# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class IPAddress(DictMixin):
    r"""IPAddress represents a single IP of a single IP Family. The object is designed
      to be used by APIs that operate on IP addresses. The object is used by the
      Service core API for allocation of IP addresses. An IP address can be
      represented in different formats, to guarantee the uniqueness of the IP, the
      name of the object is the IP address in canonical format, four decimal digits
      separated by dots suppressing leading zeros for IPv4 and the representation
      defined by RFC 5952 for IPv6. Valid: 192.168.1.5 or 2001:db8::1 or
      2001:db8:aaaa:bbbb:cccc:dddd:eeee:1 Invalid: 10.01.2.3 or 2001:db8:0:0:0::1

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[IPAddressSpec]`` - spec is the desired state of the IPAddress. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[IPAddressSpec]' = None

    def __post_init__(self):
        self.apiVersion = 'networking.k8s.io/v1beta1'
        self.kind = 'IPAddress'


@dataclass
class IPAddressList(DictMixin):
    r"""IPAddressList contains a list of IPAddress.

      **parameters**

      * **items** ``List[IPAddress]`` - items is the list of IPAddresses.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[IPAddress]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'networking.k8s.io/v1beta1'
        self.kind = 'IPAddressList'


@dataclass
class IPAddressSpec(DictMixin):
    r"""IPAddressSpec describe the attributes in an IP Address.

      **parameters**

      * **parentRef** ``ParentReference`` - ParentRef references the resource that an IPAddress is attached to. An
        IPAddress must reference a parent object.
    """
    parentRef: 'ParentReference'


@dataclass
class ParentReference(DictMixin):
    r"""ParentReference describes a reference to a parent object.

      **parameters**

      * **name** ``str`` - Name is the name of the object being referenced.
      * **resource** ``str`` - Resource is the resource of the object being referenced.
      * **group** ``Optional[str]`` - Group is the group of the object being referenced.
      * **namespace** ``Optional[str]`` - Namespace is the namespace of the object being referenced.
    """
    name: 'str'
    resource: 'str'
    group: 'Optional[str]' = None
    namespace: 'Optional[str]' = None


@dataclass
class ServiceCIDR(DictMixin):
    r"""ServiceCIDR defines a range of IP addresses using CIDR format (e.g.
      192.168.0.0/24 or 2001:db2::/64). This range is used to allocate ClusterIPs to
      Service objects.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[ServiceCIDRSpec]`` - spec is the desired state of the ServiceCIDR. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
      * **status** ``Optional[ServiceCIDRStatus]`` - status represents the current state of the ServiceCIDR. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[ServiceCIDRSpec]' = None
    status: 'Optional[ServiceCIDRStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'networking.k8s.io/v1beta1'
        self.kind = 'ServiceCIDR'


@dataclass
class ServiceCIDRList(DictMixin):
    r"""ServiceCIDRList contains a list of ServiceCIDR objects.

      **parameters**

      * **items** ``List[ServiceCIDR]`` - items is the list of ServiceCIDRs.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[ServiceCIDR]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'networking.k8s.io/v1beta1'
        self.kind = 'ServiceCIDRList'


@dataclass
class ServiceCIDRSpec(DictMixin):
    r"""ServiceCIDRSpec define the CIDRs the user wants to use for allocating
      ClusterIPs for Services.

      **parameters**

      * **cidrs** ``Optional[List[str]]`` - CIDRs defines the IP blocks in CIDR notation (e.g. "192.168.0.0/24" or
        "2001:db8::/64") from which to assign service cluster IPs. Max of two CIDRs is
        allowed, one of each IP family. This field is immutable.
    """
    cidrs: 'Optional[List[str]]' = None


@dataclass
class ServiceCIDRStatus(DictMixin):
    r"""ServiceCIDRStatus describes the current state of the ServiceCIDR.

      **parameters**

      * **conditions** ``Optional[List[meta_v1.Condition]]`` - conditions holds an array of metav1.Condition that describe the state of the
        ServiceCIDR. Current service state
    """
    conditions: 'Optional[List[meta_v1.Condition]]' = None


