# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import core_v1


@dataclass
class Endpoint(DictMixin):
    r"""Endpoint represents a single logical "backend" implementing a service.

      **parameters**

      * **addresses** ``List[str]`` - addresses of this endpoint. For EndpointSlices of addressType "IPv4" or
        "IPv6", the values are IP addresses in canonical form. The syntax and
        semantics of other addressType values are not defined. This must contain at
        least one address but no more than 100. EndpointSlices generated by the
        EndpointSlice controller will always have exactly 1 address. No semantics are
        defined for additional addresses beyond the first, and kube-proxy does not
        look at them.
      * **conditions** ``Optional[EndpointConditions]`` - conditions contains information about the current status of the endpoint.
      * **deprecatedTopology** ``Optional[dict]`` - deprecatedTopology contains topology information part of the v1beta1 API. This
        field is deprecated, and will be removed when the v1beta1 API is removed (no
        sooner than kubernetes v1.24).  While this field can hold values, it is not
        writable through the v1 API, and any attempts to write to it will be silently
        ignored. Topology information can be found in the zone and nodeName fields
        instead.
      * **hints** ``Optional[EndpointHints]`` - hints contains information associated with how an endpoint should be consumed.
      * **hostname** ``Optional[str]`` - hostname of this endpoint. This field may be used by consumers of endpoints to
        distinguish endpoints from each other (e.g. in DNS names). Multiple endpoints
        which use the same hostname should be considered fungible (e.g. multiple A
        values in DNS). Must be lowercase and pass DNS Label (RFC 1123) validation.
      * **nodeName** ``Optional[str]`` - nodeName represents the name of the Node hosting this endpoint. This can be
        used to determine endpoints local to a Node.
      * **targetRef** ``Optional[core_v1.ObjectReference]`` - targetRef is a reference to a Kubernetes object that represents this endpoint.
      * **zone** ``Optional[str]`` - zone is the name of the Zone this endpoint exists in.
    """
    addresses: 'List[str]'
    conditions: 'Optional[EndpointConditions]' = None
    deprecatedTopology: 'Optional[dict]' = None
    hints: 'Optional[EndpointHints]' = None
    hostname: 'Optional[str]' = None
    nodeName: 'Optional[str]' = None
    targetRef: 'Optional[core_v1.ObjectReference]' = None
    zone: 'Optional[str]' = None


@dataclass
class EndpointConditions(DictMixin):
    r"""EndpointConditions represents the current condition of an endpoint.

      **parameters**

      * **ready** ``Optional[bool]`` - ready indicates that this endpoint is ready to receive traffic, according to
        whatever system is managing the endpoint. A nil value should be interpreted as
        "true". In general, an endpoint should be marked ready if it is serving and
        not terminating, though this can be overridden in some cases, such as when the
        associated Service has set the publishNotReadyAddresses flag.
      * **serving** ``Optional[bool]`` - serving indicates that this endpoint is able to receive traffic, according to
        whatever system is managing the endpoint. For endpoints backed by pods, the
        EndpointSlice controller will mark the endpoint as serving if the pod's Ready
        condition is True. A nil value should be interpreted as "true".
      * **terminating** ``Optional[bool]`` - terminating indicates that this endpoint is terminating. A nil value should be
        interpreted as "false".
    """
    ready: 'Optional[bool]' = None
    serving: 'Optional[bool]' = None
    terminating: 'Optional[bool]' = None


@dataclass
class EndpointHints(DictMixin):
    r"""EndpointHints provides hints describing how an endpoint should be consumed.

      **parameters**

      * **forNodes** ``Optional[List[ForNode]]`` - forNodes indicates the node(s) this endpoint should be consumed by when using
        topology aware routing. May contain a maximum of 8 entries. This is an Alpha
        feature and is only used when the PreferSameTrafficDistribution feature gate
        is enabled.
      * **forZones** ``Optional[List[ForZone]]`` - forZones indicates the zone(s) this endpoint should be consumed by when using
        topology aware routing. May contain a maximum of 8 entries.
    """
    forNodes: 'Optional[List[ForNode]]' = None
    forZones: 'Optional[List[ForZone]]' = None


@dataclass
class EndpointPort(DictMixin):
    r"""EndpointPort represents a Port used by an EndpointSlice

      **parameters**

      * **appProtocol** ``Optional[str]`` - The application protocol for this port. This is used as a hint for
        implementations to offer richer behavior for protocols that they understand.
        This field follows standard Kubernetes label syntax. Valid values are either:
        * Un-prefixed protocol names - reserved for IANA standard service names (as
        per RFC-6335 and https://www.iana.org/assignments/service-names).
        * Kubernetes-defined prefixed names:
          * 'kubernetes.io/h2c' - HTTP/2 prior knowledge over cleartext as described
        in
        https://www.rfc-editor.org/rfc/rfc9113.html#name-starting-http-2-with-prior-
          * 'kubernetes.io/ws'  - WebSocket over cleartext as described in
        https://www.rfc-editor.org/rfc/rfc6455
          * 'kubernetes.io/wss' - WebSocket over TLS as described in
        https://www.rfc-editor.org/rfc/rfc6455
        * Other protocols should use implementation-defined prefixed names such as
        mycompany.com/my-custom-protocol.
      * **name** ``Optional[str]`` - name represents the name of this port. All ports in an EndpointSlice must have
        a unique name. If the EndpointSlice is derived from a Kubernetes service, this
        corresponds to the Service.ports[].name. Name must either be an empty string
        or pass DNS_LABEL validation: * must be no more than 63 characters long. *
        must consist of lower case alphanumeric characters or '-'. * must start and
        end with an alphanumeric character. Default is empty string.
      * **port** ``Optional[int]`` - port represents the port number of the endpoint. If the EndpointSlice is
        derived from a Kubernetes service, this must be set to the service's target
        port. EndpointSlices used for other purposes may have a nil port.
      * **protocol** ``Optional[str]`` - protocol represents the IP protocol for this port. Must be UDP, TCP, or SCTP.
        Default is TCP.
    """
    appProtocol: 'Optional[str]' = None
    name: 'Optional[str]' = None
    port: 'Optional[int]' = None
    protocol: 'Optional[str]' = None


@dataclass
class EndpointSlice(DictMixin):
    r"""EndpointSlice represents a set of service endpoints. Most EndpointSlices are
      created by the EndpointSlice controller to represent the Pods selected by
      Service objects. For a given service there may be multiple EndpointSlice
      objects which must be joined to produce the full set of endpoints; you can
      find all of the slices for a given service by listing EndpointSlices in the
      service's namespace whose `kubernetes.io/service-name` label contains the
      service's name.

      **parameters**

      * **addressType** ``str`` - addressType specifies the type of address carried by this EndpointSlice. All
        addresses in this slice must be the same type. This field is immutable after
        creation. The following address types are currently supported: * IPv4:
        Represents an IPv4 Address. * IPv6: Represents an IPv6 Address. * FQDN:
        Represents a Fully Qualified Domain Name. (Deprecated) The EndpointSlice
        controller only generates, and kube-proxy only processes, slices of
        addressType "IPv4" and "IPv6". No semantics are defined for the "FQDN" type.
      * **endpoints** ``List[Endpoint]`` - endpoints is a list of unique endpoints in this slice. Each slice may include
        a maximum of 1000 endpoints.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata.
      * **ports** ``Optional[List[EndpointPort]]`` - ports specifies the list of network ports exposed by each endpoint in this
        slice. Each port must have a unique name. Each slice may include a maximum of
        100 ports. Services always have at least 1 port, so EndpointSlices generated
        by the EndpointSlice controller will likewise always have at least 1 port.
        EndpointSlices used for other purposes may have an empty ports list.
    """
    addressType: 'str'
    endpoints: 'List[Endpoint]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    ports: 'Optional[List[EndpointPort]]' = None

    def __post_init__(self):
        self.apiVersion = 'discovery.k8s.io/v1'
        self.kind = 'EndpointSlice'


@dataclass
class EndpointSliceList(DictMixin):
    r"""EndpointSliceList represents a list of endpoint slices

      **parameters**

      * **items** ``List[EndpointSlice]`` - items is the list of endpoint slices
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata.
    """
    items: 'List[EndpointSlice]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'discovery.k8s.io/v1'
        self.kind = 'EndpointSliceList'


@dataclass
class ForNode(DictMixin):
    r"""ForNode provides information about which nodes should consume this endpoint.

      **parameters**

      * **name** ``str`` - name represents the name of the node.
    """
    name: 'str'


@dataclass
class ForZone(DictMixin):
    r"""ForZone provides information about which zones should consume this endpoint.

      **parameters**

      * **name** ``str`` - name represents the name of the zone.
    """
    name: 'str'


