# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class LeaseCandidate(DictMixin):
    r"""LeaseCandidate defines a candidate for a Lease object. Candidates are created
      such that coordinated leader election will pick the best leader from the list
      of candidates.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[LeaseCandidateSpec]`` - spec contains the specification of the Lease. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[LeaseCandidateSpec]' = None

    def __post_init__(self):
        self.apiVersion = 'coordination.k8s.io/v1beta1'
        self.kind = 'LeaseCandidate'


@dataclass
class LeaseCandidateList(DictMixin):
    r"""LeaseCandidateList is a list of Lease objects.

      **parameters**

      * **items** ``List[LeaseCandidate]`` - items is a list of schema objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[LeaseCandidate]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'coordination.k8s.io/v1beta1'
        self.kind = 'LeaseCandidateList'


@dataclass
class LeaseCandidateSpec(DictMixin):
    r"""LeaseCandidateSpec is a specification of a Lease.

      **parameters**

      * **binaryVersion** ``str`` - BinaryVersion is the binary version. It must be in a semver format without
        leading `v`. This field is required.
      * **leaseName** ``str`` - LeaseName is the name of the lease for which this candidate is contending. The
        limits on this field are the same as on Lease.name. Multiple lease candidates
        may reference the same Lease.name. This field is immutable.
      * **strategy** ``str`` - Strategy is the strategy that coordinated leader election will use for picking
        the leader. If multiple candidates for the same Lease return different
        strategies, the strategy provided by the candidate with the latest
        BinaryVersion will be used. If there is still conflict, this is a user error
        and coordinated leader election will not operate the Lease until resolved.
      * **emulationVersion** ``Optional[str]`` - EmulationVersion is the emulation version. It must be in a semver format
        without leading `v`. EmulationVersion must be less than or equal to
        BinaryVersion. This field is required when strategy is
        "OldestEmulationVersion"
      * **pingTime** ``Optional[meta_v1.MicroTime]`` - PingTime is the last time that the server has requested the LeaseCandidate to
        renew. It is only done during leader election to check if any LeaseCandidates
        have become ineligible. When PingTime is updated, the LeaseCandidate will
        respond by updating RenewTime.
      * **renewTime** ``Optional[meta_v1.MicroTime]`` - RenewTime is the time that the LeaseCandidate was last updated. Any time a
        Lease needs to do leader election, the PingTime field is updated to signal to
        the LeaseCandidate that they should update the RenewTime. Old LeaseCandidate
        objects are also garbage collected if it has been hours since the last renew.
        The PingTime field is updated regularly to prevent garbage collection for
        still active LeaseCandidates.
    """
    binaryVersion: 'str'
    leaseName: 'str'
    strategy: 'str'
    emulationVersion: 'Optional[str]' = None
    pingTime: 'Optional[meta_v1.MicroTime]' = None
    renewTime: 'Optional[meta_v1.MicroTime]' = None


