# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class FieldSelectorAttributes(DictMixin):
    r"""FieldSelectorAttributes indicates a field limited access. Webhook authors are
      encouraged to * ensure rawSelector and requirements are not both set *
      consider the requirements field if set * not try to parse or consider the
      rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting
      different systems to agree on how exactly to parse a query is not something we
      want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack
      for more details. For the *SubjectAccessReview endpoints of the
      kube-apiserver: * If rawSelector is empty and requirements are empty, the
      request is not limited. * If rawSelector is present and requirements are
      empty, the rawSelector will be parsed and limited if the parsing succeeds. *
      If rawSelector is empty and requirements are present, the requirements should
      be honored * If rawSelector is present and requirements are present, the
      request is invalid.

      **parameters**

      * **rawSelector** ``Optional[str]`` - rawSelector is the serialization of a field selector that would be included in
        a query parameter. Webhook implementations are encouraged to ignore
        rawSelector. The kube-apiserver's *SubjectAccessReview will parse the
        rawSelector as long as the requirements are not present.
      * **requirements** ``Optional[List[meta_v1.FieldSelectorRequirement]]`` - requirements is the parsed interpretation of a field selector. All
        requirements must be met for a resource instance to match the selector.
        Webhook implementations should handle requirements, but how to handle them is
        up to the webhook. Since requirements can only limit the request, it is safe
        to authorize as unlimited request if the requirements are not understood.
    """
    rawSelector: 'Optional[str]' = None
    requirements: 'Optional[List[meta_v1.FieldSelectorRequirement]]' = None


@dataclass
class LabelSelectorAttributes(DictMixin):
    r"""LabelSelectorAttributes indicates a label limited access. Webhook authors are
      encouraged to * ensure rawSelector and requirements are not both set *
      consider the requirements field if set * not try to parse or consider the
      rawSelector field if set. This is to avoid another CVE-2022-2880 (i.e. getting
      different systems to agree on how exactly to parse a query is not something we
      want), see https://www.oxeye.io/resources/golang-parameter-smuggling-attack
      for more details. For the *SubjectAccessReview endpoints of the
      kube-apiserver: * If rawSelector is empty and requirements are empty, the
      request is not limited. * If rawSelector is present and requirements are
      empty, the rawSelector will be parsed and limited if the parsing succeeds. *
      If rawSelector is empty and requirements are present, the requirements should
      be honored * If rawSelector is present and requirements are present, the
      request is invalid.

      **parameters**

      * **rawSelector** ``Optional[str]`` - rawSelector is the serialization of a field selector that would be included in
        a query parameter. Webhook implementations are encouraged to ignore
        rawSelector. The kube-apiserver's *SubjectAccessReview will parse the
        rawSelector as long as the requirements are not present.
      * **requirements** ``Optional[List[meta_v1.LabelSelectorRequirement]]`` - requirements is the parsed interpretation of a label selector. All
        requirements must be met for a resource instance to match the selector.
        Webhook implementations should handle requirements, but how to handle them is
        up to the webhook. Since requirements can only limit the request, it is safe
        to authorize as unlimited request if the requirements are not understood.
    """
    rawSelector: 'Optional[str]' = None
    requirements: 'Optional[List[meta_v1.LabelSelectorRequirement]]' = None


@dataclass
class LocalSubjectAccessReview(DictMixin):
    r"""LocalSubjectAccessReview checks whether or not a user or group can perform an
      action in a given namespace. Having a namespace scoped resource makes it much
      easier to grant namespace scoped policy that includes permissions checking.

      **parameters**

      * **spec** ``SubjectAccessReviewSpec`` - Spec holds information about the request being evaluated.  spec.namespace must
        be equal to the namespace you made the request against.  If empty, it is
        defaulted.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[SubjectAccessReviewStatus]`` - Status is filled in by the server and indicates whether the request is allowed
        or not
    """
    spec: 'SubjectAccessReviewSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[SubjectAccessReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authorization.k8s.io/v1'
        self.kind = 'LocalSubjectAccessReview'


@dataclass
class NonResourceAttributes(DictMixin):
    r"""NonResourceAttributes includes the authorization attributes available for
      non-resource requests to the Authorizer interface

      **parameters**

      * **path** ``Optional[str]`` - Path is the URL path of the request
      * **verb** ``Optional[str]`` - Verb is the standard HTTP verb
    """
    path: 'Optional[str]' = None
    verb: 'Optional[str]' = None


@dataclass
class NonResourceRule(DictMixin):
    r"""NonResourceRule holds information that describes a rule for the non-resource

      **parameters**

      * **verbs** ``List[str]`` - Verb is a list of kubernetes non-resource API verbs, like: get, post, put,
        delete, patch, head, options.  "*" means all.
      * **nonResourceURLs** ``Optional[List[str]]`` - NonResourceURLs is a set of partial urls that a user should have access to.
        *s are allowed, but only as the full, final step in the path.  "*" means all.
    """
    verbs: 'List[str]'
    nonResourceURLs: 'Optional[List[str]]' = None


@dataclass
class ResourceAttributes(DictMixin):
    r"""ResourceAttributes includes the authorization attributes available for
      resource requests to the Authorizer interface

      **parameters**

      * **fieldSelector** ``Optional[FieldSelectorAttributes]`` - fieldSelector describes the limitation on access based on field.  It can only
        limit access, not broaden it.
        This field  is alpha-level. To use this field, you must enable the
        `AuthorizeWithSelectors` feature gate (disabled by default).
      * **group** ``Optional[str]`` - Group is the API Group of the Resource.  "*" means all.
      * **labelSelector** ``Optional[LabelSelectorAttributes]`` - labelSelector describes the limitation on access based on labels.  It can only
        limit access, not broaden it.
        This field  is alpha-level. To use this field, you must enable the
        `AuthorizeWithSelectors` feature gate (disabled by default).
      * **name** ``Optional[str]`` - Name is the name of the resource being requested for a "get" or deleted for a
        "delete". "" (empty) means all.
      * **namespace** ``Optional[str]`` - Namespace is the namespace of the action being requested.  Currently, there is
        no distinction between no namespace and all namespaces "" (empty) is defaulted
        for LocalSubjectAccessReviews "" (empty) is empty for cluster-scoped resources
        "" (empty) means "all" for namespace scoped resources from a
        SubjectAccessReview or SelfSubjectAccessReview
      * **resource** ``Optional[str]`` - Resource is one of the existing resource types.  "*" means all.
      * **subresource** ``Optional[str]`` - Subresource is one of the existing resource types.  "" means none.
      * **verb** ``Optional[str]`` - Verb is a kubernetes resource API verb, like: get, list, watch, create,
        update, delete, proxy.  "*" means all.
      * **version** ``Optional[str]`` - Version is the API Version of the Resource.  "*" means all.
    """
    fieldSelector: 'Optional[FieldSelectorAttributes]' = None
    group: 'Optional[str]' = None
    labelSelector: 'Optional[LabelSelectorAttributes]' = None
    name: 'Optional[str]' = None
    namespace: 'Optional[str]' = None
    resource: 'Optional[str]' = None
    subresource: 'Optional[str]' = None
    verb: 'Optional[str]' = None
    version: 'Optional[str]' = None


@dataclass
class ResourceRule(DictMixin):
    r"""ResourceRule is the list of actions the subject is allowed to perform on
      resources. The list ordering isn't significant, may contain duplicates, and
      possibly be incomplete.

      **parameters**

      * **verbs** ``List[str]`` - Verb is a list of kubernetes resource API verbs, like: get, list, watch,
        create, update, delete, proxy.  "*" means all.
      * **apiGroups** ``Optional[List[str]]`` - APIGroups is the name of the APIGroup that contains the resources.  If
        multiple API groups are specified, any action requested against one of the
        enumerated resources in any API group will be allowed.  "*" means all.
      * **resourceNames** ``Optional[List[str]]`` - ResourceNames is an optional white list of names that the rule applies to.  An
        empty set means that everything is allowed.  "*" means all.
      * **resources** ``Optional[List[str]]`` - Resources is a list of resources this rule applies to.  "*" means all in the
        specified apiGroups.
         "*/foo" represents the subresource 'foo' for all resources in the specified
        apiGroups.
    """
    verbs: 'List[str]'
    apiGroups: 'Optional[List[str]]' = None
    resourceNames: 'Optional[List[str]]' = None
    resources: 'Optional[List[str]]' = None


@dataclass
class SelfSubjectAccessReview(DictMixin):
    r"""SelfSubjectAccessReview checks whether or the current user can perform an
      action.  Not filling in a spec.namespace means "in all namespaces".  Self is a
      special case, because users should always be able to check whether they can
      perform an action

      **parameters**

      * **spec** ``SelfSubjectAccessReviewSpec`` - Spec holds information about the request being evaluated.  user and groups
        must be empty
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[SubjectAccessReviewStatus]`` - Status is filled in by the server and indicates whether the request is allowed
        or not
    """
    spec: 'SelfSubjectAccessReviewSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[SubjectAccessReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authorization.k8s.io/v1'
        self.kind = 'SelfSubjectAccessReview'


@dataclass
class SelfSubjectAccessReviewSpec(DictMixin):
    r"""SelfSubjectAccessReviewSpec is a description of the access request.  Exactly
      one of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes
      must be set

      **parameters**

      * **nonResourceAttributes** ``Optional[NonResourceAttributes]`` - NonResourceAttributes describes information for a non-resource access request
      * **resourceAttributes** ``Optional[ResourceAttributes]`` - ResourceAuthorizationAttributes describes information for a resource access
        request
    """
    nonResourceAttributes: 'Optional[NonResourceAttributes]' = None
    resourceAttributes: 'Optional[ResourceAttributes]' = None


@dataclass
class SelfSubjectRulesReview(DictMixin):
    r"""SelfSubjectRulesReview enumerates the set of actions the current user can
      perform within a namespace. The returned list of actions may be incomplete
      depending on the server's authorization mode, and any errors experienced
      during the evaluation. SelfSubjectRulesReview should be used by UIs to
      show/hide actions, or to quickly let an end user reason about their
      permissions. It should NOT Be used by external systems to drive authorization
      decisions as this raises confused deputy, cache lifetime/revocation, and
      correctness concerns. SubjectAccessReview, and LocalAccessReview are the
      correct way to defer authorization decisions to the API server.

      **parameters**

      * **spec** ``SelfSubjectRulesReviewSpec`` - Spec holds information about the request being evaluated.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[SubjectRulesReviewStatus]`` - Status is filled in by the server and indicates the set of actions a user can
        perform.
    """
    spec: 'SelfSubjectRulesReviewSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[SubjectRulesReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authorization.k8s.io/v1'
        self.kind = 'SelfSubjectRulesReview'


@dataclass
class SelfSubjectRulesReviewSpec(DictMixin):
    r"""SelfSubjectRulesReviewSpec defines the specification for
      SelfSubjectRulesReview.

      **parameters**

      * **namespace** ``Optional[str]`` - Namespace to evaluate rules for. Required.
    """
    namespace: 'Optional[str]' = None


@dataclass
class SubjectAccessReview(DictMixin):
    r"""SubjectAccessReview checks whether or not a user or group can perform an
      action.

      **parameters**

      * **spec** ``SubjectAccessReviewSpec`` - Spec holds information about the request being evaluated
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard list metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[SubjectAccessReviewStatus]`` - Status is filled in by the server and indicates whether the request is allowed
        or not
    """
    spec: 'SubjectAccessReviewSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[SubjectAccessReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authorization.k8s.io/v1'
        self.kind = 'SubjectAccessReview'


@dataclass
class SubjectAccessReviewSpec(DictMixin):
    r"""SubjectAccessReviewSpec is a description of the access request.  Exactly one
      of ResourceAuthorizationAttributes and NonResourceAuthorizationAttributes must
      be set

      **parameters**

      * **extra** ``Optional[dict]`` - Extra corresponds to the user.Info.GetExtra() method from the authenticator.
        Since that is input to the authorizer it needs a reflection here.
      * **groups** ``Optional[List[str]]`` - Groups is the groups you're testing for.
      * **nonResourceAttributes** ``Optional[NonResourceAttributes]`` - NonResourceAttributes describes information for a non-resource access request
      * **resourceAttributes** ``Optional[ResourceAttributes]`` - ResourceAuthorizationAttributes describes information for a resource access
        request
      * **uid** ``Optional[str]`` - UID information about the requesting user.
      * **user** ``Optional[str]`` - User is the user you're testing for. If you specify "User" but not "Groups",
        then is it interpreted as "What if User were not a member of any groups
    """
    extra: 'Optional[dict]' = None
    groups: 'Optional[List[str]]' = None
    nonResourceAttributes: 'Optional[NonResourceAttributes]' = None
    resourceAttributes: 'Optional[ResourceAttributes]' = None
    uid: 'Optional[str]' = None
    user: 'Optional[str]' = None


@dataclass
class SubjectAccessReviewStatus(DictMixin):
    r"""SubjectAccessReviewStatus

      **parameters**

      * **allowed** ``bool`` - Allowed is required. True if the action would be allowed, false otherwise.
      * **denied** ``Optional[bool]`` - Denied is optional. True if the action would be denied, otherwise false. If
        both allowed is false and denied is false, then the authorizer has no opinion
        on whether to authorize the action. Denied may not be true if Allowed is true.
      * **evaluationError** ``Optional[str]`` - EvaluationError is an indication that some error occurred during the
        authorization check. It is entirely possible to get an error and be able to
        continue determine authorization status in spite of it. For instance, RBAC can
        be missing a role, but enough roles are still present and bound to reason
        about the request.
      * **reason** ``Optional[str]`` - Reason is optional.  It indicates why a request was allowed or denied.
    """
    allowed: 'bool'
    denied: 'Optional[bool]' = None
    evaluationError: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class SubjectRulesReviewStatus(DictMixin):
    r"""SubjectRulesReviewStatus contains the result of a rules check. This check can
      be incomplete depending on the set of authorizers the server is configured
      with and any errors experienced during evaluation. Because authorization rules
      are additive, if a rule appears in a list it's safe to assume the subject has
      that permission, even if that list is incomplete.

      **parameters**

      * **incomplete** ``bool`` - Incomplete is true when the rules returned by this call are incomplete. This
        is most commonly encountered when an authorizer, such as an external
        authorizer, doesn't support rules evaluation.
      * **nonResourceRules** ``List[NonResourceRule]`` - NonResourceRules is the list of actions the subject is allowed to perform on
        non-resources. The list ordering isn't significant, may contain duplicates,
        and possibly be incomplete.
      * **resourceRules** ``List[ResourceRule]`` - ResourceRules is the list of actions the subject is allowed to perform on
        resources. The list ordering isn't significant, may contain duplicates, and
        possibly be incomplete.
      * **evaluationError** ``Optional[str]`` - EvaluationError can appear in combination with Rules. It indicates an error
        occurred during rule evaluation, such as an authorizer that doesn't support
        rule evaluation, and that ResourceRules and/or NonResourceRules may be
        incomplete.
    """
    incomplete: 'bool'
    nonResourceRules: 'List[NonResourceRule]'
    resourceRules: 'List[ResourceRule]'
    evaluationError: 'Optional[str]' = None


