# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class BoundObjectReference(DictMixin):
    r"""BoundObjectReference is a reference to an object that a token is bound to.

      **parameters**

      * **apiVersion** ``Optional[str]`` - API version of the referent.
      * **kind** ``Optional[str]`` - Kind of the referent. Valid kinds are 'Pod' and 'Secret'.
      * **name** ``Optional[str]`` - Name of the referent.
      * **uid** ``Optional[str]`` - UID of the referent.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    name: 'Optional[str]' = None
    uid: 'Optional[str]' = None


@dataclass
class SelfSubjectReview(DictMixin):
    r"""SelfSubjectReview contains the user information that the kube-apiserver has
      about the user making this request. When using impersonation, users will
      receive the user info of the user being impersonated.  If impersonation or
      request header authentication is used, any extra keys will have their case
      ignored and returned as lowercase.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[SelfSubjectReviewStatus]`` - Status is filled in by the server with the user attributes.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[SelfSubjectReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authentication.k8s.io/v1'
        self.kind = 'SelfSubjectReview'


@dataclass
class SelfSubjectReviewStatus(DictMixin):
    r"""SelfSubjectReviewStatus is filled by the kube-apiserver and sent back to a
      user.

      **parameters**

      * **userInfo** ``Optional[UserInfo]`` - User attributes of the user making this request.
    """
    userInfo: 'Optional[UserInfo]' = None


@dataclass
class TokenRequest(DictMixin):
    r"""TokenRequest requests a token for a given service account.

      **parameters**

      * **spec** ``TokenRequestSpec`` - Spec holds information about the request being evaluated
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[TokenRequestStatus]`` - Status is filled in by the server and indicates whether the token can be
        authenticated.
    """
    spec: 'TokenRequestSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[TokenRequestStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authentication.k8s.io/v1'
        self.kind = 'TokenRequest'


@dataclass
class TokenRequestSpec(DictMixin):
    r"""TokenRequestSpec contains client provided parameters of a token request.

      **parameters**

      * **audiences** ``List[str]`` - Audiences are the intendend audiences of the token. A recipient of a token
        must identify themself with an identifier in the list of audiences of the
        token, and otherwise should reject the token. A token issued for multiple
        audiences may be used to authenticate against any of the audiences listed but
        implies a high degree of trust between the target audiences.
      * **boundObjectRef** ``Optional[BoundObjectReference]`` - BoundObjectRef is a reference to an object that the token will be bound to.
        The token will only be valid for as long as the bound object exists. NOTE: The
        API server's TokenReview endpoint will validate the BoundObjectRef, but other
        audiences may not. Keep ExpirationSeconds small if you want prompt revocation.
      * **expirationSeconds** ``Optional[int]`` - ExpirationSeconds is the requested duration of validity of the request. The
        token issuer may return a token with a different validity duration so a client
        needs to check the 'expiration' field in a response.
    """
    audiences: 'List[str]'
    boundObjectRef: 'Optional[BoundObjectReference]' = None
    expirationSeconds: 'Optional[int]' = None


@dataclass
class TokenRequestStatus(DictMixin):
    r"""TokenRequestStatus is the result of a token request.

      **parameters**

      * **expirationTimestamp** ``meta_v1.Time`` - ExpirationTimestamp is the time of expiration of the returned token.
      * **token** ``str`` - Token is the opaque bearer token.
    """
    expirationTimestamp: 'meta_v1.Time'
    token: 'str'


@dataclass
class TokenReview(DictMixin):
    r"""TokenReview attempts to authenticate a token to a known user. Note:
      TokenReview requests may be cached by the webhook token authenticator plugin
      in the kube-apiserver.

      **parameters**

      * **spec** ``TokenReviewSpec`` - Spec holds information about the request being evaluated
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[TokenReviewStatus]`` - Status is filled in by the server and indicates whether the request can be
        authenticated.
    """
    spec: 'TokenReviewSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[TokenReviewStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'authentication.k8s.io/v1'
        self.kind = 'TokenReview'


@dataclass
class TokenReviewSpec(DictMixin):
    r"""TokenReviewSpec is a description of the token authentication request.

      **parameters**

      * **audiences** ``Optional[List[str]]`` - Audiences is a list of the identifiers that the resource server presented with
        the token identifies as. Audience-aware token authenticators will verify that
        the token was intended for at least one of the audiences in this list. If no
        audiences are provided, the audience will default to the audience of the
        Kubernetes apiserver.
      * **token** ``Optional[str]`` - Token is the opaque bearer token.
    """
    audiences: 'Optional[List[str]]' = None
    token: 'Optional[str]' = None


@dataclass
class TokenReviewStatus(DictMixin):
    r"""TokenReviewStatus is the result of the token authentication request.

      **parameters**

      * **audiences** ``Optional[List[str]]`` - Audiences are audience identifiers chosen by the authenticator that are
        compatible with both the TokenReview and token. An identifier is any
        identifier in the intersection of the TokenReviewSpec audiences and the
        token's audiences. A client of the TokenReview API that sets the
        spec.audiences field should validate that a compatible audience identifier is
        returned in the status.audiences field to ensure that the TokenReview server
        is audience aware. If a TokenReview returns an empty status.audience field
        where status.authenticated is "true", the token is valid against the audience
        of the Kubernetes API server.
      * **authenticated** ``Optional[bool]`` - Authenticated indicates that the token was associated with a known user.
      * **error** ``Optional[str]`` - Error indicates that the token couldn't be checked
      * **user** ``Optional[UserInfo]`` - User is the UserInfo associated with the provided token.
    """
    audiences: 'Optional[List[str]]' = None
    authenticated: 'Optional[bool]' = None
    error: 'Optional[str]' = None
    user: 'Optional[UserInfo]' = None


@dataclass
class UserInfo(DictMixin):
    r"""UserInfo holds the information about the user needed to implement the
      user.Info interface.

      **parameters**

      * **extra** ``Optional[dict]`` - Any additional information provided by the authenticator.
      * **groups** ``Optional[List[str]]`` - The names of groups this user is a part of.
      * **uid** ``Optional[str]`` - A unique value that identifies this user across time. If this user is deleted
        and another user by the same name is added, they will have different UIDs.
      * **username** ``Optional[str]`` - The name that uniquely identifies this user among all active users.
    """
    extra: 'Optional[dict]' = None
    groups: 'Optional[List[str]]' = None
    uid: 'Optional[str]' = None
    username: 'Optional[str]' = None


