"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubernetesPatch = exports.PatchType = void 0;
const core_1 = require("@aws-cdk/core");
const kubectl_provider_1 = require("./kubectl-provider");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_2 = require("@aws-cdk/core");
/**
 * (experimental) Values for `kubectl patch` --type argument.
 *
 * @experimental
 */
var PatchType;
(function (PatchType) {
    PatchType["JSON"] = "json";
    PatchType["MERGE"] = "merge";
    PatchType["STRATEGIC"] = "strategic";
})(PatchType = exports.PatchType || (exports.PatchType = {}));
/**
 * (experimental) A CloudFormation resource which applies/restores a JSON patch into a Kubernetes resource.
 *
 * @see https://kubernetes.io/docs/tasks/run-application/update-api-object-kubectl-patch/
 * @experimental
 */
class KubernetesPatch extends core_2.Construct {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _a, _b;
        super(scope, id);
        const stack = core_1.Stack.of(this);
        const provider = kubectl_provider_1.KubectlProvider.getOrCreate(this, props.cluster);
        new core_1.CustomResource(this, 'Resource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::AWSCDK-EKS-KubernetesPatch',
            properties: {
                ResourceName: props.resourceName,
                ResourceNamespace: (_a = props.resourceNamespace) !== null && _a !== void 0 ? _a : 'default',
                ApplyPatchJson: stack.toJsonString(props.applyPatch),
                RestorePatchJson: stack.toJsonString(props.restorePatch),
                ClusterName: props.cluster.clusterName,
                RoleArn: provider.roleArn,
                PatchType: (_b = props.patchType) !== null && _b !== void 0 ? _b : PatchType.STRATEGIC,
            },
        });
    }
}
exports.KubernetesPatch = KubernetesPatch;
//# sourceMappingURL=data:application/json;base64,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