class GsConstant(object):
    """
    Class object that holds global constants
    """

    COLUMN_HEADER = ["Year", "Month", "Day", "Hour", "Minute", "Second"]
    PRMS_DATA_TYPES = {
        1: "integer",
        2: "real",
        3: "double",
        4: "string",
        "4": "string",
    }
    PRMS_SECTIONS = ("Dimensions", "Parameters")
    DAY_FILE_VARIABLES = (
        "humidity_hru",
        "potet",
        "hru_ppt",
        "hru_rain",
        "hru_snow",
        "newsnow",
        "pptmix",
        "prmx",
        "swrad",
        "orad_hru",
        "clear_sky",
        "tmin_hru",
        "tmax_hru",
        "tmaxf",
        "tminf",
        "tmaxc",
        "tmax",
        "tmin",
        "precip",
        "prcp",
        "tminc",
        "tavgc",
        "tavgf",
        "transp",
        "hru_intcpevap",
        "hru_intcpstor",
        "hru_form",
        "intcp_on" "intcp_stor",
        "net_ppt",
        "net_rain",
        "net_snow",
        "albedo",
        "iso",
        "lso",
        "lst",
        "mso",
        "pk_def",
        "pk_den",
        "pk_depth",
        "pk_ice",
        "pk_precip",
        "pk_temp",
        "pkwater_ante",
        "pk_water_equiv",
        "pptmix_nopack",
        "pptmix_nopack",
        "pss",
        "pst",
        "snow_evap",
        "snow_free",
        "snowcov_area",
        "snowmelt",
        "snsv",
        "tcal",
        "fall_frost",
        "hru_actet",
        "hru_et_yr",
        "hru_frac_perv",
        "imperv_evap",
        "intcp_evap",
        "perv_actet",
        "potet_lower",
        "potet_rechr",
        "spring_frost",
        "transp_on",
        "hortonian_flow",
        "hortonian_lakes",
        "hru_hortn_cascflow",
        "hru_impervevap",
        "hru_impervstor",
        "hru_sroffi",
        "hru_sroffp",
        "imperv_stor",
        "infil",
        "infil_tot",
        "sroff",
        "upslope_hotonian",
        "dprst_area_clos",
        "dprst_area_open",
        "dprst_evap_hru",
        "dprst_frac_hru",
        "dprst_frac_perv",
        "dprst_insroff_hru",
        "dprst_seep_hru",
        "dprst_sroff_hru",
        "dprst_vol_clos",
        "dprst_vol_open",
        "cap_waterin",
        "dunnian_flow",
        "hru_sz_cascadeflow",
        "lakein_sz",
        "pref_flow",
        "pref_flow_infil",
        "pref_flow_max",
        "pref_flow_stor",
        "pref_flow_thrsh",
        "recharge",
        "slow_flow",
        "slow_stor",
        "soil_lower",
        "soil_lower_ratio",
        "soil_moist",
        "soil_moist_frac",
        "soil_moist_tot",
        "soil_rechr",
        "soil_rechr_ratio",
        "soil_to_gw",
        "soil_to_ssr",
        "soil_zone_max",
        "upslope_dunnianflow",
        "upslope_interflow",
        "wind_speed_hru",
    )
    GSFLOW_FILES = [
        "csv_output_file",
        "data_file",
        "gsflow_output_file",
        "model_output_file",
        "modflow_name",
        "param_file",
        "stat_var_file",
        "var_init_file",
        "var_save_file",
        "ani_output_file",
        "param_print_file",
        "stats_output_file",
        "nsubOutBaseFileName",
        "basinOutBaseFileName",
        "nsegmentOutBaseFileName",
        "nhruOutBaseFileName",
    ] + [f"{f}_day" for f in DAY_FILE_VARIABLES]
