try:
    import simplejson as json
except ImportError:
    import json


defaults = {
    "sfr": {
        "pkg": {
            "reachinput": True,
            "const": 86400,
            "dleak": 0.0001,
            "isfropt": 1,
            "nstrail": 10,
            "isuzn": 1,
        },
        "reach": {
            "strthick": 1.0,
            "strhc1": 1.0,
        },
        "segment": {
            "icalc": 1,
            "iprior": 0,
            "flow": 1.0,
            "runoff": 0.0,
            "etsw": 0.0,
            "pptsw": 0.0,
            "roughch": 0.025,
            "width1": 10,
            "width2": 10,
        },
    },
    "uzf": {
        "nuztop": 1,
        "iuzfopt": 1,
        "irunflg": 1,
        "ietflg": 0,
        "ntrail2": 10,
        "nsets": 20,
        "surfdep": 1.0,
        "vks": 1.0,
        "eps": 3.5,
        "thts": 0.25,
    },
    "dis": {
        "nlay": 1,
        "nper": 1,
        "itmuni": 4,
        "lenuni": 2,
        "laycbd": 0,
        "perlen": 1,
        "nstp": 1,
        "tsmult": 1.0,
        "steady": True,
    },
    "bas": {
        "hnoflo": -9999.0,
        "ifrefm": True,
    },
    "upw": {
        "ipakcb": 0,
        "hdry": -999.9,
        "iphdry": 0,
        "laytyp": 1,
        "layavg": 0,
        "chani": 1,
        "layvka": 0,
        "laywet": 0,
        "hk": 10.0,
        "vka": 1.0,
        "ss": 1e-06,
        "sy": 0.20,
    },
    "oc": {
        "ihedfm": 15,
        "stress_period_data": {
            str((0, 0)): [
                "print head",
                "print budget",
                "save head",
                "save budget",
            ]
        },
    },
    "nwt": {
        "headtol": 0.0001,
        "fluxtol": 500,
        "maxiterout": 100,
        "thickfact": 0.00001,
        "linmeth": 1,
        "iprnwt": 0,
        "ibotav": 0,
        "options": "SIMPLE",
    },
    "control": {
        "start_time": {"dtype": 1, "record": [1975, 10, 1, 0, 0, 0]},
        "rpt_days": {"dtype": 1, "record": 7},
        "cascade_flag": {"dtype": 1, "record": 1},
        "cascadegw_flag": {"dtype": 1, "record": 2},
        "et_module": {"dtype": 4, "record": "potet_jh"},
        "precip_module": {"dtype": 4, "record": "precip_1sta"},
        "snarea_curve_flag": {"dtype": 1, "record": 0},
        "soilzone_aet_flag": {"dtype": 1, "record": 0},
        "solrad_module": {"dtype": 4, "record": "ddsolrad"},
        "srunoff_module": {"dtype": 4, "record": "srunoff_smidx"},
        "subbasin_flag": {"dtype": 1, "record": 1},
        "temp_module": {"dtype": 4, "record": "temp_1sta"},
        "transp_module": {"dtype": 4, "record": "transp_tindex"},
        "parameter_check_flag": {"dtype": 1, "record": 0},
        "model_mode": {"dtype": 4, "record": "GSFLOW"},
        "csv_output_file": {"dtype": 4, "record": "gsflow.csv"},
        "gsflow_output_file": {"dtype": 4, "record": "gsflow.out"},
        "executable_desc": {"dtype": 4, "record": "GSFLOW model"},
        "executable_model": {"dtype": 4, "record": "prmsIV.exe"},
    },
    "parameter": {
        "dimensions": {
            "ndepl": 1,
            "nlake": 0,
            "nrain": 1,
            "ntemp": 1,
            "nmonths": 12,
            "one": 1,
            "ndays": 366,
        },
        "parameters": {
            "elev_units": {"dtype": 1, "dimension": "one", "record": 1},
            "precip_units": {"dtype": 1, "dimension": "one", "record": 1},
            "temp_units": {"dtype": 1, "dimension": "one", "record": 1},
            "cascade_flg": {"dtype": 1, "dimension": "one", "record": 0},
            "cascade_tol": {"dtype": 2, "dimension": "one", "record": 5.0},
            "circle_switch": {"dtype": 1, "dimension": "one", "record": 1},
            "gw_pct_up": {
                "dtype": 2,
                "dimension": "ncascdgw",
                "record": [1.0],
            },
            "hru_pct_up": {
                "dtype": 2,
                "dimension": "ncascade",
                "record": [1.0],
            },
            "adjmix_rain": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [1.0],
            },
            "ppt_zero_thresh": {"dtype": 2, "dimension": "one", "record": 0.0},
            "tmax_allsnow": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [0.0],
            },
            "ppt_rad_adj": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [0.02],
            },
            "radj_sppt": {"dtype": 2, "dimension": "nhru", "record": [0.44]},
            "radj_wppt": {"dtype": 2, "dimension": "nhru", "record": [0.5]},
            "radmax": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [0.8],
            },
            "potet_sublim": {"dtype": 2, "dimension": "nhru", "record": [0.5]},
            "rad_trncf": {"dtype": 2, "dimension": "nhru", "record": [0.5]},
            "soil_type": {"dtype": 1, "dimension": "nhru", "record": [2]},
            "cov_type": {"dtype": 1, "dimension": "nhru", "record": [3]},
            "covden_sum": {"dtype": 2, "dimension": "nhru", "record": [0.5]},
            "covden_win": {"dtype": 2, "dimension": "nhru", "record": [0.5]},
            "snow_intcp": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "srain_intcp": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "wrain_intcp": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "albset_rna": {"dtype": 2, "dimension": "one", "record": 0.8},
            "albset_rnm": {"dtype": 2, "dimension": "one", "record": 0.6},
            "albset_sna": {"dtype": 2, "dimension": "one", "record": 0.05},
            "albset_snm": {"dtype": 2, "dimension": "one", "record": 0.2},
            "cecn_coef": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [5.0],
            },
            "den_init": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "den_max": {"dtype": 2, "dimension": "nhru", "record": [0.6]},
            "emis_noppt": {"dtype": 2, "dimension": "nhru", "record": [0.757]},
            "freeh2o_cap": {"dtype": 2, "dimension": "nhru", "record": [0.05]},
            "hru_deplcrv": {"dtype": 1, "dimension": "nhru", "record": [1]},
            "melt_force": {"dtype": 1, "dimension": "nhru", "record": [140]},
            "melt_look": {"dtype": 1, "dimension": "nhru", "record": [90]},
            "settle_const": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "snarea_curve": {
                "dtype": 2,
                "dimension": "ndeplval",
                "record": [1.0],
            },
            "snarea_thresh": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [50.0],
            },
            "snowpack_init": {"dtype": 2, "dimension": "nhru", "record": [0]},
            "tstorm_mo": {
                "dtype": 1,
                "dimension": "nmonths",
                "record": [0],
            },
            "carea_max": {"dtype": 2, "dimension": "nhru", "record": [0.6]},
            "hru_percent_imperv": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "imperv_stor_max": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.05],
            },
            "snowinfil_max": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [2.0],
            },
            "fastcoef_lin": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "fastcoef_sq": {"dtype": 2, "dimension": "nhru", "record": [0.8]},
            "pref_flow_den": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "sat_threshold": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [999.0],
            },
            "slowcoef_lin": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.015],
            },
            "slowcoef_sq": {"dtype": 2, "dimension": "nhru", "record": [0.1]},
            "soil_moist_init": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [3.0],
            },
            "soil_moist_init_frac": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "soil_moist_max": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [2.0],
            },
            "soil_rechr_init": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [1.0],
            },
            "soil_rechr_init_frac": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "soil_rechr_max": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [1.5],
            },
            "soil_rechr_max_frac": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [1.0],
            },
            "soil2gw_max": {"dtype": 2, "dimension": "nhru", "record": [0.0]},
            "ssr2gw_exp": {"dtype": 2, "dimension": "nssr", "record": [1.0]},
            "ssr2gw_rate": {"dtype": 2, "dimension": "nssr", "record": [0.1]},
            "sstor_init": {"dtype": 2, "dimension": "nssr", "record": [0.0]},
            "sstor_init_frac": {
                "dtype": 2,
                "dimension": "nssr",
                "record": [0.0],
            },
            "gwflow_coef": {"dtype": 2, "dimension": "ngw", "record": [0.015]},
            "gwsink_coef": {"dtype": 2, "dimension": "ngw", "record": [0.0]},
            "gwstor_init": {"dtype": 2, "dimension": "ngw", "record": [2.0]},
            "gwstor_min": {"dtype": 2, "dimension": "ngw", "record": [0.0]},
            "print_freq": {"dtype": 1, "dimension": "one", "record": 3},
            "print_type": {"dtype": 1, "dimension": "one", "record": 1},
            # et_module
            "jh_coef_hru": {"dtype": 2, "dimension": "nhru", "record": [13.0]},
            # precip_1sta
            "hru_psta": {"dtype": 1, "dimension": "nhru", "record": [1]},
            "rain_adj": {
                "dtype": 2,
                "dimension": [["nhru", "nmonths"]],
                "record": [[1.0]] * 12,
            },
            "snow_adj": {
                "dtype": 2,
                "dimension": [["nhru", "nmonths"]],
                "record": [[1.0]] * 12,
            },
            # temp_1sta
            "basin_tsta": {"dtype": 1, "dimension": "one", "record": 1},
            "hru_tsta": {"dtype": 1, "dimension": "nhru", "record": [1]},
            "max_missing": {"dtype": 1, "dimension": "one", "record": 7},
            "tmax_adj": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "tmax_lapse": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [14.58],
            },
            "tmin_adj": {
                "dtype": 2,
                "dimension": "nhru",
                "record": [0.0],
            },
            "tmin_lapse": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [14.58],
            },
            # ddsolrad
            "radadj_intcp": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [1.0],
            },
            "radadj_slope": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [1.0],
            },
            "tmax_index": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [10.0],
            },
            "dday_intcp": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [-40.0],
            },
            "dday_slope": {
                "dtype": 2,
                "dimension": "nmonths",
                "record": [0.4],
            },
            # srunoff_smidx
            "smidx_coef": {"dtype": 2, "dimension": "nhru", "record": [0.005]},
            "smidx_exp": {"dtype": 2, "dimension": "nhru", "record": [0.3]},
            # transp_tindex
            "transp_beg": {"dtype": 1, "dimension": "nhru", "record": [3]},
            "transp_end": {"dtype": 1, "dimension": "nhru", "record": [11]},
            "transp_tmax": {"dtype": 2, "dimension": "nhru", "record": [1.0]},
            "gvr_cell_pct": {
                "dtype": 2,
                "dimension": "nhrucell",
                "record": [1.0],
            },
            "gvr_hru_pct": {
                "dtype": 2,
                "dimension": "nhrucell",
                "record": [1.0],
            },
        },
    },
}

with open("defaults.json", "w") as foo:
    json.dump(defaults, foo, sort_keys=True, indent=4 * " ")
