from typing import Any, Optional, Union, TypeVar, Iterable, Tuple
from .base import Executable as Executable, DialectKWArgs as DialectKWArgs
from .elements import ClauseElement as ClauseElement, ColumnElement, TextClause
from .selectable import HasPrefixes as HasPrefixes, HasCTE as HasCTE, TableClause, Selectable
from .schema import Table, Column
from .visitors import Visitable

_UB = TypeVar('_UB', bound=UpdateBase)

class UpdateBase(HasCTE, DialectKWArgs, HasPrefixes, Executable, ClauseElement):
    __visit_name__: str = ...
    named_with_column: bool = ...
    def params(self, *arg: Any, **kw: Any) -> Any: ...
    bind: Any = ...
    def returning(self: _UB, *cols: Union[ColumnElement[Any], Table]) -> _UB: ...
    def with_hint(self: _UB, text: str, selectable: Optional[Table] = ..., dialect_name: str = ...) -> _UB: ...

_VB = TypeVar('_VB', bound=ValuesBase)

class ValuesBase(UpdateBase):
    __visit_name__: str = ...
    select: Any = ...
    table: Union[TextClause, Selectable] = ...
    def __init__(self, table: Union[str, Selectable], values: Any, prefixes: Any) -> None: ...
    parameters: Any = ...
    def values(self: _VB, *args: Any, **kwargs: Any) -> _VB: ...
    def return_defaults(self: _VB, *cols: Any) -> _VB: ...

_I = TypeVar('_I', bound=Insert)

class Insert(ValuesBase):
    __visit_name__: str = ...
    select: Optional[Selectable] = ...
    include_insert_from_select_defaults: bool = ...
    inline: bool = ...
    select_names: Optional[Iterable[Union[str, Column[Any]]]] = ...
    def __init__(self, table: Union[str, Selectable], values: Optional[Any] = ..., inline: bool = ..., bind: Optional[Any] = ...,
                 prefixes: Optional[Any] = ..., returning: Optional[Any] = ..., return_defaults: bool = ...,
                 **dialect_kw: Any) -> None: ...
    def get_children(self, **kwargs: Any) -> Union[Tuple, Tuple[Selectable]]: ...
    def from_select(self: _I, names: Iterable[Union[str, Column[Any]]], select: Union[str, Selectable],
                    include_defaults: bool = ...) -> _I: ...

_U = TypeVar('_U', bound=Update)

class Update(ValuesBase):
    __visit_name__: str = ...
    inline: bool = ...
    def __init__(self, table: Union[str, Selectable], whereclause: Optional[Union[str, bool, Visitable]] = ...,
                 values: Optional[Any] = ..., inline: bool = ..., bind: Optional[Any] = ..., prefixes: Optional[Any] = ...,
                 returning: Optional[Any] = ..., return_defaults: bool = ..., preserve_parameter_order: bool = ...,
                 **dialect_kw: Any) -> None: ...
    def get_children(self, **kwargs: Any) -> Union[Tuple, Tuple[Visitable]]: ...
    def where(self: _U, whereclause: Union[str, bool, Visitable]) -> _U: ...

_D = TypeVar('_D', bound=Delete)

class Delete(UpdateBase):
    __visit_name__: str = ...
    table: Union[TextClause, Selectable] = ...
    def __init__(self, table: Union[str, Selectable], whereclause: Optional[Union[str, bool, Visitable]] = ...,
                 bind: Optional[Any] = ..., returning: Optional[Any] = ..., prefixes: Optional[Any] = ...,
                 **dialect_kw: Any) -> None: ...
    def get_children(self, **kwargs: Any) -> Union[Tuple, Tuple[Visitable]]: ...
    def where(self: _D, whereclause: Union[str, bool, Visitable]) -> _D: ...
