"""DailyStories Generator - A library for generating children's storybooks with Gemini AI."""

from dailystories_generator.types import UpdateType, Update
from dailystories_generator.models import (
    ReferenceImage,
    GenerationRequest,
    StoryArtifact,
    PageArtifact,
)
from dailystories_generator.generator import StoryGenerator
from dailystories_generator.image_evaluation import (
    evaluate_cover_image,
    evaluate_page_image,
    CoverImageEvaluation,
    PageImageEvaluation,
    ImageCategoryScore,
)
from dailystories_generator.image_prompt_improver import (
    suggest_cover_prompt_improvements,
    suggest_page_prompt_improvements,
)
from dailystories_generator.image_statistics_tracker import ImageStatisticsTracker

__all__ = [
    "UpdateType",
    "Update",
    "ReferenceImage",
    "GenerationRequest",
    "StoryArtifact",
    "PageArtifact",
    "StoryGenerator",
    "evaluate_cover_image",
    "evaluate_page_image",
    "CoverImageEvaluation",
    "PageImageEvaluation",
    "ImageCategoryScore",
    "suggest_cover_prompt_improvements",
    "suggest_page_prompt_improvements",
    "ImageStatisticsTracker",
]

__version__ = "0.1.0"

