#!/bin/bash
# Publish script for dailystories-generator package

set -e

# Check if $PYPI_API_TOKEN is set
if [ -z "$$PYPI_API_TOKEN" ]; then
    echo "❌ Error: $PYPI_API_TOKEN environment variable not set"
    echo "Set it with: export $PYPI_API_TOKEN='your-token-here'"
    echo ""
    echo "To get a token:"
    echo "1. Go to https://pypi.org/manage/account/token/"
    echo "2. Create a new API token"
    echo "3. Export it: export $PYPI_API_TOKEN='pypi-...'"
    exit 1
fi

# Build first
echo "🔨 Building package..."
./build.sh

# Publish to PyPI
echo ""
echo "📦 Publishing to PyPI..."
uv publish --token "$$PYPI_API_TOKEN"

echo ""
echo "✅ Published successfully to PyPI!"
echo "View at: https://pypi.org/project/dailystories-generator/"

