#
# Copyright 2021 zero323
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

import unittest
from .examples import BeliefPropagation as BeliefPropagation, Graphs as Graphs
from .graphframe import (
    GraphFrame as GraphFrame,
    Pregel as Pregel,
    _from_java_gf as _from_java_gf,
    _java_api as _java_api,
)
from graphframes._typing import ExpressionOrColumn as ExpressionOrColumn
from pyspark import SparkContext
from pyspark.sql import DataFrame, SQLContext
from typing import Any, ClassVar, Dict, List, Union
from py4j.java_gateway import JVMView as JVMView, JavaObject as JavaObject

class GraphFrameTestUtils:
    sc: ClassVar[SparkContext]
    spark_version: ClassVar[Dict[str, Union[int, str]]]
    @classmethod
    def parse_spark_version(cls, version_str: str) -> Dict[str, Union[int, str]]: ...
    @classmethod
    def register(cls, sc: SparkContext) -> None: ...
    @classmethod
    def spark_at_least_of_version(cls, version_str: str) -> bool: ...

class GraphFrameTestCase(unittest.TestCase):
    sc: ClassVar[SparkContext]
    checkpointDir: ClassVar[str]
    sql: ClassVar[SQLContext]
    @classmethod
    def setUpClass(cls) -> None: ...
    @classmethod
    def tearDownClass(cls) -> None: ...

class GraphFrameTest(GraphFrameTestCase):
    g: GraphFrame
    def setUp(self) -> None: ...
    def test_spark_version_check(self) -> None: ...
    def test_construction(self) -> None: ...
    def test_cache(self) -> None: ...
    def test_degrees(self) -> None: ...
    def test_motif_finding(self) -> None: ...
    def test_filterVertices(self) -> None: ...
    def test_filterEdges(self) -> None: ...
    def test_dropIsolatedVertices(self) -> None: ...
    def test_bfs(self) -> None: ...

class PregelTest(GraphFrameTestCase):
    def setUp(self) -> None: ...
    def test_page_rank(self) -> None: ...

class GraphFrameLibTest(GraphFrameTestCase):
    sqlContext: SQLContext
    japi: JavaObject
    def setUp(self) -> None: ...
    def _hasCols(
        self, graph: GraphFrame, vcols: List[str] = ..., ecols: List[str] = ...
    ) -> None: ...
    def _df_hasCols(self, vertices: DataFrame, vcols: List[str] = ...) -> None: ...
    def _graph(self, name: str, *args: Any) -> GraphFrame: ...
    def test_aggregate_messages(self) -> None: ...
    def test_connected_components(self) -> None: ...
    def test_connected_components2(self) -> None: ...
    def test_connected_components_friends(self) -> None: ...
    def test_label_progagation(self) -> None: ...
    def test_page_rank(self) -> None: ...
    def test_parallel_personalized_page_rank(self) -> None: ...
    def test_shortest_paths(self) -> None: ...
    def test_svd_plus_plus(self) -> None: ...
    def test_strongly_connected_components(self) -> None: ...
    def test_triangle_counts(self) -> None: ...

class GraphFrameExamplesTest(GraphFrameTestCase):
    sqlContext: SQLContext
    japi: JavaObject
    def setUp(self) -> None: ...
    def test_belief_propagation(self) -> None: ...
    def test_graph_friends(self) -> None: ...
    def test_graph_grid_ising_model(self) -> None: ...
