# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['contentctl',
 'contentctl.actions',
 'contentctl.actions.detection_testing',
 'contentctl.actions.detection_testing.infrastructures',
 'contentctl.actions.detection_testing.views',
 'contentctl.enrichments',
 'contentctl.helper',
 'contentctl.input',
 'contentctl.objects',
 'contentctl.output']

package_data = \
{'': ['*'],
 'contentctl': ['templates/*',
                'templates/detections/*',
                'templates/macros/*',
                'templates/splunk_app/metadata/*',
                'templates/stories/*',
                'templates/tests/*'],
 'contentctl.output': ['templates/*']}

install_requires = \
['Jinja2>=3.1.2,<4.0.0',
 'PyYAML>=6.0,<7.0',
 'attackcti>=0.3.7,<0.4.0',
 'bottle>=0.12.23,<0.13.0',
 'docker>=6.0.1,<7.0.0',
 'gitpython>=3.1.29,<4.0.0',
 'pycvesearch>=1.2,<2.0',
 'pydantic>=1.10.2,<2.0.0',
 'questionary>=1.10.0,<2.0.0',
 'requests>=2.28.1,<3.0.0',
 'semantic-version>=2.10.0,<3.0.0',
 'splunk-sdk>=1.7.2,<2.0.0',
 'tqdm>=4.65.0,<5.0.0',
 'validators>=0.20.0,<0.21.0',
 'xmltodict>=0.13.0,<0.14.0']

entry_points = \
{'console_scripts': ['contentctl = splunk_contentctl.contentctl:main']}

setup_kwargs = {
    'name': 'contentctl',
    'version': '1.0.0',
    'description': 'Splunk Content Control Tool',
    'long_description': '\n# contentctl\n<p align="center">\n<img src="docs/contentctl_logo_white.png" title="In case you\'re wondering, it\'s a capybara" alt="contentctl logo" width="250" height="250"></p>\n\n\n\n\n# Introduction\n#### Security Is Hard \nAnyone who has managed a [SOC](acronym) will tell you it\'s hard work.  SOC Managers, Detection Engineers, and Cybersecurity Professionals must understand and manage countless tools and data sources while ensuring the reliability and security of their network and applications.  At the same time, they must be able to detect and react to data breeches, vulnerabilities, and performance degradation in minutes - not seconds or hours.\nThese responsibilities leave little time for writing new content - let alone documentation, maintenance, and testing of legacy content.  Existing solutions like Wikis, JIRA tickets, Excel Spreadsheets, and "asking that one team member who knows everything" don\'t scale and spread information across various systems.       \n#### contentctl Makes It ~~Easy~~ Less Hard \ncontentctl is a single application that support the full cycle of security content development (each of the links below will redirect to the appropriate section of the README/Wiki):\n\n- [Create Content Packs](contentctl-init) - Version-Controlled collections of searches, documentation, and test data\n- [Add New Content](contentctl-new-content) - searches, macros, lookups, and other content\n- [Statically Validate](contentctl-validate) Content Against a Well-Defined Baseline\n- [Building](contentctl-build) a Content Pack for your target - Use a supported output format or design your own\n- [Generate](contentctl-generate) documentation, MITRE Maps, and a website that makes your Content Pack searchable and easy to understand  \n- [Test](contentctl-test) your Content Pack on a running Splunk Instance\n- [Deploy](contentctl-deploy) your Content Pack to Splunk Cloud Instance, via REST API, or create a Splunkbase Application for manual deployment   \n \n \n \n # Ecosystem\n| Project               | Description                                             |\n| --------------------- | ------------------------------------------------------- |\n| [Splunk Attack Range](https://github.com/splunk/attack_range)          | Easily deploy a preconfigured Splunk Environment locally or on AWS containing a Splunk Instance, Windows and Linux Machines, and Attacker Tools like Kali Linux.  Automatically simulate attacks or run your own|\n| [PurpleSharp Attack Simulation](https://github.com/mvelazc0/PurpleSharp) | Open source adversary simulation tool for Windows Active Directory environments (integrated into Attack Range)|\n| [Red Canary Atomic Red Team](https://github.com/redcanaryco/atomic-red-team)          | Library of attack simulations mapped to the MITRE ATT&CK® framework (integrated into Attack Range)|\n| [Splunk Attack Data](https://github.com/splunk/attack_data)          | Repository of Attack Simulation Data for writing and Testing Detections|                         |\n| [Splunk Security Content](https://github.com/splunk/security_content)          | Splunk Threat Research Team\'s Content included in the [Enterprise Security Content Update App (ESCU)](https://splunkbase.splunk.com/app/3449)|\n| [Splunk contentctl](https://github.com/splunk/contentctl)          | Generate, validate, build, test, and deploy custom Security Content|\n| [SigmaHQ Sigma Rules](https://github.com/SigmaHQ/sigma) | Official Repository for Sigma Rules. These rules are an excellent starting point for new content. |\n| [Other Important Project(s)](https://github.com/otherorg/projectname)          | Additional projects that STRT uses or contributes to|\n\n\n\n\n## Workflow\n```mermaid\ngraph TD\nstarting_state --contentctl init--> contentPack \nnewContent{new_content} --contentctl new sigma content--> contentPack\nnewContent{new_content} --contentctl new spl content--> contentPack\ncontentPack --contentctl validate--> ValidatedContent\nValidatedContent --contentctl build--> SplunkContent\nValidatedContent --contentctl docs--> WebsiteDocumentation\nValidatedContent --contentctl docs--> MITRE_mapDocumentation\nSplunkContent --contentctl test via container-->TestResults\nTestResults --contentctl deploy-->SplunkRESTAPI\nTestResults --contentctl deploy-->SplunkbaseApp\nTestResults --contentctl deploy-->SplunkCloudInstance\n```\n\n## Installation\n### Requirements\nTesting is run using [GitHub Hosted Runners](https://docs.github.com/en/actions/using-github-hosted-runners/about-github-hosted-runners).  Ubuntu22.04 is the recommended configuration.\n| Operating System | Supported | Passing Intregration Tests | \n| ---------------- | --------- | ------ |\n| Windows 10       | Yes       | Not tested yet |\n| Windows 11       | Yes       | Not tested yet |\n| Ununtu 20.04 LTS | Yes       | YES (locally + GitHub Actions) |\n| *Ubuntu 22.04 LTS| Yes       | YES (locally + GitHub Actions) |\n| macOS Montery 12       | Yes       | Not tested yet |\n| macOS Ventura 13       | Yes       | Yes (locally) |\n\n| Requirement | Required | Description |  Passing Integration Tests |\n| --------------------- | ----- | ---- | ------ |\n| Python <3.9 | Not Supported | No support planned.  contentctl tool uses modern language constructs not supported ion Python3.8 and below | N/A |\n| Python 3.9 | Required | contentctl tool is written in Python | Yes (locally + GitHub Actions) |\n| Python 3.10 | Not Supported (yet) | Will be supported | Yes (in GitHub Actions) |\n| Python 3.11 | Not Supported (yet) | Will be supported | Yes (in GitHub Actions)  |\n| Docker (local or remote) | Recommended | A running Splunk Server is required for Dynamic Testing.  contentctl can automatically create, configure, and destroy this server as a Splunk container during the lifetime of a test. | (locally + GitHub Actions) |\n\n\n**Because contentctl uses a large number of dependencies, it\'s recommended to install contentctl in a virtual environment. \nThe instructions below use "poetry" and follow this recommendation.  Poetry will automatically create a new virtual environment for you.  \nIt is typically recommended to install poetry to the Global Python Environment.**\n\n#### Install via pip (coming soon): \n```\npython3.9 -m venv .venv\nsource .venv/bin/activate\npip install splunk-contentctl\n```\n\n#### From Source (advanced)\n```\ngit clone git@github.com:splunk/contentctl.git\ncd contentctl\npython3.9 -m pip install poetry\npoetry install\npoetry shell\ncontentctl --help\n```\n\n\n# Usage\n\n### contentctl init\nCreates a new Content Pack in the current directory as well as a configuration file called [contentctl.yml](contentctl.yml) which contains a number of important configuration options.\nThe content pack contains a wide variety of content types:\n- [detections](detection)\n- [baselines](baseline)\n- [lookups](lookup)\n- [macros](macro)\n- [stories](story)\n\n### contentctl new [--type TYPE]\nChoose TYPE {detection, story} to create new content for the Content Pack.  The tool will interactively ask a series of questions required for generating a basic piece of content and automatically add it to the Content Pack.\n\n### contentctl validate\nPerforms static validation on all of the content in this Content Pack.  Writing validation is extremely complex.  Each piece of content can one or dozens of fields ranging from free text to numbers to references to other content.  contentctl\'s build in validation ensures that a number of conditions are met:\n- Required fields in content are defined\n- Values in fields are appropriate.  For example, if content references a Datamodel, then that Datamodel must be valid. Similarly, numeric values that must fall within a certain range must be validated.\n- If a piece of content references other content, then it exists.  For example, if a detection makes use of a macro then the existence and correctness of the macro must be validated.\n- There are no conflicts between content.  For example, two detections cannot have the same name.\nIf any of these conditions are not met, then a descriptive error will be printed and contentctl will return a nonzero exit code.  This makes it suitable for running in an automated workflow or other CICD context.  Instead of exiting on the first error, _contentctl validate_ will continue validating all content so that it can present all relevant error before exiting.\n\n### contentctl build\nGenerates Content Packs in the output format defined in the [contentctl.yml](contentctl.yml) configuration file.  These outputs may include {splunk_app, api, ba}.  When _contentctl build_ runs, it first performs a _contentctl validate_ in order to ensure that a valid app is generated.  Note that it is *NOT* required or recommended to run _contentctl validate_ separately if the intention is to build a Content Pack.\n\n### contentctl report\n### contentctl inspect\n### contentctl deploy\nThe reason to build content is so that it can be deployed to your environment.  However, deploying content to multiple servers and different types of infrastructure can be tricky and time-consuming.  contentctl makes this easy by supporting a number of different deployment mechanisms. Deployment targets can be defined in [contentctl.yml](contentctl.yml).\n- Deploy via API - Using the REST API, individual pieces of content are deployed to a running server.  This is a great way to deploy all of the content in a content pack, but can also be used to deploy individual peices of content.\n- Deploy to Splunk Cloud via ACS - Using the Automated Private App Vetting (APAV) Feature of the Admin Config Service (ACS), Splunk Cloud customers can easily deploy custom apps to their environments.   \n### contentctl docs\n### contentctl test\nThe static validation performed by *contentctl validate* can only take you so far.  While it\'s powerful, and fast, it can only tell determine if the content is *syntactically* correct.  *contentctl test* can test your content on real Splunk Infrastructure to ensure there are no errors in your SPL, raw data can be properly ingested/processed/accelerated on your server, your search finds the event(s) you\'re looking for in raw data, and even provides high-level runtime performance metrics about your searches.    The following diagram shows this workflow at a high level\n\n```mermaid\ngraph TD\nSplunkContainer--start-->SplunkInstance\nSplunkServer-->SplunkInstance\nSplunkInstance--Install Apps-->ConfiguredInstance\nSplunkInstance--Configure Settings-->ConfiguredInstance\nContentPack--Deploy-->ConfiguredInstance\nConfiguredInstance--Start Test-->Testing\nTesting--Test Detection-->Detection\n\nDetection--Replay Raw Data-->Result\nsubgraph Test Indidivual Detection\n\tDetection--Execute Search-->Result\t\nend\nResult--Cleanup-->Testing\nTesting--Cleanup-->TestResults\n```\n\n#### Testing Modes\nThere are a number of different testing modes that control which content will be tested.  This can be controlled with the `--mode {}` option at the command line\n- all - This will test all of the content in the content pack. Please note that by default only detections marked production will be tested (detections marked as deprecated or experimental, for example, will be ignored).\n- selected - Detections whose relative paths are provided on the command line will be tested.  This is particularly useful if you would like to troubleshoot or update just a handful of detections and can save a significant amount of time.  For example, to test two detections use the following command `contentctl test --mode selected --detections_list detections/detection_one.yml detections/detection_two.yml`\n- **changes - (not currently supported) If you have a large number of detections and use a branching workflow to create new content or update content, then this is an easy way to automatically find and test only that content automatically.  This prevents you from needing to explicitly list the subset of content to test using "selected"** \n\n#### Testing Behavior\ncontentctl test\'s default mode allows it to quickly test all content with requiring user interaction.  This makes it suitable for local tests as well as CI/CD workflows.  However, users often want to troubleshoot a test if it fails.  contentctl allows you to change the tool\'s behavior if and/or when a test fails:\n- --behavior never_pause - The default behavior.  If a test does not pass, the tool begins the next test immediately\n- --behavior pause_on_failure - If a test fails, then additional information about that test, and the raw SPL of the test, is printed to the terminal.  A user may then click (or CMD+Click) the "LINK" to begin interactively debugging the failed test on the Splunk Server.  Note that the credentials for the server are printed out at the very beginning of the test.  After you have finished debugging the failure, hit "Return" in the terminal to move on to the next test. The attack_data for this test remains loaded on the server for debugging until the user moves on to the next test.\n- --behavior always_pause - Similar to pause_on_failure, but this pauses after every test regardless of whether it passes or fails.  \n\n\n1. **init** - Initilialize a new repo from scratch so you can easily add your own content to a custom application. \n2. **new** - Creates new content (detection, story)\n3. **validate** - Validates written content\n4. **build** - Builds an application suitable for deployment on a search head using Slim, the Splunk Packaging Toolkit\n5. **deploy** - Deploy the security content pack to a Splunk Server\n6. **docs** - Create documentation as Markdown\n7. **reporting** - Create different reporting files such as a Mitre ATT&CK overlay\n\n\n\n# Acronyms\n| Acronym | Meaning| Description | \n| --------------------- | ------------------------------------------------------- | ---- |\n| SOC | Security Operation Center | Description of a SoC | \n| DaC | Detection as Code | A systematic approach applying DevOps priciples to Detection Engineering. DaC enables Continuous Integration and Continuous Delivery of Detectionsa via automated validation, testing, and deployment |\n| CICD | Continuous Integration/Continuous Delivery | A modern DevOps practice that encourages users to make small, frequent changes which are automatically tested and deployed. This contrasts with legacy approaches that emphasize large changes which may be manually tested an infrequently deployed. |\n| ACS| Admin Config Service | The [Splunk Admin Configu Service](https://docs.splunk.com/Documentation/SplunkCloud/9.0.2209/Config/ACSIntro) is a cloud-native API that provides programmatic self-service administration capabilities for Splunk Cloud Platform. One of its features, Automated Private App Vetting (APAV) enables the installation of custom app on Splunk Cloud instances. | \n| APAV | Automated Private App Vetting | [Automated Private App Vetting](https://docs.splunk.com/Documentation/SplunkCloud/9.0.2209/Config/ManageApps) enables admins to use the ACS API to install, upgrade, and uninstall apps directly on your Splunk Cloud Platform deployment without assistance from Splunk Support. |\n\n\n# License\nCopyright 2023 Splunk Inc.\n\nLicensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at\n\nhttp://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.\n',
    'author': 'STRT',
    'author_email': 'research@splunk.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
