/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.StringLabel;
import edu.stanford.nlp.parser.lexparser.TreebankLangParserParams;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.ArrayList;

public class NegraPennCollinizer
implements TreeTransformer {
    Redwood.RedwoodChannels log = Redwood.channels(NegraPennCollinizer.class);
    private TreebankLangParserParams tlpp;
    private final boolean deletePunct;
    protected TreeFactory tf = new LabeledScoredTreeFactory();

    public NegraPennCollinizer(TreebankLangParserParams tlpp) {
        this(tlpp, true);
    }

    public NegraPennCollinizer(TreebankLangParserParams tlpp, boolean deletePunct) {
        this.tlpp = tlpp;
        this.deletePunct = deletePunct;
    }

    @Override
    public Tree transformTree(Tree tree) {
        Label l = tree.label();
        if (tree.isLeaf()) {
            return this.tf.newLeaf(l);
        }
        String s = l.value();
        s = this.tlpp.treebankLanguagePack().basicCategory(s);
        if (this.deletePunct && tree.isPreTerminal() && this.tlpp.treebankLanguagePack().isEvalBIgnoredPunctuationTag(s)) {
            return null;
        }
        if (tree.children()[0].label().value().equals("TOPP")) {
            this.log.info("Found a TOPP");
            tree.setChildren(tree.children()[0].children());
        }
        if (this.tlpp.treebankLanguagePack().isStartSymbol(s) && tree.numChildren() == 1) {
            return this.transformTree(tree.getChild(0));
        }
        ArrayList<Tree> children = new ArrayList<Tree>();
        int numC = tree.numChildren();
        for (int cNum = 0; cNum < numC; ++cNum) {
            Tree child = tree.getChild(cNum);
            Tree newChild = this.transformTree(child);
            if (newChild == null) continue;
            children.add(newChild);
        }
        if (children.isEmpty()) {
            return null;
        }
        return this.tf.newTreeNode(new StringLabel(s), children);
    }
}

