from starlette.exceptions import HTTPException

SUCCESS = 200
FAIL = 1

VQL_MESSAGE_MAP = {
    500: "未知的错误",
    
    501: "图片错误：无法读取",  # 图片文件无法读取
    502: "图片错误：图片损坏",  # 图片文件损坏
    503: "图片错误：无法获取",  # 图片获取失败
    504: "图片错误：无法识别",  # 图片文件不支持
    505: "图片错误：不存在的key",  # Redis模式获取数据时key不存在
    506: "图片错误：无法连接数据库",  # Redis模式获取数据时,无法连接Redis
    
    511: "算子错误：算子处理失败",  # 不明原因的Atom报错
    512: "算子错误：显存不足",
    513: "算子错误：模型不匹配",
    514: "算子错误：未找到模型文件",
    515: "算子错误：超过重试次数，无法访问地址",  # API的URL或端口错误，无法访问
    516: "算子错误：错误的地址",  # API的路由地址错误
    517: "算子错误：错误的请求格式",  # 入参格式错误
    518: "算子错误：非法的算子地址",  # atom的api地址格式错误
    519: "算子错误：不匹配的硬件",
    520: "算子错误: 模型文件损坏",
    521: "算子错误: 磁盘空间不足",
    550: "IBase错误",  # R2Base 错误
    
    600: "低代码程序错误：未知错误",  # 低代码模块程序出现错误
    601: "低代码程序错误：程序超时",
    602: "低代码程序错误：非法操作",  # 代码段中包含不允许的操作
    603: "低代码程序错误：重复定义的变量",  # 代码中的自定义变量名已经被使用
    604: "低代码程序错误：代码错误",  # 代码块报错
    
    700: "鉴权失败: 缺少鉴权信息",  # 缺少鉴权字段
    701: "鉴权失败: 无权调用",  # 鉴权显示无权限调用
    702: "鉴权失败: 无法获取",  # 访问鉴权地址失败
    703: "鉴权失败: 非法鉴权码",  # 鉴权url解密失败
}


class VqlError(HTTPException):
    
    def __init__(self, status_code: int, detail: str = None):
        if detail is None:
            detail = VQL_MESSAGE_MAP.get(status_code, '')
        super().__init__(status_code, detail)
