import sowerest


class BaseInterface(object):
    def __init__(self, auth, host):
        """
        Construct the SoWeMail API object.
        Note that the underlying client is being set up during initialization,
        therefore changing attributes in runtime will not affect HTTP client
        behaviour.

        :param auth: the authorization header
        :type auth: string
        :param host: base URL for API calls
        :type host: string
        """
        from . import __sowemail_api_version__
        self.auth = auth
        self.host = host
        self.version = __sowemail_api_version__
        self.useragent = 'sowemail/{};python'.format(self.version)

        self.client = sowerest.Client(
            host=self.host,
            request_headers=self._default_headers,
            version=3)

    @property
    def _default_headers(self):
        """Set the default header for a SoWeMail API call"""
        headers = {
            "Authorization": self.auth,
            "User-Agent": self.useragent,
            "Accept": 'application/json'
        }

        return headers

    def reset_request_headers(self):
        self.client.request_headers = self._default_headers

    def send(self, message):
        """Make a SoWeMail API request with the request body generated by the Mail object

        :param message: The SoWeMail API request body generated by the Mail object
        :type message: Mail
        """
        if not isinstance(message, dict):
            message = message.get()

        return self.client.mail.send.post(request_body=message)
