"""__init__.py module for the Unique Root Keys plugin."""
# WARNING - DO NOT EDIT - YOUR CHANGES WILL NOT BE PROTECTED.
# This file is auto-generated by the aac gen-plugin and may be overwritten.

from os.path import join, dirname
from aac.execute.aac_execution_result import (
    ExecutionResult,
)
from aac.execute import hookimpl
from aac.context.language_context import LanguageContext
from aac.execute.plugin_runner import PluginRunner
from aac.plugins.unique_root_keys.unique_root_keys_impl import plugin_name
from aac.plugins.unique_root_keys.unique_root_keys_impl import root_key_names_are_unique


unique_root_keys_aac_file_name = "unique_root_keys.aac"


def run_root_key_names_are_unique(context: LanguageContext) -> ExecutionResult:
    """Check every definition to ensure there are no duplicate root keys defined in the AaC language."""

    return root_key_names_are_unique(context)


@hookimpl
def register_plugin() -> None:
    """
    Returns information about the plugin.

    Returns:
        A collection of information about the plugin and what it contributes.
    """

    active_context = LanguageContext()
    unique_root_keys_aac_file = join(dirname(__file__), unique_root_keys_aac_file_name)
    definitions = active_context.parse_and_load(unique_root_keys_aac_file)

    unique_root_keys_plugin_definition = [
        definition for definition in definitions if definition.name == plugin_name
    ][0]

    plugin_instance = unique_root_keys_plugin_definition.instance
    for file_to_load in plugin_instance.definition_sources:
        active_context.parse_and_load(file_to_load)

    plugin_runner = PluginRunner(plugin_definition=unique_root_keys_plugin_definition)

    plugin_runner.add_constraint_callback(
        "Root key names are unique", run_root_key_names_are_unique
    )

    active_context.register_plugin_runner(plugin_runner)
