"""__init__.py module for the Root schema must have name plugin."""
# WARNING - DO NOT EDIT - YOUR CHANGES WILL NOT BE PROTECTED.
# This file is auto-generated by the aac gen-plugin and may be overwritten.
from typing import Any
from os.path import join, dirname
from aac.execute.aac_execution_result import (
    ExecutionResult,
)
from aac.execute import hookimpl
from aac.context.language_context import LanguageContext
from aac.context.definition import Definition
from aac.execute.plugin_runner import PluginRunner


from aac.plugins.root_schema_must_have_name.root_schema_must_have_name_impl import (
    plugin_name,
)


from aac.plugins.root_schema_must_have_name.root_schema_must_have_name_impl import (
    root_schema_has_name,
)


root_schema_must_have_name_aac_file_name = "root_schema_must_have_name.aac"


def run_root_schema_has_name(
    instance: Any, definition: Definition, defining_schema, arguments: Any
) -> ExecutionResult:
    """Check every schema with a root key and ensure there is a field called name."""

    return root_schema_has_name(instance, definition, defining_schema)


@hookimpl
def register_plugin() -> None:
    """
    Returns information about the plugin.

    Returns:
        A collection of information about the plugin and what it contributes.
    """

    active_context = LanguageContext()
    root_schema_must_have_name_aac_file = join(
        dirname(__file__), root_schema_must_have_name_aac_file_name
    )
    definitions = active_context.parse_and_load(root_schema_must_have_name_aac_file)

    root_schema_must_have_name_plugin_definition = [
        definition for definition in definitions if definition.name == plugin_name
    ][0]

    plugin_instance = root_schema_must_have_name_plugin_definition.instance
    for file_to_load in plugin_instance.definition_sources:
        active_context.parse_and_load(file_to_load)

    plugin_runner = PluginRunner(
        plugin_definition=root_schema_must_have_name_plugin_definition
    )

    plugin_runner.add_constraint_callback(
        "Root schema has name", run_root_schema_has_name
    )

    active_context.register_plugin_runner(plugin_runner)
