"""__init__.py module for the No Ext for Final plugin."""
# WARNING - DO NOT EDIT - YOUR CHANGES WILL NOT BE PROTECTED.
# This file is auto-generated by the aac gen-plugin and may be overwritten.

from os.path import join, dirname
from typing import Any
from aac.execute.aac_execution_result import (
    ExecutionResult,
)
from aac.execute import hookimpl
from aac.context.language_context import LanguageContext
from aac.context.definition import Definition
from aac.execute.plugin_runner import PluginRunner
from aac.plugins.no_ext_for_final.no_ext_for_final_impl import plugin_name
from aac.plugins.no_ext_for_final.no_ext_for_final_impl import no_extension_for_final


no_ext_for_final_aac_file_name = "no_ext_for_final.aac"


def run_no_extension_for_final(
    instance: Any, definition: Definition, defining_schema, arguments: Any
) -> ExecutionResult:
    """Check every schema for extension entries that are marked with a final modifier."""

    return no_extension_for_final(instance, definition, defining_schema)


@hookimpl
def register_plugin() -> None:
    """
    Returns information about the plugin.

    Returns:
        A collection of information about the plugin and what it contributes.
    """

    active_context = LanguageContext()
    no_ext_for_final_aac_file = join(dirname(__file__), no_ext_for_final_aac_file_name)
    definitions = active_context.parse_and_load(no_ext_for_final_aac_file)

    no_ext_for_final_plugin_definition = [
        definition for definition in definitions if definition.name == plugin_name
    ][0]

    plugin_instance = no_ext_for_final_plugin_definition.instance
    for file_to_load in plugin_instance.definition_sources:
        active_context.parse_and_load(file_to_load)

    plugin_runner = PluginRunner(plugin_definition=no_ext_for_final_plugin_definition)

    plugin_runner.add_constraint_callback(
        "No Extension for Final", run_no_extension_for_final
    )

    active_context.register_plugin_runner(plugin_runner)
