"""The AaC If true then empty plugin implementation module."""
# NOTE: It is safe to edit this file.
# This file is only initially generated by aac gen-plugin, and it won't be overwritten if the file already exists.

# There may be some unused imports depending on the definition of the plugin...but that's ok
from aac.execute.aac_execution_result import (
    ExecutionResult,
    ExecutionStatus,
    ExecutionMessage,
    MessageLevel,
)
from aac.context.definition import Definition
from typing import Any


plugin_name = "If true then empty"


def if_true_then_empty(
    instance: Any,
    definition: Definition,
    defining_schema,
    bool_field_name: str,
    empty_field_name: str,
) -> ExecutionResult:
    """Business logic for the If true then empty constraint."""

    bool_field_value = getattr(instance, bool_field_name, None)
    if not isinstance(bool_field_value, bool):
        # the constraint failed
        error_msg = ExecutionMessage(
            f"The If true then empty constraint for {instance.name} failed because {bool_field_name} is not a boolean.  Received {bool_field_value}.",
            MessageLevel.ERROR,
            definition.source.uri,
            None,
        )
        return ExecutionResult(
            plugin_name,
            "If true then empty",
            ExecutionStatus.GENERAL_FAILURE,
            [error_msg],
        )

    empty_field_value = getattr(instance, empty_field_name, None)

    is_empty_field_empty = (
        empty_field_value is None
        or empty_field_value == ""
        or empty_field_value == []
        or empty_field_value == {}
    )

    if bool_field_value and not is_empty_field_empty:
        # the constraint failed
        error_msg = ExecutionMessage(
            f"The If true then empty constraint for {instance.name} failed because {bool_field_name} is true and {empty_field_name} is not empty.",
            MessageLevel.ERROR,
            definition.source.uri,
            None,
        )
        return ExecutionResult(
            plugin_name,
            "If true then empty",
            ExecutionStatus.GENERAL_FAILURE,
            [error_msg],
        )

    # the constraint passed
    return ExecutionResult(
        plugin_name, "If true then empty", ExecutionStatus.SUCCESS, []
    )
