"""__init__.py module for the Gen Plugin plugin."""
# WARNING - DO NOT EDIT - YOUR CHANGES WILL NOT BE PROTECTED.
# This file is auto-generated by the aac gen-plugin and may be overwritten.

from os.path import join, dirname, abspath
from aac.execute.aac_execution_result import (
    ExecutionResult,
    ExecutionStatus,
)
from aac.execute import hookimpl
from aac.context.language_context import LanguageContext
from aac.execute.plugin_runner import PluginRunner


from aac.plugins.gen_plugin.gen_plugin_impl import (
    plugin_name,
    gen_plugin,
    before_gen_plugin_check,
    after_gen_plugin_generate,
    gen_project,
    before_gen_project_check,
    after_gen_project_generate,
)


from aac.plugins.check import run_check
from aac.plugins.generate import run_generate

gen_plugin_aac_file_name = "gen_plugin.aac"


def run_gen_plugin(
    aac_plugin_file: str,
    code_output: str,
    test_output: str,
    doc_output: str,
    no_prompt: bool,
    force_overwrite: bool,
    evaluate: bool,
) -> ExecutionResult:
    """Generate code and stubs for an AaC plugin.  Overwrites will backup existing files."""

    result = ExecutionResult(plugin_name, "gen-plugin", ExecutionStatus.SUCCESS, [])

    gen_plugin_check_result = before_gen_plugin_check(
        aac_plugin_file,
        code_output,
        test_output,
        doc_output,
        no_prompt,
        force_overwrite,
        evaluate,
        run_check,
    )
    if not gen_plugin_check_result.is_success():
        return gen_plugin_check_result
    else:
        result.add_messages(gen_plugin_check_result.messages)

    gen_plugin_result = gen_plugin(
        aac_plugin_file,
        code_output,
        test_output,
        doc_output,
        no_prompt,
        force_overwrite,
        evaluate,
    )
    if not gen_plugin_result.is_success():
        return gen_plugin_result
    else:
        result.add_messages(gen_plugin_result.messages)

    gen_plugin_generate_result = after_gen_plugin_generate(
        aac_plugin_file,
        code_output,
        test_output,
        doc_output,
        no_prompt,
        force_overwrite,
        evaluate,
        run_generate,
    )
    if not gen_plugin_generate_result.is_success():
        return gen_plugin_generate_result
    else:
        result.add_messages(gen_plugin_generate_result.messages)

    return result


def run_gen_project(
    aac_project_file: str,
    output: str,
    no_prompt: bool,
    force_overwrite: bool,
    evaluate: bool,
) -> ExecutionResult:
    """Generate code and stubs for an AaC project.  Overwrites will backup existing files."""

    result = ExecutionResult(plugin_name, "gen-project", ExecutionStatus.SUCCESS, [])

    gen_project_check_result = before_gen_project_check(
        aac_project_file, output, no_prompt, force_overwrite, evaluate, run_check
    )
    if not gen_project_check_result.is_success():
        return gen_project_check_result
    else:
        result.add_messages(gen_project_check_result.messages)

    gen_project_result = gen_project(
        aac_project_file, output, no_prompt, force_overwrite, evaluate
    )
    if not gen_project_result.is_success():
        return gen_project_result
    else:
        result.add_messages(gen_project_result.messages)

    if not output or len(output) == 0:
        output = dirname(abspath(aac_project_file))
    gen_project_generate_result = after_gen_project_generate(
        aac_project_file, output, no_prompt, force_overwrite, evaluate, run_generate
    )
    if not gen_project_generate_result.is_success():
        return gen_project_generate_result
    else:
        result.add_messages(gen_project_generate_result.messages)

    return result


@hookimpl
def register_plugin() -> None:
    """
    Returns information about the plugin.

    Returns:
        A collection of information about the plugin and what it contributes.
    """

    active_context = LanguageContext()
    gen_plugin_aac_file = join(dirname(__file__), gen_plugin_aac_file_name)
    definitions = active_context.parse_and_load(gen_plugin_aac_file)

    gen_plugin_plugin_definition = [
        definition for definition in definitions if definition.name == plugin_name
    ][0]

    plugin_instance = gen_plugin_plugin_definition.instance
    for file_to_load in plugin_instance.definition_sources:
        active_context.parse_and_load(file_to_load)

    plugin_runner = PluginRunner(plugin_definition=gen_plugin_plugin_definition)
    plugin_runner.add_command_callback("gen-plugin", run_gen_plugin)
    plugin_runner.add_command_callback("gen-project", run_gen_project)

    active_context.register_plugin_runner(plugin_runner)
