"""__init__.py module for the Exclusive fields plugin."""
# WARNING - DO NOT EDIT - YOUR CHANGES WILL NOT BE PROTECTED.
# This file is auto-generated by the aac gen-plugin and may be overwritten.

from os.path import join, dirname
from copy import deepcopy
from typing import Any
from aac.execute.aac_execution_result import (
    ExecutionResult,
)
from aac.execute import hookimpl
from aac.context.language_context import LanguageContext
from aac.context.definition import Definition
from aac.execute.plugin_runner import PluginRunner
from aac.plugins.exclusive_fields.exclusive_fields_impl import plugin_name, mutually_exclusive_fields

exclusive_fields_aac_file_name = "exclusive_fields.aac"


def run_mutually_exclusive_fields(
    instance: Any, definition: Definition, defining_schema, arguments: Any
) -> ExecutionResult:
    """Ensure that only one of the fields are defined at any time."""

    argument_copy = deepcopy(arguments)
    args = {}
    for arg in argument_copy:
        args[arg["name"]] = arg["value"]

    return mutually_exclusive_fields(instance, definition, defining_schema, **args)


@hookimpl
def register_plugin() -> None:
    """
    Returns information about the plugin.

    Returns:
        A collection of information about the plugin and what it contributes.
    """

    active_context = LanguageContext()
    exclusive_fields_aac_file = join(dirname(__file__), exclusive_fields_aac_file_name)
    definitions = active_context.parse_and_load(exclusive_fields_aac_file)

    exclusive_fields_plugin_definition = [
        definition for definition in definitions if definition.name == plugin_name
    ][0]

    plugin_instance = exclusive_fields_plugin_definition.instance
    for file_to_load in plugin_instance.definition_sources:
        active_context.parse_and_load(file_to_load)

    plugin_runner = PluginRunner(plugin_definition=exclusive_fields_plugin_definition)

    plugin_runner.add_constraint_callback(
        "Mutually exclusive fields", run_mutually_exclusive_fields
    )

    active_context.register_plugin_runner(plugin_runner)
