BEGIN TRANSACTION;
--------------------------------------------------------------------------------
PRAGMA foreign_keys = 0;
--------------------------------------------------------------------------------
-- Internationalize country names
CREATE TABLE countries_temp AS SELECT * FROM countries;
DROP TABLE countries;

CREATE TABLE countries (
    id         INTEGER  PRIMARY KEY UNIQUE NOT NULL,
    code       CHAR (3) UNIQUE NOT NULL,
    iso_code   CHAR (4) UNIQUE NOT NULL
);
INSERT INTO countries ( id, code, iso_code) SELECT id, code, iso_code FROM countries_temp;
DROP TABLE countries_temp;

CREATE TABLE country_names (
    id          INTEGER PRIMARY KEY UNIQUE NOT NULL,
    country_id  INTEGER REFERENCES countries (id) ON DELETE CASCADE ON UPDATE CASCADE NOT NULL,
    language_id INTEGER REFERENCES languages (id) ON DELETE CASCADE ON UPDATE CASCADE NOT NULL,
    name        TEXT    NOT NULL
);
CREATE UNIQUE INDEX country_name_by_language ON country_names (country_id, language_id);

DROP VIEW IF EXISTS countries_ext;
CREATE VIEW countries_ext AS
    SELECT c.id, c.code, c.iso_code, n.name
    FROM countries AS c
    LEFT JOIN country_names AS n ON n.country_id = c.id AND n.language_id = (SELECT value FROM settings WHERE id = 3);

-- Initialize countries
-- ENGLISH --
INSERT INTO country_names (country_id, language_id, name) VALUES (0, 1, 'N/A');
INSERT INTO country_names (country_id, language_id, name) VALUES (1, 1, 'Russia');
INSERT INTO country_names (country_id, language_id, name) VALUES (2, 1, 'United States');
INSERT INTO country_names (country_id, language_id, name) VALUES (3, 1, 'Ireland');
INSERT INTO country_names (country_id, language_id, name) VALUES (4, 1, 'Switzerland');
INSERT INTO country_names (country_id, language_id, name) VALUES (5, 1, 'France');
INSERT INTO country_names (country_id, language_id, name) VALUES (6, 1, 'Canada');
INSERT INTO country_names (country_id, language_id, name) VALUES (7, 1, 'Sweden');
INSERT INTO country_names (country_id, language_id, name) VALUES (8, 1, 'Italy');
INSERT INTO country_names (country_id, language_id, name) VALUES (9, 1, 'Spain');
INSERT INTO country_names (country_id, language_id, name) VALUES (10, 1, 'Australia');
INSERT INTO country_names (country_id, language_id, name) VALUES (11, 1, 'Austria');
INSERT INTO country_names (country_id, language_id, name) VALUES (12, 1, 'Belgium');
INSERT INTO country_names (country_id, language_id, name) VALUES (13, 1, 'United Kingdom');
INSERT INTO country_names (country_id, language_id, name) VALUES (14, 1, 'Germany');
INSERT INTO country_names (country_id, language_id, name) VALUES (15, 1, 'China');
INSERT INTO country_names (country_id, language_id, name) VALUES (16, 1, 'Netherlands');
INSERT INTO country_names (country_id, language_id, name) VALUES (17, 1, 'Greece');
INSERT INTO country_names (country_id, language_id, name) VALUES (18, 1, 'Bermuda');
INSERT INTO country_names (country_id, language_id, name) VALUES (19, 1, 'Finland');
INSERT INTO country_names (country_id, language_id, name) VALUES (20, 1, 'Brazil');
INSERT INTO country_names (country_id, language_id, name) VALUES (21, 1, 'Jersey');
INSERT INTO country_names (country_id, language_id, name) VALUES (22, 1, 'Afghanistan');
INSERT INTO country_names (country_id, language_id, name) VALUES (23, 1, 'Aland Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (24, 1, 'Albania');
INSERT INTO country_names (country_id, language_id, name) VALUES (25, 1, 'Algeria');
INSERT INTO country_names (country_id, language_id, name) VALUES (26, 1, 'American Samoa');
INSERT INTO country_names (country_id, language_id, name) VALUES (27, 1, 'Andorra');
INSERT INTO country_names (country_id, language_id, name) VALUES (28, 1, 'Angola');
INSERT INTO country_names (country_id, language_id, name) VALUES (29, 1, 'Anguilla');
INSERT INTO country_names (country_id, language_id, name) VALUES (30, 1, 'Antarctica');
INSERT INTO country_names (country_id, language_id, name) VALUES (31, 1, 'Antigua and Barbuda');
INSERT INTO country_names (country_id, language_id, name) VALUES (32, 1, 'Argentina');
INSERT INTO country_names (country_id, language_id, name) VALUES (33, 1, 'Armenia');
INSERT INTO country_names (country_id, language_id, name) VALUES (34, 1, 'Aruba');
INSERT INTO country_names (country_id, language_id, name) VALUES (35, 1, 'Azerbaijan');
INSERT INTO country_names (country_id, language_id, name) VALUES (36, 1, 'Bahamas');
INSERT INTO country_names (country_id, language_id, name) VALUES (37, 1, 'Bahrain');
INSERT INTO country_names (country_id, language_id, name) VALUES (38, 1, 'Bangladesh');
INSERT INTO country_names (country_id, language_id, name) VALUES (39, 1, 'Barbados');
INSERT INTO country_names (country_id, language_id, name) VALUES (40, 1, 'Belarus');
INSERT INTO country_names (country_id, language_id, name) VALUES (41, 1, 'Belize');
INSERT INTO country_names (country_id, language_id, name) VALUES (42, 1, 'Benin');
INSERT INTO country_names (country_id, language_id, name) VALUES (43, 1, 'Bhutan');
INSERT INTO country_names (country_id, language_id, name) VALUES (44, 1, 'Bolivia');
INSERT INTO country_names (country_id, language_id, name) VALUES (45, 1, 'Bosnia and Herzegovina');
INSERT INTO country_names (country_id, language_id, name) VALUES (46, 1, 'Botswana');
INSERT INTO country_names (country_id, language_id, name) VALUES (47, 1, 'Bouvet Island');
INSERT INTO country_names (country_id, language_id, name) VALUES (48, 1, 'British Virgin Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (49, 1, 'British Indian Ocean Territory');
INSERT INTO country_names (country_id, language_id, name) VALUES (50, 1, 'Brunei Darussalam');
INSERT INTO country_names (country_id, language_id, name) VALUES (51, 1, 'Bulgaria');
INSERT INTO country_names (country_id, language_id, name) VALUES (52, 1, 'Burkina Faso');
INSERT INTO country_names (country_id, language_id, name) VALUES (53, 1, 'Burundi');
INSERT INTO country_names (country_id, language_id, name) VALUES (54, 1, 'Cambodia');
INSERT INTO country_names (country_id, language_id, name) VALUES (55, 1, 'Cameroon');
INSERT INTO country_names (country_id, language_id, name) VALUES (56, 1, 'Cape Verde');
INSERT INTO country_names (country_id, language_id, name) VALUES (57, 1, 'Cayman Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (58, 1, 'Central African Republic');
INSERT INTO country_names (country_id, language_id, name) VALUES (59, 1, 'Chad');
INSERT INTO country_names (country_id, language_id, name) VALUES (60, 1, 'Chile');
INSERT INTO country_names (country_id, language_id, name) VALUES (61, 1, 'Hong Kong, SAR China');
INSERT INTO country_names (country_id, language_id, name) VALUES (62, 1, 'Macao, SAR China');
INSERT INTO country_names (country_id, language_id, name) VALUES (63, 1, 'Christmas Island');
INSERT INTO country_names (country_id, language_id, name) VALUES (64, 1, 'Cocos (Keeling) Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (65, 1, 'Colombia');
INSERT INTO country_names (country_id, language_id, name) VALUES (66, 1, 'Comoros');
INSERT INTO country_names (country_id, language_id, name) VALUES (67, 1, 'Congo (Brazzaville)');
INSERT INTO country_names (country_id, language_id, name) VALUES (68, 1, 'Congo, (Kinshasa)');
INSERT INTO country_names (country_id, language_id, name) VALUES (69, 1, 'Cook Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (70, 1, 'Costa Rica');
INSERT INTO country_names (country_id, language_id, name) VALUES (71, 1, 'Côte d’Ivoire');
INSERT INTO country_names (country_id, language_id, name) VALUES (72, 1, 'Croatia');
INSERT INTO country_names (country_id, language_id, name) VALUES (73, 1, 'Cuba');
INSERT INTO country_names (country_id, language_id, name) VALUES (74, 1, 'Cyprus');
INSERT INTO country_names (country_id, language_id, name) VALUES (75, 1, 'Czech Republic');
INSERT INTO country_names (country_id, language_id, name) VALUES (76, 1, 'Denmark');
INSERT INTO country_names (country_id, language_id, name) VALUES (77, 1, 'Djibouti');
INSERT INTO country_names (country_id, language_id, name) VALUES (78, 1, 'Dominica');
INSERT INTO country_names (country_id, language_id, name) VALUES (79, 1, 'Dominican Republic');
INSERT INTO country_names (country_id, language_id, name) VALUES (80, 1, 'Ecuador');
INSERT INTO country_names (country_id, language_id, name) VALUES (81, 1, 'Egypt');
INSERT INTO country_names (country_id, language_id, name) VALUES (82, 1, 'El Salvador');
INSERT INTO country_names (country_id, language_id, name) VALUES (83, 1, 'Equatorial Guinea');
INSERT INTO country_names (country_id, language_id, name) VALUES (84, 1, 'Eritrea');
INSERT INTO country_names (country_id, language_id, name) VALUES (85, 1, 'Estonia');
INSERT INTO country_names (country_id, language_id, name) VALUES (86, 1, 'Ethiopia');
INSERT INTO country_names (country_id, language_id, name) VALUES (87, 1, 'Falkland Islands (Malvinas)');
INSERT INTO country_names (country_id, language_id, name) VALUES (88, 1, 'Faroe Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (89, 1, 'Fiji');
INSERT INTO country_names (country_id, language_id, name) VALUES (90, 1, 'French Guiana');
INSERT INTO country_names (country_id, language_id, name) VALUES (91, 1, 'French Polynesia');
INSERT INTO country_names (country_id, language_id, name) VALUES (92, 1, 'French Southern Territories');
INSERT INTO country_names (country_id, language_id, name) VALUES (93, 1, 'Gabon');
INSERT INTO country_names (country_id, language_id, name) VALUES (94, 1, 'Gambia');
INSERT INTO country_names (country_id, language_id, name) VALUES (95, 1, 'Georgia');
INSERT INTO country_names (country_id, language_id, name) VALUES (96, 1, 'Ghana');
INSERT INTO country_names (country_id, language_id, name) VALUES (97, 1, 'Gibraltar');
INSERT INTO country_names (country_id, language_id, name) VALUES (98, 1, 'Greenland');
INSERT INTO country_names (country_id, language_id, name) VALUES (99, 1, 'Grenada');
INSERT INTO country_names (country_id, language_id, name) VALUES (100, 1, 'Guadeloupe');
INSERT INTO country_names (country_id, language_id, name) VALUES (101, 1, 'Guam');
INSERT INTO country_names (country_id, language_id, name) VALUES (102, 1, 'Guatemala');
INSERT INTO country_names (country_id, language_id, name) VALUES (103, 1, 'Guernsey');
INSERT INTO country_names (country_id, language_id, name) VALUES (104, 1, 'Guinea');
INSERT INTO country_names (country_id, language_id, name) VALUES (105, 1, 'Guinea-Bissau');
INSERT INTO country_names (country_id, language_id, name) VALUES (106, 1, 'Guyana');
INSERT INTO country_names (country_id, language_id, name) VALUES (107, 1, 'Haiti');
INSERT INTO country_names (country_id, language_id, name) VALUES (108, 1, 'Heard and Mcdonald Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (109, 1, 'Holy See (Vatican City State)');
INSERT INTO country_names (country_id, language_id, name) VALUES (110, 1, 'Honduras');
INSERT INTO country_names (country_id, language_id, name) VALUES (111, 1, 'Hungary');
INSERT INTO country_names (country_id, language_id, name) VALUES (112, 1, 'Iceland');
INSERT INTO country_names (country_id, language_id, name) VALUES (113, 1, 'India');
INSERT INTO country_names (country_id, language_id, name) VALUES (114, 1, 'Indonesia');
INSERT INTO country_names (country_id, language_id, name) VALUES (115, 1, 'Iran, Islamic Republic of');
INSERT INTO country_names (country_id, language_id, name) VALUES (116, 1, 'Iraq');
INSERT INTO country_names (country_id, language_id, name) VALUES (117, 1, 'Isle of Man');
INSERT INTO country_names (country_id, language_id, name) VALUES (118, 1, 'Israel');
INSERT INTO country_names (country_id, language_id, name) VALUES (119, 1, 'Jamaica');
INSERT INTO country_names (country_id, language_id, name) VALUES (120, 1, 'Japan');
INSERT INTO country_names (country_id, language_id, name) VALUES (121, 1, 'Jordan');
INSERT INTO country_names (country_id, language_id, name) VALUES (122, 1, 'Kazakhstan');
INSERT INTO country_names (country_id, language_id, name) VALUES (123, 1, 'Kenya');
INSERT INTO country_names (country_id, language_id, name) VALUES (124, 1, 'Kiribati');
INSERT INTO country_names (country_id, language_id, name) VALUES (125, 1, 'Korea (North)');
INSERT INTO country_names (country_id, language_id, name) VALUES (126, 1, 'Korea (South)');
INSERT INTO country_names (country_id, language_id, name) VALUES (127, 1, 'Kuwait');
INSERT INTO country_names (country_id, language_id, name) VALUES (128, 1, 'Kyrgyzstan');
INSERT INTO country_names (country_id, language_id, name) VALUES (129, 1, 'Lao PDR');
INSERT INTO country_names (country_id, language_id, name) VALUES (130, 1, 'Latvia');
INSERT INTO country_names (country_id, language_id, name) VALUES (131, 1, 'Lebanon');
INSERT INTO country_names (country_id, language_id, name) VALUES (132, 1, 'Lesotho');
INSERT INTO country_names (country_id, language_id, name) VALUES (133, 1, 'Liberia');
INSERT INTO country_names (country_id, language_id, name) VALUES (134, 1, 'Libya');
INSERT INTO country_names (country_id, language_id, name) VALUES (135, 1, 'Liechtenstein');
INSERT INTO country_names (country_id, language_id, name) VALUES (136, 1, 'Lithuania');
INSERT INTO country_names (country_id, language_id, name) VALUES (137, 1, 'Luxembourg');
INSERT INTO country_names (country_id, language_id, name) VALUES (138, 1, 'Macedonia, Republic of');
INSERT INTO country_names (country_id, language_id, name) VALUES (139, 1, 'Madagascar');
INSERT INTO country_names (country_id, language_id, name) VALUES (140, 1, 'Malawi');
INSERT INTO country_names (country_id, language_id, name) VALUES (141, 1, 'Malaysia');
INSERT INTO country_names (country_id, language_id, name) VALUES (142, 1, 'Maldives');
INSERT INTO country_names (country_id, language_id, name) VALUES (143, 1, 'Mali');
INSERT INTO country_names (country_id, language_id, name) VALUES (144, 1, 'Malta');
INSERT INTO country_names (country_id, language_id, name) VALUES (145, 1, 'Marshall Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (146, 1, 'Martinique');
INSERT INTO country_names (country_id, language_id, name) VALUES (147, 1, 'Mauritania');
INSERT INTO country_names (country_id, language_id, name) VALUES (148, 1, 'Mauritius');
INSERT INTO country_names (country_id, language_id, name) VALUES (149, 1, 'Mayotte');
INSERT INTO country_names (country_id, language_id, name) VALUES (150, 1, 'Mexico');
INSERT INTO country_names (country_id, language_id, name) VALUES (151, 1, 'Micronesia, Federated States of');
INSERT INTO country_names (country_id, language_id, name) VALUES (152, 1, 'Moldova');
INSERT INTO country_names (country_id, language_id, name) VALUES (153, 1, 'Monaco');
INSERT INTO country_names (country_id, language_id, name) VALUES (154, 1, 'Mongolia');
INSERT INTO country_names (country_id, language_id, name) VALUES (155, 1, 'Montenegro');
INSERT INTO country_names (country_id, language_id, name) VALUES (156, 1, 'Montserrat');
INSERT INTO country_names (country_id, language_id, name) VALUES (157, 1, 'Morocco');
INSERT INTO country_names (country_id, language_id, name) VALUES (158, 1, 'Mozambique');
INSERT INTO country_names (country_id, language_id, name) VALUES (159, 1, 'Myanmar');
INSERT INTO country_names (country_id, language_id, name) VALUES (160, 1, 'Namibia');
INSERT INTO country_names (country_id, language_id, name) VALUES (161, 1, 'Nauru');
INSERT INTO country_names (country_id, language_id, name) VALUES (162, 1, 'Nepal');
INSERT INTO country_names (country_id, language_id, name) VALUES (163, 1, 'Netherlands Antilles');
INSERT INTO country_names (country_id, language_id, name) VALUES (164, 1, 'New Caledonia');
INSERT INTO country_names (country_id, language_id, name) VALUES (165, 1, 'New Zealand');
INSERT INTO country_names (country_id, language_id, name) VALUES (166, 1, 'Nicaragua');
INSERT INTO country_names (country_id, language_id, name) VALUES (167, 1, 'Niger');
INSERT INTO country_names (country_id, language_id, name) VALUES (168, 1, 'Nigeria');
INSERT INTO country_names (country_id, language_id, name) VALUES (169, 1, 'Niue');
INSERT INTO country_names (country_id, language_id, name) VALUES (170, 1, 'Norfolk Island');
INSERT INTO country_names (country_id, language_id, name) VALUES (171, 1, 'Northern Mariana Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (172, 1, 'Norway');
INSERT INTO country_names (country_id, language_id, name) VALUES (173, 1, 'Oman');
INSERT INTO country_names (country_id, language_id, name) VALUES (174, 1, 'Pakistan');
INSERT INTO country_names (country_id, language_id, name) VALUES (175, 1, 'Palau');
INSERT INTO country_names (country_id, language_id, name) VALUES (176, 1, 'Palestinian Territory');
INSERT INTO country_names (country_id, language_id, name) VALUES (177, 1, 'Panama');
INSERT INTO country_names (country_id, language_id, name) VALUES (178, 1, 'Papua New Guinea');
INSERT INTO country_names (country_id, language_id, name) VALUES (179, 1, 'Paraguay');
INSERT INTO country_names (country_id, language_id, name) VALUES (180, 1, 'Peru');
INSERT INTO country_names (country_id, language_id, name) VALUES (181, 1, 'Philippines');
INSERT INTO country_names (country_id, language_id, name) VALUES (182, 1, 'Pitcairn');
INSERT INTO country_names (country_id, language_id, name) VALUES (183, 1, 'Poland');
INSERT INTO country_names (country_id, language_id, name) VALUES (184, 1, 'Portugal');
INSERT INTO country_names (country_id, language_id, name) VALUES (185, 1, 'Puerto Rico');
INSERT INTO country_names (country_id, language_id, name) VALUES (186, 1, 'Qatar');
INSERT INTO country_names (country_id, language_id, name) VALUES (187, 1, 'Réunion');
INSERT INTO country_names (country_id, language_id, name) VALUES (188, 1, 'Romania');
INSERT INTO country_names (country_id, language_id, name) VALUES (189, 1, 'Rwanda');
INSERT INTO country_names (country_id, language_id, name) VALUES (190, 1, 'Saint-Barthélemy');
INSERT INTO country_names (country_id, language_id, name) VALUES (191, 1, 'Saint Helena');
INSERT INTO country_names (country_id, language_id, name) VALUES (192, 1, 'Saint Kitts and Nevis');
INSERT INTO country_names (country_id, language_id, name) VALUES (193, 1, 'Saint Lucia');
INSERT INTO country_names (country_id, language_id, name) VALUES (194, 1, 'Saint-Martin (French part)');
INSERT INTO country_names (country_id, language_id, name) VALUES (195, 1, 'Saint Pierre and Miquelon');
INSERT INTO country_names (country_id, language_id, name) VALUES (196, 1, 'Saint Vincent and Grenadines');
INSERT INTO country_names (country_id, language_id, name) VALUES (197, 1, 'Samoa');
INSERT INTO country_names (country_id, language_id, name) VALUES (198, 1, 'San Marino');
INSERT INTO country_names (country_id, language_id, name) VALUES (199, 1, 'Sao Tome and Principe');
INSERT INTO country_names (country_id, language_id, name) VALUES (200, 1, 'Saudi Arabia');
INSERT INTO country_names (country_id, language_id, name) VALUES (201, 1, 'Senegal');
INSERT INTO country_names (country_id, language_id, name) VALUES (202, 1, 'Serbia');
INSERT INTO country_names (country_id, language_id, name) VALUES (203, 1, 'Seychelles');
INSERT INTO country_names (country_id, language_id, name) VALUES (204, 1, 'Sierra Leone');
INSERT INTO country_names (country_id, language_id, name) VALUES (205, 1, 'Singapore');
INSERT INTO country_names (country_id, language_id, name) VALUES (206, 1, 'Slovakia');
INSERT INTO country_names (country_id, language_id, name) VALUES (207, 1, 'Slovenia');
INSERT INTO country_names (country_id, language_id, name) VALUES (208, 1, 'Solomon Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (209, 1, 'Somalia');
INSERT INTO country_names (country_id, language_id, name) VALUES (210, 1, 'South Africa');
INSERT INTO country_names (country_id, language_id, name) VALUES (211, 1, 'South Georgia and the South Sandwich Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (212, 1, 'South Sudan');
INSERT INTO country_names (country_id, language_id, name) VALUES (213, 1, 'Sri Lanka');
INSERT INTO country_names (country_id, language_id, name) VALUES (214, 1, 'Sudan');
INSERT INTO country_names (country_id, language_id, name) VALUES (215, 1, 'Suriname');
INSERT INTO country_names (country_id, language_id, name) VALUES (216, 1, 'Svalbard and Jan Mayen Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (217, 1, 'Swaziland');
INSERT INTO country_names (country_id, language_id, name) VALUES (218, 1, 'Syrian Arab Republic (Syria)');
INSERT INTO country_names (country_id, language_id, name) VALUES (219, 1, 'Taiwan, Republic of China');
INSERT INTO country_names (country_id, language_id, name) VALUES (220, 1, 'Tajikistan');
INSERT INTO country_names (country_id, language_id, name) VALUES (221, 1, 'Tanzania, United Republic of');
INSERT INTO country_names (country_id, language_id, name) VALUES (222, 1, 'Thailand');
INSERT INTO country_names (country_id, language_id, name) VALUES (223, 1, 'Timor-Leste');
INSERT INTO country_names (country_id, language_id, name) VALUES (224, 1, 'Togo');
INSERT INTO country_names (country_id, language_id, name) VALUES (225, 1, 'Tokelau');
INSERT INTO country_names (country_id, language_id, name) VALUES (226, 1, 'Tonga');
INSERT INTO country_names (country_id, language_id, name) VALUES (227, 1, 'Trinidad and Tobago');
INSERT INTO country_names (country_id, language_id, name) VALUES (228, 1, 'Tunisia');
INSERT INTO country_names (country_id, language_id, name) VALUES (229, 1, 'Turkey');
INSERT INTO country_names (country_id, language_id, name) VALUES (230, 1, 'Turkmenistan');
INSERT INTO country_names (country_id, language_id, name) VALUES (231, 1, 'Turks and Caicos Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (232, 1, 'Tuvalu');
INSERT INTO country_names (country_id, language_id, name) VALUES (233, 1, 'Uganda');
INSERT INTO country_names (country_id, language_id, name) VALUES (234, 1, 'Ukraine');
INSERT INTO country_names (country_id, language_id, name) VALUES (235, 1, 'United Arab Emirates');
INSERT INTO country_names (country_id, language_id, name) VALUES (236, 1, 'US Minor Outlying Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (237, 1, 'Uruguay');
INSERT INTO country_names (country_id, language_id, name) VALUES (238, 1, 'Uzbekistan');
INSERT INTO country_names (country_id, language_id, name) VALUES (239, 1, 'Vanuatu');
INSERT INTO country_names (country_id, language_id, name) VALUES (240, 1, 'Venezuela (Bolivarian Republic)');
INSERT INTO country_names (country_id, language_id, name) VALUES (241, 1, 'Viet Nam');
INSERT INTO country_names (country_id, language_id, name) VALUES (242, 1, 'Virgin Islands, US');
INSERT INTO country_names (country_id, language_id, name) VALUES (243, 1, 'Wallis and Futuna Islands');
INSERT INTO country_names (country_id, language_id, name) VALUES (244, 1, 'Western Sahara');
INSERT INTO country_names (country_id, language_id, name) VALUES (245, 1, 'Yemen');
INSERT INTO country_names (country_id, language_id, name) VALUES (246, 1, 'Zambia');
INSERT INTO country_names (country_id, language_id, name) VALUES (247, 1, 'Zimbabwe');
-- RUSSIAN --
INSERT INTO country_names (country_id, language_id, name) VALUES (0, 2, 'н/д');
INSERT INTO country_names (country_id, language_id, name) VALUES (1, 2, 'Россия');
INSERT INTO country_names (country_id, language_id, name) VALUES (2, 2, 'США');
INSERT INTO country_names (country_id, language_id, name) VALUES (3, 2, 'Ирландия');
INSERT INTO country_names (country_id, language_id, name) VALUES (4, 2, 'Швейцария');
INSERT INTO country_names (country_id, language_id, name) VALUES (5, 2, 'Франция');
INSERT INTO country_names (country_id, language_id, name) VALUES (6, 2, 'Канада');
INSERT INTO country_names (country_id, language_id, name) VALUES (7, 2, 'Швеция');
INSERT INTO country_names (country_id, language_id, name) VALUES (8, 2, 'Италия');
INSERT INTO country_names (country_id, language_id, name) VALUES (9, 2, 'Испания');
INSERT INTO country_names (country_id, language_id, name) VALUES (10, 2, 'Австралия');
INSERT INTO country_names (country_id, language_id, name) VALUES (11, 2, 'Австрия');
INSERT INTO country_names (country_id, language_id, name) VALUES (12, 2, 'Бельгия');
INSERT INTO country_names (country_id, language_id, name) VALUES (13, 2, 'Великобритания');
INSERT INTO country_names (country_id, language_id, name) VALUES (14, 2, 'Германия');
INSERT INTO country_names (country_id, language_id, name) VALUES (15, 2, 'Китай');
INSERT INTO country_names (country_id, language_id, name) VALUES (16, 2, 'Нидерланды');
INSERT INTO country_names (country_id, language_id, name) VALUES (17, 2, 'Греция');
INSERT INTO country_names (country_id, language_id, name) VALUES (18, 2, 'Бермудские Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (19, 2, 'Финляндия');
INSERT INTO country_names (country_id, language_id, name) VALUES (20, 2, 'Бразилия');
INSERT INTO country_names (country_id, language_id, name) VALUES (21, 2, 'Джерси');
INSERT INTO country_names (country_id, language_id, name) VALUES (22, 2, 'Афганистан');
INSERT INTO country_names (country_id, language_id, name) VALUES (23, 2, 'Аландские острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (24, 2, 'Албания');
INSERT INTO country_names (country_id, language_id, name) VALUES (25, 2, 'Алжир');
INSERT INTO country_names (country_id, language_id, name) VALUES (26, 2, 'Американское Самоа');
INSERT INTO country_names (country_id, language_id, name) VALUES (27, 2, 'Андорра');
INSERT INTO country_names (country_id, language_id, name) VALUES (28, 2, 'Ангола');
INSERT INTO country_names (country_id, language_id, name) VALUES (29, 2, 'Ангилья');
INSERT INTO country_names (country_id, language_id, name) VALUES (30, 2, 'Антарктика');
INSERT INTO country_names (country_id, language_id, name) VALUES (31, 2, 'Антигуа и Барбуда');
INSERT INTO country_names (country_id, language_id, name) VALUES (32, 2, 'Аргентина');
INSERT INTO country_names (country_id, language_id, name) VALUES (33, 2, 'Армения');
INSERT INTO country_names (country_id, language_id, name) VALUES (34, 2, 'Аруба');
INSERT INTO country_names (country_id, language_id, name) VALUES (35, 2, 'Азербайджан');
INSERT INTO country_names (country_id, language_id, name) VALUES (36, 2, 'Багамские Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (37, 2, 'Бахрейн');
INSERT INTO country_names (country_id, language_id, name) VALUES (38, 2, 'Бангладеш');
INSERT INTO country_names (country_id, language_id, name) VALUES (39, 2, 'Барбадос');
INSERT INTO country_names (country_id, language_id, name) VALUES (40, 2, 'Беларусь');
INSERT INTO country_names (country_id, language_id, name) VALUES (41, 2, 'Белиз');
INSERT INTO country_names (country_id, language_id, name) VALUES (42, 2, 'Бенин');
INSERT INTO country_names (country_id, language_id, name) VALUES (43, 2, 'Бутан');
INSERT INTO country_names (country_id, language_id, name) VALUES (44, 2, 'Боливия');
INSERT INTO country_names (country_id, language_id, name) VALUES (45, 2, 'Босния и Герцоговина');
INSERT INTO country_names (country_id, language_id, name) VALUES (46, 2, 'Ботсвана');
INSERT INTO country_names (country_id, language_id, name) VALUES (47, 2, 'Остров Буве');
INSERT INTO country_names (country_id, language_id, name) VALUES (48, 2, 'Виргинские Острова (Великобритания)');
INSERT INTO country_names (country_id, language_id, name) VALUES (49, 2, 'Британская Территория в Индийском Океане');
INSERT INTO country_names (country_id, language_id, name) VALUES (50, 2, 'Бруней');
INSERT INTO country_names (country_id, language_id, name) VALUES (51, 2, 'Болгария');
INSERT INTO country_names (country_id, language_id, name) VALUES (52, 2, 'Буркина-Фасо');
INSERT INTO country_names (country_id, language_id, name) VALUES (53, 2, 'Бурунди');
INSERT INTO country_names (country_id, language_id, name) VALUES (54, 2, 'Камбоджа');
INSERT INTO country_names (country_id, language_id, name) VALUES (55, 2, 'Камерун');
INSERT INTO country_names (country_id, language_id, name) VALUES (56, 2, 'Кабо-Верде');
INSERT INTO country_names (country_id, language_id, name) VALUES (57, 2, 'Острова Кайман');
INSERT INTO country_names (country_id, language_id, name) VALUES (58, 2, 'Центральноафриканская Республика');
INSERT INTO country_names (country_id, language_id, name) VALUES (59, 2, 'Чад');
INSERT INTO country_names (country_id, language_id, name) VALUES (60, 2, 'Чили');
INSERT INTO country_names (country_id, language_id, name) VALUES (61, 2, 'Гонконг');
INSERT INTO country_names (country_id, language_id, name) VALUES (62, 2, 'Макао');
INSERT INTO country_names (country_id, language_id, name) VALUES (63, 2, 'Остров Рождества');
INSERT INTO country_names (country_id, language_id, name) VALUES (64, 2, 'Кокосовые острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (65, 2, 'Колумбия');
INSERT INTO country_names (country_id, language_id, name) VALUES (66, 2, 'Коморы');
INSERT INTO country_names (country_id, language_id, name) VALUES (67, 2, 'Республика Конго');
INSERT INTO country_names (country_id, language_id, name) VALUES (68, 2, 'Демократическая Республика Конго');
INSERT INTO country_names (country_id, language_id, name) VALUES (69, 2, 'Острова Кука');
INSERT INTO country_names (country_id, language_id, name) VALUES (70, 2, 'Коста-Рика');
INSERT INTO country_names (country_id, language_id, name) VALUES (71, 2, 'Кот-д’Ивуар');
INSERT INTO country_names (country_id, language_id, name) VALUES (72, 2, 'Хорватия');
INSERT INTO country_names (country_id, language_id, name) VALUES (73, 2, 'Куба');
INSERT INTO country_names (country_id, language_id, name) VALUES (74, 2, 'Кипр');
INSERT INTO country_names (country_id, language_id, name) VALUES (75, 2, 'Чехия');
INSERT INTO country_names (country_id, language_id, name) VALUES (76, 2, 'Дания');
INSERT INTO country_names (country_id, language_id, name) VALUES (77, 2, 'Джибути');
INSERT INTO country_names (country_id, language_id, name) VALUES (78, 2, 'Доминика');
INSERT INTO country_names (country_id, language_id, name) VALUES (79, 2, 'Доминиканская Республика');
INSERT INTO country_names (country_id, language_id, name) VALUES (80, 2, 'Эквадор');
INSERT INTO country_names (country_id, language_id, name) VALUES (81, 2, 'Египет');
INSERT INTO country_names (country_id, language_id, name) VALUES (82, 2, 'Сальвадор');
INSERT INTO country_names (country_id, language_id, name) VALUES (83, 2, 'Экваториальная Гвинея');
INSERT INTO country_names (country_id, language_id, name) VALUES (84, 2, 'Эритрея');
INSERT INTO country_names (country_id, language_id, name) VALUES (85, 2, 'Эстония');
INSERT INTO country_names (country_id, language_id, name) VALUES (86, 2, 'Эфиопия');
INSERT INTO country_names (country_id, language_id, name) VALUES (87, 2, 'Фолклендские острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (88, 2, 'Фарерские острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (89, 2, 'Фиджи');
INSERT INTO country_names (country_id, language_id, name) VALUES (90, 2, 'Французская Гвиана');
INSERT INTO country_names (country_id, language_id, name) VALUES (91, 2, 'Французская Полинезия');
INSERT INTO country_names (country_id, language_id, name) VALUES (92, 2, 'Французские южные территории');
INSERT INTO country_names (country_id, language_id, name) VALUES (93, 2, 'Габон');
INSERT INTO country_names (country_id, language_id, name) VALUES (94, 2, 'Гамбия');
INSERT INTO country_names (country_id, language_id, name) VALUES (95, 2, 'Грузия');
INSERT INTO country_names (country_id, language_id, name) VALUES (96, 2, 'Гана');
INSERT INTO country_names (country_id, language_id, name) VALUES (97, 2, 'Гибралтар ');
INSERT INTO country_names (country_id, language_id, name) VALUES (98, 2, 'Гренландия');
INSERT INTO country_names (country_id, language_id, name) VALUES (99, 2, 'Гренада');
INSERT INTO country_names (country_id, language_id, name) VALUES (100, 2, 'Гваделупа');
INSERT INTO country_names (country_id, language_id, name) VALUES (101, 2, 'Гуам');
INSERT INTO country_names (country_id, language_id, name) VALUES (102, 2, 'Гватемала');
INSERT INTO country_names (country_id, language_id, name) VALUES (103, 2, 'Гернси');
INSERT INTO country_names (country_id, language_id, name) VALUES (104, 2, 'Гвинея');
INSERT INTO country_names (country_id, language_id, name) VALUES (105, 2, 'Гвинея-Бисау');
INSERT INTO country_names (country_id, language_id, name) VALUES (106, 2, 'Гайана');
INSERT INTO country_names (country_id, language_id, name) VALUES (107, 2, 'Республика Гаити');
INSERT INTO country_names (country_id, language_id, name) VALUES (108, 2, 'Остров Херд и острова Макдональд');
INSERT INTO country_names (country_id, language_id, name) VALUES (109, 2, 'Ватикан');
INSERT INTO country_names (country_id, language_id, name) VALUES (110, 2, 'Гондурас');
INSERT INTO country_names (country_id, language_id, name) VALUES (111, 2, 'Венгрия');
INSERT INTO country_names (country_id, language_id, name) VALUES (112, 2, 'Исландия');
INSERT INTO country_names (country_id, language_id, name) VALUES (113, 2, 'Индия');
INSERT INTO country_names (country_id, language_id, name) VALUES (114, 2, 'Индонезия');
INSERT INTO country_names (country_id, language_id, name) VALUES (115, 2, 'Иран');
INSERT INTO country_names (country_id, language_id, name) VALUES (116, 2, 'Ирак');
INSERT INTO country_names (country_id, language_id, name) VALUES (117, 2, 'Остров Мэн');
INSERT INTO country_names (country_id, language_id, name) VALUES (118, 2, 'Израиль');
INSERT INTO country_names (country_id, language_id, name) VALUES (119, 2, 'Ямайка');
INSERT INTO country_names (country_id, language_id, name) VALUES (120, 2, 'Япония');
INSERT INTO country_names (country_id, language_id, name) VALUES (121, 2, 'Иордания');
INSERT INTO country_names (country_id, language_id, name) VALUES (122, 2, 'Казахстан');
INSERT INTO country_names (country_id, language_id, name) VALUES (123, 2, 'Кения');
INSERT INTO country_names (country_id, language_id, name) VALUES (124, 2, 'Кирибати');
INSERT INTO country_names (country_id, language_id, name) VALUES (125, 2, 'КНДР');
INSERT INTO country_names (country_id, language_id, name) VALUES (126, 2, 'Южная Корея');
INSERT INTO country_names (country_id, language_id, name) VALUES (127, 2, 'Кувейт');
INSERT INTO country_names (country_id, language_id, name) VALUES (128, 2, 'Киргизия');
INSERT INTO country_names (country_id, language_id, name) VALUES (129, 2, 'Лаос');
INSERT INTO country_names (country_id, language_id, name) VALUES (130, 2, 'Латвия');
INSERT INTO country_names (country_id, language_id, name) VALUES (131, 2, 'Ливан');
INSERT INTO country_names (country_id, language_id, name) VALUES (132, 2, 'Лесото');
INSERT INTO country_names (country_id, language_id, name) VALUES (133, 2, 'Либерия');
INSERT INTO country_names (country_id, language_id, name) VALUES (134, 2, 'Ливия');
INSERT INTO country_names (country_id, language_id, name) VALUES (135, 2, 'Лихтенштейн');
INSERT INTO country_names (country_id, language_id, name) VALUES (136, 2, 'Литва');
INSERT INTO country_names (country_id, language_id, name) VALUES (137, 2, 'Люксембург');
INSERT INTO country_names (country_id, language_id, name) VALUES (138, 2, 'Македония');
INSERT INTO country_names (country_id, language_id, name) VALUES (139, 2, 'Мадагаскар');
INSERT INTO country_names (country_id, language_id, name) VALUES (140, 2, 'Малави');
INSERT INTO country_names (country_id, language_id, name) VALUES (141, 2, 'Малайзия');
INSERT INTO country_names (country_id, language_id, name) VALUES (142, 2, 'Мальдивы');
INSERT INTO country_names (country_id, language_id, name) VALUES (143, 2, 'Мали');
INSERT INTO country_names (country_id, language_id, name) VALUES (144, 2, 'Мальта');
INSERT INTO country_names (country_id, language_id, name) VALUES (145, 2, 'Маршалловы Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (146, 2, 'Мартиника');
INSERT INTO country_names (country_id, language_id, name) VALUES (147, 2, 'Мавритания');
INSERT INTO country_names (country_id, language_id, name) VALUES (148, 2, 'Маврикий');
INSERT INTO country_names (country_id, language_id, name) VALUES (149, 2, 'Майотта');
INSERT INTO country_names (country_id, language_id, name) VALUES (150, 2, 'Мексика');
INSERT INTO country_names (country_id, language_id, name) VALUES (151, 2, 'Микронезия');
INSERT INTO country_names (country_id, language_id, name) VALUES (152, 2, 'Молдавия');
INSERT INTO country_names (country_id, language_id, name) VALUES (153, 2, 'Монако');
INSERT INTO country_names (country_id, language_id, name) VALUES (154, 2, 'Монголия');
INSERT INTO country_names (country_id, language_id, name) VALUES (155, 2, 'Черногория');
INSERT INTO country_names (country_id, language_id, name) VALUES (156, 2, 'Монтсеррат');
INSERT INTO country_names (country_id, language_id, name) VALUES (157, 2, 'Марокко');
INSERT INTO country_names (country_id, language_id, name) VALUES (158, 2, 'Мозамбик');
INSERT INTO country_names (country_id, language_id, name) VALUES (159, 2, 'Мьянма');
INSERT INTO country_names (country_id, language_id, name) VALUES (160, 2, 'Намибия');
INSERT INTO country_names (country_id, language_id, name) VALUES (161, 2, 'Науру');
INSERT INTO country_names (country_id, language_id, name) VALUES (162, 2, 'Непал');
INSERT INTO country_names (country_id, language_id, name) VALUES (163, 2, 'Нидерландские Антильские острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (164, 2, 'Новая Каледония');
INSERT INTO country_names (country_id, language_id, name) VALUES (165, 2, 'Новая Зеландия');
INSERT INTO country_names (country_id, language_id, name) VALUES (166, 2, 'Никарагуа');
INSERT INTO country_names (country_id, language_id, name) VALUES (167, 2, 'Нигер');
INSERT INTO country_names (country_id, language_id, name) VALUES (168, 2, 'Нигерия');
INSERT INTO country_names (country_id, language_id, name) VALUES (169, 2, 'Ниуэ');
INSERT INTO country_names (country_id, language_id, name) VALUES (170, 2, 'Остров Норфолк');
INSERT INTO country_names (country_id, language_id, name) VALUES (171, 2, 'Северные Марианские Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (172, 2, 'Норвегия');
INSERT INTO country_names (country_id, language_id, name) VALUES (173, 2, 'Оман');
INSERT INTO country_names (country_id, language_id, name) VALUES (174, 2, 'Пакистан');
INSERT INTO country_names (country_id, language_id, name) VALUES (175, 2, 'Палау');
INSERT INTO country_names (country_id, language_id, name) VALUES (176, 2, 'Сектор Газа');
INSERT INTO country_names (country_id, language_id, name) VALUES (177, 2, 'Панама');
INSERT INTO country_names (country_id, language_id, name) VALUES (178, 2, 'Папуа - Новая Гвинея');
INSERT INTO country_names (country_id, language_id, name) VALUES (179, 2, 'Парагвай');
INSERT INTO country_names (country_id, language_id, name) VALUES (180, 2, 'Перу');
INSERT INTO country_names (country_id, language_id, name) VALUES (181, 2, 'Филиппины');
INSERT INTO country_names (country_id, language_id, name) VALUES (182, 2, 'Острова Питкэрн');
INSERT INTO country_names (country_id, language_id, name) VALUES (183, 2, 'Польша');
INSERT INTO country_names (country_id, language_id, name) VALUES (184, 2, 'Португалия');
INSERT INTO country_names (country_id, language_id, name) VALUES (185, 2, 'Пуэрто-Рико ');
INSERT INTO country_names (country_id, language_id, name) VALUES (186, 2, 'Катар');
INSERT INTO country_names (country_id, language_id, name) VALUES (187, 2, 'Реюньон');
INSERT INTO country_names (country_id, language_id, name) VALUES (188, 2, 'Румыния');
INSERT INTO country_names (country_id, language_id, name) VALUES (189, 2, 'Руанда');
INSERT INTO country_names (country_id, language_id, name) VALUES (190, 2, 'Сен-Бартелеми (Карибы)');
INSERT INTO country_names (country_id, language_id, name) VALUES (191, 2, 'Остров Святой Елены');
INSERT INTO country_names (country_id, language_id, name) VALUES (192, 2, 'Сент-Китс и Невис');
INSERT INTO country_names (country_id, language_id, name) VALUES (193, 2, 'Сент-Люсия');
INSERT INTO country_names (country_id, language_id, name) VALUES (194, 2, 'Сен-Мартен (владение Франции)');
INSERT INTO country_names (country_id, language_id, name) VALUES (195, 2, 'Сен-Пьер и Микелон');
INSERT INTO country_names (country_id, language_id, name) VALUES (196, 2, 'Сент-Винсент и Гренадины');
INSERT INTO country_names (country_id, language_id, name) VALUES (197, 2, 'Самоа');
INSERT INTO country_names (country_id, language_id, name) VALUES (198, 2, 'Сан-Марино');
INSERT INTO country_names (country_id, language_id, name) VALUES (199, 2, 'Сан-Томе и Принсипи');
INSERT INTO country_names (country_id, language_id, name) VALUES (200, 2, 'Саудовская Аравия');
INSERT INTO country_names (country_id, language_id, name) VALUES (201, 2, 'Сенегал');
INSERT INTO country_names (country_id, language_id, name) VALUES (202, 2, 'Сербия');
INSERT INTO country_names (country_id, language_id, name) VALUES (203, 2, 'Сейшельские Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (204, 2, 'Сьерра-Леоне ');
INSERT INTO country_names (country_id, language_id, name) VALUES (205, 2, 'Сингапур');
INSERT INTO country_names (country_id, language_id, name) VALUES (206, 2, 'Словакия');
INSERT INTO country_names (country_id, language_id, name) VALUES (207, 2, 'Словения');
INSERT INTO country_names (country_id, language_id, name) VALUES (208, 2, 'Соломоновы Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (209, 2, 'Сомали');
INSERT INTO country_names (country_id, language_id, name) VALUES (210, 2, 'Южно-Африканская Республика');
INSERT INTO country_names (country_id, language_id, name) VALUES (211, 2, 'Южная Георгия и Южные Сандвичевы Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (212, 2, 'Южный Судан');
INSERT INTO country_names (country_id, language_id, name) VALUES (213, 2, 'Шри-Ланка');
INSERT INTO country_names (country_id, language_id, name) VALUES (214, 2, 'Судан');
INSERT INTO country_names (country_id, language_id, name) VALUES (215, 2, 'Суринам');
INSERT INTO country_names (country_id, language_id, name) VALUES (216, 2, 'Заморские территории Норвегии');
INSERT INTO country_names (country_id, language_id, name) VALUES (217, 2, 'Эсватини');
INSERT INTO country_names (country_id, language_id, name) VALUES (218, 2, 'Сирия');
INSERT INTO country_names (country_id, language_id, name) VALUES (219, 2, 'Тайвань');
INSERT INTO country_names (country_id, language_id, name) VALUES (220, 2, 'Таджикистан');
INSERT INTO country_names (country_id, language_id, name) VALUES (221, 2, 'Танзания');
INSERT INTO country_names (country_id, language_id, name) VALUES (222, 2, 'Тайланд');
INSERT INTO country_names (country_id, language_id, name) VALUES (223, 2, 'Восточный Тимор');
INSERT INTO country_names (country_id, language_id, name) VALUES (224, 2, 'Того');
INSERT INTO country_names (country_id, language_id, name) VALUES (225, 2, 'Токелау');
INSERT INTO country_names (country_id, language_id, name) VALUES (226, 2, 'Тонга');
INSERT INTO country_names (country_id, language_id, name) VALUES (227, 2, 'Тринидад и Тобаго');
INSERT INTO country_names (country_id, language_id, name) VALUES (228, 2, 'Тунис');
INSERT INTO country_names (country_id, language_id, name) VALUES (229, 2, 'Турция');
INSERT INTO country_names (country_id, language_id, name) VALUES (230, 2, 'Туркменистан');
INSERT INTO country_names (country_id, language_id, name) VALUES (231, 2, 'Теркс и Кайкос');
INSERT INTO country_names (country_id, language_id, name) VALUES (232, 2, 'Тувалу');
INSERT INTO country_names (country_id, language_id, name) VALUES (233, 2, 'Уганда');
INSERT INTO country_names (country_id, language_id, name) VALUES (234, 2, 'Украина');
INSERT INTO country_names (country_id, language_id, name) VALUES (235, 2, 'Объединённые Арабские Эмираты');
INSERT INTO country_names (country_id, language_id, name) VALUES (236, 2, 'Внешние малые острова США');
INSERT INTO country_names (country_id, language_id, name) VALUES (237, 2, 'Уругвай');
INSERT INTO country_names (country_id, language_id, name) VALUES (238, 2, 'Узбекистан');
INSERT INTO country_names (country_id, language_id, name) VALUES (239, 2, 'Вануату');
INSERT INTO country_names (country_id, language_id, name) VALUES (240, 2, 'Венесуэла');
INSERT INTO country_names (country_id, language_id, name) VALUES (241, 2, 'Вьетнам');
INSERT INTO country_names (country_id, language_id, name) VALUES (242, 2, 'Американские Виргинские Острова');
INSERT INTO country_names (country_id, language_id, name) VALUES (243, 2, 'Уоллис и Футуна');
INSERT INTO country_names (country_id, language_id, name) VALUES (244, 2, 'Западная Сахара');
INSERT INTO country_names (country_id, language_id, name) VALUES (245, 2, 'Йемен');
INSERT INTO country_names (country_id, language_id, name) VALUES (246, 2, 'Замбия');
INSERT INTO country_names (country_id, language_id, name) VALUES (247, 2, 'Зимбабве');
--------------------------------------------------------------------------------
PRAGMA foreign_keys = 1;
--------------------------------------------------------------------------------
-- Set new DB schema version
UPDATE settings SET value=41 WHERE name='SchemaVersion';
COMMIT;
