"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateToSqs = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Note: To ensure CDKv2 compatibility, keep the import statement for Construct separate
const core_1 = require("@aws-cdk/core");
const defaults = require("@aws-solutions-constructs/core");
class FargateToSqs extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        defaults.CheckFargateProps(props);
        this.vpc = defaults.buildVpc(scope, {
            existingVpc: props.existingVpc,
            defaultVpcProps: props.publicApi ? defaults.DefaultPublicPrivateVpcProps() : defaults.DefaultIsolatedVpcProps(),
            userVpcProps: props.vpcProps,
            constructVpcProps: { enableDnsHostnames: true, enableDnsSupport: true }
        });
        defaults.AddAwsServiceEndpoint(scope, this.vpc, defaults.ServiceEndpointTypes.SQS);
        if (props.existingFargateServiceObject) {
            this.service = props.existingFargateServiceObject;
            // CheckFargateProps confirms that the container is provided
            this.container = props.existingContainerDefinitionObject;
        }
        else {
            [this.service, this.container] = defaults.CreateFargateService(scope, id, this.vpc, props.clusterProps, props.ecrRepositoryArn, props.ecrImageVersion, props.fargateTaskDefinitionProps, props.containerDefinitionProps, props.fargateServiceProps);
        }
        // Setup the dead letter queue, if applicable
        this.deadLetterQueue = defaults.buildDeadLetterQueue(this, {
            existingQueueObj: props.existingQueueObj,
            deployDeadLetterQueue: props.deployDeadLetterQueue,
            deadLetterQueueProps: props.deadLetterQueueProps,
            maxReceiveCount: props.maxReceiveCount
        });
        // Setup the SQS Queue
        [this.sqsQueue] = defaults.buildQueue(this, `${id}-queue`, {
            queueProps: props.queueProps,
            deadLetterQueue: this.deadLetterQueue,
            existingQueueObj: props.existingQueueObj,
        });
        // Enable message send and receive permissions for Fargate service by default
        if (props.queuePermissions) {
            if (props.queuePermissions.includes('Read')) {
                this.sqsQueue.grantConsumeMessages(this.service.taskDefinition.taskRole);
            }
            if (props.queuePermissions.includes('Write')) {
                this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
            }
        }
        else {
            this.sqsQueue.grantSendMessages(this.service.taskDefinition.taskRole);
        }
        // Setting environment variables
        const queueArnEnvironmentVariableName = props.queueArnEnvironmentVariableName || 'SQS_QUEUE_ARN';
        this.container.addEnvironment(queueArnEnvironmentVariableName, this.sqsQueue.queueArn);
        const queueUrlEnvironmentVariableName = props.queueUrlEnvironmentVariableName || 'SQS_QUEUE_URL';
        this.container.addEnvironment(queueUrlEnvironmentVariableName, this.sqsQueue.queueUrl);
    }
}
exports.FargateToSqs = FargateToSqs;
_a = JSII_RTTI_SYMBOL_1;
FargateToSqs[_a] = { fqn: "@aws-solutions-constructs/aws-fargate-sqs.FargateToSqs", version: "1.141.0" };
//# sourceMappingURL=data:application/json;base64,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