"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.permissionSetParseArn = exports.validatePermissionSetArn = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
function validatePermissionSetArn(permissionSetArn) {
    if (!aws_cdk_lib_1.Token.isUnresolved(permissionSetArn) && !permissionSetArn.match(/arn:(aws|aws-us-gov|aws-cn|aws-iso|aws-iso-b):sso:::permissionSet\/(sso)?ins-[a-zA-Z0-9-.]{16}\/ps-[a-zA-Z0-9-./]{16}/)) {
        throw new Error(`Invalid SSO permission set ARN: ${permissionSetArn}`);
    }
}
exports.validatePermissionSetArn = validatePermissionSetArn;
;
function permissionSetParseArn(permissionSetArn) {
    validatePermissionSetArn(permissionSetArn);
    return aws_cdk_lib_1.Arn.split(permissionSetArn, aws_cdk_lib_1.ArnFormat.SLASH_RESOURCE_NAME);
}
exports.permissionSetParseArn = permissionSetParseArn;
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGVybWlzc2lvbnNldC1jb21tb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcHJpdmF0ZS9wZXJtaXNzaW9uc2V0LWNvbW1vbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2Q0FBbUU7QUFFbkUsU0FBZ0Isd0JBQXdCLENBQUMsZ0JBQXdCO0lBQy9ELElBQUksQ0FBQyxtQkFBSyxDQUFDLFlBQVksQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsS0FBSyxDQUFDLHVIQUF1SCxDQUFDLEVBQUU7UUFDN0wsTUFBTSxJQUFJLEtBQUssQ0FBQyxtQ0FBbUMsZ0JBQWdCLEVBQUUsQ0FBQyxDQUFDO0tBQ3hFO0FBQ0gsQ0FBQztBQUpELDREQUlDO0FBQUEsQ0FBQztBQUVGLFNBQWdCLHFCQUFxQixDQUFDLGdCQUF3QjtJQUM1RCx3QkFBd0IsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO0lBRTNDLE9BQU8saUJBQUcsQ0FBQyxLQUFLLENBQUMsZ0JBQWdCLEVBQUUsdUJBQVMsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDO0FBQ3BFLENBQUM7QUFKRCxzREFJQztBQUFBLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcm5Db21wb25lbnRzLCBBcm4sIEFybkZvcm1hdCwgVG9rZW4gfSBmcm9tICdhd3MtY2RrLWxpYic7XG5cbmV4cG9ydCBmdW5jdGlvbiB2YWxpZGF0ZVBlcm1pc3Npb25TZXRBcm4ocGVybWlzc2lvblNldEFybjogc3RyaW5nKTogdm9pZCB7XG4gIGlmICghVG9rZW4uaXNVbnJlc29sdmVkKHBlcm1pc3Npb25TZXRBcm4pICYmICFwZXJtaXNzaW9uU2V0QXJuLm1hdGNoKC9hcm46KGF3c3xhd3MtdXMtZ292fGF3cy1jbnxhd3MtaXNvfGF3cy1pc28tYik6c3NvOjo6cGVybWlzc2lvblNldFxcLyhzc28pP2lucy1bYS16QS1aMC05LS5dezE2fVxcL3BzLVthLXpBLVowLTktLi9dezE2fS8pKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKGBJbnZhbGlkIFNTTyBwZXJtaXNzaW9uIHNldCBBUk46ICR7cGVybWlzc2lvblNldEFybn1gKTtcbiAgfVxufTtcblxuZXhwb3J0IGZ1bmN0aW9uIHBlcm1pc3Npb25TZXRQYXJzZUFybihwZXJtaXNzaW9uU2V0QXJuOiBzdHJpbmcpOiBBcm5Db21wb25lbnRzIHtcbiAgdmFsaWRhdGVQZXJtaXNzaW9uU2V0QXJuKHBlcm1pc3Npb25TZXRBcm4pO1xuXG4gIHJldHVybiBBcm4uc3BsaXQocGVybWlzc2lvblNldEFybiwgQXJuRm9ybWF0LlNMQVNIX1JFU09VUkNFX05BTUUpO1xufTtcbiJdfQ==