[![FactSet](https://raw.githubusercontent.com/factset/enterprise-sdk/main/docs/images/factset-logo.svg)](https://www.factset.com)

# Optimization Engine API (Multi-period) client library for Python

[![API Version](https://img.shields.io/badge/api-v1-blue)]()
[![PyPi](https://img.shields.io/pypi/v/fds.sdk.OptimizationEngineAPIMultiperiod/0.21.14)](https://pypi.org/project/fds.sdk.OptimizationEngineAPIMultiperiod/v/0.21.14)
[![Apache-2 license](https://img.shields.io/badge/license-Apache2-brightgreen.svg)](https://www.apache.org/licenses/LICENSE-2.0)

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1
- SDK version: 0.21.14
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements

* Python >= 3.7

## Installation

### Poetry

```shell
poetry add fds.sdk.utils fds.sdk.OptimizationEngineAPIMultiperiod==0.21.14
```

### pip

```shell
pip install fds.sdk.utils fds.sdk.OptimizationEngineAPIMultiperiod==0.21.14
```

## Usage

1. [Generate authentication credentials](../../../../README.md#authentication).
2. Setup Python environment.
   1. Install and activate python 3.7+. If you're using [pyenv](https://github.com/pyenv/pyenv):

      ```sh
      pyenv install 3.9.7
      pyenv shell 3.9.7
      ```

   2. (optional) [Install poetry](https://python-poetry.org/docs/#installation).
3. [Install dependencies](#installation).
4. Run the following:

> [!IMPORTANT]
> The parameter variables defined below are just examples and may potentially contain non valid values. Please replace them with valid values.

### Example Code

```python
from fds.sdk.utils.authentication import ConfidentialClient

import fds.sdk.OptimizationEngineAPIMultiperiod
from fds.sdk.OptimizationEngineAPIMultiperiod.api import default_api
from fds.sdk.OptimizationEngineAPIMultiperiod.models import *
from dateutil.parser import parse as dateutil_parser
from pprint import pprint

# See configuration.py for a list of all supported configuration parameters.

# Examples for each supported authentication method are below,
# choose one that satisfies your use case.

# (Preferred) OAuth 2.0: FactSetOAuth2
# See https://github.com/FactSet/enterprise-sdk#oauth-20
# for information on how to create the app-config.json file
#
# The confidential client instance should be reused in production environments.
# See https://github.com/FactSet/enterprise-sdk-utils-python#authentication
# for more information on using the ConfidentialClient class
configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(
    fds_oauth_client=ConfidentialClient('/path/to/app-config.json')
)

# Basic authentication: FactSetApiKey
# See https://github.com/FactSet/enterprise-sdk#api-key
# for information how to create an API key
# configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(
#     username='USERNAME-SERIAL',
#     password='API-KEY'
# )

# Enter a context with an instance of the API client
with fds.sdk.OptimizationEngineAPIMultiperiod.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = default_api.DefaultApi(api_client)
    multi_period_input = OptimizerInputsMultiPeriodInput(
        strategy=OptimizerInputsMultiPeriodStrategy(
            objective=OptimizerInputsMultiPeriodObjective(
                factor_exposure=[
                    OptimizerInputsMPFactorExposureTerm(
                        term=OptimizerInputsFactorExposureTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            factors=[
                                "factors_example",
                            ],
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                volatility=[
                    OptimizerInputsMPVolatilityTerm(
                        term=OptimizerInputsVolatilityTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            risk_type=OptimizerInputsEObjectiveRiskTypeEnum(0),
                            factors=[
                                "factors_example",
                            ],
                            active_risk=True,
                            benchmark_index=1,
                        ),
                        term_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                general_linear=[
                    OptimizerInputsMPGeneralLinearTerm(
                        term=OptimizerInputsGeneralLinearTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            attribute=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            method=OptimizerInputsEAggregationMethodEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                expected_return=[
                    OptimizerInputsMPExpectedReturnTerm(
                        term=OptimizerInputsExpectedReturnTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            return_values=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            use_alpha=True,
                            rel_to_benchmark=True,
                            benchmark_index=1,
                        ),
                        term_on=OptimizerInputsBoundSourceEnum(0),
                        annualization_factor=3.14,
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                sensitivity=[
                    OptimizerInputsMPSensitivityTerm(
                        term=OptimizerInputsSensitivityTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            sensitivity_attribute=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                objective_ratio=OptimizerInputsMPObjectiveRatioTerm(
                    sharpe_ratio=OptimizerInputsSharpeRatioTerm(
                        name="name_example",
                        multiplier=OptimizerInputsValue(
                            value_type=OptimizerInputsEValueTypeEnum(0),
                            raw_value=3.14,
                            ref_index=1,
                        ),
                        risk_free_rate=OptimizerInputsValue(
                            value_type=OptimizerInputsEValueTypeEnum(0),
                            raw_value=3.14,
                            ref_index=1,
                        ),
                        direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                        active_risk=True,
                        benchmark_index=1,
                    ),
                    starr=OptimizerInputsSTARRTerm(
                        name="name_example",
                        multiplier=OptimizerInputsValue(
                            value_type=OptimizerInputsEValueTypeEnum(0),
                            raw_value=3.14,
                            ref_index=1,
                        ),
                        risk_free_rate=OptimizerInputsValue(
                            value_type=OptimizerInputsEValueTypeEnum(0),
                            raw_value=3.14,
                            ref_index=1,
                        ),
                        direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                        confidence_level=3.14,
                        use_centered_etl=True,
                        active_risk=True,
                        benchmark_index=1,
                    ),
                    diversification_ratio=OptimizerInputsDiversificationRatioTerm(
                        name="name_example",
                        multiplier=OptimizerInputsValue(
                            value_type=OptimizerInputsEValueTypeEnum(0),
                            raw_value=3.14,
                            ref_index=1,
                        ),
                        direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                    ),
                    on_periods=OptimizerInputsOnPeriods(
                        periods=[
                            1,
                        ],
                    ),
                    across_periods=OptimizerInputsAcrossPeriods(
                        start_period=1,
                        end_period=1,
                        rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                            frequency=1,
                            method=OptimizerInputsRollingMethodEnum(0),
                        ),
                    ),
                ),
                tail_risk=[
                    OptimizerInputsMPTailRiskTerm(
                        term=OptimizerInputsTailRiskTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            risk_measure=OptimizerInputsTailRiskMeasureEnum(0),
                            confidence_level=3.14,
                            use_centered_etl=True,
                            active_risk=True,
                            benchmark_index=1,
                        ),
                        term_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                target_probability=[
                    OptimizerInputsMPTargetProbabilityTerm(
                        term=OptimizerInputsTargetProbabilityTerm(
                            name="name_example",
                            multiplier=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            direction=OptimizerInputsEObjectiveTermDirectionEnum(0),
                            threshold_min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            threshold_max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                        ),
                        constrain_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
            ),
            constraints=OptimizerInputsMultiPeriodConstraints(
                expected_returns=[
                    OptimizerInputsMPExpectedReturnConstraint(
                        constraint=OptimizerInputsExpectedReturnConstraint(
                            name="name_example",
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            return_value=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            use_strategy_return_value=True,
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            return_type=OptimizerInputsEConstraintReturnTypeEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                            hierarchy=1,
                        ),
                        constraint_on=OptimizerInputsBoundSourceEnum(0),
                        annualization_factor=3.14,
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                diversification=[
                    OptimizerInputsMPDiversificationConstraint(
                        constraint=OptimizerInputsDiversificationConstraint(
                            name="name_example",
                            asset_value=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max_percent=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            unit=OptimizerInputsEConstraintUnitTypeEnum(0),
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                factor_exposures=[
                    OptimizerInputsMPFactorExposureConstraint(
                        constraint=OptimizerInputsFactorExposureConstraint(
                            name="name_example",
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                            factors=OptimizerInputsFactorExposureAttributes(
                                min=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            hierarchy=1,
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                general_linear=[
                    OptimizerInputsMPGeneralLinearConstraint(
                        constraint=OptimizerInputsGeneralLinearConstraint(
                            name="name_example",
                            security_attribute=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            weighting_method=OptimizerInputsEWeightingMethodTypeEnum(0),
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            hierarchy=1,
                            rel_to_benchmark=True,
                            benchmark_index=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                holding_threshold=[
                    OptimizerInputsMPHoldingsThresholdConstraint(
                        constraint=OptimizerInputsHoldingsThresholdConstraint(
                            name="name_example",
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            unit=OptimizerInputsEConstraintUnitTypeEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                leverage=[
                    OptimizerInputsMPLeverageConstraint(
                        constraint=OptimizerInputsLeverageConstraint(
                            name="name_example",
                            value=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            value_type=OptimizerInputsELeverageValueTypeEnum(0),
                            hierarchy=1,
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                num_of_assets=[
                    OptimizerInputsMPNumberofAssetsConstraint(
                        constraint=OptimizerInputsNumberofAssetsConstraint(
                            name="name_example",
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                sensitivity=[
                    OptimizerInputsMPSensitivityConstraint(
                        constraint=OptimizerInputsSensitivityConstraint(
                            name="name_example",
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            sensitivity_attribute=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                            hierarchy=1,
                            unit=OptimizerInputsEConstraintUnitTypeEnum(0),
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                weight_constraint=[
                    OptimizerInputsMPHoldingsWeightConstraint(
                        constraint=OptimizerInputsHoldingsWeightConstraint(
                            name="name_example",
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            unit=OptimizerInputsEConstraintUnitTypeEnum(0),
                            weight_type=OptimizerInputsEFPOConstraintWeightTypeEnum(0),
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            rel_to_benchmark=True,
                            benchmark_index=1,
                            hierarchy=1,
                            apply_only_to_direct=True,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                number_of_buys=[
                    OptimizerInputsMPNumberOfBuysConstraint(
                        constraint=OptimizerInputsNumberOfBuysConstraint(
                            name="name_example",
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                number_of_sells=[
                    OptimizerInputsMPNumberOfSellsConstraint(
                        constraint=OptimizerInputsNumberOfSellsConstraint(
                            name="name_example",
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                round_lots=[
                    OptimizerInputsMPRoundlotsConstraint(
                        constraint=OptimizerInputsRoundlotsConstraint(
                            name="name_example",
                            asset_level=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            general_value=3.14,
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                trade_threshold=[
                    OptimizerInputsMPTradeThresholdConstraint(
                        constraint=OptimizerInputsTradeThresholdConstraint(
                            name="name_example",
                            min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            unit=OptimizerInputsEConstraintUnitTypeEnum(0),
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                trading_turnover=[
                    OptimizerInputsMPTurnoverConstraint(
                        constraint=OptimizerInputsTurnoverConstraint(
                            name="name_example",
                            max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            value_type=OptimizerInputsEConstraintValueTypeEnum(0),
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            turnover_type=OptimizerInputsEConstraintTurnoverTypeEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                risk_contribution=[
                    OptimizerInputsMPRiskContributionConstraint(
                        constraint=OptimizerInputsRiskContributionConstraint(
                            name="name_example",
                            max_percent=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            custom_asset=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            asset_type=OptimizerInputsEFPOConstraintAssetTypeEnum(0),
                            risk_type=OptimizerInputsEConstraintRiskTypeEnum(0),
                            hierarchy=1,
                        ),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                    ),
                ],
                risk_volatility=[
                    OptimizerInputsMPRiskVolatilityConstraint(
                        constraint=OptimizerInputsRiskVolatilityConstraint(
                            name="name_example",
                            max_value_of_risk=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            level=OptimizerInputsEConstraintLevelEnum(0),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            groups=[
                                OptimizerInputsConstraintGroup(
                                    min=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    max=OptimizerInputsValue(
                                        value_type=OptimizerInputsEValueTypeEnum(0),
                                        raw_value=3.14,
                                        ref_index=1,
                                    ),
                                    id="id_example",
                                    nested_groups=[],
                                    group_lookup_index=1,
                                ),
                            ],
                            risk_type=OptimizerInputsEConstraintRiskTypeEnum(0),
                            active_risk=True,
                            benchmark_index=1,
                            hierarchy=1,
                        ),
                        constraint_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                tail_risk=[
                    OptimizerInputsMPLimitTailRiskConstraint(
                        constraint=OptimizerInputsLimitTailRiskConstraint(
                            name="name_example",
                            risk_measure=OptimizerInputsTailRiskMeasureEnum(0),
                            max_risk=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            confidence_level=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            penalty=OptimizerInputsPenalty(
                                enabled=True,
                                penalty_type=OptimizerInputsEConstraintPenaltyTypeEnum(0),
                                penalty_value=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                                max_violation=OptimizerInputsValue(
                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                    raw_value=3.14,
                                    ref_index=1,
                                ),
                            ),
                            active_risk=True,
                            benchmark_index=1,
                            hierarchy=1,
                        ),
                        constraint_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
                target_probability=[
                    OptimizerInputsMPTargetProbabilityConstraint(
                        constraint=OptimizerInputsTargetProbabilityConstraint(
                            name="name_example",
                            threshold_min=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            threshold_max=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            min_probability=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            max_probability=OptimizerInputsValue(
                                value_type=OptimizerInputsEValueTypeEnum(0),
                                raw_value=3.14,
                                ref_index=1,
                            ),
                            hierarchy=1,
                        ),
                        constraint_on=OptimizerInputsBoundSourceEnum(0),
                        on_periods=OptimizerInputsOnPeriods(
                            periods=[
                                1,
                            ],
                        ),
                        across_periods=OptimizerInputsAcrossPeriods(
                            start_period=1,
                            end_period=1,
                            rolling=OptimizerInputsAcrossPeriodsRollingPeriods(
                                frequency=1,
                                method=OptimizerInputsRollingMethodEnum(0),
                            ),
                        ),
                    ),
                ],
            ),
            transaction_cost=OptimizerInputsTransactionCost(
                unit_type=OptimizerInputsETransactionCostUnitTypeEnum(0),
                buy_cost=OptimizerInputsValue(
                    value_type=OptimizerInputsEValueTypeEnum(0),
                    raw_value=3.14,
                    ref_index=1,
                ),
                sell_cost=OptimizerInputsValue(
                    value_type=OptimizerInputsEValueTypeEnum(0),
                    raw_value=3.14,
                    ref_index=1,
                ),
            ),
            options=OptimizerInputsMultiPeriodOptions(
                options=OptimizerInputsOptions(
                    max_run_time=1,
                    convergence_tolerance=3.14,
                    cash_flow_formula=OptimizerInputsValue(
                        value_type=OptimizerInputsEValueTypeEnum(0),
                        raw_value=3.14,
                        ref_index=1,
                    ),
                    convert_weights_to_cash_for_ip=True,
                    convert_weights_to_cash_for_bmk=True,
                    composite_asset_lookthrough_level=1,
                ),
                weight_rebalance_periods=[
                    1,
                ],
                total_periods_count=1,
                initial_point_randomization_count=1,
            ),
            expected_return=OptimizerInputsExpectedReturn(
                alpha=OptimizerInputsValue(
                    value_type=OptimizerInputsEValueTypeEnum(0),
                    raw_value=3.14,
                    ref_index=1,
                ),
                alpha_unit=OptimizerInputsEAlphaUnitTypeEnum(0),
            ),
        ),
        universe=OptimizerInputsTotalUniverse(
            assets=[
                OptimizerInputsAsset(
                    symbol="symbol_example",
                    price=3.14,
                ),
            ],
            composite_assets=OptimizerInputsCompositeAsset(
                constituents=[
                    OptimizerInputsCompositeConstituent(
                        univ_index=1,
                        weight=3.14,
                        price=OptimizerInputsAssetPrice(
                            source=OptimizerInputsAssetPriceEPriceSource(0),
                            price_override=3.14,
                        ),
                    ),
                ],
            ),
            derivatives=OptimizerInputsDerivative(
                offset_index=1,
                future=OptimizerInputsDerivativeFuture(
                    contract_size=3.14,
                    method=OptimizerInputsDerivativeFutureEComputationMethodEnum(0),
                    using_pa_multiply=True,
                ),
                forward=True,
            ),
        ),
        portfolios=OptimizerInputsPortfolios(
            initial=OptimizerInputsPortfolio(
                holdings=[
                    OptimizerInputsPortfolioItem(
                        univ_index=1,
                        price=OptimizerInputsAssetPrice(
                            source=OptimizerInputsAssetPriceEPriceSource(0),
                            price_override=3.14,
                        ),
                        shares=3.14,
                    ),
                ],
            ),
            benchmarks=[
                OptimizerInputsPortfolio(
                    holdings=[
                        OptimizerInputsPortfolioItem(
                            univ_index=1,
                            price=OptimizerInputsAssetPrice(
                                source=OptimizerInputsAssetPriceEPriceSource(0),
                                price_override=3.14,
                            ),
                            shares=3.14,
                        ),
                    ],
                ),
            ],
            buylist=[
                OptimizerInputsBuyListItem(
                    univ_index=1,
                    price=OptimizerInputsAssetPrice(
                        source=OptimizerInputsAssetPriceEPriceSource(0),
                        price_override=3.14,
                    ),
                ),
            ],
            cash_univ_index=1,
        ),
        riskmodels=OptimizerInputsMultiPeriodRiskModels(
            risk_models=[
                OptimizerInputsRiskModelForPeriods(
                    risk_model=OptimizerInputsRiskModel(
                        simulated_risk_model=OptimizerInputsSimulatedRiskModel(
                            raw_data=VARDistributionDataMessage(
                                description=VARDistributionDescription(
                                    risk_model="risk_model_example",
                                    factor_group="factor_group_example",
                                    factors=[
                                        "factors_example",
                                    ],
                                    distribution_type=VARDistributionType(0),
                                    report_date=1,
                                    report_currency="report_currency_example",
                                    horizon_in_trading_days=3.14,
                                    return_dates=[
                                        1,
                                    ],
                                ),
                                security_simulations=[
                                    VARSimulatedReturns(
                                        entity="entity_example",
                                        returns=[
                                            3.14,
                                        ],
                                    ),
                                ],
                                status=VARDistributionStatus(
                                    indicator=VARStatusIndicator(0),
                                    message="message_example",
                                ),
                            ),
                            request_info=OptimizerInputsSimulatedRiskRequestInfo(
                                url="url_example",
                                lima_header="lima_header_example",
                            ),
                        ),
                        quant_risk_model=OptimizerInputsQuantRiskModel(
                            raw_data=OptimizerInputsQuantRiskModelRawData(
                                labels=OptimizerInputsLabels(
                                    factor=OptimizerInputsFactor(
                                        ids=[
                                            "ids_example",
                                        ],
                                        names=[
                                            "names_example",
                                        ],
                                    ),
                                    security=OptimizerInputsSecurity(
                                        ids=[
                                            "ids_example",
                                        ],
                                    ),
                                ),
                                raw_asset_covariance_matrix=OptimizerInputsSparseMatrix(
                                    rows=1,
                                    columns=1,
                                    index_pointer=[
                                        1,
                                    ],
                                    indices=[
                                        1,
                                    ],
                                    value=[
                                        3.14,
                                    ],
                                ),
                                raw_factor_exposure=OptimizerInputsSparseMatrix(
                                    rows=1,
                                    columns=1,
                                    index_pointer=[
                                        1,
                                    ],
                                    indices=[
                                        1,
                                    ],
                                    value=[
                                        3.14,
                                    ],
                                ),
                                raw_factor_covariance_matrix=OptimizerInputsDenseMatrix(
                                    value=[
                                        GoogleProtobufListValue(
                                            values=[
                                                OptimizerInputsValue(
                                                    value_type=OptimizerInputsEValueTypeEnum(0),
                                                    raw_value=3.14,
                                                    ref_index=1,
                                                ),
                                            ],
                                        ),
                                    ],
                                ),
                                risk_model_coverage_flag=[
                                    1,
                                ],
                            ),
                            request_info=OptimizerInputsQuantRiskRequestInfo(
                                service_url="service_url_example",
                                json_post_body="json_post_body_example",
                                lima_header="lima_header_example",
                                pickup_base_url="pickup_base_url_example",
                            ),
                        ),
                        raw_model=OptimizerInputsRawRiskModel(
                            simulations=[
                                OptimizerInputsRawRiskModelSimulations(
                                    id="id_example",
                                    simulated_returns=[
                                        3.14,
                                    ],
                                ),
                            ],
                        ),
                    ),
                    periods=OptimizerInputsOnPeriods(
                        periods=[
                            1,
                        ],
                    ),
                ),
            ],
        ),
        lookup_tables=OptimizerInputsLookupTables(
            groups=[
                OptimizerInputsGroupDefinition(
                    univ_indices=[
                        1,
                    ],
                ),
            ],
            values=[
                OptimizerInputsValueReference(
                    asset_values=3.14,
                ),
            ],
        ),
        output_statistics=True,
    ) # OptimizerInputsMultiPeriodInput | Multiperiod protobuf input (optional)

    try:
        # example passing only required values which don't have defaults set
        # and optional values
        api_response = api_instance.mpo_v1_optimize_fpo_post(multi_period_input=multi_period_input)

        pprint(api_response)
    except fds.sdk.OptimizationEngineAPIMultiperiod.ApiException as e:
        print("Exception when calling DefaultApi->mpo_v1_optimize_fpo_post: %s\n" % e)

    # # Get response, http status code and response headers
    # try:
    #     api_response, http_status_code, response_headers = api_instance.mpo_v1_optimize_fpo_post_with_http_info(multi_period_input=multi_period_input)


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.OptimizationEngineAPIMultiperiod.ApiException as e:
    #     print("Exception when calling DefaultApi->mpo_v1_optimize_fpo_post: %s\n" % e)

    # # Get response asynchronous
    # try:
    #     async_result = api_instance.mpo_v1_optimize_fpo_post_async(multi_period_input=multi_period_input)
    #     api_response = async_result.get()


    #     pprint(api_response)
    # except fds.sdk.OptimizationEngineAPIMultiperiod.ApiException as e:
    #     print("Exception when calling DefaultApi->mpo_v1_optimize_fpo_post: %s\n" % e)

    # # Get response, http status code and response headers asynchronous
    # try:
    #     async_result = api_instance.mpo_v1_optimize_fpo_post_with_http_info_async(multi_period_input=multi_period_input)
    #     api_response, http_status_code, response_headers = async_result.get()


    #     pprint(api_response)
    #     pprint(http_status_code)
    #     pprint(response_headers)
    # except fds.sdk.OptimizationEngineAPIMultiperiod.ApiException as e:
    #     print("Exception when calling DefaultApi->mpo_v1_optimize_fpo_post: %s\n" % e)

```

### Using Pandas

To convert an API response to a Pandas DataFrame, it is necessary to transform it first to a dictionary.
```python
import pandas as pd

response_dict = api_response.to_dict()['data']

simple_json_response = pd.DataFrame(response_dict)
nested_json_response = pd.json_normalize(response_dict)
```

### Debugging

The SDK uses the standard library [`logging`](https://docs.python.org/3/library/logging.html#module-logging) module.

Setting `debug` to `True` on an instance of the `Configuration` class sets the log-level of related packages to `DEBUG`
and enables additional logging in Pythons [HTTP Client](https://docs.python.org/3/library/http.client.html).

**Note**: This prints out sensitive information (e.g. the full request and response). Use with care.

```python
import logging
import fds.sdk.OptimizationEngineAPIMultiperiod

logging.basicConfig(level=logging.DEBUG)

configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(...)
configuration.debug = True
```

### Configure a Proxy

You can pass proxy settings to the Configuration class:

* `proxy`: The URL of the proxy to use.
* `proxy_headers`: a dictionary to pass additional headers to the proxy (e.g. `Proxy-Authorization`).

```python
import fds.sdk.OptimizationEngineAPIMultiperiod

configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(
    # ...
    proxy="http://secret:password@localhost:5050",
    proxy_headers={
        "Custom-Proxy-Header": "Custom-Proxy-Header-Value"
    }
)
```

### Custom SSL Certificate

TLS/SSL certificate verification can be configured with the following Configuration parameters:

* `ssl_ca_cert`: a path to the certificate to use for verification in `PEM` format.
* `verify_ssl`: setting this to `False` disables the verification of certificates.
  Disabling the verification is not recommended, but it might be useful during
  local development or testing.

```python
import fds.sdk.OptimizationEngineAPIMultiperiod

configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(
    # ...
    ssl_ca_cert='/path/to/ca.pem'
)
```

### Request Retries

In case the request retry behaviour should be customized, it is possible to pass a `urllib3.Retry` object to the `retry` property of the Configuration.

```python
from urllib3 import Retry
import fds.sdk.OptimizationEngineAPIMultiperiod

configuration = fds.sdk.OptimizationEngineAPIMultiperiod.Configuration(
    # ...
)

configuration.retries = Retry(total=3, status_forcelist=[500, 502, 503, 504])
```


## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**mpo_v1_optimize_fpo_post**](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/DefaultApi.md#mpo_v1_optimize_fpo_post) | **POST** /mpo/v1/optimizeFPO | 


## Documentation For Models

 - [GoogleProtobufListValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/GoogleProtobufListValue.md)
 - [GoogleProtobufNullValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/GoogleProtobufNullValue.md)
 - [GoogleProtobufStruct](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/GoogleProtobufStruct.md)
 - [GoogleProtobufValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/GoogleProtobufValue.md)
 - [OptimizerInputsAcrossPeriods](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsAcrossPeriods.md)
 - [OptimizerInputsAcrossPeriodsRollingPeriods](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsAcrossPeriodsRollingPeriods.md)
 - [OptimizerInputsAsset](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsAsset.md)
 - [OptimizerInputsAssetPrice](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsAssetPrice.md)
 - [OptimizerInputsAssetPriceEPriceSource](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsAssetPriceEPriceSource.md)
 - [OptimizerInputsBoundSourceEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsBoundSourceEnum.md)
 - [OptimizerInputsBuyListItem](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsBuyListItem.md)
 - [OptimizerInputsCompositeAsset](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsCompositeAsset.md)
 - [OptimizerInputsCompositeConstituent](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsCompositeConstituent.md)
 - [OptimizerInputsConstraintGroup](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsConstraintGroup.md)
 - [OptimizerInputsConstraints](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsConstraints.md)
 - [OptimizerInputsDenseMatrix](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDenseMatrix.md)
 - [OptimizerInputsDerivative](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDerivative.md)
 - [OptimizerInputsDerivativeFuture](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDerivativeFuture.md)
 - [OptimizerInputsDerivativeFutureEComputationMethodEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDerivativeFutureEComputationMethodEnum.md)
 - [OptimizerInputsDiversificationConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDiversificationConstraint.md)
 - [OptimizerInputsDiversificationRatioTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDiversificationRatioTerm.md)
 - [OptimizerInputsDrawdownTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsDrawdownTerm.md)
 - [OptimizerInputsEAggregationMethodEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEAggregationMethodEnum.md)
 - [OptimizerInputsEAlphaUnitTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEAlphaUnitTypeEnum.md)
 - [OptimizerInputsEConstraintGroupTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintGroupTypeEnum.md)
 - [OptimizerInputsEConstraintLevelEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintLevelEnum.md)
 - [OptimizerInputsEConstraintPenaltyTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintPenaltyTypeEnum.md)
 - [OptimizerInputsEConstraintReturnTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintReturnTypeEnum.md)
 - [OptimizerInputsEConstraintRiskRelativeInterpretationTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintRiskRelativeInterpretationTypeEnum.md)
 - [OptimizerInputsEConstraintRiskTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintRiskTypeEnum.md)
 - [OptimizerInputsEConstraintTurnoverTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintTurnoverTypeEnum.md)
 - [OptimizerInputsEConstraintUnitTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintUnitTypeEnum.md)
 - [OptimizerInputsEConstraintValueTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEConstraintValueTypeEnum.md)
 - [OptimizerInputsEFPOConstraintAssetTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEFPOConstraintAssetTypeEnum.md)
 - [OptimizerInputsEFPOConstraintWeightTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEFPOConstraintWeightTypeEnum.md)
 - [OptimizerInputsELeverageValueTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsELeverageValueTypeEnum.md)
 - [OptimizerInputsEObjectiveRiskTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEObjectiveRiskTypeEnum.md)
 - [OptimizerInputsEObjectiveTermDirectionEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEObjectiveTermDirectionEnum.md)
 - [OptimizerInputsETransactionCostUnitTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsETransactionCostUnitTypeEnum.md)
 - [OptimizerInputsEValueTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEValueTypeEnum.md)
 - [OptimizerInputsEWeightingMethodTypeEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsEWeightingMethodTypeEnum.md)
 - [OptimizerInputsExpectedReturn](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsExpectedReturn.md)
 - [OptimizerInputsExpectedReturnConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsExpectedReturnConstraint.md)
 - [OptimizerInputsExpectedReturnTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsExpectedReturnTerm.md)
 - [OptimizerInputsExpectedTailLossTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsExpectedTailLossTerm.md)
 - [OptimizerInputsFactor](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsFactor.md)
 - [OptimizerInputsFactorExposureAttributes](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsFactorExposureAttributes.md)
 - [OptimizerInputsFactorExposureConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsFactorExposureConstraint.md)
 - [OptimizerInputsFactorExposureTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsFactorExposureTerm.md)
 - [OptimizerInputsFrontierSettings](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsFrontierSettings.md)
 - [OptimizerInputsGeneralLinearConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsGeneralLinearConstraint.md)
 - [OptimizerInputsGeneralLinearTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsGeneralLinearTerm.md)
 - [OptimizerInputsGroupDefinition](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsGroupDefinition.md)
 - [OptimizerInputsHoldingsThresholdConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsHoldingsThresholdConstraint.md)
 - [OptimizerInputsHoldingsWeightConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsHoldingsWeightConstraint.md)
 - [OptimizerInputsLabels](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsLabels.md)
 - [OptimizerInputsLeverageConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsLeverageConstraint.md)
 - [OptimizerInputsLimitRiskETLConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsLimitRiskETLConstraint.md)
 - [OptimizerInputsLimitTailRiskConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsLimitTailRiskConstraint.md)
 - [OptimizerInputsLookupTables](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsLookupTables.md)
 - [OptimizerInputsMPDiversificationConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPDiversificationConstraint.md)
 - [OptimizerInputsMPExpectedReturnConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPExpectedReturnConstraint.md)
 - [OptimizerInputsMPExpectedReturnTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPExpectedReturnTerm.md)
 - [OptimizerInputsMPFactorExposureConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPFactorExposureConstraint.md)
 - [OptimizerInputsMPFactorExposureTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPFactorExposureTerm.md)
 - [OptimizerInputsMPFrontierInput](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPFrontierInput.md)
 - [OptimizerInputsMPGeneralLinearConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPGeneralLinearConstraint.md)
 - [OptimizerInputsMPGeneralLinearTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPGeneralLinearTerm.md)
 - [OptimizerInputsMPHoldingsThresholdConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPHoldingsThresholdConstraint.md)
 - [OptimizerInputsMPHoldingsWeightConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPHoldingsWeightConstraint.md)
 - [OptimizerInputsMPLeverageConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPLeverageConstraint.md)
 - [OptimizerInputsMPLimitTailRiskConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPLimitTailRiskConstraint.md)
 - [OptimizerInputsMPNumberOfBuysConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPNumberOfBuysConstraint.md)
 - [OptimizerInputsMPNumberOfSellsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPNumberOfSellsConstraint.md)
 - [OptimizerInputsMPNumberofAssetsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPNumberofAssetsConstraint.md)
 - [OptimizerInputsMPObjectiveRatioTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPObjectiveRatioTerm.md)
 - [OptimizerInputsMPRiskContributionConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPRiskContributionConstraint.md)
 - [OptimizerInputsMPRiskVolatilityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPRiskVolatilityConstraint.md)
 - [OptimizerInputsMPRoundlotsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPRoundlotsConstraint.md)
 - [OptimizerInputsMPSensitivityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPSensitivityConstraint.md)
 - [OptimizerInputsMPSensitivityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPSensitivityTerm.md)
 - [OptimizerInputsMPTailRiskTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTailRiskTerm.md)
 - [OptimizerInputsMPTargetProbabilityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTargetProbabilityConstraint.md)
 - [OptimizerInputsMPTargetProbabilityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTargetProbabilityTerm.md)
 - [OptimizerInputsMPTradeThresholdConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTradeThresholdConstraint.md)
 - [OptimizerInputsMPTransactionCostConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTransactionCostConstraint.md)
 - [OptimizerInputsMPTurnoverConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPTurnoverConstraint.md)
 - [OptimizerInputsMPVolatilityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMPVolatilityTerm.md)
 - [OptimizerInputsMultiPeriodConstraints](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodConstraints.md)
 - [OptimizerInputsMultiPeriodInput](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodInput.md)
 - [OptimizerInputsMultiPeriodObjective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodObjective.md)
 - [OptimizerInputsMultiPeriodOptions](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodOptions.md)
 - [OptimizerInputsMultiPeriodRiskModels](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodRiskModels.md)
 - [OptimizerInputsMultiPeriodStrategy](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsMultiPeriodStrategy.md)
 - [OptimizerInputsNumberOfBuysConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsNumberOfBuysConstraint.md)
 - [OptimizerInputsNumberOfSellsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsNumberOfSellsConstraint.md)
 - [OptimizerInputsNumberofAssetsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsNumberofAssetsConstraint.md)
 - [OptimizerInputsObjective](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsObjective.md)
 - [OptimizerInputsOnPeriods](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsOnPeriods.md)
 - [OptimizerInputsOptions](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsOptions.md)
 - [OptimizerInputsPenalty](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsPenalty.md)
 - [OptimizerInputsPortfolio](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsPortfolio.md)
 - [OptimizerInputsPortfolioItem](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsPortfolioItem.md)
 - [OptimizerInputsPortfolios](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsPortfolios.md)
 - [OptimizerInputsQuantRiskModel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsQuantRiskModel.md)
 - [OptimizerInputsQuantRiskModelRawData](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsQuantRiskModelRawData.md)
 - [OptimizerInputsQuantRiskRequestInfo](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsQuantRiskRequestInfo.md)
 - [OptimizerInputsRange](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRange.md)
 - [OptimizerInputsRawRiskModel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRawRiskModel.md)
 - [OptimizerInputsRawRiskModelSimulations](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRawRiskModelSimulations.md)
 - [OptimizerInputsRiskContributionConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRiskContributionConstraint.md)
 - [OptimizerInputsRiskModel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRiskModel.md)
 - [OptimizerInputsRiskModelForPeriods](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRiskModelForPeriods.md)
 - [OptimizerInputsRiskParityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRiskParityTerm.md)
 - [OptimizerInputsRiskVolatilityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRiskVolatilityConstraint.md)
 - [OptimizerInputsRollingMethodEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRollingMethodEnum.md)
 - [OptimizerInputsRoundlotsConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsRoundlotsConstraint.md)
 - [OptimizerInputsSTARRTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSTARRTerm.md)
 - [OptimizerInputsSecurity](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSecurity.md)
 - [OptimizerInputsSensitivityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSensitivityConstraint.md)
 - [OptimizerInputsSensitivityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSensitivityTerm.md)
 - [OptimizerInputsSharpeRatioTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSharpeRatioTerm.md)
 - [OptimizerInputsSimulatedRiskModel](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSimulatedRiskModel.md)
 - [OptimizerInputsSimulatedRiskRequestInfo](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSimulatedRiskRequestInfo.md)
 - [OptimizerInputsSparseMatrix](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSparseMatrix.md)
 - [OptimizerInputsSpecificPoints](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsSpecificPoints.md)
 - [OptimizerInputsStartEndRange](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsStartEndRange.md)
 - [OptimizerInputsTailRiskMeasureEnum](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTailRiskMeasureEnum.md)
 - [OptimizerInputsTailRiskTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTailRiskTerm.md)
 - [OptimizerInputsTargetProbabilityConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTargetProbabilityConstraint.md)
 - [OptimizerInputsTargetProbabilityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTargetProbabilityTerm.md)
 - [OptimizerInputsTotalUniverse](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTotalUniverse.md)
 - [OptimizerInputsTradeThresholdConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTradeThresholdConstraint.md)
 - [OptimizerInputsTradingLimitTradeConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTradingLimitTradeConstraint.md)
 - [OptimizerInputsTransactionCost](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTransactionCost.md)
 - [OptimizerInputsTransactionCostConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTransactionCostConstraint.md)
 - [OptimizerInputsTransactionCostTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTransactionCostTerm.md)
 - [OptimizerInputsTurnoverConstraint](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsTurnoverConstraint.md)
 - [OptimizerInputsValue](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsValue.md)
 - [OptimizerInputsValueReference](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsValueReference.md)
 - [OptimizerInputsVolatilityTerm](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerInputsVolatilityTerm.md)
 - [OptimizerOutputsMultiPeriodOutput](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerOutputsMultiPeriodOutput.md)
 - [OptimizerOutputsPeriods](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/OptimizerOutputsPeriods.md)
 - [VARDistributionDataMessage](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARDistributionDataMessage.md)
 - [VARDistributionDescription](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARDistributionDescription.md)
 - [VARDistributionStatus](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARDistributionStatus.md)
 - [VARDistributionType](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARDistributionType.md)
 - [VARSimulatedReturns](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARSimulatedReturns.md)
 - [VARStatusIndicator](https://github.com/FactSet/enterprise-sdk/tree/main/code/python/OptimizationEngineAPIMultiperiod/v1/docs/VARStatusIndicator.md)


## Documentation For Authorization


## FactSetApiKey

- **Type**: HTTP basic authentication


## FactSetOAuth2

- **Type**: OAuth
- **Flow**: application
- **Authorization URL**: 
- **Scopes**: N/A


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in fds.sdk.OptimizationEngineAPIMultiperiod.apis and fds.sdk.OptimizationEngineAPIMultiperiod.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from fds.sdk.OptimizationEngineAPIMultiperiod.api.default_api import DefaultApi`
- `from fds.sdk.OptimizationEngineAPIMultiperiod.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import fds.sdk.OptimizationEngineAPIMultiperiod
from fds.sdk.OptimizationEngineAPIMultiperiod.apis import *
from fds.sdk.OptimizationEngineAPIMultiperiod.models import *
```

## Contributing

Please refer to the [contributing guide](../../../../CONTRIBUTING.md).

## Copyright

Copyright 2022 FactSet Research Systems Inc

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

