module.exports = function tidy_html5(text, config) {
    FS.writeFile("input.html", text);
    var cmdlineOptions = [];
    if (config)
        for (var i in config) cmdlineOptions.push("--" + i, config[i]);
    cmdlineOptions.push("-m", "input.html");
    Module.callMain(cmdlineOptions);
    return FS.readFile("input.html", {
        encoding: "utf8"
    })
};
var Module = {
    noInitialRun: true,
    noExitRuntime: true
};
var Module;
if (!Module) Module = (typeof Module !== "undefined" ? Module : null) || {};
var moduleOverrides = {};
for (var key in Module) {
    if (Module.hasOwnProperty(key)) {
        moduleOverrides[key] = Module[key]
    }
}
var ENVIRONMENT_IS_NODE = false;
var ENVIRONMENT_IS_WEB = true;
var ENVIRONMENT_IS_WORKER = false;
var ENVIRONMENT_IS_SHELL = false;
    Module["read"] = function read(url) {
        var xhr = new XMLHttpRequest;
        xhr.open("GET", url, false);
        xhr.send(null);
        return xhr.responseText
    };
    if (typeof arguments != "undefined") {
        Module["arguments"] = arguments
    }
    if (typeof console !== "undefined") {
        if (!Module["print"]) Module["print"] = function print(x) {
            console.log(x)
        };
        if (!Module["printErr"]) Module["printErr"] = function printErr(x) {
            console.log(x)
        }
    } else {
        var TRY_USE_DUMP = false;
        if (!Module["print"]) Module["print"] = TRY_USE_DUMP && typeof dump !== "undefined" ? (function(x) {
            dump(x)
        }) : (function(x) {})
    }
    if (ENVIRONMENT_IS_WEB) {
        window["Module"] = Module
    } else {
        Module["load"] = importScripts
    }

function globalEval(x) {
    eval.call(null, x)
}
if (!Module["load"] && Module["read"]) {
    Module["load"] = function load(f) {
        globalEval(Module["read"](f))
    }
}
if (!Module["print"]) {
    Module["print"] = (function() {})
}
if (!Module["printErr"]) {
    Module["printErr"] = Module["print"]
}
if (!Module["arguments"]) {
    Module["arguments"] = []
}
if (!Module["thisProgram"]) {
    Module["thisProgram"] = "./this.program"
}
Module.print = Module["print"];
Module.printErr = Module["printErr"];
Module["preRun"] = [];
Module["postRun"] = [];
for (var key in moduleOverrides) {
    if (moduleOverrides.hasOwnProperty(key)) {
        Module[key] = moduleOverrides[key]
    }
}
var Runtime = {
    setTempRet0: (function(value) {
        tempRet0 = value
    }),
    getTempRet0: (function() {
        return tempRet0
    }),
    stackSave: (function() {
        return STACKTOP
    }),
    stackRestore: (function(stackTop) {
        STACKTOP = stackTop
    }),
    getNativeTypeSize: (function(type) {
        switch (type) {
            case "i1":
            case "i8":
                return 1;
            case "i16":
                return 2;
            case "i32":
                return 4;
            case "i64":
                return 8;
            case "float":
                return 4;
            case "double":
                return 8;
            default:
                {
                    if (type[type.length - 1] === "*") {
                        return Runtime.QUANTUM_SIZE
                    } else if (type[0] === "i") {
                        var bits = parseInt(type.substr(1));
                        assert(bits % 8 === 0);
                        return bits / 8
                    } else {
                        return 0
                    }
                }
        }
    }),
    getNativeFieldSize: (function(type) {
        return Math.max(Runtime.getNativeTypeSize(type), Runtime.QUANTUM_SIZE)
    }),
    STACK_ALIGN: 16,
    getAlignSize: (function(type, size, vararg) {
        if (!vararg && (type == "i64" || type == "double")) return 8;
        if (!type) return Math.min(size, 8);
        return Math.min(size || (type ? Runtime.getNativeFieldSize(type) : 0), Runtime.QUANTUM_SIZE)
    }),
    dynCall: (function(sig, ptr, args) {
        if (args && args.length) {
            if (!args.splice) args = Array.prototype.slice.call(args);
            args.splice(0, 0, ptr);
            return Module["dynCall_" + sig].apply(null, args)
        } else {
            return Module["dynCall_" + sig].call(null, ptr)
        }
    }),
    functionPointers: [],
    addFunction: (function(func) {
        for (var i = 0; i < Runtime.functionPointers.length; i++) {
            if (!Runtime.functionPointers[i]) {
                Runtime.functionPointers[i] = func;
                return 2 * (1 + i)
            }
        }
        throw "Finished up all reserved function pointers. Use a higher value for RESERVED_FUNCTION_POINTERS."
    }),
    removeFunction: (function(index) {
        Runtime.functionPointers[(index - 2) / 2] = null
    }),
    getAsmConst: (function(code, numArgs) {
        if (!Runtime.asmConstCache) Runtime.asmConstCache = {};
        var func = Runtime.asmConstCache[code];
        if (func) return func;
        var args = [];
        for (var i = 0; i < numArgs; i++) {
            args.push(String.fromCharCode(36) + i)
        }
        var source = Pointer_stringify(code);
        if (source[0] === '"') {
            if (source.indexOf('"', 1) === source.length - 1) {
                source = source.substr(1, source.length - 2)
            } else {
                abort("invalid EM_ASM input |" + source + "|. Please use EM_ASM(..code..) (no quotes) or EM_ASM({ ..code($0).. }, input) (to input values)")
            }
        }
        try {
            var evalled = eval("(function(Module, FS) { return function(" + args.join(",") + "){ " + source + " } })")(Module, typeof FS !== "undefined" ? FS : null)
        } catch (e) {
            Module.printErr("error in executing inline EM_ASM code: " + e + " on: \n\n" + source + "\n\nwith args |" + args + "| (make sure to use the right one out of EM_ASM, EM_ASM_ARGS, etc.)");
            throw e
        }
        return Runtime.asmConstCache[code] = evalled
    }),
    warnOnce: (function(text) {
        if (!Runtime.warnOnce.shown) Runtime.warnOnce.shown = {};
        if (!Runtime.warnOnce.shown[text]) {
            Runtime.warnOnce.shown[text] = 1;
            Module.printErr(text)
        }
    }),
    funcWrappers: {},
    getFuncWrapper: (function(func, sig) {
        assert(sig);
        if (!Runtime.funcWrappers[sig]) {
            Runtime.funcWrappers[sig] = {}
        }
        var sigCache = Runtime.funcWrappers[sig];
        if (!sigCache[func]) {
            sigCache[func] = function dynCall_wrapper() {
                return Runtime.dynCall(sig, func, arguments)
            }
        }
        return sigCache[func]
    }),
    UTF8Processor: (function() {
        var buffer = [];
        var needed = 0;
        this.processCChar = (function(code) {
            code = code & 255;
            if (buffer.length == 0) {
                if ((code & 128) == 0) {
                    return String.fromCharCode(code)
                }
                buffer.push(code);
                if ((code & 224) == 192) {
                    needed = 1
                } else if ((code & 240) == 224) {
                    needed = 2
                } else {
                    needed = 3
                }
                return ""
            }
            if (needed) {
                buffer.push(code);
                needed--;
                if (needed > 0) return ""
            }
            var c1 = buffer[0];
            var c2 = buffer[1];
            var c3 = buffer[2];
            var c4 = buffer[3];
            var ret;
            if (buffer.length == 2) {
                ret = String.fromCharCode((c1 & 31) << 6 | c2 & 63)
            } else if (buffer.length == 3) {
                ret = String.fromCharCode((c1 & 15) << 12 | (c2 & 63) << 6 | c3 & 63)
            } else {
                var codePoint = (c1 & 7) << 18 | (c2 & 63) << 12 | (c3 & 63) << 6 | c4 & 63;
                ret = String.fromCharCode(((codePoint - 65536) / 1024 | 0) + 55296, (codePoint - 65536) % 1024 + 56320)
            }
            buffer.length = 0;
            return ret
        });
        this.processJSString = function processJSString(string) {
            string = unescape(encodeURIComponent(string));
            var ret = [];
            for (var i = 0; i < string.length; i++) {
                ret.push(string.charCodeAt(i))
            }
            return ret
        }
    }),
    getCompilerSetting: (function(name) {
        throw "You must build with -s RETAIN_COMPILER_SETTINGS=1 for Runtime.getCompilerSetting or emscripten_get_compiler_setting to work"
    }),
    stackAlloc: (function(size) {
        var ret = STACKTOP;
        STACKTOP = STACKTOP + size | 0;
        STACKTOP = STACKTOP + 15 & -16;
        return ret
    }),
    staticAlloc: (function(size) {
        var ret = STATICTOP;
        STATICTOP = STATICTOP + size | 0;
        STATICTOP = STATICTOP + 15 & -16;
        return ret
    }),
    dynamicAlloc: (function(size) {
        var ret = DYNAMICTOP;
        DYNAMICTOP = DYNAMICTOP + size | 0;
        DYNAMICTOP = DYNAMICTOP + 15 & -16;
        if (DYNAMICTOP >= TOTAL_MEMORY) enlargeMemory();
        return ret
    }),
    alignMemory: (function(size, quantum) {
        var ret = size = Math.ceil(size / (quantum ? quantum : 16)) * (quantum ? quantum : 16);
        return ret
    }),
    makeBigInt: (function(low, high, unsigned) {
        var ret = unsigned ? +(low >>> 0) + +(high >>> 0) * +4294967296 : +(low >>> 0) + +(high | 0) * +4294967296;
        return ret
    }),
    GLOBAL_BASE: 8,
    QUANTUM_SIZE: 4,
    __dummy__: 0
};
Module["Runtime"] = Runtime;
var __THREW__ = 0;
var ABORT = false;
var EXITSTATUS = 0;
var undef = 0;
var tempValue, tempInt, tempBigInt, tempInt2, tempBigInt2, tempPair, tempBigIntI, tempBigIntR, tempBigIntS, tempBigIntP, tempBigIntD, tempDouble, tempFloat;
var tempI64, tempI64b;
var tempRet0, tempRet1, tempRet2, tempRet3, tempRet4, tempRet5, tempRet6, tempRet7, tempRet8, tempRet9;

function assert(condition, text) {
    if (!condition) {
        abort("Assertion failed: " + text)
    }
}
var globalScope = this;

function getCFunc(ident) {
    var func = Module["_" + ident];
    if (!func) {
        try {
            func = eval("_" + ident)
        } catch (e) {}
    }
    assert(func, "Cannot call unknown function " + ident + " (perhaps LLVM optimizations or closure removed it?)");
    return func
}
var cwrap, ccall;
((function() {
    var JSfuncs = {
        "arrayToC": (function(arr) {
            var ret = Runtime.stackAlloc(arr.length);
            writeArrayToMemory(arr, ret);
            return ret
        }),
        "stringToC": (function(str) {
            var ret = 0;
            if (str !== null && str !== undefined && str !== 0) {
                ret = Runtime.stackAlloc((str.length << 2) + 1);
                writeStringToMemory(str, ret)
            }
            return ret
        })
    };
    var toC = {
        "string": JSfuncs["stringToC"],
        "array": JSfuncs["arrayToC"]
    };
    ccall = function ccallFunc(ident, returnType, argTypes, args) {
        var func = getCFunc(ident);
        var cArgs = [];
        var stack = 0;
        if (args) {
            for (var i = 0; i < args.length; i++) {
                var converter = toC[argTypes[i]];
                if (converter) {
                    if (stack === 0) stack = Runtime.stackSave();
                    cArgs[i] = converter(args[i])
                } else {
                    cArgs[i] = args[i]
                }
            }
        }
        var ret = func.apply(null, cArgs);
        if (returnType === "string") ret = Pointer_stringify(ret);
        if (stack !== 0) Runtime.stackRestore(stack);
        return ret
    };
    var sourceRegex = /^function\s*\(([^)]*)\)\s*{\s*([^*]*?)[\s;]*(?:return\s*(.*?)[;\s]*)?}$/;

    function parseJSFunc(jsfunc) {
        var parsed = jsfunc.toString().match(sourceRegex).slice(1);
        return {
            arguments: parsed[0],
            body: parsed[1],
            returnValue: parsed[2]
        }
    }
    var JSsource = {};
    for (var fun in JSfuncs) {
        if (JSfuncs.hasOwnProperty(fun)) {
            JSsource[fun] = parseJSFunc(JSfuncs[fun])
        }
    }
    cwrap = function cwrap(ident, returnType, argTypes) {
        argTypes = argTypes || [];
        var cfunc = getCFunc(ident);
        var numericArgs = argTypes.every((function(type) {
            return type === "number"
        }));
        var numericRet = returnType !== "string";
        if (numericRet && numericArgs) {
            return cfunc
        }
        var argNames = argTypes.map((function(x, i) {
            return "$" + i
        }));
        var funcstr = "(function(" + argNames.join(",") + ") {";
        var nargs = argTypes.length;
        if (!numericArgs) {
            funcstr += "var stack = Runtime.stackSave();";
            for (var i = 0; i < nargs; i++) {
                var arg = argNames[i],
                    type = argTypes[i];
                if (type === "number") continue;
                var convertCode = JSsource[type + "ToC"];
                funcstr += "var " + convertCode.arguments + " = " + arg + ";";
                funcstr += convertCode.body + ";";
                funcstr += arg + "=" + convertCode.returnValue + ";"
            }
        }
        var cfuncname = parseJSFunc((function() {
            return cfunc
        })).returnValue;
        funcstr += "var ret = " + cfuncname + "(" + argNames.join(",") + ");";
        if (!numericRet) {
            var strgfy = parseJSFunc((function() {
                return Pointer_stringify
            })).returnValue;
            funcstr += "ret = " + strgfy + "(ret);"
        }
        if (!numericArgs) {
            funcstr += "Runtime.stackRestore(stack);"
        }
        funcstr += "return ret})";
        return eval(funcstr)
    }
}))();
Module["cwrap"] = cwrap;
Module["ccall"] = ccall;

function setValue(ptr, value, type, noSafe) {
    type = type || "i8";
    if (type.charAt(type.length - 1) === "*") type = "i32";
    switch (type) {
        case "i1":
            HEAP8[ptr >> 0] = value;
            break;
        case "i8":
            HEAP8[ptr >> 0] = value;
            break;
        case "i16":
            HEAP16[ptr >> 1] = value;
            break;
        case "i32":
            HEAP32[ptr >> 2] = value;
            break;
        case "i64":
            tempI64 = [value >>> 0, (tempDouble = value, +Math_abs(tempDouble) >= +1 ? tempDouble > +0 ? (Math_min(+Math_floor(tempDouble / +4294967296), +4294967295) | 0) >>> 0 : ~~+Math_ceil((tempDouble - +(~~tempDouble >>> 0)) / +4294967296) >>> 0 : 0)], HEAP32[ptr >> 2] = tempI64[0], HEAP32[ptr + 4 >> 2] = tempI64[1];
            break;
        case "float":
            HEAPF32[ptr >> 2] = value;
            break;
        case "double":
            HEAPF64[ptr >> 3] = value;
            break;
        default:
            abort("invalid type for setValue: " + type)
    }
}
Module["setValue"] = setValue;

function getValue(ptr, type, noSafe) {
    type = type || "i8";
    if (type.charAt(type.length - 1) === "*") type = "i32";
    switch (type) {
        case "i1":
            return HEAP8[ptr >> 0];
        case "i8":
            return HEAP8[ptr >> 0];
        case "i16":
            return HEAP16[ptr >> 1];
        case "i32":
            return HEAP32[ptr >> 2];
        case "i64":
            return HEAP32[ptr >> 2];
        case "float":
            return HEAPF32[ptr >> 2];
        case "double":
            return HEAPF64[ptr >> 3];
        default:
            abort("invalid type for setValue: " + type)
    }
    return null
}
Module["getValue"] = getValue;
var ALLOC_NORMAL = 0;
var ALLOC_STACK = 1;
var ALLOC_STATIC = 2;
var ALLOC_DYNAMIC = 3;
var ALLOC_NONE = 4;
Module["ALLOC_NORMAL"] = ALLOC_NORMAL;
Module["ALLOC_STACK"] = ALLOC_STACK;
Module["ALLOC_STATIC"] = ALLOC_STATIC;
Module["ALLOC_DYNAMIC"] = ALLOC_DYNAMIC;
Module["ALLOC_NONE"] = ALLOC_NONE;

function allocate(slab, types, allocator, ptr) {
    var zeroinit, size;
    if (typeof slab === "number") {
        zeroinit = true;
        size = slab
    } else {
        zeroinit = false;
        size = slab.length
    }
    var singleType = typeof types === "string" ? types : null;
    var ret;
    if (allocator == ALLOC_NONE) {
        ret = ptr
    } else {
        ret = [_malloc, Runtime.stackAlloc, Runtime.staticAlloc, Runtime.dynamicAlloc][allocator === undefined ? ALLOC_STATIC : allocator](Math.max(size, singleType ? 1 : types.length))
    }
    if (zeroinit) {
        var ptr = ret,
            stop;
        assert((ret & 3) == 0);
        stop = ret + (size & ~3);
        for (; ptr < stop; ptr += 4) {
            HEAP32[ptr >> 2] = 0
        }
        stop = ret + size;
        while (ptr < stop) {
            HEAP8[ptr++ >> 0] = 0
        }
        return ret
    }
    if (singleType === "i8") {
        if (slab.subarray || slab.slice) {
            HEAPU8.set(slab, ret)
        } else {
            HEAPU8.set(new Uint8Array(slab), ret)
        }
        return ret
    }
    var i = 0,
        type, typeSize, previousType;
    while (i < size) {
        var curr = slab[i];
        if (typeof curr === "function") {
            curr = Runtime.getFunctionIndex(curr)
        }
        type = singleType || types[i];
        if (type === 0) {
            i++;
            continue
        }
        if (type == "i64") type = "i32";
        setValue(ret + i, curr, type);
        if (previousType !== type) {
            typeSize = Runtime.getNativeTypeSize(type);
            previousType = type
        }
        i += typeSize
    }
    return ret
}
Module["allocate"] = allocate;

function Pointer_stringify(ptr, length) {
    if (length === 0 || !ptr) return "";
    var hasUtf = false;
    var t;
    var i = 0;
    while (1) {
        t = HEAPU8[ptr + i >> 0];
        if (t >= 128) hasUtf = true;
        else if (t == 0 && !length) break;
        i++;
        if (length && i == length) break
    }
    if (!length) length = i;
    var ret = "";
    if (!hasUtf) {
        var MAX_CHUNK = 1024;
        var curr;
        while (length > 0) {
            curr = String.fromCharCode.apply(String, HEAPU8.subarray(ptr, ptr + Math.min(length, MAX_CHUNK)));
            ret = ret ? ret + curr : curr;
            ptr += MAX_CHUNK;
            length -= MAX_CHUNK
        }
        return ret
    }
    var utf8 = new Runtime.UTF8Processor;
    for (i = 0; i < length; i++) {
        t = HEAPU8[ptr + i >> 0];
        ret += utf8.processCChar(t)
    }
    return ret
}
Module["Pointer_stringify"] = Pointer_stringify;

function UTF16ToString(ptr) {
    var i = 0;
    var str = "";
    while (1) {
        var codeUnit = HEAP16[ptr + i * 2 >> 1];
        if (codeUnit == 0) return str;
        ++i;
        str += String.fromCharCode(codeUnit)
    }
}
Module["UTF16ToString"] = UTF16ToString;

function stringToUTF16(str, outPtr) {
    for (var i = 0; i < str.length; ++i) {
        var codeUnit = str.charCodeAt(i);
        HEAP16[outPtr + i * 2 >> 1] = codeUnit
    }
    HEAP16[outPtr + str.length * 2 >> 1] = 0
}
Module["stringToUTF16"] = stringToUTF16;

function UTF32ToString(ptr) {
    var i = 0;
    var str = "";
    while (1) {
        var utf32 = HEAP32[ptr + i * 4 >> 2];
        if (utf32 == 0) return str;
        ++i;
        if (utf32 >= 65536) {
            var ch = utf32 - 65536;
            str += String.fromCharCode(55296 | ch >> 10, 56320 | ch & 1023)
        } else {
            str += String.fromCharCode(utf32)
        }
    }
}
Module["UTF32ToString"] = UTF32ToString;

function stringToUTF32(str, outPtr) {
    var iChar = 0;
    for (var iCodeUnit = 0; iCodeUnit < str.length; ++iCodeUnit) {
        var codeUnit = str.charCodeAt(iCodeUnit);
        if (codeUnit >= 55296 && codeUnit <= 57343) {
            var trailSurrogate = str.charCodeAt(++iCodeUnit);
            codeUnit = 65536 + ((codeUnit & 1023) << 10) | trailSurrogate & 1023
        }
        HEAP32[outPtr + iChar * 4 >> 2] = codeUnit;
        ++iChar
    }
    HEAP32[outPtr + iChar * 4 >> 2] = 0
}
Module["stringToUTF32"] = stringToUTF32;

function demangle(func) {
    var hasLibcxxabi = !!Module["___cxa_demangle"];
    if (hasLibcxxabi) {
        try {
            var buf = _malloc(func.length);
            writeStringToMemory(func.substr(1), buf);
            var status = _malloc(4);
            var ret = Module["___cxa_demangle"](buf, 0, 0, status);
            if (getValue(status, "i32") === 0 && ret) {
                return Pointer_stringify(ret)
            }
        } catch (e) {} finally {
            if (buf) _free(buf);
            if (status) _free(status);
            if (ret) _free(ret)
        }
    }
    var i = 3;
    var basicTypes = {
        "v": "void",
        "b": "bool",
        "c": "char",
        "s": "short",
        "i": "int",
        "l": "long",
        "f": "float",
        "d": "double",
        "w": "wchar_t",
        "a": "signed char",
        "h": "unsigned char",
        "t": "unsigned short",
        "j": "unsigned int",
        "m": "unsigned long",
        "x": "long long",
        "y": "unsigned long long",
        "z": "..."
    };
    var subs = [];
    var first = true;

    function dump(x) {
        if (x) Module.print(x);
        Module.print(func);
        var pre = "";
        for (var a = 0; a < i; a++) pre += " ";
        Module.print(pre + "^")
    }

    function parseNested() {
        i++;
        if (func[i] === "K") i++;
        var parts = [];
        while (func[i] !== "E") {
            if (func[i] === "S") {
                i++;
                var next = func.indexOf("_", i);
                var num = func.substring(i, next) || 0;
                parts.push(subs[num] || "?");
                i = next + 1;
                continue
            }
            if (func[i] === "C") {
                parts.push(parts[parts.length - 1]);
                i += 2;
                continue
            }
            var size = parseInt(func.substr(i));
            var pre = size.toString().length;
            if (!size || !pre) {
                i--;
                break
            }
            var curr = func.substr(i + pre, size);
            parts.push(curr);
            subs.push(curr);
            i += pre + size
        }
        i++;
        return parts
    }

    function parse(rawList, limit, allowVoid) {
        limit = limit || Infinity;
        var ret = "",
            list = [];

        function flushList() {
            return "(" + list.join(", ") + ")"
        }
        var name;
        if (func[i] === "N") {
            name = parseNested().join("::");
            limit--;
            if (limit === 0) return rawList ? [name] : name
        } else {
            if (func[i] === "K" || first && func[i] === "L") i++;
            var size = parseInt(func.substr(i));
            if (size) {
                var pre = size.toString().length;
                name = func.substr(i + pre, size);
                i += pre + size
            }
        }
        first = false;
        if (func[i] === "I") {
            i++;
            var iList = parse(true);
            var iRet = parse(true, 1, true);
            ret += iRet[0] + " " + name + "<" + iList.join(", ") + ">"
        } else {
            ret = name
        }
        paramLoop: while (i < func.length && limit-- > 0) {
            var c = func[i++];
            if (c in basicTypes) {
                list.push(basicTypes[c])
            } else {
                switch (c) {
                    case "P":
                        list.push(parse(true, 1, true)[0] + "*");
                        break;
                    case "R":
                        list.push(parse(true, 1, true)[0] + "&");
                        break;
                    case "L":
                        {
                            i++;
                            var end = func.indexOf("E", i);
                            var size = end - i;list.push(func.substr(i, size));i += size + 2;
                            break
                        };
                    case "A":
                        {
                            var size = parseInt(func.substr(i));i += size.toString().length;
                            if (func[i] !== "_") throw "?";i++;list.push(parse(true, 1, true)[0] + " [" + size + "]");
                            break
                        };
                    case "E":
                        break paramLoop;
                    default:
                        ret += "?" + c;
                        break paramLoop
                }
            }
        }
        if (!allowVoid && list.length === 1 && list[0] === "void") list = [];
        if (rawList) {
            if (ret) {
                list.push(ret + "?")
            }
            return list
        } else {
            return ret + flushList()
        }
    }
    var parsed = func;
    try {
        if (func == "Object._main" || func == "_main") {
            return "main()"
        }
        if (typeof func === "number") func = Pointer_stringify(func);
        if (func[0] !== "_") return func;
        if (func[1] !== "_") return func;
        if (func[2] !== "Z") return func;
        switch (func[3]) {
            case "n":
                return "operator new()";
            case "d":
                return "operator delete()"
        }
        parsed = parse()
    } catch (e) {
        parsed += "?"
    }
    if (parsed.indexOf("?") >= 0 && !hasLibcxxabi) {
        Runtime.warnOnce("warning: a problem occurred in builtin C++ name demangling; build with  -s DEMANGLE_SUPPORT=1  to link in libcxxabi demangling")
    }
    return parsed
}

function demangleAll(text) {
    return text.replace(/__Z[\w\d_]+/g, (function(x) {
        var y = demangle(x);
        return x === y ? x : x + " [" + y + "]"
    }))
}

function jsStackTrace() {
    var err = new Error;
    if (!err.stack) {
        try {
            throw new Error(0)
        } catch (e) {
            err = e
        }
        if (!err.stack) {
            return "(no stack trace available)"
        }
    }
    return err.stack.toString()
}

function stackTrace() {
    return demangleAll(jsStackTrace())
}
Module["stackTrace"] = stackTrace;
var PAGE_SIZE = 4096;

function alignMemoryPage(x) {
    return x + 4095 & -4096
}
var HEAP;
var HEAP8, HEAPU8, HEAP16, HEAPU16, HEAP32, HEAPU32, HEAPF32, HEAPF64;
var STATIC_BASE = 0,
    STATICTOP = 0,
    staticSealed = false;
var STACK_BASE = 0,
    STACKTOP = 0,
    STACK_MAX = 0;
var DYNAMIC_BASE = 0,
    DYNAMICTOP = 0;

function enlargeMemory() {
    abort("Cannot enlarge memory arrays. Either (1) compile with -s TOTAL_MEMORY=X with X higher than the current value " + TOTAL_MEMORY + ", (2) compile with ALLOW_MEMORY_GROWTH which adjusts the size at runtime but prevents some optimizations, or (3) set Module.TOTAL_MEMORY before the program runs.")
}
var TOTAL_STACK = Module["TOTAL_STACK"] || 5242880;
var TOTAL_MEMORY = Module["TOTAL_MEMORY"] || 16777216;
var FAST_MEMORY = Module["FAST_MEMORY"] || 2097152;
var totalMemory = 64 * 1024;
while (totalMemory < TOTAL_MEMORY || totalMemory < 2 * TOTAL_STACK) {
    if (totalMemory < 16 * 1024 * 1024) {
        totalMemory *= 2
    } else {
        totalMemory += 16 * 1024 * 1024
    }
}
if (totalMemory !== TOTAL_MEMORY) {
    Module.printErr("increasing TOTAL_MEMORY to " + totalMemory + " to be compliant with the asm.js spec");
    TOTAL_MEMORY = totalMemory
}
assert(typeof Int32Array !== "undefined" && typeof Float64Array !== "undefined" && !!(new Int32Array(1))["subarray"] && !!(new Int32Array(1))["set"], "JS engine does not provide full typed array support");
var buffer = new ArrayBuffer(TOTAL_MEMORY);
HEAP8 = new Int8Array(buffer);
HEAP16 = new Int16Array(buffer);
HEAP32 = new Int32Array(buffer);
HEAPU8 = new Uint8Array(buffer);
HEAPU16 = new Uint16Array(buffer);
HEAPU32 = new Uint32Array(buffer);
HEAPF32 = new Float32Array(buffer);
HEAPF64 = new Float64Array(buffer);
HEAP32[0] = 255;
assert(HEAPU8[0] === 255 && HEAPU8[3] === 0, "Typed arrays 2 must be run on a little-endian system");
Module["HEAP"] = HEAP;
Module["buffer"] = buffer;
Module["HEAP8"] = HEAP8;
Module["HEAP16"] = HEAP16;
Module["HEAP32"] = HEAP32;
Module["HEAPU8"] = HEAPU8;
Module["HEAPU16"] = HEAPU16;
Module["HEAPU32"] = HEAPU32;
Module["HEAPF32"] = HEAPF32;
Module["HEAPF64"] = HEAPF64;

function callRuntimeCallbacks(callbacks) {
    while (callbacks.length > 0) {
        var callback = callbacks.shift();
        if (typeof callback == "function") {
            callback();
            continue
        }
        var func = callback.func;
        if (typeof func === "number") {
            if (callback.arg === undefined) {
                Runtime.dynCall("v", func)
            } else {
                Runtime.dynCall("vi", func, [callback.arg])
            }
        } else {
            func(callback.arg === undefined ? null : callback.arg)
        }
    }
}
var __ATPRERUN__ = [];
var __ATINIT__ = [];
var __ATMAIN__ = [];
var __ATEXIT__ = [];
var __ATPOSTRUN__ = [];
var runtimeInitialized = false;
var runtimeExited = false;

function preRun() {
    if (Module["preRun"]) {
        if (typeof Module["preRun"] == "function") Module["preRun"] = [Module["preRun"]];
        while (Module["preRun"].length) {
            addOnPreRun(Module["preRun"].shift())
        }
    }
    callRuntimeCallbacks(__ATPRERUN__)
}

function ensureInitRuntime() {
    if (runtimeInitialized) return;
    runtimeInitialized = true;
    callRuntimeCallbacks(__ATINIT__)
}

function preMain() {
    callRuntimeCallbacks(__ATMAIN__)
}

function exitRuntime() {
    callRuntimeCallbacks(__ATEXIT__);
    runtimeExited = true
}

function postRun() {
    if (Module["postRun"]) {
        if (typeof Module["postRun"] == "function") Module["postRun"] = [Module["postRun"]];
        while (Module["postRun"].length) {
            addOnPostRun(Module["postRun"].shift())
        }
    }
    callRuntimeCallbacks(__ATPOSTRUN__)
}

function addOnPreRun(cb) {
    __ATPRERUN__.unshift(cb)
}
Module["addOnPreRun"] = Module.addOnPreRun = addOnPreRun;

function addOnInit(cb) {
    __ATINIT__.unshift(cb)
}
Module["addOnInit"] = Module.addOnInit = addOnInit;

function addOnPreMain(cb) {
    __ATMAIN__.unshift(cb)
}
Module["addOnPreMain"] = Module.addOnPreMain = addOnPreMain;

function addOnExit(cb) {
    __ATEXIT__.unshift(cb)
}
Module["addOnExit"] = Module.addOnExit = addOnExit;

function addOnPostRun(cb) {
    __ATPOSTRUN__.unshift(cb)
}
Module["addOnPostRun"] = Module.addOnPostRun = addOnPostRun;

function intArrayFromString(stringy, dontAddNull, length) {
    var ret = (new Runtime.UTF8Processor).processJSString(stringy);
    if (length) {
        ret.length = length
    }
    if (!dontAddNull) {
        ret.push(0)
    }
    return ret
}
Module["intArrayFromString"] = intArrayFromString;

function intArrayToString(array) {
    var ret = [];
    for (var i = 0; i < array.length; i++) {
        var chr = array[i];
        if (chr > 255) {
            chr &= 255
        }
        ret.push(String.fromCharCode(chr))
    }
    return ret.join("")
}
Module["intArrayToString"] = intArrayToString;

function writeStringToMemory(string, buffer, dontAddNull) {
    var array = intArrayFromString(string, dontAddNull);
    var i = 0;
    while (i < array.length) {
        var chr = array[i];
        HEAP8[buffer + i >> 0] = chr;
        i = i + 1
    }
}
Module["writeStringToMemory"] = writeStringToMemory;

function writeArrayToMemory(array, buffer) {
    for (var i = 0; i < array.length; i++) {
        HEAP8[buffer + i >> 0] = array[i]
    }
}
Module["writeArrayToMemory"] = writeArrayToMemory;

function writeAsciiToMemory(str, buffer, dontAddNull) {
    for (var i = 0; i < str.length; i++) {
        HEAP8[buffer + i >> 0] = str.charCodeAt(i)
    }
    if (!dontAddNull) HEAP8[buffer + str.length >> 0] = 0
}
Module["writeAsciiToMemory"] = writeAsciiToMemory;

function unSign(value, bits, ignore) {
    if (value >= 0) {
        return value
    }
    return bits <= 32 ? 2 * Math.abs(1 << bits - 1) + value : Math.pow(2, bits) + value
}

function reSign(value, bits, ignore) {
    if (value <= 0) {
        return value
    }
    var half = bits <= 32 ? Math.abs(1 << bits - 1) : Math.pow(2, bits - 1);
    if (value >= half && (bits <= 32 || value > half)) {
        value = -2 * half + value
    }
    return value
}
if (!Math["imul"] || Math["imul"](4294967295, 5) !== -5) Math["imul"] = function imul(a, b) {
    var ah = a >>> 16;
    var al = a & 65535;
    var bh = b >>> 16;
    var bl = b & 65535;
    return al * bl + (ah * bl + al * bh << 16) | 0
};
Math.imul = Math["imul"];
var Math_abs = Math.abs;
var Math_cos = Math.cos;
var Math_sin = Math.sin;
var Math_tan = Math.tan;
var Math_acos = Math.acos;
var Math_asin = Math.asin;
var Math_atan = Math.atan;
var Math_atan2 = Math.atan2;
var Math_exp = Math.exp;
var Math_log = Math.log;
var Math_sqrt = Math.sqrt;
var Math_ceil = Math.ceil;
var Math_floor = Math.floor;
var Math_pow = Math.pow;
var Math_imul = Math.imul;
var Math_fround = Math.fround;
var Math_min = Math.min;
var runDependencies = 0;
var runDependencyWatcher = null;
var dependenciesFulfilled = null;

function addRunDependency(id) {
    runDependencies++;
    if (Module["monitorRunDependencies"]) {
        Module["monitorRunDependencies"](runDependencies)
    }
}
Module["addRunDependency"] = addRunDependency;

function removeRunDependency(id) {
    runDependencies--;
    if (Module["monitorRunDependencies"]) {
        Module["monitorRunDependencies"](runDependencies)
    }
    if (runDependencies == 0) {
        if (runDependencyWatcher !== null) {
            clearInterval(runDependencyWatcher);
            runDependencyWatcher = null
        }
        if (dependenciesFulfilled) {
            var callback = dependenciesFulfilled;
            dependenciesFulfilled = null;
            callback()
        }
    }
}
Module["removeRunDependency"] = removeRunDependency;
Module["preloadedImages"] = {};
Module["preloadedAudios"] = {};
var memoryInitializer = null;
STATIC_BASE = 8;
STATICTOP = STATIC_BASE + 151232;
__ATINIT__.push();
allocate([0, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 95, 84, 73, 68, 89, 0, 0, 0, 0, 0, 0, 0, 76, 111, 97, 100, 105, 110, 103, 32, 99, 111, 110, 102, 105, 103, 32, 102, 105, 108, 101, 32, 34, 37, 115, 34, 32, 102, 97, 105, 108, 101, 100, 44, 32, 101, 114, 114, 32, 61, 32, 37, 100, 10, 0, 0, 0, 0, 0, 0, 120, 109, 108, 0, 0, 0, 0, 0, 97, 115, 120, 109, 108, 0, 0, 0, 97, 115, 120, 104, 116, 109, 108, 0, 97, 115, 104, 116, 109, 108, 0, 0, 105, 110, 100, 101, 110, 116, 0, 0, 111, 109, 105, 116, 0, 0, 0, 0, 117, 112, 112, 101, 114, 0, 0, 0, 99, 108, 101, 97, 110, 0, 0, 0, 103, 100, 111, 99, 0, 0, 0, 0, 98, 97, 114, 101, 0, 0, 0, 0, 114, 97, 119, 0, 0, 0, 0, 0, 97, 115, 99, 105, 105, 0, 0, 0, 108, 97, 116, 105, 110, 48, 0, 0, 108, 97, 116, 105, 110, 49, 0, 0, 117, 116, 102, 56, 0, 0, 0, 0, 105, 115, 111, 50, 48, 50, 50, 0, 117, 116, 102, 49, 54, 108, 101, 0, 117, 116, 102, 49, 54, 98, 101, 0, 117, 116, 102, 49, 54, 0, 0, 0, 115, 104, 105, 102, 116, 106, 105, 115, 0, 0, 0, 0, 0, 0, 0, 0, 98, 105, 103, 53, 0, 0, 0, 0, 109, 97, 99, 0, 0, 0, 0, 0, 119, 105, 110, 49, 50, 53, 50, 0, 105, 98, 109, 56, 53, 56, 0, 0, 110, 117, 109, 101, 114, 105, 99, 0, 109, 111, 100, 105, 102, 121, 0, 0, 99, 104, 97, 110, 103, 101, 0, 0, 117, 112, 100, 97, 116, 101, 0, 0, 101, 114, 114, 111, 114, 115, 0, 0, 113, 117, 105, 101, 116, 0, 0, 0, 104, 101, 108, 112, 0, 0, 0, 0, 104, 0, 0, 0, 0, 0, 0, 0, 120, 109, 108, 45, 104, 101, 108, 112, 0, 0, 0, 0, 0, 0, 0, 0, 104, 101, 108, 112, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 0, 120, 109, 108, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 0, 99, 111, 110, 102, 105, 103, 0, 0, 108, 97, 110, 103, 117, 97, 103, 101, 0, 0, 0, 0, 0, 0, 0, 0, 108, 97, 110, 103, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 0, 0, 45, 111, 117, 116, 112, 117, 116, 45, 102, 105, 108, 101, 0, 0, 0, 0, 111, 0, 0, 0, 0, 0, 0, 0, 102, 105, 108, 101, 0, 0, 0, 0, 45, 102, 105, 108, 101, 0, 0, 0, 102, 0, 0, 0, 0, 0, 0, 0, 119, 114, 97, 112, 0, 0, 0, 0, 45, 119, 114, 97, 112, 0, 0, 0, 119, 0, 0, 0, 0, 0, 0, 0, 37, 117, 0, 0, 0, 0, 0, 0, 118, 101, 114, 115, 105, 111, 110, 0, 45, 118, 101, 114, 115, 105, 111, 110, 0, 0, 0, 0, 0, 0, 0, 0, 118, 0, 0, 0, 0, 0, 0, 0, 45, 45, 0, 0, 0, 0, 0, 0, 97, 99, 99, 101, 115, 115, 0, 0, 115, 116, 100, 105, 110, 0, 0, 0, 72, 84, 77, 76, 32, 84, 105, 100, 121, 58, 32, 117, 110, 107, 110, 111, 119, 110, 32, 111, 112, 116, 105, 111, 110, 58, 32, 37, 99, 10, 0, 0, 72, 84, 77, 76, 32, 84, 105, 100, 121, 32, 102, 111, 114, 32, 72, 84, 77, 76, 53, 32, 40, 101, 120, 112, 101, 114, 105, 109, 101, 110, 116, 97, 108, 41, 32, 37, 115, 10, 0, 0, 37, 45, 50, 55, 46, 50, 55, 115, 32, 37, 45, 57, 46, 57, 115, 32, 32, 37, 45, 52, 48, 46, 52, 48, 115, 10, 0, 0, 0, 0, 0, 0, 78, 97, 109, 101, 0, 0, 0, 0, 84, 121, 112, 101, 0, 0, 0, 0, 67, 117, 114, 114, 101, 110, 116, 32, 86, 97, 108, 117, 101, 0, 0, 0, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 0, 0, 0, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 45, 50, 55, 46, 50, 55, 115, 32, 37, 45, 57, 46, 57, 115, 32, 37, 45, 49, 46, 49, 115, 37, 45, 51, 57, 46, 51, 57, 115, 10, 0, 101, 110, 117, 109, 0, 0, 0, 0, 60, 101, 109, 62, 80, 108, 97, 116, 102, 111, 114, 109, 32, 100, 101, 112, 101, 110, 100, 101, 110, 116, 60, 47, 101, 109, 62, 0, 0, 0, 0, 0, 68, 111, 99, 84, 121, 112, 101, 0, 84, 97, 103, 32, 110, 97, 109, 101, 115, 0, 0, 0, 0, 0, 0, 0, 116, 97, 103, 88, 44, 32, 116, 97, 103, 89, 44, 32, 46, 46, 46, 0, 69, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 66, 111, 111, 108, 101, 97, 110, 0, 121, 47, 110, 44, 32, 121, 101, 115, 47, 110, 111, 44, 32, 116, 47, 102, 44, 32, 116, 114, 117, 101, 47, 102, 97, 108, 115, 101, 44, 32, 49, 47, 48, 0, 0, 0, 0, 0, 0, 0, 65, 117, 116, 111, 66, 111, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 97, 117, 116, 111, 44, 32, 121, 47, 110, 44, 32, 121, 101, 115, 47, 110, 111, 44, 32, 116, 47, 102, 44, 32, 116, 114, 117, 101, 47, 102, 97, 108, 115, 101, 44, 32, 49, 47, 48, 0, 73, 110, 116, 101, 103, 101, 114, 0, 48, 32, 40, 110, 111, 32, 119, 114, 97, 112, 112, 105, 110, 103, 41, 44, 32, 49, 44, 32, 50, 44, 32, 46, 46, 46, 0, 0, 0, 0, 0, 0, 48, 44, 32, 49, 44, 32, 50, 44, 32, 46, 46, 46, 0, 0, 0, 0, 83, 116, 114, 105, 110, 103, 0, 0, 121, 101, 115, 0, 0, 0, 0, 0, 109, 97, 114, 107, 117, 112, 0, 0, 100, 105, 97, 103, 110, 111, 115, 116, 105, 99, 115, 0, 0, 0, 0, 0, 112, 114, 105, 110, 116, 0, 0, 0, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 109, 105, 115, 99, 0, 0, 0, 0, 70, 97, 116, 97, 108, 32, 101, 114, 114, 111, 114, 58, 32, 105, 109, 112, 111, 115, 115, 105, 98, 108, 101, 32, 118, 97, 108, 117, 101, 32, 102, 111, 114, 32, 105, 100, 61, 39, 37, 100, 39, 46, 10, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 99, 111, 110, 115, 111, 108, 101, 47, 116, 105, 100, 121, 46, 99, 0, 0, 0, 0, 67, 111, 110, 102, 105, 103, 67, 97, 116, 101, 103, 111, 114, 121, 78, 97, 109, 101, 0, 0, 0, 0, 0, 0, 60, 63, 120, 109, 108, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 49, 46, 48, 34, 63, 62, 10, 60, 99, 111, 110, 102, 105, 103, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 37, 115, 34, 62, 10, 0, 0, 0, 0, 32, 60, 111, 112, 116, 105, 111, 110, 32, 99, 108, 97, 115, 115, 61, 34, 37, 115, 34, 62, 10, 0, 0, 0, 32, 32, 60, 110, 97, 109, 101, 62, 37, 115, 60, 47, 110, 97, 109, 101, 62, 10, 0, 0, 0, 0, 0, 0, 32, 32, 60, 116, 121, 112, 101, 62, 37, 115, 60, 47, 116, 121, 112, 101, 62, 10, 0, 0, 0, 0, 0, 0, 32, 32, 60, 100, 101, 102, 97, 117, 108, 116, 62, 37, 115, 60, 47, 100, 101, 102, 97, 117, 108, 116, 62, 10, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 60, 101, 120, 97, 109, 112, 108, 101, 62, 0, 0, 0, 0, 0, 32, 32, 60, 115, 101, 101, 97, 108, 115, 111, 62, 37, 115, 60, 47, 115, 101, 101, 97, 108, 115, 111, 62, 10, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 60, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 62, 37, 115, 60, 47, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 62, 10, 0, 0, 0, 0, 0, 0, 0, 0, 87, 97, 114, 110, 105, 110, 103, 58, 32, 111, 112, 116, 105, 111, 110, 32, 96, 37, 115, 39, 32, 105, 115, 32, 110, 111, 116, 32, 100, 111, 99, 117, 109, 101, 110, 116, 101, 100, 46, 10, 0, 0, 0, 0, 0, 0, 0, 0, 37, 115, 0, 0, 0, 0, 0, 0, 44, 32, 0, 0, 0, 0, 0, 0, 65, 108, 108, 111, 119, 97, 98, 108, 101, 32, 118, 97, 108, 117, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0, 0, 0, 0, 79, 117, 116, 32, 111, 102, 32, 109, 101, 109, 111, 114, 121, 46, 32, 66, 97, 105, 108, 105, 110, 103, 32, 111, 117, 116, 46, 0, 0, 0, 0, 0, 60, 63, 120, 109, 108, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 49, 46, 48, 34, 63, 62, 10, 60, 99, 109, 100, 108, 105, 110, 101, 32, 118, 101, 114, 115, 105, 111, 110, 61, 34, 37, 115, 34, 62, 10, 0, 0, 0, 96, 11, 0, 0, 112, 11, 0, 0, 152, 11, 0, 0, 0, 0, 0, 0, 176, 11, 0, 0, 0, 0, 0, 0, 192, 11, 0, 0, 208, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 12, 0, 0, 24, 12, 0, 0, 80, 12, 0, 0, 0, 0, 0, 0, 104, 12, 0, 0, 0, 0, 0, 0, 120, 12, 0, 0, 128, 12, 0, 0, 160, 12, 0, 0, 0, 0, 0, 0, 176, 12, 0, 0, 0, 0, 0, 0, 184, 12, 0, 0, 192, 12, 0, 0, 216, 12, 0, 0, 1, 0, 0, 0, 232, 12, 0, 0, 0, 0, 0, 0, 240, 12, 0, 0, 0, 13, 0, 0, 160, 13, 0, 0, 1, 0, 0, 0, 176, 13, 0, 0, 0, 0, 0, 0, 192, 13, 0, 0, 200, 13, 0, 0, 232, 13, 0, 0, 1, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 8, 14, 0, 0, 16, 14, 0, 0, 64, 14, 0, 0, 1, 0, 0, 0, 80, 14, 0, 0, 0, 0, 0, 0, 88, 14, 0, 0, 96, 14, 0, 0, 144, 14, 0, 0, 1, 0, 0, 0, 160, 14, 0, 0, 0, 0, 0, 0, 168, 14, 0, 0, 176, 14, 0, 0, 232, 14, 0, 0, 1, 0, 0, 0, 248, 14, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 16, 15, 0, 0, 64, 15, 0, 0, 1, 0, 0, 0, 88, 15, 0, 0, 0, 0, 0, 0, 96, 15, 0, 0, 104, 15, 0, 0, 136, 15, 0, 0, 1, 0, 0, 0, 152, 15, 0, 0, 0, 0, 0, 0, 160, 15, 0, 0, 168, 15, 0, 0, 200, 15, 0, 0, 1, 0, 0, 0, 216, 15, 0, 0, 0, 0, 0, 0, 224, 15, 0, 0, 232, 15, 0, 0, 16, 16, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 16, 0, 0, 48, 16, 0, 0, 88, 16, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 16, 0, 0, 112, 16, 0, 0, 152, 16, 0, 0, 1, 0, 0, 0, 176, 16, 0, 0, 0, 0, 0, 0, 192, 16, 0, 0, 200, 16, 0, 0, 232, 16, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 16, 17, 0, 0, 112, 17, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 17, 0, 0, 152, 17, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 17, 0, 0, 216, 17, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 18, 0, 0, 16, 18, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 18, 0, 0, 72, 18, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 18, 0, 0, 136, 18, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 18, 0, 0, 184, 18, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 18, 0, 0, 232, 18, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 19, 0, 0, 40, 19, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 19, 0, 0, 96, 19, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 19, 0, 0, 168, 19, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 19, 0, 0, 224, 19, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 20, 0, 0, 16, 20, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 20, 0, 0, 64, 20, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 20, 0, 0, 120, 20, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 20, 0, 0, 184, 20, 0, 0, 248, 20, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 2, 0, 0, 16, 21, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 48, 21, 0, 0, 0, 0, 0, 0, 56, 21, 0, 0, 64, 21, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 96, 21, 0, 0, 104, 21, 0, 0, 112, 21, 0, 0, 128, 21, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 21, 0, 0, 192, 21, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 21, 0, 0, 240, 21, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 22, 0, 0, 48, 22, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 10, 0, 0, 224, 10, 0, 0, 248, 10, 0, 0, 16, 11, 0, 0, 40, 11, 0, 0, 56, 11, 0, 0, 144, 4, 0, 0, 80, 11, 0, 0, 110, 97, 109, 101, 0, 0, 0, 0, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 0, 0, 0, 0, 0, 101, 113, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 60, 37, 115, 62, 37, 115, 60, 47, 37, 115, 62, 10, 0, 0, 38, 108, 116, 59, 0, 0, 0, 0, 38, 103, 116, 59, 0, 0, 0, 0, 38, 113, 117, 111, 116, 59, 0, 0, 102, 105, 108, 101, 45, 109, 97, 110, 105, 112, 0, 0, 0, 0, 0, 0, 70, 105, 108, 101, 32, 109, 97, 110, 105, 112, 117, 108, 97, 116, 105, 111, 110, 0, 0, 0, 0, 0, 0, 0, 112, 114, 111, 99, 101, 115, 115, 45, 100, 105, 114, 101, 99, 116, 105, 118, 101, 115, 0, 0, 0, 0, 0, 0, 80, 114, 111, 99, 101, 115, 115, 105, 110, 103, 32, 100, 105, 114, 101, 99, 116, 105, 118, 101, 115, 0, 0, 0, 99, 104, 97, 114, 45, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 67, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 0, 0, 0, 0, 0, 77, 105, 115, 99, 101, 108, 108, 97, 110, 101, 111, 117, 115, 0, 0, 0, 45, 111, 117, 116, 112, 117, 116, 32, 60, 102, 105, 108, 101, 62, 0, 0, 119, 114, 105, 116, 101, 32, 111, 117, 116, 112, 117, 116, 32, 116, 111, 32, 116, 104, 101, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 102, 105, 108, 101, 58, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 45, 111, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 0, 0, 45, 99, 111, 110, 102, 105, 103, 32, 60, 102, 105, 108, 101, 62, 0, 0, 115, 101, 116, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 115, 32, 102, 114, 111, 109, 32, 116, 104, 101, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 45, 102, 105, 108, 101, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 119, 114, 105, 116, 101, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 32, 116, 111, 32, 116, 104, 101, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 0, 0, 101, 114, 114, 111, 114, 45, 102, 105, 108, 101, 58, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 0, 45, 102, 32, 60, 102, 105, 108, 101, 62, 0, 0, 0, 0, 0, 0, 0, 45, 109, 111, 100, 105, 102, 121, 0, 109, 111, 100, 105, 102, 121, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 105, 110, 112, 117, 116, 32, 102, 105, 108, 101, 115, 0, 119, 114, 105, 116, 101, 45, 98, 97, 99, 107, 58, 32, 121, 101, 115, 0, 45, 109, 0, 0, 0, 0, 0, 0, 45, 105, 110, 100, 101, 110, 116, 0, 105, 110, 100, 101, 110, 116, 32, 101, 108, 101, 109, 101, 110, 116, 32, 99, 111, 110, 116, 101, 110, 116, 0, 0, 105, 110, 100, 101, 110, 116, 58, 32, 97, 117, 116, 111, 0, 0, 0, 0, 45, 105, 0, 0, 0, 0, 0, 0, 45, 119, 114, 97, 112, 32, 60, 99, 111, 108, 117, 109, 110, 62, 0, 0, 119, 114, 97, 112, 32, 116, 101, 120, 116, 32, 97, 116, 32, 116, 104, 101, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 60, 99, 111, 108, 117, 109, 110, 62, 46, 32, 48, 32, 105, 115, 32, 97, 115, 115, 117, 109, 101, 100, 32, 105, 102, 32, 60, 99, 111, 108, 117, 109, 110, 62, 32, 105, 115, 32, 109, 105, 115, 115, 105, 110, 103, 46, 32, 87, 104, 101, 110, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 111, 109, 105, 116, 116, 101, 100, 44, 32, 116, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 111, 102, 32, 116, 104, 101, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 32, 34, 119, 114, 97, 112, 34, 32, 97, 112, 112, 108, 105, 101, 115, 46, 0, 0, 119, 114, 97, 112, 58, 32, 60, 99, 111, 108, 117, 109, 110, 62, 0, 0, 45, 119, 32, 60, 99, 111, 108, 117, 109, 110, 62, 0, 0, 0, 0, 0, 45, 117, 112, 112, 101, 114, 0, 0, 102, 111, 114, 99, 101, 32, 116, 97, 103, 115, 32, 116, 111, 32, 117, 112, 112, 101, 114, 32, 99, 97, 115, 101, 0, 0, 0, 0, 0, 0, 0, 0, 117, 112, 112, 101, 114, 99, 97, 115, 101, 45, 116, 97, 103, 115, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 45, 117, 0, 0, 0, 0, 0, 0, 45, 99, 108, 101, 97, 110, 0, 0, 114, 101, 112, 108, 97, 99, 101, 32, 70, 79, 78, 84, 44, 32, 78, 79, 66, 82, 32, 97, 110, 100, 32, 67, 69, 78, 84, 69, 82, 32, 116, 97, 103, 115, 32, 98, 121, 32, 67, 83, 83, 0, 0, 0, 0, 0, 0, 0, 99, 108, 101, 97, 110, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 45, 99, 0, 0, 0, 0, 0, 0, 45, 98, 97, 114, 101, 0, 0, 0, 115, 116, 114, 105, 112, 32, 111, 117, 116, 32, 115, 109, 97, 114, 116, 32, 113, 117, 111, 116, 101, 115, 32, 97, 110, 100, 32, 101, 109, 32, 100, 97, 115, 104, 101, 115, 44, 32, 101, 116, 99, 46, 0, 0, 0, 0, 0, 0, 98, 97, 114, 101, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 0, 45, 98, 0, 0, 0, 0, 0, 0, 45, 103, 100, 111, 99, 0, 0, 0, 112, 114, 111, 100, 117, 99, 101, 32, 99, 108, 101, 97, 110, 32, 118, 101, 114, 115, 105, 111, 110, 32, 111, 102, 32, 104, 116, 109, 108, 32, 101, 120, 112, 111, 114, 116, 101, 100, 32, 98, 121, 32, 103, 111, 111, 103, 108, 101, 32, 100, 111, 99, 115, 0, 0, 0, 103, 100, 111, 99, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 0, 45, 103, 0, 0, 0, 0, 0, 0, 45, 110, 117, 109, 101, 114, 105, 99, 0, 0, 0, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 32, 110, 117, 109, 101, 114, 105, 99, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 110, 97, 109, 101, 100, 32, 101, 110, 116, 105, 116, 105, 101, 115, 0, 0, 0, 0, 0, 0, 0, 110, 117, 109, 101, 114, 105, 99, 45, 101, 110, 116, 105, 116, 105, 101, 115, 58, 32, 121, 101, 115, 0, 0, 0, 45, 110, 0, 0, 0, 0, 0, 0, 45, 101, 114, 114, 111, 114, 115, 0, 115, 104, 111, 119, 32, 111, 110, 108, 121, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 0, 0, 0, 109, 97, 114, 107, 117, 112, 58, 32, 110, 111, 0, 0, 0, 0, 0, 0, 45, 101, 0, 0, 0, 0, 0, 0, 45, 113, 117, 105, 101, 116, 0, 0, 115, 117, 112, 112, 114, 101, 115, 115, 32, 110, 111, 110, 101, 115, 115, 101, 110, 116, 105, 97, 108, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 113, 117, 105, 101, 116, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 45, 113, 0, 0, 0, 0, 0, 0, 45, 111, 109, 105, 116, 0, 0, 0, 111, 109, 105, 116, 32, 111, 112, 116, 105, 111, 110, 97, 108, 32, 115, 116, 97, 114, 116, 32, 116, 97, 103, 115, 32, 97, 110, 100, 32, 101, 110, 100, 32, 116, 97, 103, 115, 0, 0, 0, 111, 109, 105, 116, 45, 111, 112, 116, 105, 111, 110, 97, 108, 45, 116, 97, 103, 115, 58, 32, 121, 101, 115, 0, 45, 120, 109, 108, 0, 0, 0, 0, 115, 112, 101, 99, 105, 102, 121, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 115, 32, 119, 101, 108, 108, 32, 102, 111, 114, 109, 101, 100, 32, 88, 77, 76, 0, 0, 0, 0, 105, 110, 112, 117, 116, 45, 120, 109, 108, 58, 32, 121, 101, 115, 0, 0, 45, 97, 115, 120, 109, 108, 0, 0, 99, 111, 110, 118, 101, 114, 116, 32, 72, 84, 77, 76, 32, 116, 111, 32, 119, 101, 108, 108, 32, 102, 111, 114, 109, 101, 100, 32, 88, 72, 84, 77, 76, 0, 0, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 120, 104, 116, 109, 108, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 0, 45, 97, 115, 120, 104, 116, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 45, 97, 115, 104, 116, 109, 108, 0, 102, 111, 114, 99, 101, 32, 88, 72, 84, 77, 76, 32, 116, 111, 32, 119, 101, 108, 108, 32, 102, 111, 114, 109, 101, 100, 32, 72, 84, 77, 76, 0, 111, 117, 116, 112, 117, 116, 45, 104, 116, 109, 108, 58, 32, 121, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 45, 97, 99, 99, 101, 115, 115, 32, 60, 108, 101, 118, 101, 108, 62, 0, 100, 111, 32, 97, 100, 100, 105, 116, 105, 111, 110, 97, 108, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 99, 104, 101, 99, 107, 115, 32, 40, 60, 108, 101, 118, 101, 108, 62, 32, 61, 32, 48, 44, 32, 49, 44, 32, 50, 44, 32, 51, 41, 46, 32, 48, 32, 105, 115, 32, 97, 115, 115, 117, 109, 101, 100, 32, 105, 102, 32, 60, 108, 101, 118, 101, 108, 62, 32, 105, 115, 32, 109, 105, 115, 115, 105, 110, 103, 46, 0, 0, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 45, 99, 104, 101, 99, 107, 58, 32, 60, 108, 101, 118, 101, 108, 62, 0, 0, 0, 0, 45, 114, 97, 119, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 32, 118, 97, 108, 117, 101, 115, 32, 97, 98, 111, 118, 101, 32, 49, 50, 55, 32, 119, 105, 116, 104, 111, 117, 116, 32, 99, 111, 110, 118, 101, 114, 115, 105, 111, 110, 32, 116, 111, 32, 101, 110, 116, 105, 116, 105, 101, 115, 0, 0, 45, 97, 115, 99, 105, 105, 0, 0, 117, 115, 101, 32, 73, 83, 79, 45, 56, 56, 53, 57, 45, 49, 32, 102, 111, 114, 32, 105, 110, 112, 117, 116, 44, 32, 85, 83, 45, 65, 83, 67, 73, 73, 32, 102, 111, 114, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 45, 108, 97, 116, 105, 110, 48, 0, 117, 115, 101, 32, 73, 83, 79, 45, 56, 56, 53, 57, 45, 49, 53, 32, 102, 111, 114, 32, 105, 110, 112, 117, 116, 44, 32, 85, 83, 45, 65, 83, 67, 73, 73, 32, 102, 111, 114, 32, 111, 117, 116, 112, 117, 116, 0, 0, 45, 108, 97, 116, 105, 110, 49, 0, 117, 115, 101, 32, 73, 83, 79, 45, 56, 56, 53, 57, 45, 49, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 0, 0, 0, 0, 45, 105, 115, 111, 50, 48, 50, 50, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 101, 32, 73, 83, 79, 45, 50, 48, 50, 50, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 45, 117, 116, 102, 56, 0, 0, 0, 117, 115, 101, 32, 85, 84, 70, 45, 56, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 0, 45, 109, 97, 99, 0, 0, 0, 0, 117, 115, 101, 32, 77, 97, 99, 82, 111, 109, 97, 110, 32, 102, 111, 114, 32, 105, 110, 112, 117, 116, 44, 32, 85, 83, 45, 65, 83, 67, 73, 73, 32, 102, 111, 114, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 0, 45, 119, 105, 110, 49, 50, 53, 50, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 101, 32, 87, 105, 110, 100, 111, 119, 115, 45, 49, 50, 53, 50, 32, 102, 111, 114, 32, 105, 110, 112, 117, 116, 44, 32, 85, 83, 45, 65, 83, 67, 73, 73, 32, 102, 111, 114, 32, 111, 117, 116, 112, 117, 116, 0, 45, 105, 98, 109, 56, 53, 56, 0, 117, 115, 101, 32, 73, 66, 77, 45, 56, 53, 56, 32, 40, 67, 80, 56, 53, 48, 43, 69, 117, 114, 111, 41, 32, 102, 111, 114, 32, 105, 110, 112, 117, 116, 44, 32, 85, 83, 45, 65, 83, 67, 73, 73, 32, 102, 111, 114, 32, 111, 117, 116, 112, 117, 116, 0, 45, 117, 116, 102, 49, 54, 108, 101, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 101, 32, 85, 84, 70, 45, 49, 54, 76, 69, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 45, 117, 116, 102, 49, 54, 98, 101, 0, 0, 0, 0, 0, 0, 0, 0, 117, 115, 101, 32, 85, 84, 70, 45, 49, 54, 66, 69, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 45, 117, 116, 102, 49, 54, 0, 0, 117, 115, 101, 32, 85, 84, 70, 45, 49, 54, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 45, 98, 105, 103, 53, 0, 0, 0, 117, 115, 101, 32, 66, 105, 103, 53, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 0, 0, 45, 115, 104, 105, 102, 116, 106, 105, 115, 0, 0, 0, 0, 0, 0, 0, 117, 115, 101, 32, 83, 104, 105, 102, 116, 95, 74, 73, 83, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 0, 45, 108, 97, 110, 103, 117, 97, 103, 101, 32, 60, 108, 97, 110, 103, 62, 0, 0, 0, 0, 0, 0, 0, 0, 115, 101, 116, 32, 116, 104, 101, 32, 116, 119, 111, 45, 108, 101, 116, 116, 101, 114, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 99, 111, 100, 101, 32, 60, 108, 97, 110, 103, 62, 32, 40, 102, 111, 114, 32, 102, 117, 116, 117, 114, 101, 32, 117, 115, 101, 41, 0, 0, 0, 0, 0, 0, 0, 0, 108, 97, 110, 103, 117, 97, 103, 101, 58, 32, 60, 108, 97, 110, 103, 62, 0, 0, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 32, 116, 104, 101, 32, 118, 101, 114, 115, 105, 111, 110, 32, 111, 102, 32, 84, 105, 100, 121, 0, 0, 0, 0, 0, 0, 0, 0, 45, 118, 0, 0, 0, 0, 0, 0, 45, 104, 101, 108, 112, 0, 0, 0, 108, 105, 115, 116, 32, 116, 104, 101, 32, 99, 111, 109, 109, 97, 110, 100, 32, 108, 105, 110, 101, 32, 111, 112, 116, 105, 111, 110, 115, 0, 0, 0, 45, 104, 0, 0, 0, 0, 0, 0, 45, 63, 0, 0, 0, 0, 0, 0, 45, 120, 109, 108, 45, 104, 101, 108, 112, 0, 0, 0, 0, 0, 0, 0, 108, 105, 115, 116, 32, 116, 104, 101, 32, 99, 111, 109, 109, 97, 110, 100, 32, 108, 105, 110, 101, 32, 111, 112, 116, 105, 111, 110, 115, 32, 105, 110, 32, 88, 77, 76, 32, 102, 111, 114, 109, 97, 116, 0, 0, 0, 0, 0, 45, 104, 101, 108, 112, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 108, 105, 115, 116, 32, 97, 108, 108, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 115, 0, 0, 45, 120, 109, 108, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 0, 108, 105, 115, 116, 32, 97, 108, 108, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 115, 32, 105, 110, 32, 88, 77, 76, 32, 102, 111, 114, 109, 97, 116, 0, 0, 0, 0, 45, 115, 104, 111, 119, 45, 99, 111, 110, 102, 105, 103, 0, 0, 0, 0, 108, 105, 115, 116, 32, 116, 104, 101, 32, 99, 117, 114, 114, 101, 110, 116, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 115, 101, 116, 116, 105, 110, 103, 115, 0, 37, 115, 32, 91, 111, 112, 116, 105, 111, 110, 46, 46, 46, 93, 32, 91, 102, 105, 108, 101, 46, 46, 46, 93, 32, 91, 111, 112, 116, 105, 111, 110, 46, 46, 46, 93, 32, 91, 102, 105, 108, 101, 46, 46, 46, 93, 10, 0, 32, 32, 104, 116, 116, 112, 58, 47, 47, 118, 97, 108, 105, 100, 97, 116, 111, 114, 46, 119, 51, 46, 111, 114, 103, 47, 110, 117, 47, 0, 0, 0, 37, 42, 46, 42, 115, 10, 0, 0, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 0, 0, 0, 0, 0, 0, 0, 32, 37, 45, 49, 57, 46, 49, 57, 115, 32, 37, 45, 53, 56, 46, 53, 56, 115, 10, 0, 0, 0, 0, 0, 85, 116, 105, 108, 105, 116, 121, 32, 116, 111, 32, 99, 108, 101, 97, 110, 32, 117, 112, 32, 97, 110, 100, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 32, 72, 84, 77, 76, 47, 88, 72, 84, 77, 76, 47, 88, 77, 76, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 105, 115, 32, 97, 110, 32, 72, 84, 77, 76, 53, 45, 97, 119, 97, 114, 101, 32, 101, 120, 112, 101, 114, 105, 109, 101, 110, 116, 97, 108, 32, 102, 111, 114, 107, 32, 111, 102, 32, 72, 84, 77, 76, 32, 84, 105, 100, 121, 46, 0, 0, 79, 112, 116, 105, 111, 110, 115, 32, 102, 111, 114, 32, 72, 84, 77, 76, 32, 84, 105, 100, 121, 58, 0, 0, 85, 115, 101, 32, 45, 45, 111, 112, 116, 105, 111, 110, 88, 32, 118, 97, 108, 117, 101, 88, 32, 102, 111, 114, 32, 97, 110, 121, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 32, 34, 111, 112, 116, 105, 111, 110, 88, 34, 32, 119, 105, 116, 104, 32, 97, 114, 103, 117, 109, 101, 110, 116, 10, 34, 118, 97, 108, 117, 101, 88, 34, 46, 32, 70, 111, 114, 32, 97, 32, 108, 105, 115, 116, 32, 111, 102, 32, 116, 104, 101, 32, 99, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 111, 112, 116, 105, 111, 110, 115, 44, 32, 117, 115, 101, 32, 34, 45, 104, 101, 108, 112, 45, 99, 111, 110, 102, 105, 103, 34, 32, 111, 114, 32, 114, 101, 102, 101, 114, 10, 116, 111, 32, 116, 104, 101, 32, 109, 97, 110, 32, 112, 97, 103, 101, 46, 10, 0, 0, 0, 0, 0, 0, 73, 110, 112, 117, 116, 47, 79, 117, 116, 112, 117, 116, 32, 100, 101, 102, 97, 117, 108, 116, 32, 116, 111, 32, 115, 116, 100, 105, 110, 47, 115, 116, 100, 111, 117, 116, 32, 114, 101, 115, 112, 101, 99, 116, 105, 118, 101, 108, 121, 46, 0, 0, 0, 0, 0, 0, 83, 105, 110, 103, 108, 101, 32, 108, 101, 116, 116, 101, 114, 32, 111, 112, 116, 105, 111, 110, 115, 32, 97, 112, 97, 114, 116, 32, 102, 114, 111, 109, 32, 45, 102, 32, 109, 97, 121, 32, 98, 101, 32, 99, 111, 109, 98, 105, 110, 101, 100, 0, 0, 0, 0, 0, 97, 115, 32, 105, 110, 58, 32, 32, 116, 105, 100, 121, 32, 45, 102, 32, 101, 114, 114, 115, 46, 116, 120, 116, 32, 45, 105, 109, 117, 32, 102, 111, 111, 46, 104, 116, 109, 108, 0, 0, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 111, 110, 32, 116, 104, 105, 115, 32, 72, 84, 77, 76, 53, 45, 97, 119, 97, 114, 101, 32, 101, 120, 112, 101, 114, 105, 109, 101, 110, 116, 97, 108, 32, 102, 111, 114, 107, 32, 111, 102, 32, 84, 105, 100, 121, 44, 0, 0, 0, 0, 0, 115, 101, 101, 32, 104, 116, 116, 112, 58, 47, 47, 119, 51, 99, 46, 103, 105, 116, 104, 117, 98, 46, 99, 111, 109, 47, 116, 105, 100, 121, 45, 104, 116, 109, 108, 53, 47, 0, 0, 0, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 111, 110, 32, 72, 84, 77, 76, 44, 32, 115, 101, 101, 32, 116, 104, 101, 32, 102, 111, 108, 108, 111, 119, 105, 110, 103, 58, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 72, 84, 77, 76, 58, 32, 69, 100, 105, 116, 105, 111, 110, 32, 102, 111, 114, 32, 87, 101, 98, 32, 65, 117, 116, 104, 111, 114, 115, 32, 40, 116, 104, 101, 32, 108, 97, 116, 101, 115, 116, 32, 72, 84, 77, 76, 32, 115, 112, 101, 99, 105, 102, 105, 99, 97, 116, 105, 111, 110, 41, 0, 32, 32, 104, 116, 116, 112, 58, 47, 47, 100, 101, 118, 46, 119, 51, 46, 111, 114, 103, 47, 104, 116, 109, 108, 53, 47, 115, 112, 101, 99, 45, 97, 117, 116, 104, 111, 114, 45, 118, 105, 101, 119, 0, 0, 0, 0, 0, 0, 32, 32, 72, 84, 77, 76, 58, 32, 84, 104, 101, 32, 77, 97, 114, 107, 117, 112, 32, 76, 97, 110, 103, 117, 97, 103, 101, 32, 40, 97, 110, 32, 72, 84, 77, 76, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 41, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 104, 116, 116, 112, 58, 47, 47, 100, 101, 118, 46, 119, 51, 46, 111, 114, 103, 47, 104, 116, 109, 108, 53, 47, 109, 97, 114, 107, 117, 112, 47, 0, 0, 0, 0, 0, 0, 0, 70, 105, 108, 101, 32, 98, 117, 103, 32, 114, 101, 112, 111, 114, 116, 115, 32, 97, 116, 32, 104, 116, 116, 112, 115, 58, 47, 47, 103, 105, 116, 104, 117, 98, 46, 99, 111, 109, 47, 119, 51, 99, 47, 116, 105, 100, 121, 45, 104, 116, 109, 108, 53, 47, 105, 115, 115, 117, 101, 115, 47, 0, 0, 0, 111, 114, 32, 115, 101, 110, 100, 32, 113, 117, 101, 115, 116, 105, 111, 110, 115, 32, 97, 110, 100, 32, 99, 111, 109, 109, 101, 110, 116, 115, 32, 116, 111, 32, 104, 116, 109, 108, 45, 116, 105, 100, 121, 64, 119, 51, 46, 111, 114, 103, 0, 0, 0, 0, 0, 0, 86, 97, 108, 105, 100, 97, 116, 101, 32, 121, 111, 117, 114, 32, 72, 84, 77, 76, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 32, 117, 115, 105, 110, 103, 32, 116, 104, 101, 32, 87, 51, 67, 32, 78, 117, 32, 77, 97, 114, 107, 117, 112, 32, 86, 97, 108, 105, 100, 97, 116, 111, 114, 58, 0, 60, 47, 99, 109, 100, 108, 105, 110, 101, 62, 0, 0, 0, 0, 0, 0, 10, 72, 84, 77, 76, 32, 84, 105, 100, 121, 32, 67, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 83, 101, 116, 116, 105, 110, 103, 115, 10, 0, 0, 0, 0, 0, 0, 87, 105, 116, 104, 105, 110, 32, 97, 32, 102, 105, 108, 101, 44, 32, 117, 115, 101, 32, 116, 104, 101, 32, 102, 111, 114, 109, 58, 10, 0, 0, 0, 119, 114, 97, 112, 58, 32, 55, 50, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 100, 101, 110, 116, 58, 32, 110, 111, 10, 0, 0, 0, 0, 0, 87, 104, 101, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 111, 110, 32, 116, 104, 101, 32, 99, 111, 109, 109, 97, 110, 100, 32, 108, 105, 110, 101, 44, 32, 117, 115, 101, 32, 116, 104, 101, 32, 102, 111, 114, 109, 58, 10, 0, 0, 0, 0, 0, 0, 45, 45, 119, 114, 97, 112, 32, 55, 50, 32, 45, 45, 105, 110, 100, 101, 110, 116, 32, 110, 111, 10, 0, 0, 60, 47, 99, 111, 110, 102, 105, 103, 62, 0, 0, 0, 0, 0, 0, 0, 10, 67, 111, 110, 102, 105, 103, 117, 114, 97, 116, 105, 111, 110, 32, 70, 105, 108, 101, 32, 83, 101, 116, 116, 105, 110, 103, 115, 58, 10, 0, 0, 10, 10, 86, 97, 108, 117, 101, 115, 32, 109, 97, 114, 107, 101, 100, 32, 119, 105, 116, 104, 32, 97, 110, 32, 42, 97, 115, 116, 101, 114, 105, 115, 107, 32, 97, 114, 101, 32, 99, 97, 108, 99, 117, 108, 97, 116, 101, 100, 32, 10, 105, 110, 116, 101, 114, 110, 97, 108, 108, 121, 32, 98, 121, 32, 72, 84, 77, 76, 32, 84, 105, 100, 121, 10, 0, 0, 0, 0, 0, 0, 32, 32, 60, 100, 101, 102, 97, 117, 108, 116, 32, 47, 62, 0, 0, 0, 32, 32, 60, 101, 120, 97, 109, 112, 108, 101, 32, 47, 62, 0, 0, 0, 60, 47, 101, 120, 97, 109, 112, 108, 101, 62, 0, 0, 0, 0, 0, 0, 32, 32, 60, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 32, 47, 62, 0, 0, 0, 0, 0, 0, 0, 32, 32, 60, 101, 113, 99, 111, 110, 102, 105, 103, 32, 47, 62, 0, 0, 32, 60, 47, 111, 112, 116, 105, 111, 110, 62, 0, 0, 0, 0, 0, 0, 99, 104, 97, 114, 45, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 119, 98, 0, 0, 0, 0, 0, 0, 100, 111, 99, 32, 33, 61, 32, 78, 85, 76, 76, 32, 38, 38, 32, 105, 110, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 116, 105, 100, 121, 108, 105, 98, 46, 99, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 68, 111, 99, 80, 97, 114, 115, 101, 83, 116, 114, 101, 97, 109, 0, 0, 0, 100, 111, 99, 45, 62, 100, 111, 99, 73, 110, 32, 61, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 0, 80, 85, 66, 76, 73, 67, 0, 0, 10, 80, 97, 110, 105, 99, 32, 45, 32, 116, 114, 101, 101, 32, 104, 97, 115, 32, 108, 111, 115, 116, 32, 105, 116, 115, 32, 105, 110, 116, 101, 103, 114, 105, 116, 121, 10, 0, 0, 0, 114, 98, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 68, 111, 99, 82, 101, 108, 101, 97, 115, 101, 0, 0, 100, 111, 99, 45, 62, 100, 111, 99, 79, 117, 116, 32, 61, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 104, 116, 116, 112, 45, 101, 113, 117, 105, 118, 0, 0, 0, 0, 0, 0, 67, 111, 110, 116, 101, 110, 116, 45, 84, 121, 112, 101, 0, 0, 0, 0, 99, 111, 110, 116, 101, 110, 116, 0, 116, 101, 120, 116, 47, 104, 116, 109, 108, 59, 32, 99, 104, 97, 114, 115, 101, 116, 61, 85, 84, 70, 45, 56, 0, 0, 0, 0, 0, 0, 0, 0, 110, 97, 109, 101, 0, 0, 0, 0, 105, 100, 0, 0, 0, 0, 0, 0, 99, 108, 97, 115, 115, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 106, 97, 118, 97, 115, 99, 114, 105, 112, 116, 58, 0, 0, 0, 0, 0, 60, 62, 0, 0, 0, 0, 0, 0, 37, 37, 37, 48, 50, 88, 0, 0, 100, 97, 116, 97, 45, 0, 0, 0, 32, 123, 32, 0, 0, 0, 0, 0, 32, 125, 0, 0, 0, 0, 0, 0, 59, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 208, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 216, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 224, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 240, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 0, 47, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 8, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 24, 47, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 32, 47, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 40, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 48, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 56, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 64, 47, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 80, 47, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 88, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 104, 47, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 112, 47, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 128, 47, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 144, 47, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0, 160, 47, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 176, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 184, 47, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 192, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 200, 47, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 208, 47, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 224, 47, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 232, 47, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 240, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 0, 248, 47, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 8, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 24, 48, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 40, 48, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 48, 48, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 35, 0, 0, 0, 56, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 64, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 72, 48, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 80, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 88, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 104, 48, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 120, 48, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 42, 0, 0, 0, 128, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 144, 48, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 152, 48, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 160, 48, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 168, 48, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 184, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 200, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 208, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 216, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0, 0, 0, 224, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 232, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 248, 48, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 8, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 55, 0, 0, 0, 16, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 24, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 32, 49, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 40, 49, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 48, 49, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 64, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 72, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 88, 49, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 96, 49, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 104, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 120, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 128, 49, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 136, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 152, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 168, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 184, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 71, 0, 0, 0, 200, 49, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 208, 49, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 73, 0, 0, 0, 224, 49, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 232, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0, 248, 49, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0, 0, 8, 50, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 24, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 32, 50, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 40, 50, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 56, 50, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 64, 50, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 72, 50, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 88, 50, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 96, 50, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 85, 0, 0, 0, 104, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 112, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 128, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 88, 0, 0, 0, 144, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 89, 0, 0, 0, 160, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 90, 0, 0, 0, 168, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 91, 0, 0, 0, 184, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 92, 0, 0, 0, 192, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 93, 0, 0, 0, 208, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 232, 50, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 95, 0, 0, 0, 0, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 0, 16, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0, 0, 32, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0, 40, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 56, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 72, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 101, 0, 0, 0, 80, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 102, 0, 0, 0, 88, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 103, 0, 0, 0, 104, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 104, 0, 0, 0, 120, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 105, 0, 0, 0, 136, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 106, 0, 0, 0, 152, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 107, 0, 0, 0, 168, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 108, 0, 0, 0, 176, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 109, 0, 0, 0, 192, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 110, 0, 0, 0, 208, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 111, 0, 0, 0, 224, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 0, 240, 51, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 113, 0, 0, 0, 0, 52, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 114, 0, 0, 0, 8, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 0, 0, 0, 16, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 116, 0, 0, 0, 24, 52, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 117, 0, 0, 0, 40, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 0, 0, 0, 48, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 0, 0, 0, 56, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 120, 0, 0, 0, 72, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 121, 0, 0, 0, 80, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 122, 0, 0, 0, 88, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 0, 0, 0, 96, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 0, 0, 0, 104, 52, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 125, 0, 0, 0, 112, 52, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 126, 0, 0, 0, 128, 52, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 144, 52, 0, 0, 17, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 152, 52, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 129, 0, 0, 0, 168, 52, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 130, 0, 0, 0, 184, 52, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 131, 0, 0, 0, 200, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 132, 0, 0, 0, 208, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 133, 0, 0, 0, 216, 52, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 134, 0, 0, 0, 224, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 0, 0, 0, 232, 52, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 136, 0, 0, 0, 240, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 0, 0, 0, 248, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 0, 0, 0, 53, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 139, 0, 0, 0, 16, 53, 0, 0, 18, 0, 0, 0, 0, 0, 0, 0, 140, 0, 0, 0, 24, 53, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 141, 0, 0, 0, 32, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 0, 0, 0, 40, 53, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 143, 0, 0, 0, 56, 53, 0, 0, 19, 0, 0, 0, 0, 0, 0, 0, 144, 0, 0, 0, 64, 53, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 145, 0, 0, 0, 72, 53, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 146, 0, 0, 0, 80, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 0, 0, 0, 88, 53, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 148, 0, 0, 0, 104, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 0, 0, 0, 112, 53, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 150, 0, 0, 0, 120, 53, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 151, 0, 0, 0, 128, 53, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 152, 0, 0, 0, 136, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 0, 0, 0, 144, 53, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 154, 0, 0, 0, 160, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 0, 0, 0, 176, 53], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE);
allocate([156, 0, 0, 0, 184, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 0, 0, 0, 192, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 158, 0, 0, 0, 200, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 208, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 0, 0, 0, 216, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 0, 0, 0, 224, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 0, 0, 0, 232, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 0, 0, 0, 240, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 0, 0, 0, 248, 53, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 0, 0, 0, 8, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 0, 0, 0, 24, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 0, 0, 0, 40, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 0, 0, 0, 56, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 169, 0, 0, 0, 72, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 0, 0, 0, 88, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 0, 0, 0, 104, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 0, 0, 0, 112, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 0, 0, 0, 120, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174, 0, 0, 0, 136, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 0, 0, 0, 152, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 0, 0, 0, 160, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 0, 0, 0, 176, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 0, 0, 0, 192, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 0, 0, 0, 208, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 0, 0, 0, 224, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 0, 0, 0, 240, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 0, 0, 0, 248, 54, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 0, 0, 0, 0, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 0, 0, 0, 8, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185, 0, 0, 0, 16, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186, 0, 0, 0, 24, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 0, 0, 0, 32, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 0, 0, 0, 40, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 0, 0, 0, 48, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 0, 0, 0, 64, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 0, 0, 0, 72, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 0, 0, 0, 88, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 0, 0, 0, 96, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 0, 0, 0, 112, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 0, 0, 0, 120, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 0, 0, 0, 128, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 0, 0, 0, 136, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 0, 0, 0, 152, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 0, 0, 0, 168, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200, 0, 0, 0, 184, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201, 0, 0, 0, 208, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 0, 0, 0, 224, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 0, 0, 0, 240, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 0, 0, 0, 248, 55, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205, 0, 0, 0, 8, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 0, 0, 0, 24, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 0, 0, 0, 40, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 0, 0, 0, 56, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 0, 0, 0, 72, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 0, 0, 0, 80, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 0, 0, 0, 104, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 0, 0, 0, 120, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 0, 0, 0, 128, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 0, 0, 0, 136, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 0, 0, 0, 152, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216, 0, 0, 0, 160, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 0, 0, 0, 176, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 0, 0, 0, 192, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 0, 0, 0, 216, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 0, 0, 0, 232, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 0, 0, 0, 248, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 0, 0, 0, 8, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 0, 0, 0, 24, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 0, 0, 0, 40, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 225, 0, 0, 0, 56, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226, 0, 0, 0, 72, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 0, 0, 0, 80, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 0, 0, 0, 88, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 0, 0, 0, 104, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 0, 0, 0, 120, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 0, 0, 0, 136, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 0, 0, 0, 152, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 0, 0, 0, 176, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 234, 0, 0, 0, 184, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 0, 0, 0, 200, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 0, 0, 0, 216, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 0, 0, 0, 232, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 0, 0, 0, 248, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239, 0, 0, 0, 0, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 0, 0, 0, 16, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241, 0, 0, 0, 32, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 0, 0, 0, 48, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 0, 0, 0, 64, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 244, 0, 0, 0, 72, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 0, 0, 0, 88, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 0, 0, 0, 104, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 0, 0, 0, 112, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 0, 0, 0, 128, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 0, 0, 0, 136, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 0, 0, 0, 144, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 0, 0, 0, 152, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 0, 0, 0, 168, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 253, 0, 0, 0, 184, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 0, 0, 0, 200, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 208, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 216, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 232, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0, 0, 240, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 1, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 1, 0, 0, 8, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 1, 0, 0, 16, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 110, 107, 110, 111, 119, 110, 33, 0, 0, 0, 0, 0, 0, 0, 0, 97, 98, 98, 114, 0, 0, 0, 0, 97, 99, 99, 101, 112, 116, 0, 0, 97, 99, 99, 101, 112, 116, 45, 99, 104, 97, 114, 115, 101, 116, 0, 0, 97, 99, 99, 101, 115, 115, 107, 101, 121, 0, 0, 0, 0, 0, 0, 0, 97, 99, 116, 105, 111, 110, 0, 0, 97, 100, 100, 95, 100, 97, 116, 101, 0, 0, 0, 0, 0, 0, 0, 0, 97, 108, 105, 103, 110, 0, 0, 0, 97, 108, 105, 110, 107, 0, 0, 0, 97, 108, 116, 0, 0, 0, 0, 0, 97, 114, 99, 104, 105, 118, 101, 0, 97, 120, 105, 115, 0, 0, 0, 0, 98, 97, 99, 107, 103, 114, 111, 117, 110, 100, 0, 0, 0, 0, 0, 0, 98, 103, 99, 111, 108, 111, 114, 0, 98, 103, 112, 114, 111, 112, 101, 114, 116, 105, 101, 115, 0, 0, 0, 0, 98, 111, 114, 100, 101, 114, 0, 0, 98, 111, 114, 100, 101, 114, 99, 111, 108, 111, 114, 0, 0, 0, 0, 0, 98, 111, 116, 116, 111, 109, 109, 97, 114, 103, 105, 110, 0, 0, 0, 0, 99, 101, 108, 108, 112, 97, 100, 100, 105, 110, 103, 0, 0, 0, 0, 0, 99, 101, 108, 108, 115, 112, 97, 99, 105, 110, 103, 0, 0, 0, 0, 0, 99, 104, 97, 114, 0, 0, 0, 0, 99, 104, 97, 114, 111, 102, 102, 0, 99, 104, 97, 114, 115, 101, 116, 0, 99, 104, 101, 99, 107, 101, 100, 0, 99, 105, 116, 101, 0, 0, 0, 0, 99, 108, 97, 115, 115, 0, 0, 0, 99, 108, 97, 115, 115, 105, 100, 0, 99, 108, 101, 97, 114, 0, 0, 0, 99, 111, 100, 101, 0, 0, 0, 0, 99, 111, 100, 101, 98, 97, 115, 101, 0, 0, 0, 0, 0, 0, 0, 0, 99, 111, 100, 101, 116, 121, 112, 101, 0, 0, 0, 0, 0, 0, 0, 0, 99, 111, 108, 111, 114, 0, 0, 0, 99, 111, 108, 115, 0, 0, 0, 0, 99, 111, 108, 115, 112, 97, 110, 0, 99, 111, 109, 112, 97, 99, 116, 0, 99, 111, 110, 116, 101, 110, 116, 0, 99, 111, 111, 114, 100, 115, 0, 0, 100, 97, 116, 97, 0, 0, 0, 0, 100, 97, 116, 97, 102, 108, 100, 0, 100, 97, 116, 97, 102, 111, 114, 109, 97, 116, 97, 115, 0, 0, 0, 0, 100, 97, 116, 97, 112, 97, 103, 101, 115, 105, 122, 101, 0, 0, 0, 0, 100, 97, 116, 97, 115, 114, 99, 0, 100, 97, 116, 101, 116, 105, 109, 101, 0, 0, 0, 0, 0, 0, 0, 0, 100, 101, 99, 108, 97, 114, 101, 0, 100, 101, 102, 101, 114, 0, 0, 0, 100, 105, 114, 0, 0, 0, 0, 0, 100, 105, 115, 97, 98, 108, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 101, 110, 99, 116, 121, 112, 101, 0, 102, 97, 99, 101, 0, 0, 0, 0, 102, 111, 114, 0, 0, 0, 0, 0, 102, 114, 97, 109, 101, 0, 0, 0, 102, 114, 97, 109, 101, 98, 111, 114, 100, 101, 114, 0, 0, 0, 0, 0, 102, 114, 97, 109, 101, 115, 112, 97, 99, 105, 110, 103, 0, 0, 0, 0, 103, 114, 105, 100, 120, 0, 0, 0, 103, 114, 105, 100, 121, 0, 0, 0, 104, 101, 97, 100, 101, 114, 115, 0, 104, 101, 105, 103, 104, 116, 0, 0, 104, 114, 101, 102, 0, 0, 0, 0, 104, 114, 101, 102, 108, 97, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 104, 115, 112, 97, 99, 101, 0, 0, 104, 116, 116, 112, 45, 101, 113, 117, 105, 118, 0, 0, 0, 0, 0, 0, 105, 100, 0, 0, 0, 0, 0, 0, 105, 115, 109, 97, 112, 0, 0, 0, 105, 116, 101, 109, 112, 114, 111, 112, 0, 0, 0, 0, 0, 0, 0, 0, 108, 97, 98, 101, 108, 0, 0, 0, 108, 97, 110, 103, 0, 0, 0, 0, 108, 97, 110, 103, 117, 97, 103, 101, 0, 0, 0, 0, 0, 0, 0, 0, 108, 97, 115, 116, 95, 109, 111, 100, 105, 102, 105, 101, 100, 0, 0, 0, 108, 97, 115, 116, 95, 118, 105, 115, 105, 116, 0, 0, 0, 0, 0, 0, 108, 101, 102, 116, 109, 97, 114, 103, 105, 110, 0, 0, 0, 0, 0, 0, 108, 105, 110, 107, 0, 0, 0, 0, 108, 111, 110, 103, 100, 101, 115, 99, 0, 0, 0, 0, 0, 0, 0, 0, 108, 111, 119, 115, 114, 99, 0, 0, 109, 97, 114, 103, 105, 110, 104, 101, 105, 103, 104, 116, 0, 0, 0, 0, 109, 97, 114, 103, 105, 110, 119, 105, 100, 116, 104, 0, 0, 0, 0, 0, 109, 97, 120, 108, 101, 110, 103, 116, 104, 0, 0, 0, 0, 0, 0, 0, 109, 101, 100, 105, 97, 0, 0, 0, 109, 101, 116, 104, 111, 100, 0, 0, 109, 117, 108, 116, 105, 112, 108, 101, 0, 0, 0, 0, 0, 0, 0, 0, 110, 97, 109, 101, 0, 0, 0, 0, 110, 111, 104, 114, 101, 102, 0, 0, 110, 111, 114, 101, 115, 105, 122, 101, 0, 0, 0, 0, 0, 0, 0, 0, 110, 111, 115, 104, 97, 100, 101, 0, 110, 111, 119, 114, 97, 112, 0, 0, 111, 98, 106, 101, 99, 116, 0, 0, 111, 110, 97, 102, 116, 101, 114, 117, 112, 100, 97, 116, 101, 0, 0, 0, 111, 110, 98, 101, 102, 111, 114, 101, 117, 110, 108, 111, 97, 100, 0, 0, 111, 110, 98, 101, 102, 111, 114, 101, 117, 112, 100, 97, 116, 101, 0, 0, 111, 110, 98, 108, 117, 114, 0, 0, 111, 110, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 99, 108, 105, 99, 107, 0, 111, 110, 100, 97, 116, 97, 97, 118, 97, 105, 108, 97, 98, 108, 101, 0, 111, 110, 100, 97, 116, 97, 115, 101, 116, 99, 104, 97, 110, 103, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 100, 97, 116, 97, 115, 101, 116, 99, 111, 109, 112, 108, 101, 116, 101, 0, 0, 0, 0, 0, 0, 0, 111, 110, 100, 98, 108, 99, 108, 105, 99, 107, 0, 0, 0, 0, 0, 0, 111, 110, 101, 114, 114, 111, 114, 117, 112, 100, 97, 116, 101, 0, 0, 0, 111, 110, 102, 111, 99, 117, 115, 0, 111, 110, 107, 101, 121, 100, 111, 119, 110, 0, 0, 0, 0, 0, 0, 0, 111, 110, 107, 101, 121, 112, 114, 101, 115, 115, 0, 0, 0, 0, 0, 0, 111, 110, 107, 101, 121, 117, 112, 0, 111, 110, 108, 111, 97, 100, 0, 0, 111, 110, 109, 111, 117, 115, 101, 100, 111, 119, 110, 0, 0, 0, 0, 0, 111, 110, 109, 111, 117, 115, 101, 109, 111, 118, 101, 0, 0, 0, 0, 0, 111, 110, 109, 111, 117, 115, 101, 111, 117, 116, 0, 0, 0, 0, 0, 0, 111, 110, 109, 111, 117, 115, 101, 111, 118, 101, 114, 0, 0, 0, 0, 0, 111, 110, 109, 111, 117, 115, 101, 117, 112, 0, 0, 0, 0, 0, 0, 0, 111, 110, 114, 101, 115, 101, 116, 0, 111, 110, 114, 111, 119, 101, 110, 116, 101, 114, 0, 0, 0, 0, 0, 0, 111, 110, 114, 111, 119, 101, 120, 105, 116, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 101, 108, 101, 99, 116, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 117, 98, 109, 105, 116, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 117, 110, 108, 111, 97, 100, 0, 0, 0, 0, 0, 0, 0, 0, 112, 114, 111, 102, 105, 108, 101, 0, 112, 114, 111, 109, 112, 116, 0, 0, 114, 98, 115, 112, 97, 110, 0, 0, 114, 101, 97, 100, 111, 110, 108, 121, 0, 0, 0, 0, 0, 0, 0, 0, 114, 101, 108, 0, 0, 0, 0, 0, 114, 101, 118, 0, 0, 0, 0, 0, 114, 105, 103, 104, 116, 109, 97, 114, 103, 105, 110, 0, 0, 0, 0, 0, 114, 111, 119, 115, 0, 0, 0, 0, 114, 111, 119, 115, 112, 97, 110, 0, 114, 117, 108, 101, 115, 0, 0, 0, 115, 99, 104, 101, 109, 101, 0, 0, 115, 99, 111, 112, 101, 0, 0, 0, 115, 99, 114, 111, 108, 108, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 115, 101, 108, 101, 99, 116, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 115, 104, 97, 112, 101, 0, 0, 0, 115, 104, 111, 119, 103, 114, 105, 100, 0, 0, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 103, 114, 105, 100, 120, 0, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 103, 114, 105, 100, 121, 0, 0, 0, 0, 0, 0, 0, 115, 105, 122, 101, 0, 0, 0, 0, 115, 112, 97, 110, 0, 0, 0, 0, 115, 114, 99, 0, 0, 0, 0, 0, 115, 116, 97, 110, 100, 98, 121, 0, 115, 116, 97, 114, 116, 0, 0, 0, 115, 116, 121, 108, 101, 0, 0, 0, 115, 117, 109, 109, 97, 114, 121, 0, 116, 97, 98, 105, 110, 100, 101, 120, 0, 0, 0, 0, 0, 0, 0, 0, 116, 97, 114, 103, 101, 116, 0, 0, 116, 101, 120, 116, 0, 0, 0, 0, 116, 105, 116, 108, 101, 0, 0, 0, 116, 111, 112, 109, 97, 114, 103, 105, 110, 0, 0, 0, 0, 0, 0, 0, 116, 121, 112, 101, 0, 0, 0, 0, 117, 115, 101, 109, 97, 112, 0, 0, 118, 97, 108, 105, 103, 110, 0, 0, 118, 97, 108, 117, 101, 0, 0, 0, 118, 97, 108, 117, 101, 116, 121, 112, 101, 0, 0, 0, 0, 0, 0, 0, 118, 101, 114, 115, 105, 111, 110, 0, 118, 108, 105, 110, 107, 0, 0, 0, 118, 115, 112, 97, 99, 101, 0, 0, 119, 105, 100, 116, 104, 0, 0, 0, 119, 114, 97, 112, 0, 0, 0, 0, 120, 109, 108, 58, 108, 97, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 120, 109, 108, 58, 115, 112, 97, 99, 101, 0, 0, 0, 0, 0, 0, 0, 120, 109, 108, 110, 115, 0, 0, 0, 101, 118, 101, 110, 116, 0, 0, 0, 109, 101, 116, 104, 111, 100, 115, 0, 110, 0, 0, 0, 0, 0, 0, 0, 115, 100, 97, 102, 111, 114, 109, 0, 115, 100, 97, 112, 114, 101, 102, 0, 115, 100, 97, 115, 117, 102, 102, 0, 117, 114, 110, 0, 0, 0, 0, 0, 97, 115, 121, 110, 99, 0, 0, 0, 97, 117, 116, 111, 99, 111, 109, 112, 108, 101, 116, 101, 0, 0, 0, 0, 97, 117, 116, 111, 102, 111, 99, 117, 115, 0, 0, 0, 0, 0, 0, 0, 97, 117, 116, 111, 112, 108, 97, 121, 0, 0, 0, 0, 0, 0, 0, 0, 99, 104, 97, 108, 108, 101, 110, 103, 101, 0, 0, 0, 0, 0, 0, 0, 99, 111, 110, 116, 101, 110, 116, 101, 100, 105, 116, 97, 98, 108, 101, 0, 99, 111, 110, 116, 101, 120, 116, 109, 101, 110, 117, 0, 0, 0, 0, 0, 99, 111, 110, 116, 114, 111, 108, 115, 0, 0, 0, 0, 0, 0, 0, 0, 100, 101, 102, 97, 117, 108, 116, 0, 100, 105, 114, 110, 97, 109, 101, 0, 100, 114, 97, 103, 103, 97, 98, 108, 101, 0, 0, 0, 0, 0, 0, 0, 100, 114, 111, 112, 122, 111, 110, 101, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 114, 109, 0, 0, 0, 0, 102, 111, 114, 109, 97, 99, 116, 105, 111, 110, 0, 0, 0, 0, 0, 0, 102, 111, 114, 109, 101, 110, 99, 116, 121, 112, 101, 0, 0, 0, 0, 0, 102, 111, 114, 109, 109, 101, 116, 104, 111, 100, 0, 0, 0, 0, 0, 0, 102, 111, 114, 109, 110, 111, 118, 97, 108, 105, 100, 97, 116, 101, 0, 0, 102, 111, 114, 109, 116, 97, 114, 103, 101, 116, 0, 0, 0, 0, 0, 0, 104, 105, 100, 100, 101, 110, 0, 0, 104, 105, 103, 104, 0, 0, 0, 0, 105, 99, 111, 110, 0, 0, 0, 0, 107, 101, 121, 116, 121, 112, 101, 0, 107, 105, 110, 100, 0, 0, 0, 0, 108, 105, 115, 116, 0, 0, 0, 0, 108, 111, 111, 112, 0, 0, 0, 0, 108, 111, 119, 0, 0, 0, 0, 0, 109, 97, 110, 105, 102, 101, 115, 116, 0, 0, 0, 0, 0, 0, 0, 0, 109, 97, 120, 0, 0, 0, 0, 0, 109, 101, 100, 105, 97, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 109, 105, 110, 0, 0, 0, 0, 0, 110, 111, 118, 97, 108, 105, 100, 97, 116, 101, 0, 0, 0, 0, 0, 0, 111, 112, 101, 110, 0, 0, 0, 0, 111, 112, 116, 105, 109, 117, 109, 0, 111, 110, 97, 98, 111, 114, 116, 0, 111, 110, 97, 102, 116, 101, 114, 112, 114, 105, 110, 116, 0, 0, 0, 0, 111, 110, 98, 101, 102, 111, 114, 101, 112, 114, 105, 110, 116, 0, 0, 0, 111, 110, 99, 97, 110, 112, 108, 97, 121, 0, 0, 0, 0, 0, 0, 0, 111, 110, 99, 97, 110, 112, 108, 97, 121, 116, 104, 114, 111, 117, 103, 104, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 99, 111, 110, 116, 101, 120, 116, 109, 101, 110, 117, 0, 0, 0, 111, 110, 99, 117, 101, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 0, 111, 110, 100, 114, 97, 103, 0, 0, 111, 110, 100, 114, 97, 103, 101, 110, 100, 0, 0, 0, 0, 0, 0, 0, 111, 110, 100, 114, 97, 103, 101, 110, 116, 101, 114, 0, 0, 0, 0, 0, 111, 110, 100, 114, 97, 103, 108, 101, 97, 118, 101, 0, 0, 0, 0, 0, 111, 110, 100, 114, 97, 103, 111, 118, 101, 114, 0, 0, 0, 0, 0, 0, 111, 110, 100, 114, 97, 103, 115, 116, 97, 114, 116, 0, 0, 0, 0, 0, 111, 110, 100, 114, 111, 112, 0, 0, 111, 110, 100, 117, 114, 97, 116, 105, 111, 110, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 101, 109, 112, 116, 105, 101, 100, 0, 0, 0, 0, 0, 0, 0, 111, 110, 101, 110, 100, 101, 100, 0, 111, 110, 101, 114, 114, 111, 114, 0, 111, 110, 104, 97, 115, 104, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 111, 110, 105, 110, 112, 117, 116, 0, 111, 110, 105, 110, 118, 97, 108, 105, 100, 0, 0, 0, 0, 0, 0, 0, 111, 110, 108, 111, 97, 100, 101, 100, 100, 97, 116, 97, 0, 0, 0, 0, 111, 110, 108, 111, 97, 100, 101, 100, 109, 101, 116, 97, 100, 97, 116, 97, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 108, 111, 97, 100, 115, 116, 97, 114, 116, 0, 0, 0, 0, 0, 111, 110, 109, 101, 115, 115, 97, 103, 101, 0, 0, 0, 0, 0, 0, 0, 111, 110, 109, 111, 117, 115, 101, 119, 104, 101, 101, 108, 0, 0, 0, 0, 111, 110, 111, 102, 102, 108, 105, 110, 101, 0, 0, 0, 0, 0, 0, 0, 111, 110, 111, 110, 108, 105, 110, 101, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 112, 97, 103, 101, 104, 105, 100, 101, 0, 0, 0, 0, 0, 0, 111, 110, 112, 97, 103, 101, 115, 104, 111, 119, 0, 0, 0, 0, 0, 0, 111, 110, 112, 97, 117, 115, 101, 0, 111, 110, 112, 108, 97, 121, 0, 0, 111, 110, 112, 108, 97, 121, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 111, 110, 112, 111, 112, 115, 116, 97, 116, 101, 0, 0, 0, 0, 0, 0, 111, 110, 112, 114, 111, 103, 114, 101, 115, 115, 0, 0, 0, 0, 0, 0, 111, 110, 114, 97, 116, 101, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 111, 110, 114, 101, 97, 100, 121, 115, 116, 97, 116, 101, 99, 104, 97, 110, 103, 101, 0, 0, 0, 0, 0, 0, 111, 110, 114, 101, 100, 111, 0, 0, 111, 110, 114, 101, 115, 105, 122, 101, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 99, 114, 111, 108, 108, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 101, 101, 107, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 101, 101, 107, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 104, 111, 119, 0, 0, 111, 110, 115, 116, 97, 108, 108, 101, 100, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 116, 111, 114, 97, 103, 101, 0, 0, 0, 0, 0, 0, 0, 111, 110, 115, 117, 115, 112, 101, 110, 100, 0, 0, 0, 0, 0, 0, 0, 111, 110, 116, 105, 109, 101, 117, 112, 100, 97, 116, 101, 0, 0, 0, 0, 111, 110, 117, 110, 100, 111, 0, 0, 111, 110, 118, 111, 108, 117, 109, 101, 99, 104, 97, 110, 103, 101, 0, 0, 111, 110, 119, 97, 105, 116, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 112, 97, 116, 116, 101, 114, 110, 0, 112, 108, 97, 99, 101, 104, 111, 108, 100, 101, 114, 0, 0, 0, 0, 0, 112, 111, 115, 116, 101, 114, 0, 0, 112, 114, 101, 108, 111, 97, 100, 0, 112, 117, 98, 100, 97, 116, 101, 0, 114, 97, 100, 105, 111, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 114, 101, 113, 117, 105, 114, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 114, 101, 118, 101, 114, 115, 101, 100, 0, 0, 0, 0, 0, 0, 0, 0, 115, 97, 110, 100, 98, 111, 120, 0, 115, 99, 111, 112, 101, 100, 0, 0, 115, 101, 97, 109, 108, 101, 115, 115, 0, 0, 0, 0, 0, 0, 0, 0, 115, 105, 122, 101, 115, 0, 0, 0, 115, 112, 101, 108, 108, 99, 104, 101, 99, 107, 0, 0, 0, 0, 0, 0, 115, 114, 99, 100, 111, 99, 0, 0, 115, 114, 99, 108, 97, 110, 103, 0, 115, 116, 101, 112, 0, 0, 0, 0, 72, 48, 0, 0, 104, 50, 0, 0, 40, 59, 0, 0, 0, 0, 0, 0, 114, 101, 102, 0, 0, 0, 0, 0, 72, 59, 0, 0, 80, 59, 0, 0, 88, 59, 0, 0, 96, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 111, 112, 0, 0, 0, 0, 0, 109, 105, 100, 100, 108, 101, 0, 0, 98, 111, 116, 116, 111, 109, 0, 0, 98, 97, 115, 101, 108, 105, 110, 101, 0, 0, 0, 0, 0, 0, 0, 0, 128, 59, 0, 0, 136, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 101, 102, 116, 0, 0, 0, 0, 114, 105, 103, 104, 116, 0, 0, 0, 168, 59, 0, 0, 176, 59, 0, 0, 192, 59, 0, 0, 208, 59, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 116, 111, 112, 0, 97, 98, 115, 109, 105, 100, 100, 108, 101, 0, 0, 0, 0, 0, 0, 0, 97, 98, 115, 98, 111, 116, 116, 111, 109, 0, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 98, 111, 116, 116, 111, 109, 0, 0, 0, 0, 0, 0, 24, 53, 0, 0, 64, 60, 0, 0, 80, 60, 0, 0, 96, 60, 0, 0, 104, 60, 0, 0, 112, 60, 0, 0, 120, 60, 0, 0, 240, 54, 0, 0, 128, 60, 0, 0, 136, 60, 0, 0, 24, 48, 0, 0, 144, 60, 0, 0, 128, 48, 0, 0, 152, 60, 0, 0, 168, 60, 0, 0, 176, 60, 0, 0, 184, 60, 0, 0, 192, 60, 0, 0, 200, 60, 0, 0, 208, 60, 0, 0, 216, 60, 0, 0, 224, 60, 0, 0, 232, 60, 0, 0, 0, 0, 0, 0, 112, 97, 115, 115, 119, 111, 114, 100, 0, 0, 0, 0, 0, 0, 0, 0, 99, 104, 101, 99, 107, 98, 111, 120, 0, 0, 0, 0, 0, 0, 0, 0, 114, 97, 100, 105, 111, 0, 0, 0, 115, 117, 98, 109, 105, 116, 0, 0, 114, 101, 115, 101, 116, 0, 0, 0, 102, 105, 108, 101, 0, 0, 0, 0, 105, 109, 97, 103, 101, 0, 0, 0, 98, 117, 116, 116, 111, 110, 0, 0, 100, 97, 116, 101, 0, 0, 0, 0, 100, 97, 116, 101, 116, 105, 109, 101, 45, 108, 111, 99, 97, 108, 0, 0, 101, 109, 97, 105, 108, 0, 0, 0, 109, 111, 110, 116, 104, 0, 0, 0, 110, 117, 109, 98, 101, 114, 0, 0, 114, 97, 110, 103, 101, 0, 0, 0, 115, 101, 97, 114, 99, 104, 0, 0, 116, 101, 108, 0, 0, 0, 0, 0, 116, 105, 109, 101, 0, 0, 0, 0, 117, 114, 108, 0, 0, 0, 0, 0, 119, 101, 101, 107, 0, 0, 0, 0, 136, 60, 0, 0, 104, 60, 0, 0, 112, 60, 0, 0, 0, 0, 0, 0, 16, 61, 0, 0, 24, 61, 0, 0, 32, 61, 0, 0, 0, 0, 0, 0, 100, 105, 115, 99, 0, 0, 0, 0, 115, 113, 117, 97, 114, 101, 0, 0, 99, 105, 114, 99, 108, 101, 0, 0, 56, 61, 0, 0, 64, 61, 0, 0, 72, 61, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0, 105, 0, 0, 0, 0, 0, 0, 0, 104, 61, 0, 0, 112, 61, 0, 0, 120, 61, 0, 0, 128, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 98, 108, 97, 110, 107, 0, 0, 95, 115, 101, 108, 102, 0, 0, 0, 95, 112, 97, 114, 101, 110, 116, 0, 95, 116, 111, 112, 0, 0, 0, 0, 160, 61, 0, 0, 104, 54, 0, 0, 32, 61, 0, 0, 168, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 101, 99, 116, 0, 0, 0, 0, 112, 111, 108, 121, 0, 0, 0, 0, 192, 61, 0, 0, 200, 61, 0, 0, 208, 61, 0, 0, 0, 0, 0, 0, 110, 111, 0, 0, 0, 0, 0, 0, 97, 117, 116, 111, 0, 0, 0, 0, 121, 101, 115, 0, 0, 0, 0, 0, 240, 61, 0, 0, 248, 61, 0, 0, 8, 62, 0, 0, 16, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 111, 119, 0, 0, 0, 0, 0, 114, 111, 119, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 0, 0, 99, 111, 108, 0, 0, 0, 0, 0, 99, 111, 108, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 0, 0, 48, 62, 0, 0, 56, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 101, 116, 0, 0, 0, 0, 0, 112, 111, 115, 116, 0, 0, 0, 0, 80, 62, 0, 0, 88, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 116, 108, 0, 0, 0, 0, 0, 108, 116, 114, 0, 0, 0, 0, 0, 120, 62, 0, 0, 128, 59, 0, 0, 136, 59, 0, 0, 128, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 111, 110, 101, 0, 0, 0, 0, 97, 108, 108, 0, 0, 0, 0, 0, 16, 63, 0, 0, 24, 63, 0, 0, 32, 63, 0, 0, 40, 63, 0, 0, 48, 63, 0, 0, 56, 63, 0, 0, 64, 63, 0, 0, 72, 63, 0, 0, 80, 63, 0, 0, 88, 63, 0, 0, 96, 63, 0, 0, 104, 63, 0, 0, 112, 63, 0, 0, 120, 63, 0, 0, 128, 63, 0, 0, 136, 63, 0, 0, 144, 63, 0, 0, 152, 63, 0, 0, 160, 63, 0, 0, 168, 63, 0, 0, 176, 63, 0, 0, 184, 63, 0, 0, 192, 63, 0, 0, 200, 63, 0, 0, 208, 63, 0, 0, 216, 63, 0, 0, 224, 63, 0, 0, 232, 63, 0, 0, 240, 63, 0, 0, 248, 63, 0, 0, 0, 64, 0, 0, 8, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 108, 97, 99, 107, 0, 0, 0, 35, 48, 48, 48, 48, 48, 48, 0, 103, 114, 101, 101, 110, 0, 0, 0, 35, 48, 48, 56, 48, 48, 48, 0, 115, 105, 108, 118, 101, 114, 0, 0, 35, 67, 48, 67, 48, 67, 48, 0, 108, 105, 109, 101, 0, 0, 0, 0, 35, 48, 48, 70, 70, 48, 48, 0, 103, 114, 97, 121, 0, 0, 0, 0, 35, 56, 48, 56, 48, 56, 48, 0, 111, 108, 105, 118, 101, 0, 0, 0, 35, 56, 48, 56, 48, 48, 48, 0, 119, 104, 105, 116, 101, 0, 0, 0, 35, 70, 70, 70, 70, 70, 70, 0, 121, 101, 108, 108, 111, 119, 0, 0, 35, 70, 70, 70, 70, 48, 48, 0, 109, 97, 114, 111, 111, 110, 0, 0, 35, 56, 48, 48, 48, 48, 48, 0, 110, 97, 118, 121, 0, 0, 0, 0, 35, 48, 48, 48, 48, 56, 48, 0, 114, 101, 100, 0, 0, 0, 0, 0, 35, 70, 70, 48, 48, 48, 48, 0, 98, 108, 117, 101, 0, 0, 0, 0, 35, 48, 48, 48, 48, 70, 70, 0, 112, 117, 114, 112, 108, 101, 0, 0, 35, 56, 48, 48, 48, 56, 48, 0, 116, 101, 97, 108, 0, 0, 0, 0, 35, 48, 48, 56, 48, 56, 48, 0, 102, 117, 99, 104, 115, 105, 97, 0, 35, 70, 70, 48, 48, 70, 70, 0, 97, 113, 117, 97, 0, 0, 0, 0, 35, 48, 48, 70, 70, 70, 70, 0, 97, 98, 99, 100, 101, 102, 0, 0, 128, 59, 0, 0, 136, 59, 0, 0, 48, 64, 0, 0, 56, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 101, 110, 116, 101, 114, 0, 0, 106, 117, 115, 116, 105, 102, 121, 0, 116, 104, 0, 0, 0, 0, 0, 0, 98, 114, 0, 0, 0, 0, 0, 0, 108, 105, 115, 116, 45, 115, 116, 121, 108, 101, 58, 32, 110, 111, 110, 101, 59, 32, 100, 105, 115, 112, 108, 97, 121, 58, 32, 105, 110, 108, 105, 110, 101, 0, 0, 0, 0, 0, 0, 0, 108, 105, 115, 116, 45, 115, 116, 121, 108, 101, 58, 32, 110, 111, 110, 101, 0, 0, 0, 0, 0, 0, 0, 0, 106, 97, 118, 97, 115, 99, 114, 105, 112, 116, 0, 0, 0, 0, 0, 0, 120, 109, 108, 45, 115, 116, 121, 108, 101, 115, 104, 101, 101, 116, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 49, 57, 57, 57, 47, 120, 104, 116, 109, 108, 0, 0, 0, 0, 112, 114, 101, 115, 101, 114, 118, 101, 0, 0, 0, 0, 0, 0, 0, 0, 120, 115, 108, 58, 116, 101, 120, 116, 0, 0, 0, 0, 0, 0, 0, 0, 110, 101, 120, 116, 32, 33, 61, 32, 110, 111, 100, 101, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 112, 97, 114, 115, 101, 114, 46, 99, 0, 0, 0, 0, 0, 0, 65, 116, 116, 114, 105, 98, 117, 116, 101, 67, 104, 101, 99, 107, 115, 0, 112, 97, 100, 100, 105, 110, 103, 45, 108, 101, 102, 116, 58, 32, 50, 101, 120, 59, 32, 109, 97, 114, 103, 105, 110, 45, 108, 101, 102, 116, 58, 32, 48, 101, 120, 59, 32, 109, 97, 114, 103, 105, 110, 45, 116, 111, 112, 58, 32, 48, 101, 120, 59, 32, 109, 97, 114, 103, 105, 110, 45, 98, 111, 116, 116, 111, 109, 58, 32, 48, 101, 120, 0, 0, 0, 0, 0, 0, 0, 0, 104, 101, 97, 100, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 77, 111, 118, 101, 84, 111, 72, 101, 97, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 168, 83, 0, 0, 255, 31, 6, 0, 72, 37, 1, 0, 24, 0, 2, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 176, 83, 0, 0, 252, 31, 6, 0, 240, 39, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 184, 83, 0, 0, 252, 31, 0, 0, 40, 42, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 192, 83, 0, 0, 255, 31, 6, 0, 192, 42, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 200, 83, 0, 0, 218, 6, 0, 0, 8, 45, 1, 0, 16, 24, 1, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 208, 83, 0, 0, 254, 15, 6, 0, 136, 45, 1, 0, 9, 0, 0, 0, 24, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 216, 83, 0, 0, 255, 15, 6, 0, 208, 54, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 224, 83, 0, 0, 255, 31, 6, 0, 16, 57, 1, 0, 5, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 232, 83, 0, 0, 218, 6, 0, 0, 80, 59, 1, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 248, 83, 0, 0, 252, 15, 6, 0, 120, 59, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 0, 84, 0, 0, 254, 15, 0, 0, 176, 61, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 8, 84, 0, 0, 255, 31, 6, 0, 72, 62, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 24, 84, 0, 0, 255, 31, 6, 0, 144, 64, 1, 0, 2, 128, 32, 0, 25, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 32, 84, 0, 0, 255, 31, 6, 0, 112, 67, 1, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 40, 84, 0, 0, 252, 15, 6, 0, 176, 69, 1, 0, 16, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 0, 0, 0, 48, 84, 0, 0, 254, 31, 6, 0, 128, 74, 1, 0, 128, 0, 0, 0, 23, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 56, 84, 0, 0, 218, 6, 0, 0, 192, 76, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 64, 84, 0, 0, 255, 31, 6, 0, 80, 77, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 72, 84, 0, 0, 255, 31, 6, 0, 144, 79, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 80, 84, 0, 0, 252, 15, 6, 0, 208, 81, 1, 0, 129, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 88, 84, 0, 0, 252, 15, 6, 0, 56, 84, 1, 0, 128, 128, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 104, 84, 0, 0, 255, 31, 6, 0, 48, 91, 1, 0, 64, 128, 4, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 112, 84, 0, 0, 252, 15, 6, 0, 112, 93, 1, 0, 24, 0, 2, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 0, 0, 0, 120, 84, 0, 0, 254, 31, 6, 0, 240, 97, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 0, 0, 0, 128, 84, 0, 0, 219, 6, 0, 0, 40, 100, 1, 0, 8, 0, 8, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 136, 84, 0, 0, 254, 31, 6, 0, 208, 100, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 144, 84, 0, 0, 255, 31, 6, 0, 16, 103, 1, 0, 8, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 152, 84, 0, 0, 255, 31, 6, 0, 96, 105, 1, 0, 64, 128, 4, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 0, 0, 0, 160, 84, 0, 0, 255, 31, 6, 0, 160, 107, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 0, 0, 0, 168, 84, 0, 0, 252, 15, 6, 0, 40, 112, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 184, 84, 0, 0, 218, 6, 0, 0, 216, 118, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 192, 84, 0, 0, 255, 31, 6, 0, 96, 121, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 200, 84, 0, 0, 144, 4, 0, 0, 240, 123, 1, 0, 1, 32, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 208, 84, 0, 0, 144, 4, 0, 0, 88, 124, 1, 0, 2, 32, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 224, 84, 0, 0, 255, 31, 6, 0, 160, 124, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 232, 84, 0, 0, 255, 31, 6, 0, 232, 126, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 0, 0, 0, 240, 84, 0, 0, 255, 31, 6, 0, 48, 129, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 248, 84, 0, 0, 255, 31, 6, 0, 120, 131, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 0, 85, 0, 0, 255, 31, 6, 0, 192, 133, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 8, 85, 0, 0, 255, 31, 6, 0, 8, 136, 1, 0, 8, 64, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 16, 85, 0, 0, 255, 31, 6, 0, 80, 138, 1, 0, 2, 128, 32, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 24, 85, 0, 0, 255, 15, 6, 0, 240, 144, 1, 0, 9, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 32, 85, 0, 0, 255, 31, 6, 0, 80, 147, 1, 0, 2, 128, 32, 0, 31, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 40, 85, 0, 0, 255, 15, 6, 0, 160, 149, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 0, 0, 0, 48, 85, 0, 0, 216, 6, 6, 0, 224, 151, 1, 0, 16, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 56, 85, 0, 0, 255, 31, 6, 0, 112, 154, 1, 0, 17, 0, 1, 0, 24, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 64, 85, 0, 0, 255, 31, 6, 0, 16, 157, 1, 0, 17, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 72, 85, 0, 0, 252, 15, 6, 0, 88, 160, 1, 0, 24, 0, 2, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 0, 0, 0, 80, 85, 0, 0, 219, 6, 0, 0, 160, 162, 1, 0, 9, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 88, 85, 0, 0, 255, 31, 6, 0, 240, 162, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 0, 0, 0, 96, 85, 0, 0, 252, 31, 6, 0, 144, 167, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 0, 0, 0, 104, 85, 0, 0, 252, 15, 6, 0, 216, 169, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 0, 0, 0, 112, 85, 0, 0, 255, 31, 6, 0, 24, 172, 1, 0, 32, 128, 4, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 0, 0, 0, 120, 85, 0, 0, 255, 31, 6, 0, 104, 174, 1, 0, 13, 0, 0, 0, 24, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 128, 85, 0, 0, 3, 0, 0, 0, 8, 177, 1, 0, 8, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 136, 85, 0, 0, 254, 15, 6, 0, 32, 177, 1, 0, 16, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 144, 85, 0, 0, 219, 6, 6, 0, 144, 181, 1, 0, 8, 0, 8, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 152, 85, 0, 0, 255, 31, 6, 0, 232, 183, 1, 0, 13, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 0, 0, 0, 160, 85, 0, 0, 216, 6, 0, 0, 240, 190, 1, 0, 8, 32, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 176, 85, 0, 0, 252, 15, 6, 0, 128, 191, 1, 0, 28, 0, 2, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 0, 0, 0, 192, 85, 0, 0, 252, 31, 6, 0, 184, 193, 1, 0, 20, 24, 1, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0, 0, 200, 85, 0, 0, 255, 31, 6, 0, 120, 196, 1, 0, 8, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 0, 0, 0, 208, 85, 0, 0, 252, 15, 6, 0, 216, 198, 1, 0, 0, 132, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 224, 85, 0, 0, 255, 31, 6, 0, 32, 201, 1, 0, 0, 132, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 232, 85, 0, 0, 255, 31, 6, 0, 208, 205, 1, 0, 8, 128, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 240, 85, 0, 0, 254, 31, 6, 0, 24, 208, 1, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 248, 85, 0, 0, 3, 0, 0, 0, 104, 210, 1, 0, 8, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 8, 86, 0, 0, 255, 31, 6, 0, 120, 210, 1, 0, 8, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 16, 86, 0, 0, 252, 31, 6, 0, 16, 215, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 24, 86, 0, 0, 0, 8, 0, 0, 80, 217, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 0, 0, 0, 32, 86, 0, 0, 0, 8, 0, 0, 224, 217, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 40, 86, 0, 0, 0, 8, 6, 0, 112, 218, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 48, 86, 0, 0, 0, 8, 6, 0, 168, 220, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 0, 0, 0, 56, 86, 0, 0, 0, 8, 0, 0, 232, 222, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 0, 0, 0, 64, 86, 0, 0, 0, 8, 6, 0, 120, 223, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 0, 0, 0, 72, 86, 0, 0, 216, 6, 6, 0, 176, 225, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 0, 0, 0, 80, 86, 0, 0, 255, 31, 6, 0, 224, 227, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 0, 0, 0, 88, 86, 0, 0, 254, 15, 6, 0, 32, 230, 1, 0, 28, 0, 2, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 0, 0, 0, 96, 86, 0, 0, 255, 31, 6, 0, 200, 234, 1, 0, 16, 4, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 0, 0, 0, 104, 86, 0, 0, 254, 15, 6, 0, 72, 237, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 0, 0, 0, 112, 86, 0, 0, 252, 31, 6, 0, 200, 241, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 120, 86, 0, 0, 218, 6, 0, 0, 0, 244, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 0, 0, 0, 128, 86, 0, 0, 255, 31, 6, 0, 144, 244, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 0, 0, 0, 136, 86, 0, 0, 254, 15, 6, 0, 208, 246, 1, 0, 12, 0, 0, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 0, 0, 0, 144, 86, 0, 0, 254, 15, 6, 0, 40, 249, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 0, 0, 0, 152, 86, 0, 0, 254, 15, 6, 0, 144, 253, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 0, 0, 0, 160, 86, 0, 0, 254, 31, 6, 0, 200, 255, 1, 0, 8, 0, 0, 0, 38, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 105, 0, 0, 0, 168, 86, 0, 0, 252, 15, 6, 0, 80, 2, 2, 0, 128, 129, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 0, 0, 0, 176, 86, 0, 0, 254, 31, 6, 0, 168, 4, 2, 0, 0, 130, 4, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 0, 0, 0, 184, 86, 0, 0, 255, 31, 6, 0, 80, 7, 2, 0, 16, 4, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 0, 0, 0, 200, 86, 0, 0, 252, 15, 6, 0, 240, 9, 2, 0, 128, 129, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 0, 0, 0, 208, 86, 0, 0, 254, 31, 6, 0, 72, 12, 2, 0, 0, 130, 4, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 0, 0, 0, 216, 86, 0, 0, 252, 15, 6, 0, 240, 14, 2, 0, 128, 129, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 0, 0, 0, 224, 86, 0, 0, 255, 31, 6, 0, 136, 19, 2, 0, 4, 0, 0, 0, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 0, 0, 0, 232, 86, 0, 0, 254, 31, 6, 0, 200, 21, 2, 0, 128, 128, 0, 0, 41, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 0, 0, 0, 240, 86, 0, 0, 255, 15, 0, 0, 128, 26, 2, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 0, 0, 0, 248, 86, 0, 0, 218, 6, 6, 0, 32, 27, 2, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 0, 0, 0, 0, 87, 0, 0, 255, 31, 6, 0, 80, 29, 2, 0, 8, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 0, 0, 0, 8, 87, 0, 0, 255, 31, 6, 0, 160, 31, 2, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 0, 0, 0, 16, 87, 0, 0, 3, 0, 0, 0, 136, 38, 2, 0, 8, 0, 8, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 0, 0, 0, 24, 87, 0, 0, 1, 0, 0, 0, 224, 190, 1, 0, 5, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 32, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 40, 87, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 5, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 48, 87, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 56, 87, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 0, 0, 0, 64, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 72, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 80, 87, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 16, 128, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 88, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 0, 0, 0, 104, 87, 0, 0, 0, 224, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 112, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 120, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 24, 0, 2, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0, 0, 0, 128, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94, 0, 0, 0, 136, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 28, 0, 2, 0, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 0, 0, 0, 144, 87, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 16, 24, 1, 0, 22], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 10248);
allocate([97, 0, 0, 0, 152, 87, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 0, 0, 0, 160, 87, 0, 0, 0, 0, 6, 0, 16, 48, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 0, 0, 0, 168, 87, 0, 0, 0, 0, 6, 0, 64, 50, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 0, 0, 0, 176, 87, 0, 0, 0, 0, 6, 0, 112, 52, 1, 0, 24, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 0, 0, 0, 184, 87, 0, 0, 0, 0, 6, 0, 64, 72, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 0, 0, 0, 192, 87, 0, 0, 0, 0, 6, 0, 160, 86, 1, 0, 21, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, 0, 0, 0, 200, 87, 0, 0, 0, 0, 6, 0, 0, 89, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 0, 0, 0, 216, 87, 0, 0, 0, 0, 6, 0, 184, 95, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 0, 0, 0, 224, 87, 0, 0, 0, 0, 6, 0, 224, 109, 1, 0, 17, 0, 1, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 232, 87, 0, 0, 0, 0, 6, 0, 120, 114, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 248, 87, 0, 0, 0, 0, 6, 0, 168, 116, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 0, 0, 0, 0, 88, 0, 0, 0, 0, 6, 0, 48, 119, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 0, 0, 0, 8, 88, 0, 0, 0, 0, 6, 0, 144, 140, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 0, 0, 0, 16, 88, 0, 0, 0, 0, 6, 0, 192, 142, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 24, 88, 0, 0, 0, 0, 6, 0, 48, 165, 1, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 0, 0, 0, 32, 88, 0, 0, 0, 0, 6, 0, 96, 179, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 0, 0, 0, 40, 88, 0, 0, 0, 0, 6, 0, 72, 186, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 0, 0, 0, 48, 88, 0, 0, 0, 0, 6, 0, 176, 188, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 0, 0, 0, 56, 88, 0, 0, 0, 0, 6, 0, 136, 203, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 0, 0, 0, 64, 88, 0, 0, 0, 0, 6, 0, 200, 212, 1, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 0, 0, 0, 80, 88, 0, 0, 0, 0, 6, 0, 152, 232, 1, 0, 8, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 0, 0, 0, 88, 88, 0, 0, 0, 0, 6, 0, 128, 239, 1, 0, 9, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 0, 0, 0, 96, 88, 0, 0, 0, 0, 6, 0, 96, 251, 1, 0, 8, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 0, 0, 0, 104, 88, 0, 0, 0, 0, 6, 0, 72, 17, 2, 0, 16, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 0, 0, 0, 112, 88, 0, 0, 0, 0, 6, 0, 40, 24, 2, 0, 9, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 0, 0, 0, 120, 88, 0, 0, 0, 0, 6, 0, 224, 33, 2, 0, 24, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 0, 0, 0, 128, 88, 0, 0, 0, 0, 6, 0, 88, 36, 2, 0, 17, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 110, 107, 110, 111, 119, 110, 33, 0, 0, 0, 0, 0, 0, 0, 0, 97, 0, 0, 0, 0, 0, 0, 0, 97, 98, 98, 114, 0, 0, 0, 0, 97, 99, 114, 111, 110, 121, 109, 0, 97, 100, 100, 114, 101, 115, 115, 0, 97, 112, 112, 108, 101, 116, 0, 0, 97, 114, 101, 97, 0, 0, 0, 0, 98, 0, 0, 0, 0, 0, 0, 0, 98, 97, 115, 101, 0, 0, 0, 0, 98, 97, 115, 101, 102, 111, 110, 116, 0, 0, 0, 0, 0, 0, 0, 0, 98, 100, 111, 0, 0, 0, 0, 0, 98, 105, 103, 0, 0, 0, 0, 0, 98, 108, 111, 99, 107, 113, 117, 111, 116, 101, 0, 0, 0, 0, 0, 0, 98, 111, 100, 121, 0, 0, 0, 0, 98, 114, 0, 0, 0, 0, 0, 0, 98, 117, 116, 116, 111, 110, 0, 0, 99, 97, 112, 116, 105, 111, 110, 0, 99, 101, 110, 116, 101, 114, 0, 0, 99, 105, 116, 101, 0, 0, 0, 0, 99, 111, 100, 101, 0, 0, 0, 0, 99, 111, 108, 0, 0, 0, 0, 0, 99, 111, 108, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 0, 0, 0, 0, 0, 0, 100, 101, 108, 0, 0, 0, 0, 0, 100, 102, 110, 0, 0, 0, 0, 0, 100, 105, 114, 0, 0, 0, 0, 0, 100, 105, 118, 0, 0, 0, 0, 0, 100, 108, 0, 0, 0, 0, 0, 0, 100, 116, 0, 0, 0, 0, 0, 0, 101, 109, 0, 0, 0, 0, 0, 0, 102, 105, 101, 108, 100, 115, 101, 116, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 110, 116, 0, 0, 0, 0, 102, 111, 114, 109, 0, 0, 0, 0, 102, 114, 97, 109, 101, 0, 0, 0, 102, 114, 97, 109, 101, 115, 101, 116, 0, 0, 0, 0, 0, 0, 0, 0, 104, 49, 0, 0, 0, 0, 0, 0, 104, 50, 0, 0, 0, 0, 0, 0, 104, 51, 0, 0, 0, 0, 0, 0, 104, 52, 0, 0, 0, 0, 0, 0, 104, 53, 0, 0, 0, 0, 0, 0, 104, 54, 0, 0, 0, 0, 0, 0, 104, 101, 97, 100, 0, 0, 0, 0, 104, 114, 0, 0, 0, 0, 0, 0, 104, 116, 109, 108, 0, 0, 0, 0, 105, 0, 0, 0, 0, 0, 0, 0, 105, 102, 114, 97, 109, 101, 0, 0, 105, 109, 103, 0, 0, 0, 0, 0, 105, 110, 112, 117, 116, 0, 0, 0, 105, 110, 115, 0, 0, 0, 0, 0, 105, 115, 105, 110, 100, 101, 120, 0, 107, 98, 100, 0, 0, 0, 0, 0, 108, 97, 98, 101, 108, 0, 0, 0, 108, 101, 103, 101, 110, 100, 0, 0, 108, 105, 0, 0, 0, 0, 0, 0, 108, 105, 110, 107, 0, 0, 0, 0, 108, 105, 115, 116, 105, 110, 103, 0, 109, 97, 112, 0, 0, 0, 0, 0, 109, 101, 110, 117, 0, 0, 0, 0, 109, 101, 116, 97, 0, 0, 0, 0, 110, 111, 102, 114, 97, 109, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 110, 111, 115, 99, 114, 105, 112, 116, 0, 0, 0, 0, 0, 0, 0, 0, 111, 98, 106, 101, 99, 116, 0, 0, 111, 108, 0, 0, 0, 0, 0, 0, 111, 112, 116, 103, 114, 111, 117, 112, 0, 0, 0, 0, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 0, 0, 112, 0, 0, 0, 0, 0, 0, 0, 112, 97, 114, 97, 109, 0, 0, 0, 112, 108, 97, 105, 110, 116, 101, 120, 116, 0, 0, 0, 0, 0, 0, 0, 112, 114, 101, 0, 0, 0, 0, 0, 113, 0, 0, 0, 0, 0, 0, 0, 114, 98, 0, 0, 0, 0, 0, 0, 114, 98, 99, 0, 0, 0, 0, 0, 114, 112, 0, 0, 0, 0, 0, 0, 114, 116, 0, 0, 0, 0, 0, 0, 114, 116, 99, 0, 0, 0, 0, 0, 114, 117, 98, 121, 0, 0, 0, 0, 115, 0, 0, 0, 0, 0, 0, 0, 115, 97, 109, 112, 0, 0, 0, 0, 115, 99, 114, 105, 112, 116, 0, 0, 115, 101, 108, 101, 99, 116, 0, 0, 115, 109, 97, 108, 108, 0, 0, 0, 115, 112, 97, 110, 0, 0, 0, 0, 115, 116, 114, 105, 107, 101, 0, 0, 115, 116, 114, 111, 110, 103, 0, 0, 115, 116, 121, 108, 101, 0, 0, 0, 115, 117, 98, 0, 0, 0, 0, 0, 115, 117, 112, 0, 0, 0, 0, 0, 116, 97, 98, 108, 101, 0, 0, 0, 116, 98, 111, 100, 121, 0, 0, 0, 116, 100, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 97, 114, 101, 97, 0, 0, 0, 0, 0, 0, 0, 0, 116, 102, 111, 111, 116, 0, 0, 0, 116, 104, 0, 0, 0, 0, 0, 0, 116, 104, 101, 97, 100, 0, 0, 0, 116, 105, 116, 108, 101, 0, 0, 0, 116, 114, 0, 0, 0, 0, 0, 0, 116, 116, 0, 0, 0, 0, 0, 0, 117, 0, 0, 0, 0, 0, 0, 0, 117, 108, 0, 0, 0, 0, 0, 0, 118, 97, 114, 0, 0, 0, 0, 0, 120, 109, 112, 0, 0, 0, 0, 0, 110, 101, 120, 116, 105, 100, 0, 0, 97, 108, 105, 103, 110, 0, 0, 0, 98, 103, 115, 111, 117, 110, 100, 0, 98, 108, 105, 110, 107, 0, 0, 0, 99, 111, 109, 109, 101, 110, 116, 0, 105, 108, 97, 121, 101, 114, 0, 0, 108, 97, 121, 101, 114, 0, 0, 0, 109, 97, 114, 113, 117, 101, 101, 0, 109, 117, 108, 116, 105, 99, 111, 108, 0, 0, 0, 0, 0, 0, 0, 0, 110, 111, 98, 114, 0, 0, 0, 0, 110, 111, 101, 109, 98, 101, 100, 0, 110, 111, 108, 97, 121, 101, 114, 0, 110, 111, 115, 97, 118, 101, 0, 0, 115, 101, 114, 118, 101, 114, 0, 0, 115, 101, 114, 118, 108, 101, 116, 0, 115, 112, 97, 99, 101, 114, 0, 0, 97, 114, 116, 105, 99, 108, 101, 0, 97, 115, 105, 100, 101, 0, 0, 0, 97, 117, 100, 105, 111, 0, 0, 0, 99, 97, 110, 118, 97, 115, 0, 0, 99, 111, 109, 109, 97, 110, 100, 0, 100, 97, 116, 97, 108, 105, 115, 116, 0, 0, 0, 0, 0, 0, 0, 0, 100, 101, 116, 97, 105, 108, 115, 0, 101, 109, 98, 101, 100, 0, 0, 0, 102, 105, 103, 99, 97, 112, 116, 105, 111, 110, 0, 0, 0, 0, 0, 0, 102, 105, 103, 117, 114, 101, 0, 0, 102, 111, 111, 116, 101, 114, 0, 0, 104, 101, 97, 100, 101, 114, 0, 0, 104, 103, 114, 111, 117, 112, 0, 0, 107, 101, 121, 103, 101, 110, 0, 0, 109, 97, 114, 107, 0, 0, 0, 0, 109, 101, 116, 101, 114, 0, 0, 0, 110, 97, 118, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 0, 0, 112, 114, 111, 103, 114, 101, 115, 115, 0, 0, 0, 0, 0, 0, 0, 0, 115, 101, 99, 116, 105, 111, 110, 0, 115, 111, 117, 114, 99, 101, 0, 0, 115, 117, 109, 109, 97, 114, 121, 0, 116, 105, 109, 101, 0, 0, 0, 0, 116, 114, 97, 99, 107, 0, 0, 0, 118, 105, 100, 101, 111, 0, 0, 0, 119, 98, 114, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 104, 114, 101, 102, 0, 0, 0, 0, 114, 101, 108, 0, 0, 0, 0, 0, 97, 108, 116, 0, 0, 0, 0, 0, 115, 114, 99, 0, 0, 0, 0, 0, 108, 101, 102, 116, 0, 0, 0, 0, 114, 105, 103, 104, 116, 0, 0, 0, 116, 111, 112, 0, 0, 0, 0, 0, 98, 111, 116, 116, 111, 109, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 144, 94, 0, 0, 160, 94, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 144, 94, 0, 0, 192, 94, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 144, 94, 0, 0, 216, 94, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 248, 94, 0, 0, 8, 95, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 248, 94, 0, 0, 40, 95, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 248, 94, 0, 0, 72, 95, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 4, 0, 0, 0, 104, 95, 0, 0, 120, 95, 0, 0, 152, 95, 0, 0, 8, 0, 0, 0, 8, 0, 0, 0, 200, 95, 0, 0, 224, 95, 0, 0, 8, 96, 0, 0, 7, 0, 0, 0, 16, 0, 0, 0, 56, 96, 0, 0, 80, 96, 0, 0, 120, 96, 0, 0, 3, 0, 0, 0, 32, 0, 0, 0, 168, 96, 0, 0, 192, 96, 0, 0, 224, 96, 0, 0, 5, 0, 0, 0, 64, 0, 0, 0, 8, 97, 0, 0, 32, 97, 0, 0, 72, 97, 0, 0, 4, 0, 0, 0, 128, 0, 0, 0, 112, 97, 0, 0, 136, 97, 0, 0, 176, 97, 0, 0, 9, 0, 0, 0, 0, 1, 0, 0, 216, 97, 0, 0, 240, 97, 0, 0, 24, 98, 0, 0, 11, 0, 0, 0, 0, 2, 0, 0, 80, 98, 0, 0, 104, 98, 0, 0, 144, 98, 0, 0, 10, 0, 0, 0, 0, 4, 0, 0, 200, 98, 0, 0, 224, 98, 0, 0, 8, 99, 0, 0, 12, 0, 0, 0, 0, 8, 0, 0, 64, 99, 0, 0, 80, 99, 0, 0, 112, 99, 0, 0, 13, 0, 0, 0, 0, 16, 0, 0, 160, 99, 0, 0, 176, 99, 0, 0, 208, 99, 0, 0, 20, 0, 0, 0, 0, 0, 2, 0, 8, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 4, 0, 16, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 84, 105, 100, 121, 32, 102, 111, 114, 32, 72, 84, 77, 76, 53, 32, 40, 101, 120, 112, 101, 114, 105, 109, 101, 110, 116, 97, 108, 41, 32, 37, 115, 0, 0, 0, 103, 101, 110, 101, 114, 97, 116, 111, 114, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 84, 105, 100, 121, 0, 0, 0, 0, 0, 0, 0, 110, 97, 109, 101, 0, 0, 0, 0, 99, 111, 110, 116, 101, 110, 116, 0, 83, 89, 83, 84, 69, 77, 0, 0, 80, 85, 66, 76, 73, 67, 0, 0, 104, 116, 109, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 0, 0, 0, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 108, 101, 120, 101, 114, 46, 99, 0, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 83, 101, 116, 88, 72, 84, 77, 76, 68, 111, 99, 84, 121, 112, 101, 0, 0, 118, 101, 114, 115, 105, 111, 110, 0, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 49, 46, 48, 0, 0, 0, 0, 0, 100, 105, 99, 116, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 73, 110, 102, 101, 114, 114, 101, 100, 84, 97, 103, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 71, 101, 116, 84, 111, 107, 101, 110, 0, 108, 101, 120, 101, 114, 45, 62, 112, 97, 114, 101, 110, 116, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 13, 10, 12, 0, 0, 0, 0, 0, 32, 9, 0, 0, 0, 0, 0, 0, 45, 46, 58, 95, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 97, 98, 99, 100, 101, 102, 65, 66, 67, 68, 69, 70, 0, 0, 0, 0, 112, 104, 112, 0, 0, 0, 0, 0, 120, 109, 108, 0, 0, 0, 0, 0, 67, 68, 65, 84, 65, 91, 0, 0, 106, 97, 118, 97, 115, 99, 114, 105, 112, 116, 58, 0, 0, 0, 0, 0, 60, 120, 109, 108, 32, 0, 0, 0, 97, 108, 116, 0, 0, 0, 0, 0, 116, 105, 116, 108, 101, 0, 0, 0, 118, 97, 108, 117, 101, 0, 0, 0, 112, 114, 111, 109, 112, 116, 0, 0, 100, 111, 99, 45, 62, 100, 111, 99, 73, 110, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 0, 69, 110, 100, 79, 102, 73, 110, 112, 117, 116, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0, 0, 38, 97, 112, 111, 115, 0, 0, 0, 97, 109, 112, 59, 0, 0, 0, 0, 72, 84, 77, 76, 32, 50, 46, 48, 0, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 73, 69, 84, 70, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 50, 46, 48, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 73, 69, 84, 70, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 47, 47, 69, 78, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 50, 46, 48, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 51, 46, 50, 0, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 51, 46, 50, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 51, 46, 50, 32, 70, 105, 110, 97, 108, 47, 47, 69, 78, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 51, 46, 50, 32, 68, 114, 97, 102, 116, 47, 47, 69, 78, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 32, 83, 116, 114, 105, 99, 116, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 82, 69, 67, 45, 104, 116, 109, 108, 52, 48, 47, 115, 116, 114, 105, 99, 116, 46, 100, 116, 100, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 47, 47, 69, 78, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 82, 69, 67, 45, 104, 116, 109, 108, 52, 48, 47, 108, 111, 111, 115, 101, 46, 100, 116, 100, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 32, 70, 114, 97, 109, 101, 115, 101, 116, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 32, 70, 114, 97, 109, 101, 115, 101, 116, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 82, 69, 67, 45, 104, 116, 109, 108, 52, 48, 47, 102, 114, 97, 109, 101, 115, 101, 116, 46, 100, 116, 100, 0, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 83, 116, 114, 105, 99, 116, 0, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 49, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 104, 116, 109, 108, 52, 47, 115, 116, 114, 105, 99, 116, 46, 100, 116, 100, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 47, 47, 69, 78, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 104, 116, 109, 108, 52, 47, 108, 111, 111, 115, 101, 46, 100, 116, 100, 0, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 70, 114, 97, 109, 101, 115, 101, 116, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 70, 114, 97, 109, 101, 115, 101, 116, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 104, 116, 109, 108, 52, 47, 102, 114, 97, 109, 101, 115, 101, 116, 46, 100, 116, 100, 0, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 83, 116, 114, 105, 99, 116, 0, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 83, 116, 114, 105, 99, 116, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 120, 104, 116, 109, 108, 49, 47, 68, 84, 68, 47, 120, 104, 116, 109, 108, 49, 45, 115, 116, 114, 105, 99, 116, 46, 100, 116, 100, 0, 0, 0, 0, 0, 0, 0, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 84, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 47, 47, 69, 78, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 120, 104, 116, 109, 108, 49, 47, 68, 84, 68, 47, 120, 104, 116, 109, 108, 49, 45, 116, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 46, 100, 116, 100, 0, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 70, 114, 97, 109, 101, 115, 101, 116, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 88, 72, 84, 77, 76, 32, 49, 46, 48, 32, 70, 114, 97, 109, 101, 115, 101, 116, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 120, 104, 116, 109, 108, 49, 47, 68, 84, 68, 47, 120, 104, 116, 109, 108, 49, 45, 102, 114, 97, 109, 101, 115, 101, 116, 46, 100, 116, 100, 0, 0, 0, 0, 0, 88, 72, 84, 77, 76, 32, 49, 46, 49, 0, 0, 0, 0, 0, 0, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 88, 72, 84, 77, 76, 32, 49, 46, 49, 47, 47, 69, 78, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 120, 104, 116, 109, 108, 49, 49, 47, 68, 84, 68, 47, 120, 104, 116, 109, 108, 49, 49, 46, 100, 116, 100, 0, 0, 0, 0, 88, 72, 84, 77, 76, 32, 66, 97, 115, 105, 99, 32, 49, 46, 48, 0, 45, 47, 47, 87, 51, 67, 47, 47, 68, 84, 68, 32, 88, 72, 84, 77, 76, 32, 66, 97, 115, 105, 99, 32, 49, 46, 48, 47, 47, 69, 78, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 84, 82, 47, 120, 104, 116, 109, 108, 45, 98, 97, 115, 105, 99, 47, 120, 104, 116, 109, 108, 45, 98, 97, 115, 105, 99, 49, 48, 46, 100, 116, 100, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 53, 0, 0, 0, 88, 72, 84, 77, 76, 53, 0, 0, 116, 101, 120, 116, 47, 106, 97, 118, 97, 115, 99, 114, 105, 112, 116, 0, 116, 101, 120, 116, 47, 99, 115, 115, 0, 0, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 47, 118, 98, 115, 99, 114, 105, 112, 116, 0, 0, 0, 93, 93, 62, 0, 0, 0, 0, 0, 60, 33, 91, 67, 68, 65, 84, 65, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 42, 47, 0, 0, 0, 0, 0, 0, 47, 42, 0, 0, 0, 0, 0, 0, 47, 47, 0, 0, 0, 0, 0, 0, 60, 47, 0, 0, 0, 0, 0, 0, 120, 109, 108, 58, 115, 112, 97, 99, 101, 0, 0, 0, 0, 0, 0, 0, 112, 114, 101, 115, 101, 114, 118, 101, 0, 0, 0, 0, 0, 0, 0, 0, 60, 63, 112, 104, 112, 0, 0, 0, 38, 113, 117, 111, 116, 59, 0, 0, 38, 35, 51, 57, 59, 0, 0, 0, 38, 110, 98, 115, 112, 59, 0, 0, 38, 35, 49, 54, 48, 59, 0, 0, 38, 108, 116, 59, 0, 0, 0, 0, 38, 103, 116, 59, 0, 0, 0, 0, 38, 97, 109, 112, 59, 0, 0, 0, 38, 37, 115, 59, 0, 0, 0, 0, 38, 35, 37, 117, 59, 0, 0, 0, 0, 32, 0, 0, 8, 0, 0, 0, 1, 32, 0, 0, 8, 0, 0, 0, 2, 32, 0, 0, 8, 0, 0, 0, 3, 32, 0, 0, 8, 0, 0, 0, 4, 32, 0, 0, 8, 0, 0, 0, 5, 32, 0, 0, 8, 0, 0, 0, 6, 32, 0, 0, 8, 0, 0, 0, 8, 32, 0, 0, 8, 0, 0, 0, 9, 32, 0, 0, 8, 0, 0, 0, 10, 32, 0, 0, 8, 0, 0, 0, 16, 32, 0, 0, 2, 0, 0, 0, 18, 32, 0, 0, 2, 0, 0, 0, 19, 32, 0, 0, 2, 0, 0, 0, 20, 32, 0, 0, 2, 0, 0, 0, 21, 32, 0, 0, 2, 0, 0, 0, 22, 32, 0, 0, 7, 0, 0, 0, 23, 32, 0, 0, 7, 0, 0, 0, 24, 32, 0, 0, 5, 0, 0, 0, 25, 32, 0, 0, 6, 0, 0, 0, 26, 32, 0, 0, 4, 0, 0, 0, 27, 32, 0, 0, 5, 0, 0, 0, 28, 32, 0, 0, 5, 0, 0, 0, 29, 32, 0, 0, 6, 0, 0, 0, 30, 32, 0, 0, 4, 0, 0, 0, 31, 32, 0, 0, 5, 0, 0, 0, 32, 32, 0, 0, 7, 0, 0, 0, 33, 32, 0, 0, 7, 0, 0, 0, 34, 32, 0, 0, 7, 0, 0, 0, 35, 32, 0, 0, 7, 0, 0, 0, 36, 32, 0, 0, 7, 0, 0, 0, 37, 32, 0, 0, 7, 0, 0, 0, 38, 32, 0, 0, 7, 0, 0, 0, 39, 32, 0, 0, 7, 0, 0, 0, 40, 32, 0, 0, 9, 0, 0, 0, 41, 32, 0, 0, 10, 0, 0, 0, 48, 32, 0, 0, 7, 0, 0, 0, 49, 32, 0, 0, 7, 0, 0, 0, 50, 32, 0, 0, 7, 0, 0, 0, 51, 32, 0, 0, 7, 0, 0, 0, 52, 32, 0, 0, 7, 0, 0, 0, 53, 32, 0, 0, 7, 0, 0, 0, 54, 32, 0, 0, 7, 0, 0, 0, 55, 32, 0, 0, 7, 0, 0, 0, 56, 32, 0, 0, 7, 0, 0, 0, 57, 32, 0, 0, 5, 0, 0, 0, 58, 32, 0, 0, 6, 0, 0, 0, 59, 32, 0, 0, 7, 0, 0, 0, 60, 32, 0, 0, 7, 0, 0, 0, 61, 32, 0, 0, 7, 0, 0, 0, 62, 32, 0, 0, 7, 0, 0, 0, 63, 32, 0, 0, 1, 0, 0, 0, 64, 32, 0, 0, 1, 0, 0, 0, 65, 32, 0, 0, 7, 0, 0, 0, 66, 32, 0, 0, 7, 0, 0, 0, 67, 32, 0, 0, 7, 0, 0, 0, 69, 32, 0, 0, 4, 0, 0, 0, 70, 32, 0, 0, 3, 0, 0, 0, 71, 32, 0, 0, 7, 0, 0, 0, 72, 32, 0, 0, 7, 0, 0, 0, 73, 32, 0, 0, 7, 0, 0, 0, 74, 32, 0, 0, 7, 0, 0, 0, 75, 32, 0, 0, 7, 0, 0, 0, 76, 32, 0, 0, 7, 0, 0, 0, 77, 32, 0, 0, 7, 0, 0, 0, 78, 32, 0, 0, 7, 0, 0, 0, 79, 32, 0, 0, 7, 0, 0, 0, 80, 32, 0, 0, 7, 0, 0, 0, 81, 32, 0, 0, 7, 0, 0, 0, 83, 32, 0, 0, 7, 0, 0, 0, 84, 32, 0, 0, 1, 0, 0, 0, 87, 32, 0, 0, 7, 0, 0, 0, 95, 32, 0, 0, 8, 0, 0, 0, 125, 32, 0, 0, 4, 0, 0, 0, 126, 32, 0, 0, 3, 0, 0, 0, 141, 32, 0, 0, 4, 0, 0, 0, 142, 32, 0, 0, 3, 0, 0, 0, 41, 35, 0, 0, 4, 0, 0, 0, 42, 35, 0, 0, 3, 0, 0, 0, 180, 35, 0, 0, 4, 0, 0, 0, 181, 35, 0, 0, 3, 0, 0, 0, 182, 35, 0, 0, 7, 0, 0, 0, 104, 39, 0, 0, 4, 0, 0, 0, 105, 39, 0, 0, 3, 0, 0, 0, 106, 39, 0, 0, 4, 0, 0, 0, 107, 39, 0, 0, 3, 0, 0, 0, 108, 39, 0, 0, 4, 0, 0, 0, 109, 39, 0, 0, 3, 0, 0, 0, 110, 39, 0, 0, 4, 0, 0, 0, 111, 39, 0, 0, 3, 0, 0, 0, 112, 39, 0, 0, 4, 0, 0, 0, 113, 39, 0, 0, 3, 0, 0, 0, 114, 39, 0, 0, 4, 0, 0, 0, 115, 39, 0, 0, 3, 0, 0, 0, 116, 39, 0, 0, 4, 0, 0, 0, 117, 39, 0, 0, 3, 0, 0, 0, 230, 39, 0, 0, 4, 0, 0, 0, 231, 39, 0, 0, 3, 0, 0, 0, 232, 39, 0, 0, 4, 0, 0, 0, 233, 39, 0, 0, 3, 0, 0, 0, 234, 39, 0, 0, 4, 0, 0, 0, 235, 39, 0, 0, 3, 0, 0, 0, 131, 41, 0, 0, 4, 0, 0, 0, 132, 41, 0, 0, 3, 0, 0, 0, 133, 41, 0, 0, 4, 0, 0, 0, 134, 41, 0, 0, 3, 0, 0, 0, 135, 41, 0, 0, 4, 0, 0, 0, 136, 41, 0, 0, 3, 0, 0, 0, 137, 41, 0, 0, 4, 0, 0, 0, 138, 41, 0, 0, 3, 0, 0, 0, 139, 41, 0, 0, 4, 0, 0, 0, 140, 41, 0, 0, 3, 0, 0, 0, 141, 41, 0, 0, 4, 0, 0, 0, 142, 41, 0, 0, 3, 0, 0, 0, 143, 41, 0, 0, 4, 0, 0, 0, 144, 41, 0, 0, 3, 0, 0, 0, 145, 41, 0, 0, 4, 0, 0, 0, 146, 41, 0, 0, 3, 0, 0, 0, 147, 41, 0, 0, 4, 0, 0, 0, 148, 41, 0, 0, 3, 0, 0, 0, 149, 41, 0, 0, 4, 0, 0, 0, 150, 41, 0, 0, 3, 0, 0, 0, 151, 41, 0, 0, 4, 0, 0, 0, 152, 41, 0, 0, 3, 0, 0, 0, 216, 41, 0, 0, 4, 0, 0, 0, 217, 41, 0, 0, 3, 0, 0, 0, 218, 41, 0, 0, 4, 0, 0, 0, 219, 41, 0, 0, 3, 0, 0, 0, 252, 41, 0, 0, 4, 0, 0, 0, 253, 41, 0, 0, 3, 0, 0, 0, 1, 48, 0, 0, 7, 0, 0, 0, 2, 48, 0, 0, 7, 0, 0, 0, 3, 48, 0, 0, 7, 0, 0, 0, 8, 48, 0, 0, 4, 0, 0, 0, 9, 48, 0, 0, 3, 0, 0, 0, 10, 48, 0, 0, 4, 0, 0, 0, 11, 48, 0, 0, 3, 0, 0, 0, 12, 48, 0, 0, 4, 0, 0, 0, 13, 48, 0, 0, 3, 0, 0, 0, 14, 48, 0, 0, 4, 0, 0, 0, 15, 48, 0, 0, 3, 0, 0, 0, 16, 48, 0, 0, 4, 0, 0, 0, 17, 48, 0, 0, 3, 0, 0, 0, 20, 48, 0, 0, 4, 0, 0, 0, 21, 48, 0, 0, 3, 0, 0, 0, 22, 48, 0, 0, 4, 0, 0, 0, 23, 48, 0, 0, 3, 0, 0, 0, 24, 48, 0, 0, 4, 0, 0, 0, 25, 48, 0, 0, 3, 0, 0, 0, 26, 48, 0, 0, 4, 0, 0, 0, 27, 48, 0, 0, 3, 0, 0, 0, 28, 48, 0, 0, 2, 0, 0, 0, 29, 48, 0, 0, 4, 0, 0, 0, 30, 48, 0, 0, 3, 0, 0, 0, 31, 48, 0, 0, 3, 0, 0, 0, 48, 48, 0, 0, 2, 0, 0, 0, 61, 48, 0, 0, 7, 0, 0, 0, 160, 48, 0, 0, 2, 0, 0, 0, 251, 48, 0, 0, 1, 0, 0, 0, 62, 253, 0, 0, 4, 0, 0, 0, 63, 253, 0, 0, 3, 0, 0, 0, 48, 254, 0, 0, 7, 0, 0, 0, 49, 254, 0, 0, 2, 0, 0, 0, 50, 254, 0, 0, 2, 0, 0, 0, 51, 254, 0, 0, 1, 0, 0, 0, 52, 254, 0, 0, 1, 0, 0, 0, 53, 254, 0, 0, 4, 0, 0, 0, 54, 254, 0, 0, 3, 0, 0, 0, 55, 254, 0, 0, 4, 0, 0, 0, 56, 254, 0, 0, 3, 0, 0, 0, 57, 254, 0, 0, 4, 0, 0, 0, 58, 254, 0, 0, 3, 0, 0, 0, 59, 254, 0, 0, 4, 0, 0, 0, 60, 254, 0, 0, 3, 0, 0, 0, 61, 254, 0, 0, 4, 0, 0, 0, 62, 254, 0, 0, 3, 0, 0, 0, 63, 254, 0, 0, 4, 0, 0, 0, 64, 254, 0, 0, 3, 0, 0, 0, 65, 254, 0, 0, 4, 0, 0, 0, 66, 254, 0, 0, 3, 0, 0, 0, 67, 254, 0, 0, 4, 0, 0, 0, 68, 254, 0, 0, 3, 0, 0, 0, 69, 254, 0, 0, 7, 0, 0, 0, 70, 254, 0, 0, 7, 0, 0, 0, 71, 254, 0, 0, 4, 0, 0, 0, 72, 254, 0, 0, 3, 0, 0, 0, 73, 254, 0, 0, 7, 0, 0, 0, 74, 254, 0, 0, 7, 0, 0, 0, 75, 254, 0, 0, 7, 0, 0, 0, 76, 254, 0, 0, 7, 0, 0, 0, 77, 254, 0, 0, 1, 0, 0, 0, 78, 254, 0, 0, 1, 0, 0, 0, 79, 254, 0, 0, 1, 0, 0, 0, 80, 254, 0, 0, 7, 0, 0, 0, 81, 254, 0, 0, 7, 0, 0, 0, 82, 254, 0, 0, 7, 0, 0, 0, 84, 254, 0, 0, 7, 0, 0, 0, 85, 254, 0, 0, 7, 0, 0, 0, 86, 254, 0, 0, 7, 0, 0, 0, 87, 254, 0, 0, 7, 0, 0, 0, 88, 254, 0, 0, 2, 0, 0, 0, 89, 254, 0, 0, 4, 0, 0, 0, 90, 254, 0, 0, 3, 0, 0, 0, 91, 254, 0, 0, 4, 0, 0, 0, 92, 254, 0, 0, 3, 0, 0, 0, 93, 254, 0, 0, 4, 0, 0, 0, 94, 254, 0, 0, 3, 0, 0, 0, 95, 254, 0, 0, 7, 0, 0, 0, 96, 254, 0, 0, 7, 0, 0, 0, 97, 254, 0, 0, 7, 0, 0, 0, 99, 254, 0, 0, 2, 0, 0, 0, 104, 254, 0, 0, 7, 0, 0, 0, 106, 254, 0, 0, 7, 0, 0, 0, 107, 254, 0, 0, 7, 0, 0, 0, 1, 255, 0, 0, 7, 0, 0, 0, 2, 255, 0, 0, 7, 0, 0, 0, 3, 255, 0, 0, 7, 0, 0, 0, 5, 255, 0, 0, 7, 0, 0, 0, 6, 255, 0, 0, 7, 0, 0, 0, 7, 255, 0, 0, 7, 0, 0, 0, 8, 255, 0, 0, 4, 0, 0, 0, 9, 255, 0, 0, 3, 0, 0, 0, 10, 255, 0, 0, 7, 0, 0, 0, 12, 255, 0, 0, 7, 0, 0, 0, 13, 255, 0, 0, 2, 0, 0, 0, 14, 255, 0, 0, 7, 0, 0, 0, 15, 255, 0, 0, 7, 0, 0, 0, 26, 255, 0, 0, 7, 0, 0, 0, 27, 255, 0, 0, 7, 0, 0, 0, 31, 255, 0, 0, 7, 0, 0, 0, 32, 255, 0, 0, 7, 0, 0, 0, 59, 255, 0, 0, 4, 0, 0, 0, 60, 255, 0, 0, 7, 0, 0, 0, 61, 255, 0, 0, 3, 0, 0, 0, 63, 255, 0, 0, 1, 0, 0, 0, 91, 255, 0, 0, 4, 0, 0, 0, 93, 255, 0, 0, 3, 0, 0, 0, 95, 255, 0, 0, 4, 0, 0, 0, 96, 255, 0, 0, 3, 0, 0, 0, 97, 255, 0, 0, 7, 0, 0, 0, 98, 255, 0, 0, 4, 0, 0, 0, 99, 255, 0, 0, 3, 0, 0, 0, 100, 255, 0, 0, 7, 0, 0, 0, 101, 255, 0, 0, 1, 0, 0, 0, 0, 1, 1, 0, 7, 0, 0, 0, 1, 1, 1, 0, 7, 0, 0, 0, 159, 3, 1, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 63, 0, 0, 0, 0, 0, 0, 63, 62, 0, 0, 0, 0, 0, 0, 60, 35, 0, 0, 0, 0, 0, 0, 35, 62, 0, 0, 0, 0, 0, 0, 60, 37, 0, 0, 0, 0, 0, 0, 37, 62, 0, 0, 0, 0, 0, 0, 60, 33, 91, 0, 0, 0, 0, 0, 93, 62, 0, 0, 0, 0, 0, 0, 60, 63, 120, 109, 108, 0, 0, 0, 115, 116, 97, 110, 100, 97, 108, 111, 110, 101, 0, 0, 0, 0, 0, 0, 80, 85, 66, 76, 73, 67, 0, 0, 83, 89, 83, 84, 69, 77, 0, 0, 60, 33, 68, 79, 67, 84, 89, 80, 69, 32, 0, 0, 0, 0, 0, 0, 32, 80, 85, 66, 76, 73, 67, 32, 0, 0, 0, 0, 0, 0, 0, 0, 32, 83, 89, 83, 84, 69, 77, 32, 0, 0, 0, 0, 0, 0, 0, 0, 60, 33, 45, 45, 0, 0, 0, 0, 45, 45, 0, 0, 0, 0, 0, 0, 110, 111, 100, 101, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 112, 112, 114, 105, 110, 116, 46, 99, 0, 0, 0, 0, 0, 0, 84, 101, 120, 116, 83, 116, 97, 114, 116, 115, 87, 105, 116, 104, 87, 104, 105, 116, 101, 115, 112, 97, 99, 101, 0, 0, 0, 0, 0, 0, 0, 0, 115, 116, 121, 108, 101, 0, 0, 0, 109, 97, 114, 103, 105, 110, 45, 108, 101, 102, 116, 58, 32, 37, 100, 101, 109, 0, 0, 0, 0, 0, 0, 0, 105, 102, 0, 0, 0, 0, 0, 0, 105, 102, 32, 33, 118, 109, 108, 0, 120, 109, 108, 110, 115, 58, 111, 0, 70, 105, 108, 101, 45, 76, 105, 115, 116, 0, 0, 0, 0, 0, 0, 0, 111, 58, 112, 0, 0, 0, 0, 0, 77, 115, 111, 76, 105, 115, 116, 66, 117, 108, 108, 101, 116, 0, 0, 0, 77, 115, 111, 76, 105, 115, 116, 78, 117, 109, 98, 101, 114, 0, 0, 0, 109, 115, 111, 45, 108, 105, 115, 116, 58, 0, 0, 0, 0, 0, 0, 0, 67, 111, 100, 101, 0, 0, 0, 0, 103, 101, 110, 101, 114, 97, 116, 111, 114, 0, 0, 0, 0, 0, 0, 0, 77, 105, 99, 114, 111, 115, 111, 102, 116, 0, 0, 0, 0, 0, 0, 0, 67, 111, 110, 116, 101, 110, 116, 45, 84, 121, 112, 101, 0, 0, 0, 0, 99, 104, 97, 114, 115, 101, 116, 0, 99, 104, 97, 114, 115, 101, 116, 61, 0, 0, 0, 0, 0, 0, 0, 0, 120, 109, 108, 58, 108, 97, 110, 103, 0, 0, 0, 0, 0, 0, 0, 0, 108, 97, 110, 103, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 49, 57, 57, 57, 47, 120, 104, 116, 109, 108, 0, 0, 0, 0, 120, 109, 108, 110, 115, 0, 0, 0, 105, 100, 0, 0, 0, 0, 0, 0, 110, 97, 109, 101, 0, 0, 0, 0, 77, 115, 111, 0, 0, 0, 0, 0, 120, 58, 0, 0, 0, 0, 0, 0, 109, 97, 114, 103, 105, 110, 45, 116, 111, 112, 58, 32, 48, 0, 0, 0, 109, 97, 114, 103, 105, 110, 45, 98, 111, 116, 116, 111, 109, 58, 32, 48, 0, 0, 0, 0, 0, 0, 0, 0, 105, 102, 32, 33, 115, 117, 112, 112, 111, 114, 116, 69, 109, 112, 116, 121, 80, 97, 114, 97, 115, 0, 0, 0, 160, 0, 0, 0, 0, 0, 0, 0, 101, 110, 100, 105, 102, 0, 0, 0, 116, 121, 112, 101, 0, 0, 0, 0, 116, 101, 120, 116, 47, 99, 115, 115, 0, 0, 0, 0, 0, 0, 0, 0, 32, 98, 111, 100, 121, 32, 123, 10, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 98, 97, 99, 107, 103, 114, 111, 117, 110, 100, 45, 105, 109, 97, 103, 101, 58, 32, 117, 114, 108, 40, 0, 0, 0, 0, 0, 0, 0, 0, 41, 59, 10, 0, 0, 0, 0, 0, 32, 32, 98, 97, 99, 107, 103, 114, 111, 117, 110, 100, 45, 99, 111, 108, 111, 114, 58, 32, 0, 0, 0, 0, 59, 10, 0, 0, 0, 0, 0, 0, 32, 32, 99, 111, 108, 111, 114, 58, 32, 0, 0, 0, 0, 0, 0, 0, 32, 125, 10, 0, 0, 0, 0, 0, 32, 58, 108, 105, 110, 107, 0, 0, 32, 58, 118, 105, 115, 105, 116, 101, 100, 0, 0, 0, 0, 0, 0, 0, 32, 58, 97, 99, 116, 105, 118, 101, 0, 0, 0, 0, 0, 0, 0, 0, 32, 123, 32, 99, 111, 108, 111, 114, 58, 32, 0, 0, 0, 0, 0, 0, 99, 108, 97, 115, 115, 0, 0, 0, 99, 111, 108, 111, 114, 58, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 104, 49, 0, 0, 0, 0, 0, 0, 53, 0, 0, 0, 0, 0, 0, 0, 104, 50, 0, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 104, 51, 0, 0, 0, 0, 0, 0, 102, 111, 110, 116, 45, 115, 105, 122, 101, 58, 32, 37, 115, 0, 0, 0, 96, 112, 0, 0, 104, 112, 0, 0, 112, 112, 0, 0, 0, 0, 0, 0, 120, 112, 0, 0, 128, 112, 0, 0, 136, 112, 0, 0, 0, 0, 0, 0, 54, 48, 37, 0, 0, 0, 0, 0, 55, 48, 37, 0, 0, 0, 0, 0, 56, 48, 37, 0, 0, 0, 0, 0, 49, 50, 48, 37, 0, 0, 0, 0, 49, 53, 48, 37, 0, 0, 0, 0, 50, 48, 48, 37, 0, 0, 0, 0, 176, 112, 0, 0, 112, 112, 0, 0, 184, 112, 0, 0, 192, 112, 0, 0, 200, 112, 0, 0, 208, 112, 0, 0, 216, 112, 0, 0, 0, 0, 0, 0, 49, 48, 48, 37, 0, 0, 0, 0, 54, 52, 37, 0, 0, 0, 0, 0, 53, 49, 37, 0, 0, 0, 0, 0, 52, 48, 37, 0, 0, 0, 0, 0, 51, 50, 37, 0, 0, 0, 0, 0, 50, 54, 37, 0, 0, 0, 0, 0, 176, 112, 0, 0, 120, 112, 0, 0, 0, 113, 0, 0, 8, 113, 0, 0, 16, 113, 0, 0, 24, 113, 0, 0, 32, 113, 0, 0, 0, 0, 0, 0, 49, 52, 52, 37, 0, 0, 0, 0, 49, 55, 50, 37, 0, 0, 0, 0, 50, 48, 55, 37, 0, 0, 0, 0, 50, 52, 56, 37, 0, 0, 0, 0, 50, 57, 56, 37, 0, 0, 0, 0, 115, 109, 97, 108, 108, 101, 114, 0, 108, 97, 114, 103, 101, 114, 0, 0, 102, 111, 110, 116, 45, 102, 97, 109, 105, 108, 121, 58, 32, 37, 115, 0, 8, 0, 0, 0, 144, 113, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 168, 113, 0, 0, 0, 0, 0, 0, 90, 0, 0, 0, 192, 113, 0, 0, 1, 0, 0, 0, 99, 0, 0, 0, 192, 113, 0, 0, 1, 0, 0, 0, 114, 0, 0, 0, 224, 113, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 111, 110, 116, 45, 119, 101, 105, 103, 104, 116, 58, 32, 98, 111, 108, 100, 0, 0, 0, 0, 0, 0, 0, 102, 111, 110, 116, 45, 115, 116, 121, 108, 101, 58, 32, 105, 116, 97, 108, 105, 99, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 45, 100, 101, 99, 111, 114, 97, 116, 105, 111, 110, 58, 32, 108, 105, 110, 101, 45, 116, 104, 114, 111, 117, 103, 104, 0, 0, 0, 116, 101, 120, 116, 45, 100, 101, 99, 111, 114, 97, 116, 105, 111, 110, 58, 32, 117, 110, 100, 101, 114, 108, 105, 110, 101, 0, 0, 0, 0, 0, 0, 116, 101, 120, 116, 45, 97, 108, 105, 103, 110, 58, 32, 0, 0, 0, 0, 98, 97, 99, 107, 103, 114, 111, 117, 110, 100, 45, 99, 111, 108, 111, 114, 58, 32, 37, 115, 0, 0, 0, 0, 116, 101, 120, 116, 45, 97, 108, 105, 103, 110, 58, 32, 99, 101, 110, 116, 101, 114, 0, 0, 0, 0, 0, 0, 100, 105, 118, 0, 0, 0, 0, 0, 109, 97, 114, 103, 105, 110, 45, 108, 101, 102, 116, 58, 32, 50, 101, 109, 0, 0, 0, 0, 0, 0, 0, 0, 99, 0, 0, 0, 0, 0, 0, 0, 37, 115, 37, 117, 0, 0, 0, 0, 104, 116, 116, 112, 115, 58, 47, 47, 103, 105, 116, 104, 117, 98, 46, 99, 111, 109, 47, 119, 51, 99, 47, 116, 105, 100, 121, 45, 104, 116, 109, 108, 53, 47, 116, 114, 101, 101, 47, 99, 54, 51, 99, 99, 51, 57, 0, 0, 28, 0, 0, 0, 240, 190, 0, 0, 88, 192, 0, 0, 55, 0, 0, 0, 104, 192, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 112, 193, 0, 0, 0, 0, 0, 0, 54, 0, 0, 0, 112, 194, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 56, 195, 0, 0, 0, 0, 0, 0, 79, 0, 0, 0, 232, 195, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 80, 196, 0, 0, 48, 197, 0, 0, 33, 0, 0, 0, 56, 197, 0, 0, 48, 197, 0, 0, 9, 0, 0, 0, 168, 197, 0, 0, 0, 0, 0, 0, 37, 0, 0, 0, 0, 202, 0, 0, 0, 0, 0, 0, 38, 0, 0, 0, 64, 202, 0, 0, 0, 0, 0, 0, 36, 0, 0, 0, 128, 202, 0, 0, 64, 203, 0, 0, 35, 0, 0, 0, 72, 203, 0, 0, 0, 0, 0, 0, 57, 0, 0, 0, 184, 203, 0, 0, 0, 0, 0, 0, 56, 0, 0, 0, 112, 204, 0, 0, 0, 0, 0, 0, 74, 0, 0, 0, 56, 205, 0, 0, 0, 0, 0, 0, 39, 0, 0, 0, 152, 205, 0, 0, 0, 0, 0, 0, 65, 0, 0, 0, 144, 206, 0, 0, 0, 0, 0, 0, 67, 0, 0, 0, 48, 207, 0, 0, 0, 0, 0, 0, 21, 0, 0, 0, 112, 207, 0, 0, 0, 0, 0, 0, 22, 0, 0, 0, 144, 208, 0, 0, 0, 0, 0, 0, 23, 0, 0, 0, 16, 210, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 72, 210, 0, 0, 0, 0, 0, 0, 24, 0, 0, 0, 152, 210, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 211, 0, 0, 160, 211, 0, 0, 73, 0, 0, 0, 176, 211, 0, 0, 64, 212, 0, 0, 34, 0, 0, 0, 80, 212, 0, 0, 0, 0, 0, 0, 66, 0, 0, 0, 96, 213, 0, 0, 0, 0, 0, 0, 87, 0, 0, 0, 8, 214, 0, 0, 0, 0, 0, 0, 88, 0, 0, 0, 8, 215, 0, 0, 200, 216, 0, 0, 92, 0, 0, 0, 216, 216, 0, 0, 208, 217, 0, 0, 76, 0, 0, 0, 224, 217, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 48, 218, 0, 0, 176, 219, 0, 0, 82, 0, 0, 0, 192, 219, 0, 0, 16, 221, 0, 0, 80, 0, 0, 0, 32, 221, 0, 0, 48, 222, 0, 0, 83, 0, 0, 0, 64, 222, 0, 0, 216, 223, 0, 0, 42, 0, 0, 0, 232, 223, 0, 0, 72, 225, 0, 0, 27, 0, 0, 0, 88, 225, 0, 0, 0, 0, 0, 0, 26, 0, 0, 0, 184, 225, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 8, 228, 0, 0, 0, 0, 0, 0, 45, 0, 0, 0, 48, 229, 0, 0, 0, 0, 0, 0, 43, 0, 0, 0, 136, 229, 0, 0, 0, 0, 0, 0, 44, 0, 0, 0, 112, 230, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 8, 231, 0, 0, 144, 231, 0, 0, 91, 0, 0, 0, 160, 231, 0, 0, 0, 0, 0, 0, 78, 0, 0, 0, 80, 232, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 240, 232, 0, 0, 0, 0, 0, 0, 30, 0, 0, 0, 40, 234, 0, 0, 0, 0, 0, 0, 29, 0, 0, 0, 240, 234, 0, 0, 0, 0, 0, 0, 59, 0, 0, 0, 176, 235, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 192, 236, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 32, 238, 0, 0, 0, 0, 0, 0, 17, 0, 0, 0, 168, 238, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 240, 238, 0, 0, 0, 0, 0, 0, 40, 0, 0, 0, 120, 239, 0, 0, 0, 0, 0, 0, 20, 0, 0, 0, 216, 239, 0, 0, 72, 241, 0, 0, 53, 0, 0, 0, 80, 241, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 160, 241, 0, 0, 8, 242, 0, 0, 63, 0, 0, 0, 16, 242, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 40, 244, 0, 0, 0, 0, 0, 0, 86, 0, 0, 0, 240, 244, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 88, 245, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 128, 245, 0, 0, 0, 0, 0, 0, 85, 0, 0, 0, 48, 246, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 128, 246, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 64, 247, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 192, 247, 0, 0, 248, 250, 0, 0, 50, 0, 0, 0, 8, 251, 0, 0, 0, 0, 0, 0, 51, 0, 0, 0, 136, 251, 0, 0, 0, 0, 0, 0, 47, 0, 0, 0, 8, 252, 0, 0, 208, 252, 0, 0, 48, 0, 0, 0, 216, 252, 0, 0, 0, 0, 0, 0, 71, 0, 0, 0, 64, 253, 0, 0, 16, 254, 0, 0, 4, 0, 0, 0, 24, 254, 0, 0, 0, 1, 1, 0, 5, 0, 0, 0, 16, 1, 1, 0, 120, 1, 1, 0, 75, 0, 0, 0, 128, 1, 1, 0, 0, 0, 0, 0, 77, 0, 0, 0, 224, 1, 1, 0, 0, 0, 0, 0, 6, 0, 0, 0, 144, 3, 1, 0, 104, 4, 1, 0, 7, 0, 0, 0, 112, 4, 1, 0, 0, 0, 0, 0, 13, 0, 0, 0, 16, 5, 1, 0, 144, 5, 1, 0, 52, 0, 0, 0, 152, 5, 1, 0, 0, 0, 0, 0, 69, 0, 0, 0, 32, 6, 1, 0, 0, 0, 0, 0, 61, 0, 0, 0, 48, 7, 1, 0, 0, 0, 0, 0, 62, 0, 0, 0, 192, 7, 1, 0, 0, 0, 0, 0, 58, 0, 0, 0, 216, 7, 1, 0, 0, 0, 0, 0, 14, 0, 0, 0, 40, 9, 1, 0, 144, 9, 1, 0, 19, 0, 0, 0, 152, 9, 1, 0, 0, 0, 0, 0, 12, 0, 0, 0, 40, 10, 1, 0, 0, 0, 0, 0, 60, 0, 0, 0, 88, 10, 1, 0, 0, 0, 0, 0, 15, 0, 0, 0, 16, 11, 1, 0, 0, 0, 0, 0, 89, 0, 0, 0, 248, 11, 1, 0, 0, 0, 0, 0, 90, 0, 0, 0, 120, 12, 1, 0, 0, 0, 0, 0, 93, 0, 0, 0, 216, 12, 1, 0, 0, 0, 0, 0, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 97, 110, 39, 116, 32, 111, 112, 101, 110, 32, 34, 37, 115, 34, 10, 0, 0, 0, 0, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 108, 111, 99, 97, 108, 105, 122, 101, 46, 99, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 85, 110, 107, 110, 111, 119, 110, 79, 112, 116, 105, 111, 110, 0, 0, 0, 0, 0, 0, 117, 110, 107, 110, 111, 119, 110, 32, 111, 112, 116, 105, 111, 110, 58, 32, 37, 115, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 66, 97, 100, 65, 114, 103, 117, 109, 101, 110, 116, 0, 0, 0, 0, 0, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 111, 114, 32, 109, 97, 108, 102, 111, 114, 109, 101, 100, 32, 97, 114, 103, 117, 109, 101, 110, 116, 32, 102, 111, 114, 32, 111, 112, 116, 105, 111, 110, 58, 32, 37, 115, 0, 0, 0, 0, 100, 105, 115, 99, 97, 114, 100, 105, 110, 103, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 85, 43, 37, 48, 52, 88, 0, 0, 78, 85, 76, 76, 0, 0, 0, 0, 102, 109, 116, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 65, 116, 116], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 20496);
allocate([114, 69, 114, 114, 111, 114, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 77, 105, 115, 115, 105, 110, 103, 65, 116, 116, 114, 0, 0, 0, 0, 0, 0, 0, 0, 32, 10, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 70, 105, 114, 115, 116, 44, 32, 115, 101, 97, 114, 99, 104, 32, 108, 101, 102, 116, 32, 102, 114, 111, 109, 32, 116, 104, 101, 32, 99, 101, 108, 108, 39, 115, 32, 112, 111, 115, 105, 116, 105, 111, 110, 32, 116, 111, 32, 102, 105, 110, 100, 32, 114, 111, 119, 32, 104, 101, 97, 100, 101, 114, 32, 99, 101, 108, 108, 115, 46, 10, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 84, 104, 101, 110, 32, 115, 101, 97, 114, 99, 104, 32, 117, 112, 119, 97, 114, 100, 115, 32, 116, 111, 32, 102, 105, 110, 100, 32, 99, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 32, 99, 101, 108, 108, 115, 46, 10, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 84, 104, 101, 32, 115, 101, 97, 114, 99, 104, 32, 105, 110, 32, 97, 32, 103, 105, 118, 101, 110, 32, 100, 105, 114, 101, 99, 116, 105, 111, 110, 32, 115, 116, 111, 112, 115, 32, 119, 104, 101, 110, 32, 116, 104, 101, 32, 101, 100, 103, 101, 32, 111, 102, 32, 116, 104, 101, 32, 116, 97, 98, 108, 101, 32, 105, 115, 10, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 114, 101, 97, 99, 104, 101, 100, 32, 111, 114, 32, 119, 104, 101, 110, 32, 97, 32, 100, 97, 116, 97, 32, 99, 101, 108, 108, 32, 105, 115, 32, 102, 111, 117, 110, 100, 32, 97, 102, 116, 101, 114, 32, 97, 32, 104, 101, 97, 100, 101, 114, 32, 99, 101, 108, 108, 46, 10, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 82, 111, 119, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 114, 101, 32, 105, 110, 115, 101, 114, 116, 101, 100, 32, 105, 110, 116, 111, 32, 116, 104, 101, 32, 108, 105, 115, 116, 32, 105, 110, 32, 116, 104, 101, 32, 111, 114, 100, 101, 114, 32, 116, 104, 101, 121, 32, 97, 112, 112, 101, 97, 114, 32, 105, 110, 10, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 116, 104, 101, 32, 116, 97, 98, 108, 101, 46, 32, 10, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 70, 111, 114, 32, 108, 101, 102, 116, 45, 116, 111, 45, 114, 105, 103, 104, 116, 32, 116, 97, 98, 108, 101, 115, 44, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 114, 101, 32, 105, 110, 115, 101, 114, 116, 101, 100, 32, 102, 114, 111, 109, 32, 108, 101, 102, 116, 32, 116, 111, 32, 114, 105, 103, 104, 116, 46, 10, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 67, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 114, 101, 32, 105, 110, 115, 101, 114, 116, 101, 100, 32, 97, 102, 116, 101, 114, 32, 114, 111, 119, 32, 104, 101, 97, 100, 101, 114, 115, 44, 32, 105, 110, 32, 10, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 116, 104, 101, 32, 111, 114, 100, 101, 114, 32, 116, 104, 101, 121, 32, 97, 112, 112, 101, 97, 114, 32, 105, 110, 32, 116, 104, 101, 32, 116, 97, 98, 108, 101, 44, 32, 102, 114, 111, 109, 32, 116, 111, 112, 32, 116, 111, 32, 98, 111, 116, 116, 111, 109, 46, 32, 10, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 45, 32, 73, 102, 32, 97, 32, 104, 101, 97, 100, 101, 114, 32, 99, 101, 108, 108, 32, 104, 97, 115, 32, 116, 104, 101, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 115, 101, 116, 44, 32, 116, 104, 101, 110, 32, 116, 104, 101, 32, 104, 101, 97, 100, 101, 114, 115, 32, 10, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 100, 32, 98, 121, 32, 116, 104, 105, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 97, 114, 101, 32, 105, 110, 115, 101, 114, 116, 101, 100, 32, 105, 110, 116, 111, 32, 116, 104, 101, 32, 108, 105, 115, 116, 32, 97, 110, 100, 32, 116, 104, 101, 32, 10, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 115, 101, 97, 114, 99, 104, 32, 115, 116, 111, 112, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 99, 117, 114, 114, 101, 110, 116, 32, 100, 105, 114, 101, 99, 116, 105, 111, 110, 46, 10, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 32, 32, 32, 32, 32, 32, 84, 68, 32, 99, 101, 108, 108, 115, 32, 116, 104, 97, 116, 32, 115, 101, 116, 32, 116, 104, 101, 32, 97, 120, 105, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 97, 114, 101, 32, 97, 108, 115, 111, 32, 116, 114, 101, 97, 116, 101, 100, 32, 97, 115, 32, 104, 101, 97, 100, 101, 114, 32, 99, 101, 108, 108, 115, 46, 10, 0, 37, 115, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 87, 97, 114, 110, 105, 110, 103, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 78, 111, 116, 105, 99, 101, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 112, 111, 114, 116, 69, 114, 114, 111, 114, 0, 0, 0, 0, 0, 0, 115, 112, 101, 99, 105, 102, 105, 101, 100, 0, 0, 0, 0, 0, 0, 0, 87, 105, 110, 100, 111, 119, 115, 45, 49, 50, 53, 50, 0, 0, 0, 0, 77, 97, 99, 82, 111, 109, 97, 110, 0, 0, 0, 0, 0, 0, 0, 0, 105, 98, 109, 56, 53, 56, 0, 0, 108, 97, 116, 105, 110, 48, 0, 0, 73, 116, 32, 105, 115, 32, 117, 110, 108, 105, 107, 101, 108, 121, 32, 116, 104, 97, 116, 32, 118, 101, 110, 100, 111, 114, 45, 115, 112, 101, 99, 105, 102, 105, 99, 44, 32, 115, 121, 115, 116, 101, 109, 45, 100, 101, 112, 101, 110, 100, 101, 110, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 10, 0, 0, 0, 0, 0, 0, 0, 0, 119, 111, 114, 107, 32, 119, 105, 100, 101, 108, 121, 32, 101, 110, 111, 117, 103, 104, 32, 111, 110, 32, 116, 104, 101, 32, 87, 111, 114, 108, 100, 32, 87, 105, 100, 101, 32, 87, 101, 98, 59, 32, 121, 111, 117, 32, 115, 104, 111, 117, 108, 100, 32, 97, 118, 111, 105, 100, 32, 117, 115, 105, 110, 103, 32, 116, 104, 101, 32, 10, 0, 0, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 99, 111, 100, 105, 110, 103, 44, 32, 105, 110, 115, 116, 101, 97, 100, 32, 121, 111, 117, 32, 97, 114, 101, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 116, 111, 10, 0, 0, 0, 0, 117, 115, 101, 32, 110, 97, 109, 101, 100, 32, 101, 110, 116, 105, 116, 105, 101, 115, 44, 32, 101, 46, 103, 46, 32, 38, 116, 114, 97, 100, 101, 59, 46, 10, 10, 0, 0, 0, 0, 0, 67, 104, 97, 114, 97, 99, 116, 101, 114, 32, 99, 111, 100, 101, 115, 32, 49, 50, 56, 32, 116, 111, 32, 49, 53, 57, 32, 40, 85, 43, 48, 48, 56, 48, 32, 116, 111, 32, 85, 43, 48, 48, 57, 70, 41, 32, 97, 114, 101, 32, 110, 111, 116, 32, 97, 108, 108, 111, 119, 101, 100, 32, 105, 110, 32, 72, 84, 77, 76, 59, 10, 0, 101, 118, 101, 110, 32, 105, 102, 32, 116, 104, 101, 121, 32, 119, 101, 114, 101, 44, 32, 116, 104, 101, 121, 32, 119, 111, 117, 108, 100, 32, 108, 105, 107, 101, 108, 121, 32, 98, 101, 32, 117, 110, 112, 114, 105, 110, 116, 97, 98, 108, 101, 32, 99, 111, 110, 116, 114, 111, 108, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 46, 10, 0, 0, 0, 0, 0, 0, 0, 0, 84, 105, 100, 121, 32, 97, 115, 115, 117, 109, 101, 100, 32, 121, 111, 117, 32, 119, 97, 110, 116, 101, 100, 32, 116, 111, 32, 114, 101, 102, 101, 114, 32, 116, 111, 32, 97, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 115, 97, 109, 101, 32, 98, 121, 116, 101, 32, 118, 97, 108, 117, 101, 32, 105, 110, 32, 116, 104, 101, 32, 10, 0, 0, 0, 0, 0, 0, 0, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 97, 110, 100, 32, 114, 101, 112, 108, 97, 99, 101, 100, 32, 116, 104, 97, 116, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 85, 110, 105, 99, 111, 100, 101, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 46, 10, 10, 0, 0, 0, 0, 67, 104, 97, 114, 97, 99, 116, 101, 114, 32, 99, 111, 100, 101, 115, 32, 102, 111, 114, 32, 85, 84, 70, 45, 56, 32, 109, 117, 115, 116, 32, 98, 101, 32, 105, 110, 32, 116, 104, 101, 32, 114, 97, 110, 103, 101, 58, 32, 85, 43, 48, 48, 48, 48, 32, 116, 111, 32, 85, 43, 49, 48, 70, 70, 70, 70, 46, 10, 0, 0, 0, 0, 84, 104, 101, 32, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110, 32, 111, 102, 32, 85, 84, 70, 45, 56, 32, 105, 110, 32, 65, 110, 110, 101, 120, 32, 68, 32, 111, 102, 32, 73, 83, 79, 47, 73, 69, 67, 32, 49, 48, 54, 52, 54, 45, 49, 58, 50, 48, 48, 48, 32, 97, 108, 115, 111, 10, 0, 0, 0, 0, 0, 0, 0, 0, 97, 108, 108, 111, 119, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 117, 115, 101, 32, 111, 102, 32, 102, 105, 118, 101, 45, 32, 97, 110, 100, 32, 115, 105, 120, 45, 98, 121, 116, 101, 32, 115, 101, 113, 117, 101, 110, 99, 101, 115, 32, 116, 111, 32, 101, 110, 99, 111, 100, 101, 10, 0, 0, 0, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 116, 104, 97, 116, 32, 97, 114, 101, 32, 111, 117, 116, 115, 105, 100, 101, 32, 116, 104, 101, 32, 114, 97, 110, 103, 101, 32, 111, 102, 32, 116, 104, 101, 32, 85, 110, 105, 99, 111, 100, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 115, 101, 116, 59, 10, 0, 0, 0, 0, 116, 104, 111, 115, 101, 32, 102, 105, 118, 101, 45, 32, 97, 110, 100, 32, 115, 105, 120, 45, 98, 121, 116, 101, 32, 115, 101, 113, 117, 101, 110, 99, 101, 115, 32, 97, 114, 101, 32, 105, 108, 108, 101, 103, 97, 108, 32, 102, 111, 114, 32, 116, 104, 101, 32, 117, 115, 101, 32, 111, 102, 10, 0, 0, 85, 84, 70, 45, 56, 32, 97, 115, 32, 97, 32, 116, 114, 97, 110, 115, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 111, 102, 32, 85, 110, 105, 99, 111, 100, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 46, 32, 73, 83, 79, 47, 73, 69, 67, 32, 49, 48, 54, 52, 54, 10, 0, 100, 111, 101, 115, 32, 110, 111, 116, 32, 97, 108, 108, 111, 119, 32, 109, 97, 112, 112, 105, 110, 103, 32, 111, 102, 32, 117, 110, 112, 97, 105, 114, 101, 100, 32, 115, 117, 114, 114, 111, 103, 97, 116, 101, 115, 44, 32, 110, 111, 114, 32, 85, 43, 70, 70, 70, 69, 32, 97, 110, 100, 32, 85, 43, 70, 70, 70, 70, 10, 0, 0, 0, 40, 98, 117, 116, 32, 105, 116, 32, 100, 111, 101, 115, 32, 97, 108, 108, 111, 119, 32, 111, 116, 104, 101, 114, 32, 110, 111, 110, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 41, 46, 32, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 112, 108, 101, 97, 115, 101, 32, 114, 101, 102, 101, 114, 32, 116, 111, 10, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 117, 110, 105, 99, 111, 100, 101, 46, 111, 114, 103, 47, 117, 110, 105, 99, 111, 100, 101, 32, 97, 110, 100, 32, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 99, 108, 46, 99, 97, 109, 46, 97, 99, 46, 117, 107, 47, 126, 109, 103, 107, 50, 53, 47, 117, 110, 105, 99, 111, 100, 101, 46, 104, 116, 109, 108, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 67, 104, 97, 114, 97, 99, 116, 101, 114, 32, 99, 111, 100, 101, 115, 32, 102, 111, 114, 32, 85, 84, 70, 45, 49, 54, 32, 109, 117, 115, 116, 32, 98, 101, 32, 105, 110, 32, 116, 104, 101, 32, 114, 97, 110, 103, 101, 58, 32, 85, 43, 48, 48, 48, 48, 32, 116, 111, 32, 85, 43, 49, 48, 70, 70, 70, 70, 46, 10, 0, 0, 0, 84, 104, 101, 32, 100, 101, 102, 105, 110, 105, 116, 105, 111, 110, 32, 111, 102, 32, 85, 84, 70, 45, 49, 54, 32, 105, 110, 32, 65, 110, 110, 101, 120, 32, 67, 32, 111, 102, 32, 73, 83, 79, 47, 73, 69, 67, 32, 49, 48, 54, 52, 54, 45, 49, 58, 50, 48, 48, 48, 32, 100, 111, 101, 115, 32, 110, 111, 116, 32, 97, 108, 108, 111, 119, 32, 116, 104, 101, 10, 0, 109, 97, 112, 112, 105, 110, 103, 32, 111, 102, 32, 117, 110, 112, 97, 105, 114, 101, 100, 32, 115, 117, 114, 114, 111, 103, 97, 116, 101, 115, 46, 32, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 112, 108, 101, 97, 115, 101, 32, 114, 101, 102, 101, 114, 32, 116, 111, 10, 0, 0, 0, 85, 82, 73, 115, 32, 109, 117, 115, 116, 32, 98, 101, 32, 112, 114, 111, 112, 101, 114, 108, 121, 32, 101, 115, 99, 97, 112, 101, 100, 44, 32, 116, 104, 101, 121, 32, 109, 117, 115, 116, 32, 110, 111, 116, 32, 99, 111, 110, 116, 97, 105, 110, 32, 117, 110, 101, 115, 99, 97, 112, 101, 100, 10, 0, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 98, 101, 108, 111, 119, 32, 85, 43, 48, 48, 50, 49, 32, 105, 110, 99, 108, 117, 100, 105, 110, 103, 32, 116, 104, 101, 32, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 97, 110, 100, 32, 110, 111, 116, 10, 0, 0, 97, 98, 111, 118, 101, 32, 85, 43, 48, 48, 55, 69, 46, 32, 84, 105, 100, 121, 32, 101, 115, 99, 97, 112, 101, 115, 32, 116, 104, 101, 32, 85, 82, 73, 32, 102, 111, 114, 32, 121, 111, 117, 32, 97, 115, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 98, 121, 10, 0, 0, 0, 72, 84, 77, 76, 32, 52, 46, 48, 49, 32, 115, 101, 99, 116, 105, 111, 110, 32, 66, 46, 50, 46, 49, 32, 97, 110, 100, 32, 88, 77, 76, 32, 49, 46, 48, 32, 115, 101, 99, 116, 105, 111, 110, 32, 52, 46, 50, 46, 50, 46, 32, 83, 111, 109, 101, 32, 117, 115, 101, 114, 32, 97, 103, 101, 110, 116, 115, 10, 0, 0, 0, 0, 117, 115, 101, 32, 97, 110, 111, 116, 104, 101, 114, 32, 97, 108, 103, 111, 114, 105, 116, 104, 109, 32, 116, 111, 32, 101, 115, 99, 97, 112, 101, 32, 115, 117, 99, 104, 32, 85, 82, 73, 115, 32, 97, 110, 100, 32, 115, 111, 109, 101, 32, 115, 101, 114, 118, 101, 114, 45, 115, 105, 100, 101, 100, 10, 0, 0, 0, 0, 0, 0, 0, 0, 115, 99, 114, 105, 112, 116, 115, 32, 100, 101, 112, 101, 110, 100, 32, 111, 110, 32, 116, 104, 97, 116, 46, 32, 73, 102, 32, 121, 111, 117, 32, 119, 97, 110, 116, 32, 116, 111, 32, 100, 101, 112, 101, 110, 100, 32, 111, 110, 32, 116, 104, 97, 116, 44, 32, 121, 111, 117, 32, 109, 117, 115, 116, 10, 0, 0, 0, 0, 0, 0, 0, 0, 101, 115, 99, 97, 112, 101, 32, 116, 104, 101, 32, 85, 82, 73, 32, 98, 121, 32, 121, 111, 117, 114, 32, 111, 119, 110, 46, 32, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 112, 108, 101, 97, 115, 101, 32, 114, 101, 102, 101, 114, 32, 116, 111, 10, 0, 0, 0, 0, 0, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 73, 110, 116, 101, 114, 110, 97, 116, 105, 111, 110, 97, 108, 47, 79, 45, 85, 82, 76, 45, 97, 110, 100, 45, 105, 100, 101, 110, 116, 46, 104, 116, 109, 108, 10, 10, 0, 0, 89, 111, 117, 32, 109, 97, 121, 32, 110, 101, 101, 100, 32, 116, 111, 32, 109, 111, 118, 101, 32, 111, 110, 101, 32, 111, 114, 32, 98, 111, 116, 104, 32, 111, 102, 32, 116, 104, 101, 32, 60, 102, 111, 114, 109, 62, 32, 97, 110, 100, 32, 60, 47, 102, 111, 114, 109, 62, 10, 0, 0, 0, 0, 0, 116, 97, 103, 115, 46, 32, 72, 84, 77, 76, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 112, 114, 111, 112, 101, 114, 108, 121, 32, 110, 101, 115, 116, 101, 100, 32, 97, 110, 100, 32, 102, 111, 114, 109, 32, 101, 108, 101, 109, 101, 110, 116, 115, 10, 0, 0, 0, 0, 0, 0, 0, 0, 97, 114, 101, 32, 110, 111, 32, 101, 120, 99, 101, 112, 116, 105, 111, 110, 46, 32, 70, 111, 114, 32, 105, 110, 115, 116, 97, 110, 99, 101, 32, 121, 111, 117, 32, 115, 104, 111, 117, 108, 100, 32, 110, 111, 116, 32, 112, 108, 97, 99, 101, 32, 116, 104, 101, 32, 60, 102, 111, 114, 109, 62, 10, 0, 105, 110, 32, 111, 110, 101, 32, 116, 97, 98, 108, 101, 32, 99, 101, 108, 108, 32, 97, 110, 100, 32, 116, 104, 101, 32, 60, 47, 102, 111, 114, 109, 62, 32, 105, 110, 32, 97, 110, 111, 116, 104, 101, 114, 46, 32, 73, 102, 32, 116, 104, 101, 32, 60, 102, 111, 114, 109, 62, 32, 105, 115, 10, 0, 112, 108, 97, 99, 101, 100, 32, 98, 101, 102, 111, 114, 101, 32, 97, 32, 116, 97, 98, 108, 101, 44, 32, 116, 104, 101, 32, 60, 47, 102, 111, 114, 109, 62, 32, 99, 97, 110, 110, 111, 116, 32, 98, 101, 32, 112, 108, 97, 99, 101, 100, 32, 105, 110, 115, 105, 100, 101, 32, 116, 104, 101, 10, 0, 116, 97, 98, 108, 101, 33, 32, 78, 111, 116, 101, 32, 116, 104, 97, 116, 32, 111, 110, 101, 32, 102, 111, 114, 109, 32, 99, 97, 110, 39, 116, 32, 98, 101, 32, 110, 101, 115, 116, 101, 100, 32, 105, 110, 115, 105, 100, 101, 32, 97, 110, 111, 116, 104, 101, 114, 33, 10, 10, 0, 0, 0, 0, 0, 84, 104, 101, 32, 116, 97, 98, 108, 101, 32, 115, 117, 109, 109, 97, 114, 121, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 117, 115, 101, 100, 32, 116, 111, 32, 100, 101, 115, 99, 114, 105, 98, 101, 10, 0, 116, 104, 101, 32, 116, 97, 98, 108, 101, 32, 115, 116, 114, 117, 99, 116, 117, 114, 101, 46, 32, 73, 116, 32, 105, 115, 32, 118, 101, 114, 121, 32, 104, 101, 108, 112, 102, 117, 108, 32, 102, 111, 114, 32, 112, 101, 111, 112, 108, 101, 32, 117, 115, 105, 110, 103, 10, 0, 0, 0, 0, 0, 0, 0, 110, 111, 110, 45, 118, 105, 115, 117, 97, 108, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 32, 84, 104, 101, 32, 115, 99, 111, 112, 101, 32, 97, 110, 100, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 102, 111, 114, 10, 0, 0, 0, 0, 0, 0, 116, 97, 98, 108, 101, 32, 99, 101, 108, 108, 115, 32, 97, 114, 101, 32, 117, 115, 101, 102, 117, 108, 32, 102, 111, 114, 32, 115, 112, 101, 99, 105, 102, 121, 105, 110, 103, 32, 119, 104, 105, 99, 104, 32, 104, 101, 97, 100, 101, 114, 115, 32, 97, 112, 112, 108, 121, 10, 0, 0, 0, 0, 0, 0, 116, 111, 32, 101, 97, 99, 104, 32, 116, 97, 98, 108, 101, 32, 99, 101, 108, 108, 44, 32, 101, 110, 97, 98, 108, 105, 110, 103, 32, 110, 111, 110, 45, 118, 105, 115, 117, 97, 108, 32, 98, 114, 111, 119, 115, 101, 114, 115, 32, 116, 111, 32, 112, 114, 111, 118, 105, 100, 101, 10, 0, 0, 0, 0, 97, 32, 109, 101, 97, 110, 105, 110, 103, 102, 117, 108, 32, 99, 111, 110, 116, 101, 120, 116, 32, 102, 111, 114, 32, 101, 97, 99, 104, 32, 99, 101, 108, 108, 46, 10, 10, 0, 0, 0, 84, 104, 101, 32, 97, 108, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 117, 115, 101, 100, 32, 116, 111, 32, 103, 105, 118, 101, 32, 97, 32, 115, 104, 111, 114, 116, 32, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 10, 0, 0, 0, 111, 102, 32, 97, 110, 32, 105, 109, 97, 103, 101, 59, 32, 108, 111, 110, 103, 101, 114, 32, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 115, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 103, 105, 118, 101, 110, 32, 119, 105, 116, 104, 32, 116, 104, 101, 10, 0, 0, 0, 0, 0, 0, 108, 111, 110, 103, 100, 101, 115, 99, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 119, 104, 105, 99, 104, 32, 116, 97, 107, 101, 115, 32, 97, 32, 85, 82, 76, 32, 108, 105, 110, 107, 101, 100, 32, 116, 111, 32, 116, 104, 101, 32, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 46, 10, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 101, 115, 101, 32, 109, 101, 97, 115, 117, 114, 101, 115, 32, 97, 114, 101, 32, 110, 101, 101, 100, 101, 100, 32, 102, 111, 114, 32, 112, 101, 111, 112, 108, 101, 32, 117, 115, 105, 110, 103, 32, 110, 111, 110, 45, 103, 114, 97, 112, 104, 105, 99, 97, 108, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 10, 10, 0, 0, 0, 0, 85, 115, 101, 32, 99, 108, 105, 101, 110, 116, 45, 115, 105, 100, 101, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 115, 32, 105, 110, 32, 112, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 116, 111, 32, 115, 101, 114, 118, 101, 114, 45, 115, 105, 100, 101, 32, 105, 109, 97, 103, 101, 10, 0, 0, 109, 97, 112, 115, 32, 97, 115, 32, 116, 104, 101, 32, 108, 97, 116, 116, 101, 114, 32, 97, 114, 101, 32, 105, 110, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 116, 111, 32, 112, 101, 111, 112, 108, 101, 32, 117, 115, 105, 110, 103, 32, 110, 111, 110, 45, 10, 0, 0, 0, 0, 0, 0, 0, 103, 114, 97, 112, 104, 105, 99, 97, 108, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 32, 73, 110, 32, 97, 100, 100, 105, 116, 105, 111, 110, 44, 32, 99, 108, 105, 101, 110, 116, 45, 115, 105, 100, 101, 32, 109, 97, 112, 115, 32, 97, 114, 101, 32, 101, 97, 115, 105, 101, 114, 10, 0, 0, 0, 116, 111, 32, 115, 101, 116, 32, 117, 112, 32, 97, 110, 100, 32, 112, 114, 111, 118, 105, 100, 101, 32, 105, 109, 109, 101, 100, 105, 97, 116, 101, 32, 102, 101, 101, 100, 98, 97, 99, 107, 32, 116, 111, 32, 117, 115, 101, 114, 115, 46, 10, 10, 0, 0, 0, 0, 70, 111, 114, 32, 104, 121, 112, 101, 114, 116, 101, 120, 116, 32, 108, 105, 110, 107, 115, 32, 100, 101, 102, 105, 110, 101, 100, 32, 117, 115, 105, 110, 103, 32, 97, 32, 99, 108, 105, 101, 110, 116, 45, 115, 105, 100, 101, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 44, 32, 121, 111, 117, 10, 0, 110, 101, 101, 100, 32, 116, 111, 32, 117, 115, 101, 32, 116, 104, 101, 32, 97, 108, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 116, 111, 32, 112, 114, 111, 118, 105, 100, 101, 32, 97, 32, 116, 101, 120, 116, 117, 97, 108, 32, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 10, 0, 111, 102, 32, 116, 104, 101, 32, 108, 105, 110, 107, 32, 102, 111, 114, 32, 112, 101, 111, 112, 108, 101, 32, 117, 115, 105, 110, 103, 32, 110, 111, 110, 45, 103, 114, 97, 112, 104, 105, 99, 97, 108, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 10, 10, 0, 0, 80, 97, 103, 101, 115, 32, 100, 101, 115, 105, 103, 110, 101, 100, 32, 117, 115, 105, 110, 103, 32, 102, 114, 97, 109, 101, 115, 32, 112, 114, 101, 115, 101, 110, 116, 115, 32, 112, 114, 111, 98, 108, 101, 109, 115, 32, 102, 111, 114, 10, 0, 0, 0, 0, 0, 0, 112, 101, 111, 112, 108, 101, 32, 119, 104, 111, 32, 97, 114, 101, 32, 101, 105, 116, 104, 101, 114, 32, 98, 108, 105, 110, 100, 32, 111, 114, 32, 117, 115, 105, 110, 103, 32, 97, 32, 98, 114, 111, 119, 115, 101, 114, 32, 116, 104, 97, 116, 10, 0, 0, 0, 0, 100, 111, 101, 115, 110, 39, 116, 32, 115, 117, 112, 112, 111, 114, 116, 32, 102, 114, 97, 109, 101, 115, 46, 32, 65, 32, 102, 114, 97, 109, 101, 115, 45, 98, 97, 115, 101, 100, 32, 112, 97, 103, 101, 32, 115, 104, 111, 117, 108, 100, 32, 97, 108, 119, 97, 121, 115, 10, 0, 0, 0, 0, 0, 0, 105, 110, 99, 108, 117, 100, 101, 32, 97, 110, 32, 97, 108, 116, 101, 114, 110, 97, 116, 105, 118, 101, 32, 108, 97, 121, 111, 117, 116, 32, 105, 110, 115, 105, 100, 101, 32, 97, 32, 78, 79, 70, 82, 65, 77, 69, 83, 32, 101, 108, 101, 109, 101, 110, 116, 46, 10, 10, 0, 0, 0, 0, 0, 0, 70, 111, 114, 32, 102, 117, 114, 116, 104, 101, 114, 32, 97, 100, 118, 105, 99, 101, 32, 111, 110, 32, 104, 111, 119, 32, 116, 111, 32, 109, 97, 107, 101, 32, 121, 111, 117, 114, 32, 112, 97, 103, 101, 115, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 10, 0, 0, 0, 0, 0, 0, 0, 0, 115, 101, 101, 32, 37, 115, 0, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 87, 65, 73, 47, 71, 76, 0, 0, 0, 0, 0, 0, 0, 0, 32, 97, 110, 100, 32, 37, 115, 0, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 97, 112, 114, 111, 109, 112, 116, 46, 99, 97, 47, 84, 105, 100, 121, 47, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 99, 104, 101, 99, 107, 115, 46, 104, 116, 109, 108, 0, 0, 0, 0, 0, 46, 10, 0, 0, 0, 0, 0, 0, 46, 32, 89, 111, 117, 32, 109, 97, 121, 32, 97, 108, 115, 111, 32, 119, 97, 110, 116, 32, 116, 111, 32, 116, 114, 121, 10, 0, 0, 0, 0, 0, 34, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 99, 97, 115, 116, 46, 111, 114, 103, 47, 98, 111, 98, 98, 121, 47, 34, 32, 119, 104, 105, 99, 104, 32, 105, 115, 32, 97, 32, 102, 114, 101, 101, 32, 87, 101, 98, 45, 98, 97, 115, 101, 100, 10, 0, 115, 101, 114, 118, 105, 99, 101, 32, 102, 111, 114, 32, 99, 104, 101, 99, 107, 105, 110, 103, 32, 85, 82, 76, 115, 32, 102, 111, 114, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 46, 10, 10, 0, 0, 84, 104, 101, 32, 67, 97, 115, 99, 97, 100, 105, 110, 103, 32, 83, 116, 121, 108, 101, 32, 83, 104, 101, 101, 116, 115, 32, 40, 67, 83, 83, 41, 32, 80, 111, 115, 105, 116, 105, 111, 110, 105, 110, 103, 32, 109, 101, 99, 104, 97, 110, 105, 115, 109, 10, 0, 105, 115, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 105, 110, 32, 112, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 116, 111, 32, 116, 104, 101, 32, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 32, 60, 76, 65, 89, 69, 82, 62, 10, 0, 0, 0, 0, 0, 0, 0, 0, 101, 108, 101, 109, 101, 110, 116, 32, 100, 117, 101, 32, 116, 111, 32, 108, 105, 109, 105, 116, 101, 100, 32, 118, 101, 110, 100, 111, 114, 32, 115, 117, 112, 112, 111, 114, 116, 32, 102, 111, 114, 32, 76, 65, 89, 69, 82, 46, 10, 10, 0, 0, 0, 0, 0, 0, 89, 111, 117, 32, 97, 114, 101, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 116, 111, 32, 117, 115, 101, 32, 67, 83, 83, 32, 102, 111, 114, 32, 99, 111, 110, 116, 114, 111, 108, 108, 105, 110, 103, 32, 119, 104, 105, 116, 101, 10, 0, 0, 0, 115, 112, 97, 99, 101, 32, 40, 101, 46, 103, 46, 32, 102, 111, 114, 32, 105, 110, 100, 101, 110, 116, 97, 116, 105, 111, 110, 44, 32, 109, 97, 114, 103, 105, 110, 115, 32, 97, 110, 100, 32, 108, 105, 110, 101, 32, 115, 112, 97, 99, 105, 110, 103, 41, 46, 10, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 101, 32, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 32, 60, 83, 80, 65, 67, 69, 82, 62, 32, 101, 108, 101, 109, 101, 110, 116, 32, 104, 97, 115, 32, 108, 105, 109, 105, 116, 101, 100, 32, 118, 101, 110, 100, 111, 114, 32, 115, 117, 112, 112, 111, 114, 116, 46, 10, 10, 0, 0, 89, 111, 117, 32, 97, 114, 101, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 116, 111, 32, 117, 115, 101, 32, 67, 83, 83, 32, 116, 111, 32, 115, 112, 101, 99, 105, 102, 121, 32, 116, 104, 101, 32, 102, 111, 110, 116, 32, 97, 110, 100, 10, 0, 112, 114, 111, 112, 101, 114, 116, 105, 101, 115, 32, 115, 117, 99, 104, 32, 97, 115, 32, 105, 116, 115, 32, 115, 105, 122, 101, 32, 97, 110, 100, 32, 99, 111, 108, 111, 114, 46, 32, 84, 104, 105, 115, 32, 119, 105, 108, 108, 32, 114, 101, 100, 117, 99, 101, 10, 0, 0, 0, 0, 0, 0, 0, 0, 116, 104, 101, 32, 115, 105, 122, 101, 32, 111, 102, 32, 72, 84, 77, 76, 32, 102, 105, 108, 101, 115, 32, 97, 110, 100, 32, 109, 97, 107, 101, 32, 116, 104, 101, 109, 32, 101, 97, 115, 105, 101, 114, 32, 116, 111, 32, 109, 97, 105, 110, 116, 97, 105, 110, 10, 0, 0, 0, 0, 0, 0, 0, 0, 99, 111, 109, 112, 97, 114, 101, 100, 32, 119, 105, 116, 104, 32, 117, 115, 105, 110, 103, 32, 60, 70, 79, 78, 84, 62, 32, 101, 108, 101, 109, 101, 110, 116, 115, 46, 10, 10, 0, 0, 89, 111, 117, 32, 97, 114, 101, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 116, 111, 32, 117, 115, 101, 32, 67, 83, 83, 32, 116, 111, 32, 99, 111, 110, 116, 114, 111, 108, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 112, 105, 110, 103, 46, 10, 0, 0, 0, 0, 0, 0, 0, 85, 115, 101, 32, 34, 119, 104, 105, 116, 101, 45, 115, 112, 97, 99, 101, 58, 32, 110, 111, 119, 114, 97, 112, 34, 32, 116, 111, 32, 105, 110, 104, 105, 98, 105, 116, 32, 119, 114, 97, 112, 112, 105, 110, 103, 32, 105, 110, 32, 112, 108, 97, 99, 101, 10, 0, 111, 102, 32, 105, 110, 115, 101, 114, 116, 105, 110, 103, 32, 60, 78, 79, 66, 82, 62, 46, 46, 46, 60, 47, 78, 79, 66, 82, 62, 32, 105, 110, 116, 111, 32, 116, 104, 101, 32, 109, 97, 114, 107, 117, 112, 46, 10, 10, 0, 0, 0, 0, 0, 0, 0, 0, 89, 111, 117, 32, 97, 114, 101, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 101, 100, 32, 116, 111, 32, 117, 115, 101, 32, 67, 83, 83, 32, 116, 111, 32, 115, 112, 101, 99, 105, 102, 121, 32, 112, 97, 103, 101, 32, 97, 110, 100, 32, 108, 105, 110, 107, 32, 99, 111, 108, 111, 114, 115, 10, 0, 84, 104, 105, 115, 32, 100, 111, 99, 117, 109, 101, 110, 116, 32, 104, 97, 115, 32, 101, 114, 114, 111, 114, 115, 32, 116, 104, 97, 116, 32, 109, 117, 115, 116, 32, 98, 101, 32, 102, 105, 120, 101, 100, 32, 98, 101, 102, 111, 114, 101, 10, 0, 0, 0, 0, 0, 117, 115, 105, 110, 103, 32, 72, 84, 77, 76, 32, 84, 105, 100, 121, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 116, 105, 100, 105, 101, 100, 32, 117, 112, 32, 118, 101, 114, 115, 105, 111, 110, 46, 10, 10, 0, 0, 0, 0, 0, 0, 65, 98, 111, 117, 116, 32, 116, 104, 105, 115, 32, 102, 111, 114, 107, 32, 111, 102, 32, 84, 105, 100, 121, 58, 32, 104, 116, 116, 112, 58, 47, 47, 119, 51, 99, 46, 103, 105, 116, 104, 117, 98, 46, 99, 111, 109, 47, 116, 105, 100, 121, 45, 104, 116, 109, 108, 53, 47, 10, 0, 0, 0, 0, 0, 66, 117, 103, 32, 114, 101, 112, 111, 114, 116, 115, 32, 97, 110, 100, 32, 99, 111, 109, 109, 101, 110, 116, 115, 58, 32, 104, 116, 116, 112, 115, 58, 47, 47, 103, 105, 116, 104, 117, 98, 46, 99, 111, 109, 47, 119, 51, 99, 47, 116, 105, 100, 121, 45, 104, 116, 109, 108, 53, 47, 105, 115, 115, 117, 101, 115, 47, 10, 0, 0, 0, 0, 79, 114, 32, 115, 101, 110, 100, 32, 113, 117, 101, 115, 116, 105, 111, 110, 115, 32, 97, 110, 100, 32, 99, 111, 109, 109, 101, 110, 116, 115, 32, 116, 111, 32, 104, 116, 109, 108, 45, 116, 105, 100, 121, 64, 119, 51, 46, 111, 114, 103, 10, 0, 0, 0, 0, 0, 76, 97, 116, 101, 115, 116, 32, 72, 84, 77, 76, 32, 115, 112, 101, 99, 105, 102, 105, 99, 97, 116, 105, 111, 110, 58, 32, 104, 116, 116, 112, 58, 47, 47, 100, 101, 118, 46, 119, 51, 46, 111, 114, 103, 47, 104, 116, 109, 108, 53, 47, 115, 112, 101, 99, 45, 97, 117, 116, 104, 111, 114, 45, 118, 105, 101, 119, 47, 10, 0, 0, 0, 72, 84, 77, 76, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 58, 32, 104, 116, 116, 112, 58, 47, 47, 100, 101, 118, 46, 119, 51, 46, 111, 114, 103, 47, 104, 116, 109, 108, 53, 47, 109, 97, 114, 107, 117, 112, 47, 10, 0, 0, 0, 0, 0, 0, 0, 86, 97, 108, 105, 100, 97, 116, 101, 32, 121, 111, 117, 114, 32, 72, 84, 77, 76, 53, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 58, 32, 104, 116, 116, 112, 58, 47, 47, 118, 97, 108, 105, 100, 97, 116, 111, 114, 46, 119, 51, 46, 111, 114, 103, 47, 110, 117, 47, 10, 0, 0, 0, 0, 0, 76, 111, 98, 98, 121, 32, 121, 111, 117, 114, 32, 99, 111, 109, 112, 97, 110, 121, 32, 116, 111, 32, 106, 111, 105, 110, 32, 116, 104, 101, 32, 87, 51, 67, 58, 32, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 119, 51, 46, 111, 114, 103, 47, 67, 111, 110, 115, 111, 114, 116, 105, 117, 109, 10, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 65, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 67, 104, 101, 99, 107, 115, 58, 32, 86, 101, 114, 115, 105, 111, 110, 32, 48, 46, 49, 10, 0, 0, 0, 0, 0, 0, 68, 111, 99, 116, 121, 112, 101, 32, 103, 105, 118, 101, 110, 32, 105, 115, 32, 34, 37, 115, 34, 0, 0, 0, 72, 84, 77, 76, 32, 80, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 0, 0, 0, 0, 0, 0, 0, 0, 68, 111, 99, 117, 109, 101, 110, 116, 32, 99, 111, 110, 116, 101, 110, 116, 32, 108, 111, 111, 107, 115, 32, 108, 105, 107, 101, 32, 37, 115, 0, 0, 78, 111, 32, 115, 121, 115, 116, 101, 109, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 105, 110, 32, 101, 109, 105, 116, 116, 101, 100, 32, 100, 111, 99, 116, 121, 112, 101, 0, 37, 117, 32, 37, 115, 44, 32, 37, 117, 32, 37, 115, 32, 119, 101, 114, 101, 32, 102, 111, 117, 110, 100, 33, 0, 0, 0, 0, 0, 0, 0, 0, 119, 97, 114, 110, 105, 110, 103, 0, 119, 97, 114, 110, 105, 110, 103, 115, 0, 0, 0, 0, 0, 0, 0, 0, 101, 114, 114, 111, 114, 0, 0, 0, 101, 114, 114, 111, 114, 115, 0, 0, 32, 78, 111, 116, 32, 97, 108, 108, 32, 119, 97, 114, 110, 105, 110, 103, 115, 47, 101, 114, 114, 111, 114, 115, 32, 119, 101, 114, 101, 32, 115, 104, 111, 119, 110, 46, 10, 10, 0, 0, 10, 10, 0, 0, 0, 0, 0, 0, 78, 111, 32, 119, 97, 114, 110, 105, 110, 103, 115, 32, 111, 114, 32, 101, 114, 114, 111, 114, 115, 32, 119, 101, 114, 101, 32, 102, 111, 117, 110, 100, 46, 10, 10, 0, 0, 0, 0, 0, 73, 110, 102, 111, 58, 32, 0, 0, 87, 97, 114, 110, 105, 110, 103, 58, 32, 0, 0, 0, 0, 0, 0, 0, 67, 111, 110, 102, 105, 103, 58, 32, 0, 0, 0, 0, 0, 0, 0, 0, 65, 99, 99, 101, 115, 115, 58, 32, 0, 0, 0, 0, 0, 0, 0, 0, 69, 114, 114, 111, 114, 58, 32, 0, 68, 111, 99, 117, 109, 101, 110, 116, 58, 32, 0, 0, 0, 0, 0, 0, 112, 97, 110, 105, 99, 58, 32, 0, 37, 115, 58, 37, 100, 58, 37, 100, 58, 32, 0, 0, 0, 0, 0, 0, 108, 105, 110, 101, 32, 37, 100, 32, 99, 111, 108, 117, 109, 110, 32, 37, 100, 32, 45, 32, 0, 0, 0, 0, 60, 37, 115, 62, 0, 0, 0, 0, 60, 47, 37, 115, 62, 0, 0, 0, 60, 33, 68, 79, 67, 84, 89, 80, 69, 62, 0, 0, 0, 0, 0, 0, 112, 108, 97, 105, 110, 32, 116, 101, 120, 116, 0, 0, 0, 0, 0, 0, 88, 77, 76, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 0, 80, 0, 0, 0, 240, 153, 0, 0, 76, 0, 0, 0, 56, 154, 0, 0, 77, 0, 0, 0, 56, 154, 0, 0, 78, 0, 0, 0, 88, 154, 0, 0, 79, 0, 0, 0, 128, 154, 0, 0, 82, 0, 0, 0, 184, 154, 0, 0, 1, 0, 0, 0, 232, 154, 0, 0, 2, 0, 0, 0, 8, 155, 0, 0, 4, 0, 0, 0, 64, 155, 0, 0, 3, 0, 0, 0, 112, 155, 0, 0, 5, 0, 0, 0, 152, 155, 0, 0, 49, 0, 0, 0, 200, 155, 0, 0, 50, 0, 0, 0, 232, 155, 0, 0, 48, 0, 0, 0, 8, 156, 0, 0, 53, 0, 0, 0, 40, 156, 0, 0, 68, 0, 0, 0, 72, 156, 0, 0, 57, 0, 0, 0, 120, 156, 0, 0, 71, 0, 0, 0, 152, 156, 0, 0, 70, 0, 0, 0, 184, 156, 0, 0, 54, 0, 0, 0, 240, 156, 0, 0, 66, 0, 0, 0, 24, 157, 0, 0, 51, 0, 0, 0, 56, 157, 0, 0, 73, 0, 0, 0, 104, 157, 0, 0, 72, 0, 0, 0, 168, 157, 0, 0, 55, 0, 0, 0, 216, 157, 0, 0, 74, 0, 0, 0, 16, 158, 0, 0, 52, 0, 0, 0, 56, 158, 0, 0, 58, 0, 0, 0, 88, 158, 0, 0, 59, 0, 0, 0, 128, 158, 0, 0, 75, 0, 0, 0, 176, 158, 0, 0, 60, 0, 0, 0, 216, 158, 0, 0, 61, 0, 0, 0, 0, 159, 0, 0, 62, 0, 0, 0, 48, 159, 0, 0, 63, 0, 0, 0, 88, 159, 0, 0, 64, 0, 0, 0, 128, 159, 0, 0, 65, 0, 0, 0, 168, 159, 0, 0, 87, 0, 0, 0, 208, 159, 0, 0, 69, 0, 0, 0, 0, 160, 0, 0, 56, 0, 0, 0, 48, 160, 0, 0, 86, 0, 0, 0, 88, 160, 0, 0, 9, 0, 0, 0, 112, 160, 0, 0, 40, 0, 0, 0, 136, 160, 0, 0, 20, 0, 0, 0, 176, 160, 0, 0, 85, 0, 0, 0, 216, 160, 0, 0, 23, 0, 0, 0, 0, 161, 0, 0, 83, 0, 0, 0, 24, 161, 0, 0, 24, 0, 0, 0, 216, 160, 0, 0, 84, 0, 0, 0, 48, 161, 0, 0, 6, 0, 0, 0, 80, 161, 0, 0, 7, 0, 0, 0, 96, 161, 0, 0, 8, 0, 0, 0, 120, 161, 0, 0, 10, 0, 0, 0, 152, 161, 0, 0, 11, 0, 0, 0, 192, 161, 0, 0, 12, 0, 0, 0, 232, 161, 0, 0, 13, 0, 0, 0, 248, 161, 0, 0, 38, 0, 0, 0, 16, 162, 0, 0, 14, 0, 0, 0, 40, 162, 0, 0, 15, 0, 0, 0, 72, 162, 0, 0, 19, 0, 0, 0, 96, 162, 0, 0, 21, 0, 0, 0, 120, 162, 0, 0, 25, 0, 0, 0, 152, 162, 0, 0, 26, 0, 0, 0, 176, 162, 0, 0, 36, 0, 0, 0, 216, 162, 0, 0, 41, 0, 0, 0, 248, 162, 0, 0, 47, 0, 0, 0, 32, 163, 0, 0, 46, 0, 0, 0, 64, 163, 0, 0, 39, 0, 0, 0, 96, 163, 0, 0, 34, 0, 0, 0, 128, 163, 0, 0, 17, 0, 0, 0, 168, 163, 0, 0, 28, 0, 0, 0, 208, 163, 0, 0, 44, 0, 0, 0, 248, 163, 0, 0, 27, 0, 0, 0, 24, 164, 0, 0, 29, 0, 0, 0, 64, 164, 0, 0, 30, 0, 0, 0, 96, 164, 0, 0, 32, 0, 0, 0, 120, 164, 0, 0, 33, 0, 0, 0, 160, 164, 0, 0, 45, 0, 0, 0, 200, 164, 0, 0, 35, 0, 0, 0, 248, 164, 0, 0, 31, 0, 0, 0, 24, 165, 0, 0, 37, 0, 0, 0, 56, 165, 0, 0, 42, 0, 0, 0, 104, 165, 0, 0, 16, 0, 0, 0, 160, 165, 0, 0, 18, 0, 0, 0, 200, 165, 0, 0, 22, 0, 0, 0, 232, 165, 0, 0, 13, 0, 0, 0, 248, 161, 0, 0, 88, 0, 0, 0, 0, 166, 0, 0, 233, 3, 0, 0, 32, 166, 0, 0, 234, 3, 0, 0, 72, 166, 0, 0, 235, 3, 0, 0, 120, 166, 0, 0, 236, 3, 0, 0, 168, 166, 0, 0, 237, 3, 0, 0, 216, 166, 0, 0, 240, 3, 0, 0, 8, 167, 0, 0, 241, 3, 0, 0, 56, 167, 0, 0, 242, 3, 0, 0, 96, 167, 0, 0, 244, 3, 0, 0, 136, 167, 0, 0, 245, 3, 0, 0, 184, 167, 0, 0, 246, 3, 0, 0, 232, 167, 0, 0, 247, 3, 0, 0, 24, 168, 0, 0, 248, 3, 0, 0, 72, 168, 0, 0, 249, 3, 0, 0, 120, 168, 0, 0, 250, 3, 0, 0, 176, 168, 0, 0, 251, 3, 0, 0, 224, 168, 0, 0, 252, 3, 0, 0, 16, 169, 0, 0, 253, 3, 0, 0, 64, 169, 0, 0, 254, 3, 0, 0, 112, 169, 0, 0, 255, 3, 0, 0, 152, 169, 0, 0, 0, 4, 0, 0, 208, 169, 0, 0, 1, 4, 0, 0, 0, 170, 0, 0, 2, 4, 0, 0, 56, 170, 0, 0, 3, 4, 0, 0, 120, 170, 0, 0, 4, 4, 0, 0, 176, 170, 0, 0, 5, 4, 0, 0, 248, 170, 0, 0, 6, 4, 0, 0, 72, 171, 0, 0, 7, 4, 0, 0, 152, 171, 0, 0, 8, 4, 0, 0, 232, 171, 0, 0, 9, 4, 0, 0, 48, 172, 0, 0, 10, 4, 0, 0, 88, 172, 0, 0, 11, 4, 0, 0, 128, 172, 0, 0, 12, 4, 0, 0, 176, 172, 0, 0, 13, 4, 0, 0, 224, 172, 0, 0, 14, 4, 0, 0, 0, 173, 0, 0, 15, 4, 0, 0, 56, 173, 0, 0, 16, 4, 0, 0, 96, 173, 0, 0, 17, 4, 0, 0, 136, 173, 0, 0, 18, 4, 0, 0, 176, 173, 0, 0, 19, 4, 0, 0, 224, 173, 0, 0, 20, 4, 0, 0, 8, 174, 0, 0, 21, 4, 0, 0, 48, 174, 0, 0, 22, 4, 0, 0, 88, 174, 0, 0, 23, 4, 0, 0, 128, 174, 0, 0, 24, 4, 0, 0, 176, 174, 0, 0, 25, 4, 0, 0, 216, 174, 0, 0, 26, 4, 0, 0, 0, 175, 0, 0, 27, 4, 0, 0, 64, 175, 0, 0, 28, 4, 0, 0, 128, 175, 0, 0, 29, 4, 0, 0, 192, 175, 0, 0, 30, 4, 0, 0, 0, 176, 0, 0, 31, 4, 0, 0, 64, 176, 0, 0, 32, 4, 0, 0, 120, 176, 0, 0, 33, 4, 0, 0, 176, 176, 0, 0, 34, 4, 0, 0, 216, 176, 0, 0, 35, 4, 0, 0, 8, 177, 0, 0, 36, 4, 0, 0, 56, 177, 0, 0, 37, 4, 0, 0, 112, 177, 0, 0, 38, 4, 0, 0, 152, 177, 0, 0, 39, 4, 0, 0, 208, 177, 0, 0, 40, 4, 0, 0, 8, 178, 0, 0, 41, 4, 0, 0, 72, 178, 0, 0, 42, 4, 0, 0, 120, 178, 0, 0, 43, 4, 0, 0, 184, 178, 0, 0, 44, 4, 0, 0, 248, 178, 0, 0, 45, 4, 0, 0, 32, 179, 0, 0, 46, 4, 0, 0, 88, 179, 0, 0, 47, 4, 0, 0, 144, 179, 0, 0, 48, 4, 0, 0, 200, 179, 0, 0, 49, 4, 0, 0, 8, 180, 0, 0, 50, 4, 0, 0, 72, 180, 0, 0, 51, 4, 0, 0, 136, 180, 0, 0, 52, 4, 0, 0, 200, 180, 0, 0, 53, 4, 0, 0, 0, 181, 0, 0, 54, 4, 0, 0, 56, 181, 0, 0, 55, 4, 0, 0, 112, 181, 0, 0, 56, 4, 0, 0, 160, 181, 0, 0, 57, 4, 0, 0, 200, 181, 0, 0, 58, 4, 0, 0, 240, 181, 0, 0, 59, 4, 0, 0, 24, 182, 0, 0, 60, 4, 0, 0, 64, 182, 0, 0, 61, 4, 0, 0, 112, 182, 0, 0, 62, 4, 0, 0, 152, 182, 0, 0, 63, 4, 0, 0, 184, 182, 0, 0, 64, 4, 0, 0, 224, 182, 0, 0, 65, 4, 0, 0, 32, 183, 0, 0, 66, 4, 0, 0, 96, 183, 0, 0, 67, 4, 0, 0, 160, 183, 0, 0, 68, 4, 0, 0, 224, 183, 0, 0, 69, 4, 0, 0, 24, 184, 0, 0, 70, 4, 0, 0, 88, 184, 0, 0, 71, 4, 0, 0, 152, 184, 0, 0, 72, 4, 0, 0, 208, 184, 0, 0, 73, 4, 0, 0, 16, 185, 0, 0, 74, 4, 0, 0, 80, 185, 0, 0, 75, 4, 0, 0, 144, 185, 0, 0, 76, 4, 0, 0, 192, 185, 0, 0, 79, 4, 0, 0, 248, 185, 0, 0, 80, 4, 0, 0, 40, 186, 0, 0, 81, 4, 0, 0, 96, 186, 0, 0, 82, 4, 0, 0, 152, 186, 0, 0, 83, 4, 0, 0, 200, 186, 0, 0, 84, 4, 0, 0, 248, 186, 0, 0, 85, 4, 0, 0, 40, 187, 0, 0, 86, 4, 0, 0, 88, 187, 0, 0, 87, 4, 0, 0, 136, 187, 0, 0, 88, 4, 0, 0, 184, 187, 0, 0, 89, 4, 0, 0, 232, 187, 0, 0, 90, 4, 0, 0, 24, 188, 0, 0, 91, 4, 0, 0, 72, 188, 0, 0, 92, 4, 0, 0, 120, 188, 0, 0, 93, 4, 0, 0, 160, 188, 0, 0, 94, 4, 0, 0, 208, 188, 0, 0, 95, 4, 0, 0, 0, 189, 0, 0, 96, 4, 0, 0, 64, 189, 0, 0, 97, 4, 0, 0, 136, 189, 0, 0, 98, 4, 0, 0, 208, 189, 0, 0, 99, 4, 0, 0, 248, 189, 0, 0, 100, 4, 0, 0, 24, 190, 0, 0, 101, 4, 0, 0, 56, 190, 0, 0, 104, 4, 0, 0, 112, 190, 0, 0, 106, 4, 0, 0, 144, 190, 0, 0, 107, 4, 0, 0, 200, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 105, 110, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 40, 37, 115, 41, 32, 100, 111, 101, 115, 32, 110, 111, 116, 32, 109, 97, 116, 99, 104, 32, 97, 99, 116, 117, 97, 108, 32, 105, 110, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 40, 37, 115, 41, 0, 37, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 99, 111, 100, 101, 32, 37, 115, 0, 0, 0, 0, 37, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 85, 84, 70, 45, 56, 32, 98, 121, 116, 101, 115, 32, 40, 99, 104, 97, 114, 46, 32, 99, 111, 100, 101, 32, 37, 115, 41, 0, 0, 37, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 85, 84, 70, 45, 49, 54, 32, 115, 117, 114, 114, 111, 103, 97, 116, 101, 32, 112, 97, 105, 114, 32, 40, 99, 104, 97, 114, 46, 32, 99, 111, 100, 101, 32, 37, 115, 41, 0, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 110, 117, 109, 101, 114, 105, 99, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 101, 110, 116, 105, 116, 121, 32, 34, 37, 115, 34, 32, 100, 111, 101, 115, 110, 39, 116, 32, 101, 110, 100, 32, 105, 110, 32, 39, 59, 39, 0, 0, 110, 117, 109, 101, 114, 105, 99, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 34, 37, 115, 34, 32, 100, 111, 101, 115, 110, 39, 116, 32, 101, 110, 100, 32, 105, 110, 32, 39, 59, 39, 0, 0, 0, 0, 0, 117, 110, 101, 115, 99, 97, 112, 101, 100, 32, 38, 32, 119, 104, 105, 99, 104, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 119, 114, 105, 116, 116, 101, 110, 32, 97, 115, 32, 38, 97, 109, 112, 59, 0, 0, 0, 0, 117, 110, 101, 115, 99, 97, 112, 101, 100, 32, 38, 32, 111, 114, 32, 117, 110, 107, 110, 111, 119, 110, 32, 101, 110, 116, 105, 116, 121, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 0, 110, 97, 109, 101, 100, 32, 101, 110, 116, 105, 116, 121, 32, 38, 97, 112, 111, 115, 59, 32, 111, 110, 108, 121, 32, 100, 101, 102, 105, 110, 101, 100, 32, 105, 110, 32, 88, 77, 76, 47, 88, 72, 84, 77, 76, 0, 0, 0, 37, 115, 32, 105, 110, 115, 101, 114, 116, 105, 110, 103, 32, 34, 37, 115, 34, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 0, 0, 0, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 32, 108, 97, 99, 107, 115, 32, 118, 97, 108, 117, 101, 0, 0, 0, 37, 115, 32, 117, 110, 107, 110, 111, 119, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 0, 0, 0, 37, 115, 32, 106, 111, 105, 110, 105, 110, 103, 32, 118, 97, 108, 117, 101, 115, 32, 111, 102, 32, 114, 101, 112, 101, 97, 116, 101, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 37, 115, 32, 104, 97, 115, 32, 88, 77, 76, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 73, 68, 32, 34, 37, 115, 34, 32, 117, 115, 101, 115, 32, 88, 77, 76, 32, 73, 68, 32, 115, 121, 110, 116, 97, 120, 0, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 32, 34, 37, 115, 34, 32, 109, 117, 115, 116, 32, 98, 101, 32, 108, 111, 119, 101, 114, 32, 99, 97, 115, 101, 32, 102, 111, 114, 32, 88, 72, 84, 77, 76, 0, 0, 0, 0, 37, 115, 32, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 37, 115, 32, 97, 110, 99, 104, 111, 114, 32, 34, 37, 115, 34, 32, 97, 108, 114, 101, 97, 100, 121, 32, 100, 101, 102, 105, 110, 101, 100, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 32, 104, 97, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 118, 97, 108, 117, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 32, 104, 97, 100, 32, 105, 110, 118, 97, 108, 105, 100, 32, 118, 97, 108, 117, 101, 32, 34, 37, 115, 34, 32, 97, 110, 100, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 114, 101, 112, 108, 97, 99, 101, 100, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 110, 97, 109, 101, 32, 34, 37, 115, 34, 32, 40, 118, 97, 108, 117, 101, 61, 34, 37, 115, 34, 41, 32, 105, 115, 32, 105, 110, 118, 97, 108, 105, 100, 0, 0, 37, 115, 32, 100, 114, 111, 112, 112, 105, 110, 103, 32, 118, 97, 108, 117, 101, 32, 34, 37, 115, 34, 32, 102, 111, 114, 32, 114, 101, 112, 101, 97, 116, 101, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 34, 37, 115, 34, 0, 0, 0, 0, 0, 0, 37, 115, 32, 99, 97, 110, 110, 111, 116, 32, 99, 111, 112, 121, 32, 110, 97, 109, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 116, 111, 32, 105, 100, 0, 0, 0, 0, 0, 37, 115, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 62, 39, 32, 102, 111, 114, 32, 101, 110, 100, 32, 111, 102, 32, 116, 97, 103, 0, 0, 0, 37, 115, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 111, 114, 32, 100, 117, 112, 108, 105, 99, 97, 116, 101, 32, 113, 117, 111, 116, 101, 32, 109, 97, 114, 107, 0, 0, 0, 37, 115, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 119, 105, 116, 104, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 114, 97, 105, 108, 105, 110, 103, 32, 113, 117, 111, 116, 101, 32, 109, 97, 114, 107, 0, 0, 0, 37, 115, 32, 101, 110, 100, 32, 111, 102, 32, 102, 105, 108, 101, 32, 119, 104, 105, 108, 101, 32, 112, 97, 114, 115, 105, 110, 103, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 37, 115, 32, 105, 100, 32, 97, 110, 100, 32, 110, 97, 109, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 32, 109, 105, 115, 109, 97, 116, 99, 104, 0, 37, 115, 32, 85, 82, 73, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 32, 99, 111, 110, 116, 97, 105, 110, 115, 32, 98, 97, 99, 107, 115, 108, 97, 115, 104, 46, 32, 84, 121, 112, 111, 63, 0, 0, 0, 0, 0, 0, 37, 115, 32, 99, 111, 110, 118, 101, 114, 116, 105, 110, 103, 32, 98, 97, 99, 107, 115, 108, 97, 115, 104, 32, 105, 110, 32, 85, 82, 73, 32, 116, 111, 32, 115, 108, 97, 115, 104, 0, 37, 115, 32, 105, 109, 112, 114, 111, 112, 101, 114, 108, 121, 32, 101, 115, 99, 97, 112, 101, 100, 32, 85, 82, 73, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 0, 0, 0, 0, 0, 37, 115, 32, 101, 115, 99, 97, 112, 105, 110, 103, 32, 109, 97, 108, 102, 111, 114, 109, 101, 100, 32, 85, 82, 73, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 0, 0, 0, 0, 0, 37, 115, 32, 100, 105, 115, 99, 97, 114, 100, 105, 110, 103, 32, 110, 101, 119, 108, 105, 110, 101, 32, 105, 110, 32, 85, 82, 73, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 0, 0, 37, 115, 32, 100, 105, 115, 99, 97, 114, 100, 105, 110, 103, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 105, 110, 32, 85, 82, 73, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 39, 61, 39, 44, 32, 101, 120, 112, 101, 99], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 30736);
allocate([116, 101, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 110, 97, 109, 101, 0, 0, 0, 0, 0, 0, 37, 115, 32, 115, 104, 111, 117, 108, 100, 32, 117, 115, 101, 32, 99, 108, 105, 101, 110, 116, 45, 115, 105, 100, 101, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 0, 0, 0, 0, 0, 37, 115, 32, 108, 97, 99, 107, 115, 32, 34, 37, 115, 34, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 0, 110, 101, 115, 116, 101, 100, 32, 101, 109, 112, 104, 97, 115, 105, 115, 32, 37, 115, 0, 0, 0, 0, 0, 0, 110, 101, 115, 116, 101, 100, 32, 113, 32, 101, 108, 101, 109, 101, 110, 116, 115, 44, 32, 112, 111, 115, 115, 105, 98, 108, 101, 32, 116, 121, 112, 111, 46, 0, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 111, 98, 115, 111, 108, 101, 116, 101, 32, 101, 108, 101, 109, 101, 110, 116, 32, 37, 115, 32, 98, 121, 32, 37, 115, 0, 0, 0, 0, 0, 60, 37, 115, 62, 32, 105, 115, 32, 112, 114, 111, 98, 97, 98, 108, 121, 32, 105, 110, 116, 101, 110, 100, 101, 100, 32, 97, 115, 32, 60, 47, 37, 115, 62, 0, 0, 0, 0, 0, 0, 116, 114, 105, 109, 109, 105, 110, 103, 32, 101, 109, 112, 116, 121, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 37, 115, 32, 98, 121, 32, 37, 115, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 37, 115, 32, 98, 121, 32, 37, 115, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 60, 47, 37, 115, 62, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 60, 47, 37, 115, 62, 32, 98, 101, 102, 111, 114, 101, 32, 37, 115, 0, 100, 105, 115, 99, 97, 114, 100, 105, 110, 103, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 37, 115, 32, 98, 121, 32, 60, 47, 37, 115, 62, 0, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 105, 115, 110, 39, 116, 32, 97, 108, 108, 111, 119, 101, 100, 32, 105, 110, 32, 60, 37, 115, 62, 32, 101, 108, 101, 109, 101, 110, 116, 115, 0, 0, 0, 0, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 60, 37, 115, 62, 0, 0, 0, 0, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 60, 47, 37, 115, 62, 0, 0, 0, 0, 0, 0, 0, 0, 116, 111, 111, 32, 109, 97, 110, 121, 32, 37, 115, 32, 101, 108, 101, 109, 101, 110, 116, 115, 0, 0, 0, 0, 117, 115, 105, 110, 103, 32, 60, 98, 114, 62, 32, 105, 110, 32, 112, 108, 97, 99, 101, 32, 111, 102, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 105, 110, 115, 101, 114, 116, 105, 110, 103, 32, 105, 109, 112, 108, 105, 99, 105, 116, 32, 60, 37, 115, 62, 0, 37, 115, 32, 99, 97, 110, 39, 116, 32, 98, 101, 32, 110, 101, 115, 116, 101, 100, 0, 0, 0, 0, 0, 0, 37, 115, 32, 105, 115, 32, 110, 111, 116, 32, 97, 112, 112, 114, 111, 118, 101, 100, 32, 98, 121, 32, 87, 51, 67, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 115, 104, 111, 117, 108, 100, 110, 39, 116, 32, 98, 101, 32, 110, 101, 115, 116, 101, 100, 0, 0, 37, 115, 32, 110, 111, 116, 32, 105, 110, 115, 105, 100, 101, 32, 39, 110, 111, 102, 114, 97, 109, 101, 115, 39, 32, 101, 108, 101, 109, 101, 110, 116, 0, 0, 0, 0, 0, 0, 0, 0, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 101, 110, 100, 32, 111, 102, 32, 102, 105, 108, 101, 32, 37, 115, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 101, 108, 101, 109, 101, 110, 116, 32, 110, 111, 116, 32, 101, 109, 112, 116, 121, 32, 111, 114, 32, 110, 111, 116, 32, 99, 108, 111, 115, 101, 100, 0, 0, 0, 0, 0, 0, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 60, 47, 37, 115, 62, 32, 105, 110, 32, 60, 37, 115, 62, 0, 0, 0, 0, 0, 0, 0, 0, 116, 111, 111, 32, 109, 97, 110, 121, 32, 37, 115, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 105, 110, 32, 60, 37, 115, 62, 0, 0, 0, 0, 117, 110, 101, 115, 99, 97, 112, 101, 100, 32, 37, 115, 32, 105, 110, 32, 112, 114, 101, 32, 99, 111, 110, 116, 101, 110, 116, 0, 0, 0, 0, 0, 60, 33, 68, 79, 67, 84, 89, 80, 69, 62, 32, 105, 115, 110, 39, 116, 32, 97, 108, 108, 111, 119, 101, 100, 32, 97, 102, 116, 101, 114, 32, 101, 108, 101, 109, 101, 110, 116, 115, 0, 105, 110, 115, 101, 114, 116, 105, 110, 103, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 116, 105, 116, 108, 101, 39, 32, 101, 108, 101, 109, 101, 110, 116, 0, 0, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 68, 79, 67, 84, 89, 80, 69, 32, 100, 111, 101, 115, 110, 39, 116, 32, 109, 97, 116, 99, 104, 32, 99, 111, 110, 116, 101, 110, 116, 0, 0, 0, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 60, 33, 68, 79, 67, 84, 89, 80, 69, 62, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 0, 0, 99, 111, 110, 116, 101, 110, 116, 32, 111, 99, 99, 117, 114, 115, 32, 97, 102, 116, 101, 114, 32, 101, 110, 100, 32, 111, 102, 32, 98, 111, 100, 121, 0, 0, 0, 0, 0, 0, 0, 0, 97, 100, 106, 97, 99, 101, 110, 116, 32, 104, 121, 112, 104, 101, 110, 115, 32, 119, 105, 116, 104, 105, 110, 32, 99, 111, 109, 109, 101, 110, 116, 0, 101, 120, 112, 101, 99, 116, 105, 110, 103, 32, 45, 45, 32, 111, 114, 32, 62, 0, 0, 0, 0, 0, 0, 0, 39, 60, 39, 32, 43, 32, 39, 47, 39, 32, 43, 32, 108, 101, 116, 116, 101, 114, 32, 110, 111, 116, 32, 97, 108, 108, 111, 119, 101, 100, 32, 104, 101, 114, 101, 0, 0, 0, 0, 0, 72, 84, 77, 76, 32, 110, 97, 109, 101, 115, 112, 97, 99, 101, 32, 100, 111, 101, 115, 110, 39, 116, 32, 109, 97, 116, 99, 104, 32, 99, 111, 110, 116, 101, 110, 116, 0, 0, 0, 0, 114, 101, 109, 111, 118, 105, 110, 103, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 112, 114, 101, 99, 101, 100, 105, 110, 103, 32, 88, 77, 76, 32, 68, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 0, 0, 0, 100, 105, 115, 99, 97, 114, 100, 105, 110, 103, 32, 109, 97, 108, 102, 111, 114, 109, 101, 100, 32, 60, 33, 68, 79, 67, 84, 89, 80, 69, 62, 0, 88, 77, 76, 32, 99, 111, 109, 109, 101, 110, 116, 115, 32, 99, 97, 110, 39, 116, 32, 99, 111, 110, 116, 97, 105, 110, 32, 45, 45, 0, 0, 0, 83, 89, 83, 84, 69, 77, 44, 32, 80, 85, 66, 76, 73, 67, 44, 32, 87, 51, 67, 44, 32, 68, 84, 68, 44, 32, 69, 78, 32, 109, 117, 115, 116, 32, 98, 101, 32, 117, 112, 112, 101, 114, 32, 99, 97, 115, 101, 0, 79, 117, 116, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 100, 111, 101, 115, 32, 110, 111, 116, 32, 119, 111, 114, 107, 32, 119, 105, 116, 104, 32, 115, 116, 97, 110, 100, 97, 114, 100, 32, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 0, 0, 109, 105, 115, 115, 105, 110, 103, 32, 113, 117, 111, 116, 101, 32, 109, 97, 114, 107, 32, 102, 111, 114, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 0, 0, 114, 101, 112, 101, 97, 116, 101, 100, 32, 70, 82, 65, 77, 69, 83, 69, 84, 32, 101, 108, 101, 109, 101, 110, 116, 0, 0, 0, 0, 0, 0, 0, 37, 115, 32, 105, 115, 32, 110, 111, 116, 32, 114, 101, 99, 111, 103, 110, 105, 122, 101, 100, 33, 0, 0, 0, 60, 37, 115, 62, 32, 112, 114, 101, 118, 105, 111, 117, 115, 108, 121, 32, 109, 101, 110, 116, 105, 111, 110, 101, 100, 0, 0, 0, 0, 0, 0, 0, 91, 49, 46, 49, 46, 49, 46, 49, 93, 58, 32, 60, 105, 109, 103, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 46, 0, 0, 0, 0, 91, 49, 46, 49, 46, 49, 46, 50, 93, 58, 32, 115, 117, 115, 112, 105, 99, 105, 111, 117, 115, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 32, 40, 102, 105, 108, 101, 110, 97, 109, 101, 41, 46, 0, 0, 0, 0, 91, 49, 46, 49, 46, 49, 46, 51, 93, 58, 32, 115, 117, 115, 112, 105, 99, 105, 111, 117, 115, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 32, 40, 102, 105, 108, 101, 32, 115, 105, 122, 101, 41, 46, 0, 0, 0, 91, 49, 46, 49, 46, 49, 46, 52, 93, 58, 32, 115, 117, 115, 112, 105, 99, 105, 111, 117, 115, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 32, 40, 112, 108, 97, 99, 101, 104, 111, 108, 100, 101, 114, 41, 46, 0, 91, 49, 46, 49, 46, 49, 46, 49, 48, 93, 58, 32, 115, 117, 115, 112, 105, 99, 105, 111, 117, 115, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 32, 40, 116, 111, 111, 32, 108, 111, 110, 103, 41, 46, 0, 0, 0, 91, 49, 46, 49, 46, 50, 46, 49, 93, 58, 32, 60, 105, 109, 103, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 108, 111, 110, 103, 100, 101, 115, 99, 39, 32, 97, 110, 100, 32, 100, 45, 108, 105, 110, 107, 46, 0, 91, 49, 46, 49, 46, 50, 46, 50, 93, 58, 32, 60, 105, 109, 103, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 100, 45, 108, 105, 110, 107, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 49, 46, 49, 46, 50, 46, 51, 93, 58, 32, 60, 105, 109, 103, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 108, 111, 110, 103, 100, 101, 115, 99, 39, 46, 0, 0, 0, 0, 91, 49, 46, 49, 46, 51, 46, 49, 93, 58, 32, 60, 105, 109, 103, 62, 32, 40, 98, 117, 116, 116, 111, 110, 41, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 46, 0, 0, 0, 91, 49, 46, 49, 46, 52, 46, 49, 93, 58, 32, 60, 97, 112, 112, 108, 101, 116, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 97, 108, 116, 101, 114, 110, 97, 116, 101, 32, 99, 111, 110, 116, 101, 110, 116, 46, 0, 0, 91, 49, 46, 49, 46, 53, 46, 49, 93, 58, 32, 60, 111, 98, 106, 101, 99, 116, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 97, 108, 116, 101, 114, 110, 97, 116, 101, 32, 99, 111, 110, 116, 101, 110, 116, 46, 0, 0, 91, 49, 46, 49, 46, 54, 46, 49, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 119, 97, 118, 41, 46, 0, 91, 49, 46, 49, 46, 54, 46, 50, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 97, 117, 41, 46, 0, 0, 91, 49, 46, 49, 46, 54, 46, 51, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 97, 105, 102, 102, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 49, 46, 49, 46, 54, 46, 52, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 115, 110, 100, 41, 46, 0, 91, 49, 46, 49, 46, 54, 46, 53, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 114, 97, 41, 46, 0, 0, 91, 49, 46, 49, 46, 54, 46, 54, 93, 58, 32, 97, 117, 100, 105, 111, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 116, 114, 97, 110, 115, 99, 114, 105, 112, 116, 32, 40, 114, 109, 41, 46, 0, 0, 91, 49, 46, 49, 46, 56, 46, 49, 93, 58, 32, 60, 102, 114, 97, 109, 101, 62, 32, 109, 97, 121, 32, 114, 101, 113, 117, 105, 114, 101, 32, 39, 108, 111, 110, 103, 100, 101, 115, 99, 39, 46, 0, 0, 0, 0, 0, 0, 91, 49, 46, 49, 46, 57, 46, 49, 93, 58, 32, 60, 97, 114, 101, 97, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 39, 97, 108, 116, 39, 32, 116, 101, 120, 116, 46, 0, 0, 0, 91, 49, 46, 49, 46, 49, 48, 46, 49, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 60, 110, 111, 115, 99, 114, 105, 112, 116, 62, 32, 115, 101, 99, 116, 105, 111, 110, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 49, 46, 49, 46, 49, 50, 46, 49, 93, 58, 32, 97, 115, 99, 105, 105, 32, 97, 114, 116, 32, 114, 101, 113, 117, 105, 114, 101, 115, 32, 100, 101, 115, 99, 114, 105, 112, 116, 105, 111, 110, 46, 0, 0, 0, 0, 0, 91, 49, 46, 50, 46, 49, 46, 49, 93, 58, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 32, 40, 115, 101, 114, 118, 101, 114, 45, 115, 105, 100, 101, 41, 32, 114, 101, 113, 117, 105, 114, 101, 115, 32, 116, 101, 120, 116, 32, 108, 105, 110, 107, 115, 46, 0, 91, 49, 46, 52, 46, 49, 46, 49, 93, 58, 32, 109, 117, 108, 116, 105, 109, 101, 100, 105, 97, 32, 114, 101, 113, 117, 105, 114, 101, 115, 32, 115, 121, 110, 99, 104, 114, 111, 110, 105, 122, 101, 100, 32, 116, 101, 120, 116, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 115, 46, 0, 0, 0, 91, 49, 46, 53, 46, 49, 46, 49, 93, 58, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 32, 40, 99, 108, 105, 101, 110, 116, 45, 115, 105, 100, 101, 41, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 101, 120, 116, 32, 108, 105, 110, 107, 115, 46, 0, 0, 91, 50, 46, 49, 46, 49, 46, 49, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 110, 111, 116, 32, 99, 111, 110, 118, 101, 121, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 99, 111, 108, 111, 114, 32, 97, 108, 111, 110, 101, 32, 40, 105, 109, 97, 103, 101, 41, 46, 0, 91, 50, 46, 49, 46, 49, 46, 50, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 110, 111, 116, 32, 99, 111, 110, 118, 101, 121, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 99, 111, 108, 111, 114, 32, 97, 108, 111, 110, 101, 32, 40, 97, 112, 112, 108, 101, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 50, 46, 49, 46, 49, 46, 51, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 110, 111, 116, 32, 99, 111, 110, 118, 101, 121, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 99, 111, 108, 111, 114, 32, 97, 108, 111, 110, 101, 32, 40, 111, 98, 106, 101, 99, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 50, 46, 49, 46, 49, 46, 52, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 110, 111, 116, 32, 99, 111, 110, 118, 101, 121, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 99, 111, 108, 111, 114, 32, 97, 108, 111, 110, 101, 32, 40, 115, 99, 114, 105, 112, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 50, 46, 49, 46, 49, 46, 53, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 110, 111, 116, 32, 99, 111, 110, 118, 101, 121, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 99, 111, 108, 111, 114, 32, 97, 108, 111, 110, 101, 32, 40, 105, 110, 112, 117, 116, 41, 46, 0, 91, 50, 46, 50, 46, 49, 46, 49, 93, 58, 32, 112, 111, 111, 114, 32, 99, 111, 108, 111, 114, 32, 99, 111, 110, 116, 114, 97, 115, 116, 32, 40, 116, 101, 120, 116, 41, 46, 0, 0, 91, 50, 46, 50, 46, 49, 46, 50, 93, 58, 32, 112, 111, 111, 114, 32, 99, 111, 108, 111, 114, 32, 99, 111, 110, 116, 114, 97, 115, 116, 32, 40, 108, 105, 110, 107, 41, 46, 0, 0, 91, 50, 46, 50, 46, 49, 46, 51, 93, 58, 32, 112, 111, 111, 114, 32, 99, 111, 108, 111, 114, 32, 99, 111, 110, 116, 114, 97, 115, 116, 32, 40, 97, 99, 116, 105, 118, 101, 32, 108, 105, 110, 107, 41, 46, 0, 0, 0, 91, 50, 46, 50, 46, 49, 46, 52, 93, 58, 32, 112, 111, 111, 114, 32, 99, 111, 108, 111, 114, 32, 99, 111, 110, 116, 114, 97, 115, 116, 32, 40, 118, 105, 115, 105, 116, 101, 100, 32, 108, 105, 110, 107, 41, 46, 0, 0, 91, 51, 46, 50, 46, 49, 46, 49, 93, 58, 32, 60, 100, 111, 99, 116, 121, 112, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 46, 0, 0, 0, 91, 51, 46, 51, 46, 49, 46, 49, 93, 58, 32, 117, 115, 101, 32, 115, 116, 121, 108, 101, 32, 115, 104, 101, 101, 116, 115, 32, 116, 111, 32, 99, 111, 110, 116, 114, 111, 108, 32, 112, 114, 101, 115, 101, 110, 116, 97, 116, 105, 111, 110, 46, 0, 0, 0, 0, 91, 51, 46, 53, 46, 49, 46, 49, 93, 58, 32, 104, 101, 97, 100, 101, 114, 115, 32, 105, 109, 112, 114, 111, 112, 101, 114, 108, 121, 32, 110, 101, 115, 116, 101, 100, 46, 0, 0, 0, 91, 51, 46, 53, 46, 50, 46, 49, 93, 58, 32, 112, 111, 116, 101, 110, 116, 105, 97, 108, 32, 104, 101, 97, 100, 101, 114, 32, 40, 98, 111, 108, 100, 41, 46, 0, 0, 0, 0, 0, 91, 51, 46, 53, 46, 50, 46, 50, 93, 58, 32, 112, 111, 116, 101, 110, 116, 105, 97, 108, 32, 104, 101, 97, 100, 101, 114, 32, 40, 105, 116, 97, 108, 105, 99, 115, 41, 46, 0, 0, 91, 51, 46, 53, 46, 50, 46, 51, 93, 58, 32, 112, 111, 116, 101, 110, 116, 105, 97, 108, 32, 104, 101, 97, 100, 101, 114, 32, 40, 117, 110, 100, 101, 114, 108, 105, 110, 101, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 51, 46, 53, 46, 51, 46, 49, 93, 58, 32, 104, 101, 97, 100, 101, 114, 32, 117, 115, 101, 100, 32, 116, 111, 32, 102, 111, 114, 109, 97, 116, 32, 116, 101, 120, 116, 46, 0, 0, 91, 51, 46, 54, 46, 49, 46, 49, 93, 58, 32, 108, 105, 115, 116, 32, 117, 115, 97, 103, 101, 32, 105, 110, 118, 97, 108, 105, 100, 32, 60, 117, 108, 62, 46, 0, 0, 0, 0, 0, 91, 51, 46, 54, 46, 49, 46, 50, 93, 58, 32, 108, 105, 115, 116, 32, 117, 115, 97, 103, 101, 32, 105, 110, 118, 97, 108, 105, 100, 32, 60, 111, 108, 62, 46, 0, 0, 0, 0, 0, 91, 51, 46, 54, 46, 49, 46, 52, 93, 58, 32, 108, 105, 115, 116, 32, 117, 115, 97, 103, 101, 32, 105, 110, 118, 97, 108, 105, 100, 32, 60, 108, 105, 62, 46, 0, 0, 0, 0, 0, 91, 52, 46, 49, 46, 49, 46, 49, 93, 58, 32, 105, 110, 100, 105, 99, 97, 116, 101, 32, 99, 104, 97, 110, 103, 101, 115, 32, 105, 110, 32, 108, 97, 110, 103, 117, 97, 103, 101, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 52, 46, 51, 46, 49, 46, 49, 93, 58, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 110, 111, 116, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 100, 46, 0, 0, 0, 0, 0, 91, 52, 46, 51, 46, 49, 46, 50, 93, 58, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 105, 110, 118, 97, 108, 105, 100, 46, 0, 0, 91, 53, 46, 49, 46, 50, 46, 49, 93, 58, 32, 100, 97, 116, 97, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 114, 111, 119, 47, 99, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 115, 32, 40, 97, 108, 108, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 53, 46, 49, 46, 50, 46, 50, 93, 58, 32, 100, 97, 116, 97, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 114, 111, 119, 47, 99, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 115, 32, 40, 49, 32, 99, 111, 108, 41, 46, 0, 0, 0, 0, 0, 91, 53, 46, 49, 46, 50, 46, 51, 93, 58, 32, 100, 97, 116, 97, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 114, 111, 119, 47, 99, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 115, 32, 40, 49, 32, 114, 111, 119, 41, 46, 0, 0, 0, 0, 0, 91, 53, 46, 50, 46, 49, 46, 49, 93, 58, 32, 100, 97, 116, 97, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 97, 121, 32, 114, 101, 113, 117, 105, 114, 101, 32, 109, 97, 114, 107, 117, 112, 32, 40, 99, 111, 108, 117, 109, 110, 32, 104, 101, 97, 100, 101, 114, 115, 41, 46, 0, 0, 0, 0, 91, 53, 46, 50, 46, 49, 46, 50, 93, 58, 32, 100, 97, 116, 97, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 97, 121, 32, 114, 101, 113, 117, 105, 114, 101, 32, 109, 97, 114, 107, 117, 112, 32, 40, 114, 111, 119, 32, 104, 101, 97, 100, 101, 114, 115, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 53, 46, 51, 46, 49, 46, 49, 93, 58, 32, 118, 101, 114, 105, 102, 121, 32, 108, 97, 121, 111, 117, 116, 32, 116, 97, 98, 108, 101, 115, 32, 108, 105, 110, 101, 97, 114, 105, 122, 101, 32, 112, 114, 111, 112, 101, 114, 108, 121, 46, 0, 0, 0, 0, 0, 91, 53, 46, 52, 46, 49, 46, 49, 93, 58, 32, 105, 110, 118, 97, 108, 105, 100, 32, 109, 97, 114, 107, 117, 112, 32, 117, 115, 101, 100, 32, 105, 110, 32, 108, 97, 121, 111, 117, 116, 32, 60, 116, 97, 98, 108, 101, 62, 46, 0, 0, 0, 0, 0, 0, 0, 91, 53, 46, 53, 46, 49, 46, 49, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 115, 117, 109, 109, 97, 114, 121, 46, 0, 0, 0, 0, 0, 91, 53, 46, 53, 46, 49, 46, 50, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 115, 117, 109, 109, 97, 114, 121, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 110, 117, 108, 108, 41, 46, 0, 0, 0, 0, 0, 0, 91, 53, 46, 53, 46, 49, 46, 51, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 115, 117, 109, 109, 97, 114, 121, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 115, 112, 97, 99, 101, 115, 41, 46, 0, 0, 0, 0, 91, 53, 46, 53, 46, 49, 46, 54, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 115, 117, 109, 109, 97, 114, 121, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 112, 108, 97, 99, 101, 104, 111, 108, 100, 101, 114, 32, 116, 101, 120, 116, 41, 46, 0, 0, 91, 53, 46, 53, 46, 50, 46, 49, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 60, 99, 97, 112, 116, 105, 111, 110, 62, 46, 0, 0, 0, 91, 53, 46, 54, 46, 49, 46, 49, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 109, 97, 121, 32, 114, 101, 113, 117, 105, 114, 101, 32, 104, 101, 97, 100, 101, 114, 32, 97, 98, 98, 114, 101, 118, 105, 97, 116, 105, 111, 110, 115, 46, 0, 0, 0, 0, 91, 53, 46, 54, 46, 49, 46, 50, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 104, 101, 97, 100, 101, 114, 32, 97, 98, 98, 114, 101, 118, 105, 97, 116, 105, 111, 110, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 110, 117, 108, 108, 41, 46, 0, 91, 53, 46, 54, 46, 49, 46, 51, 93, 58, 32, 60, 116, 97, 98, 108, 101, 62, 32, 104, 101, 97, 100, 101, 114, 32, 97, 98, 98, 114, 101, 118, 105, 97, 116, 105, 111, 110, 115, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 115, 112, 97, 99, 101, 115, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 49, 46, 49, 46, 49, 93, 58, 32, 115, 116, 121, 108, 101, 32, 115, 104, 101, 101, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 108, 105, 110, 107, 41, 46, 0, 91, 54, 46, 49, 46, 49, 46, 50, 93, 58, 32, 115, 116, 121, 108, 101, 32, 115, 104, 101, 101, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 115, 116, 121, 108, 101, 32, 101, 108, 101, 109, 101, 110, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 49, 46, 49, 46, 51, 93, 58, 32, 115, 116, 121, 108, 101, 32, 115, 104, 101, 101, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 115, 116, 121, 108, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 41, 46, 0, 0, 0, 0, 0, 0, 91, 54, 46, 50, 46, 49, 46, 49, 93, 58, 32, 60, 102, 114, 97, 109, 101, 62, 32, 115, 111, 117, 114, 99, 101, 32, 105, 110, 118, 97, 108, 105, 100, 46, 0, 0, 0, 0, 0, 0, 91, 54, 46, 50, 46, 50, 46, 49, 93, 58, 32, 116, 101, 120, 116, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 117, 112, 100, 97, 116, 105, 110, 103, 32, 40, 97, 112, 112, 108, 101, 116, 41, 46, 0, 0, 91, 54, 46, 50, 46, 50, 46, 50, 93, 58, 32, 116, 101, 120, 116, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 117, 112, 100, 97, 116, 105, 110, 103, 32, 40, 115, 99, 114, 105, 112, 116, 41, 46, 0, 0, 91, 54, 46, 50, 46, 50, 46, 51, 93, 58, 32, 116, 101, 120, 116, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 117, 112, 100, 97, 116, 105, 110, 103, 32, 40, 111, 98, 106, 101, 99, 116, 41, 46, 0, 0, 91, 54, 46, 51, 46, 49, 46, 49, 93, 58, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 115, 99, 114, 105, 112, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 51, 46, 49, 46, 50, 93, 58, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 111, 98, 106, 101, 99, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 51, 46, 49, 46, 51, 93, 58, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 101, 109, 98, 101, 100, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 51, 46, 49, 46, 52, 93, 58, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 116, 101, 115, 116, 105, 110, 103, 32, 40, 97, 112, 112, 108, 101, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 53, 46, 49, 46, 49, 93, 58, 32, 60, 102, 114, 97, 109, 101, 115, 101, 116, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 60, 110, 111, 102, 114, 97, 109, 101, 115, 62, 32, 115, 101, 99, 116, 105, 111, 110, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 53, 46, 49, 46, 50, 93, 58, 32, 60, 110, 111, 102, 114, 97, 109, 101, 115, 62, 32, 115, 101, 99, 116, 105, 111, 110, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 110, 111, 32, 118, 97, 108, 117, 101, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 53, 46, 49, 46, 51, 93, 58, 32, 60, 110, 111, 102, 114, 97, 109, 101, 115, 62, 32, 115, 101, 99, 116, 105, 111, 110, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 99, 111, 110, 116, 101, 110, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 54, 46, 53, 46, 49, 46, 52, 93, 58, 32, 60, 110, 111, 102, 114, 97, 109, 101, 115, 62, 32, 115, 101, 99, 116, 105, 111, 110, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 108, 105, 110, 107, 41, 46, 0, 0, 0, 91, 55, 46, 49, 46, 49, 46, 49, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 102, 108, 105, 99, 107, 101, 114, 32, 40, 115, 99, 114, 105, 112, 116, 41, 46, 0, 0, 0, 0, 0, 91, 55, 46, 49, 46, 49, 46, 50, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 102, 108, 105, 99, 107, 101, 114, 32, 40, 111, 98, 106, 101, 99, 116, 41, 46, 0, 0, 0, 0, 0, 91, 55, 46, 49, 46, 49, 46, 51, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 102, 108, 105, 99, 107, 101, 114, 32, 40, 101, 109, 98, 101, 100, 41, 46, 0, 0, 0, 0, 0, 0, 91, 55, 46, 49, 46, 49, 46, 52, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 102, 108, 105, 99, 107, 101, 114, 32, 40, 97, 112, 112, 108, 101, 116, 41, 46, 0, 0, 0, 0, 0, 91, 55, 46, 49, 46, 49, 46, 53, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 102, 108, 105, 99, 107, 101, 114, 32, 40, 97, 110, 105, 109, 97, 116, 101, 100, 32, 103, 105, 102, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 55, 46, 50, 46, 49, 46, 49, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 98, 108, 105, 110, 107, 47, 109, 97, 114, 113, 117, 101, 101, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 55, 46, 52, 46, 49, 46, 49, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 97, 117, 116, 111, 45, 114, 101, 102, 114, 101, 115, 104, 46, 0, 91, 55, 46, 53, 46, 49, 46, 49, 93, 58, 32, 114, 101, 109, 111, 118, 101, 32, 97, 117, 116, 111, 45, 114, 101, 100, 105, 114, 101, 99, 116, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 56, 46, 49, 46, 49, 46, 49, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 97, 114, 101, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 115, 99, 114, 105, 112, 116, 41, 46, 0, 91, 56, 46, 49, 46, 49, 46, 50, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 97, 114, 101, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 98, 106, 101, 99, 116, 41, 46, 0, 91, 56, 46, 49, 46, 49, 46, 51, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 97, 114, 101, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 97, 112, 112, 108, 101, 116, 41, 46, 0, 91, 56, 46, 49, 46, 49, 46, 52, 93, 58, 32, 101, 110, 115, 117, 114, 101, 32, 112, 114, 111, 103, 114, 97, 109, 109, 97, 116, 105, 99, 32, 111, 98, 106, 101, 99, 116, 115, 32, 97, 114, 101, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 101, 109, 98, 101, 100, 41, 46, 0, 0, 91, 57, 46, 49, 46, 49, 46, 49, 93, 58, 32, 105, 109, 97, 103, 101, 32, 109, 97, 112, 32, 40, 115, 101, 114, 118, 101, 114, 45, 115, 105, 100, 101, 41, 32, 114, 101, 113, 117, 105, 114, 101, 115, 32, 99, 111, 110, 118, 101, 114, 115, 105, 111, 110, 46, 0, 91, 57, 46, 51, 46, 49, 46, 49, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 77, 111, 117, 115, 101, 68, 111, 119, 110, 41, 46, 0, 0, 0, 0, 0, 0, 91, 57, 46, 51, 46, 49, 46, 50, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 77, 111, 117, 115, 101, 85, 112, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 57, 46, 51, 46, 49, 46, 51, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 67, 108, 105, 99, 107, 41, 46, 0, 0, 91, 57, 46, 51, 46, 49, 46, 52, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 77, 111, 117, 115, 101, 79, 118, 101, 114, 41, 46, 0, 0, 0, 0, 0, 0, 91, 57, 46, 51, 46, 49, 46, 53, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 77, 111, 117, 115, 101, 79, 117, 116, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 57, 46, 51, 46, 49, 46, 54, 93, 58, 32, 60, 115, 99, 114, 105, 112, 116, 62, 32, 110, 111, 116, 32, 107, 101, 121, 98, 111, 97, 114, 100, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 40, 111, 110, 77, 111, 117, 115, 101, 77, 111, 118, 101, 41, 46, 0, 0, 0, 0, 0, 0, 91, 49, 48, 46, 49, 46, 49, 46, 49, 93, 58, 32, 110, 101, 119, 32, 119, 105, 110, 100, 111, 119, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 119, 97, 114, 110, 105, 110, 103, 32, 40, 95, 110, 101, 119, 41, 46, 0, 91, 49, 48, 46, 49, 46, 49, 46, 50, 93, 58, 32, 110, 101, 119, 32, 119, 105, 110, 100, 111, 119, 115, 32, 114, 101, 113, 117, 105, 114, 101, 32, 119, 97, 114, 110, 105, 110, 103, 32, 40, 95, 98, 108, 97, 110, 107, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 49, 48, 46, 52, 46, 49, 46, 49, 93, 58, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 32, 114, 101, 113, 117, 105, 114, 101, 115, 32, 100, 101, 102, 97, 117, 108, 116, 32, 116, 101, 120, 116, 46, 0, 91, 49, 48, 46, 52, 46, 49, 46, 50, 93, 58, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 32, 100, 101, 102, 97, 117, 108, 116, 32, 116, 101, 120, 116, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 110, 117, 108, 108, 41, 46, 0, 0, 0, 91, 49, 48, 46, 52, 46, 49, 46, 51, 93, 58, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 32, 100, 101, 102, 97, 117, 108, 116, 32, 116, 101, 120, 116, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 115, 112, 97, 99, 101, 115, 41, 46, 0, 91, 49, 49, 46, 50, 46, 49, 46, 49, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 97, 112, 112, 108, 101, 116, 62, 46, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 50, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 98, 97, 115, 101, 102, 111, 110, 116, 62, 46, 0, 91, 49, 49, 46, 50, 46, 49, 46, 51, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 99, 101, 110, 116, 101, 114, 62, 46, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 52, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 100, 105, 114, 62, 46, 0, 0, 0, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 53, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 102, 111, 110, 116, 62, 46, 0, 0, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 54, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 105, 115, 105, 110, 100, 101, 120, 62, 46, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 55, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 109, 101, 110, 117, 62, 46, 0, 0, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 56, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 115, 62, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 57, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 115, 116, 114, 105, 107, 101, 62, 46, 0, 0, 0, 91, 49, 49, 46, 50, 46, 49, 46, 49, 48, 93, 58, 32, 114, 101, 112, 108, 97, 99, 101, 32, 100, 101, 112, 114, 101, 99, 97, 116, 101, 100, 32, 104, 116, 109, 108, 32, 60, 117, 62, 46, 0, 0, 0, 0, 0, 0, 0, 91, 49, 50, 46, 49, 46, 49, 46, 49, 93, 58, 32, 60, 102, 114, 97, 109, 101, 62, 32, 109, 105, 115, 115, 105, 110, 103, 32, 116, 105, 116, 108, 101, 46, 0, 0, 0, 0, 0, 0, 91, 49, 50, 46, 49, 46, 49, 46, 50, 93, 58, 32, 60, 102, 114, 97, 109, 101, 62, 32, 116, 105, 116, 108, 101, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 110, 117, 108, 108, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 49, 50, 46, 49, 46, 49, 46, 51, 93, 58, 32, 60, 102, 114, 97, 109, 101, 62, 32, 116, 105, 116, 108, 101, 32, 105, 110, 118, 97, 108, 105, 100, 32, 40, 115, 112, 97, 99, 101, 115, 41, 46, 0, 0, 0, 0, 0, 91, 49, 50, 46, 52, 46, 49, 46, 49, 93, 58, 32, 97, 115, 115, 111, 99, 105, 97, 116, 101, 32, 108, 97, 98, 101, 108, 115, 32, 101, 120, 112, 108, 105, 99, 105, 116, 108, 121, 32, 119, 105, 116, 104, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 115, 46, 0, 0, 0, 0, 0, 91, 49, 50, 46, 52, 46, 49, 46, 50, 93, 58, 32, 97, 115, 115, 111, 99, 105, 97, 116, 101, 32, 108, 97, 98, 101, 108, 115, 32, 101, 120, 112, 108, 105, 99, 105, 116, 108, 121, 32, 119, 105, 116, 104, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 115, 32, 40, 102, 111, 114, 41, 46, 0, 0, 0, 0, 0, 0, 0, 91, 49, 50, 46, 52, 46, 49, 46, 51, 93, 58, 32, 97, 115, 115, 111, 99, 105, 97, 116, 101, 32, 108, 97, 98, 101, 108, 115, 32, 101, 120, 112, 108, 105, 99, 105, 116, 108, 121, 32, 119, 105, 116, 104, 32, 102, 111, 114, 109, 32, 99, 111, 110, 116, 114, 111, 108, 115, 32, 40, 105, 100, 41, 46, 0, 0, 0, 0, 0, 0, 0, 0, 91, 49, 51, 46, 49, 46, 49, 46, 49, 93, 58, 32, 108, 105, 110, 107, 32, 116, 101, 120, 116, 32, 110, 111, 116, 32, 109, 101, 97, 110, 105, 110, 103, 102, 117, 108, 46, 0, 0, 0, 91, 49, 51, 46, 49, 46, 49, 46, 50, 93, 58, 32, 108, 105, 110, 107, 32, 116, 101, 120, 116, 32, 109, 105, 115, 115, 105, 110, 103, 46, 0, 0, 91, 49, 51, 46, 49, 46, 49, 46, 51, 93, 58, 32, 108, 105, 110, 107, 32, 116, 101, 120, 116, 32, 116, 111, 111, 32, 108, 111, 110, 103, 46, 0, 91, 49, 51, 46, 49, 46, 49, 46, 52, 93, 58, 32, 108, 105, 110, 107, 32, 116, 101, 120, 116, 32, 110, 111, 116, 32, 109, 101, 97, 110, 105, 110, 103, 102, 117, 108, 32, 40, 99, 108, 105, 99, 107, 32, 104, 101, 114, 101, 41, 46, 0, 0, 0, 0, 0, 0, 91, 49, 51, 46, 50, 46, 49, 46, 49, 93, 58, 32, 77, 101, 116, 97, 100, 97, 116, 97, 32, 109, 105, 115, 115, 105, 110, 103, 46, 0, 0, 0, 91, 49, 51, 46, 50, 46, 49, 46, 51, 93, 58, 32, 77, 101, 116, 97, 100, 97, 116, 97, 32, 109, 105, 115, 115, 105, 110, 103, 32, 40, 114, 101, 100, 105, 114, 101, 99, 116, 47, 97, 117, 116, 111, 45, 114, 101, 102, 114, 101, 115, 104, 41, 46, 0, 0, 0, 91, 49, 51, 46, 49, 48, 46, 49, 46, 49, 93, 58, 32, 115, 107, 105, 112, 32, 111, 118, 101, 114, 32, 97, 115, 99, 105, 105, 32, 97, 114, 116, 46, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 97, 100, 100, 32, 116, 104, 101, 32, 88, 77, 76, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 32, 119, 104, 101, 110, 32, 111, 117, 116, 112, 117, 116, 116, 105, 110, 103, 32, 88, 77, 76, 32, 111, 114, 32, 88, 72, 84, 77, 76, 46, 32, 78, 111, 116, 101, 32, 116, 104, 97, 116, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 97, 108, 114, 101, 97, 100, 121, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 97, 110, 32, 38, 108, 116, 59, 63, 120, 109, 108, 32, 46, 46, 46, 32, 63, 38, 103, 116, 59, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 32, 116, 104, 101, 110, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 119, 105, 108, 108, 32, 98, 101, 32, 105, 103, 110, 111, 114, 101, 100, 46, 32, 73, 102, 32, 116, 104, 101, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 102, 111, 114, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 105, 115, 32, 100, 105, 102, 102, 101, 114, 101, 110, 116, 32, 102, 114, 111, 109, 32, 34, 97, 115, 99, 105, 105, 34, 44, 32, 111, 110, 101, 32, 111, 102, 32, 116, 104, 101, 32, 117, 116, 102, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 32, 111, 114, 32, 34, 114, 97, 119, 34, 44, 32, 116, 104, 101, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 32, 105, 115, 32, 97, 108, 119, 97, 121, 115, 32, 97, 100, 100, 101, 100, 32, 97, 115, 32, 114, 101, 113, 117, 105, 114, 101, 100, 32, 98, 121, 32, 116, 104, 101, 32, 88, 77, 76, 32, 115, 116, 97, 110, 100, 97, 114, 100, 46, 32, 0, 0, 0, 4, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 97, 100, 100, 32, 120, 109, 108, 58, 115, 112, 97, 99, 101, 61, 34, 112, 114, 101, 115, 101, 114, 118, 101, 34, 32, 116, 111, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 115, 117, 99, 104, 32, 97, 115, 32, 38, 108, 116, 59, 80, 82, 69, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 83, 84, 89, 76, 69, 38, 103, 116, 59, 32, 97, 110, 100, 32, 38, 108, 116, 59, 83, 67, 82, 73, 80, 84, 38, 103, 116, 59, 32, 119, 104, 101, 110, 32, 103, 101, 110, 101, 114, 97, 116, 105, 110, 103, 32, 88, 77, 76, 46, 32, 84, 104, 105, 115, 32, 105, 115, 32, 110, 101, 101, 100, 101, 100, 32, 105, 102, 32, 116, 104, 101, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 105, 110, 32, 115, 117, 99, 104, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 105, 115, 32, 116, 111, 32, 98, 101, 32, 112, 97, 114, 115, 101, 100, 32, 97, 112, 112, 114, 111, 112, 114, 105, 97, 116, 101, 108, 121, 32, 119, 105, 116, 104, 111, 117, 116, 32, 104, 97, 118, 105, 110, 103, 32, 97, 99, 99, 101, 115, 115, 32, 116, 111, 32, 116, 104, 101, 32, 68, 84, 68, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 34, 97, 108, 116, 61, 34, 32, 116, 101, 120, 116, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 38, 108, 116, 59, 73, 77, 71, 38, 103, 116, 59, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 46, 32, 84, 104, 105, 115, 32, 102, 101, 97, 116, 117, 114, 101, 32, 105, 115, 32, 100, 97, 110, 103, 101, 114, 111, 117, 115, 32, 97, 115, 32, 105, 116, 32, 115, 117, 112, 112, 114, 101, 115, 115, 101, 115, 32, 102, 117, 114, 116, 104, 101, 114, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 119, 97, 114, 110, 105, 110, 103, 115, 46, 32, 89, 111, 117, 32, 97, 114, 101, 32, 114, 101, 115, 112, 111, 110, 115, 105, 98, 108, 101, 32, 102, 111, 114, 32, 109, 97, 107, 105, 110, 103, 32, 121, 111, 117, 114, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 32, 97, 99, 99, 101, 115, 115, 105, 98, 108, 101, 32, 116, 111, 32, 112, 101, 111, 112, 108, 101, 32, 119, 104, 111, 32, 99, 97, 110, 32, 110, 111, 116, 32, 115, 101, 101, 32, 116, 104, 101, 32, 105, 109, 97, 103, 101, 115, 33, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 104, 97, 110, 103, 101, 32, 116, 104, 101, 32, 112, 97, 114, 115, 105, 110, 103, 32, 111, 102, 32, 112, 114, 111, 99, 101, 115, 115, 105, 110, 103, 32, 105, 110, 115, 116, 114, 117, 99, 116, 105, 111, 110, 115, 32, 116, 111, 32, 114, 101, 113, 117, 105, 114, 101, 32, 63, 38, 103, 116, 59, 32, 97, 115, 32, 116, 104, 101, 32, 116, 101, 114, 109, 105, 110, 97, 116, 111, 114, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 38, 103, 116, 59, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 97, 117, 116, 111, 109, 97, 116, 105, 99, 97, 108, 108, 121, 32, 115, 101, 116, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 115, 32, 105, 110, 32, 88, 77, 76, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 115, 116, 114, 105, 112, 32, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 115, 112, 101, 99, 105, 102, 105, 99, 32, 72, 84, 77, 76, 32, 102, 114, 111, 109, 32, 87, 111, 114, 100, 32, 50, 48, 48, 48, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 44, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 32, 115, 112, 97, 99, 101, 115, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 110, 111, 110, 45, 98, 114, 101, 97, 107, 105, 110, 103, 32, 115, 112, 97, 99, 101, 115, 32, 119, 104, 101, 114, 101, 32, 116, 104, 101, 121, 32, 101, 120, 105, 115, 116, 32, 105, 110, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 46, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 112, 114, 101, 102, 105, 120, 32, 116, 104, 97, 116, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 115, 116, 121, 108, 101, 115, 32, 114, 117, 108, 101, 115, 46, 32, 66, 121, 32, 100, 101, 102, 97, 117, 108, 116, 44, 32, 34, 99, 34, 32, 119, 105, 108, 108, 32, 98, 101, 32, 117, 115, 101, 100, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 115, 116, 114, 105, 112, 32, 111, 117, 116, 32, 115, 117, 114, 112, 108, 117, 115, 32, 112, 114, 101, 115, 101, 110, 116, 97, 116, 105, 111, 110, 97, 108, 32, 116, 97, 103, 115, 32, 97, 110, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 116, 104, 101, 109, 32, 98, 121, 32, 115, 116, 121, 108, 101, 32, 114, 117, 108, 101, 115, 32, 97, 110, 100, 32, 115, 116, 114, 117, 99, 116, 117, 114, 97, 108, 32, 109, 97, 114, 107, 117, 112, 32, 97, 115, 32, 97, 112, 112, 114, 111, 112, 114, 105, 97, 116, 101, 46, 32, 73, 116, 32, 119, 111, 114, 107, 115, 32, 119, 101, 108, 108, 32, 111, 110, 32, 116, 104, 101, 32, 72, 84, 77, 76, 32, 115, 97, 118, 101, 100, 32, 98, 121, 32, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 79, 102, 102, 105, 99, 101, 32, 112, 114, 111, 100, 117, 99, 116, 115, 46, 32, 0, 0, 0, 0, 36, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 101, 110, 97, 98, 108, 101, 32, 115, 112, 101, 99, 105, 102, 105, 99, 32, 98, 101, 104, 97, 118, 105, 111, 114, 32, 102, 111, 114, 32, 99, 108, 101, 97, 110, 105, 110, 103, 32, 117, 112, 32, 72, 84, 77, 76, 32, 101, 120, 112, 111, 114, 116, 101, 100, 32, 102, 114, 111, 109, 32, 71, 111, 111, 103, 108, 101, 32, 68, 111, 99, 115, 46, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 32, 103, 101, 110, 101, 114, 97, 116, 101, 100, 32, 98, 121, 32, 84, 105, 100, 121, 46, 60, 98, 114, 32, 47, 62, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 111, 109, 105, 116, 34, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 119, 111, 110, 39, 116, 32, 99, 111, 110, 116, 97, 105, 110, 32, 97, 32, 68, 79, 67, 84, 89, 80, 69, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 46, 60, 98, 114, 32, 47, 62, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 104, 116, 109, 108, 53, 34, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 105, 115, 32, 115, 101, 116, 32, 116, 111, 32, 34, 38, 108, 116, 59, 33, 68, 79, 67, 84, 89, 80, 69, 32, 104, 116, 109, 108, 62, 34, 46, 60, 98, 114, 32, 47, 62, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 117, 116, 111, 34, 32, 40, 116, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 41, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 117, 115, 101, 32, 97, 110, 32, 101, 100, 117, 99, 97, 116, 101, 100, 32, 103, 117, 101, 115, 115, 32, 98, 97, 115, 101, 100, 32, 117, 112, 111, 110, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 115, 32, 111, 102, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 46, 60, 98, 114, 32, 47, 62, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 115, 116, 114, 105, 99, 116, 34, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 115, 101, 116, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 116, 111, 32, 116, 104, 101, 32, 72, 84, 77, 76, 52, 32, 111, 114, 32, 88, 72, 84, 77, 76, 49, 32, 115, 116, 114, 105, 99, 116, 32, 68, 84, 68, 46, 60, 98, 114, 32, 47, 62, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 108, 111, 111, 115, 101, 34, 44, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 105, 115, 32, 115, 101, 116, 32, 116, 111, 32, 116, 104, 101, 32, 72, 84, 77, 76, 52, 32, 111, 114, 32, 88, 72, 84, 77, 76, 49, 32, 108, 111, 111, 115, 101, 32, 40, 116, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 41, 32, 68, 84, 68, 46, 32, 60, 98, 114, 32, 47, 62, 65, 108, 116, 101, 114, 110, 97, 116, 105, 118, 101, 108, 121, 44, 32, 121, 111, 117, 32, 99, 97, 110, 32, 115, 117, 112, 112, 108, 121, 32, 97, 32, 115, 116, 114, 105, 110, 103, 32, 102, 111, 114, 32, 116, 104, 101, 32, 102, 111, 114, 109, 97, 108, 32, 112, 117, 98, 108, 105, 99, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 40, 70, 80, 73, 41, 46, 60, 98, 114, 32, 47, 62, 60, 98, 114, 32, 47, 62, 70, 111, 114, 32, 101, 120, 97, 109, 112, 108, 101, 58, 32, 60, 98, 114, 32, 47, 62, 100, 111, 99, 116, 121, 112, 101, 58, 32, 34, 45, 47, 47, 65, 67, 77, 69, 47, 47, 68], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 40976);
allocate([84, 68, 32, 72, 84, 77, 76, 32, 51, 46, 49, 52, 49, 53, 57, 47, 47, 69, 78, 34, 60, 98, 114, 32, 47, 62, 60, 98, 114, 32, 47, 62, 73, 102, 32, 121, 111, 117, 32, 115, 112, 101, 99, 105, 102, 121, 32, 116, 104, 101, 32, 70, 80, 73, 32, 102, 111, 114, 32, 97, 110, 32, 88, 72, 84, 77, 76, 32, 100, 111, 99, 117, 109, 101, 110, 116, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 115, 101, 116, 32, 116, 104, 101, 32, 115, 121, 115, 116, 101, 109, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 116, 111, 32, 97, 110, 32, 101, 109, 112, 116, 121, 32, 115, 116, 114, 105, 110, 103, 46, 32, 70, 111, 114, 32, 97, 110, 32, 72, 84, 77, 76, 32, 100, 111, 99, 117, 109, 101, 110, 116, 44, 32, 84, 105, 100, 121, 32, 97, 100, 100, 115, 32, 97, 32, 115, 121, 115, 116, 101, 109, 32, 105, 100, 101, 110, 116, 105, 102, 105, 101, 114, 32, 111, 110, 108, 121, 32, 105, 102, 32, 111, 110, 101, 32, 119, 97, 115, 32, 97, 108, 114, 101, 97, 100, 121, 32, 112, 114, 101, 115, 101, 110, 116, 32, 105, 110, 32, 111, 114, 100, 101, 114, 32, 116, 111, 32, 112, 114, 101, 115, 101, 114, 118, 101, 32, 116, 104, 101, 32, 112, 114, 111, 99, 101, 115, 115, 105, 110, 103, 32, 109, 111, 100, 101, 32, 111, 102, 32, 115, 111, 109, 101, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 32, 84, 105, 100, 121, 32, 108, 101, 97, 118, 101, 115, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 102, 111, 114, 32, 103, 101, 110, 101, 114, 105, 99, 32, 88, 77, 76, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 32, 117, 110, 99, 104, 97, 110, 103, 101, 100, 46, 32, 60, 99, 111, 100, 101, 62, 45, 45, 100, 111, 99, 116, 121, 112, 101, 32, 111, 109, 105, 116, 60, 47, 99, 111, 100, 101, 62, 32, 105, 109, 112, 108, 105, 101, 115, 32, 60, 99, 111, 100, 101, 62, 45, 45, 110, 117, 109, 101, 114, 105, 99, 45, 101, 110, 116, 105, 116, 105, 101, 115, 32, 121, 101, 115, 60, 47, 99, 111, 100, 101, 62, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 100, 111, 101, 115, 32, 110, 111, 116, 32, 111, 102, 102, 101, 114, 32, 97, 32, 118, 97, 108, 105, 100, 97, 116, 105, 111, 110, 32, 111, 102, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 32, 99, 111, 110, 102, 111, 114, 109, 97, 110, 99, 101, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 105, 115, 99, 97, 114, 100, 32, 101, 109, 112, 116, 121, 32, 101, 108, 101, 109, 101, 110, 116, 115, 46, 32, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 105, 115, 99, 97, 114, 100, 32, 101, 109, 112, 116, 121, 32, 112, 97, 114, 97, 103, 114, 97, 112, 104, 115, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 105, 115, 99, 97, 114, 100, 32, 38, 108, 116, 59, 70, 79, 78, 84, 38, 103, 116, 59, 32, 97, 110, 100, 32, 38, 108, 116, 59, 67, 69, 78, 84, 69, 82, 38, 103, 116, 59, 32, 116, 97, 103, 115, 32, 119, 105, 116, 104, 111, 117, 116, 32, 99, 114, 101, 97, 116, 105, 110, 103, 32, 116, 104, 101, 32, 99, 111, 114, 114, 101, 115, 112, 111, 110, 100, 105, 110, 103, 32, 115, 116, 121, 108, 101, 32, 114, 117, 108, 101, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 110, 32, 98, 101, 32, 115, 101, 116, 32, 105, 110, 100, 101, 112, 101, 110, 100, 101, 110, 116, 108, 121, 32, 111, 102, 32, 116, 104, 101, 32, 99, 108, 101, 97, 110, 32, 111, 112, 116, 105, 111, 110, 46, 32, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 115, 116, 114, 105, 112, 32, 111, 117, 116, 32, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 44, 32, 115, 117, 99, 104, 32, 97, 115, 32, 77, 83, 32, 100, 97, 116, 97, 32, 98, 105, 110, 100, 105, 110, 103, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 105, 110, 115, 101, 114, 116, 32, 97, 32, 38, 108, 116, 59, 80, 38, 103, 116, 59, 32, 101, 108, 101, 109, 101, 110, 116, 32, 116, 111, 32, 101, 110, 99, 108, 111, 115, 101, 32, 97, 110, 121, 32, 116, 101, 120, 116, 32, 105, 116, 32, 102, 105, 110, 100, 115, 32, 105, 110, 32, 97, 110, 121, 32, 101, 108, 101, 109, 101, 110, 116, 32, 116, 104, 97, 116, 32, 97, 108, 108, 111, 119, 115, 32, 109, 105, 120, 101, 100, 32, 99, 111, 110, 116, 101, 110, 116, 32, 102, 111, 114, 32, 72, 84, 77, 76, 32, 116, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 32, 98, 117, 116, 32, 110, 111, 116, 32, 72, 84, 77, 76, 32, 115, 116, 114, 105, 99, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 101, 110, 99, 108, 111, 115, 101, 32, 97, 110, 121, 32, 116, 101, 120, 116, 32, 105, 116, 32, 102, 105, 110, 100, 115, 32, 105, 110, 32, 116, 104, 101, 32, 98, 111, 100, 121, 32, 101, 108, 101, 109, 101, 110, 116, 32, 119, 105, 116, 104, 105, 110, 32, 97, 32, 38, 108, 116, 59, 80, 38, 103, 116, 59, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 84, 104, 105, 115, 32, 105, 115, 32, 117, 115, 101, 102, 117, 108, 32, 119, 104, 101, 110, 32, 121, 111, 117, 32, 119, 97, 110, 116, 32, 116, 111, 32, 116, 97, 107, 101, 32, 101, 120, 105, 115, 116, 105, 110, 103, 32, 72, 84, 77, 76, 32, 97, 110, 100, 32, 117, 115, 101, 32, 105, 116, 32, 119, 105, 116, 104, 32, 97, 32, 115, 116, 121, 108, 101, 32, 115, 104, 101, 101, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 110, 118, 101, 114, 116, 32, 38, 108, 116, 59, 33, 91, 67, 68, 65, 84, 65, 91, 93, 93, 38, 103, 116, 59, 32, 115, 101, 99, 116, 105, 111, 110, 115, 32, 116, 111, 32, 110, 111, 114, 109, 97, 108, 32, 116, 101, 120, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 114, 101, 112, 108, 97, 99, 101, 32, 117, 110, 101, 120, 112, 101, 99, 116, 101, 100, 32, 104, 121, 112, 104, 101, 110, 115, 32, 119, 105, 116, 104, 32, 34, 61, 34, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 104, 101, 110, 32, 105, 116, 32, 99, 111, 109, 101, 115, 32, 97, 99, 114, 111, 115, 115, 32, 97, 100, 106, 97, 99, 101, 110, 116, 32, 104, 121, 112, 104, 101, 110, 115, 46, 32, 84, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 105, 115, 32, 121, 101, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 112, 114, 111, 118, 105, 100, 101, 100, 32, 102, 111, 114, 32, 117, 115, 101, 114, 115, 32, 111, 102, 32, 67, 111, 108, 100, 32, 70, 117, 115, 105, 111, 110, 32, 119, 104, 105, 99, 104, 32, 117, 115, 101, 115, 32, 116, 104, 101, 32, 99, 111, 109, 109, 101, 110, 116, 32, 115, 121, 110, 116, 97, 120, 58, 32, 38, 108, 116, 59, 33, 45, 45, 45, 32, 45, 45, 45, 38, 103, 116, 59, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 104, 101, 99, 107, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 32, 116, 104, 97, 116, 32, 99, 97, 114, 114, 121, 32, 85, 82, 73, 115, 32, 102, 111, 114, 32, 105, 108, 108, 101, 103, 97, 108, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 97, 110, 100, 32, 105, 102, 32, 115, 117, 99, 104, 32, 97, 114, 101, 32, 102, 111, 117, 110, 100, 44, 32, 101, 115, 99, 97, 112, 101, 32, 116, 104, 101, 109, 32, 97, 115, 32, 72, 84, 77, 76, 32, 52, 32, 114, 101, 99, 111, 109, 109, 101, 110, 100, 115, 46, 32, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 112, 114, 105, 110, 116, 32, 111, 117, 116, 32, 99, 111, 109, 109, 101, 110, 116, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 101, 114, 99, 101, 32, 97, 32, 115, 116, 97, 114, 116, 32, 116, 97, 103, 32, 105, 110, 116, 111, 32, 97, 110, 32, 101, 110, 100, 32, 116, 97, 103, 32, 105, 110, 32, 99, 97, 115, 101, 115, 32, 119, 104, 101, 114, 101, 32, 105, 116, 32, 108, 111, 111, 107, 115, 32, 108, 105, 107, 101, 32, 97, 110, 32, 101, 110, 100, 32, 116, 97, 103, 32, 119, 97, 115, 32, 112, 114, 111, 98, 97, 98, 108, 121, 32, 105, 110, 116, 101, 110, 100, 101, 100, 59, 32, 102, 111, 114, 32, 101, 120, 97, 109, 112, 108, 101, 44, 32, 103, 105, 118, 101, 110, 32, 38, 108, 116, 59, 115, 112, 97, 110, 38, 103, 116, 59, 102, 111, 111, 32, 38, 108, 116, 59, 98, 38, 103, 116, 59, 98, 97, 114, 38, 108, 116, 59, 98, 38, 103, 116, 59, 32, 98, 97, 122, 38, 108, 116, 59, 47, 115, 112, 97, 110, 38, 103, 116, 59, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 111, 117, 116, 112, 117, 116, 32, 38, 108, 116, 59, 115, 112, 97, 110, 38, 103, 116, 59, 102, 111, 111, 32, 38, 108, 116, 59, 98, 38, 103, 116, 59, 98, 97, 114, 38, 108, 116, 59, 47, 98, 38, 103, 116, 59, 32, 98, 97, 122, 38, 108, 116, 59, 47, 115, 112, 97, 110, 38, 103, 116, 59, 46, 32, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 109, 105, 116, 32, 111, 112, 116, 105, 111, 110, 97, 108, 32, 115, 116, 97, 114, 116, 32, 116, 97, 103, 115, 32, 97, 110, 100, 32, 101, 110, 100, 32, 116, 97, 103, 115, 32, 119, 104, 101, 110, 32, 103, 101, 110, 101, 114, 97, 116, 105, 110, 103, 32, 111, 117, 116, 112, 117, 116, 46, 32, 83, 101, 116, 116, 105, 110, 103, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 117, 115, 101, 115, 32, 97, 108, 108, 32, 116, 97, 103, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 104, 116, 109, 108, 44, 32, 104, 101, 97, 100, 44, 32, 97, 110, 100, 32, 98, 111, 100, 121, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 116, 111, 32, 98, 101, 32, 111, 109, 105, 116, 116, 101, 100, 32, 102, 114, 111, 109, 32, 111, 117, 116, 112, 117, 116, 44, 32, 97, 115, 32, 119, 101, 108, 108, 32, 97, 115, 32, 115, 117, 99, 104, 32, 101, 110, 100, 32, 116, 97, 103, 115, 32, 97, 115, 32, 38, 108, 116, 59, 47, 112, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 108, 105, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 100, 116, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 100, 100, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 111, 112, 116, 105, 111, 110, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 116, 114, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 47, 116, 100, 38, 103, 116, 59, 44, 32, 97, 110, 100, 32, 38, 108, 116, 59, 47, 116, 104, 38, 103, 116, 59, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 105, 103, 110, 111, 114, 101, 100, 32, 102, 111, 114, 32, 88, 77, 76, 32, 111, 117, 116, 112, 117, 116, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 97, 110, 32, 97, 108, 105, 97, 115, 32, 102, 111, 114, 32, 111, 109, 105, 116, 45, 111, 112, 116, 105, 111, 110, 97, 108, 45, 116, 97, 103, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 105, 110, 100, 101, 110, 116, 32, 38, 108, 116, 59, 33, 91, 67, 68, 65, 84, 65, 91, 93, 93, 38, 103, 116, 59, 32, 115, 101, 99, 116, 105, 111, 110, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 117, 115, 101, 32, 116, 104, 101, 32, 88, 77, 76, 32, 112, 97, 114, 115, 101, 114, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 116, 104, 101, 32, 101, 114, 114, 111, 114, 32, 99, 111, 114, 114, 101, 99, 116, 105, 110, 103, 32, 72, 84, 77, 76, 32, 112, 97, 114, 115, 101, 114, 46, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 109, 98, 105, 110, 101, 32, 99, 108, 97, 115, 115, 32, 110, 97, 109, 101, 115, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 110, 101, 119, 32, 99, 108, 97, 115, 115, 32, 110, 97, 109, 101, 44, 32, 105, 102, 32, 109, 117, 108, 116, 105, 112, 108, 101, 32, 99, 108, 97, 115, 115, 32, 97, 115, 115, 105, 103, 110, 109, 101, 110, 116, 115, 32, 97, 114, 101, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 111, 110, 32, 97, 110, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 73, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 109, 98, 105, 110, 101, 32, 115, 116, 121, 108, 101, 115, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 110, 101, 119, 32, 115, 116, 121, 108, 101, 44, 32, 105, 102, 32, 109, 117, 108, 116, 105, 112, 108, 101, 32, 115, 116, 121, 108, 101, 32, 118, 97, 108, 117, 101, 115, 32, 97, 114, 101, 32, 100, 101, 116, 101, 99, 116, 101, 100, 32, 111, 110, 32, 97, 110, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 72, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 114, 101, 112, 108, 97, 99, 101, 32, 97, 110, 121, 32, 111, 99, 99, 117, 114, 114, 101, 110, 99, 101, 32, 111, 102, 32, 38, 108, 116, 59, 73, 38, 103, 116, 59, 32, 98, 121, 32, 38, 108, 116, 59, 69, 77, 38, 103, 116, 59, 32, 97, 110, 100, 32, 97, 110, 121, 32, 111, 99, 99, 117, 114, 114, 101, 110, 99, 101, 32, 111, 102, 32, 38, 108, 116, 59, 66, 38, 103, 116, 59, 32, 98, 121, 32, 38, 108, 116, 59, 83, 84, 82, 79, 78, 71, 38, 103, 116, 59, 46, 32, 73, 110, 32, 98, 111, 116, 104, 32, 99, 97, 115, 101, 115, 44, 32, 116, 104, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 97, 114, 101, 32, 112, 114, 101, 115, 101, 114, 118, 101, 100, 32, 117, 110, 99, 104, 97, 110, 103, 101, 100, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 110, 32, 98, 101, 32, 115, 101, 116, 32, 105, 110, 100, 101, 112, 101, 110, 100, 101, 110, 116, 108, 121, 32, 111, 102, 32, 116, 104, 101, 32, 99, 108, 101, 97, 110, 32, 97, 110, 100, 32, 100, 114, 111, 112, 45, 102, 111, 110, 116, 45, 116, 97, 103, 115, 32, 111, 112, 116, 105, 111, 110, 115, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 110, 118, 101, 114, 116, 32, 116, 104, 101, 32, 118, 97, 108, 117, 101, 32, 111, 102, 32, 97, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 116, 104, 97, 116, 32, 116, 97, 107, 101, 115, 32, 97, 32, 108, 105, 115, 116, 32, 111, 102, 32, 112, 114, 101, 100, 101, 102, 105, 110, 101, 100, 32, 118, 97, 108, 117, 101, 115, 32, 116, 111, 32, 108, 111, 119, 101, 114, 32, 99, 97, 115, 101, 46, 32, 84, 104, 105, 115, 32, 105, 115, 32, 114, 101, 113, 117, 105, 114, 101, 100, 32, 102, 111, 114, 32, 88, 72, 84, 77, 76, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 109, 101, 114, 103, 101, 32, 110, 101, 115, 116, 101, 100, 32, 38, 108, 116, 59, 98, 38, 103, 116, 59, 32, 97, 110, 100, 32, 38, 108, 116, 59, 105, 38, 103, 116, 59, 32, 101, 108, 101, 109, 101, 110, 116, 115, 59, 32, 102, 111, 114, 32, 101, 120, 97, 109, 112, 108, 101, 44, 32, 102, 111, 114, 32, 116, 104, 101, 32, 99, 97, 115, 101, 32, 38, 108, 116, 59, 98, 32, 99, 108, 97, 115, 115, 61, 34, 114, 116, 111, 112, 45, 50, 34, 38, 103, 116, 59, 102, 111, 111, 32, 38, 108, 116, 59, 98, 32, 99, 108, 97, 115, 115, 61, 34, 114, 50, 45, 50, 34, 38, 103, 116, 59, 98, 97, 114, 38, 108, 116, 59, 47, 98, 38, 103, 116, 59, 32, 98, 97, 122, 38, 108, 116, 59, 47, 98, 38, 103, 116, 59, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 111, 117, 116, 112, 117, 116, 32, 32, 38, 108, 116, 59, 98, 32, 99, 108, 97, 115, 115, 61, 34, 114, 116, 111, 112, 45, 50, 34, 38, 103, 116, 59, 102, 111, 111, 32, 98, 97, 114, 32, 98, 97, 122, 38, 108, 116, 59, 47, 98, 38, 103, 116, 59, 46, 32, 0, 0, 67, 97, 110, 32, 98, 101, 32, 117, 115, 101, 100, 32, 116, 111, 32, 109, 111, 100, 105, 102, 121, 32, 98, 101, 104, 97, 118, 105, 111, 114, 32, 111, 102, 32, 45, 99, 32, 40, 45, 45, 99, 108, 101, 97, 110, 32, 121, 101, 115, 41, 32, 111, 112, 116, 105, 111, 110, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 109, 101, 114, 103, 101, 32, 110, 101, 115, 116, 101, 100, 32, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 32, 115, 117, 99, 104, 32, 97, 115, 32, 34, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 46, 46, 46, 38, 108, 116, 59, 47, 100, 105, 118, 38, 103, 116, 59, 38, 108, 116, 59, 47, 100, 105, 118, 38, 103, 116, 59, 34, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 117, 116, 111, 34, 44, 32, 116, 104, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 111, 102, 32, 116, 104, 101, 32, 105, 110, 110, 101, 114, 32, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 32, 97, 114, 101, 32, 109, 111, 118, 101, 100, 32, 116, 111, 32, 116, 104, 101, 32, 111, 117, 116, 101, 114, 32, 111, 110, 101, 46, 32, 65, 115, 32, 119, 101, 108, 108, 44, 32, 110, 101, 115, 116, 101, 100, 32, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 32, 119, 105, 116, 104, 32, 73, 68, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 97, 114, 101, 32, 110, 111, 116, 32, 109, 101, 114, 103, 101, 100, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 121, 101, 115, 34, 44, 32, 116, 104, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 111, 102, 32, 116, 104, 101, 32, 105, 110, 110, 101, 114, 32, 38, 108, 116, 59, 100, 105, 118, 38, 103, 116, 59, 32, 97, 114, 101, 32, 100, 105, 115, 99, 97, 114, 100, 101, 100, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 101, 120, 99, 101, 112, 116, 105, 111, 110, 32, 111, 102, 32, 34, 99, 108, 97, 115, 115, 34, 32, 97, 110, 100, 32, 34, 115, 116, 121, 108, 101, 34, 46, 32, 0, 0, 0, 32, 0, 0, 0, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 97, 110, 32, 98, 101, 32, 117, 115, 101, 100, 32, 116, 111, 32, 109, 111, 100, 105, 102, 121, 32, 98, 101, 104, 97, 118, 105, 111, 114, 32, 111, 102, 32, 45, 99, 32, 40, 45, 45, 99, 108, 101, 97, 110, 32, 121, 101, 115, 41, 32, 111, 112, 116, 105, 111, 110, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 109, 101, 114, 103, 101, 32, 110, 101, 115, 116, 101, 100, 32, 38, 108, 116, 59, 115, 112, 97, 110, 38, 103, 116, 59, 32, 115, 117, 99, 104, 32, 97, 115, 32, 34, 38, 108, 116, 59, 115, 112, 97, 110, 38, 103, 116, 59, 38, 108, 116, 59, 115, 112, 97, 110, 38, 103, 116, 59, 46, 46, 46, 38, 108, 116, 59, 47, 115, 112, 97, 110, 38, 103, 116, 59, 38, 108, 116, 59, 47, 115, 112, 97, 110, 38, 103, 116, 59, 34, 46, 32, 84, 104, 101, 32, 97, 108, 103, 111, 114, 105, 116, 104, 109, 32, 105, 115, 32, 105, 100, 101, 110, 116, 105, 99, 97, 108, 32, 116, 111, 32, 116, 104, 101, 32, 111, 110, 101, 32, 117, 115, 101, 100, 32, 98, 121, 32, 45, 45, 109, 101, 114, 103, 101, 45, 100, 105, 118, 115, 46, 32, 0, 32, 0, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 97, 108, 108, 111, 119, 32, 110, 117, 109, 101, 114, 105, 99, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 114, 101, 102, 101, 114, 101, 110, 99, 101, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 110, 101, 119, 32, 98, 108, 111, 99, 107, 45, 108, 101, 118, 101, 108, 32, 116, 97, 103, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 97, 107, 101, 115, 32, 97, 32, 115, 112, 97, 99, 101, 32, 111, 114, 32, 99, 111, 109, 109, 97, 32, 115, 101, 112, 97, 114, 97, 116, 101, 100, 32, 108, 105, 115, 116, 32, 111, 102, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 46, 32, 85, 110, 108, 101, 115, 115, 32, 121, 111, 117, 32, 100, 101, 99, 108, 97, 114, 101, 32, 110, 101, 119, 32, 116, 97, 103, 115, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 114, 101, 102, 117, 115, 101, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 116, 105, 100, 105, 101, 100, 32, 102, 105, 108, 101, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 112, 114, 101, 118, 105, 111, 117, 115, 108, 121, 32, 117, 110, 107, 110, 111, 119, 110, 32, 116, 97, 103, 115, 46, 32, 78, 111, 116, 101, 32, 121, 111, 117, 32, 99, 97, 110, 39, 116, 32, 99, 104, 97, 110, 103, 101, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 32, 109, 111, 100, 101, 108, 32, 102, 111, 114, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 115, 117, 99, 104, 32, 97, 115, 32, 38, 108, 116, 59, 84, 65, 66, 76, 69, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 85, 76, 38, 103, 116, 59, 44, 32, 38, 108, 116, 59, 79, 76, 38, 103, 116, 59, 32, 97, 110, 100, 32, 38, 108, 116, 59, 68, 76, 38, 103, 116, 59, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 105, 103, 110, 111, 114, 101, 100, 32, 105, 110, 32, 88, 77, 76, 32, 109, 111, 100, 101, 46, 32, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 80, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 110, 101, 119, 32, 101, 109, 112, 116, 121, 32, 105, 110, 108, 105, 110, 101, 32, 116, 97, 103, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 97, 107, 101, 115, 32, 97, 32, 115, 112, 97, 99, 101, 32, 111, 114, 32, 99, 111, 109, 109, 97, 32, 115, 101, 112, 97, 114, 97, 116, 101, 100, 32, 108, 105, 115, 116, 32, 111, 102, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 46, 32, 85, 110, 108, 101, 115, 115, 32, 121, 111, 117, 32, 100, 101, 99, 108, 97, 114, 101, 32, 110, 101, 119, 32, 116, 97, 103, 115, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 114, 101, 102, 117, 115, 101, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 116, 105, 100, 105, 101, 100, 32, 102, 105, 108, 101, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 112, 114, 101, 118, 105, 111, 117, 115, 108, 121, 32, 117, 110, 107, 110, 111, 119, 110, 32, 116, 97, 103, 115, 46, 32, 82, 101, 109, 101, 109, 98, 101, 114, 32, 116, 111, 32, 97, 108, 115, 111, 32, 100, 101, 99, 108, 97, 114, 101, 32, 101, 109, 112, 116, 121, 32, 116, 97, 103, 115, 32, 97, 115, 32, 101, 105, 116, 104, 101, 114, 32, 105, 110, 108, 105, 110, 101, 32, 111, 114, 32, 98, 108, 111, 99, 107, 108, 101, 118, 101, 108, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 105, 103, 110, 111, 114, 101, 100, 32, 105, 110, 32, 88, 77, 76, 32, 109, 111, 100, 101, 46, 32, 0, 0, 0, 0, 81, 0, 0, 0, 80, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 110, 101, 119, 32, 110, 111, 110, 45, 101, 109, 112, 116, 121, 32, 105, 110, 108, 105, 110, 101, 32, 116, 97, 103, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 97, 107, 101, 115, 32, 97, 32, 115, 112, 97, 99, 101, 32, 111, 114, 32, 99, 111, 109, 109, 97, 32, 115, 101, 112, 97, 114, 97, 116, 101, 100, 32, 108, 105, 115, 116, 32, 111, 102, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 46, 32, 85, 110, 108, 101, 115, 115, 32, 121, 111, 117, 32, 100, 101, 99, 108, 97, 114, 101, 32, 110, 101, 119, 32, 116, 97, 103, 115, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 114, 101, 102, 117, 115, 101, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 116, 105, 100, 105, 101, 100, 32, 102, 105, 108, 101, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 112, 114, 101, 118, 105, 111, 117, 115, 108, 121, 32, 117, 110, 107, 110, 111, 119, 110, 32, 116, 97, 103, 115, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 105, 103, 110, 111, 114, 101, 100, 32, 105, 110, 32, 88, 77, 76, 32, 109, 111, 100, 101, 46, 32, 0, 0, 0, 0, 81, 0, 0, 0, 82, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 110, 101, 119, 32, 116, 97, 103, 115, 32, 116, 104, 97, 116, 32, 97, 114, 101, 32, 116, 111, 32, 98, 101, 32, 112, 114, 111, 99, 101, 115, 115, 101, 100, 32, 105, 110, 32, 101, 120, 97, 99, 116, 108, 121, 32, 116, 104, 101, 32, 115, 97, 109, 101, 32, 119, 97, 121, 32, 97, 115, 32, 72, 84, 77, 76, 39, 115, 32, 38, 108, 116, 59, 80, 82, 69, 38, 103, 116, 59, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 97, 107, 101, 115, 32, 97, 32, 115, 112, 97, 99, 101, 32, 111, 114, 32, 99, 111, 109, 109, 97, 32, 115, 101, 112, 97, 114, 97, 116, 101, 100, 32, 108, 105, 115, 116, 32, 111, 102, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 46, 32, 85, 110, 108, 101, 115, 115, 32, 121, 111, 117, 32, 100, 101, 99, 108, 97, 114, 101, 32, 110, 101, 119, 32, 116, 97, 103, 115, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 114, 101, 102, 117, 115, 101, 32, 116, 111, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 116, 105, 100, 105, 101, 100, 32, 102, 105, 108, 101, 32, 105, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 112, 114, 101, 118, 105, 111, 117, 115, 108, 121, 32, 117, 110, 107, 110, 111, 119, 110, 32, 116, 97, 103, 115, 46, 32, 78, 111, 116, 101, 32, 121, 111, 117, 32, 99, 97, 110, 32, 110, 111, 116, 32, 97, 115, 32, 121, 101, 116, 32, 97, 100, 100, 32, 110, 101, 119, 32, 67, 68, 65, 84, 65, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 40, 115, 105, 109, 105, 108, 97, 114, 32, 116, 111, 32, 38, 108, 116, 59, 83, 67, 82, 73, 80, 84, 38, 103, 116, 59, 41, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 105, 115, 32, 105, 103, 110, 111, 114, 101, 100, 32, 105, 110, 32, 88, 77, 76, 32, 109, 111, 100, 101, 46, 32, 0, 0, 81, 0, 0, 0, 82, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 111, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 116, 104, 101, 32, 98, 117, 105, 108, 116, 45, 105, 110, 32, 72, 84, 77, 76, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 40, 38, 97, 109, 112, 59, 97, 109, 112, 59, 44, 32, 38, 97, 109, 112, 59, 108, 116, 59, 44, 32, 38, 97, 109, 112, 59, 103, 116, 59, 32, 97, 110, 100, 32, 38, 97, 109, 112, 59, 113, 117, 111, 116, 59, 41, 32, 105, 110, 32, 116, 104, 101, 32, 110, 117, 109, 101, 114, 105, 99, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 116, 104, 101, 32, 110, 97, 109, 101, 100, 32, 101, 110, 116, 105, 116, 121, 32, 102, 111, 114, 109, 46, 32, 79, 110, 108, 121, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 99, 111, 109, 112, 97, 116, 105, 98, 108, 101, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 100, 101, 99, 108, 97, 114, 97, 116, 105, 111, 110, 32, 103, 101, 110, 101, 114, 97, 116, 101, 100, 32, 97, 114, 101, 32, 117, 115, 101, 100, 46, 32, 69, 110, 116, 105, 116, 105, 101, 115, 32, 116, 104, 97, 116, 32, 99, 97, 110, 32, 98, 101, 32, 114, 101, 112, 114, 101, 115, 101, 110, 116, 101, 100, 32, 105, 110, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 97, 114, 101, 32, 116, 114, 97, 110, 115, 108, 97, 116, 101, 100, 32, 99, 111, 114, 114, 101, 115, 112, 111, 110, 100, 105, 110, 103, 108, 121, 46, 32, 0, 0, 9, 0, 0, 0, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 101, 100, 32, 111, 117, 116, 112, 117, 116, 44, 32, 119, 114, 105, 116, 105, 110, 103, 32, 105, 116, 32, 97, 115, 32, 72, 84, 77, 76, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 101, 100, 32, 111, 117, 116, 112, 117, 116, 44, 32, 119, 114, 105, 116, 105, 110, 103, 32, 105, 116, 32, 97, 115, 32, 101, 120, 116, 101, 110, 115, 105, 98, 108, 101, 32, 72, 84, 77, 76, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 117, 115, 101, 115, 32, 84, 105, 100, 121, 32, 116, 111, 32, 115, 101, 116, 32, 116, 104, 101, 32, 68, 79, 67, 84, 89, 80, 69, 32, 97, 110, 100, 32, 100, 101, 102, 97, 117, 108, 116, 32, 110, 97, 109, 101, 115, 112, 97, 99, 101, 32, 97, 115, 32, 97, 112, 112, 114, 111, 112, 114, 105, 97, 116, 101, 32, 116, 111, 32, 88, 72, 84, 77, 76, 46, 32, 73, 102, 32, 97, 32, 68, 79, 67, 84, 89, 80, 69, 32, 111, 114, 32, 110, 97, 109, 101, 115, 112, 97, 99, 101, 32, 105, 115, 32, 103, 105, 118, 101, 110, 32, 116, 104, 101, 121, 32, 119, 105, 108, 108, 32, 99, 104, 101, 99, 107, 101, 100, 32, 102, 111, 114, 32, 99, 111, 110, 115, 105, 115, 116, 101, 110, 99, 121, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 32, 111, 102, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 46, 32, 73, 110, 32, 116, 104, 101, 32, 99, 97, 115, 101, 32, 111, 102, 32, 97, 110, 32, 105, 110, 99, 111, 110, 115, 105, 115, 116, 101, 110, 99, 121, 44, 32, 116, 104, 101, 32, 99, 111, 114, 114, 101, 99, 116, 101, 100, 32, 118, 97, 108, 117, 101, 115, 32, 119, 105, 108, 108, 32, 97, 112, 112, 101, 97, 114, 32, 105, 110, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 46, 32, 70, 111, 114, 32, 88, 72, 84, 77, 76, 44, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 99, 97, 110, 32, 98, 101, 32, 119, 114, 105, 116, 116, 101, 110, 32, 97, 115, 32, 110, 97, 109, 101, 100, 32, 111, 114, 32, 110, 117, 109, 101, 114, 105, 99, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 97, 99, 99, 111, 114, 100, 105, 110, 103, 32, 116, 111, 32, 116, 104, 101, 32, 115, 101, 116, 116, 105, 110, 103, 32, 111, 102, 32, 116, 104, 101, 32, 34, 110, 117, 109, 101, 114, 105, 99, 45, 101, 110, 116, 105, 116, 105, 101, 115, 34, 32, 111, 112, 116, 105, 111, 110, 46, 32, 84, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 99, 97, 115, 101, 32, 111, 102, 32, 116, 97, 103, 115, 32, 97, 110, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 119, 105, 108, 108, 32, 98, 101, 32, 112, 114, 101, 115, 101, 114, 118, 101, 100, 44, 32, 114, 101, 103, 97, 114, 100, 108, 101, 115, 115, 32, 111, 102, 32, 111, 116, 104, 101, 114, 32, 111, 112, 116, 105, 111, 110, 115, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 32, 111, 117, 116, 112, 117, 116, 44, 32, 119, 114, 105, 116, 105, 110, 103, 32, 105, 116, 32, 97, 115, 32, 119, 101, 108, 108, 45, 102, 111, 114, 109, 101, 100, 32, 88, 77, 76, 46, 32, 65, 110, 121, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 110, 111, 116, 32, 100, 101, 102, 105, 110, 101, 100, 32, 105, 110, 32, 88, 77, 76, 32, 49, 46, 48, 32, 119, 105, 108, 108, 32, 98, 101, 32, 119, 114, 105, 116, 116, 101, 110, 32, 97, 115, 32, 110, 117, 109, 101, 114, 105, 99, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 116, 111, 32, 97, 108, 108, 111, 119, 32, 116, 104, 101, 109, 32, 116, 111, 32, 98, 101, 32, 112, 97, 114, 115, 101, 100, 32, 98, 121, 32, 97, 32, 88, 77, 76, 32, 112, 97, 114, 115, 101, 114, 46, 32, 84, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 99, 97, 115, 101, 32, 111, 102, 32, 116, 97, 103, 115, 32, 97, 110, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 119, 105, 108, 108, 32, 98, 101, 32, 112, 114, 101, 115, 101, 114, 118, 101, 100, 44, 32, 114, 101, 103, 97, 114, 100, 108, 101, 115, 115, 32, 111, 102, 32, 111, 116, 104, 101, 114, 32, 111, 112, 116, 105, 111, 110, 115, 46, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 117, 110, 97, 100, 111, 114, 110, 101, 100, 32, 38, 97, 109, 112, 59, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 97, 115, 32, 38, 97, 109, 112, 59, 97, 109, 112, 59, 46, 32, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 38, 113, 117, 111, 116, 59, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 97, 115, 32, 38, 97, 109, 112, 59, 113, 117, 111, 116, 59, 32, 97, 115, 32, 105, 115, 32, 112, 114, 101, 102, 101, 114, 114, 101, 100, 32, 98, 121, 32, 115, 111, 109, 101, 32, 101, 100, 105, 116, 105, 110, 103, 32, 101, 110, 118, 105, 114, 111, 110, 109, 101, 110, 116, 115, 46, 32, 84, 104, 101, 32, 97, 112, 111, 115, 116, 114, 111, 112, 104, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 39, 32, 105, 115, 32, 119, 114, 105, 116, 116, 101, 110, 32, 111, 117, 116, 32, 97, 115, 32, 38, 97, 109, 112, 59, 35, 51, 57, 59, 32, 115, 105, 110, 99, 101, 32, 109, 97, 110, 121, 32, 119, 101, 98, 32, 98, 114, 111, 119, 115, 101, 114, 115, 32, 100, 111, 110, 39, 116, 32, 121, 101, 116, 32, 115, 117, 112, 112, 111, 114, 116, 32, 38, 97, 109, 112, 59, 97, 112, 111, 115, 59, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 110, 111, 110, 45, 98, 114, 101, 97, 107, 105, 110, 103, 32, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 97, 115, 32, 101, 110, 116, 105, 116, 105, 101, 115, 44, 32, 114, 97, 116, 104, 101, 114, 32, 116, 104, 97, 110, 32, 97, 115, 32, 116, 104, 101, 32, 85, 110, 105, 99, 111, 100, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 118, 97, 108, 117, 101, 32, 49, 54, 48, 32, 40, 100, 101, 99, 105, 109, 97, 108, 41, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 107, 101, 101, 112, 32, 116, 104, 101, 32, 102, 105, 114, 115, 116, 32, 111, 114, 32, 108, 97, 115, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 44, 32, 105, 102, 32, 97, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 105, 115, 32, 114, 101, 112, 101, 97, 116, 101, 100, 44, 32, 101, 46, 103, 46, 32, 104, 97, 115, 32, 116, 119, 111, 32, 97, 108, 105, 103, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 46, 32, 0, 0, 0, 0, 0, 72, 0, 0, 0, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 97, 116, 32, 116, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 115, 111, 114, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 119, 105, 116, 104, 105, 110, 32, 97, 110, 32, 101, 108, 101, 109, 101, 110, 116, 32, 117, 115, 105, 110, 103, 32, 116, 104, 101, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 115, 111, 114, 116, 32, 97, 108, 103, 111, 114, 105, 116, 104, 109, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 108, 112, 104, 97, 34, 44, 32, 116, 104, 101, 32, 97, 108, 103, 111, 114, 105, 116, 104, 109, 32, 105, 115, 32, 97, 110, 32, 97, 115, 99, 101, 110, 100, 105, 110, 103, 32, 97, 108, 112, 104, 97, 98, 101, 116, 105, 99, 32, 115, 111, 114, 116, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 114, 101, 112, 108, 97, 99, 101, 32, 110, 117, 109, 101, 114, 105, 99, 32, 118, 97, 108, 117, 101, 115, 32, 105, 110, 32, 99, 111, 108, 111, 114, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 98, 121, 32, 72, 84, 77, 76, 47, 88, 72, 84, 77, 76, 32, 99, 111, 108, 111, 114, 32, 110, 97, 109, 101, 115, 32, 119, 104, 101, 114, 101, 32, 100, 101, 102, 105, 110, 101, 100, 44, 32, 101, 46, 103, 46, 32, 114, 101, 112, 108, 97, 99, 101, 32, 34, 35, 102, 102, 102, 102, 102, 102, 34, 32, 119, 105, 116, 104, 32, 34, 119, 104, 105, 116, 101, 34, 46, 32, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 112, 114, 105, 110, 116, 32, 111, 110, 108, 121, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 115, 32, 111, 102, 32, 116, 104, 101, 32, 98, 111, 100, 121, 32, 116, 97, 103, 32, 97, 115, 32, 97, 110, 32, 72, 84, 77, 76, 32, 102, 114, 97, 103, 109, 101, 110, 116, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 117, 116, 111, 34, 44, 32, 116, 104, 105, 115, 32, 105, 115, 32, 112, 101, 114, 102, 111, 114, 109, 101, 100, 32, 111, 110, 108, 121, 32, 105, 102, 32, 116, 104, 101, 32, 98, 111, 100, 121, 32, 116, 97, 103, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 105, 110, 102, 101, 114, 114, 101, 100, 46, 32, 85, 115, 101, 102, 117, 108, 32, 102, 111, 114, 32, 105, 110, 99, 111, 114, 112, 111, 114, 97, 116, 105, 110, 103, 32, 101, 120, 105, 115, 116, 105, 110, 103, 32, 119, 104, 111, 108, 101, 32, 112, 97, 103, 101, 115, 32, 97, 115, 32, 97, 32, 112, 111, 114, 116, 105, 111, 110, 32, 111, 102, 32, 97, 110, 111, 116, 104, 101, 114, 32, 112, 97, 103, 101, 46, 32, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 104, 97, 115, 32, 110, 111, 32, 101, 102, 102, 101, 99, 116, 32, 105, 102, 32, 88, 77, 76, 32, 111, 117, 116, 112, 117, 116, 32, 105, 115, 32, 114, 101, 113, 117, 101, 115, 116, 101, 100, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 110, 97, 109, 101, 115, 32, 105, 110, 32, 117, 112, 112, 101, 114, 32, 99, 97, 115, 101, 46, 32, 84, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 105, 115, 32, 110, 111, 44, 32, 119, 104, 105, 99, 104, 32, 114, 101, 115, 117, 108, 116, 115, 32, 105, 110, 32, 108, 111, 119, 101, 114, 32, 99, 97, 115, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 110, 97, 109, 101, 115, 44, 32, 101, 120, 99, 101, 112, 116, 32, 102, 111, 114, 32, 88, 77, 76, 32, 105, 110, 112, 117, 116, 44, 32, 119, 104, 101, 114, 101, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 99, 97, 115, 101, 32, 105, 115, 32, 112, 114, 101, 115, 101, 114, 118, 101, 100, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 32, 105, 110, 32, 117, 112, 112, 101, 114, 32, 99, 97, 115, 101, 46, 32, 84, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 105, 115, 32, 110, 111, 44, 32, 119, 104, 105, 99, 104, 32, 114, 101, 115, 117, 108, 116, 115, 32, 105, 110, 32, 108, 111, 119, 101, 114, 32, 99, 97, 115, 101, 32, 116, 97, 103, 32, 110, 97, 109, 101, 115, 44, 32, 101, 120, 99, 101, 112, 116, 32, 102, 111, 114, 32, 88, 77, 76, 32, 105, 110, 112, 117, 116, 44, 32, 119, 104, 101, 114, 101, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 99, 97, 115, 101, 32, 105, 115, 32, 112, 114, 101, 115, 101, 114, 118, 101, 100, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 103, 111, 32, 116, 111, 32, 103, 114, 101, 97, 116, 32, 112, 97, 105, 110, 115, 32, 116, 111, 32, 115, 116, 114, 105, 112, 32, 111, 117, 116, 32, 97, 108, 108, 32, 116, 104, 101, 32, 115, 117, 114, 112, 108, 117, 115, 32, 115, 116, 117, 102, 102, 32, 77, 105, 99, 114, 111, 115, 111, 102, 116, 32, 87, 111, 114, 100, 32, 50, 48, 48, 48, 32, 105, 110, 115, 101, 114, 116, 115, 32, 119, 104, 101, 110, 32, 121, 111, 117, 32, 115, 97, 118, 101, 32, 87, 111, 114, 100, 32, 100, 111, 99, 117, 109, 101, 110, 116, 115, 32, 97, 115, 32, 34, 87, 101, 98, 32, 112, 97, 103, 101, 115, 34, 46, 32, 68, 111, 101, 115, 110, 39, 116, 32, 104, 97, 110, 100, 108, 101, 32, 101, 109, 98, 101, 100, 100, 101, 100, 32, 105, 109, 97, 103, 101, 115, 32, 111, 114, 32, 86, 77, 76, 46, 32, 89, 111, 117, 32, 115, 104, 111, 117, 108, 100, 32, 99, 111, 110, 115, 105, 100, 101, 114, 32, 117, 115, 105, 110, 103, 32, 87, 111, 114, 100, 39, 115, 32, 34, 83, 97, 118, 101, 32, 65, 115, 58, 32, 87, 101, 98, 32, 80, 97, 103, 101, 44, 32, 70, 105, 108, 116, 101, 114, 101, 100, 34, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 119, 104, 97, 116, 32, 108, 101, 118, 101, 108, 32, 111, 102, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 99, 104, 101, 99, 107, 105, 110, 103, 44, 32, 105, 102, 32, 97, 110, 121, 44, 32, 116, 104, 97, 116, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 111, 46, 32, 76, 101, 118, 101, 108, 32, 48, 32, 105, 115, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 32, 116, 111, 32, 84, 105, 100, 121, 32, 67, 108, 97, 115, 115, 105, 99, 39, 115, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 99, 104, 101, 99, 107, 105, 110, 103, 46, 32, 70, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 32, 111, 110, 32, 84, 105, 100, 121, 39, 115, 32, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 32, 99, 104, 101, 99, 107, 105, 110, 103, 44, 32, 118, 105, 115, 105, 116, 32, 116, 104, 101, 32, 60, 97, 32, 104, 114, 101, 102, 61, 34, 104, 116, 116, 112, 58, 47, 47, 119, 119, 119, 46, 97, 112, 114, 111, 109, 112, 116, 46, 99, 97, 47, 84, 105, 100, 121, 47, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 99, 104, 101, 99, 107, 115, 46, 104, 116, 109, 108, 34, 32, 62, 65, 100, 97, 112, 116, 105, 118, 101, 32, 84, 101, 99, 104, 110, 111, 108, 111, 103, 121, 32, 82, 101, 115, 111, 117, 114, 99, 101, 32, 67, 101, 110, 116, 114, 101, 32, 97, 116, 32, 116, 104, 101, 32, 85, 110, 105, 118, 101, 114, 115, 105, 116, 121, 32, 111, 102, 32, 84, 111, 114, 111, 110, 116, 111, 60, 47, 97, 62, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 110, 117, 109, 98, 101, 114, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 116, 111, 32, 100, 101, 116, 101, 114, 109, 105, 110, 101, 32, 105, 102, 32, 102, 117, 114, 116, 104, 101, 114, 32, 101, 114, 114, 111, 114, 115, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 32, 115, 104, 111, 119, 110, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 48, 44, 32, 116, 104, 101, 110, 32, 110, 111, 32, 101, 114, 114, 111, 114, 115, 32, 97, 114, 101, 32, 115, 104, 111, 119, 110, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 105, 115, 112, 108, 97, 121, 32, 105, 110, 102, 111, 45, 108, 101, 118, 101, 108, 32, 109, 101, 115, 115, 97, 103, 101, 115, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 115, 117, 112, 112, 114, 101, 115, 115, 32, 119, 97, 114, 110, 105, 110, 103, 115, 46, 32, 84, 104, 105, 115, 32, 99, 97, 110, 32, 98, 101, 32, 117, 115, 101, 102, 117, 108, 32, 119, 104, 101, 110, 32, 97, 32, 102, 101, 119, 32, 101, 114, 114, 111, 114, 115, 32, 97, 114, 101, 32, 104, 105, 100, 100, 101, 110, 32, 105, 110, 32, 97, 32, 102, 108, 117, 114, 114, 121, 32, 111, 102, 32, 119, 97, 114, 110, 105, 110, 103, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 97, 32, 108, 105, 110, 101, 32, 98, 114, 101, 97, 107, 32, 98, 101, 102, 111, 114, 101, 32, 101, 97, 99, 104, 32, 38, 108, 116, 59, 66, 82, 38, 103, 116, 59, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 105, 110, 100, 101, 110, 116, 32, 98, 108, 111, 99, 107, 45, 108, 101, 118, 101, 108, 32, 116, 97, 103, 115, 46, 32, 73, 102], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 51216);
allocate([32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 117, 116, 111, 34, 44, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 117, 115, 101, 115, 32, 84, 105, 100, 121, 32, 116, 111, 32, 100, 101, 99, 105, 100, 101, 32, 119, 104, 101, 116, 104, 101, 114, 32, 111, 114, 32, 110, 111, 116, 32, 116, 111, 32, 105, 110, 100, 101, 110, 116, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 32, 111, 102, 32, 116, 97, 103, 115, 32, 115, 117, 99, 104, 32, 97, 115, 32, 84, 73, 84, 76, 69, 44, 32, 72, 49, 45, 72, 54, 44, 32, 76, 73, 44, 32, 84, 68, 44, 32, 84, 68, 44, 32, 111, 114, 32, 80, 32, 100, 101, 112, 101, 110, 100, 105, 110, 103, 32, 111, 110, 32, 119, 104, 101, 116, 104, 101, 114, 32, 111, 114, 32, 110, 111, 116, 32, 116, 104, 101, 32, 99, 111, 110, 116, 101, 110, 116, 32, 105, 110, 99, 108, 117, 100, 101, 115, 32, 97, 32, 98, 108, 111, 99, 107, 45, 108, 101, 118, 101, 108, 32, 101, 108, 101, 109, 101, 110, 116, 46, 32, 89, 111, 117, 32, 97, 114, 101, 32, 97, 100, 118, 105, 115, 101, 100, 32, 116, 111, 32, 97, 118, 111, 105, 100, 32, 115, 101, 116, 116, 105, 110, 103, 32, 105, 110, 100, 101, 110, 116, 32, 116, 111, 32, 121, 101, 115, 32, 97, 115, 32, 116, 104, 105, 115, 32, 99, 97, 110, 32, 101, 120, 112, 111, 115, 101, 32, 108, 97, 121, 111, 117, 116, 32, 98, 117, 103, 115, 32, 105, 110, 32, 115, 111, 109, 101, 32, 98, 114, 111, 119, 115, 101, 114, 115, 46, 32, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 98, 101, 103, 105, 110, 32, 101, 97, 99, 104, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 111, 110, 32, 97, 32, 110, 101, 119, 32, 108, 105, 110, 101, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 110, 117, 109, 98, 101, 114, 32, 111, 102, 32, 115, 112, 97, 99, 101, 115, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 116, 111, 32, 105, 110, 100, 101, 110, 116, 32, 99, 111, 110, 116, 101, 110, 116, 44, 32, 119, 104, 101, 110, 32, 105, 110, 100, 101, 110, 116, 97, 116, 105, 111, 110, 32, 105, 115, 32, 101, 110, 97, 98, 108, 101, 100, 46, 32, 0, 0, 0, 20, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 104, 111, 119, 32, 84, 105, 100, 121, 32, 100, 101, 97, 108, 115, 32, 119, 105, 116, 104, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 105, 116, 104, 105, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 46, 32, 73, 102, 32, 116, 104, 101, 32, 118, 97, 108, 117, 101, 32, 105, 115, 32, 34, 110, 111, 34, 32, 40, 116, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 41, 44, 32, 84, 105, 100, 121, 32, 34, 109, 117, 110, 103, 101, 115, 34, 32, 111, 114, 32, 34, 110, 111, 114, 109, 97, 108, 105, 122, 101, 115, 34, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 32, 98, 121, 32, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 97, 110, 121, 32, 110, 101, 119, 108, 105, 110, 101, 32, 111, 114, 32, 116, 97, 98, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 119, 105, 116, 104, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 44, 32, 97, 110, 100, 32, 102, 117, 114, 116, 104, 101, 114, 32, 98, 121, 32, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 97, 110, 121, 32, 115, 101, 113, 117, 101, 110, 99, 101, 115, 32, 111, 102, 32, 109, 117, 108, 116, 105, 112, 108, 101, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 105, 116, 104, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 115, 112, 97, 99, 101, 46, 32, 84, 111, 32, 102, 111, 114, 99, 101, 32, 116, 105, 100, 121, 32, 116, 111, 32, 112, 114, 101, 115, 101, 114, 118, 101, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 44, 32, 108, 105, 116, 101, 114, 97, 108, 32, 118, 97, 108, 117, 101, 115, 32, 111, 102, 32, 97, 108, 108, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 44, 32, 97, 110, 100, 32, 101, 110, 115, 117, 114, 101, 32, 116, 104, 97, 116, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 105, 116, 104, 105, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 32, 97, 114, 101, 32, 112, 97, 115, 115, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 117, 110, 99, 104, 97, 110, 103, 101, 100, 44, 32, 115, 101, 116, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 111, 32, 34, 121, 101, 115, 34, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 101, 100, 32, 118, 101, 114, 115, 105, 111, 110, 32, 111, 102, 32, 116, 104, 101, 32, 109, 97, 114, 107, 117, 112, 46, 32, 78, 111, 116, 101, 32, 116, 104, 97, 116, 32, 84, 105, 100, 121, 32, 119, 111, 110, 39, 116, 32, 103, 101, 110, 101, 114, 97, 116, 101, 32, 97, 32, 112, 114, 101, 116, 116, 121, 32, 112, 114, 105, 110, 116, 101, 100, 32, 118, 101, 114, 115, 105, 111, 110, 32, 105, 102, 32, 105, 116, 32, 102, 105, 110, 100, 115, 32, 115, 105, 103, 110, 105, 102, 105, 99, 97, 110, 116, 32, 101, 114, 114, 111, 114, 115, 32, 40, 115, 101, 101, 32, 102, 111, 114, 99, 101, 45, 111, 117, 116, 112, 117, 116, 41, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 97, 102, 116, 101, 114, 32, 115, 111, 109, 101, 32, 85, 110, 105, 99, 111, 100, 101, 32, 111, 114, 32, 67, 104, 105, 110, 101, 115, 101, 32, 112, 117, 110, 99, 116, 117, 97, 116, 105, 111, 110, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 46, 32, 0, 0, 0, 67, 117, 114, 114, 101, 110, 116, 108, 121, 32, 110, 111, 116, 32, 117, 115, 101, 100, 46, 32, 84, 105, 100, 121, 32, 67, 108, 97, 115, 115, 105, 99, 32, 111, 110, 108, 121, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 110, 117, 109, 98, 101, 114, 32, 111, 102, 32, 99, 111, 108, 117, 109, 110, 115, 32, 116, 104, 97, 116, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 98, 101, 116, 119, 101, 101, 110, 32, 115, 117, 99, 99, 101, 115, 115, 105, 118, 101, 32, 116, 97, 98, 32, 115, 116, 111, 112, 115, 46, 32, 73, 116, 32, 105, 115, 32, 117, 115, 101, 100, 32, 116, 111, 32, 109, 97, 112, 32, 116, 97, 98, 115, 32, 116, 111, 32, 115, 112, 97, 99, 101, 115, 32, 119, 104, 101, 110, 32, 114, 101, 97, 100, 105, 110, 103, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 46, 32, 84, 105, 100, 121, 32, 110, 101, 118, 101, 114, 32, 111, 117, 116, 112, 117, 116, 115, 32, 116, 97, 98, 115, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 97, 100, 100, 32, 115, 111, 109, 101, 32, 101, 109, 112, 116, 121, 32, 108, 105, 110, 101, 115, 32, 102, 111, 114, 32, 114, 101, 97, 100, 97, 98, 105, 108, 105, 116, 121, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 114, 105, 103, 104, 116, 32, 109, 97, 114, 103, 105, 110, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 112, 105, 110, 103, 46, 32, 84, 105, 100, 121, 32, 116, 114, 105, 101, 115, 32, 116, 111, 32, 119, 114, 97, 112, 32, 108, 105, 110, 101, 115, 32, 115, 111, 32, 116, 104, 97, 116, 32, 116, 104, 101, 121, 32, 100, 111, 32, 110, 111, 116, 32, 101, 120, 99, 101, 101, 100, 32, 116, 104, 105, 115, 32, 108, 101, 110, 103, 116, 104, 46, 32, 83, 101, 116, 32, 119, 114, 97, 112, 32, 116, 111, 32, 122, 101, 114, 111, 32, 105, 102, 32, 121, 111, 117, 32, 119, 97, 110, 116, 32, 116, 111, 32, 100, 105, 115, 97, 98, 108, 101, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 112, 105, 110, 103, 46, 32, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 116, 101, 120, 116, 32, 99, 111, 110, 116, 97, 105, 110, 101, 100, 32, 119, 105, 116, 104, 105, 110, 32, 65, 83, 80, 32, 112, 115, 101, 117, 100, 111, 32, 101, 108, 101, 109, 101, 110, 116, 115, 44, 32, 119, 104, 105, 99, 104, 32, 108, 111, 111, 107, 32, 108, 105, 107, 101, 58, 32, 38, 108, 116, 59, 37, 32, 46, 46, 46, 32, 37, 38, 103, 116, 59, 46, 32, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 45, 119, 114, 97, 112, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 44, 32, 102, 111, 114, 32, 101, 97, 115, 105, 101, 114, 32, 101, 100, 105, 116, 105, 110, 103, 46, 32, 76, 105, 110, 101, 32, 119, 114, 97, 112, 112, 105, 110, 103, 32, 109, 101, 97, 110, 115, 32, 116, 104, 97, 116, 32, 105, 102, 32, 116, 104, 101, 32, 118, 97, 108, 117, 101, 32, 111, 102, 32, 97, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 99, 97, 117, 115, 101, 115, 32, 97, 32, 108, 105, 110, 101, 32, 116, 111, 32, 101, 120, 99, 101, 101, 100, 32, 116, 104, 101, 32, 119, 105, 100, 116, 104, 32, 115, 112, 101, 99, 105, 102, 105, 101, 100, 32, 98, 121, 32, 116, 104, 101, 32, 34, 119, 114, 97, 112, 34, 32, 111, 112, 116, 105, 111, 110, 44, 32, 116, 105, 100, 121, 32, 119, 105, 108, 108, 32, 97, 100, 100, 32, 111, 110, 101, 32, 111, 114, 32, 109, 111, 114, 101, 32, 108, 105, 110, 101, 32, 98, 114, 101, 97, 107, 115, 32, 116, 111, 32, 116, 104, 101, 32, 118, 97, 108, 117, 101, 44, 32, 99, 97, 117, 115, 105, 110, 103, 32, 105, 116, 32, 116, 111, 32, 119, 114, 97, 112, 112, 101, 100, 32, 105, 110, 116, 111, 32, 109, 117, 108, 116, 105, 112, 108, 101, 32, 108, 105, 110, 101, 115, 46, 32, 78, 111, 116, 101, 32, 116, 104, 97, 116, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 110, 32, 98, 101, 32, 115, 101, 116, 32, 105, 110, 100, 101, 112, 101, 110, 100, 101, 110, 116, 108, 121, 32, 111, 102, 32, 119, 114, 97, 112, 45, 115, 99, 114, 105, 112, 116, 45, 108, 105, 116, 101, 114, 97, 108, 115, 46, 32, 65, 108, 115, 111, 32, 110, 111, 116, 101, 32, 116, 104, 97, 116, 32, 98, 121, 32, 100, 101, 102, 97, 117, 108, 116, 44, 32, 84, 105, 100, 121, 32, 34, 109, 117, 110, 103, 101, 115, 34, 32, 111, 114, 32, 34, 110, 111, 114, 109, 97, 108, 105, 122, 101, 115, 34, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 32, 98, 121, 32, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 97, 110, 121, 32, 110, 101, 119, 108, 105, 110, 101, 32, 111, 114, 32, 116, 97, 98, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 119, 105, 116, 104, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 44, 32, 97, 110, 100, 32, 102, 117, 114, 116, 104, 101, 114, 32, 98, 121, 32, 114, 101, 112, 108, 97, 99, 105, 110, 103, 32, 97, 110, 121, 32, 115, 101, 113, 117, 101, 110, 99, 101, 115, 32, 111, 102, 32, 109, 117, 108, 116, 105, 112, 108, 101, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 105, 116, 104, 32, 97, 32, 115, 105, 110, 103, 108, 101, 32, 115, 112, 97, 99, 101, 46, 32, 84, 111, 32, 102, 111, 114, 99, 101, 32, 84, 105, 100, 121, 32, 116, 111, 32, 112, 114, 101, 115, 101, 114, 118, 101, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 44, 32, 108, 105, 116, 101, 114, 97, 108, 32, 118, 97, 108, 117, 101, 115, 32, 111, 102, 32, 97, 108, 108, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 44, 32, 97, 110, 100, 32, 101, 110, 115, 117, 114, 101, 32, 116, 104, 97, 116, 32, 119, 104, 105, 116, 101, 115, 112, 97, 99, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 105, 116, 104, 105, 110, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 118, 97, 108, 117, 101, 115, 32, 97, 114, 101, 32, 112, 97, 115, 115, 101, 100, 32, 116, 104, 114, 111, 117, 103, 104, 32, 117, 110, 99, 104, 97, 110, 103, 101, 100, 44, 32, 115, 101, 116, 32, 116, 104, 101, 32, 108, 105, 116, 101, 114, 97, 108, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 32, 111, 112, 116, 105, 111, 110, 32, 116, 111, 32, 34, 121, 101, 115, 34, 46, 32, 0, 47, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 116, 101, 120, 116, 32, 99, 111, 110, 116, 97, 105, 110, 101, 100, 32, 119, 105, 116, 104, 105, 110, 32, 74, 83, 84, 69, 32, 112, 115, 101, 117, 100, 111, 32, 101, 108, 101, 109, 101, 110, 116, 115, 44, 32, 119, 104, 105, 99, 104, 32, 108, 111, 111, 107, 32, 108, 105, 107, 101, 58, 32, 38, 108, 116, 59, 35, 32, 46, 46, 46, 32, 35, 38, 103, 116, 59, 46, 32, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 116, 101, 120, 116, 32, 99, 111, 110, 116, 97, 105, 110, 101, 100, 32, 119, 105, 116, 104, 105, 110, 32, 80, 72, 80, 32, 112, 115, 101, 117, 100, 111, 32, 101, 108, 101, 109, 101, 110, 116, 115, 44, 32, 119, 104, 105, 99, 104, 32, 108, 111, 111, 107, 32, 108, 105, 107, 101, 58, 32, 38, 108, 116, 59, 63, 112, 104, 112, 32, 46, 46, 46, 32, 63, 38, 103, 116, 59, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 115, 116, 114, 105, 110, 103, 32, 108, 105, 116, 101, 114, 97, 108, 115, 32, 116, 104, 97, 116, 32, 97, 112, 112, 101, 97, 114, 32, 105, 110, 32, 115, 99, 114, 105, 112, 116, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 46, 32, 84, 105, 100, 121, 32, 119, 114, 97, 112, 115, 32, 108, 111, 110, 103, 32, 115, 99, 114, 105, 112, 116, 32, 115, 116, 114, 105, 110, 103, 32, 108, 105, 116, 101, 114, 97, 108, 115, 32, 98, 121, 32, 105, 110, 115, 101, 114, 116, 105, 110, 103, 32, 97, 32, 98, 97, 99, 107, 115, 108, 97, 115, 104, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 98, 101, 102, 111, 114, 101, 32, 116, 104, 101, 32, 108, 105, 110, 101, 32, 98, 114, 101, 97, 107, 46, 32, 0, 0, 0, 0, 0, 0, 46, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 108, 105, 110, 101, 32, 119, 114, 97, 112, 32, 116, 101, 120, 116, 32, 99, 111, 110, 116, 97, 105, 110, 101, 100, 32, 119, 105, 116, 104, 105, 110, 32, 38, 108, 116, 59, 33, 91, 32, 46, 46, 46, 32, 93, 38, 103, 116, 59, 32, 115, 101, 99, 116, 105, 111, 110, 32, 116, 97, 103, 115, 46, 32, 0, 0, 0, 0, 67, 97, 110, 32, 98, 101, 32, 117, 115, 101, 100, 32, 116, 111, 32, 109, 111, 100, 105, 102, 121, 32, 98, 101, 104, 97, 118, 105, 111, 114, 32, 111, 102, 32, 45, 99, 32, 40, 45, 45, 99, 108, 101, 97, 110, 32, 121, 101, 115, 41, 32, 111, 112, 116, 105, 111, 110, 46, 32, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 121, 101, 115, 34, 32, 119, 104, 101, 110, 32, 117, 115, 105, 110, 103, 32, 45, 99, 44, 32, 38, 97, 109, 112, 59, 101, 109, 100, 97, 115, 104, 59, 44, 32, 38, 97, 109, 112, 59, 114, 100, 113, 117, 111, 59, 44, 32, 97, 110, 100, 32, 111, 116, 104, 101, 114, 32, 110, 97, 109, 101, 100, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 97, 114, 101, 32, 100, 111, 119, 110, 103, 114, 97, 100, 101, 100, 32, 116, 111, 32, 116, 104, 101, 105, 114, 32, 99, 108, 111, 115, 101, 115, 116, 32, 97, 115, 99, 105, 105, 32, 101, 113, 117, 105, 118, 97, 108, 101, 110, 116, 115, 46, 32, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 98, 111, 116, 104, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 46, 32, 70, 111, 114, 32, 97, 115, 99, 105, 105, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 97, 99, 99, 101, 112, 116, 32, 76, 97, 116, 105, 110, 45, 49, 32, 40, 73, 83, 79, 45, 56, 56, 53, 57, 45, 49, 41, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 118, 97, 108, 117, 101, 115, 44, 32, 98, 117, 116, 32, 119, 105, 108, 108, 32, 117, 115, 101, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 102, 111, 114, 32, 97, 108, 108, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 104, 111, 115, 101, 32, 118, 97, 108, 117, 101, 32, 38, 103, 116, 59, 32, 49, 50, 55, 46, 32, 70, 111, 114, 32, 114, 97, 119, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 111, 117, 116, 112, 117, 116, 32, 118, 97, 108, 117, 101, 115, 32, 97, 98, 111, 118, 101, 32, 49, 50, 55, 32, 119, 105, 116, 104, 111, 117, 116, 32, 116, 114, 97, 110, 115, 108, 97, 116, 105, 110, 103, 32, 116, 104, 101, 109, 32, 105, 110, 116, 111, 32, 101, 110, 116, 105, 116, 105, 101, 115, 46, 32, 70, 111, 114, 32, 108, 97, 116, 105, 110, 49, 44, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 97, 98, 111, 118, 101, 32, 50, 53, 53, 32, 119, 105, 108, 108, 32, 98, 101, 32, 119, 114, 105, 116, 116, 101, 110, 32, 97, 115, 32, 101, 110, 116, 105, 116, 105, 101, 115, 46, 32, 70, 111, 114, 32, 117, 116, 102, 56, 44, 32, 84, 105, 100, 121, 32, 97, 115, 115, 117, 109, 101, 115, 32, 116, 104, 97, 116, 32, 98, 111, 116, 104, 32, 105, 110, 112, 117, 116, 32, 97, 110, 100, 32, 111, 117, 116, 112, 117, 116, 32, 105, 115, 32, 101, 110, 99, 111, 100, 101, 100, 32, 97, 115, 32, 85, 84, 70, 45, 56, 46, 32, 89, 111, 117, 32, 99, 97, 110, 32, 117, 115, 101, 32, 105, 115, 111, 50, 48, 50, 50, 32, 102, 111, 114, 32, 102, 105, 108, 101, 115, 32, 101, 110, 99, 111, 100, 101, 100, 32, 117, 115, 105, 110, 103, 32, 116, 104, 101, 32, 73, 83, 79, 45, 50, 48, 50, 50, 32, 102, 97, 109, 105, 108, 121, 32, 111, 102, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 32, 101, 46, 103, 46, 32, 73, 83, 79, 45, 50, 48, 50, 50, 45, 74, 80, 46, 32, 70, 111, 114, 32, 109, 97, 99, 32, 97, 110, 100, 32, 119, 105, 110, 49, 50, 53, 50, 44, 32, 84, 105, 100, 121, 32, 119, 105, 108, 108, 32, 97, 99, 99, 101, 112, 116, 32, 118, 101, 110, 100, 111, 114, 32, 115, 112, 101, 99, 105, 102, 105, 99, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 118, 97, 108, 117, 101, 115, 44, 32, 98, 117, 116, 32, 119, 105, 108, 108, 32, 117, 115, 101, 32, 101, 110, 116, 105, 116, 105, 101, 115, 32, 102, 111, 114, 32, 97, 108, 108, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 119, 104, 111, 115, 101, 32, 118, 97, 108, 117, 101, 32, 38, 103, 116, 59, 32, 49, 50, 55, 46, 32, 70, 111, 114, 32, 117, 110, 115, 117, 112, 112, 111, 114, 116, 101, 100, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 44, 32, 117, 115, 101, 32, 97, 110, 32, 101, 120, 116, 101, 114, 110, 97, 108, 32, 117, 116, 105, 108, 105, 116, 121, 32, 116, 111, 32, 99, 111, 110, 118, 101, 114, 116, 32, 116, 111, 32, 97, 110, 100, 32, 102, 114, 111, 109, 32, 85, 84, 70, 45, 56, 46, 32, 0, 5, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 46, 32, 83, 101, 101, 32, 99, 104, 97, 114, 45, 101, 110, 99, 111, 100, 105, 110, 103, 32, 102, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 46, 32, 0, 4, 0, 0, 0, 0, 0, 0, 0, 67, 117, 114, 114, 101, 110, 116, 108, 121, 32, 110, 111, 116, 32, 117, 115, 101, 100, 44, 32, 98, 117, 116, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 108, 97, 110, 103, 117, 97, 103, 101, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 40, 102, 111, 114, 32, 105, 110, 115, 116, 97, 110, 99, 101, 32, 34, 101, 110, 34, 41, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 119, 114, 105, 116, 101, 32, 97, 32, 85, 110, 105, 99, 111, 100, 101, 32, 66, 121, 116, 101, 32, 79, 114, 100, 101, 114, 32, 77, 97, 114, 107, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 40, 66, 79, 77, 59, 32, 97, 108, 115, 111, 32, 107, 110, 111, 119, 110, 32, 97, 115, 32, 90, 101, 114, 111, 32, 87, 105, 100, 116, 104, 32, 78, 111, 45, 66, 114, 101, 97, 107, 32, 83, 112, 97, 99, 101, 59, 32, 104, 97, 115, 32, 118, 97, 108, 117, 101, 32, 111, 102, 32, 85, 43, 70, 69, 70, 70, 41, 32, 116, 111, 32, 116, 104, 101, 32, 98, 101, 103, 105, 110, 110, 105, 110, 103, 32, 111, 102, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 59, 32, 111, 110, 108, 121, 32, 102, 111, 114, 32, 85, 84, 70, 45, 56, 32, 97, 110, 100, 32, 85, 84, 70, 45, 49, 54, 32, 111, 117, 116, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 97, 117, 116, 111, 34, 44, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 97, 117, 115, 101, 115, 32, 84, 105, 100, 121, 32, 116, 111, 32, 119, 114, 105, 116, 101, 32, 97, 32, 66, 79, 77, 32, 116, 111, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 111, 110, 108, 121, 32, 105, 102, 32, 97, 32, 66, 79, 77, 32, 119, 97, 115, 32, 112, 114, 101, 115, 101, 110, 116, 32, 97, 116, 32, 116, 104, 101, 32, 98, 101, 103, 105, 110, 110, 105, 110, 103, 32, 111, 102, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 46, 32, 65, 32, 66, 79, 77, 32, 105, 115, 32, 97, 108, 119, 97, 121, 115, 32, 119, 114, 105, 116, 116, 101, 110, 32, 102, 111, 114, 32, 88, 77, 76, 47, 88, 72, 84, 77, 76, 32, 111, 117, 116, 112, 117, 116, 32, 117, 115, 105, 110, 103, 32, 85, 84, 70, 45, 49, 54, 32, 111, 117, 116, 112, 117, 116, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 32, 101, 110, 99, 111, 100, 105, 110, 103, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 46, 32, 83, 101, 101, 32, 99, 104, 97, 114, 45, 101, 110, 99, 111, 100, 105, 110, 103, 32, 102, 111, 114, 32, 109, 111, 114, 101, 32, 105, 110, 102, 111, 46, 32, 77, 97, 121, 32, 111, 110, 108, 121, 32, 98, 101, 32, 100, 105, 102, 102, 101, 114, 101, 110, 116, 32, 102, 114, 111, 109, 32, 105, 110, 112, 117, 116, 45, 101, 110, 99, 111, 100, 105, 110, 103, 32, 102, 111, 114, 32, 76, 97, 116, 105, 110, 32, 101, 110, 99, 111, 100, 105, 110, 103, 115, 32, 40, 97, 115, 99, 105, 105, 44, 32, 108, 97, 116, 105, 110, 48, 44, 32, 108, 97, 116, 105, 110, 49, 44, 32, 109, 97, 99, 44, 32, 119, 105, 110, 49, 50, 53, 50, 44, 32, 105, 98, 109, 56, 53, 56, 41, 46, 32, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 84, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 105, 115, 32, 97, 112, 112, 114, 111, 112, 114, 105, 97, 116, 101, 32, 116, 111, 32, 116, 104, 101, 32, 99, 117, 114, 114, 101, 110, 116, 32, 112, 108, 97, 116, 102, 111, 114, 109, 58, 32, 67, 82, 76, 70, 32, 111, 110, 32, 80, 67, 45, 68, 79, 83, 44, 32, 77, 83, 45, 87, 105, 110, 100, 111, 119, 115, 32, 97, 110, 100, 32, 79, 83, 47, 50, 44, 32, 67, 82, 32, 111, 110, 32, 67, 108, 97, 115, 115, 105, 99, 32, 77, 97, 99, 32, 79, 83, 44, 32, 97, 110, 100, 32, 76, 70, 32, 101, 118, 101, 114, 121, 119, 104, 101, 114, 101, 32, 101, 108, 115, 101, 32, 40, 85, 110, 105, 120, 32, 97, 110, 100, 32, 76, 105, 110, 117, 120, 41, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 101, 114, 114, 111, 114, 32, 102, 105, 108, 101, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 46, 32, 78, 111, 114, 109, 97, 108, 108, 121, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 32, 97, 114, 101, 32, 111, 117, 116, 112, 117, 116, 32, 116, 111, 32, 34, 115, 116, 100, 101, 114, 114, 34, 46, 32, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 114, 101, 112, 108, 97, 99, 101, 32, 98, 97, 99, 107, 115, 108, 97, 115, 104, 32, 99, 104, 97, 114, 97, 99, 116, 101, 114, 115, 32, 34, 60, 99, 111, 100, 101, 62, 92, 60, 47, 99, 111, 100, 101, 62, 34, 32, 105, 110, 32, 85, 82, 76, 115, 32, 98, 121, 32, 102, 111, 114, 119, 97, 114, 100, 32, 115, 108, 97, 115, 104, 101, 115, 32, 34, 60, 99, 111, 100, 101, 62, 47, 60, 47, 99, 111, 100, 101, 62, 34, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 112, 114, 111, 100, 117, 99, 101, 32, 111, 117, 116, 112, 117, 116, 32, 101, 118, 101, 110, 32, 105, 102, 32, 101, 114, 114, 111, 114, 115, 32, 97, 114, 101, 32, 101, 110, 99, 111, 117, 110, 116, 101, 114, 101, 100, 46, 32, 85, 115, 101, 32, 116, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 119, 105, 116, 104, 32, 99, 97, 114, 101, 32, 45, 32, 105, 102, 32, 84, 105, 100, 121, 32, 114, 101, 112, 111, 114, 116, 115, 32, 97, 110, 32, 101, 114, 114, 111, 114, 44, 32, 116, 104, 105, 115, 32, 109, 101, 97, 110, 115, 32, 84, 105, 100, 121, 32, 119, 97, 115, 32, 110, 111, 116, 32, 97, 98, 108, 101, 32, 116, 111, 44, 32, 111, 114, 32, 105, 115, 32, 110, 111, 116, 32, 115, 117, 114, 101, 32, 104, 111, 119, 32, 116, 111, 44, 32, 102, 105, 120, 32, 116, 104, 101, 32, 101, 114, 114, 111, 114, 44, 32, 115, 111, 32, 116, 104, 101, 32, 114, 101, 115, 117, 108, 116, 105, 110, 103, 32, 111, 117, 116, 112, 117, 116, 32, 109, 97, 121, 32, 110, 111, 116, 32, 114, 101, 102, 108, 101, 99, 116, 32, 121, 111, 117, 114, 32, 105, 110, 116, 101, 110, 116, 105, 111, 110, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 99, 104, 97, 110, 103, 101, 32, 116, 104, 101, 32, 102, 111, 114, 109, 97, 116, 32, 102, 111, 114, 32, 114, 101, 112, 111, 114, 116, 105, 110, 103, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 32, 116, 111, 32, 97, 32, 102, 111, 114, 109, 97, 116, 32, 116, 104, 97, 116, 32, 105, 115, 32, 109, 111, 114, 101, 32, 101, 97, 115, 105, 108, 121, 32, 112, 97, 114, 115, 101, 100, 32, 98, 121, 32, 71, 78, 85, 32, 69, 109, 97, 99, 115, 46, 32, 0, 0, 85, 115, 101, 100, 32, 105, 110, 116, 101, 114, 110, 97, 108, 108, 121, 46, 32, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 107, 101, 101, 112, 32, 116, 104, 101, 32, 111, 114, 105, 103, 105, 110, 97, 108, 32, 109, 111, 100, 105, 102, 105, 99, 97, 116, 105, 111, 110, 32, 116, 105, 109, 101, 32, 111, 102, 32, 102, 105, 108, 101, 115, 32, 116, 104, 97, 116, 32, 84, 105, 100, 121, 32, 109, 111, 100, 105, 102, 105, 101, 115, 32, 105, 110, 32, 112, 108, 97, 99, 101, 46, 32, 84, 104, 101, 32, 100, 101, 102, 97, 117, 108, 116, 32, 105, 115, 32, 110, 111, 46, 32, 83, 101, 116, 116, 105, 110, 103, 32, 116, 104, 101, 32, 111, 112, 116, 105, 111, 110, 32, 116, 111, 32, 121, 101, 115, 32, 97, 108, 108, 111, 119, 115, 32, 121, 111, 117, 32, 116, 111, 32, 116, 105, 100, 121, 32, 102, 105, 108, 101, 115, 32, 119, 105, 116, 104, 111, 117, 116, 32, 99, 97, 117, 115, 105, 110, 103, 32, 116, 104, 101, 115, 101, 32, 102, 105, 108, 101, 115, 32, 116, 111, 32, 98, 101, 32, 117, 112, 108, 111, 97, 100, 101, 100, 32, 116, 111, 32, 97, 32, 119, 101, 98, 32, 115, 101, 114, 118, 101, 114, 32, 119, 104, 101, 110, 32, 117, 115, 105, 110, 103, 32, 97, 32, 116, 111, 111, 108, 32, 115, 117, 99, 104, 32, 97, 115, 32, 83, 105, 116, 101, 67, 111, 112, 121, 46, 32, 78, 111, 116, 101, 32, 116, 104, 105, 115, 32, 102, 101, 97, 116, 117, 114, 101, 32, 105, 115, 32, 110, 111, 116, 32, 115, 117, 112, 112, 111, 114, 116, 101, 100, 32, 111, 110, 32, 115, 111, 109, 101, 32, 112, 108, 97, 116, 102, 111, 114, 109, 115, 46, 32, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 116, 104, 101, 32, 111, 117, 116, 112, 117, 116, 32, 102, 105, 108, 101, 32, 84, 105, 100, 121, 32, 117, 115, 101, 115, 32, 102, 111, 114, 32, 109, 97, 114, 107, 117, 112, 46, 32, 78, 111, 114, 109, 97, 108, 108, 121, 32, 109, 97, 114, 107, 117, 112, 32, 105, 115, 32, 119, 114, 105, 116, 116, 101, 110, 32, 116, 111, 32, 34, 115, 116, 100, 111, 117, 116, 34, 46, 32, 0, 0, 0, 0, 13, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 111, 117, 116, 112, 117, 116, 32, 116, 104, 101, 32, 115, 117, 109, 109, 97, 114, 121, 32, 111, 102, 32, 116, 104, 101, 32, 110, 117, 109, 98, 101, 114, 115, 32, 111, 102, 32, 101, 114, 114, 111, 114, 115, 32, 97, 110, 100, 32, 119, 97, 114, 110, 105, 110, 103, 115, 44, 32, 111, 114, 32, 116, 104, 101, 32, 119, 101, 108, 99, 111, 109, 101, 32, 111, 114, 32, 105, 110, 102, 111, 114, 109, 97, 116, 105, 111, 110, 97, 108, 32, 109, 101, 115, 115, 97, 103, 101, 115, 46, 32, 0, 0, 0, 0, 0, 0, 0, 67, 117, 114, 114, 101, 110, 116, 108, 121, 32, 110, 111, 116, 32, 117, 115, 101, 100, 46, 32, 32, 84, 105, 100, 121, 32, 67, 108, 97, 115, 115, 105, 99, 32, 111, 110, 108, 121, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 97, 100, 100, 32, 97, 32, 109, 101, 116, 97, 32, 101, 108, 101, 109, 101, 110, 116, 32, 116, 111, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 32, 104, 101, 97, 100, 32, 116, 111, 32, 105, 110, 100, 105, 99, 97, 116, 101, 32, 116, 104, 97, 116, 32, 116, 104, 101, 32, 100, 111, 99, 117, 109, 101, 110, 116, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 116, 105, 100, 105, 101, 100, 46, 32, 84, 105, 100, 121, 32, 119, 111, 110, 39, 116, 32, 97, 100, 100, 32, 97, 32, 109, 101, 116, 97, 32, 101, 108, 101, 109, 101, 110, 116, 32, 105, 102, 32, 111, 110, 101, 32, 105, 115, 32, 97, 108, 114, 101, 97, 100, 121, 32, 112, 114, 101, 115, 101, 110, 116, 46, 32, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 119, 114, 105, 116, 101, 32, 98, 97, 99, 107, 32, 116, 104, 101, 32, 116, 105, 100, 105, 101, 100, 32, 109, 97, 114, 107, 117, 112, 32, 116, 111, 32, 116, 104, 101, 32, 115, 97, 109, 101, 32, 102, 105, 108, 101, 32, 105, 116, 32, 114, 101, 97, 100, 32, 102, 114, 111, 109, 46, 32, 89, 111, 117, 32, 97, 114, 101, 32, 97, 100, 118, 105, 115, 101, 100, 32, 116, 111, 32, 107, 101, 101, 112, 32, 99, 111, 112, 105, 101, 115, 32, 111, 102, 32, 105, 109, 112, 111, 114, 116, 97, 110, 116, 32, 102, 105, 108, 101, 115, 32, 98, 101, 102, 111, 114, 101, 32, 116, 105, 100, 121, 105, 110, 103, 32, 116, 104, 101, 109, 44, 32, 97, 115, 32, 111, 110, 32, 114, 97, 114, 101, 32, 111, 99, 99, 97, 115, 105, 111, 110, 115, 32, 116, 104, 101, 32, 114, 101, 115, 117, 108, 116, 32, 109, 97, 121, 32, 110, 111, 116, 32, 98, 101, 32, 119, 104, 97, 116, 32, 121, 111, 117, 32, 101, 120, 112, 101, 99, 116, 46, 32, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 100, 101, 99, 111, 114, 97, 116, 101, 32, 105, 110, 102, 101, 114, 114, 101, 100, 32, 85, 76, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 119, 105, 116, 104, 32, 115, 111, 109, 101, 32, 67, 83, 83, 32, 109, 97, 114, 107, 117, 112, 32, 116, 111, 32, 97, 118, 111, 105, 100, 32, 105, 110, 100, 101, 110, 116, 97, 116, 105, 111, 110, 32, 116, 111, 32, 116, 104, 101, 32, 114, 105, 103, 104, 116, 46, 32, 0, 0, 0, 0, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 115, 112, 101, 99, 105, 102, 105, 101, 115, 32, 105, 102, 32, 84, 105, 100, 121, 32, 115, 104, 111, 117, 108, 100, 32, 112, 114, 101, 115, 101, 114, 118, 101, 32, 116, 104, 101, 32, 119, 101, 108, 108, 45, 102, 111, 114, 109, 101, 100, 32, 101, 110, 116, 105, 116, 105, 116, 101, 115, 32, 97, 115, 32, 102, 111, 117, 110, 100, 32, 105, 110, 32, 116, 104, 101, 32, 105, 110, 112, 117, 116, 46, 32, 0, 84, 104, 105, 115, 32, 111, 112, 116, 105, 111, 110, 32, 99, 111, 110, 116, 114, 111, 108, 115, 32, 116, 104, 101, 32, 100, 101, 108, 101, 116, 105, 111, 110, 32, 111, 114, 32, 97, 100, 100, 105, 116, 105, 111, 110, 32, 111, 102, 32, 116, 104, 101, 32, 110, 97, 109, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 105, 110, 32, 101, 108, 101, 109, 101, 110, 116, 115, 32, 119, 104, 101, 114, 101, 32, 105, 116, 32, 99, 97, 110, 32, 115, 101, 114, 118, 101, 32, 97, 115, 32, 97, 110, 99, 104, 111, 114, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 121, 101, 115, 34, 44, 32, 97, 32, 110, 97, 109, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 44, 32, 105, 102, 32, 110, 111, 116, 32, 97, 108, 114, 101, 97, 100, 121, 32, 101, 120, 105, 115, 116, 105, 110, 103, 44, 32, 105, 115, 32, 97, 100, 100, 101, 100, 32, 97, 108, 111, 110, 103, 32, 97, 110, 32, 101, 120, 105, 115, 116, 105, 110, 103, 32, 105, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 105, 102, 32, 116, 104, 101, 32, 68, 84, 68, 32, 97, 108, 108, 111, 119, 115, 32, 105, 116, 46, 32, 73, 102, 32, 115, 101, 116, 32, 116, 111, 32, 34, 110, 111, 34, 44, 32, 97, 110, 121, 32, 101, 120, 105, 115, 116, 105, 110, 103, 32, 110, 97, 109, 101, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 105, 115, 32, 114, 101, 109, 111, 118, 101, 100, 32, 105, 102, 32, 97, 110, 32, 105, 100, 32, 97, 116, 116, 114, 105, 98, 117, 116, 101, 32, 101, 120, 105, 115, 116, 115, 32, 111, 114, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 97, 100, 100, 101, 100, 46, 32, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 64, 28, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 80, 28, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 2, 0, 0, 0, 96, 28, 1, 0, 1, 0, 0, 0, 68, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 2, 0, 0, 0, 104, 28, 1, 0, 1, 0, 0, 0, 8, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 3, 0, 0, 0, 120, 28, 1, 0, 1, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 136, 28, 1, 0, 0, 0, 0, 0, 5, 0, 0, 0, 3, 0, 0, 0, 200, 28, 1, 0, 1, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 136, 28, 1, 0, 0, 0, 0, 0, 6, 0, 0, 0, 3, 0, 0, 0, 216, 28, 1, 0, 1, 0, 0, 0, 4, 0, 0, 0, 2, 0, 0, 0, 136, 28, 1, 0, 0, 0, 0, 0, 7, 0, 0, 0, 3, 0, 0, 0, 232, 28, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 240, 28, 1, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 29, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 16, 29, 1, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 48, 29, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 16, 29, 1, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 56, 29, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 5, 0, 0, 0, 80, 29, 1, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 96, 29, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 4, 0, 0, 0, 112, 29, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 4, 0, 0, 0, 128, 29, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 4, 0, 0, 0, 144, 29, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 4, 0, 0, 0, 160, 29, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 16, 0, 0, 0, 2, 0, 0, 0, 192, 29, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 17, 0, 0, 0, 1, 0, 0, 0, 200, 29, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 18, 0, 0, 0, 1, 0, 0, 0, 216, 29, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 19, 0, 0, 0, 4, 0, 0, 0, 232, 29, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 20, 0, 0, 0, 2, 0, 0, 0, 240, 29, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 248, 29, 1, 0, 0, 0, 0, 0, 21, 0, 0, 0, 0, 0, 0, 0, 8, 30, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 22, 0, 0, 0, 0, 0, 0, 0, 24, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 48, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 24, 0, 0, 0, 0, 0, 0, 0, 64, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 0, 0, 0, 80, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 96, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 112, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 28, 0, 0, 0, 0, 0, 0, 0, 128, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 29, 0, 0, 0, 0, 0, 0, 0, 144, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 160, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 184, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 192, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 33, 0, 0, 0, 0, 0, 0, 0, 200, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 34, 0, 0, 0, 0, 0, 0, 0, 208, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 35, 0, 0, 0, 0, 0, 0, 0, 232, 30, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 36, 0, 0, 0, 0, 0, 0, 0, 8, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 37, 0, 0, 0, 0, 0, 0, 0, 24, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 38, 0, 0, 0, 0, 0, 0, 0, 48, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 39, 0, 0, 0, 0, 0, 0, 0, 72, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 40, 0, 0, 0, 2, 0, 0, 0, 96, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 41, 0, 0, 0, 2, 0, 0, 0, 112, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 42, 0, 0, 0, 0, 0, 0, 0, 120, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 43, 0, 0, 0, 0, 0, 0, 0, 144, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 44, 0, 0, 0, 0, 0, 0, 0, 160, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 45, 0, 0, 0, 0, 0, 0, 0, 176, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 46, 0, 0, 0, 2, 0, 0, 0, 192, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 47, 0, 0, 0, 2, 0, 0, 0, 208, 31, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 48, 0, 0, 0, 2, 0, 0, 0, 232, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 49, 0, 0, 0, 2, 0, 0, 0, 248, 31, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 50, 0, 0, 0, 2, 0, 0, 0, 8, 32, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 51, 0, 0, 0, 2, 0, 0, 0, 24, 32, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 52, 0, 0, 0, 0, 0, 0, 0, 40, 32, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 53, 0, 0, 0, 2, 0, 0, 0, 56, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 54, 0, 0, 0, 0, 0, 0, 0, 80, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 55, 0, 0, 0, 0, 0, 0, 0, 104, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 56, 0, 0, 0, 0, 0, 0, 0, 120, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 57, 0, 0, 0, 0, 0, 0, 0, 136, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 58, 0, 0, 0, 4, 0, 0, 0, 160, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 59, 0, 0, 0, 0, 0, 0, 0, 176, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 60, 0, 0, 0, 4, 0, 0, 0, 192, 32, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 61, 0, 0, 0, 4, 0, 0, 0, 208, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 62, 0, 0, 0, 4, 0, 0, 0, 224, 32, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 240, 32, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 8, 33, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 248, 29, 1, 0, 0, 0, 0, 0, 65, 0, 0, 0, 0, 0, 0, 0, 24, 33, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 66, 0, 0, 0, 0, 0, 0, 0, 32, 33, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 67, 0, 0, 0, 0, 0, 0, 0, 48, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 64, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 69, 0, 0, 0, 4, 0, 0, 0, 80, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 70, 0, 0, 0, 1, 0, 0, 0, 96, 33, 1, 0, 1, 0, 0, 0, 6, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 0, 0, 0, 3, 0, 0, 0, 112, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 72, 0, 0, 0, 0, 0, 0, 0, 128, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 73, 0, 0, 0, 0, 0, 0, 0, 144, 33, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 74, 0, 0, 0, 0, 0, 0, 0, 160, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 75, 0, 0, 0, 3, 0, 0, 0, 176, 33, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 0, 0, 0, 0, 0, 0, 0, 192, 33, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 77, 0, 0, 0, 3, 0, 0, 0, 200, 33, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 9, 0, 0, 0, 248, 29, 1, 0, 0, 0, 0, 0, 78, 0, 0, 0, 0, 0, 0, 0, 216, 33, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 79, 0, 0, 0, 0, 0, 0, 0, 232, 33, 1], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 61456);
allocate([10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 248, 33, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 0, 0, 0, 0, 0, 0, 0, 8, 34, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 0, 0, 0, 0, 0, 0, 32, 34, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 0, 0, 0, 0, 0, 0, 0, 48, 34, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 0, 0, 0, 1, 0, 0, 0, 64, 34, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 88, 34, 1, 0, 0, 0, 0, 0, 85, 0, 0, 0, 2, 0, 0, 0, 112, 34, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 86, 0, 0, 0, 2, 0, 0, 0, 128, 34, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 87, 0, 0, 0, 0, 0, 0, 0, 152, 34, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 88, 0, 0, 0, 0, 0, 0, 0, 168, 34, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 9, 0, 0, 0, 248, 29, 1, 0, 0, 0, 0, 0, 89, 0, 0, 0, 0, 0, 0, 0, 184, 34, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 90, 0, 0, 0, 0, 0, 0, 0, 208, 34, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 91, 0, 0, 0, 2, 0, 0, 0, 232, 34, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 248, 34, 1, 0, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 0, 0, 8, 35, 1, 0, 1, 0, 0, 0, 2, 0, 0, 0, 9, 0, 0, 0, 248, 29, 1, 0, 0, 0, 0, 0, 93, 0, 0, 0, 0, 0, 0, 0, 24, 35, 1, 0, 2, 0, 0, 0, 1, 0, 0, 0, 8, 0, 0, 0, 176, 29, 1, 0, 0, 0, 0, 0, 94, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 95, 100, 101, 102, 115, 91, 32, 111, 112, 116, 73, 100, 32, 93, 46, 116, 121, 112, 101, 32, 61, 61, 32, 84, 105, 100, 121, 73, 110, 116, 101, 103, 101, 114, 0, 0, 0, 0, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 99, 111, 110, 102, 105, 103, 46, 99, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 83, 101, 116, 79, 112, 116, 105, 111, 110, 73, 110, 116, 0, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 95, 100, 101, 102, 115, 91, 32, 111, 112, 116, 73, 100, 32, 93, 46, 116, 121, 112, 101, 32, 61, 61, 32, 84, 105, 100, 121, 66, 111, 111, 108, 101, 97, 110, 0, 0, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 83, 101, 116, 79, 112, 116, 105, 111, 110, 66, 111, 111, 108, 0, 0, 0, 0, 111, 112, 116, 73, 100, 32, 61, 61, 32, 111, 112, 116, 105, 111, 110, 45, 62, 105, 100, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 115, 101, 116, 79, 112, 116, 105, 111, 110, 84, 111, 68, 101, 102, 97, 117, 108, 116, 0, 0, 0, 0, 0, 105, 120, 86, 97, 108, 32, 61, 61, 32, 40, 117, 105, 110, 116, 41, 32, 111, 112, 116, 105, 111, 110, 45, 62, 105, 100, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 115, 101, 116, 67, 111, 110, 102, 105, 103, 84, 111, 68, 101, 102, 97, 117, 108, 116, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 84, 97, 107, 101, 67, 111, 110, 102, 105, 103, 83, 110, 97, 112, 115, 104, 111, 116, 0, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 82, 101, 115, 101, 116, 67, 111, 110, 102, 105, 103, 84, 111, 83, 110, 97, 112, 115, 104, 111, 116, 0, 0, 0, 0, 97, 115, 99, 105, 105, 0, 0, 0, 114, 0, 0, 0, 0, 0, 0, 0, 117, 110, 107, 110, 111, 119, 110, 0, 105, 116, 101, 114, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 103, 101, 116, 78, 101, 120, 116, 79, 112, 116, 105, 111, 110, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 33, 61, 78, 85, 76, 76, 32, 38, 38, 32, 105, 116, 101, 114, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 103, 101, 116, 78, 101, 120, 116, 79, 112, 116, 105, 111, 110, 80, 105, 99, 107, 0, 0, 0, 0, 0, 0, 0, 0, 121, 101, 115, 0, 0, 0, 0, 0, 110, 111, 0, 0, 0, 0, 0, 0, 111, 58, 112, 0, 0, 0, 0, 0, 72, 79, 77, 69, 0, 0, 0, 0, 78, 101, 101, 100, 82, 101, 112, 97, 114, 115, 101, 84, 97, 103, 68, 101, 99, 108, 115, 0, 0, 0, 0, 0, 111, 108, 100, 118, 97, 108, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 67, 111, 112, 121, 79, 112, 116, 105, 111, 110, 86, 97, 108, 117, 101, 0, 117, 110, 107, 110, 111, 119, 110, 33, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 100, 101, 110, 116, 45, 115, 112, 97, 99, 101, 115, 0, 0, 0, 119, 114, 97, 112, 0, 0, 0, 0, 116, 97, 98, 45, 115, 105, 122, 101, 0, 0, 0, 0, 0, 0, 0, 0, 99, 104, 97, 114, 45, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 0, 120, 36, 1, 0, 104, 27, 1, 0, 128, 36, 1, 0, 136, 36, 1, 0, 144, 36, 1, 0, 152, 36, 1, 0, 160, 36, 1, 0, 168, 36, 1, 0, 176, 36, 1, 0, 184, 36, 1, 0, 192, 36, 1, 0, 200, 36, 1, 0, 208, 36, 1, 0, 216, 36, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 112, 117, 116, 45, 101, 110, 99, 111, 100, 105, 110, 103, 0, 0, 111, 117, 116, 112, 117, 116, 45, 101, 110, 99, 111, 100, 105, 110, 103, 0, 110, 101, 119, 108, 105, 110, 101, 0, 72, 36, 1, 0, 80, 36, 1, 0, 88, 36, 1, 0, 0, 0, 0, 0, 100, 111, 99, 116, 121, 112, 101, 45, 109, 111, 100, 101, 0, 0, 0, 0, 16, 36, 1, 0, 24, 36, 1, 0, 232, 35, 1, 0, 32, 36, 1, 0, 48, 36, 1, 0, 64, 36, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 111, 99, 116, 121, 112, 101, 0, 114, 101, 112, 101, 97, 116, 101, 100, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 0, 0, 0, 0, 240, 35, 1, 0, 0, 36, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 108, 116, 45, 116, 101, 120, 116, 0, 0, 0, 0, 0, 0, 0, 0, 115, 108, 105, 100, 101, 45, 115, 116, 121, 108, 101, 0, 0, 0, 0, 0, 101, 114, 114, 111, 114, 45, 102, 105, 108, 101, 0, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 102, 105, 108, 101, 0, 0, 0, 0, 0, 119, 114, 105, 116, 101, 45, 98, 97, 99, 107, 0, 0, 0, 0, 0, 0, 240, 27, 1, 0, 232, 27, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 97, 114, 107, 117, 112, 0, 0, 115, 104, 111, 119, 45, 105, 110, 102, 111, 0, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 45, 119, 97, 114, 110, 105, 110, 103, 115, 0, 0, 0, 113, 117, 105, 101, 116, 0, 0, 0, 105, 110, 100, 101, 110, 116, 0, 0, 240, 27, 1, 0, 232, 27, 1, 0, 232, 35, 1, 0, 0, 0, 0, 0, 99, 111, 101, 114, 99, 101, 45, 101, 110, 100, 116, 97, 103, 115, 0, 0, 111, 109, 105, 116, 45, 111, 112, 116, 105, 111, 110, 97, 108, 45, 116, 97, 103, 115, 0, 0, 0, 0, 0, 0, 104, 105, 100, 101, 45, 101, 110, 100, 116, 97, 103, 115, 0, 0, 0, 0, 105, 110, 112, 117, 116, 45, 120, 109, 108, 0, 0, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 120, 109, 108, 0, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 120, 104, 116, 109, 108, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 104, 116, 109, 108, 0, 0, 0, 0, 0, 97, 100, 100, 45, 120, 109, 108, 45, 100, 101, 99, 108, 0, 0, 0, 0, 117, 112, 112, 101, 114, 99, 97, 115, 101, 45, 116, 97, 103, 115, 0, 0, 117, 112, 112, 101, 114, 99, 97, 115, 101, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 0, 0, 0, 98, 97, 114, 101, 0, 0, 0, 0, 99, 108, 101, 97, 110, 0, 0, 0, 103, 100, 111, 99, 0, 0, 0, 0, 108, 111, 103, 105, 99, 97, 108, 45, 101, 109, 112, 104, 97, 115, 105, 115, 0, 0, 0, 0, 0, 0, 0, 0, 100, 114, 111, 112, 45, 112, 114, 111, 112, 114, 105, 101, 116, 97, 114, 121, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 0, 0, 0, 0, 100, 114, 111, 112, 45, 102, 111, 110, 116, 45, 116, 97, 103, 115, 0, 0, 100, 114, 111, 112, 45, 101, 109, 112, 116, 121, 45, 101, 108, 101, 109, 101, 110, 116, 115, 0, 0, 0, 0, 0, 100, 114, 111, 112, 45, 101, 109, 112, 116, 121, 45, 112, 97, 114, 97, 115, 0, 0, 0, 0, 0, 0, 0, 0, 102, 105, 120, 45, 98, 97, 100, 45, 99, 111, 109, 109, 101, 110, 116, 115, 0, 0, 0, 0, 0, 0, 0, 0, 98, 114, 101, 97, 107, 45, 98, 101, 102, 111, 114, 101, 45, 98, 114, 0, 115, 112, 108, 105, 116, 0, 0, 0, 110, 117, 109, 101, 114, 105, 99, 45, 101, 110, 116, 105, 116, 105, 101, 115, 0, 0, 0, 0, 0, 0, 0, 0, 113, 117, 111, 116, 101, 45, 109, 97, 114, 107, 115, 0, 0, 0, 0, 0, 113, 117, 111, 116, 101, 45, 110, 98, 115, 112, 0, 0, 0, 0, 0, 0, 113, 117, 111, 116, 101, 45, 97, 109, 112, 101, 114, 115, 97, 110, 100, 0, 119, 114, 97, 112, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 119, 114, 97, 112, 45, 115, 99, 114, 105, 112, 116, 45, 108, 105, 116, 101, 114, 97, 108, 115, 0, 0, 0, 0, 119, 114, 97, 112, 45, 115, 101, 99, 116, 105, 111, 110, 115, 0, 0, 0, 119, 114, 97, 112, 45, 97, 115, 112, 0, 0, 0, 0, 0, 0, 0, 0, 119, 114, 97, 112, 45, 106, 115, 116, 101, 0, 0, 0, 0, 0, 0, 0, 119, 114, 97, 112, 45, 112, 104, 112, 0, 0, 0, 0, 0, 0, 0, 0, 102, 105, 120, 45, 98, 97, 99, 107, 115, 108, 97, 115, 104, 0, 0, 0, 105, 110, 100, 101, 110, 116, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 0, 0, 0, 0, 0, 0, 97, 115, 115, 117, 109, 101, 45, 120, 109, 108, 45, 112, 114, 111, 99, 105, 110, 115, 0, 0, 0, 0, 0, 0, 97, 100, 100, 45, 120, 109, 108, 45, 115, 112, 97, 99, 101, 0, 0, 0, 101, 110, 99, 108, 111, 115, 101, 45, 116, 101, 120, 116, 0, 0, 0, 0, 101, 110, 99, 108, 111, 115, 101, 45, 98, 108, 111, 99, 107, 45, 116, 101, 120, 116, 0, 0, 0, 0, 0, 0, 107, 101, 101, 112, 45, 116, 105, 109, 101, 0, 0, 0, 0, 0, 0, 0, 119, 111, 114, 100, 45, 50, 48, 48, 48, 0, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 45, 109, 97, 114, 107, 0, 0, 0, 0, 0, 0, 0, 103, 110, 117, 45, 101, 109, 97, 99, 115, 0, 0, 0, 0, 0, 0, 0, 103, 110, 117, 45, 101, 109, 97, 99, 115, 45, 102, 105, 108, 101, 0, 0, 108, 105, 116, 101, 114, 97, 108, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 0, 0, 0, 0, 0, 115, 104, 111, 119, 45, 98, 111, 100, 121, 45, 111, 110, 108, 121, 0, 0, 102, 105, 120, 45, 117, 114, 105, 0, 108, 111, 119, 101, 114, 45, 108, 105, 116, 101, 114, 97, 108, 115, 0, 0, 104, 105, 100, 101, 45, 99, 111, 109, 109, 101, 110, 116, 115, 0, 0, 0, 105, 110, 100, 101, 110, 116, 45, 99, 100, 97, 116, 97, 0, 0, 0, 0, 102, 111, 114, 99, 101, 45, 111, 117, 116, 112, 117, 116, 0, 0, 0, 0, 115, 104, 111, 119, 45, 101, 114, 114, 111, 114, 115, 0, 0, 0, 0, 0, 97, 115, 99, 105, 105, 45, 99, 104, 97, 114, 115, 0, 0, 0, 0, 0, 106, 111, 105, 110, 45, 99, 108, 97, 115, 115, 101, 115, 0, 0, 0, 0, 106, 111, 105, 110, 45, 115, 116, 121, 108, 101, 115, 0, 0, 0, 0, 0, 101, 115, 99, 97, 112, 101, 45, 99, 100, 97, 116, 97, 0, 0, 0, 0, 108, 97, 110, 103, 117, 97, 103, 101, 0, 0, 0, 0, 0, 0, 0, 0, 110, 99, 114, 0, 0, 0, 0, 0, 111, 117, 116, 112, 117, 116, 45, 98, 111, 109, 0, 0, 0, 0, 0, 0, 114, 101, 112, 108, 97, 99, 101, 45, 99, 111, 108, 111, 114, 0, 0, 0, 99, 115, 115, 45, 112, 114, 101, 102, 105, 120, 0, 0, 0, 0, 0, 0, 110, 101, 119, 45, 105, 110, 108, 105, 110, 101, 45, 116, 97, 103, 115, 0, 110, 101, 119, 45, 98, 108, 111, 99, 107, 108, 101, 118, 101, 108, 45, 116, 97, 103, 115, 0, 0, 0, 0, 0, 110, 101, 119, 45, 101, 109, 112, 116, 121, 45, 116, 97, 103, 115, 0, 0, 110, 101, 119, 45, 112, 114, 101, 45, 116, 97, 103, 115, 0, 0, 0, 0, 97, 99, 99, 101, 115, 115, 105, 98, 105, 108, 105, 116, 121, 45, 99, 104, 101, 99, 107, 0, 0, 0, 0, 0, 56, 35, 1, 0, 80, 35, 1, 0, 104, 35, 1, 0, 128, 35, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 101, 114, 116, 105, 99, 97, 108, 45, 115, 112, 97, 99, 101, 0, 0, 112, 117, 110, 99, 116, 117, 97, 116, 105, 111, 110, 45, 119, 114, 97, 112, 0, 0, 0, 0, 0, 0, 0, 0, 109, 101, 114, 103, 101, 45, 101, 109, 112, 104, 97, 115, 105, 115, 0, 0, 109, 101, 114, 103, 101, 45, 100, 105, 118, 115, 0, 0, 0, 0, 0, 0, 100, 101, 99, 111, 114, 97, 116, 101, 45, 105, 110, 102, 101, 114, 114, 101, 100, 45, 117, 108, 0, 0, 0, 0, 112, 114, 101, 115, 101, 114, 118, 101, 45, 101, 110, 116, 105, 116, 105, 101, 115, 0, 0, 0, 0, 0, 0, 0, 115, 111, 114, 116, 45, 97, 116, 116, 114, 105, 98, 117, 116, 101, 115, 0, 40, 35, 1, 0, 48, 35, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 101, 114, 103, 101, 45, 115, 112, 97, 110, 115, 0, 0, 0, 0, 0, 97, 110, 99, 104, 111, 114, 45, 97, 115, 45, 110, 97, 109, 101, 0, 0, 110, 111, 110, 101, 0, 0, 0, 0, 97, 108, 112, 104, 97, 0, 0, 0, 48, 32, 40, 84, 105, 100, 121, 32, 67, 108, 97, 115, 115, 105, 99, 41, 0, 0, 0, 0, 0, 0, 0, 0, 49, 32, 40, 80, 114, 105, 111, 114, 105, 116, 121, 32, 49, 32, 67, 104, 101, 99, 107, 115, 41, 0, 0, 0, 50, 32, 40, 80, 114, 105, 111, 114, 105, 116, 121, 32, 50, 32, 67, 104, 101, 99, 107, 115, 41, 0, 0, 0, 51, 32, 40, 80, 114, 105, 111, 114, 105, 116, 121, 32, 51, 32, 67, 104, 101, 99, 107, 115, 41, 0, 0, 0, 44, 32, 0, 0, 0, 0, 0, 0, 111, 112, 116, 105, 111, 110, 45, 62, 105, 100, 32, 61, 61, 32, 111, 112, 116, 73, 100, 32, 38, 38, 32, 111, 112, 116, 105, 111, 110, 45, 62, 116, 121, 112, 101, 32, 61, 61, 32, 84, 105, 100, 121, 83, 116, 114, 105, 110, 103, 0, 0, 0, 0, 0, 0, 0, 83, 101, 116, 79, 112, 116, 105, 111, 110, 86, 97, 108, 117, 101, 0, 0, 97, 117, 116, 111, 0, 0, 0, 0, 107, 101, 101, 112, 45, 102, 105, 114, 115, 116, 0, 0, 0, 0, 0, 0, 107, 101, 101, 112, 45, 108, 97, 115, 116, 0, 0, 0, 0, 0, 0, 0, 104, 116, 109, 108, 53, 0, 0, 0, 111, 109, 105, 116, 0, 0, 0, 0, 115, 116, 114, 105, 99, 116, 0, 0, 108, 111, 111, 115, 101, 0, 0, 0, 116, 114, 97, 110, 115, 105, 116, 105, 111, 110, 97, 108, 0, 0, 0, 0, 117, 115, 101, 114, 0, 0, 0, 0, 76, 70, 0, 0, 0, 0, 0, 0, 67, 82, 76, 70, 0, 0, 0, 0, 67, 82, 0, 0, 0, 0, 0, 0, 108, 102, 0, 0, 0, 0, 0, 0, 99, 114, 108, 102, 0, 0, 0, 0, 99, 114, 0, 0, 0, 0, 0, 0, 114, 97, 119, 0, 0, 0, 0, 0, 108, 97, 116, 105, 110, 48, 0, 0, 108, 97, 116, 105, 110, 49, 0, 0, 117, 116, 102, 56, 0, 0, 0, 0, 105, 115, 111, 50, 48, 50, 50, 0, 109, 97, 99, 0, 0, 0, 0, 0, 119, 105, 110, 49, 50, 53, 50, 0, 105, 98, 109, 56, 53, 56, 0, 0, 117, 116, 102, 49, 54, 108, 101, 0, 117, 116, 102, 49, 54, 98, 101, 0, 117, 116, 102, 49, 54, 0, 0, 0, 98, 105, 103, 53, 0, 0, 0, 0, 115, 104, 105, 102, 116, 106, 105, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 1, 0, 0, 0, 7, 0, 0, 0, 8, 0, 0, 0, 8, 37, 1, 0, 0, 0, 0, 0, 70, 97, 116, 97, 108, 32, 101, 114, 114, 111, 114, 58, 32, 37, 115, 10, 0, 0, 0, 0, 0, 0, 0, 0, 79, 117, 116, 32, 111, 102, 32, 109, 101, 109, 111, 114, 121, 33, 0, 0, 4, 0, 0, 0, 252, 31, 6, 0, 22, 0, 0, 0, 252, 31, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 36, 0, 0, 0, 252, 15, 0, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 58, 0, 0, 0, 255, 31, 6, 0, 59, 0, 0, 0, 252, 31, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 77, 0, 0, 0, 0, 0, 6, 0, 157, 0, 0, 0, 1, 0, 0, 0, 80, 0, 0, 0, 255, 7, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 117, 0, 0, 0, 255, 31, 6, 0, 118, 0, 0, 0, 255, 31, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 127, 0, 0, 0, 252, 15, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 31, 6, 0, 139, 0, 0, 0, 216, 6, 6, 0, 141, 0, 0, 0, 255, 31, 6, 0, 143, 0, 0, 0, 252, 31, 6, 0, 162, 0, 0, 0, 1, 0, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 252, 31, 0, 0, 45, 0, 0, 0, 252, 15, 0, 0, 62, 0, 0, 0, 252, 31, 0, 0, 66, 0, 0, 0, 252, 7, 0, 0, 91, 0, 0, 0, 252, 15, 0, 0, 95, 0, 0, 0, 252, 15, 0, 0, 98, 0, 0, 0, 252, 15, 0, 0, 99, 0, 0, 0, 252, 15, 0, 0, 100, 0, 0, 0, 252, 15, 0, 0, 102, 0, 0, 0, 252, 15, 0, 0, 103, 0, 0, 0, 252, 15, 0, 0, 104, 0, 0, 0, 252, 15, 0, 0, 105, 0, 0, 0, 252, 15, 0, 0, 106, 0, 0, 0, 252, 15, 0, 0, 136, 0, 0, 0, 252, 15, 0, 0, 141, 0, 0, 0, 252, 31, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 0, 0, 0, 218, 6, 0, 0, 9, 0, 0, 0, 218, 6, 0, 0, 10, 0, 0, 0, 216, 6, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 28, 0, 0, 0, 218, 6, 0, 0, 29, 0, 0, 0, 218, 6, 0, 0, 57, 0, 0, 0, 218, 6, 0, 0, 60, 0, 0, 0, 218, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 80, 0, 0, 0, 218, 6, 0, 0, 85, 0, 0, 0, 216, 6, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 150, 0, 0, 0, 218, 6, 0, 0, 151, 0, 0, 0, 218, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 252, 15, 6, 0, 9, 0, 0, 0, 254, 15, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 36, 0, 0, 0, 254, 15, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 58, 0, 0, 0, 254, 15, 6, 0, 59, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 77, 0, 0, 0, 0, 0, 6, 0, 81, 0, 0, 0, 254, 15, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 117, 0, 0, 0, 0, 0, 6, 0, 127, 0, 0, 0, 254, 15, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 15, 6, 0, 139, 0, 0, 0, 216, 6, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 143, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 166, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 170, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 187, 0, 0, 0, 0, 0, 6, 0, 191, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 249, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 58, 0, 0, 0, 255, 31, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 139, 0, 0, 0, 216, 6, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 216, 6, 0, 0, 49, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 131, 0, 0, 0, 218, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 7, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 7, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 7, 6, 0, 99, 0, 0, 0, 0, 7, 6, 0, 100, 0, 0, 0, 0, 7, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 7, 6, 0, 103, 0, 0, 0, 0, 7, 6, 0, 104, 0, 0, 0, 0, 7, 6, 0, 105, 0, 0, 0, 0, 7, 6, 0, 106, 0, 0, 0, 0, 7, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 252, 15, 0, 0, 45, 0, 0, 0, 252, 15, 0, 0, 62, 0, 0, 0, 252, 15, 0, 0, 66, 0, 0, 0, 252, 7, 0, 0, 91, 0, 0, 0, 252, 15, 0, 0, 95, 0, 0, 0, 252, 15, 0, 0, 98, 0, 0, 0, 252, 15, 0, 0, 99, 0, 0, 0, 252, 15, 0, 0, 100, 0, 0, 0, 252, 15, 0, 0, 102, 0, 0, 0, 252, 15, 0, 0, 103, 0, 0, 0, 252, 15, 0, 0, 104, 0, 0, 0, 252, 15, 0, 0, 105, 0, 0, 0, 252, 15, 0, 0, 106, 0, 0, 0, 252, 15, 0, 0, 136, 0, 0, 0, 252, 15, 0, 0, 141, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 24, 0, 0, 0, 252, 31, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 71700);
allocate([6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 8, 0, 0, 0, 218, 6, 0, 0, 12, 0, 0, 0, 218, 6, 0, 0, 13, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 71, 0, 0, 0, 218, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 197, 0, 0, 0, 0, 0, 6, 0, 198, 0, 0, 0, 0, 0, 6, 0, 87, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 214, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 252, 15, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 220, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 222, 0, 0, 0, 0, 0, 6, 0, 223, 0, 0, 0, 0, 0, 6, 0, 224, 0, 0, 0, 0, 0, 6, 0, 225, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 229, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 233, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 234, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 240, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 243, 0, 0, 0, 0, 0, 6, 0, 112, 0, 0, 0, 252, 15, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 140, 0, 0, 0, 218, 6, 0, 0, 141, 0, 0, 0, 252, 31, 6, 0, 149, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 27, 0, 0, 0, 218, 6, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 252, 15, 6, 0, 165, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 176, 0, 0, 0, 0, 0, 6, 0, 177, 0, 0, 0, 0, 0, 6, 0, 178, 0, 0, 0, 0, 0, 6, 0, 179, 0, 0, 0, 0, 0, 6, 0, 180, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 80, 0, 0, 0, 252, 15, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 15, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 143, 0, 0, 0, 252, 15, 6, 0, 146, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 151, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 91, 0, 0, 0, 216, 6, 0, 0, 95, 0, 0, 0, 216, 6, 0, 0, 98, 0, 0, 0, 216, 6, 0, 0, 99, 0, 0, 0, 216, 6, 0, 0, 100, 0, 0, 0, 216, 6, 0, 0, 102, 0, 0, 0, 216, 6, 0, 0, 103, 0, 0, 0, 216, 6, 0, 0, 104, 0, 0, 0, 216, 6, 0, 0, 105, 0, 0, 0, 216, 6, 0, 0, 106, 0, 0, 0, 216, 6, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 252, 15, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 132, 0, 0, 0, 252, 15, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 145, 0, 0, 0, 252, 15, 0, 0, 151, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 252, 15, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 132, 0, 0, 0, 252, 15, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 145, 0, 0, 0, 252, 15, 0, 0, 151, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 23, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 46, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 183, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 65, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 251, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 143, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 24, 0, 0, 0, 252, 15, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 42, 0, 0, 0, 252, 15, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 194, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 34, 0, 0, 0, 219, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 91, 0, 0, 0, 216, 6, 0, 0, 95, 0, 0, 0, 216, 6, 0, 0, 98, 0, 0, 0, 216, 6, 0, 0, 99, 0, 0, 0, 216, 6, 0, 0, 100, 0, 0, 0, 216, 6, 0, 0, 102, 0, 0, 0, 216, 6, 0, 0, 103, 0, 0, 0, 216, 6, 0, 0, 104, 0, 0, 0, 216, 6, 0, 0, 105, 0, 0, 0, 216, 6, 0, 0, 106, 0, 0, 0, 216, 6, 0, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 34, 0, 0, 0, 219, 6, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 81942);
allocate([6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 143, 0, 0, 0, 0, 0, 6, 0, 151, 0, 0, 0, 0, 0, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 80, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 31, 0, 0, 0, 218, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 49, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 131, 0, 0, 0, 218, 6, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 224, 15, 0, 0, 3, 0, 0, 0, 252, 15, 6, 0, 4, 0, 0, 0, 0, 0, 6, 0, 5, 0, 0, 0, 255, 31, 6, 0, 164, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 48, 0, 0, 0, 255, 31, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 78, 0, 0, 0, 255, 31, 6, 0, 80, 0, 0, 0, 224, 6, 6, 0, 193, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 252, 15, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 252, 15, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 160, 0, 0, 0, 1, 0, 0, 0, 161, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 139, 0, 0, 0, 216, 6, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 144, 4, 0, 0, 52, 0, 0, 0, 144, 4, 0, 0, 62, 0, 0, 0, 144, 4, 0, 0, 72, 0, 0, 0, 144, 4, 0, 0, 74, 0, 0, 0, 144, 4, 0, 0, 75, 0, 0, 0, 144, 4, 0, 0, 80, 0, 0, 0, 144, 4, 0, 0, 82, 0, 0, 0, 144, 4, 0, 0, 125, 0, 0, 0, 144, 4, 0, 0, 133, 0, 0, 0, 144, 4, 0, 0, 136, 0, 0, 0, 144, 4, 0, 0, 141, 0, 0, 0, 144, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 144, 4, 0, 0, 32, 0, 0, 0, 144, 4, 0, 0, 62, 0, 0, 0, 144, 4, 0, 0, 101, 0, 0, 0, 144, 4, 0, 0, 112, 0, 0, 0, 144, 4, 0, 0, 120, 0, 0, 0, 144, 4, 0, 0, 136, 0, 0, 0, 144, 4, 0, 0, 141, 0, 0, 0, 144, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 113, 0, 0, 0, 252, 31, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 92182);
allocate([6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 224, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 224, 7, 6, 0, 83, 0, 0, 0, 218, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 160, 0, 0, 0, 1, 0, 0, 0, 131, 0, 0, 0, 218, 6, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 151, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 189, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 148, 0, 0, 0, 219, 24, 0, 0, 155, 0, 0, 0, 0, 31, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 216, 6, 0, 0, 25, 0, 0, 0, 216, 6, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 52, 0, 0, 0, 216, 6, 0, 0, 57, 0, 0, 0, 216, 6, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 216, 6, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 72, 0, 0, 0, 216, 6, 0, 0, 74, 0, 0, 0, 216, 6, 0, 0, 75, 0, 0, 0, 216, 6, 0, 0, 80, 0, 0, 0, 216, 6, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 254, 0, 0, 0, 0, 0, 6, 0, 125, 0, 0, 0, 216, 6, 0, 0, 0, 1, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 216, 6, 6, 0, 3, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 216, 6, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 216, 6, 6, 0, 151, 0, 0, 0, 216, 6, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 219, 6, 0, 0, 9, 0, 0, 0, 255, 31, 6, 0, 15, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 7, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 254, 31, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 60, 0, 0, 0, 218, 6, 0, 0, 62, 0, 0, 0, 252, 31, 6, 0, 63, 0, 0, 0, 255, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 72, 0, 0, 0, 252, 31, 0, 0, 80, 0, 0, 0, 224, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 255, 31, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 144, 0, 0, 0, 254, 15, 6, 0, 150, 0, 0, 0, 218, 6, 0, 0, 151, 0, 0, 0, 254, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 252, 15, 6, 0, 4, 0, 0, 0, 252, 31, 6, 0, 7, 0, 0, 0, 219, 6, 0, 0, 9, 0, 0, 0, 252, 15, 6, 0, 164, 0, 0, 0, 0, 0, 6, 0, 165, 0, 0, 0, 0, 0, 6, 0, 23, 0, 0, 0, 255, 31, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 172, 0, 0, 0, 0, 0, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 176, 0, 0, 0, 0, 0, 6, 0, 177, 0, 0, 0, 0, 0, 6, 0, 178, 0, 0, 0, 0, 0, 6, 0, 179, 0, 0, 0, 0, 0, 6, 0, 180, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 63, 0, 0, 0, 224, 0, 0, 0, 66, 0, 0, 0, 252, 7, 6, 0, 186, 0, 0, 0, 0, 0, 6, 0, 190, 0, 0, 0, 0, 0, 6, 0, 76, 0, 0, 0, 255, 31, 6, 0, 192, 0, 0, 0, 0, 0, 6, 0, 79, 0, 0, 0, 0, 0, 6, 0, 80, 0, 0, 0, 255, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 252, 15, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 252, 15, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 246, 0, 0, 0, 0, 0, 6, 0, 247, 0, 0, 0, 0, 0, 6, 0, 116, 0, 0, 0, 252, 15, 6, 0, 252, 0, 0, 0, 0, 0, 6, 0, 160, 0, 0, 0, 1, 0, 0, 0, 131, 0, 0, 0, 255, 31, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 255, 31, 6, 0, 5, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 15, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 143, 0, 0, 0, 255, 31, 6, 0, 144, 0, 0, 0, 252, 15, 0, 0, 146, 0, 0, 0, 255, 31, 6, 0, 151, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 24, 0, 0, 0, 252, 15, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 42, 0, 0, 0, 252, 15, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 114, 0, 0, 0, 218, 6, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 165, 0, 0, 0, 0, 0, 6, 0, 167, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 46, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 184, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 80, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 252, 31, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 50, 0, 0, 0, 252, 31, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 252, 15, 6, 0, 7, 0, 0, 0, 216, 6, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 143, 0, 0, 0, 218, 6, 0, 0, 146, 0, 0, 0, 218, 6, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 22, 0, 0, 0, 252, 31, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 58, 0, 0, 0, 255, 31, 6, 0, 59, 0, 0, 0, 252, 31, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 64, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 77, 0, 0, 0, 252, 31, 6, 0, 157, 0, 0, 0, 1, 0, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 117, 0, 0, 0, 255, 31, 6, 0, 118, 0, 0, 0, 255, 31, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 139, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 255, 31, 6, 0, 143, 0, 0, 0, 252, 31, 6, 0, 162, 0, 0, 0, 1, 0, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 80, 0, 0, 0, 254, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 216, 6, 6, 0, 34, 0, 0, 0, 219, 6, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 216, 6, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 216, 6, 6, 0, 65, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 216, 6, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 216, 6, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 216, 6, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 216, 6, 6, 0, 99, 0, 0, 0, 216, 6, 6, 0, 100, 0, 0, 0, 216, 6, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 216, 6, 6, 0, 103, 0, 0, 0, 216, 6, 6, 0, 104, 0, 0, 0, 216, 6, 6, 0, 105, 0, 0, 0, 216, 6, 6, 0, 106, 0, 0, 0, 216, 6, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 216, 6, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 216, 6, 6, 0, 143, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 22, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 35, 0, 0, 0, 255, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 102422);
allocate([6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 61, 0, 0, 0, 255, 31, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 80, 0, 0, 0, 255, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 123, 0, 0, 0, 252, 31, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 182, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 188, 0, 0, 0, 0, 0, 6, 0, 190, 0, 0, 0, 0, 0, 6, 0, 192, 0, 0, 0, 0, 0, 6, 0, 195, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 146, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 158, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 91, 0, 0, 0, 216, 6, 0, 0, 95, 0, 0, 0, 216, 6, 0, 0, 98, 0, 0, 0, 216, 6, 0, 0, 99, 0, 0, 0, 216, 6, 0, 0, 100, 0, 0, 0, 216, 6, 0, 0, 102, 0, 0, 0, 216, 6, 0, 0, 103, 0, 0, 0, 216, 6, 0, 0, 104, 0, 0, 0, 216, 6, 0, 0, 105, 0, 0, 0, 216, 6, 0, 0, 106, 0, 0, 0, 216, 6, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 216, 6, 0, 0, 10, 0, 0, 0, 252, 31, 0, 0, 15, 0, 0, 0, 216, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 26, 0, 0, 0, 252, 31, 0, 0, 29, 0, 0, 0, 252, 31, 0, 0, 30, 0, 0, 0, 252, 31, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 37, 0, 0, 0, 252, 31, 6, 0, 43, 0, 0, 0, 252, 31, 0, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 252, 31, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 60, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 80, 0, 0, 0, 252, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 134, 0, 0, 0, 252, 31, 0, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 31, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 143, 0, 0, 0, 252, 31, 6, 0, 144, 0, 0, 0, 252, 15, 6, 0, 150, 0, 0, 0, 216, 6, 0, 0, 151, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 34, 0, 0, 0, 219, 6, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 253, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 135, 0, 0, 0, 218, 6, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 143, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 65, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 65, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 126, 0, 0, 0, 255, 31, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 146, 0, 0, 0, 255, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 50, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 80, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 80, 0, 0, 0, 254, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 143, 0, 0, 0, 252, 31, 0, 0, 146, 0, 0, 0, 254, 31, 6, 0, 147, 0, 0, 0, 252, 31, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 151, 0, 0, 0, 219, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 154, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 190, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 146, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 24, 0, 0, 0, 252, 31, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 8, 0, 0, 45, 0, 0, 0, 0, 8, 0, 0, 62, 0, 0, 0, 0, 8, 0, 0, 91, 0, 0, 0, 0, 8, 0, 0, 95, 0, 0, 0, 0, 8, 0, 0, 98, 0, 0, 0, 0, 8, 0, 0, 99, 0, 0, 0, 0, 8, 0, 0, 100, 0, 0, 0, 0, 8, 0, 0, 102, 0, 0, 0, 0, 8, 0, 0, 103, 0, 0, 0, 0, 8, 0, 0, 104, 0, 0, 0, 0, 8, 0, 0, 105, 0, 0, 0, 0, 8, 0, 0, 106, 0, 0, 0, 0, 8, 0, 0, 136, 0, 0, 0, 0, 8, 0, 0, 141, 0, 0, 0, 0, 8, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 8, 0, 0, 45, 0, 0, 0, 0, 8, 0, 0, 62, 0, 0, 0, 0, 8, 0, 0, 91, 0, 0, 0, 0, 8, 0, 0, 95, 0, 0, 0, 0, 8, 0, 0, 98, 0, 0, 0, 0, 8, 0, 0, 99, 0, 0, 0, 0, 8, 0, 0, 100, 0, 0, 0, 0, 8, 0, 0, 102, 0, 0, 0, 0, 8, 0, 0, 103, 0, 0, 0, 0, 8, 0, 0, 104, 0, 0, 0, 0, 8, 0, 0, 105, 0, 0, 0, 0, 8, 0, 0, 106, 0, 0, 0, 0, 8, 0, 0, 136, 0, 0, 0, 0, 8, 0, 0, 141, 0, 0, 0, 0, 8, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 8, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 8, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 8, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 8, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 8, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 8, 6, 0, 99, 0, 0, 0, 0, 8, 6, 0, 100, 0, 0, 0, 0, 8, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 8, 6, 0, 103, 0, 0, 0, 0, 8, 6, 0, 104, 0, 0, 0, 0, 8, 6, 0, 105, 0, 0, 0, 0, 8, 6, 0, 106, 0, 0, 0, 0, 8, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 8, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 8, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 8, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 8, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 8, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 8, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 8, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 8, 6, 0, 99, 0, 0, 0, 0, 8, 6, 0, 100, 0, 0, 0, 0, 8, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 8, 6, 0, 103, 0, 0, 0, 0, 8, 6, 0, 104, 0, 0, 0, 0, 8, 6, 0, 105, 0, 0, 0, 0, 8, 6, 0, 106, 0, 0, 0, 0, 8, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 115, 0, 0, 0, 0, 8, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 8, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 8, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 0, 8, 0, 0, 45, 0, 0, 0, 0, 8, 0, 0, 62, 0, 0, 0, 0, 8, 0, 0, 91, 0, 0, 0, 0, 8, 0, 0, 95, 0, 0, 0, 0, 8, 0, 0, 98, 0, 0, 0, 0, 8, 0, 0, 99, 0, 0, 0, 0, 8, 0, 0, 100, 0, 0, 0, 0, 8, 0, 0, 102, 0, 0, 0, 0, 8, 0, 0, 103, 0, 0, 0, 0, 8, 0, 0, 104, 0, 0, 0, 0, 8, 0, 0, 105, 0, 0, 0, 0, 8, 0, 0, 106, 0, 0, 0, 0, 8, 0, 0, 136, 0, 0, 0, 0, 8, 0, 0, 141, 0, 0, 0, 0, 8, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 8, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 8, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 8, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 8, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 8, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 112662);
allocate([6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 8, 6, 0, 99, 0, 0, 0, 0, 8, 6, 0, 100, 0, 0, 0, 0, 8, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 8, 6, 0, 103, 0, 0, 0, 0, 8, 6, 0, 104, 0, 0, 0, 0, 8, 6, 0, 105, 0, 0, 0, 0, 8, 6, 0, 106, 0, 0, 0, 0, 8, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 8, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 8, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 216, 6, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 216, 6, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 216, 6, 6, 0, 66, 0, 0, 0, 216, 6, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 216, 6, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 216, 6, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 216, 6, 6, 0, 99, 0, 0, 0, 216, 6, 6, 0, 100, 0, 0, 0, 216, 6, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 216, 6, 6, 0, 103, 0, 0, 0, 216, 6, 6, 0, 104, 0, 0, 0, 216, 6, 6, 0, 105, 0, 0, 0, 216, 6, 6, 0, 106, 0, 0, 0, 216, 6, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 216, 6, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 216, 6, 6, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 163, 0, 0, 0, 0, 0, 6, 0, 22, 0, 0, 0, 252, 15, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 44, 0, 0, 0, 252, 15, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 156, 0, 0, 0, 252, 0, 0, 0, 50, 0, 0, 0, 252, 0, 0, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 67, 0, 0, 0, 216, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 252, 15, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 143, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 154, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 165, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 79, 0, 0, 0, 255, 31, 6, 0, 80, 0, 0, 0, 255, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 252, 15, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 252, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 131, 0, 0, 0, 255, 31, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 15, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 77, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 143, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 216, 6, 0, 0, 45, 0, 0, 0, 216, 6, 0, 0, 62, 0, 0, 0, 216, 6, 0, 0, 66, 0, 0, 0, 216, 6, 0, 0, 91, 0, 0, 0, 216, 6, 0, 0, 95, 0, 0, 0, 216, 6, 0, 0, 98, 0, 0, 0, 216, 6, 0, 0, 99, 0, 0, 0, 216, 6, 0, 0, 100, 0, 0, 0, 216, 6, 0, 0, 102, 0, 0, 0, 216, 6, 0, 0, 103, 0, 0, 0, 216, 6, 0, 0, 104, 0, 0, 0, 216, 6, 0, 0, 105, 0, 0, 0, 216, 6, 0, 0, 106, 0, 0, 0, 216, 6, 0, 0, 136, 0, 0, 0, 216, 6, 0, 0, 141, 0, 0, 0, 216, 6, 0, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 77, 0, 0, 0, 252, 15, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 255, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 143, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 154, 0, 0, 0, 0, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 218, 6, 0, 0, 13, 0, 0, 0, 216, 6, 0, 0, 15, 0, 0, 0, 254, 15, 6, 0, 18, 0, 0, 0, 254, 15, 0, 0, 19, 0, 0, 0, 254, 15, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 40, 0, 0, 0, 252, 0, 0, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 51, 0, 0, 0, 252, 15, 0, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 122, 0, 0, 0, 252, 15, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 137, 0, 0, 0, 252, 31, 0, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 151, 0, 0, 0, 254, 15, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 252, 15, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 145, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 252, 31, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 254, 31, 0, 0, 11, 0, 0, 0, 252, 31, 0, 0, 13, 0, 0, 0, 216, 6, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 33, 0, 0, 0, 254, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 56, 0, 0, 0, 252, 31, 6, 0, 57, 0, 0, 0, 218, 6, 0, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 84, 0, 0, 0, 218, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 121, 0, 0, 0, 254, 31, 6, 0, 124, 0, 0, 0, 252, 31, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 145, 0, 0, 0, 254, 31, 0, 0, 151, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 252, 31, 6, 0, 165, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 32, 0, 0, 0, 255, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 46, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 175, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 76, 0, 0, 0, 0, 0, 6, 0, 80, 0, 0, 0, 255, 31, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 252, 15, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 252, 15, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 122902);
allocate([6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 252, 15, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 252, 15, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 247, 0, 0, 0, 0, 0, 6, 0, 116, 0, 0, 0, 252, 15, 6, 0, 252, 0, 0, 0, 0, 0, 6, 0, 120, 0, 0, 0, 255, 31, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 252, 15, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 152, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 252, 15, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 145, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 252, 31, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 254, 31, 0, 0, 11, 0, 0, 0, 252, 31, 0, 0, 13, 0, 0, 0, 216, 6, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 33, 0, 0, 0, 254, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 56, 0, 0, 0, 252, 31, 6, 0, 57, 0, 0, 0, 218, 6, 0, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 84, 0, 0, 0, 218, 6, 0, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 121, 0, 0, 0, 254, 31, 6, 0, 124, 0, 0, 0, 252, 31, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 145, 0, 0, 0, 254, 31, 0, 0, 151, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 252, 15, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 15, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 15, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 15, 6, 0, 145, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 42, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 250, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 7, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 7, 0, 0, 0, 254, 31, 0, 0, 13, 0, 0, 0, 216, 6, 0, 0, 20, 0, 0, 0, 252, 15, 0, 0, 21, 0, 0, 0, 252, 15, 0, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 145, 0, 0, 0, 254, 31, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 171, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 185, 0, 0, 0, 0, 0, 6, 0, 65, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 0, 0, 6, 0, 4, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 0, 0, 0, 252, 15, 0, 0, 45, 0, 0, 0, 252, 15, 0, 0, 62, 0, 0, 0, 252, 15, 0, 0, 66, 0, 0, 0, 252, 7, 0, 0, 91, 0, 0, 0, 252, 15, 0, 0, 95, 0, 0, 0, 252, 15, 0, 0, 98, 0, 0, 0, 252, 15, 0, 0, 99, 0, 0, 0, 252, 15, 0, 0, 100, 0, 0, 0, 252, 15, 0, 0, 102, 0, 0, 0, 252, 15, 0, 0, 103, 0, 0, 0, 252, 15, 0, 0, 104, 0, 0, 0, 252, 15, 0, 0, 105, 0, 0, 0, 252, 15, 0, 0, 106, 0, 0, 0, 252, 15, 0, 0, 159, 0, 0, 0, 1, 0, 0, 0, 136, 0, 0, 0, 252, 15, 0, 0, 141, 0, 0, 0, 252, 15, 0, 0, 155, 0, 0, 0, 0, 8, 6, 0, 153, 0, 0, 0, 0, 15, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 216, 6, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 216, 6, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 216, 6, 6, 0, 66, 0, 0, 0, 216, 6, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 216, 6, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 216, 6, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 216, 6, 6, 0, 99, 0, 0, 0, 216, 6, 6, 0, 100, 0, 0, 0, 216, 6, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 216, 6, 6, 0, 103, 0, 0, 0, 216, 6, 6, 0, 104, 0, 0, 0, 216, 6, 6, 0, 105, 0, 0, 0, 216, 6, 6, 0, 106, 0, 0, 0, 216, 6, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 216, 6, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 216, 6, 6, 0, 153, 0, 0, 0, 0, 6, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 34, 0, 0, 0, 219, 6, 0, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 143, 0, 0, 0, 218, 6, 0, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 252, 31, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 252, 15, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 252, 31, 6, 0, 66, 0, 0, 0, 252, 7, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 252, 15, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 252, 15, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 252, 15, 6, 0, 99, 0, 0, 0, 252, 15, 6, 0, 100, 0, 0, 0, 252, 15, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 252, 15, 6, 0, 103, 0, 0, 0, 252, 15, 6, 0, 104, 0, 0, 0, 252, 15, 6, 0, 105, 0, 0, 0, 252, 15, 6, 0, 106, 0, 0, 0, 252, 15, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 159, 0, 0, 0, 1, 0, 0, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 252, 15, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 252, 31, 6, 0, 155, 0, 0, 0, 0, 24, 6, 0, 153, 0, 0, 0, 0, 31, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 166, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 170, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 57, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 187, 0, 0, 0, 0, 0, 6, 0, 191, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 248, 0, 0, 0, 0, 0, 6, 0, 249, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 133, 0, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 151, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 6, 0, 25, 0, 0, 0, 0, 0, 6, 0, 168, 0, 0, 0, 0, 0, 6, 0, 169, 0, 0, 0, 0, 0, 6, 0, 45, 0, 0, 0, 0, 0, 6, 0, 173, 0, 0, 0, 0, 0, 6, 0, 174, 0, 0, 0, 0, 0, 6, 0, 181, 0, 0, 0, 0, 0, 6, 0, 62, 0, 0, 0, 0, 0, 6, 0, 66, 0, 0, 0, 0, 0, 6, 0, 196, 0, 0, 0, 0, 0, 6, 0, 89, 0, 0, 0, 0, 0, 6, 0, 199, 0, 0, 0, 0, 0, 6, 0, 200, 0, 0, 0, 0, 0, 6, 0, 90, 0, 0, 0, 0, 0, 6, 0, 91, 0, 0, 0, 0, 0, 6, 0, 201, 0, 0, 0, 0, 0, 6, 0, 202, 0, 0, 0, 0, 0, 6, 0, 95, 0, 0, 0, 0, 0, 6, 0, 203, 0, 0, 0, 0, 0, 6, 0, 204, 0, 0, 0, 0, 0, 6, 0, 205, 0, 0, 0, 0, 0, 6, 0, 206, 0, 0, 0, 0, 0, 6, 0, 207, 0, 0, 0, 0, 0, 6, 0, 208, 0, 0, 0, 0, 0, 6, 0, 209, 0, 0, 0, 0, 0, 6, 0, 210, 0, 0, 0, 0, 0, 6, 0, 211, 0, 0, 0, 0, 0, 6, 0, 212, 0, 0, 0, 0, 0, 6, 0, 213, 0, 0, 0, 0, 0, 6, 0, 97, 0, 0, 0, 0, 0, 6, 0, 215, 0, 0, 0, 0, 0, 6, 0, 216, 0, 0, 0, 0, 0, 6, 0, 98, 0, 0, 0, 0, 0, 6, 0, 99, 0, 0, 0, 0, 0, 6, 0, 100, 0, 0, 0, 0, 0, 6, 0, 101, 0, 0, 0, 0, 0, 6, 0, 217, 0, 0, 0, 0, 0, 6, 0, 218, 0, 0, 0, 0, 0, 6, 0, 219, 0, 0, 0, 0, 0, 6, 0, 102, 0, 0, 0, 0, 0, 6, 0, 103, 0, 0, 0, 0, 0, 6, 0, 104, 0, 0, 0, 0, 0, 6, 0, 105, 0, 0, 0, 0, 0, 6, 0, 106, 0, 0, 0, 0, 0, 6, 0, 221, 0, 0, 0, 0, 0, 6, 0, 226, 0, 0, 0, 0, 0, 6, 0, 227, 0, 0, 0, 0, 0, 6, 0, 228, 0, 0, 0, 0, 0, 6, 0, 230, 0, 0, 0, 0, 0, 6, 0, 231, 0, 0, 0, 0, 0, 6, 0, 232, 0, 0, 0, 0, 0, 6, 0, 107, 0, 0, 0, 0, 0, 6, 0, 235, 0, 0, 0, 0, 0, 6, 0, 236, 0, 0, 0, 0, 0, 6, 0, 237, 0, 0, 0, 0, 0, 6, 0, 110, 0, 0, 0, 0, 0, 6, 0, 238, 0, 0, 0, 0, 0, 6, 0, 239, 0, 0, 0, 0, 0, 6, 0, 111, 0, 0, 0, 0, 0, 6, 0, 241, 0, 0, 0, 0, 0, 6, 0, 242, 0, 0, 0, 0, 0, 6, 0, 244, 0, 0, 0, 0, 0, 6, 0, 245, 0, 0, 0, 0, 0, 6, 0, 2, 1, 0, 0, 0, 0, 6, 0, 136, 0, 0, 0, 0, 0, 6, 0, 138, 0, 0, 0, 0, 0, 6, 0, 141, 0, 0, 0, 0, 0, 6, 0, 153, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 0, 0, 0, 1, 0, 0, 0, 160, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 117, 102, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 98, 117, 102, 102, 105, 111, 46, 99, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 73, 110, 105, 116, 87, 105, 116, 104, 65, 108, 108, 111, 99, 97, 116, 111, 114, 0, 0, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 70, 114, 101, 101, 0, 0, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 67, 104, 101, 99, 107, 65, 108, 108, 111, 99, 0, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 65, 116, 116, 97, 99, 104, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 80, 117, 116, 66, 121, 116, 101, 0, 0, 116, 105, 100, 121, 66, 117, 102, 80, 111, 112, 66, 121, 116, 101, 0, 0, 98, 118, 32, 61, 61, 32, 98, 117, 102, 45, 62, 98, 112, 91, 32, 98, 117, 102, 45, 62, 110, 101, 120, 116, 32, 93, 0, 0, 0, 0, 0, 0, 116, 105, 100, 121, 66, 117, 102, 85, 110, 103, 101, 116, 66, 121, 116, 101, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 172, 32, 0, 0, 0, 0, 0, 0, 26, 32, 0, 0, 146, 1, 0, 0, 30, 32, 0, 0, 38, 32, 0, 0, 32, 32, 0, 0, 33, 32, 0, 0, 198, 2, 0, 0, 48, 32, 0, 0, 96, 1, 0, 0, 57, 32, 0, 0, 82, 1, 0, 0, 0, 0, 0, 0, 125, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 32, 0, 0, 25, 32, 0, 0, 28, 32, 0, 0, 29, 32, 0, 0, 34, 32, 0, 0, 19, 32, 0, 0, 20, 32, 0, 0, 220, 2, 0, 0, 34, 33, 0, 0, 97, 1, 0, 0, 58, 32, 0, 0, 83, 1, 0, 0, 0, 0, 0, 0, 126, 1, 0, 0, 120, 1, 0, 0, 196, 0, 0, 0, 197, 0, 0, 0, 199, 0, 0, 0, 201, 0, 0, 0, 209, 0, 0, 0, 214, 0, 0, 0, 220, 0, 0, 0, 225, 0, 0, 0, 224, 0, 0, 0, 226, 0, 0, 0, 228, 0, 0, 0, 227, 0, 0, 0, 229, 0, 0, 0, 231, 0, 0, 0, 233, 0, 0, 0, 232, 0, 0, 0, 234, 0, 0, 0, 235, 0, 0, 0, 237, 0, 0, 0, 236, 0, 0, 0, 238, 0, 0, 0, 239, 0, 0, 0, 241, 0, 0, 0, 243, 0, 0, 0, 242, 0, 0, 0, 244, 0, 0, 0, 246, 0, 0, 0, 245, 0, 0, 0, 250, 0, 0, 0, 249, 0, 0, 0, 251, 0, 0, 0, 252, 0, 0, 0, 32, 32, 0, 0, 176, 0, 0, 0, 162, 0, 0, 0, 163, 0, 0, 0, 167, 0, 0, 0, 34, 32, 0, 0, 182, 0, 0, 0, 223, 0, 0, 0, 174, 0, 0, 0, 169, 0, 0, 0, 34, 33, 0, 0, 180, 0, 0, 0, 168, 0, 0, 0, 96, 34, 0, 0, 198, 0, 0, 0, 216, 0, 0, 0, 30, 34, 0, 0, 177, 0, 0, 0, 100, 34, 0, 0, 101, 34, 0, 0, 165, 0, 0, 0, 181, 0, 0, 0, 2, 34, 0, 0, 17, 34, 0, 0, 15, 34, 0, 0, 192, 3, 0, 0, 43, 34, 0, 0, 170, 0, 0, 0, 186, 0, 0, 0, 169, 3, 0, 0, 230, 0, 0, 0, 248, 0, 0, 0, 191, 0, 0, 0, 161, 0, 0, 0, 172, 0, 0, 0, 26, 34, 0, 0, 146, 1, 0, 0, 72, 34, 0, 0, 6, 34, 0, 0, 171, 0, 0, 0, 187, 0, 0, 0, 38, 32, 0, 0, 160, 0, 0, 0, 192, 0, 0, 0, 195, 0, 0, 0, 213, 0, 0, 0, 82, 1, 0, 0, 83, 1, 0, 0, 19, 32, 0, 0, 20, 32, 0, 0, 28, 32, 0, 0, 29, 32, 0, 0, 24, 32, 0, 0, 25, 32, 0, 0, 247, 0, 0, 0, 202, 37, 0, 0, 255, 0, 0, 0, 120, 1, 0, 0, 68, 32, 0, 0, 172, 32, 0, 0, 57, 32, 0, 0, 58, 32, 0, 0, 1, 251, 0, 0, 2, 251, 0, 0, 33, 32, 0, 0, 183, 0, 0, 0, 26, 32, 0, 0, 30, 32, 0, 0, 48, 32, 0, 0, 194, 0, 0, 0, 202, 0, 0, 0, 193, 0, 0, 0, 203, 0, 0, 0, 200, 0, 0, 0, 205, 0, 0, 0, 206, 0, 0, 0, 207, 0, 0, 0, 204, 0, 0, 0, 211, 0, 0, 0, 212, 0, 0, 0, 255, 248, 0, 0, 210, 0, 0, 0, 218, 0, 0, 0, 219, 0, 0, 0, 217, 0, 0, 0, 49, 1, 0, 0, 198, 2, 0, 0, 220, 2, 0, 0, 175, 0, 0, 0, 216, 2, 0, 0, 217, 2, 0, 0, 218, 2, 0, 0, 184, 0, 0, 0, 221, 2, 0, 0, 219, 2, 0, 0, 199, 2, 0, 0, 1, 0, 0, 0, 216, 42, 2, 0, 232, 42, 2, 0, 2, 0, 0, 0, 240, 42, 2, 0, 0, 43, 2, 0, 3, 0, 0, 0, 8, 43, 2, 0, 24, 43, 2, 0, 4, 0, 0, 0, 32, 43, 2, 0, 40, 43, 2, 0, 6, 0, 0, 0, 48, 43, 2, 0, 64, 43, 2, 0, 7, 0, 0, 0, 72, 43, 2, 0, 88, 43, 2, 0, 8, 0, 0, 0, 96, 43, 2, 0, 112, 43, 2, 0, 9, 0, 0, 0, 120, 43, 2, 0, 128, 43, 2, 0, 10, 0, 0, 0, 120, 43, 2, 0, 136, 43, 2, 0, 11, 0, 0, 0, 120, 43, 2, 0, 144, 43, 2, 0, 12, 0, 0, 0, 152, 43, 2, 0, 152, 43, 2, 0, 13, 0, 0, 0, 160, 43, 2, 0, 176, 43, 2, 0, 5, 0, 0, 0, 0, 0, 0, 0, 192, 43, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200, 43, 2, 0, 117, 115, 45, 97, 115, 99, 105, 105, 0, 0, 0, 0, 0, 0, 0, 0, 97, 115, 99, 105, 105, 0, 0, 0, 105, 115, 111, 45, 56, 56, 53, 57, 45, 49, 53, 0, 0, 0, 0, 0, 108, 97, 116, 105, 110, 48, 0, 0, 105, 115, 111, 45, 56, 56, 53, 57, 45, 49, 0, 0, 0, 0, 0, 0, 108, 97, 116, 105, 110, 49, 0, 0, 117, 116, 102, 45, 56, 0, 0, 0, 117, 116, 102, 56, 0, 0, 0, 0, 109, 97, 99, 105, 110, 116, 111, 115, 104, 0, 0, 0, 0, 0, 0, 0, 109, 97, 99, 0, 0, 0, 0, 0, 119, 105, 110, 100, 111, 119, 115, 45, 49, 50, 53, 50, 0, 0, 0, 0, 119, 105, 110, 49, 50, 53, 50, 0, 105, 98, 109, 48, 48, 56, 53, 56, 0, 0, 0, 0, 0, 0, 0, 0, 105, 98, 109, 56, 53, 56, 0, 0, 117, 116, 102, 45, 49, 54, 0, 0, 117, 116, 102, 49, 54, 108, 101, 0, 117, 116, 102, 49, 54, 98, 101, 0, 117, 116, 102, 49, 54, 0, 0, 0, 98, 105, 103, 53, 0, 0, 0, 0, 115, 104, 105, 102, 116, 95, 106, 105, 115, 0, 0, 0, 0, 0, 0, 0, 115, 104, 105, 102, 116, 106, 105, 115, 0, 0, 0, 0, 0, 0, 0, 0, 105, 115, 111, 50, 48, 50, 50, 0, 114, 97, 119, 0, 0, 0, 0, 0, 199, 0, 0, 0, 252, 0, 0, 0, 233, 0, 0, 0, 226, 0, 0, 0, 228, 0, 0, 0, 224, 0, 0, 0, 229, 0, 0, 0, 231, 0, 0, 0, 234, 0, 0, 0, 235, 0, 0, 0, 232, 0, 0, 0, 239, 0, 0, 0, 238, 0, 0, 0, 236, 0, 0, 0, 196, 0, 0, 0, 197, 0, 0, 0, 201, 0, 0, 0, 230, 0, 0, 0, 198, 0, 0, 0, 244, 0, 0, 0, 246, 0, 0, 0, 242, 0, 0, 0, 251, 0, 0, 0, 249, 0, 0, 0, 255, 0, 0, 0, 214, 0, 0, 0, 220, 0, 0, 0, 248, 0, 0, 0, 163, 0, 0, 0, 216, 0, 0, 0, 215, 0, 0, 0, 146, 1, 0, 0, 225, 0, 0, 0, 237, 0, 0, 0, 243, 0, 0, 0, 250, 0, 0, 0, 241, 0, 0, 0, 209, 0, 0, 0, 170, 0, 0, 0, 186, 0, 0, 0, 191, 0, 0, 0, 174, 0, 0, 0, 172, 0, 0, 0, 189, 0, 0, 0, 188, 0, 0, 0, 161, 0, 0, 0, 171, 0, 0, 0, 187, 0, 0, 0, 145, 37, 0, 0, 146, 37, 0, 0, 147, 37, 0, 0, 2, 37, 0, 0, 36, 37, 0, 0, 193, 0, 0, 0, 194, 0, 0, 0, 192, 0, 0, 0, 169, 0, 0, 0, 99, 37, 0, 0, 81, 37, 0, 0, 87, 37, 0, 0, 93, 37, 0, 0, 162, 0, 0, 0, 165, 0, 0, 0, 16, 37, 0, 0, 20, 37, 0, 0, 52, 37, 0, 0, 44, 37, 0, 0, 28, 37, 0, 0, 0, 37, 0, 0, 60, 37, 0, 0, 227, 0, 0, 0, 195, 0, 0, 0, 90, 37, 0, 0, 84, 37, 0, 0, 105, 37, 0, 0, 102, 37, 0, 0, 96, 37, 0, 0, 80, 37, 0, 0, 108, 37, 0, 0, 164, 0, 0, 0, 240, 0, 0, 0, 208, 0, 0, 0, 202, 0, 0, 0, 203, 0, 0, 0, 200, 0, 0, 0, 172, 32, 0, 0, 205, 0, 0, 0, 206, 0, 0, 0, 207, 0, 0, 0, 24, 37, 0, 0, 12, 37, 0, 0, 136, 37, 0, 0, 132, 37, 0, 0, 166, 0, 0, 0, 204, 0, 0, 0, 128, 37, 0, 0, 211, 0, 0, 0, 223, 0, 0, 0, 212, 0, 0, 0, 210, 0, 0, 0, 245, 0, 0, 0, 213, 0, 0, 0, 181, 0, 0, 0, 254, 0, 0, 0, 222, 0, 0, 0, 218, 0, 0, 0, 219, 0, 0, 0, 217, 0, 0, 0, 253, 0, 0, 0, 221, 0, 0, 0, 175, 0, 0, 0, 180, 0, 0, 0, 173, 0, 0, 0, 177, 0, 0, 0, 23, 32, 0, 0, 190, 0, 0, 0, 182, 0, 0, 0, 167, 0, 0, 0, 247, 0, 0, 0, 184, 0, 0, 0, 176, 0, 0, 0, 168, 0, 0, 0, 183, 0, 0, 0, 185, 0, 0, 0, 179, 0, 0, 0, 178, 0, 0, 0, 160, 37, 0, 0, 160, 0, 0, 0, 105, 110, 45, 62, 98, 117, 102, 112, 111, 115, 32, 62, 32, 48, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 115, 116, 114, 101, 97, 109, 105, 111, 46, 99, 0, 0, 0, 0, 80, 111, 112, 67, 104, 97, 114, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 0, 0, 4, 0, 0, 0, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 0, 0, 0, 1, 0, 0, 0, 0, 127, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 255, 7, 0, 0, 2, 0, 0, 0, 194, 223, 128, 191, 0, 0, 0, 0, 0, 8, 0, 0, 255, 15, 0, 0, 3, 0, 0, 0, 224, 224, 160, 191, 128, 191, 0, 0, 0, 16, 0, 0, 255, 255, 0, 0, 3, 0, 0, 0, 225, 239, 128, 191, 128, 191, 0, 0, 0, 0, 1, 0, 255, 255, 3, 0, 4, 0, 0, 0, 240, 240, 144, 191, 128, 191, 128, 191, 0, 0, 4, 0, 255, 255, 15, 0, 4, 0, 0, 0, 241, 243, 128, 191, 128, 191, 128, 191, 0, 0, 16, 0, 255, 255, 16, 0, 4, 0, 0, 0, 244, 244, 128, 143, 128, 191, 128, 191, 0, 0, 0, 0, 84, 89, 95, 40, 73, 115, 72, 105, 103, 104, 83, 117, 114, 114, 111, 103, 97, 116, 101, 41, 40, 104, 105, 103, 104, 41, 32, 38, 38, 32, 84, 89, 95, 40, 73, 115, 76, 111, 119, 83, 117, 114, 114, 111, 103, 97, 116, 101, 41, 40, 108, 111, 119, 41, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 117, 116, 102, 56, 46, 99, 0, 0, 0, 0, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 67, 111, 109, 98, 105, 110, 101, 83, 117, 114, 114, 111, 103, 97, 116, 101, 80, 97, 105, 114, 0, 0, 0, 0, 0, 96, 47, 2, 0, 104, 47, 2, 0, 112, 47, 2, 0, 120, 47, 2, 0, 128, 47, 2, 0, 136, 47, 2, 0, 144, 47, 2, 0, 152, 47, 2, 0, 160, 47, 2, 0, 168, 47, 2, 0, 176, 47, 2, 0, 184, 47, 2, 0, 192, 47, 2, 0, 200, 47, 2, 0, 208, 47, 2, 0, 216, 47, 2, 0, 224, 47, 2, 0, 232, 47, 2, 0, 46, 109, 112, 103, 0, 0, 0, 0, 46, 109, 111, 118, 0, 0, 0, 0, 46, 97, 115, 120, 0, 0, 0, 0, 46, 97, 118, 105, 0, 0, 0, 0, 46, 105, 118, 102, 0, 0, 0, 0, 46, 109, 49, 118, 0, 0, 0, 0, 46, 109, 109, 109, 0, 0, 0, 0, 46, 109, 112, 50, 118, 0, 0, 0, 46, 109, 112, 97, 0, 0, 0, 0, 46, 109, 112, 101, 0, 0, 0, 0, 46, 109, 112, 101, 103, 0, 0, 0, 46, 114, 97, 109, 0, 0, 0, 0, 46, 115, 109, 105, 0, 0, 0, 0, 46, 115, 109, 105, 108, 0, 0, 0, 46, 115, 119, 102, 0, 0, 0, 0, 46, 119, 109, 0, 0, 0, 0, 0, 46, 119, 109, 97, 0, 0, 0, 0, 46, 119, 109, 118, 0, 0, 0, 0, 115, 116, 121, 108, 101, 115, 104, 101, 101, 116, 0, 0, 0, 0, 0, 0, 98, 114, 111, 119, 115, 101, 114, 0, 105, 109, 97, 103, 101, 0, 0, 0, 115, 117, 109, 109, 97, 114, 121, 0, 116, 97, 98, 108, 101], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 133142);
allocate([72, 48, 2, 0, 80, 48, 2, 0, 88, 48, 2, 0, 96, 48, 2, 0, 104, 48, 2, 0, 112, 48, 2, 0, 120, 48, 2, 0, 128, 48, 2, 0, 136, 48, 2, 0, 200, 47, 2, 0, 46, 104, 116, 109, 0, 0, 0, 0, 46, 104, 116, 109, 108, 0, 0, 0, 46, 115, 104, 116, 109, 0, 0, 0, 46, 115, 104, 116, 109, 108, 0, 0, 46, 99, 102, 109, 0, 0, 0, 0, 46, 99, 102, 109, 108, 0, 0, 0, 46, 97, 115, 112, 0, 0, 0, 0, 46, 99, 103, 105, 0, 0, 0, 0, 46, 112, 108, 0, 0, 0, 0, 0, 95, 110, 101, 119, 0, 0, 0, 0, 95, 98, 108, 97, 110, 107, 0, 0, 100, 0, 0, 0, 0, 0, 0, 0, 68, 0, 0, 0, 0, 0, 0, 0, 232, 48, 2, 0, 240, 48, 2, 0, 248, 48, 2, 0, 0, 49, 2, 0, 8, 49, 2, 0, 16, 49, 2, 0, 24, 49, 2, 0, 32, 49, 2, 0, 40, 49, 2, 0, 48, 49, 2, 0, 56, 49, 2, 0, 64, 49, 2, 0, 72, 49, 2, 0, 0, 0, 0, 0, 46, 106, 112, 103, 0, 0, 0, 0, 46, 103, 105, 102, 0, 0, 0, 0, 46, 116, 105, 102, 0, 0, 0, 0, 46, 112, 99, 116, 0, 0, 0, 0, 46, 112, 105, 99, 0, 0, 0, 0, 46, 105, 102, 102, 0, 0, 0, 0, 46, 100, 105, 98, 0, 0, 0, 0, 46, 116, 103, 97, 0, 0, 0, 0, 46, 112, 99, 120, 0, 0, 0, 0, 46, 112, 110, 103, 0, 0, 0, 0, 46, 106, 112, 101, 103, 0, 0, 0, 46, 116, 105, 102, 102, 0, 0, 0, 46, 98, 109, 112, 0, 0, 0, 0, 98, 121, 116, 101, 115, 0, 0, 0, 111, 98, 106, 101, 99, 116, 0, 0, 112, 104, 111, 116, 111, 0, 0, 0, 109, 111, 114, 101, 0, 0, 0, 0, 99, 108, 105, 99, 107, 32, 104, 101, 114, 101, 0, 0, 0, 0, 0, 0, 176, 49, 2, 0, 184, 49, 2, 0, 192, 49, 2, 0, 200, 49, 2, 0, 208, 49, 2, 0, 216, 49, 2, 0, 247, 3, 0, 0, 248, 3, 0, 0, 249, 3, 0, 0, 250, 3, 0, 0, 251, 3, 0, 0, 252, 3, 0, 0, 46, 119, 97, 118, 0, 0, 0, 0, 46, 97, 117, 0, 0, 0, 0, 0, 46, 97, 105, 102, 102, 0, 0, 0, 46, 115, 110, 100, 0, 0, 0, 0, 46, 114, 97, 0, 0, 0, 0, 0, 46, 114, 109, 0, 0, 0, 0, 0, 114, 101, 102, 114, 101, 115, 104, 0, 104, 116, 116, 112, 58, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 51, 2, 0, 8, 51, 2, 0, 16, 51, 2, 0, 24, 51, 2, 0, 32, 51, 2, 0, 40, 51, 2, 0, 48, 51, 2, 0, 56, 51, 2, 0, 64, 51, 2, 0, 72, 51, 2, 0, 80, 51, 2, 0, 88, 51, 2, 0, 96, 51, 2, 0, 104, 51, 2, 0, 112, 51, 2, 0, 120, 51, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 255, 0, 0, 0, 255, 0, 0, 0, 98, 108, 97, 99, 107, 0, 0, 0, 115, 105, 108, 118, 101, 114, 0, 0, 103, 114, 101, 121, 0, 0, 0, 0, 119, 104, 105, 116, 101, 0, 0, 0, 109, 97, 114, 111, 111, 110, 0, 0, 114, 101, 100, 0, 0, 0, 0, 0, 112, 117, 114, 112, 108, 101, 0, 0, 102, 117, 99, 104, 115, 105, 97, 0, 103, 114, 101, 101, 110, 0, 0, 0, 108, 105, 109, 101, 0, 0, 0, 0, 111, 108, 105, 118, 101, 0, 0, 0, 121, 101, 108, 108, 111, 119, 0, 0, 110, 97, 118, 121, 0, 0, 0, 0, 98, 108, 117, 101, 0, 0, 0, 0, 116, 101, 97, 108, 0, 0, 0, 0, 97, 113, 117, 97, 0, 0, 0, 0, 72, 84, 77, 76, 32, 80, 85, 66, 76, 73, 67, 0, 0, 0, 0, 0, 104, 116, 109, 108, 32, 80, 85, 66, 76, 73, 67, 0, 0, 0, 0, 0, 110, 97, 109, 101, 32, 38, 38, 32, 110, 97, 109, 101, 91, 48, 93, 32, 61, 61, 32, 39, 38, 39, 0, 0, 46, 46, 47, 46, 46, 47, 115, 114, 99, 47, 101, 110, 116, 105, 116, 105, 101, 115, 46, 99, 0, 0, 0, 0, 112, 114, 118, 84, 105, 100, 121, 69, 110, 116, 105, 116, 121, 73, 110, 102, 111, 0, 0, 0, 0, 0, 0, 0, 99, 111, 100, 101, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 118, 101, 114, 115, 105, 111, 110, 115, 32, 33, 61, 32, 78, 85, 76, 76, 0, 0, 0, 0, 0, 0, 0, 0, 37, 120, 0, 0, 0, 0, 0, 0, 37, 117, 0, 0, 0, 0, 0, 0, 8, 64, 2, 0, 255, 31, 7, 0, 34, 0, 0, 0, 16, 64, 2, 0, 255, 31, 7, 0, 38, 0, 0, 0, 24, 64, 2, 0, 252, 31, 1, 0, 39, 0, 0, 0, 32, 64, 2, 0, 255, 31, 7, 0, 60, 0, 0, 0, 40, 64, 2, 0, 255, 31, 7, 0, 62, 0, 0, 0, 48, 64, 2, 0, 255, 31, 6, 0, 160, 0, 0, 0, 56, 64, 2, 0, 255, 31, 6, 0, 161, 0, 0, 0, 64, 64, 2, 0, 255, 31, 6, 0, 162, 0, 0, 0, 72, 64, 2, 0, 255, 31, 6, 0, 163, 0, 0, 0, 80, 64, 2, 0, 255, 31, 6, 0, 164, 0, 0, 0, 88, 64, 2, 0, 255, 31, 6, 0, 165, 0, 0, 0, 96, 64, 2, 0, 255, 31, 6, 0, 166, 0, 0, 0, 104, 64, 2, 0, 255, 31, 6, 0, 167, 0, 0, 0, 112, 64, 2, 0, 255, 31, 6, 0, 168, 0, 0, 0, 120, 64, 2, 0, 255, 31, 6, 0, 169, 0, 0, 0, 128, 64, 2, 0, 255, 31, 6, 0, 170, 0, 0, 0, 136, 64, 2, 0, 255, 31, 6, 0, 171, 0, 0, 0, 144, 64, 2, 0, 255, 31, 6, 0, 172, 0, 0, 0, 152, 64, 2, 0, 255, 31, 6, 0, 173, 0, 0, 0, 160, 64, 2, 0, 255, 31, 6, 0, 174, 0, 0, 0, 168, 64, 2, 0, 255, 31, 6, 0, 175, 0, 0, 0, 176, 64, 2, 0, 255, 31, 6, 0, 176, 0, 0, 0, 184, 64, 2, 0, 255, 31, 6, 0, 177, 0, 0, 0, 192, 64, 2, 0, 255, 31, 6, 0, 178, 0, 0, 0, 200, 64, 2, 0, 255, 31, 6, 0, 179, 0, 0, 0, 208, 64, 2, 0, 255, 31, 6, 0, 180, 0, 0, 0, 216, 64, 2, 0, 255, 31, 6, 0, 181, 0, 0, 0, 224, 64, 2, 0, 255, 31, 6, 0, 182, 0, 0, 0, 232, 64, 2, 0, 255, 31, 6, 0, 183, 0, 0, 0, 240, 64, 2, 0, 255, 31, 6, 0, 184, 0, 0, 0, 248, 64, 2, 0, 255, 31, 6, 0, 185, 0, 0, 0, 0, 65, 2, 0, 255, 31, 6, 0, 186, 0, 0, 0, 8, 65, 2, 0, 255, 31, 6, 0, 187, 0, 0, 0, 16, 65, 2, 0, 255, 31, 6, 0, 188, 0, 0, 0, 24, 65, 2, 0, 255, 31, 6, 0, 189, 0, 0, 0, 32, 65, 2, 0, 255, 31, 6, 0, 190, 0, 0, 0, 40, 65, 2, 0, 255, 31, 6, 0, 191, 0, 0, 0, 48, 65, 2, 0, 255, 31, 6, 0, 192, 0, 0, 0, 56, 65, 2, 0, 255, 31, 6, 0, 193, 0, 0, 0, 64, 65, 2, 0, 255, 31, 6, 0, 194, 0, 0, 0, 72, 65, 2, 0, 255, 31, 6, 0, 195, 0, 0, 0, 80, 65, 2, 0, 255, 31, 6, 0, 196, 0, 0, 0, 88, 65, 2, 0, 255, 31, 6, 0, 197, 0, 0, 0, 96, 65, 2, 0, 255, 31, 6, 0, 198, 0, 0, 0, 104, 65, 2, 0, 255, 31, 6, 0, 199, 0, 0, 0, 112, 65, 2, 0, 255, 31, 6, 0, 200, 0, 0, 0, 120, 65, 2, 0, 255, 31, 6, 0, 201, 0, 0, 0, 128, 65, 2, 0, 255, 31, 6, 0, 202, 0, 0, 0, 136, 65, 2, 0, 255, 31, 6, 0, 203, 0, 0, 0, 144, 65, 2, 0, 255, 31, 6, 0, 204, 0, 0, 0, 152, 65, 2, 0, 255, 31, 6, 0, 205, 0, 0, 0, 160, 65, 2, 0, 255, 31, 6, 0, 206, 0, 0, 0, 168, 65, 2, 0, 255, 31, 6, 0, 207, 0, 0, 0, 176, 65, 2, 0, 255, 31, 6, 0, 208, 0, 0, 0, 184, 65, 2, 0, 255, 31, 6, 0, 209, 0, 0, 0, 192, 65, 2, 0, 255, 31, 6, 0, 210, 0, 0, 0, 200, 65, 2, 0, 255, 31, 6, 0, 211, 0, 0, 0, 208, 65, 2, 0, 255, 31, 6, 0, 212, 0, 0, 0, 216, 65, 2, 0, 255, 31, 6, 0, 213, 0, 0, 0, 224, 65, 2, 0, 255, 31, 6, 0, 214, 0, 0, 0, 232, 65, 2, 0, 255, 31, 6, 0, 215, 0, 0, 0, 240, 65, 2, 0, 255, 31, 6, 0, 216, 0, 0, 0, 248, 65, 2, 0, 255, 31, 6, 0, 217, 0, 0, 0, 0, 66, 2, 0, 255, 31, 6, 0, 218, 0, 0, 0, 8, 66, 2, 0, 255, 31, 6, 0, 219, 0, 0, 0, 16, 66, 2, 0, 255, 31, 6, 0, 220, 0, 0, 0, 24, 66, 2, 0, 255, 31, 6, 0, 221, 0, 0, 0, 32, 66, 2, 0, 255, 31, 6, 0, 222, 0, 0, 0, 40, 66, 2, 0, 255, 31, 6, 0, 223, 0, 0, 0, 48, 66, 2, 0, 255, 31, 6, 0, 224, 0, 0, 0, 56, 66, 2, 0, 255, 31, 6, 0, 225, 0, 0, 0, 64, 66, 2, 0, 255, 31, 6, 0, 226, 0, 0, 0, 72, 66, 2, 0, 255, 31, 6, 0, 227, 0, 0, 0, 80, 66, 2, 0, 255, 31, 6, 0, 228, 0, 0, 0, 88, 66, 2, 0, 255, 31, 6, 0, 229, 0, 0, 0, 96, 66, 2, 0, 255, 31, 6, 0, 230, 0, 0, 0, 104, 66, 2, 0, 255, 31, 6, 0, 231, 0, 0, 0, 112, 66, 2, 0, 255, 31, 6, 0, 232, 0, 0, 0, 120, 66, 2, 0, 255, 31, 6, 0, 233, 0, 0, 0, 128, 66, 2, 0, 255, 31, 6, 0, 234, 0, 0, 0, 136, 66, 2, 0, 255, 31, 6, 0, 235, 0, 0, 0, 144, 66, 2, 0, 255, 31, 6, 0, 236, 0, 0, 0, 152, 66, 2, 0, 255, 31, 6, 0, 237, 0, 0, 0, 160, 66, 2, 0, 255, 31, 6, 0, 238, 0, 0, 0, 168, 66, 2, 0, 255, 31, 6, 0, 239, 0, 0, 0, 176, 66, 2, 0, 255, 31, 6, 0, 240, 0, 0, 0, 184, 66, 2, 0, 255, 31, 6, 0, 241, 0, 0, 0, 192, 66, 2, 0, 255, 31, 6, 0, 242, 0, 0, 0, 200, 66, 2, 0, 255, 31, 6, 0, 243, 0, 0, 0, 208, 66, 2, 0, 255, 31, 6, 0, 244, 0, 0, 0, 216, 66, 2, 0, 255, 31, 6, 0, 245, 0, 0, 0, 224, 66, 2, 0, 255, 31, 6, 0, 246, 0, 0, 0, 232, 66, 2, 0, 255, 31, 6, 0, 247, 0, 0, 0, 240, 66, 2, 0, 255, 31, 6, 0, 248, 0, 0, 0, 248, 66, 2, 0, 255, 31, 6, 0, 249, 0, 0, 0, 0, 67, 2, 0, 255, 31, 6, 0, 250, 0, 0, 0, 8, 67, 2, 0, 255, 31, 6, 0, 251, 0, 0, 0, 16, 67, 2, 0, 255, 31, 6, 0, 252, 0, 0, 0, 24, 67, 2, 0, 255, 31, 6, 0, 253, 0, 0, 0, 32, 67, 2, 0, 255, 31, 6, 0, 254, 0, 0, 0, 40, 67, 2, 0, 255, 31, 6, 0, 255, 0, 0, 0, 48, 67, 2, 0, 252, 31, 0, 0, 146, 1, 0, 0, 56, 67, 2, 0, 252, 31, 0, 0, 145, 3, 0, 0, 64, 67, 2, 0, 252, 31, 0, 0, 146, 3, 0, 0, 72, 67, 2, 0, 252, 31, 0, 0, 147, 3, 0, 0, 80, 67, 2, 0, 252, 31, 0, 0, 148, 3, 0, 0, 88, 67, 2, 0, 252, 31, 0, 0, 149, 3, 0, 0, 96, 67, 2, 0, 252, 31, 0, 0, 150, 3, 0, 0, 104, 67, 2, 0, 252, 31, 0, 0, 151, 3, 0, 0, 112, 67, 2, 0, 252, 31, 0, 0, 152, 3, 0, 0, 120, 67, 2, 0, 252, 31, 0, 0, 153, 3, 0, 0, 128, 67, 2, 0, 252, 31, 0, 0, 154, 3, 0, 0, 136, 67, 2, 0, 252, 31, 0, 0, 155, 3, 0, 0, 144, 67, 2, 0, 252, 31, 0, 0, 156, 3, 0, 0, 152, 67, 2, 0, 252, 31, 0, 0, 157, 3, 0, 0, 160, 67, 2, 0, 252, 31, 0, 0, 158, 3, 0, 0, 168, 67, 2, 0, 252, 31, 0, 0, 159, 3, 0, 0, 176, 67, 2, 0, 252, 31, 0, 0, 160, 3, 0, 0, 184, 67, 2, 0, 252, 31, 0, 0, 161, 3, 0, 0, 192, 67, 2, 0, 252, 31, 0, 0, 163, 3, 0, 0, 200, 67, 2, 0, 252, 31, 0, 0, 164, 3, 0, 0, 208, 67, 2, 0, 252, 31, 0, 0, 165, 3, 0, 0, 216, 67, 2, 0, 252, 31, 0, 0, 166, 3, 0, 0, 224, 67, 2, 0, 252, 31, 0, 0, 167, 3, 0, 0, 232, 67, 2, 0, 252, 31, 0, 0, 168, 3, 0, 0, 240, 67, 2, 0, 252, 31, 0, 0, 169, 3, 0, 0, 248, 67, 2, 0, 252, 31, 0, 0, 177, 3, 0, 0, 0, 68, 2, 0, 252, 31, 0, 0, 178, 3, 0, 0, 8, 68, 2, 0, 252, 31, 0, 0, 179, 3, 0, 0, 16, 68, 2, 0, 252, 31, 0, 0, 180, 3, 0, 0, 24, 68, 2, 0, 252, 31, 0, 0, 181, 3, 0, 0, 32, 68, 2, 0, 252, 31, 0, 0, 182, 3, 0, 0, 40, 68, 2, 0, 252, 31, 0, 0, 183, 3, 0, 0, 48, 68, 2, 0, 252, 31, 0, 0, 184, 3, 0, 0, 56, 68, 2, 0, 252, 31, 0, 0, 185, 3, 0, 0, 64, 68, 2, 0, 252, 31, 0, 0, 186, 3, 0, 0, 72, 68, 2, 0, 252, 31, 0, 0, 187, 3, 0, 0, 80, 68, 2, 0, 252, 31, 0, 0, 188, 3, 0, 0, 88, 68, 2, 0, 252, 31, 0, 0, 189, 3, 0, 0, 96, 68, 2, 0, 252, 31, 0, 0, 190, 3, 0, 0, 104, 68, 2, 0, 252, 31, 0, 0, 191, 3, 0, 0, 112, 68, 2, 0, 252, 31, 0, 0, 192, 3, 0, 0, 120, 68, 2, 0, 252, 31, 0, 0, 193, 3, 0, 0, 128, 68, 2, 0, 252, 31, 0, 0, 194, 3, 0, 0, 136, 68, 2, 0, 252, 31, 0, 0, 195, 3, 0, 0, 144, 68, 2, 0, 252, 31, 0, 0, 196, 3, 0, 0, 152, 68, 2, 0, 252, 31, 0, 0, 197, 3, 0, 0, 160, 68, 2, 0, 252, 31, 0, 0, 198, 3, 0, 0, 168, 68, 2, 0, 252, 31, 0, 0, 199, 3, 0, 0, 176, 68, 2, 0, 252, 31, 0, 0, 200, 3, 0, 0, 184, 68, 2, 0, 252, 31, 0, 0, 201, 3, 0, 0, 192, 68, 2, 0, 252, 31, 0, 0, 209, 3, 0, 0, 208, 68, 2, 0, 252, 31, 0, 0, 210, 3, 0, 0, 216, 68, 2, 0, 252, 31, 0, 0, 214, 3, 0, 0, 224, 68, 2, 0, 252, 31, 0, 0, 34, 32, 0, 0, 232, 68, 2, 0, 252, 31, 0, 0, 38, 32, 0, 0, 240, 68, 2, 0, 252, 31, 0, 0, 50, 32, 0, 0, 248, 68, 2, 0, 252, 31, 0, 0, 51, 32, 0, 0, 0, 69, 2, 0, 252, 31, 0, 0, 62, 32, 0, 0, 8, 69, 2, 0, 252, 31, 0, 0, 68, 32, 0, 0, 16, 69, 2, 0, 252, 31, 0, 0, 24, 33, 0, 0, 24, 69, 2, 0, 252, 31, 0, 0, 17, 33, 0, 0, 32, 69, 2, 0, 252, 31, 0, 0, 28, 33, 0, 0, 40, 69, 2, 0, 252, 31, 0, 0, 34, 33, 0, 0, 48, 69, 2, 0, 252, 31, 0, 0, 53, 33, 0, 0, 56, 69, 2, 0, 252, 31, 0, 0, 144, 33, 0, 0, 64, 69, 2, 0, 252, 31, 0, 0, 145, 33, 0, 0, 72, 69, 2, 0, 252, 31, 0, 0, 146, 33, 0, 0, 80, 69, 2, 0, 252, 31, 0, 0, 147, 33, 0, 0, 88, 69, 2, 0, 252, 31, 0, 0, 148, 33, 0, 0, 96, 69, 2, 0, 252, 31, 0, 0, 181, 33, 0, 0, 104, 69, 2, 0, 252, 31, 0, 0, 208, 33, 0, 0, 112, 69, 2, 0, 252, 31, 0, 0, 209, 33, 0, 0, 120, 69, 2, 0, 252, 31, 0, 0, 210, 33, 0, 0, 128, 69, 2, 0, 252, 31, 0, 0, 211, 33, 0, 0, 136, 69, 2, 0, 252, 31, 0, 0, 212, 33, 0, 0, 144, 69, 2, 0, 252, 31, 0, 0, 0, 34, 0, 0, 152, 69, 2, 0, 252, 31, 0, 0, 2, 34, 0, 0, 160, 69, 2, 0, 252, 31, 0, 0, 3, 34, 0, 0, 168, 69, 2, 0, 252, 31, 0, 0, 5, 34, 0, 0, 176, 69, 2, 0, 252, 31, 0, 0, 7, 34, 0, 0, 184, 69, 2, 0, 252, 31, 0, 0, 8, 34, 0, 0, 192, 69, 2, 0, 252, 31, 0, 0, 9, 34, 0, 0, 200, 69, 2, 0, 252, 31, 0, 0, 11, 34, 0, 0, 208, 69, 2, 0, 252, 31, 0, 0, 15, 34, 0, 0, 216, 69, 2, 0, 252, 31, 0, 0, 17, 34, 0, 0, 224, 69, 2, 0, 252, 31, 0, 0, 18, 34, 0, 0, 232, 69, 2, 0, 252, 31, 0, 0, 23, 34, 0, 0, 240, 69, 2, 0, 252, 31, 0, 0, 26, 34, 0, 0, 248, 69, 2, 0, 252, 31, 0, 0, 29, 34, 0, 0, 0, 70, 2, 0, 252, 31, 0, 0, 30, 34, 0, 0, 8, 70, 2, 0, 252, 31, 0, 0, 32, 34, 0, 0, 16, 70, 2, 0, 252, 31, 0, 0, 39, 34, 0, 0, 24, 70, 2, 0, 252, 31, 0, 0, 40, 34, 0, 0, 32, 70, 2, 0, 252, 31, 0, 0, 41, 34, 0, 0, 40, 70, 2, 0, 252, 31, 0, 0, 42, 34, 0, 0, 48, 70, 2, 0, 252, 31, 0, 0, 43, 34, 0, 0, 56, 70, 2, 0, 252, 31, 0, 0, 52, 34, 0, 0, 64, 70, 2, 0, 252, 31, 0, 0, 60, 34, 0, 0, 72, 70, 2, 0, 252, 31, 0, 0, 69, 34, 0, 0, 80, 70, 2, 0, 252, 31, 0, 0, 72, 34, 0, 0, 88, 70, 2, 0, 252, 31, 0, 0, 96, 34, 0, 0, 96, 70, 2, 0, 252, 31, 0, 0, 97, 34, 0, 0, 104, 70, 2, 0, 252, 31, 0, 0, 100, 34, 0, 0, 112, 70, 2, 0, 252, 31, 0, 0, 101, 34, 0, 0, 120, 70, 2, 0, 252, 31, 0, 0, 130, 34, 0, 0, 128, 70, 2, 0, 252, 31, 0, 0, 131, 34, 0, 0, 136, 70, 2, 0, 252, 31, 0, 0, 132, 34, 0, 0, 144, 70, 2, 0, 252, 31, 0, 0, 134, 34, 0, 0, 152, 70, 2, 0, 252, 31, 0, 0, 135, 34, 0, 0, 160, 70, 2, 0, 252, 31, 0, 0, 149, 34, 0, 0, 168, 70, 2, 0, 252, 31, 0, 0, 151, 34, 0, 0, 176, 70, 2, 0, 252, 31, 0, 0, 165, 34, 0, 0, 184, 70, 2, 0, 252, 31, 0, 0, 197, 34, 0, 0, 192, 70, 2, 0, 252, 31, 0, 0, 8, 35, 0, 0, 200, 70, 2, 0, 252, 31, 0, 0, 9, 35, 0, 0, 208, 70, 2, 0, 252, 31, 0, 0, 10, 35, 0, 0, 216, 70, 2, 0, 252, 31, 0, 0, 11, 35, 0, 0, 224, 70, 2, 0, 252, 31, 0, 0, 41, 35, 0, 0, 232, 70, 2, 0, 252, 31, 0, 0, 42, 35, 0, 0, 240, 70, 2, 0, 252, 31, 0, 0, 202, 37, 0, 0, 248, 70, 2, 0, 252, 31, 0, 0, 96, 38, 0, 0, 0, 71, 2, 0, 252, 31, 0, 0, 99, 38, 0, 0, 8, 71, 2, 0, 252, 31, 0, 0, 101, 38, 0, 0, 16, 71, 2, 0, 252, 31, 0, 0, 102, 38, 0, 0, 24, 71, 2, 0, 252, 31, 0, 0, 82, 1, 0, 0, 32, 71, 2, 0, 252, 31, 0, 0, 83, 1, 0, 0, 40, 71, 2, 0, 252, 31, 0, 0, 96, 1, 0, 0, 48, 71, 2, 0, 252, 31, 0, 0, 97, 1, 0, 0, 56, 71, 2, 0, 252, 31, 0, 0, 120, 1, 0, 0, 64, 71, 2, 0, 252, 31, 0, 0, 198, 2, 0, 0, 72, 71, 2, 0, 252, 31, 0, 0, 220, 2, 0, 0, 80, 71, 2, 0, 252, 31, 0, 0, 2, 32, 0, 0, 88, 71, 2, 0, 252, 31, 0, 0, 3, 32, 0, 0, 96, 71, 2, 0, 252, 31, 0, 0, 9, 32, 0, 0, 104, 71, 2, 0, 252, 31, 0, 0, 12, 32, 0, 0, 112, 71, 2, 0, 252, 31, 0, 0, 13, 32, 0, 0, 120, 71, 2, 0, 252, 31, 0, 0, 14, 32, 0, 0, 128, 71, 2, 0, 252, 31, 0, 0, 15, 32, 0, 0, 136, 71, 2, 0, 252, 31, 0, 0, 19, 32, 0, 0, 144, 71, 2, 0, 252, 31, 0, 0, 20, 32, 0, 0, 152, 71, 2, 0, 252, 31, 0, 0, 24, 32, 0, 0, 160, 71, 2, 0, 252, 31, 0, 0, 25, 32, 0, 0, 168, 71, 2, 0, 252, 31, 0, 0, 26, 32, 0, 0, 176, 71, 2, 0, 252, 31, 0, 0, 28, 32, 0, 0, 184, 71, 2, 0, 252, 31, 0, 0, 29, 32, 0, 0, 192, 71, 2, 0, 252, 31, 0, 0, 30, 32, 0, 0, 200, 71, 2, 0, 252, 31, 0, 0, 32, 32, 0, 0, 208, 71, 2, 0, 252, 31, 0, 0, 33, 32, 0, 0, 216, 71, 2, 0, 252, 31, 0, 0, 48, 32, 0, 0, 224, 71, 2, 0, 252, 31, 0, 0, 57, 32, 0, 0, 232, 71, 2, 0, 252, 31, 0, 0, 58, 32, 0, 0, 240, 71, 2, 0, 252, 31, 0, 0, 172, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 117, 111, 116, 0, 0, 0, 0, 97, 109, 112, 0, 0, 0, 0, 0, 97, 112, 111, 115, 0, 0, 0, 0, 108, 116, 0, 0, 0, 0, 0, 0, 103, 116, 0, 0, 0, 0, 0, 0, 110, 98, 115, 112, 0, 0, 0, 0, 105, 101, 120, 99, 108, 0, 0, 0, 99, 101, 110, 116, 0, 0, 0, 0, 112, 111, 117, 110, 100, 0, 0, 0, 99, 117, 114, 114, 101, 110, 0, 0, 121, 101, 110, 0, 0, 0, 0, 0, 98, 114, 118, 98, 97, 114, 0, 0, 115, 101, 99, 116, 0, 0, 0, 0, 117, 109, 108, 0, 0, 0, 0, 0, 99, 111, 112, 121, 0, 0, 0, 0, 111, 114, 100, 102, 0, 0, 0, 0, 108, 97, 113, 117, 111, 0, 0, 0, 110, 111, 116, 0, 0, 0, 0, 0, 115, 104, 121, 0, 0, 0, 0, 0, 114, 101, 103, 0, 0, 0, 0, 0, 109, 97, 99, 114, 0, 0, 0, 0, 100, 101, 103, 0, 0, 0, 0, 0, 112, 108, 117, 115, 109, 110, 0, 0, 115, 117, 112, 50, 0, 0, 0, 0, 115, 117, 112, 51, 0, 0, 0, 0, 97, 99, 117, 116, 101, 0, 0, 0, 109, 105, 99, 114, 111, 0, 0, 0, 112, 97, 114, 97, 0, 0, 0, 0, 109, 105, 100, 100, 111, 116, 0, 0, 99, 101, 100, 105, 108, 0, 0, 0, 115, 117, 112, 49, 0, 0, 0, 0, 111, 114, 100, 109, 0, 0, 0, 0, 114, 97, 113, 117, 111, 0, 0, 0, 102, 114, 97, 99, 49, 52, 0, 0, 102, 114, 97, 99, 49, 50, 0, 0, 102, 114, 97, 99, 51, 52, 0, 0, 105, 113, 117, 101, 115, 116, 0, 0, 65, 103, 114, 97, 118, 101, 0, 0, 65, 97, 99, 117, 116, 101, 0, 0, 65, 99, 105, 114, 99, 0, 0, 0, 65, 116, 105, 108, 100, 101, 0, 0, 65, 117, 109, 108, 0, 0, 0, 0, 65, 114, 105, 110, 103, 0, 0, 0, 65, 69, 108, 105, 103, 0, 0, 0, 67, 99, 101, 100, 105, 108, 0, 0, 69, 103, 114, 97, 118, 101, 0, 0, 69, 97, 99, 117, 116, 101, 0, 0, 69, 99, 105, 114, 99, 0, 0, 0, 69, 117, 109, 108, 0, 0, 0, 0, 73, 103, 114, 97, 118, 101, 0, 0, 73, 97, 99, 117, 116, 101, 0, 0, 73, 99, 105, 114, 99, 0, 0, 0, 73, 117, 109, 108, 0, 0, 0, 0, 69, 84, 72, 0, 0, 0, 0, 0, 78, 116, 105, 108, 100, 101, 0, 0, 79, 103, 114, 97, 118, 101, 0, 0, 79, 97, 99, 117, 116, 101, 0, 0, 79, 99, 105, 114, 99, 0, 0, 0, 79, 116, 105, 108, 100, 101, 0, 0, 79, 117, 109, 108, 0, 0, 0, 0, 116, 105, 109, 101, 115, 0, 0, 0, 79, 115, 108, 97, 115, 104, 0, 0, 85, 103, 114, 97, 118, 101, 0, 0, 85, 97, 99, 117, 116, 101, 0, 0, 85, 99, 105, 114, 99, 0, 0, 0, 85, 117, 109, 108, 0, 0, 0, 0, 89, 97, 99, 117, 116, 101, 0, 0, 84, 72, 79, 82, 78, 0, 0, 0, 115, 122, 108, 105, 103, 0, 0, 0, 97, 103, 114, 97, 118, 101, 0, 0, 97, 97, 99, 117, 116, 101, 0, 0, 97, 99, 105, 114, 99, 0, 0, 0, 97, 116, 105, 108, 100, 101, 0, 0, 97, 117, 109, 108, 0, 0, 0, 0, 97, 114, 105, 110, 103, 0, 0, 0, 97, 101, 108, 105, 103, 0, 0, 0, 99, 99, 101, 100, 105, 108, 0, 0, 101, 103, 114, 97, 118, 101, 0, 0, 101, 97, 99, 117, 116, 101, 0, 0, 101, 99, 105, 114, 99, 0, 0, 0, 101, 117, 109, 108, 0, 0, 0, 0, 105, 103, 114, 97, 118, 101, 0, 0, 105, 97, 99, 117, 116, 101, 0, 0, 105, 99, 105, 114, 99, 0, 0, 0, 105, 117, 109, 108, 0, 0, 0, 0, 101, 116, 104, 0, 0, 0, 0, 0, 110, 116, 105, 108, 100, 101, 0, 0, 111, 103, 114, 97, 118, 101, 0, 0, 111, 97, 99, 117, 116, 101, 0, 0, 111, 99, 105, 114, 99, 0, 0, 0, 111, 116, 105, 108, 100, 101, 0, 0, 111, 117, 109, 108, 0, 0, 0, 0, 100, 105, 118, 105, 100, 101, 0, 0, 111, 115, 108, 97, 115, 104, 0, 0, 117, 103, 114, 97, 118, 101, 0, 0, 117, 97, 99, 117, 116, 101, 0, 0, 117, 99, 105, 114, 99, 0, 0, 0, 117, 117, 109, 108, 0, 0, 0, 0, 121, 97, 99, 117, 116, 101, 0, 0, 116, 104, 111, 114, 110, 0, 0, 0, 121, 117, 109, 108, 0, 0, 0, 0, 102, 110, 111, 102, 0, 0, 0, 0, 65, 108, 112, 104, 97, 0, 0, 0, 66, 101, 116, 97, 0, 0, 0, 0, 71, 97, 109, 109, 97, 0, 0, 0, 68, 101, 108, 116, 97, 0, 0, 0, 69, 112, 115, 105, 108, 111, 110, 0, 90, 101, 116, 97, 0, 0, 0, 0, 69, 116, 97, 0, 0, 0, 0, 0, 84, 104, 101, 116, 97, 0, 0, 0, 73, 111, 116, 97, 0, 0, 0, 0, 75, 97, 112, 112, 97, 0, 0, 0, 76, 97, 109, 98, 100, 97, 0, 0, 77, 117, 0, 0, 0, 0, 0, 0, 78, 117, 0, 0, 0, 0, 0, 0, 88, 105, 0, 0, 0, 0, 0, 0, 79, 109, 105, 99, 114, 111, 110, 0, 80, 105, 0, 0, 0, 0, 0, 0, 82, 104, 111, 0, 0, 0, 0, 0, 83, 105, 103, 109, 97, 0, 0, 0, 84, 97, 117, 0, 0, 0, 0, 0, 85, 112, 115, 105, 108, 111, 110, 0, 80, 104, 105, 0, 0, 0, 0, 0, 67, 104, 105, 0, 0, 0, 0, 0, 80, 115, 105, 0, 0, 0, 0, 0, 79, 109, 101, 103, 97, 0, 0, 0, 97, 108, 112, 104, 97, 0, 0, 0, 98, 101, 116, 97, 0, 0, 0, 0, 103, 97, 109, 109, 97, 0, 0, 0, 100, 101, 108, 116, 97, 0, 0, 0, 101, 112, 115, 105, 108, 111, 110, 0, 122, 101, 116, 97, 0, 0, 0, 0, 101, 116, 97, 0, 0, 0, 0, 0, 116, 104, 101, 116, 97, 0, 0, 0, 105, 111, 116, 97, 0, 0, 0, 0, 107, 97, 112, 112, 97, 0, 0, 0, 108, 97, 109, 98, 100, 97, 0, 0, 109, 117, 0, 0, 0, 0, 0, 0, 110, 117, 0, 0, 0, 0, 0, 0, 120, 105, 0, 0, 0, 0, 0, 0, 111, 109, 105, 99, 114, 111, 110, 0, 112, 105, 0, 0, 0, 0, 0, 0, 114, 104, 111, 0, 0, 0, 0, 0, 115, 105, 103, 109, 97, 102, 0, 0, 115, 105, 103, 109, 97, 0, 0, 0, 116, 97, 117, 0, 0, 0, 0, 0, 117, 112, 115, 105, 108, 111, 110, 0, 112, 104, 105, 0, 0, 0, 0, 0, 99, 104, 105, 0, 0, 0, 0, 0, 112, 115, 105, 0, 0, 0, 0, 0, 111, 109, 101, 103, 97, 0, 0, 0, 116, 104, 101, 116, 97, 115, 121, 109, 0, 0, 0, 0, 0, 0, 0, 0, 117, 112, 115, 105, 104, 0, 0, 0, 112, 105, 118, 0, 0, 0, 0, 0, 98, 117, 108, 108, 0, 0, 0, 0, 104, 101, 108, 108, 105, 112, 0, 0, 112, 114, 105, 109, 101, 0, 0, 0, 80, 114, 105, 109, 101, 0, 0, 0, 111, 108, 105, 110, 101, 0, 0, 0, 102, 114, 97, 115, 108, 0, 0, 0, 119, 101, 105, 101, 114, 112, 0, 0, 105, 109, 97, 103, 101, 0, 0, 0, 114, 101, 97, 108, 0, 0, 0, 0, 116, 114, 97, 100, 101, 0, 0, 0, 97, 108, 101, 102, 115, 121, 109, 0, 108, 97, 114, 114, 0, 0, 0, 0, 117, 97, 114, 114, 0, 0, 0, 0, 114, 97, 114, 114, 0, 0, 0, 0, 100, 97, 114, 114, 0, 0, 0, 0, 104, 97, 114, 114, 0, 0, 0, 0, 99, 114, 97, 114, 114, 0, 0, 0, 108, 65, 114, 114, 0, 0, 0, 0, 117, 65, 114, 114, 0, 0, 0, 0, 114, 65, 114, 114, 0, 0, 0, 0, 100, 65, 114, 114, 0, 0, 0, 0, 104, 65, 114, 114, 0, 0, 0, 0, 102, 111, 114, 97, 108, 108, 0, 0, 112, 97, 114, 116, 0, 0, 0, 0, 101, 120, 105, 115, 116, 0, 0, 0, 101, 109, 112, 116, 121, 0, 0, 0, 110, 97, 98, 108, 97, 0, 0, 0, 105, 115, 105, 110, 0, 0, 0, 0, 110, 111, 116, 105, 110, 0, 0, 0, 110, 105, 0, 0, 0, 0, 0, 0, 112, 114, 111, 100, 0, 0, 0, 0, 115, 117, 109, 0, 0, 0, 0, 0, 109, 105, 110, 117, 115, 0, 0, 0, 108, 111, 119, 97, 115, 116, 0, 0, 114, 97, 100, 105, 99, 0, 0, 0, 112, 114, 111, 112, 0, 0, 0, 0, 105, 110, 102, 105, 110, 0, 0, 0, 97, 110, 103, 0, 0, 0, 0, 0, 97, 110, 100, 0, 0, 0, 0, 0, 111, 114, 0, 0, 0, 0, 0, 0, 99, 97, 112, 0, 0, 0, 0, 0, 99, 117, 112, 0, 0, 0, 0, 0, 105, 110, 116, 0, 0, 0, 0, 0, 116, 104, 101, 114, 101, 52, 0, 0, 115, 105, 109, 0, 0, 0, 0, 0, 99, 111, 110, 103, 0, 0, 0, 0, 97, 115, 121, 109, 112, 0, 0, 0, 110, 101, 0, 0, 0, 0, 0, 0, 101, 113, 117, 105, 118, 0, 0, 0, 108, 101, 0, 0, 0, 0, 0, 0, 103, 101, 0, 0, 0, 0, 0, 0, 115, 117, 98, 0, 0, 0, 0, 0, 115, 117, 112, 0, 0, 0, 0, 0, 110, 115, 117, 98, 0, 0, 0, 0, 115, 117, 98, 101, 0, 0, 0, 0, 115, 117, 112, 101, 0, 0, 0, 0, 111, 112, 108, 117, 115, 0, 0, 0, 111, 116, 105, 109, 101, 115, 0, 0, 112, 101, 114, 112, 0, 0, 0, 0, 115, 100, 111, 116, 0, 0, 0, 0, 108, 99, 101, 105, 108, 0, 0, 0, 114, 99, 101, 105, 108, 0, 0, 0, 108, 102, 108, 111, 111, 114, 0, 0, 114, 102, 108, 111, 111, 114, 0, 0, 108, 97, 110, 103, 0, 0, 0, 0, 114, 97, 110, 103, 0, 0, 0, 0, 108, 111, 122, 0, 0, 0, 0, 0, 115, 112, 97, 100, 101, 115, 0, 0, 99, 108, 117, 98, 115, 0, 0, 0, 104, 101, 97, 114, 116, 115, 0, 0, 100, 105, 97, 109, 115, 0, 0, 0, 79, 69, 108, 105, 103, 0, 0, 0, 111, 101, 108, 105, 103, 0, 0, 0, 83, 99, 97, 114, 111, 110, 0, 0, 115, 99, 97, 114, 111, 110, 0, 0, 89, 117, 109, 108, 0, 0, 0, 0, 99, 105, 114, 99, 0, 0, 0, 0, 116, 105, 108, 100, 101, 0, 0, 0, 101, 110, 115, 112, 0, 0, 0, 0, 101, 109, 115, 112, 0, 0, 0, 0, 116, 104, 105, 110, 115, 112, 0, 0, 122, 119, 110, 106, 0, 0, 0, 0, 122, 119, 106, 0, 0, 0, 0, 0, 108, 114, 109, 0, 0, 0, 0, 0, 114, 108, 109, 0, 0, 0, 0, 0, 110, 100, 97, 115, 104, 0, 0, 0, 109, 100, 97, 115, 104, 0, 0, 0, 108, 115, 113, 117, 111, 0, 0, 0, 114, 115, 113, 117, 111, 0, 0, 0, 115, 98, 113, 117, 111, 0, 0, 0, 108, 100, 113, 117, 111, 0, 0, 0, 114, 100, 113, 117, 111, 0, 0, 0, 98, 100, 113, 117, 111, 0, 0, 0, 100, 97, 103, 103, 101, 114, 0, 0, 68, 97, 103, 103, 101, 114, 0, 0, 112, 101, 114, 109, 105, 108, 0, 0, 108, 115, 97, 113, 117, 111, 0, 0, 114, 115, 97, 113, 117, 111, 0, 0, 101, 117, 114, 111, 0, 0, 0, 0, 2, 0, 0, 192, 3, 0, 0, 192, 4, 0, 0, 192, 5, 0, 0, 192, 6, 0, 0, 192, 7, 0, 0, 192, 8, 0, 0, 192, 9, 0, 0, 192, 10, 0, 0, 192, 11, 0, 0, 192, 12, 0, 0, 192, 13, 0, 0, 192, 14, 0, 0, 192, 15, 0, 0, 192, 16, 0, 0, 192, 17, 0, 0, 192, 18, 0, 0, 192, 19, 0, 0, 192, 20, 0, 0, 192, 21, 0, 0, 192, 22, 0, 0, 192, 23, 0, 0, 192, 24, 0, 0, 192, 25, 0, 0, 192, 26, 0, 0, 192, 27, 0, 0, 192, 28, 0, 0, 192, 29, 0, 0, 192, 30, 0, 0, 192, 31, 0, 0, 192, 0, 0, 0, 179, 1, 0, 0, 195, 2, 0, 0, 195, 3, 0, 0, 195, 4, 0, 0, 195, 5, 0, 0, 195, 6, 0, 0, 195, 7, 0, 0, 195, 8, 0, 0, 195, 9, 0, 0, 195, 10, 0, 0, 195, 11, 0, 0, 195, 12, 0, 0, 195, 13, 0, 0, 211, 14, 0, 0, 195, 15, 0, 0, 195, 0, 0, 12, 187, 1, 0, 12, 195, 2, 0, 12, 195, 3, 0, 12, 195, 4, 0, 12, 211, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 255, 255, 255, 255, 255, 255, 255, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 255, 255, 255, 255, 255, 255, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 4, 7, 3, 6, 5, 0, 0, 0, 0, 0, 0, 0, 0, 105, 110, 102, 105, 110, 105, 116, 121, 0, 0, 0, 0, 0, 0, 0, 0, 110, 97, 110, 0, 0, 0, 0, 0, 95, 112, 137, 0, 255, 9, 47, 15, 10, 0, 0, 0, 100, 0, 0, 0, 232, 3, 0, 0, 16, 39, 0, 0, 160, 134, 1, 0, 64, 66, 15, 0, 128, 150, 152, 0, 0, 225, 245, 5, 17, 0, 10, 0, 17, 17, 17, 0, 0, 0, 0, 5, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 15, 10, 17, 17, 17, 3, 10, 7, 0, 1, 19, 9, 11, 11, 0, 0, 9, 6, 11, 0, 0, 11, 0, 6, 17, 0, 0, 0, 17, 17, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 17, 0, 10, 10, 17, 17, 17, 0, 10, 0, 0, 2, 0, 9, 11, 0, 0, 0, 9, 0, 11, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 0, 0, 0, 0, 9, 12, 0, 0, 0, 0, 0, 12, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 0, 0, 0, 4, 13, 0, 0, 0, 0, 9, 14, 0, 0, 0, 0, 0, 14, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 15, 0, 0, 0, 0, 9, 16, 0, 0, 0, 0, 0, 16, 0, 0, 16, 0, 0, 18, 0, 0, 0, 18, 18, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 0, 0, 0, 18, 18, 18, 0, 0, 0, 0, 0, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 10, 0, 0, 0, 0, 9, 11, 0, 0, 0, 0, 0, 11, 0, 0, 11, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 12, 0, 0, 0, 0, 9, 12, 0, 0, 0, 0, 0, 12, 0, 0, 12, 0, 0, 45, 43, 32, 32, 32, 48, 88, 48, 120, 0, 0, 0, 0, 0, 0, 0, 40, 110, 117, 108, 108, 41, 0, 0, 45, 48, 88, 43, 48, 88, 32, 48, 88, 45, 48, 120, 43, 48, 120, 32, 48, 120, 0, 0, 0, 0, 0, 0, 105, 110, 102, 0, 0, 0, 0, 0, 73, 78, 70, 0, 0, 0, 0, 0, 110, 97, 110, 0, 0, 0, 0, 0, 78, 65, 78, 0, 0, 0, 0, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "i8", ALLOC_NONE, Runtime.GLOBAL_BASE + 143384);
var tempDoublePtr = Runtime.alignMemory(allocate(12, "i8", ALLOC_STATIC), 8);
assert(tempDoublePtr % 8 == 0);

function copyTempFloat(ptr) {
    HEAP8[tempDoublePtr] = HEAP8[ptr];
    HEAP8[tempDoublePtr + 1] = HEAP8[ptr + 1];
    HEAP8[tempDoublePtr + 2] = HEAP8[ptr + 2];
    HEAP8[tempDoublePtr + 3] = HEAP8[ptr + 3]
}

function copyTempDouble(ptr) {
    HEAP8[tempDoublePtr] = HEAP8[ptr];
    HEAP8[tempDoublePtr + 1] = HEAP8[ptr + 1];
    HEAP8[tempDoublePtr + 2] = HEAP8[ptr + 2];
    HEAP8[tempDoublePtr + 3] = HEAP8[ptr + 3];
    HEAP8[tempDoublePtr + 4] = HEAP8[ptr + 4];
    HEAP8[tempDoublePtr + 5] = HEAP8[ptr + 5];
    HEAP8[tempDoublePtr + 6] = HEAP8[ptr + 6];
    HEAP8[tempDoublePtr + 7] = HEAP8[ptr + 7]
}
Module["_i64Subtract"] = _i64Subtract;

function ___assert_fail(condition, filename, line, func) {
    ABORT = true;
    throw "Assertion failed: " + Pointer_stringify(condition) + ", at: " + [filename ? Pointer_stringify(filename) : "unknown filename", line, func ? Pointer_stringify(func) : "unknown function"] + " at " + stackTrace()
}
var ERRNO_CODES = {
    EPERM: 1,
    ENOENT: 2,
    ESRCH: 3,
    EINTR: 4,
    EIO: 5,
    ENXIO: 6,
    E2BIG: 7,
    ENOEXEC: 8,
    EBADF: 9,
    ECHILD: 10,
    EAGAIN: 11,
    EWOULDBLOCK: 11,
    ENOMEM: 12,
    EACCES: 13,
    EFAULT: 14,
    ENOTBLK: 15,
    EBUSY: 16,
    EEXIST: 17,
    EXDEV: 18,
    ENODEV: 19,
    ENOTDIR: 20,
    EISDIR: 21,
    EINVAL: 22,
    ENFILE: 23,
    EMFILE: 24,
    ENOTTY: 25,
    ETXTBSY: 26,
    EFBIG: 27,
    ENOSPC: 28,
    ESPIPE: 29,
    EROFS: 30,
    EMLINK: 31,
    EPIPE: 32,
    EDOM: 33,
    ERANGE: 34,
    ENOMSG: 42,
    EIDRM: 43,
    ECHRNG: 44,
    EL2NSYNC: 45,
    EL3HLT: 46,
    EL3RST: 47,
    ELNRNG: 48,
    EUNATCH: 49,
    ENOCSI: 50,
    EL2HLT: 51,
    EDEADLK: 35,
    ENOLCK: 37,
    EBADE: 52,
    EBADR: 53,
    EXFULL: 54,
    ENOANO: 55,
    EBADRQC: 56,
    EBADSLT: 57,
    EDEADLOCK: 35,
    EBFONT: 59,
    ENOSTR: 60,
    ENODATA: 61,
    ETIME: 62,
    ENOSR: 63,
    ENONET: 64,
    ENOPKG: 65,
    EREMOTE: 66,
    ENOLINK: 67,
    EADV: 68,
    ESRMNT: 69,
    ECOMM: 70,
    EPROTO: 71,
    EMULTIHOP: 72,
    EDOTDOT: 73,
    EBADMSG: 74,
    ENOTUNIQ: 76,
    EBADFD: 77,
    EREMCHG: 78,
    ELIBACC: 79,
    ELIBBAD: 80,
    ELIBSCN: 81,
    ELIBMAX: 82,
    ELIBEXEC: 83,
    ENOSYS: 38,
    ENOTEMPTY: 39,
    ENAMETOOLONG: 36,
    ELOOP: 40,
    EOPNOTSUPP: 95,
    EPFNOSUPPORT: 96,
    ECONNRESET: 104,
    ENOBUFS: 105,
    EAFNOSUPPORT: 97,
    EPROTOTYPE: 91,
    ENOTSOCK: 88,
    ENOPROTOOPT: 92,
    ESHUTDOWN: 108,
    ECONNREFUSED: 111,
    EADDRINUSE: 98,
    ECONNABORTED: 103,
    ENETUNREACH: 101,
    ENETDOWN: 100,
    ETIMEDOUT: 110,
    EHOSTDOWN: 112,
    EHOSTUNREACH: 113,
    EINPROGRESS: 115,
    EALREADY: 114,
    EDESTADDRREQ: 89,
    EMSGSIZE: 90,
    EPROTONOSUPPORT: 93,
    ESOCKTNOSUPPORT: 94,
    EADDRNOTAVAIL: 99,
    ENETRESET: 102,
    EISCONN: 106,
    ENOTCONN: 107,
    ETOOMANYREFS: 109,
    EUSERS: 87,
    EDQUOT: 122,
    ESTALE: 116,
    ENOTSUP: 95,
    ENOMEDIUM: 123,
    EILSEQ: 84,
    EOVERFLOW: 75,
    ECANCELED: 125,
    ENOTRECOVERABLE: 131,
    EOWNERDEAD: 130,
    ESTRPIPE: 86
};
var ERRNO_MESSAGES = {
    0: "Success",
    1: "Not super-user",
    2: "No such file or directory",
    3: "No such process",
    4: "Interrupted system call",
    5: "I/O error",
    6: "No such device or address",
    7: "Arg list too long",
    8: "Exec format error",
    9: "Bad file number",
    10: "No children",
    11: "No more processes",
    12: "Not enough core",
    13: "Permission denied",
    14: "Bad address",
    15: "Block device required",
    16: "Mount device busy",
    17: "File exists",
    18: "Cross-device link",
    19: "No such device",
    20: "Not a directory",
    21: "Is a directory",
    22: "Invalid argument",
    23: "Too many open files in system",
    24: "Too many open files",
    25: "Not a typewriter",
    26: "Text file busy",
    27: "File too large",
    28: "No space left on device",
    29: "Illegal seek",
    30: "Read only file system",
    31: "Too many links",
    32: "Broken pipe",
    33: "Math arg out of domain of func",
    34: "Math result not representable",
    35: "File locking deadlock error",
    36: "File or path name too long",
    37: "No record locks available",
    38: "Function not implemented",
    39: "Directory not empty",
    40: "Too many symbolic links",
    42: "No message of desired type",
    43: "Identifier removed",
    44: "Channel number out of range",
    45: "Level 2 not synchronized",
    46: "Level 3 halted",
    47: "Level 3 reset",
    48: "Link number out of range",
    49: "Protocol driver not attached",
    50: "No CSI structure available",
    51: "Level 2 halted",
    52: "Invalid exchange",
    53: "Invalid request descriptor",
    54: "Exchange full",
    55: "No anode",
    56: "Invalid request code",
    57: "Invalid slot",
    59: "Bad font file fmt",
    60: "Device not a stream",
    61: "No data (for no delay io)",
    62: "Timer expired",
    63: "Out of streams resources",
    64: "Machine is not on the network",
    65: "Package not installed",
    66: "The object is remote",
    67: "The link has been severed",
    68: "Advertise error",
    69: "Srmount error",
    70: "Communication error on send",
    71: "Protocol error",
    72: "Multihop attempted",
    73: "Cross mount point (not really error)",
    74: "Trying to read unreadable message",
    75: "Value too large for defined data type",
    76: "Given log. name not unique",
    77: "f.d. invalid for this operation",
    78: "Remote address changed",
    79: "Can   access a needed shared lib",
    80: "Accessing a corrupted shared lib",
    81: ".lib section in a.out corrupted",
    82: "Attempting to link in too many libs",
    83: "Attempting to exec a shared library",
    84: "Illegal byte sequence",
    86: "Streams pipe error",
    87: "Too many users",
    88: "Socket operation on non-socket",
    89: "Destination address required",
    90: "Message too long",
    91: "Protocol wrong type for socket",
    92: "Protocol not available",
    93: "Unknown protocol",
    94: "Socket type not supported",
    95: "Not supported",
    96: "Protocol family not supported",
    97: "Address family not supported by protocol family",
    98: "Address already in use",
    99: "Address not available",
    100: "Network interface is not configured",
    101: "Network is unreachable",
    102: "Connection reset by network",
    103: "Connection aborted",
    104: "Connection reset by peer",
    105: "No buffer space available",
    106: "Socket is already connected",
    107: "Socket is not connected",
    108: "Can't send after socket shutdown",
    109: "Too many references",
    110: "Connection timed out",
    111: "Connection refused",
    112: "Host is down",
    113: "Host is unreachable",
    114: "Socket already connected",
    115: "Connection already in progress",
    116: "Stale file handle",
    122: "Quota exceeded",
    123: "No medium (in tape drive)",
    125: "Operation canceled",
    130: "Previous owner died",
    131: "State not recoverable"
};
var ___errno_state = 0;

function ___setErrNo(value) {
    HEAP32[___errno_state >> 2] = value;
    return value
}
var PATH = {
    splitPath: (function(filename) {
        var splitPathRe = /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
        return splitPathRe.exec(filename).slice(1)
    }),
    normalizeArray: (function(parts, allowAboveRoot) {
        var up = 0;
        for (var i = parts.length - 1; i >= 0; i--) {
            var last = parts[i];
            if (last === ".") {
                parts.splice(i, 1)
            } else if (last === "..") {
                parts.splice(i, 1);
                up++
            } else if (up) {
                parts.splice(i, 1);
                up--
            }
        }
        if (allowAboveRoot) {
            for (; up--; up) {
                parts.unshift("..")
            }
        }
        return parts
    }),
    normalize: (function(path) {
        var isAbsolute = path.charAt(0) === "/",
            trailingSlash = path.substr(-1) === "/";
        path = PATH.normalizeArray(path.split("/").filter((function(p) {
            return !!p
        })), !isAbsolute).join("/");
        if (!path && !isAbsolute) {
            path = "."
        }
        if (path && trailingSlash) {
            path += "/"
        }
        return (isAbsolute ? "/" : "") + path
    }),
    dirname: (function(path) {
        var result = PATH.splitPath(path),
            root = result[0],
            dir = result[1];
        if (!root && !dir) {
            return "."
        }
        if (dir) {
            dir = dir.substr(0, dir.length - 1)
        }
        return root + dir
    }),
    basename: (function(path) {
        if (path === "/") return "/";
        var lastSlash = path.lastIndexOf("/");
        if (lastSlash === -1) return path;
        return path.substr(lastSlash + 1)
    }),
    extname: (function(path) {
        return PATH.splitPath(path)[3]
    }),
    join: (function() {
        var paths = Array.prototype.slice.call(arguments, 0);
        return PATH.normalize(paths.join("/"))
    }),
    join2: (function(l, r) {
        return PATH.normalize(l + "/" + r)
    }),
    resolve: (function() {
        var resolvedPath = "",
            resolvedAbsolute = false;
        for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
            var path = i >= 0 ? arguments[i] : FS.cwd();
            if (typeof path !== "string") {
                throw new TypeError("Arguments to path.resolve must be strings")
            } else if (!path) {
                return ""
            }
            resolvedPath = path + "/" + resolvedPath;
            resolvedAbsolute = path.charAt(0) === "/"
        }
        resolvedPath = PATH.normalizeArray(resolvedPath.split("/").filter((function(p) {
            return !!p
        })), !resolvedAbsolute).join("/");
        return (resolvedAbsolute ? "/" : "") + resolvedPath || "."
    }),
    relative: (function(from, to) {
        from = PATH.resolve(from).substr(1);
        to = PATH.resolve(to).substr(1);

        function trim(arr) {
            var start = 0;
            for (; start < arr.length; start++) {
                if (arr[start] !== "") break
            }
            var end = arr.length - 1;
            for (; end >= 0; end--) {
                if (arr[end] !== "") break
            }
            if (start > end) return [];
            return arr.slice(start, end - start + 1)
        }
        var fromParts = trim(from.split("/"));
        var toParts = trim(to.split("/"));
        var length = Math.min(fromParts.length, toParts.length);
        var samePartsLength = length;
        for (var i = 0; i < length; i++) {
            if (fromParts[i] !== toParts[i]) {
                samePartsLength = i;
                break
            }
        }
        var outputParts = [];
        for (var i = samePartsLength; i < fromParts.length; i++) {
            outputParts.push("..")
        }
        outputParts = outputParts.concat(toParts.slice(samePartsLength));
        return outputParts.join("/")
    })
};
var TTY = {
    ttys: [],
    init: (function() {}),
    shutdown: (function() {}),
    register: (function(dev, ops) {
        TTY.ttys[dev] = {
            input: [],
            output: [],
            ops: ops
        };
        FS.registerDevice(dev, TTY.stream_ops)
    }),
    stream_ops: {
        open: (function(stream) {
            var tty = TTY.ttys[stream.node.rdev];
            if (!tty) {
                throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
            }
            stream.tty = tty;
            stream.seekable = false
        }),
        close: (function(stream) {
            stream.tty.ops.flush(stream.tty)
        }),
        flush: (function(stream) {
            stream.tty.ops.flush(stream.tty)
        }),
        read: (function(stream, buffer, offset, length, pos) {
            if (!stream.tty || !stream.tty.ops.get_char) {
                throw new FS.ErrnoError(ERRNO_CODES.ENXIO)
            }
            var bytesRead = 0;
            for (var i = 0; i < length; i++) {
                var result;
                try {
                    result = stream.tty.ops.get_char(stream.tty)
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO)
                }
                if (result === undefined && bytesRead === 0) {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
                }
                if (result === null || result === undefined) break;
                bytesRead++;
                buffer[offset + i] = result
            }
            if (bytesRead) {
                stream.node.timestamp = Date.now()
            }
            return bytesRead
        }),
        write: (function(stream, buffer, offset, length, pos) {
            if (!stream.tty || !stream.tty.ops.put_char) {
                throw new FS.ErrnoError(ERRNO_CODES.ENXIO)
            }
            for (var i = 0; i < length; i++) {
                try {
                    stream.tty.ops.put_char(stream.tty, buffer[offset + i])
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO)
                }
            }
            if (length) {
                stream.node.timestamp = Date.now()
            }
            return i
        })
    },
    default_tty_ops: {
        get_char: (function(tty) {
            if (!tty.input.length) {
                var result = null;
                if (ENVIRONMENT_IS_NODE) {
                    result = process["stdin"]["read"]();
                    if (!result) {
                        if (process["stdin"]["_readableState"] && process["stdin"]["_readableState"]["ended"]) {
                            return null
                        }
                        return undefined
                    }
                } else if (typeof window != "undefined" && typeof window.prompt == "function") {
                    result = window.prompt("Input: ");
                    if (result !== null) {
                        result += "\n"
                    }
                } else if (typeof readline == "function") {
                    result = readline();
                    if (result !== null) {
                        result += "\n"
                    }
                }
                if (!result) {
                    return null
                }
                tty.input = intArrayFromString(result, true)
            }
            return tty.input.shift()
        }),
        flush: (function(tty) {
            if (tty.output && tty.output.length > 0) {
                Module["print"](tty.output.join(""));
                tty.output = []
            }
        }),
        put_char: (function(tty, val) {
            if (val === null || val === 10) {
                Module["print"](tty.output.join(""));
                tty.output = []
            } else {
                tty.output.push(TTY.utf8.processCChar(val))
            }
        })
    },
    default_tty1_ops: {
        put_char: (function(tty, val) {
            if (val === null || val === 10) {
                Module["printErr"](tty.output.join(""));
                tty.output = []
            } else {
                tty.output.push(TTY.utf8.processCChar(val))
            }
        }),
        flush: (function(tty) {
            if (tty.output && tty.output.length > 0) {
                Module["printErr"](tty.output.join(""));
                tty.output = []
            }
        })
    }
};
var MEMFS = {
    ops_table: null,
    mount: (function(mount) {
        return MEMFS.createNode(null, "/", 16384 | 511, 0)
    }),
    createNode: (function(parent, name, mode, dev) {
        if (FS.isBlkdev(mode) || FS.isFIFO(mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (!MEMFS.ops_table) {
            MEMFS.ops_table = {
                dir: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr,
                        lookup: MEMFS.node_ops.lookup,
                        mknod: MEMFS.node_ops.mknod,
                        rename: MEMFS.node_ops.rename,
                        unlink: MEMFS.node_ops.unlink,
                        rmdir: MEMFS.node_ops.rmdir,
                        readdir: MEMFS.node_ops.readdir,
                        symlink: MEMFS.node_ops.symlink
                    },
                    stream: {
                        llseek: MEMFS.stream_ops.llseek
                    }
                },
                file: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr
                    },
                    stream: {
                        llseek: MEMFS.stream_ops.llseek,
                        read: MEMFS.stream_ops.read,
                        write: MEMFS.stream_ops.write,
                        allocate: MEMFS.stream_ops.allocate,
                        mmap: MEMFS.stream_ops.mmap
                    }
                },
                link: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr,
                        readlink: MEMFS.node_ops.readlink
                    },
                    stream: {}
                },
                chrdev: {
                    node: {
                        getattr: MEMFS.node_ops.getattr,
                        setattr: MEMFS.node_ops.setattr
                    },
                    stream: FS.chrdev_stream_ops
                }
            }
        }
        var node = FS.createNode(parent, name, mode, dev);
        if (FS.isDir(node.mode)) {
            node.node_ops = MEMFS.ops_table.dir.node;
            node.stream_ops = MEMFS.ops_table.dir.stream;
            node.contents = {}
        } else if (FS.isFile(node.mode)) {
            node.node_ops = MEMFS.ops_table.file.node;
            node.stream_ops = MEMFS.ops_table.file.stream;
            node.usedBytes = 0;
            node.contents = null
        } else if (FS.isLink(node.mode)) {
            node.node_ops = MEMFS.ops_table.link.node;
            node.stream_ops = MEMFS.ops_table.link.stream
        } else if (FS.isChrdev(node.mode)) {
            node.node_ops = MEMFS.ops_table.chrdev.node;
            node.stream_ops = MEMFS.ops_table.chrdev.stream
        }
        node.timestamp = Date.now();
        if (parent) {
            parent.contents[name] = node
        }
        return node
    }),
    getFileDataAsRegularArray: (function(node) {
        if (node.contents && node.contents.subarray) {
            var arr = [];
            for (var i = 0; i < node.usedBytes; ++i) arr.push(node.contents[i]);
            return arr
        }
        return node.contents
    }),
    getFileDataAsTypedArray: (function(node) {
        if (!node.contents) return new Uint8Array;
        if (node.contents.subarray) return node.contents.subarray(0, node.usedBytes);
        return new Uint8Array(node.contents)
    }),
    expandFileStorage: (function(node, newCapacity) {
        if (node.contents && node.contents.subarray && newCapacity > node.contents.length) {
            node.contents = MEMFS.getFileDataAsRegularArray(node);
            node.usedBytes = node.contents.length
        }
        if (!node.contents || node.contents.subarray) {
            var prevCapacity = node.contents ? node.contents.buffer.byteLength : 0;
            if (prevCapacity >= newCapacity) return;
            var CAPACITY_DOUBLING_MAX = 1024 * 1024;
            newCapacity = Math.max(newCapacity, prevCapacity * (prevCapacity < CAPACITY_DOUBLING_MAX ? 2 : 1.125) | 0);
            if (prevCapacity != 0) newCapacity = Math.max(newCapacity, 256);
            var oldContents = node.contents;
            node.contents = new Uint8Array(newCapacity);
            if (node.usedBytes > 0) node.contents.set(oldContents.subarray(0, node.usedBytes), 0);
            return
        }
        if (!node.contents && newCapacity > 0) node.contents = [];
        while (node.contents.length < newCapacity) node.contents.push(0)
    }),
    resizeFileStorage: (function(node, newSize) {
        if (node.usedBytes == newSize) return;
        if (newSize == 0) {
            node.contents = null;
            node.usedBytes = 0;
            return
        }
        if (!node.contents || node.contents.subarray) {
            var oldContents = node.contents;
            node.contents = new Uint8Array(new ArrayBuffer(newSize));
            if (oldContents) {
                node.contents.set(oldContents.subarray(0, Math.min(newSize, node.usedBytes)))
            }
            node.usedBytes = newSize;
            return
        }
        if (!node.contents) node.contents = [];
        if (node.contents.length > newSize) node.contents.length = newSize;
        else
            while (node.contents.length < newSize) node.contents.push(0);
        node.usedBytes = newSize
    }),
    node_ops: {
        getattr: (function(node) {
            var attr = {};
            attr.dev = FS.isChrdev(node.mode) ? node.id : 1;
            attr.ino = node.id;
            attr.mode = node.mode;
            attr.nlink = 1;
            attr.uid = 0;
            attr.gid = 0;
            attr.rdev = node.rdev;
            if (FS.isDir(node.mode)) {
                attr.size = 4096
            } else if (FS.isFile(node.mode)) {
                attr.size = node.usedBytes
            } else if (FS.isLink(node.mode)) {
                attr.size = node.link.length
            } else {
                attr.size = 0
            }
            attr.atime = new Date(node.timestamp);
            attr.mtime = new Date(node.timestamp);
            attr.ctime = new Date(node.timestamp);
            attr.blksize = 4096;
            attr.blocks = Math.ceil(attr.size / attr.blksize);
            return attr
        }),
        setattr: (function(node, attr) {
            if (attr.mode !== undefined) {
                node.mode = attr.mode
            }
            if (attr.timestamp !== undefined) {
                node.timestamp = attr.timestamp
            }
            if (attr.size !== undefined) {
                MEMFS.resizeFileStorage(node, attr.size)
            }
        }),
        lookup: (function(parent, name) {
            throw FS.genericErrors[ERRNO_CODES.ENOENT]
        }),
        mknod: (function(parent, name, mode, dev) {
            return MEMFS.createNode(parent, name, mode, dev)
        }),
        rename: (function(old_node, new_dir, new_name) {
            if (FS.isDir(old_node.mode)) {
                var new_node;
                try {
                    new_node = FS.lookupNode(new_dir, new_name)
                } catch (e) {}
                if (new_node) {
                    for (var i in new_node.contents) {
                        throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
                    }
                }
            }
            delete old_node.parent.contents[old_node.name];
            old_node.name = new_name;
            new_dir.contents[new_name] = old_node;
            old_node.parent = new_dir
        }),
        unlink: (function(parent, name) {
            delete parent.contents[name]
        }),
        rmdir: (function(parent, name) {
            var node = FS.lookupNode(parent, name);
            for (var i in node.contents) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
            }
            delete parent.contents[name]
        }),
        readdir: (function(node) {
            var entries = [".", ".."];
            for (var key in node.contents) {
                if (!node.contents.hasOwnProperty(key)) {
                    continue
                }
                entries.push(key)
            }
            return entries
        }),
        symlink: (function(parent, newname, oldpath) {
            var node = MEMFS.createNode(parent, newname, 511 | 40960, 0);
            node.link = oldpath;
            return node
        }),
        readlink: (function(node) {
            if (!FS.isLink(node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            return node.link
        })
    },
    stream_ops: {
        read: (function(stream, buffer, offset, length, position) {
            var contents = stream.node.contents;
            if (position >= stream.node.usedBytes) return 0;
            var size = Math.min(stream.node.usedBytes - position, length);
            assert(size >= 0);
            if (size > 8 && contents.subarray) {
                buffer.set(contents.subarray(position, position + size), offset)
            } else {
                for (var i = 0; i < size; i++) buffer[offset + i] = contents[position + i]
            }
            return size
        }),
        write: (function(stream, buffer, offset, length, position, canOwn) {
            if (!length) return 0;
            var node = stream.node;
            node.timestamp = Date.now();
            if (buffer.subarray && (!node.contents || node.contents.subarray)) {
                if (canOwn) {
                    node.contents = buffer.subarray(offset, offset + length);
                    node.usedBytes = length;
                    return length
                } else if (node.usedBytes === 0 && position === 0) {
                    node.contents = new Uint8Array(buffer.subarray(offset, offset + length));
                    node.usedBytes = length;
                    return length
                } else if (position + length <= node.usedBytes) {
                    node.contents.set(buffer.subarray(offset, offset + length), position);
                    return length
                }
            }
            MEMFS.expandFileStorage(node, position + length);
            if (node.contents.subarray && buffer.subarray) node.contents.set(buffer.subarray(offset, offset + length), position);
            else
                for (var i = 0; i < length; i++) {
                    node.contents[position + i] = buffer[offset + i]
                }
            node.usedBytes = Math.max(node.usedBytes, position + length);
            return length
        }),
        llseek: (function(stream, offset, whence) {
            var position = offset;
            if (whence === 1) {
                position += stream.position
            } else if (whence === 2) {
                if (FS.isFile(stream.node.mode)) {
                    position += stream.node.usedBytes
                }
            }
            if (position < 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            return position
        }),
        allocate: (function(stream, offset, length) {
            MEMFS.expandFileStorage(stream.node, offset + length);
            stream.node.usedBytes = Math.max(stream.node.usedBytes, offset + length)
        }),
        mmap: (function(stream, buffer, offset, length, position, prot, flags) {
            if (!FS.isFile(stream.node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
            }
            var ptr;
            var allocated;
            var contents = stream.node.contents;
            if (!(flags & 2) && (contents.buffer === buffer || contents.buffer === buffer.buffer)) {
                allocated = false;
                ptr = contents.byteOffset
            } else {
                if (position > 0 || position + length < stream.node.usedBytes) {
                    if (contents.subarray) {
                        contents = contents.subarray(position, position + length)
                    } else {
                        contents = Array.prototype.slice.call(contents, position, position + length)
                    }
                }
                allocated = true;
                ptr = _malloc(length);
                if (!ptr) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOMEM)
                }
                buffer.set(contents, ptr)
            }
            return {
                ptr: ptr,
                allocated: allocated
            }
        })
    }
};
var IDBFS = {
    dbs: {},
    indexedDB: (function() {
        if (typeof indexedDB !== "undefined") return indexedDB;
        var ret = null;
        if (typeof window === "object") ret = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
        assert(ret, "IDBFS used, but indexedDB not supported");
        return ret
    }),
    DB_VERSION: 21,
    DB_STORE_NAME: "FILE_DATA",
    mount: (function(mount) {
        return MEMFS.mount.apply(null, arguments)
    }),
    syncfs: (function(mount, populate, callback) {
        IDBFS.getLocalSet(mount, (function(err, local) {
            if (err) return callback(err);
            IDBFS.getRemoteSet(mount, (function(err, remote) {
                if (err) return callback(err);
                var src = populate ? remote : local;
                var dst = populate ? local : remote;
                IDBFS.reconcile(src, dst, callback)
            }))
        }))
    }),
    getDB: (function(name, callback) {
        var db = IDBFS.dbs[name];
        if (db) {
            return callback(null, db)
        }
        var req;
        try {
            req = IDBFS.indexedDB().open(name, IDBFS.DB_VERSION)
        } catch (e) {
            return callback(e)
        }
        req.onupgradeneeded = (function(e) {
            var db = e.target.result;
            var transaction = e.target.transaction;
            var fileStore;
            if (db.objectStoreNames.contains(IDBFS.DB_STORE_NAME)) {
                fileStore = transaction.objectStore(IDBFS.DB_STORE_NAME)
            } else {
                fileStore = db.createObjectStore(IDBFS.DB_STORE_NAME)
            }
            fileStore.createIndex("timestamp", "timestamp", {
                unique: false
            })
        });
        req.onsuccess = (function() {
            db = req.result;
            IDBFS.dbs[name] = db;
            callback(null, db)
        });
        req.onerror = (function() {
            callback(this.error)
        })
    }),
    getLocalSet: (function(mount, callback) {
        var entries = {};

        function isRealDir(p) {
            return p !== "." && p !== ".."
        }

        function toAbsolute(root) {
            return (function(p) {
                return PATH.join2(root, p)
            })
        }
        var check = FS.readdir(mount.mountpoint).filter(isRealDir).map(toAbsolute(mount.mountpoint));
        while (check.length) {
            var path = check.pop();
            var stat;
            try {
                stat = FS.stat(path)
            } catch (e) {
                return callback(e)
            }
            if (FS.isDir(stat.mode)) {
                check.push.apply(check, FS.readdir(path).filter(isRealDir).map(toAbsolute(path)))
            }
            entries[path] = {
                timestamp: stat.mtime
            }
        }
        return callback(null, {
            type: "local",
            entries: entries
        })
    }),
    getRemoteSet: (function(mount, callback) {
        var entries = {};
        IDBFS.getDB(mount.mountpoint, (function(err, db) {
            if (err) return callback(err);
            var transaction = db.transaction([IDBFS.DB_STORE_NAME], "readonly");
            transaction.onerror = (function() {
                callback(this.error)
            });
            var store = transaction.objectStore(IDBFS.DB_STORE_NAME);
            var index = store.index("timestamp");
            index.openKeyCursor().onsuccess = (function(event) {
                var cursor = event.target.result;
                if (!cursor) {
                    return callback(null, {
                        type: "remote",
                        db: db,
                        entries: entries
                    })
                }
                entries[cursor.primaryKey] = {
                    timestamp: cursor.key
                };
                cursor.continue()
            })
        }))
    }),
    loadLocalEntry: (function(path, callback) {
        var stat, node;
        try {
            var lookup = FS.lookupPath(path);
            node = lookup.node;
            stat = FS.stat(path)
        } catch (e) {
            return callback(e)
        }
        if (FS.isDir(stat.mode)) {
            return callback(null, {
                timestamp: stat.mtime,
                mode: stat.mode
            })
        } else if (FS.isFile(stat.mode)) {
            node.contents = MEMFS.getFileDataAsTypedArray(node);
            return callback(null, {
                timestamp: stat.mtime,
                mode: stat.mode,
                contents: node.contents
            })
        } else {
            return callback(new Error("node type not supported"))
        }
    }),
    storeLocalEntry: (function(path, entry, callback) {
        try {
            if (FS.isDir(entry.mode)) {
                FS.mkdir(path, entry.mode)
            } else if (FS.isFile(entry.mode)) {
                FS.writeFile(path, entry.contents, {
                    encoding: "binary",
                    canOwn: true
                })
            } else {
                return callback(new Error("node type not supported"))
            }
            FS.chmod(path, entry.mode);
            FS.utime(path, entry.timestamp, entry.timestamp)
        } catch (e) {
            return callback(e)
        }
        callback(null)
    }),
    removeLocalEntry: (function(path, callback) {
        try {
            var lookup = FS.lookupPath(path);
            var stat = FS.stat(path);
            if (FS.isDir(stat.mode)) {
                FS.rmdir(path)
            } else if (FS.isFile(stat.mode)) {
                FS.unlink(path)
            }
        } catch (e) {
            return callback(e)
        }
        callback(null)
    }),
    loadRemoteEntry: (function(store, path, callback) {
        var req = store.get(path);
        req.onsuccess = (function(event) {
            callback(null, event.target.result)
        });
        req.onerror = (function() {
            callback(this.error)
        })
    }),
    storeRemoteEntry: (function(store, path, entry, callback) {
        var req = store.put(entry, path);
        req.onsuccess = (function() {
            callback(null)
        });
        req.onerror = (function() {
            callback(this.error)
        })
    }),
    removeRemoteEntry: (function(store, path, callback) {
        var req = store.delete(path);
        req.onsuccess = (function() {
            callback(null)
        });
        req.onerror = (function() {
            callback(this.error)
        })
    }),
    reconcile: (function(src, dst, callback) {
        var total = 0;
        var create = [];
        Object.keys(src.entries).forEach((function(key) {
            var e = src.entries[key];
            var e2 = dst.entries[key];
            if (!e2 || e.timestamp > e2.timestamp) {
                create.push(key);
                total++
            }
        }));
        var remove = [];
        Object.keys(dst.entries).forEach((function(key) {
            var e = dst.entries[key];
            var e2 = src.entries[key];
            if (!e2) {
                remove.push(key);
                total++
            }
        }));
        if (!total) {
            return callback(null)
        }
        var errored = false;
        var completed = 0;
        var db = src.type === "remote" ? src.db : dst.db;
        var transaction = db.transaction([IDBFS.DB_STORE_NAME], "readwrite");
        var store = transaction.objectStore(IDBFS.DB_STORE_NAME);

        function done(err) {
            if (err) {
                if (!done.errored) {
                    done.errored = true;
                    return callback(err)
                }
                return
            }
            if (++completed >= total) {
                return callback(null)
            }
        }
        transaction.onerror = (function() {
            done(this.error)
        });
        create.sort().forEach((function(path) {
            if (dst.type === "local") {
                IDBFS.loadRemoteEntry(store, path, (function(err, entry) {
                    if (err) return done(err);
                    IDBFS.storeLocalEntry(path, entry, done)
                }))
            } else {
                IDBFS.loadLocalEntry(path, (function(err, entry) {
                    if (err) return done(err);
                    IDBFS.storeRemoteEntry(store, path, entry, done)
                }))
            }
        }));
        remove.sort().reverse().forEach((function(path) {
            if (dst.type === "local") {
                IDBFS.removeLocalEntry(path, done)
            } else {
                IDBFS.removeRemoteEntry(store, path, done)
            }
        }))
    })
};
var NODEFS = {
    isWindows: false,
    staticInit: (function() {
        NODEFS.isWindows = !!process.platform.match(/^win/)
    }),
    mount: (function(mount) {
        assert(ENVIRONMENT_IS_NODE);
        return NODEFS.createNode(null, "/", NODEFS.getMode(mount.opts.root), 0)
    }),
    createNode: (function(parent, name, mode, dev) {
        if (!FS.isDir(mode) && !FS.isFile(mode) && !FS.isLink(mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node = FS.createNode(parent, name, mode);
        node.node_ops = NODEFS.node_ops;
        node.stream_ops = NODEFS.stream_ops;
        return node
    }),
    getMode: (function(path) {
        var stat;
        try {
            stat = fs.lstatSync(path);
            if (NODEFS.isWindows) {
                stat.mode = stat.mode | (stat.mode & 146) >> 1
            }
        } catch (e) {
            if (!e.code) throw e;
            throw new FS.ErrnoError(ERRNO_CODES[e.code])
        }
        return stat.mode
    }),
    realPath: (function(node) {
        var parts = [];
        while (node.parent !== node) {
            parts.push(node.name);
            node = node.parent
        }
        parts.push(node.mount.opts.root);
        parts.reverse();
        return PATH.join.apply(null, parts)
    }),
    flagsToPermissionStringMap: {
        0: "r",
        1: "r+",
        2: "r+",
        64: "r",
        65: "r+",
        66: "r+",
        129: "rx+",
        193: "rx+",
        514: "w+",
        577: "w",
        578: "w+",
        705: "wx",
        706: "wx+",
        1024: "a",
        1025: "a",
        1026: "a+",
        1089: "a",
        1090: "a+",
        1153: "ax",
        1154: "ax+",
        1217: "ax",
        1218: "ax+",
        4096: "rs",
        4098: "rs+"
    },
    flagsToPermissionString: (function(flags) {
        if (flags in NODEFS.flagsToPermissionStringMap) {
            return NODEFS.flagsToPermissionStringMap[flags]
        } else {
            return flags
        }
    }),
    node_ops: {
        getattr: (function(node) {
            var path = NODEFS.realPath(node);
            var stat;
            try {
                stat = fs.lstatSync(path)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
            if (NODEFS.isWindows && !stat.blksize) {
                stat.blksize = 4096
            }
            if (NODEFS.isWindows && !stat.blocks) {
                stat.blocks = (stat.size + stat.blksize - 1) / stat.blksize | 0
            }
            return {
                dev: stat.dev,
                ino: stat.ino,
                mode: stat.mode,
                nlink: stat.nlink,
                uid: stat.uid,
                gid: stat.gid,
                rdev: stat.rdev,
                size: stat.size,
                atime: stat.atime,
                mtime: stat.mtime,
                ctime: stat.ctime,
                blksize: stat.blksize,
                blocks: stat.blocks
            }
        }),
        setattr: (function(node, attr) {
            var path = NODEFS.realPath(node);
            try {
                if (attr.mode !== undefined) {
                    fs.chmodSync(path, attr.mode);
                    node.mode = attr.mode
                }
                if (attr.timestamp !== undefined) {
                    var date = new Date(attr.timestamp);
                    fs.utimesSync(path, date, date)
                }
                if (attr.size !== undefined) {
                    fs.truncateSync(path, attr.size)
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        lookup: (function(parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            var mode = NODEFS.getMode(path);
            return NODEFS.createNode(parent, name, mode)
        }),
        mknod: (function(parent, name, mode, dev) {
            var node = NODEFS.createNode(parent, name, mode, dev);
            var path = NODEFS.realPath(node);
            try {
                if (FS.isDir(node.mode)) {
                    fs.mkdirSync(path, node.mode)
                } else {
                    fs.writeFileSync(path, "", {
                        mode: node.mode
                    })
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
            return node
        }),
        rename: (function(oldNode, newDir, newName) {
            var oldPath = NODEFS.realPath(oldNode);
            var newPath = PATH.join2(NODEFS.realPath(newDir), newName);
            try {
                fs.renameSync(oldPath, newPath)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        unlink: (function(parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            try {
                fs.unlinkSync(path)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        rmdir: (function(parent, name) {
            var path = PATH.join2(NODEFS.realPath(parent), name);
            try {
                fs.rmdirSync(path)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        readdir: (function(node) {
            var path = NODEFS.realPath(node);
            try {
                return fs.readdirSync(path)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        symlink: (function(parent, newName, oldPath) {
            var newPath = PATH.join2(NODEFS.realPath(parent), newName);
            try {
                fs.symlinkSync(oldPath, newPath)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        readlink: (function(node) {
            var path = NODEFS.realPath(node);
            try {
                return fs.readlinkSync(path)
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        })
    },
    stream_ops: {
        open: (function(stream) {
            var path = NODEFS.realPath(stream.node);
            try {
                if (FS.isFile(stream.node.mode)) {
                    stream.nfd = fs.openSync(path, NODEFS.flagsToPermissionString(stream.flags))
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        close: (function(stream) {
            try {
                if (FS.isFile(stream.node.mode) && stream.nfd) {
                    fs.closeSync(stream.nfd)
                }
            } catch (e) {
                if (!e.code) throw e;
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
        }),
        read: (function(stream, buffer, offset, length, position) {
            if (length === 0) return 0;
            var nbuffer = new Buffer(length);
            var res;
            try {
                res = fs.readSync(stream.nfd, nbuffer, 0, length, position)
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
            if (res > 0) {
                for (var i = 0; i < res; i++) {
                    buffer[offset + i] = nbuffer[i]
                }
            }
            return res
        }),
        write: (function(stream, buffer, offset, length, position) {
            var nbuffer = new Buffer(buffer.subarray(offset, offset + length));
            var res;
            try {
                res = fs.writeSync(stream.nfd, nbuffer, 0, length, position)
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES[e.code])
            }
            return res
        }),
        llseek: (function(stream, offset, whence) {
            var position = offset;
            if (whence === 1) {
                position += stream.position
            } else if (whence === 2) {
                if (FS.isFile(stream.node.mode)) {
                    try {
                        var stat = fs.fstatSync(stream.nfd);
                        position += stat.size
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES[e.code])
                    }
                }
            }
            if (position < 0) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            return position
        })
    }
};
var _stdin = allocate(1, "i32*", ALLOC_STATIC);
var _stdout = allocate(1, "i32*", ALLOC_STATIC);
var _stderr = allocate(1, "i32*", ALLOC_STATIC);

function _fflush(stream) {}
var FS = {
    root: null,
    mounts: [],
    devices: [null],
    streams: [],
    nextInode: 1,
    nameTable: null,
    currentPath: "/",
    initialized: false,
    ignorePermissions: true,
    trackingDelegate: {},
    tracking: {
        openFlags: {
            READ: 1,
            WRITE: 2
        }
    },
    ErrnoError: null,
    genericErrors: {},
    handleFSError: (function(e) {
        if (!(e instanceof FS.ErrnoError)) throw e + " : " + stackTrace();
        return ___setErrNo(e.errno)
    }),
    lookupPath: (function(path, opts) {
        path = PATH.resolve(FS.cwd(), path);
        opts = opts || {};
        if (!path) return {
            path: "",
            node: null
        };
        var defaults = {
            follow_mount: true,
            recurse_count: 0
        };
        for (var key in defaults) {
            if (opts[key] === undefined) {
                opts[key] = defaults[key]
            }
        }
        if (opts.recurse_count > 8) {
            throw new FS.ErrnoError(ERRNO_CODES.ELOOP)
        }
        var parts = PATH.normalizeArray(path.split("/").filter((function(p) {
            return !!p
        })), false);
        var current = FS.root;
        var current_path = "/";
        for (var i = 0; i < parts.length; i++) {
            var islast = i === parts.length - 1;
            if (islast && opts.parent) {
                break
            }
            current = FS.lookupNode(current, parts[i]);
            current_path = PATH.join2(current_path, parts[i]);
            if (FS.isMountpoint(current)) {
                if (!islast || islast && opts.follow_mount) {
                    current = current.mounted.root
                }
            }
            if (!islast || opts.follow) {
                var count = 0;
                while (FS.isLink(current.mode)) {
                    var link = FS.readlink(current_path);
                    current_path = PATH.resolve(PATH.dirname(current_path), link);
                    var lookup = FS.lookupPath(current_path, {
                        recurse_count: opts.recurse_count
                    });
                    current = lookup.node;
                    if (count++ > 40) {
                        throw new FS.ErrnoError(ERRNO_CODES.ELOOP)
                    }
                }
            }
        }
        return {
            path: current_path,
            node: current
        }
    }),
    getPath: (function(node) {
        var path;
        while (true) {
            if (FS.isRoot(node)) {
                var mount = node.mount.mountpoint;
                if (!path) return mount;
                return mount[mount.length - 1] !== "/" ? mount + "/" + path : mount + path
            }
            path = path ? node.name + "/" + path : node.name;
            node = node.parent
        }
    }),
    hashName: (function(parentid, name) {
        var hash = 0;
        for (var i = 0; i < name.length; i++) {
            hash = (hash << 5) - hash + name.charCodeAt(i) | 0
        }
        return (parentid + hash >>> 0) % FS.nameTable.length
    }),
    hashAddNode: (function(node) {
        var hash = FS.hashName(node.parent.id, node.name);
        node.name_next = FS.nameTable[hash];
        FS.nameTable[hash] = node
    }),
    hashRemoveNode: (function(node) {
        var hash = FS.hashName(node.parent.id, node.name);
        if (FS.nameTable[hash] === node) {
            FS.nameTable[hash] = node.name_next
        } else {
            var current = FS.nameTable[hash];
            while (current) {
                if (current.name_next === node) {
                    current.name_next = node.name_next;
                    break
                }
                current = current.name_next
            }
        }
    }),
    lookupNode: (function(parent, name) {
        var err = FS.mayLookup(parent);
        if (err) {
            throw new FS.ErrnoError(err, parent)
        }
        var hash = FS.hashName(parent.id, name);
        for (var node = FS.nameTable[hash]; node; node = node.name_next) {
            var nodeName = node.name;
            if (node.parent.id === parent.id && nodeName === name) {
                return node
            }
        }
        return FS.lookup(parent, name)
    }),
    createNode: (function(parent, name, mode, rdev) {
        if (!FS.FSNode) {
            FS.FSNode = (function(parent, name, mode, rdev) {
                if (!parent) {
                    parent = this
                }
                this.parent = parent;
                this.mount = parent.mount;
                this.mounted = null;
                this.id = FS.nextInode++;
                this.name = name;
                this.mode = mode;
                this.node_ops = {};
                this.stream_ops = {};
                this.rdev = rdev
            });
            FS.FSNode.prototype = {};
            var readMode = 292 | 73;
            var writeMode = 146;
            Object.defineProperties(FS.FSNode.prototype, {
                read: {
                    get: (function() {
                        return (this.mode & readMode) === readMode
                    }),
                    set: (function(val) {
                        val ? this.mode |= readMode : this.mode &= ~readMode
                    })
                },
                write: {
                    get: (function() {
                        return (this.mode & writeMode) === writeMode
                    }),
                    set: (function(val) {
                        val ? this.mode |= writeMode : this.mode &= ~writeMode
                    })
                },
                isFolder: {
                    get: (function() {
                        return FS.isDir(this.mode)
                    })
                },
                isDevice: {
                    get: (function() {
                        return FS.isChrdev(this.mode)
                    })
                }
            })
        }
        var node = new FS.FSNode(parent, name, mode, rdev);
        FS.hashAddNode(node);
        return node
    }),
    destroyNode: (function(node) {
        FS.hashRemoveNode(node)
    }),
    isRoot: (function(node) {
        return node === node.parent
    }),
    isMountpoint: (function(node) {
        return !!node.mounted
    }),
    isFile: (function(mode) {
        return (mode & 61440) === 32768
    }),
    isDir: (function(mode) {
        return (mode & 61440) === 16384
    }),
    isLink: (function(mode) {
        return (mode & 61440) === 40960
    }),
    isChrdev: (function(mode) {
        return (mode & 61440) === 8192
    }),
    isBlkdev: (function(mode) {
        return (mode & 61440) === 24576
    }),
    isFIFO: (function(mode) {
        return (mode & 61440) === 4096
    }),
    isSocket: (function(mode) {
        return (mode & 49152) === 49152
    }),
    flagModes: {
        "r": 0,
        "rs": 1052672,
        "r+": 2,
        "w": 577,
        "wx": 705,
        "xw": 705,
        "w+": 578,
        "wx+": 706,
        "xw+": 706,
        "a": 1089,
        "ax": 1217,
        "xa": 1217,
        "a+": 1090,
        "ax+": 1218,
        "xa+": 1218
    },
    modeStringToFlags: (function(str) {
        var flags = FS.flagModes[str];
        if (typeof flags === "undefined") {
            throw new Error("Unknown file open mode: " + str)
        }
        return flags
    }),
    flagsToPermissionString: (function(flag) {
        var accmode = flag & 2097155;
        var perms = ["r", "w", "rw"][accmode];
        if (flag & 512) {
            perms += "w"
        }
        return perms
    }),
    nodePermissions: (function(node, perms) {
        if (FS.ignorePermissions) {
            return 0
        }
        if (perms.indexOf("r") !== -1 && !(node.mode & 292)) {
            return ERRNO_CODES.EACCES
        } else if (perms.indexOf("w") !== -1 && !(node.mode & 146)) {
            return ERRNO_CODES.EACCES
        } else if (perms.indexOf("x") !== -1 && !(node.mode & 73)) {
            return ERRNO_CODES.EACCES
        }
        return 0
    }),
    mayLookup: (function(dir) {
        var err = FS.nodePermissions(dir, "x");
        if (err) return err;
        if (!dir.node_ops.lookup) return ERRNO_CODES.EACCES;
        return 0
    }),
    mayCreate: (function(dir, name) {
        try {
            var node = FS.lookupNode(dir, name);
            return ERRNO_CODES.EEXIST
        } catch (e) {}
        return FS.nodePermissions(dir, "wx")
    }),
    mayDelete: (function(dir, name, isdir) {
        var node;
        try {
            node = FS.lookupNode(dir, name)
        } catch (e) {
            return e.errno
        }
        var err = FS.nodePermissions(dir, "wx");
        if (err) {
            return err
        }
        if (isdir) {
            if (!FS.isDir(node.mode)) {
                return ERRNO_CODES.ENOTDIR
            }
            if (FS.isRoot(node) || FS.getPath(node) === FS.cwd()) {
                return ERRNO_CODES.EBUSY
            }
        } else {
            if (FS.isDir(node.mode)) {
                return ERRNO_CODES.EISDIR
            }
        }
        return 0
    }),
    mayOpen: (function(node, flags) {
        if (!node) {
            return ERRNO_CODES.ENOENT
        }
        if (FS.isLink(node.mode)) {
            return ERRNO_CODES.ELOOP
        } else if (FS.isDir(node.mode)) {
            if ((flags & 2097155) !== 0 || flags & 512) {
                return ERRNO_CODES.EISDIR
            }
        }
        return FS.nodePermissions(node, FS.flagsToPermissionString(flags))
    }),
    MAX_OPEN_FDS: 4096,
    nextfd: (function(fd_start, fd_end) {
        fd_start = fd_start || 0;
        fd_end = fd_end || FS.MAX_OPEN_FDS;
        for (var fd = fd_start; fd <= fd_end; fd++) {
            if (!FS.streams[fd]) {
                return fd
            }
        }
        throw new FS.ErrnoError(ERRNO_CODES.EMFILE)
    }),
    getStream: (function(fd) {
        return FS.streams[fd]
    }),
    createStream: (function(stream, fd_start, fd_end) {
        if (!FS.FSStream) {
            FS.FSStream = (function() {});
            FS.FSStream.prototype = {};
            Object.defineProperties(FS.FSStream.prototype, {
                object: {
                    get: (function() {
                        return this.node
                    }),
                    set: (function(val) {
                        this.node = val
                    })
                },
                isRead: {
                    get: (function() {
                        return (this.flags & 2097155) !== 1
                    })
                },
                isWrite: {
                    get: (function() {
                        return (this.flags & 2097155) !== 0
                    })
                },
                isAppend: {
                    get: (function() {
                        return this.flags & 1024
                    })
                }
            })
        }
        var newStream = new FS.FSStream;
        for (var p in stream) {
            newStream[p] = stream[p]
        }
        stream = newStream;
        var fd = FS.nextfd(fd_start, fd_end);
        stream.fd = fd;
        FS.streams[fd] = stream;
        return stream
    }),
    closeStream: (function(fd) {
        FS.streams[fd] = null
    }),
    getStreamFromPtr: (function(ptr) {
        return FS.streams[ptr - 1]
    }),
    getPtrForStream: (function(stream) {
        return stream ? stream.fd + 1 : 0
    }),
    chrdev_stream_ops: {
        open: (function(stream) {
            var device = FS.getDevice(stream.node.rdev);
            stream.stream_ops = device.stream_ops;
            if (stream.stream_ops.open) {
                stream.stream_ops.open(stream)
            }
        }),
        llseek: (function() {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        })
    },
    major: (function(dev) {
        return dev >> 8
    }),
    minor: (function(dev) {
        return dev & 255
    }),
    makedev: (function(ma, mi) {
        return ma << 8 | mi
    }),
    registerDevice: (function(dev, ops) {
        FS.devices[dev] = {
            stream_ops: ops
        }
    }),
    getDevice: (function(dev) {
        return FS.devices[dev]
    }),
    getMounts: (function(mount) {
        var mounts = [];
        var check = [mount];
        while (check.length) {
            var m = check.pop();
            mounts.push(m);
            check.push.apply(check, m.mounts)
        }
        return mounts
    }),
    syncfs: (function(populate, callback) {
        if (typeof populate === "function") {
            callback = populate;
            populate = false
        }
        var mounts = FS.getMounts(FS.root.mount);
        var completed = 0;

        function done(err) {
            if (err) {
                if (!done.errored) {
                    done.errored = true;
                    return callback(err)
                }
                return
            }
            if (++completed >= mounts.length) {
                callback(null)
            }
        }
        mounts.forEach((function(mount) {
            if (!mount.type.syncfs) {
                return done(null)
            }
            mount.type.syncfs(mount, populate, done)
        }))
    }),
    mount: (function(type, opts, mountpoint) {
        var root = mountpoint === "/";
        var pseudo = !mountpoint;
        var node;
        if (root && FS.root) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        } else if (!root && !pseudo) {
            var lookup = FS.lookupPath(mountpoint, {
                follow_mount: false
            });
            mountpoint = lookup.path;
            node = lookup.node;
            if (FS.isMountpoint(node)) {
                throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
            }
            if (!FS.isDir(node.mode)) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
            }
        }
        var mount = {
            type: type,
            opts: opts,
            mountpoint: mountpoint,
            mounts: []
        };
        var mountRoot = type.mount(mount);
        mountRoot.mount = mount;
        mount.root = mountRoot;
        if (root) {
            FS.root = mountRoot
        } else if (node) {
            node.mounted = mount;
            if (node.mount) {
                node.mount.mounts.push(mount)
            }
        }
        return mountRoot
    }),
    unmount: (function(mountpoint) {
        var lookup = FS.lookupPath(mountpoint, {
            follow_mount: false
        });
        if (!FS.isMountpoint(lookup.node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node = lookup.node;
        var mount = node.mounted;
        var mounts = FS.getMounts(mount);
        Object.keys(FS.nameTable).forEach((function(hash) {
            var current = FS.nameTable[hash];
            while (current) {
                var next = current.name_next;
                if (mounts.indexOf(current.mount) !== -1) {
                    FS.destroyNode(current)
                }
                current = next
            }
        }));
        node.mounted = null;
        var idx = node.mount.mounts.indexOf(mount);
        assert(idx !== -1);
        node.mount.mounts.splice(idx, 1)
    }),
    lookup: (function(parent, name) {
        return parent.node_ops.lookup(parent, name)
    }),
    mknod: (function(path, mode, dev) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        if (!name || name === "." || name === "..") {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var err = FS.mayCreate(parent, name);
        if (err) {
            throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.mknod) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return parent.node_ops.mknod(parent, name, mode, dev)
    }),
    create: (function(path, mode) {
        mode = mode !== undefined ? mode : 438;
        mode &= 4095;
        mode |= 32768;
        return FS.mknod(path, mode, 0)
    }),
    mkdir: (function(path, mode) {
        mode = mode !== undefined ? mode : 511;
        mode &= 511 | 512;
        mode |= 16384;
        return FS.mknod(path, mode, 0)
    }),
    mkdev: (function(path, mode, dev) {
        if (typeof dev === "undefined") {
            dev = mode;
            mode = 438
        }
        mode |= 8192;
        return FS.mknod(path, mode, dev)
    }),
    symlink: (function(oldpath, newpath) {
        if (!PATH.resolve(oldpath)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        var lookup = FS.lookupPath(newpath, {
            parent: true
        });
        var parent = lookup.node;
        if (!parent) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        var newname = PATH.basename(newpath);
        var err = FS.mayCreate(parent, newname);
        if (err) {
            throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.symlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return parent.node_ops.symlink(parent, newname, oldpath)
    }),
    rename: (function(old_path, new_path) {
        var old_dirname = PATH.dirname(old_path);
        var new_dirname = PATH.dirname(new_path);
        var old_name = PATH.basename(old_path);
        var new_name = PATH.basename(new_path);
        var lookup, old_dir, new_dir;
        try {
            lookup = FS.lookupPath(old_path, {
                parent: true
            });
            old_dir = lookup.node;
            lookup = FS.lookupPath(new_path, {
                parent: true
            });
            new_dir = lookup.node
        } catch (e) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        if (!old_dir || !new_dir) throw new FS.ErrnoError(ERRNO_CODES.ENOENT);
        if (old_dir.mount !== new_dir.mount) {
            throw new FS.ErrnoError(ERRNO_CODES.EXDEV)
        }
        var old_node = FS.lookupNode(old_dir, old_name);
        var relative = PATH.relative(old_path, new_dirname);
        if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        relative = PATH.relative(new_path, old_dirname);
        if (relative.charAt(0) !== ".") {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTEMPTY)
        }
        var new_node;
        try {
            new_node = FS.lookupNode(new_dir, new_name)
        } catch (e) {}
        if (old_node === new_node) {
            return
        }
        var isdir = FS.isDir(old_node.mode);
        var err = FS.mayDelete(old_dir, old_name, isdir);
        if (err) {
            throw new FS.ErrnoError(err)
        }
        err = new_node ? FS.mayDelete(new_dir, new_name, isdir) : FS.mayCreate(new_dir, new_name);
        if (err) {
            throw new FS.ErrnoError(err)
        }
        if (!old_dir.node_ops.rename) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(old_node) || new_node && FS.isMountpoint(new_node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        if (new_dir !== old_dir) {
            err = FS.nodePermissions(old_dir, "w");
            if (err) {
                throw new FS.ErrnoError(err)
            }
        }
        try {
            if (FS.trackingDelegate["willMovePath"]) {
                FS.trackingDelegate["willMovePath"](old_path, new_path)
            }
        } catch (e) {
            console.log("FS.trackingDelegate['willMovePath']('" + old_path + "', '" + new_path + "') threw an exception: " + e.message)
        }
        FS.hashRemoveNode(old_node);
        try {
            old_dir.node_ops.rename(old_node, new_dir, new_name)
        } catch (e) {
            throw e
        } finally {
            FS.hashAddNode(old_node)
        }
        try {
            if (FS.trackingDelegate["onMovePath"]) FS.trackingDelegate["onMovePath"](old_path, new_path)
        } catch (e) {
            console.log("FS.trackingDelegate['onMovePath']('" + old_path + "', '" + new_path + "') threw an exception: " + e.message)
        }
    }),
    rmdir: (function(path) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, true);
        if (err) {
            throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.rmdir) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        try {
            if (FS.trackingDelegate["willDeletePath"]) {
                FS.trackingDelegate["willDeletePath"](path)
            }
        } catch (e) {
            console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message)
        }
        parent.node_ops.rmdir(parent, name);
        FS.destroyNode(node);
        try {
            if (FS.trackingDelegate["onDeletePath"]) FS.trackingDelegate["onDeletePath"](path)
        } catch (e) {
            console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message)
        }
    }),
    readdir: (function(path) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        var node = lookup.node;
        if (!node.node_ops.readdir) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
        }
        return node.node_ops.readdir(node)
    }),
    unlink: (function(path) {
        var lookup = FS.lookupPath(path, {
            parent: true
        });
        var parent = lookup.node;
        var name = PATH.basename(path);
        var node = FS.lookupNode(parent, name);
        var err = FS.mayDelete(parent, name, false);
        if (err) {
            if (err === ERRNO_CODES.EISDIR) err = ERRNO_CODES.EPERM;
            throw new FS.ErrnoError(err)
        }
        if (!parent.node_ops.unlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isMountpoint(node)) {
            throw new FS.ErrnoError(ERRNO_CODES.EBUSY)
        }
        try {
            if (FS.trackingDelegate["willDeletePath"]) {
                FS.trackingDelegate["willDeletePath"](path)
            }
        } catch (e) {
            console.log("FS.trackingDelegate['willDeletePath']('" + path + "') threw an exception: " + e.message)
        }
        parent.node_ops.unlink(parent, name);
        FS.destroyNode(node);
        try {
            if (FS.trackingDelegate["onDeletePath"]) FS.trackingDelegate["onDeletePath"](path)
        } catch (e) {
            console.log("FS.trackingDelegate['onDeletePath']('" + path + "') threw an exception: " + e.message)
        }
    }),
    readlink: (function(path) {
        var lookup = FS.lookupPath(path);
        var link = lookup.node;
        if (!link) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (!link.node_ops.readlink) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        return link.node_ops.readlink(link)
    }),
    stat: (function(path, dontFollow) {
        var lookup = FS.lookupPath(path, {
            follow: !dontFollow
        });
        var node = lookup.node;
        if (!node) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (!node.node_ops.getattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        return node.node_ops.getattr(node)
    }),
    lstat: (function(path) {
        return FS.stat(path, true)
    }),
    chmod: (function(path, mode, dontFollow) {
        var node;
        if (typeof path === "string") {
            var lookup = FS.lookupPath(path, {
                follow: !dontFollow
            });
            node = lookup.node
        } else {
            node = path
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        node.node_ops.setattr(node, {
            mode: mode & 4095 | node.mode & ~4095,
            timestamp: Date.now()
        })
    }),
    lchmod: (function(path, mode) {
        FS.chmod(path, mode, true)
    }),
    fchmod: (function(fd, mode) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        FS.chmod(stream.node, mode)
    }),
    chown: (function(path, uid, gid, dontFollow) {
        var node;
        if (typeof path === "string") {
            var lookup = FS.lookupPath(path, {
                follow: !dontFollow
            });
            node = lookup.node
        } else {
            node = path
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        node.node_ops.setattr(node, {
            timestamp: Date.now()
        })
    }),
    lchown: (function(path, uid, gid) {
        FS.chown(path, uid, gid, true)
    }),
    fchown: (function(fd, uid, gid) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        FS.chown(stream.node, uid, gid)
    }),
    truncate: (function(path, len) {
        if (len < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var node;
        if (typeof path === "string") {
            var lookup = FS.lookupPath(path, {
                follow: true
            });
            node = lookup.node
        } else {
            node = path
        }
        if (!node.node_ops.setattr) {
            throw new FS.ErrnoError(ERRNO_CODES.EPERM)
        }
        if (FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!FS.isFile(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var err = FS.nodePermissions(node, "w");
        if (err) {
            throw new FS.ErrnoError(err)
        }
        node.node_ops.setattr(node, {
            size: len,
            timestamp: Date.now()
        })
    }),
    ftruncate: (function(fd, len) {
        var stream = FS.getStream(fd);
        if (!stream) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        FS.truncate(stream.node, len)
    }),
    utime: (function(path, atime, mtime) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        var node = lookup.node;
        node.node_ops.setattr(node, {
            timestamp: Math.max(atime, mtime)
        })
    }),
    open: (function(path, flags, mode, fd_start, fd_end) {
        if (path === "") {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        flags = typeof flags === "string" ? FS.modeStringToFlags(flags) : flags;
        mode = typeof mode === "undefined" ? 438 : mode;
        if (flags & 64) {
            mode = mode & 4095 | 32768
        } else {
            mode = 0
        }
        var node;
        if (typeof path === "object") {
            node = path
        } else {
            path = PATH.normalize(path);
            try {
                var lookup = FS.lookupPath(path, {
                    follow: !(flags & 131072)
                });
                node = lookup.node
            } catch (e) {}
        }
        var created = false;
        if (flags & 64) {
            if (node) {
                if (flags & 128) {
                    throw new FS.ErrnoError(ERRNO_CODES.EEXIST)
                }
            } else {
                node = FS.mknod(path, mode, 0);
                created = true
            }
        }
        if (!node) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOENT)
        }
        if (FS.isChrdev(node.mode)) {
            flags &= ~512
        }
        if (!created) {
            var err = FS.mayOpen(node, flags);
            if (err) {
                throw new FS.ErrnoError(err)
            }
        }
        if (flags & 512) {
            FS.truncate(node, 0)
        }
        flags &= ~(128 | 512);
        var stream = FS.createStream({
            node: node,
            path: FS.getPath(node),
            flags: flags,
            seekable: true,
            position: 0,
            stream_ops: node.stream_ops,
            ungotten: [],
            error: false
        }, fd_start, fd_end);
        if (stream.stream_ops.open) {
            stream.stream_ops.open(stream)
        }
        if (Module["logReadFiles"] && !(flags & 1)) {
            if (!FS.readFiles) FS.readFiles = {};
            if (!(path in FS.readFiles)) {
                FS.readFiles[path] = 1;
                Module["printErr"]("read file: " + path)
            }
        }
        try {
            if (FS.trackingDelegate["onOpenFile"]) {
                var trackingFlags = 0;
                if ((flags & 2097155) !== 1) {
                    trackingFlags |= FS.tracking.openFlags.READ
                }
                if ((flags & 2097155) !== 0) {
                    trackingFlags |= FS.tracking.openFlags.WRITE
                }
                FS.trackingDelegate["onOpenFile"](path, trackingFlags)
            }
        } catch (e) {
            console.log("FS.trackingDelegate['onOpenFile']('" + path + "', flags) threw an exception: " + e.message)
        }
        return stream
    }),
    close: (function(stream) {
        try {
            if (stream.stream_ops.close) {
                stream.stream_ops.close(stream)
            }
        } catch (e) {
            throw e
        } finally {
            FS.closeStream(stream.fd)
        }
    }),
    llseek: (function(stream, offset, whence) {
        if (!stream.seekable || !stream.stream_ops.llseek) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        stream.position = stream.stream_ops.llseek(stream, offset, whence);
        stream.ungotten = [];
        return stream.position
    }),
    read: (function(stream, buffer, offset, length, position) {
        if (length < 0 || position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!stream.stream_ops.read) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        var seeking = true;
        if (typeof position === "undefined") {
            position = stream.position;
            seeking = false
        } else if (!stream.seekable) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        var bytesRead = stream.stream_ops.read(stream, buffer, offset, length, position);
        if (!seeking) stream.position += bytesRead;
        return bytesRead
    }),
    write: (function(stream, buffer, offset, length, position, canOwn) {
        if (length < 0 || position < 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (FS.isDir(stream.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.EISDIR)
        }
        if (!stream.stream_ops.write) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if (stream.flags & 1024) {
            FS.llseek(stream, 0, 2)
        }
        var seeking = true;
        if (typeof position === "undefined") {
            position = stream.position;
            seeking = false
        } else if (!stream.seekable) {
            throw new FS.ErrnoError(ERRNO_CODES.ESPIPE)
        }
        var bytesWritten = stream.stream_ops.write(stream, buffer, offset, length, position, canOwn);
        if (!seeking) stream.position += bytesWritten;
        try {
            if (stream.path && FS.trackingDelegate["onWriteToFile"]) FS.trackingDelegate["onWriteToFile"](stream.path)
        } catch (e) {
            console.log("FS.trackingDelegate['onWriteToFile']('" + path + "') threw an exception: " + e.message)
        }
        return bytesWritten
    }),
    allocate: (function(stream, offset, length) {
        if (offset < 0 || length <= 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
        }
        if ((stream.flags & 2097155) === 0) {
            throw new FS.ErrnoError(ERRNO_CODES.EBADF)
        }
        if (!FS.isFile(stream.node.mode) && !FS.isDir(node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
        }
        if (!stream.stream_ops.allocate) {
            throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)
        }
        stream.stream_ops.allocate(stream, offset, length)
    }),
    mmap: (function(stream, buffer, offset, length, position, prot, flags) {
        if ((stream.flags & 2097155) === 1) {
            throw new FS.ErrnoError(ERRNO_CODES.EACCES)
        }
        if (!stream.stream_ops.mmap) {
            throw new FS.ErrnoError(ERRNO_CODES.ENODEV)
        }
        return stream.stream_ops.mmap(stream, buffer, offset, length, position, prot, flags)
    }),
    ioctl: (function(stream, cmd, arg) {
        if (!stream.stream_ops.ioctl) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTTY)
        }
        return stream.stream_ops.ioctl(stream, cmd, arg)
    }),
    readFile: (function(path, opts) {
        opts = opts || {};
        opts.flags = opts.flags || "r";
        opts.encoding = opts.encoding || "binary";
        if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
            throw new Error('Invalid encoding type "' + opts.encoding + '"')
        }
        var ret;
        var stream = FS.open(path, opts.flags);
        var stat = FS.stat(path);
        var length = stat.size;
        var buf = new Uint8Array(length);
        FS.read(stream, buf, 0, length, 0);
        if (opts.encoding === "utf8") {
            ret = "";
            var utf8 = new Runtime.UTF8Processor;
            for (var i = 0; i < length; i++) {
                ret += utf8.processCChar(buf[i])
            }
        } else if (opts.encoding === "binary") {
            ret = buf
        }
        FS.close(stream);
        return ret
    }),
    writeFile: (function(path, data, opts) {
        opts = opts || {};
        opts.flags = opts.flags || "w";
        opts.encoding = opts.encoding || "utf8";
        if (opts.encoding !== "utf8" && opts.encoding !== "binary") {
            throw new Error('Invalid encoding type "' + opts.encoding + '"')
        }
        var stream = FS.open(path, opts.flags, opts.mode);
        if (opts.encoding === "utf8") {
            var utf8 = new Runtime.UTF8Processor;
            var buf = new Uint8Array(utf8.processJSString(data));
            FS.write(stream, buf, 0, buf.length, 0, opts.canOwn)
        } else if (opts.encoding === "binary") {
            FS.write(stream, data, 0, data.length, 0, opts.canOwn)
        }
        FS.close(stream)
    }),
    cwd: (function() {
        return FS.currentPath
    }),
    chdir: (function(path) {
        var lookup = FS.lookupPath(path, {
            follow: true
        });
        if (!FS.isDir(lookup.node.mode)) {
            throw new FS.ErrnoError(ERRNO_CODES.ENOTDIR)
        }
        var err = FS.nodePermissions(lookup.node, "x");
        if (err) {
            throw new FS.ErrnoError(err)
        }
        FS.currentPath = lookup.path
    }),
    createDefaultDirectories: (function() {
        FS.mkdir("/tmp");
        FS.mkdir("/home");
        FS.mkdir("/home/web_user")
    }),
    createDefaultDevices: (function() {
        FS.mkdir("/dev");
        FS.registerDevice(FS.makedev(1, 3), {
            read: (function() {
                return 0
            }),
            write: (function() {
                return 0
            })
        });
        FS.mkdev("/dev/null", FS.makedev(1, 3));
        TTY.register(FS.makedev(5, 0), TTY.default_tty_ops);
        TTY.register(FS.makedev(6, 0), TTY.default_tty1_ops);
        FS.mkdev("/dev/tty", FS.makedev(5, 0));
        FS.mkdev("/dev/tty1", FS.makedev(6, 0));
        var random_device;
        if (typeof crypto !== "undefined") {
            var randomBuffer = new Uint8Array(1);
            random_device = (function() {
                crypto.getRandomValues(randomBuffer);
                return randomBuffer[0]
            })
        } else if (ENVIRONMENT_IS_NODE) {
            random_device = (function() {
                return 12
            })
        } else {
            random_device = (function() {
                return Math.random() * 256 | 0
            })
        }
        FS.createDevice("/dev", "random", random_device);
        FS.createDevice("/dev", "urandom", random_device);
        FS.mkdir("/dev/shm");
        FS.mkdir("/dev/shm/tmp")
    }),
    createStandardStreams: (function() {
        if (Module["stdin"]) {
            FS.createDevice("/dev", "stdin", Module["stdin"])
        } else {
            FS.symlink("/dev/tty", "/dev/stdin")
        }
        if (Module["stdout"]) {
            FS.createDevice("/dev", "stdout", null, Module["stdout"])
        } else {
            FS.symlink("/dev/tty", "/dev/stdout")
        }
        if (Module["stderr"]) {
            FS.createDevice("/dev", "stderr", null, Module["stderr"])
        } else {
            FS.symlink("/dev/tty1", "/dev/stderr")
        }
        var stdin = FS.open("/dev/stdin", "r");
        HEAP32[_stdin >> 2] = FS.getPtrForStream(stdin);
        assert(stdin.fd === 0, "invalid handle for stdin (" + stdin.fd + ")");
        var stdout = FS.open("/dev/stdout", "w");
        HEAP32[_stdout >> 2] = FS.getPtrForStream(stdout);
        assert(stdout.fd === 1, "invalid handle for stdout (" + stdout.fd + ")");
        var stderr = FS.open("/dev/stderr", "w");
        HEAP32[_stderr >> 2] = FS.getPtrForStream(stderr);
        assert(stderr.fd === 2, "invalid handle for stderr (" + stderr.fd + ")")
    }),
    ensureErrnoError: (function() {
        if (FS.ErrnoError) return;
        FS.ErrnoError = function ErrnoError(errno, node) {
            this.node = node;
            this.setErrno = (function(errno) {
                this.errno = errno;
                for (var key in ERRNO_CODES) {
                    if (ERRNO_CODES[key] === errno) {
                        this.code = key;
                        break
                    }
                }
            });
            this.setErrno(errno);
            this.message = ERRNO_MESSAGES[errno]
        };
        FS.ErrnoError.prototype = new Error;
        FS.ErrnoError.prototype.constructor = FS.ErrnoError;
        [ERRNO_CODES.ENOENT].forEach((function(code) {
            FS.genericErrors[code] = new FS.ErrnoError(code);
            FS.genericErrors[code].stack = "<generic error, no stack>"
        }))
    }),
    staticInit: (function() {
        FS.ensureErrnoError();
        FS.nameTable = new Array(4096);
        FS.mount(MEMFS, {}, "/");
        FS.createDefaultDirectories();
        FS.createDefaultDevices()
    }),
    init: (function(input, output, error) {
        assert(!FS.init.initialized, "FS.init was previously called. If you want to initialize later with custom parameters, remove any earlier calls (note that one is automatically added to the generated code)");
        FS.init.initialized = true;
        FS.ensureErrnoError();
        Module["stdin"] = input || Module["stdin"];
        Module["stdout"] = output || Module["stdout"];
        Module["stderr"] = error || Module["stderr"];
        FS.createStandardStreams()
    }),
    quit: (function() {
        FS.init.initialized = false;
        for (var i = 0; i < FS.streams.length; i++) {
            var stream = FS.streams[i];
            if (!stream) {
                continue
            }
            FS.close(stream)
        }
    }),
    getMode: (function(canRead, canWrite) {
        var mode = 0;
        if (canRead) mode |= 292 | 73;
        if (canWrite) mode |= 146;
        return mode
    }),
    joinPath: (function(parts, forceRelative) {
        var path = PATH.join.apply(null, parts);
        if (forceRelative && path[0] == "/") path = path.substr(1);
        return path
    }),
    absolutePath: (function(relative, base) {
        return PATH.resolve(base, relative)
    }),
    standardizePath: (function(path) {
        return PATH.normalize(path)
    }),
    findObject: (function(path, dontResolveLastLink) {
        var ret = FS.analyzePath(path, dontResolveLastLink);
        if (ret.exists) {
            return ret.object
        } else {
            ___setErrNo(ret.error);
            return null
        }
    }),
    analyzePath: (function(path, dontResolveLastLink) {
        try {
            var lookup = FS.lookupPath(path, {
                follow: !dontResolveLastLink
            });
            path = lookup.path
        } catch (e) {}
        var ret = {
            isRoot: false,
            exists: false,
            error: 0,
            name: null,
            path: null,
            object: null,
            parentExists: false,
            parentPath: null,
            parentObject: null
        };
        try {
            var lookup = FS.lookupPath(path, {
                parent: true
            });
            ret.parentExists = true;
            ret.parentPath = lookup.path;
            ret.parentObject = lookup.node;
            ret.name = PATH.basename(path);
            lookup = FS.lookupPath(path, {
                follow: !dontResolveLastLink
            });
            ret.exists = true;
            ret.path = lookup.path;
            ret.object = lookup.node;
            ret.name = lookup.node.name;
            ret.isRoot = lookup.path === "/"
        } catch (e) {
            ret.error = e.errno
        }
        return ret
    }),
    createFolder: (function(parent, name, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.mkdir(path, mode)
    }),
    createPath: (function(parent, path, canRead, canWrite) {
        parent = typeof parent === "string" ? parent : FS.getPath(parent);
        var parts = path.split("/").reverse();
        while (parts.length) {
            var part = parts.pop();
            if (!part) continue;
            var current = PATH.join2(parent, part);
            try {
                FS.mkdir(current)
            } catch (e) {}
            parent = current
        }
        return current
    }),
    createFile: (function(parent, name, properties, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(canRead, canWrite);
        return FS.create(path, mode)
    }),
    createDataFile: (function(parent, name, data, canRead, canWrite, canOwn) {
        var path = name ? PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name) : parent;
        var mode = FS.getMode(canRead, canWrite);
        var node = FS.create(path, mode);
        if (data) {
            if (typeof data === "string") {
                var arr = new Array(data.length);
                for (var i = 0, len = data.length; i < len; ++i) arr[i] = data.charCodeAt(i);
                data = arr
            }
            FS.chmod(node, mode | 146);
            var stream = FS.open(node, "w");
            FS.write(stream, data, 0, data.length, 0, canOwn);
            FS.close(stream);
            FS.chmod(node, mode)
        }
        return node
    }),
    createDevice: (function(parent, name, input, output) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
        var mode = FS.getMode(!!input, !!output);
        if (!FS.createDevice.major) FS.createDevice.major = 64;
        var dev = FS.makedev(FS.createDevice.major++, 0);
        FS.registerDevice(dev, {
            open: (function(stream) {
                stream.seekable = false
            }),
            close: (function(stream) {
                if (output && output.buffer && output.buffer.length) {
                    output(10)
                }
            }),
            read: (function(stream, buffer, offset, length, pos) {
                var bytesRead = 0;
                for (var i = 0; i < length; i++) {
                    var result;
                    try {
                        result = input()
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES.EIO)
                    }
                    if (result === undefined && bytesRead === 0) {
                        throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
                    }
                    if (result === null || result === undefined) break;
                    bytesRead++;
                    buffer[offset + i] = result
                }
                if (bytesRead) {
                    stream.node.timestamp = Date.now()
                }
                return bytesRead
            }),
            write: (function(stream, buffer, offset, length, pos) {
                for (var i = 0; i < length; i++) {
                    try {
                        output(buffer[offset + i])
                    } catch (e) {
                        throw new FS.ErrnoError(ERRNO_CODES.EIO)
                    }
                }
                if (length) {
                    stream.node.timestamp = Date.now()
                }
                return i
            })
        });
        return FS.mkdev(path, mode, dev)
    }),
    createLink: (function(parent, name, target, canRead, canWrite) {
        var path = PATH.join2(typeof parent === "string" ? parent : FS.getPath(parent), name);
        return FS.symlink(target, path)
    }),
    forceLoadFile: (function(obj) {
        if (obj.isDevice || obj.isFolder || obj.link || obj.contents) return true;
        var success = true;
        if (typeof XMLHttpRequest !== "undefined") {
            throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")
        } else if (Module["read"]) {
            try {
                obj.contents = intArrayFromString(Module["read"](obj.url), true);
                obj.usedBytes = obj.contents.length
            } catch (e) {
                success = false
            }
        } else {
            throw new Error("Cannot load without read() or XMLHttpRequest.")
        }
        if (!success) ___setErrNo(ERRNO_CODES.EIO);
        return success
    }),
    createLazyFile: (function(parent, name, url, canRead, canWrite) {
        function LazyUint8Array() {
            this.lengthKnown = false;
            this.chunks = []
        }
        LazyUint8Array.prototype.get = function LazyUint8Array_get(idx) {
            if (idx > this.length - 1 || idx < 0) {
                return undefined
            }
            var chunkOffset = idx % this.chunkSize;
            var chunkNum = idx / this.chunkSize | 0;
            return this.getter(chunkNum)[chunkOffset]
        };
        LazyUint8Array.prototype.setDataGetter = function LazyUint8Array_setDataGetter(getter) {
            this.getter = getter
        };
        LazyUint8Array.prototype.cacheLength = function LazyUint8Array_cacheLength() {
            var xhr = new XMLHttpRequest;
            xhr.open("HEAD", url, false);
            xhr.send(null);
            if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
            var datalength = Number(xhr.getResponseHeader("Content-length"));
            var header;
            var hasByteServing = (header = xhr.getResponseHeader("Accept-Ranges")) && header === "bytes";
            var chunkSize = 1024 * 1024;
            if (!hasByteServing) chunkSize = datalength;
            var doXHR = (function(from, to) {
                if (from > to) throw new Error("invalid range (" + from + ", " + to + ") or no bytes requested!");
                if (to > datalength - 1) throw new Error("only " + datalength + " bytes available! programmer error!");
                var xhr = new XMLHttpRequest;
                xhr.open("GET", url, false);
                if (datalength !== chunkSize) xhr.setRequestHeader("Range", "bytes=" + from + "-" + to);
                if (typeof Uint8Array != "undefined") xhr.responseType = "arraybuffer";
                if (xhr.overrideMimeType) {
                    xhr.overrideMimeType("text/plain; charset=x-user-defined")
                }
                xhr.send(null);
                if (!(xhr.status >= 200 && xhr.status < 300 || xhr.status === 304)) throw new Error("Couldn't load " + url + ". Status: " + xhr.status);
                if (xhr.response !== undefined) {
                    return new Uint8Array(xhr.response || [])
                } else {
                    return intArrayFromString(xhr.responseText || "", true)
                }
            });
            var lazyArray = this;
            lazyArray.setDataGetter((function(chunkNum) {
                var start = chunkNum * chunkSize;
                var end = (chunkNum + 1) * chunkSize - 1;
                end = Math.min(end, datalength - 1);
                if (typeof lazyArray.chunks[chunkNum] === "undefined") {
                    lazyArray.chunks[chunkNum] = doXHR(start, end)
                }
                if (typeof lazyArray.chunks[chunkNum] === "undefined") throw new Error("doXHR failed!");
                return lazyArray.chunks[chunkNum]
            }));
            this._length = datalength;
            this._chunkSize = chunkSize;
            this.lengthKnown = true
        };
        if (typeof XMLHttpRequest !== "undefined") {
            if (!ENVIRONMENT_IS_WORKER) throw "Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";
            var lazyArray = new LazyUint8Array;
            Object.defineProperty(lazyArray, "length", {
                get: (function() {
                    if (!this.lengthKnown) {
                        this.cacheLength()
                    }
                    return this._length
                })
            });
            Object.defineProperty(lazyArray, "chunkSize", {
                get: (function() {
                    if (!this.lengthKnown) {
                        this.cacheLength()
                    }
                    return this._chunkSize
                })
            });
            var properties = {
                isDevice: false,
                contents: lazyArray
            }
        } else {
            var properties = {
                isDevice: false,
                url: url
            }
        }
        var node = FS.createFile(parent, name, properties, canRead, canWrite);
        if (properties.contents) {
            node.contents = properties.contents
        } else if (properties.url) {
            node.contents = null;
            node.url = properties.url
        }
        Object.defineProperty(node, "usedBytes", {
            get: (function() {
                return this.contents.length
            })
        });
        var stream_ops = {};
        var keys = Object.keys(node.stream_ops);
        keys.forEach((function(key) {
            var fn = node.stream_ops[key];
            stream_ops[key] = function forceLoadLazyFile() {
                if (!FS.forceLoadFile(node)) {
                    throw new FS.ErrnoError(ERRNO_CODES.EIO)
                }
                return fn.apply(null, arguments)
            }
        }));
        stream_ops.read = function stream_ops_read(stream, buffer, offset, length, position) {
            if (!FS.forceLoadFile(node)) {
                throw new FS.ErrnoError(ERRNO_CODES.EIO)
            }
            var contents = stream.node.contents;
            if (position >= contents.length) return 0;
            var size = Math.min(contents.length - position, length);
            assert(size >= 0);
            if (contents.slice) {
                for (var i = 0; i < size; i++) {
                    buffer[offset + i] = contents[position + i]
                }
            } else {
                for (var i = 0; i < size; i++) {
                    buffer[offset + i] = contents.get(position + i)
                }
            }
            return size
        };
        node.stream_ops = stream_ops;
        return node
    }),
    createPreloadedFile: (function(parent, name, url, canRead, canWrite, onload, onerror, dontCreateFile, canOwn) {
        Browser.init();
        var fullname = name ? PATH.resolve(PATH.join2(parent, name)) : parent;

        function processData(byteArray) {
            function finish(byteArray) {
                if (!dontCreateFile) {
                    FS.createDataFile(parent, name, byteArray, canRead, canWrite, canOwn)
                }
                if (onload) onload();
                removeRunDependency("cp " + fullname)
            }
            var handled = false;
            Module["preloadPlugins"].forEach((function(plugin) {
                if (handled) return;
                if (plugin["canHandle"](fullname)) {
                    plugin["handle"](byteArray, fullname, finish, (function() {
                        if (onerror) onerror();
                        removeRunDependency("cp " + fullname)
                    }));
                    handled = true
                }
            }));
            if (!handled) finish(byteArray)
        }
        addRunDependency("cp " + fullname);
        if (typeof url == "string") {
            Browser.asyncLoad(url, (function(byteArray) {
                processData(byteArray)
            }), onerror)
        } else {
            processData(url)
        }
    }),
    indexedDB: (function() {
        return window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB
    }),
    DB_NAME: (function() {
        return "EM_FS_" + window.location.pathname
    }),
    DB_VERSION: 20,
    DB_STORE_NAME: "FILE_DATA",
    saveFilesToDB: (function(paths, onload, onerror) {
        onload = onload || (function() {});
        onerror = onerror || (function() {});
        var indexedDB = FS.indexedDB();
        try {
            var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION)
        } catch (e) {
            return onerror(e)
        }
        openRequest.onupgradeneeded = function openRequest_onupgradeneeded() {
            console.log("creating db");
            var db = openRequest.result;
            db.createObjectStore(FS.DB_STORE_NAME)
        };
        openRequest.onsuccess = function openRequest_onsuccess() {
            var db = openRequest.result;
            var transaction = db.transaction([FS.DB_STORE_NAME], "readwrite");
            var files = transaction.objectStore(FS.DB_STORE_NAME);
            var ok = 0,
                fail = 0,
                total = paths.length;

            function finish() {
                if (fail == 0) onload();
                else onerror()
            }
            paths.forEach((function(path) {
                var putRequest = files.put(FS.analyzePath(path).object.contents, path);
                putRequest.onsuccess = function putRequest_onsuccess() {
                    ok++;
                    if (ok + fail == total) finish()
                };
                putRequest.onerror = function putRequest_onerror() {
                    fail++;
                    if (ok + fail == total) finish()
                }
            }));
            transaction.onerror = onerror
        };
        openRequest.onerror = onerror
    }),
    loadFilesFromDB: (function(paths, onload, onerror) {
        onload = onload || (function() {});
        onerror = onerror || (function() {});
        var indexedDB = FS.indexedDB();
        try {
            var openRequest = indexedDB.open(FS.DB_NAME(), FS.DB_VERSION)
        } catch (e) {
            return onerror(e)
        }
        openRequest.onupgradeneeded = onerror;
        openRequest.onsuccess = function openRequest_onsuccess() {
            var db = openRequest.result;
            try {
                var transaction = db.transaction([FS.DB_STORE_NAME], "readonly")
            } catch (e) {
                onerror(e);
                return
            }
            var files = transaction.objectStore(FS.DB_STORE_NAME);
            var ok = 0,
                fail = 0,
                total = paths.length;

            function finish() {
                if (fail == 0) onload();
                else onerror()
            }
            paths.forEach((function(path) {
                var getRequest = files.get(path);
                getRequest.onsuccess = function getRequest_onsuccess() {
                    if (FS.analyzePath(path).exists) {
                        FS.unlink(path)
                    }
                    FS.createDataFile(PATH.dirname(path), PATH.basename(path), getRequest.result, true, true, true);
                    ok++;
                    if (ok + fail == total) finish()
                };
                getRequest.onerror = function getRequest_onerror() {
                    fail++;
                    if (ok + fail == total) finish()
                }
            }));
            transaction.onerror = onerror
        };
        openRequest.onerror = onerror
    })
};

function _mkport() {
    throw "TODO"
}
var SOCKFS = {
    mount: (function(mount) {
        Module["websocket"] = Module["websocket"] && "object" === typeof Module["websocket"] ? Module["websocket"] : {};
        Module["websocket"]._callbacks = {};
        Module["websocket"]["on"] = (function(event, callback) {
            if ("function" === typeof callback) {
                this._callbacks[event] = callback
            }
            return this
        });
        Module["websocket"].emit = (function(event, param) {
            if ("function" === typeof this._callbacks[event]) {
                this._callbacks[event].call(this, param)
            }
        });
        return FS.createNode(null, "/", 16384 | 511, 0)
    }),
    createSocket: (function(family, type, protocol) {
        var streaming = type == 1;
        if (protocol) {
            assert(streaming == (protocol == 6))
        }
        var sock = {
            family: family,
            type: type,
            protocol: protocol,
            server: null,
            error: null,
            peers: {},
            pending: [],
            recv_queue: [],
            sock_ops: SOCKFS.websocket_sock_ops
        };
        var name = SOCKFS.nextname();
        var node = FS.createNode(SOCKFS.root, name, 49152, 0);
        node.sock = sock;
        var stream = FS.createStream({
            path: name,
            node: node,
            flags: FS.modeStringToFlags("r+"),
            seekable: false,
            stream_ops: SOCKFS.stream_ops
        });
        sock.stream = stream;
        return sock
    }),
    getSocket: (function(fd) {
        var stream = FS.getStream(fd);
        if (!stream || !FS.isSocket(stream.node.mode)) {
            return null
        }
        return stream.node.sock
    }),
    stream_ops: {
        poll: (function(stream) {
            var sock = stream.node.sock;
            return sock.sock_ops.poll(sock)
        }),
        ioctl: (function(stream, request, varargs) {
            var sock = stream.node.sock;
            return sock.sock_ops.ioctl(sock, request, varargs)
        }),
        read: (function(stream, buffer, offset, length, position) {
            var sock = stream.node.sock;
            var msg = sock.sock_ops.recvmsg(sock, length);
            if (!msg) {
                return 0
            }
            buffer.set(msg.buffer, offset);
            return msg.buffer.length
        }),
        write: (function(stream, buffer, offset, length, position) {
            var sock = stream.node.sock;
            return sock.sock_ops.sendmsg(sock, buffer, offset, length)
        }),
        close: (function(stream) {
            var sock = stream.node.sock;
            sock.sock_ops.close(sock)
        })
    },
    nextname: (function() {
        if (!SOCKFS.nextname.current) {
            SOCKFS.nextname.current = 0
        }
        return "socket[" + SOCKFS.nextname.current++ + "]"
    }),
    websocket_sock_ops: {
        createPeer: (function(sock, addr, port) {
            var ws;
            if (typeof addr === "object") {
                ws = addr;
                addr = null;
                port = null
            }
            if (ws) {
                if (ws._socket) {
                    addr = ws._socket.remoteAddress;
                    port = ws._socket.remotePort
                } else {
                    var result = /ws[s]?:\/\/([^:]+):(\d+)/.exec(ws.url);
                    if (!result) {
                        throw new Error("WebSocket URL must be in the format ws(s)://address:port")
                    }
                    addr = result[1];
                    port = parseInt(result[2], 10)
                }
            } else {
                try {
                    var runtimeConfig = Module["websocket"] && "object" === typeof Module["websocket"];
                    var url = "ws:#".replace("#", "//");
                    if (runtimeConfig) {
                        if ("string" === typeof Module["websocket"]["url"]) {
                            url = Module["websocket"]["url"]
                        }
                    }
                    if (url === "ws://" || url === "wss://") {
                        var parts = addr.split("/");
                        url = url + parts[0] + ":" + port + "/" + parts.slice(1).join("/")
                    }
                    var subProtocols = "binary";
                    if (runtimeConfig) {
                        if ("string" === typeof Module["websocket"]["subprotocol"]) {
                            subProtocols = Module["websocket"]["subprotocol"]
                        }
                    }
                    subProtocols = subProtocols.replace(/^ +| +$/g, "").split(/ *, */);
                    var opts = ENVIRONMENT_IS_NODE ? {
                        "protocol": subProtocols.toString()
                    } : subProtocols;
                    var WebSocket = ENVIRONMENT_IS_NODE ? false : window["WebSocket"];
                    ws = new WebSocket(url, opts);
                    ws.binaryType = "arraybuffer"
                } catch (e) {
                    throw new FS.ErrnoError(ERRNO_CODES.EHOSTUNREACH)
                }
            }
            var peer = {
                addr: addr,
                port: port,
                socket: ws,
                dgram_send_queue: []
            };
            SOCKFS.websocket_sock_ops.addPeer(sock, peer);
            SOCKFS.websocket_sock_ops.handlePeerEvents(sock, peer);
            if (sock.type === 2 && typeof sock.sport !== "undefined") {
                peer.dgram_send_queue.push(new Uint8Array([255, 255, 255, 255, "p".charCodeAt(0), "o".charCodeAt(0), "r".charCodeAt(0), "t".charCodeAt(0), (sock.sport & 65280) >> 8, sock.sport & 255]))
            }
            return peer
        }),
        getPeer: (function(sock, addr, port) {
            return sock.peers[addr + ":" + port]
        }),
        addPeer: (function(sock, peer) {
            sock.peers[peer.addr + ":" + peer.port] = peer
        }),
        removePeer: (function(sock, peer) {
            delete sock.peers[peer.addr + ":" + peer.port]
        }),
        handlePeerEvents: (function(sock, peer) {
            var first = true;
            var handleOpen = (function() {
                Module["websocket"].emit("open", sock.stream.fd);
                try {
                    var queued = peer.dgram_send_queue.shift();
                    while (queued) {
                        peer.socket.send(queued);
                        queued = peer.dgram_send_queue.shift()
                    }
                } catch (e) {
                    peer.socket.close()
                }
            });

            function handleMessage(data) {
                assert(typeof data !== "string" && data.byteLength !== undefined);
                data = new Uint8Array(data);
                var wasfirst = first;
                first = false;
                if (wasfirst && data.length === 10 && data[0] === 255 && data[1] === 255 && data[2] === 255 && data[3] === 255 && data[4] === "p".charCodeAt(0) && data[5] === "o".charCodeAt(0) && data[6] === "r".charCodeAt(0) && data[7] === "t".charCodeAt(0)) {
                    var newport = data[8] << 8 | data[9];
                    SOCKFS.websocket_sock_ops.removePeer(sock, peer);
                    peer.port = newport;
                    SOCKFS.websocket_sock_ops.addPeer(sock, peer);
                    return
                }
                sock.recv_queue.push({
                    addr: peer.addr,
                    port: peer.port,
                    data: data
                });
                Module["websocket"].emit("message", sock.stream.fd)
            }
            if (ENVIRONMENT_IS_NODE) {
                peer.socket.on("open", handleOpen);
                peer.socket.on("message", (function(data, flags) {
                    if (!flags.binary) {
                        return
                    }
                    handleMessage((new Uint8Array(data)).buffer)
                }));
                peer.socket.on("close", (function() {
                    Module["websocket"].emit("close", sock.stream.fd)
                }));
                peer.socket.on("error", (function(error) {
                    sock.error = ERRNO_CODES.ECONNREFUSED;
                    Module["websocket"].emit("error", [sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused"])
                }))
            } else {
                peer.socket.onopen = handleOpen;
                peer.socket.onclose = (function() {
                    Module["websocket"].emit("close", sock.stream.fd)
                });
                peer.socket.onmessage = function peer_socket_onmessage(event) {
                    handleMessage(event.data)
                };
                peer.socket.onerror = (function(error) {
                    sock.error = ERRNO_CODES.ECONNREFUSED;
                    Module["websocket"].emit("error", [sock.stream.fd, sock.error, "ECONNREFUSED: Connection refused"])
                })
            }
        }),
        poll: (function(sock) {
            if (sock.type === 1 && sock.server) {
                return sock.pending.length ? 64 | 1 : 0
            }
            var mask = 0;
            var dest = sock.type === 1 ? SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport) : null;
            if (sock.recv_queue.length || !dest || dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
                mask |= 64 | 1
            }
            if (!dest || dest && dest.socket.readyState === dest.socket.OPEN) {
                mask |= 4
            }
            if (dest && dest.socket.readyState === dest.socket.CLOSING || dest && dest.socket.readyState === dest.socket.CLOSED) {
                mask |= 16
            }
            return mask
        }),
        ioctl: (function(sock, request, arg) {
            switch (request) {
                case 21531:
                    var bytes = 0;
                    if (sock.recv_queue.length) {
                        bytes = sock.recv_queue[0].data.length
                    }
                    HEAP32[arg >> 2] = bytes;
                    return 0;
                default:
                    return ERRNO_CODES.EINVAL
            }
        }),
        close: (function(sock) {
            if (sock.server) {
                try {
                    sock.server.close()
                } catch (e) {}
                sock.server = null
            }
            var peers = Object.keys(sock.peers);
            for (var i = 0; i < peers.length; i++) {
                var peer = sock.peers[peers[i]];
                try {
                    peer.socket.close()
                } catch (e) {}
                SOCKFS.websocket_sock_ops.removePeer(sock, peer)
            }
            return 0
        }),
        bind: (function(sock, addr, port) {
            if (typeof sock.saddr !== "undefined" || typeof sock.sport !== "undefined") {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            sock.saddr = addr;
            sock.sport = port || _mkport();
            if (sock.type === 2) {
                if (sock.server) {
                    sock.server.close();
                    sock.server = null
                }
                try {
                    sock.sock_ops.listen(sock, 0)
                } catch (e) {
                    if (!(e instanceof FS.ErrnoError)) throw e;
                    if (e.errno !== ERRNO_CODES.EOPNOTSUPP) throw e
                }
            }
        }),
        connect: (function(sock, addr, port) {
            if (sock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)
            }
            if (typeof sock.daddr !== "undefined" && typeof sock.dport !== "undefined") {
                var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
                if (dest) {
                    if (dest.socket.readyState === dest.socket.CONNECTING) {
                        throw new FS.ErrnoError(ERRNO_CODES.EALREADY)
                    } else {
                        throw new FS.ErrnoError(ERRNO_CODES.EISCONN)
                    }
                }
            }
            var peer = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port);
            sock.daddr = peer.addr;
            sock.dport = peer.port;
            throw new FS.ErrnoError(ERRNO_CODES.EINPROGRESS)
        }),
        listen: (function(sock, backlog) {
            if (!ENVIRONMENT_IS_NODE) {
                throw new FS.ErrnoError(ERRNO_CODES.EOPNOTSUPP)
            }
            if (sock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            var WebSocketServer = {};
            var host = sock.saddr;
            sock.server = new WebSocketServer({
                host: host,
                port: sock.sport
            });
            Module["websocket"].emit("listen", sock.stream.fd);
            sock.server.on("connection", (function(ws) {
                if (sock.type === 1) {
                    var newsock = SOCKFS.createSocket(sock.family, sock.type, sock.protocol);
                    var peer = SOCKFS.websocket_sock_ops.createPeer(newsock, ws);
                    newsock.daddr = peer.addr;
                    newsock.dport = peer.port;
                    sock.pending.push(newsock);
                    Module["websocket"].emit("connection", newsock.stream.fd)
                } else {
                    SOCKFS.websocket_sock_ops.createPeer(sock, ws);
                    Module["websocket"].emit("connection", sock.stream.fd)
                }
            }));
            sock.server.on("closed", (function() {
                Module["websocket"].emit("close", sock.stream.fd);
                sock.server = null
            }));
            sock.server.on("error", (function(error) {
                sock.error = ERRNO_CODES.EHOSTUNREACH;
                Module["websocket"].emit("error", [sock.stream.fd, sock.error, "EHOSTUNREACH: Host is unreachable"])
            }))
        }),
        accept: (function(listensock) {
            if (!listensock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
            var newsock = listensock.pending.shift();
            newsock.stream.flags = listensock.stream.flags;
            return newsock
        }),
        getname: (function(sock, peer) {
            var addr, port;
            if (peer) {
                if (sock.daddr === undefined || sock.dport === undefined) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)
                }
                addr = sock.daddr;
                port = sock.dport
            } else {
                addr = sock.saddr || 0;
                port = sock.sport || 0
            }
            return {
                addr: addr,
                port: port
            }
        }),
        sendmsg: (function(sock, buffer, offset, length, addr, port) {
            if (sock.type === 2) {
                if (addr === undefined || port === undefined) {
                    addr = sock.daddr;
                    port = sock.dport
                }
                if (addr === undefined || port === undefined) {
                    throw new FS.ErrnoError(ERRNO_CODES.EDESTADDRREQ)
                }
            } else {
                addr = sock.daddr;
                port = sock.dport
            }
            var dest = SOCKFS.websocket_sock_ops.getPeer(sock, addr, port);
            if (sock.type === 1) {
                if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                    throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)
                } else if (dest.socket.readyState === dest.socket.CONNECTING) {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
                }
            }
            var data;
            if (buffer instanceof Array || buffer instanceof ArrayBuffer) {
                data = buffer.slice(offset, offset + length)
            } else {
                data = buffer.buffer.slice(buffer.byteOffset + offset, buffer.byteOffset + offset + length)
            }
            if (sock.type === 2) {
                if (!dest || dest.socket.readyState !== dest.socket.OPEN) {
                    if (!dest || dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                        dest = SOCKFS.websocket_sock_ops.createPeer(sock, addr, port)
                    }
                    dest.dgram_send_queue.push(data);
                    return length
                }
            }
            try {
                dest.socket.send(data);
                return length
            } catch (e) {
                throw new FS.ErrnoError(ERRNO_CODES.EINVAL)
            }
        }),
        recvmsg: (function(sock, length) {
            if (sock.type === 1 && sock.server) {
                throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)
            }
            var queued = sock.recv_queue.shift();
            if (!queued) {
                if (sock.type === 1) {
                    var dest = SOCKFS.websocket_sock_ops.getPeer(sock, sock.daddr, sock.dport);
                    if (!dest) {
                        throw new FS.ErrnoError(ERRNO_CODES.ENOTCONN)
                    } else if (dest.socket.readyState === dest.socket.CLOSING || dest.socket.readyState === dest.socket.CLOSED) {
                        return null
                    } else {
                        throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
                    }
                } else {
                    throw new FS.ErrnoError(ERRNO_CODES.EAGAIN)
                }
            }
            var queuedLength = queued.data.byteLength || queued.data.length;
            var queuedOffset = queued.data.byteOffset || 0;
            var queuedBuffer = queued.data.buffer || queued.data;
            var bytesRead = Math.min(length, queuedLength);
            var res = {
                buffer: new Uint8Array(queuedBuffer, queuedOffset, bytesRead),
                addr: queued.addr,
                port: queued.port
            };
            if (sock.type === 1 && bytesRead < queuedLength) {
                var bytesRemaining = queuedLength - bytesRead;
                queued.data = new Uint8Array(queuedBuffer, queuedOffset + bytesRead, bytesRemaining);
                sock.recv_queue.unshift(queued)
            }
            return res
        })
    }
};

function _recv(fd, buf, len, flags) {
    var sock = SOCKFS.getSocket(fd);
    if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    return _read(fd, buf, len)
}

function _pread(fildes, buf, nbyte, offset) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte, offset)
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _read(fildes, buf, nbyte) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    try {
        var slab = HEAP8;
        return FS.read(stream, slab, buf, nbyte)
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _fread(ptr, size, nitems, stream) {
    var bytesToRead = nitems * size;
    if (bytesToRead == 0) {
        return 0
    }
    var bytesRead = 0;
    var streamObj = FS.getStreamFromPtr(stream);
    if (!streamObj) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return 0
    }
    while (streamObj.ungotten.length && bytesToRead > 0) {
        HEAP8[ptr++ >> 0] = streamObj.ungotten.pop();
        bytesToRead--;
        bytesRead++
    }
    var err = _read(streamObj.fd, ptr, bytesToRead);
    if (err == -1) {
        if (streamObj) streamObj.error = true;
        return 0
    }
    bytesRead += err;
    if (bytesRead < bytesToRead) streamObj.eof = true;
    return bytesRead / size | 0
}

function _fgetc(stream) {
    var streamObj = FS.getStreamFromPtr(stream);
    if (!streamObj) return -1;
    if (streamObj.eof || streamObj.error) return -1;
    var ret = _fread(_fgetc.ret, 1, 1, stream);
    if (ret == 0) {
        return -1
    } else if (ret == -1) {
        streamObj.error = true;
        return -1
    } else {
        return HEAPU8[_fgetc.ret >> 0]
    }
}
Module["_memset"] = _memset;

function _close(fildes) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    try {
        FS.close(stream);
        return 0
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _fsync(fildes) {
    var stream = FS.getStream(fildes);
    if (stream) {
        return 0
    } else {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
}

function _fileno(stream) {
    stream = FS.getStreamFromPtr(stream);
    if (!stream) return -1;
    return stream.fd
}

function _fclose(stream) {
    var fd = _fileno(stream);
    _fsync(fd);
    return _close(fd)
}
Module["_strlen"] = _strlen;
Module["_strcat"] = _strcat;

function _strerror_r(errnum, strerrbuf, buflen) {
    if (errnum in ERRNO_MESSAGES) {
        if (ERRNO_MESSAGES[errnum].length > buflen - 1) {
            return ___setErrNo(ERRNO_CODES.ERANGE)
        } else {
            var msg = ERRNO_MESSAGES[errnum];
            writeAsciiToMemory(msg, strerrbuf);
            return 0
        }
    } else {
        return ___setErrNo(ERRNO_CODES.EINVAL)
    }
}

function _strerror(errnum) {
    if (!_strerror.buffer) _strerror.buffer = _malloc(256);
    _strerror_r(errnum, _strerror.buffer, 256);
    return _strerror.buffer
}
Module["_bitshift64Shl"] = _bitshift64Shl;

function _abort() {
    Module["abort"]()
}

function _send(fd, buf, len, flags) {
    var sock = SOCKFS.getSocket(fd);
    if (!sock) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    return _write(fd, buf, len)
}

function _pwrite(fildes, buf, nbyte, offset) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte, offset)
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _write(fildes, buf, nbyte) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    try {
        var slab = HEAP8;
        return FS.write(stream, slab, buf, nbyte)
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _fwrite(ptr, size, nitems, stream) {
    var bytesToWrite = nitems * size;
    if (bytesToWrite == 0) return 0;
    var fd = _fileno(stream);
    var bytesWritten = _write(fd, ptr, bytesToWrite);
    if (bytesWritten == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return 0
    } else {
        return bytesWritten / size | 0
    }
}

function __reallyNegative(x) {
    return x < 0 || x === 0 && 1 / x === -Infinity
}

function __formatString(format, varargs) {
    var textIndex = format;
    var argIndex = 0;

    function getNextArg(type) {
        var ret;
        if (type === "double") {
            ret = (HEAP32[tempDoublePtr >> 2] = HEAP32[varargs + argIndex >> 2], HEAP32[tempDoublePtr + 4 >> 2] = HEAP32[varargs + (argIndex + 4) >> 2], +HEAPF64[tempDoublePtr >> 3])
        } else if (type == "i64") {
            ret = [HEAP32[varargs + argIndex >> 2], HEAP32[varargs + (argIndex + 4) >> 2]]
        } else {
            type = "i32";
            ret = HEAP32[varargs + argIndex >> 2]
        }
        argIndex += Runtime.getNativeFieldSize(type);
        return ret
    }
    var ret = [];
    var curr, next, currArg;
    while (1) {
        var startTextIndex = textIndex;
        curr = HEAP8[textIndex >> 0];
        if (curr === 0) break;
        next = HEAP8[textIndex + 1 >> 0];
        if (curr == 37) {
            var flagAlwaysSigned = false;
            var flagLeftAlign = false;
            var flagAlternative = false;
            var flagZeroPad = false;
            var flagPadSign = false;
            flagsLoop: while (1) {
                switch (next) {
                    case 43:
                        flagAlwaysSigned = true;
                        break;
                    case 45:
                        flagLeftAlign = true;
                        break;
                    case 35:
                        flagAlternative = true;
                        break;
                    case 48:
                        if (flagZeroPad) {
                            break flagsLoop
                        } else {
                            flagZeroPad = true;
                            break
                        };
                    case 32:
                        flagPadSign = true;
                        break;
                    default:
                        break flagsLoop
                }
                textIndex++;
                next = HEAP8[textIndex + 1 >> 0]
            }
            var width = 0;
            if (next == 42) {
                width = getNextArg("i32");
                textIndex++;
                next = HEAP8[textIndex + 1 >> 0]
            } else {
                while (next >= 48 && next <= 57) {
                    width = width * 10 + (next - 48);
                    textIndex++;
                    next = HEAP8[textIndex + 1 >> 0]
                }
            }
            var precisionSet = false,
                precision = -1;
            if (next == 46) {
                precision = 0;
                precisionSet = true;
                textIndex++;
                next = HEAP8[textIndex + 1 >> 0];
                if (next == 42) {
                    precision = getNextArg("i32");
                    textIndex++
                } else {
                    while (1) {
                        var precisionChr = HEAP8[textIndex + 1 >> 0];
                        if (precisionChr < 48 || precisionChr > 57) break;
                        precision = precision * 10 + (precisionChr - 48);
                        textIndex++
                    }
                }
                next = HEAP8[textIndex + 1 >> 0]
            }
            if (precision < 0) {
                precision = 6;
                precisionSet = false
            }
            var argSize;
            switch (String.fromCharCode(next)) {
                case "h":
                    var nextNext = HEAP8[textIndex + 2 >> 0];
                    if (nextNext == 104) {
                        textIndex++;
                        argSize = 1
                    } else {
                        argSize = 2
                    }
                    break;
                case "l":
                    var nextNext = HEAP8[textIndex + 2 >> 0];
                    if (nextNext == 108) {
                        textIndex++;
                        argSize = 8
                    } else {
                        argSize = 4
                    }
                    break;
                case "L":
                case "q":
                case "j":
                    argSize = 8;
                    break;
                case "z":
                case "t":
                case "I":
                    argSize = 4;
                    break;
                default:
                    argSize = null
            }
            if (argSize) textIndex++;
            next = HEAP8[textIndex + 1 >> 0];
            switch (String.fromCharCode(next)) {
                case "d":
                case "i":
                case "u":
                case "o":
                case "x":
                case "X":
                case "p":
                    {
                        var signed = next == 100 || next == 105;argSize = argSize || 4;
                        var currArg = getNextArg("i" + argSize * 8);
                        var origArg = currArg;
                        var argText;
                        if (argSize == 8) {
                            currArg = Runtime.makeBigInt(currArg[0], currArg[1], next == 117)
                        }
                        if (argSize <= 4) {
                            var limit = Math.pow(256, argSize) - 1;
                            currArg = (signed ? reSign : unSign)(currArg & limit, argSize * 8)
                        }
                        var currAbsArg = Math.abs(currArg);
                        var prefix = "";
                        if (next == 100 || next == 105) {
                            if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], null);
                            else argText = reSign(currArg, 8 * argSize, 1).toString(10)
                        } else if (next == 117) {
                            if (argSize == 8 && i64Math) argText = i64Math.stringify(origArg[0], origArg[1], true);
                            else argText = unSign(currArg, 8 * argSize, 1).toString(10);
                            currArg = Math.abs(currArg)
                        } else if (next == 111) {
                            argText = (flagAlternative ? "0" : "") + currAbsArg.toString(8)
                        } else if (next == 120 || next == 88) {
                            prefix = flagAlternative && currArg != 0 ? "0x" : "";
                            if (argSize == 8 && i64Math) {
                                if (origArg[1]) {
                                    argText = (origArg[1] >>> 0).toString(16);
                                    var lower = (origArg[0] >>> 0).toString(16);
                                    while (lower.length < 8) lower = "0" + lower;
                                    argText += lower
                                } else {
                                    argText = (origArg[0] >>> 0).toString(16)
                                }
                            } else if (currArg < 0) {
                                currArg = -currArg;
                                argText = (currAbsArg - 1).toString(16);
                                var buffer = [];
                                for (var i = 0; i < argText.length; i++) {
                                    buffer.push((15 - parseInt(argText[i], 16)).toString(16))
                                }
                                argText = buffer.join("");
                                while (argText.length < argSize * 2) argText = "f" + argText
                            } else {
                                argText = currAbsArg.toString(16)
                            }
                            if (next == 88) {
                                prefix = prefix.toUpperCase();
                                argText = argText.toUpperCase()
                            }
                        } else if (next == 112) {
                            if (currAbsArg === 0) {
                                argText = "(nil)"
                            } else {
                                prefix = "0x";
                                argText = currAbsArg.toString(16)
                            }
                        }
                        if (precisionSet) {
                            while (argText.length < precision) {
                                argText = "0" + argText
                            }
                        }
                        if (currArg >= 0) {
                            if (flagAlwaysSigned) {
                                prefix = "+" + prefix
                            } else if (flagPadSign) {
                                prefix = " " + prefix
                            }
                        }
                        if (argText.charAt(0) == "-") {
                            prefix = "-" + prefix;
                            argText = argText.substr(1)
                        }
                        while (prefix.length + argText.length < width) {
                            if (flagLeftAlign) {
                                argText += " "
                            } else {
                                if (flagZeroPad) {
                                    argText = "0" + argText
                                } else {
                                    prefix = " " + prefix
                                }
                            }
                        }
                        argText = prefix + argText;argText.split("").forEach((function(chr) {
                            ret.push(chr.charCodeAt(0))
                        }));
                        break
                    };
                case "f":
                case "F":
                case "e":
                case "E":
                case "g":
                case "G":
                    {
                        var currArg = getNextArg("double");
                        var argText;
                        if (isNaN(currArg)) {
                            argText = "nan";
                            flagZeroPad = false
                        } else if (!isFinite(currArg)) {
                            argText = (currArg < 0 ? "-" : "") + "inf";
                            flagZeroPad = false
                        } else {
                            var isGeneral = false;
                            var effectivePrecision = Math.min(precision, 20);
                            if (next == 103 || next == 71) {
                                isGeneral = true;
                                precision = precision || 1;
                                var exponent = parseInt(currArg.toExponential(effectivePrecision).split("e")[1], 10);
                                if (precision > exponent && exponent >= -4) {
                                    next = (next == 103 ? "f" : "F").charCodeAt(0);
                                    precision -= exponent + 1
                                } else {
                                    next = (next == 103 ? "e" : "E").charCodeAt(0);
                                    precision--
                                }
                                effectivePrecision = Math.min(precision, 20)
                            }
                            if (next == 101 || next == 69) {
                                argText = currArg.toExponential(effectivePrecision);
                                if (/[eE][-+]\d$/.test(argText)) {
                                    argText = argText.slice(0, -1) + "0" + argText.slice(-1)
                                }
                            } else if (next == 102 || next == 70) {
                                argText = currArg.toFixed(effectivePrecision);
                                if (currArg === 0 && __reallyNegative(currArg)) {
                                    argText = "-" + argText
                                }
                            }
                            var parts = argText.split("e");
                            if (isGeneral && !flagAlternative) {
                                while (parts[0].length > 1 && parts[0].indexOf(".") != -1 && (parts[0].slice(-1) == "0" || parts[0].slice(-1) == ".")) {
                                    parts[0] = parts[0].slice(0, -1)
                                }
                            } else {
                                if (flagAlternative && argText.indexOf(".") == -1) parts[0] += ".";
                                while (precision > effectivePrecision++) parts[0] += "0"
                            }
                            argText = parts[0] + (parts.length > 1 ? "e" + parts[1] : "");
                            if (next == 69) argText = argText.toUpperCase();
                            if (currArg >= 0) {
                                if (flagAlwaysSigned) {
                                    argText = "+" + argText
                                } else if (flagPadSign) {
                                    argText = " " + argText
                                }
                            }
                        }
                        while (argText.length < width) {
                            if (flagLeftAlign) {
                                argText += " "
                            } else {
                                if (flagZeroPad && (argText[0] == "-" || argText[0] == "+")) {
                                    argText = argText[0] + "0" + argText.slice(1)
                                } else {
                                    argText = (flagZeroPad ? "0" : " ") + argText
                                }
                            }
                        }
                        if (next < 97) argText = argText.toUpperCase();argText.split("").forEach((function(chr) {
                            ret.push(chr.charCodeAt(0))
                        }));
                        break
                    };
                case "s":
                    {
                        var arg = getNextArg("i8*");
                        var argLength = arg ? _strlen(arg) : "(null)".length;
                        if (precisionSet) argLength = Math.min(argLength, precision);
                        if (!flagLeftAlign) {
                            while (argLength < width--) {
                                ret.push(32)
                            }
                        }
                        if (arg) {
                            for (var i = 0; i < argLength; i++) {
                                ret.push(HEAPU8[arg++ >> 0])
                            }
                        } else {
                            ret = ret.concat(intArrayFromString("(null)".substr(0, argLength), true))
                        }
                        if (flagLeftAlign) {
                            while (argLength < width--) {
                                ret.push(32)
                            }
                        }
                        break
                    };
                case "c":
                    {
                        if (flagLeftAlign) ret.push(getNextArg("i8"));
                        while (--width > 0) {
                            ret.push(32)
                        }
                        if (!flagLeftAlign) ret.push(getNextArg("i8"));
                        break
                    };
                case "n":
                    {
                        var ptr = getNextArg("i32*");HEAP32[ptr >> 2] = ret.length;
                        break
                    };
                case "%":
                    {
                        ret.push(curr);
                        break
                    };
                default:
                    {
                        for (var i = startTextIndex; i < textIndex + 2; i++) {
                            ret.push(HEAP8[i >> 0])
                        }
                    }
            }
            textIndex += 2
        } else {
            ret.push(curr);
            textIndex += 1
        }
    }
    return ret
}

function _fprintf(stream, format, varargs) {
    var result = __formatString(format, varargs);
    var stack = Runtime.stackSave();
    var ret = _fwrite(allocate(result, "i8", ALLOC_STACK), 1, result.length, stream);
    Runtime.stackRestore(stack);
    return ret
}

function _printf(format, varargs) {
    var stdout = HEAP32[_stdout >> 2];
    return _fprintf(stdout, format, varargs)
}

function _open(path, oflag, varargs) {
    var mode = HEAP32[varargs >> 2];
    path = Pointer_stringify(path);
    try {
        var stream = FS.open(path, oflag, mode);
        return stream.fd
    } catch (e) {
        FS.handleFSError(e);
        return -1
    }
}

function _fopen(filename, mode) {
    var flags;
    mode = Pointer_stringify(mode);
    if (mode[0] == "r") {
        if (mode.indexOf("+") != -1) {
            flags = 2
        } else {
            flags = 0
        }
    } else if (mode[0] == "w") {
        if (mode.indexOf("+") != -1) {
            flags = 2
        } else {
            flags = 1
        }
        flags |= 64;
        flags |= 512
    } else if (mode[0] == "a") {
        if (mode.indexOf("+") != -1) {
            flags = 2
        } else {
            flags = 1
        }
        flags |= 64;
        flags |= 1024
    } else {
        ___setErrNo(ERRNO_CODES.EINVAL);
        return 0
    }
    var fd = _open(filename, flags, allocate([511, 0, 0, 0], "i32", ALLOC_STACK));
    return fd === -1 ? 0 : FS.getPtrForStream(FS.getStream(fd))
}

function _feof(stream) {
    stream = FS.getStreamFromPtr(stream);
    return Number(stream && stream.eof)
}
Module["_strncpy"] = _strncpy;

function _fputc(c, stream) {
    var chr = unSign(c & 255);
    HEAP8[_fputc.ret >> 0] = chr;
    var fd = _fileno(stream);
    var ret = _write(fd, _fputc.ret, 1);
    if (ret == -1) {
        var streamObj = FS.getStreamFromPtr(stream);
        if (streamObj) streamObj.error = true;
        return -1
    } else {
        return chr
    }
}
Module["_i64Add"] = _i64Add;

function _fputs(s, stream) {
    var fd = _fileno(stream);
    return _write(fd, s, _strlen(s))
}

function _puts(s) {
    var stdout = HEAP32[_stdout >> 2];
    var ret = _fputs(s, stdout);
    if (ret < 0) {
        return ret
    } else {
        var newlineRet = _fputc(10, stdout);
        return newlineRet < 0 ? -1 : ret + 1
    }
}

function _copysign(a, b) {
    return __reallyNegative(a) === __reallyNegative(b) ? a : -a
}

function _copysignl() {
    return _copysign.apply(null, arguments)
}

function __exit(status) {
    Module["exit"](status)
}

function _exit(status) {
    __exit(status)
}

function _time(ptr) {
    var ret = Date.now() / 1e3 | 0;
    if (ptr) {
        HEAP32[ptr >> 2] = ret
    }
    return ret
}

function _emscripten_set_main_loop_timing(mode, value) {
    Browser.mainLoop.timingMode = mode;
    Browser.mainLoop.timingValue = value;
    if (!Browser.mainLoop.func) {
        return 1
    }
    if (mode == 0) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
            setTimeout(Browser.mainLoop.runner, value)
        };
        Browser.mainLoop.method = "timeout"
    } else if (mode == 1) {
        Browser.mainLoop.scheduler = function Browser_mainLoop_scheduler() {
            Browser.requestAnimationFrame(Browser.mainLoop.runner)
        };
        Browser.mainLoop.method = "rAF"
    }
    return 0
}

function _emscripten_set_main_loop(func, fps, simulateInfiniteLoop, arg) {
    Module["noExitRuntime"] = true;
    assert(!Browser.mainLoop.func, "emscripten_set_main_loop: there can only be one main loop function at once: call emscripten_cancel_main_loop to cancel the previous one before setting a new one with different parameters.");
    Browser.mainLoop.func = func;
    Browser.mainLoop.arg = arg;
    var thisMainLoopId = Browser.mainLoop.currentlyRunningMainloop;
    Browser.mainLoop.runner = function Browser_mainLoop_runner() {
        if (ABORT) return;
        if (Browser.mainLoop.queue.length > 0) {
            var start = Date.now();
            var blocker = Browser.mainLoop.queue.shift();
            blocker.func(blocker.arg);
            if (Browser.mainLoop.remainingBlockers) {
                var remaining = Browser.mainLoop.remainingBlockers;
                var next = remaining % 1 == 0 ? remaining - 1 : Math.floor(remaining);
                if (blocker.counted) {
                    Browser.mainLoop.remainingBlockers = next
                } else {
                    next = next + .5;
                    Browser.mainLoop.remainingBlockers = (8 * remaining + next) / 9
                }
            }
            console.log('main loop blocker "' + blocker.name + '" took ' + (Date.now() - start) + " ms");
            Browser.mainLoop.updateStatus();
            setTimeout(Browser.mainLoop.runner, 0);
            return
        }
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
        Browser.mainLoop.currentFrameNumber = Browser.mainLoop.currentFrameNumber + 1 | 0;
        if (Browser.mainLoop.timingMode == 1 && Browser.mainLoop.timingValue > 1 && Browser.mainLoop.currentFrameNumber % Browser.mainLoop.timingValue != 0) {
            Browser.mainLoop.scheduler();
            return
        }
        if (Browser.mainLoop.method === "timeout" && Module.ctx) {
            Module.printErr("Looks like you are rendering without using requestAnimationFrame for the main loop. You should use 0 for the frame rate in emscripten_set_main_loop in order to use requestAnimationFrame, as that can greatly improve your frame rates!");
            Browser.mainLoop.method = ""
        }
        Browser.mainLoop.runIter((function() {
            if (typeof arg !== "undefined") {
                Runtime.dynCall("vi", func, [arg])
            } else {
                Runtime.dynCall("v", func)
            }
        }));
        if (thisMainLoopId < Browser.mainLoop.currentlyRunningMainloop) return;
        if (typeof SDL === "object" && SDL.audio && SDL.audio.queueNewAudioData) SDL.audio.queueNewAudioData();
        Browser.mainLoop.scheduler()
    };
    if (fps && fps > 0) _emscripten_set_main_loop_timing(0, 1e3 / fps);
    else _emscripten_set_main_loop_timing(1, 1);
    Browser.mainLoop.scheduler();
    if (simulateInfiniteLoop) {
        throw "SimulateInfiniteLoop"
    }
}
var Browser = {
    mainLoop: {
        scheduler: null,
        method: "",
        currentlyRunningMainloop: 0,
        func: null,
        arg: 0,
        timingMode: 0,
        timingValue: 0,
        currentFrameNumber: 0,
        queue: [],
        pause: (function() {
            Browser.mainLoop.scheduler = null;
            Browser.mainLoop.currentlyRunningMainloop++
        }),
        resume: (function() {
            Browser.mainLoop.currentlyRunningMainloop++;
            var timingMode = Browser.mainLoop.timingMode;
            var timingValue = Browser.mainLoop.timingValue;
            var func = Browser.mainLoop.func;
            Browser.mainLoop.func = null;
            _emscripten_set_main_loop(func, 0, false, Browser.mainLoop.arg);
            _emscripten_set_main_loop_timing(timingMode, timingValue)
        }),
        updateStatus: (function() {
            if (Module["setStatus"]) {
                var message = Module["statusMessage"] || "Please wait...";
                var remaining = Browser.mainLoop.remainingBlockers;
                var expected = Browser.mainLoop.expectedBlockers;
                if (remaining) {
                    if (remaining < expected) {
                        Module["setStatus"](message + " (" + (expected - remaining) + "/" + expected + ")")
                    } else {
                        Module["setStatus"](message)
                    }
                } else {
                    Module["setStatus"]("")
                }
            }
        }),
        runIter: (function(func) {
            if (ABORT) return;
            if (Module["preMainLoop"]) {
                var preRet = Module["preMainLoop"]();
                if (preRet === false) {
                    return
                }
            }
            try {
                func()
            } catch (e) {
                if (e instanceof ExitStatus) {
                    return
                } else {
                    if (e && typeof e === "object" && e.stack) Module.printErr("exception thrown: " + [e, e.stack]);
                    throw e
                }
            }
            if (Module["postMainLoop"]) Module["postMainLoop"]()
        })
    },
    isFullScreen: false,
    pointerLock: false,
    moduleContextCreatedCallbacks: [],
    workers: [],
    init: (function() {
        if (!Module["preloadPlugins"]) Module["preloadPlugins"] = [];
        if (Browser.initted) return;
        Browser.initted = true;
        try {
            new Blob;
            Browser.hasBlobConstructor = true
        } catch (e) {
            Browser.hasBlobConstructor = false;
            console.log("warning: no blob constructor, cannot create blobs with mimetypes")
        }
        Browser.BlobBuilder = typeof MozBlobBuilder != "undefined" ? MozBlobBuilder : typeof WebKitBlobBuilder != "undefined" ? WebKitBlobBuilder : !Browser.hasBlobConstructor ? console.log("warning: no BlobBuilder") : null;
        Browser.URLObject = typeof window != "undefined" ? window.URL ? window.URL : window.webkitURL : undefined;
        if (!Module.noImageDecoding && typeof Browser.URLObject === "undefined") {
            console.log("warning: Browser does not support creating object URLs. Built-in browser image decoding will not be available.");
            Module.noImageDecoding = true
        }
        var imagePlugin = {};
        imagePlugin["canHandle"] = function imagePlugin_canHandle(name) {
            return !Module.noImageDecoding && /\.(jpg|jpeg|png|bmp)$/i.test(name)
        };
        imagePlugin["handle"] = function imagePlugin_handle(byteArray, name, onload, onerror) {
            var b = null;
            if (Browser.hasBlobConstructor) {
                try {
                    b = new Blob([byteArray], {
                        type: Browser.getMimetype(name)
                    });
                    if (b.size !== byteArray.length) {
                        b = new Blob([(new Uint8Array(byteArray)).buffer], {
                            type: Browser.getMimetype(name)
                        })
                    }
                } catch (e) {
                    Runtime.warnOnce("Blob constructor present but fails: " + e + "; falling back to blob builder")
                }
            }
            if (!b) {
                var bb = new Browser.BlobBuilder;
                bb.append((new Uint8Array(byteArray)).buffer);
                b = bb.getBlob()
            }
            var url = Browser.URLObject.createObjectURL(b);
            var img = new Image;
            img.onload = function img_onload() {
                assert(img.complete, "Image " + name + " could not be decoded");
                var canvas = document.createElement("canvas");
                canvas.width = img.width;
                canvas.height = img.height;
                var ctx = canvas.getContext("2d");
                ctx.drawImage(img, 0, 0);
                Module["preloadedImages"][name] = canvas;
                Browser.URLObject.revokeObjectURL(url);
                if (onload) onload(byteArray)
            };
            img.onerror = function img_onerror(event) {
                console.log("Image " + url + " could not be decoded");
                if (onerror) onerror()
            };
            img.src = url
        };
        Module["preloadPlugins"].push(imagePlugin);
        var audioPlugin = {};
        audioPlugin["canHandle"] = function audioPlugin_canHandle(name) {
            return !Module.noAudioDecoding && name.substr(-4) in {
                ".ogg": 1,
                ".wav": 1,
                ".mp3": 1
            }
        };
        audioPlugin["handle"] = function audioPlugin_handle(byteArray, name, onload, onerror) {
            var done = false;

            function finish(audio) {
                if (done) return;
                done = true;
                Module["preloadedAudios"][name] = audio;
                if (onload) onload(byteArray)
            }

            function fail() {
                if (done) return;
                done = true;
                Module["preloadedAudios"][name] = new Audio;
                if (onerror) onerror()
            }
            if (Browser.hasBlobConstructor) {
                try {
                    var b = new Blob([byteArray], {
                        type: Browser.getMimetype(name)
                    })
                } catch (e) {
                    return fail()
                }
                var url = Browser.URLObject.createObjectURL(b);
                var audio = new Audio;
                audio.addEventListener("canplaythrough", (function() {
                    finish(audio)
                }), false);
                audio.onerror = function audio_onerror(event) {
                    if (done) return;
                    console.log("warning: browser could not fully decode audio " + name + ", trying slower base64 approach");

                    function encode64(data) {
                        var BASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
                        var PAD = "=";
                        var ret = "";
                        var leftchar = 0;
                        var leftbits = 0;
                        for (var i = 0; i < data.length; i++) {
                            leftchar = leftchar << 8 | data[i];
                            leftbits += 8;
                            while (leftbits >= 6) {
                                var curr = leftchar >> leftbits - 6 & 63;
                                leftbits -= 6;
                                ret += BASE[curr]
                            }
                        }
                        if (leftbits == 2) {
                            ret += BASE[(leftchar & 3) << 4];
                            ret += PAD + PAD
                        } else if (leftbits == 4) {
                            ret += BASE[(leftchar & 15) << 2];
                            ret += PAD
                        }
                        return ret
                    }
                    audio.src = "data:audio/x-" + name.substr(-3) + ";base64," + encode64(byteArray);
                    finish(audio)
                };
                audio.src = url;
                Browser.safeSetTimeout((function() {
                    finish(audio)
                }), 1e4)
            } else {
                return fail()
            }
        };
        Module["preloadPlugins"].push(audioPlugin);
        var canvas = Module["canvas"];

        function pointerLockChange() {
            Browser.pointerLock = document["pointerLockElement"] === canvas || document["mozPointerLockElement"] === canvas || document["webkitPointerLockElement"] === canvas || document["msPointerLockElement"] === canvas
        }
        if (canvas) {
            canvas.requestPointerLock = canvas["requestPointerLock"] || canvas["mozRequestPointerLock"] || canvas["webkitRequestPointerLock"] || canvas["msRequestPointerLock"] || (function() {});
            canvas.exitPointerLock = document["exitPointerLock"] || document["mozExitPointerLock"] || document["webkitExitPointerLock"] || document["msExitPointerLock"] || (function() {});
            canvas.exitPointerLock = canvas.exitPointerLock.bind(document);
            document.addEventListener("pointerlockchange", pointerLockChange, false);
            document.addEventListener("mozpointerlockchange", pointerLockChange, false);
            document.addEventListener("webkitpointerlockchange", pointerLockChange, false);
            document.addEventListener("mspointerlockchange", pointerLockChange, false);
            if (Module["elementPointerLock"]) {
                canvas.addEventListener("click", (function(ev) {
                    if (!Browser.pointerLock && canvas.requestPointerLock) {
                        canvas.requestPointerLock();
                        ev.preventDefault()
                    }
                }), false)
            }
        }
    }),
    createContext: (function(canvas, useWebGL, setInModule, webGLContextAttributes) {
        if (useWebGL && Module.ctx && canvas == Module.canvas) return Module.ctx;
        var ctx;
        var contextHandle;
        if (useWebGL) {
            var contextAttributes = {
                antialias: false,
                alpha: false
            };
            if (webGLContextAttributes) {
                for (var attribute in webGLContextAttributes) {
                    contextAttributes[attribute] = webGLContextAttributes[attribute]
                }
            }
            contextHandle = GL.createContext(canvas, contextAttributes);
            if (contextHandle) {
                ctx = GL.getContext(contextHandle).GLctx
            }
            canvas.style.backgroundColor = "black"
        } else {
            ctx = canvas.getContext("2d")
        }
        if (!ctx) return null;
        if (setInModule) {
            if (!useWebGL) assert(typeof GLctx === "undefined", "cannot set in module if GLctx is used, but we are a non-GL context that would replace it");
            Module.ctx = ctx;
            if (useWebGL) GL.makeContextCurrent(contextHandle);
            Module.useWebGL = useWebGL;
            Browser.moduleContextCreatedCallbacks.forEach((function(callback) {
                callback()
            }));
            Browser.init()
        }
        return ctx
    }),
    destroyContext: (function(canvas, useWebGL, setInModule) {}),
    fullScreenHandlersInstalled: false,
    lockPointer: undefined,
    resizeCanvas: undefined,
    requestFullScreen: (function(lockPointer, resizeCanvas) {
        Browser.lockPointer = lockPointer;
        Browser.resizeCanvas = resizeCanvas;
        if (typeof Browser.lockPointer === "undefined") Browser.lockPointer = true;
        if (typeof Browser.resizeCanvas === "undefined") Browser.resizeCanvas = false;
        var canvas = Module["canvas"];

        function fullScreenChange() {
            Browser.isFullScreen = false;
            var canvasContainer = canvas.parentNode;
            if ((document["webkitFullScreenElement"] || document["webkitFullscreenElement"] || document["mozFullScreenElement"] || document["mozFullscreenElement"] || document["fullScreenElement"] || document["fullscreenElement"] || document["msFullScreenElement"] || document["msFullscreenElement"] || document["webkitCurrentFullScreenElement"]) === canvasContainer) {
                canvas.cancelFullScreen = document["cancelFullScreen"] || document["mozCancelFullScreen"] || document["webkitCancelFullScreen"] || document["msExitFullscreen"] || document["exitFullscreen"] || (function() {});
                canvas.cancelFullScreen = canvas.cancelFullScreen.bind(document);
                if (Browser.lockPointer) canvas.requestPointerLock();
                Browser.isFullScreen = true;
                if (Browser.resizeCanvas) Browser.setFullScreenCanvasSize()
            } else {
                canvasContainer.parentNode.insertBefore(canvas, canvasContainer);
                canvasContainer.parentNode.removeChild(canvasContainer);
                if (Browser.resizeCanvas) Browser.setWindowedCanvasSize()
            }
            if (Module["onFullScreen"]) Module["onFullScreen"](Browser.isFullScreen);
            Browser.updateCanvasDimensions(canvas)
        }
        if (!Browser.fullScreenHandlersInstalled) {
            Browser.fullScreenHandlersInstalled = true;
            document.addEventListener("fullscreenchange", fullScreenChange, false);
            document.addEventListener("mozfullscreenchange", fullScreenChange, false);
            document.addEventListener("webkitfullscreenchange", fullScreenChange, false);
            document.addEventListener("MSFullscreenChange", fullScreenChange, false)
        }
        var canvasContainer = document.createElement("div");
        canvas.parentNode.insertBefore(canvasContainer, canvas);
        canvasContainer.appendChild(canvas);
        canvasContainer.requestFullScreen = canvasContainer["requestFullScreen"] || canvasContainer["mozRequestFullScreen"] || canvasContainer["msRequestFullscreen"] || (canvasContainer["webkitRequestFullScreen"] ? (function() {
            canvasContainer["webkitRequestFullScreen"](Element["ALLOW_KEYBOARD_INPUT"])
        }) : null);
        canvasContainer.requestFullScreen()
    }),
    nextRAF: 0,
    fakeRequestAnimationFrame: (function(func) {
        var now = Date.now();
        if (Browser.nextRAF === 0) {
            Browser.nextRAF = now + 1e3 / 60
        } else {
            while (now + 2 >= Browser.nextRAF) {
                Browser.nextRAF += 1e3 / 60
            }
        }
        var delay = Math.max(Browser.nextRAF - now, 0);
        setTimeout(func, delay)
    }),
    requestAnimationFrame: function requestAnimationFrame(func) {
        if (typeof window === "undefined") {
            Browser.fakeRequestAnimationFrame(func)
        } else {
            if (!window.requestAnimationFrame) {
                window.requestAnimationFrame = window["requestAnimationFrame"] || window["mozRequestAnimationFrame"] || window["webkitRequestAnimationFrame"] || window["msRequestAnimationFrame"] || window["oRequestAnimationFrame"] || Browser.fakeRequestAnimationFrame
            }
            window.requestAnimationFrame(func)
        }
    },
    safeCallback: (function(func) {
        return (function() {
            if (!ABORT) return func.apply(null, arguments)
        })
    }),
    safeRequestAnimationFrame: (function(func) {
        return Browser.requestAnimationFrame((function() {
            if (!ABORT) func()
        }))
    }),
    safeSetTimeout: (function(func, timeout) {
        Module["noExitRuntime"] = true;
        return setTimeout((function() {
            if (!ABORT) func()
        }), timeout)
    }),
    safeSetInterval: (function(func, timeout) {
        Module["noExitRuntime"] = true;
        return setInterval((function() {
            if (!ABORT) func()
        }), timeout)
    }),
    getMimetype: (function(name) {
        return {
            "jpg": "image/jpeg",
            "jpeg": "image/jpeg",
            "png": "image/png",
            "bmp": "image/bmp",
            "ogg": "audio/ogg",
            "wav": "audio/wav",
            "mp3": "audio/mpeg"
        }[name.substr(name.lastIndexOf(".") + 1)]
    }),
    getUserMedia: (function(func) {
        if (!window.getUserMedia) {
            window.getUserMedia = navigator["getUserMedia"] || navigator["mozGetUserMedia"]
        }
        window.getUserMedia(func)
    }),
    getMovementX: (function(event) {
        return event["movementX"] || event["mozMovementX"] || event["webkitMovementX"] || 0
    }),
    getMovementY: (function(event) {
        return event["movementY"] || event["mozMovementY"] || event["webkitMovementY"] || 0
    }),
    getMouseWheelDelta: (function(event) {
        var delta = 0;
        switch (event.type) {
            case "DOMMouseScroll":
                delta = event.detail;
                break;
            case "mousewheel":
                delta = event.wheelDelta;
                break;
            case "wheel":
                delta = event["deltaY"];
                break;
            default:
                throw "unrecognized mouse wheel event: " + event.type
        }
        return delta
    }),
    mouseX: 0,
    mouseY: 0,
    mouseMovementX: 0,
    mouseMovementY: 0,
    touches: {},
    lastTouches: {},
    calculateMouseEvent: (function(event) {
        if (Browser.pointerLock) {
            if (event.type != "mousemove" && "mozMovementX" in event) {
                Browser.mouseMovementX = Browser.mouseMovementY = 0
            } else {
                Browser.mouseMovementX = Browser.getMovementX(event);
                Browser.mouseMovementY = Browser.getMovementY(event)
            }
            if (typeof SDL != "undefined") {
                Browser.mouseX = SDL.mouseX + Browser.mouseMovementX;
                Browser.mouseY = SDL.mouseY + Browser.mouseMovementY
            } else {
                Browser.mouseX += Browser.mouseMovementX;
                Browser.mouseY += Browser.mouseMovementY
            }
        } else {
            var rect = Module["canvas"].getBoundingClientRect();
            var cw = Module["canvas"].width;
            var ch = Module["canvas"].height;
            var scrollX = typeof window.scrollX !== "undefined" ? window.scrollX : window.pageXOffset;
            var scrollY = typeof window.scrollY !== "undefined" ? window.scrollY : window.pageYOffset;
            if (event.type === "touchstart" || event.type === "touchend" || event.type === "touchmove") {
                var touch = event.touch;
                if (touch === undefined) {
                    return
                }
                var adjustedX = touch.pageX - (scrollX + rect.left);
                var adjustedY = touch.pageY - (scrollY + rect.top);
                adjustedX = adjustedX * (cw / rect.width);
                adjustedY = adjustedY * (ch / rect.height);
                var coords = {
                    x: adjustedX,
                    y: adjustedY
                };
                if (event.type === "touchstart") {
                    Browser.lastTouches[touch.identifier] = coords;
                    Browser.touches[touch.identifier] = coords
                } else if (event.type === "touchend" || event.type === "touchmove") {
                    Browser.lastTouches[touch.identifier] = Browser.touches[touch.identifier];
                    Browser.touches[touch.identifier] = {
                        x: adjustedX,
                        y: adjustedY
                    }
                }
                return
            }
            var x = event.pageX - (scrollX + rect.left);
            var y = event.pageY - (scrollY + rect.top);
            x = x * (cw / rect.width);
            y = y * (ch / rect.height);
            Browser.mouseMovementX = x - Browser.mouseX;
            Browser.mouseMovementY = y - Browser.mouseY;
            Browser.mouseX = x;
            Browser.mouseY = y
        }
    }),
    xhrLoad: (function(url, onload, onerror) {
        var xhr = new XMLHttpRequest;
        xhr.open("GET", url, true);
        xhr.responseType = "arraybuffer";
        xhr.onload = function xhr_onload() {
            if (xhr.status == 200 || xhr.status == 0 && xhr.response) {
                onload(xhr.response)
            } else {
                onerror()
            }
        };
        xhr.onerror = onerror;
        xhr.send(null)
    }),
    asyncLoad: (function(url, onload, onerror, noRunDep) {
        Browser.xhrLoad(url, (function(arrayBuffer) {
            assert(arrayBuffer, 'Loading data file "' + url + '" failed (no arrayBuffer).');
            onload(new Uint8Array(arrayBuffer));
            if (!noRunDep) removeRunDependency("al " + url)
        }), (function(event) {
            if (onerror) {
                onerror()
            } else {
                throw 'Loading data file "' + url + '" failed.'
            }
        }));
        if (!noRunDep) addRunDependency("al " + url)
    }),
    resizeListeners: [],
    updateResizeListeners: (function() {
        var canvas = Module["canvas"];
        Browser.resizeListeners.forEach((function(listener) {
            listener(canvas.width, canvas.height)
        }))
    }),
    setCanvasSize: (function(width, height, noUpdates) {
        var canvas = Module["canvas"];
        Browser.updateCanvasDimensions(canvas, width, height);
        if (!noUpdates) Browser.updateResizeListeners()
    }),
    windowedWidth: 0,
    windowedHeight: 0,
    setFullScreenCanvasSize: (function() {
        if (typeof SDL != "undefined") {
            var flags = HEAPU32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2];
            flags = flags | 8388608;
            HEAP32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2] = flags
        }
        Browser.updateResizeListeners()
    }),
    setWindowedCanvasSize: (function() {
        if (typeof SDL != "undefined") {
            var flags = HEAPU32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2];
            flags = flags & ~8388608;
            HEAP32[SDL.screen + Runtime.QUANTUM_SIZE * 0 >> 2] = flags
        }
        Browser.updateResizeListeners()
    }),
    updateCanvasDimensions: (function(canvas, wNative, hNative) {
        if (wNative && hNative) {
            canvas.widthNative = wNative;
            canvas.heightNative = hNative
        } else {
            wNative = canvas.widthNative;
            hNative = canvas.heightNative
        }
        var w = wNative;
        var h = hNative;
        if (Module["forcedAspectRatio"] && Module["forcedAspectRatio"] > 0) {
            if (w / h < Module["forcedAspectRatio"]) {
                w = Math.round(h * Module["forcedAspectRatio"])
            } else {
                h = Math.round(w / Module["forcedAspectRatio"])
            }
        }
        if ((document["webkitFullScreenElement"] || document["webkitFullscreenElement"] || document["mozFullScreenElement"] || document["mozFullscreenElement"] || document["fullScreenElement"] || document["fullscreenElement"] || document["msFullScreenElement"] || document["msFullscreenElement"] || document["webkitCurrentFullScreenElement"]) === canvas.parentNode && typeof screen != "undefined") {
            var factor = Math.min(screen.width / w, screen.height / h);
            w = Math.round(w * factor);
            h = Math.round(h * factor)
        }
        if (Browser.resizeCanvas) {
            if (canvas.width != w) canvas.width = w;
            if (canvas.height != h) canvas.height = h;
            if (typeof canvas.style != "undefined") {
                canvas.style.removeProperty("width");
                canvas.style.removeProperty("height")
            }
        } else {
            if (canvas.width != wNative) canvas.width = wNative;
            if (canvas.height != hNative) canvas.height = hNative;
            if (typeof canvas.style != "undefined") {
                if (w != wNative || h != hNative) {
                    canvas.style.setProperty("width", w + "px", "important");
                    canvas.style.setProperty("height", h + "px", "important")
                } else {
                    canvas.style.removeProperty("width");
                    canvas.style.removeProperty("height")
                }
            }
        }
    }),
    wgetRequests: {},
    nextWgetRequestHandle: 0,
    getNextWgetRequestHandle: (function() {
        var handle = Browser.nextWgetRequestHandle;
        Browser.nextWgetRequestHandle++;
        return handle
    })
};

function _munmap(start, num) {
    if (!_mmap.mappings) _mmap.mappings = {};
    var info = _mmap.mappings[start];
    if (!info) return 0;
    if (num == info.num) {
        _mmap.mappings[start] = null;
        if (info.allocated) {
            _free(info.malloc)
        }
    }
    return 0
}

function _stat(path, buf, dontResolveLastLink) {
    path = typeof path !== "string" ? Pointer_stringify(path) : path;
    try {
        var stat = dontResolveLastLink ? FS.lstat(path) : FS.stat(path);
        HEAP32[buf >> 2] = stat.dev;
        HEAP32[buf + 4 >> 2] = 0;
        HEAP32[buf + 8 >> 2] = stat.ino;
        HEAP32[buf + 12 >> 2] = stat.mode;
        HEAP32[buf + 16 >> 2] = stat.nlink;
        HEAP32[buf + 20 >> 2] = stat.uid;
        HEAP32[buf + 24 >> 2] = stat.gid;
        HEAP32[buf + 28 >> 2] = stat.rdev;
        HEAP32[buf + 32 >> 2] = 0;
        HEAP32[buf + 36 >> 2] = stat.size;
        HEAP32[buf + 40 >> 2] = 4096;
        HEAP32[buf + 44 >> 2] = stat.blocks;
        HEAP32[buf + 48 >> 2] = stat.atime.getTime() / 1e3 | 0;
        HEAP32[buf + 52 >> 2] = 0;
        HEAP32[buf + 56 >> 2] = stat.mtime.getTime() / 1e3 | 0;
        HEAP32[buf + 60 >> 2] = 0;
        HEAP32[buf + 64 >> 2] = stat.ctime.getTime() / 1e3 | 0;
        HEAP32[buf + 68 >> 2] = 0;
        HEAP32[buf + 72 >> 2] = stat.ino;
        return 0
    } catch (e) {
        if (e.node && PATH.normalize(path) !== PATH.normalize(FS.getPath(e.node))) {
            e.setErrno(ERRNO_CODES.ENOTDIR)
        }
        FS.handleFSError(e);
        return -1
    }
}

function _fstat(fildes, buf) {
    var stream = FS.getStream(fildes);
    if (!stream) {
        ___setErrNo(ERRNO_CODES.EBADF);
        return -1
    }
    return _stat(stream.path, buf)
}

function _fmod(x, y) {
    return x % y
}

function _fmodl() {
    return _fmod.apply(null, arguments)
}

function _sysconf(name) {
    switch (name) {
        case 30:
            return PAGE_SIZE;
        case 132:
        case 133:
        case 12:
        case 137:
        case 138:
        case 15:
        case 235:
        case 16:
        case 17:
        case 18:
        case 19:
        case 20:
        case 149:
        case 13:
        case 10:
        case 236:
        case 153:
        case 9:
        case 21:
        case 22:
        case 159:
        case 154:
        case 14:
        case 77:
        case 78:
        case 139:
        case 80:
        case 81:
        case 79:
        case 82:
        case 68:
        case 67:
        case 164:
        case 11:
        case 29:
        case 47:
        case 48:
        case 95:
        case 52:
        case 51:
        case 46:
            return 200809;
        case 27:
        case 246:
        case 127:
        case 128:
        case 23:
        case 24:
        case 160:
        case 161:
        case 181:
        case 182:
        case 242:
        case 183:
        case 184:
        case 243:
        case 244:
        case 245:
        case 165:
        case 178:
        case 179:
        case 49:
        case 50:
        case 168:
        case 169:
        case 175:
        case 170:
        case 171:
        case 172:
        case 97:
        case 76:
        case 32:
        case 173:
        case 35:
            return -1;
        case 176:
        case 177:
        case 7:
        case 155:
        case 8:
        case 157:
        case 125:
        case 126:
        case 92:
        case 93:
        case 129:
        case 130:
        case 131:
        case 94:
        case 91:
            return 1;
        case 74:
        case 60:
        case 69:
        case 70:
        case 4:
            return 1024;
        case 31:
        case 42:
        case 72:
            return 32;
        case 87:
        case 26:
        case 33:
            return 2147483647;
        case 34:
        case 1:
            return 47839;
        case 38:
        case 36:
            return 99;
        case 43:
        case 37:
            return 2048;
        case 0:
            return 2097152;
        case 3:
            return 65536;
        case 28:
            return 32768;
        case 44:
            return 32767;
        case 75:
            return 16384;
        case 39:
            return 1e3;
        case 89:
            return 700;
        case 71:
            return 256;
        case 40:
            return 255;
        case 2:
            return 100;
        case 180:
            return 64;
        case 25:
            return 20;
        case 5:
            return 16;
        case 6:
            return 6;
        case 73:
            return 4;
        case 84:
            {
                if (typeof navigator === "object") return navigator["hardwareConcurrency"] || 1;
                return 1
            }
    }
    ___setErrNo(ERRNO_CODES.EINVAL);
    return -1
}
Module["_bitshift64Lshr"] = _bitshift64Lshr;

function _mmap(start, num, prot, flags, fd, offset) {
    var MAP_PRIVATE = 2;
    var ptr;
    var allocated = false;
    if (!_mmap.mappings) _mmap.mappings = {};
    if (fd == -1) {
        ptr = _malloc(num);
        if (!ptr) return -1;
        _memset(ptr, 0, num);
        allocated = true
    } else {
        var info = FS.getStream(fd);
        if (!info) return -1;
        try {
            var res = FS.mmap(info, HEAPU8, start, num, offset, prot, flags);
            ptr = res.ptr;
            allocated = res.allocated
        } catch (e) {
            FS.handleFSError(e);
            return -1
        }
    }
    _mmap.mappings[ptr] = {
        malloc: ptr,
        num: num,
        allocated: allocated
    };
    return ptr
}
var _BDtoILow = true;
var _BDtoIHigh = true;
var _environ = allocate(1, "i32*", ALLOC_STATIC);
var ___environ = _environ;

function ___buildEnvironment(env) {
    var MAX_ENV_VALUES = 64;
    var TOTAL_ENV_SIZE = 1024;
    var poolPtr;
    var envPtr;
    if (!___buildEnvironment.called) {
        ___buildEnvironment.called = true;
        ENV["USER"] = "web_user";
        ENV["PATH"] = "/";
        ENV["PWD"] = "/";
        ENV["HOME"] = "/home/web_user";
        ENV["LANG"] = "C";
        ENV["_"] = Module["thisProgram"];
        poolPtr = allocate(TOTAL_ENV_SIZE, "i8", ALLOC_STATIC);
        envPtr = allocate(MAX_ENV_VALUES * 4, "i8*", ALLOC_STATIC);
        HEAP32[envPtr >> 2] = poolPtr;
        HEAP32[_environ >> 2] = envPtr
    } else {
        envPtr = HEAP32[_environ >> 2];
        poolPtr = HEAP32[envPtr >> 2]
    }
    var strings = [];
    var totalSize = 0;
    for (var key in env) {
        if (typeof env[key] === "string") {
            var line = key + "=" + env[key];
            strings.push(line);
            totalSize += line.length
        }
    }
    if (totalSize > TOTAL_ENV_SIZE) {
        throw new Error("Environment size exceeded TOTAL_ENV_SIZE!")
    }
    var ptrSize = 4;
    for (var i = 0; i < strings.length; i++) {
        var line = strings[i];
        writeAsciiToMemory(line, poolPtr);
        HEAP32[envPtr + i * ptrSize >> 2] = poolPtr;
        poolPtr += line.length + 1
    }
    HEAP32[envPtr + strings.length * ptrSize >> 2] = 0
}
var ENV = {};

function _getenv(name) {
    if (name === 0) return 0;
    name = Pointer_stringify(name);
    if (!ENV.hasOwnProperty(name)) return 0;
    if (_getenv.ret) _free(_getenv.ret);
    _getenv.ret = allocate(intArrayFromString(ENV[name]), "i8", ALLOC_NORMAL);
    return _getenv.ret
}

function _emscripten_memcpy_big(dest, src, num) {
    HEAPU8.set(HEAPU8.subarray(src, src + num), dest);
    return dest
}
Module["_memcpy"] = _memcpy;

function _putchar(c) {
    return _fputc(c, HEAP32[_stdout >> 2])
}
var _fabs = Math_abs;

function _sbrk(bytes) {
    var self = _sbrk;
    if (!self.called) {
        DYNAMICTOP = alignMemoryPage(DYNAMICTOP);
        self.called = true;
        assert(Runtime.dynamicAlloc);
        self.alloc = Runtime.dynamicAlloc;
        Runtime.dynamicAlloc = (function() {
            abort("cannot dynamically allocate, sbrk now has control")
        })
    }
    var ret = DYNAMICTOP;
    if (bytes != 0) self.alloc(bytes);
    return ret
}

function ___errno_location() {
    return ___errno_state
}
var _BItoD = true;
Module["_strcpy"] = _strcpy;

function _llvm_trap() {
    abort("trap!")
}
_fgetc.ret = allocate([0], "i8", ALLOC_STATIC);
FS.staticInit();
__ATINIT__.unshift({
    func: (function() {
        if (!Module["noFSInit"] && !FS.init.initialized) FS.init()
    })
});
__ATMAIN__.push({
    func: (function() {
        FS.ignorePermissions = false
    })
});
__ATEXIT__.push({
    func: (function() {
        FS.quit()
    })
});
Module["FS_createFolder"] = FS.createFolder;
Module["FS_createPath"] = FS.createPath;
Module["FS_createDataFile"] = FS.createDataFile;
Module["FS_createPreloadedFile"] = FS.createPreloadedFile;
Module["FS_createLazyFile"] = FS.createLazyFile;
Module["FS_createLink"] = FS.createLink;
Module["FS_createDevice"] = FS.createDevice;
___errno_state = Runtime.staticAlloc(4);
HEAP32[___errno_state >> 2] = 0;
__ATINIT__.unshift({
    func: (function() {
        TTY.init()
    })
});
__ATEXIT__.push({
    func: (function() {
        TTY.shutdown()
    })
});
TTY.utf8 = new Runtime.UTF8Processor;

__ATINIT__.push({
    func: (function() {
        SOCKFS.root = FS.mount(SOCKFS, {}, null)
    })
});
_fputc.ret = allocate([0], "i8", ALLOC_STATIC);
Module["requestFullScreen"] = function Module_requestFullScreen(lockPointer, resizeCanvas) {
    Browser.requestFullScreen(lockPointer, resizeCanvas)
};
Module["requestAnimationFrame"] = function Module_requestAnimationFrame(func) {
    Browser.requestAnimationFrame(func)
};
Module["setCanvasSize"] = function Module_setCanvasSize(width, height, noUpdates) {
    Browser.setCanvasSize(width, height, noUpdates)
};
Module["pauseMainLoop"] = function Module_pauseMainLoop() {
    Browser.mainLoop.pause()
};
Module["resumeMainLoop"] = function Module_resumeMainLoop() {
    Browser.mainLoop.resume()
};
Module["getUserMedia"] = function Module_getUserMedia() {
    Browser.getUserMedia()
};
___buildEnvironment(ENV);
STACK_BASE = STACKTOP = Runtime.alignMemory(STATICTOP);
staticSealed = true;
STACK_MAX = STACK_BASE + TOTAL_STACK;
DYNAMIC_BASE = DYNAMICTOP = Runtime.alignMemory(STACK_MAX);
assert(DYNAMIC_BASE < TOTAL_MEMORY, "TOTAL_MEMORY not big enough for stack");
var ctlz_i8 = allocate([8, 7, 6, 6, 5, 5, 5, 5, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], "i8", ALLOC_DYNAMIC);
var cttz_i8 = allocate([8, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 7, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 6, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 5, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0, 4, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0], "i8", ALLOC_DYNAMIC);

function invoke_iiii(index, a1, a2, a3) {
    try {
        return Module["dynCall_iiii"](index, a1, a2, a3)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_vi(index, a1) {
    try {
        Module["dynCall_vi"](index, a1)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_vii(index, a1, a2) {
    try {
        Module["dynCall_vii"](index, a1, a2)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_ii(index, a1) {
    try {
        return Module["dynCall_ii"](index, a1)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_viii(index, a1, a2, a3) {
    try {
        Module["dynCall_viii"](index, a1, a2, a3)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_iii(index, a1, a2) {
    try {
        return Module["dynCall_iii"](index, a1, a2)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}

function invoke_iiiiii(index, a1, a2, a3, a4, a5) {
    try {
        return Module["dynCall_iiiiii"](index, a1, a2, a3, a4, a5)
    } catch (e) {
        if (typeof e !== "number" && e !== "longjmp") throw e;
        asm["setThrew"](1, 0)
    }
}
Module.asmGlobalArg = {
    "Math": Math,
    "Int8Array": Int8Array,
    "Int16Array": Int16Array,
    "Int32Array": Int32Array,
    "Uint8Array": Uint8Array,
    "Uint16Array": Uint16Array,
    "Uint32Array": Uint32Array,
    "Float32Array": Float32Array,
    "Float64Array": Float64Array
};
Module.asmLibraryArg = {
    "abort": abort,
    "assert": assert,
    "min": Math_min,
    "invoke_iiii": invoke_iiii,
    "invoke_vi": invoke_vi,
    "invoke_vii": invoke_vii,
    "invoke_ii": invoke_ii,
    "invoke_viii": invoke_viii,
    "invoke_iii": invoke_iii,
    "invoke_iiiiii": invoke_iiiiii,
    "_fabs": _fabs,
    "_copysignl": _copysignl,
    "_send": _send,
    "_fread": _fread,
    "_fmod": _fmod,
    "__reallyNegative": __reallyNegative,
    "_fstat": _fstat,
    "_emscripten_set_main_loop_timing": _emscripten_set_main_loop_timing,
    "___assert_fail": ___assert_fail,
    "_write": _write,
    "___buildEnvironment": ___buildEnvironment,
    "_fflush": _fflush,
    "_pwrite": _pwrite,
    "_strerror_r": _strerror_r,
    "_open": _open,
    "_sbrk": _sbrk,
    "_emscripten_memcpy_big": _emscripten_memcpy_big,
    "_fileno": _fileno,
    "__exit": __exit,
    "_close": _close,
    "__formatString": __formatString,
    "_putchar": _putchar,
    "_fputs": _fputs,
    "_pread": _pread,
    "_puts": _puts,
    "_printf": _printf,
    "_fclose": _fclose,
    "_feof": _feof,
    "_fsync": _fsync,
    "___errno_location": ___errno_location,
    "_stat": _stat,
    "_recv": _recv,
    "_fgetc": _fgetc,
    "_copysign": _copysign,
    "_getenv": _getenv,
    "_mkport": _mkport,
    "_sysconf": _sysconf,
    "_read": _read,
    "_fputc": _fputc,
    "_emscripten_set_main_loop": _emscripten_set_main_loop,
    "_abort": _abort,
    "_fwrite": _fwrite,
    "_time": _time,
    "_fprintf": _fprintf,
    "_strerror": _strerror,
    "_munmap": _munmap,
    "_mmap": _mmap,
    "_llvm_trap": _llvm_trap,
    "_fopen": _fopen,
    "_exit": _exit,
    "___setErrNo": ___setErrNo,
    "_fmodl": _fmodl,
    "STACKTOP": STACKTOP,
    "STACK_MAX": STACK_MAX,
    "tempDoublePtr": tempDoublePtr,
    "ABORT": ABORT,
    "cttz_i8": cttz_i8,
    "ctlz_i8": ctlz_i8,
    "NaN": NaN,
    "Infinity": Infinity,
    "_stderr": _stderr,
    "_stdin": _stdin,
    "_stdout": _stdout
}; // EMSCRIPTEN_START_ASM

var asm=(function(global,env,buffer) {
"use asm";var a=new global.Int8Array(buffer);var b=new global.Int16Array(buffer);var c=new global.Int32Array(buffer);var d=new global.Uint8Array(buffer);var e=new global.Uint16Array(buffer);var f=new global.Uint32Array(buffer);var g=new global.Float32Array(buffer);var h=new global.Float64Array(buffer);var i=env.STACKTOP|0;var j=env.STACK_MAX|0;var k=env.tempDoublePtr|0;var l=env.ABORT|0;var m=env.cttz_i8|0;var n=env.ctlz_i8|0;var o=env._stderr|0;var p=env._stdin|0;var q=env._stdout|0;var r=0;var s=0;var t=0;var u=0;var v=+env.NaN,w=+env.Infinity;var x=0,y=0,z=0,A=0,B=0.0,C=0,D=0,E=0,F=0.0;var G=0;var H=0;var I=0;var J=0;var K=0;var L=0;var M=0;var N=0;var O=0;var P=0;var Q=global.Math.floor;var R=global.Math.abs;var S=global.Math.sqrt;var T=global.Math.pow;var U=global.Math.cos;var V=global.Math.sin;var W=global.Math.tan;var X=global.Math.acos;var Y=global.Math.asin;var Z=global.Math.atan;var _=global.Math.atan2;var $=global.Math.exp;var aa=global.Math.log;var ba=global.Math.ceil;var ca=global.Math.imul;var da=env.abort;var ea=env.assert;var fa=env.min;var ga=env.invoke_iiii;var ha=env.invoke_vi;var ia=env.invoke_vii;var ja=env.invoke_ii;var ka=env.invoke_viii;var la=env.invoke_iii;var ma=env.invoke_iiiiii;var na=env._fabs;var oa=env._copysignl;var pa=env._send;var qa=env._fread;var ra=env._fmod;var sa=env.__reallyNegative;var ta=env._fstat;var ua=env._emscripten_set_main_loop_timing;var va=env.___assert_fail;var wa=env._write;var xa=env.___buildEnvironment;var ya=env._fflush;var za=env._pwrite;var Aa=env._strerror_r;var Ba=env._open;var Ca=env._sbrk;var Da=env._emscripten_memcpy_big;var Ea=env._fileno;var Fa=env.__exit;var Ga=env._close;var Ha=env.__formatString;var Ia=env._putchar;var Ja=env._fputs;var Ka=env._pread;var La=env._puts;var Ma=env._printf;var Na=env._fclose;var Oa=env._feof;var Pa=env._fsync;var Qa=env.___errno_location;var Ra=env._stat;var Sa=env._recv;var Ta=env._fgetc;var Ua=env._copysign;var Va=env._getenv;var Wa=env._mkport;var Xa=env._sysconf;var Ya=env._read;var Za=env._fputc;var _a=env._emscripten_set_main_loop;var $a=env._abort;var ab=env._fwrite;var bb=env._time;var cb=env._fprintf;var db=env._strerror;var eb=env._munmap;var fb=env._mmap;var gb=env._llvm_trap;var hb=env._fopen;var ib=env._exit;var jb=env.___setErrNo;var kb=env._fmodl;var lb=0.0;
// EMSCRIPTEN_START_FUNCS
function $f(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0;e=i;i=i+48|0;A=e+32|0;x=e+28|0;z=e+24|0;y=e+20|0;v=e+16|0;w=e+12|0;D=e+8|0;C=e+4|0;E=e;o=b+68|0;h=c[o>>2]|0;j=h+12|0;k=c[h+64>>2]|0;do if(c[j>>2]|0)if(!k)f=h+64|0;else{c[j>>2]=0;O=k;i=e;return O|0}else{if(k){f=h+64|0;c[f>>2]=0;break}if((c[h+100>>2]|0)==0?(c[h+96>>2]|0)==0:0){if((d|0)==4){k=c[h+72>>2]|0;if(!k)va(23912,23776,2064,23896);s=(Jc(k,133)|0)!=0;n=b+2660|0;w=c[n>>2]|0;c[h>>2]=c[w+292>>2];r=h+4|0;c[r>>2]=c[w+288>>2];c[h+8>>2]=0;j=h+92|0;O=c[j>>2]|0;m=h+52|0;c[m>>2]=O;l=h+48|0;c[l>>2]=O;w=ck(w)|0;do if((w|0)!=-1){u=k+28|0;t=k+32|0;o=h+84|0;p=1;v=0;q=0;x=0;a:while(1){Af(h,w);c[m>>2]=c[j>>2];do if((x|0)==2)if(!(pf(w)|0)){w=c[t>>2]|0;O=(c[o>>2]|0)+q|0;w=(yk(w,O,qk(w)|0)|0)==0;if(!((p|0)==0|w)){f=42;break a}if(w)if((v|0)<1){f=47;break a}else v=v+ -1|0;if((a[(c[o>>2]|0)+(q+ -2)>>0]|0)!=92?(O=c[n>>2]|0,c[h>>2]=c[O+292>>2],c[r>>2]=(c[O+288>>2]|0)+ -3,oi(b,0,0,32),(je(k)|0)!=0):0){x=c[j>>2]|0;w=q+ -1|0;if(x>>>0>w>>>0)do{O=x;x=x+ -1|0;N=c[o>>2]|0;a[N+O>>0]=a[N+x>>0]|0}while(x>>>0>w>>>0);a[(c[o>>2]|0)+w>>0]=92;c[j>>2]=(c[j>>2]|0)+1;x=0}else x=0}else x=2;else if(!x){if((w|0)!=60){if(!p){p=0;x=0;break}x=(mf(w)|0)==0;p=x?0:p;x=0;break}w=ck(c[n>>2]|0)|0;if(pf(w)|0){if((s&(p|0)!=0?(g=c[u>>2]|0,(g|0)!=0):0)?(c[g>>2]|0)==92:0){f=27;break a}Af(h,w);q=(c[j>>2]|0)+ -1|0;x=1;break}if((w|0)==47){Af(h,47);N=ck(c[n>>2]|0)|0;O=(pf(N)|0)==0;dk(N,c[n>>2]|0);if(O){x=0;break}q=c[j>>2]|0;x=2;break}else if((w|0)==92){Af(h,92);w=ck(c[n>>2]|0)|0;if((w|0)!=47){dk(w,c[n>>2]|0);x=0;break}Af(h,47);N=ck(c[n>>2]|0)|0;O=(pf(N)|0)==0;dk(N,c[n>>2]|0);if(O){x=0;break}q=c[j>>2]|0;x=2;break}else{dk(w,c[n>>2]|0);x=0;break}}else if((x|0)==1)if(!(pf(w)|0)){x=c[t>>2]|0;O=(c[o>>2]|0)+q|0;v=((yk(x,O,qk(x)|0)|0)==0&1)+v|0;x=0}else x=1;while(0);w=ck(c[n>>2]|0)|0;if((w|0)==-1){g=1;break}}if((f|0)==27){c[j>>2]=c[l>>2];dk(w,c[n>>2]|0);dk(60,c[n>>2]|0);O=0;i=e;return O|0}else if((f|0)==42){g=(c[j>>2]|0)+ -1|0;if(g>>>0>=q>>>0)do{dk(a[(c[o>>2]|0)+g>>0]|0,c[n>>2]|0);g=g+ -1|0}while(g>>>0>=q>>>0);dk(47,c[n>>2]|0);dk(60,c[n>>2]|0);g=0}else if((f|0)==47){g=(c[j>>2]|0)+ -1|0;if(g>>>0>=q>>>0)do{dk(a[(c[o>>2]|0)+g>>0]|0,c[n>>2]|0);g=g+ -1|0}while(g>>>0>=q>>>0);dk(47,c[n>>2]|0);dk(60,c[n>>2]|0);c[j>>2]=q+ -2;g=0}if(!p){c[m>>2]=c[j>>2];if(g){f=58;break}else break}else{O=c[m>>2]|0;c[l>>2]=O;c[j>>2]=O;if(g){f=58;break}else break}}else{f=c[m>>2]|0;c[l>>2]=f;c[j>>2]=f;f=58}while(0);if((f|0)==58)oi(b,k,0,6);O=Hf(h)|0;i=e;return O|0}c[v>>2]=0;c[w>>2]=0;g=h+60|0;c[g>>2]=0;p=b+2660|0;N=c[p>>2]|0;c[h>>2]=c[N+292>>2];J=h+4|0;c[J>>2]=c[N+288>>2];j=h+8|0;c[j>>2]=0;m=h+92|0;O=c[m>>2]|0;l=h+52|0;c[l>>2]=O;u=h+48|0;c[u>>2]=O;N=ck(N)|0;b:do if((N|0)==-1)k=h+56|0;else{K=h+16|0;k=h+56|0;q=h+84|0;H=b+228|0;G=b+288|0;I=h+28|0;n=b+2724|0;L=0;c:while(1){if(c[K>>2]|0){Af(h,32);c[j>>2]=1;c[K>>2]=0}M=(d|0)==2;N=(N|0)==160&M?32:N;Af(h,N);d:do switch(c[k>>2]|0){case 3:{f=139;break c};case 1:{if((N|0)==47){M=ck(c[p>>2]|0)|0;if((M|0)==-1){dk(-1,c[p>>2]|0);break d}Af(h,M);if(pf(M)|0){O=(c[m>>2]|0)+ -3|0;c[m>>2]=O;c[l>>2]=O;dk(M,c[p>>2]|0);c[k>>2]=2;a[(c[q>>2]|0)+(c[m>>2]|0)>>0]=0;O=(c[p>>2]|0)+288|0;c[O>>2]=(c[O>>2]|0)+ -2;if((c[l>>2]|0)>>>0>(c[u>>2]|0)>>>0){f=86;break c}else break d}else{c[j>>2]=0;c[k>>2]=0;break d}}if((d|0)==3){c[j>>2]=0;c[k>>2]=0;d=3;break d}if((N|0)==37){M=(c[m>>2]|0)+ -2|0;c[m>>2]=M;c[k>>2]=9;c[l>>2]=M;if(M>>>0>(c[u>>2]|0)>>>0){f=123;break c}c[u>>2]=M;break d}else if((N|0)==35){M=(c[m>>2]|0)+ -2|0;c[m>>2]=M;c[k>>2]=10;c[l>>2]=M;if(M>>>0>(c[u>>2]|0)>>>0){f=126;break c}c[u>>2]=M;break d}else if((N|0)==33){M=ck(c[p>>2]|0)|0;do if((M|0)==45){if((ck(c[p>>2]|0)|0)!=45){oi(b,0,0,29);break}c[k>>2]=4;M=(c[m>>2]|0)+ -2|0;c[m>>2]=M;c[l>>2]=M;if(M>>>0>(c[u>>2]|0)>>>0){f=97;break c}c[u>>2]=M;break d}else{if((M&-33|0)!=68){if((M|0)!=91)break;M=(c[m>>2]|0)+ -2|0;c[m>>2]=M;c[k>>2]=8;c[l>>2]=M;if(M>>>0>(c[u>>2]|0)>>>0){f=114;break c}c[u>>2]=M;break d}c[k>>2]=5;O=(c[m>>2]|0)+ -2|0;c[m>>2]=O;c[l>>2]=O;while(1){d=ck(c[p>>2]|0)|0;if((d|0)==62|(d|0)==-1){f=103;break}if(mf(d)|0){f=105;break}}do if((f|0)==103){f=0;dk(d,c[p>>2]|0)}else if((f|0)==105){while(1){d=ck(c[p>>2]|0)|0;if((d|0)==62|(d|0)==-1){f=106;break}if(!(mf(d)|0)){f=108;break}else f=105}if((f|0)==106){f=0;dk(d,c[p>>2]|0);break}else if((f|0)==108){f=0;dk(d,c[p>>2]|0);break}}while(0);if((c[l>>2]|0)>>>0>(c[u>>2]|0)>>>0){f=110;break c}c[u>>2]=c[m>>2];d=0;break d}while(0);while(1){M=ck(c[p>>2]|0)|0;if((M|0)==-1){f=117;break}else if((M|0)==62)break}if((f|0)==117){f=0;dk(-1,c[p>>2]|0)}O=(c[m>>2]|0)+ -2|0;c[m>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;break d}else if((N|0)==63){M=(c[m>>2]|0)+ -2|0;c[m>>2]=M;c[k>>2]=6;c[l>>2]=M;if(M>>>0>(c[u>>2]|0)>>>0){f=120;break c}c[u>>2]=M;break d}else{if(pf(N)|0){dk(N,c[p>>2]|0);dk(60,c[p>>2]|0);O=(c[m>>2]|0)+ -2|0;c[m>>2]=O;c[l>>2]=O;c[k>>2]=3;if(O>>>0>(c[u>>2]|0)>>>0){f=130;break c}else break d}if((N|0)==38){dk(38,c[p>>2]|0);c[m>>2]=(c[m>>2]|0)+ -1}c[k>>2]=0;c[j>>2]=0;break d}};case 0:{M=(d|0)==0;if((mf(N)|0)!=0&M?(B=c[m>>2]|0,(B|0)==((c[u>>2]|0)+1|0)):0){c[m>>2]=B+ -1;c[j>>2]=0;d=c[p>>2]|0;c[h>>2]=c[d+292>>2];c[J>>2]=c[d+288>>2];d=0;break d}if((N|0)==60){c[k>>2]=1;break d}if(!(mf(N)|0)){if((N|0)==38&(d|0)!=3)lg(b,d);c[j>>2]=0;d=M?1:d;break d}if(!(c[j>>2]|0)){c[j>>2]=1;if(!((d&-2|0)!=2&(N|0)!=32))break d;kg(h,32);break d}else{if((d&-2|0)==2)break d;c[m>>2]=(c[m>>2]|0)+ -1;O=c[p>>2]|0;c[h>>2]=c[O+292>>2];c[J>>2]=c[O+288>>2];break d}};case 4:{if((N|0)==45?(O=ck(c[p>>2]|0)|0,Af(h,O),(O|0)==45):0){M=ck(c[p>>2]|0)|0;N=(L|0)!=0;if((M|0)==62){f=198;break c}while(1){if(!N){O=c[p>>2]|0;c[h>>2]=c[O+292>>2];c[J>>2]=(c[O+288>>2]|0)+ -3}L=L+1|0;if(c[H>>2]|0)a[(c[q>>2]|0)+((c[m>>2]|0)+ -2)>>0]=61;if((M|0)!=45)break;Af(h,45);M=ck(c[p>>2]|0)|0;N=(L|0)!=0;if((M|0)==62){f=198;break c}}a[(c[q>>2]|0)+((c[m>>2]|0)+ -1)>>0]=61;Af(h,M)}break};case 2:{c[u>>2]=(c[m>>2]|0)+ -1;M=(c[p>>2]|0)+288|0;c[M>>2]=(c[M>>2]|0)+2;M=(mg(b)|0)<<24>>24;c[g>>2]=ng(b,6)|0;O=c[u>>2]|0;c[l>>2]=O;c[m>>2]=O;while(1){if((M|0)==62){f=138;break c}else if((M|0)==-1)break;M=ck(c[p>>2]|0)|0}zf(b,c[g>>2]|0);break};case 5:{f=210;break c};case 6:{O=c[m>>2]|0;M=c[u>>2]|0;do if((O-M|0)==3)if(!(xk((c[q>>2]|0)+M|0,24056,3)|0)){c[k>>2]=11;break d}else{O=c[m>>2]|0;M=c[u>>2]|0;break}while(0);if(((O-M|0)==4?(xk((c[q>>2]|0)+M|0,24064,3)|0)==0:0)?(mf(a[(c[q>>2]|0)+((c[u>>2]|0)+3)>>0]|0)|0)!=0:0){c[k>>2]=12;c[w>>2]=0;break d}if(!((c[G>>2]|0)==0?(c[I>>2]|0)==0:0))f=264;do if((f|0)==264){f=0;if((N|0)!=63)break d;N=ck(c[p>>2]|0)|0;if((N|0)==-1){oi(b,0,0,36);dk(-1,c[p>>2]|0);break d}else{Af(h,N);break}}while(0);if((N|0)==62){f=269;break c}break};case 10:{if((N|0)==35){M=ck(c[p>>2]|0)|0;if((M|0)==62){f=286;break c}dk(M,c[p>>2]|0)}break};case 11:{if((N|0)==63){M=ck(c[p>>2]|0)|0;if((M|0)==62){f=290;break c}dk(M,c[p>>2]|0)}break};case 9:{if((N|0)==37){M=ck(c[p>>2]|0)|0;if((M|0)==62){f=282;break c}dk(M,c[p>>2]|0)}break};case 12:{M=(N|0)!=63;if(!((mf(N)|0)!=0&M)){if(M){c[E>>2]=0;c[v>>2]=0;dk(N,c[p>>2]|0);M=og(b,v,D,C)|0;if(!M){f=294;break c}O=c[n>>2]|0;O=rb[c[c[O>>2]>>2]&15](O,28)|0;c[O+0>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;c[O+16>>2]=0;c[O+20>>2]=0;c[O+24>>2]=0;c[O+20>>2]=M;c[O+24>>2]=qg(b,M,1,v,E)|0;c[O+16>>2]=c[E>>2];c[O+4>>2]=Kc(b,O)|0;pg(w,O)}M=ck(c[p>>2]|0)|0;if((M|0)==62){f=298;break c}dk(M,c[p>>2]|0)}break};case 8:{if((N|0)==93){M=ck(c[p>>2]|0)|0;if((M|0)==62){f=305;break c}dk(M,c[p>>2]|0);break d}else if((N|0)!=91)break d;M=c[u>>2]|0;if((c[m>>2]|0)==(M+6|0)?(xk((c[q>>2]|0)+M|0,24072,6)|0)==0:0){c[k>>2]=7;c[m>>2]=(c[m>>2]|0)+ -6}break};case 7:{if((N|0)==93){M=ck(c[p>>2]|0)|0;N=c[p>>2]|0;if((M|0)!=93){dk(M,N);break d}M=ck(N)|0;if((M|0)==62){f=311;break c}dk(M,c[p>>2]|0);dk(93,c[p>>2]|0)}break};default:{}}while(0);N=ck(c[p>>2]|0)|0;if((N|0)==-1)break b}switch(f|0){case 86:{if((d|0)==0?(F=(c[m>>2]|0)+ -1|0,(a[(c[q>>2]|0)+F>>0]|0)==32):0){c[m>>2]=F;c[l>>2]=F}O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 97:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 110:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 114:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 120:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 123:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 126:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 130:{O=Hf(h)|0;c[g>>2]=O;i=e;return O|0};case 138:{c[k>>2]=0;c[j>>2]=0;O=c[g>>2]|0;i=e;return O|0};case 139:{kg(h,(ck(c[p>>2]|0)|0)&255);c[u>>2]=(c[m>>2]|0)+ -1;q=mg(b)|0;c[v>>2]=0;c[w>>2]=0;h=ng(b,5)|0;c[g>>2]=h;if(q<<24>>24==47){dk(47,c[p>>2]|0);f=141}else if(q<<24>>24==62)n=0;else f=141;if((f|0)==141){q=c[o>>2]|0;c[A>>2]=0;r=c[p>>2]|0;if(!r)va(24136,23776,681,24160);h=b+168|0;q=q+60|0;e:while(1){if((c[r+4>>2]|0)==0?(ik(r)|0)!=0:0)break;s=og(b,v,z,y)|0;f:do if(!s){r=c[z>>2]|0;if(r){O=c[n>>2]|0;O=rb[c[c[O>>2]>>2]&15](O,28)|0;c[O+0>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;c[O+16>>2]=0;c[O+20>>2]=0;c[O+24>>2]=0;c[O+8>>2]=r;pg(A,O);break}r=c[y>>2]|0;if(!r)break e;O=c[n>>2]|0;O=rb[c[c[O>>2]>>2]&15](O,28)|0;c[O+0>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;c[O+16>>2]=0;c[O+20>>2]=0;c[O+24>>2]=0;c[O+12>>2]=r;pg(A,O)}else{r=qg(b,s,0,v,x)|0;g:do if(pf(a[s>>0]|0)|0){if((qk(s)|0)>>>0>1){t=1;do{if(!(rf(a[s+t>>0]|0)|0)){f=156;break g}t=t+1|0}while(t>>>0<(qk(s)|0)>>>0)}}else f=156;while(0);do if((f|0)==156){f=0;if((c[h>>2]|0)!=0?(cd(s)|0)!=0:0)break;t=c[n>>2]|0;t=rb[c[c[t>>2]>>2]&15](t,28)|0;c[t+0>>2]=0;c[t+4>>2]=0;c[t+8>>2]=0;c[t+12>>2]=0;c[t+16>>2]=0;c[t+20>>2]=s;c[t+24>>2]=r;do if(!(a[s>>0]|0))f=162;else{if((a[s+((qk(s)|0)+ -1)>>0]|0)!=34){f=162;break}hi(b,c[q>>2]|0,t,59)}while(0);do if((f|0)==162){f=0;s=c[q>>2]|0;if(!r){hi(b,s,t,50);break}else{hi(b,s,t,72);break}}while(0);Ef(b,t);break f}while(0);O=c[n>>2]|0;O=rb[c[c[O>>2]>>2]&15](O,28)|0;c[O+0>>2]=0;c[O+4>>2]=0;c[O+8>>2]=0;c[O+12>>2]=0;c[O+16>>2]=c[x>>2];c[O+20>>2]=s;c[O+24>>2]=r;c[O+4>>2]=Kc(b,O)|0;pg(A,O)}while(0);r=c[p>>2]|0;if(!r){f=143;break}}if((f|0)==143)va(24136,23776,681,24160);f=c[A>>2]|0;c[w>>2]=f;h=c[g>>2]|0;if(!(c[v>>2]|0))n=f;else{c[h+44>>2]=7;n=f}}c[h+20>>2]=n;O=c[u>>2]|0;c[l>>2]=O;c[m>>2]=O;if(!M)if((c[h+44>>2]|0)==5){O=c[h+28>>2]|0;if((O|0)!=0?(c[O+16>>2]&1|0)!=0:0)f=172;else f=175}else f=173;else f=172;if((f|0)==172)if(!h)h=0;else f=173;if((f|0)==173){h=c[h+28>>2]|0;if((h|0)!=0?(O=c[h>>2]|0,(O|0)==47|(O|0)==17):0)f=175;else h=0}if((f|0)==175){f=ck(c[p>>2]|0)|0;if((f|0)==10|(f|0)==12)h=1;else{dk(f,c[p>>2]|0);h=1}}c[j>>2]=h;c[k>>2]=0;f=c[g>>2]|0;j=f+28|0;h=c[j>>2]|0;do if(!h)pi(b,0,f,22);else{if(c[b+168>>2]|0){Zc(b,f,1);break}O=c[h+8>>2]|0;N=(c[o>>2]|0)+32|0;c[N>>2]=c[N>>2]&(O|57344);do if(O&57344){if(!(c[b+200>>2]|0)){oi(b,0,f,21);if(!f)break}else{if(!f){oi(b,0,0,21);break}O=c[h>>2]|0;if((O|0)==117|(O|0)==69)break;oi(b,0,f,21)}h=c[j>>2]|0;if(h){h=c[h>>2]|0;if((h|0)==59){O=b+2712|0;c[O>>2]=c[O>>2]|2;break}else if((h|0)==97){O=b+2712|0;c[O>>2]=c[O>>2]|1;break}else if((h|0)==69){O=b+2712|0;c[O>>2]=c[O>>2]|4;break}else break}}while(0);Zc(b,f,0)}while(0);O=c[g>>2]|0;i=e;return O|0};case 198:{if(N)oi(b,0,0,29);O=(c[m>>2]|0)+ -2|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;c[g>>2]=rg(b,2)|0;b=ck(c[p>>2]|0)|0;if((b|0)==10){O=c[g>>2]|0;c[O+64>>2]=1;i=e;return O|0}else{dk(b,c[p>>2]|0);O=c[g>>2]|0;i=e;return O|0}};case 210:{dk(N,c[p>>2]|0);c[m>>2]=(c[m>>2]|0)+ -1;w=c[o>>2]|0;y=w+92|0;D=c[y>>2]|0;u=Bf(c[w+124>>2]|0,w)|0;c[u+44>>2]=1;z=w+48|0;c[u+36>>2]=c[z>>2];C=w+52|0;x=u+40|0;c[x>>2]=c[C>>2];B=w+8|0;c[B>>2]=0;H=ck(c[p>>2]|0)|0;h:do if((H|0)==-1)f=240;else{A=w+84|0;v=u+32|0;E=0;G=1;F=1;i:while(1){if((F|0)!=4){H=(H|0)==10?32:H;if(mf(H)|0){if(!(c[B>>2]|0)){Af(w,H);I=1;f=217}}else f=216}else f=216;if((f|0)==216){Af(w,H);I=0;f=217}j:do if((f|0)==217){f=0;c[B>>2]=I;switch(F|0){case 0:{O=wf(H)|0;if((O|0)==83|(O|0)==80){D=(c[y>>2]|0)+ -1|0;F=2;break j}if((H|0)==91){D=c[y>>2]|0;F=4;break j}else if((H|0)==34|(H|0)==39){E=H;D=c[y>>2]|0;F=3;break j}else if((H|0)==62)break i;else{F=0;break j}};case 1:{if((mf(H)|0)==0?!((H|0)==62|(H|0)==91):0){F=1;break j}c[v>>2]=rk(c[n>>2]|0,(c[A>>2]|0)+D|0,(c[y>>2]|0)+~D|0)|0;if(!((H|0)==62|(H|0)==91)){F=0;break j}c[y>>2]=(c[y>>2]|0)+ -1;dk(H,c[p>>2]|0);F=0;break j};case 2:{F=(H|0)==62;if(!((mf(H)|0)!=0|F)){F=2;break j}O=rk(c[n>>2]|0,(c[A>>2]|0)+D|0,(c[y>>2]|0)+~D|0)|0;G=(wk(O,23736)|0)!=0&1;N=c[n>>2]|0;ob[c[(c[N>>2]|0)+8>>2]&15](N,O);if(!F){F=0;break j}c[y>>2]=(c[y>>2]|0)+ -1;dk(62,c[p>>2]|0);F=0;break j};case 4:{if((H|0)!=93){F=4;break j}c[z>>2]=D;c[C>>2]=(c[y>>2]|0)+ -1;Qd(u,Hf(w)|0);F=0;break j};case 3:{if((H|0)!=(E|0)){F=3;break j}F=rk(c[n>>2]|0,(c[A>>2]|0)+D|0,(c[y>>2]|0)+~D|0)|0;G=Nc(b,u,(G|0)!=0?23744:23736,F)|0;O=c[n>>2]|0;ob[c[(c[O>>2]|0)+8>>2]&15](O,F);c[G+16>>2]=E;E=0;G=0;F=0;break j};default:break j}}while(0);H=ck(c[p>>2]|0)|0;if((H|0)==-1){f=240;break h}}p=(c[y>>2]|0)+ -1|0;c[y>>2]=p;c[x>>2]=p;p=Lc(u,23736)|0;if(p)Qc(b,u,p);p=c[v>>2]|0;if((p|0)!=0?(cd(p)|0)!=0:0)break;oi(b,0,0,35);zf(b,u);u=0}while(0);if((f|0)==240){oi(b,0,0,35);zf(b,u);u=0}c[g>>2]=u;O=c[m>>2]|0;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;h=h+36|0;if(((c[h>>2]|0)==0?(t=c[g>>2]|0,(t|0)!=0):0)?(c[b+168>>2]|0)==0:0){j=Lc(t,23744)|0;if((j|0)!=0?(r=j+24|0,s=c[r>>2]|0,(s|0)!=0):0){j=0;while(1){if(j>>>0<17?(wk(c[22748+(j*20|0)>>2]|0,s)|0)==0:0){f=249;break}j=j+1|0;if((j|0)==19){b=0;break}}if((f|0)==249){f=c[22740+(j*20|0)>>2]|0;if(!(659455>>>j&1)){Li(b,25,1)|0;Li(b,26,1)|0;c[(c[o>>2]|0)+28>>2]=1;b=f}else b=f}O=c[n>>2]|0;ob[c[(c[O>>2]|0)+8>>2]&15](O,c[r>>2]|0);O=c[n>>2]|0;c[r>>2]=pk(O,jg(b)|0)|0}else b=0;c[h>>2]=b}O=c[g>>2]|0;i=e;return O|0};case 269:{p=c[m>>2]|0;h=p+ -1|0;c[m>>2]=h;if(!h){c[l>>2]=0;a[c[q>>2]>>0]=0;b=rg(b,3)|0;c[g>>2]=b}else{o=c[u>>2]|0;f=c[q>>2]|0;k:do if((h|0)==(o|0)){o=h;r=0}else{t=h-o|0;s=0;while(1){r=s+1|0;if(mf(a[f+(s+o)>>0]|0)|0){r=s;break k}if(r>>>0<t>>>0)s=r;else break}}while(0);s=p+ -2|0;p=(a[f+s>>0]|0)==63;if(p){c[m>>2]=s;h=s}c[u>>2]=r+o;c[l>>2]=h;a[f+h>>0]=0;O=rg(b,3)|0;c[g>>2]=O;c[O+56>>2]=p&1;O=rk(c[n>>2]|0,(c[q>>2]|0)+((c[u>>2]|0)-r)|0,r)|0;b=c[g>>2]|0;c[b+32>>2]=O}c[k>>2]=0;c[j>>2]=0;O=b;i=e;return O|0};case 282:{O=(c[m>>2]|0)+ -1|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,10)|0;c[g>>2]=O;i=e;return O|0};case 286:{O=(c[m>>2]|0)+ -1|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,11)|0;c[g>>2]=O;i=e;return O|0};case 290:{O=(c[m>>2]|0)+ -1|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,12)|0;c[g>>2]=O;i=e;return O|0};case 294:{c[m>>2]=(c[m>>2]|0)+ -1;O=c[u>>2]|0;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,13)|0;c[g>>2]=O;c[O+20>>2]=c[w>>2];i=e;return O|0};case 298:{c[m>>2]=(c[m>>2]|0)+ -1;O=c[u>>2]|0;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,13)|0;c[g>>2]=O;c[O+20>>2]=c[w>>2];i=e;return O|0};case 305:{O=(c[m>>2]|0)+ -1|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,9)|0;c[g>>2]=O;i=e;return O|0};case 311:{O=(c[m>>2]|0)+ -1|0;c[m>>2]=O;c[l>>2]=O;a[(c[q>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,8)|0;c[g>>2]=O;i=e;return O|0}}}while(0);f=c[k>>2]|0;if(!f){O=c[m>>2]|0;c[l>>2]=O;if(O>>>0<=(c[u>>2]|0)>>>0){O=0;i=e;return O|0}dk(-1,c[p>>2]|0);b=(c[m>>2]|0)+ -1|0;if((a[(c[h+84>>2]|0)+b>>0]|0)==32){c[m>>2]=b;c[l>>2]=b}O=Hf(h)|0;c[g>>2]=O;i=e;return O|0}else if((f|0)==4){oi(b,0,0,29);O=c[m>>2]|0;c[l>>2]=O;a[(c[h+84>>2]|0)+O>>0]=0;c[k>>2]=0;c[j>>2]=0;O=rg(b,2)|0;c[g>>2]=O;i=e;return O|0}else{O=0;i=e;return O|0}}O=zl(b)|0;c[h+60>>2]=O;i=e;return O|0}while(0);c[j>>2]=0;g=c[h+60>>2]|0;if((c[g+44>>2]|0)!=4){O=g;i=e;return O|0}if((c[h+100>>2]|0)==0?(c[h+96>>2]|0)==0:0){O=g;i=e;return O|0}O=zl(b)|0;c[f>>2]=O;i=e;return O|0}function ag(){var a=0;a=i;sg(23936,24);sg(23944,8);sg(23952,4);sg(23960,133);sg(23976,38);sg(24008,70);sg(24040,128);i=a;return}function bg(a){a=a|0;var b=0;b=i;a=c[a+2724>>2]|0;a=rb[c[c[a>>2]>>2]&15](a,28)|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a+24>>2]=0;i=b;return a|0}function cg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;h=a+2724|0;f=c[h>>2]|0;f=rb[c[c[f>>2]>>2]&15](f,28)|0;c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+24>>2]=0;c[f+20>>2]=pk(c[h>>2]|0,b)|0;c[f+24>>2]=pk(c[h>>2]|0,d)|0;c[f+16>>2]=e;c[f+4>>2]=Kc(a,f)|0;i=g;return f|0}function dg(a,b){a=a|0;b=b|0;var c=0;c=i;pg(a+20|0,b);i=c;return}function eg(a,b){a=a|0;b=b|0;a=a+20|0;c[b>>2]=c[a>>2];c[a>>2]=b;return}function fg(a){a=a|0;if(a>>>0<128)a=(c[23136+(a<<2)>>2]&128|0)!=0;else a=0;return a&1|0}function gg(b,c){b=b|0;c=c|0;var d=0,e=0;d=i;e=a[c>>0]|0;if(!(e<<24>>24)){i=d;return}do{c=c+1|0;Af(b,e&255);e=a[c>>0]|0}while(e<<24>>24!=0);i=d;return}function hg(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;e=0;while(1){f=e+1|0;if((c[22740+(e*20|0)>>2]|0)==(a|0))break;if((f|0)==19){e=0;b=5;break}else e=f}if((b|0)==5){i=d;return e|0}f=c[22752+(e*20|0)>>2]|0;i=d;return f|0}function ig(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=Nf(a)|0;if(!d){f=0;i=b;return f|0}e=c[a+2724>>2]|0;e=rb[c[c[e>>2]>>2]&15](e,68)|0;f=e+0|0;a=f+68|0;do{c[f>>2]=0;f=f+4|0}while((f|0)<(a|0));c[e+44>>2]=1;Rd(d,e);f=e;i=b;return f|0}function jg(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;e=0;while(1){f=e+1|0;if((c[22740+(e*20|0)>>2]|0)==(a|0))break;if((f|0)==19){e=0;b=5;break}else e=f}if((b|0)==5){i=d;return e|0}f=c[22748+(e*20|0)>>2]|0;i=d;return f|0}function kg(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;f=c[b+92>>2]|0;if(!f){i=e;return}a[(c[b+84>>2]|0)+(f+ -1)>>0]=d;i=e;return}function lg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;f=i;i=i+16|0;e=f+4|0;l=f;o=c[b+168>>2]|0;q=c[b+432>>2]|0;c[l>>2]=0;k=b+68|0;g=c[k>>2]|0;h=g+92|0;r=c[h>>2]|0;j=r+ -1|0;m=b+2660|0;s=(c[(c[m>>2]|0)+288>>2]|0)+ -1|0;w=(o|0)==0;u=b+376|0;v=b+92|0;z=0;y=0;a:while(1){x=(y|0)==1;y=24176+(y<<2)|0;while(1){A=ck(c[m>>2]|0)|0;if((A|0)==-1){t=16;break a}else if((A|0)==59){A=59;u=1;break a}B=z+1|0;if((z|0)==0&(A|0)==35)break;if((B|0)==2&x){if((A|0)==120){x=120;t=12;break}if(w&(A|0)==88){x=88;t=12;break}}if(!(pb[c[y>>2]&15](A)|0)){t=15;break a}Af(g,A);z=B}if((t|0)==12){t=0;Af(g,x);z=2;y=2;continue}if(!(c[u>>2]|0)){t=7;break}if((c[v>>2]&-2|0)==12){t=7;break}Af(g,35);z=B;y=1}if((t|0)==7){dk(35,c[m>>2]|0);i=f;return}else if((t|0)==15){dk(A,c[m>>2]|0);u=0}else if((t|0)==16){A=-1;u=0}t=g+84|0;a[(c[t>>2]|0)+(c[h>>2]|0)>>0]=0;if((((vk((c[t>>2]|0)+j|0,24192)|0)==0?(c[b+172>>2]|0)==0:0)?(c[g+28>>2]|0)==0:0)?(c[b+176>>2]|0)==0:0)gi(b,5,(c[t>>2]|0)+j|0,39);if(((El((c[t>>2]|0)+j|0,o,e,l)|0)!=0?(n=c[e>>2]|0,(n&-32|0)!=128):0)?(p=(A|0)!=59,!(n>>>0>255&p)):0){if(p){c[g>>2]=c[(c[m>>2]|0)+292>>2];c[g+4>>2]=s;gi(b,1,(c[t>>2]|0)+j|0,A)}if(!q){c[h>>2]=j;h=c[e>>2]|0;if((h|0)==160&(d|0)==2){c[e>>2]=32;h=32}Af(g,h);if((c[e>>2]|0)==38?(c[b+252>>2]|0)==0:0)gg(g,24200)}else Af(g,59);B=(c[k>>2]|0)+32|0;c[B>>2]=c[B>>2]&(c[l>>2]|57344);i=f;return}c[g>>2]=c[(c[m>>2]|0)+292>>2];c[g+4>>2]=s;if((c[h>>2]|0)>>>0<=r>>>0){gi(b,4,(c[t>>2]|0)+j|0,c[e>>2]|0);i=f;return}k=c[e>>2]|0;if((k&-32|0)!=128){gi(b,3,(c[t>>2]|0)+j|0,k);if(!u){i=f;return}Af(g,59);i=f;return}l=c[35306]|0;if((l|0)==6)k=ek(k)|0;else if((l|0)==7)k=fk(k)|0;else k=0;l=(k|0)!=0;if((A|0)!=59)gi(b,2,(c[t>>2]|0)+j|0,A);fi(b,82,c[e>>2]|0,l&1^1);c[h>>2]=j;if(!l){i=f;return}Af(g,k);i=f;return}function mg(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=c[b+68>>2]|0;g=(c[e+84>>2]|0)+(c[e+48>>2]|0)|0;h=a[g>>0]|0;f=(c[b+168>>2]|0)!=0;if(!f?(uf(h)|0)!=0:0)a[g>>0]=vf(h)|0;g=b+2660|0;b=ck(c[g>>2]|0)|0;a:do if((b|0)==-1)b=-1;else while(1){if(f){if(!(tf(b)|0))break a}else{if(!(rf(b)|0))break a;if(uf(b)|0)b=vf(b)|0}Af(e,b);b=ck(c[g>>2]|0)|0;if((b|0)==-1){b=-1;break}}while(0);c[e+52>>2]=c[e+92>>2];i=d;return b&255|0}function ng(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;e=i;h=c[a+68>>2]|0;d=Bf(c[h+124>>2]|0,h)|0;c[d+44>>2]=b;f=h+48|0;g=c[f>>2]|0;c[d+32>>2]=rk(c[a+2724>>2]|0,(c[h+84>>2]|0)+g|0,(c[h+52>>2]|0)-g|0)|0;f=c[f>>2]|0;c[d+36>>2]=f;c[d+40>>2]=f;if((b+ -5|0)>>>0>=3){i=e;return d|0}Je(a,d)|0;i=e;return d|0}function og(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;m=a+68|0;j=c[m>>2]|0;c[d>>2]=0;c[e>>2]=0;h=a+2660|0;l=j+60|0;a:while(1){k=ck(c[h>>2]|0)|0;switch(k|0){case 60:{g=6;break a};case 34:case 39:{hi(a,c[l>>2]|0,0,58);continue a};case-1:{g=30;break a};case 61:{hi(a,c[l>>2]|0,0,69);continue a};case 47:{g=3;break a};case 62:{a=0;g=48;break a};default:if(!(mf(k)|0)){g=32;break a}else continue a}}do if((g|0)==3){g=ck(c[h>>2]|0)|0;if((g|0)!=62){dk(g,c[h>>2]|0);e=j+92|0;d=c[e>>2]|0;b=47;g=33;break}c[b>>2]=1;m=0;i=f;return m|0}else if((g|0)==6){j=ck(c[h>>2]|0)|0;if((j|0)==37){e=c[m>>2]|0;k=e+92|0;j=e+48|0;c[j>>2]=c[k>>2];l=ck(c[h>>2]|0)|0;b:do if((l|0)==-1)g=13;else{while(1){Af(e,l);if((l|0)==37){l=ck(c[h>>2]|0)|0;if((l|0)==-1){g=13;break b}Af(e,l);if((l|0)==62)break}l=ck(c[h>>2]|0)|0;if((l|0)==-1){g=13;break b}}h=(c[k>>2]|0)+ -2|0;c[k>>2]=h}while(0);if((g|0)==13)h=c[k>>2]|0;g=e+52|0;c[g>>2]=h;if(h>>>0>(c[j>>2]|0)>>>0){a=rg(a,10)|0;h=c[g>>2]|0}else a=0;c[j>>2]=h;c[d>>2]=a;m=0;i=f;return m|0}else if((j|0)==63){d=c[m>>2]|0;k=d+92|0;j=d+48|0;c[j>>2]=c[k>>2];l=ck(c[h>>2]|0)|0;c:do if((l|0)==-1)g=23;else{while(1){Af(d,l);if((l|0)==63){l=ck(c[h>>2]|0)|0;if((l|0)==-1){g=23;break c}Af(d,l);if((l|0)==62)break}l=ck(c[h>>2]|0)|0;if((l|0)==-1){g=23;break c}}h=(c[k>>2]|0)+ -2|0;c[k>>2]=h}while(0);if((g|0)==23)h=c[k>>2]|0;g=d+52|0;c[g>>2]=h;if(h>>>0>(c[j>>2]|0)>>>0){a=rg(a,12)|0;h=c[g>>2]|0}else a=0;c[j>>2]=h;c[e>>2]=a;m=0;i=f;return m|0}else{dk(j,c[h>>2]|0);dk(60,c[h>>2]|0);hi(a,c[l>>2]|0,0,52);m=0;i=f;return m|0}}else if((g|0)==30){hi(a,c[l>>2]|0,0,75);dk(-1,c[h>>2]|0);m=0;i=f;return m|0}else if((g|0)==32){e=j+92|0;d=c[e>>2]|0;if((k+ -61|0)>>>0<2)g=34;else{b=k;g=33}}else if((g|0)==48){i=f;return a|0}while(0);d:do if((g|0)==33){l=a+168|0;k=b;while(1){if((k|0)==60|(k|0)==-1){g=36;break}if((b|0)==45?(k|0)==34|(k|0)==39:0){g=39;break}if(mf(k)|0)break d;if((c[l>>2]|0)==0?(uf(k)|0)!=0:0)b=vf(k)|0;else b=k;Af(j,b);k=ck(c[h>>2]|0)|0;if((k+ -61|0)>>>0<2){g=34;break d}}if((g|0)==36){dk(k,c[h>>2]|0);break}else if((g|0)==39){c[e>>2]=(c[e>>2]|0)+ -1;dk(k,c[h>>2]|0);break}}while(0);if((g|0)==34)dk(k,c[h>>2]|0);g=(c[e>>2]|0)-d|0;if((g|0)>0)a=rk(c[a+2724>>2]|0,(c[j+84>>2]|0)+d|0,g)|0;else a=0;c[e>>2]=d;m=a;i=f;return m|0}function pg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a>>2]|0;if(!e){c[a>>2]=b;i=d;return}while(1){a=c[e>>2]|0;if(!a)break;else e=a}c[e>>2]=b;i=d;return}function qg(b,d,e,f,g){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;var h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=i;p=b+68|0;j=c[p>>2]|0;c[g>>2]=34;n=(c[b+324>>2]|0)==0;k=b+2660|0;while(1){l=ck(c[k>>2]|0)|0;if((l|0)==-1){o=3;break}if(!(mf(l)|0)){o=5;break}}if((o|0)==3){dk(-1,c[k>>2]|0);l=-1}else if((o|0)==5)if((l|0)==34|(l|0)==39|(l|0)==61){while(1){l=ck(c[k>>2]|0)|0;if((l|0)==-1){o=8;break}if(!(mf(l)|0)){o=10;break}}do if((o|0)==8){dk(-1,c[k>>2]|0);l=-1;o=35}else if((o|0)==10){if((l|0)==34|(l|0)==39)break;else if((l|0)!=60){o=35;break}l=j+92|0;m=c[l>>2]|0;Af(j,60);n=c[p>>2]|0;w=ck(c[k>>2]|0)|0;Af(n,w);if((w|0)==37|(w|0)==63|(w|0)==64)d=1;else d=0;o=ck(c[k>>2]|0)|0;a:do if((o|0)!=-1){d=(d|0)!=0;p=34;b:while(1){while(1){if((o|0)==62){o=18;break b}if(!d?(mf(o)|0)!=0:0)break a;Af(n,o);if((o|0)==39){do{o=ck(c[k>>2]|0)|0;if((o|0)==62){o=31;break b}else if((o|0)==-1){o=30;break b}Af(n,o)}while((o|0)!=39)}else if((o|0)==34)break;o=ck(c[k>>2]|0)|0;if((o|0)==-1)break a}do{o=ck(c[k>>2]|0)|0;if((o|0)==-1){o=26;break b}else if((o|0)==62){o=27;break b}Af(n,o)}while((o|0)!=34);o=ck(c[k>>2]|0)|0;if((o|0)==-1){p=39;break a}else p=39}if((o|0)==18)if(d){Af(n,62);break}else{dk(62,c[k>>2]|0);break}else if((o|0)==26){hi(b,c[n+60>>2]|0,0,75);dk(-1,c[k>>2]|0);p=0;break}else if((o|0)==27){dk(62,c[k>>2]|0);hi(b,c[n+60>>2]|0,0,52);p=0;break}else if((o|0)==30){hi(b,c[n+60>>2]|0,0,75);dk(-1,c[k>>2]|0);p=0;break}else if((o|0)==31){dk(62,c[k>>2]|0);hi(b,c[n+60>>2]|0,0,52);p=0;break}}else p=34;while(0);c[g>>2]=p;g=(c[l>>2]|0)-m|0;c[l>>2]=m;if((g|0)<=0){w=0;i=h;return w|0}w=rk(c[b+2724>>2]|0,(c[j+84>>2]|0)+m|0,g)|0;i=h;return w|0}while(0);if((o|0)==35){dk(l,c[k>>2]|0);l=0}p=j+92|0;m=c[p>>2]|0;u=ck(c[k>>2]|0)|0;c:do if((u|0)!=-1){q=(l|0)==0;s=j+60|0;r=j+84|0;e=(e|0)==0;t=0;w=0;v=0;d:while(1){e:do if(q){switch(u|0){case 60:{o=46;break d};case 47:break;case 34:case 39:{hi(b,c[s>>2]|0,0,58);o=ck(c[k>>2]|0)|0;if((o|0)==62){o=44;break d}dk(o,c[k>>2]|0);if((u|0)==60){o=46;break d}else if((u|0)!=47){o=55;break e}break};case 62:{o=42;break d};default:{o=55;break e}}o=ck(c[k>>2]|0)|0;if((o|0)==62?(Pc(b,d)|0)==0:0){o=49;break d}dk(o,c[k>>2]|0);u=47;o=60}else{if((u|0)==(l|0))break c;if((u|0)==10|(u|0)==60|(u|0)==62)w=w+1|0;v=(u|0)==62?1:v;o=55}while(0);do if((o|0)==55){o=0;if((u|0)==38){Af(j,38);lg(b,0);if(!((a[(c[r>>2]|0)+((c[p>>2]|0)+ -1)>>0]|0)==10&n)){t=38;break}kg(j,32);t=38;break}else if((u|0)==92){o=ck(c[k>>2]|0)|0;if((o|0)==10){u=10;o=60;break}dk(o,c[k>>2]|0);u=92;o=60;break}else{o=60;break}}while(0);do if((o|0)==60){o=0;if(!(mf(u)|0))if(!e?(uf(u)|0)!=0:0)t=vf(u)|0;else t=u;else{if(q)break c;if(n){if((u|0)==10?(Pc(b,d)|0)!=0:0){hi(b,c[s>>2]|0,0,65);t=10;break}if((t|0)==32){if(!(Pc(b,d)|0)){t=32;break}hi(b,c[s>>2]|0,0,87);t=32;break}else t=32}else t=u}Af(j,t)}while(0);u=ck(c[k>>2]|0)|0;if((u|0)==-1){o=39;break c}}if((o|0)==42){dk(62,c[k>>2]|0);break}else if((o|0)==44){Af(j,u);dk(62,c[k>>2]|0);break}else if((o|0)==46){dk(60,c[k>>2]|0);dk(62,c[k>>2]|0);hi(b,c[s>>2]|0,0,52);break}else if((o|0)==49){c[f>>2]=1;dk(62,c[k>>2]|0);break}}else{s=j+60|0;w=0;v=0;o=39}while(0);if((o|0)==39){hi(b,c[s>>2]|0,0,75);dk(-1,c[k>>2]|0)}do if(w>>>0>10&(v|0)!=0&n?(Rc(b,d)|0)==0:0){k=j+84|0;if((Pc(b,d)|0)!=0?(xk((c[k>>2]|0)+m|0,24080,11)|0)==0:0)break;if(xk((c[k>>2]|0)+m|0,24096,5)|0)pi(b,0,0,16)}while(0);o=(c[p>>2]|0)-m|0;c[p>>2]=m;k=(l|0)!=0;if((o|0)>0|k){if((((n?(wk(d,24104)|0)!=0:0)?(wk(d,24112)|0)!=0:0)?(wk(d,24120)|0)!=0:0)?(wk(d,24128)|0)!=0:0){d=m+ -1|0;n=c[j+84>>2]|0;while(1)if(!(mf(a[n+(d+o)>>0]|0)|0))break;else o=o+ -1|0;if((mf(a[n+m>>0]|0)|0)!=0&(m|0)<(o|0))do{m=m+1|0;o=o+ -1|0}while((mf(a[n+m>>0]|0)|0)!=0&(m|0)<(o|0))}b=rk(c[b+2724>>2]|0,(c[j+84>>2]|0)+m|0,o)|0}else b=0;c[g>>2]=k?l:34;w=b;i=h;return w|0}dk(l,c[k>>2]|0);w=0;i=h;return w|0}function rg(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[a+68>>2]|0;a=Bf(c[e+124>>2]|0,e)|0;c[a+44>>2]=b;c[a+36>>2]=c[e+48>>2];c[a+40>>2]=c[e+52>>2];i=d;return a|0}function sg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;f=a[b>>0]|0;if(!(f<<24>>24)){i=e;return}do{b=b+1|0;g=23136+((f&255)<<2)|0;c[g>>2]=c[g>>2]|d;f=a[b>>0]|0}while(f<<24>>24!=0);i=e;return}function tg(a){a=a|0;var b=0,d=0,e=0;b=i;d=a+2612|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;e=a+2636|0;a=a+2724|0;c[e+0>>2]=-1;c[e+4>>2]=-1;c[e+8>>2]=-1;c[e+12>>2]=-1;c[e+16>>2]=-1;c[e+20>>2]=-1;c[d>>2]=c[a>>2];i=b;return}function ug(a){a=a|0;var b=0,d=0,e=0;b=i;e=a+2724|0;d=c[e>>2]|0;ob[c[(c[d>>2]|0)+8>>2]&15](d,c[a+2616>>2]|0);d=a+2612|0;c[d+0>>2]=0;c[d+4>>2]=0;c[d+8>>2]=0;c[d+12>>2]=0;c[d+16>>2]=0;c[d+20>>2]=0;a=a+2636|0;c[a+0>>2]=-1;c[a+4>>2]=-1;c[a+8>>2]=-1;c[a+12>>2]=-1;c[a+16>>2]=-1;c[a+20>>2]=-1;c[d>>2]=c[e>>2];i=b;return}function vg(a,b){a=a|0;b=b|0;var d=0;d=i;if(c[a+2624>>2]|0)Ag(a);hk(10,c[a+2664>>2]|0);c[a+2636>>2]=b;i=d;return}function wg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+16|0;g=e;if((Te(d)|0)!=0?(f=d+40|0,j=c[f>>2]|0,h=c[d+36>>2]|0,j>>>0>h>>>0):0){c[g>>2]=0;b=b+84|0;do{d=(c[b>>2]|0)+h|0;k=a[d>>0]|0;c[g>>2]=k&255;if(k<<24>>24<0){h=(Hk(d,g)|0)+h|0;j=c[f>>2]|0}h=h+1|0}while(h>>>0<j>>>0);k=c[g>>2]|0;if((k|0)==10|(k|0)==32){k=1;i=e;return k|0}}k=0;i=e;return k|0}function xg(a){a=a|0;var b=0,d=0;b=i;d=Rf(a)|0;if(!d){i=b;return}d=c[d+12>>2]|0;if(!d){i=b;return}do{yg(a,0,0,d);d=c[d+8>>2]|0}while((d|0)!=0);i=b;return}function yg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=i;m=c[a+76>>2]|0;q=a+176|0;x=c[q>>2]|0;if(!e){i=f;return}v=e+44|0;do switch(c[v>>2]|0){case 13:{Fg(a,d,e);i=f;return};case 9:{Hg(a,d,e);i=f;return};case 0:{e=c[e+12>>2]|0;if(!e){i=f;return}do{yg(a,b,d,e);e=c[e+8>>2]|0}while((e|0)!=0);i=f;return};case 12:{Kg(a,d,e);i=f;return};case 2:{Cg(a,d,e);i=f;return};case 4:{Bg(a,b,d,e);i=f;return};case 8:{Gg(a,d,e);i=f;return};case 1:{Dg(a,d,e);i=f;return};case 10:{Ig(a,d,e);i=f;return};case 11:{Jg(a,d,e);i=f;return};case 3:{Eg(a,d,e);i=f;return};default:{if((Xe(e)|0)==0?(w=c[v>>2]|0,(w|0)!=7|(x|0)!=0):0){if((w|0)==7)c[v>>2]=5;k=e+28|0;r=c[k>>2]|0;do if(r){if((c[r+20>>2]|0)!=32?(c[r>>2]|0)!=107:0){if(!r)break;x=c[r>>2]|0;if(!((x|0)==92|(x|0)==101))break;k=b|25;b=a+2612|0;o=c[q>>2]|0;m=e;do{if(((m|0)!=0?(p=c[m+28>>2]|0,(p|0)!=0):0)?(c[p>>2]|0)==46:0){g=62;break}m=c[m>>2]|0}while((m|0)!=0);if((g|0)==62)vg(a,d);Mg(a,k,d,e);vg(a,0);o=(o|0)!=0;m=e+12|0;do if(o?(c[m>>2]|0)!=0:0){p=Jc(e,143)|0;do if((p|0)!=0?(l=p+24|0,n=c[l>>2]|0,(n|0)!=0):0){n=(wk(n,25624)|0)==0;if(n){l=25696;n=n?25728:25696}else{n=c[l>>2]|0;if(!n){l=25696;n=25696;break}n=(wk(n,25640)|0)==0;if(n){l=n?25712:25696;n=n?25720:25696;break}l=c[l>>2]|0;if(!l){l=25696;n=25696;break}n=(wk(l,25656)|0)==0;l=25696;n=n?25704:25696}}else{l=25696;n=25696}while(0);q=c[m>>2]|0;p=c[q+36>>2]|0;if((c[q+44>>2]|0)==4?(j=(zk((c[(c[a+68>>2]|0)+84>>2]|0)+p|0,1-p+(c[q+40>>2]|0)|0,25680)|0)!=0,j):0){j=j&1;break}j=Og(a)|0;Pg(b,n);Pg(b,25680);Pg(b,l);Lg(a,d);Ki(a,2,j)|0;j=0}else{l=25696;n=25696;j=0}while(0);r=c[m>>2]|0;if(r){p=e+16|0;q=a+68|0;s=-1;do{yg(a,k,d,r);if((r|0)==(c[p>>2]|0))s=Qg(c[q>>2]|0,r,16)|0;r=c[r+8>>2]|0}while((r|0)!=0);if((s|0)<0)g=81}else g=81;if((g|0)==81)Lg(a,d);if(o){k=c[m>>2]|0;if(!((k|0)==0|(j|0)!=0)){g=Og(a)|0;Pg(b,n);Pg(b,25672);Pg(b,l);Ki(a,2,g)|0;Lg(a,d);g=85}}else g=85;if((g|0)==85)k=c[m>>2]|0;if((k|0)!=0?(h=a+2636|0,(c[h>>2]|0)!=(d|0)):0)c[h>>2]=d;Ng(a,e);if(c[a+152>>2]|0){i=f;return}if(!(c[e+8>>2]|0)){i=f;return}if(Ve(e,16)|0){i=f;return}if(Te(e)|0){i=f;return}vg(a,d);i=f;return}x=c[a+412>>2]|0;Lg(a,d);Lg(a,d);if(((x|0)!=0?(u=c[e>>2]|0,(u|0)!=0):0)?(c[u+12>>2]|0)!=(e|0):0)vg(a,d);Mg(a,b,d,e);vg(a,0);g=c[e+12>>2]|0;if(g){h=b|9;do{yg(a,h,0,g);g=c[g+8>>2]|0}while((g|0)!=0)}Lg(a,0);Ng(a,e);if(c[a+152>>2]|0){i=f;return}if(!(c[e+8>>2]|0)){i=f;return}vg(a,d);i=f;return}while(0);if(We(e)|0){if(((c[a+200>>2]|0)!=0?(t=c[k>>2]|0,(t|0)!=0):0)?(c[t>>2]|0)==69:0){g=c[e+12>>2]|0;if(!g){i=f;return}e=b|8;do{yg(a,e,d,g);g=c[g+8>>2]|0}while((g|0)!=0);i=f;return}Mg(a,b,d,e);if(!(Rg(a,e)|0)){g=c[e+12>>2]|0;if(g)do{yg(a,b,d,g);g=c[g+8>>2]|0}while((g|0)!=0)}else{g=m+d|0;Lg(a,g);h=c[e+12>>2]|0;if(h)do{yg(a,b,g,h);h=c[h+8>>2]|0}while((h|0)!=0);Lg(a,d)}Ng(a,e);i=f;return}n=c[a+152>>2]|0;l=(n|0)!=0;n=(n|0)==2;if(!(c[a+164>>2]|0))j=(c[a+160>>2]|0)!=0;else j=1;h=(c[a+412>>2]|0)!=0;do if((h?(o=c[e>>2]|0,(o|0)!=0):0)?(c[o+12>>2]|0)!=(e|0):0){x=c[k>>2]|0;if((x|0)!=0?(c[x>>2]|0)==48:0)break;vg(a,d)}while(0);x=(Rg(a,e)|0)==0;m=(x?0:m)+d|0;Lg(a,d);if(n?(c[e+4>>2]|0)!=0:0)vg(a,d);if(!((j?(Ve(e,2097152)|0)!=0:0)?(c[e+20>>2]|0)==0:0))g=122;a:do if((g|0)==122){Mg(a,b,d,e);if(Rg(a,e)|0){x=c[k>>2]|0;if(((x|0)!=0?(c[x>>2]|0)==61:0)?(Te(c[e+12>>2]|0)|0)!=0:0)break;Lg(a,m);break}do if(!(Ve(e,2)|0)){x=c[k>>2]|0;if((x|0)!=0?(c[x>>2]|0)==71:0)break;if(!(Ve(e,4)|0))break a;x=c[k>>2]|0;if((x|0)!=0?(c[x>>2]|0)==111:0)break a}while(0);vg(a,m)}while(0);g=e+12|0;n=c[g>>2]|0;if(n){o=0;while(1){if(((!((o|0)==0|l)?(Te(o)|0)!=0:0)?(c[n+28>>2]|0)!=0:0)?(Ve(n,16)|0)==0:0)vg(a,m);yg(a,b,m,n);o=c[n+8>>2]|0;if(!o)break;else{x=n;n=o;o=x}}}do if(!(Rg(a,e)|0)){if(j){if(Ve(e,32768)|0){g=165;break}}else{if(Ve(e,2)|0){Lg(a,d);g=152;break}x=c[k>>2]|0;if((x|0)!=0?(c[x>>2]|0)==71:0){g=150;break}if(Ve(e,4)|0){b=c[k>>2]|0;if(!b){g=150;break}if((c[b>>2]|0)!=111){g=150;break}}}b:do if(h){g=c[g>>2]|0;if(g)do{if(Te(g)|0)break b;g=c[g+8>>2]|0}while((g|0)!=0);vg(a,d)}while(0);Ng(a,e);g=160}else g=150;while(0);if((g|0)==150){Lg(a,d);if(j?(Ve(e,32768)|0)!=0:0)g=165;else g=152}if((g|0)==152){Ng(a,e);g=160}do if((g|0)==160)if(l|j)g=165;else{b=c[k>>2]|0;if(!b){if(h)break}else if((c[b>>2]|0)==48|h){g=165;break}vg(a,d);i=f;return}while(0);if((g|0)==165?!h:0){i=f;return}if(!(c[e+8>>2]|0)){i=f;return}if(!(Ve(e,232)|0)){i=f;return}vg(a,d);i=f;return}if(!(Ve(e,16)|0))Lg(a,d);g=e+28|0;h=c[g>>2]|0;if(h){do if((c[h>>2]|0)==17?(s=c[e+4>>2]|0,(s|0)!=0):0){h=c[s+28>>2]|0;if(!h){if(b&1)break}else if(!((c[h>>2]|0)!=17&(b&1|0)==0))break;if(c[a+232>>2]|0)vg(a,d)}while(0);x=c[g>>2]|0;if(((((x|0)!=0?(c[x>>2]|0)==47:0)?(c[a+412>>2]|0)!=0:0)?(r=c[e>>2]|0,(r|0)!=0):0)?(c[r+12>>2]|0)!=(e|0):0)vg(a,d)}Mg(a,b,d,e);if(!(c[e+8>>2]|0)){i=f;return}e=c[e+28>>2]|0;if(!e){i=f;return}if((c[e>>2]|0)!=80?(k=c[e>>2]|0,(k|0)!=7):0){if(!((k|0)==17&(b&1|0)==0|(k|0)==47)){i=f;return}vg(a,d);i=f;return}Lg(a,d);i=f;return}}while(0)}function zg(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;h=c[a+176>>2]|0;if(!e){i=f;return}g=e+44|0;do switch(c[g>>2]|0){case 13:{Fg(a,d,e);i=f;return};case 9:{Hg(a,d,e);i=f;return};case 0:{e=c[e+12>>2]|0;if(!e){i=f;return}do{zg(a,b,d,e);e=c[e+8>>2]|0}while((e|0)!=0);i=f;return};case 12:{Kg(a,d,e);i=f;return};case 2:{Lg(a,d);Cg(a,d,e);i=f;return};case 4:{Bg(a,b,d,e);i=f;return};case 8:{Gg(a,d,e);i=f;return};case 1:{Dg(a,d,e);i=f;return};case 10:{Ig(a,d,e);i=f;return};case 11:{Jg(a,d,e);i=f;return};case 3:{Eg(a,d,e);i=f;return};default:{if((Ve(e,1)|0)==0?(c[g>>2]|0)!=7|(h|0)!=0:0){h=c[a+76>>2]|0;g=e+12|0;j=c[g>>2]|0;a:do if(!j)j=0;else while(1){if(Te(j)|0){j=1;break a}j=c[j+8>>2]|0;if(!j){j=0;break}}while(0);Lg(a,d);if(!(qe(a,e)|0)){k=(j|0)==0;j=(k?h:0)+d|0;Mg(a,b,d,e);if(k)k=24;else{h=1;k=26}}else{Mg(a,b,0,e);d=0;j=0;k=24}if((k|0)==24?(c[g>>2]|0)!=0:0){vg(a,j);h=0;k=26}if((k|0)==26){k=c[g>>2]|0;if(k)do{zg(a,b,j,k);k=c[k+8>>2]|0}while((k|0)!=0);if(!h?(c[g>>2]|0)!=0:0)Lg(a,d)}Ng(a,e);i=f;return}Lg(a,d);Mg(a,b,d,e);i=f;return}}while(0)}function Ag(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;d=i;b=a+2612|0;g=a+2636|0;j=c[g>>2]|0;e=a+2624|0;if((((j|0)<0?0:j)+(c[e>>2]|0)|0)>>>0>=(c[a+80>>2]|0)>>>0)Sg(a);if((Tg(a)|0)!=0?(f=c[g>>2]|0,f=(f|0)<0?0:f,(f|0)!=0):0){h=a+2664|0;g=0;do{hk(32,c[h>>2]|0);g=g+1|0}while(g>>>0<f>>>0)}if(!(c[e>>2]|0))g=0;else{j=a+2616|0;h=a+2664|0;f=0;do{hk(c[(c[j>>2]|0)+(f<<2)>>2]|0,c[h>>2]|0);f=f+1|0;g=c[e>>2]|0}while(f>>>0<g>>>0)}j=c[a+2644>>2]|0;if(!((j|0)>-1&(j|0)<(g|0))){Ug(b);c[e>>2]=0;i=d;return}hk(92,c[a+2664>>2]|0);Ug(b);c[e>>2]=0;i=d;return}function Bg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;j=i;i=i+16|0;h=j;l=c[f+36>>2]|0;n=c[f+40>>2]|0;c[h>>2]=0;k=b+68|0;g=Qg(c[k>>2]|0,f,d)|0;m=Vg(c[k>>2]|0,f,l,d)|0;g=n-((g|0)>0?g:0)|0;if((m|0)>0){l=(m>>>0<e>>>0?m:e)+l|0;l=l>>>0<g>>>0?l:g}if(l>>>0>=g>>>0){i=j;return}do{Wg(b,e);m=(c[(c[k>>2]|0)+84>>2]|0)+l|0;o=a[m>>0]|0;n=o&255;c[h>>2]=n;if(o<<24>>24<0){l=(Hk(m,h)|0)+l|0;n=c[h>>2]|0}if((n|0)==10){vg(b,e);m=Vg(c[k>>2]|0,f,l+1|0,d)|0;if((m|0)>0){l=(m>>>0<e>>>0?m:e)+l|0;l=l>>>0<g>>>0?l:g}}else Xg(b,n,d);l=l+1|0}while(l>>>0<g>>>0);i=j;return}function Cg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=a+2612|0;Yg(a,b)|0;Pg(f,27984);Bg(a,2,0,d);Pg(f,27992);Zg(f,62);if(!(c[d+64>>2]|0)){i=e;return}if(!(c[d+8>>2]|0)){i=e;return}vg(a,b);i=e;return}function Dg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;e=a+2612|0;j=c[a+80>>2]|0;k=c[a+76>>2]|0;p=Lc(d,27920)|0;g=Lc(d,27928)|0;Yg(a,b)|0;Lg(a,b);Pg(e,27936);Yg(a,b)|0;o=c[d+32>>2]|0;if(o)Pg(e,o);if((((p|0)!=0?(n=p+24|0,(c[n>>2]|0)!=0):0)?(Pg(e,27952),p=p+16|0,Zg(e,c[p>>2]|0),Pg(e,c[n>>2]|0),Zg(e,c[p>>2]|0),(c[n>>2]|0)!=0&(g|0)!=0):0)?(l=g+24|0,m=c[l>>2]|0,(m|0)!=0):0){n=a+2624|0;o=c[n>>2]|0;p=qk(m)|0;o=o+ -3|0;m=o-p|0;if(!(((o|0)!=(p|0)?(m+2+(qk(c[l>>2]|0)|0)|0)>>>0<j>>>0:0)?m>>>0<=((k|0)!=0?k<<1:4)>>>0:0))m=0;Lg(a,m);if(!(c[n>>2]|0))j=16;else{Zg(e,32);j=16}}else j=13;if((j|0)==13?(g|0)!=0:0)if(!(c[g+24>>2]|0))j=16;else{Pg(e,27968);j=16}if((j|0)==16?(h=g+24|0,(c[h>>2]|0)!=0):0){p=g+16|0;Zg(e,c[p>>2]|0);Pg(e,c[h>>2]|0);Zg(e,c[p>>2]|0)}g=d+12|0;if(!(c[g>>2]|0)){Yg(a,0)|0;Zg(e,62);Lg(a,b);i=f;return}Lg(a,b);Zg(e,91);Bg(a,16,0,c[g>>2]|0);Zg(e,93);Yg(a,0)|0;Zg(e,62);Lg(a,b);i=f;return}function Eg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;g=f;h=b+2612|0;Yg(b,d)|0;Pg(h,27832);j=c[e+32>>2]|0;a:do if(j)while(1){k=a[j>>0]|0;if(!(k<<24>>24))break a;l=k&255;c[g>>2]=l;if(k<<24>>24<0){j=j+(Hk(j,g)|0)|0;l=c[g>>2]|0}Zg(h,l);j=j+1|0}while(0);Bg(b,16,d,e);if(((c[b+172>>2]|0)==0?(c[b+176>>2]|0)==0:0)?(c[e+56>>2]|0)==0:0){Zg(h,62);Lg(b,d);i=f;return}Zg(h,63);Zg(h,62);Lg(b,d);i=f;return}function Fg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;h=i;f=b+2612|0;Yg(b,d)|0;g=Og(b)|0;j=c[b+192>>2]|0;Li(b,30,0)|0;Pg(f,27896);k=Jc(e,148)|0;if(k)_g(b,d,e,k);k=Jc(e,47)|0;if(k)_g(b,d,e,k);k=Lc(e,27904)|0;if(k)_g(b,d,e,k);Li(b,30,j)|0;k=c[e+40>>2]|0;if((k|0)!=0?(a[(c[(c[b+68>>2]|0)+84>>2]|0)+(k+ -1)>>0]|0)==63:0){Zg(f,62);Ki(b,2,g)|0;vg(b,d);i=h;return}Zg(f,63);Zg(f,62);Ki(b,2,g)|0;vg(b,d);i=h;return}function Gg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=a+2612|0;f=(c[a+344>>2]|0)==0?0:b;Lg(a,f);b=Og(a)|0;Pg(g,25680);Bg(a,2,f,d);Pg(g,25672);Lg(a,f);Ki(a,2,b)|0;i=e;return}function Hg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;g=a+2612|0;h=(c[a+264>>2]|0)!=0;f=$g(a,h&1^1)|0;Pg(g,27880);Bg(a,h?16:2,b,d);Pg(g,27888);Ki(a,2,f)|0;i=e;return}function Ig(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;f=a+2612|0;g=(c[a+268>>2]|0)!=0;if(g)h=(c[a+272>>2]|0)==0;else h=1;h=$g(a,h&1)|0;Pg(f,27864);Bg(a,g?16:2,b,d);Pg(f,27872);Ki(a,2,h)|0;i=e;return}function Jg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=a+2612|0;f=$g(a,(c[a+268>>2]|0)==0&1)|0;Pg(g,27848);Bg(a,(c[a+272>>2]|0)!=0?16:2,b,d);Pg(g,27856);Ki(a,2,f)|0;i=e;return}function Kg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;g=a+2612|0;h=(c[a+276>>2]|0)!=0;f=$g(a,h&1^1)|0;Pg(g,27832);Bg(a,h?16:2,b,d);Pg(g,27840);Ki(a,2,f)|0;i=e;return}function Lg(a,b){a=a|0;b=b|0;var d=0;d=i;if(!(c[a+2624>>2]|0)){i=d;return}Ag(a);hk(10,c[a+2664>>2]|0);c[a+2636>>2]=b;i=d;return}function Mg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;g=i;i=i+16|0;o=g;m=b+2612|0;p=c[b+188>>2]|0;j=c[b+176>>2]|0;n=b+172|0;k=c[n>>2]|0;q=c[f+32>>2]|0;Zg(m,60);l=f+44|0;if((c[l>>2]|0)==6)Zg(m,47);if((q|0)!=0?(r=a[q>>0]|0,r<<24>>24!=0):0){p=(p|0)==0;do{s=r&255;c[o>>2]=s;if(r<<24>>24>=0)if(p)r=s;else{r=wf(s)|0;c[o>>2]=r}else{q=q+(Hk(q,o)|0)|0;r=c[o>>2]|0}Zg(m,r);q=q+1|0;r=a[q>>0]|0}while(r<<24>>24!=0)}if((((c[n>>2]|0)!=0?(c[b+292>>2]|0)!=0:0)?(Lc(f,25744)|0)==0:0)?(qe(b,f)|0)!=0:0)Nc(b,f,25744,25760)|0;n=c[f+20>>2]|0;if(n)do{do if(!(c[n+20>>2]|0)){o=n+8|0;if(c[o>>2]|0){Zg(m,32);Ig(b,e,c[o>>2]|0);break}o=n+12|0;if(c[o>>2]|0){Zg(m,32);Kg(b,e,c[o>>2]|0)}}else _g(b,e,f,n);while(0);n=c[n>>2]|0}while((n|0)!=0);n=(j|0)!=0;do if(k|j){if((c[l>>2]|0)!=7?(Xe(f)|0)==0:0)break;Zg(m,32);Zg(m,47)}while(0);Zg(m,62);if(!(((c[l>>2]|0)!=7|n)&(d&1|0)==0)){i=g;return}s=c[b+80>>2]|0;Wg(b,e);j=b+2624|0;d=(d&8|0)!=0;if(((c[j>>2]|0)+e|0)>>>0>=s>>>0){do if(!d){if(((f|0)!=0?(h=c[f+28>>2]|0,(h|0)!=0):0)?(c[h>>2]|0)==17:0)break;if(!(ah(c[b+68>>2]|0,f)|0)){i=g;return}}while(0);Lg(b,e);i=g;return}if(d){i=g;return}if(We(f)|0){if(!f){i=g;return}e=c[f+28>>2]|0;if(!e){i=g;return}if((c[e>>2]|0)!=17){i=g;return}}if(!(ah(c[b+68>>2]|0,f)|0)){i=g;return}c[b+2628>>2]=c[j>>2];i=g;return}function Ng(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;g=i;i=i+16|0;f=g;e=b+2612|0;b=c[b+188>>2]|0;d=c[d+32>>2]|0;Pg(e,25736);if(!d){Zg(e,62);i=g;return}h=a[d>>0]|0;if(!(h<<24>>24)){Zg(e,62);i=g;return}b=(b|0)==0;do{j=h&255;c[f>>2]=j;if(h<<24>>24>=0){if(!b){j=wf(j)|0;c[f>>2]=j}}else{d=d+(Hk(d,f)|0)|0;j=c[f>>2]|0}Zg(e,j);d=d+1|0;h=a[d>>0]|0}while(h<<24>>24!=0);Zg(e,62);i=g;return}function Og(a){a=a|0;var b=0,d=0;d=i;b=c[a+80>>2]|0;Ki(a,2,-1)|0;i=d;return b|0}function Pg(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;g=i;f=b+12|0;h=c[f>>2]|0;j=qk(d)|0;e=j+h|0;if(e>>>0>=(c[b+8>>2]|0)>>>0)bh(b,e);if(!j){c[f>>2]=e;i=g;return}b=c[b+4>>2]|0;k=0;do{c[b+(k+h<<2)>>2]=a[d+k>>0];k=k+1|0}while((k|0)!=(j|0));c[f>>2]=e;i=g;return}function Qg(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;if(!(e&18)){g=-1;i=f;return g|0}if(!(Te(d)|0)){g=-1;i=f;return g|0}e=c[d+40>>2]|0;d=c[d+36>>2]|0;if(e>>>0<=d>>>0){g=-1;i=f;return g|0}g=e+ -1|0;b=c[b+84>>2]|0;a:do if(g>>>0>=d>>>0)do{h=a[b+g>>0]|0;if(!(h<<24>>24==9|h<<24>>24==32|h<<24>>24==13))break a;g=g+ -1|0}while(g>>>0>=d>>>0);while(0);if((a[b+g>>0]|0)!=10){h=-1;i=f;return h|0}h=e+~g|0;i=f;return h|0}function Rg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;j=c[a+152>>2]|0;a:do if(j){a=(b|0)!=0;if((a?(h=c[b+28>>2]|0,(h|0)!=0):0)?(c[h>>2]|0)==107:0){b=0;break}do if((j|0)==2){h=b+12|0;if((c[h>>2]|0)!=0?(Ve(b,262144)|0)!=0:0){b=c[h>>2]|0;if(!b){b=0;break a}while(1){if(Ve(b,8)|0){b=1;break a}b=c[b+8>>2]|0;if(!b){b=0;break a}}}if(Ve(b,16384)|0){b=0;break a}if(a?(g=c[b+28>>2]|0,(g|0)!=0):0){g=c[g>>2]|0;if((g|0)==111|(g|0)==79|(g|0)==48){b=0;break a}else if((g|0)!=30)break;g=c[b+16>>2]|0;if(((g|0)!=0?(e=c[g+28>>2]|0,(e|0)!=0):0)?(c[e>>2]|0)==52:0){b=0;break a}}}while(0);if(!(Ve(b,3072)|0)){if((a?(f=c[b+28>>2]|0,(f|0)!=0):0)?(c[f>>2]|0)==64:0){b=1;break}if(!(Ve(b,16)|0))b=(c[b+12>>2]|0)!=0;else b=0;b=b&1}else b=1}else b=0;while(0);i=d;return b|0}function Sg(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;d=i;b=a+2612|0;e=a+2628|0;if(!(c[e>>2]|0)){i=d;return}if((Tg(a)|0)!=0?(g=c[a+2636>>2]|0,g=(g|0)<0?0:g,(g|0)!=0):0){h=a+2664|0;j=0;do{hk(32,c[h>>2]|0);j=j+1|0}while(j>>>0<g>>>0);if(c[e>>2]|0)f=6}else f=6;if((f|0)==6){f=a+2616|0;g=a+2664|0;h=0;do{hk(c[(c[f>>2]|0)+(h<<2)>>2]|0,c[g>>2]|0);h=h+1|0}while(h>>>0<(c[e>>2]|0)>>>0)}a=a+2664|0;if(ch(b)|0)hk(92,c[a>>2]|0);hk(10,c[a>>2]|0);dh(b);i=d;return}function Tg(a){a=a|0;var b=0,d=0,e=0;b=i;e=a+2612|0;d=(c[a+2636>>2]|0)>0;if(!d){e=d&1;i=b;return e|0}d=c[a+284>>2]|0;if((eh(e)|0)==0|(d|0)!=0)a=(ch(e)|0)==0;else a=0;e=a&1;i=b;return e|0}function Ug(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;d=i;b=a+20|0;if(c[b>>2]|0){g=a+24|0;h=a+36|0;c[g+0>>2]=c[h+0>>2];c[g+4>>2]=c[h+4>>2];c[g+8>>2]=c[h+8>>2];c[h>>2]=-1;c[a+40>>2]=-1;c[a+44>>2]=-1}e=a+16|0;f=c[e>>2]|0;g=a+32|0;h=c[g>>2]|0;if(!f){if((h|0)>0)c[g>>2]=0;f=a+28|0;if((c[f>>2]|0)>0)c[f>>2]=0}else{if((h|0)>(f|0))c[g>>2]=h-f;a=a+28|0;g=c[a>>2]|0;if((g|0)>(f|0))c[a>>2]=g-f}c[b>>2]=0;c[e>>2]=0;i=d;return}function Vg(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;if(!d)va(28e3,28016,1729,28040);if(!(f&18)){i=g;return-1}if(!(Te(d)|0)){i=g;return-1}f=c[d+40>>2]|0;d=c[d+36>>2]|0;if(f>>>0<=d>>>0|d>>>0>e>>>0){i=g;return-1}a:do if(f>>>0>e>>>0){b=c[b+84>>2]|0;d=e;do{h=a[b+d>>0]|0;if(!(h<<24>>24==9|h<<24>>24==32|h<<24>>24==13))break a;d=d+1|0}while(d>>>0<f>>>0)}else d=e;while(0);i=g;return(d>>>0>e>>>0?d-e|0:-1)|0}function Wg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=a+2636|0;f=c[e>>2]|0;if((((f|0)<0?0:f)+(c[a+2624>>2]|0)|0)>>>0<(c[a+80>>2]|0)>>>0){i=d;return}Sg(a);if((c[e>>2]|0)>=0){i=d;return}c[e>>2]=b;i=d;return}function Xg(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;i=i+144|0;g=e;h=e+8|0;f=a+2612|0;l=c[a+96>>2]|0;n=c[a+244>>2]|0;do if((b|0)==32&(d&23|0)==0){if(!(d&8)){c[a+2628>>2]=c[a+2624>>2];break}if((c[a+240>>2]|0)==0?(c[a+168>>2]|0)==0:0)b=25800;else b=25808;Pg(f,b);i=e;return}while(0);if(d&18){Zg(f,b);i=e;return}do if(!(d&16)){if((b|0)==62){Pg(f,25824);i=e;return}else if((b|0)==60){Pg(f,25816);i=e;return}else if((b|0)==38){if(!(c[a+252>>2]|0))break;if(!(c[a+432>>2]|0)){Pg(f,25832);i=e;return}}n=(n|0)!=0;if((b|0)==34&n){Pg(f,25784);i=e;return}if((b|0)==39&n){Pg(f,25792);i=e;return}if((b|0)==160&(l|0)!=0){if(!(c[a+248>>2]|0)){Zg(f,160);i=e;return}if((c[a+240>>2]|0)==0?(c[a+168>>2]|0)==0:0){Pg(f,25800);i=e;return}Pg(f,25808);i=e;return}}while(0);a:do switch(l|0){case 3:{m=43;break};case 12:{Zg(f,b);if(d&1){i=e;return}if(!((c[a+416>>2]|0)!=0&(b&65280|0)==41216)){i=e;return}f=c[a+2624>>2]|0;if((b+ -41309|0)>>>0>79|(b&1|0)==0){c[a+2628>>2]=f+1;i=e;return}else{c[a+2628>>2]=f;i=e;return}};case 10:case 9:case 11:case 4:{b:do if((d&1|0)==0?!((c[a+416>>2]|0)==0|b>>>0<8192):0){n=8192;d=0;while(1){o=d+1|0;if((n|0)==(b|0))break;n=c[25856+(o<<3)>>2]|0;if((o|0)==246|n>>>0>b>>>0)break b;else d=o}n=c[a+2624>>2]|0;if((c[25860+(d<<3)>>2]&-2|0)==4){c[a+2628>>2]=n;break}else{c[a+2628>>2]=n+1;break}}while(0);switch(l|0){case 3:{m=43;break a};case 4:{Zg(f,b);i=e;return};case 9:case 10:case 11:{Zg(f,b);i=e;return};default:break a}};case 0:case 5:case 13:{Zg(f,b);i=e;return};default:{}}while(0);if((m|0)==43){if(b>>>0<=255)if((b+ -127|0)>>>0<33){c[g>>2]=b;Ek(h,128,25848,g)|0;Pg(f,h);i=e;return}else{Zg(f,b);i=e;return}j=kf(a)|0;if((c[a+240>>2]|0)==0?(k=Fl(b,j)|0,(k|0)!=0):0){c[g>>2]=k;Ek(h,128,25840,g)|0}else{c[g>>2]=b;Ek(h,128,25848,g)|0}Pg(f,h);i=e;return}if(c[a+168>>2]|0)if(b>>>0>127&(l|0)==1){c[g>>2]=b;Ek(h,128,25848,g)|0;Pg(f,h);i=e;return}else{Zg(f,b);i=e;return}do if((l|0)==1){if(b>>>0<=126?!(b>>>0<32&(b|0)!=9):0)break;k=kf(a)|0;if((c[a+240>>2]|0)==0?(j=Fl(b,k)|0,(j|0)!=0):0){c[g>>2]=j;Ek(h,128,25840,g)|0}else{c[g>>2]=b;Ek(h,128,25848,g)|0}Pg(f,h);i=e;return}while(0);Zg(f,b);i=e;return}function Yg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=i;f=c[a+2624>>2]|0;g=(f+b|0)>>>0<(c[a+80>>2]|0)>>>0;d=g&1;if(g){g=a+2636|0;if((c[g>>2]|0)<0)c[g>>2]=b;c[a+2628>>2]=f;i=e;return d|0}else{f=a+2632|0;if(c[f>>2]|0){i=e;return d|0}c[a+2648>>2]=b;c[f>>2]=1;i=e;return d|0}return 0}function Zg(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=a+12|0;f=c[e>>2]|0;g=f+1|0;if(g>>>0>=(c[a+8>>2]|0)>>>0)bh(a,g);c[(c[a+4>>2]|0)+(f<<2)>>2]=b;c[e>>2]=(c[e>>2]|0)+1;i=d;return}function _g(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;g=i;i=i+16|0;j=g;h=b+2612|0;s=c[b+172>>2]|0;t=c[b+176>>2]|0;p=c[b+256>>2]|0;m=c[b+192>>2]|0;l=c[b+284>>2]|0;v=c[b+76>>2]|0;k=e+32|0;do if(c[k>>2]|0){if((Ve(e,16)|0)!=0?(u=c[e>>2]|0,(Rg(b,(u|0)==0?e:u)|0)!=0):0){k=Mf(e)|0;if(!k)break;v=(qk(c[k+32>>2]|0)|0)+2|0;break}v=(qk(c[k>>2]|0)|0)+2|0}while(0);u=(c[e+20>>2]|0)==(f|0);k=f+20|0;o=c[k>>2]|0;l=(l|0)!=0;v=l?v:0;if(l?!((Ue(e)|0)==0|u):0){d=v+d|0;Lg(b,d)}Wg(b,d);l=(s|0)==0;do if((t|s|0)==0?(q=f+4|0,(c[q>>2]|0)!=0):0){if(Rc(b,o)|0){p=c[b+260>>2]|0;break}if((f|0)!=0?(r=c[q>>2]|0,(r|0)!=0):0){q=c[r>>2]|0;if((q|0)==9|(q|0)==146|(q|0)==35){p=0;break}if(!((q|0)!=141&(p|0)!=0)){p=0;break}}else n=18;if((n|0)==18?(p|0)==0:0){p=0;break}p=1}else p=0;while(0);if(!u?(Yg(b,d)|0)==0:0)vg(b,d+v|0);else n=23;if((n|0)==23?(c[b+2624>>2]|0)!=0:0)Zg(h,32);n=a[o>>0]|0;if(n<<24>>24){m=(m|0)==0;do{q=n&255;c[j>>2]=q;if(n<<24>>24>=0){if(!m){q=wf(q)|0;c[j>>2]=q}}else{o=o+(Hk(o,j)|0)|0;q=c[j>>2]|0}Zg(h,q);o=o+1|0;n=a[o>>0]|0}while(n<<24>>24!=0)}Wg(b,d);h=c[f+24>>2]|0;if(h){fh(b,d,h,c[f+16>>2]|0,p,0);i=g;return}j=$c(f)|0;h=ad(f)|0;j=(j|0)==0;if(!l){if(j)e=25696;else e=c[k>>2]|0;fh(b,d,e,c[f+16>>2]|0,0,h);i=g;return}if(j?(Ld(e)|0)==0:0){fh(b,d,25696,c[f+16>>2]|0,1,h);i=g;return}Yg(b,d)|0;i=g;return}function $g(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b)a=c[a+80>>2]|0;else a=Og(a)|0;i=d;return a|0}function ah(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=Xe(b)|0;a:do if(!(We(b)|0))a=1;else{e=(e|0)==0;while(1){f=c[b+4>>2]|0;if(f)break;if(!e?(We(c[b>>2]|0)|0)==0:0){a=0;break a}b=c[b>>2]|0;if(!(We(b)|0)){a=1;break a}}if(Te(f)|0){a=wg(a,f)|0;break}f=c[f+28>>2]|0;if((f|0)!=0?(c[f>>2]|0)==17:0){a=1;break}a=0}while(0);i=d;return a|0}function bh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=a+8|0;f=c[e>>2]|0;f=(f|0)==0?256:f;while(1)if(f>>>0>b>>>0)break;else f=f<<1;g=c[a>>2]|0;b=a+4|0;a=mb[c[(c[g>>2]|0)+4>>2]&3](g,c[b>>2]|0,f<<2)|0;if(!a){i=d;return}g=c[e>>2]|0;Dm(a+(g<<2)|0,0,f-g<<2|0)|0;c[e>>2]=f;c[b>>2]=a;i=d;return}function ch(a){a=a|0;var b=0,d=0;b=i;d=c[a+32>>2]|0;if(!d){d=1;d=d&1;i=b;return d|0}d=(d|0)>0?(d|0)<(c[a+16>>2]|0):0;d=d&1;i=b;return d|0}function dh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0;b=i;d=a+12|0;h=c[d>>2]|0;e=a+16|0;j=c[e>>2]|0;if(h>>>0<=j>>>0){k=0;c[d>>2]=k;Ug(a);i=b;return}g=c[a+4>>2]|0;k=g+(j<<2)|0;f=g+(h<<2)|0;a:do if((eh(a)|0)==0&(j|0)<(h|0))do{if((c[k>>2]|0)!=32)break a;k=k+4|0;j=j+1|0;c[e>>2]=j}while(k>>>0<f>>>0);while(0);if(k>>>0<f>>>0){while(1){c[g>>2]=c[k>>2];k=k+4|0;if(k>>>0>=f>>>0)break;else g=g+4|0}h=c[d>>2]|0;j=c[e>>2]|0}k=h-j|0;c[d>>2]=k;Ug(a);i=b;return}function eh(a){a=a|0;var b=0,d=0;b=i;d=c[a+28>>2]|0;if(!d){d=1;d=d&1;i=b;return d|0}d=(d|0)>0?(d|0)<(c[a+16>>2]|0):0;d=d&1;i=b;return d|0}function fh(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=0,J=0,K=0;j=i;i=i+16|0;k=j;n=b+2612|0;F=c[b+260>>2]|0;g=(g|0)!=0;o=g?4:5;p=(e|0)!=0;do if(p?(a[e>>0]|0)==60:0){K=a[e+1>>0]|0;if(!(K<<24>>24==64|K<<24>>24==37)?(xk(e,25776,5)|0)!=0:0)break;o=o|16}while(0);f=(f|0)==0?34:f;Zg(n,61);if(!((c[b+172>>2]|0)!=0?(c[b+176>>2]|0)==0:0)){Yg(b,d)|0;Wg(b,d)}Zg(n,f);if(!p){Zg(n,f);i=j;return}A=b+80|0;y=c[A>>2]|0;w=b+2632|0;x=b+2624|0;z=c[x>>2]|0;c[b+((c[w>>2]|0)*12|0)+2640>>2]=z;c[b+((c[w>>2]|0)*12|0)+2644>>2]=-1;J=a[e>>0]|0;a:do if(J<<24>>24){t=b+2636|0;B=b+2628|0;p=b+2648|0;q=b+2644|0;u=b+2656|0;r=b+2640|0;s=b+2652|0;D=b+2664|0;E=b+2616|0;C=b+324|0;v=b+244|0;G=(h|0)!=0;F=(F|0)!=0;h=(f|0)==39&G&F;F=(f|0)==34&G&F;G=-1;do{H=(G|0)<0;b:while(1){I=J<<24>>24;c[k>>2]=I;if(g&J<<24>>24==32){J=c[x>>2]|0;if((J+d|0)>>>0>=(c[A>>2]|0)>>>0){J=c[w>>2]|0;if(!J){c[p>>2]=d;c[w>>2]=1;J=c[B>>2]|0;K=c[q>>2]|0;if((K|0)>(J|0)){c[u>>2]=K-J;c[q>>2]=-1}K=c[r>>2]|0;if((K|0)>(J|0)){c[s>>2]=K-J;c[r>>2]=-1;J=1}else J=1}}else{if((c[t>>2]|0)<0)c[t>>2]=d;c[B>>2]=J;J=c[w>>2]|0}c[b+(J*12|0)+2640>>2]=z;c[b+(J*12|0)+2644>>2]=G}if((g?(m=c[B>>2]|0,(m|0)!=0):0)?(l=c[t>>2]|0,l=(l|0)<0?0:l,(l+(c[x>>2]|0)|0)>>>0>=y>>>0):0){if((Tg(b)|0)==0|(l|0)==0)I=m;else{I=0;do{hk(32,c[D>>2]|0);I=I+1|0}while(I>>>0<l>>>0);I=c[B>>2]|0}if(I){I=0;do{hk(c[(c[E>>2]|0)+(I<<2)>>2]|0,c[D>>2]|0);I=I+1|0}while(I>>>0<(c[B>>2]|0)>>>0)}K=(ch(n)|0)==0;I=c[D>>2]|0;if(K)hk(32,I);else hk(92,I);hk(10,c[D>>2]|0);dh(n);I=c[k>>2]|0}J=(I|0)==34;do if((I|0)==(f|0)){Pg(n,J?25784:25792);e=e+1|0}else{if(J){H=40;break b}if((I|0)==39){H=47;break b}if(I>>>0>127){e=e+(Hk(e,k)|0)|0;I=c[k>>2]|0}e=e+1|0;if((I|0)!=10){Xg(b,I,o);break}if(H)I=(c[C>>2]|0)!=0?0:d;else I=0;vg(b,I)}while(0);J=a[e>>0]|0;if(!(J<<24>>24))break a}if((H|0)==40){if(!(c[v>>2]|0))Zg(n,34);else Pg(n,25784);if(h)G=gh(n)|0}else if((H|0)==47){if(!(c[v>>2]|0))Zg(n,39);else Pg(n,25792);if(F)G=gh(n)|0}e=e+1|0;J=a[e>>0]|0}while(J<<24>>24!=0)}while(0);c[b+((c[w>>2]|0)*12|0)+2640>>2]=-1;c[b+((c[w>>2]|0)*12|0)+2644>>2]=-1;Zg(n,f);i=j;return}function gh(a){a=a|0;var b=0;b=a+((c[a+20>>2]|0)*12|0)+32|0;if((c[b>>2]|0)>-1)a=-1;else a=c[a+12>>2]|0;c[b>>2]=a;return a|0}function hh(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;d=c[a+68>>2]|0;if(!d){i=b;return}d=c[d+120>>2]|0;if(!d){i=b;return}a=a+2724|0;do{e=d;d=c[d+12>>2]|0;f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[e>>2]|0);f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[e+4>>2]|0);f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[e+8>>2]|0);f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,e)}while((d|0)!=0);i=b;return}function ih(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;d=Eh(a,c[b+32>>2]|0,d)|0;f=Jc(b,25)|0;if(!f){Nc(a,b,28648,d)|0;i=e;return}else{Yc(a,f,d);i=e;return}}function jh(a){a=a|0;var b=0,d=0;b=i;d=c[a+4>>2]|0;if(!d)c[(c[a>>2]|0)+12>>2]=a;else c[d+8>>2]=a;d=c[a+8>>2]|0;if(!d)c[(c[a>>2]|0)+16>>2]=a;else c[d+4>>2]=a;d=c[a+12>>2]|0;if(!d){i=b;return}do{c[d>>2]=a;d=c[d+8>>2]|0}while((d|0)!=0);i=b;return}function kh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=Jc(b,136)|0;if(!f){eg(b,cg(a,28072,d,34)|0);i=e;return}b=f+24|0;f=c[b>>2]|0;if(!f){c[b>>2]=pk(c[a+2724>>2]|0,d)|0;i=e;return}else{f=Fh(a,f,d)|0;d=c[a+2724>>2]|0;ob[c[(c[d>>2]|0)+8>>2]&15](d,c[b>>2]|0);c[b>>2]=f;i=e;return}}function lh(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;b=i;Gh(a,a)|0;if(!(c[a+200>>2]|0)){i=b;return}Hh(a,a);j=a+68|0;d=c[j>>2]|0;g=d+120|0;if(!(c[g>>2]|0)){e=Rf(a)|0;if(!e){i=b;return}if((((((Jc(e,12)|0)==0?(Jc(e,13)|0)==0:0)?(Jc(e,140)|0)==0:0)?(Jc(e,71)|0)==0:0)?(Jc(e,149)|0)==0:0)?(Jc(e,8)|0)==0:0){i=b;return}q=a+2712|0;c[q>>2]=c[q>>2]|16}k=a+2724|0;e=Bf(c[k>>2]|0,d)|0;c[e+44>>2]=5;c[e+60>>2]=1;c[e+32>>2]=pk(c[k>>2]|0,28072)|0;Je(a,e)|0;eg(e,cg(a,28456,28464,34)|0);h=Rf(a)|0;f=d+92|0;c[d+48>>2]=c[f>>2];if(h){j=c[j>>2]|0;l=Jc(h,12)|0;if(!l)l=0;else{p=l+24|0;q=c[p>>2]|0;c[p>>2]=0;Gf(a,h,l);l=q}m=Jc(h,13)|0;if(!m)m=0;else{p=m+24|0;q=c[p>>2]|0;c[p>>2]=0;Gf(a,h,m);m=q}n=Jc(h,140)|0;if(!n)o=0;else{q=n+24|0;o=c[q>>2]|0;c[q>>2]=0;Gf(a,h,n)}q=(l|0)!=0;p=(m|0)!=0;n=(o|0)!=0;if(q|p|n){Kf(j,28480);if(q){Kf(j,28496);Kf(j,l);Kf(j,28528);q=c[k>>2]|0;ob[c[(c[q>>2]|0)+8>>2]&15](q,l)}if(p){Kf(j,28536);Kf(j,m);Kf(j,28560);q=c[k>>2]|0;ob[c[(c[q>>2]|0)+8>>2]&15](q,m)}if(n){Kf(j,28568);Kf(j,o);Kf(j,28560);q=c[k>>2]|0;ob[c[(c[q>>2]|0)+8>>2]&15](q,o)}Kf(j,28584)}k=Jc(h,71)|0;if(k){Ih(j,28592,c[k+24>>2]|0);Gf(a,h,k)}k=Jc(h,149)|0;if(k){Ih(j,28600,c[k+24>>2]|0);Gf(a,h,k)}k=Jc(h,8)|0;if(k){Ih(j,28616,c[k+24>>2]|0);Gf(a,h,k)}}g=c[g>>2]|0;if(g)do{Af(d,32);Kf(d,c[g>>2]|0);Af(d,46);Kf(d,c[g+4>>2]|0);Af(d,32);Af(d,123);Kf(d,c[g+8>>2]|0);Af(d,125);Af(d,10);g=c[g+12>>2]|0}while((g|0)!=0);c[d+52>>2]=c[f>>2];Qd(e,Hf(d)|0);a=Pf(a)|0;if(!a){i=b;return}Qd(a,e);i=b;return}function mh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;i=i+16|0;e=d;if(!b){i=d;return}while(1){g=c[b+8>>2]|0;c[e>>2]=g;h=c[b+28>>2]|0;if((((h|0)!=0?(j=c[h>>2]|0,(j|0)==49|(j|0)==8):0)?(f=c[b>>2]|0,(f|0)!=0):0)?(c[f+28>>2]|0)==(h|0):0){Jh(a,b,e);g=c[e>>2]|0}else{b=c[b+12>>2]|0;if(b)mh(a,b)}if(!g)break;else b=g}i=d;return}function nh(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if(!b){i=d;return}do{e=c[b+28>>2]|0;do if(e){e=c[e>>2]|0;if((e|0)==8){Kh(a,b,100);break}else if((e|0)==49){Kh(a,b,33);break}else break}while(0);e=c[b+12>>2]|0;if(e)nh(a,e);b=c[b+8>>2]|0}while((b|0)!=0);i=d;return}function oh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if(!b){i=d;return}do{e=b+12|0;f=c[e>>2]|0;if(f)oh(a,f);f=c[b+28>>2]|0;if((((f|0)!=0?(c[f+20>>2]|0)==27:0)?(Lh(b)|0)!=0:0)?(c[(c[e>>2]|0)+60>>2]|0)!=0:0){Mh(a,b);Kh(a,b,15);c[b+60>>2]=1}b=c[b+8>>2]|0}while((b|0)!=0);i=d;return}function ph(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;j=i;i=i+48|0;d=j;e=j+8|0;if(!b){i=j;return}do{m=c[b+28>>2]|0;if(((m|0)!=0?(c[m>>2]|0)==15:0)?(h=b+60|0,(c[h>>2]|0)!=0):0){k=b+12|0;a:do if(!(Lh(b)|0)){l=1;g=12}else{l=1;while(1){m=c[k>>2]|0;if(!m)break a;m=c[m+28>>2]|0;if(!m){g=12;break a}if((c[m>>2]|0)!=15){g=12;break a}if(!(c[h>>2]|0)){g=12;break a}l=l+1|0;Mh(a,b);if(!(Lh(b)|0)){g=12;break}}}while(0);if((g|0)==12){g=0;k=c[k>>2]|0;if(k)ph(a,k)}c[d>>2]=l<<1;Ek(e,32,28080,d)|0;Kh(a,b,30);kh(a,b,e)}else g=15;if((g|0)==15?(g=0,f=c[b+12>>2]|0,(f|0)!=0):0)ph(a,f);b=c[b+8>>2]|0}while((b|0)!=0);i=j;return}function qh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if(!b){i=d;return}e=(c[a+68>>2]|0)+84|0;do do if((c[b+44>>2]|0)==9){f=b+36|0;if((xk((c[e>>2]|0)+(c[f>>2]|0)|0,28104,2)|0)==0?(xk((c[e>>2]|0)+(c[f>>2]|0)|0,28112,7)|0)!=0:0){b=Nh(a,b)|0;break}b=Od(a,b)|0}else{f=c[b+12>>2]|0;if(f)qh(a,f);b=c[b+8>>2]|0}while(0);while((b|0)!=0);i=d;return}function rh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;i=i+16|0;e=g;if(!d){i=g;return}f=b+84|0;do{h=c[d+12>>2]|0;if(h)rh(b,h);if(Te(d)|0){l=c[f>>2]|0;j=c[d+36>>2]|0;k=l+j|0;h=d+40|0;if(j>>>0<(c[h>>2]|0)>>>0)do{l=l+j|0;n=a[l>>0]|0;m=n&255;c[e>>2]=m;if(n<<24>>24<0){j=(Hk(l,e)|0)+j|0;m=c[e>>2]|0}if((m|0)==160){c[e>>2]=32;m=32}k=Ik(k,m)|0;j=j+1|0;l=c[f>>2]|0}while(j>>>0<(c[h>>2]|0)>>>0);c[h>>2]=k-l}d=c[d+8>>2]|0}while((d|0)!=0);i=g;return}function sh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;u=i;i=i+16|0;v=u+4|0;f=u;n=c[b+68>>2]|0;if(!d){i=u;return}s=n+84|0;t=b+196|0;w=0;a:while(1){b:while(1){x=d+28|0;y=c[x>>2]|0;c:do if(y){if((c[y>>2]|0)==48){if((Lc(d,28120)|0)==0?(c[t>>2]|0)==0:0){o=84;break a}Df(b,d);y=c[x>>2]|0;if(!y)break}if((c[y>>2]|0)==79?(Oh(d)|0)!=0:0){Md(b,d,82,0,1);Ph(b,d);x=c[d+12>>2]|0;if(x)sh(b,x);x=c[d+8>>2]|0;if(!x){o=84;break a}while(1){y=c[x+28>>2]|0;if(!y){d=x;break c}if((c[y>>2]|0)!=79)break;if(!(Oh(x)|0))break;y=c[x+8>>2]|0;Nd(x)|0;Qd(d,If(n)|0);Qd(d,x);Qh(b,x)|0;if(!y){o=84;break a}else x=y}if(!x){o=84;break a}else d=x}}while(0);y=d+28|0;B=c[y>>2]|0;do if(((((B|0)!=0?(c[B+16>>2]&8|0)!=0:0)?(r=c[d+12>>2]|0,(r|0)!=0):0)?(c[r+8>>2]|0)==0:0)?(c[r+44>>2]|0)==4:0){z=r+36|0;A=c[z>>2]|0;x=(c[r+40>>2]|0)-A|0;if((x|0)==1){if((a[(c[s>>2]|0)+A>>0]|0)!=32){o=29;break}}else if(!((x|0)==2?(c[v>>2]=0,Hk((c[s>>2]|0)+(c[z>>2]|0)|0,v)|0,(c[v>>2]|0)==160):0)){o=29;break}d=Qh(b,d)|0}else o=29;while(0);d:do if((o|0)==29){o=0;z=(d|0)!=0;if(!((z?(e=c[y>>2]|0,(e|0)!=0):0)?(B=c[e>>2]|0,(B|0)==67|(B|0)==101):0))o=32;if((o|0)==32?(o=0,(c[d+44>>2]|0)!=2):0){do if(z){x=c[y>>2]|0;if(x){x=c[x>>2]|0;if((x|0)==36|(x|0)==98){d=Qh(b,d)|0;break d}else if((x|0)!=62){o=42;break}x=Jc(d,117)|0;if(((x|0)!=0?(h=c[x+24>>2]|0,(h|0)!=0):0)?(wk(h,28128)|0)==0:0){d=Od(b,d)|0;break d}else o=42}}else o=42;while(0);if(((o|0)==42?(o=0,g=c[y>>2]|0,(g|0)!=0):0)?(vk(c[g+4>>2]|0,28144)|0)==0:0){Jh(b,d,f);d=c[f>>2]|0;break}x=d+12|0;if(!((c[x>>2]|0)==0&z)){o=49;break b}z=c[y>>2]|0;if(!z){w=0;break b}if((c[z>>2]|0)!=79){o=50;break b}d=Td(b,d)|0;break}d=Od(b,d)|0}while(0);if(!d){o=84;break a}}if((o|0)==49)if(z)o=50;else{o=84;break}if((o|0)==50){o=0;y=c[y>>2]|0;if(y){e:do if((c[y>>2]|0)==79){y=Jc(d,25)|0;A=Jc(d,136)|0;B=(y|0)!=0;if(B?(l=y+24|0,m=c[l>>2]|0,(m|0)!=0):0){if(wk(m,28152)|0){z=c[l>>2]|0;if(!((z|0)!=0?(wk(z,28168)|0)==0:0))o=57}}else o=57;do if((o|0)==57){o=0;if(((A|0)!=0?(q=c[A+24>>2]|0,(q|0)!=0):0)?(Ak(q,28184)|0)!=0:0)break;if(!B){w=0;break e}y=c[y+24>>2]|0;if(!y){w=0;break e}if(wk(y,28200)|0){w=0;break e}y=If(n)|0;rh(n,c[x>>2]|0);if(!(((w|0)!=0?(p=c[w+28>>2]|0,(p|0)!=0):0)?(c[p>>2]|0)==82:0)){w=Tf(b,82)|0;Rd(d,w)}Nd(d)|0;Qd(w,d);Qh(b,d)|0;Qd(w,y);d=c[w+8>>2]|0;break e}while(0);if(B?(k=c[y+24>>2]|0,(k|0)!=0):0){y=(wk(k,28168)|0)==0;y=y?76:115}else y=115;Md(b,d,61,0,1);if(!(((w|0)!=0?(j=c[w+28>>2]|0,(j|0)!=0):0)?(c[j>>2]|0)==(y|0):0)){w=Tf(b,c[(Ke(y)|0)>>2]|0)|0;Rd(d,w)}Ph(b,d);x=c[x>>2]|0;if(x)sh(b,x);Nd(d)|0;Qd(w,d);d=w}else w=0;while(0);if(!d){o=84;break}}else w=0}if(Ue(d)|0)Ph(b,d);x=c[d+12>>2]|0;if(x)sh(b,x);d=c[d+8>>2]|0;if(!d){o=84;break}}if((o|0)==84){i=u;return}}function th(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;h=Nf(a)|0;if((h|0)!=0?(Lc(h,28120)|0)!=0:0){h=1;i=b;return h|0}a=Pf(a)|0;if(!a){h=0;i=b;return h|0}a=c[a+12>>2]|0;if(!a){h=0;i=b;return h|0}while(1){h=c[a+28>>2]|0;if((((((((h|0)!=0?(c[h>>2]|0)==67:0)?(g=Jc(a,80)|0,(g|0)!=0):0)?(f=c[g+24>>2]|0,(f|0)!=0):0)?(wk(f,28208)|0)==0:0)?(e=Jc(a,35)|0,(e|0)!=0):0)?(d=c[e+24>>2]|0,(d|0)!=0):0)?(Ak(d,28224)|0)!=0:0){e=1;d=14;break}a=c[a+8>>2]|0;if(!a){e=0;d=14;break}}if((d|0)==14){i=b;return e|0}return 0}function uh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;e=i;if(!b){i=e;return}f=c[b+12>>2]|0;if(!f){i=e;return}else{b=0;g=0}do{h=c[f+28>>2]|0;if(h){j=c[h>>2]|0;b=(j|0)==16?f:b;g=(j|0)==46?f:g}f=c[f+8>>2]|0}while((f|0)!=0);if(!((g|0)!=0&(b|0)!=0)){i=e;return}h=c[g+12>>2]|0;if(!h){i=e;return}a=a+68|0;do{j=h;h=c[h+8>>2]|0;g=c[j+28>>2]|0;a:do if(((g|0)!=0?(c[g>>2]|0)==75:0)?(d=c[j+12>>2]|0,(d|0)!=0):0){g=d;while(1){if((Te(g)|0)!=0?(Vd(c[a>>2]|0,j)|0)==0:0)break;f=c[g+28>>2]|0;if(!f)break;if((c[f>>2]|0)!=80)break;g=c[g+8>>2]|0;if(!g)break a}Nd(j)|0;Pd(b,j)}while(0)}while((h|0)!=0);i=e;return}function vh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=i;e=kk(c[b+96>>2]|0)|0;if(!e){i=h;return}if(!(((d|0)!=0?(j=c[d+28>>2]|0,(j|0)!=0):0)?(c[j>>2]|0)==46:0))d=Pf(b)|0;if(!d){i=h;return}j=c[d+12>>2]|0;if(!j){i=h;return}d=b+2724|0;while(1){k=Jc(j,61)|0;l=Jc(j,35)|0;q=c[j+28>>2]|0;if((((q|0)!=0?(c[q>>2]|0)==67&(l|0)!=0&(k|0)!=0:0)?(g=c[k+24>>2]|0,(g|0)!=0):0)?(wk(g,28240)|0)==0:0){k=l+24|0;n=pk(c[d>>2]|0,c[k>>2]|0)|0;l=0;o=n;a:while(1){m=l;while(1){do{if(!o)break a;p=a[o>>0]|0;if(!(p<<24>>24))break a;while(1){q=o+1|0;if(!(Xl(p<<24>>24)|0)){p=o;break}p=a[q>>0]|0;o=q}while(1){q=a[p>>0]|0;if(q<<24>>24==59){f=22;break}else if(!(q<<24>>24)){q=p;break}p=p+1|0}if((f|0)==22){f=0;a[p>>0]=0;q=p+1|0}}while(q>>>0<=o>>>0);p=c[d>>2]|0;p=rb[c[c[p>>2]>>2]&15](p,12)|0;c[p>>2]=pk(c[d>>2]|0,o)|0;c[p+4>>2]=0;c[p+8>>2]=0;if(!m){l=p;o=q;continue a}c[m+8>>2]=p;m=p;o=q}}q=c[d>>2]|0;ob[c[(c[q>>2]|0)+8>>2]&15](q,n);b:do if(l){m=l;while(1){if(!(yk(c[m>>2]|0,28256,7)|0))break;m=c[m+8>>2]|0;if(!m)break b}p=c[d>>2]|0;ob[c[(c[p>>2]|0)+8>>2]&15](p,c[m>>2]|0);p=c[d>>2]|0;o=c[c[p>>2]>>2]|0;q=(qk(e)|0)+9|0;q=rb[o&15](p,q)|0;c[m>>2]=q;tk(q,28264)|0;tk((c[m>>2]|0)+8|0,e)|0;q=Rh(b,l)|0;p=c[d>>2]|0;ob[c[(c[p>>2]|0)+8>>2]&15](p,c[k>>2]|0);c[k>>2]=q}while(0);Sh(b,l)}j=c[j+8>>2]|0;if(!j)break}i=h;return}function wh(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if(!b){i=d;return}do{e=b;b=c[b+8>>2]|0;if((c[e+44>>2]|0)!=2){e=c[e+12>>2]|0;if(e)wh(a,e)}else{Nd(e)|0;zf(a,e)}}while((b|0)!=0);i=d;return}function xh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;d=i;i=i+16|0;e=d;if(!b){i=d;return}else f=b;while(1){b=c[f+8>>2]|0;c[e>>2]=b;g=c[f+28>>2]|0;if((g|0)!=0?(c[g>>2]|0)==36:0){Jh(a,f,e);b=c[e>>2]|0}else{f=c[f+12>>2]|0;if(f)xh(a,f,0)}if(!b)break;else f=b}i=d;return}function yh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+16|0;e=g;if(!d){i=g;return}f=(c[b+68>>2]|0)+84|0;do{h=d;d=c[d+8>>2]|0;if(Te(h)|0){m=c[f>>2]|0;k=c[h+36>>2]|0;l=m+k|0;j=h+40|0;if(k>>>0<(c[j>>2]|0)>>>0)do{m=m+k|0;o=a[m>>0]|0;n=o&255;c[e>>2]=n;if(o<<24>>24<0){k=(Hk(m,e)|0)+k|0;n=c[e>>2]|0}a:do if((n+ -8211|0)>>>0<12)switch(n|0){case 8212:case 8211:{c[e>>2]=45;n=45;break a};case 8218:case 8217:case 8216:{c[e>>2]=39;n=39;break a};case 8222:case 8221:case 8220:{c[e>>2]=34;n=34;break a};default:break a}while(0);l=Ik(l,n)|0;k=k+1|0;m=c[f>>2]|0}while(k>>>0<(c[j>>2]|0)>>>0);c[j>>2]=l-m}h=c[h+12>>2]|0;if(h)yh(b,h)}while((d|0)!=0);i=g;return}function zh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;if(!b){i=d;return}g=a+68|0;do{h=b;b=c[b+8>>2]|0;j=c[h+28>>2]|0;if((j|0)!=0?(c[j+20>>2]|0)==32:0)rh(c[g>>2]|0,c[h+12>>2]|0);else f=7;if((f|0)==7?(f=0,e=c[h+12>>2]|0,(e|0)!=0):0)zh(a,e)}while((b|0)!=0);i=d;return}function Ah(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if(!b){i=d;return}do{e=b;b=c[b+8>>2]|0;f=e+44|0;if((c[f>>2]|0)==8)c[f>>2]=4;e=c[e+12>>2]|0;if(e)Ah(a,e)}while((b|0)!=0);i=d;return}function Bh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;if(!b){i=g;return}j=(e|0)!=0;h=(d|0)!=0;f=a+68|0;do{k=b;b=c[b+8>>2]|0;if(Ue(k)|0){m=Jc(k,66)|0;l=Jc(k,153)|0;o=(m|0)!=0;n=(l|0)!=0;do if(!(o&n)){if(o&h){o=Ic(k,153)|0;if(!(c[(c[f>>2]|0)+40>>2]&o))break;Oc(a,k,28280,c[m+24>>2]|0)|0;break}if(n&j?(o=Ic(k,66)|0,(c[(c[f>>2]|0)+40>>2]&o|0)!=0):0)Oc(a,k,28296,c[l+24>>2]|0)|0}while(0);if(!((m|0)==0|j))Gf(a,k,m);if(!((l|0)==0|h))Gf(a,k,l)}k=c[k+12>>2]|0;if(k)Bh(a,k,d,e)}while((b|0)!=0);i=g;return}function Ch(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=Nf(a)|0;do if(e){g=Jc(e,155)|0;h=(g|0)!=0;if(!b){if(!h)break;Gf(a,e,g);break}if((h?(f=c[g+24>>2]|0,(f|0)!=0):0)?(wk(f,28304)|0)==0:0)break;Oc(a,e,28336,28304)|0}while(0);i=d;return}function Dh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;k=i;if(!b){i=k;return}h=(e|0)!=0;g=(d|0)==0;f=(d|0)!=0;j=a+68|0;do{m=b;b=c[b+8>>2]|0;if(Sc(a,m)|0){l=Jc(m,80)|0;p=Jc(m,62)|0;o=(l|0)!=0;n=(p|0)!=0;do if(!(o&n)){if(!(o&h)){if(!(n&f)){q=0;r=0;break}s=Ic(m,80)|0;if(!(c[(c[j>>2]|0)+40>>2]&s)){q=0;r=0;break}Oc(a,m,28352,c[p+24>>2]|0)|0;q=0;r=1;break}s=Ic(m,62)|0;if(c[(c[j>>2]|0)+40>>2]&s){q=l+24|0;if(!(bd(c[q>>2]|0)|0)){hi(a,m,l,74);q=0;r=0;break}else{Oc(a,m,28344,c[q>>2]|0)|0;q=1;r=0;break}}else{q=0;r=0}}else{s=(c[l+24>>2]|0)!=0;q=c[p+24>>2]|0;r=(q|0)!=0;if(!(s^r)){if(!(s&r)){q=0;r=0;break}if(!(vk(c[l+24>>2]|0,q)|0)){q=0;r=0;break}}hi(a,m,l,60);q=0;r=0}while(0);if(!((p|0)==0|h))if(o|g|(r|0)!=0){Gf(a,m,p);o=0}else o=0;else o=h;if(!((l|0)==0|f)?n|o^1|(q|0)!=0:0)Gf(a,m,l);if((Jc(m,80)|0)==0?(Jc(m,62)|0)==0:0)Uc(a,m)}l=c[m+12>>2]|0;if(l)Dh(a,l,d,e)}while((b|0)!=0);i=k;return}function Eh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;j=i;i=i+528|0;f=j;g=j+8|0;h=(c[b+68>>2]|0)+120|0;k=c[h>>2]|0;a:do if(k){while(1){if((vk(c[k>>2]|0,d)|0)==0?(vk(c[k+8>>2]|0,e)|0)==0:0)break;k=c[k+12>>2]|0;if(!k)break a}l=k+4|0;l=c[l>>2]|0;i=j;return l|0}while(0);l=b+2724|0;k=c[l>>2]|0;k=rb[c[c[k>>2]>>2]&15](k,16)|0;c[k>>2]=pk(c[l>>2]|0,d)|0;d=c[b+388>>2]|0;if(!((d|0)!=0?(a[d>>0]|0)!=0:0))d=29280;m=b+2732|0;b=(c[m>>2]|0)+1|0;c[m>>2]=b;c[f>>2]=d;c[f+4>>2]=b;Ek(g,512,29288,f)|0;d=k+4|0;c[d>>2]=pk(c[l>>2]|0,g)|0;c[k+8>>2]=pk(c[l>>2]|0,e)|0;c[k+12>>2]=c[h>>2];c[h>>2]=k;l=d;l=c[l>>2]|0;i=j;return l|0}function Fh(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;c=Th(a,Th(a,0,b)|0,c)|0;b=Rh(a,c)|0;Sh(a,c);i=d;return b|0}function Gh(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[b+12>>2]|0;a:do if(e)do{e=Gh(a,e)|0;if(!e)break a;e=c[e+8>>2]|0}while((e|0)!=0);while(0);e=Uh(a,b)|0;i=d;return e|0}function Hh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=c[b+12>>2]|0;if(e)do{Hh(a,e);e=c[e+8>>2]|0}while((e|0)!=0);e=Jc(b,136)|0;if(!e){i=d;return}f=e+24|0;g=c[f>>2]|0;if(!g){Gf(a,b,e);i=d;return}g=Eh(a,c[b+32>>2]|0,g)|0;h=Jc(b,25)|0;if(!h){h=a+2724|0;a=c[h>>2]|0;e=e+20|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,c[e>>2]|0);a=c[h>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,c[f>>2]|0);c[e>>2]=pk(c[h>>2]|0,28648)|0;c[f>>2]=pk(c[h>>2]|0,g)|0;i=d;return}else{Yc(a,h,g);Gf(a,b,e);i=d;return}}function Ih(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if(!((b|0)!=0&(c|0)!=0)){i=d;return}Kf(a,b);Kf(a,28632);Kf(a,c);Kf(a,28584);i=d;return}function Jh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;e=b+12|0;j=c[e>>2]|0;if(!j){c[d>>2]=Od(a,b)|0;i=f;return}h=c[b>>2]|0;g=b+8|0;k=c[b+16>>2]|0;c[k+8>>2]=c[g>>2];l=c[g>>2]|0;if(!l)c[h+16>>2]=k;else c[l+4>>2]=k;k=b+4|0;l=c[k>>2]|0;if(!l)c[h+12>>2]=j;else{c[j+4>>2]=l;c[(c[k>>2]|0)+8>>2]=j}j=c[e>>2]|0;if(!j)j=0;else{k=j;do{c[k>>2]=h;k=c[k+8>>2]|0}while((k|0)!=0)}c[d>>2]=j;c[e>>2]=0;c[g>>2]=0;zf(a,b);i=f;return}function Kh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;d=Ke(d)|0;f=a+2724|0;g=c[f>>2]|0;a=b+32|0;ob[c[(c[g>>2]|0)+8>>2]&15](g,c[a>>2]|0);c[a>>2]=pk(c[f>>2]|0,c[d+4>>2]|0)|0;c[b+28>>2]=d;i=e;return}function Lh(a){a=a|0;a=c[a+12>>2]|0;if(!a)a=0;else a=(c[a+8>>2]|0)==0;return a&1|0}function Mh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=b+12|0;f=c[e>>2]|0;g=f+12|0;c[e>>2]=c[g>>2];c[b+16>>2]=c[f+16>>2];c[g>>2]=0;zf(a,f);a=c[e>>2]|0;if(!a){i=d;return}do{c[a>>2]=b;a=c[a+8>>2]|0}while((a|0)!=0);i=d;return}function Nh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;g=c[a+68>>2]|0;f=g+84|0;while(1){a:do if(!((xk((c[f>>2]|0)+(c[b+36>>2]|0)|0,28416,21)|0)!=0|(b|0)==0)){h=b;while(1){j=c[h+28>>2]|0;if((j|0)!=0?(c[j>>2]|0)==106:0)break;h=c[h>>2]|0;if(!h)break a}if(h)Rd(b,Jf(g,28440)|0)}while(0);if((c[b+44>>2]|0)==4)b=c[b+8>>2]|0;else b=Od(a,b)|0;if(!b){a=0;e=17;break}if((c[b+44>>2]|0)!=9)continue;h=b+36|0;if(xk((c[f>>2]|0)+(c[h>>2]|0)|0,28104,2)|0)if(!(xk((c[f>>2]|0)+(c[h>>2]|0)|0,28448,5)|0))break;else continue;else{b=Nh(a,b)|0;continue}}if((e|0)==17){i=d;return a|0}j=Od(a,b)|0;i=d;return j|0}function Oh(a){a=a|0;var b=0,d=0,e=0;b=i;a=Jc(a,136)|0;if(((a|0)!=0?(d=a+24|0,e=c[d>>2]|0,(e|0)!=0):0)?(Ak(e,28376)|0)!=0:0)d=(Ak(c[d>>2]|0,28392)|0)!=0&1;else d=0;i=b;return d|0}function Ph(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;e=b+20|0;k=c[e>>2]|0;if(!k){i=f;return}b=b+28|0;h=0;a:while(1){g=(h|0)==0;j=k;b:while(1){k=c[j>>2]|0;l=j+4|0;m=c[l>>2]|0;do if(m){if((c[m>>2]|0)==25){m=j+24|0;n=c[m>>2]|0;if((n|0)!=0?(wk(n,28200)|0)==0:0)break b;if(xk(c[m>>2]|0,28360,3)|0)break b}l=c[l>>2]|0;if(l){if((c[l>>2]|0)!=25){l=c[l>>2]|0;if((l|0)==66|(l|0)==136)break;else if(!((l|0)==151|(l|0)==57)){d=15;break}l=c[b>>2]|0;if(!((l|0)!=0?(n=c[l>>2]|0,(n|0)==109|(n|0)==112|(n|0)==106):0))d=15}}else d=15}else d=15;while(0);if((d|0)==15){d=0;l=c[j+20>>2]|0;if(!l)break;if(xk(l,28368,2)|0)break}if(g)c[e>>2]=k;else c[h>>2]=k;Ef(a,j);if(!k){d=21;break a}else j=k}if(!k){d=21;break}else h=j}if((d|0)==21){i=f;return}}function Qh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;e=b+12|0;sh(a,c[e>>2]|0);h=c[e>>2]|0;j=c[b+4>>2]|0;if(!j)if(!h)g=0;else{g=c[h+8>>2]|0;Nd(h)|0;Rd(b,h);f=4}else{g=h;h=j;f=4}if((f|0)==4)if(!g)g=h;else while(1){f=c[g+8>>2]|0;Nd(g)|0;Sd(h,g);if(!f)break;else{h=g;g=f}}f=c[b+8>>2]|0;if(f){c[e>>2]=0;Od(a,b)|0;i=d;return f|0}c[(c[b>>2]|0)+16>>2]=g;c[e>>2]=0;Od(a,b)|0;i=d;return f|0}function Rh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=(d|0)==0;if(f)h=0;else{h=0;g=d;do{h=h+2+(qk(c[g>>2]|0)|0)|0;j=c[g+4>>2]|0;if(j)h=h+2+(qk(j)|0)|0;g=c[g+8>>2]|0}while((g|0)!=0)}b=c[b+2724>>2]|0;b=rb[c[c[b>>2]>>2]&15](b,h+1|0)|0;a[b>>0]=0;if(f){i=e;return b|0}else f=b;while(1){h=c[d>>2]|0;while(1){j=a[h>>0]|0;g=f+1|0;a[f>>0]=j;if(!(j<<24>>24))break;else{f=g;h=h+1|0}}h=d+4|0;if(c[h>>2]|0){a[f>>0]=58;a[g>>0]=32;f=f+2|0;h=c[h>>2]|0;while(1){j=a[h>>0]|0;g=f+1|0;a[f>>0]=j;if(!(j<<24>>24))break;else{f=g;h=h+1|0}}}d=d+8|0;if(!(c[d>>2]|0)){d=13;break}a[g+ -1>>0]=59;a[g>>0]=32;d=c[d>>2]|0;if(!d){d=13;break}else f=g+1|0}if((d|0)==13){i=e;return b|0}return 0}function Sh(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;if(!b){i=d;return}a=a+2724|0;do{e=b;b=c[b+8>>2]|0;f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[e>>2]|0);f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[e+4>>2]|0);f=c[a>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,e)}while((b|0)!=0);i=d;return}function Th(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=i;b=b+2724|0;e=pk(c[b>>2]|0,e)|0;k=a[e>>0]|0;a:do if(k<<24>>24){h=e;do{while(1){j=h+1|0;if(k<<24>>24!=32){j=h;break}k=a[j>>0]|0;h=j}while(1){if(!(k<<24>>24))break a;l=j+1|0;if(k<<24>>24==58)break;k=a[l>>0]|0;j=l}while(1){m=a[l>>0]|0;if(m<<24>>24==32)l=l+1|0;else{k=l;break}}while(1){if(!(m<<24>>24)){g=11;break}else if(m<<24>>24==59){m=1;break}p=k+1|0;m=a[p>>0]|0;k=p}if((g|0)==11){g=0;m=0}a[j>>0]=0;a[k>>0]=0;b:do if(d){n=d;o=0;while(1){p=vk(c[n>>2]|0,h)|0;if(!p)break b;if((p|0)>0)break;o=c[n+8>>2]|0;if(!o){g=18;break b}else{p=n;n=o;o=p}}p=c[b>>2]|0;p=rb[c[c[p>>2]>>2]&15](p,12)|0;c[p>>2]=pk(c[b>>2]|0,h)|0;c[p+4>>2]=pk(c[b>>2]|0,l)|0;c[p+8>>2]=n;if(!o)d=p;else c[o+8>>2]=p}else{n=0;g=18}while(0);if((g|0)==18){g=0;o=c[b>>2]|0;o=rb[c[c[o>>2]>>2]&15](o,12)|0;c[o>>2]=pk(c[b>>2]|0,h)|0;c[o+4>>2]=pk(c[b>>2]|0,l)|0;c[o+8>>2]=0;if(!n)d=o;else c[n+8>>2]=o}a[j>>0]=58;if(!m)break a;a[k>>0]=59;h=k+1|0;k=a[h>>0]|0}while(k<<24>>24!=0)}while(0);p=c[b>>2]|0;ob[c[(c[p>>2]|0)+8>>2]&15](p,e);i=f;return d|0}function Uh(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0;e=i;i=i+400|0;s=e;r=e+136|0;t=e+144|0;k=e+132|0;B=e+128|0;w=c[b+424>>2]|0;v=c[b+440>>2]|0;c[B>>2]=d;if(!(Ue(d)|0)){G=d;i=e;return G|0}z=b+216|0;A=b+2724|0;a:while(1){C=(d|0)==0;do if(!C){E=d+28|0;D=c[E>>2]|0;G=(D|0)==0;if(!G){F=c[D>>2]|0;if((F|0)==76|(F|0)==115|(F|0)==29?(x=c[d+12>>2]|0,(x|0)!=0):0){if((((c[x+8>>2]|0)==0?(u=c[x+28>>2]|0,(u|0)!=0):0)?(c[u>>2]|0)==61:0)?(c[x+60>>2]|0)!=0:0){c[E>>2]=Ke(30)|0;F=c[A>>2]|0;G=d+32|0;ob[c[(c[F>>2]|0)+8>>2]&15](F,c[G>>2]|0);c[G>>2]=pk(c[A>>2]|0,29248)|0;kh(b,d,29256);Mh(b,d);break}if(G){p=1;h=38;break}}if((c[D>>2]|0)!=115){if(G){p=1;h=38;break}if((c[D>>2]|0)==76)h=16}else h=16;if((h|0)==16){h=0;F=d+12|0;E=c[F>>2]|0;if(((((E|0)!=0?(c[E+8>>2]|0)==0:0)?(j=E+12|0,f=c[j>>2]|0,(f|0)!=0):0)?(c[f+28>>2]|0)==(D|0):0)?(g=f+8|0,(c[g>>2]|0)==0):0){h=21;break a}if(G){p=1;h=38;break}}if((c[D>>2]|0)==20){if(!(c[z>>2]|0)){Kh(b,d,30);kh(b,d,29224);break}if(c[d+12>>2]|0){G=c[d+16>>2]|0;Jh(b,d,B);Sd(G,Tf(b,17)|0);break}E=c[d+4>>2]|0;D=c[d+8>>2]|0;G=c[d>>2]|0;Jh(b,d,B);F=Tf(b,17)|0;if(D){Rd(D,F);break}if(!E){Pd(G,F);break}else{Sd(E,F);break}}else{p=1;h=38}}else{p=1;h=38}}else{p=0;h=38}while(0);do if(((h|0)==38?(h=0,(Vh(b,30,w,d)|0)==0):0)?(Vh(b,98,v,d)|0)==0:0){if(((p?(y=c[d+28>>2]|0,(y|0)!=0):0)?(G=c[y>>2]|0,(G|0)==112|(G|0)==109|(G|0)==106|(G|0)==104):0)?(q=Jc(d,13)|0,(q|0)!=0):0){c[s>>2]=c[q+24>>2];Ek(t,256,29200,s)|0;Gf(b,d,q);kh(b,d,t)}if(Wh(d)|0){if(!((p?(o=c[d+28>>2]|0,(o|0)!=0):0)?(c[o>>2]|0)==19:0))h=49;b:do if((h|0)==49?(h=0,m=d+20|0,n=c[m>>2]|0,(n|0)!=0):0){D=n;E=0;while(1){G=c[D+4>>2]|0;if((G|0)!=0?(c[G>>2]|0)==7:0)break;E=c[D>>2]|0;if(!E)break b;else{G=D;D=E;E=G}}F=c[D>>2]|0;if(!E)c[m>>2]=F;else c[E>>2]=F;E=c[D+24>>2]|0;if(E){tk(s,29184)|0;F=12;while(1){G=vf(a[E>>0]|0)|0;a[s+F>>0]=G;if(!(G&255))break;F=F+1|0;if(F>>>0<127)E=E+1|0;else break}a[s+F>>0]=0;kh(b,d,s)}Ef(b,D)}while(0);D=c[d+12>>2]|0;if((D|0)!=0?(c[D+8>>2]|0)==0:0){if(Xh(D,k,0)|0){Yh(b,d,D);kh(b,d,c[k>>2]|0);Mh(b,d);break}G=c[D+28>>2]|0;if((G|0)!=0?(c[G>>2]|0)==36:0){Yh(b,d,D);Zh(b,d,c[D+20>>2]|0);Mh(b,d);break}}}if(((_h(d)|0)!=0?(l=c[d+12>>2]|0,(l|0)!=0):0)?(c[l+8>>2]|0)==0:0){if(Xh(l,r,0)|0){Yh(b,d,l);kh(b,d,c[r>>2]|0);Mh(b,d);break}G=c[l+28>>2]|0;if((G|0)!=0?(c[G>>2]|0)==36:0){Yh(b,d,l);Zh(b,d,c[l+20>>2]|0);Mh(b,d);break}}D=c[d>>2]|0;if((c[D+12>>2]|0)==(d|0)?(c[d+8>>2]|0)==0:0){if((Wh(D)|0)==0?(_h(c[d>>2]|0)|0)==0:0)h=81}else h=81;if((h|0)==81?(h=0,(Xh(d,s,1)|0)!=0):0){Kh(b,d,98);kh(b,d,c[s>>2]|0);break}if(C){h=99;break a}C=c[d+28>>2]|0;if(!C){h=99;break a}if((c[C>>2]|0)!=36){h=99;break a}if(c[z>>2]|0){Jh(b,d,B);break}C=c[d>>2]|0;if(((c[C+12>>2]|0)==(d|0)?(c[d+8>>2]|0)==0:0)?(Wh(C)|0)!=0:0){h=99;break a}C=d+20|0;Zh(b,d,c[C>>2]|0);F=c[C>>2]|0;c:do if(!F)D=0;else{E=0;while(1){D=F;while(1){F=c[D>>2]|0;G=c[D+4>>2]|0;if((G|0)!=0?(c[G>>2]|0)==136:0)break;Ef(b,D);if(!F){D=E;break c}else D=F}c[D>>2]=0;if(!F)break;else E=D}}while(0);c[C>>2]=D;Kh(b,d,98)}while(0);d=c[B>>2]|0;if(!(Ue(d)|0)){h=100;break}}if((h|0)==21){c[B>>2]=f;h=f+4|0;c[h>>2]=c[d+4>>2];G=d+8|0;c[g>>2]=c[G>>2];c[f>>2]=c[d>>2];jh(f);c[j>>2]=0;zf(b,E);c[F>>2]=0;c[G>>2]=0;zf(b,d);j=c[h>>2]|0;if(!j){G=f;i=e;return G|0}k=c[j+28>>2]|0;if(!k){G=f;i=e;return G|0}if((c[k>>2]|0)!=115?(c[k>>2]|0)!=76:0){G=f;i=e;return G|0}k=c[j+16>>2]|0;if(!k){G=f;i=e;return G|0}c[j+8>>2]=c[g>>2];jh(j);c[f>>2]=k;c[g>>2]=0;c[h>>2]=c[k+16>>2];jh(f);Uh(b,f)|0;G=f;i=e;return G|0}else if((h|0)==99){G=c[B>>2]|0;i=e;return G|0}else if((h|0)==100){i=e;return d|0}return 0}function Vh(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;do if(((((((d|0)!=0&(e|0)!=0?(k=c[e+28>>2]|0,(k|0)!=0):0)?(c[k>>2]|0)==(b|0):0)?(g=c[e+12>>2]|0,(g|0)!=0):0)?(c[g+8>>2]|0)==0:0)?(j=c[g+28>>2]|0,(j|0)!=0):0)?(c[j>>2]|0)==(b|0):0){if((d|0)==2){if((Jc(g,62)|0)!=0?(Jc(e,62)|0)!=0:0){a=0;break}b=c[g+20>>2]|0;if(b)do{j=c[b+4>>2]|0;do if(j){j=c[j>>2]|0;if((j|0)==25|(j|0)==136){b=c[b>>2]|0;break}else if(!j){h=18;break}h=Jc(e,j)|0;if(h){Gf(a,e,h);h=18}else h=18}else h=18;while(0);if((h|0)==18){h=0;Ff(g,b);d=c[b>>2]|0;c[b>>2]=0;dg(e,b);b=d}}while((b|0)!=0)}Yh(a,e,g);Mh(a,e);a=1}else a=0;while(0);i=f;return a|0}function Wh(a){a=a|0;var b=0,d=0,e=0;d=i;if(Ve(a,232)|0)if(((a|0)!=0?(e=c[a+28>>2]|0,(e|0)!=0):0)?(e=c[e>>2]|0,(e|0)==61|(e|0)==112|(e|0)==104):0)b=5;else a=1;else b=5;if((b|0)==5)a=0;i=d;return a|0}function Xh(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;j=(d|0)==0;h=(a|0)==0;d=a+28|0;a=(a|0)!=0;k=29004|0;l=0;while(1){if(j){if(!h)f=5}else if((l+ -2|0)>>>0<3&a)f=5;if(((f|0)==5?(f=0,g=c[d>>2]|0,(g|0)!=0):0)?(c[g>>2]|0)==(c[29e3+(l*12|0)>>2]|0):0)break;l=l+1|0;if((l|0)==5){g=0;f=9;break}else k=29004+(l*12|0)|0}if((f|0)==9){i=e;return g|0}c[b>>2]=c[k>>2];l=1;i=e;return l|0}function Yh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=i;h=e+20|0;e=c[h>>2]|0;a:do if(!e)j=0;else{while(1){m=c[e+4>>2]|0;if((m|0)!=0?(c[m>>2]|0)==25:0)break;e=c[e>>2]|0;if(!e){j=0;break a}}j=c[e+24>>2]|0}while(0);e=d+20|0;k=c[e>>2]|0;b:do if(k){while(1){m=c[k+4>>2]|0;if((m|0)!=0?(c[m>>2]|0)==25:0)break;k=c[k>>2]|0;if(!k){f=7;break b}}l=k+24|0;k=c[l>>2]|0;m=(j|0)!=0;if(!k)if(m){f=15;break}else break;if(m){o=qk(k)|0;m=qk(j)|0;n=b+2724|0;p=c[n>>2]|0;m=rb[c[c[p>>2]>>2]&15](p,o+2+m|0)|0;tk(m,k)|0;a[m+o>>0]=32;tk(m+(o+1)|0,j)|0;k=c[n>>2]|0;ob[c[(c[k>>2]|0)+8>>2]&15](k,c[l>>2]|0);c[l>>2]=m}}else f=7;while(0);if((f|0)==7?(j|0)!=0:0)f=15;if((f|0)==15)eg(d,cg(b,28648,j,34)|0);h=c[h>>2]|0;c:do if(!h)h=0;else{while(1){p=c[h+4>>2]|0;if((p|0)!=0?(c[p>>2]|0)==136:0)break;h=c[h>>2]|0;if(!h){h=0;break c}}h=c[h+24>>2]|0}while(0);e=c[e>>2]|0;d:do if(!e)f=22;else{while(1){p=c[e+4>>2]|0;if((p|0)!=0?(c[p>>2]|0)==136:0)break;e=c[e>>2]|0;if(!e){f=22;break d}}e=e+24|0;k=c[e>>2]|0;j=(h|0)!=0;if(!k){if(j)break;i=g;return}if(!j){i=g;return}p=Fh(b,k,h)|0;o=c[b+2724>>2]|0;ob[c[(c[o>>2]|0)+8>>2]&15](o,c[e>>2]|0);c[e>>2]=p;i=g;return}while(0);if((f|0)==22?(h|0)==0:0){i=g;return}eg(d,cg(b,28072,h,34)|0);i=g;return}function Zh(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=i;i=i+272|0;g=n;h=n+8|0;if(!e){i=n;return}m=(d|0)==0;f=d+28|0;o=b+2724|0;p=d+32|0;do{r=c[e+24>>2]|0;a:do if((r|0)!=0?(l=c[e+4>>2]|0,(l|0)!=0):0){if((c[l>>2]|0)==49){c[g>>2]=r;Ek(h,256,28984,g)|0;kh(b,d,h);break}q=c[l>>2]|0;if((q|0)==31){c[g>>2]=r;Ek(h,128,28656,g)|0;kh(b,d,h);break}else if((q|0)!=131)break;do if((!m?(k=c[f>>2]|0,(k|0)!=0):0)?(c[k>>2]|0)==79:0){if(vk(r,28672)|0)if(vk(r,28688)|0)if(!(vk(r,28704)|0))q=28712;else break;else q=28696;else q=28680;s=c[o>>2]|0;ob[c[(c[s>>2]|0)+8>>2]&15](s,c[p>>2]|0);c[p>>2]=pk(c[o>>2]|0,q)|0;Je(b,d)|0;break a}while(0);q=a[r>>0]|0;s=q<<24>>24;if(q<<24>>24){do if((q+ -48<<24>>24&255)>=7){s=a[r+1>>0]|0;r=s<<24>>24;s=(s+ -48<<24>>24&255)<7;if(q<<24>>24==45){if(!s){q=28968;break}q=28816+(r+ -48<<2)|0;j=23;break}else{if(!s){q=28976;break}q=28896+(r+ -48<<2)|0;j=23;break}}else{q=28736+(s+ -48<<2)|0;j=23}while(0);if((j|0)==23){j=0;q=c[q>>2]|0;if(!q)break}c[g>>2]=q;Ek(h,64,28720,g)|0;kh(b,d,h)}}while(0);e=c[e>>2]|0}while((e|0)!=0);i=n;return}function _h(a){a=a|0;var b=0,d=0;b=i;if(((a|0)!=0?(d=c[a+28>>2]|0,(d|0)!=0):0)?(c[d>>2]|0)==36:0){d=0;d=d&1;i=b;return d|0}d=(Ve(a,528)|0)!=0;d=d&1;i=b;return d|0}function $h(){return 29296}function ai(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;e=28;d=29344;f=0;while(1){f=f+1|0;if((e|0)==(a|0))break;d=29344+(f*12|0)|0;e=c[d>>2]|0;if((e|0)==94){d=0;break}}i=b;return d|0}function bi(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=b;wi(a,d,30464,f);i=e;return}function ci(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;if(!b)va(30488,30504,1197,30528);else{c[e>>2]=b;wi(a,2,30560,e);i=d;return}}function di(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;e=d;if(!b)va(30488,30504,1204,30584);else{c[e>>2]=b;wi(a,2,30616,e);i=d;return}}function ei(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e;if((b|0)!=80){i=e;return}b=xi(80)|0;g=Ui(c[(c[a+2660>>2]|0)+296>>2]|0)|0;d=Ui(d)|0;c[f>>2]=g;c[f+4>>2]=d;yi(a,0,b,f);b=a+2716|0;c[b>>2]=c[b>>2]|16;i=e;return}function fi(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0,l=0;j=i;i=i+48|0;h=j;g=j+8|0;k=g+0|0;l=k+32|0;do{a[k>>0]=0;k=k+1|0}while((k|0)<(l|0));k=(f|0)!=0?30664:30680;l=xi(d)|0;switch(d|0){case 76:{zi(e,g);f=b+2716|0;c[f>>2]=c[f>>2]|1;break};case 78:{c[h>>2]=e;Ek(g,32,30696,h)|0;f=b+2716|0;c[f>>2]=c[f>>2]|4;break};case 79:{c[h>>2]=e;Ek(g,32,30696,h)|0;f=b+2716|0;c[f>>2]=c[f>>2]|8;break};case 82:{zi(e,g);f=b+2716|0;c[f>>2]=c[f>>2]|64;break};case 77:{zi(e,g);f=b+2716|0;c[f>>2]=c[f>>2]|2;break};default:{}}if(!l){i=j;return}c[h>>2]=k;c[h+4>>2]=g;yi(b,0,l,h);i=j;return}function gi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;e=i;i=i+16|0;f=e;b=xi(b)|0;if(!b){i=e;return}c[f>>2]=(d|0)!=0?d:30704;yi(a,0,b,f);i=e;return}function hi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;j=i;i=i+80|0;g=j;f=j+16|0;h=xi(e)|0;if(!h)va(30712,30504,1306,30728);Ai(b,f,64);if(!d){k=30704;d=30704}else{k=c[d+20>>2]|0;d=c[d+24>>2]|0;k=(k|0)==0?30704:k;d=(d|0)==0?30704:d}switch(e|0){case 72:case 73:case 51:{c[g>>2]=f;c[g+4>>2]=k;c[g+8>>2]=d;Bi(a,1,b,h,g);i=j;return};case 70:case 66:case 54:case 71:{c[g>>2]=f;c[g+4>>2]=d;Bi(a,1,b,h,g);i=j;return};case 68:case 53:case 57:case 50:case 49:case 48:{c[g>>2]=f;c[g+4>>2]=k;Bi(a,1,b,h,g);i=j;return};case 56:{c[g>>2]=f;Bi(a,1,b,h,g);k=a+2708|0;c[k>>2]=c[k>>2]|8;i=j;return};case 75:{d=c[a+2660>>2]|0;k=c[a+68>>2]|0;c[k>>2]=c[d+292>>2];c[k+4>>2]=c[d+288>>2];c[g>>2]=f;yi(a,0,h,g);i=j;return};case 55:{c[g>>2]=f;c[g+4>>2]=d;c[g+8>>2]=k;Bi(a,1,b,h,g);i=j;return};case 69:case 74:case 52:case 87:case 65:case 64:case 63:case 62:case 61:case 60:case 59:case 58:{c[g>>2]=f;Bi(a,1,b,h,g);i=j;return};default:{i=j;return}}}function ii(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;i=i+80|0;f=e;h=e+8|0;g=xi(86)|0;if(!g)va(30712,30504,1381,30752);else{Ai(b,h,64);c[f>>2]=h;c[f+4>>2]=d;Bi(a,1,b,g,f);i=e;return}}function ji(a){a=a|0;var b=0,c=0;b=i;i=i+16|0;c=b;Ci(a,30784,c);Ci(a,30792,c);Ci(a,30872,c);Ci(a,30936,c);Ci(a,31016,c);Ci(a,31088,c);Ci(a,31168,c);Ci(a,31192,c);Ci(a,31272,c);Ci(a,31336,c);Ci(a,31408,c);Ci(a,31488,c);Ci(a,31568,c);Ci(a,31624,c);Ci(a,30784,c);i=b;return}function ki(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e;d=xi(d)|0;g=a+2708|0;c[g>>2]=c[g>>2]|-2147483648;c[f>>2]=d;Bi(a,3,b,31704,f);i=e;return}function li(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+16|0;f=e;d=xi(d)|0;g=a+2708|0;c[g>>2]=c[g>>2]|-2147483648;c[f>>2]=d;Bi(a,3,b,31704,f);i=e;return}function mi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;k=i;i=i+528|0;g=k;f=k+264|0;l=k+8|0;h=(b|0)!=0?b:d;j=xi(e)|0;Dm(f|0,0,256)|0;Dm(l|0,0,256)|0;if(!j)va(30712,30504,1441,31712);Ai(d,f,256);if((e|0)==9){c[g>>2]=f;Bi(a,1,h,j,g);i=k;return}else if((e|0)==85){e=c[d+32>>2]|0;c[g>>2]=e;c[g+4>>2]=e;Bi(a,1,h,j,g);i=k;return}else if((e|0)==40){c[g>>2]=j;Bi(a,1,h,31704,g);i=k;return}else if((e|0)==20){Ai(b,l,256);c[g>>2]=l;c[g+4>>2]=f;Bi(a,1,h,j,g);i=k;return}else{i=k;return}}function ni(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;k=i;i=i+528|0;g=k;h=k+264|0;f=k+8|0;j=xi(e)|0;Dm(h|0,0,256)|0;Dm(f|0,0,256)|0;if(!j)va(30712,30504,1472,31736);Ai(d,h,256);if((e|0)==83){Ai(b,f,256);c[g>>2]=f;c[g+4>>2]=h;Bi(a,1,(b|0)!=0?b:d,j,g);i=k;return}else if((e|0)==23){Ai(b,f,256);c[g>>2]=f;Bi(a,1,b,j,g);i=k;return}else{i=k;return}}function oi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+528|0;f=h;j=h+264|0;l=h+8|0;Dm(j|0,0,256)|0;Dm(l|0,0,256)|0;k=(b|0)!=0?b:d;g=xi(e)|0;if(!g)va(30712,30504,1497,31760);Ai(d,j,256);do switch(e|0){case 8:{e=(c[a+2720>>2]|0)!=0?4:1;c[f>>2]=j;Bi(a,e,d,g,f);i=h;return};case 15:case 38:case 13:case 12:{c[f>>2]=c[d+32>>2];Bi(a,1,d,g,f);i=h;return};case 26:case 39:case 21:case 19:case 14:{c[f>>2]=j;Bi(a,1,d,g,f);i=h;return};case 6:{c[f>>2]=c[b+32>>2];Bi(a,1,k,g,f);i=h;return};case 11:{k=b+32|0;e=c[k>>2]|0;c[f>>2]=j;c[f+4>>2]=e;Bi(a,1,d,g,f);if(!(c[a+144>>2]|0)){i=h;return}e=xi(88)|0;c[f>>2]=c[k>>2];Bi(a,0,b,e,f);i=h;return};case 10:case 24:{e=c[d+32>>2]|0;c[f>>2]=e;c[f+4>>2]=e;Bi(a,1,k,g,f);i=h;return};case 41:case 36:case 25:case 23:{Ai(b,l,256);c[f>>2]=l;Bi(a,1,b,g,f);i=h;return};case 7:{c[f>>2]=c[b+32>>2];c[f+4>>2]=j;Bi(a,1,k,g,f);i=h;return};case 84:{Ai(b,l,256);c[f>>2]=l;c[f+4>>2]=j;Bi(a,1,k,g,f);i=h;return};case 37:case 34:case 33:case 32:case 31:case 30:case 29:case 27:case 35:case 28:case 17:{c[f>>2]=g;Bi(a,1,k,31704,f);i=h;return};case 45:case 44:case 42:{c[f>>2]=g;Bi(a,1,d,31704,f);i=h;return};case 46:case 47:{j=b+32|0;e=c[j>>2]|0;c[f>>2]=c[d+32>>2];c[f+4>>2]=e;Bi(a,1,d,g,f);if(!(c[a+144>>2]|0)){i=h;return}e=xi(88)|0;c[f>>2]=c[j>>2];Bi(a,0,d,e,f);i=h;return};default:{i=h;return}}while(0)}function pi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;i=i+272|0;g=f;j=f+8|0;Dm(j|0,0,256)|0;h=xi(e)|0;switch(e|0){case 47:{e=c[b+32>>2]|0;c[g>>2]=c[d+32>>2];c[g+4>>2]=e;Bi(a,4,d,h,g);i=f;return};case 13:{c[g>>2]=c[d+32>>2];Bi(a,4,d,h,g);i=f;return};case 18:case 16:{c[g>>2]=h;Bi(a,4,(b|0)!=0?b:d,31704,g);i=f;return};case 22:{Ai(d,j,256);c[g>>2]=j;Bi(a,4,d,h,g);i=f;return};default:{i=f;return}}}function qi(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b;e=c[a+88>>2]|0;if((e|0)==8)g=31832;else if((e|0)==7)g=31800;else if((e|0)==6)g=31816;else g=(e|0)==2?31840:31784;e=a+2708|0;f=c[e>>2]|0;if(f&32)c[e>>2]=f&-49;f=a+2716|0;h=c[f>>2]|0;if(h){if(h&1){Ci(a,31848,d);Ci(a,31920,d);c[d>>2]=g;Ci(a,31704,d);Ci(a,31992,d);Ci(a,32048,d);h=c[f>>2]|0}if(h&66){Ci(a,32088,d);Ci(a,32160,d);Ci(a,32240,d);c[d>>2]=g;Ci(a,31704,d);Ci(a,32328,d);h=c[f>>2]|0}if(h&4){Ci(a,32400,d);Ci(a,32472,d);Ci(a,32544,d);Ci(a,32608,d);Ci(a,32680,d);Ci(a,32744,d);Ci(a,32808,d);Ci(a,32880,d);Ci(a,32960,d);h=c[f>>2]|0}if(h&8){Ci(a,33048,d);Ci(a,33120,d);Ci(a,33200,d);Ci(a,32960,d);h=c[f>>2]|0}if(h&32){Ci(a,33272,d);Ci(a,33336,d);Ci(a,33400,d);Ci(a,33464,d);Ci(a,33536,d);Ci(a,33608,d);Ci(a,33680,d);Ci(a,33752,d)}}if(c[a+2720>>2]|0){Ci(a,33808,d);Ci(a,33872,d);Ci(a,33944,d);Ci(a,34008,d);Ci(a,34072,d);Ci(a,34136,d)}g=c[e>>2]|0;if(g){f=a+408|0;if(!(c[f>>2]|0)){if(g&4){Ci(a,34200,d);Ci(a,34256,d);Ci(a,34320,d);Ci(a,34384,d);Ci(a,34448,d);Ci(a,34512,d);g=c[e>>2]|0}if(g&1){Ci(a,34552,d);Ci(a,34616,d);Ci(a,34680,d);Ci(a,34752,d);g=c[e>>2]|0}if(g&8){Ci(a,34824,d);Ci(a,34888,d);Ci(a,34952,d);Ci(a,35016,d);g=c[e>>2]|0}if(g&2){Ci(a,35072,d);Ci(a,35136,d);Ci(a,35200,d);g=c[e>>2]|0}if((g&48|0)==16){Ci(a,35256,d);Ci(a,35312,d);Ci(a,35368,d);Ci(a,35432,d)}}Ci(a,35496,d);c[d>>2]=35568;Ci(a,35560,d);if(c[f>>2]|0){c[d>>2]=35608;Ci(a,35600,d)}Ci(a,35664,d);Ci(a,35672,d);Ci(a,35704,d);Ci(a,35760,d)}e=a+2712|0;f=c[e>>2]|0;if(!f){i=b;return}if(f&2){Ci(a,35808,d);Ci(a,35864,d);Ci(a,35928,d);f=c[e>>2]|0}if(f&1){Ci(a,35984,d);Ci(a,36040,d);Ci(a,36104,d);f=c[e>>2]|0}if(f&8){Ci(a,36168,d);Ci(a,36224,d);Ci(a,36288,d);Ci(a,36352,d);f=c[e>>2]|0}if(f&4){Ci(a,36392,d);Ci(a,36456,d);Ci(a,36512,d);f=c[e>>2]|0}if(!(f&16)){i=b;return}Ci(a,36568,d);i=b;return}function ri(a){a=a|0;var b=0,c=0;b=i;i=i+16|0;c=b;Ci(a,36632,c);Ci(a,36688,c);i=b;return}function si(a){a=a|0;var b=0,d=0;b=i;i=i+16|0;d=b;if(!(c[a+140>>2]|0)){i=b;return}Ci(a,36744,d);Ci(a,36808,d);Ci(a,36880,d);Ci(a,36936,d);Ci(a,37008,d);Ci(a,37072,d);Ci(a,37136,d);i=b;return}function ti(a){a=a|0;var b=0,c=0;b=i;i=i+16|0;c=b;Ci(a,37208,c);Ci(a,37216,c);Ci(a,37208,c);i=b;return}function ui(a){a=a|0;var b=0,d=0,e=0;b=i;i=i+16|0;d=b;e=c[a+2740>>2]|0;if(e){c[d>>2]=e;wi(a,0,37256,d)}if(c[a+168>>2]|0){i=b;return}e=c[(c[a+68>>2]|0)+28>>2]|0;e=Vf(Uf(a)|0,e)|0;c[d>>2]=(e|0)!=0?e:37280;wi(a,0,37304,d);if(!(Wf(a)|0)){i=b;return}wi(a,0,37336,d);i=b;return}function vi(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;e=c[a+2688>>2]|0;f=c[a+2684>>2]|0;if(!(e|f)){Ci(a,37496,d);i=b;return}c[d>>2]=e;c[d+4>>2]=(e|0)==1?37408:37416;c[d+8>>2]=f;c[d+12>>2]=(f|0)==1?37432:37440;Ci(a,37376,d);if((c[a+2684>>2]|0)>>>0<=(c[a+352>>2]|0)>>>0?(c[a+144>>2]|0)!=0:0){Ci(a,37488,d);i=b;return}Ci(a,37448,d);i=b;return}function wi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;i=i+16|0;g=f;if((b|0)==0?(c[a+140>>2]|0)==0:0){i=f;return}c[g>>2]=e;Di(a,b,0,0,d,g);i=f;return}function xi(a){a=a|0;var b=0,d=0;b=i;d=0;while(1){if((c[37728+(d<<3)>>2]|0)==(a|0)){d=c[37732+(d<<3)>>2]|0;a=4;break}d=d+1|0;if((d|0)==209){d=0;a=4;break}}if((a|0)==4){i=b;return d|0}return 0}function yi(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;b=i;i=i+16|0;f=b;h=c[a+68>>2]|0;if(!h){g=0;h=0}else{g=c[h>>2]|0;h=c[h+4>>2]|0}c[f>>2]=e;Di(a,1,g,h,d,f);i=b;return}function zi(b,c){b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=i;i=i+48|0;e=d;a[e>>0]=((b|0)%10|0)+48;if((b+9|0)>>>0>=19){f=0;while(1){b=(b|0)/10|0;g=f+1|0;a[e+g>>0]=((b|0)%10|0)+48;if((b+9|0)>>>0<19)break;else f=g}if((f|0)<=-2){g=g+1|0;g=c+g|0;a[g>>0]=0;i=d;return}}else g=0;f=g;while(1){a[c+(g-f)>>0]=a[e+f>>0]|0;if((f|0)>0)f=f+ -1|0;else break}g=g+1|0;g=c+g|0;a[g>>0]=0;i=d;return}function Ai(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;i=i+16|0;g=f;a[d>>0]=0;if(!b){i=f;return}if(Ue(b)|0){c[g>>2]=c[b+32>>2];Ek(d,e,37664,g)|0;i=f;return}h=c[b+44>>2]|0;if((h|0)==13){Ek(d,e,37712,g)|0;i=f;return}else if((h|0)==4){Ek(d,e,37696,g)|0;i=f;return}else if((h|0)==6){c[g>>2]=c[b+32>>2];Ek(d,e,37672,g)|0;i=f;return}else if((h|0)==1){Ek(d,e,37680,g)|0;i=f;return}else{b=c[b+32>>2]|0;if(!b){i=f;return}c[g>>2]=b;Ek(d,e,31704,g)|0;i=f;return}}function Bi(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0;h=i;i=i+16|0;g=h;if(!d){d=c[a+68>>2]|0;if(!d){j=0;d=0}else{j=c[d>>2]|0;d=c[d+4>>2]|0}}else{j=c[d+48>>2]|0;d=c[d+52>>2]|0}c[g>>2]=f;Di(a,b,j,d,e,g);i=h;return}function Ci(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;h=i;i=i+16|0;j=h;if(c[b+148>>2]|0){i=h;return}f=b+2724|0;g=c[f>>2]|0;g=rb[c[c[g>>2]>>2]&15](g,2048)|0;c[j>>2]=e;Dk(g,2048,d,j)|0;d=a[g>>0]|0;if(d<<24>>24){b=b+2668|0;e=g;do{hk(d<<24>>24,c[b>>2]|0);e=e+1|0;d=a[e>>0]|0}while(d<<24>>24!=0)}j=c[f>>2]|0;ob[c[(c[j>>2]|0)+8>>2]&15](j,g);i=h;return}function Di(b,d,e,f,g,h){b=b|0;d=d|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=i;i=i+16|0;m=j;k=b+2724|0;l=c[k>>2]|0;l=rb[c[c[l>>2]>>2]&15](l,2048)|0;p=b+2684|0;o=c[p>>2]|0;q=o>>>0<(c[b+352>>2]|0)>>>0;r=q&1;switch(d|0){case 2:{q=b+2680|0;c[q>>2]=(c[q>>2]|0)+1;break};case 3:{q=b+2692|0;c[q>>2]=(c[q>>2]|0)+1;break};case 1:{r=b+2688|0;c[r>>2]=(c[r>>2]|0)+1;if(q)o=(c[b+144>>2]|0)!=0;else o=0;r=o&1;break};case 5:{q=b+2700|0;c[q>>2]=(c[q>>2]|0)+1;break};case 4:{c[p>>2]=o+1;break};case 0:{q=b+2696|0;c[q>>2]=(c[q>>2]|0)+1;break};default:{}}if(!r){r=c[k>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;ob[q&15](r,l);i=j;return}Dk(l,2048,g,h)|0;g=c[b+2672>>2]|0;if(g)r=sb[g&0](b,d,e,f,l)|0;if(!r){r=c[k>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;ob[q&15](r,l);i=j;return}g=c[k>>2]|0;g=rb[c[c[g>>2]>>2]&15](g,1024)|0;if((e|0)>0&(f|0)>0){a[g>>0]=0;if((c[b+316>>2]|0)!=0?(n=c[b+320>>2]|0,(n|0)!=0):0){c[m>>2]=n;c[m+4>>2]=e;c[m+8>>2]=f;Ek(g,1024,37624,m)|0}else{c[m>>2]=e;c[m+4>>2]=f;Ek(g,1024,37640,m)|0}f=a[g>>0]|0;if(f<<24>>24){m=b+2668|0;n=g;do{hk(f<<24>>24,c[m>>2]|0);n=n+1|0;f=a[n>>0]|0}while(f<<24>>24!=0)}}a[g>>0]=0;switch(d|0){case 5:{sk(g,37600,1024)|0;break};case 1:{sk(g,37544,1024)|0;break};case 2:{sk(g,37560,1024)|0;break};case 6:{sk(g,37616,1024)|0;break};case 4:{sk(g,37592,1024)|0;break};case 0:{sk(g,37536,1024)|0;break};case 3:{sk(g,37576,1024)|0;break};default:{}}n=a[g>>0]|0;if(n<<24>>24){d=b+2668|0;m=g;do{hk(n<<24>>24,c[d>>2]|0);m=m+1|0;n=a[m>>0]|0}while(n<<24>>24!=0)}d=a[l>>0]|0;b=b+2668|0;if(d<<24>>24){m=l;do{hk(d<<24>>24,c[b>>2]|0);m=m+1|0;d=a[m>>0]|0}while(d<<24>>24!=0)}hk(10,c[b>>2]|0);r=c[k>>2]|0;ob[c[(c[r>>2]|0)+8>>2]&15](r,g);r=c[k>>2]|0;q=c[r>>2]|0;q=q+8|0;q=c[q>>2]|0;ob[q&15](r,l);i=j;return}function Ei(a){a=a|0;var b=0;b=i;Dm(a+72|0,0,772)|0;Fi(a);i=b;return}function Fi(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;i=i+16|0;d=b;f=0;e=69160;while(1){if((f|0)!=(c[e>>2]|0)){d=3;break}kj(e,d);lj(a,e,a+(f<<2)+72|0,d);f=f+1|0;if(f>>>0>=94){d=5;break}else e=e+32|0}if((d|0)==3)va(72424,72248,512,72456);else if((d|0)==5){Qe(a,0);i=b;return}}function Gi(a){a=a|0;var b=0;b=i;Fi(a);Hi(a);i=b;return}function Hi(a){a=a|0;var b=0,d=0,e=0;b=i;mj(a);e=0;d=69160;while(1){if((e|0)!=(c[d>>2]|0)){a=3;break}lj(a,d,a+(e<<2)+452|0,a+(e<<2)+72|0);e=e+1|0;if(e>>>0>=94){a=5;break}else d=d+32|0}if((a|0)==3)va(72424,72248,529,72488);else if((a|0)==5){i=b;return}}function Ii(a){a=a|0;var b=0,d=0;b=i;d=69160;while(1){if(!(wk(a,c[d+8>>2]|0)|0)){a=4;break}d=d+32|0;if(d>>>0>=(72168|0)>>>0){d=0;a=4;break}}if((a|0)==4){i=b;return d|0}return 0}function Ji(a){a=a|0;if(a>>>0<94)a=69160+(a<<5)|0;else a=0;return a|0}function Ki(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;g=b>>>0<94;e=g&1;if(!g){i=f;return e|0}if((c[69172+(b<<5)>>2]|0)!=1)va(72200,72248,384,72272);c[a+(b<<2)+72>>2]=d;i=f;return e|0}function Li(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;g=b>>>0<94;e=g&1;if(!g){i=f;return e|0}if((c[69172+(b<<5)>>2]|0)!=2)va(72296,72248,395,72344);c[a+(b<<2)+72>>2]=d;i=f;return e|0}function Mi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=i;i=i+16|0;f=e;g=b>>>0<94&(b|0)!=0;d=g&1;if(!g){i=e;return d|0}g=69160+(b<<5)|0;if((c[g>>2]|0)!=(b|0))va(72368,72248,426,72392);kj(g,f);lj(a,g,a+(b<<2)+72|0,f);i=e;return d|0}function Ni(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;i=i+16|0;d=b;e=nj(a+72|0,a+452|0,d)|0;g=0;f=69160;while(1){if((g|0)!=(c[f>>2]|0)){h=3;break}lj(a,f,a+(g<<2)+72|0,a+(g<<2)+452|0);g=g+1|0;if(g>>>0>=94)break;else f=f+32|0}if((h|0)==3)va(72424,72248,546,72520);if(!e){i=b;return}oj(a,c[d>>2]|0);i=b;return}function Oi(a,b){a=a|0;b=b|0;var c=0;c=i;a=Pi(a,b,72552)|0;i=c;return a|0}function Pi(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;f=i;i=i+8256|0;l=f+8192|0;h=f;j=b+2680|0;k=c[j>>2]|0;n=pj(b,d)|0;g=b+72|0;o=hb(n|0,72560)|0;p=mk(e)|0;if((o|0)==0|(p|0)<0){bi(b,n,2);v=-1;i=f;return v|0}e=b+840|0;c[e>>2]=$j(b,o,p)|0;o=b+836|0;c[o>>2]=qj(g)|0;s=rj(g)|0;if((s|0)!=-1){p=b+2676|0;do{q=l+0|0;r=q+64|0;do{a[q>>0]=0;q=q+1|0}while((q|0)<(r|0));a:do if(!((s|0)==35|(s|0)==47)){q=0;while(1){if((s|0)==10|(s|0)==-1)break a;else if((s|0)==58)break;a[l+q>>0]=s;q=q+1|0;s=sj(g)|0;if(q>>>0>=63){m=8;break}}if((m|0)==8?(m=0,(s|0)!=58):0)break;q=Ii(l)|0;sj(g)|0;if(q){rb[c[q+20>>2]&15](b,q)|0;break}if(!(c[p>>2]|0)){ci(b,l);break}r=rj(g)|0;if((r|0)==34|(r|0)==39)v=sj(g)|0;else{v=r;r=0}q=(r|0)!=0;s=0;t=0;b:while(1){while(1){if((v|0)==10|(v|0)==13|(v|0)==-1)break b;if(q&(v|0)==(r|0))break b;u=(mf(v)|0)==0;if(u|t)break;v=sj(g)|0}t=s+1|0;a[h+s>>0]=u?v&255:32;v=sj(g)|0;if(t>>>0>=8190){s=t;break}else{s=t;t=1}}a[h+s>>0]=0;if(!(rb[c[p>>2]&15](l,h)|0))ci(b,l)}while(0);do{q=c[o>>2]|0;while(1){if((q|0)==13){m=27;break}else if((q|0)==-1|(q|0)==10)break;q=qj(g)|0;c[o>>2]=q}if((m|0)==27){m=0;q=qj(g)|0;c[o>>2]=q}if((q|0)==10){q=qj(g)|0;c[o>>2]=q}}while((mf(q)|0)!=0);s=c[o>>2]|0}while((s|0)!=-1)}Cc((c[e>>2]|0)+304|0,1);_j(c[e>>2]|0);c[e>>2]=0;if((n|0)!=(d|0)){v=c[b+2724>>2]|0;ob[c[(c[v>>2]|0)+8>>2]&15](v,n)}mj(b);v=(c[j>>2]|0)>>>0>k>>>0&1;i=f;return v|0}function Qi(a,b){a=a|0;b=b|0;var c=0;c=i;a=mk(b)|0;i=c;return a|0}function Ri(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=Ii(b)|0;do if(!g){g=c[a+2676>>2]|0;if((g|0)!=0?(f=rb[g&15](b,d)|0,(f|0)!=0):0)break;ci(a,b);f=0}else f=Si(a,c[g>>2]|0,d)|0;while(0);i=e;return f|0}function Si(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;i=i+32|0;f=e;if(b>>>0<94&(d|0)!=0){Ej(f,c[a+2724>>2]|0);Hj(f,d,(qk(d)|0)+1|0);g=a+840|0;c[g>>2]=ak(a,f,1)|0;c[a+836>>2]=qj(a+72|0)|0;d=rb[c[69160+(b<<5)+20>>2]&15](a,69160+(b<<5)|0)|0;_j(c[g>>2]|0);c[g>>2]=0;Ij(f);i=e;return d|0}else{di(a,c[69168+(b<<5)>>2]|0);g=0;i=e;return g|0}return 0}function Ti(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;c=i;switch(b|0){case 1:{e=3;d=1;break};case 12:case 13:case 11:case 10:case 9:case 5:case 4:case 3:case 0:{e=b;d=b;break};case 2:case 8:case 7:case 6:{e=b;d=1;break};default:{e=0;i=c;return e|0}}Ki(a,4,b)|0;Ki(a,5,e)|0;Ki(a,6,d)|0;e=1;i=c;return e|0}function Ui(a){a=a|0;var b=0;b=i;a=kk(a)|0;i=b;return((a|0)!=0?a:72568)|0}function Vi(a){a=a|0;var b=0;b=i;a=lk(a)|0;i=b;return((a|0)!=0?a:72568)|0}function Wi(a){a=a|0;return 1}function Xi(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if(!b)va(72576,72248,1561,72592);d=c[b>>2]|0;e=d;if((d|0)!=0&d>>>0<94>>>0){d=e+1|0;e=69160+(e<<5)|0}else{d=e;e=0}c[b>>2]=d>>>0<94?d:0;i=a;return e|0}function Yi(a){a=a|0;var b=0;b=i;if((a|0)!=0?(c[a+24>>2]|0)!=0:0)a=1;else a=0;i=b;return a|0}function Zi(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;if(!((a|0)!=0&(b|0)!=0))va(72616,72248,1587,72648);h=c[b>>2]|0;g=h;if(((h|0)!=0&h>>>0<16>>>0?(f=c[a+24>>2]|0,(f|0)!=0):0)?(e=c[f+(g+ -1<<2)>>2]|0,(e|0)!=0):0)if(!(c[f+(g<<2)>>2]|0))a=0;else a=g+1|0;else{a=0;e=0}c[b>>2]=a;i=d;return e|0}function _i(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=a+72|0;f=rj(e)|0;if(!(of(f)|0)){di(a,c[b+8>>2]|0);g=0;i=d;return g|0}else g=0;do{g=f+ -48+(g*10|0)|0;f=sj(e)|0}while((of(f)|0)!=0);Ki(a,c[b>>2]|0,g)|0;g=1;i=d;return g|0}function $i(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+64|0;f=e;g=f+0|0;h=g+64|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0));g=b+72|0;j=rj(g)|0;a:do if((j|0)==-1)h=0;else{h=0;while(1){if(mf(j)|0)break a;k=h+1|0;a[f+h>>0]=vf(j)|0;j=sj(g)|0;if(!(k>>>0<62&(j|0)!=-1)){h=k;break}else h=k}}while(0);a[f+h>>0]=0;f=mk(f)|0;if((f|0)<0){di(b,c[d+8>>2]|0);k=0;i=e;return k|0}Ki(b,c[d>>2]|0,f)|0;if((c[d>>2]|0)!=4){k=1;i=e;return k|0}Ti(b,f)|0;k=1;i=e;return k|0}function aj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;e=i;i=i+16|0;f=e;g=f+0|0;h=g+16|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0));h=f+16|0;g=b+72|0;k=rj(g)|0;a:do if((k|0)==-1)j=f;else{j=f;while(1){if(mf(k)|0)break a;if((k|0)==10|(k|0)==13)break a;l=j+1|0;a[j>>0]=k;k=sj(g)|0;if(!((k|0)!=-1&l>>>0<h>>>0)){j=l;break}else j=l}}while(0);a[j>>0]=0;if(wk(f,74848)|0)if(wk(f,74856)|0)if(!(wk(f,74864)|0))f=2;else{di(b,c[d+8>>2]|0);l=-1;l=l>>>31;l=l^1;i=e;return l|0}else f=1;else f=0;Ki(b,c[d>>2]|0,f)|0;l=f;l=l>>>31;l=l^1;i=e;return l|0}function bj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+32|0;f=e;g=f+0|0;h=g+32|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0));g=b+72|0;j=rj(g)|0;a:do if((j|0)==-1)h=0;else if((j|0)==34|(j|0)==39){dj(b,d)|0;Ki(b,8,5)|0;k=1;i=e;return k|0}else{h=0;while(1){if(mf(j)|0)break a;k=h+1|0;a[f+h>>0]=j;j=sj(g)|0;if(!(k>>>0<31&(j|0)!=-1)){h=k;break}else h=k}}while(0);a[f+h>>0]=0;if(wk(f,74728)|0)if(wk(f,74768)|0)if(wk(f,74776)|0)if(wk(f,74784)|0)if((wk(f,74792)|0)!=0?(wk(f,74800)|0)!=0:0){di(b,c[d+8>>2]|0);k=0;i=e;return k|0}else f=4;else f=3;else f=1;else f=0;else f=2;Ki(b,8,f)|0;k=1;i=e;return k|0}function cj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;i=i+64|0;e=f;g=e+0|0;h=g+64|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0));g=b+72|0;j=rj(g)|0;a:do if((j|0)==-1)h=0;else{h=0;while(1){if(mf(j)|0)break a;k=h+1|0;a[e+h>>0]=j;j=sj(g)|0;if(!(k>>>0<63&(j|0)!=-1)){h=k;break}else h=k}}while(0);a[e+h>>0]=0;if(!(wk(e,74736)|0)){c[b+112>>2]=0;k=1;i=f;return k|0}if(!(wk(e,74752)|0)){c[b+112>>2]=1;k=1;i=f;return k|0}else{di(b,c[d+8>>2]|0);k=0;i=f;return k|0}return 0}function dj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;e=i;i=i+8192|0;f=e;g=b+72|0;j=rj(g)|0;if((j|0)==34|(j|0)==39)m=sj(g)|0;else{m=j;j=0}h=(j|0)!=0;k=0;l=0;a:while(1){while(1){if((m|0)==10|(m|0)==13|(m|0)==-1)break a;if(h&(m|0)==(j|0))break a;n=(mf(m)|0)==0;if(n|l)break;m=sj(g)|0}l=k+1|0;a[f+k>>0]=n?m&255:32;m=sj(g)|0;if(l>>>0>=8190){k=l;break}else{k=l;l=1}}a[f+k>>0]=0;tj(b,c[d>>2]|0,f);i=e;return 1}function ej(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;i=i+1024|0;e=f;Dm(e|0,0,1024)|0;g=b+72|0;j=rj(g)|0;if((j|0)!=-1){h=0;while(1){if(mf(j)|0)break;k=h+1|0;a[e+h>>0]=j;j=sj(g)|0;if(!(k>>>0<1022&(j|0)!=-1)){h=k;break}else h=k}a[e+h>>0]=0;if(h){tj(b,c[d>>2]|0,e);k=h;k=(k|0)!=0;k=k&1;i=f;return k|0}}else a[e>>0]=0;di(b,c[d+8>>2]|0);k=0;k=(k|0)!=0;k=k&1;i=f;return k|0}function fj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=0;d=uj(0,a,b,f)|0;if(!d){i=e;return d|0}Li(a,c[b>>2]|0,(c[f>>2]|0)!=0&1)|0;i=e;return d|0}function gj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=0;d=uj(2,a,b,f)|0;if(!d){i=e;return d|0}Ki(a,c[b>>2]|0,c[f>>2]|0)|0;i=e;return d|0}function hj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;i=i+256|0;f=e;Dm(f|0,0,256)|0;g=b+72|0;j=rj(g)|0;if((j|0)!=-1){h=0;while(1){if(mf(j)|0)break;k=h+1|0;a[f+h>>0]=j;j=sj(g)|0;if(!(k>>>0<254&(j|0)!=-1)){h=k;break}else h=k}g=f+h|0;a[g>>0]=0;if((h|0)!=0?(Tc(f)|0)!=0:0){a[g>>0]=45;a[f+(h+1)>>0]=0;tj(b,c[d>>2]|0,f);k=1;i=e;return k|0}}else a[f>>0]=0;di(b,c[d+8>>2]|0);k=0;i=e;return k|0}function ij(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;i=i+1024|0;h=f;j=b+72|0;m=rj(j)|0;k=c[d>>2]|0;if((k|0)==83)g=8;else if((k|0)==81)g=4;else if((k|0)==80)g=2;else if((k|0)==82)g=1;else{ci(b,c[d+8>>2]|0);n=0;i=f;return n|0}tj(b,k,0);Qe(b,g);k=b+832|0;c[k>>2]=c[k>>2]|g;k=0;do if(!((m|0)==9|(m|0)==32|(m|0)==44)){if((m|0)==10|(m|0)==13){l=sj(j)|0;if((l|0)==10&(m|0)==13)m=sj(j)|0;else m=l;if(!(mf(m)|0)){e=15;break}}if((m|0)==-1){e=11;break}else n=0;while(1){if(!((mf(m)|0)==0&(m|0)!=44)){l=n;break}l=n+1|0;a[h+n>>0]=m;m=sj(j)|0;if(l>>>0<1022&(m|0)!=-1)n=l;else break}a[h+l>>0]=0;if(l){vj(b,c[d>>2]|0,g,h);k=k+1|0}}else m=sj(j)|0;while((m|0)!=-1);if((e|0)==11)a[h>>0]=0;else if((e|0)==15){a[h>>0]=0;n=b+840|0;dk(m,c[n>>2]|0);dk(10,c[n>>2]|0)}n=(k|0)!=0&1;i=f;return n|0}function jj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;f=i;i=i+64|0;e=f;g=e+0|0;h=g+64|0;do{a[g>>0]=0;g=g+1|0}while((g|0)<(h|0));g=b+72|0;j=rj(g)|0;a:do if((j|0)==-1)h=0;else{h=0;while(1){if(mf(j)|0)break a;k=h+1|0;a[e+h>>0]=j;j=sj(g)|0;if(!(k>>>0<63&(j|0)!=-1)){h=k;break}else h=k}}while(0);a[e+h>>0]=0;if(!(wk(e,74544)|0)){c[b+436>>2]=1;k=1;i=f;return k|0}if(!(wk(e,74536)|0)){c[b+436>>2]=0;k=1;i=f;return k|0}else{di(b,c[d+8>>2]|0);k=0;i=f;return k|0}return 0}function kj(a,b){a=a|0;b=b|0;var d=0;d=i;if(!(c[a+12>>2]|0)){c[b>>2]=c[a+28>>2];i=d;return}else{c[b>>2]=c[a+16>>2];i=d;return}}function lj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;if(!d)va(72736,72248,351,72752);wj(a,b,d);if(c[b+12>>2]|0){c[d>>2]=c[e>>2];i=f;return}e=c[e>>2]|0;if((e|0)!=0?(e|0)!=(c[b+28>>2]|0):0){c[d>>2]=pk(c[a+2724>>2]|0,e)|0;i=f;return}c[d>>2]=e;i=f;return}function mj(a){a=a|0;var b=0,d=0;b=i;if(c[a+300>>2]|0)Li(a,56,1)|0;if(!(c[a+152>>2]|0))Ki(a,1,0)|0;if(!(c[a+80>>2]|0))Ki(a,2,2147483647)|0;if(c[a+308>>2]|0){d=a+832|0;c[d>>2]=c[d>>2]|2;Me(a,2,72696)}d=a+168|0;if(c[d>>2]|0)Li(a,26,0)|0;if(c[a+176>>2]|0){Li(a,25,1)|0;Li(a,29,0)|0;Li(a,30,0)|0}if(c[d>>2]|0){Li(a,25,1)|0;Li(a,54,1)|0}d=a+96|0;switch(c[d>>2]|0){case 0:case 9:case 10:case 11:case 4:case 1:break;default:if(c[a+172>>2]|0)Li(a,28,1)|0}if(!(c[a+172>>2]|0)){i=b;return}if(((c[d>>2]|0)+ -9|0)>>>0<3)Ki(a,77,1)|0;Li(a,45,1)|0;Li(a,23,0)|0;i=b;return}function nj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;f=i;c[d>>2]=0;g=0;e=69160;j=0;while(1){if((g|0)!=(c[e>>2]|0)){h=3;break}if((g|0)==83)if(!(xj(e,a+332|0,b+332|0)|0)){c[d>>2]=c[d>>2]|8;j=1;h=14}else h=13;else if((g|0)==80)if(!(xj(e,a+320|0,b+320|0)|0)){c[d>>2]=c[d>>2]|2;j=1;h=14}else h=13;else if((g|0)==82)if(!(xj(e,a+328|0,b+328|0)|0)){c[d>>2]=c[d>>2]|1;j=1;h=14}else h=13;else if((g|0)==81)if(!(xj(e,a+324|0,b+324|0)|0)){c[d>>2]=c[d>>2]|4;j=1;h=14}else h=13;else h=14;if((h|0)==13){g=g+1|0;e=e+32|0;continue}else if((h|0)==14){g=g+1|0;if(g>>>0<94){e=e+32|0;continue}else{h=15;break}}}if((h|0)==3)va(72424,72248,468,72712);else if((h|0)==15){i=f;return j|0}return 0}function oj(a,b){a=a|0;b=b|0;var c=0;c=i;if(b&2){Qe(a,2);yj(a,80)}if(b&4){Qe(a,4);yj(a,81)}if(b&1){Qe(a,1);yj(a,82)}if(!(b&8)){i=c;return}Qe(a,8);yj(a,83);i=c;return}function pj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if(!d){g=0;i=e;return g|0}if((a[d>>0]|0)!=126){g=d;i=e;return g|0}g=d+1|0;if((a[g>>0]|0)!=47){g=d;i=e;return g|0}f=Va(72704)|0;h=(f|0)==0;d=h?d:g;if(h){h=d;i=e;return h|0}h=qk(d)|0;h=h+1+(qk(f)|0)|0;g=c[b+2724>>2]|0;h=rb[c[c[g>>2]>>2]&15](g,h)|0;tk(h,f)|0;uk(h,d)|0;i=e;return h|0}function qj(a){a=a|0;var b=0;b=i;a=c[a+768>>2]|0;if(!a)a=-1;else a=ck(a)|0;i=b;return a|0}function rj(a){a=a|0;var b=0,d=0,e=0;b=i;d=a+764|0;a:do if(mf(c[d>>2]|0)|0)do{if(nf(c[d>>2]|0)|0)break a;e=qj(a)|0;c[d>>2]=e}while((mf(e)|0)!=0);while(0);i=b;return c[d>>2]|0}function sj(a){a=a|0;var b=0,d=0;b=i;d=a+764|0;if((c[d>>2]|0)==-1)a=-1;else{a=qj(a)|0;c[d>>2]=a}i=b;return a|0}function tj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=69160+(b<<5)|0;if(b>>>0>=94){i=e;return}if((c[f>>2]|0)!=(b|0))va(74656,72248,372,74712);if(c[69172+(b<<5)>>2]|0)va(74656,72248,372,74712);b=a+(b<<2)+72|0;wj(a,f,b);c[b>>2]=pk(c[a+2724>>2]|0,d)|0;i=e;return}function uj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;g=rj(b+72|0)|0;a:do switch(g|0){case 49:case 84:case 89:case 116:case 121:{c[e>>2]=1;e=1;break};case 48:case 70:case 78:case 102:case 110:{c[e>>2]=0;e=1;break};default:if((a|0)==2&(g&-33|0)==65){c[e>>2]=2;e=1;break a}else{di(b,c[d+8>>2]|0);e=0;break a}}while(0);i=f;return e|0}function vj(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;g=c[a+(b<<2)+72>>2]|0;if(!g){g=0;h=e}else{h=qk(e)|0;h=h+3+(qk(g)|0)|0;h=rk(c[a+2724>>2]|0,g,h)|0;uk(h,74648)|0;uk(h,e)|0;g=h}Me(a,d,e);tj(a,b,h);if(!g){i=f;return}h=c[a+2724>>2]|0;ob[c[(c[h>>2]|0)+8>>2]&15](h,g);i=f;return}function wj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if(c[b+12>>2]|0){i=e;return}d=c[d>>2]|0;if(!d){i=e;return}if((d|0)==(c[b+28>>2]|0)){i=e;return}b=c[a+2724>>2]|0;ob[c[(c[b>>2]|0)+8>>2]&15](b,d);i=e;return}function xj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if(!(c[a+12>>2]|0)){b=c[b>>2]|0;d=c[d>>2]|0;if((b|0)!=(d|0))if((b|0)==0|(d|0)==0)d=0;else d=(vk(b,d)|0)==0&1;else d=1}else d=(c[b>>2]|0)==(c[d>>2]|0)&1;i=e;return d|0}function yj(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=a+2724|0;e=pk(c[f>>2]|0,c[a+(b<<2)+72>>2]|0)|0;Si(a,b,e)|0;a=c[f>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,e);i=d;return}function zj(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=c[18746]|0;if(!e)e=Tl(b)|0;else e=pb[e&15](b)|0;if(e){i=d;return e|0}Cj(a,75064);i=d;return e|0}function Aj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if(b){f=c[18748]|0;if(!f)b=Vl(b,d)|0;else b=rb[f&15](b,d)|0;if(!b){Cj(a,75064);b=0}}else b=zj(a,d)|0;i=e;return b|0}function Bj(a,b){a=a|0;b=b|0;var d=0;a=i;do if(b){d=c[18750]|0;if(!d){Ul(b);break}else{nb[d&0](b);break}}while(0);i=a;return}function Cj(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;i=i+16|0;a=d;e=c[18752]|0;if(!e){e=c[o>>2]|0;c[a>>2]=b;cb(e|0,75040,a|0)|0;ib(2)}else{nb[e&0](b);i=d;return}}function Dj(a,b){a=a|0;b=b|0;c[a+4>>2]=6;c[a+12>>2]=7;c[a+8>>2]=11;c[a>>2]=b;return}function Ej(a,b){a=a|0;b=b|0;var d=0;d=i;if(!a)va(140960,140976,70,141e3);else{c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a>>2]=(b|0)!=0?b:75032;i=d;return}}function Fj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if(!a)va(140960,140976,117,141048);f=c[a>>2]|0;if(!f){c[a>>2]=75032;f=75032}g=b+1|0;b=a+12|0;h=c[b>>2]|0;if(g>>>0<=h>>>0){i=e;return}d=(h|0)==0?(d|0)==0?256:d:h;while(1)if(d>>>0<g>>>0)d=d<<1;else break;a=a+4|0;f=mb[c[(c[f>>2]|0)+4>>2]&3](f,c[a>>2]|0,d)|0;if(!f){i=e;return}h=c[b>>2]|0;Dm(f+h|0,0,d-h|0)|0;c[a>>2]=f;c[b>>2]=d;i=e;return}function Gj(a){a=a|0;var b=0,d=0;b=i;if(!a)va(140960,140976,86,141032);else{d=c[a>>2]|0;ob[c[(c[d>>2]|0)+8>>2]&15](d,c[a+4>>2]|0);Ej(a,c[a>>2]|0);i=b;return}}function Hj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if(!a)va(140960,140976,146,141072);c[a+4>>2]=b;c[a+12>>2]=d;c[a+8>>2]=d;c[a+16>>2]=0;if(c[a>>2]|0){i=e;return}c[a>>2]=75032;i=e;return}function Ij(a){a=a|0;var b=0;b=i;Ej(a,c[a>>2]|0);i=b;return}function Jj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;if(!b)va(140960,140976,178,141088);else{g=b+8|0;Fj(b,(c[g>>2]|0)+1|0,0);f=c[g>>2]|0;c[g>>2]=f+1;a[(c[b+4>>2]|0)+f>>0]=d;i=e;return}}function Kj(a){a=a|0;var b=0,e=0,f=0;b=i;if(!a)va(140960,140976,187,141104);f=a+8|0;e=c[f>>2]|0;if(!e){f=-1;i=b;return f|0}e=e+ -1|0;c[f>>2]=e;f=d[(c[a+4>>2]|0)+e>>0]|0;i=b;return f|0}function Lj(a){a=a|0;var b=0,e=0,f=0;b=i;f=a+16|0;e=c[f>>2]|0;if(e>>>0>=(c[a+8>>2]|0)>>>0){f=-1;i=b;return f|0}c[f>>2]=e+1;f=d[(c[a+4>>2]|0)+e>>0]|0;i=b;return f|0}function Mj(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=b+16|0;f=c[g>>2]|0;if(!f){i=e;return}f=f+ -1|0;c[g>>2]=f;if((a[(c[b+4>>2]|0)+f>>0]|0)==d<<24>>24){i=e;return}else va(141120,140976,215,141152)}function Nj(a){a=a|0;var b=0;b=i;a=Lj(a)|0;i=b;return a|0}function Oj(a){a=a|0;return(c[a+16>>2]|0)>>>0>=(c[a+8>>2]|0)>>>0|0}function Pj(a,b){a=a|0;b=b|0;var c=0;c=i;Mj(a,b);i=c;return}function Qj(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=rb[c[c[a>>2]>>2]&15](a,24)|0;if(!f){b=-1;i=e;return b|0}c[f+0>>2]=0;c[f+4>>2]=0;c[f+8>>2]=0;c[f+12>>2]=0;c[f+16>>2]=0;c[f+20>>2]=0;c[f+4>>2]=a;c[f>>2]=d;c[b+4>>2]=8;c[b+12>>2]=9;c[b+8>>2]=12;c[b>>2]=f;b=0;i=e;return b|0}function Rj(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;a=c[a>>2]|0;if((b|0)!=0&(a|0)!=0?(d=c[a>>2]|0,(d|0)!=0):0)Na(d|0)|0;b=a+4|0;Gj(b);b=c[b>>2]|0;ob[c[(c[b>>2]|0)+8>>2]&15](b,a);i=e;return}function Sj(a,b){a=a|0;b=b|0;var c=0;c=i;Za(b&255|0,a|0)|0;i=c;return}function Tj(a,b){a=a|0;b=b|0;c[a+4>>2]=9;c[a>>2]=b;return}function Uj(a){a=a|0;var b=0;b=i;if(!(c[a+12>>2]|0)){a=Ta(c[a>>2]|0)|0;i=b;return a|0}else{a=Kj(a+4|0)|0;i=b;return a|0}return 0}function Vj(a){a=a|0;var b=0,d=0;b=i;d=(c[a+12>>2]|0)==0;if(!d){d=d&1;i=b;return d|0}d=(Oa(c[a>>2]|0)|0)!=0&1;i=b;return d|0}function Wj(a,b){a=a|0;b=b|0;var c=0;c=i;Jj(a+4|0,b);i=c;return}function Xj(){if(!(c[35298]|0))c[35298]=c[o>>2];return 141176}function Yj(a,b){a=a|0;b=b|0;var d=0;d=i;if(!((b|0)!=0&(b|0)!=141176&(b|0)!=141200)){i=d;return}if(!(c[b+12>>2]|0))Na(c[b+16>>2]|0)|0;a=c[a+2724>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,b);i=d;return}function Zj(a,d){a=a|0;d=d|0;var e=0,f=0,g=0;f=i;g=a+2724|0;e=c[g>>2]|0;e=rb[c[c[e>>2]>>2]&15](e,324)|0;Dm(e|0,0,320)|0;c[e+292>>2]=1;c[e+288>>2]=1;c[e+296>>2]=d;c[e>>2]=0;c[e+320>>2]=a;c[e+20>>2]=5;d=c[g>>2]|0;c[e+8>>2]=d;c[e+12>>2]=rb[c[c[d>>2]>>2]&15](d,20)|0;b[e+284>>1]=0;b[e+286>>1]=0;i=f;return e|0}function _j(a){a=a|0;var b=0,d=0,e=0;b=i;d=a+8|0;e=c[d>>2]|0;ob[c[(c[e>>2]|0)+8>>2]&15](e,c[a+12>>2]|0);d=c[d>>2]|0;ob[c[(c[d>>2]|0)+8>>2]&15](d,a);i=b;return}function $j(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;d=Zj(a,d)|0;if(!(Bc(c[a+2724>>2]|0,d+304|0,b)|0)){c[d+300>>2]=0;i=e;return d|0}else{_j(d);d=0;i=e;return d|0}return 0}function ak(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;a=Zj(a,d)|0;Dj(a+304|0,b);c[a+300>>2]=1;i=e;return a|0}function bk(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;b=i;g=a+308|0;d=a+304|0;e=pb[c[g>>2]&15](c[d>>2]|0)|0;if((e|0)==-1){h=-1;i=b;return h|0}f=pb[c[g>>2]&15](c[d>>2]|0)|0;if((f|0)==-1){ob[c[a+312>>2]&15](c[d>>2]|0,e&255);h=-1;i=b;return h|0}h=f+(e<<8)|0;if((h|0)==65279){if((c[a+296>>2]&-2|0)==10){h=10;i=b;return h|0}ei(c[a+320>>2]|0,80,10);h=10;i=b;return h|0}else if((h|0)==65534){h=c[a+296>>2]|0;if((h|0)==9|(h|0)==11){h=9;i=b;return h|0}ei(c[a+320>>2]|0,80,9);h=9;i=b;return h|0}else{g=pb[c[g>>2]&15](c[d>>2]|0)|0;if((g|0)==-1){h=a+312|0;ob[c[h>>2]&15](c[d>>2]|0,f&255);ob[c[h>>2]&15](c[d>>2]|0,e&255);h=-1;i=b;return h|0}if(((f<<8)+(e<<16)+g|0)!=15711167){h=a+312|0;ob[c[h>>2]&15](c[d>>2]|0,g&255);ob[c[h>>2]&15](c[d>>2]|0,f&255);ob[c[h>>2]&15](c[d>>2]|0,e&255);h=-1;i=b;return h|0}if((c[a+296>>2]|0)==4){h=4;i=b;return h|0}ei(c[a+320>>2]|0,80,4);h=4;i=b;return h|0}return 0}function ck(a){a=a|0;var b=0,d=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;b=i;k=a+320|0;g=c[(c[k>>2]|0)+84>>2]|0;d=a+4|0;if(c[d>>2]|0){g=a+16|0;f=c[g>>2]|0;if(!f)va(142800,142816,514,142840);r=f+ -1|0;c[g>>2]=r;f=c[(c[a+12>>2]|0)+(r<<2)>>2]|0;if(!r)c[d>>2]=0;d=a+288|0;if((f|0)==10){c[d>>2]=1;r=a+292|0;c[r>>2]=(c[r>>2]|0)+1;nk(a);r=10;i=b;return r|0}else{c[d>>2]=(c[d>>2]|0)+1;nk(a);r=f;i=b;return r|0}}nk(a);d=a+288|0;c[a+((e[a+284>>1]|0)<<2)+28>>2]=c[d>>2];h=a+24|0;l=c[h>>2]|0;if((l|0)>0){c[d>>2]=(c[d>>2]|0)+1;c[h>>2]=l+ -1;r=32;i=b;return r|0}m=a+296|0;l=a+292|0;a:while(1){n=ok(a)|0;if((n|0)==10){f=13;break}else if((n|0)==-1){a=-1;f=54;break}else if((n|0)==9){f=14;break}else if((n|0)==13){f=17;break}if((n|0)==27){a=27;f=54;break}if(n>>>0<32)continue;o=c[m>>2]|0;switch(o|0){case 12:case 13:case 4:case 5:case 0:{f=23;break a};case 10:case 11:case 9:{do if(Jk(n)|0){if(Lk(n)|0){o=ok(a)|0;if((o|0)==-1){a=-1;f=54;break a}if((Kk(o)|0)!=0?(j=Mk(o,n)|0,!((Ok(j)|0)==0|(j|0)==0)):0){n=j;break}fi(c[k>>2]|0,79,0,1);n=0}}else{fi(c[k>>2]|0,79,n,1);n=0}while(0);o=c[m>>2]|0;break};default:{}}if((o|0)==8){if((n&-128|0)==128)n=c[142288+(n+ -128<<2)>>2]|0}else if((o|0)==2){if((n+ -160|0)>>>0<31)switch(n|0){case 164:{n=8364;f=52;break a};case 189:{f=42;break a};case 184:{f=40;break a};case 188:{f=41;break a};case 166:{n=352;break a};case 190:{f=43;break a};case 168:{f=38;break a};case 180:{f=39;break a};default:{}}}else if((o|0)==6)n=ek(n)|0;if((n&-32|0)==128){o=(o&-2|0)==6;p=c[k>>2]|0;q=c[p+68>>2]|0;if(q){c[q>>2]=c[l>>2];c[q+4>>2]=c[d>>2]}r=fk(n)|0;s=(r|0)==0;q=s&1;if(s&o){fi(p,76,n,q);continue}if(o)n=r;else{fi(p,77,n,q);n=r}}if(n){f=52;break}}switch(f|0){case 13:{c[d>>2]=1;c[l>>2]=(c[l>>2]|0)+1;s=10;i=b;return s|0};case 14:{a=c[d>>2]|0;if(!g)f=0;else f=g+ -1-(((a+ -1|0)>>>0)%(g>>>0)|0)|0;c[h>>2]=f;c[d>>2]=a+1;s=32;i=b;return s|0};case 17:{f=ok(a)|0;if((f|0)!=10)dk(f,a);c[d>>2]=1;c[l>>2]=(c[l>>2]|0)+1;s=10;i=b;return s|0};case 23:{c[d>>2]=(c[d>>2]|0)+1;s=n;i=b;return s|0};case 38:{n=353;break};case 39:{n=381;break};case 40:{n=382;break};case 41:{n=338;break};case 42:{n=339;break};case 43:{n=376;break};case 52:break;case 54:{i=b;return a|0}}c[d>>2]=(c[d>>2]|0)+1;s=n;i=b;return s|0}function dk(a,d){a=a|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;e=i;if((a|0)==-1){i=e;return}c[d+4>>2]=1;f=d+16|0;g=c[f>>2]|0;h=d+20|0;j=c[h>>2]|0;if((g+1|0)>>>0<j>>>0)h=c[d+12>>2]|0;else{l=c[d+8>>2]|0;m=c[(c[l>>2]|0)+4>>2]|0;g=d+12|0;k=c[g>>2]|0;j=j+1|0;c[h>>2]=j;h=mb[m&3](l,k,j<<2)|0;c[g>>2]=h;g=c[f>>2]|0}c[f>>2]=g+1;c[h+(g<<2)>>2]=a;if((a|0)==10){m=d+292|0;c[m>>2]=(c[m>>2]|0)+ -1}a=d+284|0;f=b[a>>1]|0;if((b[d+286>>1]|0)==f<<16>>16){c[d+288>>2]=0;i=e;return}c[d+288>>2]=c[d+((f&65535)<<2)+28>>2];if(!(f<<16>>16)){b[a>>1]=64;f=64}b[a>>1]=f+ -1<<16>>16;i=e;return}function ek(a){a=a|0;if(a>>>0>127)a=c[141360+(a+ -128<<2)>>2]|0;return a|0}function fk(a){a=a|0;if((a&-32|0)==128)a=c[141232+(a+ -128<<2)>>2]|0;return a|0}function gk(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;a=c[a+2724>>2]|0;a=rb[c[c[a>>2]>>2]&15](a,24)|0;c[a+0>>2]=0;c[a+4>>2]=0;c[a+8>>2]=0;c[a+12>>2]=0;c[a+16>>2]=0;c[a+20>>2]=0;c[a>>2]=d;c[a+4>>2]=0;c[a+8>>2]=e;Tj(a+16|0,b);c[a+12>>2]=0;i=f;return a|0}function hk(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;i=i+16|0;g=d+8|0;f=d;do if((a|0)==10){a=c[b+8>>2]|0;if((a|0)==1){hk(13,b);a=10;break}else if((a|0)==2){a=13;break}else{a=10;break}}while(0);switch(c[b>>2]|0){case 2:{switch(a|0){case 8364:{a=164;break};case 381:{a=180;break};case 338:{a=188;break};case 382:{a=184;break};case 339:{a=189;break};case 353:{a=168;break};case 376:{a=190;break};case 352:{a=166;break};default:{}}ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return};case 6:{if(a>>>0<128){ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return}else g=128;while(1){f=g+1|0;if((c[141360+(g+ -128<<2)>>2]|0)==(a|0))break;if((f|0)<256)g=f;else{e=60;break}}if((e|0)==60){i=d;return}ob[c[b+20>>2]&15](c[b+16>>2]|0,g&255);i=d;return};case 11:case 10:case 9:{if(!(Jk(a)|0)){i=d;return}if(Pk(a)|0)if(!(Nk(a,f,f+4|0)|0)){i=d;return}else k=2;else{c[f>>2]=a;k=1}g=b+20|0;h=b+16|0;j=0;do{a=c[f+(j<<2)>>2]|0;e=c[b>>2]|0;if((e|0)==9){ob[c[g>>2]&15](c[h>>2]|0,a&255);ob[c[g>>2]&15](c[h>>2]|0,a>>>8&255)}else if((e|0)==11|(e|0)==10){ob[c[g>>2]&15](c[h>>2]|0,a>>>8&255);ob[c[g>>2]&15](c[h>>2]|0,a&255)}j=j+1|0}while((j|0)<(k|0));i=d;return};case 8:{if(a>>>0<128){ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return}else f=128;while(1){g=f+1|0;if((c[142288+(f+ -128<<2)>>2]|0)==(a|0))break;if((g|0)<256)f=g;else{e=60;break}}if((e|0)==60){i=d;return}ob[c[b+20>>2]&15](c[b+16>>2]|0,f&255);i=d;return};case 7:{if(a>>>0<128|(a+ -160|0)>>>0<96){ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return}else g=128;while(1){f=g+1|0;if((c[141232+(g+ -128<<2)>>2]|0)==(a|0))break;if((f|0)<160)g=f;else{e=60;break}}if((e|0)==60){i=d;return}ob[c[b+20>>2]&15](c[b+16>>2]|0,g&255);i=d;return};case 13:case 12:if(a>>>0<128){ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return}else{j=b+20|0;k=b+16|0;ob[c[j>>2]&15](c[k>>2]|0,a>>>8&255);ob[c[j>>2]&15](c[k>>2]|0,a&255);i=d;return};case 4:{c[g>>2]=0;Gk(a,0,b+16|0,g)|0;if((c[g>>2]|0)>=1){i=d;return}j=b+20|0;k=b+16|0;ob[c[j>>2]&15](c[k>>2]|0,-17);ob[c[j>>2]&15](c[k>>2]|0,-65);ob[c[j>>2]&15](c[k>>2]|0,-65);i=d;return};case 5:{e=b+4|0;a:do if((a|0)==27){c[e>>2]=1;a=27}else switch(c[e>>2]|0){case 1:if((a|0)==36){c[e>>2]=2;a=36;break a}else if((a|0)==40){c[e>>2]=4;a=40;break a}else{c[e>>2]=0;break a};case 4:{c[e>>2]=0;break a};case 2:if((a|0)==40){c[e>>2]=3;a=40;break a}else{c[e>>2]=5;break a};case 3:{c[e>>2]=5;break a};case 5:{a=a&127;break a};default:break a}while(0);ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return};default:{ob[c[b+20>>2]&15](c[b+16>>2]|0,a&255);i=d;return}}}function ik(a){a=a|0;var b=0;b=i;a=pb[c[a+316>>2]&15](c[a+304>>2]|0)|0;i=b;return a|0}function jk(a){a=a|0;var b=0,d=0;b=i;d=c[a>>2]|0;if((d|0)==11|(d|0)==10|(d|0)==9|(d|0)==4)hk(65279,a);i=b;return}function kk(a){a=a|0;var b=0,d=0;b=i;d=0;while(1){if((c[141872+(d*12|0)>>2]|0)==(a|0)){d=c[141876+(d*12|0)>>2]|0;a=4;break}d=d+1|0;if((d&-2|0)==12){d=0;a=4;break}}if((a|0)==4){i=b;return d|0}return 0}function lk(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;e=0;while(1){f=e+1|0;if((c[141872+(e*12|0)>>2]|0)==(a|0))break;if(f>>>0<14)e=f;else{e=0;b=5;break}}if((b|0)==5){i=d;return e|0}f=c[141880+(e*12|0)>>2]|0;i=d;return f|0}function mk(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;e=0;while(1){f=e+1|0;if(!(wk(a,c[141880+(e*12|0)>>2]|0)|0))break;if(f>>>0<14)e=f;else{e=-1;b=5;break}}if((b|0)==5){i=d;return e|0}f=c[141872+(e*12|0)>>2]|0;i=d;return f|0}function nk(a){a=a|0;var c=0,d=0,f=0,g=0;c=i;g=a+284|0;d=e[g>>1]|0;f=d+1&63;b[g>>1]=f;a=a+286|0;if((f|0)!=(e[a>>1]|0|0)){i=c;return}b[a>>1]=d+2&63;i=c;return}function ok(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0;b=i;i=i+16|0;d=b+4|0;f=b;g=a+304|0;a:do if((pb[c[a+316>>2]&15](c[g>>2]|0)|0)==0?(h=a+308|0,e=pb[c[h>>2]&15](c[g>>2]|0)|0,(e|0)!=-1):0){j=c[a+296>>2]|0;switch(j|0){case 4:{c[f>>2]=0;j=(Fk(d,e,0,a+304|0,f)|0)==0;e=c[d>>2]|0;f=j&(e|0)==-1&(c[f>>2]|0)==1;if(f|j){e=f?-1:e;break a}e=c[a+320>>2]|0;j=c[e+68>>2]|0;c[j>>2]=c[a+292>>2];c[j+4>>2]=c[a+288>>2];fi(e,78,c[d>>2]|0,0);c[d>>2]=65533;e=65533;break a};case 9:{a=pb[c[h>>2]&15](c[g>>2]|0)|0;if((a|0)==-1){e=-1;break a}e=(a<<8)+e|0;c[d>>2]=e;break a};case 5:{if((e|0)==27){c[a>>2]=1;e=27;break a}switch(c[a>>2]|0){case 1:if((e|0)==36){c[a>>2]=2;e=36;break a}else if((e|0)==40){c[a>>2]=4;e=40;break a}else{c[a>>2]=0;break a};case 5:{e=e|128;break a};case 3:{c[a>>2]=5;break a};case 4:{c[a>>2]=0;break a};case 2:if((e|0)==40){c[a>>2]=3;e=40;break a}else{c[a>>2]=5;break a};default:break a}};case 10:case 11:{a=pb[c[h>>2]&15](c[g>>2]|0)|0;if((a|0)==-1){e=-1;break a}e=a+(e<<8)|0;c[d>>2]=e;break a};case 13:case 12:{if(e>>>0<128)break a;if((j|0)==13&e>>>0>160&e>>>0<224)break a;a=pb[c[h>>2]&15](c[g>>2]|0)|0;if((a|0)==-1){e=-1;break a}e=a+(e<<8)|0;c[d>>2]=e;break a};default:{c[d>>2]=e;break a}}}else e=-1;while(0);i=b;return e|0}function pk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;e=i;if(!d){f=0;i=e;return f|0}f=qk(d)|0;b=rb[c[c[b>>2]>>2]&15](b,f+1|0)|0;f=b;while(1){g=a[d>>0]|0;a[f>>0]=g;if(!(g<<24>>24))break;else{d=d+1|0;f=f+1|0}}i=e;return b|0}function qk(b){b=b|0;var c=0,d=0;c=i;if((b|0)!=0?(a[b>>0]|0)!=0:0){d=0;do{b=b+1|0;d=d+1|0}while((a[b>>0]|0)!=0)}else d=0;i=c;return d|0}function rk(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0;f=i;if(!((d|0)!=0&(e|0)!=0)){h=0;i=f;return h|0}b=rb[c[c[b>>2]>>2]&15](b,e+1|0)|0;g=b;while(1){if(!e)break;j=a[d>>0]|0;h=g+1|0;a[g>>0]=j;if(!(j<<24>>24)){g=h;break}else{e=e+ -1|0;d=d+1|0;g=h}}a[g>>0]=0;j=b;i=f;return j|0}function sk(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;e=i;if(!((b|0)!=0&(c|0)!=0)){i=e;return d|0}g=a[c>>0]|0;a:do if(g<<24>>24)while(1){d=d+ -1|0;if(!d){d=0;break a}c=c+1|0;f=b+1|0;a[b>>0]=g;g=a[c>>0]|0;if(!(g<<24>>24)){b=f;break}else b=f}while(0);a[b>>0]=0;i=e;return d|0}function tk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;d=i;e=a[c>>0]|0;a[b>>0]=e;if(!(e<<24>>24)){e=0;i=d;return e|0}else e=0;do{b=b+1|0;c=c+1|0;e=e+1|0;f=a[c>>0]|0;a[b>>0]=f}while(f<<24>>24!=0);i=d;return e|0}function uk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;d=i;while(1)if(!(a[b>>0]|0))break;else b=b+1|0;e=a[c>>0]|0;a[b>>0]=e;if(!(e<<24>>24)){e=0;i=d;return e|0}else e=0;do{b=b+1|0;c=c+1|0;e=e+1|0;f=a[c>>0]|0;a[b>>0]=f}while(f<<24>>24!=0);i=d;return e|0}function vk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;d=i;e=a[b>>0]|0;f=a[c>>0]|0;a:do if(e<<24>>24==f<<24>>24){while(1){if(!(e<<24>>24)){c=0;break}b=b+1|0;c=c+1|0;e=a[b>>0]|0;f=a[c>>0]|0;if(e<<24>>24!=f<<24>>24)break a}i=d;return c|0}while(0);f=e<<24>>24>f<<24>>24?1:-1;i=d;return f|0}function wk(b,c){b=b|0;c=c|0;var d=0,e=0,f=0;d=i;e=a[b>>0]|0;f=vf(e<<24>>24)|0;a:do if((f|0)==(vf(a[c>>0]|0)|0)){while(1){if(!(e<<24>>24)){c=0;break}b=b+1|0;c=c+1|0;e=a[b>>0]|0;f=vf(e<<24>>24)|0;if((f|0)!=(vf(a[c>>0]|0)|0))break a}i=d;return c|0}while(0);f=(a[b>>0]|0)>(a[c>>0]|0)?1:-1;i=d;return f|0}function xk(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;e=i;f=a[b>>0]|0;g=a[c>>0]|0;a:do if(f<<24>>24==g<<24>>24){while(1){if(f<<24>>24==0|(d|0)==0){f=0;break}b=b+1|0;c=c+1|0;d=d+ -1|0;f=a[b>>0]|0;g=a[c>>0]|0;if(f<<24>>24!=g<<24>>24)break a}i=e;return f|0}while(0);if(!d){g=0;i=e;return g|0}g=f<<24>>24>g<<24>>24?1:-1;i=e;return g|0}function yk(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;e=i;f=a[b>>0]|0;g=vf(f<<24>>24)|0;a:do if((g|0)==(vf(a[c>>0]|0)|0)){while(1){if(f<<24>>24==0|(d|0)==0){d=0;break}b=b+1|0;c=c+1|0;d=d+ -1|0;f=a[b>>0]|0;g=vf(f<<24>>24)|0;if((g|0)!=(vf(a[c>>0]|0)|0))break a}i=e;return d|0}while(0);if(!d){g=0;i=e;return g|0}g=(a[b>>0]|0)>(a[c>>0]|0)?1:-1;i=e;return g|0}function zk(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=i;e=qk(c)|0;b=b-e|0;a:do if((b|0)<0)g=0;else{f=0;while(1){g=a+f|0;if(!(xk(g,c,e)|0))break a;if((f|0)<(b|0))f=f+1|0;else{g=0;break}}}while(0);i=d;return g|0}function Ak(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=i;d=qk(a)|0;e=qk(b)|0;d=d-e|0;a:do if((d|0)<0)g=0;else{f=0;while(1){g=a+f|0;if(!(yk(g,b,e)|0))break a;if((f|0)<(d|0))f=f+1|0;else{g=0;break}}}while(0);i=c;return g|0}function Bk(b){b=b|0;var c=0,d=0,e=0;c=i;d=a[b>>0]|0;if(!(d<<24>>24)){i=c;return b|0}else e=b;do{a[e>>0]=vf(d<<24>>24)|0;e=e+1|0;d=a[e>>0]|0}while(d<<24>>24!=0);i=c;return b|0}function Ck(b){b=b|0;var c=0,d=0,e=0;c=i;d=a[b>>0]|0;if(!(d<<24>>24)){i=c;return b|0}else e=b;do{a[e>>0]=wf(d<<24>>24)|0;e=e+1|0;d=a[e>>0]|0}while(d<<24>>24!=0);i=c;return b|0}function Dk(b,c,d,e){b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0;f=i;g=c+ -1|0;c=om(b,g,d,e)|0;a[b+g>>0]=0;i=f;return c|0}function Ek(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;i=i+16|0;h=g;c[h>>2]=f;d=d+ -1|0;f=om(b,d,e,h)|0;a[b+d>>0]=0;i=g;return f|0}function Fk(b,e,f,g,h){b=b|0;e=e|0;f=f|0;g=g|0;h=h|0;var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=i;i=i+16|0;n=(f|0)!=0;f=n?f:j;if((e|0)==-1){c[b>>2]=-1;c[h>>2]=1;s=0;i=j;return s|0}do if(e>>>0>=128){if((e&224|0)==192){l=2;k=0;m=e&31;break}if((e&240|0)==224){l=3;k=0;m=e&15;break}if((e&248|0)==240){l=4;k=0;m=e&7;break}if((e&252|0)==248){l=5;k=1;m=e&3;break}else{m=(e&254|0)==252;l=m?6:1;k=1;m=m?e&1:e;break}}else{l=1;k=0;m=e}while(0);a:do if(n){n=l+ -1|0;if((n|0)>0){o=0;g=m;while(1){m=a[f+o>>0]|0;if(!(m<<24>>24))break;m=m&255;if((m&192|0)!=128)break;g=m&63|g<<6;o=o+1|0;if((o|0)>=(n|0))break a}l=o+1|0;k=1}else g=m}else{if(!g){g=l>>>0>1;l=g?1:l;k=g?1:k;g=m;break}p=l+ -1|0;if((p|0)>0){n=g+12|0;o=g+4|0;q=0;while(1){if(pb[c[n>>2]&15](c[g>>2]|0)|0){g=m;break a}r=pb[c[o>>2]&15](c[g>>2]|0)|0;s=r&255;a[f+q>>0]=s;if(!((r|0)!=-1&(r&192|0)==128))break;m=r&63|m<<6;q=q+1|0;if((q|0)>=(p|0)){g=m;break a}}l=q+1|0;if((r|0)==-1){k=1;g=m}else{ob[c[g+8>>2]&15](c[g>>2]|0,s);k=1;g=m}}else g=m}while(0);q=(k|0)==0&(g&-2|0)==65534?1:k;q=(q|0)==0&g>>>0>1114111?1:q;if(!q){n=c[142848+(l+ -1<<2)>>2]|0;k=(c[142848+(l<<2)>>2]|0)+ -1|0;if(g>>>0>=(c[142872+(n*20|0)>>2]|0)>>>0?!((n|0)>(k|0)?1:g>>>0>(c[142876+(k*20|0)>>2]|0)>>>0):0){m=(l|0)>0;e=e&255;q=1;while(1){b:do if(m){p=0;while(1){if(!p)o=e;else o=a[f+(p+ -1)>>0]|0;r=p<<1;if((o&255)<(d[142872+(n*20|0)+r+12>>0]|0)){if(q)break b}else if(!((q|0)==0?1:(o&255)<=(d[(r|1)+(142872+(n*20|0))+12>>0]|0)))break b;p=p+1|0;if((p|0)>=(l|0)){q=0;break}else q=0}}while(0);if((n|0)<(k|0))n=n+1|0;else break}}else q=1}c[h>>2]=l;c[b>>2]=g;s=((q|0)!=0)<<31>>31;i=j;return s|0}function Gk(b,d,e,f){b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,j=0,k=0;g=i;i=i+16|0;j=g;k=j+0|0;h=k+10|0;do{a[k>>0]=0;k=k+1|0}while((k|0)<(h|0));h=(d|0)==0?j:d;do if(b>>>0<128){d=b&255;a[h>>0]=d;j=1;b=1}else{if(b>>>0<2048){d=(b>>>6|192)&255;a[h>>0]=d;a[h+1>>0]=b&63|128;j=2;b=1;break}if(b>>>0<65536){d=(b>>>12|224)&255;a[h>>0]=d;a[h+1>>0]=b>>>6&63|128;a[h+2>>0]=b&63|128;j=3;b=(b&-2|0)!=65534;break}if(b>>>0<2097152){d=(b>>>18|240)&255;a[h>>0]=d;a[h+1>>0]=b>>>12&63|128;a[h+2>>0]=b>>>6&63|128;a[h+3>>0]=b&63|128;j=4;b=b>>>0<1114112;break}if(b>>>0<67108864){a[h>>0]=b>>>24|248;a[h+1>>0]=b>>>18|128;a[h+2>>0]=b>>>12&63|128;a[h+3>>0]=b>>>6&63|128;a[h+4>>0]=b&63|128;d=5;k=0;c[f>>2]=d;k=k^1;k=k<<31>>31;i=g;return k|0}if((b|0)<=-1){d=0;k=0;c[f>>2]=d;k=k^1;k=k<<31>>31;i=g;return k|0}a[h>>0]=b>>>30|252;a[h+1>>0]=b>>>24&63|128;a[h+2>>0]=b>>>18&63|128;a[h+3>>0]=b>>>12&63|128;a[h+4>>0]=b>>>6&63|128;a[h+5>>0]=b&63|128;d=6;k=0;c[f>>2]=d;k=k^1;k=k<<31>>31;i=g;return k|0}while(0);if(!(b&(e|0)!=0)){d=j;k=b;c[f>>2]=d;k=k^1;k=k<<31>>31;i=g;return k|0}b=e+4|0;k=1;while(1){ob[c[b>>2]&15](c[e>>2]|0,d);if((k|0)>=(j|0)){e=1;break}d=a[h+k>>0]|0;k=k+1|0}c[f>>2]=j;k=e^1;k=k<<31>>31;i=g;return k|0}function Hk(b,d){b=b|0;d=d|0;var e=0,f=0,g=0;f=i;i=i+16|0;g=f+4|0;e=f;c[e>>2]=0;if(!(Fk(g,a[b>>0]|0,b+1|0,0,e)|0))g=c[g>>2]|0;else{c[g>>2]=65533;g=65533}c[d>>2]=g;i=f;return(c[e>>2]|0)+ -1|0}function Ik(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;i=i+16|0;f=e;c[f>>2]=0;if(!(Gk(d,b,0,f)|0)){d=c[f>>2]|0;d=b+d|0;i=e;return d|0}else{a[b>>0]=-17;a[b+1>>0]=-65;a[b+2>>0]=-67;c[f>>2]=3;d=3;d=b+d|0;i=e;return d|0}return 0}function Jk(a){a=a|0;return a>>>0<1114112|0}function Kk(a){a=a|0;return(a&-1024|0)==56320|0}function Lk(a){a=a|0;return(a&-1024|0)==55296|0}function Mk(a,b){a=a|0;b=b|0;if((a&-1024|0)==56320&(b&-1024|0)==55296)return a+ -56613888+(b<<10)|0;else va(143016,143072,498,143096);return 0}function Nk(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;f=i;g=(Ok(a)|0)!=0&(d|0)!=0&(b|0)!=0;e=g&1;if(!g){i=f;return e|0}g=a+ -65536|0;c[b>>2]=(g>>>10)+55296;c[d>>2]=g&1023|56320;i=f;return e|0}



function tb(a){a=a|0;var b=0;b=i;i=i+a|0;i=i+15&-16;return b|0}function ub(){return i|0}function vb(a){a=a|0;i=a}function wb(a,b){a=a|0;b=b|0;if(!r){r=a;s=b}}function xb(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0]}function yb(b){b=b|0;a[k>>0]=a[b>>0];a[k+1>>0]=a[b+1>>0];a[k+2>>0]=a[b+2>>0];a[k+3>>0]=a[b+3>>0];a[k+4>>0]=a[b+4>>0];a[k+5>>0]=a[b+5>>0];a[k+6>>0]=a[b+6>>0];a[k+7>>0]=a[b+7>>0]}function zb(a){a=a|0;G=a}function Ab(){return G|0}function Bb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=i;i=i+144|0;g=e;p=e+136|0;n=e+132|0;l=e+128|0;m=e+24|0;r=e+16|0;s=e+12|0;q=c[d>>2]|0;f=Kb()|0;h=c[o>>2]|0;c[2]=h;t=Va(16)|0;if((t|0)!=0?(u=Nb(f,t)|0,(u|0)!=0):0){z=c[2]|0;c[g>>2]=t;c[g+4>>2]=u;cb(z|0,32,g|0)|0}a:do if((b|0)>0){t=0;u=0;v=0;b:while(1){while(1){y=(b|0)>1;if(y){w=d+4|0;x=c[w>>2]|0;if((a[x>>0]|0)==45)break;if(bc(f,61)|0)Zb(f,62,x)|0;w=x;x=rc(f,x)|0}else{w=576;x=sc(f)|0}do if((x|0)>-1?(vc(f)|0)>-1:0){x=wc(f)|0;if((x|0)>1){if(!(bc(f,69)|0))break}else if((x|0)<=-1)break;if(bc(f,16)|0){if((bc(f,15)|0)!=0&y){tc(f,w)|0;break}w=Yb(f,14)|0;if(!w){uc(f)|0;break}else{tc(f,w)|0;break}}}while(0);t=(mc(f)|0)+t|0;u=(nc(f)|0)+u|0;b=b+ -1|0;if((b|0)>1)d=d+4|0;else{k=t;j=u;break a}}y=x+1|0;c:do if(!(tm(y,80)|0))cc(f,24,1)|0;else{if((tm(y,88)|0)!=0?(tm(y,96)|0)!=0:0){if(!(tm(y,104)|0)){cc(f,27,1)|0;break}if(!(tm(y,112)|0)){ac(f,20,2)|0;if($b(f,1)|0)break;kc(f,1)|0;break}if(!(tm(y,120)|0)){cc(f,22,1)|0;break}if(!(tm(y,128)|0)){cc(f,29,1)|0;break}if(!(tm(y,136)|0)){cc(f,32,1)|0;break}if(!(tm(y,144)|0)){cc(f,33,1)|0;break}if(!(tm(y,152)|0)){cc(f,31,1)|0;break}do if(((tm(y,160)|0)!=0?(tm(y,168)|0)!=0:0)?(tm(y,176)|0)!=0:0){if(!(tm(y,184)|0))break;if(!(tm(y,192)|0))break;if(!(tm(y,200)|0))break;if(!(tm(y,208)|0))break;if(!(tm(y,216)|0))break;if(!(tm(y,224)|0))break;if(!(tm(y,232)|0))break;if(!(tm(y,248)|0))break;if(!(tm(y,256)|0))break;if(!(tm(y,264)|0))break;if(!(tm(y,272)|0))break;if(!(tm(y,280)|0)){cc(f,42,1)|0;break c}do if(tm(y,288)|0){if(!(tm(y,296)|0))break;if(!(tm(y,304)|0))break;if(!(tm(y,312)|0)){cc(f,16,0)|0;break c}if(!(tm(y,320)|0)){cc(f,19,1)|0;break c}if(!(tm(y,328)|0)){r=56;break b}if(!(tm(y,336)|0)){r=56;break b}z=a[y>>0]|0;if(z<<24>>24==63){r=56;break b}if(!(tm(y,344)|0)){r=79;break b}if(!(tm(y,360)|0)){r=86;break b}if(!(tm(y,376)|0)){r=88;break b}if(!(tm(y,392)|0)){r=111;break b}if(!(tm(y,408)|0)){if((b|0)<=2)break c;Nb(f,c[d+8>>2]|0)|0;d=Yb(f,13)|0;do if(d){if((v|0)!=0?(um(v,d)|0)==0:0)break;c[2]=lc(f,d)|0;v=d}while(0);b=b+ -1|0;d=w;break c}do if(tm(y,416)|0){if(!(tm(y,432)|0))break;do if(tm(y,440)|0){if(!(tm(y,448)|0))break;if(!(tm(y,464)|0))break;do if(tm(y,472)|0){if(!(tm(y,480)|0))break;if(!(tm(y,488)|0))break;do if(tm(y,496)|0){if(!(tm(y,504)|0))break;if(!(tm(y,512)|0))break;if(!(tm(y,528)|0)){r=141;break b}if(!(tm(y,536)|0)){r=141;break b}if(!(tm(y,552)|0)){r=141;break b}if(!(vm(x,560,2)|0)){if(!(_b(f,x+2|0,c[d+8>>2]|0)|0))break c;d=Yb(f,13)|0;do if(d){if((v|0)!=0?(um(v,d)|0)==0:0)break;c[2]=lc(f,d)|0;v=d}while(0);b=b+ -1|0;d=w;break c}if(!(tm(y,568)|0)){if((b|0)<=2)break c;c[s>>2]=0;z=c[d+8>>2]|0;c[g>>2]=s;z=Kl(z,520,g)|0;ac(f,84,c[s>>2]|0)|0;z=(z|0)>0;b=(z<<31>>31)+b|0;d=z?w:d;break c}if(!(z<<24>>24))break c;w=z<<24>>24;while(1){d:do switch(w|0){case 117:{cc(f,29,1)|0;break};case 99:{cc(f,32,1)|0;break};case 103:{cc(f,33,1)|0;break};case 98:{cc(f,31,1)|0;break};case 110:{cc(f,42,1)|0;break};case 109:{cc(f,15,1)|0;break};case 101:{cc(f,16,0)|0;break};case 113:{cc(f,19,1)|0;break};case 105:{ac(f,20,2)|0;if($b(f,1)|0)break d;kc(f,1)|0;break};default:{z=c[2]|0;c[g>>2]=w;cb(z|0,584,g|0)|0}}while(0);y=y+1|0;w=a[y>>0]|0;if(!(w<<24>>24))break c;else w=w<<24>>24}}while(0);if((b|0)<=2)break c;c[r>>2]=0;z=c[d+8>>2]|0;c[g>>2]=r;z=Kl(z,520,g)|0;ac(f,2,c[r>>2]|0)|0;z=(z|0)>0;b=(z<<31>>31)+b|0;d=z?w:d;break c}while(0);if((b|0)<=2)break c;v=c[d+8>>2]|0;c[2]=lc(f,v)|0;b=b+ -1|0;d=w;break c}while(0);if((b|0)<=2)break c;Zb(f,14,c[d+8>>2]|0)|0;b=b+ -1|0;d=w;break c}while(0);if((b|0)<=2)break c;Zb(f,75,c[d+8>>2]|0)|0;b=b+ -1|0;d=w;break c}while(0);cc(f,15,1)|0;break c}while(0);Ob(f,y)|0;break}cc(f,26,1)|0}while(0);b=b+ -1|0;if((b|0)<=0){k=t;j=u;break a}else d=d+4|0}if((r|0)==56){c[g>>2]=q;Ma(5720,g|0)|0;La(5904)|0;Ia(10)|0;La(5960)|0;La(Mb()|0)|0;Ia(10)|0;La(6016)|0;Ia(10)|0;l=0;e:while(1){m=c[2660+(l<<3)>>2]|0;p=Em(m|0)|0;La(m|0)|0;c[g>>2]=p;c[g+4>>2]=p;c[g+8>>2]=5808;Ma(5800,g|0)|0;p=2912;m=1696;do{if((c[m+12>>2]|0)==(l|0)){s=Em(p|0)|0;q=m+16|0;n=c[q>>2]|0;if(n)s=s+2+(Em(n|0)|0)|0;r=m+20|0;n=c[r>>2]|0;if(n)s=s+2+(Em(n|0)|0)|0;n=Tl(s+1|0)|0;if(!n){r=64;break e}Lm(n|0,p|0)|0;p=c[q>>2]|0;if(p){z=n+(Em(n|0)|0)|0;a[z+0>>0]=a[1576]|0;a[z+1>>0]=a[1577]|0;a[z+2>>0]=a[1578]|0;Fm(n|0,p|0)|0}p=c[r>>2]|0;if(p){z=n+(Em(n|0)|0)|0;a[z+0>>0]=a[1576]|0;a[z+1>>0]=a[1577]|0;a[z+2>>0]=a[1578]|0;Fm(n|0,p|0)|0}s=c[m+4>>2]|0;r=Tl(20)|0;p=Tl(59)|0;if(!r){r=70;break e}if(!p){r=72;break e}else q=n;do{q=Ib(q,19,r)|0;s=Ib(s,58,p)|0;z=(a[p>>0]|0)!=0?p:800;c[g>>2]=(a[r>>0]|0)!=0?r:800;c[g+4>>2]=z;Ma(5880,g|0)|0}while((q|0)!=0|(s|0)!=0);Ul(r);Ul(p);Ul(n)}m=m+24|0;p=c[m>>2]|0}while((p|0)!=0);Ia(10)|0;l=l+1|0;if((l|0)==4){r=77;break}}if((r|0)==64)Hb();else if((r|0)==70)Hb();else if((r|0)==72)Hb();else if((r|0)==77){La(6040)|0;La(6216)|0;Ia(10)|0;La(6272)|0;La(6328)|0;Ia(10)|0;La(6368)|0;La(6440)|0;Ia(10)|0;La(6480)|0;Ia(10)|0;La(6536)|0;La(6600)|0;Ia(10)|0;La(6648)|0;La(6712)|0;Ia(10)|0;La(6752)|0;La(6816)|0;Ia(10)|0;La(6872)|0;Ia(10)|0;Ma(5768,g|0)|0;Ia(10)|0;Lb(f);z=0;i=e;return z|0}}else if((r|0)==79){c[g>>2]=Mb()|0;Ma(1648,g|0)|0;h=1696;do{c[g>>2]=c[2656+(c[h+12>>2]<<3)>>2];Ma(1328,g|0)|0;Jb(2688,c[h>>2]|0);Jb(2688,c[h+16>>2]|0);Jb(2688,c[h+20>>2]|0);Jb(2696,c[h+4>>2]|0);j=c[h+8>>2]|0;if(!j)La(7336)|0;else Jb(2712,j);La(7352)|0;h=h+24|0}while((c[h>>2]|0)!=0);La(6936)|0;Lb(f);z=0;i=e;return z|0}else if((r|0)==86){La(6952)|0;La(6992)|0;La(7024)|0;La(7040)|0;La(7056)|0;La(7112)|0;c[g>>2]=688;c[g+4>>2]=696;c[g+8>>2]=1584;Ma(656,g|0)|0;c[g>>2]=720;c[g+4>>2]=720;c[g+8>>2]=720;Ma(656,g|0)|0;Cb(f,42);Lb(f);z=0;i=e;return z|0}else if((r|0)==88){c[g>>2]=Mb()|0;Ma(1280,g|0)|0;z=Pb(f)|0;c[l>>2]=z;if(z){s=m+4|0;r=m+8|0;q=m+16|0;k=m+100|0;j=m+12|0;do{t=Qb(f,l)|0;Eb(f,t,m);if(!(Vb(t)|0)){c[g>>2]=c[s>>2];Ma(1328,g|0)|0;c[g>>2]=c[m>>2];Ma(1352,g|0)|0;c[g>>2]=c[r>>2];Ma(1376,g|0)|0;u=c[q>>2]|0;if(!u)La(7264)|0;else{c[g>>2]=u;Ma(1400,g|0)|0}if(!(c[k>>2]|0))La(7280)|0;else{Ma(1432,g|0)|0;u=c[j>>2]|0;if(!u){z=Wb(t)|0;c[n>>2]=z;if((z|0)!=0?(c[g>>2]=Xb(t,n)|0,Ma(1568,g|0)|0,(c[n>>2]|0)!=0):0)do{Ma(1576,g|0)|0;c[g>>2]=Xb(t,n)|0;Ma(1568,g|0)|0}while((c[n>>2]|0)!=0)}else{c[g>>2]=u;Ma(1568,g|0)|0}La(7296)|0}u=hc(f,t)|0;if(!u){La(7312)|0;c[g>>2]=Sb(t)|0;cb(h|0,1520,g|0)|0}else{c[g>>2]=u;Ma(1480,g|0)|0}z=ic(f,t)|0;c[p>>2]=z;if(z)do{c[g>>2]=Sb(jc(f,p)|0)|0;Ma(1448,g|0)|0}while((c[p>>2]|0)!=0);La(7352)|0}}while((c[l>>2]|0)!=0)}La(7136)|0;Lb(f);z=0;i=e;return z|0}else if((r|0)==111){La(7152)|0;c[g>>2]=688;c[g+4>>2]=696;c[g+8>>2]=704;Ma(656,g|0)|0;c[g>>2]=720;c[g+4>>2]=720;c[g+8>>2]=720;Ma(656,g|0)|0;Cb(f,43);La(7184)|0;Lb(f);z=0;i=e;return z|0}else if((r|0)==141){c[g>>2]=Mb()|0;Ma(616,g|0)|0;Lb(f);z=0;i=e;return z|0}}else{k=0;j=0}while(0);if((bc(f,19)|0)==0?!((c[2]|0)!=(h|0)|(k|0)!=0):0)Za(10,h|0)|0;if((k|0)!=(0-j|0)?(bc(f,19)|0)==0:0)pc(f);if(!(bc(f,19)|0))qc(f);Lb(f);if(k){z=2;i=e;return z|0}z=(j|0)!=0&1;i=e;return z|0}function Cb(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=i;i=i+480|0;d=e+376|0;f=e;g=Pb(a)|0;c[d>>2]=g;if(!g)g=0;else{g=0;do{c[f+(g<<2)>>2]=Qb(a,d)|0;g=g+1|0}while((c[d>>2]|0)!=0)}c[f+(g<<2)>>2]=0;Nl(f,93,4,14);g=c[f>>2]|0;if(!g){i=e;return}do{Eb(a,g,d);qb[b&63](a,c[f>>2]|0,d);f=f+4|0;g=c[f>>2]|0}while((g|0)!=0);i=e;return}function Db(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;g=i;i=i+32|0;f=g;h=g+16|0;j=Rb(d)|0;d=(Vb(d)|0)!=0;d=d?792:800;a:do switch(j|0){case 7:{c[e+16>>2]=ec(b,7)|0;break};case 83:case 82:case 81:case 80:{o=fc(b)|0;c[h>>2]=o;if(o){n=e+16|0;m=e+8|0;do{o=gc(b,j,h)|0;c[n>>2]=o;if(!(c[h>>2]|0))break a;k=c[e>>2]|0;l=c[m>>2]|0;if(!(a[k>>0]|0)){c[f>>2]=k;c[f+4>>2]=l;c[f+8>>2]=o;Ma(656,f|0)|0}else{c[f>>2]=k;c[f+4>>2]=l;c[f+8>>2]=d;c[f+12>>2]=o;Ma(808,f|0)|0}c[e>>2]=800;c[m>>2]=800}while((c[h>>2]|0)!=0)}break};default:{}}while(0);h=c[e>>2]|0;j=a[h>>0]|0;if(j<<24>>24==0?(a[c[e+8>>2]>>0]|0)==0:0){b=c[e+16>>2]|0;if(!b){i=g;return}if(!(a[b>>0]|0)){i=g;return}}k=e+16|0;b=c[k>>2]|0;if(!b){c[k>>2]=800;j=a[h>>0]|0;b=800}e=c[e+8>>2]|0;if(!(j<<24>>24)){c[f>>2]=h;c[f+4>>2]=e;c[f+8>>2]=b;Ma(656,f|0)|0;i=g;return}else{c[f>>2]=h;c[f+4>>2]=e;c[f+8>>2]=d;c[f+12>>2]=b;Ma(808,f|0)|0;i=g;return}}function Eb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;i=i+16|0;h=f;k=Rb(d)|0;j=Tb(d)|0;c[e>>2]=Sb(d)|0;l=Ub(d)|0;switch(l|0){case 3:{g=1152;break};case 0:{g=1120;break};case 2:{g=1144;break};case 4:{g=1168;break};case 1:{g=1128;break};default:{m=c[o>>2]|0;c[h>>2]=l;cb(m|0,1176,h|0)|0;va(1224,1232,496,1256)}}c[e+4>>2]=g;l=e+12|0;c[l>>2]=0;g=e+16|0;c[g>>2]=0;m=e+100|0;c[m>>2]=1;switch(k|0){case 6:case 5:case 4:{c[e+8>>2]=920;m=dc(b,k)|0;c[g>>2]=(m|0)==0?936:m;c[l>>2]=0;i=f;return};case 83:case 82:case 81:case 80:{c[e+8>>2]=888;c[l>>2]=904;c[g>>2]=0;i=f;return};case 9:{c[e+8>>2]=880;c[l>>2]=0;d=ec(b,8)|0;if(!((d|0)!=0?(a[d>>0]|0)!=42:0))d=Yb(b,9)|0;c[g>>2]=d;i=f;return};case 84:case 7:case 91:case 10:{c[e+8>>2]=840;c[l>>2]=0;if((k|0)==7)b=848;else b=ec(b,k)|0;c[g>>2]=b;i=f;return};default:if((j|0)==1){a:do if((Tb(d)|0)==1?(m=Wb(d)|0,c[h>>2]=m,(m|0)!=0):0){while(1){if(!(um(Xb(d,h)|0,1112)|0))break;if(!(c[h>>2]|0))break a}c[e+8>>2]=992;c[l>>2]=1008;c[g>>2]=ec(b,k)|0;i=f;return}while(0);c[e+8>>2]=1048;c[l>>2]=(k|0)==2?1056:1088;m=e+20|0;c[h>>2]=$b(b,k)|0;mm(m,520,h)|0;c[g>>2]=m;i=f;return}else if((j|0)==2){c[e+8>>2]=944;c[l>>2]=952;c[g>>2]=ec(b,k)|0;i=f;return}else if(!j){c[e+8>>2]=1104;c[l>>2]=0;c[m>>2]=0;c[g>>2]=Yb(b,k)|0;i=f;return}else{i=f;return}}}function Fb(a,b){a=a|0;b=b|0;var d=0;d=i;a=Sb(c[a>>2]|0)|0;a=um(a,Sb(c[b>>2]|0)|0)|0;i=d;return a|0}function Gb(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;j=i;i=i+16|0;b=j;k=j+12|0;if(Vb(d)|0){i=j;return}if((a[c[e>>2]>>0]|0)==0?(a[c[e+8>>2]>>0]|0)==0:0){i=j;return}l=c[e+12>>2]|0;if(c[e+100>>2]|0)if(!l){o=Wb(d)|0;c[k>>2]=o;if(!o)l=1;else{m=0;l=0;while(1){l=(Em(Xb(d,k)|0)|0)+(m?l+2|0:l)|0;if(!(c[k>>2]|0))break;else m=1}l=l+1|0}l=Tl(l)|0;if(!l)Hb();a[l>>0]=0;o=Wb(d)|0;c[k>>2]=o;if((o|0)!=0?(Fm(l|0,Xb(d,k)|0)|0,(c[k>>2]|0)!=0):0){do{o=l+(Em(l|0)|0)|0;a[o+0>>0]=a[1576]|0;a[o+1>>0]=a[1577]|0;a[o+2>>0]=a[1578]|0;Fm(l|0,Xb(d,k)|0)|0}while((c[k>>2]|0)!=0);d=l}else d=l}else{d=l;l=0}else{d=1608;l=0}k=c[e>>2]|0;o=c[e+8>>2]|0;e=Tl(28)|0;m=Tl(10)|0;n=Tl(41)|0;if(!e)Hb();if(!m)Hb();if(!n)Hb();else{f=k;g=o;h=d}do{f=Ib(f,27,e)|0;g=Ib(g,9,m)|0;h=Ib(h,40,n)|0;k=(a[m>>0]|0)!=0?m:800;o=(a[n>>0]|0)!=0?n:800;c[b>>2]=(a[e>>0]|0)!=0?e:800;c[b+4>>2]=k;c[b+8>>2]=o;Ma(656,b|0)|0}while((f|0)!=0|(g|0)!=0|(h|0)!=0);Ul(e);Ul(m);Ul(n);if(!l){i=j;return}Ul(l);i=j;return}function Hb(){ab(1616,27,1,c[o>>2]|0)|0;ib(1)}function Ib(b,c,d){b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;if(!b){a[d>>0]=0;g=0;i=e;return g|0}if((Em(b|0)|0)>>>0<=c>>>0){Lm(d|0,b|0)|0;a[d+c>>0]=0;g=0;i=e;return g|0}a:do if(!c){f=1;g=0}else{g=c;while(1){if((a[b+g>>0]|0)==32){f=0;break a}g=g+ -1|0;if(!g){f=1;g=0;break}}}while(0);h=f?c:g;Hm(d|0,b|0,h|0)|0;a[d+h>>0]=0;g=b+(f?c:g+1|0)|0;i=e;return g|0}function Jb(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;i=i+16|0;e=f;if(!d){i=f;return}g=a[d>>0]|0;h=g<<24>>24==0;if(h)k=0;else{l=g;j=d;k=0;do{l=l<<24>>24;if((l|0)==34)k=k+6|0;else if((l|0)==62|(l|0)==60)k=k+4|0;else k=k+1|0;j=j+1|0;l=a[j>>0]|0}while(l<<24>>24!=0)}j=Tl(k+1|0)|0;if(!j)Hb();a[j>>0]=0;a[e+1>>0]=0;if(!h)do{h=g<<24>>24;if((h|0)==60){l=j+(Em(j|0)|0)|0;a[l+0>>0]=a[2744]|0;a[l+1>>0]=a[2745]|0;a[l+2>>0]=a[2746]|0;a[l+3>>0]=a[2747]|0;a[l+4>>0]=a[2748]|0}else if((h|0)==62){l=j+(Em(j|0)|0)|0;a[l+0>>0]=a[2752]|0;a[l+1>>0]=a[2753]|0;a[l+2>>0]=a[2754]|0;a[l+3>>0]=a[2755]|0;a[l+4>>0]=a[2756]|0}else if((h|0)==34){l=j+(Em(j|0)|0)|0;a[l+0>>0]=a[2760]|0;a[l+1>>0]=a[2761]|0;a[l+2>>0]=a[2762]|0;a[l+3>>0]=a[2763]|0;a[l+4>>0]=a[2764]|0;a[l+5>>0]=a[2765]|0;a[l+6>>0]=a[2766]|0}else{a[e>>0]=g;Fm(j|0,e|0)|0}d=d+1|0;g=a[d>>0]|0}while(g<<24>>24!=0);c[e>>2]=b;c[e+4>>2]=j;c[e+8>>2]=b;Ma(2728,e|0)|0;Ul(j);i=f;return}function Kb(){var a=0,b=0;b=i;a=yc(75032)|0;i=b;return a|0}function Lb(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;if(!a){i=b;return}if(c[a+2660>>2]|0)va(7472,7424,163,7552);if(c[a+2664>>2]|0)va(7568,7424,164,7552);e=a+2668|0;Yj(a,c[e>>2]|0);c[e>>2]=0;ug(a);yf(a);zf(a,a);e=a+0|0;d=e+68|0;do{c[e>>2]=0;e=e+4|0}while((e|0)<(d|0));e=c[a+2740>>2]|0;d=a+2724|0;if(e){f=c[d>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,e)}Gi(a);Xc(a);Re(a);f=c[d>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,a);i=b;return}function Mb(){var a=0,b=0;b=i;a=$h()|0;i=b;return a|0}function Nb(a,b){a=a|0;b=b|0;var c=0;c=i;if(!a)a=-22;else a=Oi(a,b)|0;i=c;return a|0}function Ob(a,b){a=a|0;b=b|0;var c=0;c=i;do if(!a)a=-22;else{b=Qi(a,b)|0;if((b|0)>-1?(Ti(a,b)|0)!=0:0){a=0;break}di(a,7368);a=-22}while(0);i=c;return a|0}function Pb(a){a=a|0;var b=0;b=i;if(!a)a=-1;else a=Wi(a)|0;i=b;return a|0}function Qb(a,b){a=a|0;b=b|0;var d=0;d=i;if(!a)if(!b)b=0;else{c[b>>2]=0;b=0}else b=Xi(a,b)|0;i=d;return b|0}function Rb(a){a=a|0;if(!a)a=94;else a=c[a>>2]|0;return a|0}function Sb(a){a=a|0;if(!a)a=0;else a=c[a+8>>2]|0;return a|0}function Tb(a){a=a|0;if(!a)a=-1;else a=c[a+12>>2]|0;return a|0}function Ub(a){a=a|0;if(!a)a=-1;else a=c[a+4>>2]|0;return a|0}function Vb(a){a=a|0;if(!a)a=1;else a=(c[a+20>>2]|0)==0&1;return a|0}function Wb(a){a=a|0;var b=0;b=i;if(!a)a=-1;else a=Yi(a)|0;i=b;return a|0}function Xb(a,b){a=a|0;b=b|0;var c=0;c=i;if(!a)a=0;else a=Zi(a,b)|0;i=c;return a|0}function Yb(a,b){a=a|0;b=b|0;if(!a)a=0;else a=c[a+72+(b<<2)>>2]|0;return a|0}function Zb(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if(!a)a=0;else a=Si(a,b,c)|0;i=d;return a|0}function _b(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if(!a)a=0;else a=Ri(a,b,c)|0;i=d;return a|0}function $b(a,b){a=a|0;b=b|0;if(!a)a=0;else a=c[a+72+(b<<2)>>2]|0;return a|0}function ac(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if(!a)a=0;else a=Ki(a,b,c)|0;i=d;return a|0}function bc(a,b){a=a|0;b=b|0;var d=0;d=i;if((a|0)!=0?(Ji(b)|0)!=0:0)a=c[a+72+(b<<2)>>2]|0;else a=0;i=d;return a|0}function cc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;if(!a)a=0;else a=Li(a,b,c)|0;i=d;return a|0}function dc(a,b){a=a|0;b=b|0;var d=0;d=i;if(!a)a=0;else a=c[a+72+(b<<2)>>2]|0;b=Vi(a)|0;i=d;return b|0}function ec(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;f=Ji(b)|0;if((f|0)!=0?(e=c[f+24>>2]|0,(e|0)!=0):0){if(a){a=c[a+72+(b<<2)>>2]|0;b=c[e>>2]|0;if((b|0)!=0&(a|0)!=0){f=0;do{e=e+4|0;f=f+1|0;b=c[e>>2]|0}while((b|0)!=0&f>>>0<a>>>0)}}else b=c[e>>2]|0;if(b){i=d;return b|0}}b=0;i=d;return b|0}function fc(a){a=a|0;var b=0;b=i;if(!a)a=0;else a=Ne(a)|0;i=b;return a|0}function gc(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;do if(!a)a=0;else{if((b|0)==80)b=2;else if((b|0)==81)b=4;else if((b|0)!=82)if((b|0)==83)b=8;else{a=0;break}else b=1;a=Oe(a,b,c)|0}while(0);i=d;return a|0}function hc(a,b){a=a|0;b=b|0;a=i;if(!b)b=94;else b=c[b>>2]|0;b=ai(b)|0;if(!b){b=0;i=a;return b|0}b=c[b+4>>2]|0;i=a;return b|0}function ic(a,b){a=a|0;b=b|0;var d=0;a=i;if(!b)b=94;else b=c[b>>2]|0;b=ai(b)|0;if(!((b|0)!=0?(d=c[b+8>>2]|0,(d|0)!=0):0))d=0;i=a;return d|0}function jc(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;d=c[b>>2]|0;e=c[d>>2]|0;if(e){e=Ji(e)|0;d=d+4|0;if(!(c[d>>2]|0))d=0}else{e=0;d=0}c[b>>2]=d;i=a;return e|0}function kc(a,b){a=a|0;b=b|0;var c=0;c=i;if(!a)a=0;else a=Mi(a,b)|0;i=c;return a|0}function lc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;if(!a){e=0;i=d;return e|0}e=hb(b|0,7384)|0;if(!e){bi(a,b,4);e=0;i=d;return e|0}else{g=c[a+96>>2]|0;f=c[a+100>>2]|0;b=a+2668|0;Yj(a,c[b>>2]|0);c[b>>2]=gk(a,e,g,f)|0;i=d;return e|0}return 0}function mc(a){a=a|0;if(!a)a=-1;else a=c[a+2684>>2]|0;return a|0}function nc(a){a=a|0;if(!a)a=-1;else a=c[a+2688>>2]|0;return a|0}function oc(a){a=a|0;if(!a)a=-1;else a=c[a+2692>>2]|0;return a|0}function pc(a){a=a|0;var b=0;b=i;if(a)qi(a);i=b;return}function qc(a){a=a|0;var b=0;b=i;if(a)si(a);i=b;return}function rc(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;e=hb(b|0,7544)|0;if(!e){bi(a,b,4);b=-2;i=d;return b|0}b=$j(a,e,c[a+92>>2]|0)|0;if(!b){Na(e|0)|0;b=-2;i=d;return b|0}else{e=xc(a,b)|0;Cc(b+304|0,1);_j(b);b=e;i=d;return b|0}return 0}function sc(a){a=a|0;var b=0,d=0;b=i;d=$j(a,c[p>>2]|0,c[a+92>>2]|0)|0;a=xc(a,d)|0;_j(d);i=b;return a|0}function tc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;if(((c[a+2684>>2]|0)!=0?(c[a+132>>2]|0)!=0:0)?(c[a+348>>2]|0)==0:0){f=zc(a)|0;e=7}else{f=hb(b|0,7384)|0;if(!f)f=-2;else{g=gk(a,f,c[a+96>>2]|0,c[a+100>>2]|0)|0;e=Ac(a,g)|0;Na(f|0)|0;f=c[a+2724>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,g);f=e;e=7}}if((e|0)==7)if((f|0)>=0){g=f;i=d;return g|0}bi(a,b,4);g=f;i=d;return g|0}function uc(a){a=a|0;var b=0,d=0,e=0,f=0;d=i;f=c[q>>2]|0;e=gk(a,f,c[a+96>>2]|0,c[a+100>>2]|0)|0;b=Ac(a,e)|0;ya(f|0)|0;ya(c[o>>2]|0)|0;a=c[a+2724>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,e);i=d;return b|0}function vc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;h=i;if(!a){r=-22;i=h;return r|0}q=c[a+308>>2]|0;r=c[a+208>>2]|0;p=c[a+200>>2]|0;n=c[a+204>>2]|0;o=c[a+216>>2]|0;j=c[a+180>>2]|0;b=c[a+172>>2]|0;d=c[a+176>>2]|0;g=c[a+184>>2]|0;f=c[a+312>>2]|0;e=c[a+444>>2]|0;if(c[a+168>>2]|0){r=zc(a)|0;i=h;return r|0}if(c[a+420>>2]|0)mh(a,a);oh(a,a);ph(a,a);if(r)nh(a,a);if((q|0)!=0?(th(a)|0)!=0:0){qh(a,a);sh(a,a);Ud(a,a)|0}if(o|p)lh(a);if(n)Gc(a);r=c[a+96>>2]|0;if(!((r|0)==5|(r|0)==0))vh(a,Pf(a)|0);if(!(Kd(a)|0)){r=c[a+2724>>2]|0;ob[c[(c[r>>2]|0)+12>>2]&15](r,7504)}n=Lf(a)|0;if(((n|0)!=0?(m=Lc(n,7496)|0,(m|0)!=0):0)?(l=m+24|0,k=c[l>>2]|0,(k|0)!=0):0){m=a+2740|0;o=c[m>>2]|0;n=a+2724|0;if(o){k=c[n>>2]|0;ob[c[(c[k>>2]|0)+8>>2]&15](k,o);k=c[l>>2]|0}c[m>>2]=pk(c[n>>2]|0,k)|0}if(c[a+12>>2]|0){j=(j|0)!=0;if(j)if(c[(c[a+68>>2]|0)+28>>2]|0){k=Lf(a)|0;if(!k)k=30;else{Nd(k)|0;k=30}}else k=32;else k=30;if((k|0)==30)if((d|0)==0|j)k=32;else{Xf(a)|0;Dh(a,a,e,1);Ch(a,1);Bh(a,a,1,1)}if((k|0)==32){Yf(a)|0;Dh(a,a,e,1);Ch(a,0);Bh(a,a,0,1)}if(f)Sf(a)|0}if((b|0)!=0&(g|0)!=0)Zf(a)|0;r=zc(a)|0;i=h;return r|0}function wc(a){a=a|0;var b=0,d=0;b=i;if(!a){d=-22;i=b;return d|0}d=c[a+348>>2]|0;if(!(c[a+148>>2]|0)){ui(a);vi(a)}if(!((c[a+2684>>2]|0)==0|(d|0)!=0))ri(a);d=zc(a)|0;i=b;return d|0}function xc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;e=i;d=c[a+168>>2]|0;if(!((a|0)!=0&(b|0)!=0))va(7392,7424,1155,7448);f=a+2660|0;if(c[f>>2]|0)va(7472,7424,1156,7448);c[f>>2]=b;Hi(a);yf(a);Vc(a);zf(a,a);h=a+0|0;g=h+68|0;do{c[h>>2]=0;h=h+4|0}while((h|0)<(g|0));g=a+2740|0;h=c[g>>2]|0;if(h){j=c[a+2724>>2]|0;ob[c[(c[j>>2]|0)+8>>2]&15](j,h)}c[g>>2]=0;g=xf(a)|0;c[a+68>>2]=g;c[a+48>>2]=c[g>>2];c[a+52>>2]=c[g+4>>2];c[a+2736>>2]=0;g=bk(b)|0;if((g|0)!=-1){c[b+296>>2]=g;Ki(a,5,g)|0}if(!d){c[a+2688>>2]=0;pe(a);if(Kd(a)|0){c[f>>2]=0;j=zc(a)|0;i=e;return j|0}j=c[a+2724>>2]|0;ob[c[(c[j>>2]|0)+12>>2]&15](j,7504);c[f>>2]=0;j=zc(a)|0;i=e;return j|0}else{re(a);if(Kd(a)|0){c[f>>2]=0;j=zc(a)|0;i=e;return j|0}j=c[a+2724>>2]|0;ob[c[(c[j>>2]|0)+12>>2]&15](j,7504);c[f>>2]=0;j=zc(a)|0;i=e;return j|0}return 0}function yc(a){a=a|0;var b=0,d=0;d=i;b=rb[c[c[a>>2]>>2]&15](a,2744)|0;Dm(b|0,0,2744)|0;c[b+2724>>2]=a;ag();Pe(b);Wc(b);Ei(b);tg(b);c[b+2668>>2]=Xj()|0;i=d;return b|0}function zc(a){a=a|0;var b=0;b=i;if(c[a+2684>>2]|0){a=2;i=b;return a|0}if(!(c[a+2688>>2]|0)){i=b;return(c[a+2692>>2]|0)!=0|0}else{a=1;i=b;return a|0}return 0}function Ac(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=i;h=c[a+136>>2]|0;m=c[a+348>>2]|0;k=c[a+380>>2]|0;e=c[a+172>>2]|0;f=c[a+176>>2]|0;g=c[a+328>>2]|0;o=c[a+340>>2]|0;p=c[a+200>>2]|0;l=c[a+356>>2]|0;n=c[a+196>>2]|0;j=c[a+436>>2]|0;if(c[a+368>>2]|0)Ah(a,a);if(o)wh(a,a);o=(p|0)!=0;if(o)xh(a,a,0);n=(n|0)!=0;if(o&(l|0)!=0|n)yh(a,a);if(n)rh(c[a+68>>2]|0,a);else zh(a,a);if(j)dd(a,j);if(!h){Ni(a);p=zc(a)|0;i=d;return p|0}if(!((c[a+2684>>2]|0)==0|(m|0)!=0)){Ni(a);p=zc(a)|0;i=d;return p|0}if(!((k|0)!=1?!((c[a+2736>>2]|0)!=0&(k|0)==2):0))jk(b);h=a+2664|0;c[h>>2]=b;do if((e|0)==0|(f|0)!=0){if(g>>>0<2)if(!g)e=26;else e=25;else{p=Rf(a)|0;if((p|0)!=0?(c[p+60>>2]|0)!=0:0)e=25;else e=26}if((e|0)==25){xg(a);break}else if((e|0)==26){yg(a,0,0,a);break}}else zg(a,0,0,a);while(0);vg(a,0);c[h>>2]=0;Ni(a);p=zc(a)|0;i=d;return p|0}function Bc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;i=i+80|0;g=e;f=rb[c[c[a>>2]>>2]&15](a,16)|0;if(!f){j=-1;i=e;return j|0}j=Ea(d|0)|0;if(((ta(j|0,g|0)|0)!=-1?(h=c[g+36>>2]|0,(h|0)!=0):0)?(c[f+12>>2]=h,j=fb(0,h|0,1,1,j|0,0)|0,c[f+4>>2]=j,(j|0)!=(-1|0)):0){c[f+8>>2]=0;c[f>>2]=a;Na(d|0)|0;c[b+4>>2]=4;c[b+12>>2]=5;c[b+8>>2]=10;c[b>>2]=f;j=0;i=e;return j|0}ob[c[(c[a>>2]|0)+8>>2]&15](a,f);j=Qj(a,b,d)|0;i=e;return j|0}function Cc(a,b){a=a|0;b=b|0;var d=0;d=i;if((c[a+4>>2]|0)==4){b=c[a>>2]|0;eb(c[b+4>>2]|0,c[b+12>>2]|0)|0;a=c[b>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,b);i=d;return}else{Rj(a,b);i=d;return}}function Dc(a){a=a|0;var b=0,e=0;e=a+8|0;b=c[e>>2]|0;c[e>>2]=b+1;return d[(c[a+4>>2]|0)+b>>0]|0|0}function Ec(a){a=a|0;return(c[a+8>>2]|0)>>>0>=(c[a+12>>2]|0)>>>0|0}function Fc(a,b){a=a|0;b=b|0;b=a+8|0;c[b>>2]=(c[b>>2]|0)+ -1;return}function Gc(a){a=a|0;var b=0,c=0,d=0;b=i;Hc(a,a);c=Pf(a)|0;if(!c){i=b;return}d=Tf(a,67)|0;Nc(a,d,7592,7608)|0;Nc(a,d,7624,7632)|0;Pd(c,d);i=b;return}function Hc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0;d=i;b=c[b+12>>2]|0;if(!b){i=d;return}do{e=b+8|0;f=c[e>>2]|0;a:do if(!(Ue(b)|0))b=f;else{g=b+28|0;h=c[g>>2]|0;do if(h){if((c[h>>2]|0)==101)Od(a,b)|0;g=c[g>>2]|0;if(g){g=c[g>>2]|0;if((g|0)==98){f=b+12|0;h=c[f>>2]|0;if(!h){b=Od(a,b)|0;break a}g=c[b>>2]|0;k=c[b+16>>2]|0;c[k+8>>2]=c[e>>2];j=c[e>>2]|0;if(!j)c[g+16>>2]=k;else c[j+4>>2]=k;k=b+4|0;j=c[k>>2]|0;if(!j)c[g+12>>2]=h;else{c[h+4>>2]=j;c[(c[k>>2]|0)+8>>2]=h}j=c[f>>2]|0;if(!j)j=0;else{h=j;do{c[h>>2]=g;h=c[h+8>>2]|0}while((h|0)!=0)}c[f>>2]=0;c[e>>2]=0;zf(a,b);b=j;break a}else if((g|0)==79){if(c[b+12>>2]|0)break;Od(a,b)|0;b=f;break a}else if((g|0)==1){if(c[b+12>>2]|0)break;e=Lc(b,7664)|0;if(e)Oc(a,c[b>>2]|0,7672,c[e+24>>2]|0)|0;Od(a,b)|0;b=f;break a}else break}}while(0);if(c[b+20>>2]|0)Mc(a,b,7680);Hc(a,b);b=f}while(0)}while((b|0)!=0);i=d;return}function Ic(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;a:do if((((a|0)!=0?(g=c[a+28>>2]|0,(g|0)!=0):0)?(e=c[g+12>>2]|0,(e|0)!=0):0)?(f=c[e>>2]|0,(f|0)!=0):0){a=0;while(1){g=a+1|0;if((f|0)==(b|0))break;f=c[e+(g<<3)>>2]|0;if(!f){b=0;break a}else a=g}b=c[e+(a<<3)+4>>2]|0}else b=0;while(0);i=d;return b|0}function Jc(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a+20>>2]|0;a:do if(!a)a=0;else while(1){e=c[a+4>>2]|0;if((e|0)!=0?(c[e>>2]|0)==(b|0):0)break a;a=c[a>>2]|0;if(!a){a=0;break}}while(0);i=d;return a|0}function Kc(a,b){a=a|0;b=b|0;var d=0;d=i;if(!b){b=0;i=d;return b|0}b=yd(a,a+1564|0,c[b+20>>2]|0)|0;i=d;return b|0}function Lc(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a+20>>2]|0;a:do if(!a)a=0;else while(1){e=c[a+20>>2]|0;if((e|0)!=0?(vk(e,b)|0)==0:0)break a;a=c[a>>2]|0;if(!a){a=0;break}}while(0);i=d;return a|0}function Mc(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0;e=i;b=b+20|0;g=c[b>>2]|0;if(!g){i=e;return}else h=0;while(1){j=c[g>>2]|0;k=c[g+20>>2]|0;if((k|0)!=0?(vk(k,d)|0)==0:0)break;if(!j){f=9;break}else{h=g;g=j}}if((f|0)==9){i=e;return}if(!h)c[b>>2]=j;else c[h>>2]=j;Ef(a,g);i=e;return}function Nc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;g=i;f=bg(a)|0;c[f+16>>2]=34;h=a+2724|0;c[f+20>>2]=pk(c[h>>2]|0,d)|0;if(!e)c[f+24>>2]=0;else c[f+24>>2]=pk(c[h>>2]|0,e)|0;c[f+4>>2]=yd(a,a+1564|0,d)|0;dg(b,f);i=g;return f|0}function Oc(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;g=Lc(b,d)|0;if(!g){b=Nc(a,b,d,e)|0;i=f;return b|0}d=g+24|0;b=c[d>>2]|0;if(b){h=c[a+2724>>2]|0;ob[c[(c[h>>2]|0)+8>>2]&15](h,b)}if(!e)e=0;else e=pk(c[a+2724>>2]|0,e)|0;c[d>>2]=e;h=g;i=f;return h|0}function Pc(a,b){a=a|0;b=b|0;var c=0;c=i;a=zd(a,b,4)|0;i=c;return a|0}function Qc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;m=i;i=i+16|0;l=m;if((e|0)!=0?(j=e+24|0,h=c[j>>2]|0,(h|0)!=0):0){k=(xk(h,7696,11)|0)==0;f=b+280|0;n=0;q=0;o=0;while(1){p=h+o|0;r=a[p>>0]|0;s=r<<24>>24;if(r<<24>>24==92){n=n+1|0;if(!((c[f>>2]|0)==0|k))a[p>>0]=47}else if(r<<24>>24==127)g=10;else if(r<<24>>24){if(!(r<<24>>24>=33?(rm(7712,s,3)|0)==0:0))g=10}else break;if((g|0)==10){g=0;q=q+1|0}o=o+1|0}p=b+332|0;o=(q|0)!=0;if((c[p>>2]|0)!=0&o){q=(q<<1|1)+(qk(h)|0)|0;t=b+2724|0;r=c[t>>2]|0;q=rb[c[c[r>>2]>>2]&15](r,q)|0;r=0;s=0;while(1){u=a[h+r>>0]|0;v=u<<24>>24;if(!(u<<24>>24))break;else if((u<<24>>24!=127?u<<24>>24>=33:0)?(rm(7712,v,3)|0)==0:0){a[q+s>>0]=u;u=1}else g=17;if((g|0)==17){g=0;c[l>>2]=u&255;u=mm(q+s|0,7720,l)|0}r=r+1|0;s=u+s|0}a[q+s>>0]=0;v=c[t>>2]|0;ob[c[(c[v>>2]|0)+8>>2]&15](v,c[j>>2]|0);c[j>>2]=q}do if(n)if((c[f>>2]|0)==0|k){hi(b,d,e,61);break}else{hi(b,d,e,62);break}while(0);if(!o){i=m;return}if(!(c[p>>2]|0))hi(b,d,e,63);else hi(b,d,e,64);v=b+2716|0;c[v>>2]=c[v>>2]|32;i=m;return}hi(b,d,e,50);i=m;return}function Rc(a,b){a=a|0;b=b|0;var c=0;c=i;a=zd(a,b,14)|0;i=c;return a|0}function Sc(a,b){a=a|0;b=b|0;var d=0,e=0;a=i;if((b|0)!=0?(e=c[b+28>>2]|0,(e|0)!=0):0)switch(c[e>>2]|0){case 1:case 6:case 37:case 38:case 50:case 52:case 64:{b=1;break};default:d=4}else d=4;if((d|0)==4)b=0;i=a;return b|0}function Tc(b){b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,j=0;c=i;f=0;d=0;e=1;a:while(1){g=a[b>>0]|0;b=b+1|0;h=g&255;do if(g<<24>>24==92)g=1;else if(g<<24>>24){j=(f|0)>0;if((h+ -48|0)>>>0<10){if(j){e=f+1|0;f=e;e=(e|0)<6&1}if(!e){e=0;b=13;break a}g=f;e=((d|0)>0|(f|0)>0)&1;break}else{if(!j?!((d|0)>0&g<<24>>24==45):0)e=(g&255)>160|(Gl(h)|0)!=0;else e=1;g=0;e=e&1;break}}else{b=13;break a}while(0);if(!e){e=0;b=13;break}else{f=g;d=d+1|0}}if((b|0)==13){i=c;return e|0}return 0}function Uc(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;e=a+1564|0;f=c[e>>2]|0;a:do if(f){g=0;while(1){if((c[f+4>>2]|0)==(b|0))break;g=c[f>>2]|0;if(!g){f=0;break a}else{h=f;f=g;g=h}}b=c[f>>2]|0;if(!g){c[e>>2]=b;break}else{c[g>>2]=b;break}}else f=0;while(0);Ad(a,f);i=d;return}function Vc(a){a=a|0;var b=0,d=0,e=0;b=i;d=a+1564|0;e=c[d>>2]|0;if(!e){i=b;return}do{c[d>>2]=c[e>>2];Ad(a,e);e=c[d>>2]|0}while((e|0)!=0);i=b;return}function Wc(a){a=a|0;var b=0;b=i;Dm(a+1564|0,0,720)|0;i=b;return}function Xc(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;b=i;e=a+2724|0;g=0;do{f=a+(g<<2)+1572|0;h=c[f>>2]|0;if(h)do{o=h;h=c[h+4>>2]|0;n=c[e>>2]|0;ob[c[(c[n>>2]|0)+8>>2]&15](n,o)}while((h|0)!=0);c[f>>2]=0;g=g+1|0}while((g|0)!=178);Vc(a);f=a+1568|0;h=c[f>>2]|0;if(!h){i=b;return}do{c[f>>2]=c[h+12>>2];j=h+4|0;n=c[j>>2]|0;k=a+((Bd(n)|0)<<2)+1572|0;m=k;l=0;while(1){g=c[m>>2]|0;if(!g)break;o=c[g>>2]|0;if(!o)break;m=g+4|0;if(!(vk(n,c[o+4>>2]|0)|0)){d=10;break}else l=g}if((d|0)==10){d=0;m=c[m>>2]|0;if(!l)c[k>>2]=m;else c[l+4>>2]=m;o=c[e>>2]|0;ob[c[(c[o>>2]|0)+8>>2]&15](o,g)}o=c[e>>2]|0;ob[c[(c[o>>2]|0)+8>>2]&15](o,c[j>>2]|0);o=c[e>>2]|0;ob[c[(c[o>>2]|0)+8>>2]&15](o,h);h=c[f>>2]|0}while((h|0)!=0);i=b;return}function Yc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0;f=i;d=d+24|0;h=qk(c[d>>2]|0)|0;h=h+2+(qk(e)|0)|0;g=b+2724|0;b=c[g>>2]|0;b=rb[c[c[b>>2]>>2]&15](b,h)|0;a[b>>0]=0;h=c[d>>2]|0;if(h){tk(b,h)|0;uk(b,7688)|0}uk(b,e)|0;e=c[d>>2]|0;if(!e){c[d>>2]=b;i=f;return}h=c[g>>2]|0;ob[c[(c[h>>2]|0)+8>>2]&15](h,e);c[d>>2]=b;i=f;return}function Zc(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;m=i;r=c[d+20>>2]|0;if(!r){i=m;return}p=(e|0)==0;o=b+360|0;e=b+364|0;n=b+2724|0;q=b+112|0;do{a:do if((c[r+8>>2]|0)==0?(c[r+12>>2]|0)==0:0){y=c[r>>2]|0;if(y){s=0;b:while(1){v=(r|0)!=0;u=r+4|0;w=r+20|0;t=p&v;x=r+24|0;c:while(1){d:do if((c[y+8>>2]|0)==0?(c[y+12>>2]|0)==0:0){if(v?(l=c[u>>2]|0,(l|0)!=0):0)B=c[l>>2]|0;else B=0;if((y|0)!=0?(k=c[y+4>>2]|0,(k|0)!=0):0){z=c[k>>2]|0;A=(z|0)!=0;B=(B|0)!=0;if(B&A){if(!v){f=25;break}A=c[u>>2]|0;if(!A){f=25;break}C=c[A>>2]|0;if(!((C|0)==(z|0)&(C|0)!=0)){f=25;break}}else{z=B;f=20}}else{z=(B|0)!=0;A=0;f=20}if((f|0)==20){f=0;if(z|A){f=25;break}A=c[w>>2]|0;if(!A){f=25;break}z=c[y+20>>2]|0;if(!z){f=25;break}if(vk(A,z)|0){f=25;break}}do if(t?(j=c[u>>2]|0,(j|0)!=0):0){z=c[j>>2]|0;if((z|0)==25){if(!(c[o>>2]|0))break;do if(c[x>>2]|0){A=c[y+24>>2]|0;if(!A)break;Yc(b,r,A);C=c[y>>2]|0;hi(b,d,y,68);Gf(b,d,y);y=C;break d}while(0);if((z|0)!=136)break}else if((z|0)!=136)break;if(((c[e>>2]|0)!=0?(g=c[x>>2]|0,(g|0)!=0):0)?(h=c[y+24>>2]|0,(h|0)!=0):0){A=qk(g)|0;z=(A|0)!=0;do if(z){C=c[x>>2]|0;B=a[C+(A+ -1)>>0]|0;if(B<<24>>24==59){z=c[n>>2]|0;D=c[(c[z>>2]|0)+4>>2]|0;B=A+2+(qk(h)|0)|0;C=mb[D&3](z,C,B)|0;c[x>>2]=C;uk(C,7688)|0;uk(c[x>>2]|0,h)|0;break}else if(B<<24>>24==125){B=c[n>>2]|0;z=c[(c[B>>2]|0)+4>>2]|0;D=A+6+(qk(h)|0)|0;D=mb[z&3](B,C,D)|0;c[x>>2]=D;uk(D,7736)|0;uk(c[x>>2]|0,h)|0;uk(c[x>>2]|0,7744)|0;break}else{f=43;break}}else{C=c[x>>2]|0;f=43}while(0);if((f|0)==43){f=0;D=c[n>>2]|0;B=c[(c[D>>2]|0)+4>>2]|0;A=A+3+(qk(h)|0)|0;A=mb[B&3](D,C,A)|0;c[x>>2]=A;if(z){uk(A,7752)|0;A=c[x>>2]|0}uk(A,h)|0}D=c[y>>2]|0;hi(b,d,y,68);Gf(b,d,y);y=D;break d}}while(0);if((c[q>>2]|0)==1)break c;D=c[y>>2]|0;hi(b,d,y,55);Gf(b,d,y);y=D}else f=25;while(0);if((f|0)==25){f=0;y=c[y>>2]|0}if(!y)break b}s=c[r>>2]|0;hi(b,d,r,55);Gf(b,d,r);y=c[y>>2]|0;if(!y){r=s;break a}else{r=s;s=1}}if(s)break}r=c[r>>2]|0}else f=5;while(0);if((f|0)==5){f=0;r=c[r>>2]|0}}while((r|0)!=0);i=m;return}function _c(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;f=c[d+4>>2]|0;if(f){if(((c[f>>2]|0)+ -153|0)>>>0<2?(c[(c[a+68>>2]|0)+28>>2]=1,(c[a+180>>2]|0)==0):0){Li(a,26,1)|0;Li(a,25,1)|0}lf(a,Cd(b,d)|0);g=c[f+8>>2]|0;if(g)qb[g&63](a,b,d)}if(!((b|0)!=0&(d|0)!=0)){i=e;return f|0}g=c[b+28>>2]|0;if(!g){i=e;return f|0}if(!(c[g+8>>2]&401407)){i=e;return f|0}if((Cd(b,d)|0)&401407){i=e;return f|0}hi(a,b,d,53);if(!(c[a+212>>2]|0)){i=e;return f|0}Gf(a,b,d);i=e;return f|0}function $c(a){a=a|0;var b=0,d=0;b=i;if(((a|0)!=0?(d=c[a+4>>2]|0,(d|0)!=0):0)?(c[d+8>>2]|0)==5:0){d=1;i=b;return d|0}d=0;i=b;return d|0}function ad(a){a=a|0;var b=0,d=0;b=i;if((a|0)!=0?(d=c[a+4>>2]|0,(d|0)!=0):0)a=((c[d>>2]|0)+ -86|0)>>>0<27;else a=0;i=b;return a&1|0}function bd(b){b=b|0;var c=0,d=0;c=i;a:do if(!b)b=0;else while(1){d=a[b>>0]|0;if(!(d<<24>>24)){b=1;break a}if(!(qf(d<<24>>24)|0))b=b+1|0;else{b=0;break}}while(0);i=c;return b|0}function cd(b){b=b|0;var d=0,e=0,f=0,g=0,h=0;d=i;i=i+16|0;e=d;if(!b){b=0;i=d;return b|0}f=b+1|0;h=a[b>>0]|0;g=h<<24>>24;c[e>>2]=g;if(h<<24>>24<0){f=b+((Hk(f,e)|0)+1)|0;g=c[e>>2]|0}if((sf(g)|0)==0?(h=c[e>>2]|0,!((h|0)==58|(h|0)==95)):0){h=0;i=d;return h|0}while(1){b=a[f>>0]|0;if(!(b<<24>>24)){f=1;e=10;break}g=b&255;c[e>>2]=g;if(b<<24>>24<0){f=f+(Hk(f,e)|0)|0;g=c[e>>2]|0}if(!(tf(g)|0)){f=0;e=10;break}else f=f+1|0}if((e|0)==10){i=d;return f|0}return 0}function dd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=i;if(!a){i=e;return}f=(b|0)==1?15:0;a:while(1){g=a+20|0;m=c[g>>2]|0;if(!m)l=0;else{j=1;while(1){if(!m){d=5;break a}k=(j|0)>0;l=0;h=0;r=0;while(1){h=h+1|0;b:do if(k){o=0;p=m;while(1){o=o+1|0;p=c[p>>2]|0;if(!p){n=m;p=0;q=j;break b}if((o|0)>=(j|0)){n=m;q=j;break}}}else{n=m;o=0;p=m;q=j}while(0);c:while(1)while(1){if((o|0)<=0){if(!((q|0)>0&(p|0)!=0))break c;if(!o){m=p;o=0;p=c[p>>2]|0;q=q+ -1|0}else d=16}else d=16;do if((d|0)==16){d=0;if(!((q|0)!=0&(p|0)!=0)){m=n;n=c[n>>2]|0;o=o+ -1|0;break}if((rb[f&15](n,p)|0)<1){m=n;n=c[n>>2]|0;o=o+ -1|0;break}else{m=p;p=c[p>>2]|0;q=q+ -1|0;break}}while(0);if(!r){l=m;r=m;continue c}c[r>>2]=m;r=m}if(!p)break;else m=p}c[r>>2]=0;if((h|0)<2)break;else{m=l;j=j<<1}}}c[g>>2]=l;g=c[a+12>>2]|0;if(g)dd(g,b);a=c[a+8>>2]|0;if(!a){d=27;break}}if((d|0)==5)gb();else if((d|0)==27){i=e;return}}function ed(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if((d|0)!=0?(c[d+24>>2]|0)!=0:0)Qc(a,b,d);i=e;return}function fd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;e=i;f=b+28|0;j=c[f>>2]|0;if((j|0)!=0?(c[j+16>>2]&65536|0)!=0:0){wd(a,b,d);i=e;return}if((d|0)!=0?(h=d+24|0,(c[h>>2]|0)!=0):0){Ed(a,b,d);if(((b|0)!=0?(g=c[f>>2]|0,(g|0)!=0):0)?(c[g>>2]|0)==19:0){i=e;return}if(Fd(d,16408)|0){i=e;return}f=c[h>>2]|0;if(((f|0)!=0?(wk(f,12208)|0)==0:0)?(Ve(b,640)|0)!=0:0){i=e;return}hi(a,b,d,51);i=e;return}hi(a,b,d,50);i=e;return}function gd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;g=i;if((e|0)!=0?(f=e+24|0,h=c[f>>2]|0,(h|0)!=0):0){do if((a[h>>0]|0)==35)j=10;else{k=Gd(h)|0;if(!k)if((a[h>>0]|0)==35){j=10;break}else{k=0;j=18;break}j=b+2724|0;m=c[j>>2]|0;n=c[c[m>>2]>>2]|0;l=(qk(h)|0)+2|0;l=rb[n&15](m,l)|0;a[l>>0]=35;m=l;while(1){m=m+1|0;n=a[h>>0]|0;a[m>>0]=n;if(!(n<<24>>24))break;else h=h+1|0}hi(b,d,e,73);h=c[j>>2]|0;ob[c[(c[h>>2]|0)+8>>2]&15](h,c[f>>2]|0);c[f>>2]=l;h=l;j=11}while(0);if((j|0)==10){k=Gd(h+1|0)|0;if(!k){k=0;j=18}else j=11}a:do if((j|0)==11){if((a[h>>0]|0)==35?(c[b+384>>2]|0)!=0:0){m=16008;j=0;while(1){l=j+1|0;if(!(wk(h,c[16012+(j<<3)>>2]|0)|0))break;if((l|0)==16)break a;else{m=16008+(l<<3)|0;j=l}}j=c[m>>2]|0;if(j){h=b+2724|0;n=c[h>>2]|0;ob[c[(c[n>>2]|0)+8>>2]&15](n,c[f>>2]|0);h=pk(c[h>>2]|0,j)|0;c[f>>2]=h}}}else if((j|0)==18){while(1){j=0;l=k+1|0;if(!(wk(h,c[16008+(k<<3)>>2]|0)|0)){j=19;break}if((l|0)==16){k=0;break}else{k=l;j=18}}if((j|0)==19)k=(k|0)!=16;k=k&1}while(0);if(!k){hi(b,d,e,51);i=g;return}b=c[f>>2]|0;if((a[h>>0]|0)==35){c[f>>2]=Ck(b)|0;i=g;return}else{c[f>>2]=Bk(b)|0;i=g;return}}hi(b,d,e,50);i=g;return}function hd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if((d|0)!=0?(c[d+24>>2]|0)!=0:0)Ed(a,b,d);i=e;return}function id(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;g=i;if((e|0)!=0?(k=c[e+24>>2]|0,(k|0)!=0):0){do if((d|0)!=0?(j=c[d+28>>2]|0,h=(j|0)==0,!h):0){if((c[j>>2]|0)==39){l=c[e+4>>2]|0;if(l){if((c[l>>2]|0)==32){i=g;return}if((c[l>>2]|0)==120){i=g;return}}if(h)break}if((c[j>>2]|0)==36?(l=a[k>>0]|0,l<<24>>24==45|l<<24>>24==43):0)k=k+1|0}while(0);h=a[k>>0]|0;if(!(h<<24>>24)){i=g;return}while(1){k=k+1|0;if(!(of(h<<24>>24)|0))break;h=a[k>>0]|0;if(!(h<<24>>24)){f=18;break}}if((f|0)==18){i=g;return}hi(b,d,e,51);i=g;return}hi(b,d,e,50);i=g;return}function jd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;g=i;if((e|0)!=0?(h=c[e+24>>2]|0,(h|0)!=0):0){k=c[e+4>>2]|0;if((((k|0)!=0?(c[k>>2]|0)==151&(d|0)!=0:0)?(j=c[d+28>>2]|0,(j|0)!=0):0)?((c[j>>2]|0)+ -23|0)>>>0<2:0){i=g;return}if(!(of(a[h>>0]|0)|0)){hi(b,d,e,51);i=g;return}j=h+1|0;h=a[j>>0]|0;if(!(h<<24>>24)){i=g;return}while(1){if((of(h<<24>>24)|0)==0?(a[j>>0]|0)!=37:0)break;j=j+1|0;h=a[j>>0]|0;if(!(h<<24>>24)){f=15;break}}if((f|0)==15){i=g;return}hi(b,d,e,51);i=g;return}hi(b,d,e,50);i=g;return}function kd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;f=d+24|0;if((d|0)!=0?(c[f>>2]|0)!=0:0){Ed(a,b,d);if(Fd(d,15968)|0){i=e;return}hi(a,b,d,51);i=e;return}hi(a,b,d,50);if(c[f>>2]|0){i=e;return}c[f>>2]=pk(c[a+2724>>2]|0,15992)|0;i=e;return}function ld(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15936);i=d;return}function md(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if(d){if(c[d+24>>2]|0){i=e;return}f=c[d+4>>2]|0;if((f|0)!=0?(c[f>>2]|0)==153:0){i=e;return}}if(c[a+408>>2]|0){i=e;return}hi(a,b,d,50);i=e;return}function nd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;f=i;e=c[a+68>>2]|0;if((d|0)!=0?(g=d+24|0,h=c[g>>2]|0,(h|0)!=0):0){do if(!(bd(h)|0)){if((c[e+28>>2]|0)!=0?(cd(c[g>>2]|0)|0)!=0:0){hi(a,b,d,71);break}hi(a,b,d,51)}while(0);h=Id(a,c[g>>2]|0)|0;if((h|0)==0|(h|0)==(b|0)){Jd(a,c[g>>2]|0,b);i=f;return}else{hi(a,b,d,66);i=f;return}}hi(a,b,d,50);i=f;return}function od(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15904);i=d;return}function pd(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0;h=i;i=i+16|0;f=h;if((e|0)!=0?(g=e+24|0,j=c[g>>2]|0,(j|0)!=0):0){if(!(Sc(0,d)|0)){i=h;return}a:do if(c[b+172>>2]|0){while(1){l=a[j>>0]|0;if(!(l<<24>>24))break a;k=l&255;c[f>>2]=k;if(l<<24>>24<0){j=j+(Hk(j,f)|0)|0;k=c[f>>2]|0}if(!(tf(k)|0))break;else j=j+1|0}hi(b,d,e,51)}while(0);l=Id(b,c[g>>2]|0)|0;if((l|0)==0|(l|0)==(d|0)){Jd(b,c[g>>2]|0,d);i=h;return}else{hi(b,d,e,66);i=h;return}}hi(b,d,e,50);i=h;return}function qd(a,b,c){a=a|0;b=b|0;c=c|0;return}function rd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15832);i=d;return}function sd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15792);i=d;return}function td(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15752);i=d;return}function ud(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0;f=i;if((e|0)!=0?(g=c[e+24>>2]|0,(g|0)!=0):0){if(pf(a[g>>0]|0)|0){i=f;return}if(Fd(e,15696)|0){i=f;return}hi(b,d,e,51);i=f;return}hi(b,d,e,50);i=f;return}function vd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;a:do if((b|0)!=0?(f=c[b+28>>2]|0,(f|0)!=0):0)switch(c[f>>2]|0){case 53:{Hd(a,b,d,15328);break a};case 18:{Hd(a,b,d,15600);break a};case 115:{Hd(a,b,d,15616);break a};case 61:{if((d|0)!=0?(c[d+24>>2]|0)!=0:0){if(Fd(d,15616)|0){Ed(a,b,d);break a}if(Fd(d,15656)|0)break a;hi(a,b,d,51);break a}hi(a,b,d,50);break a};case 76:{if((d|0)!=0?(c[d+24>>2]|0)!=0:0){if(Fd(d,15656)|0)break a;hi(a,b,d,51);break a}hi(a,b,d,50);break a};default:break a}while(0);i=e;return}function wd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if((d|0)!=0?(c[d+24>>2]|0)!=0:0){Ed(a,b,d);if(Fd(d,15152)|0){i=e;return}if(!(Fd(d,15216)|0))if(!(Fd(d,15248)|0)){hi(a,b,d,51);i=e;return}else{lf(a,57344);hi(a,b,d,54);i=e;return}else{f=c[b+28>>2]|0;if((f|0)!=0?(c[f+16>>2]&65536|0)!=0:0){i=e;return}hi(a,b,d,51);i=e;return}}hi(a,b,d,50);i=e;return}function xd(a,b,c){a=a|0;b=b|0;c=c|0;var d=0;d=i;Hd(a,b,c,15128);i=d;return}function yd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;f=i;if(!d){j=0;i=f;return j|0}g=c[b+((Bd(d)|0)<<2)+8>>2]|0;a:do if(!g){h=11968;j=7764|0;g=7760}else{while(1){h=c[g>>2]|0;if(!h){h=11968;j=7764|0;g=7760;break a}if(!(vk(d,c[h+4>>2]|0)|0))break;g=c[g+4>>2]|0;if(!g){h=11968;j=7764|0;g=7760;break a}}j=c[g>>2]|0;i=f;return j|0}while(0);while(1){if(!(vk(d,h)|0))break;j=g+20|0;h=c[j>>2]|0;if(!h){a=0;e=10;break}else g=g+16|0}if((e|0)==10){i=f;return a|0}h=c[a+2724>>2]|0;h=rb[c[c[h>>2]>>2]&15](h,8)|0;c[h>>2]=g;j=b+((Bd(c[j>>2]|0)|0)<<2)+8|0;c[h+4>>2]=c[j>>2];c[j>>2]=h;j=g;i=f;return j|0}function zd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;b=yd(a,a+1564|0,b)|0;if(!b)d=0;else d=(c[b+8>>2]|0)==(d|0);i=e;return d&1|0}function Ad(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=a+2724|0;if(b){e=c[a>>2]|0;ob[c[(c[e>>2]|0)+8>>2]&15](e,c[b+8>>2]|0)}e=c[a>>2]|0;ob[c[(c[e>>2]|0)+8>>2]&15](e,b);i=d;return}function Bd(b){b=b|0;var c=0,d=0,e=0;c=i;d=a[b>>0]|0;if(!(d<<24>>24)){e=0;i=c;return e|0}else e=0;do{e=(d<<24>>24)+(e*31|0)|0;b=b+1|0;d=a[b>>0]|0}while(d<<24>>24!=0);e=(e>>>0)%178|0;i=c;return e|0}function Cd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;a:do if(b){j=c[b+20>>2]|0;if((j|0)!=0?(h=(xk(j,7728,5)|0)==0,h):0){e=h?393216:0;break}b=c[b+4>>2]|0;if(b)if((((a|0)!=0?(g=c[a+28>>2]|0,(g|0)!=0):0)?(e=c[g+12>>2]|0,(e|0)!=0):0)?(f=c[e>>2]|0,(f|0)!=0):0){a=c[b>>2]|0;g=0;while(1){b=g+1|0;if((f|0)==(a|0))break;f=c[e+(b<<3)>>2]|0;if(!f){e=57344;break a}else g=b}e=c[e+(g<<3)+4>>2]|0}else e=57344;else e=0}else e=0;while(0);i=d;return e|0}function Dd(a,b){a=a|0;b=b|0;var d=0;d=i;a=vk(c[a+20>>2]|0,c[b+20>>2]|0)|0;i=d;return a|0}function Ed(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;h=i;if(!e){i=h;return}f=e+24|0;j=c[f>>2]|0;if(!j){i=h;return}k=a[j>>0]|0;if(!(k<<24>>24)){i=h;return}while(1){j=j+1|0;if(uf(k<<24>>24)|0)break;k=a[j>>0]|0;if(!(k<<24>>24)){g=10;break}}if((g|0)==10){i=h;return}j=(c[b+68>>2]|0)+28|0;if(!((c[j>>2]|0)!=0?(hi(b,d,e,70),(c[j>>2]|0)!=0):0))g=8;if((g|0)==8?(c[b+336>>2]|0)==0:0){i=h;return}c[f>>2]=Bk(c[f>>2]|0)|0;i=h;return}function Fd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;g=c[b>>2]|0;a:do if(!g)e=0;else{f=(a|0)==0;a=a+24|0;while(1){if((!f?(e=c[a>>2]|0,(e|0)!=0):0)?(wk(e,g)|0)==0:0){e=1;break a}b=b+4|0;g=c[b>>2]|0;if(!g){e=0;break}}}while(0);i=d;return e|0}function Gd(b){b=b|0;var c=0,d=0,e=0;c=i;if((qk(b)|0)==6)d=0;else{e=0;i=c;return e|0}while(1){e=b+d|0;if((of(a[e>>0]|0)|0)==0?(rm(16400,vf(a[e>>0]|0)|0,7)|0)==0:0){d=0;b=5;break}d=d+1|0;if(d>>>0>=6){d=1;b=5;break}}if((b|0)==5){i=c;return d|0}return 0}function Hd(a,b,d,e){a=a|0;b=b|0;d=d|0;e=e|0;var f=0;f=i;if((d|0)!=0?(c[d+24>>2]|0)!=0:0){Ed(a,b,d);if(Fd(d,e)|0){i=f;return}hi(a,b,d,51);i=f;return}hi(a,b,d,50);i=f;return}function Id(a,b){a=a|0;b=b|0;var d=0,e=0;e=i;d=a+2724|0;b=Bk(pk(c[d>>2]|0,b)|0)|0;a=c[a+1564>>2]|0;a:do if(a){while(1){if(!(vk(c[a+8>>2]|0,b)|0))break;a=c[a>>2]|0;if(!a)break a}d=c[d>>2]|0;ob[c[(c[d>>2]|0)+8>>2]&15](d,b);a=c[a+4>>2]|0;i=e;return a|0}while(0);a=c[d>>2]|0;ob[c[(c[a>>2]|0)+8>>2]&15](a,b);a=0;i=e;return a|0}function Jd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0;e=i;g=a+2724|0;f=c[g>>2]|0;f=rb[c[c[f>>2]>>2]&15](f,12)|0;g=pk(c[g>>2]|0,b)|0;b=f+8|0;c[b>>2]=g;c[b>>2]=Bk(g)|0;c[f+4>>2]=d;c[f>>2]=0;d=a+1564|0;a=c[d>>2]|0;if(!a){c[d>>2]=f;i=e;return}while(1){d=c[a>>2]|0;if(!d)break;else a=d}c[a>>2]=f;i=e;return}function Kd(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;f=c[a+4>>2]|0;d=(f|0)==0;if(!d?(c[f+8>>2]|0)!=(a|0):0)a=0;else e=3;a:do if((e|0)==3){f=c[a+8>>2]|0;e=(f|0)==0;if(!e){if((f|0)==(a|0)){a=0;break}if((c[f+4>>2]|0)!=(a|0)){a=0;break}}f=c[a>>2]|0;if(f){if(d?(c[f+12>>2]|0)!=(a|0):0){a=0;break}if(e?(c[f+16>>2]|0)!=(a|0):0){a=0;break}}d=c[a+12>>2]|0;if(!d)a=1;else while(1){if((c[d>>2]|0)!=(a|0)){a=0;break a}if(!(Kd(d)|0)){a=0;break a}d=c[d+8>>2]|0;if(!d){a=1;break}}}while(0);i=b;return a|0}function Ld(a){a=a|0;var b=0,d=0;b=i;if((a|0)!=0?(d=c[a+28>>2]|0,(d|0)!=0):0)a=c[d+16>>2]&1048576;else a=1;i=b;return a|0}function Md(a,b,d,e,f){a=a|0;b=b|0;d=d|0;e=e|0;f=f|0;var g=0,h=0;g=i;d=Ke(d)|0;h=Tf(a,c[d>>2]|0)|0;do if(!e)if(!f){ni(a,b,h,83);break}else{oi(a,b,h,84);break}else mi(a,b,h,20);while(0);e=a+2724|0;f=c[e>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[h+32>>2]|0);f=c[e>>2]|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,h);f=b+28|0;c[b+24>>2]=c[f>>2];c[f>>2]=d;c[b+44>>2]=5;c[b+60>>2]=1;f=c[e>>2]|0;h=b+32|0;ob[c[(c[f>>2]|0)+8>>2]&15](f,c[h>>2]|0);c[h>>2]=pk(c[e>>2]|0,c[d+4>>2]|0)|0;i=g;return}function Nd(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0;e=i;d=a+4|0;g=c[d>>2]|0;b=a+8|0;if(g)c[g+8>>2]=c[b>>2];f=c[b>>2]|0;if(f)c[f+4>>2]=g;g=c[a>>2]|0;if(g){h=g+12|0;if((c[h>>2]|0)==(a|0))c[h>>2]=f;f=g+16|0;if((c[f>>2]|0)==(a|0))c[f>>2]=c[d>>2]}c[b>>2]=0;c[d>>2]=0;c[a>>2]=0;i=e;return a|0}function Od(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if(!b){a=0;i=d;return a|0}e=c[b+8>>2]|0;Nd(b)|0;zf(a,b);a=e;i=d;return a|0}function Pd(a,b){a=a|0;b=b|0;var d=0,e=0;c[b>>2]=a;d=a+12|0;e=c[d>>2]|0;if(!e)c[a+16>>2]=b;else c[e+4>>2]=b;c[b+8>>2]=e;c[b+4>>2]=0;c[d>>2]=b;return}function Qd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;c[b>>2]=a;e=a+16|0;f=c[e>>2]|0;c[b+4>>2]=f;if(!f){c[a+12>>2]=b;c[e>>2]=b;i=d;return}else{c[f+8>>2]=b;c[e>>2]=b;i=d;return}}function Rd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;e=c[a>>2]|0;c[b>>2]=e;c[b+8>>2]=a;g=a+4|0;f=b+4|0;c[f>>2]=c[g>>2];c[g>>2]=b;f=c[f>>2]|0;if(f)c[f+8>>2]=b;e=e+12|0;if((c[e>>2]|0)!=(a|0)){i=d;return}c[e>>2]=b;i=d;return}function Sd(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;e=c[a>>2]|0;c[b>>2]=e;if((e|0)!=0?(f=e+16|0,(c[f>>2]|0)==(a|0)):0){c[f>>2]=b;e=a+8|0}else{e=a+8|0;f=c[e>>2]|0;c[b+8>>2]=f;if(f)c[f+4>>2]=b}c[e>>2]=b;c[b+4>>2]=a;i=d;return}function Td(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0,h=0,j=0;d=i;a:do if(c[a+220>>2]|0){if(!(Te(b)|0)){if(c[b+12>>2]|0)break;f=b+28|0;h=c[f>>2]|0;if(!h)break;j=c[h+16>>2]|0;if((j&8|0)!=0?(c[b+20>>2]|0)!=0:0)break;e=(b|0)!=0;do if(e){g=c[h>>2]|0;if((g|0)==1)if((c[b+20>>2]|0)==0&(j&513|0)==0){g=17;break}else break a;else if((g|0)==79)if((c[a+224>>2]|0)!=0&(j&513|0)==0){g=17;break}else break a;else{g=11;break}}else g=11;while(0);if((g|0)==11){if(j&513)break;if(e){j=c[h>>2]|0;if((j|0)==92){if(Jc(b,133)|0)break;h=c[f>>2]|0}else if((j|0)==75|(j|0)==6)break;if(h)g=17}}if((g|0)==17)switch(c[h>>2]|0){case 136:case 123:case 107:case 50:case 111:break a;default:{}}if(Jc(b,62)|0)break;if(Jc(b,80)|0)break;if(Jc(b,38)|0)break;f=c[f>>2]|0;g=c[f>>2]|0;if(!g)break;if(e&(f|0)!=0&(g&-9|0)==16)break}if((c[b+44>>2]|0)!=4)ni(a,b,0,23);j=Od(a,b)|0;i=d;return j|0}while(0);j=c[b+8>>2]|0;i=d;return j|0}function Ud(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;e=i;if(!b){i=e;return 0}do{f=c[b+8>>2]|0;g=c[b+12>>2]|0;if(g)Ud(a,g)|0;if(!(Ue(b)|0))if((Te(b)|0)!=0?(c[b+36>>2]|0)>>>0>=(c[b+40>>2]|0)>>>0:0)d=7;else b=f;else d=7;if((d|0)==7){d=0;b=Td(a,b)|0}}while((b|0)!=0);i=e;return 0}function Vd(b,d){b=b|0;d=d|0;var e=0,f=0;e=i;if(!(Te(d)|0)){d=0;i=e;return d|0}f=c[d+40>>2]|0;d=c[d+36>>2]|0;if((f|0)!=(d|0))if((f|0)==(d+1|0))b=(a[(c[b+84>>2]|0)+d>>0]|0)==32;else b=0;else b=1;d=b&1;i=e;return d|0}function Wd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;d=i;f=c[a+68>>2]|0;g=b+28|0;e=c[g>>2]|0;h=c[e+16>>2]|0;if(h&1){i=d;return}if(((e|0)!=0?(c[e>>2]|0)==37:0)?(se(b,37)|0)!=0:0){oi(a,b,0,25);h=c[(c[g>>2]|0)+16>>2]|0}if(!(h&2048))e=0;else{v=f+116|0;e=c[v>>2]|0;c[v>>2]=c[f+112>>2]}if(!(h&131072))xl(a,0)|0;q=$f(a,0)|0;a:do if(!q)q=0;else{n=b+24|0;j=f+24|0;m=a+2720|0;k=b+60|0;h=a+2724|0;l=f+20|0;o=0;p=1;b:while(1){s=q+44|0;t=(c[s>>2]|0)==6;u=c[q+28>>2]|0;if(t)if(u){if((u|0)==(c[g>>2]|0)){r=16;break}if((c[n>>2]|0)==(u|0)){r=16;break}else r=21}else{u=0;r=31}else r=21;do if((r|0)==21){r=0;v=(u|0)==0;if(!v){if((c[u>>2]|0)==16){if(se(b,46)|0){r=24;break b}if(v){u=0;r=31;break}}v=c[u>>2]|0;if((v|0)==16|(v|0)==46|(v|0)==48){if(Ue(q)|0)oi(a,b,q,8);zf(a,q)}else r=31}else{u=0;r=31}}while(0);c:do if((r|0)==31){do if(t){r=q+28|0;if(!u){oi(a,b,q,8);zf(a,q);break c}if((c[u>>2]|0)==17){c[s>>2]=5;break}if((c[u>>2]|0)==79){c[s>>2]=7;c[q+60>>2]=1;break}if(se(b,c[u>>2]|0)|0){r=39;break b}if(c[j>>2]|0){if(Ve(q,128)|0){r=44;break b}v=c[r>>2]|0;if((v|0)!=0?(c[v>>2]|0)==104:0){r=44;break b}}}while(0);if(Te(q)|0){if(((p|0)!=0?(c[(c[g>>2]|0)+16>>2]&131072|0)==0:0)?(xl(a,q)|0)>0:0){p=0;break}Qd(b,q);o=c[g>>2]|0;if(!o){o=1;p=0;break}switch(c[o>>2]|0){case 74:case 37:case 15:case 64:case 16:break;default:{o=1;p=0;break c}}lf(a,-293);o=1;p=0;break}if(!(ue(b,q)|0)){s=c[q+28>>2]|0;do if(s){r=c[s>>2]|0;if((r|0)==7){v=c[g>>2]|0;if(((v|0)!=0?(c[v>>2]|0)==64:0)?(Ue(q)|0)!=0:0){Qd(b,q);break c}oi(a,b,q,8);zf(a,q);break c}else if((r|0)==80){if((Ve(b,4096)|0)!=0?(Ue(q)|0)!=0:0){Qd(b,q);break c}oi(a,b,q,8);zf(a,q);break c}else{r=q+28|0;if(!s)break;d:do if(!(Ve(q,16)|0)){if(!(Ue(q)|0)){r=c[r>>2]|0;do if(r){if((c[r>>2]|0)!=37)break;c[m>>2]=1}while(0);oi(a,b,q,8);zf(a,q);break c}s=c[g>>2]|0;e:do if(s){t=c[s>>2]|0;f:do if((t|0)==61){s=c[r>>2]|0;if(!s)break e;do if((c[s>>2]|0)!=38){v=c[s>>2]|0;if((v|0)==78|(v|0)==77|(v|0)==39)break;if((t|0)==109|(t|0)==106)break f;else break e}while(0);oi(a,b,q,8);zf(a,q);break c}else if(!((t|0)==109|(t|0)==106))break e;while(0);if(Ve(q,4)|0){ve(a,b,q);break c}do if(!(Ve(q,32)|0)){if(!(Ve(q,64)|0))break;_f(a);q=Tf(a,31)|0;c[l>>2]=1}else{_f(a);q=Tf(a,115)|0;we(a,q);c[l>>2]=1}while(0);if(!(Ve(q,8)|0)){r=86;break b}else break d}while(0);if(Ve(q,8)|0)if(!(c[l>>2]|0))break;else{r=89;break b}r=c[r>>2]|0;if(c[r+16>>2]&4){ve(a,b,q);break c}s=c[g>>2]|0;do if(s){if((c[s>>2]|0)!=37)break;s=c[b>>2]|0;if(!s)break;t=c[s+28>>2]|0;if(!t)break;if((c[t>>2]|0)!=106)break;if((c[s+60>>2]|0)==0|(r|0)==0)break;if((c[r>>2]|0)==106){oi(a,b,q,8);zf(a,q);break c}if((c[r>>2]|0)!=109)break;oi(a,b,q,8);zf(a,q);v=c[b>>2]|0;t=c[h>>2]|0;u=v+32|0;ob[c[(c[t>>2]|0)+8>>2]&15](t,c[u>>2]|0);c[u>>2]=pk(c[h>>2]|0,16448)|0;c[v+28>>2]=Ke(109)|0;break c}while(0);do if(!(Ve(b,32768)|0)){if(c[k>>2]|0)break;oi(a,b,q,7)}while(0);_f(a);if(Ve(q,32)|0){q=c[b>>2]|0;do if(q){q=c[q+28>>2]|0;if(!q)break;if((c[q+20>>2]|0)==27){r=113;break b}}while(0);q=Tf(a,115)|0;we(a,q);break}if(!(Ve(q,64)|0)){if((Ve(q,128)|0)==0?(Ve(q,512)|0)==0:0){r=125;break b}if(c[j>>2]|0){r=153;break b}q=Tf(a,104)|0;break}else{q=c[b>>2]|0;do if(q){q=c[q+28>>2]|0;if(!q)break;if((c[q>>2]|0)==31){r=119;break b}}while(0);q=Tf(a,31)|0;break}}while(0);if(!(Ue(q)|0)){if((c[q+44>>2]|0)==6)vl(a,q);oi(a,b,q,8);zf(a,q);break c}r=q+28|0;do if(c[(c[r>>2]|0)+16>>2]&16){if(!p){o=1;p=0;break}if(c[q+60>>2]|0){o=1;break}if(c[(c[g>>2]|0)+16>>2]&131072){o=1;p=0;break}if((xl(a,q)|0)>0){p=0;break c}else{o=1;p=0}}else{o=0;p=1}while(0);do if(q){r=c[r>>2]|0;if(!r)break;if((c[r>>2]|0)!=17)break;te(a,b)}while(0);Qd(b,q);if(c[q+60>>2]|0)oi(a,b,q,15);xe(a,q,0);break c}}while(0);oi(a,b,q,8);zf(a,q)}}while(0);q=$f(a,o)|0;if(!q){q=0;break a}}switch(r|0){case 16:{zf(a,q);if(c[(c[g>>2]|0)+16>>2]&2048){g=f+112|0;f=f+116|0;if((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0)do vl(a,0);while((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0);c[f>>2]=e}c[b+56>>2]=1;te(a,b);i=d;return};case 24:{_f(a);break a};case 39:{_f(a);break a};case 44:{_f(a);te(a,b);i=d;return};case 86:{_f(a);te(a,b);i=d;return};case 89:{if(!(Ve(b,32768)|0))oi(a,b,q,7);_f(a);if(Ve(b,2048)|0)c[f+116>>2]=e;te(a,b);i=d;return};case 113:{te(a,b);i=d;return};case 119:{te(a,b);i=d;return};case 125:{if(!(Ve(b,2048)|0)){te(a,b);i=d;return}g=f+112|0;f=f+116|0;if((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0)do vl(a,0);while((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0);c[f>>2]=e;te(a,b);i=d;return};case 153:{i=d;return}}}while(0);h=c[(c[g>>2]|0)+16>>2]|0;if(!(h&32768)){oi(a,b,q,6);h=c[(c[g>>2]|0)+16>>2]|0}if(h&2048){g=f+112|0;f=f+116|0;if((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0)do vl(a,0);while((c[g>>2]|0)>>>0>(c[f>>2]|0)>>>0);c[f>>2]=e}te(a,b);i=d;return}function Xd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;k=i;m=c[a+68>>2]|0;d=b+28|0;if(c[(c[d>>2]|0)+16>>2]&1){i=k;return}c[m+100>>2]=0;o=$f(a,0)|0;a:do if(o){h=m+24|0;j=(b|0)==0;l=b+12|0;m=m+20|0;n=a+2720|0;b:while(1){p=o+28|0;if((c[p>>2]|0)==(c[d>>2]|0)?(c[o+44>>2]|0)==6:0){e=6;break}do if(!(ue(b,o)|0)){q=c[o+44>>2]|0;if((q|0)!=4){r=c[p>>2]|0;if(!r){oi(a,b,o,8);zf(a,o);break}if((q|0)==6){if((c[r>>2]|0)==37){c[n>>2]=1;oi(a,b,o,8);zf(a,o);break}if(!(Ve(o,16)|0))r=b;else{oi(a,b,o,8);vl(a,o);zf(a,o);break}while(1){r=c[r>>2]|0;if(!r)break;q=c[r+28>>2]|0;if((q|0)!=0?(c[q>>2]|0)==16:0)break;if((c[p>>2]|0)==(q|0)){e=21;break b}}oi(a,b,o,8);zf(a,o);break}}r=c[p>>2]|0;if((r|0)!=0?(c[r>>2]|0)==61:0)Qd(b,o);else e=25;do if((e|0)==25){e=0;_f(a);if((Ve(o,8)|0)!=0?(c[m>>2]|0)!=0:0){e=27;break b}if(c[h>>2]|0){if(Ve(o,896)|0){e=46;break b}r=c[p>>2]|0;if((r|0)!=0?(c[r>>2]|0)==104:0){e=46;break b}}if(((!j?(g=c[d>>2]|0,(g|0)!=0):0)?(c[g>>2]|0)==76:0)?(f=c[l>>2]|0,(f|0)!=0):0){r=0;p=f;do{q=c[p+28>>2]|0;do if(q){if((c[q>>2]|0)!=61)break;r=(c[p+44>>2]|0)==5?p:r}while(0);p=c[p+8>>2]|0}while((p|0)!=0);if(r){o=Tf(a,61)|0;oi(a,b,o,12);zf(a,o);o=r;break}}r=Ve(o,8)|0;o=Tf(a,61)|0;kh(a,o,(r|0)!=0?16464:16504);oi(a,b,o,12);Qd(b,o)}while(0);xe(a,o,0)}while(0);o=$f(a,0)|0;if(!o)break a}if((e|0)==6){zf(a,o);c[b+56>>2]=1;i=k;return}else if((e|0)==21){oi(a,b,o,7);_f(a);i=k;return}else if((e|0)==27){oi(a,b,o,7);i=k;return}else if((e|0)==46){i=k;return}}while(0);oi(a,b,0,6);i=k;return}function Yd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;e=i;q=a+68|0;v=c[q>>2]|0;s=b+28|0;if(c[(c[s>>2]|0)+16>>2]&1){i=e;return}if(!(Ve(b,8)|0))if(((b|0)!=0?(f=c[s>>2]|0,(f|0)!=0):0)?(c[f>>2]|0)==32:0)f=6;else f=8;else f=6;if((f|0)==6)if(!(Ve(b,131072)|0))xl(a,0)|0;else f=8;if((f|0)==8?(Ve(b,16)|0)!=0:0)tl(a,b);do if((b|0)!=0?(t=c[s>>2]|0,(t|0)!=0):0){s=c[t>>2]|0;if((s|0)==69){C=a+2712|0;c[C>>2]=c[C>>2]|4;break}else if((s|0)==36){C=a+2712|0;c[C>>2]=c[C>>2]|8;break}else break}while(0);s=(d|0)==2?2:1;w=$f(a,s)|0;a:do if(w){t=a+156|0;d=(s&2|0)==0;u=a+2724|0;v=v+24|0;b:while(1){y=w+28|0;z=c[y>>2]|0;x=b+28|0;A=(z|0)==(c[x>>2]|0);B=c[w+44>>2]|0;if(A&(B|0)==6){f=18;break}z=w+44|0;c:do if((((((!((B|0)!=5|A^1)?(ul(a,w)|0)!=0:0)?(c[w+60>>2]|0)==0:0)?(c[b+60>>2]|0)==0:0)?(g=c[y>>2]|0,(g|0)!=0):0)?(c[g+16>>2]&16|0)!=0:0)?(c[g>>2]|0)!=1:0){switch(c[g>>2]|0){case 98:case 83:case 103:case 102:case 96:case 13:case 36:{f=49;break c};default:{}}if(c[t>>2]|0){A=w+20|0;do if(((c[b+12>>2]|0)!=0?(c[A>>2]|0)==0:0)?(k=b+16|0,(Te(c[k>>2]|0)|0)!=0):0){if(wg(c[q>>2]|0,c[k>>2]|0)|0)break;mi(a,b,w,85);c[z>>2]=6;_f(a);break c}while(0);if((c[A>>2]|0)!=0?(c[b+20>>2]|0)!=0:0){f=54;break}mi(a,b,w,9);f=54}else f=49}else f=49;while(0);if((f|0)==49)if((((ul(a,w)|0)!=0?(c[z>>2]|0)==5:0)?(r=c[y>>2]|0,(r|0)!=0):0)?(c[r>>2]|0)==83:0){mi(a,b,w,40);f=54}else f=54;d:do if((f|0)==54){f=0;if(Te(w)|0){if((c[b+12>>2]|0)==0&d)te(a,b);if((c[w+36>>2]|0)>>>0<(c[w+40>>2]|0)>>>0){Qd(b,w);break}else{zf(a,w);break}}if(!(ue(b,w)|0)){A=c[y>>2]|0;if(A){B=c[A>>2]|0;if((B|0)==79)f=67;else if((B|0)==48){if(!(Ue(w)|0)){f=65;break b}oi(a,b,w,8);zf(a,w);break}if((f|0)==67){f=0;e:do if((c[z>>2]|0)==5){f:do if(d){do if(b){B=c[x>>2]|0;if(!B)break;if((c[B>>2]|0)==32)break f}while(0);if(!(se(b,32)|0))break e}while(0);c[y>>2]=Ke(17)|0;B=c[u>>2]|0;C=w+32|0;ob[c[(c[B>>2]|0)+8>>2]&15](B,c[C>>2]|0);c[C>>2]=pk(c[u>>2]|0,16456)|0;te(a,b);Qd(b,w);break d}while(0);if(((c[z>>2]|0)==5&(b|0)!=0?(n=c[x>>2]|0,(n|0)!=0):0)?(c[n>>2]|0)==4:0){lf(a,-293);Qd(b,w);qb[c[(c[y>>2]|0)+20>>2]&63](a,w,s);break}}if((A|0)!=0?(c[A>>2]|0)!=80:0){B=(c[z>>2]|0)==6;do if((c[A>>2]|0)==17){if(B)c[z>>2]=5}else if(B){A=c[A>>2]|0;if((A|0)==17){c[z>>2]=5;break}else if((A|0)!=79){do if(Ve(w,16)|0){C=c[y>>2]|0;if((C|0)!=0?(c[C>>2]|0)==1:0)break;if(Ve(w,2048)|0)break;if(!(Ve(b,16)|0))break;z=(b|0)!=0;A=c[x>>2]|0;do if(z){if(!A){A=0;f=97;break}if((c[A>>2]|0)!=1)f=97}else f=97;while(0);do if((f|0)==97){f=0;if((c[y>>2]|0)==(A|0))break;if(!(ul(a,w)|0))break;if(!(ul(a,b)|0))break;if(Al(a,b,w)|0){f=101;break b}}while(0);vl(a,b);if(!z){b=0;f=106;break b}z=c[x>>2]|0;if(!z){f=106;break b}if((c[z>>2]|0)!=1){f=106;break b}oi(a,b,w,8);zf(a,w);break d}while(0);if(!(c[v>>2]|0))break;if(Ve(w,128)|0){f=118;break b}A=c[y>>2]|0;if(!A)break;if((c[A>>2]|0)==104){f=118;break b}else break}else{if(se(b,79)|0)break;Md(a,w,17,0,0);te(a,b);Qd(b,w);Qd(b,Tf(a,17)|0);break d}}while(0);if((Ve(w,16384)|0)!=0?(Ve(b,16384)|0)!=0:0){f=121;break b}C=c[y>>2]|0;do if((C|0)!=0?(c[C>>2]|0)==1:0){if(c[w+60>>2]|0)break;do if(b){A=c[x>>2]|0;if(!A){f=132;break}if((c[A>>2]|0)!=1)f=132}else f=132;while(0);if((f|0)==132?(f=0,(se(b,1)|0)==0):0)break;if((c[z>>2]|0)==6){f=137;break b}if(c[w+20>>2]|0){f=137;break b}if(!(c[t>>2]|0)){f=137;break b}c[z>>2]=6;oi(a,b,w,24);_f(a);break d}while(0);B=c[x>>2]|0;A=c[B+16>>2]|0;if(A&16384){C=c[y>>2]|0;g:do if(C){do if((c[C>>2]|0)!=20){C=c[C>>2]|0;if((C|0)==30)break;else if((C|0)!=47)break g;if(!(Ue(w)|0)){oi(a,b,w,8);zf(a,w);break d}oi(a,b,w,11);if(!(c[b+12>>2]|0)){Rd(b,w);break d}Sd(b,w);if(d)te(a,b);b=Cf(a,b)|0;Sd(w,b);break d}while(0);if(!(Ue(w)|0)){oi(a,b,w,8);zf(a,w);break d}oi(a,b,w,11);if(c[b+12>>2]|0){Sd(b,w);if(d)te(a,b);b=Cf(a,b)|0;Qd(w,b);break d}c[w+12>>2]=b;c[w+16>>2]=b;c[w>>2]=c[b>>2];c[b>>2]=w;x=c[w>>2]|0;y=x+12|0;if((c[y>>2]|0)==(b|0))c[y>>2]=w;x=x+16|0;if((c[x>>2]|0)==(b|0))c[x>>2]=w;C=b+4|0;x=w+4|0;c[x>>2]=c[C>>2];c[C>>2]=0;x=c[x>>2]|0;if(x)c[x+8>>2]=w;C=b+8|0;x=w+8|0;c[x>>2]=c[C>>2];c[C>>2]=0;x=c[x>>2]|0;if(!x)break d;c[x+4>>2]=w;break d}while(0);if(!b)B=0;else f=165}else f=165;do if((f|0)==165){f=0;if(!B){B=1;break}if((c[B>>2]|0)!=32){B=1;break}B=c[y>>2]|0;if(!B){B=1;break}if((c[B>>2]|0)!=47){B=1;break}if(!(Ue(w)|0)){oi(a,b,w,8);zf(a,w);break d}oi(a,b,w,11);x=Tf(a,26)|0;if(!(c[b+12>>2]|0)){Rd(b,x);Qd(x,w);break d}Sd(b,x);Qd(x,w);if(d)te(a,b);b=Cf(a,b)|0;Sd(x,b);break d}while(0);h:do if((c[z>>2]|0)==6){z=b;while(1){z=c[z>>2]|0;if(!z)break h;if((c[y>>2]|0)==(c[z+28>>2]|0)){f=179;break b}}}while(0);C=(c[(c[y>>2]|0)+16>>2]&16|A&131072|0)==0;z=(Ue(w)|0)==0;if(C){if(z){oi(a,b,w,8);zf(a,w);break}if(!(c[(c[x>>2]|0)+16>>2]&32768))oi(a,b,w,7);y=c[y>>2]|0;z=c[y+16>>2]|0;if((z&12|0)!=4){f=193;break b}ve(a,b,w);break}if(z){oi(a,b,w,8);zf(a,w);break}if(c[w+60>>2]|0)oi(a,b,w,15);x=c[y>>2]|0;do if(x){if((c[x>>2]|0)!=17)break;te(a,b)}while(0);Qd(b,w);xe(a,w,s);break}}oi(a,b,w,8);zf(a,w)}}while(0);w=$f(a,s)|0;if(!w)break a}if((f|0)==18){if(c[z+16>>2]&16)vl(a,w);zf(a,w);if(d)te(a,b);if(((((((b|0)!=0?(j=c[x>>2]|0,(j|0)!=0):0)?(c[j>>2]|0)==36:0)?(m=b+12|0,h=c[m>>2]|0,(h|0)!=0):0)?(o=b+16|0,(h|0)==(c[o>>2]|0)):0)?(l=c[h+28>>2]|0,(l|0)!=0):0)?(c[l>>2]|0)==1:0){c[h>>2]=c[b>>2];B=b+8|0;c[h+8>>2]=c[B>>2];C=b+4|0;c[h+4>>2]=c[C>>2];c[B>>2]=0;c[C>>2]=0;c[b>>2]=h;C=h+12|0;c[m>>2]=c[C>>2];c[o>>2]=c[h+16>>2];c[C>>2]=b;jh(h);jh(b)}c[b+56>>2]=1;te(a,b);i=e;return}else if((f|0)==65){_f(a);if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==101){oi(a,b,w,10);_f(a);Bl(a,0,b)|0;if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==106){C=c[y>>2]|0;if(((C|0)!=0?(c[C>>2]|0)==1:0)?(C|0)!=(c[x>>2]|0):0){oi(a,b,w,7);_f(a)}else{oi(a,b,w,10);zf(a,w)}if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==118){_f(a);te(a,b);i=e;return}else if((f|0)==121){if((c[y>>2]|0)==(c[x>>2]|0)){oi(a,b,w,10);zf(a,w)}else{oi(a,b,w,7);_f(a)}if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==137){_f(a);oi(a,b,w,7);if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==179){if((A&32768|0)==0?(c[b+60>>2]|0)==0:0)oi(a,b,w,7);if(wl(a,b,w)|0)vl(a,b);_f(a);if(!d){i=e;return}te(a,b);i=e;return}else if((f|0)==193){do if((B?(p=c[x>>2]|0,(p|0)!=0):0)?(c[p>>2]|0)==1:0){if((y|0)!=0&(z&16384|0)==0){vl(a,b);break}if(!(c[b+12>>2]|0)){Od(a,b)|0;_f(a);i=e;return}}while(0);_f(a);if(!d){i=e;return}te(a,b);i=e;return}}while(0);if(c[(c[b+28>>2]|0)+16>>2]&32768){i=e;return}oi(a,b,0,6);i=e;return}function Zd(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;if(!(c[(c[a+68>>2]|0)+28>>2]|0)){i=e;return}d=$f(a,d)|0;if(!d){i=e;return}if((c[d+44>>2]|0)==6?(c[d+28>>2]|0)==(c[b+28>>2]|0):0){zf(a,d);i=e;return}_f(a);i=e;return}function _d(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;f=i;h=c[a+68>>2]|0;if(c[(c[b+28>>2]|0)+16>>2]&1){i=f;return}c[h+100>>2]=0;j=$f(a,0)|0;a:do if(j){g=a+2720|0;h=h+20|0;b:while(1){if((c[j+28>>2]|0)==(c[b+28>>2]|0)?(c[j+44>>2]|0)==6:0){e=6;break}c:do if(!(ue(b,j)|0)){if(Te(j)|0){_f(a);j=Tf(a,32)|0;oi(a,b,j,12)}k=j+28|0;n=c[k>>2]|0;if(!n){oi(a,b,j,8);zf(a,j);break}l=c[j+44>>2]|0;d:do if((l|0)==6){if((j|0)!=0?(c[n>>2]|0)==37:0){c[g>>2]=1;oi(a,b,j,8);zf(a,j);break c}else o=b;while(1){o=c[o>>2]|0;if(!o)break d;m=c[o+28>>2]|0;if((m|0)!=0?(c[m>>2]|0)==16:0)break;if((n|0)==(m|0)){e=21;break b}}oi(a,b,j,8);zf(a,j);break c}while(0);do if(!j)e=30;else{m=c[n>>2]|0;if((m|0)==26|(m|0)==32)break;else if((m|0)!=20){e=30;break}if(!(c[b+12>>2]|0))Rd(b,j);else Sd(b,j);o=c[j>>2]|0;c[h>>2]=0;xe(a,j,d);c[h>>2]=1;if((c[o+16>>2]|0)!=(j|0))break c;b=Tf(a,31)|0;Sd(j,b);break c}while(0);if((e|0)==30){e=0;_f(a);k=c[(c[k>>2]|0)+16>>2]|0;if(!(k&24)){e=31;break b}if((k&16|0)==0?(c[h>>2]|0)!=0:0){e=39;break b}j=Tf(a,26)|0;oi(a,b,j,12);l=c[j+44>>2]|0}if((l|0)==6){oi(a,b,j,8);zf(a,j);break}else{Qd(b,j);xe(a,j,0);break}}while(0);j=$f(a,0)|0;if(!j)break a}if((e|0)==6){zf(a,j);c[b+56>>2]=1;i=f;return}else if((e|0)==21){oi(a,b,j,7);_f(a);i=f;return}else if((e|0)==31){oi(a,b,j,11);i=f;return}else if((e|0)==39){i=f;return}}while(0);oi(a,b,0,6);i=f;return}function $d(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=i;l=c[a+68>>2]|0;g=b+28|0;if(c[(c[g>>2]|0)+16>>2]&1){i=d;return}m=$f(a,0)|0;if(!m){i=d;return}h=a+2720|0;f=l+24|0;k=l+20|0;j=l+112|0;l=l+116|0;a:while(1){o=m+28|0;n=m+44|0;q=(c[n>>2]|0)==6;if((c[o>>2]|0)==(c[g>>2]|0)){p=5;break}do if(q){if(!(Ve(m,130)|0)){p=c[o>>2]|0;if(p)if((c[p>>2]|0)==104)p=12;else p=16;else p=18}else p=12;if((p|0)==12){p=c[o>>2]|0;if(!p)p=0;else p=c[p>>2]|0;if(!(se(b,p)|0))p=16;else{p=15;break a}}if((p|0)==16){p=0;q=c[o>>2]|0;if(!((q|0)!=0?(c[q>>2]|0)==37:0))p=18}if((p|0)==18?(p=0,(Ve(m,24)|0)==0):0){q=c[o>>2]|0;if(!q){p=27;break}q=c[q>>2]|0;if(!((q|0)==109|(q|0)==106)){p=27;break}oi(a,b,m,8);zf(a,m);break}q=c[o>>2]|0;if((q|0)!=0?(c[q>>2]|0)==37:0)c[h>>2]=1;oi(a,b,m,8);zf(a,m)}else p=27;while(0);b:do if((p|0)==27?(p=0,(ue(b,m)|0)==0):0){q=c[o>>2]|0;if(!q){if((c[n>>2]|0)!=4){oi(a,b,m,8);zf(a,m);break}}else if((c[q>>2]|0)==104){oi(a,b,m,8);zf(a,m);break}if(Ve(m,256)|0){p=34;break a}if((c[n>>2]|0)==6){oi(a,b,m,8);zf(a,m);break}q=c[o>>2]|0;if((q|0)!=0?(c[q>>2]|0)==37:0){_f(a);m=Tf(a,106)|0;oi(a,b,m,12)}else p=40;do if((p|0)==40){if((Te(m)|0)==0?(Ve(m,24)|0)==0:0){if(!(c[(c[o>>2]|0)+16>>2]&4))break;oi(a,b,m,11);ve(a,b,m);break b}ze(b,m);oi(a,b,m,11);c[f>>2]=1;o=c[k>>2]|0;c[k>>2]=0;if((c[n>>2]|0)!=4)xe(a,m,0);c[f>>2]=0;c[k>>2]=o;break b}while(0);if(((m|0)!=0?(e=c[m+28>>2]|0,(e|0)!=0):0)?(q=c[e>>2]|0,(q|0)==109|(q|0)==106):0){Qd(b,m);q=c[k>>2]|0;c[k>>2]=0;xe(a,m,0);c[k>>2]=q;if((c[j>>2]|0)>>>0<=(c[l>>2]|0)>>>0)break;while(1){vl(a,0);if((c[j>>2]|0)>>>0<=(c[l>>2]|0)>>>0)break b}}oi(a,b,m,11);zf(a,m)}while(0);m=$f(a,0)|0;if(!m){p=53;break}}if((p|0)==5)if(q){zf(a,m);c[b+56>>2]=1;ye(a,b);i=d;return}else{_f(a);ye(a,b);i=d;return}else if((p|0)==15){_f(a);i=d;return}else if((p|0)==34){_f(a);i=d;return}else if((p|0)==53){i=d;return}}function ae(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=i;l=c[a+68>>2]|0;d=b+28|0;if(c[(c[d>>2]|0)+16>>2]&1){i=k;return}m=$f(a,0)|0;if(!m){i=k;return}j=a+2720|0;l=l+24|0;a:while(1){n=m+28|0;o=c[n>>2]|0;if((o|0)==(c[d>>2]|0)){g=5;break}if(((o|0)!=0?(c[o>>2]|0)==104:0)?(c[m+44>>2]|0)==6:0){g=11;break}b:do if(!(ue(b,m)|0)){p=c[n>>2]|0;o=c[m+44>>2]|0;if(!p)if((o|0)==4)g=20;else{oi(a,b,m,8);zf(a,m);break}else if((o|0)!=6){p=c[p>>2]|0;if((p|0)==109|(p|0)==106){_f(a);m=Tf(a,112)|0;oi(a,b,m,12)}else g=20}do if((g|0)==20){g=0;o=m+44|0;if((Te(m)|0)==0?(Ve(m,24)|0)==0:0){if(!(c[(c[n>>2]|0)+16>>2]&4))break;oi(a,b,m,11);ve(a,b,m);break b}ze(b,m);oi(a,b,m,11);c[l>>2]=1;if((c[o>>2]|0)!=4)xe(a,m,0);c[l>>2]=0;break b}while(0);o=m+44|0;n=c[o>>2]|0;do if((n|0)==6){p=(m|0)!=0;if(!((p?(h=c[m+28>>2]|0,(h|0)!=0):0)?(c[h>>2]|0)==37:0))g=32;if((g|0)==32?(g=0,(Ve(m,24)|0)==0):0){n=m+28|0;if((p?(f=c[n>>2]|0,(f|0)!=0):0)?(p=c[f>>2]|0,(p|0)==109|(p|0)==106|(p|0)==112):0){oi(a,b,m,8);zf(a,m);break b}else p=b;while(1){p=c[p>>2]|0;if(!p)break;if((c[n>>2]|0)==(c[p+28>>2]|0)){g=44;break a}}o=c[o>>2]|0;break}if((p?(e=c[m+28>>2]|0,(e|0)!=0):0)?(c[e>>2]|0)==37:0)c[j>>2]=1;oi(a,b,m,8);zf(a,m);break b}else{o=n;n=m+28|0}while(0);n=c[n>>2]|0;o=(o|0)==6;if(!(c[n+16>>2]&256)){if(!o){if(!(!((m|0)==0|(n|0)==0)?(c[n>>2]|0)==112:0)){m=Tf(a,112)|0;oi(a,b,m,12);_f(a)}Qd(b,m);xe(a,m,0);break}}else if(!o){g=48;break a}oi(a,b,m,8);zf(a,m)}while(0);m=$f(a,0)|0;if(!m){g=55;break}}if((g|0)==5)if((c[m+44>>2]|0)==6){c[b+56>>2]=1;zf(a,m);i=k;return}else{_f(a);i=k;return}else if((g|0)==11){_f(a);i=k;return}else if((g|0)==44){_f(a);i=k;return}else if((g|0)==48){_f(a);i=k;return}else if((g|0)==55){i=k;return}}function be(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;f=i;d=b+28|0;if(c[(c[d>>2]|0)+16>>2]&1){i=f;return}h=$f(a,0)|0;if(!h){i=f;return}g=a+2720|0;a:while(1){j=h+28|0;k=c[j>>2]|0;m=c[h+44>>2]|0;b:do if((k|0)!=(c[d>>2]|0)){l=h+44|0;if((m|0)==6){if((k|0)!=0?(c[k>>2]|0)==37:0){c[g>>2]=1;oi(a,b,h,8);zf(a,h);break}else e=b;while(1){e=c[e>>2]|0;if(!e){e=16;break b}if((k|0)==(c[e+28>>2]|0)){e=15;break a}}}else e=16}else{if((m|0)==6){e=7;break a}l=h+44|0;e=16}while(0);do if((e|0)==16){e=0;if(Te(h)|0){e=17;break a}if(!(ue(b,h)|0)){j=c[j>>2]|0;if(!j){oi(a,b,h,8);zf(a,h);break}if((c[j>>2]|0)!=23){e=22;break a}if((c[l>>2]|0)==6){oi(a,b,h,8);zf(a,h);break}else{Qd(b,h);xe(a,h,0);break}}}while(0);h=$f(a,0)|0;if(!h){e=26;break}}if((e|0)==7){zf(a,h);c[b+56>>2]=1;i=f;return}else if((e|0)==15){_f(a);i=f;return}else if((e|0)==17){_f(a);i=f;return}else if((e|0)==22){_f(a);i=f;return}else if((e|0)==26){i=f;return}}function ce(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=i;l=c[a+68>>2]|0;yl(a);j=l+116|0;g=c[j>>2]|0;c[j>>2]=c[l+112>>2];n=$f(a,0)|0;a:do if(n){d=b+28|0;h=a+2720|0;l=l+24|0;b:while(1){m=n+28|0;if((c[m>>2]|0)==(c[d>>2]|0)?(c[n+44>>2]|0)==6:0){e=5;break}c:do if(!(ue(b,n)|0)){p=c[m>>2]|0;o=c[n+44>>2]|0;if(!p)if((o|0)==4)e=14;else{oi(a,b,n,8);zf(a,n);break}else if((o|0)!=6){p=c[p>>2]|0;if((p|0)==104|(p|0)==109|(p|0)==106){_f(a);n=Tf(a,112)|0;oi(a,b,n,12)}else e=14}do if((e|0)==14){e=0;o=n+44|0;if((Te(n)|0)==0?(Ve(n,24)|0)==0:0){if(!(c[(c[m>>2]|0)+16>>2]&4))break;ve(a,b,n);break c}Rd(b,n);oi(a,b,n,11);c[l>>2]=1;if((c[o>>2]|0)!=4)xe(a,n,0);c[l>>2]=0;break c}while(0);d:do if((c[n+44>>2]|0)==6){if(((n|0)!=0?(f=c[n+28>>2]|0,(f|0)!=0):0)?(c[f>>2]|0)==37:0){c[h>>2]=1;oi(a,b,n,8);zf(a,n);break c}if((Ve(n,640)|0)==0?(Ve(n,24)|0)==0:0){o=n+28|0;m=b;while(1){m=c[m>>2]|0;if(!m)break d;if((c[o>>2]|0)==(c[m+28>>2]|0)){e=33;break b}}}oi(a,b,n,8);zf(a,n);break c}else o=n+28|0;while(0);if(!(c[(c[o>>2]|0)+16>>2]&128)){e=35;break b}if(!(Ue(n)|0)){oi(a,b,n,8);zf(a,n);break}else{Qd(b,n);xe(a,n,0);break}}while(0);n=$f(a,0)|0;if(!n)break a}if((e|0)==5){zf(a,n);c[j>>2]=g;c[b+56>>2]=1;i=k;return}else if((e|0)==33){oi(a,b,n,7);_f(a);c[j>>2]=g;i=k;return}else if((e|0)==35){_f(a);oi(a,b,n,11);c[j>>2]=g;i=k;return}}while(0);oi(a,b,0,6);c[j>>2]=g;i=k;return}function de(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;d=i;if(c[(c[b+28>>2]|0)+16>>2]&1){i=d;return}xl(a,0)|0;h=$f(a,2)|0;a:do if(h){g=a+68|0;b:while(1){j=h+44|0;do if((c[j>>2]|0)==6){m=c[h+28>>2]|0;l=(m|0)==(c[b+28>>2]|0);if(!l){if(!m)k=0;else k=c[m>>2]|0;if(!(se(b,k)|0)){e=17;break}}if(!m){e=13;break b}m=c[m>>2]|0;if(!((m|0)==48|(m|0)==16)){e=13;break b}oi(a,b,h,8);zf(a,h)}else e=17;while(0);c:do if((e|0)==17){e=0;if(Te(h)|0){Qd(b,h);break}if(!(ue(b,h)|0)){k=h+28|0;l=c[k>>2]|0;if(!l){oi(a,b,h,8);zf(a,h);break}if((c[l>>2]|0)!=79){do if(!(Te(h)|0)){m=c[k>>2]|0;if(((m|0)!=0?(c[m>>2]|0)!=80:0)?(Ve(h,1048592)|0)!=0:0)break;if((c[j>>2]|0)!=6){if(Ve(h,640)|0){e=37;break b}m=c[k>>2]|0;if((m|0)!=0?(c[m>>2]|0)==104:0){e=37;break b}Sd(b,h);oi(a,b,h,7);xe(a,h,0);m=Tf(a,82)|0;oi(a,b,m,15);Sd(h,m);b=m;break c}if(c[(c[g>>2]|0)+24>>2]|0){if(Ve(h,128)|0){e=32;break b}m=c[k>>2]|0;if((m|0)!=0?(c[m>>2]|0)==104:0){e=32;break b}}oi(a,b,h,8);zf(a,h);break c}while(0);l=c[k>>2]|0;if(l){f=l;e=42}}else{f=l;e=42}if((e|0)==42?(e=0,(c[f>>2]|0)==79):0)if((c[j>>2]|0)==5){oi(a,b,h,14);te(a,b);Md(a,h,17,0,0);Df(a,h);Qd(b,h);break}else{oi(a,b,h,8);zf(a,h);break}if(!(Ue(h)|0)){oi(a,b,h,8);zf(a,h);break}m=c[k>>2]|0;if((m|0)!=0?(c[m>>2]|0)==17:0)te(a,b);Qd(b,h);xe(a,h,2)}}while(0);h=$f(a,2)|0;if(!h)break a}if((e|0)==13){if(l)zf(a,h);else{oi(a,b,h,7);_f(a)}c[b+56>>2]=1;te(a,b);i=d;return}else if((e|0)==32){_f(a);te(a,b);i=d;return}else if((e|0)==37){if(!(c[(c[g>>2]|0)+24>>2]|0))oi(a,b,h,7);_f(a);i=d;return}}while(0);oi(a,b,0,6);i=d;return}function ee(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0;d=i;c[(c[a+68>>2]|0)+100>>2]=0;h=$f(a,0)|0;if(!h){i=d;return}g=b+28|0;while(1){j=h+28|0;if((c[j>>2]|0)==(c[g>>2]|0)?(c[h+44>>2]|0)==6:0)break;a:do if(!(ue(b,h)|0)){do if((c[h+44>>2]|0)==5?(f=c[j>>2]|0,(f|0)!=0):0){if((c[f>>2]|0)!=78){if((c[f>>2]|0)!=77)break;oi(a,b,h,19)}Qd(b,h);xe(a,h,1);break a}while(0);oi(a,b,h,8);zf(a,h)}while(0);h=$f(a,0)|0;if(!h){e=15;break}}if((e|0)==15){i=d;return}zf(a,h);c[b+56>>2]=1;te(a,b);i=d;return}function fe(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;d=i;c[(c[a+68>>2]|0)+100>>2]=0;g=$f(a,0)|0;a:do if(g){f=b+28|0;while(1){h=g+28|0;if((c[h>>2]|0)==(c[f>>2]|0)?(c[g+44>>2]|0)==6:0)break;b:do if(!(ue(b,g)|0)){do if((c[g+44>>2]|0)==5?(e=c[h>>2]|0,(e|0)!=0):0){if((c[e>>2]|0)!=78?(h=c[e>>2]|0,!((h|0)==92|(h|0)==77)):0)break;Qd(b,g);xe(a,g,0);break b}while(0);oi(a,b,g,8);zf(a,g)}while(0);g=$f(a,0)|0;if(!g)break a}zf(a,g);c[b+56>>2]=1;te(a,b);i=d;return}while(0);oi(a,b,0,6);i=d;return}function ge(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;d=i;c[(c[a+68>>2]|0)+100>>2]=0;if(((b|0)!=0?(f=c[b+28>>2]|0,(f|0)!=0):0)?(c[f>>2]|0)==107:0)h=2;else h=1;k=$f(a,h)|0;j=b+28|0;a:do if(k){g=b+12|0;f=(h&2|0)==0;b:while(1){l=k+28|0;if((c[l>>2]|0)==(c[j>>2]|0)?(c[k+44>>2]|0)==6:0){e=9;break}do if(!(ue(b,k)|0)){if(!(Te(k)|0)){l=c[l>>2]|0;if(!l)break b;if((c[l+16>>2]&1040|0)!=16)break b;oi(a,b,k,8);zf(a,k);break}if((c[g>>2]|0)==0&f)te(a,b);if((c[k+36>>2]|0)>>>0<(c[k+40>>2]|0)>>>0){Qd(b,k);break}else{zf(a,k);break}}while(0);k=$f(a,h)|0;if(!k)break a}if((e|0)==9){zf(a,k);c[b+56>>2]=1;te(a,b);i=d;return}if(!(c[(c[j>>2]|0)+16>>2]&32768))oi(a,b,k,7);_f(a);te(a,b);i=d;return}while(0);if(c[(c[j>>2]|0)+16>>2]&32768){i=d;return}oi(a,b,0,6);i=d;return}function he(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;h=i;j=$f(a,1)|0;a:do if(j){g=b+28|0;d=a+156|0;f=b+12|0;b:while(1){k=j+28|0;l=(c[k>>2]|0)==(c[g>>2]|0);c:do if(l){m=j+44|0;do if((c[m>>2]|0)==5)if(!(c[d>>2]|0))if(l)break;else{e=11;break c}else{oi(a,b,j,24);c[m>>2]=6;_f(a);break c}while(0);if((c[j+44>>2]|0)==6){e=10;break b}else e=11}else e=11;while(0);do if((e|0)==11){e=0;if(!(Te(j)|0)){if(ue(b,j)|0)break;if(c[k>>2]|0){e=20;break b}oi(a,b,j,8);zf(a,j);break}if(!(c[f>>2]|0))Ae(a,b,j);if((c[j+36>>2]|0)>>>0<(c[j+40>>2]|0)>>>0){Qd(b,j);break}else{zf(a,j);break}}while(0);j=$f(a,1)|0;if(!j)break a}if((e|0)==10){zf(a,j);c[b+56>>2]=1;te(a,b);i=h;return}else if((e|0)==20){oi(a,b,j,7);_f(a);te(a,b);i=h;return}}while(0);oi(a,b,0,6);i=h;return}function ie(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;d=i;f=a+68|0;c[(c[f>>2]|0)+72>>2]=b;e=$f(a,4)|0;c[(c[f>>2]|0)+72>>2]=0;if(!e){oi(a,b,0,6);i=d;return}Qd(b,e);e=$f(a,0)|0;if(!e){oi(a,b,0,6);i=d;return}if((c[e+44>>2]|0)==6){f=c[e+28>>2]|0;if((f|0)!=0?(c[f>>2]|0)==(c[c[b+28>>2]>>2]|0):0){zf(a,e);i=d;return}oi(a,b,e,6)}else oi(a,b,e,6);_f(a);i=d;return}function je(a){a=a|0;var b=0,d=0,e=0;b=i;a=c[a+20>>2]|0;if(!a){e=1;i=b;return e|0}while(1){e=c[a+4>>2]|0;if((((e|0)!=0?(e=c[e>>2]|0,(e|0)==143|(e|0)==67):0)?(d=c[a+24>>2]|0,(d|0)!=0):0)?(Ak(d,16528)|0)!=0:0){a=1;d=7;break}a=c[a>>2]|0;if(!a){a=0;d=7;break}}if((d|0)==7){i=b;return a|0}return 0}function ke(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0;f=i;d=c[a+68>>2]|0;l=$f(a,0)|0;if(!l){i=f;return}g=b+28|0;h=(b|0)!=0?46:38;j=0;k=0;a:while(1){b:while(1){m=l+28|0;n=c[m>>2]|0;if((n|0)==(c[g>>2]|0))if((c[l+44>>2]|0)==6){n=6;break a}else n=9;else if((n|0)!=0?(c[n>>2]|0)==48:0)n=9;else n=12;if((n|0)==9){n=0;if((c[l+44>>2]|0)==5){oi(a,b,l,8);zf(a,l)}else n=12}do if((n|0)==12){if(Te(l)|0){n=13;break a}n=l+44|0;if(((c[n>>2]|0)==3?(e=c[l+32>>2]|0,(e|0)!=0):0)?(vk(e,16544)|0)==0:0){oi(a,b,l,11);Rd(Nf(a)|0,l);break}if(!(ue(b,l)|0)){if((c[n>>2]|0)==1){Be(a,b,l);break}n=c[m>>2]|0;if(!n){oi(a,b,l,8);zf(a,l);break}if(!(c[n+16>>2]&4)){n=24;break a}if(Ue(l)|0)break b;oi(a,b,l,8);zf(a,l)}}while(0);l=$f(a,0)|0;if(!l){n=36;break a}}m=c[m>>2]|0;do if(m){m=c[m>>2]|0;if((m|0)==9){m=j+1|0;if((j|0)<=0){j=m;break}oi(a,b,l,h);j=m;break}else if((m|0)==111){m=k+1|0;if((k|0)<=0){k=m;break}oi(a,b,l,h);k=m;break}else break}while(0);Qd(b,l);xe(a,l,0);l=$f(a,0)|0;if(!l){n=36;break}}if((n|0)==6){zf(a,l);c[b+56>>2]=1;i=f;return}else if((n|0)==13){oi(a,b,l,11);_f(a);i=f;return}else if((n|0)==24){if(c[d+28>>2]|0)oi(a,b,l,11);_f(a);i=f;return}else if((n|0)==36){i=f;return}}function le(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;n=i;q=c[b+68>>2]|0;uh(b,c[d>>2]|0);t=$f(b,0)|0;if(!t){i=n;return}e=d+28|0;j=q+80|0;l=q+76|0;k=d+56|0;m=q+20|0;p=d+60|0;o=d+20|0;q=q+84|0;s=0;r=1;a:while(1){u=t+28|0;v=c[u>>2]|0;w=c[e>>2]|0;if((v|0)==(w|0)?(c[t+44>>2]|0)==5:0){oi(b,d,t,8);zf(b,t)}else f=7;b:do if((f|0)==7){f=0;if((v|0)!=0?(c[v>>2]|0)==48:0){if((Ue(t)|0)==0?(c[j>>2]|0)==0:0)c[j>>2]=1;else oi(b,d,t,8);zf(b,t);break}if((c[l>>2]|0)!=0?((c[t+44>>2]|0)+ -5|0)>>>0<3:0){oi(b,d,t,27);v=c[u>>2]|0;w=c[e>>2]|0}if((v|0)==(w|0)?(c[t+44>>2]|0)==6:0){c[k>>2]=1;te(b,d);zf(b,t);c[l>>2]=1;s=c[d>>2]|0;if(!s){s=0;break}s=c[s+28>>2]|0;if(!s){s=0;break}if((c[s>>2]|0)==71){f=101;break a}else{s=0;break}}do if(v){v=c[v>>2]|0;if((v|0)==71){w=c[t+44>>2]|0;if((w|0)==5){Qd(d,t);Wd(b,t,0);break b}else if((w|0)!=6)break;w=c[d>>2]|0;if(!w)break;x=c[w+28>>2]|0;if((x|0)!=0?(c[x>>2]|0)==71:0){f=29;break a}if((v&-2|0)!=38)break}else if(!((v|0)==39|(v|0)==38))break;v=c[d>>2]|0;if(((v|0)!=0?(h=c[v+28>>2]|0,(h|0)!=0):0)?(c[h>>2]|0)==71:0){f=34;break a}}while(0);if((Te(t)|0)!=0?(g=c[t+36>>2]|0,(c[t+40>>2]|0)>>>0<=(g+1|0)>>>0):0)v=(a[(c[q>>2]|0)+g>>0]|0)==32&1;else v=0;if(!(ue(d,t)|0)){if(Te(t)|0){if((v|0)!=0&(s|0)==0){zf(b,t);s=0;break}lf(b,-294);if((r|0)!=0?(xl(b,t)|0)>0:0){r=0;break}Qd(d,t);s=1;r=0;break}v=t+44|0;if((c[v>>2]|0)==1){Be(b,d,t);break}w=c[u>>2]|0;if((w|0)!=0?(c[w>>2]|0)!=80:0){c[m>>2]=0;if((c[w>>2]|0)!=53){if((Ve(t,8)|0)==0?(Ve(t,16)|0)==0:0){w=c[u>>2]|0;f=54}}else f=54;c:do if((f|0)==54){f=0;x=c[w+16>>2]|0;if(!(x&4)){oi(b,d,t,11);w=c[u>>2]|0;u=c[w+16>>2]|0}else u=x;if(u&2){do if(w){if((c[w>>2]|0)!=16)break;if(!(c[p>>2]|0))break;if(c[o>>2]|0)break;x=t+20|0;c[o>>2]=c[x>>2];c[x>>2]=0}while(0);zf(b,t);break b}if(u&4){ve(b,d,t);break b}if(u&32){_f(b);t=Tf(b,115)|0;we(b,t);c[m>>2]=1;break}if(u&64){_f(b);t=Tf(b,31)|0;c[m>>2]=1;break}if(u&896){if((c[v>>2]|0)!=6){_f(b);t=Tf(b,104)|0}c[m>>2]=1;break}do if(w){if((c[w>>2]|0)!=53)break;_f(b);t=Tf(b,37)|0;c[m>>2]=1;break c}while(0);if(!(Ve(t,1536)|0)){f=77;break a}zf(b,t);break b}while(0);u=t+44|0;d:do if((c[u>>2]|0)==6){do if(t){v=c[t+28>>2]|0;if(!v)break;v=c[v>>2]|0;if((v|0)==17){c[u>>2]=5;break d}else if((v|0)==79){c[u>>2]=7;c[t+60>>2]=1;break d}else break}while(0);if(Ve(t,16)|0)vl(b,t)}while(0);if(!(Ue(t)|0)){oi(b,d,t,8);zf(b,t);break}do if(Ve(t,16)|0){do if(!t)f=93;else{u=c[t+28>>2]|0;if(!u){f=93;break}if((c[u>>2]|0)!=52){f=93;break}lf(b,-293)}while(0);if((f|0)==93){f=0;lf(b,-294)}if(!r){s=1;r=0;break}if(c[t+60>>2]|0){s=1;break}if((xl(b,t)|0)>0){r=0;break b}else{s=1;r=0}}else{s=0;r=1}while(0);if(c[t+60>>2]|0)oi(b,d,t,15);Qd(d,t);xe(b,t,s);break}oi(b,d,t,8);zf(b,t)}}while(0);t=$f(b,s)|0;if(!t){f=101;break}}if((f|0)==29){te(b,d);_f(b);i=n;return}else if((f|0)==34){te(b,d);_f(b);i=n;return}else if((f|0)==77){_f(b);i=n;return}else if((f|0)==101){i=n;return}}function me(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0;f=i;g=c[a+68>>2]|0;if(!(c[a+408>>2]|0)){l=a+2708|0;c[l>>2]=c[l>>2]|32}j=$f(a,0)|0;a:do if(j){d=b+28|0;g=g+76|0;h=a+172|0;b:while(1){k=j+28|0;l=c[k>>2]|0;if((l|0)==(c[d>>2]|0)?(c[j+44>>2]|0)==6:0){e=7;break}do if(!l)e=18;else{if((c[l>>2]|0)==38)break b;l=c[l>>2]|0;if((l|0)==39)break b;else if((l|0)!=48){e=18;break}if(Ue(j)|0)oi(a,b,j,8);zf(a,j)}while(0);c:do if((e|0)==18?(e=0,(ue(b,j)|0)==0):0){l=c[k>>2]|0;if(((l|0)!=0?(c[l>>2]|0)==16:0)?(c[j+44>>2]|0)==5:0){l=c[g>>2]|0;Qd(b,j);xe(a,j,0);if(!l)break;if((Rf(a)|0)==(j|0))break;Md(a,j,30,0,0);k=Rf(a)|0;if(!k)break;Nd(j)|0;Qd(k,j);break}do if(!(Te(j)|0)){if((c[k>>2]|0)!=0?(c[j+44>>2]|0)!=6:0)break;oi(a,b,j,8);zf(a,j);break c}while(0);k=Rf(a)|0;if(!k){if(c[g>>2]|0){oi(a,b,j,8);zf(a,j);break}_f(a);j=Tf(a,16)|0;if(c[h>>2]|0)oi(a,b,j,15);Qd(b,j)}else{if(Te(j)|0){_f(a);j=Tf(a,79)|0;oi(a,b,j,27)}Qd(k,j)}xe(a,j,0)}while(0);j=$f(a,0)|0;if(!j)break a}if((e|0)==7){zf(a,j);c[b+56>>2]=1;te(a,b);i=f;return}te(a,b);if((c[j+44>>2]|0)==6){oi(a,b,j,8);zf(a,j);i=f;return}else{oi(a,b,j,7);_f(a);i=f;return}}while(0);oi(a,b,0,6);i=f;return}function ne(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0;g=i;h=c[a+68>>2]|0;if(!(c[a+408>>2]|0)){m=a+2708|0;c[m>>2]=c[m>>2]|16}k=$f(a,0)|0;a:do if(k){d=b+28|0;j=h+20|0;h=a+2708|0;while(1){l=k+28|0;if((c[l>>2]|0)==(c[d>>2]|0)?(c[k+44>>2]|0)==6:0)break;do if(!(ue(b,k)|0)){if(!(c[l>>2]|0)){oi(a,b,k,8);zf(a,k);break}if(Ue(k)|0){m=c[l>>2]|0;if(m)if(!(c[m+16>>2]&4))f=16;else{ve(a,b,k);break}}else f=16;if((f|0)==16){f=0;m=c[l>>2]|0;if((m|0)!=0?(c[m>>2]|0)==16:0){_f(a);k=Tf(a,71)|0;oi(a,b,k,15)}}l=c[k+44>>2]|0;if((l|0)==7){if(c[(c[k+28>>2]|0)+16>>2]&8192){Qd(b,k);break}}else if((l|0)==5?(c[(c[k+28>>2]|0)+16>>2]&8192|0)!=0:0){Qd(b,k);c[j>>2]=0;xe(a,k,1);break}if(((k|0)!=0?(e=c[k+28>>2]|0,(e|0)!=0):0)?(c[e>>2]|0)==1:0)c[h>>2]=c[h>>2]|64;oi(a,b,k,8);zf(a,k)}while(0);k=$f(a,0)|0;if(!k)break a}zf(a,k);c[b+56>>2]=1;te(a,b);i=g;return}while(0);oi(a,b,0,6);i=g;return}function oe(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0;e=i;Li(a,24,0)|0;k=$f(a,0)|0;a:do if(!k)g=3;else{h=b+28|0;while(1){j=c[k+28>>2]|0;if((j|0)!=0?(c[j>>2]|0)==46:0)break a;do if((j|0)==(c[h>>2]|0)){if((c[k+44>>2]|0)==6){oi(a,b,k,8);zf(a,k);break}if((c[k+44>>2]|0)==5){oi(a,b,k,8);zf(a,k)}else g=12}else g=12;while(0);if((g|0)==12?(g=0,(ue(b,k)|0)==0):0)break;k=$f(a,0)|0;if(!k){g=3;break a}}_f(a);k=Tf(a,46)|0}while(0);if((g|0)==3)k=Tf(a,46)|0;Qd(b,k);ke(a,k,0);l=$f(a,0)|0;do if(l){g=b+28|0;h=a+408|0;j=0;k=0;b:while(1){n=l+28|0;c:do if((c[n>>2]|0)!=(c[g>>2]|0)){if(!(ue(b,l)|0)){m=(l|0)!=0;do if(m?(f=c[n>>2]|0,(f|0)!=0):0){o=c[f>>2]|0;if((o|0)==39){if((c[l+44>>2]|0)!=5){oi(a,b,l,8);zf(a,l);break c}if(!j)j=l;else pi(a,b,l,18);Qd(b,l);xe(a,l,d);l=c[j+12>>2]|0;if(!l)break c;while(1){m=c[l+28>>2]|0;if(m)k=(c[m>>2]|0)==71?l:k;l=c[l+8>>2]|0;if(!l)break c}}else if((o|0)==71){if((c[l+44>>2]|0)!=5){oi(a,b,l,8);zf(a,l);break c}if(!j){g=47;break b}if(!k){Qd(j,l);k=l}else zf(a,l);xe(a,k,d);break c}else if((o|0)==16){if((c[l+44>>2]|0)!=5){oi(a,b,l,8);zf(a,l);break c}if(!((c[h>>2]|0)==0&(j|0)!=0)){g=35;break b}_f(a);if(k){l=k+44|0;if((c[l>>2]|0)==7)c[l>>2]=5}else{k=Tf(a,71)|0;Qd(j,k);oi(a,b,k,15)}xe(a,k,d);break c}else break}while(0);if(Ue(l)|0){n=c[n>>2]|0;o=(n|0)==0;if(!o?(c[n+16>>2]&4|0)!=0:0){ve(a,b,l);break}if(!(o|(j|0)!=0&m^1)?(c[n>>2]|0)==38:0){oi(a,b,l,8);zf(a,l);break}}_f(a);if(!j){g=65;break b}if(k){oi(a,b,l,26);l=k+44|0;if((c[l>>2]|0)==7)c[l>>2]=5}else{k=Tf(a,71)|0;Qd(j,k)}lf(a,1168);xe(a,k,d)}}else{if((j|0)==0?(c[l+44>>2]|0)!=5:0)oi(a,b,l,8);zf(a,l)}while(0);l=$f(a,0)|0;if(!l){g=16;break}}if((g|0)==16){if(!j)break;i=e;return}else if((g|0)==35)lf(a,-1169);else if((g|0)==47){oi(a,b,l,8);zf(a,l);l=Tf(a,16)|0}else if((g|0)==65){l=Tf(a,16)|0;oi(a,b,l,15);lf(a,-1169)}Qd(b,l);xe(a,l,d);i=e;return}while(0);o=Tf(a,16)|0;Qd(b,o);le(a,o,0);i=e;return}function pe(a){a=a|0;var b=0,d=0,e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;b=i;o=$f(a,0)|0;a:do if(o){g=a+12|0;n=0;b:while(1){m=(n|0)==0;n=o;c:while(1){p=n+44|0;do if((c[p>>2]|0)==13){if((Of(a)|0)!=0?(c[g>>2]|0)!=0:0){oi(a,a,n,8);zf(a,n);break}if((c[n+48>>2]|0)==1?(c[n+52>>2]|0)==1:0){d=12;break}oi(a,a,n,45);d=12}else d=12;while(0);do if((d|0)==12?(d=0,(ue(a,n)|0)==0):0){o=c[p>>2]|0;if((o|0)==5){d=18;break b}else if((o|0)==6){oi(a,a,n,8);zf(a,n);break}else if((o|0)!=1)break b;if(m)break c;oi(a,a,n,8);zf(a,n)}while(0);n=$f(a,0)|0;if(!n)break a}Qd(a,n);o=$f(a,0)|0;if(!o)break a}if(((((((d|0)==18?(h=c[n+28>>2]|0,(h|0)!=0):0)?(c[h>>2]|0)==48:0)?(k=Jc(n,155)|0,(k|0)!=0):0)?(l=c[k+24>>2]|0,(l|0)!=0):0)?(wk(l,16560)|0)==0:0)?(o=c[a+180>>2]|0,c[(c[a+68>>2]|0)+28>>2]=1,o=(o|0)!=0,m=o&1^1,Li(a,26,m)|0,Li(a,25,m)|0,!o):0){Li(a,29,0)|0;Li(a,30,0)|0}if(!(((c[p>>2]|0)==5?(j=c[n+28>>2]|0,(j|0)!=0):0)?(c[j>>2]|0)==48:0)){_f(a);n=Tf(a,48)|0}if(!(Lf(a)|0))oi(a,0,0,44);Qd(a,n);oe(a,n,0)}while(0);if(c[a+408>>2]|0)Qk(a);if(!(Nf(a)|0)){p=Tf(a,48)|0;Qd(a,p);oe(a,p,0)}if(!(Qf(a)|0)){p=Pf(a)|0;oi(a,p,0,17);Qd(p,Tf(a,111)|0)}Ce(a,a);De(a,a);Ud(a,a)|0;Ee(a,a);if(((c[a+296>>2]|0)!=0?(f=Rf(a)|0,(f|0)!=0):0)?(e=c[f+12>>2]|0,(e|0)!=0):0){f=a+68|0;do{if((Te(e)|0)!=0?(Vd(c[f>>2]|0,e)|0)==0:0)d=46;else d=44;do if((d|0)==44){d=0;if((Ue(e)|0)!=0?(Fe(e)|0)!=0:0){d=46;break}e=c[e+8>>2]|0}while(0);if((d|0)==46){d=Tf(a,79)|0;Rd(e,d);d:do if(!e)e=0;else while(1){if((Ue(e)|0)!=0?(Fe(e)|0)==0:0)break d;p=e;e=c[e+8>>2]|0;Nd(p)|0;Qd(d,p);if(!e){e=0;break}}while(0);te(a,d)}}while((e|0)!=0)}if(!(c[a+300>>2]|0)){i=b;return}Ge(a,a);i=b;return}function qe(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;f=c[b+20>>2]|0;a:do if(f){while(1){g=c[f+4>>2]|0;if((g|0)!=0?(c[g>>2]|0)==154:0)break;f=c[f>>2]|0;if(!f)break a}b=c[f+24>>2]|0;if((b|0)!=0?(wk(b,16592)|0)==0:0){g=1;i=d;return g|0}g=0;i=d;return g|0}while(0);f=b+32|0;if(!(c[f>>2]|0)){g=0;i=d;return g|0}if(((b|0)!=0?(e=c[b+28>>2]|0,(e|0)!=0):0)?(g=c[e>>2]|0,(g|0)==101|(g|0)==92|(g|0)==82):0){g=1;i=d;return g|0}if((Le(a,b)|0)==32){g=1;i=d;return g|0}g=(wk(c[f>>2]|0,16608)|0)==0&1;i=d;return g|0}function re(a){a=a|0;var b=0,d=0,e=0,f=0;b=i;Li(a,24,1)|0;f=$f(a,0)|0;a:do if(f){e=0;do{d=(e|0)==0;e=f;b:while(1){f=e+44|0;do if((c[f>>2]|0)!=6){if(!(ue(a,e)|0)){f=c[f>>2]|0;if((f|0)==1){if(d)break b;oi(a,a,e,8);zf(a,e);break}else if((f|0)==5){Qd(a,e);He(a,e,0);break}else if((f|0)==7){Qd(a,e);break}else{oi(a,a,e,8);zf(a,e);break}}}else{oi(a,0,e,13);zf(a,e)}while(0);e=$f(a,0)|0;if(!e)break a}Qd(a,e);f=$f(a,0)|0}while((f|0)!=0)}while(0);if(!(c[a+184>>2]|0)){i=b;return}Zf(a)|0;i=b;return}function se(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;a=c[a>>2]|0;a:do if(!a)b=0;else while(1){e=c[a+28>>2]|0;if((e|0)!=0?(c[e>>2]|0)==(b|0):0){b=1;break a}a=c[a>>2]|0;if(!a){b=0;break}}while(0);i=d;return b|0}function te(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;f=c[d+12>>2]|0;if(((d|0)!=0?(g=c[d+28>>2]|0,(g|0)!=0):0)?(c[g>>2]|0)==82:0){i=e;return}if(Ie(d)|0){i=e;return}if(Te(f)|0)Ae(b,d,f);f=c[d+16>>2]|0;if(!(Te(f)|0)){i=e;return}b=c[b+68>>2]|0;if(!(Te(f)|0)){i=e;return}g=f+40|0;h=c[g>>2]|0;if(h>>>0<=(c[f+36>>2]|0)>>>0){i=e;return}f=h+ -1|0;if((a[(c[b+84>>2]|0)+f>>0]|0)!=32){i=e;return}c[g>>2]=f;if((c[(c[d+28>>2]|0)+16>>2]&1040|0)!=16){i=e;return}c[b+16>>2]=1;i=e;return}function ue(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;a:do switch(c[b+44>>2]|0){case 12:case 11:case 10:case 9:case 8:case 3:case 2:{Qd(a,b);a=1;break};case 13:{f=a;while(1){if(!f){e=8;break a}g=c[f>>2]|0;if(!g)break;else f=g}g=c[f+12>>2]|0;if((g|0)!=0?(c[g+44>>2]|0)==13:0){e=8;break a}Pd(f,b);a=1;break};default:e=8}while(0);do if((e|0)==8){e=b+28|0;if(((c[e>>2]|0)!=0?(Ue(b)|0)!=0:0)?(Xe(b)|0)!=0:0){e=c[e>>2]|0;if((b|0)!=0?(c[e>>2]|0)!=0:0){a=0;break}if(c[e+8>>2]&57344){Qd(a,b);a=1}else a=0}else a=0}while(0);i=d;return a|0}function ve(a,b,d){a=a|0;b=b|0;d=d|0;var e=0;e=i;Nd(d)|0;if(!(Ue(d)|0)){oi(a,b,d,8);zf(a,d);i=e;return}oi(a,b,d,11);b=Pf(a)|0;if(!b)va(16760,16640,779,16776);Qd(b,d);if(!(c[(c[d+28>>2]|0)+20>>2]|0)){i=e;return}xe(a,d,0);i=e;return}function we(a,b){a=a|0;b=b|0;var d=0;d=i;if(!(c[a+428>>2]|0)){i=d;return}if(!(c[a+200>>2]|0)){kh(a,b,16680);i=d;return}else{ih(a,b,16680);i=d;return}}function xe(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0,g=0,h=0;e=i;g=c[a+68>>2]|0;f=c[b+28>>2]|0;h=c[f+16>>2]|0;if(!(h&1)){if(!(h&16))c[g+16>>2]=0}else{c[g+8>>2]=0;if(!(c[f+20>>2]|0)){i=e;return}}f=c[f+20>>2]|0;if(!f){i=e;return}if((c[b+44>>2]|0)==7){i=e;return}qb[f&63](a,b,d);i=e;return}function ye(a,b){a=a|0;b=b|0;var d=0,e=0;d=i;if(c[b+12>>2]|0){i=d;return}e=Tf(a,106)|0;Qd(b,e);oi(a,b,e,12);i=d;return}function ze(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;a=c[a>>2]|0;a:do if(a){e=a;while(1){f=c[e+28>>2]|0;if((f|0)!=0?(c[f>>2]|0)==104:0)break;e=c[e>>2]|0;if(!e)break a}Rd(e,b);i=d;return}while(0);Rd(a,b);i=d;return}function Ae(b,d,e){b=b|0;d=d|0;e=e|0;var f=0,g=0,h=0,j=0,k=0;f=i;j=c[b+68>>2]|0;if(!(Te(e)|0)){i=f;return}b=e+36|0;k=c[b>>2]|0;h=j+84|0;if((a[(c[h>>2]|0)+k>>0]|0)!=32){i=f;return}if(k>>>0>=(c[e+40>>2]|0)>>>0){i=f;return}do if((c[(c[d+28>>2]|0)+16>>2]&1040|0)==16){e=c[d+4>>2]|0;if(!(Te(e)|0)){k=Bf(c[j+124>>2]|0,j)|0;e=d+36|0;j=c[e>>2]|0;c[e>>2]=j+1;c[k+36>>2]=j;c[k+40>>2]=c[e>>2];a[(c[h>>2]|0)+j>>0]=32;Rd(d,k);break}j=e+40|0;e=c[j>>2]|0;if(e){h=c[h>>2]|0;if((a[h+(e+ -1)>>0]|0)!=32)g=9}else{h=c[h>>2]|0;g=9}if((g|0)==9){c[j>>2]=e+1;a[h+e>>0]=32}k=d+36|0;c[k>>2]=(c[k>>2]|0)+1}while(0);c[b>>2]=(c[b>>2]|0)+1;i=f;return}function Be(a,b,d){a=a|0;b=b|0;d=d|0;var e=0,f=0;e=i;if(Lf(a)|0){oi(a,b,d,8);zf(a,d);i=e;return}oi(a,b,d,34);while(1){if(((b|0)!=0?(f=c[b+28>>2]|0,(f|0)!=0):0)?(c[f>>2]|0)==48:0)break;b=c[b>>2]|0}Rd(b,d);i=e;return}function Ce(a,b){a=a|0;b=b|0;var d=0,e=0,f=0;d=i;while(1){if(!b){a=11;break}e=b;b=c[b+8>>2]|0;do if(Ue(e)|0){f=c[(c[e+28>>2]|0)+24>>2]|0;if(!f){Se(a,e);break}else{ob[f&15](a,e);break}}while(0);f=c[e+12>>2]|0;if(f)Ce(a,f);if((b|0)==(e|0)){a=10;break}}if((a|0)==10)va(16624,16640,4093,16664);else if((a|0)==11){i=d;return}}function De(a,b){a=a|0;b=b|0;var d=0,e=0,f=0,g=0;d=i;if(!b){i=d;return}do{e=b;b=c[b+8>>2]|0;f=e+28|0;g=c[f>>2]|0;do if(g){g=c[g>>2]|0;if((g|0)==66|(g|0)==29)Md(a,e,115,1,1);f=c[f>>2]|0;if(f){g=c[f>>2]|0;if(!((g|0)==63|(g|0)==118)){if(!f)break;if((c[f>>2]|0)!=81)break}Md(a,e,82,1,1)}}while(0);e=c[e+12>>2]|0;if(e)De(a,e)}while((b|0)!=0);i=d;return}function Ee(b,d){b=b|0;d=d|0;var e=0,f=0,g=0,h=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=i;if(!d){i=j;return}h=b+68|0;do{m=d+8|0;k=d;d=c[m>>2]|0;a:do if((((Te(k)|0)!=0?(Te(k)|0)!=0:0)?(g=c[k>>2]|0,(c[g+44>>2]|0)!=1):0)?(Ie(k)|0)==0:0){p=c[g+28>>2]|0;if((p|0)!=0?(c[p+20>>2]|0)==36:0)break;n=k+4|0;o=c[n>>2]|0;if(!o){if(Ve(g,16)|0){o=c[n>>2]|0;if(!o)l=17;else l=14}}else{p=c[o+28>>2]|0;if(!((p|0)!=0?(c[p>>2]|0)==17:0))l=14}do if((l|0)==14){l=0;i