# Contributing

TrelloWarrior development is a open project and contributions are welcomed.

First, see if your issue haven’t been yet reported [here][1], then, please,
discuss the change you wish to make via [a new issue][2].

## Contributing Code

Open a Pull Request to **master** branch with the changes **well
documented**.

### Here are a few guidelines you should follow before submitting

1. **License Acceptance:** All contributions must be licensed as [GNU
   GPLv3](LICENSE) to be accepted. Use `git commit --signoff` to acknowledge
   this.
2. **No Breakage:** new features or changes to existing ones must not
   degrade the user experience.
3. **Coding standards:** best-practices should be followed, comment
   generously, and avoid "clever" algorithms. Refactoring existing messes is
   great, but watch out for breakage.
4. **No large PR:** try to limit the scope of PR only to the related issue,
   so it will be easier to review and test.
5. **Don't send features that can be replaced by system tools:** for
   example, features like daemonice TrelloWarrior can be done using hooks,
   cron or systemd-timers. Please avoid send Pull Requests with
   functionalities like this example. In case of doubt, open [a new
   issue][2] to discuss it.

### Pull Request Process

1. Ensure all commits are signed-off.
2. Ensure that Pull Request is well documented.
3. Ensure that you add your name and your GitHub name in contributors list.
4. Open the Pull Request.
5. Profit.

[1]: https://github.com/ogarcia/trellowarrior/issues
[2]: https://github.com/ogarcia/trellowarrior/issues/new

## Contributors

- [Jean Jordaan](https://github.com/jean)
