import os, shutil
from snipper.snipper_main import censor_file
from pathlib import Path
import time
import fnmatch


def snip_dir(source_dir,  # Sources
             dest_dir,  # Will write to this directory
             output_dir=None, # Where snippets are going to be stored
             references=None, # Reference database
             exclude=None, clean_destination_dir=True):

    if references == None:
        references = dict(aux=None, bibtex=None,  commands=[])

    if exclude == None:
        exclude = []

    if not os.path.exists(dest_dir):
        os.makedirs(dest_dir)
    if not os.path.exists(output_dir):
        os.makedirs(output_dir)

    output_dir = os.path.abspath(output_dir)
    source_dir = os.path.abspath(source_dir)
    dest_dir = os.path.abspath(dest_dir)
    if os.path.samefile( source_dir, dest_dir):
        raise Exception("Source and destination is the same")

    if clean_destination_dir:
        shutil.rmtree(dest_dir)
    os.makedirs(dest_dir)


    out = dest_dir
    hw = {'base': source_dir,
          'exclusion': exclude}

    print(f"[snipper] Synchronizing directories: {hw['base']} -> {out}")
    if os.path.exists(dest_dir):
        shutil.rmtree(dest_dir)

    base = hw['base']

    shutil.copytree(base, dest_dir)
    time.sleep(0.2)

    ls = list(Path(dest_dir).glob('**/*.*'))
    acceptable = []
    for l in ls:
        split = os.path.normpath(os.path.relpath(l, dest_dir))
        m = [fnmatch.fnmatch(split, ex) for ex in exclude]
        acceptable.append( (l, not any(m) ))

    # print(acceptable)
    # now we have acceptable files in list.
    # run_out_dirs = ["./output"]
    n = 0
    # edirs = [os.path.join(out, f_) for f_ in hw['exclusion']]  # Exclude directories on exclude list (speed)
    # edirs = {os.path.normpath(os.path.dirname(f_) if not os.path.isdir(f_) else f_) for f_ in edirs}
    # edirs.remove(os.path.normpath(out))
    for f, accept in acceptable:
        if os.path.isdir(f) or not str(f).endswith(".py"): # We only touch .py files.
            continue
        f_dir = os.path.normpath(f if os.path.isdir(f) else os.path.dirname(f))
        if accept:
            # slist = hw['solutions'] if not CE else [os.path.basename(f)[:-3]]
            # base = None
            # if students_irlc_tools is not None:
            #     base = os.path.relpath(str(f), students_irlc_tools + "/..")
            #     base = base.replace("\\", "/")

            # if "assignments" in str(f) and "_grade.py" in str(f):
            #     continue
            info = {'new_references': [], 'code_copyright': 'Example student code. This file is automatically generated from the files in the instructor-directory'}
            paths = {}
            solution_list = []
            kwargs = {}
            cut_files = True
            run_files = True
            nrem = censor_file(f, info, run_files=run_files, run_out_dirs=output_dir, cut_files=cut_files, solution_list=solution_list,
                               include_path_base=base,
                               base_path=dest_dir,
                               references=references,
                               **kwargs)
            if nrem > 0:
                print(f"{nrem}> {f}")
            n += nrem
    for rm_file, accept in acceptable:
        # rm_file = l
        rm_file = os.path.abspath(rm_file)
        if not accept:
            if os.path.isfile(rm_file):
                os.remove(rm_file)
            else:
                if os.path.isdir(rm_file + "\\"):
                    shutil.rmtree(rm_file)

    return n
