# Python PLCopenXML

A Python class model for [PLCopen XML](https://www.plcopen.org/technical-activities/xml-exchange).

The class model has been generated with [xsdata](https://xsdata.readthedocs.io/). Xsdata can also be used to parse/serialize PLCopen XML files to/from the class model.

To be able to parse PLCopen XML files generated by Codesys, the class model also contains some manually created classes for Codesys-specific stuff.

## Usage

```python
from plcopen import *

# parsing an existing PLCopen XML file
with open(path_to_plcopen_xml_file, 'rb') as plcopen_xml_file:
    content = plcopen_xml_file.read()
    parser = XmlParser(context=XmlContext())
    return parser.from_bytes(content, Project)

# working on the parsed project
first_pou = plcopen_project.types.pous[0]

# serializing the project
with open(path_to_plcopen_xml_file, 'w') as plcopen_xml_file:
    serializer = XmlSerializer(context=context)
    serializer.config.pretty_print = True

    content = serializer.render(project)
    serializer.write(content)
```

Note: More information about parsing and serializing can be found in the [xsdata docs](https://xsdata.readthedocs.io/en/latest/xml.html#).