import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

soft_tissue_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.9853721927E+00, 8.3579401280E+00, 2.6506580254E-02, 2.6075747302E-02, 3.4380034705E-01],
	[5.0050000000E+03, 1.9876415477E+00, 8.3529549237E+00, 2.6586636177E-02, 2.6153562650E-02, 3.4405728259E-01],
	[5.0100000000E+03, 1.9899112269E+00, 8.3479776662E+00, 2.6666853319E-02, 2.6231529662E-02, 3.4431393876E-01],
	[5.0150000000E+03, 1.9921812300E+00, 8.3430083349E+00, 2.6747231842E-02, 2.6309648467E-02, 3.4457031624E-01],
	[5.0200000000E+03, 1.9944515566E+00, 8.3380469093E+00, 2.6827771908E-02, 2.6387919196E-02, 3.4482641570E-01],
	[5.0250000000E+03, 1.9967222065E+00, 8.3330933689E+00, 2.6908473681E-02, 2.6466341979E-02, 3.4508223781E-01],
	[5.0300000000E+03, 1.9989931794E+00, 8.3281476935E+00, 2.6989337321E-02, 2.6544916945E-02, 3.4533778324E-01],
	[5.0350000000E+03, 2.0012644750E+00, 8.3232098626E+00, 2.7070362993E-02, 2.6623644225E-02, 3.4559305264E-01],
	[5.0400000000E+03, 2.0035360931E+00, 8.3182798562E+00, 2.7151550857E-02, 2.6702523949E-02, 3.4584804669E-01],
	[5.0450000000E+03, 2.0058080334E+00, 8.3133576540E+00, 2.7232901077E-02, 2.6781556247E-02, 3.4610276603E-01],
	[5.0500000000E+03, 2.0080802956E+00, 8.3084432360E+00, 2.7314413815E-02, 2.6860741247E-02, 3.4635721134E-01],
	[5.0550000000E+03, 2.0103528794E+00, 8.3035365822E+00, 2.7396089233E-02, 2.6940079081E-02, 3.4661138326E-01],
	[5.0600000000E+03, 2.0126257846E+00, 8.2986376726E+00, 2.7477927494E-02, 2.7019569877E-02, 3.4686528245E-01],
	[5.0650000000E+03, 2.0148990109E+00, 8.2937464875E+00, 2.7559928759E-02, 2.7099213766E-02, 3.4711890955E-01],
	[5.0700000000E+03, 2.0171725580E+00, 8.2888630070E+00, 2.7642093193E-02, 2.7179010875E-02, 3.4737226522E-01],
	[5.0750000000E+03, 2.0194464257E+00, 8.2839872113E+00, 2.7724420955E-02, 2.7258961336E-02, 3.4762535010E-01],
	[5.0800000000E+03, 2.0217206136E+00, 8.2791190810E+00, 2.7806912211E-02, 2.7339065276E-02, 3.4787816483E-01],
	[5.0850000000E+03, 2.0240091465E+00, 8.2743413594E+00, 2.7889567120E-02, 2.7419326309E-02, 3.4813071006E-01],
	[5.0900000000E+03, 2.0262993792E+00, 8.2695791115E+00, 2.7972385847E-02, 2.7499741452E-02, 3.4838298642E-01],
	[5.0950000000E+03, 2.0285899508E+00, 8.2648242761E+00, 2.8055368553E-02, 2.7580310499E-02, 3.4863499455E-01],
	[5.1000000000E+03, 2.0308808613E+00, 8.2600768345E+00, 2.8138515401E-02, 2.7661033578E-02, 3.4888673508E-01],
	[5.1050000000E+03, 2.0331721101E+00, 8.2553367680E+00, 2.8221826552E-02, 2.7741910819E-02, 3.4913820865E-01],
	[5.1100000000E+03, 2.0354636972E+00, 8.2506040579E+00, 2.8305302171E-02, 2.7822942350E-02, 3.4938941588E-01],
	[5.1150000000E+03, 2.0377556222E+00, 8.2458786856E+00, 2.8388942418E-02, 2.7904128301E-02, 3.4964035741E-01],
	[5.1200000000E+03, 2.0400478847E+00, 8.2411606326E+00, 2.8472747456E-02, 2.7985468800E-02, 3.4989103385E-01],
	[5.1250000000E+03, 2.0423404846E+00, 8.2364498804E+00, 2.8556717448E-02, 2.8066963976E-02, 3.5014144584E-01],
	[5.1300000000E+03, 2.0446334216E+00, 8.2317464106E+00, 2.8640852556E-02, 2.8148613957E-02, 3.5039159398E-01],
	[5.1350000000E+03, 2.0469266953E+00, 8.2270502049E+00, 2.8725152943E-02, 2.8230418873E-02, 3.5064147891E-01],
	[5.1400000000E+03, 2.0492203056E+00, 8.2223612449E+00, 2.8809618770E-02, 2.8312378851E-02, 3.5089110123E-01],
	[5.1450000000E+03, 2.0515142520E+00, 8.2176795125E+00, 2.8894250200E-02, 2.8394494020E-02, 3.5114046156E-01],
	[5.1500000000E+03, 2.0538085344E+00, 8.2130049896E+00, 2.8979047396E-02, 2.8476764508E-02, 3.5138956033E-01],
	[5.1550000000E+03, 2.0561031525E+00, 8.2083376580E+00, 2.9064010519E-02, 2.8559190444E-02, 3.5163839793E-01],
	[5.1600000000E+03, 2.0583981059E+00, 8.2036774998E+00, 2.9149139733E-02, 2.8641771956E-02, 3.5188697506E-01],
	[5.1650000000E+03, 2.0607016674E+00, 8.1990728251E+00, 2.9234435200E-02, 2.8724511372E-02, 3.5213529242E-01],
	[5.1700000000E+03, 2.0630122418E+00, 8.1945140719E+00, 2.9319897081E-02, 2.8807408420E-02, 3.5238335070E-01],
	[5.1750000000E+03, 2.0653231697E+00, 8.1899622563E+00, 2.9405525540E-02, 2.8890461466E-02, 3.5263115058E-01],
	[5.1800000000E+03, 2.0676344507E+00, 8.1854173613E+00, 2.9491320739E-02, 2.8973670635E-02, 3.5287869275E-01],
	[5.1850000000E+03, 2.0699460846E+00, 8.1808793697E+00, 2.9577282840E-02, 2.9057036057E-02, 3.5312597791E-01],
	[5.1900000000E+03, 2.0722580712E+00, 8.1763482642E+00, 2.9663412005E-02, 2.9140557860E-02, 3.5337300672E-01],
	[5.1950000000E+03, 2.0745704100E+00, 8.1718240278E+00, 2.9749708397E-02, 2.9224236170E-02, 3.5361977987E-01],
	[5.2000000000E+03, 2.0768831009E+00, 8.1673066436E+00, 2.9836172178E-02, 2.9308071116E-02, 3.5386629804E-01],
	[5.2050000000E+03, 2.0791961436E+00, 8.1627960945E+00, 2.9922803511E-02, 2.9392062825E-02, 3.5411256190E-01],
	[5.2100000000E+03, 2.0815095377E+00, 8.1582923637E+00, 3.0009602558E-02, 2.9476211425E-02, 3.5435857213E-01],
	[5.2150000000E+03, 2.0838232830E+00, 8.1537954343E+00, 3.0096569481E-02, 2.9560517043E-02, 3.5460432938E-01],
	[5.2200000000E+03, 2.0861373792E+00, 8.1493052896E+00, 3.0183704443E-02, 2.9644979807E-02, 3.5484983433E-01],
	[5.2250000000E+03, 2.0884518261E+00, 8.1448219128E+00, 3.0271007606E-02, 2.9729599844E-02, 3.5509508764E-01],
	[5.2300000000E+03, 2.0907666232E+00, 8.1403452873E+00, 3.0358479132E-02, 2.9814377280E-02, 3.5534008997E-01],
	[5.2350000000E+03, 2.0930817704E+00, 8.1358753964E+00, 3.0446119184E-02, 2.9899312244E-02, 3.5558484198E-01],
	[5.2400000000E+03, 2.0953972674E+00, 8.1314122237E+00, 3.0533927924E-02, 2.9984404862E-02, 3.5582934433E-01],
	[5.2450000000E+03, 2.0977131139E+00, 8.1269557526E+00, 3.0621905515E-02, 3.0069655260E-02, 3.5607359767E-01],
	[5.2500000000E+03, 2.1000428300E+00, 8.1225841260E+00, 3.0710052118E-02, 3.0155067432E-02, 3.5631760265E-01],
	[5.2550000000E+03, 2.1023738850E+00, 8.1182246247E+00, 3.0798367897E-02, 3.0240637952E-02, 3.5656135993E-01],
	[5.2600000000E+03, 2.1047053069E+00, 8.1138716058E+00, 3.0886853013E-02, 3.0326366672E-02, 3.5680487014E-01],
	[5.2650000000E+03, 2.1070370955E+00, 8.1095250536E+00, 3.0975507630E-02, 3.0412253717E-02, 3.5704813393E-01],
	[5.2700000000E+03, 2.1093692503E+00, 8.1051849523E+00, 3.1064331908E-02, 3.0498299215E-02, 3.5729115194E-01],
	[5.2750000000E+03, 2.1117017712E+00, 8.1008512863E+00, 3.1153326011E-02, 3.0584503293E-02, 3.5753392482E-01],
	[5.2800000000E+03, 2.1140346579E+00, 8.0965240399E+00, 3.1242490102E-02, 3.0670866076E-02, 3.5777645320E-01],
	[5.2850000000E+03, 2.1163679100E+00, 8.0922031976E+00, 3.1331824341E-02, 3.0757387691E-02, 3.5801873771E-01],
	[5.2900000000E+03, 2.1187015272E+00, 8.0878887437E+00, 3.1421328892E-02, 3.0844068265E-02, 3.5826077898E-01],
	[5.2950000000E+03, 2.1210355093E+00, 8.0835806630E+00, 3.1511003918E-02, 3.0930907924E-02, 3.5850257766E-01],
	[5.3000000000E+03, 2.1233698561E+00, 8.0792789398E+00, 3.1600849579E-02, 3.1017906793E-02, 3.5874413435E-01],
	[5.3050000000E+03, 2.1257045671E+00, 8.0749835589E+00, 3.1690866040E-02, 3.1105065000E-02, 3.5898544969E-01],
	[5.3100000000E+03, 2.1280396421E+00, 8.0706945050E+00, 3.1781053461E-02, 3.1192382670E-02, 3.5922652431E-01],
	[5.3150000000E+03, 2.1303750809E+00, 8.0664117628E+00, 3.1871412006E-02, 3.1279859929E-02, 3.5946735881E-01],
	[5.3200000000E+03, 2.1327108831E+00, 8.0621353170E+00, 3.1961941837E-02, 3.1367496903E-02, 3.5970795383E-01],
	[5.3250000000E+03, 2.1350470484E+00, 8.0578651525E+00, 3.2052643116E-02, 3.1455293717E-02, 3.5994830997E-01],
	[5.3300000000E+03, 2.1373841992E+00, 8.0536048266E+00, 3.2143516006E-02, 3.1543250688E-02, 3.6018842785E-01],
	[5.3350000000E+03, 2.1397351363E+00, 8.0494276397E+00, 3.2234560668E-02, 3.1631371874E-02, 3.6042830808E-01],
	[5.3400000000E+03, 2.1420864533E+00, 8.0452565295E+00, 3.2325777266E-02, 3.1719653316E-02, 3.6066795127E-01],
	[5.3450000000E+03, 2.1444381500E+00, 8.0410914813E+00, 3.2417165961E-02, 3.1808095139E-02, 3.6090735803E-01],
	[5.3500000000E+03, 2.1467902259E+00, 8.0369324808E+00, 3.2508726916E-02, 3.1896697469E-02, 3.6114652896E-01],
	[5.3550000000E+03, 2.1491426809E+00, 8.0327795134E+00, 3.2600460293E-02, 3.1985460433E-02, 3.6138546467E-01],
	[5.3600000000E+03, 2.1514955146E+00, 8.0286325649E+00, 3.2692366255E-02, 3.2074384154E-02, 3.6162416575E-01],
	[5.3650000000E+03, 2.1538487268E+00, 8.0244916209E+00, 3.2784444964E-02, 3.2163468759E-02, 3.6186263281E-01],
	[5.3700000000E+03, 2.1562023171E+00, 8.0203566671E+00, 3.2876696582E-02, 3.2252714372E-02, 3.6210086643E-01],
	[5.3750000000E+03, 2.1585562852E+00, 8.0162276893E+00, 3.2969121272E-02, 3.2342121119E-02, 3.6233886722E-01],
	[5.3800000000E+03, 2.1609106310E+00, 8.0121046734E+00, 3.3061719195E-02, 3.2431689124E-02, 3.6257663577E-01],
	[5.3850000000E+03, 2.1632653540E+00, 8.0079876050E+00, 3.3154490515E-02, 3.2521418513E-02, 3.6281417266E-01],
	[5.3900000000E+03, 2.1656204540E+00, 8.0038764703E+00, 3.3247435393E-02, 3.2611309410E-02, 3.6305147849E-01],
	[5.3950000000E+03, 2.1679759307E+00, 7.9997712551E+00, 3.3340553993E-02, 3.2701361941E-02, 3.6328855383E-01],
	[5.4000000000E+03, 2.1703317838E+00, 7.9956719455E+00, 3.3433846476E-02, 3.2791576229E-02, 3.6352539928E-01],
	[5.4050000000E+03, 2.1726880130E+00, 7.9915785274E+00, 3.3527313004E-02, 3.2881952399E-02, 3.6376201541E-01],
	[5.4100000000E+03, 2.1750446181E+00, 7.9874909870E+00, 3.3620953740E-02, 3.2972490577E-02, 3.6399840281E-01],
	[5.4150000000E+03, 2.1774015987E+00, 7.9834093105E+00, 3.3714768847E-02, 3.3063190885E-02, 3.6423456205E-01],
	[5.4200000000E+03, 2.1797709720E+00, 7.9794018052E+00, 3.3808758486E-02, 3.3154057409E-02, 3.6447049370E-01],
	[5.4250000000E+03, 2.1821423145E+00, 7.9754089680E+00, 3.3902922820E-02, 3.3245086870E-02, 3.6470619834E-01],
	[5.4300000000E+03, 2.1845140487E+00, 7.9714218043E+00, 3.3997262012E-02, 3.3336278875E-02, 3.6494167654E-01],
	[5.4350000000E+03, 2.1868861741E+00, 7.9674403009E+00, 3.4091776223E-02, 3.3427633548E-02, 3.6517692887E-01],
	[5.4400000000E+03, 2.1892586906E+00, 7.9634644446E+00, 3.4186465616E-02, 3.3519151013E-02, 3.6541195590E-01],
	[5.4450000000E+03, 2.1916315978E+00, 7.9594942221E+00, 3.4281330353E-02, 3.3610831394E-02, 3.6564675819E-01],
	[5.4500000000E+03, 2.1940048955E+00, 7.9555296204E+00, 3.4376370597E-02, 3.3702674815E-02, 3.6588133630E-01],
	[5.4550000000E+03, 2.1963785833E+00, 7.9515706263E+00, 3.4471586510E-02, 3.3794681401E-02, 3.6611569080E-01],
	[5.4600000000E+03, 2.1987526610E+00, 7.9476172268E+00, 3.4566978254E-02, 3.3886851274E-02, 3.6634982225E-01],
	[5.4650000000E+03, 2.2011271282E+00, 7.9436694088E+00, 3.4662545992E-02, 3.3979184560E-02, 3.6658373120E-01],
	[5.4700000000E+03, 2.2035019847E+00, 7.9397271594E+00, 3.4758289885E-02, 3.4071681380E-02, 3.6681741821E-01],
	[5.4750000000E+03, 2.2058772302E+00, 7.9357904656E+00, 3.4854210097E-02, 3.4164341860E-02, 3.6705088383E-01],
	[5.4800000000E+03, 2.2082528643E+00, 7.9318593145E+00, 3.4950683081E-02, 3.4257527636E-02, 3.6728412862E-01],
	[5.4850000000E+03, 2.2106288869E+00, 7.9279336934E+00, 3.5047638087E-02, 3.4351170622E-02, 3.6751715312E-01],
	[5.4900000000E+03, 2.2130052975E+00, 7.9240135893E+00, 3.5144773048E-02, 3.4444980558E-02, 3.6774995788E-01],
	[5.4950000000E+03, 2.2153820960E+00, 7.9200989896E+00, 3.5242088134E-02, 3.4538957572E-02, 3.6798254345E-01],
	[5.5000000000E+03, 2.2177592820E+00, 7.9161898814E+00, 3.5339583514E-02, 3.4633101794E-02, 3.6821491037E-01],
	[5.5050000000E+03, 2.2201427327E+00, 7.9123194636E+00, 3.5437259355E-02, 3.4727415428E-02, 3.6844705918E-01],
	[5.5100000000E+03, 2.2225338469E+00, 7.9084954608E+00, 3.5535115828E-02, 3.4821899123E-02, 3.6867899042E-01],
	[5.5150000000E+03, 2.2249253640E+00, 7.9046767721E+00, 3.5633153101E-02, 3.4916550450E-02, 3.6891070464E-01],
	[5.5200000000E+03, 2.2273172837E+00, 7.9008633853E+00, 3.5731371342E-02, 3.5011369539E-02, 3.6914220237E-01],
	[5.5250000000E+03, 2.2297096058E+00, 7.8970552883E+00, 3.5829770720E-02, 3.5106356516E-02, 3.6937348414E-01],
	[5.5300000000E+03, 2.2321023299E+00, 7.8932524689E+00, 3.5928351404E-02, 3.5201511509E-02, 3.6960455049E-01],
	[5.5350000000E+03, 2.2344954558E+00, 7.8894549151E+00, 3.6027113564E-02, 3.5296834648E-02, 3.6983540194E-01],
	[5.5400000000E+03, 2.2368889831E+00, 7.8856626148E+00, 3.6126057367E-02, 3.5392326059E-02, 3.7006603904E-01],
	[5.5450000000E+03, 2.2392829116E+00, 7.8818755560E+00, 3.6225182982E-02, 3.5487985871E-02, 3.7029646229E-01],
	[5.5500000000E+03, 2.2416772409E+00, 7.8780937268E+00, 3.6324490579E-02, 3.5583814211E-02, 3.7052667224E-01],
	[5.5550000000E+03, 2.2440719709E+00, 7.8743171152E+00, 3.6423980326E-02, 3.5679811207E-02, 3.7075666941E-01],
	[5.5600000000E+03, 2.2464671011E+00, 7.8705457094E+00, 3.6523652392E-02, 3.5775976986E-02, 3.7098645433E-01],
	[5.5650000000E+03, 2.2488626313E+00, 7.8667794975E+00, 3.6623506945E-02, 3.5872311676E-02, 3.7121602774E-01],
	[5.5700000000E+03, 2.2512585611E+00, 7.8630184677E+00, 3.6723544155E-02, 3.5968815404E-02, 3.7144539025E-01],
	[5.5750000000E+03, 2.2536548904E+00, 7.8592626083E+00, 3.6823764190E-02, 3.6065488297E-02, 3.7167454246E-01],
	[5.5800000000E+03, 2.2560516188E+00, 7.8555119074E+00, 3.6924167220E-02, 3.6162330483E-02, 3.7190348494E-01],
	[5.5850000000E+03, 2.2584487460E+00, 7.8517663534E+00, 3.7024753412E-02, 3.6259342088E-02, 3.7213221829E-01],
	[5.5900000000E+03, 2.2608462717E+00, 7.8480259346E+00, 3.7125522936E-02, 3.6356523240E-02, 3.7236074307E-01],
	[5.5950000000E+03, 2.2632534595E+00, 7.8443426707E+00, 3.7226475961E-02, 3.6453877592E-02, 3.7258905988E-01],
	[5.6000000000E+03, 2.2656644881E+00, 7.8406836675E+00, 3.7327612655E-02, 3.6551403086E-02, 3.7281716929E-01],
	[5.6050000000E+03, 2.2680759300E+00, 7.8370296343E+00, 3.7428933188E-02, 3.6649098549E-02, 3.7304507186E-01],
	[5.6100000000E+03, 2.2704877849E+00, 7.8333805599E+00, 3.7530437727E-02, 3.6746964108E-02, 3.7327276818E-01],
	[5.6150000000E+03, 2.2729000525E+00, 7.8297364331E+00, 3.7632126443E-02, 3.6844999889E-02, 3.7350025881E-01],
	[5.6200000000E+03, 2.2753127325E+00, 7.8260972428E+00, 3.7733999503E-02, 3.6943206019E-02, 3.7372754432E-01],
	[5.6250000000E+03, 2.2777258245E+00, 7.8224629781E+00, 3.7836057077E-02, 3.7041582625E-02, 3.7395462528E-01],
	[5.6300000000E+03, 2.2801393283E+00, 7.8188336278E+00, 3.7938299333E-02, 3.7140129833E-02, 3.7418150225E-01],
	[5.6350000000E+03, 2.2825532436E+00, 7.8152091809E+00, 3.8040726440E-02, 3.7238847770E-02, 3.7440817580E-01],
	[5.6400000000E+03, 2.2849675701E+00, 7.8115896265E+00, 3.8143338568E-02, 3.7337736561E-02, 3.7463464648E-01],
	[5.6450000000E+03, 2.2873823076E+00, 7.8079749537E+00, 3.8246135884E-02, 3.7436796333E-02, 3.7486091484E-01],
	[5.6500000000E+03, 2.2897974556E+00, 7.8043651515E+00, 3.8349118558E-02, 3.7536027212E-02, 3.7508698146E-01],
	[5.6550000000E+03, 2.2922130139E+00, 7.8007602091E+00, 3.8452286759E-02, 3.7635429324E-02, 3.7531284688E-01],
	[5.6600000000E+03, 2.2946289822E+00, 7.7971601157E+00, 3.8555640655E-02, 3.7735002795E-02, 3.7553851164E-01],
	[5.6650000000E+03, 2.2970453603E+00, 7.7935648604E+00, 3.8659180416E-02, 3.7834747751E-02, 3.7576397632E-01],
	[5.6700000000E+03, 2.2994621478E+00, 7.7899744324E+00, 3.8762906210E-02, 3.7934664317E-02, 3.7598924144E-01],
	[5.6750000000E+03, 2.3018793445E+00, 7.7863888212E+00, 3.8866818205E-02, 3.8034752619E-02, 3.7621430755E-01],
	[5.6800000000E+03, 2.3042969500E+00, 7.7828080159E+00, 3.8970916572E-02, 3.8135012783E-02, 3.7643917521E-01],
	[5.6850000000E+03, 2.3067238652E+00, 7.7792817859E+00, 3.9075201479E-02, 3.8235448581E-02, 3.7666384495E-01],
	[5.6900000000E+03, 2.3091545408E+00, 7.7757789097E+00, 3.9179673094E-02, 3.8336057898E-02, 3.7688831732E-01],
	[5.6950000000E+03, 2.3115856394E+00, 7.7722806855E+00, 3.9284331587E-02, 3.8436839495E-02, 3.7711259284E-01],
	[5.7000000000E+03, 2.3140171606E+00, 7.7687871030E+00, 3.9389177126E-02, 3.8537793498E-02, 3.7733667207E-01],
	[5.7050000000E+03, 2.3164491042E+00, 7.7652981519E+00, 3.9494209880E-02, 3.8638920033E-02, 3.7756055552E-01],
	[5.7100000000E+03, 2.3188814698E+00, 7.7618138222E+00, 3.9599430019E-02, 3.8740219224E-02, 3.7778424374E-01],
	[5.7150000000E+03, 2.3213142571E+00, 7.7583341035E+00, 3.9704837710E-02, 3.8841691196E-02, 3.7800773725E-01],
	[5.7200000000E+03, 2.3237474659E+00, 7.7548589859E+00, 3.9810433124E-02, 3.8943336075E-02, 3.7823103659E-01],
	[5.7250000000E+03, 2.3261810958E+00, 7.7513884592E+00, 3.9916216428E-02, 3.9045153985E-02, 3.7845414229E-01],
	[5.7300000000E+03, 2.3286151466E+00, 7.7479225133E+00, 4.0022187792E-02, 3.9147145052E-02, 3.7867705485E-01],
	[5.7350000000E+03, 2.3310496180E+00, 7.7444611382E+00, 4.0128373186E-02, 3.9249334082E-02, 3.7889977482E-01],
	[5.7400000000E+03, 2.3334845096E+00, 7.7410043238E+00, 4.0234776512E-02, 3.9351724767E-02, 3.7912230271E-01],
	[5.7450000000E+03, 2.3359198212E+00, 7.7375520604E+00, 4.0341368684E-02, 3.9454289241E-02, 3.7934463904E-01],
	[5.7500000000E+03, 2.3383555525E+00, 7.7341043377E+00, 4.0448149873E-02, 3.9557027629E-02, 3.7956678433E-01],
	[5.7550000000E+03, 2.3407917031E+00, 7.7306611461E+00, 4.0555120248E-02, 3.9659940056E-02, 3.7978873910E-01],
	[5.7600000000E+03, 2.3432282729E+00, 7.7272224755E+00, 4.0662279978E-02, 3.9763026647E-02, 3.8001050386E-01],
	[5.7650000000E+03, 2.3456652615E+00, 7.7237883162E+00, 4.0769629233E-02, 3.9866287527E-02, 3.8023207912E-01],
	[5.7700000000E+03, 2.3481026686E+00, 7.7203586582E+00, 4.0877168183E-02, 3.9969722819E-02, 3.8045346540E-01],
	[5.7750000000E+03, 2.3505456169E+00, 7.7169620718E+00, 4.0984896997E-02, 4.0073334910E-02, 3.8067466319E-01],
	[5.7800000000E+03, 2.3529956541E+00, 7.7136070440E+00, 4.1092815845E-02, 4.0177124632E-02, 3.8089567302E-01],
	[5.7850000000E+03, 2.3554461232E+00, 7.7102563740E+00, 4.1200924896E-02, 4.0281089184E-02, 3.8111649539E-01],
	[5.7900000000E+03, 2.3578970240E+00, 7.7069100523E+00, 4.1309224320E-02, 4.0385228692E-02, 3.8133713080E-01],
	[5.7950000000E+03, 2.3603483561E+00, 7.7035680695E+00, 4.1417714287E-02, 4.0489543278E-02, 3.8155757975E-01],
	[5.8000000000E+03, 2.3628001193E+00, 7.7002304163E+00, 4.1526394966E-02, 4.0594033069E-02, 3.8177784274E-01],
	[5.8050000000E+03, 2.3652523132E+00, 7.6968970834E+00, 4.1635266527E-02, 4.0698698187E-02, 3.8199792027E-01],
	[5.8100000000E+03, 2.3677049376E+00, 7.6935680614E+00, 4.1744329140E-02, 4.0803538757E-02, 3.8221781285E-01],
	[5.8150000000E+03, 2.3701579921E+00, 7.6902433411E+00, 4.1853582973E-02, 4.0908554903E-02, 3.8243752096E-01],
	[5.8200000000E+03, 2.3726114765E+00, 7.6869229132E+00, 4.1963028197E-02, 4.1013746749E-02, 3.8265704510E-01],
	[5.8250000000E+03, 2.3750653905E+00, 7.6836067686E+00, 4.2072664981E-02, 4.1119114419E-02, 3.8287638576E-01],
	[5.8300000000E+03, 2.3775197337E+00, 7.6802948979E+00, 4.2182493496E-02, 4.1224658036E-02, 3.8309554343E-01],
	[5.8350000000E+03, 2.3799745059E+00, 7.6769872920E+00, 4.2292513910E-02, 4.1330377723E-02, 3.8331451861E-01],
	[5.8400000000E+03, 2.3824297068E+00, 7.6736839419E+00, 4.2402726393E-02, 4.1436273605E-02, 3.8353331177E-01],
	[5.8450000000E+03, 2.3848853362E+00, 7.6703848383E+00, 4.2513131115E-02, 4.1542345805E-02, 3.8375192341E-01],
	[5.8500000000E+03, 2.3873413936E+00, 7.6670899722E+00, 4.2623728245E-02, 4.1648594446E-02, 3.8397035400E-01],
	[5.8550000000E+03, 2.3897978788E+00, 7.6637993346E+00, 4.2734517954E-02, 4.1755019652E-02, 3.8418860404E-01],
	[5.8600000000E+03, 2.3922547915E+00, 7.6605129164E+00, 4.2845500410E-02, 4.1861621545E-02, 3.8440667400E-01],
	[5.8650000000E+03, 2.3947121315E+00, 7.6572307086E+00, 4.2956675784E-02, 4.1968400248E-02, 3.8462456435E-01],
	[5.8700000000E+03, 2.3971795043E+00, 7.6540061863E+00, 4.3068044244E-02, 4.2075360461E-02, 3.8484227559E-01],
	[5.8750000000E+03, 2.3996490406E+00, 7.6507953576E+00, 4.3179605962E-02, 4.2182498592E-02, 3.8505980819E-01],
	[5.8800000000E+03, 2.4021190168E+00, 7.6475886056E+00, 4.3291361106E-02, 4.2289813948E-02, 3.8527716261E-01],
	[5.8850000000E+03, 2.4045894328E+00, 7.6443859216E+00, 4.3403309846E-02, 4.2397306650E-02, 3.8549433934E-01],
	[5.8900000000E+03, 2.4070602881E+00, 7.6411872970E+00, 4.3515452351E-02, 4.2504976822E-02, 3.8571133884E-01],
	[5.8950000000E+03, 2.4095315826E+00, 7.6379927233E+00, 4.3627788792E-02, 4.2612824587E-02, 3.8592816158E-01],
	[5.9000000000E+03, 2.4120033159E+00, 7.6348021919E+00, 4.3740319338E-02, 4.2720850066E-02, 3.8614480804E-01],
	[5.9050000000E+03, 2.4144754876E+00, 7.6316156942E+00, 4.3853044159E-02, 4.2829053383E-02, 3.8636127868E-01],
	[5.9100000000E+03, 2.4169480976E+00, 7.6284332218E+00, 4.3965963424E-02, 4.2937434660E-02, 3.8657757397E-01],
	[5.9150000000E+03, 2.4194211456E+00, 7.6252547661E+00, 4.4079077303E-02, 4.3045994019E-02, 3.8679369436E-01],
	[5.9200000000E+03, 2.4218946311E+00, 7.6220803187E+00, 4.4192385966E-02, 4.3154731582E-02, 3.8700964033E-01],
	[5.9250000000E+03, 2.4243685540E+00, 7.6189098711E+00, 4.4305889582E-02, 4.3263647472E-02, 3.8722541233E-01],
	[5.9300000000E+03, 2.4268429140E+00, 7.6157434151E+00, 4.4419588322E-02, 4.3372741810E-02, 3.8744101082E-01],
	[5.9350000000E+03, 2.4293177107E+00, 7.6125809420E+00, 4.4533482354E-02, 4.3482014718E-02, 3.8765643627E-01],
	[5.9400000000E+03, 2.4317929439E+00, 7.6094224437E+00, 4.4647571848E-02, 4.3591466318E-02, 3.8787168912E-01],
	[5.9450000000E+03, 2.4342686133E+00, 7.6062679118E+00, 4.4761856975E-02, 4.3701096732E-02, 3.8808676982E-01],
	[5.9500000000E+03, 2.4367447186E+00, 7.6031173379E+00, 4.4876337904E-02, 4.3810906082E-02, 3.8830167879E-01],
	[5.9550000000E+03, 2.4392212595E+00, 7.5999707138E+00, 4.4991014804E-02, 4.3920894488E-02, 3.8851641653E-01],
	[5.9600000000E+03, 2.4416982357E+00, 7.5968280313E+00, 4.5105887845E-02, 4.4031062072E-02, 3.8873098353E-01],
	[5.9650000000E+03, 2.4441861053E+00, 7.5937475036E+00, 4.5220957198E-02, 4.4141414335E-02, 3.8894538028E-01],
	[5.9700000000E+03, 2.4466748393E+00, 7.5906731235E+00, 4.5336223031E-02, 4.4251946277E-02, 3.8915960727E-01],
	[5.9750000000E+03, 2.4491640208E+00, 7.5876025602E+00, 4.5451685514E-02, 4.4362657807E-02, 3.8937366498E-01],
	[5.9800000000E+03, 2.4516536493E+00, 7.5845358059E+00, 4.5567344818E-02, 4.4473549047E-02, 3.8958755391E-01],
	[5.9850000000E+03, 2.4541437247E+00, 7.5814728527E+00, 4.5683201111E-02, 4.4584620116E-02, 3.8980127453E-01],
	[5.9900000000E+03, 2.4566342466E+00, 7.5784136926E+00, 4.5799254564E-02, 4.4695871137E-02, 3.9001482733E-01],
	[5.9950000000E+03, 2.4591252148E+00, 7.5753583179E+00, 4.5915505346E-02, 4.4807302231E-02, 3.9022821279E-01],
	[6.0000000000E+03, 2.4616166289E+00, 7.5723067207E+00, 4.6031953627E-02, 4.4918913517E-02, 3.9044143139E-01],
	[6.0050000000E+03, 2.4641084887E+00, 7.5692588932E+00, 4.6149169830E-02, 4.5031248077E-02, 3.9065448360E-01],
	[6.0100000000E+03, 2.4666007938E+00, 7.5662148276E+00, 4.6266586292E-02, 4.5143765277E-02, 3.9086736990E-01],
	[6.0150000000E+03, 2.4690935440E+00, 7.5631745161E+00, 4.6384203188E-02, 4.5256465243E-02, 3.9108009078E-01],
	[6.0200000000E+03, 2.4715867390E+00, 7.5601379510E+00, 4.6502020692E-02, 4.5369348098E-02, 3.9129264669E-01],
	[6.0250000000E+03, 2.4740803785E+00, 7.5571051246E+00, 4.6620038979E-02, 4.5482413966E-02, 3.9150503811E-01],
	[6.0300000000E+03, 2.4765744622E+00, 7.5540760291E+00, 4.6738258222E-02, 4.5595662971E-02, 3.9171726551E-01],
	[6.0350000000E+03, 2.4790689899E+00, 7.5510506569E+00, 4.6856678597E-02, 4.5709095237E-02, 3.9192932936E-01],
	[6.0400000000E+03, 2.4815639611E+00, 7.5480290003E+00, 4.6975300278E-02, 4.5822710886E-02, 3.9214123012E-01],
	[6.0450000000E+03, 2.4840593757E+00, 7.5450110517E+00, 4.7094123439E-02, 4.5936510044E-02, 3.9235296827E-01],
	[6.0500000000E+03, 2.4865552334E+00, 7.5419968035E+00, 4.7213148253E-02, 4.6050492832E-02, 3.9256454426E-01],
	[6.0550000000E+03, 2.4890515338E+00, 7.5389862481E+00, 4.7332374897E-02, 4.6164659375E-02, 3.9277595855E-01],
	[6.0600000000E+03, 2.4915563528E+00, 7.5360241803E+00, 4.7451803543E-02, 4.6279014271E-02, 3.9298721162E-01],
	[6.0650000000E+03, 2.4940640174E+00, 7.5330789786E+00, 4.7571434367E-02, 4.6393554535E-02, 3.9319830390E-01],
	[6.0700000000E+03, 2.4965721362E+00, 7.5301373535E+00, 4.7691267542E-02, 4.6508278971E-02, 3.9340923587E-01],
	[6.0750000000E+03, 2.4990807090E+00, 7.5271992978E+00, 4.7811303243E-02, 4.6623187700E-02, 3.9362000798E-01],
	[6.0800000000E+03, 2.5015897355E+00, 7.5242648041E+00, 4.7931541645E-02, 4.6738280847E-02, 3.9383062069E-01],
	[6.0850000000E+03, 2.5040992155E+00, 7.5213338654E+00, 4.8051982921E-02, 4.6853558533E-02, 3.9404107444E-01],
	[6.0900000000E+03, 2.5066091485E+00, 7.5184064742E+00, 4.8172627247E-02, 4.6969020883E-02, 3.9425136969E-01],
	[6.0950000000E+03, 2.5091195344E+00, 7.5154826235E+00, 4.8293474796E-02, 4.7084668018E-02, 3.9446150689E-01],
	[6.1000000000E+03, 2.5116303728E+00, 7.5125623060E+00, 4.8414525743E-02, 4.7200500061E-02, 3.9467148649E-01],
	[6.1050000000E+03, 2.5141416635E+00, 7.5096455146E+00, 4.8535780263E-02, 4.7316517134E-02, 3.9488130893E-01],
	[6.1100000000E+03, 2.5166534061E+00, 7.5067322422E+00, 4.8657238529E-02, 4.7432719361E-02, 3.9509097466E-01],
	[6.1150000000E+03, 2.5191656004E+00, 7.5038224816E+00, 4.8778900716E-02, 4.7549106864E-02, 3.9530048413E-01],
	[6.1200000000E+03, 2.5216782461E+00, 7.5009162257E+00, 4.8900766999E-02, 4.7665679763E-02, 3.9550983778E-01],
	[6.1250000000E+03, 2.5241913428E+00, 7.4980134674E+00, 4.9022837552E-02, 4.7782438183E-02, 3.9571903605E-01],
	[6.1300000000E+03, 2.5267048904E+00, 7.4951141998E+00, 4.9145112549E-02, 4.7899382244E-02, 3.9592807938E-01],
	[6.1350000000E+03, 2.5292188885E+00, 7.4922184157E+00, 4.9267592165E-02, 4.8016512069E-02, 3.9613696821E-01],
	[6.1400000000E+03, 2.5317333369E+00, 7.4893261081E+00, 4.9390276574E-02, 4.8133827779E-02, 3.9634570298E-01],
	[6.1450000000E+03, 2.5342482351E+00, 7.4864372700E+00, 4.9513165951E-02, 4.8251329496E-02, 3.9655428413E-01],
	[6.1500000000E+03, 2.5367635831E+00, 7.4835518945E+00, 4.9636260470E-02, 4.8369017341E-02, 3.9676271208E-01],
	[6.1550000000E+03, 2.5392821311E+00, 7.4806851390E+00, 4.9759560306E-02, 4.8486893077E-02, 3.9697098727E-01],
	[6.1600000000E+03, 2.5418084849E+00, 7.4778622932E+00, 4.9883065632E-02, 4.8604959597E-02, 3.9717911014E-01],
	[6.1650000000E+03, 2.5443352995E+00, 7.4750428016E+00, 5.0006776624E-02, 4.8723212657E-02, 3.9738708112E-01],
	[6.1700000000E+03, 2.5468625744E+00, 7.4722266576E+00, 5.0130693456E-02, 4.8841652381E-02, 3.9759490063E-01],
	[6.1750000000E+03, 2.5493903093E+00, 7.4694138544E+00, 5.0254816302E-02, 4.8960278888E-02, 3.9780256910E-01],
	[6.1800000000E+03, 2.5519185041E+00, 7.4666043854E+00, 5.0379145338E-02, 4.9079092300E-02, 3.9801008696E-01],
	[6.1850000000E+03, 2.5544471583E+00, 7.4637982440E+00, 5.0503680736E-02, 4.9198092739E-02, 3.9821745464E-01],
	[6.1900000000E+03, 2.5569762718E+00, 7.4609954235E+00, 5.0628422672E-02, 4.9317280324E-02, 3.9842467256E-01],
	[6.1950000000E+03, 2.5595058442E+00, 7.4581959174E+00, 5.0753371321E-02, 4.9436655178E-02, 3.9863174114E-01],
	[6.2000000000E+03, 2.5620358752E+00, 7.4553997190E+00, 5.0878526856E-02, 4.9556217420E-02, 3.9883866080E-01],
	[6.2050000000E+03, 2.5645663645E+00, 7.4526068217E+00, 5.1003889452E-02, 4.9675967172E-02, 3.9904543197E-01],
	[6.2100000000E+03, 2.5670973119E+00, 7.4498172191E+00, 5.1129459285E-02, 4.9795904554E-02, 3.9925205506E-01],
	[6.2150000000E+03, 2.5696287171E+00, 7.4470309045E+00, 5.1255236527E-02, 4.9916029686E-02, 3.9945853050E-01],
	[6.2200000000E+03, 2.5721605798E+00, 7.4442478715E+00, 5.1381221354E-02, 5.0036342689E-02, 3.9966485869E-01],
	[6.2250000000E+03, 2.5746928997E+00, 7.4414681135E+00, 5.1507413941E-02, 5.0156843683E-02, 3.9987104005E-01],
	[6.2300000000E+03, 2.5772256765E+00, 7.4386916242E+00, 5.1633814461E-02, 5.0277532789E-02, 4.0007707500E-01],
	[6.2350000000E+03, 2.5797589099E+00, 7.4359183969E+00, 5.1760423090E-02, 5.0398410126E-02, 4.0028296396E-01],
	[6.2400000000E+03, 2.5822925997E+00, 7.4331484253E+00, 5.1887247838E-02, 5.0519483243E-02, 4.0048870732E-01],
	[6.2450000000E+03, 2.5848267455E+00, 7.4303817030E+00, 5.2014282445E-02, 5.0640746158E-02, 4.0069430551E-01],
	[6.2500000000E+03, 2.5873613472E+00, 7.4276182235E+00, 5.2141525728E-02, 5.0762197704E-02, 4.0089975892E-01],
	[6.2550000000E+03, 2.5899008755E+00, 7.4248824823E+00, 5.2268977861E-02, 5.0883840877E-02, 4.0110506798E-01],
	[6.2600000000E+03, 2.5924461309E+00, 7.4221787551E+00, 5.2396639019E-02, 5.1005676342E-02, 4.0131023308E-01],
	[6.2650000000E+03, 2.5949918525E+00, 7.4194781699E+00, 5.2524509377E-02, 5.1127700846E-02, 4.0151525463E-01],
	[6.2700000000E+03, 2.5975380400E+00, 7.4167807206E+00, 5.2652589108E-02, 5.1249914509E-02, 4.0172013304E-01],
	[6.2750000000E+03, 2.6000846932E+00, 7.4140864011E+00, 5.2780878389E-02, 5.1372317450E-02, 4.0192486871E-01],
	[6.2800000000E+03, 2.6026318119E+00, 7.4113952052E+00, 5.2909377393E-02, 5.1494909788E-02, 4.0212946203E-01],
	[6.2850000000E+03, 2.6051793956E+00, 7.4087071268E+00, 5.3038086296E-02, 5.1617691644E-02, 4.0233391342E-01],
	[6.2900000000E+03, 2.6077274441E+00, 7.4060221598E+00, 5.3167005271E-02, 5.1740663135E-02, 4.0253822327E-01],
	[6.2950000000E+03, 2.6102759571E+00, 7.4033402982E+00, 5.3296134494E-02, 5.1863824382E-02, 4.0274239198E-01],
	[6.3000000000E+03, 2.6128249344E+00, 7.4006615359E+00, 5.3425474139E-02, 5.1987175503E-02, 4.0294641994E-01],
	[6.3050000000E+03, 2.6153743757E+00, 7.3979858668E+00, 5.3555024381E-02, 5.2110716617E-02, 4.0315030755E-01],
	[6.3100000000E+03, 2.6179242806E+00, 7.3953132850E+00, 5.3684785395E-02, 5.2234447843E-02, 4.0335405522E-01],
	[6.3150000000E+03, 2.6204746490E+00, 7.3926437845E+00, 5.3814757355E-02, 5.2358369299E-02, 4.0355766332E-01],
	[6.3200000000E+03, 2.6230254804E+00, 7.3899773591E+00, 5.3944940437E-02, 5.2482481105E-02, 4.0376113226E-01],
	[6.3250000000E+03, 2.6255767747E+00, 7.3873140031E+00, 5.4075334813E-02, 5.2606783377E-02, 4.0396446242E-01],
	[6.3300000000E+03, 2.6281285315E+00, 7.3846537104E+00, 5.4205940661E-02, 5.2731276236E-02, 4.0416765420E-01],
	[6.3350000000E+03, 2.6306807506E+00, 7.3819964751E+00, 5.4336758154E-02, 5.2855959799E-02, 4.0437070799E-01],
	[6.3400000000E+03, 2.6332334316E+00, 7.3793422913E+00, 5.4467787466E-02, 5.2980834184E-02, 4.0457362416E-01],
	[6.3450000000E+03, 2.6357865744E+00, 7.3766911530E+00, 5.4599028773E-02, 5.3105899509E-02, 4.0477640312E-01],
	[6.3500000000E+03, 2.6383401786E+00, 7.3740430544E+00, 5.4730482250E-02, 5.3231155893E-02, 4.0497904524E-01],
	[6.3550000000E+03, 2.6408973093E+00, 7.3714147173E+00, 5.4862148071E-02, 5.3356605580E-02, 4.0518155092E-01],
	[6.3600000000E+03, 2.6434612084E+00, 7.3688237379E+00, 5.4994026410E-02, 5.3482250967E-02, 4.0538392053E-01],
	[6.3650000000E+03, 2.6460255788E+00, 7.3662357042E+00, 5.5126117443E-02, 5.3608087817E-02, 4.0558615445E-01],
	[6.3700000000E+03, 2.6485904203E+00, 7.3636506107E+00, 5.5258421345E-02, 5.3734116246E-02, 4.0578825308E-01],
	[6.3750000000E+03, 2.6511557326E+00, 7.3610684516E+00, 5.5390938289E-02, 5.3860336373E-02, 4.0599021679E-01],
	[6.3800000000E+03, 2.6537215153E+00, 7.3584892213E+00, 5.5523668452E-02, 5.3986748315E-02, 4.0619204595E-01],
	[6.3850000000E+03, 2.6562877684E+00, 7.3559129143E+00, 5.5656612007E-02, 5.4113352189E-02, 4.0639374095E-01],
	[6.3900000000E+03, 2.6588544913E+00, 7.3533395249E+00, 5.5789769130E-02, 5.4240148113E-02, 4.0659530217E-01],
	[6.3950000000E+03, 2.6614216840E+00, 7.3507690475E+00, 5.5923139995E-02, 5.4367136203E-02, 4.0679672998E-01],
	[6.4000000000E+03, 2.6639893460E+00, 7.3482014766E+00, 5.6056724776E-02, 5.4494316578E-02, 4.0699802476E-01],
	[6.4050000000E+03, 2.6665574771E+00, 7.3456368066E+00, 5.6190523650E-02, 5.4621689353E-02, 4.0719918688E-01],
	[6.4100000000E+03, 2.6691260770E+00, 7.3430750320E+00, 5.6324536790E-02, 5.4749254646E-02, 4.0740021671E-01],
	[6.4150000000E+03, 2.6716951455E+00, 7.3405161472E+00, 5.6458764371E-02, 5.4877012574E-02, 4.0760111463E-01],
	[6.4200000000E+03, 2.6742646822E+00, 7.3379601468E+00, 5.6593206569E-02, 5.5004963253E-02, 4.0780188100E-01],
	[6.4250000000E+03, 2.6768346869E+00, 7.3354070252E+00, 5.6727863557E-02, 5.5133106799E-02, 4.0800251621E-01],
	[6.4300000000E+03, 2.6794051593E+00, 7.3328567770E+00, 5.6862735512E-02, 5.5261443330E-02, 4.0820302061E-01],
	[6.4350000000E+03, 2.6819760992E+00, 7.3303093967E+00, 5.6997822607E-02, 5.5389972960E-02, 4.0840339458E-01],
	[6.4400000000E+03, 2.6845475062E+00, 7.3277648789E+00, 5.7133125017E-02, 5.5518695808E-02, 4.0860363848E-01],
	[6.4450000000E+03, 2.6871193800E+00, 7.3252232181E+00, 5.7268642917E-02, 5.5647611988E-02, 4.0880375267E-01],
	[6.4500000000E+03, 2.6896917204E+00, 7.3226844089E+00, 5.7404376483E-02, 5.5776721617E-02, 4.0900373754E-01],
	[6.4550000000E+03, 2.6922645272E+00, 7.3201484459E+00, 5.7540325888E-02, 5.5906024810E-02, 4.0920359343E-01],
	[6.4600000000E+03, 2.6948456390E+00, 7.3176579496E+00, 5.7676491308E-02, 5.6035527573E-02, 4.0940332071E-01],
	[6.4650000000E+03, 2.6974283852E+00, 7.3151765240E+00, 5.7812872918E-02, 5.6165225051E-02, 4.0960291974E-01],
	[6.4700000000E+03, 2.7000116071E+00, 7.3126978572E+00, 5.7949470892E-02, 5.6295116492E-02, 4.0980239089E-01],
	[6.4750000000E+03, 2.7025953044E+00, 7.3102219440E+00, 5.8086285405E-02, 5.6425202013E-02, 4.1000173452E-01],
	[6.4800000000E+03, 2.7051794769E+00, 7.3077487794E+00, 5.8223316632E-02, 5.6555481729E-02, 4.1020095098E-01],
	[6.4850000000E+03, 2.7077641242E+00, 7.3052783580E+00, 5.8360573163E-02, 5.6685963693E-02, 4.1040004063E-01],
	[6.4900000000E+03, 2.7103492462E+00, 7.3028106749E+00, 5.8498048258E-02, 5.6816641497E-02, 4.1059900383E-01],
	[6.4950000000E+03, 2.7129348425E+00, 7.3003457247E+00, 5.8635740634E-02, 5.6947513880E-02, 4.1079784095E-01],
	[6.5000000000E+03, 2.7155209129E+00, 7.2978835024E+00, 5.8773650466E-02, 5.7078580957E-02, 4.1099655232E-01],
	[6.5050000000E+03, 2.7181074571E+00, 7.2954240029E+00, 5.8911777928E-02, 5.7209842843E-02, 4.1119513831E-01],
	[6.5100000000E+03, 2.7206944747E+00, 7.2929672211E+00, 5.9050123197E-02, 5.7341299654E-02, 4.1139359927E-01],
	[6.5150000000E+03, 2.7232819656E+00, 7.2905131519E+00, 5.9188686446E-02, 5.7472951503E-02, 4.1159193555E-01],
	[6.5200000000E+03, 2.7258699294E+00, 7.2880617901E+00, 5.9327467852E-02, 5.7604798506E-02, 4.1179014752E-01],
	[6.5250000000E+03, 2.7284583658E+00, 7.2856131309E+00, 5.9466467588E-02, 5.7736840778E-02, 4.1198823550E-01],
	[6.5300000000E+03, 2.7310472747E+00, 7.2831671690E+00, 5.9605685829E-02, 5.7869078432E-02, 4.1218619987E-01],
	[6.5350000000E+03, 2.7336366557E+00, 7.2807238996E+00, 5.9745122752E-02, 5.8001511584E-02, 4.1238404096E-01],
	[6.5400000000E+03, 2.7362265085E+00, 7.2782833175E+00, 5.9884778530E-02, 5.8134140348E-02, 4.1258175912E-01],
	[6.5450000000E+03, 2.7388168329E+00, 7.2758454177E+00, 6.0024653339E-02, 5.8266964837E-02, 4.1277935471E-01],
	[6.5500000000E+03, 2.7414076286E+00, 7.2734101953E+00, 6.0164747354E-02, 5.8399985166E-02, 4.1297682806E-01],
	[6.5550000000E+03, 2.7439988953E+00, 7.2709776452E+00, 6.0305060749E-02, 5.8533201450E-02, 4.1317417953E-01],
	[6.5600000000E+03, 2.7465913723E+00, 7.2685517836E+00, 6.0445593701E-02, 5.8666614400E-02, 4.1337140946E-01],
	[6.5650000000E+03, 2.7491922067E+00, 7.2661714001E+00, 6.0586346383E-02, 5.8800229948E-02, 4.1356851819E-01],
	[6.5700000000E+03, 2.7517935211E+00, 7.2637936076E+00, 6.0727318971E-02, 5.8934041844E-02, 4.1376550606E-01],
	[6.5750000000E+03, 2.7543953151E+00, 7.2614184012E+00, 6.0868511640E-02, 5.9068050203E-02, 4.1396237342E-01],
	[6.5800000000E+03, 2.7569975885E+00, 7.2590457761E+00, 6.1009924564E-02, 5.9202255137E-02, 4.1415912061E-01],
	[6.5850000000E+03, 2.7596003410E+00, 7.2566757276E+00, 6.1151557920E-02, 5.9336656760E-02, 4.1435574797E-01],
	[6.5900000000E+03, 2.7622035722E+00, 7.2543082510E+00, 6.1293411882E-02, 5.9471255186E-02, 4.1455225584E-01],
	[6.5950000000E+03, 2.7648072821E+00, 7.2519433414E+00, 6.1435486624E-02, 5.9606050527E-02, 4.1474864456E-01],
	[6.6000000000E+03, 2.7674114701E+00, 7.2495809942E+00, 6.1577782323E-02, 5.9741042898E-02, 4.1494491446E-01],
	[6.6050000000E+03, 2.7700161362E+00, 7.2472212046E+00, 6.1720299153E-02, 5.9876232411E-02, 4.1514106588E-01],
	[6.6100000000E+03, 2.7726212800E+00, 7.2448639680E+00, 6.1863037289E-02, 6.0011619179E-02, 4.1533709916E-01],
	[6.6150000000E+03, 2.7752269013E+00, 7.2425092797E+00, 6.2005996906E-02, 6.0147203316E-02, 4.1553301464E-01],
	[6.6200000000E+03, 2.7778329997E+00, 7.2401571349E+00, 6.2149178179E-02, 6.0282984933E-02, 4.1572881264E-01],
	[6.6250000000E+03, 2.7804395750E+00, 7.2378075290E+00, 6.2292581284E-02, 6.0418964143E-02, 4.1592449351E-01],
	[6.6300000000E+03, 2.7830466269E+00, 7.2354604574E+00, 6.2436206396E-02, 6.0555141060E-02, 4.1612005757E-01],
	[6.6350000000E+03, 2.7856541552E+00, 7.2331159154E+00, 6.2580053689E-02, 6.0691515794E-02, 4.1631550515E-01],
	[6.6400000000E+03, 2.7882621596E+00, 7.2307738984E+00, 6.2724123338E-02, 6.0828088460E-02, 4.1651083660E-01],
	[6.6450000000E+03, 2.7908706397E+00, 7.2284344018E+00, 6.2868415520E-02, 6.0964859168E-02, 4.1670605226E-01],
	[6.6500000000E+03, 2.7934795954E+00, 7.2260974209E+00, 6.3012930408E-02, 6.1101828032E-02, 4.1690115275E-01],
	[6.6550000000E+03, 2.7960890264E+00, 7.2237629512E+00, 6.3157668178E-02, 6.1238995162E-02, 4.1709613846E-01],
	[6.6600000000E+03, 2.7986989323E+00, 7.2214309881E+00, 6.3302629005E-02, 6.1376360671E-02, 4.1729100969E-01],
	[6.6650000000E+03, 2.8013093130E+00, 7.2191015271E+00, 6.3447813065E-02, 6.1513924670E-02, 4.1748576676E-01],
	[6.6700000000E+03, 2.8039281358E+00, 7.2168178658E+00, 6.3593220531E-02, 6.1651694284E-02, 4.1768041000E-01],
	[6.6750000000E+03, 2.8065477243E+00, 7.2145381720E+00, 6.3738851580E-02, 6.1789662913E-02, 4.1787493973E-01],
	[6.6800000000E+03, 2.8091677959E+00, 7.2122609044E+00, 6.3884706387E-02, 6.1927830421E-02, 4.1806935626E-01],
	[6.6850000000E+03, 2.8117883504E+00, 7.2099860588E+00, 6.4030785126E-02, 6.2066196921E-02, 4.1826365991E-01],
	[6.6900000000E+03, 2.8144093875E+00, 7.2077136307E+00, 6.4177087973E-02, 6.2204762522E-02, 4.1845785099E-01],
	[6.6950000000E+03, 2.8170309068E+00, 7.2054436158E+00, 6.4323615103E-02, 6.2343527338E-02, 4.1865192982E-01],
	[6.7000000000E+03, 2.8196529082E+00, 7.2031760096E+00, 6.4470366690E-02, 6.2482491478E-02, 4.1884589671E-01],
	[6.7050000000E+03, 2.8222753913E+00, 7.2009108079E+00, 6.4617342911E-02, 6.2621655054E-02, 4.1903975198E-01],
	[6.7100000000E+03, 2.8248983559E+00, 7.1986480064E+00, 6.4764543941E-02, 6.2761018177E-02, 4.1923349594E-01],
	[6.7150000000E+03, 2.8275218018E+00, 7.1963876005E+00, 6.4911969954E-02, 6.2900580957E-02, 4.1942712890E-01],
	[6.7200000000E+03, 2.8301457285E+00, 7.1941295862E+00, 6.5059621125E-02, 6.3040343506E-02, 4.1962065117E-01],
	[6.7250000000E+03, 2.8327701360E+00, 7.1918739590E+00, 6.5207497631E-02, 6.3180305934E-02, 4.1981406306E-01],
	[6.7300000000E+03, 2.8353950238E+00, 7.1896207147E+00, 6.5355599645E-02, 6.3320468351E-02, 4.2000736489E-01],
	[6.7350000000E+03, 2.8380203918E+00, 7.1873698489E+00, 6.5503927344E-02, 6.3460830868E-02, 4.2020055695E-01],
	[6.7400000000E+03, 2.8406462397E+00, 7.1851213574E+00, 6.5652480902E-02, 6.3601393595E-02, 4.2039363957E-01],
	[6.7450000000E+03, 2.8432725671E+00, 7.1828752360E+00, 6.5801260494E-02, 6.3742156642E-02, 4.2058661304E-01],
	[6.7500000000E+03, 2.8458993739E+00, 7.1806314804E+00, 6.5950266297E-02, 6.3883120120E-02, 4.2077947767E-01],
	[6.7550000000E+03, 2.8485266598E+00, 7.1783900863E+00, 6.6099498484E-02, 6.4024284137E-02, 4.2097223377E-01],
	[6.7600000000E+03, 2.8511544244E+00, 7.1761510495E+00, 6.6248957231E-02, 6.4165648804E-02, 4.2116488164E-01],
	[6.7650000000E+03, 2.8537826676E+00, 7.1739143658E+00, 6.6398642714E-02, 6.4307214231E-02, 4.2135742159E-01],
	[6.7700000000E+03, 2.8564113890E+00, 7.1716800310E+00, 6.6548555107E-02, 6.4448980527E-02, 4.2154985392E-01],
	[6.7750000000E+03, 2.8590445686E+00, 7.1694697452E+00, 6.6698694586E-02, 6.4590951595E-02, 4.2174217892E-01],
	[6.7800000000E+03, 2.8616821225E+00, 7.1672829698E+00, 6.6849061325E-02, 6.4733127499E-02, 4.2193439692E-01],
	[6.7850000000E+03, 2.8643201626E+00, 7.1650984728E+00, 6.6999655501E-02, 6.4875504656E-02, 4.2212650820E-01],
	[6.7900000000E+03, 2.8669586885E+00, 7.1629162501E+00, 6.7150477289E-02, 6.5018083174E-02, 4.2231851306E-01],
	[6.7950000000E+03, 2.8695977001E+00, 7.1607362976E+00, 6.7301526863E-02, 6.5160863164E-02, 4.2251041181E-01],
	[6.8000000000E+03, 2.8722371970E+00, 7.1585586113E+00, 6.7452804398E-02, 6.5303844734E-02, 4.2270220474E-01],
	[6.8050000000E+03, 2.8748771790E+00, 7.1563831873E+00, 6.7604310071E-02, 6.5447027994E-02, 4.2289389216E-01],
	[6.8100000000E+03, 2.8775176458E+00, 7.1542100213E+00, 6.7756044056E-02, 6.5590413051E-02, 4.2308547436E-01],
	[6.8150000000E+03, 2.8801585971E+00, 7.1520391096E+00, 6.7908006529E-02, 6.5734000015E-02, 4.2327695163E-01],
	[6.8200000000E+03, 2.8828000328E+00, 7.1498704481E+00, 6.8060197664E-02, 6.5877788995E-02, 4.2346832427E-01],
	[6.8250000000E+03, 2.8854419524E+00, 7.1477040327E+00, 6.8212617638E-02, 6.6021780099E-02, 4.2365959258E-01],
	[6.8300000000E+03, 2.8880843558E+00, 7.1455398596E+00, 6.8365266625E-02, 6.6165973435E-02, 4.2385075686E-01],
	[6.8350000000E+03, 2.8907272426E+00, 7.1433779248E+00, 6.8518144800E-02, 6.6310369112E-02, 4.2404181739E-01],
	[6.8400000000E+03, 2.8933706127E+00, 7.1412182243E+00, 6.8671252340E-02, 6.6454967237E-02, 4.2423277447E-01],
	[6.8450000000E+03, 2.8960144657E+00, 7.1390607543E+00, 6.8824589418E-02, 6.6599767920E-02, 4.2442362840E-01],
	[6.8500000000E+03, 2.8986588014E+00, 7.1369055106E+00, 6.8978156211E-02, 6.6744771267E-02, 4.2461437945E-01],
	[6.8550000000E+03, 2.9013036195E+00, 7.1347524895E+00, 6.9131952893E-02, 6.6889977387E-02, 4.2480502794E-01],
	[6.8600000000E+03, 2.9039489197E+00, 7.1326016871E+00, 6.9285979641E-02, 6.7035386387E-02, 4.2499557413E-01],
	[6.8650000000E+03, 2.9065947019E+00, 7.1304530994E+00, 6.9440236628E-02, 6.7180998375E-02, 4.2518601834E-01],
	[6.8700000000E+03, 2.9092409657E+00, 7.1283067225E+00, 6.9594724032E-02, 6.7326813458E-02, 4.2537636084E-01],
	[6.8750000000E+03, 2.9118877108E+00, 7.1261625526E+00, 6.9749442026E-02, 6.7472831745E-02, 4.2556660192E-01],
	[6.8800000000E+03, 2.9145349371E+00, 7.1240205857E+00, 6.9904390786E-02, 6.7619053341E-02, 4.2575674187E-01],
	[6.8850000000E+03, 2.9171878891E+00, 7.1219095600E+00, 7.0059570488E-02, 6.7765483786E-02, 4.2594678098E-01],
	[6.8900000000E+03, 2.9198435742E+00, 7.1198129897E+00, 7.0214981306E-02, 6.7912120130E-02, 4.2613671954E-01],
	[6.8950000000E+03, 2.9224997479E+00, 7.1177185568E+00, 7.0370623416E-02, 6.8058960161E-02, 4.2632655782E-01],
	[6.9000000000E+03, 2.9251564098E+00, 7.1156262577E+00, 7.0526496994E-02, 6.8206003986E-02, 4.2651629612E-01],
	[6.9050000000E+03, 2.9278135596E+00, 7.1135360885E+00, 7.0682602215E-02, 6.8353251713E-02, 4.2670593472E-01],
	[6.9100000000E+03, 2.9304711972E+00, 7.1114480456E+00, 7.0838939253E-02, 6.8500703448E-02, 4.2689547391E-01],
	[6.9150000000E+03, 2.9331293222E+00, 7.1093621253E+00, 7.0995508285E-02, 6.8648359298E-02, 4.2708491396E-01],
	[6.9200000000E+03, 2.9357879343E+00, 7.1072783239E+00, 7.1152309486E-02, 6.8796219369E-02, 4.2727425516E-01],
	[6.9250000000E+03, 2.9384470334E+00, 7.1051966377E+00, 7.1309343030E-02, 6.8944283768E-02, 4.2746349779E-01],
	[6.9300000000E+03, 2.9411066191E+00, 7.1031170630E+00, 7.1466609094E-02, 6.9092552601E-02, 4.2765264214E-01],
	[6.9350000000E+03, 2.9437666912E+00, 7.1010395962E+00, 7.1624107853E-02, 6.9241025973E-02, 4.2784168847E-01],
	[6.9400000000E+03, 2.9464272494E+00, 7.0989642336E+00, 7.1781839482E-02, 6.9389703992E-02, 4.2803063709E-01],
	[6.9450000000E+03, 2.9490882934E+00, 7.0968909716E+00, 7.1939804156E-02, 6.9538586764E-02, 4.2821948825E-01],
	[6.9500000000E+03, 2.9517498231E+00, 7.0948198065E+00, 7.2098002051E-02, 6.9687674393E-02, 4.2840824225E-01],
	[6.9550000000E+03, 2.9544118381E+00, 7.0927507347E+00, 7.2256433343E-02, 6.9836966985E-02, 4.2859689935E-01],
	[6.9600000000E+03, 2.9570743382E+00, 7.0906837527E+00, 7.2415098205E-02, 6.9986464647E-02, 4.2878545984E-01],
	[6.9650000000E+03, 2.9597373231E+00, 7.0886188567E+00, 7.2573996815E-02, 7.0136167484E-02, 4.2897392400E-01],
	[6.9700000000E+03, 2.9624007925E+00, 7.0865560432E+00, 7.2733129347E-02, 7.0286075600E-02, 4.2916229210E-01],
	[6.9750000000E+03, 2.9650647463E+00, 7.0844953086E+00, 7.2892495977E-02, 7.0436189101E-02, 4.2935056441E-01],
	[6.9800000000E+03, 2.9677291841E+00, 7.0824366492E+00, 7.3052096880E-02, 7.0586508093E-02, 4.2953874122E-01],
	[6.9850000000E+03, 2.9703941057E+00, 7.0803800617E+00, 7.3211932231E-02, 7.0737032680E-02, 4.2972682279E-01],
	[6.9900000000E+03, 2.9730595108E+00, 7.0783255423E+00, 7.3372002206E-02, 7.0887762967E-02, 4.2991480940E-01],
	[6.9950000000E+03, 2.9757292728E+00, 7.0762944292E+00, 7.3532306980E-02, 7.1038703417E-02, 4.3010270132E-01],
	[7.0000000000E+03, 2.9784027754E+00, 7.0742832528E+00, 7.3692846729E-02, 7.1189853479E-02, 4.3029049883E-01],
	[7.0050000000E+03, 2.9810767684E+00, 7.0722740835E+00, 7.3855167303E-02, 7.1342651912E-02, 4.3047820220E-01],
	[7.0100000000E+03, 2.9837512517E+00, 7.0702669178E+00, 7.4017728908E-02, 7.1495661521E-02, 4.3066581169E-01],
	[7.0150000000E+03, 2.9864262248E+00, 7.0682617522E+00, 7.4180531728E-02, 7.1648882419E-02, 4.3085332759E-01],
	[7.0200000000E+03, 2.9891016876E+00, 7.0662585834E+00, 7.4343575950E-02, 7.1802314715E-02, 4.3104075016E-01],
	[7.0250000000E+03, 2.9917776398E+00, 7.0642574080E+00, 7.4506861756E-02, 7.1955958521E-02, 4.3122807967E-01],
	[7.0300000000E+03, 2.9944540811E+00, 7.0622582225E+00, 7.4670389333E-02, 7.2109813948E-02, 4.3141531639E-01],
	[7.0350000000E+03, 2.9971310113E+00, 7.0602610236E+00, 7.4834158866E-02, 7.2263881105E-02, 4.3160246059E-01],
	[7.0400000000E+03, 2.9998084301E+00, 7.0582658078E+00, 7.4998170538E-02, 7.2418160104E-02, 4.3178951253E-01],
	[7.0450000000E+03, 3.0024863373E+00, 7.0562725719E+00, 7.5162424536E-02, 7.2572651055E-02, 4.3197647249E-01],
	[7.0500000000E+03, 3.0051647326E+00, 7.0542813123E+00, 7.5326921044E-02, 7.2727354067E-02, 4.3216334073E-01],
	[7.0550000000E+03, 3.0078436158E+00, 7.0522920259E+00, 7.5491660247E-02, 7.2882269252E-02, 4.3235011752E-01],
	[7.0600000000E+03, 3.0105229865E+00, 7.0503047091E+00, 7.5656642330E-02, 7.3037396719E-02, 4.3253680312E-01],
	[7.0650000000E+03, 3.0132028446E+00, 7.0483193587E+00, 7.5821867478E-02, 7.3192736578E-02, 4.3272339780E-01],
	[7.0700000000E+03, 3.0158831897E+00, 7.0463359714E+00, 7.5987335876E-02, 7.3348288938E-02, 4.3290990182E-01],
	[7.0750000000E+03, 3.0185640217E+00, 7.0443545438E+00, 7.6153047708E-02, 7.3504053909E-02, 4.3309631546E-01],
	[7.0800000000E+03, 3.0212453402E+00, 7.0423750726E+00, 7.6319003161E-02, 7.3660031601E-02, 4.3328263896E-01],
	[7.0850000000E+03, 3.0239271451E+00, 7.0403975545E+00, 7.6379625989E-02, 7.3717880657E-02, 4.3346887260E-01],
	[7.0900000000E+03, 3.0266094360E+00, 7.0384219861E+00, 7.6545797001E-02, 7.3874041807E-02, 4.3365501664E-01],
	[7.0950000000E+03, 3.0292922127E+00, 7.0364483642E+00, 7.6712211679E-02, 7.4030415601E-02, 4.3384107133E-01],
	[7.1000000000E+03, 3.0319754750E+00, 7.0344766856E+00, 7.6878870209E-02, 7.4187002148E-02, 4.3402703695E-01],
	[7.1050000000E+03, 3.0346594307E+00, 7.0325080884E+00, 7.7045772774E-02, 7.4343801807E-02, 4.3421291375E-01],
	[7.1100000000E+03, 3.0373505154E+00, 7.0305778084E+00, 7.7212919561E-02, 7.4500822521E-02, 4.3439870199E-01],
	[7.1150000000E+03, 3.0400420921E+00, 7.0286494146E+00, 7.7380310752E-02, 7.4658056371E-02, 4.3458440194E-01],
	[7.1200000000E+03, 3.0427341607E+00, 7.0267229038E+00, 7.7547946533E-02, 7.4815503467E-02, 4.3477001384E-01],
	[7.1250000000E+03, 3.0454267208E+00, 7.0247982730E+00, 7.7715827087E-02, 7.4973163917E-02, 4.3495553797E-01],
	[7.1300000000E+03, 3.0481197723E+00, 7.0228755189E+00, 7.7883952600E-02, 7.5131037829E-02, 4.3514097458E-01],
	[7.1350000000E+03, 3.0508133148E+00, 7.0209546384E+00, 7.8052323256E-02, 7.5289125310E-02, 4.3532632392E-01],
	[7.1400000000E+03, 3.0535073482E+00, 7.0190356284E+00, 7.8220939239E-02, 7.5447426470E-02, 4.3551158626E-01],
	[7.1450000000E+03, 3.0562018721E+00, 7.0171184857E+00, 7.8389800734E-02, 7.5605941415E-02, 4.3569676186E-01],
	[7.1500000000E+03, 3.0588968864E+00, 7.0152032073E+00, 7.8558907926E-02, 7.5764670254E-02, 4.3588185095E-01],
	[7.1550000000E+03, 3.0615923906E+00, 7.0132897899E+00, 7.8728260998E-02, 7.5923613093E-02, 4.3606685382E-01],
	[7.1600000000E+03, 3.0642883847E+00, 7.0113782306E+00, 7.8897860136E-02, 7.6082770041E-02, 4.3625177070E-01],
	[7.1650000000E+03, 3.0669848684E+00, 7.0094685261E+00, 7.9067705524E-02, 7.6242141203E-02, 4.3643660186E-01],
	[7.1700000000E+03, 3.0696818413E+00, 7.0075606735E+00, 7.9237797347E-02, 7.6401726689E-02, 4.3662134755E-01],
	[7.1750000000E+03, 3.0723793033E+00, 7.0056546695E+00, 7.9408135789E-02, 7.6561526604E-02, 4.3680600802E-01],
	[7.1800000000E+03, 3.0750772540E+00, 7.0037505112E+00, 7.9578721035E-02, 7.6721541055E-02, 4.3699058352E-01],
	[7.1850000000E+03, 3.0777756933E+00, 7.0018481955E+00, 7.9749553269E-02, 7.6881770150E-02, 4.3717507432E-01],
	[7.1900000000E+03, 3.0804746209E+00, 6.9999477193E+00, 7.9920632676E-02, 7.7042213994E-02, 4.3735948065E-01],
	[7.1950000000E+03, 3.0831740365E+00, 6.9980490795E+00, 8.0091959440E-02, 7.7202872695E-02, 4.3754380278E-01],
	[7.2000000000E+03, 3.0858739399E+00, 6.9961522731E+00, 8.0263533747E-02, 7.7363746358E-02, 4.3772804096E-01],
	[7.2050000000E+03, 3.0885743308E+00, 6.9942572971E+00, 8.0435355780E-02, 7.7524835090E-02, 4.3791219543E-01],
	[7.2100000000E+03, 3.0912752091E+00, 6.9923641484E+00, 8.0607425725E-02, 7.7686138997E-02, 4.3809626645E-01],
	[7.2150000000E+03, 3.0939765743E+00, 6.9904728240E+00, 8.0779743766E-02, 7.7847658185E-02, 4.3828025426E-01],
	[7.2200000000E+03, 3.0966794476E+00, 6.9885888733E+00, 8.0952310087E-02, 7.8009394100E-02, 4.3846415912E-01],
	[7.2250000000E+03, 3.0993883902E+00, 6.9867370479E+00, 8.1125124874E-02, 7.8171352862E-02, 4.3864798128E-01],
	[7.2300000000E+03, 3.1020978261E+00, 6.9848869938E+00, 8.1298188311E-02, 7.8333527284E-02, 4.3883172098E-01],
	[7.2350000000E+03, 3.1048077550E+00, 6.9830387080E+00, 8.1471500582E-02, 7.8495917471E-02, 4.3901537847E-01],
	[7.2400000000E+03, 3.1075181766E+00, 6.9811921877E+00, 8.1645061873E-02, 7.8658523528E-02, 4.3919895400E-01],
	[7.2450000000E+03, 3.1102290907E+00, 6.9793474299E+00, 8.1818872367E-02, 7.8821345561E-02, 4.3938244782E-01],
	[7.2500000000E+03, 3.1129404970E+00, 6.9775044317E+00, 8.1992932250E-02, 7.8984383676E-02, 4.3956586018E-01],
	[7.2550000000E+03, 3.1156523954E+00, 6.9756631904E+00, 8.2167241707E-02, 7.9147637977E-02, 4.3974919132E-01],
	[7.2600000000E+03, 3.1183647854E+00, 6.9738237029E+00, 8.2341800922E-02, 7.9311108570E-02, 4.3993244148E-01],
	[7.2650000000E+03, 3.1210776670E+00, 6.9719859664E+00, 8.2516610079E-02, 7.9474795560E-02, 4.4011561091E-01],
	[7.2700000000E+03, 3.1237910398E+00, 6.9701499781E+00, 8.2691669364E-02, 7.9638699051E-02, 4.4029869987E-01],
	[7.2750000000E+03, 3.1265049036E+00, 6.9683157350E+00, 8.2866978961E-02, 7.9802819148E-02, 4.4048170858E-01],
	[7.2800000000E+03, 3.1292192581E+00, 6.9664832343E+00, 8.3042539055E-02, 7.9967155956E-02, 4.4066463731E-01],
	[7.2850000000E+03, 3.1319341032E+00, 6.9646524732E+00, 8.3218349831E-02, 8.0131709580E-02, 4.4084748635E-01],
	[7.2900000000E+03, 3.1346494385E+00, 6.9628234488E+00, 8.3394411473E-02, 8.0296480122E-02, 4.4103025589E-01],
	[7.2950000000E+03, 3.1373652637E+00, 6.9609961583E+00, 8.3570724167E-02, 8.0461467688E-02, 4.4121294615E-01],
	[7.3000000000E+03, 3.1400815788E+00, 6.9591705988E+00, 8.3747288096E-02, 8.0626672382E-02, 4.4139555735E-01],
	[7.3050000000E+03, 3.1427983833E+00, 6.9573467676E+00, 8.3924103447E-02, 8.0792094307E-02, 4.4157808970E-01],
	[7.3100000000E+03, 3.1455156771E+00, 6.9555246618E+00, 8.4101170402E-02, 8.0957733568E-02, 4.4176054339E-01],
	[7.3150000000E+03, 3.1482334599E+00, 6.9537042785E+00, 8.4278489148E-02, 8.1123590267E-02, 4.4194291865E-01],
	[7.3200000000E+03, 3.1509517314E+00, 6.9518856151E+00, 8.4456059870E-02, 8.1289664509E-02, 4.4212521568E-01],
	[7.3250000000E+03, 3.1536704915E+00, 6.9500686687E+00, 8.4633882751E-02, 8.1455956397E-02, 4.4230743468E-01],
	[7.3300000000E+03, 3.1563897399E+00, 6.9482534364E+00, 8.4811957977E-02, 8.1622466034E-02, 4.4248957588E-01],
	[7.3350000000E+03, 3.1591094763E+00, 6.9464399156E+00, 8.4990285732E-02, 8.1789193523E-02, 4.4267163946E-01],
	[7.3400000000E+03, 3.1618354857E+00, 6.9446593156E+00, 8.5168866202E-02, 8.1956147201E-02, 4.4285362565E-01],
	[7.3450000000E+03, 3.1645625557E+00, 6.9428834396E+00, 8.5347699571E-02, 8.2123319804E-02, 4.4303553465E-01],
	[7.3500000000E+03, 3.1672901197E+00, 6.9411092257E+00, 8.5526786025E-02, 8.2290710630E-02, 4.4321736667E-01],
	[7.3550000000E+03, 3.1700181773E+00, 6.9393366713E+00, 8.5706125747E-02, 8.2458319783E-02, 4.4339912190E-01],
	[7.3600000000E+03, 3.1727467283E+00, 6.9375657737E+00, 8.5885718923E-02, 8.2626147366E-02, 4.4358080056E-01],
	[7.3650000000E+03, 3.1754757724E+00, 6.9357965302E+00, 8.6065565738E-02, 8.2794193480E-02, 4.4376240286E-01],
	[7.3700000000E+03, 3.1782053095E+00, 6.9340289382E+00, 8.6245666376E-02, 8.2962458229E-02, 4.4394392899E-01],
	[7.3750000000E+03, 3.1809353393E+00, 6.9322629949E+00, 8.6426021023E-02, 8.3130941714E-02, 4.4412537917E-01],
	[7.3800000000E+03, 3.1836658614E+00, 6.9304986978E+00, 8.6606629863E-02, 8.3299644038E-02, 4.4430675359E-01],
	[7.3850000000E+03, 3.1863968758E+00, 6.9287360441E+00, 8.6787493082E-02, 8.3468565304E-02, 4.4448805246E-01],
	[7.3900000000E+03, 3.1891283821E+00, 6.9269750313E+00, 8.6968610864E-02, 8.3637705612E-02, 4.4466927599E-01],
	[7.3950000000E+03, 3.1918603801E+00, 6.9252156567E+00, 8.7149983393E-02, 8.3807065065E-02, 4.4485042437E-01],
	[7.4000000000E+03, 3.1945928696E+00, 6.9234579177E+00, 8.7331610856E-02, 8.3976643764E-02, 4.4503149781E-01],
	[7.4050000000E+03, 3.1973258502E+00, 6.9217018116E+00, 8.7513493437E-02, 8.4146441811E-02, 4.4521249652E-01],
	[7.4100000000E+03, 3.2000593219E+00, 6.9199473359E+00, 8.7695631321E-02, 8.4316459308E-02, 4.4539342069E-01],
	[7.4150000000E+03, 3.2027932842E+00, 6.9181944879E+00, 8.7878024692E-02, 8.4486696355E-02, 4.4557427052E-01],
	[7.4200000000E+03, 3.2055277370E+00, 6.9164432650E+00, 8.8060673736E-02, 8.4657153054E-02, 4.4575504623E-01],
	[7.4250000000E+03, 3.2082626801E+00, 6.9146936646E+00, 8.8243578639E-02, 8.4827829505E-02, 4.4593574800E-01],
	[7.4300000000E+03, 3.2109981132E+00, 6.9129456842E+00, 8.8426739583E-02, 8.4998725810E-02, 4.4611637605E-01],
	[7.4350000000E+03, 3.2137340360E+00, 6.9111993211E+00, 8.8610156756E-02, 8.5169842069E-02, 4.4629693056E-01],
	[7.4400000000E+03, 3.2164704483E+00, 6.9094545727E+00, 8.8793830341E-02, 8.5341178383E-02, 4.4647741174E-01],
	[7.4450000000E+03, 3.2192073499E+00, 6.9077114365E+00, 8.8977760524E-02, 8.5512734853E-02, 4.4665781980E-01],
	[7.4500000000E+03, 3.2219447405E+00, 6.9059699099E+00, 8.9161947490E-02, 8.5684511578E-02, 4.4683815492E-01],
	[7.4550000000E+03, 3.2246844043E+00, 6.9042395714E+00, 8.9346391424E-02, 8.5856511406E-02, 4.4701841732E-01],
	[7.4600000000E+03, 3.2274288737E+00, 6.9025339706E+00, 8.9531092510E-02, 8.6028738370E-02, 4.4719860718E-01],
	[7.4650000000E+03, 3.2301738377E+00, 6.9008299336E+00, 8.9716050934E-02, 8.6201185954E-02, 4.4737872470E-01],
	[7.4700000000E+03, 3.2329192961E+00, 6.8991274578E+00, 8.9901266881E-02, 8.6373854258E-02, 4.4755877009E-01],
	[7.4750000000E+03, 3.2356652486E+00, 6.8974265407E+00, 9.0086740536E-02, 8.6546743383E-02, 4.4773874354E-01],
	[7.4800000000E+03, 3.2384116949E+00, 6.8957271800E+00, 9.0272472084E-02, 8.6719853428E-02, 4.4791864525E-01],
	[7.4850000000E+03, 3.2411586348E+00, 6.8940293730E+00, 9.0458461710E-02, 8.6893184492E-02, 4.4809847541E-01],
	[7.4900000000E+03, 3.2439060681E+00, 6.8923331174E+00, 9.0644709598E-02, 8.7066736676E-02, 4.4827823423E-01],
	[7.4950000000E+03, 3.2466539945E+00, 6.8906384107E+00, 9.0831215935E-02, 8.7240510079E-02, 4.4845792190E-01],
	[7.5000000000E+03, 3.2494024138E+00, 6.8889452505E+00, 9.1017980906E-02, 8.7414504799E-02, 4.4863753861E-01],
	[7.5050000000E+03, 3.2521513258E+00, 6.8872536343E+00, 9.1205004694E-02, 8.7588720937E-02, 4.4881708456E-01],
	[7.5100000000E+03, 3.2549007301E+00, 6.8855635597E+00, 9.1392287486E-02, 8.7763158590E-02, 4.4899655995E-01],
	[7.5150000000E+03, 3.2576506267E+00, 6.8838750242E+00, 9.1579829467E-02, 8.7937817859E-02, 4.4917596497E-01],
	[7.5200000000E+03, 3.2604010151E+00, 6.8821880255E+00, 9.1767630821E-02, 8.8112698841E-02, 4.4935529982E-01],
	[7.5250000000E+03, 3.2631518953E+00, 6.8805025611E+00, 9.1955691734E-02, 8.8287801635E-02, 4.4953456469E-01],
	[7.5300000000E+03, 3.2659032669E+00, 6.8788186286E+00, 9.2144012390E-02, 8.8463126340E-02, 4.4971375977E-01],
	[7.5350000000E+03, 3.2686551297E+00, 6.8771362256E+00, 9.2332592976E-02, 8.8638673054E-02, 4.4989288527E-01],
	[7.5400000000E+03, 3.2714074835E+00, 6.8754553497E+00, 9.2521433676E-02, 8.8814441875E-02, 4.5007194136E-01],
	[7.5450000000E+03, 3.2741603281E+00, 6.8737759984E+00, 9.2710534675E-02, 8.8990432901E-02, 4.5025092825E-01],
	[7.5500000000E+03, 3.2769136631E+00, 6.8720981695E+00, 9.2899896159E-02, 8.9166646230E-02, 4.5042984613E-01],
	[7.5550000000E+03, 3.2796674884E+00, 6.8704218605E+00, 9.3089518312E-02, 8.9343081961E-02, 4.5060869519E-01],
	[7.5600000000E+03, 3.2824218037E+00, 6.8687470690E+00, 9.3279401321E-02, 8.9519740189E-02, 4.5078747563E-01],
	[7.5650000000E+03, 3.2851766088E+00, 6.8670737927E+00, 9.3469545369E-02, 8.9696621014E-02, 4.5096618763E-01],
	[7.5700000000E+03, 3.2879319035E+00, 6.8654020292E+00, 9.3659950643E-02, 8.9873724531E-02, 4.5114483139E-01],
	[7.5750000000E+03, 3.2906894070E+00, 6.8637409726E+00, 9.3850617326E-02, 9.0051053711E-02, 4.5132340709E-01],
	[7.5800000000E+03, 3.2934515268E+00, 6.8621034548E+00, 9.4041545606E-02, 9.0228612704E-02, 4.5150191494E-01],
	[7.5850000000E+03, 3.2962141414E+00, 6.8604674071E+00, 9.4232735666E-02, 9.0406394748E-02, 4.5168035512E-01],
	[7.5900000000E+03, 3.2989772506E+00, 6.8588328272E+00, 9.4424187693E-02, 9.0584399939E-02, 4.5185872782E-01],
	[7.5950000000E+03, 3.3017408540E+00, 6.8571997128E+00, 9.4615901871E-02, 9.0762628375E-02, 4.5203703324E-01],
	[7.6000000000E+03, 3.3045049515E+00, 6.8555680616E+00, 9.4807878385E-02, 9.0941080153E-02, 4.5221527155E-01],
	[7.6050000000E+03, 3.3072695429E+00, 6.8539378714E+00, 9.5000117421E-02, 9.1119755368E-02, 4.5239344296E-01],
	[7.6100000000E+03, 3.3100346279E+00, 6.8523091399E+00, 9.5192619164E-02, 9.1298654118E-02, 4.5257154764E-01],
	[7.6150000000E+03, 3.3128002062E+00, 6.8506818649E+00, 9.5385383799E-02, 9.1477776499E-02, 4.5274958580E-01],
	[7.6200000000E+03, 3.3155662776E+00, 6.8490560440E+00, 9.5578411512E-02, 9.1657122608E-02, 4.5292755762E-01],
	[7.6250000000E+03, 3.3183328419E+00, 6.8474316750E+00, 9.5771702488E-02, 9.1836692539E-02, 4.5310546328E-01],
	[7.6300000000E+03, 3.3210998989E+00, 6.8458087557E+00, 9.5965256912E-02, 9.2016486391E-02, 4.5328330299E-01],
	[7.6350000000E+03, 3.3238674483E+00, 6.8441872839E+00, 9.6159074969E-02, 9.2196504257E-02, 4.5346107691E-01],
	[7.6400000000E+03, 3.3266354899E+00, 6.8425672572E+00, 9.6353156845E-02, 9.2376746234E-02, 4.5363878525E-01],
	[7.6450000000E+03, 3.3294040234E+00, 6.8409486735E+00, 9.6547502725E-02, 9.2557212418E-02, 4.5381642818E-01],
	[7.6500000000E+03, 3.3321730486E+00, 6.8393315306E+00, 9.6742112794E-02, 9.2737902903E-02, 4.5399400590E-01],
	[7.6550000000E+03, 3.3349425653E+00, 6.8377158262E+00, 9.6936987238E-02, 9.2918817786E-02, 4.5417151860E-01],
	[7.6600000000E+03, 3.3377125733E+00, 6.8361015580E+00, 9.7132126242E-02, 9.3099957161E-02, 4.5434896646E-01],
	[7.6650000000E+03, 3.3404830723E+00, 6.8344887240E+00, 9.7327529992E-02, 9.3281321124E-02, 4.5452634966E-01],
	[7.6700000000E+03, 3.3432540620E+00, 6.8328773218E+00, 9.7523198672E-02, 9.3462909768E-02, 4.5470366839E-01],
	[7.6750000000E+03, 3.3460255423E+00, 6.8312673493E+00, 9.7719132467E-02, 9.3644723190E-02, 4.5488092284E-01],
	[7.6800000000E+03, 3.3487975129E+00, 6.8296588043E+00, 9.7915331565E-02, 9.3826761484E-02, 4.5505811320E-01],
	[7.6850000000E+03, 3.3515699736E+00, 6.8280516846E+00, 9.8111796149E-02, 9.4009024743E-02, 4.5523523964E-01],
	[7.6900000000E+03, 3.3543429241E+00, 6.8264459879E+00, 9.8308526405E-02, 9.4191513063E-02, 4.5541230236E-01],
	[7.6950000000E+03, 3.3571163643E+00, 6.8248417122E+00, 9.8505522519E-02, 9.4374226537E-02, 4.5558930154E-01],
	[7.7000000000E+03, 3.3598953766E+00, 6.8232659643E+00, 9.8702784675E-02, 9.4557174492E-02, 4.5576623736E-01],
	[7.7050000000E+03, 3.3626753887E+00, 6.8216942959E+00, 9.8900313060E-02, 9.4740348772E-02, 4.5594311000E-01],
	[7.7100000000E+03, 3.3654558954E+00, 6.8201240087E+00, 9.9098107859E-02, 9.4923748555E-02, 4.5611991966E-01],
	[7.7150000000E+03, 3.3682368963E+00, 6.8185551006E+00, 9.9296169256E-02, 9.5107373937E-02, 4.5629666652E-01],
	[7.7200000000E+03, 3.3710183913E+00, 6.8169875696E+00, 9.9494497439E-02, 9.5291225010E-02, 4.5647335075E-01],
	[7.7250000000E+03, 3.3738003801E+00, 6.8154214135E+00, 9.9693092591E-02, 9.5475301868E-02, 4.5664997254E-01],
	[7.7300000000E+03, 3.3765828625E+00, 6.8138566302E+00, 9.9891954898E-02, 9.5659604605E-02, 4.5682653208E-01],
	[7.7350000000E+03, 3.3793658383E+00, 6.8122932177E+00, 1.0009108455E-01, 9.5844133314E-02, 4.5700302955E-01],
	[7.7400000000E+03, 3.3821493072E+00, 6.8107311738E+00, 1.0029048172E-01, 9.6028888089E-02, 4.5717946512E-01],
	[7.7450000000E+03, 3.3849332690E+00, 6.8091704965E+00, 1.0049014661E-01, 9.6213869021E-02, 4.5735583899E-01],
	[7.7500000000E+03, 3.3877177235E+00, 6.8076111837E+00, 1.0069007939E-01, 9.6399076206E-02, 4.5753215133E-01],
	[7.7550000000E+03, 3.3905026704E+00, 6.8060532333E+00, 1.0089028026E-01, 9.6584509734E-02, 4.5770840233E-01],
	[7.7600000000E+03, 3.3932881096E+00, 6.8044966432E+00, 1.0109074939E-01, 9.6770169699E-02, 4.5788459217E-01],
	[7.7650000000E+03, 3.3960740407E+00, 6.8029414115E+00, 1.0129148698E-01, 9.6956056193E-02, 4.5806072102E-01],
	[7.7700000000E+03, 3.3988604636E+00, 6.8013875360E+00, 1.0149249321E-01, 9.7142169308E-02, 4.5823678908E-01],
	[7.7750000000E+03, 3.4016473779E+00, 6.7998350147E+00, 1.0169376826E-01, 9.7328509138E-02, 4.5841279651E-01],
	[7.7800000000E+03, 3.4044347836E+00, 6.7982838455E+00, 1.0189531232E-01, 9.7515075773E-02, 4.5858874350E-01],
	[7.7850000000E+03, 3.4072226804E+00, 6.7967340264E+00, 1.0209712558E-01, 9.7701869306E-02, 4.5876463024E-01],
	[7.7900000000E+03, 3.4100110679E+00, 6.7951855553E+00, 1.0229920822E-01, 9.7888889829E-02, 4.5894045689E-01],
	[7.7950000000E+03, 3.4127999461E+00, 6.7936384302E+00, 1.0250156042E-01, 9.8076137433E-02, 4.5911622365E-01],
	[7.8000000000E+03, 3.4155893146E+00, 6.7920926491E+00, 1.0270418238E-01, 9.8263612210E-02, 4.5929193069E-01],
	[7.8050000000E+03, 3.4183791733E+00, 6.7905482100E+00, 1.0290707428E-01, 9.8451314251E-02, 4.5946757819E-01],
	[7.8100000000E+03, 3.4211695219E+00, 6.7890051108E+00, 1.0311023630E-01, 9.8639243647E-02, 4.5964316632E-01],
	[7.8150000000E+03, 3.4239603602E+00, 6.7874633495E+00, 1.0331366862E-01, 9.8827400490E-02, 4.5981869527E-01],
	[7.8200000000E+03, 3.4267523930E+00, 6.7859266862E+00, 1.0351737145E-01, 9.9015786260E-02, 4.5999416522E-01],
	[7.8250000000E+03, 3.4295495402E+00, 6.7844160077E+00, 1.0372134495E-01, 9.9204408808E-02, 4.6016957635E-01],
	[7.8300000000E+03, 3.4323471817E+00, 6.7829066301E+00, 1.0392558932E-01, 9.9393259144E-02, 4.6034492882E-01],
	[7.8350000000E+03, 3.4351453172E+00, 6.7813985515E+00, 1.0413010474E-01, 9.9582337359E-02, 4.6052022283E-01],
	[7.8400000000E+03, 3.4379439466E+00, 6.7798917699E+00, 1.0433489139E-01, 9.9771643543E-02, 4.6069545855E-01],
	[7.8450000000E+03, 3.4407430696E+00, 6.7783862836E+00, 1.0453994947E-01, 9.9961177787E-02, 4.6087063615E-01],
	[7.8500000000E+03, 3.4435426860E+00, 6.7768820904E+00, 1.0474527916E-01, 1.0015094018E-01, 4.6104575582E-01],
	[7.8550000000E+03, 3.4463427955E+00, 6.7753791884E+00, 1.0495088064E-01, 1.0034093082E-01, 4.6122081772E-01],
	[7.8600000000E+03, 3.4491433980E+00, 6.7738775758E+00, 1.0515675410E-01, 1.0053114978E-01, 4.6139582204E-01],
	[7.8650000000E+03, 3.4519444931E+00, 6.7723772506E+00, 1.0536289972E-01, 1.0072159717E-01, 4.6157076894E-01],
	[7.8700000000E+03, 3.4547460808E+00, 6.7708782108E+00, 1.0556931770E-01, 1.0091227306E-01, 4.6174565854E-01],
	[7.8750000000E+03, 3.4575481606E+00, 6.7693804547E+00, 1.0577600821E-01, 1.0110317756E-01, 4.6192049099E-01],
	[7.8800000000E+03, 3.4603507325E+00, 6.7678839802E+00, 1.0598297145E-01, 1.0129431075E-01, 4.6209526642E-01],
	[7.8850000000E+03, 3.4631537962E+00, 6.7663887854E+00, 1.0619020759E-01, 1.0148567271E-01, 4.6226998498E-01],
	[7.8900000000E+03, 3.4659573514E+00, 6.7648948684E+00, 1.0639771682E-01, 1.0167726354E-01, 4.6244464680E-01],
	[7.8950000000E+03, 3.4687613980E+00, 6.7634022274E+00, 1.0660549933E-01, 1.0186908333E-01, 4.6261925202E-01],
	[7.9000000000E+03, 3.4715659357E+00, 6.7619108605E+00, 1.0681355531E-01, 1.0206113217E-01, 4.6279380078E-01],
	[7.9050000000E+03, 3.4743709642E+00, 6.7604207657E+00, 1.0702188494E-01, 1.0225341014E-01, 4.6296829322E-01],
	[7.9100000000E+03, 3.4771764835E+00, 6.7589319411E+00, 1.0723048840E-01, 1.0244591733E-01, 4.6314272949E-01],
	[7.9150000000E+03, 3.4799824932E+00, 6.7574443849E+00, 1.0743936589E-01, 1.0263865384E-01, 4.6331710970E-01],
	[7.9200000000E+03, 3.4827889931E+00, 6.7559580952E+00, 1.0764851758E-01, 1.0283161975E-01, 4.6349143402E-01],
	[7.9250000000E+03, 3.4855959830E+00, 6.7544730702E+00, 1.0785794367E-01, 1.0302481514E-01, 4.6366570256E-01],
	[7.9300000000E+03, 3.4884034626E+00, 6.7529893078E+00, 1.0806764434E-01, 1.0321824012E-01, 4.6383991548E-01],
	[7.9350000000E+03, 3.4912114318E+00, 6.7515068064E+00, 1.0827761977E-01, 1.0341189475E-01, 4.6401407291E-01],
	[7.9400000000E+03, 3.4940198904E+00, 6.7500255639E+00, 1.0848787015E-01, 1.0360577914E-01, 4.6418817498E-01],
	[7.9450000000E+03, 3.4968288380E+00, 6.7485455786E+00, 1.0869839566E-01, 1.0379989337E-01, 4.6436222183E-01],
	[7.9500000000E+03, 3.4996431249E+00, 6.7470927460E+00, 1.0890919650E-01, 1.0399424797E-01, 4.6453621361E-01],
	[7.9550000000E+03, 3.5024581276E+00, 6.7456423252E+00, 1.0912027285E-01, 1.0418883312E-01, 4.6471015044E-01],
	[7.9600000000E+03, 3.5052736236E+00, 6.7441931273E+00, 1.0933162489E-01, 1.0438364845E-01, 4.6488403246E-01],
	[7.9650000000E+03, 3.5080896128E+00, 6.7427451504E+00, 1.0954325281E-01, 1.0457869404E-01, 4.6505785982E-01],
	[7.9700000000E+03, 3.5109060950E+00, 6.7412983928E+00, 1.0975515679E-01, 1.0477396998E-01, 4.6523163265E-01],
	[7.9750000000E+03, 3.5137230699E+00, 6.7398528527E+00, 1.0996733702E-01, 1.0496947635E-01, 4.6540535108E-01],
	[7.9800000000E+03, 3.5165405373E+00, 6.7384085282E+00, 1.1017979370E-01, 1.0516521324E-01, 4.6557901525E-01],
	[7.9850000000E+03, 3.5193584969E+00, 6.7369654177E+00, 1.1039252699E-01, 1.0536118074E-01, 4.6575262529E-01],
	[7.9900000000E+03, 3.5221769486E+00, 6.7355235193E+00, 1.1060553709E-01, 1.0555737894E-01, 4.6592618135E-01],
	[7.9950000000E+03, 3.5249958922E+00, 6.7340828312E+00, 1.1081882419E-01, 1.0575380791E-01, 4.6609968356E-01],
	[8.0000000000E+03, 3.5278153273E+00, 6.7326433518E+00, 1.1103238846E-01, 1.0595046776E-01, 4.6627313205E-01],
	[8.0050000000E+03, 3.5306352539E+00, 6.7312050791E+00, 1.1124738520E-01, 1.0614841020E-01, 4.6644652696E-01],
	[8.0100000000E+03, 3.5334556716E+00, 6.7297680115E+00, 1.1146266325E-01, 1.0634658680E-01, 4.6661986842E-01],
	[8.0150000000E+03, 3.5362765803E+00, 6.7283321471E+00, 1.1167822279E-01, 1.0654499767E-01, 4.6679315658E-01],
	[8.0200000000E+03, 3.5390979796E+00, 6.7268974843E+00, 1.1189406401E-01, 1.0674364289E-01, 4.6696639156E-01],
	[8.0250000000E+03, 3.5419198695E+00, 6.7254640213E+00, 1.1211018711E-01, 1.0694252254E-01, 4.6713957350E-01],
	[8.0300000000E+03, 3.5447422497E+00, 6.7240317562E+00, 1.1232659228E-01, 1.0714163672E-01, 4.6731270253E-01],
	[8.0350000000E+03, 3.5475651199E+00, 6.7226006875E+00, 1.1254327971E-01, 1.0734098551E-01, 4.6748577879E-01],
	[8.0400000000E+03, 3.5503884800E+00, 6.7211708133E+00, 1.1276024959E-01, 1.0754056900E-01, 4.6765880242E-01],
	[8.0450000000E+03, 3.5532123297E+00, 6.7197421319E+00, 1.1297750211E-01, 1.0774038729E-01, 4.6783177354E-01],
	[8.0500000000E+03, 3.5560366689E+00, 6.7183146415E+00, 1.1319503746E-01, 1.0794044045E-01, 4.6800469229E-01],
	[8.0550000000E+03, 3.5588614972E+00, 6.7168883405E+00, 1.1341285585E-01, 1.0814072858E-01, 4.6817755882E-01],
	[8.0600000000E+03, 3.5616868144E+00, 6.7154632270E+00, 1.1363095744E-01, 1.0834125177E-01, 4.6835037324E-01],
	[8.0650000000E+03, 3.5645126204E+00, 6.7140392995E+00, 1.1384934245E-01, 1.0854201009E-01, 4.6852313569E-01],
	[8.0700000000E+03, 3.5673389150E+00, 6.7126165561E+00, 1.1406801106E-01, 1.0874300365E-01, 4.6869584631E-01],
	[8.0750000000E+03, 3.5701675282E+00, 6.7112046837E+00, 1.1428696346E-01, 1.0894423679E-01, 4.6886850523E-01],
	[8.0800000000E+03, 3.5729996866E+00, 6.7098101387E+00, 1.1450619984E-01, 1.0914571248E-01, 4.6904111259E-01],
	[8.0850000000E+03, 3.5758323377E+00, 6.7084167458E+00, 1.1472572039E-01, 1.0934742373E-01, 4.6921366851E-01],
	[8.0900000000E+03, 3.5786654811E+00, 6.7070245036E+00, 1.1494552531E-01, 1.0954937064E-01, 4.6938617313E-01],
	[8.0950000000E+03, 3.5814991166E+00, 6.7056334102E+00, 1.1516561479E-01, 1.0975155329E-01, 4.6955862659E-01],
	[8.1000000000E+03, 3.5843332441E+00, 6.7042434640E+00, 1.1538598901E-01, 1.0995397176E-01, 4.6973102901E-01],
	[8.1050000000E+03, 3.5871678633E+00, 6.7028546634E+00, 1.1560664818E-01, 1.1015662614E-01, 4.6990338052E-01],
	[8.1100000000E+03, 3.5900029740E+00, 6.7014670067E+00, 1.1582759248E-01, 1.1035951653E-01, 4.7007568127E-01],
	[8.1150000000E+03, 3.5928385760E+00, 6.7000804923E+00, 1.1604882210E-01, 1.1056264300E-01, 4.7024793138E-01],
	[8.1200000000E+03, 3.5956746690E+00, 6.6986951185E+00, 1.1627033724E-01, 1.1076600564E-01, 4.7042013099E-01],
	[8.1250000000E+03, 3.5985112529E+00, 6.6973108837E+00, 1.1649213808E-01, 1.1096960454E-01, 4.7059228022E-01],
	[8.1300000000E+03, 3.6013483275E+00, 6.6959277862E+00, 1.1671422482E-01, 1.1117343979E-01, 4.7076437922E-01],
	[8.1350000000E+03, 3.6041858924E+00, 6.6945458245E+00, 1.1693659765E-01, 1.1137751146E-01, 4.7093642810E-01],
	[8.1400000000E+03, 3.6070239475E+00, 6.6931649969E+00, 1.1715925676E-01, 1.1158181965E-01, 4.7110842701E-01],
	[8.1450000000E+03, 3.6098624926E+00, 6.6917853017E+00, 1.1738220234E-01, 1.1178636444E-01, 4.7128037607E-01],
	[8.1500000000E+03, 3.6127015275E+00, 6.6904067373E+00, 1.1760543459E-01, 1.1199114592E-01, 4.7145227541E-01],
	[8.1550000000E+03, 3.6155410519E+00, 6.6890293022E+00, 1.1782895370E-01, 1.1219616417E-01, 4.7162412517E-01],
	[8.1600000000E+03, 3.6183810656E+00, 6.6876529947E+00, 1.1805275985E-01, 1.1240141928E-01, 4.7179592548E-01],
	[8.1650000000E+03, 3.6212215685E+00, 6.6862778132E+00, 1.1827685324E-01, 1.1260691133E-01, 4.7196767647E-01],
	[8.1700000000E+03, 3.6240625603E+00, 6.6849037561E+00, 1.1850123406E-01, 1.1281264041E-01, 4.7213937827E-01],
	[8.1750000000E+03, 3.6269040407E+00, 6.6835308217E+00, 1.1872590251E-01, 1.1301860659E-01, 4.7231103101E-01],
	[8.1800000000E+03, 3.6297460096E+00, 6.6821590085E+00, 1.1895085877E-01, 1.1322480998E-01, 4.7248263482E-01],
	[8.1850000000E+03, 3.6325884668E+00, 6.6807883149E+00, 1.1917610303E-01, 1.1343125064E-01, 4.7265418983E-01],
	[8.1900000000E+03, 3.6354314120E+00, 6.6794187392E+00, 1.1940163549E-01, 1.1363792867E-01, 4.7282569617E-01],
	[8.1950000000E+03, 3.6382748450E+00, 6.6780502800E+00, 1.1962745634E-01, 1.1384484415E-01, 4.7299715398E-01],
	[8.2000000000E+03, 3.6411187656E+00, 6.6766829355E+00, 1.1985356578E-01, 1.1405199716E-01, 4.7316856338E-01],
	[8.2050000000E+03, 3.6439649879E+00, 6.6753261259E+00, 1.2007996398E-01, 1.1425939233E-01, 4.7333992450E-01],
	[8.2100000000E+03, 3.6468146422E+00, 6.6739856868E+00, 1.2030665115E-01, 1.1446703262E-01, 4.7351123747E-01],
	[8.2150000000E+03, 3.6496647880E+00, 6.6726463328E+00, 1.2053362748E-01, 1.1467491077E-01, 4.7368250242E-01],
	[8.2200000000E+03, 3.6525154250E+00, 6.6713080622E+00, 1.2076089315E-01, 1.1488302687E-01, 4.7385371949E-01],
	[8.2250000000E+03, 3.6553665531E+00, 6.6699708736E+00, 1.2098844836E-01, 1.1509138098E-01, 4.7402488880E-01],
	[8.2300000000E+03, 3.6582181721E+00, 6.6686347654E+00, 1.2121629331E-01, 1.1529997321E-01, 4.7419601047E-01],
	[8.2350000000E+03, 3.6610702817E+00, 6.6672997361E+00, 1.2144442818E-01, 1.1550880363E-01, 4.7436708465E-01],
	[8.2400000000E+03, 3.6639228818E+00, 6.6659657841E+00, 1.2167285316E-01, 1.1571787232E-01, 4.7453811145E-01],
	[8.2450000000E+03, 3.6667759721E+00, 6.6646329080E+00, 1.2190156845E-01, 1.1592717937E-01, 4.7470909102E-01],
	[8.2500000000E+03, 3.6696295524E+00, 6.6633011062E+00, 1.2213057424E-01, 1.1613672486E-01, 4.7488002347E-01],
	[8.2550000000E+03, 3.6724836224E+00, 6.6619703772E+00, 1.2235987071E-01, 1.1634650887E-01, 4.7505090893E-01],
	[8.2600000000E+03, 3.6753381821E+00, 6.6606407195E+00, 1.2258945807E-01, 1.1655653149E-01, 4.7522174754E-01],
	[8.2650000000E+03, 3.6781932311E+00, 6.6593121316E+00, 1.2281933651E-01, 1.1676679280E-01, 4.7539253943E-01],
	[8.2700000000E+03, 3.6810487693E+00, 6.6579846119E+00, 1.2304950621E-01, 1.1697729288E-01, 4.7556328471E-01],
	[8.2750000000E+03, 3.6839047964E+00, 6.6566581590E+00, 1.2327996736E-01, 1.1718803180E-01, 4.7573398352E-01],
	[8.2800000000E+03, 3.6867613123E+00, 6.6553327714E+00, 1.2351072017E-01, 1.1739900967E-01, 4.7590463599E-01],
	[8.2850000000E+03, 3.6896183167E+00, 6.6540084475E+00, 1.2374176482E-01, 1.1761022654E-01, 4.7607524225E-01],
	[8.2900000000E+03, 3.6924758094E+00, 6.6526851859E+00, 1.2397310150E-01, 1.1782168251E-01, 4.7624580242E-01],
	[8.2950000000E+03, 3.6953337902E+00, 6.6513629851E+00, 1.2420473041E-01, 1.1803337766E-01, 4.7641631664E-01],
	[8.3000000000E+03, 3.6981922588E+00, 6.6500418436E+00, 1.2443665173E-01, 1.1824531207E-01, 4.7658678502E-01],
	[8.3050000000E+03, 3.7010512152E+00, 6.6487217599E+00, 1.2466886566E-01, 1.1845748582E-01, 4.7675720770E-01],
	[8.3100000000E+03, 3.7039106590E+00, 6.6474027325E+00, 1.2490137240E-01, 1.1866989898E-01, 4.7692758481E-01],
	[8.3150000000E+03, 3.7067705901E+00, 6.6460847600E+00, 1.2513417212E-01, 1.1888255165E-01, 4.7709791646E-01],
	[8.3200000000E+03, 3.7096310082E+00, 6.6447678408E+00, 1.2536726503E-01, 1.1909544390E-01, 4.7726820280E-01],
	[8.3250000000E+03, 3.7124919132E+00, 6.6434519735E+00, 1.2560065132E-01, 1.1930857581E-01, 4.7743844395E-01],
	[8.3300000000E+03, 3.7153533047E+00, 6.6421371567E+00, 1.2583433117E-01, 1.1952194747E-01, 4.7760864002E-01],
	[8.3350000000E+03, 3.7182151827E+00, 6.6408233888E+00, 1.2606830479E-01, 1.1973555894E-01, 4.7777879116E-01],
	[8.3400000000E+03, 3.7210820365E+00, 6.6395335313E+00, 1.2630257236E-01, 1.1994942245E-01, 4.7794889749E-01],
	[8.3450000000E+03, 3.7239495206E+00, 6.6382454100E+00, 1.2653713407E-01, 1.2016352639E-01, 4.7811895913E-01],
	[8.3500000000E+03, 3.7268174948E+00, 6.6369583099E+00, 1.2677199012E-01, 1.2037787047E-01, 4.7828897622E-01],
	[8.3550000000E+03, 3.7296859589E+00, 6.6356722296E+00, 1.2700714069E-01, 1.2059245477E-01, 4.7845894887E-01],
	[8.3600000000E+03, 3.7325549128E+00, 6.6343871678E+00, 1.2724258599E-01, 1.2080727936E-01, 4.7862887722E-01],
	[8.3650000000E+03, 3.7354243562E+00, 6.6331031229E+00, 1.2747832620E-01, 1.2102234434E-01, 4.7879876138E-01],
	[8.3700000000E+03, 3.7382942889E+00, 6.6318200936E+00, 1.2771436151E-01, 1.2123764977E-01, 4.7896860150E-01],
	[8.3750000000E+03, 3.7411647106E+00, 6.6305380785E+00, 1.2795069212E-01, 1.2145319573E-01, 4.7913839769E-01],
	[8.3800000000E+03, 3.7440356213E+00, 6.6292570762E+00, 1.2818731822E-01, 1.2166898232E-01, 4.7930815008E-01],
	[8.3850000000E+03, 3.7469070206E+00, 6.6279770852E+00, 1.2842424000E-01, 1.2188500959E-01, 4.7947785879E-01],
	[8.3900000000E+03, 3.7497789084E+00, 6.6266981041E+00, 1.2866145765E-01, 1.2210127764E-01, 4.7964752396E-01],
	[8.3950000000E+03, 3.7526512845E+00, 6.6254201316E+00, 1.2889897136E-01, 1.2231778654E-01, 4.7981714570E-01],
	[8.4000000000E+03, 3.7555241486E+00, 6.6241431663E+00, 1.2913678134E-01, 1.2253453637E-01, 4.7998672415E-01],
	[8.4050000000E+03, 3.7583975006E+00, 6.6228672068E+00, 1.2937488776E-01, 1.2275152720E-01, 4.8015625941E-01],
	[8.4100000000E+03, 3.7612713402E+00, 6.6215922516E+00, 1.2961329082E-01, 1.2296875912E-01, 4.8032575157E-01],
	[8.4150000000E+03, 3.7641456673E+00, 6.6203182994E+00, 1.2985199071E-01, 1.2318623221E-01, 4.8049520071E-01],
	[8.4200000000E+03, 3.7670204815E+00, 6.6190453489E+00, 1.3009098763E-01, 1.2340394653E-01, 4.8066460693E-01],
	[8.4250000000E+03, 3.7698957828E+00, 6.6177733985E+00, 1.3033028177E-01, 1.2362190217E-01, 4.8083397030E-01],
	[8.4300000000E+03, 3.7727715709E+00, 6.6165024471E+00, 1.3056987331E-01, 1.2384009921E-01, 4.8100329094E-01],
	[8.4350000000E+03, 3.7756478456E+00, 6.6152324930E+00, 1.3080976246E-01, 1.2405853772E-01, 4.8117256892E-01],
	[8.4400000000E+03, 3.7785246067E+00, 6.6139635351E+00, 1.3104994940E-01, 1.2427721778E-01, 4.8134180434E-01],
	[8.4450000000E+03, 3.7814018539E+00, 6.6126955720E+00, 1.3129043433E-01, 1.2449613947E-01, 4.8151099729E-01],
	[8.4500000000E+03, 3.7842795872E+00, 6.6114286021E+00, 1.3153121743E-01, 1.2471530286E-01, 4.8168014786E-01],
	[8.4550000000E+03, 3.7871578063E+00, 6.6101626243E+00, 1.3177229890E-01, 1.2493470803E-01, 4.8184925615E-01],
	[8.4600000000E+03, 3.7900365109E+00, 6.6088976371E+00, 1.3201367894E-01, 1.2515435506E-01, 4.8201832225E-01],
	[8.4650000000E+03, 3.7929157009E+00, 6.6076336392E+00, 1.3225535773E-01, 1.2537424402E-01, 4.8218734625E-01],
	[8.4700000000E+03, 3.7957959737E+00, 6.6063736192E+00, 1.3249733547E-01, 1.2559437672E-01, 4.8235632823E-01],
	[8.4750000000E+03, 3.7986806352E+00, 6.6051340922E+00, 1.3273961234E-01, 1.2581476288E-01, 4.8252526830E-01],
	[8.4800000000E+03, 3.8015657857E+00, 6.6038955286E+00, 1.3298218855E-01, 1.2603539129E-01, 4.8269416653E-01],
	[8.4850000000E+03, 3.8044514249E+00, 6.6026579272E+00, 1.3322506428E-01, 1.2625626200E-01, 4.8286302304E-01],
	[8.4900000000E+03, 3.8073375527E+00, 6.6014212866E+00, 1.3346829578E-01, 1.2647742545E-01, 4.8303183789E-01],
	[8.4950000000E+03, 3.8102241687E+00, 6.6001856054E+00, 1.3371183072E-01, 1.2669883452E-01, 4.8320061120E-01],
	[8.5000000000E+03, 3.8131112729E+00, 6.5989508824E+00, 1.3395566596E-01, 1.2692048630E-01, 4.8336934304E-01],
	[8.5050000000E+03, 3.8159988649E+00, 6.5977171163E+00, 1.3419980169E-01, 1.2714238086E-01, 4.8353803351E-01],
	[8.5100000000E+03, 3.8188869447E+00, 6.5964843058E+00, 1.3444423812E-01, 1.2736451829E-01, 4.8370668270E-01],
	[8.5150000000E+03, 3.8217755119E+00, 6.5952524495E+00, 1.3468897542E-01, 1.2758689865E-01, 4.8387529070E-01],
	[8.5200000000E+03, 3.8246645665E+00, 6.5940215462E+00, 1.3493401380E-01, 1.2780952202E-01, 4.8404385760E-01],
	[8.5250000000E+03, 3.8275541081E+00, 6.5927915946E+00, 1.3517935344E-01, 1.2803238848E-01, 4.8421238350E-01],
	[8.5300000000E+03, 3.8304441367E+00, 6.5915625934E+00, 1.3542499455E-01, 1.2825549810E-01, 4.8438086847E-01],
	[8.5350000000E+03, 3.8333346519E+00, 6.5903345413E+00, 1.3567093731E-01, 1.2847885095E-01, 4.8454931263E-01],
	[8.5400000000E+03, 3.8362256536E+00, 6.5891074369E+00, 1.3591718191E-01, 1.2870244711E-01, 4.8471771604E-01],
	[8.5450000000E+03, 3.8391171415E+00, 6.5878812791E+00, 1.3616372854E-01, 1.2892628666E-01, 4.8488607881E-01],
	[8.5500000000E+03, 3.8420091156E+00, 6.5866560666E+00, 1.3641057741E-01, 1.2915036967E-01, 4.8505440103E-01],
	[8.5550000000E+03, 3.8449015755E+00, 6.5854317979E+00, 1.3665772870E-01, 1.2937469621E-01, 4.8522268279E-01],
	[8.5600000000E+03, 3.8477945210E+00, 6.5842084720E+00, 1.3690518261E-01, 1.2959926635E-01, 4.8539092417E-01],
	[8.5650000000E+03, 3.8506879521E+00, 6.5829860874E+00, 1.3715293932E-01, 1.2982408017E-01, 4.8555912527E-01],
	[8.5700000000E+03, 3.8535818684E+00, 6.5817646430E+00, 1.3740099903E-01, 1.3004913775E-01, 4.8572728618E-01],
	[8.5750000000E+03, 3.8564762697E+00, 6.5805441375E+00, 1.3764936194E-01, 1.3027443915E-01, 4.8589540698E-01],
	[8.5800000000E+03, 3.8593711560E+00, 6.5793245695E+00, 1.3789802823E-01, 1.3049998446E-01, 4.8606348778E-01],
	[8.5850000000E+03, 3.8622665269E+00, 6.5781059378E+00, 1.3814699810E-01, 1.3072577373E-01, 4.8623152865E-01],
	[8.5900000000E+03, 3.8651623822E+00, 6.5768882412E+00, 1.3839627175E-01, 1.3095180705E-01, 4.8639952969E-01],
	[8.5950000000E+03, 3.8680587218E+00, 6.5756714784E+00, 1.3864584935E-01, 1.3117808448E-01, 4.8656749099E-01],
	[8.6000000000E+03, 3.8709555454E+00, 6.5744556482E+00, 1.3889573112E-01, 1.3140460611E-01, 4.8673541264E-01],
	[8.6050000000E+03, 3.8738528530E+00, 6.5732407492E+00, 1.3914591723E-01, 1.3163137200E-01, 4.8690329473E-01],
	[8.6100000000E+03, 3.8767544199E+00, 6.5720453200E+00, 1.3939640789E-01, 1.3185839406E-01, 4.8707113735E-01],
	[8.6150000000E+03, 3.8796570690E+00, 6.5708537219E+00, 1.3964720328E-01, 1.3208566246E-01, 4.8723894059E-01],
	[8.6200000000E+03, 3.8825602053E+00, 6.5696630310E+00, 1.3989830360E-01, 1.3231317542E-01, 4.8740670454E-01],
	[8.6250000000E+03, 3.8854638286E+00, 6.5684732462E+00, 1.4014970904E-01, 1.3254093302E-01, 4.8757442928E-01],
	[8.6300000000E+03, 3.8883679389E+00, 6.5672843662E+00, 1.4040141979E-01, 1.3276893532E-01, 4.8774211492E-01],
	[8.6350000000E+03, 3.8912725357E+00, 6.5660963898E+00, 1.4065343605E-01, 1.3299718240E-01, 4.8790976153E-01],
	[8.6400000000E+03, 3.8941776191E+00, 6.5649093158E+00, 1.4090575801E-01, 1.3322567432E-01, 4.8807736921E-01],
	[8.6450000000E+03, 3.8970831887E+00, 6.5637231430E+00, 1.4115838587E-01, 1.3345441117E-01, 4.8824493805E-01],
	[8.6500000000E+03, 3.8999892443E+00, 6.5625378702E+00, 1.4141131981E-01, 1.3368339300E-01, 4.8841246814E-01],
	[8.6550000000E+03, 3.9028957858E+00, 6.5613534962E+00, 1.4166456002E-01, 1.3391261990E-01, 4.8857995956E-01],
	[8.6600000000E+03, 3.9058028129E+00, 6.5601700197E+00, 1.4191810671E-01, 1.3414209192E-01, 4.8874741241E-01],
	[8.6650000000E+03, 3.9087103255E+00, 6.5589874396E+00, 1.4217196006E-01, 1.3437180916E-01, 4.8891482677E-01],
	[8.6700000000E+03, 3.9116183233E+00, 6.5578057547E+00, 1.4242612027E-01, 1.3460177166E-01, 4.8908220274E-01],
	[8.6750000000E+03, 3.9145268062E+00, 6.5566249638E+00, 1.4268058752E-01, 1.3483197951E-01, 4.8924954040E-01],
	[8.6800000000E+03, 3.9174357740E+00, 6.5554450657E+00, 1.4293536202E-01, 1.3506243277E-01, 4.8941683985E-01],
	[8.6850000000E+03, 3.9203452264E+00, 6.5542660592E+00, 1.4319044396E-01, 1.3529313152E-01, 4.8958410117E-01],
	[8.6900000000E+03, 3.9232551633E+00, 6.5530879432E+00, 1.4344583352E-01, 1.3552407582E-01, 4.8975132445E-01],
	[8.6950000000E+03, 3.9261655844E+00, 6.5519107164E+00, 1.4370153091E-01, 1.3575526574E-01, 4.8991850978E-01],
	[8.7000000000E+03, 3.9290764896E+00, 6.5507343776E+00, 1.4395753631E-01, 1.3598670136E-01, 4.9008565725E-01],
	[8.7050000000E+03, 3.9319878787E+00, 6.5495589258E+00, 1.4421384991E-01, 1.3621838274E-01, 4.9025276696E-01],
	[8.7100000000E+03, 3.9348997514E+00, 6.5483843596E+00, 1.4447047192E-01, 1.3645030995E-01, 4.9041983898E-01],
	[8.7150000000E+03, 3.9378121076E+00, 6.5472106780E+00, 1.4472740252E-01, 1.3668248306E-01, 4.9058687340E-01],
	[8.7200000000E+03, 3.9407249471E+00, 6.5460378797E+00, 1.4498464190E-01, 1.3691490215E-01, 4.9075387033E-01],
	[8.7250000000E+03, 3.9436382696E+00, 6.5448659636E+00, 1.4524219027E-01, 1.3714756727E-01, 4.9092082984E-01],
	[8.7300000000E+03, 3.9465520751E+00, 6.5436949285E+00, 1.4550004780E-01, 1.3738047850E-01, 4.9108775202E-01],
	[8.7350000000E+03, 3.9494663632E+00, 6.5425247733E+00, 1.4575821470E-01, 1.3761363590E-01, 4.9125463697E-01],
	[8.7400000000E+03, 3.9523811338E+00, 6.5413554968E+00, 1.4601669116E-01, 1.3784703955E-01, 4.9142148476E-01],
	[8.7450000000E+03, 3.9552970476E+00, 6.5401902887E+00, 1.4627547738E-01, 1.3808069174E-01, 4.9158829550E-01],
	[8.7500000000E+03, 3.9582170231E+00, 6.5390432183E+00, 1.4653457353E-01, 1.3831460241E-01, 4.9175506927E-01],
	[8.7550000000E+03, 3.9611374843E+00, 6.5378970043E+00, 1.4679397982E-01, 1.3854875962E-01, 4.9192180615E-01],
	[8.7600000000E+03, 3.9640584311E+00, 6.5367516455E+00, 1.4705369644E-01, 1.3878316343E-01, 4.9208850624E-01],
	[8.7650000000E+03, 3.9669798632E+00, 6.5356071406E+00, 1.4731372359E-01, 1.3901781391E-01, 4.9225516962E-01],
	[8.7700000000E+03, 3.9699017805E+00, 6.5344634887E+00, 1.4757406145E-01, 1.3925271112E-01, 4.9242179639E-01],
	[8.7750000000E+03, 3.9728241827E+00, 6.5333206886E+00, 1.4783471022E-01, 1.3948785513E-01, 4.9258838663E-01],
	[8.7800000000E+03, 3.9757470696E+00, 6.5321787392E+00, 1.4809567010E-01, 1.3972324602E-01, 4.9275494043E-01],
	[8.7850000000E+03, 3.9786704411E+00, 6.5310376393E+00, 1.4835694127E-01, 1.3995888384E-01, 4.9292145787E-01],
	[8.7900000000E+03, 3.9815942969E+00, 6.5298973879E+00, 1.4861852393E-01, 1.4019476867E-01, 4.9308793906E-01],
	[8.7950000000E+03, 3.9845186370E+00, 6.5287579838E+00, 1.4888041827E-01, 1.4043090056E-01, 4.9325438407E-01],
	[8.8000000000E+03, 3.9874434609E+00, 6.5276194259E+00, 1.4914262448E-01, 1.4066727960E-01, 4.9342079299E-01],
	[8.8050000000E+03, 3.9903687687E+00, 6.5264817131E+00, 1.4940514277E-01, 1.4090390584E-01, 4.9358716591E-01],
	[8.8100000000E+03, 3.9932945600E+00, 6.5253448443E+00, 1.4966797331E-01, 1.4114077935E-01, 4.9375350292E-01],
	[8.8150000000E+03, 3.9962208347E+00, 6.5242088184E+00, 1.4993111631E-01, 1.4137790019E-01, 4.9391980411E-01],
	[8.8200000000E+03, 3.9991475925E+00, 6.5230736343E+00, 1.5019457196E-01, 1.4161526844E-01, 4.9408606956E-01],
	[8.8250000000E+03, 4.0020748334E+00, 6.5219392910E+00, 1.5045834045E-01, 1.4185288416E-01, 4.9425229937E-01],
	[8.8300000000E+03, 4.0050025571E+00, 6.5208057872E+00, 1.5072242197E-01, 1.4209074741E-01, 4.9441849362E-01],
	[8.8350000000E+03, 4.0079307633E+00, 6.5196731219E+00, 1.5098681672E-01, 1.4232885826E-01, 4.9458465240E-01],
	[8.8400000000E+03, 4.0108594520E+00, 6.5185412940E+00, 1.5125152489E-01, 1.4256721678E-01, 4.9475077580E-01],
	[8.8450000000E+03, 4.0137886229E+00, 6.5174103024E+00, 1.5151654667E-01, 1.4280582302E-01, 4.9491686391E-01],
	[8.8500000000E+03, 4.0167182758E+00, 6.5162801461E+00, 1.5178188226E-01, 1.4304467706E-01, 4.9508291680E-01],
	[8.8550000000E+03, 4.0196484106E+00, 6.5151508239E+00, 1.5204753185E-01, 1.4328377896E-01, 4.9524893458E-01],
	[8.8600000000E+03, 4.0225790269E+00, 6.5140223347E+00, 1.5231349563E-01, 1.4352312878E-01, 4.9541491733E-01],
	[8.8650000000E+03, 4.0255101248E+00, 6.5128946775E+00, 1.5257977380E-01, 1.4376272659E-01, 4.9558086513E-01],
	[8.8700000000E+03, 4.0284417039E+00, 6.5117678512E+00, 1.5284636655E-01, 1.4400257246E-01, 4.9574677808E-01],
	[8.8750000000E+03, 4.0313737640E+00, 6.5106418547E+00, 1.5311327407E-01, 1.4424266644E-01, 4.9591265626E-01],
	[8.8800000000E+03, 4.0343063050E+00, 6.5095166869E+00, 1.5338049656E-01, 1.4448300860E-01, 4.9607849976E-01],
	[8.8850000000E+03, 4.0372393346E+00, 6.5083923843E+00, 1.5364803421E-01, 1.4472359904E-01, 4.9624430866E-01],
	[8.8900000000E+03, 4.0401769446E+00, 6.5072883559E+00, 1.5391588721E-01, 1.4496445272E-01, 4.9641008306E-01],
	[8.8950000000E+03, 4.0431150385E+00, 6.5061851354E+00, 1.5418405575E-01, 1.4520555485E-01, 4.9657582305E-01],
	[8.9000000000E+03, 4.0460536162E+00, 6.5050827217E+00, 1.5445254004E-01, 1.4544690551E-01, 4.9674152870E-01],
	[8.9050000000E+03, 4.0489926775E+00, 6.5039811138E+00, 1.5472134026E-01, 1.4568850475E-01, 4.9690720011E-01],
	[8.9100000000E+03, 4.0519322222E+00, 6.5028803107E+00, 1.5499045660E-01, 1.4593035264E-01, 4.9707283737E-01],
	[8.9150000000E+03, 4.0548722500E+00, 6.5017803113E+00, 1.5525988926E-01, 1.4617244925E-01, 4.9723844055E-01],
	[8.9200000000E+03, 4.0578127608E+00, 6.5006811146E+00, 1.5552963844E-01, 1.4641479463E-01, 4.9740400969E-01],
	[8.9250000000E+03, 4.0607537544E+00, 6.4995827195E+00, 1.5579970432E-01, 1.4665738884E-01, 4.9756954485E-01],
	[8.9300000000E+03, 4.0636952307E+00, 6.4984851250E+00, 1.5607008710E-01, 1.4690023196E-01, 4.9773504608E-01],
	[8.9350000000E+03, 4.0666371893E+00, 6.4973883301E+00, 1.5634078698E-01, 1.4714332405E-01, 4.9790051344E-01],
	[8.9400000000E+03, 4.0695796302E+00, 6.4962923338E+00, 1.5661180414E-01, 1.4738666515E-01, 4.9806594700E-01],
	[8.9450000000E+03, 4.0725225531E+00, 6.4951971350E+00, 1.5688313878E-01, 1.4763025535E-01, 4.9823134681E-01],
	[8.9500000000E+03, 4.0754659579E+00, 6.4941027326E+00, 1.5715479109E-01, 1.4787409469E-01, 4.9839671294E-01],
	[8.9550000000E+03, 4.0784098443E+00, 6.4930091258E+00, 1.5742676127E-01, 1.4811818325E-01, 4.9856204543E-01],
	[8.9600000000E+03, 4.0813542121E+00, 6.4919163134E+00, 1.5769904950E-01, 1.4836252108E-01, 4.9872734436E-01],
	[8.9650000000E+03, 4.0842990613E+00, 6.4908242944E+00, 1.5797165600E-01, 1.4860710824E-01, 4.9889260978E-01],
	[8.9700000000E+03, 4.0872443915E+00, 6.4897330679E+00, 1.5824458093E-01, 1.4885194480E-01, 4.9905784175E-01],
	[8.9750000000E+03, 4.0901902027E+00, 6.4886426327E+00, 1.5851782451E-01, 1.4909703082E-01, 4.9922304033E-01],
	[8.9800000000E+03, 4.0931364945E+00, 6.4875529880E+00, 1.5879138692E-01, 1.4934236636E-01, 4.9938820558E-01],
	[8.9850000000E+03, 4.0960832668E+00, 6.4864641326E+00, 1.5906526836E-01, 1.4958795147E-01, 4.9955333756E-01],
	[8.9900000000E+03, 4.0990305195E+00, 6.4853760655E+00, 1.5933946902E-01, 1.4983378622E-01, 4.9971843632E-01],
	[8.9950000000E+03, 4.1019782523E+00, 6.4842887858E+00, 1.5961398909E-01, 1.5007987068E-01, 4.9988350193E-01],
	[9.0000000000E+03, 4.1049264651E+00, 6.4832022925E+00, 1.5988882877E-01, 1.5032620489E-01, 5.0004853445E-01],
	[9.0050000000E+03, 4.1078751576E+00, 6.4821165845E+00, 1.6016555126E-01, 1.5057417035E-01, 5.0021353394E-01],
	[9.0100000000E+03, 4.1108243297E+00, 6.4810316608E+00, 1.6044259827E-01, 1.5082238923E-01, 5.0037850045E-01],
	[9.0150000000E+03, 4.1137739812E+00, 6.4799475204E+00, 1.6071997000E-01, 1.5107086161E-01, 5.0054343404E-01],
	[9.0200000000E+03, 4.1167241119E+00, 6.4788641624E+00, 1.6099766664E-01, 1.5131958754E-01, 5.0070833478E-01],
	[9.0250000000E+03, 4.1196747216E+00, 6.4777815858E+00, 1.6127568840E-01, 1.5156856710E-01, 5.0087320272E-01],
	[9.0300000000E+03, 4.1226273894E+00, 6.4767071241E+00, 1.6155403547E-01, 1.5181780650E-01, 5.0103803792E-01],
	[9.0350000000E+03, 4.1255829606E+00, 6.4756446797E+00, 1.6183270805E-01, 1.5206730917E-01, 5.0120284045E-01],
	[9.0400000000E+03, 4.1285390138E+00, 6.4745829973E+00, 1.6211170635E-01, 1.5231706574E-01, 5.0136761036E-01],
	[9.0450000000E+03, 4.1314955487E+00, 6.4735220758E+00, 1.6239103056E-01, 1.5256707626E-01, 5.0153234771E-01],
	[9.0500000000E+03, 4.1344525652E+00, 6.4724619143E+00, 1.6267068089E-01, 1.5281734080E-01, 5.0169705255E-01],
	[9.0550000000E+03, 4.1374100632E+00, 6.4714025119E+00, 1.6295065752E-01, 1.5306785942E-01, 5.0186172496E-01],
	[9.0600000000E+03, 4.1403680423E+00, 6.4703438675E+00, 1.6323096067E-01, 1.5331863217E-01, 5.0202636498E-01],
	[9.0650000000E+03, 4.1433265024E+00, 6.4692859803E+00, 1.6351159052E-01, 1.5356965913E-01, 5.0219097269E-01],
	[9.0700000000E+03, 4.1462854434E+00, 6.4682288492E+00, 1.6379254729E-01, 1.5382094035E-01, 5.0235554812E-01],
	[9.0750000000E+03, 4.1492448651E+00, 6.4671724734E+00, 1.6407383117E-01, 1.5407247590E-01, 5.0252009136E-01],
	[9.0800000000E+03, 4.1522047672E+00, 6.4661168518E+00, 1.6435544236E-01, 1.5432426582E-01, 5.0268460245E-01],
	[9.0850000000E+03, 4.1551651496E+00, 6.4650619834E+00, 1.6463738105E-01, 1.5457631020E-01, 5.0284908145E-01],
	[9.0900000000E+03, 4.1581260120E+00, 6.4640078674E+00, 1.6491964745E-01, 1.5482860907E-01, 5.0301352843E-01],
	[9.0950000000E+03, 4.1610873544E+00, 6.4629545028E+00, 1.6520224177E-01, 1.5508116251E-01, 5.0317794344E-01],
	[9.1000000000E+03, 4.1640491765E+00, 6.4619018887E+00, 1.6548516419E-01, 1.5533397058E-01, 5.0334232655E-01],
	[9.1050000000E+03, 4.1670114781E+00, 6.4608500240E+00, 1.6576841491E-01, 1.5558703333E-01, 5.0350667780E-01],
	[9.1100000000E+03, 4.1699742591E+00, 6.4597989079E+00, 1.6605199415E-01, 1.5584035083E-01, 5.0367099727E-01],
	[9.1150000000E+03, 4.1729375193E+00, 6.4587485395E+00, 1.6633590208E-01, 1.5609392313E-01, 5.0383528500E-01],
	[9.1200000000E+03, 4.1759012584E+00, 6.4576989176E+00, 1.6662013893E-01, 1.5634775029E-01, 5.0399954106E-01],
	[9.1250000000E+03, 4.1788654763E+00, 6.4566500415E+00, 1.6690470488E-01, 1.5660183238E-01, 5.0416376552E-01],
	[9.1300000000E+03, 4.1818301728E+00, 6.4556019102E+00, 1.6718960014E-01, 1.5685616944E-01, 5.0432795841E-01],
	[9.1350000000E+03, 4.1847953477E+00, 6.4545545228E+00, 1.6747482490E-01, 1.5711076155E-01, 5.0449211982E-01],
	[9.1400000000E+03, 4.1877610008E+00, 6.4535078783E+00, 1.6776037937E-01, 1.5736560876E-01, 5.0465624979E-01],
	[9.1450000000E+03, 4.1907271320E+00, 6.4524619757E+00, 1.6804626374E-01, 1.5762071112E-01, 5.0482034839E-01],
	[9.1500000000E+03, 4.1936937411E+00, 6.4514168142E+00, 1.6833247821E-01, 1.5787606870E-01, 5.0498441566E-01],
	[9.1550000000E+03, 4.1966608279E+00, 6.4503723929E+00, 1.6861902299E-01, 1.5813168155E-01, 5.0514845169E-01],
	[9.1600000000E+03, 4.1996283921E+00, 6.4493287107E+00, 1.6890589827E-01, 1.5838754974E-01, 5.0531245651E-01],
	[9.1650000000E+03, 4.2025964337E+00, 6.4482857668E+00, 1.6919310426E-01, 1.5864367331E-01, 5.0547643020E-01],
	[9.1700000000E+03, 4.2055649524E+00, 6.4472435603E+00, 1.6948064115E-01, 1.5890005233E-01, 5.0564037280E-01],
	[9.1750000000E+03, 4.2085352423E+00, 6.4462079014E+00, 1.6976850914E-01, 1.5915669225E-01, 5.0580428439E-01],
	[9.1800000000E+03, 4.2115086765E+00, 6.4451849341E+00, 1.7005670843E-01, 1.5941359890E-01, 5.0596816501E-01],
	[9.1850000000E+03, 4.2144825906E+00, 6.4441626861E+00, 1.7034523923E-01, 1.5967076126E-01, 5.0613201473E-01],
	[9.1900000000E+03, 4.2174569846E+00, 6.4431411564E+00, 1.7063410172E-01, 1.5992817938E-01, 5.0629583361E-01],
	[9.1950000000E+03, 4.2204318582E+00, 6.4421203441E+00, 1.7092329612E-01, 1.6018585334E-01, 5.0645962171E-01],
	[9.2000000000E+03, 4.2234072113E+00, 6.4411002484E+00, 1.7121282262E-01, 1.6044378318E-01, 5.0662337908E-01],
	[9.2050000000E+03, 4.2263830437E+00, 6.4400808683E+00, 1.7150268143E-01, 1.6070196896E-01, 5.0678710578E-01],
	[9.2100000000E+03, 4.2293593551E+00, 6.4390622030E+00, 1.7179287273E-01, 1.6096041073E-01, 5.0695080188E-01],
	[9.2150000000E+03, 4.2323361455E+00, 6.4380442515E+00, 1.7208339673E-01, 1.6121910856E-01, 5.0711446743E-01],
	[9.2200000000E+03, 4.2353134146E+00, 6.4370270130E+00, 1.7237425364E-01, 1.6147806250E-01, 5.0727810249E-01],
	[9.2250000000E+03, 4.2382911623E+00, 6.4360104867E+00, 1.7266544365E-01, 1.6173727260E-01, 5.0744170712E-01],
	[9.2300000000E+03, 4.2412693883E+00, 6.4349946715E+00, 1.7295696695E-01, 1.6199673892E-01, 5.0760528138E-01],
	[9.2350000000E+03, 4.2442480925E+00, 6.4339795666E+00, 1.7324882376E-01, 1.6225646152E-01, 5.0776882533E-01],
	[9.2400000000E+03, 4.2472272747E+00, 6.4329651713E+00, 1.7354101427E-01, 1.6251644045E-01, 5.0793233903E-01],
	[9.2450000000E+03, 4.2502069347E+00, 6.4319514844E+00, 1.7383353867E-01, 1.6277667576E-01, 5.0809582253E-01],
	[9.2500000000E+03, 4.2531870723E+00, 6.4309385053E+00, 1.7412639718E-01, 1.6303716752E-01, 5.0825927590E-01],
	[9.2550000000E+03, 4.2561676874E+00, 6.4299262330E+00, 1.7441958999E-01, 1.6329791578E-01, 5.0842269920E-01],
	[9.2600000000E+03, 4.2591487798E+00, 6.4289146666E+00, 1.7471311730E-01, 1.6355892059E-01, 5.0858609247E-01],
	[9.2650000000E+03, 4.2621303492E+00, 6.4279038053E+00, 1.7500697931E-01, 1.6382018200E-01, 5.0874945579E-01],
	[9.2700000000E+03, 4.2651123956E+00, 6.4268936482E+00, 1.7530117621E-01, 1.6408170008E-01, 5.0891278922E-01],
	[9.2750000000E+03, 4.2680949187E+00, 6.4258841944E+00, 1.7559570822E-01, 1.6434347487E-01, 5.0907609280E-01],
	[9.2800000000E+03, 4.2710779183E+00, 6.4248754431E+00, 1.7589057553E-01, 1.6460550643E-01, 5.0923936661E-01],
	[9.2850000000E+03, 4.2740613943E+00, 6.4238673933E+00, 1.7618577833E-01, 1.6486779481E-01, 5.0940261069E-01],
	[9.2900000000E+03, 4.2770453465E+00, 6.4228600443E+00, 1.7648131684E-01, 1.6513034007E-01, 5.0956582511E-01],
	[9.2950000000E+03, 4.2800297747E+00, 6.4218533951E+00, 1.7677719125E-01, 1.6539314226E-01, 5.0972900993E-01],
	[9.3000000000E+03, 4.2830146788E+00, 6.4208474450E+00, 1.7707340175E-01, 1.6565620143E-01, 5.0989216520E-01],
	[9.3050000000E+03, 4.2860000584E+00, 6.4198421930E+00, 1.7736994856E-01, 1.6591951764E-01, 5.1005529099E-01],
	[9.3100000000E+03, 4.2889859136E+00, 6.4188376382E+00, 1.7766683187E-01, 1.6618309094E-01, 5.1021838735E-01],
	[9.3150000000E+03, 4.2919722440E+00, 6.4178337799E+00, 1.7796405187E-01, 1.6644692138E-01, 5.1038145435E-01],
	[9.3200000000E+03, 4.2949590495E+00, 6.4168306171E+00, 1.7826160878E-01, 1.6671100902E-01, 5.1054449204E-01],
	[9.3250000000E+03, 4.2979494366E+00, 6.4158416011E+00, 1.7855950278E-01, 1.6697536771E-01, 5.1070750048E-01],
	[9.3300000000E+03, 4.3009411215E+00, 6.4148568171E+00, 1.7885773409E-01, 1.6723998742E-01, 5.1087047973E-01],
	[9.3350000000E+03, 4.3039332843E+00, 6.4138727118E+00, 1.7915630290E-01, 1.6750486459E-01, 5.1103342985E-01],
	[9.3400000000E+03, 4.3069259249E+00, 6.4128892843E+00, 1.7945520940E-01, 1.6776999926E-01, 5.1119635089E-01],
	[9.3450000000E+03, 4.3099190430E+00, 6.4119065337E+00, 1.7975445381E-01, 1.6803539148E-01, 5.1135924293E-01],
	[9.3500000000E+03, 4.3129126386E+00, 6.4109244594E+00, 1.8005403631E-01, 1.6830104130E-01, 5.1152210601E-01],
	[9.3550000000E+03, 4.3159067113E+00, 6.4099430603E+00, 1.8035395712E-01, 1.6856694879E-01, 5.1168494019E-01],
	[9.3600000000E+03, 4.3189012611E+00, 6.4089623358E+00, 1.8065421643E-01, 1.6883311398E-01, 5.1184774554E-01],
	[9.3650000000E+03, 4.3218962877E+00, 6.4079822850E+00, 1.8095481444E-01, 1.6909953693E-01, 5.1201052211E-01],
	[9.3700000000E+03, 4.3248917909E+00, 6.4070029070E+00, 1.8125575135E-01, 1.6936621769E-01, 5.1217326997E-01],
	[9.3750000000E+03, 4.3278877707E+00, 6.4060242010E+00, 1.8155702736E-01, 1.6963315632E-01, 5.1233598916E-01],
	[9.3800000000E+03, 4.3308842268E+00, 6.4050461663E+00, 1.8185864267E-01, 1.6990035286E-01, 5.1249867976E-01],
	[9.3850000000E+03, 4.3338811590E+00, 6.4040688020E+00, 1.8216059749E-01, 1.7016780736E-01, 5.1266134181E-01],
	[9.3900000000E+03, 4.3368785672E+00, 6.4030921072E+00, 1.8246289200E-01, 1.7043551988E-01, 5.1282397539E-01],
	[9.3950000000E+03, 4.3398764512E+00, 6.4021160813E+00, 1.8276552642E-01, 1.7070349046E-01, 5.1298658053E-01],
	[9.4000000000E+03, 4.3428748107E+00, 6.4011407233E+00, 1.8306850094E-01, 1.7097171916E-01, 5.1314915729E-01],
	[9.4050000000E+03, 4.3458736457E+00, 6.4001660324E+00, 1.8337181576E-01, 1.7124020602E-01, 5.1331170567E-01],
	[9.4100000000E+03, 4.3488729559E+00, 6.3991920079E+00, 1.8367547109E-01, 1.7150895110E-01, 5.1347422572E-01],
	[9.4150000000E+03, 4.3518727412E+00, 6.3982186489E+00, 1.8397946712E-01, 1.7177795444E-01, 5.1363671748E-01],
	[9.4200000000E+03, 4.3548730014E+00, 6.3972459546E+00, 1.8428380405E-01, 1.7204721610E-01, 5.1379918097E-01],
	[9.4250000000E+03, 4.3578737363E+00, 6.3962739243E+00, 1.8458848208E-01, 1.7231673612E-01, 5.1396161624E-01],
	[9.4300000000E+03, 4.3608749458E+00, 6.3953025570E+00, 1.8489350142E-01, 1.7258651455E-01, 5.1412402332E-01],
	[9.4350000000E+03, 4.3638766296E+00, 6.3943318520E+00, 1.8519886226E-01, 1.7285655144E-01, 5.1428640225E-01],
	[9.4400000000E+03, 4.3668787876E+00, 6.3933618086E+00, 1.8550456481E-01, 1.7312684684E-01, 5.1444875306E-01],
	[9.4450000000E+03, 4.3698814196E+00, 6.3923924258E+00, 1.8581060926E-01, 1.7339740080E-01, 5.1461107580E-01],
	[9.4500000000E+03, 4.3728845254E+00, 6.3914237030E+00, 1.8611699581E-01, 1.7366821337E-01, 5.1477337049E-01],
	[9.4550000000E+03, 4.3758881049E+00, 6.3904556392E+00, 1.8642372468E-01, 1.7393928459E-01, 5.1493563719E-01],
	[9.4600000000E+03, 4.3788921579E+00, 6.3894882338E+00, 1.8673079604E-01, 1.7421061452E-01, 5.1509787591E-01],
	[9.4650000000E+03, 4.3818966841E+00, 6.3885214859E+00, 1.8703821012E-01, 1.7448220320E-01, 5.1526008670E-01],
	[9.4700000000E+03, 4.3849016835E+00, 6.3875553946E+00, 1.8734596709E-01, 1.7475405067E-01, 5.1542226960E-01],
	[9.4750000000E+03, 4.3879101920E+00, 6.3866026390E+00, 1.8765406718E-01, 1.7502617135E-01, 5.1558442464E-01],
	[9.4800000000E+03, 4.3909200329E+00, 6.3856541045E+00, 1.8796251057E-01, 1.7529855505E-01, 5.1574655185E-01],
	[9.4850000000E+03, 4.3939303496E+00, 6.3847062109E+00, 1.8827129747E-01, 1.7557119780E-01, 5.1590865129E-01],
	[9.4900000000E+03, 4.3969411421E+00, 6.3837589575E+00, 1.8858051897E-01, 1.7584417866E-01, 5.1607072297E-01],
	[9.4950000000E+03, 4.3999524101E+00, 6.3828123434E+00, 1.8889013720E-01, 1.7611746455E-01, 5.1623276694E-01],
	[9.5000000000E+03, 4.4029641534E+00, 6.3818663679E+00, 1.8920009998E-01, 1.7639100997E-01, 5.1639478324E-01],
	[9.5050000000E+03, 4.4059763720E+00, 6.3809210303E+00, 1.8951040751E-01, 1.7666481495E-01, 5.1655677190E-01],
	[9.5100000000E+03, 4.4089890655E+00, 6.3799763297E+00, 1.8982105999E-01, 1.7693887955E-01, 5.1671873296E-01],
	[9.5150000000E+03, 4.4120022339E+00, 6.3790322655E+00, 1.9013205763E-01, 1.7721320382E-01, 5.1688066646E-01],
	[9.5200000000E+03, 4.4150158769E+00, 6.3780888368E+00, 1.9044340062E-01, 1.7748778779E-01, 5.1704257243E-01],
	[9.5250000000E+03, 4.4180299945E+00, 6.3771460429E+00, 1.9075508917E-01, 1.7776263151E-01, 5.1720445091E-01],
	[9.5300000000E+03, 4.4210445863E+00, 6.3762038830E+00, 1.9106712347E-01, 1.7803773504E-01, 5.1736630194E-01],
	[9.5350000000E+03, 4.4240596523E+00, 6.3752623564E+00, 1.9137950373E-01, 1.7831309842E-01, 5.1752812554E-01],
	[9.5400000000E+03, 4.4270751922E+00, 6.3743214623E+00, 1.9169223015E-01, 1.7858872169E-01, 5.1768992177E-01],
	[9.5450000000E+03, 4.4300912059E+00, 6.3733812000E+00, 1.9200530293E-01, 1.7886460489E-01, 5.1785169066E-01],
	[9.5500000000E+03, 4.4331076932E+00, 6.3724415686E+00, 1.9231872227E-01, 1.7914074809E-01, 5.1801343224E-01],
	[9.5550000000E+03, 4.4361246540E+00, 6.3715025675E+00, 1.9263248837E-01, 1.7941715131E-01, 5.1817514655E-01],
	[9.5600000000E+03, 4.4391420881E+00, 6.3705641959E+00, 1.9294660144E-01, 1.7969381461E-01, 5.1833683363E-01],
	[9.5650000000E+03, 4.4421599952E+00, 6.3696264530E+00, 1.9326106167E-01, 1.7997073802E-01, 5.1849849352E-01],
	[9.5700000000E+03, 4.4451783752E+00, 6.3686893382E+00, 1.9357586927E-01, 1.8024792160E-01, 5.1866012624E-01],
	[9.5750000000E+03, 4.4481972280E+00, 6.3677528506E+00, 1.9389102444E-01, 1.8052536539E-01, 5.1882173185E-01],
	[9.5800000000E+03, 4.4512165534E+00, 6.3668169894E+00, 1.9420652737E-01, 1.8080306944E-01, 5.1898331037E-01],
	[9.5850000000E+03, 4.4542363512E+00, 6.3658817541E+00, 1.9452237827E-01, 1.8108103378E-01, 5.1914486185E-01],
	[9.5900000000E+03, 4.4572566212E+00, 6.3649471437E+00, 1.9483857735E-01, 1.8135925846E-01, 5.1930638631E-01],
	[9.5950000000E+03, 4.4602773633E+00, 6.3640131576E+00, 1.9515512480E-01, 1.8163774353E-01, 5.1946788380E-01],
	[9.6000000000E+03, 4.4632985772E+00, 6.3630797950E+00, 1.9547202082E-01, 1.8191648903E-01, 5.1962935436E-01],
	[9.6050000000E+03, 4.4663202629E+00, 6.3621470552E+00, 1.9578926561E-01, 1.8219549500E-01, 5.1979079801E-01],
	[9.6100000000E+03, 4.4693424201E+00, 6.3612149375E+00, 1.9610685939E-01, 1.8247476149E-01, 5.1995221481E-01],
	[9.6150000000E+03, 4.4723650486E+00, 6.3602834410E+00, 1.9642480234E-01, 1.8275428853E-01, 5.2011360478E-01],
	[9.6200000000E+03, 4.4753881484E+00, 6.3593525651E+00, 1.9674309466E-01, 1.8303407618E-01, 5.2027496797E-01],
	[9.6250000000E+03, 4.4784128208E+00, 6.3584267466E+00, 1.9680384647E-01, 1.8309094675E-01, 5.2043630440E-01],
	[9.6300000000E+03, 4.4814407224E+00, 6.3575126412E+00, 1.9712232775E-01, 1.8337087340E-01, 5.2059761412E-01],
	[9.6350000000E+03, 4.4844690978E+00, 6.3565991416E+00, 1.9744115827E-01, 1.8365106041E-01, 5.2075889716E-01],
	[9.6400000000E+03, 4.4874979469E+00, 6.3556862471E+00, 1.9776033823E-01, 1.8393150784E-01, 5.2092015357E-01],
	[9.6450000000E+03, 4.4905272696E+00, 6.3547739570E+00, 1.9807986783E-01, 1.8421221573E-01, 5.2108138338E-01],
	[9.6500000000E+03, 4.4935570657E+00, 6.3538622705E+00, 1.9839974727E-01, 1.8449318412E-01, 5.2124258662E-01],
	[9.6550000000E+03, 4.4965873350E+00, 6.3529511870E+00, 1.9871997676E-01, 1.8477441306E-01, 5.2140376333E-01],
	[9.6600000000E+03, 4.4996180773E+00, 6.3520407057E+00, 1.9904055650E-01, 1.8505590258E-01, 5.2156491355E-01],
	[9.6650000000E+03, 4.5026492925E+00, 6.3511308259E+00, 1.9936148667E-01, 1.8533765272E-01, 5.2172603733E-01],
	[9.6700000000E+03, 4.5056809803E+00, 6.3502215470E+00, 1.9968276750E-01, 1.8561966353E-01, 5.2188713468E-01],
	[9.6750000000E+03, 4.5087131407E+00, 6.3493128682E+00, 2.0000439917E-01, 1.8590193505E-01, 5.2204820566E-01],
	[9.6800000000E+03, 4.5117457735E+00, 6.3484047887E+00, 2.0032638189E-01, 1.8618446732E-01, 5.2220925030E-01],
	[9.6850000000E+03, 4.5147788784E+00, 6.3474973080E+00, 2.0064871586E-01, 1.8646726038E-01, 5.2237026863E-01],
	[9.6900000000E+03, 4.5178124553E+00, 6.3465904253E+00, 2.0097140128E-01, 1.8675031427E-01, 5.2253126070E-01],
	[9.6950000000E+03, 4.5208465041E+00, 6.3456841399E+00, 2.0129443834E-01, 1.8703362903E-01, 5.2269222655E-01],
	[9.7000000000E+03, 4.5238810245E+00, 6.3447784510E+00, 2.0161782726E-01, 1.8731720471E-01, 5.2285316620E-01],
	[9.7050000000E+03, 4.5269160164E+00, 6.3438733581E+00, 2.0194156823E-01, 1.8760104133E-01, 5.2301407969E-01],
	[9.7100000000E+03, 4.5299514797E+00, 6.3429688604E+00, 2.0226566145E-01, 1.8788513895E-01, 5.2317496707E-01],
	[9.7150000000E+03, 4.5329874141E+00, 6.3420649571E+00, 2.0259010713E-01, 1.8816949760E-01, 5.2333582838E-01],
	[9.7200000000E+03, 4.5360238195E+00, 6.3411616477E+00, 2.0291490546E-01, 1.8845411732E-01, 5.2349666364E-01],
	[9.7250000000E+03, 4.5390606957E+00, 6.3402589313E+00, 2.0324005664E-01, 1.8873899815E-01, 5.2365747289E-01],
	[9.7300000000E+03, 4.5420980426E+00, 6.3393568074E+00, 2.0356556088E-01, 1.8902414013E-01, 5.2381825618E-01],
	[9.7350000000E+03, 4.5451358600E+00, 6.3384552752E+00, 2.0389141838E-01, 1.8930954330E-01, 5.2397901354E-01],
	[9.7400000000E+03, 4.5481741477E+00, 6.3375543340E+00, 2.0421762933E-01, 1.8959520769E-01, 5.2413974501E-01],
	[9.7450000000E+03, 4.5512129055E+00, 6.3366539832E+00, 2.0454419394E-01, 1.8988113335E-01, 5.2430045063E-01],
	[9.7500000000E+03, 4.5542521333E+00, 6.3357542220E+00, 2.0487111242E-01, 1.9016732032E-01, 5.2446113043E-01],
	[9.7550000000E+03, 4.5572918309E+00, 6.3348550497E+00, 2.0519838495E-01, 1.9045376862E-01, 5.2462178445E-01],
	[9.7600000000E+03, 4.5603319982E+00, 6.3339564658E+00, 2.0552601174E-01, 1.9074047831E-01, 5.2478241273E-01],
	[9.7650000000E+03, 4.5633726349E+00, 6.3330584694E+00, 2.0585399300E-01, 1.9102744942E-01, 5.2494301531E-01],
	[9.7700000000E+03, 4.5664137409E+00, 6.3321610599E+00, 2.0618232892E-01, 1.9131468198E-01, 5.2510359222E-01],
	[9.7750000000E+03, 4.5694553161E+00, 6.3312642367E+00, 2.0651101970E-01, 1.9160217604E-01, 5.2526414350E-01],
	[9.7800000000E+03, 4.5724985083E+00, 6.3303724556E+00, 2.0684006555E-01, 1.9188993774E-01, 5.2542466919E-01],
	[9.7850000000E+03, 4.5755448466E+00, 6.3294916370E+00, 2.0716946666E-01, 1.9217797534E-01, 5.2558516933E-01],
	[9.7900000000E+03, 4.5785916568E+00, 6.3286113909E+00, 2.0749922325E-01, 1.9246627465E-01, 5.2574564396E-01],
	[9.7950000000E+03, 4.5816389385E+00, 6.3277317165E+00, 2.0782933550E-01, 1.9275483571E-01, 5.2590609310E-01],
	[9.8000000000E+03, 4.5846866917E+00, 6.3268526132E+00, 2.0815980361E-01, 1.9304365856E-01, 5.2606651681E-01],
	[9.8050000000E+03, 4.5877349161E+00, 6.3259740804E+00, 2.0849062780E-01, 1.9333274322E-01, 5.2622691511E-01],
	[9.8100000000E+03, 4.5907836116E+00, 6.3250961174E+00, 2.0882180826E-01, 1.9362208975E-01, 5.2638728805E-01],
	[9.8150000000E+03, 4.5938327781E+00, 6.3242187235E+00, 2.0915334520E-01, 1.9391169818E-01, 5.2654763566E-01],
	[9.8200000000E+03, 4.5968824153E+00, 6.3233418980E+00, 2.0948523880E-01, 1.9420156854E-01, 5.2670795798E-01],
	[9.8250000000E+03, 4.5999325231E+00, 6.3224656404E+00, 2.0981748928E-01, 1.9449170086E-01, 5.2686825505E-01],
	[9.8300000000E+03, 4.6029831014E+00, 6.3215899499E+00, 2.1015009684E-01, 1.9478209520E-01, 5.2702852691E-01],
	[9.8350000000E+03, 4.6060341499E+00, 6.3207148259E+00, 2.1048306167E-01, 1.9507275157E-01, 5.2718877359E-01],
	[9.8400000000E+03, 4.6090856685E+00, 6.3198402678E+00, 2.1081638398E-01, 1.9536367001E-01, 5.2734899514E-01],
	[9.8450000000E+03, 4.6121376570E+00, 6.3189662748E+00, 2.1115006396E-01, 1.9565485057E-01, 5.2750919158E-01],
	[9.8500000000E+03, 4.6151901153E+00, 6.3180928464E+00, 2.1148410183E-01, 1.9594629328E-01, 5.2766936296E-01],
	[9.8550000000E+03, 4.6182430432E+00, 6.3172199819E+00, 2.1181849778E-01, 1.9623799816E-01, 5.2782950931E-01],
	[9.8600000000E+03, 4.6212964406E+00, 6.3163476806E+00, 2.1215325201E-01, 1.9652996526E-01, 5.2798963065E-01],
	[9.8650000000E+03, 4.6243503072E+00, 6.3154759420E+00, 2.1248836472E-01, 1.9682219461E-01, 5.2814972698E-01],
	[9.8700000000E+03, 4.6274046429E+00, 6.3146047652E+00, 2.1282383612E-01, 1.9711468625E-01, 5.2830979832E-01],
	[9.8750000000E+03, 4.6304594475E+00, 6.3137341498E+00, 2.1315966640E-01, 1.9740744021E-01, 5.2846984470E-01],
	[9.8800000000E+03, 4.6335147209E+00, 6.3128640950E+00, 2.1349585577E-01, 1.9770045652E-01, 5.2862986613E-01],
	[9.8850000000E+03, 4.6365704629E+00, 6.3119946002E+00, 2.1383240443E-01, 1.9799373521E-01, 5.2878986264E-01],
	[9.8900000000E+03, 4.6396266733E+00, 6.3111256647E+00, 2.1416931258E-01, 1.9828727633E-01, 5.2894983425E-01],
	[9.8950000000E+03, 4.6426833521E+00, 6.3102572880E+00, 2.1450658041E-01, 1.9858107990E-01, 5.2910978097E-01],
	[9.9000000000E+03, 4.6457404989E+00, 6.3093894694E+00, 2.1484420814E-01, 1.9887514596E-01, 5.2926970283E-01],
	[9.9050000000E+03, 4.6487981136E+00, 6.3085222082E+00, 2.1518219596E-01, 1.9916947454E-01, 5.2942959984E-01],
	[9.9100000000E+03, 4.6518561962E+00, 6.3076555038E+00, 2.1552054407E-01, 1.9946406567E-01, 5.2958947203E-01],
	[9.9150000000E+03, 4.6549147463E+00, 6.3067893555E+00, 2.1585925268E-01, 1.9975891939E-01, 5.2974931942E-01],
	[9.9200000000E+03, 4.6579737640E+00, 6.3059237628E+00, 2.1619832199E-01, 2.0005403573E-01, 5.2990914202E-01],
	[9.9250000000E+03, 4.6610332488E+00, 6.3050587250E+00, 2.1653775219E-01, 2.0034941472E-01, 5.3006893986E-01],
	[9.9300000000E+03, 4.6640932009E+00, 6.3041942414E+00, 2.1687754349E-01, 2.0064505639E-01, 5.3022871296E-01],
	[9.9350000000E+03, 4.6671536198E+00, 6.3033303115E+00, 2.1721769610E-01, 2.0094096078E-01, 5.3038846133E-01],
	[9.9400000000E+03, 4.6702176051E+00, 6.3024785006E+00, 2.1755821020E-01, 2.0123714546E-01, 5.3054818501E-01],
	[9.9450000000E+03, 4.6732827580E+00, 6.3016298371E+00, 2.1789908601E-01, 2.0153359698E-01, 5.3070788400E-01],
	[9.9500000000E+03, 4.6763483803E+00, 6.3007817143E+00, 2.1824032372E-01, 2.0183031141E-01, 5.3086755833E-01],
	[9.9550000000E+03, 4.6794144721E+00, 6.2999341317E+00, 2.1858192353E-01, 2.0212728880E-01, 5.3102720802E-01],
	[9.9600000000E+03, 4.6824810330E+00, 6.2990870887E+00, 2.1892388565E-01, 2.0242452917E-01, 5.3118683309E-01],
	[9.9650000000E+03, 4.6855480630E+00, 6.2982405845E+00, 2.1926621028E-01, 2.0272203256E-01, 5.3134643356E-01],
	[9.9700000000E+03, 4.6886155619E+00, 6.2973946187E+00, 2.1960889762E-01, 2.0301979900E-01, 5.3150600946E-01],
	[9.9750000000E+03, 4.6916835295E+00, 6.2965491906E+00, 2.1995194787E-01, 2.0331782851E-01, 5.3166556079E-01],
	[9.9800000000E+03, 4.6947519656E+00, 6.2957042995E+00, 2.2029536124E-01, 2.0361612113E-01, 5.3182508759E-01],
	[9.9850000000E+03, 4.6978208702E+00, 6.2948599449E+00, 2.2063913791E-01, 2.0391467689E-01, 5.3198458987E-01],
	[9.9900000000E+03, 4.7008902429E+00, 6.2940161262E+00, 2.2098327810E-01, 2.0421349582E-01, 5.3214406765E-01],
	[9.9950000000E+03, 4.7039600838E+00, 6.2931728427E+00, 2.2132778201E-01, 2.0451257795E-01, 5.3230352096E-01],
	[1.0000000000E+04, 4.7070303925E+00, 6.2923300939E+00, 2.2167264983E-01, 2.0481192331E-01, 5.3246294982E-01],
	[1.0005000000E+04, 4.7101011690E+00, 6.2914878791E+00, 2.2201942192E-01, 2.0511284645E-01, 5.3262235424E-01],
	[1.0010000000E+04, 4.7131724130E+00, 6.2906461977E+00, 2.2236656238E-01, 2.0541403582E-01, 5.3278173424E-01],
	[1.0015000000E+04, 4.7162441245E+00, 6.2898050492E+00, 2.2271407140E-01, 2.0571549147E-01, 5.3294108986E-01],
	[1.0020000000E+04, 4.7193163032E+00, 6.2889644329E+00, 2.2306194920E-01, 2.0601721342E-01, 5.3310042110E-01],
	[1.0025000000E+04, 4.7223889490E+00, 6.2881243483E+00, 2.2341019598E-01, 2.0631920170E-01, 5.3325972799E-01],
	[1.0030000000E+04, 4.7254620618E+00, 6.2872847946E+00, 2.2375881194E-01, 2.0662145634E-01, 5.3341901055E-01],
	[1.0035000000E+04, 4.7285356413E+00, 6.2864457714E+00, 2.2410779731E-01, 2.0692397738E-01, 5.3357826880E-01],
	[1.0040000000E+04, 4.7316096874E+00, 6.2856072780E+00, 2.2445715227E-01, 2.0722676485E-01, 5.3373750276E-01],
	[1.0045000000E+04, 4.7346841999E+00, 6.2847693139E+00, 2.2480687704E-01, 2.0752981877E-01, 5.3389671246E-01],
	[1.0050000000E+04, 4.7377591787E+00, 6.2839318783E+00, 2.2515697182E-01, 2.0783313917E-01, 5.3405589791E-01],
	[1.0055000000E+04, 4.7408346237E+00, 6.2830949708E+00, 2.2550743682E-01, 2.0813672608E-01, 5.3421505913E-01],
	[1.0060000000E+04, 4.7439105346E+00, 6.2822585908E+00, 2.2585827225E-01, 2.0844057954E-01, 5.3437419615E-01],
	[1.0065000000E+04, 4.7469869113E+00, 6.2814227376E+00, 2.2620947831E-01, 2.0874469957E-01, 5.3453330899E-01],
	[1.0070000000E+04, 4.7500637536E+00, 6.2805874106E+00, 2.2656105521E-01, 2.0904908621E-01, 5.3469239766E-01],
	[1.0075000000E+04, 4.7531410615E+00, 6.2797526093E+00, 2.2691300316E-01, 2.0935373947E-01, 5.3485146220E-01],
	[1.0080000000E+04, 4.7562188346E+00, 6.2789183331E+00, 2.2726532235E-01, 2.0965865939E-01, 5.3501050261E-01],
	[1.0085000000E+04, 4.7592970729E+00, 6.2780845813E+00, 2.2761801301E-01, 2.0996384600E-01, 5.3516951893E-01],
	[1.0090000000E+04, 4.7623757762E+00, 6.2772513535E+00, 2.2797107533E-01, 2.1026929933E-01, 5.3532851116E-01],
	[1.0095000000E+04, 4.7654549443E+00, 6.2764186489E+00, 2.2832450952E-01, 2.1057501940E-01, 5.3548747935E-01],
	[1.0100000000E+04, 4.7685377925E+00, 6.2755977108E+00, 2.2867831579E-01, 2.1088102522E-01, 5.3564642349E-01],
	[1.0105000000E+04, 4.7716217890E+00, 6.2747796669E+00, 2.2903249434E-01, 2.1118730198E-01, 5.3580534362E-01],
	[1.0110000000E+04, 4.7747062531E+00, 6.2739621341E+00, 2.2938704538E-01, 2.1149384567E-01, 5.3596423976E-01],
	[1.0115000000E+04, 4.7777911844E+00, 6.2731451120E+00, 2.2974196912E-01, 2.1180065634E-01, 5.3612311193E-01],
	[1.0120000000E+04, 4.7808765828E+00, 6.2723286000E+00, 2.3009726576E-01, 2.1210773401E-01, 5.3628196015E-01],
	[1.0125000000E+04, 4.7839624483E+00, 6.2715125976E+00, 2.3045293551E-01, 2.1241507870E-01, 5.3644078444E-01],
	[1.0130000000E+04, 4.7870487806E+00, 6.2706971040E+00, 2.3080897858E-01, 2.1272269045E-01, 5.3659958483E-01],
	[1.0135000000E+04, 4.7901355795E+00, 6.2698821188E+00, 2.3116539517E-01, 2.1303056928E-01, 5.3675836132E-01],
	[1.0140000000E+04, 4.7932228449E+00, 6.2690676415E+00, 2.3152218549E-01, 2.1333871522E-01, 5.3691711396E-01],
	[1.0145000000E+04, 4.7963105767E+00, 6.2682536714E+00, 2.3187934975E-01, 2.1364712829E-01, 5.3707584275E-01],
	[1.0150000000E+04, 4.7993987746E+00, 6.2674402079E+00, 2.3223688815E-01, 2.1395580852E-01, 5.3723454771E-01],
	[1.0155000000E+04, 4.8024874386E+00, 6.2666272506E+00, 2.3259480089E-01, 2.1426475593E-01, 5.3739322888E-01],
	[1.0160000000E+04, 4.8055765684E+00, 6.2658147988E+00, 2.3295308820E-01, 2.1457397056E-01, 5.3755188627E-01],
	[1.0165000000E+04, 4.8086661639E+00, 6.2650028520E+00, 2.3331175026E-01, 2.1488345243E-01, 5.3771051991E-01],
	[1.0170000000E+04, 4.8117562250E+00, 6.2641914097E+00, 2.3367078730E-01, 2.1519320156E-01, 5.3786912981E-01],
	[1.0175000000E+04, 4.8148467515E+00, 6.2633804711E+00, 2.3403019951E-01, 2.1550321799E-01, 5.3802771599E-01],
	[1.0180000000E+04, 4.8179377432E+00, 6.2625700359E+00, 2.3438998710E-01, 2.1581350172E-01, 5.3818627849E-01],
	[1.0185000000E+04, 4.8210291999E+00, 6.2617601035E+00, 2.3475015028E-01, 2.1612405280E-01, 5.3834481731E-01],
	[1.0190000000E+04, 4.8241211216E+00, 6.2609506732E+00, 2.3511068926E-01, 2.1643487124E-01, 5.3850333249E-01],
	[1.0195000000E+04, 4.8272135080E+00, 6.2601417445E+00, 2.3547160424E-01, 2.1674595707E-01, 5.3866182403E-01],
	[1.0200000000E+04, 4.8303063591E+00, 6.2593333169E+00, 2.3583289543E-01, 2.1705731031E-01, 5.3882029198E-01],
	[1.0205000000E+04, 4.8333996745E+00, 6.2585253899E+00, 2.3619456303E-01, 2.1736893099E-01, 5.3897873634E-01],
	[1.0210000000E+04, 4.8364934543E+00, 6.2577179627E+00, 2.3655660725E-01, 2.1768081913E-01, 5.3913715713E-01],
	[1.0215000000E+04, 4.8395876981E+00, 6.2569110350E+00, 2.3691902831E-01, 2.1799297476E-01, 5.3929555439E-01],
	[1.0220000000E+04, 4.8426824059E+00, 6.2561046062E+00, 2.3728182640E-01, 2.1830539790E-01, 5.3945392813E-01],
	[1.0225000000E+04, 4.8457775776E+00, 6.2552986756E+00, 2.3764500173E-01, 2.1861808857E-01, 5.3961227838E-01],
	[1.0230000000E+04, 4.8488732128E+00, 6.2544932428E+00, 2.3800855451E-01, 2.1893104680E-01, 5.3977060515E-01],
	[1.0235000000E+04, 4.8519693116E+00, 6.2536883072E+00, 2.3837248495E-01, 2.1924427261E-01, 5.3992890847E-01],
	[1.0240000000E+04, 4.8550658737E+00, 6.2528838682E+00, 2.3873679325E-01, 2.1955776602E-01, 5.4008718835E-01],
	[1.0245000000E+04, 4.8581628990E+00, 6.2520799254E+00, 2.3910147962E-01, 2.1987152706E-01, 5.4024544483E-01],
	[1.0250000000E+04, 4.8612603873E+00, 6.2512764780E+00, 2.3946654427E-01, 2.2018555574E-01, 5.4040367792E-01],
	[1.0255000000E+04, 4.8643583384E+00, 6.2504735257E+00, 2.3983198740E-01, 2.2049985210E-01, 5.4056188765E-01],
	[1.0260000000E+04, 4.8674580590E+00, 6.2496752740E+00, 2.4019780922E-01, 2.2081442409E-01, 5.4072007404E-01],
	[1.0265000000E+04, 4.8705610307E+00, 6.2488864786E+00, 2.4056400993E-01, 2.2112928080E-01, 5.4087823710E-01],
	[1.0270000000E+04, 4.8736644680E+00, 6.2480981668E+00, 2.4093058975E-01, 2.2144440538E-01, 5.4103637687E-01],
	[1.0275000000E+04, 4.8767683707E+00, 6.2473103380E+00, 2.4129754888E-01, 2.2175979783E-01, 5.4119449336E-01],
	[1.0280000000E+04, 4.8798727387E+00, 6.2465229918E+00, 2.4166488753E-01, 2.2207545819E-01, 5.4135258660E-01],
	[1.0285000000E+04, 4.8829775719E+00, 6.2457361276E+00, 2.4203261313E-01, 2.2239139258E-01, 5.4151065661E-01],
	[1.0290000000E+04, 4.8860828700E+00, 6.2449497449E+00, 2.4240072868E-01, 2.2270760338E-01, 5.4166870340E-01],
	[1.0295000000E+04, 4.8891886330E+00, 6.2441638431E+00, 2.4276922443E-01, 2.2302408218E-01, 5.4182672708E-01],
	[1.0300000000E+04, 4.8922948606E+00, 6.2433784218E+00, 2.4313810057E-01, 2.2334082901E-01, 5.4198472778E-01],
	[1.0305000000E+04, 4.8954015528E+00, 6.2425934804E+00, 2.4350735733E-01, 2.2365784389E-01, 5.4214270552E-01],
	[1.0310000000E+04, 4.8985087093E+00, 6.2418090183E+00, 2.4387699489E-01, 2.2397512684E-01, 5.4230066029E-01],
	[1.0315000000E+04, 4.9016163301E+00, 6.2410250351E+00, 2.4424701347E-01, 2.2429267788E-01, 5.4245859210E-01],
	[1.0320000000E+04, 4.9047244149E+00, 6.2402415303E+00, 2.4461741328E-01, 2.2461049703E-01, 5.4261650096E-01],
	[1.0325000000E+04, 4.9078329636E+00, 6.2394585032E+00, 2.4498819453E-01, 2.2492858432E-01, 5.4277438686E-01],
	[1.0330000000E+04, 4.9109419760E+00, 6.2386759534E+00, 2.4535935741E-01, 2.2524693975E-01, 5.4293224980E-01],
	[1.0335000000E+04, 4.9140514520E+00, 6.2378938804E+00, 2.4573090214E-01, 2.2556556336E-01, 5.4309008979E-01],
	[1.0340000000E+04, 4.9171613915E+00, 6.2371122836E+00, 2.4610282893E-01, 2.2588445515E-01, 5.4324790683E-01],
	[1.0345000000E+04, 4.9202717942E+00, 6.2363311625E+00, 2.4647513798E-01, 2.2620361516E-01, 5.4340570093E-01],
	[1.0350000000E+04, 4.9233826600E+00, 6.2355505167E+00, 2.4684782950E-01, 2.2652304339E-01, 5.4356347208E-01],
	[1.0355000000E+04, 4.9264939888E+00, 6.2347703455E+00, 2.4722090370E-01, 2.2684273988E-01, 5.4372122028E-01],
	[1.0360000000E+04, 4.9296057804E+00, 6.2339906485E+00, 2.4759436078E-01, 2.2716270463E-01, 5.4387894555E-01],
	[1.0365000000E+04, 4.9327180347E+00, 6.2332114251E+00, 2.4796820095E-01, 2.2748293766E-01, 5.4403664789E-01],
	[1.0370000000E+04, 4.9358307514E+00, 6.2324326748E+00, 2.4834242442E-01, 2.2780343900E-01, 5.4419432729E-01],
	[1.0375000000E+04, 4.9389439305E+00, 6.2316543972E+00, 2.4871703139E-01, 2.2812420866E-01, 5.4435198375E-01],
	[1.0380000000E+04, 4.9420575718E+00, 6.2308765917E+00, 2.4909202208E-01, 2.2844524666E-01, 5.4450961729E-01],
	[1.0385000000E+04, 4.9451716752E+00, 6.2300992577E+00, 2.4946739668E-01, 2.2876655302E-01, 5.4466722791E-01],
	[1.0390000000E+04, 4.9482862404E+00, 6.2293223949E+00, 2.4984315541E-01, 2.2908812776E-01, 5.4482481560E-01],
	[1.0395000000E+04, 4.9514012674E+00, 6.2285460025E+00, 2.5021929848E-01, 2.2940997088E-01, 5.4498238037E-01],
	[1.0400000000E+04, 4.9545167559E+00, 6.2277700803E+00, 2.5059582609E-01, 2.2973208242E-01, 5.4513992222E-01],
	[1.0405000000E+04, 4.9576327058E+00, 6.2269946276E+00, 2.5097273844E-01, 2.3005446238E-01, 5.4529744116E-01],
	[1.0410000000E+04, 4.9607491171E+00, 6.2262196439E+00, 2.5135003575E-01, 2.3037711079E-01, 5.4545493719E-01],
	[1.0415000000E+04, 4.9638659894E+00, 6.2254451287E+00, 2.5172771822E-01, 2.3070002766E-01, 5.4561241031E-01],
	[1.0420000000E+04, 4.9669833227E+00, 6.2246710816E+00, 2.5210578607E-01, 2.3102321300E-01, 5.4576986053E-01],
	[1.0425000000E+04, 4.9701023623E+00, 6.2239011957E+00, 2.5248423949E-01, 2.3134667465E-01, 5.4592728784E-01],
	[1.0430000000E+04, 4.9732249143E+00, 6.2231408148E+00, 2.5286307869E-01, 2.3167042398E-01, 5.4608469226E-01],
	[1.0435000000E+04, 4.9763479301E+00, 6.2223808912E+00, 2.5324230389E-01, 2.3199444198E-01, 5.4624207378E-01],
	[1.0440000000E+04, 4.9794714096E+00, 6.2216214243E+00, 2.5362191528E-01, 2.3231872864E-01, 5.4639943240E-01],
	[1.0445000000E+04, 4.9825953527E+00, 6.2208624138E+00, 2.5400191309E-01, 2.3264328400E-01, 5.4655676814E-01],
	[1.0450000000E+04, 4.9857197591E+00, 6.2201038589E+00, 2.5438229750E-01, 2.3296810805E-01, 5.4671408100E-01],
	[1.0455000000E+04, 4.9888446287E+00, 6.2193457594E+00, 2.5476306874E-01, 2.3329320083E-01, 5.4687137097E-01],
	[1.0460000000E+04, 4.9919699614E+00, 6.2185881147E+00, 2.5514422700E-01, 2.3361856234E-01, 5.4702863806E-01],
	[1.0465000000E+04, 4.9950957570E+00, 6.2178309243E+00, 2.5552577251E-01, 2.3394419260E-01, 5.4718588227E-01],
	[1.0470000000E+04, 4.9982220154E+00, 6.2170741877E+00, 2.5590770545E-01, 2.3427009163E-01, 5.4734310361E-01],
	[1.0475000000E+04, 5.0013487364E+00, 6.2163179044E+00, 2.5629002605E-01, 2.3459625943E-01, 5.4750030209E-01],
	[1.0480000000E+04, 5.0044759198E+00, 6.2155620740E+00, 2.5667273450E-01, 2.3492269603E-01, 5.4765747770E-01],
	[1.0485000000E+04, 5.0076035656E+00, 6.2148066959E+00, 2.5705583102E-01, 2.3524940144E-01, 5.4781463044E-01],
	[1.0490000000E+04, 5.0107316735E+00, 6.2140517697E+00, 2.5743931581E-01, 2.3557637567E-01, 5.4797176033E-01],
	[1.0495000000E+04, 5.0138602434E+00, 6.2132972949E+00, 2.5782318908E-01, 2.3590361874E-01, 5.4812886736E-01],
	[1.0500000000E+04, 5.0169892752E+00, 6.2125432709E+00, 2.5820745104E-01, 2.3623113065E-01, 5.4828595155E-01],
	[1.0505000000E+04, 5.0201187687E+00, 6.2117896974E+00, 2.5859210189E-01, 2.3655891143E-01, 5.4844301288E-01],
	[1.0510000000E+04, 5.0232487237E+00, 6.2110365738E+00, 2.5897714185E-01, 2.3688696109E-01, 5.4860005137E-01],
	[1.0515000000E+04, 5.0263791401E+00, 6.2102838997E+00, 2.5936257112E-01, 2.3721527963E-01, 5.4875706702E-01],
	[1.0520000000E+04, 5.0295100178E+00, 6.2095316745E+00, 2.5974838990E-01, 2.3754386708E-01, 5.4891405984E-01],
	[1.0525000000E+04, 5.0326413565E+00, 6.2087798978E+00, 2.6013459841E-01, 2.3787272345E-01, 5.4907102982E-01],
	[1.0530000000E+04, 5.0357731562E+00, 6.2080285692E+00, 2.6052119685E-01, 2.3820184874E-01, 5.4922797698E-01],
	[1.0535000000E+04, 5.0389054167E+00, 6.2072776880E+00, 2.6090818543E-01, 2.3853124298E-01, 5.4938490131E-01],
	[1.0540000000E+04, 5.0420381378E+00, 6.2065272539E+00, 2.6129556436E-01, 2.3886090617E-01, 5.4954180282E-01],
	[1.0545000000E+04, 5.0451713194E+00, 6.2057772664E+00, 2.6168333385E-01, 2.3919083832E-01, 5.4969868151E-01],
	[1.0550000000E+04, 5.0483049614E+00, 6.2050277249E+00, 2.6207149410E-01, 2.3952103946E-01, 5.4985553739E-01],
	[1.0555000000E+04, 5.0514390635E+00, 6.2042786291E+00, 2.6246004531E-01, 2.3985150958E-01, 5.5001237046E-01],
	[1.0560000000E+04, 5.0545736257E+00, 6.2035299784E+00, 2.6284898771E-01, 2.4018224870E-01, 5.5016918073E-01],
	[1.0565000000E+04, 5.0577086478E+00, 6.2027817724E+00, 2.6323832149E-01, 2.4051325683E-01, 5.5032596819E-01],
	[1.0570000000E+04, 5.0608441296E+00, 6.2020340105E+00, 2.6362804686E-01, 2.4084453398E-01, 5.5048273286E-01],
	[1.0575000000E+04, 5.0639800710E+00, 6.2012866924E+00, 2.6401816394E-01, 2.4117608009E-01, 5.5063947474E-01],
	[1.0580000000E+04, 5.0671164718E+00, 6.2005398175E+00, 2.6440867276E-01, 2.4150789502E-01, 5.5079619383E-01],
	[1.0585000000E+04, 5.0702533320E+00, 6.1997933854E+00, 2.6479957380E-01, 2.4183997901E-01, 5.5095289014E-01],
	[1.0590000000E+04, 5.0733906512E+00, 6.1990473956E+00, 2.6519086726E-01, 2.4217233206E-01, 5.5110956366E-01],
	[1.0595000000E+04, 5.0765317098E+00, 6.1983108226E+00, 2.6558255334E-01, 2.4250497540E-01, 5.5126621441E-01],
	[1.0600000000E+04, 5.0796744497E+00, 6.1975780199E+00, 2.6597463227E-01, 2.4283789584E-01, 5.5142284239E-01],
	[1.0605000000E+04, 5.0828176518E+00, 6.1968456493E+00, 2.6636710424E-01, 2.4317108552E-01, 5.5157944761E-01],
	[1.0610000000E+04, 5.0859613158E+00, 6.1961137105E+00, 2.6675996946E-01, 2.4350454443E-01, 5.5173603006E-01],
	[1.0615000000E+04, 5.0891054416E+00, 6.1953822028E+00, 2.6715322815E-01, 2.4383827260E-01, 5.5189258975E-01],
	[1.0620000000E+04, 5.0922500292E+00, 6.1946511260E+00, 2.6754688050E-01, 2.4417227003E-01, 5.5204912669E-01],
	[1.0625000000E+04, 5.0953950782E+00, 6.1939204794E+00, 2.6794092673E-01, 2.4450653673E-01, 5.5220564088E-01],
	[1.0630000000E+04, 5.0985405887E+00, 6.1931902628E+00, 2.6833536704E-01, 2.4484107271E-01, 5.5236213233E-01],
	[1.0635000000E+04, 5.1016865603E+00, 6.1924604756E+00, 2.6873020164E-01, 2.4517587797E-01, 5.5251860104E-01],
	[1.0640000000E+04, 5.1048329931E+00, 6.1917311173E+00, 2.6912543075E-01, 2.4551095254E-01, 5.5267504701E-01],
	[1.0645000000E+04, 5.1079798868E+00, 6.1910021875E+00, 2.6952105456E-01, 2.4584629641E-01, 5.5283147025E-01],
	[1.0650000000E+04, 5.1111272413E+00, 6.1902736858E+00, 2.6991707328E-01, 2.4618190960E-01, 5.5298787077E-01],
	[1.0655000000E+04, 5.1142750564E+00, 6.1895456117E+00, 2.7031348713E-01, 2.4651779210E-01, 5.5314424857E-01],
	[1.0660000000E+04, 5.1174233320E+00, 6.1888179647E+00, 2.7071029631E-01, 2.4685394394E-01, 5.5330060364E-01],
	[1.0665000000E+04, 5.1205720680E+00, 6.1880907444E+00, 2.7110750102E-01, 2.4719036512E-01, 5.5345693601E-01],
	[1.0670000000E+04, 5.1237212641E+00, 6.1873639504E+00, 2.7150510148E-01, 2.4752705565E-01, 5.5361324567E-01],
	[1.0675000000E+04, 5.1268709203E+00, 6.1866375822E+00, 2.7190309790E-01, 2.4786401552E-01, 5.5376953263E-01],
	[1.0680000000E+04, 5.1300210364E+00, 6.1859116393E+00, 2.7230149048E-01, 2.4820124476E-01, 5.5392579690E-01],
	[1.0685000000E+04, 5.1331716122E+00, 6.1851861214E+00, 2.7270027942E-01, 2.4853874337E-01, 5.5408203847E-01],
	[1.0690000000E+04, 5.1363226476E+00, 6.1844610279E+00, 2.7309946495E-01, 2.4887651135E-01, 5.5423825735E-01],
	[1.0695000000E+04, 5.1394741425E+00, 6.1837363584E+00, 2.7349904726E-01, 2.4921454871E-01, 5.5439445355E-01],
	[1.0700000000E+04, 5.1426260967E+00, 6.1830121125E+00, 2.7389902656E-01, 2.4955285546E-01, 5.5455062708E-01],
	[1.0705000000E+04, 5.1457785100E+00, 6.1822882897E+00, 2.7429940306E-01, 2.4989143160E-01, 5.5470677793E-01],
	[1.0710000000E+04, 5.1489313823E+00, 6.1815648895E+00, 2.7470017698E-01, 2.5023027714E-01, 5.5486290611E-01],
	[1.0715000000E+04, 5.1520847135E+00, 6.1808419116E+00, 2.7510134851E-01, 2.5056939209E-01, 5.5501901164E-01],
	[1.0720000000E+04, 5.1552385034E+00, 6.1801193555E+00, 2.7550291786E-01, 2.5090877645E-01, 5.5517509450E-01],
	[1.0725000000E+04, 5.1583927519E+00, 6.1793972207E+00, 2.7590488525E-01, 2.5124843022E-01, 5.5533115472E-01],
	[1.0730000000E+04, 5.1615474588E+00, 6.1786755069E+00, 2.7630725087E-01, 2.5158835342E-01, 5.5548719229E-01],
	[1.0735000000E+04, 5.1647026240E+00, 6.1779542135E+00, 2.7671001495E-01, 2.5192854605E-01, 5.5564320721E-01],
	[1.0740000000E+04, 5.1678582473E+00, 6.1772333401E+00, 2.7711317768E-01, 2.5226900810E-01, 5.5579919950E-01],
	[1.0745000000E+04, 5.1710143285E+00, 6.1765128863E+00, 2.7751673928E-01, 2.5260973960E-01, 5.5595516916E-01],
	[1.0750000000E+04, 5.1741708676E+00, 6.1757928516E+00, 2.7792069995E-01, 2.5295074053E-01, 5.5611111620E-01],
	[1.0755000000E+04, 5.1773278644E+00, 6.1750732356E+00, 2.7832505990E-01, 2.5329201091E-01, 5.5626704061E-01],
	[1.0760000000E+04, 5.1804853187E+00, 6.1743540379E+00, 2.7872981933E-01, 2.5363355074E-01, 5.5642294241E-01],
	[1.0765000000E+04, 5.1836461843E+00, 6.1736427280E+00, 2.7913497847E-01, 2.5397537976E-01, 5.5657882160E-01],
	[1.0770000000E+04, 5.1868092619E+00, 6.1729362590E+00, 2.7954053751E-01, 2.5431749006E-01, 5.5673467819E-01],
	[1.0775000000E+04, 5.1899728001E+00, 6.1722301988E+00, 2.7994649666E-01, 2.5465986996E-01, 5.5689051218E-01],
	[1.0780000000E+04, 5.1931367989E+00, 6.1715245468E+00, 2.8035285613E-01, 2.5500251947E-01, 5.5704632358E-01],
	[1.0785000000E+04, 5.1963012580E+00, 6.1708193026E+00, 2.8075961613E-01, 2.5534543860E-01, 5.5720211239E-01],
	[1.0790000000E+04, 5.1994661773E+00, 6.1701144658E+00, 2.8116677687E-01, 2.5568862734E-01, 5.5735787861E-01],
	[1.0795000000E+04, 5.2026315567E+00, 6.1694100361E+00, 2.8157433855E-01, 2.5603208571E-01, 5.5751362226E-01],
	[1.0800000000E+04, 5.2057973960E+00, 6.1687060129E+00, 2.8198230138E-01, 2.5637581370E-01, 5.5766934334E-01],
	[1.0805000000E+04, 5.2089636951E+00, 6.1680023958E+00, 2.8239066558E-01, 2.5671981131E-01, 5.5782504186E-01],
	[1.0810000000E+04, 5.2121304538E+00, 6.1672991845E+00, 2.8279943134E-01, 2.5706407855E-01, 5.5798071782E-01],
	[1.0815000000E+04, 5.2152976720E+00, 6.1665963785E+00, 2.8320859889E-01, 2.5740861543E-01, 5.5813637122E-01],
	[1.0820000000E+04, 5.2184653495E+00, 6.1658939774E+00, 2.8361816841E-01, 2.5775342194E-01, 5.5829200208E-01],
	[1.0825000000E+04, 5.2216334862E+00, 6.1651919807E+00, 2.8402814013E-01, 2.5809849808E-01, 5.5844761039E-01],
	[1.0830000000E+04, 5.2248020820E+00, 6.1644903880E+00, 2.8443851426E-01, 2.5844384386E-01, 5.5860319617E-01],
	[1.0835000000E+04, 5.2279711366E+00, 6.1637891990E+00, 2.8484929099E-01, 2.5878945928E-01, 5.5875875942E-01],
	[1.0840000000E+04, 5.2311406500E+00, 6.1630884132E+00, 2.8526047054E-01, 2.5913534433E-01, 5.5891430014E-01],
	[1.0845000000E+04, 5.2343106220E+00, 6.1623880302E+00, 2.8567205311E-01, 2.5948149903E-01, 5.5906981835E-01],
	[1.0850000000E+04, 5.2374810525E+00, 6.1616880495E+00, 2.8608403893E-01, 2.5982792338E-01, 5.5922531404E-01],
	[1.0855000000E+04, 5.2406519413E+00, 6.1609884708E+00, 2.8649642818E-01, 2.6017461736E-01, 5.5938078722E-01],
	[1.0860000000E+04, 5.2438232882E+00, 6.1602892936E+00, 2.8690922108E-01, 2.6052158099E-01, 5.5953623791E-01],
	[1.0865000000E+04, 5.2469950932E+00, 6.1595905176E+00, 2.8732241784E-01, 2.6086881426E-01, 5.5969166610E-01],
	[1.0870000000E+04, 5.2501673561E+00, 6.1588921422E+00, 2.8773601867E-01, 2.6121631718E-01, 5.5984707181E-01],
	[1.0875000000E+04, 5.2533400767E+00, 6.1581941672E+00, 2.8815002378E-01, 2.6156408974E-01, 5.6000245503E-01],
	[1.0880000000E+04, 5.2565132548E+00, 6.1574965920E+00, 2.8856443337E-01, 2.6191213195E-01, 5.6015781577E-01],
	[1.0885000000E+04, 5.2596868905E+00, 6.1567994163E+00, 2.8897924765E-01, 2.6226044380E-01, 5.6031315405E-01],
	[1.0890000000E+04, 5.2628609834E+00, 6.1561026397E+00, 2.8939446683E-01, 2.6260902529E-01, 5.6046846986E-01],
	[1.0895000000E+04, 5.2660355335E+00, 6.1554062617E+00, 2.8981009112E-01, 2.6295787643E-01, 5.6062376321E-01],
	[1.0900000000E+04, 5.2692105407E+00, 6.1547102819E+00, 2.9022612073E-01, 2.6330699720E-01, 5.6077903411E-01],
	[1.0905000000E+04, 5.2723860047E+00, 6.1540147000E+00, 2.9064255586E-01, 2.6365638762E-01, 5.6093428257E-01],
	[1.0910000000E+04, 5.2755619254E+00, 6.1533195154E+00, 2.9105939673E-01, 2.6400604768E-01, 5.6108950859E-01],
	[1.0915000000E+04, 5.2787383027E+00, 6.1526247279E+00, 2.9147664353E-01, 2.6435597737E-01, 5.6124471218E-01],
	[1.0920000000E+04, 5.2819151364E+00, 6.1519303370E+00, 2.9189429649E-01, 2.6470617670E-01, 5.6139989334E-01],
	[1.0925000000E+04, 5.2850924265E+00, 6.1512363422E+00, 2.9231235581E-01, 2.6505664567E-01, 5.6155505208E-01],
	[1.0930000000E+04, 5.2882701727E+00, 6.1505427433E+00, 2.9273082169E-01, 2.6540738426E-01, 5.6171018840E-01],
	[1.0935000000E+04, 5.2914483749E+00, 6.1498495397E+00, 2.9314969435E-01, 2.6575839249E-01, 5.6186530232E-01],
	[1.0940000000E+04, 5.2946318368E+00, 6.1491679712E+00, 2.9356897399E-01, 2.6610970353E-01, 5.6202039384E-01],
	[1.0945000000E+04, 5.2978158688E+00, 6.1484870489E+00, 2.9398866083E-01, 2.6646128511E-01, 5.6217546297E-01],
	[1.0950000000E+04, 5.3010003601E+00, 6.1478065129E+00, 2.9440875506E-01, 2.6681313646E-01, 5.6233050971E-01],
	[1.0955000000E+04, 5.3041853104E+00, 6.1471263629E+00, 2.9482925691E-01, 2.6716525759E-01, 5.6248553407E-01],
	[1.0960000000E+04, 5.3073707197E+00, 6.1464465984E+00, 2.9525016657E-01, 2.6751764849E-01, 5.6264053605E-01],
	[1.0965000000E+04, 5.3105565879E+00, 6.1457672190E+00, 2.9567148426E-01, 2.6787030916E-01, 5.6279551567E-01],
	[1.0970000000E+04, 5.3137429147E+00, 6.1450882245E+00, 2.9609321018E-01, 2.6822323959E-01, 5.6295047292E-01],
	[1.0975000000E+04, 5.3169297000E+00, 6.1444096143E+00, 2.9651534454E-01, 2.6857643978E-01, 5.6310540782E-01],
	[1.0980000000E+04, 5.3201169437E+00, 6.1437313881E+00, 2.9693788756E-01, 2.6892990973E-01, 5.6326032038E-01],
	[1.0985000000E+04, 5.3233046456E+00, 6.1430535455E+00, 2.9736083943E-01, 2.6928364943E-01, 5.6341521059E-01],
	[1.0990000000E+04, 5.3264928056E+00, 6.1423760861E+00, 2.9778420038E-01, 2.6963765888E-01, 5.6357007847E-01],
	[1.0995000000E+04, 5.3296814236E+00, 6.1416990094E+00, 2.9820797060E-01, 2.6999193807E-01, 5.6372492402E-01],
	[1.1000000000E+04, 5.3328704994E+00, 6.1410223152E+00, 2.9863215030E-01, 2.7034648701E-01, 5.6387974725E-01],
	[1.1005000000E+04, 5.3360600329E+00, 6.1403460031E+00, 2.9905673970E-01, 2.7070130568E-01, 5.6403454817E-01],
	[1.1010000000E+04, 5.3392500239E+00, 6.1396700725E+00, 2.9948173900E-01, 2.7105639408E-01, 5.6418932678E-01],
	[1.1015000000E+04, 5.3424404723E+00, 6.1389945232E+00, 2.9990714842E-01, 2.7141175221E-01, 5.6434408309E-01],
	[1.1020000000E+04, 5.3456313779E+00, 6.1383193548E+00, 3.0033296815E-01, 2.7176738006E-01, 5.6449881711E-01],
	[1.1025000000E+04, 5.3488227406E+00, 6.1376445668E+00, 3.0075919841E-01, 2.7212327762E-01, 5.6465352884E-01],
	[1.1030000000E+04, 5.3520145603E+00, 6.1369701590E+00, 3.0118583940E-01, 2.7247944489E-01, 5.6480821830E-01],
	[1.1035000000E+04, 5.3552068368E+00, 6.1362961308E+00, 3.0161289135E-01, 2.7283588187E-01, 5.6496288548E-01],
	[1.1040000000E+04, 5.3583995700E+00, 6.1356224820E+00, 3.0204035444E-01, 2.7319258855E-01, 5.6511753039E-01],
	[1.1045000000E+04, 5.3615927597E+00, 6.1349492120E+00, 3.0246822890E-01, 2.7354956491E-01, 5.6527215305E-01],
	[1.1050000000E+04, 5.3647864058E+00, 6.1342763206E+00, 3.0289651493E-01, 2.7390681097E-01, 5.6542675346E-01],
	[1.1055000000E+04, 5.3679805081E+00, 6.1336038074E+00, 3.0332521273E-01, 2.7426432670E-01, 5.6558133163E-01],
	[1.1060000000E+04, 5.3711750666E+00, 6.1329316720E+00, 3.0375432253E-01, 2.7462211210E-01, 5.6573588755E-01],
	[1.1065000000E+04, 5.3743700810E+00, 6.1322599139E+00, 3.0418384452E-01, 2.7498016717E-01, 5.6589042125E-01],
	[1.1070000000E+04, 5.3775655512E+00, 6.1315885329E+00, 3.0461377892E-01, 2.7533849190E-01, 5.6604493273E-01],
	[1.1075000000E+04, 5.3807614772E+00, 6.1309175285E+00, 3.0504412594E-01, 2.7569708628E-01, 5.6619942199E-01],
	[1.1080000000E+04, 5.3839578587E+00, 6.1302469003E+00, 3.0547488577E-01, 2.7605595030E-01, 5.6635388905E-01],
	[1.1085000000E+04, 5.3871546956E+00, 6.1295766480E+00, 3.0590605864E-01, 2.7641508395E-01, 5.6650833390E-01],
	[1.1090000000E+04, 5.3903519877E+00, 6.1289067712E+00, 3.0633764475E-01, 2.7677448724E-01, 5.6666275656E-01],
	[1.1095000000E+04, 5.3935497350E+00, 6.1282372695E+00, 3.0676964430E-01, 2.7713416014E-01, 5.6681715704E-01],
	[1.1100000000E+04, 5.3967479372E+00, 6.1275681426E+00, 3.0720205752E-01, 2.7749410265E-01, 5.6697153534E-01],
	[1.1105000000E+04, 5.3999465943E+00, 6.1268993900E+00, 3.0763488460E-01, 2.7785431477E-01, 5.6712589147E-01],
	[1.1110000000E+04, 5.4031457061E+00, 6.1262310113E+00, 3.0806812576E-01, 2.7821479648E-01, 5.6728022543E-01],
	[1.1115000000E+04, 5.4063492152E+00, 6.1255715561E+00, 3.0850178120E-01, 2.7857557593E-01, 5.6743453724E-01],
	[1.1120000000E+04, 5.4095543639E+00, 6.1249150304E+00, 3.0893585113E-01, 2.7893663353E-01, 5.6758882685E-01],
	[1.1125000000E+04, 5.4127599706E+00, 6.1242588703E+00, 3.0937033576E-01, 2.7929796086E-01, 5.6774309421E-01],
	[1.1130000000E+04, 5.4159660352E+00, 6.1236030752E+00, 3.0980523531E-01, 2.7965955792E-01, 5.6789733930E-01],
	[1.1135000000E+04, 5.4191725576E+00, 6.1229476448E+00, 3.1024054997E-01, 2.8002142468E-01, 5.6805156211E-01],
	[1.1140000000E+04, 5.4223795376E+00, 6.1222925788E+00, 3.1067627997E-01, 2.8038356115E-01, 5.6820576262E-01],
	[1.1145000000E+04, 5.4255869752E+00, 6.1216378767E+00, 3.1111242549E-01, 2.8074596730E-01, 5.6835994084E-01],
	[1.1150000000E+04, 5.4287948700E+00, 6.1209835383E+00, 3.1154898677E-01, 2.8110864314E-01, 5.6851409674E-01],
	[1.1155000000E+04, 5.4320032221E+00, 6.1203295631E+00, 3.1198596400E-01, 2.8147158865E-01, 5.6866823032E-01],
	[1.1160000000E+04, 5.4352120312E+00, 6.1196759509E+00, 3.1242335739E-01, 2.8183480383E-01, 5.6882234157E-01],
	[1.1165000000E+04, 5.4384212973E+00, 6.1190227011E+00, 3.1286116715E-01, 2.8219828865E-01, 5.6897643047E-01],
	[1.1170000000E+04, 5.4416310201E+00, 6.1183698135E+00, 3.1329939350E-01, 2.8256204311E-01, 5.6913049703E-01],
	[1.1175000000E+04, 5.4448411996E+00, 6.1177172877E+00, 3.1373803664E-01, 2.8292606721E-01, 5.6928454122E-01],
	[1.1180000000E+04, 5.4480518356E+00, 6.1170651234E+00, 3.1417709677E-01, 2.8329036092E-01, 5.6943856303E-01],
	[1.1185000000E+04, 5.4512629280E+00, 6.1164133201E+00, 3.1461927750E-01, 2.8365712172E-01, 5.6959256247E-01],
	[1.1190000000E+04, 5.4544744766E+00, 6.1157618775E+00, 3.1506205480E-01, 2.8402429673E-01, 5.6974653950E-01],
	[1.1195000000E+04, 5.4576864813E+00, 6.1151107953E+00, 3.1550525654E-01, 2.8439174580E-01, 5.6990049414E-01],
	[1.1200000000E+04, 5.4608989420E+00, 6.1144600731E+00, 3.1594888294E-01, 2.8475946893E-01, 5.7005442636E-01],
	[1.1205000000E+04, 5.4641118584E+00, 6.1138097106E+00, 3.1639293420E-01, 2.8512746611E-01, 5.7020833616E-01],
	[1.1210000000E+04, 5.4673252306E+00, 6.1131597073E+00, 3.1683741056E-01, 2.8549573732E-01, 5.7036222352E-01],
	[1.1215000000E+04, 5.4705390582E+00, 6.1125100629E+00, 3.1728231222E-01, 2.8586428256E-01, 5.7051608845E-01],
	[1.1220000000E+04, 5.4737533413E+00, 6.1118607770E+00, 3.1772763940E-01, 2.8623310181E-01, 5.7066993091E-01],
	[1.1225000000E+04, 5.4769680796E+00, 6.1112118494E+00, 3.1817339231E-01, 2.8660219507E-01, 5.7082375092E-01],
	[1.1230000000E+04, 5.4801832731E+00, 6.1105632796E+00, 3.1861957118E-01, 2.8697156231E-01, 5.7097754845E-01],
	[1.1235000000E+04, 5.4833989215E+00, 6.1099150674E+00, 3.1906617622E-01, 2.8734120353E-01, 5.7113132350E-01],
	[1.1240000000E+04, 5.4866150248E+00, 6.1092672122E+00, 3.1951320765E-01, 2.8771111873E-01, 5.7128507606E-01],
	[1.1245000000E+04, 5.4898315828E+00, 6.1086197138E+00, 3.1996066568E-01, 2.8808130787E-01, 5.7143880611E-01],
	[1.1250000000E+04, 5.4930485953E+00, 6.1079725718E+00, 3.2040855052E-01, 2.8845177096E-01, 5.7159251366E-01],
	[1.1255000000E+04, 5.4962660623E+00, 6.1073257860E+00, 3.2085686240E-01, 2.8882250798E-01, 5.7174619868E-01],
	[1.1260000000E+04, 5.4994839836E+00, 6.1066793558E+00, 3.2130560154E-01, 2.8919351892E-01, 5.7189986117E-01],
	[1.1265000000E+04, 5.5027023590E+00, 6.1060332809E+00, 3.2175476814E-01, 2.8956480376E-01, 5.7205350112E-01],
	[1.1270000000E+04, 5.5059211885E+00, 6.1053875611E+00, 3.2220436242E-01, 2.8993636250E-01, 5.7220711853E-01],
	[1.1275000000E+04, 5.5091404718E+00, 6.1047421960E+00, 3.2265438461E-01, 2.9030819511E-01, 5.7236071337E-01],
	[1.1280000000E+04, 5.5123602088E+00, 6.1040971851E+00, 3.2310483491E-01, 2.9068030159E-01, 5.7251428564E-01],
	[1.1285000000E+04, 5.5155803995E+00, 6.1034525282E+00, 3.2355571355E-01, 2.9105268192E-01, 5.7266783534E-01],
	[1.1290000000E+04, 5.5188010437E+00, 6.1028082249E+00, 3.2400702074E-01, 2.9142533608E-01, 5.7282136245E-01],
	[1.1295000000E+04, 5.5220274492E+00, 6.1021749514E+00, 3.2445875670E-01, 2.9179830331E-01, 5.7297486696E-01],
	[1.1300000000E+04, 5.5252543412E+00, 6.1015420832E+00, 3.2491092164E-01, 2.9217154473E-01, 5.7312834887E-01],
	[1.1305000000E+04, 5.5284816902E+00, 6.1009095605E+00, 3.2536351578E-01, 2.9254506012E-01, 5.7328180816E-01],
	[1.1310000000E+04, 5.5317094959E+00, 6.1002773830E+00, 3.2581653933E-01, 2.9291884947E-01, 5.7343524483E-01],
	[1.1315000000E+04, 5.5349377583E+00, 6.0996455504E+00, 3.2626999252E-01, 2.9329291275E-01, 5.7358865887E-01],
	[1.1320000000E+04, 5.5381664773E+00, 6.0990140623E+00, 3.2672387556E-01, 2.9366724995E-01, 5.7374205026E-01],
	[1.1325000000E+04, 5.5413956526E+00, 6.0983829185E+00, 3.2717818867E-01, 2.9404186107E-01, 5.7389541901E-01],
	[1.1330000000E+04, 5.5446252841E+00, 6.0977521185E+00, 3.2763293206E-01, 2.9441674608E-01, 5.7404876509E-01],
	[1.1335000000E+04, 5.5478553717E+00, 6.0971216620E+00, 3.2808810595E-01, 2.9479190496E-01, 5.7420208850E-01],
	[1.1340000000E+04, 5.5510859153E+00, 6.0964915487E+00, 3.2854371056E-01, 2.9516733771E-01, 5.7435538924E-01],
	[1.1345000000E+04, 5.5543169148E+00, 6.0958617782E+00, 3.2899974609E-01, 2.9554304431E-01, 5.7450866729E-01],
	[1.1350000000E+04, 5.5575483699E+00, 6.0952323503E+00, 3.2945621278E-01, 2.9591902474E-01, 5.7466192264E-01],
	[1.1355000000E+04, 5.5607802806E+00, 6.0946032645E+00, 3.2991311084E-01, 2.9629527898E-01, 5.7481515529E-01],
	[1.1360000000E+04, 5.5640126467E+00, 6.0939745205E+00, 3.3037044048E-01, 2.9667180703E-01, 5.7496836522E-01],
	[1.1365000000E+04, 5.5672454681E+00, 6.0933461181E+00, 3.3082820192E-01, 2.9704860885E-01, 5.7512155243E-01],
	[1.1370000000E+04, 5.5704787446E+00, 6.0927180568E+00, 3.3128639537E-01, 2.9742568445E-01, 5.7527471691E-01],
	[1.1375000000E+04, 5.5737124762E+00, 6.0920903363E+00, 3.3174502106E-01, 2.9780303379E-01, 5.7542785866E-01],
	[1.1380000000E+04, 5.5769466626E+00, 6.0914629563E+00, 3.3220407920E-01, 2.9818065686E-01, 5.7558097765E-01],
	[1.1385000000E+04, 5.5801813037E+00, 6.0908359165E+00, 3.3266357001E-01, 2.9855855365E-01, 5.7573407389E-01],
	[1.1390000000E+04, 5.5834163995E+00, 6.0902092165E+00, 3.3312349370E-01, 2.9893672413E-01, 5.7588714736E-01],
	[1.1395000000E+04, 5.5866519498E+00, 6.0895828560E+00, 3.3358385048E-01, 2.9931516830E-01, 5.7604019805E-01],
	[1.1400000000E+04, 5.5898879543E+00, 6.0889568346E+00, 3.3404464059E-01, 2.9969388612E-01, 5.7619322597E-01],
	[1.1405000000E+04, 5.5931244131E+00, 6.0883311521E+00, 3.3450586423E-01, 3.0007287759E-01, 5.7634623109E-01],
	[1.1410000000E+04, 5.5963613259E+00, 6.0877058081E+00, 3.3496752163E-01, 3.0045214269E-01, 5.7649921342E-01],
	[1.1415000000E+04, 5.5995986927E+00, 6.0870808022E+00, 3.3542961298E-01, 3.0083168139E-01, 5.7665217293E-01],
	[1.1420000000E+04, 5.6028365132E+00, 6.0864561341E+00, 3.3589213853E-01, 3.0121149368E-01, 5.7680510963E-01],
	[1.1425000000E+04, 5.6060747874E+00, 6.0858318036E+00, 3.3635509847E-01, 3.0159157954E-01, 5.7695802351E-01],
	[1.1430000000E+04, 5.6093135151E+00, 6.0852078102E+00, 3.3681849304E-01, 3.0197193895E-01, 5.7711091456E-01],
	[1.1435000000E+04, 5.6125526962E+00, 6.0845841537E+00, 3.3728232244E-01, 3.0235257189E-01, 5.7726378276E-01],
	[1.1440000000E+04, 5.6157923306E+00, 6.0839608337E+00, 3.3774658689E-01, 3.0273347834E-01, 5.7741662811E-01],
	[1.1445000000E+04, 5.6190324180E+00, 6.0833378498E+00, 3.3821128661E-01, 3.0311465829E-01, 5.7756945061E-01],
	[1.1450000000E+04, 5.6222729585E+00, 6.0827152018E+00, 3.3867642182E-01, 3.0349611170E-01, 5.7772225024E-01],
	[1.1455000000E+04, 5.6255139518E+00, 6.0820928894E+00, 3.3914199273E-01, 3.0387783857E-01, 5.7787502700E-01],
	[1.1460000000E+04, 5.6287553978E+00, 6.0814709121E+00, 3.3960799955E-01, 3.0425983887E-01, 5.7802778088E-01],
	[1.1465000000E+04, 5.6319972964E+00, 6.0808492697E+00, 3.4007444252E-01, 3.0464211258E-01, 5.7818051186E-01],
	[1.1470000000E+04, 5.6352396474E+00, 6.0802279619E+00, 3.4054132184E-01, 3.0502465968E-01, 5.7833321995E-01],
	[1.1475000000E+04, 5.6384860241E+00, 6.0796136645E+00, 3.4100863773E-01, 3.0540750748E-01, 5.7848590514E-01],
	[1.1480000000E+04, 5.6417348345E+00, 6.0790033915E+00, 3.4147639041E-01, 3.0579064391E-01, 5.7863856741E-01],
	[1.1485000000E+04, 5.6449841009E+00, 6.0783934454E+00, 3.4194458009E-01, 3.0617405385E-01, 5.7879120676E-01],
	[1.1490000000E+04, 5.6482338231E+00, 6.0777838260E+00, 3.4241320699E-01, 3.0655773727E-01, 5.7894382318E-01],
	[1.1495000000E+04, 5.6514840011E+00, 6.0771745329E+00, 3.4288227134E-01, 3.0694169416E-01, 5.7909641666E-01],
	[1.1500000000E+04, 5.6547346347E+00, 6.0765655658E+00, 3.4335177334E-01, 3.0732592450E-01, 5.7924898720E-01],
	[1.1505000000E+04, 5.6579857238E+00, 6.0759569244E+00, 3.4382171321E-01, 3.0771042825E-01, 5.7940153479E-01],
	[1.1510000000E+04, 5.6612372682E+00, 6.0753486084E+00, 3.4429209117E-01, 3.0809520541E-01, 5.7955405942E-01],
	[1.1515000000E+04, 5.6644892679E+00, 6.0747406175E+00, 3.4476290744E-01, 3.0848025595E-01, 5.7970656108E-01],
	[1.1520000000E+04, 5.6677417226E+00, 6.0741329513E+00, 3.4523416223E-01, 3.0886557985E-01, 5.7985903976E-01],
	[1.1525000000E+04, 5.6709946322E+00, 6.0735256095E+00, 3.4570585577E-01, 3.0925117708E-01, 5.8001149546E-01],
	[1.1530000000E+04, 5.6742479967E+00, 6.0729185919E+00, 3.4617798826E-01, 3.0963704762E-01, 5.8016392817E-01],
	[1.1535000000E+04, 5.6775018158E+00, 6.0723118980E+00, 3.4665055993E-01, 3.1002319145E-01, 5.8031633788E-01],
	[1.1540000000E+04, 5.6807560894E+00, 6.0717055277E+00, 3.4712357099E-01, 3.1040960855E-01, 5.8046872459E-01],
	[1.1545000000E+04, 5.6840108175E+00, 6.0710994805E+00, 3.4759702166E-01, 3.1079629889E-01, 5.8062108828E-01],
	[1.1550000000E+04, 5.6872659998E+00, 6.0704937562E+00, 3.4807091216E-01, 3.1118326245E-01, 5.8077342896E-01],
	[1.1555000000E+04, 5.6905216363E+00, 6.0698883545E+00, 3.4854524270E-01, 3.1157049920E-01, 5.8092574660E-01],
	[1.1560000000E+04, 5.6937777268E+00, 6.0692832750E+00, 3.4902001351E-01, 3.1195800913E-01, 5.8107804121E-01],
	[1.1565000000E+04, 5.6970342712E+00, 6.0686785174E+00, 3.4949522479E-01, 3.1234579220E-01, 5.8123031278E-01],
	[1.1570000000E+04, 5.7002912693E+00, 6.0680740815E+00, 3.4997087677E-01, 3.1273384840E-01, 5.8138256130E-01],
	[1.1575000000E+04, 5.7035487210E+00, 6.0674699669E+00, 3.5044696966E-01, 3.1312217769E-01, 5.8153478676E-01],
	[1.1580000000E+04, 5.7068066261E+00, 6.0668661733E+00, 3.5092350368E-01, 3.1351078006E-01, 5.8168698915E-01],
	[1.1585000000E+04, 5.7100649847E+00, 6.0662627003E+00, 3.5140047905E-01, 3.1389965548E-01, 5.8183916848E-01],
	[1.1590000000E+04, 5.7133237964E+00, 6.0656595478E+00, 3.5187789599E-01, 3.1428880392E-01, 5.8199132472E-01],
	[1.1595000000E+04, 5.7165830612E+00, 6.0650567154E+00, 3.5235575470E-01, 3.1467822536E-01, 5.8214345789E-01],
	[1.1600000000E+04, 5.7198427789E+00, 6.0644542027E+00, 3.5283405542E-01, 3.1506791978E-01, 5.8229556795E-01],
	[1.1605000000E+04, 5.7231029495E+00, 6.0638520094E+00, 3.5331279835E-01, 3.1545788714E-01, 5.8244765492E-01],
	[1.1610000000E+04, 5.7263635727E+00, 6.0632501354E+00, 3.5379198372E-01, 3.1584812743E-01, 5.8259971878E-01],
	[1.1615000000E+04, 5.7296246485E+00, 6.0626485802E+00, 3.5427161174E-01, 3.1623864061E-01, 5.8275175953E-01],
	[1.1620000000E+04, 5.7328861767E+00, 6.0620473435E+00, 3.5475168262E-01, 3.1662942666E-01, 5.8290377715E-01],
	[1.1625000000E+04, 5.7361481572E+00, 6.0614464251E+00, 3.5523219660E-01, 3.1702048555E-01, 5.8305577165E-01],
	[1.1630000000E+04, 5.7394105898E+00, 6.0608458246E+00, 3.5571315387E-01, 3.1741181727E-01, 5.8320774302E-01],
	[1.1635000000E+04, 5.7426734745E+00, 6.0602455417E+00, 3.5619455467E-01, 3.1780342177E-01, 5.8335969124E-01],
	[1.1640000000E+04, 5.7459368110E+00, 6.0596455762E+00, 3.5667639921E-01, 3.1819529903E-01, 5.8351161631E-01],
	[1.1645000000E+04, 5.7492005993E+00, 6.0590459276E+00, 3.5715868770E-01, 3.1858744903E-01, 5.8366351823E-01],
	[1.1650000000E+04, 5.7524648392E+00, 6.0584465958E+00, 3.5764142036E-01, 3.1897987173E-01, 5.8381539699E-01],
	[1.1655000000E+04, 5.7557295306E+00, 6.0578475804E+00, 3.5812459742E-01, 3.1937256712E-01, 5.8396725258E-01],
	[1.1660000000E+04, 5.7589987556E+00, 6.0572559702E+00, 3.5860821908E-01, 3.1976556750E-01, 5.8411908499E-01],
	[1.1665000000E+04, 5.7622701218E+00, 6.0566675991E+00, 3.5909228557E-01, 3.2015885403E-01, 5.8427089422E-01],
	[1.1670000000E+04, 5.7655419432E+00, 6.0560795373E+00, 3.5957679710E-01, 3.2055241334E-01, 5.8442268026E-01],
	[1.1675000000E+04, 5.7688142196E+00, 6.0554917845E+00, 3.6006175390E-01, 3.2094624542E-01, 5.8457444311E-01],
	[1.1680000000E+04, 5.7720869509E+00, 6.0549043403E+00, 3.6054715617E-01, 3.2134035022E-01, 5.8472618276E-01],
	[1.1685000000E+04, 5.7753601370E+00, 6.0543172045E+00, 3.6103300413E-01, 3.2173472773E-01, 5.8487789919E-01],
	[1.1690000000E+04, 5.7786337777E+00, 6.0537303768E+00, 3.6151929801E-01, 3.2212937791E-01, 5.8502959242E-01],
	[1.1695000000E+04, 5.7819078729E+00, 6.0531438568E+00, 3.6200603802E-01, 3.2252430073E-01, 5.8518126242E-01],
	[1.1700000000E+04, 5.7851824226E+00, 6.0525576444E+00, 3.6249322438E-01, 3.2291949617E-01, 5.8533290919E-01],
	[1.1705000000E+04, 5.7884574265E+00, 6.0519717391E+00, 3.6298085730E-01, 3.2331496420E-01, 5.8548453273E-01],
	[1.1710000000E+04, 5.7917328845E+00, 6.0513861408E+00, 3.6346893701E-01, 3.2371070479E-01, 5.8563613303E-01],
	[1.1715000000E+04, 5.7950087964E+00, 6.0508008491E+00, 3.6395746371E-01, 3.2410671790E-01, 5.8578771009E-01],
	[1.1720000000E+04, 5.7982851623E+00, 6.0502158637E+00, 3.6444643764E-01, 3.2450300351E-01, 5.8593926389E-01],
	[1.1725000000E+04, 5.8015619819E+00, 6.0496311843E+00, 3.6493585900E-01, 3.2489956159E-01, 5.8609079443E-01],
	[1.1730000000E+04, 5.8048392551E+00, 6.0490468107E+00, 3.6542572801E-01, 3.2529639210E-01, 5.8624230170E-01],
	[1.1735000000E+04, 5.8081169817E+00, 6.0484627425E+00, 3.6591604490E-01, 3.2569349503E-01, 5.8639378571E-01],
	[1.1740000000E+04, 5.8113951617E+00, 6.0478789795E+00, 3.6640680987E-01, 3.2609087033E-01, 5.8654524643E-01],
	[1.1745000000E+04, 5.8146737949E+00, 6.0472955214E+00, 3.6689802315E-01, 3.2648851797E-01, 5.8669668388E-01],
	[1.1750000000E+04, 5.8179528811E+00, 6.0467123678E+00, 3.6738968496E-01, 3.2688643793E-01, 5.8684809803E-01],
	[1.1755000000E+04, 5.8212324204E+00, 6.0461295185E+00, 3.6788179551E-01, 3.2728463017E-01, 5.8699948889E-01],
	[1.1760000000E+04, 5.8245124124E+00, 6.0455469733E+00, 3.6837435501E-01, 3.2768309467E-01, 5.8715085644E-01],
	[1.1765000000E+04, 5.8277928571E+00, 6.0449647318E+00, 3.6886736370E-01, 3.2808183138E-01, 5.8730220069E-01],
	[1.1770000000E+04, 5.8310737544E+00, 6.0443827937E+00, 3.6936082177E-01, 3.2848084029E-01, 5.8745352162E-01],
	[1.1775000000E+04, 5.8343551041E+00, 6.0438011587E+00, 3.6985472947E-01, 3.2888012135E-01, 5.8760481923E-01],
	[1.1780000000E+04, 5.8376369060E+00, 6.0432198266E+00, 3.7034908699E-01, 3.2927967453E-01, 5.8775609352E-01],
	[1.1785000000E+04, 5.8409191602E+00, 6.0426387971E+00, 3.7084389456E-01, 3.2967949981E-01, 5.8790734447E-01],
	[1.1790000000E+04, 5.8442018664E+00, 6.0420580699E+00, 3.7133915239E-01, 3.3007959714E-01, 5.8805857209E-01],
	[1.1795000000E+04, 5.8474850245E+00, 6.0414776447E+00, 3.7183486071E-01, 3.3047996651E-01, 5.8820977636E-01],
	[1.1800000000E+04, 5.8507686344E+00, 6.0408975212E+00, 3.7233101973E-01, 3.3088060786E-01, 5.8836095729E-01],
	[1.1805000000E+04, 5.8540526959E+00, 6.0403176991E+00, 3.7282762967E-01, 3.3128152118E-01, 5.8851211485E-01],
	[1.1810000000E+04, 5.8573372089E+00, 6.0397381782E+00, 3.7332469075E-01, 3.3168270642E-01, 5.8866324906E-01],
	[1.1815000000E+04, 5.8606221734E+00, 6.0391589581E+00, 3.7382220318E-01, 3.3208416356E-01, 5.8881435990E-01],
	[1.1820000000E+04, 5.8639075891E+00, 6.0385800387E+00, 3.7432016719E-01, 3.3248589256E-01, 5.8896544737E-01],
	[1.1825000000E+04, 5.8671934559E+00, 6.0380014195E+00, 3.7481859431E-01, 3.3288790231E-01, 5.8911651146E-01],
	[1.1830000000E+04, 5.8704797737E+00, 6.0374231003E+00, 3.7531747985E-01, 3.3329018890E-01, 5.8926755217E-01],
	[1.1835000000E+04, 5.8737665424E+00, 6.0368450809E+00, 3.7581681766E-01, 3.3369274729E-01, 5.8941856949E-01],
	[1.1840000000E+04, 5.8770537619E+00, 6.0362673609E+00, 3.7631660796E-01, 3.3409557742E-01, 5.8956956342E-01],
	[1.1845000000E+04, 5.8803424918E+00, 6.0356916529E+00, 3.7681685097E-01, 3.3449868796E-01, 5.8972053394E-01],
	[1.1850000000E+04, 5.8836366017E+00, 6.0351242031E+00, 3.7731754691E-01, 3.3490211071E-01, 5.8987148106E-01],
	[1.1855000000E+04, 5.8869311662E+00, 6.0345570460E+00, 3.7781869600E-01, 3.3530580530E-01, 5.9002240477E-01],
	[1.1860000000E+04, 5.8902261850E+00, 6.0339901813E+00, 3.7832029844E-01, 3.3570977170E-01, 5.9017330506E-01],
	[1.1865000000E+04, 5.8935216582E+00, 6.0334236088E+00, 3.7882235447E-01, 3.3611400989E-01, 5.9032418193E-01],
	[1.1870000000E+04, 5.8968175855E+00, 6.0328573281E+00, 3.7932486431E-01, 3.3651851981E-01, 5.9047503538E-01],
	[1.1875000000E+04, 5.9001139668E+00, 6.0322913390E+00, 3.7982782815E-01, 3.3692330145E-01, 5.9062586539E-01],
	[1.1880000000E+04, 5.9034108020E+00, 6.0317256413E+00, 3.8033124624E-01, 3.3732835475E-01, 5.9077667196E-01],
	[1.1885000000E+04, 5.9067080910E+00, 6.0311602346E+00, 3.8083511878E-01, 3.3773367969E-01, 5.9092745508E-01],
	[1.1890000000E+04, 5.9100058336E+00, 6.0305951187E+00, 3.8133944599E-01, 3.3813927623E-01, 5.9107821467E-01],
	[1.1895000000E+04, 5.9133040297E+00, 6.0300302933E+00, 3.8184422808E-01, 3.3854514434E-01, 5.9122895069E-01],
	[1.1900000000E+04, 5.9166026791E+00, 6.0294657582E+00, 3.8234946529E-01, 3.3895128397E-01, 5.9137966313E-01],
	[1.1905000000E+04, 5.9199017819E+00, 6.0289015130E+00, 3.8285515783E-01, 3.3935769509E-01, 5.9153035196E-01],
	[1.1910000000E+04, 5.9232013377E+00, 6.0283375575E+00, 3.8336130591E-01, 3.3976437766E-01, 5.9168101718E-01],
	[1.1915000000E+04, 5.9265013465E+00, 6.0277738915E+00, 3.8386790975E-01, 3.4017133165E-01, 5.9183165877E-01],
	[1.1920000000E+04, 5.9298018082E+00, 6.0272105146E+00, 3.8437496957E-01, 3.4057855702E-01, 5.9198227672E-01],
	[1.1925000000E+04, 5.9331027227E+00, 6.0266474266E+00, 3.8488248559E-01, 3.4098605373E-01, 5.9213287100E-01],
	[1.1930000000E+04, 5.9364040897E+00, 6.0260846272E+00, 3.8539045803E-01, 3.4139382175E-01, 5.9228344160E-01],
	[1.1935000000E+04, 5.9397059092E+00, 6.0255221162E+00, 3.8589888710E-01, 3.4180186103E-01, 5.9243398851E-01],
	[1.1940000000E+04, 5.9430081811E+00, 6.0249598932E+00, 3.8640777302E-01, 3.4221017153E-01, 5.9258451171E-01],
	[1.1945000000E+04, 5.9463109052E+00, 6.0243979581E+00, 3.8691711602E-01, 3.4261875323E-01, 5.9273501119E-01],
	[1.1950000000E+04, 5.9496140814E+00, 6.0238363105E+00, 3.8742691631E-01, 3.4302760608E-01, 5.9288548693E-01],
	[1.1955000000E+04, 5.9529177096E+00, 6.0232749502E+00, 3.8793717410E-01, 3.4343673004E-01, 5.9303593891E-01],
	[1.1960000000E+04, 5.9562217896E+00, 6.0227138769E+00, 3.8844788963E-01, 3.4384612507E-01, 5.9318636713E-01],
	[1.1965000000E+04, 5.9595263213E+00, 6.0221530903E+00, 3.8895906309E-01, 3.4425579114E-01, 5.9333677155E-01],
	[1.1970000000E+04, 5.9628313046E+00, 6.0215925902E+00, 3.8947069472E-01, 3.4466572820E-01, 5.9348715218E-01],
	[1.1975000000E+04, 5.9661367394E+00, 6.0210323764E+00, 3.8998278473E-01, 3.4507593621E-01, 5.9363750899E-01],
	[1.1980000000E+04, 5.9694426255E+00, 6.0204724485E+00, 3.9049533334E-01, 3.4548641515E-01, 5.9378784197E-01],
	[1.1985000000E+04, 5.9727489628E+00, 6.0199128062E+00, 3.9100834076E-01, 3.4589716495E-01, 5.9393815110E-01],
	[1.1990000000E+04, 5.9760557512E+00, 6.0193534494E+00, 3.9152180723E-01, 3.4630818560E-01, 5.9408843637E-01],
	[1.1995000000E+04, 5.9793629906E+00, 6.0187943777E+00, 3.9203573294E-01, 3.4671947704E-01, 5.9423869777E-01],
	[1.2000000000E+04, 5.9826706808E+00, 6.0182355910E+00, 3.9255011813E-01, 3.4713103923E-01, 5.9438893527E-01],
	[1.2005000000E+04, 5.9859788217E+00, 6.0176770888E+00, 3.9306496301E-01, 3.4754287214E-01, 5.9453914887E-01],
	[1.2010000000E+04, 5.9892874131E+00, 6.0171188710E+00, 3.9358026780E-01, 3.4795497572E-01, 5.9468933854E-01],
	[1.2015000000E+04, 5.9925964550E+00, 6.0165609373E+00, 3.9409603272E-01, 3.4836734993E-01, 5.9483950428E-01],
	[1.2020000000E+04, 5.9959059473E+00, 6.0160032875E+00, 3.9461225798E-01, 3.4877999473E-01, 5.9498964607E-01],
	[1.2025000000E+04, 5.9992158897E+00, 6.0154459212E+00, 3.9512894381E-01, 3.4919291009E-01, 5.9513976389E-01],
	[1.2030000000E+04, 6.0025262822E+00, 6.0148888382E+00, 3.9564609042E-01, 3.4960609595E-01, 5.9528985773E-01],
	[1.2035000000E+04, 6.0058373866E+00, 6.0143324325E+00, 3.9616369803E-01, 3.5001955450E-01, 5.9543992757E-01],
	[1.2040000000E+04, 6.0091548894E+00, 6.0137852547E+00, 3.9668176686E-01, 3.5043333409E-01, 5.9558997341E-01],
	[1.2045000000E+04, 6.0124728461E+00, 6.0132383539E+00, 3.9720029713E-01, 3.5084738427E-01, 5.9573999522E-01],
	[1.2050000000E+04, 6.0157912567E+00, 6.0126917298E+00, 3.9771928906E-01, 3.5126170500E-01, 5.9588999299E-01],
	[1.2055000000E+04, 6.0191101210E+00, 6.0121453821E+00, 3.9823874286E-01, 3.5167629624E-01, 5.9603996670E-01],
	[1.2060000000E+04, 6.0224294389E+00, 6.0115993105E+00, 3.9875865876E-01, 3.5209115794E-01, 5.9618991635E-01],
	[1.2065000000E+04, 6.0257492103E+00, 6.0110535149E+00, 3.9927903696E-01, 3.5250629007E-01, 5.9633984191E-01],
	[1.2070000000E+04, 6.0290694349E+00, 6.0105079950E+00, 3.9979987770E-01, 3.5292169258E-01, 5.9648974338E-01],
	[1.2075000000E+04, 6.0323901128E+00, 6.0099627504E+00, 4.0032118119E-01, 3.5333736542E-01, 5.9663962073E-01],
	[1.2080000000E+04, 6.0357112438E+00, 6.0094177810E+00, 4.0084294764E-01, 3.5375330856E-01, 5.9678947396E-01],
	[1.2085000000E+04, 6.0390328277E+00, 6.0088730866E+00, 4.0136517728E-01, 3.5416952194E-01, 5.9693930305E-01],
	[1.2090000000E+04, 6.0423548645E+00, 6.0083286668E+00, 4.0188787033E-01, 3.5458600554E-01, 5.9708910798E-01],
	[1.2095000000E+04, 6.0456773540E+00, 6.0077845213E+00, 4.0241102700E-01, 3.5500275929E-01, 5.9723888874E-01],
	[1.2100000000E+04, 6.0490002960E+00, 6.0072406501E+00, 4.0293464751E-01, 3.5541978317E-01, 5.9738864531E-01],
	[1.2105000000E+04, 6.0523236905E+00, 6.0066970527E+00, 4.0345873208E-01, 3.5583707712E-01, 5.9753837769E-01],
	[1.2110000000E+04, 6.0556475374E+00, 6.0061537290E+00, 4.0398328093E-01, 3.5625464110E-01, 5.9768808586E-01],
	[1.2115000000E+04, 6.0589718364E+00, 6.0056106787E+00, 4.0450829428E-01, 3.5667247507E-01, 5.9783776979E-01],
	[1.2120000000E+04, 6.0622965875E+00, 6.0050679015E+00, 4.0503377234E-01, 3.5709057898E-01, 5.9798742949E-01],
	[1.2125000000E+04, 6.0656217906E+00, 6.0045253972E+00, 4.0555971534E-01, 3.5750895279E-01, 5.9813706494E-01],
	[1.2130000000E+04, 6.0689474455E+00, 6.0039831656E+00, 4.0608612349E-01, 3.5792759644E-01, 5.9828667611E-01],
	[1.2135000000E+04, 6.0722735521E+00, 6.0034412063E+00, 4.0661299701E-01, 3.5834650990E-01, 5.9843626300E-01],
	[1.2140000000E+04, 6.0756001103E+00, 6.0028995192E+00, 4.0714033613E-01, 3.5876569313E-01, 5.9858582560E-01],
	[1.2145000000E+04, 6.0789271199E+00, 6.0023581041E+00, 4.0766814105E-01, 3.5918514606E-01, 5.9873536388E-01],
	[1.2150000000E+04, 6.0822545809E+00, 6.0018169605E+00, 4.0819641201E-01, 3.5960486867E-01, 5.9888487784E-01],
	[1.2155000000E+04, 6.0855824931E+00, 6.0012760884E+00, 4.0872514921E-01, 3.6002486089E-01, 5.9903436746E-01],
	[1.2160000000E+04, 6.0889108563E+00, 6.0007354874E+00, 4.0925435287E-01, 3.6044512270E-01, 5.9918383273E-01],
	[1.2165000000E+04, 6.0922396705E+00, 6.0001951573E+00, 4.0978402322E-01, 3.6086565403E-01, 5.9933327363E-01],
	[1.2170000000E+04, 6.0955689356E+00, 5.9996550979E+00, 4.1031416048E-01, 3.6128645485E-01, 5.9948269016E-01],
	[1.2175000000E+04, 6.0988986513E+00, 5.9991153089E+00, 4.1084476485E-01, 3.6170752510E-01, 5.9963208228E-01],
	[1.2180000000E+04, 6.1022288177E+00, 5.9985757901E+00, 4.1137583657E-01, 3.6212886474E-01, 5.9978145001E-01],
	[1.2185000000E+04, 6.1055594345E+00, 5.9980365412E+00, 4.1190737585E-01, 3.6255047372E-01, 5.9993079331E-01],
	[1.2190000000E+04, 6.1088905016E+00, 5.9974975620E+00, 4.1243938290E-01, 3.6297235200E-01, 6.0008011217E-01],
	[1.2195000000E+04, 6.1122220189E+00, 5.9969588522E+00, 4.1297185795E-01, 3.6339449952E-01, 6.0022940659E-01],
	[1.2200000000E+04, 6.1155539864E+00, 5.9964204116E+00, 4.1350480122E-01, 3.6381691624E-01, 6.0037867655E-01],
	[1.2205000000E+04, 6.1188864038E+00, 5.9958822400E+00, 4.1403821292E-01, 3.6423960211E-01, 6.0052792203E-01],
	[1.2210000000E+04, 6.1222192710E+00, 5.9953443370E+00, 4.1457209327E-01, 3.6466255708E-01, 6.0067714302E-01],
	[1.2215000000E+04, 6.1255525880E+00, 5.9948067025E+00, 4.1510644250E-01, 3.6508578111E-01, 6.0082633951E-01],
	[1.2220000000E+04, 6.1288863545E+00, 5.9942693362E+00, 4.1564126082E-01, 3.6550927414E-01, 6.0097551148E-01],
	[1.2225000000E+04, 6.1322205706E+00, 5.9937322378E+00, 4.1617654845E-01, 3.6593303612E-01, 6.0112465893E-01],
	[1.2230000000E+04, 6.1355571237E+00, 5.9931980535E+00, 4.1671230561E-01, 3.6635708363E-01, 6.0127378183E-01],
	[1.2235000000E+04, 6.1388986740E+00, 5.9926705047E+00, 4.1724853251E-01, 3.6678144016E-01, 6.0142288018E-01],
	[1.2240000000E+04, 6.1422406778E+00, 5.9921432178E+00, 4.1778522939E-01, 3.6720606571E-01, 6.0157195396E-01],
	[1.2245000000E+04, 6.1455831349E+00, 5.9916161927E+00, 4.1832239645E-01, 3.6763096025E-01, 6.0172100316E-01],
	[1.2250000000E+04, 6.1489260453E+00, 5.9910894291E+00, 4.1886003391E-01, 3.6805612371E-01, 6.0187002776E-01],
	[1.2255000000E+04, 6.1522694087E+00, 5.9905629267E+00, 4.1939814200E-01, 3.6848155605E-01, 6.0201902775E-01],
	[1.2260000000E+04, 6.1556132252E+00, 5.9900366853E+00, 4.1993672093E-01, 3.6890725723E-01, 6.0216800312E-01],
	[1.2265000000E+04, 6.1589574945E+00, 5.9895107047E+00, 4.2047577092E-01, 3.6933322718E-01, 6.0231695386E-01],
	[1.2270000000E+04, 6.1623022165E+00, 5.9889849846E+00, 4.2101529219E-01, 3.6975946587E-01, 6.0246587995E-01],
	[1.2275000000E+04, 6.1656473911E+00, 5.9884595248E+00, 4.2155528496E-01, 3.7018597323E-01, 6.0261478138E-01],
	[1.2280000000E+04, 6.1689930182E+00, 5.9879343251E+00, 4.2209574945E-01, 3.7061274923E-01, 6.0276365814E-01],
	[1.2285000000E+04, 6.1723390977E+00, 5.9874093852E+00, 4.2263668588E-01, 3.7103979380E-01, 6.0291251021E-01],
	[1.2290000000E+04, 6.1756856294E+00, 5.9868847049E+00, 4.2317809446E-01, 3.7146710690E-01, 6.0306133758E-01],
	[1.2295000000E+04, 6.1790326132E+00, 5.9863602840E+00, 4.2371997542E-01, 3.7189468848E-01, 6.0321014024E-01],
	[1.2300000000E+04, 6.1823800490E+00, 5.9858361223E+00, 4.2426232897E-01, 3.7232253849E-01, 6.0335891817E-01],
	[1.2305000000E+04, 6.1857279367E+00, 5.9853122194E+00, 4.2480515534E-01, 3.7275065686E-01, 6.0350767136E-01],
	[1.2310000000E+04, 6.1890762762E+00, 5.9847885752E+00, 4.2534845474E-01, 3.7317904356E-01, 6.0365639981E-01],
	[1.2315000000E+04, 6.1924250672E+00, 5.9842651894E+00, 4.2589222740E-01, 3.7360769853E-01, 6.0380510349E-01],
	[1.2320000000E+04, 6.1957743097E+00, 5.9837420618E+00, 4.2643647352E-01, 3.7403662172E-01, 6.0395378240E-01],
	[1.2325000000E+04, 6.1991240037E+00, 5.9832191922E+00, 4.2698119333E-01, 3.7446581308E-01, 6.0410243651E-01],
	[1.2330000000E+04, 6.2024741489E+00, 5.9826965803E+00, 4.2752638706E-01, 3.7489527254E-01, 6.0425106583E-01],
	[1.2335000000E+04, 6.2058247452E+00, 5.9821742259E+00, 4.2807205491E-01, 3.7532500007E-01, 6.0439967033E-01],
	[1.2340000000E+04, 6.2091757925E+00, 5.9816521288E+00, 4.2861819711E-01, 3.7575499560E-01, 6.0454825000E-01],
	[1.2345000000E+04, 6.2125272907E+00, 5.9811302887E+00, 4.2916481387E-01, 3.7618525909E-01, 6.0469680484E-01],
	[1.2350000000E+04, 6.2158792397E+00, 5.9806087055E+00, 4.2971190542E-01, 3.7661579048E-01, 6.0484533482E-01],
	[1.2355000000E+04, 6.2192316393E+00, 5.9800873788E+00, 4.3025947198E-01, 3.7704658972E-01, 6.0499383994E-01],
	[1.2360000000E+04, 6.2225844895E+00, 5.9795663085E+00, 4.3080751376E-01, 3.7747765675E-01, 6.0514232019E-01],
	[1.2365000000E+04, 6.2259377900E+00, 5.9790454943E+00, 4.3135603098E-01, 3.7790899152E-01, 6.0529077554E-01],
	[1.2370000000E+04, 6.2292915409E+00, 5.9785249360E+00, 4.3190502387E-01, 3.7834059398E-01, 6.0543920600E-01],
	[1.2375000000E+04, 6.2326457419E+00, 5.9780046334E+00, 4.3245449264E-01, 3.7877246407E-01, 6.0558761154E-01],
	[1.2380000000E+04, 6.2360003929E+00, 5.9774845862E+00, 4.3300443751E-01, 3.7920460174E-01, 6.0573599215E-01],
	[1.2385000000E+04, 6.2393554938E+00, 5.9769647942E+00, 4.3355485870E-01, 3.7963700693E-01, 6.0588434783E-01],
	[1.2390000000E+04, 6.2427110446E+00, 5.9764452571E+00, 4.3410575642E-01, 3.8006967959E-01, 6.0603267856E-01],
	[1.2395000000E+04, 6.2460670450E+00, 5.9759259749E+00, 4.3465713091E-01, 3.8050261966E-01, 6.0618098432E-01],
	[1.2400000000E+04, 6.2494234950E+00, 5.9754069471E+00, 4.3520898238E-01, 3.8093582708E-01, 6.0632926511E-01],
	[1.2405000000E+04, 6.2527803944E+00, 5.9748881737E+00, 4.3576131104E-01, 3.8136930181E-01, 6.0647752092E-01],
	[1.2410000000E+04, 6.2561377431E+00, 5.9743696543E+00, 4.3631411712E-01, 3.8180304379E-01, 6.0662575172E-01],
	[1.2415000000E+04, 6.2594955410E+00, 5.9738513887E+00, 4.3686740084E-01, 3.8223705295E-01, 6.0677395752E-01],
	[1.2420000000E+04, 6.2628537879E+00, 5.9733333768E+00, 4.3742116241E-01, 3.8267132925E-01, 6.0692213829E-01],
	[1.2425000000E+04, 6.2662124838E+00, 5.9728156183E+00, 4.3797540206E-01, 3.8310587263E-01, 6.0707029402E-01],
	[1.2430000000E+04, 6.2695777707E+00, 5.9723061316E+00, 4.3853012000E-01, 3.8354073909E-01, 6.0721842471E-01],
	[1.2435000000E+04, 6.2729440382E+00, 5.9717975817E+00, 4.3908531645E-01, 3.8397587755E-01, 6.0736653034E-01],
	[1.2440000000E+04, 6.2763107587E+00, 5.9712892796E+00, 4.3964099164E-01, 3.8441128315E-01, 6.0751461091E-01],
	[1.2445000000E+04, 6.2796779321E+00, 5.9707812250E+00, 4.4019714578E-01, 3.8484695583E-01, 6.0766266638E-01],
	[1.2450000000E+04, 6.2830455584E+00, 5.9702734177E+00, 4.4075377909E-01, 3.8528289554E-01, 6.0781069677E-01],
	[1.2455000000E+04, 6.2864136373E+00, 5.9697658574E+00, 4.4131089179E-01, 3.8571910222E-01, 6.0795870205E-01],
	[1.2460000000E+04, 6.2897821688E+00, 5.9692585440E+00, 4.4186848410E-01, 3.8615557582E-01, 6.0810668221E-01],
	[1.2465000000E+04, 6.2931511528E+00, 5.9687514772E+00, 4.4242655624E-01, 3.8659231627E-01, 6.0825463724E-01],
	[1.2470000000E+04, 6.2965205891E+00, 5.9682446568E+00, 4.4298510843E-01, 3.8702932351E-01, 6.0840256713E-01],
	[1.2475000000E+04, 6.2998904776E+00, 5.9677380825E+00, 4.4354414089E-01, 3.8746659750E-01, 6.0855047187E-01],
	[1.2480000000E+04, 6.3032608182E+00, 5.9672317543E+00, 4.4410365384E-01, 3.8790413817E-01, 6.0869835144E-01],
	[1.2485000000E+04, 6.3066316108E+00, 5.9667256718E+00, 4.4466364750E-01, 3.8834194547E-01, 6.0884620584E-01],
	[1.2490000000E+04, 6.3100028552E+00, 5.9662198348E+00, 4.4522412208E-01, 3.8878001933E-01, 6.0899403505E-01],
	[1.2495000000E+04, 6.3133745513E+00, 5.9657142431E+00, 4.4578507781E-01, 3.8921835970E-01, 6.0914183906E-01],
	[1.2500000000E+04, 6.3167466991E+00, 5.9652088966E+00, 4.4634651491E-01, 3.8965696652E-01, 6.0928961786E-01],
	[1.2505000000E+04, 6.3201192983E+00, 5.9647037949E+00, 4.4690955277E-01, 3.9009669245E-01, 6.0943737144E-01],
	[1.2510000000E+04, 6.3234923489E+00, 5.9641989379E+00, 4.4747307485E-01, 3.9053668609E-01, 6.0958509978E-01],
	[1.2515000000E+04, 6.3268658508E+00, 5.9636943253E+00, 4.4803708137E-01, 3.9097694739E-01, 6.0973280288E-01],
	[1.2520000000E+04, 6.3302398037E+00, 5.9631899569E+00, 4.4860157255E-01, 3.9141747628E-01, 6.0988048073E-01],
	[1.2525000000E+04, 6.3336142077E+00, 5.9626858326E+00, 4.4916654860E-01, 3.9185827271E-01, 6.1002813330E-01],
	[1.2530000000E+04, 6.3369890626E+00, 5.9621819521E+00, 4.4973200976E-01, 3.9229933662E-01, 6.1017576060E-01],
	[1.2535000000E+04, 6.3403643682E+00, 5.9616783151E+00, 4.5029795624E-01, 3.9274066794E-01, 6.1032336261E-01],
	[1.2540000000E+04, 6.3437401245E+00, 5.9611749216E+00, 4.5086438827E-01, 3.9318226662E-01, 6.1047093932E-01],
	[1.2545000000E+04, 6.3471163314E+00, 5.9606717711E+00, 4.5143130607E-01, 3.9362413260E-01, 6.1061849071E-01],
	[1.2550000000E+04, 6.3504929886E+00, 5.9601688637E+00, 4.5199870985E-01, 3.9406626581E-01, 6.1076601678E-01],
	[1.2555000000E+04, 6.3538700961E+00, 5.9596661989E+00, 4.5256659985E-01, 3.9450866620E-01, 6.1091351752E-01],
	[1.2560000000E+04, 6.3572476538E+00, 5.9591637767E+00, 4.5313497629E-01, 3.9495133370E-01, 6.1106099291E-01],
	[1.2565000000E+04, 6.3606256615E+00, 5.9586615967E+00, 4.5370383938E-01, 3.9539426826E-01, 6.1120844294E-01],
	[1.2570000000E+04, 6.3640041192E+00, 5.9581596589E+00, 4.5427318935E-01, 3.9583746980E-01, 6.1135586761E-01],
	[1.2575000000E+04, 6.3673830267E+00, 5.9576579629E+00, 4.5484302642E-01, 3.9628093828E-01, 6.1150326690E-01],
	[1.2580000000E+04, 6.3707623839E+00, 5.9571565086E+00, 4.5541335081E-01, 3.9672467363E-01, 6.1165064079E-01],
	[1.2585000000E+04, 6.3741421906E+00, 5.9566552957E+00, 4.5598416275E-01, 3.9716867579E-01, 6.1179798929E-01],
	[1.2590000000E+04, 6.3775224468E+00, 5.9561543241E+00, 4.5655546246E-01, 3.9761294469E-01, 6.1194531237E-01],
	[1.2595000000E+04, 6.3809031524E+00, 5.9556535935E+00, 4.5712725015E-01, 3.9805748027E-01, 6.1209261004E-01],
	[1.2600000000E+04, 6.3842843071E+00, 5.9551531037E+00, 4.5769952606E-01, 3.9850228248E-01, 6.1223988226E-01],
	[1.2605000000E+04, 6.3876659110E+00, 5.9546528545E+00, 4.5827229040E-01, 3.9894735124E-01, 6.1238712905E-01],
	[1.2610000000E+04, 6.3910479639E+00, 5.9541528457E+00, 4.5884554340E-01, 3.9939268650E-01, 6.1253435043E-01],
	[1.2615000000E+04, 6.3944304656E+00, 5.9536530771E+00, 4.5941928527E-01, 3.9983828819E-01, 6.1268154642E-01],
	[1.2620000000E+04, 6.3978134160E+00, 5.9531535484E+00, 4.5999351625E-01, 4.0028415625E-01, 6.1282871698E-01],
	[1.2625000000E+04, 6.4011968151E+00, 5.9526542595E+00, 4.6056823655E-01, 4.0073029062E-01, 6.1297586211E-01],
	[1.2630000000E+04, 6.4045870905E+00, 5.9521629665E+00, 4.6114344639E-01, 4.0117675168E-01, 6.1312298178E-01],
	[1.2635000000E+04, 6.4079784196E+00, 5.9516726333E+00, 4.6171914600E-01, 4.0162348481E-01, 6.1327007597E-01],
	[1.2640000000E+04, 6.4113702016E+00, 5.9511825345E+00, 4.6229533560E-01, 4.0207048430E-01, 6.1341714466E-01],
	[1.2645000000E+04, 6.4147624364E+00, 5.9506926698E+00, 4.6287201541E-01, 4.0251775009E-01, 6.1356418784E-01],
	[1.2650000000E+04, 6.4181551239E+00, 5.9502030391E+00, 4.6344918565E-01, 4.0296528212E-01, 6.1371120548E-01],
	[1.2655000000E+04, 6.4215482640E+00, 5.9497136422E+00, 4.6402684655E-01, 4.0341308031E-01, 6.1385819757E-01],
	[1.2660000000E+04, 6.4249418565E+00, 5.9492244788E+00, 4.6460499833E-01, 4.0386114460E-01, 6.1400516409E-01],
	[1.2665000000E+04, 6.4283359013E+00, 5.9487355487E+00, 4.6518364121E-01, 4.0430947494E-01, 6.1415210501E-01],
	[1.2670000000E+04, 6.4317303984E+00, 5.9482468518E+00, 4.6576277541E-01, 4.0475807126E-01, 6.1429902032E-01],
	[1.2675000000E+04, 6.4351253475E+00, 5.9477583879E+00, 4.6634240116E-01, 4.0520693348E-01, 6.1444590999E-01],
	[1.2680000000E+04, 6.4385207487E+00, 5.9472701566E+00, 4.6692251868E-01, 4.0565606156E-01, 6.1459277402E-01],
	[1.2685000000E+04, 6.4419166016E+00, 5.9467821580E+00, 4.6750312818E-01, 4.0610545541E-01, 6.1473961238E-01],
	[1.2690000000E+04, 6.4453129064E+00, 5.9462943916E+00, 4.6808422990E-01, 4.0655511498E-01, 6.1488642505E-01],
	[1.2695000000E+04, 6.4487096627E+00, 5.9458068574E+00, 4.6866582405E-01, 4.0700504020E-01, 6.1503321201E-01],
	[1.2700000000E+04, 6.4521068706E+00, 5.9453195551E+00, 4.6924791087E-01, 4.0745523101E-01, 6.1517997324E-01],
	[1.2705000000E+04, 6.4555045298E+00, 5.9448324845E+00, 4.6983049056E-01, 4.0790568733E-01, 6.1532670873E-01],
	[1.2710000000E+04, 6.4589026403E+00, 5.9443456455E+00, 4.7041356335E-01, 4.0835640911E-01, 6.1547341846E-01],
	[1.2715000000E+04, 6.4623012020E+00, 5.9438590378E+00, 4.7099712947E-01, 4.0880739627E-01, 6.1562010240E-01],
	[1.2720000000E+04, 6.4657002147E+00, 5.9433726612E+00, 4.7158118913E-01, 4.0925864876E-01, 6.1576676054E-01],
	[1.2725000000E+04, 6.4690996783E+00, 5.9428865155E+00, 4.7216574256E-01, 4.0971016649E-01, 6.1591339286E-01],
	[1.2730000000E+04, 6.4724995927E+00, 5.9424006006E+00, 4.7275078999E-01, 4.1016194942E-01, 6.1605999934E-01],
	[1.2735000000E+04, 6.4758999578E+00, 5.9419149162E+00, 4.7333633163E-01, 4.1061399746E-01, 6.1620657997E-01],
	[1.2740000000E+04, 6.4793007735E+00, 5.9414294621E+00, 4.7392236771E-01, 4.1106631055E-01, 6.1635313472E-01],
	[1.2745000000E+04, 6.4827020396E+00, 5.9409442381E+00, 4.7450889845E-01, 4.1151888863E-01, 6.1649966357E-01],
	[1.2750000000E+04, 6.4861037560E+00, 5.9404592440E+00, 4.7509592407E-01, 4.1197173163E-01, 6.1664616651E-01],
	[1.2755000000E+04, 6.4895059227E+00, 5.9399744797E+00, 4.7568344479E-01, 4.1242483947E-01, 6.1679264352E-01],
	[1.2760000000E+04, 6.4929085394E+00, 5.9394899449E+00, 4.7627146084E-01, 4.1287821210E-01, 6.1693909458E-01],
	[1.2765000000E+04, 6.4963116061E+00, 5.9390056395E+00, 4.7685997244E-01, 4.1333184944E-01, 6.1708551967E-01],
	[1.2770000000E+04, 6.4997151227E+00, 5.9385215632E+00, 4.7744897981E-01, 4.1378575142E-01, 6.1723191877E-01],
	[1.2775000000E+04, 6.5031190890E+00, 5.9380377158E+00, 4.7803848318E-01, 4.1423991798E-01, 6.1737829187E-01],
	[1.2780000000E+04, 6.5065235050E+00, 5.9375540971E+00, 4.7862848277E-01, 4.1469434904E-01, 6.1752463894E-01],
	[1.2785000000E+04, 6.5099283705E+00, 5.9370707070E+00, 4.7921897879E-01, 4.1514904455E-01, 6.1767095998E-01],
	[1.2790000000E+04, 6.5133336854E+00, 5.9365875452E+00, 4.7980997148E-01, 4.1560400442E-01, 6.1781725495E-01],
	[1.2795000000E+04, 6.5167394495E+00, 5.9361046115E+00, 4.8040146106E-01, 4.1605922859E-01, 6.1796352384E-01],
	[1.2800000000E+04, 6.5201456628E+00, 5.9356219058E+00, 4.8099344774E-01, 4.1651471699E-01, 6.1810976664E-01],
	[1.2805000000E+04, 6.5235523252E+00, 5.9351394279E+00, 4.8158593175E-01, 4.1697046955E-01, 6.1825598332E-01],
	[1.2810000000E+04, 6.5269594365E+00, 5.9346571775E+00, 4.8217891332E-01, 4.1742648620E-01, 6.1840217388E-01],
	[1.2815000000E+04, 6.5303669966E+00, 5.9341751544E+00, 4.8277239266E-01, 4.1788276687E-01, 6.1854833828E-01],
	[1.2820000000E+04, 6.5337750054E+00, 5.9336933586E+00, 4.8336637000E-01, 4.1833931149E-01, 6.1869447651E-01],
	[1.2825000000E+04, 6.5371834628E+00, 5.9332117897E+00, 4.8396084556E-01, 4.1879611999E-01, 6.1884058856E-01],
	[1.2830000000E+04, 6.5405943433E+00, 5.9327326432E+00, 4.8455581957E-01, 4.1925321138E-01, 6.1898667440E-01],
	[1.2835000000E+04, 6.5440111781E+00, 5.9322598395E+00, 4.8515129224E-01, 4.1971061984E-01, 6.1913273402E-01],
	[1.2840000000E+04, 6.5474284661E+00, 5.9317872576E+00, 4.8574726380E-01, 4.2016829222E-01, 6.1927876740E-01],
	[1.2845000000E+04, 6.5508462071E+00, 5.9313148974E+00, 4.8634373448E-01, 4.2062622847E-01, 6.1942477452E-01],
	[1.2850000000E+04, 6.5542644010E+00, 5.9308427585E+00, 4.8694070449E-01, 4.2108442850E-01, 6.1957075537E-01],
	[1.2855000000E+04, 6.5576830476E+00, 5.9303708409E+00, 4.8753817406E-01, 4.2154289225E-01, 6.1971670992E-01],
	[1.2860000000E+04, 6.5611021469E+00, 5.9298991444E+00, 4.8813614340E-01, 4.2200161964E-01, 6.1986263817E-01],
	[1.2865000000E+04, 6.5645216988E+00, 5.9294276687E+00, 4.8873461276E-01, 4.2246061060E-01, 6.2000854008E-01],
	[1.2870000000E+04, 6.5679417030E+00, 5.9289564136E+00, 4.8933358234E-01, 4.2291986507E-01, 6.2015441565E-01],
	[1.2875000000E+04, 6.5713621596E+00, 5.9284853791E+00, 4.8993305236E-01, 4.2337938296E-01, 6.2030026486E-01],
	[1.2880000000E+04, 6.5747830684E+00, 5.9280145648E+00, 4.9053302306E-01, 4.2383916421E-01, 6.2044608768E-01],
	[1.2885000000E+04, 6.5782044293E+00, 5.9275439707E+00, 4.9113349466E-01, 4.2429920875E-01, 6.2059188411E-01],
	[1.2890000000E+04, 6.5816262421E+00, 5.9270735964E+00, 4.9173446737E-01, 4.2475951650E-01, 6.2073765412E-01],
	[1.2895000000E+04, 6.5850485068E+00, 5.9266034419E+00, 4.9233594142E-01, 4.2522008738E-01, 6.2088339769E-01],
	[1.2900000000E+04, 6.5884712232E+00, 5.9261335069E+00, 4.9293791704E-01, 4.2568092134E-01, 6.2102911482E-01],
	[1.2905000000E+04, 6.5918943912E+00, 5.9256637913E+00, 4.9354039444E-01, 4.2614201829E-01, 6.2117480548E-01],
	[1.2910000000E+04, 6.5953180107E+00, 5.9251942948E+00, 4.9414337386E-01, 4.2660337815E-01, 6.2132046965E-01],
	[1.2915000000E+04, 6.5987420817E+00, 5.9247250173E+00, 4.9474685550E-01, 4.2706500087E-01, 6.2146610732E-01],
	[1.2920000000E+04, 6.6021666038E+00, 5.9242559586E+00, 4.9535083960E-01, 4.2752688636E-01, 6.2161171847E-01],
	[1.2925000000E+04, 6.6055915772E+00, 5.9237871185E+00, 4.9595532638E-01, 4.2798903455E-01, 6.2175730308E-01],
	[1.2930000000E+04, 6.6090170016E+00, 5.9233184968E+00, 4.9656031606E-01, 4.2845144536E-01, 6.2190286114E-01],
	[1.2935000000E+04, 6.6124428769E+00, 5.9228500934E+00, 4.9716580886E-01, 4.2891411873E-01, 6.2204839263E-01],
	[1.2940000000E+04, 6.6158692030E+00, 5.9223819080E+00, 4.9777180501E-01, 4.2937705457E-01, 6.2219389753E-01],
	[1.2945000000E+04, 6.6192959798E+00, 5.9219139404E+00, 4.9837830473E-01, 4.2984025282E-01, 6.2233937582E-01],
	[1.2950000000E+04, 6.6227232072E+00, 5.9214461905E+00, 4.9898530825E-01, 4.3030371339E-01, 6.2248482750E-01],
	[1.2955000000E+04, 6.6261508851E+00, 5.9209786581E+00, 4.9959281578E-01, 4.3076743621E-01, 6.2263025253E-01],
	[1.2960000000E+04, 6.6295790133E+00, 5.9205113431E+00, 5.0020082755E-01, 4.3123142122E-01, 6.2277565091E-01],
	[1.2965000000E+04, 6.6330075917E+00, 5.9200442451E+00, 5.0080934378E-01, 4.3169566832E-01, 6.2292102261E-01],
	[1.2970000000E+04, 6.6364366203E+00, 5.9195773641E+00, 5.0141836469E-01, 4.3216017746E-01, 6.2306636762E-01],
	[1.2975000000E+04, 6.6398660989E+00, 5.9191106998E+00, 5.0202789052E-01, 4.3262494854E-01, 6.2321168593E-01],
	[1.2980000000E+04, 6.6432960273E+00, 5.9186442521E+00, 5.0263792147E-01, 4.3308998150E-01, 6.2335697752E-01],
	[1.2985000000E+04, 6.6467264056E+00, 5.9181780207E+00, 5.0324845778E-01, 4.3355527626E-01, 6.2350224236E-01],
	[1.2990000000E+04, 6.6501572335E+00, 5.9177120056E+00, 5.0385949967E-01, 4.3402083274E-01, 6.2364748045E-01],
	[1.2995000000E+04, 6.6535885110E+00, 5.9172462065E+00, 5.0447104736E-01, 4.3448665087E-01, 6.2379269176E-01],
	[1.3000000000E+04, 6.6570202379E+00, 5.9167806232E+00, 5.0508310107E-01, 4.3495273057E-01, 6.2393787628E-01],
	[1.3005000000E+04, 6.6604524141E+00, 5.9163152555E+00, 5.0569566103E-01, 4.3541907176E-01, 6.2408303400E-01],
	[1.3010000000E+04, 6.6638850395E+00, 5.9158501033E+00, 5.0630872746E-01, 4.3588567437E-01, 6.2422816489E-01],
	[1.3015000000E+04, 6.6673181140E+00, 5.9153851664E+00, 5.0692230058E-01, 4.3635253832E-01, 6.2437326895E-01],
	[1.3020000000E+04, 6.6707516375E+00, 5.9149204446E+00, 5.0753638062E-01, 4.3681966352E-01, 6.2451834614E-01],
	[1.3025000000E+04, 6.6741856099E+00, 5.9144559378E+00, 5.0815096780E-01, 4.3728704992E-01, 6.2466339647E-01],
	[1.3030000000E+04, 6.6776200310E+00, 5.9139916456E+00, 5.0876606234E-01, 4.3775469741E-01, 6.2480841990E-01],
	[1.3035000000E+04, 6.6810549008E+00, 5.9135275680E+00, 5.0938166447E-01, 4.3822260594E-01, 6.2495341644E-01],
	[1.3040000000E+04, 6.6844978322E+00, 5.9130715224E+00, 5.0999777440E-01, 4.3869085124E-01, 6.2509838604E-01],
	[1.3045000000E+04, 6.6879415406E+00, 5.9126160191E+00, 5.1061439237E-01, 4.3915936090E-01, 6.2524332872E-01],
	[1.3050000000E+04, 6.6913857025E+00, 5.9121607254E+00, 5.1123151860E-01, 4.3962813164E-01, 6.2538824443E-01],
	[1.3055000000E+04, 6.6948303177E+00, 5.9117056412E+00, 5.1184915330E-01, 4.4009716338E-01, 6.2553313318E-01],
	[1.3060000000E+04, 6.6982753861E+00, 5.9112507662E+00, 5.1246729671E-01, 4.4056645603E-01, 6.2567799494E-01],
	[1.3065000000E+04, 6.7017209075E+00, 5.9107961003E+00, 5.1308594904E-01, 4.4103600952E-01, 6.2582282969E-01],
	[1.3070000000E+04, 6.7051668820E+00, 5.9103416434E+00, 5.1370511052E-01, 4.4150582376E-01, 6.2596763743E-01],
	[1.3075000000E+04, 6.7086133092E+00, 5.9098873952E+00, 5.1432478137E-01, 4.4197589869E-01, 6.2611241813E-01],
	[1.3080000000E+04, 6.7120601893E+00, 5.9094333555E+00, 5.1494496182E-01, 4.4244623422E-01, 6.2625717179E-01],
	[1.3085000000E+04, 6.7155075219E+00, 5.9089795243E+00, 5.1556565209E-01, 4.4291683028E-01, 6.2640189837E-01],
	[1.3090000000E+04, 6.7189553071E+00, 5.9085259012E+00, 5.1618685240E-01, 4.4338768677E-01, 6.2654659787E-01],
	[1.3095000000E+04, 6.7224035446E+00, 5.9080724862E+00, 5.1680856297E-01, 4.4385880363E-01, 6.2669127028E-01],
	[1.3100000000E+04, 6.7258522345E+00, 5.9076192791E+00, 5.1743078404E-01, 4.4433018077E-01, 6.2683591556E-01],
	[1.3105000000E+04, 6.7293013765E+00, 5.9071662797E+00, 5.1805351581E-01, 4.4480181811E-01, 6.2698053372E-01],
	[1.3110000000E+04, 6.7327509706E+00, 5.9067134877E+00, 5.1867675852E-01, 4.4527371558E-01, 6.2712512473E-01],
	[1.3115000000E+04, 6.7362010166E+00, 5.9062609032E+00, 5.1930051239E-01, 4.4574587309E-01, 6.2726968858E-01],
	[1.3120000000E+04, 6.7396515145E+00, 5.9058085257E+00, 5.1992477765E-01, 4.4621829056E-01, 6.2741422525E-01],
	[1.3125000000E+04, 6.7431024640E+00, 5.9053563553E+00, 5.2054955450E-01, 4.4669096792E-01, 6.2755873473E-01],
	[1.3130000000E+04, 6.7465538652E+00, 5.9049043918E+00, 5.2117484319E-01, 4.4716390507E-01, 6.2770321700E-01],
	[1.3135000000E+04, 6.7500057179E+00, 5.9044526348E+00, 5.2180064393E-01, 4.4763710195E-01, 6.2784767204E-01],
	[1.3140000000E+04, 6.7534580219E+00, 5.9040010843E+00, 5.2242695695E-01, 4.4811055846E-01, 6.2799209984E-01],
	[1.3145000000E+04, 6.7569107773E+00, 5.9035497402E+00, 5.2305378247E-01, 4.4858427453E-01, 6.2813650039E-01],
	[1.3150000000E+04, 6.7603639837E+00, 5.9030986022E+00, 5.2368112071E-01, 4.4905825007E-01, 6.2828087366E-01],
	[1.3155000000E+04, 6.7638176413E+00, 5.9026476701E+00, 5.2430897189E-01, 4.4953248500E-01, 6.2842521965E-01],
	[1.3160000000E+04, 6.7672717497E+00, 5.9021969438E+00, 5.2493733625E-01, 4.5000697925E-01, 6.2856953833E-01],
	[1.3165000000E+04, 6.7707263090E+00, 5.9017464231E+00, 5.2556621400E-01, 4.5048173272E-01, 6.2871382970E-01],
	[1.3170000000E+04, 6.7741813189E+00, 5.9012961079E+00, 5.2619560537E-01, 4.5095674535E-01, 6.2885809373E-01],
	[1.3175000000E+04, 6.7776367795E+00, 5.9008459979E+00, 5.2682551058E-01, 4.5143201703E-01, 6.2900233042E-01],
	[1.3180000000E+04, 6.7810926906E+00, 5.9003960931E+00, 5.2745592985E-01, 4.5190754770E-01, 6.2914653974E-01],
	[1.3185000000E+04, 6.7845490520E+00, 5.8999463932E+00, 5.2808686341E-01, 4.5238333726E-01, 6.2929072168E-01],
	[1.3190000000E+04, 6.7880058637E+00, 5.8994968980E+00, 5.2871831148E-01, 4.5285938564E-01, 6.2943487622E-01],
	[1.3195000000E+04, 6.7914631255E+00, 5.8990476074E+00, 5.2935027429E-01, 4.5333569275E-01, 6.2957900336E-01],
	[1.3200000000E+04, 6.7949208373E+00, 5.8985985212E+00, 5.2998275205E-01, 4.5381225851E-01, 6.2972310307E-01],
	[1.3205000000E+04, 6.7983789991E+00, 5.8981496393E+00, 5.3061574500E-01, 4.5428908283E-01, 6.2986717534E-01],
	[1.3210000000E+04, 6.8018376107E+00, 5.8977009614E+00, 5.3124925335E-01, 4.5476616563E-01, 6.3001122016E-01],
	[1.3215000000E+04, 6.8052966719E+00, 5.8972524875E+00, 5.3188327734E-01, 4.5524350683E-01, 6.3015523750E-01],
	[1.3220000000E+04, 6.8087561828E+00, 5.8968042173E+00, 5.3251781717E-01, 4.5572110634E-01, 6.3029922736E-01],
	[1.3225000000E+04, 6.8122161431E+00, 5.8963561506E+00, 5.3315287309E-01, 4.5619896407E-01, 6.3044318972E-01],
	[1.3230000000E+04, 6.8156765528E+00, 5.8959082874E+00, 5.3378844530E-01, 4.5667707995E-01, 6.3058712456E-01],
	[1.3235000000E+04, 6.8191374118E+00, 5.8954606274E+00, 5.3442453404E-01, 4.5715545389E-01, 6.3073103188E-01],
	[1.3240000000E+04, 6.8225987198E+00, 5.8950131704E+00, 5.3506113952E-01, 4.5763408580E-01, 6.3087491164E-01],
	[1.3245000000E+04, 6.8260604770E+00, 5.8945659163E+00, 5.3569826198E-01, 4.5811297560E-01, 6.3101876385E-01],
	[1.3250000000E+04, 6.8295309935E+00, 5.8941267708E+00, 5.3633590163E-01, 4.5859220853E-01, 6.3116258848E-01],
	[1.3255000000E+04, 6.8330020531E+00, 5.8936879082E+00, 5.3697405870E-01, 4.5907170039E-01, 6.3130638553E-01],
	[1.3260000000E+04, 6.8364735668E+00, 5.8932492438E+00, 5.3761273342E-01, 4.5955145018E-01, 6.3145015497E-01],
	[1.3265000000E+04, 6.8399455344E+00, 5.8928107774E+00, 5.3825192600E-01, 4.6003145781E-01, 6.3159389678E-01],
	[1.3270000000E+04, 6.8434179559E+00, 5.8923725089E+00, 5.3889163667E-01, 4.6051172320E-01, 6.3173761097E-01],
	[1.3275000000E+04, 6.8468908310E+00, 5.8919344380E+00, 5.3953186566E-01, 4.6099224626E-01, 6.3188129751E-01],
	[1.3280000000E+04, 6.8503641598E+00, 5.8914965647E+00, 5.4017261318E-01, 4.6147302690E-01, 6.3202495638E-01],
	[1.3285000000E+04, 6.8538379420E+00, 5.8910588887E+00, 5.4081387946E-01, 4.6195406505E-01, 6.3216858757E-01],
	[1.3290000000E+04, 6.8573121777E+00, 5.8906214099E+00, 5.4145566473E-01, 4.6243536061E-01, 6.3231219107E-01],
	[1.3295000000E+04, 6.8607868666E+00, 5.8901841282E+00, 5.4209796921E-01, 4.6291691350E-01, 6.3245576684E-01],
	[1.3300000000E+04, 6.8642620086E+00, 5.8897470432E+00, 5.4274079312E-01, 4.6339872362E-01, 6.3259931487E-01],
	[1.3305000000E+04, 6.8677376037E+00, 5.8893101551E+00, 5.4338413669E-01, 4.6388079091E-01, 6.3274283513E-01],
	[1.3310000000E+04, 6.8712136517E+00, 5.8888734634E+00, 5.4402800014E-01, 4.6436311526E-01, 6.3288632760E-01],
	[1.3315000000E+04, 6.8746901526E+00, 5.8884369681E+00, 5.4467238370E-01, 4.6484569658E-01, 6.3302979227E-01],
	[1.3320000000E+04, 6.8781671062E+00, 5.8880006690E+00, 5.4531728758E-01, 4.6532853481E-01, 6.3317322912E-01],
	[1.3325000000E+04, 6.8816445123E+00, 5.8875645660E+00, 5.4596271202E-01, 4.6581162983E-01, 6.3331663812E-01],
	[1.3330000000E+04, 6.8851223710E+00, 5.8871286589E+00, 5.4660865723E-01, 4.6629498158E-01, 6.3346001926E-01],
	[1.3335000000E+04, 6.8886006820E+00, 5.8866929475E+00, 5.4725512344E-01, 4.6677858995E-01, 6.3360337252E-01],
	[1.3340000000E+04, 6.8920794454E+00, 5.8862574317E+00, 5.4790211088E-01, 4.6726245486E-01, 6.3374669788E-01],
	[1.3345000000E+04, 6.8955586608E+00, 5.8858221113E+00, 5.4854961976E-01, 4.6774657623E-01, 6.3388999532E-01],
	[1.3350000000E+04, 6.8990383283E+00, 5.8853869861E+00, 5.4919765032E-01, 4.6823095396E-01, 6.3403326482E-01],
	[1.3355000000E+04, 6.9025184478E+00, 5.8849520561E+00, 5.4984620277E-01, 4.6871558797E-01, 6.3417650636E-01],
	[1.3360000000E+04, 6.9059990191E+00, 5.8845173209E+00, 5.5049527735E-01, 4.6920047816E-01, 6.3431971992E-01],
	[1.3365000000E+04, 6.9094800421E+00, 5.8840827805E+00, 5.5114487426E-01, 4.6968562446E-01, 6.3446290549E-01],
	[1.3370000000E+04, 6.9129615167E+00, 5.8836484348E+00, 5.5179499375E-01, 4.7017102676E-01, 6.3460606303E-01],
	[1.3375000000E+04, 6.9164434428E+00, 5.8832142834E+00, 5.5244563603E-01, 4.7065668498E-01, 6.3474919255E-01],
	[1.3380000000E+04, 6.9199258202E+00, 5.8827803264E+00, 5.5309680132E-01, 4.7114259903E-01, 6.3489229401E-01],
	[1.3385000000E+04, 6.9234086490E+00, 5.8823465635E+00, 5.5374848985E-01, 4.7162876882E-01, 6.3503536740E-01],
	[1.3390000000E+04, 6.9268919289E+00, 5.8819129946E+00, 5.5440070185E-01, 4.7211519426E-01, 6.3517841269E-01],
	[1.3395000000E+04, 6.9303756599E+00, 5.8814796194E+00, 5.5505343754E-01, 4.7260187526E-01, 6.3532142988E-01],
	[1.3400000000E+04, 6.9338598418E+00, 5.8810464379E+00, 5.5570669713E-01, 4.7308881174E-01, 6.3546441893E-01],
	[1.3405000000E+04, 6.9373444746E+00, 5.8806134499E+00, 5.5636048087E-01, 4.7357600359E-01, 6.3560737984E-01],
	[1.3410000000E+04, 6.9408295580E+00, 5.8801806553E+00, 5.5701478896E-01, 4.7406345073E-01, 6.3575031258E-01],
	[1.3415000000E+04, 6.9443150921E+00, 5.8797480538E+00, 5.5766962164E-01, 4.7455115307E-01, 6.3589321713E-01],
	[1.3420000000E+04, 6.9478010767E+00, 5.8793156453E+00, 5.5832497913E-01, 4.7503911051E-01, 6.3603609348E-01],
	[1.3425000000E+04, 6.9512875117E+00, 5.8788834297E+00, 5.5898086165E-01, 4.7552732297E-01, 6.3617894161E-01],
	[1.3430000000E+04, 6.9547743970E+00, 5.8784514068E+00, 5.5963726943E-01, 4.7601579036E-01, 6.3632176150E-01],
	[1.3435000000E+04, 6.9582617325E+00, 5.8780195764E+00, 5.6029420269E-01, 4.7650451258E-01, 6.3646455312E-01],
	[1.3440000000E+04, 6.9617495180E+00, 5.8775879385E+00, 5.6095166165E-01, 4.7699348954E-01, 6.3660731647E-01],
	[1.3445000000E+04, 6.9652377535E+00, 5.8771564927E+00, 5.6160964654E-01, 4.7748272115E-01, 6.3675005152E-01],
	[1.3450000000E+04, 6.9687264388E+00, 5.8767252390E+00, 5.6226815759E-01, 4.7797220732E-01, 6.3689275825E-01],
	[1.3455000000E+04, 6.9722155739E+00, 5.8762941773E+00, 5.6292719501E-01, 4.7846194796E-01, 6.3703543665E-01],
	[1.3460000000E+04, 6.9757082079E+00, 5.8758660024E+00, 5.6358675904E-01, 4.7895197524E-01, 6.3717808670E-01],
	[1.3465000000E+04, 6.9792071115E+00, 5.8754431570E+00, 5.6424684989E-01, 4.7944231860E-01, 6.3732070838E-01],
	[1.3470000000E+04, 6.9827064701E+00, 5.8750204991E+00, 5.6490746779E-01, 4.7993291646E-01, 6.3746330167E-01],
	[1.3475000000E+04, 6.9862062835E+00, 5.8745980284E+00, 5.6556861297E-01, 4.8042376873E-01, 6.3760586656E-01],
	[1.3480000000E+04, 6.9897065518E+00, 5.8741757448E+00, 5.6623028565E-01, 4.8091487532E-01, 6.3774840301E-01],
	[1.3485000000E+04, 6.9932072748E+00, 5.8737536482E+00, 5.6689248605E-01, 4.8140623613E-01, 6.3789091103E-01],
	[1.3490000000E+04, 6.9967084523E+00, 5.8733317383E+00, 5.6755521439E-01, 4.8189785108E-01, 6.3803339058E-01],
	[1.3495000000E+04, 7.0002100842E+00, 5.8729100151E+00, 5.6821847091E-01, 4.8238972007E-01, 6.3817584166E-01],
	[1.3500000000E+04, 7.0037121705E+00, 5.8724884783E+00, 5.6888225583E-01, 4.8288184300E-01, 6.3831826423E-01],
	[1.3505000000E+04, 7.0072147110E+00, 5.8720671280E+00, 5.6954656936E-01, 4.8337421978E-01, 6.3846065829E-01],
	[1.3510000000E+04, 7.0107177057E+00, 5.8716459637E+00, 5.7021141174E-01, 4.8386685033E-01, 6.3860302382E-01],
	[1.3515000000E+04, 7.0142211543E+00, 5.8712249856E+00, 5.7087678319E-01, 4.8435973454E-01, 6.3874536080E-01],
	[1.3520000000E+04, 7.0177250569E+00, 5.8708041933E+00, 5.7154268393E-01, 4.8485287232E-01, 6.3888766920E-01],
	[1.3525000000E+04, 7.0212294133E+00, 5.8703835867E+00, 5.7220911419E-01, 4.8534626358E-01, 6.3902994902E-01],
	[1.3530000000E+04, 7.0247342233E+00, 5.8699631657E+00, 5.7287607419E-01, 4.8583990822E-01, 6.3917220024E-01],
	[1.3535000000E+04, 7.0282394869E+00, 5.8695429301E+00, 5.7354356416E-01, 4.8633380616E-01, 6.3931442283E-01],
	[1.3540000000E+04, 7.0317452040E+00, 5.8691228799E+00, 5.7421158432E-01, 4.8682795728E-01, 6.3945661678E-01],
	[1.3545000000E+04, 7.0352513745E+00, 5.8687030147E+00, 5.7488013489E-01, 4.8732236150E-01, 6.3959878208E-01],
	[1.3550000000E+04, 7.0387579982E+00, 5.8682833346E+00, 5.7554921610E-01, 4.8781701873E-01, 6.3974091870E-01],
	[1.3555000000E+04, 7.0422650750E+00, 5.8678638392E+00, 5.7621882818E-01, 4.8831192887E-01, 6.3988302662E-01],
	[1.3560000000E+04, 7.0457726049E+00, 5.8674445286E+00, 5.7688897135E-01, 4.8880709182E-01, 6.4002510583E-01],
	[1.3565000000E+04, 7.0492805877E+00, 5.8670254024E+00, 5.7755964583E-01, 4.8930250749E-01, 6.4016715632E-01],
	[1.3570000000E+04, 7.0527890233E+00, 5.8666064607E+00, 5.7823085184E-01, 4.8979817578E-01, 6.4030917806E-01],
	[1.3575000000E+04, 7.0562979117E+00, 5.8661877032E+00, 5.7890258962E-01, 4.9029409659E-01, 6.4045117104E-01],
	[1.3580000000E+04, 7.0598072526E+00, 5.8657691298E+00, 5.7957485938E-01, 4.9079026984E-01, 6.4059313523E-01],
	[1.3585000000E+04, 7.0633170460E+00, 5.8653507403E+00, 5.8024766136E-01, 4.9128669542E-01, 6.4073507063E-01],
	[1.3590000000E+04, 7.0668272918E+00, 5.8649325346E+00, 5.8092099577E-01, 4.9178337323E-01, 6.4087697721E-01],
	[1.3595000000E+04, 7.0703379899E+00, 5.8645145125E+00, 5.8159486284E-01, 4.9228030319E-01, 6.4101885496E-01],
	[1.3600000000E+04, 7.0738491402E+00, 5.8640966739E+00, 5.8226926279E-01, 4.9277748519E-01, 6.4116070386E-01],
	[1.3605000000E+04, 7.0773607425E+00, 5.8636790187E+00, 5.8294419586E-01, 4.9327491914E-01, 6.4130252389E-01],
	[1.3610000000E+04, 7.0808727967E+00, 5.8632615467E+00, 5.8361966225E-01, 4.9377260494E-01, 6.4144431504E-01],
	[1.3615000000E+04, 7.0843853028E+00, 5.8628442577E+00, 5.8429566221E-01, 4.9427054249E-01, 6.4158607729E-01],
	[1.3620000000E+04, 7.0878982607E+00, 5.8624271516E+00, 5.8497219595E-01, 4.9476873169E-01, 6.4172781061E-01],
	[1.3625000000E+04, 7.0914116701E+00, 5.8620102283E+00, 5.8564926369E-01, 4.9526717245E-01, 6.4186951500E-01],
	[1.3630000000E+04, 7.0949255311E+00, 5.8615934875E+00, 5.8632686567E-01, 4.9576586467E-01, 6.4201119044E-01],
	[1.3635000000E+04, 7.0984398435E+00, 5.8611769293E+00, 5.8700500210E-01, 4.9626480826E-01, 6.4215283691E-01],
	[1.3640000000E+04, 7.1019546072E+00, 5.8607605533E+00, 5.8768367321E-01, 4.9676400310E-01, 6.4229445439E-01],
	[1.3645000000E+04, 7.1054698221E+00, 5.8603443595E+00, 5.8836287923E-01, 4.9726344911E-01, 6.4243604287E-01],
	[1.3650000000E+04, 7.1089854881E+00, 5.8599283477E+00, 5.8904262038E-01, 4.9776314619E-01, 6.4257760233E-01],
	[1.3655000000E+04, 7.1125016051E+00, 5.8595125178E+00, 5.8972289689E-01, 4.9826309423E-01, 6.4271913275E-01],
	[1.3660000000E+04, 7.1160181729E+00, 5.8590968697E+00, 5.9040370897E-01, 4.9876329315E-01, 6.4286063411E-01],
	[1.3665000000E+04, 7.1195351915E+00, 5.8586814031E+00, 5.9108505686E-01, 4.9926374283E-01, 6.4300210640E-01],
	[1.3670000000E+04, 7.1230526608E+00, 5.8582661179E+00, 5.9176694078E-01, 4.9976444318E-01, 6.4314354961E-01],
	[1.3675000000E+04, 7.1265706922E+00, 5.8578511059E+00, 5.9244936095E-01, 5.0026539532E-01, 6.4328496371E-01],
	[1.3680000000E+04, 7.1300984034E+00, 5.8574438651E+00, 5.9313231760E-01, 5.0076669894E-01, 6.4342634869E-01],
	[1.3685000000E+04, 7.1336265708E+00, 5.8570368015E+00, 5.9381581095E-01, 5.0126825327E-01, 6.4356770453E-01],
	[1.3690000000E+04, 7.1371551942E+00, 5.8566299148E+00, 5.9449984123E-01, 5.0177005820E-01, 6.4370903122E-01],
	[1.3695000000E+04, 7.1406842736E+00, 5.8562232049E+00, 5.9518603632E-01, 5.0227327279E-01, 6.4385032873E-01],
	[1.3700000000E+04, 7.1442138088E+00, 5.8558166718E+00, 5.9587543020E-01, 5.0277863184E-01, 6.4399159706E-01],
	[1.3705000000E+04, 7.1477437997E+00, 5.8554103152E+00, 5.9656537004E-01, 5.0328424530E-01, 6.4413283619E-01],
	[1.3710000000E+04, 7.1512742463E+00, 5.8550041350E+00, 5.9725585606E-01, 5.0379011306E-01, 6.4427404609E-01],
	[1.3715000000E+04, 7.1548051483E+00, 5.8545981310E+00, 5.9794688850E-01, 5.0429623502E-01, 6.4441522676E-01],
	[1.3720000000E+04, 7.1583365058E+00, 5.8541923032E+00, 5.9863846760E-01, 5.0480261108E-01, 6.4455637817E-01],
	[1.3725000000E+04, 7.1618683186E+00, 5.8537866514E+00, 5.9933059358E-01, 5.0530924115E-01, 6.4469750031E-01],
	[1.3730000000E+04, 7.1654005865E+00, 5.8533811754E+00, 6.0002326668E-01, 5.0581612510E-01, 6.4483859317E-01],
	[1.3735000000E+04, 7.1689333095E+00, 5.8529758752E+00, 6.0071648713E-01, 5.0632326286E-01, 6.4497965673E-01],
	[1.3740000000E+04, 7.1724664875E+00, 5.8525707504E+00, 6.0141025516E-01, 5.0683065431E-01, 6.4512069096E-01],
	[1.3745000000E+04, 7.1760001204E+00, 5.8521658012E+00, 6.0210457101E-01, 5.0733829934E-01, 6.4526169587E-01],
	[1.3750000000E+04, 7.1795342080E+00, 5.8517610272E+00, 6.0279943490E-01, 5.0784619787E-01, 6.4540267142E-01],
	[1.3755000000E+04, 7.1830687503E+00, 5.8513564283E+00, 6.0349484707E-01, 5.0835434979E-01, 6.4554361760E-01],
	[1.3760000000E+04, 7.1866037472E+00, 5.8509520045E+00, 6.0419080775E-01, 5.0886275499E-01, 6.4568453440E-01],
	[1.3765000000E+04, 7.1901391984E+00, 5.8505477555E+00, 6.0488731718E-01, 5.0937141337E-01, 6.4582542180E-01],
	[1.3770000000E+04, 7.1936751040E+00, 5.8501436812E+00, 6.0558437558E-01, 5.0988032483E-01, 6.4596627979E-01],
	[1.3775000000E+04, 7.1972114639E+00, 5.8497397816E+00, 6.0628198319E-01, 5.1038948927E-01, 6.4610710835E-01],
	[1.3780000000E+04, 7.2007482778E+00, 5.8493360563E+00, 6.0698014024E-01, 5.1089890658E-01, 6.4624790745E-01],
	[1.3785000000E+04, 7.2042855458E+00, 5.8489325054E+00, 6.0767884697E-01, 5.1140857666E-01, 6.4638867710E-01],
	[1.3790000000E+04, 7.2078232677E+00, 5.8485291287E+00, 6.0837810360E-01, 5.1191849940E-01, 6.4652941727E-01],
	[1.3795000000E+04, 7.2113614434E+00, 5.8481259260E+00, 6.0907791037E-01, 5.1242867470E-01, 6.4667012794E-01],
	[1.3800000000E+04, 7.2149000727E+00, 5.8477228972E+00, 6.0977826751E-01, 5.1293910247E-01, 6.4681080910E-01],
	[1.3805000000E+04, 7.2184391557E+00, 5.8473200422E+00, 6.1047917526E-01, 5.1344978258E-01, 6.4695146073E-01],
	[1.3810000000E+04, 7.2219786922E+00, 5.8469173607E+00, 6.1118063384E-01, 5.1396071495E-01, 6.4709208283E-01],
	[1.3815000000E+04, 7.2255186820E+00, 5.8465148528E+00, 6.1188264349E-01, 5.1447189946E-01, 6.4723267536E-01],
	[1.3820000000E+04, 7.2290591251E+00, 5.8461125182E+00, 6.1258520444E-01, 5.1498333601E-01, 6.4737323833E-01],
	[1.3825000000E+04, 7.2326000213E+00, 5.8457103568E+00, 6.1328831692E-01, 5.1549502449E-01, 6.4751377170E-01],
	[1.3830000000E+04, 7.2361413707E+00, 5.8453083685E+00, 6.1399198117E-01, 5.1600696481E-01, 6.4765427547E-01],
	[1.3835000000E+04, 7.2396831729E+00, 5.8449065531E+00, 6.1469619742E-01, 5.1651915685E-01, 6.4779474962E-01],
	[1.3840000000E+04, 7.2432254280E+00, 5.8445049105E+00, 6.1540096590E-01, 5.1703160050E-01, 6.4793519413E-01],
	[1.3845000000E+04, 7.2467681359E+00, 5.8441034406E+00, 6.1610628684E-01, 5.1754429568E-01, 6.4807560899E-01],
	[1.3850000000E+04, 7.2503112964E+00, 5.8437021432E+00, 6.1681216048E-01, 5.1805724226E-01, 6.4821599419E-01],
	[1.3855000000E+04, 7.2538549094E+00, 5.8433010182E+00, 6.1751858705E-01, 5.1857044014E-01, 6.4835634971E-01],
	[1.3860000000E+04, 7.2573989749E+00, 5.8429000654E+00, 6.1822556678E-01, 5.1908388922E-01, 6.4849667552E-01],
	[1.3865000000E+04, 7.2609434926E+00, 5.8424992848E+00, 6.1893309991E-01, 5.1959758938E-01, 6.4863697163E-01],
	[1.3870000000E+04, 7.2644884626E+00, 5.8420986761E+00, 6.1964118666E-01, 5.2011154053E-01, 6.4877723800E-01],
	[1.3875000000E+04, 7.2680338847E+00, 5.8416982393E+00, 6.2034982727E-01, 5.2062574256E-01, 6.4891747464E-01],
	[1.3880000000E+04, 7.2715797588E+00, 5.8412979742E+00, 6.2105902198E-01, 5.2114019536E-01, 6.4905768151E-01],
	[1.3885000000E+04, 7.2751260848E+00, 5.8408978807E+00, 6.2176877101E-01, 5.2165489882E-01, 6.4919785862E-01],
	[1.3890000000E+04, 7.2786728626E+00, 5.8404979586E+00, 6.2247907460E-01, 5.2216985283E-01, 6.4933800593E-01],
	[1.3895000000E+04, 7.2822200921E+00, 5.8400982078E+00, 6.2318993298E-01, 5.2268505730E-01, 6.4947812344E-01],
	[1.3900000000E+04, 7.2857774198E+00, 5.8397060283E+00, 6.2390134638E-01, 5.2320062125E-01, 6.4961821113E-01],
	[1.3905000000E+04, 7.2893353781E+00, 5.8393141489E+00, 6.2461331504E-01, 5.2371643775E-01, 6.4975826899E-01],
	[1.3910000000E+04, 7.2928937939E+00, 5.8389224368E+00, 6.2532583919E-01, 5.2423250473E-01, 6.4989829700E-01],
	[1.3915000000E+04, 7.2964526670E+00, 5.8385308917E+00, 6.2603891906E-01, 5.2474882209E-01, 6.5003829514E-01],
	[1.3920000000E+04, 7.3000119973E+00, 5.8381395134E+00, 6.2675255488E-01, 5.2526538971E-01, 6.5017826341E-01],
	[1.3925000000E+04, 7.3035717847E+00, 5.8377483020E+00, 6.2746674689E-01, 5.2578220750E-01, 6.5031820178E-01],
	[1.3930000000E+04, 7.3071320290E+00, 5.8373572572E+00, 6.2818149533E-01, 5.2629927534E-01, 6.5045811024E-01],
	[1.3935000000E+04, 7.3106927303E+00, 5.8369663790E+00, 6.2889680041E-01, 5.2681659312E-01, 6.5059798878E-01],
	[1.3940000000E+04, 7.3142538884E+00, 5.8365756671E+00, 6.2961266238E-01, 5.2733416073E-01, 6.5073783737E-01],
	[1.3945000000E+04, 7.3178155031E+00, 5.8361851215E+00, 6.3032908148E-01, 5.2785197808E-01, 6.5087765598E-01],
	[1.3950000000E+04, 7.3213775744E+00, 5.8357947419E+00, 6.3104605792E-01, 5.2837004504E-01, 6.5101744459E-01],
	[1.3955000000E+04, 7.3249401022E+00, 5.8354045284E+00, 6.3176359194E-01, 5.2888836151E-01, 6.5115720319E-01],
	[1.3960000000E+04, 7.3285030863E+00, 5.8350144808E+00, 6.3248168379E-01, 5.2940692739E-01, 6.5129693176E-01],
	[1.3965000000E+04, 7.3320665267E+00, 5.8346245989E+00, 6.3320033368E-01, 5.2992574255E-01, 6.5143663027E-01],
	[1.3970000000E+04, 7.3356304232E+00, 5.8342348826E+00, 6.3391954186E-01, 5.3044480690E-01, 6.5157629872E-01],
	[1.3975000000E+04, 7.3391947758E+00, 5.8338453317E+00, 6.3463930856E-01, 5.3096412032E-01, 6.5171593707E-01],
	[1.3980000000E+04, 7.3427595843E+00, 5.8334559463E+00, 6.3535963400E-01, 5.3148368271E-01, 6.5185554532E-01],
	[1.3985000000E+04, 7.3463248487E+00, 5.8330667260E+00, 6.3608051843E-01, 5.3200349394E-01, 6.5199512343E-01],
	[1.3990000000E+04, 7.3498905688E+00, 5.8326776708E+00, 6.3680196207E-01, 5.3252355392E-01, 6.5213467141E-01],
	[1.3995000000E+04, 7.3534567445E+00, 5.8322887806E+00, 6.3752396516E-01, 5.3304386254E-01, 6.5227418922E-01],
	[1.4000000000E+04, 7.3570233758E+00, 5.8319000552E+00, 6.3824652794E-01, 5.3356441967E-01, 6.5241367685E-01],
	[1.4005000000E+04, 7.3605904625E+00, 5.8315114945E+00, 6.3896965062E-01, 5.3408522522E-01, 6.5255313427E-01],
	[1.4010000000E+04, 7.3641580044E+00, 5.8311230984E+00, 6.3969333346E-01, 5.3460627907E-01, 6.5269256148E-01],
	[1.4015000000E+04, 7.3677260016E+00, 5.8307348667E+00, 6.4041757667E-01, 5.3512758111E-01, 6.5283195845E-01],
	[1.4020000000E+04, 7.3712944539E+00, 5.8303467993E+00, 6.4114238050E-01, 5.3564913123E-01, 6.5297132517E-01],
	[1.4025000000E+04, 7.3748633613E+00, 5.8299588961E+00, 6.4186774517E-01, 5.3617092932E-01, 6.5311066161E-01],
	[1.4030000000E+04, 7.3784327235E+00, 5.8295711570E+00, 6.4259367093E-01, 5.3669297527E-01, 6.5324996776E-01],
	[1.4035000000E+04, 7.3820025405E+00, 5.8291835818E+00, 6.4332015800E-01, 5.3721526896E-01, 6.5338924360E-01],
	[1.4040000000E+04, 7.3855728121E+00, 5.8287961705E+00, 6.4404720661E-01, 5.3773781029E-01, 6.5352848911E-01],
	[1.4045000000E+04, 7.3891435384E+00, 5.8284089227E+00, 6.4477481700E-01, 5.3826059913E-01, 6.5366770428E-01],
	[1.4050000000E+04, 7.3927147192E+00, 5.8280218386E+00, 6.4550298941E-01, 5.3878363539E-01, 6.5380688908E-01],
	[1.4055000000E+04, 7.3962863543E+00, 5.8276349179E+00, 6.4623172406E-01, 5.3930691894E-01, 6.5394604350E-01],
	[1.4060000000E+04, 7.3998584437E+00, 5.8272481604E+00, 6.4696102119E-01, 5.3983044968E-01, 6.5408516752E-01],
	[1.4065000000E+04, 7.4034309873E+00, 5.8268615661E+00, 6.4769088103E-01, 5.4035422749E-01, 6.5422426112E-01],
	[1.4070000000E+04, 7.4070039849E+00, 5.8264751349E+00, 6.4842130381E-01, 5.4087825226E-01, 6.5436332428E-01],
	[1.4075000000E+04, 7.4105774365E+00, 5.8260888666E+00, 6.4915228978E-01, 5.4140252388E-01, 6.5450235700E-01],
	[1.4080000000E+04, 7.4141513420E+00, 5.8257027611E+00, 6.4988383915E-01, 5.4192704223E-01, 6.5464135923E-01],
	[1.4085000000E+04, 7.4177257012E+00, 5.8253168182E+00, 6.5061595217E-01, 5.4245180721E-01, 6.5478033098E-01],
	[1.4090000000E+04, 7.4213005141E+00, 5.8249310379E+00, 6.5134862907E-01, 5.4297681869E-01, 6.5491927223E-01],
	[1.4095000000E+04, 7.4248757805E+00, 5.8245454199E+00, 6.5208187008E-01, 5.4350207656E-01, 6.5505818294E-01],
	[1.4100000000E+04, 7.4284515004E+00, 5.8241599643E+00, 6.5281567544E-01, 5.4402758071E-01, 6.5519706312E-01],
	[1.4105000000E+04, 7.4320276736E+00, 5.8237746708E+00, 6.5355004537E-01, 5.4455333103E-01, 6.5533591273E-01],
	[1.4110000000E+04, 7.4356043000E+00, 5.8233895394E+00, 6.5428498011E-01, 5.4507932740E-01, 6.5547473177E-01],
	[1.4115000000E+04, 7.4391813796E+00, 5.8230045698E+00, 6.5502047990E-01, 5.4560556970E-01, 6.5561352021E-01],
	[1.4120000000E+04, 7.4427614256E+00, 5.8226215646E+00, 6.5575654496E-01, 5.4613208723E-01, 6.5575227804E-01],
	[1.4125000000E+04, 7.4463497173E+00, 5.8222443048E+00, 6.5649317554E-01, 5.4665894177E-01, 6.5589100524E-01],
	[1.4130000000E+04, 7.4499384681E+00, 5.8218672029E+00, 6.5723037186E-01, 5.4718604228E-01, 6.5602970179E-01],
	[1.4135000000E+04, 7.4535276779E+00, 5.8214902589E+00, 6.5796813416E-01, 5.4771338865E-01, 6.5616836767E-01],
	[1.4140000000E+04, 7.4571173465E+00, 5.8211134726E+00, 6.5870646267E-01, 5.4824098077E-01, 6.5630700288E-01],
	[1.4145000000E+04, 7.4607074740E+00, 5.8207368439E+00, 6.5944535763E-01, 5.4876881851E-01, 6.5644560738E-01],
	[1.4150000000E+04, 7.4642980601E+00, 5.8203603726E+00, 6.6018481926E-01, 5.4929690177E-01, 6.5658418117E-01],
	[1.4155000000E+04, 7.4678891049E+00, 5.8199840587E+00, 6.6092484780E-01, 5.4982523042E-01, 6.5672272422E-01],
	[1.4160000000E+04, 7.4714806080E+00, 5.8196079020E+00, 6.6166544349E-01, 5.5035380435E-01, 6.5686123652E-01],
	[1.4165000000E+04, 7.4750725696E+00, 5.8192319024E+00, 6.6240660656E-01, 5.5088262346E-01, 6.5699971805E-01],
	[1.4170000000E+04, 7.4786649894E+00, 5.8188560597E+00, 6.6314833724E-01, 5.5141168761E-01, 6.5713816880E-01],
	[1.4175000000E+04, 7.4822578674E+00, 5.8184803740E+00, 6.6389063577E-01, 5.5194099670E-01, 6.5727658874E-01],
	[1.4180000000E+04, 7.4858512035E+00, 5.8181048449E+00, 6.6463350237E-01, 5.5247055061E-01, 6.5741497787E-01],
	[1.4185000000E+04, 7.4894449975E+00, 5.8177294725E+00, 6.6537693729E-01, 5.5300034923E-01, 6.5755333616E-01],
	[1.4190000000E+04, 7.4930392494E+00, 5.8173542566E+00, 6.6612094075E-01, 5.5353039243E-01, 6.5769166359E-01],
	[1.4195000000E+04, 7.4966339590E+00, 5.8169791970E+00, 6.6686551299E-01, 5.5406068011E-01, 6.5782996016E-01],
	[1.4200000000E+04, 7.5002291263E+00, 5.8166042938E+00, 6.6761065424E-01, 5.5459121214E-01, 6.5796822583E-01],
	[1.4205000000E+04, 7.5038247511E+00, 5.8162295466E+00, 6.6835636474E-01, 5.5512198841E-01, 6.5810646061E-01],
	[1.4210000000E+04, 7.5074208333E+00, 5.8158549554E+00, 6.6910264472E-01, 5.5565300880E-01, 6.5824466446E-01],
	[1.4215000000E+04, 7.5110173729E+00, 5.8154805202E+00, 6.6984949442E-01, 5.5618427319E-01, 6.5838283737E-01],
	[1.4220000000E+04, 7.5146143698E+00, 5.8151062407E+00, 6.7059691406E-01, 5.5671578148E-01, 6.5852097933E-01],
	[1.4225000000E+04, 7.5182118237E+00, 5.8147321169E+00, 6.7134490388E-01, 5.5724753353E-01, 6.5865909032E-01],
	[1.4230000000E+04, 7.5218097348E+00, 5.8143581486E+00, 6.7209346412E-01, 5.5777952924E-01, 6.5879717032E-01],
	[1.4235000000E+04, 7.5254081027E+00, 5.8139843358E+00, 6.7284259500E-01, 5.5831176848E-01, 6.5893521932E-01],
	[1.4240000000E+04, 7.5290069274E+00, 5.8136106782E+00, 6.7359229677E-01, 5.5884425114E-01, 6.5907323729E-01],
	[1.4245000000E+04, 7.5326062089E+00, 5.8132371758E+00, 6.7434256965E-01, 5.5937697709E-01, 6.5921122423E-01],
	[1.4250000000E+04, 7.5362059470E+00, 5.8128638285E+00, 6.7509341388E-01, 5.5990994623E-01, 6.5934918011E-01],
	[1.4255000000E+04, 7.5398061417E+00, 5.8124906361E+00, 6.7584482970E-01, 5.6044315843E-01, 6.5948710493E-01],
	[1.4260000000E+04, 7.5434067927E+00, 5.8121175985E+00, 6.7659681733E-01, 5.6097661358E-01, 6.5962499865E-01],
	[1.4265000000E+04, 7.5470079001E+00, 5.8117447157E+00, 6.7734937701E-01, 5.6151031155E-01, 6.5976286128E-01],
	[1.4270000000E+04, 7.5506094636E+00, 5.8113719874E+00, 6.7810250897E-01, 5.6204425223E-01, 6.5990069278E-01],
	[1.4275000000E+04, 7.5542114833E+00, 5.8109994136E+00, 6.7885621345E-01, 5.6257843549E-01, 6.6003849315E-01],
	[1.4280000000E+04, 7.5578139590E+00, 5.8106269941E+00, 6.7961049069E-01, 5.6311286122E-01, 6.6017626236E-01],
	[1.4285000000E+04, 7.5614168906E+00, 5.8102547289E+00, 6.8036534091E-01, 5.6364752931E-01, 6.6031400041E-01],
	[1.4290000000E+04, 7.5650202780E+00, 5.8098826178E+00, 6.8112076434E-01, 5.6418243962E-01, 6.6045170728E-01],
	[1.4295000000E+04, 7.5686241211E+00, 5.8095106607E+00, 6.8187676123E-01, 5.6471759204E-01, 6.6058938294E-01],
	[1.4300000000E+04, 7.5722284199E+00, 5.8091388574E+00, 6.8263333181E-01, 5.6525298646E-01, 6.6072702738E-01],
	[1.4305000000E+04, 7.5758331741E+00, 5.8087672079E+00, 6.8339047631E-01, 5.6578862274E-01, 6.6086464060E-01],
	[1.4310000000E+04, 7.5794383837E+00, 5.8083957121E+00, 6.8414819496E-01, 5.6632450077E-01, 6.6100222256E-01],
	[1.4315000000E+04, 7.5830440486E+00, 5.8080243698E+00, 6.8490648800E-01, 5.6686062044E-01, 6.6113977326E-01],
	[1.4320000000E+04, 7.5866501687E+00, 5.8076531809E+00, 6.8566535566E-01, 5.6739698161E-01, 6.6127729268E-01],
	[1.4325000000E+04, 7.5902567439E+00, 5.8072821453E+00, 6.8642479817E-01, 5.6793358417E-01, 6.6141478080E-01],
	[1.4330000000E+04, 7.5938637741E+00, 5.8069112629E+00, 6.8718481578E-01, 5.6847042800E-01, 6.6155223761E-01],
	[1.4335000000E+04, 7.5974712592E+00, 5.8065405335E+00, 6.8794540871E-01, 5.6900751298E-01, 6.6168966309E-01],
	[1.4340000000E+04, 7.6010791990E+00, 5.8061699571E+00, 6.8870657720E-01, 5.6954483898E-01, 6.6182705722E-01],
	[1.4345000000E+04, 7.6046875936E+00, 5.8057995335E+00, 6.8946832147E-01, 5.7008240589E-01, 6.6196442000E-01],
	[1.4350000000E+04, 7.6083049201E+00, 5.8054349524E+00, 6.9023064178E-01, 5.7062031623E-01, 6.6210175140E-01],
	[1.4355000000E+04, 7.6119250241E+00, 5.8050720760E+00, 6.9099353834E-01, 5.7115849565E-01, 6.6223905141E-01],
	[1.4360000000E+04, 7.6155455890E+00, 5.8047093487E+00, 6.9175701139E-01, 5.7169691602E-01, 6.6237632001E-01],
	[1.4365000000E+04, 7.6191666147E+00, 5.8043467704E+00, 6.9252106118E-01, 5.7223557719E-01, 6.6251355719E-01],
	[1.4370000000E+04, 7.6227881010E+00, 5.8039843408E+00, 6.9328568792E-01, 5.7277447907E-01, 6.6265076293E-01],
	[1.4375000000E+04, 7.6264100480E+00, 5.8036220600E+00, 6.9405089186E-01, 5.7331362152E-01, 6.6278793721E-01],
	[1.4380000000E+04, 7.6300324553E+00, 5.8032599277E+00, 6.9481667323E-01, 5.7385300442E-01, 6.6292508003E-01],
	[1.4385000000E+04, 7.6336553231E+00, 5.8028979439E+00, 6.9558303226E-01, 5.7439262766E-01, 6.6306219136E-01],
	[1.4390000000E+04, 7.6372786511E+00, 5.8025361085E+00, 6.9634996919E-01, 5.7493249110E-01, 6.6319927120E-01],
	[1.4395000000E+04, 7.6409024393E+00, 5.8021744214E+00, 6.9711748425E-01, 5.7547259463E-01, 6.6333631951E-01],
	[1.4400000000E+04, 7.6445266876E+00, 5.8018128824E+00, 6.9788557767E-01, 5.7601293812E-01, 6.6347333630E-01],
	[1.4405000000E+04, 7.6481513958E+00, 5.8014514914E+00, 6.9865424969E-01, 5.7655352146E-01, 6.6361032154E-01],
	[1.4410000000E+04, 7.6517765639E+00, 5.8010902483E+00, 6.9942350055E-01, 5.7709434451E-01, 6.6374727521E-01],
	[1.4415000000E+04, 7.6554021917E+00, 5.8007291530E+00, 7.0019333048E-01, 5.7763540716E-01, 6.6388419731E-01],
	[1.4420000000E+04, 7.6590282793E+00, 5.8003682054E+00, 7.0096373970E-01, 5.7817670929E-01, 6.6402108782E-01],
	[1.4425000000E+04, 7.6626548263E+00, 5.8000074055E+00, 7.0173472847E-01, 5.7871825076E-01, 6.6415794672E-01],
	[1.4430000000E+04, 7.6662818329E+00, 5.7996467529E+00, 7.0250629700E-01, 5.7926003146E-01, 6.6429477400E-01],
	[1.4435000000E+04, 7.6699092987E+00, 5.7992862478E+00, 7.0327844553E-01, 5.7980205126E-01, 6.6443156964E-01],
	[1.4440000000E+04, 7.6735372239E+00, 5.7989258899E+00, 7.0405117431E-01, 5.8034431004E-01, 6.6456833363E-01],
	[1.4445000000E+04, 7.6771656082E+00, 5.7985656791E+00, 7.0482448355E-01, 5.8088680768E-01, 6.6470506595E-01],
	[1.4450000000E+04, 7.6807944515E+00, 5.7982056153E+00, 7.0559837351E-01, 5.8142954405E-01, 6.6484176659E-01],
	[1.4455000000E+04, 7.6844237538E+00, 5.7978456985E+00, 7.0637284440E-01, 5.8197251902E-01, 6.6497843553E-01],
	[1.4460000000E+04, 7.6880535150E+00, 5.7974859284E+00, 7.0714789647E-01, 5.8251573248E-01, 6.6511507275E-01],
	[1.4465000000E+04, 7.6916837349E+00, 5.7971263051E+00, 7.0792352995E-01, 5.8305918429E-01, 6.6525167825E-01],
	[1.4470000000E+04, 7.6953144135E+00, 5.7967668283E+00, 7.0869974507E-01, 5.8360287434E-01, 6.6538825201E-01],
	[1.4475000000E+04, 7.6989455506E+00, 5.7964074980E+00, 7.0947654207E-01, 5.8414680250E-01, 6.6552479401E-01],
	[1.4480000000E+04, 7.7025771462E+00, 5.7960483141E+00, 7.1025392118E-01, 5.8469096864E-01, 6.6566130424E-01],
	[1.4485000000E+04, 7.7062092001E+00, 5.7956892764E+00, 7.1103188264E-01, 5.8523537264E-01, 6.6579778268E-01],
	[1.4490000000E+04, 7.7098417122E+00, 5.7953303849E+00, 7.1181042667E-01, 5.8578001437E-01, 6.6593422932E-01],
	[1.4495000000E+04, 7.7134746826E+00, 5.7949716394E+00, 7.1258955353E-01, 5.8632489371E-01, 6.6607064415E-01],
	[1.4500000000E+04, 7.7171081109E+00, 5.7946130398E+00, 7.1336926343E-01, 5.8687001054E-01, 6.6620702714E-01],
	[1.4505000000E+04, 7.7207419972E+00, 5.7942545861E+00, 7.1414955661E-01, 5.8741536471E-01, 6.6634337829E-01],
	[1.4510000000E+04, 7.7243763414E+00, 5.7938962780E+00, 7.1493043331E-01, 5.8796095612E-01, 6.6647969758E-01],
	[1.4515000000E+04, 7.7280111433E+00, 5.7935381156E+00, 7.1571189377E-01, 5.8850678464E-01, 6.6661598500E-01],
	[1.4520000000E+04, 7.7316464029E+00, 5.7931800986E+00, 7.1649393821E-01, 5.8905285013E-01, 6.6675224052E-01],
	[1.4525000000E+04, 7.7352821200E+00, 5.7928222270E+00, 7.1727656687E-01, 5.8959915247E-01, 6.6688846415E-01],
	[1.4530000000E+04, 7.7389182945E+00, 5.7924645006E+00, 7.1805977999E-01, 5.9014569154E-01, 6.6702465585E-01],
	[1.4535000000E+04, 7.7425549264E+00, 5.7921069194E+00, 7.1884357780E-01, 5.9069246721E-01, 6.6716081563E-01],
	[1.4540000000E+04, 7.7461920156E+00, 5.7917494833E+00, 7.1962796053E-01, 5.9123947935E-01, 6.6729694345E-01],
	[1.4545000000E+04, 7.7498295619E+00, 5.7913921921E+00, 7.2041292842E-01, 5.9178672783E-01, 6.6743303932E-01],
	[1.4550000000E+04, 7.7534675653E+00, 5.7910350457E+00, 7.2119848170E-01, 5.9233421253E-01, 6.6756910321E-01],
	[1.4555000000E+04, 7.7571060256E+00, 5.7906780441E+00, 7.2198462061E-01, 5.9288193332E-01, 6.6770513512E-01],
	[1.4560000000E+04, 7.7607449427E+00, 5.7903211871E+00, 7.2277134538E-01, 5.9342989008E-01, 6.6784113507E-01],
	[1.4565000000E+04, 7.7643843166E+00, 5.7899644746E+00, 7.2355865625E-01, 5.9397808266E-01, 6.6797710306E-01],
	[1.4570000000E+04, 7.7680241472E+00, 5.7896079064E+00, 7.2434655345E-01, 5.9452651096E-01, 6.6811303907E-01],
	[1.4575000000E+04, 7.7716644343E+00, 5.7892514826E+00, 7.2513503722E-01, 5.9507517483E-01, 6.6824894309E-01],
	[1.4580000000E+04, 7.7753118945E+00, 5.7888994302E+00, 7.2592410778E-01, 5.9562415833E-01, 6.6838481509E-01],
	[1.4585000000E+04, 7.7789643904E+00, 5.7885503980E+00, 7.2671376538E-01, 5.9617343479E-01, 6.6852065506E-01],
	[1.4590000000E+04, 7.7826173493E+00, 5.7882015064E+00, 7.2750401025E-01, 5.9672294688E-01, 6.6865646299E-01],
	[1.4595000000E+04, 7.7862707711E+00, 5.7878527554E+00, 7.2829484262E-01, 5.9727269445E-01, 6.6879223884E-01],
	[1.4600000000E+04, 7.7899246556E+00, 5.7875041448E+00, 7.2908626273E-01, 5.9782267737E-01, 6.6892798261E-01],
	[1.4605000000E+04, 7.7935790028E+00, 5.7871556746E+00, 7.2987827081E-01, 5.9837289553E-01, 6.6906369428E-01],
	[1.4610000000E+04, 7.7972338126E+00, 5.7868073447E+00, 7.3067086710E-01, 5.9892334880E-01, 6.6919937382E-01],
	[1.4615000000E+04, 7.8008890848E+00, 5.7864591549E+00, 7.3146405183E-01, 5.9947403703E-01, 6.6933502123E-01],
	[1.4620000000E+04, 7.8045448194E+00, 5.7861111051E+00, 7.3225782524E-01, 6.0002496012E-01, 6.6947063647E-01],
	[1.4625000000E+04, 7.8082010163E+00, 5.7857631953E+00, 7.3305218756E-01, 6.0057611791E-01, 6.6960621954E-01],
	[1.4630000000E+04, 7.8118576754E+00, 5.7854154253E+00, 7.3384713903E-01, 6.0112751030E-01, 6.6974177042E-01],
	[1.4635000000E+04, 7.8155147965E+00, 5.7850677950E+00, 7.3464267987E-01, 6.0167913714E-01, 6.6987728908E-01],
	[1.4640000000E+04, 7.8191723796E+00, 5.7847203043E+00, 7.3543881033E-01, 6.0223099832E-01, 6.7001277552E-01],
	[1.4645000000E+04, 7.8228304246E+00, 5.7843729532E+00, 7.3623553064E-01, 6.0278309369E-01, 6.7014822970E-01],
	[1.4650000000E+04, 7.8264889313E+00, 5.7840257415E+00, 7.3703284104E-01, 6.0333542313E-01, 6.7028365163E-01],
	[1.4655000000E+04, 7.8301478998E+00, 5.7836786691E+00, 7.3783074175E-01, 6.0388798651E-01, 6.7041904127E-01],
	[1.4660000000E+04, 7.8338073298E+00, 5.7833317359E+00, 7.3862923302E-01, 6.0444078371E-01, 6.7055439861E-01],
	[1.4665000000E+04, 7.8374672212E+00, 5.7829849418E+00, 7.3942831508E-01, 6.0499381458E-01, 6.7068972363E-01],
	[1.4670000000E+04, 7.8411275741E+00, 5.7826382867E+00, 7.4022798816E-01, 6.0554707900E-01, 6.7082501632E-01],
	[1.4675000000E+04, 7.8447883882E+00, 5.7822917705E+00, 7.4102825249E-01, 6.0610057684E-01, 6.7096027665E-01],
	[1.4680000000E+04, 7.8484496636E+00, 5.7819453932E+00, 7.4182910833E-01, 6.0665430797E-01, 6.7109550462E-01],
	[1.4685000000E+04, 7.8521114000E+00, 5.7815991545E+00, 7.4263055588E-01, 6.0720827226E-01, 6.7123070020E-01],
	[1.4690000000E+04, 7.8557735973E+00, 5.7812530544E+00, 7.4343259541E-01, 6.0776246957E-01, 6.7136586337E-01],
	[1.4695000000E+04, 7.8594362556E+00, 5.7809070928E+00, 7.4423522713E-01, 6.0831689979E-01, 6.7150099412E-01],
	[1.4700000000E+04, 7.8630993747E+00, 5.7805612695E+00, 7.4503845128E-01, 6.0887156276E-01, 6.7163609243E-01],
	[1.4705000000E+04, 7.8667629544E+00, 5.7802155846E+00, 7.4584226809E-01, 6.0942645837E-01, 6.7177115829E-01],
	[1.4710000000E+04, 7.8704269947E+00, 5.7798700379E+00, 7.4664667781E-01, 6.0998158648E-01, 6.7190619167E-01],
	[1.4715000000E+04, 7.8740914955E+00, 5.7795246292E+00, 7.4745168067E-01, 6.1053694697E-01, 6.7204119256E-01],
	[1.4720000000E+04, 7.8777564567E+00, 5.7791793585E+00, 7.4825727690E-01, 6.1109253969E-01, 6.7217616094E-01],
	[1.4725000000E+04, 7.8814218782E+00, 5.7788342257E+00, 7.4906346673E-01, 6.1164836452E-01, 6.7231109680E-01],
	[1.4730000000E+04, 7.8850877599E+00, 5.7784892306E+00, 7.4987025041E-01, 6.1220442132E-01, 6.7244600011E-01],
	[1.4735000000E+04, 7.8887541017E+00, 5.7781443732E+00, 7.5067762816E-01, 6.1276070996E-01, 6.7258087087E-01],
	[1.4740000000E+04, 7.8924209034E+00, 5.7777996534E+00, 7.5148560022E-01, 6.1331723032E-01, 6.7271570905E-01],
	[1.4745000000E+04, 7.8960881651E+00, 5.7774550711E+00, 7.5229416683E-01, 6.1387398225E-01, 6.7285051463E-01],
	[1.4750000000E+04, 7.8997558866E+00, 5.7771106261E+00, 7.5310332822E-01, 6.1443096563E-01, 6.7298528761E-01],
	[1.4755000000E+04, 7.9034240677E+00, 5.7767663184E+00, 7.5391308463E-01, 6.1498818032E-01, 6.7312002796E-01],
	[1.4760000000E+04, 7.9070927085E+00, 5.7764221479E+00, 7.5472343629E-01, 6.1554562619E-01, 6.7325473567E-01],
	[1.4765000000E+04, 7.9107618088E+00, 5.7760781144E+00, 7.5553438343E-01, 6.1610330311E-01, 6.7338941071E-01],
	[1.4770000000E+04, 7.9144313685E+00, 5.7757342179E+00, 7.5634592630E-01, 6.1666121094E-01, 6.7352405308E-01],
	[1.4775000000E+04, 7.9181013875E+00, 5.7753904582E+00, 7.5715806512E-01, 6.1721934955E-01, 6.7365866276E-01],
	[1.4780000000E+04, 7.9217718657E+00, 5.7750468353E+00, 7.5797080013E-01, 6.1777771880E-01, 6.7379323972E-01],
	[1.4785000000E+04, 7.9254428030E+00, 5.7747033491E+00, 7.5878413157E-01, 6.1833631857E-01, 6.7392778396E-01],
	[1.4790000000E+04, 7.9291141993E+00, 5.7743599994E+00, 7.5959805966E-01, 6.1889514872E-01, 6.7406229545E-01],
	[1.4795000000E+04, 7.9327860545E+00, 5.7740167862E+00, 7.6041258466E-01, 6.1945420911E-01, 6.7419677419E-01],
	[1.4800000000E+04, 7.9364583686E+00, 5.7736737094E+00, 7.6122770679E-01, 6.2001349961E-01, 6.7433122014E-01],
	[1.4805000000E+04, 7.9401311414E+00, 5.7733307688E+00, 7.6204342628E-01, 6.2057302008E-01, 6.7446563331E-01],
	[1.4810000000E+04, 7.9438043728E+00, 5.7729879644E+00, 7.6285974337E-01, 6.2113277040E-01, 6.7460001366E-01],
	[1.4815000000E+04, 7.9474858564E+00, 5.7726499017E+00, 7.6367665830E-01, 6.2169285153E-01, 6.7473436119E-01],
	[1.4820000000E+04, 7.9511718043E+00, 5.7723143362E+00, 7.6449417130E-01, 6.2225321450E-01, 6.7486867588E-01],
	[1.4825000000E+04, 7.9548582175E+00, 5.7719789034E+00, 7.6531228261E-01, 6.2281380735E-01, 6.7500295771E-01],
	[1.4830000000E+04, 7.9585450958E+00, 5.7716436032E+00, 7.6613099246E-01, 6.2337462994E-01, 6.7513720667E-01],
	[1.4835000000E+04, 7.9622324392E+00, 5.7713084355E+00, 7.6695030109E-01, 6.2393568215E-01, 6.7527142273E-01],
	[1.4840000000E+04, 7.9659202476E+00, 5.7709734002E+00, 7.6777020873E-01, 6.2449696383E-01, 6.7540560589E-01],
	[1.4845000000E+04, 7.9696085209E+00, 5.7706384972E+00, 7.6859071562E-01, 6.2505847486E-01, 6.7553975612E-01],
	[1.4850000000E+04, 7.9732972589E+00, 5.7703037264E+00, 7.6941182199E-01, 6.2562021509E-01, 6.7567387342E-01],
	[1.4855000000E+04, 7.9769864617E+00, 5.7699690878E+00, 7.7023352808E-01, 6.2618218439E-01, 6.7580795776E-01],
	[1.4860000000E+04, 7.9806761290E+00, 5.7696345811E+00, 7.7105583412E-01, 6.2674438263E-01, 6.7594200913E-01],
	[1.4865000000E+04, 7.9843662608E+00, 5.7693002063E+00, 7.7187874035E-01, 6.2730680967E-01, 6.7607602751E-01],
	[1.4870000000E+04, 7.9880568570E+00, 5.7689659634E+00, 7.7270224700E-01, 6.2786946538E-01, 6.7621001289E-01],
	[1.4875000000E+04, 7.9917479175E+00, 5.7686318522E+00, 7.7352635432E-01, 6.2843234962E-01, 6.7634396525E-01],
	[1.4880000000E+04, 7.9954394421E+00, 5.7682978726E+00, 7.7435106252E-01, 6.2899546225E-01, 6.7647788458E-01],
	[1.4885000000E+04, 7.9991314309E+00, 5.7679640246E+00, 7.7517637186E-01, 6.2955880313E-01, 6.7661177085E-01],
	[1.4890000000E+04, 8.0028238837E+00, 5.7676303079E+00, 7.7600228256E-01, 6.3012237214E-01, 6.7674562406E-01],
	[1.4895000000E+04, 8.0065168003E+00, 5.7672967227E+00, 7.7682879486E-01, 6.3068616914E-01, 6.7687944419E-01],
	[1.4900000000E+04, 8.0102101808E+00, 5.7669632686E+00, 7.7765590899E-01, 6.3125019398E-01, 6.7701323122E-01],
	[1.4905000000E+04, 8.0139040250E+00, 5.7666299458E+00, 7.7848362520E-01, 6.3181444654E-01, 6.7714698514E-01],
	[1.4910000000E+04, 8.0175983328E+00, 5.7662967539E+00, 7.7931194371E-01, 6.3237892667E-01, 6.7728070593E-01],
	[1.4915000000E+04, 8.0212931041E+00, 5.7659636931E+00, 7.8014086477E-01, 6.3294363424E-01, 6.7741439357E-01],
	[1.4920000000E+04, 8.0249883388E+00, 5.7656307631E+00, 7.8097038860E-01, 6.3350856911E-01, 6.7754804806E-01],
	[1.4925000000E+04, 8.0286840368E+00, 5.7652979638E+00, 7.8180051544E-01, 6.3407373115E-01, 6.7768166937E-01],
	[1.4930000000E+04, 8.0323801980E+00, 5.7649652952E+00, 7.8263124553E-01, 6.3463912021E-01, 6.7781525748E-01],
	[1.4935000000E+04, 8.0360768224E+00, 5.7646327573E+00, 7.8346257911E-01, 6.3520473616E-01, 6.7794881240E-01],
	[1.4940000000E+04, 8.0397739098E+00, 5.7643003497E+00, 7.8429451640E-01, 6.3577057887E-01, 6.7808233409E-01],
	[1.4945000000E+04, 8.0434714601E+00, 5.7639680726E+00, 7.8512705764E-01, 6.3633664819E-01, 6.7821582254E-01],
	[1.4950000000E+04, 8.0471694733E+00, 5.7636359258E+00, 7.8596020308E-01, 6.3690294398E-01, 6.7834927774E-01],
	[1.4955000000E+04, 8.0508679491E+00, 5.7633039092E+00, 7.8679395294E-01, 6.3746946612E-01, 6.7848269968E-01],
	[1.4960000000E+04, 8.0545668877E+00, 5.7629720226E+00, 7.8762830746E-01, 6.3803621445E-01, 6.7861608833E-01],
	[1.4965000000E+04, 8.0582662887E+00, 5.7626402661E+00, 7.8846326687E-01, 6.3860318885E-01, 6.7874944368E-01],
	[1.4970000000E+04, 8.0619661522E+00, 5.7623086395E+00, 7.8929883142E-01, 6.3917038917E-01, 6.7888276572E-01],
	[1.4975000000E+04, 8.0656664781E+00, 5.7619771427E+00, 7.9013500133E-01, 6.3973781527E-01, 6.7901605444E-01],
	[1.4980000000E+04, 8.0693672662E+00, 5.7616457756E+00, 7.9097177685E-01, 6.4030546702E-01, 6.7914930981E-01],
	[1.4985000000E+04, 8.0730685164E+00, 5.7613145382E+00, 7.9180915820E-01, 6.4087334428E-01, 6.7928253182E-01],
	[1.4990000000E+04, 8.0767702288E+00, 5.7609834303E+00, 7.9264714563E-01, 6.4144144691E-01, 6.7941572046E-01],
	[1.4995000000E+04, 8.0804724030E+00, 5.7606524519E+00, 7.9348573936E-01, 6.4200977476E-01, 6.7954887571E-01],
	[1.5000000000E+04, 8.0841750392E+00, 5.7603216028E+00, 7.9432493964E-01, 6.4257832771E-01, 6.7968199756E-01],
	[1.5005000000E+04, 8.0878781371E+00, 5.7599908829E+00, 7.9516725384E-01, 6.4314874575E-01, 6.7981508599E-01],
	[1.5010000000E+04, 8.0915816967E+00, 5.7596602923E+00, 7.9601017959E-01, 6.4371939045E-01, 6.7994814099E-01],
	[1.5015000000E+04, 8.0952857178E+00, 5.7593298306E+00, 7.9685371714E-01, 6.4429026165E-01, 6.8008116254E-01],
	[1.5020000000E+04, 8.0989902005E+00, 5.7589994980E+00, 7.9769786672E-01, 6.4486135922E-01, 6.8021415063E-01],
	[1.5025000000E+04, 8.1026951445E+00, 5.7586692943E+00, 7.9854262856E-01, 6.4543268302E-01, 6.8034710524E-01],
	[1.5030000000E+04, 8.1064005498E+00, 5.7583392193E+00, 7.9938800293E-01, 6.4600423290E-01, 6.8048002636E-01],
	[1.5035000000E+04, 8.1101064163E+00, 5.7580092730E+00, 8.0023399004E-01, 6.4657600872E-01, 6.8061291398E-01],
	[1.5040000000E+04, 8.1138127439E+00, 5.7576794554E+00, 8.0108059014E-01, 6.4714801035E-01, 6.8074576807E-01],
	[1.5045000000E+04, 8.1175195325E+00, 5.7573497662E+00, 8.0192780347E-01, 6.4772023764E-01, 6.8087858863E-01],
	[1.5050000000E+04, 8.1212267820E+00, 5.7570202055E+00, 8.0277563028E-01, 6.4829269045E-01, 6.8101137564E-01],
	[1.5055000000E+04, 8.1249464414E+00, 5.7566974164E+00, 8.0362407079E-01, 6.4886552925E-01, 6.8114412908E-01],
	[1.5060000000E+04, 8.1286669229E+00, 5.7563749496E+00, 8.0447312525E-01, 6.4943859850E-01, 6.8127684895E-01],
	[1.5065000000E+04, 8.1323878722E+00, 5.7560526078E+00, 8.0532279390E-01, 6.5001189332E-01, 6.8140953522E-01],
	[1.5070000000E+04, 8.1361092891E+00, 5.7557303910E+00, 8.0617307697E-01, 6.5058541356E-01, 6.8154218789E-01],
	[1.5075000000E+04, 8.1398311736E+00, 5.7554082992E+00, 8.0702397472E-01, 6.5115915908E-01, 6.8167480694E-01],
	[1.5080000000E+04, 8.1435535257E+00, 5.7550863322E+00, 8.0787548737E-01, 6.5173312974E-01, 6.8180739234E-01],
	[1.5085000000E+04, 8.1472763451E+00, 5.7547644899E+00, 8.0872761517E-01, 6.5230732539E-01, 6.8193994410E-01],
	[1.5090000000E+04, 8.1509996318E+00, 5.7544427722E+00, 8.0958035835E-01, 6.5288174589E-01, 6.8207246220E-01],
	[1.5095000000E+04, 8.1547233857E+00, 5.7541211791E+00, 8.1043371716E-01, 6.5345639111E-01, 6.8220494661E-01],
	[1.5100000000E+04, 8.1584476066E+00, 5.7537997105E+00, 8.1128769184E-01, 6.5403126090E-01, 6.8233739734E-01],
	[1.5105000000E+04, 8.1621722947E+00, 5.7534783663E+00, 8.1214228262E-01, 6.5460635511E-01, 6.8246981435E-01],
	[1.5110000000E+04, 8.1658974496E+00, 5.7531571464E+00, 8.1299748975E-01, 6.5518167361E-01, 6.8260219765E-01],
	[1.5115000000E+04, 8.1696230713E+00, 5.7528360506E+00, 8.1385331346E-01, 6.5575721625E-01, 6.8273454721E-01],
	[1.5120000000E+04, 8.1733491597E+00, 5.7525150790E+00, 8.1470975399E-01, 6.5633298289E-01, 6.8286686302E-01],
	[1.5125000000E+04, 8.1770757148E+00, 5.7521942314E+00, 8.1556681159E-01, 6.5690897338E-01, 6.8299914507E-01],
	[1.5130000000E+04, 8.1808027364E+00, 5.7518735077E+00, 8.1642448649E-01, 6.5748518759E-01, 6.8313139334E-01],
	[1.5135000000E+04, 8.1845302244E+00, 5.7515529079E+00, 8.1728277894E-01, 6.5806162537E-01, 6.8326360783E-01],
	[1.5140000000E+04, 8.1882581788E+00, 5.7512324318E+00, 8.1814168917E-01, 6.5863828657E-01, 6.8339578851E-01],
	[1.5145000000E+04, 8.1919865994E+00, 5.7509120794E+00, 8.1900121742E-01, 6.5921517106E-01, 6.8352793537E-01],
	[1.5150000000E+04, 8.1957154862E+00, 5.7505918506E+00, 8.1986136394E-01, 6.5979227868E-01, 6.8366004839E-01],
	[1.5155000000E+04, 8.1994448390E+00, 5.7502717453E+00, 8.2072212896E-01, 6.6036960930E-01, 6.8379212758E-01],
	[1.5160000000E+04, 8.2031746577E+00, 5.7499517634E+00, 8.2158351272E-01, 6.6094716277E-01, 6.8392417290E-01],
	[1.5165000000E+04, 8.2069049423E+00, 5.7496319047E+00, 8.2244551546E-01, 6.6152493894E-01, 6.8405618435E-01],
	[1.5170000000E+04, 8.2106356927E+00, 5.7493121694E+00, 8.2330813743E-01, 6.6210293768E-01, 6.8418816191E-01],
	[1.5175000000E+04, 8.2143669087E+00, 5.7489925571E+00, 8.2417137886E-01, 6.6268115884E-01, 6.8432010558E-01],
	[1.5180000000E+04, 8.2180985903E+00, 5.7486730679E+00, 8.2503523999E-01, 6.6325960227E-01, 6.8445201533E-01],
	[1.5185000000E+04, 8.2218307374E+00, 5.7483537017E+00, 8.2589972106E-01, 6.6383826783E-01, 6.8458389115E-01],
	[1.5190000000E+04, 8.2255633499E+00, 5.7480344583E+00, 8.2676482232E-01, 6.6441715537E-01, 6.8471573303E-01],
	[1.5195000000E+04, 8.2292964276E+00, 5.7477153377E+00, 8.2763054399E-01, 6.6499626475E-01, 6.8484754096E-01],
	[1.5200000000E+04, 8.2330299706E+00, 5.7473963399E+00, 8.2849688633E-01, 6.6557559583E-01, 6.8497931493E-01],
	[1.5205000000E+04, 8.2367639786E+00, 5.7470774646E+00, 8.2936384957E-01, 6.6615514845E-01, 6.8511105491E-01],
	[1.5210000000E+04, 8.2404984516E+00, 5.7467587119E+00, 8.3023143395E-01, 6.6673492248E-01, 6.8524276089E-01],
	[1.5215000000E+04, 8.2442333896E+00, 5.7464400816E+00, 8.3109963971E-01, 6.6731491777E-01, 6.8537443287E-01],
	[1.5220000000E+04, 8.2479687923E+00, 5.7461215736E+00, 8.3196846709E-01, 6.6789513417E-01, 6.8550607083E-01],
	[1.5225000000E+04, 8.2517046598E+00, 5.7458031879E+00, 8.3283791634E-01, 6.6847557153E-01, 6.8563767476E-01],
	[1.5230000000E+04, 8.2554409919E+00, 5.7454849244E+00, 8.3370798768E-01, 6.6905622972E-01, 6.8576924464E-01],
	[1.5235000000E+04, 8.2591777885E+00, 5.7451667830E+00, 8.3457868137E-01, 6.6963710858E-01, 6.8590078046E-01],
	[1.5240000000E+04, 8.2629150495E+00, 5.7448487636E+00, 8.3544999764E-01, 6.7021820797E-01, 6.8603228221E-01],
	[1.5245000000E+04, 8.2666527749E+00, 5.7445308661E+00, 8.3632193673E-01, 6.7079952774E-01, 6.8616374987E-01],
	[1.5250000000E+04, 8.2703909645E+00, 5.7442130904E+00, 8.3719449888E-01, 6.7138106775E-01, 6.8629518343E-01],
	[1.5255000000E+04, 8.2741296183E+00, 5.7438954365E+00, 8.3806768434E-01, 6.7196282785E-01, 6.8642658288E-01],
	[1.5260000000E+04, 8.2778687361E+00, 5.7435779042E+00, 8.3894149333E-01, 6.7254480788E-01, 6.8655794820E-01],
	[1.5265000000E+04, 8.2816083179E+00, 5.7432604935E+00, 8.3981592611E-01, 6.7312700772E-01, 6.8668927939E-01],
	[1.5270000000E+04, 8.2853483636E+00, 5.7429432042E+00, 8.4069098291E-01, 6.7370942720E-01, 6.8682057643E-01],
	[1.5275000000E+04, 8.2890888730E+00, 5.7426260364E+00, 8.4156666397E-01, 6.7429206619E-01, 6.8695183930E-01],
	[1.5280000000E+04, 8.2928298461E+00, 5.7423089899E+00, 8.4244296954E-01, 6.7487492453E-01, 6.8708306800E-01],
	[1.5285000000E+04, 8.2965712827E+00, 5.7419920646E+00, 8.4331989984E-01, 6.7545800207E-01, 6.8721426250E-01],
	[1.5290000000E+04, 8.3003131829E+00, 5.7416752604E+00, 8.4419745513E-01, 6.7604129868E-01, 6.8734542281E-01],
	[1.5295000000E+04, 8.3040621314E+00, 5.7413620327E+00, 8.4507563564E-01, 6.7662490590E-01, 6.8747654890E-01],
	[1.5300000000E+04, 8.3078177789E+00, 5.7410521929E+00, 8.4595444162E-01, 6.7720881904E-01, 6.8760764077E-01],
	[1.5305000000E+04, 8.3115738970E+00, 5.7407424710E+00, 8.4683387329E-01, 6.7779295127E-01, 6.8773869839E-01],
	[1.5310000000E+04, 8.3153304856E+00, 5.7404328671E+00, 8.4771393091E-01, 6.7837730247E-01, 6.8786972176E-01],
	[1.5315000000E+04, 8.3190875445E+00, 5.7401233809E+00, 8.4859461472E-01, 6.7896187248E-01, 6.8800071087E-01],
	[1.5320000000E+04, 8.3228450738E+00, 5.7398140124E+00, 8.4947592495E-01, 6.7954666116E-01, 6.8813166570E-01],
	[1.5325000000E+04, 8.3266030733E+00, 5.7395047615E+00, 8.5035786184E-01, 6.8013166835E-01, 6.8826258624E-01],
	[1.5330000000E+04, 8.3303615429E+00, 5.7391956282E+00, 8.5124042564E-01, 6.8071689392E-01, 6.8839347248E-01],
	[1.5335000000E+04, 8.3341204826E+00, 5.7388866123E+00, 8.5212361658E-01, 6.8130233770E-01, 6.8852432441E-01],
	[1.5340000000E+04, 8.3378798921E+00, 5.7385777138E+00, 8.5300743490E-01, 6.8188799956E-01, 6.8865514201E-01],
	[1.5345000000E+04, 8.3416397715E+00, 5.7382689325E+00, 8.5389188085E-01, 6.8247387934E-01, 6.8878592527E-01],
	[1.5350000000E+04, 8.3454001206E+00, 5.7379602685E+00, 8.5477695467E-01, 6.8305997689E-01, 6.8891667417E-01],
	[1.5355000000E+04, 8.3491609393E+00, 5.7376517216E+00, 8.5566265659E-01, 6.8364629208E-01, 6.8904738872E-01],
	[1.5360000000E+04, 8.3529222276E+00, 5.7373432917E+00, 8.5654898686E-01, 6.8423282474E-01, 6.8917806889E-01],
	[1.5365000000E+04, 8.3566839853E+00, 5.7370349788E+00, 8.5743594572E-01, 6.8481957473E-01, 6.8930871467E-01],
	[1.5370000000E+04, 8.3604462124E+00, 5.7367267828E+00, 8.5832353340E-01, 6.8540654191E-01, 6.8943932605E-01],
	[1.5375000000E+04, 8.3642089088E+00, 5.7364187035E+00, 8.5921175015E-01, 6.8599372611E-01, 6.8956990301E-01],
	[1.5380000000E+04, 8.3679720743E+00, 5.7361107410E+00, 8.6010059621E-01, 6.8658112720E-01, 6.8970044556E-01],
	[1.5385000000E+04, 8.3717357089E+00, 5.7358028951E+00, 8.6099007181E-01, 6.8716874502E-01, 6.8983095367E-01],
	[1.5390000000E+04, 8.3754998125E+00, 5.7354951657E+00, 8.6188017721E-01, 6.8775657943E-01, 6.8996142732E-01],
	[1.5395000000E+04, 8.3792643850E+00, 5.7351875528E+00, 8.6277091263E-01, 6.8834463027E-01, 6.9009186652E-01],
	[1.5400000000E+04, 8.3830294263E+00, 5.7348800563E+00, 8.6366227832E-01, 6.8893289739E-01, 6.9022227125E-01],
	[1.5405000000E+04, 8.3867949362E+00, 5.7345726761E+00, 8.6455427453E-01, 6.8952138065E-01, 6.9035264149E-01],
	[1.5410000000E+04, 8.3905609148E+00, 5.7342654121E+00, 8.6544690148E-01, 6.9011007989E-01, 6.9048297724E-01],
	[1.5415000000E+04, 8.3943273619E+00, 5.7339582642E+00, 8.6634015943E-01, 6.9069899496E-01, 6.9061327848E-01],
	[1.5420000000E+04, 8.3980942773E+00, 5.7336512324E+00, 8.6723404860E-01, 6.9128812572E-01, 6.9074354520E-01],
	[1.5425000000E+04, 8.4018616612E+00, 5.7333443165E+00, 8.6812856925E-01, 6.9187747202E-01, 6.9087377739E-01],
	[1.5430000000E+04, 8.4056295132E+00, 5.7330375166E+00, 8.6902372161E-01, 6.9246703369E-01, 6.9100397504E-01],
	[1.5435000000E+04, 8.4093978334E+00, 5.7327308324E+00, 8.6991950592E-01, 6.9305681060E-01, 6.9113413813E-01],
	[1.5440000000E+04, 8.4131666216E+00, 5.7324242640E+00, 8.7081592243E-01, 6.9364680258E-01, 6.9126426665E-01],
	[1.5445000000E+04, 8.4169358778E+00, 5.7321178112E+00, 8.7171297137E-01, 6.9423700950E-01, 6.9139436060E-01],
	[1.5450000000E+04, 8.4207056018E+00, 5.7318114740E+00, 8.7261065299E-01, 6.9482743120E-01, 6.9152441996E-01],
	[1.5455000000E+04, 8.4244757936E+00, 5.7315052523E+00, 8.7350896752E-01, 6.9541806752E-01, 6.9165444472E-01],
	[1.5460000000E+04, 8.4282464531E+00, 5.7311991460E+00, 8.7440791521E-01, 6.9600891833E-01, 6.9178443486E-01],
	[1.5465000000E+04, 8.4320175801E+00, 5.7308931550E+00, 8.7530749629E-01, 6.9659998345E-01, 6.9191439038E-01],
	[1.5470000000E+04, 8.4357891746E+00, 5.7305872793E+00, 8.7620771101E-01, 6.9719126275E-01, 6.9204431127E-01],
	[1.5475000000E+04, 8.4395612365E+00, 5.7302815187E+00, 8.7710855961E-01, 6.9778275607E-01, 6.9217419751E-01],
	[1.5480000000E+04, 8.4433337658E+00, 5.7299758732E+00, 8.7801004233E-01, 6.9837446327E-01, 6.9230404909E-01],
	[1.5485000000E+04, 8.4471067622E+00, 5.7296703427E+00, 8.7891215940E-01, 6.9896638417E-01, 6.9243386601E-01],
	[1.5490000000E+04, 8.4508802257E+00, 5.7293649271E+00, 8.7981491108E-01, 6.9955851865E-01, 6.9256364824E-01],
	[1.5495000000E+04, 8.4546541562E+00, 5.7290596264E+00, 8.8071829760E-01, 7.0015086654E-01, 6.9269339578E-01],
	[1.5500000000E+04, 8.4584285537E+00, 5.7287544404E+00, 8.8162231920E-01, 7.0074342769E-01, 6.9282310862E-01],
	[1.5505000000E+04, 8.4622034180E+00, 5.7284493691E+00, 8.8252697612E-01, 7.0133620195E-01, 6.9295278674E-01],
	[1.5510000000E+04, 8.4659787490E+00, 5.7281444124E+00, 8.8343226860E-01, 7.0192918916E-01, 6.9308243014E-01],
	[1.5515000000E+04, 8.4697545467E+00, 5.7278395702E+00, 8.8433819689E-01, 7.0252238918E-01, 6.9321203881E-01],
	[1.5520000000E+04, 8.4735308109E+00, 5.7275348425E+00, 8.8524476122E-01, 7.0311580185E-01, 6.9334161272E-01],
	[1.5525000000E+04, 8.4773075416E+00, 5.7272302291E+00, 8.8615196184E-01, 7.0370942701E-01, 6.9347115188E-01],
	[1.5530000000E+04, 8.4810847387E+00, 5.7269257300E+00, 8.8705979898E-01, 7.0430326452E-01, 6.9360065627E-01],
	[1.5535000000E+04, 8.4848624020E+00, 5.7266213452E+00, 8.8796827289E-01, 7.0489731422E-01, 6.9373012587E-01],
	[1.5540000000E+04, 8.4886442168E+00, 5.7263189018E+00, 8.8887738380E-01, 7.0549162916E-01, 6.9385956069E-01],
	[1.5545000000E+04, 8.4924361513E+00, 5.7260213554E+00, 8.8978713197E-01, 7.0608629557E-01, 6.9398896070E-01],
	[1.5550000000E+04, 8.4962285594E+00, 5.7257239200E+00, 8.9069751762E-01, 7.0668117423E-01, 6.9411832590E-01],
	[1.5555000000E+04, 8.5000214410E+00, 5.7254265958E+00, 8.9160854101E-01, 7.0727626499E-01, 6.9424765628E-01],
	[1.5560000000E+04, 8.5038147960E+00, 5.7251293825E+00, 8.9252020236E-01, 7.0787156769E-01, 6.9437695182E-01],
	[1.5565000000E+04, 8.5076086243E+00, 5.7248322801E+00, 8.9343250193E-01, 7.0846708217E-01, 6.9450621252E-01],
	[1.5570000000E+04, 8.5114029259E+00, 5.7245352886E+00, 8.9434543995E-01, 7.0906280828E-01, 6.9463543836E-01],
	[1.5575000000E+04, 8.5151977006E+00, 5.7242384079E+00, 8.9525901667E-01, 7.0965874588E-01, 6.9476462934E-01],
	[1.5580000000E+04, 8.5189929483E+00, 5.7239416378E+00, 8.9617323231E-01, 7.1025489480E-01, 6.9489378543E-01],
	[1.5585000000E+04, 8.5227886690E+00, 5.7236449783E+00, 8.9708808714E-01, 7.1085125490E-01, 6.9502290664E-01],
	[1.5590000000E+04, 8.5265848625E+00, 5.7233484293E+00, 8.9800358138E-01, 7.1144782601E-01, 6.9515199295E-01],
	[1.5595000000E+04, 8.5303815288E+00, 5.7230519908E+00, 8.9891971528E-01, 7.1204460799E-01, 6.9528104435E-01],
	[1.5600000000E+04, 8.5341786678E+00, 5.7227556627E+00, 8.9983648907E-01, 7.1264160067E-01, 6.9541006084E-01],
	[1.5605000000E+04, 8.5379762793E+00, 5.7224594449E+00, 9.0075390301E-01, 7.1323880391E-01, 6.9553904239E-01],
	[1.5610000000E+04, 8.5417743633E+00, 5.7221633373E+00, 9.0167195732E-01, 7.1383621756E-01, 6.9566798900E-01],
	[1.5615000000E+04, 8.5455729197E+00, 5.7218673398E+00, 9.0259065226E-01, 7.1443384145E-01, 6.9579690066E-01],
	[1.5620000000E+04, 8.5493719484E+00, 5.7215714524E+00, 9.0350998806E-01, 7.1503167543E-01, 6.9592577736E-01],
	[1.5625000000E+04, 8.5531714493E+00, 5.7212756750E+00, 9.0442996496E-01, 7.1562971935E-01, 6.9605461909E-01],
	[1.5630000000E+04, 8.5569714224E+00, 5.7209800075E+00, 9.0535058321E-01, 7.1622797305E-01, 6.9618342583E-01],
	[1.5635000000E+04, 8.5607718674E+00, 5.7206844499E+00, 9.0627184305E-01, 7.1682643638E-01, 6.9631219758E-01],
	[1.5640000000E+04, 8.5645727844E+00, 5.7203890020E+00, 9.0719374471E-01, 7.1742510918E-01, 6.9644093434E-01],
	[1.5645000000E+04, 8.5683741732E+00, 5.7200936638E+00, 9.0811628843E-01, 7.1802399129E-01, 6.9656963607E-01],
	[1.5650000000E+04, 8.5721760337E+00, 5.7197984352E+00, 9.0903947447E-01, 7.1862308257E-01, 6.9669830279E-01],
	[1.5655000000E+04, 8.5759783659E+00, 5.7195033162E+00, 9.0996330306E-01, 7.1922238285E-01, 6.9682693447E-01],
	[1.5660000000E+04, 8.5797811697E+00, 5.7192083066E+00, 9.1088777444E-01, 7.1982189199E-01, 6.9695553111E-01],
	[1.5665000000E+04, 8.5835844449E+00, 5.7189134064E+00, 9.1181288885E-01, 7.2042160981E-01, 6.9708409270E-01],
	[1.5670000000E+04, 8.5873881915E+00, 5.7186186155E+00, 9.1273864653E-01, 7.2102153618E-01, 6.9721261922E-01],
	[1.5675000000E+04, 8.5911924094E+00, 5.7183239338E+00, 9.1366504773E-01, 7.2162167093E-01, 6.9734111067E-01],
	[1.5680000000E+04, 8.5949970985E+00, 5.7180293614E+00, 9.1459209268E-01, 7.2222201390E-01, 6.9746956704E-01],
	[1.5685000000E+04, 8.5988022587E+00, 5.7177348980E+00, 9.1551978163E-01, 7.2282256494E-01, 6.9759798831E-01],
	[1.5690000000E+04, 8.6026078899E+00, 5.7174405436E+00, 9.1644811482E-01, 7.2342332390E-01, 6.9772637448E-01],
	[1.5695000000E+04, 8.6064139920E+00, 5.7171462981E+00, 9.1737709249E-01, 7.2402429061E-01, 6.9785472554E-01],
	[1.5700000000E+04, 8.6102205649E+00, 5.7168521615E+00, 9.1830671488E-01, 7.2462546492E-01, 6.9798304148E-01],
	[1.5705000000E+04, 8.6140276086E+00, 5.7165581337E+00, 9.1923698223E-01, 7.2522684668E-01, 6.9811132228E-01],
	[1.5710000000E+04, 8.6178351229E+00, 5.7162642146E+00, 9.2016789479E-01, 7.2582843572E-01, 6.9823956794E-01],
	[1.5715000000E+04, 8.6216431077E+00, 5.7159704041E+00, 9.2109945279E-01, 7.2643023189E-01, 6.9836777845E-01],
	[1.5720000000E+04, 8.6254515630E+00, 5.7156767022E+00, 9.2203165647E-01, 7.2703223504E-01, 6.9849595380E-01],
	[1.5725000000E+04, 8.6292604887E+00, 5.7153831088E+00, 9.2296450609E-01, 7.2763444500E-01, 6.9862409396E-01],
	[1.5730000000E+04, 8.6330698847E+00, 5.7150896238E+00, 9.2389800187E-01, 7.2823686161E-01, 6.9875219892E-01],
	[1.5735000000E+04, 8.6368797508E+00, 5.7147962471E+00, 9.2483214406E-01, 7.2883948473E-01, 6.9888026866E-01],
	[1.5740000000E+04, 8.6406900870E+00, 5.7145029787E+00, 9.2576693290E-01, 7.2944231419E-01, 6.9900830316E-01],
	[1.5745000000E+04, 8.6445008932E+00, 5.7142098184E+00, 9.2670236863E-01, 7.3004534984E-01, 6.9913630242E-01],
	[1.5750000000E+04, 8.6483121694E+00, 5.7139167663E+00, 9.2763845150E-01, 7.3064859151E-01, 6.9926426642E-01],
	[1.5755000000E+04, 8.6521239153E+00, 5.7136238223E+00, 9.2857518174E-01, 7.3125203905E-01, 6.9939219514E-01],
	[1.5760000000E+04, 8.6559361310E+00, 5.7133309862E+00, 9.2951255960E-01, 7.3185569230E-01, 6.9952008858E-01],
	[1.5765000000E+04, 8.6597488163E+00, 5.7130382579E+00, 9.3045058532E-01, 7.3245955111E-01, 6.9964794672E-01],
	[1.5770000000E+04, 8.6635619712E+00, 5.7127456375E+00, 9.3138925913E-01, 7.3306361531E-01, 6.9977576954E-01],
	[1.5775000000E+04, 8.6673755955E+00, 5.7124531249E+00, 9.3232858129E-01, 7.3366788474E-01, 6.9990355704E-01],
	[1.5780000000E+04, 8.6711896891E+00, 5.7121607199E+00, 9.3326855203E-01, 7.3427235926E-01, 7.0003130920E-01],
	[1.5785000000E+04, 8.6750042521E+00, 5.7118684225E+00, 9.3420917159E-01, 7.3487703869E-01, 7.0015902601E-01],
	[1.5790000000E+04, 8.6788226975E+00, 5.7115778337E+00, 9.3515044022E-01, 7.3548197394E-01, 7.0028670745E-01],
	[1.5795000000E+04, 8.6826520643E+00, 5.7112922511E+00, 9.3609235816E-01, 7.3608727042E-01, 7.0041435351E-01],
	[1.5800000000E+04, 8.6864819080E+00, 5.7110067731E+00, 9.3703492564E-01, 7.3669277189E-01, 7.0054196418E-01],
	[1.5805000000E+04, 8.6903122283E+00, 5.7107213998E+00, 9.3797814291E-01, 7.3729847818E-01, 7.0066953945E-01],
	[1.5810000000E+04, 8.6941430253E+00, 5.7104361309E+00, 9.3892201022E-01, 7.3790438913E-01, 7.0079707930E-01],
	[1.5815000000E+04, 8.6979742988E+00, 5.7101509665E+00, 9.3986652779E-01, 7.3851050459E-01, 7.0092458372E-01],
	[1.5820000000E+04, 8.7018060488E+00, 5.7098659065E+00, 9.4081169588E-01, 7.3911682440E-01, 7.0105205270E-01],
	[1.5825000000E+04, 8.7056382751E+00, 5.7095809508E+00, 9.4175751473E-01, 7.3972334840E-01, 7.0117948622E-01],
	[1.5830000000E+04, 8.7094709778E+00, 5.7092960993E+00, 9.4270398457E-01, 7.4033007643E-01, 7.0130688427E-01],
	[1.5835000000E+04, 8.7133041565E+00, 5.7090113520E+00, 9.4365110566E-01, 7.4093700833E-01, 7.0143424684E-01],
	[1.5840000000E+04, 8.7171378114E+00, 5.7087267087E+00, 9.4459887822E-01, 7.4154414394E-01, 7.0156157392E-01],
	[1.5845000000E+04, 8.7209719423E+00, 5.7084421695E+00, 9.4554730251E-01, 7.4215148311E-01, 7.0168886549E-01],
	[1.5850000000E+04, 8.7248065490E+00, 5.7081577342E+00, 9.4649637876E-01, 7.4275902567E-01, 7.0181612154E-01],
	[1.5855000000E+04, 8.7286416316E+00, 5.7078734029E+00, 9.4744610721E-01, 7.4336677146E-01, 7.0194334207E-01],
	[1.5860000000E+04, 8.7324771899E+00, 5.7075891753E+00, 9.4839648811E-01, 7.4397472032E-01, 7.0207052704E-01],
	[1.5865000000E+04, 8.7363132239E+00, 5.7073050515E+00, 9.4934752170E-01, 7.4458287210E-01, 7.0219767647E-01],
	[1.5870000000E+04, 8.7401497333E+00, 5.7070210313E+00, 9.5029920822E-01, 7.4519122664E-01, 7.0232479032E-01],
	[1.5875000000E+04, 8.7439867183E+00, 5.7067371147E+00, 9.5125154792E-01, 7.4579978377E-01, 7.0245186859E-01],
	[1.5880000000E+04, 8.7478241785E+00, 5.7064533017E+00, 9.5220454102E-01, 7.4640854333E-01, 7.0257891127E-01],
	[1.5885000000E+04, 8.7516621141E+00, 5.7061695921E+00, 9.5315818778E-01, 7.4701750517E-01, 7.0270591834E-01],
	[1.5890000000E+04, 8.7555005248E+00, 5.7058859859E+00, 9.5411248844E-01, 7.4762666912E-01, 7.0283288980E-01],
	[1.5895000000E+04, 8.7593394106E+00, 5.7056024830E+00, 9.5506744324E-01, 7.4823603502E-01, 7.0295982562E-01],
	[1.5900000000E+04, 8.7631787714E+00, 5.7053190833E+00, 9.5602305242E-01, 7.4884560271E-01, 7.0308672581E-01],
	[1.5905000000E+04, 8.7670186071E+00, 5.7050357869E+00, 9.5697931622E-01, 7.4945537204E-01, 7.0321359033E-01],
	[1.5910000000E+04, 8.7708589176E+00, 5.7047525935E+00, 9.5793623489E-01, 7.5006534283E-01, 7.0334041919E-01],
	[1.5915000000E+04, 8.7746997029E+00, 5.7044695032E+00, 9.5889380866E-01, 7.5067551494E-01, 7.0346721238E-01],
	[1.5920000000E+04, 8.7785409628E+00, 5.7041865158E+00, 9.5985203778E-01, 7.5128588819E-01, 7.0359396987E-01],
	[1.5925000000E+04, 8.7823826972E+00, 5.7039036313E+00, 9.6081092249E-01, 7.5189646243E-01, 7.0372069166E-01],
	[1.5930000000E+04, 8.7862249061E+00, 5.7036208497E+00, 9.6177046303E-01, 7.5250723750E-01, 7.0384737773E-01],
	[1.5935000000E+04, 8.7900675893E+00, 5.7033381708E+00, 9.6273065964E-01, 7.5311821323E-01, 7.0397402808E-01],
	[1.5940000000E+04, 8.7939107468E+00, 5.7030555946E+00, 9.6369151257E-01, 7.5372938947E-01, 7.0410064269E-01],
	[1.5945000000E+04, 8.7977543785E+00, 5.7027731210E+00, 9.6465302206E-01, 7.5434076604E-01, 7.0422722155E-01],
	[1.5950000000E+04, 8.8015984842E+00, 5.7024907500E+00, 9.6561518834E-01, 7.5495234280E-01, 7.0435376465E-01],
	[1.5955000000E+04, 8.8054430640E+00, 5.7022084814E+00, 9.6657801167E-01, 7.5556411957E-01, 7.0448027197E-01],
	[1.5960000000E+04, 8.8092881177E+00, 5.7019263153E+00, 9.6754149228E-01, 7.5617609620E-01, 7.0460674351E-01],
	[1.5965000000E+04, 8.8131336452E+00, 5.7016442515E+00, 9.6850563041E-01, 7.5678827253E-01, 7.0473317925E-01],
	[1.5970000000E+04, 8.8169796464E+00, 5.7013622899E+00, 9.6947042631E-01, 7.5740064838E-01, 7.0485957919E-01],
	[1.5975000000E+04, 8.8208261213E+00, 5.7010804306E+00, 9.7043588022E-01, 7.5801322361E-01, 7.0498594330E-01],
	[1.5980000000E+04, 8.8246730697E+00, 5.7007986734E+00, 9.7140199238E-01, 7.5862599804E-01, 7.0511227158E-01],
	[1.5985000000E+04, 8.8285204916E+00, 5.7005170183E+00, 9.7236876303E-01, 7.5923897151E-01, 7.0523856402E-01],
	[1.5990000000E+04, 8.8323683869E+00, 5.7002354651E+00, 9.7333619241E-01, 7.5985214387E-01, 7.0536482060E-01],
	[1.5995000000E+04, 8.8362167554E+00, 5.6999540139E+00, 9.7430428078E-01, 7.6046551495E-01, 7.0549104132E-01],
	[1.6000000000E+04, 8.8400655972E+00, 5.6996726646E+00, 9.7527302836E-01, 7.6107908458E-01, 7.0561722615E-01],
	[1.6005000000E+04, 8.8439149120E+00, 5.6993914170E+00, 9.7624243540E-01, 7.6169285261E-01, 7.0574337510E-01],
	[1.6010000000E+04, 8.8477646998E+00, 5.6991102711E+00, 9.7721250214E-01, 7.6230681886E-01, 7.0586948815E-01],
	[1.6015000000E+04, 8.8516149606E+00, 5.6988292270E+00, 9.7818322883E-01, 7.6292098319E-01, 7.0599556529E-01],
	[1.6020000000E+04, 8.8554656942E+00, 5.6985482843E+00, 9.7915461570E-01, 7.6353534541E-01, 7.0612160650E-01],
	[1.6025000000E+04, 8.8593169005E+00, 5.6982674432E+00, 9.8012666300E-01, 7.6414990538E-01, 7.0624761178E-01],
	[1.6030000000E+04, 8.8631685795E+00, 5.6979867036E+00, 9.8109937098E-01, 7.6476466292E-01, 7.0637358111E-01],
	[1.6035000000E+04, 8.8670207311E+00, 5.6977060653E+00, 9.8207273986E-01, 7.6537961788E-01, 7.0649951449E-01],
	[1.6040000000E+04, 8.8708733551E+00, 5.6974255284E+00, 9.8304676990E-01, 7.6599477009E-01, 7.0662541190E-01],
	[1.6045000000E+04, 8.8747323640E+00, 5.6971477183E+00, 9.8402146134E-01, 7.6661021104E-01, 7.0675127333E-01],
	[1.6050000000E+04, 8.8786003338E+00, 5.6968737748E+00, 9.8499681442E-01, 7.6722598082E-01, 7.0687709877E-01],
	[1.6055000000E+04, 8.8824687838E+00, 5.6965999298E+00, 9.8597282938E-01, 7.6784194793E-01, 7.0700288821E-01],
	[1.6060000000E+04, 8.8863377140E+00, 5.6963261832E+00, 9.8694950646E-01, 7.6845811219E-01, 7.0712864164E-01],
	[1.6065000000E+04, 8.8902071242E+00, 5.6960525349E+00, 9.8792684591E-01, 7.6907447345E-01, 7.0725435904E-01],
	[1.6070000000E+04, 8.8940770145E+00, 5.6957789850E+00, 9.8890484796E-01, 7.6969103155E-01, 7.0738004041E-01],
	[1.6075000000E+04, 8.8979473846E+00, 5.6955055333E+00, 9.8988351287E-01, 7.7030778631E-01, 7.0750568574E-01],
	[1.6080000000E+04, 8.9018182344E+00, 5.6952321797E+00, 9.9086284086E-01, 7.7092473758E-01, 7.0763129501E-01],
	[1.6085000000E+04, 8.9056895640E+00, 5.6949589243E+00, 9.9184283220E-01, 7.7154188519E-01, 7.0775686822E-01],
	[1.6090000000E+04, 8.9095613732E+00, 5.6946857668E+00, 9.9282348710E-01, 7.7215922898E-01, 7.0788240535E-01],
	[1.6095000000E+04, 8.9134336620E+00, 5.6944127074E+00, 9.9380480583E-01, 7.7277676878E-01, 7.0800790639E-01],
	[1.6100000000E+04, 8.9173064301E+00, 5.6941397458E+00, 9.9478678862E-01, 7.7339450443E-01, 7.0813337133E-01],
	[1.6105000000E+04, 8.9211796777E+00, 5.6938668821E+00, 9.9576943571E-01, 7.7401243576E-01, 7.0825880017E-01],
	[1.6110000000E+04, 8.9250534044E+00, 5.6935941162E+00, 9.9675274735E-01, 7.7463056262E-01, 7.0838419288E-01],
	[1.6115000000E+04, 8.9289276104E+00, 5.6933214479E+00, 9.9773672377E-01, 7.7524888482E-01, 7.0850954947E-01],
	[1.6120000000E+04, 8.9328022954E+00, 5.6930488773E+00, 9.9872136523E-01, 7.7586740222E-01, 7.0863486992E-01],
	[1.6125000000E+04, 8.9366774594E+00, 5.6927764043E+00, 9.9970667196E-01, 7.7648611465E-01, 7.0876015421E-01],
	[1.6130000000E+04, 8.9405531023E+00, 5.6925040288E+00, 1.0006926442E+00, 7.7710502193E-01, 7.0888540234E-01],
	[1.6135000000E+04, 8.9444292240E+00, 5.6922317507E+00, 1.0016792822E+00, 7.7772412391E-01, 7.0901061430E-01],
	[1.6140000000E+04, 8.9483058245E+00, 5.6919595700E+00, 1.0026665862E+00, 7.7834342043E-01, 7.0913579008E-01],
	[1.6145000000E+04, 8.9521829035E+00, 5.6916874866E+00, 1.0036545564E+00, 7.7896291130E-01, 7.0926092967E-01],
	[1.6150000000E+04, 8.9560604611E+00, 5.6914155005E+00, 1.0046431932E+00, 7.7958259638E-01, 7.0938603306E-01],
	[1.6155000000E+04, 8.9599384972E+00, 5.6911436115E+00, 1.0056324966E+00, 7.8020247549E-01, 7.0951110023E-01],
	[1.6160000000E+04, 8.9638170116E+00, 5.6908718197E+00, 1.0066224670E+00, 7.8082254847E-01, 7.0963613118E-01],
	[1.6165000000E+04, 8.9676960043E+00, 5.6906001249E+00, 1.0076131047E+00, 7.8144281515E-01, 7.0976112589E-01],
	[1.6170000000E+04, 8.9715754752E+00, 5.6903285272E+00, 1.0086044098E+00, 7.8206327537E-01, 7.0988608436E-01],
	[1.6175000000E+04, 8.9754554242E+00, 5.6900570263E+00, 1.0095963826E+00, 7.8268392896E-01, 7.1001100658E-01],
	[1.6180000000E+04, 8.9793358512E+00, 5.6897856223E+00, 1.0105890233E+00, 7.8330477576E-01, 7.1013589253E-01],
	[1.6185000000E+04, 8.9832167561E+00, 5.6895143151E+00, 1.0115823322E+00, 7.8392581560E-01, 7.1026074221E-01],
	[1.6190000000E+04, 8.9870981388E+00, 5.6892431046E+00, 1.0125763095E+00, 7.8454704831E-01, 7.1038555561E-01],
	[1.6195000000E+04, 8.9909799993E+00, 5.6889719908E+00, 1.0135709555E+00, 7.8516847372E-01, 7.1051033271E-01],
	[1.6200000000E+04, 8.9948623374E+00, 5.6887009736E+00, 1.0145662704E+00, 7.8579009168E-01, 7.1063507351E-01],
	[1.6205000000E+04, 8.9987451531E+00, 5.6884300530E+00, 1.0155622545E+00, 7.8641190201E-01, 7.1075977800E-01],
	[1.6210000000E+04, 9.0026284463E+00, 5.6881592288E+00, 1.0165589079E+00, 7.8703390455E-01, 7.1088444616E-01],
	[1.6215000000E+04, 9.0065122169E+00, 5.6878885010E+00, 1.0175562310E+00, 7.8765609913E-01, 7.1100907799E-01],
	[1.6220000000E+04, 9.0103964647E+00, 5.6876178696E+00, 1.0185542240E+00, 7.8827848559E-01, 7.1113367348E-01],
	[1.6225000000E+04, 9.0142811898E+00, 5.6873473345E+00, 1.0195528871E+00, 7.8890106375E-01, 7.1125823261E-01],
	[1.6230000000E+04, 9.0181663920E+00, 5.6870768956E+00, 1.0205522205E+00, 7.8952383345E-01, 7.1138275539E-01],
	[1.6235000000E+04, 9.0220520712E+00, 5.6868065528E+00, 1.0215522246E+00, 7.9014679453E-01, 7.1150724179E-01],
	[1.6240000000E+04, 9.0259382274E+00, 5.6865363061E+00, 1.0225528995E+00, 7.9076994681E-01, 7.1163169181E-01],
	[1.6245000000E+04, 9.0298248604E+00, 5.6862661555E+00, 1.0235542455E+00, 7.9139329013E-01, 7.1175610543E-01],
	[1.6250000000E+04, 9.0337119702E+00, 5.6859961008E+00, 1.0245562628E+00, 7.9201682432E-01, 7.1188048266E-01],
	[1.6255000000E+04, 9.0375995567E+00, 5.6857261420E+00, 1.0255589517E+00, 7.9264054922E-01, 7.1200482347E-01],
	[1.6260000000E+04, 9.0414876198E+00, 5.6854562791E+00, 1.0265623125E+00, 7.9326446465E-01, 7.1212912787E-01],
	[1.6265000000E+04, 9.0453761593E+00, 5.6851865119E+00, 1.0275663453E+00, 7.9388857045E-01, 7.1225339584E-01],
	[1.6270000000E+04, 9.0492651753E+00, 5.6849168404E+00, 1.0285710504E+00, 7.9451286646E-01, 7.1237762737E-01],
	[1.6275000000E+04, 9.0531546676E+00, 5.6846472646E+00, 1.0295764280E+00, 7.9513735249E-01, 7.1250182245E-01],
	[1.6280000000E+04, 9.0570446362E+00, 5.6843777844E+00, 1.0305824785E+00, 7.9576202839E-01, 7.1262598107E-01],
	[1.6285000000E+04, 9.0609350809E+00, 5.6841083997E+00, 1.0315892019E+00, 7.9638689399E-01, 7.1275010322E-01],
	[1.6290000000E+04, 9.0648260016E+00, 5.6838391104E+00, 1.0325965987E+00, 7.9701194912E-01, 7.1287418890E-01],
	[1.6295000000E+04, 9.0687173984E+00, 5.6835699166E+00, 1.0336046689E+00, 7.9763719361E-01, 7.1299823810E-01],
	[1.6300000000E+04, 9.0726092710E+00, 5.6833008180E+00, 1.0346134130E+00, 7.9826262729E-01, 7.1312225080E-01],
	[1.6305000000E+04, 9.0765129248E+00, 5.6830365722E+00, 1.0356228310E+00, 7.9888843158E-01, 7.1324622699E-01],
	[1.6310000000E+04, 9.0804206944E+00, 5.6827739481E+00, 1.0366329233E+00, 7.9951448361E-01, 7.1337016668E-01],
	[1.6315000000E+04, 9.0843289480E+00, 5.6825114167E+00, 1.0376436901E+00, 8.0014072492E-01, 7.1349406984E-01],
	[1.6320000000E+04, 9.0882376853E+00, 5.6822489778E+00, 1.0386551316E+00, 8.0076715533E-01, 7.1361793647E-01],
	[1.6325000000E+04, 9.0921469063E+00, 5.6819866314E+00, 1.0396672481E+00, 8.0139377469E-01, 7.1374176656E-01],
	[1.6330000000E+04, 9.0960566110E+00, 5.6817243775E+00, 1.0406800398E+00, 8.0202058282E-01, 7.1386556010E-01],
	[1.6335000000E+04, 9.0999667992E+00, 5.6814622159E+00, 1.0416935069E+00, 8.0264757955E-01, 7.1398931709E-01],
	[1.6340000000E+04, 9.1038774708E+00, 5.6812001467E+00, 1.0427076498E+00, 8.0327476472E-01, 7.1411303751E-01],
	[1.6345000000E+04, 9.1077886258E+00, 5.6809381697E+00, 1.0437224686E+00, 8.0390213816E-01, 7.1423672135E-01],
	[1.6350000000E+04, 9.1117002640E+00, 5.6806762850E+00, 1.0447379636E+00, 8.0452969970E-01, 7.1436036861E-01],
	[1.6355000000E+04, 9.1156123854E+00, 5.6804144923E+00, 1.0457541350E+00, 8.0515744917E-01, 7.1448397927E-01],
	[1.6360000000E+04, 9.1195249899E+00, 5.6801527918E+00, 1.0467709832E+00, 8.0578538640E-01, 7.1460755333E-01],
	[1.6365000000E+04, 9.1234380774E+00, 5.6798911833E+00, 1.0477885082E+00, 8.0641351123E-01, 7.1473109078E-01],
	[1.6370000000E+04, 9.1273516477E+00, 5.6796296667E+00, 1.0488067104E+00, 8.0704182347E-01, 7.1485459161E-01],
	[1.6375000000E+04, 9.1312657010E+00, 5.6793682421E+00, 1.0498255900E+00, 8.0767032298E-01, 7.1497805582E-01],
	[1.6380000000E+04, 9.1351802369E+00, 5.6791069093E+00, 1.0508451472E+00, 8.0829900956E-01, 7.1510148338E-01],
	[1.6385000000E+04, 9.1390952555E+00, 5.6788456682E+00, 1.0518653824E+00, 8.0892788307E-01, 7.1522487430E-01],
	[1.6390000000E+04, 9.1430107567E+00, 5.6785845189E+00, 1.0528862956E+00, 8.0955694332E-01, 7.1534822857E-01],
	[1.6395000000E+04, 9.1469267403E+00, 5.6783234613E+00, 1.0539078873E+00, 8.1018619014E-01, 7.1547154618E-01],
	[1.6400000000E+04, 9.1508432063E+00, 5.6780624952E+00, 1.0549301575E+00, 8.1081562338E-01, 7.1559482711E-01],
	[1.6405000000E+04, 9.1547601546E+00, 5.6778016207E+00, 1.0559531067E+00, 8.1144524285E-01, 7.1571807136E-01],
	[1.6410000000E+04, 9.1586775851E+00, 5.6775408376E+00, 1.0569767349E+00, 8.1207504839E-01, 7.1584127893E-01],
	[1.6415000000E+04, 9.1625954977E+00, 5.6772801460E+00, 1.0580010425E+00, 8.1270503983E-01, 7.1596444980E-01],
	[1.6420000000E+04, 9.1665138924E+00, 5.6770195457E+00, 1.0590260297E+00, 8.1333521700E-01, 7.1608758396E-01],
	[1.6425000000E+04, 9.1704327690E+00, 5.6767590368E+00, 1.0600516967E+00, 8.1396557972E-01, 7.1621068141E-01],
	[1.6430000000E+04, 9.1743521275E+00, 5.6764986190E+00, 1.0610780438E+00, 8.1459612783E-01, 7.1633374214E-01],
	[1.6435000000E+04, 9.1782719677E+00, 5.6762382925E+00, 1.0621050712E+00, 8.1522686117E-01, 7.1645676614E-01],
	[1.6440000000E+04, 9.1821922896E+00, 5.6759780571E+00, 1.0631327791E+00, 8.1585777954E-01, 7.1657975341E-01],
	[1.6445000000E+04, 9.1861130932E+00, 5.6757179127E+00, 1.0641611679E+00, 8.1648888280E-01, 7.1670270392E-01],
	[1.6450000000E+04, 9.1900343782E+00, 5.6754578593E+00, 1.0651902378E+00, 8.1712017076E-01, 7.1682561769E-01],
	[1.6455000000E+04, 9.1939561446E+00, 5.6751978969E+00, 1.0662199889E+00, 8.1775164325E-01, 7.1694849469E-01],
	[1.6460000000E+04, 9.1978783924E+00, 5.6749380254E+00, 1.0672504215E+00, 8.1838330012E-01, 7.1707133492E-01],
	[1.6465000000E+04, 9.2018011214E+00, 5.6746782447E+00, 1.0682815360E+00, 8.1901514117E-01, 7.1719413837E-01],
	[1.6470000000E+04, 9.2057243316E+00, 5.6744185547E+00, 1.0693133325E+00, 8.1964716625E-01, 7.1731690503E-01],
	[1.6475000000E+04, 9.2096480229E+00, 5.6741589555E+00, 1.0703458112E+00, 8.2027937518E-01, 7.1743963490E-01],
	[1.6480000000E+04, 9.2135721951E+00, 5.6738994468E+00, 1.0713789724E+00, 8.2091176779E-01, 7.1756232797E-01],
	[1.6485000000E+04, 9.2174968482E+00, 5.6736400288E+00, 1.0724128164E+00, 8.2154434392E-01, 7.1768498423E-01],
	[1.6490000000E+04, 9.2214219822E+00, 5.6733807013E+00, 1.0734473434E+00, 8.2217710338E-01, 7.1780760367E-01],
	[1.6495000000E+04, 9.2253475969E+00, 5.6731214643E+00, 1.0744825536E+00, 8.2281004601E-01, 7.1793018628E-01],
	[1.6500000000E+04, 9.2292736922E+00, 5.6728623177E+00, 1.0755184473E+00, 8.2344317163E-01, 7.1805273207E-01],
	[1.6505000000E+04, 9.2332002680E+00, 5.6726032614E+00, 1.0765550248E+00, 8.2407648008E-01, 7.1817524100E-01],
	[1.6510000000E+04, 9.2371273244E+00, 5.6723442954E+00, 1.0775922862E+00, 8.2470997118E-01, 7.1829771309E-01],
	[1.6515000000E+04, 9.2410548611E+00, 5.6720854197E+00, 1.0786302318E+00, 8.2534364477E-01, 7.1842014833E-01],
	[1.6520000000E+04, 9.2449828781E+00, 5.6718266341E+00, 1.0796688619E+00, 8.2597750066E-01, 7.1854254670E-01],
	[1.6525000000E+04, 9.2489113753E+00, 5.6715679387E+00, 1.0807081766E+00, 8.2661153869E-01, 7.1866490819E-01],
	[1.6530000000E+04, 9.2528403526E+00, 5.6713093333E+00, 1.0817481764E+00, 8.2724575868E-01, 7.1878723281E-01],
	[1.6535000000E+04, 9.2567698099E+00, 5.6710508179E+00, 1.0827888613E+00, 8.2788016047E-01, 7.1890952054E-01],
	[1.6540000000E+04, 9.2606997472E+00, 5.6707923924E+00, 1.0838302316E+00, 8.2851474388E-01, 7.1903177137E-01],
	[1.6545000000E+04, 9.2646301644E+00, 5.6705340568E+00, 1.0848722876E+00, 8.2914950874E-01, 7.1915398530E-01],
	[1.6550000000E+04, 9.2685610613E+00, 5.6702758111E+00, 1.0859150295E+00, 8.2978445488E-01, 7.1927616232E-01],
	[1.6555000000E+04, 9.2724924379E+00, 5.6700176551E+00, 1.0869584576E+00, 8.3041958212E-01, 7.1939830243E-01],
	[1.6560000000E+04, 9.2764242941E+00, 5.6697595888E+00, 1.0880025721E+00, 8.3105489029E-01, 7.1952040560E-01],
	[1.6565000000E+04, 9.2803608314E+00, 5.6695032896E+00, 1.0890473732E+00, 8.3169044906E-01, 7.1964247185E-01],
	[1.6570000000E+04, 9.2843091373E+00, 5.6692515837E+00, 1.0900928612E+00, 8.3232637639E-01, 7.1976450116E-01],
	[1.6575000000E+04, 9.2882579310E+00, 5.6689999648E+00, 1.0911390364E+00, 8.3296248475E-01, 7.1988649352E-01],
	[1.6580000000E+04, 9.2922072124E+00, 5.6687484330E+00, 1.0921858989E+00, 8.3359877396E-01, 7.2000844893E-01],
	[1.6585000000E+04, 9.2961569814E+00, 5.6684969882E+00, 1.0932334490E+00, 8.3423524386E-01, 7.2013036737E-01],
	[1.6590000000E+04, 9.3001072380E+00, 5.6682456304E+00, 1.0942816870E+00, 8.3487189427E-01, 7.2025224885E-01],
	[1.6595000000E+04, 9.3040579821E+00, 5.6679943594E+00, 1.0953306131E+00, 8.3550872503E-01, 7.2037409335E-01],
	[1.6600000000E+04, 9.3080092136E+00, 5.6677431753E+00, 1.0963802276E+00, 8.3614573595E-01, 7.2049590087E-01],
	[1.6605000000E+04, 9.3119609323E+00, 5.6674920779E+00, 1.0974305307E+00, 8.3678292687E-01, 7.2061767140E-01],
	[1.6610000000E+04, 9.3159131383E+00, 5.6672410673E+00, 1.0984815226E+00, 8.3742029761E-01, 7.2073940493E-01],
	[1.6615000000E+04, 9.3198658313E+00, 5.6669901433E+00, 1.0995332035E+00, 8.3805784800E-01, 7.2086110146E-01],
	[1.6620000000E+04, 9.3238190114E+00, 5.6667393059E+00, 1.1005855738E+00, 8.3869557787E-01, 7.2098276097E-01],
	[1.6625000000E+04, 9.3277726785E+00, 5.6664885551E+00, 1.1016386337E+00, 8.3933348704E-01, 7.2110438347E-01],
	[1.6630000000E+04, 9.3317268324E+00, 5.6662378907E+00, 1.1026923834E+00, 8.3997157535E-01, 7.2122596895E-01],
	[1.6635000000E+04, 9.3356814731E+00, 5.6659873128E+00, 1.1037468231E+00, 8.4060984261E-01, 7.2134751739E-01],
	[1.6640000000E+04, 9.3396366005E+00, 5.6657368213E+00, 1.1048019531E+00, 8.4124828866E-01, 7.2146902879E-01],
	[1.6645000000E+04, 9.3435922145E+00, 5.6654864161E+00, 1.1058577737E+00, 8.4188691331E-01, 7.2159050315E-01],
	[1.6650000000E+04, 9.3475483150E+00, 5.6652360972E+00, 1.1069142851E+00, 8.4252571641E-01, 7.2171194046E-01],
	[1.6655000000E+04, 9.3515049019E+00, 5.6649858645E+00, 1.1079714875E+00, 8.4316469777E-01, 7.2183334070E-01],
	[1.6660000000E+04, 9.3554619752E+00, 5.6647357179E+00, 1.1090293811E+00, 8.4380385722E-01, 7.2195470389E-01],
	[1.6665000000E+04, 9.3594195347E+00, 5.6644856574E+00, 1.1100879663E+00, 8.4444319460E-01, 7.2207603000E-01],
	[1.6670000000E+04, 9.3633775804E+00, 5.6642356830E+00, 1.1111472433E+00, 8.4508270971E-01, 7.2219731903E-01],
	[1.6675000000E+04, 9.3673361121E+00, 5.6639857946E+00, 1.1122072122E+00, 8.4572240239E-01, 7.2231857097E-01],
	[1.6680000000E+04, 9.3712951299E+00, 5.6637359922E+00, 1.1132678734E+00, 8.4636227247E-01, 7.2243978582E-01],
	[1.6685000000E+04, 9.3752546336E+00, 5.6634862756E+00, 1.1143292271E+00, 8.4700231978E-01, 7.2256096357E-01],
	[1.6690000000E+04, 9.3792146231E+00, 5.6632366448E+00, 1.1153912735E+00, 8.4764254413E-01, 7.2268210422E-01],
	[1.6695000000E+04, 9.3831750984E+00, 5.6629870998E+00, 1.1164540129E+00, 8.4828294535E-01, 7.2280320776E-01],
	[1.6700000000E+04, 9.3871360593E+00, 5.6627376405E+00, 1.1175174455E+00, 8.4892352327E-01, 7.2292427417E-01],
	[1.6705000000E+04, 9.3910975058E+00, 5.6624882669E+00, 1.1185815716E+00, 8.4956427772E-01, 7.2304530347E-01],
	[1.6710000000E+04, 9.3950594377E+00, 5.6622389789E+00, 1.1196463914E+00, 8.5020520852E-01, 7.2316629563E-01],
	[1.6715000000E+04, 9.3990218551E+00, 5.6619897765E+00, 1.1207119052E+00, 8.5084631550E-01, 7.2328725065E-01],
	[1.6720000000E+04, 9.4029847577E+00, 5.6617406595E+00, 1.1217781131E+00, 8.5148759848E-01, 7.2340816853E-01],
	[1.6725000000E+04, 9.4069481456E+00, 5.6614916280E+00, 1.1228450155E+00, 8.5212905729E-01, 7.2352904926E-01],
	[1.6730000000E+04, 9.4109120186E+00, 5.6612426818E+00, 1.1239126126E+00, 8.5277069174E-01, 7.2364989283E-01],
	[1.6735000000E+04, 9.4148763767E+00, 5.6609938210E+00, 1.1249809046E+00, 8.5341250168E-01, 7.2377069924E-01],
	[1.6740000000E+04, 9.4188412198E+00, 5.6607450455E+00, 1.1260498918E+00, 8.5405448692E-01, 7.2389146848E-01],
	[1.6745000000E+04, 9.4228065477E+00, 5.6604963552E+00, 1.1271195744E+00, 8.5469664729E-01, 7.2401220055E-01],
	[1.6750000000E+04, 9.4267723604E+00, 5.6602477501E+00, 1.1281899527E+00, 8.5533898261E-01, 7.2413289543E-01],
	[1.6755000000E+04, 9.4307386579E+00, 5.6599992300E+00, 1.1292610268E+00, 8.5598149271E-01, 7.2425355313E-01],
	[1.6760000000E+04, 9.4347054399E+00, 5.6597507951E+00, 1.1303327971E+00, 8.5662417741E-01, 7.2437417363E-01],
	[1.6765000000E+04, 9.4386727065E+00, 5.6595024451E+00, 1.1314052638E+00, 8.5726703654E-01, 7.2449475694E-01],
	[1.6770000000E+04, 9.4426404576E+00, 5.6592541801E+00, 1.1324784272E+00, 8.5791006992E-01, 7.2461530303E-01],
	[1.6775000000E+04, 9.4466086930E+00, 5.6590060000E+00, 1.1335522874E+00, 8.5855327738E-01, 7.2473581192E-01],
	[1.6780000000E+04, 9.4505774128E+00, 5.6587579047E+00, 1.1346268448E+00, 8.5919665873E-01, 7.2485628359E-01],
	[1.6785000000E+04, 9.4545466167E+00, 5.6585098942E+00, 1.1357020995E+00, 8.5984021382E-01, 7.2497671803E-01],
	[1.6790000000E+04, 9.4585163047E+00, 5.6582619685E+00, 1.1367780518E+00, 8.6048394245E-01, 7.2509711525E-01],
	[1.6795000000E+04, 9.4624864768E+00, 5.6580141274E+00, 1.1378547020E+00, 8.6112784446E-01, 7.2521747523E-01],
	[1.6800000000E+04, 9.4664571328E+00, 5.6577663710E+00, 1.1389320503E+00, 8.6177191967E-01, 7.2533779797E-01],
	[1.6805000000E+04, 9.4704282726E+00, 5.6575186991E+00, 1.1400100969E+00, 8.6241616790E-01, 7.2545808346E-01],
	[1.6810000000E+04, 9.4743998963E+00, 5.6572711117E+00, 1.1410888421E+00, 8.6306058897E-01, 7.2557833168E-01],
	[1.6815000000E+04, 9.4783720036E+00, 5.6570236088E+00, 1.1421682862E+00, 8.6370518272E-01, 7.2569854257E-01],
	[1.6820000000E+04, 9.4823445945E+00, 5.6567761903E+00, 1.1432484293E+00, 8.6434994896E-01, 7.2581871614E-01],
	[1.6825000000E+04, 9.4863176690E+00, 5.6565288562E+00, 1.1443292718E+00, 8.6499488751E-01, 7.2593885237E-01],
	[1.6830000000E+04, 9.4902912269E+00, 5.6562816063E+00, 1.1454108138E+00, 8.6563999821E-01, 7.2605895126E-01],
	[1.6835000000E+04, 9.4942803651E+00, 5.6560401612E+00, 1.1464930556E+00, 8.6628554076E-01, 7.2617901280E-01],
	[1.6840000000E+04, 9.4982709433E+00, 5.6557991573E+00, 1.1475759975E+00, 8.6693127204E-01, 7.2629903698E-01],
	[1.6845000000E+04, 9.5022620134E+00, 5.6555582352E+00, 1.1486596397E+00, 8.6757717557E-01, 7.2641902380E-01],
	[1.6850000000E+04, 9.5062535752E+00, 5.6553173949E+00, 1.1497439824E+00, 8.6822325119E-01, 7.2653897325E-01],
	[1.6855000000E+04, 9.5102456287E+00, 5.6550766363E+00, 1.1508290259E+00, 8.6886949870E-01, 7.2665888531E-01],
	[1.6860000000E+04, 9.5142381739E+00, 5.6548359593E+00, 1.1519147704E+00, 8.6951591794E-01, 7.2677875999E-01],
	[1.6865000000E+04, 9.5182312106E+00, 5.6545953640E+00, 1.1530012162E+00, 8.7016250874E-01, 7.2689859727E-01],
	[1.6870000000E+04, 9.5222247387E+00, 5.6543548501E+00, 1.1540883635E+00, 8.7080927090E-01, 7.2701839715E-01],
	[1.6875000000E+04, 9.5262187582E+00, 5.6541144178E+00, 1.1551762126E+00, 8.7145620427E-01, 7.2713815962E-01],
	[1.6880000000E+04, 9.5302132690E+00, 5.6538740670E+00, 1.1562647637E+00, 8.7210330865E-01, 7.2725788468E-01],
	[1.6885000000E+04, 9.5342082709E+00, 5.6536337975E+00, 1.1573540170E+00, 8.7275058388E-01, 7.2737757231E-01],
	[1.6890000000E+04, 9.5382037640E+00, 5.6533936094E+00, 1.1584439729E+00, 8.7339802978E-01, 7.2749722251E-01],
	[1.6895000000E+04, 9.5421997481E+00, 5.6531535025E+00, 1.1595346314E+00, 8.7404564618E-01, 7.2761683527E-01],
	[1.6900000000E+04, 9.5461962231E+00, 5.6529134770E+00, 1.1606259930E+00, 8.7469343288E-01, 7.2773641058E-01],
	[1.6905000000E+04, 9.5501931890E+00, 5.6526735326E+00, 1.1617180578E+00, 8.7534138973E-01, 7.2785594844E-01],
	[1.6910000000E+04, 9.5541906456E+00, 5.6524336693E+00, 1.1628108260E+00, 8.7598951653E-01, 7.2797544884E-01],
	[1.6915000000E+04, 9.5581885930E+00, 5.6521938871E+00, 1.1639042980E+00, 8.7663781312E-01, 7.2809491177E-01],
	[1.6920000000E+04, 9.5621870309E+00, 5.6519541860E+00, 1.1649984739E+00, 8.7728627932E-01, 7.2821433723E-01],
	[1.6925000000E+04, 9.5661859593E+00, 5.6517145658E+00, 1.1660933541E+00, 8.7793491495E-01, 7.2833372520E-01],
	[1.6930000000E+04, 9.5701853782E+00, 5.6514750266E+00, 1.1671889386E+00, 8.7858371984E-01, 7.2845307569E-01],
	[1.6935000000E+04, 9.5741852874E+00, 5.6512355683E+00, 1.1682852279E+00, 8.7923269379E-01, 7.2857238868E-01],
	[1.6940000000E+04, 9.5781856868E+00, 5.6509961907E+00, 1.1693822221E+00, 8.7988183665E-01, 7.2869166417E-01],
	[1.6945000000E+04, 9.5821865765E+00, 5.6507568940E+00, 1.1704799215E+00, 8.8053114823E-01, 7.2881090215E-01],
	[1.6950000000E+04, 9.5861879562E+00, 5.6505176780E+00, 1.1715783263E+00, 8.8118062835E-01, 7.2893010261E-01],
	[1.6955000000E+04, 9.5901898259E+00, 5.6502785427E+00, 1.1726774368E+00, 8.8183027684E-01, 7.2904926555E-01],
	[1.6960000000E+04, 9.5941921856E+00, 5.6500394880E+00, 1.1737772532E+00, 8.8248009352E-01, 7.2916839096E-01],
	[1.6965000000E+04, 9.5981950350E+00, 5.6498005139E+00, 1.1748777758E+00, 8.8313007821E-01, 7.2928747884E-01],
	[1.6970000000E+04, 9.6021983743E+00, 5.6495616203E+00, 1.1759790048E+00, 8.8378023074E-01, 7.2940652917E-01],
	[1.6975000000E+04, 9.6062022032E+00, 5.6493228071E+00, 1.1770809404E+00, 8.8443055091E-01, 7.2952554195E-01],
	[1.6980000000E+04, 9.6102065217E+00, 5.6490840744E+00, 1.1781835829E+00, 8.8508103857E-01, 7.2964451717E-01],
	[1.6985000000E+04, 9.6142113296E+00, 5.6488454221E+00, 1.1792869325E+00, 8.8573169353E-01, 7.2976345483E-01],
	[1.6990000000E+04, 9.6182166270E+00, 5.6486068501E+00, 1.1803909896E+00, 8.8638251561E-01, 7.2988235492E-01],
	[1.6995000000E+04, 9.6222224137E+00, 5.6483683583E+00, 1.1814957542E+00, 8.8703350463E-01, 7.3000121744E-01],
	[1.7000000000E+04, 9.6262286897E+00, 5.6481299468E+00, 1.1826012267E+00, 8.8768466042E-01, 7.3012004237E-01],
	[1.7005000000E+04, 9.6302354548E+00, 5.6478916155E+00, 1.1837074074E+00, 8.8833598280E-01, 7.3023882971E-01],
	[1.7010000000E+04, 9.6342427090E+00, 5.6476533642E+00, 1.1848142964E+00, 8.8898747158E-01, 7.3035757946E-01],
	[1.7015000000E+04, 9.6382504522E+00, 5.6474151931E+00, 1.1859218940E+00, 8.8963912660E-01, 7.3047629160E-01],
	[1.7020000000E+04, 9.6422586843E+00, 5.6471771019E+00, 1.1870302004E+00, 8.9029094767E-01, 7.3059496613E-01],
	[1.7025000000E+04, 9.6462674052E+00, 5.6469390907E+00, 1.1881392160E+00, 8.9094293461E-01, 7.3071360305E-01],
	[1.7030000000E+04, 9.6502766149E+00, 5.6467011595E+00, 1.1892489408E+00, 8.9159508725E-01, 7.3083220235E-01],
	[1.7035000000E+04, 9.6542863132E+00, 5.6464633081E+00, 1.1903593753E+00, 8.9224740540E-01, 7.3095076402E-01],
	[1.7040000000E+04, 9.6582965001E+00, 5.6462255365E+00, 1.1914705196E+00, 8.9289988890E-01, 7.3106928806E-01],
	[1.7045000000E+04, 9.6623071755E+00, 5.6459878447E+00, 1.1925823739E+00, 8.9355253755E-01, 7.3118777446E-01],
	[1.7050000000E+04, 9.6663183393E+00, 5.6457502326E+00, 1.1936949386E+00, 8.9420535118E-01, 7.3130622321E-01],
	[1.7055000000E+04, 9.6703299914E+00, 5.6455127002E+00, 1.1948082138E+00, 8.9485832962E-01, 7.3142463431E-01],
	[1.7060000000E+04, 9.6743421317E+00, 5.6452752474E+00, 1.1959221999E+00, 8.9551147267E-01, 7.3154300775E-01],
	[1.7065000000E+04, 9.6783547602E+00, 5.6450378741E+00, 1.1970368970E+00, 8.9616478017E-01, 7.3166134353E-01],
	[1.7070000000E+04, 9.6823678768E+00, 5.6448005804E+00, 1.1981523053E+00, 8.9681825194E-01, 7.3177964163E-01],
	[1.7075000000E+04, 9.6863814814E+00, 5.6445633661E+00, 1.1992684253E+00, 8.9747188779E-01, 7.3189790206E-01],
	[1.7080000000E+04, 9.6903955738E+00, 5.6443262313E+00, 1.2003852570E+00, 8.9812568754E-01, 7.3201612481E-01],
	[1.7085000000E+04, 9.6944101541E+00, 5.6440891758E+00, 1.2015028007E+00, 8.9877965103E-01, 7.3213430986E-01],
	[1.7090000000E+04, 9.6984252221E+00, 5.6438521996E+00, 1.2026210567E+00, 8.9943377806E-01, 7.3225245723E-01],
	[1.7095000000E+04, 9.7024407778E+00, 5.6436153027E+00, 1.2037400252E+00, 9.0008806845E-01, 7.3237056689E-01],
	[1.7100000000E+04, 9.7064568210E+00, 5.6433784850E+00, 1.2048597065E+00, 9.0074252204E-01, 7.3248863885E-01],
	[1.7105000000E+04, 9.7104858411E+00, 5.6431462431E+00, 1.2059801008E+00, 9.0139736098E-01, 7.3260667309E-01],
	[1.7110000000E+04, 9.7145194766E+00, 5.6429155616E+00, 1.2071012083E+00, 9.0205243669E-01, 7.3272466962E-01],
	[1.7115000000E+04, 9.7185536084E+00, 5.6426849570E+00, 1.2082230294E+00, 9.0270767571E-01, 7.3284262842E-01],
	[1.7120000000E+04, 9.7225882363E+00, 5.6424544292E+00, 1.2093455642E+00, 9.0336307787E-01, 7.3296054950E-01],
	[1.7125000000E+04, 9.7266233603E+00, 5.6422239781E+00, 1.2104688129E+00, 9.0401864299E-01, 7.3307843284E-01],
	[1.7130000000E+04, 9.7306589802E+00, 5.6419936037E+00, 1.2115927759E+00, 9.0467437089E-01, 7.3319627844E-01],
	[1.7135000000E+04, 9.7346950961E+00, 5.6417633059E+00, 1.2127174534E+00, 9.0533026139E-01, 7.3331408630E-01],
	[1.7140000000E+04, 9.7387317077E+00, 5.6415330847E+00, 1.2138428456E+00, 9.0598631431E-01, 7.3343185640E-01],
	[1.7145000000E+04, 9.7427688151E+00, 5.6413029401E+00, 1.2149689528E+00, 9.0664252947E-01, 7.3354958874E-01],
	[1.7150000000E+04, 9.7468064181E+00, 5.6410728719E+00, 1.2160957751E+00, 9.0729890669E-01, 7.3366728333E-01],
	[1.7155000000E+04, 9.7508445167E+00, 5.6408428802E+00, 1.2172233130E+00, 9.0795544579E-01, 7.3378494014E-01],
	[1.7160000000E+04, 9.7548831108E+00, 5.6406129649E+00, 1.2183515665E+00, 9.0861214660E-01, 7.3390255918E-01],
	[1.7165000000E+04, 9.7589222003E+00, 5.6403831259E+00, 1.2194805359E+00, 9.0926900893E-01, 7.3402014044E-01],
	[1.7170000000E+04, 9.7629617851E+00, 5.6401533633E+00, 1.2206102216E+00, 9.0992603260E-01, 7.3413768392E-01],
	[1.7175000000E+04, 9.7670018651E+00, 5.6399236768E+00, 1.2217406237E+00, 9.1058321743E-01, 7.3425518961E-01],
	[1.7180000000E+04, 9.7710424402E+00, 5.6396940666E+00, 1.2228717425E+00, 9.1124056325E-01, 7.3437265751E-01],
	[1.7185000000E+04, 9.7750835104E+00, 5.6394645326E+00, 1.2240035782E+00, 9.1189806986E-01, 7.3449008760E-01],
	[1.7190000000E+04, 9.7791250756E+00, 5.6392350747E+00, 1.2251361310E+00, 9.1255573711E-01, 7.3460747989E-01],
	[1.7195000000E+04, 9.7831671357E+00, 5.6390056928E+00, 1.2262694013E+00, 9.1321356479E-01, 7.3472483436E-01],
	[1.7200000000E+04, 9.7872096906E+00, 5.6387763869E+00, 1.2274033893E+00, 9.1387155274E-01, 7.3484215103E-01],
	[1.7205000000E+04, 9.7912527402E+00, 5.6385471570E+00, 1.2285380951E+00, 9.1452970077E-01, 7.3495942987E-01],
	[1.7210000000E+04, 9.7952962845E+00, 5.6383180031E+00, 1.2296735191E+00, 9.1518800870E-01, 7.3507667088E-01],
	[1.7215000000E+04, 9.7993403233E+00, 5.6380889250E+00, 1.2308096615E+00, 9.1584647635E-01, 7.3519387406E-01],
	[1.7220000000E+04, 9.8033848566E+00, 5.6378599227E+00, 1.2319465225E+00, 9.1650510355E-01, 7.3531103941E-01],
	[1.7225000000E+04, 9.8074298843E+00, 5.6376309963E+00, 1.2330841024E+00, 9.1716389010E-01, 7.3542816692E-01],
	[1.7230000000E+04, 9.8114754063E+00, 5.6374021455E+00, 1.2342224015E+00, 9.1782283584E-01, 7.3554525658E-01],
	[1.7235000000E+04, 9.8155214225E+00, 5.6371733704E+00, 1.2353614199E+00, 9.1848194057E-01, 7.3566230839E-01],
	[1.7240000000E+04, 9.8195679329E+00, 5.6369446710E+00, 1.2365011579E+00, 9.1914120412E-01, 7.3577932234E-01],
	[1.7245000000E+04, 9.8236149373E+00, 5.6367160472E+00, 1.2376416158E+00, 9.1980062631E-01, 7.3589629843E-01],
	[1.7250000000E+04, 9.8276624357E+00, 5.6364874989E+00, 1.2387827938E+00, 9.2046020696E-01, 7.3601323666E-01],
	[1.7255000000E+04, 9.8317104281E+00, 5.6362590261E+00, 1.2399246922E+00, 9.2111994589E-01, 7.3613013701E-01],
	[1.7260000000E+04, 9.8357589142E+00, 5.6360306288E+00, 1.2410673111E+00, 9.2177984291E-01, 7.3624699949E-01],
	[1.7265000000E+04, 9.8398078940E+00, 5.6358023069E+00, 1.2422106509E+00, 9.2243989784E-01, 7.3636382409E-01],
	[1.7270000000E+04, 9.8438573675E+00, 5.6355740603E+00, 1.2433547118E+00, 9.2310011051E-01, 7.3648061081E-01],
	[1.7275000000E+04, 9.8479073346E+00, 5.6353458891E+00, 1.2444994941E+00, 9.2376048073E-01, 7.3659735963E-01],
	[1.7280000000E+04, 9.8519577952E+00, 5.6351177931E+00, 1.2456449979E+00, 9.2442100833E-01, 7.3671407056E-01],
	[1.7285000000E+04, 9.8560087491E+00, 5.6348897723E+00, 1.2467912235E+00, 9.2508169311E-01, 7.3683074359E-01],
	[1.7290000000E+04, 9.8600601964E+00, 5.6346618267E+00, 1.2479381712E+00, 9.2574253490E-01, 7.3694737872E-01],
	[1.7295000000E+04, 9.8641121369E+00, 5.6344339562E+00, 1.2490858412E+00, 9.2640353352E-01, 7.3706397594E-01],
	[1.7300000000E+04, 9.8681645705E+00, 5.6342061609E+00, 1.2502342338E+00, 9.2706468878E-01, 7.3718053525E-01],
	[1.7305000000E+04, 9.8722174973E+00, 5.6339784405E+00, 1.2513833492E+00, 9.2772600051E-01, 7.3729705664E-01],
	[1.7310000000E+04, 9.8762709170E+00, 5.6337507951E+00, 1.2525331876E+00, 9.2838746852E-01, 7.3741354011E-01],
	[1.7315000000E+04, 9.8803248296E+00, 5.6335232247E+00, 1.2536837494E+00, 9.2904909263E-01, 7.3752998566E-01],
	[1.7320000000E+04, 9.8843792350E+00, 5.6332957292E+00, 1.2548350347E+00, 9.2971087267E-01, 7.3764639327E-01],
	[1.7325000000E+04, 9.8884341332E+00, 5.6330683085E+00, 1.2559870437E+00, 9.3037280844E-01, 7.3776276295E-01],
	[1.7330000000E+04, 9.8924895240E+00, 5.6328409626E+00, 1.2571397768E+00, 9.3103489976E-01, 7.3787909469E-01],
	[1.7335000000E+04, 9.8965454074E+00, 5.6326136914E+00, 1.2582932342E+00, 9.3169714647E-01, 7.3799538848E-01],
	[1.7340000000E+04, 9.9006017833E+00, 5.6323864950E+00, 1.2594474161E+00, 9.3235954836E-01, 7.3811164433E-01],
	[1.7345000000E+04, 9.9046586516E+00, 5.6321593733E+00, 1.2606023228E+00, 9.3302210527E-01, 7.3822786223E-01],
	[1.7350000000E+04, 9.9087160123E+00, 5.6319323261E+00, 1.2617579544E+00, 9.3368481700E-01, 7.3834404217E-01],
	[1.7355000000E+04, 9.9127738652E+00, 5.6317053535E+00, 1.2629143114E+00, 9.3434768338E-01, 7.3846018415E-01],
	[1.7360000000E+04, 9.9168322102E+00, 5.6314784555E+00, 1.2640713938E+00, 9.3501070423E-01, 7.3857628817E-01],
	[1.7365000000E+04, 9.9208910473E+00, 5.6312516319E+00, 1.2652292020E+00, 9.3567387935E-01, 7.3869235422E-01],
	[1.7370000000E+04, 9.9249503765E+00, 5.6310248828E+00, 1.2663877362E+00, 9.3633720858E-01, 7.3880838229E-01],
	[1.7375000000E+04, 9.9290101975E+00, 5.6307982080E+00, 1.2675469966E+00, 9.3700069173E-01, 7.3892437239E-01],
	[1.7380000000E+04, 9.9330823739E+00, 5.6305756698E+00, 1.2687069835E+00, 9.3766454698E-01, 7.3904032451E-01],
	[1.7385000000E+04, 9.9371603648E+00, 5.6303550239E+00, 1.2698676972E+00, 9.3832865420E-01, 7.3915623864E-01],
	[1.7390000000E+04, 9.9412388565E+00, 5.6301344501E+00, 1.2710291378E+00, 9.3899291549E-01, 7.3927211478E-01],
	[1.7395000000E+04, 9.9453178489E+00, 5.6299139484E+00, 1.2721913056E+00, 9.3965733066E-01, 7.3938795294E-01],
	[1.7400000000E+04, 9.9493973419E+00, 5.6296935187E+00, 1.2733542009E+00, 9.4032189953E-01, 7.3950375309E-01],
	[1.7405000000E+04, 9.9534773355E+00, 5.6294731609E+00, 1.2745178240E+00, 9.4098662192E-01, 7.3961951525E-01],
	[1.7410000000E+04, 9.9575578296E+00, 5.6292528751E+00, 1.2756821749E+00, 9.4165149764E-01, 7.3973523940E-01],
	[1.7415000000E+04, 9.9616388241E+00, 5.6290326611E+00, 1.2768472541E+00, 9.4231652652E-01, 7.3985092554E-01],
	[1.7420000000E+04, 9.9657203189E+00, 5.6288125190E+00, 1.2780130618E+00, 9.4298170837E-01, 7.3996657367E-01],
	[1.7425000000E+04, 9.9698023139E+00, 5.6285924486E+00, 1.2791795981E+00, 9.4364704301E-01, 7.4008218378E-01],
	[1.7430000000E+04, 9.9738848090E+00, 5.6283724500E+00, 1.2803468634E+00, 9.4431253025E-01, 7.4019775588E-01],
	[1.7435000000E+04, 9.9779678043E+00, 5.6281525230E+00, 1.2815148578E+00, 9.4497816992E-01, 7.4031328995E-01],
	[1.7440000000E+04, 9.9820512995E+00, 5.6279326678E+00, 1.2826835817E+00, 9.4564396184E-01, 7.4042878600E-01],
	[1.7445000000E+04, 9.9861352945E+00, 5.6277128841E+00, 1.2838530353E+00, 9.4630990581E-01, 7.4054424402E-01],
	[1.7450000000E+04, 9.9902197894E+00, 5.6274931720E+00, 1.2850232187E+00, 9.4697600166E-01, 7.4065966400E-01],
	[1.7455000000E+04, 9.9943047841E+00, 5.6272735314E+00, 1.2861941324E+00, 9.4764224921E-01, 7.4077504594E-01],
	[1.7460000000E+04, 9.9983902784E+00, 5.6270539623E+00, 1.2873657764E+00, 9.4830864827E-01, 7.4089038985E-01],
	[1.7465000000E+04, 1.0002476272E+01, 5.6268344646E+00, 1.2885381512E+00, 9.4897519866E-01, 7.4100569571E-01],
	[1.7470000000E+04, 1.0006562766E+01, 5.6266150383E+00, 1.2897112568E+00, 9.4964190020E-01, 7.4112096352E-01],
	[1.7475000000E+04, 1.0010649758E+01, 5.6263956834E+00, 1.2908850936E+00, 9.5030875270E-01, 7.4123619328E-01],
	[1.7480000000E+04, 1.0014737250E+01, 5.6261763997E+00, 1.2920596617E+00, 9.5097575598E-01, 7.4135138499E-01],
	[1.7485000000E+04, 1.0018825242E+01, 5.6259571873E+00, 1.2932349616E+00, 9.5164290986E-01, 7.4146653864E-01],
	[1.7490000000E+04, 1.0022913732E+01, 5.6257380462E+00, 1.2944109933E+00, 9.5231021416E-01, 7.4158165422E-01],
	[1.7495000000E+04, 1.0027002722E+01, 5.6255189762E+00, 1.2955877571E+00, 9.5297766870E-01, 7.4169673174E-01],
	[1.7500000000E+04, 1.0031092210E+01, 5.6252999773E+00, 1.2967652533E+00, 9.5364527328E-01, 7.4181177120E-01],
	[1.7505000000E+04, 1.0035182198E+01, 5.6250810495E+00, 1.2979529344E+00, 9.5431813756E-01, 7.4192677258E-01],
	[1.7510000000E+04, 1.0039272684E+01, 5.6248621927E+00, 1.2991413630E+00, 9.5499115513E-01, 7.4204173589E-01],
	[1.7515000000E+04, 1.0043363669E+01, 5.6246434070E+00, 1.3003305393E+00, 9.5566432578E-01, 7.4215666112E-01],
	[1.7520000000E+04, 1.0047455153E+01, 5.6244246922E+00, 1.3015204635E+00, 9.5633764933E-01, 7.4227154827E-01],
	[1.7525000000E+04, 1.0051547135E+01, 5.6242060483E+00, 1.3027111359E+00, 9.5701112561E-01, 7.4238639733E-01],
	[1.7530000000E+04, 1.0055639616E+01, 5.6239874753E+00, 1.3039025567E+00, 9.5768475441E-01, 7.4250120831E-01],
	[1.7535000000E+04, 1.0059732595E+01, 5.6237689731E+00, 1.3050947263E+00, 9.5835853555E-01, 7.4261598120E-01],
	[1.7540000000E+04, 1.0063826073E+01, 5.6235505417E+00, 1.3062876448E+00, 9.5903246885E-01, 7.4273071599E-01],
	[1.7545000000E+04, 1.0067920049E+01, 5.6233321810E+00, 1.3074813126E+00, 9.5970655412E-01, 7.4284541269E-01],
	[1.7550000000E+04, 1.0072014523E+01, 5.6231138910E+00, 1.3086757299E+00, 9.6038079116E-01, 7.4296007129E-01],
	[1.7555000000E+04, 1.0076109495E+01, 5.6228956717E+00, 1.3098708968E+00, 9.6105517980E-01, 7.4307469179E-01],
	[1.7560000000E+04, 1.0080204965E+01, 5.6226775230E+00, 1.3110668138E+00, 9.6172971985E-01, 7.4318927418E-01],
	[1.7565000000E+04, 1.0084300933E+01, 5.6224594448E+00, 1.3122634811E+00, 9.6240441111E-01, 7.4330381847E-01],
	[1.7570000000E+04, 1.0088397399E+01, 5.6222414372E+00, 1.3134608988E+00, 9.6307925340E-01, 7.4341832464E-01],
	[1.7575000000E+04, 1.0092494363E+01, 5.6220235000E+00, 1.3146590673E+00, 9.6375424654E-01, 7.4353279270E-01],
	[1.7580000000E+04, 1.0096591824E+01, 5.6218056333E+00, 1.3158579868E+00, 9.6442939033E-01, 7.4364722264E-01],
	[1.7585000000E+04, 1.0100689783E+01, 5.6215878370E+00, 1.3170576576E+00, 9.6510468459E-01, 7.4376161446E-01],
	[1.7590000000E+04, 1.0104788240E+01, 5.6213701110E+00, 1.3182580800E+00, 9.6578012912E-01, 7.4387596817E-01],
	[1.7595000000E+04, 1.0108887194E+01, 5.6211524554E+00, 1.3194592541E+00, 9.6645572375E-01, 7.4399028374E-01],
	[1.7600000000E+04, 1.0112986645E+01, 5.6209348700E+00, 1.3206611802E+00, 9.6713146828E-01, 7.4410456119E-01],
	[1.7605000000E+04, 1.0117086594E+01, 5.6207173548E+00, 1.3218638587E+00, 9.6780736253E-01, 7.4421880051E-01],
	[1.7610000000E+04, 1.0121187040E+01, 5.6204999099E+00, 1.3230672897E+00, 9.6848340631E-01, 7.4433300170E-01],
	[1.7615000000E+04, 1.0125287983E+01, 5.6202825350E+00, 1.3242714735E+00, 9.6915959942E-01, 7.4444716475E-01],
	[1.7620000000E+04, 1.0129389423E+01, 5.6200652303E+00, 1.3254764104E+00, 9.6983594169E-01, 7.4456128966E-01],
	[1.7625000000E+04, 1.0133491360E+01, 5.6198479956E+00, 1.3266821007E+00, 9.7051243292E-01, 7.4467537644E-01],
	[1.7630000000E+04, 1.0137593794E+01, 5.6196308309E+00, 1.3278885445E+00, 9.7118907293E-01, 7.4478942506E-01],
	[1.7635000000E+04, 1.0141696724E+01, 5.6194137362E+00, 1.3290957421E+00, 9.7186586152E-01, 7.4490343555E-01],
	[1.7640000000E+04, 1.0145800152E+01, 5.6191967114E+00, 1.3303036939E+00, 9.7254279851E-01, 7.4501740789E-01],
	[1.7645000000E+04, 1.0149904076E+01, 5.6189797565E+00, 1.3315124000E+00, 9.7321988371E-01, 7.4513134207E-01],
	[1.7650000000E+04, 1.0154008496E+01, 5.6187628714E+00, 1.3327218607E+00, 9.7389711694E-01, 7.4524523811E-01],
	[1.7655000000E+04, 1.0158113414E+01, 5.6185460562E+00, 1.3339320763E+00, 9.7457449799E-01, 7.4535909598E-01],
	[1.7660000000E+04, 1.0162231959E+01, 5.6183336110E+00, 1.3351430470E+00, 9.7525227722E-01, 7.4547291570E-01],
	[1.7665000000E+04, 1.0166355555E+01, 5.6181227223E+00, 1.3363547730E+00, 9.7593029125E-01, 7.4558669727E-01],
	[1.7670000000E+04, 1.0170479656E+01, 5.6179119012E+00, 1.3375672547E+00, 9.7660845327E-01, 7.4570044066E-01],
	[1.7675000000E+04, 1.0174604263E+01, 5.6177011477E+00, 1.3387804923E+00, 9.7728676310E-01, 7.4581414590E-01],
	[1.7680000000E+04, 1.0178729376E+01, 5.6174904616E+00, 1.3399944861E+00, 9.7796522054E-01, 7.4592781297E-01],
	[1.7685000000E+04, 1.0182854993E+01, 5.6172798431E+00, 1.3412092362E+00, 9.7864382541E-01, 7.4604144187E-01],
	[1.7690000000E+04, 1.0186981116E+01, 5.6170692920E+00, 1.3424247430E+00, 9.7932257752E-01, 7.4615503260E-01],
	[1.7695000000E+04, 1.0191107744E+01, 5.6168588083E+00, 1.3436410068E+00, 9.8000147668E-01, 7.4626858515E-01],
	[1.7700000000E+04, 1.0195234877E+01, 5.6166483919E+00, 1.3448580277E+00, 9.8068052271E-01, 7.4638209953E-01],
	[1.7705000000E+04, 1.0199362515E+01, 5.6164380428E+00, 1.3460758060E+00, 9.8135971541E-01, 7.4649557574E-01],
	[1.7710000000E+04, 1.0203490658E+01, 5.6162277610E+00, 1.3472943420E+00, 9.8203905460E-01, 7.4660901376E-01],
	[1.7715000000E+04, 1.0207619306E+01, 5.6160175465E+00, 1.3485136360E+00, 9.8271854008E-01, 7.4672241360E-01],
	[1.7720000000E+04, 1.0211748458E+01, 5.6158073991E+00, 1.3497336881E+00, 9.8339817168E-01, 7.4683577526E-01],
	[1.7725000000E+04, 1.0215878115E+01, 5.6155973189E+00, 1.3509544988E+00, 9.8407794920E-01, 7.4694909874E-01],
	[1.7730000000E+04, 1.0220008277E+01, 5.6153873058E+00, 1.3521760681E+00, 9.8475787245E-01, 7.4706238403E-01],
	[1.7735000000E+04, 1.0224138943E+01, 5.6151773597E+00, 1.3533983964E+00, 9.8543794124E-01, 7.4717563112E-01],
	[1.7740000000E+04, 1.0228270114E+01, 5.6149674807E+00, 1.3546214839E+00, 9.8611815539E-01, 7.4728884003E-01],
	[1.7745000000E+04, 1.0232401789E+01, 5.6147576687E+00, 1.3558453309E+00, 9.8679851471E-01, 7.4740201075E-01],
	[1.7750000000E+04, 1.0236533968E+01, 5.6145479236E+00, 1.3570699377E+00, 9.8747901900E-01, 7.4751514327E-01],
	[1.7755000000E+04, 1.0240666651E+01, 5.6143382454E+00, 1.3582953044E+00, 9.8815966809E-01, 7.4762823759E-01],
	[1.7760000000E+04, 1.0244799839E+01, 5.6141286341E+00, 1.3595214314E+00, 9.8884046178E-01, 7.4774129372E-01],
	[1.7765000000E+04, 1.0248933530E+01, 5.6139190896E+00, 1.3607483190E+00, 9.8952139987E-01, 7.4785431164E-01],
	[1.7770000000E+04, 1.0253067726E+01, 5.6137096119E+00, 1.3619759672E+00, 9.9020248219E-01, 7.4796729137E-01],
	[1.7775000000E+04, 1.0257202425E+01, 5.6135002010E+00, 1.3632043765E+00, 9.9088370855E-01, 7.4808023289E-01],
	[1.7780000000E+04, 1.0261337628E+01, 5.6132908567E+00, 1.3644335471E+00, 9.9156507875E-01, 7.4819313621E-01],
	[1.7785000000E+04, 1.0265473335E+01, 5.6130815792E+00, 1.3656634793E+00, 9.9224659260E-01, 7.4830600131E-01],
	[1.7790000000E+04, 1.0269609545E+01, 5.6128723682E+00, 1.3668941732E+00, 9.9292824993E-01, 7.4841882822E-01],
	[1.7795000000E+04, 1.0273746259E+01, 5.6126632238E+00, 1.3681256292E+00, 9.9361005053E-01, 7.4853161691E-01],
	[1.7800000000E+04, 1.0277883476E+01, 5.6124541460E+00, 1.3693578474E+00, 9.9429199422E-01, 7.4864436739E-01],
	[1.7805000000E+04, 1.0282021197E+01, 5.6122451347E+00, 1.3705908283E+00, 9.9497408080E-01, 7.4875707966E-01],
	[1.7810000000E+04, 1.0286159421E+01, 5.6120361899E+00, 1.3718245720E+00, 9.9565631010E-01, 7.4886975371E-01],
	[1.7815000000E+04, 1.0290298148E+01, 5.6118273114E+00, 1.3730590787E+00, 9.9633868192E-01, 7.4898238955E-01],
	[1.7820000000E+04, 1.0294437378E+01, 5.6116184994E+00, 1.3742943488E+00, 9.9702119607E-01, 7.4909498717E-01],
	[1.7825000000E+04, 1.0298577112E+01, 5.6114097537E+00, 1.3755303825E+00, 9.9770385237E-01, 7.4920754657E-01],
	[1.7830000000E+04, 1.0302717348E+01, 5.6112010743E+00, 1.3767671800E+00, 9.9838665061E-01, 7.4932006784E-01],
	[1.7835000000E+04, 1.0306858087E+01, 5.6109924612E+00, 1.3780047417E+00, 9.9906959062E-01, 7.4943255102E-01],
	[1.7840000000E+04, 1.0310999329E+01, 5.6107839143E+00, 1.3792430677E+00, 9.9975267221E-01, 7.4954499611E-01],
	[1.7845000000E+04, 1.0315141074E+01, 5.6105754337E+00, 1.3804821583E+00, 1.0004358952E+00, 7.4965740311E-01],
	[1.7850000000E+04, 1.0319283322E+01, 5.6103670191E+00, 1.3817220138E+00, 1.0011192593E+00, 7.4976977201E-01],
	[1.7855000000E+04, 1.0323426072E+01, 5.6101586707E+00, 1.3829626344E+00, 1.0018027645E+00, 7.4988210281E-01],
	[1.7860000000E+04, 1.0327569324E+01, 5.6099503883E+00, 1.3842040205E+00, 1.0024864105E+00, 7.4999439550E-01],
	[1.7865000000E+04, 1.0331713079E+01, 5.6097421720E+00, 1.3854461721E+00, 1.0031701971E+00, 7.5010665008E-01],
	[1.7870000000E+04, 1.0335857336E+01, 5.6095340216E+00, 1.3866890897E+00, 1.0038541241E+00, 7.5021886654E-01],
	[1.7875000000E+04, 1.0340002096E+01, 5.6093259373E+00, 1.3879327735E+00, 1.0045381914E+00, 7.5033104489E-01],
	[1.7880000000E+04, 1.0344147357E+01, 5.6091179188E+00, 1.3891772236E+00, 1.0052223988E+00, 7.5044318511E-01],
	[1.7885000000E+04, 1.0348293121E+01, 5.6089099662E+00, 1.3904224405E+00, 1.0059067460E+00, 7.5055528720E-01],
	[1.7890000000E+04, 1.0352439387E+01, 5.6087020794E+00, 1.3916684243E+00, 1.0065912329E+00, 7.5066735116E-01],
	[1.7895000000E+04, 1.0356586155E+01, 5.6084942584E+00, 1.3929151752E+00, 1.0072758593E+00, 7.5077937698E-01],
	[1.7900000000E+04, 1.0360733424E+01, 5.6082865032E+00, 1.3941626937E+00, 1.0079606249E+00, 7.5089136466E-01],
	[1.7905000000E+04, 1.0364881195E+01, 5.6080788137E+00, 1.3954109798E+00, 1.0086455297E+00, 7.5100331420E-01],
	[1.7910000000E+04, 1.0369029469E+01, 5.6078711899E+00, 1.3966600339E+00, 1.0093305734E+00, 7.5111522559E-01],
	[1.7915000000E+04, 1.0373178243E+01, 5.6076636317E+00, 1.3979098562E+00, 1.0100157558E+00, 7.5122709882E-01],
	[1.7920000000E+04, 1.0377327519E+01, 5.6074561391E+00, 1.3991604470E+00, 1.0107010768E+00, 7.5133893390E-01],
	[1.7925000000E+04, 1.0381477297E+01, 5.6072487121E+00, 1.4004118065E+00, 1.0113865361E+00, 7.5145073082E-01],
	[1.7930000000E+04, 1.0385627576E+01, 5.6070413506E+00, 1.4016639350E+00, 1.0120721336E+00, 7.5156248958E-01],
	[1.7935000000E+04, 1.0389778356E+01, 5.6068340546E+00, 1.4029168328E+00, 1.0127578690E+00, 7.5167421017E-01],
	[1.7940000000E+04, 1.0393929638E+01, 5.6066268240E+00, 1.4041705001E+00, 1.0134437422E+00, 7.5178589258E-01],
	[1.7945000000E+04, 1.0398097625E+01, 5.6064247570E+00, 1.4054249371E+00, 1.0141300739E+00, 7.5189753682E-01],
	[1.7950000000E+04, 1.0402268035E+01, 5.6062233552E+00, 1.4066801442E+00, 1.0148165816E+00, 7.5200914288E-01],
	[1.7955000000E+04, 1.0406438955E+01, 5.6060220167E+00, 1.4079361215E+00, 1.0155032273E+00, 7.5212071076E-01],
	[1.7960000000E+04, 1.0410610386E+01, 5.6058207415E+00, 1.4091928694E+00, 1.0161900108E+00, 7.5223224045E-01],
	[1.7965000000E+04, 1.0414782327E+01, 5.6056195296E+00, 1.4104503881E+00, 1.0168769318E+00, 7.5234373195E-01],
	[1.7970000000E+04, 1.0418954779E+01, 5.6054183809E+00, 1.4117086778E+00, 1.0175639902E+00, 7.5245518525E-01],
	[1.7975000000E+04, 1.0423127740E+01, 5.6052172953E+00, 1.4129677388E+00, 1.0182511858E+00, 7.5256660036E-01],
	[1.7980000000E+04, 1.0427301211E+01, 5.6050162729E+00, 1.4142275714E+00, 1.0189385183E+00, 7.5267797727E-01],
	[1.7985000000E+04, 1.0431475193E+01, 5.6048153136E+00, 1.4154881759E+00, 1.0196259877E+00, 7.5278931597E-01],
	[1.7990000000E+04, 1.0435649684E+01, 5.6046144174E+00, 1.4167495524E+00, 1.0203135938E+00, 7.5290061647E-01],
	[1.7995000000E+04, 1.0439824685E+01, 5.6044135842E+00, 1.4180117012E+00, 1.0210013362E+00, 7.5301187875E-01],
	[1.8000000000E+04, 1.0444000196E+01, 5.6042128140E+00, 1.4192746226E+00, 1.0216892149E+00, 7.5312310282E-01],
	[1.8005000000E+04, 1.0448176216E+01, 5.6040121067E+00, 1.4205383169E+00, 1.0223772297E+00, 7.5323428867E-01],
	[1.8010000000E+04, 1.0452352746E+01, 5.6038114623E+00, 1.4218027843E+00, 1.0230653803E+00, 7.5334543629E-01],
	[1.8015000000E+04, 1.0456529786E+01, 5.6036108808E+00, 1.4230680251E+00, 1.0237536666E+00, 7.5345654570E-01],
	[1.8020000000E+04, 1.0460707335E+01, 5.6034103622E+00, 1.4243340395E+00, 1.0244420883E+00, 7.5356761687E-01],
	[1.8025000000E+04, 1.0464885393E+01, 5.6032099064E+00, 1.4256008277E+00, 1.0251306454E+00, 7.5367864981E-01],
	[1.8030000000E+04, 1.0469063960E+01, 5.6030095133E+00, 1.4268683902E+00, 1.0258193375E+00, 7.5378964452E-01],
	[1.8035000000E+04, 1.0473243037E+01, 5.6028091829E+00, 1.4281367270E+00, 1.0265081646E+00, 7.5390060099E-01],
	[1.8040000000E+04, 1.0477422623E+01, 5.6026089153E+00, 1.4294058384E+00, 1.0271971264E+00, 7.5401151922E-01],
	[1.8045000000E+04, 1.0481602717E+01, 5.6024087103E+00, 1.4306757248E+00, 1.0278862227E+00, 7.5412239920E-01],
	[1.8050000000E+04, 1.0485783321E+01, 5.6022085679E+00, 1.4319463864E+00, 1.0285754533E+00, 7.5423324094E-01],
	[1.8055000000E+04, 1.0489964433E+01, 5.6020084881E+00, 1.4332178233E+00, 1.0292648181E+00, 7.5434404443E-01],
	[1.8060000000E+04, 1.0494146054E+01, 5.6018084708E+00, 1.4344900360E+00, 1.0299543169E+00, 7.5445480966E-01],
	[1.8065000000E+04, 1.0498328184E+01, 5.6016085161E+00, 1.4357630246E+00, 1.0306439494E+00, 7.5456553664E-01],
	[1.8070000000E+04, 1.0502510823E+01, 5.6014086238E+00, 1.4370367894E+00, 1.0313337155E+00, 7.5467622535E-01],
	[1.8075000000E+04, 1.0506693970E+01, 5.6012087939E+00, 1.4383113307E+00, 1.0320236150E+00, 7.5478687581E-01],
	[1.8080000000E+04, 1.0510877625E+01, 5.6010090265E+00, 1.4395866486E+00, 1.0327136477E+00, 7.5489748800E-01],
	[1.8085000000E+04, 1.0515061789E+01, 5.6008093214E+00, 1.4408627436E+00, 1.0334038134E+00, 7.5500806192E-01],
	[1.8090000000E+04, 1.0519246461E+01, 5.6006096786E+00, 1.4421396158E+00, 1.0340941119E+00, 7.5511859757E-01],
	[1.8095000000E+04, 1.0523431642E+01, 5.6004100981E+00, 1.4434172655E+00, 1.0347845430E+00, 7.5522909494E-01],
	[1.8100000000E+04, 1.0527617330E+01, 5.6002105799E+00, 1.4446956929E+00, 1.0354751065E+00, 7.5533955404E-01],
	[1.8105000000E+04, 1.0531803527E+01, 5.6000111239E+00, 1.4459748983E+00, 1.0361658023E+00, 7.5544997486E-01],
	[1.8110000000E+04, 1.0535990231E+01, 5.5998117300E+00, 1.4472548820E+00, 1.0368566302E+00, 7.5556035740E-01],
	[1.8115000000E+04, 1.0540177444E+01, 5.5996123983E+00, 1.4485356442E+00, 1.0375475899E+00, 7.5567070166E-01],
	[1.8120000000E+04, 1.0544365164E+01, 5.5994131287E+00, 1.4498171852E+00, 1.0382386812E+00, 7.5578100762E-01],
	[1.8125000000E+04, 1.0548553392E+01, 5.5992139212E+00, 1.4510995052E+00, 1.0389299041E+00, 7.5589127530E-01],
	[1.8130000000E+04, 1.0552742128E+01, 5.5990147757E+00, 1.4523826045E+00, 1.0396212582E+00, 7.5600150468E-01],
	[1.8135000000E+04, 1.0556931371E+01, 5.5988156922E+00, 1.4536664834E+00, 1.0403127434E+00, 7.5611169577E-01],
	[1.8140000000E+04, 1.0561121122E+01, 5.5986166706E+00, 1.4549511421E+00, 1.0410043596E+00, 7.5622184856E-01],
	[1.8145000000E+04, 1.0565311380E+01, 5.5984177110E+00, 1.4562365808E+00, 1.0416961064E+00, 7.5633196305E-01],
	[1.8150000000E+04, 1.0569502146E+01, 5.5982188132E+00, 1.4575227999E+00, 1.0423879838E+00, 7.5644203924E-01],
	[1.8155000000E+04, 1.0573693418E+01, 5.5980199773E+00, 1.4588097995E+00, 1.0430799915E+00, 7.5655207712E-01],
	[1.8160000000E+04, 1.0577885198E+01, 5.5978212032E+00, 1.4600975800E+00, 1.0437721293E+00, 7.5666207670E-01],
	[1.8165000000E+04, 1.0582077485E+01, 5.5976224909E+00, 1.4613861416E+00, 1.0444643971E+00, 7.5677203797E-01],
	[1.8170000000E+04, 1.0586270280E+01, 5.5974238403E+00, 1.4626754846E+00, 1.0451567947E+00, 7.5688196092E-01],
	[1.8175000000E+04, 1.0590463581E+01, 5.5972252515E+00, 1.4639656091E+00, 1.0458493218E+00, 7.5699184556E-01],
	[1.8180000000E+04, 1.0594657389E+01, 5.5970267243E+00, 1.4652565156E+00, 1.0465419783E+00, 7.5710169188E-01],
	[1.8185000000E+04, 1.0598851704E+01, 5.5968282587E+00, 1.4665482041E+00, 1.0472347639E+00, 7.5721149989E-01],
	[1.8190000000E+04, 1.0603046525E+01, 5.5966298547E+00, 1.4678406751E+00, 1.0479276786E+00, 7.5732126957E-01],
	[1.8195000000E+04, 1.0607241853E+01, 5.5964315123E+00, 1.4691339287E+00, 1.0486207221E+00, 7.5743100093E-01],
	[1.8200000000E+04, 1.0611437688E+01, 5.5962332314E+00, 1.4704279652E+00, 1.0493138941E+00, 7.5754069396E-01],
	[1.8205000000E+04, 1.0615634029E+01, 5.5960350120E+00, 1.4717227848E+00, 1.0500071946E+00, 7.5765034867E-01],
	[1.8210000000E+04, 1.0619830877E+01, 5.5958368541E+00, 1.4730183879E+00, 1.0507006233E+00, 7.5775996504E-01],
	[1.8215000000E+04, 1.0624028231E+01, 5.5956387575E+00, 1.4743147747E+00, 1.0513941801E+00, 7.5786954309E-01],
	[1.8220000000E+04, 1.0628226091E+01, 5.5954407224E+00, 1.4756119454E+00, 1.0520878647E+00, 7.5797908280E-01],
	[1.8225000000E+04, 1.0632424457E+01, 5.5952427486E+00, 1.4769099002E+00, 1.0527816769E+00, 7.5808858417E-01],
	[1.8230000000E+04, 1.0636625757E+01, 5.5950455703E+00, 1.4782086396E+00, 1.0534756664E+00, 7.5819804721E-01],
	[1.8235000000E+04, 1.0640843699E+01, 5.5948533315E+00, 1.4795081636E+00, 1.0541701149E+00, 7.5830747191E-01],
	[1.8240000000E+04, 1.0645062155E+01, 5.5946611521E+00, 1.4808084727E+00, 1.0548646912E+00, 7.5841685826E-01],
	[1.8245000000E+04, 1.0649281127E+01, 5.5944690318E+00, 1.4821095669E+00, 1.0555593952E+00, 7.5852620628E-01],
	[1.8250000000E+04, 1.0653500615E+01, 5.5942769709E+00, 1.4834114466E+00, 1.0562542266E+00, 7.5863551594E-01],
	[1.8255000000E+04, 1.0657720618E+01, 5.5940849691E+00, 1.4847141121E+00, 1.0569491853E+00, 7.5874478726E-01],
	[1.8260000000E+04, 1.0661941136E+01, 5.5938930265E+00, 1.4860175636E+00, 1.0576442710E+00, 7.5885402023E-01],
	[1.8265000000E+04, 1.0666162169E+01, 5.5937011430E+00, 1.4873218013E+00, 1.0583394837E+00, 7.5896321485E-01],
	[1.8270000000E+04, 1.0670383717E+01, 5.5935093187E+00, 1.4886268256E+00, 1.0590348231E+00, 7.5907237112E-01],
	[1.8275000000E+04, 1.0674605781E+01, 5.5933175533E+00, 1.4899326366E+00, 1.0597302890E+00, 7.5918148904E-01],
	[1.8280000000E+04, 1.0678828359E+01, 5.5931258471E+00, 1.4912392347E+00, 1.0604258811E+00, 7.5929056859E-01],
	[1.8285000000E+04, 1.0683051452E+01, 5.5929341998E+00, 1.4925466200E+00, 1.0611215995E+00, 7.5939960979E-01],
	[1.8290000000E+04, 1.0687275060E+01, 5.5927426115E+00, 1.4938547929E+00, 1.0618174437E+00, 7.5950861264E-01],
	[1.8295000000E+04, 1.0691499182E+01, 5.5925510821E+00, 1.4951637536E+00, 1.0625134137E+00, 7.5961757712E-01],
	[1.8300000000E+04, 1.0695723819E+01, 5.5923596116E+00, 1.4964735024E+00, 1.0632095093E+00, 7.5972650324E-01],
	[1.8305000000E+04, 1.0699948971E+01, 5.5921682000E+00, 1.4977840395E+00, 1.0639057302E+00, 7.5983539099E-01],
	[1.8310000000E+04, 1.0704174637E+01, 5.5919768472E+00, 1.4990953652E+00, 1.0646020763E+00, 7.5994424038E-01],
	[1.8315000000E+04, 1.0708400817E+01, 5.5917855532E+00, 1.5004074797E+00, 1.0652985473E+00, 7.6005305140E-01],
	[1.8320000000E+04, 1.0712627512E+01, 5.5915943179E+00, 1.5017203833E+00, 1.0659951432E+00, 7.6016182406E-01],
	[1.8325000000E+04, 1.0716854721E+01, 5.5914031414E+00, 1.5030340763E+00, 1.0666918636E+00, 7.6027055834E-01],
	[1.8330000000E+04, 1.0721082444E+01, 5.5912120235E+00, 1.5043485589E+00, 1.0673887085E+00, 7.6037925426E-01],
	[1.8335000000E+04, 1.0725310681E+01, 5.5910209643E+00, 1.5056638314E+00, 1.0680856775E+00, 7.6048791180E-01],
	[1.8340000000E+04, 1.0729539432E+01, 5.5908299638E+00, 1.5069798940E+00, 1.0687827706E+00, 7.6059653097E-01],
	[1.8345000000E+04, 1.0733768697E+01, 5.5906390218E+00, 1.5082967470E+00, 1.0694799875E+00, 7.6070511177E-01],
	[1.8350000000E+04, 1.0737998476E+01, 5.5904481384E+00, 1.5096143906E+00, 1.0701773281E+00, 7.6081365419E-01],
	[1.8355000000E+04, 1.0742228769E+01, 5.5902573134E+00, 1.5109328252E+00, 1.0708747920E+00, 7.6092215823E-01],
	[1.8360000000E+04, 1.0746459575E+01, 5.5900665470E+00, 1.5122520509E+00, 1.0715723793E+00, 7.6103062389E-01],
	[1.8365000000E+04, 1.0750690895E+01, 5.5898758391E+00, 1.5135720681E+00, 1.0722700896E+00, 7.6113905117E-01],
	[1.8370000000E+04, 1.0754922728E+01, 5.5896851895E+00, 1.5148928769E+00, 1.0729679228E+00, 7.6124744008E-01],
	[1.8375000000E+04, 1.0759155075E+01, 5.5894945983E+00, 1.5162144777E+00, 1.0736658786E+00, 7.6135579060E-01],
	[1.8380000000E+04, 1.0763387935E+01, 5.5893040655E+00, 1.5175368706E+00, 1.0743639570E+00, 7.6146410274E-01],
	[1.8385000000E+04, 1.0767621308E+01, 5.5891135910E+00, 1.5188600561E+00, 1.0750621576E+00, 7.6157237649E-01],
	[1.8390000000E+04, 1.0771855195E+01, 5.5889231748E+00, 1.5201840342E+00, 1.0757604804E+00, 7.6168061186E-01],
	[1.8395000000E+04, 1.0776089595E+01, 5.5887328168E+00, 1.5215088054E+00, 1.0764589250E+00, 7.6178880885E-01],
	[1.8400000000E+04, 1.0780324508E+01, 5.5885425171E+00, 1.5228343697E+00, 1.0771574914E+00, 7.6189696744E-01],
	[1.8405000000E+04, 1.0784559933E+01, 5.5883522755E+00, 1.5241607276E+00, 1.0778561793E+00, 7.6200508765E-01],
	[1.8410000000E+04, 1.0788795872E+01, 5.5881620921E+00, 1.5254878792E+00, 1.0785549886E+00, 7.6211316947E-01],
	[1.8415000000E+04, 1.0793032323E+01, 5.5879719668E+00, 1.5268158248E+00, 1.0792539189E+00, 7.6222121290E-01],
	[1.8420000000E+04, 1.0797269288E+01, 5.5877818996E+00, 1.5281445647E+00, 1.0799529703E+00, 7.6232921794E-01],
	[1.8425000000E+04, 1.0801506765E+01, 5.5875918904E+00, 1.5294740991E+00, 1.0806521424E+00, 7.6243718459E-01],
	[1.8430000000E+04, 1.0805744754E+01, 5.5874019392E+00, 1.5308044283E+00, 1.0813514351E+00, 7.6254511285E-01],
	[1.8435000000E+04, 1.0809983256E+01, 5.5872120460E+00, 1.5321355525E+00, 1.0820508481E+00, 7.6265300272E-01],
	[1.8440000000E+04, 1.0814222270E+01, 5.5870222108E+00, 1.5334674721E+00, 1.0827503813E+00, 7.6276085419E-01],
	[1.8445000000E+04, 1.0818461797E+01, 5.5868324335E+00, 1.5348001872E+00, 1.0834500346E+00, 7.6286866727E-01],
	[1.8450000000E+04, 1.0822701836E+01, 5.5866427140E+00, 1.5361336981E+00, 1.0841498076E+00, 7.6297644195E-01],
	[1.8455000000E+04, 1.0826942387E+01, 5.5864530524E+00, 1.5374680051E+00, 1.0848497002E+00, 7.6308417824E-01],
	[1.8460000000E+04, 1.0831183451E+01, 5.5862634487E+00, 1.5388031085E+00, 1.0855497123E+00, 7.6319187613E-01],
	[1.8465000000E+04, 1.0835425026E+01, 5.5860739027E+00, 1.5401390084E+00, 1.0862498436E+00, 7.6329953562E-01],
	[1.8470000000E+04, 1.0839667114E+01, 5.5858844144E+00, 1.5414757052E+00, 1.0869500939E+00, 7.6340715672E-01],
	[1.8475000000E+04, 1.0843909713E+01, 5.5856949839E+00, 1.5428131991E+00, 1.0876504630E+00, 7.6351473942E-01],
	[1.8480000000E+04, 1.0848152824E+01, 5.5855056110E+00, 1.5441514904E+00, 1.0883509508E+00, 7.6362228372E-01],
	[1.8485000000E+04, 1.0852396447E+01, 5.5853162958E+00, 1.5454905793E+00, 1.0890515571E+00, 7.6372978962E-01],
	[1.8490000000E+04, 1.0856640581E+01, 5.5851270382E+00, 1.5468304661E+00, 1.0897522816E+00, 7.6383725713E-01],
	[1.8495000000E+04, 1.0860885227E+01, 5.5849378382E+00, 1.5481711511E+00, 1.0904531242E+00, 7.6394468623E-01],
	[1.8500000000E+04, 1.0865130385E+01, 5.5847486957E+00, 1.5495126344E+00, 1.0911540847E+00, 7.6405207694E-01],
	[1.8505000000E+04, 1.0869376054E+01, 5.5845596108E+00, 1.5508549165E+00, 1.0918551628E+00, 7.6415942924E-01],
	[1.8510000000E+04, 1.0873622234E+01, 5.5843705833E+00, 1.5521979974E+00, 1.0925563585E+00, 7.6426674315E-01],
	[1.8515000000E+04, 1.0877868926E+01, 5.5841816133E+00, 1.5535418776E+00, 1.0932576714E+00, 7.6437401865E-01],
	[1.8520000000E+04, 1.0882116129E+01, 5.5839927007E+00, 1.5548865571E+00, 1.0939591015E+00, 7.6448125575E-01],
	[1.8525000000E+04, 1.0886372155E+01, 5.5838062626E+00, 1.5562320364E+00, 1.0946608254E+00, 7.6458845445E-01],
	[1.8530000000E+04, 1.0890639397E+01, 5.5836229912E+00, 1.5575783157E+00, 1.0953628944E+00, 7.6469561475E-01],
	[1.8535000000E+04, 1.0894907159E+01, 5.5834397751E+00, 1.5589253951E+00, 1.0960650806E+00, 7.6480273665E-01],
	[1.8540000000E+04, 1.0899175442E+01, 5.5832566145E+00, 1.5602732751E+00, 1.0967673840E+00, 7.6490982014E-01],
	[1.8545000000E+04, 1.0903444245E+01, 5.5830735093E+00, 1.5616219558E+00, 1.0974698044E+00, 7.6501686524E-01],
	[1.8550000000E+04, 1.0907713569E+01, 5.5828904595E+00, 1.5629714374E+00, 1.0981723415E+00, 7.6512387193E-01],
	[1.8555000000E+04, 1.0911983413E+01, 5.5827074650E+00, 1.5643217204E+00, 1.0988749951E+00, 7.6523084022E-01],
	[1.8560000000E+04, 1.0916253778E+01, 5.5825245258E+00, 1.5656728048E+00, 1.0995777651E+00, 7.6533777010E-01],
	[1.8565000000E+04, 1.0920524663E+01, 5.5823416419E+00, 1.5670246910E+00, 1.1002806513E+00, 7.6544466159E-01],
	[1.8570000000E+04, 1.0924796068E+01, 5.5821588132E+00, 1.5683773793E+00, 1.1009836535E+00, 7.6555151467E-01],
	[1.8575000000E+04, 1.0929067993E+01, 5.5819760397E+00, 1.5697308698E+00, 1.1016867715E+00, 7.6565832935E-01],
	[1.8580000000E+04, 1.0933340438E+01, 5.5817933214E+00, 1.5710851629E+00, 1.1023900051E+00, 7.6576510563E-01],
	[1.8585000000E+04, 1.0937613403E+01, 5.5816106582E+00, 1.5724402588E+00, 1.1030933540E+00, 7.6587184350E-01],
	[1.8590000000E+04, 1.0941886888E+01, 5.5814280501E+00, 1.5737961578E+00, 1.1037968182E+00, 7.6597854298E-01],
	[1.8595000000E+04, 1.0946160893E+01, 5.5812454971E+00, 1.5751528601E+00, 1.1045003975E+00, 7.6608520405E-01],
	[1.8600000000E+04, 1.0950435417E+01, 5.5810629992E+00, 1.5765103660E+00, 1.1052040915E+00, 7.6619182672E-01],
	[1.8605000000E+04, 1.0954710461E+01, 5.5808805563E+00, 1.5778686757E+00, 1.1059079002E+00, 7.6629841099E-01],
	[1.8610000000E+04, 1.0958986025E+01, 5.5806981684E+00, 1.5792277896E+00, 1.1066118234E+00, 7.6640495685E-01],
	[1.8615000000E+04, 1.0963262108E+01, 5.5805158354E+00, 1.5805877078E+00, 1.1073158608E+00, 7.6651146432E-01],
	[1.8620000000E+04, 1.0967538710E+01, 5.5803335573E+00, 1.5819484306E+00, 1.1080200123E+00, 7.6661793339E-01],
	[1.8625000000E+04, 1.0971815832E+01, 5.5801513342E+00, 1.5833099583E+00, 1.1087242776E+00, 7.6672436405E-01],
	[1.8630000000E+04, 1.0976093473E+01, 5.5799691659E+00, 1.5846722912E+00, 1.1094286566E+00, 7.6683075632E-01],
	[1.8635000000E+04, 1.0980371634E+01, 5.5797870524E+00, 1.5860354294E+00, 1.1101331492E+00, 7.6693711019E-01],
	[1.8640000000E+04, 1.0984650313E+01, 5.5796049937E+00, 1.5873993733E+00, 1.1108377550E+00, 7.6704342565E-01],
	[1.8645000000E+04, 1.0988929511E+01, 5.5794229898E+00, 1.5887641232E+00, 1.1115424739E+00, 7.6714970272E-01],
	[1.8650000000E+04, 1.0993209229E+01, 5.5792410406E+00, 1.5901296792E+00, 1.1122473057E+00, 7.6725594139E-01],
	[1.8655000000E+04, 1.0997489465E+01, 5.5790591462E+00, 1.5914960416E+00, 1.1129522503E+00, 7.6736214166E-01],
	[1.8660000000E+04, 1.1001770220E+01, 5.5788773064E+00, 1.5928632108E+00, 1.1136573074E+00, 7.6746830354E-01],
	[1.8665000000E+04, 1.1006051494E+01, 5.5786955212E+00, 1.5942311868E+00, 1.1143624768E+00, 7.6757442702E-01],
	[1.8670000000E+04, 1.1010333286E+01, 5.5785137907E+00, 1.5955999702E+00, 1.1150677583E+00, 7.6768051210E-01],
	[1.8675000000E+04, 1.1014615597E+01, 5.5783321147E+00, 1.5969695609E+00, 1.1157731519E+00, 7.6778655878E-01],
	[1.8680000000E+04, 1.1018898427E+01, 5.5781504933E+00, 1.5983399595E+00, 1.1164786571E+00, 7.6789256707E-01],
	[1.8685000000E+04, 1.1023181775E+01, 5.5779689264E+00, 1.5997111660E+00, 1.1171842740E+00, 7.6799853697E-01],
	[1.8690000000E+04, 1.1027465641E+01, 5.5777874140E+00, 1.6010831807E+00, 1.1178900022E+00, 7.6810446847E-01],
	[1.8695000000E+04, 1.1031750025E+01, 5.5776059561E+00, 1.6024560040E+00, 1.1185958416E+00, 7.6821036158E-01],
	[1.8700000000E+04, 1.1036034928E+01, 5.5774245525E+00, 1.6038296361E+00, 1.1193017920E+00, 7.6831621630E-01],
	[1.8705000000E+04, 1.1040320349E+01, 5.5772432034E+00, 1.6052040771E+00, 1.1200078532E+00, 7.6842203262E-01],
	[1.8710000000E+04, 1.1044606288E+01, 5.5770619086E+00, 1.6065793996E+00, 1.1207140601E+00, 7.6852781056E-01],
	[1.8715000000E+04, 1.1048892744E+01, 5.5768806682E+00, 1.6079556716E+00, 1.1214204455E+00, 7.6863355010E-01],
	[1.8720000000E+04, 1.1053179719E+01, 5.5766994821E+00, 1.6093327537E+00, 1.1221269411E+00, 7.6873925126E-01],
	[1.8725000000E+04, 1.1057467211E+01, 5.5765183502E+00, 1.6107106463E+00, 1.1228335469E+00, 7.6884491403E-01],
	[1.8730000000E+04, 1.1061755222E+01, 5.5763372726E+00, 1.6120893495E+00, 1.1235402626E+00, 7.6895053841E-01],
	[1.8735000000E+04, 1.1066043750E+01, 5.5761562492E+00, 1.6134688637E+00, 1.1242470880E+00, 7.6905612440E-01],
	[1.8740000000E+04, 1.1070332795E+01, 5.5759752800E+00, 1.6148491890E+00, 1.1249540229E+00, 7.6916167200E-01],
	[1.8745000000E+04, 1.1074622358E+01, 5.5757943649E+00, 1.6162303257E+00, 1.1256610671E+00, 7.6926718123E-01],
	[1.8750000000E+04, 1.1078912438E+01, 5.5756135039E+00, 1.6176122742E+00, 1.1263682205E+00, 7.6937265207E-01],
	[1.8755000000E+04, 1.1083203036E+01, 5.5754326970E+00, 1.6189950346E+00, 1.1270754828E+00, 7.6947808452E-01],
	[1.8760000000E+04, 1.1087494151E+01, 5.5752519442E+00, 1.6203786072E+00, 1.1277828539E+00, 7.6958347860E-01],
	[1.8765000000E+04, 1.1091785783E+01, 5.5750712454E+00, 1.6217629923E+00, 1.1284903335E+00, 7.6968883429E-01],
	[1.8770000000E+04, 1.1096077933E+01, 5.5748906006E+00, 1.6231481901E+00, 1.1291979215E+00, 7.6979415160E-01],
	[1.8775000000E+04, 1.1100370599E+01, 5.5747100098E+00, 1.6245342010E+00, 1.1299056177E+00, 7.6989943054E-01],
	[1.8780000000E+04, 1.1104663782E+01, 5.5745294729E+00, 1.6259210250E+00, 1.1306134218E+00, 7.7000467110E-01],
	[1.8785000000E+04, 1.1108957483E+01, 5.5743489899E+00, 1.6273086626E+00, 1.1313213338E+00, 7.7010987328E-01],
	[1.8790000000E+04, 1.1113251700E+01, 5.5741685608E+00, 1.6286971140E+00, 1.1320293533E+00, 7.7021503710E-01],
	[1.8795000000E+04, 1.1117546434E+01, 5.5739881855E+00, 1.6300863794E+00, 1.1327374802E+00, 7.7032016275E-01],
	[1.8800000000E+04, 1.1121841684E+01, 5.5738078640E+00, 1.6314764591E+00, 1.1334457144E+00, 7.7042525033E-01],
	[1.8805000000E+04, 1.1126137451E+01, 5.5736275964E+00, 1.6328673534E+00, 1.1341540556E+00, 7.7053029983E-01],
	[1.8810000000E+04, 1.1130433735E+01, 5.5734473824E+00, 1.6342590625E+00, 1.1348625036E+00, 7.7063531124E-01],
	[1.8815000000E+04, 1.1134730535E+01, 5.5732672222E+00, 1.6356515866E+00, 1.1355710582E+00, 7.7074028457E-01],
	[1.8820000000E+04, 1.1139027852E+01, 5.5730871157E+00, 1.6370449261E+00, 1.1362797193E+00, 7.7084521982E-01],
	[1.8825000000E+04, 1.1143341238E+01, 5.5729114114E+00, 1.6384390812E+00, 1.1369888296E+00, 7.7095011698E-01],
	[1.8830000000E+04, 1.1147659065E+01, 5.5727368540E+00, 1.6398340521E+00, 1.1376981330E+00, 7.7105497606E-01],
	[1.8835000000E+04, 1.1151977419E+01, 5.5725623485E+00, 1.6412298392E+00, 1.1384075431E+00, 7.7115979706E-01],
	[1.8840000000E+04, 1.1156296298E+01, 5.5723878947E+00, 1.6426264426E+00, 1.1391170597E+00, 7.7126457997E-01],
	[1.8845000000E+04, 1.1160615703E+01, 5.5722134927E+00, 1.6440238627E+00, 1.1398266826E+00, 7.7136932480E-01],
	[1.8850000000E+04, 1.1164935634E+01, 5.5720391424E+00, 1.6454220996E+00, 1.1405364115E+00, 7.7147403155E-01],
	[1.8855000000E+04, 1.1169256091E+01, 5.5718648437E+00, 1.6468211537E+00, 1.1412462464E+00, 7.7157870021E-01],
	[1.8860000000E+04, 1.1173577074E+01, 5.5716905968E+00, 1.6482210252E+00, 1.1419561870E+00, 7.7168333079E-01],
	[1.8865000000E+04, 1.1177898582E+01, 5.5715164015E+00, 1.6496217144E+00, 1.1426662332E+00, 7.7178792328E-01],
	[1.8870000000E+04, 1.1182220615E+01, 5.5713422578E+00, 1.6510232216E+00, 1.1433763847E+00, 7.7189247769E-01],
	[1.8875000000E+04, 1.1186543174E+01, 5.5711681657E+00, 1.6524255469E+00, 1.1440866413E+00, 7.7199699401E-01],
	[1.8880000000E+04, 1.1190866259E+01, 5.5709941251E+00, 1.6538286907E+00, 1.1447970029E+00, 7.7210147225E-01],
	[1.8885000000E+04, 1.1195189868E+01, 5.5708201360E+00, 1.6552326532E+00, 1.1455074692E+00, 7.7220591241E-01],
	[1.8890000000E+04, 1.1199514003E+01, 5.5706461984E+00, 1.6566374346E+00, 1.1462180402E+00, 7.7231031448E-01],
	[1.8895000000E+04, 1.1203838663E+01, 5.5704723123E+00, 1.6580430353E+00, 1.1469287155E+00, 7.7241467847E-01],
	[1.8900000000E+04, 1.1208163848E+01, 5.5702984777E+00, 1.6594494555E+00, 1.1476394949E+00, 7.7251900437E-01],
	[1.8905000000E+04, 1.1212489558E+01, 5.5701246944E+00, 1.6608566955E+00, 1.1483503784E+00, 7.7262329219E-01],
	[1.8910000000E+04, 1.1216815793E+01, 5.5699509625E+00, 1.6622647554E+00, 1.1490613657E+00, 7.7272754193E-01],
	[1.8915000000E+04, 1.1221142552E+01, 5.5697772820E+00, 1.6636736357E+00, 1.1497724566E+00, 7.7283175358E-01],
	[1.8920000000E+04, 1.1225469837E+01, 5.5696036527E+00, 1.6650833365E+00, 1.1504836509E+00, 7.7293592716E-01],
	[1.8925000000E+04, 1.1229797646E+01, 5.5694300748E+00, 1.6664938580E+00, 1.1511949484E+00, 7.7304006264E-01],
	[1.8930000000E+04, 1.1234125980E+01, 5.5692565481E+00, 1.6679052007E+00, 1.1519063490E+00, 7.7314416005E-01],
	[1.8935000000E+04, 1.1238454838E+01, 5.5690830727E+00, 1.6693173646E+00, 1.1526178524E+00, 7.7324821938E-01],
	[1.8940000000E+04, 1.1242784221E+01, 5.5689096484E+00, 1.6707303501E+00, 1.1533294585E+00, 7.7335224062E-01],
	[1.8945000000E+04, 1.1247114128E+01, 5.5687362754E+00, 1.6721441575E+00, 1.1540411670E+00, 7.7345622378E-01],
	[1.8950000000E+04, 1.1251444559E+01, 5.5685629534E+00, 1.6735587869E+00, 1.1547529778E+00, 7.7356016886E-01],
	[1.8955000000E+04, 1.1255775515E+01, 5.5683896826E+00, 1.6749742387E+00, 1.1554648906E+00, 7.7366407586E-01],
	[1.8960000000E+04, 1.1260106994E+01, 5.5682164629E+00, 1.6763905132E+00, 1.1561769054E+00, 7.7376794479E-01],
	[1.8965000000E+04, 1.1264438998E+01, 5.5680432943E+00, 1.6778076105E+00, 1.1568890218E+00, 7.7387177563E-01],
	[1.8970000000E+04, 1.1268771526E+01, 5.5678701767E+00, 1.6792255309E+00, 1.1576012398E+00, 7.7397556839E-01],
	[1.8975000000E+04, 1.1273104578E+01, 5.5676971100E+00, 1.6806442748E+00, 1.1583135590E+00, 7.7407932308E-01],
	[1.8980000000E+04, 1.1277438153E+01, 5.5675240944E+00, 1.6820638423E+00, 1.1590259794E+00, 7.7418303968E-01],
	[1.8985000000E+04, 1.1281772253E+01, 5.5673511297E+00, 1.6834842337E+00, 1.1597385006E+00, 7.7428671822E-01],
	[1.8990000000E+04, 1.1286106876E+01, 5.5671782159E+00, 1.6849054493E+00, 1.1604511227E+00, 7.7439035867E-01],
	[1.8995000000E+04, 1.1290442023E+01, 5.5670053530E+00, 1.6863274893E+00, 1.1611638452E+00, 7.7449396105E-01],
	[1.9000000000E+04, 1.1294777693E+01, 5.5668325410E+00, 1.6877503541E+00, 1.1618766681E+00, 7.7459752536E-01],
	[1.9005000000E+04, 1.1299113886E+01, 5.5666597798E+00, 1.6891740438E+00, 1.1625895912E+00, 7.7470105159E-01],
	[1.9010000000E+04, 1.1303450604E+01, 5.5664870694E+00, 1.6905985587E+00, 1.1633026142E+00, 7.7480453974E-01],
	[1.9015000000E+04, 1.1307787844E+01, 5.5663144098E+00, 1.6920238991E+00, 1.1640157370E+00, 7.7490798983E-01],
	[1.9020000000E+04, 1.1312125608E+01, 5.5661418010E+00, 1.6934500652E+00, 1.1647289593E+00, 7.7501140184E-01],
	[1.9025000000E+04, 1.1316463895E+01, 5.5659692428E+00, 1.6948770574E+00, 1.1654422811E+00, 7.7511477578E-01],
	[1.9030000000E+04, 1.1320802705E+01, 5.5657967354E+00, 1.6963048758E+00, 1.1661557020E+00, 7.7521811166E-01],
	[1.9035000000E+04, 1.1325142038E+01, 5.5656242786E+00, 1.6977335207E+00, 1.1668692220E+00, 7.7532140946E-01],
	[1.9040000000E+04, 1.1329481894E+01, 5.5654518724E+00, 1.6991629924E+00, 1.1675828407E+00, 7.7542466919E-01],
	[1.9045000000E+04, 1.1333822273E+01, 5.5652795169E+00, 1.7005932912E+00, 1.1682965581E+00, 7.7552789086E-01],
	[1.9050000000E+04, 1.1338163174E+01, 5.5651072119E+00, 1.7020244173E+00, 1.1690103739E+00, 7.7563107446E-01],
	[1.9055000000E+04, 1.1342504599E+01, 5.5649349575E+00, 1.7034563709E+00, 1.1697242880E+00, 7.7573422000E-01],
	[1.9060000000E+04, 1.1346846546E+01, 5.5647627536E+00, 1.7048891523E+00, 1.1704383001E+00, 7.7583732747E-01],
	[1.9065000000E+04, 1.1351189015E+01, 5.5645906002E+00, 1.7063227619E+00, 1.1711524100E+00, 7.7594039688E-01],
	[1.9070000000E+04, 1.1355532008E+01, 5.5644184973E+00, 1.7077571998E+00, 1.1718666176E+00, 7.7604342823E-01],
	[1.9075000000E+04, 1.1359875522E+01, 5.5642464448E+00, 1.7091924663E+00, 1.1725809227E+00, 7.7614642151E-01],
	[1.9080000000E+04, 1.1364219559E+01, 5.5640744427E+00, 1.7106285616E+00, 1.1732953250E+00, 7.7624937674E-01],
	[1.9085000000E+04, 1.1368564119E+01, 5.5639024910E+00, 1.7120654861E+00, 1.1740098244E+00, 7.7635229390E-01],
	[1.9090000000E+04, 1.1372909200E+01, 5.5637305897E+00, 1.7135032400E+00, 1.1747244208E+00, 7.7645517301E-01],
	[1.9095000000E+04, 1.1377254804E+01, 5.5635587387E+00, 1.7149418235E+00, 1.1754391138E+00, 7.7655801407E-01],
	[1.9100000000E+04, 1.1381600929E+01, 5.5633869380E+00, 1.7163812370E+00, 1.1761539033E+00, 7.7666081706E-01],
	[1.9105000000E+04, 1.1385947577E+01, 5.5632151875E+00, 1.7178214806E+00, 1.1768687891E+00, 7.7676358201E-01],
	[1.9110000000E+04, 1.1390294747E+01, 5.5630434873E+00, 1.7192625546E+00, 1.1775837711E+00, 7.7686630890E-01],
	[1.9115000000E+04, 1.1394642438E+01, 5.5628718373E+00, 1.7207044594E+00, 1.1782988490E+00, 7.7696899774E-01],
	[1.9120000000E+04, 1.1398990651E+01, 5.5627002375E+00, 1.7221471951E+00, 1.1790140227E+00, 7.7707164853E-01],
	[1.9125000000E+04, 1.1403343380E+01, 5.5625297621E+00, 1.7235907620E+00, 1.1797293829E+00, 7.7717426127E-01],
	[1.9130000000E+04, 1.1407712575E+01, 5.5623636231E+00, 1.7250351604E+00, 1.1804452024E+00, 7.7727683597E-01],
	[1.9135000000E+04, 1.1412082301E+01, 5.5621975326E+00, 1.7264803905E+00, 1.1811611180E+00, 7.7737937262E-01],
	[1.9140000000E+04, 1.1416452560E+01, 5.5620314904E+00, 1.7279264526E+00, 1.1818771293E+00, 7.7748187122E-01],
	[1.9145000000E+04, 1.1420823349E+01, 5.5618654965E+00, 1.7293733470E+00, 1.1825932363E+00, 7.7758433179E-01],
	[1.9150000000E+04, 1.1425194670E+01, 5.5616995509E+00, 1.7308210738E+00, 1.1833094387E+00, 7.7768675431E-01],
	[1.9155000000E+04, 1.1429566522E+01, 5.5615336536E+00, 1.7322696335E+00, 1.1840257364E+00, 7.7778913879E-01],
	[1.9160000000E+04, 1.1433938906E+01, 5.5613678045E+00, 1.7337190262E+00, 1.1847421290E+00, 7.7789148523E-01],
	[1.9165000000E+04, 1.1438311820E+01, 5.5612020037E+00, 1.7351692522E+00, 1.1854586166E+00, 7.7799379364E-01],
	[1.9170000000E+04, 1.1442685266E+01, 5.5610362510E+00, 1.7366203118E+00, 1.1861751988E+00, 7.7809606401E-01],
	[1.9175000000E+04, 1.1447059243E+01, 5.5608705465E+00, 1.7380722052E+00, 1.1868918754E+00, 7.7819829635E-01],
	[1.9180000000E+04, 1.1451433750E+01, 5.5607048902E+00, 1.7395249326E+00, 1.1876086464E+00, 7.7830049066E-01],
	[1.9185000000E+04, 1.1455808789E+01, 5.5605392819E+00, 1.7409784945E+00, 1.1883255114E+00, 7.7840264693E-01],
	[1.9190000000E+04, 1.1460184358E+01, 5.5603737218E+00, 1.7424328909E+00, 1.1890424703E+00, 7.7850476518E-01],
	[1.9195000000E+04, 1.1464560458E+01, 5.5602082097E+00, 1.7438881222E+00, 1.1897595229E+00, 7.7860684540E-01],
	[1.9200000000E+04, 1.1468937088E+01, 5.5600427456E+00, 1.7453441886E+00, 1.1904766691E+00, 7.7870888760E-01],
	[1.9205000000E+04, 1.1473314249E+01, 5.5598773296E+00, 1.7468010904E+00, 1.1911939085E+00, 7.7881089178E-01],
	[1.9210000000E+04, 1.1477691940E+01, 5.5597119615E+00, 1.7482588278E+00, 1.1919112411E+00, 7.7891285793E-01],
	[1.9215000000E+04, 1.1482070162E+01, 5.5595466414E+00, 1.7497174012E+00, 1.1926286667E+00, 7.7901478606E-01],
	[1.9220000000E+04, 1.1486448914E+01, 5.5593813692E+00, 1.7511768107E+00, 1.1933461849E+00, 7.7911667618E-01],
	[1.9225000000E+04, 1.1490828197E+01, 5.5592161449E+00, 1.7526370566E+00, 1.1940637958E+00, 7.7921852828E-01],
	[1.9230000000E+04, 1.1495208009E+01, 5.5590509685E+00, 1.7540981393E+00, 1.1947814990E+00, 7.7932034237E-01],
	[1.9235000000E+04, 1.1499588352E+01, 5.5588858399E+00, 1.7555600589E+00, 1.1954992944E+00, 7.7942211844E-01],
	[1.9240000000E+04, 1.1503969225E+01, 5.5587207591E+00, 1.7570228157E+00, 1.1962171817E+00, 7.7952385651E-01],
	[1.9245000000E+04, 1.1508350627E+01, 5.5585557262E+00, 1.7584864100E+00, 1.1969351609E+00, 7.7962555656E-01],
	[1.9250000000E+04, 1.1512732560E+01, 5.5583907410E+00, 1.7599508420E+00, 1.1976532316E+00, 7.7972721861E-01],
	[1.9255000000E+04, 1.1517115022E+01, 5.5582258035E+00, 1.7614161121E+00, 1.1983713938E+00, 7.7982884266E-01],
	[1.9260000000E+04, 1.1521498014E+01, 5.5580609138E+00, 1.7628822203E+00, 1.1990896472E+00, 7.7993042871E-01],
	[1.9265000000E+04, 1.1525881536E+01, 5.5578960718E+00, 1.7643491671E+00, 1.1998079916E+00, 7.8003197675E-01],
	[1.9270000000E+04, 1.1530265587E+01, 5.5577312774E+00, 1.7658169527E+00, 1.2005264268E+00, 7.8013348680E-01],
	[1.9275000000E+04, 1.1534650168E+01, 5.5575665307E+00, 1.7672855773E+00, 1.2012449527E+00, 7.8023495885E-01],
	[1.9280000000E+04, 1.1539035278E+01, 5.5574018315E+00, 1.7687550413E+00, 1.2019635691E+00, 7.8033639291E-01],
	[1.9285000000E+04, 1.1543420918E+01, 5.5572371800E+00, 1.7702253448E+00, 1.2026822757E+00, 7.8043778898E-01],
	[1.9290000000E+04, 1.1547807087E+01, 5.5570725760E+00, 1.7716964881E+00, 1.2034010723E+00, 7.8053914706E-01],
	[1.9295000000E+04, 1.1552193785E+01, 5.5569080196E+00, 1.7731684715E+00, 1.2041199589E+00, 7.8064046716E-01],
	[1.9300000000E+04, 1.1556581012E+01, 5.5567435106E+00, 1.7746412952E+00, 1.2048389351E+00, 7.8074174927E-01],
	[1.9305000000E+04, 1.1560968769E+01, 5.5565790492E+00, 1.7761149596E+00, 1.2055580009E+00, 7.8084299339E-01],
	[1.9310000000E+04, 1.1565357054E+01, 5.5564146352E+00, 1.7775894648E+00, 1.2062771559E+00, 7.8094419954E-01],
	[1.9315000000E+04, 1.1569745868E+01, 5.5562502686E+00, 1.7790648112E+00, 1.2069964001E+00, 7.8104536771E-01],
	[1.9320000000E+04, 1.1574135211E+01, 5.5560859494E+00, 1.7805409989E+00, 1.2077157332E+00, 7.8114649790E-01],
	[1.9325000000E+04, 1.1578525083E+01, 5.5559216776E+00, 1.7820180283E+00, 1.2084351550E+00, 7.8124759012E-01],
	[1.9330000000E+04, 1.1582915484E+01, 5.5557574532E+00, 1.7834958997E+00, 1.2091546654E+00, 7.8134864438E-01],
	[1.9335000000E+04, 1.1587306413E+01, 5.5555932761E+00, 1.7849746132E+00, 1.2098742641E+00, 7.8144966066E-01],
	[1.9340000000E+04, 1.1591697871E+01, 5.5554291463E+00, 1.7864541691E+00, 1.2105939510E+00, 7.8155063898E-01],
	[1.9345000000E+04, 1.1596089857E+01, 5.5552650637E+00, 1.7879345677E+00, 1.2113137258E+00, 7.8165157933E-01],
	[1.9350000000E+04, 1.1600482372E+01, 5.5551010285E+00, 1.7894158093E+00, 1.2120335885E+00, 7.8175248173E-01],
	[1.9355000000E+04, 1.1604875414E+01, 5.5549370404E+00, 1.7908978941E+00, 1.2127535387E+00, 7.8185334616E-01],
	[1.9360000000E+04, 1.1609268986E+01, 5.5547730995E+00, 1.7923808224E+00, 1.2134735763E+00, 7.8195417264E-01],
	[1.9365000000E+04, 1.1613663085E+01, 5.5546092058E+00, 1.7938645945E+00, 1.2141937011E+00, 7.8205496117E-01],
	[1.9370000000E+04, 1.1618057713E+01, 5.5544453593E+00, 1.7953492105E+00, 1.2149139129E+00, 7.8215571175E-01],
	[1.9375000000E+04, 1.1622452868E+01, 5.5542815598E+00, 1.7968346708E+00, 1.2156342116E+00, 7.8225642438E-01],
	[1.9380000000E+04, 1.1626848552E+01, 5.5541178075E+00, 1.7983209756E+00, 1.2163545969E+00, 7.8235709907E-01],
	[1.9385000000E+04, 1.1631244763E+01, 5.5539541022E+00, 1.7998081253E+00, 1.2170750686E+00, 7.8245773581E-01],
	[1.9390000000E+04, 1.1635641503E+01, 5.5537904440E+00, 1.8012961200E+00, 1.2177956266E+00, 7.8255833461E-01],
	[1.9395000000E+04, 1.1640038770E+01, 5.5536268328E+00, 1.8027849599E+00, 1.2185162706E+00, 7.8265889548E-01],
	[1.9400000000E+04, 1.1644436565E+01, 5.5534632686E+00, 1.8042746455E+00, 1.2192370005E+00, 7.8275941841E-01],
	[1.9405000000E+04, 1.1648834887E+01, 5.5532997513E+00, 1.8057651769E+00, 1.2199578161E+00, 7.8285990342E-01],
	[1.9410000000E+04, 1.1653233737E+01, 5.5531362810E+00, 1.8072565544E+00, 1.2206787172E+00, 7.8296035049E-01],
	[1.9415000000E+04, 1.1657633114E+01, 5.5529728576E+00, 1.8087487783E+00, 1.2213997036E+00, 7.8306075964E-01],
	[1.9420000000E+04, 1.1662033019E+01, 5.5528094811E+00, 1.8102418487E+00, 1.2221207750E+00, 7.8316113086E-01],
	[1.9425000000E+04, 1.1666433451E+01, 5.5526461514E+00, 1.8117357661E+00, 1.2228419314E+00, 7.8326146416E-01],
	[1.9430000000E+04, 1.1670834410E+01, 5.5524828686E+00, 1.8132305306E+00, 1.2235631725E+00, 7.8336175955E-01],
	[1.9435000000E+04, 1.1675248678E+01, 5.5523229396E+00, 1.8147261425E+00, 1.2242847995E+00, 7.8346201702E-01],
	[1.9440000000E+04, 1.1679671109E+01, 5.5521650294E+00, 1.8162226021E+00, 1.2250066914E+00, 7.8356223659E-01],
	[1.9445000000E+04, 1.1684094076E+01, 5.5520071644E+00, 1.8177199095E+00, 1.2257286682E+00, 7.8366241824E-01],
	[1.9450000000E+04, 1.1688517581E+01, 5.5518493444E+00, 1.8192180652E+00, 1.2264507299E+00, 7.8376256199E-01],
	[1.9455000000E+04, 1.1692941623E+01, 5.5516915694E+00, 1.8207170694E+00, 1.2271728762E+00, 7.8386266783E-01],
	[1.9460000000E+04, 1.1697366202E+01, 5.5515338395E+00, 1.8222169222E+00, 1.2278951069E+00, 7.8396273578E-01],
	[1.9465000000E+04, 1.1701791318E+01, 5.5513761546E+00, 1.8237176240E+00, 1.2286174219E+00, 7.8406276583E-01],
	[1.9470000000E+04, 1.1706216971E+01, 5.5512185146E+00, 1.8252191751E+00, 1.2293398209E+00, 7.8416275798E-01],
	[1.9475000000E+04, 1.1710643160E+01, 5.5510609196E+00, 1.8267215756E+00, 1.2300623038E+00, 7.8426271225E-01],
	[1.9480000000E+04, 1.1715069886E+01, 5.5509033695E+00, 1.8282248259E+00, 1.2307848704E+00, 7.8436262863E-01],
	[1.9485000000E+04, 1.1719497149E+01, 5.5507458644E+00, 1.8297289263E+00, 1.2315075204E+00, 7.8446250712E-01],
	[1.9490000000E+04, 1.1723924948E+01, 5.5505884041E+00, 1.8312338769E+00, 1.2322302538E+00, 7.8456234774E-01],
	[1.9495000000E+04, 1.1728353284E+01, 5.5504309887E+00, 1.8327396780E+00, 1.2329530702E+00, 7.8466215048E-01],
	[1.9500000000E+04, 1.1732782156E+01, 5.5502736181E+00, 1.8342463300E+00, 1.2336759696E+00, 7.8476191534E-01],
	[1.9505000000E+04, 1.1737211565E+01, 5.5501162923E+00, 1.8357538330E+00, 1.2343989517E+00, 7.8486164233E-01],
	[1.9510000000E+04, 1.1741641509E+01, 5.5499590112E+00, 1.8372621874E+00, 1.2351220164E+00, 7.8496133146E-01],
	[1.9515000000E+04, 1.1746071990E+01, 5.5498017750E+00, 1.8387713933E+00, 1.2358451634E+00, 7.8506098272E-01],
	[1.9520000000E+04, 1.1750503007E+01, 5.5496445835E+00, 1.8402814511E+00, 1.2365683925E+00, 7.8516059611E-01],
	[1.9525000000E+04, 1.1754934561E+01, 5.5494874367E+00, 1.8417923610E+00, 1.2372917036E+00, 7.8526017165E-01],
	[1.9530000000E+04, 1.1759366650E+01, 5.5493303345E+00, 1.8433041233E+00, 1.2380150965E+00, 7.8535970934E-01],
	[1.9535000000E+04, 1.1763799275E+01, 5.5491732771E+00, 1.8448167382E+00, 1.2387385710E+00, 7.8545920917E-01],
	[1.9540000000E+04, 1.1768232435E+01, 5.5490162643E+00, 1.8463302061E+00, 1.2394621269E+00, 7.8555867116E-01],
	[1.9545000000E+04, 1.1772666132E+01, 5.5488592960E+00, 1.8478445270E+00, 1.2401857640E+00, 7.8565809530E-01],
	[1.9550000000E+04, 1.1777100364E+01, 5.5487023724E+00, 1.8493597015E+00, 1.2409094821E+00, 7.8575748161E-01],
	[1.9555000000E+04, 1.1781535132E+01, 5.5485454934E+00, 1.8508757295E+00, 1.2416332810E+00, 7.8585683007E-01],
	[1.9560000000E+04, 1.1785970435E+01, 5.5483886588E+00, 1.8523926116E+00, 1.2423571605E+00, 7.8595614070E-01],
	[1.9565000000E+04, 1.1790406274E+01, 5.5482318688E+00, 1.8539103478E+00, 1.2430811206E+00, 7.8605541350E-01],
	[1.9570000000E+04, 1.1794842648E+01, 5.5480751233E+00, 1.8554289385E+00, 1.2438051608E+00, 7.8615464847E-01],
	[1.9575000000E+04, 1.1799279558E+01, 5.5479184223E+00, 1.8569483840E+00, 1.2445292812E+00, 7.8625384562E-01],
	[1.9580000000E+04, 1.1803717002E+01, 5.5477617657E+00, 1.8584686844E+00, 1.2452534814E+00, 7.8635300495E-01],
	[1.9585000000E+04, 1.1808154982E+01, 5.5476051535E+00, 1.8599898401E+00, 1.2459777613E+00, 7.8645212646E-01],
	[1.9590000000E+04, 1.1812593497E+01, 5.5474485857E+00, 1.8615118514E+00, 1.2467021207E+00, 7.8655121016E-01],
	[1.9595000000E+04, 1.1817032547E+01, 5.5472920623E+00, 1.8630347184E+00, 1.2474265594E+00, 7.8665025606E-01],
	[1.9600000000E+04, 1.1821472132E+01, 5.5471355833E+00, 1.8645584414E+00, 1.2481510772E+00, 7.8674926414E-01],
	[1.9605000000E+04, 1.1825912252E+01, 5.5469791486E+00, 1.8660830207E+00, 1.2488756740E+00, 7.8684823443E-01],
	[1.9610000000E+04, 1.1830352907E+01, 5.5468227581E+00, 1.8676084566E+00, 1.2496003495E+00, 7.8694716691E-01],
	[1.9615000000E+04, 1.1834794096E+01, 5.5466664120E+00, 1.8691347494E+00, 1.2503251035E+00, 7.8704606161E-01],
	[1.9620000000E+04, 1.1839235820E+01, 5.5465101101E+00, 1.8706618992E+00, 1.2510499359E+00, 7.8714491851E-01],
	[1.9625000000E+04, 1.1843678079E+01, 5.5463538524E+00, 1.8721899064E+00, 1.2517748465E+00, 7.8724373763E-01],
	[1.9630000000E+04, 1.1848120872E+01, 5.5461976389E+00, 1.8737187712E+00, 1.2524998351E+00, 7.8734251896E-01],
	[1.9635000000E+04, 1.1852564200E+01, 5.5460414697E+00, 1.8752484938E+00, 1.2532249014E+00, 7.8744126251E-01],
	[1.9640000000E+04, 1.1857008062E+01, 5.5458853446E+00, 1.8767790746E+00, 1.2539500454E+00, 7.8753996829E-01],
	[1.9645000000E+04, 1.1861452458E+01, 5.5457292636E+00, 1.8783105139E+00, 1.2546752667E+00, 7.8763863630E-01],
	[1.9650000000E+04, 1.1865897389E+01, 5.5455732267E+00, 1.8798428117E+00, 1.2554005653E+00, 7.8773726654E-01],
	[1.9655000000E+04, 1.1870342854E+01, 5.5454172339E+00, 1.8813759685E+00, 1.2561259409E+00, 7.8783585902E-01],
	[1.9660000000E+04, 1.1874788853E+01, 5.5452612852E+00, 1.8829099845E+00, 1.2568513934E+00, 7.8793441373E-01],
	[1.9665000000E+04, 1.1879235386E+01, 5.5451053805E+00, 1.8844448599E+00, 1.2575769225E+00, 7.8803293069E-01],
	[1.9670000000E+04, 1.1883682452E+01, 5.5449495198E+00, 1.8859805950E+00, 1.2583025281E+00, 7.8813140990E-01],
	[1.9675000000E+04, 1.1888130053E+01, 5.5447937032E+00, 1.8875171902E+00, 1.2590282100E+00, 7.8822985137E-01],
	[1.9680000000E+04, 1.1892578188E+01, 5.5446379305E+00, 1.8890546455E+00, 1.2597539679E+00, 7.8832825509E-01],
	[1.9685000000E+04, 1.1897026856E+01, 5.5444822017E+00, 1.8905929613E+00, 1.2604798018E+00, 7.8842662106E-01],
	[1.9690000000E+04, 1.1901476058E+01, 5.5443265169E+00, 1.8921321379E+00, 1.2612057113E+00, 7.8852494931E-01],
	[1.9695000000E+04, 1.1905925793E+01, 5.5441708760E+00, 1.8936721756E+00, 1.2619316964E+00, 7.8862323982E-01],
	[1.9700000000E+04, 1.1910376062E+01, 5.5440152789E+00, 1.8952130745E+00, 1.2626577568E+00, 7.8872149260E-01],
	[1.9705000000E+04, 1.1914826865E+01, 5.5438597257E+00, 1.8967548349E+00, 1.2633838923E+00, 7.8881970767E-01],
	[1.9710000000E+04, 1.1919278201E+01, 5.5437042163E+00, 1.8982974572E+00, 1.2641101028E+00, 7.8891788499E-01],
	[1.9715000000E+04, 1.1923730070E+01, 5.5435487507E+00, 1.8998409415E+00, 1.2648363881E+00, 7.8901602457E-01],
	[1.9720000000E+04, 1.1928182472E+01, 5.5433933289E+00, 1.9013852882E+00, 1.2655627479E+00, 7.8911412640E-01],
	[1.9725000000E+04, 1.1932635408E+01, 5.5432379509E+00, 1.9029304974E+00, 1.2662891821E+00, 7.8921219048E-01],
	[1.9730000000E+04, 1.1937088876E+01, 5.5430826166E+00, 1.9044765695E+00, 1.2670156905E+00, 7.8931021682E-01],
	[1.9735000000E+04, 1.1941542878E+01, 5.5429273260E+00, 1.9060235048E+00, 1.2677422729E+00, 7.8940820541E-01],
	[1.9740000000E+04, 1.1945997412E+01, 5.5427720791E+00, 1.9075713034E+00, 1.2684689292E+00, 7.8950615626E-01],
	[1.9745000000E+04, 1.1950453753E+01, 5.5426171929E+00, 1.9091199657E+00, 1.2691956900E+00, 7.8960406937E-01],
	[1.9750000000E+04, 1.1954930246E+01, 5.5424672339E+00, 1.9106694918E+00, 1.2699230021E+00, 7.8970194475E-01],
	[1.9755000000E+04, 1.1959407283E+01, 5.5423173170E+00, 1.9122198822E+00, 1.2706503883E+00, 7.8979978238E-01],
	[1.9760000000E+04, 1.1963884862E+01, 5.5421674420E+00, 1.9137711369E+00, 1.2713778485E+00, 7.8989758229E-01],
	[1.9765000000E+04, 1.1968362985E+01, 5.5420176090E+00, 1.9153232564E+00, 1.2721053824E+00, 7.8999534446E-01],
	[1.9770000000E+04, 1.1972841650E+01, 5.5418678180E+00, 1.9168762408E+00, 1.2728329899E+00, 7.9009306891E-01],
	[1.9775000000E+04, 1.1977320858E+01, 5.5417180688E+00, 1.9184300904E+00, 1.2735606707E+00, 7.9019075563E-01],
	[1.9780000000E+04, 1.1981800609E+01, 5.5415683616E+00, 1.9199848055E+00, 1.2742884247E+00, 7.9028840462E-01],
	[1.9785000000E+04, 1.1986280902E+01, 5.5414186963E+00, 1.9215403864E+00, 1.2750162517E+00, 7.9038601589E-01],
	[1.9790000000E+04, 1.1990761738E+01, 5.5412690728E+00, 1.9230968333E+00, 1.2757441516E+00, 7.9048358944E-01],
	[1.9795000000E+04, 1.1995243116E+01, 5.5411194912E+00, 1.9246541464E+00, 1.2764721240E+00, 7.9058112528E-01],
	[1.9800000000E+04, 1.1999725037E+01, 5.5409699513E+00, 1.9262123261E+00, 1.2772001689E+00, 7.9067862339E-01],
	[1.9805000000E+04, 1.2004207500E+01, 5.5408204533E+00, 1.9277713725E+00, 1.2779282860E+00, 7.9077608380E-01],
	[1.9810000000E+04, 1.2008690505E+01, 5.5406709970E+00, 1.9293312860E+00, 1.2786564751E+00, 7.9087350649E-01],
	[1.9815000000E+04, 1.2013174053E+01, 5.5405215825E+00, 1.9308920669E+00, 1.2793847362E+00, 7.9097089148E-01],
	[1.9820000000E+04, 1.2017658143E+01, 5.5403722097E+00, 1.9324537153E+00, 1.2801130689E+00, 7.9106823876E-01],
	[1.9825000000E+04, 1.2022142774E+01, 5.5402228786E+00, 1.9340162315E+00, 1.2808414730E+00, 7.9116554834E-01],
	[1.9830000000E+04, 1.2026627948E+01, 5.5400735892E+00, 1.9355796159E+00, 1.2815699485E+00, 7.9126282021E-01],
	[1.9835000000E+04, 1.2031113664E+01, 5.5399243415E+00, 1.9371438686E+00, 1.2822984951E+00, 7.9136005439E-01],
	[1.9840000000E+04, 1.2035599921E+01, 5.5397751353E+00, 1.9387089900E+00, 1.2830271126E+00, 7.9145725087E-01],
	[1.9845000000E+04, 1.2040086721E+01, 5.5396259708E+00, 1.9402749802E+00, 1.2837558009E+00, 7.9155440966E-01],
	[1.9850000000E+04, 1.2044574062E+01, 5.5394768479E+00, 1.9418418396E+00, 1.2844845597E+00, 7.9165153076E-01],
	[1.9855000000E+04, 1.2049061944E+01, 5.5393277666E+00, 1.9434095684E+00, 1.2852133889E+00, 7.9174861417E-01],
	[1.9860000000E+04, 1.2053550368E+01, 5.5391787268E+00, 1.9449781670E+00, 1.2859422882E+00, 7.9184565989E-01],
	[1.9865000000E+04, 1.2058039334E+01, 5.5390297285E+00, 1.9465476354E+00, 1.2866712575E+00, 7.9194266793E-01],
	[1.9870000000E+04, 1.2062528841E+01, 5.5388807718E+00, 1.9481179741E+00, 1.2874002966E+00, 7.9203963830E-01],
	[1.9875000000E+04, 1.2067018889E+01, 5.5387318565E+00, 1.9496891832E+00, 1.2881294053E+00, 7.9213657098E-01],
	[1.9880000000E+04, 1.2071509479E+01, 5.5385829827E+00, 1.9512612630E+00, 1.2888585835E+00, 7.9223346599E-01],
	[1.9885000000E+04, 1.2076000610E+01, 5.5384341503E+00, 1.9528342139E+00, 1.2895878309E+00, 7.9233032333E-01],
	[1.9890000000E+04, 1.2080492282E+01, 5.5382853594E+00, 1.9544080360E+00, 1.2903171473E+00, 7.9242714299E-01],
	[1.9895000000E+04, 1.2084984495E+01, 5.5381366098E+00, 1.9559827296E+00, 1.2910465325E+00, 7.9252392500E-01],
	[1.9900000000E+04, 1.2089477249E+01, 5.5379879016E+00, 1.9575582950E+00, 1.2917759865E+00, 7.9262066933E-01],
	[1.9905000000E+04, 1.2093970544E+01, 5.5378392348E+00, 1.9591347325E+00, 1.2925055089E+00, 7.9271737601E-01],
	[1.9910000000E+04, 1.2098464380E+01, 5.5376906092E+00, 1.9607120423E+00, 1.2932350996E+00, 7.9281404503E-01],
	[1.9915000000E+04, 1.2102958757E+01, 5.5375420250E+00, 1.9622902246E+00, 1.2939647584E+00, 7.9291067640E-01],
	[1.9920000000E+04, 1.2107453674E+01, 5.5373934821E+00, 1.9638692798E+00, 1.2946944852E+00, 7.9300727011E-01],
	[1.9925000000E+04, 1.2111949132E+01, 5.5372449805E+00, 1.9654492080E+00, 1.2954242796E+00, 7.9310382617E-01],
	[1.9930000000E+04, 1.2116445131E+01, 5.5370965200E+00, 1.9670300097E+00, 1.2961541416E+00, 7.9320034459E-01],
	[1.9935000000E+04, 1.2120941670E+01, 5.5369481008E+00, 1.9686116849E+00, 1.2968840710E+00, 7.9329682537E-01],
	[1.9940000000E+04, 1.2125438749E+01, 5.5367997228E+00, 1.9701942341E+00, 1.2976140675E+00, 7.9339326850E-01],
	[1.9945000000E+04, 1.2129936369E+01, 5.5366513860E+00, 1.9717776573E+00, 1.2983441310E+00, 7.9348967400E-01],
	[1.9950000000E+04, 1.2134434529E+01, 5.5365030904E+00, 1.9733619550E+00, 1.2990742613E+00, 7.9358604186E-01],
	[1.9955000000E+04, 1.2138933229E+01, 5.5363548358E+00, 1.9749471274E+00, 1.2998044582E+00, 7.9368237210E-01],
	[1.9960000000E+04, 1.2143432470E+01, 5.5362066224E+00, 1.9765331747E+00, 1.3005347216E+00, 7.9377866470E-01],
	[1.9965000000E+04, 1.2147932250E+01, 5.5360584501E+00, 1.9781200972E+00, 1.3012650511E+00, 7.9387491968E-01],
	[1.9970000000E+04, 1.2152432571E+01, 5.5359103188E+00, 1.9797078952E+00, 1.3019954467E+00, 7.9397113705E-01],
	[1.9975000000E+04, 1.2156933431E+01, 5.5357622286E+00, 1.9812965689E+00, 1.3027259082E+00, 7.9406731679E-01],
	[1.9980000000E+04, 1.2161434832E+01, 5.5356141794E+00, 1.9828861185E+00, 1.3034564353E+00, 7.9416345892E-01],
	[1.9985000000E+04, 1.2165936772E+01, 5.5354661712E+00, 1.9844765445E+00, 1.3041870279E+00, 7.9425956343E-01],
	[1.9990000000E+04, 1.2170439252E+01, 5.5353182040E+00, 1.9860678469E+00, 1.3049176858E+00, 7.9435563034E-01],
	[1.9995000000E+04, 1.2174942271E+01, 5.5351702777E+00, 1.9876600261E+00, 1.3056484088E+00, 7.9445165964E-01],
	[2.0000000000E+04, 1.2179445830E+01, 5.5350223924E+00, 1.9892530824E+00, 1.3063791967E+00, 7.9454765135E-01],
	[2.0005000000E+04, 1.2183949929E+01, 5.5348745480E+00, 1.9908493521E+00, 1.3071110564E+00, 7.9464360545E-01],
	[2.0010000000E+04, 1.2188454567E+01, 5.5347267445E+00, 1.9924465026E+00, 1.3078429811E+00, 7.9473952196E-01],
	[2.0015000000E+04, 1.2192959744E+01, 5.5345789819E+00, 1.9940445342E+00, 1.3085749705E+00, 7.9483540088E-01],
	[2.0020000000E+04, 1.2197465461E+01, 5.5344312601E+00, 1.9956434472E+00, 1.3093070246E+00, 7.9493124220E-01],
	[2.0025000000E+04, 1.2201971717E+01, 5.5342835791E+00, 1.9972432418E+00, 1.3100391431E+00, 7.9502704595E-01],
	[2.0030000000E+04, 1.2206478512E+01, 5.5341359390E+00, 1.9988439183E+00, 1.3107713258E+00, 7.9512281211E-01],
	[2.0035000000E+04, 1.2210985846E+01, 5.5339883396E+00, 2.0004454770E+00, 1.3115035725E+00, 7.9521854070E-01],
	[2.0040000000E+04, 1.2215493719E+01, 5.5338407810E+00, 2.0020479181E+00, 1.3122358831E+00, 7.9531423171E-01],
	[2.0045000000E+04, 1.2220002132E+01, 5.5336932632E+00, 2.0036512419E+00, 1.3129682574E+00, 7.9540988515E-01],
	[2.0050000000E+04, 1.2224511083E+01, 5.5335457861E+00, 2.0052554486E+00, 1.3137006951E+00, 7.9550550103E-01],
	[2.0055000000E+04, 1.2229020572E+01, 5.5333983497E+00, 2.0068605386E+00, 1.3144331961E+00, 7.9560107934E-01],
	[2.0060000000E+04, 1.2233530601E+01, 5.5332509539E+00, 2.0084665120E+00, 1.3151657603E+00, 7.9569662009E-01],
	[2.0065000000E+04, 1.2238051570E+01, 5.5331061003E+00, 2.0100733692E+00, 1.3158986491E+00, 7.9579212328E-01],
	[2.0070000000E+04, 1.2242583982E+01, 5.5329639065E+00, 2.0116811104E+00, 1.3166318754E+00, 7.9588758892E-01],
	[2.0075000000E+04, 1.2247116942E+01, 5.5328217517E+00, 2.0132897359E+00, 1.3173651652E+00, 7.9598301702E-01],
	[2.0080000000E+04, 1.2251650451E+01, 5.5326796359E+00, 2.0148992459E+00, 1.3180985183E+00, 7.9607840757E-01],
	[2.0085000000E+04, 1.2256184509E+01, 5.5325375592E+00, 2.0165096408E+00, 1.3188319344E+00, 7.9617376057E-01],
	[2.0090000000E+04, 1.2260719116E+01, 5.5323955216E+00, 2.0181209207E+00, 1.3195654133E+00, 7.9626907604E-01],
	[2.0095000000E+04, 1.2265254271E+01, 5.5322535229E+00, 2.0197330860E+00, 1.3202989550E+00, 7.9636435398E-01],
	[2.0100000000E+04, 1.2269789975E+01, 5.5321115631E+00, 2.0213461368E+00, 1.3210325591E+00, 7.9645959439E-01],
	[2.0105000000E+04, 1.2274326228E+01, 5.5319696424E+00, 2.0229600736E+00, 1.3217662256E+00, 7.9655479727E-01],
	[2.0110000000E+04, 1.2278863029E+01, 5.5318277605E+00, 2.0245748965E+00, 1.3224999542E+00, 7.9664996262E-01],
	[2.0115000000E+04, 1.2283400378E+01, 5.5316859176E+00, 2.0261906057E+00, 1.3232337447E+00, 7.9674509046E-01],
	[2.0120000000E+04, 1.2287938276E+01, 5.5315441135E+00, 2.0278072017E+00, 1.3239675970E+00, 7.9684018079E-01],
	[2.0125000000E+04, 1.2292476722E+01, 5.5314023483E+00, 2.0294246846E+00, 1.3247015109E+00, 7.9693523360E-01],
	[2.0130000000E+04, 1.2297015716E+01, 5.5312606220E+00, 2.0310430547E+00, 1.3254354861E+00, 7.9703024891E-01],
	[2.0135000000E+04, 1.2301555259E+01, 5.5311189345E+00, 2.0326623122E+00, 1.3261695225E+00, 7.9712522671E-01],
	[2.0140000000E+04, 1.2306095349E+01, 5.5309772858E+00, 2.0342824575E+00, 1.3269036199E+00, 7.9722016702E-01],
	[2.0145000000E+04, 1.2310635987E+01, 5.5308356759E+00, 2.0359034908E+00, 1.3276377782E+00, 7.9731506983E-01],
	[2.0150000000E+04, 1.2315177174E+01, 5.5306941048E+00, 2.0375254124E+00, 1.3283719970E+00, 7.9740993515E-01],
	[2.0155000000E+04, 1.2319718908E+01, 5.5305525724E+00, 2.0391482225E+00, 1.3291062764E+00, 7.9750476299E-01],
	[2.0160000000E+04, 1.2324261190E+01, 5.5304110787E+00, 2.0407719213E+00, 1.3298406160E+00, 7.9759955334E-01],
	[2.0165000000E+04, 1.2328804019E+01, 5.5302696238E+00, 2.0423965093E+00, 1.3305750156E+00, 7.9769430621E-01],
	[2.0170000000E+04, 1.2333347397E+01, 5.5301282075E+00, 2.0440219865E+00, 1.3313094752E+00, 7.9778902161E-01],
	[2.0175000000E+04, 1.2337891321E+01, 5.5299868299E+00, 2.0456483534E+00, 1.3320439944E+00, 7.9788369954E-01],
	[2.0180000000E+04, 1.2342435794E+01, 5.5298454909E+00, 2.0472756101E+00, 1.3327785732E+00, 7.9797834000E-01],
	[2.0185000000E+04, 1.2346980813E+01, 5.5297041906E+00, 2.0489037569E+00, 1.3335132113E+00, 7.9807294300E-01],
	[2.0190000000E+04, 1.2351526380E+01, 5.5295629289E+00, 2.0505327941E+00, 1.3342479085E+00, 7.9816750855E-01],
	[2.0195000000E+04, 1.2356072495E+01, 5.5294217057E+00, 2.0521627220E+00, 1.3349826647E+00, 7.9826203664E-01],
	[2.0200000000E+04, 1.2360619156E+01, 5.5292805212E+00, 2.0537935408E+00, 1.3357174796E+00, 7.9835652728E-01],
	[2.0205000000E+04, 1.2365166365E+01, 5.5291393751E+00, 2.0554252508E+00, 1.3364523532E+00, 7.9845098048E-01],
	[2.0210000000E+04, 1.2369714120E+01, 5.5289982676E+00, 2.0570578522E+00, 1.3371872851E+00, 7.9854539623E-01],
	[2.0215000000E+04, 1.2374262423E+01, 5.5288571986E+00, 2.0586913453E+00, 1.3379222753E+00, 7.9863977455E-01],
	[2.0220000000E+04, 1.2378811273E+01, 5.5287161681E+00, 2.0603257304E+00, 1.3386573234E+00, 7.9873411544E-01],
	[2.0225000000E+04, 1.2383360669E+01, 5.5285751761E+00, 2.0619610078E+00, 1.3393924294E+00, 7.9882841890E-01],
	[2.0230000000E+04, 1.2387910613E+01, 5.5284342225E+00, 2.0635971777E+00, 1.3401275931E+00, 7.9892268494E-01],
	[2.0235000000E+04, 1.2392461103E+01, 5.5282933073E+00, 2.0652342403E+00, 1.3408628143E+00, 7.9901691356E-01],
	[2.0240000000E+04, 1.2397012139E+01, 5.5281524305E+00, 2.0668721960E+00, 1.3415980927E+00, 7.9911110477E-01],
	[2.0245000000E+04, 1.2401563723E+01, 5.5280115922E+00, 2.0685110451E+00, 1.3423334282E+00, 7.9920525856E-01],
	[2.0250000000E+04, 1.2406115853E+01, 5.5278707921E+00, 2.0701507877E+00, 1.3430688206E+00, 7.9929937496E-01],
	[2.0255000000E+04, 1.2410668529E+01, 5.5277300305E+00, 2.0717914241E+00, 1.3438042698E+00, 7.9939345395E-01],
	[2.0260000000E+04, 1.2415221751E+01, 5.5275893071E+00, 2.0734329546E+00, 1.3445397755E+00, 7.9948749554E-01],
	[2.0265000000E+04, 1.2419775520E+01, 5.5274486221E+00, 2.0750753795E+00, 1.3452753375E+00, 7.9958149974E-01],
	[2.0270000000E+04, 1.2424329836E+01, 5.5273079754E+00, 2.0767186991E+00, 1.3460109557E+00, 7.9967546656E-01],
	[2.0275000000E+04, 1.2428884697E+01, 5.5271673669E+00, 2.0783629136E+00, 1.3467466299E+00, 7.9976939599E-01],
	[2.0280000000E+04, 1.2433440104E+01, 5.5270267966E+00, 2.0800080232E+00, 1.3474823599E+00, 7.9986328805E-01],
	[2.0285000000E+04, 1.2437996058E+01, 5.5268862646E+00, 2.0816540283E+00, 1.3482181456E+00, 7.9995714273E-01],
	[2.0290000000E+04, 1.2442552557E+01, 5.5267457708E+00, 2.0833009290E+00, 1.3489539866E+00, 8.0005096005E-01],
	[2.0295000000E+04, 1.2447109603E+01, 5.5266053152E+00, 2.0849487258E+00, 1.3496898829E+00, 8.0014474000E-01],
	[2.0300000000E+04, 1.2451667194E+01, 5.5264648978E+00, 2.0865974187E+00, 1.3504258342E+00, 8.0023848259E-01],
	[2.0305000000E+04, 1.2456225331E+01, 5.5263245185E+00, 2.0882470082E+00, 1.3511618404E+00, 8.0033218783E-01],
	[2.0310000000E+04, 1.2460784013E+01, 5.5261841773E+00, 2.0898974945E+00, 1.3518979013E+00, 8.0042585572E-01],
	[2.0315000000E+04, 1.2465343241E+01, 5.5260438742E+00, 2.0915488777E+00, 1.3526340167E+00, 8.0051948626E-01],
	[2.0320000000E+04, 1.2469903015E+01, 5.5259036092E+00, 2.0932011583E+00, 1.3533701864E+00, 8.0061307946E-01],
	[2.0325000000E+04, 1.2474463334E+01, 5.5257633823E+00, 2.0948543365E+00, 1.3541064102E+00, 8.0070663533E-01],
	[2.0330000000E+04, 1.2479024199E+01, 5.5256231935E+00, 2.0965084124E+00, 1.3548426880E+00, 8.0080015387E-01],
	[2.0335000000E+04, 1.2483585609E+01, 5.5254830427E+00, 2.0981633865E+00, 1.3555790195E+00, 8.0089363508E-01],
	[2.0340000000E+04, 1.2488147564E+01, 5.5253429298E+00, 2.0998192589E+00, 1.3563154047E+00, 8.0098707898E-01],
	[2.0345000000E+04, 1.2492710065E+01, 5.5252028550E+00, 2.1014760300E+00, 1.3570518432E+00, 8.0108048555E-01],
	[2.0350000000E+04, 1.2497273110E+01, 5.5250628181E+00, 2.1031336999E+00, 1.3577883349E+00, 8.0117385482E-01],
	[2.0355000000E+04, 1.2501836701E+01, 5.5249228192E+00, 2.1047922691E+00, 1.3585248796E+00, 8.0126718678E-01],
	[2.0360000000E+04, 1.2506400837E+01, 5.5247828583E+00, 2.1064517376E+00, 1.3592614772E+00, 8.0136048144E-01],
	[2.0365000000E+04, 1.2510965517E+01, 5.5246429352E+00, 2.1081121058E+00, 1.3599981274E+00, 8.0145373880E-01],
	[2.0370000000E+04, 1.2515530743E+01, 5.5245030500E+00, 2.1097733740E+00, 1.3607348301E+00, 8.0154695888E-01],
	[2.0375000000E+04, 1.2520096513E+01, 5.5243632027E+00, 2.1114355425E+00, 1.3614715850E+00, 8.0164014166E-01],
	[2.0380000000E+04, 1.2524662828E+01, 5.5242233933E+00, 2.1130986114E+00, 1.3622083921E+00, 8.0173328717E-01],
	[2.0385000000E+04, 1.2529229687E+01, 5.5240836217E+00, 2.1147625811E+00, 1.3629452511E+00, 8.0182639540E-01],
	[2.0390000000E+04, 1.2533816303E+01, 5.5239483859E+00, 2.1164274517E+00, 1.3636826633E+00, 8.0191946636E-01],
	[2.0395000000E+04, 1.2538405789E+01, 5.5238137287E+00, 2.1180932237E+00, 1.3644201884E+00, 8.0201250006E-01],
	[2.0400000000E+04, 1.2542995830E+01, 5.5236791078E+00, 2.1197598973E+00, 1.3651577658E+00, 8.0210549649E-01],
	[2.0405000000E+04, 1.2547586426E+01, 5.5235445232E+00, 2.1214274726E+00, 1.3658953952E+00, 8.0219845567E-01],
	[2.0410000000E+04, 1.2552177576E+01, 5.5234099748E+00, 2.1230959501E+00, 1.3666330766E+00, 8.0229137760E-01],
	[2.0415000000E+04, 1.2556769282E+01, 5.5232754627E+00, 2.1247653299E+00, 1.3673708096E+00, 8.0238426229E-01],
	[2.0420000000E+04, 1.2561361541E+01, 5.5231409868E+00, 2.1264356123E+00, 1.3681085942E+00, 8.0247710973E-01],
	[2.0425000000E+04, 1.2565954356E+01, 5.5230065471E+00, 2.1281067977E+00, 1.3688464301E+00, 8.0256991995E-01],
	[2.0430000000E+04, 1.2570547725E+01, 5.5228721435E+00, 2.1297788861E+00, 1.3695843172E+00, 8.0266269293E-01],
	[2.0435000000E+04, 1.2575141648E+01, 5.5227377761E+00, 2.1314518780E+00, 1.3703222553E+00, 8.0275542869E-01],
	[2.0440000000E+04, 1.2579736126E+01, 5.5226034449E+00, 2.1331257736E+00, 1.3710602442E+00, 8.0284812723E-01],
	[2.0445000000E+04, 1.2584331157E+01, 5.5224691497E+00, 2.1348005731E+00, 1.3717982836E+00, 8.0294078856E-01],
	[2.0450000000E+04, 1.2588926743E+01, 5.5223348907E+00, 2.1364762769E+00, 1.3725363735E+00, 8.0303341267E-01],
	[2.0455000000E+04, 1.2593522884E+01, 5.5222006678E+00, 2.1381528851E+00, 1.3732745137E+00, 8.0312599959E-01],
	[2.0460000000E+04, 1.2598119578E+01, 5.5220664809E+00, 2.1398303981E+00, 1.3740127039E+00, 8.0321854931E-01],
	[2.0465000000E+04, 1.2602716826E+01, 5.5219323301E+00, 2.1415088161E+00, 1.3747509440E+00, 8.0331106184E-01],
	[2.0470000000E+04, 1.2607314628E+01, 5.5217982153E+00, 2.1431881394E+00, 1.3754892337E+00, 8.0340353718E-01],
	[2.0475000000E+04, 1.2611912985E+01, 5.5216641365E+00, 2.1448683683E+00, 1.3762275730E+00, 8.0349597535E-01],
	[2.0480000000E+04, 1.2616511894E+01, 5.5215300937E+00, 2.1465495029E+00, 1.3769659616E+00, 8.0358837633E-01],
	[2.0485000000E+04, 1.2621111358E+01, 5.5213960869E+00, 2.1482315437E+00, 1.3777043994E+00, 8.0368074015E-01],
	[2.0490000000E+04, 1.2625711375E+01, 5.5212621160E+00, 2.1499144907E+00, 1.3784428861E+00, 8.0377306680E-01],
	[2.0495000000E+04, 1.2630311946E+01, 5.5211281811E+00, 2.1515983445E+00, 1.3791814215E+00, 8.0386535630E-01],
	[2.0500000000E+04, 1.2634913070E+01, 5.5209942821E+00, 2.1532831051E+00, 1.3799200056E+00, 8.0395760864E-01],
	[2.0505000000E+04, 1.2639514748E+01, 5.5208604190E+00, 2.1549687728E+00, 1.3806586381E+00, 8.0404982383E-01],
	[2.0510000000E+04, 1.2644116979E+01, 5.5207265918E+00, 2.1566553480E+00, 1.3813973188E+00, 8.0414200188E-01],
	[2.0515000000E+04, 1.2648719764E+01, 5.5205928004E+00, 2.1583428308E+00, 1.3821360476E+00, 8.0423414280E-01],
	[2.0520000000E+04, 1.2653323102E+01, 5.5204590449E+00, 2.1600312216E+00, 1.3828748242E+00, 8.0432624658E-01],
	[2.0525000000E+04, 1.2657926993E+01, 5.5203253252E+00, 2.1617205206E+00, 1.3836136485E+00, 8.0441831324E-01],
	[2.0530000000E+04, 1.2662531437E+01, 5.5201916413E+00, 2.1634107281E+00, 1.3843525203E+00, 8.0451034278E-01],
	[2.0535000000E+04, 1.2667136434E+01, 5.5200579932E+00, 2.1651018443E+00, 1.3850914394E+00, 8.0460233521E-01],
	[2.0540000000E+04, 1.2671741984E+01, 5.5199243809E+00, 2.1667938696E+00, 1.3858304056E+00, 8.0469429052E-01],
	[2.0545000000E+04, 1.2676348087E+01, 5.5197908044E+00, 2.1684868041E+00, 1.3865694188E+00, 8.0478620874E-01],
	[2.0550000000E+04, 1.2680954743E+01, 5.5196572635E+00, 2.1701806482E+00, 1.3873084787E+00, 8.0487808986E-01],
	[2.0555000000E+04, 1.2685561951E+01, 5.5195237584E+00, 2.1718754021E+00, 1.3880475852E+00, 8.0496993389E-01],
	[2.0560000000E+04, 1.2690169712E+01, 5.5193902890E+00, 2.1735710661E+00, 1.3887867381E+00, 8.0506174083E-01],
	[2.0565000000E+04, 1.2694778026E+01, 5.5192568553E+00, 2.1752676404E+00, 1.3895259373E+00, 8.0515351070E-01],
	[2.0570000000E+04, 1.2699386893E+01, 5.5191234572E+00, 2.1769651253E+00, 1.3902651824E+00, 8.0524524349E-01],
	[2.0575000000E+04, 1.2703996312E+01, 5.5189900948E+00, 2.1786635211E+00, 1.3910044734E+00, 8.0533693921E-01],
	[2.0580000000E+04, 1.2708606283E+01, 5.5188567680E+00, 2.1803628281E+00, 1.3917438101E+00, 8.0542859787E-01],
	[2.0585000000E+04, 1.2713216807E+01, 5.5187234768E+00, 2.1820630465E+00, 1.3924831923E+00, 8.0552021947E-01],
	[2.0590000000E+04, 1.2717827883E+01, 5.5185902212E+00, 2.1837641766E+00, 1.3932226197E+00, 8.0561180397E-01],
	[2.0595000000E+04, 1.2722439511E+01, 5.5184570012E+00, 2.1854662186E+00, 1.3939620923E+00, 8.0570335138E-01],
	[2.0600000000E+04, 1.2727051692E+01, 5.5183238167E+00, 2.1871691728E+00, 1.3947016098E+00, 8.0579486170E-01],
	[2.0605000000E+04, 1.2731664424E+01, 5.5181906678E+00, 2.1888730395E+00, 1.3954411721E+00, 8.0588633494E-01],
	[2.0610000000E+04, 1.2736277709E+01, 5.5180575543E+00, 2.1905778190E+00, 1.3961807790E+00, 8.0597777111E-01],
	[2.0615000000E+04, 1.2740891545E+01, 5.5179244764E+00, 2.1922835115E+00, 1.3969204302E+00, 8.0606917021E-01],
	[2.0620000000E+04, 1.2745505934E+01, 5.5177914340E+00, 2.1939901172E+00, 1.3976601257E+00, 8.0616053225E-01],
	[2.0625000000E+04, 1.2750120874E+01, 5.5176584270E+00, 2.1956976365E+00, 1.3983998652E+00, 8.0625185724E-01],
	[2.0630000000E+04, 1.2754736366E+01, 5.5175254555E+00, 2.1974060696E+00, 1.3991396485E+00, 8.0634314518E-01],
	[2.0635000000E+04, 1.2759352409E+01, 5.5173925194E+00, 2.1991154168E+00, 1.3998794755E+00, 8.0643439608E-01],
	[2.0640000000E+04, 1.2763969005E+01, 5.5172596187E+00, 2.2008256784E+00, 1.4006193459E+00, 8.0652560995E-01],
	[2.0645000000E+04, 1.2768586152E+01, 5.5171267534E+00, 2.2025368546E+00, 1.4013592597E+00, 8.0661678679E-01],
	[2.0650000000E+04, 1.2773203850E+01, 5.5169939235E+00, 2.2042489456E+00, 1.4020992166E+00, 8.0670792661E-01],
	[2.0655000000E+04, 1.2777822099E+01, 5.5168611289E+00, 2.2059619518E+00, 1.4028392164E+00, 8.0679902941E-01],
	[2.0660000000E+04, 1.2782440900E+01, 5.5167283696E+00, 2.2076758734E+00, 1.4035792590E+00, 8.0689009521E-01],
	[2.0665000000E+04, 1.2787060253E+01, 5.5165956457E+00, 2.2093907107E+00, 1.4043193442E+00, 8.0698112401E-01],
	[2.0670000000E+04, 1.2791680156E+01, 5.5164629571E+00, 2.2111064640E+00, 1.4050594717E+00, 8.0707211582E-01],
	[2.0675000000E+04, 1.2796300611E+01, 5.5163303038E+00, 2.2128231334E+00, 1.4057996415E+00, 8.0716307064E-01],
	[2.0680000000E+04, 1.2800921617E+01, 5.5161976857E+00, 2.2145407194E+00, 1.4065398533E+00, 8.0725398848E-01],
	[2.0685000000E+04, 1.2805543173E+01, 5.5160651029E+00, 2.2162592221E+00, 1.4072801069E+00, 8.0734486934E-01],
	[2.0690000000E+04, 1.2810165281E+01, 5.5159325553E+00, 2.2179786418E+00, 1.4080204022E+00, 8.0743571324E-01],
	[2.0695000000E+04, 1.2814787940E+01, 5.5158000429E+00, 2.2196989788E+00, 1.4087607390E+00, 8.0752652018E-01],
	[2.0700000000E+04, 1.2819411149E+01, 5.5156675657E+00, 2.2214202334E+00, 1.4095011170E+00, 8.0761729017E-01],
	[2.0705000000E+04, 1.2824034909E+01, 5.5155351237E+00, 2.2231424057E+00, 1.4102415362E+00, 8.0770802322E-01],
	[2.0710000000E+04, 1.2828659220E+01, 5.5154027169E+00, 2.2248654962E+00, 1.4109819964E+00, 8.0779871932E-01],
	[2.0715000000E+04, 1.2833289656E+01, 5.5152716178E+00, 2.2265895050E+00, 1.4117226481E+00, 8.0788937849E-01],
	[2.0720000000E+04, 1.2837936805E+01, 5.5151442409E+00, 2.2283144324E+00, 1.4124637782E+00, 8.0798000074E-01],
	[2.0725000000E+04, 1.2842584515E+01, 5.5150168977E+00, 2.2300402788E+00, 1.4132049495E+00, 8.0807058607E-01],
	[2.0730000000E+04, 1.2847232785E+01, 5.5148895882E+00, 2.2317670442E+00, 1.4139461620E+00, 8.0816113449E-01],
	[2.0735000000E+04, 1.2851881617E+01, 5.5147623123E+00, 2.2334947291E+00, 1.4146874154E+00, 8.0825164601E-01],
	[2.0740000000E+04, 1.2856531009E+01, 5.5146350700E+00, 2.2352233337E+00, 1.4154287097E+00, 8.0834212062E-01],
	[2.0745000000E+04, 1.2861180962E+01, 5.5145078613E+00, 2.2369528582E+00, 1.4161700445E+00, 8.0843255835E-01],
	[2.0750000000E+04, 1.2865831475E+01, 5.5143806863E+00, 2.2386833030E+00, 1.4169114197E+00, 8.0852295920E-01],
	[2.0755000000E+04, 1.2870482549E+01, 5.5142535447E+00, 2.2404146683E+00, 1.4176528351E+00, 8.0861332317E-01],
	[2.0760000000E+04, 1.2875134183E+01, 5.5141264368E+00, 2.2421469543E+00, 1.4183942906E+00, 8.0870365027E-01],
	[2.0765000000E+04, 1.2879786378E+01, 5.5139993624E+00, 2.2438801613E+00, 1.4191357860E+00, 8.0879394051E-01],
	[2.0770000000E+04, 1.2884439133E+01, 5.5138723215E+00, 2.2456142896E+00, 1.4198773210E+00, 8.0888419390E-01],
	[2.0775000000E+04, 1.2889092448E+01, 5.5137453141E+00, 2.2473493395E+00, 1.4206188956E+00, 8.0897441044E-01],
	[2.0780000000E+04, 1.2893746324E+01, 5.5136183402E+00, 2.2490853112E+00, 1.4213605095E+00, 8.0906459014E-01],
	[2.0785000000E+04, 1.2898400759E+01, 5.5134913998E+00, 2.2508222050E+00, 1.4221021626E+00, 8.0915473300E-01],
	[2.0790000000E+04, 1.2903055755E+01, 5.5133644928E+00, 2.2525600211E+00, 1.4228438546E+00, 8.0924483904E-01],
	[2.0795000000E+04, 1.2907711310E+01, 5.5132376193E+00, 2.2542987599E+00, 1.4235855854E+00, 8.0933490826E-01],
	[2.0800000000E+04, 1.2912367426E+01, 5.5131107791E+00, 2.2560384216E+00, 1.4243273549E+00, 8.0942494067E-01],
	[2.0805000000E+04, 1.2917024101E+01, 5.5129839724E+00, 2.2577790064E+00, 1.4250691627E+00, 8.0951493628E-01],
	[2.0810000000E+04, 1.2921681336E+01, 5.5128571991E+00, 2.2595205147E+00, 1.4258110088E+00, 8.0960489509E-01],
	[2.0815000000E+04, 1.2926339131E+01, 5.5127304591E+00, 2.2612629466E+00, 1.4265528930E+00, 8.0969481710E-01],
	[2.0820000000E+04, 1.2930997486E+01, 5.5126037525E+00, 2.2630063026E+00, 1.4272948151E+00, 8.0978470234E-01],
	[2.0825000000E+04, 1.2935656400E+01, 5.5124770793E+00, 2.2647505827E+00, 1.4280367749E+00, 8.0987455080E-01],
	[2.0830000000E+04, 1.2940315873E+01, 5.5123504393E+00, 2.2664957874E+00, 1.4287787722E+00, 8.0996436250E-01],
	[2.0835000000E+04, 1.2944975906E+01, 5.5122238327E+00, 2.2682419168E+00, 1.4295208069E+00, 8.1005413743E-01],
	[2.0840000000E+04, 1.2949636499E+01, 5.5120972593E+00, 2.2699889712E+00, 1.4302628787E+00, 8.1014387561E-01],
	[2.0845000000E+04, 1.2954297650E+01, 5.5119707193E+00, 2.2717369510E+00, 1.4310049876E+00, 8.1023357704E-01],
	[2.0850000000E+04, 1.2958959361E+01, 5.5118442124E+00, 2.2734858563E+00, 1.4317471332E+00, 8.1032324174E-01],
	[2.0855000000E+04, 1.2963621631E+01, 5.5117177388E+00, 2.2752356874E+00, 1.4324893155E+00, 8.1041286970E-01],
	[2.0860000000E+04, 1.2968284460E+01, 5.5115912984E+00, 2.2769864447E+00, 1.4332315343E+00, 8.1050246094E-01],
	[2.0865000000E+04, 1.2972947848E+01, 5.5114648913E+00, 2.2787381283E+00, 1.4339737893E+00, 8.1059201547E-01],
	[2.0870000000E+04, 1.2977611796E+01, 5.5113385173E+00, 2.2804907385E+00, 1.4347160805E+00, 8.1068153328E-01],
	[2.0875000000E+04, 1.2982276302E+01, 5.5112121765E+00, 2.2822442757E+00, 1.4354584075E+00, 8.1077101440E-01],
	[2.0880000000E+04, 1.2986941366E+01, 5.5110858688E+00, 2.2839987400E+00, 1.4362007703E+00, 8.1086045882E-01],
	[2.0885000000E+04, 1.2991606990E+01, 5.5109595943E+00, 2.2857541318E+00, 1.4369431686E+00, 8.1094986655E-01],
	[2.0890000000E+04, 1.2996273172E+01, 5.5108333529E+00, 2.2875104513E+00, 1.4376856024E+00, 8.1103923761E-01],
	[2.0895000000E+04, 1.3000939913E+01, 5.5107071445E+00, 2.2892676987E+00, 1.4384280713E+00, 8.1112857199E-01],
	[2.0900000000E+04, 1.3005607213E+01, 5.5105809693E+00, 2.2910258744E+00, 1.4391705753E+00, 8.1121786971E-01],
	[2.0905000000E+04, 1.3010275071E+01, 5.5104548272E+00, 2.2927849786E+00, 1.4399131141E+00, 8.1130713078E-01],
	[2.0910000000E+04, 1.3014943488E+01, 5.5103287181E+00, 2.2945450116E+00, 1.4406556876E+00, 8.1139635519E-01],
	[2.0915000000E+04, 1.3019612462E+01, 5.5102026420E+00, 2.2963059736E+00, 1.4413982955E+00, 8.1148554297E-01],
	[2.0920000000E+04, 1.3024281996E+01, 5.5100765990E+00, 2.2980678649E+00, 1.4421409378E+00, 8.1157469411E-01],
	[2.0925000000E+04, 1.3028952087E+01, 5.5099505889E+00, 2.2998306858E+00, 1.4428836142E+00, 8.1166380862E-01],
	[2.0930000000E+04, 1.3033622737E+01, 5.5098246119E+00, 2.3015944366E+00, 1.4436263246E+00, 8.1175288652E-01],
	[2.0935000000E+04, 1.3038293944E+01, 5.5096986678E+00, 2.3033591174E+00, 1.4443690687E+00, 8.1184192781E-01],
	[2.0940000000E+04, 1.3042965710E+01, 5.5095727567E+00, 2.3051247287E+00, 1.4451118464E+00, 8.1193093249E-01],
	[2.0945000000E+04, 1.3047638034E+01, 5.5094468785E+00, 2.3068912706E+00, 1.4458546576E+00, 8.1201990058E-01],
	[2.0950000000E+04, 1.3052310915E+01, 5.5093210332E+00, 2.3086587434E+00, 1.4465975020E+00, 8.1210883208E-01],
	[2.0955000000E+04, 1.3056984355E+01, 5.5091952209E+00, 2.3104271474E+00, 1.4473403794E+00, 8.1219772700E-01],
	[2.0960000000E+04, 1.3061658352E+01, 5.5090694414E+00, 2.3121964828E+00, 1.4480832898E+00, 8.1228658535E-01],
	[2.0965000000E+04, 1.3066332907E+01, 5.5089436948E+00, 2.3139667500E+00, 1.4488262328E+00, 8.1237540713E-01],
	[2.0970000000E+04, 1.3071008019E+01, 5.5088179810E+00, 2.3157379492E+00, 1.4495692084E+00, 8.1246419236E-01],
	[2.0975000000E+04, 1.3075683689E+01, 5.5086923001E+00, 2.3175100806E+00, 1.4503122163E+00, 8.1255294104E-01],
	[2.0980000000E+04, 1.3080359917E+01, 5.5085666520E+00, 2.3192831445E+00, 1.4510552564E+00, 8.1264165317E-01],
	[2.0985000000E+04, 1.3085036702E+01, 5.5084410368E+00, 2.3210571412E+00, 1.4517983285E+00, 8.1273032878E-01],
	[2.0990000000E+04, 1.3089714044E+01, 5.5083154543E+00, 2.3228320710E+00, 1.4525414324E+00, 8.1281896785E-01],
	[2.0995000000E+04, 1.3094391944E+01, 5.5081899045E+00, 2.3246079341E+00, 1.4532845679E+00, 8.1290757042E-01],
	[2.1000000000E+04, 1.3099070401E+01, 5.5080643876E+00, 2.3263847308E+00, 1.4540277349E+00, 8.1299613647E-01],
	[2.1005000000E+04, 1.3103749415E+01, 5.5079389034E+00, 2.3281624614E+00, 1.4547709332E+00, 8.1308466601E-01],
	[2.1010000000E+04, 1.3108428986E+01, 5.5078134519E+00, 2.3299411261E+00, 1.4555141626E+00, 8.1317315907E-01],
	[2.1015000000E+04, 1.3113109114E+01, 5.5076880331E+00, 2.3317207251E+00, 1.4562574229E+00, 8.1326161564E-01],
	[2.1020000000E+04, 1.3117789799E+01, 5.5075626470E+00, 2.3335012589E+00, 1.4570007139E+00, 8.1335003573E-01],
	[2.1025000000E+04, 1.3122471041E+01, 5.5074372936E+00, 2.3352827276E+00, 1.4577440356E+00, 8.1343841935E-01],
	[2.1030000000E+04, 1.3127152840E+01, 5.5073119728E+00, 2.3370651315E+00, 1.4584873876E+00, 8.1352676650E-01],
	[2.1035000000E+04, 1.3131835196E+01, 5.5071866847E+00, 2.3388484708E+00, 1.4592307699E+00, 8.1361507721E-01],
	[2.1040000000E+04, 1.3136518108E+01, 5.5070614292E+00, 2.3406327459E+00, 1.4599741822E+00, 8.1370335146E-01],
	[2.1045000000E+04, 1.3141201577E+01, 5.5069362063E+00, 2.3424179570E+00, 1.4607176243E+00, 8.1379158928E-01],
	[2.1050000000E+04, 1.3145897979E+01, 5.5068137695E+00, 2.3442041043E+00, 1.4614614431E+00, 8.1387979067E-01],
	[2.1055000000E+04, 1.3150604512E+01, 5.5066934926E+00, 2.3459911882E+00, 1.4622055602E+00, 8.1396795563E-01],
	[2.1060000000E+04, 1.3155311612E+01, 5.5065732468E+00, 2.3477792090E+00, 1.4629497075E+00, 8.1405608418E-01],
	[2.1065000000E+04, 1.3160019279E+01, 5.5064530323E+00, 2.3495681667E+00, 1.4636938850E+00, 8.1414417633E-01],
	[2.1070000000E+04, 1.3164727513E+01, 5.5063328489E+00, 2.3513580619E+00, 1.4644380924E+00, 8.1423223207E-01],
	[2.1075000000E+04, 1.3169436313E+01, 5.5062126966E+00, 2.3531488946E+00, 1.4651823295E+00, 8.1432025143E-01],
	[2.1080000000E+04, 1.3174145680E+01, 5.5060925754E+00, 2.3549406652E+00, 1.4659265961E+00, 8.1440823440E-01],
	[2.1085000000E+04, 1.3178855613E+01, 5.5059724854E+00, 2.3567333740E+00, 1.4666708922E+00, 8.1449618100E-01],
	[2.1090000000E+04, 1.3183566113E+01, 5.5058524264E+00, 2.3585270211E+00, 1.4674152174E+00, 8.1458409123E-01],
	[2.1095000000E+04, 1.3188277180E+01, 5.5057323986E+00, 2.3603216070E+00, 1.4681595717E+00, 8.1467196511E-01],
	[2.1100000000E+04, 1.3192988812E+01, 5.5056124017E+00, 2.3621171318E+00, 1.4689039548E+00, 8.1475980263E-01],
	[2.1105000000E+04, 1.3197701011E+01, 5.5054924360E+00, 2.3639135958E+00, 1.4696483666E+00, 8.1484760381E-01],
	[2.1110000000E+04, 1.3202413777E+01, 5.5053725012E+00, 2.3657109993E+00, 1.4703928068E+00, 8.1493536866E-01],
	[2.1115000000E+04, 1.3207127108E+01, 5.5052525975E+00, 2.3675093426E+00, 1.4711372755E+00, 8.1502309719E-01],
	[2.1120000000E+04, 1.3211841006E+01, 5.5051327248E+00, 2.3693086259E+00, 1.4718817722E+00, 8.1511078939E-01],
	[2.1125000000E+04, 1.3216555469E+01, 5.5050128831E+00, 2.3711088495E+00, 1.4726262969E+00, 8.1519844529E-01],
	[2.1130000000E+04, 1.3221270499E+01, 5.5048930723E+00, 2.3729100136E+00, 1.4733708494E+00, 8.1528606489E-01],
	[2.1135000000E+04, 1.3225986095E+01, 5.5047732925E+00, 2.3747121186E+00, 1.4741154296E+00, 8.1537364820E-01],
	[2.1140000000E+04, 1.3230702256E+01, 5.5046535436E+00, 2.3765151647E+00, 1.4748600371E+00, 8.1546119522E-01],
	[2.1145000000E+04, 1.3235418983E+01, 5.5045338257E+00, 2.3783191521E+00, 1.4756046720E+00, 8.1554870596E-01],
	[2.1150000000E+04, 1.3240136276E+01, 5.5044141386E+00, 2.3801240811E+00, 1.4763493339E+00, 8.1563618044E-01],
	[2.1155000000E+04, 1.3244854135E+01, 5.5042944825E+00, 2.3819299521E+00, 1.4770940228E+00, 8.1572361866E-01],
	[2.1160000000E+04, 1.3249572559E+01, 5.5041748572E+00, 2.3837367652E+00, 1.4778387384E+00, 8.1581102063E-01],
	[2.1165000000E+04, 1.3254291548E+01, 5.5040552628E+00, 2.3855445208E+00, 1.4785834805E+00, 8.1589838635E-01],
	[2.1170000000E+04, 1.3259011103E+01, 5.5039356992E+00, 2.3873532191E+00, 1.4793282491E+00, 8.1598571584E-01],
	[2.1175000000E+04, 1.3263731224E+01, 5.5038161665E+00, 2.3891628603E+00, 1.4800730438E+00, 8.1607300911E-01],
	[2.1180000000E+04, 1.3268451910E+01, 5.5036966646E+00, 2.3909734448E+00, 1.4808178646E+00, 8.1616026615E-01],
	[2.1185000000E+04, 1.3273173161E+01, 5.5035771935E+00, 2.3927849727E+00, 1.4815627113E+00, 8.1624748699E-01],
	[2.1190000000E+04, 1.3277894977E+01, 5.5034577531E+00, 2.3945974445E+00, 1.4823075836E+00, 8.1633467163E-01],
	[2.1195000000E+04, 1.3282617358E+01, 5.5033383436E+00, 2.3964108603E+00, 1.4830524815E+00, 8.1642182008E-01],
	[2.1200000000E+04, 1.3287340305E+01, 5.5032189648E+00, 2.3982252204E+00, 1.4837974047E+00, 8.1650893234E-01],
	[2.1205000000E+04, 1.3292063816E+01, 5.5030996167E+00, 2.4000405251E+00, 1.4845423531E+00, 8.1659600842E-01],
	[2.1210000000E+04, 1.3296787892E+01, 5.5029802994E+00, 2.4018567747E+00, 1.4852873264E+00, 8.1668304834E-01],
	[2.1215000000E+04, 1.3301512533E+01, 5.5028610128E+00, 2.4036739693E+00, 1.4860323246E+00, 8.1677005210E-01],
	[2.1220000000E+04, 1.3306237739E+01, 5.5027417569E+00, 2.4054921094E+00, 1.4867773474E+00, 8.1685701971E-01],
	[2.1225000000E+04, 1.3310963510E+01, 5.5026225316E+00, 2.4073111951E+00, 1.4875223947E+00, 8.1694395118E-01],
	[2.1230000000E+04, 1.3315689845E+01, 5.5025033370E+00, 2.4091312267E+00, 1.4882674663E+00, 8.1703084651E-01],
	[2.1235000000E+04, 1.3320416745E+01, 5.5023841731E+00, 2.4109522046E+00, 1.4890125619E+00, 8.1711770573E-01],
	[2.1240000000E+04, 1.3325144210E+01, 5.5022650398E+00, 2.4127741288E+00, 1.4897576816E+00, 8.1720452882E-01],
	[2.1245000000E+04, 1.3329872239E+01, 5.5021459371E+00, 2.4145969999E+00, 1.4905028250E+00, 8.1729131581E-01],
	[2.1250000000E+04, 1.3334600832E+01, 5.5020268651E+00, 2.4164208179E+00, 1.4912479919E+00, 8.1737806670E-01],
	[2.1255000000E+04, 1.3339329990E+01, 5.5019078236E+00, 2.4182455831E+00, 1.4919931823E+00, 8.1746478149E-01],
	[2.1260000000E+04, 1.3344059712E+01, 5.5017888127E+00, 2.4200712959E+00, 1.4927383960E+00, 8.1755146021E-01],
	[2.1265000000E+04, 1.3348789998E+01, 5.5016698323E+00, 2.4218979565E+00, 1.4934836327E+00, 8.1763810285E-01],
	[2.1270000000E+04, 1.3353520848E+01, 5.5015508825E+00, 2.4237255652E+00, 1.4942288923E+00, 8.1772470943E-01],
	[2.1275000000E+04, 1.3358252262E+01, 5.5014319632E+00, 2.4255541222E+00, 1.4949741747E+00, 8.1781127996E-01],
	[2.1280000000E+04, 1.3362984241E+01, 5.5013130745E+00, 2.4273836278E+00, 1.4957194795E+00, 8.1789781443E-01],
	[2.1285000000E+04, 1.3367716783E+01, 5.5011942162E+00, 2.4292140823E+00, 1.4964648068E+00, 8.1798431287E-01],
	[2.1290000000E+04, 1.3372449889E+01, 5.5010753884E+00, 2.4310454860E+00, 1.4972101563E+00, 8.1807077528E-01],
	[2.1295000000E+04, 1.3377183559E+01, 5.5009565911E+00, 2.4328778390E+00, 1.4979555277E+00, 8.1815720166E-01],
	[2.1300000000E+04, 1.3381917793E+01, 5.5008378243E+00, 2.4347111417E+00, 1.4987009211E+00, 8.1824359204E-01],
	[2.1305000000E+04, 1.3386652590E+01, 5.5007190879E+00, 2.4365453944E+00, 1.4994463361E+00, 8.1832994640E-01],
	[2.1310000000E+04, 1.3391387951E+01, 5.5006003819E+00, 2.4383805973E+00, 1.5001917726E+00, 8.1841626478E-01],
	[2.1315000000E+04, 1.3396123876E+01, 5.5004817063E+00, 2.4402167507E+00, 1.5009372305E+00, 8.1850254717E-01],
	[2.1320000000E+04, 1.3400860364E+01, 5.5003630611E+00, 2.4420538548E+00, 1.5016827095E+00, 8.1858879358E-01],
	[2.1325000000E+04, 1.3405597416E+01, 5.5002444463E+00, 2.4438919100E+00, 1.5024282095E+00, 8.1867500402E-01],
	[2.1330000000E+04, 1.3410335030E+01, 5.5001258619E+00, 2.4457309165E+00, 1.5031737303E+00, 8.1876117850E-01],
	[2.1335000000E+04, 1.3415073208E+01, 5.5000073078E+00, 2.4475708745E+00, 1.5039192718E+00, 8.1884731703E-01],
	[2.1340000000E+04, 1.3419811950E+01, 5.4998887840E+00, 2.4494117843E+00, 1.5046648337E+00, 8.1893341962E-01],
	[2.1345000000E+04, 1.3424551254E+01, 5.4997702906E+00, 2.4512536462E+00, 1.5054104159E+00, 8.1901948628E-01],
	[2.1350000000E+04, 1.3429291122E+01, 5.4996518275E+00, 2.4530964605E+00, 1.5061560182E+00, 8.1910551701E-01],
	[2.1355000000E+04, 1.3434031553E+01, 5.4995333946E+00, 2.4549402275E+00, 1.5069016405E+00, 8.1919151182E-01],
	[2.1360000000E+04, 1.3438772546E+01, 5.4994149921E+00, 2.4567849473E+00, 1.5076472825E+00, 8.1927747073E-01],
	[2.1365000000E+04, 1.3443514103E+01, 5.4992966198E+00, 2.4586306203E+00, 1.5083929442E+00, 8.1936339373E-01],
	[2.1370000000E+04, 1.3448256222E+01, 5.4991782777E+00, 2.4604772468E+00, 1.5091386252E+00, 8.1944928085E-01],
	[2.1375000000E+04, 1.3452998904E+01, 5.4990599659E+00, 2.4623248270E+00, 1.5098843256E+00, 8.1953513209E-01],
	[2.1380000000E+04, 1.3457742149E+01, 5.4989416843E+00, 2.4641733611E+00, 1.5106300450E+00, 8.1962094746E-01],
	[2.1385000000E+04, 1.3462485956E+01, 5.4988234329E+00, 2.4660228495E+00, 1.5113757833E+00, 8.1970672696E-01],
	[2.1390000000E+04, 1.3467248006E+01, 5.4987090450E+00, 2.4678732924E+00, 1.5121220531E+00, 8.1979247061E-01],
	[2.1395000000E+04, 1.3472015107E+01, 5.4985956575E+00, 2.4697246901E+00, 1.5128684723E+00, 8.1987817842E-01],
	[2.1400000000E+04, 1.3476782781E+01, 5.4984822988E+00, 2.4715770428E+00, 1.5136149108E+00, 8.1996385039E-01],
	[2.1405000000E+04, 1.3481551027E+01, 5.4983689689E+00, 2.4734303509E+00, 1.5143613685E+00, 8.2004948653E-01],
	[2.1410000000E+04, 1.3486319847E+01, 5.4982556678E+00, 2.4752846145E+00, 1.5151078451E+00, 8.2013508686E-01],
	[2.1415000000E+04, 1.3491089239E+01, 5.4981423955E+00, 2.4771398341E+00, 1.5158543406E+00, 8.2022065137E-01],
	[2.1420000000E+04, 1.3495859204E+01, 5.4980291520E+00, 2.4789960097E+00, 1.5166008547E+00, 8.2030618009E-01],
	[2.1425000000E+04, 1.3500629742E+01, 5.4979159373E+00, 2.4808531417E+00, 1.5173473872E+00, 8.2039167301E-01],
	[2.1430000000E+04, 1.3505400852E+01, 5.4978027513E+00, 2.4827112304E+00, 1.5180939381E+00, 8.2047713009E-01],
	[2.1435000000E+04, 1.3510172535E+01, 5.4976895940E+00, 2.4845702761E+00, 1.5188405071E+00, 8.2056255134E-01],
	[2.1440000000E+04, 1.3514944790E+01, 5.4975764654E+00, 2.4864302789E+00, 1.5195870940E+00, 8.2064793677E-01],
	[2.1445000000E+04, 1.3519717617E+01, 5.4974633656E+00, 2.4882912392E+00, 1.5203336988E+00, 8.2073328637E-01],
	[2.1450000000E+04, 1.3524491016E+01, 5.4973502944E+00, 2.4901531573E+00, 1.5210803211E+00, 8.2081860016E-01],
	[2.1455000000E+04, 1.3529264988E+01, 5.4972372520E+00, 2.4920160334E+00, 1.5218269609E+00, 8.2090387814E-01],
	[2.1460000000E+04, 1.3534039532E+01, 5.4971242382E+00, 2.4938798677E+00, 1.5225736179E+00, 8.2098912031E-01],
	[2.1465000000E+04, 1.3538814648E+01, 5.4970112530E+00, 2.4957446606E+00, 1.5233202921E+00, 8.2107432669E-01],
	[2.1470000000E+04, 1.3543590336E+01, 5.4968982965E+00, 2.4976104123E+00, 1.5240669832E+00, 8.2115949728E-01],
	[2.1475000000E+04, 1.3548366596E+01, 5.4967853686E+00, 2.4994771231E+00, 1.5248136910E+00, 8.2124463209E-01],
	[2.1480000000E+04, 1.3553143428E+01, 5.4966724693E+00, 2.5013447932E+00, 1.5255604154E+00, 8.2132973111E-01],
	[2.1485000000E+04, 1.3557920831E+01, 5.4965595986E+00, 2.5032134230E+00, 1.5263071562E+00, 8.2141479436E-01],
	[2.1490000000E+04, 1.3562698807E+01, 5.4964467565E+00, 2.5050830127E+00, 1.5270539133E+00, 8.2149982185E-01],
	[2.1495000000E+04, 1.3567477354E+01, 5.4963339430E+00, 2.5069535625E+00, 1.5278006864E+00, 8.2158481358E-01],
	[2.1500000000E+04, 1.3572256472E+01, 5.4962211580E+00, 2.5088250728E+00, 1.5285474755E+00, 8.2166976955E-01],
	[2.1505000000E+04, 1.3577036162E+01, 5.4961084015E+00, 2.5106975437E+00, 1.5292942803E+00, 8.2175468978E-01],
	[2.1510000000E+04, 1.3581816424E+01, 5.4959956736E+00, 2.5125709756E+00, 1.5300411006E+00, 8.2183957427E-01],
	[2.1515000000E+04, 1.3586597257E+01, 5.4958829742E+00, 2.5144453688E+00, 1.5307879363E+00, 8.2192442302E-01],
	[2.1520000000E+04, 1.3591378662E+01, 5.4957703033E+00, 2.5163207235E+00, 1.5315347872E+00, 8.2200923604E-01],
	[2.1525000000E+04, 1.3596160638E+01, 5.4956576609E+00, 2.5181970399E+00, 1.5322816532E+00, 8.2209401334E-01],
	[2.1530000000E+04, 1.3600943185E+01, 5.4955450469E+00, 2.5200743184E+00, 1.5330285341E+00, 8.2217875493E-01],
	[2.1535000000E+04, 1.3605726303E+01, 5.4954324614E+00, 2.5219525592E+00, 1.5337754297E+00, 8.2226346081E-01],
	[2.1540000000E+04, 1.3610509992E+01, 5.4953199043E+00, 2.5238317626E+00, 1.5345223398E+00, 8.2234813098E-01],
	[2.1545000000E+04, 1.3615294252E+01, 5.4952073757E+00, 2.5257119288E+00, 1.5352692643E+00, 8.2243276546E-01],
	[2.1550000000E+04, 1.3620079084E+01, 5.4950948755E+00, 2.5275930582E+00, 1.5360162029E+00, 8.2251736425E-01],
	[2.1555000000E+04, 1.3624864486E+01, 5.4949824037E+00, 2.5294751509E+00, 1.5367631556E+00, 8.2260192735E-01],
	[2.1560000000E+04, 1.3629650459E+01, 5.4948699602E+00, 2.5313582073E+00, 1.5375101222E+00, 8.2268645478E-01],
	[2.1565000000E+04, 1.3634437003E+01, 5.4947575452E+00, 2.5332422277E+00, 1.5382571024E+00, 8.2277094654E-01],
	[2.1570000000E+04, 1.3639224117E+01, 5.4946451585E+00, 2.5351272122E+00, 1.5390040962E+00, 8.2285540263E-01],
	[2.1575000000E+04, 1.3644011802E+01, 5.4945328001E+00, 2.5370131612E+00, 1.5397511033E+00, 8.2293982307E-01],
	[2.1580000000E+04, 1.3648800058E+01, 5.4944204701E+00, 2.5389000749E+00, 1.5404981236E+00, 8.2302420785E-01],
	[2.1585000000E+04, 1.3653588885E+01, 5.4943081684E+00, 2.5407879537E+00, 1.5412451569E+00, 8.2310855699E-01],
	[2.1590000000E+04, 1.3658378281E+01, 5.4941958951E+00, 2.5426767977E+00, 1.5419922030E+00, 8.2319287050E-01],
	[2.1595000000E+04, 1.3663168248E+01, 5.4940836500E+00, 2.5445666072E+00, 1.5427392618E+00, 8.2327714837E-01],
	[2.1600000000E+04, 1.3667958786E+01, 5.4939714331E+00, 2.5464573826E+00, 1.5434863331E+00, 8.2336139062E-01],
	[2.1605000000E+04, 1.3672749894E+01, 5.4938592446E+00, 2.5483491241E+00, 1.5442334167E+00, 8.2344559725E-01],
	[2.1610000000E+04, 1.3677541572E+01, 5.4937470843E+00, 2.5502418319E+00, 1.5449805125E+00, 8.2352976827E-01],
	[2.1615000000E+04, 1.3682333820E+01, 5.4936349522E+00, 2.5521355063E+00, 1.5457276203E+00, 8.2361390369E-01],
	[2.1620000000E+04, 1.3687126638E+01, 5.4935228484E+00, 2.5540301476E+00, 1.5464747399E+00, 8.2369800351E-01],
	[2.1625000000E+04, 1.3691920026E+01, 5.4934107727E+00, 2.5559257561E+00, 1.5472218712E+00, 8.2378206773E-01],
	[2.1630000000E+04, 1.3696713984E+01, 5.4932987253E+00, 2.5578223320E+00, 1.5479690139E+00, 8.2386609638E-01],
	[2.1635000000E+04, 1.3701508512E+01, 5.4931867060E+00, 2.5597198756E+00, 1.5487161680E+00, 8.2395008944E-01],
	[2.1640000000E+04, 1.3706303610E+01, 5.4930747150E+00, 2.5616183871E+00, 1.5494633332E+00, 8.2403404694E-01],
	[2.1645000000E+04, 1.3711099278E+01, 5.4929627520E+00, 2.5635178669E+00, 1.5502105094E+00, 8.2411796887E-01],
	[2.1650000000E+04, 1.3715895515E+01, 5.4928508172E+00, 2.5654183153E+00, 1.5509576964E+00, 8.2420185525E-01],
	[2.1655000000E+04, 1.3720692322E+01, 5.4927389106E+00, 2.5673197323E+00, 1.5517048940E+00, 8.2428570607E-01],
	[2.1660000000E+04, 1.3725489699E+01, 5.4926270320E+00, 2.5692221185E+00, 1.5524521021E+00, 8.2436952136E-01],
	[2.1665000000E+04, 1.3730287645E+01, 5.4925151816E+00, 2.5711254739E+00, 1.5531993205E+00, 8.2445330110E-01],
	[2.1670000000E+04, 1.3735086160E+01, 5.4924033592E+00, 2.5730297989E+00, 1.5539465491E+00, 8.2453704532E-01],
	[2.1675000000E+04, 1.3739885245E+01, 5.4922915649E+00, 2.5749350938E+00, 1.5546937876E+00, 8.2462075402E-01],
	[2.1680000000E+04, 1.3744684899E+01, 5.4921797987E+00, 2.5768413588E+00, 1.5554410359E+00, 8.2470442719E-01],
	[2.1685000000E+04, 1.3749485122E+01, 5.4920680605E+00, 2.5787485942E+00, 1.5561882939E+00, 8.2478806486E-01],
	[2.1690000000E+04, 1.3754285915E+01, 5.4919563504E+00, 2.5806568003E+00, 1.5569355613E+00, 8.2487166703E-01],
	[2.1695000000E+04, 1.3759087276E+01, 5.4918446683E+00, 2.5825659773E+00, 1.5576828380E+00, 8.2495523371E-01],
	[2.1700000000E+04, 1.3763889207E+01, 5.4917330142E+00, 2.5844761254E+00, 1.5584301238E+00, 8.2503876489E-01],
	[2.1705000000E+04, 1.3768691707E+01, 5.4916213880E+00, 2.5863872451E+00, 1.5591774186E+00, 8.2512226060E-01],
	[2.1710000000E+04, 1.3773494775E+01, 5.4915097899E+00, 2.5882993365E+00, 1.5599247222E+00, 8.2520572083E-01],
	[2.1715000000E+04, 1.3778298413E+01, 5.4913982197E+00, 2.5902123999E+00, 1.5606720344E+00, 8.2528914560E-01],
	[2.1720000000E+04, 1.3783102619E+01, 5.4912866775E+00, 2.5921264356E+00, 1.5614193550E+00, 8.2537253491E-01],
	[2.1725000000E+04, 1.3787907394E+01, 5.4911751632E+00, 2.5940414438E+00, 1.5621666840E+00, 8.2545588876E-01],
	[2.1730000000E+04, 1.3792712738E+01, 5.4910636768E+00, 2.5959574249E+00, 1.5629140210E+00, 8.2553920717E-01],
	[2.1735000000E+04, 1.3797539703E+01, 5.4909566671E+00, 2.5978743790E+00, 1.5636619972E+00, 8.2562249014E-01],
	[2.1740000000E+04, 1.3802368573E+01, 5.4908499644E+00, 2.5997923065E+00, 1.5644100218E+00, 8.2570573768E-01],
	[2.1745000000E+04, 1.3807198023E+01, 5.4907432883E+00, 2.6017112076E+00, 1.5651580551E+00, 8.2578894980E-01],
	[2.1750000000E+04, 1.3812028051E+01, 5.4906366388E+00, 2.6036310826E+00, 1.5659060967E+00, 8.2587212650E-01],
	[2.1755000000E+04, 1.3816858659E+01, 5.4905300159E+00, 2.6055519318E+00, 1.5666541465E+00, 8.2595526779E-01],
	[2.1760000000E+04, 1.3821689845E+01, 5.4904234195E+00, 2.6074737554E+00, 1.5674022044E+00, 8.2603837368E-01],
	[2.1765000000E+04, 1.3826521609E+01, 5.4903168498E+00, 2.6093965537E+00, 1.5681502702E+00, 8.2612144418E-01],
	[2.1770000000E+04, 1.3831353953E+01, 5.4902103065E+00, 2.6113203270E+00, 1.5688983437E+00, 8.2620447928E-01],
	[2.1775000000E+04, 1.3836186875E+01, 5.4901037899E+00, 2.6132450756E+00, 1.5696464248E+00, 8.2628747901E-01],
	[2.1780000000E+04, 1.3841020375E+01, 5.4899972997E+00, 2.6151707996E+00, 1.5703945133E+00, 8.2637044336E-01],
	[2.1785000000E+04, 1.3845854454E+01, 5.4898908360E+00, 2.6170974994E+00, 1.5711426090E+00, 8.2645337235E-01],
	[2.1790000000E+04, 1.3850689111E+01, 5.4897843989E+00, 2.6190251753E+00, 1.5718907117E+00, 8.2653626598E-01],
	[2.1795000000E+04, 1.3855524347E+01, 5.4896779882E+00, 2.6209538275E+00, 1.5726388214E+00, 8.2661912426E-01],
	[2.1800000000E+04, 1.3860360161E+01, 5.4895716040E+00, 2.6228834563E+00, 1.5733869378E+00, 8.2670194719E-01],
	[2.1805000000E+04, 1.3865196553E+01, 5.4894652462E+00, 2.6248140620E+00, 1.5741350607E+00, 8.2678473479E-01],
	[2.1810000000E+04, 1.3870033523E+01, 5.4893589149E+00, 2.6267456448E+00, 1.5748831900E+00, 8.2686748706E-01],
	[2.1815000000E+04, 1.3874871072E+01, 5.4892526100E+00, 2.6286782050E+00, 1.5756313256E+00, 8.2695020401E-01],
	[2.1820000000E+04, 1.3879709198E+01, 5.4891463316E+00, 2.6306117429E+00, 1.5763794673E+00, 8.2703288564E-01],
	[2.1825000000E+04, 1.3884547902E+01, 5.4890400795E+00, 2.6325462587E+00, 1.5771276148E+00, 8.2711553197E-01],
	[2.1830000000E+04, 1.3889387184E+01, 5.4889338539E+00, 2.6344817527E+00, 1.5778757681E+00, 8.2719814300E-01],
	[2.1835000000E+04, 1.3894227044E+01, 5.4888276546E+00, 2.6364182252E+00, 1.5786239269E+00, 8.2728071873E-01],
	[2.1840000000E+04, 1.3899067482E+01, 5.4887214817E+00, 2.6383556764E+00, 1.5793720911E+00, 8.2736325919E-01],
	[2.1845000000E+04, 1.3903908497E+01, 5.4886153352E+00, 2.6402941067E+00, 1.5801202606E+00, 8.2744576436E-01],
	[2.1850000000E+04, 1.3908750090E+01, 5.4885092150E+00, 2.6422335163E+00, 1.5808684351E+00, 8.2752823427E-01],
	[2.1855000000E+04, 1.3913592261E+01, 5.4884031211E+00, 2.6441739054E+00, 1.5816166146E+00, 8.2761066891E-01],
	[2.1860000000E+04, 1.3918435009E+01, 5.4882970536E+00, 2.6461152744E+00, 1.5823647988E+00, 8.2769306830E-01],
	[2.1865000000E+04, 1.3923278334E+01, 5.4881910123E+00, 2.6480576234E+00, 1.5831129875E+00, 8.2777543245E-01],
	[2.1870000000E+04, 1.3928122237E+01, 5.4880849974E+00, 2.6500009528E+00, 1.5838611807E+00, 8.2785776135E-01],
	[2.1875000000E+04, 1.3932966717E+01, 5.4879790087E+00, 2.6519452629E+00, 1.5846093781E+00, 8.2794005503E-01],
	[2.1880000000E+04, 1.3937811775E+01, 5.4878730463E+00, 2.6538905539E+00, 1.5853575796E+00, 8.2802231348E-01],
	[2.1885000000E+04, 1.3942657410E+01, 5.4877671102E+00, 2.6558368260E+00, 1.5861057850E+00, 8.2810453671E-01],
	[2.1890000000E+04, 1.3947503621E+01, 5.4876612003E+00, 2.6577840796E+00, 1.5868539942E+00, 8.2818672474E-01],
	[2.1895000000E+04, 1.3952350410E+01, 5.4875553166E+00, 2.6597323150E+00, 1.5876022069E+00, 8.2826887756E-01],
	[2.1900000000E+04, 1.3957197776E+01, 5.4874494592E+00, 2.6616815323E+00, 1.5883504230E+00, 8.2835099520E-01],
	[2.1905000000E+04, 1.3962045719E+01, 5.4873436280E+00, 2.6636317318E+00, 1.5890986424E+00, 8.2843307765E-01],
	[2.1910000000E+04, 1.3966894238E+01, 5.4872378229E+00, 2.6655829139E+00, 1.5898468649E+00, 8.2851512492E-01],
	[2.1915000000E+04, 1.3971743335E+01, 5.4871320441E+00, 2.6675350788E+00, 1.5905950904E+00, 8.2859713702E-01],
	[2.1920000000E+04, 1.3976593008E+01, 5.4870262914E+00, 2.6694882268E+00, 1.5913433185E+00, 8.2867911395E-01],
	[2.1925000000E+04, 1.3981443257E+01, 5.4869205649E+00, 2.6714423581E+00, 1.5920915493E+00, 8.2876105574E-01],
	[2.1930000000E+04, 1.3986294084E+01, 5.4868148645E+00, 2.6733974731E+00, 1.5928397825E+00, 8.2884296238E-01],
	[2.1935000000E+04, 1.3991145487E+01, 5.4867091902E+00, 2.6753535719E+00, 1.5935880180E+00, 8.2892483388E-01],
	[2.1940000000E+04, 1.3995997466E+01, 5.4866035421E+00, 2.6773106548E+00, 1.5943362556E+00, 8.2900667025E-01],
	[2.1945000000E+04, 1.4000850022E+01, 5.4864979201E+00, 2.6792687222E+00, 1.5950844951E+00, 8.2908847149E-01],
	[2.1950000000E+04, 1.4005703155E+01, 5.4863923241E+00, 2.6812277742E+00, 1.5958327364E+00, 8.2917023762E-01],
	[2.1955000000E+04, 1.4010556863E+01, 5.4862867543E+00, 2.6831878113E+00, 1.5965809793E+00, 8.2925196865E-01],
	[2.1960000000E+04, 1.4015411148E+01, 5.4861812105E+00, 2.6851488335E+00, 1.5973292236E+00, 8.2933366457E-01],
	[2.1965000000E+04, 1.4020266009E+01, 5.4860756928E+00, 2.6871108413E+00, 1.5980774693E+00, 8.2941532540E-01],
	[2.1970000000E+04, 1.4025121446E+01, 5.4859702011E+00, 2.6890738348E+00, 1.5988257160E+00, 8.2949695115E-01],
	[2.1975000000E+04, 1.4029977459E+01, 5.4858647355E+00, 2.6910378144E+00, 1.5995739637E+00, 8.2957854183E-01],
	[2.1980000000E+04, 1.4034834048E+01, 5.4857592958E+00, 2.6930027802E+00, 1.6003222122E+00, 8.2966009743E-01],
	[2.1985000000E+04, 1.4039691213E+01, 5.4856538822E+00, 2.6949687327E+00, 1.6010704613E+00, 8.2974161798E-01],
	[2.1990000000E+04, 1.4044548954E+01, 5.4855484946E+00, 2.6969356720E+00, 1.6018187109E+00, 8.2982310348E-01],
	[2.1995000000E+04, 1.4049407271E+01, 5.4854431330E+00, 2.6989035984E+00, 1.6025669608E+00, 8.2990455393E-01],
	[2.2000000000E+04, 1.4054266163E+01, 5.4853377973E+00, 2.7008725123E+00, 1.6033152108E+00, 8.2998596934E-01],
	[2.2005000000E+04, 1.4059125631E+01, 5.4852324876E+00, 2.7028424137E+00, 1.6040634609E+00, 8.3006734973E-01],
	[2.2010000000E+04, 1.4063985675E+01, 5.4851272039E+00, 2.7048133032E+00, 1.6048117107E+00, 8.3014869510E-01],
	[2.2015000000E+04, 1.4068846295E+01, 5.4850219461E+00, 2.7067851808E+00, 1.6055599601E+00, 8.3023000546E-01],
	[2.2020000000E+04, 1.4073707489E+01, 5.4849167142E+00, 2.7087580469E+00, 1.6063082091E+00, 8.3031128081E-01],
	[2.2025000000E+04, 1.4078569259E+01, 5.4848115082E+00, 2.7107319017E+00, 1.6070564574E+00, 8.3039252117E-01],
	[2.2030000000E+04, 1.4083431605E+01, 5.4847063281E+00, 2.7127067455E+00, 1.6078047048E+00, 8.3047372654E-01],
	[2.2035000000E+04, 1.4088294526E+01, 5.4846011739E+00, 2.7146825787E+00, 1.6085529512E+00, 8.3055489694E-01],
	[2.2040000000E+04, 1.4093158022E+01, 5.4844960455E+00, 2.7166594014E+00, 1.6093011965E+00, 8.3063603236E-01],
	[2.2045000000E+04, 1.4098022093E+01, 5.4843909431E+00, 2.7186372139E+00, 1.6100494404E+00, 8.3071713282E-01],
	[2.2050000000E+04, 1.4102886740E+01, 5.4842858665E+00, 2.7206160165E+00, 1.6107976829E+00, 8.3079819832E-01],
	[2.2055000000E+04, 1.4107751961E+01, 5.4841808157E+00, 2.7225958095E+00, 1.6115459237E+00, 8.3087922888E-01],
	[2.2060000000E+04, 1.4112617757E+01, 5.4840757907E+00, 2.7245765931E+00, 1.6122941627E+00, 8.3096022450E-01],
	[2.2065000000E+04, 1.4117484129E+01, 5.4839707916E+00, 2.7265583676E+00, 1.6130423997E+00, 8.3104118520E-01],
	[2.2070000000E+04, 1.4122351075E+01, 5.4838658182E+00, 2.7285411333E+00, 1.6137906345E+00, 8.3112211096E-01],
	[2.2075000000E+04, 1.4127218596E+01, 5.4837608707E+00, 2.7305248904E+00, 1.6145388671E+00, 8.3120300182E-01],
	[2.2080000000E+04, 1.4132086692E+01, 5.4836559489E+00, 2.7325096392E+00, 1.6152870972E+00, 8.3128385777E-01],
	[2.2085000000E+04, 1.4136977403E+01, 5.4835555918E+00, 2.7344953801E+00, 1.6160360069E+00, 8.3136467882E-01],
	[2.2090000000E+04, 1.4141869262E+01, 5.4834553753E+00, 2.7364821132E+00, 1.6167849322E+00, 8.3144546499E-01],
	[2.2095000000E+04, 1.4146761707E+01, 5.4833551834E+00, 2.7384698388E+00, 1.6175338555E+00, 8.3152621627E-01],
	[2.2100000000E+04, 1.4151654736E+01, 5.4832550159E+00, 2.7404585572E+00, 1.6182827766E+00, 8.3160693269E-01],
	[2.2105000000E+04, 1.4156548351E+01, 5.4831548729E+00, 2.7424482687E+00, 1.6190316954E+00, 8.3168761424E-01],
	[2.2110000000E+04, 1.4161442550E+01, 5.4830547544E+00, 2.7444389736E+00, 1.6197806118E+00, 8.3176826093E-01],
	[2.2115000000E+04, 1.4166337334E+01, 5.4829546604E+00, 2.7464306720E+00, 1.6205295254E+00, 8.3184887278E-01],
	[2.2120000000E+04, 1.4171232703E+01, 5.4828545908E+00, 2.7484233643E+00, 1.6212784363E+00, 8.3192944979E-01],
	[2.2125000000E+04, 1.4176128656E+01, 5.4827545457E+00, 2.7504170508E+00, 1.6220273442E+00, 8.3200999196E-01],
	[2.2130000000E+04, 1.4181025194E+01, 5.4826545250E+00, 2.7524117317E+00, 1.6227762490E+00, 8.3209049932E-01],
	[2.2135000000E+04, 1.4185922317E+01, 5.4825545287E+00, 2.7544074073E+00, 1.6235251505E+00, 8.3217097187E-01],
	[2.2140000000E+04, 1.4190820024E+01, 5.4824545568E+00, 2.7564040778E+00, 1.6242740485E+00, 8.3225140960E-01],
	[2.2145000000E+04, 1.4195718316E+01, 5.4823546094E+00, 2.7584017436E+00, 1.6250229430E+00, 8.3233181255E-01],
	[2.2150000000E+04, 1.4200617191E+01, 5.4822546863E+00, 2.7604004049E+00, 1.6257718336E+00, 8.3241218070E-01],
	[2.2155000000E+04, 1.4205516652E+01, 5.4821547876E+00, 2.7624000620E+00, 1.6265207203E+00, 8.3249251408E-01],
	[2.2160000000E+04, 1.4210416696E+01, 5.4820549132E+00, 2.7644007151E+00, 1.6272696030E+00, 8.3257281268E-01],
	[2.2165000000E+04, 1.4215317325E+01, 5.4819550632E+00, 2.7664023645E+00, 1.6280184813E+00, 8.3265307652E-01],
	[2.2170000000E+04, 1.4220218537E+01, 5.4818552375E+00, 2.7684050105E+00, 1.6287673553E+00, 8.3273330561E-01],
	[2.2175000000E+04, 1.4225120334E+01, 5.4817554362E+00, 2.7704086534E+00, 1.6295162247E+00, 8.3281349996E-01],
	[2.2180000000E+04, 1.4230022715E+01, 5.4816556592E+00, 2.7724132934E+00, 1.6302650893E+00, 8.3289365956E-01],
	[2.2185000000E+04, 1.4234925679E+01, 5.4815559065E+00, 2.7744189308E+00, 1.6310139491E+00, 8.3297378444E-01],
	[2.2190000000E+04, 1.4239829228E+01, 5.4814561781E+00, 2.7764255659E+00, 1.6317628038E+00, 8.3305387460E-01],
	[2.2195000000E+04, 1.4244733360E+01, 5.4813564739E+00, 2.7784331989E+00, 1.6325116533E+00, 8.3313393005E-01],
	[2.2200000000E+04, 1.4249638076E+01, 5.4812567941E+00, 2.7804418301E+00, 1.6332604974E+00, 8.3321395079E-01],
	[2.2205000000E+04, 1.4254543375E+01, 5.4811571385E+00, 2.7824514598E+00, 1.6340093359E+00, 8.3329393684E-01],
	[2.2210000000E+04, 1.4259449259E+01, 5.4810575071E+00, 2.7844620883E+00, 1.6347581688E+00, 8.3337388821E-01],
	[2.2215000000E+04, 1.4264355725E+01, 5.4809579000E+00, 2.7864737157E+00, 1.6355069958E+00, 8.3345380490E-01],
	[2.2220000000E+04, 1.4269262776E+01, 5.4808583171E+00, 2.7884863425E+00, 1.6362558168E+00, 8.3353368692E-01],
	[2.2225000000E+04, 1.4274170409E+01, 5.4807587584E+00, 2.7904999688E+00, 1.6370046317E+00, 8.3361353429E-01],
	[2.2230000000E+04, 1.4279078626E+01, 5.4806592239E+00, 2.7925145950E+00, 1.6377534402E+00, 8.3369334700E-01],
	[2.2235000000E+04, 1.4283987427E+01, 5.4805597137E+00, 2.7945302213E+00, 1.6385022422E+00, 8.3377312509E-01],
	[2.2240000000E+04, 1.4288896810E+01, 5.4804602276E+00, 2.7965468479E+00, 1.6392510375E+00, 8.3385286859E-01],
	[2.2245000000E+04, 1.4293806777E+01, 5.4803607656E+00, 2.7985644752E+00, 1.6399998261E+00, 8.3393257752E-01],
	[2.2250000000E+04, 1.4298717327E+01, 5.4802613279E+00, 2.8005831034E+00, 1.6407486077E+00, 8.3401225187E-01],
	[2.2255000000E+04, 1.4303628460E+01, 5.4801619142E+00, 2.8026027328E+00, 1.6414973821E+00, 8.3409189166E-01],
	[2.2260000000E+04, 1.4308540176E+01, 5.4800625247E+00, 2.8046233637E+00, 1.6422461493E+00, 8.3417149690E-01],
	[2.2265000000E+04, 1.4313452475E+01, 5.4799631594E+00, 2.8066449963E+00, 1.6429949090E+00, 8.3425106758E-01],
	[2.2270000000E+04, 1.4318365356E+01, 5.4798638181E+00, 2.8086676309E+00, 1.6437436611E+00, 8.3433060372E-01],
	[2.2275000000E+04, 1.4323278821E+01, 5.4797645010E+00, 2.8106912678E+00, 1.6444924054E+00, 8.3441010533E-01],
	[2.2280000000E+04, 1.4328192868E+01, 5.4796652079E+00, 2.8127159072E+00, 1.6452411418E+00, 8.3448957240E-01],
	[2.2285000000E+04, 1.4333107498E+01, 5.4795659389E+00, 2.8147415494E+00, 1.6459898702E+00, 8.3456900495E-01],
	[2.2290000000E+04, 1.4338022711E+01, 5.4794666940E+00, 2.8167681947E+00, 1.6467385902E+00, 8.3464840299E-01],
	[2.2295000000E+04, 1.4342938506E+01, 5.4793674731E+00, 2.8187958434E+00, 1.6474873019E+00, 8.3472776651E-01],
	[2.2300000000E+04, 1.4347854883E+01, 5.4792682763E+00, 2.8208244957E+00, 1.6482360051E+00, 8.3480709553E-01],
	[2.2305000000E+04, 1.4352771843E+01, 5.4791691035E+00, 2.8228541519E+00, 1.6489846995E+00, 8.3488639006E-01],
	[2.2310000000E+04, 1.4357689386E+01, 5.4790699548E+00, 2.8248848123E+00, 1.6497333850E+00, 8.3496565010E-01],
	[2.2315000000E+04, 1.4362607511E+01, 5.4789708300E+00, 2.8269164771E+00, 1.6504820616E+00, 8.3504487565E-01],
	[2.2320000000E+04, 1.4367526218E+01, 5.4788717293E+00, 2.8289491466E+00, 1.6512307289E+00, 8.3512406673E-01],
	[2.2325000000E+04, 1.4372445507E+01, 5.4787726525E+00, 2.8309828211E+00, 1.6519793869E+00, 8.3520322335E-01],
	[2.2330000000E+04, 1.4377365378E+01, 5.4786735998E+00, 2.8330175009E+00, 1.6527280353E+00, 8.3528234550E-01],
	[2.2335000000E+04, 1.4382285831E+01, 5.4785745710E+00, 2.8350531861E+00, 1.6534766741E+00, 8.3536143320E-01],
	[2.2340000000E+04, 1.4387206867E+01, 5.4784755661E+00, 2.8370898772E+00, 1.6542253031E+00, 8.3544048645E-01],
	[2.2345000000E+04, 1.4392128484E+01, 5.4783765852E+00, 2.8391275744E+00, 1.6549739221E+00, 8.3551950526E-01],
	[2.2350000000E+04, 1.4397050683E+01, 5.4782776282E+00, 2.8411662778E+00, 1.6557225310E+00, 8.3559848964E-01],
	[2.2355000000E+04, 1.4401973464E+01, 5.4781786952E+00, 2.8432059879E+00, 1.6564711296E+00, 8.3567743959E-01],
	[2.2360000000E+04, 1.4406896827E+01, 5.4780797860E+00, 2.8452467049E+00, 1.6572197177E+00, 8.3575635512E-01],
	[2.2365000000E+04, 1.4411820771E+01, 5.4779809008E+00, 2.8473000070E+00, 1.6579722210E+00, 8.3583523624E-01],
	[2.2370000000E+04, 1.4416745297E+01, 5.4778820394E+00, 2.8493562165E+00, 1.6587253531E+00, 8.3591408296E-01],
	[2.2375000000E+04, 1.4421670405E+01, 5.4777832020E+00, 2.8514134500E+00, 1.6594784750E+00, 8.3599289528E-01],
	[2.2380000000E+04, 1.4426596094E+01, 5.4776843883E+00, 2.8534717078E+00, 1.6602315865E+00, 8.3607167321E-01],
	[2.2385000000E+04, 1.4431522365E+01, 5.4775855986E+00, 2.8555309902E+00, 1.6609846874E+00, 8.3615041675E-01],
	[2.2390000000E+04, 1.4436449217E+01, 5.4774868327E+00, 2.8575912974E+00, 1.6617377776E+00, 8.3622912592E-01],
	[2.2395000000E+04, 1.4441376650E+01, 5.4773880906E+00, 2.8596526298E+00, 1.6624908568E+00, 8.3630780072E-01],
	[2.2400000000E+04, 1.4446304665E+01, 5.4772893724E+00, 2.8617149876E+00, 1.6632439250E+00, 8.3638644116E-01],
	[2.2405000000E+04, 1.4451233260E+01, 5.4771906779E+00, 2.8637783711E+00, 1.6639969820E+00, 8.3646504725E-01],
	[2.2410000000E+04, 1.4456162437E+01, 5.4770920073E+00, 2.8658427806E+00, 1.6647500276E+00, 8.3654361899E-01],
	[2.2415000000E+04, 1.4461092195E+01, 5.4769933604E+00, 2.8679082164E+00, 1.6655030616E+00, 8.3662215639E-01],
	[2.2420000000E+04, 1.4466022534E+01, 5.4768947374E+00, 2.8699746787E+00, 1.6662560839E+00, 8.3670065945E-01],
	[2.2425000000E+04, 1.4470953454E+01, 5.4767961381E+00, 2.8720421678E+00, 1.6670090944E+00, 8.3677912819E-01],
	[2.2430000000E+04, 1.4475884955E+01, 5.4766975625E+00, 2.8741106840E+00, 1.6677620928E+00, 8.3685756262E-01],
	[2.2435000000E+04, 1.4480817037E+01, 5.4765990107E+00, 2.8761802276E+00, 1.6685150790E+00, 8.3693596273E-01],
	[2.2440000000E+04, 1.4485769863E+01, 5.4765045293E+00, 2.8782507989E+00, 1.6692686967E+00, 8.3701432854E-01],
	[2.2445000000E+04, 1.4490725949E+01, 5.4764106062E+00, 2.8803223981E+00, 1.6700223879E+00, 8.3709266006E-01],
	[2.2450000000E+04, 1.4495682626E+01, 5.4763167057E+00, 2.8823950256E+00, 1.6707760675E+00, 8.3717095728E-01],
	[2.2455000000E+04, 1.4500639894E+01, 5.4762228277E+00, 2.8844686815E+00, 1.6715297351E+00, 8.3724922023E-01],
	[2.2460000000E+04, 1.4505597753E+01, 5.4761289723E+00, 2.8865433663E+00, 1.6722833908E+00, 8.3732744890E-01],
	[2.2465000000E+04, 1.4510556203E+01, 5.4760351393E+00, 2.8886190801E+00, 1.6730370343E+00, 8.3740564331E-01],
	[2.2470000000E+04, 1.4515515244E+01, 5.4759413288E+00, 2.8906958233E+00, 1.6737906655E+00, 8.3748380345E-01],
	[2.2475000000E+04, 1.4520474876E+01, 5.4758475408E+00, 2.8927735960E+00, 1.6745442842E+00, 8.3756192935E-01],
	[2.2480000000E+04, 1.4525435099E+01, 5.4757537753E+00, 2.8948523987E+00, 1.6752978902E+00, 8.3764002101E-01],
	[2.2485000000E+04, 1.4530395913E+01, 5.4756600322E+00, 2.8969322316E+00, 1.6760514834E+00, 8.3771807842E-01],
	[2.2490000000E+04, 1.4535357317E+01, 5.4755663115E+00, 2.8990130950E+00, 1.6768050636E+00, 8.3779610161E-01],
	[2.2495000000E+04, 1.4540319311E+01, 5.4754726133E+00, 2.9010949891E+00, 1.6775586308E+00, 8.3787409058E-01],
	[2.2500000000E+04, 1.4545281897E+01, 5.4753789376E+00, 2.9031779142E+00, 1.6783121846E+00, 8.3795204534E-01],
	[2.2505000000E+04, 1.4550245072E+01, 5.4752852842E+00, 2.9052618707E+00, 1.6790657250E+00, 8.3802996589E-01],
	[2.2510000000E+04, 1.4555208839E+01, 5.4751916533E+00, 2.9073468587E+00, 1.6798192518E+00, 8.3810785224E-01],
	[2.2515000000E+04, 1.4560173195E+01, 5.4750980447E+00, 2.9094328787E+00, 1.6805727648E+00, 8.3818570440E-01],
	[2.2520000000E+04, 1.4565138142E+01, 5.4750044586E+00, 2.9115199307E+00, 1.6813262640E+00, 8.3826352238E-01],
	[2.2525000000E+04, 1.4570103679E+01, 5.4749108948E+00, 2.9136080153E+00, 1.6820797490E+00, 8.3834130618E-01],
	[2.2530000000E+04, 1.4575069806E+01, 5.4748173534E+00, 2.9156971325E+00, 1.6828332198E+00, 8.3841905582E-01],
	[2.2535000000E+04, 1.4580036524E+01, 5.4747238343E+00, 2.9177872827E+00, 1.6835866763E+00, 8.3849677129E-01],
	[2.2540000000E+04, 1.4585003831E+01, 5.4746303376E+00, 2.9198784662E+00, 1.6843401182E+00, 8.3857445262E-01],
	[2.2545000000E+04, 1.4589971728E+01, 5.4745368632E+00, 2.9219706833E+00, 1.6850935454E+00, 8.3865209980E-01],
	[2.2550000000E+04, 1.4594940216E+01, 5.4744434111E+00, 2.9240639342E+00, 1.6858469577E+00, 8.3872971284E-01],
	[2.2555000000E+04, 1.4599909293E+01, 5.4743499814E+00, 2.9261582192E+00, 1.6866003550E+00, 8.3880729176E-01],
	[2.2560000000E+04, 1.4604878960E+01, 5.4742565739E+00, 2.9282535386E+00, 1.6873537372E+00, 8.3888483655E-01],
	[2.2565000000E+04, 1.4609849217E+01, 5.4741631888E+00, 2.9303498927E+00, 1.6881071040E+00, 8.3896234723E-01],
	[2.2570000000E+04, 1.4614820063E+01, 5.4740698259E+00, 2.9324472818E+00, 1.6888604553E+00, 8.3903982381E-01],
	[2.2575000000E+04, 1.4619791499E+01, 5.4739764853E+00, 2.9345457061E+00, 1.6896137910E+00, 8.3911726629E-01],
	[2.2580000000E+04, 1.4624763525E+01, 5.4738831669E+00, 2.9366451659E+00, 1.6903671109E+00, 8.3919467468E-01],
	[2.2585000000E+04, 1.4629736140E+01, 5.4737898708E+00, 2.9387456616E+00, 1.6911204148E+00, 8.3927204898E-01],
	[2.2590000000E+04, 1.4634709345E+01, 5.4736965970E+00, 2.9408471933E+00, 1.6918737026E+00, 8.3934938922E-01],
	[2.2595000000E+04, 1.4639683139E+01, 5.4736033454E+00, 2.9429497614E+00, 1.6926269741E+00, 8.3942669538E-01],
	[2.2600000000E+04, 1.4644657522E+01, 5.4735101160E+00, 2.9450533661E+00, 1.6933802292E+00, 8.3950396749E-01],
	[2.2605000000E+04, 1.4649632495E+01, 5.4734169088E+00, 2.9471580078E+00, 1.6941334678E+00, 8.3958120555E-01],
	[2.2610000000E+04, 1.4654608057E+01, 5.4733237238E+00, 2.9492636867E+00, 1.6948866896E+00, 8.3965840957E-01],
	[2.2615000000E+04, 1.4659584208E+01, 5.4732305610E+00, 2.9513704030E+00, 1.6956398945E+00, 8.3973557955E-01],
	[2.2620000000E+04, 1.4664560948E+01, 5.4731374204E+00, 2.9534781572E+00, 1.6963930823E+00, 8.3981271551E-01],
	[2.2625000000E+04, 1.4669538277E+01, 5.4730443020E+00, 2.9555869494E+00, 1.6971462529E+00, 8.3988981745E-01],
	[2.2630000000E+04, 1.4674516195E+01, 5.4729512057E+00, 2.9576967799E+00, 1.6978994062E+00, 8.3996688537E-01],
	[2.2635000000E+04, 1.4679494702E+01, 5.4728581316E+00, 2.9598076490E+00, 1.6986525420E+00, 8.4004391930E-01],
	[2.2640000000E+04, 1.4684473798E+01, 5.4727650796E+00, 2.9619195571E+00, 1.6994056601E+00, 8.4012091923E-01],
	[2.2645000000E+04, 1.4689453482E+01, 5.4726720497E+00, 2.9640325043E+00, 1.7001587603E+00, 8.4019788518E-01],
	[2.2650000000E+04, 1.4694433756E+01, 5.4725790420E+00, 2.9661464909E+00, 1.7009118426E+00, 8.4027481714E-01],
	[2.2655000000E+04, 1.4699414618E+01, 5.4724860564E+00, 2.9682615173E+00, 1.7016649067E+00, 8.4035171514E-01],
	[2.2660000000E+04, 1.4704396068E+01, 5.4723930928E+00, 2.9703775838E+00, 1.7024179525E+00, 8.4042857918E-01],
	[2.2665000000E+04, 1.4709378107E+01, 5.4723001514E+00, 2.9724946905E+00, 1.7031709799E+00, 8.4050540926E-01],
	[2.2670000000E+04, 1.4714360735E+01, 5.4722072320E+00, 2.9746128378E+00, 1.7039239887E+00, 8.4058220539E-01],
	[2.2675000000E+04, 1.4719343951E+01, 5.4721143347E+00, 2.9767320260E+00, 1.7046769787E+00, 8.4065896759E-01],
	[2.2680000000E+04, 1.4724327756E+01, 5.4720214595E+00, 2.9788522553E+00, 1.7054299498E+00, 8.4073569586E-01],
	[2.2685000000E+04, 1.4729312148E+01, 5.4719286063E+00, 2.9809735260E+00, 1.7061829018E+00, 8.4081239021E-01],
	[2.2690000000E+04, 1.4734297129E+01, 5.4718357752E+00, 2.9830958385E+00, 1.7069358346E+00, 8.4088905064E-01],
	[2.2695000000E+04, 1.4739282698E+01, 5.4717429660E+00, 2.9852191929E+00, 1.7076887480E+00, 8.4096567717E-01],
	[2.2700000000E+04, 1.4744268855E+01, 5.4716501789E+00, 2.9873435896E+00, 1.7084416419E+00, 8.4104226981E-01],
	[2.2705000000E+04, 1.4749255601E+01, 5.4715574138E+00, 2.9894690289E+00, 1.7091945161E+00, 8.4111882855E-01],
	[2.2710000000E+04, 1.4754242934E+01, 5.4714646708E+00, 2.9915955110E+00, 1.7099473705E+00, 8.4119535342E-01],
	[2.2715000000E+04, 1.4759230855E+01, 5.4713719496E+00, 2.9937230362E+00, 1.7107002048E+00, 8.4127184442E-01],
	[2.2720000000E+04, 1.4764219364E+01, 5.4712792505E+00, 2.9958516048E+00, 1.7114530190E+00, 8.4134830155E-01],
	[2.2725000000E+04, 1.4769208461E+01, 5.4711865734E+00, 2.9979812170E+00, 1.7122058129E+00, 8.4142472482E-01],
	[2.2730000000E+04, 1.4774198146E+01, 5.4710939182E+00, 3.0001118733E+00, 1.7129585863E+00, 8.4150111425E-01],
	[2.2735000000E+04, 1.4779188418E+01, 5.4710012849E+00, 3.0022435737E+00, 1.7137113392E+00, 8.4157746984E-01],
	[2.2740000000E+04, 1.4784179278E+01, 5.4709086736E+00, 3.0043763187E+00, 1.7144640712E+00, 8.4165379160E-01],
	[2.2745000000E+04, 1.4789170726E+01, 5.4708160842E+00, 3.0065101085E+00, 1.7152167823E+00, 8.4173007954E-01],
	[2.2750000000E+04, 1.4794162761E+01, 5.4707235167E+00, 3.0086449434E+00, 1.7159694724E+00, 8.4180633367E-01],
	[2.2755000000E+04, 1.4799155384E+01, 5.4706309712E+00, 3.0107808236E+00, 1.7167221412E+00, 8.4188255399E-01],
	[2.2760000000E+04, 1.4804148594E+01, 5.4705384475E+00, 3.0129177495E+00, 1.7174747886E+00, 8.4195874051E-01],
	[2.2765000000E+04, 1.4809142391E+01, 5.4704459457E+00, 3.0150557213E+00, 1.7182274145E+00, 8.4203489325E-01],
	[2.2770000000E+04, 1.4814136776E+01, 5.4703534658E+00, 3.0171947393E+00, 1.7189800187E+00, 8.4211101221E-01],
	[2.2775000000E+04, 1.4819131748E+01, 5.4702610078E+00, 3.0193348038E+00, 1.7197326011E+00, 8.4218709739E-01],
	[2.2780000000E+04, 1.4824127306E+01, 5.4701685716E+00, 3.0214759150E+00, 1.7204851614E+00, 8.4226314882E-01],
	[2.2785000000E+04, 1.4829123453E+01, 5.4700761573E+00, 3.0236180733E+00, 1.7212376997E+00, 8.4233916649E-01],
	[2.2790000000E+04, 1.4834120186E+01, 5.4699837648E+00, 3.0257612790E+00, 1.7219902156E+00, 8.4241515041E-01],
	[2.2795000000E+04, 1.4839117506E+01, 5.4698913942E+00, 3.0279055322E+00, 1.7227427090E+00, 8.4249110060E-01],
	[2.2800000000E+04, 1.4844130327E+01, 5.4698019623E+00, 3.0300508334E+00, 1.7234956705E+00, 8.4256701705E-01],
	[2.2805000000E+04, 1.4849151895E+01, 5.4697141457E+00, 3.0321971827E+00, 1.7242488782E+00, 8.4264289979E-01],
	[2.2810000000E+04, 1.4854174061E+01, 5.4696263497E+00, 3.0343445805E+00, 1.7250020640E+00, 8.4271874882E-01],
	[2.2815000000E+04, 1.4859196823E+01, 5.4695385743E+00, 3.0364930271E+00, 1.7257552277E+00, 8.4279456414E-01],
	[2.2820000000E+04, 1.4864220183E+01, 5.4694508196E+00, 3.0386425226E+00, 1.7265083691E+00, 8.4287034577E-01],
	[2.2825000000E+04, 1.4869244140E+01, 5.4693630856E+00, 3.0407930675E+00, 1.7272614881E+00, 8.4294609371E-01],
	[2.2830000000E+04, 1.4874268694E+01, 5.4692753721E+00, 3.0429446619E+00, 1.7280145845E+00, 8.4302180798E-01],
	[2.2835000000E+04, 1.4879293845E+01, 5.4691876793E+00, 3.0450973062E+00, 1.7287676582E+00, 8.4309748858E-01],
	[2.2840000000E+04, 1.4884319593E+01, 5.4691000071E+00, 3.0472510007E+00, 1.7295207091E+00, 8.4317313552E-01],
	[2.2845000000E+04, 1.4889345938E+01, 5.4690123555E+00, 3.0494057456E+00, 1.7302737370E+00, 8.4324874880E-01],
	[2.2850000000E+04, 1.4894372880E+01, 5.4689247244E+00, 3.0515615411E+00, 1.7310267416E+00, 8.4332432845E-01],
	[2.2855000000E+04, 1.4899400418E+01, 5.4688371139E+00, 3.0537183877E+00, 1.7317797230E+00, 8.4339987446E-01],
	[2.2860000000E+04, 1.4904428554E+01, 5.4687495240E+00, 3.0558762856E+00, 1.7325326809E+00, 8.4347538685E-01],
	[2.2865000000E+04, 1.4909457286E+01, 5.4686619547E+00, 3.0580352350E+00, 1.7332856152E+00, 8.4355086561E-01],
	[2.2870000000E+04, 1.4914486614E+01, 5.4685744059E+00, 3.0601952363E+00, 1.7340385257E+00, 8.4362631078E-01],
	[2.2875000000E+04, 1.4919516539E+01, 5.4684868777E+00, 3.0623562896E+00, 1.7347914122E+00, 8.4370172234E-01],
	[2.2880000000E+04, 1.4924547061E+01, 5.4683993699E+00, 3.0645183954E+00, 1.7355442747E+00, 8.4377710031E-01],
	[2.2885000000E+04, 1.4929578179E+01, 5.4683118827E+00, 3.0666815539E+00, 1.7362971130E+00, 8.4385244471E-01],
	[2.2890000000E+04, 1.4934609893E+01, 5.4682244160E+00, 3.0688457653E+00, 1.7370499269E+00, 8.4392775552E-01],
	[2.2895000000E+04, 1.4939642203E+01, 5.4681369699E+00, 3.0710110300E+00, 1.7378027163E+00, 8.4400303278E-01],
	[2.2900000000E+04, 1.4944675110E+01, 5.4680495442E+00, 3.0731773482E+00, 1.7385554809E+00, 8.4407827648E-01],
	[2.2905000000E+04, 1.4949708613E+01, 5.4679621390E+00, 3.0753447202E+00, 1.7393082208E+00, 8.4415348664E-01],
	[2.2910000000E+04, 1.4954742712E+01, 5.4678747542E+00, 3.0775131463E+00, 1.7400609357E+00, 8.4422866325E-01],
	[2.2915000000E+04, 1.4959777407E+01, 5.4677873900E+00, 3.0796826267E+00, 1.7408136254E+00, 8.4430380634E-01],
	[2.2920000000E+04, 1.4964812698E+01, 5.4677000461E+00, 3.0818531618E+00, 1.7415662898E+00, 8.4437891591E-01],
	[2.2925000000E+04, 1.4969848585E+01, 5.4676127228E+00, 3.0840247519E+00, 1.7423189289E+00, 8.4445399197E-01],
	[2.2930000000E+04, 1.4974885068E+01, 5.4675254198E+00, 3.0861973972E+00, 1.7430715423E+00, 8.4452903453E-01],
	[2.2935000000E+04, 1.4979922147E+01, 5.4674381373E+00, 3.0883710980E+00, 1.7438241300E+00, 8.4460404360E-01],
	[2.2940000000E+04, 1.4984959822E+01, 5.4673508753E+00, 3.0905458545E+00, 1.7445766918E+00, 8.4467901918E-01],
	[2.2945000000E+04, 1.4989998092E+01, 5.4672636336E+00, 3.0927216671E+00, 1.7453292276E+00, 8.4475396129E-01],
	[2.2950000000E+04, 1.4995036958E+01, 5.4671764123E+00, 3.0948985361E+00, 1.7460817372E+00, 8.4482886993E-01],
	[2.2955000000E+04, 1.5000076419E+01, 5.4670892114E+00, 3.0970764617E+00, 1.7468342204E+00, 8.4490374511E-01],
	[2.2960000000E+04, 1.5005116476E+01, 5.4670020309E+00, 3.0992554442E+00, 1.7475866772E+00, 8.4497858685E-01],
	[2.2965000000E+04, 1.5010157129E+01, 5.4669148708E+00, 3.1014354839E+00, 1.7483391074E+00, 8.4505339515E-01],
	[2.2970000000E+04, 1.5015198377E+01, 5.4668277310E+00, 3.1036165811E+00, 1.7490915107E+00, 8.4512817001E-01],
	[2.2975000000E+04, 1.5020240220E+01, 5.4667406116E+00, 3.1057987360E+00, 1.7498438871E+00, 8.4520291146E-01],
	[2.2980000000E+04, 1.5025282658E+01, 5.4666535126E+00, 3.1079819490E+00, 1.7505962365E+00, 8.4527761950E-01],
	[2.2985000000E+04, 1.5030325692E+01, 5.4665664338E+00, 3.1101662202E+00, 1.7513485586E+00, 8.4535229413E-01],
	[2.2990000000E+04, 1.5035369321E+01, 5.4664793755E+00, 3.1123515501E+00, 1.7521008533E+00, 8.4542693537E-01],
	[2.2995000000E+04, 1.5040413545E+01, 5.4663923374E+00, 3.1145379389E+00, 1.7528531205E+00, 8.4550154322E-01],
	[2.3000000000E+04, 1.5045458364E+01, 5.4663053196E+00, 3.1167253868E+00, 1.7536053600E+00, 8.4557611770E-01],
	[2.3005000000E+04, 1.5050503778E+01, 5.4662183221E+00, 3.1189138942E+00, 1.7543575717E+00, 8.4565065881E-01],
	[2.3010000000E+04, 1.5055549787E+01, 5.4661313449E+00, 3.1211034613E+00, 1.7551097554E+00, 8.4572516657E-01],
	[2.3015000000E+04, 1.5060596390E+01, 5.4660443880E+00, 3.1232940884E+00, 1.7558619110E+00, 8.4579964098E-01],
	[2.3020000000E+04, 1.5065643589E+01, 5.4659574514E+00, 3.1254857758E+00, 1.7566140383E+00, 8.4587408204E-01],
	[2.3025000000E+04, 1.5070691382E+01, 5.4658705351E+00, 3.1276785238E+00, 1.7573661372E+00, 8.4594848978E-01],
	[2.3030000000E+04, 1.5075739771E+01, 5.4657836389E+00, 3.1298723327E+00, 1.7581182075E+00, 8.4602286420E-01],
	[2.3035000000E+04, 1.5080788753E+01, 5.4656967631E+00, 3.1320672026E+00, 1.7588702491E+00, 8.4609720531E-01],
	[2.3040000000E+04, 1.5085838330E+01, 5.4656099074E+00, 3.1342631340E+00, 1.7596222618E+00, 8.4617151311E-01],
	[2.3045000000E+04, 1.5090888502E+01, 5.4655230720E+00, 3.1364601272E+00, 1.7603742455E+00, 8.4624578762E-01],
	[2.3050000000E+04, 1.5095939269E+01, 5.4654362569E+00, 3.1386581822E+00, 1.7611262001E+00, 8.4632002885E-01],
	[2.3055000000E+04, 1.5100990629E+01, 5.4653494619E+00, 3.1408572996E+00, 1.7618781253E+00, 8.4639423680E-01],
	[2.3060000000E+04, 1.5106042584E+01, 5.4652626871E+00, 3.1430574795E+00, 1.7626300210E+00, 8.4646841149E-01],
	[2.3065000000E+04, 1.5111095133E+01, 5.4651759325E+00, 3.1452587223E+00, 1.7633818872E+00, 8.4654255292E-01],
	[2.3070000000E+04, 1.5116148277E+01, 5.4650891981E+00, 3.1474610281E+00, 1.7641337236E+00, 8.4661666111E-01],
	[2.3075000000E+04, 1.5121202015E+01, 5.4650024839E+00, 3.1496643974E+00, 1.7648855301E+00, 8.4669073605E-01],
	[2.3080000000E+04, 1.5126256346E+01, 5.4649157898E+00, 3.1518688303E+00, 1.7656373065E+00, 8.4676477777E-01],
	[2.3085000000E+04, 1.5131311272E+01, 5.4648291159E+00, 3.1540743272E+00, 1.7663890527E+00, 8.4683878628E-01],
	[2.3090000000E+04, 1.5136366792E+01, 5.4647424621E+00, 3.1562808883E+00, 1.7671407686E+00, 8.4691276157E-01],
	[2.3095000000E+04, 1.5141422906E+01, 5.4646558285E+00, 3.1584885140E+00, 1.7678924540E+00, 8.4698670366E-01],
	[2.3100000000E+04, 1.5146479613E+01, 5.4645692150E+00, 3.1606972045E+00, 1.7686441087E+00, 8.4706061256E-01],
	[2.3105000000E+04, 1.5151536914E+01, 5.4644826216E+00, 3.1629069600E+00, 1.7693957327E+00, 8.4713448828E-01],
	[2.3110000000E+04, 1.5156594810E+01, 5.4643960483E+00, 3.1651177810E+00, 1.7701473257E+00, 8.4720833082E-01],
	[2.3115000000E+04, 1.5161653298E+01, 5.4643094951E+00, 3.1673296676E+00, 1.7708988876E+00, 8.4728214021E-01],
	[2.3120000000E+04, 1.5166712381E+01, 5.4642229620E+00, 3.1695426201E+00, 1.7716504183E+00, 8.4735591644E-01],
	[2.3125000000E+04, 1.5171772057E+01, 5.4641364490E+00, 3.1717566388E+00, 1.7724019176E+00, 8.4742965953E-01],
	[2.3130000000E+04, 1.5176832326E+01, 5.4640499561E+00, 3.1739717241E+00, 1.7731533854E+00, 8.4750336948E-01],
	[2.3135000000E+04, 1.5181893189E+01, 5.4639634832E+00, 3.1761878761E+00, 1.7739048215E+00, 8.4757704631E-01],
	[2.3140000000E+04, 1.5186954646E+01, 5.4638770304E+00, 3.1784050952E+00, 1.7746562258E+00, 8.4765069002E-01],
	[2.3145000000E+04, 1.5192016696E+01, 5.4637905976E+00, 3.1806233816E+00, 1.7754075981E+00, 8.4772430063E-01],
	[2.3150000000E+04, 1.5197079339E+01, 5.4637041848E+00, 3.1828427357E+00, 1.7761589383E+00, 8.4779787814E-01],
	[2.3155000000E+04, 1.5202142575E+01, 5.4636177921E+00, 3.1850631577E+00, 1.7769102463E+00, 8.4787142256E-01],
	[2.3160000000E+04, 1.5207206404E+01, 5.4635314194E+00, 3.1872846479E+00, 1.7776615219E+00, 8.4794493391E-01],
	[2.3165000000E+04, 1.5212276588E+01, 5.4634461648E+00, 3.1895072066E+00, 1.7784129599E+00, 8.4801841219E-01],
	[2.3170000000E+04, 1.5217364912E+01, 5.4633642731E+00, 3.1917308340E+00, 1.7791649600E+00, 8.4809185740E-01],
	[2.3175000000E+04, 1.5222453840E+01, 5.4632824003E+00, 3.1939555304E+00, 1.7799169281E+00, 8.4816526957E-01],
	[2.3180000000E+04, 1.5227543372E+01, 5.4632005464E+00, 3.1961812962E+00, 1.7806688642E+00, 8.4823864871E-01],
	[2.3185000000E+04, 1.5232633507E+01, 5.4631187113E+00, 3.1984081316E+00, 1.7814207682E+00, 8.4831199481E-01],
	[2.3190000000E+04, 1.5237724245E+01, 5.4630368951E+00, 3.2006360369E+00, 1.7821726398E+00, 8.4838530789E-01],
	[2.3195000000E+04, 1.5242815586E+01, 5.4629550978E+00, 3.2028650124E+00, 1.7829244790E+00, 8.4845858796E-01],
	[2.3200000000E+04, 1.5247907531E+01, 5.4628733193E+00, 3.2050950583E+00, 1.7836762855E+00, 8.4853183503E-01],
	[2.3205000000E+04, 1.5253000079E+01, 5.4627915597E+00, 3.2073261750E+00, 1.7844280594E+00, 8.4860504911E-01],
	[2.3210000000E+04, 1.5258093230E+01, 5.4627098189E+00, 3.2095583627E+00, 1.7851798003E+00, 8.4867823020E-01],
	[2.3215000000E+04, 1.5263186984E+01, 5.4626280970E+00, 3.2117916216E+00, 1.7859315082E+00, 8.4875137833E-01],
	[2.3220000000E+04, 1.5268281341E+01, 5.4625463939E+00, 3.2140259522E+00, 1.7866831829E+00, 8.4882449349E-01],
	[2.3225000000E+04, 1.5273376301E+01, 5.4624647096E+00, 3.2162613547E+00, 1.7874348242E+00, 8.4889757570E-01],
	[2.3230000000E+04, 1.5278471864E+01, 5.4623830440E+00, 3.2184978293E+00, 1.7881864321E+00, 8.4897062496E-01],
	[2.3235000000E+04, 1.5283568029E+01, 5.4623013973E+00, 3.2207353763E+00, 1.7889380064E+00, 8.4904364129E-01],
	[2.3240000000E+04, 1.5288664798E+01, 5.4622197694E+00, 3.2229739960E+00, 1.7896895469E+00, 8.4911662470E-01],
	[2.3245000000E+04, 1.5293762169E+01, 5.4621381603E+00, 3.2252136888E+00, 1.7904410535E+00, 8.4918957520E-01],
	[2.3250000000E+04, 1.5298860143E+01, 5.4620565699E+00, 3.2274544548E+00, 1.7911925261E+00, 8.4926249279E-01],
	[2.3255000000E+04, 1.5303958719E+01, 5.4619749983E+00, 3.2296962944E+00, 1.7919439645E+00, 8.4933537748E-01],
	[2.3260000000E+04, 1.5309057898E+01, 5.4618934454E+00, 3.2319392078E+00, 1.7926953685E+00, 8.4940822929E-01],
	[2.3265000000E+04, 1.5314157679E+01, 5.4618119113E+00, 3.2341831954E+00, 1.7934467380E+00, 8.4948104823E-01],
	[2.3270000000E+04, 1.5319258062E+01, 5.4617303959E+00, 3.2364282574E+00, 1.7941980729E+00, 8.4955383430E-01],
	[2.3275000000E+04, 1.5324359048E+01, 5.4616488993E+00, 3.2386743940E+00, 1.7949493730E+00, 8.4962658751E-01],
	[2.3280000000E+04, 1.5329460637E+01, 5.4615674214E+00, 3.2409216057E+00, 1.7957006382E+00, 8.4969930788E-01],
	[2.3285000000E+04, 1.5334562827E+01, 5.4614859621E+00, 3.2431698926E+00, 1.7964518684E+00, 8.4977199541E-01],
	[2.3290000000E+04, 1.5339665620E+01, 5.4614045216E+00, 3.2454192550E+00, 1.7972030633E+00, 8.4984465012E-01],
	[2.3295000000E+04, 1.5344769015E+01, 5.4613230998E+00, 3.2476696933E+00, 1.7979542229E+00, 8.4991727201E-01],
	[2.3300000000E+04, 1.5349873011E+01, 5.4612416967E+00, 3.2499212077E+00, 1.7987053470E+00, 8.4998986109E-01],
	[2.3305000000E+04, 1.5354977610E+01, 5.4611603123E+00, 3.2521737985E+00, 1.7994564355E+00, 8.5006241738E-01],
	[2.3310000000E+04, 1.5360082811E+01, 5.4610789465E+00, 3.2544274660E+00, 1.8002074882E+00, 8.5013494088E-01],
	[2.3315000000E+04, 1.5365188613E+01, 5.4609975994E+00, 3.2566822104E+00, 1.8009585050E+00, 8.5020743160E-01],
	[2.3320000000E+04, 1.5370295018E+01, 5.4609162709E+00, 3.2589380320E+00, 1.8017094857E+00, 8.5027988956E-01],
	[2.3325000000E+04, 1.5375402024E+01, 5.4608349611E+00, 3.2611949312E+00, 1.8024604302E+00, 8.5035231476E-01],
	[2.3330000000E+04, 1.5380509632E+01, 5.4607536700E+00, 3.2634529082E+00, 1.8032113383E+00, 8.5042470721E-01],
	[2.3335000000E+04, 1.5385617841E+01, 5.4606723974E+00, 3.2657119633E+00, 1.8039622099E+00, 8.5049706692E-01],
	[2.3340000000E+04, 1.5390726653E+01, 5.4605911435E+00, 3.2679720967E+00, 1.8047130450E+00, 8.5056939391E-01],
	[2.3345000000E+04, 1.5395836065E+01, 5.4605099082E+00, 3.2702333088E+00, 1.8054638432E+00, 8.5064168818E-01],
	[2.3350000000E+04, 1.5400946079E+01, 5.4604286915E+00, 3.2724955999E+00, 1.8062146045E+00, 8.5071394974E-01],
	[2.3355000000E+04, 1.5406056695E+01, 5.4603474934E+00, 3.2747589702E+00, 1.8069653288E+00, 8.5078617861E-01],
	[2.3360000000E+04, 1.5411167912E+01, 5.4602663139E+00, 3.2770234199E+00, 1.8077160158E+00, 8.5085837478E-01],
	[2.3365000000E+04, 1.5416279730E+01, 5.4601851529E+00, 3.2792889495E+00, 1.8084666655E+00, 8.5093053828E-01],
	[2.3370000000E+04, 1.5421392149E+01, 5.4601040106E+00, 3.2815555591E+00, 1.8092172777E+00, 8.5100266911E-01],
	[2.3375000000E+04, 1.5426505170E+01, 5.4600228868E+00, 3.2838232491E+00, 1.8099678523E+00, 8.5107476729E-01],
	[2.3380000000E+04, 1.5431618791E+01, 5.4599417815E+00, 3.2860920197E+00, 1.8107183891E+00, 8.5114683281E-01],
	[2.3385000000E+04, 1.5436733014E+01, 5.4598606949E+00, 3.2883618712E+00, 1.8114688879E+00, 8.5121886570E-01],
	[2.3390000000E+04, 1.5441847838E+01, 5.4597796267E+00, 3.2906328040E+00, 1.8122193487E+00, 8.5129086596E-01],
	[2.3395000000E+04, 1.5446963263E+01, 5.4596985771E+00, 3.2929048182E+00, 1.8129697714E+00, 8.5136283360E-01],
	[2.3400000000E+04, 1.5452079288E+01, 5.4596175460E+00, 3.2951779142E+00, 1.8137201556E+00, 8.5143476864E-01],
	[2.3405000000E+04, 1.5457195915E+01, 5.4595365334E+00, 3.2974520922E+00, 1.8144705014E+00, 8.5150667108E-01],
	[2.3410000000E+04, 1.5462313142E+01, 5.4594555393E+00, 3.2997273526E+00, 1.8152208086E+00, 8.5157854093E-01],
	[2.3415000000E+04, 1.5467430970E+01, 5.4593745637E+00, 3.3020036956E+00, 1.8159710770E+00, 8.5165037820E-01],
	[2.3420000000E+04, 1.5472549398E+01, 5.4592936066E+00, 3.3042811215E+00, 1.8167213065E+00, 8.5172218291E-01],
	[2.3425000000E+04, 1.5477668427E+01, 5.4592126680E+00, 3.3065596305E+00, 1.8174714969E+00, 8.5179395506E-01],
	[2.3430000000E+04, 1.5482788057E+01, 5.4591317479E+00, 3.3088392231E+00, 1.8182216482E+00, 8.5186569466E-01],
	[2.3435000000E+04, 1.5487908287E+01, 5.4590508462E+00, 3.3111198994E+00, 1.8189717601E+00, 8.5193740172E-01],
	[2.3440000000E+04, 1.5493029118E+01, 5.4589699630E+00, 3.3134016597E+00, 1.8197218325E+00, 8.5200907626E-01],
	[2.3445000000E+04, 1.5498150549E+01, 5.4588890983E+00, 3.3156845043E+00, 1.8204718654E+00, 8.5208071828E-01],
	[2.3450000000E+04, 1.5503272580E+01, 5.4588082519E+00, 3.3179684336E+00, 1.8212218584E+00, 8.5215232780E-01],
	[2.3455000000E+04, 1.5508395212E+01, 5.4587274240E+00, 3.3202534477E+00, 1.8219718116E+00, 8.5222390482E-01],
	[2.3460000000E+04, 1.5513518443E+01, 5.4586466146E+00, 3.3225395470E+00, 1.8227217248E+00, 8.5229544935E-01],
	[2.3465000000E+04, 1.5518642275E+01, 5.4585658235E+00, 3.3248267317E+00, 1.8234715977E+00, 8.5236696141E-01],
	[2.3470000000E+04, 1.5523766707E+01, 5.4584850509E+00, 3.3271150022E+00, 1.8242214304E+00, 8.5243844100E-01],
	[2.3475000000E+04, 1.5528891739E+01, 5.4584042967E+00, 3.3294043587E+00, 1.8249712226E+00, 8.5250988814E-01],
	[2.3480000000E+04, 1.5534017371E+01, 5.4583235608E+00, 3.3316948015E+00, 1.8257209742E+00, 8.5258130283E-01],
	[2.3485000000E+04, 1.5539143603E+01, 5.4582428434E+00, 3.3339863308E+00, 1.8264706851E+00, 8.5265268508E-01],
	[2.3490000000E+04, 1.5544270435E+01, 5.4581621443E+00, 3.3362789471E+00, 1.8272203551E+00, 8.5272403492E-01],
	[2.3495000000E+04, 1.5549397866E+01, 5.4580814636E+00, 3.3385726504E+00, 1.8279699841E+00, 8.5279535233E-01],
	[2.3500000000E+04, 1.5554525897E+01, 5.4580008012E+00, 3.3408674413E+00, 1.8287195719E+00, 8.5286663734E-01],
	[2.3505000000E+04, 1.5559654528E+01, 5.4579201572E+00, 3.3431633198E+00, 1.8294691184E+00, 8.5293788996E-01],
	[2.3510000000E+04, 1.5564783759E+01, 5.4578395316E+00, 3.3454602863E+00, 1.8302186235E+00, 8.5300911020E-01],
	[2.3515000000E+04, 1.5569913589E+01, 5.4577589242E+00, 3.3477583411E+00, 1.8309680870E+00, 8.5308029806E-01],
	[2.3520000000E+04, 1.5575044019E+01, 5.4576783352E+00, 3.3500574845E+00, 1.8317175089E+00, 8.5315145356E-01],
	[2.3525000000E+04, 1.5580175048E+01, 5.4575977646E+00, 3.3523577167E+00, 1.8324668888E+00, 8.5322257670E-01],
	[2.3530000000E+04, 1.5585306676E+01, 5.4575172122E+00, 3.3546590381E+00, 1.8332162268E+00, 8.5329366750E-01],
	[2.3535000000E+04, 1.5590438904E+01, 5.4574366781E+00, 3.3569614489E+00, 1.8339655226E+00, 8.5336472597E-01],
	[2.3540000000E+04, 1.5595587419E+01, 5.4573590756E+00, 3.3592649493E+00, 1.8347153226E+00, 8.5343575212E-01],
	[2.3545000000E+04, 1.5600744403E+01, 5.4572829501E+00, 3.3615695398E+00, 1.8354653547E+00, 8.5350674596E-01],
	[2.3550000000E+04, 1.5605901996E+01, 5.4572068418E+00, 3.3638752205E+00, 1.8362153452E+00, 8.5357770750E-01],
	[2.3555000000E+04, 1.5611060200E+01, 5.4571307508E+00, 3.3661819918E+00, 1.8369652940E+00, 8.5364863674E-01],
	[2.3560000000E+04, 1.5616219012E+01, 5.4570546770E+00, 3.3684898539E+00, 1.8377152009E+00, 8.5371953371E-01],
	[2.3565000000E+04, 1.5621378434E+01, 5.4569786203E+00, 3.3707988071E+00, 1.8384650659E+00, 8.5379039840E-01],
	[2.3570000000E+04, 1.5626538466E+01, 5.4569025809E+00, 3.3731088517E+00, 1.8392148887E+00, 8.5386123084E-01],
	[2.3575000000E+04, 1.5631699107E+01, 5.4568265586E+00, 3.3754199880E+00, 1.8399646693E+00, 8.5393203102E-01],
	[2.3580000000E+04, 1.5636860358E+01, 5.4567505536E+00, 3.3777322163E+00, 1.8407144074E+00, 8.5400279897E-01],
	[2.3585000000E+04, 1.5642022217E+01, 5.4566745657E+00, 3.3800455368E+00, 1.8414641030E+00, 8.5407353469E-01],
	[2.3590000000E+04, 1.5647184686E+01, 5.4565985949E+00, 3.3823599499E+00, 1.8422137558E+00, 8.5414423819E-01],
	[2.3595000000E+04, 1.5652347764E+01, 5.4565226414E+00, 3.3846754558E+00, 1.8429633659E+00, 8.5421490948E-01],
	[2.3600000000E+04, 1.5657511452E+01, 5.4564467049E+00, 3.3869920547E+00, 1.8437129330E+00, 8.5428554858E-01],
	[2.3605000000E+04, 1.5662675748E+01, 5.4563707857E+00, 3.3893097471E+00, 1.8444624570E+00, 8.5435615549E-01],
	[2.3610000000E+04, 1.5667840653E+01, 5.4562948835E+00, 3.3916285331E+00, 1.8452119378E+00, 8.5442673022E-01],
	[2.3615000000E+04, 1.5673006168E+01, 5.4562189985E+00, 3.3939484131E+00, 1.8459613751E+00, 8.5449727279E-01],
	[2.3620000000E+04, 1.5678172291E+01, 5.4561431306E+00, 3.3962693873E+00, 1.8467107690E+00, 8.5456778320E-01],
	[2.3625000000E+04, 1.5683339023E+01, 5.4560672798E+00, 3.3985914561E+00, 1.8474601192E+00, 8.5463826147E-01],
	[2.3630000000E+04, 1.5688506364E+01, 5.4559914461E+00, 3.4009146196E+00, 1.8482094256E+00, 8.5470870760E-01],
	[2.3635000000E+04, 1.5693674313E+01, 5.4559156296E+00, 3.4032388782E+00, 1.8489586881E+00, 8.5477912161E-01],
	[2.3640000000E+04, 1.5698842871E+01, 5.4558398301E+00, 3.4055642322E+00, 1.8497079066E+00, 8.5484950351E-01],
	[2.3645000000E+04, 1.5704012038E+01, 5.4557640477E+00, 3.4078907014E+00, 1.8504570866E+00, 8.5491985330E-01],
	[2.3650000000E+04, 1.5709181814E+01, 5.4556882823E+00, 3.4102183121E+00, 1.8512062356E+00, 8.5499017101E-01],
	[2.3655000000E+04, 1.5714352197E+01, 5.4556125341E+00, 3.4125470191E+00, 1.8519553402E+00, 8.5506045663E-01],
	[2.3660000000E+04, 1.5719523190E+01, 5.4555368029E+00, 3.4148768227E+00, 1.8527044003E+00, 8.5513071018E-01],
	[2.3665000000E+04, 1.5724694790E+01, 5.4554610887E+00, 3.4172077232E+00, 1.8534534155E+00, 8.5520093167E-01],
	[2.3670000000E+04, 1.5729866999E+01, 5.4553853916E+00, 3.4195397208E+00, 1.8542023859E+00, 8.5527112111E-01],
	[2.3675000000E+04, 1.5735039817E+01, 5.4553097116E+00, 3.4218728159E+00, 1.8549513113E+00, 8.5534127851E-01],
	[2.3680000000E+04, 1.5740213242E+01, 5.4552340485E+00, 3.4242070087E+00, 1.8557001915E+00, 8.5541140388E-01],
	[2.3685000000E+04, 1.5745387276E+01, 5.4551584025E+00, 3.4265422995E+00, 1.8564490264E+00, 8.5548149723E-01],
	[2.3690000000E+04, 1.5750561918E+01, 5.4550827735E+00, 3.4288786887E+00, 1.8571978159E+00, 8.5555155858E-01],
	[2.3695000000E+04, 1.5755737167E+01, 5.4550071615E+00, 3.4312161763E+00, 1.8579465599E+00, 8.5562158793E-01],
	[2.3700000000E+04, 1.5760913025E+01, 5.4549315666E+00, 3.4335547629E+00, 1.8586952581E+00, 8.5569158529E-01],
	[2.3705000000E+04, 1.5766089491E+01, 5.4548559886E+00, 3.4358944486E+00, 1.8594439106E+00, 8.5576155068E-01],
	[2.3710000000E+04, 1.5771266564E+01, 5.4547804276E+00, 3.4382352338E+00, 1.8601925170E+00, 8.5583148411E-01],
	[2.3715000000E+04, 1.5776444246E+01, 5.4547048835E+00, 3.4405771186E+00, 1.8609410774E+00, 8.5590138558E-01],
	[2.3720000000E+04, 1.5781622535E+01, 5.4546293565E+00, 3.4429201035E+00, 1.8616895915E+00, 8.5597125510E-01],
	[2.3725000000E+04, 1.5786801431E+01, 5.4545538464E+00, 3.4452641886E+00, 1.8624380592E+00, 8.5604109269E-01],
	[2.3730000000E+04, 1.5791980936E+01, 5.4544783533E+00, 3.4476093743E+00, 1.8631864804E+00, 8.5611089837E-01],
	[2.3735000000E+04, 1.5797161048E+01, 5.4544028771E+00, 3.4499556608E+00, 1.8639348550E+00, 8.5618067213E-01],
	[2.3740000000E+04, 1.5802341768E+01, 5.4543274178E+00, 3.4523030485E+00, 1.8646831828E+00, 8.5625041398E-01],
	[2.3745000000E+04, 1.5807523095E+01, 5.4542519755E+00, 3.4546515376E+00, 1.8654314637E+00, 8.5632012395E-01],
	[2.3750000000E+04, 1.5812705029E+01, 5.4541765502E+00, 3.4570011284E+00, 1.8661796976E+00, 8.5638980204E-01],
	[2.3755000000E+04, 1.5817887571E+01, 5.4541011417E+00, 3.4593518212E+00, 1.8669278842E+00, 8.5645944826E-01],
	[2.3760000000E+04, 1.5823070720E+01, 5.4540257502E+00, 3.4617036163E+00, 1.8676760236E+00, 8.5652906263E-01],
	[2.3765000000E+04, 1.5828254476E+01, 5.4539503755E+00, 3.4640565139E+00, 1.8684241155E+00, 8.5659864514E-01],
	[2.3770000000E+04, 1.5833438840E+01, 5.4538750178E+00, 3.4664105144E+00, 1.8691721598E+00, 8.5666819581E-01],
	[2.3775000000E+04, 1.5838623810E+01, 5.4537996769E+00, 3.4687656180E+00, 1.8699201564E+00, 8.5673771460E-01],
	[2.3780000000E+04, 1.5843809388E+01, 5.4537243530E+00, 3.4711218250E+00, 1.8706681051E+00, 8.5680720153E-01],
	[2.3785000000E+04, 1.5848995573E+01, 5.4536490459E+00, 3.4734791356E+00, 1.8714160058E+00, 8.5687665661E-01],
	[2.3790000000E+04, 1.5854182365E+01, 5.4535737557E+00, 3.4758375503E+00, 1.8721638584E+00, 8.5694607984E-01],
	[2.3795000000E+04, 1.5859369763E+01, 5.4534984823E+00, 3.4781970692E+00, 1.8729116628E+00, 8.5701547124E-01],
	[2.3800000000E+04, 1.5864557769E+01, 5.4534232258E+00, 3.4805576927E+00, 1.8736594187E+00, 8.5708483081E-01],
	[2.3805000000E+04, 1.5869746381E+01, 5.4533479861E+00, 3.4829194210E+00, 1.8744071262E+00, 8.5715415856E-01],
	[2.3810000000E+04, 1.5874935600E+01, 5.4532727633E+00, 3.4852822544E+00, 1.8751547849E+00, 8.5722345451E-01],
	[2.3815000000E+04, 1.5880125426E+01, 5.4531975573E+00, 3.4876461932E+00, 1.8759023949E+00, 8.5729271866E-01],
	[2.3820000000E+04, 1.5885315858E+01, 5.4531223682E+00, 3.4900112377E+00, 1.8766499559E+00, 8.5736195101E-01],
	[2.3825000000E+04, 1.5890506897E+01, 5.4530471958E+00, 3.4923773881E+00, 1.8773974679E+00, 8.5743115159E-01],
	[2.3830000000E+04, 1.5895698542E+01, 5.4529720403E+00, 3.4947446448E+00, 1.8781449307E+00, 8.5750032040E-01],
	[2.3835000000E+04, 1.5900890794E+01, 5.4528969015E+00, 3.4971130080E+00, 1.8788923442E+00, 8.5756945744E-01],
	[2.3840000000E+04, 1.5906083652E+01, 5.4528217796E+00, 3.4994824781E+00, 1.8796397082E+00, 8.5763856273E-01],
	[2.3845000000E+04, 1.5911277117E+01, 5.4527466744E+00, 3.5018530552E+00, 1.8803870226E+00, 8.5770763628E-01],
	[2.3850000000E+04, 1.5916471188E+01, 5.4526715861E+00, 3.5042247398E+00, 1.8811342873E+00, 8.5777667809E-01],
	[2.3855000000E+04, 1.5921665865E+01, 5.4525965145E+00, 3.5065975320E+00, 1.8818815021E+00, 8.5784568817E-01],
	[2.3860000000E+04, 1.5926861148E+01, 5.4525214597E+00, 3.5089714321E+00, 1.8826286669E+00, 8.5791466655E-01],
	[2.3865000000E+04, 1.5932057037E+01, 5.4524464216E+00, 3.5113464405E+00, 1.8833757816E+00, 8.5798361321E-01],
	[2.3870000000E+04, 1.5937253533E+01, 5.4523714003E+00, 3.5137225575E+00, 1.8841228461E+00, 8.5805252818E-01],
	[2.3875000000E+04, 1.5942450634E+01, 5.4522963957E+00, 3.5160997832E+00, 1.8848698601E+00, 8.5812141146E-01],
	[2.3880000000E+04, 1.5947648342E+01, 5.4522214079E+00, 3.5184781180E+00, 1.8856168237E+00, 8.5819026306E-01],
	[2.3885000000E+04, 1.5952846655E+01, 5.4521464368E+00, 3.5208575622E+00, 1.8863637365E+00, 8.5825908299E-01],
	[2.3890000000E+04, 1.5958045574E+01, 5.4520714824E+00, 3.5232381161E+00, 1.8871105986E+00, 8.5832787126E-01],
	[2.3895000000E+04, 1.5963245099E+01, 5.4519965447E+00, 3.5256197799E+00, 1.8878574098E+00, 8.5839662788E-01],
	[2.3900000000E+04, 1.5968445229E+01, 5.4519216238E+00, 3.5280025540E+00, 1.8886041699E+00, 8.5846535286E-01],
	[2.3905000000E+04, 1.5973645966E+01, 5.4518467195E+00, 3.5303864385E+00, 1.8893508788E+00, 8.5853404621E-01],
	[2.3910000000E+04, 1.5978847308E+01, 5.4517718319E+00, 3.5327714339E+00, 1.8900975365E+00, 8.5860270794E-01],
	[2.3915000000E+04, 1.5984049255E+01, 5.4516969611E+00, 3.5351575403E+00, 1.8908441426E+00, 8.5867133805E-01],
	[2.3920000000E+04, 1.5989272859E+01, 5.4516259153E+00, 3.5375447581E+00, 1.8915914503E+00, 8.5873993656E-01],
	[2.3925000000E+04, 1.5994499827E+01, 5.4515553823E+00, 3.5399330876E+00, 1.8923388056E+00, 8.5880850347E-01],
	[2.3930000000E+04, 1.5999727410E+01, 5.4514848650E+00, 3.5423225290E+00, 1.8930861099E+00, 8.5887703880E-01],
	[2.3935000000E+04, 1.6004955609E+01, 5.4514143633E+00, 3.5447130826E+00, 1.8938333633E+00, 8.5894554256E-01],
	[2.3940000000E+04, 1.6010184424E+01, 5.4513438773E+00, 3.5471047487E+00, 1.8945805655E+00, 8.5901401475E-01],
	[2.3945000000E+04, 1.6015413855E+01, 5.4512734069E+00, 3.5494975276E+00, 1.8953277164E+00, 8.5908245538E-01],
	[2.3950000000E+04, 1.6020643902E+01, 5.4512029521E+00, 3.5518914196E+00, 1.8960748159E+00, 8.5915086446E-01],
	[2.3955000000E+04, 1.6025874564E+01, 5.4511325129E+00, 3.5542864250E+00, 1.8968218639E+00, 8.5921924201E-01],
	[2.3960000000E+04, 1.6031105842E+01, 5.4510620894E+00, 3.5566825440E+00, 1.8975688603E+00, 8.5928758803E-01],
	[2.3965000000E+04, 1.6036337735E+01, 5.4509916814E+00, 3.5590797769E+00, 1.8983158048E+00, 8.5935590254E-01],
	[2.3970000000E+04, 1.6041570244E+01, 5.4509212891E+00, 3.5614781240E+00, 1.8990626974E+00, 8.5942418553E-01],
	[2.3975000000E+04, 1.6046803368E+01, 5.4508509123E+00, 3.5638775857E+00, 1.8998095379E+00, 8.5949243702E-01],
	[2.3980000000E+04, 1.6052037108E+01, 5.4507805511E+00, 3.5662781621E+00, 1.9005563263E+00, 8.5956065703E-01],
	[2.3985000000E+04, 1.6057271463E+01, 5.4507102055E+00, 3.5686798536E+00, 1.9013030623E+00, 8.5962884555E-01],
	[2.3990000000E+04, 1.6062506433E+01, 5.4506398755E+00, 3.5710826604E+00, 1.9020497459E+00, 8.5969700261E-01],
	[2.3995000000E+04, 1.6067742018E+01, 5.4505695611E+00, 3.5734865829E+00, 1.9027963770E+00, 8.5976512820E-01],
	[2.4000000000E+04, 1.6072978219E+01, 5.4504992621E+00, 3.5758916213E+00, 1.9035429553E+00, 8.5983322234E-01],
	[2.4005000000E+04, 1.6078215034E+01, 5.4504289788E+00, 3.5782977759E+00, 1.9042894808E+00, 8.5990128504E-01],
	[2.4010000000E+04, 1.6083452465E+01, 5.4503587110E+00, 3.5807050470E+00, 1.9050359533E+00, 8.5996931631E-01],
	[2.4015000000E+04, 1.6088690511E+01, 5.4502884587E+00, 3.5831134349E+00, 1.9057823727E+00, 8.6003731616E-01],
	[2.4020000000E+04, 1.6093929171E+01, 5.4502182220E+00, 3.5855229398E+00, 1.9065287389E+00, 8.6010528459E-01],
	[2.4025000000E+04, 1.6099168447E+01, 5.4501480007E+00, 3.5879335621E+00, 1.9072750517E+00, 8.6017322162E-01],
	[2.4030000000E+04, 1.6104408337E+01, 5.4500777950E+00, 3.5903453020E+00, 1.9080213110E+00, 8.6024112726E-01],
	[2.4035000000E+04, 1.6109648842E+01, 5.4500076048E+00, 3.5927581598E+00, 1.9087675168E+00, 8.6030900152E-01],
	[2.4040000000E+04, 1.6114889962E+01, 5.4499374301E+00, 3.5951721359E+00, 1.9095136687E+00, 8.6037684440E-01],
	[2.4045000000E+04, 1.6120131696E+01, 5.4498672709E+00, 3.5975872304E+00, 1.9102597669E+00, 8.6044465591E-01],
	[2.4050000000E+04, 1.6125374045E+01, 5.4497971272E+00, 3.6000034437E+00, 1.9110058110E+00, 8.6051243607E-01],
	[2.4055000000E+04, 1.6130617008E+01, 5.4497269990E+00, 3.6024207760E+00, 1.9117518009E+00, 8.6058018489E-01],
	[2.4060000000E+04, 1.6135860586E+01, 5.4496568863E+00, 3.6048392277E+00, 1.9124977367E+00, 8.6064790237E-01],
	[2.4065000000E+04, 1.6141104779E+01, 5.4495867890E+00, 3.6072587990E+00, 1.9132436180E+00, 8.6071558852E-01],
	[2.4070000000E+04, 1.6146349586E+01, 5.4495167072E+00, 3.6096794902E+00, 1.9139894448E+00, 8.6078324336E-01],
	[2.4075000000E+04, 1.6151595007E+01, 5.4494466408E+00, 3.6121013016E+00, 1.9147352169E+00, 8.6085086690E-01],
	[2.4080000000E+04, 1.6156841042E+01, 5.4493765899E+00, 3.6145242334E+00, 1.9154809343E+00, 8.6091845914E-01],
	[2.4085000000E+04, 1.6162087691E+01, 5.4493065545E+00, 3.6169482861E+00, 1.9162265968E+00, 8.6098602009E-01],
	[2.4090000000E+04, 1.6167334955E+01, 5.4492365345E+00, 3.6193734598E+00, 1.9169722043E+00, 8.6105354977E-01],
	[2.4095000000E+04, 1.6172582833E+01, 5.4491665299E+00, 3.6217997548E+00, 1.9177177566E+00, 8.6112104818E-01],
	[2.4100000000E+04, 1.6177831325E+01, 5.4490965407E+00, 3.6242271714E+00, 1.9184632536E+00, 8.6118851533E-01],
	[2.4105000000E+04, 1.6183080430E+01, 5.4490265670E+00, 3.6266557100E+00, 1.9192086952E+00, 8.6125595123E-01],
	[2.4110000000E+04, 1.6188330150E+01, 5.4489566086E+00, 3.6290853707E+00, 1.9199540812E+00, 8.6132335590E-01],
	[2.4115000000E+04, 1.6193580484E+01, 5.4488866657E+00, 3.6315161539E+00, 1.9206994116E+00, 8.6139072934E-01],
	[2.4120000000E+04, 1.6198831431E+01, 5.4488167382E+00, 3.6339480599E+00, 1.9214446862E+00, 8.6145807157E-01],
	[2.4125000000E+04, 1.6204082992E+01, 5.4487468260E+00, 3.6363810889E+00, 1.9221899048E+00, 8.6152538258E-01],
	[2.4130000000E+04, 1.6209335167E+01, 5.4486769293E+00, 3.6388152412E+00, 1.9229350674E+00, 8.6159266240E-01],
	[2.4135000000E+04, 1.6214587956E+01, 5.4486070479E+00, 3.6412505172E+00, 1.9236801738E+00, 8.6165991104E-01],
	[2.4140000000E+04, 1.6219841358E+01, 5.4485371819E+00, 3.6436869170E+00, 1.9244252239E+00, 8.6172712849E-01],
	[2.4145000000E+04, 1.6225095373E+01, 5.4484673313E+00, 3.6461244410E+00, 1.9251702176E+00, 8.6179431478E-01],
	[2.4150000000E+04, 1.6230350002E+01, 5.4483974960E+00, 3.6485630895E+00, 1.9259151547E+00, 8.6186146990E-01],
	[2.4155000000E+04, 1.6235605245E+01, 5.4483276761E+00, 3.6510028628E+00, 1.9266600351E+00, 8.6192859388E-01],
	[2.4160000000E+04, 1.6240861101E+01, 5.4482578715E+00, 3.6534437611E+00, 1.9274048587E+00, 8.6199568673E-01],
	[2.4165000000E+04, 1.6246117570E+01, 5.4481880822E+00, 3.6558857847E+00, 1.9281496253E+00, 8.6206274844E-01],
	[2.4170000000E+04, 1.6251374652E+01, 5.4481183083E+00, 3.6583289339E+00, 1.9288943349E+00, 8.6212977904E-01],
	[2.4175000000E+04, 1.6256632348E+01, 5.4480485497E+00, 3.6607732090E+00, 1.9296389873E+00, 8.6219677853E-01],
	[2.4180000000E+04, 1.6261890657E+01, 5.4479788065E+00, 3.6632186103E+00, 1.9303835824E+00, 8.6226374692E-01],
	[2.4185000000E+04, 1.6267149579E+01, 5.4479090785E+00, 3.6656651381E+00, 1.9311281200E+00, 8.6233068422E-01],
	[2.4190000000E+04, 1.6272409114E+01, 5.4478393659E+00, 3.6681127926E+00, 1.9318726000E+00, 8.6239759044E-01],
	[2.4195000000E+04, 1.6277669262E+01, 5.4477696685E+00, 3.6705615741E+00, 1.9326170223E+00, 8.6246446560E-01],
	[2.4200000000E+04, 1.6282930022E+01, 5.4476999865E+00, 3.6730114830E+00, 1.9333613868E+00, 8.6253130970E-01],
	[2.4205000000E+04, 1.6288191396E+01, 5.4476303197E+00, 3.6754625195E+00, 1.9341056934E+00, 8.6259812275E-01],
	[2.4210000000E+04, 1.6293453383E+01, 5.4475606682E+00, 3.6779146838E+00, 1.9348499418E+00, 8.6266490476E-01],
	[2.4215000000E+04, 1.6298715982E+01, 5.4474910320E+00, 3.6803679764E+00, 1.9355941321E+00, 8.6273165575E-01],
	[2.4220000000E+04, 1.6303979194E+01, 5.4474214110E+00, 3.6828223974E+00, 1.9363382640E+00, 8.6279837571E-01],
	[2.4225000000E+04, 1.6309243018E+01, 5.4473518053E+00, 3.6852779471E+00, 1.9370823375E+00, 8.6286506467E-01],
	[2.4230000000E+04, 1.6314507456E+01, 5.4472822149E+00, 3.6877346259E+00, 1.9378263524E+00, 8.6293172264E-01],
	[2.4235000000E+04, 1.6319772505E+01, 5.4472126397E+00, 3.6901924340E+00, 1.9385703085E+00, 8.6299834961E-01],
	[2.4240000000E+04, 1.6325038168E+01, 5.4471430798E+00, 3.6926513717E+00, 1.9393142059E+00, 8.6306494561E-01],
	[2.4245000000E+04, 1.6330304442E+01, 5.4470735351E+00, 3.6951114393E+00, 1.9400580443E+00, 8.6313151064E-01],
	[2.4250000000E+04, 1.6335571329E+01, 5.4470040056E+00, 3.6975726370E+00, 1.9408018236E+00, 8.6319804471E-01],
	[2.4255000000E+04, 1.6340838829E+01, 5.4469344913E+00, 3.7000349653E+00, 1.9415455436E+00, 8.6326454784E-01],
	[2.4260000000E+04, 1.6346106940E+01, 5.4468649923E+00, 3.7024984242E+00, 1.9422892044E+00, 8.6333102003E-01],
	[2.4265000000E+04, 1.6351375664E+01, 5.4467955085E+00, 3.7049630142E+00, 1.9430328057E+00, 8.6339746129E-01],
	[2.4270000000E+04, 1.6356645000E+01, 5.4467260398E+00, 3.7074287355E+00, 1.9437763474E+00, 8.6346387164E-01],
	[2.4275000000E+04, 1.6361914948E+01, 5.4466565864E+00, 3.7098955884E+00, 1.9445198294E+00, 8.6353025108E-01],
	[2.4280000000E+04, 1.6367185508E+01, 5.4465871481E+00, 3.7123635732E+00, 1.9452632515E+00, 8.6359659963E-01],
	[2.4285000000E+04, 1.6372456681E+01, 5.4465177251E+00, 3.7148326902E+00, 1.9460066137E+00, 8.6366291729E-01],
	[2.4290000000E+04, 1.6377728465E+01, 5.4464483172E+00, 3.7173029396E+00, 1.9467499159E+00, 8.6372920407E-01],
	[2.4295000000E+04, 1.6383000861E+01, 5.4463789245E+00, 3.7197743217E+00, 1.9474931578E+00, 8.6379545999E-01],
	[2.4300000000E+04, 1.6388273868E+01, 5.4463095469E+00, 3.7222468369E+00, 1.9482363394E+00, 8.6386168505E-01],
	[2.4305000000E+04, 1.6393568725E+01, 5.4462439276E+00, 3.7247204854E+00, 1.9489802400E+00, 8.6392787927E-01],
	[2.4310000000E+04, 1.6398867020E+01, 5.4461788190E+00, 3.7271952675E+00, 1.9497241843E+00, 8.6399404265E-01],
	[2.4315000000E+04, 1.6404165937E+01, 5.4461137245E+00, 3.7296711835E+00, 1.9504680690E+00, 8.6406017521E-01],
	[2.4320000000E+04, 1.6409465476E+01, 5.4460486442E+00, 3.7321482336E+00, 1.9512118937E+00, 8.6412627696E-01],
	[2.4325000000E+04, 1.6414765637E+01, 5.4459835781E+00, 3.7346264182E+00, 1.9519556584E+00, 8.6419234790E-01],
	[2.4330000000E+04, 1.6420066421E+01, 5.4459185261E+00, 3.7371057376E+00, 1.9526993631E+00, 8.6425838805E-01],
	[2.4335000000E+04, 1.6425367826E+01, 5.4458534883E+00, 3.7395861919E+00, 1.9534430075E+00, 8.6432439741E-01],
	[2.4340000000E+04, 1.6430669854E+01, 5.4457884646E+00, 3.7420677816E+00, 1.9541865915E+00, 8.6439037600E-01],
	[2.4345000000E+04, 1.6435972503E+01, 5.4457234550E+00, 3.7445505069E+00, 1.9549301151E+00, 8.6445632383E-01],
	[2.4350000000E+04, 1.6441275774E+01, 5.4456584596E+00, 3.7470343680E+00, 1.9556735780E+00, 8.6452224091E-01],
	[2.4355000000E+04, 1.6446579667E+01, 5.4455934782E+00, 3.7495193654E+00, 1.9564169802E+00, 8.6458812725E-01],
	[2.4360000000E+04, 1.6451884182E+01, 5.4455285110E+00, 3.7520054991E+00, 1.9571603216E+00, 8.6465398285E-01],
	[2.4365000000E+04, 1.6457189318E+01, 5.4454635579E+00, 3.7544927697E+00, 1.9579036020E+00, 8.6471980773E-01],
	[2.4370000000E+04, 1.6462495076E+01, 5.4453986189E+00, 3.7569811772E+00, 1.9586468213E+00, 8.6478560190E-01],
	[2.4375000000E+04, 1.6467801455E+01, 5.4453336940E+00, 3.7594707221E+00, 1.9593899794E+00, 8.6485136537E-01],
	[2.4380000000E+04, 1.6473108456E+01, 5.4452687832E+00, 3.7619614045E+00, 1.9601330761E+00, 8.6491709816E-01],
	[2.4385000000E+04, 1.6478416079E+01, 5.4452038865E+00, 3.7644532248E+00, 1.9608761113E+00, 8.6498280026E-01],
	[2.4390000000E+04, 1.6483724323E+01, 5.4451390039E+00, 3.7669461833E+00, 1.9616190850E+00, 8.6504847169E-01],
	[2.4395000000E+04, 1.6489033188E+01, 5.4450741353E+00, 3.7694402803E+00, 1.9623619969E+00, 8.6511411246E-01],
	[2.4400000000E+04, 1.6494342674E+01, 5.4450092808E+00, 3.7719355160E+00, 1.9631048471E+00, 8.6517972259E-01],
	[2.4405000000E+04, 1.6499652782E+01, 5.4449444403E+00, 3.7744318907E+00, 1.9638476352E+00, 8.6524530207E-01],
	[2.4410000000E+04, 1.6504963511E+01, 5.4448796139E+00, 3.7769294047E+00, 1.9645903613E+00, 8.6531085093E-01],
	[2.4415000000E+04, 1.6510274861E+01, 5.4448148016E+00, 3.7794280583E+00, 1.9653330252E+00, 8.6537636917E-01],
	[2.4420000000E+04, 1.6515586832E+01, 5.4447500033E+00, 3.7819278518E+00, 1.9660756268E+00, 8.6544185681E-01],
	[2.4425000000E+04, 1.6520899424E+01, 5.4446852190E+00, 3.7844287855E+00, 1.9668181659E+00, 8.6550731385E-01],
	[2.4430000000E+04, 1.6526212638E+01, 5.4446204488E+00, 3.7869308596E+00, 1.9675606424E+00, 8.6557274030E-01],
	[2.4435000000E+04, 1.6531526472E+01, 5.4445556926E+00, 3.7894340745E+00, 1.9683030563E+00, 8.6563813618E-01],
	[2.4440000000E+04, 1.6536840926E+01, 5.4444909504E+00, 3.7919384304E+00, 1.9690454074E+00, 8.6570350149E-01],
	[2.4445000000E+04, 1.6542156002E+01, 5.4444262222E+00, 3.7944439276E+00, 1.9697876955E+00, 8.6576883625E-01],
	[2.4450000000E+04, 1.6547471698E+01, 5.4443615081E+00, 3.7969505664E+00, 1.9705299206E+00, 8.6583414046E-01],
	[2.4455000000E+04, 1.6552788016E+01, 5.4442968079E+00, 3.7994583471E+00, 1.9712720825E+00, 8.6589941414E-01],
	[2.4460000000E+04, 1.6558104953E+01, 5.4442321217E+00, 3.8019672699E+00, 1.9720141811E+00, 8.6596465730E-01],
	[2.4465000000E+04, 1.6563422512E+01, 5.4441674496E+00, 3.8044773353E+00, 1.9727562163E+00, 8.6602986994E-01],
	[2.4470000000E+04, 1.6568740690E+01, 5.4441027914E+00, 3.8069885433E+00, 1.9734981880E+00, 8.6609505209E-01],
	[2.4475000000E+04, 1.6574059490E+01, 5.4440381471E+00, 3.8095008944E+00, 1.9742400960E+00, 8.6616020374E-01],
	[2.4480000000E+04, 1.6579378910E+01, 5.4439735169E+00, 3.8120143888E+00, 1.9749819403E+00, 8.6622532491E-01],
	[2.4485000000E+04, 1.6584698950E+01, 5.4439089006E+00, 3.8145290267E+00, 1.9757237206E+00, 8.6629041561E-01],
	[2.4490000000E+04, 1.6590019610E+01, 5.4438442983E+00, 3.8170448086E+00, 1.9764654369E+00, 8.6635547586E-01],
	[2.4495000000E+04, 1.6595340891E+01, 5.4437797099E+00, 3.8195617346E+00, 1.9772070891E+00, 8.6642050565E-01],
	[2.4500000000E+04, 1.6600662792E+01, 5.4437151355E+00, 3.8220798051E+00, 1.9779486771E+00, 8.6648550500E-01],
	[2.4505000000E+04, 1.6605985313E+01, 5.4436505750E+00, 3.8245990204E+00, 1.9786902006E+00, 8.6655047393E-01],
	[2.4510000000E+04, 1.6611308454E+01, 5.4435860285E+00, 3.8271193806E+00, 1.9794316597E+00, 8.6661541244E-01],
	[2.4515000000E+04, 1.6616632215E+01, 5.4435214959E+00, 3.8296408862E+00, 1.9801730541E+00, 8.6668032054E-01],
	[2.4520000000E+04, 1.6621956596E+01, 5.4434569772E+00, 3.8321635374E+00, 1.9809143839E+00, 8.6674519825E-01],
	[2.4525000000E+04, 1.6627281597E+01, 5.4433924725E+00, 3.8346873345E+00, 1.9816556487E+00, 8.6681004557E-01],
	[2.4530000000E+04, 1.6632607218E+01, 5.4433279816E+00, 3.8372122777E+00, 1.9823968486E+00, 8.6687486252E-01],
	[2.4535000000E+04, 1.6637933459E+01, 5.4432635047E+00, 3.8397383674E+00, 1.9831379834E+00, 8.6693964910E-01],
	[2.4540000000E+04, 1.6643260319E+01, 5.4431990416E+00, 3.8422656038E+00, 1.9838790529E+00, 8.6700440533E-01],
	[2.4545000000E+04, 1.6648587800E+01, 5.4431345925E+00, 3.8447939873E+00, 1.9846200572E+00, 8.6706913122E-01],
	[2.4550000000E+04, 1.6653915900E+01, 5.4430701573E+00, 3.8473235181E+00, 1.9853609959E+00, 8.6713382678E-01],
	[2.4555000000E+04, 1.6659244619E+01, 5.4430057359E+00, 3.8498541965E+00, 1.9861018691E+00, 8.6719849201E-01],
	[2.4560000000E+04, 1.6664573958E+01, 5.4429413284E+00, 3.8523860228E+00, 1.9868426766E+00, 8.6726312693E-01],
	[2.4565000000E+04, 1.6669903917E+01, 5.4428769348E+00, 3.8549189972E+00, 1.9875834184E+00, 8.6732773156E-01],
	[2.4570000000E+04, 1.6675234495E+01, 5.4428125550E+00, 3.8574531202E+00, 1.9883240941E+00, 8.6739230589E-01],
	[2.4575000000E+04, 1.6680565692E+01, 5.4427481892E+00, 3.8599883918E+00, 1.9890647038E+00, 8.6745684994E-01],
	[2.4580000000E+04, 1.6685897509E+01, 5.4426838371E+00, 3.8625248125E+00, 1.9898052474E+00, 8.6752136373E-01],
	[2.4585000000E+04, 1.6691229945E+01, 5.4426194990E+00, 3.8650623825E+00, 1.9905457247E+00, 8.6758584726E-01],
	[2.4590000000E+04, 1.6696563000E+01, 5.4425551746E+00, 3.8676011022E+00, 1.9912861355E+00, 8.6765030054E-01],
	[2.4595000000E+04, 1.6701896675E+01, 5.4424908641E+00, 3.8701409717E+00, 1.9920264799E+00, 8.6771472359E-01],
	[2.4600000000E+04, 1.6707230968E+01, 5.4424265674E+00, 3.8726819914E+00, 1.9927667576E+00, 8.6777911641E-01],
	[2.4605000000E+04, 1.6712565881E+01, 5.4423622846E+00, 3.8752241615E+00, 1.9935069685E+00, 8.6784347902E-01],
	[2.4610000000E+04, 1.6717901412E+01, 5.4422980156E+00, 3.8777674824E+00, 1.9942471126E+00, 8.6790781143E-01],
	[2.4615000000E+04, 1.6723237563E+01, 5.4422337604E+00, 3.8803119544E+00, 1.9949871897E+00, 8.6797211364E-01],
	[2.4620000000E+04, 1.6728574332E+01, 5.4421695190E+00, 3.8828575777E+00, 1.9957271996E+00, 8.6803638567E-01],
	[2.4625000000E+04, 1.6733911721E+01, 5.4421052914E+00, 3.8854043526E+00, 1.9964671424E+00, 8.6810062753E-01],
	[2.4630000000E+04, 1.6739249728E+01, 5.4420410776E+00, 3.8879522793E+00, 1.9972070177E+00, 8.6816483923E-01],
	[2.4635000000E+04, 1.6744588354E+01, 5.4419768776E+00, 3.8905013583E+00, 1.9979468257E+00, 8.6822902078E-01],
	[2.4640000000E+04, 1.6749927598E+01, 5.4419126914E+00, 3.8930515897E+00, 1.9986865660E+00, 8.6829317219E-01],
	[2.4645000000E+04, 1.6755267461E+01, 5.4418485190E+00, 3.8956029739E+00, 1.9994262386E+00, 8.6835729347E-01],
	[2.4650000000E+04, 1.6760607943E+01, 5.4417843603E+00, 3.8981555111E+00, 2.0001658434E+00, 8.6842138463E-01],
	[2.4655000000E+04, 1.6765949043E+01, 5.4417202154E+00, 3.9007092017E+00, 2.0009053803E+00, 8.6848544569E-01],
	[2.4660000000E+04, 1.6771290762E+01, 5.4416560843E+00, 3.9032640459E+00, 2.0016448492E+00, 8.6854947666E-01],
	[2.4665000000E+04, 1.6776633099E+01, 5.4415919669E+00, 3.9058200439E+00, 2.0023842498E+00, 8.6861347754E-01],
	[2.4670000000E+04, 1.6781976055E+01, 5.4415278633E+00, 3.9083771962E+00, 2.0031235822E+00, 8.6867744834E-01],
	[2.4675000000E+04, 1.6787319629E+01, 5.4414637734E+00, 3.9109355029E+00, 2.0038628462E+00, 8.6874138908E-01],
	[2.4680000000E+04, 1.6792663821E+01, 5.4413996973E+00, 3.9134949644E+00, 2.0046020416E+00, 8.6880529977E-01],
	[2.4685000000E+04, 1.6798008631E+01, 5.4413356349E+00, 3.9160555809E+00, 2.0053411684E+00, 8.6886918042E-01],
	[2.4690000000E+04, 1.6803354060E+01, 5.4412715862E+00, 3.9186173528E+00, 2.0060802265E+00, 8.6893303104E-01],
	[2.4695000000E+04, 1.6808715705E+01, 5.4412102300E+00, 3.9211802803E+00, 2.0068198024E+00, 8.6899685164E-01],
	[2.4700000000E+04, 1.6814086690E+01, 5.4411503829E+00, 3.9237443637E+00, 2.0075596379E+00, 8.6906064223E-01],
	[2.4705000000E+04, 1.6819458304E+01, 5.4410905486E+00, 3.9263096033E+00, 2.0082994052E+00, 8.6912440282E-01],
	[2.4710000000E+04, 1.6824830546E+01, 5.4410307271E+00, 3.9288759993E+00, 2.0090391042E+00, 8.6918813343E-01],
	[2.4715000000E+04, 1.6830203416E+01, 5.4409709183E+00, 3.9314435522E+00, 2.0097787348E+00, 8.6925183406E-01],
	[2.4720000000E+04, 1.6835576915E+01, 5.4409111223E+00, 3.9340122621E+00, 2.0105182970E+00, 8.6931550473E-01],
	[2.4725000000E+04, 1.6840951042E+01, 5.4408513390E+00, 3.9365821293E+00, 2.0112577906E+00, 8.6937914544E-01],
	[2.4730000000E+04, 1.6846325798E+01, 5.4407915684E+00, 3.9391531541E+00, 2.0119972154E+00, 8.6944275621E-01],
	[2.4735000000E+04, 1.6851701182E+01, 5.4407318107E+00, 3.9417253369E+00, 2.0127365714E+00, 8.6950633704E-01],
	[2.4740000000E+04, 1.6857077194E+01, 5.4406720656E+00, 3.9442986779E+00, 2.0134758584E+00, 8.6956988796E-01],
	[2.4745000000E+04, 1.6862453834E+01, 5.4406123333E+00, 3.9468731773E+00, 2.0142150763E+00, 8.6963340896E-01],
	[2.4750000000E+04, 1.6867831102E+01, 5.4405526137E+00, 3.9494488355E+00, 2.0149542251E+00, 8.6969690007E-01],
	[2.4755000000E+04, 1.6873208998E+01, 5.4404929068E+00, 3.9520256528E+00, 2.0156933046E+00, 8.6976036129E-01],
	[2.4760000000E+04, 1.6878587523E+01, 5.4404332126E+00, 3.9546036294E+00, 2.0164323146E+00, 8.6982379263E-01],
	[2.4765000000E+04, 1.6883966675E+01, 5.4403735312E+00, 3.9571827656E+00, 2.0171712551E+00, 8.6988719410E-01],
	[2.4770000000E+04, 1.6889346455E+01, 5.4403138624E+00, 3.9597630618E+00, 2.0179101260E+00, 8.6995056572E-01],
	[2.4775000000E+04, 1.6894726863E+01, 5.4402542063E+00, 3.9623445182E+00, 2.0186489271E+00, 8.7001390749E-01],
	[2.4780000000E+04, 1.6900107898E+01, 5.4401945630E+00, 3.9649271350E+00, 2.0193876583E+00, 8.7007721943E-01],
	[2.4785000000E+04, 1.6905489561E+01, 5.4401349323E+00, 3.9675109127E+00, 2.0201263195E+00, 8.7014050155E-01],
	[2.4790000000E+04, 1.6910871852E+01, 5.4400753143E+00, 3.9700958514E+00, 2.0208649107E+00, 8.7020375386E-01],
	[2.4795000000E+04, 1.6916254771E+01, 5.4400157090E+00, 3.9726819514E+00, 2.0216034316E+00, 8.7026697637E-01],
	[2.4800000000E+04, 1.6921638317E+01, 5.4399561163E+00, 3.9752692131E+00, 2.0223418821E+00, 8.7033016909E-01],
	[2.4805000000E+04, 1.6927022491E+01, 5.4398965363E+00, 3.9778576368E+00, 2.0230802623E+00, 8.7039333203E-01],
	[2.4810000000E+04, 1.6932407292E+01, 5.4398369690E+00, 3.9804472226E+00, 2.0238185718E+00, 8.7045646520E-01],
	[2.4815000000E+04, 1.6937792720E+01, 5.4397774143E+00, 3.9830379709E+00, 2.0245568107E+00, 8.7051956861E-01],
	[2.4820000000E+04, 1.6943178776E+01, 5.4397178723E+00, 3.9856298820E+00, 2.0252949788E+00, 8.7058264229E-01],
	[2.4825000000E+04, 1.6948565459E+01, 5.4396583429E+00, 3.9882229562E+00, 2.0260330760E+00, 8.7064568622E-01],
	[2.4830000000E+04, 1.6953952769E+01, 5.4395988262E+00, 3.9908171938E+00, 2.0267711021E+00, 8.7070870044E-01],
	[2.4835000000E+04, 1.6959340707E+01, 5.4395393221E+00, 3.9934125950E+00, 2.0275090571E+00, 8.7077168494E-01],
	[2.4840000000E+04, 1.6964729271E+01, 5.4394798306E+00, 3.9960091601E+00, 2.0282469409E+00, 8.7083463974E-01],
	[2.4845000000E+04, 1.6970118463E+01, 5.4394203518E+00, 3.9986068894E+00, 2.0289847533E+00, 8.7089756485E-01],
	[2.4850000000E+04, 1.6975508282E+01, 5.4393608856E+00, 4.0012057833E+00, 2.0297224943E+00, 8.7096046029E-01],
	[2.4855000000E+04, 1.6980898727E+01, 5.4393014319E+00, 4.0038058419E+00, 2.0304601637E+00, 8.7102332605E-01],
	[2.4860000000E+04, 1.6986289800E+01, 5.4392419909E+00, 4.0064070657E+00, 2.0311977613E+00, 8.7108616216E-01],
	[2.4865000000E+04, 1.6991681499E+01, 5.4391825625E+00, 4.0090094548E+00, 2.0319352872E+00, 8.7114896862E-01],
	[2.4870000000E+04, 1.6997073825E+01, 5.4391231467E+00, 4.0116130095E+00, 2.0326727411E+00, 8.7121174545E-01],
	[2.4875000000E+04, 1.7002466778E+01, 5.4390637435E+00, 4.0142177302E+00, 2.0334101230E+00, 8.7127449266E-01],
	[2.4880000000E+04, 1.7007860358E+01, 5.4390043529E+00, 4.0168236171E+00, 2.0341474327E+00, 8.7133721026E-01],
	[2.4885000000E+04, 1.7013254564E+01, 5.4389449749E+00, 4.0194306705E+00, 2.0348846702E+00, 8.7139989825E-01],
	[2.4890000000E+04, 1.7018649397E+01, 5.4388856094E+00, 4.0220388908E+00, 2.0356218353E+00, 8.7146255665E-01],
	[2.4895000000E+04, 1.7024044857E+01, 5.4388262565E+00, 4.0246482781E+00, 2.0363589279E+00, 8.7152518548E-01],
	[2.4900000000E+04, 1.7029440943E+01, 5.4387669162E+00, 4.0272588328E+00, 2.0370959479E+00, 8.7158778474E-01],
	[2.4905000000E+04, 1.7034837655E+01, 5.4387075884E+00, 4.0298705552E+00, 2.0378328952E+00, 8.7165035444E-01],
	[2.4910000000E+04, 1.7040234994E+01, 5.4386482732E+00, 4.0324834455E+00, 2.0385697697E+00, 8.7171289460E-01],
	[2.4915000000E+04, 1.7045632959E+01, 5.4385889706E+00, 4.0350975040E+00, 2.0393065712E+00, 8.7177540522E-01],
	[2.4920000000E+04, 1.7051031550E+01, 5.4385296804E+00, 4.0377127311E+00, 2.0400432997E+00, 8.7183788632E-01],
	[2.4925000000E+04, 1.7056430768E+01, 5.4384704029E+00, 4.0403291270E+00, 2.0407799550E+00, 8.7190033791E-01],
	[2.4930000000E+04, 1.7061830611E+01, 5.4384111378E+00, 4.0429466919E+00, 2.0415165370E+00, 8.7196276000E-01],
	[2.4935000000E+04, 1.7067231081E+01, 5.4383518853E+00, 4.0455654263E+00, 2.0422530457E+00, 8.7202515260E-01],
	[2.4940000000E+04, 1.7072632177E+01, 5.4382926454E+00, 4.0481853303E+00, 2.0429894809E+00, 8.7208751572E-01],
	[2.4945000000E+04, 1.7078033899E+01, 5.4382334179E+00, 4.0508064043E+00, 2.0437258424E+00, 8.7214984937E-01],
	[2.4950000000E+04, 1.7083436247E+01, 5.4381742030E+00, 4.0534286486E+00, 2.0444621303E+00, 8.7221215357E-01],
	[2.4955000000E+04, 1.7088839220E+01, 5.4381150005E+00, 4.0560520634E+00, 2.0451983443E+00, 8.7227442833E-01],
	[2.4960000000E+04, 1.7094242820E+01, 5.4380558106E+00, 4.0586766490E+00, 2.0459344843E+00, 8.7233667365E-01],
	[2.4965000000E+04, 1.7099647045E+01, 5.4379966332E+00, 4.0613024057E+00, 2.0466705503E+00, 8.7239888955E-01],
	[2.4970000000E+04, 1.7105051897E+01, 5.4379374683E+00, 4.0639293338E+00, 2.0474065422E+00, 8.7246107604E-01],
	[2.4975000000E+04, 1.7110457373E+01, 5.4378783158E+00, 4.0665574335E+00, 2.0481424598E+00, 8.7252323313E-01],
	[2.4980000000E+04, 1.7115863476E+01, 5.4378191759E+00, 4.0691867053E+00, 2.0488783030E+00, 8.7258536083E-01],
	[2.4985000000E+04, 1.7121270204E+01, 5.4377600484E+00, 4.0718171493E+00, 2.0496140717E+00, 8.7264745916E-01],
	[2.4990000000E+04, 1.7126677557E+01, 5.4377009334E+00, 4.0744487659E+00, 2.0503497657E+00, 8.7270952812E-01],
	[2.4995000000E+04, 1.7132085536E+01, 5.4376418309E+00, 4.0770815552E+00, 2.0510853851E+00, 8.7277156772E-01],
	[2.5000000000E+04, 1.7137494141E+01, 5.4375827408E+00, 4.0797155177E+00, 2.0518209297E+00, 8.7283357798E-01],
	[2.5005000000E+04, 1.7142903371E+01, 5.4375236632E+00, 4.0823570924E+00, 2.0525580270E+00, 8.7289555891E-01],
	[2.5010000000E+04, 1.7148313226E+01, 5.4374645980E+00, 4.0849998480E+00, 2.0532950492E+00, 8.7295751052E-01],
	[2.5015000000E+04, 1.7153723706E+01, 5.4374055453E+00, 4.0876437847E+00, 2.0540319962E+00, 8.7301943282E-01],
	[2.5020000000E+04, 1.7159134812E+01, 5.4373465050E+00, 4.0902889030E+00, 2.0547688678E+00, 8.7308132583E-01],
	[2.5025000000E+04, 1.7164546543E+01, 5.4372874772E+00, 4.0929352029E+00, 2.0555056640E+00, 8.7314318954E-01],
	[2.5030000000E+04, 1.7169958899E+01, 5.4372284618E+00, 4.0955826849E+00, 2.0562423847E+00, 8.7320502398E-01],
	[2.5035000000E+04, 1.7175371880E+01, 5.4371694589E+00, 4.0982313492E+00, 2.0569790297E+00, 8.7326682916E-01],
	[2.5040000000E+04, 1.7180785486E+01, 5.4371104683E+00, 4.1008811962E+00, 2.0577155990E+00, 8.7332860508E-01],
	[2.5045000000E+04, 1.7186199717E+01, 5.4370514902E+00, 4.1035322261E+00, 2.0584520923E+00, 8.7339035177E-01],
	[2.5050000000E+04, 1.7191614572E+01, 5.4369925245E+00, 4.1061844391E+00, 2.0591885097E+00, 8.7345206922E-01],
	[2.5055000000E+04, 1.7197030053E+01, 5.4369335712E+00, 4.1088378357E+00, 2.0599248510E+00, 8.7351375745E-01],
	[2.5060000000E+04, 1.7202446159E+01, 5.4368746303E+00, 4.1114924161E+00, 2.0606611160E+00, 8.7357541648E-01],
	[2.5065000000E+04, 1.7207862889E+01, 5.4368157018E+00, 4.1141481805E+00, 2.0613973048E+00, 8.7363704631E-01],
	[2.5070000000E+04, 1.7213280244E+01, 5.4367567857E+00, 4.1168051293E+00, 2.0621334171E+00, 8.7369864695E-01],
	[2.5075000000E+04, 1.7218698223E+01, 5.4366978819E+00, 4.1194632628E+00, 2.0628694528E+00, 8.7376021842E-01],
	[2.5080000000E+04, 1.7224116827E+01, 5.4366389906E+00, 4.1221225813E+00, 2.0636054120E+00, 8.7382176073E-01],
	[2.5085000000E+04, 1.7229536056E+01, 5.4365801116E+00, 4.1247830850E+00, 2.0643412943E+00, 8.7388327389E-01],
	[2.5090000000E+04, 1.7234959352E+01, 5.4365218232E+00, 4.1274447742E+00, 2.0650772327E+00, 8.7394475791E-01],
	[2.5095000000E+04, 1.7240404293E+01, 5.4364670752E+00, 4.1301076492E+00, 2.0658139054E+00, 8.7400621280E-01],
	[2.5100000000E+04, 1.7245849868E+01, 5.4364123387E+00, 4.1327717104E+00, 2.0665505020E+00, 8.7406763857E-01],
	[2.5105000000E+04, 1.7251296079E+01, 5.4363576136E+00, 4.1354369580E+00, 2.0672870224E+00, 8.7412903524E-01],
	[2.5110000000E+04, 1.7256742924E+01, 5.4363029000E+00, 4.1381033923E+00, 2.0680234663E+00, 8.7419040282E-01],
	[2.5115000000E+04, 1.7262190404E+01, 5.4362481978E+00, 4.1407710135E+00, 2.0687598339E+00, 8.7425174131E-01],
	[2.5120000000E+04, 1.7267638519E+01, 5.4361935071E+00, 4.1434398221E+00, 2.0694961248E+00, 8.7431305073E-01],
	[2.5125000000E+04, 1.7273087268E+01, 5.4361388278E+00, 4.1461098182E+00, 2.0702323391E+00, 8.7437433110E-01],
	[2.5130000000E+04, 1.7278536652E+01, 5.4360841599E+00, 4.1487810022E+00, 2.0709684765E+00, 8.7443558241E-01],
	[2.5135000000E+04, 1.7283986671E+01, 5.4360295034E+00, 4.1514533744E+00, 2.0717045371E+00, 8.7449680469E-01],
	[2.5140000000E+04, 1.7289437324E+01, 5.4359748584E+00, 4.1541269350E+00, 2.0724405207E+00, 8.7455799794E-01],
	[2.5145000000E+04, 1.7294888611E+01, 5.4359202248E+00, 4.1568016844E+00, 2.0731764271E+00, 8.7461916218E-01],
	[2.5150000000E+04, 1.7300340533E+01, 5.4358656026E+00, 4.1594776228E+00, 2.0739122563E+00, 8.7468029741E-01],
	[2.5155000000E+04, 1.7305793089E+01, 5.4358109918E+00, 4.1621547505E+00, 2.0746480082E+00, 8.7474140366E-01],
	[2.5160000000E+04, 1.7311246280E+01, 5.4357563924E+00, 4.1648330678E+00, 2.0753836826E+00, 8.7480248092E-01],
	[2.5165000000E+04, 1.7316700104E+01, 5.4357018044E+00, 4.1675125751E+00, 2.0761192795E+00, 8.7486352922E-01],
	[2.5170000000E+04, 1.7322154563E+01, 5.4356472278E+00, 4.1701932725E+00, 2.0768547988E+00, 8.7492454855E-01],
	[2.5175000000E+04, 1.7327609656E+01, 5.4355926626E+00, 4.1728751604E+00, 2.0775902402E+00, 8.7498553895E-01],
	[2.5180000000E+04, 1.7333065383E+01, 5.4355381088E+00, 4.1755582392E+00, 2.0783256038E+00, 8.7504650041E-01],
	[2.5185000000E+04, 1.7338521744E+01, 5.4354835663E+00, 4.1782425090E+00, 2.0790608894E+00, 8.7510743294E-01],
	[2.5190000000E+04, 1.7343978739E+01, 5.4354290353E+00, 4.1809279701E+00, 2.0797960969E+00, 8.7516833657E-01],
	[2.5195000000E+04, 1.7349436368E+01, 5.4353745155E+00, 4.1836146229E+00, 2.0805312262E+00, 8.7522921129E-01],
	[2.5200000000E+04, 1.7354894631E+01, 5.4353200072E+00, 4.1863024677E+00, 2.0812662773E+00, 8.7529005713E-01],
	[2.5205000000E+04, 1.7360353528E+01, 5.4352655102E+00, 4.1889915047E+00, 2.0820012499E+00, 8.7535087409E-01],
	[2.5210000000E+04, 1.7365813059E+01, 5.4352110246E+00, 4.1916817342E+00, 2.0827361439E+00, 8.7541166221E-01],
	[2.5215000000E+04, 1.7371273223E+01, 5.4351565503E+00, 4.1943731566E+00, 2.0834709594E+00, 8.7547242162E-01],
	[2.5220000000E+04, 1.7376734021E+01, 5.4351020874E+00, 4.1970657720E+00, 2.0842056961E+00, 8.7553315236E-01],
	[2.5225000000E+04, 1.7382195452E+01, 5.4350476358E+00, 4.1997595809E+00, 2.0849403540E+00, 8.7559385444E-01],
	[2.5230000000E+04, 1.7387657517E+01, 5.4349931956E+00, 4.2024545835E+00, 2.0856749329E+00, 8.7565452787E-01],
	[2.5235000000E+04, 1.7393120216E+01, 5.4349387667E+00, 4.2051507801E+00, 2.0864094328E+00, 8.7571517266E-01],
	[2.5240000000E+04, 1.7398583548E+01, 5.4348843491E+00, 4.2078481709E+00, 2.0871438535E+00, 8.7577578881E-01],
	[2.5245000000E+04, 1.7404047513E+01, 5.4348299428E+00, 4.2105467563E+00, 2.0878781950E+00, 8.7583637634E-01],
	[2.5250000000E+04, 1.7409512112E+01, 5.4347755479E+00, 4.2132465366E+00, 2.0886124571E+00, 8.7589693525E-01],
	[2.5255000000E+04, 1.7414977344E+01, 5.4347211642E+00, 4.2159475121E+00, 2.0893466397E+00, 8.7595746556E-01],
	[2.5260000000E+04, 1.7420443209E+01, 5.4346667919E+00, 4.2186496829E+00, 2.0900807427E+00, 8.7601796727E-01],
	[2.5265000000E+04, 1.7425909707E+01, 5.4346124309E+00, 4.2213530496E+00, 2.0908147660E+00, 8.7607844039E-01],
	[2.5270000000E+04, 1.7431376839E+01, 5.4345580812E+00, 4.2240576122E+00, 2.0915487096E+00, 8.7613888494E-01],
	[2.5275000000E+04, 1.7436844604E+01, 5.4345037428E+00, 4.2267633712E+00, 2.0922825732E+00, 8.7619930092E-01],
	[2.5280000000E+04, 1.7442313001E+01, 5.4344494157E+00, 4.2294703268E+00, 2.0930163568E+00, 8.7625968834E-01],
	[2.5285000000E+04, 1.7447782032E+01, 5.4343950998E+00, 4.2321784793E+00, 2.0937500603E+00, 8.7632004721E-01],
	[2.5290000000E+04, 1.7453251696E+01, 5.4343407953E+00, 4.2348878291E+00, 2.0944836836E+00, 8.7638037754E-01],
	[2.5295000000E+04, 1.7458721992E+01, 5.4342865020E+00, 4.2375983763E+00, 2.0952172266E+00, 8.7644067934E-01],
	[2.5300000000E+04, 1.7464192922E+01, 5.4342322200E+00, 4.2403101212E+00, 2.0959506891E+00, 8.7650095262E-01],
	[2.5305000000E+04, 1.7469664484E+01, 5.4341779493E+00, 4.2430230643E+00, 2.0966840711E+00, 8.7656119739E-01],
	[2.5310000000E+04, 1.7475136679E+01, 5.4341236898E+00, 4.2457372057E+00, 2.0974173725E+00, 8.7662141365E-01],
	[2.5315000000E+04, 1.7480609506E+01, 5.4340694416E+00, 4.2484525458E+00, 2.0981505931E+00, 8.7668160142E-01],
	[2.5320000000E+04, 1.7486082966E+01, 5.4340152046E+00, 4.2511690848E+00, 2.0988837328E+00, 8.7674176071E-01],
	[2.5325000000E+04, 1.7491557059E+01, 5.4339609789E+00, 4.2538868231E+00, 2.0996167916E+00, 8.7680189153E-01],
	[2.5330000000E+04, 1.7497031784E+01, 5.4339067645E+00, 4.2566057609E+00, 2.1003497694E+00, 8.7686199388E-01],
	[2.5335000000E+04, 1.7502507142E+01, 5.4338525612E+00, 4.2593258986E+00, 2.1010826660E+00, 8.7692206778E-01],
	[2.5340000000E+04, 1.7507983132E+01, 5.4337983693E+00, 4.2620472363E+00, 2.1018154813E+00, 8.7698211323E-01],
	[2.5345000000E+04, 1.7513459755E+01, 5.4337441885E+00, 4.2647697745E+00, 2.1025482152E+00, 8.7704213024E-01],
	[2.5350000000E+04, 1.7518937010E+01, 5.4336900190E+00, 4.2674935133E+00, 2.1032808677E+00, 8.7710211883E-01],
	[2.5355000000E+04, 1.7524414897E+01, 5.4336358607E+00, 4.2702184532E+00, 2.1040134385E+00, 8.7716207900E-01],
	[2.5360000000E+04, 1.7529893416E+01, 5.4335817136E+00, 4.2729445943E+00, 2.1047459277E+00, 8.7722201077E-01],
	[2.5365000000E+04, 1.7535372567E+01, 5.4335275777E+00, 4.2756719371E+00, 2.1054783351E+00, 8.7728191413E-01],
	[2.5370000000E+04, 1.7540852351E+01, 5.4334734531E+00, 4.2784004817E+00, 2.1062106606E+00, 8.7734178911E-01],
	[2.5375000000E+04, 1.7546332766E+01, 5.4334193396E+00, 4.2811302284E+00, 2.1069429041E+00, 8.7740163571E-01],
	[2.5380000000E+04, 1.7551813814E+01, 5.4333652374E+00, 4.2838611776E+00, 2.1076750655E+00, 8.7746145394E-01],
	[2.5385000000E+04, 1.7557295494E+01, 5.4333111463E+00, 4.2865933296E+00, 2.1084071447E+00, 8.7752124381E-01],
	[2.5390000000E+04, 1.7562777805E+01, 5.4332570665E+00, 4.2893266846E+00, 2.1091391415E+00, 8.7758100533E-01],
	[2.5395000000E+04, 1.7568260748E+01, 5.4332029978E+00, 4.2920612429E+00, 2.1098710560E+00, 8.7764073851E-01],
	[2.5400000000E+04, 1.7573744323E+01, 5.4331489403E+00, 4.2947970048E+00, 2.1106028879E+00, 8.7770044336E-01],
	[2.5405000000E+04, 1.7579228530E+01, 5.4330948940E+00, 4.2975339707E+00, 2.1113346373E+00, 8.7776011989E-01],
	[2.5410000000E+04, 1.7584713369E+01, 5.4330408588E+00, 4.3002721407E+00, 2.1120663039E+00, 8.7781976810E-01],
	[2.5415000000E+04, 1.7590198839E+01, 5.4329868348E+00, 4.3030115153E+00, 2.1127978876E+00, 8.7787938802E-01],
	[2.5420000000E+04, 1.7595684941E+01, 5.4329328220E+00, 4.3057520947E+00, 2.1135293885E+00, 8.7793897964E-01],
	[2.5425000000E+04, 1.7601171674E+01, 5.4328788204E+00, 4.3084938791E+00, 2.1142608063E+00, 8.7799854298E-01],
	[2.5430000000E+04, 1.7606659039E+01, 5.4328248299E+00, 4.3112368689E+00, 2.1149921410E+00, 8.7805807805E-01],
	[2.5435000000E+04, 1.7612147035E+01, 5.4327708505E+00, 4.3139810644E+00, 2.1157233924E+00, 8.7811758485E-01],
	[2.5440000000E+04, 1.7617635663E+01, 5.4327168823E+00, 4.3167264658E+00, 2.1164545605E+00, 8.7817706340E-01],
	[2.5445000000E+04, 1.7623124921E+01, 5.4326629253E+00, 4.3194730735E+00, 2.1171856452E+00, 8.7823651371E-01],
	[2.5450000000E+04, 1.7628614812E+01, 5.4326089794E+00, 4.3222208878E+00, 2.1179166463E+00, 8.7829593578E-01],
	[2.5455000000E+04, 1.7634105333E+01, 5.4325550446E+00, 4.3249699088E+00, 2.1186475637E+00, 8.7835532962E-01],
	[2.5460000000E+04, 1.7639596486E+01, 5.4325011209E+00, 4.3277201370E+00, 2.1193783974E+00, 8.7841469526E-01],
	[2.5465000000E+04, 1.7645088269E+01, 5.4324472084E+00, 4.3304715726E+00, 2.1201091473E+00, 8.7847403268E-01],
	[2.5470000000E+04, 1.7650580684E+01, 5.4323933070E+00, 4.3332242160E+00, 2.1208398132E+00, 8.7853334191E-01],
	[2.5475000000E+04, 1.7656073730E+01, 5.4323394167E+00, 4.3359780673E+00, 2.1215703950E+00, 8.7859262296E-01],
	[2.5480000000E+04, 1.7661567407E+01, 5.4322855375E+00, 4.3387331270E+00, 2.1223008927E+00, 8.7865187583E-01],
	[2.5485000000E+04, 1.7667061715E+01, 5.4322316694E+00, 4.3414893952E+00, 2.1230313061E+00, 8.7871110053E-01],
	[2.5490000000E+04, 1.7672556653E+01, 5.4321778124E+00, 4.3442468723E+00, 2.1237616352E+00, 8.7877029708E-01],
	[2.5495000000E+04, 1.7678060995E+01, 5.4321254175E+00, 4.3470055586E+00, 2.1244922285E+00, 8.7882946548E-01],
	[2.5500000000E+04, 1.7683581566E+01, 5.4320756117E+00, 4.3497654543E+00, 2.1252233573E+00, 8.7888860575E-01],
	[2.5505000000E+04, 1.7689102777E+01, 5.4320258162E+00, 4.3525265598E+00, 2.1259544025E+00, 8.7894771788E-01],
	[2.5510000000E+04, 1.7694624630E+01, 5.4319760308E+00, 4.3552888754E+00, 2.1266853638E+00, 8.7900680190E-01],
	[2.5515000000E+04, 1.7700147124E+01, 5.4319262557E+00, 4.3580524013E+00, 2.1274162412E+00, 8.7906585781E-01],
	[2.5520000000E+04, 1.7705670258E+01, 5.4318764907E+00, 4.3608171378E+00, 2.1281470346E+00, 8.7912488563E-01],
	[2.5525000000E+04, 1.7711194034E+01, 5.4318267360E+00, 4.3635830853E+00, 2.1288777438E+00, 8.7918388535E-01],
	[2.5530000000E+04, 1.7716718450E+01, 5.4317769915E+00, 4.3663502440E+00, 2.1296083688E+00, 8.7924285700E-01],
	[2.5535000000E+04, 1.7722243507E+01, 5.4317272572E+00, 4.3691186142E+00, 2.1303389095E+00, 8.7930180058E-01],
	[2.5540000000E+04, 1.7727769205E+01, 5.4316775330E+00, 4.3718881962E+00, 2.1310693657E+00, 8.7936071610E-01],
	[2.5545000000E+04, 1.7733295544E+01, 5.4316278191E+00, 4.3746589903E+00, 2.1317997374E+00, 8.7941960358E-01],
	[2.5550000000E+04, 1.7738822523E+01, 5.4315781153E+00, 4.3774309968E+00, 2.1325300244E+00, 8.7947846301E-01],
	[2.5555000000E+04, 1.7744350143E+01, 5.4315284218E+00, 4.3802042160E+00, 2.1332602267E+00, 8.7953729442E-01],
	[2.5560000000E+04, 1.7749878404E+01, 5.4314787384E+00, 4.3829786481E+00, 2.1339903442E+00, 8.7959609780E-01],
	[2.5565000000E+04, 1.7755407305E+01, 5.4314290651E+00, 4.3857542936E+00, 2.1347203767E+00, 8.7965487318E-01],
	[2.5570000000E+04, 1.7760936846E+01, 5.4313794021E+00, 4.3885311526E+00, 2.1354503242E+00, 8.7971362056E-01],
	[2.5575000000E+04, 1.7766467028E+01, 5.4313297492E+00, 4.3913092254E+00, 2.1361801865E+00, 8.7977233995E-01],
	[2.5580000000E+04, 1.7771997850E+01, 5.4312801064E+00, 4.3940885124E+00, 2.1369099636E+00, 8.7983103136E-01],
	[2.5585000000E+04, 1.7777529313E+01, 5.4312304739E+00, 4.3968690138E+00, 2.1376396554E+00, 8.7988969480E-01],
	[2.5590000000E+04, 1.7783061416E+01, 5.4311808514E+00, 4.3996507300E+00, 2.1383692617E+00, 8.7994833028E-01],
	[2.5595000000E+04, 1.7788594159E+01, 5.4311312392E+00, 4.4024336612E+00, 2.1390987825E+00, 8.8000693781E-01],
	[2.5600000000E+04, 1.7794127542E+01, 5.4310816370E+00, 4.4052178077E+00, 2.1398282176E+00, 8.8006551740E-01],
	[2.5605000000E+04, 1.7799661565E+01, 5.4310320450E+00, 4.4080031698E+00, 2.1405575670E+00, 8.8012406907E-01],
	[2.5610000000E+04, 1.7805196228E+01, 5.4309824632E+00, 4.4107897478E+00, 2.1412868306E+00, 8.8018259281E-01],
	[2.5615000000E+04, 1.7810731531E+01, 5.4309328914E+00, 4.4135775420E+00, 2.1420160082E+00, 8.8024108864E-01],
	[2.5620000000E+04, 1.7816267475E+01, 5.4308833298E+00, 4.4163665527E+00, 2.1427450998E+00, 8.8029955658E-01],
	[2.5625000000E+04, 1.7821804058E+01, 5.4308337784E+00, 4.4191567802E+00, 2.1434741053E+00, 8.8035799662E-01],
	[2.5630000000E+04, 1.7827341281E+01, 5.4307842370E+00, 4.4219482247E+00, 2.1442030245E+00, 8.8041640878E-01],
	[2.5635000000E+04, 1.7832879143E+01, 5.4307347058E+00, 4.4247408866E+00, 2.1449318574E+00, 8.8047479308E-01],
	[2.5640000000E+04, 1.7838417646E+01, 5.4306851846E+00, 4.4275347662E+00, 2.1456606039E+00, 8.8053314951E-01],
	[2.5645000000E+04, 1.7843956788E+01, 5.4306356736E+00, 4.4303298637E+00, 2.1463892638E+00, 8.8059147809E-01],
	[2.5650000000E+04, 1.7849496570E+01, 5.4305861727E+00, 4.4331261795E+00, 2.1471178371E+00, 8.8064977884E-01],
	[2.5655000000E+04, 1.7855036991E+01, 5.4305366819E+00, 4.4359237138E+00, 2.1478463237E+00, 8.8070805175E-01],
	[2.5660000000E+04, 1.7860578052E+01, 5.4304872011E+00, 4.4387224669E+00, 2.1485747234E+00, 8.8076629685E-01],
	[2.5665000000E+04, 1.7866119752E+01, 5.4304377305E+00, 4.4415224391E+00, 2.1493030362E+00, 8.8082451413E-01],
	[2.5670000000E+04, 1.7871662092E+01, 5.4303882700E+00, 4.4443236308E+00, 2.1500312621E+00, 8.8088270362E-01],
	[2.5675000000E+04, 1.7877205071E+01, 5.4303388195E+00, 4.4471260422E+00, 2.1507594007E+00, 8.8094086531E-01],
	[2.5680000000E+04, 1.7882748690E+01, 5.4302893791E+00, 4.4499296736E+00, 2.1514874522E+00, 8.8099899923E-01],
	[2.5685000000E+04, 1.7888292948E+01, 5.4302399488E+00, 4.4527345252E+00, 2.1522154164E+00, 8.8105710538E-01],
	[2.5690000000E+04, 1.7893837845E+01, 5.4301905286E+00, 4.4555405975E+00, 2.1529432931E+00, 8.8111518377E-01],
	[2.5695000000E+04, 1.7899383381E+01, 5.4301411184E+00, 4.4583478906E+00, 2.1536710823E+00, 8.8117323440E-01],
	[2.5700000000E+04, 1.7904929556E+01, 5.4300917183E+00, 4.4611564049E+00, 2.1543987840E+00, 8.8123125730E-01],
	[2.5705000000E+04, 1.7910476371E+01, 5.4300423282E+00, 4.4639661407E+00, 2.1551263979E+00, 8.8128925247E-01],
	[2.5710000000E+04, 1.7916023824E+01, 5.4299929483E+00, 4.4667770982E+00, 2.1558539240E+00, 8.8134721992E-01],
	[2.5715000000E+04, 1.7921571917E+01, 5.4299435783E+00, 4.4695892778E+00, 2.1565813622E+00, 8.8140515967E-01],
	[2.5720000000E+04, 1.7927120648E+01, 5.4298942184E+00, 4.4724026797E+00, 2.1573087124E+00, 8.8146307171E-01],
	[2.5725000000E+04, 1.7932670018E+01, 5.4298448686E+00, 4.4752173043E+00, 2.1580359745E+00, 8.8152095606E-01],
	[2.5730000000E+04, 1.7938220028E+01, 5.4297955288E+00, 4.4780331517E+00, 2.1587631485E+00, 8.8157881274E-01],
	[2.5735000000E+04, 1.7943770675E+01, 5.4297461990E+00, 4.4808502225E+00, 2.1594902341E+00, 8.8163664175E-01],
	[2.5740000000E+04, 1.7949321962E+01, 5.4296968792E+00, 4.4836685167E+00, 2.1602172313E+00, 8.8169444310E-01],
	[2.5745000000E+04, 1.7954873887E+01, 5.4296475695E+00, 4.4864880347E+00, 2.1609441401E+00, 8.8175221680E-01],
	[2.5750000000E+04, 1.7960426451E+01, 5.4295982698E+00, 4.4893087768E+00, 2.1616709603E+00, 8.8180996286E-01],
	[2.5755000000E+04, 1.7965979654E+01, 5.4295489802E+00, 4.4921307434E+00, 2.1623976918E+00, 8.8186768130E-01],
	[2.5760000000E+04, 1.7971533495E+01, 5.4294997005E+00, 4.4949539346E+00, 2.1631243346E+00, 8.8192537212E-01],
	[2.5765000000E+04, 1.7977087974E+01, 5.4294504308E+00, 4.4977783508E+00, 2.1638508885E+00, 8.8198303533E-01],
	[2.5770000000E+04, 1.7982643092E+01, 5.4294011712E+00, 4.5006039922E+00, 2.1645773534E+00, 8.8204067094E-01],
	[2.5775000000E+04, 1.7988198848E+01, 5.4293519216E+00, 4.5034308593E+00, 2.1653037292E+00, 8.8209827897E-01],
	[2.5780000000E+04, 1.7993755243E+01, 5.4293026819E+00, 4.5062589522E+00, 2.1660300159E+00, 8.8215585942E-01],
	[2.5785000000E+04, 1.7999312276E+01, 5.4292534523E+00, 4.5090882712E+00, 2.1667562134E+00, 8.8221341230E-01],
	[2.5790000000E+04, 1.8004869947E+01, 5.4292042326E+00, 4.5119188167E+00, 2.1674823215E+00, 8.8227093763E-01],
	[2.5795000000E+04, 1.8010428256E+01, 5.4291550230E+00, 4.5147505889E+00, 2.1682083401E+00, 8.8232843541E-01],
	[2.5800000000E+04, 1.8015987203E+01, 5.4291058233E+00, 4.5175835882E+00, 2.1689342692E+00, 8.8238590565E-01],
	[2.5805000000E+04, 1.8021546789E+01, 5.4290566336E+00, 4.5204178148E+00, 2.1696601087E+00, 8.8244334837E-01],
	[2.5810000000E+04, 1.8027107012E+01, 5.4290074539E+00, 4.5232532690E+00, 2.1703858585E+00, 8.8250076358E-01],
	[2.5815000000E+04, 1.8032667873E+01, 5.4289582841E+00, 4.5260899511E+00, 2.1711115184E+00, 8.8255815127E-01],
	[2.5820000000E+04, 1.8038229373E+01, 5.4289091243E+00, 4.5289278614E+00, 2.1718370884E+00, 8.8261551148E-01],
	[2.5825000000E+04, 1.8043791510E+01, 5.4288599745E+00, 4.5317670003E+00, 2.1725625684E+00, 8.8267284420E-01],
	[2.5830000000E+04, 1.8049354285E+01, 5.4288108347E+00, 4.5346073679E+00, 2.1732879583E+00, 8.8273014944E-01],
	[2.5835000000E+04, 1.8054917698E+01, 5.4287617047E+00, 4.5374489646E+00, 2.1740132579E+00, 8.8278742722E-01],
	[2.5840000000E+04, 1.8060481748E+01, 5.4287125848E+00, 4.5402917906E+00, 2.1747384673E+00, 8.8284467755E-01],
	[2.5845000000E+04, 1.8066046436E+01, 5.4286634748E+00, 4.5431358464E+00, 2.1754635863E+00, 8.8290190043E-01],
	[2.5850000000E+04, 1.8071611762E+01, 5.4286143747E+00, 4.5459811321E+00, 2.1761886148E+00, 8.8295909588E-01],
	[2.5855000000E+04, 1.8077177725E+01, 5.4285652846E+00, 4.5488276481E+00, 2.1769135527E+00, 8.8301626391E-01],
	[2.5860000000E+04, 1.8082744326E+01, 5.4285162044E+00, 4.5516753946E+00, 2.1776383999E+00, 8.8307340452E-01],
	[2.5865000000E+04, 1.8088311564E+01, 5.4284671342E+00, 4.5545243719E+00, 2.1783631564E+00, 8.8313051774E-01],
	[2.5870000000E+04, 1.8093879440E+01, 5.4284180738E+00, 4.5573745804E+00, 2.1790878219E+00, 8.8318760356E-01],
	[2.5875000000E+04, 1.8099447953E+01, 5.4283690234E+00, 4.5602260204E+00, 2.1798123966E+00, 8.8324466199E-01],
	[2.5880000000E+04, 1.8105017104E+01, 5.4283199830E+00, 4.5630786920E+00, 2.1805368801E+00, 8.8330169306E-01],
	[2.5885000000E+04, 1.8110586891E+01, 5.4282709524E+00, 4.5659325957E+00, 2.1812612725E+00, 8.8335869677E-01],
	[2.5890000000E+04, 1.8116157316E+01, 5.4282219318E+00, 4.5687877317E+00, 2.1819855737E+00, 8.8341567312E-01],
	[2.5895000000E+04, 1.8121728378E+01, 5.4281729210E+00, 4.5716441003E+00, 2.1827097836E+00, 8.8347262214E-01],
	[2.5900000000E+04, 1.8127300077E+01, 5.4281239202E+00, 4.5745017017E+00, 2.1834339020E+00, 8.8352954382E-01],
	[2.5905000000E+04, 1.8132879173E+01, 5.4280760318E+00, 4.5773605364E+00, 2.1841582054E+00, 8.8358643819E-01],
	[2.5910000000E+04, 1.8138476388E+01, 5.4280310032E+00, 4.5802206046E+00, 2.1848831330E+00, 8.8364330525E-01],
	[2.5915000000E+04, 1.8144074251E+01, 5.4279859837E+00, 4.5830819065E+00, 2.1856079697E+00, 8.8370014500E-01],
	[2.5920000000E+04, 1.8149672760E+01, 5.4279409732E+00, 4.5859444425E+00, 2.1863327155E+00, 8.8375695747E-01],
	[2.5925000000E+04, 1.8155271917E+01, 5.4278959718E+00, 4.5888082129E+00, 2.1870573704E+00, 8.8381374266E-01],
	[2.5930000000E+04, 1.8160871720E+01, 5.4278509795E+00, 4.5916732179E+00, 2.1877819342E+00, 8.8387050059E-01],
	[2.5935000000E+04, 1.8166472171E+01, 5.4278059962E+00, 4.5945394579E+00, 2.1885064068E+00, 8.8392723125E-01],
	[2.5940000000E+04, 1.8172073269E+01, 5.4277610219E+00, 4.5974069331E+00, 2.1892307881E+00, 8.8398393467E-01],
	[2.5945000000E+04, 1.8177675013E+01, 5.4277160567E+00, 4.6002756439E+00, 2.1899550781E+00, 8.8404061086E-01],
	[2.5950000000E+04, 1.8183277405E+01, 5.4276711005E+00, 4.6031455905E+00, 2.1906792767E+00, 8.8409725981E-01],
	[2.5955000000E+04, 1.8188880443E+01, 5.4276261534E+00, 4.6060167732E+00, 2.1914033837E+00, 8.8415388156E-01],
	[2.5960000000E+04, 1.8194484128E+01, 5.4275812152E+00, 4.6088891923E+00, 2.1921273991E+00, 8.8421047609E-01],
	[2.5965000000E+04, 1.8200088460E+01, 5.4275362862E+00, 4.6117628482E+00, 2.1928513228E+00, 8.8426704343E-01],
	[2.5970000000E+04, 1.8205693438E+01, 5.4274913661E+00, 4.6146377411E+00, 2.1935751547E+00, 8.8432358359E-01],
	[2.5975000000E+04, 1.8211299063E+01, 5.4274464550E+00, 4.6175138712E+00, 2.1942988947E+00, 8.8438009658E-01],
	[2.5980000000E+04, 1.8216905335E+01, 5.4274015530E+00, 4.6203912390E+00, 2.1950225426E+00, 8.8443658240E-01],
	[2.5985000000E+04, 1.8222512253E+01, 5.4273566600E+00, 4.6232698446E+00, 2.1957460985E+00, 8.8449304106E-01],
	[2.5990000000E+04, 1.8228119817E+01, 5.4273117760E+00, 4.6261496884E+00, 2.1964695622E+00, 8.8454947259E-01],
	[2.5995000000E+04, 1.8233728028E+01, 5.4272669009E+00, 4.6290307707E+00, 2.1971929336E+00, 8.8460587698E-01],
	[2.6000000000E+04, 1.8239336886E+01, 5.4272220349E+00, 4.6319130918E+00, 2.1979162126E+00, 8.8466225425E-01],
	[2.6005000000E+04, 1.8244946389E+01, 5.4271771779E+00, 4.6347966519E+00, 2.1986393992E+00, 8.8471860441E-01],
	[2.6010000000E+04, 1.8250556539E+01, 5.4271323299E+00, 4.6376814514E+00, 2.1993624933E+00, 8.8477492747E-01],
	[2.6015000000E+04, 1.8256167335E+01, 5.4270874909E+00, 4.6405674905E+00, 2.2000854947E+00, 8.8483122344E-01],
	[2.6020000000E+04, 1.8261778778E+01, 5.4270426608E+00, 4.6434547696E+00, 2.2008084033E+00, 8.8488749234E-01],
	[2.6025000000E+04, 1.8267390866E+01, 5.4269978398E+00, 4.6463432889E+00, 2.2015312192E+00, 8.8494373416E-01],
	[2.6030000000E+04, 1.8273003601E+01, 5.4269530277E+00, 4.6492330488E+00, 2.2022539421E+00, 8.8499994892E-01],
	[2.6035000000E+04, 1.8278616981E+01, 5.4269082246E+00, 4.6521240494E+00, 2.2029765720E+00, 8.8505613664E-01],
	[2.6040000000E+04, 1.8284231007E+01, 5.4268634305E+00, 4.6550162912E+00, 2.2036991088E+00, 8.8511229731E-01],
	[2.6045000000E+04, 1.8289845680E+01, 5.4268186454E+00, 4.6579097744E+00, 2.2044215525E+00, 8.8516843096E-01],
	[2.6050000000E+04, 1.8295460998E+01, 5.4267738692E+00, 4.6608044993E+00, 2.2051439028E+00, 8.8522453760E-01],
	[2.6055000000E+04, 1.8301076962E+01, 5.4267291019E+00, 4.6637004662E+00, 2.2058661598E+00, 8.8528061723E-01],
	[2.6060000000E+04, 1.8306693572E+01, 5.4266843437E+00, 4.6665976754E+00, 2.2065883233E+00, 8.8533666986E-01],
	[2.6065000000E+04, 1.8312310827E+01, 5.4266395944E+00, 4.6694961272E+00, 2.2073103933E+00, 8.8539269551E-01],
	[2.6070000000E+04, 1.8317928729E+01, 5.4265948540E+00, 4.6723958218E+00, 2.2080323697E+00, 8.8544869418E-01],
	[2.6075000000E+04, 1.8323547275E+01, 5.4265501226E+00, 4.6752967596E+00, 2.2087542523E+00, 8.8550466589E-01],
	[2.6080000000E+04, 1.8329166468E+01, 5.4265054001E+00, 4.6781989409E+00, 2.2094760410E+00, 8.8556061065E-01],
	[2.6085000000E+04, 1.8334786306E+01, 5.4264606866E+00, 4.6811023660E+00, 2.2101977359E+00, 8.8561652847E-01],
	[2.6090000000E+04, 1.8340406789E+01, 5.4264159820E+00, 4.6840070351E+00, 2.2109193368E+00, 8.8567241935E-01],
	[2.6095000000E+04, 1.8346027918E+01, 5.4263712864E+00, 4.6869129486E+00, 2.2116408435E+00, 8.8572828331E-01],
	[2.6100000000E+04, 1.8351649692E+01, 5.4263265997E+00, 4.6898201067E+00, 2.2123622561E+00, 8.8578412036E-01],
	[2.6105000000E+04, 1.8357272111E+01, 5.4262819219E+00, 4.6927285098E+00, 2.2130835745E+00, 8.8583993052E-01],
	[2.6110000000E+04, 1.8362895176E+01, 5.4262372530E+00, 4.6956381580E+00, 2.2138047984E+00, 8.8589571378E-01],
	[2.6115000000E+04, 1.8368518886E+01, 5.4261925931E+00, 4.6985490518E+00, 2.2145259279E+00, 8.8595147016E-01],
	[2.6120000000E+04, 1.8374143241E+01, 5.4261479420E+00, 4.7014611915E+00, 2.2152469629E+00, 8.8600719967E-01],
	[2.6125000000E+04, 1.8379768242E+01, 5.4261032999E+00, 4.7043745772E+00, 2.2159679032E+00, 8.8606290233E-01],
	[2.6130000000E+04, 1.8385393887E+01, 5.4260586667E+00, 4.7072892094E+00, 2.2166887488E+00, 8.8611857814E-01],
	[2.6135000000E+04, 1.8391020177E+01, 5.4260140424E+00, 4.7102050882E+00, 2.2174094996E+00, 8.8617422711E-01],
	[2.6140000000E+04, 1.8396647113E+01, 5.4259694270E+00, 4.7131222141E+00, 2.2181301555E+00, 8.8622984926E-01],
	[2.6145000000E+04, 1.8402274693E+01, 5.4259248206E+00, 4.7160405872E+00, 2.2188507165E+00, 8.8628544459E-01],
	[2.6150000000E+04, 1.8407902918E+01, 5.4258802230E+00, 4.7189602079E+00, 2.2195711823E+00, 8.8634101312E-01],
	[2.6155000000E+04, 1.8413531788E+01, 5.4258356343E+00, 4.7218810765E+00, 2.2202915530E+00, 8.8639655485E-01],
	[2.6160000000E+04, 1.8419161303E+01, 5.4257910544E+00, 4.7248031933E+00, 2.2210118284E+00, 8.8645206980E-01],
	[2.6165000000E+04, 1.8424791462E+01, 5.4257464835E+00, 4.7277265585E+00, 2.2217320085E+00, 8.8650755798E-01],
	[2.6170000000E+04, 1.8430422266E+01, 5.4257019215E+00, 4.7306511725E+00, 2.2224520932E+00, 8.8656301939E-01],
	[2.6175000000E+04, 1.8436053715E+01, 5.4256573683E+00, 4.7335770355E+00, 2.2231720823E+00, 8.8661845406E-01],
	[2.6180000000E+04, 1.8441685808E+01, 5.4256128240E+00, 4.7365041479E+00, 2.2238919758E+00, 8.8667386198E-01],
	[2.6185000000E+04, 1.8447318546E+01, 5.4255682886E+00, 4.7394325100E+00, 2.2246117737E+00, 8.8672924318E-01],
	[2.6190000000E+04, 1.8452951929E+01, 5.4255237620E+00, 4.7423621220E+00, 2.2253314757E+00, 8.8678459765E-01],
	[2.6195000000E+04, 1.8458585955E+01, 5.4254792444E+00, 4.7452929842E+00, 2.2260510819E+00, 8.8683992541E-01],
	[2.6200000000E+04, 1.8464220627E+01, 5.4254347355E+00, 4.7482250969E+00, 2.2267705921E+00, 8.8689522648E-01],
	[2.6205000000E+04, 1.8469855942E+01, 5.4253902356E+00, 4.7511584604E+00, 2.2274900063E+00, 8.8695050086E-01],
	[2.6210000000E+04, 1.8475491902E+01, 5.4253457445E+00, 4.7540930751E+00, 2.2282093243E+00, 8.8700574857E-01],
	[2.6215000000E+04, 1.8481128506E+01, 5.4253012622E+00, 4.7570289412E+00, 2.2289285462E+00, 8.8706096960E-01],
	[2.6220000000E+04, 1.8486765754E+01, 5.4252567888E+00, 4.7599660589E+00, 2.2296476717E+00, 8.8711616398E-01],
	[2.6225000000E+04, 1.8492403646E+01, 5.4252123242E+00, 4.7629044287E+00, 2.2303667008E+00, 8.8717133172E-01],
	[2.6230000000E+04, 1.8498042183E+01, 5.4251678685E+00, 4.7658440507E+00, 2.2310856334E+00, 8.8722647283E-01],
	[2.6235000000E+04, 1.8503681363E+01, 5.4251234216E+00, 4.7687849254E+00, 2.2318044694E+00, 8.8728158731E-01],
	[2.6240000000E+04, 1.8509321188E+01, 5.4250789836E+00, 4.7717270529E+00, 2.2325232088E+00, 8.8733667518E-01],
	[2.6245000000E+04, 1.8514961656E+01, 5.4250345543E+00, 4.7746704336E+00, 2.2332418515E+00, 8.8739173644E-01],
	[2.6250000000E+04, 1.8520602768E+01, 5.4249901339E+00, 4.7776150678E+00, 2.2339603973E+00, 8.8744677112E-01],
	[2.6255000000E+04, 1.8526244525E+01, 5.4249457224E+00, 4.7805609557E+00, 2.2346788462E+00, 8.8750177922E-01],
	[2.6260000000E+04, 1.8531886924E+01, 5.4249013196E+00, 4.7835080976E+00, 2.2353971980E+00, 8.8755676074E-01],
	[2.6265000000E+04, 1.8537529968E+01, 5.4248569257E+00, 4.7864564940E+00, 2.2361154528E+00, 8.8761171571E-01],
	[2.6270000000E+04, 1.8543173655E+01, 5.4248125406E+00, 4.7894061449E+00, 2.2368336104E+00, 8.8766664413E-01],
	[2.6275000000E+04, 1.8548817986E+01, 5.4247681642E+00, 4.7923570508E+00, 2.2375516708E+00, 8.8772154602E-01],
	[2.6280000000E+04, 1.8554462961E+01, 5.4247237967E+00, 4.7953092120E+00, 2.2382696337E+00, 8.8777642137E-01],
	[2.6285000000E+04, 1.8560108579E+01, 5.4246794380E+00, 4.7982626287E+00, 2.2389874993E+00, 8.8783127021E-01],
	[2.6290000000E+04, 1.8565754841E+01, 5.4246350881E+00, 4.8012173011E+00, 2.2397052673E+00, 8.8788609255E-01],
	[2.6295000000E+04, 1.8571401746E+01, 5.4245907470E+00, 4.8041732298E+00, 2.2404229377E+00, 8.8794088839E-01],
	[2.6300000000E+04, 1.8577049294E+01, 5.4245464147E+00, 4.8071304148E+00, 2.2411405104E+00, 8.8799565775E-01],
	[2.6305000000E+04, 1.8582697486E+01, 5.4245020912E+00, 4.8100888565E+00, 2.2418579853E+00, 8.8805040064E-01],
	[2.6310000000E+04, 1.8588346321E+01, 5.4244577765E+00, 4.8130485552E+00, 2.2425753624E+00, 8.8810511706E-01],
	[2.6315000000E+04, 1.8593995799E+01, 5.4244134705E+00, 4.8160095112E+00, 2.2432926415E+00, 8.8815980704E-01],
	[2.6320000000E+04, 1.8599645921E+01, 5.4243691733E+00, 4.8189717248E+00, 2.2440098225E+00, 8.8821447057E-01],
	[2.6325000000E+04, 1.8605317814E+01, 5.4243282833E+00, 4.8219351963E+00, 2.2447277950E+00, 8.8826910767E-01],
	[2.6330000000E+04, 1.8610993340E+01, 5.4242878807E+00, 4.8248999260E+00, 2.2454457955E+00, 8.8832371836E-01],
	[2.6335000000E+04, 1.8616669520E+01, 5.4242474861E+00, 4.8278659141E+00, 2.2461636987E+00, 8.8837830264E-01],
	[2.6340000000E+04, 1.8622346352E+01, 5.4242070994E+00, 4.8308331610E+00, 2.2468815044E+00, 8.8843286052E-01],
	[2.6345000000E+04, 1.8628023838E+01, 5.4241667207E+00, 4.8338016670E+00, 2.2475992125E+00, 8.8848739201E-01],
	[2.6350000000E+04, 1.8633701976E+01, 5.4241263500E+00, 4.8367714323E+00, 2.2483168230E+00, 8.8854189713E-01],
	[2.6355000000E+04, 1.8639380768E+01, 5.4240859873E+00, 4.8397424573E+00, 2.2490343357E+00, 8.8859637589E-01],
	[2.6360000000E+04, 1.8645060212E+01, 5.4240456325E+00, 4.8427147422E+00, 2.2497517507E+00, 8.8865082829E-01],
	[2.6365000000E+04, 1.8650740310E+01, 5.4240052856E+00, 4.8456882873E+00, 2.2504690677E+00, 8.8870525435E-01],
	[2.6370000000E+04, 1.8656421060E+01, 5.4239649467E+00, 4.8486630930E+00, 2.2511862867E+00, 8.8875965407E-01],
	[2.6375000000E+04, 1.8662102463E+01, 5.4239246158E+00, 4.8516391595E+00, 2.2519034076E+00, 8.8881402748E-01],
	[2.6380000000E+04, 1.8667784518E+01, 5.4238842927E+00, 4.8546164872E+00, 2.2526204304E+00, 8.8886837457E-01],
	[2.6385000000E+04, 1.8673467227E+01, 5.4238439777E+00, 4.8575950762E+00, 2.2533373549E+00, 8.8892269537E-01],
	[2.6390000000E+04, 1.8679150588E+01, 5.4238036706E+00, 4.8605749270E+00, 2.2540541811E+00, 8.8897698987E-01],
	[2.6395000000E+04, 1.8684834601E+01, 5.4237633714E+00, 4.8635560398E+00, 2.2547709089E+00, 8.8903125810E-01],
	[2.6400000000E+04, 1.8690519267E+01, 5.4237230801E+00, 4.8665384149E+00, 2.2554875382E+00, 8.8908550006E-01],
	[2.6405000000E+04, 1.8696204585E+01, 5.4236827968E+00, 4.8695220525E+00, 2.2562040689E+00, 8.8913971577E-01],
	[2.6410000000E+04, 1.8701890556E+01, 5.4236425214E+00, 4.8725069531E+00, 2.2569205009E+00, 8.8919390523E-01],
	[2.6415000000E+04, 1.8707577179E+01, 5.4236022539E+00, 4.8754931168E+00, 2.2576368342E+00, 8.8924806846E-01],
	[2.6420000000E+04, 1.8713264455E+01, 5.4235619943E+00, 4.8784805441E+00, 2.2583530686E+00, 8.8930220546E-01],
	[2.6425000000E+04, 1.8718952383E+01, 5.4235217427E+00, 4.8814692351E+00, 2.2590692041E+00, 8.8935631625E-01],
	[2.6430000000E+04, 1.8724640963E+01, 5.4234814990E+00, 4.8844591902E+00, 2.2597852407E+00, 8.8941040084E-01],
	[2.6435000000E+04, 1.8730330195E+01, 5.4234412632E+00, 4.8874504096E+00, 2.2605011781E+00, 8.8946445923E-01],
	[2.6440000000E+04, 1.8736020080E+01, 5.4234010353E+00, 4.8904428937E+00, 2.2612170164E+00, 8.8951849145E-01],
	[2.6445000000E+04, 1.8741710616E+01, 5.4233608153E+00, 4.8934366428E+00, 2.2619327554E+00, 8.8957249750E-01],
	[2.6450000000E+04, 1.8747401804E+01, 5.4233206032E+00, 4.8964316571E+00, 2.2626483950E+00, 8.8962647739E-01],
	[2.6455000000E+04, 1.8753093645E+01, 5.4232803990E+00, 4.8994279369E+00, 2.2633639353E+00, 8.8968043113E-01],
	[2.6460000000E+04, 1.8758786137E+01, 5.4232402026E+00, 4.9024254826E+00, 2.2640793760E+00, 8.8973435874E-01],
	[2.6465000000E+04, 1.8764479282E+01, 5.4232000142E+00, 4.9054242944E+00, 2.2647947172E+00, 8.8978826022E-01],
	[2.6470000000E+04, 1.8770173078E+01, 5.4231598337E+00, 4.9084243727E+00, 2.2655099587E+00, 8.8984213558E-01],
	[2.6475000000E+04, 1.8775867526E+01, 5.4231196611E+00, 4.9114257176E+00, 2.2662251004E+00, 8.8989598485E-01],
	[2.6480000000E+04, 1.8781562625E+01, 5.4230794963E+00, 4.9144283296E+00, 2.2669401423E+00, 8.8994980802E-01],
	[2.6485000000E+04, 1.8787258377E+01, 5.4230393394E+00, 4.9174322089E+00, 2.2676550843E+00, 8.9000360510E-01],
	[2.6490000000E+04, 1.8792954780E+01, 5.4229991905E+00, 4.9204373559E+00, 2.2683699263E+00, 8.9005737612E-01],
	[2.6495000000E+04, 1.8798651834E+01, 5.4229590493E+00, 4.9234437707E+00, 2.2690846682E+00, 8.9011112108E-01],
	[2.6500000000E+04, 1.8804349540E+01, 5.4229189161E+00, 4.9264514537E+00, 2.2697993100E+00, 8.9016483999E-01],
	[2.6505000000E+04, 1.8810047898E+01, 5.4228787907E+00, 4.9294604052E+00, 2.2705138515E+00, 8.9021853285E-01],
	[2.6510000000E+04, 1.8815746907E+01, 5.4228386732E+00, 4.9324706255E+00, 2.2712282926E+00, 8.9027219970E-01],
	[2.6515000000E+04, 1.8821446568E+01, 5.4227985635E+00, 4.9354821149E+00, 2.2719426334E+00, 8.9032584052E-01],
	[2.6520000000E+04, 1.8827146879E+01, 5.4227584617E+00, 4.9384948736E+00, 2.2726568736E+00, 8.9037945534E-01],
	[2.6525000000E+04, 1.8832847843E+01, 5.4227183678E+00, 4.9415089020E+00, 2.2733710133E+00, 8.9043304417E-01],
	[2.6530000000E+04, 1.8838549457E+01, 5.4226782817E+00, 4.9445242004E+00, 2.2740850523E+00, 8.9048660701E-01],
	[2.6535000000E+04, 1.8844251723E+01, 5.4226382035E+00, 4.9475407691E+00, 2.2747989906E+00, 8.9054014388E-01],
	[2.6540000000E+04, 1.8849954639E+01, 5.4225981331E+00, 4.9505586083E+00, 2.2755128281E+00, 8.9059365479E-01],
	[2.6545000000E+04, 1.8855658207E+01, 5.4225580706E+00, 4.9535777184E+00, 2.2762265646E+00, 8.9064713975E-01],
	[2.6550000000E+04, 1.8861362426E+01, 5.4225180159E+00, 4.9565980996E+00, 2.2769402002E+00, 8.9070059877E-01],
	[2.6555000000E+04, 1.8867067296E+01, 5.4224779690E+00, 4.9596197522E+00, 2.2776537347E+00, 8.9075403186E-01],
	[2.6560000000E+04, 1.8872772817E+01, 5.4224379300E+00, 4.9626426766E+00, 2.2783671681E+00, 8.9080743903E-01],
	[2.6565000000E+04, 1.8878478989E+01, 5.4223978988E+00, 4.9656668731E+00, 2.2790805003E+00, 8.9086082029E-01],
	[2.6570000000E+04, 1.8884185812E+01, 5.4223578754E+00, 4.9686923418E+00, 2.2797937311E+00, 8.9091417566E-01],
	[2.6575000000E+04, 1.8889893285E+01, 5.4223178599E+00, 4.9717190832E+00, 2.2805068605E+00, 8.9096750514E-01],
	[2.6580000000E+04, 1.8895601409E+01, 5.4222778522E+00, 4.9747470975E+00, 2.2812198885E+00, 8.9102080874E-01],
	[2.6585000000E+04, 1.8901310184E+01, 5.4222378523E+00, 4.9777763850E+00, 2.2819328149E+00, 8.9107408645E-01],
	[2.6590000000E+04, 1.8907019610E+01, 5.4221978602E+00, 4.9808069461E+00, 2.2826456397E+00, 8.9112733831E-01],
	[2.6595000000E+04, 1.8912729686E+01, 5.4221578759E+00, 4.9838387809E+00, 2.2833583628E+00, 8.9118056430E-01],
	[2.6600000000E+04, 1.8918440413E+01, 5.4221178995E+00, 4.9868718898E+00, 2.2840709841E+00, 8.9123376444E-01],
	[2.6605000000E+04, 1.8924151791E+01, 5.4220779308E+00, 4.9899062731E+00, 2.2847835035E+00, 8.9128693875E-01],
	[2.6610000000E+04, 1.8929863819E+01, 5.4220379700E+00, 4.9929419311E+00, 2.2854959209E+00, 8.9134008723E-01],
	[2.6615000000E+04, 1.8935576497E+01, 5.4219980170E+00, 4.9959788641E+00, 2.2862082364E+00, 8.9139320989E-01],
	[2.6620000000E+04, 1.8941289826E+01, 5.4219580717E+00, 4.9990170724E+00, 2.2869204497E+00, 8.9144630674E-01],
	[2.6625000000E+04, 1.8947003805E+01, 5.4219181343E+00, 5.0020565562E+00, 2.2876325608E+00, 8.9149937780E-01],
	[2.6630000000E+04, 1.8952718434E+01, 5.4218782046E+00, 5.0050973160E+00, 2.2883445696E+00, 8.9155242306E-01],
	[2.6635000000E+04, 1.8958433714E+01, 5.4218382828E+00, 5.0081393519E+00, 2.2890564761E+00, 8.9160544255E-01],
	[2.6640000000E+04, 1.8964149644E+01, 5.4217983687E+00, 5.0111826642E+00, 2.2897682802E+00, 8.9165843626E-01],
	[2.6645000000E+04, 1.8969866224E+01, 5.4217584624E+00, 5.0142272533E+00, 2.2904799817E+00, 8.9171140422E-01],
	[2.6650000000E+04, 1.8975583454E+01, 5.4217185639E+00, 5.0172731195E+00, 2.2911915807E+00, 8.9176434642E-01],
	[2.6655000000E+04, 1.8981301334E+01, 5.4216786732E+00, 5.0203202630E+00, 2.2919030770E+00, 8.9181726289E-01],
	[2.6660000000E+04, 1.8987019864E+01, 5.4216387903E+00, 5.0233686841E+00, 2.2926144705E+00, 8.9187015362E-01],
	[2.6665000000E+04, 1.8992739044E+01, 5.4215989151E+00, 5.0264183832E+00, 2.2933257612E+00, 8.9192301863E-01],
	[2.6670000000E+04, 1.8998458874E+01, 5.4215590477E+00, 5.0294693605E+00, 2.2940369490E+00, 8.9197585793E-01],
	[2.6675000000E+04, 1.9004179354E+01, 5.4215191880E+00, 5.0325216163E+00, 2.2947480338E+00, 8.9202867154E-01],
	[2.6680000000E+04, 1.9009900484E+01, 5.4214793362E+00, 5.0355751510E+00, 2.2954590155E+00, 8.9208145945E-01],
	[2.6685000000E+04, 1.9015622263E+01, 5.4214394921E+00, 5.0386299648E+00, 2.2961698941E+00, 8.9213422167E-01],
	[2.6690000000E+04, 1.9021344692E+01, 5.4213996557E+00, 5.0416860580E+00, 2.2968806694E+00, 8.9218695823E-01],
	[2.6695000000E+04, 1.9027067771E+01, 5.4213598271E+00, 5.0447434309E+00, 2.2975913415E+00, 8.9223966912E-01],
	[2.6700000000E+04, 1.9032791499E+01, 5.4213200062E+00, 5.0478020838E+00, 2.2983019102E+00, 8.9229235437E-01],
	[2.6705000000E+04, 1.9038515877E+01, 5.4212801931E+00, 5.0508620170E+00, 2.2990123754E+00, 8.9234501397E-01],
	[2.6710000000E+04, 1.9044240905E+01, 5.4212403878E+00, 5.0539232308E+00, 2.2997227370E+00, 8.9239764794E-01],
	[2.6715000000E+04, 1.9049966582E+01, 5.4212005902E+00, 5.0569857255E+00, 2.3004329951E+00, 8.9245025628E-01],
	[2.6720000000E+04, 1.9055692908E+01, 5.4211608003E+00, 5.0600495014E+00, 2.3011431494E+00, 8.9250283901E-01],
	[2.6725000000E+04, 1.9061419884E+01, 5.4211210182E+00, 5.0631145588E+00, 2.3018532000E+00, 8.9255539614E-01],
	[2.6730000000E+04, 1.9067147509E+01, 5.4210812438E+00, 5.0661808980E+00, 2.3025631467E+00, 8.9260792768E-01],
	[2.6735000000E+04, 1.9072875784E+01, 5.4210414771E+00, 5.0692485192E+00, 2.3032729895E+00, 8.9266043364E-01],
	[2.6740000000E+04, 1.9078604707E+01, 5.4210017181E+00, 5.0723174228E+00, 2.3039827283E+00, 8.9271291402E-01],
	[2.6745000000E+04, 1.9084337424E+01, 5.4209624659E+00, 5.0753876090E+00, 2.3046924990E+00, 8.9276536884E-01],
	[2.6750000000E+04, 1.9090091625E+01, 5.4209265267E+00, 5.0784590783E+00, 2.3054030674E+00, 8.9281779810E-01],
	[2.6755000000E+04, 1.9095846486E+01, 5.4208905944E+00, 5.0815318307E+00, 2.3061135324E+00, 8.9287020182E-01],
	[2.6760000000E+04, 1.9101602005E+01, 5.4208546691E+00, 5.0846058668E+00, 2.3068238940E+00, 8.9292258001E-01],
	[2.6765000000E+04, 1.9107358183E+01, 5.4208187508E+00, 5.0876811866E+00, 2.3075341520E+00, 8.9297493268E-01],
	[2.6770000000E+04, 1.9113115021E+01, 5.4207828394E+00, 5.0907577907E+00, 2.3082443065E+00, 8.9302725983E-01],
	[2.6775000000E+04, 1.9118872517E+01, 5.4207469350E+00, 5.0938356791E+00, 2.3089543573E+00, 8.9307956147E-01],
	[2.6780000000E+04, 1.9124630671E+01, 5.4207110374E+00, 5.0969148523E+00, 2.3096643043E+00, 8.9313183763E-01],
	[2.6785000000E+04, 1.9130389485E+01, 5.4206751469E+00, 5.0999953105E+00, 2.3103741475E+00, 8.9318408830E-01],
	[2.6790000000E+04, 1.9136148957E+01, 5.4206392633E+00, 5.1030770541E+00, 2.3110838869E+00, 8.9323631349E-01],
	[2.6795000000E+04, 1.9141909088E+01, 5.4206033866E+00, 5.1061600832E+00, 2.3117935222E+00, 8.9328851323E-01],
	[2.6800000000E+04, 1.9147669878E+01, 5.4205675168E+00, 5.1092443983E+00, 2.3125030535E+00, 8.9334068751E-01],
	[2.6805000000E+04, 1.9153431326E+01, 5.4205316540E+00, 5.1123299996E+00, 2.3132124807E+00, 8.9339283634E-01],
	[2.6810000000E+04, 1.9159193433E+01, 5.4204957980E+00, 5.1154168874E+00, 2.3139218036E+00, 8.9344495974E-01],
	[2.6815000000E+04, 1.9164956198E+01, 5.4204599491E+00, 5.1185050620E+00, 2.3146310223E+00, 8.9349705772E-01],
	[2.6820000000E+04, 1.9170719621E+01, 5.4204241070E+00, 5.1215945237E+00, 2.3153401366E+00, 8.9354913028E-01],
	[2.6825000000E+04, 1.9176483703E+01, 5.4203882719E+00, 5.1246852728E+00, 2.3160491465E+00, 8.9360117744E-01],
	[2.6830000000E+04, 1.9182248443E+01, 5.4203524436E+00, 5.1277773096E+00, 2.3167580518E+00, 8.9365319920E-01],
	[2.6835000000E+04, 1.9188013842E+01, 5.4203166223E+00, 5.1308706344E+00, 2.3174668526E+00, 8.9370519558E-01],
	[2.6840000000E+04, 1.9193779898E+01, 5.4202808079E+00, 5.1339652475E+00, 2.3181755487E+00, 8.9375716659E-01],
	[2.6845000000E+04, 1.9199546613E+01, 5.4202450004E+00, 5.1370611491E+00, 2.3188841400E+00, 8.9380911223E-01],
	[2.6850000000E+04, 1.9205313986E+01, 5.4202091998E+00, 5.1401583396E+00, 2.3195926266E+00, 8.9386103252E-01],
	[2.6855000000E+04, 1.9211082017E+01, 5.4201734061E+00, 5.1432568193E+00, 2.3203010082E+00, 8.9391292746E-01],
	[2.6860000000E+04, 1.9216850707E+01, 5.4201376193E+00, 5.1463565885E+00, 2.3210092849E+00, 8.9396479707E-01],
	[2.6865000000E+04, 1.9222620054E+01, 5.4201018394E+00, 5.1494576474E+00, 2.3217174565E+00, 8.9401664136E-01],
	[2.6870000000E+04, 1.9228390059E+01, 5.4200660664E+00, 5.1525599964E+00, 2.3224255231E+00, 8.9406846033E-01],
	[2.6875000000E+04, 1.9234160722E+01, 5.4200303003E+00, 5.1556636357E+00, 2.3231334844E+00, 8.9412025400E-01],
	[2.6880000000E+04, 1.9239932043E+01, 5.4199945411E+00, 5.1587685656E+00, 2.3238413404E+00, 8.9417202237E-01],
	[2.6885000000E+04, 1.9245704021E+01, 5.4199587888E+00, 5.1618747866E+00, 2.3245490911E+00, 8.9422376546E-01],
	[2.6890000000E+04, 1.9251476657E+01, 5.4199230433E+00, 5.1649822987E+00, 2.3252567364E+00, 8.9427548328E-01],
	[2.6895000000E+04, 1.9257249952E+01, 5.4198873048E+00, 5.1680911024E+00, 2.3259642762E+00, 8.9432717583E-01],
	[2.6900000000E+04, 1.9263023903E+01, 5.4198515731E+00, 5.1712011980E+00, 2.3266717104E+00, 8.9437884313E-01],
	[2.6905000000E+04, 1.9268798513E+01, 5.4198158483E+00, 5.1743125856E+00, 2.3273790389E+00, 8.9443048518E-01],
	[2.6910000000E+04, 1.9274573780E+01, 5.4197801303E+00, 5.1774252657E+00, 2.3280862618E+00, 8.9448210201E-01],
	[2.6915000000E+04, 1.9280349704E+01, 5.4197444193E+00, 5.1805392385E+00, 2.3287933788E+00, 8.9453369361E-01],
	[2.6920000000E+04, 1.9286126286E+01, 5.4197087151E+00, 5.1836545043E+00, 2.3295003900E+00, 8.9458525999E-01],
	[2.6925000000E+04, 1.9291903525E+01, 5.4196730177E+00, 5.1867710635E+00, 2.3302072952E+00, 8.9463680117E-01],
	[2.6930000000E+04, 1.9297681422E+01, 5.4196373273E+00, 5.1898889162E+00, 2.3309140944E+00, 8.9468831716E-01],
	[2.6935000000E+04, 1.9303459976E+01, 5.4196016437E+00, 5.1930080629E+00, 2.3316207875E+00, 8.9473980797E-01],
	[2.6940000000E+04, 1.9309239187E+01, 5.4195659669E+00, 5.1961285037E+00, 2.3323273744E+00, 8.9479127360E-01],
	[2.6945000000E+04, 1.9315019056E+01, 5.4195302970E+00, 5.1992502390E+00, 2.3330338551E+00, 8.9484271407E-01],
	[2.6950000000E+04, 1.9320799581E+01, 5.4194946340E+00, 5.2023732692E+00, 2.3337402294E+00, 8.9489412939E-01],
	[2.6955000000E+04, 1.9326580764E+01, 5.4194589778E+00, 5.2054975944E+00, 2.3344464974E+00, 8.9494551956E-01],
	[2.6960000000E+04, 1.9332362604E+01, 5.4194233285E+00, 5.2086232150E+00, 2.3351526589E+00, 8.9499688461E-01],
	[2.6965000000E+04, 1.9338145101E+01, 5.4193876860E+00, 5.2117501313E+00, 2.3358587139E+00, 8.9504822453E-01],
	[2.6970000000E+04, 1.9343928255E+01, 5.4193520503E+00, 5.2148783436E+00, 2.3365646622E+00, 8.9509953933E-01],
	[2.6975000000E+04, 1.9349712066E+01, 5.4193164215E+00, 5.2180078521E+00, 2.3372705039E+00, 8.9515082904E-01],
	[2.6980000000E+04, 1.9355496534E+01, 5.4192807995E+00, 5.2211386573E+00, 2.3379762388E+00, 8.9520209365E-01],
	[2.6985000000E+04, 1.9361281659E+01, 5.4192451844E+00, 5.2242707592E+00, 2.3386818669E+00, 8.9525333319E-01],
	[2.6990000000E+04, 1.9367067440E+01, 5.4192095761E+00, 5.2274041584E+00, 2.3393873880E+00, 8.9530454765E-01],
	[2.6995000000E+04, 1.9372853878E+01, 5.4191739746E+00, 5.2305388550E+00, 2.3400928022E+00, 8.9535573705E-01],
	[2.7000000000E+04, 1.9378640973E+01, 5.4191383799E+00, 5.2336748493E+00, 2.3407981093E+00, 8.9540690139E-01],
	[2.7005000000E+04, 1.9384428725E+01, 5.4191027921E+00, 5.2368121417E+00, 2.3415033093E+00, 8.9545804070E-01],
	[2.7010000000E+04, 1.9390217133E+01, 5.4190672111E+00, 5.2399507325E+00, 2.3422084021E+00, 8.9550915498E-01],
	[2.7015000000E+04, 1.9396006198E+01, 5.4190316369E+00, 5.2430906219E+00, 2.3429133876E+00, 8.9556024423E-01],
	[2.7020000000E+04, 1.9401795919E+01, 5.4189960696E+00, 5.2462318102E+00, 2.3436182658E+00, 8.9561130847E-01],
	[2.7025000000E+04, 1.9407586297E+01, 5.4189605090E+00, 5.2493742978E+00, 2.3443230365E+00, 8.9566234772E-01],
	[2.7030000000E+04, 1.9413377331E+01, 5.4189249553E+00, 5.2525180849E+00, 2.3450276998E+00, 8.9571336197E-01],
	[2.7035000000E+04, 1.9419169022E+01, 5.4188894083E+00, 5.2556631718E+00, 2.3457322555E+00, 8.9576435125E-01],
	[2.7040000000E+04, 1.9424961369E+01, 5.4188538682E+00, 5.2588095589E+00, 2.3464367035E+00, 8.9581531555E-01],
	[2.7045000000E+04, 1.9430754372E+01, 5.4188183349E+00, 5.2619572464E+00, 2.3471410439E+00, 8.9586625489E-01],
	[2.7050000000E+04, 1.9436548032E+01, 5.4187828084E+00, 5.2651062346E+00, 2.3478452764E+00, 8.9591716929E-01],
	[2.7055000000E+04, 1.9442342348E+01, 5.4187472887E+00, 5.2682565238E+00, 2.3485494011E+00, 8.9596805874E-01],
	[2.7060000000E+04, 1.9448137319E+01, 5.4187117757E+00, 5.2714081143E+00, 2.3492534179E+00, 8.9601892327E-01],
	[2.7065000000E+04, 1.9453932947E+01, 5.4186762696E+00, 5.2745610064E+00, 2.3499573267E+00, 8.9606976288E-01],
	[2.7070000000E+04, 1.9459729231E+01, 5.4186407703E+00, 5.2777152004E+00, 2.3506611274E+00, 8.9612057758E-01],
	[2.7075000000E+04, 1.9465526171E+01, 5.4186052777E+00, 5.2808706966E+00, 2.3513648199E+00, 8.9617136738E-01],
	[2.7080000000E+04, 1.9471323767E+01, 5.4185697920E+00, 5.2840274954E+00, 2.3520684043E+00, 8.9622213229E-01],
	[2.7085000000E+04, 1.9477122019E+01, 5.4185343130E+00, 5.2871855969E+00, 2.3527718803E+00, 8.9627287232E-01],
	[2.7090000000E+04, 1.9482920927E+01, 5.4184988408E+00, 5.2903450015E+00, 2.3534752480E+00, 8.9632358749E-01],
	[2.7095000000E+04, 1.9488720491E+01, 5.4184633754E+00, 5.2935057094E+00, 2.3541785073E+00, 8.9637427780E-01],
	[2.7100000000E+04, 1.9494520710E+01, 5.4184279167E+00, 5.2966677211E+00, 2.3548816581E+00, 8.9642494326E-01],
	[2.7105000000E+04, 1.9500321585E+01, 5.4183924649E+00, 5.2998310367E+00, 2.3555847003E+00, 8.9647558389E-01],
	[2.7110000000E+04, 1.9506123116E+01, 5.4183570198E+00, 5.3029956567E+00, 2.3562876338E+00, 8.9652619969E-01],
	[2.7115000000E+04, 1.9511925302E+01, 5.4183215814E+00, 5.3061615811E+00, 2.3569904587E+00, 8.9657679067E-01],
	[2.7120000000E+04, 1.9517728144E+01, 5.4182861499E+00, 5.3093288105E+00, 2.3576931747E+00, 8.9662735685E-01],
	[2.7125000000E+04, 1.9523531642E+01, 5.4182507251E+00, 5.3124973450E+00, 2.3583957819E+00, 8.9667789823E-01],
	[2.7130000000E+04, 1.9529335795E+01, 5.4182153070E+00, 5.3156671850E+00, 2.3590982802E+00, 8.9672841482E-01],
	[2.7135000000E+04, 1.9535140603E+01, 5.4181798958E+00, 5.3188383307E+00, 2.3598006695E+00, 8.9677890664E-01],
	[2.7140000000E+04, 1.9540946067E+01, 5.4181444912E+00, 5.3220107825E+00, 2.3605029497E+00, 8.9682937370E-01],
	[2.7145000000E+04, 1.9546752187E+01, 5.4181090935E+00, 5.3251845406E+00, 2.3612051207E+00, 8.9687981600E-01],
	[2.7150000000E+04, 1.9552558961E+01, 5.4180737024E+00, 5.3283596054E+00, 2.3619071826E+00, 8.9693023355E-01],
	[2.7155000000E+04, 1.9558366391E+01, 5.4180383182E+00, 5.3315359771E+00, 2.3626091352E+00, 8.9698062638E-01],
	[2.7160000000E+04, 1.9564174476E+01, 5.4180029406E+00, 5.3347136561E+00, 2.3633109784E+00, 8.9703099447E-01],
	[2.7165000000E+04, 1.9569983216E+01, 5.4179675699E+00, 5.3378926425E+00, 2.3640127122E+00, 8.9708133786E-01],
	[2.7170000000E+04, 1.9575792611E+01, 5.4179322058E+00, 5.3410729369E+00, 2.3647143365E+00, 8.9713165654E-01],
	[2.7175000000E+04, 1.9581603177E+01, 5.4178969293E+00, 5.3442545393E+00, 2.3654158741E+00, 8.9718195053E-01],
	[2.7180000000E+04, 1.9587437727E+01, 5.4178653113E+00, 5.3474374502E+00, 2.3661183391E+00, 8.9723221983E-01],
	[2.7185000000E+04, 1.9593272942E+01, 5.4178336994E+00, 5.3506216698E+00, 2.3668206953E+00, 8.9728246447E-01],
	[2.7190000000E+04, 1.9599108821E+01, 5.4178020935E+00, 5.3538071984E+00, 2.3675229425E+00, 8.9733268444E-01],
	[2.7195000000E+04, 1.9604945365E+01, 5.4177704935E+00, 5.3569940364E+00, 2.3682250808E+00, 8.9738287976E-01],
	[2.7200000000E+04, 1.9610782574E+01, 5.4177388996E+00, 5.3601821839E+00, 2.3689271100E+00, 8.9743305043E-01],
	[2.7205000000E+04, 1.9616620447E+01, 5.4177073116E+00, 5.3633716414E+00, 2.3696290301E+00, 8.9748319648E-01],
	[2.7210000000E+04, 1.9622458984E+01, 5.4176757297E+00, 5.3665624090E+00, 2.3703308410E+00, 8.9753331791E-01],
	[2.7215000000E+04, 1.9628298187E+01, 5.4176441537E+00, 5.3697544872E+00, 2.3710325426E+00, 8.9758341472E-01],
	[2.7220000000E+04, 1.9634138053E+01, 5.4176125837E+00, 5.3729478761E+00, 2.3717341350E+00, 8.9763348694E-01],
	[2.7225000000E+04, 1.9639978584E+01, 5.4175810197E+00, 5.3761425762E+00, 2.3724356179E+00, 8.9768353457E-01],
	[2.7230000000E+04, 1.9645819780E+01, 5.4175494617E+00, 5.3793385876E+00, 2.3731369914E+00, 8.9773355762E-01],
	[2.7235000000E+04, 1.9651661639E+01, 5.4175179096E+00, 5.3825359108E+00, 2.3738382553E+00, 8.9778355609E-01],
	[2.7240000000E+04, 1.9657504163E+01, 5.4174863635E+00, 5.3857345459E+00, 2.3745394096E+00, 8.9783353001E-01],
	[2.7245000000E+04, 1.9663347352E+01, 5.4174548234E+00, 5.3889344933E+00, 2.3752404543E+00, 8.9788347939E-01],
	[2.7250000000E+04, 1.9669191204E+01, 5.4174232893E+00, 5.3921357533E+00, 2.3759413892E+00, 8.9793340422E-01],
	[2.7255000000E+04, 1.9675035720E+01, 5.4173917611E+00, 5.3953383261E+00, 2.3766422143E+00, 8.9798330453E-01],
	[2.7260000000E+04, 1.9680880901E+01, 5.4173602389E+00, 5.3985422122E+00, 2.3773429296E+00, 8.9803318032E-01],
	[2.7265000000E+04, 1.9686726745E+01, 5.4173287227E+00, 5.4017474117E+00, 2.3780435349E+00, 8.9808303160E-01],
	[2.7270000000E+04, 1.9692573254E+01, 5.4172972124E+00, 5.4049539250E+00, 2.3787440301E+00, 8.9813285839E-01],
	[2.7275000000E+04, 1.9698420426E+01, 5.4172657081E+00, 5.4081617523E+00, 2.3794444153E+00, 8.9818266069E-01],
	[2.7280000000E+04, 1.9704268263E+01, 5.4172342098E+00, 5.4113708940E+00, 2.3801446904E+00, 8.9823243851E-01],
	[2.7285000000E+04, 1.9710116763E+01, 5.4172027174E+00, 5.4145813503E+00, 2.3808448552E+00, 8.9828219187E-01],
	[2.7290000000E+04, 1.9715965927E+01, 5.4171712310E+00, 5.4177931217E+00, 2.3815449097E+00, 8.9833192078E-01],
	[2.7295000000E+04, 1.9721815755E+01, 5.4171397505E+00, 5.4210062082E+00, 2.3822448539E+00, 8.9838162524E-01],
	[2.7300000000E+04, 1.9727666246E+01, 5.4171082759E+00, 5.4242206103E+00, 2.3829446877E+00, 8.9843130526E-01],
	[2.7305000000E+04, 1.9733517401E+01, 5.4170768073E+00, 5.4274363283E+00, 2.3836444109E+00, 8.9848096086E-01],
	[2.7310000000E+04, 1.9739369220E+01, 5.4170453447E+00, 5.4306533624E+00, 2.3843440236E+00, 8.9853059205E-01],
	[2.7315000000E+04, 1.9745221702E+01, 5.4170138880E+00, 5.4338717129E+00, 2.3850435257E+00, 8.9858019884E-01],
	[2.7320000000E+04, 1.9751074848E+01, 5.4169824372E+00, 5.4370913802E+00, 2.3857429171E+00, 8.9862978124E-01],
	[2.7325000000E+04, 1.9756928657E+01, 5.4169509924E+00, 5.4403123645E+00, 2.3864421977E+00, 8.9867933925E-01],
	[2.7330000000E+04, 1.9762783130E+01, 5.4169195535E+00, 5.4435346661E+00, 2.3871413675E+00, 8.9872887289E-01],
	[2.7335000000E+04, 1.9768638266E+01, 5.4168881205E+00, 5.4467582854E+00, 2.3878404264E+00, 8.9877838217E-01],
	[2.7340000000E+04, 1.9774494065E+01, 5.4168566935E+00, 5.4499832226E+00, 2.3885393743E+00, 8.9882786710E-01],
	[2.7345000000E+04, 1.9780350528E+01, 5.4168252724E+00, 5.4532094780E+00, 2.3892382112E+00, 8.9887732769E-01],
	[2.7350000000E+04, 1.9786207654E+01, 5.4167938572E+00, 5.4564370519E+00, 2.3899369370E+00, 8.9892676395E-01],
	[2.7355000000E+04, 1.9792065443E+01, 5.4167624480E+00, 5.4596659446E+00, 2.3906355516E+00, 8.9897617589E-01],
	[2.7360000000E+04, 1.9797923895E+01, 5.4167310447E+00, 5.4628961565E+00, 2.3913340550E+00, 8.9902556352E-01],
	[2.7365000000E+04, 1.9803783011E+01, 5.4166996473E+00, 5.4661276877E+00, 2.3920324471E+00, 8.9907492685E-01],
	[2.7370000000E+04, 1.9809642789E+01, 5.4166682558E+00, 5.4693605387E+00, 2.3927307278E+00, 8.9912426589E-01],
	[2.7375000000E+04, 1.9815503231E+01, 5.4166368702E+00, 5.4725947097E+00, 2.3934288971E+00, 8.9917358066E-01],
	[2.7380000000E+04, 1.9821364335E+01, 5.4166054906E+00, 5.4758302009E+00, 2.3941269549E+00, 8.9922287116E-01],
	[2.7385000000E+04, 1.9827226102E+01, 5.4165741168E+00, 5.4790670128E+00, 2.3948249011E+00, 8.9927213740E-01],
	[2.7390000000E+04, 1.9833088532E+01, 5.4165427490E+00, 5.4823056627E+00, 2.3955228345E+00, 8.9932137940E-01],
	[2.7395000000E+04, 1.9838951625E+01, 5.4165113871E+00, 5.4855457803E+00, 2.3962206839E+00, 8.9937059716E-01],
	[2.7400000000E+04, 1.9844815381E+01, 5.4164800310E+00, 5.4887872201E+00, 2.3969184216E+00, 8.9941979069E-01],
	[2.7405000000E+04, 1.9850679800E+01, 5.4164486809E+00, 5.4920299823E+00, 2.3976160474E+00, 8.9946896001E-01],
	[2.7410000000E+04, 1.9856544881E+01, 5.4164173367E+00, 5.4952740674E+00, 2.3983135613E+00, 8.9951810513E-01],
	[2.7415000000E+04, 1.9862410625E+01, 5.4163859984E+00, 5.4985194755E+00, 2.3990109633E+00, 8.9956722605E-01],
	[2.7420000000E+04, 1.9868277031E+01, 5.4163546660E+00, 5.5017662070E+00, 2.3997082531E+00, 8.9961632278E-01],
	[2.7425000000E+04, 1.9874144100E+01, 5.4163233394E+00, 5.5050142621E+00, 2.4004054309E+00, 8.9966539535E-01],
	[2.7430000000E+04, 1.9880011832E+01, 5.4162920188E+00, 5.5082636413E+00, 2.4011024965E+00, 8.9971444375E-01],
	[2.7435000000E+04, 1.9885880226E+01, 5.4162607040E+00, 5.5115143447E+00, 2.4017994498E+00, 8.9976346800E-01],
	[2.7440000000E+04, 1.9891749282E+01, 5.4162293952E+00, 5.5147663727E+00, 2.4024962909E+00, 8.9981246811E-01],
	[2.7445000000E+04, 1.9897619001E+01, 5.4161980922E+00, 5.5180197256E+00, 2.4031930195E+00, 8.9986144409E-01],
	[2.7450000000E+04, 1.9903489382E+01, 5.4161667951E+00, 5.5212744036E+00, 2.4038896357E+00, 8.9991039594E-01],
	[2.7455000000E+04, 1.9909360425E+01, 5.4161355039E+00, 5.5245304071E+00, 2.4045861394E+00, 8.9995932369E-01],
	[2.7460000000E+04, 1.9915232130E+01, 5.4161042186E+00, 5.5277877363E+00, 2.4052825305E+00, 9.0000822734E-01],
	[2.7465000000E+04, 1.9921104498E+01, 5.4160729391E+00, 5.5310463916E+00, 2.4059788090E+00, 9.0005710690E-01],
	[2.7470000000E+04, 1.9926977528E+01, 5.4160416655E+00, 5.5343063733E+00, 2.4066749748E+00, 9.0010596237E-01],
	[2.7475000000E+04, 1.9932851220E+01, 5.4160103978E+00, 5.5375676816E+00, 2.4073710278E+00, 9.0015479379E-01],
	[2.7480000000E+04, 1.9938725574E+01, 5.4159791360E+00, 5.5408303169E+00, 2.4080669680E+00, 9.0020360114E-01],
	[2.7485000000E+04, 1.9944600590E+01, 5.4159478800E+00, 5.5440942794E+00, 2.4087627953E+00, 9.0025238444E-01],
	[2.7490000000E+04, 1.9950476268E+01, 5.4159166299E+00, 5.5473595695E+00, 2.4094585097E+00, 9.0030114371E-01],
	[2.7495000000E+04, 1.9956352608E+01, 5.4158853857E+00, 5.5506261874E+00, 2.4101541110E+00, 9.0034987896E-01],
	[2.7500000000E+04, 1.9962229609E+01, 5.4158541473E+00, 5.5538941334E+00, 2.4108495992E+00, 9.0039859018E-01],
	[2.7505000000E+04, 1.9968107273E+01, 5.4158229148E+00, 5.5571634079E+00, 2.4115449742E+00, 9.0044727741E-01],
	[2.7510000000E+04, 1.9973985598E+01, 5.4157916881E+00, 5.5604340111E+00, 2.4122402360E+00, 9.0049594064E-01],
	[2.7515000000E+04, 1.9979864585E+01, 5.4157604673E+00, 5.5637059434E+00, 2.4129353846E+00, 9.0054457988E-01],
	[2.7520000000E+04, 1.9985744234E+01, 5.4157292524E+00, 5.5669792050E+00, 2.4136304198E+00, 9.0059319515E-01],
	[2.7525000000E+04, 1.9991624544E+01, 5.4156980433E+00, 5.5702537962E+00, 2.4143253416E+00, 9.0064178646E-01],
	[2.7530000000E+04, 1.9997505516E+01, 5.4156668400E+00, 5.5735297174E+00, 2.4150201499E+00, 9.0069035381E-01],
	[2.7535000000E+04, 2.0003387149E+01, 5.4156356426E+00, 5.5768069688E+00, 2.4157148447E+00, 9.0073889722E-01],
	[2.7540000000E+04, 2.0009269444E+01, 5.4156044510E+00, 5.5800855507E+00, 2.4164094258E+00, 9.0078741671E-01],
	[2.7545000000E+04, 2.0015152401E+01, 5.4155732653E+00, 5.5833654634E+00, 2.4171038933E+00, 9.0083591227E-01],
	[2.7550000000E+04, 2.0021036018E+01, 5.4155420854E+00, 5.5866467073E+00, 2.4177982471E+00, 9.0088438392E-01],
	[2.7555000000E+04, 2.0026920298E+01, 5.4155109114E+00, 5.5899292825E+00, 2.4184924870E+00, 9.0093283167E-01],
	[2.7560000000E+04, 2.0032805238E+01, 5.4154797432E+00, 5.5932131895E+00, 2.4191866131E+00, 9.0098125553E-01],
	[2.7565000000E+04, 2.0038690840E+01, 5.4154485808E+00, 5.5964984285E+00, 2.4198806253E+00, 9.0102965551E-01],
	[2.7570000000E+04, 2.0044577103E+01, 5.4154174243E+00, 5.5997849998E+00, 2.4205745235E+00, 9.0107803162E-01],
	[2.7575000000E+04, 2.0050464027E+01, 5.4153862735E+00, 5.6030729038E+00, 2.4212683077E+00, 9.0112638388E-01],
	[2.7580000000E+04, 2.0056351612E+01, 5.4153551286E+00, 5.6063621406E+00, 2.4219619777E+00, 9.0117471229E-01],
	[2.7585000000E+04, 2.0062239858E+01, 5.4153239896E+00, 5.6096527107E+00, 2.4226555336E+00, 9.0122301686E-01],
	[2.7590000000E+04, 2.0068128766E+01, 5.4152928563E+00, 5.6129446142E+00, 2.4233489752E+00, 9.0127129761E-01],
	[2.7595000000E+04, 2.0074018334E+01, 5.4152617289E+00, 5.6162378515E+00, 2.4240423025E+00, 9.0131955454E-01],
	[2.7600000000E+04, 2.0079908563E+01, 5.4152306073E+00, 5.6195324230E+00, 2.4247355155E+00, 9.0136778767E-01],
	[2.7605000000E+04, 2.0085799453E+01, 5.4151994915E+00, 5.6228283288E+00, 2.4254286140E+00, 9.0141599700E-01],
	[2.7610000000E+04, 2.0091691004E+01, 5.4151683816E+00, 5.6261255694E+00, 2.4261215981E+00, 9.0146418255E-01],
	[2.7615000000E+04, 2.0097595683E+01, 5.4151392035E+00, 5.6294241449E+00, 2.4268150362E+00, 9.0151234432E-01],
	[2.7620000000E+04, 2.0103512268E+01, 5.4151117672E+00, 5.6327240558E+00, 2.4275088729E+00, 9.0156048233E-01],
	[2.7625000000E+04, 2.0109429524E+01, 5.4150843361E+00, 5.6360253022E+00, 2.4282025959E+00, 9.0160859659E-01],
	[2.7630000000E+04, 2.0115347450E+01, 5.4150569100E+00, 5.6393278845E+00, 2.4288962049E+00, 9.0165668711E-01],
	[2.7635000000E+04, 2.0121266047E+01, 5.4150294891E+00, 5.6426318030E+00, 2.4295897000E+00, 9.0170475390E-01],
	[2.7640000000E+04, 2.0127185314E+01, 5.4150020732E+00, 5.6459370580E+00, 2.4302830811E+00, 9.0175279697E-01],
	[2.7645000000E+04, 2.0133105250E+01, 5.4149746625E+00, 5.6492436497E+00, 2.4309763481E+00, 9.0180081633E-01],
	[2.7650000000E+04, 2.0139025858E+01, 5.4149472568E+00, 5.6525515786E+00, 2.4316695009E+00, 9.0184881198E-01],
	[2.7655000000E+04, 2.0144947135E+01, 5.4149198562E+00, 5.6558608448E+00, 2.4323625396E+00, 9.0189678395E-01],
	[2.7660000000E+04, 2.0150869082E+01, 5.4148924608E+00, 5.6591714487E+00, 2.4330554640E+00, 9.0194473225E-01],
	[2.7665000000E+04, 2.0156791699E+01, 5.4148650704E+00, 5.6624833906E+00, 2.4337482740E+00, 9.0199265687E-01],
	[2.7670000000E+04, 2.0162714986E+01, 5.4148376851E+00, 5.6657966708E+00, 2.4344409697E+00, 9.0204055784E-01],
	[2.7675000000E+04, 2.0168638943E+01, 5.4148103049E+00, 5.6691112895E+00, 2.4351335509E+00, 9.0208843516E-01],
	[2.7680000000E+04, 2.0174563570E+01, 5.4147829298E+00, 5.6724272471E+00, 2.4358260176E+00, 9.0213628885E-01],
	[2.7685000000E+04, 2.0180488867E+01, 5.4147555597E+00, 5.6757445439E+00, 2.4365183697E+00, 9.0218411891E-01],
	[2.7690000000E+04, 2.0186414833E+01, 5.4147281948E+00, 5.6790631801E+00, 2.4372106072E+00, 9.0223192535E-01],
	[2.7695000000E+04, 2.0192341469E+01, 5.4147008349E+00, 5.6823831561E+00, 2.4379027299E+00, 9.0227970820E-01],
	[2.7700000000E+04, 2.0198268775E+01, 5.4146734801E+00, 5.6857044722E+00, 2.4385947379E+00, 9.0232746744E-01],
	[2.7705000000E+04, 2.0204196750E+01, 5.4146461304E+00, 5.6890271286E+00, 2.4392866311E+00, 9.0237520311E-01],
	[2.7710000000E+04, 2.0210125395E+01, 5.4146187857E+00, 5.6923511257E+00, 2.4399784095E+00, 9.0242291521E-01],
	[2.7715000000E+04, 2.0216054710E+01, 5.4145914461E+00, 5.6956764637E+00, 2.4406700728E+00, 9.0247060374E-01],
	[2.7720000000E+04, 2.0221984694E+01, 5.4145641116E+00, 5.6990031430E+00, 2.4413616212E+00, 9.0251826872E-01],
	[2.7725000000E+04, 2.0227915348E+01, 5.4145367822E+00, 5.7023311639E+00, 2.4420530545E+00, 9.0256591016E-01],
	[2.7730000000E+04, 2.0233846670E+01, 5.4145094578E+00, 5.7056605266E+00, 2.4427443727E+00, 9.0261352807E-01],
	[2.7735000000E+04, 2.0239778663E+01, 5.4144821385E+00, 5.7089912315E+00, 2.4434355756E+00, 9.0266112247E-01],
	[2.7740000000E+04, 2.0245711324E+01, 5.4144548242E+00, 5.7123232788E+00, 2.4441266634E+00, 9.0270869335E-01],
	[2.7745000000E+04, 2.0251644655E+01, 5.4144275151E+00, 5.7156566688E+00, 2.4448176358E+00, 9.0275624074E-01],
	[2.7750000000E+04, 2.0257578655E+01, 5.4144002109E+00, 5.7189914020E+00, 2.4455084929E+00, 9.0280376464E-01],
	[2.7755000000E+04, 2.0263513325E+01, 5.4143729118E+00, 5.7223274784E+00, 2.4461992345E+00, 9.0285126506E-01],
	[2.7760000000E+04, 2.0269448663E+01, 5.4143456178E+00, 5.7256648985E+00, 2.4468898607E+00, 9.0289874202E-01],
	[2.7765000000E+04, 2.0275384670E+01, 5.4143183289E+00, 5.7290036625E+00, 2.4475803713E+00, 9.0294619552E-01],
	[2.7770000000E+04, 2.0281321347E+01, 5.4142910449E+00, 5.7323437708E+00, 2.4482707663E+00, 9.0299362558E-01],
	[2.7775000000E+04, 2.0287258692E+01, 5.4142637661E+00, 5.7356852237E+00, 2.4489610456E+00, 9.0304103220E-01],
	[2.7780000000E+04, 2.0293196707E+01, 5.4142364923E+00, 5.7390280213E+00, 2.4496512092E+00, 9.0308841540E-01],
	[2.7785000000E+04, 2.0299135390E+01, 5.4142092235E+00, 5.7423721641E+00, 2.4503412570E+00, 9.0313577518E-01],
	[2.7790000000E+04, 2.0305074743E+01, 5.4141819598E+00, 5.7457176523E+00, 2.4510311889E+00, 9.0318311157E-01],
	[2.7795000000E+04, 2.0311014764E+01, 5.4141547011E+00, 5.7490644863E+00, 2.4517210050E+00, 9.0323042456E-01],
	[2.7800000000E+04, 2.0316955453E+01, 5.4141274474E+00, 5.7524126663E+00, 2.4524107051E+00, 9.0327771417E-01],
	[2.7805000000E+04, 2.0322896812E+01, 5.4141001988E+00, 5.7557621926E+00, 2.4531002891E+00, 9.0332498041E-01],
	[2.7810000000E+04, 2.0328838839E+01, 5.4140729553E+00, 5.7591130656E+00, 2.4537897571E+00, 9.0337222329E-01],
	[2.7815000000E+04, 2.0334781535E+01, 5.4140457167E+00, 5.7624652855E+00, 2.4544791089E+00, 9.0341944282E-01],
	[2.7820000000E+04, 2.0340724900E+01, 5.4140184832E+00, 5.7658188526E+00, 2.4551683445E+00, 9.0346663902E-01],
	[2.7825000000E+04, 2.0346668933E+01, 5.4139912547E+00, 5.7691737672E+00, 2.4558574639E+00, 9.0351381188E-01],
	[2.7830000000E+04, 2.0352613634E+01, 5.4139640313E+00, 5.7725300297E+00, 2.4565464669E+00, 9.0356096143E-01],
	[2.7835000000E+04, 2.0358559004E+01, 5.4139368129E+00, 5.7758876402E+00, 2.4572353536E+00, 9.0360808767E-01],
	[2.7840000000E+04, 2.0364505043E+01, 5.4139095995E+00, 5.7792465992E+00, 2.4579241238E+00, 9.0365519062E-01],
	[2.7845000000E+04, 2.0370451749E+01, 5.4138823911E+00, 5.7826069069E+00, 2.4586127775E+00, 9.0370227028E-01],
	[2.7850000000E+04, 2.0376399124E+01, 5.4138551878E+00, 5.7859685637E+00, 2.4593013147E+00, 9.0374932667E-01],
	[2.7855000000E+04, 2.0382347168E+01, 5.4138279895E+00, 5.7893315697E+00, 2.4599897352E+00, 9.0379635979E-01],
	[2.7860000000E+04, 2.0388295879E+01, 5.4138007962E+00, 5.7926959254E+00, 2.4606780391E+00, 9.0384336966E-01],
	[2.7865000000E+04, 2.0394245259E+01, 5.4137736079E+00, 5.7960616310E+00, 2.4613662262E+00, 9.0389035628E-01],
	[2.7870000000E+04, 2.0400195307E+01, 5.4137464246E+00, 5.7994286868E+00, 2.4620542965E+00, 9.0393731967E-01],
	[2.7875000000E+04, 2.0406146023E+01, 5.4137192463E+00, 5.8027970931E+00, 2.4627422500E+00, 9.0398425984E-01],
	[2.7880000000E+04, 2.0412097407E+01, 5.4136920731E+00, 5.8061668502E+00, 2.4634300866E+00, 9.0403117679E-01],
	[2.7885000000E+04, 2.0418049459E+01, 5.4136649048E+00, 5.8095379584E+00, 2.4641178062E+00, 9.0407807053E-01],
	[2.7890000000E+04, 2.0424002179E+01, 5.4136377416E+00, 5.8129104180E+00, 2.4648054088E+00, 9.0412494108E-01],
	[2.7895000000E+04, 2.0429955567E+01, 5.4136105834E+00, 5.8162842294E+00, 2.4654928943E+00, 9.0417178843E-01],
	[2.7900000000E+04, 2.0435909623E+01, 5.4135834302E+00, 5.8196593927E+00, 2.4661802626E+00, 9.0421861260E-01],
	[2.7905000000E+04, 2.0441864347E+01, 5.4135562819E+00, 5.8230359083E+00, 2.4668675138E+00, 9.0426541360E-01],
	[2.7910000000E+04, 2.0447819738E+01, 5.4135291387E+00, 5.8264137766E+00, 2.4675546477E+00, 9.0431219144E-01],
	[2.7915000000E+04, 2.0453775797E+01, 5.4135020005E+00, 5.8297929977E+00, 2.4682416643E+00, 9.0435894613E-01],
	[2.7920000000E+04, 2.0459732524E+01, 5.4134748673E+00, 5.8331735721E+00, 2.4689285635E+00, 9.0440567767E-01],
	[2.7925000000E+04, 2.0465689919E+01, 5.4134477390E+00, 5.8365554999E+00, 2.4696153453E+00, 9.0445238609E-01],
	[2.7930000000E+04, 2.0471647981E+01, 5.4134206158E+00, 5.8399387815E+00, 2.4703020096E+00, 9.0449907137E-01],
	[2.7935000000E+04, 2.0477606711E+01, 5.4133934975E+00, 5.8433234173E+00, 2.4709885564E+00, 9.0454573354E-01],
	[2.7940000000E+04, 2.0483566108E+01, 5.4133663843E+00, 5.8467094074E+00, 2.4716749856E+00, 9.0459237261E-01],
	[2.7945000000E+04, 2.0489526173E+01, 5.4133392760E+00, 5.8500967522E+00, 2.4723612971E+00, 9.0463898858E-01],
	[2.7950000000E+04, 2.0495486905E+01, 5.4133121727E+00, 5.8534854521E+00, 2.4730474909E+00, 9.0468558146E-01],
	[2.7955000000E+04, 2.0501448304E+01, 5.4132850744E+00, 5.8568755072E+00, 2.4737335669E+00, 9.0473215127E-01],
	[2.7960000000E+04, 2.0507410371E+01, 5.4132579811E+00, 5.8602669179E+00, 2.4744195251E+00, 9.0477869800E-01],
	[2.7965000000E+04, 2.0513373105E+01, 5.4132308928E+00, 5.8636596845E+00, 2.4751053654E+00, 9.0482522168E-01],
	[2.7970000000E+04, 2.0519336507E+01, 5.4132038094E+00, 5.8670538072E+00, 2.4757910877E+00, 9.0487172231E-01],
	[2.7975000000E+04, 2.0525300575E+01, 5.4131767310E+00, 5.8704492865E+00, 2.4764766921E+00, 9.0491819990E-01],
	[2.7980000000E+04, 2.0531265311E+01, 5.4131496576E+00, 5.8738461226E+00, 2.4771621784E+00, 9.0496465446E-01],
	[2.7985000000E+04, 2.0537230714E+01, 5.4131225892E+00, 5.8772443157E+00, 2.4778475466E+00, 9.0501108599E-01],
	[2.7990000000E+04, 2.0543196784E+01, 5.4130955257E+00, 5.8806438662E+00, 2.4785327967E+00, 9.0505749452E-01],
	[2.7995000000E+04, 2.0549163521E+01, 5.4130684672E+00, 5.8840447744E+00, 2.4792179285E+00, 9.0510388004E-01],
	[2.8000000000E+04, 2.0555130925E+01, 5.4130414137E+00, 5.8874470406E+00, 2.4799029420E+00, 9.0515024257E-01],
	[2.8005000000E+04, 2.0561098995E+01, 5.4130143651E+00, 5.8908506651E+00, 2.4805878372E+00, 9.0519658212E-01],
	[2.8010000000E+04, 2.0567067733E+01, 5.4129873215E+00, 5.8942556482E+00, 2.4812726140E+00, 9.0524289869E-01],
	[2.8015000000E+04, 2.0573037138E+01, 5.4129602829E+00, 5.8976619901E+00, 2.4819572723E+00, 9.0528919230E-01],
	[2.8020000000E+04, 2.0579007209E+01, 5.4129332492E+00, 5.9010696912E+00, 2.4826418122E+00, 9.0533546295E-01],
	[2.8025000000E+04, 2.0584977947E+01, 5.4129062205E+00, 5.9044787518E+00, 2.4833262335E+00, 9.0538171065E-01],
	[2.8030000000E+04, 2.0590949352E+01, 5.4128791967E+00, 5.9078891722E+00, 2.4840105362E+00, 9.0542793542E-01],
	[2.8035000000E+04, 2.0596921424E+01, 5.4128521779E+00, 5.9113009526E+00, 2.4846947202E+00, 9.0547413727E-01],
	[2.8040000000E+04, 2.0602894162E+01, 5.4128251640E+00, 5.9147140934E+00, 2.4853787854E+00, 9.0552031619E-01],
	[2.8045000000E+04, 2.0608867567E+01, 5.4127981551E+00, 5.9181285949E+00, 2.4860627319E+00, 9.0556647221E-01],
	[2.8050000000E+04, 2.0614841638E+01, 5.4127711512E+00, 5.9215444574E+00, 2.4867465596E+00, 9.0561260533E-01],
	[2.8055000000E+04, 2.0620816376E+01, 5.4127441522E+00, 5.9249616811E+00, 2.4874302684E+00, 9.0565871555E-01],
	[2.8060000000E+04, 2.0626806429E+01, 5.4127193919E+00, 5.9283802664E+00, 2.4881145433E+00, 9.0570480290E-01],
	[2.8065000000E+04, 2.0632806074E+01, 5.4126959962E+00, 5.9318002136E+00, 2.4887991171E+00, 9.0575086738E-01],
	[2.8070000000E+04, 2.0638806395E+01, 5.4126726047E+00, 5.9352215229E+00, 2.4894835727E+00, 9.0579690900E-01],
	[2.8075000000E+04, 2.0644807393E+01, 5.4126492175E+00, 5.9386441948E+00, 2.4901679100E+00, 9.0584292777E-01],
	[2.8080000000E+04, 2.0650809066E+01, 5.4126258345E+00, 5.9420682294E+00, 2.4908521289E+00, 9.0588892369E-01],
	[2.8085000000E+04, 2.0656811414E+01, 5.4126024558E+00, 5.9454936270E+00, 2.4915362295E+00, 9.0593489679E-01],
	[2.8090000000E+04, 2.0662814438E+01, 5.4125790814E+00, 5.9489203880E+00, 2.4922202116E+00, 9.0598084706E-01],
	[2.8095000000E+04, 2.0668818138E+01, 5.4125557112E+00, 5.9523485127E+00, 2.4929040751E+00, 9.0602677451E-01],
	[2.8100000000E+04, 2.0674822514E+01, 5.4125323453E+00, 5.9557780014E+00, 2.4935878201E+00, 9.0607267916E-01],
	[2.8105000000E+04, 2.0680827565E+01, 5.4125089836E+00, 5.9592088543E+00, 2.4942714465E+00, 9.0611856102E-01],
	[2.8110000000E+04, 2.0686833291E+01, 5.4124856262E+00, 5.9626410718E+00, 2.4949549543E+00, 9.0616442010E-01],
	[2.8115000000E+04, 2.0692839693E+01, 5.4124622731E+00, 5.9660746541E+00, 2.4956383432E+00, 9.0621025639E-01],
	[2.8120000000E+04, 2.0698846771E+01, 5.4124389242E+00, 5.9695096016E+00, 2.4963216135E+00, 9.0625606993E-01],
	[2.8125000000E+04, 2.0704854523E+01, 5.4124155796E+00, 5.9729459146E+00, 2.4970047648E+00, 9.0630186070E-01],
	[2.8130000000E+04, 2.0710862951E+01, 5.4123922392E+00, 5.9763835933E+00, 2.4976877973E+00, 9.0634762873E-01],
	[2.8135000000E+04, 2.0716872055E+01, 5.4123689030E+00, 5.9798226381E+00, 2.4983707109E+00, 9.0639337402E-01],
	[2.8140000000E+04, 2.0722881833E+01, 5.4123455712E+00, 5.9832630492E+00, 2.4990535054E+00, 9.0643909659E-01],
	[2.8145000000E+04, 2.0728892287E+01, 5.4123222435E+00, 5.9867048271E+00, 2.4997361809E+00, 9.0648479643E-01],
	[2.8150000000E+04, 2.0734903416E+01, 5.4122989201E+00, 5.9901479718E+00, 2.5004187373E+00, 9.0653047357E-01],
	[2.8155000000E+04, 2.0740915220E+01, 5.4122756010E+00, 5.9935924838E+00, 2.5011011745E+00, 9.0657612801E-01],
	[2.8160000000E+04, 2.0746927699E+01, 5.4122522860E+00, 5.9970383634E+00, 2.5017834925E+00, 9.0662175976E-01],
	[2.8165000000E+04, 2.0752940853E+01, 5.4122289754E+00, 6.0004856109E+00, 2.5024656912E+00, 9.0666736882E-01],
	[2.8170000000E+04, 2.0758954681E+01, 5.4122056689E+00, 6.0039342265E+00, 2.5031477706E+00, 9.0671295522E-01],
	[2.8175000000E+04, 2.0764969185E+01, 5.4121823667E+00, 6.0073842105E+00, 2.5038297307E+00, 9.0675851896E-01],
	[2.8180000000E+04, 2.0770984364E+01, 5.4121590688E+00, 6.0108355633E+00, 2.5045115713E+00, 9.0680406005E-01],
	[2.8185000000E+04, 2.0777000217E+01, 5.4121357750E+00, 6.0142882852E+00, 2.5051932924E+00, 9.0684957849E-01],
	[2.8190000000E+04, 2.0783016746E+01, 5.4121124855E+00, 6.0177423764E+00, 2.5058748940E+00, 9.0689507430E-01],
	[2.8195000000E+04, 2.0789033949E+01, 5.4120892003E+00, 6.0211978372E+00, 2.5065563760E+00, 9.0694054749E-01],
	[2.8200000000E+04, 2.0795051827E+01, 5.4120659192E+00, 6.0246546681E+00, 2.5072377384E+00, 9.0698599807E-01],
	[2.8205000000E+04, 2.0801070379E+01, 5.4120426424E+00, 6.0281128691E+00, 2.5079189811E+00, 9.0703142604E-01],
	[2.8210000000E+04, 2.0807089606E+01, 5.4120193698E+00, 6.0315724408E+00, 2.5086001040E+00, 9.0707683142E-01],
	[2.8215000000E+04, 2.0813109507E+01, 5.4119961015E+00, 6.0350333832E+00, 2.5092811071E+00, 9.0712221421E-01],
	[2.8220000000E+04, 2.0819130083E+01, 5.4119728373E+00, 6.0384956969E+00, 2.5099619904E+00, 9.0716757443E-01],
	[2.8225000000E+04, 2.0825151334E+01, 5.4119495774E+00, 6.0419593819E+00, 2.5106427538E+00, 9.0721291208E-01],
	[2.8230000000E+04, 2.0831173259E+01, 5.4119263217E+00, 6.0454244388E+00, 2.5113233972E+00, 9.0725822718E-01],
	[2.8235000000E+04, 2.0837195858E+01, 5.4119030702E+00, 6.0488908676E+00, 2.5120039206E+00, 9.0730351973E-01],
	[2.8240000000E+04, 2.0843219132E+01, 5.4118798230E+00, 6.0523586689E+00, 2.5126843239E+00, 9.0734878975E-01],
	[2.8245000000E+04, 2.0849243080E+01, 5.4118565799E+00, 6.0558278427E+00, 2.5133646072E+00, 9.0739403724E-01],
	[2.8250000000E+04, 2.0855267702E+01, 5.4118333411E+00, 6.0592983896E+00, 2.5140447702E+00, 9.0743926221E-01],
	[2.8255000000E+04, 2.0861292999E+01, 5.4118101065E+00, 6.0627703096E+00, 2.5147248130E+00, 9.0748446468E-01],
	[2.8260000000E+04, 2.0867318969E+01, 5.4117868760E+00, 6.0662436032E+00, 2.5154047356E+00, 9.0752964464E-01],
	[2.8265000000E+04, 2.0873345614E+01, 5.4117636498E+00, 6.0697182707E+00, 2.5160845379E+00, 9.0757480212E-01],
	[2.8270000000E+04, 2.0879372933E+01, 5.4117404279E+00, 6.0731943123E+00, 2.5167642197E+00, 9.0761993712E-01],
	[2.8275000000E+04, 2.0885400926E+01, 5.4117172101E+00, 6.0766717284E+00, 2.5174437812E+00, 9.0766504965E-01],
	[2.8280000000E+04, 2.0891429592E+01, 5.4116939965E+00, 6.0801505192E+00, 2.5181232221E+00, 9.0771013972E-01],
	[2.8285000000E+04, 2.0897458933E+01, 5.4116707871E+00, 6.0836306850E+00, 2.5188025425E+00, 9.0775520734E-01],
	[2.8290000000E+04, 2.0903488948E+01, 5.4116475819E+00, 6.0871122262E+00, 2.5194817424E+00, 9.0780025253E-01],
	[2.8295000000E+04, 2.0909519636E+01, 5.4116243810E+00, 6.0905951431E+00, 2.5201608216E+00, 9.0784527528E-01],
	[2.8300000000E+04, 2.0915550999E+01, 5.4116011842E+00, 6.0940794359E+00, 2.5208397801E+00, 9.0789027561E-01],
	[2.8305000000E+04, 2.0921583035E+01, 5.4115779916E+00, 6.0975651049E+00, 2.5215186179E+00, 9.0793525352E-01],
	[2.8310000000E+04, 2.0927615745E+01, 5.4115548032E+00, 6.1010521505E+00, 2.5221973349E+00, 9.0798020904E-01],
	[2.8315000000E+04, 2.0933649128E+01, 5.4115316190E+00, 6.1045405729E+00, 2.5228759311E+00, 9.0802514217E-01],
	[2.8320000000E+04, 2.0939683186E+01, 5.4115084390E+00, 6.1080303725E+00, 2.5235544063E+00, 9.0807005291E-01],
	[2.8325000000E+04, 2.0945717916E+01, 5.4114852632E+00, 6.1115215495E+00, 2.5242327607E+00, 9.0811494128E-01],
	[2.8330000000E+04, 2.0951753321E+01, 5.4114620916E+00, 6.1150141042E+00, 2.5249109940E+00, 9.0815980729E-01],
	[2.8335000000E+04, 2.0957789398E+01, 5.4114389242E+00, 6.1185080370E+00, 2.5255891063E+00, 9.0820465094E-01],
	[2.8340000000E+04, 2.0963826150E+01, 5.4114157610E+00, 6.1220033482E+00, 2.5262670975E+00, 9.0824947225E-01],
	[2.8345000000E+04, 2.0969863574E+01, 5.4113926019E+00, 6.1255000380E+00, 2.5269449675E+00, 9.0829427123E-01],
	[2.8350000000E+04, 2.0975901673E+01, 5.4113694470E+00, 6.1289981067E+00, 2.5276227164E+00, 9.0833904788E-01],
	[2.8355000000E+04, 2.0981940444E+01, 5.4113462964E+00, 6.1324975547E+00, 2.5283003440E+00, 9.0838380222E-01],
	[2.8360000000E+04, 2.0987979889E+01, 5.4113231498E+00, 6.1359983822E+00, 2.5289778503E+00, 9.0842853425E-01],
	[2.8365000000E+04, 2.0994020007E+01, 5.4113000075E+00, 6.1395005895E+00, 2.5296552353E+00, 9.0847324399E-01],
	[2.8370000000E+04, 2.1000060798E+01, 5.4112768694E+00, 6.1430041770E+00, 2.5303324988E+00, 9.0851793144E-01],
	[2.8375000000E+04, 2.1006102262E+01, 5.4112537354E+00, 6.1465091450E+00, 2.5310096409E+00, 9.0856259662E-01],
	[2.8380000000E+04, 2.1012144400E+01, 5.4112306056E+00, 6.1500154937E+00, 2.5316866616E+00, 9.0860723953E-01],
	[2.8385000000E+04, 2.1018187210E+01, 5.4112074800E+00, 6.1535232234E+00, 2.5323635606E+00, 9.0865186018E-01],
	[2.8390000000E+04, 2.1024230694E+01, 5.4111843585E+00, 6.1570323345E+00, 2.5330403381E+00, 9.0869645859E-01],
	[2.8395000000E+04, 2.1030274850E+01, 5.4111612413E+00, 6.1605428272E+00, 2.5337169939E+00, 9.0874103476E-01],
	[2.8400000000E+04, 2.1036319680E+01, 5.4111381281E+00, 6.1640547018E+00, 2.5343935281E+00, 9.0878558870E-01],
	[2.8405000000E+04, 2.1042365182E+01, 5.4111150192E+00, 6.1675679587E+00, 2.5350699404E+00, 9.0883012042E-01],
	[2.8410000000E+04, 2.1048411357E+01, 5.4110919144E+00, 6.1710825982E+00, 2.5357462310E+00, 9.0887462994E-01],
	[2.8415000000E+04, 2.1054458205E+01, 5.4110688138E+00, 6.1745986204E+00, 2.5364223998E+00, 9.0891911726E-01],
	[2.8420000000E+04, 2.1060505726E+01, 5.4110457174E+00, 6.1781160259E+00, 2.5370984466E+00, 9.0896358239E-01],
	[2.8425000000E+04, 2.1066553920E+01, 5.4110226251E+00, 6.1816348147E+00, 2.5377743715E+00, 9.0900802534E-01],
	[2.8430000000E+04, 2.1072602786E+01, 5.4109995369E+00, 6.1851549874E+00, 2.5384501744E+00, 9.0905244612E-01],
	[2.8435000000E+04, 2.1078652325E+01, 5.4109764530E+00, 6.1886765440E+00, 2.5391258552E+00, 9.0909684474E-01],
	[2.8440000000E+04, 2.1084702536E+01, 5.4109533732E+00, 6.1921994850E+00, 2.5398014140E+00, 9.0914122122E-01],
	[2.8445000000E+04, 2.1090753420E+01, 5.4109302975E+00, 6.1957238106E+00, 2.5404768506E+00, 9.0918557555E-01],
	[2.8450000000E+04, 2.1096804977E+01, 5.4109072260E+00, 6.1992495212E+00, 2.5411521650E+00, 9.0922990775E-01],
	[2.8455000000E+04, 2.1102857206E+01, 5.4108841586E+00, 6.2027766171E+00, 2.5418273572E+00, 9.0927421783E-01],
	[2.8460000000E+04, 2.1108910107E+01, 5.4108610954E+00, 6.2063050984E+00, 2.5425024271E+00, 9.0931850581E-01],
	[2.8465000000E+04, 2.1114963681E+01, 5.4108380364E+00, 6.2098349656E+00, 2.5431773747E+00, 9.0936277168E-01],
	[2.8470000000E+04, 2.1121017927E+01, 5.4108149815E+00, 6.2133662190E+00, 2.5438521998E+00, 9.0940701546E-01],
	[2.8475000000E+04, 2.1127072845E+01, 5.4107919307E+00, 6.2168988588E+00, 2.5445269025E+00, 9.0945123716E-01],
	[2.8480000000E+04, 2.1133128436E+01, 5.4107688841E+00, 6.2204328853E+00, 2.5452014828E+00, 9.0949543678E-01],
	[2.8485000000E+04, 2.1139184699E+01, 5.4107458417E+00, 6.2239682989E+00, 2.5458759405E+00, 9.0953961435E-01],
	[2.8490000000E+04, 2.1145241634E+01, 5.4107228033E+00, 6.2275050999E+00, 2.5465502756E+00, 9.0958376986E-01],
	[2.8495000000E+04, 2.1151299241E+01, 5.4106997692E+00, 6.2310432884E+00, 2.5472244881E+00, 9.0962790333E-01],
	[2.8500000000E+04, 2.1157357520E+01, 5.4106767391E+00, 6.2345828649E+00, 2.5478985779E+00, 9.0967201477E-01],
	[2.8505000000E+04, 2.1163416471E+01, 5.4106537132E+00, 6.2381238297E+00, 2.5485725450E+00, 9.0971610418E-01],
	[2.8510000000E+04, 2.1169482794E+01, 5.4106317002E+00, 6.2416661830E+00, 2.5492467104E+00, 9.0976017158E-01],
	[2.8515000000E+04, 2.1175566519E+01, 5.4106122089E+00, 6.2452099252E+00, 2.5499215550E+00, 9.0980421698E-01],
	[2.8520000000E+04, 2.1181650925E+01, 5.4105927211E+00, 6.2487550565E+00, 2.5505962775E+00, 9.0984824038E-01],
	[2.8525000000E+04, 2.1187736013E+01, 5.4105732369E+00, 6.2523015772E+00, 2.5512708779E+00, 9.0989224180E-01],
	[2.8530000000E+04, 2.1193821781E+01, 5.4105537561E+00, 6.2558494877E+00, 2.5519453562E+00, 9.0993622125E-01],
	[2.8535000000E+04, 2.1199908231E+01, 5.4105342787E+00, 6.2593987883E+00, 2.5526197122E+00, 9.0998017873E-01],
	[2.8540000000E+04, 2.1205995362E+01, 5.4105148049E+00, 6.2629494791E+00, 2.5532939460E+00, 9.1002411426E-01],
	[2.8545000000E+04, 2.1212083174E+01, 5.4104953346E+00, 6.2665015607E+00, 2.5539680574E+00, 9.1006802784E-01],
	[2.8550000000E+04, 2.1218171667E+01, 5.4104758677E+00, 6.2700550332E+00, 2.5546420465E+00, 9.1011191949E-01],
	[2.8555000000E+04, 2.1224260840E+01, 5.4104564043E+00, 6.2736098969E+00, 2.5553159132E+00, 9.1015578921E-01],
	[2.8560000000E+04, 2.1230350695E+01, 5.4104369444E+00, 6.2771661522E+00, 2.5559896575E+00, 9.1019963702E-01],
	[2.8565000000E+04, 2.1236441230E+01, 5.4104174880E+00, 6.2807237993E+00, 2.5566632792E+00, 9.1024346292E-01],
	[2.8570000000E+04, 2.1242532447E+01, 5.4103980350E+00, 6.2842828386E+00, 2.5573367784E+00, 9.1028726692E-01],
	[2.8575000000E+04, 2.1248624344E+01, 5.4103785855E+00, 6.2878432703E+00, 2.5580101550E+00, 9.1033104904E-01],
	[2.8580000000E+04, 2.1254716921E+01, 5.4103591395E+00, 6.2914050948E+00, 2.5586834090E+00, 9.1037480928E-01],
	[2.8585000000E+04, 2.1260810180E+01, 5.4103396970E+00, 6.2949683123E+00, 2.5593565402E+00, 9.1041854766E-01],
	[2.8590000000E+04, 2.1266904119E+01, 5.4103202579E+00, 6.2985329232E+00, 2.5600295488E+00, 9.1046226418E-01],
	[2.8595000000E+04, 2.1272998738E+01, 5.4103008223E+00, 6.3020989277E+00, 2.5607024346E+00, 9.1050595885E-01],
	[2.8600000000E+04, 2.1279094038E+01, 5.4102813902E+00, 6.3056663262E+00, 2.5613751975E+00, 9.1054963169E-01],
	[2.8605000000E+04, 2.1285190019E+01, 5.4102619615E+00, 6.3092351189E+00, 2.5620478375E+00, 9.1059328270E-01],
	[2.8610000000E+04, 2.1291286680E+01, 5.4102425363E+00, 6.3128053062E+00, 2.5627203547E+00, 9.1063691189E-01],
	[2.8615000000E+04, 2.1297384022E+01, 5.4102231146E+00, 6.3163768883E+00, 2.5633927488E+00, 9.1068051927E-01],
	[2.8620000000E+04, 2.1303482043E+01, 5.4102036963E+00, 6.3199498656E+00, 2.5640650200E+00, 9.1072410486E-01],
	[2.8625000000E+04, 2.1309580746E+01, 5.4101842815E+00, 6.3235242383E+00, 2.5647371681E+00, 9.1076766865E-01],
	[2.8630000000E+04, 2.1315680128E+01, 5.4101648702E+00, 6.3271000068E+00, 2.5654091931E+00, 9.1081121067E-01],
	[2.8635000000E+04, 2.1321780191E+01, 5.4101454623E+00, 6.3306771714E+00, 2.5660810949E+00, 9.1085473092E-01],
	[2.8640000000E+04, 2.1327880934E+01, 5.4101260578E+00, 6.3342557323E+00, 2.5667528735E+00, 9.1089822942E-01],
	[2.8645000000E+04, 2.1333982357E+01, 5.4101066569E+00, 6.3378356898E+00, 2.5674245289E+00, 9.1094170616E-01],
	[2.8650000000E+04, 2.1340084460E+01, 5.4100872593E+00, 6.3414170444E+00, 2.5680960610E+00, 9.1098516116E-01],
	[2.8655000000E+04, 2.1346187243E+01, 5.4100678653E+00, 6.3449997961E+00, 2.5687674697E+00, 9.1102859444E-01],
	[2.8660000000E+04, 2.1352290706E+01, 5.4100484747E+00, 6.3485839455E+00, 2.5694387551E+00, 9.1107200600E-01],
	[2.8665000000E+04, 2.1358394849E+01, 5.4100290875E+00, 6.3521694927E+00, 2.5701099170E+00, 9.1111539584E-01],
	[2.8670000000E+04, 2.1364499672E+01, 5.4100097038E+00, 6.3557564380E+00, 2.5707809554E+00, 9.1115876399E-01],
	[2.8675000000E+04, 2.1370605175E+01, 5.4099903235E+00, 6.3593447818E+00, 2.5714518704E+00, 9.1120211045E-01],
	[2.8680000000E+04, 2.1376711358E+01, 5.4099709467E+00, 6.3629345244E+00, 2.5721226617E+00, 9.1124543522E-01],
	[2.8685000000E+04, 2.1382818221E+01, 5.4099515734E+00, 6.3665256660E+00, 2.5727933295E+00, 9.1128873833E-01],
	[2.8690000000E+04, 2.1388925763E+01, 5.4099322034E+00, 6.3701182070E+00, 2.5734638736E+00, 9.1133201978E-01],
	[2.8695000000E+04, 2.1395033986E+01, 5.4099128370E+00, 6.3737121477E+00, 2.5741342939E+00, 9.1137527957E-01],
	[2.8700000000E+04, 2.1401142888E+01, 5.4098934739E+00, 6.3773074883E+00, 2.5748045906E+00, 9.1141851773E-01],
	[2.8705000000E+04, 2.1407252469E+01, 5.4098741144E+00, 6.3809042292E+00, 2.5754747634E+00, 9.1146173426E-01],
	[2.8710000000E+04, 2.1413362730E+01, 5.4098547582E+00, 6.3845023706E+00, 2.5761448124E+00, 9.1150492916E-01],
	[2.8715000000E+04, 2.1419473671E+01, 5.4098354055E+00, 6.3881019130E+00, 2.5768147375E+00, 9.1154810245E-01],
	[2.8720000000E+04, 2.1425585291E+01, 5.4098160562E+00, 6.3917028564E+00, 2.5774845387E+00, 9.1159125414E-01],
	[2.8725000000E+04, 2.1431697590E+01, 5.4097967104E+00, 6.3953052014E+00, 2.5781542158E+00, 9.1163438424E-01],
	[2.8730000000E+04, 2.1437810570E+01, 5.4097773680E+00, 6.3989089481E+00, 2.5788237690E+00, 9.1167749276E-01],
	[2.8735000000E+04, 2.1443924228E+01, 5.4097580291E+00, 6.4025140969E+00, 2.5794931981E+00, 9.1172057971E-01],
	[2.8740000000E+04, 2.1450038566E+01, 5.4097386935E+00, 6.4061206480E+00, 2.5801625031E+00, 9.1176364510E-01],
	[2.8745000000E+04, 2.1456153583E+01, 5.4097193614E+00, 6.4097286019E+00, 2.5808316840E+00, 9.1180668893E-01],
	[2.8750000000E+04, 2.1462269279E+01, 5.4097000328E+00, 6.4133379587E+00, 2.5815007406E+00, 9.1184971122E-01],
	[2.8755000000E+04, 2.1468385655E+01, 5.4096807076E+00, 6.4169487187E+00, 2.5821696730E+00, 9.1189271198E-01],
	[2.8760000000E+04, 2.1474502709E+01, 5.4096613857E+00, 6.4205608824E+00, 2.5828384811E+00, 9.1193569122E-01],
	[2.8765000000E+04, 2.1480620443E+01, 5.4096420674E+00, 6.4241744499E+00, 2.5835071649E+00, 9.1197864894E-01],
	[2.8770000000E+04, 2.1486738856E+01, 5.4096227524E+00, 6.4277894216E+00, 2.5841757243E+00, 9.1202158516E-01],
	[2.8775000000E+04, 2.1492857948E+01, 5.4096034409E+00, 6.4314057977E+00, 2.5848441593E+00, 9.1206449989E-01],
	[2.8780000000E+04, 2.1498977719E+01, 5.4095841328E+00, 6.4350235786E+00, 2.5855124698E+00, 9.1210739314E-01],
	[2.8785000000E+04, 2.1505098169E+01, 5.4095648281E+00, 6.4386427647E+00, 2.5861806558E+00, 9.1215026491E-01],
	[2.8790000000E+04, 2.1511219297E+01, 5.4095455269E+00, 6.4422633561E+00, 2.5868487172E+00, 9.1219311522E-01],
	[2.8795000000E+04, 2.1517341105E+01, 5.4095262291E+00, 6.4458853531E+00, 2.5875166541E+00, 9.1223594407E-01],
	[2.8800000000E+04, 2.1523463591E+01, 5.4095069346E+00, 6.4495087562E+00, 2.5881844663E+00, 9.1227875149E-01],
	[2.8805000000E+04, 2.1529586757E+01, 5.4094876436E+00, 6.4531335655E+00, 2.5888521538E+00, 9.1232153747E-01],
	[2.8810000000E+04, 2.1535710601E+01, 5.4094683561E+00, 6.4567597814E+00, 2.5895197166E+00, 9.1236430202E-01],
	[2.8815000000E+04, 2.1541835123E+01, 5.4094490719E+00, 6.4603874042E+00, 2.5901871546E+00, 9.1240704516E-01],
	[2.8820000000E+04, 2.1547960325E+01, 5.4094297912E+00, 6.4640164342E+00, 2.5908544678E+00, 9.1244976690E-01],
	[2.8825000000E+04, 2.1554086205E+01, 5.4094105138E+00, 6.4676468716E+00, 2.5915216561E+00, 9.1249246724E-01],
	[2.8830000000E+04, 2.1560212763E+01, 5.4093912399E+00, 6.4712787169E+00, 2.5921887196E+00, 9.1253514620E-01],
	[2.8835000000E+04, 2.1566340000E+01, 5.4093719694E+00, 6.4749119702E+00, 2.5928556581E+00, 9.1257780379E-01],
	[2.8840000000E+04, 2.1572467916E+01, 5.4093527023E+00, 6.4785466319E+00, 2.5935224716E+00, 9.1262044001E-01],
	[2.8845000000E+04, 2.1578596510E+01, 5.4093334386E+00, 6.4821827024E+00, 2.5941891600E+00, 9.1266305487E-01],
	[2.8850000000E+04, 2.1584725782E+01, 5.4093141783E+00, 6.4858201818E+00, 2.5948557234E+00, 9.1270564840E-01],
	[2.8855000000E+04, 2.1590855733E+01, 5.4092949215E+00, 6.4894590704E+00, 2.5955221617E+00, 9.1274822058E-01],
	[2.8860000000E+04, 2.1596986362E+01, 5.4092756680E+00, 6.4930993687E+00, 2.5961884748E+00, 9.1279077144E-01],
	[2.8865000000E+04, 2.1603117669E+01, 5.4092564179E+00, 6.4967410769E+00, 2.5968546627E+00, 9.1283330099E-01],
	[2.8870000000E+04, 2.1609249655E+01, 5.4092371712E+00, 6.5003841953E+00, 2.5975207254E+00, 9.1287580923E-01],
	[2.8875000000E+04, 2.1615382319E+01, 5.4092179280E+00, 6.5040287241E+00, 2.5981866627E+00, 9.1291829618E-01],
	[2.8880000000E+04, 2.1621515660E+01, 5.4091986881E+00, 6.5076746638E+00, 2.5988524748E+00, 9.1296076184E-01],
	[2.8885000000E+04, 2.1627649680E+01, 5.4091794517E+00, 6.5113220145E+00, 2.5995181614E+00, 9.1300320623E-01],
	[2.8890000000E+04, 2.1633784379E+01, 5.4091602186E+00, 6.5149707767E+00, 2.6001837227E+00, 9.1304562935E-01],
	[2.8895000000E+04, 2.1639919755E+01, 5.4091409889E+00, 6.5186209506E+00, 2.6008491585E+00, 9.1308803121E-01],
	[2.8900000000E+04, 2.1646055809E+01, 5.4091217626E+00, 6.5222725364E+00, 2.6015144687E+00, 9.1313041183E-01],
	[2.8905000000E+04, 2.1652192541E+01, 5.4091025398E+00, 6.5259255346E+00, 2.6021796535E+00, 9.1317277121E-01],
	[2.8910000000E+04, 2.1658329950E+01, 5.4090833203E+00, 6.5295799453E+00, 2.6028447126E+00, 9.1321510937E-01],
	[2.8915000000E+04, 2.1664468038E+01, 5.4090641042E+00, 6.5332357690E+00, 2.6035096461E+00, 9.1325742631E-01],
	[2.8920000000E+04, 2.1670606804E+01, 5.4090448915E+00, 6.5368930059E+00, 2.6041744540E+00, 9.1329972204E-01],
	[2.8925000000E+04, 2.1676746247E+01, 5.4090256822E+00, 6.5405516562E+00, 2.6048391361E+00, 9.1334199658E-01],
	[2.8930000000E+04, 2.1682886368E+01, 5.4090064762E+00, 6.5442117204E+00, 2.6055036925E+00, 9.1338424994E-01],
	[2.8935000000E+04, 2.1689027167E+01, 5.4089872737E+00, 6.5478731987E+00, 2.6061681231E+00, 9.1342648211E-01],
	[2.8940000000E+04, 2.1695168643E+01, 5.4089680745E+00, 6.5515360914E+00, 2.6068324278E+00, 9.1346869312E-01],
	[2.8945000000E+04, 2.1701310797E+01, 5.4089488788E+00, 6.5552003988E+00, 2.6074966067E+00, 9.1351088297E-01],
	[2.8950000000E+04, 2.1707453628E+01, 5.4089296864E+00, 6.5588661213E+00, 2.6081606597E+00, 9.1355305168E-01],
	[2.8955000000E+04, 2.1713597137E+01, 5.4089104974E+00, 6.5625332590E+00, 2.6088245866E+00, 9.1359519925E-01],
	[2.8960000000E+04, 2.1719741324E+01, 5.4088913118E+00, 6.5662018124E+00, 2.6094883876E+00, 9.1363732569E-01],
	[2.8965000000E+04, 2.1725886188E+01, 5.4088721295E+00, 6.5698717817E+00, 2.6101520625E+00, 9.1367943102E-01],
	[2.8970000000E+04, 2.1732043280E+01, 5.4088546679E+00, 6.5735431672E+00, 2.6108161782E+00, 9.1372151523E-01],
	[2.8975000000E+04, 2.1738212786E+01, 5.4088389529E+00, 6.5772159692E+00, 2.6114807439E+00, 9.1376357835E-01],
	[2.8980000000E+04, 2.1744382978E+01, 5.4088232407E+00, 6.5808901880E+00, 2.6121451842E+00, 9.1380562039E-01],
	[2.8985000000E+04, 2.1750553857E+01, 5.4088075312E+00, 6.5845658240E+00, 2.6128094990E+00, 9.1384764134E-01],
	[2.8990000000E+04, 2.1756725422E+01, 5.4087918245E+00, 6.5882428774E+00, 2.6134736884E+00, 9.1388964123E-01],
	[2.8995000000E+04, 2.1762897674E+01, 5.4087761205E+00, 6.5919213485E+00, 2.6141377523E+00, 9.1393162006E-01],
	[2.9000000000E+04, 2.1769070611E+01, 5.4087604193E+00, 6.5956012376E+00, 2.6148016906E+00, 9.1397357785E-01],
	[2.9005000000E+04, 2.1775244236E+01, 5.4087447208E+00, 6.5992825451E+00, 2.6154655033E+00, 9.1401551459E-01],
	[2.9010000000E+04, 2.1781418546E+01, 5.4087290251E+00, 6.6029652712E+00, 2.6161291904E+00, 9.1405743031E-01],
	[2.9015000000E+04, 2.1787593542E+01, 5.4087133321E+00, 6.6066494162E+00, 2.6167927518E+00, 9.1409932501E-01],
	[2.9020000000E+04, 2.1793769225E+01, 5.4086976419E+00, 6.6103349805E+00, 2.6174561875E+00, 9.1414119871E-01],
	[2.9025000000E+04, 2.1799945593E+01, 5.4086819545E+00, 6.6140219642E+00, 2.6181194974E+00, 9.1418305140E-01],
	[2.9030000000E+04, 2.1806122648E+01, 5.4086662697E+00, 6.6177103679E+00, 2.6187826816E+00, 9.1422488311E-01],
	[2.9035000000E+04, 2.1812300389E+01, 5.4086505878E+00, 6.6214001916E+00, 2.6194457399E+00, 9.1426669384E-01],
	[2.9040000000E+04, 2.1818478816E+01, 5.4086349085E+00, 6.6250914358E+00, 2.6201086723E+00, 9.1430848360E-01],
	[2.9045000000E+04, 2.1824657928E+01, 5.4086192321E+00, 6.6287841008E+00, 2.6207714788E+00, 9.1435025240E-01],
	[2.9050000000E+04, 2.1830837727E+01, 5.4086035583E+00, 6.6324781868E+00, 2.6214341593E+00, 9.1439200025E-01],
	[2.9055000000E+04, 2.1837018211E+01, 5.4085878873E+00, 6.6361736941E+00, 2.6220967138E+00, 9.1443372716E-01],
	[2.9060000000E+04, 2.1843199381E+01, 5.4085722191E+00, 6.6398706231E+00, 2.6227591423E+00, 9.1447543315E-01],
	[2.9065000000E+04, 2.1849381237E+01, 5.4085565536E+00, 6.6435689740E+00, 2.6234214447E+00, 9.1451711822E-01],
	[2.9070000000E+04, 2.1855563779E+01, 5.4085408908E+00, 6.6472687472E+00, 2.6240836210E+00, 9.1455878238E-01],
	[2.9075000000E+04, 2.1861747006E+01, 5.4085252308E+00, 6.6509699429E+00, 2.6247456712E+00, 9.1460042564E-01],
	[2.9080000000E+04, 2.1867930919E+01, 5.4085095735E+00, 6.6546725614E+00, 2.6254075951E+00, 9.1464204801E-01],
	[2.9085000000E+04, 2.1874115518E+01, 5.4084939189E+00, 6.6583766032E+00, 2.6260693928E+00, 9.1468364950E-01],
	[2.9090000000E+04, 2.1880300802E+01, 5.4084782671E+00, 6.6620820683E+00, 2.6267310642E+00, 9.1472523012E-01],
	[2.9095000000E+04, 2.1886486771E+01, 5.4084626180E+00, 6.6657889573E+00, 2.6273926093E+00, 9.1476678989E-01],
	[2.9100000000E+04, 2.1892673426E+01, 5.4084469716E+00, 6.6694972703E+00, 2.6280540280E+00, 9.1480832880E-01],
	[2.9105000000E+04, 2.1898860767E+01, 5.4084313280E+00, 6.6732070076E+00, 2.6287153203E+00, 9.1484984688E-01],
	[2.9110000000E+04, 2.1905048793E+01, 5.4084156871E+00, 6.6769181696E+00, 2.6293764862E+00, 9.1489134413E-01],
	[2.9115000000E+04, 2.1911237504E+01, 5.4084000490E+00, 6.6806307566E+00, 2.6300375256E+00, 9.1493282055E-01],
	[2.9120000000E+04, 2.1917426901E+01, 5.4083844136E+00, 6.6843447688E+00, 2.6306984385E+00, 9.1497427616E-01],
	[2.9125000000E+04, 2.1923616982E+01, 5.4083687809E+00, 6.6880602066E+00, 2.6313592248E+00, 9.1501571098E-01],
	[2.9130000000E+04, 2.1929807749E+01, 5.4083531509E+00, 6.6917770703E+00, 2.6320198846E+00, 9.1505712499E-01],
	[2.9135000000E+04, 2.1935999201E+01, 5.4083375237E+00, 6.6954953601E+00, 2.6326804177E+00, 9.1509851822E-01],
	[2.9140000000E+04, 2.1942191339E+01, 5.4083218992E+00, 6.6992150764E+00, 2.6333408241E+00, 9.1513989068E-01],
	[2.9145000000E+04, 2.1948384161E+01, 5.4083062774E+00, 6.7029362195E+00, 2.6340011038E+00, 9.1518124236E-01],
	[2.9150000000E+04, 2.1954577668E+01, 5.4082906583E+00, 6.7066587897E+00, 2.6346612568E+00, 9.1522257329E-01],
	[2.9155000000E+04, 2.1960771861E+01, 5.4082750420E+00, 6.7103827872E+00, 2.6353212830E+00, 9.1526388347E-01],
	[2.9160000000E+04, 2.1966966738E+01, 5.4082594284E+00, 6.7141082124E+00, 2.6359811823E+00, 9.1530517290E-01],
	[2.9165000000E+04, 2.1973162301E+01, 5.4082438175E+00, 6.7178350656E+00, 2.6366409548E+00, 9.1534644161E-01],
	[2.9170000000E+04, 2.1979358548E+01, 5.4082282093E+00, 6.7215633471E+00, 2.6373006004E+00, 9.1538768959E-01],
	[2.9175000000E+04, 2.1985555480E+01, 5.4082126038E+00, 6.7252930571E+00, 2.6379601190E+00, 9.1542891686E-01],
	[2.9180000000E+04, 2.1991753097E+01, 5.4081970011E+00, 6.7290241961E+00, 2.6386195106E+00, 9.1547012342E-01],
	[2.9185000000E+04, 2.1997951398E+01, 5.4081814011E+00, 6.7327567642E+00, 2.6392787753E+00, 9.1551130929E-01],
	[2.9190000000E+04, 2.2004150385E+01, 5.4081658038E+00, 6.7364907618E+00, 2.6399379128E+00, 9.1555247447E-01],
	[2.9195000000E+04, 2.2010350055E+01, 5.4081502092E+00, 6.7402261892E+00, 2.6405969233E+00, 9.1559361897E-01],
	[2.9200000000E+04, 2.2016550411E+01, 5.4081346174E+00, 6.7439630467E+00, 2.6412558066E+00, 9.1563474280E-01],
	[2.9205000000E+04, 2.2022751451E+01, 5.4081190282E+00, 6.7477013346E+00, 2.6419145628E+00, 9.1567584597E-01],
	[2.9210000000E+04, 2.2028953176E+01, 5.4081034418E+00, 6.7514410532E+00, 2.6425731917E+00, 9.1571692849E-01],
	[2.9215000000E+04, 2.2035155585E+01, 5.4080878581E+00, 6.7551822028E+00, 2.6432316934E+00, 9.1575799037E-01],
	[2.9220000000E+04, 2.2041358679E+01, 5.4080722771E+00, 6.7589247837E+00, 2.6438900679E+00, 9.1579903162E-01],
	[2.9225000000E+04, 2.2047562457E+01, 5.4080566988E+00, 6.7626687962E+00, 2.6445483149E+00, 9.1584005224E-01],
	[2.9230000000E+04, 2.2053766920E+01, 5.4080411232E+00, 6.7664142406E+00, 2.6452064347E+00, 9.1588105224E-01],
	[2.9235000000E+04, 2.2059972066E+01, 5.4080255503E+00, 6.7701611172E+00, 2.6458644270E+00, 9.1592203164E-01],
	[2.9240000000E+04, 2.2066177898E+01, 5.4080099801E+00, 6.7739094263E+00, 2.6465222919E+00, 9.1596299044E-01],
	[2.9245000000E+04, 2.2072384413E+01, 5.4079944126E+00, 6.7776591683E+00, 2.6471800293E+00, 9.1600392865E-01],
	[2.9250000000E+04, 2.2078591613E+01, 5.4079788479E+00, 6.7814103433E+00, 2.6478376392E+00, 9.1604484628E-01],
	[2.9255000000E+04, 2.2084799496E+01, 5.4079632858E+00, 6.7851629517E+00, 2.6484951215E+00, 9.1608574334E-01],
	[2.9260000000E+04, 2.2091008064E+01, 5.4079477265E+00, 6.7889169939E+00, 2.6491524763E+00, 9.1612661983E-01],
	[2.9265000000E+04, 2.2097217316E+01, 5.4079321698E+00, 6.7926724701E+00, 2.6498097034E+00, 9.1616747578E-01],
	[2.9270000000E+04, 2.2103427252E+01, 5.4079166159E+00, 6.7964293806E+00, 2.6504668029E+00, 9.1620831118E-01],
	[2.9275000000E+04, 2.2109637872E+01, 5.4079010646E+00, 6.8001877257E+00, 2.6511237746E+00, 9.1624912605E-01],
	[2.9280000000E+04, 2.2115849177E+01, 5.4078855161E+00, 6.8039475058E+00, 2.6517806187E+00, 9.1628992039E-01],
	[2.9285000000E+04, 2.2122061164E+01, 5.4078699703E+00, 6.8077087211E+00, 2.6524373349E+00, 9.1633069421E-01],
	[2.9290000000E+04, 2.2128273836E+01, 5.4078544271E+00, 6.8114713719E+00, 2.6530939234E+00, 9.1637144753E-01],
	[2.9295000000E+04, 2.2134487192E+01, 5.4078388867E+00, 6.8152354585E+00, 2.6537503840E+00, 9.1641218035E-01],
	[2.9300000000E+04, 2.2140701231E+01, 5.4078233489E+00, 6.8190009813E+00, 2.6544067167E+00, 9.1645289267E-01],
	[2.9305000000E+04, 2.2146915955E+01, 5.4078078139E+00, 6.8227679405E+00, 2.6550629215E+00, 9.1649358452E-01],
	[2.9310000000E+04, 2.2153131362E+01, 5.4077922815E+00, 6.8265363365E+00, 2.6557189984E+00, 9.1653425589E-01],
	[2.9315000000E+04, 2.2159347452E+01, 5.4077767518E+00, 6.8303061694E+00, 2.6563749472E+00, 9.1657490681E-01],
	[2.9320000000E+04, 2.2165564227E+01, 5.4077612249E+00, 6.8340774398E+00, 2.6570307681E+00, 9.1661553726E-01],
	[2.9325000000E+04, 2.2171781684E+01, 5.4077457006E+00, 6.8378501477E+00, 2.6576864608E+00, 9.1665614728E-01],
	[2.9330000000E+04, 2.2177999826E+01, 5.4077301790E+00, 6.8416242937E+00, 2.6583420255E+00, 9.1669673685E-01],
	[2.9335000000E+04, 2.2184218651E+01, 5.4077146601E+00, 6.8453998778E+00, 2.6589974620E+00, 9.1673730600E-01],
	[2.9340000000E+04, 2.2190438159E+01, 5.4076991439E+00, 6.8491769006E+00, 2.6596527704E+00, 9.1677785474E-01],
	[2.9345000000E+04, 2.2196658351E+01, 5.4076836304E+00, 6.8529553621E+00, 2.6603079505E+00, 9.1681838306E-01],
	[2.9350000000E+04, 2.2202879226E+01, 5.4076681195E+00, 6.8567352628E+00, 2.6609630024E+00, 9.1685889099E-01],
	[2.9355000000E+04, 2.2209100785E+01, 5.4076526114E+00, 6.8605166030E+00, 2.6616179260E+00, 9.1689937852E-01],
	[2.9360000000E+04, 2.2215323027E+01, 5.4076371059E+00, 6.8642993830E+00, 2.6622727213E+00, 9.1693984567E-01],
	[2.9365000000E+04, 2.2221545952E+01, 5.4076216032E+00, 6.8680836030E+00, 2.6629273883E+00, 9.1698029245E-01],
	[2.9370000000E+04, 2.2227769560E+01, 5.4076061031E+00, 6.8718692633E+00, 2.6635819268E+00, 9.1702071887E-01],
	[2.9375000000E+04, 2.2233993851E+01, 5.4075906057E+00, 6.8756563644E+00, 2.6642363369E+00, 9.1706112493E-01],
	[2.9380000000E+04, 2.2240218826E+01, 5.4075751109E+00, 6.8794449064E+00, 2.6648906186E+00, 9.1710151064E-01],
	[2.9385000000E+04, 2.2246444484E+01, 5.4075596189E+00, 6.8832348897E+00, 2.6655447718E+00, 9.1714187602E-01],
	[2.9390000000E+04, 2.2252670825E+01, 5.4075441295E+00, 6.8870263145E+00, 2.6661987964E+00, 9.1718222108E-01],
	[2.9395000000E+04, 2.2258897848E+01, 5.4075286428E+00, 6.8908191812E+00, 2.6668526925E+00, 9.1722254581E-01],
	[2.9400000000E+04, 2.2265125555E+01, 5.4075131588E+00, 6.8946134901E+00, 2.6675064600E+00, 9.1726285024E-01],
	[2.9405000000E+04, 2.2271353945E+01, 5.4074976775E+00, 6.8984092415E+00, 2.6681600988E+00, 9.1730313436E-01],
	[2.9410000000E+04, 2.2277583017E+01, 5.4074821989E+00, 6.9022064357E+00, 2.6688136090E+00, 9.1734339819E-01],
	[2.9415000000E+04, 2.2283812773E+01, 5.4074667229E+00, 6.9060050729E+00, 2.6694669905E+00, 9.1738364175E-01],
	[2.9420000000E+04, 2.2290043211E+01, 5.4074512496E+00, 6.9098051535E+00, 2.6701202432E+00, 9.1742386502E-01],
	[2.9425000000E+04, 2.2296274332E+01, 5.4074357789E+00, 6.9136066779E+00, 2.6707733671E+00, 9.1746406804E-01],
	[2.9430000000E+04, 2.2302506136E+01, 5.4074203110E+00, 6.9174096462E+00, 2.6714263622E+00, 9.1750425080E-01],
	[2.9435000000E+04, 2.2308743912E+01, 5.4074056224E+00, 6.9212140588E+00, 2.6720794941E+00, 9.1754441331E-01],
	[2.9440000000E+04, 2.2315000218E+01, 5.4073935560E+00, 6.9250199160E+00, 2.6727333932E+00, 9.1758455559E-01],
	[2.9445000000E+04, 2.2321257215E+01, 5.4073814918E+00, 6.9288272181E+00, 2.6733871642E+00, 9.1762467764E-01],
	[2.9450000000E+04, 2.2327514905E+01, 5.4073694296E+00, 6.9326359654E+00, 2.6740408070E+00, 9.1766477947E-01],
	[2.9455000000E+04, 2.2333773285E+01, 5.4073573695E+00, 6.9364461583E+00, 2.6746943215E+00, 9.1770486109E-01],
	[2.9460000000E+04, 2.2340032358E+01, 5.4073453115E+00, 6.9402577969E+00, 2.6753477078E+00, 9.1774492251E-01],
	[2.9465000000E+04, 2.2346292121E+01, 5.4073332556E+00, 6.9440708816E+00, 2.6760009658E+00, 9.1778496374E-01],
	[2.9470000000E+04, 2.2352552577E+01, 5.4073212017E+00, 6.9478854128E+00, 2.6766540955E+00, 9.1782498479E-01],
	[2.9475000000E+04, 2.2358813723E+01, 5.4073091499E+00, 6.9517013906E+00, 2.6773070968E+00, 9.1786498566E-01],
	[2.9480000000E+04, 2.2365075561E+01, 5.4072971002E+00, 6.9555188155E+00, 2.6779599697E+00, 9.1790496637E-01],
	[2.9485000000E+04, 2.2371338090E+01, 5.4072850525E+00, 6.9593376877E+00, 2.6786127142E+00, 9.1794492693E-01],
	[2.9490000000E+04, 2.2377601311E+01, 5.4072730069E+00, 6.9631580075E+00, 2.6792653302E+00, 9.1798486734E-01],
	[2.9495000000E+04, 2.2383865222E+01, 5.4072609634E+00, 6.9669797752E+00, 2.6799178177E+00, 9.1802478761E-01],
	[2.9500000000E+04, 2.2390129825E+01, 5.4072489219E+00, 6.9708029912E+00, 2.6805701767E+00, 9.1806468776E-01],
	[2.9505000000E+04, 2.2396395119E+01, 5.4072368826E+00, 6.9746276557E+00, 2.6812224070E+00, 9.1810456778E-01],
	[2.9510000000E+04, 2.2402661104E+01, 5.4072248452E+00, 6.9784537691E+00, 2.6818745088E+00, 9.1814442770E-01],
	[2.9515000000E+04, 2.2408927780E+01, 5.4072128100E+00, 6.9822813315E+00, 2.6825264820E+00, 9.1818426752E-01],
	[2.9520000000E+04, 2.2415195147E+01, 5.4072007768E+00, 6.9861103434E+00, 2.6831783264E+00, 9.1822408724E-01],
	[2.9525000000E+04, 2.2421463205E+01, 5.4071887457E+00, 6.9899408051E+00, 2.6838300422E+00, 9.1826388689E-01],
	[2.9530000000E+04, 2.2427731954E+01, 5.4071767166E+00, 6.9937727168E+00, 2.6844816292E+00, 9.1830366646E-01],
	[2.9535000000E+04, 2.2434001394E+01, 5.4071646896E+00, 6.9976060788E+00, 2.6851330875E+00, 9.1834342596E-01],
	[2.9540000000E+04, 2.2440271525E+01, 5.4071526647E+00, 7.0014408915E+00, 2.6857844169E+00, 9.1838316541E-01],
	[2.9545000000E+04, 2.2446542346E+01, 5.4071406418E+00, 7.0052771551E+00, 2.6864356175E+00, 9.1842288482E-01],
	[2.9550000000E+04, 2.2452813859E+01, 5.4071286210E+00, 7.0091148700E+00, 2.6870866892E+00, 9.1846258419E-01],
	[2.9555000000E+04, 2.2459086062E+01, 5.4071166023E+00, 7.0129540365E+00, 2.6877376320E+00, 9.1850226353E-01],
	[2.9560000000E+04, 2.2465358955E+01, 5.4071045856E+00, 7.0167946548E+00, 2.6883884459E+00, 9.1854192286E-01],
	[2.9565000000E+04, 2.2471632540E+01, 5.4070925710E+00, 7.0206367253E+00, 2.6890391308E+00, 9.1858156217E-01],
	[2.9570000000E+04, 2.2477906815E+01, 5.4070805584E+00, 7.0244802482E+00, 2.6896896867E+00, 9.1862118148E-01],
	[2.9575000000E+04, 2.2484181780E+01, 5.4070685479E+00, 7.0283252239E+00, 2.6903401136E+00, 9.1866078081E-01],
	[2.9580000000E+04, 2.2490457436E+01, 5.4070565394E+00, 7.0321716527E+00, 2.6909904113E+00, 9.1870036015E-01],
	[2.9585000000E+04, 2.2496733782E+01, 5.4070445330E+00, 7.0360195348E+00, 2.6916405800E+00, 9.1873991952E-01],
	[2.9590000000E+04, 2.2503010819E+01, 5.4070325287E+00, 7.0398688706E+00, 2.6922906195E+00, 9.1877945892E-01],
	[2.9595000000E+04, 2.2509288547E+01, 5.4070205264E+00, 7.0437196604E+00, 2.6929405299E+00, 9.1881897838E-01],
	[2.9600000000E+04, 2.2515566964E+01, 5.4070085261E+00, 7.0475719045E+00, 2.6935903111E+00, 9.1885847788E-01],
	[2.9605000000E+04, 2.2521846072E+01, 5.4069965280E+00, 7.0514256032E+00, 2.6942399630E+00, 9.1889795745E-01],
	[2.9610000000E+04, 2.2528125871E+01, 5.4069845318E+00, 7.0552807567E+00, 2.6948894856E+00, 9.1893741709E-01],
	[2.9615000000E+04, 2.2534406359E+01, 5.4069725378E+00, 7.0591373655E+00, 2.6955388790E+00, 9.1897685682E-01],
	[2.9620000000E+04, 2.2540687538E+01, 5.4069605457E+00, 7.0629954297E+00, 2.6961881430E+00, 9.1901627664E-01],
	[2.9625000000E+04, 2.2546969407E+01, 5.4069485558E+00, 7.0668549498E+00, 2.6968372776E+00, 9.1905567655E-01],
	[2.9630000000E+04, 2.2553251965E+01, 5.4069365678E+00, 7.0707159259E+00, 2.6974862829E+00, 9.1909505658E-01],
	[2.9635000000E+04, 2.2559535214E+01, 5.4069245820E+00, 7.0745783584E+00, 2.6981351587E+00, 9.1913441672E-01],
	[2.9640000000E+04, 2.2565819154E+01, 5.4069125981E+00, 7.0784422477E+00, 2.6987839051E+00, 9.1917375700E-01],
	[2.9645000000E+04, 2.2572103783E+01, 5.4069006164E+00, 7.0823075939E+00, 2.6994325219E+00, 9.1921307741E-01],
	[2.9650000000E+04, 2.2578389102E+01, 5.4068886366E+00, 7.0861743975E+00, 2.7000810092E+00, 9.1925237796E-01],
	[2.9655000000E+04, 2.2584675110E+01, 5.4068766589E+00, 7.0900426586E+00, 2.7007293670E+00, 9.1929165868E-01],
	[2.9660000000E+04, 2.2590961809E+01, 5.4068646833E+00, 7.0939123777E+00, 2.7013775952E+00, 9.1933091955E-01],
	[2.9665000000E+04, 2.2597249198E+01, 5.4068527097E+00, 7.0977835550E+00, 2.7020256937E+00, 9.1937016060E-01],
	[2.9670000000E+04, 2.2603537276E+01, 5.4068407382E+00, 7.1016561909E+00, 2.7026736626E+00, 9.1940938183E-01],
	[2.9675000000E+04, 2.2609826044E+01, 5.4068287687E+00, 7.1055302855E+00, 2.7033215018E+00, 9.1944858326E-01],
	[2.9680000000E+04, 2.2616115502E+01, 5.4068168012E+00, 7.1094058393E+00, 2.7039692113E+00, 9.1948776489E-01],
	[2.9685000000E+04, 2.2622405649E+01, 5.4068048358E+00, 7.1132828525E+00, 2.7046167911E+00, 9.1952692672E-01],
	[2.9690000000E+04, 2.2628696487E+01, 5.4067928724E+00, 7.1171613255E+00, 2.7052642410E+00, 9.1956606878E-01],
	[2.9695000000E+04, 2.2634988013E+01, 5.4067809111E+00, 7.1210412584E+00, 2.7059115612E+00, 9.1960519106E-01],
	[2.9700000000E+04, 2.2641280229E+01, 5.4067689518E+00, 7.1249226518E+00, 2.7065587515E+00, 9.1964429358E-01],
	[2.9705000000E+04, 2.2647573135E+01, 5.4067569945E+00, 7.1288055057E+00, 2.7072058119E+00, 9.1968337635E-01],
	[2.9710000000E+04, 2.2653866730E+01, 5.4067450393E+00, 7.1326898207E+00, 2.7078527424E+00, 9.1972243938E-01],
	[2.9715000000E+04, 2.2660161015E+01, 5.4067330861E+00, 7.1365755968E+00, 2.7084995430E+00, 9.1976148267E-01],
	[2.9720000000E+04, 2.2666455989E+01, 5.4067211350E+00, 7.1404628345E+00, 2.7091462136E+00, 9.1980050623E-01],
	[2.9725000000E+04, 2.2672751652E+01, 5.4067091859E+00, 7.1443515341E+00, 2.7097927542E+00, 9.1983951008E-01],
	[2.9730000000E+04, 2.2679048005E+01, 5.4066972388E+00, 7.1482416959E+00, 2.7104391648E+00, 9.1987849423E-01],
	[2.9735000000E+04, 2.2685345047E+01, 5.4066852938E+00, 7.1521333201E+00, 2.7110854453E+00, 9.1991745867E-01],
	[2.9740000000E+04, 2.2691642778E+01, 5.4066733508E+00, 7.1560264070E+00, 2.7117315957E+00, 9.1995640342E-01],
	[2.9745000000E+04, 2.2697941198E+01, 5.4066614098E+00, 7.1599209571E+00, 2.7123776160E+00, 9.1999532850E-01],
	[2.9750000000E+04, 2.2704240307E+01, 5.4066494709E+00, 7.1638169705E+00, 2.7130235062E+00, 9.2003423391E-01],
	[2.9755000000E+04, 2.2710540106E+01, 5.4066375340E+00, 7.1677144475E+00, 2.7136692661E+00, 9.2007311965E-01],
	[2.9760000000E+04, 2.2716840594E+01, 5.4066255991E+00, 7.1716133886E+00, 2.7143148959E+00, 9.2011198574E-01],
	[2.9765000000E+04, 2.2723141770E+01, 5.4066136663E+00, 7.1755137939E+00, 2.7149603954E+00, 9.2015083219E-01],
	[2.9770000000E+04, 2.2729443636E+01, 5.4066017355E+00, 7.1794156639E+00, 2.7156057646E+00, 9.2018965901E-01],
	[2.9775000000E+04, 2.2735746190E+01, 5.4065898067E+00, 7.1833189987E+00, 2.7162510035E+00, 9.2022846620E-01],
	[2.9780000000E+04, 2.2742049434E+01, 5.4065778799E+00, 7.1872237987E+00, 2.7168961121E+00, 9.2026725377E-01],
	[2.9785000000E+04, 2.2748353366E+01, 5.4065659552E+00, 7.1911300642E+00, 2.7175410903E+00, 9.2030602174E-01],
	[2.9790000000E+04, 2.2754657987E+01, 5.4065540325E+00, 7.1950377955E+00, 2.7181859381E+00, 9.2034477011E-01],
	[2.9795000000E+04, 2.2760963297E+01, 5.4065421119E+00, 7.1989469928E+00, 2.7188306555E+00, 9.2038349890E-01],
	[2.9800000000E+04, 2.2767269295E+01, 5.4065301932E+00, 7.2028576566E+00, 2.7194752424E+00, 9.2042220811E-01],
	[2.9805000000E+04, 2.2773575982E+01, 5.4065182766E+00, 7.2067697872E+00, 2.7201196989E+00, 9.2046089774E-01],
	[2.9810000000E+04, 2.2779883358E+01, 5.4065063620E+00, 7.2106833847E+00, 2.7207640248E+00, 9.2049956782E-01],
	[2.9815000000E+04, 2.2786191423E+01, 5.4064944495E+00, 7.2145984495E+00, 2.7214082202E+00, 9.2053821835E-01],
	[2.9820000000E+04, 2.2792500176E+01, 5.4064825389E+00, 7.2185149819E+00, 2.7220522850E+00, 9.2057684933E-01],
	[2.9825000000E+04, 2.2798809618E+01, 5.4064706304E+00, 7.2224329823E+00, 2.7226962192E+00, 9.2061546078E-01],
	[2.9830000000E+04, 2.2805119748E+01, 5.4064587239E+00, 7.2263524509E+00, 2.7233400227E+00, 9.2065405271E-01],
	[2.9835000000E+04, 2.2811430566E+01, 5.4064468195E+00, 7.2302733880E+00, 2.7239836956E+00, 9.2069262512E-01],
	[2.9840000000E+04, 2.2817742073E+01, 5.4064349170E+00, 7.2341957940E+00, 2.7246272378E+00, 9.2073117803E-01],
	[2.9845000000E+04, 2.2824054269E+01, 5.4064230166E+00, 7.2381196691E+00, 2.7252706493E+00, 9.2076971145E-01],
	[2.9850000000E+04, 2.2830367152E+01, 5.4064111182E+00, 7.2420450136E+00, 2.7259139300E+00, 9.2080822537E-01],
	[2.9855000000E+04, 2.2836680724E+01, 5.4063992218E+00, 7.2459718278E+00, 2.7265570800E+00, 9.2084671982E-01],
	[2.9860000000E+04, 2.2842994984E+01, 5.4063873274E+00, 7.2499001122E+00, 2.7272000991E+00, 9.2088519481E-01],
	[2.9865000000E+04, 2.2849309933E+01, 5.4063754351E+00, 7.2538298668E+00, 2.7278429874E+00, 9.2092365033E-01],
	[2.9870000000E+04, 2.2855625569E+01, 5.4063635447E+00, 7.2577610921E+00, 2.7284857448E+00, 9.2096208640E-01],
	[2.9875000000E+04, 2.2861941894E+01, 5.4063516564E+00, 7.2616937884E+00, 2.7291283713E+00, 9.2100050303E-01],
	[2.9880000000E+04, 2.2868258907E+01, 5.4063397701E+00, 7.2656279559E+00, 2.7297708669E+00, 9.2103890024E-01],
	[2.9885000000E+04, 2.2874576608E+01, 5.4063278858E+00, 7.2695635950E+00, 2.7304132316E+00, 9.2107727802E-01],
	[2.9890000000E+04, 2.2880894997E+01, 5.4063160036E+00, 7.2735007059E+00, 2.7310554652E+00, 9.2111563638E-01],
	[2.9895000000E+04, 2.2887214074E+01, 5.4063041233E+00, 7.2774392890E+00, 2.7316975678E+00, 9.2115397534E-01],
	[2.9900000000E+04, 2.2893533838E+01, 5.4062922450E+00, 7.2813793446E+00, 2.7323395394E+00, 9.2119229491E-01],
	[2.9905000000E+04, 2.2899854291E+01, 5.4062803688E+00, 7.2853208730E+00, 2.7329813799E+00, 9.2123059510E-01],
	[2.9910000000E+04, 2.2906185993E+01, 5.4062700266E+00, 7.2892638744E+00, 2.7336236315E+00, 9.2126887590E-01],
	[2.9915000000E+04, 2.2912530804E+01, 5.4062614870E+00, 7.2932083493E+00, 2.7342663897E+00, 9.2130713734E-01],
	[2.9920000000E+04, 2.2918876312E+01, 5.4062529488E+00, 7.2971542978E+00, 2.7349090175E+00, 9.2134537942E-01],
	[2.9925000000E+04, 2.2925222517E+01, 5.4062444120E+00, 7.3011017203E+00, 2.7355515148E+00, 9.2138360216E-01],
	[2.9930000000E+04, 2.2931569418E+01, 5.4062358767E+00, 7.3050506171E+00, 2.7361938816E+00, 9.2142180555E-01],
	[2.9935000000E+04, 2.2937917015E+01, 5.4062273428E+00, 7.3090009885E+00, 2.7368361180E+00, 9.2145998962E-01],
	[2.9940000000E+04, 2.2944265309E+01, 5.4062188104E+00, 7.3129528348E+00, 2.7374782238E+00, 9.2149815436E-01],
	[2.9945000000E+04, 2.2950614300E+01, 5.4062102794E+00, 7.3169061563E+00, 2.7381201990E+00, 9.2153629980E-01],
	[2.9950000000E+04, 2.2956963987E+01, 5.4062017498E+00, 7.3208609533E+00, 2.7387620437E+00, 9.2157442593E-01],
	[2.9955000000E+04, 2.2963314370E+01, 5.4061932217E+00, 7.3248172261E+00, 2.7394037577E+00, 9.2161253276E-01],
	[2.9960000000E+04, 2.2969665450E+01, 5.4061846950E+00, 7.3287749750E+00, 2.7400453410E+00, 9.2165062032E-01],
	[2.9965000000E+04, 2.2976017226E+01, 5.4061761698E+00, 7.3327342004E+00, 2.7406867937E+00, 9.2168868860E-01],
	[2.9970000000E+04, 2.2982369698E+01, 5.4061676460E+00, 7.3366949025E+00, 2.7413281157E+00, 9.2172673761E-01],
	[2.9975000000E+04, 2.2988722866E+01, 5.4061591236E+00, 7.3406570816E+00, 2.7419693070E+00, 9.2176476737E-01],
	[2.9980000000E+04, 2.2995076730E+01, 5.4061506026E+00, 7.3446207380E+00, 2.7426103674E+00, 9.2180277788E-01],
	[2.9985000000E+04, 2.3001431291E+01, 5.4061420831E+00, 7.3485858721E+00, 2.7432512971E+00, 9.2184076915E-01],
	[2.9990000000E+04, 2.3007786548E+01, 5.4061335650E+00, 7.3525524841E+00, 2.7438920960E+00, 9.2187874120E-01],
	[2.9995000000E+04, 2.3014142500E+01, 5.4061250484E+00, 7.3565205743E+00, 2.7445327640E+00, 9.2191669402E-01],
	[3.0000000000E+04, 2.3020499149E+01, 5.4061165332E+00, 7.3604901431E+00, 2.7451733012E+00, 9.2195462764E-01],
	[3.0005000000E+04, 2.3026856494E+01, 5.4061080194E+00, 7.3644856967E+00, 2.7458171141E+00, 9.2199254205E-01],
	[3.0010000000E+04, 2.3033214534E+01, 5.4060995071E+00, 7.3684827519E+00, 2.7464607951E+00, 9.2203043727E-01],
	[3.0015000000E+04, 2.3039573270E+01, 5.4060909962E+00, 7.3724813091E+00, 2.7471043440E+00, 9.2206831331E-01],
	[3.0020000000E+04, 2.3045932703E+01, 5.4060824867E+00, 7.3764813685E+00, 2.7477477608E+00, 9.2210617018E-01],
	[3.0025000000E+04, 2.3052292831E+01, 5.4060739786E+00, 7.3804829304E+00, 2.7483910456E+00, 9.2214400788E-01],
	[3.0030000000E+04, 2.3058653654E+01, 5.4060654720E+00, 7.3844859952E+00, 2.7490341983E+00, 9.2218182643E-01],
	[3.0035000000E+04, 2.3065015174E+01, 5.4060569668E+00, 7.3884905632E+00, 2.7496772189E+00, 9.2221962583E-01],
	[3.0040000000E+04, 2.3071377389E+01, 5.4060484630E+00, 7.3924966347E+00, 2.7503201073E+00, 9.2225740610E-01],
	[3.0045000000E+04, 2.3077740300E+01, 5.4060399607E+00, 7.3965042100E+00, 2.7509628635E+00, 9.2229516724E-01],
	[3.0050000000E+04, 2.3084103906E+01, 5.4060314598E+00, 7.4005132894E+00, 2.7516054874E+00, 9.2233290926E-01],
	[3.0055000000E+04, 2.3090468208E+01, 5.4060229603E+00, 7.4045238732E+00, 2.7522479792E+00, 9.2237063218E-01],
	[3.0060000000E+04, 2.3096833206E+01, 5.4060144623E+00, 7.4085359618E+00, 2.7528903387E+00, 9.2240833599E-01],
	[3.0065000000E+04, 2.3103198899E+01, 5.4060059657E+00, 7.4125495554E+00, 2.7535325658E+00, 9.2244602071E-01],
	[3.0070000000E+04, 2.3109565287E+01, 5.4059974705E+00, 7.4165646544E+00, 2.7541746607E+00, 9.2248368636E-01],
	[3.0075000000E+04, 2.3115932371E+01, 5.4059889767E+00, 7.4205812591E+00, 2.7548166231E+00, 9.2252133293E-01],
	[3.0080000000E+04, 2.3122300150E+01, 5.4059804843E+00, 7.4245993698E+00, 2.7554584533E+00, 9.2255896044E-01],
	[3.0085000000E+04, 2.3128668625E+01, 5.4059719934E+00, 7.4286189868E+00, 2.7561001509E+00, 9.2259656889E-01],
	[3.0090000000E+04, 2.3135037794E+01, 5.4059635039E+00, 7.4326401105E+00, 2.7567417162E+00, 9.2263415831E-01],
	[3.0095000000E+04, 2.3141407659E+01, 5.4059550158E+00, 7.4366627410E+00, 2.7573831490E+00, 9.2267172868E-01],
	[3.0100000000E+04, 2.3147778219E+01, 5.4059465292E+00, 7.4406868789E+00, 2.7580244493E+00, 9.2270928003E-01],
	[3.0105000000E+04, 2.3154149475E+01, 5.4059380440E+00, 7.4447125243E+00, 2.7586656171E+00, 9.2274681237E-01],
	[3.0110000000E+04, 2.3160521425E+01, 5.4059295602E+00, 7.4487396776E+00, 2.7593066523E+00, 9.2278432570E-01],
	[3.0115000000E+04, 2.3166894071E+01, 5.4059210778E+00, 7.4527683391E+00, 2.7599475550E+00, 9.2282182003E-01],
	[3.0120000000E+04, 2.3173267411E+01, 5.4059125968E+00, 7.4567985091E+00, 2.7605883251E+00, 9.2285929537E-01],
	[3.0125000000E+04, 2.3179641447E+01, 5.4059041173E+00, 7.4608301879E+00, 2.7612289625E+00, 9.2289675173E-01],
	[3.0130000000E+04, 2.3186016177E+01, 5.4058956392E+00, 7.4648633758E+00, 2.7618694673E+00, 9.2293418913E-01],
	[3.0135000000E+04, 2.3192391603E+01, 5.4058871625E+00, 7.4688980732E+00, 2.7625098394E+00, 9.2297160756E-01],
	[3.0140000000E+04, 2.3198767723E+01, 5.4058786872E+00, 7.4729342804E+00, 2.7631500788E+00, 9.2300900704E-01],
	[3.0145000000E+04, 2.3205144538E+01, 5.4058702133E+00, 7.4769719976E+00, 2.7637901855E+00, 9.2304638758E-01],
	[3.0150000000E+04, 2.3211522048E+01, 5.4058617409E+00, 7.4810112253E+00, 2.7644301594E+00, 9.2308374918E-01],
	[3.0155000000E+04, 2.3217900253E+01, 5.4058532698E+00, 7.4850519636E+00, 2.7650700006E+00, 9.2312109186E-01],
	[3.0160000000E+04, 2.3224279153E+01, 5.4058448002E+00, 7.4890942130E+00, 2.7657097089E+00, 9.2315841563E-01],
	[3.0165000000E+04, 2.3230658747E+01, 5.4058363320E+00, 7.4931379737E+00, 2.7663492844E+00, 9.2319572049E-01],
	[3.0170000000E+04, 2.3237039036E+01, 5.4058278653E+00, 7.4971832460E+00, 2.7669887270E+00, 9.2323300646E-01],
	[3.0175000000E+04, 2.3243420019E+01, 5.4058193999E+00, 7.5012300303E+00, 2.7676280367E+00, 9.2327027353E-01],
	[3.0180000000E+04, 2.3249801697E+01, 5.4058109360E+00, 7.5052783269E+00, 2.7682672135E+00, 9.2330752173E-01],
	[3.0185000000E+04, 2.3256184069E+01, 5.4058024735E+00, 7.5093281361E+00, 2.7689062574E+00, 9.2334475107E-01],
	[3.0190000000E+04, 2.3262567136E+01, 5.4057940123E+00, 7.5133794582E+00, 2.7695451683E+00, 9.2338196154E-01],
	[3.0195000000E+04, 2.3268950898E+01, 5.4057855526E+00, 7.5174322935E+00, 2.7701839462E+00, 9.2341915316E-01],
	[3.0200000000E+04, 2.3275335354E+01, 5.4057770944E+00, 7.5214866423E+00, 2.7708225911E+00, 9.2345632594E-01],
	[3.0205000000E+04, 2.3281720504E+01, 5.4057686375E+00, 7.5255425049E+00, 2.7714611030E+00, 9.2349347989E-01],
	[3.0210000000E+04, 2.3288106349E+01, 5.4057601820E+00, 7.5295998818E+00, 2.7720994817E+00, 9.2353061502E-01],
	[3.0215000000E+04, 2.3294492887E+01, 5.4057517280E+00, 7.5336587731E+00, 2.7727377274E+00, 9.2356773133E-01],
	[3.0220000000E+04, 2.3300880120E+01, 5.4057432754E+00, 7.5377191791E+00, 2.7733758400E+00, 9.2360482884E-01],
	[3.0225000000E+04, 2.3307268048E+01, 5.4057348242E+00, 7.5417811003E+00, 2.7740138194E+00, 9.2364190756E-01],
	[3.0230000000E+04, 2.3313656669E+01, 5.4057263743E+00, 7.5458445369E+00, 2.7746516656E+00, 9.2367896749E-01],
	[3.0235000000E+04, 2.3320045985E+01, 5.4057179259E+00, 7.5499094892E+00, 2.7752893787E+00, 9.2371600864E-01],
	[3.0240000000E+04, 2.3326435995E+01, 5.4057094790E+00, 7.5539759576E+00, 2.7759269585E+00, 9.2375303103E-01],
	[3.0245000000E+04, 2.3332826698E+01, 5.4057010334E+00, 7.5580439423E+00, 2.7765644051E+00, 9.2379003466E-01],
	[3.0250000000E+04, 2.3339218096E+01, 5.4056925892E+00, 7.5621134437E+00, 2.7772017184E+00, 9.2382701954E-01],
	[3.0255000000E+04, 2.3345610188E+01, 5.4056841465E+00, 7.5661844621E+00, 2.7778388983E+00, 9.2386398568E-01],
	[3.0260000000E+04, 2.3352002973E+01, 5.4056757051E+00, 7.5702569978E+00, 2.7784759450E+00, 9.2390093310E-01],
	[3.0265000000E+04, 2.3358396453E+01, 5.4056672652E+00, 7.5743310511E+00, 2.7791128583E+00, 9.2393786179E-01],
	[3.0270000000E+04, 2.3364790626E+01, 5.4056588266E+00, 7.5784066223E+00, 2.7797496383E+00, 9.2397477177E-01],
	[3.0275000000E+04, 2.3371185494E+01, 5.4056503895E+00, 7.5824837117E+00, 2.7803862848E+00, 9.2401166305E-01],
	[3.0280000000E+04, 2.3377581055E+01, 5.4056419538E+00, 7.5865623197E+00, 2.7810227980E+00, 9.2404853563E-01],
	[3.0285000000E+04, 2.3383977309E+01, 5.4056335195E+00, 7.5906424466E+00, 2.7816591776E+00, 9.2408538953E-01],
	[3.0290000000E+04, 2.3390374258E+01, 5.4056250866E+00, 7.5947240927E+00, 2.7822954238E+00, 9.2412222476E-01],
	[3.0295000000E+04, 2.3396771900E+01, 5.4056166550E+00, 7.5988072582E+00, 2.7829315365E+00, 9.2415904132E-01],
	[3.0300000000E+04, 2.3403170236E+01, 5.4056082249E+00, 7.6028919436E+00, 2.7835675157E+00, 9.2419583922E-01],
	[3.0305000000E+04, 2.3409569265E+01, 5.4055997962E+00, 7.6069781491E+00, 2.7842033614E+00, 9.2423261848E-01],
	[3.0310000000E+04, 2.3415968988E+01, 5.4055913690E+00, 7.6110658750E+00, 2.7848390734E+00, 9.2426937909E-01],
	[3.0315000000E+04, 2.3422369404E+01, 5.4055829431E+00, 7.6151551217E+00, 2.7854746519E+00, 9.2430612108E-01],
	[3.0320000000E+04, 2.3428770514E+01, 5.4055745186E+00, 7.6192458895E+00, 2.7861100967E+00, 9.2434284444E-01],
	[3.0325000000E+04, 2.3435172317E+01, 5.4055660955E+00, 7.6233381786E+00, 2.7867454080E+00, 9.2437954918E-01],
	[3.0330000000E+04, 2.3441574814E+01, 5.4055576738E+00, 7.6274319895E+00, 2.7873805855E+00, 9.2441623532E-01],
	[3.0335000000E+04, 2.3447978004E+01, 5.4055492535E+00, 7.6315273223E+00, 2.7880156293E+00, 9.2445290286E-01],
	[3.0340000000E+04, 2.3454381887E+01, 5.4055408346E+00, 7.6356241775E+00, 2.7886505395E+00, 9.2448955181E-01],
	[3.0345000000E+04, 2.3460786464E+01, 5.4055324172E+00, 7.6397225553E+00, 2.7892853159E+00, 9.2452618218E-01],
	[3.0350000000E+04, 2.3467191734E+01, 5.4055240011E+00, 7.6438224561E+00, 2.7899199585E+00, 9.2456279398E-01],
	[3.0355000000E+04, 2.3473597697E+01, 5.4055155864E+00, 7.6479238801E+00, 2.7905544673E+00, 9.2459938721E-01],
	[3.0360000000E+04, 2.3480004353E+01, 5.4055071731E+00, 7.6520268277E+00, 2.7911888424E+00, 9.2463596188E-01],
	[3.0365000000E+04, 2.3486411702E+01, 5.4054987612E+00, 7.6561312992E+00, 2.7918230835E+00, 9.2467251801E-01],
	[3.0370000000E+04, 2.3492819744E+01, 5.4054903508E+00, 7.6602372949E+00, 2.7924571909E+00, 9.2470905560E-01],
	[3.0375000000E+04, 2.3499228480E+01, 5.4054819417E+00, 7.6643448152E+00, 2.7930911643E+00, 9.2474557466E-01],
	[3.0380000000E+04, 2.3505637908E+01, 5.4054735340E+00, 7.6684538603E+00, 2.7937250039E+00, 9.2478207519E-01],
	[3.0385000000E+04, 2.3512048029E+01, 5.4054651277E+00, 7.6725644305E+00, 2.7943587095E+00, 9.2481855721E-01],
	[3.0390000000E+04, 2.3518462602E+01, 5.4054572618E+00, 7.6766765262E+00, 2.7949924783E+00, 9.2485502072E-01],
	[3.0395000000E+04, 2.3524896894E+01, 5.4054521245E+00, 7.6807901477E+00, 2.7956271115E+00, 9.2489146574E-01],
	[3.0400000000E+04, 2.3531331888E+01, 5.4054469881E+00, 7.6849052953E+00, 2.7962616114E+00, 9.2492789226E-01],
	[3.0405000000E+04, 2.3537767583E+01, 5.4054418525E+00, 7.6890219693E+00, 2.7968959780E+00, 9.2496430031E-01],
	[3.0410000000E+04, 2.3544203980E+01, 5.4054367178E+00, 7.6931401700E+00, 2.7975302113E+00, 9.2500068988E-01],
	[3.0415000000E+04, 2.3550641078E+01, 5.4054315840E+00, 7.6972598978E+00, 2.7981643112E+00, 9.2503706099E-01],
	[3.0420000000E+04, 2.3557078878E+01, 5.4054264510E+00, 7.7013811529E+00, 2.7987982777E+00, 9.2507341364E-01],
	[3.0425000000E+04, 2.3563517379E+01, 5.4054213188E+00, 7.7055039357E+00, 2.7994321108E+00, 9.2510974785E-01],
	[3.0430000000E+04, 2.3569956581E+01, 5.4054161875E+00, 7.7096282465E+00, 2.8000658105E+00, 9.2514606362E-01],
	[3.0435000000E+04, 2.3576396484E+01, 5.4054110570E+00, 7.7137540856E+00, 2.8006993768E+00, 9.2518236095E-01],
	[3.0440000000E+04, 2.3582837089E+01, 5.4054059274E+00, 7.7178814532E+00, 2.8013328095E+00, 9.2521863987E-01],
	[3.0445000000E+04, 2.3589278395E+01, 5.4054007987E+00, 7.7220103499E+00, 2.8019661088E+00, 9.2525490037E-01],
	[3.0450000000E+04, 2.3595720402E+01, 5.4053956707E+00, 7.7261407757E+00, 2.8025992746E+00, 9.2529114247E-01],
	[3.0455000000E+04, 2.3602163110E+01, 5.4053905437E+00, 7.7302727311E+00, 2.8032323068E+00, 9.2532736617E-01],
	[3.0460000000E+04, 2.3608606519E+01, 5.4053854174E+00, 7.7344062164E+00, 2.8038652055E+00, 9.2536357148E-01],
	[3.0465000000E+04, 2.3615050629E+01, 5.4053802920E+00, 7.7385412319E+00, 2.8044979705E+00, 9.2539975841E-01],
	[3.0470000000E+04, 2.3621495440E+01, 5.4053751675E+00, 7.7426777778E+00, 2.8051306020E+00, 9.2543592697E-01],
	[3.0475000000E+04, 2.3627940952E+01, 5.4053700438E+00, 7.7468158546E+00, 2.8057630998E+00, 9.2547207717E-01],
	[3.0480000000E+04, 2.3634387165E+01, 5.4053649210E+00, 7.7509554625E+00, 2.8063954640E+00, 9.2550820901E-01],
	[3.0485000000E+04, 2.3640834079E+01, 5.4053597990E+00, 7.7550966019E+00, 2.8070276945E+00, 9.2554432250E-01],
	[3.0490000000E+04, 2.3647281694E+01, 5.4053546778E+00, 7.7592392730E+00, 2.8076597913E+00, 9.2558041766E-01],
	[3.0495000000E+04, 2.3653730009E+01, 5.4053495575E+00, 7.7633834762E+00, 2.8082917544E+00, 9.2561649449E-01],
	[3.0500000000E+04, 2.3660179026E+01, 5.4053444380E+00, 7.7675292118E+00, 2.8089235838E+00, 9.2565255300E-01],
	[3.0505000000E+04, 2.3666628743E+01, 5.4053393194E+00, 7.7716764801E+00, 2.8095552793E+00, 9.2568859320E-01],
	[3.0510000000E+04, 2.3673079160E+01, 5.4053342016E+00, 7.7758252814E+00, 2.8101868411E+00, 9.2572461509E-01],
	[3.0515000000E+04, 2.3679530279E+01, 5.4053290847E+00, 7.7799756160E+00, 2.8108182691E+00, 9.2576061869E-01],
	[3.0520000000E+04, 2.3685982097E+01, 5.4053239686E+00, 7.7841274843E+00, 2.8114495633E+00, 9.2579660400E-01],
	[3.0525000000E+04, 2.3692434617E+01, 5.4053188534E+00, 7.7882808865E+00, 2.8120807236E+00, 9.2583257103E-01],
	[3.0530000000E+04, 2.3698887837E+01, 5.4053137390E+00, 7.7924358230E+00, 2.8127117500E+00, 9.2586851979E-01],
	[3.0535000000E+04, 2.3705341757E+01, 5.4053086254E+00, 7.7965922941E+00, 2.8133426425E+00, 9.2590445029E-01],
	[3.0540000000E+04, 2.3711796378E+01, 5.4053035127E+00, 7.8007503002E+00, 2.8139734011E+00, 9.2594036253E-01],
	[3.0545000000E+04, 2.3718251699E+01, 5.4052984008E+00, 7.8049098414E+00, 2.8146040258E+00, 9.2597625653E-01],
	[3.0550000000E+04, 2.3724707721E+01, 5.4052932898E+00, 7.8090709182E+00, 2.8152345165E+00, 9.2601213230E-01],
	[3.0555000000E+04, 2.3731164443E+01, 5.4052881796E+00, 7.8132335308E+00, 2.8158648732E+00, 9.2604798983E-01],
	[3.0560000000E+04, 2.3737621865E+01, 5.4052830702E+00, 7.8173976796E+00, 2.8164950959E+00, 9.2608382915E-01],
	[3.0565000000E+04, 2.3744079988E+01, 5.4052779617E+00, 7.8215633648E+00, 2.8171251846E+00, 9.2611965026E-01],
	[3.0570000000E+04, 2.3750538811E+01, 5.4052728540E+00, 7.8257305869E+00, 2.8177551392E+00, 9.2615545316E-01],
	[3.0575000000E+04, 2.3756998334E+01, 5.4052677472E+00, 7.8298993461E+00, 2.8183849598E+00, 9.2619123787E-01],
	[3.0580000000E+04, 2.3763458557E+01, 5.4052626412E+00, 7.8340696427E+00, 2.8190146463E+00, 9.2622700439E-01],
	[3.0585000000E+04, 2.3769919480E+01, 5.4052575360E+00, 7.8382414770E+00, 2.8196441986E+00, 9.2626275274E-01],
	[3.0590000000E+04, 2.3776381103E+01, 5.4052524317E+00, 7.8424148494E+00, 2.8202736169E+00, 9.2629848292E-01],
	[3.0595000000E+04, 2.3782843426E+01, 5.4052473283E+00, 7.8465897602E+00, 2.8209029009E+00, 9.2633419493E-01],
	[3.0600000000E+04, 2.3789306449E+01, 5.4052422256E+00, 7.8507662096E+00, 2.8215320508E+00, 9.2636988880E-01],
	[3.0605000000E+04, 2.3795770173E+01, 5.4052371238E+00, 7.8549441980E+00, 2.8221610665E+00, 9.2640556452E-01],
	[3.0610000000E+04, 2.3802234596E+01, 5.4052320229E+00, 7.8591237258E+00, 2.8227899480E+00, 9.2644122211E-01],
	[3.0615000000E+04, 2.3808699719E+01, 5.4052269227E+00, 7.8633047932E+00, 2.8234186953E+00, 9.2647686157E-01],
	[3.0620000000E+04, 2.3815165541E+01, 5.4052218235E+00, 7.8674874005E+00, 2.8240473082E+00, 9.2651248291E-01],
	[3.0625000000E+04, 2.3821632064E+01, 5.4052167250E+00, 7.8716715481E+00, 2.8246757869E+00, 9.2654808615E-01],
	[3.0630000000E+04, 2.3828099286E+01, 5.4052116274E+00, 7.8758572363E+00, 2.8253041313E+00, 9.2658367128E-01],
	[3.0635000000E+04, 2.3834567208E+01, 5.4052065306E+00, 7.8800444653E+00, 2.8259323414E+00, 9.2661923832E-01],
	[3.0640000000E+04, 2.3841035830E+01, 5.4052014347E+00, 7.8842332356E+00, 2.8265604172E+00, 9.2665478727E-01],
	[3.0645000000E+04, 2.3847505151E+01, 5.4051963396E+00, 7.8884235474E+00, 2.8271883585E+00, 9.2669031816E-01],
	[3.0650000000E+04, 2.3853975172E+01, 5.4051912453E+00, 7.8926154010E+00, 2.8278161655E+00, 9.2672583097E-01],
	[3.0655000000E+04, 2.3860445893E+01, 5.4051861519E+00, 7.8968087967E+00, 2.8284438381E+00, 9.2676132572E-01],
	[3.0660000000E+04, 2.3866917313E+01, 5.4051810593E+00, 7.9010037349E+00, 2.8290713763E+00, 9.2679680243E-01],
	[3.0665000000E+04, 2.3873389432E+01, 5.4051759675E+00, 7.9052002160E+00, 2.8296987800E+00, 9.2683226109E-01],
	[3.0670000000E+04, 2.3879862251E+01, 5.4051708766E+00, 7.9093982400E+00, 2.8303260493E+00, 9.2686770172E-01],
	[3.0675000000E+04, 2.3886335769E+01, 5.4051657865E+00, 7.9135978076E+00, 2.8309531840E+00, 9.2690312433E-01],
	[3.0680000000E+04, 2.3892809987E+01, 5.4051606973E+00, 7.9177989188E+00, 2.8315801843E+00, 9.2693852892E-01],
	[3.0685000000E+04, 2.3899284904E+01, 5.4051556089E+00, 7.9220015741E+00, 2.8322070500E+00, 9.2697391550E-01],
	[3.0690000000E+04, 2.3905760520E+01, 5.4051505213E+00, 7.9262057737E+00, 2.8328337812E+00, 9.2700928408E-01],
	[3.0695000000E+04, 2.3912236836E+01, 5.4051454345E+00, 7.9304115180E+00, 2.8334603778E+00, 9.2704463467E-01],
	[3.0700000000E+04, 2.3918713850E+01, 5.4051403486E+00, 7.9346188073E+00, 2.8340868399E+00, 9.2707996728E-01],
	[3.0705000000E+04, 2.3925191564E+01, 5.4051352635E+00, 7.9388276419E+00, 2.8347131673E+00, 9.2711528192E-01],
	[3.0710000000E+04, 2.3931669977E+01, 5.4051301793E+00, 7.9430380221E+00, 2.8353393601E+00, 9.2715057859E-01],
	[3.0715000000E+04, 2.3938149090E+01, 5.4051250958E+00, 7.9472499482E+00, 2.8359654183E+00, 9.2718585730E-01],
	[3.0720000000E+04, 2.3944628901E+01, 5.4051200132E+00, 7.9514634206E+00, 2.8365913418E+00, 9.2722111807E-01],
	[3.0725000000E+04, 2.3951109411E+01, 5.4051149315E+00, 7.9556784395E+00, 2.8372171306E+00, 9.2725636089E-01],
	[3.0730000000E+04, 2.3957590620E+01, 5.4051098506E+00, 7.9598950053E+00, 2.8378427848E+00, 9.2729158579E-01],
	[3.0735000000E+04, 2.3964072528E+01, 5.4051047705E+00, 7.9641131183E+00, 2.8384683042E+00, 9.2732679276E-01],
	[3.0740000000E+04, 2.3970555135E+01, 5.4050996912E+00, 7.9683327789E+00, 2.8390936888E+00, 9.2736198182E-01],
	[3.0745000000E+04, 2.3977038441E+01, 5.4050946128E+00, 7.9725539872E+00, 2.8397189387E+00, 9.2739715297E-01],
	[3.0750000000E+04, 2.3983522446E+01, 5.4050895352E+00, 7.9767767437E+00, 2.8403440538E+00, 9.2743230622E-01],
	[3.0755000000E+04, 2.3990007150E+01, 5.4050844584E+00, 7.9810010486E+00, 2.8409690342E+00, 9.2746744159E-01],
	[3.0760000000E+04, 2.3996492552E+01, 5.4050793825E+00, 7.9852269023E+00, 2.8415938797E+00, 9.2750255907E-01],
	[3.0765000000E+04, 2.4002978653E+01, 5.4050743074E+00, 7.9894543051E+00, 2.8422185903E+00, 9.2753765869E-01],
	[3.0770000000E+04, 2.4009465453E+01, 5.4050692331E+00, 7.9936832573E+00, 2.8428431661E+00, 9.2757274044E-01],
	[3.0775000000E+04, 2.4015952951E+01, 5.4050641596E+00, 7.9979137592E+00, 2.8434676070E+00, 9.2760780433E-01],
	[3.0780000000E+04, 2.4022441148E+01, 5.4050590870E+00, 8.0021458111E+00, 2.8440919131E+00, 9.2764285038E-01],
	[3.0785000000E+04, 2.4028930043E+01, 5.4050540152E+00, 8.0063794134E+00, 2.8447160842E+00, 9.2767787859E-01],
	[3.0790000000E+04, 2.4035419637E+01, 5.4050489442E+00, 8.0106145663E+00, 2.8453401204E+00, 9.2771288898E-01],
	[3.0795000000E+04, 2.4041909930E+01, 5.4050438741E+00, 8.0148512702E+00, 2.8459640216E+00, 9.2774788154E-01],
	[3.0800000000E+04, 2.4048400921E+01, 5.4050388048E+00, 8.0190895254E+00, 2.8465877879E+00, 9.2778285629E-01],
	[3.0805000000E+04, 2.4054892610E+01, 5.4050337363E+00, 8.0233293322E+00, 2.8472114192E+00, 9.2781781323E-01],
	[3.0810000000E+04, 2.4061384998E+01, 5.4050286687E+00, 8.0275706910E+00, 2.8478349154E+00, 9.2785275238E-01],
	[3.0815000000E+04, 2.4067878084E+01, 5.4050236018E+00, 8.0318136019E+00, 2.8484582767E+00, 9.2788767375E-01],
	[3.0820000000E+04, 2.4074371868E+01, 5.4050185358E+00, 8.0360580655E+00, 2.8490815029E+00, 9.2792257733E-01],
	[3.0825000000E+04, 2.4080866351E+01, 5.4050134707E+00, 8.0403040819E+00, 2.8497045940E+00, 9.2795746315E-01],
	[3.0830000000E+04, 2.4087361531E+01, 5.4050084063E+00, 8.0445516514E+00, 2.8503275501E+00, 9.2799233121E-01],
	[3.0835000000E+04, 2.4093857410E+01, 5.4050033428E+00, 8.0488007745E+00, 2.8509503710E+00, 9.2802718151E-01],
	[3.0840000000E+04, 2.4100353987E+01, 5.4049982801E+00, 8.0530514514E+00, 2.8515730569E+00, 9.2806201407E-01],
	[3.0845000000E+04, 2.4106851263E+01, 5.4049932182E+00, 8.0573036825E+00, 2.8521956076E+00, 9.2809682889E-01],
	[3.0850000000E+04, 2.4113349236E+01, 5.4049881572E+00, 8.0615574679E+00, 2.8528180231E+00, 9.2813162599E-01],
	[3.0855000000E+04, 2.4119847907E+01, 5.4049830969E+00, 8.0658128082E+00, 2.8534403035E+00, 9.2816640536E-01],
	[3.0860000000E+04, 2.4126347276E+01, 5.4049780376E+00, 8.0700697035E+00, 2.8540624487E+00, 9.2820116703E-01],
	[3.0865000000E+04, 2.4132847344E+01, 5.4049729790E+00, 8.0743281542E+00, 2.8546844587E+00, 9.2823591099E-01],
	[3.0870000000E+04, 2.4139348109E+01, 5.4049679212E+00, 8.0785881606E+00, 2.8553063334E+00, 9.2827063727E-01],
	[3.0875000000E+04, 2.4145849572E+01, 5.4049628643E+00, 8.0828497230E+00, 2.8559280730E+00, 9.2830534586E-01],
	[3.0880000000E+04, 2.4152358956E+01, 5.4049588325E+00, 8.0871128418E+00, 2.8565500644E+00, 9.2834003677E-01],
	[3.0885000000E+04, 2.4158884386E+01, 5.4049569765E+00, 8.0913775173E+00, 2.8571727432E+00, 9.2837471001E-01],
	[3.0890000000E+04, 2.4165410522E+01, 5.4049551208E+00, 8.0956437497E+00, 2.8577952873E+00, 9.2840936560E-01],
	[3.0895000000E+04, 2.4171937364E+01, 5.4049532654E+00, 8.0999115394E+00, 2.8584176969E+00, 9.2844400353E-01],
	[3.0900000000E+04, 2.4178464912E+01, 5.4049514103E+00, 8.1041808867E+00, 2.8590399718E+00, 9.2847862383E-01],
	[3.0905000000E+04, 2.4184993166E+01, 5.4049495555E+00, 8.1084517919E+00, 2.8596621121E+00, 9.2851322649E-01],
	[3.0910000000E+04, 2.4191522127E+01, 5.4049477011E+00, 8.1127242554E+00, 2.8602841177E+00, 9.2854781152E-01],
	[3.0915000000E+04, 2.4198051793E+01, 5.4049458469E+00, 8.1169982774E+00, 2.8609059885E+00, 9.2858237894E-01],
	[3.0920000000E+04, 2.4204582166E+01, 5.4049439930E+00, 8.1212738582E+00, 2.8615277247E+00, 9.2861692875E-01],
	[3.0925000000E+04, 2.4211113245E+01, 5.4049421394E+00, 8.1255509983E+00, 2.8621493261E+00, 9.2865146096E-01],
	[3.0930000000E+04, 2.4217645029E+01, 5.4049402861E+00, 8.1298296979E+00, 2.8627707928E+00, 9.2868597559E-01],
	[3.0935000000E+04, 2.4224177520E+01, 5.4049384331E+00, 8.1341099572E+00, 2.8633921247E+00, 9.2872047262E-01],
	[3.0940000000E+04, 2.4230710716E+01, 5.4049365804E+00, 8.1383917767E+00, 2.8640133219E+00, 9.2875495209E-01],
	[3.0945000000E+04, 2.4237244619E+01, 5.4049347280E+00, 8.1426751567E+00, 2.8646343842E+00, 9.2878941399E-01],
	[3.0950000000E+04, 2.4243779227E+01, 5.4049328760E+00, 8.1469600974E+00, 2.8652553117E+00, 9.2882385833E-01],
	[3.0955000000E+04, 2.4250314541E+01, 5.4049310242E+00, 8.1512465991E+00, 2.8658761044E+00, 9.2885828513E-01],
	[3.0960000000E+04, 2.4256850560E+01, 5.4049291727E+00, 8.1555346623E+00, 2.8664967622E+00, 9.2889269438E-01],
	[3.0965000000E+04, 2.4263387286E+01, 5.4049273215E+00, 8.1598242872E+00, 2.8671172852E+00, 9.2892708611E-01],
	[3.0970000000E+04, 2.4269924717E+01, 5.4049254706E+00, 8.1641154741E+00, 2.8677376733E+00, 9.2896146031E-01],
	[3.0975000000E+04, 2.4276462853E+01, 5.4049236200E+00, 8.1684082233E+00, 2.8683579264E+00, 9.2899581700E-01],
	[3.0980000000E+04, 2.4283001696E+01, 5.4049217697E+00, 8.1727025352E+00, 2.8689780447E+00, 9.2903015618E-01],
	[3.0985000000E+04, 2.4289541244E+01, 5.4049199197E+00, 8.1769984101E+00, 2.8695980280E+00, 9.2906447787E-01],
	[3.0990000000E+04, 2.4296081497E+01, 5.4049180701E+00, 8.1812958483E+00, 2.8702178763E+00, 9.2909878207E-01],
	[3.0995000000E+04, 2.4302622456E+01, 5.4049162207E+00, 8.1855948500E+00, 2.8708375897E+00, 9.2913306878E-01],
	[3.1000000000E+04, 2.4309164120E+01, 5.4049143716E+00, 8.1898954157E+00, 2.8714571681E+00, 9.2916733803E-01],
	[3.1005000000E+04, 2.4315706490E+01, 5.4049125228E+00, 8.1941975456E+00, 2.8720766115E+00, 9.2920158981E-01],
	[3.1010000000E+04, 2.4322249565E+01, 5.4049106743E+00, 8.1985012401E+00, 2.8726959199E+00, 9.2923582414E-01],
	[3.1015000000E+04, 2.4328793345E+01, 5.4049088261E+00, 8.2028064994E+00, 2.8733150932E+00, 9.2927004102E-01],
	[3.1020000000E+04, 2.4335337831E+01, 5.4049069782E+00, 8.2071133240E+00, 2.8739341315E+00, 9.2930424047E-01],
	[3.1025000000E+04, 2.4341883022E+01, 5.4049051306E+00, 8.2114217140E+00, 2.8745530347E+00, 9.2933842249E-01],
	[3.1030000000E+04, 2.4348428918E+01, 5.4049032833E+00, 8.2157316698E+00, 2.8751718029E+00, 9.2937258708E-01],
	[3.1035000000E+04, 2.4354975519E+01, 5.4049014363E+00, 8.2200431918E+00, 2.8757904359E+00, 9.2940673427E-01],
	[3.1040000000E+04, 2.4361522826E+01, 5.4048995896E+00, 8.2243562802E+00, 2.8764089338E+00, 9.2944086405E-01],
	[3.1045000000E+04, 2.4368070837E+01, 5.4048977432E+00, 8.2286709354E+00, 2.8770272966E+00, 9.2947497644E-01],
	[3.1050000000E+04, 2.4374619554E+01, 5.4048958971E+00, 8.2329871577E+00, 2.8776455242E+00, 9.2950907144E-01],
	[3.1055000000E+04, 2.4381168976E+01, 5.4048940513E+00, 8.2373049473E+00, 2.8782636167E+00, 9.2954314907E-01],
	[3.1060000000E+04, 2.4387719102E+01, 5.4048922057E+00, 8.2416243047E+00, 2.8788815739E+00, 9.2957720932E-01],
	[3.1065000000E+04, 2.4394269934E+01, 5.4048903605E+00, 8.2459452301E+00, 2.8794993960E+00, 9.2961125222E-01],
	[3.1070000000E+04, 2.4400821470E+01, 5.4048885156E+00, 8.2502677238E+00, 2.8801170829E+00, 9.2964527776E-01],
	[3.1075000000E+04, 2.4407373712E+01, 5.4048866710E+00, 8.2545917862E+00, 2.8807346345E+00, 9.2967928596E-01],
	[3.1080000000E+04, 2.4413926658E+01, 5.4048848267E+00, 8.2589174176E+00, 2.8813520509E+00, 9.2971327682E-01],
	[3.1085000000E+04, 2.4420480309E+01, 5.4048829826E+00, 8.2632446183E+00, 2.8819693320E+00, 9.2974725036E-01],
	[3.1090000000E+04, 2.4427034665E+01, 5.4048811389E+00, 8.2675733885E+00, 2.8825864779E+00, 9.2978120658E-01],
	[3.1095000000E+04, 2.4433589725E+01, 5.4048792955E+00, 8.2719037288E+00, 2.8832034884E+00, 9.2981514549E-01],
	[3.1100000000E+04, 2.4440145491E+01, 5.4048774524E+00, 8.2762356392E+00, 2.8838203637E+00, 9.2984906710E-01],
	[3.1105000000E+04, 2.4446701961E+01, 5.4048756095E+00, 8.2805691202E+00, 2.8844371036E+00, 9.2988297142E-01],
	[3.1110000000E+04, 2.4453259135E+01, 5.4048737670E+00, 8.2849041721E+00, 2.8850537082E+00, 9.2991685846E-01],
	[3.1115000000E+04, 2.4459817014E+01, 5.4048719247E+00, 8.2892407951E+00, 2.8856701774E+00, 9.2995072822E-01],
	[3.1120000000E+04, 2.4466375598E+01, 5.4048700828E+00, 8.2935789897E+00, 2.8862865113E+00, 9.2998458071E-01],
	[3.1125000000E+04, 2.4472934886E+01, 5.4048682411E+00, 8.2979187561E+00, 2.8869027097E+00, 9.3001841594E-01],
	[3.1130000000E+04, 2.4479494879E+01, 5.4048663998E+00, 8.3022600947E+00, 2.8875187728E+00, 9.3005223393E-01],
	[3.1135000000E+04, 2.4486055576E+01, 5.4048645587E+00, 8.3066030056E+00, 2.8881347005E+00, 9.3008603467E-01],
	[3.1140000000E+04, 2.4492616977E+01, 5.4048627180E+00, 8.3109474894E+00, 2.8887504927E+00, 9.3011981818E-01],
	[3.1145000000E+04, 2.4499179083E+01, 5.4048608775E+00, 8.3152935463E+00, 2.8893661495E+00, 9.3015358447E-01],
	[3.1150000000E+04, 2.4505741893E+01, 5.4048590373E+00, 8.3196411765E+00, 2.8899816708E+00, 9.3018733355E-01],
	[3.1155000000E+04, 2.4512305407E+01, 5.4048571975E+00, 8.3239903805E+00, 2.8905970566E+00, 9.3022106541E-01],
	[3.1160000000E+04, 2.4518869626E+01, 5.4048553579E+00, 8.3283411585E+00, 2.8912123070E+00, 9.3025478008E-01],
	[3.1165000000E+04, 2.4525434549E+01, 5.4048535186E+00, 8.3326935109E+00, 2.8918274218E+00, 9.3028847756E-01],
	[3.1170000000E+04, 2.4532000176E+01, 5.4048516796E+00, 8.3370474379E+00, 2.8924424012E+00, 9.3032215785E-01],
	[3.1175000000E+04, 2.4538566507E+01, 5.4048498409E+00, 8.3414029399E+00, 2.8930572450E+00, 9.3035582097E-01],
	[3.1180000000E+04, 2.4545133542E+01, 5.4048480025E+00, 8.3457600172E+00, 2.8936719532E+00, 9.3038946693E-01],
	[3.1185000000E+04, 2.4551701281E+01, 5.4048461644E+00, 8.3501186702E+00, 2.8942865259E+00, 9.3042309574E-01],
	[3.1190000000E+04, 2.4558269724E+01, 5.4048443266E+00, 8.3544788990E+00, 2.8949009630E+00, 9.3045670739E-01],
	[3.1195000000E+04, 2.4564838872E+01, 5.4048424891E+00, 8.3588407042E+00, 2.8955152645E+00, 9.3049030191E-01],
	[3.1200000000E+04, 2.4571408723E+01, 5.4048406519E+00, 8.3632040859E+00, 2.8961294304E+00, 9.3052387930E-01],
	[3.1205000000E+04, 2.4577979278E+01, 5.4048388150E+00, 8.3675690444E+00, 2.8967434607E+00, 9.3055743957E-01],
	[3.1210000000E+04, 2.4584550537E+01, 5.4048369784E+00, 8.3719355802E+00, 2.8973573554E+00, 9.3059098272E-01],
	[3.1215000000E+04, 2.4591122500E+01, 5.4048351420E+00, 8.3763036935E+00, 2.8979711144E+00, 9.3062450877E-01],
	[3.1220000000E+04, 2.4597695166E+01, 5.4048333060E+00, 8.3806733846E+00, 2.8985847377E+00, 9.3065801772E-01],
	[3.1225000000E+04, 2.4604268536E+01, 5.4048314703E+00, 8.3850446539E+00, 2.8991982253E+00, 9.3069150958E-01],
	[3.1230000000E+04, 2.4610842611E+01, 5.4048296348E+00, 8.3894175017E+00, 2.8998115773E+00, 9.3072498437E-01],
	[3.1235000000E+04, 2.4617417388E+01, 5.4048277997E+00, 8.3937919282E+00, 2.9004247936E+00, 9.3075844209E-01],
	[3.1240000000E+04, 2.4623992870E+01, 5.4048259648E+00, 8.3981679338E+00, 2.9010378741E+00, 9.3079188274E-01],
	[3.1245000000E+04, 2.4630569055E+01, 5.4048241303E+00, 8.4025455189E+00, 2.9016508189E+00, 9.3082530634E-01],
	[3.1250000000E+04, 2.4637145943E+01, 5.4048222960E+00, 8.4069246836E+00, 2.9022636280E+00, 9.3085871290E-01],
	[3.1255000000E+04, 2.4643723535E+01, 5.4048204620E+00, 8.4113054285E+00, 2.9028763012E+00, 9.3089210242E-01],
	[3.1260000000E+04, 2.4650301831E+01, 5.4048186283E+00, 8.4156877537E+00, 2.9034888388E+00, 9.3092547491E-01],
	[3.1265000000E+04, 2.4656880830E+01, 5.4048167950E+00, 8.4200716595E+00, 2.9041012405E+00, 9.3095883038E-01],
	[3.1270000000E+04, 2.4663460532E+01, 5.4048149619E+00, 8.4244571464E+00, 2.9047135064E+00, 9.3099216884E-01],
	[3.1275000000E+04, 2.4670040938E+01, 5.4048131291E+00, 8.4288442146E+00, 2.9053256365E+00, 9.3102549030E-01],
	[3.1280000000E+04, 2.4676622047E+01, 5.4048112966E+00, 8.4332328644E+00, 2.9059376308E+00, 9.3105879477E-01],
	[3.1285000000E+04, 2.4683203860E+01, 5.4048094643E+00, 8.4376230962E+00, 2.9065494892E+00, 9.3109208225E-01],
	[3.1290000000E+04, 2.4689786375E+01, 5.4048076324E+00, 8.4420149103E+00, 2.9071612118E+00, 9.3112535275E-01],
	[3.1295000000E+04, 2.4696369594E+01, 5.4048058008E+00, 8.4464083069E+00, 2.9077727985E+00, 9.3115860629E-01],
	[3.1300000000E+04, 2.4702953517E+01, 5.4048039695E+00, 8.4508032864E+00, 2.9083842493E+00, 9.3119184286E-01],
	[3.1305000000E+04, 2.4709538142E+01, 5.4048021384E+00, 8.4551998491E+00, 2.9089955643E+00, 9.3122506249E-01],
	[3.1310000000E+04, 2.4716123470E+01, 5.4048003077E+00, 8.4595979954E+00, 2.9096067433E+00, 9.3125826517E-01],
	[3.1315000000E+04, 2.4722709502E+01, 5.4047984772E+00, 8.4639977255E+00, 2.9102177864E+00, 9.3129145092E-01],
	[3.1320000000E+04, 2.4729296236E+01, 5.4047966471E+00, 8.4683990398E+00, 2.9108286935E+00, 9.3132461974E-01],
	[3.1325000000E+04, 2.4735883674E+01, 5.4047948172E+00, 8.4728019386E+00, 2.9114394647E+00, 9.3135777165E-01],
	[3.1330000000E+04, 2.4742471815E+01, 5.4047929876E+00, 8.4772064222E+00, 2.9120500999E+00, 9.3139090665E-01],
	[3.1335000000E+04, 2.4749060658E+01, 5.4047911584E+00, 8.4816124909E+00, 2.9126605992E+00, 9.3142402475E-01],
	[3.1340000000E+04, 2.4755650204E+01, 5.4047893294E+00, 8.4860201450E+00, 2.9132709625E+00, 9.3145712595E-01],
	[3.1345000000E+04, 2.4762240454E+01, 5.4047875007E+00, 8.4904293849E+00, 2.9138811898E+00, 9.3149021028E-01],
	[3.1350000000E+04, 2.4768831406E+01, 5.4047856723E+00, 8.4948402108E+00, 2.9144912810E+00, 9.3152327773E-01],
	[3.1355000000E+04, 2.4775423061E+01, 5.4047838442E+00, 8.4992526231E+00, 2.9151012363E+00, 9.3155632831E-01],
	[3.1360000000E+04, 2.4782015418E+01, 5.4047820163E+00, 8.5036666221E+00, 2.9157110554E+00, 9.3158936204E-01],
	[3.1365000000E+04, 2.4788608478E+01, 5.4047801888E+00, 8.5080822082E+00, 2.9163207386E+00, 9.3162237891E-01],
	[3.1370000000E+04, 2.4795202241E+01, 5.4047783616E+00, 8.5124993816E+00, 2.9169302857E+00, 9.3165537895E-01],
	[3.1375000000E+04, 2.4801796707E+01, 5.4047765346E+00, 8.5169181426E+00, 2.9175396967E+00, 9.3168836216E-01],
	[3.1380000000E+04, 2.4808411990E+01, 5.4047775289E+00, 8.5213384916E+00, 2.9181500722E+00, 9.3172132854E-01],
	[3.1385000000E+04, 2.4815030215E+01, 5.4047788362E+00, 8.5257604289E+00, 2.9187604345E+00, 9.3175427811E-01],
	[3.1390000000E+04, 2.4821649152E+01, 5.4047801432E+00, 8.5301839548E+00, 2.9193706613E+00, 9.3178721087E-01],
	[3.1395000000E+04, 2.4828268799E+01, 5.4047814500E+00, 8.5346090696E+00, 2.9199807526E+00, 9.3182012683E-01],
	[3.1400000000E+04, 2.4834889157E+01, 5.4047827566E+00, 8.5390357736E+00, 2.9205907085E+00, 9.3185302600E-01],
	[3.1405000000E+04, 2.4841510226E+01, 5.4047840630E+00, 8.5434640672E+00, 2.9212005289E+00, 9.3188590840E-01],
	[3.1410000000E+04, 2.4848132006E+01, 5.4047853692E+00, 8.5478939506E+00, 2.9218102137E+00, 9.3191877402E-01],
	[3.1415000000E+04, 2.4854754496E+01, 5.4047866752E+00, 8.5523254243E+00, 2.9224197631E+00, 9.3195162288E-01],
	[3.1420000000E+04, 2.4861377697E+01, 5.4047879810E+00, 8.5567584884E+00, 2.9230291769E+00, 9.3198445498E-01],
	[3.1425000000E+04, 2.4868001609E+01, 5.4047892865E+00, 8.5611931434E+00, 2.9236384552E+00, 9.3201727033E-01],
	[3.1430000000E+04, 2.4874626231E+01, 5.4047905919E+00, 8.5656293895E+00, 2.9242475979E+00, 9.3205006895E-01],
	[3.1435000000E+04, 2.4881251564E+01, 5.4047918971E+00, 8.5700672271E+00, 2.9248566051E+00, 9.3208285084E-01],
	[3.1440000000E+04, 2.4887877607E+01, 5.4047932020E+00, 8.5745066564E+00, 2.9254654767E+00, 9.3211561601E-01],
	[3.1445000000E+04, 2.4894504360E+01, 5.4047945068E+00, 8.5789476779E+00, 2.9260742127E+00, 9.3214836446E-01],
	[3.1450000000E+04, 2.4901131825E+01, 5.4047958113E+00, 8.5833902917E+00, 2.9266828131E+00, 9.3218109621E-01],
	[3.1455000000E+04, 2.4907759999E+01, 5.4047971156E+00, 8.5878344983E+00, 2.9272912779E+00, 9.3221381126E-01],
	[3.1460000000E+04, 2.4914388884E+01, 5.4047984197E+00, 8.5922802979E+00, 2.9278996071E+00, 9.3224650962E-01],
	[3.1465000000E+04, 2.4921018479E+01, 5.4047997237E+00, 8.5967276908E+00, 2.9285078007E+00, 9.3227919130E-01],
	[3.1470000000E+04, 2.4927648784E+01, 5.4048010274E+00, 8.6011766774E+00, 2.9291158585E+00, 9.3231185630E-01],
	[3.1475000000E+04, 2.4934279800E+01, 5.4048023309E+00, 8.6056272581E+00, 2.9297237808E+00, 9.3234450464E-01],
	[3.1480000000E+04, 2.4940911526E+01, 5.4048036342E+00, 8.6100794330E+00, 2.9303315673E+00, 9.3237713632E-01],
	[3.1485000000E+04, 2.4947543962E+01, 5.4048049372E+00, 8.6145332026E+00, 2.9309392182E+00, 9.3240975134E-01],
	[3.1490000000E+04, 2.4954177108E+01, 5.4048062401E+00, 8.6189885671E+00, 2.9315467334E+00, 9.3244234973E-01],
	[3.1495000000E+04, 2.4960810964E+01, 5.4048075428E+00, 8.6234455268E+00, 2.9321541129E+00, 9.3247493147E-01],
	[3.1500000000E+04, 2.4967445531E+01, 5.4048088453E+00, 8.6279040821E+00, 2.9327613567E+00, 9.3250749659E-01],
	[3.1505000000E+04, 2.4974080807E+01, 5.4048101475E+00, 8.6323642334E+00, 2.9333684647E+00, 9.3254004509E-01],
	[3.1510000000E+04, 2.4980716793E+01, 5.4048114496E+00, 8.6368259808E+00, 2.9339754370E+00, 9.3257257698E-01],
	[3.1515000000E+04, 2.4987353490E+01, 5.4048127514E+00, 8.6412893248E+00, 2.9345822735E+00, 9.3260509227E-01],
	[3.1520000000E+04, 2.4993990896E+01, 5.4048140531E+00, 8.6457542656E+00, 2.9351889743E+00, 9.3263759095E-01],
	[3.1525000000E+04, 2.5000629012E+01, 5.4048153545E+00, 8.6502208036E+00, 2.9357955393E+00, 9.3267007305E-01],
	[3.1530000000E+04, 2.5007267838E+01, 5.4048166557E+00, 8.6546889391E+00, 2.9364019686E+00, 9.3270253857E-01],
	[3.1535000000E+04, 2.5013907373E+01, 5.4048179568E+00, 8.6591586723E+00, 2.9370082620E+00, 9.3273498751E-01],
	[3.1540000000E+04, 2.5020547619E+01, 5.4048192576E+00, 8.6636300037E+00, 2.9376144196E+00, 9.3276741989E-01],
	[3.1545000000E+04, 2.5027188574E+01, 5.4048205582E+00, 8.6681029335E+00, 2.9382204414E+00, 9.3279983571E-01],
	[3.1550000000E+04, 2.5033830239E+01, 5.4048218586E+00, 8.6725774621E+00, 2.9388263274E+00, 9.3283223498E-01],
	[3.1555000000E+04, 2.5040472613E+01, 5.4048231588E+00, 8.6770535897E+00, 2.9394320775E+00, 9.3286461771E-01],
	[3.1560000000E+04, 2.5047115698E+01, 5.4048244588E+00, 8.6815313167E+00, 2.9400376918E+00, 9.3289698390E-01],
	[3.1565000000E+04, 2.5053759491E+01, 5.4048257586E+00, 8.6860106435E+00, 2.9406431703E+00, 9.3292933357E-01],
	[3.1570000000E+04, 2.5060403995E+01, 5.4048270582E+00, 8.6904915702E+00, 2.9412485128E+00, 9.3296166672E-01],
	[3.1575000000E+04, 2.5067049207E+01, 5.4048283575E+00, 8.6949740973E+00, 2.9418537195E+00, 9.3299398336E-01],
	[3.1580000000E+04, 2.5073695130E+01, 5.4048296567E+00, 8.6994582250E+00, 2.9424587903E+00, 9.3302628350E-01],
	[3.1585000000E+04, 2.5080341761E+01, 5.4048309557E+00, 8.7039439537E+00, 2.9430637251E+00, 9.3305856714E-01],
	[3.1590000000E+04, 2.5086989102E+01, 5.4048322544E+00, 8.7084312837E+00, 2.9436685241E+00, 9.3309083429E-01],
	[3.1595000000E+04, 2.5093637153E+01, 5.4048335530E+00, 8.7129202153E+00, 2.9442731871E+00, 9.3312308496E-01],
	[3.1600000000E+04, 2.5100285913E+01, 5.4048348514E+00, 8.7174107488E+00, 2.9448777142E+00, 9.3315531916E-01],
	[3.1605000000E+04, 2.5106935382E+01, 5.4048361495E+00, 8.7219028846E+00, 2.9454821054E+00, 9.3318753690E-01],
	[3.1610000000E+04, 2.5113585560E+01, 5.4048374474E+00, 8.7263966229E+00, 2.9460863606E+00, 9.3321973818E-01],
	[3.1615000000E+04, 2.5120236447E+01, 5.4048387452E+00, 8.7308919641E+00, 2.9466904798E+00, 9.3325192301E-01],
	[3.1620000000E+04, 2.5126888044E+01, 5.4048400427E+00, 8.7353889085E+00, 2.9472944631E+00, 9.3328409141E-01],
	[3.1625000000E+04, 2.5133540350E+01, 5.4048413400E+00, 8.7398874564E+00, 2.9478983103E+00, 9.3331624337E-01],
	[3.1630000000E+04, 2.5140193365E+01, 5.4048426372E+00, 8.7443876081E+00, 2.9485020216E+00, 9.3334837890E-01],
	[3.1635000000E+04, 2.5146847089E+01, 5.4048439341E+00, 8.7488893640E+00, 2.9491055968E+00, 9.3338049802E-01],
	[3.1640000000E+04, 2.5153501522E+01, 5.4048452308E+00, 8.7533927244E+00, 2.9497090361E+00, 9.3341260073E-01],
	[3.1645000000E+04, 2.5160156664E+01, 5.4048465273E+00, 8.7578976895E+00, 2.9503123393E+00, 9.3344468703E-01],
	[3.1650000000E+04, 2.5166812515E+01, 5.4048478236E+00, 8.7624042597E+00, 2.9509155065E+00, 9.3347675695E-01],
	[3.1655000000E+04, 2.5173469075E+01, 5.4048491197E+00, 8.7669124354E+00, 2.9515185376E+00, 9.3350881047E-01],
	[3.1660000000E+04, 2.5180126344E+01, 5.4048504156E+00, 8.7714222168E+00, 2.9521214327E+00, 9.3354084762E-01],
	[3.1665000000E+04, 2.5186784321E+01, 5.4048517113E+00, 8.7759336042E+00, 2.9527241917E+00, 9.3357286840E-01],
	[3.1670000000E+04, 2.5193443008E+01, 5.4048530068E+00, 8.7804465980E+00, 2.9533268146E+00, 9.3360487282E-01],
	[3.1675000000E+04, 2.5200102403E+01, 5.4048543021E+00, 8.7849611985E+00, 2.9539293015E+00, 9.3363686088E-01],
	[3.1680000000E+04, 2.5206762507E+01, 5.4048555971E+00, 8.7894774060E+00, 2.9545316522E+00, 9.3366883260E-01],
	[3.1685000000E+04, 2.5213423320E+01, 5.4048568920E+00, 8.7939952208E+00, 2.9551338669E+00, 9.3370078797E-01],
	[3.1690000000E+04, 2.5220084841E+01, 5.4048581867E+00, 8.7985146432E+00, 2.9557359454E+00, 9.3373272702E-01],
	[3.1695000000E+04, 2.5226747071E+01, 5.4048594811E+00, 8.8030356737E+00, 2.9563378878E+00, 9.3376464974E-01],
	[3.1700000000E+04, 2.5233410010E+01, 5.4048607754E+00, 8.8075583123E+00, 2.9569396941E+00, 9.3379655615E-01],
	[3.1705000000E+04, 2.5240073657E+01, 5.4048620695E+00, 8.8120825596E+00, 2.9575413642E+00, 9.3382844625E-01],
	[3.1710000000E+04, 2.5246738013E+01, 5.4048633633E+00, 8.8166084158E+00, 2.9581428982E+00, 9.3386032005E-01],
	[3.1715000000E+04, 2.5253403077E+01, 5.4048646570E+00, 8.8211358813E+00, 2.9587442960E+00, 9.3389217755E-01],
	[3.1720000000E+04, 2.5260068849E+01, 5.4048659504E+00, 8.8256649562E+00, 2.9593455576E+00, 9.3392401878E-01],
	[3.1725000000E+04, 2.5266735330E+01, 5.4048672437E+00, 8.8301956411E+00, 2.9599466831E+00, 9.3395584372E-01],
	[3.1730000000E+04, 2.5273402520E+01, 5.4048685367E+00, 8.8347279361E+00, 2.9605476724E+00, 9.3398765240E-01],
	[3.1735000000E+04, 2.5280070418E+01, 5.4048698295E+00, 8.8392618416E+00, 2.9611485255E+00, 9.3401944482E-01],
	[3.1740000000E+04, 2.5286739024E+01, 5.4048711222E+00, 8.8437973579E+00, 2.9617492423E+00, 9.3405122098E-01],
	[3.1745000000E+04, 2.5293408338E+01, 5.4048724146E+00, 8.8483344854E+00, 2.9623498230E+00, 9.3408298090E-01],
	[3.1750000000E+04, 2.5300078361E+01, 5.4048737068E+00, 8.8528732243E+00, 2.9629502674E+00, 9.3411472459E-01],
	[3.1755000000E+04, 2.5306749091E+01, 5.4048749988E+00, 8.8574135750E+00, 2.9635505756E+00, 9.3414645204E-01],
	[3.1760000000E+04, 2.5313420530E+01, 5.4048762907E+00, 8.8619555378E+00, 2.9641507476E+00, 9.3417816327E-01],
	[3.1765000000E+04, 2.5320092677E+01, 5.4048775823E+00, 8.8664991130E+00, 2.9647507833E+00, 9.3420985829E-01],
	[3.1770000000E+04, 2.5326765532E+01, 5.4048788737E+00, 8.8710443009E+00, 2.9653506827E+00, 9.3424153711E-01],
	[3.1775000000E+04, 2.5333439095E+01, 5.4048801649E+00, 8.8755911019E+00, 2.9659504459E+00, 9.3427319972E-01],
	[3.1780000000E+04, 2.5340113367E+01, 5.4048814559E+00, 8.8801395162E+00, 2.9665500727E+00, 9.3430484615E-01],
	[3.1785000000E+04, 2.5346788346E+01, 5.4048827467E+00, 8.8846895442E+00, 2.9671495634E+00, 9.3433647639E-01],
	[3.1790000000E+04, 2.5353464033E+01, 5.4048840373E+00, 8.8892411862E+00, 2.9677489177E+00, 9.3436809046E-01],
	[3.1795000000E+04, 2.5360140428E+01, 5.4048853277E+00, 8.8937944425E+00, 2.9683481357E+00, 9.3439968836E-01],
	[3.1800000000E+04, 2.5366817531E+01, 5.4048866179E+00, 8.8983493134E+00, 2.9689472174E+00, 9.3443127010E-01],
	[3.1805000000E+04, 2.5373495341E+01, 5.4048879079E+00, 8.9029057993E+00, 2.9695461627E+00, 9.3446283569E-01],
	[3.1810000000E+04, 2.5380173860E+01, 5.4048891977E+00, 8.9074639005E+00, 2.9701449718E+00, 9.3449438514E-01],
	[3.1815000000E+04, 2.5386853086E+01, 5.4048904873E+00, 8.9120236173E+00, 2.9707436445E+00, 9.3452591845E-01],
	[3.1820000000E+04, 2.5393533020E+01, 5.4048917767E+00, 8.9165849499E+00, 2.9713421808E+00, 9.3455743564E-01],
	[3.1825000000E+04, 2.5400213662E+01, 5.4048930659E+00, 8.9211478988E+00, 2.9719405809E+00, 9.3458893671E-01],
	[3.1830000000E+04, 2.5406895011E+01, 5.4048943549E+00, 8.9257124642E+00, 2.9725388445E+00, 9.3462042166E-01],
	[3.1835000000E+04, 2.5413577068E+01, 5.4048956436E+00, 8.9302786465E+00, 2.9731369718E+00, 9.3465189051E-01],
	[3.1840000000E+04, 2.5420259832E+01, 5.4048969322E+00, 8.9348464459E+00, 2.9737349627E+00, 9.3468334327E-01],
	[3.1845000000E+04, 2.5426943304E+01, 5.4048982206E+00, 8.9394158629E+00, 2.9743328172E+00, 9.3471477993E-01],
	[3.1850000000E+04, 2.5433627484E+01, 5.4048995088E+00, 8.9439868976E+00, 2.9749305353E+00, 9.3474620052E-01],
	[3.1855000000E+04, 2.5440312371E+01, 5.4049007967E+00, 8.9485595505E+00, 2.9755281170E+00, 9.3477760504E-01],
	[3.1860000000E+04, 2.5446997965E+01, 5.4049020845E+00, 8.9531338218E+00, 2.9761255623E+00, 9.3480899348E-01],
	[3.1865000000E+04, 2.5453684267E+01, 5.4049033721E+00, 8.9577097119E+00, 2.9767228712E+00, 9.3484036588E-01],
	[3.1870000000E+04, 2.5460371276E+01, 5.4049046595E+00, 8.9622872211E+00, 2.9773200437E+00, 9.3487172222E-01],
	[3.1875000000E+04, 2.5467058993E+01, 5.4049059466E+00, 8.9668663497E+00, 2.9779170797E+00, 9.3490306252E-01],
	[3.1880000000E+04, 2.5473747417E+01, 5.4049072336E+00, 8.9714470980E+00, 2.9785139793E+00, 9.3493438679E-01],
	[3.1885000000E+04, 2.5480456004E+01, 5.4049112206E+00, 8.9760294664E+00, 2.9791118288E+00, 9.3496569504E-01],
	[3.1890000000E+04, 2.5487167970E+01, 5.4049155768E+00, 8.9806134551E+00, 2.9797096912E+00, 9.3499698726E-01],
	[3.1895000000E+04, 2.5493880652E+01, 5.4049199323E+00, 8.9851990645E+00, 2.9803074178E+00, 9.3502826348E-01],
	[3.1900000000E+04, 2.5500594050E+01, 5.4049242872E+00, 8.9897862948E+00, 2.9809050085E+00, 9.3505952369E-01],
	[3.1905000000E+04, 2.5507308162E+01, 5.4049286414E+00, 8.9943751465E+00, 2.9815024634E+00, 9.3509076791E-01],
	[3.1910000000E+04, 2.5514022990E+01, 5.4049329949E+00, 8.9989656199E+00, 2.9820997824E+00, 9.3512199615E-01],
	[3.1915000000E+04, 2.5520738533E+01, 5.4049373477E+00, 9.0035577151E+00, 2.9826969656E+00, 9.3515320840E-01],
	[3.1920000000E+04, 2.5527454792E+01, 5.4049416999E+00, 9.0081514327E+00, 2.9832940129E+00, 9.3518440469E-01],
	[3.1925000000E+04, 2.5534171765E+01, 5.4049460514E+00, 9.0127467728E+00, 2.9838909244E+00, 9.3521558501E-01],
	[3.1930000000E+04, 2.5540889454E+01, 5.4049504021E+00, 9.0173437358E+00, 2.9844876999E+00, 9.3524674938E-01],
	[3.1935000000E+04, 2.5547607857E+01, 5.4049547523E+00, 9.0219423220E+00, 2.9850843396E+00, 9.3527789780E-01],
	[3.1940000000E+04, 2.5554326976E+01, 5.4049591017E+00, 9.0265425318E+00, 2.9856808434E+00, 9.3530903029E-01],
	[3.1945000000E+04, 2.5561046809E+01, 5.4049634505E+00, 9.0311443655E+00, 2.9862772113E+00, 9.3534014684E-01],
	[3.1950000000E+04, 2.5567767358E+01, 5.4049677985E+00, 9.0357478233E+00, 2.9868734433E+00, 9.3537124746E-01],
	[3.1955000000E+04, 2.5574488621E+01, 5.4049721460E+00, 9.0403529056E+00, 2.9874695393E+00, 9.3540233218E-01],
	[3.1960000000E+04, 2.5581210599E+01, 5.4049764927E+00, 9.0449596127E+00, 2.9880654995E+00, 9.3543340098E-01],
	[3.1965000000E+04, 2.5587933293E+01, 5.4049808387E+00, 9.0495679450E+00, 2.9886613237E+00, 9.3546445388E-01],
	[3.1970000000E+04, 2.5594656701E+01, 5.4049851841E+00, 9.0541779027E+00, 2.9892570120E+00, 9.3549549090E-01],
	[3.1975000000E+04, 2.5601380823E+01, 5.4049895288E+00, 9.0587894862E+00, 2.9898525643E+00, 9.3552651202E-01],
	[3.1980000000E+04, 2.5608105661E+01, 5.4049938728E+00, 9.0634026957E+00, 2.9904479807E+00, 9.3555751728E-01],
	[3.1985000000E+04, 2.5614831213E+01, 5.4049982162E+00, 9.0680175317E+00, 2.9910432611E+00, 9.3558850666E-01],
	[3.1990000000E+04, 2.5621557480E+01, 5.4050025589E+00, 9.0726339944E+00, 2.9916384055E+00, 9.3561948018E-01],
	[3.1995000000E+04, 2.5628284461E+01, 5.4050069009E+00, 9.0772520841E+00, 2.9922334140E+00, 9.3565043785E-01],
	[3.2000000000E+04, 2.5635012157E+01, 5.4050112422E+00, 9.0818718012E+00, 2.9928282865E+00, 9.3568137968E-01],
	[3.2005000000E+04, 2.5641740568E+01, 5.4050155828E+00, 9.0864931460E+00, 2.9934230231E+00, 9.3571230567E-01],
	[3.2010000000E+04, 2.5648469693E+01, 5.4050199228E+00, 9.0911161188E+00, 2.9940176236E+00, 9.3574321583E-01],
	[3.2015000000E+04, 2.5655199533E+01, 5.4050242621E+00, 9.0957407199E+00, 2.9946120881E+00, 9.3577411016E-01],
	[3.2020000000E+04, 2.5661930087E+01, 5.4050286008E+00, 9.1003669496E+00, 2.9952064166E+00, 9.3580498869E-01],
	[3.2025000000E+04, 2.5668661355E+01, 5.4050329387E+00, 9.1049948082E+00, 2.9958006091E+00, 9.3583585141E-01],
	[3.2030000000E+04, 2.5675393338E+01, 5.4050372760E+00, 9.1096242962E+00, 2.9963946656E+00, 9.3586669833E-01],
	[3.2035000000E+04, 2.5682126035E+01, 5.4050416126E+00, 9.1142554137E+00, 2.9969885861E+00, 9.3589752946E-01],
	[3.2040000000E+04, 2.5688859447E+01, 5.4050459485E+00, 9.1188881612E+00, 2.9975823705E+00, 9.3592834481E-01],
	[3.2045000000E+04, 2.5695593572E+01, 5.4050502838E+00, 9.1235225388E+00, 2.9981760189E+00, 9.3595914438E-01],
	[3.2050000000E+04, 2.5702328412E+01, 5.4050546184E+00, 9.1281585470E+00, 2.9987695313E+00, 9.3598992819E-01],
	[3.2055000000E+04, 2.5709063967E+01, 5.4050589523E+00, 9.1327961861E+00, 2.9993629076E+00, 9.3602069624E-01],
	[3.2060000000E+04, 2.5715800235E+01, 5.4050632855E+00, 9.1374354564E+00, 2.9999561479E+00, 9.3605144854E-01],
	[3.2065000000E+04, 2.5722537218E+01, 5.4050676181E+00, 9.1420763581E+00, 3.0005492520E+00, 9.3608218509E-01],
	[3.2070000000E+04, 2.5729274914E+01, 5.4050719500E+00, 9.1467188917E+00, 3.0011422202E+00, 9.3611290591E-01],
	[3.2075000000E+04, 2.5736013325E+01, 5.4050762812E+00, 9.1513630574E+00, 3.0017350522E+00, 9.3614361101E-01],
	[3.2080000000E+04, 2.5742752449E+01, 5.4050806118E+00, 9.1560088556E+00, 3.0023277482E+00, 9.3617430038E-01],
	[3.2085000000E+04, 2.5749492288E+01, 5.4050849417E+00, 9.1606562866E+00, 3.0029203081E+00, 9.3620497404E-01],
	[3.2090000000E+04, 2.5756232841E+01, 5.4050892709E+00, 9.1653053506E+00, 3.0035127318E+00, 9.3623563200E-01],
	[3.2095000000E+04, 2.5762974107E+01, 5.4050935994E+00, 9.1699560481E+00, 3.0041050195E+00, 9.3626627427E-01],
	[3.2100000000E+04, 2.5769716088E+01, 5.4050979273E+00, 9.1746083793E+00, 3.0046971711E+00, 9.3629690084E-01],
	[3.2105000000E+04, 2.5776458782E+01, 5.4051022545E+00, 9.1792623445E+00, 3.0052891866E+00, 9.3632751174E-01],
	[3.2110000000E+04, 2.5783202190E+01, 5.4051065810E+00, 9.1839179441E+00, 3.0058810659E+00, 9.3635810696E-01],
	[3.2115000000E+04, 2.5789946312E+01, 5.4051109069E+00, 9.1885751784E+00, 3.0064728092E+00, 9.3638868652E-01],
	[3.2120000000E+04, 2.5796691147E+01, 5.4051152320E+00, 9.1932340477E+00, 3.0070644163E+00, 9.3641925042E-01],
	[3.2125000000E+04, 2.5803436697E+01, 5.4051195566E+00, 9.1978945523E+00, 3.0076558873E+00, 9.3644979868E-01],
	[3.2130000000E+04, 2.5810182960E+01, 5.4051238804E+00, 9.2025566926E+00, 3.0082472221E+00, 9.3648033129E-01],
	[3.2135000000E+04, 2.5816929936E+01, 5.4051282036E+00, 9.2072204689E+00, 3.0088384208E+00, 9.3651084827E-01],
	[3.2140000000E+04, 2.5823677626E+01, 5.4051325261E+00, 9.2118858814E+00, 3.0094294834E+00, 9.3654134962E-01],
	[3.2145000000E+04, 2.5830426030E+01, 5.4051368479E+00, 9.2165529305E+00, 3.0100204098E+00, 9.3657183536E-01],
	[3.2150000000E+04, 2.5837175147E+01, 5.4051411691E+00, 9.2212216165E+00, 3.0106112000E+00, 9.3660230549E-01],
	[3.2155000000E+04, 2.5843924978E+01, 5.4051454896E+00, 9.2258919398E+00, 3.0112018541E+00, 9.3663276001E-01],
	[3.2160000000E+04, 2.5850675522E+01, 5.4051498095E+00, 9.2305639006E+00, 3.0117923720E+00, 9.3666319895E-01],
	[3.2165000000E+04, 2.5857426780E+01, 5.4051541286E+00, 9.2352374993E+00, 3.0123827537E+00, 9.3669362229E-01],
	[3.2170000000E+04, 2.5864178751E+01, 5.4051584471E+00, 9.2399127362E+00, 3.0129729992E+00, 9.3672403006E-01],
	[3.2175000000E+04, 2.5870931435E+01, 5.4051627650E+00, 9.2445896117E+00, 3.0135631086E+00, 9.3675442226E-01],
	[3.2180000000E+04, 2.5877684833E+01, 5.4051670821E+00, 9.2492681259E+00, 3.0141530818E+00, 9.3678479890E-01],
	[3.2185000000E+04, 2.5884438944E+01, 5.4051713986E+00, 9.2539482793E+00, 3.0147429187E+00, 9.3681515998E-01],
	[3.2190000000E+04, 2.5891193768E+01, 5.4051757144E+00, 9.2586300722E+00, 3.0153326195E+00, 9.3684550551E-01],
	[3.2195000000E+04, 2.5897949305E+01, 5.4051800296E+00, 9.2633135048E+00, 3.0159221841E+00, 9.3687583551E-01],
	[3.2200000000E+04, 2.5904705556E+01, 5.4051843441E+00, 9.2679985776E+00, 3.0165116124E+00, 9.3690614997E-01],
	[3.2205000000E+04, 2.5911462519E+01, 5.4051886579E+00, 9.2726852908E+00, 3.0171009046E+00, 9.3693644892E-01],
	[3.2210000000E+04, 2.5918220196E+01, 5.4051929711E+00, 9.2773736447E+00, 3.0176900605E+00, 9.3696673234E-01],
	[3.2215000000E+04, 2.5924978586E+01, 5.4051972836E+00, 9.2820636397E+00, 3.0182790802E+00, 9.3699700026E-01],
	[3.2220000000E+04, 2.5931737689E+01, 5.4052015954E+00, 9.2867552761E+00, 3.0188679636E+00, 9.3702725268E-01],
	[3.2225000000E+04, 2.5938497505E+01, 5.4052059066E+00, 9.2914485542E+00, 3.0194567109E+00, 9.3705748961E-01],
	[3.2230000000E+04, 2.5945258033E+01, 5.4052102171E+00, 9.2961434743E+00, 3.0200453218E+00, 9.3708771105E-01],
	[3.2235000000E+04, 2.5952019275E+01, 5.4052145269E+00, 9.3008400368E+00, 3.0206337966E+00, 9.3711791702E-01],
	[3.2240000000E+04, 2.5958781230E+01, 5.4052188361E+00, 9.3055382419E+00, 3.0212221351E+00, 9.3714810752E-01],
	[3.2245000000E+04, 2.5965543897E+01, 5.4052231446E+00, 9.3102380900E+00, 3.0218103373E+00, 9.3717828256E-01],
	[3.2250000000E+04, 2.5972307277E+01, 5.4052274524E+00, 9.3149395814E+00, 3.0223984033E+00, 9.3720844214E-01],
	[3.2255000000E+04, 2.5979071370E+01, 5.4052317596E+00, 9.3196427164E+00, 3.0229863330E+00, 9.3723858629E-01],
	[3.2260000000E+04, 2.5985836176E+01, 5.4052360661E+00, 9.3243474953E+00, 3.0235741265E+00, 9.3726871499E-01],
	[3.2265000000E+04, 2.5992601695E+01, 5.4052403720E+00, 9.3290539185E+00, 3.0241617837E+00, 9.3729882827E-01],
	[3.2270000000E+04, 2.5999367926E+01, 5.4052446772E+00, 9.3337619863E+00, 3.0247493046E+00, 9.3732892612E-01],
	[3.2275000000E+04, 2.6006134870E+01, 5.4052489817E+00, 9.3384716990E+00, 3.0253366892E+00, 9.3735900856E-01],
	[3.2280000000E+04, 2.6012902526E+01, 5.4052532855E+00, 9.3431830568E+00, 3.0259239376E+00, 9.3738907559E-01],
	[3.2285000000E+04, 2.6019670895E+01, 5.4052575887E+00, 9.3478960602E+00, 3.0265110496E+00, 9.3741912723E-01],
	[3.2290000000E+04, 2.6026439976E+01, 5.4052618913E+00, 9.3526107095E+00, 3.0270980254E+00, 9.3744916348E-01],
	[3.2295000000E+04, 2.6033209770E+01, 5.4052661931E+00, 9.3573270049E+00, 3.0276848649E+00, 9.3747918434E-01],
	[3.2300000000E+04, 2.6039980277E+01, 5.4052704943E+00, 9.3620449468E+00, 3.0282715681E+00, 9.3750918984E-01],
	[3.2305000000E+04, 2.6046751496E+01, 5.4052747949E+00, 9.3667645356E+00, 3.0288581349E+00, 9.3753917996E-01],
	[3.2310000000E+04, 2.6053523427E+01, 5.4052790948E+00, 9.3714857714E+00, 3.0294445655E+00, 9.3756915473E-01],
	[3.2315000000E+04, 2.6060296070E+01, 5.4052833940E+00, 9.3762086547E+00, 3.0300308598E+00, 9.3759911414E-01],
	[3.2320000000E+04, 2.6067069426E+01, 5.4052876925E+00, 9.3809331858E+00, 3.0306170177E+00, 9.3762905821E-01],
	[3.2325000000E+04, 2.6073843495E+01, 5.4052919904E+00, 9.3856593649E+00, 3.0312030393E+00, 9.3765898695E-01],
	[3.2330000000E+04, 2.6080618275E+01, 5.4052962877E+00, 9.3903871925E+00, 3.0317889246E+00, 9.3768890036E-01],
	[3.2335000000E+04, 2.6087393768E+01, 5.4053005843E+00, 9.3951166688E+00, 3.0323746736E+00, 9.3771879845E-01],
	[3.2340000000E+04, 2.6094169973E+01, 5.4053048802E+00, 9.3998477941E+00, 3.0329602863E+00, 9.3774868123E-01],
	[3.2345000000E+04, 2.6100946890E+01, 5.4053091754E+00, 9.4045805688E+00, 3.0335457626E+00, 9.3777854870E-01],
	[3.2350000000E+04, 2.6107724519E+01, 5.4053134700E+00, 9.4093149932E+00, 3.0341311025E+00, 9.3780840088E-01],
	[3.2355000000E+04, 2.6114502860E+01, 5.4053177639E+00, 9.4140510675E+00, 3.0347163062E+00, 9.3783823777E-01],
	[3.2360000000E+04, 2.6121281913E+01, 5.4053220572E+00, 9.4187887922E+00, 3.0353013735E+00, 9.3786805939E-01],
	[3.2365000000E+04, 2.6128061678E+01, 5.4053263498E+00, 9.4235281675E+00, 3.0358863044E+00, 9.3789786572E-01],
	[3.2370000000E+04, 2.6134842155E+01, 5.4053306418E+00, 9.4282691938E+00, 3.0364710990E+00, 9.3792765680E-01],
	[3.2375000000E+04, 2.6141623345E+01, 5.4053349331E+00, 9.4330118714E+00, 3.0370557573E+00, 9.3795743261E-01],
	[3.2380000000E+04, 2.6148405246E+01, 5.4053392237E+00, 9.4377562006E+00, 3.0376402791E+00, 9.3798719318E-01],
	[3.2385000000E+04, 2.6155187858E+01, 5.4053435137E+00, 9.4425021816E+00, 3.0382246647E+00, 9.3801693851E-01],
	[3.2390000000E+04, 2.6161971183E+01, 5.4053478030E+00, 9.4472498149E+00, 3.0388089138E+00, 9.3804666860E-01],
	[3.2395000000E+04, 2.6168760312E+01, 5.4053527914E+00, 9.4519991008E+00, 3.0393933166E+00, 9.3807638347E-01],
	[3.2400000000E+04, 2.6175566951E+01, 5.4053600869E+00, 9.4567500396E+00, 3.0399785396E+00, 9.3810608312E-01],
	[3.2405000000E+04, 2.6182374311E+01, 5.4053673812E+00, 9.4615029148E+00, 3.0405636561E+00, 9.3813576756E-01],
	[3.2410000000E+04, 2.6189182390E+01, 5.4053746744E+00, 9.4662582505E+00, 3.0411487200E+00, 9.3816543679E-01],
	[3.2415000000E+04, 2.6195991189E+01, 5.4053819664E+00, 9.4710152410E+00, 3.0417336482E+00, 9.3819509084E-01],
	[3.2420000000E+04, 2.6202800707E+01, 5.4053892574E+00, 9.4757738866E+00, 3.0423184406E+00, 9.3822472969E-01],
	[3.2425000000E+04, 2.6209610945E+01, 5.4053965473E+00, 9.4805341878E+00, 3.0429030971E+00, 9.3825435337E-01],
	[3.2430000000E+04, 2.6216421902E+01, 5.4054038360E+00, 9.4852961447E+00, 3.0434876179E+00, 9.3828396188E-01],
	[3.2435000000E+04, 2.6223233579E+01, 5.4054111236E+00, 9.4900597577E+00, 3.0440720028E+00, 9.3831355522E-01],
	[3.2440000000E+04, 2.6230045975E+01, 5.4054184101E+00, 9.4948250271E+00, 3.0446562519E+00, 9.3834313341E-01],
	[3.2445000000E+04, 2.6236859091E+01, 5.4054256955E+00, 9.4995919532E+00, 3.0452403652E+00, 9.3837269645E-01],
	[3.2450000000E+04, 2.6243672926E+01, 5.4054329798E+00, 9.5043605364E+00, 3.0458243426E+00, 9.3840224435E-01],
	[3.2455000000E+04, 2.6250487481E+01, 5.4054402630E+00, 9.5091307771E+00, 3.0464081842E+00, 9.3843177712E-01],
	[3.2460000000E+04, 2.6257302755E+01, 5.4054475450E+00, 9.5139026754E+00, 3.0469918900E+00, 9.3846129477E-01],
	[3.2465000000E+04, 2.6264118748E+01, 5.4054548260E+00, 9.5186762317E+00, 3.0475754599E+00, 9.3849079730E-01],
	[3.2470000000E+04, 2.6270935460E+01, 5.4054621058E+00, 9.5234514463E+00, 3.0481588940E+00, 9.3852028472E-01],
	[3.2475000000E+04, 2.6277752892E+01, 5.4054693846E+00, 9.5282283197E+00, 3.0487421923E+00, 9.3854975704E-01],
	[3.2480000000E+04, 2.6284571043E+01, 5.4054766622E+00, 9.5330068520E+00, 3.0493253547E+00, 9.3857921427E-01],
	[3.2485000000E+04, 2.6291389913E+01, 5.4054839387E+00, 9.5377870436E+00, 3.0499083813E+00, 9.3860865641E-01],
	[3.2490000000E+04, 2.6298209502E+01, 5.4054912141E+00, 9.5425688948E+00, 3.0504912720E+00, 9.3863808348E-01],
	[3.2495000000E+04, 2.6305029810E+01, 5.4054984884E+00, 9.5473524060E+00, 3.0510740269E+00, 9.3866749548E-01],
	[3.2500000000E+04, 2.6311850837E+01, 5.4055057615E+00, 9.5521375774E+00, 3.0516566459E+00, 9.3869689241E-01],
	[3.2505000000E+04, 2.6318672583E+01, 5.4055130336E+00, 9.5569244095E+00, 3.0522391291E+00, 9.3872627429E-01],
	[3.2510000000E+04, 2.6325495049E+01, 5.4055203045E+00, 9.5617129024E+00, 3.0528214764E+00, 9.3875564113E-01],
	[3.2515000000E+04, 2.6332318233E+01, 5.4055275744E+00, 9.5665030565E+00, 3.0534036878E+00, 9.3878499292E-01],
	[3.2520000000E+04, 2.6339142136E+01, 5.4055348431E+00, 9.5712948722E+00, 3.0539857634E+00, 9.3881432969E-01],
	[3.2525000000E+04, 2.6345966758E+01, 5.4055421108E+00, 9.5760883498E+00, 3.0545677031E+00, 9.3884365143E-01],
	[3.2530000000E+04, 2.6352792098E+01, 5.4055493773E+00, 9.5808834895E+00, 3.0551495069E+00, 9.3887295816E-01],
	[3.2535000000E+04, 2.6359618158E+01, 5.4055566427E+00, 9.5856802917E+00, 3.0557311749E+00, 9.3890224989E-01],
	[3.2540000000E+04, 2.6366444936E+01, 5.4055639070E+00, 9.5904787568E+00, 3.0563127070E+00, 9.3893152661E-01],
	[3.2545000000E+04, 2.6373272433E+01, 5.4055711702E+00, 9.5952788850E+00, 3.0568941032E+00, 9.3896078834E-01],
	[3.2550000000E+04, 2.6380100649E+01, 5.4055784323E+00, 9.6000806767E+00, 3.0574753635E+00, 9.3899003509E-01],
	[3.2555000000E+04, 2.6386929584E+01, 5.4055856933E+00, 9.6048841321E+00, 3.0580564880E+00, 9.3901926686E-01],
	[3.2560000000E+04, 2.6393759237E+01, 5.4055929532E+00, 9.6096892517E+00, 3.0586374765E+00, 9.3904848366E-01],
	[3.2565000000E+04, 2.6400589608E+01, 5.4056002120E+00, 9.6144960356E+00, 3.0592183292E+00, 9.3907768549E-01],
	[3.2570000000E+04, 2.6407420698E+01, 5.4056074697E+00, 9.6193044844E+00, 3.0597990460E+00, 9.3910687238E-01],
	[3.2575000000E+04, 2.6414252507E+01, 5.4056147262E+00, 9.6241145982E+00, 3.0603796270E+00, 9.3913604431E-01],
	[3.2580000000E+04, 2.6421085034E+01, 5.4056219817E+00, 9.6289263773E+00, 3.0609600720E+00, 9.3916520130E-01],
	[3.2585000000E+04, 2.6427918280E+01, 5.4056292361E+00, 9.6337398222E+00, 3.0615403811E+00, 9.3919434336E-01],
	[3.2590000000E+04, 2.6434752244E+01, 5.4056364893E+00, 9.6385549331E+00, 3.0621205544E+00, 9.3922347049E-01],
	[3.2595000000E+04, 2.6441586926E+01, 5.4056437415E+00, 9.6433717104E+00, 3.0627005917E+00, 9.3925258270E-01],
	[3.2600000000E+04, 2.6448422327E+01, 5.4056509926E+00, 9.6481901543E+00, 3.0632804932E+00, 9.3928168000E-01],
	[3.2605000000E+04, 2.6455258446E+01, 5.4056582425E+00, 9.6530102652E+00, 3.0638602587E+00, 9.3931076239E-01],
	[3.2610000000E+04, 2.6462095284E+01, 5.4056654914E+00, 9.6578320434E+00, 3.0644398884E+00, 9.3933982988E-01],
	[3.2615000000E+04, 2.6468932839E+01, 5.4056727391E+00, 9.6626554892E+00, 3.0650193821E+00, 9.3936888249E-01],
	[3.2620000000E+04, 2.6475771113E+01, 5.4056799858E+00, 9.6674806030E+00, 3.0655987400E+00, 9.3939792021E-01],
	[3.2625000000E+04, 2.6482610105E+01, 5.4056872313E+00, 9.6723073851E+00, 3.0661779619E+00, 9.3942694305E-01],
	[3.2630000000E+04, 2.6489449816E+01, 5.4056944758E+00, 9.6771358357E+00, 3.0667570480E+00, 9.3945595102E-01],
	[3.2635000000E+04, 2.6496290244E+01, 5.4057017191E+00, 9.6819659553E+00, 3.0673359981E+00, 9.3948494413E-01],
	[3.2640000000E+04, 2.6503131390E+01, 5.4057089614E+00, 9.6867977441E+00, 3.0679148124E+00, 9.3951392239E-01],
	[3.2645000000E+04, 2.6509973255E+01, 5.4057162025E+00, 9.6916312024E+00, 3.0684934907E+00, 9.3954288580E-01],
	[3.2650000000E+04, 2.6516815837E+01, 5.4057234426E+00, 9.6964663306E+00, 3.0690720331E+00, 9.3957183436E-01],
	[3.2655000000E+04, 2.6523659137E+01, 5.4057306815E+00, 9.7013031290E+00, 3.0696504396E+00, 9.3960076810E-01],
	[3.2660000000E+04, 2.6530503156E+01, 5.4057379194E+00, 9.7061415979E+00, 3.0702287102E+00, 9.3962968700E-01],
	[3.2665000000E+04, 2.6537347892E+01, 5.4057451561E+00, 9.7109817376E+00, 3.0708068448E+00, 9.3965859109E-01],
	[3.2670000000E+04, 2.6544193346E+01, 5.4057523918E+00, 9.7158235485E+00, 3.0713848436E+00, 9.3968748037E-01],
	[3.2675000000E+04, 2.6551039518E+01, 5.4057596263E+00, 9.7206670309E+00, 3.0719627064E+00, 9.3971635484E-01],
	[3.2680000000E+04, 2.6557886408E+01, 5.4057668598E+00, 9.7255121851E+00, 3.0725404334E+00, 9.3974521451E-01],
	[3.2685000000E+04, 2.6564734015E+01, 5.4057740921E+00, 9.7303590113E+00, 3.0731180244E+00, 9.3977405939E-01],
	[3.2690000000E+04, 2.6571582340E+01, 5.4057813234E+00, 9.7352075100E+00, 3.0736954794E+00, 9.3980288949E-01],
	[3.2695000000E+04, 2.6578431383E+01, 5.4057885536E+00, 9.7400576815E+00, 3.0742727986E+00, 9.3983170482E-01],
	[3.2700000000E+04, 2.6585281144E+01, 5.4057957827E+00, 9.7449095260E+00, 3.0748499819E+00, 9.3986050537E-01],
	[3.2705000000E+04, 2.6592131622E+01, 5.4058030106E+00, 9.7497630440E+00, 3.0754270292E+00, 9.3988929116E-01],
	[3.2710000000E+04, 2.6598982818E+01, 5.4058102375E+00, 9.7546182356E+00, 3.0760039406E+00, 9.3991806220E-01],
	[3.2715000000E+04, 2.6605834731E+01, 5.4058174633E+00, 9.7594751013E+00, 3.0765807161E+00, 9.3994681849E-01],
	[3.2720000000E+04, 2.6612687362E+01, 5.4058246880E+00, 9.7643336414E+00, 3.0771573556E+00, 9.3997556004E-01],
	[3.2725000000E+04, 2.6619540710E+01, 5.4058319116E+00, 9.7691938561E+00, 3.0777338592E+00, 9.4000428686E-01],
	[3.2730000000E+04, 2.6626394776E+01, 5.4058391341E+00, 9.7740557458E+00, 3.0783102269E+00, 9.4003299895E-01],
	[3.2735000000E+04, 2.6633249559E+01, 5.4058463555E+00, 9.7789193109E+00, 3.0788864587E+00, 9.4006169633E-01],
	[3.2740000000E+04, 2.6640105059E+01, 5.4058535758E+00, 9.7837845516E+00, 3.0794625546E+00, 9.4009037899E-01],
	[3.2745000000E+04, 2.6646961277E+01, 5.4058607951E+00, 9.7886514682E+00, 3.0800385145E+00, 9.4011904695E-01],
	[3.2750000000E+04, 2.6653818213E+01, 5.4058680132E+00, 9.7935200612E+00, 3.0806143385E+00, 9.4014770021E-01],
	[3.2755000000E+04, 2.6660675865E+01, 5.4058752302E+00, 9.7983903307E+00, 3.0811900266E+00, 9.4017633878E-01],
	[3.2760000000E+04, 2.6667534235E+01, 5.4058824462E+00, 9.8032622772E+00, 3.0817655787E+00, 9.4020496267E-01],
	[3.2765000000E+04, 2.6674393322E+01, 5.4058896611E+00, 9.8081359009E+00, 3.0823409949E+00, 9.4023357188E-01],
	[3.2770000000E+04, 2.6681253126E+01, 5.4058968748E+00, 9.8130112022E+00, 3.0829162752E+00, 9.4026216643E-01],
	[3.2775000000E+04, 2.6688113647E+01, 5.4059040875E+00, 9.8178881813E+00, 3.0834914196E+00, 9.4029074631E-01],
	[3.2780000000E+04, 2.6694974885E+01, 5.4059112991E+00, 9.8227668387E+00, 3.0840664280E+00, 9.4031931154E-01],
	[3.2785000000E+04, 2.6701836841E+01, 5.4059185096E+00, 9.8276471746E+00, 3.0846413005E+00, 9.4034786212E-01],
	[3.2790000000E+04, 2.6708699513E+01, 5.4059257190E+00, 9.8325291893E+00, 3.0852160371E+00, 9.4037639807E-01],
	[3.2795000000E+04, 2.6715562903E+01, 5.4059329273E+00, 9.8374128832E+00, 3.0857906378E+00, 9.4040491938E-01],
	[3.2800000000E+04, 2.6722427009E+01, 5.4059401345E+00, 9.8422982566E+00, 3.0863651025E+00, 9.4043342607E-01],
	[3.2805000000E+04, 2.6729291833E+01, 5.4059473407E+00, 9.8471853099E+00, 3.0869394313E+00, 9.4046191814E-01],
	[3.2810000000E+04, 2.6736157373E+01, 5.4059545457E+00, 9.8520740432E+00, 3.0875136241E+00, 9.4049039560E-01],
	[3.2815000000E+04, 2.6743023630E+01, 5.4059617497E+00, 9.8569644570E+00, 3.0880876811E+00, 9.4051885845E-01],
	[3.2820000000E+04, 2.6749890604E+01, 5.4059689525E+00, 9.8618565516E+00, 3.0886616021E+00, 9.4054730671E-01],
	[3.2825000000E+04, 2.6756758295E+01, 5.4059761543E+00, 9.8667503272E+00, 3.0892353871E+00, 9.4057574038E-01],
	[3.2830000000E+04, 2.6763626702E+01, 5.4059833550E+00, 9.8716457843E+00, 3.0898090363E+00, 9.4060415947E-01],
	[3.2835000000E+04, 2.6770495827E+01, 5.4059905546E+00, 9.8765429232E+00, 3.0903825495E+00, 9.4063256398E-01],
	[3.2840000000E+04, 2.6777365668E+01, 5.4059977531E+00, 9.8814417440E+00, 3.0909559268E+00, 9.4066095393E-01],
	[3.2845000000E+04, 2.6784236225E+01, 5.4060049506E+00, 9.8863422473E+00, 3.0915291682E+00, 9.4068932931E-01],
	[3.2850000000E+04, 2.6791107499E+01, 5.4060121469E+00, 9.8912444332E+00, 3.0921022736E+00, 9.4071769015E-01],
	[3.2855000000E+04, 2.6797979490E+01, 5.4060193422E+00, 9.8961483022E+00, 3.0926752431E+00, 9.4074603643E-01],
	[3.2860000000E+04, 2.6804852198E+01, 5.4060265364E+00, 9.9010538545E+00, 3.0932480767E+00, 9.4077436818E-01],
	[3.2865000000E+04, 2.6811725621E+01, 5.4060337295E+00, 9.9059610905E+00, 3.0938207744E+00, 9.4080268540E-01],
	[3.2870000000E+04, 2.6818599762E+01, 5.4060409215E+00, 9.9108700105E+00, 3.0943933361E+00, 9.4083098809E-01],
	[3.2875000000E+04, 2.6825474619E+01, 5.4060481124E+00, 9.9157806147E+00, 3.0949657620E+00, 9.4085927627E-01],
	[3.2880000000E+04, 2.6832350192E+01, 5.4060553022E+00, 9.9206929036E+00, 3.0955380518E+00, 9.4088754993E-01],
	[3.2885000000E+04, 2.6839226482E+01, 5.4060624910E+00, 9.9256068775E+00, 3.0961102058E+00, 9.4091580910E-01],
	[3.2890000000E+04, 2.6846103488E+01, 5.4060696787E+00, 9.9305225366E+00, 3.0966822239E+00, 9.4094405377E-01],
	[3.2895000000E+04, 2.6852981210E+01, 5.4060768653E+00, 9.9354398813E+00, 3.0972541060E+00, 9.4097228394E-01],
	[3.2900000000E+04, 2.6859859648E+01, 5.4060840508E+00, 9.9403589119E+00, 3.0978258522E+00, 9.4100049964E-01],
	[3.2905000000E+04, 2.6866738803E+01, 5.4060912352E+00, 9.9452796287E+00, 3.0983974625E+00, 9.4102870087E-01],
	[3.2910000000E+04, 2.6873618674E+01, 5.4060984186E+00, 9.9502020321E+00, 3.0989689369E+00, 9.4105688763E-01],
	[3.2915000000E+04, 2.6880499261E+01, 5.4061056008E+00, 9.9551261224E+00, 3.0995402753E+00, 9.4108505993E-01],
	[3.2920000000E+04, 2.6887400773E+01, 5.4061155319E+00, 9.9600518998E+00, 3.1001126508E+00, 9.4111321777E-01],
	[3.2925000000E+04, 2.6894304452E+01, 5.4061256580E+00, 9.9649793648E+00, 3.1006849747E+00, 9.4114136117E-01],
	[3.2930000000E+04, 2.6901208855E+01, 5.4061357825E+00, 9.9699085176E+00, 3.1012571633E+00, 9.4116949014E-01],
	[3.2935000000E+04, 2.6908113981E+01, 5.4061459056E+00, 9.9748393586E+00, 3.1018292166E+00, 9.4119760467E-01],
	[3.2940000000E+04, 2.6915019832E+01, 5.4061560271E+00, 9.9797718880E+00, 3.1024011345E+00, 9.4122570478E-01],
	[3.2945000000E+04, 2.6921926406E+01, 5.4061661471E+00, 9.9847061063E+00, 3.1029729171E+00, 9.4125379047E-01],
	[3.2950000000E+04, 2.6928833704E+01, 5.4061762655E+00, 9.9896420136E+00, 3.1035445644E+00, 9.4128186176E-01],
	[3.2955000000E+04, 2.6935741725E+01, 5.4061863825E+00, 9.9945796104E+00, 3.1041160763E+00, 9.4130991864E-01],
	[3.2960000000E+04, 2.6942650471E+01, 5.4061964979E+00, 9.9995188970E+00, 3.1046874529E+00, 9.4133796113E-01],
	[3.2965000000E+04, 2.6949559940E+01, 5.4062066118E+00, 1.0004459874E+01, 3.1052586943E+00, 9.4136598923E-01],
	[3.2970000000E+04, 2.6956470132E+01, 5.4062167242E+00, 1.0009402541E+01, 3.1058298002E+00, 9.4139400295E-01],
	[3.2975000000E+04, 2.6963381048E+01, 5.4062268351E+00, 1.0014346898E+01, 3.1064007709E+00, 9.4142200230E-01],
	[3.2980000000E+04, 2.6970292688E+01, 5.4062369445E+00, 1.0019292947E+01, 3.1069716062E+00, 9.4144998728E-01],
	[3.2985000000E+04, 2.6977205051E+01, 5.4062470524E+00, 1.0024240688E+01, 3.1075423063E+00, 9.4147795790E-01],
	[3.2990000000E+04, 2.6984118138E+01, 5.4062571587E+00, 1.0029190119E+01, 3.1081128710E+00, 9.4150591418E-01],
	[3.2995000000E+04, 2.6991031948E+01, 5.4062672636E+00, 1.0034141243E+01, 3.1086833004E+00, 9.4153385610E-01],
	[3.3000000000E+04, 2.6997946482E+01, 5.4062773669E+00, 1.0039094060E+01, 3.1092535944E+00, 9.4156178369E-01],
	[3.3005000000E+04, 2.7004861739E+01, 5.4062874687E+00, 1.0044048568E+01, 3.1098237532E+00, 9.4158969695E-01],
	[3.3010000000E+04, 2.7011777719E+01, 5.4062975690E+00, 1.0049004770E+01, 3.1103937767E+00, 9.4161759589E-01],
	[3.3015000000E+04, 2.7018694423E+01, 5.4063076678E+00, 1.0053962666E+01, 3.1109636648E+00, 9.4164548052E-01],
	[3.3020000000E+04, 2.7025611850E+01, 5.4063177651E+00, 1.0058922254E+01, 3.1115334176E+00, 9.4167335083E-01],
	[3.3025000000E+04, 2.7032530000E+01, 5.4063278609E+00, 1.0063883537E+01, 3.1121030352E+00, 9.4170120684E-01],
	[3.3030000000E+04, 2.7039448873E+01, 5.4063379551E+00, 1.0068846514E+01, 3.1126725174E+00, 9.4172904856E-01],
	[3.3035000000E+04, 2.7046368470E+01, 5.4063480479E+00, 1.0073811186E+01, 3.1132418643E+00, 9.4175687600E-01],
	[3.3040000000E+04, 2.7053288789E+01, 5.4063581391E+00, 1.0078777552E+01, 3.1138110759E+00, 9.4178468915E-01],
	[3.3045000000E+04, 2.7060209832E+01, 5.4063682289E+00, 1.0083745614E+01, 3.1143801522E+00, 9.4181248803E-01],
	[3.3050000000E+04, 2.7067131598E+01, 5.4063783171E+00, 1.0088715371E+01, 3.1149490933E+00, 9.4184027265E-01],
	[3.3055000000E+04, 2.7074054087E+01, 5.4063884038E+00, 1.0093686824E+01, 3.1155178990E+00, 9.4186804300E-01],
	[3.3060000000E+04, 2.7080977299E+01, 5.4063984890E+00, 1.0098659973E+01, 3.1160865694E+00, 9.4189579911E-01],
	[3.3065000000E+04, 2.7087901233E+01, 5.4064085727E+00, 1.0103634819E+01, 3.1166551045E+00, 9.4192354098E-01],
	[3.3070000000E+04, 2.7094825891E+01, 5.4064186549E+00, 1.0108611362E+01, 3.1172235044E+00, 9.4195126860E-01],
	[3.3075000000E+04, 2.7101751272E+01, 5.4064287356E+00, 1.0113589602E+01, 3.1177917689E+00, 9.4197898200E-01],
	[3.3080000000E+04, 2.7108677375E+01, 5.4064388148E+00, 1.0118569539E+01, 3.1183598982E+00, 9.4200668118E-01],
	[3.3085000000E+04, 2.7115604202E+01, 5.4064488925E+00, 1.0123551174E+01, 3.1189278921E+00, 9.4203436614E-01],
	[3.3090000000E+04, 2.7122531751E+01, 5.4064589687E+00, 1.0128534507E+01, 3.1194957508E+00, 9.4206203690E-01],
	[3.3095000000E+04, 2.7129460023E+01, 5.4064690434E+00, 1.0133519539E+01, 3.1200634742E+00, 9.4208969345E-01],
	[3.3100000000E+04, 2.7136389018E+01, 5.4064791166E+00, 1.0138506269E+01, 3.1206310624E+00, 9.4211733581E-01],
	[3.3105000000E+04, 2.7143318735E+01, 5.4064891882E+00, 1.0143494699E+01, 3.1211985152E+00, 9.4214496399E-01],
	[3.3110000000E+04, 2.7150249175E+01, 5.4064992584E+00, 1.0148484828E+01, 3.1217658328E+00, 9.4217257799E-01],
	[3.3115000000E+04, 2.7157180338E+01, 5.4065093271E+00, 1.0153476656E+01, 3.1223330151E+00, 9.4220017781E-01],
	[3.3120000000E+04, 2.7164112223E+01, 5.4065193942E+00, 1.0158470185E+01, 3.1229000621E+00, 9.4222776347E-01],
	[3.3125000000E+04, 2.7171044831E+01, 5.4065294599E+00, 1.0163465414E+01, 3.1234669739E+00, 9.4225533498E-01],
	[3.3130000000E+04, 2.7177978161E+01, 5.4065395241E+00, 1.0168462344E+01, 3.1240337504E+00, 9.4228289233E-01],
	[3.3135000000E+04, 2.7184912214E+01, 5.4065495867E+00, 1.0173460975E+01, 3.1246003916E+00, 9.4231043554E-01],
	[3.3140000000E+04, 2.7191846990E+01, 5.4065596479E+00, 1.0178461307E+01, 3.1251668976E+00, 9.4233796462E-01],
	[3.3145000000E+04, 2.7198782487E+01, 5.4065697076E+00, 1.0183463341E+01, 3.1257332683E+00, 9.4236547956E-01],
	[3.3150000000E+04, 2.7205718708E+01, 5.4065797657E+00, 1.0188467076E+01, 3.1262995038E+00, 9.4239298039E-01],
	[3.3155000000E+04, 2.7212655650E+01, 5.4065898224E+00, 1.0193472514E+01, 3.1268656040E+00, 9.4242046710E-01],
	[3.3160000000E+04, 2.7219593315E+01, 5.4065998776E+00, 1.0198479655E+01, 3.1274315689E+00, 9.4244793971E-01],
	[3.3165000000E+04, 2.7226531702E+01, 5.4066099313E+00, 1.0203488499E+01, 3.1279973986E+00, 9.4247539821E-01],
	[3.3170000000E+04, 2.7233470812E+01, 5.4066199834E+00, 1.0208499045E+01, 3.1285630931E+00, 9.4250284262E-01],
	[3.3175000000E+04, 2.7240410643E+01, 5.4066300341E+00, 1.0213511296E+01, 3.1291286523E+00, 9.4253027295E-01],
	[3.3180000000E+04, 2.7247351197E+01, 5.4066400833E+00, 1.0218525250E+01, 3.1296940762E+00, 9.4255768920E-01],
	[3.3185000000E+04, 2.7254292473E+01, 5.4066501310E+00, 1.0223540909E+01, 3.1302593650E+00, 9.4258509138E-01],
	[3.3190000000E+04, 2.7261234471E+01, 5.4066601772E+00, 1.0228558272E+01, 3.1308245185E+00, 9.4261247950E-01],
	[3.3195000000E+04, 2.7268177192E+01, 5.4066702219E+00, 1.0233577340E+01, 3.1313895367E+00, 9.4263985355E-01],
	[3.3200000000E+04, 2.7275120634E+01, 5.4066802651E+00, 1.0238598113E+01, 3.1319544198E+00, 9.4266721356E-01],
	[3.3205000000E+04, 2.7282064798E+01, 5.4066903068E+00, 1.0243620592E+01, 3.1325191676E+00, 9.4269455953E-01],
	[3.3210000000E+04, 2.7289009684E+01, 5.4067003470E+00, 1.0248644776E+01, 3.1330837801E+00, 9.4272189146E-01],
	[3.3215000000E+04, 2.7295955293E+01, 5.4067103858E+00, 1.0253670667E+01, 3.1336482575E+00, 9.4274920937E-01],
	[3.3220000000E+04, 2.7302901623E+01, 5.4067204230E+00, 1.0258698264E+01, 3.1342125996E+00, 9.4277651325E-01],
	[3.3225000000E+04, 2.7309848675E+01, 5.4067304588E+00, 1.0263727568E+01, 3.1347768066E+00, 9.4280380312E-01],
	[3.3230000000E+04, 2.7316796449E+01, 5.4067404930E+00, 1.0268758580E+01, 3.1353408783E+00, 9.4283107899E-01],
	[3.3235000000E+04, 2.7323744945E+01, 5.4067505258E+00, 1.0273791298E+01, 3.1359048148E+00, 9.4285834085E-01],
	[3.3240000000E+04, 2.7330694162E+01, 5.4067605570E+00, 1.0278825724E+01, 3.1364686161E+00, 9.4288558873E-01],
	[3.3245000000E+04, 2.7337644102E+01, 5.4067705868E+00, 1.0283861859E+01, 3.1370322822E+00, 9.4291282261E-01],
	[3.3250000000E+04, 2.7344594763E+01, 5.4067806151E+00, 1.0288899702E+01, 3.1375958131E+00, 9.4294004252E-01],
	[3.3255000000E+04, 2.7351546145E+01, 5.4067906419E+00, 1.0293939253E+01, 3.1381592088E+00, 9.4296724847E-01],
	[3.3260000000E+04, 2.7358498250E+01, 5.4068006672E+00, 1.0298980514E+01, 3.1387224693E+00, 9.4299444044E-01],
	[3.3265000000E+04, 2.7365451076E+01, 5.4068106910E+00, 1.0304023484E+01, 3.1392855946E+00, 9.4302161846E-01],
	[3.3270000000E+04, 2.7372404623E+01, 5.4068207134E+00, 1.0309068164E+01, 3.1398485847E+00, 9.4304878254E-01],
	[3.3275000000E+04, 2.7379358893E+01, 5.4068307342E+00, 1.0314114554E+01, 3.1404114397E+00, 9.4307593267E-01],
	[3.3280000000E+04, 2.7386313883E+01, 5.4068407536E+00, 1.0319162654E+01, 3.1409741595E+00, 9.4310306887E-01],
	[3.3285000000E+04, 2.7393269595E+01, 5.4068507715E+00, 1.0324212465E+01, 3.1415367441E+00, 9.4313019113E-01],
	[3.3290000000E+04, 2.7400226029E+01, 5.4068607878E+00, 1.0329263986E+01, 3.1420991935E+00, 9.4315729948E-01],
	[3.3295000000E+04, 2.7407183184E+01, 5.4068708027E+00, 1.0334317219E+01, 3.1426615077E+00, 9.4318439392E-01],
	[3.3300000000E+04, 2.7414141061E+01, 5.4068808162E+00, 1.0339372164E+01, 3.1432236868E+00, 9.4321147445E-01],
	[3.3305000000E+04, 2.7421099658E+01, 5.4068908281E+00, 1.0344428821E+01, 3.1437857308E+00, 9.4323854108E-01],
	[3.3310000000E+04, 2.7428058977E+01, 5.4069008385E+00, 1.0349487190E+01, 3.1443476395E+00, 9.4326559382E-01],
	[3.3315000000E+04, 2.7435019018E+01, 5.4069108475E+00, 1.0354547271E+01, 3.1449094131E+00, 9.4329263268E-01],
	[3.3320000000E+04, 2.7441979780E+01, 5.4069208550E+00, 1.0359609066E+01, 3.1454710516E+00, 9.4331965766E-01],
	[3.3325000000E+04, 2.7448941262E+01, 5.4069308610E+00, 1.0364672574E+01, 3.1460325549E+00, 9.4334666877E-01],
	[3.3330000000E+04, 2.7455903466E+01, 5.4069408655E+00, 1.0369737795E+01, 3.1465939231E+00, 9.4337366601E-01],
	[3.3335000000E+04, 2.7462866392E+01, 5.4069508685E+00, 1.0374804730E+01, 3.1471551562E+00, 9.4340064940E-01],
	[3.3340000000E+04, 2.7469830038E+01, 5.4069608701E+00, 1.0379873380E+01, 3.1477162541E+00, 9.4342761895E-01],
	[3.3345000000E+04, 2.7476794405E+01, 5.4069708701E+00, 1.0384943744E+01, 3.1482772168E+00, 9.4345457465E-01],
	[3.3350000000E+04, 2.7483759494E+01, 5.4069808687E+00, 1.0390015822E+01, 3.1488380445E+00, 9.4348151651E-01],
	[3.3355000000E+04, 2.7490725303E+01, 5.4069908658E+00, 1.0395089616E+01, 3.1493987370E+00, 9.4350844455E-01],
	[3.3360000000E+04, 2.7497691834E+01, 5.4070008615E+00, 1.0400165126E+01, 3.1499592944E+00, 9.4353535877E-01],
	[3.3365000000E+04, 2.7504659085E+01, 5.4070108556E+00, 1.0405242351E+01, 3.1505197167E+00, 9.4356225918E-01],
	[3.3370000000E+04, 2.7511627058E+01, 5.4070208483E+00, 1.0410321293E+01, 3.1510800039E+00, 9.4358914578E-01],
	[3.3375000000E+04, 2.7518595751E+01, 5.4070308395E+00, 1.0415401950E+01, 3.1516401559E+00, 9.4361601859E-01],
	[3.3380000000E+04, 2.7525565165E+01, 5.4070408292E+00, 1.0420484325E+01, 3.1522001729E+00, 9.4364287760E-01],
	[3.3385000000E+04, 2.7532535300E+01, 5.4070508174E+00, 1.0425568417E+01, 3.1527600548E+00, 9.4366972283E-01],
	[3.3390000000E+04, 2.7539506156E+01, 5.4070608042E+00, 1.0430654226E+01, 3.1533198016E+00, 9.4369655428E-01],
	[3.3395000000E+04, 2.7546477732E+01, 5.4070707895E+00, 1.0435741753E+01, 3.1538794132E+00, 9.4372337196E-01],
	[3.3400000000E+04, 2.7553450029E+01, 5.4070807733E+00, 1.0440830998E+01, 3.1544388898E+00, 9.4375017588E-01],
	[3.3405000000E+04, 2.7560423047E+01, 5.4070907556E+00, 1.0445921962E+01, 3.1549982314E+00, 9.4377696605E-01],
	[3.3410000000E+04, 2.7567396785E+01, 5.4071007364E+00, 1.0451014644E+01, 3.1555574378E+00, 9.4380374246E-01],
	[3.3415000000E+04, 2.7574371245E+01, 5.4071107158E+00, 1.0456109045E+01, 3.1561165092E+00, 9.4383050514E-01],
	[3.3420000000E+04, 2.7581346424E+01, 5.4071206937E+00, 1.0461205166E+01, 3.1566754455E+00, 9.4385725408E-01],
	[3.3425000000E+04, 2.7588322325E+01, 5.4071306701E+00, 1.0466303006E+01, 3.1572342467E+00, 9.4388398929E-01],
	[3.3430000000E+04, 2.7595298945E+01, 5.4071406451E+00, 1.0471402566E+01, 3.1577929129E+00, 9.4391071079E-01],
	[3.3435000000E+04, 2.7602276287E+01, 5.4071506186E+00, 1.0476503847E+01, 3.1583514440E+00, 9.4393741857E-01],
	[3.3440000000E+04, 2.7609254348E+01, 5.4071605906E+00, 1.0481606848E+01, 3.1589098401E+00, 9.4396411264E-01],
	[3.3445000000E+04, 2.7616233130E+01, 5.4071705611E+00, 1.0486711571E+01, 3.1594681011E+00, 9.4399079302E-01],
	[3.3450000000E+04, 2.7623233076E+01, 5.4071832866E+00, 1.0491818014E+01, 3.1600274361E+00, 9.4401745971E-01],
	[3.3455000000E+04, 2.7630234715E+01, 5.4071961403E+00, 1.0496926179E+01, 3.1605866936E+00, 9.4404411271E-01],
	[3.3460000000E+04, 2.7637237081E+01, 5.4072089922E+00, 1.0502036067E+01, 3.1611458167E+00, 9.4407075204E-01],
	[3.3465000000E+04, 2.7644240176E+01, 5.4072218421E+00, 1.0507147676E+01, 3.1617048053E+00, 9.4409737770E-01],
	[3.3470000000E+04, 2.7651243998E+01, 5.4072346902E+00, 1.0512261008E+01, 3.1622636594E+00, 9.4412398969E-01],
	[3.3475000000E+04, 2.7658248549E+01, 5.4072475364E+00, 1.0517376063E+01, 3.1628223791E+00, 9.4415058803E-01],
	[3.3480000000E+04, 2.7665253827E+01, 5.4072603807E+00, 1.0522492841E+01, 3.1633809644E+00, 9.4417717272E-01],
	[3.3485000000E+04, 2.7672259832E+01, 5.4072732231E+00, 1.0527611343E+01, 3.1639394151E+00, 9.4420374377E-01],
	[3.3490000000E+04, 2.7679266566E+01, 5.4072860636E+00, 1.0532731569E+01, 3.1644977315E+00, 9.4423030119E-01],
	[3.3495000000E+04, 2.7686274027E+01, 5.4072989022E+00, 1.0537853518E+01, 3.1650559134E+00, 9.4425684498E-01],
	[3.3500000000E+04, 2.7693282217E+01, 5.4073117390E+00, 1.0542977193E+01, 3.1656139608E+00, 9.4428337515E-01],
	[3.3505000000E+04, 2.7700291133E+01, 5.4073245738E+00, 1.0548102592E+01, 3.1661718739E+00, 9.4430989171E-01],
	[3.3510000000E+04, 2.7707300778E+01, 5.4073374068E+00, 1.0553229716E+01, 3.1667296525E+00, 9.4433639466E-01],
	[3.3515000000E+04, 2.7714311149E+01, 5.4073502379E+00, 1.0558358566E+01, 3.1672872967E+00, 9.4436288401E-01],
	[3.3520000000E+04, 2.7721322249E+01, 5.4073630671E+00, 1.0563489142E+01, 3.1678448065E+00, 9.4438935977E-01],
	[3.3525000000E+04, 2.7728334076E+01, 5.4073758944E+00, 1.0568621444E+01, 3.1684021818E+00, 9.4441582195E-01],
	[3.3530000000E+04, 2.7735346630E+01, 5.4073887198E+00, 1.0573755472E+01, 3.1689594228E+00, 9.4444227056E-01],
	[3.3535000000E+04, 2.7742359912E+01, 5.4074015434E+00, 1.0578891227E+01, 3.1695165294E+00, 9.4446870559E-01],
	[3.3540000000E+04, 2.7749373922E+01, 5.4074143651E+00, 1.0584028709E+01, 3.1700735015E+00, 9.4449512706E-01],
	[3.3545000000E+04, 2.7756388658E+01, 5.4074271849E+00, 1.0589167919E+01, 3.1706303393E+00, 9.4452153497E-01],
	[3.3550000000E+04, 2.7763404123E+01, 5.4074400028E+00, 1.0594308856E+01, 3.1711870427E+00, 9.4454792934E-01],
	[3.3555000000E+04, 2.7770420314E+01, 5.4074528188E+00, 1.0599451521E+01, 3.1717436117E+00, 9.4457431016E-01],
	[3.3560000000E+04, 2.7777437233E+01, 5.4074656330E+00, 1.0604595915E+01, 3.1723000464E+00, 9.4460067745E-01],
	[3.3565000000E+04, 2.7784454879E+01, 5.4074784452E+00, 1.0609742038E+01, 3.1728563466E+00, 9.4462703121E-01],
	[3.3570000000E+04, 2.7791473252E+01, 5.4074912556E+00, 1.0614889889E+01, 3.1734125125E+00, 9.4465337146E-01],
	[3.3575000000E+04, 2.7798492352E+01, 5.4075040642E+00, 1.0620039470E+01, 3.1739685441E+00, 9.4467969819E-01],
	[3.3580000000E+04, 2.7805512180E+01, 5.4075168708E+00, 1.0625190781E+01, 3.1745244413E+00, 9.4470601141E-01],
	[3.3585000000E+04, 2.7812532735E+01, 5.4075296756E+00, 1.0630343822E+01, 3.1750802041E+00, 9.4473231114E-01],
	[3.3590000000E+04, 2.7819554016E+01, 5.4075424785E+00, 1.0635498593E+01, 3.1756358327E+00, 9.4475859738E-01],
	[3.3595000000E+04, 2.7826576025E+01, 5.4075552795E+00, 1.0640655094E+01, 3.1761913268E+00, 9.4478487013E-01],
	[3.3600000000E+04, 2.7833598761E+01, 5.4075680786E+00, 1.0645813327E+01, 3.1767466867E+00, 9.4481112940E-01],
	[3.3605000000E+04, 2.7840622224E+01, 5.4075808759E+00, 1.0650973291E+01, 3.1773019122E+00, 9.4483737520E-01],
	[3.3610000000E+04, 2.7847646414E+01, 5.4075936713E+00, 1.0656134986E+01, 3.1778570034E+00, 9.4486360754E-01],
	[3.3615000000E+04, 2.7854671331E+01, 5.4076064648E+00, 1.0661298414E+01, 3.1784119603E+00, 9.4488982644E-01],
	[3.3620000000E+04, 2.7861696974E+01, 5.4076192564E+00, 1.0666463574E+01, 3.1789667828E+00, 9.4491603191E-01],
	[3.3625000000E+04, 2.7868723345E+01, 5.4076320462E+00, 1.0671630466E+01, 3.1795214711E+00, 9.4494222397E-01],
	[3.3630000000E+04, 2.7875750442E+01, 5.4076448341E+00, 1.0676799091E+01, 3.1800760251E+00, 9.4496840262E-01],
	[3.3635000000E+04, 2.7882778266E+01, 5.4076576202E+00, 1.0681969450E+01, 3.1806304447E+00, 9.4499456786E-01],
	[3.3640000000E+04, 2.7889806817E+01, 5.4076704043E+00, 1.0687141542E+01, 3.1811847301E+00, 9.4502071970E-01],
	[3.3645000000E+04, 2.7896836095E+01, 5.4076831866E+00, 1.0692315368E+01, 3.1817388812E+00, 9.4504685815E-01],
	[3.3650000000E+04, 2.7903866099E+01, 5.4076959670E+00, 1.0697490928E+01, 3.1822928981E+00, 9.4507298321E-01],
	[3.3655000000E+04, 2.7910896830E+01, 5.4077087456E+00, 1.0702668223E+01, 3.1828467807E+00, 9.4509909490E-01],
	[3.3660000000E+04, 2.7917928288E+01, 5.4077215223E+00, 1.0707847252E+01, 3.1834005290E+00, 9.4512519321E-01],
	[3.3665000000E+04, 2.7924960472E+01, 5.4077342971E+00, 1.0713028017E+01, 3.1839541430E+00, 9.4515127815E-01],
	[3.3670000000E+04, 2.7931993383E+01, 5.4077470701E+00, 1.0718210517E+01, 3.1845076228E+00, 9.4517734973E-01],
	[3.3675000000E+04, 2.7939027021E+01, 5.4077598411E+00, 1.0723394753E+01, 3.1850609683E+00, 9.4520340796E-01],
	[3.3680000000E+04, 2.7946061384E+01, 5.4077726104E+00, 1.0728580725E+01, 3.1856141797E+00, 9.4522945284E-01],
	[3.3685000000E+04, 2.7953096475E+01, 5.4077853777E+00, 1.0733768434E+01, 3.1861672567E+00, 9.4525548438E-01],
	[3.3690000000E+04, 2.7960132292E+01, 5.4077981432E+00, 1.0738957880E+01, 3.1867201996E+00, 9.4528150258E-01],
	[3.3695000000E+04, 2.7967168835E+01, 5.4078109068E+00, 1.0744149062E+01, 3.1872730082E+00, 9.4530750745E-01],
	[3.3700000000E+04, 2.7974206104E+01, 5.4078236686E+00, 1.0749341982E+01, 3.1878256826E+00, 9.4533349900E-01],
	[3.3705000000E+04, 2.7981244100E+01, 5.4078364285E+00, 1.0754536640E+01, 3.1883782228E+00, 9.4535947724E-01],
	[3.3710000000E+04, 2.7988282822E+01, 5.4078491865E+00, 1.0759733036E+01, 3.1889306288E+00, 9.4538544216E-01],
	[3.3715000000E+04, 2.7995322271E+01, 5.4078619427E+00, 1.0764931170E+01, 3.1894829006E+00, 9.4541139378E-01],
	[3.3720000000E+04, 2.8002362446E+01, 5.4078746970E+00, 1.0770131043E+01, 3.1900350383E+00, 9.4543733210E-01],
	[3.3725000000E+04, 2.8009403347E+01, 5.4078874495E+00, 1.0775332655E+01, 3.1905870417E+00, 9.4546325713E-01],
	[3.3730000000E+04, 2.8016444974E+01, 5.4079002001E+00, 1.0780536006E+01, 3.1911389110E+00, 9.4548916887E-01],
	[3.3735000000E+04, 2.8023487327E+01, 5.4079129488E+00, 1.0785741097E+01, 3.1916906460E+00, 9.4551506733E-01],
	[3.3740000000E+04, 2.8030530406E+01, 5.4079256957E+00, 1.0790947929E+01, 3.1922422470E+00, 9.4554095253E-01],
	[3.3745000000E+04, 2.8037574212E+01, 5.4079384407E+00, 1.0796156500E+01, 3.1927937137E+00, 9.4556682445E-01],
	[3.3750000000E+04, 2.8044618743E+01, 5.4079511838E+00, 1.0801366812E+01, 3.1933450463E+00, 9.4559268311E-01],
	[3.3755000000E+04, 2.8051664001E+01, 5.4079639251E+00, 1.0806578865E+01, 3.1938962448E+00, 9.4561852853E-01],
	[3.3760000000E+04, 2.8058709984E+01, 5.4079766646E+00, 1.0811792660E+01, 3.1944473091E+00, 9.4564436069E-01],
	[3.3765000000E+04, 2.8065756694E+01, 5.4079894021E+00, 1.0817008196E+01, 3.1949982393E+00, 9.4567017961E-01],
	[3.3770000000E+04, 2.8072804129E+01, 5.4080021379E+00, 1.0822225474E+01, 3.1955490354E+00, 9.4569598530E-01],
	[3.3775000000E+04, 2.8079852290E+01, 5.4080148717E+00, 1.0827444494E+01, 3.1960996973E+00, 9.4572177775E-01],
	[3.3780000000E+04, 2.8086901177E+01, 5.4080276038E+00, 1.0832665257E+01, 3.1966502252E+00, 9.4574755699E-01],
	[3.3785000000E+04, 2.8093950790E+01, 5.4080403339E+00, 1.0837887763E+01, 3.1972006189E+00, 9.4577332301E-01],
	[3.3790000000E+04, 2.8101001129E+01, 5.4080530622E+00, 1.0843112012E+01, 3.1977508785E+00, 9.4579907582E-01],
	[3.3795000000E+04, 2.8108052193E+01, 5.4080657887E+00, 1.0848338005E+01, 3.1983010041E+00, 9.4582481542E-01],
	[3.3800000000E+04, 2.8115103983E+01, 5.4080785133E+00, 1.0853565742E+01, 3.1988509955E+00, 9.4585054183E-01],
	[3.3805000000E+04, 2.8122156499E+01, 5.4080912360E+00, 1.0858795222E+01, 3.1994008529E+00, 9.4587625505E-01],
	[3.3810000000E+04, 2.8129209740E+01, 5.4081039569E+00, 1.0864026448E+01, 3.1999505762E+00, 9.4590195508E-01],
	[3.3815000000E+04, 2.8136263707E+01, 5.4081166760E+00, 1.0869259418E+01, 3.2005001655E+00, 9.4592764194E-01],
	[3.3820000000E+04, 2.8143318400E+01, 5.4081293932E+00, 1.0874494133E+01, 3.2010496207E+00, 9.4595331562E-01],
	[3.3825000000E+04, 2.8150373818E+01, 5.4081421085E+00, 1.0879730594E+01, 3.2015989418E+00, 9.4597897614E-01],
	[3.3830000000E+04, 2.8157429962E+01, 5.4081548220E+00, 1.0884968801E+01, 3.2021481289E+00, 9.4600462350E-01],
	[3.3835000000E+04, 2.8164486831E+01, 5.4081675337E+00, 1.0890208754E+01, 3.2026971819E+00, 9.4603025770E-01],
	[3.3840000000E+04, 2.8171544426E+01, 5.4081802435E+00, 1.0895450453E+01, 3.2032461010E+00, 9.4605587876E-01],
	[3.3845000000E+04, 2.8178602746E+01, 5.4081929514E+00, 1.0900693900E+01, 3.2037948860E+00, 9.4608148668E-01],
	[3.3850000000E+04, 2.8185661791E+01, 5.4082056575E+00, 1.0905939093E+01, 3.2043435369E+00, 9.4610708146E-01],
	[3.3855000000E+04, 2.8192721562E+01, 5.4082183618E+00, 1.0911186034E+01, 3.2048920539E+00, 9.4613266312E-01],
	[3.3860000000E+04, 2.8199782058E+01, 5.4082310642E+00, 1.0916434722E+01, 3.2054404369E+00, 9.4615823165E-01],
	[3.3865000000E+04, 2.8206843280E+01, 5.4082437648E+00, 1.0921685159E+01, 3.2059886859E+00, 9.4618378707E-01],
	[3.3870000000E+04, 2.8213905227E+01, 5.4082564635E+00, 1.0926937344E+01, 3.2065368009E+00, 9.4620932938E-01],
	[3.3875000000E+04, 2.8220967899E+01, 5.4082691604E+00, 1.0932191278E+01, 3.2070847819E+00, 9.4623485859E-01],
	[3.3880000000E+04, 2.8228031296E+01, 5.4082818554E+00, 1.0937446961E+01, 3.2076326290E+00, 9.4626037470E-01],
	[3.3885000000E+04, 2.8235095418E+01, 5.4082945486E+00, 1.0942704394E+01, 3.2081803420E+00, 9.4628587772E-01],
	[3.3890000000E+04, 2.8242160265E+01, 5.4083072399E+00, 1.0947963576E+01, 3.2087279212E+00, 9.4631136766E-01],
	[3.3895000000E+04, 2.8249225838E+01, 5.4083199294E+00, 1.0953224508E+01, 3.2092753663E+00, 9.4633684452E-01],
	[3.3900000000E+04, 2.8256292136E+01, 5.4083326171E+00, 1.0958487190E+01, 3.2098226776E+00, 9.4636230831E-01],
	[3.3905000000E+04, 2.8263359158E+01, 5.4083453029E+00, 1.0963751623E+01, 3.2103698549E+00, 9.4638775903E-01],
	[3.3910000000E+04, 2.8270426906E+01, 5.4083579869E+00, 1.0969017808E+01, 3.2109168982E+00, 9.4641319670E-01],
	[3.3915000000E+04, 2.8277495378E+01, 5.4083706690E+00, 1.0974285743E+01, 3.2114638077E+00, 9.4643862132E-01],
	[3.3920000000E+04, 2.8284564576E+01, 5.4083833493E+00, 1.0979555430E+01, 3.2120105832E+00, 9.4646403288E-01],
	[3.3925000000E+04, 2.8291634498E+01, 5.4083960278E+00, 1.0984826869E+01, 3.2125572249E+00, 9.4648943141E-01],
	[3.3930000000E+04, 2.8298705146E+01, 5.4084087044E+00, 1.0990100061E+01, 3.2131037326E+00, 9.4651481691E-01],
	[3.3935000000E+04, 2.8305776518E+01, 5.4084213792E+00, 1.0995375005E+01, 3.2136501065E+00, 9.4654018938E-01],
	[3.3940000000E+04, 2.8312848615E+01, 5.4084340521E+00, 1.1000651702E+01, 3.2141963464E+00, 9.4656554883E-01],
	[3.3945000000E+04, 2.8319921436E+01, 5.4084467232E+00, 1.1005930152E+01, 3.2147424525E+00, 9.4659089526E-01],
	[3.3950000000E+04, 2.8326994983E+01, 5.4084593925E+00, 1.1011210356E+01, 3.2152884247E+00, 9.4661622869E-01],
	[3.3955000000E+04, 2.8334069254E+01, 5.4084720599E+00, 1.1016492314E+01, 3.2158342631E+00, 9.4664154912E-01],
	[3.3960000000E+04, 2.8341144250E+01, 5.4084847255E+00, 1.1021776026E+01, 3.2163799676E+00, 9.4666685655E-01],
	[3.3965000000E+04, 2.8348219970E+01, 5.4084973893E+00, 1.1027061493E+01, 3.2169255383E+00, 9.4669215099E-01],
	[3.3970000000E+04, 2.8355296415E+01, 5.4085100512E+00, 1.1032348715E+01, 3.2174709752E+00, 9.4671743245E-01],
	[3.3975000000E+04, 2.8362373585E+01, 5.4085227113E+00, 1.1037637692E+01, 3.2180162782E+00, 9.4674270093E-01],
	[3.3980000000E+04, 2.8369451479E+01, 5.4085353696E+00, 1.1042928424E+01, 3.2185614474E+00, 9.4676795645E-01],
	[3.3985000000E+04, 2.8376535819E+01, 5.4085487907E+00, 1.1048220912E+01, 3.2191068273E+00, 9.4679319900E-01],
	[3.3990000000E+04, 2.8383636322E+01, 5.4085642732E+00, 1.1053515157E+01, 3.2196530034E+00, 9.4681842859E-01],
	[3.3995000000E+04, 2.8390737558E+01, 5.4085797535E+00, 1.1058811157E+01, 3.2201990462E+00, 9.4684364523E-01],
	[3.4000000000E+04, 2.8397839526E+01, 5.4085952316E+00, 1.1064108915E+01, 3.2207449557E+00, 9.4686884893E-01],
	[3.4005000000E+04, 2.8404942225E+01, 5.4086107074E+00, 1.1069408430E+01, 3.2212907320E+00, 9.4689403969E-01],
	[3.4010000000E+04, 2.8412045656E+01, 5.4086261810E+00, 1.1074709703E+01, 3.2218363751E+00, 9.4691921751E-01],
	[3.4015000000E+04, 2.8419149819E+01, 5.4086416524E+00, 1.1080012733E+01, 3.2223818850E+00, 9.4694438242E-01],
	[3.4020000000E+04, 2.8426254714E+01, 5.4086571215E+00, 1.1085317521E+01, 3.2229272616E+00, 9.4696953440E-01],
	[3.4025000000E+04, 2.8433360341E+01, 5.4086725884E+00, 1.1090624068E+01, 3.2234725050E+00, 9.4699467347E-01],
	[3.4030000000E+04, 2.8440466699E+01, 5.4086880531E+00, 1.1095932374E+01, 3.2240176152E+00, 9.4701979963E-01],
	[3.4035000000E+04, 2.8447573789E+01, 5.4087035155E+00, 1.1101242438E+01, 3.2245625922E+00, 9.4704491290E-01],
	[3.4040000000E+04, 2.8454681610E+01, 5.4087189757E+00, 1.1106554262E+01, 3.2251074360E+00, 9.4707001326E-01],
	[3.4045000000E+04, 2.8461790163E+01, 5.4087344337E+00, 1.1111867846E+01, 3.2256521467E+00, 9.4709510075E-01],
	[3.4050000000E+04, 2.8468899448E+01, 5.4087498895E+00, 1.1117183190E+01, 3.2261967242E+00, 9.4712017535E-01],
	[3.4055000000E+04, 2.8476009464E+01, 5.4087653430E+00, 1.1122500295E+01, 3.2267411685E+00, 9.4714523707E-01],
	[3.4060000000E+04, 2.8483120211E+01, 5.4087807944E+00, 1.1127819160E+01, 3.2272854796E+00, 9.4717028593E-01],
	[3.4065000000E+04, 2.8490231690E+01, 5.4087962434E+00, 1.1133139786E+01, 3.2278296576E+00, 9.4719532192E-01],
	[3.4070000000E+04, 2.8497343901E+01, 5.4088116903E+00, 1.1138462173E+01, 3.2283737025E+00, 9.4722034506E-01],
	[3.4075000000E+04, 2.8504456843E+01, 5.4088271350E+00, 1.1143786323E+01, 3.2289176143E+00, 9.4724535535E-01],
	[3.4080000000E+04, 2.8511570516E+01, 5.4088425774E+00, 1.1149112234E+01, 3.2294613929E+00, 9.4727035280E-01],
	[3.4085000000E+04, 2.8518684920E+01, 5.4088580176E+00, 1.1154439907E+01, 3.2300050384E+00, 9.4729533741E-01],
	[3.4090000000E+04, 2.8525800056E+01, 5.4088734556E+00, 1.1159769344E+01, 3.2305485508E+00, 9.4732030919E-01],
	[3.4095000000E+04, 2.8532915923E+01, 5.4088888913E+00, 1.1165100543E+01, 3.2310919301E+00, 9.4734526814E-01],
	[3.4100000000E+04, 2.8540032522E+01, 5.4089043249E+00, 1.1170433505E+01, 3.2316351763E+00, 9.4737021428E-01],
	[3.4105000000E+04, 2.8547149851E+01, 5.4089197562E+00, 1.1175768232E+01, 3.2321782894E+00, 9.4739514760E-01],
	[3.4110000000E+04, 2.8554267912E+01, 5.4089351853E+00, 1.1181104722E+01, 3.2327212695E+00, 9.4742006812E-01],
	[3.4115000000E+04, 2.8561386704E+01, 5.4089506122E+00, 1.1186442976E+01, 3.2332641165E+00, 9.4744497585E-01],
	[3.4120000000E+04, 2.8568506227E+01, 5.4089660369E+00, 1.1191782995E+01, 3.2338068304E+00, 9.4746987077E-01],
	[3.4125000000E+04, 2.8575626481E+01, 5.4089814593E+00, 1.1197124779E+01, 3.2343494113E+00, 9.4749475292E-01],
	[3.4130000000E+04, 2.8582747466E+01, 5.4089968796E+00, 1.1202468328E+01, 3.2348918592E+00, 9.4751962228E-01],
	[3.4135000000E+04, 2.8589869182E+01, 5.4090122976E+00, 1.1207813643E+01, 3.2354341740E+00, 9.4754447887E-01],
	[3.4140000000E+04, 2.8596991629E+01, 5.4090277134E+00, 1.1213160724E+01, 3.2359763558E+00, 9.4756932269E-01],
	[3.4145000000E+04, 2.8604114807E+01, 5.4090431270E+00, 1.1218509571E+01, 3.2365184046E+00, 9.4759415375E-01],
	[3.4150000000E+04, 2.8611238716E+01, 5.4090585384E+00, 1.1223860185E+01, 3.2370603204E+00, 9.4761897206E-01],
	[3.4155000000E+04, 2.8618363355E+01, 5.4090739476E+00, 1.1229212565E+01, 3.2376021032E+00, 9.4764377762E-01],
	[3.4160000000E+04, 2.8625488726E+01, 5.4090893545E+00, 1.1234566713E+01, 3.2381437530E+00, 9.4766857043E-01],
	[3.4165000000E+04, 2.8632614827E+01, 5.4091047593E+00, 1.1239922628E+01, 3.2386852698E+00, 9.4769335051E-01],
	[3.4170000000E+04, 2.8639741659E+01, 5.4091201618E+00, 1.1245280311E+01, 3.2392266537E+00, 9.4771811787E-01],
	[3.4175000000E+04, 2.8646869222E+01, 5.4091355621E+00, 1.1250639762E+01, 3.2397679046E+00, 9.4774287249E-01],
	[3.4180000000E+04, 2.8653997516E+01, 5.4091509603E+00, 1.1256000981E+01, 3.2403090226E+00, 9.4776761441E-01],
	[3.4185000000E+04, 2.8661126540E+01, 5.4091663562E+00, 1.1261363970E+01, 3.2408500076E+00, 9.4779234361E-01],
	[3.4190000000E+04, 2.8668256295E+01, 5.4091817499E+00, 1.1266728728E+01, 3.2413908597E+00, 9.4781706011E-01],
	[3.4195000000E+04, 2.8675386781E+01, 5.4091971414E+00, 1.1272095255E+01, 3.2419315789E+00, 9.4784176391E-01],
	[3.4200000000E+04, 2.8682517997E+01, 5.4092125307E+00, 1.1277463552E+01, 3.2424721652E+00, 9.4786645502E-01],
	[3.4205000000E+04, 2.8689649944E+01, 5.4092279177E+00, 1.1282833619E+01, 3.2430126185E+00, 9.4789113344E-01],
	[3.4210000000E+04, 2.8696782621E+01, 5.4092433026E+00, 1.1288205456E+01, 3.2435529390E+00, 9.4791579919E-01],
	[3.4215000000E+04, 2.8703916029E+01, 5.4092586853E+00, 1.1293579064E+01, 3.2440931265E+00, 9.4794045226E-01],
	[3.4220000000E+04, 2.8711050167E+01, 5.4092740658E+00, 1.1298954444E+01, 3.2446331812E+00, 9.4796509267E-01],
	[3.4225000000E+04, 2.8718185036E+01, 5.4092894440E+00, 1.1304331594E+01, 3.2451731031E+00, 9.4798972042E-01],
	[3.4230000000E+04, 2.8725320635E+01, 5.4093048201E+00, 1.1309710517E+01, 3.2457128920E+00, 9.4801433552E-01],
	[3.4235000000E+04, 2.8732456964E+01, 5.4093201940E+00, 1.1315091211E+01, 3.2462525482E+00, 9.4803893797E-01],
	[3.4240000000E+04, 2.8739594024E+01, 5.4093355656E+00, 1.1320473678E+01, 3.2467920714E+00, 9.4806352777E-01],
	[3.4245000000E+04, 2.8746731814E+01, 5.4093509351E+00, 1.1325857918E+01, 3.2473314619E+00, 9.4808810495E-01],
	[3.4250000000E+04, 2.8753870334E+01, 5.4093663023E+00, 1.1331243931E+01, 3.2478707195E+00, 9.4811266950E-01],
	[3.4255000000E+04, 2.8761009585E+01, 5.4093816674E+00, 1.1336631717E+01, 3.2484098443E+00, 9.4813722142E-01],
	[3.4260000000E+04, 2.8768149566E+01, 5.4093970302E+00, 1.1342021277E+01, 3.2489488364E+00, 9.4816176073E-01],
	[3.4265000000E+04, 2.8775290277E+01, 5.4094123909E+00, 1.1347412610E+01, 3.2494876956E+00, 9.4818628743E-01],
	[3.4270000000E+04, 2.8782431718E+01, 5.4094277494E+00, 1.1352805719E+01, 3.2500264220E+00, 9.4821080153E-01],
	[3.4275000000E+04, 2.8789573889E+01, 5.4094431056E+00, 1.1358200601E+01, 3.2505650157E+00, 9.4823530303E-01],
	[3.4280000000E+04, 2.8796716790E+01, 5.4094584597E+00, 1.1363597259E+01, 3.2511034766E+00, 9.4825979195E-01],
	[3.4285000000E+04, 2.8803860422E+01, 5.4094738116E+00, 1.1368995692E+01, 3.2516418047E+00, 9.4828426828E-01],
	[3.4290000000E+04, 2.8811004783E+01, 5.4094891613E+00, 1.1374395901E+01, 3.2521800001E+00, 9.4830873203E-01],
	[3.4295000000E+04, 2.8818149874E+01, 5.4095045088E+00, 1.1379797885E+01, 3.2527180628E+00, 9.4833318321E-01],
	[3.4300000000E+04, 2.8825295696E+01, 5.4095198540E+00, 1.1385201646E+01, 3.2532559927E+00, 9.4835762183E-01],
	[3.4305000000E+04, 2.8832442247E+01, 5.4095351971E+00, 1.1390607184E+01, 3.2537937900E+00, 9.4838204789E-01],
	[3.4310000000E+04, 2.8839589528E+01, 5.4095505380E+00, 1.1396014498E+01, 3.2543314545E+00, 9.4840646139E-01],
	[3.4315000000E+04, 2.8846737539E+01, 5.4095658768E+00, 1.1401423590E+01, 3.2548689863E+00, 9.4843086236E-01],
	[3.4320000000E+04, 2.8853886280E+01, 5.4095812133E+00, 1.1406834459E+01, 3.2554063854E+00, 9.4845525078E-01],
	[3.4325000000E+04, 2.8861035750E+01, 5.4095965476E+00, 1.1412247107E+01, 3.2559436519E+00, 9.4847962667E-01],
	[3.4330000000E+04, 2.8868185951E+01, 5.4096118798E+00, 1.1417661532E+01, 3.2564807857E+00, 9.4850399003E-01],
	[3.4335000000E+04, 2.8875336881E+01, 5.4096272097E+00, 1.1423077736E+01, 3.2570177868E+00, 9.4852834088E-01],
	[3.4340000000E+04, 2.8882488540E+01, 5.4096425375E+00, 1.1428495719E+01, 3.2575546553E+00, 9.4855267921E-01],
	[3.4345000000E+04, 2.8889640930E+01, 5.4096578630E+00, 1.1433915481E+01, 3.2580913911E+00, 9.4857700503E-01],
	[3.4350000000E+04, 2.8896794049E+01, 5.4096731864E+00, 1.1439337023E+01, 3.2586279944E+00, 9.4860131835E-01],
	[3.4355000000E+04, 2.8903947897E+01, 5.4096885076E+00, 1.1444760344E+01, 3.2591644650E+00, 9.4862561918E-01],
	[3.4360000000E+04, 2.8911102476E+01, 5.4097038266E+00, 1.1450185446E+01, 3.2597008030E+00, 9.4864990751E-01],
	[3.4365000000E+04, 2.8918257783E+01, 5.4097191435E+00, 1.1455612328E+01, 3.2602370084E+00, 9.4867418337E-01],
	[3.4370000000E+04, 2.8925413821E+01, 5.4097344581E+00, 1.1461040991E+01, 3.2607730812E+00, 9.4869844675E-01],
	[3.4375000000E+04, 2.8932570587E+01, 5.4097497706E+00, 1.1466471435E+01, 3.2613090214E+00, 9.4872269766E-01],
	[3.4380000000E+04, 2.8939728084E+01, 5.4097650809E+00, 1.1471903661E+01, 3.2618448291E+00, 9.4874693611E-01],
	[3.4385000000E+04, 2.8946886309E+01, 5.4097803889E+00, 1.1477337668E+01, 3.2623805042E+00, 9.4877116210E-01],
	[3.4390000000E+04, 2.8954045264E+01, 5.4097956949E+00, 1.1482773458E+01, 3.2629160467E+00, 9.4879537564E-01],
	[3.4395000000E+04, 2.8961204948E+01, 5.4098109986E+00, 1.1488211030E+01, 3.2634514567E+00, 9.4881957674E-01],
	[3.4400000000E+04, 2.8968365362E+01, 5.4098263001E+00, 1.1493650384E+01, 3.2639867342E+00, 9.4884376539E-01],
	[3.4405000000E+04, 2.8975526505E+01, 5.4098415995E+00, 1.1499091522E+01, 3.2645218792E+00, 9.4886794162E-01],
	[3.4410000000E+04, 2.8982688377E+01, 5.4098568967E+00, 1.1504534443E+01, 3.2650568917E+00, 9.4889210542E-01],
	[3.4415000000E+04, 2.8989850979E+01, 5.4098721917E+00, 1.1509979149E+01, 3.2655917716E+00, 9.4891625681E-01],
	[3.4420000000E+04, 2.8997014309E+01, 5.4098874845E+00, 1.1515425638E+01, 3.2661265191E+00, 9.4894039578E-01],
	[3.4425000000E+04, 2.9004178369E+01, 5.4099027752E+00, 1.1520873911E+01, 3.2666611342E+00, 9.4896452234E-01],
	[3.4430000000E+04, 2.9011343158E+01, 5.4099180636E+00, 1.1526323969E+01, 3.2671956167E+00, 9.4898863651E-01],
	[3.4435000000E+04, 2.9018508676E+01, 5.4099333499E+00, 1.1531775813E+01, 3.2677299668E+00, 9.4901273828E-01],
	[3.4440000000E+04, 2.9025674923E+01, 5.4099486340E+00, 1.1537229441E+01, 3.2682641844E+00, 9.4903682766E-01],
	[3.4445000000E+04, 2.9032841899E+01, 5.4099639160E+00, 1.1542684856E+01, 3.2687982697E+00, 9.4906090466E-01],
	[3.4450000000E+04, 2.9040009604E+01, 5.4099791958E+00, 1.1548142056E+01, 3.2693322225E+00, 9.4908496929E-01],
	[3.4455000000E+04, 2.9047178038E+01, 5.4099944734E+00, 1.1553601043E+01, 3.2698660428E+00, 9.4910902155E-01],
	[3.4460000000E+04, 2.9054347201E+01, 5.4100097488E+00, 1.1559061816E+01, 3.2703997308E+00, 9.4913306145E-01],
	[3.4465000000E+04, 2.9061517093E+01, 5.4100250220E+00, 1.1564524376E+01, 3.2709332864E+00, 9.4915708899E-01],
	[3.4470000000E+04, 2.9068687713E+01, 5.4100402931E+00, 1.1569988724E+01, 3.2714667096E+00, 9.4918110419E-01],
	[3.4475000000E+04, 2.9075859063E+01, 5.4100555620E+00, 1.1575454859E+01, 3.2720000005E+00, 9.4920510704E-01],
	[3.4480000000E+04, 2.9083031141E+01, 5.4100708287E+00, 1.1580922783E+01, 3.2725331589E+00, 9.4922909755E-01],
	[3.4485000000E+04, 2.9090203948E+01, 5.4100860933E+00, 1.1586392494E+01, 3.2730661851E+00, 9.4925307574E-01],
	[3.4490000000E+04, 2.9097377484E+01, 5.4101013557E+00, 1.1591863994E+01, 3.2735990789E+00, 9.4927704160E-01],
	[3.4495000000E+04, 2.9104551749E+01, 5.4101166159E+00, 1.1597337284E+01, 3.2741318403E+00, 9.4930099514E-01],
	[3.4500000000E+04, 2.9111726742E+01, 5.4101318740E+00, 1.1602812362E+01, 3.2746644695E+00, 9.4932493637E-01],
	[3.4505000000E+04, 2.9118902464E+01, 5.4101471298E+00, 1.1608289230E+01, 3.2751969663E+00, 9.4934886530E-01],
	[3.4510000000E+04, 2.9126078915E+01, 5.4101623836E+00, 1.1613767888E+01, 3.2757293309E+00, 9.4937278193E-01],
	[3.4515000000E+04, 2.9133256094E+01, 5.4101776351E+00, 1.1619248336E+01, 3.2762615631E+00, 9.4939668626E-01],
	[3.4520000000E+04, 2.9140434001E+01, 5.4101928845E+00, 1.1624730575E+01, 3.2767936631E+00, 9.4942057831E-01],
	[3.4525000000E+04, 2.9147612638E+01, 5.4102081317E+00, 1.1630214605E+01, 3.2773256309E+00, 9.4944445808E-01],
	[3.4530000000E+04, 2.9154792002E+01, 5.4102233768E+00, 1.1635700425E+01, 3.2778574663E+00, 9.4946832558E-01],
	[3.4535000000E+04, 2.9161989910E+01, 5.4102409812E+00, 1.1641188038E+01, 3.2783902619E+00, 9.4949218081E-01],
	[3.4540000000E+04, 2.9169191640E+01, 5.4102589924E+00, 1.1646677442E+01, 3.2789231149E+00, 9.4951602378E-01],
	[3.4545000000E+04, 2.9176394106E+01, 5.4102770011E+00, 1.1652168639E+01, 3.2794558363E+00, 9.4953985449E-01],
	[3.4550000000E+04, 2.9183597307E+01, 5.4102950072E+00, 1.1657661628E+01, 3.2799884259E+00, 9.4956367296E-01],
	[3.4555000000E+04, 2.9190801244E+01, 5.4103130108E+00, 1.1663156409E+01, 3.2805208839E+00, 9.4958747918E-01],
	[3.4560000000E+04, 2.9198005917E+01, 5.4103310118E+00, 1.1668652984E+01, 3.2810532102E+00, 9.4961127317E-01],
	[3.4565000000E+04, 2.9205211325E+01, 5.4103490102E+00, 1.1674151353E+01, 3.2815854048E+00, 9.4963505493E-01],
	[3.4570000000E+04, 2.9212417469E+01, 5.4103670062E+00, 1.1679651515E+01, 3.2821174678E+00, 9.4965882447E-01],
	[3.4575000000E+04, 2.9219624348E+01, 5.4103849995E+00, 1.1685153472E+01, 3.2826493991E+00, 9.4968258179E-01],
	[3.4580000000E+04, 2.9226831962E+01, 5.4104029904E+00, 1.1690657223E+01, 3.2831811988E+00, 9.4970632690E-01],
	[3.4585000000E+04, 2.9234040312E+01, 5.4104209787E+00, 1.1696162768E+01, 3.2837128669E+00, 9.4973005980E-01],
	[3.4590000000E+04, 2.9241249398E+01, 5.4104389644E+00, 1.1701670109E+01, 3.2842444034E+00, 9.4975378051E-01],
	[3.4595000000E+04, 2.9248459218E+01, 5.4104569476E+00, 1.1707179245E+01, 3.2847758082E+00, 9.4977748903E-01],
	[3.4600000000E+04, 2.9255669775E+01, 5.4104749283E+00, 1.1712690178E+01, 3.2853070815E+00, 9.4980118536E-01],
	[3.4605000000E+04, 2.9262881066E+01, 5.4104929065E+00, 1.1718202906E+01, 3.2858382232E+00, 9.4982486952E-01],
	[3.4610000000E+04, 2.9270093093E+01, 5.4105108821E+00, 1.1723717430E+01, 3.2863692334E+00, 9.4984854150E-01],
	[3.4615000000E+04, 2.9277305855E+01, 5.4105288551E+00, 1.1729233752E+01, 3.2869001119E+00, 9.4987220132E-01],
	[3.4620000000E+04, 2.9284519352E+01, 5.4105468257E+00, 1.1734751870E+01, 3.2874308590E+00, 9.4989584897E-01],
	[3.4625000000E+04, 2.9291733584E+01, 5.4105647936E+00, 1.1740271786E+01, 3.2879614745E+00, 9.4991948447E-01],
	[3.4630000000E+04, 2.9298948552E+01, 5.4105827591E+00, 1.1745793499E+01, 3.2884919585E+00, 9.4994310783E-01],
	[3.4635000000E+04, 2.9306164254E+01, 5.4106007220E+00, 1.1751317011E+01, 3.2890223110E+00, 9.4996671904E-01],
	[3.4640000000E+04, 2.9313380692E+01, 5.4106186824E+00, 1.1756842321E+01, 3.2895525320E+00, 9.4999031812E-01],
	[3.4645000000E+04, 2.9320597865E+01, 5.4106366403E+00, 1.1762369429E+01, 3.2900826215E+00, 9.5001390508E-01],
	[3.4650000000E+04, 2.9327815772E+01, 5.4106545956E+00, 1.1767898337E+01, 3.2906125795E+00, 9.5003747991E-01],
	[3.4655000000E+04, 2.9335034415E+01, 5.4106725484E+00, 1.1773429044E+01, 3.2911424060E+00, 9.5006104262E-01],
	[3.4660000000E+04, 2.9342253793E+01, 5.4106904987E+00, 1.1778961551E+01, 3.2916721012E+00, 9.5008459323E-01],
	[3.4665000000E+04, 2.9349473905E+01, 5.4107084464E+00, 1.1784495857E+01, 3.2922016648E+00, 9.5010813173E-01],
	[3.4670000000E+04, 2.9356694753E+01, 5.4107263916E+00, 1.1790031964E+01, 3.2927310971E+00, 9.5013165813E-01],
	[3.4675000000E+04, 2.9363916335E+01, 5.4107443343E+00, 1.1795569872E+01, 3.2932603979E+00, 9.5015517245E-01],
	[3.4680000000E+04, 2.9371138653E+01, 5.4107622744E+00, 1.1801109581E+01, 3.2937895673E+00, 9.5017867468E-01],
	[3.4685000000E+04, 2.9378361705E+01, 5.4107802120E+00, 1.1806651090E+01, 3.2943186053E+00, 9.5020216483E-01],
	[3.4690000000E+04, 2.9385585491E+01, 5.4107981471E+00, 1.1812194402E+01, 3.2948475119E+00, 9.5022564291E-01],
	[3.4695000000E+04, 2.9392810013E+01, 5.4108160797E+00, 1.1817739515E+01, 3.2953762872E+00, 9.5024910893E-01],
	[3.4700000000E+04, 2.9400035269E+01, 5.4108340098E+00, 1.1823286431E+01, 3.2959049311E+00, 9.5027256289E-01],
	[3.4705000000E+04, 2.9407261260E+01, 5.4108519373E+00, 1.1828835150E+01, 3.2964334437E+00, 9.5029600479E-01],
	[3.4710000000E+04, 2.9414487986E+01, 5.4108698623E+00, 1.1834385671E+01, 3.2969618249E+00, 9.5031943465E-01],
	[3.4715000000E+04, 2.9421715446E+01, 5.4108877848E+00, 1.1839937995E+01, 3.2974900748E+00, 9.5034285247E-01],
	[3.4720000000E+04, 2.9428943641E+01, 5.4109057047E+00, 1.1845492123E+01, 3.2980181934E+00, 9.5036625826E-01],
	[3.4725000000E+04, 2.9436172570E+01, 5.4109236222E+00, 1.1851048055E+01, 3.2985461806E+00, 9.5038965201E-01],
	[3.4730000000E+04, 2.9443402234E+01, 5.4109415371E+00, 1.1856605792E+01, 3.2990740366E+00, 9.5041303375E-01],
	[3.4735000000E+04, 2.9450632632E+01, 5.4109594495E+00, 1.1862165332E+01, 3.2996017613E+00, 9.5043640347E-01],
	[3.4740000000E+04, 2.9457863765E+01, 5.4109773593E+00, 1.1867726678E+01, 3.3001293548E+00, 9.5045976118E-01],
	[3.4745000000E+04, 2.9465095633E+01, 5.4109952667E+00, 1.1873289829E+01, 3.3006568170E+00, 9.5048310690E-01],
	[3.4750000000E+04, 2.9472328234E+01, 5.4110131715E+00, 1.1878854785E+01, 3.3011841479E+00, 9.5050644061E-01],
	[3.4755000000E+04, 2.9479561570E+01, 5.4110310738E+00, 1.1884421548E+01, 3.3017113476E+00, 9.5052976233E-01],
	[3.4760000000E+04, 2.9486795641E+01, 5.4110489737E+00, 1.1889990116E+01, 3.3022384161E+00, 9.5055307208E-01],
	[3.4765000000E+04, 2.9494030445E+01, 5.4110668709E+00, 1.1895560491E+01, 3.3027653534E+00, 9.5057636984E-01],
	[3.4770000000E+04, 2.9501265984E+01, 5.4110847657E+00, 1.1901132673E+01, 3.3032921595E+00, 9.5059965563E-01],
	[3.4775000000E+04, 2.9508502257E+01, 5.4111026580E+00, 1.1906706662E+01, 3.3038188345E+00, 9.5062292946E-01],
	[3.4780000000E+04, 2.9515739265E+01, 5.4111205477E+00, 1.1912282458E+01, 3.3043453782E+00, 9.5064619133E-01],
	[3.4785000000E+04, 2.9522977006E+01, 5.4111384350E+00, 1.1917860062E+01, 3.3048717908E+00, 9.5066944125E-01],
	[3.4790000000E+04, 2.9530215482E+01, 5.4111563197E+00, 1.1923439475E+01, 3.3053980722E+00, 9.5069267923E-01],
	[3.4795000000E+04, 2.9537454692E+01, 5.4111742019E+00, 1.1929020695E+01, 3.3059242225E+00, 9.5071590526E-01],
	[3.4800000000E+04, 2.9544694636E+01, 5.4111920816E+00, 1.1934603725E+01, 3.3064502417E+00, 9.5073911936E-01],
	[3.4805000000E+04, 2.9551935314E+01, 5.4112099588E+00, 1.1940188564E+01, 3.3069761298E+00, 9.5076232153E-01],
	[3.4810000000E+04, 2.9559176726E+01, 5.4112278335E+00, 1.1945775212E+01, 3.3075018868E+00, 9.5078551179E-01],
	[3.4815000000E+04, 2.9566418872E+01, 5.4112457057E+00, 1.1951363670E+01, 3.3080275127E+00, 9.5080869012E-01],
	[3.4820000000E+04, 2.9573661752E+01, 5.4112635753E+00, 1.1956953938E+01, 3.3085530075E+00, 9.5083185655E-01],
	[3.4825000000E+04, 2.9580905366E+01, 5.4112814425E+00, 1.1962546016E+01, 3.3090783713E+00, 9.5085501108E-01],
	[3.4830000000E+04, 2.9588149714E+01, 5.4112993071E+00, 1.1968139905E+01, 3.3096036040E+00, 9.5087815372E-01],
	[3.4835000000E+04, 2.9595394795E+01, 5.4113171693E+00, 1.1973735605E+01, 3.3101287056E+00, 9.5090128446E-01],
	[3.4840000000E+04, 2.9602640611E+01, 5.4113350289E+00, 1.1979333117E+01, 3.3106536763E+00, 9.5092440332E-01],
	[3.4845000000E+04, 2.9609887160E+01, 5.4113528861E+00, 1.1984932440E+01, 3.3111785159E+00, 9.5094751031E-01],
	[3.4850000000E+04, 2.9617134443E+01, 5.4113707407E+00, 1.1990533576E+01, 3.3117032246E+00, 9.5097060542E-01],
	[3.4855000000E+04, 2.9624382460E+01, 5.4113885929E+00, 1.1996136523E+01, 3.3122278022E+00, 9.5099368867E-01],
	[3.4860000000E+04, 2.9631631211E+01, 5.4114064425E+00, 1.2001741284E+01, 3.3127522489E+00, 9.5101676006E-01],
	[3.4865000000E+04, 2.9638880695E+01, 5.4114242896E+00, 1.2007347857E+01, 3.3132765646E+00, 9.5103981960E-01],
	[3.4870000000E+04, 2.9646130913E+01, 5.4114421343E+00, 1.2012956244E+01, 3.3138007494E+00, 9.5106286729E-01],
	[3.4875000000E+04, 2.9653381865E+01, 5.4114599764E+00, 1.2018566444E+01, 3.3143248032E+00, 9.5108590315E-01],
	[3.4880000000E+04, 2.9660633550E+01, 5.4114778160E+00, 1.2024178459E+01, 3.3148487261E+00, 9.5110892717E-01],
	[3.4885000000E+04, 2.9667885969E+01, 5.4114956532E+00, 1.2029792287E+01, 3.3153725181E+00, 9.5113193937E-01],
	[3.4890000000E+04, 2.9675139121E+01, 5.4115134878E+00, 1.2035407931E+01, 3.3158961792E+00, 9.5115493974E-01],
	[3.4895000000E+04, 2.9682393007E+01, 5.4115313199E+00, 1.2041025389E+01, 3.3164197095E+00, 9.5117792831E-01],
	[3.4900000000E+04, 2.9689647626E+01, 5.4115491496E+00, 1.2046644663E+01, 3.3169431088E+00, 9.5120090506E-01],
	[3.4905000000E+04, 2.9696902978E+01, 5.4115669767E+00, 1.2052265752E+01, 3.3174663773E+00, 9.5122387001E-01],
	[3.4910000000E+04, 2.9704159064E+01, 5.4115848014E+00, 1.2057888657E+01, 3.3179895149E+00, 9.5124682317E-01],
	[3.4915000000E+04, 2.9711415884E+01, 5.4116026235E+00, 1.2063513379E+01, 3.3185125217E+00, 9.5126976454E-01],
	[3.4920000000E+04, 2.9718673437E+01, 5.4116204432E+00, 1.2069139917E+01, 3.3190353977E+00, 9.5129269412E-01],
	[3.4925000000E+04, 2.9725931723E+01, 5.4116382604E+00, 1.2074768272E+01, 3.3195581429E+00, 9.5131561193E-01],
	[3.4930000000E+04, 2.9733190742E+01, 5.4116560751E+00, 1.2080398444E+01, 3.3200807572E+00, 9.5133851797E-01],
	[3.4935000000E+04, 2.9740450495E+01, 5.4116738873E+00, 1.2086030434E+01, 3.3206032408E+00, 9.5136141224E-01],
	[3.4940000000E+04, 2.9747710981E+01, 5.4116916970E+00, 1.2091664242E+01, 3.3211255936E+00, 9.5138429476E-01],
	[3.4945000000E+04, 2.9754972200E+01, 5.4117095042E+00, 1.2097299868E+01, 3.3216478157E+00, 9.5140716552E-01],
	[3.4950000000E+04, 2.9762234152E+01, 5.4117273089E+00, 1.2102937313E+01, 3.3221699070E+00, 9.5143002454E-01],
	[3.4955000000E+04, 2.9769496837E+01, 5.4117451111E+00, 1.2108576576E+01, 3.3226918676E+00, 9.5145287182E-01],
	[3.4960000000E+04, 2.9776760256E+01, 5.4117629109E+00, 1.2114217659E+01, 3.3232136974E+00, 9.5147570737E-01],
	[3.4965000000E+04, 2.9784024407E+01, 5.4117807081E+00, 1.2119860561E+01, 3.3237353966E+00, 9.5149853119E-01],
	[3.4970000000E+04, 2.9791289292E+01, 5.4117985029E+00, 1.2125505283E+01, 3.3242569650E+00, 9.5152134329E-01],
	[3.4975000000E+04, 2.9798554909E+01, 5.4118162952E+00, 1.2131151825E+01, 3.3247784028E+00, 9.5154414368E-01],
	[3.4980000000E+04, 2.9805821260E+01, 5.4118340850E+00, 1.2136800188E+01, 3.3252997099E+00, 9.5156693236E-01],
	[3.4985000000E+04, 2.9813088343E+01, 5.4118518723E+00, 1.2142450371E+01, 3.3258208864E+00, 9.5158970934E-01],
	[3.4990000000E+04, 2.9820356159E+01, 5.4118696571E+00, 1.2148102376E+01, 3.3263419322E+00, 9.5161247462E-01],
	[3.4995000000E+04, 2.9827624709E+01, 5.4118874395E+00, 1.2153756202E+01, 3.3268628474E+00, 9.5163522821E-01],
	[3.5000000000E+04, 2.9834893991E+01, 5.4119052194E+00, 1.2159411851E+01, 3.3273836319E+00, 9.5165797012E-01],
	[3.5005000000E+04, 2.9842164006E+01, 5.4119229967E+00, 1.2165076083E+01, 3.3279047919E+00, 9.5168070036E-01],
	[3.5010000000E+04, 2.9849434753E+01, 5.4119407716E+00, 1.2170742143E+01, 3.3284258212E+00, 9.5170341892E-01],
	[3.5015000000E+04, 2.9856706234E+01, 5.4119585441E+00, 1.2176410031E+01, 3.3289467196E+00, 9.5172612582E-01],
	[3.5020000000E+04, 2.9863978447E+01, 5.4119763140E+00, 1.2182079748E+01, 3.3294674872E+00, 9.5174882106E-01],
	[3.5025000000E+04, 2.9871251393E+01, 5.4119940815E+00, 1.2187751294E+01, 3.3299881241E+00, 9.5177150465E-01],
	[3.5030000000E+04, 2.9878525071E+01, 5.4120118465E+00, 1.2193424669E+01, 3.3305086302E+00, 9.5179417659E-01],
	[3.5035000000E+04, 2.9885799483E+01, 5.4120296090E+00, 1.2199099874E+01, 3.3310290056E+00, 9.5181683689E-01],
	[3.5040000000E+04, 2.9893074626E+01, 5.4120473690E+00, 1.2204776908E+01, 3.3315492502E+00, 9.5183948557E-01],
	[3.5045000000E+04, 2.9900350503E+01, 5.4120651266E+00, 1.2210455773E+01, 3.3320693642E+00, 9.5186212261E-01],
	[3.5050000000E+04, 2.9907627112E+01, 5.4120828817E+00, 1.2216136468E+01, 3.3325893474E+00, 9.5188474803E-01],
	[3.5055000000E+04, 2.9914904453E+01, 5.4121006343E+00, 1.2221818994E+01, 3.3331091999E+00, 9.5190736184E-01],
	[3.5060000000E+04, 2.9922182527E+01, 5.4121183844E+00, 1.2227503352E+01, 3.3336289218E+00, 9.5192996404E-01],
	[3.5065000000E+04, 2.9929461333E+01, 5.4121361321E+00, 1.2233189540E+01, 3.3341485130E+00, 9.5195255464E-01],
	[3.5070000000E+04, 2.9936740872E+01, 5.4121538773E+00, 1.2238877561E+01, 3.3346679736E+00, 9.5197513365E-01],
	[3.5075000000E+04, 2.9944021143E+01, 5.4121716200E+00, 1.2244567414E+01, 3.3351873035E+00, 9.5199770106E-01],
	[3.5080000000E+04, 2.9951302147E+01, 5.4121893603E+00, 1.2250259099E+01, 3.3357065029E+00, 9.5202025689E-01],
	[3.5085000000E+04, 2.9958583883E+01, 5.4122070980E+00, 1.2255952618E+01, 3.3362255716E+00, 9.5204280114E-01],
	[3.5090000000E+04, 2.9965880245E+01, 5.4122266588E+00, 1.2261647969E+01, 3.3367453758E+00, 9.5206533383E-01],
	[3.5095000000E+04, 2.9973184104E+01, 5.4122471049E+00, 1.2267345154E+01, 3.3372654713E+00, 9.5208785494E-01],
	[3.5100000000E+04, 2.9980488703E+01, 5.4122675481E+00, 1.2273044173E+01, 3.3377854366E+00, 9.5211036450E-01],
	[3.5105000000E+04, 2.9987794041E+01, 5.4122879884E+00, 1.2278745025E+01, 3.3383052719E+00, 9.5213286251E-01],
	[3.5110000000E+04, 2.9995100118E+01, 5.4123084260E+00, 1.2284447713E+01, 3.3388249771E+00, 9.5215534897E-01],
	[3.5115000000E+04, 3.0002406934E+01, 5.4123288607E+00, 1.2290152235E+01, 3.3393445523E+00, 9.5217782389E-01],
	[3.5120000000E+04, 3.0009714490E+01, 5.4123492926E+00, 1.2295858592E+01, 3.3398639975E+00, 9.5220028728E-01],
	[3.5125000000E+04, 3.0017022785E+01, 5.4123697216E+00, 1.2301566785E+01, 3.3403833126E+00, 9.5222273914E-01],
	[3.5130000000E+04, 3.0024331819E+01, 5.4123901478E+00, 1.2307276813E+01, 3.3409024978E+00, 9.5224517948E-01],
	[3.5135000000E+04, 3.0031641592E+01, 5.4124105712E+00, 1.2312988678E+01, 3.3414215530E+00, 9.5226760831E-01],
	[3.5140000000E+04, 3.0038952104E+01, 5.4124309918E+00, 1.2318702379E+01, 3.3419404782E+00, 9.5229002562E-01],
	[3.5145000000E+04, 3.0046263356E+01, 5.4124514095E+00, 1.2324417917E+01, 3.3424592734E+00, 9.5231243143E-01],
	[3.5150000000E+04, 3.0053575346E+01, 5.4124718244E+00, 1.2330135292E+01, 3.3429779388E+00, 9.5233482575E-01],
	[3.5155000000E+04, 3.0060888076E+01, 5.4124922365E+00, 1.2335854504E+01, 3.3434964741E+00, 9.5235720858E-01],
	[3.5160000000E+04, 3.0068201544E+01, 5.4125126457E+00, 1.2341575554E+01, 3.3440148796E+00, 9.5237957992E-01],
	[3.5165000000E+04, 3.0075515751E+01, 5.4125330521E+00, 1.2347298443E+01, 3.3445331552E+00, 9.5240193978E-01],
	[3.5170000000E+04, 3.0082830698E+01, 5.4125534557E+00, 1.2353023169E+01, 3.3450513008E+00, 9.5242428818E-01],
	[3.5175000000E+04, 3.0090146383E+01, 5.4125738565E+00, 1.2358749735E+01, 3.3455693166E+00, 9.5244662510E-01],
	[3.5180000000E+04, 3.0097462807E+01, 5.4125942545E+00, 1.2364478139E+01, 3.3460872026E+00, 9.5246895057E-01],
	[3.5185000000E+04, 3.0104779970E+01, 5.4126146496E+00, 1.2370208383E+01, 3.3466049587E+00, 9.5249126458E-01],
	[3.5190000000E+04, 3.0112097871E+01, 5.4126350419E+00, 1.2375940467E+01, 3.3471225849E+00, 9.5251356715E-01],
	[3.5195000000E+04, 3.0119416512E+01, 5.4126554314E+00, 1.2381674390E+01, 3.3476400814E+00, 9.5253585828E-01],
	[3.5200000000E+04, 3.0126735891E+01, 5.4126758181E+00, 1.2387410155E+01, 3.3481574480E+00, 9.5255813797E-01],
	[3.5205000000E+04, 3.0134056009E+01, 5.4126962019E+00, 1.2393147759E+01, 3.3486746848E+00, 9.5258040624E-01],
	[3.5210000000E+04, 3.0141376865E+01, 5.4127165829E+00, 1.2398887205E+01, 3.3491917919E+00, 9.5260266308E-01],
	[3.5215000000E+04, 3.0148698461E+01, 5.4127369612E+00, 1.2404628492E+01, 3.3497087692E+00, 9.5262490850E-01],
	[3.5220000000E+04, 3.0156020794E+01, 5.4127573366E+00, 1.2410371621E+01, 3.3502256167E+00, 9.5264714252E-01],
	[3.5225000000E+04, 3.0163343867E+01, 5.4127777091E+00, 1.2416116592E+01, 3.3507423346E+00, 9.5266936513E-01],
	[3.5230000000E+04, 3.0170667678E+01, 5.4127980789E+00, 1.2421863406E+01, 3.3512589227E+00, 9.5269157635E-01],
	[3.5235000000E+04, 3.0177992227E+01, 5.4128184459E+00, 1.2427612062E+01, 3.3517753810E+00, 9.5271377617E-01],
	[3.5240000000E+04, 3.0185317515E+01, 5.4128388100E+00, 1.2433362561E+01, 3.3522917097E+00, 9.5273596461E-01],
	[3.5245000000E+04, 3.0192643541E+01, 5.4128591713E+00, 1.2439114903E+01, 3.3528079087E+00, 9.5275814167E-01],
	[3.5250000000E+04, 3.0199970306E+01, 5.4128795298E+00, 1.2444869089E+01, 3.3533239781E+00, 9.5278030736E-01],
	[3.5255000000E+04, 3.0207297810E+01, 5.4128998855E+00, 1.2450625119E+01, 3.3538399178E+00, 9.5280246168E-01],
	[3.5260000000E+04, 3.0214626051E+01, 5.4129202384E+00, 1.2456382994E+01, 3.3543557278E+00, 9.5282460464E-01],
	[3.5265000000E+04, 3.0221955031E+01, 5.4129405885E+00, 1.2462142713E+01, 3.3548714083E+00, 9.5284673624E-01],
	[3.5270000000E+04, 3.0229284750E+01, 5.4129609358E+00, 1.2467904277E+01, 3.3553869591E+00, 9.5286885650E-01],
	[3.5275000000E+04, 3.0236615206E+01, 5.4129812803E+00, 1.2473667686E+01, 3.3559023803E+00, 9.5289096542E-01],
	[3.5280000000E+04, 3.0243946401E+01, 5.4130016219E+00, 1.2479432941E+01, 3.3564176720E+00, 9.5291306300E-01],
	[3.5285000000E+04, 3.0251278334E+01, 5.4130219608E+00, 1.2485200042E+01, 3.3569328341E+00, 9.5293514925E-01],
	[3.5290000000E+04, 3.0258611005E+01, 5.4130422968E+00, 1.2490968990E+01, 3.3574478666E+00, 9.5295722417E-01],
	[3.5295000000E+04, 3.0265944415E+01, 5.4130626301E+00, 1.2496739784E+01, 3.3579627696E+00, 9.5297928778E-01],
	[3.5300000000E+04, 3.0273278562E+01, 5.4130829605E+00, 1.2502512425E+01, 3.3584775431E+00, 9.5300134008E-01],
	[3.5305000000E+04, 3.0280613448E+01, 5.4131032881E+00, 1.2508286913E+01, 3.3589921871E+00, 9.5302338107E-01],
	[3.5310000000E+04, 3.0287949071E+01, 5.4131236130E+00, 1.2514063249E+01, 3.3595067015E+00, 9.5304541077E-01],
	[3.5315000000E+04, 3.0295285433E+01, 5.4131439350E+00, 1.2519841432E+01, 3.3600210865E+00, 9.5306742917E-01],
	[3.5320000000E+04, 3.0302622533E+01, 5.4131642542E+00, 1.2525621465E+01, 3.3605353420E+00, 9.5308943628E-01],
	[3.5325000000E+04, 3.0309960371E+01, 5.4131845707E+00, 1.2531403345E+01, 3.3610494681E+00, 9.5311143212E-01],
	[3.5330000000E+04, 3.0317298946E+01, 5.4132048843E+00, 1.2537187075E+01, 3.3615634648E+00, 9.5313341668E-01],
	[3.5335000000E+04, 3.0324638260E+01, 5.4132251951E+00, 1.2542972654E+01, 3.3620773320E+00, 9.5315538997E-01],
	[3.5340000000E+04, 3.0331978311E+01, 5.4132455032E+00, 1.2548760082E+01, 3.3625910698E+00, 9.5317735200E-01],
	[3.5345000000E+04, 3.0339319101E+01, 5.4132658084E+00, 1.2554549361E+01, 3.3631046782E+00, 9.5319930277E-01],
	[3.5350000000E+04, 3.0346660628E+01, 5.4132861109E+00, 1.2560340489E+01, 3.3636181572E+00, 9.5322124229E-01],
	[3.5355000000E+04, 3.0354002893E+01, 5.4133064105E+00, 1.2566133469E+01, 3.3641315069E+00, 9.5324317058E-01],
	[3.5360000000E+04, 3.0361345896E+01, 5.4133267074E+00, 1.2571928299E+01, 3.3646447272E+00, 9.5326508762E-01],
	[3.5365000000E+04, 3.0368689636E+01, 5.4133470014E+00, 1.2577724980E+01, 3.3651578182E+00, 9.5328699343E-01],
	[3.5370000000E+04, 3.0376034114E+01, 5.4133672927E+00, 1.2583523513E+01, 3.3656707799E+00, 9.5330888802E-01],
	[3.5375000000E+04, 3.0383379330E+01, 5.4133875812E+00, 1.2589323898E+01, 3.3661836123E+00, 9.5333077138E-01],
	[3.5380000000E+04, 3.0390725284E+01, 5.4134078669E+00, 1.2595126135E+01, 3.3666963153E+00, 9.5335264354E-01],
	[3.5385000000E+04, 3.0398071975E+01, 5.4134281497E+00, 1.2600930225E+01, 3.3672088891E+00, 9.5337450449E-01],
	[3.5390000000E+04, 3.0405419404E+01, 5.4134484299E+00, 1.2606736167E+01, 3.3677213337E+00, 9.5339635423E-01],
	[3.5395000000E+04, 3.0412767570E+01, 5.4134687072E+00, 1.2612543963E+01, 3.3682336490E+00, 9.5341819278E-01],
	[3.5400000000E+04, 3.0420116474E+01, 5.4134889817E+00, 1.2618353613E+01, 3.3687458350E+00, 9.5344002015E-01],
	[3.5405000000E+04, 3.0427466115E+01, 5.4135092534E+00, 1.2624165116E+01, 3.3692578919E+00, 9.5346183633E-01],
	[3.5410000000E+04, 3.0434816494E+01, 5.4135295224E+00, 1.2629978473E+01, 3.3697698195E+00, 9.5348364134E-01],
	[3.5415000000E+04, 3.0442167610E+01, 5.4135497886E+00, 1.2635793685E+01, 3.3702816180E+00, 9.5350543517E-01],
	[3.5420000000E+04, 3.0449519464E+01, 5.4135700519E+00, 1.2641610752E+01, 3.3707932872E+00, 9.5352721784E-01],
	[3.5425000000E+04, 3.0456872055E+01, 5.4135903125E+00, 1.2647429674E+01, 3.3713048274E+00, 9.5354898935E-01],
	[3.5430000000E+04, 3.0464225383E+01, 5.4136105703E+00, 1.2653250451E+01, 3.3718162384E+00, 9.5357074972E-01],
	[3.5435000000E+04, 3.0471579448E+01, 5.4136308254E+00, 1.2659073085E+01, 3.3723275202E+00, 9.5359249893E-01],
	[3.5440000000E+04, 3.0478934251E+01, 5.4136510776E+00, 1.2664897574E+01, 3.3728386730E+00, 9.5361423701E-01],
	[3.5445000000E+04, 3.0486289792E+01, 5.4136713271E+00, 1.2670723920E+01, 3.3733496966E+00, 9.5363596395E-01],
	[3.5450000000E+04, 3.0493646069E+01, 5.4136915738E+00, 1.2676552123E+01, 3.3738605912E+00, 9.5365767977E-01],
	[3.5455000000E+04, 3.0501003084E+01, 5.4137118177E+00, 1.2682382183E+01, 3.3743713567E+00, 9.5367938446E-01],
	[3.5460000000E+04, 3.0508360835E+01, 5.4137320588E+00, 1.2688214101E+01, 3.3748819931E+00, 9.5370107804E-01],
	[3.5465000000E+04, 3.0515719324E+01, 5.4137522972E+00, 1.2694047876E+01, 3.3753925005E+00, 9.5372276051E-01],
	[3.5470000000E+04, 3.0523078550E+01, 5.4137725327E+00, 1.2699883510E+01, 3.3759028789E+00, 9.5374443188E-01],
	[3.5475000000E+04, 3.0530438513E+01, 5.4137927655E+00, 1.2705721002E+01, 3.3764131283E+00, 9.5376609215E-01],
	[3.5480000000E+04, 3.0537799214E+01, 5.4138129955E+00, 1.2711560353E+01, 3.3769232487E+00, 9.5378774133E-01],
	[3.5485000000E+04, 3.0545160651E+01, 5.4138332228E+00, 1.2717401562E+01, 3.3774332401E+00, 9.5380937942E-01],
	[3.5490000000E+04, 3.0552522825E+01, 5.4138534473E+00, 1.2723244632E+01, 3.3779431025E+00, 9.5383100644E-01],
	[3.5495000000E+04, 3.0559885736E+01, 5.4138736689E+00, 1.2729089561E+01, 3.3784528360E+00, 9.5385262238E-01],
	[3.5500000000E+04, 3.0567249384E+01, 5.4138938879E+00, 1.2734936350E+01, 3.3789624406E+00, 9.5387422726E-01],
	[3.5505000000E+04, 3.0574613769E+01, 5.4139141040E+00, 1.2740785000E+01, 3.3794719162E+00, 9.5389582108E-01],
	[3.5510000000E+04, 3.0581978891E+01, 5.4139343174E+00, 1.2746635511E+01, 3.3799812630E+00, 9.5391740384E-01],
	[3.5515000000E+04, 3.0589344749E+01, 5.4139545280E+00, 1.2752487883E+01, 3.3804904809E+00, 9.5393897555E-01],
	[3.5520000000E+04, 3.0596711345E+01, 5.4139747359E+00, 1.2758342116E+01, 3.3809995699E+00, 9.5396053623E-01],
	[3.5525000000E+04, 3.0604078677E+01, 5.4139949409E+00, 1.2764198211E+01, 3.3815085300E+00, 9.5398208586E-01],
	[3.5530000000E+04, 3.0611446746E+01, 5.4140151432E+00, 1.2770056168E+01, 3.3820173613E+00, 9.5400362447E-01],
	[3.5535000000E+04, 3.0618815551E+01, 5.4140353428E+00, 1.2775915987E+01, 3.3825260638E+00, 9.5402515205E-01],
	[3.5540000000E+04, 3.0626185094E+01, 5.4140555395E+00, 1.2781777670E+01, 3.3830346375E+00, 9.5404666862E-01],
	[3.5545000000E+04, 3.0633555373E+01, 5.4140757335E+00, 1.2787641215E+01, 3.3835430824E+00, 9.5406817417E-01],
	[3.5550000000E+04, 3.0640926388E+01, 5.4140959248E+00, 1.2793506624E+01, 3.3840513985E+00, 9.5408966872E-01],
	[3.5555000000E+04, 3.0648298140E+01, 5.4141161132E+00, 1.2799373896E+01, 3.3845595858E+00, 9.5411115227E-01],
	[3.5560000000E+04, 3.0655670629E+01, 5.4141362990E+00, 1.2805243033E+01, 3.3850676444E+00, 9.5413262482E-01],
	[3.5565000000E+04, 3.0663043854E+01, 5.4141564819E+00, 1.2811114034E+01, 3.3855755743E+00, 9.5415408639E-01],
	[3.5570000000E+04, 3.0670417816E+01, 5.4141766621E+00, 1.2816986899E+01, 3.3860833754E+00, 9.5417553698E-01],
	[3.5575000000E+04, 3.0677792514E+01, 5.4141968395E+00, 1.2822861630E+01, 3.3865910479E+00, 9.5419697659E-01],
	[3.5580000000E+04, 3.0685167949E+01, 5.4142170142E+00, 1.2828738227E+01, 3.3870985916E+00, 9.5421840523E-01],
	[3.5585000000E+04, 3.0692544120E+01, 5.4142371861E+00, 1.2834616688E+01, 3.3876060067E+00, 9.5423982291E-01],
	[3.5590000000E+04, 3.0699921028E+01, 5.4142573552E+00, 1.2840497016E+01, 3.3881132932E+00, 9.5426122963E-01],
	[3.5595000000E+04, 3.0707298672E+01, 5.4142775216E+00, 1.2846379211E+01, 3.3886204510E+00, 9.5428262540E-01],
	[3.5600000000E+04, 3.0714677052E+01, 5.4142976852E+00, 1.2852263272E+01, 3.3891274801E+00, 9.5430401023E-01],
	[3.5605000000E+04, 3.0722056168E+01, 5.4143178461E+00, 1.2858149200E+01, 3.3896343807E+00, 9.5432538411E-01],
	[3.5610000000E+04, 3.0729436021E+01, 5.4143380042E+00, 1.2864036996E+01, 3.3901411527E+00, 9.5434674707E-01],
	[3.5615000000E+04, 3.0736816610E+01, 5.4143581596E+00, 1.2869926659E+01, 3.3906477961E+00, 9.5436809909E-01],
	[3.5620000000E+04, 3.0744197935E+01, 5.4143783122E+00, 1.2875818190E+01, 3.3911543110E+00, 9.5438944020E-01],
	[3.5625000000E+04, 3.0751579997E+01, 5.4143984620E+00, 1.2881711590E+01, 3.3916606973E+00, 9.5441077039E-01],
	[3.5630000000E+04, 3.0758962794E+01, 5.4144186091E+00, 1.2887606858E+01, 3.3921669551E+00, 9.5443208967E-01],
	[3.5635000000E+04, 3.0766346328E+01, 5.4144387535E+00, 1.2893503996E+01, 3.3926730843E+00, 9.5445339805E-01],
	[3.5640000000E+04, 3.0773730597E+01, 5.4144588951E+00, 1.2899403002E+01, 3.3931790851E+00, 9.5447469554E-01],
	[3.5645000000E+04, 3.0781115603E+01, 5.4144790339E+00, 1.2905303879E+01, 3.3936849574E+00, 9.5449598213E-01],
	[3.5650000000E+04, 3.0788501345E+01, 5.4144991700E+00, 1.2911206625E+01, 3.3941907012E+00, 9.5451725784E-01],
	[3.5655000000E+04, 3.0795902196E+01, 5.4145211700E+00, 1.2917111242E+01, 3.3946972250E+00, 9.5453852266E-01],
	[3.5660000000E+04, 3.0803309853E+01, 5.4145439543E+00, 1.2923017729E+01, 3.3952040039E+00, 9.5455977662E-01],
	[3.5665000000E+04, 3.0810718252E+01, 5.4145667355E+00, 1.2928926088E+01, 3.3957106549E+00, 9.5458101970E-01],
	[3.5670000000E+04, 3.0818127394E+01, 5.4145895137E+00, 1.2934836318E+01, 3.3962171779E+00, 9.5460225191E-01],
	[3.5675000000E+04, 3.0825537279E+01, 5.4146122887E+00, 1.2940748419E+01, 3.3967235730E+00, 9.5462347327E-01],
	[3.5680000000E+04, 3.0832947907E+01, 5.4146350606E+00, 1.2946662392E+01, 3.3972298402E+00, 9.5464468377E-01],
	[3.5685000000E+04, 3.0840359278E+01, 5.4146578295E+00, 1.2952578238E+01, 3.3977359795E+00, 9.5466588343E-01],
	[3.5690000000E+04, 3.0847771391E+01, 5.4146805952E+00, 1.2958495957E+01, 3.3982419910E+00, 9.5468707224E-01],
	[3.5695000000E+04, 3.0855184247E+01, 5.4147033579E+00, 1.2964415548E+01, 3.3987478745E+00, 9.5470825021E-01],
	[3.5700000000E+04, 3.0862597846E+01, 5.4147261174E+00, 1.2970337013E+01, 3.3992536303E+00, 9.5472941735E-01],
	[3.5705000000E+04, 3.0870012188E+01, 5.4147488739E+00, 1.2976260351E+01, 3.3997592582E+00, 9.5475057366E-01],
	[3.5710000000E+04, 3.0877427272E+01, 5.4147716273E+00, 1.2982185563E+01, 3.4002647582E+00, 9.5477171914E-01],
	[3.5715000000E+04, 3.0884843098E+01, 5.4147943776E+00, 1.2988112650E+01, 3.4007701305E+00, 9.5479285381E-01],
	[3.5720000000E+04, 3.0892259667E+01, 5.4148171248E+00, 1.2994041611E+01, 3.4012753750E+00, 9.5481397767E-01],
	[3.5725000000E+04, 3.0899676979E+01, 5.4148398689E+00, 1.2999972447E+01, 3.4017804918E+00, 9.5483509072E-01],
	[3.5730000000E+04, 3.0907095033E+01, 5.4148626099E+00, 1.3005905159E+01, 3.4022854808E+00, 9.5485619297E-01],
	[3.5735000000E+04, 3.0914513830E+01, 5.4148853478E+00, 1.3011839746E+01, 3.4027903420E+00, 9.5487728442E-01],
	[3.5740000000E+04, 3.0921933369E+01, 5.4149080827E+00, 1.3017776209E+01, 3.4032950756E+00, 9.5489836509E-01],
	[3.5745000000E+04, 3.0929353651E+01, 5.4149308144E+00, 1.3023714548E+01, 3.4037996814E+00, 9.5491943496E-01],
	[3.5750000000E+04, 3.0936774674E+01, 5.4149535431E+00, 1.3029654764E+01, 3.4043041596E+00, 9.5494049406E-01],
	[3.5755000000E+04, 3.0944196441E+01, 5.4149762687E+00, 1.3035596857E+01, 3.4048085100E+00, 9.5496154238E-01],
	[3.5760000000E+04, 3.0951618949E+01, 5.4149989912E+00, 1.3041540827E+01, 3.4053127329E+00, 9.5498257993E-01],
	[3.5765000000E+04, 3.0959042200E+01, 5.4150217107E+00, 1.3047486675E+01, 3.4058168281E+00, 9.5500360671E-01],
	[3.5770000000E+04, 3.0966466193E+01, 5.4150444270E+00, 1.3053434401E+01, 3.4063207957E+00, 9.5502462274E-01],
	[3.5775000000E+04, 3.0973890929E+01, 5.4150671403E+00, 1.3059384005E+01, 3.4068246356E+00, 9.5504562801E-01],
	[3.5780000000E+04, 3.0981316406E+01, 5.4150898505E+00, 1.3065335487E+01, 3.4073283480E+00, 9.5506662254E-01],
	[3.5785000000E+04, 3.0988742626E+01, 5.4151125576E+00, 1.3071288849E+01, 3.4078319328E+00, 9.5508760632E-01],
	[3.5790000000E+04, 3.0996169588E+01, 5.4151352616E+00, 1.3077244090E+01, 3.4083353901E+00, 9.5510857936E-01],
	[3.5795000000E+04, 3.1003597292E+01, 5.4151579626E+00, 1.3083201210E+01, 3.4088387198E+00, 9.5512954167E-01],
	[3.5800000000E+04, 3.1011025738E+01, 5.4151806605E+00, 1.3089160210E+01, 3.4093419220E+00, 9.5515049325E-01],
	[3.5805000000E+04, 3.1018454927E+01, 5.4152033553E+00, 1.3095121090E+01, 3.4098449967E+00, 9.5517143411E-01],
	[3.5810000000E+04, 3.1025884857E+01, 5.4152260470E+00, 1.3101083851E+01, 3.4103479439E+00, 9.5519236425E-01],
	[3.5815000000E+04, 3.1033315529E+01, 5.4152487357E+00, 1.3107048493E+01, 3.4108507636E+00, 9.5521328368E-01],
	[3.5820000000E+04, 3.1040746943E+01, 5.4152714213E+00, 1.3113015017E+01, 3.4113534559E+00, 9.5523419240E-01],
	[3.5825000000E+04, 3.1048179099E+01, 5.4152941038E+00, 1.3118983421E+01, 3.4118560207E+00, 9.5525509042E-01],
	[3.5830000000E+04, 3.1055611997E+01, 5.4153167833E+00, 1.3124953708E+01, 3.4123584581E+00, 9.5527597775E-01],
	[3.5835000000E+04, 3.1063045637E+01, 5.4153394597E+00, 1.3130925877E+01, 3.4128607681E+00, 9.5529685438E-01],
	[3.5840000000E+04, 3.1070480019E+01, 5.4153621330E+00, 1.3136899928E+01, 3.4133629506E+00, 9.5531772033E-01],
	[3.5845000000E+04, 3.1077915143E+01, 5.4153848032E+00, 1.3142875862E+01, 3.4138650059E+00, 9.5533857560E-01],
	[3.5850000000E+04, 3.1085351008E+01, 5.4154074704E+00, 1.3148853680E+01, 3.4143669337E+00, 9.5535942020E-01],
	[3.5855000000E+04, 3.1092787615E+01, 5.4154301345E+00, 1.3154833381E+01, 3.4148687342E+00, 9.5538025413E-01],
	[3.5860000000E+04, 3.1100224964E+01, 5.4154527956E+00, 1.3160814966E+01, 3.4153704074E+00, 9.5540107739E-01],
	[3.5865000000E+04, 3.1107663055E+01, 5.4154754535E+00, 1.3166798435E+01, 3.4158719533E+00, 9.5542188999E-01],
	[3.5870000000E+04, 3.1115101887E+01, 5.4154981084E+00, 1.3172783788E+01, 3.4163733719E+00, 9.5544269194E-01],
	[3.5875000000E+04, 3.1122541461E+01, 5.4155207603E+00, 1.3178771027E+01, 3.4168746632E+00, 9.5546348324E-01],
	[3.5880000000E+04, 3.1129981776E+01, 5.4155434091E+00, 1.3184760150E+01, 3.4173758272E+00, 9.5548426389E-01],
	[3.5885000000E+04, 3.1137422834E+01, 5.4155660548E+00, 1.3190751159E+01, 3.4178768640E+00, 9.5550503391E-01],
	[3.5890000000E+04, 3.1144864632E+01, 5.4155886975E+00, 1.3196744054E+01, 3.4183777736E+00, 9.5552579330E-01],
	[3.5895000000E+04, 3.1152307172E+01, 5.4156113371E+00, 1.3202738836E+01, 3.4188785560E+00, 9.5554654206E-01],
	[3.5900000000E+04, 3.1159750454E+01, 5.4156339737E+00, 1.3208735503E+01, 3.4193792111E+00, 9.5556728020E-01],
	[3.5905000000E+04, 3.1167194477E+01, 5.4156566072E+00, 1.3214734058E+01, 3.4198797391E+00, 9.5558800772E-01],
	[3.5910000000E+04, 3.1174639242E+01, 5.4156792376E+00, 1.3220734500E+01, 3.4203801399E+00, 9.5560872463E-01],
	[3.5915000000E+04, 3.1182084748E+01, 5.4157018650E+00, 1.3226736829E+01, 3.4208804136E+00, 9.5562943093E-01],
	[3.5920000000E+04, 3.1189530995E+01, 5.4157244893E+00, 1.3232741046E+01, 3.4213805602E+00, 9.5565012663E-01],
	[3.5925000000E+04, 3.1196977984E+01, 5.4157471106E+00, 1.3238747151E+01, 3.4218805796E+00, 9.5567081174E-01],
	[3.5930000000E+04, 3.1204425714E+01, 5.4157697288E+00, 1.3244755145E+01, 3.4223804720E+00, 9.5569148626E-01],
	[3.5935000000E+04, 3.1211874186E+01, 5.4157923439E+00, 1.3250765028E+01, 3.4228802373E+00, 9.5571215019E-01],
	[3.5940000000E+04, 3.1219323398E+01, 5.4158149561E+00, 1.3256776799E+01, 3.4233798755E+00, 9.5573280354E-01],
	[3.5945000000E+04, 3.1226773352E+01, 5.4158375651E+00, 1.3262790460E+01, 3.4238793866E+00, 9.5575344632E-01],
	[3.5950000000E+04, 3.1234224047E+01, 5.4158601711E+00, 1.3268806011E+01, 3.4243787708E+00, 9.5577407853E-01],
	[3.5955000000E+04, 3.1241675484E+01, 5.4158827741E+00, 1.3274823453E+01, 3.4248780279E+00, 9.5579470017E-01],
	[3.5960000000E+04, 3.1249127661E+01, 5.4159053740E+00, 1.3280842784E+01, 3.4253771581E+00, 9.5581531126E-01],
	[3.5965000000E+04, 3.1256580580E+01, 5.4159279709E+00, 1.3286864007E+01, 3.4258761612E+00, 9.5583591179E-01],
	[3.5970000000E+04, 3.1264034239E+01, 5.4159505647E+00, 1.3292887120E+01, 3.4263750374E+00, 9.5585650178E-01],
	[3.5975000000E+04, 3.1271488640E+01, 5.4159731555E+00, 1.3298912125E+01, 3.4268737867E+00, 9.5587708122E-01],
	[3.5980000000E+04, 3.1278943782E+01, 5.4159957432E+00, 1.3304939022E+01, 3.4273724090E+00, 9.5589765012E-01],
	[3.5985000000E+04, 3.1286399664E+01, 5.4160183279E+00, 1.3310967811E+01, 3.4278709044E+00, 9.5591820850E-01],
	[3.5990000000E+04, 3.1293856288E+01, 5.4160409095E+00, 1.3316998492E+01, 3.4283692730E+00, 9.5593875634E-01],
	[3.5995000000E+04, 3.1301313653E+01, 5.4160634881E+00, 1.3323031067E+01, 3.4288675146E+00, 9.5595929367E-01],
	[3.6000000000E+04, 3.1308771758E+01, 5.4160860637E+00, 1.3329065534E+01, 3.4293656294E+00, 9.5597982047E-01],
	[3.6005000000E+04, 3.1316230604E+01, 5.4161086362E+00, 1.3335101895E+01, 3.4298636174E+00, 9.5600033677E-01],
	[3.6010000000E+04, 3.1323690192E+01, 5.4161312056E+00, 1.3341140149E+01, 3.4303614786E+00, 9.5602084256E-01],
	[3.6015000000E+04, 3.1331150520E+01, 5.4161537721E+00, 1.3347180298E+01, 3.4308592129E+00, 9.5604133785E-01],
	[3.6020000000E+04, 3.1338611589E+01, 5.4161763355E+00, 1.3353222341E+01, 3.4313568204E+00, 9.5606182265E-01],
	[3.6025000000E+04, 3.1346073398E+01, 5.4161988958E+00, 1.3359266279E+01, 3.4318543012E+00, 9.5608229696E-01],
	[3.6030000000E+04, 3.1353535949E+01, 5.4162214531E+00, 1.3365312112E+01, 3.4323516552E+00, 9.5610276078E-01],
	[3.6035000000E+04, 3.1360999240E+01, 5.4162440074E+00, 1.3371359840E+01, 3.4328488825E+00, 9.5612321412E-01],
	[3.6040000000E+04, 3.1368463272E+01, 5.4162665587E+00, 1.3377409465E+01, 3.4333459831E+00, 9.5614365699E-01],
	[3.6045000000E+04, 3.1375928044E+01, 5.4162891069E+00, 1.3383460985E+01, 3.4338429569E+00, 9.5616408939E-01],
	[3.6050000000E+04, 3.1383393557E+01, 5.4163116521E+00, 1.3389514402E+01, 3.4343398041E+00, 9.5618451132E-01],
	[3.6055000000E+04, 3.1390859811E+01, 5.4163341942E+00, 1.3395569715E+01, 3.4348365246E+00, 9.5620492280E-01],
	[3.6060000000E+04, 3.1398326805E+01, 5.4163567333E+00, 1.3401626926E+01, 3.4353331184E+00, 9.5622532383E-01],
	[3.6065000000E+04, 3.1405794540E+01, 5.4163792694E+00, 1.3407686034E+01, 3.4358295856E+00, 9.5624571440E-01],
	[3.6070000000E+04, 3.1413263015E+01, 5.4164018024E+00, 1.3413747039E+01, 3.4363259262E+00, 9.5626609454E-01],
	[3.6075000000E+04, 3.1420732231E+01, 5.4164243325E+00, 1.3419809943E+01, 3.4368221402E+00, 9.5628646424E-01],
	[3.6080000000E+04, 3.1428202187E+01, 5.4164468595E+00, 1.3425874745E+01, 3.4373182277E+00, 9.5630682350E-01],
	[3.6085000000E+04, 3.1435672883E+01, 5.4164693834E+00, 1.3431941446E+01, 3.4378141885E+00, 9.5632717234E-01],
	[3.6090000000E+04, 3.1443144320E+01, 5.4164919044E+00, 1.3438010046E+01, 3.4383100228E+00, 9.5634751076E-01],
	[3.6095000000E+04, 3.1450616497E+01, 5.4165144223E+00, 1.3444080546E+01, 3.4388057306E+00, 9.5636783877E-01],
	[3.6100000000E+04, 3.1458089415E+01, 5.4165369372E+00, 1.3450152945E+01, 3.4393013118E+00, 9.5638815636E-01],
	[3.6105000000E+04, 3.1465563073E+01, 5.4165594490E+00, 1.3456227244E+01, 3.4397967666E+00, 9.5640846355E-01],
	[3.6110000000E+04, 3.1473037471E+01, 5.4165819579E+00, 1.3462303444E+01, 3.4402920949E+00, 9.5642876033E-01],
	[3.6115000000E+04, 3.1480512610E+01, 5.4166044637E+00, 1.3468381544E+01, 3.4407872967E+00, 9.5644904673E-01],
	[3.6120000000E+04, 3.1487988488E+01, 5.4166269665E+00, 1.3474461545E+01, 3.4412823721E+00, 9.5646932273E-01],
	[3.6125000000E+04, 3.1495465107E+01, 5.4166494662E+00, 1.3480543448E+01, 3.4417773211E+00, 9.5648958835E-01],
	[3.6130000000E+04, 3.1502942466E+01, 5.4166719630E+00, 1.3486627253E+01, 3.4422721436E+00, 9.5650984359E-01],
	[3.6135000000E+04, 3.1510420565E+01, 5.4166944567E+00, 1.3492712959E+01, 3.4427668398E+00, 9.5653008845E-01],
	[3.6140000000E+04, 3.1517899404E+01, 5.4167169474E+00, 1.3498800568E+01, 3.4432614095E+00, 9.5655032295E-01],
	[3.6145000000E+04, 3.1525378984E+01, 5.4167394351E+00, 1.3504890080E+01, 3.4437558530E+00, 9.5657054709E-01],
	[3.6150000000E+04, 3.1532859303E+01, 5.4167619198E+00, 1.3510981494E+01, 3.4442501701E+00, 9.5659076086E-01],
	[3.6155000000E+04, 3.1540340362E+01, 5.4167844015E+00, 1.3517074813E+01, 3.4447443608E+00, 9.5661096429E-01],
	[3.6160000000E+04, 3.1547822161E+01, 5.4168068801E+00, 1.3523170034E+01, 3.4452384253E+00, 9.5663115736E-01],
	[3.6165000000E+04, 3.1555304701E+01, 5.4168293557E+00, 1.3529267160E+01, 3.4457323635E+00, 9.5665134010E-01],
	[3.6170000000E+04, 3.1562787980E+01, 5.4168518284E+00, 1.3535366190E+01, 3.4462261754E+00, 9.5667151250E-01],
	[3.6175000000E+04, 3.1570271999E+01, 5.4168742980E+00, 1.3541467125E+01, 3.4467198611E+00, 9.5669167456E-01],
	[3.6180000000E+04, 3.1577756758E+01, 5.4168967646E+00, 1.3547569965E+01, 3.4472134205E+00, 9.5671182631E-01],
	[3.6185000000E+04, 3.1585242256E+01, 5.4169192281E+00, 1.3553674710E+01, 3.4477068537E+00, 9.5673196773E-01],
	[3.6190000000E+04, 3.1592728495E+01, 5.4169416887E+00, 1.3559781361E+01, 3.4482001607E+00, 9.5675209883E-01],
	[3.6195000000E+04, 3.1600215473E+01, 5.4169641463E+00, 1.3565889918E+01, 3.4486933416E+00, 9.5677221962E-01],
	[3.6200000000E+04, 3.1607703191E+01, 5.4169866008E+00, 1.3572000381E+01, 3.4491863962E+00, 9.5679233011E-01],
	[3.6205000000E+04, 3.1615191649E+01, 5.4170090524E+00, 1.3578112751E+01, 3.4496793248E+00, 9.5681243030E-01],
	[3.6210000000E+04, 3.1622680846E+01, 5.4170315009E+00, 1.3584227028E+01, 3.4501721272E+00, 9.5683252020E-01],
	[3.6215000000E+04, 3.1630170783E+01, 5.4170539464E+00, 1.3590343212E+01, 3.4506648035E+00, 9.5685259980E-01],
	[3.6220000000E+04, 3.1637661460E+01, 5.4170763889E+00, 1.3596461304E+01, 3.4511573537E+00, 9.5687266913E-01],
	[3.6225000000E+04, 3.1645152876E+01, 5.4170988285E+00, 1.3602581304E+01, 3.4516497779E+00, 9.5689272817E-01],
	[3.6230000000E+04, 3.1652663540E+01, 5.4171236403E+00, 1.3608703213E+01, 3.4521432607E+00, 9.5691277694E-01],
	[3.6235000000E+04, 3.1660176663E+01, 5.4171486688E+00, 1.3614827029E+01, 3.4526367277E+00, 9.5693281544E-01],
	[3.6240000000E+04, 3.1667690533E+01, 5.4171736940E+00, 1.3620952755E+01, 3.4531300691E+00, 9.5695284368E-01],
	[3.6245000000E+04, 3.1675205148E+01, 5.4171987159E+00, 1.3627080391E+01, 3.4536232849E+00, 9.5697286166E-01],
	[3.6250000000E+04, 3.1682720511E+01, 5.4172237344E+00, 1.3633209936E+01, 3.4541163752E+00, 9.5699286939E-01],
	[3.6255000000E+04, 3.1690236619E+01, 5.4172487495E+00, 1.3639341391E+01, 3.4546093400E+00, 9.5701286687E-01],
	[3.6260000000E+04, 3.1697753473E+01, 5.4172737613E+00, 1.3645474756E+01, 3.4551021792E+00, 9.5703285411E-01],
	[3.6265000000E+04, 3.1705271074E+01, 5.4172987698E+00, 1.3651610032E+01, 3.4555948930E+00, 9.5705283111E-01],
	[3.6270000000E+04, 3.1712789421E+01, 5.4173237750E+00, 1.3657747219E+01, 3.4560874813E+00, 9.5707279788E-01],
	[3.6275000000E+04, 3.1720308514E+01, 5.4173487768E+00, 1.3663886317E+01, 3.4565799441E+00, 9.5709275443E-01],
	[3.6280000000E+04, 3.1727828353E+01, 5.4173737753E+00, 1.3670027327E+01, 3.4570722815E+00, 9.5711270076E-01],
	[3.6285000000E+04, 3.1735348938E+01, 5.4173987705E+00, 1.3676170249E+01, 3.4575644934E+00, 9.5713263687E-01],
	[3.6290000000E+04, 3.1742870269E+01, 5.4174237624E+00, 1.3682315083E+01, 3.4580565800E+00, 9.5715256277E-01],
	[3.6295000000E+04, 3.1750392346E+01, 5.4174487509E+00, 1.3688461830E+01, 3.4585485412E+00, 9.5717247846E-01],
	[3.6300000000E+04, 3.1757915169E+01, 5.4174737361E+00, 1.3694610489E+01, 3.4590403770E+00, 9.5719238396E-01],
	[3.6305000000E+04, 3.1765438738E+01, 5.4174987179E+00, 1.3700761062E+01, 3.4595320874E+00, 9.5721227926E-01],
	[3.6310000000E+04, 3.1772963053E+01, 5.4175236965E+00, 1.3706913549E+01, 3.4600236726E+00, 9.5723216437E-01],
	[3.6315000000E+04, 3.1780488113E+01, 5.4175486717E+00, 1.3713067950E+01, 3.4605151324E+00, 9.5725203930E-01],
	[3.6320000000E+04, 3.1788013920E+01, 5.4175736436E+00, 1.3719224265E+01, 3.4610064669E+00, 9.5727190405E-01],
	[3.6325000000E+04, 3.1795540472E+01, 5.4175986121E+00, 1.3725382494E+01, 3.4614976761E+00, 9.5729175862E-01],
	[3.6330000000E+04, 3.1803067770E+01, 5.4176235774E+00, 1.3731542639E+01, 3.4619887601E+00, 9.5731160303E-01],
	[3.6335000000E+04, 3.1810595814E+01, 5.4176485393E+00, 1.3737704699E+01, 3.4624797188E+00, 9.5733143728E-01],
	[3.6340000000E+04, 3.1818124604E+01, 5.4176734979E+00, 1.3743868674E+01, 3.4629705523E+00, 9.5735126136E-01],
	[3.6345000000E+04, 3.1825654139E+01, 5.4176984532E+00, 1.3750034565E+01, 3.4634612606E+00, 9.5737107530E-01],
	[3.6350000000E+04, 3.1833184420E+01, 5.4177234052E+00, 1.3756202373E+01, 3.4639518437E+00, 9.5739087909E-01],
	[3.6355000000E+04, 3.1840715447E+01, 5.4177483538E+00, 1.3762372097E+01, 3.4644423017E+00, 9.5741067273E-01],
	[3.6360000000E+04, 3.1848247219E+01, 5.4177732992E+00, 1.3768543739E+01, 3.4649326345E+00, 9.5743045624E-01],
	[3.6365000000E+04, 3.1855779737E+01, 5.4177982412E+00, 1.3774717297E+01, 3.4654228421E+00, 9.5745022962E-01],
	[3.6370000000E+04, 3.1863313001E+01, 5.4178231799E+00, 1.3780892773E+01, 3.4659129247E+00, 9.5746999288E-01],
	[3.6375000000E+04, 3.1870847010E+01, 5.4178481153E+00, 1.3787070167E+01, 3.4664028821E+00, 9.5748974601E-01],
	[3.6380000000E+04, 3.1878381764E+01, 5.4178730474E+00, 1.3793249480E+01, 3.4668927145E+00, 9.5750948903E-01],
	[3.6385000000E+04, 3.1885917264E+01, 5.4178979761E+00, 1.3799430710E+01, 3.4673824218E+00, 9.5752922193E-01],
	[3.6390000000E+04, 3.1893453509E+01, 5.4179229016E+00, 1.3805613860E+01, 3.4678720040E+00, 9.5754894473E-01],
	[3.6395000000E+04, 3.1900990500E+01, 5.4179478237E+00, 1.3811798929E+01, 3.4683614613E+00, 9.5756865743E-01],
	[3.6400000000E+04, 3.1908528236E+01, 5.4179727426E+00, 1.3817985918E+01, 3.4688507935E+00, 9.5758836004E-01],
	[3.6405000000E+04, 3.1916066718E+01, 5.4179976581E+00, 1.3824174827E+01, 3.4693400007E+00, 9.5760805256E-01],
	[3.6410000000E+04, 3.1923605945E+01, 5.4180225703E+00, 1.3830365656E+01, 3.4698290830E+00, 9.5762773499E-01],
	[3.6415000000E+04, 3.1931145917E+01, 5.4180474793E+00, 1.3836558405E+01, 3.4703180403E+00, 9.5764740735E-01],
	[3.6420000000E+04, 3.1938686634E+01, 5.4180723849E+00, 1.3842753076E+01, 3.4708068727E+00, 9.5766706963E-01],
	[3.6425000000E+04, 3.1946228097E+01, 5.4180972872E+00, 1.3848949667E+01, 3.4712955802E+00, 9.5768672185E-01],
	[3.6430000000E+04, 3.1953770305E+01, 5.4181221862E+00, 1.3855148181E+01, 3.4717841627E+00, 9.5770636400E-01],
	[3.6435000000E+04, 3.1961313258E+01, 5.4181470819E+00, 1.3861348616E+01, 3.4722726204E+00, 9.5772599609E-01],
	[3.6440000000E+04, 3.1968856956E+01, 5.4181719743E+00, 1.3867550973E+01, 3.4727609532E+00, 9.5774561813E-01],
	[3.6445000000E+04, 3.1976401399E+01, 5.4181968634E+00, 1.3873755253E+01, 3.4732491612E+00, 9.5776523012E-01],
	[3.6450000000E+04, 3.1983946588E+01, 5.4182217492E+00, 1.3879961456E+01, 3.4737372444E+00, 9.5778483208E-01],
	[3.6455000000E+04, 3.1991492521E+01, 5.4182466317E+00, 1.3886169582E+01, 3.4742252028E+00, 9.5780442399E-01],
	[3.6460000000E+04, 3.1999039200E+01, 5.4182715109E+00, 1.3892379632E+01, 3.4747130363E+00, 9.5782400587E-01],
	[3.6465000000E+04, 3.2006586624E+01, 5.4182963868E+00, 1.3898591605E+01, 3.4752007451E+00, 9.5784357773E-01],
	[3.6470000000E+04, 3.2014134792E+01, 5.4183212594E+00, 1.3904805503E+01, 3.4756883292E+00, 9.5786313957E-01],
	[3.6475000000E+04, 3.2021683706E+01, 5.4183461287E+00, 1.3911021326E+01, 3.4761757885E+00, 9.5788269139E-01],
	[3.6480000000E+04, 3.2029233364E+01, 5.4183709947E+00, 1.3917239073E+01, 3.4766631231E+00, 9.5790223320E-01],
	[3.6485000000E+04, 3.2036783767E+01, 5.4183958574E+00, 1.3923458746E+01, 3.4771503330E+00, 9.5792176500E-01],
	[3.6490000000E+04, 3.2044334916E+01, 5.4184207169E+00, 1.3929680344E+01, 3.4776374183E+00, 9.5794128681E-01],
	[3.6495000000E+04, 3.2051886809E+01, 5.4184455730E+00, 1.3935903868E+01, 3.4781243789E+00, 9.5796079862E-01],
	[3.6500000000E+04, 3.2059439447E+01, 5.4184704259E+00, 1.3942129318E+01, 3.4786112148E+00, 9.5798030044E-01],
	[3.6505000000E+04, 3.2066992829E+01, 5.4184952754E+00, 1.3948356695E+01, 3.4790979261E+00, 9.5799979227E-01],
	[3.6510000000E+04, 3.2074546957E+01, 5.4185201217E+00, 1.3954585999E+01, 3.4795845129E+00, 9.5801927413E-01],
	[3.6515000000E+04, 3.2082101829E+01, 5.4185449647E+00, 1.3960817230E+01, 3.4800709750E+00, 9.5803874601E-01],
	[3.6520000000E+04, 3.2089657446E+01, 5.4185698044E+00, 1.3967050388E+01, 3.4805573126E+00, 9.5805820793E-01],
	[3.6525000000E+04, 3.2097213807E+01, 5.4185946408E+00, 1.3973285474E+01, 3.4810435256E+00, 9.5807765988E-01],
	[3.6530000000E+04, 3.2104770913E+01, 5.4186194739E+00, 1.3979522489E+01, 3.4815296141E+00, 9.5809710187E-01],
	[3.6535000000E+04, 3.2112328764E+01, 5.4186443037E+00, 1.3985761432E+01, 3.4820155781E+00, 9.5811653391E-01],
	[3.6540000000E+04, 3.2119887359E+01, 5.4186691303E+00, 1.3992002304E+01, 3.4825014176E+00, 9.5813595601E-01],
	[3.6545000000E+04, 3.2127446699E+01, 5.4186939535E+00, 1.3998245105E+01, 3.4829871326E+00, 9.5815536816E-01],
	[3.6550000000E+04, 3.2135006784E+01, 5.4187187735E+00, 1.4004489836E+01, 3.4834727232E+00, 9.5817477037E-01],
	[3.6555000000E+04, 3.2142567613E+01, 5.4187435902E+00, 1.4010736497E+01, 3.4839581894E+00, 9.5819416265E-01],
	[3.6560000000E+04, 3.2150129186E+01, 5.4187684036E+00, 1.4016985088E+01, 3.4844435311E+00, 9.5821354500E-01],
	[3.6565000000E+04, 3.2157691504E+01, 5.4187932138E+00, 1.4023235609E+01, 3.4849287484E+00, 9.5823291744E-01],
	[3.6570000000E+04, 3.2165254566E+01, 5.4188180206E+00, 1.4029488061E+01, 3.4854138414E+00, 9.5825227995E-01],
	[3.6575000000E+04, 3.2172818373E+01, 5.4188428242E+00, 1.4035742445E+01, 3.4858988100E+00, 9.5827163256E-01],
	[3.6580000000E+04, 3.2180382924E+01, 5.4188676245E+00, 1.4041998760E+01, 3.4863836542E+00, 9.5829097526E-01],
	[3.6585000000E+04, 3.2187948219E+01, 5.4188924216E+00, 1.4048257006E+01, 3.4868683742E+00, 9.5831030806E-01],
	[3.6590000000E+04, 3.2195514259E+01, 5.4189172153E+00, 1.4054517185E+01, 3.4873529698E+00, 9.5832963096E-01],
	[3.6595000000E+04, 3.2203081043E+01, 5.4189420058E+00, 1.4060779297E+01, 3.4878374412E+00, 9.5834894398E-01],
	[3.6600000000E+04, 3.2210648571E+01, 5.4189667930E+00, 1.4067043342E+01, 3.4883217883E+00, 9.5836824710E-01],
	[3.6605000000E+04, 3.2218216843E+01, 5.4189915769E+00, 1.4073309319E+01, 3.4888060111E+00, 9.5838754035E-01],
	[3.6610000000E+04, 3.2225785860E+01, 5.4190163576E+00, 1.4079577230E+01, 3.4892901097E+00, 9.5840682373E-01],
	[3.6615000000E+04, 3.2233355621E+01, 5.4190411350E+00, 1.4085847075E+01, 3.4897740841E+00, 9.5842609723E-01],
	[3.6620000000E+04, 3.2240926125E+01, 5.4190659091E+00, 1.4092118855E+01, 3.4902579344E+00, 9.5844536087E-01],
	[3.6625000000E+04, 3.2248497374E+01, 5.4190906800E+00, 1.4098392568E+01, 3.4907416604E+00, 9.5846461466E-01],
	[3.6630000000E+04, 3.2256069367E+01, 5.4191154476E+00, 1.4104668217E+01, 3.4912252623E+00, 9.5848385859E-01],
	[3.6635000000E+04, 3.2263642104E+01, 5.4191402119E+00, 1.4110945801E+01, 3.4917087401E+00, 9.5850309267E-01],
	[3.6640000000E+04, 3.2271215585E+01, 5.4191649729E+00, 1.4117225320E+01, 3.4921920937E+00, 9.5852231690E-01],
	[3.6645000000E+04, 3.2278789810E+01, 5.4191897307E+00, 1.4123506775E+01, 3.4926753233E+00, 9.5854153130E-01],
	[3.6650000000E+04, 3.2286364779E+01, 5.4192144852E+00, 1.4129790166E+01, 3.4931584288E+00, 9.5856073587E-01],
	[3.6655000000E+04, 3.2293940492E+01, 5.4192392365E+00, 1.4136075494E+01, 3.4936414102E+00, 9.5857993061E-01],
	[3.6660000000E+04, 3.2301516949E+01, 5.4192639845E+00, 1.4142362759E+01, 3.4941242676E+00, 9.5859911553E-01],
	[3.6665000000E+04, 3.2309094150E+01, 5.4192887292E+00, 1.4148651961E+01, 3.4946070010E+00, 9.5861829063E-01],
	[3.6670000000E+04, 3.2316672095E+01, 5.4193134707E+00, 1.4154943100E+01, 3.4950896104E+00, 9.5863745591E-01],
	[3.6675000000E+04, 3.2324250783E+01, 5.4193382089E+00, 1.4161236177E+01, 3.4955720958E+00, 9.5865661140E-01],
	[3.6680000000E+04, 3.2331830215E+01, 5.4193629439E+00, 1.4167531193E+01, 3.4960544572E+00, 9.5867575707E-01],
	[3.6685000000E+04, 3.2339410391E+01, 5.4193876756E+00, 1.4173828147E+01, 3.4965366947E+00, 9.5869489296E-01],
	[3.6690000000E+04, 3.2346991311E+01, 5.4194124040E+00, 1.4180127039E+01, 3.4970188083E+00, 9.5871401905E-01],
	[3.6695000000E+04, 3.2354572974E+01, 5.4194371292E+00, 1.4186427871E+01, 3.4975007980E+00, 9.5873313536E-01],
	[3.6700000000E+04, 3.2362155381E+01, 5.4194618511E+00, 1.4192730643E+01, 3.4979826638E+00, 9.5875224188E-01],
	[3.6705000000E+04, 3.2369738532E+01, 5.4194865698E+00, 1.4199035354E+01, 3.4984644057E+00, 9.5877133863E-01],
	[3.6710000000E+04, 3.2377322426E+01, 5.4195112852E+00, 1.4205342005E+01, 3.4989460238E+00, 9.5879042561E-01],
	[3.6715000000E+04, 3.2384907064E+01, 5.4195359973E+00, 1.4211650597E+01, 3.4994275181E+00, 9.5880950283E-01],
	[3.6720000000E+04, 3.2392492445E+01, 5.4195607062E+00, 1.4217961130E+01, 3.4999088885E+00, 9.5882857028E-01],
	[3.6725000000E+04, 3.2400078570E+01, 5.4195854119E+00, 1.4224273604E+01, 3.5003901352E+00, 9.5884762799E-01],
	[3.6730000000E+04, 3.2407665439E+01, 5.4196101143E+00, 1.4230588019E+01, 3.5008712581E+00, 9.5886667594E-01],
	[3.6735000000E+04, 3.2415253051E+01, 5.4196348135E+00, 1.4236904376E+01, 3.5013522572E+00, 9.5888571414E-01],
	[3.6740000000E+04, 3.2422841406E+01, 5.4196595094E+00, 1.4243222676E+01, 3.5018331327E+00, 9.5890474261E-01],
	[3.6745000000E+04, 3.2430430505E+01, 5.4196842020E+00, 1.4249542917E+01, 3.5023138844E+00, 9.5892376135E-01],
	[3.6750000000E+04, 3.2438020347E+01, 5.4197088914E+00, 1.4255865102E+01, 3.5027945124E+00, 9.5894277035E-01],
	[3.6755000000E+04, 3.2445610932E+01, 5.4197335776E+00, 1.4262189230E+01, 3.5032750167E+00, 9.5896176963E-01],
	[3.6760000000E+04, 3.2453202261E+01, 5.4197582605E+00, 1.4268515301E+01, 3.5037553974E+00, 9.5898075920E-01],
	[3.6765000000E+04, 3.2460794334E+01, 5.4197829402E+00, 1.4274843316E+01, 3.5042356545E+00, 9.5899973905E-01],
	[3.6770000000E+04, 3.2468387149E+01, 5.4198076166E+00, 1.4281173276E+01, 3.5047157879E+00, 9.5901870919E-01],
	[3.6775000000E+04, 3.2475980708E+01, 5.4198322898E+00, 1.4287505179E+01, 3.5051957978E+00, 9.5903766963E-01],
	[3.6780000000E+04, 3.2483575010E+01, 5.4198569597E+00, 1.4293839028E+01, 3.5056756841E+00, 9.5905662037E-01],
	[3.6785000000E+04, 3.2491170055E+01, 5.4198816265E+00, 1.4300174822E+01, 3.5061554468E+00, 9.5907556142E-01],
	[3.6790000000E+04, 3.2498765843E+01, 5.4199062899E+00, 1.4306512561E+01, 3.5066350860E+00, 9.5909449279E-01],
	[3.6795000000E+04, 3.2506362375E+01, 5.4199309501E+00, 1.4312852246E+01, 3.5071146017E+00, 9.5911341447E-01],
	[3.6800000000E+04, 3.2513959649E+01, 5.4199556071E+00, 1.4319193877E+01, 3.5075939939E+00, 9.5913232647E-01],
	[3.6805000000E+04, 3.2521557667E+01, 5.4199802609E+00, 1.4325537455E+01, 3.5080732626E+00, 9.5915122880E-01],
	[3.6810000000E+04, 3.2529162011E+01, 5.4200056201E+00, 1.4331882979E+01, 3.5085527698E+00, 9.5917012147E-01],
	[3.6815000000E+04, 3.2536781516E+01, 5.4200328053E+00, 1.4338230451E+01, 3.5090330880E+00, 9.5918900447E-01],
	[3.6820000000E+04, 3.2544401771E+01, 5.4200599869E+00, 1.4344579870E+01, 3.5095132833E+00, 9.5920787782E-01],
	[3.6825000000E+04, 3.2552022775E+01, 5.4200871649E+00, 1.4350931237E+01, 3.5099933556E+00, 9.5922674152E-01],
	[3.6830000000E+04, 3.2559644528E+01, 5.4201143394E+00, 1.4357284552E+01, 3.5104733049E+00, 9.5924559557E-01],
	[3.6835000000E+04, 3.2567267031E+01, 5.4201415103E+00, 1.4363639815E+01, 3.5109531312E+00, 9.5926443999E-01],
	[3.6840000000E+04, 3.2574890284E+01, 5.4201686777E+00, 1.4369997028E+01, 3.5114328347E+00, 9.5928327476E-01],
	[3.6845000000E+04, 3.2582514286E+01, 5.4201958415E+00, 1.4376356189E+01, 3.5119124152E+00, 9.5930209991E-01],
	[3.6850000000E+04, 3.2590139038E+01, 5.4202230018E+00, 1.4382717300E+01, 3.5123918728E+00, 9.5932091543E-01],
	[3.6855000000E+04, 3.2597764539E+01, 5.4202501585E+00, 1.4389080361E+01, 3.5128712076E+00, 9.5933972133E-01],
	[3.6860000000E+04, 3.2605390789E+01, 5.4202773117E+00, 1.4395445372E+01, 3.5133504195E+00, 9.5935851762E-01],
	[3.6865000000E+04, 3.2613017789E+01, 5.4203044613E+00, 1.4401812333E+01, 3.5138295086E+00, 9.5937730430E-01],
	[3.6870000000E+04, 3.2620645538E+01, 5.4203316074E+00, 1.4408181245E+01, 3.5143084749E+00, 9.5939608137E-01],
	[3.6875000000E+04, 3.2628274037E+01, 5.4203587499E+00, 1.4414552108E+01, 3.5147873184E+00, 9.5941484884E-01],
	[3.6880000000E+04, 3.2635903284E+01, 5.4203858889E+00, 1.4420924923E+01, 3.5152660391E+00, 9.5943360672E-01],
	[3.6885000000E+04, 3.2643533281E+01, 5.4204130244E+00, 1.4427299690E+01, 3.5157446371E+00, 9.5945235501E-01],
	[3.6890000000E+04, 3.2651164028E+01, 5.4204401563E+00, 1.4433676408E+01, 3.5162231123E+00, 9.5947109372E-01],
	[3.6895000000E+04, 3.2658795523E+01, 5.4204672846E+00, 1.4440055079E+01, 3.5167014648E+00, 9.5948982285E-01],
	[3.6900000000E+04, 3.2666427768E+01, 5.4204944095E+00, 1.4446435703E+01, 3.5171796947E+00, 9.5950854241E-01],
	[3.6905000000E+04, 3.2674060762E+01, 5.4205215307E+00, 1.4452818280E+01, 3.5176578018E+00, 9.5952725239E-01],
	[3.6910000000E+04, 3.2681694505E+01, 5.4205486485E+00, 1.4459202811E+01, 3.5181357863E+00, 9.5954595282E-01],
	[3.6915000000E+04, 3.2689328997E+01, 5.4205757627E+00, 1.4465589295E+01, 3.5186136482E+00, 9.5956464368E-01],
	[3.6920000000E+04, 3.2696964238E+01, 5.4206028734E+00, 1.4471977733E+01, 3.5190913874E+00, 9.5958332500E-01],
	[3.6925000000E+04, 3.2704600228E+01, 5.4206299805E+00, 1.4478368126E+01, 3.5195690041E+00, 9.5960199676E-01],
	[3.6930000000E+04, 3.2712236967E+01, 5.4206570841E+00, 1.4484760474E+01, 3.5200464982E+00, 9.5962065899E-01],
	[3.6935000000E+04, 3.2719874456E+01, 5.4206841842E+00, 1.4491154777E+01, 3.5205238697E+00, 9.5963931168E-01],
	[3.6940000000E+04, 3.2727512693E+01, 5.4207112807E+00, 1.4497551035E+01, 3.5210011187E+00, 9.5965795483E-01],
	[3.6945000000E+04, 3.2735151679E+01, 5.4207383737E+00, 1.4503949249E+01, 3.5214782451E+00, 9.5967658846E-01],
	[3.6950000000E+04, 3.2742791414E+01, 5.4207654632E+00, 1.4510349419E+01, 3.5219552491E+00, 9.5969521256E-01],
	[3.6955000000E+04, 3.2750431898E+01, 5.4207925492E+00, 1.4516751546E+01, 3.5224321306E+00, 9.5971382715E-01],
	[3.6960000000E+04, 3.2758073131E+01, 5.4208196316E+00, 1.4523155629E+01, 3.5229088897E+00, 9.5973243223E-01],
	[3.6965000000E+04, 3.2765715112E+01, 5.4208467105E+00, 1.4529561670E+01, 3.5233855263E+00, 9.5975102780E-01],
	[3.6970000000E+04, 3.2773357842E+01, 5.4208737858E+00, 1.4535969667E+01, 3.5238620404E+00, 9.5976961387E-01],
	[3.6975000000E+04, 3.2781001322E+01, 5.4209008576E+00, 1.4542379623E+01, 3.5243384322E+00, 9.5978819045E-01],
	[3.6980000000E+04, 3.2788645549E+01, 5.4209279260E+00, 1.4548791537E+01, 3.5248147016E+00, 9.5980675753E-01],
	[3.6985000000E+04, 3.2796290526E+01, 5.4209549907E+00, 1.4555205409E+01, 3.5252908487E+00, 9.5982531513E-01],
	[3.6990000000E+04, 3.2803936251E+01, 5.4209820520E+00, 1.4561621240E+01, 3.5257668734E+00, 9.5984386324E-01],
	[3.6995000000E+04, 3.2811582725E+01, 5.4210091097E+00, 1.4568039031E+01, 3.5262427758E+00, 9.5986240188E-01],
	[3.7000000000E+04, 3.2819229948E+01, 5.4210361639E+00, 1.4574458780E+01, 3.5267185559E+00, 9.5988093105E-01],
	[3.7005000000E+04, 3.2826877919E+01, 5.4210632146E+00, 1.4580880490E+01, 3.5271942137E+00, 9.5989945076E-01],
	[3.7010000000E+04, 3.2834526638E+01, 5.4210902618E+00, 1.4587304159E+01, 3.5276697492E+00, 9.5991796101E-01],
	[3.7015000000E+04, 3.2842176107E+01, 5.4211173055E+00, 1.4593729789E+01, 3.5281451625E+00, 9.5993646180E-01],
	[3.7020000000E+04, 3.2849826323E+01, 5.4211443456E+00, 1.4600157380E+01, 3.5286204536E+00, 9.5995495314E-01],
	[3.7025000000E+04, 3.2857477289E+01, 5.4211713822E+00, 1.4606586932E+01, 3.5290956225E+00, 9.5997343503E-01],
	[3.7030000000E+04, 3.2865129002E+01, 5.4211984153E+00, 1.4613018445E+01, 3.5295706692E+00, 9.5999190749E-01],
	[3.7035000000E+04, 3.2872781465E+01, 5.4212254449E+00, 1.4619451920E+01, 3.5300455938E+00, 9.6001037051E-01],
	[3.7040000000E+04, 3.2880434675E+01, 5.4212524710E+00, 1.4625887357E+01, 3.5305203962E+00, 9.6002882410E-01],
	[3.7045000000E+04, 3.2888088634E+01, 5.4212794936E+00, 1.4632324757E+01, 3.5309950765E+00, 9.6004726827E-01],
	[3.7050000000E+04, 3.2895743341E+01, 5.4213065126E+00, 1.4638764120E+01, 3.5314696347E+00, 9.6006570302E-01],
	[3.7055000000E+04, 3.2903398797E+01, 5.4213335281E+00, 1.4645205445E+01, 3.5319440708E+00, 9.6008412836E-01],
	[3.7060000000E+04, 3.2911055001E+01, 5.4213605402E+00, 1.4651648734E+01, 3.5324183849E+00, 9.6010254428E-01],
	[3.7065000000E+04, 3.2918711953E+01, 5.4213875487E+00, 1.4658093987E+01, 3.5328925769E+00, 9.6012095081E-01],
	[3.7070000000E+04, 3.2926369653E+01, 5.4214145537E+00, 1.4664541204E+01, 3.5333666469E+00, 9.6013934793E-01],
	[3.7075000000E+04, 3.2934028102E+01, 5.4214415552E+00, 1.4670990385E+01, 3.5338405949E+00, 9.6015773566E-01],
	[3.7080000000E+04, 3.2941687298E+01, 5.4214685532E+00, 1.4677441531E+01, 3.5343144209E+00, 9.6017611400E-01],
	[3.7085000000E+04, 3.2949347243E+01, 5.4214955477E+00, 1.4683894642E+01, 3.5347881249E+00, 9.6019448296E-01],
	[3.7090000000E+04, 3.2957007936E+01, 5.4215225387E+00, 1.4690349719E+01, 3.5352617070E+00, 9.6021284254E-01],
	[3.7095000000E+04, 3.2964669377E+01, 5.4215495261E+00, 1.4696806761E+01, 3.5357351672E+00, 9.6023119275E-01],
	[3.7100000000E+04, 3.2972331567E+01, 5.4215765101E+00, 1.4703265770E+01, 3.5362085055E+00, 9.6024953359E-01],
	[3.7105000000E+04, 3.2979994504E+01, 5.4216034906E+00, 1.4709726745E+01, 3.5366817220E+00, 9.6026786507E-01],
	[3.7110000000E+04, 3.2987658189E+01, 5.4216304676E+00, 1.4716189687E+01, 3.5371548165E+00, 9.6028618719E-01],
	[3.7115000000E+04, 3.2995322622E+01, 5.4216574410E+00, 1.4722654595E+01, 3.5376277892E+00, 9.6030449996E-01],
	[3.7120000000E+04, 3.3002987804E+01, 5.4216844110E+00, 1.4729121472E+01, 3.5381006401E+00, 9.6032280338E-01],
	[3.7125000000E+04, 3.3010653733E+01, 5.4217113775E+00, 1.4735590316E+01, 3.5385733692E+00, 9.6034109745E-01],
	[3.7130000000E+04, 3.3018320410E+01, 5.4217383405E+00, 1.4742061128E+01, 3.5390459766E+00, 9.6035938219E-01],
	[3.7135000000E+04, 3.3025987835E+01, 5.4217653000E+00, 1.4748533908E+01, 3.5395184621E+00, 9.6037765760E-01],
	[3.7140000000E+04, 3.3033656007E+01, 5.4217922559E+00, 1.4755008658E+01, 3.5399908260E+00, 9.6039592368E-01],
	[3.7145000000E+04, 3.3041324928E+01, 5.4218192084E+00, 1.4761485376E+01, 3.5404630681E+00, 9.6041418044E-01],
	[3.7150000000E+04, 3.3048994596E+01, 5.4218461574E+00, 1.4767964064E+01, 3.5409351885E+00, 9.6043242788E-01],
	[3.7155000000E+04, 3.3056665012E+01, 5.4218731029E+00, 1.4774444722E+01, 3.5414071872E+00, 9.6045066601E-01],
	[3.7160000000E+04, 3.3064336176E+01, 5.4219000450E+00, 1.4780927349E+01, 3.5418790643E+00, 9.6046889484E-01],
	[3.7165000000E+04, 3.3072008088E+01, 5.4219269835E+00, 1.4787411948E+01, 3.5423508198E+00, 9.6048711436E-01],
	[3.7170000000E+04, 3.3079680747E+01, 5.4219539185E+00, 1.4793898517E+01, 3.5428224536E+00, 9.6050532458E-01],
	[3.7175000000E+04, 3.3087354154E+01, 5.4219808500E+00, 1.4800387057E+01, 3.5432939658E+00, 9.6052352552E-01],
	[3.7180000000E+04, 3.3095028308E+01, 5.4220077781E+00, 1.4806877568E+01, 3.5437653565E+00, 9.6054171716E-01],
	[3.7185000000E+04, 3.3102703210E+01, 5.4220347027E+00, 1.4813370052E+01, 3.5442366256E+00, 9.6055989953E-01],
	[3.7190000000E+04, 3.3110378860E+01, 5.4220616237E+00, 1.4819864507E+01, 3.5447077731E+00, 9.6057807262E-01],
	[3.7195000000E+04, 3.3118055257E+01, 5.4220885413E+00, 1.4826360935E+01, 3.5451787992E+00, 9.6059623644E-01],
	[3.7200000000E+04, 3.3125732402E+01, 5.4221154555E+00, 1.4832859335E+01, 3.5456497037E+00, 9.6061439099E-01],
	[3.7205000000E+04, 3.3133410294E+01, 5.4221423661E+00, 1.4839359709E+01, 3.5461204868E+00, 9.6063253629E-01],
	[3.7210000000E+04, 3.3141088934E+01, 5.4221692732E+00, 1.4845862056E+01, 3.5465911485E+00, 9.6065067232E-01],
	[3.7215000000E+04, 3.3148768321E+01, 5.4221961769E+00, 1.4852366377E+01, 3.5470616887E+00, 9.6066879911E-01],
	[3.7220000000E+04, 3.3156448456E+01, 5.4222230771E+00, 1.4858872672E+01, 3.5475321074E+00, 9.6068691665E-01],
	[3.7225000000E+04, 3.3164129338E+01, 5.4222499738E+00, 1.4865380941E+01, 3.5480024048E+00, 9.6070502495E-01],
	[3.7230000000E+04, 3.3171810967E+01, 5.4222768670E+00, 1.4871891186E+01, 3.5484725809E+00, 9.6072312401E-01],
	[3.7235000000E+04, 3.3179493343E+01, 5.4223037567E+00, 1.4878403405E+01, 3.5489426355E+00, 9.6074121384E-01],
	[3.7240000000E+04, 3.3187176467E+01, 5.4223306430E+00, 1.4884917600E+01, 3.5494125689E+00, 9.6075929445E-01],
	[3.7245000000E+04, 3.3194860338E+01, 5.4223575258E+00, 1.4891433770E+01, 3.5498823809E+00, 9.6077736584E-01],
	[3.7250000000E+04, 3.3202544957E+01, 5.4223844051E+00, 1.4897951917E+01, 3.5503520717E+00, 9.6079542801E-01],
	[3.7255000000E+04, 3.3210230322E+01, 5.4224112809E+00, 1.4904472040E+01, 3.5508216411E+00, 9.6081348097E-01],
	[3.7260000000E+04, 3.3217916435E+01, 5.4224381533E+00, 1.4910994140E+01, 3.5512910894E+00, 9.6083152473E-01],
	[3.7265000000E+04, 3.3225603295E+01, 5.4224650222E+00, 1.4917518216E+01, 3.5517604163E+00, 9.6084955929E-01],
	[3.7270000000E+04, 3.3233290902E+01, 5.4224918876E+00, 1.4924044271E+01, 3.5522296221E+00, 9.6086758465E-01],
	[3.7275000000E+04, 3.3240979256E+01, 5.4225187496E+00, 1.4930572303E+01, 3.5526987067E+00, 9.6088560082E-01],
	[3.7280000000E+04, 3.3248668357E+01, 5.4225456081E+00, 1.4937102313E+01, 3.5531676702E+00, 9.6090360781E-01],
	[3.7285000000E+04, 3.3256358206E+01, 5.4225724631E+00, 1.4943634302E+01, 3.5536365125E+00, 9.6092160562E-01],
	[3.7290000000E+04, 3.3264048801E+01, 5.4225993146E+00, 1.4950168269E+01, 3.5541052336E+00, 9.6093959425E-01],
	[3.7295000000E+04, 3.3271740143E+01, 5.4226261627E+00, 1.4956704216E+01, 3.5545738337E+00, 9.6095757372E-01],
	[3.7300000000E+04, 3.3279432232E+01, 5.4226530073E+00, 1.4963242142E+01, 3.5550423127E+00, 9.6097554401E-01],
	[3.7305000000E+04, 3.3287125068E+01, 5.4226798484E+00, 1.4969782047E+01, 3.5555106706E+00, 9.6099350515E-01],
	[3.7310000000E+04, 3.3294818651E+01, 5.4227066861E+00, 1.4976323933E+01, 3.5559789075E+00, 9.6101145714E-01],
	[3.7315000000E+04, 3.3302512981E+01, 5.4227335203E+00, 1.4982867799E+01, 3.5564470233E+00, 9.6102939997E-01],
	[3.7320000000E+04, 3.3310208058E+01, 5.4227603511E+00, 1.4989413646E+01, 3.5569150182E+00, 9.6104733366E-01],
	[3.7325000000E+04, 3.3317903882E+01, 5.4227871784E+00, 1.4995961475E+01, 3.5573828921E+00, 9.6106525821E-01],
	[3.7330000000E+04, 3.3325600452E+01, 5.4228140022E+00, 1.5002511284E+01, 3.5578506450E+00, 9.6108317363E-01],
	[3.7335000000E+04, 3.3333297769E+01, 5.4228408226E+00, 1.5009063075E+01, 3.5583182770E+00, 9.6110107992E-01],
	[3.7340000000E+04, 3.3340995833E+01, 5.4228676395E+00, 1.5015616849E+01, 3.5587857880E+00, 9.6111897708E-01],
	[3.7345000000E+04, 3.3348694644E+01, 5.4228944530E+00, 1.5022172605E+01, 3.5592531782E+00, 9.6113686513E-01],
	[3.7350000000E+04, 3.3356394201E+01, 5.4229212630E+00, 1.5028730343E+01, 3.5597204475E+00, 9.6115474406E-01],
	[3.7355000000E+04, 3.3364094505E+01, 5.4229480695E+00, 1.5035290065E+01, 3.5601875959E+00, 9.6117261388E-01],
	[3.7360000000E+04, 3.3371795556E+01, 5.4229748726E+00, 1.5041851770E+01, 3.5606546235E+00, 9.6119047459E-01],
	[3.7365000000E+04, 3.3379497353E+01, 5.4230016722E+00, 1.5048415459E+01, 3.5611215303E+00, 9.6120832621E-01],
	[3.7370000000E+04, 3.3387199897E+01, 5.4230284684E+00, 1.5054981132E+01, 3.5615883162E+00, 9.6122616874E-01],
	[3.7375000000E+04, 3.3394903187E+01, 5.4230552611E+00, 1.5061548790E+01, 3.5620549815E+00, 9.6124400217E-01],
	[3.7380000000E+04, 3.3402607224E+01, 5.4230820504E+00, 1.5068118432E+01, 3.5625215259E+00, 9.6126182652E-01],
	[3.7385000000E+04, 3.3410312007E+01, 5.4231088362E+00, 1.5074690060E+01, 3.5629879497E+00, 9.6127964179E-01],
	[3.7390000000E+04, 3.3418017537E+01, 5.4231356186E+00, 1.5081263672E+01, 3.5634542527E+00, 9.6129744799E-01],
	[3.7395000000E+04, 3.3425723813E+01, 5.4231623975E+00, 1.5087839271E+01, 3.5639204350E+00, 9.6131524512E-01],
	[3.7400000000E+04, 3.3433430836E+01, 5.4231891730E+00, 1.5094416856E+01, 3.5643864967E+00, 9.6133303318E-01],
	[3.7405000000E+04, 3.3441153740E+01, 5.4232178451E+00, 1.5100996427E+01, 3.5648534307E+00, 9.6135081219E-01],
	[3.7410000000E+04, 3.3448882031E+01, 5.4232470953E+00, 1.5107577985E+01, 3.5653205485E+00, 9.6136858214E-01],
	[3.7415000000E+04, 3.3456611074E+01, 5.4232763418E+00, 1.5114161530E+01, 3.5657875461E+00, 9.6138634305E-01],
	[3.7420000000E+04, 3.3464340870E+01, 5.4233055846E+00, 1.5120747062E+01, 3.5662544235E+00, 9.6140409491E-01],
	[3.7425000000E+04, 3.3472071419E+01, 5.4233348236E+00, 1.5127334583E+01, 3.5667211807E+00, 9.6142183773E-01],
	[3.7430000000E+04, 3.3479802721E+01, 5.4233640588E+00, 1.5133924091E+01, 3.5671878178E+00, 9.6143957151E-01],
	[3.7435000000E+04, 3.3487534776E+01, 5.4233932903E+00, 1.5140515588E+01, 3.5676543347E+00, 9.6145729627E-01],
	[3.7440000000E+04, 3.3495267583E+01, 5.4234225180E+00, 1.5147109073E+01, 3.5681207315E+00, 9.6147501201E-01],
	[3.7445000000E+04, 3.3503001143E+01, 5.4234517420E+00, 1.5153704548E+01, 3.5685870083E+00, 9.6149271872E-01],
	[3.7450000000E+04, 3.3510735455E+01, 5.4234809623E+00, 1.5160302012E+01, 3.5690531649E+00, 9.6151041642E-01],
	[3.7455000000E+04, 3.3518470520E+01, 5.4235101788E+00, 1.5166901466E+01, 3.5695192015E+00, 9.6152810512E-01],
	[3.7460000000E+04, 3.3526206338E+01, 5.4235393916E+00, 1.5173502910E+01, 3.5699851181E+00, 9.6154578481E-01],
	[3.7465000000E+04, 3.3533942908E+01, 5.4235686006E+00, 1.5180106345E+01, 3.5704509147E+00, 9.6156345550E-01],
	[3.7470000000E+04, 3.3541680231E+01, 5.4235978059E+00, 1.5186711770E+01, 3.5709165913E+00, 9.6158111720E-01],
	[3.7475000000E+04, 3.3549418306E+01, 5.4236270074E+00, 1.5193319186E+01, 3.5713821479E+00, 9.6159876990E-01],
	[3.7480000000E+04, 3.3557157133E+01, 5.4236562053E+00, 1.5199928594E+01, 3.5718475846E+00, 9.6161641363E-01],
	[3.7485000000E+04, 3.3564896713E+01, 5.4236853993E+00, 1.5206539994E+01, 3.5723129014E+00, 9.6163404837E-01],
	[3.7490000000E+04, 3.3572637046E+01, 5.4237145897E+00, 1.5213153385E+01, 3.5727780983E+00, 9.6165167415E-01],
	[3.7495000000E+04, 3.3580378131E+01, 5.4237437763E+00, 1.5219768769E+01, 3.5732431752E+00, 9.6166929095E-01],
	[3.7500000000E+04, 3.3588119968E+01, 5.4237729591E+00, 1.5226386146E+01, 3.5737081324E+00, 9.6168689879E-01],
	[3.7505000000E+04, 3.3595862557E+01, 5.4238021383E+00, 1.5233005516E+01, 3.5741729696E+00, 9.6170449767E-01],
	[3.7510000000E+04, 3.3603605899E+01, 5.4238313137E+00, 1.5239626880E+01, 3.5746376871E+00, 9.6172208760E-01],
	[3.7515000000E+04, 3.3611349993E+01, 5.4238604853E+00, 1.5246250237E+01, 3.5751022848E+00, 9.6173966858E-01],
	[3.7520000000E+04, 3.3619094839E+01, 5.4238896533E+00, 1.5252875589E+01, 3.5755667627E+00, 9.6175724061E-01],
	[3.7525000000E+04, 3.3626840438E+01, 5.4239188175E+00, 1.5259502935E+01, 3.5760311208E+00, 9.6177480371E-01],
	[3.7530000000E+04, 3.3634586789E+01, 5.4239479779E+00, 1.5266132275E+01, 3.5764953592E+00, 9.6179235787E-01],
	[3.7535000000E+04, 3.3642333891E+01, 5.4239771347E+00, 1.5272763611E+01, 3.5769594779E+00, 9.6180990310E-01],
	[3.7540000000E+04, 3.3650081746E+01, 5.4240062877E+00, 1.5279396942E+01, 3.5774234769E+00, 9.6182743941E-01],
	[3.7545000000E+04, 3.3657830353E+01, 5.4240354370E+00, 1.5286032269E+01, 3.5778873562E+00, 9.6184496680E-01],
	[3.7550000000E+04, 3.3665579712E+01, 5.4240645826E+00, 1.5292669592E+01, 3.5783511159E+00, 9.6186248528E-01],
	[3.7555000000E+04, 3.3673329824E+01, 5.4240937244E+00, 1.5299308912E+01, 3.5788147559E+00, 9.6187999485E-01],
	[3.7560000000E+04, 3.3681080687E+01, 5.4241228625E+00, 1.5305950228E+01, 3.5792782763E+00, 9.6189749551E-01],
	[3.7565000000E+04, 3.3688832302E+01, 5.4241519970E+00, 1.5312593542E+01, 3.5797416772E+00, 9.6191498728E-01],
	[3.7570000000E+04, 3.3696584669E+01, 5.4241811276E+00, 1.5319238853E+01, 3.5802049584E+00, 9.6193247015E-01],
	[3.7575000000E+04, 3.3704337788E+01, 5.4242102546E+00, 1.5325886162E+01, 3.5806681202E+00, 9.6194994413E-01],
	[3.7580000000E+04, 3.3712091659E+01, 5.4242393778E+00, 1.5332535469E+01, 3.5811311624E+00, 9.6196740922E-01],
	[3.7585000000E+04, 3.3719846282E+01, 5.4242684974E+00, 1.5339186774E+01, 3.5815940851E+00, 9.6198486544E-01],
	[3.7590000000E+04, 3.3727601657E+01, 5.4242976132E+00, 1.5345840078E+01, 3.5820568883E+00, 9.6200231278E-01],
	[3.7595000000E+04, 3.3735357784E+01, 5.4243267252E+00, 1.5352495381E+01, 3.5825195721E+00, 9.6201975124E-01],
	[3.7600000000E+04, 3.3743114662E+01, 5.4243558336E+00, 1.5359152684E+01, 3.5829821364E+00, 9.6203718084E-01],
	[3.7605000000E+04, 3.3750872292E+01, 5.4243849383E+00, 1.5365811987E+01, 3.5834445813E+00, 9.6205460158E-01],
	[3.7610000000E+04, 3.3758630674E+01, 5.4244140392E+00, 1.5372473289E+01, 3.5839069068E+00, 9.6207201345E-01],
	[3.7615000000E+04, 3.3766389808E+01, 5.4244431365E+00, 1.5379136592E+01, 3.5843691129E+00, 9.6208941647E-01],
	[3.7620000000E+04, 3.3774149693E+01, 5.4244722300E+00, 1.5385801896E+01, 3.5848311997E+00, 9.6210681064E-01],
	[3.7625000000E+04, 3.3781910330E+01, 5.4245013198E+00, 1.5392469201E+01, 3.5852931671E+00, 9.6212419596E-01],
	[3.7630000000E+04, 3.3789671719E+01, 5.4245304059E+00, 1.5399138508E+01, 3.5857550153E+00, 9.6214157244E-01],
	[3.7635000000E+04, 3.3797433859E+01, 5.4245594883E+00, 1.5405809816E+01, 3.5862167441E+00, 9.6215894008E-01],
	[3.7640000000E+04, 3.3805196751E+01, 5.4245885670E+00, 1.5412483127E+01, 3.5866783537E+00, 9.6217629889E-01],
	[3.7645000000E+04, 3.3812960394E+01, 5.4246176420E+00, 1.5419158440E+01, 3.5871398440E+00, 9.6219364888E-01],
	[3.7650000000E+04, 3.3820724789E+01, 5.4246467132E+00, 1.5425835756E+01, 3.5876012151E+00, 9.6221099003E-01],
	[3.7655000000E+04, 3.3828489935E+01, 5.4246757808E+00, 1.5432515074E+01, 3.5880624670E+00, 9.6222832237E-01],
	[3.7660000000E+04, 3.3836255833E+01, 5.4247048447E+00, 1.5439196397E+01, 3.5885235997E+00, 9.6224564589E-01],
	[3.7665000000E+04, 3.3844022483E+01, 5.4247339048E+00, 1.5445879723E+01, 3.5889846132E+00, 9.6226296061E-01],
	[3.7670000000E+04, 3.3851789884E+01, 5.4247629613E+00, 1.5452565053E+01, 3.5894455076E+00, 9.6228026651E-01],
	[3.7675000000E+04, 3.3859558036E+01, 5.4247920140E+00, 1.5459252388E+01, 3.5899062829E+00, 9.6229756362E-01],
	[3.7680000000E+04, 3.3867326939E+01, 5.4248210631E+00, 1.5465941728E+01, 3.5903669390E+00, 9.6231485192E-01],
	[3.7685000000E+04, 3.3875096594E+01, 5.4248501085E+00, 1.5472633073E+01, 3.5908274761E+00, 9.6233213144E-01],
	[3.7690000000E+04, 3.3882867000E+01, 5.4248791501E+00, 1.5479326423E+01, 3.5912878942E+00, 9.6234940216E-01],
	[3.7695000000E+04, 3.3890638158E+01, 5.4249081881E+00, 1.5486021779E+01, 3.5917481932E+00, 9.6236666410E-01],
	[3.7700000000E+04, 3.3898410067E+01, 5.4249372224E+00, 1.5492719141E+01, 3.5922083732E+00, 9.6238391727E-01],
	[3.7705000000E+04, 3.3906182727E+01, 5.4249662529E+00, 1.5499418510E+01, 3.5926684341E+00, 9.6240116165E-01],
	[3.7710000000E+04, 3.3913956138E+01, 5.4249952798E+00, 1.5506119885E+01, 3.5931283762E+00, 9.6241839727E-01],
	[3.7715000000E+04, 3.3921730300E+01, 5.4250243030E+00, 1.5512823268E+01, 3.5935881992E+00, 9.6243562412E-01],
	[3.7720000000E+04, 3.3929505214E+01, 5.4250533225E+00, 1.5519528658E+01, 3.5940479034E+00, 9.6245284220E-01],
	[3.7725000000E+04, 3.3937280879E+01, 5.4250823383E+00, 1.5526236056E+01, 3.5945074886E+00, 9.6247005153E-01],
	[3.7730000000E+04, 3.3945057294E+01, 5.4251113504E+00, 1.5532945462E+01, 3.5949669550E+00, 9.6248725211E-01],
	[3.7735000000E+04, 3.3952834461E+01, 5.4251403588E+00, 1.5539656877E+01, 3.5954263025E+00, 9.6250444394E-01],
	[3.7740000000E+04, 3.3960612379E+01, 5.4251693636E+00, 1.5546370300E+01, 3.5958855311E+00, 9.6252162702E-01],
	[3.7745000000E+04, 3.3968391048E+01, 5.4251983646E+00, 1.5553085733E+01, 3.5963446409E+00, 9.6253880136E-01],
	[3.7750000000E+04, 3.3976170468E+01, 5.4252273620E+00, 1.5559803175E+01, 3.5968036319E+00, 9.6255596697E-01],
	[3.7755000000E+04, 3.3983950639E+01, 5.4252563557E+00, 1.5566522627E+01, 3.5972625042E+00, 9.6257312385E-01],
	[3.7760000000E+04, 3.3991731561E+01, 5.4252853457E+00, 1.5573244089E+01, 3.5977212577E+00, 9.6259027200E-01],
	[3.7765000000E+04, 3.3999513233E+01, 5.4253143320E+00, 1.5579967562E+01, 3.5981798924E+00, 9.6260741142E-01],
	[3.7770000000E+04, 3.4007295657E+01, 5.4253433146E+00, 1.5586693045E+01, 3.5986384085E+00, 9.6262454213E-01],
	[3.7775000000E+04, 3.4015078832E+01, 5.4253722935E+00, 1.5593420540E+01, 3.5990968058E+00, 9.6264166413E-01],
	[3.7780000000E+04, 3.4022862757E+01, 5.4254012688E+00, 1.5600150046E+01, 3.5995550845E+00, 9.6265877742E-01],
	[3.7785000000E+04, 3.4030647433E+01, 5.4254302404E+00, 1.5606881564E+01, 3.6000132445E+00, 9.6267588200E-01],
	[3.7790000000E+04, 3.4038432860E+01, 5.4254592083E+00, 1.5613615094E+01, 3.6004712859E+00, 9.6269297788E-01],
	[3.7795000000E+04, 3.4046219037E+01, 5.4254881725E+00, 1.5620350636E+01, 3.6009292087E+00, 9.6271006507E-01],
	[3.7800000000E+04, 3.4054005966E+01, 5.4255171331E+00, 1.5627088192E+01, 3.6013870129E+00, 9.6272714357E-01],
	[3.7805000000E+04, 3.4061793645E+01, 5.4255460899E+00, 1.5633827760E+01, 3.6018446985E+00, 9.6274421338E-01],
	[3.7810000000E+04, 3.4069582075E+01, 5.4255750431E+00, 1.5640569342E+01, 3.6023022657E+00, 9.6276127450E-01],
	[3.7815000000E+04, 3.4077371255E+01, 5.4256039927E+00, 1.5647312938E+01, 3.6027597142E+00, 9.6277832695E-01],
	[3.7820000000E+04, 3.4085161186E+01, 5.4256329385E+00, 1.5654058548E+01, 3.6032170443E+00, 9.6279537073E-01],
	[3.7825000000E+04, 3.4092951868E+01, 5.4256618807E+00, 1.5660806173E+01, 3.6036742559E+00, 9.6281240584E-01],
	[3.7830000000E+04, 3.4100743300E+01, 5.4256908192E+00, 1.5667555813E+01, 3.6041313491E+00, 9.6282943228E-01],
	[3.7835000000E+04, 3.4108535482E+01, 5.4257197540E+00, 1.5674307467E+01, 3.6045883238E+00, 9.6284645006E-01],
	[3.7840000000E+04, 3.4116328415E+01, 5.4257486852E+00, 1.5681061137E+01, 3.6050451801E+00, 9.6286345918E-01],
	[3.7845000000E+04, 3.4124122099E+01, 5.4257776127E+00, 1.5687816823E+01, 3.6055019180E+00, 9.6288045966E-01],
	[3.7850000000E+04, 3.4131916533E+01, 5.4258065365E+00, 1.5694574526E+01, 3.6059585376E+00, 9.6289745149E-01],
	[3.7855000000E+04, 3.4139711718E+01, 5.4258354567E+00, 1.5701334244E+01, 3.6064150388E+00, 9.6291443467E-01],
	[3.7860000000E+04, 3.4147507653E+01, 5.4258643732E+00, 1.5708095980E+01, 3.6068714217E+00, 9.6293140922E-01],
	[3.7865000000E+04, 3.4155304338E+01, 5.4258932861E+00, 1.5714859733E+01, 3.6073276863E+00, 9.6294837513E-01],
	[3.7870000000E+04, 3.4163101774E+01, 5.4259221952E+00, 1.5721625503E+01, 3.6077838326E+00, 9.6296533241E-01],
	[3.7875000000E+04, 3.4170899960E+01, 5.4259511007E+00, 1.5728393291E+01, 3.6082398606E+00, 9.6298228107E-01],
	[3.7880000000E+04, 3.4178698896E+01, 5.4259800026E+00, 1.5735163098E+01, 3.6086957704E+00, 9.6299922111E-01],
	[3.7885000000E+04, 3.4186498582E+01, 5.4260089008E+00, 1.5741934922E+01, 3.6091515620E+00, 9.6301615253E-01],
	[3.7890000000E+04, 3.4194299019E+01, 5.4260377953E+00, 1.5748708766E+01, 3.6096072354E+00, 9.6303307534E-01],
	[3.7895000000E+04, 3.4202100206E+01, 5.4260666862E+00, 1.5755484629E+01, 3.6100627906E+00, 9.6304998954E-01],
	[3.7900000000E+04, 3.4209902143E+01, 5.4260955734E+00, 1.5762262512E+01, 3.6105182277E+00, 9.6306689514E-01],
	[3.7905000000E+04, 3.4217704831E+01, 5.4261244569E+00, 1.5769042414E+01, 3.6109735466E+00, 9.6308379214E-01],
	[3.7910000000E+04, 3.4225508268E+01, 5.4261533368E+00, 1.5775824336E+01, 3.6114287474E+00, 9.6310068055E-01],
	[3.7915000000E+04, 3.4233312456E+01, 5.4261822131E+00, 1.5782608280E+01, 3.6118838302E+00, 9.6311756037E-01],
	[3.7920000000E+04, 3.4241117393E+01, 5.4262110857E+00, 1.5789394243E+01, 3.6123387949E+00, 9.6313443160E-01],
	[3.7925000000E+04, 3.4248923081E+01, 5.4262399546E+00, 1.5796182229E+01, 3.6127936415E+00, 9.6315129425E-01],
	[3.7930000000E+04, 3.4256729519E+01, 5.4262688199E+00, 1.5802972235E+01, 3.6132483702E+00, 9.6316814833E-01],
	[3.7935000000E+04, 3.4264536706E+01, 5.4262976815E+00, 1.5809764264E+01, 3.6137029808E+00, 9.6318499383E-01],
	[3.7940000000E+04, 3.4272344644E+01, 5.4263265395E+00, 1.5816558315E+01, 3.6141574734E+00, 9.6320183076E-01],
	[3.7945000000E+04, 3.4280153332E+01, 5.4263553938E+00, 1.5823354388E+01, 3.6146118481E+00, 9.6321865914E-01],
	[3.7950000000E+04, 3.4287962769E+01, 5.4263842445E+00, 1.5830152484E+01, 3.6150661049E+00, 9.6323547895E-01],
	[3.7955000000E+04, 3.4295772957E+01, 5.4264130916E+00, 1.5836952604E+01, 3.6155202438E+00, 9.6325229021E-01],
	[3.7960000000E+04, 3.4303583894E+01, 5.4264419350E+00, 1.5843754747E+01, 3.6159742647E+00, 9.6326909292E-01],
	[3.7965000000E+04, 3.4311395581E+01, 5.4264707747E+00, 1.5850558914E+01, 3.6164281678E+00, 9.6328588708E-01],
	[3.7970000000E+04, 3.4319208018E+01, 5.4264996108E+00, 1.5857365105E+01, 3.6168819531E+00, 9.6330267271E-01],
	[3.7975000000E+04, 3.4327021205E+01, 5.4265284433E+00, 1.5864173320E+01, 3.6173356205E+00, 9.6331944979E-01],
	[3.7980000000E+04, 3.4334835141E+01, 5.4265572721E+00, 1.5870983561E+01, 3.6177891702E+00, 9.6333621835E-01],
	[3.7985000000E+04, 3.4342649827E+01, 5.4265860972E+00, 1.5877795827E+01, 3.6182426020E+00, 9.6335297837E-01],
	[3.7990000000E+04, 3.4350465263E+01, 5.4266149188E+00, 1.5884610118E+01, 3.6186959161E+00, 9.6336972987E-01],
	[3.7995000000E+04, 3.4358281449E+01, 5.4266437367E+00, 1.5891426435E+01, 3.6191491125E+00, 9.6338647286E-01],
	[3.8000000000E+04, 3.4366098384E+01, 5.4266725509E+00, 1.5898244779E+01, 3.6196021912E+00, 9.6340320733E-01],
	[3.8005000000E+04, 3.4373922788E+01, 5.4267021964E+00, 1.5905065149E+01, 3.6200555982E+00, 9.6341993328E-01],
	[3.8010000000E+04, 3.4381760759E+01, 5.4267334304E+00, 1.5911887545E+01, 3.6205097385E+00, 9.6343665074E-01],
	[3.8015000000E+04, 3.4389599487E+01, 5.4267646604E+00, 1.5918711970E+01, 3.6209637615E+00, 9.6345335969E-01],
	[3.8020000000E+04, 3.4397438970E+01, 5.4267958865E+00, 1.5925538421E+01, 3.6214176672E+00, 9.6347006014E-01],
	[3.8025000000E+04, 3.4405279209E+01, 5.4268271087E+00, 1.5932366901E+01, 3.6218714557E+00, 9.6348675210E-01],
	[3.8030000000E+04, 3.4413120204E+01, 5.4268583269E+00, 1.5939197409E+01, 3.6223251270E+00, 9.6350343557E-01],
	[3.8035000000E+04, 3.4420961955E+01, 5.4268895412E+00, 1.5946029945E+01, 3.6227786811E+00, 9.6352011056E-01],
	[3.8040000000E+04, 3.4428804462E+01, 5.4269207516E+00, 1.5952864511E+01, 3.6232321181E+00, 9.6353677707E-01],
	[3.8045000000E+04, 3.4436647724E+01, 5.4269519581E+00, 1.5959701105E+01, 3.6236854379E+00, 9.6355343511E-01],
	[3.8050000000E+04, 3.4444491742E+01, 5.4269831607E+00, 1.5966539729E+01, 3.6241386405E+00, 9.6357008467E-01],
	[3.8055000000E+04, 3.4452336515E+01, 5.4270143593E+00, 1.5973380384E+01, 3.6245917261E+00, 9.6358672577E-01],
	[3.8060000000E+04, 3.4460182045E+01, 5.4270455540E+00, 1.5980223068E+01, 3.6250446946E+00, 9.6360335840E-01],
	[3.8065000000E+04, 3.4468028330E+01, 5.4270767448E+00, 1.5987067783E+01, 3.6254975460E+00, 9.6361998258E-01],
	[3.8070000000E+04, 3.4475875370E+01, 5.4271079317E+00, 1.5993914529E+01, 3.6259502804E+00, 9.6363659831E-01],
	[3.8075000000E+04, 3.4483723166E+01, 5.4271391146E+00, 1.6000763306E+01, 3.6264028978E+00, 9.6365320558E-01],
	[3.8080000000E+04, 3.4491571718E+01, 5.4271702937E+00, 1.6007614115E+01, 3.6268553982E+00, 9.6366980442E-01],
	[3.8085000000E+04, 3.4499421025E+01, 5.4272014688E+00, 1.6014466955E+01, 3.6273077816E+00, 9.6368639481E-01],
	[3.8090000000E+04, 3.4507271088E+01, 5.4272326400E+00, 1.6021321828E+01, 3.6277600480E+00, 9.6370297677E-01],
	[3.8095000000E+04, 3.4515121906E+01, 5.4272638073E+00, 1.6028178734E+01, 3.6282121976E+00, 9.6371955029E-01],
	[3.8100000000E+04, 3.4522973480E+01, 5.4272949707E+00, 1.6035037672E+01, 3.6286642302E+00, 9.6373611539E-01],
	[3.8105000000E+04, 3.4530825809E+01, 5.4273261302E+00, 1.6041898644E+01, 3.6291161459E+00, 9.6375267207E-01],
	[3.8110000000E+04, 3.4538678893E+01, 5.4273572858E+00, 1.6048761649E+01, 3.6295679448E+00, 9.6376922032E-01],
	[3.8115000000E+04, 3.4546532733E+01, 5.4273884375E+00, 1.6055626688E+01, 3.6300196269E+00, 9.6378576017E-01],
	[3.8120000000E+04, 3.4554387328E+01, 5.4274195852E+00, 1.6062493762E+01, 3.6304711921E+00, 9.6380229161E-01],
	[3.8125000000E+04, 3.4562242678E+01, 5.4274507291E+00, 1.6069362870E+01, 3.6309226405E+00, 9.6381881464E-01],
	[3.8130000000E+04, 3.4570098784E+01, 5.4274818690E+00, 1.6076234013E+01, 3.6313739722E+00, 9.6383532927E-01],
	[3.8135000000E+04, 3.4577955645E+01, 5.4275130051E+00, 1.6083107191E+01, 3.6318251871E+00, 9.6385183550E-01],
	[3.8140000000E+04, 3.4585813261E+01, 5.4275441372E+00, 1.6089982405E+01, 3.6322762853E+00, 9.6386833335E-01],
	[3.8145000000E+04, 3.4593671633E+01, 5.4275752654E+00, 1.6096859655E+01, 3.6327272668E+00, 9.6388482280E-01],
	[3.8150000000E+04, 3.4601530759E+01, 5.4276063898E+00, 1.6103738942E+01, 3.6331781316E+00, 9.6390130387E-01],
	[3.8155000000E+04, 3.4609390641E+01, 5.4276375102E+00, 1.6110620264E+01, 3.6336288797E+00, 9.6391777657E-01],
	[3.8160000000E+04, 3.4617251278E+01, 5.4276686267E+00, 1.6117503624E+01, 3.6340795112E+00, 9.6393424089E-01],
	[3.8165000000E+04, 3.4625112670E+01, 5.4276997394E+00, 1.6124389021E+01, 3.6345300261E+00, 9.6395069684E-01],
	[3.8170000000E+04, 3.4632974817E+01, 5.4277308481E+00, 1.6131276456E+01, 3.6349804243E+00, 9.6396714443E-01],
	[3.8175000000E+04, 3.4640837719E+01, 5.4277619529E+00, 1.6138165929E+01, 3.6354307060E+00, 9.6398358365E-01],
	[3.8180000000E+04, 3.4648701376E+01, 5.4277930539E+00, 1.6145057440E+01, 3.6358808712E+00, 9.6400001452E-01],
	[3.8185000000E+04, 3.4656565788E+01, 5.4278241509E+00, 1.6151950989E+01, 3.6363309198E+00, 9.6401643704E-01],
	[3.8190000000E+04, 3.4664430956E+01, 5.4278552441E+00, 1.6158846578E+01, 3.6367808519E+00, 9.6403285120E-01],
	[3.8195000000E+04, 3.4672296878E+01, 5.4278863334E+00, 1.6165744206E+01, 3.6372306675E+00, 9.6404925703E-01],
	[3.8200000000E+04, 3.4680163555E+01, 5.4279174187E+00, 1.6172643873E+01, 3.6376803667E+00, 9.6406565452E-01],
	[3.8205000000E+04, 3.4688030986E+01, 5.4279485002E+00, 1.6179545581E+01, 3.6381299494E+00, 9.6408204367E-01],
	[3.8210000000E+04, 3.4695899173E+01, 5.4279795778E+00, 1.6186449329E+01, 3.6385794157E+00, 9.6409842449E-01],
	[3.8215000000E+04, 3.4703768115E+01, 5.4280106515E+00, 1.6193355117E+01, 3.6390287656E+00, 9.6411479698E-01],
	[3.8220000000E+04, 3.4711637811E+01, 5.4280417213E+00, 1.6200262947E+01, 3.6394779991E+00, 9.6413116116E-01],
	[3.8225000000E+04, 3.4719508262E+01, 5.4280727873E+00, 1.6207172817E+01, 3.6399271163E+00, 9.6414751701E-01],
	[3.8230000000E+04, 3.4727379468E+01, 5.4281038493E+00, 1.6214084730E+01, 3.6403761171E+00, 9.6416386456E-01],
	[3.8235000000E+04, 3.4735251429E+01, 5.4281349075E+00, 1.6220998684E+01, 3.6408250017E+00, 9.6418020379E-01],
	[3.8240000000E+04, 3.4743124144E+01, 5.4281659618E+00, 1.6227914681E+01, 3.6412737699E+00, 9.6419653472E-01],
	[3.8245000000E+04, 3.4750997614E+01, 5.4281970122E+00, 1.6234832720E+01, 3.6417224219E+00, 9.6421285736E-01],
	[3.8250000000E+04, 3.4758871839E+01, 5.4282280587E+00, 1.6241752803E+01, 3.6421709577E+00, 9.6422917169E-01],
	[3.8255000000E+04, 3.4766746818E+01, 5.4282591013E+00, 1.6248674929E+01, 3.6426193772E+00, 9.6424547774E-01],
	[3.8260000000E+04, 3.4774622552E+01, 5.4282901401E+00, 1.6255599098E+01, 3.6430676805E+00, 9.6426177550E-01],
	[3.8265000000E+04, 3.4782499040E+01, 5.4283211749E+00, 1.6262525311E+01, 3.6435158677E+00, 9.6427806498E-01],
	[3.8270000000E+04, 3.4790376283E+01, 5.4283522059E+00, 1.6269453569E+01, 3.6439639387E+00, 9.6429434617E-01],
	[3.8275000000E+04, 3.4798254281E+01, 5.4283832330E+00, 1.6276383872E+01, 3.6444118936E+00, 9.6431061910E-01],
	[3.8280000000E+04, 3.4806133033E+01, 5.4284142563E+00, 1.6283316219E+01, 3.6448597323E+00, 9.6432688376E-01],
	[3.8285000000E+04, 3.4814012539E+01, 5.4284452757E+00, 1.6290250612E+01, 3.6453074550E+00, 9.6434314015E-01],
	[3.8290000000E+04, 3.4821892800E+01, 5.4284762912E+00, 1.6297187050E+01, 3.6457550616E+00, 9.6435938828E-01],
	[3.8295000000E+04, 3.4829773816E+01, 5.4285073028E+00, 1.6304125535E+01, 3.6462025522E+00, 9.6437562816E-01],
	[3.8300000000E+04, 3.4837655586E+01, 5.4285383105E+00, 1.6311066066E+01, 3.6466499268E+00, 9.6439185978E-01],
	[3.8305000000E+04, 3.4845538110E+01, 5.4285693144E+00, 1.6318008643E+01, 3.6470971853E+00, 9.6440808316E-01],
	[3.8310000000E+04, 3.4853421388E+01, 5.4286003144E+00, 1.6324953268E+01, 3.6475443279E+00, 9.6442429829E-01],
	[3.8315000000E+04, 3.4861305421E+01, 5.4286313106E+00, 1.6331899940E+01, 3.6479913546E+00, 9.6444050519E-01],
	[3.8320000000E+04, 3.4869190208E+01, 5.4286623029E+00, 1.6338848659E+01, 3.6484382653E+00, 9.6445670385E-01],
	[3.8325000000E+04, 3.4877075749E+01, 5.4286932913E+00, 1.6345799427E+01, 3.6488850601E+00, 9.6447289428E-01],
	[3.8330000000E+04, 3.4884962045E+01, 5.4287242758E+00, 1.6352752243E+01, 3.6493317390E+00, 9.6448907649E-01],
	[3.8335000000E+04, 3.4892849095E+01, 5.4287552565E+00, 1.6359707108E+01, 3.6497783021E+00, 9.6450525048E-01],
	[3.8340000000E+04, 3.4900736898E+01, 5.4287862333E+00, 1.6366664021E+01, 3.6502247493E+00, 9.6452141624E-01],
	[3.8345000000E+04, 3.4908625457E+01, 5.4288172062E+00, 1.6373622984E+01, 3.6506710807E+00, 9.6453757380E-01],
	[3.8350000000E+04, 3.4916514769E+01, 5.4288481753E+00, 1.6380583997E+01, 3.6511172963E+00, 9.6455372315E-01],
	[3.8355000000E+04, 3.4924404835E+01, 5.4288791406E+00, 1.6387547060E+01, 3.6515633962E+00, 9.6456986429E-01],
	[3.8360000000E+04, 3.4932295655E+01, 5.4289101019E+00, 1.6394512173E+01, 3.6520093803E+00, 9.6458599724E-01],
	[3.8365000000E+04, 3.4940187230E+01, 5.4289410594E+00, 1.6401479337E+01, 3.6524552486E+00, 9.6460212199E-01],
	[3.8370000000E+04, 3.4948079558E+01, 5.4289720131E+00, 1.6408448552E+01, 3.6529010013E+00, 9.6461823855E-01],
	[3.8375000000E+04, 3.4955972641E+01, 5.4290029629E+00, 1.6415419819E+01, 3.6533466383E+00, 9.6463434692E-01],
	[3.8380000000E+04, 3.4963866477E+01, 5.4290339088E+00, 1.6422393137E+01, 3.6537921596E+00, 9.6465044712E-01],
	[3.8385000000E+04, 3.4971761068E+01, 5.4290648509E+00, 1.6429368507E+01, 3.6542375653E+00, 9.6466653913E-01],
	[3.8390000000E+04, 3.4979656412E+01, 5.4290957892E+00, 1.6436345930E+01, 3.6546828553E+00, 9.6468262297E-01],
	[3.8395000000E+04, 3.4987552510E+01, 5.4291267235E+00, 1.6443325405E+01, 3.6551280298E+00, 9.6469869864E-01],
	[3.8400000000E+04, 3.4995449362E+01, 5.4291576541E+00, 1.6450306933E+01, 3.6555730887E+00, 9.6471476615E-01],
	[3.8405000000E+04, 3.5003346968E+01, 5.4291885807E+00, 1.6457290515E+01, 3.6560180321E+00, 9.6473082550E-01],
	[3.8410000000E+04, 3.5011245328E+01, 5.4292195036E+00, 1.6464276151E+01, 3.6564628599E+00, 9.6474687669E-01],
	[3.8415000000E+04, 3.5019144441E+01, 5.4292504225E+00, 1.6471263840E+01, 3.6569075723E+00, 9.6476291973E-01],
	[3.8420000000E+04, 3.5027044308E+01, 5.4292813377E+00, 1.6478253585E+01, 3.6573521691E+00, 9.6477895463E-01],
	[3.8425000000E+04, 3.5034944929E+01, 5.4293122490E+00, 1.6485245383E+01, 3.6577966505E+00, 9.6479498138E-01],
	[3.8430000000E+04, 3.5042846304E+01, 5.4293431564E+00, 1.6492239237E+01, 3.6582410165E+00, 9.6481099999E-01],
	[3.8435000000E+04, 3.5050748432E+01, 5.4293740600E+00, 1.6499235146E+01, 3.6586852670E+00, 9.6482701047E-01],
	[3.8440000000E+04, 3.5058651314E+01, 5.4294049597E+00, 1.6506233112E+01, 3.6591294022E+00, 9.6484301281E-01],
	[3.8445000000E+04, 3.5066554950E+01, 5.4294358556E+00, 1.6513233133E+01, 3.6595734220E+00, 9.6485900704E-01],
	[3.8450000000E+04, 3.5074459339E+01, 5.4294667477E+00, 1.6520235210E+01, 3.6600173265E+00, 9.6487499314E-01],
	[3.8455000000E+04, 3.5082364482E+01, 5.4294976359E+00, 1.6527239345E+01, 3.6604611156E+00, 9.6489097113E-01],
	[3.8460000000E+04, 3.5090270378E+01, 5.4295285203E+00, 1.6534245536E+01, 3.6609047895E+00, 9.6490694100E-01],
	[3.8465000000E+04, 3.5098177028E+01, 5.4295594008E+00, 1.6541253785E+01, 3.6613483480E+00, 9.6492290276E-01],
	[3.8470000000E+04, 3.5106084432E+01, 5.4295902775E+00, 1.6548264092E+01, 3.6617917913E+00, 9.6493885642E-01],
	[3.8475000000E+04, 3.5113992589E+01, 5.4296211504E+00, 1.6555276456E+01, 3.6622351194E+00, 9.6495480199E-01],
	[3.8480000000E+04, 3.5121901499E+01, 5.4296520194E+00, 1.6562290880E+01, 3.6626783323E+00, 9.6497073945E-01],
	[3.8485000000E+04, 3.5129811163E+01, 5.4296828846E+00, 1.6569307362E+01, 3.6631214300E+00, 9.6498666883E-01],
	[3.8490000000E+04, 3.5137721580E+01, 5.4297137460E+00, 1.6576325903E+01, 3.6635644125E+00, 9.6500259012E-01],
	[3.8495000000E+04, 3.5145632750E+01, 5.4297446035E+00, 1.6583346503E+01, 3.6640072799E+00, 9.6501850332E-01],
	[3.8500000000E+04, 3.5153544674E+01, 5.4297754572E+00, 1.6590369164E+01, 3.6644500322E+00, 9.6503440845E-01],
	[3.8505000000E+04, 3.5161457351E+01, 5.4298063071E+00, 1.6597393884E+01, 3.6648926693E+00, 9.6505030551E-01],
	[3.8510000000E+04, 3.5169370782E+01, 5.4298371531E+00, 1.6604420665E+01, 3.6653351914E+00, 9.6506619450E-01],
	[3.8515000000E+04, 3.5177284966E+01, 5.4298679953E+00, 1.6611449507E+01, 3.6657775985E+00, 9.6508207542E-01],
	[3.8520000000E+04, 3.5185199902E+01, 5.4298988337E+00, 1.6618480410E+01, 3.6662198905E+00, 9.6509794828E-01],
	[3.8525000000E+04, 3.5193115593E+01, 5.4299296682E+00, 1.6625513374E+01, 3.6666620676E+00, 9.6511381309E-01],
	[3.8530000000E+04, 3.5201032036E+01, 5.4299604989E+00, 1.6632548400E+01, 3.6671041296E+00, 9.6512966984E-01],
	[3.8535000000E+04, 3.5208949232E+01, 5.4299913258E+00, 1.6639585488E+01, 3.6675460767E+00, 9.6514551855E-01],
	[3.8540000000E+04, 3.5216867182E+01, 5.4300221489E+00, 1.6646624639E+01, 3.6679879089E+00, 9.6516135921E-01],
	[3.8545000000E+04, 3.5224785885E+01, 5.4300529681E+00, 1.6653665853E+01, 3.6684296261E+00, 9.6517719184E-01],
	[3.8550000000E+04, 3.5232705341E+01, 5.4300837836E+00, 1.6660709130E+01, 3.6688712284E+00, 9.6519301643E-01],
	[3.8555000000E+04, 3.5240625550E+01, 5.4301145952E+00, 1.6667754470E+01, 3.6693127159E+00, 9.6520883299E-01],
	[3.8560000000E+04, 3.5248546512E+01, 5.4301454029E+00, 1.6674801874E+01, 3.6697540886E+00, 9.6522464152E-01],
	[3.8565000000E+04, 3.5256468226E+01, 5.4301762069E+00, 1.6681851342E+01, 3.6701953464E+00, 9.6524044203E-01],
	[3.8570000000E+04, 3.5264390694E+01, 5.4302070070E+00, 1.6688902875E+01, 3.6706364894E+00, 9.6525623453E-01],
	[3.8575000000E+04, 3.5272313915E+01, 5.4302378034E+00, 1.6695956472E+01, 3.6710775177E+00, 9.6527201901E-01],
	[3.8580000000E+04, 3.5280237889E+01, 5.4302685959E+00, 1.6703012135E+01, 3.6715184312E+00, 9.6528779548E-01],
	[3.8585000000E+04, 3.5288162616E+01, 5.4302993846E+00, 1.6710069863E+01, 3.6719592299E+00, 9.6530356395E-01],
	[3.8590000000E+04, 3.5296088095E+01, 5.4303301694E+00, 1.6717129657E+01, 3.6723999140E+00, 9.6531932442E-01],
	[3.8595000000E+04, 3.5304014327E+01, 5.4303609505E+00, 1.6724191518E+01, 3.6728404834E+00, 9.6533507689E-01],
	[3.8600000000E+04, 3.5311941313E+01, 5.4303917278E+00, 1.6731255444E+01, 3.6732809381E+00, 9.6535082138E-01],
	[3.8605000000E+04, 3.5319869051E+01, 5.4304225012E+00, 1.6738321438E+01, 3.6737212782E+00, 9.6536655787E-01],
	[3.8610000000E+04, 3.5327797541E+01, 5.4304532708E+00, 1.6745389499E+01, 3.6741615036E+00, 9.6538228638E-01],
	[3.8615000000E+04, 3.5335726785E+01, 5.4304840366E+00, 1.6752459627E+01, 3.6746016145E+00, 9.6539800692E-01],
	[3.8620000000E+04, 3.5343675760E+01, 5.4305171336E+00, 1.6759531823E+01, 3.6750428853E+00, 9.6541371948E-01],
	[3.8625000000E+04, 3.5351625808E+01, 5.4305502650E+00, 1.6766606088E+01, 3.6754840630E+00, 9.6542942407E-01],
	[3.8630000000E+04, 3.5359576614E+01, 5.4305833923E+00, 1.6773682420E+01, 3.6759251265E+00, 9.6544512069E-01],
	[3.8635000000E+04, 3.5367528179E+01, 5.4306165156E+00, 1.6780760822E+01, 3.6763660759E+00, 9.6546080935E-01],
	[3.8640000000E+04, 3.5375480503E+01, 5.4306496347E+00, 1.6787841293E+01, 3.6768069111E+00, 9.6547649006E-01],
	[3.8645000000E+04, 3.5383433586E+01, 5.4306827498E+00, 1.6794923834E+01, 3.6772476322E+00, 9.6549216281E-01],
	[3.8650000000E+04, 3.5391387428E+01, 5.4307158608E+00, 1.6802008444E+01, 3.6776882392E+00, 9.6550782762E-01],
	[3.8655000000E+04, 3.5399342028E+01, 5.4307489677E+00, 1.6809095125E+01, 3.6781287322E+00, 9.6552348448E-01],
	[3.8660000000E+04, 3.5407297387E+01, 5.4307820705E+00, 1.6816183876E+01, 3.6785691111E+00, 9.6553913340E-01],
	[3.8665000000E+04, 3.5415253504E+01, 5.4308151693E+00, 1.6823274698E+01, 3.6790093760E+00, 9.6555477438E-01],
	[3.8670000000E+04, 3.5423210380E+01, 5.4308482639E+00, 1.6830367591E+01, 3.6794495269E+00, 9.6557040744E-01],
	[3.8675000000E+04, 3.5431168015E+01, 5.4308813545E+00, 1.6837462556E+01, 3.6798895639E+00, 9.6558603256E-01],
	[3.8680000000E+04, 3.5439126408E+01, 5.4309144411E+00, 1.6844559593E+01, 3.6803294868E+00, 9.6560164977E-01],
	[3.8685000000E+04, 3.5447085560E+01, 5.4309475235E+00, 1.6851658702E+01, 3.6807692959E+00, 9.6561725906E-01],
	[3.8690000000E+04, 3.5455045470E+01, 5.4309806019E+00, 1.6858759883E+01, 3.6812089911E+00, 9.6563286043E-01],
	[3.8695000000E+04, 3.5463006139E+01, 5.4310136762E+00, 1.6865863138E+01, 3.6816485723E+00, 9.6564845389E-01],
	[3.8700000000E+04, 3.5470967567E+01, 5.4310467464E+00, 1.6872968466E+01, 3.6820880397E+00, 9.6566403945E-01],
	[3.8705000000E+04, 3.5478929753E+01, 5.4310798125E+00, 1.6880075867E+01, 3.6825273933E+00, 9.6567961710E-01],
	[3.8710000000E+04, 3.5486892697E+01, 5.4311128746E+00, 1.6887185342E+01, 3.6829666331E+00, 9.6569518686E-01],
	[3.8715000000E+04, 3.5494856399E+01, 5.4311459326E+00, 1.6894296892E+01, 3.6834057591E+00, 9.6571074873E-01],
	[3.8720000000E+04, 3.5502820860E+01, 5.4311789866E+00, 1.6901410516E+01, 3.6838447713E+00, 9.6572630271E-01],
	[3.8725000000E+04, 3.5510786080E+01, 5.4312120365E+00, 1.6908526215E+01, 3.6842836697E+00, 9.6574184880E-01],
	[3.8730000000E+04, 3.5518752057E+01, 5.4312450823E+00, 1.6915643989E+01, 3.6847224545E+00, 9.6575738701E-01],
	[3.8735000000E+04, 3.5526718793E+01, 5.4312781240E+00, 1.6922763839E+01, 3.6851611255E+00, 9.6577291735E-01],
	[3.8740000000E+04, 3.5534686288E+01, 5.4313111617E+00, 1.6929885765E+01, 3.6855996829E+00, 9.6578843982E-01],
	[3.8745000000E+04, 3.5542654540E+01, 5.4313441953E+00, 1.6937009767E+01, 3.6860381266E+00, 9.6580395442E-01],
	[3.8750000000E+04, 3.5550623551E+01, 5.4313772249E+00, 1.6944135845E+01, 3.6864764567E+00, 9.6581946116E-01],
	[3.8755000000E+04, 3.5558593320E+01, 5.4314102504E+00, 1.6951264001E+01, 3.6869146732E+00, 9.6583496004E-01],
	[3.8760000000E+04, 3.5566563847E+01, 5.4314432718E+00, 1.6958394234E+01, 3.6873527761E+00, 9.6585045106E-01],
	[3.8765000000E+04, 3.5574535132E+01, 5.4314762892E+00, 1.6965526544E+01, 3.6877907654E+00, 9.6586593424E-01],
	[3.8770000000E+04, 3.5582507175E+01, 5.4315093025E+00, 1.6972660933E+01, 3.6882286412E+00, 9.6588140957E-01],
	[3.8775000000E+04, 3.5590479976E+01, 5.4315423118E+00, 1.6979797400E+01, 3.6886664034E+00, 9.6589687706E-01],
	[3.8780000000E+04, 3.5598453536E+01, 5.4315753170E+00, 1.6986935945E+01, 3.6891040522E+00, 9.6591233671E-01],
	[3.8785000000E+04, 3.5606427853E+01, 5.4316083182E+00, 1.6994076569E+01, 3.6895415875E+00, 9.6592778853E-01],
	[3.8790000000E+04, 3.5614402929E+01, 5.4316413153E+00, 1.7001219273E+01, 3.6899790094E+00, 9.6594323252E-01],
	[3.8795000000E+04, 3.5622378762E+01, 5.4316743083E+00, 1.7008364056E+01, 3.6904163178E+00, 9.6595866868E-01],
	[3.8800000000E+04, 3.5630355354E+01, 5.4317072973E+00, 1.7015510920E+01, 3.6908535129E+00, 9.6597409703E-01],
	[3.8805000000E+04, 3.5638332703E+01, 5.4317402823E+00, 1.7022659863E+01, 3.6912905945E+00, 9.6598951756E-01],
	[3.8810000000E+04, 3.5646310810E+01, 5.4317732632E+00, 1.7029810888E+01, 3.6917275629E+00, 9.6600493028E-01],
	[3.8815000000E+04, 3.5654289676E+01, 5.4318062400E+00, 1.7036963993E+01, 3.6921644178E+00, 9.6602033519E-01],
	[3.8820000000E+04, 3.5662269299E+01, 5.4318392128E+00, 1.7044119179E+01, 3.6926011595E+00, 9.6603573230E-01],
	[3.8825000000E+04, 3.5670249679E+01, 5.4318721816E+00, 1.7051276448E+01, 3.6930377879E+00, 9.6605112161E-01],
	[3.8830000000E+04, 3.5678230818E+01, 5.4319051463E+00, 1.7058435798E+01, 3.6934743030E+00, 9.6606650312E-01],
	[3.8835000000E+04, 3.5686212715E+01, 5.4319381069E+00, 1.7065597230E+01, 3.6939107049E+00, 9.6608187685E-01],
	[3.8840000000E+04, 3.5694195369E+01, 5.4319710636E+00, 1.7072760746E+01, 3.6943469935E+00, 9.6609724279E-01],
	[3.8845000000E+04, 3.5702178781E+01, 5.4320040161E+00, 1.7079926344E+01, 3.6947831690E+00, 9.6611260094E-01],
	[3.8850000000E+04, 3.5710162950E+01, 5.4320369647E+00, 1.7087094026E+01, 3.6952192313E+00, 9.6612795132E-01],
	[3.8855000000E+04, 3.5718147878E+01, 5.4320699092E+00, 1.7094263791E+01, 3.6956551804E+00, 9.6614329393E-01],
	[3.8860000000E+04, 3.5726133563E+01, 5.4321028496E+00, 1.7101435640E+01, 3.6960910164E+00, 9.6615862877E-01],
	[3.8865000000E+04, 3.5734120005E+01, 5.4321357861E+00, 1.7108609574E+01, 3.6965267393E+00, 9.6617395584E-01],
	[3.8870000000E+04, 3.5742107205E+01, 5.4321687184E+00, 1.7115785592E+01, 3.6969623492E+00, 9.6618927516E-01],
	[3.8875000000E+04, 3.5750095163E+01, 5.4322016468E+00, 1.7122963696E+01, 3.6973978460E+00, 9.6620458671E-01],
	[3.8880000000E+04, 3.5758083878E+01, 5.4322345711E+00, 1.7130143884E+01, 3.6978332297E+00, 9.6621989052E-01],
	[3.8885000000E+04, 3.5766073351E+01, 5.4322674914E+00, 1.7137326159E+01, 3.6982685004E+00, 9.6623518657E-01],
	[3.8890000000E+04, 3.5774063582E+01, 5.4323004076E+00, 1.7144510519E+01, 3.6987036582E+00, 9.6625047489E-01],
	[3.8895000000E+04, 3.5782054569E+01, 5.4323333198E+00, 1.7151696966E+01, 3.6991387030E+00, 9.6626575546E-01],
	[3.8900000000E+04, 3.5790046315E+01, 5.4323662280E+00, 1.7158885500E+01, 3.6995736348E+00, 9.6628102830E-01],
	[3.8905000000E+04, 3.5798038817E+01, 5.4323991322E+00, 1.7166076120E+01, 3.7000084538E+00, 9.6629629341E-01],
	[3.8910000000E+04, 3.5806032077E+01, 5.4324320323E+00, 1.7173268829E+01, 3.7004431598E+00, 9.6631155079E-01],
	[3.8915000000E+04, 3.5814026095E+01, 5.4324649284E+00, 1.7180463624E+01, 3.7008777530E+00, 9.6632680045E-01],
	[3.8920000000E+04, 3.5822020870E+01, 5.4324978204E+00, 1.7187660508E+01, 3.7013122333E+00, 9.6634204239E-01],
	[3.8925000000E+04, 3.5830016402E+01, 5.4325307085E+00, 1.7194859480E+01, 3.7017466008E+00, 9.6635727662E-01],
	[3.8930000000E+04, 3.5838012691E+01, 5.4325635925E+00, 1.7202060541E+01, 3.7021808554E+00, 9.6637250314E-01],
	[3.8935000000E+04, 3.5846009738E+01, 5.4325964725E+00, 1.7209263691E+01, 3.7026149973E+00, 9.6638772195E-01],
	[3.8940000000E+04, 3.5854007542E+01, 5.4326293485E+00, 1.7216468931E+01, 3.7030490265E+00, 9.6640293307E-01],
	[3.8945000000E+04, 3.5862006103E+01, 5.4326622204E+00, 1.7223676260E+01, 3.7034829429E+00, 9.6641813648E-01],
	[3.8950000000E+04, 3.5870005421E+01, 5.4326950883E+00, 1.7230885679E+01, 3.7039167466E+00, 9.6643333220E-01],
	[3.8955000000E+04, 3.5878005497E+01, 5.4327279522E+00, 1.7238097189E+01, 3.7043504376E+00, 9.6644852024E-01],
	[3.8960000000E+04, 3.5886006329E+01, 5.4327608121E+00, 1.7245310790E+01, 3.7047840160E+00, 9.6646370059E-01],
	[3.8965000000E+04, 3.5894007919E+01, 5.4327936680E+00, 1.7252526481E+01, 3.7052174817E+00, 9.6647887326E-01],
	[3.8970000000E+04, 3.5902010266E+01, 5.4328265198E+00, 1.7259744264E+01, 3.7056508348E+00, 9.6649403825E-01],
	[3.8975000000E+04, 3.5910013370E+01, 5.4328593676E+00, 1.7266964139E+01, 3.7060840753E+00, 9.6650919557E-01],
	[3.8980000000E+04, 3.5918017231E+01, 5.4328922115E+00, 1.7274186106E+01, 3.7065172033E+00, 9.6652434523E-01],
	[3.8985000000E+04, 3.5926021849E+01, 5.4329250513E+00, 1.7281410165E+01, 3.7069502187E+00, 9.6653948722E-01],
	[3.8990000000E+04, 3.5934027224E+01, 5.4329578871E+00, 1.7288636318E+01, 3.7073831215E+00, 9.6655462155E-01],
	[3.8995000000E+04, 3.5942033356E+01, 5.4329907188E+00, 1.7295864563E+01, 3.7078159119E+00, 9.6656974823E-01],
	[3.9000000000E+04, 3.5950040244E+01, 5.4330235466E+00, 1.7303094902E+01, 3.7082485898E+00, 9.6658486726E-01],
	[3.9005000000E+04, 3.5958047890E+01, 5.4330563704E+00, 1.7310327334E+01, 3.7086811552E+00, 9.6659997864E-01],
	[3.9010000000E+04, 3.5966056293E+01, 5.4330891901E+00, 1.7317561861E+01, 3.7091136082E+00, 9.6661508238E-01],
	[3.9015000000E+04, 3.5974065452E+01, 5.4331220058E+00, 1.7324798482E+01, 3.7095459488E+00, 9.6663017848E-01],
	[3.9020000000E+04, 3.5982075369E+01, 5.4331548176E+00, 1.7332037198E+01, 3.7099781770E+00, 9.6664526695E-01],
	[3.9025000000E+04, 3.5990086042E+01, 5.4331876253E+00, 1.7339278009E+01, 3.7104102929E+00, 9.6666034779E-01],
	[3.9030000000E+04, 3.5998097472E+01, 5.4332204290E+00, 1.7346520915E+01, 3.7108422964E+00, 9.6667542100E-01],
	[3.9035000000E+04, 3.6006109658E+01, 5.4332532287E+00, 1.7353765918E+01, 3.7112741876E+00, 9.6669048659E-01],
	[3.9040000000E+04, 3.6014122602E+01, 5.4332860245E+00, 1.7361013016E+01, 3.7117059665E+00, 9.6670554457E-01],
	[3.9045000000E+04, 3.6022136302E+01, 5.4333188162E+00, 1.7368262211E+01, 3.7121376331E+00, 9.6672059493E-01],
	[3.9050000000E+04, 3.6030150759E+01, 5.4333516039E+00, 1.7375513503E+01, 3.7125691875E+00, 9.6673563769E-01],
	[3.9055000000E+04, 3.6038165972E+01, 5.4333843876E+00, 1.7382766892E+01, 3.7130006297E+00, 9.6675067284E-01],
	[3.9060000000E+04, 3.6046181942E+01, 5.4334171673E+00, 1.7390022379E+01, 3.7134319596E+00, 9.6676570039E-01],
	[3.9065000000E+04, 3.6054198669E+01, 5.4334499430E+00, 1.7397279963E+01, 3.7138631774E+00, 9.6678072034E-01],
	[3.9070000000E+04, 3.6062216152E+01, 5.4334827147E+00, 1.7404539646E+01, 3.7142942831E+00, 9.6679573271E-01],
	[3.9075000000E+04, 3.6070234392E+01, 5.4335154825E+00, 1.7411801427E+01, 3.7147252766E+00, 9.6681073748E-01],
	[3.9080000000E+04, 3.6078253389E+01, 5.4335482462E+00, 1.7419065307E+01, 3.7151561580E+00, 9.6682573467E-01],
	[3.9085000000E+04, 3.6086273141E+01, 5.4335810059E+00, 1.7426331286E+01, 3.7155869273E+00, 9.6684072429E-01],
	[3.9090000000E+04, 3.6094293651E+01, 5.4336137616E+00, 1.7433599365E+01, 3.7160175846E+00, 9.6685570632E-01],
	[3.9095000000E+04, 3.6102314917E+01, 5.4336465134E+00, 1.7440869543E+01, 3.7164481298E+00, 9.6687068079E-01],
	[3.9100000000E+04, 3.6110336939E+01, 5.4336792611E+00, 1.7448141822E+01, 3.7168785630E+00, 9.6688564769E-01],
	[3.9105000000E+04, 3.6118359717E+01, 5.4337120049E+00, 1.7455416201E+01, 3.7173088843E+00, 9.6690060703E-01],
	[3.9110000000E+04, 3.6126383252E+01, 5.4337447447E+00, 1.7462692681E+01, 3.7177390935E+00, 9.6691555881E-01],
	[3.9115000000E+04, 3.6134407544E+01, 5.4337774805E+00, 1.7469971263E+01, 3.7181691909E+00, 9.6693050304E-01],
	[3.9120000000E+04, 3.6142432592E+01, 5.4338102123E+00, 1.7477251946E+01, 3.7185991763E+00, 9.6694543972E-01],
	[3.9125000000E+04, 3.6150458396E+01, 5.4338429401E+00, 1.7484534731E+01, 3.7190290498E+00, 9.6696036885E-01],
	[3.9130000000E+04, 3.6158484956E+01, 5.4338756639E+00, 1.7491819618E+01, 3.7194588114E+00, 9.6697529044E-01],
	[3.9135000000E+04, 3.6166512272E+01, 5.4339083838E+00, 1.7499106607E+01, 3.7198884612E+00, 9.6699020449E-01],
	[3.9140000000E+04, 3.6174540345E+01, 5.4339410996E+00, 1.7506395700E+01, 3.7203179992E+00, 9.6700511101E-01],
	[3.9145000000E+04, 3.6182569174E+01, 5.4339738115E+00, 1.7513686896E+01, 3.7207474253E+00, 9.6702001000E-01],
	[3.9150000000E+04, 3.6190598759E+01, 5.4340065194E+00, 1.7520980195E+01, 3.7211767397E+00, 9.6703490147E-01],
	[3.9155000000E+04, 3.6198629100E+01, 5.4340392233E+00, 1.7528275598E+01, 3.7216059424E+00, 9.6704978541E-01],
	[3.9160000000E+04, 3.6206660198E+01, 5.4340719233E+00, 1.7535573106E+01, 3.7220350333E+00, 9.6706466184E-01],
	[3.9165000000E+04, 3.6214692051E+01, 5.4341046192E+00, 1.7542872718E+01, 3.7224640125E+00, 9.6707953076E-01],
	[3.9170000000E+04, 3.6222724661E+01, 5.4341373112E+00, 1.7550174435E+01, 3.7228928800E+00, 9.6709439217E-01],
	[3.9175000000E+04, 3.6230758026E+01, 5.4341699992E+00, 1.7557478257E+01, 3.7233216358E+00, 9.6710924607E-01],
	[3.9180000000E+04, 3.6238792148E+01, 5.4342026832E+00, 1.7564784185E+01, 3.7237502800E+00, 9.6712409248E-01],
	[3.9185000000E+04, 3.6246827026E+01, 5.4342353633E+00, 1.7572092219E+01, 3.7241788126E+00, 9.6713893139E-01],
	[3.9190000000E+04, 3.6254862659E+01, 5.4342680394E+00, 1.7579402360E+01, 3.7246072336E+00, 9.6715376281E-01],
	[3.9195000000E+04, 3.6262899049E+01, 5.4343007115E+00, 1.7586714606E+01, 3.7250355431E+00, 9.6716858674E-01],
	[3.9200000000E+04, 3.6270936194E+01, 5.4343333796E+00, 1.7594028960E+01, 3.7254637410E+00, 9.6718340319E-01],
	[3.9205000000E+04, 3.6278974096E+01, 5.4343660438E+00, 1.7601345421E+01, 3.7258918273E+00, 9.6719821216E-01],
	[3.9210000000E+04, 3.6287012753E+01, 5.4343987040E+00, 1.7608663990E+01, 3.7263198022E+00, 9.6721301365E-01],
	[3.9215000000E+04, 3.6295052166E+01, 5.4344313603E+00, 1.7615984666E+01, 3.7267476656E+00, 9.6722780768E-01],
	[3.9220000000E+04, 3.6303092335E+01, 5.4344640125E+00, 1.7623307451E+01, 3.7271754176E+00, 9.6724259424E-01],
	[3.9225000000E+04, 3.6311133260E+01, 5.4344966608E+00, 1.7630632345E+01, 3.7276030581E+00, 9.6725737333E-01],
	[3.9230000000E+04, 3.6319174940E+01, 5.4345293052E+00, 1.7637959348E+01, 3.7280305872E+00, 9.6727214497E-01],
	[3.9235000000E+04, 3.6327217376E+01, 5.4345619455E+00, 1.7645288460E+01, 3.7284580050E+00, 9.6728690915E-01],
	[3.9240000000E+04, 3.6335273016E+01, 5.4345960993E+00, 1.7652619681E+01, 3.7288861568E+00, 9.6730166589E-01],
	[3.9245000000E+04, 3.6343336011E+01, 5.4346310527E+00, 1.7659953013E+01, 3.7293146454E+00, 9.6731641517E-01],
	[3.9250000000E+04, 3.6351399767E+01, 5.4346660018E+00, 1.7667288455E+01, 3.7297430231E+00, 9.6733115702E-01],
	[3.9255000000E+04, 3.6359464285E+01, 5.4347009467E+00, 1.7674626007E+01, 3.7301712898E+00, 9.6734589143E-01],
	[3.9260000000E+04, 3.6367529564E+01, 5.4347358874E+00, 1.7681965671E+01, 3.7305994455E+00, 9.6736061841E-01],
	[3.9265000000E+04, 3.6375595606E+01, 5.4347708238E+00, 1.7689307446E+01, 3.7310274904E+00, 9.6737533795E-01],
	[3.9270000000E+04, 3.6383662408E+01, 5.4348057561E+00, 1.7696651332E+01, 3.7314554243E+00, 9.6739005007E-01],
	[3.9275000000E+04, 3.6391729973E+01, 5.4348406841E+00, 1.7703997331E+01, 3.7318832474E+00, 9.6740475478E-01],
	[3.9280000000E+04, 3.6399798299E+01, 5.4348756079E+00, 1.7711345442E+01, 3.7323109597E+00, 9.6741945206E-01],
	[3.9285000000E+04, 3.6407867386E+01, 5.4349105274E+00, 1.7718695666E+01, 3.7327385611E+00, 9.6743414193E-01],
	[3.9290000000E+04, 3.6415937235E+01, 5.4349454428E+00, 1.7726048002E+01, 3.7331660517E+00, 9.6744882440E-01],
	[3.9295000000E+04, 3.6424007845E+01, 5.4349803539E+00, 1.7733402452E+01, 3.7335934316E+00, 9.6746349945E-01],
	[3.9300000000E+04, 3.6432079217E+01, 5.4350152608E+00, 1.7740759016E+01, 3.7340207007E+00, 9.6747816711E-01],
	[3.9305000000E+04, 3.6440151350E+01, 5.4350501635E+00, 1.7748117694E+01, 3.7344478591E+00, 9.6749282738E-01],
	[3.9310000000E+04, 3.6448224244E+01, 5.4350850620E+00, 1.7755478486E+01, 3.7348749067E+00, 9.6750748025E-01],
	[3.9315000000E+04, 3.6456297900E+01, 5.4351199562E+00, 1.7762841393E+01, 3.7353018437E+00, 9.6752212573E-01],
	[3.9320000000E+04, 3.6464372317E+01, 5.4351548463E+00, 1.7770206416E+01, 3.7357286701E+00, 9.6753676383E-01],
	[3.9325000000E+04, 3.6472447496E+01, 5.4351897321E+00, 1.7777573553E+01, 3.7361553858E+00, 9.6755139455E-01],
	[3.9330000000E+04, 3.6480523436E+01, 5.4352246137E+00, 1.7784942806E+01, 3.7365819909E+00, 9.6756601789E-01],
	[3.9335000000E+04, 3.6488600137E+01, 5.4352594912E+00, 1.7792314175E+01, 3.7370084854E+00, 9.6758063387E-01],
	[3.9340000000E+04, 3.6496677599E+01, 5.4352943644E+00, 1.7799687661E+01, 3.7374348694E+00, 9.6759524247E-01],
	[3.9345000000E+04, 3.6504755822E+01, 5.4353292334E+00, 1.7807063264E+01, 3.7378611428E+00, 9.6760984372E-01],
	[3.9350000000E+04, 3.6512834807E+01, 5.4353640981E+00, 1.7814440983E+01, 3.7382873057E+00, 9.6762443760E-01],
	[3.9355000000E+04, 3.6520914553E+01, 5.4353989587E+00, 1.7821820820E+01, 3.7387133581E+00, 9.6763902413E-01],
	[3.9360000000E+04, 3.6528995060E+01, 5.4354338151E+00, 1.7829202775E+01, 3.7391393001E+00, 9.6765360331E-01],
	[3.9365000000E+04, 3.6537076328E+01, 5.4354686673E+00, 1.7836586848E+01, 3.7395651316E+00, 9.6766817514E-01],
	[3.9370000000E+04, 3.6545158357E+01, 5.4355035153E+00, 1.7843973039E+01, 3.7399908527E+00, 9.6768273963E-01],
	[3.9375000000E+04, 3.6553241147E+01, 5.4355383590E+00, 1.7851361349E+01, 3.7404164633E+00, 9.6769729678E-01],
	[3.9380000000E+04, 3.6561324698E+01, 5.4355731986E+00, 1.7858751778E+01, 3.7408419636E+00, 9.6771184660E-01],
	[3.9385000000E+04, 3.6569409011E+01, 5.4356080340E+00, 1.7866144327E+01, 3.7412673536E+00, 9.6772638909E-01],
	[3.9390000000E+04, 3.6577494084E+01, 5.4356428651E+00, 1.7873538995E+01, 3.7416926332E+00, 9.6774092425E-01],
	[3.9395000000E+04, 3.6585579918E+01, 5.4356776921E+00, 1.7880935784E+01, 3.7421178026E+00, 9.6775545209E-01],
	[3.9400000000E+04, 3.6593666513E+01, 5.4357125149E+00, 1.7888334693E+01, 3.7425428616E+00, 9.6776997261E-01],
	[3.9405000000E+04, 3.6601753869E+01, 5.4357473334E+00, 1.7895735723E+01, 3.7429678104E+00, 9.6778448582E-01],
	[3.9410000000E+04, 3.6609841986E+01, 5.4357821478E+00, 1.7903138874E+01, 3.7433926490E+00, 9.6779899171E-01],
	[3.9415000000E+04, 3.6617930864E+01, 5.4358169580E+00, 1.7910544147E+01, 3.7438173773E+00, 9.6781349031E-01],
	[3.9420000000E+04, 3.6626020502E+01, 5.4358517640E+00, 1.7917951541E+01, 3.7442419955E+00, 9.6782798159E-01],
	[3.9425000000E+04, 3.6634110902E+01, 5.4358865658E+00, 1.7925361057E+01, 3.7446665035E+00, 9.6784246558E-01],
	[3.9430000000E+04, 3.6642202062E+01, 5.4359213634E+00, 1.7932772696E+01, 3.7450909013E+00, 9.6785694227E-01],
	[3.9435000000E+04, 3.6650293983E+01, 5.4359561569E+00, 1.7940186458E+01, 3.7455151891E+00, 9.6787141167E-01],
	[3.9440000000E+04, 3.6658386664E+01, 5.4359909461E+00, 1.7947602343E+01, 3.7459393667E+00, 9.6788587379E-01],
	[3.9445000000E+04, 3.6666480107E+01, 5.4360257312E+00, 1.7955020352E+01, 3.7463634343E+00, 9.6790032861E-01],
	[3.9450000000E+04, 3.6674574310E+01, 5.4360605120E+00, 1.7962440484E+01, 3.7467873918E+00, 9.6791477616E-01],
	[3.9455000000E+04, 3.6682669273E+01, 5.4360952887E+00, 1.7969862741E+01, 3.7472112394E+00, 9.6792921642E-01],
	[3.9460000000E+04, 3.6690764998E+01, 5.4361300612E+00, 1.7977287122E+01, 3.7476349769E+00, 9.6794364942E-01],
	[3.9465000000E+04, 3.6698861483E+01, 5.4361648295E+00, 1.7984713628E+01, 3.7480586044E+00, 9.6795807514E-01],
	[3.9470000000E+04, 3.6706958728E+01, 5.4361995936E+00, 1.7992142259E+01, 3.7484821220E+00, 9.6797249359E-01],
	[3.9475000000E+04, 3.6715056734E+01, 5.4362343536E+00, 1.7999573016E+01, 3.7489055297E+00, 9.6798690479E-01],
	[3.9480000000E+04, 3.6723155501E+01, 5.4362691093E+00, 1.8007005898E+01, 3.7493288274E+00, 9.6800130872E-01],
	[3.9485000000E+04, 3.6731255028E+01, 5.4363038609E+00, 1.8014440907E+01, 3.7497520153E+00, 9.6801570540E-01],
	[3.9490000000E+04, 3.6739355315E+01, 5.4363386083E+00, 1.8021878043E+01, 3.7501750934E+00, 9.6803009482E-01],
	[3.9495000000E+04, 3.6747456363E+01, 5.4363733516E+00, 1.8029317305E+01, 3.7505980615E+00, 9.6804447700E-01],
	[3.9500000000E+04, 3.6755558172E+01, 5.4364080906E+00, 1.8036758695E+01, 3.7510209199E+00, 9.6805885193E-01],
	[3.9505000000E+04, 3.6763660741E+01, 5.4364428255E+00, 1.8044202212E+01, 3.7514436685E+00, 9.6807321963E-01],
	[3.9510000000E+04, 3.6771764070E+01, 5.4364775562E+00, 1.8051647857E+01, 3.7518663074E+00, 9.6808758008E-01],
	[3.9515000000E+04, 3.6779868160E+01, 5.4365122827E+00, 1.8059095630E+01, 3.7522888365E+00, 9.6810193330E-01],
	[3.9520000000E+04, 3.6787973010E+01, 5.4365470051E+00, 1.8066545532E+01, 3.7527112559E+00, 9.6811627929E-01],
	[3.9525000000E+04, 3.6796078620E+01, 5.4365817233E+00, 1.8073997563E+01, 3.7531335655E+00, 9.6813061806E-01],
	[3.9530000000E+04, 3.6804184990E+01, 5.4366164373E+00, 1.8081451723E+01, 3.7535557656E+00, 9.6814494960E-01],
	[3.9535000000E+04, 3.6812292121E+01, 5.4366511472E+00, 1.8088908012E+01, 3.7539778560E+00, 9.6815927392E-01],
	[3.9540000000E+04, 3.6820400012E+01, 5.4366858528E+00, 1.8096366432E+01, 3.7543998367E+00, 9.6817359103E-01],
	[3.9545000000E+04, 3.6828508663E+01, 5.4367205544E+00, 1.8103826982E+01, 3.7548217079E+00, 9.6818790093E-01],
	[3.9550000000E+04, 3.6836618075E+01, 5.4367552517E+00, 1.8111289663E+01, 3.7552434695E+00, 9.6820220361E-01],
	[3.9555000000E+04, 3.6844728246E+01, 5.4367899449E+00, 1.8118754474E+01, 3.7556651215E+00, 9.6821649910E-01],
	[3.9560000000E+04, 3.6852839178E+01, 5.4368246339E+00, 1.8126221417E+01, 3.7560866640E+00, 9.6823078738E-01],
	[3.9565000000E+04, 3.6860950870E+01, 5.4368593188E+00, 1.8133690491E+01, 3.7565080970E+00, 9.6824506847E-01],
	[3.9570000000E+04, 3.6869063322E+01, 5.4368939995E+00, 1.8141161698E+01, 3.7569294206E+00, 9.6825934236E-01],
	[3.9575000000E+04, 3.6877176534E+01, 5.4369286760E+00, 1.8148635036E+01, 3.7573506347E+00, 9.6827360906E-01],
	[3.9580000000E+04, 3.6885290506E+01, 5.4369633484E+00, 1.8156110508E+01, 3.7577717393E+00, 9.6828786858E-01],
	[3.9585000000E+04, 3.6893405238E+01, 5.4369980166E+00, 1.8163588112E+01, 3.7581927346E+00, 9.6830212092E-01],
	[3.9590000000E+04, 3.6901520730E+01, 5.4370326807E+00, 1.8171067850E+01, 3.7586136204E+00, 9.6831636607E-01],
	[3.9595000000E+04, 3.6909636982E+01, 5.4370673406E+00, 1.8178549721E+01, 3.7590343969E+00, 9.6833060405E-01],
	[3.9600000000E+04, 3.6917753994E+01, 5.4371019963E+00, 1.8186033727E+01, 3.7594550641E+00, 9.6834483486E-01],
	[3.9605000000E+04, 3.6925871765E+01, 5.4371366479E+00, 1.8193519866E+01, 3.7598756219E+00, 9.6835905851E-01],
	[3.9610000000E+04, 3.6933990297E+01, 5.4371712953E+00, 1.8201008141E+01, 3.7602960705E+00, 9.6837327499E-01],
	[3.9615000000E+04, 3.6942109589E+01, 5.4372059386E+00, 1.8208498550E+01, 3.7607164098E+00, 9.6838748431E-01],
	[3.9620000000E+04, 3.6950229640E+01, 5.4372405778E+00, 1.8215991095E+01, 3.7611366399E+00, 9.6840168647E-01],
	[3.9625000000E+04, 3.6958350451E+01, 5.4372752127E+00, 1.8223485775E+01, 3.7615567607E+00, 9.6841588148E-01],
	[3.9630000000E+04, 3.6966472022E+01, 5.4373098436E+00, 1.8230982592E+01, 3.7619767723E+00, 9.6843006934E-01],
	[3.9635000000E+04, 3.6974594353E+01, 5.4373444703E+00, 1.8238481545E+01, 3.7623966748E+00, 9.6844425005E-01],
	[3.9640000000E+04, 3.6982717443E+01, 5.4373790928E+00, 1.8245982634E+01, 3.7628164681E+00, 9.6845842362E-01],
	[3.9645000000E+04, 3.6990841294E+01, 5.4374137112E+00, 1.8253485861E+01, 3.7632361523E+00, 9.6847259006E-01],
	[3.9650000000E+04, 3.6998965904E+01, 5.4374483254E+00, 1.8260991225E+01, 3.7636557274E+00, 9.6848674936E-01],
	[3.9655000000E+04, 3.7007091273E+01, 5.4374829356E+00, 1.8268498727E+01, 3.7640751935E+00, 9.6850090152E-01],
	[3.9660000000E+04, 3.7015217402E+01, 5.4375175415E+00, 1.8276008367E+01, 3.7644945505E+00, 9.6851504657E-01],
	[3.9665000000E+04, 3.7023344291E+01, 5.4375521433E+00, 1.8283520145E+01, 3.7649137984E+00, 9.6852918448E-01],
	[3.9670000000E+04, 3.7031471939E+01, 5.4375867410E+00, 1.8291034062E+01, 3.7653329374E+00, 9.6854331528E-01],
	[3.9675000000E+04, 3.7039600347E+01, 5.4376213345E+00, 1.8298550118E+01, 3.7657519673E+00, 9.6855743896E-01],
	[3.9680000000E+04, 3.7047729515E+01, 5.4376559239E+00, 1.8306068313E+01, 3.7661708883E+00, 9.6857155553E-01],
	[3.9685000000E+04, 3.7055859442E+01, 5.4376905092E+00, 1.8313588649E+01, 3.7665897004E+00, 9.6858566499E-01],
	[3.9690000000E+04, 3.7063990128E+01, 5.4377250903E+00, 1.8321111124E+01, 3.7670084036E+00, 9.6859976734E-01],
	[3.9695000000E+04, 3.7072121574E+01, 5.4377596673E+00, 1.8328635740E+01, 3.7674269979E+00, 9.6861386259E-01],
	[3.9700000000E+04, 3.7080253780E+01, 5.4377942402E+00, 1.8336162496E+01, 3.7678454833E+00, 9.6862795075E-01],
	[3.9705000000E+04, 3.7088386745E+01, 5.4378288089E+00, 1.8343691394E+01, 3.7682638599E+00, 9.6864203181E-01],
	[3.9710000000E+04, 3.7096520469E+01, 5.4378633734E+00, 1.8351222433E+01, 3.7686821277E+00, 9.6865610578E-01],
	[3.9715000000E+04, 3.7104654952E+01, 5.4378979339E+00, 1.8358755614E+01, 3.7691002866E+00, 9.6867017266E-01],
	[3.9720000000E+04, 3.7112790195E+01, 5.4379324902E+00, 1.8366290937E+01, 3.7695183369E+00, 9.6868423246E-01],
	[3.9725000000E+04, 3.7120926197E+01, 5.4379670424E+00, 1.8373828403E+01, 3.7699362783E+00, 9.6869828518E-01],
	[3.9730000000E+04, 3.7129062959E+01, 5.4380015905E+00, 1.8381368011E+01, 3.7703541111E+00, 9.6871233082E-01],
	[3.9735000000E+04, 3.7137200480E+01, 5.4380361344E+00, 1.8388909763E+01, 3.7707718352E+00, 9.6872636939E-01],
	[3.9740000000E+04, 3.7145338760E+01, 5.4380706742E+00, 1.8396453658E+01, 3.7711894505E+00, 9.6874040089E-01],
	[3.9745000000E+04, 3.7153477799E+01, 5.4381052099E+00, 1.8403999697E+01, 3.7716069573E+00, 9.6875442533E-01],
	[3.9750000000E+04, 3.7161617597E+01, 5.4381397414E+00, 1.8411547880E+01, 3.7720243554E+00, 9.6876844270E-01],
	[3.9755000000E+04, 3.7169758155E+01, 5.4381742689E+00, 1.8419098207E+01, 3.7724416449E+00, 9.6878245302E-01],
	[3.9760000000E+04, 3.7177899472E+01, 5.4382087922E+00, 1.8426650680E+01, 3.7728588259E+00, 9.6879645628E-01],
	[3.9765000000E+04, 3.7186041548E+01, 5.4382433114E+00, 1.8434205297E+01, 3.7732758983E+00, 9.6881045250E-01],
	[3.9770000000E+04, 3.7194184383E+01, 5.4382778264E+00, 1.8441762060E+01, 3.7736928621E+00, 9.6882444166E-01],
	[3.9775000000E+04, 3.7202327977E+01, 5.4383123374E+00, 1.8449320969E+01, 3.7741097175E+00, 9.6883842378E-01],
	[3.9780000000E+04, 3.7210472330E+01, 5.4383468442E+00, 1.8456882024E+01, 3.7745264644E+00, 9.6885239887E-01],
	[3.9785000000E+04, 3.7218617442E+01, 5.4383813469E+00, 1.8464445226E+01, 3.7749431028E+00, 9.6886636691E-01],
	[3.9790000000E+04, 3.7226763313E+01, 5.4384158455E+00, 1.8472010575E+01, 3.7753596328E+00, 9.6888032793E-01],
	[3.9795000000E+04, 3.7234909943E+01, 5.4384503399E+00, 1.8479578070E+01, 3.7757760544E+00, 9.6889428191E-01],
	[3.9800000000E+04, 3.7243057332E+01, 5.4384848303E+00, 1.8487147714E+01, 3.7761923676E+00, 9.6890822887E-01],
	[3.9805000000E+04, 3.7251205480E+01, 5.4385193165E+00, 1.8494719505E+01, 3.7766085724E+00, 9.6892216881E-01],
	[3.9810000000E+04, 3.7259354387E+01, 5.4385537987E+00, 1.8502293444E+01, 3.7770246690E+00, 9.6893610173E-01],
	[3.9815000000E+04, 3.7267504052E+01, 5.4385882767E+00, 1.8509869532E+01, 3.7774406571E+00, 9.6895002764E-01],
	[3.9820000000E+04, 3.7275654477E+01, 5.4386227506E+00, 1.8517447769E+01, 3.7778565370E+00, 9.6896394654E-01],
	[3.9825000000E+04, 3.7283805660E+01, 5.4386572204E+00, 1.8525028156E+01, 3.7782723087E+00, 9.6897785843E-01],
	[3.9830000000E+04, 3.7291957602E+01, 5.4386916861E+00, 1.8532610691E+01, 3.7786879721E+00, 9.6899176332E-01],
	[3.9835000000E+04, 3.7300110303E+01, 5.4387261477E+00, 1.8540195377E+01, 3.7791035273E+00, 9.6900566120E-01],
	[3.9840000000E+04, 3.7308263763E+01, 5.4387606051E+00, 1.8547782213E+01, 3.7795189743E+00, 9.6901955210E-01],
	[3.9845000000E+04, 3.7316417981E+01, 5.4387950585E+00, 1.8555371200E+01, 3.7799343131E+00, 9.6903343600E-01],
	[3.9850000000E+04, 3.7324572958E+01, 5.4388295078E+00, 1.8562962337E+01, 3.7803495437E+00, 9.6904731291E-01],
	[3.9855000000E+04, 3.7332728694E+01, 5.4388639529E+00, 1.8570555626E+01, 3.7807646663E+00, 9.6906118283E-01],
	[3.9860000000E+04, 3.7340885189E+01, 5.4388983940E+00, 1.8578151067E+01, 3.7811796807E+00, 9.6907504578E-01],
	[3.9865000000E+04, 3.7349042442E+01, 5.4389328309E+00, 1.8585748659E+01, 3.7815945871E+00, 9.6908890174E-01],
	[3.9870000000E+04, 3.7357206509E+01, 5.4389679950E+00, 1.8593348404E+01, 3.7820098011E+00, 9.6910275074E-01],
	[3.9875000000E+04, 3.7365384082E+01, 5.4390046935E+00, 1.8600950301E+01, 3.7824257818E+00, 9.6911659276E-01],
	[3.9880000000E+04, 3.7373562419E+01, 5.4390413876E+00, 1.8608554351E+01, 3.7828416548E+00, 9.6913042782E-01],
	[3.9885000000E+04, 3.7381741521E+01, 5.4390780774E+00, 1.8616160555E+01, 3.7832574201E+00, 9.6914425591E-01],
	[3.9890000000E+04, 3.7389921387E+01, 5.4391147628E+00, 1.8623768912E+01, 3.7836730778E+00, 9.6915807704E-01],
	[3.9895000000E+04, 3.7398102017E+01, 5.4391514438E+00, 1.8631379424E+01, 3.7840886279E+00, 9.6917189122E-01],
	[3.9900000000E+04, 3.7406283412E+01, 5.4391881206E+00, 1.8638992089E+01, 3.7845040704E+00, 9.6918569844E-01],
	[3.9905000000E+04, 3.7414465571E+01, 5.4392247929E+00, 1.8646606910E+01, 3.7849194053E+00, 9.6919949872E-01],
	[3.9910000000E+04, 3.7422648495E+01, 5.4392614609E+00, 1.8654223885E+01, 3.7853346326E+00, 9.6921329205E-01],
	[3.9915000000E+04, 3.7430832182E+01, 5.4392981246E+00, 1.8661843016E+01, 3.7857497525E+00, 9.6922707844E-01],
	[3.9920000000E+04, 3.7439016634E+01, 5.4393347840E+00, 1.8669464302E+01, 3.7861647648E+00, 9.6924085790E-01],
	[3.9925000000E+04, 3.7447201850E+01, 5.4393714389E+00, 1.8677087745E+01, 3.7865796696E+00, 9.6925463041E-01],
	[3.9930000000E+04, 3.7455387830E+01, 5.4394080896E+00, 1.8684713343E+01, 3.7869944670E+00, 9.6926839600E-01],
	[3.9935000000E+04, 3.7463574574E+01, 5.4394447359E+00, 1.8692341099E+01, 3.7874091569E+00, 9.6928215466E-01],
	[3.9940000000E+04, 3.7471762083E+01, 5.4394813778E+00, 1.8699971011E+01, 3.7878237394E+00, 9.6929590640E-01],
	[3.9945000000E+04, 3.7479950355E+01, 5.4395180155E+00, 1.8707603081E+01, 3.7882382146E+00, 9.6930965122E-01],
	[3.9950000000E+04, 3.7488139392E+01, 5.4395546487E+00, 1.8715237309E+01, 3.7886525823E+00, 9.6932338912E-01],
	[3.9955000000E+04, 3.7496329193E+01, 5.4395912777E+00, 1.8722873695E+01, 3.7890668428E+00, 9.6933712011E-01],
	[3.9960000000E+04, 3.7504519757E+01, 5.4396279023E+00, 1.8730512239E+01, 3.7894809959E+00, 9.6935084420E-01],
	[3.9965000000E+04, 3.7512711086E+01, 5.4396645226E+00, 1.8738152942E+01, 3.7898950417E+00, 9.6936456137E-01],
	[3.9970000000E+04, 3.7520903178E+01, 5.4397011385E+00, 1.8745795804E+01, 3.7903089803E+00, 9.6937827165E-01],
	[3.9975000000E+04, 3.7529096035E+01, 5.4397377501E+00, 1.8753440825E+01, 3.7907228116E+00, 9.6939197503E-01],
	[3.9980000000E+04, 3.7537289656E+01, 5.4397743574E+00, 1.8761088007E+01, 3.7911365357E+00, 9.6940567151E-01],
	[3.9985000000E+04, 3.7545484040E+01, 5.4398109603E+00, 1.8768737348E+01, 3.7915501526E+00, 9.6941936110E-01],
	[3.9990000000E+04, 3.7553679188E+01, 5.4398475589E+00, 1.8776388850E+01, 3.7919636624E+00, 9.6943304381E-01],
	[3.9995000000E+04, 3.7561875101E+01, 5.4398841532E+00, 1.8784042512E+01, 3.7923770650E+00, 9.6944671963E-01],
	[4.0000000000E+04, 3.7570071777E+01, 5.4399207431E+00, 1.8791698336E+01, 3.7927903604E+00, 9.6946038858E-01],
	[4.0005000000E+04, 3.7578269216E+01, 5.4399573288E+00, 1.8799383713E+01, 3.7932046640E+00, 9.6947405064E-01],
	[4.0010000000E+04, 3.7586467420E+01, 5.4399939101E+00, 1.8807071271E+01, 3.7936188599E+00, 9.6948770584E-01],
	[4.0015000000E+04, 3.7594666387E+01, 5.4400304870E+00, 1.8814761010E+01, 3.7940329482E+00, 9.6950135416E-01],
	[4.0020000000E+04, 3.7602866118E+01, 5.4400670597E+00, 1.8822452930E+01, 3.7944469289E+00, 9.6951499562E-01],
	[4.0025000000E+04, 3.7611066613E+01, 5.4401036280E+00, 1.8830147033E+01, 3.7948608020E+00, 9.6952863022E-01],
	[4.0030000000E+04, 3.7619267872E+01, 5.4401401920E+00, 1.8837843318E+01, 3.7952745677E+00, 9.6954225796E-01],
	[4.0035000000E+04, 3.7627469894E+01, 5.4401767517E+00, 1.8845541785E+01, 3.7956882258E+00, 9.6955587885E-01],
	[4.0040000000E+04, 3.7635672679E+01, 5.4402133070E+00, 1.8853242435E+01, 3.7961017764E+00, 9.6956949289E-01],
	[4.0045000000E+04, 3.7643876229E+01, 5.4402498581E+00, 1.8860945269E+01, 3.7965152195E+00, 9.6958310008E-01],
	[4.0050000000E+04, 3.7652080542E+01, 5.4402864048E+00, 1.8868650286E+01, 3.7969285552E+00, 9.6959670042E-01],
	[4.0055000000E+04, 3.7660285618E+01, 5.4403229472E+00, 1.8876357487E+01, 3.7973417835E+00, 9.6961029393E-01],
	[4.0060000000E+04, 3.7668491458E+01, 5.4403594853E+00, 1.8884066872E+01, 3.7977549044E+00, 9.6962388060E-01],
	[4.0065000000E+04, 3.7676698062E+01, 5.4403960191E+00, 1.8891778443E+01, 3.7981679179E+00, 9.6963746043E-01],
	[4.0070000000E+04, 3.7684905429E+01, 5.4404325485E+00, 1.8899492198E+01, 3.7985808240E+00, 9.6965103344E-01],
	[4.0075000000E+04, 3.7693113560E+01, 5.4404690737E+00, 1.8907208138E+01, 3.7989936229E+00, 9.6966459962E-01],
	[4.0080000000E+04, 3.7701322454E+01, 5.4405055945E+00, 1.8914926264E+01, 3.7994063144E+00, 9.6967815898E-01],
	[4.0085000000E+04, 3.7709532111E+01, 5.4405421110E+00, 1.8922646576E+01, 3.7998188987E+00, 9.6969171153E-01],
	[4.0090000000E+04, 3.7717742532E+01, 5.4405786233E+00, 1.8930369075E+01, 3.8002313757E+00, 9.6970525725E-01],
	[4.0095000000E+04, 3.7725953716E+01, 5.4406151312E+00, 1.8938093760E+01, 3.8006437455E+00, 9.6971879617E-01],
	[4.0100000000E+04, 3.7734165663E+01, 5.4406516348E+00, 1.8945820633E+01, 3.8010560081E+00, 9.6973232828E-01],
	[4.0105000000E+04, 3.7742378374E+01, 5.4406881341E+00, 1.8953549692E+01, 3.8014681635E+00, 9.6974585359E-01],
	[4.0110000000E+04, 3.7750591848E+01, 5.4407246290E+00, 1.8961280940E+01, 3.8018802117E+00, 9.6975937209E-01],
	[4.0115000000E+04, 3.7758806086E+01, 5.4407611197E+00, 1.8969014376E+01, 3.8022921529E+00, 9.6977288380E-01],
	[4.0120000000E+04, 3.7767021086E+01, 5.4407976061E+00, 1.8976750000E+01, 3.8027039869E+00, 9.6978638871E-01],
	[4.0125000000E+04, 3.7775236850E+01, 5.4408340882E+00, 1.8984487813E+01, 3.8031157138E+00, 9.6979988684E-01],
	[4.0130000000E+04, 3.7783453377E+01, 5.4408705660E+00, 1.8992227815E+01, 3.8035273337E+00, 9.6981337818E-01],
	[4.0135000000E+04, 3.7791670668E+01, 5.4409070394E+00, 1.8999970007E+01, 3.8039388465E+00, 9.6982686274E-01],
	[4.0140000000E+04, 3.7799888721E+01, 5.4409435086E+00, 1.9007714388E+01, 3.8043502524E+00, 9.6984034052E-01],
	[4.0145000000E+04, 3.7808107537E+01, 5.4409799735E+00, 1.9015460960E+01, 3.8047615512E+00, 9.6985381152E-01],
	[4.0150000000E+04, 3.7816327117E+01, 5.4410164341E+00, 1.9023209722E+01, 3.8051727431E+00, 9.6986727576E-01],
	[4.0155000000E+04, 3.7824547460E+01, 5.4410528904E+00, 1.9030960675E+01, 3.8055838281E+00, 9.6988073322E-01],
	[4.0160000000E+04, 3.7832768566E+01, 5.4410893424E+00, 1.9038713819E+01, 3.8059948061E+00, 9.6989418392E-01],
	[4.0165000000E+04, 3.7840990434E+01, 5.4411257901E+00, 1.9046469155E+01, 3.8064056772E+00, 9.6990762786E-01],
	[4.0170000000E+04, 3.7849213066E+01, 5.4411622335E+00, 1.9054226683E+01, 3.8068164415E+00, 9.6992106505E-01],
	[4.0175000000E+04, 3.7857436461E+01, 5.4411986726E+00, 1.9061986403E+01, 3.8072270989E+00, 9.6993449548E-01],
	[4.0180000000E+04, 3.7865660619E+01, 5.4412351074E+00, 1.9069748316E+01, 3.8076376496E+00, 9.6994791916E-01],
	[4.0185000000E+04, 3.7873885539E+01, 5.4412715379E+00, 1.9077512422E+01, 3.8080480934E+00, 9.6996133609E-01],
	[4.0190000000E+04, 3.7882111223E+01, 5.4413079642E+00, 1.9085278721E+01, 3.8084584305E+00, 9.6997474628E-01],
	[4.0195000000E+04, 3.7890337669E+01, 5.4413443861E+00, 1.9093047213E+01, 3.8088686608E+00, 9.6998814974E-01],
	[4.0200000000E+04, 3.7898564879E+01, 5.4413808038E+00, 1.9100817900E+01, 3.8092787844E+00, 9.7000154645E-01],
	[4.0205000000E+04, 3.7906792851E+01, 5.4414172172E+00, 1.9108590781E+01, 3.8096888013E+00, 9.7001493644E-01],
	[4.0210000000E+04, 3.7915021586E+01, 5.4414536263E+00, 1.9116365856E+01, 3.8100987115E+00, 9.7002831970E-01],
	[4.0215000000E+04, 3.7923251084E+01, 5.4414900311E+00, 1.9124143127E+01, 3.8105085151E+00, 9.7004169623E-01],
	[4.0220000000E+04, 3.7931481344E+01, 5.4415264316E+00, 1.9131922593E+01, 3.8109182120E+00, 9.7005506604E-01],
	[4.0225000000E+04, 3.7939712367E+01, 5.4415628279E+00, 1.9139704255E+01, 3.8113278024E+00, 9.7006842913E-01],
	[4.0230000000E+04, 3.7947944153E+01, 5.4415992199E+00, 1.9147488113E+01, 3.8117372861E+00, 9.7008178551E-01],
	[4.0235000000E+04, 3.7956176702E+01, 5.4416356076E+00, 1.9155274167E+01, 3.8121466634E+00, 9.7009513518E-01],
	[4.0240000000E+04, 3.7964410013E+01, 5.4416719910E+00, 1.9163062418E+01, 3.8125559341E+00, 9.7010847814E-01],
	[4.0245000000E+04, 3.7972644087E+01, 5.4417083701E+00, 1.9170852867E+01, 3.8129650982E+00, 9.7012181440E-01],
	[4.0250000000E+04, 3.7980878924E+01, 5.4417447450E+00, 1.9178645512E+01, 3.8133741560E+00, 9.7013514396E-01],
	[4.0255000000E+04, 3.7989114523E+01, 5.4417811156E+00, 1.9186440356E+01, 3.8137831072E+00, 9.7014846683E-01],
	[4.0260000000E+04, 3.7997350885E+01, 5.4418174819E+00, 1.9194237397E+01, 3.8141919520E+00, 9.7016178300E-01],
	[4.0265000000E+04, 3.8005588009E+01, 5.4418538439E+00, 1.9202036637E+01, 3.8146006905E+00, 9.7017509248E-01],
	[4.0270000000E+04, 3.8013825896E+01, 5.4418902017E+00, 1.9209838076E+01, 3.8150093225E+00, 9.7018839528E-01],
	[4.0275000000E+04, 3.8022064545E+01, 5.4419265552E+00, 1.9217641715E+01, 3.8154178482E+00, 9.7020169139E-01],
	[4.0280000000E+04, 3.8030303957E+01, 5.4419629044E+00, 1.9225447552E+01, 3.8158262675E+00, 9.7021498083E-01],
	[4.0285000000E+04, 3.8038544132E+01, 5.4419992494E+00, 1.9233255590E+01, 3.8162345806E+00, 9.7022826359E-01],
	[4.0290000000E+04, 3.8046785068E+01, 5.4420355900E+00, 1.9241065828E+01, 3.8166427873E+00, 9.7024153968E-01],
	[4.0295000000E+04, 3.8055026767E+01, 5.4420719265E+00, 1.9248878266E+01, 3.8170508878E+00, 9.7025480911E-01],
	[4.0300000000E+04, 3.8063269229E+01, 5.4421082586E+00, 1.9256692905E+01, 3.8174588821E+00, 9.7026807187E-01],
	[4.0305000000E+04, 3.8071512453E+01, 5.4421445865E+00, 1.9264509746E+01, 3.8178667701E+00, 9.7028132797E-01],
	[4.0310000000E+04, 3.8079756439E+01, 5.4421809101E+00, 1.9272328788E+01, 3.8182745519E+00, 9.7029457741E-01],
	[4.0315000000E+04, 3.8088001187E+01, 5.4422172295E+00, 1.9280150032E+01, 3.8186822276E+00, 9.7030782020E-01],
	[4.0320000000E+04, 3.8096246698E+01, 5.4422535446E+00, 1.9287973479E+01, 3.8190897972E+00, 9.7032105634E-01],
	[4.0325000000E+04, 3.8104492971E+01, 5.4422898554E+00, 1.9295799128E+01, 3.8194972606E+00, 9.7033428584E-01],
	[4.0330000000E+04, 3.8112740006E+01, 5.4423261620E+00, 1.9303626980E+01, 3.8199046179E+00, 9.7034750869E-01],
	[4.0335000000E+04, 3.8120987804E+01, 5.4423624643E+00, 1.9311457036E+01, 3.8203118692E+00, 9.7036072490E-01],
	[4.0340000000E+04, 3.8129236363E+01, 5.4423987624E+00, 1.9319289295E+01, 3.8207190144E+00, 9.7037393448E-01],
	[4.0345000000E+04, 3.8137485685E+01, 5.4424350562E+00, 1.9327123758E+01, 3.8211260536E+00, 9.7038713743E-01],
	[4.0350000000E+04, 3.8145735769E+01, 5.4424713458E+00, 1.9334960426E+01, 3.8215329868E+00, 9.7040033375E-01],
	[4.0355000000E+04, 3.8153986615E+01, 5.4425076311E+00, 1.9342799298E+01, 3.8219398141E+00, 9.7041352344E-01],
	[4.0360000000E+04, 3.8162238223E+01, 5.4425439121E+00, 1.9350640375E+01, 3.8223465353E+00, 9.7042670651E-01],
	[4.0365000000E+04, 3.8170490594E+01, 5.4425801889E+00, 1.9358483658E+01, 3.8227531507E+00, 9.7043988297E-01],
	[4.0370000000E+04, 3.8178743726E+01, 5.4426164614E+00, 1.9366329147E+01, 3.8231596602E+00, 9.7045305281E-01],
	[4.0375000000E+04, 3.8186997620E+01, 5.4426527297E+00, 1.9374176842E+01, 3.8235660638E+00, 9.7046621604E-01],
	[4.0380000000E+04, 3.8195252276E+01, 5.4426889938E+00, 1.9382026743E+01, 3.8239723615E+00, 9.7047937266E-01],
	[4.0385000000E+04, 3.8203507695E+01, 5.4427252536E+00, 1.9389878851E+01, 3.8243785534E+00, 9.7049252268E-01],
	[4.0390000000E+04, 3.8211763875E+01, 5.4427615091E+00, 1.9397733166E+01, 3.8247846395E+00, 9.7050566610E-01],
	[4.0395000000E+04, 3.8220020817E+01, 5.4427977604E+00, 1.9405589689E+01, 3.8251906199E+00, 9.7051880293E-01],
	[4.0400000000E+04, 3.8228278521E+01, 5.4428340075E+00, 1.9413448419E+01, 3.8255964945E+00, 9.7053193316E-01],
	[4.0405000000E+04, 3.8236536987E+01, 5.4428702503E+00, 1.9421309358E+01, 3.8260022633E+00, 9.7054505680E-01],
	[4.0410000000E+04, 3.8244796214E+01, 5.4429064888E+00, 1.9429172505E+01, 3.8264079265E+00, 9.7055817386E-01],
	[4.0415000000E+04, 3.8253056204E+01, 5.4429427232E+00, 1.9437037862E+01, 3.8268134840E+00, 9.7057128434E-01],
	[4.0420000000E+04, 3.8261316955E+01, 5.4429789532E+00, 1.9444905427E+01, 3.8272189358E+00, 9.7058438824E-01],
	[4.0425000000E+04, 3.8269578468E+01, 5.4430151791E+00, 1.9452775202E+01, 3.8276242820E+00, 9.7059748556E-01],
	[4.0430000000E+04, 3.8277840743E+01, 5.4430514007E+00, 1.9460647187E+01, 3.8280295225E+00, 9.7061057631E-01],
	[4.0435000000E+04, 3.8286103780E+01, 5.4430876180E+00, 1.9468521382E+01, 3.8284346575E+00, 9.7062366049E-01],
	[4.0440000000E+04, 3.8294367578E+01, 5.4431238312E+00, 1.9476397788E+01, 3.8288396870E+00, 9.7063673811E-01],
	[4.0445000000E+04, 3.8302632138E+01, 5.4431600401E+00, 1.9484276405E+01, 3.8292446109E+00, 9.7064980917E-01],
	[4.0450000000E+04, 3.8310897460E+01, 5.4431962447E+00, 1.9492157233E+01, 3.8296494293E+00, 9.7066287367E-01],
	[4.0455000000E+04, 3.8319163543E+01, 5.4432324451E+00, 1.9500040273E+01, 3.8300541422E+00, 9.7067593162E-01],
	[4.0460000000E+04, 3.8327430388E+01, 5.4432686413E+00, 1.9507925525E+01, 3.8304587496E+00, 9.7068898302E-01],
	[4.0465000000E+04, 3.8335697995E+01, 5.4433048333E+00, 1.9515812989E+01, 3.8308632516E+00, 9.7070202787E-01],
	[4.0470000000E+04, 3.8343966363E+01, 5.4433410210E+00, 1.9523702666E+01, 3.8312676482E+00, 9.7071506618E-01],
	[4.0475000000E+04, 3.8352235492E+01, 5.4433772045E+00, 1.9531594556E+01, 3.8316719394E+00, 9.7072809795E-01],
	[4.0480000000E+04, 3.8360505383E+01, 5.4434133838E+00, 1.9539488659E+01, 3.8320761252E+00, 9.7074112318E-01],
	[4.0485000000E+04, 3.8368776036E+01, 5.4434495588E+00, 1.9547384976E+01, 3.8324802057E+00, 9.7075414188E-01],
	[4.0490000000E+04, 3.8377047450E+01, 5.4434857296E+00, 1.9555283507E+01, 3.8328841809E+00, 9.7076715406E-01],
	[4.0495000000E+04, 3.8385319626E+01, 5.4435218962E+00, 1.9563184253E+01, 3.8332880508E+00, 9.7078015970E-01],
	[4.0500000000E+04, 3.8393592563E+01, 5.4435580585E+00, 1.9571087213E+01, 3.8336918154E+00, 9.7079315883E-01],
	[4.0505000000E+04, 3.8401866261E+01, 5.4435942167E+00, 1.9578992389E+01, 3.8340954748E+00, 9.7080615144E-01],
	[4.0510000000E+04, 3.8410140721E+01, 5.4436303706E+00, 1.9586899780E+01, 3.8344990290E+00, 9.7081913753E-01],
	[4.0515000000E+04, 3.8418433798E+01, 5.4436686436E+00, 1.9594809387E+01, 3.8349037096E+00, 9.7083211711E-01],
	[4.0520000000E+04, 3.8426728448E+01, 5.4437070081E+00, 1.9602721210E+01, 3.8353083411E+00, 9.7084509018E-01],
	[4.0525000000E+04, 3.8435023866E+01, 5.4437453682E+00, 1.9610635249E+01, 3.8357128676E+00, 9.7085805675E-01],
	[4.0530000000E+04, 3.8443320051E+01, 5.4437837238E+00, 1.9618551506E+01, 3.8361172894E+00, 9.7087101682E-01],
	[4.0535000000E+04, 3.8451617003E+01, 5.4438220749E+00, 1.9626469980E+01, 3.8365216063E+00, 9.7088397039E-01],
	[4.0540000000E+04, 3.8459914722E+01, 5.4438604216E+00, 1.9634390671E+01, 3.8369258184E+00, 9.7089691747E-01],
	[4.0545000000E+04, 3.8468213208E+01, 5.4438987638E+00, 1.9642313580E+01, 3.8373299258E+00, 9.7090985806E-01],
	[4.0550000000E+04, 3.8476512461E+01, 5.4439371016E+00, 1.9650238707E+01, 3.8377339284E+00, 9.7092279216E-01],
	[4.0555000000E+04, 3.8484812481E+01, 5.4439754349E+00, 1.9658166053E+01, 3.8381378264E+00, 9.7093571978E-01],
	[4.0560000000E+04, 3.8493113267E+01, 5.4440137637E+00, 1.9666095618E+01, 3.8385416196E+00, 9.7094864092E-01],
	[4.0565000000E+04, 3.8501414821E+01, 5.4440520881E+00, 1.9674027402E+01, 3.8389453082E+00, 9.7096155559E-01],
	[4.0570000000E+04, 3.8509717141E+01, 5.4440904081E+00, 1.9681961406E+01, 3.8393488921E+00, 9.7097446378E-01],
	[4.0575000000E+04, 3.8518020228E+01, 5.4441287236E+00, 1.9689897630E+01, 3.8397523714E+00, 9.7098736550E-01],
	[4.0580000000E+04, 3.8526324082E+01, 5.4441670346E+00, 1.9697836074E+01, 3.8401557462E+00, 9.7100026076E-01],
	[4.0585000000E+04, 3.8534628702E+01, 5.4442053412E+00, 1.9705776739E+01, 3.8405590163E+00, 9.7101314956E-01],
	[4.0590000000E+04, 3.8542934090E+01, 5.4442436433E+00, 1.9713719625E+01, 3.8409621820E+00, 9.7102603189E-01],
	[4.0595000000E+04, 3.8551240244E+01, 5.4442819410E+00, 1.9721664732E+01, 3.8413652431E+00, 9.7103890778E-01],
	[4.0600000000E+04, 3.8559547165E+01, 5.4443202342E+00, 1.9729612061E+01, 3.8417681997E+00, 9.7105177721E-01],
	[4.0605000000E+04, 3.8567854852E+01, 5.4443585230E+00, 1.9737561612E+01, 3.8421710518E+00, 9.7106464019E-01],
	[4.0610000000E+04, 3.8576163306E+01, 5.4443968074E+00, 1.9745513386E+01, 3.8425737995E+00, 9.7107749673E-01],
	[4.0615000000E+04, 3.8584472527E+01, 5.4444350873E+00, 1.9753467382E+01, 3.8429764427E+00, 9.7109034683E-01],
	[4.0620000000E+04, 3.8592782514E+01, 5.4444733627E+00, 1.9761423601E+01, 3.8433789816E+00, 9.7110319049E-01],
	[4.0625000000E+04, 3.8601093268E+01, 5.4445116338E+00, 1.9769382044E+01, 3.8437814161E+00, 9.7111602772E-01],
	[4.0630000000E+04, 3.8609404788E+01, 5.4445499003E+00, 1.9777342711E+01, 3.8441837462E+00, 9.7112885852E-01],
	[4.0635000000E+04, 3.8617717075E+01, 5.4445881625E+00, 1.9785305602E+01, 3.8445859720E+00, 9.7114168289E-01],
	[4.0640000000E+04, 3.8626030129E+01, 5.4446264202E+00, 1.9793270717E+01, 3.8449880935E+00, 9.7115450084E-01],
	[4.0645000000E+04, 3.8634343949E+01, 5.4446646734E+00, 1.9801238057E+01, 3.8453901108E+00, 9.7116731237E-01],
	[4.0650000000E+04, 3.8642658535E+01, 5.4447029222E+00, 1.9809207622E+01, 3.8457920238E+00, 9.7118011748E-01],
	[4.0655000000E+04, 3.8650973888E+01, 5.4447411666E+00, 1.9817179413E+01, 3.8461938325E+00, 9.7119291618E-01],
	[4.0660000000E+04, 3.8659290007E+01, 5.4447794066E+00, 1.9825153430E+01, 3.8465955371E+00, 9.7120570847E-01],
	[4.0665000000E+04, 3.8667606893E+01, 5.4448176421E+00, 1.9833129673E+01, 3.8469971374E+00, 9.7121849436E-01],
	[4.0670000000E+04, 3.8675924545E+01, 5.4448558732E+00, 1.9841108143E+01, 3.8473986336E+00, 9.7123127384E-01],
	[4.0675000000E+04, 3.8684242963E+01, 5.4448940998E+00, 1.9849088839E+01, 3.8478000257E+00, 9.7124404692E-01],
	[4.0680000000E+04, 3.8692562148E+01, 5.4449323221E+00, 1.9857071763E+01, 3.8482013137E+00, 9.7125681361E-01],
	[4.0685000000E+04, 3.8700882098E+01, 5.4449705399E+00, 1.9865056914E+01, 3.8486024976E+00, 9.7126957391E-01],
	[4.0690000000E+04, 3.8709202816E+01, 5.4450087532E+00, 1.9873044294E+01, 3.8490035774E+00, 9.7128232782E-01],
	[4.0695000000E+04, 3.8717524299E+01, 5.4450469622E+00, 1.9881033901E+01, 3.8494045532E+00, 9.7129507534E-01],
	[4.0700000000E+04, 3.8725846549E+01, 5.4450851667E+00, 1.9889025738E+01, 3.8498054250E+00, 9.7130781649E-01],
	[4.0705000000E+04, 3.8734169564E+01, 5.4451233668E+00, 1.9897019803E+01, 3.8502061928E+00, 9.7132055125E-01],
	[4.0710000000E+04, 3.8742493346E+01, 5.4451615624E+00, 1.9905016098E+01, 3.8506068566E+00, 9.7133327964E-01],
	[4.0715000000E+04, 3.8750817894E+01, 5.4451997537E+00, 1.9913014622E+01, 3.8510074165E+00, 9.7134600166E-01],
	[4.0720000000E+04, 3.8759143209E+01, 5.4452379405E+00, 1.9921015377E+01, 3.8514078725E+00, 9.7135871732E-01],
	[4.0725000000E+04, 3.8767469289E+01, 5.4452761229E+00, 1.9929018362E+01, 3.8518082246E+00, 9.7137142661E-01],
	[4.0730000000E+04, 3.8775796135E+01, 5.4453143009E+00, 1.9937023578E+01, 3.8522084728E+00, 9.7138412953E-01],
	[4.0735000000E+04, 3.8784123748E+01, 5.4453524744E+00, 1.9945031024E+01, 3.8526086172E+00, 9.7139682611E-01],
	[4.0740000000E+04, 3.8792452126E+01, 5.4453906436E+00, 1.9953040703E+01, 3.8530086577E+00, 9.7140951633E-01],
	[4.0745000000E+04, 3.8800781271E+01, 5.4454288083E+00, 1.9961052613E+01, 3.8534085945E+00, 9.7142220020E-01],
	[4.0750000000E+04, 3.8809111181E+01, 5.4454669686E+00, 1.9969066755E+01, 3.8538084275E+00, 9.7143487772E-01],
	[4.0755000000E+04, 3.8817441858E+01, 5.4455051245E+00, 1.9977083129E+01, 3.8542081567E+00, 9.7144754890E-01],
	[4.0760000000E+04, 3.8825773300E+01, 5.4455432760E+00, 1.9985101737E+01, 3.8546077823E+00, 9.7146021374E-01],
	[4.0765000000E+04, 3.8834105508E+01, 5.4455814231E+00, 1.9993122578E+01, 3.8550073041E+00, 9.7147287225E-01],
	[4.0770000000E+04, 3.8842438483E+01, 5.4456195657E+00, 2.0001145652E+01, 3.8554067223E+00, 9.7148552442E-01],
	[4.0775000000E+04, 3.8850772223E+01, 5.4456577040E+00, 2.0009170960E+01, 3.8558060368E+00, 9.7149817026E-01],
	[4.0780000000E+04, 3.8859106728E+01, 5.4456958378E+00, 2.0017198502E+01, 3.8562052477E+00, 9.7151080978E-01],
	[4.0785000000E+04, 3.8867442000E+01, 5.4457339672E+00, 2.0025228279E+01, 3.8566043550E+00, 9.7152344298E-01],
	[4.0790000000E+04, 3.8875778038E+01, 5.4457720922E+00, 2.0033260291E+01, 3.8570033587E+00, 9.7153606985E-01],
	[4.0795000000E+04, 3.8884114841E+01, 5.4458102129E+00, 2.0041294538E+01, 3.8574022589E+00, 9.7154869042E-01],
	[4.0800000000E+04, 3.8892452410E+01, 5.4458483291E+00, 2.0049331021E+01, 3.8578010556E+00, 9.7156130467E-01],
	[4.0805000000E+04, 3.8900790745E+01, 5.4458864409E+00, 2.0057369739E+01, 3.8581997487E+00, 9.7157391261E-01],
	[4.0810000000E+04, 3.8909129845E+01, 5.4459245483E+00, 2.0065410694E+01, 3.8585983384E+00, 9.7158651425E-01],
	[4.0815000000E+04, 3.8917469711E+01, 5.4459626513E+00, 2.0073453886E+01, 3.8589968246E+00, 9.7159910959E-01],
	[4.0820000000E+04, 3.8925810343E+01, 5.4460007499E+00, 2.0081499314E+01, 3.8593952074E+00, 9.7161169863E-01],
	[4.0825000000E+04, 3.8934151740E+01, 5.4460388441E+00, 2.0089546980E+01, 3.8597934868E+00, 9.7162428137E-01],
	[4.0830000000E+04, 3.8942493903E+01, 5.4460769339E+00, 2.0097596884E+01, 3.8601916628E+00, 9.7163685783E-01],
	[4.0835000000E+04, 3.8950836832E+01, 5.4461150193E+00, 2.0105649026E+01, 3.8605897354E+00, 9.7164942799E-01],
	[4.0840000000E+04, 3.8959180526E+01, 5.4461531003E+00, 2.0113703406E+01, 3.8609877047E+00, 9.7166199188E-01],
	[4.0845000000E+04, 3.8967524986E+01, 5.4461911769E+00, 2.0121760025E+01, 3.8613855707E+00, 9.7167454948E-01],
	[4.0850000000E+04, 3.8975870211E+01, 5.4462292491E+00, 2.0129818883E+01, 3.8617833334E+00, 9.7168710081E-01],
	[4.0855000000E+04, 3.8984216201E+01, 5.4462673170E+00, 2.0137879980E+01, 3.8621809929E+00, 9.7169964586E-01],
	[4.0860000000E+04, 3.8992562957E+01, 5.4463053804E+00, 2.0145943317E+01, 3.8625785491E+00, 9.7171218464E-01],
	[4.0865000000E+04, 3.9000910479E+01, 5.4463434394E+00, 2.0154008894E+01, 3.8629760022E+00, 9.7172471716E-01],
	[4.0870000000E+04, 3.9009258766E+01, 5.4463814941E+00, 2.0162076712E+01, 3.8633733520E+00, 9.7173724341E-01],
	[4.0875000000E+04, 3.9017607818E+01, 5.4464195443E+00, 2.0170146771E+01, 3.8637705987E+00, 9.7174976340E-01],
	[4.0880000000E+04, 3.9025957636E+01, 5.4464575902E+00, 2.0178219071E+01, 3.8641677422E+00, 9.7176227714E-01],
	[4.0885000000E+04, 3.9034308219E+01, 5.4464956317E+00, 2.0186293612E+01, 3.8645647826E+00, 9.7177478463E-01],
	[4.0890000000E+04, 3.9042659568E+01, 5.4465336688E+00, 2.0194370395E+01, 3.8649617199E+00, 9.7178728586E-01],
	[4.0895000000E+04, 3.9051011681E+01, 5.4465717015E+00, 2.0202449420E+01, 3.8653585542E+00, 9.7179978085E-01],
	[4.0900000000E+04, 3.9059364560E+01, 5.4466097298E+00, 2.0210530688E+01, 3.8657552854E+00, 9.7181226960E-01],
	[4.0905000000E+04, 3.9067718205E+01, 5.4466477538E+00, 2.0218614199E+01, 3.8661519136E+00, 9.7182475210E-01],
	[4.0910000000E+04, 3.9076072614E+01, 5.4466857733E+00, 2.0226699953E+01, 3.8665484389E+00, 9.7183722838E-01],
	[4.0915000000E+04, 3.9084427789E+01, 5.4467237885E+00, 2.0234787951E+01, 3.8669448611E+00, 9.7184969842E-01],
	[4.0920000000E+04, 3.9092783728E+01, 5.4467617993E+00, 2.0242878193E+01, 3.8673411804E+00, 9.7186216223E-01],
	[4.0925000000E+04, 3.9101140434E+01, 5.4467998057E+00, 2.0250970679E+01, 3.8677373968E+00, 9.7187461982E-01],
	[4.0930000000E+04, 3.9109497904E+01, 5.4468378078E+00, 2.0259065409E+01, 3.8681335103E+00, 9.7188707118E-01],
	[4.0935000000E+04, 3.9117856139E+01, 5.4468758054E+00, 2.0267162385E+01, 3.8685295209E+00, 9.7189951633E-01],
	[4.0940000000E+04, 3.9126215139E+01, 5.4469137987E+00, 2.0275261606E+01, 3.8689254287E+00, 9.7191195526E-01],
	[4.0945000000E+04, 3.9134574905E+01, 5.4469517877E+00, 2.0283363073E+01, 3.8693212337E+00, 9.7192438798E-01],
	[4.0950000000E+04, 3.9142935435E+01, 5.4469897722E+00, 2.0291466786E+01, 3.8697169358E+00, 9.7193681449E-01],
	[4.0955000000E+04, 3.9151296731E+01, 5.4470277524E+00, 2.0299572745E+01, 3.8701125352E+00, 9.7194923480E-01],
	[4.0960000000E+04, 3.9159658791E+01, 5.4470657282E+00, 2.0307680951E+01, 3.8705080318E+00, 9.7196164890E-01],
	[4.0965000000E+04, 3.9168021617E+01, 5.4471036996E+00, 2.0315791403E+01, 3.8709034257E+00, 9.7197405681E-01],
	[4.0970000000E+04, 3.9176385207E+01, 5.4471416667E+00, 2.0323904104E+01, 3.8712987170E+00, 9.7198645853E-01],
	[4.0975000000E+04, 3.9184749562E+01, 5.4471796293E+00, 2.0332019052E+01, 3.8716939055E+00, 9.7199885405E-01],
	[4.0980000000E+04, 3.9193114682E+01, 5.4472175877E+00, 2.0340136248E+01, 3.8720889914E+00, 9.7201124339E-01],
	[4.0985000000E+04, 3.9201480568E+01, 5.4472555416E+00, 2.0348255693E+01, 3.8724839746E+00, 9.7202362654E-01],
	[4.0990000000E+04, 3.9209847218E+01, 5.4472934912E+00, 2.0356377387E+01, 3.8728788553E+00, 9.7203600351E-01],
	[4.0995000000E+04, 3.9218214632E+01, 5.4473314364E+00, 2.0364501330E+01, 3.8732736334E+00, 9.7204837430E-01],
	[4.1000000000E+04, 3.9226582812E+01, 5.4473693773E+00, 2.0372627522E+01, 3.8736683089E+00, 9.7206073892E-01],
	[4.1005000000E+04, 3.9234951756E+01, 5.4474073138E+00, 2.0380755964E+01, 3.8740628819E+00, 9.7207309738E-01],
	[4.1010000000E+04, 3.9243321465E+01, 5.4474452459E+00, 2.0388886656E+01, 3.8744573524E+00, 9.7208544966E-01],
	[4.1015000000E+04, 3.9251691939E+01, 5.4474831737E+00, 2.0397019599E+01, 3.8748517204E+00, 9.7209779578E-01],
	[4.1020000000E+04, 3.9260063178E+01, 5.4475210971E+00, 2.0405154793E+01, 3.8752459860E+00, 9.7211013574E-01],
	[4.1025000000E+04, 3.9268435181E+01, 5.4475590162E+00, 2.0413292238E+01, 3.8756401491E+00, 9.7212246954E-01],
	[4.1030000000E+04, 3.9276807949E+01, 5.4475969309E+00, 2.0421431935E+01, 3.8760342098E+00, 9.7213479719E-01],
	[4.1035000000E+04, 3.9285181482E+01, 5.4476348412E+00, 2.0429573884E+01, 3.8764281681E+00, 9.7214711869E-01],
	[4.1040000000E+04, 3.9293555779E+01, 5.4476727472E+00, 2.0437718085E+01, 3.8768220241E+00, 9.7215943405E-01],
	[4.1045000000E+04, 3.9301930841E+01, 5.4477106489E+00, 2.0445864539E+01, 3.8772157777E+00, 9.7217174326E-01],
	[4.1050000000E+04, 3.9310306667E+01, 5.4477485461E+00, 2.0454013245E+01, 3.8776094291E+00, 9.7218404633E-01],
	[4.1055000000E+04, 3.9318683258E+01, 5.4477864391E+00, 2.0462164205E+01, 3.8780029781E+00, 9.7219634326E-01],
	[4.1060000000E+04, 3.9327060614E+01, 5.4478243277E+00, 2.0470317419E+01, 3.8783964249E+00, 9.7220863407E-01],
	[4.1065000000E+04, 3.9335438734E+01, 5.4478622119E+00, 2.0478472887E+01, 3.8787897694E+00, 9.7222091874E-01],
	[4.1070000000E+04, 3.9343817618E+01, 5.4479000918E+00, 2.0486630609E+01, 3.8791830118E+00, 9.7223319729E-01],
	[4.1075000000E+04, 3.9352197267E+01, 5.4479379673E+00, 2.0494790586E+01, 3.8795761519E+00, 9.7224546971E-01],
	[4.1080000000E+04, 3.9360577680E+01, 5.4479758385E+00, 2.0502952818E+01, 3.8799691899E+00, 9.7225773602E-01],
	[4.1085000000E+04, 3.9368958858E+01, 5.4480137053E+00, 2.0511117305E+01, 3.8803621257E+00, 9.7226999621E-01],
	[4.1090000000E+04, 3.9377340800E+01, 5.4480515678E+00, 2.0519284049E+01, 3.8807549594E+00, 9.7228225029E-01],
	[4.1095000000E+04, 3.9385723507E+01, 5.4480894260E+00, 2.0527453048E+01, 3.8811476911E+00, 9.7229449826E-01],
	[4.1100000000E+04, 3.9394106977E+01, 5.4481272798E+00, 2.0535624304E+01, 3.8815403206E+00, 9.7230674012E-01],
	[4.1105000000E+04, 3.9402491213E+01, 5.4481651293E+00, 2.0543797817E+01, 3.8819328481E+00, 9.7231897588E-01],
	[4.1110000000E+04, 3.9410876212E+01, 5.4482029744E+00, 2.0551973586E+01, 3.8823252736E+00, 9.7233120554E-01],
	[4.1115000000E+04, 3.9419261976E+01, 5.4482408152E+00, 2.0560151614E+01, 3.8827175972E+00, 9.7234342911E-01],
	[4.1120000000E+04, 3.9427648504E+01, 5.4482786516E+00, 2.0568331899E+01, 3.8831098187E+00, 9.7235564658E-01],
	[4.1125000000E+04, 3.9436035796E+01, 5.4483164837E+00, 2.0576514442E+01, 3.8835019383E+00, 9.7236785797E-01],
	[4.1130000000E+04, 3.9444423852E+01, 5.4483543115E+00, 2.0584699245E+01, 3.8838939560E+00, 9.7238006327E-01],
	[4.1135000000E+04, 3.9452812673E+01, 5.4483921349E+00, 2.0592886306E+01, 3.8842858718E+00, 9.7239226249E-01],
	[4.1140000000E+04, 3.9461202258E+01, 5.4484299540E+00, 2.0601075626E+01, 3.8846776857E+00, 9.7240445563E-01],
	[4.1145000000E+04, 3.9469592607E+01, 5.4484677688E+00, 2.0609267206E+01, 3.8850693977E+00, 9.7241664270E-01],
	[4.1150000000E+04, 3.9477983720E+01, 5.4485055792E+00, 2.0617461045E+01, 3.8854610080E+00, 9.7242882370E-01],
	[4.1155000000E+04, 3.9486375597E+01, 5.4485433853E+00, 2.0625657146E+01, 3.8858525164E+00, 9.7244099862E-01],
	[4.1160000000E+04, 3.9494768238E+01, 5.4485811871E+00, 2.0633855506E+01, 3.8862439231E+00, 9.7245316748E-01],
	[4.1165000000E+04, 3.9503171391E+01, 5.4486201235E+00, 2.0642056128E+01, 3.8866359019E+00, 9.7246533028E-01],
	[4.1170000000E+04, 3.9511584135E+01, 5.4486600862E+00, 2.0650259011E+01, 3.8870283891E+00, 9.7247748703E-01],
	[4.1175000000E+04, 3.9519997649E+01, 5.4487000444E+00, 2.0658464156E+01, 3.8874207749E+00, 9.7248963771E-01],
	[4.1180000000E+04, 3.9528411932E+01, 5.4487399980E+00, 2.0666671563E+01, 3.8878130593E+00, 9.7250178235E-01],
	[4.1185000000E+04, 3.9536826985E+01, 5.4487799470E+00, 2.0674881233E+01, 3.8882052423E+00, 9.7251392093E-01],
	[4.1190000000E+04, 3.9545242808E+01, 5.4488198915E+00, 2.0683093165E+01, 3.8885973239E+00, 9.7252605347E-01],
	[4.1195000000E+04, 3.9553659400E+01, 5.4488598314E+00, 2.0691307360E+01, 3.8889893042E+00, 9.7253817996E-01],
	[4.1200000000E+04, 3.9562076761E+01, 5.4488997668E+00, 2.0699523818E+01, 3.8893811832E+00, 9.7255030041E-01],
	[4.1205000000E+04, 3.9570494893E+01, 5.4489396976E+00, 2.0707742541E+01, 3.8897729609E+00, 9.7256241483E-01],
	[4.1210000000E+04, 3.9578913793E+01, 5.4489796239E+00, 2.0715963527E+01, 3.8901646373E+00, 9.7257452321E-01],
	[4.1215000000E+04, 3.9587333463E+01, 5.4490195456E+00, 2.0724186779E+01, 3.8905562126E+00, 9.7258662556E-01],
	[4.1220000000E+04, 3.9595753903E+01, 5.4490594628E+00, 2.0732412294E+01, 3.8909476866E+00, 9.7259872189E-01],
	[4.1225000000E+04, 3.9604175112E+01, 5.4490993754E+00, 2.0740640076E+01, 3.8913390594E+00, 9.7261081219E-01],
	[4.1230000000E+04, 3.9612597090E+01, 5.4491392835E+00, 2.0748870122E+01, 3.8917303310E+00, 9.7262289646E-01],
	[4.1235000000E+04, 3.9621019838E+01, 5.4491791870E+00, 2.0757102435E+01, 3.8921215015E+00, 9.7263497472E-01],
	[4.1240000000E+04, 3.9629443354E+01, 5.4492190860E+00, 2.0765337014E+01, 3.8925125709E+00, 9.7264704696E-01],
	[4.1245000000E+04, 3.9637867641E+01, 5.4492589804E+00, 2.0773573859E+01, 3.8929035392E+00, 9.7265911319E-01],
	[4.1250000000E+04, 3.9646292696E+01, 5.4492988703E+00, 2.0781812971E+01, 3.8932944064E+00, 9.7267117341E-01],
	[4.1255000000E+04, 3.9654718521E+01, 5.4493387557E+00, 2.0790054351E+01, 3.8936851726E+00, 9.7268322762E-01],
	[4.1260000000E+04, 3.9663145115E+01, 5.4493786365E+00, 2.0798297998E+01, 3.8940758377E+00, 9.7269527583E-01],
	[4.1265000000E+04, 3.9671572479E+01, 5.4494185127E+00, 2.0806543913E+01, 3.8944664019E+00, 9.7270731804E-01],
	[4.1270000000E+04, 3.9680000611E+01, 5.4494583845E+00, 2.0814792097E+01, 3.8948568651E+00, 9.7271935425E-01],
	[4.1275000000E+04, 3.9688429513E+01, 5.4494982517E+00, 2.0823042549E+01, 3.8952472274E+00, 9.7273138447E-01],
	[4.1280000000E+04, 3.9696859184E+01, 5.4495381143E+00, 2.0831295270E+01, 3.8956374887E+00, 9.7274340869E-01],
	[4.1285000000E+04, 3.9705289624E+01, 5.4495779724E+00, 2.0839550261E+01, 3.8960276491E+00, 9.7275542693E-01],
	[4.1290000000E+04, 3.9713720833E+01, 5.4496178260E+00, 2.0847807521E+01, 3.8964177087E+00, 9.7276743918E-01],
	[4.1295000000E+04, 3.9722152811E+01, 5.4496576750E+00, 2.0856067051E+01, 3.8968076674E+00, 9.7277944545E-01],
	[4.1300000000E+04, 3.9730585558E+01, 5.4496975195E+00, 2.0864328852E+01, 3.8971975252E+00, 9.7279144574E-01],
	[4.1305000000E+04, 3.9739019075E+01, 5.4497373595E+00, 2.0872592923E+01, 3.8975872823E+00, 9.7280344006E-01],
	[4.1310000000E+04, 3.9747453360E+01, 5.4497771950E+00, 2.0880859266E+01, 3.8979769386E+00, 9.7281542840E-01],
	[4.1315000000E+04, 3.9755888414E+01, 5.4498170259E+00, 2.0889127880E+01, 3.8983664942E+00, 9.7282741077E-01],
	[4.1320000000E+04, 3.9764324237E+01, 5.4498568523E+00, 2.0897398766E+01, 3.8987559490E+00, 9.7283938718E-01],
	[4.1325000000E+04, 3.9772760830E+01, 5.4498966741E+00, 2.0905671924E+01, 3.8991453031E+00, 9.7285135762E-01],
	[4.1330000000E+04, 3.9781198191E+01, 5.4499364915E+00, 2.0913947355E+01, 3.8995345565E+00, 9.7286332210E-01],
	[4.1335000000E+04, 3.9789636321E+01, 5.4499763043E+00, 2.0922225058E+01, 3.8999237093E+00, 9.7287528063E-01],
	[4.1340000000E+04, 3.9798075220E+01, 5.4500161126E+00, 2.0930505035E+01, 3.9003127615E+00, 9.7288723319E-01],
	[4.1345000000E+04, 3.9806514887E+01, 5.4500559163E+00, 2.0938787285E+01, 3.9007017130E+00, 9.7289917981E-01],
	[4.1350000000E+04, 3.9814955324E+01, 5.4500957155E+00, 2.0947071809E+01, 3.9010905640E+00, 9.7291112048E-01],
	[4.1355000000E+04, 3.9823396529E+01, 5.4501355103E+00, 2.0955358608E+01, 3.9014793144E+00, 9.7292305521E-01],
	[4.1360000000E+04, 3.9831838504E+01, 5.4501753004E+00, 2.0963647681E+01, 3.9018679642E+00, 9.7293498399E-01],
	[4.1365000000E+04, 3.9840281247E+01, 5.4502150861E+00, 2.0971939029E+01, 3.9022565136E+00, 9.7294690683E-01],
	[4.1370000000E+04, 3.9848724758E+01, 5.4502548673E+00, 2.0980232652E+01, 3.9026449624E+00, 9.7295882374E-01],
	[4.1375000000E+04, 3.9857169039E+01, 5.4502946439E+00, 2.0988528551E+01, 3.9030333108E+00, 9.7297073471E-01],
	[4.1380000000E+04, 3.9865614088E+01, 5.4503344160E+00, 2.0996826726E+01, 3.9034215588E+00, 9.7298263975E-01],
	[4.1385000000E+04, 3.9874059906E+01, 5.4503741836E+00, 2.1005127177E+01, 3.9038097064E+00, 9.7299453887E-01],
	[4.1390000000E+04, 3.9882506492E+01, 5.4504139467E+00, 2.1013429905E+01, 3.9041977535E+00, 9.7300643206E-01],
	[4.1395000000E+04, 3.9890953847E+01, 5.4504537053E+00, 2.1021734910E+01, 3.9045857003E+00, 9.7301831933E-01],
	[4.1400000000E+04, 3.9899401971E+01, 5.4504934594E+00, 2.1030042192E+01, 3.9049735468E+00, 9.7303020068E-01],
	[4.1405000000E+04, 3.9907850863E+01, 5.4505332089E+00, 2.1038351752E+01, 3.9053612929E+00, 9.7304207612E-01],
	[4.1410000000E+04, 3.9916300524E+01, 5.4505729540E+00, 2.1046663590E+01, 3.9057489388E+00, 9.7305394565E-01],
	[4.1415000000E+04, 3.9924750953E+01, 5.4506126945E+00, 2.1054977707E+01, 3.9061364844E+00, 9.7306580927E-01],
	[4.1420000000E+04, 3.9933202151E+01, 5.4506524305E+00, 2.1063294102E+01, 3.9065239297E+00, 9.7307766698E-01],
	[4.1425000000E+04, 3.9941654117E+01, 5.4506921621E+00, 2.1071612777E+01, 3.9069112748E+00, 9.7308951879E-01],
	[4.1430000000E+04, 3.9950106852E+01, 5.4507318891E+00, 2.1079933731E+01, 3.9072985198E+00, 9.7310136470E-01],
	[4.1435000000E+04, 3.9958560355E+01, 5.4507716116E+00, 2.1088256965E+01, 3.9076856645E+00, 9.7311320471E-01],
	[4.1440000000E+04, 3.9967014627E+01, 5.4508113296E+00, 2.1096582479E+01, 3.9080727091E+00, 9.7312503883E-01],
	[4.1445000000E+04, 3.9975469667E+01, 5.4508510431E+00, 2.1104910274E+01, 3.9084596536E+00, 9.7313686706E-01],
	[4.1450000000E+04, 3.9983925475E+01, 5.4508907521E+00, 2.1113240349E+01, 3.9088464980E+00, 9.7314868941E-01],
	[4.1455000000E+04, 3.9992382052E+01, 5.4509304566E+00, 2.1121572706E+01, 3.9092332423E+00, 9.7316050586E-01],
	[4.1460000000E+04, 4.0000839397E+01, 5.4509701566E+00, 2.1129907344E+01, 3.9096198866E+00, 9.7317231644E-01],
	[4.1465000000E+04, 4.0009297511E+01, 5.4510098521E+00, 2.1138244264E+01, 3.9100064308E+00, 9.7318412114E-01],
	[4.1470000000E+04, 4.0017756392E+01, 5.4510495431E+00, 2.1146583467E+01, 3.9103928751E+00, 9.7319591996E-01],
	[4.1475000000E+04, 4.0026216042E+01, 5.4510892296E+00, 2.1154924952E+01, 3.9107792193E+00, 9.7320771291E-01],
	[4.1480000000E+04, 4.0034676461E+01, 5.4511289117E+00, 2.1163268720E+01, 3.9111654637E+00, 9.7321950000E-01],
	[4.1485000000E+04, 4.0043137647E+01, 5.4511685892E+00, 2.1171614771E+01, 3.9115516080E+00, 9.7323128121E-01],
	[4.1490000000E+04, 4.0051599602E+01, 5.4512082622E+00, 2.1179963106E+01, 3.9119376525E+00, 9.7324305656E-01],
	[4.1495000000E+04, 4.0060062324E+01, 5.4512479308E+00, 2.1188313725E+01, 3.9123235971E+00, 9.7325482606E-01],
	[4.1500000000E+04, 4.0068525815E+01, 5.4512875948E+00, 2.1196666629E+01, 3.9127094419E+00, 9.7326658969E-01],
	[4.1505000000E+04, 4.0076990074E+01, 5.4513272544E+00, 2.1205021817E+01, 3.9130951868E+00, 9.7327834748E-01],
	[4.1510000000E+04, 4.0085455101E+01, 5.4513669094E+00, 2.1213379290E+01, 3.9134808319E+00, 9.7329009941E-01],
	[4.1515000000E+04, 4.0093920897E+01, 5.4514065600E+00, 2.1221739049E+01, 3.9138663773E+00, 9.7330184549E-01],
	[4.1520000000E+04, 4.0102387460E+01, 5.4514462061E+00, 2.1230101093E+01, 3.9142518228E+00, 9.7331358573E-01],
	[4.1525000000E+04, 4.0110854791E+01, 5.4514858477E+00, 2.1238465424E+01, 3.9146371687E+00, 9.7332532013E-01],
	[4.1530000000E+04, 4.0119322890E+01, 5.4515254848E+00, 2.1246832041E+01, 3.9150224148E+00, 9.7333704869E-01],
	[4.1535000000E+04, 4.0127791758E+01, 5.4515651175E+00, 2.1255200945E+01, 3.9154075612E+00, 9.7334877141E-01],
	[4.1540000000E+04, 4.0136261393E+01, 5.4516047456E+00, 2.1263572136E+01, 3.9157926080E+00, 9.7336048830E-01],
	[4.1545000000E+04, 4.0144731796E+01, 5.4516443693E+00, 2.1271945614E+01, 3.9161775552E+00, 9.7337219936E-01],
	[4.1550000000E+04, 4.0153202967E+01, 5.4516839885E+00, 2.1280321381E+01, 3.9165624027E+00, 9.7338390459E-01],
	[4.1555000000E+04, 4.0161674906E+01, 5.4517236032E+00, 2.1288699435E+01, 3.9169471507E+00, 9.7339560400E-01],
	[4.1560000000E+04, 4.0170147613E+01, 5.4517632134E+00, 2.1297079778E+01, 3.9173317991E+00, 9.7340729759E-01],
	[4.1565000000E+04, 4.0178621088E+01, 5.4518028192E+00, 2.1305462410E+01, 3.9177163479E+00, 9.7341898537E-01],
	[4.1570000000E+04, 4.0187095330E+01, 5.4518424205E+00, 2.1313847332E+01, 3.9181007972E+00, 9.7343066733E-01],
	[4.1575000000E+04, 4.0195570341E+01, 5.4518820173E+00, 2.1322234543E+01, 3.9184851471E+00, 9.7344234347E-01],
	[4.1580000000E+04, 4.0204046119E+01, 5.4519216096E+00, 2.1330624044E+01, 3.9188693974E+00, 9.7345401381E-01],
	[4.1585000000E+04, 4.0212522665E+01, 5.4519611975E+00, 2.1339015835E+01, 3.9192535484E+00, 9.7346567834E-01],
	[4.1590000000E+04, 4.0220999978E+01, 5.4520007809E+00, 2.1347409917E+01, 3.9196375999E+00, 9.7347733708E-01],
	[4.1595000000E+04, 4.0229478060E+01, 5.4520403598E+00, 2.1355806289E+01, 3.9200215520E+00, 9.7348899001E-01],
	[4.1600000000E+04, 4.0237956909E+01, 5.4520799342E+00, 2.1364204954E+01, 3.9204054048E+00, 9.7350063714E-01],
	[4.1605000000E+04, 4.0246436525E+01, 5.4521195042E+00, 2.1372605909E+01, 3.9207891582E+00, 9.7351227849E-01],
	[4.1610000000E+04, 4.0254916910E+01, 5.4521590697E+00, 2.1381009157E+01, 3.9211728123E+00, 9.7352391404E-01],
	[4.1615000000E+04, 4.0263398062E+01, 5.4521986308E+00, 2.1389414698E+01, 3.9215563671E+00, 9.7353554380E-01],
	[4.1620000000E+04, 4.0271879981E+01, 5.4522381873E+00, 2.1397822531E+01, 3.9219398226E+00, 9.7354716778E-01],
	[4.1625000000E+04, 4.0280362668E+01, 5.4522777394E+00, 2.1406232657E+01, 3.9223231789E+00, 9.7355878598E-01],
	[4.1630000000E+04, 4.0288846123E+01, 5.4523172871E+00, 2.1414645077E+01, 3.9227064359E+00, 9.7357039841E-01],
	[4.1635000000E+04, 4.0297330345E+01, 5.4523568303E+00, 2.1423059790E+01, 3.9230895938E+00, 9.7358200505E-01],
	[4.1640000000E+04, 4.0305815335E+01, 5.4523963690E+00, 2.1431476798E+01, 3.9234726524E+00, 9.7359360593E-01],
	[4.1645000000E+04, 4.0314301092E+01, 5.4524359033E+00, 2.1439896100E+01, 3.9238556120E+00, 9.7360520103E-01],
	[4.1650000000E+04, 4.0322787617E+01, 5.4524754331E+00, 2.1448317697E+01, 3.9242384724E+00, 9.7361679037E-01],
	[4.1655000000E+04, 4.0331274909E+01, 5.4525149584E+00, 2.1456741589E+01, 3.9246212337E+00, 9.7362837395E-01],
	[4.1660000000E+04, 4.0339762969E+01, 5.4525544793E+00, 2.1465167777E+01, 3.9250038959E+00, 9.7363995177E-01],
	[4.1665000000E+04, 4.0348251796E+01, 5.4525939957E+00, 2.1473596260E+01, 3.9253864591E+00, 9.7365152383E-01],
	[4.1670000000E+04, 4.0356741390E+01, 5.4526335077E+00, 2.1482027040E+01, 3.9257689232E+00, 9.7366309014E-01],
	[4.1675000000E+04, 4.0365231751E+01, 5.4526730152E+00, 2.1490460116E+01, 3.9261512883E+00, 9.7367465069E-01],
	[4.1680000000E+04, 4.0373722880E+01, 5.4527125183E+00, 2.1498895490E+01, 3.9265335545E+00, 9.7368620550E-01],
	[4.1685000000E+04, 4.0382214777E+01, 5.4527520169E+00, 2.1507333160E+01, 3.9269157217E+00, 9.7369775456E-01],
	[4.1690000000E+04, 4.0390707440E+01, 5.4527915111E+00, 2.1515773129E+01, 3.9272977899E+00, 9.7370929788E-01],
	[4.1695000000E+04, 4.0399200871E+01, 5.4528310008E+00, 2.1524215395E+01, 3.9276797593E+00, 9.7372083547E-01],
	[4.1700000000E+04, 4.0407695069E+01, 5.4528704860E+00, 2.1532659960E+01, 3.9280616298E+00, 9.7373236731E-01],
	[4.1705000000E+04, 4.0416190034E+01, 5.4529099668E+00, 2.1541106823E+01, 3.9284434014E+00, 9.7374389343E-01],
	[4.1710000000E+04, 4.0424685767E+01, 5.4529494432E+00, 2.1549555985E+01, 3.9288250742E+00, 9.7375541381E-01],
	[4.1715000000E+04, 4.0433182266E+01, 5.4529889151E+00, 2.1558007447E+01, 3.9292066482E+00, 9.7376692847E-01],
	[4.1720000000E+04, 4.0441679533E+01, 5.4530283826E+00, 2.1566461208E+01, 3.9295881233E+00, 9.7377843740E-01],
	[4.1725000000E+04, 4.0450177567E+01, 5.4530678456E+00, 2.1574917270E+01, 3.9299694998E+00, 9.7378994062E-01],
	[4.1730000000E+04, 4.0458676368E+01, 5.4531073042E+00, 2.1583375632E+01, 3.9303507775E+00, 9.7380143811E-01],
	[4.1735000000E+04, 4.0467175936E+01, 5.4531467584E+00, 2.1591836295E+01, 3.9307319564E+00, 9.7381292989E-01],
	[4.1740000000E+04, 4.0475676271E+01, 5.4531862081E+00, 2.1600299259E+01, 3.9311130367E+00, 9.7382441596E-01],
	[4.1745000000E+04, 4.0484177373E+01, 5.4532256533E+00, 2.1608764524E+01, 3.9314940183E+00, 9.7383589632E-01],
	[4.1750000000E+04, 4.0492679242E+01, 5.4532650942E+00, 2.1617232091E+01, 3.9318749013E+00, 9.7384737098E-01],
	[4.1755000000E+04, 4.0501181879E+01, 5.4533045306E+00, 2.1625701961E+01, 3.9322556857E+00, 9.7385883993E-01],
	[4.1760000000E+04, 4.0509685282E+01, 5.4533439625E+00, 2.1634174133E+01, 3.9326363715E+00, 9.7387030318E-01],
	[4.1765000000E+04, 4.0518189452E+01, 5.4533833900E+00, 2.1642648608E+01, 3.9330169587E+00, 9.7388176074E-01],
	[4.1770000000E+04, 4.0526694389E+01, 5.4534228131E+00, 2.1651125386E+01, 3.9333974474E+00, 9.7389321260E-01],
	[4.1775000000E+04, 4.0535200092E+01, 5.4534622318E+00, 2.1659604467E+01, 3.9337778375E+00, 9.7390465878E-01],
	[4.1780000000E+04, 4.0543706563E+01, 5.4535016460E+00, 2.1668085853E+01, 3.9341581292E+00, 9.7391609926E-01],
	[4.1785000000E+04, 4.0552213801E+01, 5.4535410557E+00, 2.1676569543E+01, 3.9345383223E+00, 9.7392753406E-01],
	[4.1790000000E+04, 4.0560721805E+01, 5.4535804611E+00, 2.1685055537E+01, 3.9349184171E+00, 9.7393896318E-01],
	[4.1795000000E+04, 4.0569230576E+01, 5.4536198620E+00, 2.1693543837E+01, 3.9352984134E+00, 9.7395038662E-01],
	[4.1800000000E+04, 4.0577740114E+01, 5.4536592585E+00, 2.1702034442E+01, 3.9356783113E+00, 9.7396180438E-01],
	[4.1805000000E+04, 4.0586250419E+01, 5.4536986506E+00, 2.1710527352E+01, 3.9360581109E+00, 9.7397321648E-01],
	[4.1810000000E+04, 4.0594761490E+01, 5.4537380382E+00, 2.1719022569E+01, 3.9364378121E+00, 9.7398462290E-01],
	[4.1815000000E+04, 4.0603273329E+01, 5.4537774214E+00, 2.1727520092E+01, 3.9368174150E+00, 9.7399602365E-01],
	[4.1820000000E+04, 4.0611785933E+01, 5.4538168002E+00, 2.1736019921E+01, 3.9371969195E+00, 9.7400741875E-01],
	[4.1825000000E+04, 4.0620299305E+01, 5.4538561746E+00, 2.1744522058E+01, 3.9375763258E+00, 9.7401880818E-01],
	[4.1830000000E+04, 4.0628831796E+01, 5.4538976515E+00, 2.1753026502E+01, 3.9379569048E+00, 9.7403019195E-01],
	[4.1835000000E+04, 4.0637365184E+01, 5.4539391380E+00, 2.1761533254E+01, 3.9383373943E+00, 9.7404157007E-01],
	[4.1840000000E+04, 4.0645899344E+01, 5.4539806200E+00, 2.1770042314E+01, 3.9387177860E+00, 9.7405294254E-01],
	[4.1845000000E+04, 4.0654434276E+01, 5.4540220972E+00, 2.1778553683E+01, 3.9390980797E+00, 9.7406430936E-01],
	[4.1850000000E+04, 4.0662969980E+01, 5.4540635699E+00, 2.1787067360E+01, 3.9394782755E+00, 9.7407567053E-01],
	[4.1855000000E+04, 4.0671506456E+01, 5.4541050379E+00, 2.1795583347E+01, 3.9398583734E+00, 9.7408702607E-01],
	[4.1860000000E+04, 4.0680043705E+01, 5.4541465012E+00, 2.1804101643E+01, 3.9402383735E+00, 9.7409837596E-01],
	[4.1865000000E+04, 4.0688581725E+01, 5.4541879600E+00, 2.1812622249E+01, 3.9406182757E+00, 9.7410972021E-01],
	[4.1870000000E+04, 4.0697120517E+01, 5.4542294141E+00, 2.1821145165E+01, 3.9409980801E+00, 9.7412105884E-01],
	[4.1875000000E+04, 4.0705660082E+01, 5.4542708635E+00, 2.1829670392E+01, 3.9413777868E+00, 9.7413239183E-01],
	[4.1880000000E+04, 4.0714200418E+01, 5.4543123083E+00, 2.1838197930E+01, 3.9417573957E+00, 9.7414371919E-01],
	[4.1885000000E+04, 4.0722741526E+01, 5.4543537485E+00, 2.1846727779E+01, 3.9421369068E+00, 9.7415504093E-01],
	[4.1890000000E+04, 4.0731283407E+01, 5.4543951841E+00, 2.1855259940E+01, 3.9425163203E+00, 9.7416635705E-01],
	[4.1895000000E+04, 4.0739826059E+01, 5.4544366150E+00, 2.1863794412E+01, 3.9428956360E+00, 9.7417766755E-01],
	[4.1900000000E+04, 4.0748369483E+01, 5.4544780413E+00, 2.1872331197E+01, 3.9432748541E+00, 9.7418897243E-01],
	[4.1905000000E+04, 4.0756913678E+01, 5.4545194629E+00, 2.1880870295E+01, 3.9436539746E+00, 9.7420027170E-01],
	[4.1910000000E+04, 4.0765458646E+01, 5.4545608800E+00, 2.1889411705E+01, 3.9440329974E+00, 9.7421156536E-01],
	[4.1915000000E+04, 4.0774004385E+01, 5.4546022924E+00, 2.1897955430E+01, 3.9444119227E+00, 9.7422285342E-01],
	[4.1920000000E+04, 4.0782550897E+01, 5.4546437002E+00, 2.1906501467E+01, 3.9447907504E+00, 9.7423413587E-01],
	[4.1925000000E+04, 4.0791098180E+01, 5.4546851033E+00, 2.1915049819E+01, 3.9451694806E+00, 9.7424541272E-01],
	[4.1930000000E+04, 4.0799646234E+01, 5.4547265019E+00, 2.1923600485E+01, 3.9455481132E+00, 9.7425668397E-01],
	[4.1935000000E+04, 4.0808195061E+01, 5.4547678958E+00, 2.1932153466E+01, 3.9459266484E+00, 9.7426794963E-01],
	[4.1940000000E+04, 4.0816744659E+01, 5.4548092851E+00, 2.1940708763E+01, 3.9463050860E+00, 9.7427920969E-01],
	[4.1945000000E+04, 4.0825295029E+01, 5.4548506698E+00, 2.1949266374E+01, 3.9466834263E+00, 9.7429046417E-01],
	[4.1950000000E+04, 4.0833846170E+01, 5.4548920498E+00, 2.1957826302E+01, 3.9470616691E+00, 9.7430171306E-01],
	[4.1955000000E+04, 4.0842398084E+01, 5.4549334253E+00, 2.1966388545E+01, 3.9474398145E+00, 9.7431295637E-01],
	[4.1960000000E+04, 4.0850950768E+01, 5.4549747961E+00, 2.1974953106E+01, 3.9478178626E+00, 9.7432419410E-01],
	[4.1965000000E+04, 4.0859504225E+01, 5.4550161623E+00, 2.1983519983E+01, 3.9481958133E+00, 9.7433542625E-01],
	[4.1970000000E+04, 4.0868058452E+01, 5.4550575239E+00, 2.1992089177E+01, 3.9485736666E+00, 9.7434665283E-01],
	[4.1975000000E+04, 4.0876613452E+01, 5.4550988808E+00, 2.2000660689E+01, 3.9489514227E+00, 9.7435787383E-01],
	[4.1980000000E+04, 4.0885169223E+01, 5.4551402332E+00, 2.2009234519E+01, 3.9493290815E+00, 9.7436908927E-01],
	[4.1985000000E+04, 4.0893725765E+01, 5.4551815810E+00, 2.2017810667E+01, 3.9497066431E+00, 9.7438029915E-01],
	[4.1990000000E+04, 4.0902283079E+01, 5.4552229241E+00, 2.2026389134E+01, 3.9500841074E+00, 9.7439150346E-01],
	[4.1995000000E+04, 4.0910841164E+01, 5.4552642626E+00, 2.2034969919E+01, 3.9504614745E+00, 9.7440270221E-01],
	[4.2000000000E+04, 4.0919400021E+01, 5.4553055966E+00, 2.2043553024E+01, 3.9508387445E+00, 9.7441389541E-01],
	[4.2005000000E+04, 4.0927959649E+01, 5.4553469259E+00, 2.2052138449E+01, 3.9512159173E+00, 9.7442508305E-01],
	[4.2010000000E+04, 4.0936520049E+01, 5.4553882506E+00, 2.2060726194E+01, 3.9515929929E+00, 9.7443626515E-01],
	[4.2015000000E+04, 4.0945081220E+01, 5.4554295707E+00, 2.2069316259E+01, 3.9519699715E+00, 9.7444744169E-01],
	[4.2020000000E+04, 4.0953643162E+01, 5.4554708862E+00, 2.2077908645E+01, 3.9523468530E+00, 9.7445861270E-01],
	[4.2025000000E+04, 4.0962205876E+01, 5.4555121971E+00, 2.2086503352E+01, 3.9527236374E+00, 9.7446977816E-01],
	[4.2030000000E+04, 4.0970769361E+01, 5.4555535034E+00, 2.2095100380E+01, 3.9531003248E+00, 9.7448093808E-01],
	[4.2035000000E+04, 4.0979333617E+01, 5.4555948051E+00, 2.2103699730E+01, 3.9534769152E+00, 9.7449209247E-01],
	[4.2040000000E+04, 4.0987898644E+01, 5.4556361022E+00, 2.2112301402E+01, 3.9538534085E+00, 9.7450324132E-01],
	[4.2045000000E+04, 4.0996464443E+01, 5.4556773947E+00, 2.2120905397E+01, 3.9542298050E+00, 9.7451438465E-01],
	[4.2050000000E+04, 4.1005031013E+01, 5.4557186826E+00, 2.2129511715E+01, 3.9546061045E+00, 9.7452552245E-01],
	[4.2055000000E+04, 4.1013598354E+01, 5.4557599659E+00, 2.2138120356E+01, 3.9549823070E+00, 9.7453665473E-01],
	[4.2060000000E+04, 4.1022166466E+01, 5.4558012446E+00, 2.2146731320E+01, 3.9553584127E+00, 9.7454778148E-01],
	[4.2065000000E+04, 4.1030735349E+01, 5.4558425187E+00, 2.2155344608E+01, 3.9557344216E+00, 9.7455890272E-01],
	[4.2070000000E+04, 4.1039305004E+01, 5.4558837882E+00, 2.2163960220E+01, 3.9561103336E+00, 9.7457001845E-01],
	[4.2075000000E+04, 4.1047875429E+01, 5.4559250531E+00, 2.2172578157E+01, 3.9564861487E+00, 9.7458112866E-01],
	[4.2080000000E+04, 4.1056446626E+01, 5.4559663135E+00, 2.2181198419E+01, 3.9568618671E+00, 9.7459223336E-01],
	[4.2085000000E+04, 4.1065018594E+01, 5.4560075692E+00, 2.2189821007E+01, 3.9572374887E+00, 9.7460333256E-01],
	[4.2090000000E+04, 4.1073591332E+01, 5.4560488204E+00, 2.2198445919E+01, 3.9576130136E+00, 9.7461442626E-01],
	[4.2095000000E+04, 4.1082164842E+01, 5.4560900669E+00, 2.2207073158E+01, 3.9579884417E+00, 9.7462551445E-01],
	[4.2100000000E+04, 4.1090739123E+01, 5.4561313089E+00, 2.2215702723E+01, 3.9583637732E+00, 9.7463659715E-01],
	[4.2105000000E+04, 4.1099314174E+01, 5.4561725463E+00, 2.2224334615E+01, 3.9587390080E+00, 9.7464767436E-01],
	[4.2110000000E+04, 4.1107889997E+01, 5.4562137791E+00, 2.2232968834E+01, 3.9591141461E+00, 9.7465874607E-01],
	[4.2115000000E+04, 4.1116466590E+01, 5.4562550074E+00, 2.2241605381E+01, 3.9594891876E+00, 9.7466981230E-01],
	[4.2120000000E+04, 4.1125043955E+01, 5.4562962310E+00, 2.2250244255E+01, 3.9598641325E+00, 9.7468087304E-01],
	[4.2125000000E+04, 4.1133622090E+01, 5.4563374501E+00, 2.2258885457E+01, 3.9602389809E+00, 9.7469192830E-01],
	[4.2130000000E+04, 4.1142200996E+01, 5.4563786645E+00, 2.2267528987E+01, 3.9606137327E+00, 9.7470297808E-01],
	[4.2135000000E+04, 4.1150780673E+01, 5.4564198744E+00, 2.2276174846E+01, 3.9609883879E+00, 9.7471402239E-01],
	[4.2140000000E+04, 4.1159361121E+01, 5.4564610798E+00, 2.2284823035E+01, 3.9613629467E+00, 9.7472506122E-01],
	[4.2145000000E+04, 4.1167942339E+01, 5.4565022805E+00, 2.2293473553E+01, 3.9617374090E+00, 9.7473609458E-01],
	[4.2150000000E+04, 4.1176524329E+01, 5.4565434767E+00, 2.2302126401E+01, 3.9621117748E+00, 9.7474712248E-01],
	[4.2155000000E+04, 4.1185107089E+01, 5.4565846683E+00, 2.2310781579E+01, 3.9624860442E+00, 9.7475814491E-01],
	[4.2160000000E+04, 4.1193690619E+01, 5.4566258553E+00, 2.2319439087E+01, 3.9628602172E+00, 9.7476916187E-01],
	[4.2165000000E+04, 4.1202274921E+01, 5.4566670377E+00, 2.2328098927E+01, 3.9632342938E+00, 9.7478017338E-01],
	[4.2170000000E+04, 4.1210859993E+01, 5.4567082156E+00, 2.2336761097E+01, 3.9636082740E+00, 9.7479117944E-01],
	[4.2175000000E+04, 4.1219445836E+01, 5.4567493889E+00, 2.2345425600E+01, 3.9639821580E+00, 9.7480218004E-01],
	[4.2180000000E+04, 4.1228032449E+01, 5.4567905576E+00, 2.2354092434E+01, 3.9643559456E+00, 9.7481317519E-01],
	[4.2185000000E+04, 4.1236619833E+01, 5.4568317218E+00, 2.2362761600E+01, 3.9647296369E+00, 9.7482416490E-01],
	[4.2190000000E+04, 4.1245207988E+01, 5.4568728814E+00, 2.2371433099E+01, 3.9651032320E+00, 9.7483514916E-01],
	[4.2195000000E+04, 4.1253796913E+01, 5.4569140364E+00, 2.2380106931E+01, 3.9654767308E+00, 9.7484612798E-01],
	[4.2200000000E+04, 4.1262386609E+01, 5.4569551868E+00, 2.2388783097E+01, 3.9658501334E+00, 9.7485710137E-01],
	[4.2205000000E+04, 4.1270977075E+01, 5.4569963327E+00, 2.2397461596E+01, 3.9662234398E+00, 9.7486806932E-01],
	[4.2210000000E+04, 4.1279568312E+01, 5.4570374741E+00, 2.2406142429E+01, 3.9665966501E+00, 9.7487903183E-01],
	[4.2215000000E+04, 4.1288160319E+01, 5.4570786108E+00, 2.2414825597E+01, 3.9669697642E+00, 9.7488998892E-01],
	[4.2220000000E+04, 4.1296753096E+01, 5.4571197430E+00, 2.2423511099E+01, 3.9673427822E+00, 9.7490094058E-01],
	[4.2225000000E+04, 4.1305346644E+01, 5.4571608707E+00, 2.2432198937E+01, 3.9677157041E+00, 9.7491188682E-01],
	[4.2230000000E+04, 4.1313940963E+01, 5.4572019937E+00, 2.2440889109E+01, 3.9680885300E+00, 9.7492282764E-01],
	[4.2235000000E+04, 4.1322536052E+01, 5.4572431123E+00, 2.2449581618E+01, 3.9684612598E+00, 9.7493376304E-01],
	[4.2240000000E+04, 4.1331131911E+01, 5.4572842262E+00, 2.2458276463E+01, 3.9688338936E+00, 9.7494469303E-01],
	[4.2245000000E+04, 4.1339728540E+01, 5.4573253356E+00, 2.2466973644E+01, 3.9692064314E+00, 9.7495561761E-01],
	[4.2250000000E+04, 4.1348325940E+01, 5.4573664405E+00, 2.2475673163E+01, 3.9695788732E+00, 9.7496653677E-01],
	[4.2255000000E+04, 4.1356924110E+01, 5.4574075408E+00, 2.2484375018E+01, 3.9699512190E+00, 9.7497745054E-01],
	[4.2260000000E+04, 4.1365523051E+01, 5.4574486365E+00, 2.2493079211E+01, 3.9703234690E+00, 9.7498835889E-01],
	[4.2265000000E+04, 4.1374122762E+01, 5.4574897277E+00, 2.2501785742E+01, 3.9706956230E+00, 9.7499926185E-01],
	[4.2270000000E+04, 4.1382723242E+01, 5.4575308144E+00, 2.2510494611E+01, 3.9710676812E+00, 9.7501015942E-01],
	[4.2275000000E+04, 4.1391324494E+01, 5.4575718965E+00, 2.2519205818E+01, 3.9714396435E+00, 9.7502105158E-01],
	[4.2280000000E+04, 4.1399926515E+01, 5.4576129740E+00, 2.2527919365E+01, 3.9718115100E+00, 9.7503193836E-01],
	[4.2285000000E+04, 4.1408529306E+01, 5.4576540470E+00, 2.2536635251E+01, 3.9721832807E+00, 9.7504281975E-01],
	[4.2290000000E+04, 4.1417132868E+01, 5.4576951154E+00, 2.2545353477E+01, 3.9725549556E+00, 9.7505369576E-01],
	[4.2295000000E+04, 4.1425737200E+01, 5.4577361793E+00, 2.2554074042E+01, 3.9729265348E+00, 9.7506456638E-01],
	[4.2300000000E+04, 4.1434342301E+01, 5.4577772387E+00, 2.2562796948E+01, 3.9732980182E+00, 9.7507543162E-01],
	[4.2305000000E+04, 4.1442948173E+01, 5.4578182935E+00, 2.2571522195E+01, 3.9736694060E+00, 9.7508629149E-01],
	[4.2310000000E+04, 4.1451554815E+01, 5.4578593438E+00, 2.2580249783E+01, 3.9740406980E+00, 9.7509714598E-01],
	[4.2315000000E+04, 4.1460162227E+01, 5.4579003895E+00, 2.2588979712E+01, 3.9744118944E+00, 9.7510799511E-01],
	[4.2320000000E+04, 4.1468770409E+01, 5.4579414307E+00, 2.2597711983E+01, 3.9747829951E+00, 9.7511883886E-01],
	[4.2325000000E+04, 4.1477379361E+01, 5.4579824673E+00, 2.2606446596E+01, 3.9751540003E+00, 9.7512967725E-01],
	[4.2330000000E+04, 4.1485989083E+01, 5.4580234994E+00, 2.2615183551E+01, 3.9755249098E+00, 9.7514051028E-01],
	[4.2335000000E+04, 4.1494599575E+01, 5.4580645270E+00, 2.2623922850E+01, 3.9758957238E+00, 9.7515133795E-01],
	[4.2340000000E+04, 4.1503210837E+01, 5.4581055500E+00, 2.2632664491E+01, 3.9762664423E+00, 9.7516216027E-01],
	[4.2345000000E+04, 4.1511822869E+01, 5.4581465685E+00, 2.2641408476E+01, 3.9766370652E+00, 9.7517297723E-01],
	[4.2350000000E+04, 4.1520435670E+01, 5.4581875825E+00, 2.2650154805E+01, 3.9770075927E+00, 9.7518378884E-01],
	[4.2355000000E+04, 4.1529049241E+01, 5.4582285919E+00, 2.2658903478E+01, 3.9773780247E+00, 9.7519459511E-01],
	[4.2360000000E+04, 4.1537663583E+01, 5.4582695968E+00, 2.2667654496E+01, 3.9777483613E+00, 9.7520539603E-01],
	[4.2365000000E+04, 4.1546278694E+01, 5.4583105972E+00, 2.2676407858E+01, 3.9781186024E+00, 9.7521619160E-01],
	[4.2370000000E+04, 4.1554894575E+01, 5.4583515930E+00, 2.2685163566E+01, 3.9784887481E+00, 9.7522698184E-01],
	[4.2375000000E+04, 4.1563511225E+01, 5.4583925843E+00, 2.2693921620E+01, 3.9788587985E+00, 9.7523776675E-01],
	[4.2380000000E+04, 4.1572128646E+01, 5.4584335711E+00, 2.2702682019E+01, 3.9792287536E+00, 9.7524854632E-01],
	[4.2385000000E+04, 4.1580746836E+01, 5.4584745533E+00, 2.2711444765E+01, 3.9795986133E+00, 9.7525932056E-01],
	[4.2390000000E+04, 4.1589365795E+01, 5.4585155310E+00, 2.2720209857E+01, 3.9799683777E+00, 9.7527008948E-01],
	[4.2395000000E+04, 4.1597985525E+01, 5.4585565042E+00, 2.2728977297E+01, 3.9803380468E+00, 9.7528085307E-01],
	[4.2400000000E+04, 4.1606606024E+01, 5.4585974729E+00, 2.2737747084E+01, 3.9807076207E+00, 9.7529161134E-01],
	[4.2405000000E+04, 4.1615227293E+01, 5.4586384370E+00, 2.2746519218E+01, 3.9810770994E+00, 9.7530236429E-01],
	[4.2410000000E+04, 4.1623849331E+01, 5.4586793966E+00, 2.2755293701E+01, 3.9814464829E+00, 9.7531311193E-01],
	[4.2415000000E+04, 4.1632472139E+01, 5.4587203517E+00, 2.2764070532E+01, 3.9818157712E+00, 9.7532385426E-01],
	[4.2420000000E+04, 4.1641095717E+01, 5.4587613023E+00, 2.2772849712E+01, 3.9821849643E+00, 9.7533459127E-01],
	[4.2425000000E+04, 4.1649720064E+01, 5.4588022484E+00, 2.2781631241E+01, 3.9825540623E+00, 9.7534532298E-01],
	[4.2430000000E+04, 4.1658345180E+01, 5.4588431899E+00, 2.2790415119E+01, 3.9829230653E+00, 9.7535604939E-01],
	[4.2435000000E+04, 4.1666971066E+01, 5.4588841269E+00, 2.2799201347E+01, 3.9832919731E+00, 9.7536677049E-01],
	[4.2440000000E+04, 4.1675597722E+01, 5.4589250594E+00, 2.2807989926E+01, 3.9836607859E+00, 9.7537748630E-01],
	[4.2445000000E+04, 4.1684225147E+01, 5.4589659874E+00, 2.2816780855E+01, 3.9840295037E+00, 9.7538819681E-01],
	[4.2450000000E+04, 4.1692853341E+01, 5.4590069109E+00, 2.2825574135E+01, 3.9843981264E+00, 9.7539890203E-01],
	[4.2455000000E+04, 4.1701482305E+01, 5.4590478299E+00, 2.2834369766E+01, 3.9847666542E+00, 9.7540960196E-01],
	[4.2460000000E+04, 4.1710112038E+01, 5.4590887443E+00, 2.2843167749E+01, 3.9851350870E+00, 9.7542029661E-01],
	[4.2465000000E+04, 4.1718742541E+01, 5.4591296543E+00, 2.2851968083E+01, 3.9855034248E+00, 9.7543098597E-01],
	[4.2470000000E+04, 4.1727373813E+01, 5.4591705597E+00, 2.2860770770E+01, 3.9858716678E+00, 9.7544167005E-01],
	[4.2475000000E+04, 4.1736005854E+01, 5.4592114606E+00, 2.2869575810E+01, 3.9862398159E+00, 9.7545234885E-01],
	[4.2480000000E+04, 4.1744638665E+01, 5.4592523570E+00, 2.2878383202E+01, 3.9866078691E+00, 9.7546302238E-01],
	[4.2485000000E+04, 4.1753272245E+01, 5.4592932490E+00, 2.2887192948E+01, 3.9869758275E+00, 9.7547369063E-01],
	[4.2490000000E+04, 4.1761906594E+01, 5.4593341364E+00, 2.2896005048E+01, 3.9873436911E+00, 9.7548435362E-01],
	[4.2495000000E+04, 4.1770541712E+01, 5.4593750193E+00, 2.2904819502E+01, 3.9877114598E+00, 9.7549501134E-01],
	[4.2500000000E+04, 4.1779183628E+01, 5.4594165780E+00, 2.2913636310E+01, 3.9880795518E+00, 9.7550566380E-01],
	[4.2505000000E+04, 4.1787838666E+01, 5.4594595257E+00, 2.2922455473E+01, 3.9884484054E+00, 9.7551631100E-01],
	[4.2510000000E+04, 4.1796494478E+01, 5.4595024686E+00, 2.2931276991E+01, 3.9888171645E+00, 9.7552695294E-01],
	[4.2515000000E+04, 4.1805151065E+01, 5.4595454069E+00, 2.2940100864E+01, 3.9891858291E+00, 9.7553758963E-01],
	[4.2520000000E+04, 4.1813808426E+01, 5.4595883404E+00, 2.2948927093E+01, 3.9895543993E+00, 9.7554822106E-01],
	[4.2525000000E+04, 4.1822466562E+01, 5.4596312693E+00, 2.2957755679E+01, 3.9899228751E+00, 9.7555884725E-01],
	[4.2530000000E+04, 4.1831125473E+01, 5.4596741934E+00, 2.2966586620E+01, 3.9902912565E+00, 9.7556946818E-01],
	[4.2535000000E+04, 4.1839785158E+01, 5.4597171128E+00, 2.2975419919E+01, 3.9906595436E+00, 9.7558008388E-01],
	[4.2540000000E+04, 4.1848445617E+01, 5.4597600275E+00, 2.2984255575E+01, 3.9910277363E+00, 9.7559069434E-01],
	[4.2545000000E+04, 4.1857106851E+01, 5.4598029375E+00, 2.2993093589E+01, 3.9913958346E+00, 9.7560129956E-01],
	[4.2550000000E+04, 4.1865768860E+01, 5.4598458428E+00, 2.3001933960E+01, 3.9917638387E+00, 9.7561189954E-01],
	[4.2555000000E+04, 4.1874431642E+01, 5.4598887434E+00, 2.3010776690E+01, 3.9921317486E+00, 9.7562249429E-01],
	[4.2560000000E+04, 4.1883095200E+01, 5.4599316393E+00, 2.3019621778E+01, 3.9924995641E+00, 9.7563308382E-01],
	[4.2565000000E+04, 4.1891759531E+01, 5.4599745305E+00, 2.3028469225E+01, 3.9928672855E+00, 9.7564366812E-01],
	[4.2570000000E+04, 4.1900424637E+01, 5.4600174170E+00, 2.3037319032E+01, 3.9932349127E+00, 9.7565424719E-01],
	[4.2575000000E+04, 4.1909090517E+01, 5.4600602988E+00, 2.3046171198E+01, 3.9936024457E+00, 9.7566482105E-01],
	[4.2580000000E+04, 4.1917757172E+01, 5.4601031759E+00, 2.3055025724E+01, 3.9939698845E+00, 9.7567538969E-01],
	[4.2585000000E+04, 4.1926424601E+01, 5.4601460483E+00, 2.3063882611E+01, 3.9943372292E+00, 9.7568595311E-01],
	[4.2590000000E+04, 4.1935092804E+01, 5.4601889160E+00, 2.3072741858E+01, 3.9947044799E+00, 9.7569651132E-01],
	[4.2595000000E+04, 4.1943761781E+01, 5.4602317790E+00, 2.3081603467E+01, 3.9950716364E+00, 9.7570706433E-01],
	[4.2600000000E+04, 4.1952431533E+01, 5.4602746373E+00, 2.3090467436E+01, 3.9954386989E+00, 9.7571761213E-01],
	[4.2605000000E+04, 4.1961102059E+01, 5.4603174909E+00, 2.3099333768E+01, 3.9958056674E+00, 9.7572815472E-01],
	[4.2610000000E+04, 4.1969773359E+01, 5.4603603398E+00, 2.3108202462E+01, 3.9961725418E+00, 9.7573869212E-01],
	[4.2615000000E+04, 4.1978445433E+01, 5.4604031840E+00, 2.3117073518E+01, 3.9965393223E+00, 9.7574922431E-01],
	[4.2620000000E+04, 4.1987118281E+01, 5.4604460236E+00, 2.3125946937E+01, 3.9969060088E+00, 9.7575975132E-01],
	[4.2625000000E+04, 4.1995791904E+01, 5.4604888584E+00, 2.3134822719E+01, 3.9972726014E+00, 9.7577027313E-01],
	[4.2630000000E+04, 4.2004466300E+01, 5.4605316886E+00, 2.3143700865E+01, 3.9976391001E+00, 9.7578078975E-01],
	[4.2635000000E+04, 4.2013141471E+01, 5.4605745140E+00, 2.3152581375E+01, 3.9980055049E+00, 9.7579130119E-01],
	[4.2640000000E+04, 4.2021817415E+01, 5.4606173348E+00, 2.3161464249E+01, 3.9983718158E+00, 9.7580180745E-01],
	[4.2645000000E+04, 4.2030494134E+01, 5.4606601509E+00, 2.3170349487E+01, 3.9987380329E+00, 9.7581230852E-01],
	[4.2650000000E+04, 4.2039171626E+01, 5.4607029623E+00, 2.3179237091E+01, 3.9991041562E+00, 9.7582280442E-01],
	[4.2655000000E+04, 4.2047849893E+01, 5.4607457691E+00, 2.3188127059E+01, 3.9994701857E+00, 9.7583329514E-01],
	[4.2660000000E+04, 4.2056528934E+01, 5.4607885711E+00, 2.3197019394E+01, 3.9998361215E+00, 9.7584378069E-01],
	[4.2665000000E+04, 4.2065208748E+01, 5.4608313685E+00, 2.3205914094E+01, 4.0002019635E+00, 9.7585426108E-01],
	[4.2670000000E+04, 4.2073889336E+01, 5.4608741612E+00, 2.3214811161E+01, 4.0005677117E+00, 9.7586473630E-01],
	[4.2675000000E+04, 4.2082570699E+01, 5.4609169492E+00, 2.3223710594E+01, 4.0009333663E+00, 9.7587520635E-01],
	[4.2680000000E+04, 4.2091252835E+01, 5.4609597325E+00, 2.3232612395E+01, 4.0012989272E+00, 9.7588567124E-01],
	[4.2685000000E+04, 4.2099935745E+01, 5.4610025112E+00, 2.3241516563E+01, 4.0016643945E+00, 9.7589613098E-01],
	[4.2690000000E+04, 4.2108619429E+01, 5.4610452852E+00, 2.3250423098E+01, 4.0020297681E+00, 9.7590658556E-01],
	[4.2695000000E+04, 4.2117303887E+01, 5.4610880545E+00, 2.3259332002E+01, 4.0023950482E+00, 9.7591703500E-01],
	[4.2700000000E+04, 4.2125989118E+01, 5.4611308191E+00, 2.3268243274E+01, 4.0027602346E+00, 9.7592747928E-01],
	[4.2705000000E+04, 4.2134675123E+01, 5.4611735791E+00, 2.3277156915E+01, 4.0031253276E+00, 9.7593791841E-01],
	[4.2710000000E+04, 4.2143361902E+01, 5.4612163344E+00, 2.3286072925E+01, 4.0034903270E+00, 9.7594835241E-01],
	[4.2715000000E+04, 4.2152049455E+01, 5.4612590850E+00, 2.3294991305E+01, 4.0038552329E+00, 9.7595878126E-01],
	[4.2720000000E+04, 4.2160737782E+01, 5.4613018309E+00, 2.3303912054E+01, 4.0042200453E+00, 9.7596920498E-01],
	[4.2725000000E+04, 4.2169426882E+01, 5.4613445722E+00, 2.3312835174E+01, 4.0045847642E+00, 9.7597962356E-01],
	[4.2730000000E+04, 4.2178116755E+01, 5.4613873088E+00, 2.3321760665E+01, 4.0049493898E+00, 9.7599003701E-01],
	[4.2735000000E+04, 4.2186807403E+01, 5.4614300408E+00, 2.3330688526E+01, 4.0053139219E+00, 9.7600044533E-01],
	[4.2740000000E+04, 4.2195498824E+01, 5.4614727680E+00, 2.3339618758E+01, 4.0056783606E+00, 9.7601084852E-01],
	[4.2745000000E+04, 4.2204191018E+01, 5.4615154907E+00, 2.3348551362E+01, 4.0060427060E+00, 9.7602124660E-01],
	[4.2750000000E+04, 4.2212883987E+01, 5.4615582086E+00, 2.3357486339E+01, 4.0064069580E+00, 9.7603163955E-01],
	[4.2755000000E+04, 4.2221577728E+01, 5.4616009219E+00, 2.3366423687E+01, 4.0067711168E+00, 9.7604202738E-01],
	[4.2760000000E+04, 4.2230272244E+01, 5.4616436305E+00, 2.3375363408E+01, 4.0071351822E+00, 9.7605241010E-01],
	[4.2765000000E+04, 4.2238967532E+01, 5.4616863345E+00, 2.3384305502E+01, 4.0074991544E+00, 9.7606278771E-01],
	[4.2770000000E+04, 4.2247663594E+01, 5.4617290338E+00, 2.3393249970E+01, 4.0078630333E+00, 9.7607316021E-01],
	[4.2775000000E+04, 4.2256360430E+01, 5.4617717285E+00, 2.3402196811E+01, 4.0082268191E+00, 9.7608352760E-01],
	[4.2780000000E+04, 4.2265058039E+01, 5.4618144185E+00, 2.3411146026E+01, 4.0085905116E+00, 9.7609388989E-01],
	[4.2785000000E+04, 4.2273756422E+01, 5.4618571038E+00, 2.3420097616E+01, 4.0089541110E+00, 9.7610424707E-01],
	[4.2790000000E+04, 4.2282455578E+01, 5.4618997845E+00, 2.3429051581E+01, 4.0093176172E+00, 9.7611459916E-01],
	[4.2795000000E+04, 4.2291155507E+01, 5.4619424606E+00, 2.3438007920E+01, 4.0096810303E+00, 9.7612494616E-01],
	[4.2800000000E+04, 4.2299856210E+01, 5.4619851319E+00, 2.3446966636E+01, 4.0100443503E+00, 9.7613528806E-01],
	[4.2805000000E+04, 4.2308557686E+01, 5.4620277987E+00, 2.3455927727E+01, 4.0104075772E+00, 9.7614562487E-01],
	[4.2810000000E+04, 4.2317259935E+01, 5.4620704608E+00, 2.3464891194E+01, 4.0107707111E+00, 9.7615595660E-01],
	[4.2815000000E+04, 4.2325962958E+01, 5.4621131182E+00, 2.3473857038E+01, 4.0111337520E+00, 9.7616628325E-01],
	[4.2820000000E+04, 4.2334666754E+01, 5.4621557710E+00, 2.3482825258E+01, 4.0114966999E+00, 9.7617660481E-01],
	[4.2825000000E+04, 4.2343371323E+01, 5.4621984191E+00, 2.3491795856E+01, 4.0118595547E+00, 9.7618692129E-01],
	[4.2830000000E+04, 4.2352076665E+01, 5.4622410626E+00, 2.3500768832E+01, 4.0122223167E+00, 9.7619723270E-01],
	[4.2835000000E+04, 4.2360782781E+01, 5.4622837015E+00, 2.3509744185E+01, 4.0125849857E+00, 9.7620753904E-01],
	[4.2840000000E+04, 4.2369489670E+01, 5.4623263357E+00, 2.3518721917E+01, 4.0129475618E+00, 9.7621784031E-01],
	[4.2845000000E+04, 4.2378197332E+01, 5.4623689652E+00, 2.3527702028E+01, 4.0133100450E+00, 9.7622813651E-01],
	[4.2850000000E+04, 4.2386905767E+01, 5.4624115901E+00, 2.3536684517E+01, 4.0136724353E+00, 9.7623842764E-01],
	[4.2855000000E+04, 4.2395614975E+01, 5.4624542104E+00, 2.3545669386E+01, 4.0140347329E+00, 9.7624871372E-01],
	[4.2860000000E+04, 4.2404324956E+01, 5.4624968260E+00, 2.3554656635E+01, 4.0143969376E+00, 9.7625899473E-01],
	[4.2865000000E+04, 4.2413035710E+01, 5.4625394370E+00, 2.3563646263E+01, 4.0147590495E+00, 9.7626927069E-01],
	[4.2870000000E+04, 4.2421747238E+01, 5.4625820434E+00, 2.3572638272E+01, 4.0151210687E+00, 9.7627954160E-01],
	[4.2875000000E+04, 4.2430459538E+01, 5.4626246451E+00, 2.3581632662E+01, 4.0154829951E+00, 9.7628980745E-01],
	[4.2880000000E+04, 4.2439172612E+01, 5.4626672422E+00, 2.3590629433E+01, 4.0158448288E+00, 9.7630006825E-01],
	[4.2885000000E+04, 4.2447886458E+01, 5.4627098347E+00, 2.3599628586E+01, 4.0162065698E+00, 9.7631032401E-01],
	[4.2890000000E+04, 4.2456601078E+01, 5.4627524225E+00, 2.3608630120E+01, 4.0165682182E+00, 9.7632057472E-01],
	[4.2895000000E+04, 4.2465316470E+01, 5.4627950057E+00, 2.3617634036E+01, 4.0169297739E+00, 9.7633082040E-01],
	[4.2900000000E+04, 4.2474032635E+01, 5.4628375842E+00, 2.3626640335E+01, 4.0172912370E+00, 9.7634106103E-01],
	[4.2905000000E+04, 4.2482749573E+01, 5.4628801582E+00, 2.3635649017E+01, 4.0176526075E+00, 9.7635129663E-01],
	[4.2910000000E+04, 4.2491467284E+01, 5.4629227275E+00, 2.3644660082E+01, 4.0180138854E+00, 9.7636152719E-01],
	[4.2915000000E+04, 4.2500185768E+01, 5.4629652921E+00, 2.3653673531E+01, 4.0183750708E+00, 9.7637175272E-01],
	[4.2920000000E+04, 4.2508905025E+01, 5.4630078522E+00, 2.3662689364E+01, 4.0187361637E+00, 9.7638197323E-01],
	[4.2925000000E+04, 4.2517625055E+01, 5.4630504076E+00, 2.3671707580E+01, 4.0190971640E+00, 9.7639218871E-01],
	[4.2930000000E+04, 4.2526345857E+01, 5.4630929584E+00, 2.3680728182E+01, 4.0194580719E+00, 9.7640239916E-01],
	[4.2935000000E+04, 4.2535067432E+01, 5.4631355045E+00, 2.3689751169E+01, 4.0198188873E+00, 9.7641260459E-01],
	[4.2940000000E+04, 4.2543789780E+01, 5.4631780461E+00, 2.3698776541E+01, 4.0201796103E+00, 9.7642280501E-01],
	[4.2945000000E+04, 4.2552512901E+01, 5.4632205830E+00, 2.3707804298E+01, 4.0205402409E+00, 9.7643300041E-01],
	[4.2950000000E+04, 4.2561236794E+01, 5.4632631153E+00, 2.3716834442E+01, 4.0209007791E+00, 9.7644319080E-01],
	[4.2955000000E+04, 4.2569961460E+01, 5.4633056430E+00, 2.3725866972E+01, 4.0212612250E+00, 9.7645337618E-01],
	[4.2960000000E+04, 4.2578686898E+01, 5.4633481660E+00, 2.3734901889E+01, 4.0216215785E+00, 9.7646355655E-01],
	[4.2965000000E+04, 4.2587413110E+01, 5.4633906845E+00, 2.3743939193E+01, 4.0219818397E+00, 9.7647373191E-01],
	[4.2970000000E+04, 4.2596140094E+01, 5.4634331983E+00, 2.3752978884E+01, 4.0223420087E+00, 9.7648390227E-01],
	[4.2975000000E+04, 4.2604867850E+01, 5.4634757075E+00, 2.3762020963E+01, 4.0227020854E+00, 9.7649406763E-01],
	[4.2980000000E+04, 4.2613596379E+01, 5.4635182121E+00, 2.3771065431E+01, 4.0230620698E+00, 9.7650422800E-01],
	[4.2985000000E+04, 4.2622325681E+01, 5.4635607121E+00, 2.3780112287E+01, 4.0234219620E+00, 9.7651438336E-01],
	[4.2990000000E+04, 4.2631055755E+01, 5.4636032074E+00, 2.3789161532E+01, 4.0237817620E+00, 9.7652453374E-01],
	[4.2995000000E+04, 4.2639786602E+01, 5.4636456982E+00, 2.3798213166E+01, 4.0241414699E+00, 9.7653467912E-01],
	[4.3000000000E+04, 4.2648518221E+01, 5.4636881843E+00, 2.3807267189E+01, 4.0245010856E+00, 9.7654481952E-01],
	[4.3005000000E+04, 4.2657250613E+01, 5.4637306659E+00, 2.3816323603E+01, 4.0248606092E+00, 9.7655495494E-01],
	[4.3010000000E+04, 4.2665983777E+01, 5.4637731428E+00, 2.3825382406E+01, 4.0252200407E+00, 9.7656508537E-01],
	[4.3015000000E+04, 4.2674717714E+01, 5.4638156151E+00, 2.3834443601E+01, 4.0255793802E+00, 9.7657521082E-01],
	[4.3020000000E+04, 4.2683452423E+01, 5.4638580828E+00, 2.3843507186E+01, 4.0259386276E+00, 9.7658533129E-01],
	[4.3025000000E+04, 4.2692187904E+01, 5.4639005459E+00, 2.3852573163E+01, 4.0262977829E+00, 9.7659544679E-01],
	[4.3030000000E+04, 4.2700924158E+01, 5.4639430044E+00, 2.3861641532E+01, 4.0266568463E+00, 9.7660555732E-01],
	[4.3035000000E+04, 4.2709661184E+01, 5.4639854583E+00, 2.3870712292E+01, 4.0270158177E+00, 9.7661566288E-01],
	[4.3040000000E+04, 4.2718398982E+01, 5.4640279076E+00, 2.3879785445E+01, 4.0273746971E+00, 9.7662576347E-01],
	[4.3045000000E+04, 4.2727137553E+01, 5.4640703523E+00, 2.3888860991E+01, 4.0277334846E+00, 9.7663585910E-01],
	[4.3050000000E+04, 4.2735876896E+01, 5.4641127924E+00, 2.3897938929E+01, 4.0280921802E+00, 9.7664594976E-01],
	[4.3055000000E+04, 4.2744617011E+01, 5.4641552279E+00, 2.3907019262E+01, 4.0284507840E+00, 9.7665603547E-01],
	[4.3060000000E+04, 4.2753357898E+01, 5.4641976588E+00, 2.3916101988E+01, 4.0288092958E+00, 9.7666611622E-01],
	[4.3065000000E+04, 4.2762099558E+01, 5.4642400851E+00, 2.3925187108E+01, 4.0291677159E+00, 9.7667619201E-01],
	[4.3070000000E+04, 4.2770841990E+01, 5.4642825068E+00, 2.3934274623E+01, 4.0295260441E+00, 9.7668626286E-01],
	[4.3075000000E+04, 4.2779585194E+01, 5.4643249239E+00, 2.3943364532E+01, 4.0298842806E+00, 9.7669632875E-01],
	[4.3080000000E+04, 4.2788329170E+01, 5.4643673365E+00, 2.3952456837E+01, 4.0302424252E+00, 9.7670638970E-01],
	[4.3085000000E+04, 4.2797073918E+01, 5.4644097444E+00, 2.3961551537E+01, 4.0306004782E+00, 9.7671644570E-01],
	[4.3090000000E+04, 4.2805819439E+01, 5.4644521477E+00, 2.3970648633E+01, 4.0309584394E+00, 9.7672649677E-01],
	[4.3095000000E+04, 4.2814565731E+01, 5.4644945464E+00, 2.3979748126E+01, 4.0313163090E+00, 9.7673654289E-01],
	[4.3100000000E+04, 4.2823312796E+01, 5.4645369406E+00, 2.3988850015E+01, 4.0316740868E+00, 9.7674658408E-01],
	[4.3105000000E+04, 4.2832060633E+01, 5.4645793302E+00, 2.3997954301E+01, 4.0320317731E+00, 9.7675662033E-01],
	[4.3110000000E+04, 4.2840809241E+01, 5.4646217151E+00, 2.4007060985E+01, 4.0323893677E+00, 9.7676665165E-01],
	[4.3115000000E+04, 4.2849558622E+01, 5.4646640955E+00, 2.4016170066E+01, 4.0327468707E+00, 9.7677667805E-01],
	[4.3120000000E+04, 4.2858308774E+01, 5.4647064713E+00, 2.4025281545E+01, 4.0331042822E+00, 9.7678669952E-01],
	[4.3125000000E+04, 4.2867059699E+01, 5.4647488425E+00, 2.4034395423E+01, 4.0334616021E+00, 9.7679671606E-01],
	[4.3130000000E+04, 4.2875811395E+01, 5.4647912092E+00, 2.4043511699E+01, 4.0338188305E+00, 9.7680672768E-01],
	[4.3135000000E+04, 4.2884563864E+01, 5.4648335712E+00, 2.4052630374E+01, 4.0341759673E+00, 9.7681673439E-01],
	[4.3140000000E+04, 4.2893317104E+01, 5.4648759287E+00, 2.4061751449E+01, 4.0345330127E+00, 9.7682673618E-01],
	[4.3145000000E+04, 4.2902071116E+01, 5.4649182815E+00, 2.4070874924E+01, 4.0348899667E+00, 9.7683673305E-01],
	[4.3150000000E+04, 4.2910825900E+01, 5.4649606299E+00, 2.4080000799E+01, 4.0352468292E+00, 9.7684672502E-01],
	[4.3155000000E+04, 4.2919581456E+01, 5.4650029736E+00, 2.4089129074E+01, 4.0356036003E+00, 9.7685671208E-01],
	[4.3160000000E+04, 4.2928337784E+01, 5.4650453127E+00, 2.4098259750E+01, 4.0359602801E+00, 9.7686669423E-01],
	[4.3165000000E+04, 4.2937094883E+01, 5.4650876473E+00, 2.4107392828E+01, 4.0363168685E+00, 9.7687667148E-01],
	[4.3170000000E+04, 4.2945852755E+01, 5.4651299773E+00, 2.4116528307E+01, 4.0366733655E+00, 9.7688664382E-01],
	[4.3175000000E+04, 4.2954611397E+01, 5.4651723027E+00, 2.4125666187E+01, 4.0370297712E+00, 9.7689661127E-01],
	[4.3180000000E+04, 4.2963370812E+01, 5.4652146236E+00, 2.4134806471E+01, 4.0373860857E+00, 9.7690657383E-01],
	[4.3185000000E+04, 4.2972140043E+01, 5.4652579433E+00, 2.4143949156E+01, 4.0377429364E+00, 9.7691653149E-01],
	[4.3190000000E+04, 4.2980919280E+01, 5.4653022824E+00, 2.4153094245E+01, 4.0381003366E+00, 9.7692648426E-01],
	[4.3195000000E+04, 4.2989699295E+01, 5.4653466167E+00, 2.4162241737E+01, 4.0384576458E+00, 9.7693643214E-01],
	[4.3200000000E+04, 4.2998480086E+01, 5.4653909463E+00, 2.4171391633E+01, 4.0388148640E+00, 9.7694637514E-01],
	[4.3205000000E+04, 4.3007261654E+01, 5.4654352711E+00, 2.4180543933E+01, 4.0391719912E+00, 9.7695631325E-01],
	[4.3210000000E+04, 4.3016044000E+01, 5.4654795911E+00, 2.4189698637E+01, 4.0395290276E+00, 9.7696624648E-01],
	[4.3215000000E+04, 4.3024827122E+01, 5.4655239064E+00, 2.4198855746E+01, 4.0398859730E+00, 9.7697617484E-01],
	[4.3220000000E+04, 4.3033611021E+01, 5.4655682169E+00, 2.4208015260E+01, 4.0402428275E+00, 9.7698609832E-01],
	[4.3225000000E+04, 4.3042395697E+01, 5.4656125226E+00, 2.4217177179E+01, 4.0405995912E+00, 9.7699601693E-01],
	[4.3230000000E+04, 4.3051181150E+01, 5.4656568236E+00, 2.4226341504E+01, 4.0409562641E+00, 9.7700593067E-01],
	[4.3235000000E+04, 4.3059967379E+01, 5.4657011198E+00, 2.4235508236E+01, 4.0413128461E+00, 9.7701583954E-01],
	[4.3240000000E+04, 4.3068754386E+01, 5.4657454112E+00, 2.4244677374E+01, 4.0416693374E+00, 9.7702574355E-01],
	[4.3245000000E+04, 4.3077542169E+01, 5.4657896979E+00, 2.4253848918E+01, 4.0420257379E+00, 9.7703564269E-01],
	[4.3250000000E+04, 4.3086330729E+01, 5.4658339798E+00, 2.4263022870E+01, 4.0423820477E+00, 9.7704553697E-01],
	[4.3255000000E+04, 4.3095120066E+01, 5.4658782570E+00, 2.4272199230E+01, 4.0427382667E+00, 9.7705542640E-01],
	[4.3260000000E+04, 4.3103910179E+01, 5.4659225294E+00, 2.4281377997E+01, 4.0430943951E+00, 9.7706531097E-01],
	[4.3265000000E+04, 4.3112701069E+01, 5.4659667970E+00, 2.4290559173E+01, 4.0434504328E+00, 9.7707519069E-01],
	[4.3270000000E+04, 4.3121492736E+01, 5.4660110599E+00, 2.4299742757E+01, 4.0438063799E+00, 9.7708506556E-01],
	[4.3275000000E+04, 4.3130285180E+01, 5.4660553180E+00, 2.4308928750E+01, 4.0441622363E+00, 9.7709493558E-01],
	[4.3280000000E+04, 4.3139078400E+01, 5.4660995714E+00, 2.4318117153E+01, 4.0445180021E+00, 9.7710480075E-01],
	[4.3285000000E+04, 4.3147872397E+01, 5.4661438200E+00, 2.4327307965E+01, 4.0448736774E+00, 9.7711466109E-01],
	[4.3290000000E+04, 4.3156667170E+01, 5.4661880638E+00, 2.4336501188E+01, 4.0452292621E+00, 9.7712451658E-01],
	[4.3295000000E+04, 4.3165462720E+01, 5.4662323029E+00, 2.4345696820E+01, 4.0455847563E+00, 9.7713436724E-01],
	[4.3300000000E+04, 4.3174259046E+01, 5.4662765373E+00, 2.4354894864E+01, 4.0459401600E+00, 9.7714421306E-01],
	[4.3305000000E+04, 4.3183056149E+01, 5.4663207669E+00, 2.4364095318E+01, 4.0462954733E+00, 9.7715405405E-01],
	[4.3310000000E+04, 4.3191854029E+01, 5.4663649918E+00, 2.4373298184E+01, 4.0466506960E+00, 9.7716389022E-01],
	[4.3315000000E+04, 4.3200652685E+01, 5.4664092119E+00, 2.4382503462E+01, 4.0470058284E+00, 9.7717372155E-01],
	[4.3320000000E+04, 4.3209452118E+01, 5.4664534272E+00, 2.4391711152E+01, 4.0473608703E+00, 9.7718354806E-01],
	[4.3325000000E+04, 4.3218252327E+01, 5.4664976379E+00, 2.4400921254E+01, 4.0477158218E+00, 9.7719336975E-01],
	[4.3330000000E+04, 4.3227053312E+01, 5.4665418437E+00, 2.4410133769E+01, 4.0480706830E+00, 9.7720318661E-01],
	[4.3335000000E+04, 4.3235855074E+01, 5.4665860449E+00, 2.4419348698E+01, 4.0484254539E+00, 9.7721299866E-01],
	[4.3340000000E+04, 4.3244657612E+01, 5.4666302413E+00, 2.4428566040E+01, 4.0487801344E+00, 9.7722280590E-01],
	[4.3345000000E+04, 4.3253460927E+01, 5.4666744329E+00, 2.4437785796E+01, 4.0491347247E+00, 9.7723260833E-01],
	[4.3350000000E+04, 4.3262265017E+01, 5.4667186198E+00, 2.4447007966E+01, 4.0494892246E+00, 9.7724240594E-01],
	[4.3355000000E+04, 4.3271069885E+01, 5.4667628020E+00, 2.4456232551E+01, 4.0498436344E+00, 9.7725219875E-01],
	[4.3360000000E+04, 4.3279875528E+01, 5.4668069794E+00, 2.4465459551E+01, 4.0501979539E+00, 9.7726198675E-01],
	[4.3365000000E+04, 4.3288681948E+01, 5.4668511521E+00, 2.4474688966E+01, 4.0505521832E+00, 9.7727176996E-01],
	[4.3370000000E+04, 4.3297489144E+01, 5.4668953201E+00, 2.4483920797E+01, 4.0509063224E+00, 9.7728154836E-01],
	[4.3375000000E+04, 4.3306297116E+01, 5.4669394833E+00, 2.4493155043E+01, 4.0512603714E+00, 9.7729132196E-01],
	[4.3380000000E+04, 4.3315105865E+01, 5.4669836418E+00, 2.4502391707E+01, 4.0516143303E+00, 9.7730109078E-01],
	[4.3385000000E+04, 4.3323915390E+01, 5.4670277955E+00, 2.4511630787E+01, 4.0519681991E+00, 9.7731085480E-01],
	[4.3390000000E+04, 4.3332725691E+01, 5.4670719446E+00, 2.4520872284E+01, 4.0523219778E+00, 9.7732061403E-01],
	[4.3395000000E+04, 4.3341536768E+01, 5.4671160888E+00, 2.4530116198E+01, 4.0526756664E+00, 9.7733036847E-01],
	[4.3400000000E+04, 4.3350348621E+01, 5.4671602284E+00, 2.4539362530E+01, 4.0530292651E+00, 9.7734011813E-01],
	[4.3405000000E+04, 4.3359161250E+01, 5.4672043632E+00, 2.4548611281E+01, 4.0533827737E+00, 9.7734986301E-01],
	[4.3410000000E+04, 4.3367974656E+01, 5.4672484934E+00, 2.4557862450E+01, 4.0537361923E+00, 9.7735960311E-01],
	[4.3415000000E+04, 4.3376788837E+01, 5.4672926187E+00, 2.4567116038E+01, 4.0540895210E+00, 9.7736933843E-01],
	[4.3420000000E+04, 4.3385603795E+01, 5.4673367394E+00, 2.4576372045E+01, 4.0544427597E+00, 9.7737906898E-01],
	[4.3425000000E+04, 4.3394419528E+01, 5.4673808553E+00, 2.4585630471E+01, 4.0547959086E+00, 9.7738879475E-01],
	[4.3430000000E+04, 4.3403236038E+01, 5.4674249665E+00, 2.4594891318E+01, 4.0551489675E+00, 9.7739851576E-01],
	[4.3435000000E+04, 4.3412053323E+01, 5.4674690730E+00, 2.4604154585E+01, 4.0555019366E+00, 9.7740823200E-01],
	[4.3440000000E+04, 4.3420871385E+01, 5.4675131748E+00, 2.4613420272E+01, 4.0558548158E+00, 9.7741794348E-01],
	[4.3445000000E+04, 4.3429690222E+01, 5.4675572718E+00, 2.4622688380E+01, 4.0562076052E+00, 9.7742765019E-01],
	[4.3450000000E+04, 4.3438509836E+01, 5.4676013641E+00, 2.4631958910E+01, 4.0565603048E+00, 9.7743735215E-01],
	[4.3455000000E+04, 4.3447330225E+01, 5.4676454518E+00, 2.4641231861E+01, 4.0569129147E+00, 9.7744704935E-01],
	[4.3460000000E+04, 4.3456151390E+01, 5.4676895346E+00, 2.4650507235E+01, 4.0572654348E+00, 9.7745674179E-01],
	[4.3465000000E+04, 4.3464973331E+01, 5.4677336128E+00, 2.4659785031E+01, 4.0576178652E+00, 9.7746642949E-01],
	[4.3470000000E+04, 4.3473796048E+01, 5.4677776863E+00, 2.4669065249E+01, 4.0579702058E+00, 9.7747611243E-01],
	[4.3475000000E+04, 4.3482619541E+01, 5.4678217550E+00, 2.4678347891E+01, 4.0583224568E+00, 9.7748579063E-01],
	[4.3480000000E+04, 4.3491443810E+01, 5.4678658191E+00, 2.4687632956E+01, 4.0586746182E+00, 9.7749546409E-01],
	[4.3485000000E+04, 4.3500268854E+01, 5.4679098784E+00, 2.4696920445E+01, 4.0590266899E+00, 9.7750513280E-01],
	[4.3490000000E+04, 4.3509094674E+01, 5.4679539330E+00, 2.4706210358E+01, 4.0593786720E+00, 9.7751479677E-01],
	[4.3495000000E+04, 4.3517921270E+01, 5.4679979829E+00, 2.4715502696E+01, 4.0597305645E+00, 9.7752445601E-01],
	[4.3500000000E+04, 4.3526748641E+01, 5.4680420281E+00, 2.4724797458E+01, 4.0600823675E+00, 9.7753411051E-01],
	[4.3505000000E+04, 4.3535576788E+01, 5.4680860686E+00, 2.4734094646E+01, 4.0604340809E+00, 9.7754376028E-01],
	[4.3510000000E+04, 4.3544405711E+01, 5.4681301043E+00, 2.4743394259E+01, 4.0607857048E+00, 9.7755340533E-01],
	[4.3515000000E+04, 4.3553235410E+01, 5.4681741354E+00, 2.4752696298E+01, 4.0611372393E+00, 9.7756304564E-01],
	[4.3520000000E+04, 4.3562065884E+01, 5.4682181618E+00, 2.4762000764E+01, 4.0614886842E+00, 9.7757268124E-01],
	[4.3525000000E+04, 4.3570897134E+01, 5.4682621834E+00, 2.4771307656E+01, 4.0618400397E+00, 9.7758231211E-01],
	[4.3530000000E+04, 4.3579729159E+01, 5.4683062004E+00, 2.4780616975E+01, 4.0621913058E+00, 9.7759193826E-01],
	[4.3535000000E+04, 4.3588561960E+01, 5.4683502127E+00, 2.4789928721E+01, 4.0625424825E+00, 9.7760155969E-01],
	[4.3540000000E+04, 4.3597395536E+01, 5.4683942202E+00, 2.4799242895E+01, 4.0628935699E+00, 9.7761117641E-01],
	[4.3545000000E+04, 4.3606229888E+01, 5.4684382231E+00, 2.4808559497E+01, 4.0632445679E+00, 9.7762078842E-01],
	[4.3550000000E+04, 4.3615065016E+01, 5.4684822212E+00, 2.4817878528E+01, 4.0635954765E+00, 9.7763039572E-01],
	[4.3555000000E+04, 4.3623900919E+01, 5.4685262147E+00, 2.4827199987E+01, 4.0639462959E+00, 9.7763999832E-01],
	[4.3560000000E+04, 4.3632737597E+01, 5.4685702035E+00, 2.4836523875E+01, 4.0642970260E+00, 9.7764959621E-01],
	[4.3565000000E+04, 4.3641575051E+01, 5.4686141875E+00, 2.4845850193E+01, 4.0646476668E+00, 9.7765918940E-01],
	[4.3570000000E+04, 4.3650413280E+01, 5.4686581669E+00, 2.4855178941E+01, 4.0649982184E+00, 9.7766877789E-01],
	[4.3575000000E+04, 4.3659252285E+01, 5.4687021416E+00, 2.4864510119E+01, 4.0653486808E+00, 9.7767836168E-01],
	[4.3580000000E+04, 4.3668092065E+01, 5.4687461116E+00, 2.4873843727E+01, 4.0656990540E+00, 9.7768794078E-01],
	[4.3585000000E+04, 4.3676932620E+01, 5.4687900769E+00, 2.4883179766E+01, 4.0660493380E+00, 9.7769751519E-01],
	[4.3590000000E+04, 4.3685773951E+01, 5.4688340375E+00, 2.4892518237E+01, 4.0663995329E+00, 9.7770708490E-01],
	[4.3595000000E+04, 4.3694616057E+01, 5.4688779934E+00, 2.4901859139E+01, 4.0667496387E+00, 9.7771664994E-01],
	[4.3600000000E+04, 4.3703458938E+01, 5.4689219447E+00, 2.4911202473E+01, 4.0670996554E+00, 9.7772621028E-01],
	[4.3605000000E+04, 4.3712302595E+01, 5.4689658912E+00, 2.4920548239E+01, 4.0674495831E+00, 9.7773576595E-01],
	[4.3610000000E+04, 4.3721147027E+01, 5.4690098331E+00, 2.4929896438E+01, 4.0677994217E+00, 9.7774531694E-01],
	[4.3615000000E+04, 4.3729992234E+01, 5.4690537703E+00, 2.4939247070E+01, 4.0681491712E+00, 9.7775486325E-01],
	[4.3620000000E+04, 4.3738838216E+01, 5.4690977028E+00, 2.4948600135E+01, 4.0684988318E+00, 9.7776440488E-01],
	[4.3625000000E+04, 4.3747684974E+01, 5.4691416306E+00, 2.4957955634E+01, 4.0688484034E+00, 9.7777394185E-01],
	[4.3630000000E+04, 4.3756532507E+01, 5.4691855537E+00, 2.4967313567E+01, 4.0691978861E+00, 9.7778347414E-01],
	[4.3635000000E+04, 4.3765380815E+01, 5.4692294722E+00, 2.4976673935E+01, 4.0695472798E+00, 9.7779300177E-01],
	[4.3640000000E+04, 4.3774229897E+01, 5.4692733859E+00, 2.4986036737E+01, 4.0698965846E+00, 9.7780252474E-01],
	[4.3645000000E+04, 4.3783079756E+01, 5.4693172950E+00, 2.4995401974E+01, 4.0702458006E+00, 9.7781204304E-01],
	[4.3650000000E+04, 4.3791930389E+01, 5.4693611994E+00, 2.5004769647E+01, 4.0705949277E+00, 9.7782155668E-01],
	[4.3655000000E+04, 4.3800781797E+01, 5.4694050992E+00, 2.5014139755E+01, 4.0709439659E+00, 9.7783106567E-01],
	[4.3660000000E+04, 4.3809633980E+01, 5.4694489942E+00, 2.5023512300E+01, 4.0712929154E+00, 9.7784057000E-01],
	[4.3665000000E+04, 4.3818486938E+01, 5.4694928846E+00, 2.5032887281E+01, 4.0716417760E+00, 9.7785006969E-01],
	[4.3670000000E+04, 4.3827340672E+01, 5.4695367703E+00, 2.5042264700E+01, 4.0719905480E+00, 9.7785956472E-01],
	[4.3675000000E+04, 4.3836195180E+01, 5.4695806514E+00, 2.5051644555E+01, 4.0723392311E+00, 9.7786905510E-01],
	[4.3680000000E+04, 4.3845050463E+01, 5.4696245277E+00, 2.5061026848E+01, 4.0726878256E+00, 9.7787854084E-01],
	[4.3685000000E+04, 4.3853906521E+01, 5.4696683994E+00, 2.5070411579E+01, 4.0730363313E+00, 9.7788802194E-01],
	[4.3690000000E+04, 4.3862763355E+01, 5.4697122665E+00, 2.5079798748E+01, 4.0733847484E+00, 9.7789749840E-01],
	[4.3695000000E+04, 4.3871620963E+01, 5.4697561288E+00, 2.5089188356E+01, 4.0737330769E+00, 9.7790697022E-01],
	[4.3700000000E+04, 4.3880479345E+01, 5.4697999865E+00, 2.5098580403E+01, 4.0740813167E+00, 9.7791643741E-01],
	[4.3705000000E+04, 4.3889338503E+01, 5.4698438396E+00, 2.5107974889E+01, 4.0744294679E+00, 9.7792589997E-01],
	[4.3710000000E+04, 4.3898198436E+01, 5.4698876879E+00, 2.5117371816E+01, 4.0747775306E+00, 9.7793535789E-01],
	[4.3715000000E+04, 4.3907059143E+01, 5.4699315316E+00, 2.5126771182E+01, 4.0751255047E+00, 9.7794481119E-01],
	[4.3720000000E+04, 4.3915920625E+01, 5.4699753707E+00, 2.5136172988E+01, 4.0754733902E+00, 9.7795425987E-01],
	[4.3725000000E+04, 4.3924782882E+01, 5.4700192050E+00, 2.5145577235E+01, 4.0758211873E+00, 9.7796370392E-01],
	[4.3730000000E+04, 4.3933645914E+01, 5.4700630348E+00, 2.5154983924E+01, 4.0761688959E+00, 9.7797314335E-01],
	[4.3735000000E+04, 4.3942509720E+01, 5.4701068598E+00, 2.5164393054E+01, 4.0765165160E+00, 9.7798257817E-01],
	[4.3740000000E+04, 4.3951374301E+01, 5.4701506802E+00, 2.5173804625E+01, 4.0768640477E+00, 9.7799200837E-01],
	[4.3745000000E+04, 4.3960239657E+01, 5.4701944959E+00, 2.5183218639E+01, 4.0772114910E+00, 9.7800143396E-01],
	[4.3750000000E+04, 4.3969105788E+01, 5.4702383070E+00, 2.5192635096E+01, 4.0775588459E+00, 9.7801085494E-01],
	[4.3755000000E+04, 4.3977972693E+01, 5.4702821135E+00, 2.5202053995E+01, 4.0779061124E+00, 9.7802027131E-01],
	[4.3760000000E+04, 4.3986840372E+01, 5.4703259152E+00, 2.5211475338E+01, 4.0782532906E+00, 9.7802968308E-01],
	[4.3765000000E+04, 4.3995708827E+01, 5.4703697123E+00, 2.5220899124E+01, 4.0786003805E+00, 9.7803909024E-01],
	[4.3770000000E+04, 4.4004578056E+01, 5.4704135048E+00, 2.5230325354E+01, 4.0789473821E+00, 9.7804849281E-01],
	[4.3775000000E+04, 4.4013448059E+01, 5.4704572926E+00, 2.5239754029E+01, 4.0792942954E+00, 9.7805789078E-01],
	[4.3780000000E+04, 4.4022318837E+01, 5.4705010758E+00, 2.5249185148E+01, 4.0796411205E+00, 9.7806728415E-01],
	[4.3785000000E+04, 4.4031190390E+01, 5.4705448543E+00, 2.5258618712E+01, 4.0799878573E+00, 9.7807667293E-01],
	[4.3790000000E+04, 4.4040062717E+01, 5.4705886281E+00, 2.5268054722E+01, 4.0803345059E+00, 9.7808605712E-01],
	[4.3795000000E+04, 4.4048935818E+01, 5.4706323974E+00, 2.5277493177E+01, 4.0806810664E+00, 9.7809543672E-01],
	[4.3800000000E+04, 4.4057809694E+01, 5.4706761619E+00, 2.5286934079E+01, 4.0810275387E+00, 9.7810481174E-01],
	[4.3805000000E+04, 4.4066684345E+01, 5.4707199219E+00, 2.5296377427E+01, 4.0813739229E+00, 9.7811418218E-01],
	[4.3810000000E+04, 4.4075559770E+01, 5.4707636771E+00, 2.5305823221E+01, 4.0817202190E+00, 9.7812354803E-01],
	[4.3815000000E+04, 4.4084435969E+01, 5.4708074278E+00, 2.5315271463E+01, 4.0820664269E+00, 9.7813290931E-01],
	[4.3820000000E+04, 4.4093312943E+01, 5.4708511738E+00, 2.5324722153E+01, 4.0824125469E+00, 9.7814226601E-01],
	[4.3825000000E+04, 4.4102190691E+01, 5.4708949151E+00, 2.5334175290E+01, 4.0827585788E+00, 9.7815161814E-01],
	[4.3830000000E+04, 4.4111069213E+01, 5.4709386518E+00, 2.5343630875E+01, 4.0831045226E+00, 9.7816096570E-01],
	[4.3835000000E+04, 4.4119948510E+01, 5.4709823839E+00, 2.5353088909E+01, 4.0834503785E+00, 9.7817030869E-01],
	[4.3840000000E+04, 4.4128828581E+01, 5.4710261113E+00, 2.5362549392E+01, 4.0837961465E+00, 9.7817964712E-01],
	[4.3845000000E+04, 4.4137709426E+01, 5.4710698341E+00, 2.5372012324E+01, 4.0841418264E+00, 9.7818898098E-01],
	[4.3850000000E+04, 4.4146591045E+01, 5.4711135523E+00, 2.5381477706E+01, 4.0844874185E+00, 9.7819831028E-01],
	[4.3855000000E+04, 4.4155473439E+01, 5.4711572658E+00, 2.5390945538E+01, 4.0848329227E+00, 9.7820763503E-01],
	[4.3860000000E+04, 4.4164356607E+01, 5.4712009747E+00, 2.5400415820E+01, 4.0851783389E+00, 9.7821695521E-01],
	[4.3865000000E+04, 4.4173240549E+01, 5.4712446789E+00, 2.5409888553E+01, 4.0855236674E+00, 9.7822627085E-01],
	[4.3870000000E+04, 4.4182125265E+01, 5.4712883786E+00, 2.5419363737E+01, 4.0858689080E+00, 9.7823558193E-01],
	[4.3875000000E+04, 4.4191010756E+01, 5.4713320736E+00, 2.5428841372E+01, 4.0862140608E+00, 9.7824488847E-01],
	[4.3880000000E+04, 4.4199905358E+01, 5.4713766736E+00, 2.5438321459E+01, 4.0865597046E+00, 9.7825419046E-01],
	[4.3885000000E+04, 4.4208810569E+01, 5.4714223414E+00, 2.5447803998E+01, 4.0869059431E+00, 9.7826348791E-01],
	[4.3890000000E+04, 4.4217716559E+01, 5.4714680044E+00, 2.5457288990E+01, 4.0872520941E+00, 9.7827278081E-01],
	[4.3895000000E+04, 4.4226623329E+01, 5.4715136626E+00, 2.5466776434E+01, 4.0875981576E+00, 9.7828206918E-01],
	[4.3900000000E+04, 4.4235530878E+01, 5.4715593160E+00, 2.5476266332E+01, 4.0879441336E+00, 9.7829135301E-01],
	[4.3905000000E+04, 4.4244439207E+01, 5.4716049645E+00, 2.5485758683E+01, 4.0882900221E+00, 9.7830063231E-01],
	[4.3910000000E+04, 4.4253348314E+01, 5.4716506082E+00, 2.5495253488E+01, 4.0886358232E+00, 9.7830990708E-01],
	[4.3915000000E+04, 4.4262258201E+01, 5.4716962472E+00, 2.5504750747E+01, 4.0889815369E+00, 9.7831917732E-01],
	[4.3920000000E+04, 4.4271168867E+01, 5.4717418813E+00, 2.5514250461E+01, 4.0893271632E+00, 9.7832844303E-01],
	[4.3925000000E+04, 4.4280080312E+01, 5.4717875105E+00, 2.5523752629E+01, 4.0896727022E+00, 9.7833770422E-01],
	[4.3930000000E+04, 4.4288992536E+01, 5.4718331350E+00, 2.5533257253E+01, 4.0900181537E+00, 9.7834696088E-01],
	[4.3935000000E+04, 4.4297905540E+01, 5.4718787547E+00, 2.5542764333E+01, 4.0903635180E+00, 9.7835621303E-01],
	[4.3940000000E+04, 4.4306819322E+01, 5.4719243695E+00, 2.5552273869E+01, 4.0907087950E+00, 9.7836546066E-01],
	[4.3945000000E+04, 4.4315733884E+01, 5.4719699795E+00, 2.5561785861E+01, 4.0910539846E+00, 9.7837470378E-01],
	[4.3950000000E+04, 4.4324649225E+01, 5.4720155848E+00, 2.5571300310E+01, 4.0913990871E+00, 9.7838394238E-01],
	[4.3955000000E+04, 4.4333565345E+01, 5.4720611852E+00, 2.5580817216E+01, 4.0917441023E+00, 9.7839317648E-01],
	[4.3960000000E+04, 4.4342482243E+01, 5.4721067808E+00, 2.5590336579E+01, 4.0920890303E+00, 9.7840240607E-01],
	[4.3965000000E+04, 4.4351399921E+01, 5.4721523716E+00, 2.5599858400E+01, 4.0924338711E+00, 9.7841163115E-01],
	[4.3970000000E+04, 4.4360318378E+01, 5.4721979576E+00, 2.5609382679E+01, 4.0927786247E+00, 9.7842085174E-01],
	[4.3975000000E+04, 4.4369237614E+01, 5.4722435388E+00, 2.5618909417E+01, 4.0931232912E+00, 9.7843006782E-01],
	[4.3980000000E+04, 4.4378157629E+01, 5.4722891152E+00, 2.5628438613E+01, 4.0934678706E+00, 9.7843927941E-01],
	[4.3985000000E+04, 4.4387078423E+01, 5.4723346868E+00, 2.5637970269E+01, 4.0938123630E+00, 9.7844848650E-01],
	[4.3990000000E+04, 4.4395999995E+01, 5.4723802536E+00, 2.5647504384E+01, 4.0941567682E+00, 9.7845768910E-01],
	[4.3995000000E+04, 4.4404922347E+01, 5.4724258156E+00, 2.5657040959E+01, 4.0945010864E+00, 9.7846688721E-01],
	[4.4000000000E+04, 4.4413845477E+01, 5.4724713728E+00, 2.5666579995E+01, 4.0948453176E+00, 9.7847608083E-01],
	[4.4005000000E+04, 4.4422769387E+01, 5.4725169252E+00, 2.5676121491E+01, 4.0951894617E+00, 9.7848526997E-01],
	[4.4010000000E+04, 4.4431694075E+01, 5.4725624728E+00, 2.5685665448E+01, 4.0955335189E+00, 9.7849445463E-01],
	[4.4015000000E+04, 4.4440619542E+01, 5.4726080156E+00, 2.5695211866E+01, 4.0958774892E+00, 9.7850363480E-01],
	[4.4020000000E+04, 4.4449545787E+01, 5.4726535536E+00, 2.5704760746E+01, 4.0962213725E+00, 9.7851281050E-01],
	[4.4025000000E+04, 4.4458472812E+01, 5.4726990868E+00, 2.5714312088E+01, 4.0965651689E+00, 9.7852198172E-01],
	[4.4030000000E+04, 4.4467400615E+01, 5.4727446152E+00, 2.5723865892E+01, 4.0969088784E+00, 9.7853114847E-01],
	[4.4035000000E+04, 4.4476329197E+01, 5.4727901388E+00, 2.5733422160E+01, 4.0972525011E+00, 9.7854031075E-01],
	[4.4040000000E+04, 4.4485258558E+01, 5.4728356577E+00, 2.5742980890E+01, 4.0975960369E+00, 9.7854946856E-01],
	[4.4045000000E+04, 4.4494188697E+01, 5.4728811717E+00, 2.5752542083E+01, 4.0979394859E+00, 9.7855862191E-01],
	[4.4050000000E+04, 4.4503119615E+01, 5.4729266810E+00, 2.5762105741E+01, 4.0982828482E+00, 9.7856777079E-01],
	[4.4055000000E+04, 4.4512051312E+01, 5.4729721855E+00, 2.5771671863E+01, 4.0986261236E+00, 9.7857691521E-01],
	[4.4060000000E+04, 4.4520983788E+01, 5.4730176852E+00, 2.5781240449E+01, 4.0989693123E+00, 9.7858605518E-01],
	[4.4065000000E+04, 4.4529917042E+01, 5.4730631801E+00, 2.5790811500E+01, 4.0993124143E+00, 9.7859519069E-01],
	[4.4070000000E+04, 4.4538851074E+01, 5.4731086702E+00, 2.5800385016E+01, 4.0996554296E+00, 9.7860432174E-01],
	[4.4075000000E+04, 4.4547785885E+01, 5.4731541555E+00, 2.5809960998E+01, 4.0999983583E+00, 9.7861344834E-01],
	[4.4080000000E+04, 4.4556721475E+01, 5.4731996361E+00, 2.5819539446E+01, 4.1003412002E+00, 9.7862257050E-01],
	[4.4085000000E+04, 4.4565657843E+01, 5.4732451119E+00, 2.5829120360E+01, 4.1006839556E+00, 9.7863168821E-01],
	[4.4090000000E+04, 4.4574594990E+01, 5.4732905829E+00, 2.5838703740E+01, 4.1010266243E+00, 9.7864080147E-01],
	[4.4095000000E+04, 4.4583532915E+01, 5.4733360491E+00, 2.5848289588E+01, 4.1013692064E+00, 9.7864991030E-01],
	[4.4100000000E+04, 4.4592471619E+01, 5.4733815105E+00, 2.5857877903E+01, 4.1017117020E+00, 9.7865901468E-01],
	[4.4105000000E+04, 4.4601411101E+01, 5.4734269672E+00, 2.5867468686E+01, 4.1020541111E+00, 9.7866811463E-01],
	[4.4110000000E+04, 4.4610351361E+01, 5.4734724191E+00, 2.5877061937E+01, 4.1023964336E+00, 9.7867721015E-01],
	[4.4115000000E+04, 4.4619292400E+01, 5.4735178662E+00, 2.5886657656E+01, 4.1027386697E+00, 9.7868630123E-01],
	[4.4120000000E+04, 4.4628234217E+01, 5.4735633086E+00, 2.5896255844E+01, 4.1030808193E+00, 9.7869538788E-01],
	[4.4125000000E+04, 4.4637176813E+01, 5.4736087461E+00, 2.5905856501E+01, 4.1034228824E+00, 9.7870447011E-01],
	[4.4130000000E+04, 4.4646120187E+01, 5.4736541789E+00, 2.5915459627E+01, 4.1037648591E+00, 9.7871354791E-01],
	[4.4135000000E+04, 4.4655064339E+01, 5.4736996070E+00, 2.5925065224E+01, 4.1041067494E+00, 9.7872262129E-01],
	[4.4140000000E+04, 4.4664009270E+01, 5.4737450302E+00, 2.5934673290E+01, 4.1044485534E+00, 9.7873169025E-01],
	[4.4145000000E+04, 4.4672954979E+01, 5.4737904487E+00, 2.5944283828E+01, 4.1047902710E+00, 9.7874075479E-01],
	[4.4150000000E+04, 4.4681901466E+01, 5.4738358624E+00, 2.5953896836E+01, 4.1051319022E+00, 9.7874981492E-01],
	[4.4155000000E+04, 4.4690848732E+01, 5.4738812714E+00, 2.5963512315E+01, 4.1054734472E+00, 9.7875887064E-01],
	[4.4160000000E+04, 4.4699796775E+01, 5.4739266756E+00, 2.5973130266E+01, 4.1058149059E+00, 9.7876792194E-01],
	[4.4165000000E+04, 4.4708745597E+01, 5.4739720750E+00, 2.5982750689E+01, 4.1061562783E+00, 9.7877696884E-01],
	[4.4170000000E+04, 4.4717695197E+01, 5.4740174697E+00, 2.5992373584E+01, 4.1064975644E+00, 9.7878601133E-01],
	[4.4175000000E+04, 4.4726645575E+01, 5.4740628596E+00, 2.6001998952E+01, 4.1068387644E+00, 9.7879504942E-01],
	[4.4180000000E+04, 4.4735596732E+01, 5.4741082447E+00, 2.6011626793E+01, 4.1071798782E+00, 9.7880408311E-01],
	[4.4185000000E+04, 4.4744548666E+01, 5.4741536251E+00, 2.6021257107E+01, 4.1075209058E+00, 9.7881311240E-01],
	[4.4190000000E+04, 4.4753501379E+01, 5.4741990007E+00, 2.6030889895E+01, 4.1078618472E+00, 9.7882213730E-01],
	[4.4195000000E+04, 4.4762454869E+01, 5.4742443716E+00, 2.6040525157E+01, 4.1082027026E+00, 9.7883115780E-01],
	[4.4200000000E+04, 4.4771409138E+01, 5.4742897377E+00, 2.6050162894E+01, 4.1085434718E+00, 9.7884017391E-01],
	[4.4205000000E+04, 4.4780364185E+01, 5.4743350991E+00, 2.6059803105E+01, 4.1088841550E+00, 9.7884918564E-01],
	[4.4210000000E+04, 4.4789320009E+01, 5.4743804557E+00, 2.6069445791E+01, 4.1092247521E+00, 9.7885819297E-01],
	[4.4215000000E+04, 4.4798276612E+01, 5.4744258075E+00, 2.6079090953E+01, 4.1095652632E+00, 9.7886719593E-01],
	[4.4220000000E+04, 4.4807233993E+01, 5.4744711546E+00, 2.6088738591E+01, 4.1099056882E+00, 9.7887619450E-01],
	[4.4225000000E+04, 4.4816192151E+01, 5.4745164970E+00, 2.6098388705E+01, 4.1102460273E+00, 9.7888518869E-01],
	[4.4230000000E+04, 4.4825151088E+01, 5.4745618346E+00, 2.6108041296E+01, 4.1105862805E+00, 9.7889417851E-01],
	[4.4235000000E+04, 4.4834110803E+01, 5.4746071674E+00, 2.6117696364E+01, 4.1109264476E+00, 9.7890316395E-01],
	[4.4240000000E+04, 4.4843071295E+01, 5.4746524955E+00, 2.6127353908E+01, 4.1112665289E+00, 9.7891214502E-01],
	[4.4245000000E+04, 4.4852032565E+01, 5.4746978188E+00, 2.6137013931E+01, 4.1116065243E+00, 9.7892112172E-01],
	[4.4250000000E+04, 4.4860994613E+01, 5.4747431374E+00, 2.6146676431E+01, 4.1119464338E+00, 9.7893009406E-01],
	[4.4255000000E+04, 4.4869957439E+01, 5.4747884513E+00, 2.6156341410E+01, 4.1122862575E+00, 9.7893906203E-01],
	[4.4260000000E+04, 4.4878921043E+01, 5.4748337604E+00, 2.6166008868E+01, 4.1126259953E+00, 9.7894802563E-01],
	[4.4265000000E+04, 4.4887885425E+01, 5.4748790648E+00, 2.6175678805E+01, 4.1129656474E+00, 9.7895698488E-01],
	[4.4270000000E+04, 4.4896850584E+01, 5.4749243644E+00, 2.6185351221E+01, 4.1133052137E+00, 9.7896593977E-01],
	[4.4275000000E+04, 4.4905816521E+01, 5.4749696593E+00, 2.6195026116E+01, 4.1136446942E+00, 9.7897489031E-01],
	[4.4280000000E+04, 4.4914783236E+01, 5.4750149494E+00, 2.6204703492E+01, 4.1139840890E+00, 9.7898383649E-01],
	[4.4285000000E+04, 4.4923750728E+01, 5.4750602348E+00, 2.6214383349E+01, 4.1143233981E+00, 9.7899277832E-01],
	[4.4290000000E+04, 4.4932718998E+01, 5.4751055155E+00, 2.6224065686E+01, 4.1146626215E+00, 9.7900171581E-01],
	[4.4295000000E+04, 4.4941688046E+01, 5.4751507914E+00, 2.6233750505E+01, 4.1150017592E+00, 9.7901064895E-01],
	[4.4300000000E+04, 4.4950657872E+01, 5.4751960626E+00, 2.6243437805E+01, 4.1153408113E+00, 9.7901957774E-01],
	[4.4305000000E+04, 4.4959628475E+01, 5.4752413291E+00, 2.6253127586E+01, 4.1156797778E+00, 9.7902850220E-01],
	[4.4310000000E+04, 4.4968599856E+01, 5.4752865908E+00, 2.6262819851E+01, 4.1160186587E+00, 9.7903742231E-01],
	[4.4315000000E+04, 4.4977572014E+01, 5.4753318478E+00, 2.6272514597E+01, 4.1163574540E+00, 9.7904633809E-01],
	[4.4320000000E+04, 4.4986544950E+01, 5.4753771000E+00, 2.6282211827E+01, 4.1166961637E+00, 9.7905524954E-01],
	[4.4325000000E+04, 4.4995518664E+01, 5.4754223476E+00, 2.6291911540E+01, 4.1170347880E+00, 9.7906415665E-01],
	[4.4330000000E+04, 4.5004493155E+01, 5.4754675904E+00, 2.6301613737E+01, 4.1173733267E+00, 9.7907305944E-01],
	[4.4335000000E+04, 4.5013468423E+01, 5.4755128284E+00, 2.6311318418E+01, 4.1177117800E+00, 9.7908195790E-01],
	[4.4340000000E+04, 4.5022444469E+01, 5.4755580618E+00, 2.6321025583E+01, 4.1180501478E+00, 9.7909085204E-01],
	[4.4345000000E+04, 4.5031421292E+01, 5.4756032904E+00, 2.6330735233E+01, 4.1183884302E+00, 9.7909974185E-01],
	[4.4350000000E+04, 4.5040398893E+01, 5.4756485143E+00, 2.6340447368E+01, 4.1187266272E+00, 9.7910862734E-01],
	[4.4355000000E+04, 4.5049377272E+01, 5.4756937334E+00, 2.6350161988E+01, 4.1190647387E+00, 9.7911750852E-01],
	[4.4360000000E+04, 4.5058356427E+01, 5.4757389479E+00, 2.6359879094E+01, 4.1194027650E+00, 9.7912638538E-01],
	[4.4365000000E+04, 4.5067336361E+01, 5.4757841576E+00, 2.6369598687E+01, 4.1197407059E+00, 9.7913525793E-01],
	[4.4370000000E+04, 4.5076317071E+01, 5.4758293626E+00, 2.6379320766E+01, 4.1200785614E+00, 9.7914412617E-01],
	[4.4375000000E+04, 4.5085298559E+01, 5.4758745629E+00, 2.6389045332E+01, 4.1204163317E+00, 9.7915299011E-01],
	[4.4380000000E+04, 4.5094280824E+01, 5.4759197584E+00, 2.6398772385E+01, 4.1207540167E+00, 9.7916184973E-01],
	[4.4385000000E+04, 4.5103263866E+01, 5.4759649493E+00, 2.6408501925E+01, 4.1210916164E+00, 9.7917070506E-01],
	[4.4390000000E+04, 4.5112247686E+01, 5.4760101354E+00, 2.6418233954E+01, 4.1214291310E+00, 9.7917955608E-01],
	[4.4395000000E+04, 4.5121232283E+01, 5.4760553168E+00, 2.6427968471E+01, 4.1217665603E+00, 9.7918840281E-01],
	[4.4400000000E+04, 4.5130217657E+01, 5.4761004935E+00, 2.6437705476E+01, 4.1221039044E+00, 9.7919724524E-01],
	[4.4405000000E+04, 4.5139203809E+01, 5.4761456654E+00, 2.6447444971E+01, 4.1224411634E+00, 9.7920608338E-01],
	[4.4410000000E+04, 4.5148190737E+01, 5.4761908327E+00, 2.6457186955E+01, 4.1227783373E+00, 9.7921491722E-01],
	[4.4415000000E+04, 4.5157178443E+01, 5.4762359952E+00, 2.6466931428E+01, 4.1231154260E+00, 9.7922374678E-01],
	[4.4420000000E+04, 4.5166166926E+01, 5.4762811531E+00, 2.6476678392E+01, 4.1234524296E+00, 9.7923257205E-01],
	[4.4425000000E+04, 4.5175156186E+01, 5.4763263062E+00, 2.6486427846E+01, 4.1237893482E+00, 9.7924139303E-01],
	[4.4430000000E+04, 4.5184146224E+01, 5.4763714546E+00, 2.6496179791E+01, 4.1241261818E+00, 9.7925020974E-01],
	[4.4435000000E+04, 4.5193137038E+01, 5.4764165983E+00, 2.6505934227E+01, 4.1244629303E+00, 9.7925902216E-01],
	[4.4440000000E+04, 4.5202128630E+01, 5.4764617373E+00, 2.6515691154E+01, 4.1247995938E+00, 9.7926783031E-01],
	[4.4445000000E+04, 4.5211120998E+01, 5.4765068716E+00, 2.6525450574E+01, 4.1251361724E+00, 9.7927663419E-01],
	[4.4450000000E+04, 4.5220114144E+01, 5.4765520012E+00, 2.6535212485E+01, 4.1254726660E+00, 9.7928543379E-01],
	[4.4455000000E+04, 4.5229108066E+01, 5.4765971261E+00, 2.6544976889E+01, 4.1258090746E+00, 9.7929422912E-01],
	[4.4460000000E+04, 4.5238102766E+01, 5.4766422462E+00, 2.6554743786E+01, 4.1261453984E+00, 9.7930302018E-01],
	[4.4465000000E+04, 4.5247098242E+01, 5.4766873617E+00, 2.6564513177E+01, 4.1264816373E+00, 9.7931180698E-01],
	[4.4470000000E+04, 4.5256094496E+01, 5.4767324725E+00, 2.6574285061E+01, 4.1268177913E+00, 9.7932058953E-01],
	[4.4475000000E+04, 4.5265091526E+01, 5.4767775786E+00, 2.6584059439E+01, 4.1271538605E+00, 9.7932936783E-01],
	[4.4480000000E+04, 4.5274089334E+01, 5.4768226800E+00, 2.6593836311E+01, 4.1274898449E+00, 9.7933814189E-01],
	[4.4485000000E+04, 4.5283087918E+01, 5.4768677766E+00, 2.6603615678E+01, 4.1278257445E+00, 9.7934691170E-01],
	[4.4490000000E+04, 4.5292087279E+01, 5.4769128686E+00, 2.6613397540E+01, 4.1281615593E+00, 9.7935567727E-01],
	[4.4495000000E+04, 4.5301087417E+01, 5.4769579559E+00, 2.6623181897E+01, 4.1284972894E+00, 9.7936443861E-01],
	[4.4500000000E+04, 4.5310088332E+01, 5.4770030385E+00, 2.6632968750E+01, 4.1288329347E+00, 9.7937319570E-01],
	[4.4505000000E+04, 4.5319090023E+01, 5.4770481164E+00, 2.6642758100E+01, 4.1291684954E+00, 9.7938194856E-01],
	[4.4510000000E+04, 4.5328092492E+01, 5.4770931896E+00, 2.6652549945E+01, 4.1295039714E+00, 9.7939069718E-01],
	[4.4515000000E+04, 4.5337095737E+01, 5.4771382581E+00, 2.6662344288E+01, 4.1298393627E+00, 9.7939944158E-01],
	[4.4520000000E+04, 4.5346099759E+01, 5.4771833219E+00, 2.6672141128E+01, 4.1301746694E+00, 9.7940818174E-01],
	[4.4525000000E+04, 4.5355104558E+01, 5.4772283810E+00, 2.6681940465E+01, 4.1305098915E+00, 9.7941691768E-01],
	[4.4530000000E+04, 4.5364110133E+01, 5.4772734355E+00, 2.6691742300E+01, 4.1308450290E+00, 9.7942564939E-01],
	[4.4535000000E+04, 4.5373116485E+01, 5.4773184852E+00, 2.6701546634E+01, 4.1311800819E+00, 9.7943437688E-01],
	[4.4540000000E+04, 4.5382123614E+01, 5.4773635303E+00, 2.6711353466E+01, 4.1315150503E+00, 9.7944310015E-01],
	[4.4545000000E+04, 4.5391131519E+01, 5.4774085707E+00, 2.6721162797E+01, 4.1318499342E+00, 9.7945181919E-01],
	[4.4550000000E+04, 4.5400140202E+01, 5.4774536064E+00, 2.6730974627E+01, 4.1321847336E+00, 9.7946053403E-01],
	[4.4555000000E+04, 4.5409149660E+01, 5.4774986374E+00, 2.6740788957E+01, 4.1325194485E+00, 9.7946924464E-01],
	[4.4560000000E+04, 4.5418159896E+01, 5.4775436637E+00, 2.6750605787E+01, 4.1328540789E+00, 9.7947795104E-01],
	[4.4565000000E+04, 4.5427170907E+01, 5.4775886854E+00, 2.6760425117E+01, 4.1331886250E+00, 9.7948665324E-01],
	[4.4570000000E+04, 4.5436182696E+01, 5.4776337023E+00, 2.6770246948E+01, 4.1335230866E+00, 9.7949535122E-01],
	[4.4575000000E+04, 4.5445195261E+01, 5.4776787146E+00, 2.6780071281E+01, 4.1338574639E+00, 9.7950404500E-01],
	[4.4580000000E+04, 4.5454208602E+01, 5.4777237222E+00, 2.6789898114E+01, 4.1341917568E+00, 9.7951273457E-01],
	[4.4585000000E+04, 4.5463226055E+01, 5.4777690830E+00, 2.6799727450E+01, 4.1345261968E+00, 9.7952141994E-01],
	[4.4590000000E+04, 4.5472259011E+01, 5.4778160191E+00, 2.6809559287E+01, 4.1348615746E+00, 9.7953010111E-01],
	[4.4595000000E+04, 4.5481292748E+01, 5.4778629503E+00, 2.6819393627E+01, 4.1351968682E+00, 9.7953877808E-01],
	[4.4600000000E+04, 4.5490327267E+01, 5.4779098767E+00, 2.6829230471E+01, 4.1355320778E+00, 9.7954745085E-01],
	[4.4605000000E+04, 4.5499362568E+01, 5.4779567982E+00, 2.6839069817E+01, 4.1358672034E+00, 9.7955611943E-01],
	[4.4610000000E+04, 4.5508398650E+01, 5.4780037149E+00, 2.6848911667E+01, 4.1362022449E+00, 9.7956478381E-01],
	[4.4615000000E+04, 4.5517435514E+01, 5.4780506267E+00, 2.6858756020E+01, 4.1365372024E+00, 9.7957344401E-01],
	[4.4620000000E+04, 4.5526473159E+01, 5.4780975337E+00, 2.6868602878E+01, 4.1368720759E+00, 9.7958210001E-01],
	[4.4625000000E+04, 4.5535511586E+01, 5.4781444358E+00, 2.6878452241E+01, 4.1372068654E+00, 9.7959075183E-01],
	[4.4630000000E+04, 4.5544550794E+01, 5.4781913330E+00, 2.6888304109E+01, 4.1375415710E+00, 9.7959939947E-01],
	[4.4635000000E+04, 4.5553590784E+01, 5.4782382254E+00, 2.6898158482E+01, 4.1378761927E+00, 9.7960804292E-01],
	[4.4640000000E+04, 4.5562631555E+01, 5.4782851129E+00, 2.6908015361E+01, 4.1382107305E+00, 9.7961668220E-01],
	[4.4645000000E+04, 4.5571673107E+01, 5.4783319956E+00, 2.6917874746E+01, 4.1385451844E+00, 9.7962531729E-01],
	[4.4650000000E+04, 4.5580715441E+01, 5.4783788735E+00, 2.6927736637E+01, 4.1388795545E+00, 9.7963394821E-01],
	[4.4655000000E+04, 4.5589758556E+01, 5.4784257465E+00, 2.6937601035E+01, 4.1392138407E+00, 9.7964257496E-01],
	[4.4660000000E+04, 4.5598802452E+01, 5.4784726146E+00, 2.6947467940E+01, 4.1395480431E+00, 9.7965119753E-01],
	[4.4665000000E+04, 4.5607847130E+01, 5.4785194779E+00, 2.6957337353E+01, 4.1398821617E+00, 9.7965981593E-01],
	[4.4670000000E+04, 4.5616892589E+01, 5.4785663364E+00, 2.6967209274E+01, 4.1402161966E+00, 9.7966843017E-01],
	[4.4675000000E+04, 4.5625938829E+01, 5.4786131900E+00, 2.6977083702E+01, 4.1405501478E+00, 9.7967704024E-01],
	[4.4680000000E+04, 4.5634985851E+01, 5.4786600388E+00, 2.6986960640E+01, 4.1408840152E+00, 9.7968564614E-01],
	[4.4685000000E+04, 4.5644033654E+01, 5.4787068827E+00, 2.6996840086E+01, 4.1412177989E+00, 9.7969424788E-01],
	[4.4690000000E+04, 4.5653082238E+01, 5.4787537218E+00, 2.7006722041E+01, 4.1415514990E+00, 9.7970284547E-01],
	[4.4695000000E+04, 4.5662131603E+01, 5.4788005560E+00, 2.7016606507E+01, 4.1418851154E+00, 9.7971143889E-01],
	[4.4700000000E+04, 4.5671181750E+01, 5.4788473854E+00, 2.7026493482E+01, 4.1422186482E+00, 9.7972002816E-01],
	[4.4705000000E+04, 4.5680232677E+01, 5.4788942100E+00, 2.7036382967E+01, 4.1425520973E+00, 9.7972861328E-01],
	[4.4710000000E+04, 4.5689284386E+01, 5.4789410297E+00, 2.7046274964E+01, 4.1428854629E+00, 9.7973719424E-01],
	[4.4715000000E+04, 4.5698336876E+01, 5.4789878446E+00, 2.7056169471E+01, 4.1432187450E+00, 9.7974577106E-01],
	[4.4720000000E+04, 4.5707390147E+01, 5.4790346547E+00, 2.7066066490E+01, 4.1435519435E+00, 9.7975434372E-01],
	[4.4725000000E+04, 4.5716444199E+01, 5.4790814599E+00, 2.7075966020E+01, 4.1438850585E+00, 9.7976291224E-01],
	[4.4730000000E+04, 4.5725499032E+01, 5.4791282603E+00, 2.7085868063E+01, 4.1442180900E+00, 9.7977147662E-01],
	[4.4735000000E+04, 4.5734554646E+01, 5.4791750559E+00, 2.7095772618E+01, 4.1445510380E+00, 9.7978003686E-01],
	[4.4740000000E+04, 4.5743611041E+01, 5.4792218466E+00, 2.7105679686E+01, 4.1448839026E+00, 9.7978859295E-01],
	[4.4745000000E+04, 4.5752668217E+01, 5.4792686326E+00, 2.7115589267E+01, 4.1452166838E+00, 9.7979714491E-01],
	[4.4750000000E+04, 4.5761726174E+01, 5.4793154136E+00, 2.7125501361E+01, 4.1455493816E+00, 9.7980569274E-01],
	[4.4755000000E+04, 4.5770784912E+01, 5.4793621899E+00, 2.7135415970E+01, 4.1458819960E+00, 9.7981423643E-01],
	[4.4760000000E+04, 4.5779844431E+01, 5.4794089613E+00, 2.7145333093E+01, 4.1462145270E+00, 9.7982277599E-01],
	[4.4765000000E+04, 4.5788904731E+01, 5.4794557279E+00, 2.7155252730E+01, 4.1465469747E+00, 9.7983131142E-01],
	[4.4770000000E+04, 4.5797965812E+01, 5.4795024897E+00, 2.7165174882E+01, 4.1468793391E+00, 9.7983984272E-01],
	[4.4775000000E+04, 4.5807027674E+01, 5.4795492466E+00, 2.7175099550E+01, 4.1472116202E+00, 9.7984836990E-01],
	[4.4780000000E+04, 4.5816090316E+01, 5.4795959988E+00, 2.7185026734E+01, 4.1475438181E+00, 9.7985689295E-01],
	[4.4785000000E+04, 4.5825153740E+01, 5.4796427461E+00, 2.7194956433E+01, 4.1478759327E+00, 9.7986541189E-01],
	[4.4790000000E+04, 4.5834217944E+01, 5.4796894886E+00, 2.7204888649E+01, 4.1482079640E+00, 9.7987392670E-01],
	[4.4795000000E+04, 4.5843282929E+01, 5.4797362262E+00, 2.7214823382E+01, 4.1485399122E+00, 9.7988243740E-01],
	[4.4800000000E+04, 4.5852348695E+01, 5.4797829591E+00, 2.7224760631E+01, 4.1488717772E+00, 9.7989094398E-01],
	[4.4805000000E+04, 4.5861415241E+01, 5.4798296871E+00, 2.7234700398E+01, 4.1492035591E+00, 9.7989944645E-01],
	[4.4810000000E+04, 4.5870482569E+01, 5.4798764103E+00, 2.7244642683E+01, 4.1495352578E+00, 9.7990794481E-01],
	[4.4815000000E+04, 4.5879550677E+01, 5.4799231288E+00, 2.7254587487E+01, 4.1498668735E+00, 9.7991643906E-01],
	[4.4820000000E+04, 4.5888619565E+01, 5.4799698423E+00, 2.7264534808E+01, 4.1501984060E+00, 9.7992492920E-01],
	[4.4825000000E+04, 4.5897689235E+01, 5.4800165511E+00, 2.7274484649E+01, 4.1505298555E+00, 9.7993341524E-01],
	[4.4830000000E+04, 4.5906759685E+01, 5.4800632551E+00, 2.7284437009E+01, 4.1508612219E+00, 9.7994189717E-01],
	[4.4835000000E+04, 4.5915830915E+01, 5.4801099542E+00, 2.7294391888E+01, 4.1511925054E+00, 9.7995037501E-01],
	[4.4840000000E+04, 4.5924902927E+01, 5.4801566486E+00, 2.7304349288E+01, 4.1515237058E+00, 9.7995884874E-01],
	[4.4845000000E+04, 4.5933975719E+01, 5.4802033381E+00, 2.7314309207E+01, 4.1518548233E+00, 9.7996731838E-01],
	[4.4850000000E+04, 4.5943049291E+01, 5.4802500229E+00, 2.7324271648E+01, 4.1521858578E+00, 9.7997578392E-01],
	[4.4855000000E+04, 4.5952123644E+01, 5.4802967028E+00, 2.7334236609E+01, 4.1525168094E+00, 9.7998424537E-01],
	[4.4860000000E+04, 4.5961198778E+01, 5.4803433779E+00, 2.7344204092E+01, 4.1528476780E+00, 9.7999270274E-01],
	[4.4865000000E+04, 4.5970274692E+01, 5.4803900482E+00, 2.7354174097E+01, 4.1531784638E+00, 9.8000115601E-01],
	[4.4870000000E+04, 4.5979351386E+01, 5.4804367137E+00, 2.7364146623E+01, 4.1535091668E+00, 9.8000960519E-01],
	[4.4875000000E+04, 4.5988428861E+01, 5.4804833744E+00, 2.7374121673E+01, 4.1538397869E+00, 9.8001805029E-01],
	[4.4880000000E+04, 4.5997507117E+01, 5.4805300303E+00, 2.7384099244E+01, 4.1541703242E+00, 9.8002649131E-01],
	[4.4885000000E+04, 4.6006586153E+01, 5.4805766814E+00, 2.7394079340E+01, 4.1545007787E+00, 9.8003492825E-01],
	[4.4890000000E+04, 4.6015665969E+01, 5.4806233277E+00, 2.7404061958E+01, 4.1548311504E+00, 9.8004336111E-01],
	[4.4895000000E+04, 4.6024746566E+01, 5.4806699693E+00, 2.7414047101E+01, 4.1551614394E+00, 9.8005178990E-01],
	[4.4900000000E+04, 4.6033827943E+01, 5.4807166060E+00, 2.7424034767E+01, 4.1554916457E+00, 9.8006021461E-01],
	[4.4905000000E+04, 4.6042910101E+01, 5.4807632379E+00, 2.7434024959E+01, 4.1558217692E+00, 9.8006863524E-01],
	[4.4910000000E+04, 4.6051993039E+01, 5.4808098650E+00, 2.7444017675E+01, 4.1561518101E+00, 9.8007705181E-01],
	[4.4915000000E+04, 4.6061076757E+01, 5.4808564873E+00, 2.7454012917E+01, 4.1564817683E+00, 9.8008546431E-01],
	[4.4920000000E+04, 4.6070161255E+01, 5.4809031049E+00, 2.7464010684E+01, 4.1568116439E+00, 9.8009387274E-01],
	[4.4925000000E+04, 4.6079246534E+01, 5.4809497176E+00, 2.7474010977E+01, 4.1571414369E+00, 9.8010227711E-01],
	[4.4930000000E+04, 4.6088332593E+01, 5.4809963255E+00, 2.7484013797E+01, 4.1574711473E+00, 9.8011067741E-01],
	[4.4935000000E+04, 4.6097419432E+01, 5.4810429287E+00, 2.7494019143E+01, 4.1578007751E+00, 9.8011907366E-01],
	[4.4940000000E+04, 4.6106507052E+01, 5.4810895271E+00, 2.7504027016E+01, 4.1581303204E+00, 9.8012746585E-01],
	[4.4945000000E+04, 4.6115595451E+01, 5.4811361206E+00, 2.7514037417E+01, 4.1584597831E+00, 9.8013585398E-01],
	[4.4950000000E+04, 4.6124684631E+01, 5.4811827094E+00, 2.7524050346E+01, 4.1587891634E+00, 9.8014423806E-01],
	[4.4955000000E+04, 4.6133774591E+01, 5.4812292934E+00, 2.7534065803E+01, 4.1591184612E+00, 9.8015261808E-01],
	[4.4960000000E+04, 4.6142865332E+01, 5.4812758727E+00, 2.7544083788E+01, 4.1594476765E+00, 9.8016099406E-01],
	[4.4965000000E+04, 4.6151956852E+01, 5.4813224471E+00, 2.7554104302E+01, 4.1597768094E+00, 9.8016936598E-01],
	[4.4970000000E+04, 4.6161049152E+01, 5.4813690168E+00, 2.7564127346E+01, 4.1601058599E+00, 9.8017773387E-01],
	[4.4975000000E+04, 4.6170142233E+01, 5.4814155816E+00, 2.7574152919E+01, 4.1604348280E+00, 9.8018609770E-01],
	[4.4980000000E+04, 4.6179236093E+01, 5.4814621417E+00, 2.7584181022E+01, 4.1607637137E+00, 9.8019445750E-01],
	[4.4985000000E+04, 4.6188330734E+01, 5.4815086970E+00, 2.7594211655E+01, 4.1610925171E+00, 9.8020281326E-01],
	[4.4990000000E+04, 4.6197426155E+01, 5.4815552476E+00, 2.7604244819E+01, 4.1614212382E+00, 9.8021116497E-01],
	[4.4995000000E+04, 4.6206522355E+01, 5.4816017933E+00, 2.7614280514E+01, 4.1617498770E+00, 9.8021951266E-01],
	[4.5000000000E+04, 4.6215619336E+01, 5.4816483343E+00, 2.7624318740E+01, 4.1620784335E+00, 9.8022785630E-01],
	[4.5005000000E+04, 4.6224717096E+01, 5.4816948705E+00, 2.7634380411E+01, 4.1624073822E+00, 9.8023619592E-01],
	[4.5010000000E+04, 4.6233815637E+01, 5.4817414019E+00, 2.7644444627E+01, 4.1627362484E+00, 9.8024453151E-01],
	[4.5015000000E+04, 4.6242914957E+01, 5.4817879286E+00, 2.7654511389E+01, 4.1630650322E+00, 9.8025286307E-01],
	[4.5020000000E+04, 4.6252015058E+01, 5.4818344505E+00, 2.7664580696E+01, 4.1633937336E+00, 9.8026119060E-01],
	[4.5025000000E+04, 4.6261115938E+01, 5.4818809676E+00, 2.7674652550E+01, 4.1637223525E+00, 9.8026951411E-01],
	[4.5030000000E+04, 4.6270217598E+01, 5.4819274799E+00, 2.7684726949E+01, 4.1640508891E+00, 9.8027783360E-01],
	[4.5035000000E+04, 4.6279320038E+01, 5.4819739875E+00, 2.7694803896E+01, 4.1643793433E+00, 9.8028614907E-01],
	[4.5040000000E+04, 4.6288423258E+01, 5.4820204903E+00, 2.7704883390E+01, 4.1647077151E+00, 9.8029446052E-01],
	[4.5045000000E+04, 4.6297527257E+01, 5.4820669883E+00, 2.7714965432E+01, 4.1650360046E+00, 9.8030276796E-01],
	[4.5050000000E+04, 4.6306632037E+01, 5.4821134816E+00, 2.7725050021E+01, 4.1653642119E+00, 9.8031107138E-01],
	[4.5055000000E+04, 4.6315737596E+01, 5.4821599701E+00, 2.7735137159E+01, 4.1656923368E+00, 9.8031937079E-01],
	[4.5060000000E+04, 4.6324843935E+01, 5.4822064538E+00, 2.7745226845E+01, 4.1660203795E+00, 9.8032766619E-01],
	[4.5065000000E+04, 4.6333951053E+01, 5.4822529328E+00, 2.7755319080E+01, 4.1663483400E+00, 9.8033595758E-01],
	[4.5070000000E+04, 4.6343058951E+01, 5.4822994070E+00, 2.7765413865E+01, 4.1666762183E+00, 9.8034424497E-01],
	[4.5075000000E+04, 4.6352167629E+01, 5.4823458764E+00, 2.7775511200E+01, 4.1670040144E+00, 9.8035252835E-01],
	[4.5080000000E+04, 4.6361277087E+01, 5.4823923411E+00, 2.7785611084E+01, 4.1673317283E+00, 9.8036080774E-01],
	[4.5085000000E+04, 4.6370387324E+01, 5.4824388011E+00, 2.7795713519E+01, 4.1676593601E+00, 9.8036908312E-01],
	[4.5090000000E+04, 4.6379498341E+01, 5.4824852562E+00, 2.7805818505E+01, 4.1679869098E+00, 9.8037735451E-01],
	[4.5095000000E+04, 4.6388610138E+01, 5.4825317066E+00, 2.7815926042E+01, 4.1683143774E+00, 9.8038562190E-01],
	[4.5100000000E+04, 4.6397722714E+01, 5.4825781523E+00, 2.7826036131E+01, 4.1686417629E+00, 9.8039388530E-01],
	[4.5105000000E+04, 4.6406836070E+01, 5.4826245932E+00, 2.7836148771E+01, 4.1689690663E+00, 9.8040214470E-01],
	[4.5110000000E+04, 4.6415950205E+01, 5.4826710293E+00, 2.7846263964E+01, 4.1692962878E+00, 9.8041040012E-01],
	[4.5115000000E+04, 4.6425065120E+01, 5.4827174607E+00, 2.7856381709E+01, 4.1696234272E+00, 9.8041865155E-01],
	[4.5120000000E+04, 4.6434180814E+01, 5.4827638874E+00, 2.7866502008E+01, 4.1699504846E+00, 9.8042689899E-01],
	[4.5125000000E+04, 4.6443297288E+01, 5.4828103093E+00, 2.7876624859E+01, 4.1702774601E+00, 9.8043514245E-01],
	[4.5130000000E+04, 4.6452414541E+01, 5.4828567264E+00, 2.7886750265E+01, 4.1706043537E+00, 9.8044338193E-01],
	[4.5135000000E+04, 4.6461532574E+01, 5.4829031388E+00, 2.7896878224E+01, 4.1709311653E+00, 9.8045161743E-01],
	[4.5140000000E+04, 4.6470651386E+01, 5.4829495464E+00, 2.7907008738E+01, 4.1712578950E+00, 9.8045984896E-01],
	[4.5145000000E+04, 4.6479770977E+01, 5.4829959493E+00, 2.7917141806E+01, 4.1715845429E+00, 9.8046807651E-01],
	[4.5150000000E+04, 4.6488891348E+01, 5.4830423475E+00, 2.7927277430E+01, 4.1719111089E+00, 9.8047630008E-01],
	[4.5155000000E+04, 4.6498012499E+01, 5.4830887409E+00, 2.7937415609E+01, 4.1722375931E+00, 9.8048451968E-01],
	[4.5160000000E+04, 4.6507134428E+01, 5.4831351295E+00, 2.7947556345E+01, 4.1725639955E+00, 9.8049273532E-01],
	[4.5165000000E+04, 4.6516257137E+01, 5.4831815134E+00, 2.7957699636E+01, 4.1728903161E+00, 9.8050094699E-01],
	[4.5170000000E+04, 4.6525380626E+01, 5.4832278926E+00, 2.7967845484E+01, 4.1732165550E+00, 9.8050915469E-01],
	[4.5175000000E+04, 4.6534504893E+01, 5.4832742670E+00, 2.7977993889E+01, 4.1735427121E+00, 9.8051735843E-01],
	[4.5180000000E+04, 4.6543629940E+01, 5.4833206367E+00, 2.7988144851E+01, 4.1738687875E+00, 9.8052555820E-01],
	[4.5185000000E+04, 4.6552755766E+01, 5.4833670017E+00, 2.7998298371E+01, 4.1741947812E+00, 9.8053375402E-01],
	[4.5190000000E+04, 4.6561882372E+01, 5.4834133619E+00, 2.8008454449E+01, 4.1745206932E+00, 9.8054194589E-01],
	[4.5195000000E+04, 4.6571009756E+01, 5.4834597173E+00, 2.8018613085E+01, 4.1748465236E+00, 9.8055013379E-01],
	[4.5200000000E+04, 4.6580137920E+01, 5.4835060681E+00, 2.8028774280E+01, 4.1751722724E+00, 9.8055831775E-01],
	[4.5205000000E+04, 4.6589266863E+01, 5.4835524141E+00, 2.8038938034E+01, 4.1754979396E+00, 9.8056649775E-01],
	[4.5210000000E+04, 4.6598396585E+01, 5.4835987553E+00, 2.8049104348E+01, 4.1758235252E+00, 9.8057467380E-01],
	[4.5215000000E+04, 4.6607527086E+01, 5.4836450919E+00, 2.8059273221E+01, 4.1761490292E+00, 9.8058284591E-01],
	[4.5220000000E+04, 4.6616658367E+01, 5.4836914237E+00, 2.8069444655E+01, 4.1764744517E+00, 9.8059101407E-01],
	[4.5225000000E+04, 4.6625790426E+01, 5.4837377508E+00, 2.8079618649E+01, 4.1767997927E+00, 9.8059917829E-01],
	[4.5230000000E+04, 4.6634923265E+01, 5.4837840731E+00, 2.8089795204E+01, 4.1771250522E+00, 9.8060733856E-01],
	[4.5235000000E+04, 4.6644056882E+01, 5.4838303907E+00, 2.8099974320E+01, 4.1774502302E+00, 9.8061549490E-01],
	[4.5240000000E+04, 4.6653191279E+01, 5.4838767036E+00, 2.8110155998E+01, 4.1777753268E+00, 9.8062364730E-01],
	[4.5245000000E+04, 4.6662326454E+01, 5.4839230117E+00, 2.8120340238E+01, 4.1781003420E+00, 9.8063179577E-01],
	[4.5250000000E+04, 4.6671462409E+01, 5.4839693152E+00, 2.8130527041E+01, 4.1784252757E+00, 9.8063994030E-01],
	[4.5255000000E+04, 4.6680599143E+01, 5.4840156139E+00, 2.8140716406E+01, 4.1787501281E+00, 9.8064808090E-01],
	[4.5260000000E+04, 4.6689736655E+01, 5.4840619079E+00, 2.8150908334E+01, 4.1790748991E+00, 9.8065621758E-01],
	[4.5265000000E+04, 4.6698874947E+01, 5.4841081971E+00, 2.8161102826E+01, 4.1793995888E+00, 9.8066435032E-01],
	[4.5270000000E+04, 4.6708014017E+01, 5.4841544817E+00, 2.8171299881E+01, 4.1797241972E+00, 9.8067247915E-01],
	[4.5275000000E+04, 4.6717153866E+01, 5.4842007615E+00, 2.8181499501E+01, 4.1800487243E+00, 9.8068060404E-01],
	[4.5280000000E+04, 4.6726294495E+01, 5.4842470366E+00, 2.8191701685E+01, 4.1803731701E+00, 9.8068872502E-01],
	[4.5285000000E+04, 4.6735435902E+01, 5.4842933069E+00, 2.8201906434E+01, 4.1806975347E+00, 9.8069684208E-01],
	[4.5290000000E+04, 4.6744578088E+01, 5.4843395726E+00, 2.8212113748E+01, 4.1810218181E+00, 9.8070495522E-01],
	[4.5295000000E+04, 4.6753721052E+01, 5.4843858335E+00, 2.8222323628E+01, 4.1813460203E+00, 9.8071306445E-01],
	[4.5300000000E+04, 4.6762864796E+01, 5.4844320898E+00, 2.8232536074E+01, 4.1816701412E+00, 9.8072116976E-01],
	[4.5305000000E+04, 4.6772020765E+01, 5.4844795473E+00, 2.8242751086E+01, 4.1819949738E+00, 9.8072927116E-01],
	[4.5310000000E+04, 4.6781184066E+01, 5.4845276900E+00, 2.8252968664E+01, 4.1823201789E+00, 9.8073736866E-01],
	[4.5315000000E+04, 4.6790348152E+01, 5.4845758278E+00, 2.8263188810E+01, 4.1826453031E+00, 9.8074546224E-01],
	[4.5320000000E+04, 4.6799513021E+01, 5.4846239607E+00, 2.8273411524E+01, 4.1829703464E+00, 9.8075355192E-01],
	[4.5325000000E+04, 4.6808678674E+01, 5.4846720887E+00, 2.8283636805E+01, 4.1832953088E+00, 9.8076163770E-01],
	[4.5330000000E+04, 4.6817845110E+01, 5.4847202119E+00, 2.8293864654E+01, 4.1836201903E+00, 9.8076971958E-01],
	[4.5335000000E+04, 4.6827012331E+01, 5.4847683302E+00, 2.8304095072E+01, 4.1839449910E+00, 9.8077779756E-01],
	[4.5340000000E+04, 4.6836180335E+01, 5.4848164435E+00, 2.8314328058E+01, 4.1842697108E+00, 9.8078587164E-01],
	[4.5345000000E+04, 4.6845349122E+01, 5.4848645520E+00, 2.8324563614E+01, 4.1845943499E+00, 9.8079394183E-01],
	[4.5350000000E+04, 4.6854518694E+01, 5.4849126557E+00, 2.8334801739E+01, 4.1849189081E+00, 9.8080200812E-01],
	[4.5355000000E+04, 4.6863689049E+01, 5.4849607544E+00, 2.8345042435E+01, 4.1852433856E+00, 9.8081007052E-01],
	[4.5360000000E+04, 4.6872860187E+01, 5.4850088482E+00, 2.8355285700E+01, 4.1855677824E+00, 9.8081812904E-01],
	[4.5365000000E+04, 4.6882032110E+01, 5.4850569372E+00, 2.8365531536E+01, 4.1858920985E+00, 9.8082618366E-01],
	[4.5370000000E+04, 4.6891204815E+01, 5.4851050213E+00, 2.8375779944E+01, 4.1862163338E+00, 9.8083423440E-01],
	[4.5375000000E+04, 4.6900378305E+01, 5.4851531005E+00, 2.8386030922E+01, 4.1865404885E+00, 9.8084228126E-01],
	[4.5380000000E+04, 4.6909552578E+01, 5.4852011749E+00, 2.8396284473E+01, 4.1868645625E+00, 9.8085032424E-01],
	[4.5385000000E+04, 4.6918727634E+01, 5.4852492443E+00, 2.8406540595E+01, 4.1871885560E+00, 9.8085836334E-01],
	[4.5390000000E+04, 4.6927903474E+01, 5.4852973089E+00, 2.8416799290E+01, 4.1875124688E+00, 9.8086639856E-01],
	[4.5395000000E+04, 4.6937080098E+01, 5.4853453686E+00, 2.8427060558E+01, 4.1878363010E+00, 9.8087442991E-01],
	[4.5400000000E+04, 4.6946257505E+01, 5.4853934235E+00, 2.8437324399E+01, 4.1881600526E+00, 9.8088245738E-01],
	[4.5405000000E+04, 4.6955435695E+01, 5.4854414734E+00, 2.8447590814E+01, 4.1884837238E+00, 9.8089048098E-01],
	[4.5410000000E+04, 4.6964614669E+01, 5.4854895186E+00, 2.8457859802E+01, 4.1888073144E+00, 9.8089850072E-01],
	[4.5415000000E+04, 4.6973794426E+01, 5.4855375588E+00, 2.8468131365E+01, 4.1891308245E+00, 9.8090651659E-01],
	[4.5420000000E+04, 4.6982974967E+01, 5.4855855942E+00, 2.8478405502E+01, 4.1894542542E+00, 9.8091452859E-01],
	[4.5425000000E+04, 4.6992156291E+01, 5.4856336247E+00, 2.8488682215E+01, 4.1897776033E+00, 9.8092253673E-01],
	[4.5430000000E+04, 4.7001338398E+01, 5.4856816503E+00, 2.8498961503E+01, 4.1901008721E+00, 9.8093054100E-01],
	[4.5435000000E+04, 4.7010521289E+01, 5.4857296711E+00, 2.8509243366E+01, 4.1904240605E+00, 9.8093854142E-01],
	[4.5440000000E+04, 4.7019704963E+01, 5.4857776870E+00, 2.8519527806E+01, 4.1907471685E+00, 9.8094653798E-01],
	[4.5445000000E+04, 4.7028889420E+01, 5.4858256980E+00, 2.8529814822E+01, 4.1910701961E+00, 9.8095453069E-01],
	[4.5450000000E+04, 4.7038074661E+01, 5.4858737042E+00, 2.8540104414E+01, 4.1913931434E+00, 9.8096251954E-01],
	[4.5455000000E+04, 4.7047260685E+01, 5.4859217055E+00, 2.8550396584E+01, 4.1917160103E+00, 9.8097050454E-01],
	[4.5460000000E+04, 4.7056447492E+01, 5.4859697020E+00, 2.8560691332E+01, 4.1920387970E+00, 9.8097848570E-01],
	[4.5465000000E+04, 4.7065635082E+01, 5.4860176936E+00, 2.8570988657E+01, 4.1923615034E+00, 9.8098646300E-01],
	[4.5470000000E+04, 4.7074823455E+01, 5.4860656803E+00, 2.8581288561E+01, 4.1926841295E+00, 9.8099443646E-01],
	[4.5475000000E+04, 4.7084012612E+01, 5.4861136622E+00, 2.8591591043E+01, 4.1930066754E+00, 9.8100240608E-01],
	[4.5480000000E+04, 4.7093202552E+01, 5.4861616392E+00, 2.8601896104E+01, 4.1933291411E+00, 9.8101037186E-01],
	[4.5485000000E+04, 4.7102393275E+01, 5.4862096114E+00, 2.8612203745E+01, 4.1936515267E+00, 9.8101833379E-01],
	[4.5490000000E+04, 4.7111584781E+01, 5.4862575787E+00, 2.8622513965E+01, 4.1939738320E+00, 9.8102629189E-01],
	[4.5495000000E+04, 4.7120777070E+01, 5.4863055412E+00, 2.8632826765E+01, 4.1942960572E+00, 9.8103424616E-01],
	[4.5500000000E+04, 4.7129970143E+01, 5.4863534988E+00, 2.8643142146E+01, 4.1946182023E+00, 9.8104219659E-01],
	[4.5505000000E+04, 4.7139163998E+01, 5.4864014516E+00, 2.8653460108E+01, 4.1949402673E+00, 9.8105014319E-01],
	[4.5510000000E+04, 4.7148358636E+01, 5.4864493995E+00, 2.8663780650E+01, 4.1952622523E+00, 9.8105808596E-01],
	[4.5515000000E+04, 4.7157554058E+01, 5.4864973425E+00, 2.8674103774E+01, 4.1955841572E+00, 9.8106602490E-01],
	[4.5520000000E+04, 4.7166750262E+01, 5.4865452808E+00, 2.8684429480E+01, 4.1959059820E+00, 9.8107396002E-01],
	[4.5525000000E+04, 4.7175947249E+01, 5.4865932141E+00, 2.8694757769E+01, 4.1962277268E+00, 9.8108189131E-01],
	[4.5530000000E+04, 4.7185145020E+01, 5.4866411427E+00, 2.8705088640E+01, 4.1965493917E+00, 9.8108981879E-01],
	[4.5535000000E+04, 4.7194343573E+01, 5.4866890664E+00, 2.8715422093E+01, 4.1968709766E+00, 9.8109774244E-01],
	[4.5540000000E+04, 4.7203542909E+01, 5.4867369852E+00, 2.8725758130E+01, 4.1971924815E+00, 9.8110566228E-01],
	[4.5545000000E+04, 4.7212743029E+01, 5.4867848992E+00, 2.8736096751E+01, 4.1975139065E+00, 9.8111357830E-01],
	[4.5550000000E+04, 4.7221943931E+01, 5.4868328084E+00, 2.8746437956E+01, 4.1978352517E+00, 9.8112149050E-01],
	[4.5555000000E+04, 4.7231145616E+01, 5.4868807127E+00, 2.8756781745E+01, 4.1981565169E+00, 9.8112939890E-01],
	[4.5560000000E+04, 4.7240348083E+01, 5.4869286121E+00, 2.8767128119E+01, 4.1984777023E+00, 9.8113730349E-01],
	[4.5565000000E+04, 4.7249551334E+01, 5.4869765068E+00, 2.8777477078E+01, 4.1987988079E+00, 9.8114520427E-01],
	[4.5570000000E+04, 4.7258755367E+01, 5.4870243966E+00, 2.8787828623E+01, 4.1991198336E+00, 9.8115310124E-01],
	[4.5575000000E+04, 4.7267960183E+01, 5.4870722815E+00, 2.8798182753E+01, 4.1994407796E+00, 9.8116099441E-01],
	[4.5580000000E+04, 4.7277165782E+01, 5.4871201617E+00, 2.8808539470E+01, 4.1997616458E+00, 9.8116888378E-01],
	[4.5585000000E+04, 4.7286372164E+01, 5.4871680370E+00, 2.8818898773E+01, 4.2000824322E+00, 9.8117676935E-01],
	[4.5590000000E+04, 4.7295579329E+01, 5.4872159074E+00, 2.8829260663E+01, 4.2004031389E+00, 9.8118465112E-01],
	[4.5595000000E+04, 4.7304787276E+01, 5.4872637731E+00, 2.8839625140E+01, 4.2007237660E+00, 9.8119252909E-01],
	[4.5600000000E+04, 4.7313996006E+01, 5.4873116339E+00, 2.8849992205E+01, 4.2010443133E+00, 9.8120040327E-01],
	[4.5605000000E+04, 4.7323205518E+01, 5.4873594898E+00, 2.8860361858E+01, 4.2013647810E+00, 9.8120827366E-01],
	[4.5610000000E+04, 4.7332415813E+01, 5.4874073410E+00, 2.8870734100E+01, 4.2016851691E+00, 9.8121614026E-01],
	[4.5615000000E+04, 4.7341626891E+01, 5.4874551873E+00, 2.8881108930E+01, 4.2020054775E+00, 9.8122400308E-01],
	[4.5620000000E+04, 4.7350838752E+01, 5.4875030288E+00, 2.8891486349E+01, 4.2023257064E+00, 9.8123186210E-01],
	[4.5625000000E+04, 4.7360051395E+01, 5.4875508654E+00, 2.8901866358E+01, 4.2026458556E+00, 9.8123971735E-01],
	[4.5630000000E+04, 4.7369264820E+01, 5.4875986973E+00, 2.8912248956E+01, 4.2029659254E+00, 9.8124756881E-01],
	[4.5635000000E+04, 4.7378479029E+01, 5.4876465243E+00, 2.8922634145E+01, 4.2032859156E+00, 9.8125541649E-01],
	[4.5640000000E+04, 4.7387694019E+01, 5.4876943464E+00, 2.8933021924E+01, 4.2036058263E+00, 9.8126326039E-01],
	[4.5645000000E+04, 4.7396909793E+01, 5.4877421638E+00, 2.8943412295E+01, 4.2039256575E+00, 9.8127110052E-01],
	[4.5650000000E+04, 4.7406126348E+01, 5.4877899764E+00, 2.8953805256E+01, 4.2042454093E+00, 9.8127893687E-01],
	[4.5655000000E+04, 4.7415343687E+01, 5.4878377841E+00, 2.8964200809E+01, 4.2045650816E+00, 9.8128676945E-01],
	[4.5660000000E+04, 4.7424561807E+01, 5.4878855870E+00, 2.8974598954E+01, 4.2048846745E+00, 9.8129459826E-01],
	[4.5665000000E+04, 4.7433780711E+01, 5.4879333851E+00, 2.8984999691E+01, 4.2052041881E+00, 9.8130242331E-01],
	[4.5670000000E+04, 4.7443000396E+01, 5.4879811783E+00, 2.8995403022E+01, 4.2055236222E+00, 9.8131024458E-01],
	[4.5675000000E+04, 4.7452220864E+01, 5.4880289668E+00, 2.9005808945E+01, 4.2058429770E+00, 9.8131806210E-01],
	[4.5680000000E+04, 4.7461442115E+01, 5.4880767504E+00, 2.9016217461E+01, 4.2061622525E+00, 9.8132587585E-01],
	[4.5685000000E+04, 4.7470664147E+01, 5.4881245292E+00, 2.9026628572E+01, 4.2064814486E+00, 9.8133368584E-01],
	[4.5690000000E+04, 4.7479886962E+01, 5.4881723033E+00, 2.9037042276E+01, 4.2068005655E+00, 9.8134149207E-01],
	[4.5695000000E+04, 4.7489110560E+01, 5.4882200724E+00, 2.9047458576E+01, 4.2071196031E+00, 9.8134929454E-01],
	[4.5700000000E+04, 4.7498334940E+01, 5.4882678368E+00, 2.9057877470E+01, 4.2074385615E+00, 9.8135709327E-01],
	[4.5705000000E+04, 4.7507560102E+01, 5.4883155964E+00, 2.9068298959E+01, 4.2077574407E+00, 9.8136488823E-01],
	[4.5710000000E+04, 4.7516786046E+01, 5.4883633512E+00, 2.9078723044E+01, 4.2080762407E+00, 9.8137267945E-01],
	[4.5715000000E+04, 4.7526012772E+01, 5.4884111011E+00, 2.9089149724E+01, 4.2083949614E+00, 9.8138046692E-01],
	[4.5720000000E+04, 4.7535240281E+01, 5.4884588463E+00, 2.9099579002E+01, 4.2087136031E+00, 9.8138825065E-01],
	[4.5725000000E+04, 4.7544468572E+01, 5.4885065866E+00, 2.9110010875E+01, 4.2090321656E+00, 9.8139603063E-01],
	[4.5730000000E+04, 4.7553697645E+01, 5.4885543222E+00, 2.9120445346E+01, 4.2093506490E+00, 9.8140380686E-01],
	[4.5735000000E+04, 4.7562927501E+01, 5.4886020529E+00, 2.9130882415E+01, 4.2096690533E+00, 9.8141157936E-01],
	[4.5740000000E+04, 4.7572158138E+01, 5.4886497789E+00, 2.9141322081E+01, 4.2099873785E+00, 9.8141934812E-01],
	[4.5745000000E+04, 4.7581389558E+01, 5.4886975000E+00, 2.9151764345E+01, 4.2103056248E+00, 9.8142711314E-01],
	[4.5750000000E+04, 4.7590621760E+01, 5.4887452163E+00, 2.9162209208E+01, 4.2106237919E+00, 9.8143487442E-01],
	[4.5755000000E+04, 4.7599854744E+01, 5.4887929279E+00, 2.9172656670E+01, 4.2109418801E+00, 9.8144263197E-01],
	[4.5760000000E+04, 4.7609088510E+01, 5.4888406346E+00, 2.9183106730E+01, 4.2112598893E+00, 9.8145038580E-01],
	[4.5765000000E+04, 4.7618323058E+01, 5.4888883365E+00, 2.9193559391E+01, 4.2115778196E+00, 9.8145813589E-01],
	[4.5770000000E+04, 4.7627558388E+01, 5.4889360337E+00, 2.9204014651E+01, 4.2118956709E+00, 9.8146588226E-01],
	[4.5775000000E+04, 4.7636794500E+01, 5.4889837260E+00, 2.9214472512E+01, 4.2122134433E+00, 9.8147362490E-01],
	[4.5780000000E+04, 4.7646031394E+01, 5.4890314136E+00, 2.9224932973E+01, 4.2125311368E+00, 9.8148136382E-01],
	[4.5785000000E+04, 4.7655269070E+01, 5.4890790963E+00, 2.9235396036E+01, 4.2128487514E+00, 9.8148909901E-01],
	[4.5790000000E+04, 4.7664507528E+01, 5.4891267743E+00, 2.9245861700E+01, 4.2131662872E+00, 9.8149683049E-01],
	[4.5795000000E+04, 4.7673746768E+01, 5.4891744474E+00, 2.9256329965E+01, 4.2134837442E+00, 9.8150455825E-01],
	[4.5800000000E+04, 4.7682986790E+01, 5.4892221158E+00, 2.9266800833E+01, 4.2138011224E+00, 9.8151228230E-01],
	[4.5805000000E+04, 4.7692227594E+01, 5.4892697794E+00, 2.9277274303E+01, 4.2141184218E+00, 9.8152000263E-01],
	[4.5810000000E+04, 4.7701469179E+01, 5.4893174382E+00, 2.9287750376E+01, 4.2144356424E+00, 9.8152771925E-01],
	[4.5815000000E+04, 4.7710711547E+01, 5.4893650922E+00, 2.9298229053E+01, 4.2147527843E+00, 9.8153543216E-01],
	[4.5820000000E+04, 4.7719954696E+01, 5.4894127415E+00, 2.9308710333E+01, 4.2150698474E+00, 9.8154314137E-01],
	[4.5825000000E+04, 4.7729198628E+01, 5.4894603859E+00, 2.9319194216E+01, 4.2153868319E+00, 9.8155084687E-01],
	[4.5830000000E+04, 4.7738443341E+01, 5.4895080255E+00, 2.9329680704E+01, 4.2157037377E+00, 9.8155854866E-01],
	[4.5835000000E+04, 4.7747688836E+01, 5.4895556604E+00, 2.9340169797E+01, 4.2160205649E+00, 9.8156624676E-01],
	[4.5840000000E+04, 4.7756935112E+01, 5.4896032905E+00, 2.9350661495E+01, 4.2163373134E+00, 9.8157394115E-01],
	[4.5845000000E+04, 4.7766182171E+01, 5.4896509158E+00, 2.9361155798E+01, 4.2166539833E+00, 9.8158163185E-01],
	[4.5850000000E+04, 4.7775430011E+01, 5.4896985363E+00, 2.9371652707E+01, 4.2169705747E+00, 9.8158931885E-01],
	[4.5855000000E+04, 4.7784678633E+01, 5.4897461521E+00, 2.9382152222E+01, 4.2172870875E+00, 9.8159700216E-01],
	[4.5860000000E+04, 4.7793928036E+01, 5.4897937631E+00, 2.9392654344E+01, 4.2176035217E+00, 9.8160468177E-01],
	[4.5865000000E+04, 4.7803178221E+01, 5.4898413692E+00, 2.9403159072E+01, 4.2179198774E+00, 9.8161235770E-01],
	[4.5870000000E+04, 4.7812429188E+01, 5.4898889707E+00, 2.9413666407E+01, 4.2182361546E+00, 9.8162002994E-01],
	[4.5875000000E+04, 4.7821680937E+01, 5.4899365673E+00, 2.9424176351E+01, 4.2185523533E+00, 9.8162769849E-01],
	[4.5880000000E+04, 4.7830933467E+01, 5.4899841592E+00, 2.9434688902E+01, 4.2188684736E+00, 9.8163536336E-01],
	[4.5885000000E+04, 4.7840186779E+01, 5.4900317463E+00, 2.9445204061E+01, 4.2191845155E+00, 9.8164302454E-01],
	[4.5890000000E+04, 4.7849440872E+01, 5.4900793286E+00, 2.9455721829E+01, 4.2195004789E+00, 9.8165068205E-01],
	[4.5895000000E+04, 4.7858695747E+01, 5.4901269061E+00, 2.9466242206E+01, 4.2198163640E+00, 9.8165833587E-01],
	[4.5900000000E+04, 4.7867951403E+01, 5.4901744789E+00, 2.9476765192E+01, 4.2201321707E+00, 9.8166598602E-01],
	[4.5905000000E+04, 4.7877207841E+01, 5.4902220469E+00, 2.9487290788E+01, 4.2204478990E+00, 9.8167363250E-01],
	[4.5910000000E+04, 4.7886465060E+01, 5.4902696101E+00, 2.9497818994E+01, 4.2207635490E+00, 9.8168127530E-01],
	[4.5915000000E+04, 4.7895723061E+01, 5.4903171686E+00, 2.9508349811E+01, 4.2210791207E+00, 9.8168891444E-01],
	[4.5920000000E+04, 4.7904981844E+01, 5.4903647223E+00, 2.9518883238E+01, 4.2213946141E+00, 9.8169654990E-01],
	[4.5925000000E+04, 4.7914241408E+01, 5.4904122712E+00, 2.9529419277E+01, 4.2217100293E+00, 9.8170418170E-01],
	[4.5930000000E+04, 4.7923501753E+01, 5.4904598154E+00, 2.9539957927E+01, 4.2220253663E+00, 9.8171180984E-01],
	[4.5935000000E+04, 4.7932762879E+01, 5.4905073548E+00, 2.9550499189E+01, 4.2223406250E+00, 9.8171943431E-01],
	[4.5940000000E+04, 4.7942024788E+01, 5.4905548894E+00, 2.9561043063E+01, 4.2226558055E+00, 9.8172705512E-01],
	[4.5945000000E+04, 4.7951287477E+01, 5.4906024193E+00, 2.9571589550E+01, 4.2229709078E+00, 9.8173467227E-01],
	[4.5950000000E+04, 4.7960550948E+01, 5.4906499445E+00, 2.9582138650E+01, 4.2232859321E+00, 9.8174228576E-01],
	[4.5955000000E+04, 4.7969815200E+01, 5.4906974648E+00, 2.9592690364E+01, 4.2236008781E+00, 9.8174989560E-01],
	[4.5960000000E+04, 4.7979080233E+01, 5.4907449804E+00, 2.9603244691E+01, 4.2239157461E+00, 9.8175750179E-01],
	[4.5965000000E+04, 4.7988346048E+01, 5.4907924913E+00, 2.9613801632E+01, 4.2242305360E+00, 9.8176510432E-01],
	[4.5970000000E+04, 4.7997612644E+01, 5.4908399973E+00, 2.9624361187E+01, 4.2245452478E+00, 9.8177270321E-01],
	[4.5975000000E+04, 4.8006880021E+01, 5.4908874987E+00, 2.9634923358E+01, 4.2248598816E+00, 9.8178029845E-01],
	[4.5980000000E+04, 4.8016148180E+01, 5.4909349953E+00, 2.9645488143E+01, 4.2251744373E+00, 9.8178789004E-01],
	[4.5985000000E+04, 4.8025417119E+01, 5.4909824871E+00, 2.9656055544E+01, 4.2254889151E+00, 9.8179547799E-01],
	[4.5990000000E+04, 4.8034686840E+01, 5.4910299741E+00, 2.9666625561E+01, 4.2258033149E+00, 9.8180306230E-01],
	[4.5995000000E+04, 4.8043957342E+01, 5.4910774565E+00, 2.9677198195E+01, 4.2261176367E+00, 9.8181064297E-01],
	[4.6000000000E+04, 4.8053228626E+01, 5.4911249340E+00, 2.9687773444E+01, 4.2264318806E+00, 9.8181822000E-01],
	[4.6005000000E+04, 4.8062500690E+01, 5.4911724069E+00, 2.9698351311E+01, 4.2267460466E+00, 9.8182579340E-01],
	[4.6010000000E+04, 4.8071773535E+01, 5.4912198749E+00, 2.9708931795E+01, 4.2270601347E+00, 9.8183336316E-01],
	[4.6015000000E+04, 4.8081047162E+01, 5.4912673382E+00, 2.9719514897E+01, 4.2273741449E+00, 9.8184092929E-01],
	[4.6020000000E+04, 4.8090321570E+01, 5.4913147968E+00, 2.9730100617E+01, 4.2276880773E+00, 9.8184849179E-01],
	[4.6025000000E+04, 4.8099596758E+01, 5.4913622506E+00, 2.9740688956E+01, 4.2280019318E+00, 9.8185605066E-01],
	[4.6030000000E+04, 4.8108872728E+01, 5.4914096997E+00, 2.9751279913E+01, 4.2283157086E+00, 9.8186360591E-01],
	[4.6035000000E+04, 4.8118163452E+01, 5.4914585860E+00, 2.9761873489E+01, 4.2286303704E+00, 9.8187115753E-01],
	[4.6040000000E+04, 4.8127458981E+01, 5.4915078823E+00, 2.9772469685E+01, 4.2289452318E+00, 9.8187870553E-01],
	[4.6045000000E+04, 4.8136755297E+01, 5.4915571737E+00, 2.9783068501E+01, 4.2292600156E+00, 9.8188624991E-01],
	[4.6050000000E+04, 4.8146052399E+01, 5.4916064602E+00, 2.9793669937E+01, 4.2295747218E+00, 9.8189379067E-01],
	[4.6055000000E+04, 4.8155350286E+01, 5.4916557418E+00, 2.9804273993E+01, 4.2298893505E+00, 9.8190132781E-01],
	[4.6060000000E+04, 4.8164648960E+01, 5.4917050184E+00, 2.9814880671E+01, 4.2302039016E+00, 9.8190886134E-01],
	[4.6065000000E+04, 4.8173948419E+01, 5.4917542902E+00, 2.9825489970E+01, 4.2305183753E+00, 9.8191639126E-01],
	[4.6070000000E+04, 4.8183248665E+01, 5.4918035570E+00, 2.9836101890E+01, 4.2308327715E+00, 9.8192391757E-01],
	[4.6075000000E+04, 4.8192549696E+01, 5.4918528190E+00, 2.9846716433E+01, 4.2311470903E+00, 9.8193144027E-01],
	[4.6080000000E+04, 4.8201851513E+01, 5.4919020760E+00, 2.9857333598E+01, 4.2314613316E+00, 9.8193895936E-01],
	[4.6085000000E+04, 4.8211154116E+01, 5.4919513282E+00, 2.9867953386E+01, 4.2317754955E+00, 9.8194647485E-01],
	[4.6090000000E+04, 4.8220457504E+01, 5.4920005754E+00, 2.9878575797E+01, 4.2320895821E+00, 9.8195398673E-01],
	[4.6095000000E+04, 4.8229761679E+01, 5.4920498178E+00, 2.9889200831E+01, 4.2324035913E+00, 9.8196149501E-01],
	[4.6100000000E+04, 4.8239066639E+01, 5.4920990552E+00, 2.9899828490E+01, 4.2327175231E+00, 9.8196899969E-01],
	[4.6105000000E+04, 4.8248372385E+01, 5.4921482878E+00, 2.9910458772E+01, 4.2330313776E+00, 9.8197650078E-01],
	[4.6110000000E+04, 4.8257678916E+01, 5.4921975154E+00, 2.9921091679E+01, 4.2333451548E+00, 9.8198399827E-01],
	[4.6115000000E+04, 4.8266986234E+01, 5.4922467382E+00, 2.9931727212E+01, 4.2336588548E+00, 9.8199149217E-01],
	[4.6120000000E+04, 4.8276294337E+01, 5.4922959560E+00, 2.9942365369E+01, 4.2339724775E+00, 9.8199898247E-01],
	[4.6125000000E+04, 4.8285603226E+01, 5.4923451690E+00, 2.9953006152E+01, 4.2342860229E+00, 9.8200646919E-01],
	[4.6130000000E+04, 4.8294912900E+01, 5.4923943771E+00, 2.9963649562E+01, 4.2345994912E+00, 9.8201395232E-01],
	[4.6135000000E+04, 4.8304223360E+01, 5.4924435802E+00, 2.9974295597E+01, 4.2349128822E+00, 9.8202143186E-01],
	[4.6140000000E+04, 4.8313534606E+01, 5.4924927785E+00, 2.9984944260E+01, 4.2352261961E+00, 9.8202890782E-01],
	[4.6145000000E+04, 4.8322846637E+01, 5.4925419719E+00, 2.9995595549E+01, 4.2355394328E+00, 9.8203638019E-01],
	[4.6150000000E+04, 4.8332159454E+01, 5.4925911604E+00, 3.0006249466E+01, 4.2358525924E+00, 9.8204384899E-01],
	[4.6155000000E+04, 4.8341473057E+01, 5.4926403440E+00, 3.0016906011E+01, 4.2361656749E+00, 9.8205131421E-01],
	[4.6160000000E+04, 4.8350787445E+01, 5.4926895227E+00, 3.0027565184E+01, 4.2364786803E+00, 9.8205877585E-01],
	[4.6165000000E+04, 4.8360102618E+01, 5.4927386966E+00, 3.0038226986E+01, 4.2367916087E+00, 9.8206623392E-01],
	[4.6170000000E+04, 4.8369418577E+01, 5.4927878655E+00, 3.0048891417E+01, 4.2371044600E+00, 9.8207368841E-01],
	[4.6175000000E+04, 4.8378735322E+01, 5.4928370296E+00, 3.0059558477E+01, 4.2374172343E+00, 9.8208113934E-01],
	[4.6180000000E+04, 4.8388052852E+01, 5.4928861888E+00, 3.0070228166E+01, 4.2377299316E+00, 9.8208858669E-01],
	[4.6185000000E+04, 4.8397371167E+01, 5.4929353431E+00, 3.0080900486E+01, 4.2380425519E+00, 9.8209603048E-01],
	[4.6190000000E+04, 4.8406690268E+01, 5.4929844925E+00, 3.0091575436E+01, 4.2383550953E+00, 9.8210347071E-01],
	[4.6195000000E+04, 4.8416010154E+01, 5.4930336371E+00, 3.0102253017E+01, 4.2386675617E+00, 9.8211090737E-01],
	[4.6200000000E+04, 4.8425330826E+01, 5.4930827767E+00, 3.0112933229E+01, 4.2389799512E+00, 9.8211834047E-01],
	[4.6205000000E+04, 4.8434652283E+01, 5.4931319115E+00, 3.0123616073E+01, 4.2392922638E+00, 9.8212577001E-01],
	[4.6210000000E+04, 4.8443974525E+01, 5.4931810414E+00, 3.0134301548E+01, 4.2396044996E+00, 9.8213319599E-01],
	[4.6215000000E+04, 4.8453297553E+01, 5.4932301665E+00, 3.0144989656E+01, 4.2399166585E+00, 9.8214061842E-01],
	[4.6220000000E+04, 4.8462621366E+01, 5.4932792866E+00, 3.0155680396E+01, 4.2402287406E+00, 9.8214803730E-01],
	[4.6225000000E+04, 4.8471945964E+01, 5.4933284019E+00, 3.0166373769E+01, 4.2405407458E+00, 9.8215545262E-01],
	[4.6230000000E+04, 4.8481271348E+01, 5.4933775123E+00, 3.0177069775E+01, 4.2408526743E+00, 9.8216286440E-01],
	[4.6235000000E+04, 4.8490597517E+01, 5.4934266179E+00, 3.0187768415E+01, 4.2411645261E+00, 9.8217027262E-01],
	[4.6240000000E+04, 4.8499924471E+01, 5.4934757185E+00, 3.0198469689E+01, 4.2414763010E+00, 9.8217767730E-01],
	[4.6245000000E+04, 4.8509252210E+01, 5.4935248143E+00, 3.0209173598E+01, 4.2417879993E+00, 9.8218507844E-01],
	[4.6250000000E+04, 4.8518580735E+01, 5.4935739052E+00, 3.0219880141E+01, 4.2420996209E+00, 9.8219247604E-01],
	[4.6255000000E+04, 4.8527910045E+01, 5.4936229913E+00, 3.0230589320E+01, 4.2424111658E+00, 9.8219987009E-01],
	[4.6260000000E+04, 4.8537240140E+01, 5.4936720725E+00, 3.0241301133E+01, 4.2427226340E+00, 9.8220726061E-01],
	[4.6265000000E+04, 4.8546571020E+01, 5.4937211488E+00, 3.0252015583E+01, 4.2430340256E+00, 9.8221464759E-01],
	[4.6270000000E+04, 4.8555902685E+01, 5.4937702203E+00, 3.0262732669E+01, 4.2433453406E+00, 9.8222203103E-01],
	[4.6275000000E+04, 4.8565235135E+01, 5.4938192869E+00, 3.0273452392E+01, 4.2436565790E+00, 9.8222941095E-01],
	[4.6280000000E+04, 4.8574568371E+01, 5.4938683486E+00, 3.0284174751E+01, 4.2439677408E+00, 9.8223678733E-01],
	[4.6285000000E+04, 4.8583902391E+01, 5.4939174055E+00, 3.0294899748E+01, 4.2442788260E+00, 9.8224416018E-01],
	[4.6290000000E+04, 4.8593237197E+01, 5.4939664575E+00, 3.0305627382E+01, 4.2445898348E+00, 9.8225152951E-01],
	[4.6295000000E+04, 4.8602572787E+01, 5.4940155046E+00, 3.0316357655E+01, 4.2449007670E+00, 9.8225889531E-01],
	[4.6300000000E+04, 4.8611909163E+01, 5.4940645469E+00, 3.0327090566E+01, 4.2452116228E+00, 9.8226625759E-01],
	[4.6305000000E+04, 4.8621246324E+01, 5.4941135843E+00, 3.0337826115E+01, 4.2455224021E+00, 9.8227361635E-01],
	[4.6310000000E+04, 4.8630584269E+01, 5.4941626169E+00, 3.0348564304E+01, 4.2458331049E+00, 9.8228097159E-01],
	[4.6315000000E+04, 4.8639923000E+01, 5.4942116446E+00, 3.0359305132E+01, 4.2461437313E+00, 9.8228832331E-01],
	[4.6320000000E+04, 4.8649262515E+01, 5.4942606675E+00, 3.0370048600E+01, 4.2464542813E+00, 9.8229567151E-01],
	[4.6325000000E+04, 4.8658602816E+01, 5.4943096855E+00, 3.0380794708E+01, 4.2467647550E+00, 9.8230301620E-01],
	[4.6330000000E+04, 4.8667943901E+01, 5.4943586987E+00, 3.0391543457E+01, 4.2470751523E+00, 9.8231035738E-01],
	[4.6335000000E+04, 4.8677285771E+01, 5.4944077070E+00, 3.0402294847E+01, 4.2473854732E+00, 9.8231769505E-01],
	[4.6340000000E+04, 4.8686628426E+01, 5.4944567104E+00, 3.0413048878E+01, 4.2476957178E+00, 9.8232502922E-01],
	[4.6345000000E+04, 4.8695971866E+01, 5.4945057090E+00, 3.0423805551E+01, 4.2480058862E+00, 9.8233235987E-01],
	[4.6350000000E+04, 4.8705316091E+01, 5.4945547028E+00, 3.0434564865E+01, 4.2483159782E+00, 9.8233968702E-01],
	[4.6355000000E+04, 4.8714661100E+01, 5.4946036917E+00, 3.0445326823E+01, 4.2486259941E+00, 9.8234701067E-01],
	[4.6360000000E+04, 4.8724006895E+01, 5.4946526757E+00, 3.0456091422E+01, 4.2489359336E+00, 9.8235433082E-01],
	[4.6365000000E+04, 4.8733353474E+01, 5.4947016550E+00, 3.0466858665E+01, 4.2492457970E+00, 9.8236164747E-01],
	[4.6370000000E+04, 4.8742700838E+01, 5.4947506293E+00, 3.0477628552E+01, 4.2495555842E+00, 9.8236896062E-01],
	[4.6375000000E+04, 4.8752048986E+01, 5.4947995988E+00, 3.0488401082E+01, 4.2498652952E+00, 9.8237627028E-01],
	[4.6380000000E+04, 4.8761397920E+01, 5.4948485635E+00, 3.0499176257E+01, 4.2501749301E+00, 9.8238357645E-01],
	[4.6385000000E+04, 4.8770747638E+01, 5.4948975234E+00, 3.0509954076E+01, 4.2504844889E+00, 9.8239087912E-01],
	[4.6390000000E+04, 4.8780098141E+01, 5.4949464784E+00, 3.0520734540E+01, 4.2507939715E+00, 9.8239817831E-01],
	[4.6395000000E+04, 4.8789449428E+01, 5.4949954285E+00, 3.0531517649E+01, 4.2511033781E+00, 9.8240547401E-01],
	[4.6400000000E+04, 4.8798801500E+01, 5.4950443738E+00, 3.0542303404E+01, 4.2514127086E+00, 9.8241276622E-01],
	[4.6405000000E+04, 4.8808154357E+01, 5.4950933143E+00, 3.0553091805E+01, 4.2517219631E+00, 9.8242005495E-01],
	[4.6410000000E+04, 4.8817507998E+01, 5.4951422499E+00, 3.0563882852E+01, 4.2520311415E+00, 9.8242734019E-01],
	[4.6415000000E+04, 4.8826862424E+01, 5.4951911808E+00, 3.0574676546E+01, 4.2523402440E+00, 9.8243462196E-01],
	[4.6420000000E+04, 4.8836217634E+01, 5.4952401067E+00, 3.0585472888E+01, 4.2526492705E+00, 9.8244190025E-01],
	[4.6425000000E+04, 4.8845573629E+01, 5.4952890279E+00, 3.0596271876E+01, 4.2529582210E+00, 9.8244917506E-01],
	[4.6430000000E+04, 4.8854930409E+01, 5.4953379442E+00, 3.0607073513E+01, 4.2532670956E+00, 9.8245644640E-01],
	[4.6435000000E+04, 4.8864287973E+01, 5.4953868556E+00, 3.0617877797E+01, 4.2535758943E+00, 9.8246371427E-01],
	[4.6440000000E+04, 4.8873646321E+01, 5.4954357623E+00, 3.0628684731E+01, 4.2538846171E+00, 9.8247097867E-01],
	[4.6445000000E+04, 4.8883005454E+01, 5.4954846641E+00, 3.0639494313E+01, 4.2541932640E+00, 9.8247823959E-01],
	[4.6450000000E+04, 4.8892365371E+01, 5.4955335611E+00, 3.0650306544E+01, 4.2545018351E+00, 9.8248549706E-01],
	[4.6455000000E+04, 4.8901726073E+01, 5.4955824532E+00, 3.0661121426E+01, 4.2548103303E+00, 9.8249275105E-01],
	[4.6460000000E+04, 4.8911087560E+01, 5.4956313405E+00, 3.0671938957E+01, 4.2551187498E+00, 9.8250000158E-01],
	[4.6465000000E+04, 4.8920449830E+01, 5.4956802230E+00, 3.0682759138E+01, 4.2554270934E+00, 9.8250724866E-01],
	[4.6470000000E+04, 4.8929812885E+01, 5.4957291007E+00, 3.0693581971E+01, 4.2557353613E+00, 9.8251449227E-01],
	[4.6475000000E+04, 4.8939176725E+01, 5.4957779736E+00, 3.0704407454E+01, 4.2560435535E+00, 9.8252173242E-01],
	[4.6480000000E+04, 4.8948541349E+01, 5.4958268416E+00, 3.0715235589E+01, 4.2563516699E+00, 9.8252896912E-01],
	[4.6485000000E+04, 4.8957906757E+01, 5.4958757048E+00, 3.0726066376E+01, 4.2566597107E+00, 9.8253620237E-01],
	[4.6490000000E+04, 4.8967272949E+01, 5.4959245632E+00, 3.0736899815E+01, 4.2569676757E+00, 9.8254343216E-01],
	[4.6495000000E+04, 4.8976639926E+01, 5.4959734167E+00, 3.0747735906E+01, 4.2572755651E+00, 9.8255065851E-01],
	[4.6500000000E+04, 4.8986007687E+01, 5.4960222655E+00, 3.0758574650E+01, 4.2575833789E+00, 9.8255788141E-01],
	[4.6505000000E+04, 4.8995376232E+01, 5.4960711094E+00, 3.0769416048E+01, 4.2578911170E+00, 9.8256510086E-01],
	[4.6510000000E+04, 4.9004745561E+01, 5.4961199485E+00, 3.0780260100E+01, 4.2581987796E+00, 9.8257231686E-01],
	[4.6515000000E+04, 4.9014115675E+01, 5.4961687828E+00, 3.0791106805E+01, 4.2585063666E+00, 9.8257952942E-01],
	[4.6520000000E+04, 4.9023486573E+01, 5.4962176123E+00, 3.0801956165E+01, 4.2588138780E+00, 9.8258673855E-01],
	[4.6525000000E+04, 4.9032858255E+01, 5.4962664370E+00, 3.0812808179E+01, 4.2591213139E+00, 9.8259394423E-01],
	[4.6530000000E+04, 4.9042230721E+01, 5.4963152568E+00, 3.0823662849E+01, 4.2594286743E+00, 9.8260114648E-01],
	[4.6535000000E+04, 4.9051603971E+01, 5.4963640719E+00, 3.0834520174E+01, 4.2597359592E+00, 9.8260834529E-01],
	[4.6540000000E+04, 4.9060978006E+01, 5.4964128821E+00, 3.0845380155E+01, 4.2600431686E+00, 9.8261554067E-01],
	[4.6545000000E+04, 4.9070352824E+01, 5.4964616875E+00, 3.0856242792E+01, 4.2603503026E+00, 9.8262273261E-01],
	[4.6550000000E+04, 4.9079728427E+01, 5.4965104881E+00, 3.0867108086E+01, 4.2606573612E+00, 9.8262992113E-01],
	[4.6555000000E+04, 4.9089104814E+01, 5.4965592839E+00, 3.0877976036E+01, 4.2609643444E+00, 9.8263710622E-01],
	[4.6560000000E+04, 4.9098481984E+01, 5.4966080749E+00, 3.0888846644E+01, 4.2612712522E+00, 9.8264428789E-01],
	[4.6565000000E+04, 4.9107859939E+01, 5.4966568611E+00, 3.0899719910E+01, 4.2615780846E+00, 9.8265146613E-01],
	[4.6570000000E+04, 4.9117238678E+01, 5.4967056425E+00, 3.0910595833E+01, 4.2618848417E+00, 9.8265864095E-01],
	[4.6575000000E+04, 4.9126618201E+01, 5.4967544190E+00, 3.0921474415E+01, 4.2621915234E+00, 9.8266581234E-01],
	[4.6580000000E+04, 4.9135998508E+01, 5.4968031908E+00, 3.0932355656E+01, 4.2624981299E+00, 9.8267298032E-01],
	[4.6585000000E+04, 4.9145379598E+01, 5.4968519578E+00, 3.0943239556E+01, 4.2628046611E+00, 9.8268014489E-01],
	[4.6590000000E+04, 4.9154761473E+01, 5.4969007199E+00, 3.0954126115E+01, 4.2631111170E+00, 9.8268730603E-01],
	[4.6595000000E+04, 4.9164144131E+01, 5.4969494773E+00, 3.0965015334E+01, 4.2634174977E+00, 9.8269446377E-01],
	[4.6600000000E+04, 4.9173527574E+01, 5.4969982299E+00, 3.0975907213E+01, 4.2637238032E+00, 9.8270161809E-01],
	[4.6605000000E+04, 4.9182911800E+01, 5.4970469777E+00, 3.0986801753E+01, 4.2640300335E+00, 9.8270876901E-01],
	[4.6610000000E+04, 4.9192296810E+01, 5.4970957206E+00, 3.0997698954E+01, 4.2643361886E+00, 9.8271591652E-01],
	[4.6615000000E+04, 4.9201682604E+01, 5.4971444588E+00, 3.1008598816E+01, 4.2646422686E+00, 9.8272306062E-01],
	[4.6620000000E+04, 4.9211069182E+01, 5.4971931922E+00, 3.1019501340E+01, 4.2649482734E+00, 9.8273020132E-01],
	[4.6625000000E+04, 4.9220456544E+01, 5.4972419208E+00, 3.1030406526E+01, 4.2652542031E+00, 9.8273733862E-01],
	[4.6630000000E+04, 4.9229844689E+01, 5.4972906446E+00, 3.1041314374E+01, 4.2655600578E+00, 9.8274447251E-01],
	[4.6635000000E+04, 4.9239233618E+01, 5.4973393636E+00, 3.1052224885E+01, 4.2658658374E+00, 9.8275160301E-01],
	[4.6640000000E+04, 4.9248623331E+01, 5.4973880778E+00, 3.1063138059E+01, 4.2661715419E+00, 9.8275873012E-01],
	[4.6645000000E+04, 4.9258013828E+01, 5.4974367872E+00, 3.1074053896E+01, 4.2664771714E+00, 9.8276585382E-01],
	[4.6650000000E+04, 4.9267405108E+01, 5.4974854918E+00, 3.1084972398E+01, 4.2667827259E+00, 9.8277297414E-01],
	[4.6655000000E+04, 4.9276797172E+01, 5.4975341917E+00, 3.1095893563E+01, 4.2670882054E+00, 9.8278009107E-01],
	[4.6660000000E+04, 4.9286190020E+01, 5.4975828867E+00, 3.1106817393E+01, 4.2673936100E+00, 9.8278720460E-01],
	[4.6665000000E+04, 4.9295583651E+01, 5.4976315770E+00, 3.1117743888E+01, 4.2676989396E+00, 9.8279431475E-01],
	[4.6670000000E+04, 4.9304978066E+01, 5.4976802625E+00, 3.1128673049E+01, 4.2680041943E+00, 9.8280142152E-01],
	[4.6675000000E+04, 4.9314373265E+01, 5.4977289432E+00, 3.1139604875E+01, 4.2683093741E+00, 9.8280852490E-01],
	[4.6680000000E+04, 4.9323769247E+01, 5.4977776191E+00, 3.1150539367E+01, 4.2686144791E+00, 9.8281562490E-01],
	[4.6685000000E+04, 4.9333166013E+01, 5.4978262902E+00, 3.1161476525E+01, 4.2689195091E+00, 9.8282272152E-01],
	[4.6690000000E+04, 4.9342563562E+01, 5.4978749566E+00, 3.1172416350E+01, 4.2692244644E+00, 9.8282981476E-01],
	[4.6695000000E+04, 4.9351961895E+01, 5.4979236181E+00, 3.1183358842E+01, 4.2695293448E+00, 9.8283690462E-01],
	[4.6700000000E+04, 4.9361361012E+01, 5.4979722749E+00, 3.1194304002E+01, 4.2698341504E+00, 9.8284399112E-01],
	[4.6705000000E+04, 4.9370760912E+01, 5.4980209269E+00, 3.1205251830E+01, 4.2701388813E+00, 9.8285107423E-01],
	[4.6710000000E+04, 4.9380161595E+01, 5.4980695742E+00, 3.1216202326E+01, 4.2704435374E+00, 9.8285815398E-01],
	[4.6715000000E+04, 4.9389563062E+01, 5.4981182166E+00, 3.1227155490E+01, 4.2707481188E+00, 9.8286523036E-01],
	[4.6720000000E+04, 4.9398965312E+01, 5.4981668543E+00, 3.1238111323E+01, 4.2710526255E+00, 9.8287230338E-01],
	[4.6725000000E+04, 4.9408368346E+01, 5.4982154872E+00, 3.1249069826E+01, 4.2713570575E+00, 9.8287937302E-01],
	[4.6730000000E+04, 4.9417772163E+01, 5.4982641154E+00, 3.1260030998E+01, 4.2716614148E+00, 9.8288643931E-01],
	[4.6735000000E+04, 4.9427176764E+01, 5.4983127387E+00, 3.1270994840E+01, 4.2719656974E+00, 9.8289350223E-01],
	[4.6740000000E+04, 4.9436582148E+01, 5.4983613573E+00, 3.1281961353E+01, 4.2722699055E+00, 9.8290056180E-01],
	[4.6745000000E+04, 4.9445988315E+01, 5.4984099711E+00, 3.1292930537E+01, 4.2725740389E+00, 9.8290761800E-01],
	[4.6750000000E+04, 4.9455395266E+01, 5.4984585802E+00, 3.1303902391E+01, 4.2728780978E+00, 9.8291467085E-01],
	[4.6755000000E+04, 4.9464803000E+01, 5.4985071844E+00, 3.1314876917E+01, 4.2731820821E+00, 9.8292172035E-01],
	[4.6760000000E+04, 4.9474211517E+01, 5.4985557840E+00, 3.1325854115E+01, 4.2734859919E+00, 9.8292876649E-01],
	[4.6765000000E+04, 4.9483620818E+01, 5.4986043787E+00, 3.1336833985E+01, 4.2737898271E+00, 9.8293580929E-01],
	[4.6770000000E+04, 4.9493030902E+01, 5.4986529687E+00, 3.1347816528E+01, 4.2740935878E+00, 9.8294284873E-01],
	[4.6775000000E+04, 4.9502452004E+01, 5.4987025885E+00, 3.1358801744E+01, 4.2743979756E+00, 9.8294988483E-01],
	[4.6780000000E+04, 4.9511881650E+01, 5.4987529874E+00, 3.1369789632E+01, 4.2747028206E+00, 9.8295691758E-01],
	[4.6785000000E+04, 4.9521312084E+01, 5.4988033815E+00, 3.1380780195E+01, 4.2750075913E+00, 9.8296394699E-01],
	[4.6790000000E+04, 4.9530743306E+01, 5.4988537706E+00, 3.1391773432E+01, 4.2753122877E+00, 9.8297097306E-01],
	[4.6795000000E+04, 4.9540175316E+01, 5.4989041547E+00, 3.1402769343E+01, 4.2756169099E+00, 9.8297799579E-01],
	[4.6800000000E+04, 4.9549608115E+01, 5.4989545340E+00, 3.1413767929E+01, 4.2759214579E+00, 9.8298501518E-01],
	[4.6805000000E+04, 4.9559041701E+01, 5.4990049084E+00, 3.1424769189E+01, 4.2762259317E+00, 9.8299203124E-01],
	[4.6810000000E+04, 4.9568476076E+01, 5.4990552778E+00, 3.1435773126E+01, 4.2765303313E+00, 9.8299904396E-01],
	[4.6815000000E+04, 4.9577911238E+01, 5.4991056423E+00, 3.1446779738E+01, 4.2768346567E+00, 9.8300605335E-01],
	[4.6820000000E+04, 4.9587347189E+01, 5.4991560019E+00, 3.1457789027E+01, 4.2771389080E+00, 9.8301305941E-01],
	[4.6825000000E+04, 4.9596783927E+01, 5.4992063566E+00, 3.1468800992E+01, 4.2774430852E+00, 9.8302006214E-01],
	[4.6830000000E+04, 4.9606221454E+01, 5.4992567063E+00, 3.1479815634E+01, 4.2777471882E+00, 9.8302706155E-01],
	[4.6835000000E+04, 4.9615659768E+01, 5.4993070511E+00, 3.1490832953E+01, 4.2780512172E+00, 9.8303405762E-01],
	[4.6840000000E+04, 4.9625098871E+01, 5.4993573911E+00, 3.1501852950E+01, 4.2783551721E+00, 9.8304105038E-01],
	[4.6845000000E+04, 4.9634538761E+01, 5.4994077261E+00, 3.1512875625E+01, 4.2786590530E+00, 9.8304803981E-01],
	[4.6850000000E+04, 4.9643979439E+01, 5.4994580562E+00, 3.1523900979E+01, 4.2789628599E+00, 9.8305502593E-01],
	[4.6855000000E+04, 4.9653420905E+01, 5.4995083814E+00, 3.1534929011E+01, 4.2792665927E+00, 9.8306200873E-01],
	[4.6860000000E+04, 4.9662863159E+01, 5.4995587017E+00, 3.1545959722E+01, 4.2795702516E+00, 9.8306898821E-01],
	[4.6865000000E+04, 4.9672306201E+01, 5.4996090171E+00, 3.1556993113E+01, 4.2798738366E+00, 9.8307596437E-01],
	[4.6870000000E+04, 4.9681750030E+01, 5.4996593275E+00, 3.1568029184E+01, 4.2801773476E+00, 9.8308293723E-01],
	[4.6875000000E+04, 4.9691194648E+01, 5.4997096331E+00, 3.1579067935E+01, 4.2804807846E+00, 9.8308990677E-01],
	[4.6880000000E+04, 4.9700640053E+01, 5.4997599337E+00, 3.1590109366E+01, 4.2807841478E+00, 9.8309687301E-01],
	[4.6885000000E+04, 4.9710086246E+01, 5.4998102295E+00, 3.1601153479E+01, 4.2810874372E+00, 9.8310383594E-01],
	[4.6890000000E+04, 4.9719533226E+01, 5.4998605203E+00, 3.1612200273E+01, 4.2813906526E+00, 9.8311079556E-01],
	[4.6895000000E+04, 4.9728980995E+01, 5.4999108063E+00, 3.1623249748E+01, 4.2816937943E+00, 9.8311775188E-01],
	[4.6900000000E+04, 4.9738429551E+01, 5.4999610873E+00, 3.1634301906E+01, 4.2819968621E+00, 9.8312470490E-01],
	[4.6905000000E+04, 4.9747878895E+01, 5.5000113635E+00, 3.1645356746E+01, 4.2822998561E+00, 9.8313165462E-01],
	[4.6910000000E+04, 4.9757329026E+01, 5.5000616347E+00, 3.1656414268E+01, 4.2826027764E+00, 9.8313860104E-01],
	[4.6915000000E+04, 4.9766779945E+01, 5.5001119011E+00, 3.1667474474E+01, 4.2829056229E+00, 9.8314554417E-01],
	[4.6920000000E+04, 4.9776231652E+01, 5.5001621625E+00, 3.1678537364E+01, 4.2832083957E+00, 9.8315248400E-01],
	[4.6925000000E+04, 4.9785684146E+01, 5.5002124191E+00, 3.1689602937E+01, 4.2835110948E+00, 9.8315942054E-01],
	[4.6930000000E+04, 4.9795137428E+01, 5.5002626707E+00, 3.1700671194E+01, 4.2838137202E+00, 9.8316635379E-01],
	[4.6935000000E+04, 4.9804591498E+01, 5.5003129175E+00, 3.1711742136E+01, 4.2841162720E+00, 9.8317328374E-01],
	[4.6940000000E+04, 4.9814046355E+01, 5.5003631593E+00, 3.1722815763E+01, 4.2844187500E+00, 9.8318021042E-01],
	[4.6945000000E+04, 4.9823502000E+01, 5.5004133963E+00, 3.1733892076E+01, 4.2847211545E+00, 9.8318713380E-01],
	[4.6950000000E+04, 4.9832958432E+01, 5.5004636284E+00, 3.1744971074E+01, 4.2850234854E+00, 9.8319405391E-01],
	[4.6955000000E+04, 4.9842415652E+01, 5.5005138556E+00, 3.1756052758E+01, 4.2853257427E+00, 9.8320097073E-01],
	[4.6960000000E+04, 4.9851873659E+01, 5.5005640779E+00, 3.1767137129E+01, 4.2856279264E+00, 9.8320788427E-01],
	[4.6965000000E+04, 4.9861332454E+01, 5.5006142953E+00, 3.1778224186E+01, 4.2859300366E+00, 9.8321479453E-01],
	[4.6970000000E+04, 4.9870792036E+01, 5.5006645078E+00, 3.1789313930E+01, 4.2862320732E+00, 9.8322170152E-01],
	[4.6975000000E+04, 4.9880252405E+01, 5.5007147155E+00, 3.1800406362E+01, 4.2865340364E+00, 9.8322860524E-01],
	[4.6980000000E+04, 4.9889713562E+01, 5.5007649182E+00, 3.1811501482E+01, 4.2868359260E+00, 9.8323550568E-01],
	[4.6985000000E+04, 4.9899175507E+01, 5.5008151161E+00, 3.1822599291E+01, 4.2871377423E+00, 9.8324240284E-01],
	[4.6990000000E+04, 4.9908638238E+01, 5.5008653091E+00, 3.1833699787E+01, 4.2874394850E+00, 9.8324929675E-01],
	[4.6995000000E+04, 4.9918101758E+01, 5.5009154972E+00, 3.1844802973E+01, 4.2877411544E+00, 9.8325618738E-01],
	[4.7000000000E+04, 4.9927566064E+01, 5.5009656804E+00, 3.1855908848E+01, 4.2880427504E+00, 9.8326307475E-01],
	[4.7005000000E+04, 4.9937031158E+01, 5.5010158587E+00, 3.1867017413E+01, 4.2883442730E+00, 9.8326995885E-01],
	[4.7010000000E+04, 4.9946497039E+01, 5.5010660322E+00, 3.1878128668E+01, 4.2886457222E+00, 9.8327683969E-01],
	[4.7015000000E+04, 4.9955963707E+01, 5.5011162008E+00, 3.1889242613E+01, 4.2889470981E+00, 9.8328371727E-01],
	[4.7020000000E+04, 4.9965431163E+01, 5.5011663645E+00, 3.1900359249E+01, 4.2892484007E+00, 9.8329059160E-01],
	[4.7025000000E+04, 4.9974899406E+01, 5.5012165233E+00, 3.1911478576E+01, 4.2895496300E+00, 9.8329746266E-01],
	[4.7030000000E+04, 4.9984368436E+01, 5.5012666773E+00, 3.1922600595E+01, 4.2898507860E+00, 9.8330433047E-01],
	[4.7035000000E+04, 4.9993838254E+01, 5.5013168264E+00, 3.1933725306E+01, 4.2901518688E+00, 9.8331119503E-01],
	[4.7040000000E+04, 5.0003308858E+01, 5.5013669706E+00, 3.1944852709E+01, 4.2904528783E+00, 9.8331805634E-01],
	[4.7045000000E+04, 5.0012780250E+01, 5.5014171099E+00, 3.1955982804E+01, 4.2907538146E+00, 9.8332491440E-01],
	[4.7050000000E+04, 5.0022252429E+01, 5.5014672443E+00, 3.1967115593E+01, 4.2910546778E+00, 9.8333176921E-01],
	[4.7055000000E+04, 5.0031725395E+01, 5.5015173739E+00, 3.1978251075E+01, 4.2913554677E+00, 9.8333862077E-01],
	[4.7060000000E+04, 5.0041199148E+01, 5.5015674987E+00, 3.1989389250E+01, 4.2916561845E+00, 9.8334546909E-01],
	[4.7065000000E+04, 5.0050673688E+01, 5.5016176185E+00, 3.2000530120E+01, 4.2919568282E+00, 9.8335231417E-01],
	[4.7070000000E+04, 5.0060149016E+01, 5.5016677335E+00, 3.2011673684E+01, 4.2922573988E+00, 9.8335915601E-01],
	[4.7075000000E+04, 5.0069625130E+01, 5.5017178436E+00, 3.2022819943E+01, 4.2925578963E+00, 9.8336599461E-01],
	[4.7080000000E+04, 5.0079102032E+01, 5.5017679489E+00, 3.2033968897E+01, 4.2928583207E+00, 9.8337282997E-01],
	[4.7085000000E+04, 5.0088579720E+01, 5.5018180492E+00, 3.2045120547E+01, 4.2931586721E+00, 9.8337966209E-01],
	[4.7090000000E+04, 5.0098058196E+01, 5.5018681448E+00, 3.2056274892E+01, 4.2934589505E+00, 9.8338649099E-01],
	[4.7095000000E+04, 5.0107537459E+01, 5.5019182354E+00, 3.2067431934E+01, 4.2937591558E+00, 9.8339331665E-01],
	[4.7100000000E+04, 5.0117017508E+01, 5.5019683212E+00, 3.2078591673E+01, 4.2940592882E+00, 9.8340013908E-01],
	[4.7105000000E+04, 5.0126498345E+01, 5.5020184022E+00, 3.2089754108E+01, 4.2943593476E+00, 9.8340695828E-01],
	[4.7110000000E+04, 5.0135979968E+01, 5.5020684782E+00, 3.2100919241E+01, 4.2946593340E+00, 9.8341377426E-01],
	[4.7115000000E+04, 5.0145462379E+01, 5.5021185495E+00, 3.2112087072E+01, 4.2949592475E+00, 9.8342058701E-01],
	[4.7120000000E+04, 5.0154945576E+01, 5.5021686158E+00, 3.2123257600E+01, 4.2952590882E+00, 9.8342739654E-01],
	[4.7125000000E+04, 5.0164429560E+01, 5.5022186773E+00, 3.2134430827E+01, 4.2955588559E+00, 9.8343420285E-01],
	[4.7130000000E+04, 5.0173914331E+01, 5.5022687340E+00, 3.2145606753E+01, 4.2958585508E+00, 9.8344100594E-01],
	[4.7135000000E+04, 5.0183399889E+01, 5.5023187858E+00, 3.2156785378E+01, 4.2961581728E+00, 9.8344780581E-01],
	[4.7140000000E+04, 5.0192886234E+01, 5.5023688327E+00, 3.2167966703E+01, 4.2964577221E+00, 9.8345460246E-01],
	[4.7145000000E+04, 5.0202373365E+01, 5.5024188748E+00, 3.2179150728E+01, 4.2967571985E+00, 9.8346139591E-01],
	[4.7150000000E+04, 5.0211861284E+01, 5.5024689120E+00, 3.2190337453E+01, 4.2970566021E+00, 9.8346818613E-01],
	[4.7155000000E+04, 5.0221349989E+01, 5.5025189444E+00, 3.2201526878E+01, 4.2973559330E+00, 9.8347497315E-01],
	[4.7160000000E+04, 5.0230839481E+01, 5.5025689719E+00, 3.2212719005E+01, 4.2976551912E+00, 9.8348175696E-01],
	[4.7165000000E+04, 5.0240329759E+01, 5.5026189946E+00, 3.2223913833E+01, 4.2979543766E+00, 9.8348853757E-01],
	[4.7170000000E+04, 5.0249820825E+01, 5.5026690125E+00, 3.2235111362E+01, 4.2982534893E+00, 9.8349531496E-01],
	[4.7175000000E+04, 5.0259312677E+01, 5.5027190254E+00, 3.2246311594E+01, 4.2985525294E+00, 9.8350208916E-01],
	[4.7180000000E+04, 5.0268805316E+01, 5.5027690336E+00, 3.2257514528E+01, 4.2988514968E+00, 9.8350886015E-01],
	[4.7185000000E+04, 5.0278298741E+01, 5.5028190369E+00, 3.2268720165E+01, 4.2991503915E+00, 9.8351562795E-01],
	[4.7190000000E+04, 5.0287792953E+01, 5.5028690353E+00, 3.2279928506E+01, 4.2994492137E+00, 9.8352239254E-01],
	[4.7195000000E+04, 5.0297287952E+01, 5.5029190290E+00, 3.2291139550E+01, 4.2997479632E+00, 9.8352915394E-01],
	[4.7200000000E+04, 5.0306783737E+01, 5.5029690177E+00, 3.2302353297E+01, 4.3000466402E+00, 9.8353591214E-01],
	[4.7205000000E+04, 5.0316280309E+01, 5.5030190017E+00, 3.2313569750E+01, 4.3003452446E+00, 9.8354266715E-01],
	[4.7210000000E+04, 5.0325777668E+01, 5.5030689807E+00, 3.2324788906E+01, 4.3006437765E+00, 9.8354941897E-01],
	[4.7215000000E+04, 5.0335275813E+01, 5.5031189550E+00, 3.2336010768E+01, 4.3009422359E+00, 9.8355616760E-01],
	[4.7220000000E+04, 5.0344774745E+01, 5.5031689244E+00, 3.2347235335E+01, 4.3012406228E+00, 9.8356291305E-01],
	[4.7225000000E+04, 5.0354274463E+01, 5.5032188890E+00, 3.2358462608E+01, 4.3015389372E+00, 9.8356965530E-01],
	[4.7230000000E+04, 5.0363774967E+01, 5.5032688487E+00, 3.2369692587E+01, 4.3018371792E+00, 9.8357639438E-01],
	[4.7235000000E+04, 5.0373276259E+01, 5.5033188036E+00, 3.2380925273E+01, 4.3021353487E+00, 9.8358313027E-01],
	[4.7240000000E+04, 5.0382778336E+01, 5.5033687537E+00, 3.2392160665E+01, 4.3024334458E+00, 9.8358986298E-01],
	[4.7245000000E+04, 5.0392281200E+01, 5.5034186989E+00, 3.2403398765E+01, 4.3027314705E+00, 9.8359659251E-01],
	[4.7250000000E+04, 5.0401784851E+01, 5.5034686393E+00, 3.2414639572E+01, 4.3030294229E+00, 9.8360331886E-01],
	[4.7255000000E+04, 5.0411289288E+01, 5.5035185749E+00, 3.2425883088E+01, 4.3033273029E+00, 9.8361004204E-01],
	[4.7260000000E+04, 5.0420794511E+01, 5.5035685056E+00, 3.2437129311E+01, 4.3036251106E+00, 9.8361676205E-01],
	[4.7265000000E+04, 5.0430300521E+01, 5.5036184315E+00, 3.2448378243E+01, 4.3039228460E+00, 9.8362347888E-01],
	[4.7270000000E+04, 5.0439807317E+01, 5.5036683526E+00, 3.2459629884E+01, 4.3042205090E+00, 9.8363019254E-01],
	[4.7275000000E+04, 5.0449314899E+01, 5.5037182689E+00, 3.2470884235E+01, 4.3045180999E+00, 9.8363690304E-01],
	[4.7280000000E+04, 5.0458823268E+01, 5.5037681803E+00, 3.2482141296E+01, 4.3048156184E+00, 9.8364361037E-01],
	[4.7285000000E+04, 5.0468332423E+01, 5.5038180869E+00, 3.2493401066E+01, 4.3051130648E+00, 9.8365031453E-01],
	[4.7290000000E+04, 5.0477842364E+01, 5.5038679887E+00, 3.2504663547E+01, 4.3054104389E+00, 9.8365701553E-01],
	[4.7295000000E+04, 5.0487353092E+01, 5.5039178856E+00, 3.2515928739E+01, 4.3057077409E+00, 9.8366371337E-01],
	[4.7300000000E+04, 5.0496864606E+01, 5.5039677778E+00, 3.2527196642E+01, 4.3060049706E+00, 9.8367040805E-01],
	[4.7305000000E+04, 5.0506376906E+01, 5.5040176651E+00, 3.2538467257E+01, 4.3063021283E+00, 9.8367709957E-01],
	[4.7310000000E+04, 5.0515889992E+01, 5.5040675476E+00, 3.2549740584E+01, 4.3065992138E+00, 9.8368378794E-01],
	[4.7315000000E+04, 5.0525403865E+01, 5.5041174252E+00, 3.2561016623E+01, 4.3068962272E+00, 9.8369047315E-01],
	[4.7320000000E+04, 5.0534918524E+01, 5.5041672981E+00, 3.2572295375E+01, 4.3071931685E+00, 9.8369715521E-01],
	[4.7325000000E+04, 5.0544433968E+01, 5.5042171661E+00, 3.2583576840E+01, 4.3074900378E+00, 9.8370383411E-01],
	[4.7330000000E+04, 5.0553950199E+01, 5.5042670294E+00, 3.2594861018E+01, 4.3077868350E+00, 9.8371050987E-01],
	[4.7335000000E+04, 5.0563467217E+01, 5.5043168878E+00, 3.2606147910E+01, 4.3080835602E+00, 9.8371718248E-01],
	[4.7340000000E+04, 5.0572985020E+01, 5.5043667413E+00, 3.2617437516E+01, 4.3083802134E+00, 9.8372385195E-01],
	[4.7345000000E+04, 5.0582503609E+01, 5.5044165901E+00, 3.2628729837E+01, 4.3086767946E+00, 9.8373051827E-01],
	[4.7350000000E+04, 5.0592022985E+01, 5.5044664341E+00, 3.2640024873E+01, 4.3089733038E+00, 9.8373718145E-01],
	[4.7355000000E+04, 5.0601543146E+01, 5.5045162732E+00, 3.2651322624E+01, 4.3092697411E+00, 9.8374384149E-01],
	[4.7360000000E+04, 5.0611064094E+01, 5.5045661076E+00, 3.2662623090E+01, 4.3095661065E+00, 9.8375049838E-01],
	[4.7365000000E+04, 5.0620585827E+01, 5.5046159371E+00, 3.2673926273E+01, 4.3098624000E+00, 9.8375715215E-01],
	[4.7370000000E+04, 5.0630108347E+01, 5.5046657618E+00, 3.2685232172E+01, 4.3101586216E+00, 9.8376380277E-01],
	[4.7375000000E+04, 5.0639631652E+01, 5.5047155817E+00, 3.2696540787E+01, 4.3104547713E+00, 9.8377045027E-01],
	[4.7380000000E+04, 5.0649155744E+01, 5.5047653968E+00, 3.2707852120E+01, 4.3107508492E+00, 9.8377709463E-01],
	[4.7385000000E+04, 5.0658680621E+01, 5.5048152071E+00, 3.2719166170E+01, 4.3110468553E+00, 9.8378373586E-01],
	[4.7390000000E+04, 5.0668206284E+01, 5.5048650126E+00, 3.2730482938E+01, 4.3113427896E+00, 9.8379037396E-01],
	[4.7395000000E+04, 5.0677732734E+01, 5.5049148133E+00, 3.2741802424E+01, 4.3116386521E+00, 9.8379700894E-01],
	[4.7400000000E+04, 5.0687259969E+01, 5.5049646092E+00, 3.2753124629E+01, 4.3119344428E+00, 9.8380364079E-01],
	[4.7405000000E+04, 5.0696787990E+01, 5.5050144003E+00, 3.2764449553E+01, 4.3122301619E+00, 9.8381026952E-01],
	[4.7410000000E+04, 5.0706316797E+01, 5.5050641866E+00, 3.2775777195E+01, 4.3125258091E+00, 9.8381689513E-01],
	[4.7415000000E+04, 5.0715846389E+01, 5.5051139681E+00, 3.2787107558E+01, 4.3128213847E+00, 9.8382351762E-01],
	[4.7420000000E+04, 5.0725376768E+01, 5.5051637447E+00, 3.2798440641E+01, 4.3131168886E+00, 9.8383013698E-01],
	[4.7425000000E+04, 5.0734907932E+01, 5.5052135166E+00, 3.2809776443E+01, 4.3134123209E+00, 9.8383675324E-01],
	[4.7430000000E+04, 5.0744439882E+01, 5.5052632837E+00, 3.2821114967E+01, 4.3137076815E+00, 9.8384336638E-01],
	[4.7435000000E+04, 5.0753972618E+01, 5.5053130460E+00, 3.2832456212E+01, 4.3140029705E+00, 9.8384997640E-01],
	[4.7440000000E+04, 5.0763506140E+01, 5.5053628035E+00, 3.2843800178E+01, 4.3142981879E+00, 9.8385658331E-01],
	[4.7445000000E+04, 5.0773040447E+01, 5.5054125562E+00, 3.2855146866E+01, 4.3145933337E+00, 9.8386318712E-01],
	[4.7450000000E+04, 5.0782575540E+01, 5.5054623041E+00, 3.2866496276E+01, 4.3148884080E+00, 9.8386978782E-01],
	[4.7455000000E+04, 5.0792111419E+01, 5.5055120472E+00, 3.2877848409E+01, 4.3151834107E+00, 9.8387638541E-01],
	[4.7460000000E+04, 5.0801648083E+01, 5.5055617856E+00, 3.2889203265E+01, 4.3154783420E+00, 9.8388297989E-01],
	[4.7465000000E+04, 5.0811185534E+01, 5.5056115191E+00, 3.2900560844E+01, 4.3157732017E+00, 9.8388957128E-01],
	[4.7470000000E+04, 5.0820723769E+01, 5.5056612478E+00, 3.2911921147E+01, 4.3160679899E+00, 9.8389615956E-01],
	[4.7475000000E+04, 5.0830262791E+01, 5.5057109718E+00, 3.2923284173E+01, 4.3163627067E+00, 9.8390274475E-01],
	[4.7480000000E+04, 5.0839802598E+01, 5.5057606910E+00, 3.2934649925E+01, 4.3166573521E+00, 9.8390932683E-01],
	[4.7485000000E+04, 5.0849343190E+01, 5.5058104054E+00, 3.2946018401E+01, 4.3169519260E+00, 9.8391590582E-01],
	[4.7490000000E+04, 5.0858884568E+01, 5.5058601150E+00, 3.2957389602E+01, 4.3172464286E+00, 9.8392248172E-01],
	[4.7495000000E+04, 5.0868426732E+01, 5.5059098198E+00, 3.2968763528E+01, 4.3175408598E+00, 9.8392905452E-01],
	[4.7500000000E+04, 5.0877969681E+01, 5.5059595198E+00, 3.2980140181E+01, 4.3178352196E+00, 9.8393562424E-01],
	[4.7505000000E+04, 5.0887513416E+01, 5.5060092150E+00, 3.2991519559E+01, 4.3181295081E+00, 9.8394219086E-01],
	[4.7510000000E+04, 5.0897057936E+01, 5.5060589055E+00, 3.3002901664E+01, 4.3184237253E+00, 9.8394875440E-01],
	[4.7515000000E+04, 5.0906603242E+01, 5.5061085912E+00, 3.3014286496E+01, 4.3187178711E+00, 9.8395531485E-01],
	[4.7520000000E+04, 5.0916149333E+01, 5.5061582721E+00, 3.3025674056E+01, 4.3190119458E+00, 9.8396187222E-01],
	[4.7525000000E+04, 5.0925696209E+01, 5.5062079482E+00, 3.3037064343E+01, 4.3193059491E+00, 9.8396842651E-01],
	[4.7530000000E+04, 5.0935261416E+01, 5.5062593567E+00, 3.3048457358E+01, 4.3196010765E+00, 9.8397497772E-01],
	[4.7535000000E+04, 5.0944827858E+01, 5.5063108043E+00, 3.3059853102E+01, 4.3198961631E+00, 9.8398152584E-01],
	[4.7540000000E+04, 5.0954395091E+01, 5.5063622469E+00, 3.3071251574E+01, 4.3201911786E+00, 9.8398807089E-01],
	[4.7545000000E+04, 5.0963963113E+01, 5.5064136847E+00, 3.3082652776E+01, 4.3204861232E+00, 9.8399461286E-01],
	[4.7550000000E+04, 5.0973531926E+01, 5.5064651175E+00, 3.3094056707E+01, 4.3207809967E+00, 9.8400115176E-01],
	[4.7555000000E+04, 5.0983101529E+01, 5.5065165453E+00, 3.3105463368E+01, 4.3210757992E+00, 9.8400768758E-01],
	[4.7560000000E+04, 5.0992671922E+01, 5.5065679683E+00, 3.3116872759E+01, 4.3213705307E+00, 9.8401422033E-01],
	[4.7565000000E+04, 5.1002243105E+01, 5.5066193863E+00, 3.3128284881E+01, 4.3216651913E+00, 9.8402075000E-01],
	[4.7570000000E+04, 5.1011815078E+01, 5.5066707994E+00, 3.3139699734E+01, 4.3219597809E+00, 9.8402727661E-01],
	[4.7575000000E+04, 5.1021387842E+01, 5.5067222076E+00, 3.3151117318E+01, 4.3222542996E+00, 9.8403380014E-01],
	[4.7580000000E+04, 5.1030961395E+01, 5.5067736108E+00, 3.3162537634E+01, 4.3225487475E+00, 9.8404032061E-01],
	[4.7585000000E+04, 5.1040535739E+01, 5.5068250091E+00, 3.3173960682E+01, 4.3228431244E+00, 9.8404683802E-01],
	[4.7590000000E+04, 5.1050110873E+01, 5.5068764025E+00, 3.3185386462E+01, 4.3231374305E+00, 9.8405335236E-01],
	[4.7595000000E+04, 5.1059686796E+01, 5.5069277910E+00, 3.3196814976E+01, 4.3234316658E+00, 9.8405986364E-01],
	[4.7600000000E+04, 5.1069263510E+01, 5.5069791746E+00, 3.3208246222E+01, 4.3237258302E+00, 9.8406637185E-01],
	[4.7605000000E+04, 5.1078841014E+01, 5.5070305532E+00, 3.3219680202E+01, 4.3240199239E+00, 9.8407287701E-01],
	[4.7610000000E+04, 5.1088419308E+01, 5.5070819270E+00, 3.3231116916E+01, 4.3243139468E+00, 9.8407937911E-01],
	[4.7615000000E+04, 5.1097998392E+01, 5.5071332958E+00, 3.3242556364E+01, 4.3246078989E+00, 9.8408587815E-01],
	[4.7620000000E+04, 5.1107578265E+01, 5.5071846597E+00, 3.3253998546E+01, 4.3249017803E+00, 9.8409237413E-01],
	[4.7625000000E+04, 5.1117158929E+01, 5.5072360187E+00, 3.3265443464E+01, 4.3251955910E+00, 9.8409886707E-01],
	[4.7630000000E+04, 5.1126740383E+01, 5.5072873728E+00, 3.3276891117E+01, 4.3254893310E+00, 9.8410535695E-01],
	[4.7635000000E+04, 5.1136322626E+01, 5.5073387219E+00, 3.3288341506E+01, 4.3257830003E+00, 9.8411184377E-01],
	[4.7640000000E+04, 5.1145905660E+01, 5.5073900662E+00, 3.3299794631E+01, 4.3260765989E+00, 9.8411832755E-01],
	[4.7645000000E+04, 5.1155489483E+01, 5.5074414055E+00, 3.3311250493E+01, 4.3263701269E+00, 9.8412480829E-01],
	[4.7650000000E+04, 5.1165074096E+01, 5.5074927400E+00, 3.3322709091E+01, 4.3266635843E+00, 9.8413128597E-01],
	[4.7655000000E+04, 5.1174659499E+01, 5.5075440695E+00, 3.3334170426E+01, 4.3269569711E+00, 9.8413776061E-01],
	[4.7660000000E+04, 5.1184245692E+01, 5.5075953941E+00, 3.3345634499E+01, 4.3272502874E+00, 9.8414423221E-01],
	[4.7665000000E+04, 5.1193832674E+01, 5.5076467138E+00, 3.3357101310E+01, 4.3275435331E+00, 9.8415070077E-01],
	[4.7670000000E+04, 5.1203420447E+01, 5.5076980286E+00, 3.3368570859E+01, 4.3278367082E+00, 9.8415716628E-01],
	[4.7675000000E+04, 5.1213009009E+01, 5.5077493385E+00, 3.3380043147E+01, 4.3281298128E+00, 9.8416362876E-01],
	[4.7680000000E+04, 5.1222598361E+01, 5.5078006435E+00, 3.3391518174E+01, 4.3284228470E+00, 9.8417008820E-01],
	[4.7685000000E+04, 5.1232188502E+01, 5.5078519436E+00, 3.3402995941E+01, 4.3287158106E+00, 9.8417654460E-01],
	[4.7690000000E+04, 5.1241779434E+01, 5.5079032388E+00, 3.3414476447E+01, 4.3290087038E+00, 9.8418299797E-01],
	[4.7695000000E+04, 5.1251371155E+01, 5.5079545291E+00, 3.3425959693E+01, 4.3293015266E+00, 9.8418944830E-01],
	[4.7700000000E+04, 5.1260963665E+01, 5.5080058145E+00, 3.3437445680E+01, 4.3295942789E+00, 9.8419589561E-01],
	[4.7705000000E+04, 5.1270556966E+01, 5.5080570950E+00, 3.3448934407E+01, 4.3298869609E+00, 9.8420233988E-01],
	[4.7710000000E+04, 5.1280151056E+01, 5.5081083706E+00, 3.3460425876E+01, 4.3301795725E+00, 9.8420878113E-01],
	[4.7715000000E+04, 5.1289745935E+01, 5.5081596413E+00, 3.3471920087E+01, 4.3304721137E+00, 9.8421521934E-01],
	[4.7720000000E+04, 5.1299341604E+01, 5.5082109071E+00, 3.3483417039E+01, 4.3307645846E+00, 9.8422165454E-01],
	[4.7725000000E+04, 5.1308938063E+01, 5.5082621681E+00, 3.3494916734E+01, 4.3310569852E+00, 9.8422808670E-01],
	[4.7730000000E+04, 5.1318535311E+01, 5.5083134241E+00, 3.3506419171E+01, 4.3313493155E+00, 9.8423451585E-01],
	[4.7735000000E+04, 5.1328133349E+01, 5.5083646752E+00, 3.3517924351E+01, 4.3316415755E+00, 9.8424094197E-01],
	[4.7740000000E+04, 5.1337732177E+01, 5.5084159214E+00, 3.3529432275E+01, 4.3319337652E+00, 9.8424736508E-01],
	[4.7745000000E+04, 5.1347331794E+01, 5.5084671628E+00, 3.3540942943E+01, 4.3322258847E+00, 9.8425378517E-01],
	[4.7750000000E+04, 5.1356932200E+01, 5.5085183993E+00, 3.3552456355E+01, 4.3325179340E+00, 9.8426020224E-01],
	[4.7755000000E+04, 5.1366533396E+01, 5.5085696308E+00, 3.3563972511E+01, 4.3328099131E+00, 9.8426661629E-01],
	[4.7760000000E+04, 5.1376135382E+01, 5.5086208575E+00, 3.3575491412E+01, 4.3331018221E+00, 9.8427302733E-01],
	[4.7765000000E+04, 5.1385738156E+01, 5.5086720793E+00, 3.3587013059E+01, 4.3333936608E+00, 9.8427943536E-01],
	[4.7770000000E+04, 5.1395341721E+01, 5.5087232962E+00, 3.3598537451E+01, 4.3336854295E+00, 9.8428584038E-01],
	[4.7775000000E+04, 5.1404946074E+01, 5.5087745083E+00, 3.3610064589E+01, 4.3339771280E+00, 9.8429224239E-01],
	[4.7780000000E+04, 5.1414551217E+01, 5.5088257154E+00, 3.3621594473E+01, 4.3342687564E+00, 9.8429864139E-01],
	[4.7785000000E+04, 5.1424157150E+01, 5.5088769177E+00, 3.3633127105E+01, 4.3345603147E+00, 9.8430503738E-01],
	[4.7790000000E+04, 5.1433763872E+01, 5.5089281151E+00, 3.3644662483E+01, 4.3348518030E+00, 9.8431143037E-01],
	[4.7795000000E+04, 5.1443371383E+01, 5.5089793076E+00, 3.3656200609E+01, 4.3351432213E+00, 9.8431782036E-01],
	[4.7800000000E+04, 5.1452979683E+01, 5.5090304952E+00, 3.3667741482E+01, 4.3354345695E+00, 9.8432420734E-01],
	[4.7805000000E+04, 5.1462588773E+01, 5.5090816779E+00, 3.3679285104E+01, 4.3357258478E+00, 9.8433059133E-01],
	[4.7810000000E+04, 5.1472198652E+01, 5.5091328558E+00, 3.3690831474E+01, 4.3360170560E+00, 9.8433697231E-01],
	[4.7815000000E+04, 5.1481809320E+01, 5.5091840288E+00, 3.3702380593E+01, 4.3363081943E+00, 9.8434335030E-01],
	[4.7820000000E+04, 5.1491420778E+01, 5.5092351969E+00, 3.3713932462E+01, 4.3365992627E+00, 9.8434972529E-01],
	[4.7825000000E+04, 5.1501033025E+01, 5.5092863601E+00, 3.3725487080E+01, 4.3368902611E+00, 9.8435609729E-01],
	[4.7830000000E+04, 5.1510646061E+01, 5.5093375185E+00, 3.3737044448E+01, 4.3371811897E+00, 9.8436246629E-01],
	[4.7835000000E+04, 5.1520259886E+01, 5.5093886720E+00, 3.3748604567E+01, 4.3374720483E+00, 9.8436883230E-01],
	[4.7840000000E+04, 5.1529874500E+01, 5.5094398206E+00, 3.3760167436E+01, 4.3377628372E+00, 9.8437519532E-01],
	[4.7845000000E+04, 5.1539489904E+01, 5.5094909644E+00, 3.3771733056E+01, 4.3380535561E+00, 9.8438155536E-01],
	[4.7850000000E+04, 5.1549106097E+01, 5.5095421033E+00, 3.3783301428E+01, 4.3383442053E+00, 9.8438791240E-01],
	[4.7855000000E+04, 5.1558723078E+01, 5.5095932373E+00, 3.3794872552E+01, 4.3386347846E+00, 9.8439426646E-01],
	[4.7860000000E+04, 5.1568340849E+01, 5.5096443664E+00, 3.3806446428E+01, 4.3389252942E+00, 9.8440061754E-01],
	[4.7865000000E+04, 5.1577959409E+01, 5.5096954907E+00, 3.3818023056E+01, 4.3392157340E+00, 9.8440696563E-01],
	[4.7870000000E+04, 5.1587578758E+01, 5.5097466101E+00, 3.3829602438E+01, 4.3395061041E+00, 9.8441331074E-01],
	[4.7875000000E+04, 5.1597198896E+01, 5.5097977246E+00, 3.3841184573E+01, 4.3397964045E+00, 9.8441965288E-01],
	[4.7880000000E+04, 5.1606819824E+01, 5.5098488343E+00, 3.3852769461E+01, 4.3400866351E+00, 9.8442599203E-01],
	[4.7885000000E+04, 5.1616441540E+01, 5.5098999391E+00, 3.3864357104E+01, 4.3403767961E+00, 9.8443232821E-01],
	[4.7890000000E+04, 5.1626064045E+01, 5.5099510391E+00, 3.3875947501E+01, 4.3406668874E+00, 9.8443866141E-01],
	[4.7895000000E+04, 5.1635687339E+01, 5.5100021342E+00, 3.3887540652E+01, 4.3409569091E+00, 9.8444499164E-01],
	[4.7900000000E+04, 5.1645311422E+01, 5.5100532244E+00, 3.3899136559E+01, 4.3412468611E+00, 9.8445131889E-01],
	[4.7905000000E+04, 5.1654936294E+01, 5.5101043098E+00, 3.3910735222E+01, 4.3415367436E+00, 9.8445764318E-01],
	[4.7910000000E+04, 5.1664561955E+01, 5.5101553903E+00, 3.3922336640E+01, 4.3418265565E+00, 9.8446396449E-01],
	[4.7915000000E+04, 5.1674188405E+01, 5.5102064660E+00, 3.3933940814E+01, 4.3421162998E+00, 9.8447028284E-01],
	[4.7920000000E+04, 5.1683815644E+01, 5.5102575368E+00, 3.3945547745E+01, 4.3424059736E+00, 9.8447659822E-01],
	[4.7925000000E+04, 5.1693443672E+01, 5.5103086028E+00, 3.3957157434E+01, 4.3426955778E+00, 9.8448291063E-01],
	[4.7930000000E+04, 5.1703072488E+01, 5.5103596639E+00, 3.3968769879E+01, 4.3429851125E+00, 9.8448922009E-01],
	[4.7935000000E+04, 5.1712702094E+01, 5.5104107201E+00, 3.3980385082E+01, 4.3432745778E+00, 9.8449552658E-01],
	[4.7940000000E+04, 5.1722332488E+01, 5.5104617715E+00, 3.3992003043E+01, 4.3435639736E+00, 9.8450183010E-01],
	[4.7945000000E+04, 5.1731963671E+01, 5.5105128180E+00, 3.4003623763E+01, 4.3438533000E+00, 9.8450813067E-01],
	[4.7950000000E+04, 5.1741595643E+01, 5.5105638597E+00, 3.4015247242E+01, 4.3441425569E+00, 9.8451442829E-01],
	[4.7955000000E+04, 5.1751228403E+01, 5.5106148966E+00, 3.4026873479E+01, 4.3444317444E+00, 9.8452072294E-01],
	[4.7960000000E+04, 5.1760861953E+01, 5.5106659286E+00, 3.4038502477E+01, 4.3447208626E+00, 9.8452701464E-01],
	[4.7965000000E+04, 5.1770496291E+01, 5.5107169557E+00, 3.4050134234E+01, 4.3450099114E+00, 9.8453330339E-01],
	[4.7970000000E+04, 5.1780131418E+01, 5.5107679780E+00, 3.4061768751E+01, 4.3452988908E+00, 9.8453958918E-01],
	[4.7975000000E+04, 5.1789767333E+01, 5.5108189954E+00, 3.4073406029E+01, 4.3455878009E+00, 9.8454587203E-01],
	[4.7980000000E+04, 5.1799404037E+01, 5.5108700081E+00, 3.4085046068E+01, 4.3458766417E+00, 9.8455215193E-01],
	[4.7985000000E+04, 5.1809041530E+01, 5.5109210158E+00, 3.4096688869E+01, 4.3461654132E+00, 9.8455842887E-01],
	[4.7990000000E+04, 5.1818679812E+01, 5.5109720187E+00, 3.4108334431E+01, 4.3464541155E+00, 9.8456470288E-01],
	[4.7995000000E+04, 5.1828318882E+01, 5.5110230168E+00, 3.4119982756E+01, 4.3467427485E+00, 9.8457097394E-01],
	[4.8000000000E+04, 5.1837958741E+01, 5.5110740101E+00, 3.4131633842E+01, 4.3470313123E+00, 9.8457724205E-01],
	[4.8005000000E+04, 5.1847599388E+01, 5.5111249985E+00, 3.4143287692E+01, 4.3473198069E+00, 9.8458350722E-01],
	[4.8010000000E+04, 5.1857240824E+01, 5.5111759820E+00, 3.4154944305E+01, 4.3476082323E+00, 9.8458976946E-01],
	[4.8015000000E+04, 5.1866883048E+01, 5.5112269607E+00, 3.4166603681E+01, 4.3478965885E+00, 9.8459602875E-01],
	[4.8020000000E+04, 5.1876526061E+01, 5.5112779346E+00, 3.4178265822E+01, 4.3481848756E+00, 9.8460228511E-01],
	[4.8025000000E+04, 5.1886169863E+01, 5.5113289037E+00, 3.4189930727E+01, 4.3484730935E+00, 9.8460853853E-01],
	[4.8030000000E+04, 5.1895814453E+01, 5.5113798679E+00, 3.4201598396E+01, 4.3487612423E+00, 9.8461478902E-01],
	[4.8035000000E+04, 5.1905459832E+01, 5.5114308273E+00, 3.4213268830E+01, 4.3490493221E+00, 9.8462103657E-01],
	[4.8040000000E+04, 5.1915105999E+01, 5.5114817818E+00, 3.4224942030E+01, 4.3493373328E+00, 9.8462728120E-01],
	[4.8045000000E+04, 5.1924752954E+01, 5.5115327315E+00, 3.4236617996E+01, 4.3496252744E+00, 9.8463352289E-01],
	[4.8050000000E+04, 5.1934400698E+01, 5.5115836764E+00, 3.4248296728E+01, 4.3499131470E+00, 9.8463976165E-01],
	[4.8055000000E+04, 5.1944049230E+01, 5.5116346165E+00, 3.4259978226E+01, 4.3502009506E+00, 9.8464599749E-01],
	[4.8060000000E+04, 5.1953698551E+01, 5.5116855517E+00, 3.4271662491E+01, 4.3504886852E+00, 9.8465223040E-01],
	[4.8065000000E+04, 5.1963348660E+01, 5.5117364821E+00, 3.4283349524E+01, 4.3507763508E+00, 9.8465846039E-01],
	[4.8070000000E+04, 5.1972999558E+01, 5.5117874077E+00, 3.4295039324E+01, 4.3510639475E+00, 9.8466468746E-01],
	[4.8075000000E+04, 5.1982651243E+01, 5.5118383284E+00, 3.4306731892E+01, 4.3513514753E+00, 9.8467091160E-01],
	[4.8080000000E+04, 5.1992303718E+01, 5.5118892443E+00, 3.4318427228E+01, 4.3516389341E+00, 9.8467713283E-01],
	[4.8085000000E+04, 5.2001956980E+01, 5.5119401554E+00, 3.4330125333E+01, 4.3519263241E+00, 9.8468335113E-01],
	[4.8090000000E+04, 5.2011611031E+01, 5.5119910617E+00, 3.4341826208E+01, 4.3522136451E+00, 9.8468956652E-01],
	[4.8095000000E+04, 5.2021265870E+01, 5.5120419631E+00, 3.4353529851E+01, 4.3525008973E+00, 9.8469577900E-01],
	[4.8100000000E+04, 5.2030921497E+01, 5.5120928598E+00, 3.4365236265E+01, 4.3527880807E+00, 9.8470198856E-01],
	[4.8105000000E+04, 5.2040577913E+01, 5.5121437516E+00, 3.4376945449E+01, 4.3530751953E+00, 9.8470819521E-01],
	[4.8110000000E+04, 5.2050235116E+01, 5.5121946386E+00, 3.4388657403E+01, 4.3533622411E+00, 9.8471439895E-01],
	[4.8115000000E+04, 5.2059893108E+01, 5.5122455207E+00, 3.4400372128E+01, 4.3536492181E+00, 9.8472059977E-01],
	[4.8120000000E+04, 5.2069551889E+01, 5.5122963981E+00, 3.4412089624E+01, 4.3539361263E+00, 9.8472679769E-01],
	[4.8125000000E+04, 5.2079211457E+01, 5.5123472706E+00, 3.4423809892E+01, 4.3542229658E+00, 9.8473299271E-01],
	[4.8130000000E+04, 5.2088871813E+01, 5.5123981383E+00, 3.4435532933E+01, 4.3545097366E+00, 9.8473918482E-01],
	[4.8135000000E+04, 5.2098532958E+01, 5.5124490012E+00, 3.4447258745E+01, 4.3547964387E+00, 9.8474537402E-01],
	[4.8140000000E+04, 5.2108194891E+01, 5.5124998593E+00, 3.4458987330E+01, 4.3550830722E+00, 9.8475156032E-01],
	[4.8145000000E+04, 5.2117857612E+01, 5.5125507126E+00, 3.4470718689E+01, 4.3553696369E+00, 9.8475774373E-01],
	[4.8150000000E+04, 5.2127521121E+01, 5.5126015611E+00, 3.4482452820E+01, 4.3556561331E+00, 9.8476392423E-01],
	[4.8155000000E+04, 5.2137185418E+01, 5.5126524047E+00, 3.4494189726E+01, 4.3559425606E+00, 9.8477010183E-01],
	[4.8160000000E+04, 5.2146850503E+01, 5.5127032436E+00, 3.4505929406E+01, 4.3562289195E+00, 9.8477627654E-01],
	[4.8165000000E+04, 5.2156516376E+01, 5.5127540776E+00, 3.4517671861E+01, 4.3565152098E+00, 9.8478244836E-01],
	[4.8170000000E+04, 5.2166183037E+01, 5.5128049068E+00, 3.4529417090E+01, 4.3568014316E+00, 9.8478861728E-01],
	[4.8175000000E+04, 5.2175850486E+01, 5.5128557312E+00, 3.4541165095E+01, 4.3570875848E+00, 9.8479478331E-01],
	[4.8180000000E+04, 5.2185518723E+01, 5.5129065509E+00, 3.4552915875E+01, 4.3573736695E+00, 9.8480094644E-01],
	[4.8185000000E+04, 5.2195187748E+01, 5.5129573657E+00, 3.4564669432E+01, 4.3576596857E+00, 9.8480710669E-01],
	[4.8190000000E+04, 5.2204857561E+01, 5.5130081757E+00, 3.4576425765E+01, 4.3579456335E+00, 9.8481326405E-01],
	[4.8195000000E+04, 5.2214528162E+01, 5.5130589809E+00, 3.4588184875E+01, 4.3582315127E+00, 9.8481941853E-01],
	[4.8200000000E+04, 5.2224199551E+01, 5.5131097813E+00, 3.4599946762E+01, 4.3585173236E+00, 9.8482557012E-01],
	[4.8205000000E+04, 5.2233871727E+01, 5.5131605769E+00, 3.4611711426E+01, 4.3588030660E+00, 9.8483171883E-01],
	[4.8210000000E+04, 5.2243544692E+01, 5.5132113677E+00, 3.4623478868E+01, 4.3590887400E+00, 9.8483786465E-01],
	[4.8215000000E+04, 5.2253218445E+01, 5.5132621537E+00, 3.4635249089E+01, 4.3593743456E+00, 9.8484400760E-01],
	[4.8220000000E+04, 5.2262892985E+01, 5.5133129348E+00, 3.4647022088E+01, 4.3596598828E+00, 9.8485014766E-01],
	[4.8225000000E+04, 5.2272568313E+01, 5.5133637112E+00, 3.4658797867E+01, 4.3599453517E+00, 9.8485628485E-01],
	[4.8230000000E+04, 5.2282244429E+01, 5.5134144829E+00, 3.4670576424E+01, 4.3602307523E+00, 9.8486241916E-01],
	[4.8235000000E+04, 5.2291921332E+01, 5.5134652497E+00, 3.4682357761E+01, 4.3605160846E+00, 9.8486855060E-01],
	[4.8240000000E+04, 5.2301599024E+01, 5.5135160117E+00, 3.4694141879E+01, 4.3608013486E+00, 9.8487467917E-01],
	[4.8245000000E+04, 5.2311277503E+01, 5.5135667689E+00, 3.4705928777E+01, 4.3610865443E+00, 9.8488080486E-01],
	[4.8250000000E+04, 5.2320956770E+01, 5.5136175213E+00, 3.4717718455E+01, 4.3613716718E+00, 9.8488692768E-01],
	[4.8255000000E+04, 5.2330636825E+01, 5.5136682689E+00, 3.4729510915E+01, 4.3616567310E+00, 9.8489304764E-01],
	[4.8260000000E+04, 5.2340317667E+01, 5.5137190118E+00, 3.4741306157E+01, 4.3619417221E+00, 9.8489916472E-01],
	[4.8265000000E+04, 5.2349999297E+01, 5.5137697498E+00, 3.4753104180E+01, 4.3622266449E+00, 9.8490527894E-01],
	[4.8270000000E+04, 5.2359681715E+01, 5.5138204831E+00, 3.4764904986E+01, 4.3625114996E+00, 9.8491139030E-01],
	[4.8275000000E+04, 5.2369364920E+01, 5.5138712116E+00, 3.4776708574E+01, 4.3627962861E+00, 9.8491749879E-01],
	[4.8280000000E+04, 5.2379048913E+01, 5.5139219353E+00, 3.4788514946E+01, 4.3630810045E+00, 9.8492360443E-01],
	[4.8285000000E+04, 5.2388733694E+01, 5.5139726542E+00, 3.4800324101E+01, 4.3633656548E+00, 9.8492970720E-01],
	[4.8290000000E+04, 5.2398419262E+01, 5.5140233683E+00, 3.4812136039E+01, 4.3636502370E+00, 9.8493580711E-01],
	[4.8295000000E+04, 5.2408122835E+01, 5.5140757477E+00, 3.4823950762E+01, 4.3639359165E+00, 9.8494190417E-01],
	[4.8300000000E+04, 5.2417827968E+01, 5.5141281966E+00, 3.4835768269E+01, 4.3642215801E+00, 9.8494799837E-01],
	[4.8305000000E+04, 5.2427533893E+01, 5.5141806406E+00, 3.4847588561E+01, 4.3645071757E+00, 9.8495408971E-01],
	[4.8310000000E+04, 5.2437240610E+01, 5.5142330797E+00, 3.4859411639E+01, 4.3647927035E+00, 9.8496017821E-01],
	[4.8315000000E+04, 5.2446948120E+01, 5.5142855138E+00, 3.4871237502E+01, 4.3650781634E+00, 9.8496626385E-01],
	[4.8320000000E+04, 5.2456656422E+01, 5.5143379430E+00, 3.4883066151E+01, 4.3653635554E+00, 9.8497234664E-01],
	[4.8325000000E+04, 5.2466365516E+01, 5.5143903673E+00, 3.4894897586E+01, 4.3656488796E+00, 9.8497842659E-01],
	[4.8330000000E+04, 5.2476075403E+01, 5.5144427867E+00, 3.4906731808E+01, 4.3659341360E+00, 9.8498450368E-01],
	[4.8335000000E+04, 5.2485786082E+01, 5.5144952011E+00, 3.4918568817E+01, 4.3662193246E+00, 9.8499057793E-01],
	[4.8340000000E+04, 5.2495497553E+01, 5.5145476107E+00, 3.4930408613E+01, 4.3665044455E+00, 9.8499664934E-01],
	[4.8345000000E+04, 5.2505209816E+01, 5.5146000152E+00, 3.4942251198E+01, 4.3667894985E+00, 9.8500271790E-01],
	[4.8350000000E+04, 5.2514922871E+01, 5.5146524149E+00, 3.4954096570E+01, 4.3670744839E+00, 9.8500878363E-01],
	[4.8355000000E+04, 5.2524636719E+01, 5.5147048097E+00, 3.4965944731E+01, 4.3673594015E+00, 9.8501484651E-01],
	[4.8360000000E+04, 5.2534351359E+01, 5.5147571995E+00, 3.4977795681E+01, 4.3676442514E+00, 9.8502090655E-01],
	[4.8365000000E+04, 5.2544066790E+01, 5.5148095844E+00, 3.4989649420E+01, 4.3679290337E+00, 9.8502696376E-01],
	[4.8370000000E+04, 5.2553783014E+01, 5.5148619644E+00, 3.5001505949E+01, 4.3682137483E+00, 9.8503301813E-01],
	[4.8375000000E+04, 5.2563500030E+01, 5.5149143395E+00, 3.5013365268E+01, 4.3684983953E+00, 9.8503906967E-01],
	[4.8380000000E+04, 5.2573217838E+01, 5.5149667096E+00, 3.5025227377E+01, 4.3687829746E+00, 9.8504511838E-01],
	[4.8385000000E+04, 5.2582936439E+01, 5.5150190749E+00, 3.5037092277E+01, 4.3690674863E+00, 9.8505116425E-01],
	[4.8390000000E+04, 5.2592655831E+01, 5.5150714352E+00, 3.5048959969E+01, 4.3693519305E+00, 9.8505720729E-01],
	[4.8395000000E+04, 5.2602376015E+01, 5.5151237906E+00, 3.5060830451E+01, 4.3696363071E+00, 9.8506324751E-01],
	[4.8400000000E+04, 5.2612096991E+01, 5.5151761412E+00, 3.5072703726E+01, 4.3699206162E+00, 9.8506928490E-01],
	[4.8405000000E+04, 5.2621818759E+01, 5.5152284867E+00, 3.5084579792E+01, 4.3702048577E+00, 9.8507531946E-01],
	[4.8410000000E+04, 5.2631541320E+01, 5.5152808274E+00, 3.5096458652E+01, 4.3704890317E+00, 9.8508135120E-01],
	[4.8415000000E+04, 5.2641264672E+01, 5.5153331632E+00, 3.5108340304E+01, 4.3707731383E+00, 9.8508738012E-01],
	[4.8420000000E+04, 5.2650988816E+01, 5.5153854941E+00, 3.5120224750E+01, 4.3710571773E+00, 9.8509340621E-01],
	[4.8425000000E+04, 5.2660713752E+01, 5.5154378200E+00, 3.5132111989E+01, 4.3713411490E+00, 9.8509942949E-01],
	[4.8430000000E+04, 5.2670439480E+01, 5.5154901411E+00, 3.5144002022E+01, 4.3716250532E+00, 9.8510544995E-01],
	[4.8435000000E+04, 5.2680165999E+01, 5.5155424573E+00, 3.5155894850E+01, 4.3719088900E+00, 9.8511146759E-01],
	[4.8440000000E+04, 5.2689893311E+01, 5.5155947685E+00, 3.5167790472E+01, 4.3721926594E+00, 9.8511748241E-01],
	[4.8445000000E+04, 5.2699621414E+01, 5.5156470748E+00, 3.5179688890E+01, 4.3724763614E+00, 9.8512349442E-01],
	[4.8450000000E+04, 5.2709350310E+01, 5.5156993763E+00, 3.5191590103E+01, 4.3727599961E+00, 9.8512950362E-01],
	[4.8455000000E+04, 5.2719079997E+01, 5.5157516728E+00, 3.5203494113E+01, 4.3730435635E+00, 9.8513551001E-01],
	[4.8460000000E+04, 5.2728810476E+01, 5.5158039645E+00, 3.5215400918E+01, 4.3733270636E+00, 9.8514151359E-01],
	[4.8465000000E+04, 5.2738541746E+01, 5.5158562512E+00, 3.5227310520E+01, 4.3736104963E+00, 9.8514751436E-01],
	[4.8470000000E+04, 5.2748273809E+01, 5.5159085331E+00, 3.5239222919E+01, 4.3738938618E+00, 9.8515351232E-01],
	[4.8475000000E+04, 5.2758006663E+01, 5.5159608100E+00, 3.5251138116E+01, 4.3741771600E+00, 9.8515950748E-01],
	[4.8480000000E+04, 5.2767740309E+01, 5.5160130820E+00, 3.5263056110E+01, 4.3744603910E+00, 9.8516549983E-01],
	[4.8485000000E+04, 5.2777474747E+01, 5.5160653492E+00, 3.5274976902E+01, 4.3747435548E+00, 9.8517148938E-01],
	[4.8490000000E+04, 5.2787209976E+01, 5.5161176115E+00, 3.5286900493E+01, 4.3750266514E+00, 9.8517747613E-01],
	[4.8495000000E+04, 5.2796945997E+01, 5.5161698688E+00, 3.5298826882E+01, 4.3753096808E+00, 9.8518346008E-01],
	[4.8500000000E+04, 5.2806682810E+01, 5.5162221213E+00, 3.5310756071E+01, 4.3755926430E+00, 9.8518944123E-01],
	[4.8505000000E+04, 5.2816420414E+01, 5.5162743689E+00, 3.5322688059E+01, 4.3758755381E+00, 9.8519541959E-01],
	[4.8510000000E+04, 5.2826158810E+01, 5.5163266116E+00, 3.5334622848E+01, 4.3761583661E+00, 9.8520139515E-01],
	[4.8515000000E+04, 5.2835897997E+01, 5.5163788494E+00, 3.5346560436E+01, 4.3764411270E+00, 9.8520736791E-01],
	[4.8520000000E+04, 5.2845637977E+01, 5.5164310823E+00, 3.5358500826E+01, 4.3767238208E+00, 9.8521333789E-01],
	[4.8525000000E+04, 5.2855378747E+01, 5.5164833103E+00, 3.5370444016E+01, 4.3770064476E+00, 9.8521930507E-01],
	[4.8530000000E+04, 5.2865120310E+01, 5.5165355334E+00, 3.5382390008E+01, 4.3772890073E+00, 9.8522526946E-01],
	[4.8535000000E+04, 5.2874862663E+01, 5.5165877517E+00, 3.5394338801E+01, 4.3775714999E+00, 9.8523123107E-01],
	[4.8540000000E+04, 5.2884605809E+01, 5.5166399650E+00, 3.5406290397E+01, 4.3778539256E+00, 9.8523718988E-01],
	[4.8545000000E+04, 5.2894349746E+01, 5.5166921735E+00, 3.5418244795E+01, 4.3781362843E+00, 9.8524314592E-01],
	[4.8550000000E+04, 5.2904094474E+01, 5.5167443771E+00, 3.5430201996E+01, 4.3784185760E+00, 9.8524909916E-01],
	[4.8555000000E+04, 5.2913839994E+01, 5.5167965758E+00, 3.5442162000E+01, 4.3787008008E+00, 9.8525504963E-01],
	[4.8560000000E+04, 5.2923586305E+01, 5.5168487697E+00, 3.5454124808E+01, 4.3789829586E+00, 9.8526099731E-01],
	[4.8565000000E+04, 5.2933333408E+01, 5.5169009586E+00, 3.5466090420E+01, 4.3792650495E+00, 9.8526694222E-01],
	[4.8570000000E+04, 5.2943081302E+01, 5.5169531427E+00, 3.5478058837E+01, 4.3795470736E+00, 9.8527288435E-01],
	[4.8575000000E+04, 5.2952829987E+01, 5.5170053219E+00, 3.5490030058E+01, 4.3798290307E+00, 9.8527882369E-01],
	[4.8580000000E+04, 5.2962579464E+01, 5.5170574962E+00, 3.5502004084E+01, 4.3801109211E+00, 9.8528476027E-01],
	[4.8585000000E+04, 5.2972329732E+01, 5.5171096657E+00, 3.5513980915E+01, 4.3803927445E+00, 9.8529069407E-01],
	[4.8590000000E+04, 5.2982080792E+01, 5.5171618302E+00, 3.5525960553E+01, 4.3806745012E+00, 9.8529662510E-01],
	[4.8595000000E+04, 5.2991832643E+01, 5.5172139899E+00, 3.5537942996E+01, 4.3809561911E+00, 9.8530255335E-01],
	[4.8600000000E+04, 5.3001585285E+01, 5.5172661448E+00, 3.5549928247E+01, 4.3812378142E+00, 9.8530847884E-01],
	[4.8605000000E+04, 5.3011338719E+01, 5.5173182947E+00, 3.5561916304E+01, 4.3815193705E+00, 9.8531440156E-01],
	[4.8610000000E+04, 5.3021092943E+01, 5.5173704398E+00, 3.5573907168E+01, 4.3818008601E+00, 9.8532032151E-01],
	[4.8615000000E+04, 5.3030847959E+01, 5.5174225800E+00, 3.5585900840E+01, 4.3820822830E+00, 9.8532623870E-01],
	[4.8620000000E+04, 5.3040603767E+01, 5.5174747153E+00, 3.5597897320E+01, 4.3823636392E+00, 9.8533215312E-01],
	[4.8625000000E+04, 5.3050360365E+01, 5.5175268458E+00, 3.5609896609E+01, 4.3826449287E+00, 9.8533806478E-01],
	[4.8630000000E+04, 5.3060117755E+01, 5.5175789714E+00, 3.5621898706E+01, 4.3829261515E+00, 9.8534397368E-01],
	[4.8635000000E+04, 5.3069875936E+01, 5.5176310921E+00, 3.5633903613E+01, 4.3832073077E+00, 9.8534987982E-01],
	[4.8640000000E+04, 5.3079634908E+01, 5.5176832080E+00, 3.5645911329E+01, 4.3834883973E+00, 9.8535578320E-01],
	[4.8645000000E+04, 5.3089394671E+01, 5.5177353190E+00, 3.5657921854E+01, 4.3837694202E+00, 9.8536168382E-01],
	[4.8650000000E+04, 5.3099155226E+01, 5.5177874251E+00, 3.5669935190E+01, 4.3840503766E+00, 9.8536758169E-01],
	[4.8655000000E+04, 5.3108916571E+01, 5.5178395264E+00, 3.5681951337E+01, 4.3843312664E+00, 9.8537347680E-01],
	[4.8660000000E+04, 5.3118678708E+01, 5.5178916228E+00, 3.5693970295E+01, 4.3846120897E+00, 9.8537936916E-01],
	[4.8665000000E+04, 5.3128441636E+01, 5.5179437144E+00, 3.5705992064E+01, 4.3848928464E+00, 9.8538525877E-01],
	[4.8670000000E+04, 5.3138205355E+01, 5.5179958011E+00, 3.5718016645E+01, 4.3851735366E+00, 9.8539114563E-01],
	[4.8675000000E+04, 5.3147969865E+01, 5.5180478829E+00, 3.5730044037E+01, 4.3854541604E+00, 9.8539702974E-01],
	[4.8680000000E+04, 5.3157735165E+01, 5.5180999599E+00, 3.5742074243E+01, 4.3857347176E+00, 9.8540291111E-01],
	[4.8685000000E+04, 5.3167501257E+01, 5.5181520320E+00, 3.5754107261E+01, 4.3860152085E+00, 9.8540878973E-01],
	[4.8690000000E+04, 5.3177268140E+01, 5.5182040993E+00, 3.5766143092E+01, 4.3862956328E+00, 9.8541466560E-01],
	[4.8695000000E+04, 5.3187035814E+01, 5.5182561617E+00, 3.5778181737E+01, 4.3865759908E+00, 9.8542053873E-01],
	[4.8700000000E+04, 5.3196804279E+01, 5.5183082192E+00, 3.5790223196E+01, 4.3868562824E+00, 9.8542640912E-01],
	[4.8705000000E+04, 5.3206573535E+01, 5.5183602719E+00, 3.5802267469E+01, 4.3871365075E+00, 9.8543227677E-01],
	[4.8710000000E+04, 5.3216343582E+01, 5.5184123198E+00, 3.5814314556E+01, 4.3874166664E+00, 9.8543814168E-01],
	[4.8715000000E+04, 5.3226114420E+01, 5.5184643627E+00, 3.5826364459E+01, 4.3876967589E+00, 9.8544400386E-01],
	[4.8720000000E+04, 5.3235886048E+01, 5.5185164009E+00, 3.5838417177E+01, 4.3879767850E+00, 9.8544986330E-01],
	[4.8725000000E+04, 5.3245658468E+01, 5.5185684342E+00, 3.5850472711E+01, 4.3882567449E+00, 9.8545572000E-01],
	[4.8730000000E+04, 5.3255431678E+01, 5.5186204626E+00, 3.5862531061E+01, 4.3885366385E+00, 9.8546157397E-01],
	[4.8735000000E+04, 5.3265205679E+01, 5.5186724862E+00, 3.5874592228E+01, 4.3888164658E+00, 9.8546742521E-01],
	[4.8740000000E+04, 5.3274980471E+01, 5.5187245050E+00, 3.5886656211E+01, 4.3890962269E+00, 9.8547327372E-01],
	[4.8745000000E+04, 5.3284756054E+01, 5.5187765189E+00, 3.5898723012E+01, 4.3893759217E+00, 9.8547911951E-01],
	[4.8750000000E+04, 5.3294532428E+01, 5.5188285279E+00, 3.5910792630E+01, 4.3896555504E+00, 9.8548496256E-01],
	[4.8755000000E+04, 5.3304309592E+01, 5.5188805322E+00, 3.5922865067E+01, 4.3899351128E+00, 9.8549080289E-01],
	[4.8760000000E+04, 5.3314087548E+01, 5.5189325315E+00, 3.5934940321E+01, 4.3902146091E+00, 9.8549664049E-01],
	[4.8765000000E+04, 5.3323866294E+01, 5.5189845261E+00, 3.5947018395E+01, 4.3904940393E+00, 9.8550247537E-01],
	[4.8770000000E+04, 5.3333645830E+01, 5.5190365158E+00, 3.5959099287E+01, 4.3907734033E+00, 9.8550830753E-01],
	[4.8775000000E+04, 5.3343426158E+01, 5.5190885006E+00, 3.5971182999E+01, 4.3910527012E+00, 9.8551413697E-01],
	[4.8780000000E+04, 5.3353207276E+01, 5.5191404806E+00, 3.5983269531E+01, 4.3913319330E+00, 9.8551996369E-01],
	[4.8785000000E+04, 5.3362989185E+01, 5.5191924558E+00, 3.5995358882E+01, 4.3916110987E+00, 9.8552578769E-01],
	[4.8790000000E+04, 5.3372771884E+01, 5.5192444261E+00, 3.6007451055E+01, 4.3918901984E+00, 9.8553160898E-01],
	[4.8795000000E+04, 5.3382555374E+01, 5.5192963916E+00, 3.6019546048E+01, 4.3921692320E+00, 9.8553742755E-01],
	[4.8800000000E+04, 5.3392339655E+01, 5.5193483523E+00, 3.6031643863E+01, 4.3924481996E+00, 9.8554324341E-01],
	[4.8805000000E+04, 5.3402124726E+01, 5.5194003081E+00, 3.6043744499E+01, 4.3927271013E+00, 9.8554905656E-01],
	[4.8810000000E+04, 5.3411910588E+01, 5.5194522591E+00, 3.6055847957E+01, 4.3930059369E+00, 9.8555486699E-01],
	[4.8815000000E+04, 5.3421697241E+01, 5.5195042053E+00, 3.6067954238E+01, 4.3932847066E+00, 9.8556067472E-01],
	[4.8820000000E+04, 5.3431484684E+01, 5.5195561466E+00, 3.6080063342E+01, 4.3935634103E+00, 9.8556647974E-01],
	[4.8825000000E+04, 5.3441272917E+01, 5.5196080831E+00, 3.6092175268E+01, 4.3938420481E+00, 9.8557228206E-01],
	[4.8830000000E+04, 5.3451061942E+01, 5.5196600148E+00, 3.6104290018E+01, 4.3941206201E+00, 9.8557808166E-01],
	[4.8835000000E+04, 5.3460851756E+01, 5.5197119416E+00, 3.6116407593E+01, 4.3943991261E+00, 9.8558387857E-01],
	[4.8840000000E+04, 5.3470642361E+01, 5.5197638636E+00, 3.6128527991E+01, 4.3946775662E+00, 9.8558967277E-01],
	[4.8845000000E+04, 5.3480433757E+01, 5.5198157808E+00, 3.6140651214E+01, 4.3949559406E+00, 9.8559546428E-01],
	[4.8850000000E+04, 5.3490225943E+01, 5.5198676932E+00, 3.6152777261E+01, 4.3952342490E+00, 9.8560125308E-01],
	[4.8855000000E+04, 5.3500018920E+01, 5.5199196007E+00, 3.6164906135E+01, 4.3955124917E+00, 9.8560703919E-01],
	[4.8860000000E+04, 5.3509812686E+01, 5.5199715034E+00, 3.6177037834E+01, 4.3957906686E+00, 9.8561282260E-01],
	[4.8865000000E+04, 5.3519607244E+01, 5.5200234013E+00, 3.6189172358E+01, 4.3960687797E+00, 9.8561860331E-01],
	[4.8870000000E+04, 5.3529402592E+01, 5.5200752944E+00, 3.6201309710E+01, 4.3963468251E+00, 9.8562438133E-01],
	[4.8875000000E+04, 5.3539198730E+01, 5.5201271826E+00, 3.6213449888E+01, 4.3966248047E+00, 9.8563015666E-01],
	[4.8880000000E+04, 5.3548995658E+01, 5.5201790661E+00, 3.6225592894E+01, 4.3969027186E+00, 9.8563592930E-01],
	[4.8885000000E+04, 5.3558793377E+01, 5.5202309447E+00, 3.6237738727E+01, 4.3971805668E+00, 9.8564169925E-01],
	[4.8890000000E+04, 5.3568591886E+01, 5.5202828185E+00, 3.6249887388E+01, 4.3974583493E+00, 9.8564746651E-01],
	[4.8895000000E+04, 5.3578391185E+01, 5.5203346874E+00, 3.6262038877E+01, 4.3977360662E+00, 9.8565323108E-01],
	[4.8900000000E+04, 5.3588191275E+01, 5.5203865516E+00, 3.6274193195E+01, 4.3980137174E+00, 9.8565899297E-01],
	[4.8905000000E+04, 5.3597992155E+01, 5.5204384109E+00, 3.6286350342E+01, 4.3982913030E+00, 9.8566475217E-01],
	[4.8910000000E+04, 5.3607793825E+01, 5.5204902654E+00, 3.6298510318E+01, 4.3985688230E+00, 9.8567050870E-01],
	[4.8915000000E+04, 5.3617596286E+01, 5.5205421152E+00, 3.6310673124E+01, 4.3988462774E+00, 9.8567626254E-01],
	[4.8920000000E+04, 5.3627399536E+01, 5.5205939601E+00, 3.6322838760E+01, 4.3991236663E+00, 9.8568201370E-01],
	[4.8925000000E+04, 5.3637203577E+01, 5.5206458001E+00, 3.6335007227E+01, 4.3994009896E+00, 9.8568776218E-01],
	[4.8930000000E+04, 5.3647008408E+01, 5.5206976354E+00, 3.6347178524E+01, 4.3996782474E+00, 9.8569350799E-01],
	[4.8935000000E+04, 5.3656814029E+01, 5.5207494659E+00, 3.6359352653E+01, 4.3999554396E+00, 9.8569925112E-01],
	[4.8940000000E+04, 5.3666620441E+01, 5.5208012915E+00, 3.6371529614E+01, 4.4002325664E+00, 9.8570499158E-01],
	[4.8945000000E+04, 5.3676427642E+01, 5.5208531124E+00, 3.6383709406E+01, 4.4005096277E+00, 9.8571072936E-01],
	[4.8950000000E+04, 5.3686235634E+01, 5.5209049284E+00, 3.6395892031E+01, 4.4007866236E+00, 9.8571646448E-01],
	[4.8955000000E+04, 5.3696044416E+01, 5.5209567397E+00, 3.6408077488E+01, 4.4010635540E+00, 9.8572219692E-01],
	[4.8960000000E+04, 5.3705853987E+01, 5.5210085461E+00, 3.6420265779E+01, 4.4013404190E+00, 9.8572792669E-01],
	[4.8965000000E+04, 5.3715664349E+01, 5.5210603477E+00, 3.6432456903E+01, 4.4016172186E+00, 9.8573365380E-01],
	[4.8970000000E+04, 5.3725475501E+01, 5.5211121445E+00, 3.6444650861E+01, 4.4018939528E+00, 9.8573937824E-01],
	[4.8975000000E+04, 5.3735287443E+01, 5.5211639365E+00, 3.6456847653E+01, 4.4021706217E+00, 9.8574510002E-01],
	[4.8980000000E+04, 5.3745100175E+01, 5.5212157238E+00, 3.6469047280E+01, 4.4024472252E+00, 9.8575081914E-01],
	[4.8985000000E+04, 5.3754913697E+01, 5.5212675062E+00, 3.6481249741E+01, 4.4027237634E+00, 9.8575653559E-01],
	[4.8990000000E+04, 5.3764728009E+01, 5.5213192838E+00, 3.6493455038E+01, 4.4030002363E+00, 9.8576224938E-01],
	[4.8995000000E+04, 5.3774543111E+01, 5.5213710566E+00, 3.6505663170E+01, 4.4032766439E+00, 9.8576796052E-01],
	[4.9000000000E+04, 5.3784359003E+01, 5.5214228246E+00, 3.6517874139E+01, 4.4035529863E+00, 9.8577366899E-01],
	[4.9005000000E+04, 5.3794175684E+01, 5.5214745879E+00, 3.6530087944E+01, 4.4038292634E+00, 9.8577937481E-01],
	[4.9010000000E+04, 5.3803993156E+01, 5.5215263463E+00, 3.6542304586E+01, 4.4041054753E+00, 9.8578507798E-01],
	[4.9015000000E+04, 5.3813811417E+01, 5.5215780999E+00, 3.6554524065E+01, 4.4043816219E+00, 9.8579077849E-01],
	[4.9020000000E+04, 5.3823630469E+01, 5.5216298488E+00, 3.6566746381E+01, 4.4046577034E+00, 9.8579647635E-01],
	[4.9025000000E+04, 5.3833450310E+01, 5.5216815928E+00, 3.6578971535E+01, 4.4049337197E+00, 9.8580217156E-01],
	[4.9030000000E+04, 5.3843270941E+01, 5.5217333320E+00, 3.6591199528E+01, 4.4052096709E+00, 9.8580786412E-01],
	[4.9035000000E+04, 5.3853092362E+01, 5.5217850665E+00, 3.6603430359E+01, 4.4054855569E+00, 9.8581355404E-01],
	[4.9040000000E+04, 5.3862914573E+01, 5.5218367962E+00, 3.6615664029E+01, 4.4057613778E+00, 9.8581924130E-01],
	[4.9045000000E+04, 5.3872737574E+01, 5.5218885211E+00, 3.6627900538E+01, 4.4060371336E+00, 9.8582492593E-01],
	[4.9050000000E+04, 5.3882561364E+01, 5.5219402412E+00, 3.6640139888E+01, 4.4063128243E+00, 9.8583060790E-01],
	[4.9055000000E+04, 5.3892385944E+01, 5.5219919565E+00, 3.6652382077E+01, 4.4065884499E+00, 9.8583628724E-01],
	[4.9060000000E+04, 5.3902211314E+01, 5.5220436670E+00, 3.6664627107E+01, 4.4068640106E+00, 9.8584196394E-01],
	[4.9065000000E+04, 5.3912037473E+01, 5.5220953727E+00, 3.6676874977E+01, 4.4071395062E+00, 9.8584763799E-01],
	[4.9070000000E+04, 5.3921872979E+01, 5.5221478870E+00, 3.6689125689E+01, 4.4074155120E+00, 9.8585330941E-01],
	[4.9075000000E+04, 5.3931718698E+01, 5.5222012917E+00, 3.6701379242E+01, 4.4076920862E+00, 9.8585897819E-01],
	[4.9080000000E+04, 5.3941565212E+01, 5.5222546915E+00, 3.6713635638E+01, 4.4079685957E+00, 9.8586464434E-01],
	[4.9085000000E+04, 5.3951412520E+01, 5.5223080864E+00, 3.6725894875E+01, 4.4082450402E+00, 9.8587030785E-01],
	[4.9090000000E+04, 5.3961260622E+01, 5.5223614764E+00, 3.6738156956E+01, 4.4085214200E+00, 9.8587596873E-01],
	[4.9095000000E+04, 5.3971109519E+01, 5.5224148615E+00, 3.6750421879E+01, 4.4087977349E+00, 9.8588162698E-01],
	[4.9100000000E+04, 5.3980959210E+01, 5.5224682416E+00, 3.6762689646E+01, 4.4090739851E+00, 9.8588728259E-01],
	[4.9105000000E+04, 5.3990809695E+01, 5.5225216168E+00, 3.6774960256E+01, 4.4093501705E+00, 9.8589293558E-01],
	[4.9110000000E+04, 5.4000660974E+01, 5.5225749871E+00, 3.6787233711E+01, 4.4096262912E+00, 9.8589858595E-01],
	[4.9115000000E+04, 5.4010513048E+01, 5.5226283525E+00, 3.6799510010E+01, 4.4099023472E+00, 9.8590423368E-01],
	[4.9120000000E+04, 5.4020365916E+01, 5.5226817129E+00, 3.6811789154E+01, 4.4101783384E+00, 9.8590987880E-01],
	[4.9125000000E+04, 5.4030219579E+01, 5.5227350685E+00, 3.6824071143E+01, 4.4104542650E+00, 9.8591552129E-01],
	[4.9130000000E+04, 5.4040074035E+01, 5.5227884191E+00, 3.6836355978E+01, 4.4107301269E+00, 9.8592116116E-01],
	[4.9135000000E+04, 5.4049929286E+01, 5.5228417648E+00, 3.6848643659E+01, 4.4110059241E+00, 9.8592679840E-01],
	[4.9140000000E+04, 5.4059785331E+01, 5.5228951056E+00, 3.6860934187E+01, 4.4112816567E+00, 9.8593243303E-01],
	[4.9145000000E+04, 5.4069642170E+01, 5.5229484415E+00, 3.6873227561E+01, 4.4115573247E+00, 9.8593806505E-01],
	[4.9150000000E+04, 5.4079499804E+01, 5.5230017725E+00, 3.6885523782E+01, 4.4118329282E+00, 9.8594369444E-01],
	[4.9155000000E+04, 5.4089358231E+01, 5.5230550986E+00, 3.6897822851E+01, 4.4121084670E+00, 9.8594932122E-01],
	[4.9160000000E+04, 5.4099217453E+01, 5.5231084197E+00, 3.6910124767E+01, 4.4123839413E+00, 9.8595494539E-01],
	[4.9165000000E+04, 5.4109077468E+01, 5.5231617360E+00, 3.6922429532E+01, 4.4126593510E+00, 9.8596056695E-01],
	[4.9170000000E+04, 5.4118938278E+01, 5.5232150473E+00, 3.6934737145E+01, 4.4129346963E+00, 9.8596618589E-01],
	[4.9175000000E+04, 5.4128799882E+01, 5.5232683538E+00, 3.6947047607E+01, 4.4132099770E+00, 9.8597180223E-01],
	[4.9180000000E+04, 5.4138662280E+01, 5.5233216553E+00, 3.6959360919E+01, 4.4134851932E+00, 9.8597741596E-01],
	[4.9185000000E+04, 5.4148525472E+01, 5.5233749519E+00, 3.6971677080E+01, 4.4137603450E+00, 9.8598302708E-01],
	[4.9190000000E+04, 5.4158389458E+01, 5.5234282437E+00, 3.6983996092E+01, 4.4140354323E+00, 9.8598863560E-01],
	[4.9195000000E+04, 5.4168254238E+01, 5.5234815305E+00, 3.6996317953E+01, 4.4143104552E+00, 9.8599424151E-01],
	[4.9200000000E+04, 5.4178119812E+01, 5.5235348124E+00, 3.7008642666E+01, 4.4145854137E+00, 9.8599984482E-01],
	[4.9205000000E+04, 5.4187986180E+01, 5.5235880894E+00, 3.7020970230E+01, 4.4148603078E+00, 9.8600544553E-01],
	[4.9210000000E+04, 5.4197853342E+01, 5.5236413615E+00, 3.7033300645E+01, 4.4151351376E+00, 9.8601104364E-01],
	[4.9215000000E+04, 5.4207721298E+01, 5.5236946288E+00, 3.7045633912E+01, 4.4154099030E+00, 9.8601663915E-01],
	[4.9220000000E+04, 5.4217590048E+01, 5.5237478911E+00, 3.7057970031E+01, 4.4156846040E+00, 9.8602223207E-01],
	[4.9225000000E+04, 5.4227459592E+01, 5.5238011485E+00, 3.7070309003E+01, 4.4159592407E+00, 9.8602782238E-01],
	[4.9230000000E+04, 5.4237329930E+01, 5.5238544011E+00, 3.7082650828E+01, 4.4162338132E+00, 9.8603341011E-01],
	[4.9235000000E+04, 5.4247201061E+01, 5.5239076487E+00, 3.7094995507E+01, 4.4165083213E+00, 9.8603899524E-01],
	[4.9240000000E+04, 5.4257072987E+01, 5.5239608914E+00, 3.7107343039E+01, 4.4167827652E+00, 9.8604457778E-01],
	[4.9245000000E+04, 5.4266945706E+01, 5.5240141293E+00, 3.7119693425E+01, 4.4170571448E+00, 9.8605015773E-01],
	[4.9250000000E+04, 5.4276819219E+01, 5.5240673622E+00, 3.7132046666E+01, 4.4173314603E+00, 9.8605573509E-01],
	[4.9255000000E+04, 5.4286693526E+01, 5.5241205903E+00, 3.7144402762E+01, 4.4176057115E+00, 9.8606130987E-01],
	[4.9260000000E+04, 5.4296568627E+01, 5.5241738135E+00, 3.7156761713E+01, 4.4178798985E+00, 9.8606688206E-01],
	[4.9265000000E+04, 5.4306444521E+01, 5.5242270318E+00, 3.7169123519E+01, 4.4181540214E+00, 9.8607245166E-01],
	[4.9270000000E+04, 5.4316321209E+01, 5.5242802452E+00, 3.7181488182E+01, 4.4184280801E+00, 9.8607801868E-01],
	[4.9275000000E+04, 5.4326198691E+01, 5.5243334537E+00, 3.7193855701E+01, 4.4187020747E+00, 9.8608358312E-01],
	[4.9280000000E+04, 5.4336076967E+01, 5.5243866573E+00, 3.7206226076E+01, 4.4189760051E+00, 9.8608914498E-01],
	[4.9285000000E+04, 5.4345956036E+01, 5.5244398560E+00, 3.7218599309E+01, 4.4192498715E+00, 9.8609470426E-01],
	[4.9290000000E+04, 5.4355835900E+01, 5.5244930499E+00, 3.7230975399E+01, 4.4195236738E+00, 9.8610026096E-01],
	[4.9295000000E+04, 5.4365716556E+01, 5.5245462389E+00, 3.7243354346E+01, 4.4197974120E+00, 9.8610581508E-01],
	[4.9300000000E+04, 5.4375598007E+01, 5.5245994230E+00, 3.7255736153E+01, 4.4200710862E+00, 9.8611136663E-01],
	[4.9305000000E+04, 5.4385480251E+01, 5.5246526022E+00, 3.7268120817E+01, 4.4203446964E+00, 9.8611691561E-01],
	[4.9310000000E+04, 5.4395363289E+01, 5.5247057765E+00, 3.7280508341E+01, 4.4206182425E+00, 9.8612246201E-01],
	[4.9315000000E+04, 5.4405247120E+01, 5.5247589459E+00, 3.7292898723E+01, 4.4208917247E+00, 9.8612800584E-01],
	[4.9320000000E+04, 5.4415131745E+01, 5.5248121105E+00, 3.7305291966E+01, 4.4211651429E+00, 9.8613354710E-01],
	[4.9325000000E+04, 5.4425017163E+01, 5.5248652702E+00, 3.7317688068E+01, 4.4214384971E+00, 9.8613908580E-01],
	[4.9330000000E+04, 5.4434903375E+01, 5.5249184250E+00, 3.7330087031E+01, 4.4217117875E+00, 9.8614462192E-01],
	[4.9335000000E+04, 5.4444790381E+01, 5.5249715749E+00, 3.7342488855E+01, 4.4219850139E+00, 9.8615015548E-01],
	[4.9340000000E+04, 5.4454678180E+01, 5.5250247200E+00, 3.7354893540E+01, 4.4222581764E+00, 9.8615568648E-01],
	[4.9345000000E+04, 5.4464566773E+01, 5.5250778602E+00, 3.7367301086E+01, 4.4225312750E+00, 9.8616121491E-01],
	[4.9350000000E+04, 5.4474456159E+01, 5.5251309955E+00, 3.7379711494E+01, 4.4228043098E+00, 9.8616674079E-01],
	[4.9355000000E+04, 5.4484346338E+01, 5.5251841259E+00, 3.7392124764E+01, 4.4230772808E+00, 9.8617226410E-01],
	[4.9360000000E+04, 5.4494237311E+01, 5.5252372515E+00, 3.7404540897E+01, 4.4233501879E+00, 9.8617778485E-01],
	[4.9365000000E+04, 5.4504129078E+01, 5.5252903722E+00, 3.7416959894E+01, 4.4236230312E+00, 9.8618330305E-01],
	[4.9370000000E+04, 5.4514021638E+01, 5.5253434880E+00, 3.7429381753E+01, 4.4238958108E+00, 9.8618881868E-01],
	[4.9375000000E+04, 5.4523914991E+01, 5.5253965990E+00, 3.7441806476E+01, 4.4241685265E+00, 9.8619433177E-01],
	[4.9380000000E+04, 5.4533809138E+01, 5.5254497051E+00, 3.7454234063E+01, 4.4244411786E+00, 9.8619984230E-01],
	[4.9385000000E+04, 5.4543704078E+01, 5.5255028063E+00, 3.7466664515E+01, 4.4247137668E+00, 9.8620535028E-01],
	[4.9390000000E+04, 5.4553599811E+01, 5.5255559027E+00, 3.7479097831E+01, 4.4249862914E+00, 9.8621085570E-01],
	[4.9395000000E+04, 5.4563496338E+01, 5.5256089942E+00, 3.7491534013E+01, 4.4252587523E+00, 9.8621635858E-01],
	[4.9400000000E+04, 5.4573393658E+01, 5.5256620808E+00, 3.7503973060E+01, 4.4255311495E+00, 9.8622185891E-01],
	[4.9405000000E+04, 5.4583291772E+01, 5.5257151626E+00, 3.7516414973E+01, 4.4258034831E+00, 9.8622735670E-01],
	[4.9410000000E+04, 5.4593190679E+01, 5.5257682395E+00, 3.7528859753E+01, 4.4260757530E+00, 9.8623285193E-01],
	[4.9415000000E+04, 5.4603090379E+01, 5.5258213115E+00, 3.7541307399E+01, 4.4263479593E+00, 9.8623834463E-01],
	[4.9420000000E+04, 5.4612990872E+01, 5.5258743787E+00, 3.7553757912E+01, 4.4266201020E+00, 9.8624383478E-01],
	[4.9425000000E+04, 5.4622892158E+01, 5.5259274411E+00, 3.7566211293E+01, 4.4268921811E+00, 9.8624932239E-01],
	[4.9430000000E+04, 5.4632794238E+01, 5.5259804985E+00, 3.7578667542E+01, 4.4271641967E+00, 9.8625480746E-01],
	[4.9435000000E+04, 5.4642697111E+01, 5.5260335511E+00, 3.7591126658E+01, 4.4274361486E+00, 9.8626028999E-01],
	[4.9440000000E+04, 5.4652600777E+01, 5.5260865989E+00, 3.7603588643E+01, 4.4277080371E+00, 9.8626576998E-01],
	[4.9445000000E+04, 5.4662505236E+01, 5.5261396418E+00, 3.7616053497E+01, 4.4279798621E+00, 9.8627124744E-01],
	[4.9450000000E+04, 5.4672410489E+01, 5.5261926798E+00, 3.7628521221E+01, 4.4282516235E+00, 9.8627672236E-01],
	[4.9455000000E+04, 5.4682316535E+01, 5.5262457130E+00, 3.7640991814E+01, 4.4285233215E+00, 9.8628219475E-01],
	[4.9460000000E+04, 5.4692223373E+01, 5.5262987414E+00, 3.7653465277E+01, 4.4287949561E+00, 9.8628766461E-01],
	[4.9465000000E+04, 5.4702131005E+01, 5.5263517649E+00, 3.7665941610E+01, 4.4290665272E+00, 9.8629313193E-01],
	[4.9470000000E+04, 5.4712039430E+01, 5.5264047835E+00, 3.7678420814E+01, 4.4293380348E+00, 9.8629859673E-01],
	[4.9475000000E+04, 5.4721948648E+01, 5.5264577973E+00, 3.7690902889E+01, 4.4296094791E+00, 9.8630405900E-01],
	[4.9480000000E+04, 5.4731858659E+01, 5.5265108062E+00, 3.7703387836E+01, 4.4298808600E+00, 9.8630951874E-01],
	[4.9485000000E+04, 5.4741769463E+01, 5.5265638103E+00, 3.7715875655E+01, 4.4301521775E+00, 9.8631497596E-01],
	[4.9490000000E+04, 5.4751681060E+01, 5.5266168096E+00, 3.7728366346E+01, 4.4304234317E+00, 9.8632043065E-01],
	[4.9495000000E+04, 5.4761593450E+01, 5.5266698040E+00, 3.7740859909E+01, 4.4306946226E+00, 9.8632588282E-01],
	[4.9500000000E+04, 5.4771506634E+01, 5.5267227935E+00, 3.7753356345E+01, 4.4309657501E+00, 9.8633133247E-01],
	[4.9505000000E+04, 5.4781420610E+01, 5.5267757782E+00, 3.7765855655E+01, 4.4312368143E+00, 9.8633677960E-01],
	[4.9510000000E+04, 5.4791335379E+01, 5.5268287581E+00, 3.7778357838E+01, 4.4315078153E+00, 9.8634222421E-01],
	[4.9515000000E+04, 5.4801250941E+01, 5.5268817331E+00, 3.7790862896E+01, 4.4317787530E+00, 9.8634766630E-01],
	[4.9520000000E+04, 5.4811167296E+01, 5.5269347033E+00, 3.7803370828E+01, 4.4320496275E+00, 9.8635310588E-01],
	[4.9525000000E+04, 5.4821084443E+01, 5.5269876686E+00, 3.7815881635E+01, 4.4323204388E+00, 9.8635854294E-01],
	[4.9530000000E+04, 5.4831002384E+01, 5.5270406291E+00, 3.7828395316E+01, 4.4325911868E+00, 9.8636397749E-01],
	[4.9535000000E+04, 5.4840921118E+01, 5.5270935848E+00, 3.7840911874E+01, 4.4328618717E+00, 9.8636940953E-01],
	[4.9540000000E+04, 5.4850840644E+01, 5.5271465356E+00, 3.7853431307E+01, 4.4331324934E+00, 9.8637483905E-01],
	[4.9545000000E+04, 5.4860760964E+01, 5.5271994816E+00, 3.7865953617E+01, 4.4334030520E+00, 9.8638026607E-01],
	[4.9550000000E+04, 5.4870682076E+01, 5.5272524227E+00, 3.7878478803E+01, 4.4336735474E+00, 9.8638569058E-01],
	[4.9555000000E+04, 5.4880603981E+01, 5.5273053591E+00, 3.7891006867E+01, 4.4339439797E+00, 9.8639111258E-01],
	[4.9560000000E+04, 5.4890526678E+01, 5.5273582905E+00, 3.7903537808E+01, 4.4342143489E+00, 9.8639653208E-01],
	[4.9565000000E+04, 5.4900450169E+01, 5.5274112172E+00, 3.7916071626E+01, 4.4344846551E+00, 9.8640194907E-01],
	[4.9570000000E+04, 5.4910374452E+01, 5.5274641390E+00, 3.7928608323E+01, 4.4347548982E+00, 9.8640736356E-01],
	[4.9575000000E+04, 5.4920299528E+01, 5.5275170560E+00, 3.7941147898E+01, 4.4350250782E+00, 9.8641277555E-01],
	[4.9580000000E+04, 5.4930225397E+01, 5.5275699682E+00, 3.7953690352E+01, 4.4352951952E+00, 9.8641818504E-01],
	[4.9585000000E+04, 5.4940152058E+01, 5.5276228755E+00, 3.7966235686E+01, 4.4355652493E+00, 9.8642359203E-01],
	[4.9590000000E+04, 5.4950079512E+01, 5.5276757780E+00, 3.7978783899E+01, 4.4358352403E+00, 9.8642899652E-01],
	[4.9595000000E+04, 5.4960007759E+01, 5.5277286756E+00, 3.7991334992E+01, 4.4361051684E+00, 9.8643439852E-01],
	[4.9600000000E+04, 5.4969936799E+01, 5.5277815685E+00, 3.8003888965E+01, 4.4363750335E+00, 9.8643979802E-01],
	[4.9605000000E+04, 5.4979866631E+01, 5.5278344565E+00, 3.8016445819E+01, 4.4366448357E+00, 9.8644519503E-01],
	[4.9610000000E+04, 5.4989797255E+01, 5.5278873397E+00, 3.8029005555E+01, 4.4369145750E+00, 9.8645058954E-01],
	[4.9615000000E+04, 5.4999728673E+01, 5.5279402181E+00, 3.8041568171E+01, 4.4371842514E+00, 9.8645598157E-01],
	[4.9620000000E+04, 5.5009660883E+01, 5.5279930916E+00, 3.8054133670E+01, 4.4374538649E+00, 9.8646137111E-01],
	[4.9625000000E+04, 5.5019593885E+01, 5.5280459603E+00, 3.8066702051E+01, 4.4377234156E+00, 9.8646675815E-01],
	[4.9630000000E+04, 5.5029527680E+01, 5.5280988243E+00, 3.8079273314E+01, 4.4379929034E+00, 9.8647214271E-01],
	[4.9635000000E+04, 5.5039462268E+01, 5.5281516833E+00, 3.8091847460E+01, 4.4382623284E+00, 9.8647752479E-01],
	[4.9640000000E+04, 5.5049397648E+01, 5.5282045376E+00, 3.8104424490E+01, 4.4385316906E+00, 9.8648290438E-01],
	[4.9645000000E+04, 5.5059333821E+01, 5.5282573871E+00, 3.8117004403E+01, 4.4388009900E+00, 9.8648828149E-01],
	[4.9650000000E+04, 5.5069270786E+01, 5.5283102317E+00, 3.8129587201E+01, 4.4390702266E+00, 9.8649365612E-01],
	[4.9655000000E+04, 5.5079208543E+01, 5.5283630715E+00, 3.8142172883E+01, 4.4393394005E+00, 9.8649902827E-01],
	[4.9660000000E+04, 5.5089147093E+01, 5.5284159065E+00, 3.8154761449E+01, 4.4396085117E+00, 9.8650439793E-01],
	[4.9665000000E+04, 5.5099086436E+01, 5.5284687367E+00, 3.8167352901E+01, 4.4398775601E+00, 9.8650976513E-01],
	[4.9670000000E+04, 5.5109026571E+01, 5.5285215620E+00, 3.8179947238E+01, 4.4401465458E+00, 9.8651512984E-01],
	[4.9675000000E+04, 5.5118967498E+01, 5.5285743826E+00, 3.8192544462E+01, 4.4404154689E+00, 9.8652049208E-01],
	[4.9680000000E+04, 5.5128909218E+01, 5.5286271983E+00, 3.8205144571E+01, 4.4406843293E+00, 9.8652585185E-01],
	[4.9685000000E+04, 5.5138851730E+01, 5.5286800093E+00, 3.8217747567E+01, 4.4409531271E+00, 9.8653120914E-01],
	[4.9690000000E+04, 5.5148795035E+01, 5.5287328154E+00, 3.8230353451E+01, 4.4412218622E+00, 9.8653656396E-01],
	[4.9695000000E+04, 5.5158739131E+01, 5.5287856167E+00, 3.8242962221E+01, 4.4414905348E+00, 9.8654191632E-01],
	[4.9700000000E+04, 5.5168684021E+01, 5.5288384132E+00, 3.8255573880E+01, 4.4417591447E+00, 9.8654726620E-01],
	[4.9705000000E+04, 5.5178629702E+01, 5.5288912049E+00, 3.8268188426E+01, 4.4420276921E+00, 9.8655261362E-01],
	[4.9710000000E+04, 5.5188576176E+01, 5.5289439918E+00, 3.8280805861E+01, 4.4422961769E+00, 9.8655795857E-01],
	[4.9715000000E+04, 5.5198523442E+01, 5.5289967739E+00, 3.8293426185E+01, 4.4425645992E+00, 9.8656330106E-01],
	[4.9720000000E+04, 5.5208471500E+01, 5.5290495512E+00, 3.8306049398E+01, 4.4428329590E+00, 9.8656864108E-01],
	[4.9725000000E+04, 5.5218420351E+01, 5.5291023237E+00, 3.8318675501E+01, 4.4431012563E+00, 9.8657397865E-01],
	[4.9730000000E+04, 5.5228369993E+01, 5.5291550914E+00, 3.8331304494E+01, 4.4433694911E+00, 9.8657931375E-01],
	[4.9735000000E+04, 5.5238320428E+01, 5.5292078542E+00, 3.8343936377E+01, 4.4436376634E+00, 9.8658464639E-01],
	[4.9740000000E+04, 5.5248271655E+01, 5.5292606123E+00, 3.8356571151E+01, 4.4439057733E+00, 9.8658997658E-01],
	[4.9745000000E+04, 5.5258223675E+01, 5.5293133656E+00, 3.8369208816E+01, 4.4441738208E+00, 9.8659530430E-01],
	[4.9750000000E+04, 5.5268176486E+01, 5.5293661141E+00, 3.8381849373E+01, 4.4444418058E+00, 9.8660062958E-01],
	[4.9755000000E+04, 5.5278130090E+01, 5.5294188577E+00, 3.8394492821E+01, 4.4447097285E+00, 9.8660595240E-01],
	[4.9760000000E+04, 5.5288084486E+01, 5.5294715966E+00, 3.8407139161E+01, 4.4449775888E+00, 9.8661127277E-01],
	[4.9765000000E+04, 5.5298039673E+01, 5.5295243307E+00, 3.8419788395E+01, 4.4452453867E+00, 9.8661659068E-01],
	[4.9770000000E+04, 5.5307995653E+01, 5.5295770600E+00, 3.8432440521E+01, 4.4455131223E+00, 9.8662190615E-01],
	[4.9775000000E+04, 5.5317952425E+01, 5.5296297845E+00, 3.8445095540E+01, 4.4457807956E+00, 9.8662721916E-01],
	[4.9780000000E+04, 5.5327909990E+01, 5.5296825042E+00, 3.8457753453E+01, 4.4460484066E+00, 9.8663252973E-01],
	[4.9785000000E+04, 5.5337868346E+01, 5.5297352191E+00, 3.8470414260E+01, 4.4463159553E+00, 9.8663783786E-01],
	[4.9790000000E+04, 5.5347827494E+01, 5.5297879292E+00, 3.8483077962E+01, 4.4465834417E+00, 9.8664314354E-01],
	[4.9795000000E+04, 5.5357787434E+01, 5.5298406346E+00, 3.8495744558E+01, 4.4468508659E+00, 9.8664844677E-01],
	[4.9800000000E+04, 5.5367748166E+01, 5.5298933351E+00, 3.8508414050E+01, 4.4471182279E+00, 9.8665374756E-01],
	[4.9805000000E+04, 5.5377709690E+01, 5.5299460308E+00, 3.8521086437E+01, 4.4473855276E+00, 9.8665904592E-01],
	[4.9810000000E+04, 5.5387672007E+01, 5.5299987218E+00, 3.8533761720E+01, 4.4476527652E+00, 9.8666434183E-01],
	[4.9815000000E+04, 5.5397635115E+01, 5.5300514080E+00, 3.8546439899E+01, 4.4479199405E+00, 9.8666963530E-01],
	[4.9820000000E+04, 5.5407599015E+01, 5.5301040894E+00, 3.8559120975E+01, 4.4481870538E+00, 9.8667492634E-01],
	[4.9825000000E+04, 5.5417563707E+01, 5.5301567660E+00, 3.8571804948E+01, 4.4484541048E+00, 9.8668021494E-01],
	[4.9830000000E+04, 5.5427529190E+01, 5.5302094378E+00, 3.8584491818E+01, 4.4487210938E+00, 9.8668550111E-01],
	[4.9835000000E+04, 5.5437495466E+01, 5.5302621048E+00, 3.8597181586E+01, 4.4489880207E+00, 9.8669078485E-01],
	[4.9840000000E+04, 5.5447462534E+01, 5.5303147671E+00, 3.8609874253E+01, 4.4492548854E+00, 9.8669606615E-01],
	[4.9845000000E+04, 5.5457430393E+01, 5.5303674246E+00, 3.8622569818E+01, 4.4495216881E+00, 9.8670134502E-01],
	[4.9850000000E+04, 5.5467399044E+01, 5.5304200773E+00, 3.8635268281E+01, 4.4497884288E+00, 9.8670662146E-01],
	[4.9855000000E+04, 5.5477368487E+01, 5.5304727252E+00, 3.8647969644E+01, 4.4500551074E+00, 9.8671189548E-01],
	[4.9860000000E+04, 5.5487347559E+01, 5.5305261911E+00, 3.8660673907E+01, 4.4503223136E+00, 9.8671716707E-01],
	[4.9865000000E+04, 5.5497336566E+01, 5.5305805031E+00, 3.8673381069E+01, 4.4505900677E+00, 9.8672243623E-01],
	[4.9870000000E+04, 5.5507326370E+01, 5.5306348102E+00, 3.8686091132E+01, 4.4508577600E+00, 9.8672770297E-01],
	[4.9875000000E+04, 5.5517316970E+01, 5.5306891123E+00, 3.8698804096E+01, 4.4511253903E+00, 9.8673296729E-01],
	[4.9880000000E+04, 5.5527308366E+01, 5.5307434096E+00, 3.8711519960E+01, 4.4513929588E+00, 9.8673822918E-01],
	[4.9885000000E+04, 5.5537300559E+01, 5.5307977020E+00, 3.8724238727E+01, 4.4516604656E+00, 9.8674348866E-01],
	[4.9890000000E+04, 5.5547293548E+01, 5.5308519894E+00, 3.8736960395E+01, 4.4519279105E+00, 9.8674874572E-01],
	[4.9895000000E+04, 5.5557287333E+01, 5.5309062719E+00, 3.8749684965E+01, 4.4521952936E+00, 9.8675400036E-01],
	[4.9900000000E+04, 5.5567281915E+01, 5.5309605496E+00, 3.8762412438E+01, 4.4524626149E+00, 9.8675925258E-01],
	[4.9905000000E+04, 5.5577277293E+01, 5.5310148223E+00, 3.8775142813E+01, 4.4527298745E+00, 9.8676450239E-01],
	[4.9910000000E+04, 5.5587273467E+01, 5.5310690901E+00, 3.8787876093E+01, 4.4529970724E+00, 9.8676974978E-01],
	[4.9915000000E+04, 5.5597270437E+01, 5.5311233530E+00, 3.8800612275E+01, 4.4532642085E+00, 9.8677499476E-01],
	[4.9920000000E+04, 5.5607268204E+01, 5.5311776110E+00, 3.8813351362E+01, 4.4535312830E+00, 9.8678023733E-01],
	[4.9925000000E+04, 5.5617266767E+01, 5.5312318641E+00, 3.8826093354E+01, 4.4537982958E+00, 9.8678547749E-01],
	[4.9930000000E+04, 5.5627266127E+01, 5.5312861123E+00, 3.8838838250E+01, 4.4540652469E+00, 9.8679071525E-01],
	[4.9935000000E+04, 5.5637266282E+01, 5.5313403556E+00, 3.8851586051E+01, 4.4543321364E+00, 9.8679595059E-01],
	[4.9940000000E+04, 5.5647267234E+01, 5.5313945940E+00, 3.8864336758E+01, 4.4545989642E+00, 9.8680118353E-01],
	[4.9945000000E+04, 5.5657268982E+01, 5.5314488275E+00, 3.8877090371E+01, 4.4548657305E+00, 9.8680641407E-01],
	[4.9950000000E+04, 5.5667271526E+01, 5.5315030561E+00, 3.8889846890E+01, 4.4551324351E+00, 9.8681164220E-01],
	[4.9955000000E+04, 5.5677274866E+01, 5.5315572799E+00, 3.8902606315E+01, 4.4553990782E+00, 9.8681686793E-01],
	[4.9960000000E+04, 5.5687279002E+01, 5.5316114987E+00, 3.8915368648E+01, 4.4556656597E+00, 9.8682209126E-01],
	[4.9965000000E+04, 5.5697283935E+01, 5.5316657126E+00, 3.8928133888E+01, 4.4559321797E+00, 9.8682731219E-01],
	[4.9970000000E+04, 5.5707289663E+01, 5.5317199216E+00, 3.8940902036E+01, 4.4561986381E+00, 9.8683253072E-01],
	[4.9975000000E+04, 5.5717296188E+01, 5.5317741258E+00, 3.8953673092E+01, 4.4564650351E+00, 9.8683774685E-01],
	[4.9980000000E+04, 5.5727303509E+01, 5.5318283250E+00, 3.8966447057E+01, 4.4567313706E+00, 9.8684296059E-01],
	[4.9985000000E+04, 5.5737311626E+01, 5.5318825194E+00, 3.8979223931E+01, 4.4569976446E+00, 9.8684817194E-01],
	[4.9990000000E+04, 5.5747320538E+01, 5.5319367088E+00, 3.8992003713E+01, 4.4572638571E+00, 9.8685338089E-01],
	[4.9995000000E+04, 5.5757330247E+01, 5.5319908934E+00, 3.9004786406E+01, 4.4575300083E+00, 9.8685858745E-01],
	[5.0000000000E+04, 5.5767340752E+01, 5.5320450731E+00, 3.9017572008E+01, 4.4577960980E+00, 9.8686379162E-01],
	[5.0005000000E+04, 5.5777352053E+01, 5.5320992479E+00, 3.9030374400E+01, 4.4580623074E+00, 9.8686899340E-01],
	[5.0010000000E+04, 5.5787364150E+01, 5.5321534178E+00, 3.9043179711E+01, 4.4583284553E+00, 9.8687419279E-01],
	[5.0015000000E+04, 5.5797377042E+01, 5.5322075828E+00, 3.9055987941E+01, 4.4585945418E+00, 9.8687938980E-01],
	[5.0020000000E+04, 5.5807390731E+01, 5.5322617430E+00, 3.9068799091E+01, 4.4588605668E+00, 9.8688458442E-01],
	[5.0025000000E+04, 5.581740