import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

liver_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.7882642628E+00, 8.0478385680E+00, 2.2824519904E-02, 2.2473935265E-02, 3.4402173212E-01],
	[5.0050000000E+03, 1.7903055003E+00, 8.0429734345E+00, 2.2893162990E-02, 2.2540768510E-02, 3.4427964864E-01],
	[5.0100000000E+03, 1.7923470262E+00, 8.0381160954E+00, 2.2961943403E-02, 2.2607731435E-02, 3.4453727253E-01],
	[5.0150000000E+03, 1.7943888401E+00, 8.0332665307E+00, 2.3030861280E-02, 2.2674824151E-02, 3.4479460451E-01],
	[5.0200000000E+03, 1.7964309418E+00, 8.0284247202E+00, 2.3099916756E-02, 2.2742046770E-02, 3.4505164529E-01],
	[5.0250000000E+03, 1.7984733311E+00, 8.0235906436E+00, 2.3169109968E-02, 2.2809399403E-02, 3.4530839558E-01],
	[5.0300000000E+03, 1.8005160078E+00, 8.0187642810E+00, 2.3238441053E-02, 2.2876882159E-02, 3.4556485609E-01],
	[5.0350000000E+03, 1.8025589715E+00, 8.0139456125E+00, 2.3307910146E-02, 2.2944495151E-02, 3.4582102754E-01],
	[5.0400000000E+03, 1.8046022221E+00, 8.0091346181E+00, 2.3377517384E-02, 2.3012238488E-02, 3.4607691063E-01],
	[5.0450000000E+03, 1.8066457594E+00, 8.0043312780E+00, 2.3447262905E-02, 2.3080112282E-02, 3.4633250606E-01],
	[5.0500000000E+03, 1.8086895829E+00, 7.9995355726E+00, 2.3517146843E-02, 2.3148116643E-02, 3.4658781453E-01],
	[5.0550000000E+03, 1.8107336926E+00, 7.9947474820E+00, 2.3587169335E-02, 2.3216251681E-02, 3.4684283674E-01],
	[5.0600000000E+03, 1.8127780882E+00, 7.9899669867E+00, 2.3657330519E-02, 2.3284517507E-02, 3.4709757338E-01],
	[5.0650000000E+03, 1.8148227694E+00, 7.9851940672E+00, 2.3727630529E-02, 2.3352914231E-02, 3.4735202515E-01],
	[5.0700000000E+03, 1.8168677360E+00, 7.9804287040E+00, 2.3798069503E-02, 2.3421441965E-02, 3.4760619273E-01],
	[5.0750000000E+03, 1.8189129878E+00, 7.9756708776E+00, 2.3868647577E-02, 2.3490100817E-02, 3.4786007682E-01],
	[5.0800000000E+03, 1.8209585245E+00, 7.9709205689E+00, 2.3939364887E-02, 2.3558890898E-02, 3.4811367809E-01],
	[5.0850000000E+03, 1.8230177065E+00, 7.9662576571E+00, 2.4010221570E-02, 2.3627815266E-02, 3.4836699723E-01],
	[5.0900000000E+03, 1.8250784877E+00, 7.9616097989E+00, 2.4081217762E-02, 2.3696871397E-02, 3.4862003492E-01],
	[5.0950000000E+03, 1.8271395716E+00, 7.9569692118E+00, 2.4152353599E-02, 2.3766059119E-02, 3.4887279184E-01],
	[5.1000000000E+03, 1.8292009581E+00, 7.9523358775E+00, 2.4223629218E-02, 2.3835378540E-02, 3.4912526866E-01],
	[5.1050000000E+03, 1.8312626468E+00, 7.9477097775E+00, 2.4295044755E-02, 2.3904829770E-02, 3.4937746604E-01],
	[5.1100000000E+03, 1.8333246375E+00, 7.9430908934E+00, 2.4366600347E-02, 2.3974412920E-02, 3.4962938467E-01],
	[5.1150000000E+03, 1.8353869300E+00, 7.9384792069E+00, 2.4438296129E-02, 2.4044128100E-02, 3.4988102521E-01],
	[5.1200000000E+03, 1.8374495241E+00, 7.9338746997E+00, 2.4510132239E-02, 2.4113975419E-02, 3.5013238832E-01],
	[5.1250000000E+03, 1.8395124193E+00, 7.9292773538E+00, 2.4582108812E-02, 2.4183954987E-02, 3.5038347467E-01],
	[5.1300000000E+03, 1.8415756156E+00, 7.9246871510E+00, 2.4654225985E-02, 2.4254066913E-02, 3.5063428491E-01],
	[5.1350000000E+03, 1.8436391127E+00, 7.9201040733E+00, 2.4726483894E-02, 2.4324311309E-02, 3.5088481970E-01],
	[5.1400000000E+03, 1.8457029103E+00, 7.9155281026E+00, 2.4798882676E-02, 2.4394688282E-02, 3.5113507971E-01],
	[5.1450000000E+03, 1.8477670081E+00, 7.9109592211E+00, 2.4871422467E-02, 2.4465197943E-02, 3.5138506557E-01],
	[5.1500000000E+03, 1.8498314060E+00, 7.9063974109E+00, 2.4944103403E-02, 2.4535840400E-02, 3.5163477794E-01],
	[5.1550000000E+03, 1.8518961037E+00, 7.9018426542E+00, 2.5016925620E-02, 2.4606615764E-02, 3.5188421747E-01],
	[5.1600000000E+03, 1.8539611008E+00, 7.8972949333E+00, 2.5089889255E-02, 2.4677524144E-02, 3.5213338480E-01],
	[5.1650000000E+03, 1.8560342868E+00, 7.8928009179E+00, 2.5162994445E-02, 2.4748567510E-02, 3.5238228058E-01],
	[5.1700000000E+03, 1.8581141403E+00, 7.8883513692E+00, 2.5236241325E-02, 2.4819745633E-02, 3.5263090545E-01],
	[5.1750000000E+03, 1.8601943105E+00, 7.8839086264E+00, 2.5309630032E-02, 2.4891057131E-02, 3.5287926004E-01],
	[5.1800000000E+03, 1.8622747974E+00, 7.8794726727E+00, 2.5383160702E-02, 2.4962502112E-02, 3.5312734500E-01],
	[5.1850000000E+03, 1.8643556005E+00, 7.8750434909E+00, 2.5456833471E-02, 2.5034080685E-02, 3.5337516095E-01],
	[5.1900000000E+03, 1.8664367196E+00, 7.8706210644E+00, 2.5530648477E-02, 2.5105792959E-02, 3.5362270853E-01],
	[5.1950000000E+03, 1.8685181544E+00, 7.8662053763E+00, 2.5604605854E-02, 2.5177639044E-02, 3.5386998837E-01],
	[5.2000000000E+03, 1.8705999048E+00, 7.8617964099E+00, 2.5678705740E-02, 2.5249619048E-02, 3.5411700110E-01],
	[5.2050000000E+03, 1.8726819705E+00, 7.8573941485E+00, 2.5752948271E-02, 2.5321733080E-02, 3.5436374733E-01],
	[5.2100000000E+03, 1.8747643511E+00, 7.8529985754E+00, 2.5827333582E-02, 2.5393981249E-02, 3.5461022769E-01],
	[5.2150000000E+03, 1.8768470465E+00, 7.8486096741E+00, 2.5901861811E-02, 2.5466363664E-02, 3.5485644281E-01],
	[5.2200000000E+03, 1.8789300563E+00, 7.8442274282E+00, 2.5976533094E-02, 2.5538880433E-02, 3.5510239330E-01],
	[5.2250000000E+03, 1.8810133804E+00, 7.8398518211E+00, 2.6051347566E-02, 2.5611531666E-02, 3.5534807978E-01],
	[5.2300000000E+03, 1.8830970185E+00, 7.8354828364E+00, 2.6126305365E-02, 2.5684317469E-02, 3.5559350286E-01],
	[5.2350000000E+03, 1.8851809703E+00, 7.8311204579E+00, 2.6201406627E-02, 2.5757237953E-02, 3.5583866315E-01],
	[5.2400000000E+03, 1.8872652356E+00, 7.8267646692E+00, 2.6276651487E-02, 2.5830293225E-02, 3.5608356127E-01],
	[5.2450000000E+03, 1.8893498141E+00, 7.8224154540E+00, 2.6352040082E-02, 2.5903483394E-02, 3.5632819781E-01],
	[5.2500000000E+03, 1.8914476139E+00, 7.8181483551E+00, 2.6427572548E-02, 2.5976811836E-02, 3.5657257339E-01],
	[5.2550000000E+03, 1.8935466717E+00, 7.8138930712E+00, 2.6503249022E-02, 2.6050275657E-02, 3.5681668861E-01],
	[5.2600000000E+03, 1.8956460594E+00, 7.8096441470E+00, 2.6579069640E-02, 2.6123874731E-02, 3.5706054408E-01],
	[5.2650000000E+03, 1.8977457767E+00, 7.8054015669E+00, 2.6655034539E-02, 2.6197609167E-02, 3.5730414038E-01],
	[5.2700000000E+03, 1.8998458233E+00, 7.8011653154E+00, 2.6731143853E-02, 2.6271479071E-02, 3.5754747811E-01],
	[5.2750000000E+03, 1.9019461991E+00, 7.7969353771E+00, 2.6807397721E-02, 2.6345484553E-02, 3.5779055788E-01],
	[5.2800000000E+03, 1.9040469037E+00, 7.7927117366E+00, 2.6883796277E-02, 2.6419625721E-02, 3.5803338027E-01],
	[5.2850000000E+03, 1.9061479368E+00, 7.7884943786E+00, 2.6960339658E-02, 2.6493902681E-02, 3.5827594588E-01],
	[5.2900000000E+03, 1.9082492983E+00, 7.7842832878E+00, 2.7037028002E-02, 2.6568315543E-02, 3.5851825529E-01],
	[5.2950000000E+03, 1.9103509878E+00, 7.7800784490E+00, 2.7113861442E-02, 2.6642864414E-02, 3.5876030908E-01],
	[5.3000000000E+03, 1.9124530052E+00, 7.7758798470E+00, 2.7190840117E-02, 2.6717549402E-02, 3.5900210786E-01],
	[5.3050000000E+03, 1.9145553500E+00, 7.7716874668E+00, 2.7267964162E-02, 2.6792370614E-02, 3.5924365219E-01],
	[5.3100000000E+03, 1.9166580222E+00, 7.7675012931E+00, 2.7345233714E-02, 2.6867328158E-02, 3.5948494266E-01],
	[5.3150000000E+03, 1.9187610214E+00, 7.7633213111E+00, 2.7422648908E-02, 2.6942422142E-02, 3.5972597984E-01],
	[5.3200000000E+03, 1.9208643473E+00, 7.7591475056E+00, 2.7500209882E-02, 2.7017652673E-02, 3.5996676432E-01],
	[5.3250000000E+03, 1.9229679998E+00, 7.7549798619E+00, 2.7577916770E-02, 2.7093019858E-02, 3.6020729671E-01],
	[5.3300000000E+03, 1.9250725737E+00, 7.7508218211E+00, 2.7655769710E-02, 2.7168523966E-02, 3.6044757773E-01],
	[5.3350000000E+03, 1.9271903053E+00, 7.7467442962E+00, 2.7733768838E-02, 2.7244168429E-02, 3.6068760805E-01],
	[5.3400000000E+03, 1.9293083794E+00, 7.7426727331E+00, 2.7811914290E-02, 2.7319949901E-02, 3.6092738834E-01],
	[5.3450000000E+03, 1.9314267959E+00, 7.7386071175E+00, 2.7890206202E-02, 2.7395868489E-02, 3.6116691923E-01],
	[5.3500000000E+03, 1.9335455544E+00, 7.7345474352E+00, 2.7968644710E-02, 2.7471924299E-02, 3.6140620139E-01],
	[5.3550000000E+03, 1.9356646548E+00, 7.7304936719E+00, 2.8047229951E-02, 2.7548117440E-02, 3.6164523546E-01],
	[5.3600000000E+03, 1.9377840966E+00, 7.7264458135E+00, 2.8125962061E-02, 2.7624448018E-02, 3.6188402209E-01],
	[5.3650000000E+03, 1.9399038796E+00, 7.7224038459E+00, 2.8204841176E-02, 2.7700916140E-02, 3.6212256193E-01],
	[5.3700000000E+03, 1.9420240037E+00, 7.7183677551E+00, 2.8283867432E-02, 2.7777521914E-02, 3.6236085560E-01],
	[5.3750000000E+03, 1.9441444685E+00, 7.7143375271E+00, 2.8363040965E-02, 2.7854265446E-02, 3.6259890375E-01],
	[5.3800000000E+03, 1.9462652738E+00, 7.7103131478E+00, 2.8442361912E-02, 2.7931146843E-02, 3.6283670702E-01],
	[5.3850000000E+03, 1.9483864192E+00, 7.7062946034E+00, 2.8521830410E-02, 2.8008166212E-02, 3.6307426604E-01],
	[5.3900000000E+03, 1.9505079046E+00, 7.7022818801E+00, 2.8601446593E-02, 2.8085323659E-02, 3.6331158145E-01],
	[5.3950000000E+03, 1.9526297297E+00, 7.6982749640E+00, 2.8681210598E-02, 2.8162619291E-02, 3.6354865386E-01],
	[5.4000000000E+03, 1.9547518942E+00, 7.6942738412E+00, 2.8761122562E-02, 2.8240053214E-02, 3.6378548391E-01],
	[5.4050000000E+03, 1.9568743978E+00, 7.6902784982E+00, 2.8841182621E-02, 2.8317625536E-02, 3.6402207223E-01],
	[5.4100000000E+03, 1.9589972404E+00, 7.6862889212E+00, 2.8921390911E-02, 2.8395336361E-02, 3.6425841943E-01],
	[5.4150000000E+03, 1.9611204216E+00, 7.6823050966E+00, 2.9001747568E-02, 2.8473185798E-02, 3.6449452613E-01],
	[5.4200000000E+03, 1.9632554438E+00, 7.6783931573E+00, 2.9082252728E-02, 2.8551177299E-02, 3.6473039295E-01],
	[5.4250000000E+03, 1.9653923300E+00, 7.6744954929E+00, 2.9162906527E-02, 2.8629308094E-02, 3.6496602050E-01],
	[5.4300000000E+03, 1.9675295703E+00, 7.6706033949E+00, 2.9243709102E-02, 2.8707577851E-02, 3.6520140940E-01],
	[5.4350000000E+03, 1.9696671644E+00, 7.6667168503E+00, 2.9324660589E-02, 2.8785986677E-02, 3.6543656027E-01],
	[5.4400000000E+03, 1.9718051121E+00, 7.6628358461E+00, 2.9405761124E-02, 2.8864534677E-02, 3.6567147369E-01],
	[5.4450000000E+03, 1.9739434131E+00, 7.6589603692E+00, 2.9487010843E-02, 2.8943221959E-02, 3.6590615029E-01],
	[5.4500000000E+03, 1.9760820671E+00, 7.6550904068E+00, 2.9568409883E-02, 2.9022048627E-02, 3.6614059066E-01],
	[5.4550000000E+03, 1.9782210738E+00, 7.6512259459E+00, 2.9649958379E-02, 2.9101014788E-02, 3.6637479542E-01],
	[5.4600000000E+03, 1.9803604330E+00, 7.6473669737E+00, 2.9731656467E-02, 2.9180120548E-02, 3.6660876514E-01],
	[5.4650000000E+03, 1.9825001445E+00, 7.6435134774E+00, 2.9813504285E-02, 2.9259366013E-02, 3.6684250044E-01],
	[5.4700000000E+03, 1.9846402079E+00, 7.6396654442E+00, 2.9895501968E-02, 2.9338751287E-02, 3.6707600190E-01],
	[5.4750000000E+03, 1.9867806230E+00, 7.6358228614E+00, 2.9977649651E-02, 2.9418276478E-02, 3.6730927013E-01],
	[5.4800000000E+03, 1.9889213895E+00, 7.6319857163E+00, 3.0060292096E-02, 2.9498273548E-02, 3.6754230570E-01],
	[5.4850000000E+03, 1.9910625072E+00, 7.6281539962E+00, 3.0143364478E-02, 2.9578679979E-02, 3.6777510922E-01],
	[5.4900000000E+03, 1.9932039758E+00, 7.6243276886E+00, 3.0226590136E-02, 2.9659229311E-02, 3.6800768125E-01],
	[5.4950000000E+03, 1.9953457950E+00, 7.6205067809E+00, 3.0309969210E-02, 2.9739921655E-02, 3.6824002240E-01],
	[5.5000000000E+03, 1.9974879647E+00, 7.6166912605E+00, 3.0393501844E-02, 2.9820757120E-02, 3.6847213323E-01],
	[5.5050000000E+03, 1.9996361181E+00, 7.6129132947E+00, 3.0477188179E-02, 2.9901737573E-02, 3.6870401433E-01],
	[5.5100000000E+03, 2.0017915960E+00, 7.6091803672E+00, 3.0561028357E-02, 2.9982863563E-02, 3.6893566628E-01],
	[5.5150000000E+03, 2.0039474391E+00, 7.6054526536E+00, 3.0645022519E-02, 3.0064133039E-02, 3.6916708965E-01],
	[5.5200000000E+03, 2.0061036472E+00, 7.6017301417E+00, 3.0729170809E-02, 3.0145546110E-02, 3.6939828502E-01],
	[5.5250000000E+03, 2.0082602199E+00, 7.5980128197E+00, 3.0813473368E-02, 3.0227102887E-02, 3.6962925295E-01],
	[5.5300000000E+03, 2.0104171571E+00, 7.5943006755E+00, 3.0897930337E-02, 3.0308803479E-02, 3.6985999402E-01],
	[5.5350000000E+03, 2.0125744584E+00, 7.5905936975E+00, 3.0982541859E-02, 3.0390647996E-02, 3.7009050879E-01],
	[5.5400000000E+03, 2.0147321236E+00, 7.5868918736E+00, 3.1067308076E-02, 3.0472636549E-02, 3.7032079783E-01],
	[5.5450000000E+03, 2.0168901525E+00, 7.5831951920E+00, 3.1152229129E-02, 3.0554769245E-02, 3.7055086170E-01],
	[5.5500000000E+03, 2.0190485446E+00, 7.5795036411E+00, 3.1237305161E-02, 3.0637046196E-02, 3.7078070096E-01],
	[5.5550000000E+03, 2.0212072999E+00, 7.5758172090E+00, 3.1322536314E-02, 3.0719467510E-02, 3.7101031618E-01],
	[5.5600000000E+03, 2.0233664179E+00, 7.5721358842E+00, 3.1407922729E-02, 3.0802033297E-02, 3.7123970790E-01],
	[5.5650000000E+03, 2.0255258985E+00, 7.5684596548E+00, 3.1493464548E-02, 3.0884743667E-02, 3.7146887668E-01],
	[5.5700000000E+03, 2.0276857414E+00, 7.5647885093E+00, 3.1579161914E-02, 3.0967598728E-02, 3.7169782309E-01],
	[5.5750000000E+03, 2.0298459463E+00, 7.5611224362E+00, 3.1665014968E-02, 3.1050598589E-02, 3.7192654766E-01],
	[5.5800000000E+03, 2.0320065130E+00, 7.5574614238E+00, 3.1751023853E-02, 3.1133743361E-02, 3.7215505094E-01],
	[5.5850000000E+03, 2.0341674411E+00, 7.5538054606E+00, 3.1837188709E-02, 3.1217033151E-02, 3.7238333349E-01],
	[5.5900000000E+03, 2.0363287305E+00, 7.5501545352E+00, 3.1923509680E-02, 3.1300468069E-02, 3.7261139585E-01],
	[5.5950000000E+03, 2.0384992739E+00, 7.5465590921E+00, 3.2009986907E-02, 3.1384051205E-02, 3.7283923856E-01],
	[5.6000000000E+03, 2.0406734832E+00, 7.5429872320E+00, 3.2096620532E-02, 3.1467780819E-02, 3.7306686217E-01],
	[5.6050000000E+03, 2.0428480680E+00, 7.5394202480E+00, 3.2183410697E-02, 3.1551655923E-02, 3.7329426721E-01],
	[5.6100000000E+03, 2.0450230280E+00, 7.5358581291E+00, 3.2270357544E-02, 3.1635676626E-02, 3.7352145422E-01],
	[5.6150000000E+03, 2.0471983629E+00, 7.5323008642E+00, 3.2357461215E-02, 3.1719843035E-02, 3.7374842374E-01],
	[5.6200000000E+03, 2.0493740724E+00, 7.5287484426E+00, 3.2444721851E-02, 3.1804155260E-02, 3.7397517630E-01],
	[5.6250000000E+03, 2.0515501563E+00, 7.5252008533E+00, 3.2532139596E-02, 3.1888613410E-02, 3.7420171244E-01],
	[5.6300000000E+03, 2.0537266143E+00, 7.5216580853E+00, 3.2619714590E-02, 3.1973217592E-02, 3.7442803267E-01],
	[5.6350000000E+03, 2.0559034462E+00, 7.5181201280E+00, 3.2707446976E-02, 3.2057967916E-02, 3.7465413754E-01],
	[5.6400000000E+03, 2.0580806516E+00, 7.5145869705E+00, 3.2795336896E-02, 3.2142864491E-02, 3.7488002757E-01],
	[5.6450000000E+03, 2.0602582303E+00, 7.5110586020E+00, 3.2883384491E-02, 3.2227907423E-02, 3.7510570328E-01],
	[5.6500000000E+03, 2.0624361821E+00, 7.5075350119E+00, 3.2971589904E-02, 3.2313096822E-02, 3.7533116528E-01],
	[5.6550000000E+03, 2.0646145067E+00, 7.5040161894E+00, 3.3059953276E-02, 3.2398432795E-02, 3.7555641418E-01],
	[5.6600000000E+03, 2.0667932037E+00, 7.5005021239E+00, 3.3148474749E-02, 3.2483915452E-02, 3.7578145055E-01],
	[5.6650000000E+03, 2.0689722730E+00, 7.4969928048E+00, 3.3237154467E-02, 3.2569544899E-02, 3.7600627497E-01],
	[5.6700000000E+03, 2.0711517143E+00, 7.4934882214E+00, 3.3325992569E-02, 3.2655321245E-02, 3.7623088801E-01],
	[5.6750000000E+03, 2.0733315273E+00, 7.4899883632E+00, 3.3414989199E-02, 3.2741244598E-02, 3.7645529025E-01],
	[5.6800000000E+03, 2.0755117118E+00, 7.4864932197E+00, 3.3504144498E-02, 3.2827315066E-02, 3.7667948225E-01],
	[5.6850000000E+03, 2.0777008265E+00, 7.4830510942E+00, 3.3593458608E-02, 3.2913535838E-02, 3.7690346458E-01],
	[5.6900000000E+03, 2.0798935355E+00, 7.4796316838E+00, 3.3682931671E-02, 3.2999905128E-02, 3.7712723781E-01],
	[5.6950000000E+03, 2.0820866296E+00, 7.4762168373E+00, 3.3772563830E-02, 3.3086421891E-02, 3.7735080249E-01],
	[5.7000000000E+03, 2.0842801085E+00, 7.4728065446E+00, 3.3862355225E-02, 3.3173086236E-02, 3.7757415919E-01],
	[5.7050000000E+03, 2.0864739719E+00, 7.4694007957E+00, 3.3952306000E-02, 3.3259898270E-02, 3.7779730846E-01],
	[5.7100000000E+03, 2.0886682196E+00, 7.4659995805E+00, 3.4042416295E-02, 3.3346858100E-02, 3.7802025087E-01],
	[5.7150000000E+03, 2.0908628513E+00, 7.4626028890E+00, 3.4132686253E-02, 3.3433965834E-02, 3.7824298696E-01],
	[5.7200000000E+03, 2.0930578667E+00, 7.4592107112E+00, 3.4223116017E-02, 3.3521221580E-02, 3.7846551729E-01],
	[5.7250000000E+03, 2.0952532655E+00, 7.4558230373E+00, 3.4313705727E-02, 3.3608625444E-02, 3.7868784241E-01],
	[5.7300000000E+03, 2.0974490475E+00, 7.4524398572E+00, 3.4404455525E-02, 3.3696177534E-02, 3.7890996286E-01],
	[5.7350000000E+03, 2.0996452125E+00, 7.4490611612E+00, 3.4495395734E-02, 3.3783906905E-02, 3.7913187920E-01],
	[5.7400000000E+03, 2.1018417601E+00, 7.4456869394E+00, 3.4586530861E-02, 3.3871817843E-02, 3.7935359197E-01],
	[5.7450000000E+03, 2.1040386901E+00, 7.4423171820E+00, 3.4677826827E-02, 3.3959877631E-02, 3.7957510170E-01],
	[5.7500000000E+03, 2.1062360022E+00, 7.4389518791E+00, 3.4769283777E-02, 3.4048086376E-02, 3.7979640894E-01],
	[5.7550000000E+03, 2.1084336961E+00, 7.4355910211E+00, 3.4860901851E-02, 3.4136444186E-02, 3.8001751423E-01],
	[5.7600000000E+03, 2.1106317717E+00, 7.4322345982E+00, 3.4952681194E-02, 3.4224951168E-02, 3.8023841811E-01],
	[5.7650000000E+03, 2.1128302286E+00, 7.4288826007E+00, 3.5044621948E-02, 3.4313607430E-02, 3.8045912110E-01],
	[5.7700000000E+03, 2.1150290665E+00, 7.4255350189E+00, 3.5136724255E-02, 3.4402413078E-02, 3.8067962375E-01],
	[5.7750000000E+03, 2.1172332201E+00, 7.4222196059E+00, 3.5228988259E-02, 3.4491370130E-02, 3.8089992657E-01],
	[5.7800000000E+03, 2.1194441805E+00, 7.4189446053E+00, 3.5321414102E-02, 3.4580479291E-02, 3.8112003011E-01],
	[5.7850000000E+03, 2.1216555349E+00, 7.4156738797E+00, 3.5414001927E-02, 3.4669738198E-02, 3.8133993489E-01],
	[5.7900000000E+03, 2.1238672832E+00, 7.4124074199E+00, 3.5506751877E-02, 3.4759146957E-02, 3.8155964142E-01],
	[5.7950000000E+03, 2.1260794250E+00, 7.4091452165E+00, 3.5599664093E-02, 3.4848705675E-02, 3.8177915025E-01],
	[5.8000000000E+03, 2.1282919600E+00, 7.4058872605E+00, 3.5692738720E-02, 3.4938414460E-02, 3.8199846188E-01],
	[5.8050000000E+03, 2.1305048880E+00, 7.4026335425E+00, 3.5785975900E-02, 3.5028273418E-02, 3.8221757683E-01],
	[5.8100000000E+03, 2.1327182088E+00, 7.3993840536E+00, 3.5879375776E-02, 3.5118282657E-02, 3.8243649563E-01],
	[5.8150000000E+03, 2.1349319220E+00, 7.3961387844E+00, 3.5972938489E-02, 3.5208442283E-02, 3.8265521879E-01],
	[5.8200000000E+03, 2.1371460274E+00, 7.3928977260E+00, 3.6066664184E-02, 3.5298752403E-02, 3.8287374682E-01],
	[5.8250000000E+03, 2.1393605247E+00, 7.3896608692E+00, 3.6160553003E-02, 3.5389213123E-02, 3.8309208024E-01],
	[5.8300000000E+03, 2.1415754137E+00, 7.3864282051E+00, 3.6254605088E-02, 3.5479824551E-02, 3.8331021955E-01],
	[5.8350000000E+03, 2.1437906941E+00, 7.3831997245E+00, 3.6348820583E-02, 3.5570586793E-02, 3.8352816527E-01],
	[5.8400000000E+03, 2.1460063656E+00, 7.3799754185E+00, 3.6443199630E-02, 3.5661499954E-02, 3.8374591790E-01],
	[5.8450000000E+03, 2.1482224279E+00, 7.3767552782E+00, 3.6537742371E-02, 3.5752564143E-02, 3.8396347795E-01],
	[5.8500000000E+03, 2.1504388809E+00, 7.3735392945E+00, 3.6632448951E-02, 3.5843779464E-02, 3.8418084591E-01],
	[5.8550000000E+03, 2.1526557241E+00, 7.3703274586E+00, 3.6727319510E-02, 3.5935146024E-02, 3.8439802230E-01],
	[5.8600000000E+03, 2.1548729575E+00, 7.3671197617E+00, 3.6822354193E-02, 3.6026663930E-02, 3.8461500761E-01],
	[5.8650000000E+03, 2.1570905806E+00, 7.3639161947E+00, 3.6917553142E-02, 3.6118333287E-02, 3.8483180233E-01],
	[5.8700000000E+03, 2.1593178646E+00, 7.3607687511E+00, 3.7012916499E-02, 3.6210158067E-02, 3.8504840698E-01],
	[5.8750000000E+03, 2.1615472143E+00, 7.3576346569E+00, 3.7108444408E-02, 3.6302135239E-02, 3.8526482203E-01],
	[5.8800000000E+03, 2.1637769662E+00, 7.3545045617E+00, 3.7204137011E-02, 3.6394264217E-02, 3.8548104798E-01],
	[5.8850000000E+03, 2.1660071200E+00, 7.3513784569E+00, 3.7299994450E-02, 3.6486545108E-02, 3.8569708533E-01],
	[5.8900000000E+03, 2.1682376754E+00, 7.3482563340E+00, 3.7396016870E-02, 3.6578978017E-02, 3.8591293456E-01],
	[5.8950000000E+03, 2.1704686323E+00, 7.3451381847E+00, 3.7492204411E-02, 3.6671563051E-02, 3.8612859617E-01],
	[5.9000000000E+03, 2.1726999903E+00, 7.3420240005E+00, 3.7588557218E-02, 3.6764300314E-02, 3.8634407063E-01],
	[5.9050000000E+03, 2.1749317492E+00, 7.3389137729E+00, 3.7685075433E-02, 3.6857189914E-02, 3.8655935843E-01],
	[5.9100000000E+03, 2.1771639086E+00, 7.3358074937E+00, 3.7781759199E-02, 3.6950231954E-02, 3.8677446006E-01],
	[5.9150000000E+03, 2.1793964684E+00, 7.3327051545E+00, 3.7878608658E-02, 3.7043426541E-02, 3.8698937600E-01],
	[5.9200000000E+03, 2.1816294283E+00, 7.3296067469E+00, 3.7975623954E-02, 3.7136773780E-02, 3.8720410672E-01],
	[5.9250000000E+03, 2.1838627879E+00, 7.3265122626E+00, 3.8072805228E-02, 3.7230273776E-02, 3.8741865270E-01],
	[5.9300000000E+03, 2.1860965470E+00, 7.3234216935E+00, 3.8170152624E-02, 3.7323926635E-02, 3.8763301443E-01],
	[5.9350000000E+03, 2.1883307055E+00, 7.3203350312E+00, 3.8267666285E-02, 3.7417732462E-02, 3.8784719237E-01],
	[5.9400000000E+03, 2.1905652629E+00, 7.3172522674E+00, 3.8365346353E-02, 3.7511691362E-02, 3.8806118700E-01],
	[5.9450000000E+03, 2.1928002190E+00, 7.3141733942E+00, 3.8463192971E-02, 3.7605803440E-02, 3.8827499879E-01],
	[5.9500000000E+03, 2.1950355736E+00, 7.3110984031E+00, 3.8561206282E-02, 3.7700068800E-02, 3.8848862821E-01],
	[5.9550000000E+03, 2.1972713265E+00, 7.3080272861E+00, 3.8659386428E-02, 3.7794487549E-02, 3.8870207561E-01],
	[5.9600000000E+03, 2.1995074772E+00, 7.3049600351E+00, 3.8757733553E-02, 3.7889059789E-02, 3.8891534141E-01],
	[5.9650000000E+03, 2.2017541411E+00, 7.3019533041E+00, 3.8856247799E-02, 3.7983790171E-02, 3.8912842612E-01],
	[5.9700000000E+03, 2.2040016180E+00, 7.2989525850E+00, 3.8954929309E-02, 3.8078674473E-02, 3.8934133024E-01],
	[5.9750000000E+03, 2.2062495046E+00, 7.2959556096E+00, 3.9053778225E-02, 3.8173712621E-02, 3.8955405429E-01],
	[5.9800000000E+03, 2.2084978007E+00, 7.2929623701E+00, 3.9152794692E-02, 3.8268904717E-02, 3.8976659877E-01],
	[5.9850000000E+03, 2.2107465060E+00, 7.2899728587E+00, 3.9251978850E-02, 3.8364250867E-02, 3.8997896420E-01],
	[5.9900000000E+03, 2.2129956203E+00, 7.2869870677E+00, 3.9351330843E-02, 3.8459751177E-02, 3.9019115106E-01],
	[5.9950000000E+03, 2.2152451432E+00, 7.2840049894E+00, 3.9450850814E-02, 3.8555405748E-02, 3.9040315987E-01],
	[6.0000000000E+03, 2.2174950745E+00, 7.2810266160E+00, 3.9550538906E-02, 3.8651214688E-02, 3.9061499112E-01],
	[6.0050000000E+03, 2.2197454140E+00, 7.2780519399E+00, 3.9650871068E-02, 3.8747632476E-02, 3.9082664532E-01],
	[6.0100000000E+03, 2.2219961614E+00, 7.2750809534E+00, 3.9751373656E-02, 3.8844206691E-02, 3.9103812296E-01],
	[6.0150000000E+03, 2.2242473164E+00, 7.2721136488E+00, 3.9852046816E-02, 3.8940937441E-02, 3.9124942453E-01],
	[6.0200000000E+03, 2.2264988787E+00, 7.2691500185E+00, 3.9952890695E-02, 3.9037824832E-02, 3.9146055053E-01],
	[6.0250000000E+03, 2.2287508481E+00, 7.2661900550E+00, 4.0053905438E-02, 3.9134868972E-02, 3.9167150144E-01],
	[6.0300000000E+03, 2.2310032243E+00, 7.2632337507E+00, 4.0155091193E-02, 3.9232069968E-02, 3.9188227777E-01],
	[6.0350000000E+03, 2.2332560071E+00, 7.2602810979E+00, 4.0256448107E-02, 3.9329427926E-02, 3.9209287999E-01],
	[6.0400000000E+03, 2.2355091962E+00, 7.2573320893E+00, 4.0357976326E-02, 3.9426942953E-02, 3.9230330860E-01],
	[6.0450000000E+03, 2.2377627913E+00, 7.2543867172E+00, 4.0459675996E-02, 3.9524615156E-02, 3.9251356407E-01],
	[6.0500000000E+03, 2.2400167921E+00, 7.2514449743E+00, 4.0561547264E-02, 3.9622444641E-02, 3.9272364689E-01],
	[6.0550000000E+03, 2.2422711985E+00, 7.2485068529E+00, 4.0663590277E-02, 3.9720431515E-02, 3.9293355755E-01],
	[6.0600000000E+03, 2.2445338348E+00, 7.2456159899E+00, 4.0765805181E-02, 3.9818579665E-02, 3.9314329651E-01],
	[6.0650000000E+03, 2.2467992046E+00, 7.2427415805E+00, 4.0868192123E-02, 3.9916886571E-02, 3.9335286427E-01],
	[6.0700000000E+03, 2.2490649912E+00, 7.2398706786E+00, 4.0970751250E-02, 4.0015351224E-02, 3.9356226129E-01],
	[6.0750000000E+03, 2.2513311943E+00, 7.2370032772E+00, 4.1073482708E-02, 4.0113973732E-02, 3.9377148806E-01],
	[6.0800000000E+03, 2.2535978136E+00, 7.2341393691E+00, 4.1176386644E-02, 4.0212754199E-02, 3.9398054503E-01],
	[6.0850000000E+03, 2.2558648489E+00, 7.2312789471E+00, 4.1279463205E-02, 4.0311692732E-02, 3.9418943269E-01],
	[6.0900000000E+03, 2.2581322999E+00, 7.2284220042E+00, 4.1382712536E-02, 4.0410789437E-02, 3.9439815151E-01],
	[6.0950000000E+03, 2.2604001663E+00, 7.2255685333E+00, 4.1486134785E-02, 4.0510044421E-02, 3.9460670195E-01],
	[6.1000000000E+03, 2.2626684480E+00, 7.2227185272E+00, 4.1589730099E-02, 4.0609457789E-02, 3.9481508448E-01],
	[6.1050000000E+03, 2.2649371445E+00, 7.2198719791E+00, 4.1693498623E-02, 4.0709029648E-02, 3.9502329957E-01],
	[6.1100000000E+03, 2.2672062556E+00, 7.2170288818E+00, 4.1797440505E-02, 4.0808760102E-02, 3.9523134768E-01],
	[6.1150000000E+03, 2.2694757811E+00, 7.2141892283E+00, 4.1901555892E-02, 4.0908649258E-02, 3.9543922926E-01],
	[6.1200000000E+03, 2.2717457208E+00, 7.2113530117E+00, 4.2005844929E-02, 4.1008697221E-02, 3.9564694479E-01],
	[6.1250000000E+03, 2.2740160743E+00, 7.2085202250E+00, 4.2110307764E-02, 4.1108904097E-02, 3.9585449472E-01],
	[6.1300000000E+03, 2.2762868414E+00, 7.2056908613E+00, 4.2214944543E-02, 4.1209269992E-02, 3.9606187951E-01],
	[6.1350000000E+03, 2.2785580218E+00, 7.2028649136E+00, 4.2319755412E-02, 4.1309795010E-02, 3.9626909961E-01],
	[6.1400000000E+03, 2.2808296153E+00, 7.2000423750E+00, 4.2424740520E-02, 4.1410479258E-02, 3.9647615548E-01],
	[6.1450000000E+03, 2.2831016216E+00, 7.1972232387E+00, 4.2529900011E-02, 4.1511322840E-02, 3.9668304757E-01],
	[6.1500000000E+03, 2.2853740405E+00, 7.1944074978E+00, 4.2635234033E-02, 4.1612325861E-02, 3.9688977634E-01],
	[6.1550000000E+03, 2.2876495403E+00, 7.1916099322E+00, 4.2740742733E-02, 4.1713489812E-02, 3.9709634223E-01],
	[6.1600000000E+03, 2.2899325898E+00, 7.1888552015E+00, 4.2846426257E-02, 4.1814817138E-02, 3.9730274569E-01],
	[6.1650000000E+03, 2.2922160626E+00, 7.1861037597E+00, 4.2952284751E-02, 4.1916304258E-02, 3.9750898716E-01],
	[6.1700000000E+03, 2.2944999585E+00, 7.1833556004E+00, 4.3058318363E-02, 4.2017951279E-02, 3.9771506711E-01],
	[6.1750000000E+03, 2.2967842772E+00, 7.1806107169E+00, 4.3164527239E-02, 4.2119758304E-02, 3.9792098596E-01],
	[6.1800000000E+03, 2.2990690184E+00, 7.1778691027E+00, 4.3270911526E-02, 4.2221725439E-02, 3.9812674416E-01],
	[6.1850000000E+03, 2.3013541818E+00, 7.1751307512E+00, 4.3377471370E-02, 4.2323852788E-02, 3.9833234215E-01],
	[6.1900000000E+03, 2.3036397672E+00, 7.1723956559E+00, 4.3484206919E-02, 4.2426140457E-02, 3.9853778037E-01],
	[6.1950000000E+03, 2.3059257744E+00, 7.1696638103E+00, 4.3591118318E-02, 4.2528588549E-02, 3.9874305927E-01],
	[6.2000000000E+03, 2.3082122030E+00, 7.1669352080E+00, 4.3698205715E-02, 4.2631197169E-02, 3.9894817927E-01],
	[6.2050000000E+03, 2.3104990528E+00, 7.1642098425E+00, 4.3805469256E-02, 4.2733966422E-02, 3.9915314081E-01],
	[6.2100000000E+03, 2.3127863236E+00, 7.1614877073E+00, 4.3912909088E-02, 4.2836896412E-02, 3.9935794433E-01],
	[6.2150000000E+03, 2.3150740151E+00, 7.1587687960E+00, 4.4020525357E-02, 4.2939987243E-02, 3.9956259026E-01],
	[6.2200000000E+03, 2.3173621269E+00, 7.1560531023E+00, 4.4128318211E-02, 4.3043239020E-02, 3.9976707903E-01],
	[6.2250000000E+03, 2.3196506590E+00, 7.1533406197E+00, 4.4236287795E-02, 4.3146651847E-02, 3.9997141107E-01],
	[6.2300000000E+03, 2.3219396109E+00, 7.1506313418E+00, 4.4344434257E-02, 4.3250225827E-02, 4.0017558681E-01],
	[6.2350000000E+03, 2.3242289824E+00, 7.1479252623E+00, 4.4452757744E-02, 4.3353961065E-02, 4.0037960668E-01],
	[6.2400000000E+03, 2.3265187734E+00, 7.1452223748E+00, 4.4561258402E-02, 4.3457857664E-02, 4.0058347110E-01],
	[6.2450000000E+03, 2.3288089835E+00, 7.1425226731E+00, 4.4669936377E-02, 4.3561915729E-02, 4.0078718049E-01],
	[6.2500000000E+03, 2.3310996124E+00, 7.1398261509E+00, 4.4778791817E-02, 4.3666135362E-02, 4.0099073529E-01],
	[6.2550000000E+03, 2.3333950044E+00, 7.1371567178E+00, 4.4887824868E-02, 4.3770519097E-02, 4.0119413590E-01],
	[6.2600000000E+03, 2.3356959371E+00, 7.1345185469E+00, 4.4997035676E-02, 4.3875067496E-02, 4.0139738276E-01],
	[6.2650000000E+03, 2.3379972989E+00, 7.1318834564E+00, 4.5106424390E-02, 4.3979777816E-02, 4.0160047628E-01],
	[6.2700000000E+03, 2.3402990896E+00, 7.1292514401E+00, 4.5215991154E-02, 4.4084650160E-02, 4.0180341688E-01],
	[6.2750000000E+03, 2.3426013089E+00, 7.1266224921E+00, 4.5325736117E-02, 4.4189684633E-02, 4.0200620498E-01],
	[6.2800000000E+03, 2.3449039566E+00, 7.1239966063E+00, 4.5435659424E-02, 4.4294881337E-02, 4.0220884099E-01],
	[6.2850000000E+03, 2.3472070323E+00, 7.1213737767E+00, 4.5545761223E-02, 4.4400240375E-02, 4.0241132532E-01],
	[6.2900000000E+03, 2.3495105359E+00, 7.1187539974E+00, 4.5656041660E-02, 4.4505761852E-02, 4.0261365839E-01],
	[6.2950000000E+03, 2.3518144670E+00, 7.1161372624E+00, 4.5766500882E-02, 4.4611445869E-02, 4.0281584061E-01],
	[6.3000000000E+03, 2.3541188255E+00, 7.1135235656E+00, 4.5877139036E-02, 4.4717292531E-02, 4.0301787238E-01],
	[6.3050000000E+03, 2.3564236109E+00, 7.1109129013E+00, 4.5987956268E-02, 4.4823301939E-02, 4.0321975413E-01],
	[6.3100000000E+03, 2.3587288232E+00, 7.1083052634E+00, 4.6098952725E-02, 4.4929474198E-02, 4.0342148625E-01],
	[6.3150000000E+03, 2.3610344620E+00, 7.1057006461E+00, 4.6210128554E-02, 4.5035809410E-02, 4.0362306916E-01],
	[6.3200000000E+03, 2.3633405270E+00, 7.1030990435E+00, 4.6321483901E-02, 4.5142307676E-02, 4.0382450325E-01],
	[6.3250000000E+03, 2.3656470181E+00, 7.1005004496E+00, 4.6433018914E-02, 4.5248969102E-02, 4.0402578893E-01],
	[6.3300000000E+03, 2.3679539349E+00, 7.0979048588E+00, 4.6544733739E-02, 4.5355793787E-02, 4.0422692661E-01],
	[6.3350000000E+03, 2.3702612772E+00, 7.0953122650E+00, 4.6656628523E-02, 4.5462781837E-02, 4.0442791668E-01],
	[6.3400000000E+03, 2.3725690447E+00, 7.0927226626E+00, 4.6768703412E-02, 4.5569933351E-02, 4.0462875955E-01],
	[6.3450000000E+03, 2.3748772372E+00, 7.0901360456E+00, 4.6880958553E-02, 4.5677248434E-02, 4.0482945561E-01],
	[6.3500000000E+03, 2.3771858544E+00, 7.0875524083E+00, 4.6993394094E-02, 4.5784727186E-02, 4.0503000526E-01],
	[6.3550000000E+03, 2.3794978794E+00, 7.0849880902E+00, 4.7106010180E-02, 4.5892371506E-02, 4.0523040890E-01],
	[6.3600000000E+03, 2.3818164672E+00, 7.0824602844E+00, 4.7218806959E-02, 4.6000183419E-02, 4.0543066693E-01],
	[6.3650000000E+03, 2.3841354894E+00, 7.0799353660E+00, 4.7331784578E-02, 4.6108159350E-02, 4.0563077973E-01],
	[6.3700000000E+03, 2.3864549459E+00, 7.0774133293E+00, 4.7444943182E-02, 4.6216299402E-02, 4.0583074771E-01],
	[6.3750000000E+03, 2.3887748364E+00, 7.0748941688E+00, 4.7558282920E-02, 4.6324603677E-02, 4.0603057125E-01],
	[6.3800000000E+03, 2.3910951606E+00, 7.0723778789E+00, 4.7671803937E-02, 4.6433072276E-02, 4.0623025074E-01],
	[6.3850000000E+03, 2.3934159182E+00, 7.0698644542E+00, 4.7785506380E-02, 4.6541705301E-02, 4.0642978658E-01],
	[6.3900000000E+03, 2.3957371091E+00, 7.0673538891E+00, 4.7899390397E-02, 4.6650502855E-02, 4.0662917915E-01],
	[6.3950000000E+03, 2.3980587329E+00, 7.0648461782E+00, 4.8013456133E-02, 4.6759465038E-02, 4.0682842883E-01],
	[6.4000000000E+03, 2.4003807894E+00, 7.0623413160E+00, 4.8127703737E-02, 4.6868591952E-02, 4.0702753602E-01],
	[6.4050000000E+03, 2.4027032784E+00, 7.0598392970E+00, 4.8242133354E-02, 4.6977883699E-02, 4.0722650111E-01],
	[6.4100000000E+03, 2.4050261995E+00, 7.0573401158E+00, 4.8356745131E-02, 4.7087340381E-02, 4.0742532446E-01],
	[6.4150000000E+03, 2.4073495525E+00, 7.0548437669E+00, 4.8471539215E-02, 4.7196962097E-02, 4.0762400647E-01],
	[6.4200000000E+03, 2.4096733372E+00, 7.0523502450E+00, 4.8586515753E-02, 4.7306748951E-02, 4.0782254752E-01],
	[6.4250000000E+03, 2.4119975532E+00, 7.0498595446E+00, 4.8701674892E-02, 4.7416701042E-02, 4.0802094799E-01],
	[6.4300000000E+03, 2.4143222005E+00, 7.0473716604E+00, 4.8817016778E-02, 4.7526818472E-02, 4.0821920825E-01],
	[6.4350000000E+03, 2.4166472786E+00, 7.0448865870E+00, 4.8932541558E-02, 4.7637101342E-02, 4.0841732869E-01],
	[6.4400000000E+03, 2.4189727874E+00, 7.0424043190E+00, 4.9048249380E-02, 4.7747549752E-02, 4.0861530968E-01],
	[6.4450000000E+03, 2.4212987265E+00, 7.0399248511E+00, 4.9164140389E-02, 4.7858163804E-02, 4.0881315160E-01],
	[6.4500000000E+03, 2.4236250958E+00, 7.0374481779E+00, 4.9280214733E-02, 4.7968943598E-02, 4.0901085483E-01],
	[6.4550000000E+03, 2.4259518950E+00, 7.0349742942E+00, 4.9396472559E-02, 4.8079889235E-02, 4.0920841973E-01],
	[6.4600000000E+03, 2.4282867663E+00, 7.0325448920E+00, 4.9512914012E-02, 4.8191005783E-02, 4.0940584668E-01],
	[6.4650000000E+03, 2.4306232062E+00, 7.0301243674E+00, 4.9629539241E-02, 4.8302289150E-02, 4.0960313605E-01],
	[6.4700000000E+03, 2.4329600853E+00, 7.0277065464E+00, 4.9746348392E-02, 4.8413738705E-02, 4.0980028822E-01],
	[6.4750000000E+03, 2.4352974034E+00, 7.0252914236E+00, 4.9863341611E-02, 4.8525354547E-02, 4.0999730355E-01],
	[6.4800000000E+03, 2.4376351600E+00, 7.0228789941E+00, 4.9980519046E-02, 4.8637136778E-02, 4.1019418241E-01],
	[6.4850000000E+03, 2.4399733551E+00, 7.0204692528E+00, 5.0097886375E-02, 4.8749090736E-02, 4.1039092516E-01],
	[6.4900000000E+03, 2.4423119884E+00, 7.0180621946E+00, 5.0215439200E-02, 4.8861212216E-02, 4.1058753218E-01],
	[6.4950000000E+03, 2.4446510595E+00, 7.0156578145E+00, 5.0333176706E-02, 4.8973500408E-02, 4.1078400383E-01],
	[6.5000000000E+03, 2.4469905682E+00, 7.0132561074E+00, 5.0451099042E-02, 4.9085955412E-02, 4.1098034048E-01],
	[6.5050000000E+03, 2.4493305143E+00, 7.0108570683E+00, 5.0569206354E-02, 4.9198577330E-02, 4.1117654248E-01],
	[6.5100000000E+03, 2.4516708976E+00, 7.0084606921E+00, 5.0687498788E-02, 4.9311366260E-02, 4.1137261020E-01],
	[6.5150000000E+03, 2.4540117177E+00, 7.0060669740E+00, 5.0805976492E-02, 4.9424322303E-02, 4.1156854400E-01],
	[6.5200000000E+03, 2.4563529744E+00, 7.0036759089E+00, 5.0924639613E-02, 4.9537445558E-02, 4.1176434427E-01],
	[6.5250000000E+03, 2.4586946675E+00, 7.0012874918E+00, 5.1043488298E-02, 4.9650736125E-02, 4.1196001159E-01],
	[6.5300000000E+03, 2.4610367966E+00, 6.9989017177E+00, 5.1162522693E-02, 4.9764194103E-02, 4.1215554635E-01],
	[6.5350000000E+03, 2.4633793617E+00, 6.9965185818E+00, 5.1281742945E-02, 4.9877819592E-02, 4.1235094894E-01],
	[6.5400000000E+03, 2.4657223623E+00, 6.9941380791E+00, 5.1401149201E-02, 4.9991612691E-02, 4.1254621971E-01],
	[6.5450000000E+03, 2.4680657983E+00, 6.9917602047E+00, 5.1520741608E-02, 5.0105573500E-02, 4.1274135905E-01],
	[6.5500000000E+03, 2.4704096694E+00, 6.9893849537E+00, 5.1640520314E-02, 5.0219702118E-02, 4.1293636732E-01],
	[6.5550000000E+03, 2.4727539753E+00, 6.9870123211E+00, 5.1760485464E-02, 5.0333998643E-02, 4.1313124489E-01],
	[6.5600000000E+03, 2.4750994383E+00, 6.9846462401E+00, 5.1880637206E-02, 5.0448463681E-02, 4.1332599212E-01],
	[6.5650000000E+03, 2.4774530395E+00, 6.9823246994E+00, 5.2000975686E-02, 5.0563102237E-02, 4.1352060939E-01],
	[6.5700000000E+03, 2.4798070844E+00, 6.9800056969E+00, 5.2121501052E-02, 5.0677909041E-02, 4.1371509704E-01],
	[6.5750000000E+03, 2.4821615727E+00, 6.9776892279E+00, 5.2242213451E-02, 5.0792884193E-02, 4.1390945546E-01],
	[6.5800000000E+03, 2.4845165042E+00, 6.9753752877E+00, 5.2363113029E-02, 5.0908027792E-02, 4.1410368499E-01],
	[6.5850000000E+03, 2.4868718785E+00, 6.9730638717E+00, 5.2484199933E-02, 5.1023339936E-02, 4.1429778601E-01],
	[6.5900000000E+03, 2.4892276955E+00, 6.9707549751E+00, 5.2605474311E-02, 5.1138820724E-02, 4.1449175886E-01],
	[6.5950000000E+03, 2.4915839549E+00, 6.9684485932E+00, 5.2726936308E-02, 5.1254470255E-02, 4.1468560392E-01],
	[6.6000000000E+03, 2.4939406564E+00, 6.9661447216E+00, 5.2848586073E-02, 5.1370288627E-02, 4.1487932153E-01],
	[6.6050000000E+03, 2.4962977998E+00, 6.9638433554E+00, 5.2970423751E-02, 5.1486275939E-02, 4.1507291205E-01],
	[6.6100000000E+03, 2.4986553848E+00, 6.9615444902E+00, 5.3092449491E-02, 5.1602432289E-02, 4.1526637585E-01],
	[6.6150000000E+03, 2.5010134113E+00, 6.9592481213E+00, 5.3214663438E-02, 5.1718757775E-02, 4.1545971327E-01],
	[6.6200000000E+03, 2.5033718788E+00, 6.9569542441E+00, 5.3337065740E-02, 5.1835252496E-02, 4.1565292467E-01],
	[6.6250000000E+03, 2.5057307872E+00, 6.9546628540E+00, 5.3459656543E-02, 5.1951916549E-02, 4.1584601040E-01],
	[6.6300000000E+03, 2.5080901363E+00, 6.9523739464E+00, 5.3582435995E-02, 5.2068750032E-02, 4.1603897081E-01],
	[6.6350000000E+03, 2.5104499257E+00, 6.9500875169E+00, 5.3705404243E-02, 5.2185753044E-02, 4.1623180626E-01],
	[6.6400000000E+03, 2.5128101553E+00, 6.9478035608E+00, 5.3828561433E-02, 5.2302925682E-02, 4.1642451709E-01],
	[6.6450000000E+03, 2.5151708247E+00, 6.9455220736E+00, 5.3951907712E-02, 5.2420268044E-02, 4.1661710365E-01],
	[6.6500000000E+03, 2.5175319338E+00, 6.9432430508E+00, 5.4075443228E-02, 5.2537780228E-02, 4.1680956630E-01],
	[6.6550000000E+03, 2.5198934823E+00, 6.9409664878E+00, 5.4199168127E-02, 5.2655462330E-02, 4.1700190537E-01],
	[6.6600000000E+03, 2.5222554699E+00, 6.9386923803E+00, 5.4323082556E-02, 5.2773314449E-02, 4.1719412121E-01],
	[6.6650000000E+03, 2.5246178963E+00, 6.9364207236E+00, 5.4447186663E-02, 5.2891336682E-02, 4.1738621417E-01],
	[6.6700000000E+03, 2.5269885605E+00, 6.9341939733E+00, 5.4571480593E-02, 5.3009535040E-02, 4.1757818460E-01],
	[6.6750000000E+03, 2.5293599486E+00, 6.9319711102E+00, 5.4695964494E-02, 5.3127903959E-02, 4.1777003282E-01],
	[6.6800000000E+03, 2.5317317839E+00, 6.9297506234E+00, 5.4820638514E-02, 5.3246443330E-02, 4.1796175920E-01],
	[6.6850000000E+03, 2.5341040661E+00, 6.9275325085E+00, 5.4945502798E-02, 5.3365153248E-02, 4.1815336406E-01],
	[6.6900000000E+03, 2.5364767951E+00, 6.9253167612E+00, 5.5070557495E-02, 5.3484033811E-02, 4.1834484775E-01],
	[6.6950000000E+03, 2.5388499705E+00, 6.9231033772E+00, 5.5195802750E-02, 5.3603085116E-02, 4.1853621060E-01],
	[6.7000000000E+03, 2.5412235922E+00, 6.9208923522E+00, 5.5321238711E-02, 5.3722307261E-02, 4.1872745296E-01],
	[6.7050000000E+03, 2.5435976598E+00, 6.9186836819E+00, 5.5446865525E-02, 5.3841700341E-02, 4.1891857516E-01],
	[6.7100000000E+03, 2.5459721731E+00, 6.9164773622E+00, 5.5572683338E-02, 5.3961264453E-02, 4.1910957754E-01],
	[6.7150000000E+03, 2.5483471318E+00, 6.9142733886E+00, 5.5698692298E-02, 5.4080999695E-02, 4.1930046044E-01],
	[6.7200000000E+03, 2.5507225359E+00, 6.9120717571E+00, 5.5824892552E-02, 5.4200906162E-02, 4.1949122418E-01],
	[6.7250000000E+03, 2.5530983848E+00, 6.9098724633E+00, 5.5951284247E-02, 5.4320983952E-02, 4.1968186910E-01],
	[6.7300000000E+03, 2.5554746785E+00, 6.9076755031E+00, 5.6077867529E-02, 5.4441233160E-02, 4.1987239554E-01],
	[6.7350000000E+03, 2.5578514167E+00, 6.9054808723E+00, 5.6204642546E-02, 5.4561653884E-02, 4.2006280383E-01],
	[6.7400000000E+03, 2.5602285991E+00, 6.9032885665E+00, 5.6331609444E-02, 5.4682246218E-02, 4.2025309429E-01],
	[6.7450000000E+03, 2.5626062255E+00, 6.9010985818E+00, 5.6458768371E-02, 5.4803010259E-02, 4.2044326725E-01],
	[6.7500000000E+03, 2.5649842956E+00, 6.8989109138E+00, 5.6586119474E-02, 5.4923946104E-02, 4.2063332306E-01],
	[6.7550000000E+03, 2.5673628092E+00, 6.8967255584E+00, 5.6713662899E-02, 5.5045053848E-02, 4.2082326202E-01],
	[6.7600000000E+03, 2.5697417661E+00, 6.8945425115E+00, 5.6841398793E-02, 5.5166333587E-02, 4.2101308448E-01],
	[6.7650000000E+03, 2.5721211659E+00, 6.8923617690E+00, 5.6969327305E-02, 5.5287785417E-02, 4.2120279076E-01],
	[6.7700000000E+03, 2.5745010085E+00, 6.8901833266E+00, 5.7097448579E-02, 5.5409409433E-02, 4.2139238118E-01],
	[6.7750000000E+03, 2.5768851985E+00, 6.8880284896E+00, 5.7225762764E-02, 5.5531208929E-02, 4.2158185606E-01],
	[6.7800000000E+03, 2.5792736539E+00, 6.8858967288E+00, 5.7354270007E-02, 5.5653183964E-02, 4.2177121574E-01],
	[6.7850000000E+03, 2.5816625600E+00, 6.8837671986E+00, 5.7482970454E-02, 5.5775331518E-02, 4.2196046054E-01],
	[6.7900000000E+03, 2.5840519163E+00, 6.8816398950E+00, 5.7611864252E-02, 5.5897651686E-02, 4.2214959077E-01],
	[6.7950000000E+03, 2.5864417228E+00, 6.8795148140E+00, 5.7740951550E-02, 5.6020144564E-02, 4.2233860676E-01],
	[6.8000000000E+03, 2.5888319792E+00, 6.8773919516E+00, 5.7870232492E-02, 5.6142810248E-02, 4.2252750882E-01],
	[6.8050000000E+03, 2.5912226851E+00, 6.8752713039E+00, 5.7999707227E-02, 5.6265648831E-02, 4.2271629729E-01],
	[6.8100000000E+03, 2.5936138405E+00, 6.8731528670E+00, 5.8129375902E-02, 5.6388660411E-02, 4.2290497247E-01],
	[6.8150000000E+03, 2.5960054449E+00, 6.8710366369E+00, 5.8259238663E-02, 5.6511845081E-02, 4.2309353468E-01],
	[6.8200000000E+03, 2.5983974983E+00, 6.8689226097E+00, 5.8389295657E-02, 5.6635202936E-02, 4.2328198425E-01],
	[6.8250000000E+03, 2.6007900003E+00, 6.8668107816E+00, 5.8519547032E-02, 5.6758734072E-02, 4.2347032148E-01],
	[6.8300000000E+03, 2.6031829507E+00, 6.8647011486E+00, 5.8649992935E-02, 5.6882438583E-02, 4.2365854670E-01],
	[6.8350000000E+03, 2.6055763492E+00, 6.8625937068E+00, 5.8780633512E-02, 5.7006316564E-02, 4.2384666022E-01],
	[6.8400000000E+03, 2.6079701957E+00, 6.8604884524E+00, 5.8911468911E-02, 5.7130368109E-02, 4.2403466235E-01],
	[6.8450000000E+03, 2.6103644898E+00, 6.8583853815E+00, 5.9042499279E-02, 5.7254593313E-02, 4.2422255340E-01],
	[6.8500000000E+03, 2.6127592313E+00, 6.8562844902E+00, 5.9173724762E-02, 5.7378992270E-02, 4.2441033369E-01],
	[6.8550000000E+03, 2.6151544200E+00, 6.8541857747E+00, 5.9305145508E-02, 5.7503565075E-02, 4.2459800352E-01],
	[6.8600000000E+03, 2.6175500557E+00, 6.8520892311E+00, 5.9436761663E-02, 5.7628311822E-02, 4.2478556322E-01],
	[6.8650000000E+03, 2.6199461380E+00, 6.8499948557E+00, 5.9568573376E-02, 5.7753232604E-02, 4.2497301308E-01],
	[6.8700000000E+03, 2.6223426668E+00, 6.8479026446E+00, 5.9700580792E-02, 5.7878327517E-02, 4.2516035342E-01],
	[6.8750000000E+03, 2.6247396418E+00, 6.8458125939E+00, 5.9832784058E-02, 5.8003596653E-02, 4.2534758455E-01],
	[6.8800000000E+03, 2.6271370627E+00, 6.8437247000E+00, 5.9965183323E-02, 5.8129040107E-02, 4.2553470677E-01],
	[6.8850000000E+03, 2.6295400884E+00, 6.8416672154E+00, 6.0097778733E-02, 5.8254662552E-02, 4.2572172039E-01],
	[6.8900000000E+03, 2.6319457753E+00, 6.8396239326E+00, 6.0230570434E-02, 5.8380461504E-02, 4.2590862571E-01],
	[6.8950000000E+03, 2.6343519155E+00, 6.8375827417E+00, 6.0363558574E-02, 5.8506435102E-02, 4.2609542305E-01],
	[6.9000000000E+03, 2.6367585089E+00, 6.8355436389E+00, 6.0496743301E-02, 5.8632583439E-02, 4.2628211270E-01],
	[6.9050000000E+03, 2.6391655551E+00, 6.8335066207E+00, 6.0630124760E-02, 5.8758906609E-02, 4.2646869497E-01],
	[6.9100000000E+03, 2.6415730539E+00, 6.8314716833E+00, 6.0763703100E-02, 5.8885404706E-02, 4.2665517017E-01],
	[6.9150000000E+03, 2.6439810051E+00, 6.8294388231E+00, 6.0897478467E-02, 5.9012077822E-02, 4.2684153858E-01],
	[6.9200000000E+03, 2.6463894084E+00, 6.8274080366E+00, 6.1031451008E-02, 5.9138926051E-02, 4.2702780052E-01],
	[6.9250000000E+03, 2.6487982637E+00, 6.8253793201E+00, 6.1165620870E-02, 5.9265949487E-02, 4.2721395629E-01],
	[6.9300000000E+03, 2.6512075705E+00, 6.8233526701E+00, 6.1299988200E-02, 5.9393148222E-02, 4.2740000618E-01],
	[6.9350000000E+03, 2.6536173288E+00, 6.8213280828E+00, 6.1434553146E-02, 5.9520522349E-02, 4.2758595050E-01],
	[6.9400000000E+03, 2.6560275383E+00, 6.8193055548E+00, 6.1569315855E-02, 5.9648071962E-02, 4.2777178954E-01],
	[6.9450000000E+03, 2.6584381987E+00, 6.8172850824E+00, 6.1704276473E-02, 5.9775797152E-02, 4.2795752360E-01],
	[6.9500000000E+03, 2.6608493097E+00, 6.8152666622E+00, 6.1839435147E-02, 5.9903698014E-02, 4.2814315298E-01],
	[6.9550000000E+03, 2.6632608712E+00, 6.8132502905E+00, 6.1974792025E-02, 6.0031774639E-02, 4.2832867798E-01],
	[6.9600000000E+03, 2.6656728830E+00, 6.8112359637E+00, 6.2110347254E-02, 6.0160027120E-02, 4.2851409888E-01],
	[6.9650000000E+03, 2.6680853446E+00, 6.8092236784E+00, 6.2246100981E-02, 6.0288455550E-02, 4.2869941599E-01],
	[6.9700000000E+03, 2.6704982561E+00, 6.8072134311E+00, 6.2382053352E-02, 6.0417060020E-02, 4.2888462960E-01],
	[6.9750000000E+03, 2.6729116170E+00, 6.8052052181E+00, 6.2518204516E-02, 6.0545840624E-02, 4.2906974000E-01],
	[6.9800000000E+03, 2.6753254271E+00, 6.8031990359E+00, 6.2654554618E-02, 6.0674797453E-02, 4.2925474748E-01],
	[6.9850000000E+03, 2.6777396863E+00, 6.8011948812E+00, 6.2791103807E-02, 6.0803930599E-02, 4.2943965235E-01],
	[6.9900000000E+03, 2.6801543942E+00, 6.7991927503E+00, 6.2927852228E-02, 6.0933240154E-02, 4.2962445488E-01],
	[6.9950000000E+03, 2.6825733701E+00, 6.7972136476E+00, 6.3064800030E-02, 6.1062729885E-02, 4.2980915536E-01],
	[7.0000000000E+03, 2.6849960062E+00, 6.7952541575E+00, 6.3201947360E-02, 6.1192399330E-02, 4.2999375410E-01],
	[7.0050000000E+03, 2.6874190980E+00, 6.7932966309E+00, 6.3340684940E-02, 6.1323548928E-02, 4.3017825138E-01],
	[7.0100000000E+03, 2.6898426453E+00, 6.7913410642E+00, 6.3479627456E-02, 6.1454879874E-02, 4.3036264748E-01],
	[7.0150000000E+03, 2.6922666478E+00, 6.7893874543E+00, 6.3618775062E-02, 6.1586392267E-02, 4.3054694269E-01],
	[7.0200000000E+03, 2.6946911053E+00, 6.7874357977E+00, 6.3758127915E-02, 6.1718086203E-02, 4.3073113731E-01],
	[7.0250000000E+03, 2.6971160175E+00, 6.7854860911E+00, 6.3897686169E-02, 6.1849961781E-02, 4.3091523162E-01],
	[7.0300000000E+03, 2.6995413843E+00, 6.7835383311E+00, 6.4037449981E-02, 6.1982019099E-02, 4.3109922590E-01],
	[7.0350000000E+03, 2.7019672053E+00, 6.7815925145E+00, 6.4177419506E-02, 6.2114258253E-02, 4.3128312044E-01],
	[7.0400000000E+03, 2.7043934804E+00, 6.7796486379E+00, 6.4317594900E-02, 6.2246679340E-02, 4.3146691552E-01],
	[7.0450000000E+03, 2.7068202092E+00, 6.7777066980E+00, 6.4457976318E-02, 6.2379282459E-02, 4.3165061149E-01],
	[7.0500000000E+03, 2.7092473916E+00, 6.7757666915E+00, 6.4598563915E-02, 6.2512067705E-02, 4.3183420866E-01],
	[7.0550000000E+03, 2.7116750274E+00, 6.7738286151E+00, 6.4739357848E-02, 6.2645035177E-02, 4.3201770730E-01],
	[7.0600000000E+03, 2.7141031162E+00, 6.7718924655E+00, 6.4880358271E-02, 6.2778184970E-02, 4.3220110769E-01],
	[7.0650000000E+03, 2.7165316579E+00, 6.7699582395E+00, 6.5021565341E-02, 6.2911517182E-02, 4.3238441010E-01],
	[7.0700000000E+03, 2.7189606522E+00, 6.7680259337E+00, 6.5162979212E-02, 6.3045031909E-02, 4.3256761480E-01],
	[7.0750000000E+03, 2.7213900989E+00, 6.7660955450E+00, 6.5304600042E-02, 6.3178729247E-02, 4.3275072204E-01],
	[7.0800000000E+03, 2.7238199977E+00, 6.7641670700E+00, 6.5446427984E-02, 6.3312609294E-02, 4.3293373211E-01],
	[7.0850000000E+03, 2.7262503484E+00, 6.7622405055E+00, 6.5588463195E-02, 6.3446672146E-02, 4.3311664527E-01],
	[7.0900000000E+03, 2.7286811508E+00, 6.7603158483E+00, 6.5730705831E-02, 6.3580917899E-02, 4.3329946179E-01],
	[7.0950000000E+03, 2.7311124047E+00, 6.7583930952E+00, 6.5873156046E-02, 6.3715346648E-02, 4.3348218193E-01],
	[7.1000000000E+03, 2.7335441097E+00, 6.7564722428E+00, 6.6015813997E-02, 6.3849958491E-02, 4.3366480596E-01],
	[7.1050000000E+03, 2.7359764711E+00, 6.7545544125E+00, 6.6158679840E-02, 6.3984753736E-02, 4.3384733414E-01],
	[7.1100000000E+03, 2.7384158365E+00, 6.7526743101E+00, 6.6301753729E-02, 6.4119739092E-02, 4.3402976673E-01],
	[7.1150000000E+03, 2.7408556598E+00, 6.7507960522E+00, 6.6445035820E-02, 6.4254907878E-02, 4.3421210401E-01],
	[7.1200000000E+03, 2.7432959405E+00, 6.7489196356E+00, 6.6588526270E-02, 6.4390260191E-02, 4.3439434624E-01],
	[7.1250000000E+03, 2.7457366786E+00, 6.7470450573E+00, 6.6732225234E-02, 6.4525796125E-02, 4.3457649367E-01],
	[7.1300000000E+03, 2.7481778737E+00, 6.7451723142E+00, 6.6876132867E-02, 6.4661515778E-02, 4.3475854656E-01],
	[7.1350000000E+03, 2.7506195256E+00, 6.7433014031E+00, 6.7020249325E-02, 6.4797419244E-02, 4.3494050519E-01],
	[7.1400000000E+03, 2.7530616342E+00, 6.7414323210E+00, 6.7164574764E-02, 6.4933506619E-02, 4.3512236981E-01],
	[7.1450000000E+03, 2.7555041991E+00, 6.7395650649E+00, 6.7309109340E-02, 6.5069777999E-02, 4.3530414067E-01],
	[7.1500000000E+03, 2.7579472201E+00, 6.7376996317E+00, 6.7453853208E-02, 6.5206233478E-02, 4.3548581805E-01],
	[7.1550000000E+03, 2.7603906971E+00, 6.7358360183E+00, 6.7598806523E-02, 6.5342873152E-02, 4.3566740220E-01],
	[7.1600000000E+03, 2.7628346297E+00, 6.7339742217E+00, 6.7743969442E-02, 6.5479697116E-02, 4.3584889337E-01],
	[7.1650000000E+03, 2.7652790177E+00, 6.7321142388E+00, 6.7889342120E-02, 6.5616705465E-02, 4.3603029183E-01],
	[7.1700000000E+03, 2.7677238609E+00, 6.7302560667E+00, 6.8034924713E-02, 6.5753898293E-02, 4.3621159782E-01],
	[7.1750000000E+03, 2.7701691591E+00, 6.7283997022E+00, 6.8180717377E-02, 6.5891275697E-02, 4.3639281162E-01],
	[7.1800000000E+03, 2.7726149120E+00, 6.7265451425E+00, 6.8326720267E-02, 6.6028837770E-02, 4.3657393347E-01],
	[7.1850000000E+03, 2.7750611194E+00, 6.7246923844E+00, 6.8472933539E-02, 6.6166584606E-02, 4.3675496363E-01],
	[7.1900000000E+03, 2.7775077811E+00, 6.7228414249E+00, 6.8619357349E-02, 6.6304516301E-02, 4.3693590235E-01],
	[7.1950000000E+03, 2.7799548968E+00, 6.7209922612E+00, 6.8765991853E-02, 6.6442632949E-02, 4.3711674989E-01],
	[7.2000000000E+03, 2.7824024663E+00, 6.7191448901E+00, 6.8912837205E-02, 6.6580934644E-02, 4.3729750650E-01],
	[7.2050000000E+03, 2.7848504893E+00, 6.7172993087E+00, 6.9059893563E-02, 6.6719421481E-02, 4.3747817244E-01],
	[7.2100000000E+03, 2.7872989658E+00, 6.7154555141E+00, 6.9207161081E-02, 6.6858093552E-02, 4.3765874795E-01],
	[7.2150000000E+03, 2.7897478953E+00, 6.7136135032E+00, 6.9354639916E-02, 6.6996950953E-02, 4.3783923329E-01],
	[7.2200000000E+03, 2.7921982847E+00, 6.7117787445E+00, 6.9502330223E-02, 6.7135994907E-02, 4.3801962871E-01],
	[7.2250000000E+03, 2.7946546320E+00, 6.7099756280E+00, 6.9650232159E-02, 6.7275230579E-02, 4.3819993447E-01],
	[7.2300000000E+03, 2.7971114386E+00, 6.7081742429E+00, 6.9798345877E-02, 6.7414651912E-02, 4.3838015080E-01],
	[7.2350000000E+03, 2.7995687043E+00, 6.7063745862E+00, 6.9946671536E-02, 6.7554259000E-02, 4.3856027797E-01],
	[7.2400000000E+03, 2.8020264289E+00, 6.7045766551E+00, 7.0095209290E-02, 6.7694051938E-02, 4.3874031622E-01],
	[7.2450000000E+03, 2.8044846122E+00, 6.7027804467E+00, 7.0243959295E-02, 6.7834030818E-02, 4.3892026579E-01],
	[7.2500000000E+03, 2.8069432538E+00, 6.7009859583E+00, 7.0392921707E-02, 6.7974195735E-02, 4.3910012694E-01],
	[7.2550000000E+03, 2.8094023537E+00, 6.6991931870E+00, 7.0542096681E-02, 6.8114546782E-02, 4.3927989992E-01],
	[7.2600000000E+03, 2.8118619115E+00, 6.6974021299E+00, 7.0691484375E-02, 6.8255084051E-02, 4.3945958497E-01],
	[7.2650000000E+03, 2.8143219270E+00, 6.6956127842E+00, 7.0841084942E-02, 6.8395807637E-02, 4.3963918234E-01],
	[7.2700000000E+03, 2.8167824001E+00, 6.6938251472E+00, 7.0990898540E-02, 6.8536717632E-02, 4.3981869227E-01],
	[7.2750000000E+03, 2.8192433304E+00, 6.6920392160E+00, 7.1140925323E-02, 6.8677814129E-02, 4.3999811501E-01],
	[7.2800000000E+03, 2.8217047177E+00, 6.6902549878E+00, 7.1291165449E-02, 6.8819097222E-02, 4.4017745081E-01],
	[7.2850000000E+03, 2.8241665619E+00, 6.6884724598E+00, 7.1441619072E-02, 6.8960567002E-02, 4.4035669990E-01],
	[7.2900000000E+03, 2.8266288626E+00, 6.6866916293E+00, 7.1592286348E-02, 6.9102223563E-02, 4.4053586254E-01],
	[7.2950000000E+03, 2.8290916197E+00, 6.6849124935E+00, 7.1743167434E-02, 6.9244066997E-02, 4.4071493896E-01],
	[7.3000000000E+03, 2.8315548329E+00, 6.6831350495E+00, 7.1894262485E-02, 6.9386097396E-02, 4.4089392941E-01],
	[7.3050000000E+03, 2.8340185020E+00, 6.6813592947E+00, 7.2045571657E-02, 6.9528314854E-02, 4.4107283414E-01],
	[7.3100000000E+03, 2.8364826268E+00, 6.6795852262E+00, 7.2197095106E-02, 6.9670719462E-02, 4.4125165337E-01],
	[7.3150000000E+03, 2.8389472070E+00, 6.6778128414E+00, 7.2348832988E-02, 6.9813311312E-02, 4.4143038736E-01],
	[7.3200000000E+03, 2.8414122424E+00, 6.6760421374E+00, 7.2500785458E-02, 6.9956090497E-02, 4.4160903635E-01],
	[7.3250000000E+03, 2.8438777329E+00, 6.6742731116E+00, 7.2652952673E-02, 7.0099057108E-02, 4.4178760057E-01],
	[7.3300000000E+03, 2.8463436780E+00, 6.6725057611E+00, 7.2805334788E-02, 7.0242211238E-02, 4.4196608027E-01],
	[7.3350000000E+03, 2.8488100777E+00, 6.6707400833E+00, 7.2957931960E-02, 7.0385552978E-02, 4.4214447568E-01],
	[7.3400000000E+03, 2.8512826347E+00, 6.6690068463E+00, 7.3110744343E-02, 7.0529089350E-02, 4.4232278704E-01],
	[7.3450000000E+03, 2.8537562107E+00, 6.6672782518E+00, 7.3263772095E-02, 7.0672814244E-02, 4.4250101460E-01],
	[7.3500000000E+03, 2.8562302472E+00, 6.6655512811E+00, 7.3417015370E-02, 7.0816727076E-02, 4.4267915859E-01],
	[7.3550000000E+03, 2.8587047438E+00, 6.6638259317E+00, 7.3570474326E-02, 7.0960827936E-02, 4.4285721924E-01],
	[7.3600000000E+03, 2.8611797005E+00, 6.6621022010E+00, 7.3724149117E-02, 7.1105116917E-02, 4.4303519680E-01],
	[7.3650000000E+03, 2.8636551168E+00, 6.6603800863E+00, 7.3878039900E-02, 7.1249594108E-02, 4.4321309150E-01],
	[7.3700000000E+03, 2.8661309928E+00, 6.6586595850E+00, 7.4032146831E-02, 7.1394259603E-02, 4.4339090357E-01],
	[7.3750000000E+03, 2.8686073280E+00, 6.6569406946E+00, 7.4186470065E-02, 7.1539113491E-02, 4.4356863326E-01],
	[7.3800000000E+03, 2.8710841222E+00, 6.6552234123E+00, 7.4341009758E-02, 7.1684155865E-02, 4.4374628079E-01],
	[7.3850000000E+03, 2.8735613754E+00, 6.6535077358E+00, 7.4495766068E-02, 7.1829386814E-02, 4.4392384640E-01],
	[7.3900000000E+03, 2.8760390871E+00, 6.6517936622E+00, 7.4650739148E-02, 7.1974806430E-02, 4.4410133033E-01],
	[7.3950000000E+03, 2.8785172573E+00, 6.6500811891E+00, 7.4805929156E-02, 7.2120414803E-02, 4.4427873281E-01],
	[7.4000000000E+03, 2.8809958856E+00, 6.6483703139E+00, 7.4961336247E-02, 7.2266212024E-02, 4.4445605407E-01],
	[7.4050000000E+03, 2.8834749719E+00, 6.6466610341E+00, 7.5116960578E-02, 7.2412198184E-02, 4.4463329435E-01],
	[7.4100000000E+03, 2.8859545159E+00, 6.6449533470E+00, 7.5272802303E-02, 7.2558373372E-02, 4.4481045387E-01],
	[7.4150000000E+03, 2.8884345174E+00, 6.6432472500E+00, 7.5428861580E-02, 7.2704737680E-02, 4.4498753287E-01],
	[7.4200000000E+03, 2.8909149761E+00, 6.6415427408E+00, 7.5585138564E-02, 7.2851291198E-02, 4.4516453158E-01],
	[7.4250000000E+03, 2.8933958919E+00, 6.6398398166E+00, 7.5741633412E-02, 7.2998034014E-02, 4.4534145023E-01],
	[7.4300000000E+03, 2.8958772646E+00, 6.6381384750E+00, 7.5898346278E-02, 7.3144966221E-02, 4.4551828906E-01],
	[7.4350000000E+03, 2.8983590938E+00, 6.6364387134E+00, 7.6055277320E-02, 7.3292087907E-02, 4.4569504828E-01],
	[7.4400000000E+03, 2.9008413795E+00, 6.6347405293E+00, 7.6212426693E-02, 7.3439399162E-02, 4.4587172814E-01],
	[7.4450000000E+03, 2.9033241212E+00, 6.6330439202E+00, 7.6369794553E-02, 7.3586900076E-02, 4.4604832885E-01],
	[7.4500000000E+03, 2.9058073190E+00, 6.6313488836E+00, 7.6527381056E-02, 7.3734590738E-02, 4.4622485065E-01],
	[7.4550000000E+03, 2.9082927308E+00, 6.6296648671E+00, 7.6685186359E-02, 7.3882473547E-02, 4.4640129377E-01],
	[7.4600000000E+03, 2.9107828522E+00, 6.6280052356E+00, 7.6843210617E-02, 7.4030551898E-02, 4.4657765844E-01],
	[7.4650000000E+03, 2.9132734352E+00, 6.6263471311E+00, 7.7001453986E-02, 7.4178820318E-02, 4.4675394487E-01],
	[7.4700000000E+03, 2.9157644795E+00, 6.6246905512E+00, 7.7159916622E-02, 7.4327278898E-02, 4.4693015330E-01],
	[7.4750000000E+03, 2.9182559848E+00, 6.6230354935E+00, 7.7318598682E-02, 7.4475927727E-02, 4.4710628396E-01],
	[7.4800000000E+03, 2.9207479510E+00, 6.6213819555E+00, 7.7477500321E-02, 7.4624766893E-02, 4.4728233707E-01],
	[7.4850000000E+03, 2.9232403778E+00, 6.6197299349E+00, 7.7636621696E-02, 7.4773796487E-02, 4.4745831286E-01],
	[7.4900000000E+03, 2.9257332649E+00, 6.6180794292E+00, 7.7795962962E-02, 7.4923016596E-02, 4.4763421155E-01],
	[7.4950000000E+03, 2.9282266123E+00, 6.6164304361E+00, 7.7955524276E-02, 7.5072427310E-02, 4.4781003336E-01],
	[7.5000000000E+03, 2.9307204196E+00, 6.6147829531E+00, 7.8115305793E-02, 7.5222028718E-02, 4.4798577852E-01],
	[7.5050000000E+03, 2.9332146866E+00, 6.6131369779E+00, 7.8275307670E-02, 7.5371820908E-02, 4.4816144726E-01],
	[7.5100000000E+03, 2.9357094132E+00, 6.6114925081E+00, 7.8435530063E-02, 7.5521803968E-02, 4.4833703980E-01],
	[7.5150000000E+03, 2.9382045990E+00, 6.6098495413E+00, 7.8595973128E-02, 7.5671977988E-02, 4.4851255636E-01],
	[7.5200000000E+03, 2.9407002439E+00, 6.6082080752E+00, 7.8756637021E-02, 7.5822343055E-02, 4.4868799717E-01],
	[7.5250000000E+03, 2.9431963477E+00, 6.6065681072E+00, 7.8917521898E-02, 7.5972899257E-02, 4.4886336244E-01],
	[7.5300000000E+03, 2.9456929100E+00, 6.6049296353E+00, 7.9078627915E-02, 7.6123646683E-02, 4.4903865240E-01],
	[7.5350000000E+03, 2.9481899308E+00, 6.6032926568E+00, 7.9239955229E-02, 7.6274585421E-02, 4.4921386729E-01],
	[7.5400000000E+03, 2.9506874097E+00, 6.6016571696E+00, 7.9401503995E-02, 7.6425715558E-02, 4.4938900729E-01],
	[7.5450000000E+03, 2.9531853467E+00, 6.6000231712E+00, 7.9563274369E-02, 7.6577037183E-02, 4.4956407261E-01],
	[7.5500000000E+03, 2.9556837413E+00, 6.5983906593E+00, 7.9725266508E-02, 7.6728550383E-02, 4.4973906345E-01],
	[7.5550000000E+03, 2.9581825935E+00, 6.5967596316E+00, 7.9887480568E-02, 7.6880255245E-02, 4.4991398000E-01],
	[7.5600000000E+03, 2.9606819030E+00, 6.5951300857E+00, 8.0049916705E-02, 7.7032151857E-02, 4.5008882247E-01],
	[7.5650000000E+03, 2.9631816696E+00, 6.5935020194E+00, 8.0212575074E-02, 7.7184240307E-02, 4.5026359104E-01],
	[7.5700000000E+03, 2.9656818930E+00, 6.5918754302E+00, 8.0375455833E-02, 7.7336520682E-02, 4.5043828592E-01],
	[7.5750000000E+03, 2.9681842668E+00, 6.5902593918E+00, 8.0538559138E-02, 7.7488995477E-02, 4.5061290730E-01],
	[7.5800000000E+03, 2.9706911626E+00, 6.5886665674E+00, 8.0701885143E-02, 7.7641668184E-02, 4.5078745537E-01],
	[7.5850000000E+03, 2.9731985205E+00, 6.5870751779E+00, 8.0865434007E-02, 7.7794533131E-02, 4.5096193035E-01],
	[7.5900000000E+03, 2.9757063403E+00, 6.5854852210E+00, 8.1029205884E-02, 7.7947590406E-02, 4.5113633241E-01],
	[7.5950000000E+03, 2.9782146217E+00, 6.5838966946E+00, 8.1193200931E-02, 7.8100840095E-02, 4.5131066176E-01],
	[7.6000000000E+03, 2.9807233647E+00, 6.5823095965E+00, 8.1357419305E-02, 7.8254282286E-02, 4.5148491858E-01],
	[7.6050000000E+03, 2.9832325689E+00, 6.5807239243E+00, 8.1521861160E-02, 7.8407917065E-02, 4.5165910308E-01],
	[7.6100000000E+03, 2.9857422341E+00, 6.5791396759E+00, 8.1686526655E-02, 7.8561744518E-02, 4.5183321545E-01],
	[7.6150000000E+03, 2.9882523601E+00, 6.5775568491E+00, 8.1851415944E-02, 7.8715764732E-02, 4.5200725588E-01],
	[7.6200000000E+03, 2.9907629467E+00, 6.5759754417E+00, 8.2016529184E-02, 7.8869977794E-02, 4.5218122457E-01],
	[7.6250000000E+03, 2.9932739937E+00, 6.5743954515E+00, 8.2181866531E-02, 7.9024383790E-02, 4.5235512170E-01],
	[7.6300000000E+03, 2.9957855008E+00, 6.5728168762E+00, 8.2347428141E-02, 7.9178982806E-02, 4.5252894747E-01],
	[7.6350000000E+03, 2.9982974679E+00, 6.5712397136E+00, 8.2513214171E-02, 7.9333774927E-02, 4.5270270208E-01],
	[7.6400000000E+03, 3.0008098947E+00, 6.5696639617E+00, 8.2679224777E-02, 7.9488760241E-02, 4.5287638571E-01],
	[7.6450000000E+03, 3.0033227810E+00, 6.5680896182E+00, 8.2845460115E-02, 7.9643938833E-02, 4.5304999856E-01],
	[7.6500000000E+03, 3.0058361266E+00, 6.5665166808E+00, 8.3011920341E-02, 7.9799310788E-02, 4.5322354081E-01],
	[7.6550000000E+03, 3.0083499312E+00, 6.5649451476E+00, 8.3178605611E-02, 7.9954876193E-02, 4.5339701267E-01],
	[7.6600000000E+03, 3.0108641947E+00, 6.5633750162E+00, 8.3345516082E-02, 8.0110635132E-02, 4.5357041431E-01],
	[7.6650000000E+03, 3.0133789169E+00, 6.5618062845E+00, 8.3512651910E-02, 8.0266587691E-02, 4.5374374593E-01],
	[7.6700000000E+03, 3.0158940975E+00, 6.5602389504E+00, 8.3680013252E-02, 8.0422733956E-02, 4.5391700773E-01],
	[7.6750000000E+03, 3.0184097363E+00, 6.5586730117E+00, 8.3847600262E-02, 8.0579074012E-02, 4.5409019988E-01],
	[7.6800000000E+03, 3.0209258330E+00, 6.5571084662E+00, 8.4015413099E-02, 8.0735607943E-02, 4.5426332258E-01],
	[7.6850000000E+03, 3.0234423876E+00, 6.5555453118E+00, 8.4183451917E-02, 8.0892335835E-02, 4.5443637602E-01],
	[7.6900000000E+03, 3.0259593997E+00, 6.5539835464E+00, 8.4351716874E-02, 8.1049257773E-02, 4.5460936039E-01],
	[7.6950000000E+03, 3.0284768692E+00, 6.5524231679E+00, 8.4520208125E-02, 8.1206373841E-02, 4.5478227587E-01],
	[7.7000000000E+03, 3.0309998003E+00, 6.5508909423E+00, 8.4688925827E-02, 8.1363691860E-02, 4.5495512265E-01],
	[7.7050000000E+03, 3.0335236911E+00, 6.5493627285E+00, 8.4857870136E-02, 8.1521205001E-02, 4.5512790092E-01],
	[7.7100000000E+03, 3.0360480441E+00, 6.5478358623E+00, 8.5027041209E-02, 8.1678912582E-02, 4.5530061087E-01],
	[7.7150000000E+03, 3.0385728593E+00, 6.5463103416E+00, 8.5196439201E-02, 8.1836814687E-02, 4.5547325269E-01],
	[7.7200000000E+03, 3.0410981362E+00, 6.5447861643E+00, 8.5366064269E-02, 8.1994911402E-02, 4.5564582656E-01],
	[7.7250000000E+03, 3.0436238749E+00, 6.5432633283E+00, 8.5535916569E-02, 8.2153202810E-02, 4.5581833266E-01],
	[7.7300000000E+03, 3.0461500749E+00, 6.5417418317E+00, 8.5705996258E-02, 8.2311688996E-02, 4.5599077119E-01],
	[7.7350000000E+03, 3.0486767362E+00, 6.5402216724E+00, 8.5876303492E-02, 8.2470370044E-02, 4.5616314233E-01],
	[7.7400000000E+03, 3.0512038584E+00, 6.5387028483E+00, 8.6046838427E-02, 8.2629246037E-02, 4.5633544627E-01],
	[7.7450000000E+03, 3.0537314415E+00, 6.5371853574E+00, 8.6217601220E-02, 8.2788317060E-02, 4.5650768319E-01],
	[7.7500000000E+03, 3.0562594851E+00, 6.5356691977E+00, 8.6388592027E-02, 8.2947583197E-02, 4.5667985327E-01],
	[7.7550000000E+03, 3.0587879891E+00, 6.5341543671E+00, 8.6559811004E-02, 8.3107044531E-02, 4.5685195670E-01],
	[7.7600000000E+03, 3.0613169532E+00, 6.5326408637E+00, 8.6731258307E-02, 8.3266701145E-02, 4.5702399367E-01],
	[7.7650000000E+03, 3.0638463772E+00, 6.5311286854E+00, 8.6902934094E-02, 8.3426553124E-02, 4.5719596435E-01],
	[7.7700000000E+03, 3.0663762610E+00, 6.5296178302E+00, 8.7074838520E-02, 8.3586600550E-02, 4.5736786894E-01],
	[7.7750000000E+03, 3.0689066042E+00, 6.5281082961E+00, 8.7246971741E-02, 8.3746843507E-02, 4.5753970762E-01],
	[7.7800000000E+03, 3.0714374068E+00, 6.5266000810E+00, 8.7419333915E-02, 8.3907282077E-02, 4.5771148056E-01],
	[7.7850000000E+03, 3.0739686684E+00, 6.5250931831E+00, 8.7591925196E-02, 8.4067916345E-02, 4.5788318795E-01],
	[7.7900000000E+03, 3.0765003889E+00, 6.5235876003E+00, 8.7764745743E-02, 8.4228746392E-02, 4.5805482998E-01],
	[7.7950000000E+03, 3.0790325681E+00, 6.5220833306E+00, 8.7937795711E-02, 8.4389772302E-02, 4.5822640683E-01],
	[7.8000000000E+03, 3.0815652057E+00, 6.5205803720E+00, 8.8111075256E-02, 8.4550994157E-02, 4.5839791867E-01],
	[7.8050000000E+03, 3.0840983016E+00, 6.5190787225E+00, 8.8284584535E-02, 8.4712412039E-02, 4.5856936569E-01],
	[7.8100000000E+03, 3.0866318555E+00, 6.5175783802E+00, 8.8458323705E-02, 8.4874026032E-02, 4.5874074808E-01],
	[7.8150000000E+03, 3.0891658671E+00, 6.5160793431E+00, 8.8632292921E-02, 8.5035836218E-02, 4.5891206600E-01],
	[7.8200000000E+03, 3.0917010302E+00, 6.5145853262E+00, 8.8806492341E-02, 8.5197843840E-02, 4.5908331965E-01],
	[7.8250000000E+03, 3.0942412022E+00, 6.5131169661E+00, 8.8980922120E-02, 8.5360055475E-02, 4.5925450921E-01],
	[7.8300000000E+03, 3.0967818368E+00, 6.5116498745E+00, 8.9155582415E-02, 8.5522463606E-02, 4.5942563484E-01],
	[7.8350000000E+03, 3.0993229335E+00, 6.5101840496E+00, 8.9330473382E-02, 8.5685068315E-02, 4.5959669674E-01],
	[7.8400000000E+03, 3.1018644923E+00, 6.5087194896E+00, 8.9505595178E-02, 8.5847869684E-02, 4.5976769509E-01],
	[7.8450000000E+03, 3.1044065128E+00, 6.5072561924E+00, 8.9680947959E-02, 8.6010867795E-02, 4.5993863006E-01],
	[7.8500000000E+03, 3.1069489950E+00, 6.5057941562E+00, 8.9856531883E-02, 8.6174062730E-02, 4.6010950183E-01],
	[7.8550000000E+03, 3.1094919385E+00, 6.5043333791E+00, 9.0032347104E-02, 8.6337454571E-02, 4.6028031058E-01],
	[7.8600000000E+03, 3.1120353432E+00, 6.5028738592E+00, 9.0208393779E-02, 8.6501043399E-02, 4.6045105649E-01],
	[7.8650000000E+03, 3.1145792089E+00, 6.5014155947E+00, 9.0384672066E-02, 8.6664829295E-02, 4.6062173974E-01],
	[7.8700000000E+03, 3.1171235353E+00, 6.4999585837E+00, 9.0561182120E-02, 8.6828812341E-02, 4.6079236050E-01],
	[7.8750000000E+03, 3.1196683222E+00, 6.4985028242E+00, 9.0737924099E-02, 8.6992992618E-02, 4.6096291896E-01],
	[7.8800000000E+03, 3.1222135695E+00, 6.4970483145E+00, 9.0914898157E-02, 8.7157370207E-02, 4.6113341529E-01],
	[7.8850000000E+03, 3.1247592770E+00, 6.4955950527E+00, 9.1092104453E-02, 8.7321945190E-02, 4.6130384966E-01],
	[7.8900000000E+03, 3.1273054443E+00, 6.4941430368E+00, 9.1269543142E-02, 8.7486717647E-02, 4.6147422227E-01],
	[7.8950000000E+03, 3.1298520713E+00, 6.4926922651E+00, 9.1447214380E-02, 8.7651687658E-02, 4.6164453327E-01],
	[7.9000000000E+03, 3.1323991579E+00, 6.4912427357E+00, 9.1625118325E-02, 8.7816855306E-02, 4.6181478285E-01],
	[7.9050000000E+03, 3.1349467037E+00, 6.4897944467E+00, 9.1803255133E-02, 8.7982220669E-02, 4.6198497119E-01],
	[7.9100000000E+03, 3.1374947087E+00, 6.4883473963E+00, 9.1981624960E-02, 8.8147783829E-02, 4.6215509846E-01],
	[7.9150000000E+03, 3.1400431725E+00, 6.4869015827E+00, 9.2160227963E-02, 8.8313544865E-02, 4.6232516483E-01],
	[7.9200000000E+03, 3.1425920949E+00, 6.4854570039E+00, 9.2339064298E-02, 8.8479503859E-02, 4.6249517049E-01],
	[7.9250000000E+03, 3.1451414759E+00, 6.4840136583E+00, 9.2518134123E-02, 8.8645660890E-02, 4.6266511560E-01],
	[7.9300000000E+03, 3.1476913151E+00, 6.4825715439E+00, 9.2697437592E-02, 8.8812016038E-02, 4.6283500035E-01],
	[7.9350000000E+03, 3.1502416123E+00, 6.4811306590E+00, 9.2876974864E-02, 8.8978569383E-02, 4.6300482490E-01],
	[7.9400000000E+03, 3.1527923674E+00, 6.4796910017E+00, 9.3056746093E-02, 8.9145321005E-02, 4.6317458943E-01],
	[7.9450000000E+03, 3.1553435801E+00, 6.4782525701E+00, 9.3236751438E-02, 8.9312270984E-02, 4.6334429411E-01],
	[7.9500000000E+03, 3.1579000201E+00, 6.4768409660E+00, 9.3416991054E-02, 8.9479428115E-02, 4.6351393913E-01],
	[7.9550000000E+03, 3.1604571408E+00, 6.4754317293E+00, 9.3597465099E-02, 8.9646784217E-02, 4.6368352465E-01],
	[7.9600000000E+03, 3.1630147234E+00, 6.4740236844E+00, 9.3778173728E-02, 8.9814338973E-02, 4.6385305084E-01],
	[7.9650000000E+03, 3.1655727677E+00, 6.4726168295E+00, 9.3959117098E-02, 8.9982092462E-02, 4.6402251788E-01],
	[7.9700000000E+03, 3.1681312736E+00, 6.4712111629E+00, 9.4140295365E-02, 9.0150044762E-02, 4.6419192595E-01],
	[7.9750000000E+03, 3.1706902408E+00, 6.4698066829E+00, 9.4321708687E-02, 9.0318195954E-02, 4.6436127520E-01],
	[7.9800000000E+03, 3.1732496691E+00, 6.4684033877E+00, 9.4503357220E-02, 9.0486546115E-02, 4.6453056583E-01],
	[7.9850000000E+03, 3.1758095584E+00, 6.4670012755E+00, 9.4685241120E-02, 9.0655095326E-02, 4.6469979799E-01],
	[7.9900000000E+03, 3.1783699083E+00, 6.4656003447E+00, 9.4867360545E-02, 9.0823843665E-02, 4.6486897185E-01],
	[7.9950000000E+03, 3.1809307188E+00, 6.4642005935E+00, 9.5049715649E-02, 9.0992791211E-02, 4.6503808755E-01],
	[8.0000000000E+03, 3.1834919896E+00, 6.4628020202E+00, 9.5232306591E-02, 9.1161938042E-02, 4.6520714523E-01],
	[8.0050000000E+03, 3.1860537204E+00, 6.4614046230E+00, 9.5416086971E-02, 9.1332157811E-02, 4.6537614505E-01],
	[8.0100000000E+03, 3.1886159112E+00, 6.4600084002E+00, 9.5600106592E-02, 9.1502579636E-02, 4.6554508715E-01],
	[8.0150000000E+03, 3.1911785616E+00, 6.4586133501E+00, 9.5784365616E-02, 9.1673203598E-02, 4.6571397167E-01],
	[8.0200000000E+03, 3.1937416716E+00, 6.4572194710E+00, 9.5968864203E-02, 9.1844029779E-02, 4.6588279877E-01],
	[8.0250000000E+03, 3.1963052408E+00, 6.4558267612E+00, 9.6153602515E-02, 9.2015058260E-02, 4.6605156858E-01],
	[8.0300000000E+03, 3.1988692691E+00, 6.4544352190E+00, 9.6338580713E-02, 9.2186289120E-02, 4.6622028125E-01],
	[8.0350000000E+03, 3.2014337562E+00, 6.4530448426E+00, 9.6523798959E-02, 9.2357722441E-02, 4.6638893693E-01],
	[8.0400000000E+03, 3.2039987020E+00, 6.4516556303E+00, 9.6709257412E-02, 9.2529358304E-02, 4.6655753577E-01],
	[8.0450000000E+03, 3.2065641063E+00, 6.4502675806E+00, 9.6894956235E-02, 9.2701196788E-02, 4.6672607790E-01],
	[8.0500000000E+03, 3.2091299688E+00, 6.4488806916E+00, 9.7080895589E-02, 9.2873237974E-02, 4.6689456347E-01],
	[8.0550000000E+03, 3.2116962894E+00, 6.4474949616E+00, 9.7267075634E-02, 9.3045481942E-02, 4.6706299264E-01],
	[8.0600000000E+03, 3.2142630679E+00, 6.4461103891E+00, 9.7453496533E-02, 9.3217928772E-02, 4.6723136553E-01],
	[8.0650000000E+03, 3.2168303040E+00, 6.4447269722E+00, 9.7640158445E-02, 9.3390578544E-02, 4.6739968230E-01],
	[8.0700000000E+03, 3.2193979976E+00, 6.4433447094E+00, 9.7827061533E-02, 9.3563431338E-02, 4.6756794308E-01],
	[8.0750000000E+03, 3.2219679432E+00, 6.4419731851E+00, 9.8014205958E-02, 9.3736490782E-02, 4.6773614803E-01],
	[8.0800000000E+03, 3.2245413437E+00, 6.4406187872E+00, 9.8201591880E-02, 9.3909759370E-02, 4.6790429729E-01],
	[8.0850000000E+03, 3.2271152058E+00, 6.4392655118E+00, 9.8389219461E-02, 9.4083231278E-02, 4.6807239099E-01],
	[8.0900000000E+03, 3.2296895291E+00, 6.4379133570E+00, 9.8577088863E-02, 9.4256906587E-02, 4.6824042929E-01],
	[8.0950000000E+03, 3.2322643136E+00, 6.4365623214E+00, 9.8765200246E-02, 9.4430785376E-02, 4.6840841233E-01],
	[8.1000000000E+03, 3.2348395590E+00, 6.4352124032E+00, 9.8953553771E-02, 9.4604867724E-02, 4.6857634024E-01],
	[8.1050000000E+03, 3.2374152651E+00, 6.4338636009E+00, 9.9142149601E-02, 9.4779153710E-02, 4.6874421317E-01],
	[8.1100000000E+03, 3.2399914317E+00, 6.4325159129E+00, 9.9330987896E-02, 9.4953643413E-02, 4.6891203127E-01],
	[8.1150000000E+03, 3.2425680586E+00, 6.4311693376E+00, 9.9520068817E-02, 9.5128336914E-02, 4.6907979467E-01],
	[8.1200000000E+03, 3.2451451456E+00, 6.4298238733E+00, 9.9709392526E-02, 9.5303234289E-02, 4.6924750352E-01],
	[8.1250000000E+03, 3.2477226925E+00, 6.4284795185E+00, 9.9898959183E-02, 9.5478335619E-02, 4.6941515796E-01],
	[8.1300000000E+03, 3.2503006992E+00, 6.4271362715E+00, 1.0008876895E-01, 9.5653640981E-02, 4.6958275813E-01],
	[8.1350000000E+03, 3.2528791653E+00, 6.4257941308E+00, 1.0027882199E-01, 9.5829150454E-02, 4.6975030418E-01],
	[8.1400000000E+03, 3.2554580908E+00, 6.4244530948E+00, 1.0046911846E-01, 9.6004864117E-02, 4.6991779623E-01],
	[8.1450000000E+03, 3.2580374753E+00, 6.4231131618E+00, 1.0065965853E-01, 9.6180782048E-02, 4.7008523445E-01],
	[8.1500000000E+03, 3.2606173187E+00, 6.4217743304E+00, 1.0085044235E-01, 9.6356904325E-02, 4.7025261895E-01],
	[8.1550000000E+03, 3.2631976209E+00, 6.4204365989E+00, 1.0104147009E-01, 9.6533231027E-02, 4.7041994990E-01],
	[8.1600000000E+03, 3.2657783815E+00, 6.4190999657E+00, 1.0123274191E-01, 9.6709762230E-02, 4.7058722742E-01],
	[8.1650000000E+03, 3.2683596005E+00, 6.4177644294E+00, 1.0142425796E-01, 9.6886498012E-02, 4.7075445166E-01],
	[8.1700000000E+03, 3.2709412775E+00, 6.4164299882E+00, 1.0161601842E-01, 9.7063438453E-02, 4.7092162276E-01],
	[8.1750000000E+03, 3.2735234125E+00, 6.4150966406E+00, 1.0180802344E-01, 9.7240583628E-02, 4.7108874085E-01],
	[8.1800000000E+03, 3.2761060052E+00, 6.4137643852E+00, 1.0200027318E-01, 9.7417933616E-02, 4.7125580609E-01],
	[8.1850000000E+03, 3.2786890553E+00, 6.4124332202E+00, 1.0219276781E-01, 9.7595488494E-02, 4.7142281860E-01],
	[8.1900000000E+03, 3.2812725628E+00, 6.4111031442E+00, 1.0238550748E-01, 9.7773248338E-02, 4.7158977853E-01],
	[8.1950000000E+03, 3.2838565274E+00, 6.4097741556E+00, 1.0257849236E-01, 9.7951213227E-02, 4.7175668601E-01],
	[8.2000000000E+03, 3.2864409489E+00, 6.4084462528E+00, 1.0277172261E-01, 9.8129383237E-02, 4.7192354119E-01],
	[8.2050000000E+03, 3.2890275976E+00, 6.4071287649E+00, 1.0296519839E-01, 9.8307762223E-02, 4.7209034421E-01],
	[8.2100000000E+03, 3.2916175764E+00, 6.4058274709E+00, 1.0315891987E-01, 9.8486352653E-02, 4.7225709520E-01],
	[8.2150000000E+03, 3.2942080160E+00, 6.4045272332E+00, 1.0335288719E-01, 9.8665148495E-02, 4.7242379430E-01],
	[8.2200000000E+03, 3.2967989161E+00, 6.4032280504E+00, 1.0354710053E-01, 9.8844149828E-02, 4.7259044165E-01],
	[8.2250000000E+03, 3.2993902767E+00, 6.4019299208E+00, 1.0374156004E-01, 9.9023356727E-02, 4.7275703739E-01],
	[8.2300000000E+03, 3.3019820975E+00, 6.4006328431E+00, 1.0393626590E-01, 9.9202769269E-02, 4.7292358166E-01],
	[8.2350000000E+03, 3.3045743783E+00, 6.3993368157E+00, 1.0413121825E-01, 9.9382387531E-02, 4.7309007460E-01],
	[8.2400000000E+03, 3.3071671188E+00, 6.3980418372E+00, 1.0432641726E-01, 9.9562211588E-02, 4.7325651633E-01],
	[8.2450000000E+03, 3.3097603190E+00, 6.3967479061E+00, 1.0452186309E-01, 9.9742241517E-02, 4.7342290701E-01],
	[8.2500000000E+03, 3.3123539786E+00, 6.3954550208E+00, 1.0471755591E-01, 9.9922477394E-02, 4.7358924677E-01],
	[8.2550000000E+03, 3.3149480974E+00, 6.3941631799E+00, 1.0491349587E-01, 1.0010291929E-01, 4.7375553575E-01],
	[8.2600000000E+03, 3.3175426752E+00, 6.3928723819E+00, 1.0510968313E-01, 1.0028356729E-01, 4.7392177407E-01],
	[8.2650000000E+03, 3.3201377118E+00, 6.3915826255E+00, 1.0530611786E-01, 1.0046442147E-01, 4.7408796189E-01],
	[8.2700000000E+03, 3.3227332071E+00, 6.3902939090E+00, 1.0550280023E-01, 1.0064548189E-01, 4.7425409934E-01],
	[8.2750000000E+03, 3.3253291607E+00, 6.3890062310E+00, 1.0569973038E-01, 1.0082674865E-01, 4.7442018655E-01],
	[8.2800000000E+03, 3.3279255726E+00, 6.3877195901E+00, 1.0589690848E-01, 1.0100822180E-01, 4.7458622366E-01],
	[8.2850000000E+03, 3.3305224425E+00, 6.3864339847E+00, 1.0609433470E-01, 1.0118990143E-01, 4.7475221081E-01],
	[8.2900000000E+03, 3.3331197703E+00, 6.3851494135E+00, 1.0629200919E-01, 1.0137178761E-01, 4.7491814813E-01],
	[8.2950000000E+03, 3.3357175557E+00, 6.3838658750E+00, 1.0648993212E-01, 1.0155388041E-01, 4.7508403576E-01],
	[8.3000000000E+03, 3.3383157985E+00, 6.3825833678E+00, 1.0668810364E-01, 1.0173617992E-01, 4.7524987384E-01],
	[8.3050000000E+03, 3.3409144986E+00, 6.3813018903E+00, 1.0688652393E-01, 1.0191868620E-01, 4.7541566250E-01],
	[8.3100000000E+03, 3.3435136557E+00, 6.3800214411E+00, 1.0708519314E-01, 1.0210139934E-01, 4.7558140187E-01],
	[8.3150000000E+03, 3.3461132697E+00, 6.3787420188E+00, 1.0728411142E-01, 1.0228431940E-01, 4.7574709210E-01],
	[8.3200000000E+03, 3.3487133404E+00, 6.3774636220E+00, 1.0748327896E-01, 1.0246744646E-01, 4.7591273332E-01],
	[8.3250000000E+03, 3.3513138675E+00, 6.3761862493E+00, 1.0768269589E-01, 1.0265078059E-01, 4.7607832566E-01],
	[8.3300000000E+03, 3.3539148509E+00, 6.3749098990E+00, 1.0788236240E-01, 1.0283432186E-01, 4.7624386926E-01],
	[8.3350000000E+03, 3.3565162904E+00, 6.3736345700E+00, 1.0808227863E-01, 1.0301807036E-01, 4.7640936425E-01],
	[8.3400000000E+03, 3.3591225438E+00, 6.3723829241E+00, 1.0828244475E-01, 1.0320203622E-01, 4.7657481078E-01],
	[8.3450000000E+03, 3.3617293931E+00, 6.3711329806E+00, 1.0848286093E-01, 1.0338620981E-01, 4.7674020896E-01],
	[8.3500000000E+03, 3.3643367022E+00, 6.3698840306E+00, 1.0868352731E-01, 1.0357059092E-01, 4.7690555894E-01],
	[8.3550000000E+03, 3.3669444708E+00, 6.3686360730E+00, 1.0888444407E-01, 1.0375517960E-01, 4.7707086086E-01],
	[8.3600000000E+03, 3.3695526988E+00, 6.3673891062E+00, 1.0908561137E-01, 1.0393997594E-01, 4.7723611484E-01],
	[8.3650000000E+03, 3.3721613860E+00, 6.3661431289E+00, 1.0928702937E-01, 1.0412498001E-01, 4.7740132102E-01],
	[8.3700000000E+03, 3.3747705322E+00, 6.3648981398E+00, 1.0948869823E-01, 1.0431019187E-01, 4.7756647954E-01],
	[8.3750000000E+03, 3.3773801373E+00, 6.3636541374E+00, 1.0969061810E-01, 1.0449561161E-01, 4.7773159052E-01],
	[8.3800000000E+03, 3.3799902009E+00, 6.3624111204E+00, 1.0989278916E-01, 1.0468123930E-01, 4.7789665410E-01],
	[8.3850000000E+03, 3.3826007229E+00, 6.3611690874E+00, 1.1009521157E-01, 1.0486707500E-01, 4.7806167043E-01],
	[8.3900000000E+03, 3.3852117032E+00, 6.3599280371E+00, 1.1029788548E-01, 1.0505311880E-01, 4.7822663961E-01],
	[8.3950000000E+03, 3.3878231415E+00, 6.3586879680E+00, 1.1050081105E-01, 1.0523937076E-01, 4.7839156181E-01],
	[8.4000000000E+03, 3.3904350376E+00, 6.3574488789E+00, 1.1070398846E-01, 1.0542583096E-01, 4.7855643713E-01],
	[8.4050000000E+03, 3.3930473914E+00, 6.3562107684E+00, 1.1090741786E-01, 1.0561249947E-01, 4.7872126573E-01],
	[8.4100000000E+03, 3.3956602027E+00, 6.3549736350E+00, 1.1111109941E-01, 1.0579937636E-01, 4.7888604772E-01],
	[8.4150000000E+03, 3.3982734712E+00, 6.3537374776E+00, 1.1131503327E-01, 1.0598646171E-01, 4.7905078325E-01],
	[8.4200000000E+03, 3.4008871967E+00, 6.3525022947E+00, 1.1151921961E-01, 1.0617375559E-01, 4.7921547243E-01],
	[8.4250000000E+03, 3.4035013792E+00, 6.3512680849E+00, 1.1172365859E-01, 1.0636125806E-01, 4.7938011536E-01],
	[8.4300000000E+03, 3.4061160184E+00, 6.3500348470E+00, 1.1192835037E-01, 1.0654896921E-01, 4.7954471216E-01],
	[8.4350000000E+03, 3.4087311140E+00, 6.3488025795E+00, 1.1213329510E-01, 1.0673688909E-01, 4.7970926292E-01],
	[8.4400000000E+03, 3.4113466660E+00, 6.3475712813E+00, 1.1233849297E-01, 1.0692501779E-01, 4.7987376776E-01],
	[8.4450000000E+03, 3.4139626740E+00, 6.3463409508E+00, 1.1254394411E-01, 1.0711335538E-01, 4.8003822679E-01],
	[8.4500000000E+03, 3.4165791380E+00, 6.3451115868E+00, 1.1274964870E-01, 1.0730190192E-01, 4.8020264011E-01],
	[8.4550000000E+03, 3.4191960578E+00, 6.3438831879E+00, 1.1295560690E-01, 1.0749065749E-01, 4.8036700784E-01],
	[8.4600000000E+03, 3.4218134330E+00, 6.3426557529E+00, 1.1316181887E-01, 1.0767962217E-01, 4.8053133007E-01],
	[8.4650000000E+03, 3.4244312637E+00, 6.3414292804E+00, 1.1336828477E-01, 1.0786879601E-01, 4.8069560692E-01],
	[8.4700000000E+03, 3.4270501263E+00, 6.3402067360E+00, 1.1357500476E-01, 1.0805818052E-01, 4.8085983849E-01],
	[8.4750000000E+03, 3.4296732121E+00, 6.3390045073E+00, 1.1378197900E-01, 1.0824778376E-01, 4.8102402490E-01],
	[8.4800000000E+03, 3.4322967567E+00, 6.3378032154E+00, 1.1398920767E-01, 1.0843759645E-01, 4.8118816625E-01],
	[8.4850000000E+03, 3.4349207600E+00, 6.3366028591E+00, 1.1419669091E-01, 1.0862761865E-01, 4.8135226264E-01],
	[8.4900000000E+03, 3.4375452217E+00, 6.3354034371E+00, 1.1440448072E-01, 1.0881789734E-01, 4.8151631418E-01],
	[8.4950000000E+03, 3.4401701418E+00, 6.3342049481E+00, 1.1461252869E-01, 1.0900838862E-01, 4.8168032098E-01],
	[8.5000000000E+03, 3.4427955199E+00, 6.3330073907E+00, 1.1482083191E-01, 1.0919908978E-01, 4.8184428316E-01],
	[8.5050000000E+03, 3.4454213560E+00, 6.3318107639E+00, 1.1502939054E-01, 1.0939000089E-01, 4.8200820080E-01],
	[8.5100000000E+03, 3.4480476498E+00, 6.3306150662E+00, 1.1523820473E-01, 1.0958112203E-01, 4.8217207403E-01],
	[8.5150000000E+03, 3.4506744011E+00, 6.3294202965E+00, 1.1544727467E-01, 1.0977245327E-01, 4.8233590294E-01],
	[8.5200000000E+03, 3.4533016098E+00, 6.3282264534E+00, 1.1565660049E-01, 1.0996399466E-01, 4.8249968764E-01],
	[8.5250000000E+03, 3.4559292756E+00, 6.3270335356E+00, 1.1586618238E-01, 1.1015574629E-01, 4.8266342825E-01],
	[8.5300000000E+03, 3.4585573984E+00, 6.3258415420E+00, 1.1607602048E-01, 1.1034770823E-01, 4.8282712486E-01],
	[8.5350000000E+03, 3.4611859780E+00, 6.3246504713E+00, 1.1628611497E-01, 1.1053988054E-01, 4.8299077758E-01],
	[8.5400000000E+03, 3.4638150142E+00, 6.3234603222E+00, 1.1649646600E-01, 1.1073226329E-01, 4.8315438653E-01],
	[8.5450000000E+03, 3.4664445068E+00, 6.3222710935E+00, 1.1670707374E-01, 1.1092485655E-01, 4.8331795179E-01],
	[8.5500000000E+03, 3.4690744556E+00, 6.3210827839E+00, 1.1691793834E-01, 1.1111766039E-01, 4.8348147349E-01],
	[8.5550000000E+03, 3.4717048604E+00, 6.3198953921E+00, 1.1712905997E-01, 1.1131067489E-01, 4.8364495172E-01],
	[8.5600000000E+03, 3.4743357210E+00, 6.3187089170E+00, 1.1734043880E-01, 1.1150390010E-01, 4.8380838659E-01],
	[8.5650000000E+03, 3.4769670373E+00, 6.3175233573E+00, 1.1755207498E-01, 1.1169733611E-01, 4.8397177821E-01],
	[8.5700000000E+03, 3.4795988091E+00, 6.3163387117E+00, 1.1776396868E-01, 1.1189098297E-01, 4.8413512669E-01],
	[8.5750000000E+03, 3.4822310362E+00, 6.3151549790E+00, 1.1797612006E-01, 1.1208484076E-01, 4.8429843212E-01],
	[8.5800000000E+03, 3.4848637183E+00, 6.3139721580E+00, 1.1818852928E-01, 1.1227890954E-01, 4.8446169461E-01],
	[8.5850000000E+03, 3.4874968554E+00, 6.3127902474E+00, 1.1840119650E-01, 1.1247318938E-01, 4.8462491428E-01],
	[8.5900000000E+03, 3.4901304471E+00, 6.3116092460E+00, 1.1861412189E-01, 1.1266768036E-01, 4.8478809122E-01],
	[8.5950000000E+03, 3.4927644935E+00, 6.3104291526E+00, 1.1882730560E-01, 1.1286238254E-01, 4.8495122553E-01],
	[8.6000000000E+03, 3.4953989941E+00, 6.3092499659E+00, 1.1904074780E-01, 1.1305729598E-01, 4.8511431733E-01],
	[8.6050000000E+03, 3.4980339489E+00, 6.3080716848E+00, 1.1925444866E-01, 1.1325242076E-01, 4.8527736672E-01],
	[8.6100000000E+03, 3.5006729801E+00, 6.3069127244E+00, 1.1946840833E-01, 1.1344776671E-01, 4.8544037380E-01],
	[8.6150000000E+03, 3.5033130395E+00, 6.3057575501E+00, 1.1968262698E-01, 1.1364332573E-01, 4.8560333868E-01],
	[8.6200000000E+03, 3.5059535563E+00, 6.3046032574E+00, 1.1989710476E-01, 1.1383909635E-01, 4.8576626147E-01],
	[8.6250000000E+03, 3.5085945305E+00, 6.3034498452E+00, 1.2011184185E-01, 1.1403507865E-01, 4.8592914226E-01],
	[8.6300000000E+03, 3.5112359617E+00, 6.3022973123E+00, 1.2032683840E-01, 1.1423127269E-01, 4.8609198116E-01],
	[8.6350000000E+03, 3.5138778499E+00, 6.3011456574E+00, 1.2054209457E-01, 1.1442767854E-01, 4.8625477828E-01],
	[8.6400000000E+03, 3.5165201949E+00, 6.2999948795E+00, 1.2075761054E-01, 1.1462429626E-01, 4.8641753372E-01],
	[8.6450000000E+03, 3.5191629964E+00, 6.2988449774E+00, 1.2097338645E-01, 1.1482112593E-01, 4.8658024758E-01],
	[8.6500000000E+03, 3.5218062542E+00, 6.2976959498E+00, 1.2118942247E-01, 1.1501816761E-01, 4.8674291998E-01],
	[8.6550000000E+03, 3.5244499683E+00, 6.2965477956E+00, 1.2140571877E-01, 1.1521542136E-01, 4.8690555100E-01],
	[8.6600000000E+03, 3.5270941383E+00, 6.2954005137E+00, 1.2162227551E-01, 1.1541288726E-01, 4.8706814076E-01],
	[8.6650000000E+03, 3.5297387642E+00, 6.2942541028E+00, 1.2183909284E-01, 1.1561056537E-01, 4.8723068937E-01],
	[8.6700000000E+03, 3.5323838457E+00, 6.2931085619E+00, 1.2205617093E-01, 1.1580845576E-01, 4.8739319691E-01],
	[8.6750000000E+03, 3.5350293827E+00, 6.2919638897E+00, 1.2227350995E-01, 1.1600655849E-01, 4.8755566351E-01],
	[8.6800000000E+03, 3.5376753749E+00, 6.2908200851E+00, 1.2249111006E-01, 1.1620487363E-01, 4.8771808925E-01],
	[8.6850000000E+03, 3.5403218222E+00, 6.2896771469E+00, 1.2270897141E-01, 1.1640340124E-01, 4.8788047425E-01],
	[8.6900000000E+03, 3.5429687244E+00, 6.2885350741E+00, 1.2292709417E-01, 1.1660214140E-01, 4.8804281861E-01],
	[8.6950000000E+03, 3.5456160814E+00, 6.2873938653E+00, 1.2314547851E-01, 1.1680109416E-01, 4.8820512243E-01],
	[8.7000000000E+03, 3.5482638928E+00, 6.2862535195E+00, 1.2336412458E-01, 1.1700025960E-01, 4.8836738582E-01],
	[8.7050000000E+03, 3.5509121586E+00, 6.2851140356E+00, 1.2358303254E-01, 1.1719963778E-01, 4.8852960887E-01],
	[8.7100000000E+03, 3.5535608786E+00, 6.2839754123E+00, 1.2380220257E-01, 1.1739922876E-01, 4.8869179170E-01],
	[8.7150000000E+03, 3.5562100525E+00, 6.2828376486E+00, 1.2402163482E-01, 1.1759903261E-01, 4.8885393440E-01],
	[8.7200000000E+03, 3.5588596802E+00, 6.2817007432E+00, 1.2424132945E-01, 1.1779904940E-01, 4.8901603708E-01],
	[8.7250000000E+03, 3.5615097616E+00, 6.2805646952E+00, 1.2446128663E-01, 1.1799927918E-01, 4.8917809983E-01],
	[8.7300000000E+03, 3.5641602964E+00, 6.2794295032E+00, 1.2468150652E-01, 1.1819972204E-01, 4.8934012277E-01],
	[8.7350000000E+03, 3.5668112844E+00, 6.2782951663E+00, 1.2490198928E-01, 1.1840037802E-01, 4.8950210600E-01],
	[8.7400000000E+03, 3.5694627255E+00, 6.2771616832E+00, 1.2512273507E-01, 1.1860124720E-01, 4.8966404962E-01],
	[8.7450000000E+03, 3.5721152494E+00, 6.2760322260E+00, 1.2534374406E-01, 1.1880233147E-01, 4.8982595372E-01],
	[8.7500000000E+03, 3.5747716377E+00, 6.2749207867E+00, 1.2556501641E-01, 1.1900363903E-01, 4.8998781842E-01],
	[8.7550000000E+03, 3.5774284823E+00, 6.2738101789E+00, 1.2578655228E-01, 1.1920516005E-01, 4.9014964381E-01],
	[8.7600000000E+03, 3.5800857828E+00, 6.2727004016E+00, 1.2600835184E-01, 1.1940689459E-01, 4.9031143001E-01],
	[8.7650000000E+03, 3.5827435393E+00, 6.2715914537E+00, 1.2623041523E-01, 1.1960884271E-01, 4.9047317710E-01],
	[8.7700000000E+03, 3.5854017513E+00, 6.2704833341E+00, 1.2645274264E-01, 1.1981100449E-01, 4.9063488520E-01],
	[8.7750000000E+03, 3.5880604189E+00, 6.2693760418E+00, 1.2667533422E-01, 1.2001337998E-01, 4.9079655440E-01],
	[8.7800000000E+03, 3.5907195418E+00, 6.2682695755E+00, 1.2689819013E-01, 1.2021596925E-01, 4.9095818480E-01],
	[8.7850000000E+03, 3.5933791198E+00, 6.2671639343E+00, 1.2712131053E-01, 1.2041877237E-01, 4.9111977652E-01],
	[8.7900000000E+03, 3.5960391528E+00, 6.2660591170E+00, 1.2734469560E-01, 1.2062178939E-01, 4.9128132965E-01],
	[8.7950000000E+03, 3.5986996405E+00, 6.2649551226E+00, 1.2756834548E-01, 1.2082502037E-01, 4.9144284428E-01],
	[8.8000000000E+03, 3.6013605828E+00, 6.2638519500E+00, 1.2779226035E-01, 1.2102846540E-01, 4.9160432054E-01],
	[8.8050000000E+03, 3.6040219795E+00, 6.2627495982E+00, 1.2801644036E-01, 1.2123212451E-01, 4.9176575851E-01],
	[8.8100000000E+03, 3.6066838304E+00, 6.2616480659E+00, 1.2824088568E-01, 1.2143599779E-01, 4.9192715829E-01],
	[8.8150000000E+03, 3.6093461354E+00, 6.2605473522E+00, 1.2846559647E-01, 1.2164008529E-01, 4.9208852000E-01],
	[8.8200000000E+03, 3.6120088942E+00, 6.2594474560E+00, 1.2869057289E-01, 1.2184438708E-01, 4.9224984372E-01],
	[8.8250000000E+03, 3.6146721067E+00, 6.2583483762E+00, 1.2891581510E-01, 1.2204890321E-01, 4.9241112957E-01],
	[8.8300000000E+03, 3.6173357727E+00, 6.2572501118E+00, 1.2914132328E-01, 1.2225363375E-01, 4.9257237763E-01],
	[8.8350000000E+03, 3.6199998921E+00, 6.2561526617E+00, 1.2936709757E-01, 1.2245857877E-01, 4.9273358796E-01],
	[8.8400000000E+03, 3.6226644645E+00, 6.2550560248E+00, 1.2959313815E-01, 1.2266373833E-01, 4.9289476066E-01],
	[8.8450000000E+03, 3.6253294900E+00, 6.2539602000E+00, 1.2981944517E-01, 1.2286911248E-01, 4.9305589580E-01],
	[8.8500000000E+03, 3.6279949682E+00, 6.2528651864E+00, 1.3004601880E-01, 1.2307470129E-01, 4.9321699347E-01],
	[8.8550000000E+03, 3.6306608990E+00, 6.2517709827E+00, 1.3027285920E-01, 1.2328050483E-01, 4.9337805373E-01],
	[8.8600000000E+03, 3.6333272823E+00, 6.2506775881E+00, 1.3049996653E-01, 1.2348652315E-01, 4.9353907667E-01],
	[8.8650000000E+03, 3.6359941178E+00, 6.2495850014E+00, 1.3072734096E-01, 1.2369275631E-01, 4.9370006237E-01],
	[8.8700000000E+03, 3.6386614053E+00, 6.2484932216E+00, 1.3095498265E-01, 1.2389920439E-01, 4.9386101090E-01],
	[8.8750000000E+03, 3.6413291448E+00, 6.2474022476E+00, 1.3118289175E-01, 1.2410586743E-01, 4.9402192235E-01],
	[8.8800000000E+03, 3.6439973359E+00, 6.2463120784E+00, 1.3141106844E-01, 1.2431274550E-01, 4.9418279680E-01],
	[8.8850000000E+03, 3.6466659861E+00, 6.2452227503E+00, 1.3163951287E-01, 1.2451983869E-01, 4.9434363432E-01],
	[8.8900000000E+03, 3.6493389675E+00, 6.2441535884E+00, 1.3186822521E-01, 1.2472715929E-01, 4.9450443500E-01],
	[8.8950000000E+03, 3.6520124036E+00, 6.2430852106E+00, 1.3209720562E-01, 1.2493469517E-01, 4.9466519891E-01],
	[8.9000000000E+03, 3.6546862942E+00, 6.2420176158E+00, 1.3232645427E-01, 1.2514244641E-01, 4.9482592613E-01],
	[8.9050000000E+03, 3.6573606391E+00, 6.2409508030E+00, 1.3255597131E-01, 1.2535041304E-01, 4.9498661674E-01],
	[8.9100000000E+03, 3.6600354381E+00, 6.2398847712E+00, 1.3278575691E-01, 1.2555859515E-01, 4.9514727082E-01],
	[8.9150000000E+03, 3.6627106912E+00, 6.2388195195E+00, 1.3301581123E-01, 1.2576699278E-01, 4.9530788845E-01],
	[8.9200000000E+03, 3.6653863980E+00, 6.2377550467E+00, 1.3324613443E-01, 1.2597560600E-01, 4.9546846971E-01],
	[8.9250000000E+03, 3.6680625584E+00, 6.2366913518E+00, 1.3347672668E-01, 1.2618443487E-01, 4.9562901467E-01],
	[8.9300000000E+03, 3.6707391723E+00, 6.2356284340E+00, 1.3370758813E-01, 1.2639347945E-01, 4.9578952341E-01],
	[8.9350000000E+03, 3.6734162395E+00, 6.2345662921E+00, 1.3393871896E-01, 1.2660273981E-01, 4.9594999602E-01],
	[8.9400000000E+03, 3.6760937597E+00, 6.2335049252E+00, 1.3417011932E-01, 1.2681221599E-01, 4.9611043257E-01],
	[8.9450000000E+03, 3.6787717328E+00, 6.2324443323E+00, 1.3440178938E-01, 1.2702190806E-01, 4.9627083314E-01],
	[8.9500000000E+03, 3.6814501587E+00, 6.2313845123E+00, 1.3463372930E-01, 1.2723181608E-01, 4.9643119781E-01],
	[8.9550000000E+03, 3.6841290371E+00, 6.2303254644E+00, 1.3486593924E-01, 1.2744194011E-01, 4.9659152665E-01],
	[8.9600000000E+03, 3.6868083679E+00, 6.2292671874E+00, 1.3509841936E-01, 1.2765228021E-01, 4.9675181975E-01],
	[8.9650000000E+03, 3.6894881509E+00, 6.2282096804E+00, 1.3533116983E-01, 1.2786283643E-01, 4.9691207718E-01],
	[8.9700000000E+03, 3.6921683859E+00, 6.2271529425E+00, 1.3556419081E-01, 1.2807360885E-01, 4.9707229903E-01],
	[8.9750000000E+03, 3.6948490728E+00, 6.2260969725E+00, 1.3579748247E-01, 1.2828459751E-01, 4.9723248537E-01],
	[8.9800000000E+03, 3.6975302114E+00, 6.2250417696E+00, 1.3603104496E-01, 1.2849580248E-01, 4.9739263627E-01],
	[8.9850000000E+03, 3.7002118014E+00, 6.2239873328E+00, 1.3626487844E-01, 1.2870722381E-01, 4.9755275182E-01],
	[8.9900000000E+03, 3.7028938428E+00, 6.2229336610E+00, 1.3649898309E-01, 1.2891886156E-01, 4.9771283209E-01],
	[8.9950000000E+03, 3.7055763353E+00, 6.2218807533E+00, 1.3673335906E-01, 1.2913071580E-01, 4.9787287717E-01],
	[9.0000000000E+03, 3.7082592788E+00, 6.2208286087E+00, 1.3696800651E-01, 1.2934278657E-01, 4.9803288713E-01],
	[9.0050000000E+03, 3.7109426731E+00, 6.2197772263E+00, 1.3720432934E-01, 1.2955632554E-01, 4.9819286205E-01],
	[9.0100000000E+03, 3.7136265180E+00, 6.2187266050E+00, 1.3744092801E-01, 1.2977008440E-01, 4.9835280200E-01],
	[9.0150000000E+03, 3.7163108134E+00, 6.2176767439E+00, 1.3767780270E-01, 1.2998406319E-01, 4.9851270707E-01],
	[9.0200000000E+03, 3.7189955590E+00, 6.2166276420E+00, 1.3791495357E-01, 1.3019826199E-01, 4.9867257734E-01],
	[9.0250000000E+03, 3.7216807548E+00, 6.2155792984E+00, 1.3815238079E-01, 1.3041268086E-01, 4.9883241287E-01],
	[9.0300000000E+03, 3.7243678831E+00, 6.2145390170E+00, 1.3839008453E-01, 1.3062732490E-01, 4.9899221375E-01],
	[9.0350000000E+03, 3.7270577373E+00, 6.2135106844E+00, 1.3862806495E-01, 1.3084219693E-01, 4.9915198006E-01],
	[9.0400000000E+03, 3.7297480444E+00, 6.2124830907E+00, 1.3886632223E-01, 1.3105728928E-01, 4.9931171187E-01],
	[9.0450000000E+03, 3.7324388043E+00, 6.2114562351E+00, 1.3910485653E-01, 1.3127260200E-01, 4.9947140927E-01],
	[9.0500000000E+03, 3.7351300168E+00, 6.2104301165E+00, 1.3934366802E-01, 1.3148813517E-01, 4.9963107232E-01],
	[9.0550000000E+03, 3.7378216817E+00, 6.2094047340E+00, 1.3958275687E-01, 1.3170388883E-01, 4.9979070111E-01],
	[9.0600000000E+03, 3.7405137988E+00, 6.2083800867E+00, 1.3982212324E-01, 1.3191986306E-01, 4.9995029572E-01],
	[9.0650000000E+03, 3.7432063679E+00, 6.2073561738E+00, 1.4006176731E-01, 1.3213605790E-01, 5.0010985622E-01],
	[9.0700000000E+03, 3.7458993889E+00, 6.2063329941E+00, 1.4030168924E-01, 1.3235247342E-01, 5.0026938268E-01],
	[9.0750000000E+03, 3.7485928617E+00, 6.2053105468E+00, 1.4054188920E-01, 1.3256910968E-01, 5.0042887520E-01],
	[9.0800000000E+03, 3.7512867859E+00, 6.2042888311E+00, 1.4078236736E-01, 1.3278596673E-01, 5.0058833384E-01],
	[9.0850000000E+03, 3.7539811616E+00, 6.2032678458E+00, 1.4102312388E-01, 1.3300304465E-01, 5.0074775868E-01],
	[9.0900000000E+03, 3.7566759884E+00, 6.2022475902E+00, 1.4126415894E-01, 1.3322034347E-01, 5.0090714980E-01],
	[9.0950000000E+03, 3.7593712662E+00, 6.2012280633E+00, 1.4150547270E-01, 1.3343786327E-01, 5.0106650728E-01],
	[9.1000000000E+03, 3.7620669948E+00, 6.2002092642E+00, 1.4174706533E-01, 1.3365560410E-01, 5.0122583120E-01],
	[9.1050000000E+03, 3.7647631742E+00, 6.1991911920E+00, 1.4198893700E-01, 1.3387356603E-01, 5.0138512162E-01],
	[9.1100000000E+03, 3.7674598040E+00, 6.1981738457E+00, 1.4223108787E-01, 1.3409174910E-01, 5.0154437863E-01],
	[9.1150000000E+03, 3.7701568841E+00, 6.1971572244E+00, 1.4247351812E-01, 1.3431015338E-01, 5.0170360231E-01],
	[9.1200000000E+03, 3.7728544144E+00, 6.1961413273E+00, 1.4271622791E-01, 1.3452877892E-01, 5.0186279274E-01],
	[9.1250000000E+03, 3.7755523947E+00, 6.1951261534E+00, 1.4295921741E-01, 1.3474762579E-01, 5.0202194998E-01],
	[9.1300000000E+03, 3.7782508248E+00, 6.1941117017E+00, 1.4320248680E-01, 1.3496669405E-01, 5.0218107412E-01],
	[9.1350000000E+03, 3.7809497045E+00, 6.1930979715E+00, 1.4344603622E-01, 1.3518598374E-01, 5.0234016523E-01],
	[9.1400000000E+03, 3.7836490337E+00, 6.1920849617E+00, 1.4368986587E-01, 1.3540549492E-01, 5.0249922340E-01],
	[9.1450000000E+03, 3.7863488122E+00, 6.1910726715E+00, 1.4393397589E-01, 1.3562522767E-01, 5.0265824870E-01],
	[9.1500000000E+03, 3.7890490398E+00, 6.1900611000E+00, 1.4417836647E-01, 1.3584518202E-01, 5.0281724120E-01],
	[9.1550000000E+03, 3.7917497164E+00, 6.1890502462E+00, 1.4442303777E-01, 1.3606535805E-01, 5.0297620098E-01],
	[9.1600000000E+03, 3.7944508417E+00, 6.1880401094E+00, 1.4466798995E-01, 1.3628575580E-01, 5.0313512812E-01],
	[9.1650000000E+03, 3.7971524157E+00, 6.1870306884E+00, 1.4491322319E-01, 1.3650637533E-01, 5.0329402270E-01],
	[9.1700000000E+03, 3.7998544381E+00, 6.1860219826E+00, 1.4515873766E-01, 1.3672721670E-01, 5.0345288480E-01],
	[9.1750000000E+03, 3.8025581126E+00, 6.1850197670E+00, 1.4540453351E-01, 1.3694828436E-01, 5.0361171448E-01],
	[9.1800000000E+03, 3.8052647164E+00, 6.1840301484E+00, 1.4565061093E-01, 1.3716958307E-01, 5.0377051183E-01],
	[9.1850000000E+03, 3.8079717714E+00, 6.1830412269E+00, 1.4589697008E-01, 1.3739110387E-01, 5.0392927692E-01],
	[9.1900000000E+03, 3.8106792774E+00, 6.1820530016E+00, 1.4614361112E-01, 1.3761284681E-01, 5.0408800983E-01],
	[9.1950000000E+03, 3.8133872342E+00, 6.1810654716E+00, 1.4639053423E-01, 1.3783481195E-01, 5.0424671064E-01],
	[9.2000000000E+03, 3.8160956416E+00, 6.1800786361E+00, 1.4663773957E-01, 1.3805699934E-01, 5.0440537942E-01],
	[9.2050000000E+03, 3.8188044996E+00, 6.1790924942E+00, 1.4688522731E-01, 1.3827940904E-01, 5.0456401626E-01],
	[9.2100000000E+03, 3.8215138078E+00, 6.1781070450E+00, 1.4713299762E-01, 1.3850204111E-01, 5.0472262122E-01],
	[9.2150000000E+03, 3.8242235662E+00, 6.1771222877E+00, 1.4738105067E-01, 1.3872489560E-01, 5.0488119438E-01],
	[9.2200000000E+03, 3.8269337745E+00, 6.1761382214E+00, 1.4762938662E-01, 1.3894797256E-01, 5.0503973582E-01],
	[9.2250000000E+03, 3.8296444327E+00, 6.1751548453E+00, 1.4787800565E-01, 1.3917127206E-01, 5.0519824559E-01],
	[9.2300000000E+03, 3.8323555405E+00, 6.1741721585E+00, 1.4812690793E-01, 1.3939479415E-01, 5.0535672374E-01],
	[9.2350000000E+03, 3.8350670978E+00, 6.1731901601E+00, 1.4837609361E-01, 1.3961853888E-01, 5.0551517033E-01],
	[9.2400000000E+03, 3.8377791043E+00, 6.1722088493E+00, 1.4862556287E-01, 1.3984250631E-01, 5.0567358543E-01],
	[9.2450000000E+03, 3.8404915600E+00, 6.1712282252E+00, 1.4887531588E-01, 1.4006669650E-01, 5.0583196908E-01],
	[9.2500000000E+03, 3.8432044646E+00, 6.1702482871E+00, 1.4912535281E-01, 1.4029110949E-01, 5.0599032135E-01],
	[9.2550000000E+03, 3.8459178181E+00, 6.1692690339E+00, 1.4937567382E-01, 1.4051574535E-01, 5.0614864228E-01],
	[9.2600000000E+03, 3.8486316201E+00, 6.1682904650E+00, 1.4962627908E-01, 1.4074060413E-01, 5.0630693195E-01],
	[9.2650000000E+03, 3.8513458706E+00, 6.1673125794E+00, 1.4987716877E-01, 1.4096568587E-01, 5.0646519041E-01],
	[9.2700000000E+03, 3.8540605694E+00, 6.1663353762E+00, 1.5012834304E-01, 1.4119099065E-01, 5.0662341771E-01],
	[9.2750000000E+03, 3.8567757164E+00, 6.1653588547E+00, 1.5037980207E-01, 1.4141651850E-01, 5.0678161391E-01],
	[9.2800000000E+03, 3.8594913112E+00, 6.1643830141E+00, 1.5063154602E-01, 1.4164226949E-01, 5.0693977907E-01],
	[9.2850000000E+03, 3.8622073539E+00, 6.1634078533E+00, 1.5088357507E-01, 1.4186824367E-01, 5.0709791325E-01],
	[9.2900000000E+03, 3.8649238441E+00, 6.1624333718E+00, 1.5113588939E-01, 1.4209444109E-01, 5.0725601650E-01],
	[9.2950000000E+03, 3.8676407818E+00, 6.1614595685E+00, 1.5138848913E-01, 1.4232086181E-01, 5.0741408888E-01],
	[9.3000000000E+03, 3.8703581668E+00, 6.1604864426E+00, 1.5164137447E-01, 1.4254750587E-01, 5.0757213045E-01],
	[9.3050000000E+03, 3.8730759989E+00, 6.1595139934E+00, 1.5189454558E-01, 1.4277437334E-01, 5.0773014127E-01],
	[9.3100000000E+03, 3.8757942780E+00, 6.1585422199E+00, 1.5214800263E-01, 1.4300146427E-01, 5.0788812139E-01],
	[9.3150000000E+03, 3.8785130038E+00, 6.1575711214E+00, 1.5240174578E-01, 1.4322877870E-01, 5.0804607087E-01],
	[9.3200000000E+03, 3.8812321763E+00, 6.1566006970E+00, 1.5265577521E-01, 1.4345631669E-01, 5.0820398977E-01],
	[9.3250000000E+03, 3.8839546571E+00, 6.1556442839E+00, 1.5291009107E-01, 1.4368408949E-01, 5.0836187814E-01],
	[9.3300000000E+03, 3.8866783426E+00, 6.1546920514E+00, 1.5316469355E-01, 1.4391208897E-01, 5.0851973605E-01],
	[9.3350000000E+03, 3.8894024772E+00, 6.1537404764E+00, 1.5341958280E-01, 1.4414031225E-01, 5.0867756354E-01],
	[9.3400000000E+03, 3.8921270610E+00, 6.1527895578E+00, 1.5367475900E-01, 1.4436875938E-01, 5.0883536069E-01],
	[9.3450000000E+03, 3.8948520937E+00, 6.1518392951E+00, 1.5393022232E-01, 1.4459743042E-01, 5.0899312754E-01],
	[9.3500000000E+03, 3.8975775751E+00, 6.1508896872E+00, 1.5418597291E-01, 1.4482632541E-01, 5.0915086415E-01],
	[9.3550000000E+03, 3.9003035051E+00, 6.1499407335E+00, 1.5444201097E-01, 1.4505544441E-01, 5.0930857057E-01],
	[9.3600000000E+03, 3.9030298835E+00, 6.1489924332E+00, 1.5469833664E-01, 1.4528478746E-01, 5.0946624688E-01],
	[9.3650000000E+03, 3.9057567101E+00, 6.1480447854E+00, 1.5495495010E-01, 1.4551435463E-01, 5.0962389312E-01],
	[9.3700000000E+03, 3.9084839849E+00, 6.1470977893E+00, 1.5521185151E-01, 1.4574414596E-01, 5.0978150934E-01],
	[9.3750000000E+03, 3.9112117075E+00, 6.1461514442E+00, 1.5546904106E-01, 1.4597416151E-01, 5.0993909562E-01],
	[9.3800000000E+03, 3.9139398779E+00, 6.1452057492E+00, 1.5572651889E-01, 1.4620440132E-01, 5.1009665200E-01],
	[9.3850000000E+03, 3.9166684959E+00, 6.1442607036E+00, 1.5598428520E-01, 1.4643486546E-01, 5.1025417854E-01],
	[9.3900000000E+03, 3.9193975614E+00, 6.1433163066E+00, 1.5624234013E-01, 1.4666555395E-01, 5.1041167530E-01],
	[9.3950000000E+03, 3.9221270740E+00, 6.1423725574E+00, 1.5650068386E-01, 1.4689646687E-01, 5.1056914234E-01],
	[9.4000000000E+03, 3.9248570338E+00, 6.1414294551E+00, 1.5675931656E-01, 1.4712760426E-01, 5.1072657971E-01],
	[9.4050000000E+03, 3.9275874405E+00, 6.1404869991E+00, 1.5701823840E-01, 1.4735896618E-01, 5.1088398747E-01],
	[9.4100000000E+03, 3.9303182939E+00, 6.1395451885E+00, 1.5727744954E-01, 1.4759055266E-01, 5.1104136568E-01],
	[9.4150000000E+03, 3.9330495940E+00, 6.1386040225E+00, 1.5753695016E-01, 1.4782236377E-01, 5.1119871439E-01],
	[9.4200000000E+03, 3.9357813405E+00, 6.1376635003E+00, 1.5779674042E-01, 1.4805439955E-01, 5.1135603366E-01],
	[9.4250000000E+03, 3.9385135332E+00, 6.1367236213E+00, 1.5805682049E-01, 1.4828666005E-01, 5.1151332356E-01],
	[9.4300000000E+03, 3.9412461721E+00, 6.1357843845E+00, 1.5831719054E-01, 1.4851914533E-01, 5.1167058412E-01],
	[9.4350000000E+03, 3.9439792569E+00, 6.1348457892E+00, 1.5857785074E-01, 1.4875185542E-01, 5.1182781543E-01],
	[9.4400000000E+03, 3.9467127875E+00, 6.1339078347E+00, 1.5883880126E-01, 1.4898479040E-01, 5.1198501752E-01],
	[9.4450000000E+03, 3.9494467637E+00, 6.1329705201E+00, 1.5910004226E-01, 1.4921795029E-01, 5.1214219046E-01],
	[9.4500000000E+03, 3.9521811853E+00, 6.1320338447E+00, 1.5936157392E-01, 1.4945133516E-01, 5.1229933430E-01],
	[9.4550000000E+03, 3.9549160523E+00, 6.1310978077E+00, 1.5962339640E-01, 1.4968494505E-01, 5.1245644910E-01],
	[9.4600000000E+03, 3.9576513643E+00, 6.1301624084E+00, 1.5988550987E-01, 1.4991878001E-01, 5.1261353492E-01],
	[9.4650000000E+03, 3.9603871214E+00, 6.1292276459E+00, 1.6014791451E-01, 1.5015284009E-01, 5.1277059182E-01],
	[9.4700000000E+03, 3.9631233232E+00, 6.1282935195E+00, 1.6041061047E-01, 1.5038712534E-01, 5.1292761985E-01],
	[9.4750000000E+03, 3.9658627388E+00, 6.1273725685E+00, 1.6067359793E-01, 1.5062164738E-01, 5.1308461907E-01],
	[9.4800000000E+03, 3.9686033830E+00, 6.1264557787E+00, 1.6093687705E-01, 1.5085639802E-01, 5.1324158953E-01],
	[9.4850000000E+03, 3.9713444746E+00, 6.1255396094E+00, 1.6120044801E-01, 1.5109137405E-01, 5.1339853130E-01],
	[9.4900000000E+03, 3.9740860133E+00, 6.1246240599E+00, 1.6146441644E-01, 1.5132666817E-01, 5.1355544442E-01],
	[9.4950000000E+03, 3.9768279991E+00, 6.1237091293E+00, 1.6172873834E-01, 1.5156224159E-01, 5.1371232896E-01],
	[9.5000000000E+03, 3.9795704317E+00, 6.1227948170E+00, 1.6199335309E-01, 1.5179804095E-01, 5.1386918498E-01],
	[9.5050000000E+03, 3.9823133110E+00, 6.1218811221E+00, 1.6225826086E-01, 1.5203406630E-01, 5.1402601253E-01],
	[9.5100000000E+03, 3.9850566368E+00, 6.1209680441E+00, 1.6252346182E-01, 1.5227031768E-01, 5.1418281166E-01],
	[9.5150000000E+03, 3.9878004090E+00, 6.1200555820E+00, 1.6278895613E-01, 1.5250679515E-01, 5.1433958244E-01],
	[9.5200000000E+03, 3.9905446274E+00, 6.1191437352E+00, 1.6305474397E-01, 1.5274349876E-01, 5.1449632492E-01],
	[9.5250000000E+03, 3.9932892919E+00, 6.1182325029E+00, 1.6332082551E-01, 1.5298042855E-01, 5.1465303916E-01],
	[9.5300000000E+03, 3.9960344022E+00, 6.1173218845E+00, 1.6358720092E-01, 1.5321758457E-01, 5.1480972522E-01],
	[9.5350000000E+03, 3.9987799582E+00, 6.1164118791E+00, 1.6385387036E-01, 1.5345496687E-01, 5.1496638314E-01],
	[9.5400000000E+03, 4.0015259598E+00, 6.1155024860E+00, 1.6412083401E-01, 1.5369257549E-01, 5.1512301300E-01],
	[9.5450000000E+03, 4.0042724068E+00, 6.1145937046E+00, 1.6438809203E-01, 1.5393041048E-01, 5.1527961484E-01],
	[9.5500000000E+03, 4.0070192991E+00, 6.1136855340E+00, 1.6465564459E-01, 1.5416847190E-01, 5.1543618872E-01],
	[9.5550000000E+03, 4.0097666364E+00, 6.1127779735E+00, 1.6492349187E-01, 1.5440675979E-01, 5.1559273471E-01],
	[9.5600000000E+03, 4.0125144186E+00, 6.1118710225E+00, 1.6519163404E-01, 1.5464527418E-01, 5.1574925285E-01],
	[9.5650000000E+03, 4.0152626456E+00, 6.1109646801E+00, 1.6546007125E-01, 1.5488401515E-01, 5.1590574320E-01],
	[9.5700000000E+03, 4.0180113171E+00, 6.1100589457E+00, 1.6572880369E-01, 1.5512298272E-01, 5.1606220582E-01],
	[9.5750000000E+03, 4.0207604331E+00, 6.1091538185E+00, 1.6599783152E-01, 1.5536217694E-01, 5.1621864077E-01],
	[9.5800000000E+03, 4.0235099934E+00, 6.1082492979E+00, 1.6626715492E-01, 1.5560159787E-01, 5.1637504811E-01],
	[9.5850000000E+03, 4.0262599978E+00, 6.1073453830E+00, 1.6653677404E-01, 1.5584124554E-01, 5.1653142788E-01],
	[9.5900000000E+03, 4.0290104461E+00, 6.1064420732E+00, 1.6680668906E-01, 1.5608112001E-01, 5.1668778015E-01],
	[9.5950000000E+03, 4.0317613383E+00, 6.1055393677E+00, 1.6707690016E-01, 1.5632122132E-01, 5.1684410498E-01],
	[9.6000000000E+03, 4.0345126740E+00, 6.1046372658E+00, 1.6734740749E-01, 1.5656154951E-01, 5.1700040240E-01],
	[9.6050000000E+03, 4.0372644533E+00, 6.1037357669E+00, 1.6761821124E-01, 1.5680210464E-01, 5.1715667245E-01],
	[9.6100000000E+03, 4.0400166758E+00, 6.1028348701E+00, 1.6788931156E-01, 1.5704288674E-01, 5.1731291517E-01],
	[9.6150000000E+03, 4.0427693415E+00, 6.1019345748E+00, 1.6816070863E-01, 1.5728389587E-01, 5.1746913060E-01],
	[9.6200000000E+03, 4.0455224502E+00, 6.1010348803E+00, 1.6843240262E-01, 1.5752513206E-01, 5.1762531878E-01],
	[9.6250000000E+03, 4.0482769962E+00, 6.1001401626E+00, 1.6870439370E-01, 1.5776659981E-01, 5.1778147976E-01],
	[9.6300000000E+03, 4.0510344746E+00, 6.0992569867E+00, 1.6897668204E-01, 1.5800830587E-01, 5.1793761357E-01],
	[9.6350000000E+03, 4.0537923985E+00, 6.0983743969E+00, 1.6924926780E-01, 1.5825023922E-01, 5.1809372026E-01],
	[9.6400000000E+03, 4.0565507677E+00, 6.0974923927E+00, 1.6952215117E-01, 1.5849239990E-01, 5.1824979986E-01],
	[9.6450000000E+03, 4.0593095821E+00, 6.0966109734E+00, 1.6979533229E-01, 1.5873478796E-01, 5.1840585242E-01],
	[9.6500000000E+03, 4.0620688413E+00, 6.0957301381E+00, 1.7006881136E-01, 1.5897740343E-01, 5.1856187797E-01],
	[9.6550000000E+03, 4.0648285455E+00, 6.0948498863E+00, 1.7034258853E-01, 1.5922024638E-01, 5.1871787656E-01],
	[9.6600000000E+03, 4.0675886942E+00, 6.0939702172E+00, 1.7061666397E-01, 1.5946331683E-01, 5.1887384823E-01],
	[9.6650000000E+03, 4.0703492875E+00, 6.0930911302E+00, 1.7089103786E-01, 1.5970661484E-01, 5.1902979301E-01],
	[9.6700000000E+03, 4.0731103251E+00, 6.0922126245E+00, 1.7116571037E-01, 1.5995014045E-01, 5.1918571096E-01],
	[9.6750000000E+03, 4.0758718068E+00, 6.0913346996E+00, 1.7144068166E-01, 1.6019389370E-01, 5.1934160210E-01],
	[9.6800000000E+03, 4.0786337326E+00, 6.0904573546E+00, 1.7171595191E-01, 1.6043787463E-01, 5.1949746648E-01],
	[9.6850000000E+03, 4.0813961023E+00, 6.0895805890E+00, 1.7199152128E-01, 1.6068208330E-01, 5.1965330415E-01],
	[9.6900000000E+03, 4.0841589157E+00, 6.0887044020E+00, 1.7226738994E-01, 1.6092651974E-01, 5.1980911514E-01],
	[9.6950000000E+03, 4.0869221726E+00, 6.0878287930E+00, 1.7254355807E-01, 1.6117118400E-01, 5.1996489948E-01],
	[9.7000000000E+03, 4.0896858729E+00, 6.0869537613E+00, 1.7282002583E-01, 1.6141607612E-01, 5.2012065724E-01],
	[9.7050000000E+03, 4.0924500164E+00, 6.0860793062E+00, 1.7309679340E-01, 1.6166119615E-01, 5.2027638843E-01],
	[9.7100000000E+03, 4.0952146030E+00, 6.0852054270E+00, 1.7337386094E-01, 1.6190654412E-01, 5.2043209311E-01],
	[9.7150000000E+03, 4.0979796325E+00, 6.0843321230E+00, 1.7365122862E-01, 1.6215212008E-01, 5.2058777132E-01],
	[9.7200000000E+03, 4.1007451048E+00, 6.0834593937E+00, 1.7392889661E-01, 1.6239792407E-01, 5.2074342309E-01],
	[9.7250000000E+03, 4.1035110197E+00, 6.0825872382E+00, 1.7420686509E-01, 1.6264395614E-01, 5.2089904847E-01],
	[9.7300000000E+03, 4.1062773771E+00, 6.0817156560E+00, 1.7448513421E-01, 1.6289021632E-01, 5.2105464749E-01],
	[9.7350000000E+03, 4.1090441767E+00, 6.0808446464E+00, 1.7476370416E-01, 1.6313670467E-01, 5.2121022021E-01],
	[9.7400000000E+03, 4.1118114185E+00, 6.0799742086E+00, 1.7504257511E-01, 1.6338342122E-01, 5.2136576665E-01],
	[9.7450000000E+03, 4.1145791022E+00, 6.0791043421E+00, 1.7532174721E-01, 1.6363036601E-01, 5.2152128686E-01],
	[9.7500000000E+03, 4.1173472278E+00, 6.0782350461E+00, 1.7560122065E-01, 1.6387753909E-01, 5.2167678088E-01],
	[9.7550000000E+03, 4.1201157950E+00, 6.0773663200E+00, 1.7588099558E-01, 1.6412494049E-01, 5.2183224876E-01],
	[9.7600000000E+03, 4.1228848037E+00, 6.0764981631E+00, 1.7616107219E-01, 1.6437257027E-01, 5.2198769052E-01],
	[9.7650000000E+03, 4.1256542538E+00, 6.0756305748E+00, 1.7644145064E-01, 1.6462042845E-01, 5.2214310622E-01],
	[9.7700000000E+03, 4.1284241451E+00, 6.0747635544E+00, 1.7672213110E-01, 1.6486851509E-01, 5.2229849589E-01],
	[9.7750000000E+03, 4.1311944774E+00, 6.0738971012E+00, 1.7700311374E-01, 1.6511683022E-01, 5.2245385958E-01],
	[9.7800000000E+03, 4.1339662758E+00, 6.0730355979E+00, 1.7728439874E-01, 1.6536537878E-01, 5.2260919732E-01],
	[9.7850000000E+03, 4.1367409059E+00, 6.0721848673E+00, 1.7756598625E-01, 1.6561416736E-01, 5.2276450916E-01],
	[9.7900000000E+03, 4.1395159793E+00, 6.0713346903E+00, 1.7784787645E-01, 1.6586318464E-01, 5.2291979513E-01],
	[9.7950000000E+03, 4.1422914960E+00, 6.0704850664E+00, 1.7813006951E-01, 1.6611243066E-01, 5.2307505528E-01],
	[9.8000000000E+03, 4.1450674558E+00, 6.0696359949E+00, 1.7841256561E-01, 1.6636190547E-01, 5.2323028966E-01],
	[9.8050000000E+03, 4.1478438585E+00, 6.0687874752E+00, 1.7869536490E-01, 1.6661160910E-01, 5.2338549829E-01],
	[9.8100000000E+03, 4.1506207040E+00, 6.0679395065E+00, 1.7897846757E-01, 1.6686154160E-01, 5.2354068122E-01],
	[9.8150000000E+03, 4.1533979922E+00, 6.0670920883E+00, 1.7926187377E-01, 1.6711170299E-01, 5.2369583849E-01],
	[9.8200000000E+03, 4.1561757228E+00, 6.0662452200E+00, 1.7954558369E-01, 1.6736209334E-01, 5.2385097014E-01],
	[9.8250000000E+03, 4.1589538958E+00, 6.0653989009E+00, 1.7982959748E-01, 1.6761271266E-01, 5.2400607622E-01],
	[9.8300000000E+03, 4.1617325109E+00, 6.0645531304E+00, 1.8011391533E-01, 1.6786356101E-01, 5.2416115676E-01],
	[9.8350000000E+03, 4.1645115680E+00, 6.0637079078E+00, 1.8039853739E-01, 1.6811463842E-01, 5.2431621180E-01],
	[9.8400000000E+03, 4.1672910670E+00, 6.0628632324E+00, 1.8068346384E-01, 1.6836594494E-01, 5.2447124139E-01],
	[9.8450000000E+03, 4.1700710077E+00, 6.0620191038E+00, 1.8096869486E-01, 1.6861748060E-01, 5.2462624557E-01],
	[9.8500000000E+03, 4.1728513900E+00, 6.0611755212E+00, 1.8125423060E-01, 1.6886924544E-01, 5.2478122438E-01],
	[9.8550000000E+03, 4.1756322136E+00, 6.0603324840E+00, 1.8154007125E-01, 1.6912123950E-01, 5.2493617785E-01],
	[9.8600000000E+03, 4.1784134785E+00, 6.0594899916E+00, 1.8182621696E-01, 1.6937346282E-01, 5.2509110603E-01],
	[9.8650000000E+03, 4.1811951845E+00, 6.0586480433E+00, 1.8211266791E-01, 1.6962591543E-01, 5.2524600896E-01],
	[9.8700000000E+03, 4.1839773314E+00, 6.0578066386E+00, 1.8239942428E-01, 1.6987859739E-01, 5.2540088669E-01],
	[9.8750000000E+03, 4.1867599191E+00, 6.0569657768E+00, 1.8268648622E-01, 1.7013150872E-01, 5.2555573924E-01],
	[9.8800000000E+03, 4.1895429475E+00, 6.0561254572E+00, 1.8297385391E-01, 1.7038464946E-01, 5.2571056667E-01],
	[9.8850000000E+03, 4.1923264163E+00, 6.0552856793E+00, 1.8326152753E-01, 1.7063801966E-01, 5.2586536901E-01],
	[9.8900000000E+03, 4.1951103254E+00, 6.0544464424E+00, 1.8354950723E-01, 1.7089161934E-01, 5.2602014631E-01],
	[9.8950000000E+03, 4.1978946747E+00, 6.0536077459E+00, 1.8383779320E-01, 1.7114544856E-01, 5.2617489860E-01],
	[9.9000000000E+03, 4.2006794640E+00, 6.0527695892E+00, 1.8412638559E-01, 1.7139950734E-01, 5.2632962593E-01],
	[9.9050000000E+03, 4.2034646932E+00, 6.0519319717E+00, 1.8441528458E-01, 1.7165379572E-01, 5.2648432834E-01],
	[9.9100000000E+03, 4.2062503621E+00, 6.0510948927E+00, 1.8470449035E-01, 1.7190831374E-01, 5.2663900586E-01],
	[9.9150000000E+03, 4.2090364705E+00, 6.0502583516E+00, 1.8499400305E-01, 1.7216306145E-01, 5.2679365855E-01],
	[9.9200000000E+03, 4.2118230184E+00, 6.0494223479E+00, 1.8528382287E-01, 1.7241803886E-01, 5.2694828644E-01],
	[9.9250000000E+03, 4.2146100055E+00, 6.0485868808E+00, 1.8557394997E-01, 1.7267324603E-01, 5.2710288957E-01],
	[9.9300000000E+03, 4.2173974317E+00, 6.0477519498E+00, 1.8586438451E-01, 1.7292868299E-01, 5.2725746798E-01],
	[9.9350000000E+03, 4.2201852968E+00, 6.0469175543E+00, 1.8615512668E-01, 1.7318434977E-01, 5.2741202172E-01],
	[9.9400000000E+03, 4.2229763375E+00, 6.0460950360E+00, 1.8644617664E-01, 1.7344026037E-01, 5.2756655082E-01],
	[9.9450000000E+03, 4.2257684358E+00, 6.0452755969E+00, 1.8673753456E-01, 1.7369640409E-01, 5.2772105532E-01],
	[9.9500000000E+03, 4.2285609753E+00, 6.0444566805E+00, 1.8702920061E-01, 1.7395277783E-01, 5.2787553528E-01],
	[9.9550000000E+03, 4.2313539559E+00, 6.0436382865E+00, 1.8732117497E-01, 1.7420938163E-01, 5.2802999072E-01],
	[9.9600000000E+03, 4.2341473774E+00, 6.0428204141E+00, 1.8761345779E-01, 1.7446621553E-01, 5.2818442176E-01],
	[9.9650000000E+03, 4.2369412398E+00, 6.0420030627E+00, 1.8790604926E-01, 1.7472327956E-01, 5.2833882853E-01],
	[9.9700000000E+03, 4.2397355427E+00, 6.0411862319E+00, 1.8819894953E-01, 1.7498057376E-01, 5.2849321107E-01],
	[9.9750000000E+03, 4.2425302861E+00, 6.0403699209E+00, 1.8849215880E-01, 1.7523809816E-01, 5.2864756939E-01],
	[9.9800000000E+03, 4.2453254699E+00, 6.0395541293E+00, 1.8878567721E-01, 1.7549585280E-01, 5.2880190352E-01],
	[9.9850000000E+03, 4.2481210938E+00, 6.0387388563E+00, 1.8907950494E-01, 1.7575383772E-01, 5.2895621348E-01],
	[9.9900000000E+03, 4.2509171577E+00, 6.0379241015E+00, 1.8937364217E-01, 1.7601205295E-01, 5.2911049929E-01],
	[9.9950000000E+03, 4.2537136616E+00, 6.0371098642E+00, 1.8966808906E-01, 1.7627049852E-01, 5.2926476097E-01],
	[1.0000000000E+04, 4.2565106051E+00, 6.0362961438E+00, 1.8996284579E-01, 1.7652917448E-01, 5.2941899854E-01],
	[1.0005000000E+04, 4.2593079882E+00, 6.0354829398E+00, 1.9025916370E-01, 1.7678916114E-01, 5.2957321202E-01],
	[1.0010000000E+04, 4.2621058108E+00, 6.0346702516E+00, 1.9055579507E-01, 1.7704938071E-01, 5.2972740144E-01],
	[1.0015000000E+04, 4.2649040726E+00, 6.0338580785E+00, 1.9085274007E-01, 1.7730983324E-01, 5.2988156681E-01],
	[1.0020000000E+04, 4.2677027735E+00, 6.0330464200E+00, 1.9114999888E-01, 1.7757051874E-01, 5.3003570817E-01],
	[1.0025000000E+04, 4.2705019134E+00, 6.0322352756E+00, 1.9144757167E-01, 1.7783143727E-01, 5.3018982552E-01],
	[1.0030000000E+04, 4.2733014921E+00, 6.0314246446E+00, 1.9174545861E-01, 1.7809258885E-01, 5.3034391890E-01],
	[1.0035000000E+04, 4.2761015095E+00, 6.0306145265E+00, 1.9204365989E-01, 1.7835397353E-01, 5.3049798832E-01],
	[1.0040000000E+04, 4.2789019655E+00, 6.0298049206E+00, 1.9234217567E-01, 1.7861559133E-01, 5.3065203381E-01],
	[1.0045000000E+04, 4.2817028597E+00, 6.0289958264E+00, 1.9264100613E-01, 1.7887744229E-01, 5.3080605538E-01],
	[1.0050000000E+04, 4.2845041922E+00, 6.0281872434E+00, 1.9294015144E-01, 1.7913952645E-01, 5.3096005306E-01],
	[1.0055000000E+04, 4.2873059628E+00, 6.0273791709E+00, 1.9323961178E-01, 1.7940184384E-01, 5.3111402687E-01],
	[1.0060000000E+04, 4.2901081713E+00, 6.0265716083E+00, 1.9353938731E-01, 1.7966439450E-01, 5.3126797684E-01],
	[1.0065000000E+04, 4.2929108176E+00, 6.0257645552E+00, 1.9383947823E-01, 1.7992717847E-01, 5.3142190298E-01],
	[1.0070000000E+04, 4.2957139015E+00, 6.0249580108E+00, 1.9413988469E-01, 1.8019019577E-01, 5.3157580531E-01],
	[1.0075000000E+04, 4.2985174229E+00, 6.0241519747E+00, 1.9444060687E-01, 1.8045344644E-01, 5.3172968386E-01],
	[1.0080000000E+04, 4.3013213816E+00, 6.0233464463E+00, 1.9474164496E-01, 1.8071693051E-01, 5.3188353866E-01],
	[1.0085000000E+04, 4.3041257775E+00, 6.0225414250E+00, 1.9504299911E-01, 1.8098064802E-01, 5.3203736971E-01],
	[1.0090000000E+04, 4.3069306104E+00, 6.0217369102E+00, 1.9534466952E-01, 1.8124459901E-01, 5.3219117705E-01],
	[1.0095000000E+04, 4.3097358802E+00, 6.0209329014E+00, 1.9564665634E-01, 1.8150878351E-01, 5.3234496069E-01],
	[1.0100000000E+04, 4.3125443907E+00, 6.0201404011E+00, 1.9594895976E-01, 1.8177321656E-01, 5.3249872067E-01],
	[1.0105000000E+04, 4.3153539342E+00, 6.0193507269E+00, 1.9625157994E-01, 1.8203788644E-01, 5.3265245699E-01],
	[1.0110000000E+04, 4.3181639170E+00, 6.0185615468E+00, 1.9655451708E-01, 1.8230279003E-01, 5.3280616968E-01],
	[1.0115000000E+04, 4.3209743387E+00, 6.0177728603E+00, 1.9685777133E-01, 1.8256792735E-01, 5.3295985877E-01],
	[1.0120000000E+04, 4.3237851993E+00, 6.0169846669E+00, 1.9716134287E-01, 1.8283329844E-01, 5.3311352427E-01],
	[1.0125000000E+04, 4.3265964987E+00, 6.0161969659E+00, 1.9746523188E-01, 1.8309890333E-01, 5.3326716621E-01],
	[1.0130000000E+04, 4.3294082366E+00, 6.0154097569E+00, 1.9776943853E-01, 1.8336474205E-01, 5.3342078461E-01],
	[1.0135000000E+04, 4.3322204130E+00, 6.0146230393E+00, 1.9807396299E-01, 1.8363081464E-01, 5.3357437949E-01],
	[1.0140000000E+04, 4.3350330276E+00, 6.0138368125E+00, 1.9837880545E-01, 1.8389712113E-01, 5.3372795088E-01],
	[1.0145000000E+04, 4.3378460804E+00, 6.0130510759E+00, 1.9868396607E-01, 1.8416366155E-01, 5.3388149879E-01],
	[1.0150000000E+04, 4.3406595712E+00, 6.0122658292E+00, 1.9898944503E-01, 1.8443043593E-01, 5.3403502326E-01],
	[1.0155000000E+04, 4.3434734998E+00, 6.0114810716E+00, 1.9929524250E-01, 1.8469744431E-01, 5.3418852429E-01],
	[1.0160000000E+04, 4.3462878662E+00, 6.0106968027E+00, 1.9960135866E-01, 1.8496468672E-01, 5.3434200192E-01],
	[1.0165000000E+04, 4.3491026700E+00, 6.0099130218E+00, 1.9990779368E-01, 1.8523216319E-01, 5.3449545616E-01],
	[1.0170000000E+04, 4.3519179113E+00, 6.0091297286E+00, 2.0021454774E-01, 1.8549987375E-01, 5.3464888704E-01],
	[1.0175000000E+04, 4.3547335898E+00, 6.0083469223E+00, 2.0052162101E-01, 1.8576781843E-01, 5.3480229458E-01],
	[1.0180000000E+04, 4.3575497055E+00, 6.0075646026E+00, 2.0082901367E-01, 1.8603599727E-01, 5.3495567880E-01],
	[1.0185000000E+04, 4.3603662581E+00, 6.0067827688E+00, 2.0113672588E-01, 1.8630441030E-01, 5.3510903973E-01],
	[1.0190000000E+04, 4.3631832475E+00, 6.0060014203E+00, 2.0144475783E-01, 1.8657305754E-01, 5.3526237738E-01],
	[1.0195000000E+04, 4.3660006736E+00, 6.0052205568E+00, 2.0175310969E-01, 1.8684193904E-01, 5.3541569178E-01],
	[1.0200000000E+04, 4.3688185362E+00, 6.0044401775E+00, 2.0206178163E-01, 1.8711105481E-01, 5.3556898296E-01],
	[1.0205000000E+04, 4.3716368352E+00, 6.0036602820E+00, 2.0237077383E-01, 1.8738040490E-01, 5.3572225093E-01],
	[1.0210000000E+04, 4.3744555704E+00, 6.0028808698E+00, 2.0268008646E-01, 1.8764998932E-01, 5.3587549572E-01],
	[1.0215000000E+04, 4.3772747416E+00, 6.0021019403E+00, 2.0298971970E-01, 1.8791980812E-01, 5.3602871734E-01],
	[1.0220000000E+04, 4.3800943489E+00, 6.0013234929E+00, 2.0329967372E-01, 1.8818986132E-01, 5.3618191583E-01],
	[1.0225000000E+04, 4.3829143919E+00, 6.0005455272E+00, 2.0360994870E-01, 1.8846014895E-01, 5.3633509121E-01],
	[1.0230000000E+04, 4.3857348705E+00, 5.9997680426E+00, 2.0392054480E-01, 1.8873067105E-01, 5.3648824349E-01],
	[1.0235000000E+04, 4.3885557847E+00, 5.9989910386E+00, 2.0423146221E-01, 1.8900142763E-01, 5.3664137269E-01],
	[1.0240000000E+04, 4.3913771342E+00, 5.9982145146E+00, 2.0454270111E-01, 1.8927241874E-01, 5.3679447886E-01],
	[1.0245000000E+04, 4.3941989189E+00, 5.9974384701E+00, 2.0485426165E-01, 1.8954364440E-01, 5.3694756199E-01],
	[1.0250000000E+04, 4.3970211387E+00, 5.9966629046E+00, 2.0516614403E-01, 1.8981510464E-01, 5.3710062213E-01],
	[1.0255000000E+04, 4.3998437934E+00, 5.9958878176E+00, 2.0547834840E-01, 1.9008679949E-01, 5.3725365928E-01],
	[1.0260000000E+04, 4.4026680085E+00, 5.9951173189E+00, 2.0579087496E-01, 1.9035873523E-01, 5.3740667348E-01],
	[1.0265000000E+04, 4.4054950603E+00, 5.9943560558E+00, 2.0610372387E-01, 1.9063091903E-01, 5.3755966474E-01],
	[1.0270000000E+04, 4.4083225494E+00, 5.9935952601E+00, 2.0641689530E-01, 1.9090333762E-01, 5.3771263309E-01],
	[1.0275000000E+04, 4.4111504756E+00, 5.9928349311E+00, 2.0673038944E-01, 1.9117599103E-01, 5.3786557855E-01],
	[1.0280000000E+04, 4.4139788389E+00, 5.9920750685E+00, 2.0704420646E-01, 1.9144887929E-01, 5.3801850115E-01],
	[1.0285000000E+04, 4.4168076390E+00, 5.9913156716E+00, 2.0735834652E-01, 1.9172200244E-01, 5.3817140090E-01],
	[1.0290000000E+04, 4.4196368758E+00, 5.9905567400E+00, 2.0767280981E-01, 1.9199536049E-01, 5.3832427783E-01],
	[1.0295000000E+04, 4.4224665491E+00, 5.9897982731E+00, 2.0798759650E-01, 1.9226895348E-01, 5.3847713196E-01],
	[1.0300000000E+04, 4.4252966589E+00, 5.9890402704E+00, 2.0830270677E-01, 1.9254278144E-01, 5.3862996332E-01],
	[1.0305000000E+04, 4.4281272050E+00, 5.9882827315E+00, 2.0861814079E-01, 1.9281684439E-01, 5.3878277192E-01],
	[1.0310000000E+04, 4.4309581872E+00, 5.9875256558E+00, 2.0893389873E-01, 1.9309114236E-01, 5.3893555780E-01],
	[1.0315000000E+04, 4.4337896053E+00, 5.9867690428E+00, 2.0924998077E-01, 1.9336567538E-01, 5.3908832097E-01],
	[1.0320000000E+04, 4.4366214593E+00, 5.9860128920E+00, 2.0956638708E-01, 1.9364044348E-01, 5.3924106145E-01],
	[1.0325000000E+04, 4.4394537490E+00, 5.9852572029E+00, 2.0988311784E-01, 1.9391544668E-01, 5.3939377928E-01],
	[1.0330000000E+04, 4.4422864743E+00, 5.9845019750E+00, 2.1020017323E-01, 1.9419068501E-01, 5.3954647447E-01],
	[1.0335000000E+04, 4.4451196350E+00, 5.9837472078E+00, 2.1051755341E-01, 1.9446615850E-01, 5.3969914704E-01],
	[1.0340000000E+04, 4.4479532309E+00, 5.9829929008E+00, 2.1083525857E-01, 1.9474186718E-01, 5.3985179702E-01],
	[1.0345000000E+04, 4.4507872619E+00, 5.9822390535E+00, 2.1115328888E-01, 1.9501781107E-01, 5.4000442443E-01],
	[1.0350000000E+04, 4.4536217280E+00, 5.9814856653E+00, 2.1147164450E-01, 1.9529399019E-01, 5.4015702930E-01],
	[1.0355000000E+04, 4.4564566288E+00, 5.9807327358E+00, 2.1179032563E-01, 1.9557040458E-01, 5.4030961164E-01],
	[1.0360000000E+04, 4.4592919644E+00, 5.9799802645E+00, 2.1210933242E-01, 1.9584705427E-01, 5.4046217149E-01],
	[1.0365000000E+04, 4.4621277345E+00, 5.9792282509E+00, 2.1242866507E-01, 1.9612393927E-01, 5.4061470886E-01],
	[1.0370000000E+04, 4.4649639390E+00, 5.9784766945E+00, 2.1274832373E-01, 1.9640105961E-01, 5.4076722377E-01],
	[1.0375000000E+04, 4.4678005777E+00, 5.9777255947E+00, 2.1306830859E-01, 1.9667841533E-01, 5.4091971626E-01],
	[1.0380000000E+04, 4.4706376506E+00, 5.9769749511E+00, 2.1338861982E-01, 1.9695600643E-01, 5.4107218634E-01],
	[1.0385000000E+04, 4.4734751575E+00, 5.9762247633E+00, 2.1370925760E-01, 1.9723383296E-01, 5.4122463403E-01],
	[1.0390000000E+04, 4.4763130982E+00, 5.9754750306E+00, 2.1403022210E-01, 1.9751189494E-01, 5.4137705937E-01],
	[1.0395000000E+04, 4.4791514726E+00, 5.9747257526E+00, 2.1435151349E-01, 1.9779019239E-01, 5.4152946237E-01],
	[1.0400000000E+04, 4.4819902805E+00, 5.9739769288E+00, 2.1467313196E-01, 1.9806872533E-01, 5.4168184305E-01],
	[1.0405000000E+04, 4.4848295218E+00, 5.9732285587E+00, 2.1499507767E-01, 1.9834749380E-01, 5.4183420144E-01],
	[1.0410000000E+04, 4.4876691964E+00, 5.9724806418E+00, 2.1531735080E-01, 1.9862649781E-01, 5.4198653757E-01],
	[1.0415000000E+04, 4.4905093042E+00, 5.9717331776E+00, 2.1563995152E-01, 1.9890573739E-01, 5.4213885145E-01],
	[1.0420000000E+04, 4.4933498449E+00, 5.9709861657E+00, 2.1596288001E-01, 1.9918521257E-01, 5.4229114311E-01],
	[1.0425000000E+04, 4.4961918792E+00, 5.9702432101E+00, 2.1628613645E-01, 1.9946492947E-01, 5.4244341257E-01],
	[1.0430000000E+04, 4.4990369452E+00, 5.9695095254E+00, 2.1660972101E-01, 1.9974489705E-01, 5.4259565986E-01],
	[1.0435000000E+04, 4.5018824467E+00, 5.9687762825E+00, 2.1693363387E-01, 2.0002510040E-01, 5.4274788500E-01],
	[1.0440000000E+04, 4.5047283834E+00, 5.9680434808E+00, 2.1725787519E-01, 2.0030553955E-01, 5.4290008801E-01],
	[1.0445000000E+04, 4.5075747553E+00, 5.9673111198E+00, 2.1758244516E-01, 2.0058621451E-01, 5.4305226892E-01],
	[1.0450000000E+04, 4.5104215622E+00, 5.9665791992E+00, 2.1790734394E-01, 2.0086712532E-01, 5.4320442775E-01],
	[1.0455000000E+04, 4.5132688040E+00, 5.9658477184E+00, 2.1823257173E-01, 2.0114827199E-01, 5.4335656452E-01],
	[1.0460000000E+04, 4.5161164805E+00, 5.9651166770E+00, 2.1855812868E-01, 2.0142965455E-01, 5.4350867925E-01],
	[1.0465000000E+04, 4.5189645915E+00, 5.9643860744E+00, 2.1888401497E-01, 2.0171127303E-01, 5.4366077198E-01],
	[1.0470000000E+04, 4.5218131370E+00, 5.9636559102E+00, 2.1921023079E-01, 2.0199312744E-01, 5.4381284272E-01],
	[1.0475000000E+04, 4.5246621168E+00, 5.9629261840E+00, 2.1953677629E-01, 2.0227521781E-01, 5.4396489150E-01],
	[1.0480000000E+04, 4.5275115307E+00, 5.9621968952E+00, 2.1986365167E-01, 2.0255754416E-01, 5.4411691833E-01],
	[1.0485000000E+04, 4.5303613786E+00, 5.9614680435E+00, 2.2019085709E-01, 2.0284010652E-01, 5.4426892326E-01],
	[1.0490000000E+04, 4.5332116604E+00, 5.9607396282E+00, 2.2051839273E-01, 2.0312290491E-01, 5.4442090628E-01],
	[1.0495000000E+04, 4.5360623760E+00, 5.9600116490E+00, 2.2084625877E-01, 2.0340593934E-01, 5.4457286745E-01],
	[1.0500000000E+04, 4.5389135251E+00, 5.9592841054E+00, 2.2117445537E-01, 2.0368920985E-01, 5.4472480676E-01],
	[1.0505000000E+04, 4.5417651076E+00, 5.9585569969E+00, 2.2150298272E-01, 2.0397271646E-01, 5.4487672426E-01],
	[1.0510000000E+04, 4.5446171235E+00, 5.9578303230E+00, 2.2183184099E-01, 2.0425645918E-01, 5.4502861995E-01],
	[1.0515000000E+04, 4.5474695726E+00, 5.9571040834E+00, 2.2216103035E-01, 2.0454043803E-01, 5.4518049388E-01],
	[1.0520000000E+04, 4.5503224546E+00, 5.9563782774E+00, 2.2249055098E-01, 2.0482465305E-01, 5.4533234605E-01],
	[1.0525000000E+04, 4.5531757696E+00, 5.9556529047E+00, 2.2282040306E-01, 2.0510910425E-01, 5.4548417650E-01],
	[1.0530000000E+04, 4.5560295173E+00, 5.9549279648E+00, 2.2315058675E-01, 2.0539379165E-01, 5.4563598524E-01],
	[1.0535000000E+04, 4.5588836976E+00, 5.9542034572E+00, 2.2348110224E-01, 2.0567871528E-01, 5.4578777230E-01],
	[1.0540000000E+04, 4.5617383104E+00, 5.9534793814E+00, 2.2381194970E-01, 2.0596387515E-01, 5.4593953771E-01],
	[1.0545000000E+04, 4.5645933555E+00, 5.9527557371E+00, 2.2414312931E-01, 2.0624927129E-01, 5.4609128149E-01],
	[1.0550000000E+04, 4.5674488328E+00, 5.9520325237E+00, 2.2447464123E-01, 2.0653490371E-01, 5.4624300366E-01],
	[1.0555000000E+04, 4.5703047421E+00, 5.9513097408E+00, 2.2480648565E-01, 2.0682077245E-01, 5.4639470425E-01],
	[1.0560000000E+04, 4.5731610834E+00, 5.9505873879E+00, 2.2513866274E-01, 2.0710687751E-01, 5.4654638328E-01],
	[1.0565000000E+04, 4.5760178564E+00, 5.9498654645E+00, 2.2547117267E-01, 2.0739321891E-01, 5.4669804077E-01],
	[1.0570000000E+04, 4.5788750610E+00, 5.9491439703E+00, 2.2580401563E-01, 2.0767979669E-01, 5.4684967675E-01],
	[1.0575000000E+04, 4.5817326972E+00, 5.9484229047E+00, 2.2613719178E-01, 2.0796661086E-01, 5.4700129124E-01],
	[1.0580000000E+04, 4.5845907647E+00, 5.9477022672E+00, 2.2647070130E-01, 2.0825366143E-01, 5.4715288427E-01],
	[1.0585000000E+04, 4.5874492634E+00, 5.9469820575E+00, 2.2680454437E-01, 2.0854094843E-01, 5.4730445585E-01],
	[1.0590000000E+04, 4.5903081931E+00, 5.9462622751E+00, 2.2713872115E-01, 2.0882847188E-01, 5.4745600602E-01],
	[1.0595000000E+04, 4.5931703183E+00, 5.9455516649E+00, 2.2747323184E-01, 2.0911624834E-01, 5.4760753480E-01],
	[1.0600000000E+04, 4.5960339044E+00, 5.9448447249E+00, 2.2780807659E-01, 2.0940426754E-01, 5.4775904221E-01],
	[1.0605000000E+04, 4.5988979241E+00, 5.9441382022E+00, 2.2814325559E-01, 2.0969252334E-01, 5.4791052828E-01],
	[1.0610000000E+04, 4.6017623773E+00, 5.9434320965E+00, 2.2847876902E-01, 2.0998101578E-01, 5.4806199302E-01],
	[1.0615000000E+04, 4.6046272638E+00, 5.9427264072E+00, 2.2881461704E-01, 2.1026974488E-01, 5.4821343647E-01],
	[1.0620000000E+04, 4.6074925835E+00, 5.9420211341E+00, 2.2915079983E-01, 2.1055871064E-01, 5.4836485865E-01],
	[1.0625000000E+04, 4.6103583362E+00, 5.9413162765E+00, 2.2948731757E-01, 2.1084791309E-01, 5.4851625958E-01],
	[1.0630000000E+04, 4.6132245218E+00, 5.9406118341E+00, 2.2982417044E-01, 2.1113735225E-01, 5.4866763928E-01],
	[1.0635000000E+04, 4.6160911402E+00, 5.9399078064E+00, 2.3016135860E-01, 2.1142702813E-01, 5.4881899779E-01],
	[1.0640000000E+04, 4.6189581912E+00, 5.9392041931E+00, 2.3049888223E-01, 2.1171694076E-01, 5.4897033512E-01],
	[1.0645000000E+04, 4.6218256747E+00, 5.9385009935E+00, 2.3083674152E-01, 2.1200709016E-01, 5.4912165129E-01],
	[1.0650000000E+04, 4.6246935905E+00, 5.9377982074E+00, 2.3117493662E-01, 2.1229747633E-01, 5.4927294628E-01],
	[1.0655000000E+04, 4.6275619386E+00, 5.9370958343E+00, 2.3151346773E-01, 2.1258809930E-01, 5.4942422005E-01],
	[1.0660000000E+04, 4.6304307187E+00, 5.9363938738E+00, 2.3185233501E-01, 2.1287895909E-01, 5.4957547263E-01],
	[1.0665000000E+04, 4.6332999308E+00, 5.9356923253E+00, 2.3219153864E-01, 2.1317005571E-01, 5.4972670402E-01],
	[1.0670000000E+04, 4.6361695746E+00, 5.9349911885E+00, 2.3253107879E-01, 2.1346138918E-01, 5.4987791422E-01],
	[1.0675000000E+04, 4.6390396501E+00, 5.9342904630E+00, 2.3287095565E-01, 2.1375295952E-01, 5.5002910323E-01],
	[1.0680000000E+04, 4.6419101572E+00, 5.9335901482E+00, 2.3321116938E-01, 2.1404476674E-01, 5.5018027107E-01],
	[1.0685000000E+04, 4.6447810956E+00, 5.9328902439E+00, 2.3355172016E-01, 2.1433681087E-01, 5.5033141773E-01],
	[1.0690000000E+04, 4.6476524653E+00, 5.9321907494E+00, 2.3389260817E-01, 2.1462909191E-01, 5.5048254322E-01],
	[1.0695000000E+04, 4.6505242661E+00, 5.9314916645E+00, 2.3423383358E-01, 2.1492160989E-01, 5.5063364755E-01],
	[1.0700000000E+04, 4.6533964978E+00, 5.9307929887E+00, 2.3457539657E-01, 2.1521436482E-01, 5.5078473072E-01],
	[1.0705000000E+04, 4.6562691604E+00, 5.9300947215E+00, 2.3491729731E-01, 2.1550735672E-01, 5.5093579273E-01],
	[1.0710000000E+04, 4.6591422537E+00, 5.9293968625E+00, 2.3525953597E-01, 2.1580058560E-01, 5.5108683359E-01],
	[1.0715000000E+04, 4.6620157776E+00, 5.9286994113E+00, 2.3560211274E-01, 2.1609405148E-01, 5.5123785331E-01],
	[1.0720000000E+04, 4.6648897319E+00, 5.9280023675E+00, 2.3594502779E-01, 2.1638775438E-01, 5.5138885189E-01],
	[1.0725000000E+04, 4.6677641165E+00, 5.9273057306E+00, 2.3628828129E-01, 2.1668169431E-01, 5.5153982933E-01],
	[1.0730000000E+04, 4.6706389312E+00, 5.9266095002E+00, 2.3663187343E-01, 2.1697587128E-01, 5.5169078564E-01],
	[1.0735000000E+04, 4.6735141760E+00, 5.9259136759E+00, 2.3697580436E-01, 2.1727028532E-01, 5.5184172083E-01],
	[1.0740000000E+04, 4.6763898506E+00, 5.9252182573E+00, 2.3732007428E-01, 2.1756493643E-01, 5.5199263490E-01],
	[1.0745000000E+04, 4.6792659550E+00, 5.9245232438E+00, 2.3766468335E-01, 2.1785982464E-01, 5.5214352786E-01],
	[1.0750000000E+04, 4.6821424890E+00, 5.9238286352E+00, 2.3800963176E-01, 2.1815494995E-01, 5.5229439970E-01],
	[1.0755000000E+04, 4.6850194525E+00, 5.9231344310E+00, 2.3835491967E-01, 2.1845031238E-01, 5.5244525045E-01],
	[1.0760000000E+04, 4.6878968453E+00, 5.9224406307E+00, 2.3870054726E-01, 2.1874591195E-01, 5.5259608009E-01],
	[1.0765000000E+04, 4.6907771323E+00, 5.9217545020E+00, 2.3904651471E-01, 2.1904176399E-01, 5.5274688864E-01],
	[1.0770000000E+04, 4.6936593126E+00, 5.9210730803E+00, 2.3939282219E-01, 2.1933786237E-01, 5.5289767610E-01],
	[1.0775000000E+04, 4.6965419249E+00, 5.9203920532E+00, 2.3973946988E-01, 2.1963419804E-01, 5.5304844248E-01],
	[1.0780000000E+04, 4.6994249690E+00, 5.9197114204E+00, 2.4008645796E-01, 2.1993077102E-01, 5.5319918779E-01],
	[1.0785000000E+04, 4.7023084447E+00, 5.9190311814E+00, 2.4043378659E-01, 2.2022758132E-01, 5.5334991202E-01],
	[1.0790000000E+04, 4.7051923520E+00, 5.9183513358E+00, 2.4078145596E-01, 2.2052462896E-01, 5.5350061518E-01],
	[1.0795000000E+04, 4.7080766906E+00, 5.9176718832E+00, 2.4112946624E-01, 2.2082191395E-01, 5.5365129729E-01],
	[1.0800000000E+04, 4.7109614605E+00, 5.9169928231E+00, 2.4147781761E-01, 2.2111943629E-01, 5.5380195833E-01],
	[1.0805000000E+04, 4.7138466616E+00, 5.9163141553E+00, 2.4182651023E-01, 2.2141719602E-01, 5.5395259833E-01],
	[1.0810000000E+04, 4.7167322936E+00, 5.9156358792E+00, 2.4217554430E-01, 2.2171519313E-01, 5.5410321729E-01],
	[1.0815000000E+04, 4.7196183564E+00, 5.9149579945E+00, 2.4252491998E-01, 2.2201342764E-01, 5.5425381520E-01],
	[1.0820000000E+04, 4.7225048500E+00, 5.9142805007E+00, 2.4287463744E-01, 2.2231189957E-01, 5.5440439208E-01],
	[1.0825000000E+04, 4.7253917742E+00, 5.9136033975E+00, 2.4322469687E-01, 2.2261060893E-01, 5.5455494794E-01],
	[1.0830000000E+04, 4.7282791288E+00, 5.9129266844E+00, 2.4357509844E-01, 2.2290955572E-01, 5.5470548277E-01],
	[1.0835000000E+04, 4.7311669137E+00, 5.9122503610E+00, 2.4392584232E-01, 2.2320873997E-01, 5.5485599659E-01],
	[1.0840000000E+04, 4.7340551287E+00, 5.9115744270E+00, 2.4427692870E-01, 2.2350816169E-01, 5.5500648940E-01],
	[1.0845000000E+04, 4.7369437739E+00, 5.9108988820E+00, 2.4462835774E-01, 2.2380782088E-01, 5.5515696120E-01],
	[1.0850000000E+04, 4.7398328489E+00, 5.9102237254E+00, 2.4498012962E-01, 2.2410771756E-01, 5.5530741200E-01],
	[1.0855000000E+04, 4.7427223537E+00, 5.9095489570E+00, 2.4533224452E-01, 2.2440785174E-01, 5.5545784181E-01],
	[1.0860000000E+04, 4.7456122881E+00, 5.9088745763E+00, 2.4568470261E-01, 2.2470822344E-01, 5.5560825064E-01],
	[1.0865000000E+04, 4.7485026521E+00, 5.9082005829E+00, 2.4603750407E-01, 2.2500883266E-01, 5.5575863848E-01],
	[1.0870000000E+04, 4.7513934454E+00, 5.9075269764E+00, 2.4639064908E-01, 2.2530967941E-01, 5.5590900535E-01],
	[1.0875000000E+04, 4.7542846680E+00, 5.9068537565E+00, 2.4674413781E-01, 2.2561076372E-01, 5.5605935125E-01],
	[1.0880000000E+04, 4.7571763196E+00, 5.9061809227E+00, 2.4709797043E-01, 2.2591208558E-01, 5.5620967618E-01],
	[1.0885000000E+04, 4.7600684002E+00, 5.9055084746E+00, 2.4745214712E-01, 2.2621364501E-01, 5.5635998016E-01],
	[1.0890000000E+04, 4.7629609097E+00, 5.9048364118E+00, 2.4780666806E-01, 2.2651544202E-01, 5.5651026318E-01],
	[1.0895000000E+04, 4.7658538479E+00, 5.9041647340E+00, 2.4816153342E-01, 2.2681747662E-01, 5.5666052526E-01],
	[1.0900000000E+04, 4.7687472146E+00, 5.9034934407E+00, 2.4851674338E-01, 2.2711974882E-01, 5.5681076641E-01],
	[1.0905000000E+04, 4.7716410098E+00, 5.9028225315E+00, 2.4887229812E-01, 2.2742225863E-01, 5.5696098661E-01],
	[1.0910000000E+04, 4.7745352333E+00, 5.9021520061E+00, 2.4922819780E-01, 2.2772500607E-01, 5.5711118590E-01],
	[1.0915000000E+04, 4.7774298849E+00, 5.9014818640E+00, 2.4958444261E-01, 2.2802799113E-01, 5.5726136426E-01],
	[1.0920000000E+04, 4.7803249646E+00, 5.9008121048E+00, 2.4994103272E-01, 2.2833121384E-01, 5.5741152170E-01],
	[1.0925000000E+04, 4.7832204722E+00, 5.9001427282E+00, 2.5029796831E-01, 2.2863467420E-01, 5.5756165824E-01],
	[1.0930000000E+04, 4.7861164075E+00, 5.8994737338E+00, 2.5065524955E-01, 2.2893837221E-01, 5.5771177388E-01],
	[1.0935000000E+04, 4.7890127705E+00, 5.8988051212E+00, 2.5101287662E-01, 2.2924230790E-01, 5.5786186862E-01],
	[1.0940000000E+04, 4.7919135330E+00, 5.8981478093E+00, 2.5137084969E-01, 2.2954650692E-01, 5.5801194247E-01],
	[1.0945000000E+04, 4.7948148176E+00, 5.8974911228E+00, 2.5172916895E-01, 2.2985094434E-01, 5.5816199543E-01],
	[1.0950000000E+04, 4.7977165324E+00, 5.8968348092E+00, 2.5208783455E-01, 2.3015561957E-01, 5.5831202752E-01],
	[1.0955000000E+04, 4.8006186774E+00, 5.8961788683E+00, 2.5244684670E-01, 2.3046053263E-01, 5.5846203874E-01],
	[1.0960000000E+04, 4.8035212524E+00, 5.8955232996E+00, 2.5280620554E-01, 2.3076568353E-01, 5.5861202910E-01],
	[1.0965000000E+04, 4.8064242574E+00, 5.8948681028E+00, 2.5316591128E-01, 2.3107107227E-01, 5.5876199860E-01],
	[1.0970000000E+04, 4.8093276921E+00, 5.8942132774E+00, 2.5352596407E-01, 2.3137669886E-01, 5.5891194724E-01],
	[1.0975000000E+04, 4.8122315564E+00, 5.8935588231E+00, 2.5388636409E-01, 2.3168256331E-01, 5.5906187505E-01],
	[1.0980000000E+04, 4.8151358503E+00, 5.8929047395E+00, 2.5424711153E-01, 2.3198866563E-01, 5.5921178201E-01],
	[1.0985000000E+04, 4.8180405735E+00, 5.8922510262E+00, 2.5460820655E-01, 2.3229500583E-01, 5.5936166814E-01],
	[1.0990000000E+04, 4.8209457260E+00, 5.8915976829E+00, 2.5496964933E-01, 2.3260158391E-01, 5.5951153345E-01],
	[1.0995000000E+04, 4.8238513075E+00, 5.8909447091E+00, 2.5533144006E-01, 2.3290839989E-01, 5.5966137794E-01],
	[1.1000000000E+04, 4.8267573181E+00, 5.8902921046E+00, 2.5569357889E-01, 2.3321545376E-01, 5.5981120162E-01],
	[1.1005000000E+04, 4.8296637575E+00, 5.8896398688E+00, 2.5605606602E-01, 2.3352274555E-01, 5.5996100449E-01],
	[1.1010000000E+04, 4.8325706256E+00, 5.8889880016E+00, 2.5641890161E-01, 2.3383027524E-01, 5.6011078656E-01],
	[1.1015000000E+04, 4.8354779223E+00, 5.8883365023E+00, 2.5678208584E-01, 2.3413804287E-01, 5.6026054785E-01],
	[1.1020000000E+04, 4.8383856475E+00, 5.8876853708E+00, 2.5714561890E-01, 2.3444604841E-01, 5.6041028834E-01],
	[1.1025000000E+04, 4.8412938010E+00, 5.8870346066E+00, 2.5750950094E-01, 2.3475429190E-01, 5.6056000806E-01],
	[1.1030000000E+04, 4.8442023827E+00, 5.8863842093E+00, 2.5787373216E-01, 2.3506277333E-01, 5.6070970701E-01],
	[1.1035000000E+04, 4.8471113924E+00, 5.8857341786E+00, 2.5823831272E-01, 2.3537149271E-01, 5.6085938520E-01],
	[1.1040000000E+04, 4.8500208301E+00, 5.8850845141E+00, 2.5860324280E-01, 2.3568045004E-01, 5.6100904262E-01],
	[1.1045000000E+04, 4.8529306955E+00, 5.8844352154E+00, 2.5896852257E-01, 2.3598964533E-01, 5.6115867930E-01],
	[1.1050000000E+04, 4.8558409887E+00, 5.8837862822E+00, 2.5933415223E-01, 2.3629907860E-01, 5.6130829523E-01],
	[1.1055000000E+04, 4.8587517093E+00, 5.8831377140E+00, 2.5970013193E-01, 2.3660874983E-01, 5.6145789042E-01],
	[1.1060000000E+04, 4.8616628574E+00, 5.8824895106E+00, 2.6006646185E-01, 2.3691865905E-01, 5.6160746489E-01],
	[1.1065000000E+04, 4.8645744327E+00, 5.8818416715E+00, 2.6043314218E-01, 2.3722880625E-01, 5.6175701863E-01],
	[1.1070000000E+04, 4.8674864352E+00, 5.8811941964E+00, 2.6080017308E-01, 2.3753919144E-01, 5.6190655165E-01],
	[1.1075000000E+04, 4.8703988647E+00, 5.8805470849E+00, 2.6116755474E-01, 2.3784981463E-01, 5.6205606397E-01],
	[1.1080000000E+04, 4.8733117211E+00, 5.8799003367E+00, 2.6153528732E-01, 2.3816067582E-01, 5.6220555558E-01],
	[1.1085000000E+04, 4.8762250042E+00, 5.8792539513E+00, 2.6190337101E-01, 2.3847177502E-01, 5.6235502650E-01],
	[1.1090000000E+04, 4.8791387140E+00, 5.8786079284E+00, 2.6227180598E-01, 2.3878311222E-01, 5.6250447673E-01],
	[1.1095000000E+04, 4.8820528502E+00, 5.8779622676E+00, 2.6264059241E-01, 2.3909468744E-01, 5.6265390628E-01],
	[1.1100000000E+04, 4.8849674129E+00, 5.8773169686E+00, 2.6300973047E-01, 2.3940650068E-01, 5.6280331516E-01],
	[1.1105000000E+04, 4.8878824017E+00, 5.8766720311E+00, 2.6337922034E-01, 2.3971855195E-01, 5.6295270337E-01],
	[1.1110000000E+04, 4.8907978167E+00, 5.8760274545E+00, 2.6374906219E-01, 2.4003084124E-01, 5.6310207092E-01],
	[1.1115000000E+04, 4.8937168897E+00, 5.8753915313E+00, 2.6411925621E-01, 2.4034339024E-01, 5.6325141782E-01],
	[1.1120000000E+04, 4.8966373603E+00, 5.8747584478E+00, 2.6448980256E-01, 2.4065618388E-01, 5.6340074408E-01],
	[1.1125000000E+04, 4.8995582597E+00, 5.8741257171E+00, 2.6486070143E-01, 2.4096921569E-01, 5.6355004970E-01],
	[1.1130000000E+04, 4.9024795877E+00, 5.8734933389E+00, 2.6523195298E-01, 2.4128248566E-01, 5.6369933468E-01],
	[1.1135000000E+04, 4.9054013444E+00, 5.8728613126E+00, 2.6560355741E-01, 2.4159599381E-01, 5.6384859905E-01],
	[1.1140000000E+04, 4.9083235295E+00, 5.8722296381E+00, 2.6597551487E-01, 2.4190974014E-01, 5.6399784280E-01],
	[1.1145000000E+04, 4.9112461429E+00, 5.8715983150E+00, 2.6634782555E-01, 2.4222372465E-01, 5.6414706594E-01],
	[1.1150000000E+04, 4.9141691846E+00, 5.8709673428E+00, 2.6672048962E-01, 2.4253794734E-01, 5.6429626848E-01],
	[1.1155000000E+04, 4.9170926542E+00, 5.8703367213E+00, 2.6709350726E-01, 2.4285240822E-01, 5.6444545043E-01],
	[1.1160000000E+04, 4.9200165518E+00, 5.8697064500E+00, 2.6746687865E-01, 2.4316710729E-01, 5.6459461180E-01],
	[1.1165000000E+04, 4.9229408772E+00, 5.8690765288E+00, 2.6784060396E-01, 2.4348204455E-01, 5.6474375258E-01],
	[1.1170000000E+04, 4.9258656303E+00, 5.8684469571E+00, 2.6821468337E-01, 2.4379722001E-01, 5.6489287280E-01],
	[1.1175000000E+04, 4.9287908109E+00, 5.8678177346E+00, 2.6858911706E-01, 2.4411263366E-01, 5.6504197245E-01],
	[1.1180000000E+04, 4.9317164190E+00, 5.8671888610E+00, 2.6896390519E-01, 2.4442828552E-01, 5.6519105155E-01],
	[1.1185000000E+04, 4.9346424543E+00, 5.8665603360E+00, 2.6934146944E-01, 2.4474617501E-01, 5.6534011009E-01],
	[1.1190000000E+04, 4.9375689167E+00, 5.8659321591E+00, 2.6971954893E-01, 2.4506443433E-01, 5.6548914810E-01],
	[1.1195000000E+04, 4.9404958062E+00, 5.8653043301E+00, 2.7009798947E-01, 2.4538293599E-01, 5.6563816558E-01],
	[1.1200000000E+04, 4.9434231226E+00, 5.8646768486E+00, 2.7047679123E-01, 2.4570167999E-01, 5.6578716253E-01],
	[1.1205000000E+04, 4.9463508658E+00, 5.8640497143E+00, 2.7085595440E-01, 2.4602066633E-01, 5.6593613896E-01],
	[1.1210000000E+04, 4.9492790356E+00, 5.8634229267E+00, 2.7123547916E-01, 2.4633989501E-01, 5.6608509489E-01],
	[1.1215000000E+04, 4.9522076319E+00, 5.8627964856E+00, 2.7161536569E-01, 2.4665936603E-01, 5.6623403031E-01],
	[1.1220000000E+04, 4.9551366546E+00, 5.8621703906E+00, 2.7199561419E-01, 2.4697907941E-01, 5.6638294524E-01],
	[1.1225000000E+04, 4.9580661036E+00, 5.8615446414E+00, 2.7237622482E-01, 2.4729903513E-01, 5.6653183968E-01],
	[1.1230000000E+04, 4.9609959787E+00, 5.8609192376E+00, 2.7275719777E-01, 2.4761923321E-01, 5.6668071365E-01],
	[1.1235000000E+04, 4.9639262798E+00, 5.8602941788E+00, 2.7313853323E-01, 2.4793967365E-01, 5.6682956714E-01],
	[1.1240000000E+04, 4.9668570068E+00, 5.8596694648E+00, 2.7352023138E-01, 2.4826035644E-01, 5.6697840017E-01],
	[1.1245000000E+04, 4.9697881595E+00, 5.8590450952E+00, 2.7390229239E-01, 2.4858128159E-01, 5.6712721275E-01],
	[1.1250000000E+04, 4.9727197379E+00, 5.8584210696E+00, 2.7428471646E-01, 2.4890244911E-01, 5.6727600488E-01],
	[1.1255000000E+04, 4.9756517417E+00, 5.8577973877E+00, 2.7466750377E-01, 2.4922385898E-01, 5.6742477657E-01],
	[1.1260000000E+04, 4.9785841709E+00, 5.8571740492E+00, 2.7505065449E-01, 2.4954551122E-01, 5.6757352783E-01],
	[1.1265000000E+04, 4.9815170253E+00, 5.8565510537E+00, 2.7543416882E-01, 2.4986740583E-01, 5.6772225866E-01],
	[1.1270000000E+04, 4.9844503049E+00, 5.8559284009E+00, 2.7581804693E-01, 2.5018954280E-01, 5.6787096908E-01],
	[1.1275000000E+04, 4.9873840094E+00, 5.8553060904E+00, 2.7620228901E-01, 2.5051192214E-01, 5.6801965910E-01],
	[1.1280000000E+04, 4.9903181388E+00, 5.8546841219E+00, 2.7658689524E-01, 2.5083454384E-01, 5.6816832872E-01],
	[1.1285000000E+04, 4.9932526929E+00, 5.8540624951E+00, 2.7697186580E-01, 2.5115740792E-01, 5.6831697794E-01],
	[1.1290000000E+04, 4.9961876717E+00, 5.8534412096E+00, 2.7735720088E-01, 2.5148051436E-01, 5.6846560678E-01],
	[1.1295000000E+04, 4.9991273914E+00, 5.8528306036E+00, 2.7774290065E-01, 2.5180389326E-01, 5.6861421521E-01],
	[1.1300000000E+04, 5.0020675627E+00, 5.8522203888E+00, 2.7812896531E-01, 2.5212751482E-01, 5.6876280321E-01],
	[1.1305000000E+04, 5.0050081613E+00, 5.8516105076E+00, 2.7851539503E-01, 2.5245137889E-01, 5.6891137077E-01],
	[1.1310000000E+04, 5.0079491872E+00, 5.8510009596E+00, 2.7890219000E-01, 2.5277548546E-01, 5.6905991789E-01],
	[1.1315000000E+04, 5.0108906403E+00, 5.8503917444E+00, 2.7928935040E-01, 2.5309983454E-01, 5.6920844457E-01],
	[1.1320000000E+04, 5.0138325204E+00, 5.8497828618E+00, 2.7967687641E-01, 2.5342442611E-01, 5.6935695079E-01],
	[1.1325000000E+04, 5.0167748274E+00, 5.8491743114E+00, 2.8006476822E-01, 2.5374926019E-01, 5.6950543655E-01],
	[1.1330000000E+04, 5.0197175611E+00, 5.8485660928E+00, 2.8045302600E-01, 2.5407433677E-01, 5.6965390185E-01],
	[1.1335000000E+04, 5.0226607215E+00, 5.8479582059E+00, 2.8084164995E-01, 2.5439965584E-01, 5.6980234668E-01],
	[1.1340000000E+04, 5.0256043085E+00, 5.8473506501E+00, 2.8123064024E-01, 2.5472521742E-01, 5.6995077104E-01],
	[1.1345000000E+04, 5.0285483218E+00, 5.8467434253E+00, 2.8161999707E-01, 2.5505102149E-01, 5.7009917491E-01],
	[1.1350000000E+04, 5.0314927613E+00, 5.8461365310E+00, 2.8200972060E-01, 2.5537706806E-01, 5.7024755830E-01],
	[1.1355000000E+04, 5.0344376270E+00, 5.8455299670E+00, 2.8239981102E-01, 2.5570335713E-01, 5.7039592120E-01],
	[1.1360000000E+04, 5.0373829188E+00, 5.8449237329E+00, 2.8279026852E-01, 2.5602988869E-01, 5.7054426361E-01],
	[1.1365000000E+04, 5.0403286364E+00, 5.8443178284E+00, 2.8318109329E-01, 2.5635666274E-01, 5.7069258551E-01],
	[1.1370000000E+04, 5.0432747797E+00, 5.8437122531E+00, 2.8357228549E-01, 2.5668367928E-01, 5.7084088690E-01],
	[1.1375000000E+04, 5.0462213487E+00, 5.8431070069E+00, 2.8396384532E-01, 2.5701093831E-01, 5.7098916779E-01],
	[1.1380000000E+04, 5.0491683432E+00, 5.8425020892E+00, 2.8435577296E-01, 2.5733843982E-01, 5.7113742815E-01],
	[1.1385000000E+04, 5.0521157631E+00, 5.8418974999E+00, 2.8474806859E-01, 2.5766618381E-01, 5.7128566800E-01],
	[1.1390000000E+04, 5.0550636083E+00, 5.8412932385E+00, 2.8514073240E-01, 2.5799417029E-01, 5.7143388731E-01],
	[1.1395000000E+04, 5.0580118785E+00, 5.8406893049E+00, 2.8553376456E-01, 2.5832239925E-01, 5.7158208610E-01],
	[1.1400000000E+04, 5.0609605738E+00, 5.8400856985E+00, 2.8592716526E-01, 2.5865087067E-01, 5.7173026435E-01],
	[1.1405000000E+04, 5.0639096940E+00, 5.8394824192E+00, 2.8632093469E-01, 2.5897958457E-01, 5.7187842205E-01],
	[1.1410000000E+04, 5.0668592389E+00, 5.8388794666E+00, 2.8671507303E-01, 2.5930854094E-01, 5.7202655921E-01],
	[1.1415000000E+04, 5.0698092085E+00, 5.8382768403E+00, 2.8710958045E-01, 2.5963773978E-01, 5.7217467582E-01],
	[1.1420000000E+04, 5.0727596025E+00, 5.8376745401E+00, 2.8750445715E-01, 2.5996718107E-01, 5.7232277186E-01],
	[1.1425000000E+04, 5.0757104210E+00, 5.8370725657E+00, 2.8789970331E-01, 2.6029686483E-01, 5.7247084735E-01],
	[1.1430000000E+04, 5.0786616637E+00, 5.8364709167E+00, 2.8829531910E-01, 2.6062679103E-01, 5.7261890227E-01],
	[1.1435000000E+04, 5.0816133305E+00, 5.8358695927E+00, 2.8869130472E-01, 2.6095695969E-01, 5.7276693662E-01],
	[1.1440000000E+04, 5.0845654213E+00, 5.8352685936E+00, 2.8908766034E-01, 2.6128737079E-01, 5.7291495039E-01],
	[1.1445000000E+04, 5.0875179361E+00, 5.8346679189E+00, 2.8948438616E-01, 2.6161802433E-01, 5.7306294358E-01],
	[1.1450000000E+04, 5.0904708746E+00, 5.8340675684E+00, 2.8988148234E-01, 2.6194892031E-01, 5.7321091618E-01],
	[1.1455000000E+04, 5.0934242367E+00, 5.8334675418E+00, 2.9027894908E-01, 2.6228005873E-01, 5.7335886820E-01],
	[1.1460000000E+04, 5.0963780223E+00, 5.8328678386E+00, 2.9067678656E-01, 2.6261143956E-01, 5.7350679961E-01],
	[1.1465000000E+04, 5.0993322313E+00, 5.8322684587E+00, 2.9107499496E-01, 2.6294306282E-01, 5.7365471043E-01],
	[1.1470000000E+04, 5.1022868636E+00, 5.8316694016E+00, 2.9147357447E-01, 2.6327492850E-01, 5.7380260065E-01],
	[1.1475000000E+04, 5.1052448030E+00, 5.8310771210E+00, 2.9187252526E-01, 2.6360705747E-01, 5.7395047025E-01],
	[1.1480000000E+04, 5.1082047647E+00, 5.8304887302E+00, 2.9227184753E-01, 2.6393944052E-01, 5.7409831924E-01],
	[1.1485000000E+04, 5.1111651525E+00, 5.8299006550E+00, 2.9267154145E-01, 2.6427206610E-01, 5.7424614761E-01],
	[1.1490000000E+04, 5.1141259663E+00, 5.8293128951E+00, 2.9307160720E-01, 2.6460493423E-01, 5.7439395536E-01],
	[1.1495000000E+04, 5.1170872061E+00, 5.8287254501E+00, 2.9347204498E-01, 2.6493804488E-01, 5.7454174248E-01],
	[1.1500000000E+04, 5.1200488715E+00, 5.8281383197E+00, 2.9387285496E-01, 2.6527139805E-01, 5.7468950898E-01],
	[1.1505000000E+04, 5.1230109626E+00, 5.8275515036E+00, 2.9427403733E-01, 2.6560499374E-01, 5.7483725483E-01],
	[1.1510000000E+04, 5.1259734792E+00, 5.8269650015E+00, 2.9467559228E-01, 2.6593883195E-01, 5.7498498005E-01],
	[1.1515000000E+04, 5.1289364212E+00, 5.8263788132E+00, 2.9507751997E-01, 2.6627291265E-01, 5.7513268462E-01],
	[1.1520000000E+04, 5.1318997885E+00, 5.8257929383E+00, 2.9547982061E-01, 2.6660723586E-01, 5.7528036854E-01],
	[1.1525000000E+04, 5.1348635809E+00, 5.8252073764E+00, 2.9588249436E-01, 2.6694180156E-01, 5.7542803181E-01],
	[1.1530000000E+04, 5.1378277983E+00, 5.8246221274E+00, 2.9628554142E-01, 2.6727660974E-01, 5.7557567442E-01],
	[1.1535000000E+04, 5.1407924406E+00, 5.8240371909E+00, 2.9668896197E-01, 2.6761166040E-01, 5.7572329637E-01],
	[1.1540000000E+04, 5.1437575076E+00, 5.8234525666E+00, 2.9709275618E-01, 2.6794695353E-01, 5.7587089765E-01],
	[1.1545000000E+04, 5.1467229993E+00, 5.8228682541E+00, 2.9749692425E-01, 2.6828248912E-01, 5.7601847826E-01],
	[1.1550000000E+04, 5.1496889156E+00, 5.8222842533E+00, 2.9790146636E-01, 2.6861826717E-01, 5.7616603820E-01],
	[1.1555000000E+04, 5.1526552562E+00, 5.8217005637E+00, 2.9830638269E-01, 2.6895428767E-01, 5.7631357747E-01],
	[1.1560000000E+04, 5.1556220211E+00, 5.8211171852E+00, 2.9871167343E-01, 2.6929055061E-01, 5.7646109605E-01],
	[1.1565000000E+04, 5.1585892102E+00, 5.8205341173E+00, 2.9911733875E-01, 2.6962705598E-01, 5.7660859394E-01],
	[1.1570000000E+04, 5.1615568233E+00, 5.8199513599E+00, 2.9952337884E-01, 2.6996380377E-01, 5.7675607114E-01],
	[1.1575000000E+04, 5.1645248602E+00, 5.8193689125E+00, 2.9992979389E-01, 2.7030079399E-01, 5.7690352765E-01],
	[1.1580000000E+04, 5.1674933210E+00, 5.8187867749E+00, 3.0033658408E-01, 2.7063802660E-01, 5.7705096347E-01],
	[1.1585000000E+04, 5.1704622055E+00, 5.8182049468E+00, 3.0074374958E-01, 2.7097550162E-01, 5.7719837858E-01],
	[1.1590000000E+04, 5.1734315135E+00, 5.8176234280E+00, 3.0115129060E-01, 2.7131321903E-01, 5.7734577298E-01],
	[1.1595000000E+04, 5.1764012449E+00, 5.8170422180E+00, 3.0155920730E-01, 2.7165117882E-01, 5.7749314668E-01],
	[1.1600000000E+04, 5.1793713995E+00, 5.8164613166E+00, 3.0196749987E-01, 2.7198938098E-01, 5.7764049966E-01],
	[1.1605000000E+04, 5.1823419774E+00, 5.8158807235E+00, 3.0237616850E-01, 2.7232782550E-01, 5.7778783192E-01],
	[1.1610000000E+04, 5.1853129783E+00, 5.8153004385E+00, 3.0278521336E-01, 2.7266651238E-01, 5.7793514347E-01],
	[1.1615000000E+04, 5.1882844022E+00, 5.8147204611E+00, 3.0319463465E-01, 2.7300544160E-01, 5.7808243429E-01],
	[1.1620000000E+04, 5.1912562488E+00, 5.8141407912E+00, 3.0360443255E-01, 2.7334461315E-01, 5.7822970438E-01],
	[1.1625000000E+04, 5.1942285182E+00, 5.8135614284E+00, 3.0401460723E-01, 2.7368402703E-01, 5.7837695374E-01],
	[1.1630000000E+04, 5.1972012101E+00, 5.8129823724E+00, 3.0442515889E-01, 2.7402368322E-01, 5.7852418236E-01],
	[1.1635000000E+04, 5.2001743244E+00, 5.8124036230E+00, 3.0483608770E-01, 2.7436358172E-01, 5.7867139025E-01],
	[1.1640000000E+04, 5.2031478611E+00, 5.8118251798E+00, 3.0524739385E-01, 2.7470372251E-01, 5.7881857739E-01],
	[1.1645000000E+04, 5.2061218200E+00, 5.8112470425E+00, 3.0565907753E-01, 2.7504410558E-01, 5.7896574378E-01],
	[1.1650000000E+04, 5.2090962009E+00, 5.8106692110E+00, 3.0607113891E-01, 2.7538473093E-01, 5.7911288943E-01],
	[1.1655000000E+04, 5.2120710038E+00, 5.8100916847E+00, 3.0648357818E-01, 2.7572559853E-01, 5.7926001433E-01],
	[1.1660000000E+04, 5.2150494999E+00, 5.8095213046E+00, 3.0689639553E-01, 2.7606673300E-01, 5.7940711846E-01],
	[1.1665000000E+04, 5.2180297720E+00, 5.8089540504E+00, 3.0730959114E-01, 2.7640812000E-01, 5.7955420184E-01],
	[1.1670000000E+04, 5.2210104690E+00, 5.8083870946E+00, 3.0772316519E-01, 2.7674974938E-01, 5.7970126445E-01],
	[1.1675000000E+04, 5.2239915908E+00, 5.8078204370E+00, 3.0813711786E-01, 2.7709162112E-01, 5.7984830630E-01],
	[1.1680000000E+04, 5.2269731372E+00, 5.8072540772E+00, 3.0855144934E-01, 2.7743373521E-01, 5.7999532738E-01],
	[1.1685000000E+04, 5.2299551081E+00, 5.8066880150E+00, 3.0896615981E-01, 2.7777609165E-01, 5.8014232768E-01],
	[1.1690000000E+04, 5.2329375035E+00, 5.8061222502E+00, 3.0938124946E-01, 2.7811869041E-01, 5.8028930721E-01],
	[1.1695000000E+04, 5.2359203231E+00, 5.8055567823E+00, 3.0979671847E-01, 2.7846153148E-01, 5.8043626595E-01],
	[1.1700000000E+04, 5.2389035669E+00, 5.8049916113E+00, 3.1021256702E-01, 2.7880461487E-01, 5.8058320392E-01],
	[1.1705000000E+04, 5.2418872347E+00, 5.8044267366E+00, 3.1062879530E-01, 2.7914794054E-01, 5.8073012110E-01],
	[1.1710000000E+04, 5.2448713264E+00, 5.8038621582E+00, 3.1104540348E-01, 2.7949150849E-01, 5.8087701748E-01],
	[1.1715000000E+04, 5.2478558420E+00, 5.8032978756E+00, 3.1146239177E-01, 2.7983531871E-01, 5.8102389308E-01],
	[1.1720000000E+04, 5.2508407812E+00, 5.8027338886E+00, 3.1187976033E-01, 2.8017937119E-01, 5.8117074788E-01],
	[1.1725000000E+04, 5.2538261440E+00, 5.8021701970E+00, 3.1229750935E-01, 2.8052366591E-01, 5.8131758188E-01],
	[1.1730000000E+04, 5.2568119302E+00, 5.8016068004E+00, 3.1271563902E-01, 2.8086820285E-01, 5.8146439508E-01],
	[1.1735000000E+04, 5.2597981397E+00, 5.8010436987E+00, 3.1313414951E-01, 2.8121298202E-01, 5.8161118748E-01],
	[1.1740000000E+04, 5.2627847724E+00, 5.8004808914E+00, 3.1355304102E-01, 2.8155800338E-01, 5.8175795906E-01],
	[1.1745000000E+04, 5.2657718283E+00, 5.7999183783E+00, 3.1397231373E-01, 2.8190326693E-01, 5.8190470984E-01],
	[1.1750000000E+04, 5.2687593070E+00, 5.7993561591E+00, 3.1439196781E-01, 2.8224877266E-01, 5.8205143980E-01],
	[1.1755000000E+04, 5.2717472086E+00, 5.7987942336E+00, 3.1481200346E-01, 2.8259452055E-01, 5.8219814895E-01],
	[1.1760000000E+04, 5.2747355329E+00, 5.7982326015E+00, 3.1523242086E-01, 2.8294051059E-01, 5.8234483727E-01],
	[1.1765000000E+04, 5.2777242798E+00, 5.7976712625E+00, 3.1565322019E-01, 2.8328674276E-01, 5.8249150478E-01],
	[1.1770000000E+04, 5.2807134492E+00, 5.7971102163E+00, 3.1607440164E-01, 2.8363321705E-01, 5.8263815146E-01],
	[1.1775000000E+04, 5.2837030409E+00, 5.7965494626E+00, 3.1649596538E-01, 2.8397993344E-01, 5.8278477731E-01],
	[1.1780000000E+04, 5.2866930549E+00, 5.7959890012E+00, 3.1691791161E-01, 2.8432689192E-01, 5.8293138233E-01],
	[1.1785000000E+04, 5.2896834910E+00, 5.7954288318E+00, 3.1734024050E-01, 2.8467409248E-01, 5.8307796652E-01],
	[1.1790000000E+04, 5.2926743490E+00, 5.7948689542E+00, 3.1776295224E-01, 2.8502153510E-01, 5.8322452987E-01],
	[1.1795000000E+04, 5.2956656290E+00, 5.7943093679E+00, 3.1818604702E-01, 2.8536921976E-01, 5.8337107238E-01],
	[1.1800000000E+04, 5.2986573307E+00, 5.7937500728E+00, 3.1860952502E-01, 2.8571714645E-01, 5.8351759405E-01],
	[1.1805000000E+04, 5.3016494541E+00, 5.7931910687E+00, 3.1903338642E-01, 2.8606531515E-01, 5.8366409488E-01],
	[1.1810000000E+04, 5.3046419989E+00, 5.7926323551E+00, 3.1945763141E-01, 2.8641372586E-01, 5.8381057486E-01],
	[1.1815000000E+04, 5.3076349652E+00, 5.7920739319E+00, 3.1988226016E-01, 2.8676237854E-01, 5.8395703399E-01],
	[1.1820000000E+04, 5.3106283528E+00, 5.7915157987E+00, 3.2030727287E-01, 2.8711127319E-01, 5.8410347227E-01],
	[1.1825000000E+04, 5.3136221615E+00, 5.7909579554E+00, 3.2073266972E-01, 2.8746040980E-01, 5.8424988970E-01],
	[1.1830000000E+04, 5.3166163912E+00, 5.7904004015E+00, 3.2115845089E-01, 2.8780978833E-01, 5.8439628626E-01],
	[1.1835000000E+04, 5.3196110419E+00, 5.7898431370E+00, 3.2158461656E-01, 2.8815940879E-01, 5.8454266197E-01],
	[1.1840000000E+04, 5.3226061134E+00, 5.7892861613E+00, 3.2201116693E-01, 2.8850927114E-01, 5.8468901682E-01],
	[1.1845000000E+04, 5.3256024492E+00, 5.7887311243E+00, 3.2243810216E-01, 2.8885938197E-01, 5.8483535080E-01],
	[1.1850000000E+04, 5.3286031296E+00, 5.7881840428E+00, 3.2286542246E-01, 2.8920976540E-01, 5.8498166392E-01],
	[1.1855000000E+04, 5.3316042337E+00, 5.7876372438E+00, 3.2329312799E-01, 2.8956039083E-01, 5.8512795617E-01],
	[1.1860000000E+04, 5.3346057616E+00, 5.7870907270E+00, 3.2372121896E-01, 2.8991125824E-01, 5.8527422755E-01],
	[1.1865000000E+04, 5.3376077130E+00, 5.7865444921E+00, 3.2414969553E-01, 2.9026236763E-01, 5.8542047805E-01],
	[1.1870000000E+04, 5.3406100878E+00, 5.7859985389E+00, 3.2457855789E-01, 2.9061371897E-01, 5.8556670768E-01],
	[1.1875000000E+04, 5.3436128860E+00, 5.7854528671E+00, 3.2500780623E-01, 2.9096531224E-01, 5.8571291643E-01],
	[1.1880000000E+04, 5.3466161074E+00, 5.7849074764E+00, 3.2543744074E-01, 2.9131714744E-01, 5.8585910430E-01],
	[1.1885000000E+04, 5.3496197519E+00, 5.7843623666E+00, 3.2586746158E-01, 2.9166922453E-01, 5.8600527128E-01],
	[1.1890000000E+04, 5.3526238194E+00, 5.7838175374E+00, 3.2629786896E-01, 2.9202154350E-01, 5.8615141739E-01],
	[1.1895000000E+04, 5.3556283097E+00, 5.7832729886E+00, 3.2672866305E-01, 2.9237410434E-01, 5.8629754260E-01],
	[1.1900000000E+04, 5.3586332228E+00, 5.7827287198E+00, 3.2715984404E-01, 2.9272690703E-01, 5.8644364693E-01],
	[1.1905000000E+04, 5.3616385584E+00, 5.7821847309E+00, 3.2759141211E-01, 2.9307995154E-01, 5.8658973035E-01],
	[1.1910000000E+04, 5.3646443166E+00, 5.7816410215E+00, 3.2802336745E-01, 2.9343323786E-01, 5.8673579283E-01],
	[1.1915000000E+04, 5.3676504972E+00, 5.7810975914E+00, 3.2845571023E-01, 2.9378676597E-01, 5.8688183437E-01],
	[1.1920000000E+04, 5.3706571000E+00, 5.7805544404E+00, 3.2888844065E-01, 2.9414053585E-01, 5.8702785495E-01],
	[1.1925000000E+04, 5.3736641250E+00, 5.7800115682E+00, 3.2932155889E-01, 2.9449454749E-01, 5.8717385456E-01],
	[1.1930000000E+04, 5.3766715720E+00, 5.7794689745E+00, 3.2975506512E-01, 2.9484880085E-01, 5.8731983319E-01],
	[1.1935000000E+04, 5.3796794409E+00, 5.7789266590E+00, 3.3018895955E-01, 2.9520329594E-01, 5.8746579082E-01],
	[1.1940000000E+04, 5.3826877316E+00, 5.7783846215E+00, 3.3062324234E-01, 2.9555803271E-01, 5.8761172745E-01],
	[1.1945000000E+04, 5.3856964439E+00, 5.7778428618E+00, 3.3105791369E-01, 2.9591301116E-01, 5.8775764307E-01],
	[1.1950000000E+04, 5.3887055779E+00, 5.7773013796E+00, 3.3149297378E-01, 2.9626823127E-01, 5.8790353766E-01],
	[1.1955000000E+04, 5.3917151332E+00, 5.7767601746E+00, 3.3192842279E-01, 2.9662369301E-01, 5.8804941120E-01],
	[1.1960000000E+04, 5.3947251099E+00, 5.7762192466E+00, 3.3236426091E-01, 2.9697939636E-01, 5.8819526370E-01],
	[1.1965000000E+04, 5.3977355078E+00, 5.7756785953E+00, 3.3280048831E-01, 2.9733534131E-01, 5.8834109513E-01],
	[1.1970000000E+04, 5.4007463268E+00, 5.7751382204E+00, 3.3323710520E-01, 2.9769152783E-01, 5.8848690549E-01],
	[1.1975000000E+04, 5.4037575668E+00, 5.7745981218E+00, 3.3367411174E-01, 2.9804795590E-01, 5.8863269476E-01],
	[1.1980000000E+04, 5.4067692276E+00, 5.7740582991E+00, 3.3411150812E-01, 2.9840462551E-01, 5.8877846294E-01],
	[1.1985000000E+04, 5.4097813092E+00, 5.7735187521E+00, 3.3454929454E-01, 2.9876153663E-01, 5.8892421000E-01],
	[1.1990000000E+04, 5.4127938113E+00, 5.7729794805E+00, 3.3498747116E-01, 2.9911868924E-01, 5.8906993595E-01],
	[1.1995000000E+04, 5.4158067340E+00, 5.7724404841E+00, 3.3542603818E-01, 2.9947608331E-01, 5.8921564076E-01],
	[1.2000000000E+04, 5.4188200771E+00, 5.7719017626E+00, 3.3586499578E-01, 2.9983371884E-01, 5.8936132443E-01],
	[1.2005000000E+04, 5.4218338404E+00, 5.7713633157E+00, 3.3630434415E-01, 3.0019159579E-01, 5.8950698694E-01],
	[1.2010000000E+04, 5.4248480239E+00, 5.7708251433E+00, 3.3674408346E-01, 3.0054971414E-01, 5.8965262829E-01],
	[1.2015000000E+04, 5.4278626275E+00, 5.7702872451E+00, 3.3718421391E-01, 3.0090807387E-01, 5.8979824846E-01],
	[1.2020000000E+04, 5.4308776509E+00, 5.7697496207E+00, 3.3762473568E-01, 3.0126667497E-01, 5.8994384745E-01],
	[1.2025000000E+04, 5.4338930942E+00, 5.7692122700E+00, 3.3806564894E-01, 3.0162551740E-01, 5.9008942523E-01],
	[1.2030000000E+04, 5.4369089572E+00, 5.7686751927E+00, 3.3850695389E-01, 3.0198460114E-01, 5.9023498180E-01],
	[1.2035000000E+04, 5.4399254469E+00, 5.7681387675E+00, 3.3894865072E-01, 3.0234392786E-01, 5.9038051716E-01],
	[1.2040000000E+04, 5.4429470613E+00, 5.7676112161E+00, 3.3939073960E-01, 3.0270353410E-01, 5.9052603127E-01],
	[1.2045000000E+04, 5.4459690985E+00, 5.7670839319E+00, 3.3983322071E-01, 3.0306338175E-01, 5.9067152415E-01],
	[1.2050000000E+04, 5.4489915583E+00, 5.7665569147E+00, 3.4027609425E-01, 3.0342347078E-01, 5.9081699577E-01],
	[1.2055000000E+04, 5.4520144406E+00, 5.7660301642E+00, 3.4071936040E-01, 3.0378380117E-01, 5.9096244612E-01],
	[1.2060000000E+04, 5.4550377453E+00, 5.7655036803E+00, 3.4116301934E-01, 3.0414437291E-01, 5.9110787520E-01],
	[1.2065000000E+04, 5.4580614723E+00, 5.7649774626E+00, 3.4160707125E-01, 3.0450518595E-01, 5.9125328298E-01],
	[1.2070000000E+04, 5.4610856215E+00, 5.7644515110E+00, 3.4205151633E-01, 3.0486624029E-01, 5.9139866947E-01],
	[1.2075000000E+04, 5.4641101927E+00, 5.7639258252E+00, 3.4249635475E-01, 3.0522753590E-01, 5.9154403465E-01],
	[1.2080000000E+04, 5.4671351859E+00, 5.7634004049E+00, 3.4294158670E-01, 3.0558907275E-01, 5.9168937851E-01],
	[1.2085000000E+04, 5.4701606009E+00, 5.7628752499E+00, 3.4338721236E-01, 3.0595085083E-01, 5.9183470104E-01],
	[1.2090000000E+04, 5.4731864376E+00, 5.7623503600E+00, 3.4383323193E-01, 3.0631287010E-01, 5.9198000222E-01],
	[1.2095000000E+04, 5.4762126959E+00, 5.7618257348E+00, 3.4427964557E-01, 3.0667513054E-01, 5.9212528206E-01],
	[1.2100000000E+04, 5.4792393757E+00, 5.7613013743E+00, 3.4472645348E-01, 3.0703763213E-01, 5.9227054053E-01],
	[1.2105000000E+04, 5.4822664768E+00, 5.7607772780E+00, 3.4517365585E-01, 3.0740037484E-01, 5.9241577762E-01],
	[1.2110000000E+04, 5.4852939992E+00, 5.7602534459E+00, 3.4562125284E-01, 3.0776335866E-01, 5.9256099333E-01],
	[1.2115000000E+04, 5.4883219427E+00, 5.7597298775E+00, 3.4606924466E-01, 3.0812658354E-01, 5.9270618764E-01],
	[1.2120000000E+04, 5.4913503072E+00, 5.7592065728E+00, 3.4651763149E-01, 3.0849004948E-01, 5.9285136055E-01],
	[1.2125000000E+04, 5.4943790927E+00, 5.7586835314E+00, 3.4696641350E-01, 3.0885375644E-01, 5.9299651204E-01],
	[1.2130000000E+04, 5.4974082989E+00, 5.7581607532E+00, 3.4741559089E-01, 3.0921770440E-01, 5.9314164211E-01],
	[1.2135000000E+04, 5.5004379257E+00, 5.7576382378E+00, 3.4786516384E-01, 3.0958189333E-01, 5.9328675073E-01],
	[1.2140000000E+04, 5.5034679732E+00, 5.7571159850E+00, 3.4831513252E-01, 3.0994632321E-01, 5.9343183791E-01],
	[1.2145000000E+04, 5.5064984410E+00, 5.7565939947E+00, 3.4876549714E-01, 3.1031099401E-01, 5.9357690363E-01],
	[1.2150000000E+04, 5.5095293292E+00, 5.7560722665E+00, 3.4921625787E-01, 3.1067590571E-01, 5.9372194788E-01],
	[1.2155000000E+04, 5.5125606376E+00, 5.7555508002E+00, 3.4966741489E-01, 3.1104105827E-01, 5.9386697065E-01],
	[1.2160000000E+04, 5.5155923661E+00, 5.7550295956E+00, 3.5011896840E-01, 3.1140645168E-01, 5.9401197194E-01],
	[1.2165000000E+04, 5.5186245146E+00, 5.7545086524E+00, 3.5057091857E-01, 3.1177208590E-01, 5.9415695172E-01],
	[1.2170000000E+04, 5.5216570830E+00, 5.7539879705E+00, 3.5102326559E-01, 3.1213796092E-01, 5.9430190999E-01],
	[1.2175000000E+04, 5.5246900711E+00, 5.7534675494E+00, 3.5147600964E-01, 3.1250407669E-01, 5.9444684674E-01],
	[1.2180000000E+04, 5.5277234788E+00, 5.7529473891E+00, 3.5192915091E-01, 3.1287043320E-01, 5.9459176196E-01],
	[1.2185000000E+04, 5.5307573061E+00, 5.7524274893E+00, 3.5238268959E-01, 3.1323703043E-01, 5.9473665564E-01],
	[1.2190000000E+04, 5.5337915527E+00, 5.7519078498E+00, 3.5283662586E-01, 3.1360386833E-01, 5.9488152777E-01],
	[1.2195000000E+04, 5.5368262187E+00, 5.7513884702E+00, 3.5329095990E-01, 3.1397094688E-01, 5.9502637834E-01],
	[1.2200000000E+04, 5.5398613039E+00, 5.7508693504E+00, 3.5374569189E-01, 3.1433826607E-01, 5.9517120734E-01],
	[1.2205000000E+04, 5.5428968081E+00, 5.7503504902E+00, 3.5420082203E-01, 3.1470582585E-01, 5.9531601475E-01],
	[1.2210000000E+04, 5.5459327312E+00, 5.7498318893E+00, 3.5465635049E-01, 3.1507362620E-01, 5.9546080058E-01],
	[1.2215000000E+04, 5.5489690733E+00, 5.7493135474E+00, 3.5511227747E-01, 3.1544166710E-01, 5.9560556480E-01],
	[1.2220000000E+04, 5.5520058340E+00, 5.7487954643E+00, 3.5556860314E-01, 3.1580994850E-01, 5.9575030742E-01],
	[1.2225000000E+04, 5.5550430133E+00, 5.7482776399E+00, 3.5602532770E-01, 3.1617847040E-01, 5.9589502841E-01],
	[1.2230000000E+04, 5.5580820954E+00, 5.7477626133E+00, 3.5648245131E-01, 3.1654724527E-01, 5.9603972777E-01],
	[1.2235000000E+04, 5.5611251718E+00, 5.7472539560E+00, 3.5693997418E-01, 3.1691629081E-01, 5.9618440549E-01],
	[1.2240000000E+04, 5.5641686699E+00, 5.7467455515E+00, 3.5739789649E-01, 3.1728557692E-01, 5.9632906156E-01],
	[1.2245000000E+04, 5.5672125896E+00, 5.7462373996E+00, 3.5785621841E-01, 3.1765510357E-01, 5.9647369597E-01],
	[1.2250000000E+04, 5.5702569309E+00, 5.7457295000E+00, 3.5831494013E-01, 3.1802487073E-01, 5.9661830871E-01],
	[1.2255000000E+04, 5.5733016935E+00, 5.7452218526E+00, 3.5877406185E-01, 3.1839487837E-01, 5.9676289977E-01],
	[1.2260000000E+04, 5.5763468775E+00, 5.7447144571E+00, 3.5923358374E-01, 3.1876512646E-01, 5.9690746914E-01],
	[1.2265000000E+04, 5.5793924825E+00, 5.7442073132E+00, 3.5969350599E-01, 3.1913561498E-01, 5.9705201681E-01],
	[1.2270000000E+04, 5.5824385087E+00, 5.7437004208E+00, 3.6015382878E-01, 3.1950634389E-01, 5.9719654277E-01],
	[1.2275000000E+04, 5.5854849558E+00, 5.7431937797E+00, 3.6061455229E-01, 3.1987731316E-01, 5.9734104701E-01],
	[1.2280000000E+04, 5.5885318237E+00, 5.7426873895E+00, 3.6107567673E-01, 3.2024852276E-01, 5.9748552953E-01],
	[1.2285000000E+04, 5.5915791123E+00, 5.7421812500E+00, 3.6153720225E-01, 3.2061997267E-01, 5.9762999030E-01],
	[1.2290000000E+04, 5.5946268216E+00, 5.7416753611E+00, 3.6199912906E-01, 3.2099166285E-01, 5.9777442933E-01],
	[1.2295000000E+04, 5.5976749513E+00, 5.7411697226E+00, 3.6246145734E-01, 3.2136359328E-01, 5.9791884661E-01],
	[1.2300000000E+04, 5.6007235014E+00, 5.7406643341E+00, 3.6292418727E-01, 3.2173576392E-01, 5.9806324212E-01],
	[1.2305000000E+04, 5.6037724717E+00, 5.7401591955E+00, 3.6338731903E-01, 3.2210817474E-01, 5.9820761585E-01],
	[1.2310000000E+04, 5.6068218623E+00, 5.7396543065E+00, 3.6385085282E-01, 3.2248082571E-01, 5.9835196779E-01],
	[1.2315000000E+04, 5.6098716728E+00, 5.7391496669E+00, 3.6431478881E-01, 3.2285371680E-01, 5.9849629795E-01],
	[1.2320000000E+04, 5.6129219033E+00, 5.7386452765E+00, 3.6477912720E-01, 3.2322684798E-01, 5.9864060630E-01],
	[1.2325000000E+04, 5.6159725536E+00, 5.7381411351E+00, 3.6524386816E-01, 3.2360021922E-01, 5.9878489283E-01],
	[1.2330000000E+04, 5.6190236235E+00, 5.7376372424E+00, 3.6570901188E-01, 3.2397383048E-01, 5.9892915754E-01],
	[1.2335000000E+04, 5.6220751131E+00, 5.7371335982E+00, 3.6617455854E-01, 3.2434768174E-01, 5.9907340043E-01],
	[1.2340000000E+04, 5.6251270221E+00, 5.7366302024E+00, 3.6664050834E-01, 3.2472177296E-01, 5.9921762147E-01],
	[1.2345000000E+04, 5.6281793506E+00, 5.7361270546E+00, 3.6710686145E-01, 3.2509610411E-01, 5.9936182066E-01],
	[1.2350000000E+04, 5.6312320982E+00, 5.7356241546E+00, 3.6757361806E-01, 3.2547067516E-01, 5.9950599799E-01],
	[1.2355000000E+04, 5.6342852650E+00, 5.7351215023E+00, 3.6804077836E-01, 3.2584548608E-01, 5.9965015346E-01],
	[1.2360000000E+04, 5.6373388508E+00, 5.7346190973E+00, 3.6850834252E-01, 3.2622053683E-01, 5.9979428704E-01],
	[1.2365000000E+04, 5.6403928555E+00, 5.7341169396E+00, 3.6897631074E-01, 3.2659582738E-01, 5.9993839874E-01],
	[1.2370000000E+04, 5.6434472791E+00, 5.7336150288E+00, 3.6944468320E-01, 3.2697135770E-01, 6.0008248855E-01],
	[1.2375000000E+04, 5.6465021213E+00, 5.7331133648E+00, 3.6991346009E-01, 3.2734712775E-01, 6.0022655645E-01],
	[1.2380000000E+04, 5.6495573821E+00, 5.7326119473E+00, 3.7038264158E-01, 3.2772313751E-01, 6.0037060243E-01],
	[1.2385000000E+04, 5.6526130614E+00, 5.7321107760E+00, 3.7085222788E-01, 3.2809938693E-01, 6.0051462650E-01],
	[1.2390000000E+04, 5.6556691590E+00, 5.7316098509E+00, 3.7132221914E-01, 3.2847587600E-01, 6.0065862863E-01],
	[1.2395000000E+04, 5.6587256748E+00, 5.7311091716E+00, 3.7179261558E-01, 3.2885260466E-01, 6.0080260882E-01],
	[1.2400000000E+04, 5.6617826088E+00, 5.7306087379E+00, 3.7226341736E-01, 3.2922957289E-01, 6.0094656707E-01],
	[1.2405000000E+04, 5.6648399609E+00, 5.7301085497E+00, 3.7273462468E-01, 3.2960678066E-01, 6.0109050335E-01],
	[1.2410000000E+04, 5.6678977308E+00, 5.7296086067E+00, 3.7320623772E-01, 3.2998422793E-01, 6.0123441767E-01],
	[1.2415000000E+04, 5.6709559185E+00, 5.7291089086E+00, 3.7367825666E-01, 3.3036191466E-01, 6.0137831001E-01],
	[1.2420000000E+04, 5.6740145239E+00, 5.7286094553E+00, 3.7415068169E-01, 3.3073984082E-01, 6.0152218037E-01],
	[1.2425000000E+04, 5.6770735469E+00, 5.7281102465E+00, 3.7462351300E-01, 3.3111800639E-01, 6.0166602874E-01],
	[1.2430000000E+04, 5.6801377920E+00, 5.7276189622E+00, 3.7509675077E-01, 3.3149645340E-01, 6.0180985510E-01],
	[1.2435000000E+04, 5.6832028705E+00, 5.7271285771E+00, 3.7557039518E-01, 3.3187514353E-01, 6.0195365945E-01],
	[1.2440000000E+04, 5.6862683698E+00, 5.7266384310E+00, 3.7604444642E-01, 3.3225407313E-01, 6.0209744179E-01],
	[1.2445000000E+04, 5.6893342898E+00, 5.7261485238E+00, 3.7651890468E-01, 3.3263324216E-01, 6.0224120209E-01],
	[1.2450000000E+04, 5.6924006303E+00, 5.7256588554E+00, 3.7699377013E-01, 3.3301265059E-01, 6.0238494036E-01],
	[1.2455000000E+04, 5.6954673912E+00, 5.7251694253E+00, 3.7746904297E-01, 3.3339229838E-01, 6.0252865659E-01],
	[1.2460000000E+04, 5.6985345725E+00, 5.7246802335E+00, 3.7794472338E-01, 3.3377218551E-01, 6.0267235076E-01],
	[1.2465000000E+04, 5.7016021740E+00, 5.7241912798E+00, 3.7842081155E-01, 3.3415231192E-01, 6.0281602287E-01],
	[1.2470000000E+04, 5.7046701956E+00, 5.7237025639E+00, 3.7889730766E-01, 3.3453267760E-01, 6.0295967291E-01],
	[1.2475000000E+04, 5.7077386371E+00, 5.7232140856E+00, 3.7937421189E-01, 3.3491328250E-01, 6.0310330087E-01],
	[1.2480000000E+04, 5.7108074986E+00, 5.7227258447E+00, 3.7985152443E-01, 3.3529412658E-01, 6.0324690674E-01],
	[1.2485000000E+04, 5.7138767798E+00, 5.7222378410E+00, 3.8032924547E-01, 3.3567520981E-01, 6.0339049063E-01],
	[1.2490000000E+04, 5.7169464806E+00, 5.7217500743E+00, 3.8080737519E-01, 3.3605653216E-01, 6.0353405266E-01],
	[1.2495000000E+04, 5.7200166010E+00, 5.7212625444E+00, 3.8128591377E-01, 3.3643809358E-01, 6.0367759282E-01],
	[1.2500000000E+04, 5.7230871409E+00, 5.7207752510E+00, 3.8176486141E-01, 3.3681989405E-01, 6.0382111108E-01],
	[1.2505000000E+04, 5.7261581001E+00, 5.7202881940E+00, 3.8224509077E-01, 3.3720261250E-01, 6.0396460744E-01],
	[1.2510000000E+04, 5.7292294785E+00, 5.7198013732E+00, 3.8272573145E-01, 3.3758557106E-01, 6.0410808189E-01],
	[1.2515000000E+04, 5.7323012760E+00, 5.7193147882E+00, 3.8320678364E-01, 3.3796876970E-01, 6.0425153440E-01],
	[1.2520000000E+04, 5.7353734924E+00, 5.7188284391E+00, 3.8368824751E-01, 3.3835220838E-01, 6.0439496496E-01],
	[1.2525000000E+04, 5.7384461278E+00, 5.7183423254E+00, 3.8417012327E-01, 3.3873588707E-01, 6.0453837356E-01],
	[1.2530000000E+04, 5.7415191820E+00, 5.7178564470E+00, 3.8465241110E-01, 3.3911980571E-01, 6.0468176018E-01],
	[1.2535000000E+04, 5.7445926548E+00, 5.7173708038E+00, 3.8513511118E-01, 3.3950396429E-01, 6.0482512481E-01],
	[1.2540000000E+04, 5.7476665461E+00, 5.7168853955E+00, 3.8561822369E-01, 3.3988836275E-01, 6.0496846744E-01],
	[1.2545000000E+04, 5.7507408560E+00, 5.7164002218E+00, 3.8610174884E-01, 3.4027300106E-01, 6.0511178804E-01],
	[1.2550000000E+04, 5.7538155841E+00, 5.7159152827E+00, 3.8658568681E-01, 3.4065787919E-01, 6.0525508661E-01],
	[1.2555000000E+04, 5.7568907305E+00, 5.7154305778E+00, 3.8707003777E-01, 3.4104299710E-01, 6.0539836312E-01],
	[1.2560000000E+04, 5.7599662949E+00, 5.7149461070E+00, 3.8755480193E-01, 3.4142835474E-01, 6.0554161758E-01],
	[1.2565000000E+04, 5.7630422774E+00, 5.7144618700E+00, 3.8803997946E-01, 3.4181395208E-01, 6.0568484995E-01],
	[1.2570000000E+04, 5.7661186778E+00, 5.7139778667E+00, 3.8852557056E-01, 3.4219978908E-01, 6.0582806023E-01],
	[1.2575000000E+04, 5.7691954960E+00, 5.7134940969E+00, 3.8901157541E-01, 3.4258586570E-01, 6.0597124841E-01],
	[1.2580000000E+04, 5.7722727318E+00, 5.7130105603E+00, 3.8949799419E-01, 3.4297218191E-01, 6.0611441446E-01],
	[1.2585000000E+04, 5.7753503852E+00, 5.7125272568E+00, 3.8998482711E-01, 3.4335873766E-01, 6.0625755838E-01],
	[1.2590000000E+04, 5.7784284561E+00, 5.7120441861E+00, 3.9047207433E-01, 3.4374553291E-01, 6.0640068014E-01],
	[1.2595000000E+04, 5.7815069443E+00, 5.7115613480E+00, 3.9095973606E-01, 3.4413256763E-01, 6.0654377974E-01],
	[1.2600000000E+04, 5.7845858498E+00, 5.7110787424E+00, 3.9144781247E-01, 3.4451984177E-01, 6.0668685717E-01],
	[1.2605000000E+04, 5.7876651724E+00, 5.7105963690E+00, 3.9193630376E-01, 3.4490735530E-01, 6.0682991240E-01],
	[1.2610000000E+04, 5.7907449120E+00, 5.7101142276E+00, 3.9242521012E-01, 3.4529510818E-01, 6.0697294542E-01],
	[1.2615000000E+04, 5.7938250685E+00, 5.7096323180E+00, 3.9291453172E-01, 3.4568310036E-01, 6.0711595622E-01],
	[1.2620000000E+04, 5.7969056418E+00, 5.7091506400E+00, 3.9340426876E-01, 3.4607133180E-01, 6.0725894479E-01],
	[1.2625000000E+04, 5.7999866319E+00, 5.7086691935E+00, 3.9389442142E-01, 3.4645980247E-01, 6.0740191111E-01],
	[1.2630000000E+04, 5.8030730796E+00, 5.7081953948E+00, 3.9438498990E-01, 3.4684855772E-01, 6.0754485517E-01],
	[1.2635000000E+04, 5.8061604186E+00, 5.7077225160E+00, 3.9487597437E-01, 3.4723755654E-01, 6.0768777695E-01],
	[1.2640000000E+04, 5.8092481776E+00, 5.7072498635E+00, 3.9536737503E-01, 3.4762679464E-01, 6.0783067644E-01],
	[1.2645000000E+04, 5.8123363566E+00, 5.7067774370E+00, 3.9585919206E-01, 3.4801627199E-01, 6.0797355362E-01],
	[1.2650000000E+04, 5.8154249553E+00, 5.7063052364E+00, 3.9635142566E-01, 3.4840598856E-01, 6.0811640849E-01],
	[1.2655000000E+04, 5.8185139739E+00, 5.7058332614E+00, 3.9684407600E-01, 3.4879594429E-01, 6.0825924102E-01],
	[1.2660000000E+04, 5.8216034120E+00, 5.7053615119E+00, 3.9733714328E-01, 3.4918613914E-01, 6.0840205121E-01],
	[1.2665000000E+04, 5.8246932696E+00, 5.7048899876E+00, 3.9783062768E-01, 3.4957657309E-01, 6.0854483904E-01],
	[1.2670000000E+04, 5.8277835466E+00, 5.7044186884E+00, 3.9832452940E-01, 3.4996724607E-01, 6.0868760449E-01],
	[1.2675000000E+04, 5.8308742429E+00, 5.7039476141E+00, 3.9881884861E-01, 3.5035815806E-01, 6.0883034756E-01],
	[1.2680000000E+04, 5.8339653584E+00, 5.7034767644E+00, 3.9931358551E-01, 3.5074930901E-01, 6.0897306823E-01],
	[1.2685000000E+04, 5.8370568929E+00, 5.7030061392E+00, 3.9980874028E-01, 3.5114069888E-01, 6.0911576648E-01],
	[1.2690000000E+04, 5.8401488464E+00, 5.7025357383E+00, 4.0030431311E-01, 3.5153232763E-01, 6.0925844231E-01],
	[1.2695000000E+04, 5.8432412187E+00, 5.7020655614E+00, 4.0080030419E-01, 3.5192419521E-01, 6.0940109569E-01],
	[1.2700000000E+04, 5.8463340098E+00, 5.7015956085E+00, 4.0129671370E-01, 3.5231630158E-01, 6.0954372662E-01],
	[1.2705000000E+04, 5.8494272195E+00, 5.7011258792E+00, 4.0179354184E-01, 3.5270864670E-01, 6.0968633508E-01],
	[1.2710000000E+04, 5.8525208478E+00, 5.7006563735E+00, 4.0229078878E-01, 3.5310123053E-01, 6.0982892106E-01],
	[1.2715000000E+04, 5.8556148944E+00, 5.7001870910E+00, 4.0278845473E-01, 3.5349405302E-01, 6.0997148454E-01],
	[1.2720000000E+04, 5.8587093594E+00, 5.6997180317E+00, 4.0328653986E-01, 3.5388711413E-01, 6.1011402552E-01],
	[1.2725000000E+04, 5.8618042426E+00, 5.6992491953E+00, 4.0378504436E-01, 3.5428041382E-01, 6.1025654397E-01],
	[1.2730000000E+04, 5.8648995439E+00, 5.6987805816E+00, 4.0428396843E-01, 3.5467395205E-01, 6.1039903989E-01],
	[1.2735000000E+04, 5.8679952631E+00, 5.6983121904E+00, 4.0478331224E-01, 3.5506772876E-01, 6.1054151325E-01],
	[1.2740000000E+04, 5.8710914003E+00, 5.6978440216E+00, 4.0528307599E-01, 3.5546174393E-01, 6.1068396406E-01],
	[1.2745000000E+04, 5.8741879552E+00, 5.6973760749E+00, 4.0578325986E-01, 3.5585599749E-01, 6.1082639229E-01],
	[1.2750000000E+04, 5.8772849277E+00, 5.6969083502E+00, 4.0628386404E-01, 3.5625048941E-01, 6.1096879794E-01],
	[1.2755000000E+04, 5.8803823178E+00, 5.6964408473E+00, 4.0678488872E-01, 3.5664521965E-01, 6.1111118098E-01],
	[1.2760000000E+04, 5.8834801254E+00, 5.6959735659E+00, 4.0728633408E-01, 3.5704018816E-01, 6.1125354140E-01],
	[1.2765000000E+04, 5.8865783503E+00, 5.6955065058E+00, 4.0778820032E-01, 3.5743539490E-01, 6.1139587920E-01],
	[1.2770000000E+04, 5.8896769925E+00, 5.6950396670E+00, 4.0829048762E-01, 3.5783083981E-01, 6.1153819436E-01],
	[1.2775000000E+04, 5.8927760518E+00, 5.6945730492E+00, 4.0879319617E-01, 3.5822652287E-01, 6.1168048687E-01],
	[1.2780000000E+04, 5.8958755280E+00, 5.6941066521E+00, 4.0929632616E-01, 3.5862244401E-01, 6.1182275670E-01],
	[1.2785000000E+04, 5.8989754212E+00, 5.6936404757E+00, 4.0979987776E-01, 3.5901860320E-01, 6.1196500386E-01],
	[1.2790000000E+04, 5.9020757313E+00, 5.6931745197E+00, 4.1030385118E-01, 3.5941500040E-01, 6.1210722833E-01],
	[1.2795000000E+04, 5.9051764580E+00, 5.6927087839E+00, 4.1080824660E-01, 3.5981163554E-01, 6.1224943009E-01],
	[1.2800000000E+04, 5.9082776013E+00, 5.6922432682E+00, 4.1131306421E-01, 3.6020850860E-01, 6.1239160913E-01],
	[1.2805000000E+04, 5.9113791611E+00, 5.6917779723E+00, 4.1181830419E-01, 3.6060561952E-01, 6.1253376544E-01],
	[1.2810000000E+04, 5.9144811372E+00, 5.6913128961E+00, 4.1232396673E-01, 3.6100296826E-01, 6.1267589900E-01],
	[1.2815000000E+04, 5.9175835296E+00, 5.6908480394E+00, 4.1283005203E-01, 3.6140055478E-01, 6.1281800981E-01],
	[1.2820000000E+04, 5.9206863382E+00, 5.6903834019E+00, 4.1333656026E-01, 3.6179837901E-01, 6.1296009785E-01],
	[1.2825000000E+04, 5.9237895629E+00, 5.6899189836E+00, 4.1384349161E-01, 3.6219644093E-01, 6.1310216310E-01],
	[1.2830000000E+04, 5.9268947634E+00, 5.6894568807E+00, 4.1435084628E-01, 3.6259475484E-01, 6.1324420556E-01],
	[1.2835000000E+04, 5.9300047295E+00, 5.6890008368E+00, 4.1485862445E-01, 3.6299334646E-01, 6.1338622521E-01],
	[1.2840000000E+04, 5.9331151152E+00, 5.6885450070E+00, 4.1536682631E-01, 3.6339217581E-01, 6.1352822204E-01],
	[1.2845000000E+04, 5.9362259203E+00, 5.6880893911E+00, 4.1587545204E-01, 3.6379124287E-01, 6.1367019604E-01],
	[1.2850000000E+04, 5.9393371450E+00, 5.6876339891E+00, 4.1638450184E-01, 3.6419054756E-01, 6.1381214720E-01],
	[1.2855000000E+04, 5.9424487889E+00, 5.6871788006E+00, 4.1689397589E-01, 3.6459008986E-01, 6.1395407549E-01],
	[1.2860000000E+04, 5.9455608520E+00, 5.6867238256E+00, 4.1740387438E-01, 3.6498986971E-01, 6.1409598091E-01],
	[1.2865000000E+04, 5.9486733342E+00, 5.6862690638E+00, 4.1791419750E-01, 3.6538988706E-01, 6.1423786345E-01],
	[1.2870000000E+04, 5.9517862354E+00, 5.6858145151E+00, 4.1842494543E-01, 3.6579014187E-01, 6.1437972310E-01],
	[1.2875000000E+04, 5.9548995555E+00, 5.6853601792E+00, 4.1893611837E-01, 3.6619063409E-01, 6.1452155983E-01],
	[1.2880000000E+04, 5.9580132944E+00, 5.6849060561E+00, 4.1944771650E-01, 3.6659136368E-01, 6.1466337365E-01],
	[1.2885000000E+04, 5.9611274519E+00, 5.6844521454E+00, 4.1995974000E-01, 3.6699233057E-01, 6.1480516453E-01],
	[1.2890000000E+04, 5.9642420280E+00, 5.6839984471E+00, 4.2047218907E-01, 3.6739353473E-01, 6.1494693247E-01],
	[1.2895000000E+04, 5.9673570226E+00, 5.6835449609E+00, 4.2098506390E-01, 3.6779497611E-01, 6.1508867745E-01],
	[1.2900000000E+04, 5.9704724355E+00, 5.6830916867E+00, 4.2149836467E-01, 3.6819665466E-01, 6.1523039946E-01],
	[1.2905000000E+04, 5.9735882667E+00, 5.6826386242E+00, 4.2201209156E-01, 3.6859857033E-01, 6.1537209848E-01],
	[1.2910000000E+04, 5.9767045160E+00, 5.6821857734E+00, 4.2252624478E-01, 3.6900072307E-01, 6.1551377452E-01],
	[1.2915000000E+04, 5.9798211833E+00, 5.6817331340E+00, 4.2304082450E-01, 3.6940311283E-01, 6.1565542754E-01],
	[1.2920000000E+04, 5.9829382685E+00, 5.6812807058E+00, 4.2355583092E-01, 3.6980573957E-01, 6.1579705755E-01],
	[1.2925000000E+04, 5.9860557716E+00, 5.6808284887E+00, 4.2407126421E-01, 3.7020860323E-01, 6.1593866453E-01],
	[1.2930000000E+04, 5.9891736924E+00, 5.6803764824E+00, 4.2458712458E-01, 3.7061170377E-01, 6.1608024846E-01],
	[1.2935000000E+04, 5.9922920308E+00, 5.6799246869E+00, 4.2510341220E-01, 3.7101504113E-01, 6.1622180934E-01],
	[1.2940000000E+04, 5.9954107868E+00, 5.6794731019E+00, 4.2562012727E-01, 3.7141861527E-01, 6.1636334715E-01],
	[1.2945000000E+04, 5.9985299601E+00, 5.6790217272E+00, 4.2613726998E-01, 3.7182242613E-01, 6.1650486188E-01],
	[1.2950000000E+04, 6.0016495507E+00, 5.6785705627E+00, 4.2665484050E-01, 3.7222647367E-01, 6.1664635353E-01],
	[1.2955000000E+04, 6.0047695585E+00, 5.6781196081E+00, 4.2717283903E-01, 3.7263075784E-01, 6.1678782207E-01],
	[1.2960000000E+04, 6.0078899834E+00, 5.6776688634E+00, 4.2769126576E-01, 3.7303527859E-01, 6.1692926749E-01],
	[1.2965000000E+04, 6.0110108252E+00, 5.6772183283E+00, 4.2821012088E-01, 3.7344003585E-01, 6.1707068979E-01],
	[1.2970000000E+04, 6.0141320840E+00, 5.6767680026E+00, 4.2872940457E-01, 3.7384502960E-01, 6.1721208894E-01],
	[1.2975000000E+04, 6.0172537595E+00, 5.6763178863E+00, 4.2924911702E-01, 3.7425025976E-01, 6.1735346495E-01],
	[1.2980000000E+04, 6.0203758517E+00, 5.6758679790E+00, 4.2976925842E-01, 3.7465572630E-01, 6.1749481780E-01],
	[1.2985000000E+04, 6.0234983604E+00, 5.6754182806E+00, 4.3028982895E-01, 3.7506142917E-01, 6.1763614747E-01],
	[1.2990000000E+04, 6.0266212856E+00, 5.6749687909E+00, 4.3081082881E-01, 3.7546736830E-01, 6.1777745396E-01],
	[1.2995000000E+04, 6.0297446271E+00, 5.6745195098E+00, 4.3133225819E-01, 3.7587354365E-01, 6.1791873724E-01],
	[1.3000000000E+04, 6.0328683849E+00, 5.6740704371E+00, 4.3185411726E-01, 3.7627995517E-01, 6.1805999732E-01],
	[1.3005000000E+04, 6.0359925588E+00, 5.6736215726E+00, 4.3237640623E-01, 3.7668660280E-01, 6.1820123418E-01],
	[1.3010000000E+04, 6.0391171488E+00, 5.6731729162E+00, 4.3289912527E-01, 3.7709348650E-01, 6.1834244781E-01],
	[1.3015000000E+04, 6.0422421547E+00, 5.6727244675E+00, 4.3342227458E-01, 3.7750060621E-01, 6.1848363819E-01],
	[1.3020000000E+04, 6.0453675764E+00, 5.6722762266E+00, 4.3394585434E-01, 3.7790796188E-01, 6.1862480531E-01],
	[1.3025000000E+04, 6.0484934138E+00, 5.6718281932E+00, 4.3446986474E-01, 3.7831555346E-01, 6.1876594917E-01],
	[1.3030000000E+04, 6.0516196669E+00, 5.6713803670E+00, 4.3499430597E-01, 3.7872338089E-01, 6.1890706975E-01],
	[1.3035000000E+04, 6.0547463354E+00, 5.6709327481E+00, 4.3551917822E-01, 3.7913144413E-01, 6.1904816704E-01],
	[1.3040000000E+04, 6.0578794732E+00, 5.6704927906E+00, 4.3604448168E-01, 3.7953980027E-01, 6.1918924106E-01],
	[1.3045000000E+04, 6.0610132876E+00, 5.6700533527E+00, 4.3657021653E-01, 3.7994839475E-01, 6.1933029181E-01],
	[1.3050000000E+04, 6.0641475213E+00, 5.6696141172E+00, 4.3709638296E-01, 3.8035722508E-01, 6.1947131929E-01],
	[1.3055000000E+04, 6.0672821743E+00, 5.6691750840E+00, 4.3762298117E-01, 3.8076629122E-01, 6.1961232347E-01],
	[1.3060000000E+04, 6.0704172463E+00, 5.6687362529E+00, 4.3815001133E-01, 3.8117559311E-01, 6.1975330433E-01],
	[1.3065000000E+04, 6.0735527373E+00, 5.6682976237E+00, 4.3867747364E-01, 3.8158513070E-01, 6.1989426185E-01],
	[1.3070000000E+04, 6.0766886472E+00, 5.6678591963E+00, 4.3920536828E-01, 3.8199490394E-01, 6.2003519602E-01],
	[1.3075000000E+04, 6.0798249759E+00, 5.6674209705E+00, 4.3973369545E-01, 3.8240491276E-01, 6.2017610680E-01],
	[1.3080000000E+04, 6.0829617233E+00, 5.6669829460E+00, 4.4026245532E-01, 3.8281515712E-01, 6.2031699419E-01],
	[1.3085000000E+04, 6.0860988892E+00, 5.6665451228E+00, 4.4079164810E-01, 3.8322563697E-01, 6.2045785816E-01],
	[1.3090000000E+04, 6.0892364736E+00, 5.6661075007E+00, 4.4132127396E-01, 3.8363635224E-01, 6.2059869870E-01],
	[1.3095000000E+04, 6.0923744763E+00, 5.6656700795E+00, 4.4185133311E-01, 3.8404730289E-01, 6.2073951578E-01],
	[1.3100000000E+04, 6.0955128974E+00, 5.6652328590E+00, 4.4238182571E-01, 3.8445848886E-01, 6.2088030938E-01],
	[1.3105000000E+04, 6.0986517365E+00, 5.6647958391E+00, 4.4291275197E-01, 3.8486991010E-01, 6.2102107949E-01],
	[1.3110000000E+04, 6.1017909938E+00, 5.6643590196E+00, 4.4344411206E-01, 3.8528156655E-01, 6.2116182609E-01],
	[1.3115000000E+04, 6.1049306690E+00, 5.6639224003E+00, 4.4397590619E-01, 3.8569345816E-01, 6.2130254915E-01],
	[1.3120000000E+04, 6.1080707620E+00, 5.6634859811E+00, 4.4450813453E-01, 3.8610558487E-01, 6.2144324866E-01],
	[1.3125000000E+04, 6.1112112728E+00, 5.6630497618E+00, 4.4504079728E-01, 3.8651794662E-01, 6.2158392460E-01],
	[1.3130000000E+04, 6.1143522012E+00, 5.6626137422E+00, 4.4557389463E-01, 3.8693054337E-01, 6.2172457694E-01],
	[1.3135000000E+04, 6.1174935471E+00, 5.6621779222E+00, 4.4610742675E-01, 3.8734337505E-01, 6.2186520568E-01],
	[1.3140000000E+04, 6.1206353105E+00, 5.6617423015E+00, 4.4664139385E-01, 3.8775644162E-01, 6.2200581078E-01],
	[1.3145000000E+04, 6.1237774912E+00, 5.6613068801E+00, 4.4717579610E-01, 3.8816974301E-01, 6.2214639224E-01],
	[1.3150000000E+04, 6.1269200891E+00, 5.6608716578E+00, 4.4771063370E-01, 3.8858327917E-01, 6.2228695003E-01],
	[1.3155000000E+04, 6.1300631041E+00, 5.6604366343E+00, 4.4824590684E-01, 3.8899705004E-01, 6.2242748413E-01],
	[1.3160000000E+04, 6.1332065362E+00, 5.6600018095E+00, 4.4878161569E-01, 3.8941105558E-01, 6.2256799453E-01],
	[1.3165000000E+04, 6.1363503852E+00, 5.6595671834E+00, 4.4931776047E-01, 3.8982529571E-01, 6.2270848120E-01],
	[1.3170000000E+04, 6.1394946509E+00, 5.6591327556E+00, 4.4985434134E-01, 3.9023977038E-01, 6.2284894413E-01],
	[1.3175000000E+04, 6.1426393334E+00, 5.6586985260E+00, 4.5039135850E-01, 3.9065447955E-01, 6.2298938329E-01],
	[1.3180000000E+04, 6.1457844325E+00, 5.6582644945E+00, 4.5092881214E-01, 3.9106942314E-01, 6.2312979867E-01],
	[1.3185000000E+04, 6.1489299481E+00, 5.6578306609E+00, 4.5146670244E-01, 3.9148460111E-01, 6.2327019025E-01],
	[1.3190000000E+04, 6.1520758801E+00, 5.6573970250E+00, 4.5200502960E-01, 3.9190001339E-01, 6.2341055802E-01],
	[1.3195000000E+04, 6.1552222284E+00, 5.6569635867E+00, 4.5254379380E-01, 3.9231565994E-01, 6.2355090194E-01],
	[1.3200000000E+04, 6.1583689929E+00, 5.6565303458E+00, 4.5308299523E-01, 3.9273154068E-01, 6.2369122201E-01],
	[1.3205000000E+04, 6.1615161735E+00, 5.6560973021E+00, 4.5362263407E-01, 3.9314765557E-01, 6.2383151820E-01],
	[1.3210000000E+04, 6.1646637701E+00, 5.6556644555E+00, 4.5416271053E-01, 3.9356400455E-01, 6.2397179050E-01],
	[1.3215000000E+04, 6.1678117825E+00, 5.6552318058E+00, 4.5470322478E-01, 3.9398058755E-01, 6.2411203888E-01],
	[1.3220000000E+04, 6.1709602108E+00, 5.6547993529E+00, 4.5524417702E-01, 3.9439740453E-01, 6.2425226333E-01],
	[1.3225000000E+04, 6.1741090547E+00, 5.6543670965E+00, 4.5578556743E-01, 3.9481445542E-01, 6.2439246384E-01],
	[1.3230000000E+04, 6.1772583142E+00, 5.6539350366E+00, 4.5632739620E-01, 3.9523174016E-01, 6.2453264037E-01],
	[1.3235000000E+04, 6.1804079892E+00, 5.6535031729E+00, 4.5686966352E-01, 3.9564925870E-01, 6.2467279292E-01],
	[1.3240000000E+04, 6.1835580795E+00, 5.6530715053E+00, 4.5741236958E-01, 3.9606701097E-01, 6.2481292146E-01],
	[1.3245000000E+04, 6.1867085851E+00, 5.6526400336E+00, 4.5795551457E-01, 3.9648499693E-01, 6.2495302597E-01],
	[1.3250000000E+04, 6.1898661532E+00, 5.6522162857E+00, 4.5849909867E-01, 3.9690328095E-01, 6.2509310645E-01],
	[1.3255000000E+04, 6.1930242118E+00, 5.6517928101E+00, 4.5904312208E-01, 3.9732179945E-01, 6.2523316286E-01],
	[1.3260000000E+04, 6.1961826896E+00, 5.6513695258E+00, 4.5958758498E-01, 3.9774055168E-01, 6.2537319520E-01],
	[1.3265000000E+04, 6.1993415867E+00, 5.6509464328E+00, 4.6013248756E-01, 3.9815953757E-01, 6.2551320344E-01],
	[1.3270000000E+04, 6.2025009028E+00, 5.6505235309E+00, 4.6067783001E-01, 3.9857875708E-01, 6.2565318756E-01],
	[1.3275000000E+04, 6.2056606378E+00, 5.6501008199E+00, 4.6122361252E-01, 3.9899821014E-01, 6.2579314755E-01],
	[1.3280000000E+04, 6.2088207918E+00, 5.6496782998E+00, 4.6176983527E-01, 3.9941789669E-01, 6.2593308338E-01],
	[1.3285000000E+04, 6.2119813645E+00, 5.6492559702E+00, 4.6231649846E-01, 3.9983781668E-01, 6.2607299505E-01],
	[1.3290000000E+04, 6.2151423558E+00, 5.6488338312E+00, 4.6286360227E-01, 4.0025797003E-01, 6.2621288253E-01],
	[1.3295000000E+04, 6.2183037658E+00, 5.6484118824E+00, 4.6341114690E-01, 4.0067835670E-01, 6.2635274580E-01],
	[1.3300000000E+04, 6.2214655942E+00, 5.6479901239E+00, 4.6395913252E-01, 4.0109897662E-01, 6.2649258485E-01],
	[1.3305000000E+04, 6.2246278409E+00, 5.6475685553E+00, 4.6450755934E-01, 4.0151982973E-01, 6.2663239965E-01],
	[1.3310000000E+04, 6.2277905059E+00, 5.6471471765E+00, 4.6505642753E-01, 4.0194091597E-01, 6.2677219020E-01],
	[1.3315000000E+04, 6.2309535891E+00, 5.6467259875E+00, 4.6560573730E-01, 4.0236223528E-01, 6.2691195647E-01],
	[1.3320000000E+04, 6.2341170903E+00, 5.6463049879E+00, 4.6615548881E-01, 4.0278378761E-01, 6.2705169844E-01],
	[1.3325000000E+04, 6.2372810095E+00, 5.6458841778E+00, 4.6670568227E-01, 4.0320557288E-01, 6.2719141609E-01],
	[1.3330000000E+04, 6.2404453465E+00, 5.6454635569E+00, 4.6725631787E-01, 4.0362759104E-01, 6.2733110942E-01],
	[1.3335000000E+04, 6.2436101012E+00, 5.6450431250E+00, 4.6780739578E-01, 4.0404984203E-01, 6.2747077840E-01],
	[1.3340000000E+04, 6.2467752737E+00, 5.6446228820E+00, 4.6835891621E-01, 4.0447232578E-01, 6.2761042300E-01],
	[1.3345000000E+04, 6.2499408636E+00, 5.6442028278E+00, 4.6891087933E-01, 4.0489504224E-01, 6.2775004323E-01],
	[1.3350000000E+04, 6.2531068710E+00, 5.6437829622E+00, 4.6946328535E-01, 4.0531799134E-01, 6.2788963905E-01],
	[1.3355000000E+04, 6.2562732958E+00, 5.6433632850E+00, 4.7001613443E-01, 4.0574117302E-01, 6.2802921045E-01],
	[1.3360000000E+04, 6.2594401377E+00, 5.6429437961E+00, 4.7056942679E-01, 4.0616458722E-01, 6.2816875741E-01],
	[1.3365000000E+04, 6.2626073969E+00, 5.6425244953E+00, 4.7112316259E-01, 4.0658823388E-01, 6.2830827992E-01],
	[1.3370000000E+04, 6.2657750730E+00, 5.6421053825E+00, 4.7167734204E-01, 4.0701211293E-01, 6.2844777796E-01],
	[1.3375000000E+04, 6.2689431661E+00, 5.6416864575E+00, 4.7223196533E-01, 4.0743622431E-01, 6.2858725150E-01],
	[1.3380000000E+04, 6.2721116760E+00, 5.6412677202E+00, 4.7278703263E-01, 4.0786056796E-01, 6.2872670054E-01],
	[1.3385000000E+04, 6.2752806027E+00, 5.6408491704E+00, 4.7334254414E-01, 4.0828514382E-01, 6.2886612505E-01],
	[1.3390000000E+04, 6.2784499460E+00, 5.6404308080E+00, 4.7389850004E-01, 4.0870995182E-01, 6.2900552501E-01],
	[1.3395000000E+04, 6.2816197059E+00, 5.6400126328E+00, 4.7445490054E-01, 4.0913499191E-01, 6.2914490042E-01],
	[1.3400000000E+04, 6.2847898821E+00, 5.6395946446E+00, 4.7501174580E-01, 4.0956026401E-01, 6.2928425125E-01],
	[1.3405000000E+04, 6.2879604747E+00, 5.6391768433E+00, 4.7556903604E-01, 4.0998576806E-01, 6.2942357749E-01],
	[1.3410000000E+04, 6.2911314836E+00, 5.6387592287E+00, 4.7612677142E-01, 4.1041150400E-01, 6.2956287911E-01],
	[1.3415000000E+04, 6.2943029085E+00, 5.6383418008E+00, 4.7668495215E-01, 4.1083747178E-01, 6.2970215611E-01],
	[1.3420000000E+04, 6.2974747495E+00, 5.6379245593E+00, 4.7724357840E-01, 4.1126367131E-01, 6.2984140845E-01],
	[1.3425000000E+04, 6.3006470065E+00, 5.6375075040E+00, 4.7780265038E-01, 4.1169010255E-01, 6.2998063614E-01],
	[1.3430000000E+04, 6.3038196792E+00, 5.6370906349E+00, 4.7836216826E-01, 4.1211676541E-01, 6.3011983914E-01],
	[1.3435000000E+04, 6.3069927677E+00, 5.6366739518E+00, 4.7892213224E-01, 4.1254365985E-01, 6.3025901745E-01],
	[1.3440000000E+04, 6.3101662718E+00, 5.6362574545E+00, 4.7948254251E-01, 4.1297078580E-01, 6.3039817104E-01],
	[1.3445000000E+04, 6.3133401915E+00, 5.6358411429E+00, 4.8004339925E-01, 4.1339814319E-01, 6.3053729989E-01],
	[1.3450000000E+04, 6.3165145265E+00, 5.6354250168E+00, 4.8060470265E-01, 4.1382573196E-01, 6.3067640400E-01],
	[1.3455000000E+04, 6.3196892769E+00, 5.6350090761E+00, 4.8116645291E-01, 4.1425355203E-01, 6.3081548335E-01],
	[1.3460000000E+04, 6.3228668945E+00, 5.6345958833E+00, 4.8172865021E-01, 4.1468162779E-01, 6.3095453791E-01],
	[1.3465000000E+04, 6.3260496072E+00, 5.6341877613E+00, 4.8229129473E-01, 4.1510998148E-01, 6.3109356767E-01],
	[1.3470000000E+04, 6.3292327394E+00, 5.6337798203E+00, 4.8285438668E-01, 4.1553856652E-01, 6.3123257261E-01],
	[1.3475000000E+04, 6.3324162910E+00, 5.6333720602E+00, 4.8341792623E-01, 4.1596738287E-01, 6.3137155272E-01],
	[1.3480000000E+04, 6.3356002620E+00, 5.6329644809E+00, 4.8398191359E-01, 4.1639643044E-01, 6.3151050798E-01],
	[1.3485000000E+04, 6.3387846523E+00, 5.6325570823E+00, 4.8454634892E-01, 4.1682570918E-01, 6.3164943838E-01],
	[1.3490000000E+04, 6.3419694617E+00, 5.6321498641E+00, 4.8511123244E-01, 4.1725521901E-01, 6.3178834389E-01],
	[1.3495000000E+04, 6.3451546901E+00, 5.6317428262E+00, 4.8567656431E-01, 4.1768495988E-01, 6.3192722450E-01],
	[1.3500000000E+04, 6.3483403375E+00, 5.6313359685E+00, 4.8624234474E-01, 4.1811493171E-01, 6.3206608019E-01],
	[1.3505000000E+04, 6.3515264038E+00, 5.6309292909E+00, 4.8680857391E-01, 4.1854513444E-01, 6.3220491095E-01],
	[1.3510000000E+04, 6.3547128887E+00, 5.6305227931E+00, 4.8737525201E-01, 4.1897556801E-01, 6.3234371676E-01],
	[1.3515000000E+04, 6.3578997924E+00, 5.6301164751E+00, 4.8794237923E-01, 4.1940623235E-01, 6.3248249760E-01],
	[1.3520000000E+04, 6.3610871146E+00, 5.6297103367E+00, 4.8850995576E-01, 4.1983712739E-01, 6.3262125346E-01],
	[1.3525000000E+04, 6.3642748552E+00, 5.6293043777E+00, 4.8907798179E-01, 4.2026825306E-01, 6.3275998432E-01],
	[1.3530000000E+04, 6.3674630141E+00, 5.6288985981E+00, 4.8964645750E-01, 4.2069960931E-01, 6.3289869016E-01],
	[1.3535000000E+04, 6.3706515914E+00, 5.6284929976E+00, 4.9021538309E-01, 4.2113119605E-01, 6.3303737097E-01],
	[1.3540000000E+04, 6.3738405867E+00, 5.6280875761E+00, 4.9078475874E-01, 4.2156301323E-01, 6.3317602673E-01],
	[1.3545000000E+04, 6.3770300001E+00, 5.6276823335E+00, 4.9135458465E-01, 4.2199506078E-01, 6.3331465743E-01],
	[1.3550000000E+04, 6.3802198315E+00, 5.6272772696E+00, 4.9192486100E-01, 4.2242733863E-01, 6.3345326304E-01],
	[1.3555000000E+04, 6.3834100807E+00, 5.6268723843E+00, 4.9249558799E-01, 4.2285984671E-01, 6.3359184356E-01],
	[1.3560000000E+04, 6.3866007477E+00, 5.6264676774E+00, 4.9306676579E-01, 4.2329258495E-01, 6.3373039896E-01],
	[1.3565000000E+04, 6.3897918323E+00, 5.6260631489E+00, 4.9363839460E-01, 4.2372555330E-01, 6.3386892923E-01],
	[1.3570000000E+04, 6.3929833344E+00, 5.6256587984E+00, 4.9421047462E-01, 4.2415875167E-01, 6.3400743435E-01],
	[1.3575000000E+04, 6.3961752540E+00, 5.6252546260E+00, 4.9478300602E-01, 4.2459218000E-01, 6.3414591432E-01],
	[1.3580000000E+04, 6.3993675910E+00, 5.6248506315E+00, 4.9535598900E-01, 4.2502583823E-01, 6.3428436910E-01],
	[1.3585000000E+04, 6.4025603452E+00, 5.6244468146E+00, 4.9592942374E-01, 4.2545972628E-01, 6.3442279869E-01],
	[1.3590000000E+04, 6.4057535166E+00, 5.6240431754E+00, 4.9650331044E-01, 4.2589384409E-01, 6.3456120306E-01],
	[1.3595000000E+04, 6.4089471050E+00, 5.6236397135E+00, 4.9707764929E-01, 4.2632819159E-01, 6.3469958221E-01],
	[1.3600000000E+04, 6.4121411104E+00, 5.6232364290E+00, 4.9765244047E-01, 4.2676276871E-01, 6.3483793612E-01],
	[1.3605000000E+04, 6.4153355326E+00, 5.6228333216E+00, 4.9822768417E-01, 4.2719757537E-01, 6.3497626477E-01],
	[1.3610000000E+04, 6.4185303716E+00, 5.6224303912E+00, 4.9880338059E-01, 4.2763261152E-01, 6.3511456814E-01],
	[1.3615000000E+04, 6.4217256273E+00, 5.6220276376E+00, 4.9937952991E-01, 4.2806787707E-01, 6.3525284622E-01],
	[1.3620000000E+04, 6.4249212995E+00, 5.6216250608E+00, 4.9995613231E-01, 4.2850337197E-01, 6.3539109900E-01],
	[1.3625000000E+04, 6.4281173882E+00, 5.6212226605E+00, 5.0053318800E-01, 4.2893909615E-01, 6.3552932645E-01],
	[1.3630000000E+04, 6.4313138932E+00, 5.6208204367E+00, 5.0111069716E-01, 4.2937504952E-01, 6.3566752857E-01],
	[1.3635000000E+04, 6.4345108145E+00, 5.6204183892E+00, 5.0168865997E-01, 4.2981123203E-01, 6.3580570533E-01],
	[1.3640000000E+04, 6.4377081520E+00, 5.6200165178E+00, 5.0226707664E-01, 4.3024764360E-01, 6.3594385672E-01],
	[1.3645000000E+04, 6.4409059055E+00, 5.6196148224E+00, 5.0284594734E-01, 4.3068428416E-01, 6.3608198272E-01],
	[1.3650000000E+04, 6.4441040750E+00, 5.6192133029E+00, 5.0342527226E-01, 4.3112115365E-01, 6.3622008333E-01],
	[1.3655000000E+04, 6.4473026604E+00, 5.6188119591E+00, 5.0400505160E-01, 4.3155825199E-01, 6.3635815852E-01],
	[1.3660000000E+04, 6.4505016616E+00, 5.6184107909E+00, 5.0458528555E-01, 4.3199557911E-01, 6.3649620827E-01],
	[1.3665000000E+04, 6.4537010784E+00, 5.6180097981E+00, 5.0516597429E-01, 4.3243313493E-01, 6.3663423258E-01],
	[1.3670000000E+04, 6.4569009108E+00, 5.6176089806E+00, 5.0574711801E-01, 4.3287091940E-01, 6.3677223142E-01],
	[1.3675000000E+04, 6.4601012489E+00, 5.6172084255E+00, 5.0632871690E-01, 4.3330893337E-01, 6.3691020479E-01],
	[1.3680000000E+04, 6.4633094592E+00, 5.6168152526E+00, 5.0691077116E-01, 4.3374725239E-01, 6.3704815266E-01],
	[1.3685000000E+04, 6.4665180896E+00, 5.6164222510E+00, 5.0749328097E-01, 4.3418580010E-01, 6.3718607502E-01],
	[1.3690000000E+04, 6.4697271399E+00, 5.6160294203E+00, 5.0807624651E-01, 4.3462457642E-01, 6.3732397186E-01],
	[1.3695000000E+04, 6.4729366100E+00, 5.6156367606E+00, 5.0866113292E-01, 4.3506465296E-01, 6.3746184315E-01],
	[1.3700000000E+04, 6.4761464998E+00, 5.6152442717E+00, 5.0924887074E-01, 4.3550670920E-01, 6.3759968889E-01],
	[1.3705000000E+04, 6.4793568092E+00, 5.6148519534E+00, 5.0983707235E-01, 4.3594899775E-01, 6.3773750906E-01],
	[1.3710000000E+04, 6.4825675382E+00, 5.6144598055E+00, 5.1042573794E-01, 4.3639151852E-01, 6.3787530364E-01],
	[1.3715000000E+04, 6.4857786866E+00, 5.6140678281E+00, 5.1101486773E-01, 4.3683427146E-01, 6.3801307262E-01],
	[1.3720000000E+04, 6.4889902542E+00, 5.6136760209E+00, 5.1160446189E-01, 4.3727725648E-01, 6.3815081598E-01],
	[1.3725000000E+04, 6.4922022411E+00, 5.6132843837E+00, 5.1219452063E-01, 4.3772047351E-01, 6.3828853371E-01],
	[1.3730000000E+04, 6.4954146472E+00, 5.6128929166E+00, 5.1278504414E-01, 4.3816392249E-01, 6.3842622580E-01],
	[1.3735000000E+04, 6.4986274722E+00, 5.6125016192E+00, 5.1337603261E-01, 4.3860760333E-01, 6.3856389222E-01],
	[1.3740000000E+04, 6.5018407162E+00, 5.6121104915E+00, 5.1396748626E-01, 4.3905151597E-01, 6.3870153296E-01],
	[1.3745000000E+04, 6.5050543790E+00, 5.6117195334E+00, 5.1455940526E-01, 4.3949566034E-01, 6.3883914801E-01],
	[1.3750000000E+04, 6.5082684606E+00, 5.6113287447E+00, 5.1515178981E-01, 4.3994003635E-01, 6.3897673736E-01],
	[1.3755000000E+04, 6.5114829607E+00, 5.6109381252E+00, 5.1574464012E-01, 4.4038464394E-01, 6.3911430098E-01],
	[1.3760000000E+04, 6.5146978795E+00, 5.6105476749E+00, 5.1633795638E-01, 4.4082948303E-01, 6.3925183886E-01],
	[1.3765000000E+04, 6.5179132166E+00, 5.6101573937E+00, 5.1693173878E-01, 4.4127455355E-01, 6.3938935100E-01],
	[1.3770000000E+04, 6.5211289721E+00, 5.6097672813E+00, 5.1752598753E-01, 4.4171985543E-01, 6.3952683736E-01],
	[1.3775000000E+04, 6.5243451459E+00, 5.6093773376E+00, 5.1812070281E-01, 4.4216538859E-01, 6.3966429794E-01],
	[1.3780000000E+04, 6.5275617378E+00, 5.6089875625E+00, 5.1871588482E-01, 4.4261115295E-01, 6.3980173273E-01],
	[1.3785000000E+04, 6.5307787477E+00, 5.6085979559E+00, 5.1931153376E-01, 4.4305714845E-01, 6.3993914170E-01],
	[1.3790000000E+04, 6.5339961756E+00, 5.6082085177E+00, 5.1990764982E-01, 4.4350337500E-01, 6.4007652485E-01],
	[1.3795000000E+04, 6.5372140213E+00, 5.6078192476E+00, 5.2050423321E-01, 4.4394983254E-01, 6.4021388216E-01],
	[1.3800000000E+04, 6.5404322848E+00, 5.6074301456E+00, 5.2110128412E-01, 4.4439652099E-01, 6.4035121361E-01],
	[1.3805000000E+04, 6.5436509660E+00, 5.6070412116E+00, 5.2169880273E-01, 4.4484344028E-01, 6.4048851919E-01],
	[1.3810000000E+04, 6.5468700647E+00, 5.6066524453E+00, 5.2229678926E-01, 4.4529059032E-01, 6.4062579888E-01],
	[1.3815000000E+04, 6.5500895809E+00, 5.6062638468E+00, 5.2289524390E-01, 4.4573797105E-01, 6.4076305268E-01],
	[1.3820000000E+04, 6.5533095145E+00, 5.6058754157E+00, 5.2349416683E-01, 4.4618558238E-01, 6.4090028056E-01],
	[1.3825000000E+04, 6.5565298653E+00, 5.6054871521E+00, 5.2409355827E-01, 4.4663342425E-01, 6.4103748251E-01],
	[1.3830000000E+04, 6.5597506333E+00, 5.6050990557E+00, 5.2469341840E-01, 4.4708149658E-01, 6.4117465852E-01],
	[1.3835000000E+04, 6.5629718184E+00, 5.6047111265E+00, 5.2529374742E-01, 4.4752979929E-01, 6.4131180857E-01],
	[1.3840000000E+04, 6.5661934205E+00, 5.6043233643E+00, 5.2589454552E-01, 4.4797833230E-01, 6.4144893265E-01],
	[1.3845000000E+04, 6.5694154394E+00, 5.6039357690E+00, 5.2649581291E-01, 4.4842709554E-01, 6.4158603074E-01],
	[1.3850000000E+04, 6.5726378752E+00, 5.6035483404E+00, 5.2709754979E-01, 4.4887608894E-01, 6.4172310283E-01],
	[1.3855000000E+04, 6.5758607276E+00, 5.6031610784E+00, 5.2769975633E-01, 4.4932531242E-01, 6.4186014890E-01],
	[1.3860000000E+04, 6.5790839967E+00, 5.6027739829E+00, 5.2830243275E-01, 4.4977476589E-01, 6.4199716895E-01],
	[1.3865000000E+04, 6.5823076822E+00, 5.6023870537E+00, 5.2890557924E-01, 4.5022444929E-01, 6.4213416295E-01],
	[1.3870000000E+04, 6.5855317841E+00, 5.6020002908E+00, 5.2950919599E-01, 4.5067436253E-01, 6.4227113089E-01],
	[1.3875000000E+04, 6.5887563024E+00, 5.6016136939E+00, 5.3011328321E-01, 4.5112450555E-01, 6.4240807276E-01],
	[1.3880000000E+04, 6.5919812368E+00, 5.6012272630E+00, 5.3071784108E-01, 4.5157487826E-01, 6.4254498855E-01],
	[1.3885000000E+04, 6.5952065874E+00, 5.6008409980E+00, 5.3132286981E-01, 4.5202548058E-01, 6.4268187823E-01],
	[1.3890000000E+04, 6.5984323540E+00, 5.6004548986E+00, 5.3192836959E-01, 4.5247631244E-01, 6.4281874180E-01],
	[1.3895000000E+04, 6.6016585365E+00, 5.6000689648E+00, 5.3253434061E-01, 4.5292737376E-01, 6.4295557923E-01],
	[1.3900000000E+04, 6.6048929629E+00, 5.5996902133E+00, 5.3314078308E-01, 4.5337874735E-01, 6.4309239053E-01],
	[1.3905000000E+04, 6.6081279505E+00, 5.5993117497E+00, 5.3374769719E-01, 4.5383035200E-01, 6.4322917567E-01],
	[1.3910000000E+04, 6.6113633586E+00, 5.5989334476E+00, 5.3435508313E-01, 4.5428218616E-01, 6.4336593463E-01],
	[1.3915000000E+04, 6.6145991872E+00, 5.5985553071E+00, 5.3496294111E-01, 4.5473424974E-01, 6.4350266742E-01],
	[1.3920000000E+04, 6.6178354361E+00, 5.5981773279E+00, 5.3557127131E-01, 4.5518654266E-01, 6.4363937400E-01],
	[1.3925000000E+04, 6.6210721054E+00, 5.5977995100E+00, 5.3618007394E-01, 4.5563906486E-01, 6.4377605437E-01],
	[1.3930000000E+04, 6.6243091948E+00, 5.5974218532E+00, 5.3678934920E-01, 4.5609181625E-01, 6.4391270851E-01],
	[1.3935000000E+04, 6.6275467043E+00, 5.5970443574E+00, 5.3739909727E-01, 4.5654479674E-01, 6.4404933641E-01],
	[1.3940000000E+04, 6.6307846337E+00, 5.5966670225E+00, 5.3800931836E-01, 4.5699800628E-01, 6.4418593806E-01],
	[1.3945000000E+04, 6.6340229831E+00, 5.5962898483E+00, 5.3862001265E-01, 4.5745144476E-01, 6.4432251344E-01],
	[1.3950000000E+04, 6.6372617522E+00, 5.5959128347E+00, 5.3923118036E-01, 4.5790511213E-01, 6.4445906253E-01],
	[1.3955000000E+04, 6.6405009411E+00, 5.5955359816E+00, 5.3984282167E-01, 4.5835900829E-01, 6.4459558533E-01],
	[1.3960000000E+04, 6.6437405495E+00, 5.5951592889E+00, 5.4045493678E-01, 4.5881313317E-01, 6.4473208182E-01],
	[1.3965000000E+04, 6.6469805774E+00, 5.5947827564E+00, 5.4106752589E-01, 4.5926748668E-01, 6.4486855199E-01],
	[1.3970000000E+04, 6.6502210248E+00, 5.5944063841E+00, 5.4168058919E-01, 4.5972206876E-01, 6.4500499582E-01],
	[1.3975000000E+04, 6.6534618915E+00, 5.5940301717E+00, 5.4229412689E-01, 4.6017687932E-01, 6.4514141330E-01],
	[1.3980000000E+04, 6.6567031773E+00, 5.5936541192E+00, 5.4290813917E-01, 4.6063191828E-01, 6.4527780441E-01],
	[1.3985000000E+04, 6.6599448823E+00, 5.5932782264E+00, 5.4352262623E-01, 4.6108718555E-01, 6.4541416915E-01],
	[1.3990000000E+04, 6.6631870064E+00, 5.5929024933E+00, 5.4413758828E-01, 4.6154268107E-01, 6.4555050750E-01],
	[1.3995000000E+04, 6.6664295493E+00, 5.5925269196E+00, 5.4475302550E-01, 4.6199840475E-01, 6.4568681944E-01],
	[1.4000000000E+04, 6.6696725111E+00, 5.5921515053E+00, 5.4536893809E-01, 4.6245435651E-01, 6.4582310496E-01],
	[1.4005000000E+04, 6.6729158916E+00, 5.5917762502E+00, 5.4598532626E-01, 4.6291053627E-01, 6.4595936405E-01],
	[1.4010000000E+04, 6.6761596908E+00, 5.5914011543E+00, 5.4660219019E-01, 4.6336694395E-01, 6.4609559670E-01],
	[1.4015000000E+04, 6.6794039085E+00, 5.5910262173E+00, 5.4721953008E-01, 4.6382357946E-01, 6.4623180289E-01],
	[1.4020000000E+04, 6.6826485446E+00, 5.5906514392E+00, 5.4783734614E-01, 4.6428044273E-01, 6.4636798260E-01],
	[1.4025000000E+04, 6.6858935992E+00, 5.5902768199E+00, 5.4845563855E-01, 4.6473753368E-01, 6.4650413583E-01],
	[1.4030000000E+04, 6.6891390719E+00, 5.5899023592E+00, 5.4907440752E-01, 4.6519485223E-01, 6.4664026257E-01],
	[1.4035000000E+04, 6.6923849629E+00, 5.5895280570E+00, 5.4969365324E-01, 4.6565239828E-01, 6.4677636279E-01],
	[1.4040000000E+04, 6.6956312719E+00, 5.5891539131E+00, 5.5031337590E-01, 4.6611017177E-01, 6.4691243648E-01],
	[1.4045000000E+04, 6.6988779989E+00, 5.5887799275E+00, 5.5093357570E-01, 4.6656817261E-01, 6.4704848364E-01],
	[1.4050000000E+04, 6.7021251438E+00, 5.5884061000E+00, 5.5155425285E-01, 4.6702640072E-01, 6.4718450425E-01],
	[1.4055000000E+04, 6.7053727064E+00, 5.5880324305E+00, 5.5217540753E-01, 4.6748485602E-01, 6.4732049829E-01],
	[1.4060000000E+04, 6.7086206867E+00, 5.5876589189E+00, 5.5279703995E-01, 4.6794353842E-01, 6.4745646575E-01],
	[1.4065000000E+04, 6.7118690847E+00, 5.5872855651E+00, 5.5341915030E-01, 4.6840244784E-01, 6.4759240663E-01],
	[1.4070000000E+04, 6.7151179001E+00, 5.5869123689E+00, 5.5404173878E-01, 4.6886158420E-01, 6.4772832090E-01],
	[1.4075000000E+04, 6.7183671330E+00, 5.5865393302E+00, 5.5466480557E-01, 4.6932094742E-01, 6.4786420855E-01],
	[1.4080000000E+04, 6.7216167831E+00, 5.5861664489E+00, 5.5528835089E-01, 4.6978053742E-01, 6.4800006958E-01],
	[1.4085000000E+04, 6.7248668505E+00, 5.5857937248E+00, 5.5591237493E-01, 4.7024035411E-01, 6.4813590393E-01],
	[1.4090000000E+04, 6.7281173350E+00, 5.5854211579E+00, 5.5653687788E-01, 4.7070039740E-01, 6.4827171158E-01],
	[1.4095000000E+04, 6.7313682365E+00, 5.5850487481E+00, 5.5716185995E-01, 4.7116066723E-01, 6.4840749250E-01],
	[1.4100000000E+04, 6.7346195550E+00, 5.5846764951E+00, 5.5778732132E-01, 4.7162116349E-01, 6.4854324668E-01],
	[1.4105000000E+04, 6.7378712903E+00, 5.5843043989E+00, 5.5841326219E-01, 4.7208188612E-01, 6.4867897409E-01],
	[1.4110000000E+04, 6.7411234423E+00, 5.5839324594E+00, 5.5903968277E-01, 4.7254283502E-01, 6.4881467471E-01],
	[1.4115000000E+04, 6.7443760110E+00, 5.5835606764E+00, 5.5966658325E-01, 4.7300401011E-01, 6.4895034853E-01],
	[1.4120000000E+04, 6.7476310440E+00, 5.5831907566E+00, 5.6029396382E-01, 4.7346543366E-01, 6.4908599553E-01],
	[1.4125000000E+04, 6.7508928422E+00, 5.5828262803E+00, 5.6092182468E-01, 4.7392715271E-01, 6.4922161569E-01],
	[1.4130000000E+04, 6.7541550620E+00, 5.5824619568E+00, 5.6155016603E-01, 4.7438909798E-01, 6.4935720898E-01],
	[1.4135000000E+04, 6.7574177032E+00, 5.5820977859E+00, 5.6217898807E-01, 4.7485126940E-01, 6.4949277540E-01],
	[1.4140000000E+04, 6.7606807657E+00, 5.5817337676E+00, 5.6280829100E-01, 4.7531366689E-01, 6.4962831491E-01],
	[1.4145000000E+04, 6.7639442493E+00, 5.5813699017E+00, 5.6343807500E-01, 4.7577629036E-01, 6.4976382751E-01],
	[1.4150000000E+04, 6.7672081542E+00, 5.5810061881E+00, 5.6406834028E-01, 4.7623913972E-01, 6.4989931317E-01],
	[1.4155000000E+04, 6.7704724800E+00, 5.5806426266E+00, 5.6469908703E-01, 4.7670221489E-01, 6.5003477188E-01],
	[1.4160000000E+04, 6.7737372268E+00, 5.5802792173E+00, 5.6533031545E-01, 4.7716551579E-01, 6.5017020361E-01],
	[1.4165000000E+04, 6.7770023944E+00, 5.5799159599E+00, 5.6596202574E-01, 4.7762904234E-01, 6.5030560835E-01],
	[1.4170000000E+04, 6.7802679827E+00, 5.5795528544E+00, 5.6659421810E-01, 4.7809279444E-01, 6.5044098608E-01],
	[1.4175000000E+04, 6.7835339917E+00, 5.5791899005E+00, 5.6722689271E-01, 4.7855677201E-01, 6.5057633678E-01],
	[1.4180000000E+04, 6.7868004213E+00, 5.5788270983E+00, 5.6786004979E-01, 4.7902097497E-01, 6.5071166043E-01],
	[1.4185000000E+04, 6.7900672713E+00, 5.5784644475E+00, 5.6849368952E-01, 4.7948540323E-01, 6.5084695701E-01],
	[1.4190000000E+04, 6.7933345417E+00, 5.5781019481E+00, 5.6912781210E-01, 4.7995005671E-01, 6.5098222650E-01],
	[1.4195000000E+04, 6.7966022323E+00, 5.5777396000E+00, 5.6976241774E-01, 4.8041493532E-01, 6.5111746889E-01],
	[1.4200000000E+04, 6.7998703432E+00, 5.5773774030E+00, 5.7039750662E-01, 4.8088003898E-01, 6.5125268416E-01],
	[1.4205000000E+04, 6.8031388741E+00, 5.5770153570E+00, 5.7103307894E-01, 4.8134536759E-01, 6.5138787229E-01],
	[1.4210000000E+04, 6.8064078250E+00, 5.5766534620E+00, 5.7166913490E-01, 4.8181092108E-01, 6.5152303325E-01],
	[1.4215000000E+04, 6.8096771958E+00, 5.5762917177E+00, 5.7230567471E-01, 4.8227669936E-01, 6.5165816704E-01],
	[1.4220000000E+04, 6.8129469864E+00, 5.5759301241E+00, 5.7294269854E-01, 4.8274270234E-01, 6.5179327363E-01],
	[1.4225000000E+04, 6.8162171967E+00, 5.5755686810E+00, 5.7358020661E-01, 4.8320892993E-01, 6.5192835300E-01],
	[1.4230000000E+04, 6.8194878266E+00, 5.5752073884E+00, 5.7421819911E-01, 4.8367538205E-01, 6.5206340514E-01],
	[1.4235000000E+04, 6.8227588760E+00, 5.5748462461E+00, 5.7485667623E-01, 4.8414205861E-01, 6.5219843003E-01],
	[1.4240000000E+04, 6.8260303449E+00, 5.5744852540E+00, 5.7549563818E-01, 4.8460895952E-01, 6.5233342765E-01],
	[1.4245000000E+04, 6.8293022331E+00, 5.5741244120E+00, 5.7613508515E-01, 4.8507608470E-01, 6.5246839798E-01],
	[1.4250000000E+04, 6.8325745405E+00, 5.5737637200E+00, 5.7677501733E-01, 4.8554343406E-01, 6.5260334100E-01],
	[1.4255000000E+04, 6.8358472671E+00, 5.5734031778E+00, 5.7741543493E-01, 4.8601100752E-01, 6.5273825670E-01],
	[1.4260000000E+04, 6.8391204128E+00, 5.5730427854E+00, 5.7805633814E-01, 4.8647880498E-01, 6.5287314505E-01],
	[1.4265000000E+04, 6.8423939774E+00, 5.5726825427E+00, 5.7869772717E-01, 4.8694682636E-01, 6.5300800605E-01],
	[1.4270000000E+04, 6.8456679608E+00, 5.5723224494E+00, 5.7933960219E-01, 4.8741507157E-01, 6.5314283967E-01],
	[1.4275000000E+04, 6.8489423631E+00, 5.5719625056E+00, 5.7998196342E-01, 4.8788354052E-01, 6.5327764589E-01],
	[1.4280000000E+04, 6.8522171840E+00, 5.5716027110E+00, 5.8062481105E-01, 4.8835223312E-01, 6.5341242469E-01],
	[1.4285000000E+04, 6.8554924235E+00, 5.5712430656E+00, 5.8126814528E-01, 4.8882114929E-01, 6.5354717607E-01],
	[1.4290000000E+04, 6.8587680815E+00, 5.5708835693E+00, 5.8191196631E-01, 4.8929028894E-01, 6.5368189999E-01],
	[1.4295000000E+04, 6.8620441579E+00, 5.5705242220E+00, 5.8255627432E-01, 4.8975965197E-01, 6.5381659645E-01],
	[1.4300000000E+04, 6.8653206527E+00, 5.5701650234E+00, 5.8320106953E-01, 4.9022923831E-01, 6.5395126542E-01],
	[1.4305000000E+04, 6.8685975656E+00, 5.5698059736E+00, 5.8384635212E-01, 4.9069904786E-01, 6.5408590688E-01],
	[1.4310000000E+04, 6.8718748967E+00, 5.5694470724E+00, 5.8449212229E-01, 4.9116908053E-01, 6.5422052083E-01],
	[1.4315000000E+04, 6.8751526457E+00, 5.5690883197E+00, 5.8513838025E-01, 4.9163933624E-01, 6.5435510723E-01],
	[1.4320000000E+04, 6.8784308128E+00, 5.5687297154E+00, 5.8578512619E-01, 4.9210981489E-01, 6.5448966608E-01],
	[1.4325000000E+04, 6.8817093976E+00, 5.5683712594E+00, 5.8643236030E-01, 4.9258051639E-01, 6.5462419736E-01],
	[1.4330000000E+04, 6.8849884003E+00, 5.5680129515E+00, 5.8708008278E-01, 4.9305144066E-01, 6.5475870104E-01],
	[1.4335000000E+04, 6.8882678205E+00, 5.5676547916E+00, 5.8772829384E-01, 4.9352258761E-01, 6.5489317711E-01],
	[1.4340000000E+04, 6.8915476584E+00, 5.5672967797E+00, 5.8837699366E-01, 4.9399395714E-01, 6.5502762556E-01],
	[1.4345000000E+04, 6.8948279137E+00, 5.5669389156E+00, 5.8902618245E-01, 4.9446554917E-01, 6.5516204636E-01],
	[1.4350000000E+04, 6.8981155182E+00, 5.5665865791E+00, 5.8967586040E-01, 4.9493744182E-01, 6.5529643950E-01],
	[1.4355000000E+04, 6.9014054396E+00, 5.5662358579E+00, 5.9032602771E-01, 4.9540957845E-01, 6.5543080497E-01],
	[1.4360000000E+04, 6.9046957834E+00, 5.5658852810E+00, 5.9097668458E-01, 4.9588193761E-01, 6.5556514273E-01],
	[1.4365000000E+04, 6.9079865497E+00, 5.5655348481E+00, 5.9162783120E-01, 4.9635451921E-01, 6.5569945278E-01],
	[1.4370000000E+04, 6.9112777383E+00, 5.5651845592E+00, 5.9227946777E-01, 4.9682732317E-01, 6.5583373510E-01],
	[1.4375000000E+04, 6.9145693491E+00, 5.5648344143E+00, 5.9293159450E-01, 4.9730034939E-01, 6.5596798967E-01],
	[1.4380000000E+04, 6.9178613822E+00, 5.5644844131E+00, 5.9358421157E-01, 4.9777359779E-01, 6.5610221648E-01],
	[1.4385000000E+04, 6.9211538372E+00, 5.5641345556E+00, 5.9423731918E-01, 4.9824706828E-01, 6.5623641550E-01],
	[1.4390000000E+04, 6.9244467143E+00, 5.5637848417E+00, 5.9489091754E-01, 4.9872076075E-01, 6.5637058673E-01],
	[1.4395000000E+04, 6.9277400132E+00, 5.5634352712E+00, 5.9554500683E-01, 4.9919467513E-01, 6.5650473013E-01],
	[1.4400000000E+04, 6.9310337340E+00, 5.5630858441E+00, 5.9619958726E-01, 4.9966881132E-01, 6.5663884571E-01],
	[1.4405000000E+04, 6.9343278764E+00, 5.5627365602E+00, 5.9685465903E-01, 5.0014316923E-01, 6.5677293343E-01],
	[1.4410000000E+04, 6.9376224404E+00, 5.5623874195E+00, 5.9751022232E-01, 5.0061774877E-01, 6.5690699328E-01],
	[1.4415000000E+04, 6.9409174259E+00, 5.5620384218E+00, 5.9816627735E-01, 5.0109254985E-01, 6.5704102525E-01],
	[1.4420000000E+04, 6.9442128329E+00, 5.5616895670E+00, 5.9882282430E-01, 5.0156757237E-01, 6.5717502932E-01],
	[1.4425000000E+04, 6.9475086612E+00, 5.5613408550E+00, 5.9947986338E-01, 5.0204281625E-01, 6.5730900546E-01],
	[1.4430000000E+04, 6.9508049107E+00, 5.5609922857E+00, 6.0013739477E-01, 5.0251828139E-01, 6.5744295367E-01],
	[1.4435000000E+04, 6.9541015813E+00, 5.5606438590E+00, 6.0079541869E-01, 5.0299396770E-01, 6.5757687393E-01],
	[1.4440000000E+04, 6.9573986730E+00, 5.5602955748E+00, 6.0145393532E-01, 5.0346987509E-01, 6.5771076622E-01],
	[1.4445000000E+04, 6.9606961857E+00, 5.5599474330E+00, 6.0211294486E-01, 5.0394600347E-01, 6.5784463053E-01],
	[1.4450000000E+04, 6.9639941192E+00, 5.5595994335E+00, 6.0277244752E-01, 5.0442235274E-01, 6.5797846683E-01],
	[1.4455000000E+04, 6.9672924735E+00, 5.5592515761E+00, 6.0343244349E-01, 5.0489892281E-01, 6.5811227511E-01],
	[1.4460000000E+04, 6.9705912485E+00, 5.5589038607E+00, 6.0409293296E-01, 5.0537571360E-01, 6.5824605535E-01],
	[1.4465000000E+04, 6.9738904440E+00, 5.5585562874E+00, 6.0475391614E-01, 5.0585272499E-01, 6.5837980754E-01],
	[1.4470000000E+04, 6.9771900601E+00, 5.5582088558E+00, 6.0541539322E-01, 5.0632995691E-01, 6.5851353167E-01],
	[1.4475000000E+04, 6.9804900966E+00, 5.5578615660E+00, 6.0607736440E-01, 5.0680740926E-01, 6.5864722770E-01],
	[1.4480000000E+04, 6.9837905533E+00, 5.5575144179E+00, 6.0673982987E-01, 5.0728508195E-01, 6.5878089563E-01],
	[1.4485000000E+04, 6.9870914303E+00, 5.5571674112E+00, 6.0740278984E-01, 5.0776297488E-01, 6.5891453545E-01],
	[1.4490000000E+04, 6.9903927275E+00, 5.5568205460E+00, 6.0806624450E-01, 5.0824108796E-01, 6.5904814713E-01],
	[1.4495000000E+04, 6.9936944446E+00, 5.5564738221E+00, 6.0873019405E-01, 5.0871942110E-01, 6.5918173066E-01],
	[1.4500000000E+04, 6.9969965818E+00, 5.5561272394E+00, 6.0939463869E-01, 5.0919797420E-01, 6.5931528602E-01],
	[1.4505000000E+04, 7.0002991387E+00, 5.5557807977E+00, 6.1005957862E-01, 5.0967674716E-01, 6.5944881319E-01],
	[1.4510000000E+04, 7.0036021155E+00, 5.5554344971E+00, 6.1072501403E-01, 5.1015573990E-01, 6.5958231216E-01],
	[1.4515000000E+04, 7.0069055119E+00, 5.5550883374E+00, 6.1139094511E-01, 5.1063495233E-01, 6.5971578292E-01],
	[1.4520000000E+04, 7.0102093279E+00, 5.5547423184E+00, 6.1205737208E-01, 5.1111438433E-01, 6.5984922544E-01],
	[1.4525000000E+04, 7.0135135634E+00, 5.5543964401E+00, 6.1272429512E-01, 5.1159403583E-01, 6.5998263972E-01],
	[1.4530000000E+04, 7.0168182183E+00, 5.5540507024E+00, 6.1339171444E-01, 5.1207390673E-01, 6.6011602573E-01],
	[1.4535000000E+04, 7.0201232925E+00, 5.5537051051E+00, 6.1405963023E-01, 5.1255399693E-01, 6.6024938345E-01],
	[1.4540000000E+04, 7.0234287859E+00, 5.5533596482E+00, 6.1472804268E-01, 5.1303430633E-01, 6.6038271288E-01],
	[1.4545000000E+04, 7.0267346984E+00, 5.5530143316E+00, 6.1539695201E-01, 5.1351483485E-01, 6.6051601399E-01],
	[1.4550000000E+04, 7.0300410300E+00, 5.5526691551E+00, 6.1606635839E-01, 5.1399558238E-01, 6.6064928678E-01],
	[1.4555000000E+04, 7.0333477805E+00, 5.5523241186E+00, 6.1673626204E-01, 5.1447654884E-01, 6.6078253122E-01],
	[1.4560000000E+04, 7.0366549499E+00, 5.5519792221E+00, 6.1740666315E-01, 5.1495773412E-01, 6.6091574729E-01],
	[1.4565000000E+04, 7.0399625381E+00, 5.5516344654E+00, 6.1807756192E-01, 5.1543913813E-01, 6.6104893499E-01],
	[1.4570000000E+04, 7.0432705449E+00, 5.5512898485E+00, 6.1874895855E-01, 5.1592076078E-01, 6.6118209429E-01],
	[1.4575000000E+04, 7.0465789703E+00, 5.5509453711E+00, 6.1942085322E-01, 5.1640260196E-01, 6.6131522519E-01],
	[1.4580000000E+04, 7.0498933247E+00, 5.5506050247E+00, 6.2009324615E-01, 5.1688472583E-01, 6.6144832766E-01],
	[1.4585000000E+04, 7.0532118545E+00, 5.5502675333E+00, 6.2076613753E-01, 5.1736711204E-01, 6.6158140168E-01],
	[1.4590000000E+04, 7.0565308081E+00, 5.5499301781E+00, 6.2143952756E-01, 5.1784971683E-01, 6.6171444726E-01],
	[1.4595000000E+04, 7.0598501856E+00, 5.5495929590E+00, 6.2211341643E-01, 5.1833254010E-01, 6.6184746435E-01],
	[1.4600000000E+04, 7.0631699866E+00, 5.5492558758E+00, 6.2278780434E-01, 5.1881558176E-01, 6.6198045296E-01],
	[1.4605000000E+04, 7.0664902113E+00, 5.5489189286E+00, 6.2346269149E-01, 5.1929884170E-01, 6.6211341307E-01],
	[1.4610000000E+04, 7.0698108594E+00, 5.5485821171E+00, 6.2413807809E-01, 5.1978231984E-01, 6.6224634465E-01],
	[1.4615000000E+04, 7.0731319309E+00, 5.5482454413E+00, 6.2481396431E-01, 5.2026601608E-01, 6.6237924770E-01],
	[1.4620000000E+04, 7.0764534257E+00, 5.5479089011E+00, 6.2549035038E-01, 5.2074993031E-01, 6.6251212220E-01],
	[1.4625000000E+04, 7.0797753436E+00, 5.5475724964E+00, 6.2616723647E-01, 5.2123406245E-01, 6.6264496813E-01],
	[1.4630000000E+04, 7.0830976848E+00, 5.5472362270E+00, 6.2684462280E-01, 5.2171841239E-01, 6.6277778548E-01],
	[1.4635000000E+04, 7.0864204489E+00, 5.5469000929E+00, 6.2752250955E-01, 5.2220298005E-01, 6.6291057424E-01],
	[1.4640000000E+04, 7.0897436359E+00, 5.5465640940E+00, 6.2820089693E-01, 5.2268776531E-01, 6.6304333438E-01],
	[1.4645000000E+04, 7.0930672458E+00, 5.5462282302E+00, 6.2887978513E-01, 5.2317276809E-01, 6.6317606589E-01],
	[1.4650000000E+04, 7.0963912785E+00, 5.5458925014E+00, 6.2955917436E-01, 5.2365798829E-01, 6.6330876876E-01],
	[1.4655000000E+04, 7.0997157338E+00, 5.5455569074E+00, 6.3023906480E-01, 5.2414342580E-01, 6.6344144297E-01],
	[1.4660000000E+04, 7.1030406117E+00, 5.5452214482E+00, 6.3091945666E-01, 5.2462908054E-01, 6.6357408850E-01],
	[1.4665000000E+04, 7.1063659120E+00, 5.5448861237E+00, 6.3160035014E-01, 5.2511495240E-01, 6.6370670535E-01],
	[1.4670000000E+04, 7.1096916348E+00, 5.5445509337E+00, 6.3228174543E-01, 5.2560104129E-01, 6.6383929349E-01],
	[1.4675000000E+04, 7.1130177798E+00, 5.5442158783E+00, 6.3296364274E-01, 5.2608734711E-01, 6.6397185291E-01],
	[1.4680000000E+04, 7.1163443471E+00, 5.5438809572E+00, 6.3364604225E-01, 5.2657386976E-01, 6.6410438360E-01],
	[1.4685000000E+04, 7.1196713364E+00, 5.5435461704E+00, 6.3432894417E-01, 5.2706060913E-01, 6.6423688553E-01],
	[1.4690000000E+04, 7.1229987478E+00, 5.5432115177E+00, 6.3501234870E-01, 5.2754756514E-01, 6.6436935871E-01],
	[1.4695000000E+04, 7.1263265812E+00, 5.5428769992E+00, 6.3569625603E-01, 5.2803473769E-01, 6.6450180310E-01],
	[1.4700000000E+04, 7.1296548363E+00, 5.5425426146E+00, 6.3638066636E-01, 5.2852212667E-01, 6.6463421869E-01],
	[1.4705000000E+04, 7.1329835133E+00, 5.5422083639E+00, 6.3706557990E-01, 5.2900973198E-01, 6.6476660548E-01],
	[1.4710000000E+04, 7.1363126119E+00, 5.5418742470E+00, 6.3775099683E-01, 5.2949755354E-01, 6.6489896344E-01],
	[1.4715000000E+04, 7.1396421321E+00, 5.5415402637E+00, 6.3843691736E-01, 5.2998559123E-01, 6.6503129256E-01],
	[1.4720000000E+04, 7.1429720737E+00, 5.5412064141E+00, 6.3912334168E-01, 5.3047384496E-01, 6.6516359283E-01],
	[1.4725000000E+04, 7.1463024368E+00, 5.5408726979E+00, 6.3981026999E-01, 5.3096231463E-01, 6.6529586422E-01],
	[1.4730000000E+04, 7.1496332212E+00, 5.5405391151E+00, 6.4049770250E-01, 5.3145100014E-01, 6.6542810673E-01],
	[1.4735000000E+04, 7.1529644268E+00, 5.5402056656E+00, 6.4118563939E-01, 5.3193990139E-01, 6.6556032035E-01],
	[1.4740000000E+04, 7.1562960535E+00, 5.5398723493E+00, 6.4187408087E-01, 5.3242901828E-01, 6.6569250505E-01],
	[1.4745000000E+04, 7.1596281012E+00, 5.5395391660E+00, 6.4256302714E-01, 5.3291835071E-01, 6.6582466081E-01],
	[1.4750000000E+04, 7.1629605699E+00, 5.5392061158E+00, 6.4325247839E-01, 5.3340789859E-01, 6.6595678764E-01],
	[1.4755000000E+04, 7.1662934595E+00, 5.5388731984E+00, 6.4394243482E-01, 5.3389766180E-01, 6.6608888551E-01],
	[1.4760000000E+04, 7.1696267698E+00, 5.5385404139E+00, 6.4463289663E-01, 5.3438764025E-01, 6.6622095440E-01],
	[1.4765000000E+04, 7.1729605008E+00, 5.5382077620E+00, 6.4532386401E-01, 5.3487783384E-01, 6.6635299431E-01],
	[1.4770000000E+04, 7.1762946525E+00, 5.5378752428E+00, 6.4601533718E-01, 5.3536824246E-01, 6.6648500521E-01],
	[1.4775000000E+04, 7.1796292246E+00, 5.5375428560E+00, 6.4670731631E-01, 5.3585886603E-01, 6.6661698710E-01],
	[1.4780000000E+04, 7.1829642171E+00, 5.5372106017E+00, 6.4739980162E-01, 5.3634970443E-01, 6.6674893996E-01],
	[1.4785000000E+04, 7.1862996299E+00, 5.5368784796E+00, 6.4809279330E-01, 5.3684075757E-01, 6.6688086377E-01],
	[1.4790000000E+04, 7.1896354630E+00, 5.5365464898E+00, 6.4878629155E-01, 5.3733202534E-01, 6.6701275853E-01],
	[1.4795000000E+04, 7.1929717162E+00, 5.5362146321E+00, 6.4948029657E-01, 5.3782350764E-01, 6.6714462421E-01],
	[1.4800000000E+04, 7.1963083895E+00, 5.5358829064E+00, 6.5017480855E-01, 5.3831520438E-01, 6.6727646080E-01],
	[1.4805000000E+04, 7.1996454827E+00, 5.5355513126E+00, 6.5086982769E-01, 5.3880711544E-01, 6.6740826828E-01],
	[1.4810000000E+04, 7.2029829958E+00, 5.5352198506E+00, 6.5156535420E-01, 5.3929924073E-01, 6.6754004665E-01],
	[1.4815000000E+04, 7.2063273427E+00, 5.5348928629E+00, 6.5226138827E-01, 5.3979165744E-01, 6.6767179589E-01],
	[1.4820000000E+04, 7.2096754060E+00, 5.5345682332E+00, 6.5295793009E-01, 5.4028432813E-01, 6.6780351598E-01],
	[1.4825000000E+04, 7.2130238945E+00, 5.5342437320E+00, 6.5365497988E-01, 5.4077721309E-01, 6.6793520692E-01],
	[1.4830000000E+04, 7.2163728083E+00, 5.5339193592E+00, 6.5435253781E-01, 5.4127031221E-01, 6.6806686868E-01],
	[1.4835000000E+04, 7.2197221473E+00, 5.5335951148E+00, 6.5505060410E-01, 5.4176362539E-01, 6.6819850125E-01],
	[1.4840000000E+04, 7.2230719114E+00, 5.5332709986E+00, 6.5574917895E-01, 5.4225715253E-01, 6.6833010462E-01],
	[1.4845000000E+04, 7.2264221004E+00, 5.5329470106E+00, 6.5644826254E-01, 5.4275089354E-01, 6.6846167877E-01],
	[1.4850000000E+04, 7.2297727143E+00, 5.5326231506E+00, 6.5714785508E-01, 5.4324484830E-01, 6.6859322369E-01],
	[1.4855000000E+04, 7.2331237530E+00, 5.5322994187E+00, 6.5784795677E-01, 5.4373901671E-01, 6.6872473937E-01],
	[1.4860000000E+04, 7.2364752165E+00, 5.5319758146E+00, 6.5854856780E-01, 5.4423339868E-01, 6.6885622579E-01],
	[1.4865000000E+04, 7.2398271045E+00, 5.5316523382E+00, 6.5924968838E-01, 5.4472799409E-01, 6.6898768294E-01],
	[1.4870000000E+04, 7.2431794171E+00, 5.5313289896E+00, 6.5995131870E-01, 5.4522280286E-01, 6.6911911080E-01],
	[1.4875000000E+04, 7.2465321542E+00, 5.5310057686E+00, 6.6065345896E-01, 5.4571782486E-01, 6.6925050936E-01],
	[1.4880000000E+04, 7.2498853156E+00, 5.5306826751E+00, 6.6135610936E-01, 5.4621306001E-01, 6.6938187861E-01],
	[1.4885000000E+04, 7.2532389013E+00, 5.5303597090E+00, 6.6205927009E-01, 5.4670850819E-01, 6.6951321853E-01],
	[1.4890000000E+04, 7.2565929111E+00, 5.5300368702E+00, 6.6276294136E-01, 5.4720416930E-01, 6.6964452911E-01],
	[1.4895000000E+04, 7.2599473451E+00, 5.5297141586E+00, 6.6346712337E-01, 5.4770004325E-01, 6.6977581033E-01],
	[1.4900000000E+04, 7.2633022030E+00, 5.5293915742E+00, 6.6417181631E-01, 5.4819612992E-01, 6.6990706219E-01],
	[1.4905000000E+04, 7.2666574849E+00, 5.5290691168E+00, 6.6487702038E-01, 5.4869242922E-01, 6.7003828466E-01],
	[1.4910000000E+04, 7.2700131906E+00, 5.5287467864E+00, 6.6558273578E-01, 5.4918894103E-01, 6.7016947774E-01],
	[1.4915000000E+04, 7.2733693200E+00, 5.5284245828E+00, 6.6628896270E-01, 5.4968566526E-01, 6.7030064141E-01],
	[1.4920000000E+04, 7.2767258731E+00, 5.5281025060E+00, 6.6699570136E-01, 5.5018260180E-01, 6.7043177565E-01],
	[1.4925000000E+04, 7.2800828497E+00, 5.5277805559E+00, 6.6770295194E-01, 5.5067975055E-01, 6.7056288046E-01],
	[1.4930000000E+04, 7.2834402498E+00, 5.5274587323E+00, 6.6841071464E-01, 5.5117711140E-01, 6.7069395581E-01],
	[1.4935000000E+04, 7.2867980733E+00, 5.5271370352E+00, 6.6911898966E-01, 5.5167468425E-01, 6.7082500171E-01],
	[1.4940000000E+04, 7.2901563201E+00, 5.5268154645E+00, 6.6982777721E-01, 5.5217246899E-01, 6.7095601812E-01],
	[1.4945000000E+04, 7.2935149901E+00, 5.5264940201E+00, 6.7053707747E-01, 5.5267046552E-01, 6.7108700505E-01],
	[1.4950000000E+04, 7.2968740832E+00, 5.5261727020E+00, 6.7124689066E-01, 5.5316867373E-01, 6.7121796247E-01],
	[1.4955000000E+04, 7.3002335993E+00, 5.5258515099E+00, 6.7195721695E-01, 5.5366709352E-01, 6.7134889037E-01],
	[1.4960000000E+04, 7.3035935384E+00, 5.5255304439E+00, 6.7266805657E-01, 5.5416572478E-01, 6.7147978874E-01],
	[1.4965000000E+04, 7.3069539003E+00, 5.5252095038E+00, 6.7337940970E-01, 5.5466456742E-01, 6.7161065757E-01],
	[1.4970000000E+04, 7.3103146850E+00, 5.5248886895E+00, 6.7409127654E-01, 5.5516362131E-01, 6.7174149685E-01],
	[1.4975000000E+04, 7.3136758924E+00, 5.5245680010E+00, 6.7480365729E-01, 5.5566288636E-01, 6.7187230655E-01],
	[1.4980000000E+04, 7.3170375223E+00, 5.5242474382E+00, 6.7551655215E-01, 5.5616236246E-01, 6.7200308666E-01],
	[1.4985000000E+04, 7.3203995748E+00, 5.5239270009E+00, 6.7622996131E-01, 5.5666204951E-01, 6.7213383718E-01],
	[1.4990000000E+04, 7.3237620497E+00, 5.5236066892E+00, 6.7694388499E-01, 5.5716194740E-01, 6.7226455809E-01],
	[1.4995000000E+04, 7.3271249469E+00, 5.5232865028E+00, 6.7765832337E-01, 5.5766205602E-01, 6.7239524938E-01],
	[1.5000000000E+04, 7.3304882663E+00, 5.5229664417E+00, 6.7837327665E-01, 5.5816237527E-01, 6.7252591103E-01],
	[1.5005000000E+04, 7.3338520079E+00, 5.5226465058E+00, 6.7909090730E-01, 5.5866436841E-01, 6.7265654304E-01],
	[1.5010000000E+04, 7.3372161716E+00, 5.5223266950E+00, 6.7980905716E-01, 5.5916657368E-01, 6.7278714538E-01],
	[1.5015000000E+04, 7.3405807572E+00, 5.5220070093E+00, 6.8052772641E-01, 5.5966899097E-01, 6.7291771804E-01],
	[1.5020000000E+04, 7.3439457647E+00, 5.5216874484E+00, 6.8124691528E-01, 5.6017162018E-01, 6.7304826102E-01],
	[1.5025000000E+04, 7.3473111940E+00, 5.5213680125E+00, 6.8196662396E-01, 5.6067446119E-01, 6.7317877429E-01],
	[1.5030000000E+04, 7.3506770450E+00, 5.5210487013E+00, 6.8268685264E-01, 5.6117751391E-01, 6.7330925786E-01],
	[1.5035000000E+04, 7.3540433177E+00, 5.5207295147E+00, 6.8340760154E-01, 5.6168077821E-01, 6.7343971169E-01],
	[1.5040000000E+04, 7.3574100118E+00, 5.5204104527E+00, 6.8412887086E-01, 5.6218425400E-01, 6.7357013579E-01],
	[1.5045000000E+04, 7.3607771275E+00, 5.5200915152E+00, 6.8485066079E-01, 5.6268794117E-01, 6.7370053013E-01],
	[1.5050000000E+04, 7.3641446645E+00, 5.5197727021E+00, 6.8557297154E-01, 5.6319183961E-01, 6.7383089471E-01],
	[1.5055000000E+04, 7.3675224901E+00, 5.5194602705E+00, 6.8629580332E-01, 5.6369607223E-01, 6.7396122950E-01],
	[1.5060000000E+04, 7.3709010354E+00, 5.5191481458E+00, 6.8701915631E-01, 5.6420051991E-01, 6.7409153449E-01],
	[1.5065000000E+04, 7.3742800076E+00, 5.5188361423E+00, 6.8774303074E-01, 5.6470517890E-01, 6.7422180964E-01],
	[1.5070000000E+04, 7.3776594068E+00, 5.5185242600E+00, 6.8846742679E-01, 5.6521004909E-01, 6.7435205494E-01],
	[1.5075000000E+04, 7.3810392329E+00, 5.5182124988E+00, 6.8919234467E-01, 5.6571513038E-01, 6.7448227038E-01],
	[1.5080000000E+04, 7.3844194857E+00, 5.5179008586E+00, 6.8991778458E-01, 5.6622042264E-01, 6.7461245594E-01],
	[1.5085000000E+04, 7.3878001652E+00, 5.5175893392E+00, 6.9064374673E-01, 5.6672592579E-01, 6.7474261160E-01],
	[1.5090000000E+04, 7.3911812713E+00, 5.5172779407E+00, 6.9137023131E-01, 5.6723163970E-01, 6.7487273734E-01],
	[1.5095000000E+04, 7.3945628039E+00, 5.5169666629E+00, 6.9209723853E-01, 5.6773756427E-01, 6.7500283316E-01],
	[1.5100000000E+04, 7.3979447629E+00, 5.5166555058E+00, 6.9282476859E-01, 5.6824369939E-01, 6.7513289902E-01],
	[1.5105000000E+04, 7.4013271482E+00, 5.5163444692E+00, 6.9355282169E-01, 5.6875004495E-01, 6.7526293492E-01],
	[1.5110000000E+04, 7.4047099598E+00, 5.5160335531E+00, 6.9428139804E-01, 5.6925660085E-01, 6.7539294084E-01],
	[1.5115000000E+04, 7.4080931975E+00, 5.5157227574E+00, 6.9501049783E-01, 5.6976336697E-01, 6.7552291676E-01],
	[1.5120000000E+04, 7.4114768613E+00, 5.5154120819E+00, 6.9574012128E-01, 5.7027034320E-01, 6.7565286267E-01],
	[1.5125000000E+04, 7.4148609511E+00, 5.5151015267E+00, 6.9647026857E-01, 5.7077752943E-01, 6.7578277855E-01],
	[1.5130000000E+04, 7.4182454667E+00, 5.5147910916E+00, 6.9720093992E-01, 5.7128492556E-01, 6.7591266438E-01],
	[1.5135000000E+04, 7.4216304082E+00, 5.5144807765E+00, 6.9793213552E-01, 5.7179253148E-01, 6.7604252015E-01],
	[1.5140000000E+04, 7.4250157754E+00, 5.5141705814E+00, 6.9866385559E-01, 5.7230034707E-01, 6.7617234584E-01],
	[1.5145000000E+04, 7.4284015682E+00, 5.5138605061E+00, 6.9939610031E-01, 5.7280837222E-01, 6.7630214144E-01],
	[1.5150000000E+04, 7.4317877865E+00, 5.5135505507E+00, 7.0012886989E-01, 5.7331660683E-01, 6.7643190692E-01],
	[1.5155000000E+04, 7.4351744303E+00, 5.5132407149E+00, 7.0086216454E-01, 5.7382505079E-01, 6.7656164227E-01],
	[1.5160000000E+04, 7.4385614995E+00, 5.5129309987E+00, 7.0159598446E-01, 5.7433370398E-01, 6.7669134748E-01],
	[1.5165000000E+04, 7.4419489940E+00, 5.5126214021E+00, 7.0233032984E-01, 5.7484256630E-01, 6.7682102254E-01],
	[1.5170000000E+04, 7.4453369136E+00, 5.5123119248E+00, 7.0306520090E-01, 5.7535163762E-01, 6.7695066741E-01],
	[1.5175000000E+04, 7.4487252584E+00, 5.5120025670E+00, 7.0380059783E-01, 5.7586091786E-01, 6.7708028209E-01],
	[1.5180000000E+04, 7.4521140282E+00, 5.5116933284E+00, 7.0453652083E-01, 5.7637040688E-01, 6.7720986657E-01],
	[1.5185000000E+04, 7.4555032229E+00, 5.5113842090E+00, 7.0527297012E-01, 5.7688010459E-01, 6.7733942082E-01],
	[1.5190000000E+04, 7.4588928425E+00, 5.5110752087E+00, 7.0600994588E-01, 5.7739001086E-01, 6.7746894483E-01],
	[1.5195000000E+04, 7.4622828868E+00, 5.5107663274E+00, 7.0674744833E-01, 5.7790012560E-01, 6.7759843859E-01],
	[1.5200000000E+04, 7.4656733558E+00, 5.5104575650E+00, 7.0748547767E-01, 5.7841044868E-01, 6.7772790207E-01],
	[1.5205000000E+04, 7.4690642494E+00, 5.5101489214E+00, 7.0822403409E-01, 5.7892098000E-01, 6.7785733527E-01],
	[1.5210000000E+04, 7.4724555675E+00, 5.5098403966E+00, 7.0896311780E-01, 5.7943171945E-01, 6.7798673816E-01],
	[1.5215000000E+04, 7.4758473100E+00, 5.5095319905E+00, 7.0970272900E-01, 5.7994266690E-01, 6.7811611074E-01],
	[1.5220000000E+04, 7.4792394768E+00, 5.5092237030E+00, 7.1044286790E-01, 5.8045382226E-01, 6.7824545298E-01],
	[1.5225000000E+04, 7.4826320679E+00, 5.5089155340E+00, 7.1118353470E-01, 5.8096518541E-01, 6.7837476487E-01],
	[1.5230000000E+04, 7.4860250831E+00, 5.5086074834E+00, 7.1192472960E-01, 5.8147675623E-01, 6.7850404639E-01],
	[1.5235000000E+04, 7.4894185224E+00, 5.5082995511E+00, 7.1266645280E-01, 5.8198853462E-01, 6.7863329753E-01],
	[1.5240000000E+04, 7.4928123857E+00, 5.5079917371E+00, 7.1340870450E-01, 5.8250052047E-01, 6.7876251828E-01],
	[1.5245000000E+04, 7.4962066729E+00, 5.5076840412E+00, 7.1415148491E-01, 5.8301271365E-01, 6.7889170861E-01],
	[1.5250000000E+04, 7.4996013839E+00, 5.5073764635E+00, 7.1489479423E-01, 5.8352511406E-01, 6.7902086852E-01],
	[1.5255000000E+04, 7.5029965187E+00, 5.5070690037E+00, 7.1563863267E-01, 5.8403772159E-01, 6.7914999798E-01],
	[1.5260000000E+04, 7.5063920770E+00, 5.5067616618E+00, 7.1638300041E-01, 5.8455053611E-01, 6.7927909699E-01],
	[1.5265000000E+04, 7.5097880589E+00, 5.5064544378E+00, 7.1712789768E-01, 5.8506355753E-01, 6.7940816552E-01],
	[1.5270000000E+04, 7.5131844643E+00, 5.5061473315E+00, 7.1787332466E-01, 5.8557678572E-01, 6.7953720356E-01],
	[1.5275000000E+04, 7.5165812931E+00, 5.5058403428E+00, 7.1861928157E-01, 5.8609022058E-01, 6.7966621109E-01],
	[1.5280000000E+04, 7.5199785452E+00, 5.5055334718E+00, 7.1936576860E-01, 5.8660386199E-01, 6.7979518811E-01],
	[1.5285000000E+04, 7.5233762204E+00, 5.5052267182E+00, 7.2011278596E-01, 5.8711770983E-01, 6.7992413459E-01],
	[1.5290000000E+04, 7.5267743188E+00, 5.5049200821E+00, 7.2086033384E-01, 5.8763176399E-01, 6.8005305052E-01],
	[1.5295000000E+04, 7.5301783016E+00, 5.5046168170E+00, 7.2160841246E-01, 5.8814609483E-01, 6.8018193588E-01],
	[1.5300000000E+04, 7.5335878791E+00, 5.5043167455E+00, 7.2235702202E-01, 5.8866069871E-01, 6.8031079066E-01],
	[1.5305000000E+04, 7.5369978856E+00, 5.5040167884E+00, 7.2310616271E-01, 5.8917550896E-01, 6.8043961485E-01],
	[1.5310000000E+04, 7.5404083210E+00, 5.5037169456E+00, 7.2385583474E-01, 5.8969052547E-01, 6.8056840843E-01],
	[1.5315000000E+04, 7.5438191852E+00, 5.5034172171E+00, 7.2460603832E-01, 5.9020574811E-01, 6.8069717138E-01],
	[1.5320000000E+04, 7.5472304782E+00, 5.5031176027E+00, 7.2535677364E-01, 5.9072117678E-01, 6.8082590369E-01],
	[1.5325000000E+04, 7.5506421998E+00, 5.5028181024E+00, 7.2610804091E-01, 5.9123681136E-01, 6.8095460535E-01],
	[1.5330000000E+04, 7.5540543501E+00, 5.5025187160E+00, 7.2685984033E-01, 5.9175265174E-01, 6.8108327633E-01],
	[1.5335000000E+04, 7.5574669287E+00, 5.5022194436E+00, 7.2761217210E-01, 5.9226869780E-01, 6.8121191663E-01],
	[1.5340000000E+04, 7.5608799358E+00, 5.5019202850E+00, 7.2836503643E-01, 5.9278494943E-01, 6.8134052623E-01],
	[1.5345000000E+04, 7.5642933712E+00, 5.5016212402E+00, 7.2911843351E-01, 5.9330140651E-01, 6.8146910511E-01],
	[1.5350000000E+04, 7.5677072349E+00, 5.5013223090E+00, 7.2987236356E-01, 5.9381806893E-01, 6.8159765326E-01],
	[1.5355000000E+04, 7.5711215266E+00, 5.5010234914E+00, 7.3062682677E-01, 5.9433493658E-01, 6.8172617067E-01],
	[1.5360000000E+04, 7.5745362465E+00, 5.5007247874E+00, 7.3138182335E-01, 5.9485200934E-01, 6.8185465732E-01],
	[1.5365000000E+04, 7.5779513942E+00, 5.5004261967E+00, 7.3213735350E-01, 5.9536928709E-01, 6.8198311319E-01],
	[1.5370000000E+04, 7.5813669699E+00, 5.5001277194E+00, 7.3289341742E-01, 5.9588676972E-01, 6.8211153828E-01],
	[1.5375000000E+04, 7.5847829734E+00, 5.4998293554E+00, 7.3365001531E-01, 5.9640445712E-01, 6.8223993256E-01],
	[1.5380000000E+04, 7.5881994046E+00, 5.4995311046E+00, 7.3440714738E-01, 5.9692234917E-01, 6.8236829603E-01],
	[1.5385000000E+04, 7.5916162634E+00, 5.4992329669E+00, 7.3516481383E-01, 5.9744044576E-01, 6.8249662866E-01],
	[1.5390000000E+04, 7.5950335498E+00, 5.4989349422E+00, 7.3592301487E-01, 5.9795874676E-01, 6.8262493045E-01],
	[1.5395000000E+04, 7.5984512636E+00, 5.4986370305E+00, 7.3668175069E-01, 5.9847725207E-01, 6.8275320137E-01],
	[1.5400000000E+04, 7.6018694048E+00, 5.4983392316E+00, 7.3744102150E-01, 5.9899596157E-01, 6.8288144142E-01],
	[1.5405000000E+04, 7.6052879733E+00, 5.4980415455E+00, 7.3820082750E-01, 5.9951487514E-01, 6.8300965058E-01],
	[1.5410000000E+04, 7.6087069689E+00, 5.4977439722E+00, 7.3896116889E-01, 6.0003399266E-01, 6.8313782884E-01],
	[1.5415000000E+04, 7.6121263917E+00, 5.4974465115E+00, 7.3972204589E-01, 6.0055331402E-01, 6.8326597617E-01],
	[1.5420000000E+04, 7.6155462416E+00, 5.4971491633E+00, 7.4048345868E-01, 6.0107283911E-01, 6.8339409258E-01],
	[1.5425000000E+04, 7.6189665183E+00, 5.4968519276E+00, 7.4124540747E-01, 6.0159256781E-01, 6.8352217803E-01],
	[1.5430000000E+04, 7.6223872220E+00, 5.4965548043E+00, 7.4200789247E-01, 6.0211250000E-01, 6.8365023253E-01],
	[1.5435000000E+04, 7.6258083524E+00, 5.4962577934E+00, 7.4277091388E-01, 6.0263263556E-01, 6.8377825605E-01],
	[1.5440000000E+04, 7.6292299095E+00, 5.4959608946E+00, 7.4353447190E-01, 6.0315297438E-01, 6.8390624858E-01],
	[1.5445000000E+04, 7.6326518932E+00, 5.4956641080E+00, 7.4429856673E-01, 6.0367351634E-01, 6.8403421011E-01],
	[1.5450000000E+04, 7.6360743034E+00, 5.4953674336E+00, 7.4506319858E-01, 6.0419426132E-01, 6.8416214061E-01],
	[1.5455000000E+04, 7.6394971400E+00, 5.4950708711E+00, 7.4582836765E-01, 6.0471520921E-01, 6.8429004009E-01],
	[1.5460000000E+04, 7.6429204030E+00, 5.4947744205E+00, 7.4659407414E-01, 6.0523635989E-01, 6.8441790852E-01],
	[1.5465000000E+04, 7.6463440923E+00, 5.4944780818E+00, 7.4736031826E-01, 6.0575771325E-01, 6.8454574589E-01],
	[1.5470000000E+04, 7.6497682078E+00, 5.4941818548E+00, 7.4812710021E-01, 6.0627926916E-01, 6.8467355219E-01],
	[1.5475000000E+04, 7.6531927493E+00, 5.4938857396E+00, 7.4889442019E-01, 6.0680102750E-01, 6.8480132740E-01],
	[1.5480000000E+04, 7.6566177169E+00, 5.4935897359E+00, 7.4966227840E-01, 6.0732298817E-01, 6.8492907151E-01],
	[1.5485000000E+04, 7.6600431104E+00, 5.4932938438E+00, 7.5043067505E-01, 6.0784515104E-01, 6.8505678450E-01],
	[1.5490000000E+04, 7.6634689297E+00, 5.4929980632E+00, 7.5119961034E-01, 6.0836751599E-01, 6.8518446636E-01],
	[1.5495000000E+04, 7.6668951748E+00, 5.4927023939E+00, 7.5196908448E-01, 6.0889008291E-01, 6.8531211708E-01],
	[1.5500000000E+04, 7.6703218455E+00, 5.4924068359E+00, 7.5273909766E-01, 6.0941285168E-01, 6.8543973665E-01],
	[1.5505000000E+04, 7.6737489419E+00, 5.4921113891E+00, 7.5350965009E-01, 6.0993582217E-01, 6.8556732504E-01],
	[1.5510000000E+04, 7.6771764637E+00, 5.4918160535E+00, 7.5428074197E-01, 6.1045899428E-01, 6.8569488225E-01],
	[1.5515000000E+04, 7.6806044110E+00, 5.4915208290E+00, 7.5505237351E-01, 6.1098236788E-01, 6.8582240826E-01],
	[1.5520000000E+04, 7.6840327836E+00, 5.4912257154E+00, 7.5582454491E-01, 6.1150594286E-01, 6.8594990307E-01],
	[1.5525000000E+04, 7.6874615815E+00, 5.4909307128E+00, 7.5659725637E-01, 6.1202971909E-01, 6.8607736664E-01],
	[1.5530000000E+04, 7.6908908045E+00, 5.4906358210E+00, 7.5737050809E-01, 6.1255369646E-01, 6.8620479898E-01],
	[1.5535000000E+04, 7.6943204526E+00, 5.4903410399E+00, 7.5814430028E-01, 6.1307787485E-01, 6.8633220007E-01],
	[1.5540000000E+04, 7.6977535949E+00, 5.4900480901E+00, 7.5891863314E-01, 6.1360229513E-01, 6.8645956989E-01],
	[1.5545000000E+04, 7.7011952021E+00, 5.4897597540E+00, 7.5969350688E-01, 6.1412702378E-01, 6.8658690843E-01],
	[1.5550000000E+04, 7.7046372405E+00, 5.4894715258E+00, 7.6046892169E-01, 6.1465195350E-01, 6.8671421569E-01],
	[1.5555000000E+04, 7.7080797100E+00, 5.4891834054E+00, 7.6124487778E-01, 6.1517708416E-01, 6.8684149163E-01],
	[1.5560000000E+04, 7.7115226104E+00, 5.4888953927E+00, 7.6202137536E-01, 6.1570241566E-01, 6.8696873626E-01],
	[1.5565000000E+04, 7.7149659418E+00, 5.4886074876E+00, 7.6279841462E-01, 6.1622794786E-01, 6.8709594956E-01],
	[1.5570000000E+04, 7.7184097040E+00, 5.4883196901E+00, 7.6357599577E-01, 6.1675368065E-01, 6.8722313151E-01],
	[1.5575000000E+04, 7.7218538969E+00, 5.4880320000E+00, 7.6435411902E-01, 6.1727961391E-01, 6.8735028210E-01],
	[1.5580000000E+04, 7.7252985206E+00, 5.4877444174E+00, 7.6513278456E-01, 6.1780574752E-01, 6.8747740132E-01],
	[1.5585000000E+04, 7.7287435748E+00, 5.4874569422E+00, 7.6591199260E-01, 6.1833208136E-01, 6.8760448916E-01],
	[1.5590000000E+04, 7.7321890595E+00, 5.4871695742E+00, 7.6669174334E-01, 6.1885861532E-01, 6.8773154560E-01],
	[1.5595000000E+04, 7.7356349745E+00, 5.4868823133E+00, 7.6747203699E-01, 6.1938534926E-01, 6.8785857063E-01],
	[1.5600000000E+04, 7.7390813200E+00, 5.4865951597E+00, 7.6825287374E-01, 6.1991228308E-01, 6.8798556423E-01],
	[1.5605000000E+04, 7.7425280956E+00, 5.4863081130E+00, 7.6903425381E-01, 6.2043941665E-01, 6.8811252640E-01],
	[1.5610000000E+04, 7.7459753015E+00, 5.4860211733E+00, 7.6981617739E-01, 6.2096674985E-01, 6.8823945712E-01],
	[1.5615000000E+04, 7.7494229374E+00, 5.4857343405E+00, 7.7059864469E-01, 6.2149428256E-01, 6.8836635637E-01],
	[1.5620000000E+04, 7.7528710032E+00, 5.4854476146E+00, 7.7138165591E-01, 6.2202201466E-01, 6.8849322415E-01],
	[1.5625000000E+04, 7.7563194990E+00, 5.4851609953E+00, 7.7216521126E-01, 6.2254994604E-01, 6.8862006044E-01],
	[1.5630000000E+04, 7.7597684246E+00, 5.4848744828E+00, 7.7294931094E-01, 6.2307807656E-01, 6.8874686523E-01],
	[1.5635000000E+04, 7.7632177800E+00, 5.4845880768E+00, 7.7373395514E-01, 6.2360640611E-01, 6.8887363851E-01],
	[1.5640000000E+04, 7.7666675650E+00, 5.4843017774E+00, 7.7451914408E-01, 6.2413493457E-01, 6.8900038026E-01],
	[1.5645000000E+04, 7.7701177796E+00, 5.4840155844E+00, 7.7530487796E-01, 6.2466366182E-01, 6.8912709047E-01],
	[1.5650000000E+04, 7.7735684236E+00, 5.4837294978E+00, 7.7609115698E-01, 6.2519258773E-01, 6.8925376913E-01],
	[1.5655000000E+04, 7.7770194971E+00, 5.4834435175E+00, 7.7687798135E-01, 6.2572171219E-01, 6.8938041622E-01],
	[1.5660000000E+04, 7.7804709999E+00, 5.4831576435E+00, 7.7766535126E-01, 6.2625103507E-01, 6.8950703173E-01],
	[1.5665000000E+04, 7.7839229319E+00, 5.4828718756E+00, 7.7845326692E-01, 6.2678055625E-01, 6.8963361566E-01],
	[1.5670000000E+04, 7.7873752930E+00, 5.4825862137E+00, 7.7924172854E-01, 6.2731027562E-01, 6.8976016798E-01],
	[1.5675000000E+04, 7.7908280833E+00, 5.4823006579E+00, 7.8003073632E-01, 6.2784019304E-01, 6.8988668869E-01],
	[1.5680000000E+04, 7.7942813025E+00, 5.4820152080E+00, 7.8082029045E-01, 6.2837030840E-01, 6.9001317777E-01],
	[1.5685000000E+04, 7.7977349506E+00, 5.4817298640E+00, 7.8161039116E-01, 6.2890062158E-01, 6.9013963520E-01],
	[1.5690000000E+04, 7.8011890275E+00, 5.4814446258E+00, 7.8240103863E-01, 6.2943113245E-01, 6.9026606099E-01],
	[1.5695000000E+04, 7.8046435332E+00, 5.4811594933E+00, 7.8319223307E-01, 6.2996184089E-01, 6.9039245511E-01],
	[1.5700000000E+04, 7.8080984675E+00, 5.4808744665E+00, 7.8398397469E-01, 6.3049274678E-01, 6.9051881755E-01],
	[1.5705000000E+04, 7.8115538304E+00, 5.4805895452E+00, 7.8477626368E-01, 6.3102384999E-01, 6.9064514831E-01],
	[1.5710000000E+04, 7.8150096217E+00, 5.4803047294E+00, 7.8556910026E-01, 6.3155515041E-01, 6.9077144736E-01],
	[1.5715000000E+04, 7.8184658415E+00, 5.4800200190E+00, 7.8636248462E-01, 6.3208664792E-01, 6.9089771470E-01],
	[1.5720000000E+04, 7.8219224895E+00, 5.4797354140E+00, 7.8715641697E-01, 6.3261834238E-01, 6.9102395031E-01],
	[1.5725000000E+04, 7.8253795659E+00, 5.4794509143E+00, 7.8795089751E-01, 6.3315023368E-01, 6.9115015418E-01],
	[1.5730000000E+04, 7.8288370703E+00, 5.4791665198E+00, 7.8874592645E-01, 6.3368232169E-01, 6.9127632630E-01],
	[1.5735000000E+04, 7.8322950028E+00, 5.4788822305E+00, 7.8954150399E-01, 6.3421460629E-01, 6.9140246665E-01],
	[1.5740000000E+04, 7.8357533634E+00, 5.4785980462E+00, 7.9033763033E-01, 6.3474708736E-01, 6.9152857524E-01],
	[1.5745000000E+04, 7.8392121518E+00, 5.4783139668E+00, 7.9113430567E-01, 6.3527976477E-01, 6.9165465203E-01],
	[1.5750000000E+04, 7.8426713680E+00, 5.4780299925E+00, 7.9193153023E-01, 6.3581263840E-01, 6.9178069703E-01],
	[1.5755000000E+04, 7.8461310120E+00, 5.4777461229E+00, 7.9272930420E-01, 6.3634570813E-01, 6.9190671021E-01],
	[1.5760000000E+04, 7.8495910836E+00, 5.4774623582E+00, 7.9352762778E-01, 6.3687897384E-01, 6.9203269157E-01],
	[1.5765000000E+04, 7.8530515828E+00, 5.4771786981E+00, 7.9432650119E-01, 6.3741243539E-01, 6.9215864110E-01],
	[1.5770000000E+04, 7.8565125094E+00, 5.4768951427E+00, 7.9512592462E-01, 6.3794609267E-01, 6.9228455878E-01],
	[1.5775000000E+04, 7.8599738635E+00, 5.4766116918E+00, 7.9592589827E-01, 6.3847994555E-01, 6.9241044459E-01],
	[1.5780000000E+04, 7.8634356449E+00, 5.4763283455E+00, 7.9672642236E-01, 6.3901399391E-01, 6.9253629854E-01],
	[1.5785000000E+04, 7.8668978535E+00, 5.4760451035E+00, 7.9752749708E-01, 6.3954823763E-01, 6.9266212061E-01],
	[1.5790000000E+04, 7.8703633432E+00, 5.4757634731E+00, 7.9832912264E-01, 6.4008271604E-01, 6.9278791078E-01],
	[1.5795000000E+04, 7.8738379989E+00, 5.4754865587E+00, 7.9913129924E-01, 6.4061751064E-01, 6.9291366905E-01],
	[1.5800000000E+04, 7.8773130881E+00, 5.4752097459E+00, 7.9993402709E-01, 6.4115250065E-01, 6.9303939539E-01],
	[1.5805000000E+04, 7.8807886108E+00, 5.4749330346E+00, 8.0073730639E-01, 6.4168768593E-01, 6.9316508981E-01],
	[1.5810000000E+04, 7.8842645669E+00, 5.4746564249E+00, 8.0154113734E-01, 6.4222306638E-01, 6.9329075229E-01],
	[1.5815000000E+04, 7.8877409562E+00, 5.4743799166E+00, 8.0234552014E-01, 6.4275864187E-01, 6.9341638281E-01],
	[1.5820000000E+04, 7.8912177788E+00, 5.4741035096E+00, 8.0315045501E-01, 6.4329441226E-01, 6.9354198137E-01],
	[1.5825000000E+04, 7.8946950344E+00, 5.4738272040E+00, 8.0395594214E-01, 6.4383037744E-01, 6.9366754795E-01],
	[1.5830000000E+04, 7.8981727232E+00, 5.4735509996E+00, 8.0476198173E-01, 6.4436653728E-01, 6.9379308255E-01],
	[1.5835000000E+04, 7.9016508448E+00, 5.4732748963E+00, 8.0556857400E-01, 6.4490289166E-01, 6.9391858514E-01],
	[1.5840000000E+04, 7.9051293994E+00, 5.4729988941E+00, 8.0637571914E-01, 6.4543944045E-01, 6.9404405573E-01],
	[1.5845000000E+04, 7.9086083867E+00, 5.4727229930E+00, 8.0718341736E-01, 6.4597618353E-01, 6.9416949429E-01],
	[1.5850000000E+04, 7.9120878067E+00, 5.4724471928E+00, 8.0799166886E-01, 6.4651312077E-01, 6.9429490082E-01],
	[1.5855000000E+04, 7.9155676594E+00, 5.4721714934E+00, 8.0880047385E-01, 6.4705025204E-01, 6.9442027531E-01],
	[1.5860000000E+04, 7.9190479445E+00, 5.4718958949E+00, 8.0960983253E-01, 6.4758757723E-01, 6.9454561774E-01],
	[1.5865000000E+04, 7.9225286622E+00, 5.4716203972E+00, 8.1041974510E-01, 6.4812509621E-01, 6.9467092810E-01],
	[1.5870000000E+04, 7.9260098122E+00, 5.4713450001E+00, 8.1123021177E-01, 6.4866280885E-01, 6.9479620639E-01],
	[1.5875000000E+04, 7.9294913945E+00, 5.4710697036E+00, 8.1204123274E-01, 6.4920071502E-01, 6.9492145258E-01],
	[1.5880000000E+04, 7.9329734091E+00, 5.4707945077E+00, 8.1285280821E-01, 6.4973881460E-01, 6.9504666668E-01],
	[1.5885000000E+04, 7.9364558557E+00, 5.4705194122E+00, 8.1366493840E-01, 6.5027710747E-01, 6.9517184866E-01],
	[1.5890000000E+04, 7.9399387344E+00, 5.4702444171E+00, 8.1447762349E-01, 6.5081559349E-01, 6.9529699852E-01],
	[1.5895000000E+04, 7.9434220451E+00, 5.4699695224E+00, 8.1529086370E-01, 6.5135427255E-01, 6.9542211624E-01],
	[1.5900000000E+04, 7.9469057876E+00, 5.4696947279E+00, 8.1610465923E-01, 6.5189314451E-01, 6.9554720182E-01],
	[1.5905000000E+04, 7.9503899620E+00, 5.4694200336E+00, 8.1691901029E-01, 6.5243220926E-01, 6.9567225525E-01],
	[1.5910000000E+04, 7.9538745680E+00, 5.4691454395E+00, 8.1773391707E-01, 6.5297146666E-01, 6.9579727650E-01],
	[1.5915000000E+04, 7.9573596057E+00, 5.4688709454E+00, 8.1854937979E-01, 6.5351091658E-01, 6.9592226558E-01],
	[1.5920000000E+04, 7.9608450750E+00, 5.4685965513E+00, 8.1936539864E-01, 6.5405055891E-01, 6.9604722247E-01],
	[1.5925000000E+04, 7.9643309757E+00, 5.4683222572E+00, 8.2018197382E-01, 6.5459039351E-01, 6.9617214715E-01],
	[1.5930000000E+04, 7.9678173078E+00, 5.4680480629E+00, 8.2099910556E-01, 6.5513042025E-01, 6.9629703963E-01],
	[1.5935000000E+04, 7.9713040712E+00, 5.4677739684E+00, 8.2181679404E-01, 6.5567063902E-01, 6.9642189988E-01],
	[1.5940000000E+04, 7.9747912658E+00, 5.4674999736E+00, 8.2263503947E-01, 6.5621104968E-01, 6.9654672791E-01],
	[1.5945000000E+04, 7.9782788916E+00, 5.4672260785E+00, 8.2345384205E-01, 6.5675165211E-01, 6.9667152369E-01],
	[1.5950000000E+04, 7.9817669484E+00, 5.4669522829E+00, 8.2427320199E-01, 6.5729244618E-01, 6.9679628721E-01],
	[1.5955000000E+04, 7.9852554362E+00, 5.4666785869E+00, 8.2509311950E-01, 6.5783343176E-01, 6.9692101847E-01],
	[1.5960000000E+04, 7.9887443549E+00, 5.4664049903E+00, 8.2591359477E-01, 6.5837460872E-01, 6.9704571745E-01],
	[1.5965000000E+04, 7.9922337044E+00, 5.4661314932E+00, 8.2673462802E-01, 6.5891597694E-01, 6.9717038415E-01],
	[1.5970000000E+04, 7.9957234847E+00, 5.4658580953E+00, 8.2755621944E-01, 6.5945753630E-01, 6.9729501854E-01],
	[1.5975000000E+04, 7.9992136956E+00, 5.4655847967E+00, 8.2837836923E-01, 6.5999928665E-01, 6.9741962062E-01],
	[1.5980000000E+04, 8.0027043371E+00, 5.4653115973E+00, 8.2920107761E-01, 6.6054122788E-01, 6.9754419035E-01],
	[1.5985000000E+04, 8.0061954090E+00, 5.4650384970E+00, 8.3002434478E-01, 6.6108335985E-01, 6.9766872774E-01],
	[1.5990000000E+04, 8.0096869114E+00, 5.4647654957E+00, 8.3084817094E-01, 6.6162568244E-01, 6.9779323277E-01],
	[1.5995000000E+04, 8.0131788441E+00, 5.4644925934E+00, 8.3167255629E-01, 6.6216819553E-01, 6.9791770542E-01],
	[1.6000000000E+04, 8.0166712070E+00, 5.4642197901E+00, 8.3249750104E-01, 6.6271089897E-01, 6.9804214569E-01],
	[1.6005000000E+04, 8.0201640001E+00, 5.4639470856E+00, 8.3332300539E-01, 6.6325379265E-01, 6.9816655355E-01],
	[1.6010000000E+04, 8.0236572233E+00, 5.4636744799E+00, 8.3414906955E-01, 6.6379687644E-01, 6.9829092900E-01],
	[1.6015000000E+04, 8.0271508764E+00, 5.4634019729E+00, 8.3497569372E-01, 6.6434015020E-01, 6.9841527202E-01],
	[1.6020000000E+04, 8.0306449595E+00, 5.4631295645E+00, 8.3580287811E-01, 6.6488361380E-01, 6.9853958259E-01],
	[1.6025000000E+04, 8.0341394724E+00, 5.4628572548E+00, 8.3663062291E-01, 6.6542726713E-01, 6.9866386071E-01],
	[1.6030000000E+04, 8.0376344151E+00, 5.4625850435E+00, 8.3745892834E-01, 6.6597111005E-01, 6.9878810637E-01],
	[1.6035000000E+04, 8.0411297875E+00, 5.4623129307E+00, 8.3828779460E-01, 6.6651514243E-01, 6.9891231954E-01],
	[1.6040000000E+04, 8.0446255894E+00, 5.4620409163E+00, 8.3911722188E-01, 6.6705936414E-01, 6.9903650021E-01],
	[1.6045000000E+04, 8.0481267822E+00, 5.4617714717E+00, 8.3994721041E-01, 6.6760384613E-01, 6.9916064838E-01],
	[1.6050000000E+04, 8.0516355274E+00, 5.4615056695E+00, 8.4077776037E-01, 6.6814861945E-01, 6.9928476403E-01],
	[1.6055000000E+04, 8.0551447087E+00, 5.4612399630E+00, 8.4160887197E-01, 6.6869358217E-01, 6.9940884714E-01],
	[1.6060000000E+04, 8.0586543260E+00, 5.4609743522E+00, 8.4244054543E-01, 6.6923873416E-01, 6.9953289771E-01],
	[1.6065000000E+04, 8.0621643792E+00, 5.4607088370E+00, 8.4327278093E-01, 6.6978407528E-01, 6.9965691572E-01],
	[1.6070000000E+04, 8.0656748683E+00, 5.4604434173E+00, 8.4410557869E-01, 6.7032960540E-01, 6.9978090116E-01],
	[1.6075000000E+04, 8.0691857931E+00, 5.4601780931E+00, 8.4493893892E-01, 6.7087532440E-01, 6.9990485401E-01],
	[1.6080000000E+04, 8.0726971537E+00, 5.4599128642E+00, 8.4577286180E-01, 6.7142123215E-01, 7.0002877426E-01],
	[1.6085000000E+04, 8.0762089499E+00, 5.4596477307E+00, 8.4660734756E-01, 6.7196732852E-01, 7.0015266190E-01],
	[1.6090000000E+04, 8.0797211815E+00, 5.4593826925E+00, 8.4744239639E-01, 6.7251361337E-01, 7.0027651691E-01],
	[1.6095000000E+04, 8.0832338487E+00, 5.4591177495E+00, 8.4827800849E-01, 6.7306008658E-01, 7.0040033929E-01],
	[1.6100000000E+04, 8.0867469512E+00, 5.4588529016E+00, 8.4911418408E-01, 6.7360674802E-01, 7.0052412902E-01],
	[1.6105000000E+04, 8.0902604889E+00, 5.4585881488E+00, 8.4995092335E-01, 6.7415359756E-01, 7.0064788609E-01],
	[1.6110000000E+04, 8.0937744619E+00, 5.4583234911E+00, 8.5078822652E-01, 6.7470063507E-01, 7.0077161049E-01],
	[1.6115000000E+04, 8.0972888700E+00, 5.4580589282E+00, 8.5162609377E-01, 6.7524786041E-01, 7.0089530219E-01],
	[1.6120000000E+04, 8.1008037131E+00, 5.4577944603E+00, 8.5246452533E-01, 6.7579527347E-01, 7.0101896120E-01],
	[1.6125000000E+04, 8.1043189912E+00, 5.4575300872E+00, 8.5330352139E-01, 6.7634287410E-01, 7.0114258749E-01],
	[1.6130000000E+04, 8.1078347042E+00, 5.4572658089E+00, 8.5414308215E-01, 6.7689066218E-01, 7.0126618106E-01],
	[1.6135000000E+04, 8.1113508520E+00, 5.4570016253E+00, 8.5498320783E-01, 6.7743863758E-01, 7.0138974190E-01],
	[1.6140000000E+04, 8.1148674345E+00, 5.4567375363E+00, 8.5582389863E-01, 6.7798680017E-01, 7.0151326998E-01],
	[1.6145000000E+04, 8.1183844516E+00, 5.4564735418E+00, 8.5666515474E-01, 6.7853514981E-01, 7.0163676530E-01],
	[1.6150000000E+04, 8.1219019033E+00, 5.4562096419E+00, 8.5750697638E-01, 6.7908368638E-01, 7.0176022785E-01],
	[1.6155000000E+04, 8.1254197894E+00, 5.4559458365E+00, 8.5834936374E-01, 6.7963240974E-01, 7.0188365761E-01],
	[1.6160000000E+04, 8.1289381099E+00, 5.4556821254E+00, 8.5919231704E-01, 6.8018131977E-01, 7.0200705457E-01],
	[1.6165000000E+04, 8.1324568648E+00, 5.4554185086E+00, 8.6003583648E-01, 6.8073041633E-01, 7.0213041872E-01],
	[1.6170000000E+04, 8.1359760539E+00, 5.4551549861E+00, 8.6087992226E-01, 6.8127969929E-01, 7.0225375005E-01],
	[1.6175000000E+04, 8.1394956771E+00, 5.4548915578E+00, 8.6172457459E-01, 6.8182916852E-01, 7.0237704854E-01],
	[1.6180000000E+04, 8.1430157344E+00, 5.4546282236E+00, 8.6256979366E-01, 6.8237882389E-01, 7.0250031418E-01],
	[1.6185000000E+04, 8.1465362257E+00, 5.4543649835E+00, 8.6341557970E-01, 6.8292866527E-01, 7.0262354696E-01],
	[1.6190000000E+04, 8.1500571509E+00, 5.4541018374E+00, 8.6426193289E-01, 6.8347869252E-01, 7.0274674688E-01],
	[1.6195000000E+04, 8.1535785099E+00, 5.4538387853E+00, 8.6510885344E-01, 6.8402890552E-01, 7.0286991390E-01],
	[1.6200000000E+04, 8.1571003027E+00, 5.4535758270E+00, 8.6595634157E-01, 6.8457930413E-01, 7.0299304803E-01],
	[1.6205000000E+04, 8.1606225291E+00, 5.4533129626E+00, 8.6680439746E-01, 6.8512988822E-01, 7.0311614926E-01],
	[1.6210000000E+04, 8.1641451891E+00, 5.4530501919E+00, 8.6765302134E-01, 6.8568065766E-01, 7.0323921756E-01],
	[1.6215000000E+04, 8.1676682826E+00, 5.4527875149E+00, 8.6850221339E-01, 6.8623161232E-01, 7.0336225294E-01],
	[1.6220000000E+04, 8.1711918096E+00, 5.4525249315E+00, 8.6935197383E-01, 6.8678275206E-01, 7.0348525536E-01],
	[1.6225000000E+04, 8.1747157699E+00, 5.4522624418E+00, 8.7020230287E-01, 6.8733407675E-01, 7.0360822484E-01],
	[1.6230000000E+04, 8.1782401634E+00, 5.4520000455E+00, 8.7105320069E-01, 6.8788558626E-01, 7.0373116134E-01],
	[1.6235000000E+04, 8.1817649902E+00, 5.4517377426E+00, 8.7190466752E-01, 6.8843728046E-01, 7.0385406487E-01],
	[1.6240000000E+04, 8.1852902500E+00, 5.4514755332E+00, 8.7275670355E-01, 6.8898915922E-01, 7.0397693541E-01],
	[1.6245000000E+04, 8.1888159429E+00, 5.4512134171E+00, 8.7360930900E-01, 6.8954122240E-01, 7.0409977294E-01],
	[1.6250000000E+04, 8.1923420687E+00, 5.4509513942E+00, 8.7446248405E-01, 6.9009346987E-01, 7.0422257747E-01],
	[1.6255000000E+04, 8.1958686274E+00, 5.4506894645E+00, 8.7531622892E-01, 6.9064590149E-01, 7.0434534896E-01],
	[1.6260000000E+04, 8.1993956188E+00, 5.4504276280E+00, 8.7617054382E-01, 6.9119851714E-01, 7.0446808742E-01],
	[1.6265000000E+04, 8.2029230430E+00, 5.4501658846E+00, 8.7702542894E-01, 6.9175131668E-01, 7.0459079283E-01],
	[1.6270000000E+04, 8.2064508998E+00, 5.4499042341E+00, 8.7788088449E-01, 6.9230429998E-01, 7.0471346518E-01],
	[1.6275000000E+04, 8.2099791891E+00, 5.4496426766E+00, 8.7873691068E-01, 6.9285746690E-01, 7.0483610446E-01],
	[1.6280000000E+04, 8.2135079109E+00, 5.4493812120E+00, 8.7959350771E-01, 6.9341081731E-01, 7.0495871065E-01],
	[1.6285000000E+04, 8.2170370651E+00, 5.4491198403E+00, 8.8045067579E-01, 6.9396435108E-01, 7.0508128375E-01],
	[1.6290000000E+04, 8.2205666515E+00, 5.4488585613E+00, 8.8130841512E-01, 6.9451806808E-01, 7.0520382374E-01],
	[1.6295000000E+04, 8.2240966702E+00, 5.4485973750E+00, 8.8216672590E-01, 6.9507196816E-01, 7.0532633062E-01],
	[1.6300000000E+04, 8.2276271211E+00, 5.4483362813E+00, 8.8302560834E-01, 6.9562605120E-01, 7.0544880437E-01],
	[1.6305000000E+04, 8.2311675229E+00, 5.4480797576E+00, 8.8388506264E-01, 6.9618045827E-01, 7.0557124498E-01],
	[1.6310000000E+04, 8.2347114215E+00, 5.4478247631E+00, 8.8474508901E-01, 6.9673509382E-01, 7.0569365244E-01],
	[1.6315000000E+04, 8.2382557591E+00, 5.4475698588E+00, 8.8560568766E-01, 6.9728991239E-01, 7.0581602673E-01],
	[1.6320000000E+04, 8.2418005354E+00, 5.4473150444E+00, 8.8646685878E-01, 6.9784491385E-01, 7.0593836785E-01],
	[1.6325000000E+04, 8.2453457505E+00, 5.4470603200E+00, 8.8732860259E-01, 6.9840009807E-01, 7.0606067579E-01],
	[1.6330000000E+04, 8.2488914041E+00, 5.4468056855E+00, 8.8819091929E-01, 6.9895546492E-01, 7.0618295053E-01],
	[1.6335000000E+04, 8.2524374963E+00, 5.4465511409E+00, 8.8905380907E-01, 6.9951101425E-01, 7.0630519207E-01],
	[1.6340000000E+04, 8.2559840269E+00, 5.4462966861E+00, 8.8991727216E-01, 7.0006674594E-01, 7.0642740039E-01],
	[1.6345000000E+04, 8.2595309959E+00, 5.4460423210E+00, 8.9078130874E-01, 7.0062265985E-01, 7.0654957547E-01],
	[1.6350000000E+04, 8.2630784033E+00, 5.4457880456E+00, 8.9164591903E-01, 7.0117875585E-01, 7.0667171732E-01],
	[1.6355000000E+04, 8.2666262488E+00, 5.4455338598E+00, 8.9251110324E-01, 7.0173503380E-01, 7.0679382592E-01],
	[1.6360000000E+04, 8.2701745325E+00, 5.4452797635E+00, 8.9337686155E-01, 7.0229149358E-01, 7.0691590126E-01],
	[1.6365000000E+04, 8.2737232542E+00, 5.4450257567E+00, 8.9424319419E-01, 7.0284813504E-01, 7.0703794332E-01],
	[1.6370000000E+04, 8.2772724139E+00, 5.4447718394E+00, 8.9511010136E-01, 7.0340495805E-01, 7.0715995210E-01],
	[1.6375000000E+04, 8.2808220115E+00, 5.4445180115E+00, 8.9597758325E-01, 7.0396196247E-01, 7.0728192759E-01],
	[1.6380000000E+04, 8.2843720469E+00, 5.4442642729E+00, 8.9684564008E-01, 7.0451914818E-01, 7.0740386977E-01],
	[1.6385000000E+04, 8.2879225201E+00, 5.4440106235E+00, 8.9771427205E-01, 7.0507651503E-01, 7.0752577864E-01],
	[1.6390000000E+04, 8.2914734309E+00, 5.4437570634E+00, 8.9858347937E-01, 7.0563406289E-01, 7.0764765418E-01],
	[1.6395000000E+04, 8.2950247793E+00, 5.4435035923E+00, 8.9945326223E-01, 7.0619179164E-01, 7.0776949638E-01],
	[1.6400000000E+04, 8.2985765653E+00, 5.4432502104E+00, 9.0032362085E-01, 7.0674970112E-01, 7.0789130524E-01],
	[1.6405000000E+04, 8.3021287886E+00, 5.4429969175E+00, 9.0119455543E-01, 7.0730779121E-01, 7.0801308074E-01],
	[1.6410000000E+04, 8.3056814493E+00, 5.4427437136E+00, 9.0206606617E-01, 7.0786606177E-01, 7.0813482286E-01],
	[1.6415000000E+04, 8.3092345472E+00, 5.4424905986E+00, 9.0293815328E-01, 7.0842451267E-01, 7.0825653161E-01],
	[1.6420000000E+04, 8.3127880823E+00, 5.4422375724E+00, 9.0381081696E-01, 7.0898314376E-01, 7.0837820698E-01],
	[1.6425000000E+04, 8.3163420545E+00, 5.4419846351E+00, 9.0468405743E-01, 7.0954195493E-01, 7.0849984894E-01],
	[1.6430000000E+04, 8.3198964638E+00, 5.4417317864E+00, 9.0555787487E-01, 7.1010094602E-01, 7.0862145748E-01],
	[1.6435000000E+04, 8.3234513100E+00, 5.4414790265E+00, 9.0643226951E-01, 7.1066011690E-01, 7.0874303261E-01],
	[1.6440000000E+04, 8.3270065930E+00, 5.4412263551E+00, 9.0730724154E-01, 7.1121946745E-01, 7.0886457431E-01],
	[1.6445000000E+04, 8.3305623129E+00, 5.4409737724E+00, 9.0818279116E-01, 7.1177899751E-01, 7.0898608257E-01],
	[1.6450000000E+04, 8.3341184694E+00, 5.4407212781E+00, 9.0905891859E-01, 7.1233870696E-01, 7.0910755737E-01],
	[1.6455000000E+04, 8.3376750626E+00, 5.4404688723E+00, 9.0993562403E-01, 7.1289859567E-01, 7.0922899871E-01],
	[1.6460000000E+04, 8.3412320923E+00, 5.4402165548E+00, 9.1081290768E-01, 7.1345866348E-01, 7.0935040658E-01],
	[1.6465000000E+04, 8.3447895585E+00, 5.4399643257E+00, 9.1169076975E-01, 7.1401891027E-01, 7.0947178096E-01],
	[1.6470000000E+04, 8.3483474611E+00, 5.4397121849E+00, 9.1256921045E-01, 7.1457933591E-01, 7.0959312186E-01],
	[1.6475000000E+04, 8.3519058000E+00, 5.4394601323E+00, 9.1344822997E-01, 7.1513994024E-01, 7.0971442925E-01],
	[1.6480000000E+04, 8.3554645751E+00, 5.4392081679E+00, 9.1432782852E-01, 7.1570072315E-01, 7.0983570313E-01],
	[1.6485000000E+04, 8.3590237864E+00, 5.4389562915E+00, 9.1520800632E-01, 7.1626168449E-01, 7.0995694348E-01],
	[1.6490000000E+04, 8.3625834338E+00, 5.4387045032E+00, 9.1608876355E-01, 7.1682282412E-01, 7.1007815030E-01],
	[1.6495000000E+04, 8.3661435171E+00, 5.4384528029E+00, 9.1697010044E-01, 7.1738414191E-01, 7.1019932358E-01],
	[1.6500000000E+04, 8.3697040364E+00, 5.4382011905E+00, 9.1785201717E-01, 7.1794563772E-01, 7.1032046330E-01],
	[1.6505000000E+04, 8.3732649915E+00, 5.4379496659E+00, 9.1873451397E-01, 7.1850731142E-01, 7.1044156946E-01],
	[1.6510000000E+04, 8.3768263824E+00, 5.4376982292E+00, 9.1961759103E-01, 7.1906916286E-01, 7.1056264205E-01],
	[1.6515000000E+04, 8.3803882090E+00, 5.4374468802E+00, 9.2050124856E-01, 7.1963119192E-01, 7.1068368106E-01],
	[1.6520000000E+04, 8.3839504711E+00, 5.4371956190E+00, 9.2138548676E-01, 7.2019339844E-01, 7.1080468647E-01],
	[1.6525000000E+04, 8.3875131688E+00, 5.4369444454E+00, 9.2227030584E-01, 7.2075578230E-01, 7.1092565828E-01],
	[1.6530000000E+04, 8.3910763020E+00, 5.4366933593E+00, 9.2315570600E-01, 7.2131834336E-01, 7.1104659648E-01],
	[1.6535000000E+04, 8.3946398705E+00, 5.4364423608E+00, 9.2404168745E-01, 7.2188108148E-01, 7.1116750106E-01],
	[1.6540000000E+04, 8.3982038743E+00, 5.4361914498E+00, 9.2492825040E-01, 7.2244399652E-01, 7.1128837200E-01],
	[1.6545000000E+04, 8.4017683133E+00, 5.4359406261E+00, 9.2581539505E-01, 7.2300708835E-01, 7.1140920931E-01],
	[1.6550000000E+04, 8.4053331874E+00, 5.4356898899E+00, 9.2670312160E-01, 7.2357035682E-01, 7.1153001296E-01],
	[1.6555000000E+04, 8.4088984966E+00, 5.4354392409E+00, 9.2759143026E-01, 7.2413380180E-01, 7.1165078295E-01],
	[1.6560000000E+04, 8.4124642407E+00, 5.4351886792E+00, 9.2848032123E-01, 7.2469742316E-01, 7.1177151927E-01],
	[1.6565000000E+04, 8.4160339687E+00, 5.4349397832E+00, 9.2936979473E-01, 7.2526127521E-01, 7.1189222191E-01],
	[1.6570000000E+04, 8.4196136670E+00, 5.4346952123E+00, 9.3025985095E-01, 7.2582544994E-01, 7.1201289087E-01],
	[1.6575000000E+04, 8.4231938071E+00, 5.4344507261E+00, 9.3115049009E-01, 7.2638980112E-01, 7.1213352612E-01],
	[1.6580000000E+04, 8.4267743891E+00, 5.4342063247E+00, 9.3204171238E-01, 7.2695432861E-01, 7.1225412767E-01],
	[1.6585000000E+04, 8.4303554128E+00, 5.4339620079E+00, 9.3293351800E-01, 7.2751903227E-01, 7.1237469550E-01],
	[1.6590000000E+04, 8.4339368781E+00, 5.4337177758E+00, 9.3382590718E-01, 7.2808391197E-01, 7.1249522960E-01],
	[1.6595000000E+04, 8.4375187851E+00, 5.4334736282E+00, 9.3471888010E-01, 7.2864896756E-01, 7.1261572996E-01],
	[1.6600000000E+04, 8.4411011335E+00, 5.4332295652E+00, 9.3561243698E-01, 7.2921419891E-01, 7.1273619658E-01],
	[1.6605000000E+04, 8.4446839234E+00, 5.4329855866E+00, 9.3650657802E-01, 7.2977960588E-01, 7.1285662945E-01],
	[1.6610000000E+04, 8.4482671546E+00, 5.4327416924E+00, 9.3740130342E-01, 7.3034518834E-01, 7.1297702855E-01],
	[1.6615000000E+04, 8.4518508271E+00, 5.4324978826E+00, 9.3829661340E-01, 7.3091094613E-01, 7.1309739388E-01],
	[1.6620000000E+04, 8.4554349408E+00, 5.4322541571E+00, 9.3919250816E-01, 7.3147687914E-01, 7.1321772542E-01],
	[1.6625000000E+04, 8.4590194956E+00, 5.4320105158E+00, 9.4008898790E-01, 7.3204298720E-01, 7.1333802318E-01],
	[1.6630000000E+04, 8.4626044914E+00, 5.4317669587E+00, 9.4098605282E-01, 7.3260927020E-01, 7.1345828713E-01],
	[1.6635000000E+04, 8.4661899282E+00, 5.4315234857E+00, 9.4188370314E-01, 7.3317572799E-01, 7.1357851727E-01],
	[1.6640000000E+04, 8.4697758059E+00, 5.4312800968E+00, 9.4278193906E-01, 7.3374236042E-01, 7.1369871360E-01],
	[1.6645000000E+04, 8.4733621243E+00, 5.4310367920E+00, 9.4368076078E-01, 7.3430916737E-01, 7.1381887609E-01],
	[1.6650000000E+04, 8.4769488835E+00, 5.4307935711E+00, 9.4458016851E-01, 7.3487614869E-01, 7.1393900475E-01],
	[1.6655000000E+04, 8.4805360833E+00, 5.4305504341E+00, 9.4548016246E-01, 7.3544330424E-01, 7.1405909956E-01],
	[1.6660000000E+04, 8.4841237237E+00, 5.4303073810E+00, 9.4638074283E-01, 7.3601063389E-01, 7.1417916052E-01],
	[1.6665000000E+04, 8.4877118046E+00, 5.4300644117E+00, 9.4728190982E-01, 7.3657813749E-01, 7.1429918762E-01],
	[1.6670000000E+04, 8.4913003258E+00, 5.4298215261E+00, 9.4818366364E-01, 7.3714581490E-01, 7.1441918084E-01],
	[1.6675000000E+04, 8.4948892874E+00, 5.4295787243E+00, 9.4908600450E-01, 7.3771366600E-01, 7.1453914018E-01],
	[1.6680000000E+04, 8.4984786893E+00, 5.4293360061E+00, 9.4998893260E-01, 7.3828169062E-01, 7.1465906563E-01],
	[1.6685000000E+04, 8.5020685313E+00, 5.4290933714E+00, 9.5089244815E-01, 7.3884988865E-01, 7.1477895718E-01],
	[1.6690000000E+04, 8.5056588135E+00, 5.4288508204E+00, 9.5179655134E-01, 7.3941825993E-01, 7.1489881483E-01],
	[1.6695000000E+04, 8.5092495356E+00, 5.4286083528E+00, 9.5270124240E-01, 7.3998680433E-01, 7.1501863855E-01],
	[1.6700000000E+04, 8.5128406977E+00, 5.4283659686E+00, 9.5360652152E-01, 7.4055552171E-01, 7.1513842836E-01],
	[1.6705000000E+04, 8.5164322996E+00, 5.4281236678E+00, 9.5451238891E-01, 7.4112441193E-01, 7.1525818422E-01],
	[1.6710000000E+04, 8.5200243413E+00, 5.4278814503E+00, 9.5541884477E-01, 7.4169347484E-01, 7.1537790615E-01],
	[1.6715000000E+04, 8.5236168228E+00, 5.4276393161E+00, 9.5632588931E-01, 7.4226271031E-01, 7.1549759413E-01],
	[1.6720000000E+04, 8.5272097438E+00, 5.4273972652E+00, 9.5723352274E-01, 7.4283211820E-01, 7.1561724814E-01],
	[1.6725000000E+04, 8.5308031045E+00, 5.4271552973E+00, 9.5814174526E-01, 7.4340169836E-01, 7.1573686819E-01],
	[1.6730000000E+04, 8.5343969045E+00, 5.4269134126E+00, 9.5905055707E-01, 7.4397145067E-01, 7.1585645426E-01],
	[1.6735000000E+04, 8.5379911440E+00, 5.4266716110E+00, 9.5995995839E-01, 7.4454137496E-01, 7.1597600635E-01],
	[1.6740000000E+04, 8.5415858228E+00, 5.4264298923E+00, 9.6086994941E-01, 7.4511147112E-01, 7.1609552444E-01],
	[1.6745000000E+04, 8.5451809409E+00, 5.4261882566E+00, 9.6178053035E-01, 7.4568173898E-01, 7.1621500853E-01],
	[1.6750000000E+04, 8.5487764981E+00, 5.4259467038E+00, 9.6269170140E-01, 7.4625217843E-01, 7.1633445861E-01],
	[1.6755000000E+04, 8.5523724944E+00, 5.4257052339E+00, 9.6360346278E-01, 7.4682278930E-01, 7.1645387468E-01],
	[1.6760000000E+04, 8.5559689297E+00, 5.4254638467E+00, 9.6451581468E-01, 7.4739357147E-01, 7.1657325671E-01],
	[1.6765000000E+04, 8.5595658039E+00, 5.4252225422E+00, 9.6542875732E-01, 7.4796452479E-01, 7.1669260471E-01],
	[1.6770000000E+04, 8.5631631170E+00, 5.4249813205E+00, 9.6634229090E-01, 7.4853564913E-01, 7.1681191867E-01],
	[1.6775000000E+04, 8.5667608688E+00, 5.4247401814E+00, 9.6725641563E-01, 7.4910694433E-01, 7.1693119858E-01],
	[1.6780000000E+04, 8.5703590594E+00, 5.4244991248E+00, 9.6817113171E-01, 7.4967841026E-01, 7.1705044442E-01],
	[1.6785000000E+04, 8.5739576885E+00, 5.4242581508E+00, 9.6908643935E-01, 7.5025004677E-01, 7.1716965620E-01],
	[1.6790000000E+04, 8.5775567563E+00, 5.4240172592E+00, 9.7000233875E-01, 7.5082185374E-01, 7.1728883390E-01],
	[1.6795000000E+04, 8.5811562625E+00, 5.4237764501E+00, 9.7091883011E-01, 7.5139383100E-01, 7.1740797752E-01],
	[1.6800000000E+04, 8.5847562070E+00, 5.4235357234E+00, 9.7183591365E-01, 7.5196597843E-01, 7.1752708705E-01],
	[1.6805000000E+04, 8.5883565899E+00, 5.4232950789E+00, 9.7275358958E-01, 7.5253829588E-01, 7.1764616248E-01],
	[1.6810000000E+04, 8.5919574110E+00, 5.4230545167E+00, 9.7367185808E-01, 7.5311078322E-01, 7.1776520380E-01],
	[1.6815000000E+04, 8.5955586703E+00, 5.4228140367E+00, 9.7459071938E-01, 7.5368344028E-01, 7.1788421100E-01],
	[1.6820000000E+04, 8.5991603677E+00, 5.4225736389E+00, 9.7551017367E-01, 7.5425626695E-01, 7.1800318408E-01],
	[1.6825000000E+04, 8.6027625031E+00, 5.4223333232E+00, 9.7643022117E-01, 7.5482926307E-01, 7.1812212302E-01],
	[1.6830000000E+04, 8.6063650764E+00, 5.4220930895E+00, 9.7735086207E-01, 7.5540242850E-01, 7.1824102783E-01],
	[1.6835000000E+04, 8.6099808774E+00, 5.4218583201E+00, 9.7827209659E-01, 7.5597596634E-01, 7.1835989849E-01],
	[1.6840000000E+04, 8.6135979267E+00, 5.4216239686E+00, 9.7919392493E-01, 7.5654968646E-01, 7.1847873498E-01],
	[1.6845000000E+04, 8.6172154211E+00, 5.4213896967E+00, 9.8011634729E-01, 7.5712357599E-01, 7.1859753729E-01],
	[1.6850000000E+04, 8.6208333604E+00, 5.4211555045E+00, 9.8103936389E-01, 7.5769763478E-01, 7.1871630543E-01],
	[1.6855000000E+04, 8.6244517446E+00, 5.4209213919E+00, 9.8196297492E-01, 7.5827186268E-01, 7.1883503936E-01],
	[1.6860000000E+04, 8.6280705737E+00, 5.4206873589E+00, 9.8288718059E-01, 7.5884625955E-01, 7.1895373910E-01],
	[1.6865000000E+04, 8.6316898475E+00, 5.4204534053E+00, 9.8381198111E-01, 7.5942082526E-01, 7.1907240462E-01],
	[1.6870000000E+04, 8.6353095659E+00, 5.4202195312E+00, 9.8473737669E-01, 7.5999555966E-01, 7.1919103591E-01],
	[1.6875000000E+04, 8.6389297290E+00, 5.4199857365E+00, 9.8566336752E-01, 7.6057046260E-01, 7.1930963297E-01],
	[1.6880000000E+04, 8.6425503366E+00, 5.4197520211E+00, 9.8658995382E-01, 7.6114553395E-01, 7.1942819579E-01],
	[1.6885000000E+04, 8.6461713886E+00, 5.4195183850E+00, 9.8751713580E-01, 7.6172077357E-01, 7.1954672436E-01],
	[1.6890000000E+04, 8.6497928850E+00, 5.4192848281E+00, 9.8844491365E-01, 7.6229618130E-01, 7.1966521866E-01],
	[1.6895000000E+04, 8.6534148256E+00, 5.4190513504E+00, 9.8937328758E-01, 7.6287175701E-01, 7.1978367868E-01],
	[1.6900000000E+04, 8.6570372105E+00, 5.4188179519E+00, 9.9030225780E-01, 7.6344750056E-01, 7.1990210443E-01],
	[1.6905000000E+04, 8.6606600395E+00, 5.4185846325E+00, 9.9123182451E-01, 7.6402341179E-01, 7.2002049588E-01],
	[1.6910000000E+04, 8.6642833126E+00, 5.4183513921E+00, 9.9216198793E-01, 7.6459949058E-01, 7.2013885302E-01],
	[1.6915000000E+04, 8.6679070296E+00, 5.4181182307E+00, 9.9309274825E-01, 7.6517573678E-01, 7.2025717586E-01],
	[1.6920000000E+04, 8.6715311906E+00, 5.4178851482E+00, 9.9402410569E-01, 7.6575215024E-01, 7.2037546437E-01],
	[1.6925000000E+04, 8.6751557954E+00, 5.4176521447E+00, 9.9495606044E-01, 7.6632873082E-01, 7.2049371856E-01],
	[1.6930000000E+04, 8.6787808439E+00, 5.4174192199E+00, 9.9588861272E-01, 7.6690547838E-01, 7.2061193840E-01],
	[1.6935000000E+04, 8.6824063361E+00, 5.4171863740E+00, 9.9682176273E-01, 7.6748239278E-01, 7.2073012389E-01],
	[1.6940000000E+04, 8.6860322718E+00, 5.4169536068E+00, 9.9775551067E-01, 7.6805947386E-01, 7.2084827502E-01],
	[1.6945000000E+04, 8.6896586511E+00, 5.4167209183E+00, 9.9868985675E-01, 7.6863672150E-01, 7.2096639179E-01],
	[1.6950000000E+04, 8.6932854739E+00, 5.4164883084E+00, 9.9962480119E-01, 7.6921413554E-01, 7.2108447417E-01],
	[1.6955000000E+04, 8.6969127400E+00, 5.4162557771E+00, 1.0005603442E+00, 7.6979171585E-01, 7.2120252216E-01],
	[1.6960000000E+04, 8.7005404494E+00, 5.4160233244E+00, 1.0014964859E+00, 7.7036946227E-01, 7.2132053576E-01],
	[1.6965000000E+04, 8.7041686020E+00, 5.4157909501E+00, 1.0024332266E+00, 7.7094737466E-01, 7.2143851495E-01],
	[1.6970000000E+04, 8.7077971977E+00, 5.4155586543E+00, 1.0033705665E+00, 7.7152545289E-01, 7.2155645973E-01],
	[1.6975000000E+04, 8.7114262365E+00, 5.4153264369E+00, 1.0043085058E+00, 7.7210369681E-01, 7.2167437008E-01],
	[1.6980000000E+04, 8.7150557183E+00, 5.4150942979E+00, 1.0052470446E+00, 7.7268210626E-01, 7.2179224600E-01],
	[1.6985000000E+04, 8.7186856430E+00, 5.4148622371E+00, 1.0061861832E+00, 7.7326068112E-01, 7.2191008747E-01],
	[1.6990000000E+04, 8.7223160105E+00, 5.4146302545E+00, 1.0071259219E+00, 7.7383942124E-01, 7.2202789449E-01],
	[1.6995000000E+04, 8.7259468207E+00, 5.4143983502E+00, 1.0080662607E+00, 7.7441832646E-01, 7.2214566705E-01],
	[1.7000000000E+04, 8.7295780737E+00, 5.4141665240E+00, 1.0090071999E+00, 7.7499739665E-01, 7.2226340514E-01],
	[1.7005000000E+04, 8.7332097692E+00, 5.4139347759E+00, 1.0099487398E+00, 7.7557663167E-01, 7.2238110874E-01],
	[1.7010000000E+04, 8.7368419073E+00, 5.4137031059E+00, 1.0108908805E+00, 7.7615603137E-01, 7.2249877786E-01],
	[1.7015000000E+04, 8.7404744878E+00, 5.4134715138E+00, 1.0118336222E+00, 7.7673559559E-01, 7.2261641248E-01],
	[1.7020000000E+04, 8.7441075107E+00, 5.4132399997E+00, 1.0127769651E+00, 7.7731532421E-01, 7.2273401260E-01],
	[1.7025000000E+04, 8.7477409759E+00, 5.4130085635E+00, 1.0137209095E+00, 7.7789521708E-01, 7.2285157820E-01],
	[1.7030000000E+04, 8.7513748832E+00, 5.4127772052E+00, 1.0146654555E+00, 7.7847527405E-01, 7.2296910927E-01],
	[1.7035000000E+04, 8.7550092328E+00, 5.4125459246E+00, 1.0156106033E+00, 7.7905549497E-01, 7.2308660581E-01],
	[1.7040000000E+04, 8.7586440244E+00, 5.4123147218E+00, 1.0165563532E+00, 7.7963587971E-01, 7.2320406781E-01],
	[1.7045000000E+04, 8.7622792580E+00, 5.4120835967E+00, 1.0175027054E+00, 7.8021642811E-01, 7.2332149526E-01],
	[1.7050000000E+04, 8.7659149335E+00, 5.4118525492E+00, 1.0184496601E+00, 7.8079714003E-01, 7.2343888815E-01],
	[1.7055000000E+04, 8.7695510509E+00, 5.4116215794E+00, 1.0193972174E+00, 7.8137801533E-01, 7.2355624647E-01],
	[1.7060000000E+04, 8.7731876100E+00, 5.4113906871E+00, 1.0203453776E+00, 7.8195905387E-01, 7.2367357021E-01],
	[1.7065000000E+04, 8.7768246108E+00, 5.4111598723E+00, 1.0212941409E+00, 7.8254025549E-01, 7.2379085937E-01],
	[1.7070000000E+04, 8.7804620532E+00, 5.4109291350E+00, 1.0222435075E+00, 7.8312162005E-01, 7.2390811394E-01],
	[1.7075000000E+04, 8.7840999372E+00, 5.4106984751E+00, 1.0231934775E+00, 7.8370314741E-01, 7.2402533390E-01],
	[1.7080000000E+04, 8.7877382626E+00, 5.4104678926E+00, 1.0241440513E+00, 7.8428483742E-01, 7.2414251925E-01],
	[1.7085000000E+04, 8.7913770294E+00, 5.4102373873E+00, 1.0250952290E+00, 7.8486668994E-01, 7.2425966998E-01],
	[1.7090000000E+04, 8.7950162375E+00, 5.4100069594E+00, 1.0260470108E+00, 7.8544870482E-01, 7.2437678608E-01],
	[1.7095000000E+04, 8.7986558868E+00, 5.4097766086E+00, 1.0269993970E+00, 7.8603088191E-01, 7.2449386754E-01],
	[1.7100000000E+04, 8.8022959773E+00, 5.4095463350E+00, 1.0279523876E+00, 7.8661322107E-01, 7.2461091437E-01],
	[1.7105000000E+04, 8.8059471194E+00, 5.4093203687E+00, 1.0289059830E+00, 7.8719589653E-01, 7.2472792653E-01],
	[1.7110000000E+04, 8.8096022094E+00, 5.4090958730E+00, 1.0298601834E+00, 7.8777879176E-01, 7.2484490404E-01],
	[1.7115000000E+04, 8.8132577480E+00, 5.4088714523E+00, 1.0308149889E+00, 7.8836184916E-01, 7.2496184687E-01],
	[1.7120000000E+04, 8.8169137349E+00, 5.4086471064E+00, 1.0317703997E+00, 7.8894506858E-01, 7.2507875503E-01],
	[1.7125000000E+04, 8.8205701703E+00, 5.4084228353E+00, 1.0327264161E+00, 7.8952844988E-01, 7.2519562850E-01],
	[1.7130000000E+04, 8.8242270538E+00, 5.4081986390E+00, 1.0336830383E+00, 7.9011199292E-01, 7.2531246728E-01],
	[1.7135000000E+04, 8.8278843856E+00, 5.4079745175E+00, 1.0346402665E+00, 7.9069569754E-01, 7.2542927135E-01],
	[1.7140000000E+04, 8.8315421655E+00, 5.4077504705E+00, 1.0355981008E+00, 7.9127956360E-01, 7.2554604071E-01],
	[1.7145000000E+04, 8.8352003934E+00, 5.4075264983E+00, 1.0365565415E+00, 7.9186359095E-01, 7.2566277536E-01],
	[1.7150000000E+04, 8.8388590693E+00, 5.4073026006E+00, 1.0375155888E+00, 7.9244777945E-01, 7.2577947527E-01],
	[1.7155000000E+04, 8.8425181931E+00, 5.4070787774E+00, 1.0384752430E+00, 7.9303212896E-01, 7.2589614045E-01],
	[1.7160000000E+04, 8.8461777647E+00, 5.4068550287E+00, 1.0394355041E+00, 7.9361663933E-01, 7.2601277089E-01],
	[1.7165000000E+04, 8.8498377841E+00, 5.4066313545E+00, 1.0403963724E+00, 7.9420131040E-01, 7.2612936658E-01],
	[1.7170000000E+04, 8.8534982511E+00, 5.4064077546E+00, 1.0413578482E+00, 7.9478614204E-01, 7.2624592751E-01],
	[1.7175000000E+04, 8.8571591657E+00, 5.4061842291E+00, 1.0423199315E+00, 7.9537113410E-01, 7.2636245367E-01],
	[1.7180000000E+04, 8.8608205278E+00, 5.4059607779E+00, 1.0432826227E+00, 7.9595628644E-01, 7.2647894505E-01],
	[1.7185000000E+04, 8.8644823373E+00, 5.4057374010E+00, 1.0442459220E+00, 7.9654159889E-01, 7.2659540166E-01],
	[1.7190000000E+04, 8.8681445942E+00, 5.4055140982E+00, 1.0452098295E+00, 7.9712707133E-01, 7.2671182347E-01],
	[1.7195000000E+04, 8.8718072984E+00, 5.4052908697E+00, 1.0461743454E+00, 7.9771270361E-01, 7.2682821048E-01],
	[1.7200000000E+04, 8.8754704498E+00, 5.4050677152E+00, 1.0471394700E+00, 7.9829849557E-01, 7.2694456269E-01],
	[1.7205000000E+04, 8.8791340483E+00, 5.4048446348E+00, 1.0481052034E+00, 7.9888444707E-01, 7.2706088009E-01],
	[1.7210000000E+04, 8.8827980939E+00, 5.4046216285E+00, 1.0490715460E+00, 7.9947055797E-01, 7.2717716266E-01],
	[1.7215000000E+04, 8.8864625864E+00, 5.4043986961E+00, 1.0500384978E+00, 8.0005682811E-01, 7.2729341041E-01],
	[1.7220000000E+04, 8.8901275259E+00, 5.4041758376E+00, 1.0510060590E+00, 8.0064325736E-01, 7.2740962331E-01],
	[1.7225000000E+04, 8.8937929122E+00, 5.4039530530E+00, 1.0519742300E+00, 8.0122984556E-01, 7.2752580138E-01],
	[1.7230000000E+04, 8.8974587453E+00, 5.4037303423E+00, 1.0529430109E+00, 8.0181659256E-01, 7.2764194459E-01],
	[1.7235000000E+04, 8.9011250250E+00, 5.4035077054E+00, 1.0539124018E+00, 8.0240349823E-01, 7.2775805294E-01],
	[1.7240000000E+04, 8.9047917513E+00, 5.4032851422E+00, 1.0548824031E+00, 8.0299056241E-01, 7.2787412643E-01],
	[1.7245000000E+04, 8.9084589242E+00, 5.4030626527E+00, 1.0558530149E+00, 8.0357778495E-01, 7.2799016504E-01],
	[1.7250000000E+04, 8.9121265436E+00, 5.4028402369E+00, 1.0568242374E+00, 8.0416516571E-01, 7.2810616877E-01],
	[1.7255000000E+04, 8.9157946093E+00, 5.4026178946E+00, 1.0577960709E+00, 8.0475270455E-01, 7.2822213761E-01],
	[1.7260000000E+04, 8.9194631213E+00, 5.4023956260E+00, 1.0587685154E+00, 8.0534040131E-01, 7.2833807156E-01],
	[1.7265000000E+04, 8.9231320796E+00, 5.4021734309E+00, 1.0597415713E+00, 8.0592825584E-01, 7.2845397060E-01],
	[1.7270000000E+04, 8.9268014840E+00, 5.4019513092E+00, 1.0607152388E+00, 8.0651626801E-01, 7.2856983473E-01],
	[1.7275000000E+04, 8.9304713345E+00, 5.4017292610E+00, 1.0616895180E+00, 8.0710443765E-01, 7.2868566394E-01],
	[1.7280000000E+04, 8.9341416310E+00, 5.4015072861E+00, 1.0626644092E+00, 8.0769276463E-01, 7.2880145823E-01],
	[1.7285000000E+04, 8.9378123734E+00, 5.4012853846E+00, 1.0636399125E+00, 8.0828124880E-01, 7.2891721758E-01],
	[1.7290000000E+04, 8.9414835617E+00, 5.4010635564E+00, 1.0646160282E+00, 8.0886989000E-01, 7.2903294200E-01],
	[1.7295000000E+04, 8.9451551957E+00, 5.4008418014E+00, 1.0655927565E+00, 8.0945868810E-01, 7.2914863146E-01],
	[1.7300000000E+04, 8.9488272755E+00, 5.4006201196E+00, 1.0665700976E+00, 8.1004764294E-01, 7.2926428598E-01],
	[1.7305000000E+04, 8.9524998009E+00, 5.4003985110E+00, 1.0675480517E+00, 8.1063675438E-01, 7.2937990553E-01],
	[1.7310000000E+04, 8.9561727719E+00, 5.4001769755E+00, 1.0685266190E+00, 8.1122602226E-01, 7.2949549011E-01],
	[1.7315000000E+04, 8.9598461883E+00, 5.3999555131E+00, 1.0695057996E+00, 8.1181544644E-01, 7.2961103972E-01],
	[1.7320000000E+04, 8.9635200502E+00, 5.3997341237E+00, 1.0704855939E+00, 8.1240502677E-01, 7.2972655435E-01],
	[1.7325000000E+04, 8.9671943574E+00, 5.3995128072E+00, 1.0714660021E+00, 8.1299476311E-01, 7.2984203399E-01],
	[1.7330000000E+04, 8.9708691098E+00, 5.3992915637E+00, 1.0724470242E+00, 8.1358465530E-01, 7.2995747863E-01],
	[1.7335000000E+04, 8.9745443075E+00, 5.3990703931E+00, 1.0734286606E+00, 8.1417470319E-01, 7.3007288827E-01],
	[1.7340000000E+04, 8.9782199502E+00, 5.3988492953E+00, 1.0744109114E+00, 8.1476490665E-01, 7.3018826290E-01],
	[1.7345000000E+04, 8.9818960380E+00, 5.3986282703E+00, 1.0753937768E+00, 8.1535526551E-01, 7.3030360251E-01],
	[1.7350000000E+04, 8.9855725707E+00, 5.3984073180E+00, 1.0763772572E+00, 8.1594577963E-01, 7.3041890710E-01],
	[1.7355000000E+04, 8.9892495484E+00, 5.3981864385E+00, 1.0773613525E+00, 8.1653644887E-01, 7.3053417666E-01],
	[1.7360000000E+04, 8.9929269708E+00, 5.3979656316E+00, 1.0783460632E+00, 8.1712727307E-01, 7.3064941118E-01],
	[1.7365000000E+04, 8.9966048380E+00, 5.3977448973E+00, 1.0793313893E+00, 8.1771825208E-01, 7.3076461066E-01],
	[1.7370000000E+04, 9.0002831498E+00, 5.3975242356E+00, 1.0803173311E+00, 8.1830938577E-01, 7.3087977509E-01],
	[1.7375000000E+04, 9.0039619062E+00, 5.3973036465E+00, 1.0813038888E+00, 8.1890067396E-01, 7.3099490446E-01],
	[1.7380000000E+04, 9.0076512129E+00, 5.3970869508E+00, 1.0822910625E+00, 8.1949228827E-01, 7.3110999877E-01],
	[1.7385000000E+04, 9.0113454981E+00, 5.3968720377E+00, 1.0832788526E+00, 8.2008413421E-01, 7.3122505801E-01],
	[1.7390000000E+04, 9.0150402354E+00, 5.3966571950E+00, 1.0842672592E+00, 8.2067613477E-01, 7.3134008217E-01],
	[1.7395000000E+04, 9.0187354247E+00, 5.3964424226E+00, 1.0852562825E+00, 8.2126828982E-01, 7.3145507125E-01],
	[1.7400000000E+04, 9.0224310661E+00, 5.3962277204E+00, 1.0862459227E+00, 8.2186059920E-01, 7.3157002524E-01],
	[1.7405000000E+04, 9.0261271593E+00, 5.3960130885E+00, 1.0872361801E+00, 8.2245306276E-01, 7.3168494413E-01],
	[1.7410000000E+04, 9.0298237044E+00, 5.3957985268E+00, 1.0882270547E+00, 8.2304568036E-01, 7.3179982792E-01],
	[1.7415000000E+04, 9.0335207012E+00, 5.3955840352E+00, 1.0892185470E+00, 8.2363845184E-01, 7.3191467661E-01],
	[1.7420000000E+04, 9.0372181498E+00, 5.3953696137E+00, 1.0902106569E+00, 8.2423137705E-01, 7.3202949018E-01],
	[1.7425000000E+04, 9.0409160499E+00, 5.3951552622E+00, 1.0912033849E+00, 8.2482445586E-01, 7.3214426862E-01],
	[1.7430000000E+04, 9.0446144016E+00, 5.3949409808E+00, 1.0921967309E+00, 8.2541768810E-01, 7.3225901194E-01],
	[1.7435000000E+04, 9.0483132048E+00, 5.3947267693E+00, 1.0931906954E+00, 8.2601107364E-01, 7.3237372013E-01],
	[1.7440000000E+04, 9.0520124593E+00, 5.3945126278E+00, 1.0941852784E+00, 8.2660461231E-01, 7.3248839317E-01],
	[1.7445000000E+04, 9.0557121652E+00, 5.3942985561E+00, 1.0951804802E+00, 8.2719830397E-01, 7.3260303107E-01],
	[1.7450000000E+04, 9.0594123223E+00, 5.3940845543E+00, 1.0961763010E+00, 8.2779214848E-01, 7.3271763382E-01],
	[1.7455000000E+04, 9.0631129306E+00, 5.3938706223E+00, 1.0971727410E+00, 8.2838614568E-01, 7.3283220141E-01],
	[1.7460000000E+04, 9.0668139899E+00, 5.3936567600E+00, 1.0981698004E+00, 8.2898029542E-01, 7.3294673383E-01],
	[1.7465000000E+04, 9.0705155003E+00, 5.3934429674E+00, 1.0991674795E+00, 8.2957459756E-01, 7.3306123108E-01],
	[1.7470000000E+04, 9.0742174616E+00, 5.3932292445E+00, 1.1001657783E+00, 8.3016905194E-01, 7.3317569316E-01],
	[1.7475000000E+04, 9.0779198738E+00, 5.3930155912E+00, 1.1011646971E+00, 8.3076365841E-01, 7.3329012005E-01],
	[1.7480000000E+04, 9.0816227368E+00, 5.3928020076E+00, 1.1021642362E+00, 8.3135841683E-01, 7.3340451175E-01],
	[1.7485000000E+04, 9.0853260505E+00, 5.3925884934E+00, 1.1031643957E+00, 8.3195332705E-01, 7.3351886826E-01],
	[1.7490000000E+04, 9.0890298149E+00, 5.3923750488E+00, 1.1041651759E+00, 8.3254838891E-01, 7.3363318957E-01],
	[1.7495000000E+04, 9.0927340298E+00, 5.3921616736E+00, 1.1051665769E+00, 8.3314360227E-01, 7.3374747567E-01],
	[1.7500000000E+04, 9.0964386952E+00, 5.3919483678E+00, 1.1061685990E+00, 8.3373896697E-01, 7.3386172656E-01],
	[1.7505000000E+04, 9.1001438111E+00, 5.3917351314E+00, 1.1071794062E+00, 8.3433911888E-01, 7.3397594223E-01],
	[1.7510000000E+04, 9.1038493773E+00, 5.3915219643E+00, 1.1081908474E+00, 8.3493942539E-01, 7.3409012268E-01],
	[1.7515000000E+04, 9.1075553938E+00, 5.3913088665E+00, 1.1092029228E+00, 8.3553988632E-01, 7.3420426790E-01],
	[1.7520000000E+04, 9.1112618604E+00, 5.3910958379E+00, 1.1102156327E+00, 8.3614050154E-01, 7.3431837788E-01],
	[1.7525000000E+04, 9.1149687773E+00, 5.3908828786E+00, 1.1112289772E+00, 8.3674127089E-01, 7.3443245262E-01],
	[1.7530000000E+04, 9.1186761441E+00, 5.3906699884E+00, 1.1122429567E+00, 8.3734219421E-01, 7.3454649211E-01],
	[1.7535000000E+04, 9.1223839610E+00, 5.3904571673E+00, 1.1132575712E+00, 8.3794327136E-01, 7.3466049635E-01],
	[1.7540000000E+04, 9.1260922278E+00, 5.3902444153E+00, 1.1142728210E+00, 8.3854450217E-01, 7.3477446534E-01],
	[1.7545000000E+04, 9.1298009444E+00, 5.3900317323E+00, 1.1152887064E+00, 8.3914588649E-01, 7.3488839905E-01],
	[1.7550000000E+04, 9.1335101107E+00, 5.3898191183E+00, 1.1163052274E+00, 8.3974742418E-01, 7.3500229750E-01],
	[1.7555000000E+04, 9.1372197268E+00, 5.3896065733E+00, 1.1173223845E+00, 8.4034911508E-01, 7.3511616068E-01],
	[1.7560000000E+04, 9.1409297924E+00, 5.3893940971E+00, 1.1183401777E+00, 8.4095095903E-01, 7.3522998857E-01],
	[1.7565000000E+04, 9.1446403076E+00, 5.3891816899E+00, 1.1193586073E+00, 8.4155295588E-01, 7.3534378118E-01],
	[1.7570000000E+04, 9.1483512723E+00, 5.3889693514E+00, 1.1203776736E+00, 8.4215510547E-01, 7.3545753850E-01],
	[1.7575000000E+04, 9.1520626864E+00, 5.3887570818E+00, 1.1213973766E+00, 8.4275740766E-01, 7.3557126052E-01],
	[1.7580000000E+04, 9.1557745498E+00, 5.3885448809E+00, 1.1224177167E+00, 8.4335986229E-01, 7.3568494724E-01],
	[1.7585000000E+04, 9.1594868624E+00, 5.3883327486E+00, 1.1234386940E+00, 8.4396246920E-01, 7.3579859865E-01],
	[1.7590000000E+04, 9.1631996242E+00, 5.3881206851E+00, 1.1244603089E+00, 8.4456522824E-01, 7.3591221474E-01],
	[1.7595000000E+04, 9.1669128351E+00, 5.3879086901E+00, 1.1254825614E+00, 8.4516813926E-01, 7.3602579552E-01],
	[1.7600000000E+04, 9.1706264951E+00, 5.3876967637E+00, 1.1265054518E+00, 8.4577120210E-01, 7.3613934098E-01],
	[1.7605000000E+04, 9.1743406039E+00, 5.3874849059E+00, 1.1275289803E+00, 8.4637441661E-01, 7.3625285111E-01],
	[1.7610000000E+04, 9.1780551617E+00, 5.3872731165E+00, 1.1285531471E+00, 8.4697778263E-01, 7.3636632590E-01],
	[1.7615000000E+04, 9.1817701683E+00, 5.3870613956E+00, 1.1295779525E+00, 8.4758130001E-01, 7.3647976536E-01],
	[1.7620000000E+04, 9.1854856236E+00, 5.3868497431E+00, 1.1306033967E+00, 8.4818496860E-01, 7.3659316947E-01],
	[1.7625000000E+04, 9.1892015276E+00, 5.3866381589E+00, 1.1316294799E+00, 8.4878878823E-01, 7.3670653823E-01],
	[1.7630000000E+04, 9.1929178801E+00, 5.3864266431E+00, 1.1326562022E+00, 8.4939275876E-01, 7.3681987164E-01],
	[1.7635000000E+04, 9.1966346812E+00, 5.3862151955E+00, 1.1336835640E+00, 8.4999688003E-01, 7.3693316969E-01],
	[1.7640000000E+04, 9.2003519307E+00, 5.3860038162E+00, 1.1347115654E+00, 8.5060115189E-01, 7.3704643237E-01],
	[1.7645000000E+04, 9.2040696286E+00, 5.3857925051E+00, 1.1357402066E+00, 8.5120557418E-01, 7.3715965968E-01],
	[1.7650000000E+04, 9.2077877748E+00, 5.3855812622E+00, 1.1367694880E+00, 8.5181014675E-01, 7.3727285162E-01],
	[1.7655000000E+04, 9.2115063692E+00, 5.3853700873E+00, 1.1377994096E+00, 8.5241486944E-01, 7.3738600832E-01],
	[1.7660000000E+04, 9.2152366324E+00, 5.3851630267E+00, 1.1388299717E+00, 8.5301993976E-01, 7.3749912986E-01],
	[1.7665000000E+04, 9.2189712349E+00, 5.3849574330E+00, 1.1398611745E+00, 8.5362522883E-01, 7.3761221625E-01],
	[1.7670000000E+04, 9.2227062934E+00, 5.3847519054E+00, 1.1408930182E+00, 8.5423066814E-01, 7.3772526747E-01],
	[1.7675000000E+04, 9.2264418077E+00, 5.3845464437E+00, 1.1419255031E+00, 8.5483625755E-01, 7.3783828354E-01],
	[1.7680000000E+04, 9.2301777778E+00, 5.3843410480E+00, 1.1429586293E+00, 8.5544199688E-01, 7.3795126443E-01],
	[1.7685000000E+04, 9.2339142037E+00, 5.3841357183E+00, 1.1439923972E+00, 8.5604788600E-01, 7.3806421014E-01],
	[1.7690000000E+04, 9.2376510851E+00, 5.3839304543E+00, 1.1450268068E+00, 8.5665392474E-01, 7.3817712067E-01],
	[1.7695000000E+04, 9.2413884222E+00, 5.3837252563E+00, 1.1460618584E+00, 8.5726011295E-01, 7.3828999601E-01],
	[1.7700000000E+04, 9.2451262148E+00, 5.3835201240E+00, 1.1470975523E+00, 8.5786645048E-01, 7.3840283615E-01],
	[1.7705000000E+04, 9.2488644628E+00, 5.3833150574E+00, 1.1481338886E+00, 8.5847293716E-01, 7.3851564110E-01],
	[1.7710000000E+04, 9.2526031661E+00, 5.3831100566E+00, 1.1491708675E+00, 8.5907957285E-01, 7.3862841083E-01],
	[1.7715000000E+04, 9.2563423248E+00, 5.3829051214E+00, 1.1502084894E+00, 8.5968635739E-01, 7.3874114535E-01],
	[1.7720000000E+04, 9.2600819386E+00, 5.3827002519E+00, 1.1512467543E+00, 8.6029329063E-01, 7.3885384466E-01],
	[1.7725000000E+04, 9.2638220076E+00, 5.3824954480E+00, 1.1522856625E+00, 8.6090037240E-01, 7.3896650874E-01],
	[1.7730000000E+04, 9.2675625317E+00, 5.3822907096E+00, 1.1533252143E+00, 8.6150760256E-01, 7.3907913759E-01],
	[1.7735000000E+04, 9.2713035107E+00, 5.3820860367E+00, 1.1543654098E+00, 8.6211498095E-01, 7.3919173121E-01],
	[1.7740000000E+04, 9.2750449447E+00, 5.3818814293E+00, 1.1554062493E+00, 8.6272250742E-01, 7.3930428958E-01],
	[1.7745000000E+04, 9.2787868335E+00, 5.3816768874E+00, 1.1564477329E+00, 8.6333018180E-01, 7.3941681271E-01],
	[1.7750000000E+04, 9.2825291771E+00, 5.3814724108E+00, 1.1574898610E+00, 8.6393800394E-01, 7.3952930058E-01],
	[1.7755000000E+04, 9.2862719754E+00, 5.3812679996E+00, 1.1585326336E+00, 8.6454597370E-01, 7.3964175320E-01],
	[1.7760000000E+04, 9.2900152283E+00, 5.3810636537E+00, 1.1595760511E+00, 8.6515409090E-01, 7.3975417055E-01],
	[1.7765000000E+04, 9.2937589358E+00, 5.3808593731E+00, 1.1606201136E+00, 8.6576235541E-01, 7.3986655264E-01],
	[1.7770000000E+04, 9.2975030977E+00, 5.3806551577E+00, 1.1616648213E+00, 8.6637076705E-01, 7.3997889945E-01],
	[1.7775000000E+04, 9.3012477141E+00, 5.3804510076E+00, 1.1627101746E+00, 8.6697932568E-01, 7.4009121099E-01],
	[1.7780000000E+04, 9.3049927848E+00, 5.3802469226E+00, 1.1637561735E+00, 8.6758803114E-01, 7.4020348723E-01],
	[1.7785000000E+04, 9.3087383098E+00, 5.3800429027E+00, 1.1648028183E+00, 8.6819688327E-01, 7.4031572819E-01],
	[1.7790000000E+04, 9.3124842889E+00, 5.3798389479E+00, 1.1658501093E+00, 8.6880588192E-01, 7.4042793386E-01],
	[1.7795000000E+04, 9.3162307222E+00, 5.3796350581E+00, 1.1668980466E+00, 8.6941502693E-01, 7.4054010422E-01],
	[1.7800000000E+04, 9.3199776095E+00, 5.3794312334E+00, 1.1679466304E+00, 8.7002431815E-01, 7.4065223927E-01],
	[1.7805000000E+04, 9.3237249508E+00, 5.3792274736E+00, 1.1689958610E+00, 8.7063375542E-01, 7.4076433902E-01],
	[1.7810000000E+04, 9.3274727460E+00, 5.3790237787E+00, 1.1700457387E+00, 8.7124333858E-01, 7.4087640345E-01],
	[1.7815000000E+04, 9.3312209951E+00, 5.3788201487E+00, 1.1710962635E+00, 8.7185306748E-01, 7.4098843256E-01],
	[1.7820000000E+04, 9.3349696978E+00, 5.3786165836E+00, 1.1721474357E+00, 8.7246294196E-01, 7.4110042634E-01],
	[1.7825000000E+04, 9.3387188543E+00, 5.3784130833E+00, 1.1731992556E+00, 8.7307296187E-01, 7.4121238479E-01],
	[1.7830000000E+04, 9.3424684644E+00, 5.3782096477E+00, 1.1742517233E+00, 8.7368312704E-01, 7.4132430790E-01],
	[1.7835000000E+04, 9.3462185280E+00, 5.3780062769E+00, 1.1753048391E+00, 8.7429343733E-01, 7.4143619568E-01],
	[1.7840000000E+04, 9.3499690451E+00, 5.3778029708E+00, 1.1763586032E+00, 8.7490389257E-01, 7.4154804810E-01],
	[1.7845000000E+04, 9.3537200156E+00, 5.3775997293E+00, 1.1774130159E+00, 8.7551449262E-01, 7.4165986518E-01],
	[1.7850000000E+04, 9.3574714394E+00, 5.3773965525E+00, 1.1784680772E+00, 8.7612523730E-01, 7.4177164689E-01],
	[1.7855000000E+04, 9.3612233165E+00, 5.3771934402E+00, 1.1795237874E+00, 8.7673612648E-01, 7.4188339325E-01],
	[1.7860000000E+04, 9.3649756467E+00, 5.3769903925E+00, 1.1805801469E+00, 8.7734715998E-01, 7.4199510424E-01],
	[1.7865000000E+04, 9.3687284300E+00, 5.3767874092E+00, 1.1816371557E+00, 8.7795833766E-01, 7.4210677986E-01],
	[1.7870000000E+04, 9.3724816664E+00, 5.3765844905E+00, 1.1826948141E+00, 8.7856965935E-01, 7.4221842010E-01],
	[1.7875000000E+04, 9.3762353557E+00, 5.3763816361E+00, 1.1837531222E+00, 8.7918112490E-01, 7.4233002497E-01],
	[1.7880000000E+04, 9.3799894980E+00, 5.3761788461E+00, 1.1848120805E+00, 8.7979273416E-01, 7.4244159444E-01],
	[1.7885000000E+04, 9.3837440930E+00, 5.3759761205E+00, 1.1858716889E+00, 8.8040448696E-01, 7.4255312853E-01],
	[1.7890000000E+04, 9.3874991408E+00, 5.3757734592E+00, 1.1869319478E+00, 8.8101638315E-01, 7.4266462722E-01],
	[1.7895000000E+04, 9.3912546413E+00, 5.3755708622E+00, 1.1879928574E+00, 8.8162842257E-01, 7.4277609052E-01],
	[1.7900000000E+04, 9.3950105943E+00, 5.3753683294E+00, 1.1890544179E+00, 8.8224060506E-01, 7.4288751841E-01],
	[1.7905000000E+04, 9.3987669999E+00, 5.3751658608E+00, 1.1901166295E+00, 8.8285293048E-01, 7.4299891089E-01],
	[1.7910000000E+04, 9.4025238580E+00, 5.3749634563E+00, 1.1911794924E+00, 8.8346539865E-01, 7.4311026795E-01],
	[1.7915000000E+04, 9.4062811684E+00, 5.3747611159E+00, 1.1922430068E+00, 8.8407800943E-01, 7.4322158960E-01],
	[1.7920000000E+04, 9.4100389312E+00, 5.3745588397E+00, 1.1933071730E+00, 8.8469076266E-01, 7.4333287583E-01],
	[1.7925000000E+04, 9.4137971462E+00, 5.3743566275E+00, 1.1943719912E+00, 8.8530365817E-01, 7.4344412663E-01],
	[1.7930000000E+04, 9.4175558134E+00, 5.3741544792E+00, 1.1954374615E+00, 8.8591669581E-01, 7.4355534200E-01],
	[1.7935000000E+04, 9.4213149326E+00, 5.3739523950E+00, 1.1965035843E+00, 8.8652987543E-01, 7.4366652193E-01],
	[1.7940000000E+04, 9.4250745039E+00, 5.3737503746E+00, 1.1975703597E+00, 8.8714319687E-01, 7.4377766642E-01],
	[1.7945000000E+04, 9.4288484204E+00, 5.3735532179E+00, 1.1986377879E+00, 8.8775691412E-01, 7.4388877547E-01],
	[1.7950000000E+04, 9.4326244364E+00, 5.3733566898E+00, 1.1997058692E+00, 8.8837080346E-01, 7.4399984907E-01],
	[1.7955000000E+04, 9.4364009123E+00, 5.3731602236E+00, 1.2007746038E+00, 8.8898483475E-01, 7.4411088721E-01],
	[1.7960000000E+04, 9.4401778481E+00, 5.3729638193E+00, 1.2018439919E+00, 8.8959900783E-01, 7.4422188990E-01],
	[1.7965000000E+04, 9.4439552436E+00, 5.3727674769E+00, 1.2029140337E+00, 8.9021332256E-01, 7.4433285713E-01],
	[1.7970000000E+04, 9.4477330987E+00, 5.3725711963E+00, 1.2039847294E+00, 8.9082777876E-01, 7.4444378889E-01],
	[1.7975000000E+04, 9.4515114135E+00, 5.3723749774E+00, 1.2050560792E+00, 8.9144237628E-01, 7.4455468518E-01],
	[1.7980000000E+04, 9.4552901879E+00, 5.3721788203E+00, 1.2061280834E+00, 8.9205711497E-01, 7.4466554600E-01],
	[1.7985000000E+04, 9.4590694217E+00, 5.3719827249E+00, 1.2072007422E+00, 8.9267199467E-01, 7.4477637133E-01],
	[1.7990000000E+04, 9.4628491149E+00, 5.3717866911E+00, 1.2082740557E+00, 8.9328701522E-01, 7.4488716119E-01],
	[1.7995000000E+04, 9.4666292674E+00, 5.3715907190E+00, 1.2093480243E+00, 8.9390217646E-01, 7.4499791556E-01],
	[1.8000000000E+04, 9.4704098791E+00, 5.3713948084E+00, 1.2104226481E+00, 8.9451747824E-01, 7.4510863443E-01],
	[1.8005000000E+04, 9.4741909501E+00, 5.3711989595E+00, 1.2114979274E+00, 8.9513292040E-01, 7.4521931782E-01],
	[1.8010000000E+04, 9.4779724801E+00, 5.3710031720E+00, 1.2125738623E+00, 8.9574850278E-01, 7.4532996570E-01],
	[1.8015000000E+04, 9.4817544692E+00, 5.3708074460E+00, 1.2136504531E+00, 8.9636422522E-01, 7.4544057808E-01],
	[1.8020000000E+04, 9.4855369173E+00, 5.3706117815E+00, 1.2147277000E+00, 8.9698008756E-01, 7.4555115496E-01],
	[1.8025000000E+04, 9.4893198242E+00, 5.3704161783E+00, 1.2158056032E+00, 8.9759608966E-01, 7.4566169632E-01],
	[1.8030000000E+04, 9.4931031900E+00, 5.3702206366E+00, 1.2168841629E+00, 8.9821223134E-01, 7.4577220217E-01],
	[1.8035000000E+04, 9.4968870145E+00, 5.3700251561E+00, 1.2179633794E+00, 8.9882851245E-01, 7.4588267250E-01],
	[1.8040000000E+04, 9.5006712977E+00, 5.3698297370E+00, 1.2190432529E+00, 8.9944493284E-01, 7.4599310731E-01],
	[1.8045000000E+04, 9.5044560395E+00, 5.3696343792E+00, 1.2201237835E+00, 9.0006149234E-01, 7.4610350659E-01],
	[1.8050000000E+04, 9.5082412399E+00, 5.3694390825E+00, 1.2212049715E+00, 9.0067819081E-01, 7.4621387034E-01],
	[1.8055000000E+04, 9.5120268987E+00, 5.3692438471E+00, 1.2222868172E+00, 9.0129502807E-01, 7.4632419856E-01],
	[1.8060000000E+04, 9.5158130159E+00, 5.3690486728E+00, 1.2233693207E+00, 9.0191200397E-01, 7.4643449125E-01],
	[1.8065000000E+04, 9.5195995914E+00, 5.3688535596E+00, 1.2244524822E+00, 9.0252911836E-01, 7.4654474839E-01],
	[1.8070000000E+04, 9.5233866251E+00, 5.3686585076E+00, 1.2255363020E+00, 9.0314637107E-01, 7.4665496998E-01],
	[1.8075000000E+04, 9.5271741171E+00, 5.3684635165E+00, 1.2266207803E+00, 9.0376376195E-01, 7.4676515603E-01],
	[1.8080000000E+04, 9.5309620671E+00, 5.3682685865E+00, 1.2277059172E+00, 9.0438129083E-01, 7.4687530653E-01],
	[1.8085000000E+04, 9.5347504752E+00, 5.3680737174E+00, 1.2287917131E+00, 9.0499895757E-01, 7.4698542147E-01],
	[1.8090000000E+04, 9.5385393412E+00, 5.3678789093E+00, 1.2298781682E+00, 9.0561676200E-01, 7.4709550085E-01],
	[1.8095000000E+04, 9.5423286652E+00, 5.3676841621E+00, 1.2309652825E+00, 9.0623470396E-01, 7.4720554467E-01],
	[1.8100000000E+04, 9.5461184469E+00, 5.3674894758E+00, 1.2320530565E+00, 9.0685278330E-01, 7.4731555293E-01],
	[1.8105000000E+04, 9.5499086864E+00, 5.3672948503E+00, 1.2331414903E+00, 9.0747099985E-01, 7.4742552561E-01],
	[1.8110000000E+04, 9.5536993836E+00, 5.3671002856E+00, 1.2342305840E+00, 9.0808935347E-01, 7.4753546272E-01],
	[1.8115000000E+04, 9.5574905384E+00, 5.3669057816E+00, 1.2353203380E+00, 9.0870784398E-01, 7.4764536426E-01],
	[1.8120000000E+04, 9.5612821507E+00, 5.3667113384E+00, 1.2364107524E+00, 9.0932647123E-01, 7.4775523021E-01],
	[1.8125000000E+04, 9.5650742205E+00, 5.3665169558E+00, 1.2375018275E+00, 9.0994523506E-01, 7.4786506058E-01],
	[1.8130000000E+04, 9.5688667477E+00, 5.3663226340E+00, 1.2385935634E+00, 9.1056413532E-01, 7.4797485537E-01],
	[1.8135000000E+04, 9.5726597322E+00, 5.3661283727E+00, 1.2396859604E+00, 9.1118317184E-01, 7.4808461457E-01],
	[1.8140000000E+04, 9.5764531740E+00, 5.3659341720E+00, 1.2407790188E+00, 9.1180234447E-01, 7.4819433817E-01],
	[1.8145000000E+04, 9.5802470730E+00, 5.3657400319E+00, 1.2418727386E+00, 9.1242165304E-01, 7.4830402618E-01],
	[1.8150000000E+04, 9.5840414290E+00, 5.3655459522E+00, 1.2429671202E+00, 9.1304109740E-01, 7.4841367859E-01],
	[1.8155000000E+04, 9.5878362421E+00, 5.3653519331E+00, 1.2440621638E+00, 9.1366067739E-01, 7.4852329539E-01],
	[1.8160000000E+04, 9.5916315122E+00, 5.3651579744E+00, 1.2451578696E+00, 9.1428039285E-01, 7.4863287659E-01],
	[1.8165000000E+04, 9.5954272392E+00, 5.3649640760E+00, 1.2462542377E+00, 9.1490024362E-01, 7.4874242218E-01],
	[1.8170000000E+04, 9.5992234230E+00, 5.3647702381E+00, 1.2473512685E+00, 9.1552022954E-01, 7.4885193216E-01],
	[1.8175000000E+04, 9.6030200635E+00, 5.3645764605E+00, 1.2484489621E+00, 9.1614035046E-01, 7.4896140653E-01],
	[1.8180000000E+04, 9.6068171607E+00, 5.3643827432E+00, 1.2495473187E+00, 9.1676060621E-01, 7.4907084527E-01],
	[1.8185000000E+04, 9.6106147146E+00, 5.3641890861E+00, 1.2506463386E+00, 9.1738099663E-01, 7.4918024840E-01],
	[1.8190000000E+04, 9.6144127250E+00, 5.3639954893E+00, 1.2517460220E+00, 9.1800152156E-01, 7.4928961590E-01],
	[1.8195000000E+04, 9.6182111919E+00, 5.3638019527E+00, 1.2528463691E+00, 9.1862218085E-01, 7.4939894777E-01],
	[1.8200000000E+04, 9.6220101151E+00, 5.3636084762E+00, 1.2539473801E+00, 9.1924297434E-01, 7.4950824401E-01],
	[1.8205000000E+04, 9.6258094947E+00, 5.3634150599E+00, 1.2550490552E+00, 9.1986390186E-01, 7.4961750463E-01],
	[1.8210000000E+04, 9.6296093306E+00, 5.3632217036E+00, 1.2561513947E+00, 9.2048496326E-01, 7.4972672960E-01],
	[1.8215000000E+04, 9.6334096227E+00, 5.3630284074E+00, 1.2572543987E+00, 9.2110615837E-01, 7.4983591894E-01],
	[1.8220000000E+04, 9.6372103709E+00, 5.3628351712E+00, 1.2583580676E+00, 9.2172748705E-01, 7.4994507263E-01],
	[1.8225000000E+04, 9.6410115751E+00, 5.3626419950E+00, 1.2594624014E+00, 9.2234894912E-01, 7.5005419068E-01],
	[1.8230000000E+04, 9.6448153233E+00, 5.3624495704E+00, 1.2605674005E+00, 9.2297058405E-01, 7.5016327308E-01],
	[1.8235000000E+04, 9.6486334068E+00, 5.3622618012E+00, 1.2616730650E+00, 9.2359261564E-01, 7.5027231984E-01],
	[1.8240000000E+04, 9.6524519544E+00, 5.3620740901E+00, 1.2627793952E+00, 9.2421478077E-01, 7.5038133094E-01],
	[1.8245000000E+04, 9.6562709660E+00, 5.3618864370E+00, 1.2638863912E+00, 9.2483707930E-01, 7.5049030638E-01],
	[1.8250000000E+04, 9.6600904416E+00, 5.3616988419E+00, 1.2649940534E+00, 9.2545951106E-01, 7.5059924617E-01],
	[1.8255000000E+04, 9.6639103810E+00, 5.3615113048E+00, 1.2661023818E+00, 9.2608207589E-01, 7.5070815030E-01],
	[1.8260000000E+04, 9.6677307842E+00, 5.3613238255E+00, 1.2672113768E+00, 9.2670477362E-01, 7.5081701876E-01],
	[1.8265000000E+04, 9.6715516511E+00, 5.3611364042E+00, 1.2683210385E+00, 9.2732760412E-01, 7.5092585156E-01],
	[1.8270000000E+04, 9.6753729816E+00, 5.3609490406E+00, 1.2694313672E+00, 9.2795056720E-01, 7.5103464869E-01],
	[1.8275000000E+04, 9.6791947758E+00, 5.3607617349E+00, 1.2705423630E+00, 9.2857366272E-01, 7.5114341015E-01],
	[1.8280000000E+04, 9.6830170334E+00, 5.3605744870E+00, 1.2716540263E+00, 9.2919689051E-01, 7.5125213593E-01],
	[1.8285000000E+04, 9.6868397545E+00, 5.3603872969E+00, 1.2727663572E+00, 9.2982025041E-01, 7.5136082604E-01],
	[1.8290000000E+04, 9.6906629389E+00, 5.3602001644E+00, 1.2738793559E+00, 9.3044374227E-01, 7.5146948048E-01],
	[1.8295000000E+04, 9.6944865867E+00, 5.3600130896E+00, 1.2749930227E+00, 9.3106736592E-01, 7.5157809923E-01],
	[1.8300000000E+04, 9.6983106976E+00, 5.3598260725E+00, 1.2761073577E+00, 9.3169112121E-01, 7.5168668229E-01],
	[1.8305000000E+04, 9.7021352717E+00, 5.3596391130E+00, 1.2772223612E+00, 9.3231500798E-01, 7.5179522967E-01],
	[1.8310000000E+04, 9.7059603089E+00, 5.3594522110E+00, 1.2783380334E+00, 9.3293902605E-01, 7.5190374137E-01],
	[1.8315000000E+04, 9.7097858091E+00, 5.3592653666E+00, 1.2794543746E+00, 9.3356317529E-01, 7.5201221737E-01],
	[1.8320000000E+04, 9.7136117723E+00, 5.3590785798E+00, 1.2805713848E+00, 9.3418745552E-01, 7.5212065768E-01],
	[1.8325000000E+04, 9.7174381983E+00, 5.3588918504E+00, 1.2816890645E+00, 9.3481186659E-01, 7.5222906230E-01],
	[1.8330000000E+04, 9.7212650871E+00, 5.3587051784E+00, 1.2828074137E+00, 9.3543640833E-01, 7.5233743122E-01],
	[1.8335000000E+04, 9.7250924387E+00, 5.3585185639E+00, 1.2839264327E+00, 9.3606108059E-01, 7.5244576444E-01],
	[1.8340000000E+04, 9.7289202529E+00, 5.3583320067E+00, 1.2850461217E+00, 9.3668588321E-01, 7.5255406196E-01],
	[1.8345000000E+04, 9.7327485297E+00, 5.3581455069E+00, 1.2861664810E+00, 9.3731081602E-01, 7.5266232377E-01],
	[1.8350000000E+04, 9.7365772690E+00, 5.3579590644E+00, 1.2872875106E+00, 9.3793587887E-01, 7.5277054988E-01],
	[1.8355000000E+04, 9.7404064708E+00, 5.3577726792E+00, 1.2884092110E+00, 9.3856107159E-01, 7.5287874028E-01],
	[1.8360000000E+04, 9.7442361350E+00, 5.3575863512E+00, 1.2895315822E+00, 9.3918639403E-01, 7.5298689497E-01],
	[1.8365000000E+04, 9.7480662615E+00, 5.3574000804E+00, 1.2906546246E+00, 9.3981184603E-01, 7.5309501395E-01],
	[1.8370000000E+04, 9.7518968502E+00, 5.3572138668E+00, 1.2917783382E+00, 9.4043742742E-01, 7.5320309722E-01],
	[1.8375000000E+04, 9.7557279010E+00, 5.3570277104E+00, 1.2929027234E+00, 9.4106313805E-01, 7.5331114477E-01],
	[1.8380000000E+04, 9.7595594140E+00, 5.3568416111E+00, 1.2940277804E+00, 9.4168897775E-01, 7.5341915660E-01],
	[1.8385000000E+04, 9.7633913890E+00, 5.3566555688E+00, 1.2951535093E+00, 9.4231494637E-01, 7.5352713271E-01],
	[1.8390000000E+04, 9.7672238260E+00, 5.3564695836E+00, 1.2962799104E+00, 9.4294104374E-01, 7.5363507310E-01],
	[1.8395000000E+04, 9.7710567249E+00, 5.3562836555E+00, 1.2974069839E+00, 9.4356726970E-01, 7.5374297776E-01],
	[1.8400000000E+04, 9.7748900856E+00, 5.3560977843E+00, 1.2985347300E+00, 9.4419362410E-01, 7.5385084670E-01],
	[1.8405000000E+04, 9.7787239080E+00, 5.3559119700E+00, 1.2996631490E+00, 9.4482010677E-01, 7.5395867991E-01],
	[1.8410000000E+04, 9.7825581921E+00, 5.3557262127E+00, 1.3007922410E+00, 9.4544671756E-01, 7.5406647740E-01],
	[1.8415000000E+04, 9.7863929378E+00, 5.3555405122E+00, 1.3019220063E+00, 9.4607345629E-01, 7.5417423915E-01],
	[1.8420000000E+04, 9.7902281451E+00, 5.3553548686E+00, 1.3030524451E+00, 9.4670032282E-01, 7.5428196517E-01],
	[1.8425000000E+04, 9.7940638138E+00, 5.3551692819E+00, 1.3041835577E+00, 9.4732731698E-01, 7.5438965545E-01],
	[1.8430000000E+04, 9.7978999440E+00, 5.3549837519E+00, 1.3053153441E+00, 9.4795443860E-01, 7.5449731000E-01],
	[1.8435000000E+04, 9.8017365355E+00, 5.3547982786E+00, 1.3064478047E+00, 9.4858168754E-01, 7.5460492880E-01],
	[1.8440000000E+04, 9.8055735882E+00, 5.3546128621E+00, 1.3075809397E+00, 9.4920906362E-01, 7.5471251175E-01],
	[1.8445000000E+04, 9.8094111021E+00, 5.3544275023E+00, 1.3087147493E+00, 9.4983656670E-01, 7.5482005876E-01],
	[1.8450000000E+04, 9.8132490772E+00, 5.3542421991E+00, 1.3098492336E+00, 9.5046419660E-01, 7.5492756982E-01],
	[1.8455000000E+04, 9.8170875133E+00, 5.3540569525E+00, 1.3109843930E+00, 9.5109195316E-01, 7.5503504493E-01],
	[1.8460000000E+04, 9.8209264104E+00, 5.3538717625E+00, 1.3121202276E+00, 9.5171983623E-01, 7.5514248411E-01],
	[1.8465000000E+04, 9.8247657684E+00, 5.3536866291E+00, 1.3132567377E+00, 9.5234784565E-01, 7.5524988735E-01],
	[1.8470000000E+04, 9.8286055872E+00, 5.3535015522E+00, 1.3143939235E+00, 9.5297598125E-01, 7.5535725465E-01],
	[1.8475000000E+04, 9.8324458668E+00, 5.3533165318E+00, 1.3155317852E+00, 9.5360424287E-01, 7.5546458601E-01],
	[1.8480000000E+04, 9.8362866072E+00, 5.3531315679E+00, 1.3166703229E+00, 9.5423263035E-01, 7.5557188145E-01],
	[1.8485000000E+04, 9.8401278081E+00, 5.3529466604E+00, 1.3178095370E+00, 9.5486114354E-01, 7.5567914095E-01],
	[1.8490000000E+04, 9.8439694696E+00, 5.3527618092E+00, 1.3189494277E+00, 9.5548978226E-01, 7.5578636452E-01],
	[1.8495000000E+04, 9.8478115917E+00, 5.3525770145E+00, 1.3200899951E+00, 9.5611854636E-01, 7.5589355216E-01],
	[1.8500000000E+04, 9.8516541741E+00, 5.3523922760E+00, 1.3212312395E+00, 9.5674743568E-01, 7.5600070388E-01],
	[1.8505000000E+04, 9.8554972170E+00, 5.3522075939E+00, 1.3223731611E+00, 9.5737645005E-01, 7.5610781967E-01],
	[1.8510000000E+04, 9.8593407201E+00, 5.3520229680E+00, 1.3235157601E+00, 9.5800558932E-01, 7.5621489955E-01],
	[1.8515000000E+04, 9.8631846834E+00, 5.3518383984E+00, 1.3246590368E+00, 9.5863485332E-01, 7.5632194350E-01],
	[1.8520000000E+04, 9.8670291069E+00, 5.3516538849E+00, 1.3258029913E+00, 9.5926424190E-01, 7.5642895154E-01],
	[1.8525000000E+04, 9.8708811633E+00, 5.3514717061E+00, 1.3269476239E+00, 9.5989389602E-01, 7.5653592365E-01],
	[1.8530000000E+04, 9.8747429164E+00, 5.3512925142E+00, 1.3280929348E+00, 9.6052385648E-01, 7.5664285986E-01],
	[1.8535000000E+04, 9.8786051379E+00, 5.3511133767E+00, 1.3292389242E+00, 9.6115394169E-01, 7.5674976015E-01],
	[1.8540000000E+04, 9.8824678276E+00, 5.3509342935E+00, 1.3303855923E+00, 9.6178415147E-01, 7.5685662454E-01],
	[1.8545000000E+04, 9.8863309855E+00, 5.3507552646E+00, 1.3315329394E+00, 9.6241448567E-01, 7.5696345301E-01],
	[1.8550000000E+04, 9.8901946115E+00, 5.3505762900E+00, 1.3326809656E+00, 9.6304494413E-01, 7.5707024559E-01],
	[1.8555000000E+04, 9.8940587056E+00, 5.3503973696E+00, 1.3338296712E+00, 9.6367552668E-01, 7.5717700225E-01],
	[1.8560000000E+04, 9.8979232676E+00, 5.3502185033E+00, 1.3349790565E+00, 9.6430623317E-01, 7.5728372302E-01],
	[1.8565000000E+04, 9.9017882976E+00, 5.3500396912E+00, 1.3361291215E+00, 9.6493706342E-01, 7.5739040789E-01],
	[1.8570000000E+04, 9.9056537953E+00, 5.3498609332E+00, 1.3372798666E+00, 9.6556801729E-01, 7.5749705686E-01],
	[1.8575000000E+04, 9.9095197609E+00, 5.3496822294E+00, 1.3384312920E+00, 9.6619909462E-01, 7.5760366993E-01],
	[1.8580000000E+04, 9.9133861941E+00, 5.3495035796E+00, 1.3395833978E+00, 9.6683029523E-01, 7.5771024711E-01],
	[1.8585000000E+04, 9.9172530950E+00, 5.3493249838E+00, 1.3407361843E+00, 9.6746161896E-01, 7.5781678841E-01],
	[1.8590000000E+04, 9.9211204635E+00, 5.3491464420E+00, 1.3418896518E+00, 9.6809306567E-01, 7.5792329381E-01],
	[1.8595000000E+04, 9.9249882994E+00, 5.3489679542E+00, 1.3430438003E+00, 9.6872463518E-01, 7.5802976333E-01],
	[1.8600000000E+04, 9.9288566027E+00, 5.3487895204E+00, 1.3441986302E+00, 9.6935632734E-01, 7.5813619697E-01],
	[1.8605000000E+04, 9.9327253734E+00, 5.3486111404E+00, 1.3453541417E+00, 9.6998814198E-01, 7.5824259472E-01],
	[1.8610000000E+04, 9.9365946114E+00, 5.3484328143E+00, 1.3465103350E+00, 9.7062007894E-01, 7.5834895659E-01],
	[1.8615000000E+04, 9.9404643166E+00, 5.3482545421E+00, 1.3476672103E+00, 9.7125213807E-01, 7.5845528259E-01],
	[1.8620000000E+04, 9.9443344889E+00, 5.3480763237E+00, 1.3488247678E+00, 9.7188431919E-01, 7.5856157272E-01],
	[1.8625000000E+04, 9.9482051284E+00, 5.3478981591E+00, 1.3499830077E+00, 9.7251662215E-01, 7.5866782697E-01],
	[1.8630000000E+04, 9.9520762348E+00, 5.3477200482E+00, 1.3511419303E+00, 9.7314904678E-01, 7.5877404535E-01],
	[1.8635000000E+04, 9.9559478081E+00, 5.3475419911E+00, 1.3523015358E+00, 9.7378159294E-01, 7.5888022787E-01],
	[1.8640000000E+04, 9.9598198484E+00, 5.3473639876E+00, 1.3534618243E+00, 9.7441426044E-01, 7.5898637452E-01],
	[1.8645000000E+04, 9.9636923554E+00, 5.3471860379E+00, 1.3546227962E+00, 9.7504704914E-01, 7.5909248531E-01],
	[1.8650000000E+04, 9.9675653292E+00, 5.3470081417E+00, 1.3557844516E+00, 9.7567995886E-01, 7.5919856024E-01],
	[1.8655000000E+04, 9.9714387696E+00, 5.3468302992E+00, 1.3569467908E+00, 9.7631298946E-01, 7.5930459931E-01],
	[1.8660000000E+04, 9.9753126766E+00, 5.3466525102E+00, 1.3581098140E+00, 9.7694614076E-01, 7.5941060253E-01],
	[1.8665000000E+04, 9.9791870501E+00, 5.3464747748E+00, 1.3592735213E+00, 9.7757941261E-01, 7.5951656990E-01],
	[1.8670000000E+04, 9.9830618901E+00, 5.3462970928E+00, 1.3604379130E+00, 9.7821280484E-01, 7.5962250142E-01],
	[1.8675000000E+04, 9.9869371965E+00, 5.3461194644E+00, 1.3616029894E+00, 9.7884631729E-01, 7.5972839709E-01],
	[1.8680000000E+04, 9.9908129692E+00, 5.3459418894E+00, 1.3627687506E+00, 9.7947994981E-01, 7.5983425691E-01],
	[1.8685000000E+04, 9.9946892081E+00, 5.3457643679E+00, 1.3639351969E+00, 9.8011370222E-01, 7.5994008089E-01],
	[1.8690000000E+04, 9.9985659133E+00, 5.3455868997E+00, 1.3651023284E+00, 9.8074757437E-01, 7.6004586904E-01],
	[1.8695000000E+04, 1.0002443085E+01, 5.3454094849E+00, 1.3662701455E+00, 9.8138156609E-01, 7.6015162134E-01],
	[1.8700000000E+04, 1.0006320722E+01, 5.3452321234E+00, 1.3674386482E+00, 9.8201567723E-01, 7.6025733782E-01],
	[1.8705000000E+04, 1.0010198825E+01, 5.3450548152E+00, 1.3686078369E+00, 9.8264990762E-01, 7.6036301846E-01],
	[1.8710000000E+04, 1.0014077394E+01, 5.3448775603E+00, 1.3697777794E+00, 9.8328429193E-01, 7.6046866327E-01],
	[1.8715000000E+04, 1.0017956429E+01, 5.3447003586E+00, 1.3709485397E+00, 9.8391886284E-01, 7.6057427226E-01],
	[1.8720000000E+04, 1.0021835930E+01, 5.3445232101E+00, 1.3721199869E+00, 9.8455355259E-01, 7.6067984542E-01],
	[1.8725000000E+04, 1.0025715896E+01, 5.3443461148E+00, 1.3732921212E+00, 9.8518836101E-01, 7.6078538277E-01],
	[1.8730000000E+04, 1.0029596329E+01, 5.3441690727E+00, 1.3744649428E+00, 9.8582328794E-01, 7.6089088429E-01],
	[1.8735000000E+04, 1.0033477226E+01, 5.3439920837E+00, 1.3756384519E+00, 9.8645833322E-01, 7.6099635000E-01],
	[1.8740000000E+04, 1.0037358589E+01, 5.3438151477E+00, 1.3768126489E+00, 9.8709349668E-01, 7.6110177990E-01],
	[1.8745000000E+04, 1.0041240418E+01, 5.3436382648E+00, 1.3779875338E+00, 9.8772877818E-01, 7.6120717399E-01],
	[1.8750000000E+04, 1.0045122712E+01, 5.3434614350E+00, 1.3791631070E+00, 9.8836417753E-01, 7.6131253227E-01],
	[1.8755000000E+04, 1.0049005471E+01, 5.3432846581E+00, 1.3803393685E+00, 9.8899969459E-01, 7.6141785475E-01],
	[1.8760000000E+04, 1.0052888696E+01, 5.3431079342E+00, 1.3815163187E+00, 9.8963532918E-01, 7.6152314143E-01],
	[1.8765000000E+04, 1.0056772385E+01, 5.3429312633E+00, 1.3826939578E+00, 9.9027108115E-01, 7.6162839231E-01],
	[1.8770000000E+04, 1.0060656540E+01, 5.3427546452E+00, 1.3838722860E+00, 9.9090695033E-01, 7.6173360739E-01],
	[1.8775000000E+04, 1.0064541160E+01, 5.3425780801E+00, 1.3850513035E+00, 9.9154293656E-01, 7.6183878669E-01],
	[1.8780000000E+04, 1.0068426244E+01, 5.3424015677E+00, 1.3862310105E+00, 9.9217903969E-01, 7.6194393019E-01],
	[1.8785000000E+04, 1.0072311794E+01, 5.3422251082E+00, 1.3874114072E+00, 9.9281525954E-01, 7.6204903791E-01],
	[1.8790000000E+04, 1.0076197808E+01, 5.3420487015E+00, 1.3885924939E+00, 9.9345159595E-01, 7.6215410984E-01],
	[1.8795000000E+04, 1.0080084287E+01, 5.3418723476E+00, 1.3897742708E+00, 9.9408804876E-01, 7.6225914599E-01],
	[1.8800000000E+04, 1.0083971231E+01, 5.3416960463E+00, 1.3909567380E+00, 9.9472461782E-01, 7.6236414637E-01],
	[1.8805000000E+04, 1.0087858639E+01, 5.3415197978E+00, 1.3921398959E+00, 9.9536130295E-01, 7.6246911097E-01],
	[1.8810000000E+04, 1.0091746512E+01, 5.3413436020E+00, 1.3933237446E+00, 9.9599810399E-01, 7.6257403980E-01],
	[1.8815000000E+04, 1.0095634850E+01, 5.3411674587E+00, 1.3945082844E+00, 9.9663502079E-01, 7.6267893286E-01],
	[1.8820000000E+04, 1.0099523651E+01, 5.3409913681E+00, 1.3956935155E+00, 9.9727205318E-01, 7.6278379016E-01],
	[1.8825000000E+04, 1.0103426380E+01, 5.3408194316E+00, 1.3968794380E+00, 9.9790947551E-01, 7.6288861169E-01],
	[1.8830000000E+04, 1.0107332969E+01, 5.3406485789E+00, 1.3980660523E+00, 9.9854708283E-01, 7.6299339747E-01],
	[1.8835000000E+04, 1.0111240032E+01, 5.3404777770E+00, 1.3992533585E+00, 9.9918480592E-01, 7.6309814748E-01],
	[1.8840000000E+04, 1.0115147567E+01, 5.3403070258E+00, 1.4004413568E+00, 9.9982264462E-01, 7.6320286175E-01],
	[1.8845000000E+04, 1.0119055575E+01, 5.3401363255E+00, 1.4016300475E+00, 1.0004605988E+00, 7.6330754027E-01],
	[1.8850000000E+04, 1.0122964055E+01, 5.3399656759E+00, 1.4028194308E+00, 1.0010986682E+00, 7.6341218304E-01],
	[1.8855000000E+04, 1.0126873008E+01, 5.3397950769E+00, 1.4040095069E+00, 1.0017368528E+00, 7.6351679006E-01],
	[1.8860000000E+04, 1.0130782433E+01, 5.3396245287E+00, 1.4052002761E+00, 1.0023751523E+00, 7.6362136135E-01],
	[1.8865000000E+04, 1.0134692330E+01, 5.3394540311E+00, 1.4063917385E+00, 1.0030135666E+00, 7.6372589690E-01],
	[1.8870000000E+04, 1.0138602700E+01, 5.3392835842E+00, 1.4075838943E+00, 1.0036520956E+00, 7.6383039671E-01],
	[1.8875000000E+04, 1.0142513542E+01, 5.3391131878E+00, 1.4087767438E+00, 1.0042907390E+00, 7.6393486080E-01],
	[1.8880000000E+04, 1.0146424856E+01, 5.3389428421E+00, 1.4099702873E+00, 1.0049294968E+00, 7.6403928916E-01],
	[1.8885000000E+04, 1.0150336642E+01, 5.3387725468E+00, 1.4111645248E+00, 1.0055683687E+00, 7.6414368179E-01],
	[1.8890000000E+04, 1.0154248900E+01, 5.3386023021E+00, 1.4123594567E+00, 1.0062073546E+00, 7.6424803870E-01],
	[1.8895000000E+04, 1.0158161630E+01, 5.3384321078E+00, 1.4135550832E+00, 1.0068464543E+00, 7.6435235990E-01],
	[1.8900000000E+04, 1.0162074831E+01, 5.3382619640E+00, 1.4147514044E+00, 1.0074856677E+00, 7.6445664538E-01],
	[1.8905000000E+04, 1.0165988505E+01, 5.3380918706E+00, 1.4159484207E+00, 1.0081249946E+00, 7.6456089515E-01],
	[1.8910000000E+04, 1.0169902650E+01, 5.3379218277E+00, 1.4171461321E+00, 1.0087644348E+00, 7.6466510921E-01],
	[1.8915000000E+04, 1.0173817267E+01, 5.3377518351E+00, 1.4183445390E+00, 1.0094039882E+00, 7.6476928757E-01],
	[1.8920000000E+04, 1.0177732355E+01, 5.3375818928E+00, 1.4195436416E+00, 1.0100436546E+00, 7.6487343023E-01],
	[1.8925000000E+04, 1.0181647915E+01, 5.3374120009E+00, 1.4207434400E+00, 1.0106834339E+00, 7.6497753720E-01],
	[1.8930000000E+04, 1.0185563947E+01, 5.3372421592E+00, 1.4219439345E+00, 1.0113233258E+00, 7.6508160846E-01],
	[1.8935000000E+04, 1.0189480449E+01, 5.3370723678E+00, 1.4231451254E+00, 1.0119633303E+00, 7.6518564404E-01],
	[1.8940000000E+04, 1.0193397423E+01, 5.3369026266E+00, 1.4243470128E+00, 1.0126034472E+00, 7.6528964393E-01],
	[1.8945000000E+04, 1.0197314869E+01, 5.3367329356E+00, 1.4255495969E+00, 1.0132436762E+00, 7.6539360814E-01],
	[1.8950000000E+04, 1.0201232785E+01, 5.3365632948E+00, 1.4267528780E+00, 1.0138840173E+00, 7.6549753667E-01],
	[1.8955000000E+04, 1.0205151172E+01, 5.3363937042E+00, 1.4279568563E+00, 1.0145244702E+00, 7.6560142952E-01],
	[1.8960000000E+04, 1.0209070031E+01, 5.3362241636E+00, 1.4291615320E+00, 1.0151650349E+00, 7.6570528670E-01],
	[1.8965000000E+04, 1.0212989360E+01, 5.3360546732E+00, 1.4303669053E+00, 1.0158057111E+00, 7.6580910821E-01],
	[1.8970000000E+04, 1.0216909161E+01, 5.3358852328E+00, 1.4315729765E+00, 1.0164464987E+00, 7.6591289406E-01],
	[1.8975000000E+04, 1.0220829432E+01, 5.3357158424E+00, 1.4327797458E+00, 1.0170873976E+00, 7.6601664424E-01],
	[1.8980000000E+04, 1.0224750174E+01, 5.3355465020E+00, 1.4339872133E+00, 1.0177284075E+00, 7.6612035876E-01],
	[1.8985000000E+04, 1.0228671387E+01, 5.3353772117E+00, 1.4351953794E+00, 1.0183695283E+00, 7.6622403763E-01],
	[1.8990000000E+04, 1.0232593070E+01, 5.3352079712E+00, 1.4364042442E+00, 1.0190107598E+00, 7.6632768085E-01],
	[1.8995000000E+04, 1.0236515224E+01, 5.3350387807E+00, 1.4376138079E+00, 1.0196521019E+00, 7.6643128842E-01],
	[1.9000000000E+04, 1.0240437848E+01, 5.3348696401E+00, 1.4388240708E+00, 1.0202935544E+00, 7.6653486034E-01],
	[1.9005000000E+04, 1.0244360943E+01, 5.3347005493E+00, 1.4400350331E+00, 1.0209351172E+00, 7.6663839663E-01],
	[1.9010000000E+04, 1.0248284508E+01, 5.3345315084E+00, 1.4412466950E+00, 1.0215767900E+00, 7.6674189728E-01],
	[1.9015000000E+04, 1.0252208543E+01, 5.3343625173E+00, 1.4424590567E+00, 1.0222185728E+00, 7.6684536230E-01],
	[1.9020000000E+04, 1.0256133049E+01, 5.3341935760E+00, 1.4436721184E+00, 1.0228604653E+00, 7.6694879168E-01],
	[1.9025000000E+04, 1.0260058025E+01, 5.3340246844E+00, 1.4448858805E+00, 1.0235024674E+00, 7.6705218544E-01],
	[1.9030000000E+04, 1.0263983470E+01, 5.3338558426E+00, 1.4461003430E+00, 1.0241445790E+00, 7.6715554358E-01],
	[1.9035000000E+04, 1.0267909386E+01, 5.3336870504E+00, 1.4473155062E+00, 1.0247867998E+00, 7.6725886611E-01],
	[1.9040000000E+04, 1.0271835772E+01, 5.3335183079E+00, 1.4485313703E+00, 1.0254291298E+00, 7.6736215301E-01],
	[1.9045000000E+04, 1.0275762628E+01, 5.3333496151E+00, 1.4497479356E+00, 1.0260715686E+00, 7.6746540431E-01],
	[1.9050000000E+04, 1.0279689953E+01, 5.3331809719E+00, 1.4509652022E+00, 1.0267141163E+00, 7.6756862000E-01],
	[1.9055000000E+04, 1.0283617748E+01, 5.3330123783E+00, 1.4521831704E+00, 1.0273567726E+00, 7.6767180009E-01],
	[1.9060000000E+04, 1.0287546013E+01, 5.3328438342E+00, 1.4534018405E+00, 1.0279995373E+00, 7.6777494458E-01],
	[1.9065000000E+04, 1.0291474748E+01, 5.3326753397E+00, 1.4546212125E+00, 1.0286424104E+00, 7.6787805347E-01],
	[1.9070000000E+04, 1.0295403952E+01, 5.3325068946E+00, 1.4558412868E+00, 1.0292853915E+00, 7.6798112678E-01],
	[1.9075000000E+04, 1.0299333625E+01, 5.3323384991E+00, 1.4570620635E+00, 1.0299284806E+00, 7.6808416449E-01],
	[1.9080000000E+04, 1.0303263768E+01, 5.3321701530E+00, 1.4582835429E+00, 1.0305716776E+00, 7.6818716663E-01],
	[1.9085000000E+04, 1.0307194381E+01, 5.3320018563E+00, 1.4595057252E+00, 1.0312149821E+00, 7.6829013318E-01],
	[1.9090000000E+04, 1.0311125462E+01, 5.3318336090E+00, 1.4607286107E+00, 1.0318583942E+00, 7.6839306416E-01],
	[1.9095000000E+04, 1.0315057013E+01, 5.3316654111E+00, 1.4619521994E+00, 1.0325019135E+00, 7.6849595956E-01],
	[1.9100000000E+04, 1.0318989033E+01, 5.3314972625E+00, 1.4631764918E+00, 1.0331455400E+00, 7.6859881940E-01],
	[1.9105000000E+04, 1.0322921522E+01, 5.3313291632E+00, 1.4644014879E+00, 1.0337892735E+00, 7.6870164368E-01],
	[1.9110000000E+04, 1.0326854480E+01, 5.3311611133E+00, 1.4656271880E+00, 1.0344331139E+00, 7.6880443239E-01],
	[1.9115000000E+04, 1.0330787907E+01, 5.3309931126E+00, 1.4668535923E+00, 1.0350770608E+00, 7.6890718556E-01],
	[1.9120000000E+04, 1.0334721803E+01, 5.3308251611E+00, 1.4680807010E+00, 1.0357211143E+00, 7.6900990316E-01],
	[1.9125000000E+04, 1.0338659634E+01, 5.3306582725E+00, 1.4693085144E+00, 1.0363653473E+00, 7.6911258523E-01],
	[1.9130000000E+04, 1.0342611776E+01, 5.3304954785E+00, 1.4705370327E+00, 1.0370099788E+00, 7.6921523174E-01],
	[1.9135000000E+04, 1.0346564395E+01, 5.3303327321E+00, 1.4717662561E+00, 1.0376547170E+00, 7.6931784272E-01],
	[1.9140000000E+04, 1.0350517491E+01, 5.3301700331E+00, 1.4729961848E+00, 1.0382995618E+00, 7.6942041817E-01],
	[1.9145000000E+04, 1.0354471064E+01, 5.3300073816E+00, 1.4742268190E+00, 1.0389445129E+00, 7.6952295808E-01],
	[1.9150000000E+04, 1.0358425115E+01, 5.3298447775E+00, 1.4754581590E+00, 1.0395895703E+00, 7.6962546246E-01],
	[1.9155000000E+04, 1.0362379643E+01, 5.3296822208E+00, 1.4766902050E+00, 1.0402347337E+00, 7.6972793133E-01],
	[1.9160000000E+04, 1.0366334648E+01, 5.3295197115E+00, 1.4779229571E+00, 1.0408800030E+00, 7.6983036467E-01],
	[1.9165000000E+04, 1.0370290129E+01, 5.3293572495E+00, 1.4791564157E+00, 1.0415253780E+00, 7.6993276250E-01],
	[1.9170000000E+04, 1.0374246088E+01, 5.3291948349E+00, 1.4803905809E+00, 1.0421708585E+00, 7.7003512482E-01],
	[1.9175000000E+04, 1.0378202523E+01, 5.3290324676E+00, 1.4816254529E+00, 1.0428164445E+00, 7.7013745163E-01],
	[1.9180000000E+04, 1.0382159436E+01, 5.3288701476E+00, 1.4828610321E+00, 1.0434621357E+00, 7.7023974295E-01],
	[1.9185000000E+04, 1.0386116825E+01, 5.3287078748E+00, 1.4840973185E+00, 1.0441079320E+00, 7.7034199876E-01],
	[1.9190000000E+04, 1.0390074690E+01, 5.3285456492E+00, 1.4853343124E+00, 1.0447538331E+00, 7.7044421907E-01],
	[1.9195000000E+04, 1.0394033032E+01, 5.3283834709E+00, 1.4865720141E+00, 1.0453998391E+00, 7.7054640379E-01],
	[1.9200000000E+04, 1.0397991850E+01, 5.3282213397E+00, 1.4878104237E+00, 1.0460459496E+00, 7.7064855291E-01],
	[1.9205000000E+04, 1.0401951145E+01, 5.3280592557E+00, 1.4890495415E+00, 1.0466921645E+00, 7.7075066643E-01],
	[1.9210000000E+04, 1.0405910917E+01, 5.3278972188E+00, 1.4902893676E+00, 1.0473384837E+00, 7.7085274435E-01],
	[1.9215000000E+04, 1.0409871164E+01, 5.3277352289E+00, 1.4915299024E+00, 1.0479849069E+00, 7.7095478667E-01],
	[1.9220000000E+04, 1.0413831888E+01, 5.3275732862E+00, 1.4927711461E+00, 1.0486314341E+00, 7.7105679338E-01],
	[1.9225000000E+04, 1.0417793088E+01, 5.3274113905E+00, 1.4940130987E+00, 1.0492780651E+00, 7.7115876448E-01],
	[1.9230000000E+04, 1.0421754764E+01, 5.3272495418E+00, 1.4952557607E+00, 1.0499247997E+00, 7.7126069998E-01],
	[1.9235000000E+04, 1.0425716916E+01, 5.3270877401E+00, 1.4964991321E+00, 1.0505716377E+00, 7.7136259986E-01],
	[1.9240000000E+04, 1.0429679544E+01, 5.3269259854E+00, 1.4977432133E+00, 1.0512185790E+00, 7.7146446413E-01],
	[1.9245000000E+04, 1.0433642648E+01, 5.3267642776E+00, 1.4989880043E+00, 1.0518656234E+00, 7.7156629279E-01],
	[1.9250000000E+04, 1.0437606227E+01, 5.3266026167E+00, 1.5002335056E+00, 1.0525127708E+00, 7.7166808583E-01],
	[1.9255000000E+04, 1.0441570283E+01, 5.3264410027E+00, 1.5014797172E+00, 1.0531600209E+00, 7.7176984325E-01],
	[1.9260000000E+04, 1.0445534814E+01, 5.3262794356E+00, 1.5027266394E+00, 1.0538073737E+00, 7.7187156506E-01],
	[1.9265000000E+04, 1.0449499821E+01, 5.3261179153E+00, 1.5039742724E+00, 1.0544548289E+00, 7.7197325124E-01],
	[1.9270000000E+04, 1.0453465303E+01, 5.3259564418E+00, 1.5052226164E+00, 1.0551023865E+00, 7.7207490180E-01],
	[1.9275000000E+04, 1.0457431260E+01, 5.3257950152E+00, 1.5064716717E+00, 1.0557500461E+00, 7.7217651674E-01],
	[1.9280000000E+04, 1.0461397694E+01, 5.3256336352E+00, 1.5077214385E+00, 1.0563978078E+00, 7.7227809605E-01],
	[1.9285000000E+04, 1.0465364602E+01, 5.3254723020E+00, 1.5089719169E+00, 1.0570456712E+00, 7.7237963974E-01],
	[1.9290000000E+04, 1.0469331986E+01, 5.3253110156E+00, 1.5102231073E+00, 1.0576936363E+00, 7.7248114780E-01],
	[1.9295000000E+04, 1.0473299845E+01, 5.3251497758E+00, 1.5114750098E+00, 1.0583417029E+00, 7.7258262022E-01],
	[1.9300000000E+04, 1.0477268179E+01, 5.3249885826E+00, 1.5127276246E+00, 1.0589898708E+00, 7.7268405702E-01],
	[1.9305000000E+04, 1.0481236988E+01, 5.3248274361E+00, 1.5139809520E+00, 1.0596381399E+00, 7.7278545818E-01],
	[1.9310000000E+04, 1.0485206273E+01, 5.3246663362E+00, 1.5152349923E+00, 1.0602865099E+00, 7.7288682372E-01],
	[1.9315000000E+04, 1.0489176032E+01, 5.3245052829E+00, 1.5164897455E+00, 1.0609349808E+00, 7.7298815361E-01],
	[1.9320000000E+04, 1.0493146266E+01, 5.3243442761E+00, 1.5177452119E+00, 1.0615835524E+00, 7.7308944787E-01],
	[1.9325000000E+04, 1.0497116975E+01, 5.3241833159E+00, 1.5190013918E+00, 1.0622322244E+00, 7.7319070649E-01],
	[1.9330000000E+04, 1.0501088158E+01, 5.3240224021E+00, 1.5202582854E+00, 1.0628809968E+00, 7.7329192948E-01],
	[1.9335000000E+04, 1.0505059817E+01, 5.3238615349E+00, 1.5215158929E+00, 1.0635298694E+00, 7.7339311682E-01],
	[1.9340000000E+04, 1.0509031950E+01, 5.3237007141E+00, 1.5227742145E+00, 1.0641788420E+00, 7.7349426852E-01],
	[1.9345000000E+04, 1.0513004557E+01, 5.3235399397E+00, 1.5240332504E+00, 1.0648279144E+00, 7.7359538458E-01],
	[1.9350000000E+04, 1.0516977639E+01, 5.3233792117E+00, 1.5252930009E+00, 1.0654770866E+00, 7.7369646500E-01],
	[1.9355000000E+04, 1.0520951196E+01, 5.3232185301E+00, 1.5265534661E+00, 1.0661263582E+00, 7.7379750977E-01],
	[1.9360000000E+04, 1.0524925227E+01, 5.3230578949E+00, 1.5278146463E+00, 1.0667757292E+00, 7.7389851890E-01],
	[1.9365000000E+04, 1.0528899732E+01, 5.3228973060E+00, 1.5290765418E+00, 1.0674251994E+00, 7.7399949238E-01],
	[1.9370000000E+04, 1.0532874711E+01, 5.3227367633E+00, 1.5303391527E+00, 1.0680747687E+00, 7.7410043021E-01],
	[1.9375000000E+04, 1.0536850164E+01, 5.3225762670E+00, 1.5316024792E+00, 1.0687244368E+00, 7.7420133239E-01],
	[1.9380000000E+04, 1.0540826092E+01, 5.3224158169E+00, 1.5328665216E+00, 1.0693742036E+00, 7.7430219893E-01],
	[1.9385000000E+04, 1.0544802494E+01, 5.3222554130E+00, 1.5341312801E+00, 1.0700240689E+00, 7.7440302981E-01],
	[1.9390000000E+04, 1.0548779369E+01, 5.3220950554E+00, 1.5353967549E+00, 1.0706740327E+00, 7.7450382505E-01],
	[1.9395000000E+04, 1.0552756719E+01, 5.3219347439E+00, 1.5366629463E+00, 1.0713240946E+00, 7.7460458463E-01],
	[1.9400000000E+04, 1.0556734542E+01, 5.3217744786E+00, 1.5379298544E+00, 1.0719742546E+00, 7.7470530856E-01],
	[1.9405000000E+04, 1.0560712839E+01, 5.3216142593E+00, 1.5391974795E+00, 1.0726245125E+00, 7.7480599683E-01],
	[1.9410000000E+04, 1.0564691610E+01, 5.3214540862E+00, 1.5404658217E+00, 1.0732748682E+00, 7.7490664945E-01],
	[1.9415000000E+04, 1.0568670854E+01, 5.3212939592E+00, 1.5417348814E+00, 1.0739253214E+00, 7.7500726642E-01],
	[1.9420000000E+04, 1.0572650572E+01, 5.3211338782E+00, 1.5430046588E+00, 1.0745758720E+00, 7.7510784772E-01],
	[1.9425000000E+04, 1.0576630764E+01, 5.3209738432E+00, 1.5442751540E+00, 1.0752265198E+00, 7.7520839338E-01],
	[1.9430000000E+04, 1.0580611429E+01, 5.3208138543E+00, 1.5455463672E+00, 1.0758772647E+00, 7.7530890337E-01],
	[1.9435000000E+04, 1.0584603694E+01, 5.3206570341E+00, 1.5468182988E+00, 1.0765283494E+00, 7.7540937771E-01],
	[1.9440000000E+04, 1.0588603079E+01, 5.3205021222E+00, 1.5480909489E+00, 1.0771796765E+00, 7.7550981638E-01],
	[1.9445000000E+04, 1.0592602946E+01, 5.3203472547E+00, 1.5493643177E+00, 1.0778311008E+00, 7.7561021940E-01],
	[1.9450000000E+04, 1.0596603295E+01, 5.3201924314E+00, 1.5506384055E+00, 1.0784826223E+00, 7.7571058676E-01],
	[1.9455000000E+04, 1.0600604127E+01, 5.3200376525E+00, 1.5519132124E+00, 1.0791342407E+00, 7.7581091846E-01],
	[1.9460000000E+04, 1.0604605440E+01, 5.3198829178E+00, 1.5531887388E+00, 1.0797859560E+00, 7.7591121450E-01],
	[1.9465000000E+04, 1.0608607235E+01, 5.3197282274E+00, 1.5544649847E+00, 1.0804377679E+00, 7.7601147487E-01],
	[1.9470000000E+04, 1.0612609511E+01, 5.3195735812E+00, 1.5557419506E+00, 1.0810896762E+00, 7.7611169959E-01],
	[1.9475000000E+04, 1.0616612269E+01, 5.3194189793E+00, 1.5570196364E+00, 1.0817416809E+00, 7.7621188864E-01],
	[1.9480000000E+04, 1.0620615509E+01, 5.3192644215E+00, 1.5582980426E+00, 1.0823937818E+00, 7.7631204203E-01],
	[1.9485000000E+04, 1.0624619231E+01, 5.3191099078E+00, 1.5595771692E+00, 1.0830459786E+00, 7.7641215975E-01],
	[1.9490000000E+04, 1.0628623434E+01, 5.3189554383E+00, 1.5608570166E+00, 1.0836982713E+00, 7.7651224181E-01],
	[1.9495000000E+04, 1.0632628118E+01, 5.3188010129E+00, 1.5621375849E+00, 1.0843506596E+00, 7.7661228821E-01],
	[1.9500000000E+04, 1.0636633284E+01, 5.3186466316E+00, 1.5634188744E+00, 1.0850031434E+00, 7.7671229894E-01],
	[1.9505000000E+04, 1.0640638931E+01, 5.3184922943E+00, 1.5647008853E+00, 1.0856557226E+00, 7.7681227401E-01],
	[1.9510000000E+04, 1.0644645059E+01, 5.3183380011E+00, 1.5659836178E+00, 1.0863083969E+00, 7.7691221342E-01],
	[1.9515000000E+04, 1.0648651668E+01, 5.3181837518E+00, 1.5672670721E+00, 1.0869611663E+00, 7.7701211716E-01],
	[1.9520000000E+04, 1.0652658758E+01, 5.3180295466E+00, 1.5685512484E+00, 1.0876140305E+00, 7.7711198523E-01],
	[1.9525000000E+04, 1.0656666330E+01, 5.3178753853E+00, 1.5698361470E+00, 1.0882669894E+00, 7.7721181764E-01],
	[1.9530000000E+04, 1.0660674382E+01, 5.3177212680E+00, 1.5711217681E+00, 1.0889200428E+00, 7.7731161438E-01],
	[1.9535000000E+04, 1.0664682915E+01, 5.3175671946E+00, 1.5724081119E+00, 1.0895731906E+00, 7.7741137546E-01],
	[1.9540000000E+04, 1.0668691929E+01, 5.3174131651E+00, 1.5736951786E+00, 1.0902264326E+00, 7.7751110087E-01],
	[1.9545000000E+04, 1.0672701424E+01, 5.3172591794E+00, 1.5749829685E+00, 1.0908797686E+00, 7.7761079062E-01],
	[1.9550000000E+04, 1.0676711400E+01, 5.3171052376E+00, 1.5762714817E+00, 1.0915331984E+00, 7.7771044470E-01],
	[1.9555000000E+04, 1.0680721856E+01, 5.3169513396E+00, 1.5775607186E+00, 1.0921867220E+00, 7.7781006311E-01],
	[1.9560000000E+04, 1.0684732792E+01, 5.3167974854E+00, 1.5788506792E+00, 1.0928403392E+00, 7.7790964586E-01],
	[1.9565000000E+04, 1.0688744209E+01, 5.3166436750E+00, 1.5801413639E+00, 1.0934940497E+00, 7.7800919294E-01],
	[1.9570000000E+04, 1.0692756107E+01, 5.3164899084E+00, 1.5814327728E+00, 1.0941478534E+00, 7.7810870435E-01],
	[1.9575000000E+04, 1.0696768485E+01, 5.3163361854E+00, 1.5827249062E+00, 1.0948017502E+00, 7.7820818010E-01],
	[1.9580000000E+04, 1.0700781343E+01, 5.3161825062E+00, 1.5840177643E+00, 1.0954557399E+00, 7.7830762019E-01],
	[1.9585000000E+04, 1.0704794682E+01, 5.3160288706E+00, 1.5853113473E+00, 1.0961098223E+00, 7.7840702461E-01],
	[1.9590000000E+04, 1.0708808500E+01, 5.3158752787E+00, 1.5866056554E+00, 1.0967639973E+00, 7.7850639336E-01],
	[1.9595000000E+04, 1.0712822799E+01, 5.3157217305E+00, 1.5879006889E+00, 1.0974182646E+00, 7.7860572645E-01],
	[1.9600000000E+04, 1.0716837578E+01, 5.3155682258E+00, 1.5891964479E+00, 1.0980726243E+00, 7.7870502387E-01],
	[1.9605000000E+04, 1.0720852836E+01, 5.3154147647E+00, 1.5904929328E+00, 1.0987270759E+00, 7.7880428563E-01],
	[1.9610000000E+04, 1.0724868575E+01, 5.3152613472E+00, 1.5917901437E+00, 1.0993816196E+00, 7.7890351172E-01],
	[1.9615000000E+04, 1.0728884794E+01, 5.3151079733E+00, 1.5930880808E+00, 1.1000362549E+00, 7.7900270215E-01],
	[1.9620000000E+04, 1.0732901492E+01, 5.3149546428E+00, 1.5943867443E+00, 1.1006909819E+00, 7.7910185691E-01],
	[1.9625000000E+04, 1.0736918670E+01, 5.3148013558E+00, 1.5956861346E+00, 1.1013458002E+00, 7.7920097601E-01],
	[1.9630000000E+04, 1.0740936327E+01, 5.3146481123E+00, 1.5969862517E+00, 1.1020007098E+00, 7.7930005945E-01],
	[1.9635000000E+04, 1.0744954465E+01, 5.3144949123E+00, 1.5982870960E+00, 1.1026557106E+00, 7.7939910722E-01],
	[1.9640000000E+04, 1.0748973081E+01, 5.3143417557E+00, 1.5995886676E+00, 1.1033108022E+00, 7.7949811933E-01],
	[1.9645000000E+04, 1.0752992178E+01, 5.3141886424E+00, 1.6008909667E+00, 1.1039659847E+00, 7.7959709578E-01],
	[1.9650000000E+04, 1.0757011753E+01, 5.3140355726E+00, 1.6021939937E+00, 1.1046212577E+00, 7.7969603657E-01],
	[1.9655000000E+04, 1.0761031808E+01, 5.3138825461E+00, 1.6034977486E+00, 1.1052766212E+00, 7.7979494170E-01],
	[1.9660000000E+04, 1.0765052342E+01, 5.3137295629E+00, 1.6048022318E+00, 1.1059320750E+00, 7.7989381116E-01],
	[1.9665000000E+04, 1.0769073355E+01, 5.3135766230E+00, 1.6061074434E+00, 1.1065876189E+00, 7.7999264497E-01],
	[1.9670000000E+04, 1.0773094848E+01, 5.3134237264E+00, 1.6074133837E+00, 1.1072432527E+00, 7.8009144311E-01],
	[1.9675000000E+04, 1.0777116819E+01, 5.3132708731E+00, 1.6087200529E+00, 1.1078989763E+00, 7.8019020560E-01],
	[1.9680000000E+04, 1.0781139270E+01, 5.3131180630E+00, 1.6100274511E+00, 1.1085547896E+00, 7.8028893242E-01],
	[1.9685000000E+04, 1.0785162199E+01, 5.3129652961E+00, 1.6113355787E+00, 1.1092106923E+00, 7.8038762359E-01],
	[1.9690000000E+04, 1.0789185608E+01, 5.3128125724E+00, 1.6126444359E+00, 1.1098666844E+00, 7.8048627910E-01],
	[1.9695000000E+04, 1.0793209495E+01, 5.3126598919E+00, 1.6139540228E+00, 1.1105227655E+00, 7.8058489896E-01],
	[1.9700000000E+04, 1.0797233861E+01, 5.3125072545E+00, 1.6152643397E+00, 1.1111789357E+00, 7.8068348316E-01],
	[1.9705000000E+04, 1.0801258705E+01, 5.3123546602E+00, 1.6165753869E+00, 1.1118351947E+00, 7.8078203170E-01],
	[1.9710000000E+04, 1.0805284028E+01, 5.3122021091E+00, 1.6178871644E+00, 1.1124915423E+00, 7.8088054459E-01],
	[1.9715000000E+04, 1.0809309830E+01, 5.3120496010E+00, 1.6191996726E+00, 1.1131479784E+00, 7.8097902183E-01],
	[1.9720000000E+04, 1.0813336110E+01, 5.3118971359E+00, 1.6205129117E+00, 1.1138045028E+00, 7.8107746341E-01],
	[1.9725000000E+04, 1.0817362869E+01, 5.3117447139E+00, 1.6218268819E+00, 1.1144611154E+00, 7.8117586934E-01],
	[1.9730000000E+04, 1.0821390106E+01, 5.3115923349E+00, 1.6231415834E+00, 1.1151178160E+00, 7.8127423962E-01],
	[1.9735000000E+04, 1.0825417821E+01, 5.3114399988E+00, 1.6244570164E+00, 1.1157746044E+00, 7.8137257425E-01],
	[1.9740000000E+04, 1.0829446014E+01, 5.3112877058E+00, 1.6257731812E+00, 1.1164314805E+00, 7.8147087322E-01],
	[1.9745000000E+04, 1.0833475797E+01, 5.3111357552E+00, 1.6270900780E+00, 1.1170884692E+00, 7.8156913655E-01],
	[1.9750000000E+04, 1.0837523184E+01, 5.3109884619E+00, 1.6284077070E+00, 1.1177459318E+00, 7.8166736424E-01],
	[1.9755000000E+04, 1.0841571059E+01, 5.3108412101E+00, 1.6297260684E+00, 1.1184034823E+00, 7.8176555627E-01],
	[1.9760000000E+04, 1.0845619420E+01, 5.3106939996E+00, 1.6310451624E+00, 1.1190611206E+00, 7.8186371266E-01],
	[1.9765000000E+04, 1.0849668268E+01, 5.3105468304E+00, 1.6323649893E+00, 1.1197188465E+00, 7.8196183341E-01],
	[1.9770000000E+04, 1.0853717603E+01, 5.3103997025E+00, 1.6336855493E+00, 1.1203766598E+00, 7.8205991851E-01],
	[1.9775000000E+04, 1.0857767425E+01, 5.3102526159E+00, 1.6350068426E+00, 1.1210345604E+00, 7.8215796797E-01],
	[1.9780000000E+04, 1.0861817733E+01, 5.3101055705E+00, 1.6363288694E+00, 1.1216925481E+00, 7.8225598178E-01],
	[1.9785000000E+04, 1.0865868528E+01, 5.3099585664E+00, 1.6376516300E+00, 1.1223506227E+00, 7.8235395996E-01],
	[1.9790000000E+04, 1.0869919810E+01, 5.3098116035E+00, 1.6389751245E+00, 1.1230087841E+00, 7.8245190250E-01],
	[1.9795000000E+04, 1.0873971578E+01, 5.3096646818E+00, 1.6402993532E+00, 1.1236670321E+00, 7.8254980940E-01],
	[1.9800000000E+04, 1.0878023832E+01, 5.3095178013E+00, 1.6416243164E+00, 1.1243253665E+00, 7.8264768066E-01],
	[1.9805000000E+04, 1.0882076573E+01, 5.3093709619E+00, 1.6429500141E+00, 1.1249837872E+00, 7.8274551628E-01],
	[1.9810000000E+04, 1.0886129800E+01, 5.3092241636E+00, 1.6442764468E+00, 1.1256422941E+00, 7.8284331627E-01],
	[1.9815000000E+04, 1.0890183513E+01, 5.3090774064E+00, 1.6456036145E+00, 1.1263008869E+00, 7.8294108063E-01],
	[1.9820000000E+04, 1.0894237713E+01, 5.3089306904E+00, 1.6469315175E+00, 1.1269595655E+00, 7.8303880936E-01],
	[1.9825000000E+04, 1.0898292398E+01, 5.3087840153E+00, 1.6482601560E+00, 1.1276183298E+00, 7.8313650245E-01],
	[1.9830000000E+04, 1.0902347570E+01, 5.3086373814E+00, 1.6495895302E+00, 1.1282771795E+00, 7.8323415992E-01],
	[1.9835000000E+04, 1.0906403228E+01, 5.3084907884E+00, 1.6509196404E+00, 1.1289361146E+00, 7.8333178176E-01],
	[1.9840000000E+04, 1.0910459371E+01, 5.3083442364E+00, 1.6522504868E+00, 1.1295951348E+00, 7.8342936797E-01],
	[1.9845000000E+04, 1.0914516001E+01, 5.3081977254E+00, 1.6535820696E+00, 1.1302542400E+00, 7.8352691855E-01],
	[1.9850000000E+04, 1.0918573116E+01, 5.3080512554E+00, 1.6549143890E+00, 1.1309134300E+00, 7.8362443351E-01],
	[1.9855000000E+04, 1.0922630717E+01, 5.3079048263E+00, 1.6562474453E+00, 1.1315727046E+00, 7.8372191285E-01],
	[1.9860000000E+04, 1.0926688803E+01, 5.3077584381E+00, 1.6575812386E+00, 1.1322320638E+00, 7.8381935657E-01],
	[1.9865000000E+04, 1.0930747375E+01, 5.3076120908E+00, 1.6589157692E+00, 1.1328915073E+00, 7.8391676466E-01],
	[1.9870000000E+04, 1.0934806433E+01, 5.3074657843E+00, 1.6602510373E+00, 1.1335510350E+00, 7.8401413714E-01],
	[1.9875000000E+04, 1.0938865976E+01, 5.3073195187E+00, 1.6615870431E+00, 1.1342106467E+00, 7.8411147401E-01],
	[1.9880000000E+04, 1.0942926004E+01, 5.3071732939E+00, 1.6629237869E+00, 1.1348703422E+00, 7.8420877525E-01],
	[1.9885000000E+04, 1.0946986518E+01, 5.3070271099E+00, 1.6642612689E+00, 1.1355301214E+00, 7.8430604089E-01],
	[1.9890000000E+04, 1.0951047517E+01, 5.3068809667E+00, 1.6655994893E+00, 1.1361899842E+00, 7.8440327091E-01],
	[1.9895000000E+04, 1.0955109002E+01, 5.3067348642E+00, 1.6669384482E+00, 1.1368499303E+00, 7.8450046532E-01],
	[1.9900000000E+04, 1.0959170971E+01, 5.3065888025E+00, 1.6682781460E+00, 1.1375099596E+00, 7.8459762412E-01],
	[1.9905000000E+04, 1.0963233426E+01, 5.3064427815E+00, 1.6696185829E+00, 1.1381700719E+00, 7.8469474732E-01],
	[1.9910000000E+04, 1.0967296365E+01, 5.3062968012E+00, 1.6709597591E+00, 1.1388302671E+00, 7.8479183491E-01],
	[1.9915000000E+04, 1.0971359790E+01, 5.3061508615E+00, 1.6723016747E+00, 1.1394905450E+00, 7.8488888690E-01],
	[1.9920000000E+04, 1.0975423699E+01, 5.3060049625E+00, 1.6736443301E+00, 1.1401509055E+00, 7.8498590328E-01],
	[1.9925000000E+04, 1.0979488093E+01, 5.3058591041E+00, 1.6749877254E+00, 1.1408113483E+00, 7.8508288406E-01],
	[1.9930000000E+04, 1.0983552972E+01, 5.3057132864E+00, 1.6763318608E+00, 1.1414718734E+00, 7.8517982924E-01],
	[1.9935000000E+04, 1.0987618336E+01, 5.3055675092E+00, 1.6776767367E+00, 1.1421324806E+00, 7.8527673882E-01],
	[1.9940000000E+04, 1.0991684184E+01, 5.3054217726E+00, 1.6790223532E+00, 1.1427931696E+00, 7.8537361279E-01],
	[1.9945000000E+04, 1.0995750517E+01, 5.3052760765E+00, 1.6803687104E+00, 1.1434539404E+00, 7.8547045116E-01],
	[1.9950000000E+04, 1.0999817334E+01, 5.3051304209E+00, 1.6817158088E+00, 1.1441147927E+00, 7.8556725394E-01],
	[1.9955000000E+04, 1.1003884636E+01, 5.3049848058E+00, 1.6830636484E+00, 1.1447757265E+00, 7.8566402111E-01],
	[1.9960000000E+04, 1.1007952422E+01, 5.3048392313E+00, 1.6844122295E+00, 1.1454367415E+00, 7.8576075268E-01],
	[1.9965000000E+04, 1.1012020692E+01, 5.3046936971E+00, 1.6857615523E+00, 1.1460978376E+00, 7.8585744865E-01],
	[1.9970000000E+04, 1.1016089447E+01, 5.3045482034E+00, 1.6871116171E+00, 1.1467590146E+00, 7.8595410903E-01],
	[1.9975000000E+04, 1.1020158686E+01, 5.3044027501E+00, 1.6884624240E+00, 1.1474202723E+00, 7.8605073381E-01],
	[1.9980000000E+04, 1.1024228409E+01, 5.3042573372E+00, 1.6898139732E+00, 1.1480816107E+00, 7.8614732299E-01],
	[1.9985000000E+04, 1.1028298616E+01, 5.3041119647E+00, 1.6911662651E+00, 1.1487430295E+00, 7.8624387658E-01],
	[1.9990000000E+04, 1.1032369307E+01, 5.3039666325E+00, 1.6925192998E+00, 1.1494045286E+00, 7.8634039457E-01],
	[1.9995000000E+04, 1.1036440482E+01, 5.3038213407E+00, 1.6938730776E+00, 1.1500661078E+00, 7.8643687696E-01],
	[2.0000000000E+04, 1.1040512140E+01, 5.3036760891E+00, 1.6952275986E+00, 1.1507277669E+00, 7.8653332376E-01],
	[2.0005000000E+04, 1.1044584283E+01, 5.3035308779E+00, 1.6965849202E+00, 1.1513904533E+00, 7.8662973497E-01],
	[2.0010000000E+04, 1.1048656909E+01, 5.3033857069E+00, 1.6979429884E+00, 1.1520532197E+00, 7.8672611059E-01],
	[2.0015000000E+04, 1.1052730019E+01, 5.3032405761E+00, 1.6993018035E+00, 1.1527160661E+00, 7.8682245061E-01],
	[2.0020000000E+04, 1.1056803613E+01, 5.3030954856E+00, 1.7006613655E+00, 1.1533789923E+00, 7.8691875505E-01],
	[2.0025000000E+04, 1.1060877690E+01, 5.3029504353E+00, 1.7020216748E+00, 1.1540419981E+00, 7.8701502389E-01],
	[2.0030000000E+04, 1.1064952251E+01, 5.3028054251E+00, 1.7033827317E+00, 1.1547050833E+00, 7.8711125715E-01],
	[2.0035000000E+04, 1.1069027295E+01, 5.3026604551E+00, 1.7047445362E+00, 1.1553682479E+00, 7.8720745482E-01],
	[2.0040000000E+04, 1.1073102822E+01, 5.3025155253E+00, 1.7061070887E+00, 1.1560314915E+00, 7.8730361691E-01],
	[2.0045000000E+04, 1.1077178833E+01, 5.3023706355E+00, 1.7074703893E+00, 1.1566948141E+00, 7.8739974340E-01],
	[2.0050000000E+04, 1.1081255327E+01, 5.3022257859E+00, 1.7088344383E+00, 1.1573582155E+00, 7.8749583432E-01],
	[2.0055000000E+04, 1.1085332304E+01, 5.3020809763E+00, 1.7101992359E+00, 1.1580216956E+00, 7.8759188965E-01],
	[2.0060000000E+04, 1.1089409764E+01, 5.3019362068E+00, 1.7115647823E+00, 1.1586852541E+00, 7.8768790940E-01],
	[2.0065000000E+04, 1.1093496812E+01, 5.3017938421E+00, 1.7129310778E+00, 1.1593491034E+00, 7.8778389356E-01],
	[2.0070000000E+04, 1.1097593885E+01, 5.3016539935E+00, 1.7142981226E+00, 1.1600132540E+00, 7.8787984215E-01],
	[2.0075000000E+04, 1.1101691451E+01, 5.3015141833E+00, 1.7156659168E+00, 1.1606774834E+00, 7.8797575516E-01],
	[2.0080000000E+04, 1.1105789508E+01, 5.3013744117E+00, 1.7170344608E+00, 1.1613417914E+00, 7.8807163259E-01],
	[2.0085000000E+04, 1.1109888058E+01, 5.3012346786E+00, 1.7184037547E+00, 1.1620061777E+00, 7.8816747445E-01],
	[2.0090000000E+04, 1.1113987099E+01, 5.3010949839E+00, 1.7197737988E+00, 1.1626706423E+00, 7.8826328073E-01],
	[2.0095000000E+04, 1.1118086632E+01, 5.3009553277E+00, 1.7211445933E+00, 1.1633351850E+00, 7.8835905143E-01],
	[2.0100000000E+04, 1.1122186657E+01, 5.3008157099E+00, 1.7225161384E+00, 1.1639998056E+00, 7.8845478657E-01],
	[2.0105000000E+04, 1.1126287173E+01, 5.3006761304E+00, 1.7238884344E+00, 1.1646645039E+00, 7.8855048613E-01],
	[2.0110000000E+04, 1.1130388181E+01, 5.3005365894E+00, 1.7252614814E+00, 1.1653292799E+00, 7.8864615012E-01],
	[2.0115000000E+04, 1.1134489680E+01, 5.3003970868E+00, 1.7266352797E+00, 1.1659941333E+00, 7.8874177854E-01],
	[2.0120000000E+04, 1.1138591671E+01, 5.3002576224E+00, 1.7280098295E+00, 1.1666590639E+00, 7.8883737140E-01],
	[2.0125000000E+04, 1.1142694154E+01, 5.3001181964E+00, 1.7293851311E+00, 1.1673240717E+00, 7.8893292869E-01],
	[2.0130000000E+04, 1.1146797127E+01, 5.2999788087E+00, 1.7307611846E+00, 1.1679891564E+00, 7.8902845042E-01],
	[2.0135000000E+04, 1.1150900592E+01, 5.2998394593E+00, 1.7321379903E+00, 1.1686543179E+00, 7.8912393658E-01],
	[2.0140000000E+04, 1.1155004548E+01, 5.2997001482E+00, 1.7335155484E+00, 1.1693195560E+00, 7.8921938719E-01],
	[2.0145000000E+04, 1.1159108995E+01, 5.2995608753E+00, 1.7348938591E+00, 1.1699848706E+00, 7.8931480223E-01],
	[2.0150000000E+04, 1.1163213933E+01, 5.2994216406E+00, 1.7362729227E+00, 1.1706502614E+00, 7.8941018172E-01],
	[2.0155000000E+04, 1.1167319362E+01, 5.2992824441E+00, 1.7376527393E+00, 1.1713157284E+00, 7.8950552565E-01],
	[2.0160000000E+04, 1.1171425282E+01, 5.2991432858E+00, 1.7390333093E+00, 1.1719812714E+00, 7.8960083402E-01],
	[2.0165000000E+04, 1.1175531693E+01, 5.2990041656E+00, 1.7404146328E+00, 1.1726468902E+00, 7.8969610684E-01],
	[2.0170000000E+04, 1.1179638595E+01, 5.2988650836E+00, 1.7417967100E+00, 1.1733125846E+00, 7.8979134411E-01],
	[2.0175000000E+04, 1.1183745987E+01, 5.2987260398E+00, 1.7431795412E+00, 1.1739783545E+00, 7.8988654583E-01],
	[2.0180000000E+04, 1.1187853870E+01, 5.2985870340E+00, 1.7445631266E+00, 1.1746441998E+00, 7.8998171200E-01],
	[2.0185000000E+04, 1.1191962244E+01, 5.2984480663E+00, 1.7459474665E+00, 1.1753101202E+00, 7.9007684262E-01],
	[2.0190000000E+04, 1.1196071108E+01, 5.2983091366E+00, 1.7473325610E+00, 1.1759761155E+00, 7.9017193770E-01],
	[2.0195000000E+04, 1.1200180463E+01, 5.2981702451E+00, 1.7487184103E+00, 1.1766421858E+00, 7.9026699723E-01],
	[2.0200000000E+04, 1.1204290308E+01, 5.2980313915E+00, 1.7501050147E+00, 1.1773083307E+00, 7.9036202122E-01],
	[2.0205000000E+04, 1.1208400644E+01, 5.2978925759E+00, 1.7514923745E+00, 1.1779745501E+00, 7.9045700968E-01],
	[2.0210000000E+04, 1.1212511469E+01, 5.2977537984E+00, 1.7528804898E+00, 1.1786408439E+00, 7.9055196259E-01],
	[2.0215000000E+04, 1.1216622786E+01, 5.2976150587E+00, 1.7542693608E+00, 1.1793072118E+00, 7.9064687997E-01],
	[2.0220000000E+04, 1.1220734592E+01, 5.2974763571E+00, 1.7556589879E+00, 1.1799736538E+00, 7.9074176182E-01],
	[2.0225000000E+04, 1.1224846888E+01, 5.2973376933E+00, 1.7570493711E+00, 1.1806401696E+00, 7.9083660813E-01],
	[2.0230000000E+04, 1.1228959675E+01, 5.2971990675E+00, 1.7584405108E+00, 1.1813067592E+00, 7.9093141892E-01],
	[2.0235000000E+04, 1.1233072951E+01, 5.2970604795E+00, 1.7598324072E+00, 1.1819734222E+00, 7.9102619417E-01],
	[2.0240000000E+04, 1.1237186717E+01, 5.2969219294E+00, 1.7612250604E+00, 1.1826401587E+00, 7.9112093390E-01],
	[2.0245000000E+04, 1.1241300974E+01, 5.2967834172E+00, 1.7626184708E+00, 1.1833069683E+00, 7.9121563810E-01],
	[2.0250000000E+04, 1.1245415720E+01, 5.2966449427E+00, 1.7640126385E+00, 1.1839738511E+00, 7.9131030678E-01],
	[2.0255000000E+04, 1.1249530955E+01, 5.2965065061E+00, 1.7654075637E+00, 1.1846408067E+00, 7.9140493994E-01],
	[2.0260000000E+04, 1.1253646681E+01, 5.2963681073E+00, 1.7668032467E+00, 1.1853078350E+00, 7.9149953759E-01],
	[2.0265000000E+04, 1.1257762896E+01, 5.2962297462E+00, 1.7681996877E+00, 1.1859749359E+00, 7.9159409971E-01],
	[2.0270000000E+04, 1.1261879600E+01, 5.2960914229E+00, 1.7695968870E+00, 1.1866421092E+00, 7.9168862632E-01],
	[2.0275000000E+04, 1.1265996794E+01, 5.2959531373E+00, 1.7709948447E+00, 1.1873093547E+00, 7.9178311742E-01],
	[2.0280000000E+04, 1.1270114478E+01, 5.2958148894E+00, 1.7723935611E+00, 1.1879766723E+00, 7.9187757302E-01],
	[2.0285000000E+04, 1.1274232651E+01, 5.2956766792E+00, 1.7737930363E+00, 1.1886440619E+00, 7.9197199310E-01],
	[2.0290000000E+04, 1.1278351313E+01, 5.2955385067E+00, 1.7751932707E+00, 1.1893115232E+00, 7.9206637767E-01],
	[2.0295000000E+04, 1.1282470464E+01, 5.2954003718E+00, 1.7765942645E+00, 1.1899790561E+00, 7.9216072675E-01],
	[2.0300000000E+04, 1.1286590105E+01, 5.2952622746E+00, 1.7779960178E+00, 1.1906466604E+00, 7.9225504032E-01],
	[2.0305000000E+04, 1.1290710234E+01, 5.2951242150E+00, 1.7793985309E+00, 1.1913143360E+00, 7.9234931840E-01],
	[2.0310000000E+04, 1.1294830853E+01, 5.2949861929E+00, 1.7808018041E+00, 1.1919820827E+00, 7.9244356097E-01],
	[2.0315000000E+04, 1.1298951961E+01, 5.2948482084E+00, 1.7822058374E+00, 1.1926499003E+00, 7.9253776806E-01],
	[2.0320000000E+04, 1.1303073557E+01, 5.2947102615E+00, 1.7836106313E+00, 1.1933177887E+00, 7.9263193965E-01],
	[2.0325000000E+04, 1.1307195643E+01, 5.2945723521E+00, 1.7850161858E+00, 1.1939857478E+00, 7.9272607575E-01],
	[2.0330000000E+04, 1.1311318217E+01, 5.2944344802E+00, 1.7864225013E+00, 1.1946537773E+00, 7.9282017636E-01],
	[2.0335000000E+04, 1.1315441280E+01, 5.2942966458E+00, 1.7878295779E+00, 1.1953218771E+00, 7.9291424150E-01],
	[2.0340000000E+04, 1.1319564832E+01, 5.2941588489E+00, 1.7892374159E+00, 1.1959900470E+00, 7.9300827114E-01],
	[2.0345000000E+04, 1.1323688872E+01, 5.2940210895E+00, 1.7906460154E+00, 1.1966582869E+00, 7.9310226531E-01],
	[2.0350000000E+04, 1.1327813401E+01, 5.2938833674E+00, 1.7920553768E+00, 1.1973265967E+00, 7.9319622400E-01],
	[2.0355000000E+04, 1.1331938418E+01, 5.2937456828E+00, 1.7934655002E+00, 1.1979949760E+00, 7.9329014722E-01],
	[2.0360000000E+04, 1.1336063924E+01, 5.2936080356E+00, 1.7948763859E+00, 1.1986634249E+00, 7.9338403496E-01],
	[2.0365000000E+04, 1.1340189918E+01, 5.2934704258E+00, 1.7962880340E+00, 1.1993319431E+00, 7.9347788724E-01],
	[2.0370000000E+04, 1.1344316400E+01, 5.2933328533E+00, 1.7977004449E+00, 1.2000005305E+00, 7.9357170404E-01],
	[2.0375000000E+04, 1.1348443371E+01, 5.2931953182E+00, 1.7991136187E+00, 1.2006691868E+00, 7.9366548538E-01],
	[2.0380000000E+04, 1.1352570830E+01, 5.2930578204E+00, 1.8005275557E+00, 1.2013379120E+00, 7.9375923126E-01],
	[2.0385000000E+04, 1.1356698777E+01, 5.2929203598E+00, 1.8019422560E+00, 1.2020067059E+00, 7.9385294168E-01],
	[2.0390000000E+04, 1.1360844073E+01, 5.2927871903E+00, 1.8033577200E+00, 1.2026759769E+00, 7.9394661665E-01],
	[2.0395000000E+04, 1.1364991898E+01, 5.2926545694E+00, 1.8047739478E+00, 1.2033453662E+00, 7.9404025616E-01],
	[2.0400000000E+04, 1.1369140220E+01, 5.2925219844E+00, 1.8061909396E+00, 1.2040148245E+00, 7.9413386022E-01],
	[2.0405000000E+04, 1.1373289039E+01, 5.2923894351E+00, 1.8076086957E+00, 1.2046843516E+00, 7.9422742882E-01],
	[2.0410000000E+04, 1.1377438355E+01, 5.2922569217E+00, 1.8090272164E+00, 1.2053539473E+00, 7.9432096199E-01],
	[2.0415000000E+04, 1.1381588168E+01, 5.2921244440E+00, 1.8104465017E+00, 1.2060236115E+00, 7.9441445971E-01],
	[2.0420000000E+04, 1.1385738478E+01, 5.2919920021E+00, 1.8118665520E+00, 1.2066933441E+00, 7.9450792199E-01],
	[2.0425000000E+04, 1.1389889284E+01, 5.2918595959E+00, 1.8132873675E+00, 1.2073631447E+00, 7.9460134883E-01],
	[2.0430000000E+04, 1.1394040587E+01, 5.2917272255E+00, 1.8147089484E+00, 1.2080330134E+00, 7.9469474024E-01],
	[2.0435000000E+04, 1.1398192387E+01, 5.2915948907E+00, 1.8161312949E+00, 1.2087029499E+00, 7.9478809621E-01],
	[2.0440000000E+04, 1.1402344684E+01, 5.2914625916E+00, 1.8175544073E+00, 1.2093729541E+00, 7.9488141676E-01],
	[2.0445000000E+04, 1.1406497476E+01, 5.2913303282E+00, 1.8189782858E+00, 1.2100430258E+00, 7.9497470188E-01],
	[2.0450000000E+04, 1.1410650766E+01, 5.2911981005E+00, 1.8204029305E+00, 1.2107131648E+00, 7.9506795158E-01],
	[2.0455000000E+04, 1.1414804551E+01, 5.2910659083E+00, 1.8218283418E+00, 1.2113833710E+00, 7.9516116585E-01],
	[2.0460000000E+04, 1.1418958833E+01, 5.2909337518E+00, 1.8232545198E+00, 1.2120536443E+00, 7.9525434471E-01],
	[2.0465000000E+04, 1.1423113612E+01, 5.2908016309E+00, 1.8246814648E+00, 1.2127239844E+00, 7.9534748816E-01],
	[2.0470000000E+04, 1.1427268886E+01, 5.2906695455E+00, 1.8261091770E+00, 1.2133943912E+00, 7.9544059619E-01],
	[2.0475000000E+04, 1.1431424656E+01, 5.2905374957E+00, 1.8275376566E+00, 1.2140648646E+00, 7.9553366882E-01],
	[2.0480000000E+04, 1.1435580923E+01, 5.2904054815E+00, 1.8289669039E+00, 1.2147354043E+00, 7.9562670604E-01],
	[2.0485000000E+04, 1.1439737686E+01, 5.2902735027E+00, 1.8303969190E+00, 1.2154060103E+00, 7.9571970785E-01],
	[2.0490000000E+04, 1.1443894944E+01, 5.2901415595E+00, 1.8318277022E+00, 1.2160766824E+00, 7.9581267427E-01],
	[2.0495000000E+04, 1.1448052699E+01, 5.2900096517E+00, 1.8332592538E+00, 1.2167474203E+00, 7.9590560529E-01],
	[2.0500000000E+04, 1.1452210949E+01, 5.2898777794E+00, 1.8346915739E+00, 1.2174182240E+00, 7.9599850092E-01],
	[2.0505000000E+04, 1.1456369695E+01, 5.2897459426E+00, 1.8361246627E+00, 1.2180890933E+00, 7.9609136116E-01],
	[2.0510000000E+04, 1.1460528937E+01, 5.2896141411E+00, 1.8375585206E+00, 1.2187600279E+00, 7.9618418602E-01],
	[2.0515000000E+04, 1.1464688674E+01, 5.2894823751E+00, 1.8389931477E+00, 1.2194310279E+00, 7.9627697548E-01],
	[2.0520000000E+04, 1.1468848907E+01, 5.2893506445E+00, 1.8404285442E+00, 1.2201020929E+00, 7.9636972957E-01],
	[2.0525000000E+04, 1.1473009635E+01, 5.2892189493E+00, 1.8418647104E+00, 1.2207732229E+00, 7.9646244829E-01],
	[2.0530000000E+04, 1.1477170859E+01, 5.2890872894E+00, 1.8433016464E+00, 1.2214444176E+00, 7.9655513162E-01],
	[2.0535000000E+04, 1.1481332578E+01, 5.2889556648E+00, 1.8447393526E+00, 1.2221156770E+00, 7.9664777959E-01],
	[2.0540000000E+04, 1.1485494793E+01, 5.2888240756E+00, 1.8461778292E+00, 1.2227870008E+00, 7.9674039219E-01],
	[2.0545000000E+04, 1.1489657503E+01, 5.2886925217E+00, 1.8476170763E+00, 1.2234583890E+00, 7.9683296943E-01],
	[2.0550000000E+04, 1.1493820708E+01, 5.2885610030E+00, 1.8490570942E+00, 1.2241298412E+00, 7.9692551131E-01],
	[2.0555000000E+04, 1.1497984408E+01, 5.2884295196E+00, 1.8504978831E+00, 1.2248013574E+00, 7.9701801783E-01],
	[2.0560000000E+04, 1.1502148603E+01, 5.2882980715E+00, 1.8519394432E+00, 1.2254729375E+00, 7.9711048899E-01],
	[2.0565000000E+04, 1.1506313293E+01, 5.2881666586E+00, 1.8533817748E+00, 1.2261445812E+00, 7.9720292481E-01],
	[2.0570000000E+04, 1.1510478478E+01, 5.2880352809E+00, 1.8548248781E+00, 1.2268162883E+00, 7.9729532528E-01],
	[2.0575000000E+04, 1.1514644159E+01, 5.2879039384E+00, 1.8562687533E+00, 1.2274880589E+00, 7.9738769040E-01],
	[2.0580000000E+04, 1.1518810333E+01, 5.2877726311E+00, 1.8577134007E+00, 1.2281598925E+00, 7.9748002019E-01],
	[2.0585000000E+04, 1.1522977003E+01, 5.2876413589E+00, 1.8591588204E+00, 1.2288317892E+00, 7.9757231464E-01],
	[2.0590000000E+04, 1.1527144168E+01, 5.2875101219E+00, 1.8606050127E+00, 1.2295037488E+00, 7.9766457375E-01],
	[2.0595000000E+04, 1.1531311827E+01, 5.2873789200E+00, 1.8620519778E+00, 1.2301757710E+00, 7.9775679754E-01],
	[2.0600000000E+04, 1.1535479980E+01, 5.2872477531E+00, 1.8634997160E+00, 1.2308478558E+00, 7.9784898600E-01],
	[2.0605000000E+04, 1.1539648628E+01, 5.2871166214E+00, 1.8649482274E+00, 1.2315200029E+00, 7.9794113914E-01],
	[2.0610000000E+04, 1.1543817771E+01, 5.2869855248E+00, 1.8663975123E+00, 1.2321922122E+00, 7.9803325696E-01],
	[2.0615000000E+04, 1.1547987408E+01, 5.2868544632E+00, 1.8678475709E+00, 1.2328644836E+00, 7.9812533943E-01],
	[2.0620000000E+04, 1.1552157539E+01, 5.2867234366E+00, 1.8692984034E+00, 1.2335368169E+00, 7.9821738650E-01],
	[2.0625000000E+04, 1.1556328165E+01, 5.2865924450E+00, 1.8707500101E+00, 1.2342092119E+00, 7.9830939817E-01],
	[2.0630000000E+04, 1.1560499285E+01, 5.2864614885E+00, 1.8722023912E+00, 1.2348816685E+00, 7.9840137446E-01],
	[2.0635000000E+04, 1.1564670899E+01, 5.2863305669E+00, 1.8736555469E+00, 1.2355541864E+00, 7.9849331537E-01],
	[2.0640000000E+04, 1.1568843007E+01, 5.2861996803E+00, 1.8751094775E+00, 1.2362267656E+00, 7.9858522091E-01],
	[2.0645000000E+04, 1.1573015609E+01, 5.2860688286E+00, 1.8765641831E+00, 1.2368994060E+00, 7.9867709108E-01],
	[2.0650000000E+04, 1.1577188705E+01, 5.2859380118E+00, 1.8780196640E+00, 1.2375721072E+00, 7.9876892589E-01],
	[2.0655000000E+04, 1.1581362295E+01, 5.2858072300E+00, 1.8794759204E+00, 1.2382448692E+00, 7.9886072534E-01],
	[2.0660000000E+04, 1.1585536379E+01, 5.2856764830E+00, 1.8809329525E+00, 1.2389176918E+00, 7.9895248944E-01],
	[2.0665000000E+04, 1.1589710957E+01, 5.2855457709E+00, 1.8823907606E+00, 1.2395905748E+00, 7.9904421820E-01],
	[2.0670000000E+04, 1.1593886028E+01, 5.2854150937E+00, 1.8838493448E+00, 1.2402635182E+00, 7.9913591163E-01],
	[2.0675000000E+04, 1.1598061593E+01, 5.2852844513E+00, 1.8853087055E+00, 1.2409365216E+00, 7.9922756972E-01],
	[2.0680000000E+04, 1.1602237652E+01, 5.2851538437E+00, 1.8867688428E+00, 1.2416095851E+00, 7.9931919249E-01],
	[2.0685000000E+04, 1.1606414204E+01, 5.2850232709E+00, 1.8882297570E+00, 1.2422827083E+00, 7.9941077994E-01],
	[2.0690000000E+04, 1.1610591250E+01, 5.2848927330E+00, 1.8896914483E+00, 1.2429558912E+00, 7.9950233209E-01],
	[2.0695000000E+04, 1.1614768789E+01, 5.2847622297E+00, 1.8911539168E+00, 1.2436291335E+00, 7.9959384892E-01],
	[2.0700000000E+04, 1.1618946821E+01, 5.2846317612E+00, 1.8926171629E+00, 1.2443024352E+00, 7.9968533046E-01],
	[2.0705000000E+04, 1.1623125347E+01, 5.2845013275E+00, 1.8940811868E+00, 1.2449757961E+00, 7.9977677671E-01],
	[2.0710000000E+04, 1.1627304366E+01, 5.2843709284E+00, 1.8955459887E+00, 1.2456492160E+00, 7.9986818767E-01],
	[2.0715000000E+04, 1.1631488785E+01, 5.2842417680E+00, 1.8970115687E+00, 1.2463228180E+00, 7.9995956335E-01],
	[2.0720000000E+04, 1.1635687920E+01, 5.2841161300E+00, 1.8984779272E+00, 1.2469968365E+00, 8.0005090376E-01],
	[2.0725000000E+04, 1.1639887557E+01, 5.2839905253E+00, 1.8999450643E+00, 1.2476709143E+00, 8.0014220891E-01],
	[2.0730000000E+04, 1.1644087696E+01, 5.2838649539E+00, 1.9014129804E+00, 1.2483450512E+00, 8.0023347879E-01],
	[2.0735000000E+04, 1.1648288338E+01, 5.2837394158E+00, 1.9028816755E+00, 1.2490192471E+00, 8.0032471342E-01],
	[2.0740000000E+04, 1.1652489481E+01, 5.2836139109E+00, 1.9043511500E+00, 1.2496935019E+00, 8.0041591281E-01],
	[2.0745000000E+04, 1.1656691127E+01, 5.2834884393E+00, 1.9058214040E+00, 1.2503678153E+00, 8.0050707695E-01],
	[2.0750000000E+04, 1.1660893274E+01, 5.2833630009E+00, 1.9072924378E+00, 1.2510421872E+00, 8.0059820586E-01],
	[2.0755000000E+04, 1.1665095923E+01, 5.2832375956E+00, 1.9087642516E+00, 1.2517166175E+00, 8.0068929955E-01],
	[2.0760000000E+04, 1.1669299074E+01, 5.2831122236E+00, 1.9102368457E+00, 1.2523911060E+00, 8.0078035801E-01],
	[2.0765000000E+04, 1.1673502727E+01, 5.2829868847E+00, 1.9117102202E+00, 1.2530656525E+00, 8.0087138126E-01],
	[2.0770000000E+04, 1.1677706881E+01, 5.2828615790E+00, 1.9131843754E+00, 1.2537402569E+00, 8.0096236930E-01],
	[2.0775000000E+04, 1.1681911537E+01, 5.2827363064E+00, 1.9146593115E+00, 1.2544149189E+00, 8.0105332215E-01],
	[2.0780000000E+04, 1.1686116695E+01, 5.2826110669E+00, 1.9161350288E+00, 1.2550896386E+00, 8.0114423979E-01],
	[2.0785000000E+04, 1.1690322354E+01, 5.2824858605E+00, 1.9176115274E+00, 1.2557644156E+00, 8.0123512225E-01],
	[2.0790000000E+04, 1.1694528515E+01, 5.2823606872E+00, 1.9190888076E+00, 1.2564392499E+00, 8.0132596953E-01],
	[2.0795000000E+04, 1.1698735176E+01, 5.2822355470E+00, 1.9205668696E+00, 1.2571141412E+00, 8.0141678164E-01],
	[2.0800000000E+04, 1.1702942340E+01, 5.2821104398E+00, 1.9220457136E+00, 1.2577890895E+00, 8.0150755858E-01],
	[2.0805000000E+04, 1.1707150004E+01, 5.2819853657E+00, 1.9235253399E+00, 1.2584640945E+00, 8.0159830035E-01],
	[2.0810000000E+04, 1.1711358170E+01, 5.2818603245E+00, 1.9250057487E+00, 1.2591391561E+00, 8.0168900698E-01],
	[2.0815000000E+04, 1.1715566836E+01, 5.2817353164E+00, 1.9264869401E+00, 1.2598142742E+00, 8.0177967845E-01],
	[2.0820000000E+04, 1.1719776004E+01, 5.2816103412E+00, 1.9279689146E+00, 1.2604894485E+00, 8.0187031479E-01],
	[2.0825000000E+04, 1.1723985673E+01, 5.2814853990E+00, 1.9294516721E+00, 1.2611646790E+00, 8.0196091599E-01],
	[2.0830000000E+04, 1.1728195842E+01, 5.2813604898E+00, 1.9309352131E+00, 1.2618399654E+00, 8.0205148206E-01],
	[2.0835000000E+04, 1.1732406513E+01, 5.2812356135E+00, 1.9324195377E+00, 1.2625153076E+00, 8.0214201302E-01],
	[2.0840000000E+04, 1.1736617684E+01, 5.2811107701E+00, 1.9339046461E+00, 1.2631907055E+00, 8.0223250886E-01],
	[2.0845000000E+04, 1.1740829357E+01, 5.2809859596E+00, 1.9353905386E+00, 1.2638661589E+00, 8.0232296959E-01],
	[2.0850000000E+04, 1.1745041529E+01, 5.2808611820E+00, 1.9368772153E+00, 1.2645416676E+00, 8.0241339523E-01],
	[2.0855000000E+04, 1.1749254203E+01, 5.2807364372E+00, 1.9383646766E+00, 1.2652172314E+00, 8.0250378577E-01],
	[2.0860000000E+04, 1.1753467377E+01, 5.2806117253E+00, 1.9398529226E+00, 1.2658928503E+00, 8.0259414122E-01],
	[2.0865000000E+04, 1.1757681051E+01, 5.2804870463E+00, 1.9413419536E+00, 1.2665685240E+00, 8.0268446160E-01],
	[2.0870000000E+04, 1.1761895226E+01, 5.2803624000E+00, 1.9428317698E+00, 1.2672442525E+00, 8.0277474690E-01],
	[2.0875000000E+04, 1.1766109902E+01, 5.2802377866E+00, 1.9443223713E+00, 1.2679200354E+00, 8.0286499713E-01],
	[2.0880000000E+04, 1.1770325078E+01, 5.2801132059E+00, 1.9458137586E+00, 1.2685958727E+00, 8.0295521231E-01],
	[2.0885000000E+04, 1.1774540754E+01, 5.2799886580E+00, 1.9473059316E+00, 1.2692717643E+00, 8.0304539244E-01],
	[2.0890000000E+04, 1.1778756930E+01, 5.2798641429E+00, 1.9487988908E+00, 1.2699477099E+00, 8.0313553752E-01],
	[2.0895000000E+04, 1.1782973606E+01, 5.2797396605E+00, 1.9502926363E+00, 1.2706237094E+00, 8.0322564756E-01],
	[2.0900000000E+04, 1.1787190783E+01, 5.2796152108E+00, 1.9517871683E+00, 1.2712997627E+00, 8.0331572257E-01],
	[2.0905000000E+04, 1.1791408459E+01, 5.2794907938E+00, 1.9532824871E+00, 1.2719758695E+00, 8.0340576256E-01],
	[2.0910000000E+04, 1.1795626636E+01, 5.2793664095E+00, 1.9547785929E+00, 1.2726520298E+00, 8.0349576753E-01],
	[2.0915000000E+04, 1.1799845312E+01, 5.2792420579E+00, 1.9562754859E+00, 1.2733282433E+00, 8.0358573749E-01],
	[2.0920000000E+04, 1.1804064488E+01, 5.2791177389E+00, 1.9577731663E+00, 1.2740045099E+00, 8.0367567245E-01],
	[2.0925000000E+04, 1.1808284164E+01, 5.2789934525E+00, 1.9592716344E+00, 1.2746808295E+00, 8.0376557241E-01],
	[2.0930000000E+04, 1.1812504340E+01, 5.2788691988E+00, 1.9607708904E+00, 1.2753572019E+00, 8.0385543738E-01],
	[2.0935000000E+04, 1.1816725015E+01, 5.2787449777E+00, 1.9622709345E+00, 1.2760336269E+00, 8.0394526737E-01],
	[2.0940000000E+04, 1.1820946190E+01, 5.2786207891E+00, 1.9637717670E+00, 1.2767101044E+00, 8.0403506239E-01],
	[2.0945000000E+04, 1.1825167865E+01, 5.2784966332E+00, 1.9652733880E+00, 1.2773866342E+00, 8.0412482244E-01],
	[2.0950000000E+04, 1.1829390039E+01, 5.2783725098E+00, 1.9667757978E+00, 1.2780632162E+00, 8.0421454752E-01],
	[2.0955000000E+04, 1.1833612713E+01, 5.2782484189E+00, 1.9682789966E+00, 1.2787398502E+00, 8.0430423765E-01],
	[2.0960000000E+04, 1.1837835885E+01, 5.2781243605E+00, 1.9697829847E+00, 1.2794165360E+00, 8.0439389284E-01],
	[2.0965000000E+04, 1.1842059558E+01, 5.2780003347E+00, 1.9712877622E+00, 1.2800932735E+00, 8.0448351309E-01],
	[2.0970000000E+04, 1.1846283729E+01, 5.2778763413E+00, 1.9727933295E+00, 1.2807700626E+00, 8.0457309840E-01],
	[2.0975000000E+04, 1.1850508400E+01, 5.2777523804E+00, 1.9742996867E+00, 1.2814469030E+00, 8.0466264879E-01],
	[2.0980000000E+04, 1.1854733569E+01, 5.2776284520E+00, 1.9758068340E+00, 1.2821237946E+00, 8.0475216426E-01],
	[2.0985000000E+04, 1.1858959238E+01, 5.2775045560E+00, 1.9773147717E+00, 1.2828007373E+00, 8.0484164482E-01],
	[2.0990000000E+04, 1.1863185406E+01, 5.2773806925E+00, 1.9788234999E+00, 1.2834777308E+00, 8.0493109047E-01],
	[2.0995000000E+04, 1.1867412073E+01, 5.2772568613E+00, 1.9803330190E+00, 1.2841547751E+00, 8.0502050123E-01],
	[2.1000000000E+04, 1.1871639238E+01, 5.2771330625E+00, 1.9818433292E+00, 1.2848318700E+00, 8.0510987710E-01],
	[2.1005000000E+04, 1.1875866903E+01, 5.2770092961E+00, 1.9833544306E+00, 1.2855090153E+00, 8.0519921808E-01],
	[2.1010000000E+04, 1.1880095066E+01, 5.2768855621E+00, 1.9848663236E+00, 1.2861862109E+00, 8.0528852420E-01],
	[2.1015000000E+04, 1.1884323728E+01, 5.2767618604E+00, 1.9863790082E+00, 1.2868634566E+00, 8.0537779544E-01],
	[2.1020000000E+04, 1.1888552889E+01, 5.2766381911E+00, 1.9878924848E+00, 1.2875407522E+00, 8.0546703182E-01],
	[2.1025000000E+04, 1.1892782548E+01, 5.2765145540E+00, 1.9894067536E+00, 1.2882180976E+00, 8.0555623335E-01],
	[2.1030000000E+04, 1.1897012705E+01, 5.2763909493E+00, 1.9909218148E+00, 1.2888954927E+00, 8.0564540004E-01],
	[2.1035000000E+04, 1.1901243362E+01, 5.2762673768E+00, 1.9924376686E+00, 1.2895729372E+00, 8.0573453188E-01],
	[2.1040000000E+04, 1.1905474516E+01, 5.2761438366E+00, 1.9939543153E+00, 1.2902504311E+00, 8.0582362890E-01],
	[2.1045000000E+04, 1.1909706169E+01, 5.2760203286E+00, 1.9954717550E+00, 1.2909279741E+00, 8.0591269109E-01],
	[2.1050000000E+04, 1.1913949242E+01, 5.2758994583E+00, 1.9969899881E+00, 1.2916058506E+00, 8.0600171846E-01],
	[2.1055000000E+04, 1.1918201262E+01, 5.2757806332E+00, 1.9985090146E+00, 1.2922839965E+00, 8.0609071103E-01],
	[2.1060000000E+04, 1.1922453789E+01, 5.2756618390E+00, 2.0000288350E+00, 1.2929621919E+00, 8.0617966879E-01],
	[2.1065000000E+04, 1.1926706824E+01, 5.2755430756E+00, 2.0015494493E+00, 1.2936404367E+00, 8.0626859176E-01],
	[2.1070000000E+04, 1.1930960366E+01, 5.2754243431E+00, 2.0030708578E+00, 1.2943187305E+00, 8.0635747994E-01],
	[2.1075000000E+04, 1.1935214415E+01, 5.2753056415E+00, 2.0045930608E+00, 1.2949970734E+00, 8.0644633334E-01],
	[2.1080000000E+04, 1.1939468971E+01, 5.2751869706E+00, 2.0061160584E+00, 1.2956754652E+00, 8.0653515197E-01],
	[2.1085000000E+04, 1.1943724034E+01, 5.2750683306E+00, 2.0076398509E+00, 1.2963539056E+00, 8.0662393583E-01],
	[2.1090000000E+04, 1.1947979604E+01, 5.2749497214E+00, 2.0091644385E+00, 1.2970323946E+00, 8.0671268494E-01],
	[2.1095000000E+04, 1.1952235682E+01, 5.2748311430E+00, 2.0106898215E+00, 1.2977109319E+00, 8.0680139929E-01],
	[2.1100000000E+04, 1.1956492266E+01, 5.2747125953E+00, 2.0122160000E+00, 1.2983895175E+00, 8.0689007890E-01],
	[2.1105000000E+04, 1.1960749357E+01, 5.2745940784E+00, 2.0137429743E+00, 1.2990681512E+00, 8.0697872378E-01],
	[2.1110000000E+04, 1.1965006954E+01, 5.2744755922E+00, 2.0152707446E+00, 1.2997468327E+00, 8.0706733393E-01],
	[2.1115000000E+04, 1.1969265059E+01, 5.2743571368E+00, 2.0167993112E+00, 1.3004255621E+00, 8.0715590936E-01],
	[2.1120000000E+04, 1.1973523670E+01, 5.2742387120E+00, 2.0183286742E+00, 1.3011043390E+00, 8.0724445008E-01],
	[2.1125000000E+04, 1.1977782787E+01, 5.2741203180E+00, 2.0198588339E+00, 1.3017831633E+00, 8.0733295609E-01],
	[2.1130000000E+04, 1.1982042411E+01, 5.2740019546E+00, 2.0213897905E+00, 1.3024620349E+00, 8.0742142740E-01],
	[2.1135000000E+04, 1.1986302542E+01, 5.2738836219E+00, 2.0229215443E+00, 1.3031409537E+00, 8.0750986403E-01],
	[2.1140000000E+04, 1.1990563179E+01, 5.2737653198E+00, 2.0244540955E+00, 1.3038199194E+00, 8.0759826597E-01],
	[2.1145000000E+04, 1.1994824322E+01, 5.2736470483E+00, 2.0259874442E+00, 1.3044989320E+00, 8.0768663323E-01],
	[2.1150000000E+04, 1.1999085972E+01, 5.2735288075E+00, 2.0275215908E+00, 1.3051779912E+00, 8.0777496583E-01],
	[2.1155000000E+04, 1.2003348128E+01, 5.2734105973E+00, 2.0290565354E+00, 1.3058570969E+00, 8.0786326377E-01],
	[2.1160000000E+04, 1.2007610790E+01, 5.2732924176E+00, 2.0305922782E+00, 1.3065362489E+00, 8.0795152706E-01],
	[2.1165000000E+04, 1.2011873958E+01, 5.2731742685E+00, 2.0321288196E+00, 1.3072154472E+00, 8.0803975570E-01],
	[2.1170000000E+04, 1.2016137632E+01, 5.2730561500E+00, 2.0336661597E+00, 1.3078946915E+00, 8.0812794970E-01],
	[2.1175000000E+04, 1.2020401812E+01, 5.2729380620E+00, 2.0352042987E+00, 1.3085739816E+00, 8.0821610908E-01],
	[2.1180000000E+04, 1.2024666498E+01, 5.2728200046E+00, 2.0367432370E+00, 1.3092533175E+00, 8.0830423383E-01],
	[2.1185000000E+04, 1.2028931690E+01, 5.2727019776E+00, 2.0382829746E+00, 1.3099326989E+00, 8.0839232397E-01],
	[2.1190000000E+04, 1.2033197388E+01, 5.2725839812E+00, 2.0398235118E+00, 1.3106121257E+00, 8.0848037951E-01],
	[2.1195000000E+04, 1.2037463591E+01, 5.2724660152E+00, 2.0413648490E+00, 1.3112915978E+00, 8.0856840044E-01],
	[2.1200000000E+04, 1.2041730300E+01, 5.2723480797E+00, 2.0429069861E+00, 1.3119711150E+00, 8.0865638678E-01],
	[2.1205000000E+04, 1.2045997515E+01, 5.2722301746E+00, 2.0444499236E+00, 1.3126506771E+00, 8.0874433854E-01],
	[2.1210000000E+04, 1.2050265235E+01, 5.2721123000E+00, 2.0459936616E+00, 1.3133302840E+00, 8.0883225573E-01],
	[2.1215000000E+04, 1.2054533461E+01, 5.2719944558E+00, 2.0475382004E+00, 1.3140099356E+00, 8.0892013834E-01],
	[2.1220000000E+04, 1.2058802193E+01, 5.2718766420E+00, 2.0490835402E+00, 1.3146896316E+00, 8.0900798640E-01],
	[2.1225000000E+04, 1.2063071429E+01, 5.2717588585E+00, 2.0506296812E+00, 1.3153693719E+00, 8.0909579990E-01],
	[2.1230000000E+04, 1.2067341171E+01, 5.2716411055E+00, 2.0521766236E+00, 1.3160491564E+00, 8.0918357886E-01],
	[2.1235000000E+04, 1.2071611419E+01, 5.2715233828E+00, 2.0537243676E+00, 1.3167289849E+00, 8.0927132328E-01],
	[2.1240000000E+04, 1.2075882171E+01, 5.2714056905E+00, 2.0552729136E+00, 1.3174088572E+00, 8.0935903317E-01],
	[2.1245000000E+04, 1.2080153429E+01, 5.2712880284E+00, 2.0568222617E+00, 1.3180887732E+00, 8.0944670854E-01],
	[2.1250000000E+04, 1.2084425192E+01, 5.2711703967E+00, 2.0583724121E+00, 1.3187687328E+00, 8.0953434940E-01],
	[2.1255000000E+04, 1.2088697460E+01, 5.2710527953E+00, 2.0599233651E+00, 1.3194487357E+00, 8.0962195575E-01],
	[2.1260000000E+04, 1.2092970232E+01, 5.2709352242E+00, 2.0614751208E+00, 1.3201287819E+00, 8.0970952761E-01],
	[2.1265000000E+04, 1.2097243510E+01, 5.2708176834E+00, 2.0630276796E+00, 1.3208088711E+00, 8.0979706497E-01],
	[2.1270000000E+04, 1.2101517293E+01, 5.2707001728E+00, 2.0645810417E+00, 1.3214890032E+00, 8.0988456785E-01],
	[2.1275000000E+04, 1.2105791580E+01, 5.2705826924E+00, 2.0661352072E+00, 1.3221691781E+00, 8.0997203626E-01],
	[2.1280000000E+04, 1.2110066372E+01, 5.2704652423E+00, 2.0676901764E+00, 1.3228493956E+00, 8.1005947020E-01],
	[2.1285000000E+04, 1.2114341669E+01, 5.2703478224E+00, 2.0692459495E+00, 1.3235296556E+00, 8.1014686968E-01],
	[2.1290000000E+04, 1.2118617471E+01, 5.2702304326E+00, 2.0708025267E+00, 1.3242099578E+00, 8.1023423471E-01],
	[2.1295000000E+04, 1.2122893777E+01, 5.2701130731E+00, 2.0723599084E+00, 1.3248903022E+00, 8.1032156526E-01],
	[2.1300000000E+04, 1.2127170587E+01, 5.2699957437E+00, 2.0739180946E+00, 1.3255706886E+00, 8.1040886135E-01],
	[2.1305000000E+04, 1.2131447902E+01, 5.2698784445E+00, 2.0754770857E+00, 1.3262511167E+00, 8.1049612297E-01],
	[2.1310000000E+04, 1.2135725721E+01, 5.2697611754E+00, 2.0770368818E+00, 1.3269315866E+00, 8.1058335012E-01],
	[2.1315000000E+04, 1.2140004045E+01, 5.2696439364E+00, 2.0785974832E+00, 1.3276120980E+00, 8.1067054282E-01],
	[2.1320000000E+04, 1.2144282873E+01, 5.2695267275E+00, 2.0801588902E+00, 1.3282926507E+00, 8.1075770106E-01],
	[2.1325000000E+04, 1.2148562205E+01, 5.2694095487E+00, 2.0817211028E+00, 1.3289732446E+00, 8.1084482485E-01],
	[2.1330000000E+04, 1.2152842042E+01, 5.2692924000E+00, 2.0832841214E+00, 1.3296538796E+00, 8.1093191419E-01],
	[2.1335000000E+04, 1.2157122382E+01, 5.2691752814E+00, 2.0848479462E+00, 1.3303345555E+00, 8.1101896908E-01],
	[2.1340000000E+04, 1.2161403226E+01, 5.2690581928E+00, 2.0864125774E+00, 1.3310152721E+00, 8.1110598953E-01],
	[2.1345000000E+04, 1.2165684575E+01, 5.2689411342E+00, 2.0879780152E+00, 1.3316960293E+00, 8.1119297554E-01],
	[2.1350000000E+04, 1.2169966427E+01, 5.2688241057E+00, 2.0895442599E+00, 1.3323768269E+00, 8.1127992712E-01],
	[2.1355000000E+04, 1.2174248783E+01, 5.2687071071E+00, 2.0911113117E+00, 1.3330576648E+00, 8.1136684426E-01],
	[2.1360000000E+04, 1.2178531643E+01, 5.2685901386E+00, 2.0926791708E+00, 1.3337385428E+00, 8.1145372697E-01],
	[2.1365000000E+04, 1.2182815007E+01, 5.2684732000E+00, 2.0942478375E+00, 1.3344194608E+00, 8.1154057526E-01],
	[2.1370000000E+04, 1.2187098875E+01, 5.2683562913E+00, 2.0958173119E+00, 1.3351004186E+00, 8.1162738913E-01],
	[2.1375000000E+04, 1.2191383246E+01, 5.2682394127E+00, 2.0973875943E+00, 1.3357814160E+00, 8.1171416858E-01],
	[2.1380000000E+04, 1.2195668120E+01, 5.2681225639E+00, 2.0989586849E+00, 1.3364624530E+00, 8.1180091361E-01],
	[2.1385000000E+04, 1.2199953498E+01, 5.2680057451E+00, 2.1005305840E+00, 1.3371435293E+00, 8.1188762424E-01],
	[2.1390000000E+04, 1.2204255023E+01, 5.2678925845E+00, 2.1021032918E+00, 1.3378250667E+00, 8.1197430045E-01],
	[2.1395000000E+04, 1.2208561024E+01, 5.2677803720E+00, 2.1036768084E+00, 1.3385067509E+00, 8.1206094227E-01],
	[2.1400000000E+04, 1.2212867537E+01, 5.2676681882E+00, 2.1052511342E+00, 1.3391884747E+00, 8.1214754968E-01],
	[2.1405000000E+04, 1.2217174562E+01, 5.2675560330E+00, 2.1068262693E+00, 1.3398702381E+00, 8.1223412270E-01],
	[2.1410000000E+04, 1.2221482100E+01, 5.2674439063E+00, 2.1084022140E+00, 1.3405520408E+00, 8.1232066132E-01],
	[2.1415000000E+04, 1.2225790150E+01, 5.2673318083E+00, 2.1099789686E+00, 1.3412338828E+00, 8.1240716555E-01],
	[2.1420000000E+04, 1.2230098713E+01, 5.2672197387E+00, 2.1115565331E+00, 1.3419157638E+00, 8.1249363540E-01],
	[2.1425000000E+04, 1.2234407788E+01, 5.2671076977E+00, 2.1131349079E+00, 1.3425976837E+00, 8.1258007087E-01],
	[2.1430000000E+04, 1.2238717375E+01, 5.2669956853E+00, 2.1147140932E+00, 1.3432796424E+00, 8.1266647196E-01],
	[2.1435000000E+04, 1.2243027474E+01, 5.2668837013E+00, 2.1162940892E+00, 1.3439616397E+00, 8.1275283868E-01],
	[2.1440000000E+04, 1.2247338085E+01, 5.2667717459E+00, 2.1178748962E+00, 1.3446436755E+00, 8.1283917102E-01],
	[2.1445000000E+04, 1.2251649208E+01, 5.2666598189E+00, 2.1194565143E+00, 1.3453257495E+00, 8.1292546900E-01],
	[2.1450000000E+04, 1.2255960844E+01, 5.2665479204E+00, 2.1210389438E+00, 1.3460078617E+00, 8.1301173262E-01],
	[2.1455000000E+04, 1.2260272991E+01, 5.2664360504E+00, 2.1226221849E+00, 1.3466900118E+00, 8.1309796188E-01],
	[2.1460000000E+04, 1.2264585650E+01, 5.2663242088E+00, 2.1242062379E+00, 1.3473721998E+00, 8.1318415679E-01],
	[2.1465000000E+04, 1.2268898821E+01, 5.2662123957E+00, 2.1257911029E+00, 1.3480544255E+00, 8.1327031734E-01],
	[2.1470000000E+04, 1.2273212503E+01, 5.2661006109E+00, 2.1273767802E+00, 1.3487366887E+00, 8.1335644355E-01],
	[2.1475000000E+04, 1.2277526697E+01, 5.2659888546E+00, 2.1289632701E+00, 1.3494189893E+00, 8.1344253541E-01],
	[2.1480000000E+04, 1.2281841403E+01, 5.2658771266E+00, 2.1305505727E+00, 1.3501013271E+00, 8.1352859294E-01],
	[2.1485000000E+04, 1.2286156621E+01, 5.2657654270E+00, 2.1321386883E+00, 1.3507837020E+00, 8.1361461613E-01],
	[2.1490000000E+04, 1.2290472349E+01, 5.2656537558E+00, 2.1337276170E+00, 1.3514661138E+00, 8.1370060499E-01],
	[2.1495000000E+04, 1.2294788590E+01, 5.2655421129E+00, 2.1353173593E+00, 1.3521485623E+00, 8.1378655953E-01],
	[2.1500000000E+04, 1.2299105341E+01, 5.2654304984E+00, 2.1369079151E+00, 1.3528310475E+00, 8.1387247974E-01],
	[2.1505000000E+04, 1.2303422604E+01, 5.2653189122E+00, 2.1384992849E+00, 1.3535135691E+00, 8.1395836563E-01],
	[2.1510000000E+04, 1.2307740379E+01, 5.2652073543E+00, 2.1400914687E+00, 1.3541961270E+00, 8.1404421721E-01],
	[2.1515000000E+04, 1.2312058664E+01, 5.2650958246E+00, 2.1416844669E+00, 1.3548787210E+00, 8.1413003448E-01],
	[2.1520000000E+04, 1.2316377461E+01, 5.2649843233E+00, 2.1432782797E+00, 1.3555613510E+00, 8.1421581745E-01],
	[2.1525000000E+04, 1.2320696769E+01, 5.2648728502E+00, 2.1448729073E+00, 1.3562440169E+00, 8.1430156611E-01],
	[2.1530000000E+04, 1.2325016587E+01, 5.2647614054E+00, 2.1464683498E+00, 1.3569267185E+00, 8.1438728047E-01],
	[2.1535000000E+04, 1.2329336917E+01, 5.2646499888E+00, 2.1480646076E+00, 1.3576094556E+00, 8.1447296054E-01],
	[2.1540000000E+04, 1.2333657758E+01, 5.2645386004E+00, 2.1496616809E+00, 1.3582922280E+00, 8.1455860633E-01],
	[2.1545000000E+04, 1.2337979109E+01, 5.2644272402E+00, 2.1512595699E+00, 1.3589750357E+00, 8.1464421782E-01],
	[2.1550000000E+04, 1.2342300971E+01, 5.2643159083E+00, 2.1528582748E+00, 1.3596578785E+00, 8.1472979504E-01],
	[2.1555000000E+04, 1.2346623344E+01, 5.2642046045E+00, 2.1544577958E+00, 1.3603407562E+00, 8.1481533798E-01],
	[2.1560000000E+04, 1.2350946228E+01, 5.2640933289E+00, 2.1560581333E+00, 1.3610236687E+00, 8.1490084665E-01],
	[2.1565000000E+04, 1.2355269622E+01, 5.2639820814E+00, 2.1576592873E+00, 1.3617066157E+00, 8.1498632105E-01],
	[2.1570000000E+04, 1.2359593527E+01, 5.2638708621E+00, 2.1592612581E+00, 1.3623895973E+00, 8.1507176119E-01],
	[2.1575000000E+04, 1.2363917943E+01, 5.2637596709E+00, 2.1608640460E+00, 1.3630726131E+00, 8.1515716707E-01],
	[2.1580000000E+04, 1.2368242869E+01, 5.2636485078E+00, 2.1624676512E+00, 1.3637556631E+00, 8.1524253869E-01],
	[2.1585000000E+04, 1.2372568305E+01, 5.2635373728E+00, 2.1640720740E+00, 1.3644387471E+00, 8.1532787607E-01],
	[2.1590000000E+04, 1.2376894251E+01, 5.2634262659E+00, 2.1656773144E+00, 1.3651218650E+00, 8.1541317920E-01],
	[2.1595000000E+04, 1.2381220708E+01, 5.2633151871E+00, 2.1672833728E+00, 1.3658050165E+00, 8.1549844808E-01],
	[2.1600000000E+04, 1.2385547675E+01, 5.2632041363E+00, 2.1688902494E+00, 1.3664882016E+00, 8.1558368274E-01],
	[2.1605000000E+04, 1.2389875152E+01, 5.2630931136E+00, 2.1704979444E+00, 1.3671714201E+00, 8.1566888316E-01],
	[2.1610000000E+04, 1.2394203140E+01, 5.2629821189E+00, 2.1721064581E+00, 1.3678546718E+00, 8.1575404935E-01],
	[2.1615000000E+04, 1.2398531637E+01, 5.2628711522E+00, 2.1737157906E+00, 1.3685379566E+00, 8.1583918132E-01],
	[2.1620000000E+04, 1.2402860645E+01, 5.2627602136E+00, 2.1753259422E+00, 1.3692212744E+00, 8.1592427907E-01],
	[2.1625000000E+04, 1.2407190162E+01, 5.2626493029E+00, 2.1769369132E+00, 1.3699046249E+00, 8.1600934261E-01],
	[2.1630000000E+04, 1.2411520189E+01, 5.2625384202E+00, 2.1785487037E+00, 1.3705880081E+00, 8.1609437194E-01],
	[2.1635000000E+04, 1.2415850726E+01, 5.2624275654E+00, 2.1801613139E+00, 1.3712714237E+00, 8.1617936706E-01],
	[2.1640000000E+04, 1.2420181773E+01, 5.2623167387E+00, 2.1817747442E+00, 1.3719548717E+00, 8.1626432798E-01],
	[2.1645000000E+04, 1.2424513329E+01, 5.2622059398E+00, 2.1833889947E+00, 1.3726383518E+00, 8.1634925471E-01],
	[2.1650000000E+04, 1.2428845395E+01, 5.2620951689E+00, 2.1850040657E+00, 1.3733218640E+00, 8.1643414725E-01],
	[2.1655000000E+04, 1.2433177971E+01, 5.2619844259E+00, 2.1866199574E+00, 1.3740054081E+00, 8.1651900560E-01],
	[2.1660000000E+04, 1.2437511056E+01, 5.2618737108E+00, 2.1882366699E+00, 1.3746889838E+00, 8.1660382977E-01],
	[2.1665000000E+04, 1.2441844650E+01, 5.2617630235E+00, 2.1898542036E+00, 1.3753725911E+00, 8.1668861977E-01],
	[2.1670000000E+04, 1.2446178754E+01, 5.2616523642E+00, 2.1914725587E+00, 1.3760562299E+00, 8.1677337559E-01],
	[2.1675000000E+04, 1.2450513368E+01, 5.2615417327E+00, 2.1930917354E+00, 1.3767398998E+00, 8.1685809725E-01],
	[2.1680000000E+04, 1.2454848491E+01, 5.2614311290E+00, 2.1947117339E+00, 1.3774236010E+00, 8.1694278474E-01],
	[2.1685000000E+04, 1.2459184122E+01, 5.2613205532E+00, 2.1963325544E+00, 1.3781073330E+00, 8.1702743808E-01],
	[2.1690000000E+04, 1.2463520263E+01, 5.2612100052E+00, 2.1979541972E+00, 1.3787910959E+00, 8.1711205726E-01],
	[2.1695000000E+04, 1.2467856914E+01, 5.2610994849E+00, 2.1995766625E+00, 1.3794748894E+00, 8.1719664230E-01],
	[2.1700000000E+04, 1.2472194073E+01, 5.2609889925E+00, 2.2011999505E+00, 1.3801587134E+00, 8.1728119320E-01],
	[2.1705000000E+04, 1.2476531741E+01, 5.2608785279E+00, 2.2028240615E+00, 1.3808425678E+00, 8.1736570995E-01],
	[2.1710000000E+04, 1.2480869918E+01, 5.2607680910E+00, 2.2044489957E+00, 1.3815264524E+00, 8.1745019258E-01],
	[2.1715000000E+04, 1.2485208604E+01, 5.2606576818E+00, 2.2060747533E+00, 1.3822103670E+00, 8.1753464107E-01],
	[2.1720000000E+04, 1.2489547799E+01, 5.2605473004E+00, 2.2077013345E+00, 1.3828943115E+00, 8.1761905545E-01],
	[2.1725000000E+04, 1.2493887503E+01, 5.2604369468E+00, 2.2093287396E+00, 1.3835782858E+00, 8.1770343570E-01],
	[2.1730000000E+04, 1.2498227716E+01, 5.2603266208E+00, 2.2109569688E+00, 1.3842622896E+00, 8.1778778185E-01],
	[2.1735000000E+04, 1.2502587115E+01, 5.2602205345E+00, 2.2125860223E+00, 1.3849468441E+00, 8.1787209388E-01],
	[2.1740000000E+04, 1.2506948209E+01, 5.2601147402E+00, 2.2142159003E+00, 1.3856314615E+00, 8.1795637181E-01],
	[2.1745000000E+04, 1.2511309820E+01, 5.2600089724E+00, 2.2158466031E+00, 1.3863161089E+00, 8.1804061565E-01],
	[2.1750000000E+04, 1.2515671950E+01, 5.2599032311E+00, 2.2174781309E+00, 1.3870007860E+00, 8.1812482539E-01],
	[2.1755000000E+04, 1.2520034597E+01, 5.2597975161E+00, 2.2191104839E+00, 1.3876854928E+00, 8.1820900104E-01],
	[2.1760000000E+04, 1.2524397762E+01, 5.2596918276E+00, 2.2207436624E+00, 1.3883702291E+00, 8.1829314262E-01],
	[2.1765000000E+04, 1.2528761445E+01, 5.2595861655E+00, 2.2223776666E+00, 1.3890549947E+00, 8.1837725011E-01],
	[2.1770000000E+04, 1.2533125645E+01, 5.2594805298E+00, 2.2240124966E+00, 1.3897397896E+00, 8.1846132353E-01],
	[2.1775000000E+04, 1.2537490362E+01, 5.2593749204E+00, 2.2256481528E+00, 1.3904246134E+00, 8.1854536289E-01],
	[2.1780000000E+04, 1.2541855597E+01, 5.2592693375E+00, 2.2272846354E+00, 1.3911094662E+00, 8.1862936818E-01],
	[2.1785000000E+04, 1.2546221349E+01, 5.2591637808E+00, 2.2289219445E+00, 1.3917943477E+00, 8.1871333942E-01],
	[2.1790000000E+04, 1.2550587618E+01, 5.2590582506E+00, 2.2305600805E+00, 1.3924792579E+00, 8.1879727660E-01],
	[2.1795000000E+04, 1.2554954405E+01, 5.2589527466E+00, 2.2321990435E+00, 1.3931641964E+00, 8.1888117974E-01],
	[2.1800000000E+04, 1.2559321709E+01, 5.2588472690E+00, 2.2338388338E+00, 1.3938491633E+00, 8.1896504884E-01],
	[2.1805000000E+04, 1.2563689530E+01, 5.2587418176E+00, 2.2354794516E+00, 1.3945341583E+00, 8.1904888390E-01],
	[2.1810000000E+04, 1.2568057867E+01, 5.2586363926E+00, 2.2371208971E+00, 1.3952191812E+00, 8.1913268493E-01],
	[2.1815000000E+04, 1.2572426722E+01, 5.2585309938E+00, 2.2387631705E+00, 1.3959042321E+00, 8.1921645194E-01],
	[2.1820000000E+04, 1.2576796094E+01, 5.2584256214E+00, 2.2404062721E+00, 1.3965893106E+00, 8.1930018492E-01],
	[2.1825000000E+04, 1.2581165983E+01, 5.2583202751E+00, 2.2420502022E+00, 1.3972744166E+00, 8.1938388390E-01],
	[2.1830000000E+04, 1.2585536389E+01, 5.2582149551E+00, 2.2436949608E+00, 1.3979595501E+00, 8.1946754886E-01],
	[2.1835000000E+04, 1.2589907311E+01, 5.2581096614E+00, 2.2453405484E+00, 1.3986447108E+00, 8.1955117982E-01],
	[2.1840000000E+04, 1.2594278750E+01, 5.2580043938E+00, 2.2469869650E+00, 1.3993298986E+00, 8.1963477678E-01],
	[2.1845000000E+04, 1.2598650706E+01, 5.2578991525E+00, 2.2486342109E+00, 1.4000151133E+00, 8.1971833975E-01],
	[2.1850000000E+04, 1.2603023178E+01, 5.2577939373E+00, 2.2502822864E+00, 1.4007003548E+00, 8.1980186873E-01],
	[2.1855000000E+04, 1.2607396167E+01, 5.2576887483E+00, 2.2519311916E+00, 1.4013856229E+00, 8.1988536373E-01],
	[2.1860000000E+04, 1.2611769672E+01, 5.2575835855E+00, 2.2535809268E+00, 1.4020709176E+00, 8.1996882475E-01],
	[2.1865000000E+04, 1.2616143694E+01, 5.2574784488E+00, 2.2552314923E+00, 1.4027562386E+00, 8.2005225181E-01],
	[2.1870000000E+04, 1.2620518232E+01, 5.2573733383E+00, 2.2568828882E+00, 1.4034415857E+00, 8.2013564489E-01],
	[2.1875000000E+04, 1.2624893286E+01, 5.2572682539E+00, 2.2585351148E+00, 1.4041269590E+00, 8.2021900402E-01],
	[2.1880000000E+04, 1.2629268857E+01, 5.2571631957E+00, 2.2601881723E+00, 1.4048123581E+00, 8.2030232919E-01],
	[2.1885000000E+04, 1.2633644943E+01, 5.2570581635E+00, 2.2618420609E+00, 1.4054977829E+00, 8.2038562042E-01],
	[2.1890000000E+04, 1.2638021546E+01, 5.2569531574E+00, 2.2634967809E+00, 1.4061832334E+00, 8.2046887770E-01],
	[2.1895000000E+04, 1.2642398665E+01, 5.2568481774E+00, 2.2651523325E+00, 1.4068687092E+00, 8.2055210104E-01],
	[2.1900000000E+04, 1.2646776300E+01, 5.2567432235E+00, 2.2668087159E+00, 1.4075542104E+00, 8.2063529045E-01],
	[2.1905000000E+04, 1.2651154451E+01, 5.2566382956E+00, 2.2684659313E+00, 1.4082397367E+00, 8.2071844594E-01],
	[2.1910000000E+04, 1.2655533118E+01, 5.2565333938E+00, 2.2701239790E+00, 1.4089252880E+00, 8.2080156750E-01],
	[2.1915000000E+04, 1.2659912301E+01, 5.2564285180E+00, 2.2717828592E+00, 1.4096108642E+00, 8.2088465515E-01],
	[2.1920000000E+04, 1.2664291999E+01, 5.2563236682E+00, 2.2734425722E+00, 1.4102964651E+00, 8.2096770889E-01],
	[2.1925000000E+04, 1.2668672214E+01, 5.2562188444E+00, 2.2751031180E+00, 1.4109820905E+00, 8.2105072873E-01],
	[2.1930000000E+04, 1.2673052944E+01, 5.2561140466E+00, 2.2767644971E+00, 1.4116677403E+00, 8.2113371467E-01],
	[2.1935000000E+04, 1.2677434189E+01, 5.2560092748E+00, 2.2784267096E+00, 1.4123534143E+00, 8.2121666671E-01],
	[2.1940000000E+04, 1.2681815950E+01, 5.2559045289E+00, 2.2800897557E+00, 1.4130391124E+00, 8.2129958487E-01],
	[2.1945000000E+04, 1.2686198227E+01, 5.2557998091E+00, 2.2817536356E+00, 1.4137248345E+00, 8.2138246915E-01],
	[2.1950000000E+04, 1.2690581019E+01, 5.2556951151E+00, 2.2834183497E+00, 1.4144105804E+00, 8.2146531956E-01],
	[2.1955000000E+04, 1.2694964326E+01, 5.2555904471E+00, 2.2850838981E+00, 1.4150963500E+00, 8.2154813610E-01],
	[2.1960000000E+04, 1.2699348149E+01, 5.2554858050E+00, 2.2867502810E+00, 1.4157821430E+00, 8.2163091877E-01],
	[2.1965000000E+04, 1.2703732487E+01, 5.2553811888E+00, 2.2884174987E+00, 1.4164679594E+00, 8.2171366759E-01],
	[2.1970000000E+04, 1.2708117341E+01, 5.2552765985E+00, 2.2900855514E+00, 1.4171537990E+00, 8.2179638255E-01],
	[2.1975000000E+04, 1.2712502709E+01, 5.2551720341E+00, 2.2917544393E+00, 1.4178396617E+00, 8.2187906367E-01],
	[2.1980000000E+04, 1.2716888593E+01, 5.2550674955E+00, 2.2934241626E+00, 1.4185255473E+00, 8.2196171095E-01],
	[2.1985000000E+04, 1.2721274991E+01, 5.2549629828E+00, 2.2950947217E+00, 1.4192114556E+00, 8.2204432440E-01],
	[2.1990000000E+04, 1.2725661905E+01, 5.2548584960E+00, 2.2967661167E+00, 1.4198973865E+00, 8.2212690402E-01],
	[2.1995000000E+04, 1.2730049333E+01, 5.2547540350E+00, 2.2984383478E+00, 1.4205833399E+00, 8.2220944981E-01],
	[2.2000000000E+04, 1.2734437277E+01, 5.2546495998E+00, 2.3001114152E+00, 1.4212693157E+00, 8.2229196179E-01],
	[2.2005000000E+04, 1.2738825735E+01, 5.2545451904E+00, 2.3017853193E+00, 1.4219553135E+00, 8.2237443997E-01],
	[2.2010000000E+04, 1.2743214708E+01, 5.2544408068E+00, 2.3034600602E+00, 1.4226413334E+00, 8.2245688433E-01],
	[2.2015000000E+04, 1.2747604196E+01, 5.2543364490E+00, 2.3051356381E+00, 1.4233273752E+00, 8.2253929490E-01],
	[2.2020000000E+04, 1.2751994198E+01, 5.2542321169E+00, 2.3068120533E+00, 1.4240134387E+00, 8.2262167168E-01],
	[2.2025000000E+04, 1.2756384715E+01, 5.2541278106E+00, 2.3084893060E+00, 1.4246995237E+00, 8.2270401468E-01],
	[2.2030000000E+04, 1.2760775747E+01, 5.2540235301E+00, 2.3101673965E+00, 1.4253856302E+00, 8.2278632389E-01],
	[2.2035000000E+04, 1.2765167293E+01, 5.2539192753E+00, 2.3118463249E+00, 1.4260717580E+00, 8.2286859933E-01],
	[2.2040000000E+04, 1.2769559353E+01, 5.2538150462E+00, 2.3135260914E+00, 1.4267579068E+00, 8.2295084100E-01],
	[2.2045000000E+04, 1.2773951928E+01, 5.2537108428E+00, 2.3152066964E+00, 1.4274440767E+00, 8.2303304891E-01],
	[2.2050000000E+04, 1.2778345017E+01, 5.2536066652E+00, 2.3168881401E+00, 1.4281302674E+00, 8.2311522307E-01],
	[2.2055000000E+04, 1.2782738621E+01, 5.2535025132E+00, 2.3185704226E+00, 1.4288164788E+00, 8.2319736348E-01],
	[2.2060000000E+04, 1.2787132738E+01, 5.2533983869E+00, 2.3202535442E+00, 1.4295027107E+00, 8.2327947014E-01],
	[2.2065000000E+04, 1.2791527370E+01, 5.2532942862E+00, 2.3219375051E+00, 1.4301889630E+00, 8.2336154307E-01],
	[2.2070000000E+04, 1.2795922516E+01, 5.2531902112E+00, 2.3236223056E+00, 1.4308752355E+00, 8.2344358227E-01],
	[2.2075000000E+04, 1.2800318176E+01, 5.2530861618E+00, 2.3253079459E+00, 1.4315615281E+00, 8.2352558774E-01],
	[2.2080000000E+04, 1.2804714350E+01, 5.2529821381E+00, 2.3269944261E+00, 1.4322478407E+00, 8.2360755950E-01],
	[2.2085000000E+04, 1.2809130644E+01, 5.2528824387E+00, 2.3286817466E+00, 1.4329347383E+00, 8.2368949754E-01],
	[2.2090000000E+04, 1.2813547963E+01, 5.2527828736E+00, 2.3303699076E+00, 1.4336216708E+00, 8.2377140188E-01],
	[2.2095000000E+04, 1.2817965805E+01, 5.2526833330E+00, 2.3320589093E+00, 1.4343086237E+00, 8.2385327252E-01],
	[2.2100000000E+04, 1.2822384170E+01, 5.2525838168E+00, 2.3337487518E+00, 1.4349955967E+00, 8.2393510947E-01],
	[2.2105000000E+04, 1.2826803058E+01, 5.2524843250E+00, 2.3354394356E+00, 1.4356825897E+00, 8.2401691273E-01],
	[2.2110000000E+04, 1.2831222469E+01, 5.2523848576E+00, 2.3371309607E+00, 1.4363696027E+00, 8.2409868231E-01],
	[2.2115000000E+04, 1.2835642403E+01, 5.2522854145E+00, 2.3388233274E+00, 1.4370566353E+00, 8.2418041821E-01],
	[2.2120000000E+04, 1.2840062860E+01, 5.2521859958E+00, 2.3405165359E+00, 1.4377436876E+00, 8.2426212045E-01],
	[2.2125000000E+04, 1.2844483839E+01, 5.2520866015E+00, 2.3422105865E+00, 1.4384307593E+00, 8.2434378903E-01],
	[2.2130000000E+04, 1.2848905341E+01, 5.2519872315E+00, 2.3439054794E+00, 1.4391178502E+00, 8.2442542396E-01],
	[2.2135000000E+04, 1.2853327366E+01, 5.2518878858E+00, 2.3456012147E+00, 1.4398049604E+00, 8.2450702523E-01],
	[2.2140000000E+04, 1.2857749913E+01, 5.2517885645E+00, 2.3472977929E+00, 1.4404920895E+00, 8.2458859287E-01],
	[2.2145000000E+04, 1.2862172983E+01, 5.2516892674E+00, 2.3489952140E+00, 1.4411792375E+00, 8.2467012687E-01],
	[2.2150000000E+04, 1.2866596575E+01, 5.2515899947E+00, 2.3506934783E+00, 1.4418664041E+00, 8.2475162724E-01],
	[2.2155000000E+04, 1.2871020690E+01, 5.2514907462E+00, 2.3523925860E+00, 1.4425535894E+00, 8.2483309398E-01],
	[2.2160000000E+04, 1.2875445327E+01, 5.2513915220E+00, 2.3540925374E+00, 1.4432407930E+00, 8.2491452712E-01],
	[2.2165000000E+04, 1.2879870486E+01, 5.2512923221E+00, 2.3557933326E+00, 1.4439280149E+00, 8.2499592664E-01],
	[2.2170000000E+04, 1.2884296168E+01, 5.2511931464E+00, 2.3574949720E+00, 1.4446152549E+00, 8.2507729256E-01],
	[2.2175000000E+04, 1.2888722372E+01, 5.2510939949E+00, 2.3591974557E+00, 1.4453025129E+00, 8.2515862488E-01],
	[2.2180000000E+04, 1.2893149098E+01, 5.2509948677E+00, 2.3609007840E+00, 1.4459897888E+00, 8.2523992362E-01],
	[2.2185000000E+04, 1.2897576346E+01, 5.2508957647E+00, 2.3626049570E+00, 1.4466770822E+00, 8.2532118877E-01],
	[2.2190000000E+04, 1.2902004116E+01, 5.2507966859E+00, 2.3643099751E+00, 1.4473643933E+00, 8.2540242035E-01],
	[2.2195000000E+04, 1.2906432408E+01, 5.2506976313E+00, 2.3660158384E+00, 1.4480517217E+00, 8.2548361835E-01],
	[2.2200000000E+04, 1.2910861222E+01, 5.2505986008E+00, 2.3677225472E+00, 1.4487390674E+00, 8.2556478279E-01],
	[2.2205000000E+04, 1.2915290558E+01, 5.2504995946E+00, 2.3694301018E+00, 1.4494264301E+00, 8.2564591368E-01],
	[2.2210000000E+04, 1.2919720415E+01, 5.2504006125E+00, 2.3711385022E+00, 1.4501138098E+00, 8.2572701102E-01],
	[2.2215000000E+04, 1.2924150795E+01, 5.2503016545E+00, 2.3728477488E+00, 1.4508012063E+00, 8.2580807481E-01],
	[2.2220000000E+04, 1.2928581696E+01, 5.2502027207E+00, 2.3745578418E+00, 1.4514886195E+00, 8.2588910507E-01],
	[2.2225000000E+04, 1.2933013118E+01, 5.2501038109E+00, 2.3762687814E+00, 1.4521760491E+00, 8.2597010179E-01],
	[2.2230000000E+04, 1.2937445063E+01, 5.2500049253E+00, 2.3779805679E+00, 1.4528634952E+00, 8.2605106500E-01],
	[2.2235000000E+04, 1.2941877528E+01, 5.2499060639E+00, 2.3796932014E+00, 1.4535509574E+00, 8.2613199468E-01],
	[2.2240000000E+04, 1.2946310516E+01, 5.2498072264E+00, 2.3814066822E+00, 1.4542384357E+00, 8.2621289086E-01],
	[2.2245000000E+04, 1.2950744024E+01, 5.2497084131E+00, 2.3831210106E+00, 1.4549259300E+00, 8.2629375354E-01],
	[2.2250000000E+04, 1.2955178054E+01, 5.2496096239E+00, 2.3848361867E+00, 1.4556134400E+00, 8.2637458272E-01],
	[2.2255000000E+04, 1.2959612606E+01, 5.2495108587E+00, 2.3865522108E+00, 1.4563009657E+00, 8.2645537841E-01],
	[2.2260000000E+04, 1.2964047678E+01, 5.2494121175E+00, 2.3882690831E+00, 1.4569885068E+00, 8.2653614061E-01],
	[2.2265000000E+04, 1.2968483272E+01, 5.2493134004E+00, 2.3899868038E+00, 1.4576760633E+00, 8.2661686935E-01],
	[2.2270000000E+04, 1.2972919387E+01, 5.2492147073E+00, 2.3917053733E+00, 1.4583636350E+00, 8.2669756461E-01],
	[2.2275000000E+04, 1.2977356022E+01, 5.2491160382E+00, 2.3934247916E+00, 1.4590512218E+00, 8.2677822641E-01],
	[2.2280000000E+04, 1.2981793179E+01, 5.2490173931E+00, 2.3951450590E+00, 1.4597388235E+00, 8.2685885476E-01],
	[2.2285000000E+04, 1.2986230857E+01, 5.2489187720E+00, 2.3968661758E+00, 1.4604264399E+00, 8.2693944966E-01],
	[2.2290000000E+04, 1.2990669056E+01, 5.2488201748E+00, 2.3985881422E+00, 1.4611140709E+00, 8.2702001111E-01],
	[2.2295000000E+04, 1.2995107776E+01, 5.2487216017E+00, 2.4003109584E+00, 1.4618017164E+00, 8.2710053914E-01],
	[2.2300000000E+04, 1.2999547016E+01, 5.2486230525E+00, 2.4020346246E+00, 1.4624893763E+00, 8.2718103373E-01],
	[2.2305000000E+04, 1.3003986777E+01, 5.2485245272E+00, 2.4037591411E+00, 1.4631770503E+00, 8.2726149491E-01],
	[2.2310000000E+04, 1.3008427059E+01, 5.2484260259E+00, 2.4054845081E+00, 1.4638647384E+00, 8.2734192267E-01],
	[2.2315000000E+04, 1.3012867862E+01, 5.2483275485E+00, 2.4072107258E+00, 1.4645524404E+00, 8.2742231703E-01],
	[2.2320000000E+04, 1.3017309185E+01, 5.2482290950E+00, 2.4089377945E+00, 1.4652401561E+00, 8.2750267798E-01],
	[2.2325000000E+04, 1.3021751028E+01, 5.2481306653E+00, 2.4106657143E+00, 1.4659278854E+00, 8.2758300555E-01],
	[2.2330000000E+04, 1.3026193392E+01, 5.2480322596E+00, 2.4123944856E+00, 1.4666156281E+00, 8.2766329973E-01],
	[2.2335000000E+04, 1.3030636277E+01, 5.2479338778E+00, 2.4141241085E+00, 1.4673033842E+00, 8.2774356053E-01],
	[2.2340000000E+04, 1.3035079682E+01, 5.2478355198E+00, 2.4158545832E+00, 1.4679911535E+00, 8.2782378796E-01],
	[2.2345000000E+04, 1.3039523607E+01, 5.2477371857E+00, 2.4175859101E+00, 1.4686789358E+00, 8.2790398202E-01],
	[2.2350000000E+04, 1.3043968052E+01, 5.2476388754E+00, 2.4193180892E+00, 1.4693667309E+00, 8.2798414273E-01],
	[2.2355000000E+04, 1.3048413018E+01, 5.2475405890E+00, 2.4210511209E+00, 1.4700545388E+00, 8.2806427009E-01],
	[2.2360000000E+04, 1.3052858503E+01, 5.2474423264E+00, 2.4227850054E+00, 1.4707423593E+00, 8.2814436410E-01],
	[2.2365000000E+04, 1.3057304509E+01, 5.2473440875E+00, 2.4245299209E+00, 1.4714339410E+00, 8.2822442478E-01],
	[2.2370000000E+04, 1.3061751035E+01, 5.2472458725E+00, 2.4262773597E+00, 1.4721261461E+00, 8.2830445213E-01],
	[2.2375000000E+04, 1.3066198080E+01, 5.2471476813E+00, 2.4280256663E+00, 1.4728183643E+00, 8.2838444616E-01],
	[2.2380000000E+04, 1.3070645646E+01, 5.2470495138E+00, 2.4297748409E+00, 1.4735105954E+00, 8.2846440688E-01],
	[2.2385000000E+04, 1.3075093731E+01, 5.2469513702E+00, 2.4315248837E+00, 1.4742028393E+00, 8.2854433429E-01],
	[2.2390000000E+04, 1.3079542337E+01, 5.2468532502E+00, 2.4332757949E+00, 1.4748950957E+00, 8.2862422840E-01],
	[2.2395000000E+04, 1.3083991462E+01, 5.2467551540E+00, 2.4350275748E+00, 1.4755873647E+00, 8.2870408921E-01],
	[2.2400000000E+04, 1.3088441106E+01, 5.2466570816E+00, 2.4367802236E+00, 1.4762796460E+00, 8.2878391674E-01],
	[2.2405000000E+04, 1.3092891271E+01, 5.2465590329E+00, 2.4385337416E+00, 1.4769719395E+00, 8.2886371099E-01],
	[2.2410000000E+04, 1.3097341954E+01, 5.2464610078E+00, 2.4402881290E+00, 1.4776642450E+00, 8.2894347198E-01],
	[2.2415000000E+04, 1.3101793158E+01, 5.2463630065E+00, 2.4420433860E+00, 1.4783565624E+00, 8.2902319969E-01],
	[2.2420000000E+04, 1.3106244881E+01, 5.2462650289E+00, 2.4437995129E+00, 1.4790488915E+00, 8.2910289416E-01],
	[2.2425000000E+04, 1.3110697123E+01, 5.2461670749E+00, 2.4455565098E+00, 1.4797412323E+00, 8.2918255537E-01],
	[2.2430000000E+04, 1.3115149885E+01, 5.2460691446E+00, 2.4473143771E+00, 1.4804335845E+00, 8.2926218334E-01],
	[2.2435000000E+04, 1.3119603165E+01, 5.2459712380E+00, 2.4490731150E+00, 1.4811259480E+00, 8.2934177808E-01],
	[2.2440000000E+04, 1.3124074950E+01, 5.2458771886E+00, 2.4508327237E+00, 1.4818188578E+00, 8.2942133959E-01],
	[2.2445000000E+04, 1.3128549643E+01, 5.2457836693E+00, 2.4525932035E+00, 1.4825118502E+00, 8.2950086788E-01],
	[2.2450000000E+04, 1.3133024865E+01, 5.2456901726E+00, 2.4543545545E+00, 1.4832048544E+00, 8.2958036295E-01],
	[2.2455000000E+04, 1.3137500615E+01, 5.2455966983E+00, 2.4561167771E+00, 1.4838978701E+00, 8.2965982483E-01],
	[2.2460000000E+04, 1.3141976893E+01, 5.2455032465E+00, 2.4578798714E+00, 1.4845908972E+00, 8.2973925350E-01],
	[2.2465000000E+04, 1.3146453700E+01, 5.2454098172E+00, 2.4596438377E+00, 1.4852839355E+00, 8.2981864899E-01],
	[2.2470000000E+04, 1.3150931035E+01, 5.2453164103E+00, 2.4614086762E+00, 1.4859769850E+00, 8.2989801129E-01],
	[2.2475000000E+04, 1.3155408898E+01, 5.2452230259E+00, 2.4631743872E+00, 1.4866700455E+00, 8.2997734042E-01],
	[2.2480000000E+04, 1.3159887290E+01, 5.2451296639E+00, 2.4649409709E+00, 1.4873631167E+00, 8.3005663638E-01],
	[2.2485000000E+04, 1.3164366209E+01, 5.2450363243E+00, 2.4667084276E+00, 1.4880561987E+00, 8.3013589918E-01],
	[2.2490000000E+04, 1.3168845657E+01, 5.2449430072E+00, 2.4684767574E+00, 1.4887492912E+00, 8.3021512882E-01],
	[2.2495000000E+04, 1.3173325632E+01, 5.2448497124E+00, 2.4702459606E+00, 1.4894423940E+00, 8.3029432533E-01],
	[2.2500000000E+04, 1.3177806135E+01, 5.2447564401E+00, 2.4720160375E+00, 1.4901355071E+00, 8.3037348869E-01],
	[2.2505000000E+04, 1.3182287166E+01, 5.2446631901E+00, 2.4737869883E+00, 1.4908286303E+00, 8.3045261892E-01],
	[2.2510000000E+04, 1.3186768725E+01, 5.2445699625E+00, 2.4755588132E+00, 1.4915217635E+00, 8.3053171604E-01],
	[2.2515000000E+04, 1.3191250812E+01, 5.2444767573E+00, 2.4773315124E+00, 1.4922149064E+00, 8.3061078003E-01],
	[2.2520000000E+04, 1.3195733426E+01, 5.2443835744E+00, 2.4791050863E+00, 1.4929080590E+00, 8.3068981092E-01],
	[2.2525000000E+04, 1.3200216568E+01, 5.2442904138E+00, 2.4808795349E+00, 1.4936012212E+00, 8.3076880871E-01],
	[2.2530000000E+04, 1.3204700237E+01, 5.2441972756E+00, 2.4826548587E+00, 1.4942943926E+00, 8.3084777340E-01],
	[2.2535000000E+04, 1.3209184434E+01, 5.2441041597E+00, 2.4844310577E+00, 1.4949875733E+00, 8.3092670502E-01],
	[2.2540000000E+04, 1.3213669159E+01, 5.2440110661E+00, 2.4862081323E+00, 1.4956807631E+00, 8.3100560355E-01],
	[2.2545000000E+04, 1.3218154410E+01, 5.2439179949E+00, 2.4879860827E+00, 1.4963739619E+00, 8.3108446902E-01],
	[2.2550000000E+04, 1.3222640190E+01, 5.2438249459E+00, 2.4897649091E+00, 1.4970671694E+00, 8.3116330142E-01],
	[2.2555000000E+04, 1.3227126496E+01, 5.2437319192E+00, 2.4915446117E+00, 1.4977603855E+00, 8.3124210077E-01],
	[2.2560000000E+04, 1.3231613330E+01, 5.2436389147E+00, 2.4933251909E+00, 1.4984536102E+00, 8.3132086707E-01],
	[2.2565000000E+04, 1.3236100691E+01, 5.2435459325E+00, 2.4951066467E+00, 1.4991468432E+00, 8.3139960033E-01],
	[2.2570000000E+04, 1.3240588579E+01, 5.2434529726E+00, 2.4968889796E+00, 1.4998400844E+00, 8.3147830057E-01],
	[2.2575000000E+04, 1.3245076994E+01, 5.2433600349E+00, 2.4986721896E+00, 1.5005333336E+00, 8.3155696778E-01],
	[2.2580000000E+04, 1.3249565936E+01, 5.2432671195E+00, 2.5004562770E+00, 1.5012265908E+00, 8.3163560197E-01],
	[2.2585000000E+04, 1.3254055405E+01, 5.2431742262E+00, 2.5022412422E+00, 1.5019198558E+00, 8.3171420315E-01],
	[2.2590000000E+04, 1.3258545401E+01, 5.2430813552E+00, 2.5040270852E+00, 1.5026131284E+00, 8.3179277133E-01],
	[2.2595000000E+04, 1.3263035923E+01, 5.2429885063E+00, 2.5058138064E+00, 1.5033064085E+00, 8.3187130651E-01],
	[2.2600000000E+04, 1.3267526973E+01, 5.2428956797E+00, 2.5076014059E+00, 1.5039996959E+00, 8.3194980869E-01],
	[2.2605000000E+04, 1.3272018549E+01, 5.2428028752E+00, 2.5093898841E+00, 1.5046929905E+00, 8.3202827789E-01],
	[2.2610000000E+04, 1.3276510652E+01, 5.2427100929E+00, 2.5111792412E+00, 1.5053862922E+00, 8.3210671410E-01],
	[2.2615000000E+04, 1.3281003282E+01, 5.2426173328E+00, 2.5129694773E+00, 1.5060796008E+00, 8.3218511734E-01],
	[2.2620000000E+04, 1.3285496438E+01, 5.2425245948E+00, 2.5147605928E+00, 1.5067729161E+00, 8.3226348761E-01],
	[2.2625000000E+04, 1.3289990121E+01, 5.2424318789E+00, 2.5165525878E+00, 1.5074662381E+00, 8.3234182492E-01],
	[2.2630000000E+04, 1.3294484330E+01, 5.2423391852E+00, 2.5183454626E+00, 1.5081595665E+00, 8.3242012927E-01],
	[2.2635000000E+04, 1.3298979066E+01, 5.2422465135E+00, 2.5201392175E+00, 1.5088529013E+00, 8.3249840066E-01],
	[2.2640000000E+04, 1.3303474328E+01, 5.2421538640E+00, 2.5219338527E+00, 1.5095462422E+00, 8.3257663911E-01],
	[2.2645000000E+04, 1.3307970116E+01, 5.2420612366E+00, 2.5237293683E+00, 1.5102395892E+00, 8.3265484462E-01],
	[2.2650000000E+04, 1.3312466431E+01, 5.2419686313E+00, 2.5255257648E+00, 1.5109329421E+00, 8.3273301719E-01],
	[2.2655000000E+04, 1.3316963272E+01, 5.2418760480E+00, 2.5273230422E+00, 1.5116263008E+00, 8.3281115684E-01],
	[2.2660000000E+04, 1.3321460639E+01, 5.2417834868E+00, 2.5291212008E+00, 1.5123196651E+00, 8.3288926357E-01],
	[2.2665000000E+04, 1.3325958532E+01, 5.2416909477E+00, 2.5309202409E+00, 1.5130130348E+00, 8.3296733737E-01],
	[2.2670000000E+04, 1.3330456951E+01, 5.2415984306E+00, 2.5327201627E+00, 1.5137064099E+00, 8.3304537827E-01],
	[2.2675000000E+04, 1.3334955896E+01, 5.2415059355E+00, 2.5345209664E+00, 1.5143997902E+00, 8.3312338627E-01],
	[2.2680000000E+04, 1.3339455367E+01, 5.2414134625E+00, 2.5363226523E+00, 1.5150931755E+00, 8.3320136137E-01],
	[2.2685000000E+04, 1.3343955363E+01, 5.2413210115E+00, 2.5381252206E+00, 1.5157865657E+00, 8.3327930357E-01],
	[2.2690000000E+04, 1.3348455886E+01, 5.2412285825E+00, 2.5399286716E+00, 1.5164799606E+00, 8.3335721289E-01],
	[2.2695000000E+04, 1.3352956934E+01, 5.2411361755E+00, 2.5417330054E+00, 1.5171733602E+00, 8.3343508934E-01],
	[2.2700000000E+04, 1.3357458508E+01, 5.2410437904E+00, 2.5435382224E+00, 1.5178667642E+00, 8.3351293291E-01],
	[2.2705000000E+04, 1.3361960608E+01, 5.2409514274E+00, 2.5453443227E+00, 1.5185601725E+00, 8.3359074361E-01],
	[2.2710000000E+04, 1.3366463233E+01, 5.2408590863E+00, 2.5471513066E+00, 1.5192535851E+00, 8.3366852145E-01],
	[2.2715000000E+04, 1.3370966384E+01, 5.2407667671E+00, 2.5489591744E+00, 1.5199470016E+00, 8.3374626644E-01],
	[2.2720000000E+04, 1.3375470061E+01, 5.2406744699E+00, 2.5507679262E+00, 1.5206404221E+00, 8.3382397858E-01],
	[2.2725000000E+04, 1.3379974262E+01, 5.2405821947E+00, 2.5525775623E+00, 1.5213338463E+00, 8.3390165787E-01],
	[2.2730000000E+04, 1.3384478990E+01, 5.2404899414E+00, 2.5543880830E+00, 1.5220272741E+00, 8.3397930434E-01],
	[2.2735000000E+04, 1.3388984242E+01, 5.2403977099E+00, 2.5561994884E+00, 1.5227207054E+00, 8.3405691797E-01],
	[2.2740000000E+04, 1.3393490020E+01, 5.2403055004E+00, 2.5580117789E+00, 1.5234141400E+00, 8.3413449878E-01],
	[2.2745000000E+04, 1.3397996323E+01, 5.2402133128E+00, 2.5598249546E+00, 1.5241075778E+00, 8.3421204677E-01],
	[2.2750000000E+04, 1.3402503151E+01, 5.2401211471E+00, 2.5616390158E+00, 1.5248010186E+00, 8.3428956196E-01],
	[2.2755000000E+04, 1.3407010504E+01, 5.2400290032E+00, 2.5634539627E+00, 1.5254944624E+00, 8.3436704434E-01],
	[2.2760000000E+04, 1.3411518382E+01, 5.2399368812E+00, 2.5652697956E+00, 1.5261879088E+00, 8.3444449392E-01],
	[2.2765000000E+04, 1.3416026786E+01, 5.2398447811E+00, 2.5670865147E+00, 1.5268813579E+00, 8.3452191071E-01],
	[2.2770000000E+04, 1.3420535714E+01, 5.2397527028E+00, 2.5689041203E+00, 1.5275748095E+00, 8.3459929472E-01],
	[2.2775000000E+04, 1.3425045167E+01, 5.2396606463E+00, 2.5707226125E+00, 1.5282682634E+00, 8.3467664595E-01],
	[2.2780000000E+04, 1.3429555145E+01, 5.2395686117E+00, 2.5725419916E+00, 1.5289617195E+00, 8.3475396441E-01],
	[2.2785000000E+04, 1.3434065648E+01, 5.2394765989E+00, 2.5743622579E+00, 1.5296551776E+00, 8.3483125010E-01],
	[2.2790000000E+04, 1.3438576675E+01, 5.2393846078E+00, 2.5761834116E+00, 1.5303486376E+00, 8.3490850304E-01],
	[2.2795000000E+04, 1.3443088227E+01, 5.2392926386E+00, 2.5780054529E+00, 1.5310420994E+00, 8.3498572322E-01],
	[2.2800000000E+04, 1.3447613642E+01, 5.2392034554E+00, 2.5798283821E+00, 1.5317359721E+00, 8.3506291066E-01],
	[2.2805000000E+04, 1.3452146878E+01, 5.2391158039E+00, 2.5816521993E+00, 1.5324300707E+00, 8.3514006535E-01],
	[2.2810000000E+04, 1.3456680647E+01, 5.2390281731E+00, 2.5834769049E+00, 1.5331241714E+00, 8.3521718732E-01],
	[2.2815000000E+04, 1.3461214951E+01, 5.2389405629E+00, 2.5853024991E+00, 1.5338182742E+00, 8.3529427656E-01],
	[2.2820000000E+04, 1.3465749788E+01, 5.2388529734E+00, 2.5871289821E+00, 1.5345123789E+00, 8.3537133308E-01],
	[2.2825000000E+04, 1.3470285159E+01, 5.2387654045E+00, 2.5889563541E+00, 1.5352064853E+00, 8.3544835689E-01],
	[2.2830000000E+04, 1.3474821064E+01, 5.2386778563E+00, 2.5907846154E+00, 1.5359005934E+00, 8.3552534799E-01],
	[2.2835000000E+04, 1.3479357502E+01, 5.2385903287E+00, 2.5926137663E+00, 1.5365947029E+00, 8.3560230639E-01],
	[2.2840000000E+04, 1.3483894474E+01, 5.2385028218E+00, 2.5944438069E+00, 1.5372888137E+00, 8.3567923210E-01],
	[2.2845000000E+04, 1.3488431980E+01, 5.2384153354E+00, 2.5962747375E+00, 1.5379829258E+00, 8.3575612512E-01],
	[2.2850000000E+04, 1.3492970018E+01, 5.2383278697E+00, 2.5981065584E+00, 1.5386770388E+00, 8.3583298547E-01],
	[2.2855000000E+04, 1.3497508591E+01, 5.2382404246E+00, 2.5999392697E+00, 1.5393711528E+00, 8.3590981314E-01],
	[2.2860000000E+04, 1.3502047696E+01, 5.2381530000E+00, 2.6017728717E+00, 1.5400652675E+00, 8.3598660815E-01],
	[2.2865000000E+04, 1.3506587335E+01, 5.2380655961E+00, 2.6036073647E+00, 1.5407593829E+00, 8.3606337049E-01],
	[2.2870000000E+04, 1.3511127507E+01, 5.2379782127E+00, 2.6054427488E+00, 1.5414534987E+00, 8.3614010019E-01],
	[2.2875000000E+04, 1.3515668212E+01, 5.2378908498E+00, 2.6072790244E+00, 1.5421476149E+00, 8.3621679724E-01],
	[2.2880000000E+04, 1.3520209450E+01, 5.2378035075E+00, 2.6091161917E+00, 1.5428417313E+00, 8.3629346165E-01],
	[2.2885000000E+04, 1.3524751221E+01, 5.2377161858E+00, 2.6109542508E+00, 1.5435358477E+00, 8.3637009342E-01],
	[2.2890000000E+04, 1.3529293526E+01, 5.2376288846E+00, 2.6127932021E+00, 1.5442299641E+00, 8.3644669258E-01],
	[2.2895000000E+04, 1.3533836363E+01, 5.2375416039E+00, 2.6146330457E+00, 1.5449240802E+00, 8.3652325911E-01],
	[2.2900000000E+04, 1.3538379733E+01, 5.2374543437E+00, 2.6164737820E+00, 1.5456181959E+00, 8.3659979303E-01],
	[2.2905000000E+04, 1.3542923636E+01, 5.2373671040E+00, 2.6183154111E+00, 1.5463123112E+00, 8.3667629435E-01],
	[2.2910000000E+04, 1.3547468071E+01, 5.2372798848E+00, 2.6201579333E+00, 1.5470064258E+00, 8.3675276307E-01],
	[2.2915000000E+04, 1.3552013040E+01, 5.2371926862E+00, 2.6220013488E+00, 1.5477005397E+00, 8.3682919920E-01],
	[2.2920000000E+04, 1.3556558541E+01, 5.2371055079E+00, 2.6238456578E+00, 1.5483946526E+00, 8.3690560275E-01],
	[2.2925000000E+04, 1.3561104575E+01, 5.2370183502E+00, 2.6256908607E+00, 1.5490887644E+00, 8.3698197371E-01],
	[2.2930000000E+04, 1.3565651141E+01, 5.2369312129E+00, 2.6275369576E+00, 1.5497828751E+00, 8.3705831211E-01],
	[2.2935000000E+04, 1.3570198240E+01, 5.2368440960E+00, 2.6293839488E+00, 1.5504769844E+00, 8.3713461795E-01],
	[2.2940000000E+04, 1.3574745871E+01, 5.2367569996E+00, 2.6312318345E+00, 1.5511710922E+00, 8.3721089123E-01],
	[2.2945000000E+04, 1.3579294035E+01, 5.2366699236E+00, 2.6330806149E+00, 1.5518651984E+00, 8.3728713196E-01],
	[2.2950000000E+04, 1.3583842731E+01, 5.2365828681E+00, 2.6349302903E+00, 1.5525593028E+00, 8.3736334014E-01],
	[2.2955000000E+04, 1.3588391959E+01, 5.2364958329E+00, 2.6367808609E+00, 1.5532534054E+00, 8.3743951580E-01],
	[2.2960000000E+04, 1.3592941720E+01, 5.2364088182E+00, 2.6386323270E+00, 1.5539475058E+00, 8.3751565892E-01],
	[2.2965000000E+04, 1.3597492013E+01, 5.2363218238E+00, 2.6404846888E+00, 1.5546416041E+00, 8.3759176952E-01],
	[2.2970000000E+04, 1.3602042837E+01, 5.2362348499E+00, 2.6423379466E+00, 1.5553357001E+00, 8.3766784761E-01],
	[2.2975000000E+04, 1.3606594194E+01, 5.2361478963E+00, 2.6441921005E+00, 1.5560297936E+00, 8.3774389320E-01],
	[2.2980000000E+04, 1.3611146084E+01, 5.2360609630E+00, 2.6460471508E+00, 1.5567238846E+00, 8.3781990628E-01],
	[2.2985000000E+04, 1.3615698505E+01, 5.2359740501E+00, 2.6479030977E+00, 1.5574179727E+00, 8.3789588687E-01],
	[2.2990000000E+04, 1.3620251457E+01, 5.2358871576E+00, 2.6497599416E+00, 1.5581120581E+00, 8.3797183497E-01],
	[2.2995000000E+04, 1.3624804942E+01, 5.2358002854E+00, 2.6516176826E+00, 1.5588061403E+00, 8.3804775060E-01],
	[2.3000000000E+04, 1.3629358959E+01, 5.2357134336E+00, 2.6534763209E+00, 1.5595002195E+00, 8.3812363376E-01],
	[2.3005000000E+04, 1.3633913507E+01, 5.2356266020E+00, 2.6553358568E+00, 1.5601942953E+00, 8.3819948445E-01],
	[2.3010000000E+04, 1.3638468587E+01, 5.2355397908E+00, 2.6571962906E+00, 1.5608883677E+00, 8.3827530268E-01],
	[2.3015000000E+04, 1.3643024199E+01, 5.2354529998E+00, 2.6590576224E+00, 1.5615824365E+00, 8.3835108847E-01],
	[2.3020000000E+04, 1.3647580342E+01, 5.2353662292E+00, 2.6609198526E+00, 1.5622765016E+00, 8.3842684181E-01],
	[2.3025000000E+04, 1.3652137017E+01, 5.2352794788E+00, 2.6627829813E+00, 1.5629705629E+00, 8.3850256271E-01],
	[2.3030000000E+04, 1.3656694224E+01, 5.2351927487E+00, 2.6646470087E+00, 1.5636646201E+00, 8.3857825119E-01],
	[2.3035000000E+04, 1.3661251962E+01, 5.2351060389E+00, 2.6665119353E+00, 1.5643586733E+00, 8.3865390725E-01],
	[2.3040000000E+04, 1.3665810231E+01, 5.2350193493E+00, 2.6683777610E+00, 1.5650527222E+00, 8.3872953090E-01],
	[2.3045000000E+04, 1.3670369031E+01, 5.2349326800E+00, 2.6702444863E+00, 1.5657467666E+00, 8.3880512213E-01],
	[2.3050000000E+04, 1.3674928363E+01, 5.2348460309E+00, 2.6721121113E+00, 1.5664408065E+00, 8.3888068097E-01],
	[2.3055000000E+04, 1.3679488226E+01, 5.2347594021E+00, 2.6739806363E+00, 1.5671348418E+00, 8.3895620742E-01],
	[2.3060000000E+04, 1.3684048620E+01, 5.2346727934E+00, 2.6758500615E+00, 1.5678288722E+00, 8.3903170149E-01],
	[2.3065000000E+04, 1.3688609546E+01, 5.2345862050E+00, 2.6777203872E+00, 1.5685228976E+00, 8.3910716317E-01],
	[2.3070000000E+04, 1.3693171002E+01, 5.2344996368E+00, 2.6795916135E+00, 1.5692169180E+00, 8.3918259249E-01],
	[2.3075000000E+04, 1.3697732990E+01, 5.2344130887E+00, 2.6814637408E+00, 1.5699109331E+00, 8.3925798945E-01],
	[2.3080000000E+04, 1.3702295508E+01, 5.2343265609E+00, 2.6833367692E+00, 1.5706049429E+00, 8.3933335405E-01],
	[2.3085000000E+04, 1.3706858557E+01, 5.2342400532E+00, 2.6852106990E+00, 1.5712989471E+00, 8.3940868630E-01],
	[2.3090000000E+04, 1.3711422138E+01, 5.2341535657E+00, 2.6870855305E+00, 1.5719929457E+00, 8.3948398622E-01],
	[2.3095000000E+04, 1.3715986249E+01, 5.2340670983E+00, 2.6889612639E+00, 1.5726869385E+00, 8.3955925380E-01],
	[2.3100000000E+04, 1.3720550890E+01, 5.2339806511E+00, 2.6908378993E+00, 1.5733809254E+00, 8.3963448906E-01],
	[2.3105000000E+04, 1.3725116063E+01, 5.2338942240E+00, 2.6927154372E+00, 1.5740749062E+00, 8.3970969200E-01],
	[2.3110000000E+04, 1.3729681766E+01, 5.2338078171E+00, 2.6945938776E+00, 1.5747688808E+00, 8.3978486263E-01],
	[2.3115000000E+04, 1.3734247999E+01, 5.2337214302E+00, 2.6964732208E+00, 1.5754628490E+00, 8.3986000095E-01],
	[2.3120000000E+04, 1.3738814764E+01, 5.2336350635E+00, 2.6983534671E+00, 1.5761568108E+00, 8.3993510699E-01],
	[2.3125000000E+04, 1.3743382058E+01, 5.2335487169E+00, 2.7002346168E+00, 1.5768507660E+00, 8.4001018073E-01],
	[2.3130000000E+04, 1.3747949883E+01, 5.2334623903E+00, 2.7021166699E+00, 1.5775447144E+00, 8.4008522219E-01],
	[2.3135000000E+04, 1.3752518239E+01, 5.2333760839E+00, 2.7039996269E+00, 1.5782386560E+00, 8.4016023139E-01],
	[2.3140000000E+04, 1.3757087125E+01, 5.2332897975E+00, 2.7058834878E+00, 1.5789325905E+00, 8.4023520832E-01],
	[2.3145000000E+04, 1.3761656541E+01, 5.2332035312E+00, 2.7077682531E+00, 1.5796265178E+00, 8.4031015299E-01],
	[2.3150000000E+04, 1.3766226487E+01, 5.2331172849E+00, 2.7096539228E+00, 1.5803204379E+00, 8.4038506541E-01],
	[2.3155000000E+04, 1.3770796963E+01, 5.2330310587E+00, 2.7115404972E+00, 1.5810143505E+00, 8.4045994559E-01],
	[2.3160000000E+04, 1.3775367970E+01, 5.2329448525E+00, 2.7134279767E+00, 1.5817082556E+00, 8.4053479353E-01],
	[2.3165000000E+04, 1.3779944672E+01, 5.2328597073E+00, 2.7153163613E+00, 1.5824023162E+00, 8.4060960925E-01],
	[2.3170000000E+04, 1.3784537638E+01, 5.2327777507E+00, 2.7172056514E+00, 1.5830968667E+00, 8.4068439275E-01],
	[2.3175000000E+04, 1.3789131143E+01, 5.2326958131E+00, 2.7190958471E+00, 1.5837914101E+00, 8.4075914403E-01],
	[2.3180000000E+04, 1.3793725187E+01, 5.2326138945E+00, 2.7209869488E+00, 1.5844859462E+00, 8.4083386312E-01],
	[2.3185000000E+04, 1.3798319770E+01, 5.2325319948E+00, 2.7228789567E+00, 1.5851804749E+00, 8.4090855001E-01],
	[2.3190000000E+04, 1.3802914893E+01, 5.2324501141E+00, 2.7247718709E+00, 1.5858749961E+00, 8.4098320471E-01],
	[2.3195000000E+04, 1.3807510555E+01, 5.2323682523E+00, 2.7266656918E+00, 1.5865695095E+00, 8.4105782722E-01],
	[2.3200000000E+04, 1.3812106756E+01, 5.2322864094E+00, 2.7285604196E+00, 1.5872640152E+00, 8.4113241757E-01],
	[2.3205000000E+04, 1.3816703496E+01, 5.2322045854E+00, 2.7304560545E+00, 1.5879585129E+00, 8.4120697575E-01],
	[2.3210000000E+04, 1.3821300774E+01, 5.2321227804E+00, 2.7323525967E+00, 1.5886530025E+00, 8.4128150177E-01],
	[2.3215000000E+04, 1.3825898592E+01, 5.2320409942E+00, 2.7342500465E+00, 1.5893474838E+00, 8.4135599565E-01],
	[2.3220000000E+04, 1.3830496949E+01, 5.2319592269E+00, 2.7361484042E+00, 1.5900419568E+00, 8.4143045738E-01],
	[2.3225000000E+04, 1.3835095844E+01, 5.2318774786E+00, 2.7380476699E+00, 1.5907364213E+00, 8.4150488698E-01],
	[2.3230000000E+04, 1.3839695279E+01, 5.2317957490E+00, 2.7399478439E+00, 1.5914308772E+00, 8.4157928445E-01],
	[2.3235000000E+04, 1.3844295251E+01, 5.2317140384E+00, 2.7418489265E+00, 1.5921253243E+00, 8.4165364981E-01],
	[2.3240000000E+04, 1.3848895763E+01, 5.2316323466E+00, 2.7437509179E+00, 1.5928197625E+00, 8.4172798305E-01],
	[2.3245000000E+04, 1.3853496813E+01, 5.2315506737E+00, 2.7456538182E+00, 1.5935141916E+00, 8.4180228419E-01],
	[2.3250000000E+04, 1.3858098402E+01, 5.2314690196E+00, 2.7475576279E+00, 1.5942086116E+00, 8.4187655324E-01],
	[2.3255000000E+04, 1.3862700529E+01, 5.2313873843E+00, 2.7494623470E+00, 1.5949030222E+00, 8.4195079019E-01],
	[2.3260000000E+04, 1.3867303195E+01, 5.2313057679E+00, 2.7513679758E+00, 1.5955974234E+00, 8.4202499507E-01],
	[2.3265000000E+04, 1.3871906399E+01, 5.2312241703E+00, 2.7532745147E+00, 1.5962918150E+00, 8.4209916788E-01],
	[2.3270000000E+04, 1.3876510141E+01, 5.2311425914E+00, 2.7551819637E+00, 1.5969861969E+00, 8.4217330863E-01],
	[2.3275000000E+04, 1.3881114422E+01, 5.2310610314E+00, 2.7570903232E+00, 1.5976805690E+00, 8.4224741732E-01],
	[2.3280000000E+04, 1.3885719241E+01, 5.2309794902E+00, 2.7589995934E+00, 1.5983749310E+00, 8.4232149396E-01],
	[2.3285000000E+04, 1.3890324598E+01, 5.2308979678E+00, 2.7609097745E+00, 1.5990692829E+00, 8.4239553857E-01],
	[2.3290000000E+04, 1.3894930493E+01, 5.2308164641E+00, 2.7628208668E+00, 1.5997636246E+00, 8.4246955114E-01],
	[2.3295000000E+04, 1.3899536926E+01, 5.2307349792E+00, 2.7647328704E+00, 1.6004579558E+00, 8.4254353169E-01],
	[2.3300000000E+04, 1.3904143897E+01, 5.2306535130E+00, 2.7666457857E+00, 1.6011522766E+00, 8.4261748022E-01],
	[2.3305000000E+04, 1.3908751407E+01, 5.2305720656E+00, 2.7685596129E+00, 1.6018465866E+00, 8.4269139675E-01],
	[2.3310000000E+04, 1.3913359454E+01, 5.2304906370E+00, 2.7704743522E+00, 1.6025408859E+00, 8.4276528128E-01],
	[2.3315000000E+04, 1.3917968039E+01, 5.2304092270E+00, 2.7723900039E+00, 1.6032351742E+00, 8.4283913382E-01],
	[2.3320000000E+04, 1.3922577161E+01, 5.2303278358E+00, 2.7743065681E+00, 1.6039294515E+00, 8.4291295437E-01],
	[2.3325000000E+04, 1.3927186822E+01, 5.2302464633E+00, 2.7762240452E+00, 1.6046237175E+00, 8.4298674295E-01],
	[2.3330000000E+04, 1.3931797020E+01, 5.2301651096E+00, 2.7781424354E+00, 1.6053179722E+00, 8.4306049956E-01],
	[2.3335000000E+04, 1.3936407756E+01, 5.2300837745E+00, 2.7800617388E+00, 1.6060122155E+00, 8.4313422421E-01],
	[2.3340000000E+04, 1.3941019030E+01, 5.2300024581E+00, 2.7819819559E+00, 1.6067064471E+00, 8.4320791691E-01],
	[2.3345000000E+04, 1.3945630841E+01, 5.2299211604E+00, 2.7839030867E+00, 1.6074006670E+00, 8.4328157767E-01],
	[2.3350000000E+04, 1.3950243189E+01, 5.2298398813E+00, 2.7858251315E+00, 1.6080948750E+00, 8.4335520649E-01],
	[2.3355000000E+04, 1.3954856075E+01, 5.2297586209E+00, 2.7877480906E+00, 1.6087890710E+00, 8.4342880339E-01],
	[2.3360000000E+04, 1.3959469499E+01, 5.2296773792E+00, 2.7896719642E+00, 1.6094832548E+00, 8.4350236837E-01],
	[2.3365000000E+04, 1.3964083459E+01, 5.2295961562E+00, 2.7915967525E+00, 1.6101774264E+00, 8.4357590144E-01],
	[2.3370000000E+04, 1.3968697957E+01, 5.2295149517E+00, 2.7935224558E+00, 1.6108715856E+00, 8.4364940261E-01],
	[2.3375000000E+04, 1.3973312992E+01, 5.2294337659E+00, 2.7954490743E+00, 1.6115657322E+00, 8.4372287188E-01],
	[2.3380000000E+04, 1.3977928565E+01, 5.2293525988E+00, 2.7973766083E+00, 1.6122598661E+00, 8.4379630927E-01],
	[2.3385000000E+04, 1.3982544674E+01, 5.2292714502E+00, 2.7993050579E+00, 1.6129539872E+00, 8.4386971478E-01],
	[2.3390000000E+04, 1.3987161321E+01, 5.2291903203E+00, 2.8012344235E+00, 1.6136480954E+00, 8.4394308842E-01],
	[2.3395000000E+04, 1.3991778505E+01, 5.2291092089E+00, 2.8031647053E+00, 1.6143421905E+00, 8.4401643020E-01],
	[2.3400000000E+04, 1.3996396225E+01, 5.2290281162E+00, 2.8050959035E+00, 1.6150362724E+00, 8.4408974013E-01],
	[2.3405000000E+04, 1.4001014483E+01, 5.2289470420E+00, 2.8070280183E+00, 1.6157303409E+00, 8.4416301822E-01],
	[2.3410000000E+04, 1.4005633277E+01, 5.2288659864E+00, 2.8089610500E+00, 1.6164243960E+00, 8.4423626446E-01],
	[2.3415000000E+04, 1.4010252608E+01, 5.2287849494E+00, 2.8108949989E+00, 1.6171184374E+00, 8.4430947888E-01],
	[2.3420000000E+04, 1.4014872476E+01, 5.2287039309E+00, 2.8128298651E+00, 1.6178124651E+00, 8.4438266149E-01],
	[2.3425000000E+04, 1.4019492881E+01, 5.2286229310E+00, 2.8147656489E+00, 1.6185064789E+00, 8.4445581228E-01],
	[2.3430000000E+04, 1.4024113822E+01, 5.2285419496E+00, 2.8167023505E+00, 1.6192004787E+00, 8.4452893126E-01],
	[2.3435000000E+04, 1.4028735300E+01, 5.2284609867E+00, 2.8186399702E+00, 1.6198944643E+00, 8.4460201846E-01],
	[2.3440000000E+04, 1.4033357314E+01, 5.2283800424E+00, 2.8205785083E+00, 1.6205884356E+00, 8.4467507386E-01],
	[2.3445000000E+04, 1.4037979865E+01, 5.2282991166E+00, 2.8225179649E+00, 1.6212823926E+00, 8.4474809749E-01],
	[2.3450000000E+04, 1.4042602953E+01, 5.2282182093E+00, 2.8244583403E+00, 1.6219763350E+00, 8.4482108935E-01],
	[2.3455000000E+04, 1.4047226576E+01, 5.2281373205E+00, 2.8263996347E+00, 1.6226702627E+00, 8.4489404945E-01],
	[2.3460000000E+04, 1.4051850736E+01, 5.2280564502E+00, 2.8283418484E+00, 1.6233641756E+00, 8.4496697780E-01],
	[2.3465000000E+04, 1.4056475433E+01, 5.2279755984E+00, 2.8302849816E+00, 1.6240580736E+00, 8.4503987440E-01],
	[2.3470000000E+04, 1.4061100665E+01, 5.2278947650E+00, 2.8322290346E+00, 1.6247519565E+00, 8.4511273926E-01],
	[2.3475000000E+04, 1.4065726434E+01, 5.2278139501E+00, 2.8341740075E+00, 1.6254458241E+00, 8.4518557240E-01],
	[2.3480000000E+04, 1.4070352739E+01, 5.2277331537E+00, 2.8361199007E+00, 1.6261396765E+00, 8.4525837382E-01],
	[2.3485000000E+04, 1.4074979580E+01, 5.2276523758E+00, 2.8380667143E+00, 1.6268335133E+00, 8.4533114353E-01],
	[2.3490000000E+04, 1.4079606957E+01, 5.2275716162E+00, 2.8400144487E+00, 1.6275273346E+00, 8.4540388154E-01],
	[2.3495000000E+04, 1.4084234870E+01, 5.2274908752E+00, 2.8419631039E+00, 1.6282211401E+00, 8.4547658786E-01],
	[2.3500000000E+04, 1.4088863319E+01, 5.2274101525E+00, 2.8439126804E+00, 1.6289149298E+00, 8.4554926249E-01],
	[2.3505000000E+04, 1.4093492304E+01, 5.2273294483E+00, 2.8458631783E+00, 1.6296087034E+00, 8.4562190544E-01],
	[2.3510000000E+04, 1.4098121825E+01, 5.2272487624E+00, 2.8478145979E+00, 1.6303024609E+00, 8.4569451673E-01],
	[2.3515000000E+04, 1.4102751881E+01, 5.2271680950E+00, 2.8497669393E+00, 1.6309962022E+00, 8.4576709635E-01],
	[2.3520000000E+04, 1.4107382473E+01, 5.2270874460E+00, 2.8517202029E+00, 1.6316899270E+00, 8.4583964433E-01],
	[2.3525000000E+04, 1.4112013601E+01, 5.2270068153E+00, 2.8536743888E+00, 1.6323836353E+00, 8.4591216066E-01],
	[2.3530000000E+04, 1.4116645265E+01, 5.2269262031E+00, 2.8556294974E+00, 1.6330773270E+00, 8.4598464536E-01],
	[2.3535000000E+04, 1.4121277464E+01, 5.2268456092E+00, 2.8575855288E+00, 1.6337710018E+00, 8.4605709844E-01],
	[2.3540000000E+04, 1.4125924301E+01, 5.2267677959E+00, 2.8595424834E+00, 1.6344651187E+00, 8.4612951990E-01],
	[2.3545000000E+04, 1.4130578747E+01, 5.2266913841E+00, 2.8615003612E+00, 1.6351594491E+00, 8.4620190975E-01],
	[2.3550000000E+04, 1.4135233739E+01, 5.2266149896E+00, 2.8634591626E+00, 1.6358537632E+00, 8.4627426800E-01],
	[2.3555000000E+04, 1.4139889275E+01, 5.2265386125E+00, 2.8654188879E+00, 1.6365480609E+00, 8.4634659466E-01],
	[2.3560000000E+04, 1.4144545356E+01, 5.2264622527E+00, 2.8673795371E+00, 1.6372423419E+00, 8.4641888974E-01],
	[2.3565000000E+04, 1.4149201981E+01, 5.2263859102E+00, 2.8693411107E+00, 1.6379366062E+00, 8.4649115325E-01],
	[2.3570000000E+04, 1.4153859151E+01, 5.2263095850E+00, 2.8713036088E+00, 1.6386308537E+00, 8.4656338519E-01],
	[2.3575000000E+04, 1.4158516866E+01, 5.2262332771E+00, 2.8732670316E+00, 1.6393250841E+00, 8.4663558557E-01],
	[2.3580000000E+04, 1.4163175125E+01, 5.2261569866E+00, 2.8752313795E+00, 1.6400192974E+00, 8.4670775441E-01],
	[2.3585000000E+04, 1.4167833929E+01, 5.2260807133E+00, 2.8771966526E+00, 1.6407134935E+00, 8.4677989171E-01],
	[2.3590000000E+04, 1.4172493277E+01, 5.2260044573E+00, 2.8791628512E+00, 1.6414076722E+00, 8.4685199748E-01],
	[2.3595000000E+04, 1.4177153169E+01, 5.2259282185E+00, 2.8811299755E+00, 1.6421018334E+00, 8.4692407173E-01],
	[2.3600000000E+04, 1.4181813606E+01, 5.2258519971E+00, 2.8830980257E+00, 1.6427959769E+00, 8.4699611446E-01],
	[2.3605000000E+04, 1.4186474587E+01, 5.2257757928E+00, 2.8850670022E+00, 1.6434901026E+00, 8.4706812570E-01],
	[2.3610000000E+04, 1.4191136112E+01, 5.2256996059E+00, 2.8870369051E+00, 1.6441842105E+00, 8.4714010543E-01],
	[2.3615000000E+04, 1.4195798182E+01, 5.2256234362E+00, 2.8890077347E+00, 1.6448783003E+00, 8.4721205369E-01],
	[2.3620000000E+04, 1.4200460795E+01, 5.2255472837E+00, 2.8909794911E+00, 1.6455723719E+00, 8.4728397046E-01],
	[2.3625000000E+04, 1.4205123953E+01, 5.2254711484E+00, 2.8929521748E+00, 1.6462664252E+00, 8.4735585576E-01],
	[2.3630000000E+04, 1.4209787654E+01, 5.2253950304E+00, 2.8949257858E+00, 1.6469604601E+00, 8.4742770961E-01],
	[2.3635000000E+04, 1.4214451899E+01, 5.2253189296E+00, 2.8969003245E+00, 1.6476544765E+00, 8.4749953200E-01],
	[2.3640000000E+04, 1.4219116689E+01, 5.2252428460E+00, 2.8988757910E+00, 1.6483484741E+00, 8.4757132296E-01],
	[2.3645000000E+04, 1.4223782022E+01, 5.2251667796E+00, 2.9008521857E+00, 1.6490424530E+00, 8.4764308247E-01],
	[2.3650000000E+04, 1.4228447899E+01, 5.2250907303E+00, 2.9028295087E+00, 1.6497364129E+00, 8.4771481057E-01],
	[2.3655000000E+04, 1.4233114320E+01, 5.2250146983E+00, 2.9048077602E+00, 1.6504303537E+00, 8.4778650725E-01],
	[2.3660000000E+04, 1.4237781284E+01, 5.2249386834E+00, 2.9067869406E+00, 1.6511242753E+00, 8.4785817252E-01],
	[2.3665000000E+04, 1.4242448792E+01, 5.2248626857E+00, 2.9087670501E+00, 1.6518181776E+00, 8.4792980639E-01],
	[2.3670000000E+04, 1.4247116844E+01, 5.2247867052E+00, 2.9107480889E+00, 1.6525120604E+00, 8.4800140888E-01],
	[2.3675000000E+04, 1.4251785439E+01, 5.2247107418E+00, 2.9127300572E+00, 1.6532059236E+00, 8.4807297998E-01],
	[2.3680000000E+04, 1.4256454578E+01, 5.2246347956E+00, 2.9147129553E+00, 1.6538997671E+00, 8.4814451972E-01],
	[2.3685000000E+04, 1.4261124260E+01, 5.2245588665E+00, 2.9166967835E+00, 1.6545935907E+00, 8.4821602809E-01],
	[2.3690000000E+04, 1.4265794485E+01, 5.2244829545E+00, 2.9186815419E+00, 1.6552873943E+00, 8.4828750510E-01],
	[2.3695000000E+04, 1.4270465254E+01, 5.2244070596E+00, 2.9206672308E+00, 1.6559811779E+00, 8.4835895078E-01],
	[2.3700000000E+04, 1.4275136566E+01, 5.2243311819E+00, 2.9226538504E+00, 1.6566749412E+00, 8.4843036511E-01],
	[2.3705000000E+04, 1.4279808421E+01, 5.2242553213E+00, 2.9246414010E+00, 1.6573686841E+00, 8.4850174812E-01],
	[2.3710000000E+04, 1.4284480820E+01, 5.2241794778E+00, 2.9266298829E+00, 1.6580624065E+00, 8.4857309982E-01],
	[2.3715000000E+04, 1.4289153761E+01, 5.2241036513E+00, 2.9286192962E+00, 1.6587561083E+00, 8.4864442020E-01],
	[2.3720000000E+04, 1.4293827246E+01, 5.2240278420E+00, 2.9306096412E+00, 1.6594497893E+00, 8.4871570929E-01],
	[2.3725000000E+04, 1.4298501274E+01, 5.2239520497E+00, 2.9326009181E+00, 1.6601434495E+00, 8.4878696708E-01],
	[2.3730000000E+04, 1.4303175844E+01, 5.2238762745E+00, 2.9345931272E+00, 1.6608370886E+00, 8.4885819359E-01],
	[2.3735000000E+04, 1.4307850958E+01, 5.2238005164E+00, 2.9365862687E+00, 1.6615307066E+00, 8.4892938883E-01],
	[2.3740000000E+04, 1.4312526614E+01, 5.2237247753E+00, 2.9385803429E+00, 1.6622243033E+00, 8.4900055281E-01],
	[2.3745000000E+04, 1.4317202813E+01, 5.2236490513E+00, 2.9405753500E+00, 1.6629178786E+00, 8.4907168553E-01],
	[2.3750000000E+04, 1.4321879555E+01, 5.2235733443E+00, 2.9425712902E+00, 1.6636114324E+00, 8.4914278701E-01],
	[2.3755000000E+04, 1.4326556840E+01, 5.2234976543E+00, 2.9445681637E+00, 1.6643049645E+00, 8.4921385725E-01],
	[2.3760000000E+04, 1.4331234667E+01, 5.2234219814E+00, 2.9465659709E+00, 1.6649984748E+00, 8.4928489626E-01],
	[2.3765000000E+04, 1.4335913037E+01, 5.2233463255E+00, 2.9485647120E+00, 1.6656919633E+00, 8.4935590405E-01],
	[2.3770000000E+04, 1.4340591950E+01, 5.2232706866E+00, 2.9505643871E+00, 1.6663854297E+00, 8.4942688064E-01],
	[2.3775000000E+04, 1.4345271405E+01, 5.2231950647E+00, 2.9525649966E+00, 1.6670788739E+00, 8.4949782602E-01],
	[2.3780000000E+04, 1.4349951402E+01, 5.2231194598E+00, 2.9545665406E+00, 1.6677722958E+00, 8.4956874022E-01],
	[2.3785000000E+04, 1.4354631942E+01, 5.2230438719E+00, 2.9565690194E+00, 1.6684656953E+00, 8.4963962323E-01],
	[2.3790000000E+04, 1.4359313025E+01, 5.2229683009E+00, 2.9585724333E+00, 1.6691590722E+00, 8.4971047507E-01],
	[2.3795000000E+04, 1.4363994649E+01, 5.2228927470E+00, 2.9605767825E+00, 1.6698524265E+00, 8.4978129574E-01],
	[2.3800000000E+04, 1.4368676816E+01, 5.2228172100E+00, 2.9625820672E+00, 1.6705457579E+00, 8.4985208526E-01],
	[2.3805000000E+04, 1.4373359525E+01, 5.2227416900E+00, 2.9645882876E+00, 1.6712390664E+00, 8.4992284364E-01],
	[2.3810000000E+04, 1.4378042776E+01, 5.2226661869E+00, 2.9665954441E+00, 1.6719323519E+00, 8.4999357087E-01],
	[2.3815000000E+04, 1.4382726569E+01, 5.2225907008E+00, 2.9686035368E+00, 1.6726256141E+00, 8.5006426698E-01],
	[2.3820000000E+04, 1.4387410904E+01, 5.2225152316E+00, 2.9706125660E+00, 1.6733188531E+00, 8.5013493195E-01],
	[2.3825000000E+04, 1.4392095782E+01, 5.2224397793E+00, 2.9726225319E+00, 1.6740120686E+00, 8.5020556581E-01],
	[2.3830000000E+04, 1.4396781201E+01, 5.2223643440E+00, 2.9746334348E+00, 1.6747052605E+00, 8.5027616856E-01],
	[2.3835000000E+04, 1.4401467162E+01, 5.2222889255E+00, 2.9766452749E+00, 1.6753984287E+00, 8.5034674021E-01],
	[2.3840000000E+04, 1.4406153665E+01, 5.2222135240E+00, 2.9786580524E+00, 1.6760915731E+00, 8.5041728077E-01],
	[2.3845000000E+04, 1.4410840710E+01, 5.2221381394E+00, 2.9806717676E+00, 1.6767846935E+00, 8.5048779023E-01],
	[2.3850000000E+04, 1.4415528296E+01, 5.2220627717E+00, 2.9826864207E+00, 1.6774777899E+00, 8.5055826862E-01],
	[2.3855000000E+04, 1.4420216424E+01, 5.2219874208E+00, 2.9847020120E+00, 1.6781708620E+00, 8.5062871593E-01],
	[2.3860000000E+04, 1.4424905094E+01, 5.2219120869E+00, 2.9867185417E+00, 1.6788639098E+00, 8.5069913219E-01],
	[2.3865000000E+04, 1.4429594306E+01, 5.2218367698E+00, 2.9887360100E+00, 1.6795569332E+00, 8.5076951738E-01],
	[2.3870000000E+04, 1.4434284059E+01, 5.2217614696E+00, 2.9907544172E+00, 1.6802499320E+00, 8.5083987152E-01],
	[2.3875000000E+04, 1.4438974353E+01, 5.2216861862E+00, 2.9927737636E+00, 1.6809429060E+00, 8.5091019463E-01],
	[2.3880000000E+04, 1.4443665189E+01, 5.2216109197E+00, 2.9947940492E+00, 1.6816358552E+00, 8.5098048670E-01],
	[2.3885000000E+04, 1.4448356566E+01, 5.2215356700E+00, 2.9968152745E+00, 1.6823287795E+00, 8.5105074774E-01],
	[2.3890000000E+04, 1.4453048485E+01, 5.2214604372E+00, 2.9988374396E+00, 1.6830216786E+00, 8.5112097777E-01],
	[2.3895000000E+04, 1.4457740944E+01, 5.2213852212E+00, 3.0008605448E+00, 1.6837145525E+00, 8.5119117678E-01],
	[2.3900000000E+04, 1.4462433945E+01, 5.2213100220E+00, 3.0028845903E+00, 1.6844074011E+00, 8.5126134480E-01],
	[2.3905000000E+04, 1.4467127488E+01, 5.2212348396E+00, 3.0049095764E+00, 1.6851002242E+00, 8.5133148181E-01],
	[2.3910000000E+04, 1.4471821571E+01, 5.2211596740E+00, 3.0069355033E+00, 1.6857930217E+00, 8.5140158784E-01],
	[2.3915000000E+04, 1.4476516196E+01, 5.2210845252E+00, 3.0089623712E+00, 1.6864857935E+00, 8.5147166289E-01],
	[2.3920000000E+04, 1.4481230334E+01, 5.2210130053E+00, 3.0109901804E+00, 1.6871791742E+00, 8.5154170697E-01],
	[2.3925000000E+04, 1.4485947498E+01, 5.2209419727E+00, 3.0130189310E+00, 1.6878726125E+00, 8.5161172008E-01],
	[2.3930000000E+04, 1.4490665212E+01, 5.2208709559E+00, 3.0150486235E+00, 1.6885660256E+00, 8.5168170224E-01],
	[2.3935000000E+04, 1.4495383477E+01, 5.2207999549E+00, 3.0170792579E+00, 1.6892594133E+00, 8.5175165345E-01],
	[2.3940000000E+04, 1.4500102293E+01, 5.2207289697E+00, 3.0191108346E+00, 1.6899527756E+00, 8.5182157372E-01],
	[2.3945000000E+04, 1.4504821658E+01, 5.2206580002E+00, 3.0211433537E+00, 1.6906461121E+00, 8.5189146305E-01],
	[2.3950000000E+04, 1.4509541574E+01, 5.2205870466E+00, 3.0231768156E+00, 1.6913394230E+00, 8.5196132146E-01],
	[2.3955000000E+04, 1.4514262040E+01, 5.2205161087E+00, 3.0252112204E+00, 1.6920327079E+00, 8.5203114896E-01],
	[2.3960000000E+04, 1.4518983056E+01, 5.2204451866E+00, 3.0272465684E+00, 1.6927259669E+00, 8.5210094554E-01],
	[2.3965000000E+04, 1.4523704622E+01, 5.2203742803E+00, 3.0292828598E+00, 1.6934191997E+00, 8.5217071122E-01],
	[2.3970000000E+04, 1.4528426738E+01, 5.2203033897E+00, 3.0313200949E+00, 1.6941124063E+00, 8.5224044601E-01],
	[2.3975000000E+04, 1.4533149403E+01, 5.2202325149E+00, 3.0333582740E+00, 1.6948055865E+00, 8.5231014992E-01],
	[2.3980000000E+04, 1.4537872619E+01, 5.2201616558E+00, 3.0353973971E+00, 1.6954987402E+00, 8.5237982294E-01],
	[2.3985000000E+04, 1.4542596385E+01, 5.2200908125E+00, 3.0374374647E+00, 1.6961918673E+00, 8.5244946510E-01],
	[2.3990000000E+04, 1.4547320700E+01, 5.2200199849E+00, 3.0394784769E+00, 1.6968849676E+00, 8.5251907639E-01],
	[2.3995000000E+04, 1.4552045565E+01, 5.2199491729E+00, 3.0415204339E+00, 1.6975780411E+00, 8.5258865683E-01],
	[2.4000000000E+04, 1.4556770980E+01, 5.2198783768E+00, 3.0435633361E+00, 1.6982710876E+00, 8.5265820643E-01],
	[2.4005000000E+04, 1.4561496944E+01, 5.2198075963E+00, 3.0456071836E+00, 1.6989641069E+00, 8.5272772519E-01],
	[2.4010000000E+04, 1.4566223458E+01, 5.2197368315E+00, 3.0476519767E+00, 1.6996570990E+00, 8.5279721311E-01],
	[2.4015000000E+04, 1.4570950521E+01, 5.2196660824E+00, 3.0496977157E+00, 1.7003500637E+00, 8.5286667022E-01],
	[2.4020000000E+04, 1.4575678134E+01, 5.2195953490E+00, 3.0517444007E+00, 1.7010430009E+00, 8.5293609651E-01],
	[2.4025000000E+04, 1.4580406297E+01, 5.2195246313E+00, 3.0537920320E+00, 1.7017359105E+00, 8.5300549200E-01],
	[2.4030000000E+04, 1.4585135008E+01, 5.2194539293E+00, 3.0558406099E+00, 1.7024287923E+00, 8.5307485669E-01],
	[2.4035000000E+04, 1.4589864269E+01, 5.2193832429E+00, 3.0578901346E+00, 1.7031216463E+00, 8.5314419059E-01],
	[2.4040000000E+04, 1.4594594080E+01, 5.2193125722E+00, 3.0599406063E+00, 1.7038144723E+00, 8.5321349371E-01],
	[2.4045000000E+04, 1.4599324439E+01, 5.2192419171E+00, 3.0619920252E+00, 1.7045072701E+00, 8.5328276605E-01],
	[2.4050000000E+04, 1.4604055348E+01, 5.2191712777E+00, 3.0640443917E+00, 1.7052000397E+00, 8.5335200763E-01],
	[2.4055000000E+04, 1.4608786806E+01, 5.2191006539E+00, 3.0660977059E+00, 1.7058927810E+00, 8.5342121846E-01],
	[2.4060000000E+04, 1.4613518812E+01, 5.2190300458E+00, 3.0681519681E+00, 1.7065854938E+00, 8.5349039853E-01],
	[2.4065000000E+04, 1.4618251368E+01, 5.2189594532E+00, 3.0702071786E+00, 1.7072781779E+00, 8.5355954786E-01],
	[2.4070000000E+04, 1.4622984473E+01, 5.2188888763E+00, 3.0722633375E+00, 1.7079708333E+00, 8.5362866646E-01],
	[2.4075000000E+04, 1.4627718127E+01, 5.2188183151E+00, 3.0743204451E+00, 1.7086634599E+00, 8.5369775434E-01],
	[2.4080000000E+04, 1.4632452329E+01, 5.2187477694E+00, 3.0763785017E+00, 1.7093560575E+00, 8.5376681150E-01],
	[2.4085000000E+04, 1.4637187081E+01, 5.2186772393E+00, 3.0784375074E+00, 1.7100486259E+00, 8.5383583795E-01],
	[2.4090000000E+04, 1.4641922381E+01, 5.2186067248E+00, 3.0804974626E+00, 1.7107411652E+00, 8.5390483371E-01],
	[2.4095000000E+04, 1.4646658230E+01, 5.2185362259E+00, 3.0825583675E+00, 1.7114336750E+00, 8.5397379877E-01],
	[2.4100000000E+04, 1.4651394628E+01, 5.2184657426E+00, 3.0846202222E+00, 1.7121261555E+00, 8.5404273314E-01],
	[2.4105000000E+04, 1.4656131574E+01, 5.2183952749E+00, 3.0866830272E+00, 1.7128186063E+00, 8.5411163685E-01],
	[2.4110000000E+04, 1.4660869068E+01, 5.2183248227E+00, 3.0887467825E+00, 1.7135110274E+00, 8.5418050988E-01],
	[2.4115000000E+04, 1.4665607112E+01, 5.2182543861E+00, 3.0908114884E+00, 1.7142034186E+00, 8.5424935226E-01],
	[2.4120000000E+04, 1.4670345703E+01, 5.2181839650E+00, 3.0928771452E+00, 1.7148957799E+00, 8.5431816399E-01],
	[2.4125000000E+04, 1.4675084844E+01, 5.2181135595E+00, 3.0949437531E+00, 1.7155881111E+00, 8.5438694507E-01],
	[2.4130000000E+04, 1.4679824532E+01, 5.2180431695E+00, 3.0970113124E+00, 1.7162804121E+00, 8.5445569552E-01],
	[2.4135000000E+04, 1.4684564769E+01, 5.2179727951E+00, 3.0990798232E+00, 1.7169726827E+00, 8.5452441535E-01],
	[2.4140000000E+04, 1.4689305554E+01, 5.2179024362E+00, 3.1011492859E+00, 1.7176649229E+00, 8.5459310456E-01],
	[2.4145000000E+04, 1.4694046887E+01, 5.2178320928E+00, 3.1032197007E+00, 1.7183571325E+00, 8.5466176316E-01],
	[2.4150000000E+04, 1.4698788769E+01, 5.2177617649E+00, 3.1052910677E+00, 1.7190493114E+00, 8.5473039116E-01],
	[2.4155000000E+04, 1.4703531198E+01, 5.2176914525E+00, 3.1073633873E+00, 1.7197414595E+00, 8.5479898857E-01],
	[2.4160000000E+04, 1.4708274176E+01, 5.2176211556E+00, 3.1094366597E+00, 1.7204335766E+00, 8.5486755539E-01],
	[2.4165000000E+04, 1.4713017702E+01, 5.2175508743E+00, 3.1115108852E+00, 1.7211256627E+00, 8.5493609164E-01],
	[2.4170000000E+04, 1.4717761775E+01, 5.2174806084E+00, 3.1135860639E+00, 1.7218177176E+00, 8.5500459732E-01],
	[2.4175000000E+04, 1.4722506397E+01, 5.2174103579E+00, 3.1156621961E+00, 1.7225097411E+00, 8.5507307245E-01],
	[2.4180000000E+04, 1.4727251566E+01, 5.2173401230E+00, 3.1177392821E+00, 1.7232017333E+00, 8.5514151702E-01],
	[2.4185000000E+04, 1.4731997283E+01, 5.2172699035E+00, 3.1198173220E+00, 1.7238936939E+00, 8.5520993106E-01],
	[2.4190000000E+04, 1.4736743548E+01, 5.2171996995E+00, 3.1218963162E+00, 1.7245856228E+00, 8.5527831456E-01],
	[2.4195000000E+04, 1.4741490361E+01, 5.2171295110E+00, 3.1239762649E+00, 1.7252775199E+00, 8.5534666754E-01],
	[2.4200000000E+04, 1.4746237721E+01, 5.2170593378E+00, 3.1260571682E+00, 1.7259693850E+00, 8.5541499000E-01],
	[2.4205000000E+04, 1.4750985629E+01, 5.2169891802E+00, 3.1281390266E+00, 1.7266612182E+00, 8.5548328195E-01],
	[2.4210000000E+04, 1.4755734084E+01, 5.2169190379E+00, 3.1302218401E+00, 1.7273530191E+00, 8.5555154340E-01],
	[2.4215000000E+04, 1.4760483087E+01, 5.2168489111E+00, 3.1323056090E+00, 1.7280447878E+00, 8.5561977437E-01],
	[2.4220000000E+04, 1.4765232638E+01, 5.2167787997E+00, 3.1343903337E+00, 1.7287365241E+00, 8.5568797485E-01],
	[2.4225000000E+04, 1.4769982736E+01, 5.2167087037E+00, 3.1364760142E+00, 1.7294282279E+00, 8.5575614486E-01],
	[2.4230000000E+04, 1.4774733381E+01, 5.2166386232E+00, 3.1385626509E+00, 1.7301198990E+00, 8.5582428440E-01],
	[2.4235000000E+04, 1.4779484574E+01, 5.2165685580E+00, 3.1406502440E+00, 1.7308115373E+00, 8.5589239349E-01],
	[2.4240000000E+04, 1.4784236313E+01, 5.2164985082E+00, 3.1427387937E+00, 1.7315031428E+00, 8.5596047213E-01],
	[2.4245000000E+04, 1.4788988600E+01, 5.2164284739E+00, 3.1448283003E+00, 1.7321947152E+00, 8.5602852033E-01],
	[2.4250000000E+04, 1.4793741435E+01, 5.2163584549E+00, 3.1469187640E+00, 1.7328862545E+00, 8.5609653810E-01],
	[2.4255000000E+04, 1.4798494816E+01, 5.2162884512E+00, 3.1490101851E+00, 1.7335777606E+00, 8.5616452544E-01],
	[2.4260000000E+04, 1.4803248744E+01, 5.2162184630E+00, 3.1511025637E+00, 1.7342692333E+00, 8.5623248238E-01],
	[2.4265000000E+04, 1.4808003220E+01, 5.2161484901E+00, 3.1531959002E+00, 1.7349606724E+00, 8.5630040891E-01],
	[2.4270000000E+04, 1.4812758242E+01, 5.2160785325E+00, 3.1552901948E+00, 1.7356520780E+00, 8.5636830504E-01],
	[2.4275000000E+04, 1.4817513811E+01, 5.2160085903E+00, 3.1573854477E+00, 1.7363434499E+00, 8.5643617079E-01],
	[2.4280000000E+04, 1.4822269927E+01, 5.2159386635E+00, 3.1594816591E+00, 1.7370347878E+00, 8.5650400616E-01],
	[2.4285000000E+04, 1.4827026590E+01, 5.2158687520E+00, 3.1615788294E+00, 1.7377260919E+00, 8.5657181115E-01],
	[2.4290000000E+04, 1.4831783800E+01, 5.2157988558E+00, 3.1636769587E+00, 1.7384173618E+00, 8.5663958579E-01],
	[2.4295000000E+04, 1.4836541556E+01, 5.2157289749E+00, 3.1657760472E+00, 1.7391085975E+00, 8.5670733007E-01],
	[2.4300000000E+04, 1.4841299859E+01, 5.2156591094E+00, 3.1678760953E+00, 1.7397997988E+00, 8.5677504401E-01],
	[2.4305000000E+04, 1.4846077898E+01, 5.2155928102E+00, 3.1699771031E+00, 1.7404916249E+00, 8.5684272762E-01],
	[2.4310000000E+04, 1.4850859037E+01, 5.2155269965E+00, 3.1720790710E+00, 1.7411835047E+00, 8.5691038090E-01],
	[2.4315000000E+04, 1.4855640732E+01, 5.2154611971E+00, 3.1741819991E+00, 1.7418753506E+00, 8.5697800386E-01],
	[2.4320000000E+04, 1.4860422983E+01, 5.2153954121E+00, 3.1762858876E+00, 1.7425671626E+00, 8.5704559651E-01],
	[2.4325000000E+04, 1.4865205790E+01, 5.2153296414E+00, 3.1783907369E+00, 1.7432589404E+00, 8.5711315886E-01],
	[2.4330000000E+04, 1.4869989153E+01, 5.2152638851E+00, 3.1804965472E+00, 1.7439506841E+00, 8.5718069092E-01],
	[2.4335000000E+04, 1.4874773071E+01, 5.2151981431E+00, 3.1826033186E+00, 1.7446423935E+00, 8.5724819270E-01],
	[2.4340000000E+04, 1.4879557545E+01, 5.2151324155E+00, 3.1847110515E+00, 1.7453340684E+00, 8.5731566420E-01],
	[2.4345000000E+04, 1.4884342575E+01, 5.2150667021E+00, 3.1868197461E+00, 1.7460257087E+00, 8.5738310544E-01],
	[2.4350000000E+04, 1.4889128161E+01, 5.2150010032E+00, 3.1889294026E+00, 1.7467173144E+00, 8.5745051642E-01],
	[2.4355000000E+04, 1.4893914303E+01, 5.2149353185E+00, 3.1910400212E+00, 1.7474088853E+00, 8.5751789715E-01],
	[2.4360000000E+04, 1.4898700999E+01, 5.2148696481E+00, 3.1931516023E+00, 1.7481004212E+00, 8.5758524765E-01],
	[2.4365000000E+04, 1.4903488252E+01, 5.2148039921E+00, 3.1952641460E+00, 1.7487919222E+00, 8.5765256792E-01],
	[2.4370000000E+04, 1.4908276060E+01, 5.2147383503E+00, 3.1973776526E+00, 1.7494833879E+00, 8.5771985796E-01],
	[2.4375000000E+04, 1.4913064423E+01, 5.2146727228E+00, 3.1994921223E+00, 1.7501748184E+00, 8.5778711780E-01],
	[2.4380000000E+04, 1.4917853342E+01, 5.2146071096E+00, 3.2016075554E+00, 1.7508662136E+00, 8.5785434743E-01],
	[2.4385000000E+04, 1.4922642816E+01, 5.2145415107E+00, 3.2037239521E+00, 1.7515575732E+00, 8.5792154686E-01],
	[2.4390000000E+04, 1.4927432845E+01, 5.2144759261E+00, 3.2058413127E+00, 1.7522488971E+00, 8.5798871611E-01],
	[2.4395000000E+04, 1.4932223429E+01, 5.2144103557E+00, 3.2079596373E+00, 1.7529401854E+00, 8.5805585519E-01],
	[2.4400000000E+04, 1.4937014569E+01, 5.2143447996E+00, 3.2100789263E+00, 1.7536314377E+00, 8.5812296409E-01],
	[2.4405000000E+04, 1.4941806264E+01, 5.2142792578E+00, 3.2121991799E+00, 1.7543226541E+00, 8.5819004284E-01],
	[2.4410000000E+04, 1.4946598513E+01, 5.2142137302E+00, 3.2143203982E+00, 1.7550138344E+00, 8.5825709144E-01],
	[2.4415000000E+04, 1.4951391318E+01, 5.2141482169E+00, 3.2164425816E+00, 1.7557049785E+00, 8.5832410990E-01],
	[2.4420000000E+04, 1.4956184678E+01, 5.2140827178E+00, 3.2185657303E+00, 1.7563960862E+00, 8.5839109823E-01],
	[2.4425000000E+04, 1.4960978593E+01, 5.2140172329E+00, 3.2206898445E+00, 1.7570871574E+00, 8.5845805643E-01],
	[2.4430000000E+04, 1.4965773062E+01, 5.2139517622E+00, 3.2228149246E+00, 1.7577781921E+00, 8.5852498452E-01],
	[2.4435000000E+04, 1.4970568087E+01, 5.2138863058E+00, 3.2249409706E+00, 1.7584691901E+00, 8.5859188251E-01],
	[2.4440000000E+04, 1.4975363666E+01, 5.2138208636E+00, 3.2270679829E+00, 1.7591601513E+00, 8.5865875040E-01],
	[2.4445000000E+04, 1.4980159800E+01, 5.2137554356E+00, 3.2291959616E+00, 1.7598510756E+00, 8.5872558820E-01],
	[2.4450000000E+04, 1.4984956488E+01, 5.2136900218E+00, 3.2313249071E+00, 1.7605419628E+00, 8.5879239593E-01],
	[2.4455000000E+04, 1.4989753732E+01, 5.2136246222E+00, 3.2334548196E+00, 1.7612328129E+00, 8.5885917358E-01],
	[2.4460000000E+04, 1.4994551529E+01, 5.2135592367E+00, 3.2355856993E+00, 1.7619236257E+00, 8.5892592118E-01],
	[2.4465000000E+04, 1.4999349882E+01, 5.2134938655E+00, 3.2377175465E+00, 1.7626144010E+00, 8.5899263873E-01],
	[2.4470000000E+04, 1.5004148788E+01, 5.2134285084E+00, 3.2398503614E+00, 1.7633051389E+00, 8.5905932624E-01],
	[2.4475000000E+04, 1.5008948250E+01, 5.2133631656E+00, 3.2419841442E+00, 1.7639958391E+00, 8.5912598371E-01],
	[2.4480000000E+04, 1.5013748265E+01, 5.2132978368E+00, 3.2441188952E+00, 1.7646865016E+00, 8.5919261116E-01],
	[2.4485000000E+04, 1.5018548835E+01, 5.2132325223E+00, 3.2462546146E+00, 1.7653771263E+00, 8.5925920859E-01],
	[2.4490000000E+04, 1.5023349959E+01, 5.2131672219E+00, 3.2483913027E+00, 1.7660677129E+00, 8.5932577603E-01],
	[2.4495000000E+04, 1.5028151638E+01, 5.2131019356E+00, 3.2505289597E+00, 1.7667582614E+00, 8.5939231346E-01],
	[2.4500000000E+04, 1.5032953870E+01, 5.2130366635E+00, 3.2526675858E+00, 1.7674487718E+00, 8.5945882091E-01],
	[2.4505000000E+04, 1.5037756657E+01, 5.2129714055E+00, 3.2548071813E+00, 1.7681392438E+00, 8.5952529838E-01],
	[2.4510000000E+04, 1.5042559998E+01, 5.2129061617E+00, 3.2569477465E+00, 1.7688296773E+00, 8.5959174588E-01],
	[2.4515000000E+04, 1.5047363893E+01, 5.2128409320E+00, 3.2590892815E+00, 1.7695200723E+00, 8.5965816342E-01],
	[2.4520000000E+04, 1.5052168342E+01, 5.2127757164E+00, 3.2612317866E+00, 1.7702104286E+00, 8.5972455102E-01],
	[2.4525000000E+04, 1.5056973344E+01, 5.2127105149E+00, 3.2633752621E+00, 1.7709007461E+00, 8.5979090867E-01],
	[2.4530000000E+04, 1.5061778901E+01, 5.2126453275E+00, 3.2655197081E+00, 1.7715910246E+00, 8.5985723639E-01],
	[2.4535000000E+04, 1.5066585012E+01, 5.2125801542E+00, 3.2676651250E+00, 1.7722812642E+00, 8.5992353419E-01],
	[2.4540000000E+04, 1.5071391676E+01, 5.2125149950E+00, 3.2698115130E+00, 1.7729714646E+00, 8.5998980207E-01],
	[2.4545000000E+04, 1.5076198894E+01, 5.2124498499E+00, 3.2719588723E+00, 1.7736616257E+00, 8.6005604005E-01],
	[2.4550000000E+04, 1.5081006666E+01, 5.2123847189E+00, 3.2741072031E+00, 1.7743517475E+00, 8.6012224813E-01],
	[2.4555000000E+04, 1.5085814991E+01, 5.2123196020E+00, 3.2762565057E+00, 1.7750418297E+00, 8.6018842633E-01],
	[2.4560000000E+04, 1.5090623870E+01, 5.2122544991E+00, 3.2784067804E+00, 1.7757318724E+00, 8.6025457466E-01],
	[2.4565000000E+04, 1.5095433302E+01, 5.2121894103E+00, 3.2805580274E+00, 1.7764218753E+00, 8.6032069311E-01],
	[2.4570000000E+04, 1.5100243288E+01, 5.2121243355E+00, 3.2827102468E+00, 1.7771118384E+00, 8.6038678171E-01],
	[2.4575000000E+04, 1.5105053828E+01, 5.2120592749E+00, 3.2848634391E+00, 1.7778017615E+00, 8.6045284046E-01],
	[2.4580000000E+04, 1.5109864921E+01, 5.2119942282E+00, 3.2870176043E+00, 1.7784916445E+00, 8.6051886937E-01],
	[2.4585000000E+04, 1.5114676567E+01, 5.2119291956E+00, 3.2891727427E+00, 1.7791814874E+00, 8.6058486845E-01],
	[2.4590000000E+04, 1.5119488766E+01, 5.2118641771E+00, 3.2913288547E+00, 1.7798712899E+00, 8.6065083770E-01],
	[2.4595000000E+04, 1.5124301519E+01, 5.2117991725E+00, 3.2934859404E+00, 1.7805610520E+00, 8.6071677715E-01],
	[2.4600000000E+04, 1.5129114825E+01, 5.2117341820E+00, 3.2956440000E+00, 1.7812507736E+00, 8.6078268680E-01],
	[2.4605000000E+04, 1.5133928684E+01, 5.2116692055E+00, 3.2978030339E+00, 1.7819404546E+00, 8.6084856665E-01],
	[2.4610000000E+04, 1.5138743096E+01, 5.2116042430E+00, 3.2999630421E+00, 1.7826300947E+00, 8.6091441672E-01],
	[2.4615000000E+04, 1.5143558061E+01, 5.2115392946E+00, 3.3021240251E+00, 1.7833196940E+00, 8.6098023701E-01],
	[2.4620000000E+04, 1.5148373580E+01, 5.2114743601E+00, 3.3042859830E+00, 1.7840092523E+00, 8.6104602754E-01],
	[2.4625000000E+04, 1.5153189651E+01, 5.2114094396E+00, 3.3064489161E+00, 1.7846987695E+00, 8.6111178831E-01],
	[2.4630000000E+04, 1.5158006275E+01, 5.2113445331E+00, 3.3086128246E+00, 1.7853882454E+00, 8.6117751934E-01],
	[2.4635000000E+04, 1.5162823452E+01, 5.2112796406E+00, 3.3107777088E+00, 1.7860776800E+00, 8.6124322063E-01],
	[2.4640000000E+04, 1.5167641182E+01, 5.2112147621E+00, 3.3129435688E+00, 1.7867670732E+00, 8.6130889220E-01],
	[2.4645000000E+04, 1.5172459464E+01, 5.2111498975E+00, 3.3151104050E+00, 1.7874564248E+00, 8.6137453404E-01],
	[2.4650000000E+04, 1.5177278299E+01, 5.2110850470E+00, 3.3172782175E+00, 1.7881457347E+00, 8.6144014618E-01],
	[2.4655000000E+04, 1.5182097687E+01, 5.2110202103E+00, 3.3194470067E+00, 1.7888350028E+00, 8.6150572862E-01],
	[2.4660000000E+04, 1.5186917628E+01, 5.2109553876E+00, 3.3216167727E+00, 1.7895242289E+00, 8.6157128137E-01],
	[2.4665000000E+04, 1.5191738121E+01, 5.2108905789E+00, 3.3237875159E+00, 1.7902134131E+00, 8.6163680444E-01],
	[2.4670000000E+04, 1.5196559166E+01, 5.2108257841E+00, 3.3259592363E+00, 1.7909025551E+00, 8.6170229783E-01],
	[2.4675000000E+04, 1.5201380765E+01, 5.2107610033E+00, 3.3281319344E+00, 1.7915916549E+00, 8.6176776157E-01],
	[2.4680000000E+04, 1.5206202915E+01, 5.2106962364E+00, 3.3303056103E+00, 1.7922807123E+00, 8.6183319566E-01],
	[2.4685000000E+04, 1.5211025618E+01, 5.2106314834E+00, 3.3324802642E+00, 1.7929697272E+00, 8.6189860010E-01],
	[2.4690000000E+04, 1.5215848873E+01, 5.2105667443E+00, 3.3346558964E+00, 1.7936586995E+00, 8.6196397491E-01],
	[2.4695000000E+04, 1.5220686811E+01, 5.2105045612E+00, 3.3368325072E+00, 1.7943481269E+00, 8.6202932010E-01],
	[2.4700000000E+04, 1.5225533201E+01, 5.2104438111E+00, 3.3390100968E+00, 1.7950377903E+00, 8.6209463567E-01],
	[2.4705000000E+04, 1.5230380153E+01, 5.2103830740E+00, 3.3411886654E+00, 1.7957274116E+00, 8.6215992164E-01],
	[2.4710000000E+04, 1.5235227667E+01, 5.2103223498E+00, 3.3433682133E+00, 1.7964169907E+00, 8.6222517801E-01],
	[2.4715000000E+04, 1.5240075742E+01, 5.2102616387E+00, 3.3455487407E+00, 1.7971065275E+00, 8.6229040480E-01],
	[2.4720000000E+04, 1.5244924379E+01, 5.2102009406E+00, 3.3477302479E+00, 1.7977960218E+00, 8.6235560201E-01],
	[2.4725000000E+04, 1.5249773578E+01, 5.2101402554E+00, 3.3499127350E+00, 1.7984854736E+00, 8.6242076966E-01],
	[2.4730000000E+04, 1.5254623337E+01, 5.2100795833E+00, 3.3520962024E+00, 1.7991748828E+00, 8.6248590775E-01],
	[2.4735000000E+04, 1.5259473659E+01, 5.2100189241E+00, 3.3542806503E+00, 1.7998642492E+00, 8.6255101629E-01],
	[2.4740000000E+04, 1.5264324541E+01, 5.2099582779E+00, 3.3564660788E+00, 1.8005535727E+00, 8.6261609530E-01],
	[2.4745000000E+04, 1.5269175985E+01, 5.2098976446E+00, 3.3586524884E+00, 1.8012428532E+00, 8.6268114477E-01],
	[2.4750000000E+04, 1.5274027990E+01, 5.2098370243E+00, 3.3608398791E+00, 1.8019320906E+00, 8.6274616473E-01],
	[2.4755000000E+04, 1.5278880557E+01, 5.2097764169E+00, 3.3630282513E+00, 1.8026212848E+00, 8.6281115518E-01],
	[2.4760000000E+04, 1.5283733685E+01, 5.2097158225E+00, 3.3652176052E+00, 1.8033104357E+00, 8.6287611613E-01],
	[2.4765000000E+04, 1.5288587373E+01, 5.2096552410E+00, 3.3674079410E+00, 1.8039995431E+00, 8.6294104759E-01],
	[2.4770000000E+04, 1.5293441623E+01, 5.2095946725E+00, 3.3695992589E+00, 1.8046886069E+00, 8.6300594958E-01],
	[2.4775000000E+04, 1.5298296434E+01, 5.2095341169E+00, 3.3717915593E+00, 1.8053776271E+00, 8.6307082209E-01],
	[2.4780000000E+04, 1.5303151806E+01, 5.2094735742E+00, 3.3739848423E+00, 1.8060666035E+00, 8.6313566514E-01],
	[2.4785000000E+04, 1.5308007739E+01, 5.2094130444E+00, 3.3761791083E+00, 1.8067555361E+00, 8.6320047874E-01],
	[2.4790000000E+04, 1.5312864232E+01, 5.2093525275E+00, 3.3783743573E+00, 1.8074444246E+00, 8.6326526289E-01],
	[2.4795000000E+04, 1.5317721287E+01, 5.2092920236E+00, 3.3805705897E+00, 1.8081332690E+00, 8.6333001762E-01],
	[2.4800000000E+04, 1.5322578902E+01, 5.2092315325E+00, 3.3827678058E+00, 1.8088220691E+00, 8.6339474293E-01],
	[2.4805000000E+04, 1.5327437078E+01, 5.2091710544E+00, 3.3849660057E+00, 1.8095108250E+00, 8.6345943882E-01],
	[2.4810000000E+04, 1.5332295815E+01, 5.2091105891E+00, 3.3871651897E+00, 1.8101995363E+00, 8.6352410531E-01],
	[2.4815000000E+04, 1.5337155112E+01, 5.2090501367E+00, 3.3893653580E+00, 1.8108882031E+00, 8.6358874240E-01],
	[2.4820000000E+04, 1.5342014970E+01, 5.2089896972E+00, 3.3915665109E+00, 1.8115768253E+00, 8.6365335012E-01],
	[2.4825000000E+04, 1.5346875389E+01, 5.2089292706E+00, 3.3937686487E+00, 1.8122654026E+00, 8.6371792846E-01],
	[2.4830000000E+04, 1.5351736368E+01, 5.2088688569E+00, 3.3959717715E+00, 1.8129539350E+00, 8.6378247743E-01],
	[2.4835000000E+04, 1.5356597907E+01, 5.2088084560E+00, 3.3981758796E+00, 1.8136424225E+00, 8.6384699705E-01],
	[2.4840000000E+04, 1.5361460007E+01, 5.2087480679E+00, 3.4003809733E+00, 1.8143308648E+00, 8.6391148733E-01],
	[2.4845000000E+04, 1.5366322667E+01, 5.2086876928E+00, 3.4025870528E+00, 1.8150192618E+00, 8.6397594828E-01],
	[2.4850000000E+04, 1.5371185888E+01, 5.2086273305E+00, 3.4047941183E+00, 1.8157076135E+00, 8.6404037989E-01],
	[2.4855000000E+04, 1.5376049669E+01, 5.2085669810E+00, 3.4070021700E+00, 1.8163959198E+00, 8.6410478220E-01],
	[2.4860000000E+04, 1.5380914010E+01, 5.2085066443E+00, 3.4092112083E+00, 1.8170841805E+00, 8.6416915519E-01],
	[2.4865000000E+04, 1.5385778911E+01, 5.2084463205E+00, 3.4114212333E+00, 1.8177723955E+00, 8.6423349890E-01],
	[2.4870000000E+04, 1.5390644372E+01, 5.2083860095E+00, 3.4136322454E+00, 1.8184605647E+00, 8.6429781331E-01],
	[2.4875000000E+04, 1.5395510393E+01, 5.2083257114E+00, 3.4158442447E+00, 1.8191486881E+00, 8.6436209845E-01],
	[2.4880000000E+04, 1.5400376975E+01, 5.2082654260E+00, 3.4180572314E+00, 1.8198367654E+00, 8.6442635433E-01],
	[2.4885000000E+04, 1.5405244116E+01, 5.2082051535E+00, 3.4202712059E+00, 1.8205247966E+00, 8.6449058094E-01],
	[2.4890000000E+04, 1.5410111817E+01, 5.2081448938E+00, 3.4224861683E+00, 1.8212127815E+00, 8.6455477831E-01],
	[2.4895000000E+04, 1.5414980078E+01, 5.2080846469E+00, 3.4247021190E+00, 1.8219007201E+00, 8.6461894645E-01],
	[2.4900000000E+04, 1.5419848899E+01, 5.2080244127E+00, 3.4269190581E+00, 1.8225886123E+00, 8.6468308536E-01],
	[2.4905000000E+04, 1.5424718280E+01, 5.2079641914E+00, 3.4291369859E+00, 1.8232764579E+00, 8.6474719505E-01],
	[2.4910000000E+04, 1.5429588221E+01, 5.2079039828E+00, 3.4313559026E+00, 1.8239642568E+00, 8.6481127553E-01],
	[2.4915000000E+04, 1.5434458721E+01, 5.2078437871E+00, 3.4335758085E+00, 1.8246520089E+00, 8.6487532682E-01],
	[2.4920000000E+04, 1.5439329780E+01, 5.2077836041E+00, 3.4357967038E+00, 1.8253397141E+00, 8.6493934891E-01],
	[2.4925000000E+04, 1.5444201400E+01, 5.2077234338E+00, 3.4380185888E+00, 1.8260273724E+00, 8.6500334183E-01],
	[2.4930000000E+04, 1.5449073579E+01, 5.2076632764E+00, 3.4402414637E+00, 1.8267149835E+00, 8.6506730559E-01],
	[2.4935000000E+04, 1.5453946317E+01, 5.2076031317E+00, 3.4424653287E+00, 1.8274025474E+00, 8.6513124018E-01],
	[2.4940000000E+04, 1.5458819615E+01, 5.2075429997E+00, 3.4446901841E+00, 1.8280900639E+00, 8.6519514563E-01],
	[2.4945000000E+04, 1.5463693472E+01, 5.2074828805E+00, 3.4469160301E+00, 1.8287775330E+00, 8.6525902194E-01],
	[2.4950000000E+04, 1.5468567889E+01, 5.2074227741E+00, 3.4491428670E+00, 1.8294649546E+00, 8.6532286912E-01],
	[2.4955000000E+04, 1.5473442865E+01, 5.2073626803E+00, 3.4513706950E+00, 1.8301523285E+00, 8.6538668718E-01],
	[2.4960000000E+04, 1.5478318400E+01, 5.2073025993E+00, 3.4535995143E+00, 1.8308396546E+00, 8.6545047613E-01],
	[2.4965000000E+04, 1.5483194494E+01, 5.2072425311E+00, 3.4558293252E+00, 1.8315269328E+00, 8.6551423606E-01],
	[2.4970000000E+04, 1.5488071147E+01, 5.2071824755E+00, 3.4580601280E+00, 1.8322141630E+00, 8.6557796709E-01],
	[2.4975000000E+04, 1.5492948360E+01, 5.2071224327E+00, 3.4602919228E+00, 1.8329013451E+00, 8.6564166923E-01],
	[2.4980000000E+04, 1.5497826132E+01, 5.2070624026E+00, 3.4625247100E+00, 1.8335884791E+00, 8.6570534248E-01],
	[2.4985000000E+04, 1.5502704462E+01, 5.2070023852E+00, 3.4647584897E+00, 1.8342755647E+00, 8.6576898686E-01],
	[2.4990000000E+04, 1.5507583352E+01, 5.2069423805E+00, 3.4669932622E+00, 1.8349626018E+00, 8.6583260238E-01],
	[2.4995000000E+04, 1.5512462800E+01, 5.2068823885E+00, 3.4692290278E+00, 1.8356495905E+00, 8.6589618905E-01],
	[2.5000000000E+04, 1.5517342808E+01, 5.2068224092E+00, 3.4714657866E+00, 1.8363365304E+00, 8.6595974687E-01],
	[2.5005000000E+04, 1.5522223374E+01, 5.2067624425E+00, 3.4737090733E+00, 1.8370249694E+00, 8.6602327586E-01],
	[2.5010000000E+04, 1.5527104499E+01, 5.2067024886E+00, 3.4759533599E+00, 1.8377133596E+00, 8.6608677602E-01],
	[2.5015000000E+04, 1.5531986183E+01, 5.2066425473E+00, 3.4781986468E+00, 1.8384017009E+00, 8.6615024737E-01],
	[2.5020000000E+04, 1.5536868425E+01, 5.2065826187E+00, 3.4804449341E+00, 1.8390899931E+00, 8.6621368992E-01],
	[2.5025000000E+04, 1.5541751226E+01, 5.2065227027E+00, 3.4826922221E+00, 1.8397782362E+00, 8.6627710367E-01],
	[2.5030000000E+04, 1.5546634585E+01, 5.2064627994E+00, 3.4849405110E+00, 1.8404664301E+00, 8.6634048863E-01],
	[2.5035000000E+04, 1.5551518504E+01, 5.2064029088E+00, 3.4871898012E+00, 1.8411545746E+00, 8.6640384482E-01],
	[2.5040000000E+04, 1.5556402980E+01, 5.2063430308E+00, 3.4894400927E+00, 1.8418426696E+00, 8.6646717224E-01],
	[2.5045000000E+04, 1.5561288015E+01, 5.2062831655E+00, 3.4916913860E+00, 1.8425307150E+00, 8.6653047091E-01],
	[2.5050000000E+04, 1.5566173609E+01, 5.2062233128E+00, 3.4939436811E+00, 1.8432187108E+00, 8.6659374083E-01],
	[2.5055000000E+04, 1.5571059760E+01, 5.2061634727E+00, 3.4961969785E+00, 1.8439066568E+00, 8.6665698201E-01],
	[2.5060000000E+04, 1.5575946470E+01, 5.2061036453E+00, 3.4984512782E+00, 1.8445945528E+00, 8.6672019447E-01],
	[2.5065000000E+04, 1.5580833739E+01, 5.2060438305E+00, 3.5007065806E+00, 1.8452823989E+00, 8.6678337820E-01],
	[2.5070000000E+04, 1.5585721565E+01, 5.2059840283E+00, 3.5029628859E+00, 1.8459701948E+00, 8.6684653323E-01],
	[2.5075000000E+04, 1.5590609950E+01, 5.2059242387E+00, 3.5052201944E+00, 1.8466579405E+00, 8.6690965957E-01],
	[2.5080000000E+04, 1.5595498893E+01, 5.2058644617E+00, 3.5074785063E+00, 1.8473456359E+00, 8.6697275721E-01],
	[2.5085000000E+04, 1.5600388393E+01, 5.2058046973E+00, 3.5097378218E+00, 1.8480332808E+00, 8.6703582618E-01],
	[2.5090000000E+04, 1.5605281578E+01, 5.2057454946E+00, 3.5119981412E+00, 1.8487209883E+00, 8.6709886647E-01],
	[2.5095000000E+04, 1.5610194401E+01, 5.2056896546E+00, 3.5142594647E+00, 1.8494093359E+00, 8.6716187811E-01],
	[2.5100000000E+04, 1.5615107791E+01, 5.2056338264E+00, 3.5165217926E+00, 1.8500976336E+00, 8.6722486110E-01],
	[2.5105000000E+04, 1.5620021749E+01, 5.2055780099E+00, 3.5187851251E+00, 1.8507858812E+00, 8.6728781545E-01],
	[2.5110000000E+04, 1.5624936274E+01, 5.2055222051E+00, 3.5210494625E+00, 1.8514740788E+00, 8.6735074117E-01],
	[2.5115000000E+04, 1.5629851366E+01, 5.2054664120E+00, 3.5233148050E+00, 1.8521622260E+00, 8.6741363827E-01],
	[2.5120000000E+04, 1.5634767026E+01, 5.2054106307E+00, 3.5255811529E+00, 1.8528503230E+00, 8.6747650676E-01],
	[2.5125000000E+04, 1.5639683252E+01, 5.2053548610E+00, 3.5278485063E+00, 1.8535383694E+00, 8.6753934665E-01],
	[2.5130000000E+04, 1.5644600046E+01, 5.2052991030E+00, 3.5301168657E+00, 1.8542263653E+00, 8.6760215795E-01],
	[2.5135000000E+04, 1.5649517408E+01, 5.2052433567E+00, 3.5323862311E+00, 1.8549143106E+00, 8.6766494067E-01],
	[2.5140000000E+04, 1.5654435336E+01, 5.2051876221E+00, 3.5346566028E+00, 1.8556022050E+00, 8.6772769481E-01],
	[2.5145000000E+04, 1.5659353831E+01, 5.2051318992E+00, 3.5369279812E+00, 1.8562900486E+00, 8.6779042040E-01],
	[2.5150000000E+04, 1.5664272893E+01, 5.2050761880E+00, 3.5392003663E+00, 1.8569778412E+00, 8.6785311744E-01],
	[2.5155000000E+04, 1.5669192522E+01, 5.2050204884E+00, 3.5414737586E+00, 1.8576655826E+00, 8.6791578593E-01],
	[2.5160000000E+04, 1.5674112718E+01, 5.2049648005E+00, 3.5437481582E+00, 1.8583532729E+00, 8.6797842590E-01],
	[2.5165000000E+04, 1.5679033480E+01, 5.2049091242E+00, 3.5460235653E+00, 1.8590409118E+00, 8.6804103734E-01],
	[2.5170000000E+04, 1.5683954810E+01, 5.2048534596E+00, 3.5482999803E+00, 1.8597284993E+00, 8.6810362027E-01],
	[2.5175000000E+04, 1.5688876706E+01, 5.2047978067E+00, 3.5505774033E+00, 1.8604160353E+00, 8.6816617470E-01],
	[2.5180000000E+04, 1.5693799169E+01, 5.2047421654E+00, 3.5528558346E+00, 1.8611035196E+00, 8.6822870064E-01],
	[2.5185000000E+04, 1.5698722198E+01, 5.2046865357E+00, 3.5551352745E+00, 1.8617909522E+00, 8.6829119809E-01],
	[2.5190000000E+04, 1.5703645794E+01, 5.2046309177E+00, 3.5574157232E+00, 1.8624783330E+00, 8.6835366708E-01],
	[2.5195000000E+04, 1.5708569957E+01, 5.2045753113E+00, 3.5596971809E+00, 1.8631656617E+00, 8.6841610760E-01],
	[2.5200000000E+04, 1.5713494686E+01, 5.2045197166E+00, 3.5619796479E+00, 1.8638529385E+00, 8.6847851967E-01],
	[2.5205000000E+04, 1.5718419982E+01, 5.2044641335E+00, 3.5642631244E+00, 1.8645401630E+00, 8.6854090330E-01],
	[2.5210000000E+04, 1.5723345844E+01, 5.2044085619E+00, 3.5665476107E+00, 1.8652273353E+00, 8.6860325849E-01],
	[2.5215000000E+04, 1.5728272272E+01, 5.2043530020E+00, 3.5688331071E+00, 1.8659144552E+00, 8.6866558526E-01],
	[2.5220000000E+04, 1.5733199266E+01, 5.2042974538E+00, 3.5711196137E+00, 1.8666015226E+00, 8.6872788362E-01],
	[2.5225000000E+04, 1.5738126827E+01, 5.2042419171E+00, 3.5734071308E+00, 1.8672885374E+00, 8.6879015358E-01],
	[2.5230000000E+04, 1.5743054954E+01, 5.2041863920E+00, 3.5756956587E+00, 1.8679754994E+00, 8.6885239515E-01],
	[2.5235000000E+04, 1.5747983647E+01, 5.2041308785E+00, 3.5779851976E+00, 1.8686624087E+00, 8.6891460833E-01],
	[2.5240000000E+04, 1.5752912907E+01, 5.2040753766E+00, 3.5802757478E+00, 1.8693492651E+00, 8.6897679314E-01],
	[2.5245000000E+04, 1.5757842732E+01, 5.2040198863E+00, 3.5825673094E+00, 1.8700360685E+00, 8.6903894959E-01],
	[2.5250000000E+04, 1.5762773123E+01, 5.2039644075E+00, 3.5848598828E+00, 1.8707228187E+00, 8.6910107768E-01],
	[2.5255000000E+04, 1.5767704081E+01, 5.2039089404E+00, 3.5871534682E+00, 1.8714095157E+00, 8.6916317744E-01],
	[2.5260000000E+04, 1.5772635604E+01, 5.2038534848E+00, 3.5894480658E+00, 1.8720961593E+00, 8.6922524886E-01],
	[2.5265000000E+04, 1.5777567693E+01, 5.2037980408E+00, 3.5917436759E+00, 1.8727827496E+00, 8.6928729195E-01],
	[2.5270000000E+04, 1.5782500348E+01, 5.2037426083E+00, 3.5940402987E+00, 1.8734692862E+00, 8.6934930674E-01],
	[2.5275000000E+04, 1.5787433569E+01, 5.2036871874E+00, 3.5963379345E+00, 1.8741557692E+00, 8.6941129322E-01],
	[2.5280000000E+04, 1.5792367355E+01, 5.2036317781E+00, 3.5986365836E+00, 1.8748421985E+00, 8.6947325141E-01],
	[2.5285000000E+04, 1.5797301708E+01, 5.2035763803E+00, 3.6009362461E+00, 1.8755285739E+00, 8.6953518132E-01],
	[2.5290000000E+04, 1.5802236625E+01, 5.2035209940E+00, 3.6032369223E+00, 1.8762148953E+00, 8.6959708295E-01],
	[2.5295000000E+04, 1.5807172109E+01, 5.2034656193E+00, 3.6055386124E+00, 1.8769011627E+00, 8.6965895632E-01],
	[2.5300000000E+04, 1.5812108158E+01, 5.2034102561E+00, 3.6078413168E+00, 1.8775873758E+00, 8.6972080144E-01],
	[2.5305000000E+04, 1.5817044772E+01, 5.2033549045E+00, 3.6101450356E+00, 1.8782735347E+00, 8.6978261832E-01],
	[2.5310000000E+04, 1.5821981952E+01, 5.2032995643E+00, 3.6124497691E+00, 1.8789596392E+00, 8.6984440696E-01],
	[2.5315000000E+04, 1.5826919697E+01, 5.2032442357E+00, 3.6147555175E+00, 1.8796456892E+00, 8.6990616738E-01],
	[2.5320000000E+04, 1.5831858008E+01, 5.2031889186E+00, 3.6170622811E+00, 1.8803316846E+00, 8.6996789959E-01],
	[2.5325000000E+04, 1.5836796884E+01, 5.2031336130E+00, 3.6193700602E+00, 1.8810176253E+00, 8.7002960360E-01],
	[2.5330000000E+04, 1.5841736325E+01, 5.2030783190E+00, 3.6216788549E+00, 1.8817035112E+00, 8.7009127942E-01],
	[2.5335000000E+04, 1.5846676332E+01, 5.2030230364E+00, 3.6239886656E+00, 1.8823893422E+00, 8.7015292705E-01],
	[2.5340000000E+04, 1.5851616903E+01, 5.2029677653E+00, 3.6262994924E+00, 1.8830751182E+00, 8.7021454651E-01],
	[2.5345000000E+04, 1.5856558040E+01, 5.2029125057E+00, 3.6286113357E+00, 1.8837608391E+00, 8.7027613781E-01],
	[2.5350000000E+04, 1.5861499742E+01, 5.2028572576E+00, 3.6309241956E+00, 1.8844465047E+00, 8.7033770096E-01],
	[2.5355000000E+04, 1.5866442009E+01, 5.2028020210E+00, 3.6332380724E+00, 1.8851321150E+00, 8.7039923596E-01],
	[2.5360000000E+04, 1.5871384840E+01, 5.2027467958E+00, 3.6355529664E+00, 1.8858176699E+00, 8.7046074284E-01],
	[2.5365000000E+04, 1.5876328237E+01, 5.2026915822E+00, 3.6378688777E+00, 1.8865031692E+00, 8.7052222159E-01],
	[2.5370000000E+04, 1.5881272199E+01, 5.2026363800E+00, 3.6401858067E+00, 1.8871886129E+00, 8.7058367223E-01],
	[2.5375000000E+04, 1.5886216725E+01, 5.2025811892E+00, 3.6425037536E+00, 1.8878740008E+00, 8.7064509477E-01],
	[2.5380000000E+04, 1.5891161816E+01, 5.2025260100E+00, 3.6448227187E+00, 1.8885593329E+00, 8.7070648922E-01],
	[2.5385000000E+04, 1.5896107473E+01, 5.2024708421E+00, 3.6471427021E+00, 1.8892446091E+00, 8.7076785559E-01],
	[2.5390000000E+04, 1.5901053693E+01, 5.2024156858E+00, 3.6494637042E+00, 1.8899298292E+00, 8.7082919389E-01],
	[2.5395000000E+04, 1.5906000479E+01, 5.2023605408E+00, 3.6517857251E+00, 1.8906149931E+00, 8.7089050412E-01],
	[2.5400000000E+04, 1.5910947829E+01, 5.2023054074E+00, 3.6541087651E+00, 1.8913001008E+00, 8.7095178631E-01],
	[2.5405000000E+04, 1.5915895743E+01, 5.2022502853E+00, 3.6564328246E+00, 1.8919851522E+00, 8.7101304046E-01],
	[2.5410000000E+04, 1.5920844222E+01, 5.2021951747E+00, 3.6587579036E+00, 1.8926701470E+00, 8.7107426657E-01],
	[2.5415000000E+04, 1.5925793266E+01, 5.2021400755E+00, 3.6610840025E+00, 1.8933550853E+00, 8.7113546467E-01],
	[2.5420000000E+04, 1.5930742874E+01, 5.2020849877E+00, 3.6634111215E+00, 1.8940399669E+00, 8.7119663475E-01],
	[2.5425000000E+04, 1.5935693046E+01, 5.2020299114E+00, 3.6657392608E+00, 1.8947247917E+00, 8.7125777684E-01],
	[2.5430000000E+04, 1.5940643783E+01, 5.2019748464E+00, 3.6680684208E+00, 1.8954095597E+00, 8.7131889094E-01],
	[2.5435000000E+04, 1.5945595084E+01, 5.2019197929E+00, 3.6703986016E+00, 1.8960942707E+00, 8.7137997706E-01],
	[2.5440000000E+04, 1.5950546949E+01, 5.2018647508E+00, 3.6727298035E+00, 1.8967789246E+00, 8.7144103520E-01],
	[2.5445000000E+04, 1.5955499378E+01, 5.2018097200E+00, 3.6750620267E+00, 1.8974635213E+00, 8.7150206539E-01],
	[2.5450000000E+04, 1.5960452372E+01, 5.2017547007E+00, 3.6773952715E+00, 1.8981480607E+00, 8.7156306764E-01],
	[2.5455000000E+04, 1.5965405929E+01, 5.2016996928E+00, 3.6797295381E+00, 1.8988325427E+00, 8.7162404194E-01],
	[2.5460000000E+04, 1.5970360051E+01, 5.2016446962E+00, 3.6820648268E+00, 1.8995169672E+00, 8.7168498831E-01],
	[2.5465000000E+04, 1.5975314737E+01, 5.2015897110E+00, 3.6844011378E+00, 1.9002013342E+00, 8.7174590677E-01],
	[2.5470000000E+04, 1.5980269986E+01, 5.2015347372E+00, 3.6867384714E+00, 1.9008856434E+00, 8.7180679732E-01],
	[2.5475000000E+04, 1.5985225800E+01, 5.2014797748E+00, 3.6890768278E+00, 1.9015698949E+00, 8.7186765997E-01],
	[2.5480000000E+04, 1.5990182177E+01, 5.2014248237E+00, 3.6914162073E+00, 1.9022540884E+00, 8.7192849473E-01],
	[2.5485000000E+04, 1.5995139118E+01, 5.2013698840E+00, 3.6937566101E+00, 1.9029382239E+00, 8.7198930162E-01],
	[2.5490000000E+04, 1.6000096623E+01, 5.2013149557E+00, 3.6960980364E+00, 1.9036223013E+00, 8.7205008064E-01],
	[2.5495000000E+04, 1.6005062665E+01, 5.2012614185E+00, 3.6984404865E+00, 1.9043066184E+00, 8.7211083181E-01],
	[2.5500000000E+04, 1.6010043445E+01, 5.2012103443E+00, 3.7007839607E+00, 1.9049914070E+00, 8.7217155512E-01],
	[2.5505000000E+04, 1.6015024798E+01, 5.2011592805E+00, 3.7031284591E+00, 1.9056761380E+00, 8.7223225060E-01],
	[2.5510000000E+04, 1.6020006725E+01, 5.2011082273E+00, 3.7054739821E+00, 1.9063608114E+00, 8.7229291826E-01],
	[2.5515000000E+04, 1.6024989224E+01, 5.2010571846E+00, 3.7078205299E+00, 1.9070454269E+00, 8.7235355810E-01],
	[2.5520000000E+04, 1.6029972296E+01, 5.2010061524E+00, 3.7101681027E+00, 1.9077299847E+00, 8.7241417014E-01],
	[2.5525000000E+04, 1.6034955941E+01, 5.2009551307E+00, 3.7125167008E+00, 1.9084144844E+00, 8.7247475438E-01],
	[2.5530000000E+04, 1.6039940159E+01, 5.2009041195E+00, 3.7148663244E+00, 1.9090989261E+00, 8.7253531083E-01],
	[2.5535000000E+04, 1.6044924950E+01, 5.2008531187E+00, 3.7172169738E+00, 1.9097833095E+00, 8.7259583951E-01],
	[2.5540000000E+04, 1.6049910313E+01, 5.2008021285E+00, 3.7195686492E+00, 1.9104676347E+00, 8.7265634043E-01],
	[2.5545000000E+04, 1.6054896249E+01, 5.2007511487E+00, 3.7219213508E+00, 1.9111519016E+00, 8.7271681360E-01],
	[2.5550000000E+04, 1.6059882758E+01, 5.2007001794E+00, 3.7242750790E+00, 1.9118361099E+00, 8.7277725902E-01],
	[2.5555000000E+04, 1.6064869839E+01, 5.2006492206E+00, 3.7266298339E+00, 1.9125202597E+00, 8.7283767670E-01],
	[2.5560000000E+04, 1.6069857493E+01, 5.2005982723E+00, 3.7289856158E+00, 1.9132043508E+00, 8.7289806667E-01],
	[2.5565000000E+04, 1.6074845719E+01, 5.2005473344E+00, 3.7313424250E+00, 1.9138883831E+00, 8.7295842892E-01],
	[2.5570000000E+04, 1.6079834518E+01, 5.2004964070E+00, 3.7337002616E+00, 1.9145723565E+00, 8.7301876347E-01],
	[2.5575000000E+04, 1.6084823889E+01, 5.2004454900E+00, 3.7360591260E+00, 1.9152562710E+00, 8.7307907033E-01],
	[2.5580000000E+04, 1.6089813832E+01, 5.2003945835E+00, 3.7384190184E+00, 1.9159401263E+00, 8.7313934951E-01],
	[2.5585000000E+04, 1.6094804348E+01, 5.2003436874E+00, 3.7407799390E+00, 1.9166239225E+00, 8.7319960101E-01],
	[2.5590000000E+04, 1.6099795436E+01, 5.2002928018E+00, 3.7431418881E+00, 1.9173076594E+00, 8.7325982486E-01],
	[2.5595000000E+04, 1.6104787096E+01, 5.2002419266E+00, 3.7455048659E+00, 1.9179913369E+00, 8.7332002105E-01],
	[2.5600000000E+04, 1.6109779329E+01, 5.2001910619E+00, 3.7478688727E+00, 1.9186749549E+00, 8.7338018961E-01],
	[2.5605000000E+04, 1.6114772133E+01, 5.2001402076E+00, 3.7502339088E+00, 1.9193585134E+00, 8.7344033053E-01],
	[2.5610000000E+04, 1.6119765509E+01, 5.2000893637E+00, 3.7525999742E+00, 1.9200420121E+00, 8.7350044384E-01],
	[2.5615000000E+04, 1.6124759458E+01, 5.2000385302E+00, 3.7549670694E+00, 1.9207254511E+00, 8.7356052954E-01],
	[2.5620000000E+04, 1.6129753978E+01, 5.1999877072E+00, 3.7573351946E+00, 1.9214088302E+00, 8.7362058764E-01],
	[2.5625000000E+04, 1.6134749071E+01, 5.1999368945E+00, 3.7597043499E+00, 1.9220921493E+00, 8.7368061815E-01],
	[2.5630000000E+04, 1.6139744735E+01, 5.1998860923E+00, 3.7620745357E+00, 1.9227754083E+00, 8.7374062108E-01],
	[2.5635000000E+04, 1.6144740971E+01, 5.1998353005E+00, 3.7644457522E+00, 1.9234586072E+00, 8.7380059644E-01],
	[2.5640000000E+04, 1.6149737779E+01, 5.1997845191E+00, 3.7668179997E+00, 1.9241417458E+00, 8.7386054425E-01],
	[2.5645000000E+04, 1.6154735159E+01, 5.1997337481E+00, 3.7691912783E+00, 1.9248248239E+00, 8.7392046452E-01],
	[2.5650000000E+04, 1.6159733110E+01, 5.1996829874E+00, 3.7715655884E+00, 1.9255078416E+00, 8.7398035724E-01],
	[2.5655000000E+04, 1.6164731633E+01, 5.1996322372E+00, 3.7739409301E+00, 1.9261907988E+00, 8.7404022244E-01],
	[2.5660000000E+04, 1.6169730728E+01, 5.1995814973E+00, 3.7763173038E+00, 1.9268736952E+00, 8.7410006013E-01],
	[2.5665000000E+04, 1.6174730394E+01, 5.1995307679E+00, 3.7786947097E+00, 1.9275565309E+00, 8.7415987031E-01],
	[2.5670000000E+04, 1.6179730631E+01, 5.1994800488E+00, 3.7810731480E+00, 1.9282393057E+00, 8.7421965299E-01],
	[2.5675000000E+04, 1.6184731441E+01, 5.1994293401E+00, 3.7834526189E+00, 1.9289220195E+00, 8.7427940819E-01],
	[2.5680000000E+04, 1.6189732821E+01, 5.1993786417E+00, 3.7858331228E+00, 1.9296046723E+00, 8.7433913592E-01],
	[2.5685000000E+04, 1.6194734773E+01, 5.1993279537E+00, 3.7882146598E+00, 1.9302872638E+00, 8.7439883618E-01],
	[2.5690000000E+04, 1.6199737296E+01, 5.1992772761E+00, 3.7905972303E+00, 1.9309697941E+00, 8.7445850900E-01],
	[2.5695000000E+04, 1.6204740391E+01, 5.1992266088E+00, 3.7929808344E+00, 1.9316522631E+00, 8.7451815437E-01],
	[2.5700000000E+04, 1.6209744056E+01, 5.1991759519E+00, 3.7953654724E+00, 1.9323346705E+00, 8.7457777230E-01],
	[2.5705000000E+04, 1.6214748293E+01, 5.1991253053E+00, 3.7977511446E+00, 1.9330170164E+00, 8.7463736282E-01],
	[2.5710000000E+04, 1.6219753102E+01, 5.1990746691E+00, 3.8001378511E+00, 1.9336993007E+00, 8.7469692593E-01],
	[2.5715000000E+04, 1.6224758481E+01, 5.1990240432E+00, 3.8025255923E+00, 1.9343815232E+00, 8.7475646163E-01],
	[2.5720000000E+04, 1.6229764431E+01, 5.1989734277E+00, 3.8049143684E+00, 1.9350636838E+00, 8.7481596994E-01],
	[2.5725000000E+04, 1.6234770952E+01, 5.1989228224E+00, 3.8073041797E+00, 1.9357457824E+00, 8.7487545088E-01],
	[2.5730000000E+04, 1.6239778044E+01, 5.1988722276E+00, 3.8096950263E+00, 1.9364278190E+00, 8.7493490445E-01],
	[2.5735000000E+04, 1.6244785708E+01, 5.1988216430E+00, 3.8120869085E+00, 1.9371097935E+00, 8.7499433065E-01],
	[2.5740000000E+04, 1.6249793942E+01, 5.1987710687E+00, 3.8144798267E+00, 1.9377917057E+00, 8.7505372951E-01],
	[2.5745000000E+04, 1.6254802746E+01, 5.1987205048E+00, 3.8168737809E+00, 1.9384735555E+00, 8.7511310103E-01],
	[2.5750000000E+04, 1.6259812122E+01, 5.1986699512E+00, 3.8192687715E+00, 1.9391553429E+00, 8.7517244523E-01],
	[2.5755000000E+04, 1.6264822068E+01, 5.1986194079E+00, 3.8216647988E+00, 1.9398370677E+00, 8.7523176211E-01],
	[2.5760000000E+04, 1.6269832585E+01, 5.1985688748E+00, 3.8240618629E+00, 1.9405187300E+00, 8.7529105168E-01],
	[2.5765000000E+04, 1.6274843673E+01, 5.1985183521E+00, 3.8264599641E+00, 1.9412003294E+00, 8.7535031395E-01],
	[2.5770000000E+04, 1.6279855331E+01, 5.1984678397E+00, 3.8288591027E+00, 1.9418818660E+00, 8.7540954894E-01],
	[2.5775000000E+04, 1.6284867560E+01, 5.1984173376E+00, 3.8312592789E+00, 1.9425633397E+00, 8.7546875666E-01],
	[2.5780000000E+04, 1.6289880359E+01, 5.1983668457E+00, 3.8336604929E+00, 1.9432447504E+00, 8.7552793711E-01],
	[2.5785000000E+04, 1.6294893729E+01, 5.1983163642E+00, 3.8360627450E+00, 1.9439260979E+00, 8.7558709031E-01],
	[2.5790000000E+04, 1.6299907669E+01, 5.1982658929E+00, 3.8384660355E+00, 1.9446073822E+00, 8.7564621627E-01],
	[2.5795000000E+04, 1.6304922180E+01, 5.1982154319E+00, 3.8408703646E+00, 1.9452886032E+00, 8.7570531499E-01],
	[2.5800000000E+04, 1.6309937260E+01, 5.1981649811E+00, 3.8432757325E+00, 1.9459697608E+00, 8.7576438649E-01],
	[2.5805000000E+04, 1.6314952912E+01, 5.1981145406E+00, 3.8456821395E+00, 1.9466508548E+00, 8.7582343078E-01],
	[2.5810000000E+04, 1.6319969133E+01, 5.1980641104E+00, 3.8480895858E+00, 1.9473318853E+00, 8.7588244787E-01],
	[2.5815000000E+04, 1.6324985924E+01, 5.1980136905E+00, 3.8504980718E+00, 1.9480128520E+00, 8.7594143776E-01],
	[2.5820000000E+04, 1.6330003286E+01, 5.1979632808E+00, 3.8529075975E+00, 1.9486937549E+00, 8.7600040048E-01],
	[2.5825000000E+04, 1.6335021218E+01, 5.1979128813E+00, 3.8553181633E+00, 1.9493745939E+00, 8.7605933603E-01],
	[2.5830000000E+04, 1.6340039720E+01, 5.1978624921E+00, 3.8577297695E+00, 1.9500553689E+00, 8.7611824442E-01],
	[2.5835000000E+04, 1.6345058791E+01, 5.1978121131E+00, 3.8601424162E+00, 1.9507360799E+00, 8.7617712566E-01],
	[2.5840000000E+04, 1.6350078433E+01, 5.1977617444E+00, 3.8625561037E+00, 1.9514167266E+00, 8.7623597977E-01],
	[2.5845000000E+04, 1.6355098645E+01, 5.1977113859E+00, 3.8649708323E+00, 1.9520973090E+00, 8.7629480674E-01],
	[2.5850000000E+04, 1.6360119426E+01, 5.1976610376E+00, 3.8673866022E+00, 1.9527778271E+00, 8.7635360660E-01],
	[2.5855000000E+04, 1.6365140778E+01, 5.1976106996E+00, 3.8698034136E+00, 1.9534582807E+00, 8.7641237936E-01],
	[2.5860000000E+04, 1.6370162699E+01, 5.1975603718E+00, 3.8722212669E+00, 1.9541386697E+00, 8.7647112502E-01],
	[2.5865000000E+04, 1.6375185190E+01, 5.1975100542E+00, 3.8746401622E+00, 1.9548189940E+00, 8.7652984359E-01],
	[2.5870000000E+04, 1.6380208250E+01, 5.1974597468E+00, 3.8770600998E+00, 1.9554992536E+00, 8.7658853509E-01],
	[2.5875000000E+04, 1.6385231880E+01, 5.1974094496E+00, 3.8794810799E+00, 1.9561794483E+00, 8.7664719953E-01],
	[2.5880000000E+04, 1.6390256080E+01, 5.1973591626E+00, 3.8819031029E+00, 1.9568595780E+00, 8.7670583691E-01],
	[2.5885000000E+04, 1.6395280849E+01, 5.1973088858E+00, 3.8843261689E+00, 1.9575396427E+00, 8.7676444725E-01],
	[2.5890000000E+04, 1.6400306188E+01, 5.1972586193E+00, 3.8867502781E+00, 1.9582196423E+00, 8.7682303056E-01],
	[2.5895000000E+04, 1.6405332096E+01, 5.1972083629E+00, 3.8891754309E+00, 1.9588995766E+00, 8.7688158684E-01],
	[2.5900000000E+04, 1.6410358574E+01, 5.1971581167E+00, 3.8916016275E+00, 1.9595794455E+00, 8.7694011612E-01],
	[2.5905000000E+04, 1.6415391771E+01, 5.1971089308E+00, 3.8940288681E+00, 1.9602594862E+00, 8.7699861840E-01],
	[2.5910000000E+04, 1.6420441443E+01, 5.1970624693E+00, 3.8964571530E+00, 1.9609400748E+00, 8.7705709368E-01],
	[2.5915000000E+04, 1.6425491693E+01, 5.1970160173E+00, 3.8988864824E+00, 1.9616205986E+00, 8.7711554199E-01],
	[2.5920000000E+04, 1.6430542522E+01, 5.1969695746E+00, 3.9013168566E+00, 1.9623010575E+00, 8.7717396333E-01],
	[2.5925000000E+04, 1.6435593929E+01, 5.1969231413E+00, 3.9037482758E+00, 1.9629814514E+00, 8.7723235771E-01],
	[2.5930000000E+04, 1.6440645915E+01, 5.1968767173E+00, 3.9061807402E+00, 1.9636617802E+00, 8.7729072515E-01],
	[2.5935000000E+04, 1.6445698479E+01, 5.1968303027E+00, 3.9086142502E+00, 1.9643420439E+00, 8.7734906565E-01],
	[2.5940000000E+04, 1.6450751622E+01, 5.1967838975E+00, 3.9110488059E+00, 1.9650222423E+00, 8.7740737922E-01],
	[2.5945000000E+04, 1.6455805343E+01, 5.1967375017E+00, 3.9134844076E+00, 1.9657023754E+00, 8.7746566588E-01],
	[2.5950000000E+04, 1.6460859642E+01, 5.1966911152E+00, 3.9159210556E+00, 1.9663824430E+00, 8.7752392563E-01],
	[2.5955000000E+04, 1.6465914519E+01, 5.1966447380E+00, 3.9183587501E+00, 1.9670624450E+00, 8.7758215849E-01],
	[2.5960000000E+04, 1.6470969974E+01, 5.1965983702E+00, 3.9207974913E+00, 1.9677423814E+00, 8.7764036447E-01],
	[2.5965000000E+04, 1.6476026008E+01, 5.1965520117E+00, 3.9232372795E+00, 1.9684222521E+00, 8.7769854357E-01],
	[2.5970000000E+04, 1.6481082619E+01, 5.1965056626E+00, 3.9256781150E+00, 1.9691020570E+00, 8.7775669581E-01],
	[2.5975000000E+04, 1.6486139809E+01, 5.1964593228E+00, 3.9281199979E+00, 1.9697817959E+00, 8.7781482120E-01],
	[2.5980000000E+04, 1.6491197576E+01, 5.1964129924E+00, 3.9305629286E+00, 1.9704614688E+00, 8.7787291975E-01],
	[2.5985000000E+04, 1.6496255922E+01, 5.1963666713E+00, 3.9330069072E+00, 1.9711410756E+00, 8.7793099147E-01],
	[2.5990000000E+04, 1.6501314845E+01, 5.1963203595E+00, 3.9354519341E+00, 1.9718206161E+00, 8.7798903637E-01],
	[2.5995000000E+04, 1.6506374346E+01, 5.1962740570E+00, 3.9378980095E+00, 1.9725000904E+00, 8.7804705447E-01],
	[2.6000000000E+04, 1.6511434425E+01, 5.1962277638E+00, 3.9403451336E+00, 1.9731794983E+00, 8.7810504576E-01],
	[2.6005000000E+04, 1.6516495081E+01, 5.1961814800E+00, 3.9427933067E+00, 1.9738588397E+00, 8.7816301027E-01],
	[2.6010000000E+04, 1.6521556316E+01, 5.1961352054E+00, 3.9452425289E+00, 1.9745381145E+00, 8.7822094800E-01],
	[2.6015000000E+04, 1.6526618128E+01, 5.1960889402E+00, 3.9476928007E+00, 1.9752173227E+00, 8.7827885896E-01],
	[2.6020000000E+04, 1.6531680517E+01, 5.1960426843E+00, 3.9501441222E+00, 1.9758964641E+00, 8.7833674317E-01],
	[2.6025000000E+04, 1.6536743484E+01, 5.1959964376E+00, 3.9525964936E+00, 1.9765755386E+00, 8.7839460063E-01],
	[2.6030000000E+04, 1.6541807029E+01, 5.1959502003E+00, 3.9550499152E+00, 1.9772545461E+00, 8.7845243136E-01],
	[2.6035000000E+04, 1.6546871151E+01, 5.1959039723E+00, 3.9575043873E+00, 1.9779334867E+00, 8.7851023537E-01],
	[2.6040000000E+04, 1.6551935850E+01, 5.1958577535E+00, 3.9599599101E+00, 1.9786123600E+00, 8.7856801267E-01],
	[2.6045000000E+04, 1.6557001127E+01, 5.1958115441E+00, 3.9624164839E+00, 1.9792911662E+00, 8.7862576326E-01],
	[2.6050000000E+04, 1.6562066982E+01, 5.1957653439E+00, 3.9648741088E+00, 1.9799699050E+00, 8.7868348716E-01],
	[2.6055000000E+04, 1.6567133413E+01, 5.1957191530E+00, 3.9673327852E+00, 1.9806485764E+00, 8.7874118438E-01],
	[2.6060000000E+04, 1.6572200422E+01, 5.1956729713E+00, 3.9697925133E+00, 1.9813271803E+00, 8.7879885493E-01],
	[2.6065000000E+04, 1.6577268008E+01, 5.1956267990E+00, 3.9722532933E+00, 1.9820057166E+00, 8.7885649883E-01],
	[2.6070000000E+04, 1.6582336171E+01, 5.1955806359E+00, 3.9747151256E+00, 1.9826841852E+00, 8.7891411607E-01],
	[2.6075000000E+04, 1.6587404911E+01, 5.1955344820E+00, 3.9771780102E+00, 1.9833625860E+00, 8.7897170665E-01],
	[2.6080000000E+04, 1.6592474228E+01, 5.1954883374E+00, 3.9796419475E+00, 1.9840409189E+00, 8.7902927054E-01],
	[2.6085000000E+04, 1.6597544122E+01, 5.1954422021E+00, 3.9821069378E+00, 1.9847191839E+00, 8.7908680775E-01],
	[2.6090000000E+04, 1.6602614594E+01, 5.1953960761E+00, 3.9845729813E+00, 1.9853973808E+00, 8.7914431829E-01],
	[2.6095000000E+04, 1.6607685642E+01, 5.1953499592E+00, 3.9870400781E+00, 1.9860755095E+00, 8.7920180216E-01],
	[2.6100000000E+04, 1.6612757267E+01, 5.1953038517E+00, 3.9895082287E+00, 1.9867535700E+00, 8.7925925938E-01],
	[2.6105000000E+04, 1.6617829469E+01, 5.1952577533E+00, 3.9919774331E+00, 1.9874315621E+00, 8.7931668996E-01],
	[2.6110000000E+04, 1.6622902247E+01, 5.1952116642E+00, 3.9944476918E+00, 1.9881094858E+00, 8.7937409389E-01],
	[2.6115000000E+04, 1.6627975603E+01, 5.1951655844E+00, 3.9969190048E+00, 1.9887873410E+00, 8.7943147120E-01],
	[2.6120000000E+04, 1.6633049535E+01, 5.1951195137E+00, 3.9993913725E+00, 1.9894651276E+00, 8.7948882189E-01],
	[2.6125000000E+04, 1.6638124044E+01, 5.1950734523E+00, 4.0018647952E+00, 1.9901428455E+00, 8.7954614597E-01],
	[2.6130000000E+04, 1.6643199129E+01, 5.1950274001E+00, 4.0043392729E+00, 1.9908204945E+00, 8.7960344344E-01],
	[2.6135000000E+04, 1.6648274791E+01, 5.1949813572E+00, 4.0068148061E+00, 1.9914980747E+00, 8.7966071433E-01],
	[2.6140000000E+04, 1.6653351029E+01, 5.1949353234E+00, 4.0092913950E+00, 1.9921755859E+00, 8.7971795862E-01],
	[2.6145000000E+04, 1.6658427844E+01, 5.1948892989E+00, 4.0117690397E+00, 1.9928530280E+00, 8.7977517635E-01],
	[2.6150000000E+04, 1.6663505236E+01, 5.1948432836E+00, 4.0142477406E+00, 1.9935304010E+00, 8.7983236750E-01],
	[2.6155000000E+04, 1.6668583203E+01, 5.1947972774E+00, 4.0167274979E+00, 1.9942077047E+00, 8.7988953210E-01],
	[2.6160000000E+04, 1.6673661748E+01, 5.1947512805E+00, 4.0192083118E+00, 1.9948849391E+00, 8.7994667015E-01],
	[2.6165000000E+04, 1.6678740868E+01, 5.1947052928E+00, 4.0216901827E+00, 1.9955621040E+00, 8.8000378166E-01],
	[2.6170000000E+04, 1.6683820565E+01, 5.1946593143E+00, 4.0241731106E+00, 1.9962391994E+00, 8.8006086664E-01],
	[2.6175000000E+04, 1.6688900837E+01, 5.1946133449E+00, 4.0266570960E+00, 1.9969162252E+00, 8.8011792510E-01],
	[2.6180000000E+04, 1.6693981687E+01, 5.1945673848E+00, 4.0291421390E+00, 1.9975931812E+00, 8.8017495704E-01],
	[2.6185000000E+04, 1.6699063112E+01, 5.1945214338E+00, 4.0316282399E+00, 1.9982700675E+00, 8.8023196248E-01],
	[2.6190000000E+04, 1.6704145113E+01, 5.1944754920E+00, 4.0341153989E+00, 1.9989468839E+00, 8.8028894143E-01],
	[2.6195000000E+04, 1.6709227690E+01, 5.1944295594E+00, 4.0366036163E+00, 1.9996236303E+00, 8.8034589389E-01],
	[2.6200000000E+04, 1.6714310843E+01, 5.1943836360E+00, 4.0390928923E+00, 2.0003003066E+00, 8.8040281987E-01],
	[2.6205000000E+04, 1.6719394573E+01, 5.1943377217E+00, 4.0415832272E+00, 2.0009769127E+00, 8.8045971938E-01],
	[2.6210000000E+04, 1.6724478878E+01, 5.1942918166E+00, 4.0440746212E+00, 2.0016534487E+00, 8.8051659243E-01],
	[2.6215000000E+04, 1.6729563759E+01, 5.1942459206E+00, 4.0465670746E+00, 2.0023299142E+00, 8.8057343904E-01],
	[2.6220000000E+04, 1.6734649215E+01, 5.1942000339E+00, 4.0490605876E+00, 2.0030063094E+00, 8.8063025920E-01],
	[2.6225000000E+04, 1.6739735248E+01, 5.1941541562E+00, 4.0515551604E+00, 2.0036826340E+00, 8.8068705293E-01],
	[2.6230000000E+04, 1.6744821856E+01, 5.1941082878E+00, 4.0540507934E+00, 2.0043588880E+00, 8.8074382023E-01],
	[2.6235000000E+04, 1.6749909040E+01, 5.1940624284E+00, 4.0565474867E+00, 2.0050350713E+00, 8.8080056112E-01],
	[2.6240000000E+04, 1.6754996799E+01, 5.1940165782E+00, 4.0590452407E+00, 2.0057111838E+00, 8.8085727561E-01],
	[2.6245000000E+04, 1.6760085134E+01, 5.1939707372E+00, 4.0615440555E+00, 2.0063872254E+00, 8.8091396369E-01],
	[2.6250000000E+04, 1.6765174045E+01, 5.1939249053E+00, 4.0640439314E+00, 2.0070631961E+00, 8.8097062540E-01],
	[2.6255000000E+04, 1.6770263531E+01, 5.1938790825E+00, 4.0665448686E+00, 2.0077390957E+00, 8.8102726072E-01],
	[2.6260000000E+04, 1.6775353593E+01, 5.1938332689E+00, 4.0690468675E+00, 2.0084149242E+00, 8.8108386967E-01],
	[2.6265000000E+04, 1.6780444230E+01, 5.1937874643E+00, 4.0715499282E+00, 2.0090906814E+00, 8.8114045226E-01],
	[2.6270000000E+04, 1.6785535442E+01, 5.1937416689E+00, 4.0740540510E+00, 2.0097663673E+00, 8.8119700850E-01],
	[2.6275000000E+04, 1.6790627230E+01, 5.1936958827E+00, 4.0765592361E+00, 2.0104419817E+00, 8.8125353840E-01],
	[2.6280000000E+04, 1.6795719593E+01, 5.1936501055E+00, 4.0790654839E+00, 2.0111175247E+00, 8.8131004197E-01],
	[2.6285000000E+04, 1.6800812531E+01, 5.1936043374E+00, 4.0815727944E+00, 2.0117929961E+00, 8.8136651921E-01],
	[2.6290000000E+04, 1.6805906044E+01, 5.1935585785E+00, 4.0840811681E+00, 2.0124683957E+00, 8.8142297013E-01],
	[2.6295000000E+04, 1.6811000133E+01, 5.1935128287E+00, 4.0865906051E+00, 2.0131437237E+00, 8.8147939475E-01],
	[2.6300000000E+04, 1.6816094796E+01, 5.1934670879E+00, 4.0891011057E+00, 2.0138189797E+00, 8.8153579307E-01],
	[2.6305000000E+04, 1.6821190035E+01, 5.1934213563E+00, 4.0916126701E+00, 2.0144941638E+00, 8.8159216511E-01],
	[2.6310000000E+04, 1.6826285849E+01, 5.1933756337E+00, 4.0941252986E+00, 2.0151692759E+00, 8.8164851087E-01],
	[2.6315000000E+04, 1.6831382237E+01, 5.1933299203E+00, 4.0966389914E+00, 2.0158443158E+00, 8.8170483035E-01],
	[2.6320000000E+04, 1.6836479201E+01, 5.1932842159E+00, 4.0991537488E+00, 2.0165192835E+00, 8.8176112358E-01],
	[2.6325000000E+04, 1.6841595983E+01, 5.1932417623E+00, 4.1016695710E+00, 2.0171949441E+00, 8.8181739055E-01],
	[2.6330000000E+04, 1.6846716065E+01, 5.1931997743E+00, 4.1041864583E+00, 2.0178706410E+00, 8.8187363128E-01],
	[2.6335000000E+04, 1.6851836730E+01, 5.1931577947E+00, 4.1067044109E+00, 2.0185462663E+00, 8.8192984578E-01],
	[2.6340000000E+04, 1.6856957979E+01, 5.1931158234E+00, 4.1092234291E+00, 2.0192218198E+00, 8.8198603406E-01],
	[2.6345000000E+04, 1.6862079812E+01, 5.1930738603E+00, 4.1117435131E+00, 2.0198973014E+00, 8.8204219612E-01],
	[2.6350000000E+04, 1.6867202229E+01, 5.1930319056E+00, 4.1142646632E+00, 2.0205727112E+00, 8.8209833197E-01],
	[2.6355000000E+04, 1.6872325229E+01, 5.1929899592E+00, 4.1167868795E+00, 2.0212480489E+00, 8.8215444163E-01],
	[2.6360000000E+04, 1.6877448813E+01, 5.1929480211E+00, 4.1193101625E+00, 2.0219233146E+00, 8.8221052510E-01],
	[2.6365000000E+04, 1.6882572981E+01, 5.1929060912E+00, 4.1218345122E+00, 2.0225985080E+00, 8.8226658240E-01],
	[2.6370000000E+04, 1.6887697733E+01, 5.1928641697E+00, 4.1243599290E+00, 2.0232736292E+00, 8.8232261352E-01],
	[2.6375000000E+04, 1.6892823068E+01, 5.1928222564E+00, 4.1268864131E+00, 2.0239486780E+00, 8.8237861848E-01],
	[2.6380000000E+04, 1.6897948987E+01, 5.1927803515E+00, 4.1294139647E+00, 2.0246236544E+00, 8.8243459730E-01],
	[2.6385000000E+04, 1.6903075489E+01, 5.1927384548E+00, 4.1319425842E+00, 2.0252985582E+00, 8.8249054997E-01],
	[2.6390000000E+04, 1.6908202574E+01, 5.1926965664E+00, 4.1344722717E+00, 2.0259733894E+00, 8.8254647651E-01],
	[2.6395000000E+04, 1.6913330243E+01, 5.1926546862E+00, 4.1370030275E+00, 2.0266481479E+00, 8.8260237693E-01],
	[2.6400000000E+04, 1.6918458496E+01, 5.1926128144E+00, 4.1395348518E+00, 2.0273228336E+00, 8.8265825123E-01],
	[2.6405000000E+04, 1.6923587331E+01, 5.1925709507E+00, 4.1420677449E+00, 2.0279974464E+00, 8.8271409943E-01],
	[2.6410000000E+04, 1.6928716750E+01, 5.1925290954E+00, 4.1446017071E+00, 2.0286719863E+00, 8.8276992153E-01],
	[2.6415000000E+04, 1.6933846752E+01, 5.1924872483E+00, 4.1471367386E+00, 2.0293464530E+00, 8.8282571755E-01],
	[2.6420000000E+04, 1.6938977338E+01, 5.1924454095E+00, 4.1496728396E+00, 2.0300208467E+00, 8.8288148749E-01],
	[2.6425000000E+04, 1.6944108506E+01, 5.1924035789E+00, 4.1522100104E+00, 2.0306951671E+00, 8.8293723137E-01],
	[2.6430000000E+04, 1.6949240258E+01, 5.1923617566E+00, 4.1547482512E+00, 2.0313694142E+00, 8.8299294918E-01],
	[2.6435000000E+04, 1.6954372592E+01, 5.1923199425E+00, 4.1572875623E+00, 2.0320435878E+00, 8.8304864095E-01],
	[2.6440000000E+04, 1.6959505510E+01, 5.1922781367E+00, 4.1598279439E+00, 2.0327176880E+00, 8.8310430668E-01],
	[2.6445000000E+04, 1.6964639011E+01, 5.1922363391E+00, 4.1623693963E+00, 2.0333917146E+00, 8.8315994638E-01],
	[2.6450000000E+04, 1.6969773094E+01, 5.1921945498E+00, 4.1649119198E+00, 2.0340656676E+00, 8.8321556005E-01],
	[2.6455000000E+04, 1.6974907760E+01, 5.1921527687E+00, 4.1674555145E+00, 2.0347395467E+00, 8.8327114772E-01],
	[2.6460000000E+04, 1.6980043010E+01, 5.1921109958E+00, 4.1700001807E+00, 2.0354133521E+00, 8.8332670938E-01],
	[2.6465000000E+04, 1.6985178842E+01, 5.1920692311E+00, 4.1725459187E+00, 2.0360870835E+00, 8.8338224505E-01],
	[2.6470000000E+04, 1.6990315256E+01, 5.1920274747E+00, 4.1750927288E+00, 2.0367607409E+00, 8.8343775473E-01],
	[2.6475000000E+04, 1.6995452254E+01, 5.1919857265E+00, 4.1776406111E+00, 2.0374343242E+00, 8.8349323845E-01],
	[2.6480000000E+04, 1.7000589834E+01, 5.1919439865E+00, 4.1801895659E+00, 2.0381078334E+00, 8.8354869619E-01],
	[2.6485000000E+04, 1.7005727997E+01, 5.1919022548E+00, 4.1827395934E+00, 2.0387812682E+00, 8.8360412798E-01],
	[2.6490000000E+04, 1.7010866742E+01, 5.1918605312E+00, 4.1852906940E+00, 2.0394546288E+00, 8.8365953383E-01],
	[2.6495000000E+04, 1.7016006070E+01, 5.1918188159E+00, 4.1878428679E+00, 2.0401279148E+00, 8.8371491373E-01],
	[2.6500000000E+04, 1.7021145980E+01, 5.1917771087E+00, 4.1903961153E+00, 2.0408011264E+00, 8.8377026771E-01],
	[2.6505000000E+04, 1.7026286473E+01, 5.1917354098E+00, 4.1929504364E+00, 2.0414742633E+00, 8.8382559577E-01],
	[2.6510000000E+04, 1.7031427548E+01, 5.1916937191E+00, 4.1955058315E+00, 2.0421473256E+00, 8.8388089793E-01],
	[2.6515000000E+04, 1.7036569205E+01, 5.1916520365E+00, 4.1980623009E+00, 2.0428203130E+00, 8.8393617418E-01],
	[2.6520000000E+04, 1.7041711445E+01, 5.1916103622E+00, 4.2006198448E+00, 2.0434932256E+00, 8.8399142454E-01],
	[2.6525000000E+04, 1.7046854267E+01, 5.1915686960E+00, 4.2031784634E+00, 2.0441660633E+00, 8.8404664902E-01],
	[2.6530000000E+04, 1.7051997671E+01, 5.1915270381E+00, 4.2057381571E+00, 2.0448388259E+00, 8.8410184763E-01],
	[2.6535000000E+04, 1.7057141658E+01, 5.1914853883E+00, 4.2082989260E+00, 2.0455115134E+00, 8.8415702038E-01],
	[2.6540000000E+04, 1.7062286226E+01, 5.1914437467E+00, 4.2108607703E+00, 2.0461841256E+00, 8.8421216728E-01],
	[2.6545000000E+04, 1.7067431377E+01, 5.1914021133E+00, 4.2134236905E+00, 2.0468566626E+00, 8.8426728833E-01],
	[2.6550000000E+04, 1.7072577110E+01, 5.1913604880E+00, 4.2159876866E+00, 2.0475291242E+00, 8.8432238355E-01],
	[2.6555000000E+04, 1.7077723424E+01, 5.1913188710E+00, 4.2185527590E+00, 2.0482015104E+00, 8.8437745294E-01],
	[2.6560000000E+04, 1.7082870321E+01, 5.1912772621E+00, 4.2211189078E+00, 2.0488738210E+00, 8.8443249652E-01],
	[2.6565000000E+04, 1.7088017800E+01, 5.1912356613E+00, 4.2236861334E+00, 2.0495460560E+00, 8.8448751430E-01],
	[2.6570000000E+04, 1.7093165860E+01, 5.1911940687E+00, 4.2262544360E+00, 2.0502182152E+00, 8.8454250628E-01],
	[2.6575000000E+04, 1.7098314502E+01, 5.1911524843E+00, 4.2288238159E+00, 2.0508902987E+00, 8.8459747247E-01],
	[2.6580000000E+04, 1.7103463726E+01, 5.1911109081E+00, 4.2313942732E+00, 2.0515623063E+00, 8.8465241288E-01],
	[2.6585000000E+04, 1.7108613532E+01, 5.1910693400E+00, 4.2339658082E+00, 2.0522342379E+00, 8.8470732753E-01],
	[2.6590000000E+04, 1.7113763919E+01, 5.1910277800E+00, 4.2365384213E+00, 2.0529060934E+00, 8.8476221642E-01],
	[2.6595000000E+04, 1.7118914888E+01, 5.1909862282E+00, 4.2391121125E+00, 2.0535778729E+00, 8.8481707956E-01],
	[2.6600000000E+04, 1.7124066439E+01, 5.1909446845E+00, 4.2416868823E+00, 2.0542495761E+00, 8.8487191696E-01],
	[2.6605000000E+04, 1.7129218571E+01, 5.1909031490E+00, 4.2442627307E+00, 2.0549212030E+00, 8.8492672863E-01],
	[2.6610000000E+04, 1.7134371285E+01, 5.1908616216E+00, 4.2468396582E+00, 2.0555927535E+00, 8.8498151458E-01],
	[2.6615000000E+04, 1.7139524580E+01, 5.1908201024E+00, 4.2494176648E+00, 2.0562642275E+00, 8.8503627482E-01],
	[2.6620000000E+04, 1.7144678457E+01, 5.1907785912E+00, 4.2519967510E+00, 2.0569356250E+00, 8.8509100936E-01],
	[2.6625000000E+04, 1.7149832915E+01, 5.1907370883E+00, 4.2545769169E+00, 2.0576069459E+00, 8.8514571821E-01],
	[2.6630000000E+04, 1.7154987954E+01, 5.1906955934E+00, 4.2571581627E+00, 2.0582781900E+00, 8.8520040138E-01],
	[2.6635000000E+04, 1.7160143575E+01, 5.1906541066E+00, 4.2597404888E+00, 2.0589493573E+00, 8.8525505887E-01],
	[2.6640000000E+04, 1.7165299777E+01, 5.1906126280E+00, 4.2623238953E+00, 2.0596204477E+00, 8.8530969070E-01],
	[2.6645000000E+04, 1.7170456560E+01, 5.1905711575E+00, 4.2649083825E+00, 2.0602914612E+00, 8.8536429687E-01],
	[2.6650000000E+04, 1.7175613924E+01, 5.1905296951E+00, 4.2674939508E+00, 2.0609623976E+00, 8.8541887741E-01],
	[2.6655000000E+04, 1.7180771870E+01, 5.1904882408E+00, 4.2700806002E+00, 2.0616332569E+00, 8.8547343230E-01],
	[2.6660000000E+04, 1.7185930396E+01, 5.1904467946E+00, 4.2726683311E+00, 2.0623040389E+00, 8.8552796158E-01],
	[2.6665000000E+04, 1.7191089504E+01, 5.1904053565E+00, 4.2752571437E+00, 2.0629747437E+00, 8.8558246523E-01],
	[2.6670000000E+04, 1.7196249193E+01, 5.1903639266E+00, 4.2778470382E+00, 2.0636453710E+00, 8.8563694328E-01],
	[2.6675000000E+04, 1.7201409462E+01, 5.1903225047E+00, 4.2804380150E+00, 2.0643159209E+00, 8.8569139574E-01],
	[2.6680000000E+04, 1.7206570312E+01, 5.1902810909E+00, 4.2830300743E+00, 2.0649863933E+00, 8.8574582261E-01],
	[2.6685000000E+04, 1.7211731744E+01, 5.1902396852E+00, 4.2856232162E+00, 2.0656567880E+00, 8.8580022390E-01],
	[2.6690000000E+04, 1.7216893756E+01, 5.1901982876E+00, 4.2882174411E+00, 2.0663271050E+00, 8.8585459962E-01],
	[2.6695000000E+04, 1.7222056349E+01, 5.1901568980E+00, 4.2908127492E+00, 2.0669973441E+00, 8.8590894978E-01],
	[2.6700000000E+04, 1.7227219522E+01, 5.1901155166E+00, 4.2934091407E+00, 2.0676675055E+00, 8.8596327440E-01],
	[2.6705000000E+04, 1.7232383277E+01, 5.1900741432E+00, 4.2960066160E+00, 2.0683375888E+00, 8.8601757348E-01],
	[2.6710000000E+04, 1.7237547611E+01, 5.1900327779E+00, 4.2986051752E+00, 2.0690075941E+00, 8.8607184703E-01],
	[2.6715000000E+04, 1.7242712527E+01, 5.1899914207E+00, 4.3012048186E+00, 2.0696775213E+00, 8.8612609506E-01],
	[2.6720000000E+04, 1.7247878023E+01, 5.1899500716E+00, 4.3038055465E+00, 2.0703473702E+00, 8.8618031758E-01],
	[2.6725000000E+04, 1.7253044100E+01, 5.1899087305E+00, 4.3064073590E+00, 2.0710171409E+00, 8.8623451459E-01],
	[2.6730000000E+04, 1.7258210757E+01, 5.1898673975E+00, 4.3090102565E+00, 2.0716868332E+00, 8.8628868612E-01],
	[2.6735000000E+04, 1.7263377994E+01, 5.1898260725E+00, 4.3116142392E+00, 2.0723564470E+00, 8.8634283217E-01],
	[2.6740000000E+04, 1.7268545812E+01, 5.1897847556E+00, 4.3142193074E+00, 2.0730259823E+00, 8.8639695274E-01],
	[2.6745000000E+04, 1.7273717077E+01, 5.1897439234E+00, 4.3168254612E+00, 2.0736955564E+00, 8.8645104786E-01],
	[2.6750000000E+04, 1.7278907923E+01, 5.1897062571E+00, 4.3194327010E+00, 2.0743658302E+00, 8.8650511752E-01],
	[2.6755000000E+04, 1.7284099358E+01, 5.1896685981E+00, 4.3220410269E+00, 2.0750360261E+00, 8.8655916173E-01],
	[2.6760000000E+04, 1.7289291382E+01, 5.1896309465E+00, 4.3246504393E+00, 2.0757061439E+00, 8.8661318052E-01],
	[2.6765000000E+04, 1.7294483995E+01, 5.1895933021E+00, 4.3272609384E+00, 2.0763761836E+00, 8.8666717388E-01],
	[2.6770000000E+04, 1.7299677197E+01, 5.1895556650E+00, 4.3298725245E+00, 2.0770461451E+00, 8.8672114183E-01],
	[2.6775000000E+04, 1.7304870989E+01, 5.1895180353E+00, 4.3324851977E+00, 2.0777160283E+00, 8.8677508437E-01],
	[2.6780000000E+04, 1.7310065369E+01, 5.1894804128E+00, 4.3350989583E+00, 2.0783858331E+00, 8.8682900152E-01],
	[2.6785000000E+04, 1.7315260339E+01, 5.1894427976E+00, 4.3377138067E+00, 2.0790555594E+00, 8.8688289329E-01],
	[2.6790000000E+04, 1.7320455897E+01, 5.1894051898E+00, 4.3403297430E+00, 2.0797252072E+00, 8.8693675968E-01],
	[2.6795000000E+04, 1.7325652044E+01, 5.1893675892E+00, 4.3429467674E+00, 2.0803947763E+00, 8.8699060070E-01],
	[2.6800000000E+04, 1.7330848781E+01, 5.1893299959E+00, 4.3455648803E+00, 2.0810642668E+00, 8.8704441637E-01],
	[2.6805000000E+04, 1.7336046106E+01, 5.1892924099E+00, 4.3481840819E+00, 2.0817336785E+00, 8.8709820670E-01],
	[2.6810000000E+04, 1.7341244020E+01, 5.1892548312E+00, 4.3508043724E+00, 2.0824030113E+00, 8.8715197169E-01],
	[2.6815000000E+04, 1.7346442523E+01, 5.1892172597E+00, 4.3534257520E+00, 2.0830722652E+00, 8.8720571135E-01],
	[2.6820000000E+04, 1.7351641614E+01, 5.1891796955E+00, 4.3560482211E+00, 2.0837414400E+00, 8.8725942569E-01],
	[2.6825000000E+04, 1.7356841294E+01, 5.1891421386E+00, 4.3586717799E+00, 2.0844105357E+00, 8.8731311473E-01],
	[2.6830000000E+04, 1.7362041563E+01, 5.1891045890E+00, 4.3612964286E+00, 2.0850795523E+00, 8.8736677847E-01],
	[2.6835000000E+04, 1.7367242420E+01, 5.1890670467E+00, 4.3639221675E+00, 2.0857484896E+00, 8.8742041692E-01],
	[2.6840000000E+04, 1.7372443866E+01, 5.1890295116E+00, 4.3665489968E+00, 2.0864173475E+00, 8.8747403009E-01],
	[2.6845000000E+04, 1.7377645901E+01, 5.1889919837E+00, 4.3691769168E+00, 2.0870861260E+00, 8.8752761800E-01],
	[2.6850000000E+04, 1.7382848523E+01, 5.1889544632E+00, 4.3718059277E+00, 2.0877548250E+00, 8.8758118065E-01],
	[2.6855000000E+04, 1.7388051735E+01, 5.1889169499E+00, 4.3744360297E+00, 2.0884234444E+00, 8.8763471805E-01],
	[2.6860000000E+04, 1.7393255534E+01, 5.1888794438E+00, 4.3770672232E+00, 2.0890919841E+00, 8.8768823021E-01],
	[2.6865000000E+04, 1.7398459922E+01, 5.1888419450E+00, 4.3796995084E+00, 2.0897604441E+00, 8.8774171714E-01],
	[2.6870000000E+04, 1.7403664899E+01, 5.1888044535E+00, 4.3823328854E+00, 2.0904288243E+00, 8.8779517885E-01],
	[2.6875000000E+04, 1.7408870463E+01, 5.1887669692E+00, 4.3849673547E+00, 2.0910971245E+00, 8.8784861535E-01],
	[2.6880000000E+04, 1.7414076616E+01, 5.1887294921E+00, 4.3876029163E+00, 2.0917653448E+00, 8.8790202665E-01],
	[2.6885000000E+04, 1.7419283357E+01, 5.1886920223E+00, 4.3902395707E+00, 2.0924334850E+00, 8.8795541276E-01],
	[2.6890000000E+04, 1.7424490686E+01, 5.1886545597E+00, 4.3928773179E+00, 2.0931015451E+00, 8.8800877370E-01],
	[2.6895000000E+04, 1.7429698603E+01, 5.1886171043E+00, 4.3955161583E+00, 2.0937695249E+00, 8.8806210946E-01],
	[2.6900000000E+04, 1.7434907108E+01, 5.1885796562E+00, 4.3981560921E+00, 2.0944374244E+00, 8.8811542006E-01],
	[2.6905000000E+04, 1.7440116201E+01, 5.1885422153E+00, 4.4007971196E+00, 2.0951052436E+00, 8.8816870551E-01],
	[2.6910000000E+04, 1.7445325882E+01, 5.1885047817E+00, 4.4034392410E+00, 2.0957729823E+00, 8.8822196581E-01],
	[2.6915000000E+04, 1.7450536151E+01, 5.1884673553E+00, 4.4060824565E+00, 2.0964406404E+00, 8.8827520099E-01],
	[2.6920000000E+04, 1.7455747007E+01, 5.1884299361E+00, 4.4087267665E+00, 2.0971082179E+00, 8.8832841104E-01],
	[2.6925000000E+04, 1.7460958452E+01, 5.1883925241E+00, 4.4113721711E+00, 2.0977757148E+00, 8.8838159599E-01],
	[2.6930000000E+04, 1.7466170484E+01, 5.1883551193E+00, 4.4140186707E+00, 2.0984431308E+00, 8.8843475583E-01],
	[2.6935000000E+04, 1.7471383104E+01, 5.1883177217E+00, 4.4166662653E+00, 2.0991104660E+00, 8.8848789058E-01],
	[2.6940000000E+04, 1.7476596312E+01, 5.1882803314E+00, 4.4193149554E+00, 2.0997777203E+00, 8.8854100024E-01],
	[2.6945000000E+04, 1.7481810108E+01, 5.1882429482E+00, 4.4219647412E+00, 2.1004448935E+00, 8.8859408484E-01],
	[2.6950000000E+04, 1.7487024491E+01, 5.1882055723E+00, 4.4246156229E+00, 2.1011119857E+00, 8.8864714437E-01],
	[2.6955000000E+04, 1.7492239461E+01, 5.1881682036E+00, 4.4272676007E+00, 2.1017789966E+00, 8.8870017885E-01],
	[2.6960000000E+04, 1.7497455019E+01, 5.1881308420E+00, 4.4299206749E+00, 2.1024459264E+00, 8.8875318828E-01],
	[2.6965000000E+04, 1.7502671165E+01, 5.1880934877E+00, 4.4325748458E+00, 2.1031127748E+00, 8.8880617268E-01],
	[2.6970000000E+04, 1.7507887898E+01, 5.1880561406E+00, 4.4352301135E+00, 2.1037795418E+00, 8.8885913206E-01],
	[2.6975000000E+04, 1.7513105218E+01, 5.1880188006E+00, 4.4378864785E+00, 2.1044462273E+00, 8.8891206643E-01],
	[2.6980000000E+04, 1.7518323126E+01, 5.1879814679E+00, 4.4405439408E+00, 2.1051128312E+00, 8.8896497579E-01],
	[2.6985000000E+04, 1.7523541621E+01, 5.1879441423E+00, 4.4432025008E+00, 2.1057793536E+00, 8.8901786016E-01],
	[2.6990000000E+04, 1.7528760703E+01, 5.1879068239E+00, 4.4458621586E+00, 2.1064457942E+00, 8.8907071954E-01],
	[2.6995000000E+04, 1.7533980373E+01, 5.1878695127E+00, 4.4485229147E+00, 2.1071121530E+00, 8.8912355395E-01],
	[2.7000000000E+04, 1.7539200629E+01, 5.1878322087E+00, 4.4511847691E+00, 2.1077784299E+00, 8.8917636339E-01],
	[2.7005000000E+04, 1.7544421473E+01, 5.1877949118E+00, 4.4538477222E+00, 2.1084446249E+00, 8.8922914788E-01],
	[2.7010000000E+04, 1.7549642904E+01, 5.1877576221E+00, 4.4565117742E+00, 2.1091107378E+00, 8.8928190743E-01],
	[2.7015000000E+04, 1.7554864922E+01, 5.1877203396E+00, 4.4591769253E+00, 2.1097767687E+00, 8.8933464204E-01],
	[2.7020000000E+04, 1.7560087527E+01, 5.1876830643E+00, 4.4618431758E+00, 2.1104427173E+00, 8.8938735173E-01],
	[2.7025000000E+04, 1.7565310719E+01, 5.1876457961E+00, 4.4645105260E+00, 2.1111085837E+00, 8.8944003650E-01],
	[2.7030000000E+04, 1.7570534498E+01, 5.1876085351E+00, 4.4671789760E+00, 2.1117743678E+00, 8.8949269637E-01],
	[2.7035000000E+04, 1.7575758863E+01, 5.1875712812E+00, 4.4698485262E+00, 2.1124400695E+00, 8.8954533134E-01],
	[2.7040000000E+04, 1.7580983816E+01, 5.1875340345E+00, 4.4725191769E+00, 2.1131056886E+00, 8.8959794142E-01],
	[2.7045000000E+04, 1.7586209355E+01, 5.1874967950E+00, 4.4751909281E+00, 2.1137712252E+00, 8.8965052664E-01],
	[2.7050000000E+04, 1.7591435481E+01, 5.1874595626E+00, 4.4778637802E+00, 2.1144366792E+00, 8.8970308698E-01],
	[2.7055000000E+04, 1.7596662194E+01, 5.1874223373E+00, 4.4805377335E+00, 2.1151020504E+00, 8.8975562247E-01],
	[2.7060000000E+04, 1.7601889493E+01, 5.1873851192E+00, 4.4832127882E+00, 2.1157673388E+00, 8.8980813312E-01],
	[2.7065000000E+04, 1.7607117379E+01, 5.1873479083E+00, 4.4858889445E+00, 2.1164325444E+00, 8.8986061893E-01],
	[2.7070000000E+04, 1.7612345852E+01, 5.1873107045E+00, 4.4885662027E+00, 2.1170976670E+00, 8.8991307991E-01],
	[2.7075000000E+04, 1.7617574911E+01, 5.1872735078E+00, 4.4912445631E+00, 2.1177627066E+00, 8.8996551608E-01],
	[2.7080000000E+04, 1.7622804557E+01, 5.1872363183E+00, 4.4939240258E+00, 2.1184276630E+00, 8.9001792744E-01],
	[2.7085000000E+04, 1.7628034789E+01, 5.1871991358E+00, 4.4966045912E+00, 2.1190925363E+00, 8.9007031401E-01],
	[2.7090000000E+04, 1.7633265607E+01, 5.1871619606E+00, 4.4992862595E+00, 2.1197573264E+00, 8.9012267579E-01],
	[2.7095000000E+04, 1.7638497012E+01, 5.1871247924E+00, 4.5019690309E+00, 2.1204220331E+00, 8.9017501279E-01],
	[2.7100000000E+04, 1.7643729003E+01, 5.1870876314E+00, 4.5046529057E+00, 2.1210866564E+00, 8.9022732503E-01],
	[2.7105000000E+04, 1.7648961581E+01, 5.1870504775E+00, 4.5073378842E+00, 2.1217511962E+00, 8.9027961251E-01],
	[2.7110000000E+04, 1.7654194744E+01, 5.1870133307E+00, 4.5100239665E+00, 2.1224156524E+00, 8.9033187524E-01],
	[2.7115000000E+04, 1.7659428494E+01, 5.1869761910E+00, 4.5127111530E+00, 2.1230800250E+00, 8.9038411324E-01],
	[2.7120000000E+04, 1.7664662830E+01, 5.1869390585E+00, 4.5153994439E+00, 2.1237443139E+00, 8.9043632652E-01],
	[2.7125000000E+04, 1.7669897753E+01, 5.1869019330E+00, 4.5180888394E+00, 2.1244085190E+00, 8.9048851507E-01],
	[2.7130000000E+04, 1.7675133261E+01, 5.1868648147E+00, 4.5207793397E+00, 2.1250726403E+00, 8.9054067892E-01],
	[2.7135000000E+04, 1.7680369355E+01, 5.1868277035E+00, 4.5234709453E+00, 2.1257366776E+00, 8.9059281808E-01],
	[2.7140000000E+04, 1.7685606035E+01, 5.1867905993E+00, 4.5261636562E+00, 2.1264006309E+00, 8.9064493254E-01],
	[2.7145000000E+04, 1.7690843301E+01, 5.1867535023E+00, 4.5288574727E+00, 2.1270645000E+00, 8.9069702233E-01],
	[2.7150000000E+04, 1.7696081153E+01, 5.1867164124E+00, 4.5315523952E+00, 2.1277282851E+00, 8.9074908745E-01],
	[2.7155000000E+04, 1.7701319591E+01, 5.1866793295E+00, 4.5342484237E+00, 2.1283919859E+00, 8.9080112791E-01],
	[2.7160000000E+04, 1.7706558615E+01, 5.1866422538E+00, 4.5369455587E+00, 2.1290556023E+00, 8.9085314371E-01],
	[2.7165000000E+04, 1.7711798224E+01, 5.1866051851E+00, 4.5396438003E+00, 2.1297191344E+00, 8.9090513488E-01],
	[2.7170000000E+04, 1.7717038420E+01, 5.1865681236E+00, 4.5423431487E+00, 2.1303825820E+00, 8.9095710141E-01],
	[2.7175000000E+04, 1.7722279671E+01, 5.1865311464E+00, 4.5450436044E+00, 2.1310459649E+00, 8.9100904331E-01],
	[2.7180000000E+04, 1.7727542808E+01, 5.1864976705E+00, 4.5477451674E+00, 2.1317101616E+00, 8.9106096060E-01],
	[2.7185000000E+04, 1.7732806539E+01, 5.1864642011E+00, 4.5504478380E+00, 2.1323742743E+00, 8.9111285329E-01],
	[2.7190000000E+04, 1.7738070865E+01, 5.1864307380E+00, 4.5531516165E+00, 2.1330383030E+00, 8.9116472137E-01],
	[2.7195000000E+04, 1.7743335785E+01, 5.1863972813E+00, 4.5558565031E+00, 2.1337022477E+00, 8.9121656487E-01],
	[2.7200000000E+04, 1.7748601299E+01, 5.1863638310E+00, 4.5585624982E+00, 2.1343661083E+00, 8.9126838378E-01],
	[2.7205000000E+04, 1.7753867408E+01, 5.1863303870E+00, 4.5612696018E+00, 2.1350298846E+00, 8.9132017813E-01],
	[2.7210000000E+04, 1.7759134111E+01, 5.1862969494E+00, 4.5639778144E+00, 2.1356935768E+00, 8.9137194791E-01],
	[2.7215000000E+04, 1.7764401408E+01, 5.1862635181E+00, 4.5666871361E+00, 2.1363571845E+00, 8.9142369315E-01],
	[2.7220000000E+04, 1.7769669300E+01, 5.1862300932E+00, 4.5693975671E+00, 2.1370207079E+00, 8.9147541383E-01],
	[2.7225000000E+04, 1.7774937786E+01, 5.1861966747E+00, 4.5721091078E+00, 2.1376841467E+00, 8.9152710999E-01],
	[2.7230000000E+04, 1.7780206865E+01, 5.1861632625E+00, 4.5748217584E+00, 2.1383475010E+00, 8.9157878161E-01],
	[2.7235000000E+04, 1.7785476539E+01, 5.1861298567E+00, 4.5775355191E+00, 2.1390107707E+00, 8.9163042872E-01],
	[2.7240000000E+04, 1.7790746807E+01, 5.1860964572E+00, 4.5802503902E+00, 2.1396739556E+00, 8.9168205132E-01],
	[2.7245000000E+04, 1.7796017669E+01, 5.1860630640E+00, 4.5829663719E+00, 2.1403370558E+00, 8.9173364943E-01],
	[2.7250000000E+04, 1.7801289125E+01, 5.1860296772E+00, 4.5856834646E+00, 2.1410000711E+00, 8.9178522304E-01],
	[2.7255000000E+04, 1.7806561174E+01, 5.1859962968E+00, 4.5884016683E+00, 2.1416630015E+00, 8.9183677218E-01],
	[2.7260000000E+04, 1.7811833818E+01, 5.1859629226E+00, 4.5911209834E+00, 2.1423258468E+00, 8.9188829684E-01],
	[2.7265000000E+04, 1.7817107055E+01, 5.1859295549E+00, 4.5938414102E+00, 2.1429886071E+00, 8.9193979704E-01],
	[2.7270000000E+04, 1.7822380887E+01, 5.1858961934E+00, 4.5965629488E+00, 2.1436512822E+00, 8.9199127278E-01],
	[2.7275000000E+04, 1.7827655311E+01, 5.1858628383E+00, 4.5992855996E+00, 2.1443138721E+00, 8.9204272408E-01],
	[2.7280000000E+04, 1.7832930330E+01, 5.1858294895E+00, 4.6020093627E+00, 2.1449763767E+00, 8.9209415095E-01],
	[2.7285000000E+04, 1.7838205942E+01, 5.1857961470E+00, 4.6047342385E+00, 2.1456387959E+00, 8.9214555339E-01],
	[2.7290000000E+04, 1.7843482148E+01, 5.1857628109E+00, 4.6074602272E+00, 2.1463011297E+00, 8.9219693141E-01],
	[2.7295000000E+04, 1.7848758948E+01, 5.1857294810E+00, 4.6101873290E+00, 2.1469633779E+00, 8.9224828503E-01],
	[2.7300000000E+04, 1.7854036341E+01, 5.1856961575E+00, 4.6129155442E+00, 2.1476255405E+00, 8.9229961425E-01],
	[2.7305000000E+04, 1.7859314327E+01, 5.1856628403E+00, 4.6156448730E+00, 2.1482876175E+00, 8.9235091907E-01],
	[2.7310000000E+04, 1.7864592907E+01, 5.1856295295E+00, 4.6183753157E+00, 2.1489496087E+00, 8.9240219952E-01],
	[2.7315000000E+04, 1.7869872080E+01, 5.1855962249E+00, 4.6211068725E+00, 2.1496115142E+00, 8.9245345559E-01],
	[2.7320000000E+04, 1.7875151847E+01, 5.1855629266E+00, 4.6238395437E+00, 2.1502733337E+00, 8.9250468730E-01],
	[2.7325000000E+04, 1.7880432207E+01, 5.1855296347E+00, 4.6265733296E+00, 2.1509350673E+00, 8.9255589466E-01],
	[2.7330000000E+04, 1.7885713160E+01, 5.1854963491E+00, 4.6293082303E+00, 2.1515967148E+00, 8.9260707768E-01],
	[2.7335000000E+04, 1.7890994707E+01, 5.1854630697E+00, 4.6320442461E+00, 2.1522582763E+00, 8.9265823636E-01],
	[2.7340000000E+04, 1.7896276846E+01, 5.1854297967E+00, 4.6347813774E+00, 2.1529197515E+00, 8.9270937071E-01],
	[2.7345000000E+04, 1.7901559579E+01, 5.1853965299E+00, 4.6375196243E+00, 2.1535811405E+00, 8.9276048075E-01],
	[2.7350000000E+04, 1.7906842905E+01, 5.1853632695E+00, 4.6402589870E+00, 2.1542424432E+00, 8.9281156648E-01],
	[2.7355000000E+04, 1.7912126824E+01, 5.1853300153E+00, 4.6429994659E+00, 2.1549036595E+00, 8.9286262791E-01],
	[2.7360000000E+04, 1.7917411336E+01, 5.1852967675E+00, 4.6457410612E+00, 2.1555647894E+00, 8.9291366505E-01],
	[2.7365000000E+04, 1.7922696441E+01, 5.1852635259E+00, 4.6484837731E+00, 2.1562258326E+00, 8.9296467791E-01],
	[2.7370000000E+04, 1.7927982139E+01, 5.1852302906E+00, 4.6512276019E+00, 2.1568867893E+00, 8.9301566650E-01],
	[2.7375000000E+04, 1.7933268430E+01, 5.1851970616E+00, 4.6539725478E+00, 2.1575476593E+00, 8.9306663083E-01],
	[2.7380000000E+04, 1.7938555314E+01, 5.1851638389E+00, 4.6567186111E+00, 2.1582084426E+00, 8.9311757091E-01],
	[2.7385000000E+04, 1.7943842790E+01, 5.1851306225E+00, 4.6594657920E+00, 2.1588691390E+00, 8.9316848674E-01],
	[2.7390000000E+04, 1.7949130860E+01, 5.1850974123E+00, 4.6622146827E+00, 2.1595298755E+00, 8.9321937834E-01],
	[2.7395000000E+04, 1.7954419522E+01, 5.1850642084E+00, 4.6649648592E+00, 2.1601905609E+00, 8.9327024572E-01],
	[2.7400000000E+04, 1.7959708776E+01, 5.1850310108E+00, 4.6677161549E+00, 2.1608511592E+00, 8.9332108888E-01],
	[2.7405000000E+04, 1.7964998624E+01, 5.1849978194E+00, 4.6704685700E+00, 2.1615116703E+00, 8.9337190783E-01],
	[2.7410000000E+04, 1.7970289064E+01, 5.1849646344E+00, 4.6732221048E+00, 2.1621720943E+00, 8.9342270258E-01],
	[2.7415000000E+04, 1.7975580096E+01, 5.1849314555E+00, 4.6759767595E+00, 2.1628324310E+00, 8.9347347315E-01],
	[2.7420000000E+04, 1.7980871721E+01, 5.1848982830E+00, 4.6787325344E+00, 2.1634926804E+00, 8.9352421954E-01],
	[2.7425000000E+04, 1.7986163939E+01, 5.1848651167E+00, 4.6814894297E+00, 2.1641528424E+00, 8.9357494176E-01],
	[2.7430000000E+04, 1.7991456749E+01, 5.1848319567E+00, 4.6842474458E+00, 2.1648129168E+00, 8.9362563982E-01],
	[2.7435000000E+04, 1.7996750151E+01, 5.1847988029E+00, 4.6870065827E+00, 2.1654729038E+00, 8.9367631372E-01],
	[2.7440000000E+04, 1.8002044146E+01, 5.1847656554E+00, 4.6897668409E+00, 2.1661328031E+00, 8.9372696349E-01],
	[2.7445000000E+04, 1.8007338733E+01, 5.1847325141E+00, 4.6925282205E+00, 2.1667926147E+00, 8.9377758912E-01],
	[2.7450000000E+04, 1.8012633912E+01, 5.1846993791E+00, 4.6952907217E+00, 2.1674523385E+00, 8.9382819063E-01],
	[2.7455000000E+04, 1.8017929684E+01, 5.1846662503E+00, 4.6980543449E+00, 2.1681119745E+00, 8.9387876803E-01],
	[2.7460000000E+04, 1.8023226048E+01, 5.1846331278E+00, 4.7008190903E+00, 2.1687715226E+00, 8.9392932132E-01],
	[2.7465000000E+04, 1.8028523004E+01, 5.1846000115E+00, 4.7035849582E+00, 2.1694309827E+00, 8.9397985052E-01],
	[2.7470000000E+04, 1.8033820552E+01, 5.1845669014E+00, 4.7063519487E+00, 2.1700903548E+00, 8.9403035563E-01],
	[2.7475000000E+04, 1.8039118692E+01, 5.1845337976E+00, 4.7091200622E+00, 2.1707496387E+00, 8.9408083666E-01],
	[2.7480000000E+04, 1.8044417424E+01, 5.1845007000E+00, 4.7118892989E+00, 2.1714088345E+00, 8.9413129362E-01],
	[2.7485000000E+04, 1.8049716748E+01, 5.1844676087E+00, 4.7146596590E+00, 2.1720679420E+00, 8.9418172653E-01],
	[2.7490000000E+04, 1.8055016664E+01, 5.1844345236E+00, 4.7174311428E+00, 2.1727269612E+00, 8.9423213539E-01],
	[2.7495000000E+04, 1.8060317172E+01, 5.1844014447E+00, 4.7202037505E+00, 2.1733858919E+00, 8.9428252021E-01],
	[2.7500000000E+04, 1.8065618272E+01, 5.1843683720E+00, 4.7229774825E+00, 2.1740447342E+00, 8.9433288099E-01],
	[2.7505000000E+04, 1.8070919963E+01, 5.1843353056E+00, 4.7257523389E+00, 2.1747034880E+00, 8.9438321776E-01],
	[2.7510000000E+04, 1.8076222247E+01, 5.1843022454E+00, 4.7285283200E+00, 2.1753621532E+00, 8.9443353052E-01],
	[2.7515000000E+04, 1.8081525122E+01, 5.1842691914E+00, 4.7313054260E+00, 2.1760207296E+00, 8.9448381927E-01],
	[2.7520000000E+04, 1.8086828589E+01, 5.1842361436E+00, 4.7340836573E+00, 2.1766792174E+00, 8.9453408403E-01],
	[2.7525000000E+04, 1.8092132647E+01, 5.1842031020E+00, 4.7368630139E+00, 2.1773376163E+00, 8.9458432480E-01],
	[2.7530000000E+04, 1.8097437297E+01, 5.1841700667E+00, 4.7396434963E+00, 2.1779959263E+00, 8.9463454160E-01],
	[2.7535000000E+04, 1.8102742539E+01, 5.1841370375E+00, 4.7424251047E+00, 2.1786541474E+00, 8.9468473444E-01],
	[2.7540000000E+04, 1.8108048372E+01, 5.1841040146E+00, 4.7452078392E+00, 2.1793122794E+00, 8.9473490332E-01],
	[2.7545000000E+04, 1.8113354797E+01, 5.1840709979E+00, 4.7479917002E+00, 2.1799703223E+00, 8.9478504825E-01],
	[2.7550000000E+04, 1.8118661813E+01, 5.1840379873E+00, 4.7507766879E+00, 2.1806282761E+00, 8.9483516925E-01],
	[2.7555000000E+04, 1.8123969420E+01, 5.1840049830E+00, 4.7535628026E+00, 2.1812861406E+00, 8.9488526632E-01],
	[2.7560000000E+04, 1.8129277619E+01, 5.1839719849E+00, 4.7563500445E+00, 2.1819439159E+00, 8.9493533947E-01],
	[2.7565000000E+04, 1.8134586409E+01, 5.1839389929E+00, 4.7591384138E+00, 2.1826016017E+00, 8.9498538871E-01],
	[2.7570000000E+04, 1.8139895791E+01, 5.1839060072E+00, 4.7619279108E+00, 2.1832591981E+00, 8.9503541405E-01],
	[2.7575000000E+04, 1.8145205763E+01, 5.1838730277E+00, 4.7647185358E+00, 2.1839167051E+00, 8.9508541551E-01],
	[2.7580000000E+04, 1.8150516327E+01, 5.1838400543E+00, 4.7675102890E+00, 2.1845741224E+00, 8.9513539308E-01],
	[2.7585000000E+04, 1.8155827482E+01, 5.1838070871E+00, 4.7703031707E+00, 2.1852314501E+00, 8.9518534678E-01],
	[2.7590000000E+04, 1.8161139228E+01, 5.1837741261E+00, 4.7730971811E+00, 2.1858886880E+00, 8.9523527661E-01],
	[2.7595000000E+04, 1.8166451566E+01, 5.1837411713E+00, 4.7758923204E+00, 2.1865458362E+00, 8.9528518260E-01],
	[2.7600000000E+04, 1.8171764494E+01, 5.1837082227E+00, 4.7786885890E+00, 2.1872028945E+00, 8.9533506474E-01],
	[2.7605000000E+04, 1.8177078013E+01, 5.1836752803E+00, 4.7814859870E+00, 2.1878598629E+00, 8.9538492305E-01],
	[2.7610000000E+04, 1.8182392123E+01, 5.1836423440E+00, 4.7842845148E+00, 2.1885167413E+00, 8.9543475753E-01],
	[2.7615000000E+04, 1.8187718220E+01, 5.1836112598E+00, 4.7870841725E+00, 2.1891740240E+00, 8.9548456820E-01],
	[2.7620000000E+04, 1.8193055189E+01, 5.1835818454E+00, 4.7898849604E+00, 2.1898316628E+00, 8.9553435506E-01],
	[2.7625000000E+04, 1.8198392758E+01, 5.1835524365E+00, 4.7926868788E+00, 2.1904892122E+00, 8.9558411813E-01],
	[2.7630000000E+04, 1.8203730926E+01, 5.1835230331E+00, 4.7954899279E+00, 2.1911466722E+00, 8.9563385741E-01],
	[2.7635000000E+04, 1.8209069694E+01, 5.1834936352E+00, 4.7982941080E+00, 2.1918040426E+00, 8.9568357291E-01],
	[2.7640000000E+04, 1.8214409061E+01, 5.1834642427E+00, 4.8010994193E+00, 2.1924613233E+00, 8.9573326465E-01],
	[2.7645000000E+04, 1.8219749028E+01, 5.1834348558E+00, 4.8039058621E+00, 2.1931185144E+00, 8.9578293262E-01],
	[2.7650000000E+04, 1.8225089594E+01, 5.1834054743E+00, 4.8067134366E+00, 2.1937756157E+00, 8.9583257685E-01],
	[2.7655000000E+04, 1.8230430759E+01, 5.1833760983E+00, 4.8095221431E+00, 2.1944326272E+00, 8.9588219734E-01],
	[2.7660000000E+04, 1.8235772524E+01, 5.1833467278E+00, 4.8123319818E+00, 2.1950895488E+00, 8.9593179410E-01],
	[2.7665000000E+04, 1.8241114888E+01, 5.1833173628E+00, 4.8151429530E+00, 2.1957463805E+00, 8.9598136713E-01],
	[2.7670000000E+04, 1.8246457851E+01, 5.1832880032E+00, 4.8179550569E+00, 2.1964031221E+00, 8.9603091646E-01],
	[2.7675000000E+04, 1.8251801413E+01, 5.1832586491E+00, 4.8207682938E+00, 2.1970597737E+00, 8.9608044208E-01],
	[2.7680000000E+04, 1.8257145575E+01, 5.1832293005E+00, 4.8235826640E+00, 2.1977163351E+00, 8.9612994402E-01],
	[2.7685000000E+04, 1.8262490335E+01, 5.1831999573E+00, 4.8263981676E+00, 2.1983728062E+00, 8.9617942226E-01],
	[2.7690000000E+04, 1.8267835695E+01, 5.1831706196E+00, 4.8292148050E+00, 2.1990291871E+00, 8.9622887684E-01],
	[2.7695000000E+04, 1.8273181653E+01, 5.1831412874E+00, 4.8320325763E+00, 2.1996854776E+00, 8.9627830775E-01],
	[2.7700000000E+04, 1.8278528211E+01, 5.1831119606E+00, 4.8348514819E+00, 2.2003416776E+00, 8.9632771501E-01],
	[2.7705000000E+04, 1.8283875367E+01, 5.1830826393E+00, 4.8376715220E+00, 2.2009977872E+00, 8.9637709862E-01],
	[2.7710000000E+04, 1.8289223123E+01, 5.1830533235E+00, 4.8404926968E+00, 2.2016538062E+00, 8.9642645860E-01],
	[2.7715000000E+04, 1.8294571477E+01, 5.1830240131E+00, 4.8433150066E+00, 2.2023097346E+00, 8.9647579495E-01],
	[2.7720000000E+04, 1.8299920430E+01, 5.1829947081E+00, 4.8461384516E+00, 2.2029655723E+00, 8.9652510768E-01],
	[2.7725000000E+04, 1.8305269982E+01, 5.1829654086E+00, 4.8489630321E+00, 2.2036213193E+00, 8.9657439681E-01],
	[2.7730000000E+04, 1.8310620133E+01, 5.1829361146E+00, 4.8517887484E+00, 2.2042769754E+00, 8.9662366234E-01],
	[2.7735000000E+04, 1.8315970882E+01, 5.1829068260E+00, 4.8546156007E+00, 2.2049325406E+00, 8.9667290428E-01],
	[2.7740000000E+04, 1.8321322230E+01, 5.1828775429E+00, 4.8574435892E+00, 2.2055880148E+00, 8.9672212265E-01],
	[2.7745000000E+04, 1.8326674176E+01, 5.1828482652E+00, 4.8602727142E+00, 2.2062433980E+00, 8.9677131744E-01],
	[2.7750000000E+04, 1.8332026721E+01, 5.1828189929E+00, 4.8631029760E+00, 2.2068986901E+00, 8.9682048868E-01],
	[2.7755000000E+04, 1.8337379865E+01, 5.1827897261E+00, 4.8659343748E+00, 2.2075538911E+00, 8.9686963636E-01],
	[2.7760000000E+04, 1.8342733607E+01, 5.1827604647E+00, 4.8687669108E+00, 2.2082090008E+00, 8.9691876051E-01],
	[2.7765000000E+04, 1.8348087947E+01, 5.1827312087E+00, 4.8716005843E+00, 2.2088640193E+00, 8.9696786112E-01],
	[2.7770000000E+04, 1.8353442886E+01, 5.1827019582E+00, 4.8744353956E+00, 2.2095189464E+00, 8.9701693822E-01],
	[2.7775000000E+04, 1.8358798424E+01, 5.1826727131E+00, 4.8772713449E+00, 2.2101737820E+00, 8.9706599180E-01],
	[2.7780000000E+04, 1.8364154559E+01, 5.1826434734E+00, 4.8801084325E+00, 2.2108285262E+00, 8.9711502188E-01],
	[2.7785000000E+04, 1.8369511293E+01, 5.1826142392E+00, 4.8829466585E+00, 2.2114831788E+00, 8.9716402847E-01],
	[2.7790000000E+04, 1.8374868625E+01, 5.1825850104E+00, 4.8857860234E+00, 2.2121377398E+00, 8.9721301157E-01],
	[2.7795000000E+04, 1.8380226555E+01, 5.1825557870E+00, 4.8886265272E+00, 2.2127922091E+00, 8.9726197120E-01],
	[2.7800000000E+04, 1.8385585084E+01, 5.1825265690E+00, 4.8914681703E+00, 2.2134465866E+00, 8.9731090737E-01],
	[2.7805000000E+04, 1.8390944210E+01, 5.1824973565E+00, 4.8943109529E+00, 2.2141008723E+00, 8.9735982008E-01],
	[2.7810000000E+04, 1.8396303935E+01, 5.1824681494E+00, 4.8971548753E+00, 2.2147550662E+00, 8.9740870935E-01],
	[2.7815000000E+04, 1.8401664258E+01, 5.1824389476E+00, 4.8999999377E+00, 2.2154091680E+00, 8.9745757518E-01],
	[2.7820000000E+04, 1.8407025178E+01, 5.1824097513E+00, 4.9028461403E+00, 2.2160631779E+00, 8.9750641759E-01],
	[2.7825000000E+04, 1.8412386697E+01, 5.1823805605E+00, 4.9056934835E+00, 2.2167170957E+00, 8.9755523658E-01],
	[2.7830000000E+04, 1.8417748814E+01, 5.1823513750E+00, 4.9085419675E+00, 2.2173709214E+00, 8.9760403216E-01],
	[2.7835000000E+04, 1.8423111528E+01, 5.1823221949E+00, 4.9113915925E+00, 2.2180246548E+00, 8.9765280435E-01],
	[2.7840000000E+04, 1.8428474840E+01, 5.1822930202E+00, 4.9142423587E+00, 2.2186782959E+00, 8.9770155315E-01],
	[2.7845000000E+04, 1.8433838750E+01, 5.1822638510E+00, 4.9170942665E+00, 2.2193318448E+00, 8.9775027857E-01],
	[2.7850000000E+04, 1.8439203258E+01, 5.1822346871E+00, 4.9199473161E+00, 2.2199853012E+00, 8.9779898062E-01],
	[2.7855000000E+04, 1.8444568363E+01, 5.1822055286E+00, 4.9228015077E+00, 2.2206386651E+00, 8.9784765932E-01],
	[2.7860000000E+04, 1.8449934067E+01, 5.1821763756E+00, 4.9256568415E+00, 2.2212919365E+00, 8.9789631466E-01],
	[2.7865000000E+04, 1.8455300367E+01, 5.1821472279E+00, 4.9285133180E+00, 2.2219451153E+00, 8.9794494667E-01],
	[2.7870000000E+04, 1.8460667266E+01, 5.1821180856E+00, 4.9313709371E+00, 2.2225982015E+00, 8.9799355534E-01],
	[2.7875000000E+04, 1.8466034761E+01, 5.1820889488E+00, 4.9342296994E+00, 2.2232511949E+00, 8.9804214070E-01],
	[2.7880000000E+04, 1.8471402855E+01, 5.1820598173E+00, 4.9370896049E+00, 2.2239040955E+00, 8.9809070275E-01],
	[2.7885000000E+04, 1.8476771546E+01, 5.1820306912E+00, 4.9399506540E+00, 2.2245569033E+00, 8.9813924149E-01],
	[2.7890000000E+04, 1.8482140834E+01, 5.1820015704E+00, 4.9428128468E+00, 2.2252096181E+00, 8.9818775694E-01],
	[2.7895000000E+04, 1.8487510720E+01, 5.1819724551E+00, 4.9456761837E+00, 2.2258622400E+00, 8.9823624911E-01],
	[2.7900000000E+04, 1.8492881203E+01, 5.1819433451E+00, 4.9485406649E+00, 2.2265147688E+00, 8.9828471801E-01],
	[2.7905000000E+04, 1.8498252283E+01, 5.1819142406E+00, 4.9514062906E+00, 2.2271672045E+00, 8.9833316365E-01],
	[2.7910000000E+04, 1.8503623960E+01, 5.1818851414E+00, 4.9542730611E+00, 2.2278195470E+00, 8.9838158603E-01],
	[2.7915000000E+04, 1.8508996235E+01, 5.1818560475E+00, 4.9571409767E+00, 2.2284717963E+00, 8.9842998517E-01],
	[2.7920000000E+04, 1.8514369107E+01, 5.1818269591E+00, 4.9600100376E+00, 2.2291239522E+00, 8.9847836108E-01],
	[2.7925000000E+04, 1.8519742576E+01, 5.1817978760E+00, 4.9628802440E+00, 2.2297760148E+00, 8.9852671376E-01],
	[2.7930000000E+04, 1.8525116642E+01, 5.1817687983E+00, 4.9657515963E+00, 2.2304279840E+00, 8.9857504323E-01],
	[2.7935000000E+04, 1.8530491306E+01, 5.1817397260E+00, 4.9686240946E+00, 2.2310798597E+00, 8.9862334950E-01],
	[2.7940000000E+04, 1.8535866566E+01, 5.1817106590E+00, 4.9714977392E+00, 2.2317316418E+00, 8.9867163257E-01],
	[2.7945000000E+04, 1.8541242423E+01, 5.1816815974E+00, 4.9743725303E+00, 2.2323833303E+00, 8.9871989245E-01],
	[2.7950000000E+04, 1.8546618877E+01, 5.1816525411E+00, 4.9772484683E+00, 2.2330349251E+00, 8.9876812916E-01],
	[2.7955000000E+04, 1.8551995928E+01, 5.1816234903E+00, 4.9801255533E+00, 2.2336864261E+00, 8.9881634270E-01],
	[2.7960000000E+04, 1.8557373576E+01, 5.1815944447E+00, 4.9830037857E+00, 2.2343378334E+00, 8.9886453308E-01],
	[2.7965000000E+04, 1.8562751821E+01, 5.1815654046E+00, 4.9858831656E+00, 2.2349891467E+00, 8.9891270032E-01],
	[2.7970000000E+04, 1.8568130662E+01, 5.1815363698E+00, 4.9887636933E+00, 2.2356403662E+00, 8.9896084442E-01],
	[2.7975000000E+04, 1.8573510101E+01, 5.1815073403E+00, 4.9916453691E+00, 2.2362914916E+00, 8.9900896540E-01],
	[2.7980000000E+04, 1.8578890136E+01, 5.1814783162E+00, 4.9945281933E+00, 2.2369425229E+00, 8.9905706325E-01],
	[2.7985000000E+04, 1.8584270767E+01, 5.1814492974E+00, 4.9974121660E+00, 2.2375934602E+00, 8.9910513800E-01],
	[2.7990000000E+04, 1.8589651995E+01, 5.1814202840E+00, 5.0002972875E+00, 2.2382443032E+00, 8.9915318965E-01],
	[2.7995000000E+04, 1.8595033820E+01, 5.1813912759E+00, 5.0031835581E+00, 2.2388950520E+00, 8.9920121821E-01],
	[2.8000000000E+04, 1.8600416241E+01, 5.1813622732E+00, 5.0060709780E+00, 2.2395457065E+00, 8.9924922369E-01],
	[2.8005000000E+04, 1.8605799259E+01, 5.1813332758E+00, 5.0089595475E+00, 2.2401962666E+00, 8.9929720610E-01],
	[2.8010000000E+04, 1.8611182873E+01, 5.1813042838E+00, 5.0118492669E+00, 2.2408467322E+00, 8.9934516546E-01],
	[2.8015000000E+04, 1.8616567084E+01, 5.1812752970E+00, 5.0147401363E+00, 2.2414971034E+00, 8.9939310176E-01],
	[2.8020000000E+04, 1.8621951891E+01, 5.1812463157E+00, 5.0176321561E+00, 2.2421473799E+00, 8.9944101502E-01],
	[2.8025000000E+04, 1.8627337294E+01, 5.1812173396E+00, 5.0205253264E+00, 2.2427975619E+00, 8.9948890525E-01],
	[2.8030000000E+04, 1.8632723294E+01, 5.1811883689E+00, 5.0234196476E+00, 2.2434476492E+00, 8.9953677246E-01],
	[2.8035000000E+04, 1.8638109890E+01, 5.1811594035E+00, 5.0263151199E+00, 2.2440976417E+00, 8.9958461666E-01],
	[2.8040000000E+04, 1.8643497082E+01, 5.1811304435E+00, 5.0292117435E+00, 2.2447475394E+00, 8.9963243786E-01],
	[2.8045000000E+04, 1.8648884870E+01, 5.1811014887E+00, 5.0321095188E+00, 2.2453973422E+00, 8.9968023606E-01],
	[2.8050000000E+04, 1.8654273254E+01, 5.1810725393E+00, 5.0350084458E+00, 2.2460470501E+00, 8.9972801129E-01],
	[2.8055000000E+04, 1.8659662235E+01, 5.1810435952E+00, 5.0379085250E+00, 2.2466966630E+00, 8.9977576354E-01],
	[2.8060000000E+04, 1.8665065220E+01, 5.1810168006E+00, 5.0408097565E+00, 2.2473467786E+00, 8.9982349283E-01],
	[2.8065000000E+04, 1.8670476971E+01, 5.1809913162E+00, 5.0437121407E+00, 2.2479971637E+00, 8.9987119916E-01],
	[2.8070000000E+04, 1.8675889326E+01, 5.1809658365E+00, 5.0466156776E+00, 2.2486474544E+00, 8.9991888255E-01],
	[2.8075000000E+04, 1.8681302287E+01, 5.1809403615E+00, 5.0495203677E+00, 2.2492976507E+00, 8.9996654301E-01],
	[2.8080000000E+04, 1.8686715852E+01, 5.1809148911E+00, 5.0524262112E+00, 2.2499477523E+00, 9.0001418055E-01],
	[2.8085000000E+04, 1.8692130021E+01, 5.1808894253E+00, 5.0553332082E+00, 2.2505977594E+00, 9.0006179517E-01],
	[2.8090000000E+04, 1.8697544795E+01, 5.1808639643E+00, 5.0582413592E+00, 2.2512476718E+00, 9.0010938688E-01],
	[2.8095000000E+04, 1.8702960173E+01, 5.1808385078E+00, 5.0611506642E+00, 2.2518974895E+00, 9.0015695571E-01],
	[2.8100000000E+04, 1.8708376156E+01, 5.1808130561E+00, 5.0640611236E+00, 2.2525472124E+00, 9.0020450164E-01],
	[2.8105000000E+04, 1.8713792743E+01, 5.1807876090E+00, 5.0669727377E+00, 2.2531968404E+00, 9.0025202470E-01],
	[2.8110000000E+04, 1.8719209934E+01, 5.1807621665E+00, 5.0698855066E+00, 2.2538463736E+00, 9.0029952490E-01],
	[2.8115000000E+04, 1.8724627729E+01, 5.1807367287E+00, 5.0727994306E+00, 2.2544958118E+00, 9.0034700224E-01],
	[2.8120000000E+04, 1.8730046129E+01, 5.1807112955E+00, 5.0757145100E+00, 2.2551451549E+00, 9.0039445673E-01],
	[2.8125000000E+04, 1.8735465133E+01, 5.1806858670E+00, 5.0786307450E+00, 2.2557944030E+00, 9.0044188839E-01],
	[2.8130000000E+04, 1.8740884741E+01, 5.1806604431E+00, 5.0815481359E+00, 2.2564435559E+00, 9.0048929722E-01],
	[2.8135000000E+04, 1.8746304953E+01, 5.1806350239E+00, 5.0844666830E+00, 2.2570926136E+00, 9.0053668324E-01],
	[2.8140000000E+04, 1.8751725769E+01, 5.1806096093E+00, 5.0873863864E+00, 2.2577415760E+00, 9.0058404645E-01],
	[2.8145000000E+04, 1.8757147189E+01, 5.1805841994E+00, 5.0903072464E+00, 2.2583904431E+00, 9.0063138686E-01],
	[2.8150000000E+04, 1.8762569213E+01, 5.1805587941E+00, 5.0932292634E+00, 2.2590392148E+00, 9.0067870448E-01],
	[2.8155000000E+04, 1.8767991841E+01, 5.1805333934E+00, 5.0961524375E+00, 2.2596878910E+00, 9.0072599932E-01],
	[2.8160000000E+04, 1.8773415072E+01, 5.1805079974E+00, 5.0990767690E+00, 2.2603364717E+00, 9.0077327140E-01],
	[2.8165000000E+04, 1.8778838908E+01, 5.1804826060E+00, 5.1020022581E+00, 2.2609849569E+00, 9.0082052075E-01],
	[2.8170000000E+04, 1.8784263348E+01, 5.1804572192E+00, 5.1049289051E+00, 2.2616333464E+00, 9.0086774739E-01],
	[2.8175000000E+04, 1.8789688391E+01, 5.1804318371E+00, 5.1078567103E+00, 2.2622816402E+00, 9.0091495133E-01],
	[2.8180000000E+04, 1.8795114038E+01, 5.1804064596E+00, 5.1107856739E+00, 2.2629298383E+00, 9.0096213258E-01],
	[2.8185000000E+04, 1.8800540288E+01, 5.1803810867E+00, 5.1137157961E+00, 2.2635779405E+00, 9.0100929115E-01],
	[2.8190000000E+04, 1.8805967143E+01, 5.1803557184E+00, 5.1166470772E+00, 2.2642259469E+00, 9.0105642705E-01],
	[2.8195000000E+04, 1.8811394601E+01, 5.1803303548E+00, 5.1195795175E+00, 2.2648738574E+00, 9.0110354029E-01],
	[2.8200000000E+04, 1.8816822662E+01, 5.1803049958E+00, 5.1225131172E+00, 2.2655216718E+00, 9.0115063086E-01],
	[2.8205000000E+04, 1.8822251327E+01, 5.1802796414E+00, 5.1254478766E+00, 2.2661693902E+00, 9.0119769879E-01],
	[2.8210000000E+04, 1.8827680595E+01, 5.1802542916E+00, 5.1283837959E+00, 2.2668170125E+00, 9.0124474408E-01],
	[2.8215000000E+04, 1.8833110467E+01, 5.1802289464E+00, 5.1313208753E+00, 2.2674645386E+00, 9.0129176674E-01],
	[2.8220000000E+04, 1.8838540943E+01, 5.1802036059E+00, 5.1342591152E+00, 2.2681119685E+00, 9.0133876677E-01],
	[2.8225000000E+04, 1.8843972021E+01, 5.1801782699E+00, 5.1371985157E+00, 2.2687593020E+00, 9.0138574419E-01],
	[2.8230000000E+04, 1.8849403703E+01, 5.1801529386E+00, 5.1401390772E+00, 2.2694065393E+00, 9.0143269901E-01],
	[2.8235000000E+04, 1.8854835989E+01, 5.1801276119E+00, 5.1430807998E+00, 2.2700536801E+00, 9.0147963122E-01],
	[2.8240000000E+04, 1.8860268877E+01, 5.1801022898E+00, 5.1460236839E+00, 2.2707007244E+00, 9.0152654085E-01],
	[2.8245000000E+04, 1.8865702369E+01, 5.1800769723E+00, 5.1489677296E+00, 2.2713476723E+00, 9.0157342790E-01],
	[2.8250000000E+04, 1.8871136464E+01, 5.1800516594E+00, 5.1519129373E+00, 2.2719945235E+00, 9.0162029237E-01],
	[2.8255000000E+04, 1.8876571162E+01, 5.1800263511E+00, 5.1548593072E+00, 2.2726412781E+00, 9.0166713428E-01],
	[2.8260000000E+04, 1.8882006463E+01, 5.1800010475E+00, 5.1578068395E+00, 2.2732879360E+00, 9.0171395363E-01],
	[2.8265000000E+04, 1.8887442367E+01, 5.1799757484E+00, 5.1607555345E+00, 2.2739344971E+00, 9.0176075044E-01],
	[2.8270000000E+04, 1.8892878874E+01, 5.1799504539E+00, 5.1637053924E+00, 2.2745809614E+00, 9.0180752470E-01],
	[2.8275000000E+04, 1.8898315984E+01, 5.1799251640E+00, 5.1666564135E+00, 2.2752273288E+00, 9.0185427644E-01],
	[2.8280000000E+04, 1.8903753697E+01, 5.1798998787E+00, 5.1696085981E+00, 2.2758735993E+00, 9.0190100565E-01],
	[2.8285000000E+04, 1.8909192013E+01, 5.1798745980E+00, 5.1725619464E+00, 2.2765197727E+00, 9.0194771235E-01],
	[2.8290000000E+04, 1.8914630932E+01, 5.1798493219E+00, 5.1755164586E+00, 2.2771658491E+00, 9.0199439654E-01],
	[2.8295000000E+04, 1.8920070453E+01, 5.1798240504E+00, 5.1784721350E+00, 2.2778118284E+00, 9.0204105824E-01],
	[2.8300000000E+04, 1.8925510578E+01, 5.1797987835E+00, 5.1814289759E+00, 2.2784577106E+00, 9.0208769745E-01],
	[2.8305000000E+04, 1.8930951305E+01, 5.1797735211E+00, 5.1843869815E+00, 2.2791034955E+00, 9.0213431418E-01],
	[2.8310000000E+04, 1.8936392635E+01, 5.1797482634E+00, 5.1873461521E+00, 2.2797491831E+00, 9.0218090843E-01],
	[2.8315000000E+04, 1.8941834567E+01, 5.1797230102E+00, 5.1903064879E+00, 2.2803947733E+00, 9.0222748023E-01],
	[2.8320000000E+04, 1.8947277102E+01, 5.1796977616E+00, 5.1932679891E+00, 2.2810402662E+00, 9.0227402956E-01],
	[2.8325000000E+04, 1.8952720240E+01, 5.1796725176E+00, 5.1962306561E+00, 2.2816856615E+00, 9.0232055646E-01],
	[2.8330000000E+04, 1.8958163980E+01, 5.1796472781E+00, 5.1991944890E+00, 2.2823309594E+00, 9.0236706091E-01],
	[2.8335000000E+04, 1.8963608322E+01, 5.1796220433E+00, 5.2021594881E+00, 2.2829761597E+00, 9.0241354294E-01],
	[2.8340000000E+04, 1.8969053267E+01, 5.1795968130E+00, 5.2051256538E+00, 2.2836212623E+00, 9.0246000254E-01],
	[2.8345000000E+04, 1.8974498815E+01, 5.1795715873E+00, 5.2080929861E+00, 2.2842662673E+00, 9.0250643974E-01],
	[2.8350000000E+04, 1.8979944965E+01, 5.1795463662E+00, 5.2110614855E+00, 2.2849111745E+00, 9.0255285452E-01],
	[2.8355000000E+04, 1.8985391717E+01, 5.1795211496E+00, 5.2140311521E+00, 2.2855559839E+00, 9.0259924692E-01],
	[2.8360000000E+04, 1.8990839071E+01, 5.1794959376E+00, 5.2170019861E+00, 2.2862006954E+00, 9.0264561693E-01],
	[2.8365000000E+04, 1.8996287028E+01, 5.1794707302E+00, 5.2199739879E+00, 2.2868453090E+00, 9.0269196456E-01],
	[2.8370000000E+04, 1.9001735587E+01, 5.1794455273E+00, 5.2229471577E+00, 2.2874898246E+00, 9.0273828981E-01],
	[2.8375000000E+04, 1.9007184748E+01, 5.1794203290E+00, 5.2259214958E+00, 2.2881342421E+00, 9.0278459271E-01],
	[2.8380000000E+04, 1.9012634511E+01, 5.1793951353E+00, 5.2288970023E+00, 2.2887785616E+00, 9.0283087326E-01],
	[2.8385000000E+04, 1.9018084876E+01, 5.1793699461E+00, 5.2318736776E+00, 2.2894227829E+00, 9.0287713146E-01],
	[2.8390000000E+04, 1.9023535844E+01, 5.1793447615E+00, 5.2348515219E+00, 2.2900669060E+00, 9.0292336733E-01],
	[2.8395000000E+04, 1.9028987413E+01, 5.1793195814E+00, 5.2378305354E+00, 2.2907109309E+00, 9.0296958087E-01],
	[2.8400000000E+04, 1.9034439584E+01, 5.1792944059E+00, 5.2408107185E+00, 2.2913548574E+00, 9.0301577209E-01],
	[2.8405000000E+04, 1.9039892358E+01, 5.1792692350E+00, 5.2437920713E+00, 2.2919986855E+00, 9.0306194100E-01],
	[2.8410000000E+04, 1.9045345733E+01, 5.1792440686E+00, 5.2467745941E+00, 2.2926424152E+00, 9.0310808761E-01],
	[2.8415000000E+04, 1.9050799710E+01, 5.1792189068E+00, 5.2497582872E+00, 2.2932860464E+00, 9.0315421193E-01],
	[2.8420000000E+04, 1.9056254289E+01, 5.1791937495E+00, 5.2527431508E+00, 2.2939295791E+00, 9.0320031396E-01],
	[2.8425000000E+04, 1.9061709469E+01, 5.1791685967E+00, 5.2557291852E+00, 2.2945730131E+00, 9.0324639372E-01],
	[2.8430000000E+04, 1.9067165252E+01, 5.1791434485E+00, 5.2587163906E+00, 2.2952163485E+00, 9.0329245121E-01],
	[2.8435000000E+04, 1.9072621636E+01, 5.1791183049E+00, 5.2617047672E+00, 2.2958595851E+00, 9.0333848644E-01],
	[2.8440000000E+04, 1.9078078622E+01, 5.1790931657E+00, 5.2646943154E+00, 2.2965027230E+00, 9.0338449942E-01],
	[2.8445000000E+04, 1.9083536209E+01, 5.1790680312E+00, 5.2676850354E+00, 2.2971457620E+00, 9.0343049016E-01],
	[2.8450000000E+04, 1.9088994398E+01, 5.1790429011E+00, 5.2706769274E+00, 2.2977887022E+00, 9.0347645867E-01],
	[2.8455000000E+04, 1.9094453188E+01, 5.1790177756E+00, 5.2736699917E+00, 2.2984315434E+00, 9.0352240496E-01],
	[2.8460000000E+04, 1.9099912580E+01, 5.1789926547E+00, 5.2766642286E+00, 2.2990742856E+00, 9.0356832903E-01],
	[2.8465000000E+04, 1.9105372574E+01, 5.1789675383E+00, 5.2796596382E+00, 2.2997169288E+00, 9.0361423089E-01],
	[2.8470000000E+04, 1.9110833168E+01, 5.1789424264E+00, 5.2826562209E+00, 2.3003594728E+00, 9.0366011056E-01],
	[2.8475000000E+04, 1.9116294365E+01, 5.1789173190E+00, 5.2856539769E+00, 2.3010019177E+00, 9.0370596803E-01],
	[2.8480000000E+04, 1.9121756162E+01, 5.1788922162E+00, 5.2886529064E+00, 2.3016442633E+00, 9.0375180333E-01],
	[2.8485000000E+04, 1.9127218561E+01, 5.1788671179E+00, 5.2916530098E+00, 2.3022865097E+00, 9.0379761645E-01],
	[2.8490000000E+04, 1.9132681561E+01, 5.1788420241E+00, 5.2946542872E+00, 2.3029286567E+00, 9.0384340741E-01],
	[2.8495000000E+04, 1.9138145163E+01, 5.1788169349E+00, 5.2976567389E+00, 2.3035707044E+00, 9.0388917621E-01],
	[2.8500000000E+04, 1.9143609365E+01, 5.1787918501E+00, 5.3006603651E+00, 2.3042126526E+00, 9.0393492287E-01],
	[2.8505000000E+04, 1.9149074169E+01, 5.1787667699E+00, 5.3036651662E+00, 2.3048545012E+00, 9.0398064739E-01],
	[2.8510000000E+04, 1.9154545714E+01, 5.1787426640E+00, 5.3066711423E+00, 2.3054965315E+00, 9.0402634978E-01],
	[2.8515000000E+04, 1.9160033195E+01, 5.1787209829E+00, 5.3096782938E+00, 2.3061391645E+00, 9.0407203006E-01],
	[2.8520000000E+04, 1.9165521285E+01, 5.1786993057E+00, 5.3126866208E+00, 2.3067816986E+00, 9.0411768822E-01],
	[2.8525000000E+04, 1.9171009984E+01, 5.1786776325E+00, 5.3156961237E+00, 2.3074241337E+00, 9.0416332427E-01],
	[2.8530000000E+04, 1.9176499293E+01, 5.1786559631E+00, 5.3187068027E+00, 2.3080664698E+00, 9.0420893824E-01],
	[2.8535000000E+04, 1.9181989212E+01, 5.1786342976E+00, 5.3217186579E+00, 2.3087087068E+00, 9.0425453011E-01],
	[2.8540000000E+04, 1.9187479740E+01, 5.1786126359E+00, 5.3247316898E+00, 2.3093508446E+00, 9.0430009991E-01],
	[2.8545000000E+04, 1.9192970877E+01, 5.1785909782E+00, 5.3277458985E+00, 2.3099928833E+00, 9.0434564765E-01],
	[2.8550000000E+04, 1.9198462623E+01, 5.1785693243E+00, 5.3307612843E+00, 2.3106348227E+00, 9.0439117332E-01],
	[2.8555000000E+04, 1.9203954979E+01, 5.1785476744E+00, 5.3337778474E+00, 2.3112766629E+00, 9.0443667694E-01],
	[2.8560000000E+04, 1.9209447944E+01, 5.1785260283E+00, 5.3367955881E+00, 2.3119184036E+00, 9.0448215852E-01],
	[2.8565000000E+04, 1.9214941518E+01, 5.1785043861E+00, 5.3398145067E+00, 2.3125600450E+00, 9.0452761807E-01],
	[2.8570000000E+04, 1.9220435702E+01, 5.1784827478E+00, 5.3428346034E+00, 2.3132015869E+00, 9.0457305559E-01],
	[2.8575000000E+04, 1.9225930494E+01, 5.1784611133E+00, 5.3458558784E+00, 2.3138430292E+00, 9.0461847110E-01],
	[2.8580000000E+04, 1.9231425895E+01, 5.1784394827E+00, 5.3488783321E+00, 2.3144843720E+00, 9.0466386460E-01],
	[2.8585000000E+04, 1.9236921906E+01, 5.1784178560E+00, 5.3519019646E+00, 2.3151256152E+00, 9.0470923610E-01],
	[2.8590000000E+04, 1.9242418526E+01, 5.1783962332E+00, 5.3549267762E+00, 2.3157667587E+00, 9.0475458562E-01],
	[2.8595000000E+04, 1.9247915754E+01, 5.1783746142E+00, 5.3579527672E+00, 2.3164078024E+00, 9.0479991315E-01],
	[2.8600000000E+04, 1.9253413591E+01, 5.1783529992E+00, 5.3609799378E+00, 2.3170487464E+00, 9.0484521871E-01],
	[2.8605000000E+04, 1.9258912038E+01, 5.1783313879E+00, 5.3640082883E+00, 2.3176895905E+00, 9.0489050230E-01],
	[2.8610000000E+04, 1.9264411093E+01, 5.1783097806E+00, 5.3670378189E+00, 2.3183303347E+00, 9.0493576394E-01],
	[2.8615000000E+04, 1.9269910757E+01, 5.1782881771E+00, 5.3700685299E+00, 2.3189709790E+00, 9.0498100364E-01],
	[2.8620000000E+04, 1.9275411029E+01, 5.1782665775E+00, 5.3731004215E+00, 2.3196115232E+00, 9.0502622140E-01],
	[2.8625000000E+04, 1.9280911911E+01, 5.1782449817E+00, 5.3761334940E+00, 2.3202519674E+00, 9.0507141723E-01],
	[2.8630000000E+04, 1.9286413401E+01, 5.1782233898E+00, 5.3791677476E+00, 2.3208923115E+00, 9.0511659114E-01],
	[2.8635000000E+04, 1.9291915499E+01, 5.1782018018E+00, 5.3822031827E+00, 2.3215325554E+00, 9.0516174314E-01],
	[2.8640000000E+04, 1.9297418207E+01, 5.1781802176E+00, 5.3852397994E+00, 2.3221726991E+00, 9.0520687324E-01],
	[2.8645000000E+04, 1.9302921523E+01, 5.1781586373E+00, 5.3882775979E+00, 2.3228127425E+00, 9.0525198144E-01],
	[2.8650000000E+04, 1.9308425447E+01, 5.1781370608E+00, 5.3913165787E+00, 2.3234526856E+00, 9.0529706776E-01],
	[2.8655000000E+04, 1.9313929980E+01, 5.1781154882E+00, 5.3943567418E+00, 2.3240925283E+00, 9.0534213220E-01],
	[2.8660000000E+04, 1.9319435121E+01, 5.1780939195E+00, 5.3973980876E+00, 2.3247322706E+00, 9.0538717478E-01],
	[2.8665000000E+04, 1.9324940871E+01, 5.1780723546E+00, 5.4004406163E+00, 2.3253719124E+00, 9.0543219550E-01],
	[2.8670000000E+04, 1.9330447229E+01, 5.1780507935E+00, 5.4034843281E+00, 2.3260114536E+00, 9.0547719437E-01],
	[2.8675000000E+04, 1.9335954195E+01, 5.1780292363E+00, 5.4065292234E+00, 2.3266508943E+00, 9.0552217140E-01],
	[2.8680000000E+04, 1.9341461770E+01, 5.1780076830E+00, 5.4095753024E+00, 2.3272902343E+00, 9.0556712660E-01],
	[2.8685000000E+04, 1.9346969953E+01, 5.1779861335E+00, 5.4126225653E+00, 2.3279294735E+00, 9.0561205997E-01],
	[2.8690000000E+04, 1.9352478744E+01, 5.1779645878E+00, 5.4156710123E+00, 2.3285686121E+00, 9.0565697154E-01],
	[2.8695000000E+04, 1.9357988144E+01, 5.1779430460E+00, 5.4187206438E+00, 2.3292076498E+00, 9.0570186129E-01],
	[2.8700000000E+04, 1.9363498151E+01, 5.1779215080E+00, 5.4217714599E+00, 2.3298465867E+00, 9.0574672925E-01],
	[2.8705000000E+04, 1.9369008767E+01, 5.1778999739E+00, 5.4248234610E+00, 2.3304854227E+00, 9.0579157542E-01],
	[2.8710000000E+04, 1.9374519990E+01, 5.1778784436E+00, 5.4278766473E+00, 2.3311241577E+00, 9.0583639982E-01],
	[2.8715000000E+04, 1.9380031822E+01, 5.1778569172E+00, 5.4309310191E+00, 2.3317627917E+00, 9.0588120244E-01],
	[2.8720000000E+04, 1.9385544262E+01, 5.1778353946E+00, 5.4339865765E+00, 2.3324013246E+00, 9.0592598331E-01],
	[2.8725000000E+04, 1.9391057309E+01, 5.1778138758E+00, 5.4370433199E+00, 2.3330397564E+00, 9.0597074242E-01],
	[2.8730000000E+04, 1.9396570965E+01, 5.1777923608E+00, 5.4401012494E+00, 2.3336780870E+00, 9.0601547978E-01],
	[2.8735000000E+04, 1.9402085228E+01, 5.1777708497E+00, 5.4431603655E+00, 2.3343163164E+00, 9.0606019542E-01],
	[2.8740000000E+04, 1.9407600099E+01, 5.1777493424E+00, 5.4462206682E+00, 2.3349544445E+00, 9.0610488932E-01],
	[2.8745000000E+04, 1.9413115578E+01, 5.1777278390E+00, 5.4492821579E+00, 2.3355924713E+00, 9.0614956152E-01],
	[2.8750000000E+04, 1.9418631665E+01, 5.1777063394E+00, 5.4523448348E+00, 2.3362303967E+00, 9.0619421200E-01],
	[2.8755000000E+04, 1.9424148359E+01, 5.1776848436E+00, 5.4554086992E+00, 2.3368682207E+00, 9.0623884078E-01],
	[2.8760000000E+04, 1.9429665661E+01, 5.1776633516E+00, 5.4584737513E+00, 2.3375059432E+00, 9.0628344788E-01],
	[2.8765000000E+04, 1.9435183571E+01, 5.1776418635E+00, 5.4615399914E+00, 2.3381435642E+00, 9.0632803329E-01],
	[2.8770000000E+04, 1.9440702088E+01, 5.1776203792E+00, 5.4646074197E+00, 2.3387810835E+00, 9.0637259703E-01],
	[2.8775000000E+04, 1.9446221213E+01, 5.1775988987E+00, 5.4676760365E+00, 2.3394185013E+00, 9.0641713911E-01],
	[2.8780000000E+04, 1.9451740946E+01, 5.1775774220E+00, 5.4707458421E+00, 2.3400558173E+00, 9.0646165953E-01],
	[2.8785000000E+04, 1.9457261285E+01, 5.1775559492E+00, 5.4738168366E+00, 2.3406930316E+00, 9.0650615830E-01],
	[2.8790000000E+04, 1.9462782233E+01, 5.1775344801E+00, 5.4768890203E+00, 2.3413301441E+00, 9.0655063544E-01],
	[2.8795000000E+04, 1.9468303787E+01, 5.1775130149E+00, 5.4799623936E+00, 2.3419671547E+00, 9.0659509096E-01],
	[2.8800000000E+04, 1.9473825949E+01, 5.1774915535E+00, 5.4830369566E+00, 2.3426040635E+00, 9.0663952485E-01],
	[2.8805000000E+04, 1.9479348719E+01, 5.1774700959E+00, 5.4861127096E+00, 2.3432408702E+00, 9.0668393713E-01],
	[2.8810000000E+04, 1.9484872095E+01, 5.1774486422E+00, 5.4891896529E+00, 2.3438775750E+00, 9.0672832781E-01],
	[2.8815000000E+04, 1.9490396079E+01, 5.1774271922E+00, 5.4922677867E+00, 2.3445141778E+00, 9.0677269690E-01],
	[2.8820000000E+04, 1.9495920670E+01, 5.1774057461E+00, 5.4953471112E+00, 2.3451506784E+00, 9.0681704441E-01],
	[2.8825000000E+04, 1.9501445869E+01, 5.1773843037E+00, 5.4984276267E+00, 2.3457870769E+00, 9.0686137034E-01],
	[2.8830000000E+04, 1.9506971674E+01, 5.1773628652E+00, 5.5015093336E+00, 2.3464233732E+00, 9.0690567471E-01],
	[2.8835000000E+04, 1.9512498087E+01, 5.1773414305E+00, 5.5045922319E+00, 2.3470595672E+00, 9.0694995752E-01],
	[2.8840000000E+04, 1.9518025106E+01, 5.1773199996E+00, 5.5076763220E+00, 2.3476956589E+00, 9.0699421878E-01],
	[2.8845000000E+04, 1.9523552733E+01, 5.1772985724E+00, 5.5107616042E+00, 2.3483316483E+00, 9.0703845850E-01],
	[2.8850000000E+04, 1.9529080966E+01, 5.1772771491E+00, 5.5138480786E+00, 2.3489675353E+00, 9.0708267669E-01],
	[2.8855000000E+04, 1.9534609807E+01, 5.1772557296E+00, 5.5169357456E+00, 2.3496033198E+00, 9.0712687337E-01],
	[2.8860000000E+04, 1.9540139254E+01, 5.1772343139E+00, 5.5200246054E+00, 2.3502390018E+00, 9.0717104853E-01],
	[2.8865000000E+04, 1.9545669308E+01, 5.1772129020E+00, 5.5231146582E+00, 2.3508745812E+00, 9.0721520219E-01],
	[2.8870000000E+04, 1.9551199969E+01, 5.1771914939E+00, 5.5262059043E+00, 2.3515100580E+00, 9.0725933435E-01],
	[2.8875000000E+04, 1.9556731237E+01, 5.1771700896E+00, 5.5292983439E+00, 2.3521454322E+00, 9.0730344503E-01],
	[2.8880000000E+04, 1.9562263112E+01, 5.1771486890E+00, 5.5323919774E+00, 2.3527807036E+00, 9.0734753423E-01],
	[2.8885000000E+04, 1.9567795593E+01, 5.1771272923E+00, 5.5354868049E+00, 2.3534158723E+00, 9.0739160197E-01],
	[2.8890000000E+04, 1.9573328681E+01, 5.1771058994E+00, 5.5385828267E+00, 2.3540509382E+00, 9.0743564824E-01],
	[2.8895000000E+04, 1.9578862375E+01, 5.1770845102E+00, 5.5416800431E+00, 2.3546859012E+00, 9.0747967307E-01],
	[2.8900000000E+04, 1.9584396677E+01, 5.1770631248E+00, 5.5447784544E+00, 2.3553207613E+00, 9.0752367646E-01],
	[2.8905000000E+04, 1.9589931584E+01, 5.1770417433E+00, 5.5478780607E+00, 2.3559555185E+00, 9.0756765842E-01],
	[2.8910000000E+04, 1.9595467098E+01, 5.1770203655E+00, 5.5509788623E+00, 2.3565901726E+00, 9.0761161895E-01],
	[2.8915000000E+04, 1.9601003219E+01, 5.1769989915E+00, 5.5540808595E+00, 2.3572247237E+00, 9.0765555807E-01],
	[2.8920000000E+04, 1.9606539946E+01, 5.1769776213E+00, 5.5571840525E+00, 2.3578591717E+00, 9.0769947579E-01],
	[2.8925000000E+04, 1.9612077280E+01, 5.1769562548E+00, 5.5602884416E+00, 2.3584935165E+00, 9.0774337211E-01],
	[2.8930000000E+04, 1.9617615220E+01, 5.1769348922E+00, 5.5633940271E+00, 2.3591277581E+00, 9.0778724704E-01],
	[2.8935000000E+04, 1.9623153766E+01, 5.1769135333E+00, 5.5665008091E+00, 2.3597618965E+00, 9.0783110060E-01],
	[2.8940000000E+04, 1.9628692918E+01, 5.1768921782E+00, 5.5696087880E+00, 2.3603959315E+00, 9.0787493279E-01],
	[2.8945000000E+04, 1.9634232677E+01, 5.1768708269E+00, 5.5727179640E+00, 2.3610298632E+00, 9.0791874362E-01],
	[2.8950000000E+04, 1.9639773042E+01, 5.1768494794E+00, 5.5758283374E+00, 2.3616636915E+00, 9.0796253310E-01],
	[2.8955000000E+04, 1.9645314013E+01, 5.1768281356E+00, 5.5789399084E+00, 2.3622974163E+00, 9.0800630123E-01],
	[2.8960000000E+04, 1.9650855590E+01, 5.1768067956E+00, 5.5820526772E+00, 2.3629310376E+00, 9.0805004804E-01],
	[2.8965000000E+04, 1.9656397774E+01, 5.1767854594E+00, 5.5851666442E+00, 2.3635645554E+00, 9.0809377352E-01],
	[2.8970000000E+04, 1.9661951165E+01, 5.1767657804E+00, 5.5882818095E+00, 2.3641984677E+00, 9.0813747769E-01],
	[2.8975000000E+04, 1.9667515933E+01, 5.1767477837E+00, 5.5913981734E+00, 2.3648327828E+00, 9.0818116055E-01],
	[2.8980000000E+04, 1.9673081316E+01, 5.1767297902E+00, 5.5945157363E+00, 2.3654669949E+00, 9.0822482212E-01],
	[2.8985000000E+04, 1.9678647314E+01, 5.1767117999E+00, 5.5976344982E+00, 2.3661011039E+00, 9.0826846240E-01],
	[2.8990000000E+04, 1.9684213925E+01, 5.1766938127E+00, 5.6007544595E+00, 2.3667351099E+00, 9.0831208140E-01],
	[2.8995000000E+04, 1.9689781151E+01, 5.1766758287E+00, 5.6038756205E+00, 2.3673690128E+00, 9.0835567913E-01],
	[2.9000000000E+04, 1.9695348991E+01, 5.1766578478E+00, 5.6069979814E+00, 2.3680028125E+00, 9.0839925560E-01],
	[2.9005000000E+04, 1.9700917445E+01, 5.1766398701E+00, 5.6101215424E+00, 2.3686365091E+00, 9.0844281082E-01],
	[2.9010000000E+04, 1.9706486514E+01, 5.1766218956E+00, 5.6132463038E+00, 2.3692701023E+00, 9.0848634479E-01],
	[2.9015000000E+04, 1.9712056196E+01, 5.1766039242E+00, 5.6163722659E+00, 2.3699035923E+00, 9.0852985754E-01],
	[2.9020000000E+04, 1.9717626493E+01, 5.1765859560E+00, 5.6194994289E+00, 2.3705369789E+00, 9.0857334906E-01],
	[2.9025000000E+04, 1.9723197403E+01, 5.1765679910E+00, 5.6226277931E+00, 2.3711702621E+00, 9.0861681936E-01],
	[2.9030000000E+04, 1.9728768927E+01, 5.1765500291E+00, 5.6257573586E+00, 2.3718034418E+00, 9.0866026846E-01],
	[2.9035000000E+04, 1.9734341066E+01, 5.1765320703E+00, 5.6288881259E+00, 2.3724365181E+00, 9.0870369636E-01],
	[2.9040000000E+04, 1.9739913818E+01, 5.1765141147E+00, 5.6320200950E+00, 2.3730694908E+00, 9.0874710308E-01],
	[2.9045000000E+04, 1.9745487184E+01, 5.1764961623E+00, 5.6351532664E+00, 2.3737023599E+00, 9.0879048861E-01],
	[2.9050000000E+04, 1.9751061164E+01, 5.1764782130E+00, 5.6382876401E+00, 2.3743351253E+00, 9.0883385298E-01],
	[2.9055000000E+04, 1.9756635758E+01, 5.1764602669E+00, 5.6414232166E+00, 2.3749677871E+00, 9.0887719618E-01],
	[2.9060000000E+04, 1.9762210966E+01, 5.1764423239E+00, 5.6445599960E+00, 2.3756003451E+00, 9.0892051823E-01],
	[2.9065000000E+04, 1.9767786787E+01, 5.1764243841E+00, 5.6476979786E+00, 2.3762327994E+00, 9.0896381914E-01],
	[2.9070000000E+04, 1.9773363222E+01, 5.1764064474E+00, 5.6508371646E+00, 2.3768651498E+00, 9.0900709892E-01],
	[2.9075000000E+04, 1.9778940270E+01, 5.1763885139E+00, 5.6539775543E+00, 2.3774973963E+00, 9.0905035757E-01],
	[2.9080000000E+04, 1.9784517932E+01, 5.1763705835E+00, 5.6571191480E+00, 2.3781295389E+00, 9.0909359511E-01],
	[2.9085000000E+04, 1.9790096208E+01, 5.1763526562E+00, 5.6602619459E+00, 2.3787615775E+00, 9.0913681154E-01],
	[2.9090000000E+04, 1.9795675097E+01, 5.1763347321E+00, 5.6634059483E+00, 2.3793935121E+00, 9.0918000687E-01],
	[2.9095000000E+04, 1.9801254600E+01, 5.1763168112E+00, 5.6665511554E+00, 2.3800253426E+00, 9.0922318111E-01],
	[2.9100000000E+04, 1.9806834716E+01, 5.1762988934E+00, 5.6696975674E+00, 2.3806570690E+00, 9.0926633428E-01],
	[2.9105000000E+04, 1.9812415446E+01, 5.1762809787E+00, 5.6728451847E+00, 2.3812886912E+00, 9.0930946637E-01],
	[2.9110000000E+04, 1.9817996789E+01, 5.1762630672E+00, 5.6759940075E+00, 2.3819202092E+00, 9.0935257741E-01],
	[2.9115000000E+04, 1.9823578745E+01, 5.1762451588E+00, 5.6791440360E+00, 2.3825516230E+00, 9.0939566739E-01],
	[2.9120000000E+04, 1.9829161314E+01, 5.1762272535E+00, 5.6822952705E+00, 2.3831829324E+00, 9.0943873633E-01],
	[2.9125000000E+04, 1.9834744497E+01, 5.1762093514E+00, 5.6854477112E+00, 2.3838141375E+00, 9.0948178423E-01],
	[2.9130000000E+04, 1.9840328293E+01, 5.1761914524E+00, 5.6886013584E+00, 2.3844452382E+00, 9.0952481112E-01],
	[2.9135000000E+04, 1.9845912702E+01, 5.1761735565E+00, 5.6917562124E+00, 2.3850762344E+00, 9.0956781698E-01],
	[2.9140000000E+04, 1.9851497725E+01, 5.1761556638E+00, 5.6949122733E+00, 2.3857071261E+00, 9.0961080184E-01],
	[2.9145000000E+04, 1.9857083360E+01, 5.1761377742E+00, 5.6980695416E+00, 2.3863379133E+00, 9.0965376570E-01],
	[2.9150000000E+04, 1.9862669609E+01, 5.1761198878E+00, 5.7012280173E+00, 2.3869685959E+00, 9.0969670857E-01],
	[2.9155000000E+04, 1.9868256470E+01, 5.1761020044E+00, 5.7043877008E+00, 2.3875991739E+00, 9.0973963047E-01],
	[2.9160000000E+04, 1.9873843945E+01, 5.1760841242E+00, 5.7075485923E+00, 2.3882296472E+00, 9.0978253139E-01],
	[2.9165000000E+04, 1.9879432032E+01, 5.1760662471E+00, 5.7107106921E+00, 2.3888600157E+00, 9.0982541136E-01],
	[2.9170000000E+04, 1.9885020732E+01, 5.1760483732E+00, 5.7138740005E+00, 2.3894902795E+00, 9.0986827037E-01],
	[2.9175000000E+04, 1.9890610046E+01, 5.1760305024E+00, 5.7170385176E+00, 2.3901204384E+00, 9.0991110843E-01],
	[2.9180000000E+04, 1.9896199972E+01, 5.1760126347E+00, 5.7202042437E+00, 2.3907504925E+00, 9.0995392557E-01],
	[2.9185000000E+04, 1.9901790511E+01, 5.1759947701E+00, 5.7233711792E+00, 2.3913804417E+00, 9.0999672178E-01],
	[2.9190000000E+04, 1.9907381662E+01, 5.1759769086E+00, 5.7265393241E+00, 2.3920102859E+00, 9.1003949708E-01],
	[2.9195000000E+04, 1.9912973427E+01, 5.1759590503E+00, 5.7297086789E+00, 2.3926400251E+00, 9.1008225146E-01],
	[2.9200000000E+04, 1.9918565804E+01, 5.1759411951E+00, 5.7328792438E+00, 2.3932696592E+00, 9.1012498496E-01],
	[2.9205000000E+04, 1.9924158793E+01, 5.1759233430E+00, 5.7360510189E+00, 2.3938991883E+00, 9.1016769756E-01],
	[2.9210000000E+04, 1.9929752396E+01, 5.1759054940E+00, 5.7392240046E+00, 2.3945286122E+00, 9.1021038928E-01],
	[2.9215000000E+04, 1.9935346610E+01, 5.1758876482E+00, 5.7423982011E+00, 2.3951579309E+00, 9.1025306014E-01],
	[2.9220000000E+04, 1.9940941438E+01, 5.1758698054E+00, 5.7455736087E+00, 2.3957871443E+00, 9.1029571013E-01],
	[2.9225000000E+04, 1.9946536878E+01, 5.1758519658E+00, 5.7487502276E+00, 2.3964162525E+00, 9.1033833928E-01],
	[2.9230000000E+04, 1.9952132930E+01, 5.1758341293E+00, 5.7519280581E+00, 2.3970452554E+00, 9.1038094758E-01],
	[2.9235000000E+04, 1.9957729595E+01, 5.1758162959E+00, 5.7551071004E+00, 2.3976741529E+00, 9.1042353505E-01],
	[2.9240000000E+04, 1.9963326872E+01, 5.1757984656E+00, 5.7582873549E+00, 2.3983029449E+00, 9.1046610169E-01],
	[2.9245000000E+04, 1.9968924762E+01, 5.1757806384E+00, 5.7614688216E+00, 2.3989316315E+00, 9.1050864752E-01],
	[2.9250000000E+04, 1.9974523263E+01, 5.1757628143E+00, 5.7646515010E+00, 2.3995602126E+00, 9.1055117254E-01],
	[2.9255000000E+04, 1.9980122378E+01, 5.1757449933E+00, 5.7678353932E+00, 2.4001886882E+00, 9.1059367677E-01],
	[2.9260000000E+04, 1.9985722104E+01, 5.1757271755E+00, 5.7710204985E+00, 2.4008170581E+00, 9.1063616020E-01],
	[2.9265000000E+04, 1.9991322442E+01, 5.1757093607E+00, 5.7742068171E+00, 2.4014453224E+00, 9.1067862287E-01],
	[2.9270000000E+04, 1.9996923393E+01, 5.1756915491E+00, 5.7773943494E+00, 2.4020734810E+00, 9.1072106476E-01],
	[2.9275000000E+04, 2.0002524956E+01, 5.1756737405E+00, 5.7805830956E+00, 2.4027015339E+00, 9.1076348589E-01],
	[2.9280000000E+04, 2.0008127131E+01, 5.1756559351E+00, 5.7837730558E+00, 2.4033294809E+00, 9.1080588627E-01],
	[2.9285000000E+04, 2.0013729918E+01, 5.1756381327E+00, 5.7869642305E+00, 2.4039573222E+00, 9.1084826591E-01],
	[2.9290000000E+04, 2.0019333317E+01, 5.1756203335E+00, 5.7901566197E+00, 2.4045850576E+00, 9.1089062481E-01],
	[2.9295000000E+04, 2.0024937327E+01, 5.1756025374E+00, 5.7933502239E+00, 2.4052126871E+00, 9.1093296299E-01],
	[2.9300000000E+04, 2.0030541950E+01, 5.1755847443E+00, 5.7965450432E+00, 2.4058402106E+00, 9.1097528046E-01],
	[2.9305000000E+04, 2.0036147185E+01, 5.1755669544E+00, 5.7997410779E+00, 2.4064676281E+00, 9.1101757723E-01],
	[2.9310000000E+04, 2.0041753032E+01, 5.1755491675E+00, 5.8029383282E+00, 2.4070949396E+00, 9.1105985329E-01],
	[2.9315000000E+04, 2.0047359490E+01, 5.1755313838E+00, 5.8061367944E+00, 2.4077221449E+00, 9.1110210867E-01],
	[2.9320000000E+04, 2.0052966560E+01, 5.1755136031E+00, 5.8093364768E+00, 2.4083492442E+00, 9.1114434338E-01],
	[2.9325000000E+04, 2.0058574242E+01, 5.1754958255E+00, 5.8125373756E+00, 2.4089762372E+00, 9.1118655741E-01],
	[2.9330000000E+04, 2.0064182536E+01, 5.1754780511E+00, 5.8157394911E+00, 2.4096031240E+00, 9.1122875079E-01],
	[2.9335000000E+04, 2.0069791441E+01, 5.1754602797E+00, 5.8189428235E+00, 2.4102299046E+00, 9.1127092351E-01],
	[2.9340000000E+04, 2.0075400958E+01, 5.1754425114E+00, 5.8221473731E+00, 2.4108565788E+00, 9.1131307560E-01],
	[2.9345000000E+04, 2.0081011086E+01, 5.1754247462E+00, 5.8253531401E+00, 2.4114831467E+00, 9.1135520705E-01],
	[2.9350000000E+04, 2.0086621827E+01, 5.1754069840E+00, 5.8285601247E+00, 2.4121096082E+00, 9.1139731788E-01],
	[2.9355000000E+04, 2.0092233178E+01, 5.1753892250E+00, 5.8317683274E+00, 2.4127359632E+00, 9.1143940810E-01],
	[2.9360000000E+04, 2.0097845141E+01, 5.1753714691E+00, 5.8349777482E+00, 2.4133622118E+00, 9.1148147771E-01],
	[2.9365000000E+04, 2.0103457716E+01, 5.1753537162E+00, 5.8381883874E+00, 2.4139883538E+00, 9.1152352673E-01],
	[2.9370000000E+04, 2.0109070902E+01, 5.1753359664E+00, 5.8414002454E+00, 2.4146143892E+00, 9.1156555516E-01],
	[2.9375000000E+04, 2.0114684699E+01, 5.1753182197E+00, 5.8446133223E+00, 2.4152403180E+00, 9.1160756302E-01],
	[2.9380000000E+04, 2.0120299108E+01, 5.1753004761E+00, 5.8478276184E+00, 2.4158661401E+00, 9.1164955030E-01],
	[2.9385000000E+04, 2.0125914127E+01, 5.1752827356E+00, 5.8510431340E+00, 2.4164918556E+00, 9.1169151703E-01],
	[2.9390000000E+04, 2.0131529759E+01, 5.1752649981E+00, 5.8542598693E+00, 2.4171174642E+00, 9.1173346321E-01],
	[2.9395000000E+04, 2.0137146001E+01, 5.1752472637E+00, 5.8574778246E+00, 2.4177429661E+00, 9.1177538886E-01],
	[2.9400000000E+04, 2.0142762855E+01, 5.1752295324E+00, 5.8606970001E+00, 2.4183683612E+00, 9.1181729397E-01],
	[2.9405000000E+04, 2.0148380319E+01, 5.1752118042E+00, 5.8639173961E+00, 2.4189936493E+00, 9.1185917855E-01],
	[2.9410000000E+04, 2.0153998395E+01, 5.1751940791E+00, 5.8671390128E+00, 2.4196188306E+00, 9.1190104263E-01],
	[2.9415000000E+04, 2.0159617082E+01, 5.1751763570E+00, 5.8703618505E+00, 2.4202439048E+00, 9.1194288620E-01],
	[2.9420000000E+04, 2.0165236380E+01, 5.1751586380E+00, 5.8735859095E+00, 2.4208688721E+00, 9.1198470928E-01],
	[2.9425000000E+04, 2.0170856289E+01, 5.1751409221E+00, 5.8768111900E+00, 2.4214937323E+00, 9.1202651188E-01],
	[2.9430000000E+04, 2.0176476809E+01, 5.1751232092E+00, 5.8800376922E+00, 2.4221184854E+00, 9.1206829400E-01],
	[2.9435000000E+04, 2.0182102801E+01, 5.1751062484E+00, 5.8832654165E+00, 2.4227433656E+00, 9.1211005565E-01],
	[2.9440000000E+04, 2.0187745808E+01, 5.1750918171E+00, 5.8864943630E+00, 2.4233689291E+00, 9.1215179685E-01],
	[2.9445000000E+04, 2.0193389435E+01, 5.1750773882E+00, 5.8897245320E+00, 2.4239943861E+00, 9.1219351760E-01],
	[2.9450000000E+04, 2.0199033680E+01, 5.1750629618E+00, 5.8929559238E+00, 2.4246197366E+00, 9.1223521791E-01],
	[2.9455000000E+04, 2.0204678545E+01, 5.1750485379E+00, 5.8961885386E+00, 2.4252449805E+00, 9.1227689779E-01],
	[2.9460000000E+04, 2.0210324028E+01, 5.1750341166E+00, 5.8994223767E+00, 2.4258701177E+00, 9.1231855725E-01],
	[2.9465000000E+04, 2.0215970131E+01, 5.1750196976E+00, 5.9026574384E+00, 2.4264951483E+00, 9.1236019630E-01],
	[2.9470000000E+04, 2.0221616852E+01, 5.1750052812E+00, 5.9058937238E+00, 2.4271200721E+00, 9.1240181494E-01],
	[2.9475000000E+04, 2.0227264192E+01, 5.1749908673E+00, 5.9091312333E+00, 2.4277448892E+00, 9.1244341320E-01],
	[2.9480000000E+04, 2.0232912151E+01, 5.1749764558E+00, 5.9123699671E+00, 2.4283695994E+00, 9.1248499107E-01],
	[2.9485000000E+04, 2.0238560729E+01, 5.1749620469E+00, 5.9156099255E+00, 2.4289942028E+00, 9.1252654857E-01],
	[2.9490000000E+04, 2.0244209926E+01, 5.1749476404E+00, 5.9188511086E+00, 2.4296186993E+00, 9.1256808570E-01],
	[2.9495000000E+04, 2.0249859741E+01, 5.1749332364E+00, 5.9220935169E+00, 2.4302430889E+00, 9.1260960247E-01],
	[2.9500000000E+04, 2.0255510175E+01, 5.1749188349E+00, 5.9253371504E+00, 2.4308673715E+00, 9.1265109890E-01],
	[2.9505000000E+04, 2.0261161228E+01, 5.1749044359E+00, 5.9285820096E+00, 2.4314915471E+00, 9.1269257500E-01],
	[2.9510000000E+04, 2.0266812899E+01, 5.1748900393E+00, 5.9318280945E+00, 2.4321156156E+00, 9.1273403076E-01],
	[2.9515000000E+04, 2.0272465189E+01, 5.1748756452E+00, 5.9350754056E+00, 2.4327395770E+00, 9.1277546621E-01],
	[2.9520000000E+04, 2.0278118098E+01, 5.1748612536E+00, 5.9383239430E+00, 2.4333634313E+00, 9.1281688134E-01],
	[2.9525000000E+04, 2.0283771625E+01, 5.1748468645E+00, 5.9415737070E+00, 2.4339871783E+00, 9.1285827618E-01],
	[2.9530000000E+04, 2.0289425770E+01, 5.1748324779E+00, 5.9448246978E+00, 2.4346108182E+00, 9.1289965073E-01],
	[2.9535000000E+04, 2.0295080534E+01, 5.1748180937E+00, 5.9480769157E+00, 2.4352343508E+00, 9.1294100499E-01],
	[2.9540000000E+04, 2.0300735916E+01, 5.1748037120E+00, 5.9513303610E+00, 2.4358577760E+00, 9.1298233898E-01],
	[2.9545000000E+04, 2.0306391917E+01, 5.1747893328E+00, 5.9545850340E+00, 2.4364810939E+00, 9.1302365270E-01],
	[2.9550000000E+04, 2.0312048536E+01, 5.1747749560E+00, 5.9578409348E+00, 2.4371043044E+00, 9.1306494618E-01],
	[2.9555000000E+04, 2.0317705773E+01, 5.1747605818E+00, 5.9610980637E+00, 2.4377274075E+00, 9.1310621940E-01],
	[2.9560000000E+04, 2.0323363629E+01, 5.1747462100E+00, 5.9643564210E+00, 2.4383504031E+00, 9.1314747240E-01],
	[2.9565000000E+04, 2.0329022102E+01, 5.1747318406E+00, 5.9676160069E+00, 2.4389732912E+00, 9.1318870516E-01],
	[2.9570000000E+04, 2.0334681194E+01, 5.1747174738E+00, 5.9708768217E+00, 2.4395960717E+00, 9.1322991771E-01],
	[2.9575000000E+04, 2.0340340904E+01, 5.1747031094E+00, 5.9741388657E+00, 2.4402187446E+00, 9.1327111005E-01],
	[2.9580000000E+04, 2.0346001232E+01, 5.1746887474E+00, 5.9774021391E+00, 2.4408413099E+00, 9.1331228219E-01],
	[2.9585000000E+04, 2.0351662178E+01, 5.1746743880E+00, 5.9806666421E+00, 2.4414637674E+00, 9.1335343414E-01],
	[2.9590000000E+04, 2.0357323742E+01, 5.1746600310E+00, 5.9839323750E+00, 2.4420861173E+00, 9.1339456591E-01],
	[2.9595000000E+04, 2.0362985925E+01, 5.1746456765E+00, 5.9871993381E+00, 2.4427083594E+00, 9.1343567751E-01],
	[2.9600000000E+04, 2.0368648725E+01, 5.1746313244E+00, 5.9904675316E+00, 2.4433304936E+00, 9.1347676895E-01],
	[2.9605000000E+04, 2.0374312143E+01, 5.1746169748E+00, 5.9937369558E+00, 2.4439525201E+00, 9.1351784024E-01],
	[2.9610000000E+04, 2.0379976179E+01, 5.1746026277E+00, 5.9970076109E+00, 2.4445744386E+00, 9.1355889138E-01],
	[2.9615000000E+04, 2.0385640832E+01, 5.1745882830E+00, 6.0002794972E+00, 2.4451962492E+00, 9.1359992239E-01],
	[2.9620000000E+04, 2.0391306104E+01, 5.1745739408E+00, 6.0035526150E+00, 2.4458179518E+00, 9.1364093327E-01],
	[2.9625000000E+04, 2.0396971993E+01, 5.1745596010E+00, 6.0068269644E+00, 2.4464395464E+00, 9.1368192404E-01],
	[2.9630000000E+04, 2.0402638500E+01, 5.1745452638E+00, 6.0101025458E+00, 2.4470610330E+00, 9.1372289470E-01],
	[2.9635000000E+04, 2.0408305625E+01, 5.1745309289E+00, 6.0133793594E+00, 2.4476824115E+00, 9.1376384526E-01],
	[2.9640000000E+04, 2.0413973367E+01, 5.1745165965E+00, 6.0166574054E+00, 2.4483036818E+00, 9.1380477574E-01],
	[2.9645000000E+04, 2.0419641727E+01, 5.1745022666E+00, 6.0199366842E+00, 2.4489248440E+00, 9.1384568613E-01],
	[2.9650000000E+04, 2.0425310705E+01, 5.1744879392E+00, 6.0232171959E+00, 2.4495458979E+00, 9.1388657646E-01],
	[2.9655000000E+04, 2.0430980300E+01, 5.1744736142E+00, 6.0264989409E+00, 2.4501668436E+00, 9.1392744673E-01],
	[2.9660000000E+04, 2.0436650512E+01, 5.1744592916E+00, 6.0297819193E+00, 2.4507876810E+00, 9.1396829695E-01],
	[2.9665000000E+04, 2.0442321342E+01, 5.1744449715E+00, 6.0330661315E+00, 2.4514084101E+00, 9.1400912712E-01],
	[2.9670000000E+04, 2.0447992790E+01, 5.1744306539E+00, 6.0363515776E+00, 2.4520290308E+00, 9.1404993726E-01],
	[2.9675000000E+04, 2.0453664855E+01, 5.1744163387E+00, 6.0396382580E+00, 2.4526495431E+00, 9.1409072738E-01],
	[2.9680000000E+04, 2.0459337537E+01, 5.1744020260E+00, 6.0429261730E+00, 2.4532699469E+00, 9.1413149749E-01],
	[2.9685000000E+04, 2.0465010836E+01, 5.1743877157E+00, 6.0462153226E+00, 2.4538902422E+00, 9.1417224759E-01],
	[2.9690000000E+04, 2.0470684753E+01, 5.1743734078E+00, 6.0495057073E+00, 2.4545104290E+00, 9.1421297769E-01],
	[2.9695000000E+04, 2.0476359287E+01, 5.1743591024E+00, 6.0527973272E+00, 2.4551305072E+00, 9.1425368781E-01],
	[2.9700000000E+04, 2.0482034439E+01, 5.1743447995E+00, 6.0560901827E+00, 2.4557504768E+00, 9.1429437795E-01],
	[2.9705000000E+04, 2.0487710207E+01, 5.1743304990E+00, 6.0593842739E+00, 2.4563703378E+00, 9.1433504813E-01],
	[2.9710000000E+04, 2.0493386593E+01, 5.1743162010E+00, 6.0626796012E+00, 2.4569900900E+00, 9.1437569834E-01],
	[2.9715000000E+04, 2.0499063596E+01, 5.1743019054E+00, 6.0659761647E+00, 2.4576097335E+00, 9.1441632861E-01],
	[2.9720000000E+04, 2.0504741215E+01, 5.1742876122E+00, 6.0692739648E+00, 2.4582292683E+00, 9.1445693894E-01],
	[2.9725000000E+04, 2.0510419452E+01, 5.1742733215E+00, 6.0725730017E+00, 2.4588486942E+00, 9.1449752933E-01],
	[2.9730000000E+04, 2.0516098306E+01, 5.1742590332E+00, 6.0758732756E+00, 2.4594680113E+00, 9.1453809981E-01],
	[2.9735000000E+04, 2.0521777777E+01, 5.1742447474E+00, 6.0791747869E+00, 2.4600872195E+00, 9.1457865037E-01],
	[2.9740000000E+04, 2.0527457864E+01, 5.1742304640E+00, 6.0824775357E+00, 2.4607063188E+00, 9.1461918103E-01],
	[2.9745000000E+04, 2.0533138569E+01, 5.1742161830E+00, 6.0857815223E+00, 2.4613253091E+00, 9.1465969180E-01],
	[2.9750000000E+04, 2.0538819890E+01, 5.1742019045E+00, 6.0890867470E+00, 2.4619441904E+00, 9.1470018268E-01],
	[2.9755000000E+04, 2.0544501829E+01, 5.1741876285E+00, 6.0923932100E+00, 2.4625629627E+00, 9.1474065369E-01],
	[2.9760000000E+04, 2.0550184383E+01, 5.1741733548E+00, 6.0957009116E+00, 2.4631816258E+00, 9.1478110483E-01],
	[2.9765000000E+04, 2.0555867555E+01, 5.1741590837E+00, 6.0990098521E+00, 2.4638001799E+00, 9.1482153611E-01],
	[2.9770000000E+04, 2.0561551344E+01, 5.1741448149E+00, 6.1023200316E+00, 2.4644186247E+00, 9.1486194755E-01],
	[2.9775000000E+04, 2.0567235749E+01, 5.1741305486E+00, 6.1056314505E+00, 2.4650369604E+00, 9.1490233915E-01],
	[2.9780000000E+04, 2.0572920770E+01, 5.1741162847E+00, 6.1089441090E+00, 2.4656551869E+00, 9.1494271092E-01],
	[2.9785000000E+04, 2.0578606409E+01, 5.1741020232E+00, 6.1122580074E+00, 2.4662733040E+00, 9.1498306287E-01],
	[2.9790000000E+04, 2.0584292663E+01, 5.1740877642E+00, 6.1155731458E+00, 2.4668913119E+00, 9.1502339501E-01],
	[2.9795000000E+04, 2.0589979535E+01, 5.1740735076E+00, 6.1188895247E+00, 2.4675092104E+00, 9.1506370735E-01],
	[2.9800000000E+04, 2.0595667023E+01, 5.1740592535E+00, 6.1222071441E+00, 2.4681269995E+00, 9.1510399990E-01],
	[2.9805000000E+04, 2.0601355127E+01, 5.1740450018E+00, 6.1255260045E+00, 2.4687446791E+00, 9.1514427266E-01],
	[2.9810000000E+04, 2.0607043848E+01, 5.1740307525E+00, 6.1288461059E+00, 2.4693622493E+00, 9.1518452566E-01],
	[2.9815000000E+04, 2.0612733185E+01, 5.1740165056E+00, 6.1321674488E+00, 2.4699797100E+00, 9.1522475889E-01],
	[2.9820000000E+04, 2.0618423138E+01, 5.1740022612E+00, 6.1354900333E+00, 2.4705970611E+00, 9.1526497236E-01],
	[2.9825000000E+04, 2.0624113708E+01, 5.1739880192E+00, 6.1388138597E+00, 2.4712143027E+00, 9.1530516609E-01],
	[2.9830000000E+04, 2.0629804893E+01, 5.1739737796E+00, 6.1421389283E+00, 2.4718314346E+00, 9.1534534008E-01],
	[2.9835000000E+04, 2.0635496696E+01, 5.1739595424E+00, 6.1454652393E+00, 2.4724484569E+00, 9.1538549434E-01],
	[2.9840000000E+04, 2.0641189114E+01, 5.1739453077E+00, 6.1487927930E+00, 2.4730653695E+00, 9.1542562889E-01],
	[2.9845000000E+04, 2.0646882148E+01, 5.1739310754E+00, 6.1521215896E+00, 2.4736821723E+00, 9.1546574373E-01],
	[2.9850000000E+04, 2.0652575799E+01, 5.1739168455E+00, 6.1554516293E+00, 2.4742988654E+00, 9.1550583887E-01],
	[2.9855000000E+04, 2.0658270066E+01, 5.1739026180E+00, 6.1587829125E+00, 2.4749154486E+00, 9.1554591432E-01],
	[2.9860000000E+04, 2.0663964948E+01, 5.1738883930E+00, 6.1621154394E+00, 2.4755319220E+00, 9.1558597009E-01],
	[2.9865000000E+04, 2.0669660447E+01, 5.1738741704E+00, 6.1654492102E+00, 2.4761482855E+00, 9.1562600619E-01],
	[2.9870000000E+04, 2.0675356562E+01, 5.1738599502E+00, 6.1687842253E+00, 2.4767645391E+00, 9.1566602263E-01],
	[2.9875000000E+04, 2.0681053292E+01, 5.1738457324E+00, 6.1721204848E+00, 2.4773806827E+00, 9.1570601941E-01],
	[2.9880000000E+04, 2.0686750639E+01, 5.1738315170E+00, 6.1754579890E+00, 2.4779967164E+00, 9.1574599655E-01],
	[2.9885000000E+04, 2.0692448601E+01, 5.1738173041E+00, 6.1787967381E+00, 2.4786126400E+00, 9.1578595406E-01],
	[2.9890000000E+04, 2.0698147179E+01, 5.1738030936E+00, 6.1821367325E+00, 2.4792284535E+00, 9.1582589194E-01],
	[2.9895000000E+04, 2.0703846373E+01, 5.1737888855E+00, 6.1854779724E+00, 2.4798441569E+00, 9.1586581020E-01],
	[2.9900000000E+04, 2.0709546183E+01, 5.1737746798E+00, 6.1888204580E+00, 2.4804597502E+00, 9.1590570886E-01],
	[2.9905000000E+04, 2.0715246608E+01, 5.1737604765E+00, 6.1921641896E+00, 2.4810752332E+00, 9.1594558793E-01],
	[2.9910000000E+04, 2.0720957369E+01, 5.1737477552E+00, 6.1955091674E+00, 2.4816910859E+00, 9.1598544740E-01],
	[2.9915000000E+04, 2.0726680178E+01, 5.1737367754E+00, 6.1988553918E+00, 2.4823073930E+00, 9.1602528729E-01],
	[2.9920000000E+04, 2.0732403611E+01, 5.1737257974E+00, 6.2022028629E+00, 2.4829235905E+00, 9.1606510762E-01],
	[2.9925000000E+04, 2.0738127667E+01, 5.1737148212E+00, 6.2055515810E+00, 2.4835396783E+00, 9.1610490839E-01],
	[2.9930000000E+04, 2.0743852347E+01, 5.1737038469E+00, 6.2089015464E+00, 2.4841556565E+00, 9.1614468960E-01],
	[2.9935000000E+04, 2.0749577651E+01, 5.1736928745E+00, 6.2122527593E+00, 2.4847715249E+00, 9.1618445128E-01],
	[2.9940000000E+04, 2.0755303578E+01, 5.1736819039E+00, 6.2156052199E+00, 2.4853872836E+00, 9.1622419342E-01],
	[2.9945000000E+04, 2.0761030129E+01, 5.1736709352E+00, 6.2189589287E+00, 2.4860029326E+00, 9.1626391604E-01],
	[2.9950000000E+04, 2.0766757304E+01, 5.1736599684E+00, 6.2223138857E+00, 2.4866184717E+00, 9.1630361914E-01],
	[2.9955000000E+04, 2.0772485101E+01, 5.1736490033E+00, 6.2256700912E+00, 2.4872339009E+00, 9.1634330274E-01],
	[2.9960000000E+04, 2.0778213523E+01, 5.1736380402E+00, 6.2290275456E+00, 2.4878492203E+00, 9.1638296685E-01],
	[2.9965000000E+04, 2.0783942567E+01, 5.1736270789E+00, 6.2323862490E+00, 2.4884644297E+00, 9.1642261147E-01],
	[2.9970000000E+04, 2.0789672235E+01, 5.1736161194E+00, 6.2357462017E+00, 2.4890795291E+00, 9.1646223661E-01],
	[2.9975000000E+04, 2.0795402527E+01, 5.1736051618E+00, 6.2391074040E+00, 2.4896945186E+00, 9.1650184228E-01],
	[2.9980000000E+04, 2.0801133441E+01, 5.1735942061E+00, 6.2424698561E+00, 2.4903093980E+00, 9.1654142850E-01],
	[2.9985000000E+04, 2.0806864979E+01, 5.1735832522E+00, 6.2458335583E+00, 2.4909241674E+00, 9.1658099527E-01],
	[2.9990000000E+04, 2.0812597140E+01, 5.1735723001E+00, 6.2491985108E+00, 2.4915388266E+00, 9.1662054260E-01],
	[2.9995000000E+04, 2.0818329924E+01, 5.1735613499E+00, 6.2525647139E+00, 2.4921533757E+00, 9.1666007049E-01],
	[3.0000000000E+04, 2.0824063332E+01, 5.1735504016E+00, 6.2559321679E+00, 2.4927678146E+00, 9.1669957897E-01],
	[3.0005000000E+04, 2.0829797362E+01, 5.1735394551E+00, 6.2593220069E+00, 2.4933854968E+00, 9.1673906804E-01],
	[3.0010000000E+04, 2.0835532016E+01, 5.1735285104E+00, 6.2627131166E+00, 2.4940030680E+00, 9.1677853770E-01],
	[3.0015000000E+04, 2.0841267293E+01, 5.1735175676E+00, 6.2661054972E+00, 2.4946205279E+00, 9.1681798797E-01],
	[3.0020000000E+04, 2.0847003192E+01, 5.1735066267E+00, 6.2694991490E+00, 2.4952378767E+00, 9.1685741885E-01],
	[3.0025000000E+04, 2.0852739715E+01, 5.1734956875E+00, 6.2728940723E+00, 2.4958551142E+00, 9.1689683037E-01],
	[3.0030000000E+04, 2.0858476860E+01, 5.1734847503E+00, 6.2762902673E+00, 2.4964722405E+00, 9.1693622251E-01],
	[3.0035000000E+04, 2.0864214629E+01, 5.1734738148E+00, 6.2796877342E+00, 2.4970892555E+00, 9.1697559530E-01],
	[3.0040000000E+04, 2.0869953020E+01, 5.1734628813E+00, 6.2830864734E+00, 2.4977061591E+00, 9.1701494874E-01],
	[3.0045000000E+04, 2.0875692034E+01, 5.1734519495E+00, 6.2864864851E+00, 2.4983229513E+00, 9.1705428285E-01],
	[3.0050000000E+04, 2.0881431671E+01, 5.1734410196E+00, 6.2898877696E+00, 2.4989396321E+00, 9.1709359762E-01],
	[3.0055000000E+04, 2.0887171931E+01, 5.1734300915E+00, 6.2932903271E+00, 2.4995562015E+00, 9.1713289308E-01],
	[3.0060000000E+04, 2.0892912813E+01, 5.1734191653E+00, 6.2966941579E+00, 2.5001726594E+00, 9.1717216923E-01],
	[3.0065000000E+04, 2.0898654318E+01, 5.1734082409E+00, 6.3000992623E+00, 2.5007890057E+00, 9.1721142607E-01],
	[3.0070000000E+04, 2.0904396446E+01, 5.1733973184E+00, 6.3035056405E+00, 2.5014052405E+00, 9.1725066363E-01],
	[3.0075000000E+04, 2.0910139196E+01, 5.1733863977E+00, 6.3069132928E+00, 2.5020213637E+00, 9.1728988190E-01],
	[3.0080000000E+04, 2.0915882569E+01, 5.1733754788E+00, 6.3103222195E+00, 2.5026373753E+00, 9.1732908090E-01],
	[3.0085000000E+04, 2.0921626564E+01, 5.1733645618E+00, 6.3137324207E+00, 2.5032532752E+00, 9.1736826064E-01],
	[3.0090000000E+04, 2.0927371182E+01, 5.1733536466E+00, 6.3171438969E+00, 2.5038690634E+00, 9.1740742112E-01],
	[3.0095000000E+04, 2.0933116422E+01, 5.1733427333E+00, 6.3205566482E+00, 2.5044847398E+00, 9.1744656236E-01],
	[3.0100000000E+04, 2.0938862285E+01, 5.1733318218E+00, 6.3239706749E+00, 2.5051003045E+00, 9.1748568436E-01],
	[3.0105000000E+04, 2.0944608770E+01, 5.1733209121E+00, 6.3273859773E+00, 2.5057157574E+00, 9.1752478713E-01],
	[3.0110000000E+04, 2.0950355877E+01, 5.1733100043E+00, 6.3308025557E+00, 2.5063310984E+00, 9.1756387069E-01],
	[3.0115000000E+04, 2.0956103607E+01, 5.1732990982E+00, 6.3342204102E+00, 2.5069463275E+00, 9.1760293503E-01],
	[3.0120000000E+04, 2.0961851959E+01, 5.1732881941E+00, 6.3376395412E+00, 2.5075614447E+00, 9.1764198016E-01],
	[3.0125000000E+04, 2.0967600934E+01, 5.1732772917E+00, 6.3410599490E+00, 2.5081764500E+00, 9.1768100610E-01],
	[3.0130000000E+04, 2.0973350530E+01, 5.1732663912E+00, 6.3444816337E+00, 2.5087913433E+00, 9.1772001285E-01],
	[3.0135000000E+04, 2.0979100749E+01, 5.1732554925E+00, 6.3479045957E+00, 2.5094061245E+00, 9.1775900042E-01],
	[3.0140000000E+04, 2.0984851590E+01, 5.1732445957E+00, 6.3513288353E+00, 2.5100207937E+00, 9.1779796881E-01],
	[3.0145000000E+04, 2.0990603052E+01, 5.1732337007E+00, 6.3547543526E+00, 2.5106353508E+00, 9.1783691804E-01],
	[3.0150000000E+04, 2.0996355137E+01, 5.1732228075E+00, 6.3581811480E+00, 2.5112497958E+00, 9.1787584811E-01],
	[3.0155000000E+04, 2.1002107844E+01, 5.1732119161E+00, 6.3616092217E+00, 2.5118641285E+00, 9.1791475903E-01],
	[3.0160000000E+04, 2.1007861173E+01, 5.1732010266E+00, 6.3650385740E+00, 2.5124783491E+00, 9.1795365080E-01],
	[3.0165000000E+04, 2.1013615124E+01, 5.1731901389E+00, 6.3684692051E+00, 2.5130924575E+00, 9.1799252344E-01],
	[3.0170000000E+04, 2.1019369697E+01, 5.1731792530E+00, 6.3719011154E+00, 2.5137064536E+00, 9.1803137696E-01],
	[3.0175000000E+04, 2.1025124892E+01, 5.1731683690E+00, 6.3753343050E+00, 2.5143203374E+00, 9.1807021136E-01],
	[3.0180000000E+04, 2.1030880709E+01, 5.1731574868E+00, 6.3787687743E+00, 2.5149341088E+00, 9.1810902664E-01],
	[3.0185000000E+04, 2.1036637147E+01, 5.1731466064E+00, 6.3822045234E+00, 2.5155477679E+00, 9.1814782283E-01],
	[3.0190000000E+04, 2.1042394207E+01, 5.1731357278E+00, 6.3856415528E+00, 2.5161613145E+00, 9.1818659992E-01],
	[3.0195000000E+04, 2.1048151889E+01, 5.1731248510E+00, 6.3890798626E+00, 2.5167747487E+00, 9.1822535792E-01],
	[3.0200000000E+04, 2.1053910193E+01, 5.1731139761E+00, 6.3925194530E+00, 2.5173880705E+00, 9.1826409684E-01],
	[3.0205000000E+04, 2.1059669118E+01, 5.1731031030E+00, 6.3959603245E+00, 2.5180012797E+00, 9.1830281669E-01],
	[3.0210000000E+04, 2.1065428665E+01, 5.1730922317E+00, 6.3994024771E+00, 2.5186143764E+00, 9.1834151748E-01],
	[3.0215000000E+04, 2.1071188834E+01, 5.1730813623E+00, 6.4028459113E+00, 2.5192273605E+00, 9.1838019922E-01],
	[3.0220000000E+04, 2.1076949624E+01, 5.1730704947E+00, 6.4062906272E+00, 2.5198402319E+00, 9.1841886190E-01],
	[3.0225000000E+04, 2.1082711035E+01, 5.1730596288E+00, 6.4097366252E+00, 2.5204529908E+00, 9.1845750555E-01],
	[3.0230000000E+04, 2.1088473068E+01, 5.1730487649E+00, 6.4131839054E+00, 2.5210656369E+00, 9.1849613017E-01],
	[3.0235000000E+04, 2.1094235723E+01, 5.1730379027E+00, 6.4166324681E+00, 2.5216781703E+00, 9.1853473576E-01],
	[3.0240000000E+04, 2.1099998999E+01, 5.1730270423E+00, 6.4200823137E+00, 2.5222905910E+00, 9.1857332234E-01],
	[3.0245000000E+04, 2.1105762896E+01, 5.1730161838E+00, 6.4235334424E+00, 2.5229028989E+00, 9.1861188991E-01],
	[3.0250000000E+04, 2.1111527415E+01, 5.1730053271E+00, 6.4269858544E+00, 2.5235150939E+00, 9.1865043848E-01],
	[3.0255000000E+04, 2.1117292555E+01, 5.1729944722E+00, 6.4304395500E+00, 2.5241271761E+00, 9.1868896806E-01],
	[3.0260000000E+04, 2.1123058316E+01, 5.1729836191E+00, 6.4338945295E+00, 2.5247391454E+00, 9.1872747865E-01],
	[3.0265000000E+04, 2.1128824699E+01, 5.1729727678E+00, 6.4373507931E+00, 2.5253510018E+00, 9.1876597027E-01],
	[3.0270000000E+04, 2.1134591703E+01, 5.1729619184E+00, 6.4408083411E+00, 2.5259627453E+00, 9.1880444292E-01],
	[3.0275000000E+04, 2.1140359328E+01, 5.1729510707E+00, 6.4442671738E+00, 2.5265743757E+00, 9.1884289662E-01],
	[3.0280000000E+04, 2.1146127574E+01, 5.1729402249E+00, 6.4477272915E+00, 2.5271858931E+00, 9.1888133136E-01],
	[3.0285000000E+04, 2.1151896441E+01, 5.1729293809E+00, 6.4511886943E+00, 2.5277972975E+00, 9.1891974716E-01],
	[3.0290000000E+04, 2.1157665929E+01, 5.1729185387E+00, 6.4546513825E+00, 2.5284085888E+00, 9.1895814402E-01],
	[3.0295000000E+04, 2.1163436038E+01, 5.1729076983E+00, 6.4581153565E+00, 2.5290197669E+00, 9.1899652195E-01],
	[3.0300000000E+04, 2.1169206769E+01, 5.1728968597E+00, 6.4615806165E+00, 2.5296308319E+00, 9.1903488097E-01],
	[3.0305000000E+04, 2.1174978120E+01, 5.1728860230E+00, 6.4650471628E+00, 2.5302417837E+00, 9.1907322107E-01],
	[3.0310000000E+04, 2.1180750092E+01, 5.1728751880E+00, 6.4685149955E+00, 2.5308526223E+00, 9.1911154227E-01],
	[3.0315000000E+04, 2.1186522685E+01, 5.1728643549E+00, 6.4719841151E+00, 2.5314633476E+00, 9.1914984457E-01],
	[3.0320000000E+04, 2.1192295899E+01, 5.1728535236E+00, 6.4754545216E+00, 2.5320739597E+00, 9.1918812799E-01],
	[3.0325000000E+04, 2.1198069733E+01, 5.1728426940E+00, 6.4789262155E+00, 2.5326844584E+00, 9.1922639252E-01],
	[3.0330000000E+04, 2.1203844189E+01, 5.1728318663E+00, 6.4823991970E+00, 2.5332948437E+00, 9.1926463819E-01],
	[3.0335000000E+04, 2.1209619265E+01, 5.1728210404E+00, 6.4858734663E+00, 2.5339051157E+00, 9.1930286499E-01],
	[3.0340000000E+04, 2.1215394962E+01, 5.1728102163E+00, 6.4893490238E+00, 2.5345152742E+00, 9.1934107294E-01],
	[3.0345000000E+04, 2.1221171279E+01, 5.1727993940E+00, 6.4928258695E+00, 2.5351253193E+00, 9.1937926203E-01],
	[3.0350000000E+04, 2.1226948217E+01, 5.1727885735E+00, 6.4963040040E+00, 2.5357352509E+00, 9.1941743229E-01],
	[3.0355000000E+04, 2.1232725776E+01, 5.1727777548E+00, 6.4997834273E+00, 2.5363450690E+00, 9.1945558372E-01],
	[3.0360000000E+04, 2.1238503956E+01, 5.1727669380E+00, 6.5032641398E+00, 2.5369547736E+00, 9.1949371632E-01],
	[3.0365000000E+04, 2.1244282755E+01, 5.1727561229E+00, 6.5067461417E+00, 2.5375643645E+00, 9.1953183011E-01],
	[3.0370000000E+04, 2.1250062176E+01, 5.1727453096E+00, 6.5102294333E+00, 2.5381738418E+00, 9.1956992509E-01],
	[3.0375000000E+04, 2.1255842217E+01, 5.1727344981E+00, 6.5137140149E+00, 2.5387832055E+00, 9.1960800127E-01],
	[3.0380000000E+04, 2.1261622878E+01, 5.1727236885E+00, 6.5171998867E+00, 2.5393924555E+00, 9.1964605866E-01],
	[3.0385000000E+04, 2.1267404159E+01, 5.1727128806E+00, 6.5206870490E+00, 2.5400015918E+00, 9.1968409726E-01],
	[3.0390000000E+04, 2.1273189522E+01, 5.1727025953E+00, 6.5241755020E+00, 2.5406107893E+00, 9.1972211709E-01],
	[3.0395000000E+04, 2.1278993021E+01, 5.1726949472E+00, 6.5276652460E+00, 2.5412207591E+00, 9.1976011816E-01],
	[3.0400000000E+04, 2.1284797148E+01, 5.1726873002E+00, 6.5311562814E+00, 2.5418306157E+00, 9.1979810046E-01],
	[3.0405000000E+04, 2.1290601904E+01, 5.1726796546E+00, 6.5346486083E+00, 2.5424403591E+00, 9.1983606401E-01],
	[3.0410000000E+04, 2.1296407288E+01, 5.1726720102E+00, 6.5381422270E+00, 2.5430499893E+00, 9.1987400882E-01],
	[3.0415000000E+04, 2.1302213300E+01, 5.1726643671E+00, 6.5416371377E+00, 2.5436595064E+00, 9.1991193490E-01],
	[3.0420000000E+04, 2.1308019940E+01, 5.1726567253E+00, 6.5451333408E+00, 2.5442689101E+00, 9.1994984224E-01],
	[3.0425000000E+04, 2.1313827209E+01, 5.1726490847E+00, 6.5486308366E+00, 2.5448782006E+00, 9.1998773087E-01],
	[3.0430000000E+04, 2.1319635105E+01, 5.1726414454E+00, 6.5521296252E+00, 2.5454873777E+00, 9.2002560079E-01],
	[3.0435000000E+04, 2.1325443629E+01, 5.1726338074E+00, 6.5556297069E+00, 2.5460964415E+00, 9.2006345200E-01],
	[3.0440000000E+04, 2.1331252781E+01, 5.1726261706E+00, 6.5591310820E+00, 2.5467053919E+00, 9.2010128452E-01],
	[3.0445000000E+04, 2.1337062562E+01, 5.1726185351E+00, 6.5626337508E+00, 2.5473142289E+00, 9.2013909836E-01],
	[3.0450000000E+04, 2.1342872970E+01, 5.1726109009E+00, 6.5661377135E+00, 2.5479229525E+00, 9.2017689351E-01],
	[3.0455000000E+04, 2.1348684006E+01, 5.1726032679E+00, 6.5696429705E+00, 2.5485315626E+00, 9.2021467000E-01],
	[3.0460000000E+04, 2.1354495669E+01, 5.1725956362E+00, 6.5731495218E+00, 2.5491400591E+00, 9.2025242782E-01],
	[3.0465000000E+04, 2.1360307961E+01, 5.1725880057E+00, 6.5766573679E+00, 2.5497484421E+00, 9.2029016699E-01],
	[3.0470000000E+04, 2.1366120880E+01, 5.1725803765E+00, 6.5801665090E+00, 2.5503567116E+00, 9.2032788751E-01],
	[3.0475000000E+04, 2.1371934427E+01, 5.1725727486E+00, 6.5836769454E+00, 2.5509648674E+00, 9.2036558939E-01],
	[3.0480000000E+04, 2.1377748602E+01, 5.1725651220E+00, 6.5871886773E+00, 2.5515729096E+00, 9.2040327264E-01],
	[3.0485000000E+04, 2.1383563404E+01, 5.1725574966E+00, 6.5907017049E+00, 2.5521808381E+00, 9.2044093727E-01],
	[3.0490000000E+04, 2.1389378834E+01, 5.1725498724E+00, 6.5942160286E+00, 2.5527886530E+00, 9.2047858329E-01],
	[3.0495000000E+04, 2.1395194892E+01, 5.1725422495E+00, 6.5977316487E+00, 2.5533963541E+00, 9.2051621070E-01],
	[3.0500000000E+04, 2.1401011577E+01, 5.1725346279E+00, 6.6012485653E+00, 2.5540039414E+00, 9.2055381951E-01],
	[3.0505000000E+04, 2.1406828890E+01, 5.1725270076E+00, 6.6047667787E+00, 2.5546114149E+00, 9.2059140974E-01],
	[3.0510000000E+04, 2.1412646830E+01, 5.1725193885E+00, 6.6082862893E+00, 2.5552187747E+00, 9.2062898138E-01],
	[3.0515000000E+04, 2.1418465397E+01, 5.1725117707E+00, 6.6118070972E+00, 2.5558260205E+00, 9.2066653445E-01],
	[3.0520000000E+04, 2.1424284592E+01, 5.1725041541E+00, 6.6153292028E+00, 2.5564331525E+00, 9.2070406895E-01],
	[3.0525000000E+04, 2.1430104414E+01, 5.1724965388E+00, 6.6188526063E+00, 2.5570401706E+00, 9.2074158490E-01],
	[3.0530000000E+04, 2.1435924864E+01, 5.1724889247E+00, 6.6223773080E+00, 2.5576470747E+00, 9.2077908229E-01],
	[3.0535000000E+04, 2.1441745941E+01, 5.1724813119E+00, 6.6259033081E+00, 2.5582538648E+00, 9.2081656115E-01],
	[3.0540000000E+04, 2.1447567645E+01, 5.1724737004E+00, 6.6294306069E+00, 2.5588605409E+00, 9.2085402147E-01],
	[3.0545000000E+04, 2.1453389977E+01, 5.1724660901E+00, 6.6329592046E+00, 2.5594671030E+00, 9.2089146327E-01],
	[3.0550000000E+04, 2.1459212935E+01, 5.1724584811E+00, 6.6364891016E+00, 2.5600735511E+00, 9.2092888655E-01],
	[3.0555000000E+04, 2.1465036521E+01, 5.1724508733E+00, 6.6400202981E+00, 2.5606798850E+00, 9.2096629132E-01],
	[3.0560000000E+04, 2.1470860734E+01, 5.1724432668E+00, 6.6435527944E+00, 2.5612861048E+00, 9.2100367759E-01],
	[3.0565000000E+04, 2.1476685574E+01, 5.1724356615E+00, 6.6470865906E+00, 2.5618922104E+00, 9.2104104537E-01],
	[3.0570000000E+04, 2.1482511041E+01, 5.1724280575E+00, 6.6506216872E+00, 2.5624982018E+00, 9.2107839467E-01],
	[3.0575000000E+04, 2.1488337135E+01, 5.1724204548E+00, 6.6541580843E+00, 2.5631040790E+00, 9.2111572549E-01],
	[3.0580000000E+04, 2.1494163856E+01, 5.1724128533E+00, 6.6576957823E+00, 2.5637098420E+00, 9.2115303784E-01],
	[3.0585000000E+04, 2.1499991204E+01, 5.1724052531E+00, 6.6612347813E+00, 2.5643154907E+00, 9.2119033173E-01],
	[3.0590000000E+04, 2.1505819179E+01, 5.1723976541E+00, 6.6647750817E+00, 2.5649210250E+00, 9.2122760717E-01],
	[3.0595000000E+04, 2.1511647781E+01, 5.1723900563E+00, 6.6683166837E+00, 2.5655264450E+00, 9.2126486417E-01],
	[3.0600000000E+04, 2.1517477009E+01, 5.1723824599E+00, 6.6718595876E+00, 2.5661317507E+00, 9.2130210273E-01],
	[3.0605000000E+04, 2.1523306865E+01, 5.1723748646E+00, 6.6754037936E+00, 2.5667369419E+00, 9.2133932287E-01],
	[3.0610000000E+04, 2.1529137347E+01, 5.1723672707E+00, 6.6789493021E+00, 2.5673420188E+00, 9.2137652458E-01],
	[3.0615000000E+04, 2.1534968456E+01, 5.1723596779E+00, 6.6824961132E+00, 2.5679469811E+00, 9.2141370789E-01],
	[3.0620000000E+04, 2.1540800191E+01, 5.1723520865E+00, 6.6860442273E+00, 2.5685518290E+00, 9.2145087279E-01],
	[3.0625000000E+04, 2.1546632554E+01, 5.1723444962E+00, 6.6895936446E+00, 2.5691565623E+00, 9.2148801930E-01],
	[3.0630000000E+04, 2.1552465543E+01, 5.1723369073E+00, 6.6931443653E+00, 2.5697611811E+00, 9.2152514742E-01],
	[3.0635000000E+04, 2.1558299158E+01, 5.1723293196E+00, 6.6966963898E+00, 2.5703656853E+00, 9.2156225716E-01],
	[3.0640000000E+04, 2.1564133400E+01, 5.1723217331E+00, 6.7002497183E+00, 2.5709700749E+00, 9.2159934853E-01],
	[3.0645000000E+04, 2.1569968269E+01, 5.1723141479E+00, 6.7038043511E+00, 2.5715743499E+00, 9.2163642154E-01],
	[3.0650000000E+04, 2.1575803764E+01, 5.1723065639E+00, 6.7073602884E+00, 2.5721785102E+00, 9.2167347620E-01],
	[3.0655000000E+04, 2.1581639886E+01, 5.1722989812E+00, 6.7109175305E+00, 2.5727825557E+00, 9.2171051251E-01],
	[3.0660000000E+04, 2.1587476634E+01, 5.1722913997E+00, 6.7144760777E+00, 2.5733864866E+00, 9.2174753048E-01],
	[3.0665000000E+04, 2.1593314008E+01, 5.1722838194E+00, 6.7180359302E+00, 2.5739903027E+00, 9.2178453012E-01],
	[3.0670000000E+04, 2.1599152009E+01, 5.1722762405E+00, 6.7215970883E+00, 2.5745940040E+00, 9.2182151144E-01],
	[3.0675000000E+04, 2.1604990636E+01, 5.1722686627E+00, 6.7251595523E+00, 2.5751975905E+00, 9.2185847445E-01],
	[3.0680000000E+04, 2.1610829889E+01, 5.1722610862E+00, 6.7287233224E+00, 2.5758010622E+00, 9.2189541916E-01],
	[3.0685000000E+04, 2.1616669769E+01, 5.1722535110E+00, 6.7322883989E+00, 2.5764044190E+00, 9.2193234556E-01],
	[3.0690000000E+04, 2.1622510274E+01, 5.1722459370E+00, 6.7358547821E+00, 2.5770076609E+00, 9.2196925368E-01],
	[3.0695000000E+04, 2.1628351406E+01, 5.1722383642E+00, 6.7394224721E+00, 2.5776107878E+00, 9.2200614352E-01],
	[3.0700000000E+04, 2.1634193165E+01, 5.1722307927E+00, 6.7429914694E+00, 2.5782137998E+00, 9.2204301509E-01],
	[3.0705000000E+04, 2.1640035549E+01, 5.1722232225E+00, 6.7465617741E+00, 2.5788166969E+00, 9.2207986839E-01],
	[3.0710000000E+04, 2.1645878559E+01, 5.1722156534E+00, 6.7501333866E+00, 2.5794194788E+00, 9.2211670344E-01],
	[3.0715000000E+04, 2.1651722195E+01, 5.1722080856E+00, 6.7537063070E+00, 2.5800221458E+00, 9.2215352024E-01],
	[3.0720000000E+04, 2.1657566458E+01, 5.1722005191E+00, 6.7572805357E+00, 2.5806246977E+00, 9.2219031879E-01],
	[3.0725000000E+04, 2.1663411346E+01, 5.1721929538E+00, 6.7608560729E+00, 2.5812271344E+00, 9.2222709912E-01],
	[3.0730000000E+04, 2.1669256860E+01, 5.1721853898E+00, 6.7644329188E+00, 2.5818294561E+00, 9.2226386123E-01],
	[3.0735000000E+04, 2.1675103000E+01, 5.1721778270E+00, 6.7680110739E+00, 2.5824316626E+00, 9.2230060512E-01],
	[3.0740000000E+04, 2.1680949766E+01, 5.1721702654E+00, 6.7715905382E+00, 2.5830337538E+00, 9.2233733080E-01],
	[3.0745000000E+04, 2.1686797158E+01, 5.1721627051E+00, 6.7751713121E+00, 2.5836357299E+00, 9.2237403829E-01],
	[3.0750000000E+04, 2.1692645176E+01, 5.1721551460E+00, 6.7787533959E+00, 2.5842375907E+00, 9.2241072758E-01],
	[3.0755000000E+04, 2.1698493819E+01, 5.1721475881E+00, 6.7823367897E+00, 2.5848393363E+00, 9.2244739869E-01],
	[3.0760000000E+04, 2.1704343088E+01, 5.1721400315E+00, 6.7859214940E+00, 2.5854409666E+00, 9.2248405163E-01],
	[3.0765000000E+04, 2.1710192983E+01, 5.1721324761E+00, 6.7895075089E+00, 2.5860424815E+00, 9.2252068640E-01],
	[3.0770000000E+04, 2.1716043504E+01, 5.1721249220E+00, 6.7930948347E+00, 2.5866438811E+00, 9.2255730302E-01],
	[3.0775000000E+04, 2.1721894650E+01, 5.1721173691E+00, 6.7966834717E+00, 2.5872451653E+00, 9.2259390148E-01],
	[3.0780000000E+04, 2.1727746421E+01, 5.1721098175E+00, 6.8002734201E+00, 2.5878463340E+00, 9.2263048181E-01],
	[3.0785000000E+04, 2.1733598819E+01, 5.1721022671E+00, 6.8038646802E+00, 2.5884473874E+00, 9.2266704400E-01],
	[3.0790000000E+04, 2.1739451841E+01, 5.1720947179E+00, 6.8074572523E+00, 2.5890483252E+00, 9.2270358806E-01],
	[3.0795000000E+04, 2.1745305490E+01, 5.1720871699E+00, 6.8110511366E+00, 2.5896491476E+00, 9.2274011401E-01],
	[3.0800000000E+04, 2.1751159763E+01, 5.1720796232E+00, 6.8146463334E+00, 2.5902498544E+00, 9.2277662186E-01],
	[3.0805000000E+04, 2.1757014662E+01, 5.1720720778E+00, 6.8182428430E+00, 2.5908504457E+00, 9.2281311160E-01],
	[3.0810000000E+04, 2.1762870187E+01, 5.1720645335E+00, 6.8218406656E+00, 2.5914509215E+00, 9.2284958325E-01],
	[3.0815000000E+04, 2.1768726337E+01, 5.1720569905E+00, 6.8254398015E+00, 2.5920512816E+00, 9.2288603681E-01],
	[3.0820000000E+04, 2.1774583112E+01, 5.1720494488E+00, 6.8290402510E+00, 2.5926515260E+00, 9.2292247230E-01],
	[3.0825000000E+04, 2.1780440512E+01, 5.1720419082E+00, 6.8326420143E+00, 2.5932516548E+00, 9.2295888973E-01],
	[3.0830000000E+04, 2.1786298538E+01, 5.1720343689E+00, 6.8362450917E+00, 2.5938516680E+00, 9.2299528909E-01],
	[3.0835000000E+04, 2.1792157189E+01, 5.1720268309E+00, 6.8398494834E+00, 2.5944515654E+00, 9.2303167040E-01],
	[3.0840000000E+04, 2.1798016465E+01, 5.1720192940E+00, 6.8434551898E+00, 2.5950513471E+00, 9.2306803367E-01],
	[3.0845000000E+04, 2.1803876366E+01, 5.1720117584E+00, 6.8470622111E+00, 2.5956510129E+00, 9.2310437891E-01],
	[3.0850000000E+04, 2.1809736892E+01, 5.1720042241E+00, 6.8506705475E+00, 2.5962505630E+00, 9.2314070612E-01],
	[3.0855000000E+04, 2.1815598043E+01, 5.1719966910E+00, 6.8542801994E+00, 2.5968499973E+00, 9.2317701531E-01],
	[3.0860000000E+04, 2.1821459820E+01, 5.1719891591E+00, 6.8578911669E+00, 2.5974493157E+00, 9.2321330649E-01],
	[3.0865000000E+04, 2.1827322221E+01, 5.1719816284E+00, 6.8615034504E+00, 2.5980485183E+00, 9.2324957967E-01],
	[3.0870000000E+04, 2.1833185247E+01, 5.1719740989E+00, 6.8651170501E+00, 2.5986476049E+00, 9.2328583486E-01],
	[3.0875000000E+04, 2.1839048898E+01, 5.1719665707E+00, 6.8687319663E+00, 2.5992465756E+00, 9.2332207206E-01],
	[3.0880000000E+04, 2.1844919824E+01, 5.1719600336E+00, 6.8723481993E+00, 2.5998457747E+00, 9.2335829129E-01],
	[3.0885000000E+04, 2.1850805502E+01, 5.1719555994E+00, 6.8759657493E+00, 2.6004455894E+00, 9.2339449254E-01],
	[3.0890000000E+04, 2.1856691812E+01, 5.1719511660E+00, 6.8795846165E+00, 2.6010452888E+00, 9.2343067584E-01],
	[3.0895000000E+04, 2.1862578755E+01, 5.1719467332E+00, 6.8832048014E+00, 2.6016448727E+00, 9.2346684118E-01],
	[3.0900000000E+04, 2.1868466331E+01, 5.1719423012E+00, 6.8868263040E+00, 2.6022443413E+00, 9.2350298858E-01],
	[3.0905000000E+04, 2.1874354539E+01, 5.1719378700E+00, 6.8904491247E+00, 2.6028436945E+00, 9.2353911805E-01],
	[3.0910000000E+04, 2.1880243380E+01, 5.1719334394E+00, 6.8940732637E+00, 2.6034429321E+00, 9.2357522959E-01],
	[3.0915000000E+04, 2.1886132853E+01, 5.1719290096E+00, 6.8976987214E+00, 2.6040420543E+00, 9.2361132320E-01],
	[3.0920000000E+04, 2.1892022958E+01, 5.1719245805E+00, 6.9013254980E+00, 2.6046410610E+00, 9.2364739891E-01],
	[3.0925000000E+04, 2.1897913696E+01, 5.1719201521E+00, 6.9049535937E+00, 2.6052399522E+00, 9.2368345671E-01],
	[3.0930000000E+04, 2.1903805066E+01, 5.1719157244E+00, 6.9085830088E+00, 2.6058387278E+00, 9.2371949662E-01],
	[3.0935000000E+04, 2.1909697069E+01, 5.1719112974E+00, 6.9122137435E+00, 2.6064373878E+00, 9.2375551864E-01],
	[3.0940000000E+04, 2.1915589704E+01, 5.1719068712E+00, 6.9158457983E+00, 2.6070359322E+00, 9.2379152279E-01],
	[3.0945000000E+04, 2.1921482971E+01, 5.1719024457E+00, 6.9194791732E+00, 2.6076343609E+00, 9.2382750906E-01],
	[3.0950000000E+04, 2.1927376870E+01, 5.1718980209E+00, 6.9231138686E+00, 2.6082326740E+00, 9.2386347748E-01],
	[3.0955000000E+04, 2.1933271402E+01, 5.1718935968E+00, 6.9267498847E+00, 2.6088308713E+00, 9.2389942804E-01],
	[3.0960000000E+04, 2.1939166565E+01, 5.1718891734E+00, 6.9303872219E+00, 2.6094289530E+00, 9.2393536075E-01],
	[3.0965000000E+04, 2.1945062361E+01, 5.1718847508E+00, 6.9340258803E+00, 2.6100269189E+00, 9.2397127563E-01],
	[3.0970000000E+04, 2.1950958789E+01, 5.1718803289E+00, 6.9376658603E+00, 2.6106247690E+00, 9.2400717268E-01],
	[3.0975000000E+04, 2.1956855849E+01, 5.1718759076E+00, 6.9413071620E+00, 2.6112225034E+00, 9.2404305191E-01],
	[3.0980000000E+04, 2.1962753541E+01, 5.1718714872E+00, 6.9449497859E+00, 2.6118201219E+00, 9.2407891332E-01],
	[3.0985000000E+04, 2.1968651865E+01, 5.1718670674E+00, 6.9485937321E+00, 2.6124176245E+00, 9.2411475694E-01],
	[3.0990000000E+04, 2.1974550820E+01, 5.1718626483E+00, 6.9522390008E+00, 2.6130150113E+00, 9.2415058275E-01],
	[3.0995000000E+04, 2.1980450408E+01, 5.1718582300E+00, 6.9558855925E+00, 2.6136122822E+00, 9.2418639078E-01],
	[3.1000000000E+04, 2.1986350628E+01, 5.1718538124E+00, 6.9595335073E+00, 2.6142094371E+00, 9.2422218103E-01],
	[3.1005000000E+04, 2.1992251479E+01, 5.1718493954E+00, 6.9631827455E+00, 2.6148064761E+00, 9.2425795351E-01],
	[3.1010000000E+04, 2.1998152963E+01, 5.1718449793E+00, 6.9668333073E+00, 2.6154033992E+00, 9.2429370823E-01],
	[3.1015000000E+04, 2.2004055078E+01, 5.1718405638E+00, 6.9704851931E+00, 2.6160002062E+00, 9.2432944519E-01],
	[3.1020000000E+04, 2.2009957824E+01, 5.1718361490E+00, 6.9741384031E+00, 2.6165968972E+00, 9.2436516441E-01],
	[3.1025000000E+04, 2.2015861203E+01, 5.1718317350E+00, 6.9777929375E+00, 2.6171934721E+00, 9.2440086589E-01],
	[3.1030000000E+04, 2.2021765213E+01, 5.1718273216E+00, 6.9814487967E+00, 2.6177899309E+00, 9.2443654964E-01],
	[3.1035000000E+04, 2.2027669855E+01, 5.1718229090E+00, 6.9851059809E+00, 2.6183862737E+00, 9.2447221566E-01],
	[3.1040000000E+04, 2.2033575128E+01, 5.1718184971E+00, 6.9887644903E+00, 2.6189825003E+00, 9.2450786398E-01],
	[3.1045000000E+04, 2.2039481033E+01, 5.1718140859E+00, 6.9924243253E+00, 2.6195786108E+00, 9.2454349459E-01],
	[3.1050000000E+04, 2.2045387570E+01, 5.1718096755E+00, 6.9960854860E+00, 2.6201746050E+00, 9.2457910750E-01],
	[3.1055000000E+04, 2.2051294738E+01, 5.1718052657E+00, 6.9997479728E+00, 2.6207704831E+00, 9.2461470273E-01],
	[3.1060000000E+04, 2.2057202537E+01, 5.1718008567E+00, 7.0034117860E+00, 2.6213662449E+00, 9.2465028027E-01],
	[3.1065000000E+04, 2.2063110968E+01, 5.1717964483E+00, 7.0070769258E+00, 2.6219618905E+00, 9.2468584014E-01],
	[3.1070000000E+04, 2.2069020031E+01, 5.1717920407E+00, 7.0107433924E+00, 2.6225574198E+00, 9.2472138235E-01],
	[3.1075000000E+04, 2.2074929724E+01, 5.1717876338E+00, 7.0144111861E+00, 2.6231528328E+00, 9.2475690691E-01],
	[3.1080000000E+04, 2.2080840049E+01, 5.1717832276E+00, 7.0180803072E+00, 2.6237481295E+00, 9.2479241382E-01],
	[3.1085000000E+04, 2.2086751006E+01, 5.1717788221E+00, 7.0217507560E+00, 2.6243433098E+00, 9.2482790308E-01],
	[3.1090000000E+04, 2.2092662593E+01, 5.1717744174E+00, 7.0254225327E+00, 2.6249383737E+00, 9.2486337472E-01],
	[3.1095000000E+04, 2.2098574812E+01, 5.1717700133E+00, 7.0290956376E+00, 2.6255333212E+00, 9.2489882874E-01],
	[3.1100000000E+04, 2.2104487662E+01, 5.1717656100E+00, 7.0327700710E+00, 2.6261281523E+00, 9.2493426514E-01],
	[3.1105000000E+04, 2.2110401143E+01, 5.1717612073E+00, 7.0364458331E+00, 2.6267228670E+00, 9.2496968393E-01],
	[3.1110000000E+04, 2.2116315256E+01, 5.1717568054E+00, 7.0401229241E+00, 2.6273174651E+00, 9.2500508513E-01],
	[3.1115000000E+04, 2.2122229999E+01, 5.1717524042E+00, 7.0438013445E+00, 2.6279119468E+00, 9.2504046874E-01],
	[3.1120000000E+04, 2.2128145373E+01, 5.1717480037E+00, 7.0474810943E+00, 2.6285063119E+00, 9.2507583477E-01],
	[3.1125000000E+04, 2.2134061379E+01, 5.1717436039E+00, 7.0511621740E+00, 2.6291005605E+00, 9.2511118323E-01],
	[3.1130000000E+04, 2.2139978015E+01, 5.1717392048E+00, 7.0548445837E+00, 2.6296946925E+00, 9.2514651412E-01],
	[3.1135000000E+04, 2.2145895283E+01, 5.1717348065E+00, 7.0585283237E+00, 2.6302887079E+00, 9.2518182745E-01],
	[3.1140000000E+04, 2.2151813181E+01, 5.1717304088E+00, 7.0622133943E+00, 2.6308826067E+00, 9.2521712324E-01],
	[3.1145000000E+04, 2.2157731710E+01, 5.1717260119E+00, 7.0658997958E+00, 2.6314763889E+00, 9.2525240149E-01],
	[3.1150000000E+04, 2.2163650870E+01, 5.1717216156E+00, 7.0695875284E+00, 2.6320700543E+00, 9.2528766221E-01],
	[3.1155000000E+04, 2.2169570661E+01, 5.1717172201E+00, 7.0732765924E+00, 2.6326636031E+00, 9.2532290540E-01],
	[3.1160000000E+04, 2.2175491083E+01, 5.1717128253E+00, 7.0769669880E+00, 2.6332570352E+00, 9.2535813108E-01],
	[3.1165000000E+04, 2.2181412135E+01, 5.1717084312E+00, 7.0806587155E+00, 2.6338503505E+00, 9.2539333925E-01],
	[3.1170000000E+04, 2.2187333818E+01, 5.1717040378E+00, 7.0843517753E+00, 2.6344435490E+00, 9.2542852992E-01],
	[3.1175000000E+04, 2.2193256132E+01, 5.1716996451E+00, 7.0880461675E+00, 2.6350366308E+00, 9.2546370311E-01],
	[3.1180000000E+04, 2.2199179077E+01, 5.1716952531E+00, 7.0917418924E+00, 2.6356295957E+00, 9.2549885881E-01],
	[3.1185000000E+04, 2.2205102652E+01, 5.1716908618E+00, 7.0954389503E+00, 2.6362224438E+00, 9.2553399704E-01],
	[3.1190000000E+04, 2.2211026858E+01, 5.1716864712E+00, 7.0991373414E+00, 2.6368151750E+00, 9.2556911780E-01],
	[3.1195000000E+04, 2.2216951694E+01, 5.1716820814E+00, 7.1028370661E+00, 2.6374077894E+00, 9.2560422111E-01],
	[3.1200000000E+04, 2.2222877160E+01, 5.1716776922E+00, 7.1065381245E+00, 2.6380002868E+00, 9.2563930697E-01],
	[3.1205000000E+04, 2.2228803258E+01, 5.1716733038E+00, 7.1102405170E+00, 2.6385926674E+00, 9.2567437539E-01],
	[3.1210000000E+04, 2.2234729985E+01, 5.1716689160E+00, 7.1139442439E+00, 2.6391849309E+00, 9.2570942637E-01],
	[3.1215000000E+04, 2.2240657343E+01, 5.1716645290E+00, 7.1176493053E+00, 2.6397770775E+00, 9.2574445994E-01],
	[3.1220000000E+04, 2.2246585332E+01, 5.1716601427E+00, 7.1213557015E+00, 2.6403691071E+00, 9.2577947608E-01],
	[3.1225000000E+04, 2.2252513951E+01, 5.1716557570E+00, 7.1250634329E+00, 2.6409610196E+00, 9.2581447482E-01],
	[3.1230000000E+04, 2.2258443200E+01, 5.1716513721E+00, 7.1287724997E+00, 2.6415528151E+00, 9.2584945616E-01],
	[3.1235000000E+04, 2.2264373079E+01, 5.1716469879E+00, 7.1324829021E+00, 2.6421444936E+00, 9.2588442011E-01],
	[3.1240000000E+04, 2.2270303589E+01, 5.1716426044E+00, 7.1361946404E+00, 2.6427360549E+00, 9.2591936668E-01],
	[3.1245000000E+04, 2.2276234728E+01, 5.1716382216E+00, 7.1399077149E+00, 2.6433274991E+00, 9.2595429588E-01],
	[3.1250000000E+04, 2.2282166498E+01, 5.1716338395E+00, 7.1436221259E+00, 2.6439188262E+00, 9.2598920770E-01],
	[3.1255000000E+04, 2.2288098899E+01, 5.1716294581E+00, 7.1473378736E+00, 2.6445100361E+00, 9.2602410217E-01],
	[3.1260000000E+04, 2.2294031929E+01, 5.1716250774E+00, 7.1510549582E+00, 2.6451011289E+00, 9.2605897930E-01],
	[3.1265000000E+04, 2.2299965589E+01, 5.1716206975E+00, 7.1547733802E+00, 2.6456921044E+00, 9.2609383908E-01],
	[3.1270000000E+04, 2.2305899879E+01, 5.1716163182E+00, 7.1584931396E+00, 2.6462829627E+00, 9.2612868152E-01],
	[3.1275000000E+04, 2.2311834800E+01, 5.1716119396E+00, 7.1622142368E+00, 2.6468737037E+00, 9.2616350665E-01],
	[3.1280000000E+04, 2.2317770350E+01, 5.1716075617E+00, 7.1659366721E+00, 2.6474643275E+00, 9.2619831445E-01],
	[3.1285000000E+04, 2.2323706530E+01, 5.1716031846E+00, 7.1696604457E+00, 2.6480548339E+00, 9.2623310495E-01],
	[3.1290000000E+04, 2.2329643341E+01, 5.1715988081E+00, 7.1733855578E+00, 2.6486452231E+00, 9.2626787815E-01],
	[3.1295000000E+04, 2.2335580781E+01, 5.1715944324E+00, 7.1771120089E+00, 2.6492354949E+00, 9.2630263406E-01],
	[3.1300000000E+04, 2.2341518850E+01, 5.1715900573E+00, 7.1808397990E+00, 2.6498256493E+00, 9.2633737268E-01],
	[3.1305000000E+04, 2.2347457550E+01, 5.1715856829E+00, 7.1845689285E+00, 2.6504156864E+00, 9.2637209403E-01],
	[3.1310000000E+04, 2.2353396880E+01, 5.1715813093E+00, 7.1882993977E+00, 2.6510056060E+00, 9.2640679812E-01],
	[3.1315000000E+04, 2.2359336839E+01, 5.1715769363E+00, 7.1920312068E+00, 2.6515954082E+00, 9.2644148494E-01],
	[3.1320000000E+04, 2.2365277428E+01, 5.1715725641E+00, 7.1957643560E+00, 2.6521850929E+00, 9.2647615452E-01],
	[3.1325000000E+04, 2.2371218646E+01, 5.1715681925E+00, 7.1994988458E+00, 2.6527746602E+00, 9.2651080685E-01],
	[3.1330000000E+04, 2.2377160494E+01, 5.1715638217E+00, 7.2032346762E+00, 2.6533641100E+00, 9.2654544195E-01],
	[3.1335000000E+04, 2.2383102972E+01, 5.1715594516E+00, 7.2069718476E+00, 2.6539534422E+00, 9.2658005983E-01],
	[3.1340000000E+04, 2.2389046079E+01, 5.1715550821E+00, 7.2107103603E+00, 2.6545426569E+00, 9.2661466049E-01],
	[3.1345000000E+04, 2.2394989816E+01, 5.1715507134E+00, 7.2144502145E+00, 2.6551317541E+00, 9.2664924394E-01],
	[3.1350000000E+04, 2.2400934183E+01, 5.1715463453E+00, 7.2181914105E+00, 2.6557207336E+00, 9.2668381019E-01],
	[3.1355000000E+04, 2.2406879178E+01, 5.1715419780E+00, 7.2219339485E+00, 2.6563095955E+00, 9.2671835924E-01],
	[3.1360000000E+04, 2.2412824804E+01, 5.1715376114E+00, 7.2256778288E+00, 2.6568983398E+00, 9.2675289112E-01],
	[3.1365000000E+04, 2.2418771058E+01, 5.1715332454E+00, 7.2294230518E+00, 2.6574869665E+00, 9.2678740582E-01],
	[3.1370000000E+04, 2.2424717942E+01, 5.1715288802E+00, 7.2331696176E+00, 2.6580754755E+00, 9.2682190335E-01],
	[3.1375000000E+04, 2.2430665456E+01, 5.1715245156E+00, 7.2369175265E+00, 2.6586638668E+00, 9.2685638372E-01],
	[3.1380000000E+04, 2.2436632111E+01, 5.1715228779E+00, 7.2406667787E+00, 2.6592531212E+00, 9.2689084694E-01],
	[3.1385000000E+04, 2.2442601458E+01, 5.1715215431E+00, 7.2444173747E+00, 2.6598423674E+00, 9.2692529302E-01],
	[3.1390000000E+04, 2.2448571442E+01, 5.1715202085E+00, 7.2481693145E+00, 2.6604314965E+00, 9.2695972197E-01],
	[3.1395000000E+04, 2.2454542063E+01, 5.1715188741E+00, 7.2519225986E+00, 2.6610205085E+00, 9.2699413379E-01],
	[3.1400000000E+04, 2.2460513320E+01, 5.1715175399E+00, 7.2556772271E+00, 2.6616094032E+00, 9.2702852849E-01],
	[3.1405000000E+04, 2.2466485214E+01, 5.1715162059E+00, 7.2594332003E+00, 2.6621981808E+00, 9.2706290608E-01],
	[3.1410000000E+04, 2.2472457745E+01, 5.1715148721E+00, 7.2631905185E+00, 2.6627868412E+00, 9.2709726658E-01],
	[3.1415000000E+04, 2.2478430913E+01, 5.1715135385E+00, 7.2669491819E+00, 2.6633753844E+00, 9.2713160998E-01],
	[3.1420000000E+04, 2.2484404717E+01, 5.1715122052E+00, 7.2707091909E+00, 2.6639638103E+00, 9.2716593629E-01],
	[3.1425000000E+04, 2.2490379158E+01, 5.1715108720E+00, 7.2744705457E+00, 2.6645521189E+00, 9.2720024553E-01],
	[3.1430000000E+04, 2.2496354236E+01, 5.1715095391E+00, 7.2782332465E+00, 2.6651403102E+00, 9.2723453770E-01],
	[3.1435000000E+04, 2.2502329950E+01, 5.1715082064E+00, 7.2819972936E+00, 2.6657283843E+00, 9.2726881282E-01],
	[3.1440000000E+04, 2.2508306301E+01, 5.1715068739E+00, 7.2857626874E+00, 2.6663163410E+00, 9.2730307088E-01],
	[3.1445000000E+04, 2.2514283288E+01, 5.1715055416E+00, 7.2895294279E+00, 2.6669041803E+00, 9.2733731189E-01],
	[3.1450000000E+04, 2.2520260912E+01, 5.1715042095E+00, 7.2932975156E+00, 2.6674919022E+00, 9.2737153588E-01],
	[3.1455000000E+04, 2.2526239172E+01, 5.1715028777E+00, 7.2970669507E+00, 2.6680795068E+00, 9.2740574283E-01],
	[3.1460000000E+04, 2.2532218069E+01, 5.1715015460E+00, 7.3008377335E+00, 2.6686669939E+00, 9.2743993277E-01],
	[3.1465000000E+04, 2.2538197602E+01, 5.1715002146E+00, 7.3046098641E+00, 2.6692543636E+00, 9.2747410570E-01],
	[3.1470000000E+04, 2.2544177771E+01, 5.1714988834E+00, 7.3083833430E+00, 2.6698416159E+00, 9.2750826163E-01],
	[3.1475000000E+04, 2.2550158576E+01, 5.1714975523E+00, 7.3121581703E+00, 2.6704287506E+00, 9.2754240056E-01],
	[3.1480000000E+04, 2.2556140018E+01, 5.1714962215E+00, 7.3159343464E+00, 2.6710157678E+00, 9.2757652251E-01],
	[3.1485000000E+04, 2.2562122096E+01, 5.1714948909E+00, 7.3197118714E+00, 2.6716026676E+00, 9.2761062748E-01],
	[3.1490000000E+04, 2.2568104811E+01, 5.1714935606E+00, 7.3234907457E+00, 2.6721894498E+00, 9.2764471549E-01],
	[3.1495000000E+04, 2.2574088161E+01, 5.1714922304E+00, 7.3272709695E+00, 2.6727761144E+00, 9.2767878653E-01],
	[3.1500000000E+04, 2.2580072148E+01, 5.1714909004E+00, 7.3310525431E+00, 2.6733626614E+00, 9.2771284062E-01],
	[3.1505000000E+04, 2.2586056770E+01, 5.1714895707E+00, 7.3348354668E+00, 2.6739490908E+00, 9.2774687777E-01],
	[3.1510000000E+04, 2.2592042029E+01, 5.1714882412E+00, 7.3386197408E+00, 2.6745354026E+00, 9.2778089798E-01],
	[3.1515000000E+04, 2.2598027924E+01, 5.1714869118E+00, 7.3424053654E+00, 2.6751215968E+00, 9.2781490126E-01],
	[3.1520000000E+04, 2.2604014455E+01, 5.1714855827E+00, 7.3461923408E+00, 2.6757076733E+00, 9.2784888763E-01],
	[3.1525000000E+04, 2.2610001622E+01, 5.1714842538E+00, 7.3499806674E+00, 2.6762936321E+00, 9.2788285709E-01],
	[3.1530000000E+04, 2.2615989425E+01, 5.1714829251E+00, 7.3537703454E+00, 2.6768794731E+00, 9.2791680964E-01],
	[3.1535000000E+04, 2.2621977863E+01, 5.1714815966E+00, 7.3575613750E+00, 2.6774651965E+00, 9.2795074530E-01],
	[3.1540000000E+04, 2.2627966938E+01, 5.1714802684E+00, 7.3613537566E+00, 2.6780508021E+00, 9.2798466407E-01],
	[3.1545000000E+04, 2.2633956648E+01, 5.1714789403E+00, 7.3651474904E+00, 2.6786362900E+00, 9.2801856597E-01],
	[3.1550000000E+04, 2.2639946994E+01, 5.1714776125E+00, 7.3689425766E+00, 2.6792216600E+00, 9.2805245099E-01],
	[3.1555000000E+04, 2.2645937976E+01, 5.1714762848E+00, 7.3727390155E+00, 2.6798069123E+00, 9.2808631916E-01],
	[3.1560000000E+04, 2.2651929594E+01, 5.1714749574E+00, 7.3765368075E+00, 2.6803920467E+00, 9.2812017047E-01],
	[3.1565000000E+04, 2.2657921847E+01, 5.1714736302E+00, 7.3803359527E+00, 2.6809770633E+00, 9.2815400494E-01],
	[3.1570000000E+04, 2.2663914736E+01, 5.1714723032E+00, 7.3841364515E+00, 2.6815619620E+00, 9.2818782257E-01],
	[3.1575000000E+04, 2.2669908261E+01, 5.1714709764E+00, 7.3879383040E+00, 2.6821467428E+00, 9.2822162338E-01],
	[3.1580000000E+04, 2.2675902421E+01, 5.1714696498E+00, 7.3917415107E+00, 2.6827314057E+00, 9.2825540736E-01],
	[3.1585000000E+04, 2.2681897217E+01, 5.1714683234E+00, 7.3955460716E+00, 2.6833159507E+00, 9.2828917454E-01],
	[3.1590000000E+04, 2.2687892649E+01, 5.1714669973E+00, 7.3993519872E+00, 2.6839003778E+00, 9.2832292491E-01],
	[3.1595000000E+04, 2.2693888716E+01, 5.1714656713E+00, 7.4031592576E+00, 2.6844846868E+00, 9.2835665848E-01],
	[3.1600000000E+04, 2.2699885418E+01, 5.1714643456E+00, 7.4069678832E+00, 2.6850688779E+00, 9.2839037527E-01],
	[3.1605000000E+04, 2.2705882756E+01, 5.1714630201E+00, 7.4107778642E+00, 2.6856529510E+00, 9.2842407528E-01],
	[3.1610000000E+04, 2.2711880729E+01, 5.1714616947E+00, 7.4145892008E+00, 2.6862369061E+00, 9.2845775852E-01],
	[3.1615000000E+04, 2.2717879338E+01, 5.1714603696E+00, 7.4184018934E+00, 2.6868207431E+00, 9.2849142500E-01],
	[3.1620000000E+04, 2.2723878582E+01, 5.1714590447E+00, 7.4222159422E+00, 2.6874044621E+00, 9.2852507473E-01],
	[3.1625000000E+04, 2.2729878461E+01, 5.1714577200E+00, 7.4260313474E+00, 2.6879880629E+00, 9.2855870771E-01],
	[3.1630000000E+04, 2.2735878976E+01, 5.1714563955E+00, 7.4298481094E+00, 2.6885715457E+00, 9.2859232395E-01],
	[3.1635000000E+04, 2.2741880126E+01, 5.1714550713E+00, 7.4336662284E+00, 2.6891549104E+00, 9.2862592347E-01],
	[3.1640000000E+04, 2.2747881911E+01, 5.1714537472E+00, 7.4374857047E+00, 2.6897381569E+00, 9.2865950626E-01],
	[3.1645000000E+04, 2.2753884331E+01, 5.1714524234E+00, 7.4413065385E+00, 2.6903212852E+00, 9.2869307234E-01],
	[3.1650000000E+04, 2.2759887386E+01, 5.1714510997E+00, 7.4451287302E+00, 2.6909042954E+00, 9.2872662172E-01],
	[3.1655000000E+04, 2.2765891076E+01, 5.1714497763E+00, 7.4489522799E+00, 2.6914871874E+00, 9.2876015440E-01],
	[3.1660000000E+04, 2.2771895402E+01, 5.1714484531E+00, 7.4527771879E+00, 2.6920699612E+00, 9.2879367040E-01],
	[3.1665000000E+04, 2.2777900363E+01, 5.1714471300E+00, 7.4566034546E+00, 2.6926526167E+00, 9.2882716971E-01],
	[3.1670000000E+04, 2.2783905958E+01, 5.1714458072E+00, 7.4604310801E+00, 2.6932351540E+00, 9.2886065236E-01],
	[3.1675000000E+04, 2.2789912189E+01, 5.1714444846E+00, 7.4642600648E+00, 2.6938175730E+00, 9.2889411834E-01],
	[3.1680000000E+04, 2.2795919054E+01, 5.1714431622E+00, 7.4680904090E+00, 2.6943998737E+00, 9.2892756767E-01],
	[3.1685000000E+04, 2.2801926555E+01, 5.1714418401E+00, 7.4719221127E+00, 2.6949820561E+00, 9.2896100035E-01],
	[3.1690000000E+04, 2.2807934690E+01, 5.1714405181E+00, 7.4757551765E+00, 2.6955641202E+00, 9.2899441640E-01],
	[3.1695000000E+04, 2.2813943460E+01, 5.1714391963E+00, 7.4795896004E+00, 2.6961460660E+00, 9.2902781581E-01],
	[3.1700000000E+04, 2.2819952865E+01, 5.1714378748E+00, 7.4834253849E+00, 2.6967278933E+00, 9.2906119860E-01],
	[3.1705000000E+04, 2.2825962905E+01, 5.1714365534E+00, 7.4872625301E+00, 2.6973096023E+00, 9.2909456478E-01],
	[3.1710000000E+04, 2.2831973579E+01, 5.1714352323E+00, 7.4911010363E+00, 2.6978911929E+00, 9.2912791436E-01],
	[3.1715000000E+04, 2.2837984888E+01, 5.1714339114E+00, 7.4949409038E+00, 2.6984726651E+00, 9.2916124734E-01],
	[3.1720000000E+04, 2.2843996832E+01, 5.1714325907E+00, 7.4987821329E+00, 2.6990540188E+00, 9.2919456373E-01],
	[3.1725000000E+04, 2.2850009410E+01, 5.1714312701E+00, 7.5026247237E+00, 2.6996352541E+00, 9.2922786353E-01],
	[3.1730000000E+04, 2.2856022624E+01, 5.1714299498E+00, 7.5064686767E+00, 2.7002163709E+00, 9.2926114677E-01],
	[3.1735000000E+04, 2.2862036471E+01, 5.1714286297E+00, 7.5103139920E+00, 2.7007973692E+00, 9.2929441345E-01],
	[3.1740000000E+04, 2.2868050953E+01, 5.1714273099E+00, 7.5141606700E+00, 2.7013782490E+00, 9.2932766357E-01],
	[3.1745000000E+04, 2.2874066070E+01, 5.1714259902E+00, 7.5180087108E+00, 2.7019590103E+00, 9.2936089714E-01],
	[3.1750000000E+04, 2.2880081821E+01, 5.1714246707E+00, 7.5218581148E+00, 2.7025396530E+00, 9.2939411417E-01],
	[3.1755000000E+04, 2.2886098207E+01, 5.1714233515E+00, 7.5257088823E+00, 2.7031201771E+00, 9.2942731467E-01],
	[3.1760000000E+04, 2.2892115227E+01, 5.1714220324E+00, 7.5295610134E+00, 2.7037005827E+00, 9.2946049865E-01],
	[3.1765000000E+04, 2.2898132882E+01, 5.1714207136E+00, 7.5334145085E+00, 2.7042808697E+00, 9.2949366612E-01],
	[3.1770000000E+04, 2.2904151170E+01, 5.1714193949E+00, 7.5372693678E+00, 2.7048610380E+00, 9.2952681708E-01],
	[3.1775000000E+04, 2.2910170094E+01, 5.1714180765E+00, 7.5411255916E+00, 2.7054410878E+00, 9.2955995154E-01],
	[3.1780000000E+04, 2.2916189651E+01, 5.1714167583E+00, 7.5449831802E+00, 2.7060210188E+00, 9.2959306951E-01],
	[3.1785000000E+04, 2.2922209843E+01, 5.1714154403E+00, 7.5488421338E+00, 2.7066008312E+00, 9.2962617100E-01],
	[3.1790000000E+04, 2.2928230668E+01, 5.1714141225E+00, 7.5527024527E+00, 2.7071805249E+00, 9.2965925602E-01],
	[3.1795000000E+04, 2.2934252129E+01, 5.1714128049E+00, 7.5565641372E+00, 2.7077600999E+00, 9.2969232458E-01],
	[3.1800000000E+04, 2.2940274223E+01, 5.1714114875E+00, 7.5604271875E+00, 2.7083395562E+00, 9.2972537667E-01],
	[3.1805000000E+04, 2.2946296951E+01, 5.1714101703E+00, 7.5642916040E+00, 2.7089188937E+00, 9.2975841232E-01],
	[3.1810000000E+04, 2.2952320313E+01, 5.1714088533E+00, 7.5681573868E+00, 2.7094981125E+00, 9.2979143153E-01],
	[3.1815000000E+04, 2.2958344310E+01, 5.1714075365E+00, 7.5720245362E+00, 2.7100772125E+00, 9.2982443431E-01],
	[3.1820000000E+04, 2.2964368940E+01, 5.1714062200E+00, 7.5758930526E+00, 2.7106561937E+00, 9.2985742066E-01],
	[3.1825000000E+04, 2.2970394205E+01, 5.1714049036E+00, 7.5797629361E+00, 2.7112350561E+00, 9.2989039060E-01],
	[3.1830000000E+04, 2.2976420103E+01, 5.1714035875E+00, 7.5836341870E+00, 2.7118137997E+00, 9.2992334413E-01],
	[3.1835000000E+04, 2.2982446636E+01, 5.1714022716E+00, 7.5875068057E+00, 2.7123924244E+00, 9.2995628126E-01],
	[3.1840000000E+04, 2.2988473802E+01, 5.1714009558E+00, 7.5913807924E+00, 2.7129709303E+00, 9.2998920201E-01],
	[3.1845000000E+04, 2.2994501602E+01, 5.1713996403E+00, 7.5952561473E+00, 2.7135493172E+00, 9.3002210636E-01],
	[3.1850000000E+04, 2.3000530036E+01, 5.1713983250E+00, 7.5991328707E+00, 2.7141275853E+00, 9.3005499435E-01],
	[3.1855000000E+04, 2.3006559104E+01, 5.1713970099E+00, 7.6030109629E+00, 2.7147057345E+00, 9.3008786597E-01],
	[3.1860000000E+04, 2.3012588805E+01, 5.1713956950E+00, 7.6068904241E+00, 2.7152837647E+00, 9.3012072123E-01],
	[3.1865000000E+04, 2.3018619140E+01, 5.1713943803E+00, 7.6107712547E+00, 2.7158616760E+00, 9.3015356014E-01],
	[3.1870000000E+04, 2.3024650109E+01, 5.1713930658E+00, 7.6146534549E+00, 2.7164394683E+00, 9.3018638271E-01],
	[3.1875000000E+04, 2.3030681711E+01, 5.1713917515E+00, 7.6185370249E+00, 2.7170171417E+00, 9.3021918895E-01],
	[3.1880000000E+04, 2.3036713948E+01, 5.1713904374E+00, 7.6224219650E+00, 2.7175946960E+00, 9.3025197886E-01],
	[3.1885000000E+04, 2.3042764722E+01, 5.1713917332E+00, 7.6263082755E+00, 2.7181731015E+00, 9.3028475246E-01],
	[3.1890000000E+04, 2.3048818589E+01, 5.1713933863E+00, 7.6301959567E+00, 2.7187515214E+00, 9.3031750975E-01],
	[3.1895000000E+04, 2.3054873097E+01, 5.1713950391E+00, 7.6340850088E+00, 2.7193298229E+00, 9.3035025074E-01],
	[3.1900000000E+04, 2.3060928246E+01, 5.1713966916E+00, 7.6379754321E+00, 2.7199080059E+00, 9.3038297543E-01],
	[3.1905000000E+04, 2.3066984036E+01, 5.1713983439E+00, 7.6418672268E+00, 2.7204860704E+00, 9.3041568384E-01],
	[3.1910000000E+04, 2.3073040466E+01, 5.1713999959E+00, 7.6457603933E+00, 2.7210640165E+00, 9.3044837598E-01],
	[3.1915000000E+04, 2.3079097538E+01, 5.1714016477E+00, 7.6496549318E+00, 2.7216418441E+00, 9.3048105185E-01],
	[3.1920000000E+04, 2.3085155251E+01, 5.1714032992E+00, 7.6535508425E+00, 2.7222195531E+00, 9.3051371146E-01],
	[3.1925000000E+04, 2.3091213604E+01, 5.1714049504E+00, 7.6574481258E+00, 2.7227971436E+00, 9.3054635482E-01],
	[3.1930000000E+04, 2.3097272598E+01, 5.1714066014E+00, 7.6613467819E+00, 2.7233746156E+00, 9.3057898193E-01],
	[3.1935000000E+04, 2.3103332233E+01, 5.1714082522E+00, 7.6652468110E+00, 2.7239519690E+00, 9.3061159282E-01],
	[3.1940000000E+04, 2.3109392509E+01, 5.1714099026E+00, 7.6691482135E+00, 2.7245292039E+00, 9.3064418747E-01],
	[3.1945000000E+04, 2.3115453426E+01, 5.1714115529E+00, 7.6730509896E+00, 2.7251063201E+00, 9.3067676589E-01],
	[3.1950000000E+04, 2.3121514983E+01, 5.1714132028E+00, 7.6769551395E+00, 2.7256833177E+00, 9.3070932811E-01],
	[3.1955000000E+04, 2.3127577180E+01, 5.1714148525E+00, 7.6808606636E+00, 2.7262601967E+00, 9.3074187411E-01],
	[3.1960000000E+04, 2.3133640018E+01, 5.1714165020E+00, 7.6847675621E+00, 2.7268369571E+00, 9.3077440391E-01],
	[3.1965000000E+04, 2.3139703497E+01, 5.1714181512E+00, 7.6886758353E+00, 2.7274135988E+00, 9.3080691752E-01],
	[3.1970000000E+04, 2.3145767616E+01, 5.1714198001E+00, 7.6925854834E+00, 2.7279901218E+00, 9.3083941494E-01],
	[3.1975000000E+04, 2.3151832376E+01, 5.1714214488E+00, 7.6964965067E+00, 2.7285665261E+00, 9.3087189619E-01],
	[3.1980000000E+04, 2.3157897777E+01, 5.1714230972E+00, 7.7004089056E+00, 2.7291428117E+00, 9.3090436126E-01],
	[3.1985000000E+04, 2.3163963817E+01, 5.1714247453E+00, 7.7043226801E+00, 2.7297189786E+00, 9.3093681016E-01],
	[3.1990000000E+04, 2.3170030498E+01, 5.1714263932E+00, 7.7082378307E+00, 2.7302950267E+00, 9.3096924291E-01],
	[3.1995000000E+04, 2.3176097820E+01, 5.1714280409E+00, 7.7121543576E+00, 2.7308709561E+00, 9.3100165950E-01],
	[3.2000000000E+04, 2.3182165781E+01, 5.1714296883E+00, 7.7160722610E+00, 2.7314467667E+00, 9.3103405996E-01],
	[3.2005000000E+04, 2.3188234384E+01, 5.1714313354E+00, 7.7199915412E+00, 2.7320224585E+00, 9.3106644427E-01],
	[3.2010000000E+04, 2.3194303626E+01, 5.1714329823E+00, 7.7239121986E+00, 2.7325980316E+00, 9.3109881246E-01],
	[3.2015000000E+04, 2.3200373508E+01, 5.1714346289E+00, 7.7278342333E+00, 2.7331734858E+00, 9.3113116452E-01],
	[3.2020000000E+04, 2.3206444031E+01, 5.1714362752E+00, 7.7317576456E+00, 2.7337488211E+00, 9.3116350047E-01],
	[3.2025000000E+04, 2.3212515194E+01, 5.1714379214E+00, 7.7356824358E+00, 2.7343240376E+00, 9.3119582031E-01],
	[3.2030000000E+04, 2.3218586997E+01, 5.1714395672E+00, 7.7396086042E+00, 2.7348991353E+00, 9.3122812405E-01],
	[3.2035000000E+04, 2.3224659440E+01, 5.1714412128E+00, 7.7435361510E+00, 2.7354741140E+00, 9.3126041170E-01],
	[3.2040000000E+04, 2.3230732523E+01, 5.1714428581E+00, 7.7474650765E+00, 2.7360489739E+00, 9.3129268325E-01],
	[3.2045000000E+04, 2.3236806247E+01, 5.1714445032E+00, 7.7513953809E+00, 2.7366237149E+00, 9.3132493874E-01],
	[3.2050000000E+04, 2.3242880610E+01, 5.1714461480E+00, 7.7553270646E+00, 2.7371983369E+00, 9.3135717814E-01],
	[3.2055000000E+04, 2.3248955613E+01, 5.1714477926E+00, 7.7592601278E+00, 2.7377728400E+00, 9.3138940149E-01],
	[3.2060000000E+04, 2.3255031256E+01, 5.1714494369E+00, 7.7631945708E+00, 2.7383472241E+00, 9.3142160877E-01],
	[3.2065000000E+04, 2.3261107539E+01, 5.1714510810E+00, 7.7671303938E+00, 2.7389214892E+00, 9.3145380001E-01],
	[3.2070000000E+04, 2.3267184462E+01, 5.1714527248E+00, 7.7710675971E+00, 2.7394956354E+00, 9.3148597520E-01],
	[3.2075000000E+04, 2.3273262025E+01, 5.1714543683E+00, 7.7750061810E+00, 2.7400696625E+00, 9.3151813436E-01],
	[3.2080000000E+04, 2.3279340228E+01, 5.1714560116E+00, 7.7789461458E+00, 2.7406435707E+00, 9.3155027749E-01],
	[3.2085000000E+04, 2.3285419070E+01, 5.1714576546E+00, 7.7828874916E+00, 2.7412173598E+00, 9.3158240459E-01],
	[3.2090000000E+04, 2.3291498552E+01, 5.1714592974E+00, 7.7868302189E+00, 2.7417910298E+00, 9.3161451569E-01],
	[3.2095000000E+04, 2.3297578674E+01, 5.1714609399E+00, 7.7907743278E+00, 2.7423645808E+00, 9.3164661077E-01],
	[3.2100000000E+04, 2.3303659436E+01, 5.1714625822E+00, 7.7947198186E+00, 2.7429380127E+00, 9.3167868986E-01],
	[3.2105000000E+04, 2.3309740837E+01, 5.1714642242E+00, 7.7986666915E+00, 2.7435113255E+00, 9.3171075295E-01],
	[3.2110000000E+04, 2.3315822877E+01, 5.1714658659E+00, 7.8026149470E+00, 2.7440845192E+00, 9.3174280006E-01],
	[3.2115000000E+04, 2.3321905558E+01, 5.1714675074E+00, 7.8065645851E+00, 2.7446575938E+00, 9.3177483118E-01],
	[3.2120000000E+04, 2.3327988878E+01, 5.1714691487E+00, 7.8105156063E+00, 2.7452305493E+00, 9.3180684634E-01],
	[3.2125000000E+04, 2.3334072837E+01, 5.1714707897E+00, 7.8144680107E+00, 2.7458033855E+00, 9.3183884553E-01],
	[3.2130000000E+04, 2.3340157436E+01, 5.1714724304E+00, 7.8184217986E+00, 2.7463761027E+00, 9.3187082877E-01],
	[3.2135000000E+04, 2.3346242674E+01, 5.1714740709E+00, 7.8223769704E+00, 2.7469487006E+00, 9.3190279606E-01],
	[3.2140000000E+04, 2.3352328552E+01, 5.1714757111E+00, 7.8263335262E+00, 2.7475211794E+00, 9.3193474740E-01],
	[3.2145000000E+04, 2.3358415069E+01, 5.1714773511E+00, 7.8302914663E+00, 2.7480935389E+00, 9.3196668281E-01],
	[3.2150000000E+04, 2.3364502226E+01, 5.1714789908E+00, 7.8342507910E+00, 2.7486657792E+00, 9.3199860230E-01],
	[3.2155000000E+04, 2.3370590022E+01, 5.1714806303E+00, 7.8382115007E+00, 2.7492379003E+00, 9.3203050586E-01],
	[3.2160000000E+04, 2.3376678457E+01, 5.1714822695E+00, 7.8421735954E+00, 2.7498099021E+00, 9.3206239351E-01],
	[3.2165000000E+04, 2.3382767531E+01, 5.1714839084E+00, 7.8461370755E+00, 2.7503817846E+00, 9.3209426525E-01],
	[3.2170000000E+04, 2.3388857245E+01, 5.1714855471E+00, 7.8501019414E+00, 2.7509535479E+00, 9.3212612109E-01],
	[3.2175000000E+04, 2.3394947598E+01, 5.1714871856E+00, 7.8540681931E+00, 2.7515251919E+00, 9.3215796104E-01],
	[3.2180000000E+04, 2.3401038590E+01, 5.1714888238E+00, 7.8580358311E+00, 2.7520967165E+00, 9.3218978511E-01],
	[3.2185000000E+04, 2.3407130221E+01, 5.1714904617E+00, 7.8620048556E+00, 2.7526681219E+00, 9.3222159330E-01],
	[3.2190000000E+04, 2.3413222491E+01, 5.1714920994E+00, 7.8659752668E+00, 2.7532394079E+00, 9.3225338562E-01],
	[3.2195000000E+04, 2.3419315400E+01, 5.1714937368E+00, 7.8699470650E+00, 2.7538105745E+00, 9.3228516208E-01],
	[3.2200000000E+04, 2.3425408949E+01, 5.1714953740E+00, 7.8739202505E+00, 2.7543816218E+00, 9.3231692268E-01],
	[3.2205000000E+04, 2.3431503136E+01, 5.1714970109E+00, 7.8778948236E+00, 2.7549525497E+00, 9.3234866743E-01],
	[3.2210000000E+04, 2.3437597962E+01, 5.1714986476E+00, 7.8818707844E+00, 2.7555233582E+00, 9.3238039635E-01],
	[3.2215000000E+04, 2.3443693427E+01, 5.1715002840E+00, 7.8858481334E+00, 2.7560940473E+00, 9.3241210942E-01],
	[3.2220000000E+04, 2.3449789531E+01, 5.1715019201E+00, 7.8898268708E+00, 2.7566646170E+00, 9.3244380668E-01],
	[3.2225000000E+04, 2.3455886274E+01, 5.1715035560E+00, 7.8938069967E+00, 2.7572350672E+00, 9.3247548811E-01],
	[3.2230000000E+04, 2.3461983656E+01, 5.1715051917E+00, 7.8977885116E+00, 2.7578053980E+00, 9.3250715373E-01],
	[3.2235000000E+04, 2.3468081677E+01, 5.1715068271E+00, 7.9017714156E+00, 2.7583756094E+00, 9.3253880355E-01],
	[3.2240000000E+04, 2.3474180336E+01, 5.1715084622E+00, 7.9057557091E+00, 2.7589457012E+00, 9.3257043757E-01],
	[3.2245000000E+04, 2.3480279634E+01, 5.1715100971E+00, 7.9097413922E+00, 2.7595156736E+00, 9.3260205579E-01],
	[3.2250000000E+04, 2.3486379571E+01, 5.1715117318E+00, 7.9137284654E+00, 2.7600855264E+00, 9.3263365824E-01],
	[3.2255000000E+04, 2.3492480147E+01, 5.1715133662E+00, 7.9177169288E+00, 2.7606552598E+00, 9.3266524491E-01],
	[3.2260000000E+04, 2.3498581361E+01, 5.1715150003E+00, 7.9217067826E+00, 2.7612248736E+00, 9.3269681581E-01],
	[3.2265000000E+04, 2.3504683214E+01, 5.1715166342E+00, 7.9256980273E+00, 2.7617943679E+00, 9.3272837095E-01],
	[3.2270000000E+04, 2.3510785705E+01, 5.1715182678E+00, 7.9296906630E+00, 2.7623637426E+00, 9.3275991033E-01],
	[3.2275000000E+04, 2.3516888835E+01, 5.1715199012E+00, 7.9336846900E+00, 2.7629329977E+00, 9.3279143397E-01],
	[3.2280000000E+04, 2.3522992604E+01, 5.1715215343E+00, 7.9376801086E+00, 2.7635021333E+00, 9.3282294187E-01],
	[3.2285000000E+04, 2.3529097011E+01, 5.1715231672E+00, 7.9416769191E+00, 2.7640711493E+00, 9.3285443404E-01],
	[3.2290000000E+04, 2.3535202056E+01, 5.1715247998E+00, 7.9456751217E+00, 2.7646400456E+00, 9.3288591048E-01],
	[3.2295000000E+04, 2.3541307740E+01, 5.1715264322E+00, 7.9496747166E+00, 2.7652088224E+00, 9.3291737120E-01],
	[3.2300000000E+04, 2.3547414062E+01, 5.1715280643E+00, 7.9536757043E+00, 2.7657774795E+00, 9.3294881622E-01],
	[3.2305000000E+04, 2.3553521023E+01, 5.1715296962E+00, 7.9576780848E+00, 2.7663460169E+00, 9.3298024553E-01],
	[3.2310000000E+04, 2.3559628622E+01, 5.1715313278E+00, 7.9616818586E+00, 2.7669144347E+00, 9.3301165914E-01],
	[3.2315000000E+04, 2.3565736859E+01, 5.1715329591E+00, 7.9656870258E+00, 2.7674827329E+00, 9.3304305707E-01],
	[3.2320000000E+04, 2.3571845734E+01, 5.1715345902E+00, 7.9696935867E+00, 2.7680509113E+00, 9.3307443931E-01],
	[3.2325000000E+04, 2.3577955248E+01, 5.1715362211E+00, 7.9737015417E+00, 2.7686189700E+00, 9.3310580588E-01],
	[3.2330000000E+04, 2.3584065400E+01, 5.1715378517E+00, 7.9777108909E+00, 2.7691869090E+00, 9.3313715678E-01],
	[3.2335000000E+04, 2.3590176190E+01, 5.1715394821E+00, 7.9817216346E+00, 2.7697547283E+00, 9.3316849202E-01],
	[3.2340000000E+04, 2.3596287618E+01, 5.1715411122E+00, 7.9857337732E+00, 2.7703224279E+00, 9.3319981161E-01],
	[3.2345000000E+04, 2.3602399684E+01, 5.1715427420E+00, 7.9897473069E+00, 2.7708900077E+00, 9.3323111556E-01],
	[3.2350000000E+04, 2.3608512389E+01, 5.1715443716E+00, 7.9937622358E+00, 2.7714574678E+00, 9.3326240387E-01],
	[3.2355000000E+04, 2.3614625731E+01, 5.1715460010E+00, 7.9977785604E+00, 2.7720248080E+00, 9.3329367654E-01],
	[3.2360000000E+04, 2.3620739712E+01, 5.1715476301E+00, 8.0017962809E+00, 2.7725920285E+00, 9.3332493360E-01],
	[3.2365000000E+04, 2.3626854330E+01, 5.1715492589E+00, 8.0058153976E+00, 2.7731591292E+00, 9.3335617503E-01],
	[3.2370000000E+04, 2.3632969586E+01, 5.1715508875E+00, 8.0098359106E+00, 2.7737261101E+00, 9.3338740086E-01],
	[3.2375000000E+04, 2.3639085480E+01, 5.1715525158E+00, 8.0138578204E+00, 2.7742929711E+00, 9.3341861109E-01],
	[3.2380000000E+04, 2.3645202013E+01, 5.1715541439E+00, 8.0178811271E+00, 2.7748597123E+00, 9.3344980572E-01],
	[3.2385000000E+04, 2.3651319183E+01, 5.1715557718E+00, 8.0219058310E+00, 2.7754263337E+00, 9.3348098477E-01],
	[3.2390000000E+04, 2.3657436990E+01, 5.1715573994E+00, 8.0259319325E+00, 2.7759928352E+00, 9.3351214823E-01],
	[3.2395000000E+04, 2.3663560121E+01, 5.1715597031E+00, 8.0299594317E+00, 2.7765594763E+00, 9.3354329613E-01],
	[3.2400000000E+04, 2.3669699347E+01, 5.1715642369E+00, 8.0339883289E+00, 2.7771268536E+00, 9.3357442846E-01],
	[3.2405000000E+04, 2.3675839218E+01, 5.1715687701E+00, 8.0380189115E+00, 2.7776941459E+00, 9.3360554523E-01],
	[3.2410000000E+04, 2.3681979734E+01, 5.1715733026E+00, 8.0420517105E+00, 2.7782614165E+00, 9.3363664645E-01],
	[3.2415000000E+04, 2.3688120896E+01, 5.1715778344E+00, 8.0460859093E+00, 2.7788285676E+00, 9.3366773212E-01],
	[3.2420000000E+04, 2.3694262702E+01, 5.1715823655E+00, 8.0501215083E+00, 2.7793955994E+00, 9.3369880226E-01],
	[3.2425000000E+04, 2.3700405152E+01, 5.1715868959E+00, 8.0541585076E+00, 2.7799625119E+00, 9.3372985687E-01],
	[3.2430000000E+04, 2.3706548248E+01, 5.1715914256E+00, 8.0581969075E+00, 2.7805293049E+00, 9.3376089596E-01],
	[3.2435000000E+04, 2.3712691989E+01, 5.1715959546E+00, 8.0622367084E+00, 2.7810959785E+00, 9.3379191954E-01],
	[3.2440000000E+04, 2.3718836374E+01, 5.1716004829E+00, 8.0662779104E+00, 2.7816625326E+00, 9.3382292761E-01],
	[3.2445000000E+04, 2.3724981405E+01, 5.1716050105E+00, 8.0703205139E+00, 2.7822289673E+00, 9.3385392018E-01],
	[3.2450000000E+04, 2.3731127080E+01, 5.1716095374E+00, 8.0743645191E+00, 2.7827952826E+00, 9.3388489726E-01],
	[3.2455000000E+04, 2.3737273399E+01, 5.1716140637E+00, 8.0784099263E+00, 2.7833614784E+00, 9.3391585885E-01],
	[3.2460000000E+04, 2.3743420364E+01, 5.1716185892E+00, 8.0824567357E+00, 2.7839275548E+00, 9.3394680496E-01],
	[3.2465000000E+04, 2.3749567973E+01, 5.1716231140E+00, 8.0865049477E+00, 2.7844935116E+00, 9.3397773560E-01],
	[3.2470000000E+04, 2.3755716227E+01, 5.1716276382E+00, 8.0905545625E+00, 2.7850593490E+00, 9.3400865079E-01],
	[3.2475000000E+04, 2.3761865125E+01, 5.1716321616E+00, 8.0946055804E+00, 2.7856250668E+00, 9.3403955051E-01],
	[3.2480000000E+04, 2.3768014668E+01, 5.1716366844E+00, 8.0986580015E+00, 2.7861906651E+00, 9.3407043479E-01],
	[3.2485000000E+04, 2.3774164855E+01, 5.1716412065E+00, 8.1027118263E+00, 2.7867561439E+00, 9.3410130362E-01],
	[3.2490000000E+04, 2.3780315687E+01, 5.1716457279E+00, 8.1067670550E+00, 2.7873215032E+00, 9.3413215702E-01],
	[3.2495000000E+04, 2.3786467164E+01, 5.1716502486E+00, 8.1108236878E+00, 2.7878867428E+00, 9.3416299499E-01],
	[3.2500000000E+04, 2.3792619285E+01, 5.1716547686E+00, 8.1148817250E+00, 2.7884518630E+00, 9.3419381755E-01],
	[3.2505000000E+04, 2.3798772050E+01, 5.1716592879E+00, 8.1189411669E+00, 2.7890168635E+00, 9.3422462469E-01],
	[3.2510000000E+04, 2.3804925459E+01, 5.1716638065E+00, 8.1230020138E+00, 2.7895817444E+00, 9.3425541643E-01],
	[3.2515000000E+04, 2.3811079513E+01, 5.1716683244E+00, 8.1270642659E+00, 2.7901465058E+00, 9.3428619276E-01],
	[3.2520000000E+04, 2.3817234212E+01, 5.1716728416E+00, 8.1311279235E+00, 2.7907111475E+00, 9.3431695371E-01],
	[3.2525000000E+04, 2.3823389554E+01, 5.1716773582E+00, 8.1351929868E+00, 2.7912756696E+00, 9.3434769928E-01],
	[3.2530000000E+04, 2.3829545541E+01, 5.1716818740E+00, 8.1392594562E+00, 2.7918400721E+00, 9.3437842947E-01],
	[3.2535000000E+04, 2.3835702172E+01, 5.1716863892E+00, 8.1433273319E+00, 2.7924043549E+00, 9.3440914429E-01],
	[3.2540000000E+04, 2.3841859447E+01, 5.1716909037E+00, 8.1473966141E+00, 2.7929685181E+00, 9.3443984375E-01],
	[3.2545000000E+04, 2.3848017367E+01, 5.1716954175E+00, 8.1514673032E+00, 2.7935325616E+00, 9.3447052786E-01],
	[3.2550000000E+04, 2.3854175930E+01, 5.1716999306E+00, 8.1555393994E+00, 2.7940964854E+00, 9.3450119662E-01],
	[3.2555000000E+04, 2.3860335138E+01, 5.1717044430E+00, 8.1596129030E+00, 2.7946602895E+00, 9.3453185004E-01],
	[3.2560000000E+04, 2.3866494989E+01, 5.1717089547E+00, 8.1636878143E+00, 2.7952239740E+00, 9.3456248813E-01],
	[3.2565000000E+04, 2.3872655485E+01, 5.1717134657E+00, 8.1677641334E+00, 2.7957875387E+00, 9.3459311089E-01],
	[3.2570000000E+04, 2.3878816625E+01, 5.1717179760E+00, 8.1718418608E+00, 2.7963509837E+00, 9.3462371834E-01],
	[3.2575000000E+04, 2.3884978408E+01, 5.1717224857E+00, 8.1759209966E+00, 2.7969143089E+00, 9.3465431047E-01],
	[3.2580000000E+04, 2.3891140836E+01, 5.1717269947E+00, 8.1800015411E+00, 2.7974775144E+00, 9.3468488731E-01],
	[3.2585000000E+04, 2.3897303907E+01, 5.1717315029E+00, 8.1840834946E+00, 2.7980406002E+00, 9.3471544884E-01],
	[3.2590000000E+04, 2.3903467623E+01, 5.1717360105E+00, 8.1881668574E+00, 2.7986035662E+00, 9.3474599509E-01],
	[3.2595000000E+04, 2.3909631982E+01, 5.1717405174E+00, 8.1922516298E+00, 2.7991664124E+00, 9.3477652606E-01],
	[3.2600000000E+04, 2.3915796985E+01, 5.1717450236E+00, 8.1963378119E+00, 2.7997291388E+00, 9.3480704176E-01],
	[3.2605000000E+04, 2.3921962631E+01, 5.1717495292E+00, 8.2004254041E+00, 2.8002917454E+00, 9.3483754219E-01],
	[3.2610000000E+04, 2.3928128922E+01, 5.1717540340E+00, 8.2045144067E+00, 2.8008542322E+00, 9.3486802736E-01],
	[3.2615000000E+04, 2.3934295856E+01, 5.1717585381E+00, 8.2086048199E+00, 2.8014165992E+00, 9.3489849728E-01],
	[3.2620000000E+04, 2.3940463434E+01, 5.1717630416E+00, 8.2126966440E+00, 2.8019788464E+00, 9.3492895195E-01],
	[3.2625000000E+04, 2.3946631656E+01, 5.1717675444E+00, 8.2167898792E+00, 2.8025409737E+00, 9.3495939139E-01],
	[3.2630000000E+04, 2.3952800521E+01, 5.1717720465E+00, 8.2208845259E+00, 2.8031029812E+00, 9.3498981559E-01],
	[3.2635000000E+04, 2.3958970029E+01, 5.1717765479E+00, 8.2249805842E+00, 2.8036648688E+00, 9.3502022458E-01],
	[3.2640000000E+04, 2.3965140182E+01, 5.1717810486E+00, 8.2290780545E+00, 2.8042266366E+00, 9.3505061835E-01],
	[3.2645000000E+04, 2.3971310978E+01, 5.1717855486E+00, 8.2331769371E+00, 2.8047882844E+00, 9.3508099691E-01],
	[3.2650000000E+04, 2.3977482417E+01, 5.1717900480E+00, 8.2372772322E+00, 2.8053498124E+00, 9.3511136027E-01],
	[3.2655000000E+04, 2.3983654500E+01, 5.1717945466E+00, 8.2413789400E+00, 2.8059112204E+00, 9.3514170843E-01],
	[3.2660000000E+04, 2.3989827226E+01, 5.1717990446E+00, 8.2454820609E+00, 2.8064725086E+00, 9.3517204142E-01],
	[3.2665000000E+04, 2.3996000595E+01, 5.1718035419E+00, 8.2495865951E+00, 2.8070336768E+00, 9.3520235922E-01],
	[3.2670000000E+04, 2.4002174608E+01, 5.1718080385E+00, 8.2536925429E+00, 2.8075947251E+00, 9.3523266185E-01],
	[3.2675000000E+04, 2.4008349265E+01, 5.1718125345E+00, 8.2577999045E+00, 2.8081556535E+00, 9.3526294932E-01],
	[3.2680000000E+04, 2.4014524564E+01, 5.1718170297E+00, 8.2619086803E+00, 2.8087164619E+00, 9.3529322163E-01],
	[3.2685000000E+04, 2.4020700507E+01, 5.1718215243E+00, 8.2660188705E+00, 2.8092771504E+00, 9.3532347879E-01],
	[3.2690000000E+04, 2.4026877093E+01, 5.1718260181E+00, 8.2701304753E+00, 2.8098377188E+00, 9.3535372080E-01],
	[3.2695000000E+04, 2.4033054323E+01, 5.1718305113E+00, 8.2742434951E+00, 2.8103981673E+00, 9.3538394769E-01],
	[3.2700000000E+04, 2.4039232195E+01, 5.1718350038E+00, 8.2783579300E+00, 2.8109584958E+00, 9.3541415944E-01],
	[3.2705000000E+04, 2.4045410711E+01, 5.1718394957E+00, 8.2824737805E+00, 2.8115187043E+00, 9.3544435608E-01],
	[3.2710000000E+04, 2.4051589870E+01, 5.1718439868E+00, 8.2865910467E+00, 2.8120787928E+00, 9.3547453760E-01],
	[3.2715000000E+04, 2.4057769671E+01, 5.1718484773E+00, 8.2907097289E+00, 2.8126387613E+00, 9.3550470402E-01],
	[3.2720000000E+04, 2.4063950116E+01, 5.1718529670E+00, 8.2948298274E+00, 2.8131986097E+00, 9.3553485534E-01],
	[3.2725000000E+04, 2.4070131204E+01, 5.1718574561E+00, 8.2989513424E+00, 2.8137583381E+00, 9.3556499156E-01],
	[3.2730000000E+04, 2.4076312935E+01, 5.1718619445E+00, 8.3030742743E+00, 2.8143179465E+00, 9.3559511271E-01],
	[3.2735000000E+04, 2.4082495309E+01, 5.1718664323E+00, 8.3071986233E+00, 2.8148774348E+00, 9.3562521877E-01],
	[3.2740000000E+04, 2.4088678326E+01, 5.1718709193E+00, 8.3113243896E+00, 2.8154368030E+00, 9.3565530977E-01],
	[3.2745000000E+04, 2.4094861986E+01, 5.1718754057E+00, 8.3154515736E+00, 2.8159960512E+00, 9.3568538571E-01],
	[3.2750000000E+04, 2.4101046288E+01, 5.1718798914E+00, 8.3195801754E+00, 2.8165551792E+00, 9.3571544659E-01],
	[3.2755000000E+04, 2.4107231234E+01, 5.1718843764E+00, 8.3237101955E+00, 2.8171141872E+00, 9.3574549242E-01],
	[3.2760000000E+04, 2.4113416822E+01, 5.1718888607E+00, 8.3278416340E+00, 2.8176730751E+00, 9.3577552322E-01],
	[3.2765000000E+04, 2.4119603053E+01, 5.1718933444E+00, 8.3319744912E+00, 2.8182318428E+00, 9.3580553898E-01],
	[3.2770000000E+04, 2.4125789926E+01, 5.1718978273E+00, 8.3361087674E+00, 2.8187904905E+00, 9.3583553971E-01],
	[3.2775000000E+04, 2.4131977443E+01, 5.1719023096E+00, 8.3402444628E+00, 2.8193490180E+00, 9.3586552543E-01],
	[3.2780000000E+04, 2.4138165602E+01, 5.1719067912E+00, 8.3443815778E+00, 2.8199074253E+00, 9.3589549614E-01],
	[3.2785000000E+04, 2.4144354404E+01, 5.1719112721E+00, 8.3485201126E+00, 2.8204657125E+00, 9.3592545184E-01],
	[3.2790000000E+04, 2.4150543848E+01, 5.1719157524E+00, 8.3526600674E+00, 2.8210238796E+00, 9.3595539255E-01],
	[3.2795000000E+04, 2.4156733935E+01, 5.1719202320E+00, 8.3568014426E+00, 2.8215819265E+00, 9.3598531827E-01],
	[3.2800000000E+04, 2.4162924664E+01, 5.1719247108E+00, 8.3609442384E+00, 2.8221398532E+00, 9.3601522900E-01],
	[3.2805000000E+04, 2.4169116036E+01, 5.1719291891E+00, 8.3650884550E+00, 2.8226976597E+00, 9.3604512477E-01],
	[3.2810000000E+04, 2.4175308051E+01, 5.1719336666E+00, 8.3692340928E+00, 2.8232553460E+00, 9.3607500556E-01],
	[3.2815000000E+04, 2.4181500708E+01, 5.1719381434E+00, 8.3733811520E+00, 2.8238129121E+00, 9.3610487140E-01],
	[3.2820000000E+04, 2.4187694007E+01, 5.1719426196E+00, 8.3775296330E+00, 2.8243703580E+00, 9.3613472228E-01],
	[3.2825000000E+04, 2.4193887949E+01, 5.1719470951E+00, 8.3816795358E+00, 2.8249276837E+00, 9.3616455822E-01],
	[3.2830000000E+04, 2.4200082533E+01, 5.1719515699E+00, 8.3858308609E+00, 2.8254848892E+00, 9.3619437922E-01],
	[3.2835000000E+04, 2.4206277760E+01, 5.1719560441E+00, 8.3899836085E+00, 2.8260419744E+00, 9.3622418529E-01],
	[3.2840000000E+04, 2.4212473628E+01, 5.1719605175E+00, 8.3941377789E+00, 2.8265989394E+00, 9.3625397644E-01],
	[3.2845000000E+04, 2.4218670139E+01, 5.1719649903E+00, 8.3982933722E+00, 2.8271557841E+00, 9.3628375267E-01],
	[3.2850000000E+04, 2.4224867293E+01, 5.1719694624E+00, 8.4024503890E+00, 2.8277125085E+00, 9.3631351399E-01],
	[3.2855000000E+04, 2.4231065088E+01, 5.1719739339E+00, 8.4066088292E+00, 2.8282691127E+00, 9.3634326042E-01],
	[3.2860000000E+04, 2.4237263526E+01, 5.1719784046E+00, 8.4107686934E+00, 2.8288255966E+00, 9.3637299194E-01],
	[3.2865000000E+04, 2.4243462606E+01, 5.1719828747E+00, 8.4149299816E+00, 2.8293819602E+00, 9.3640270858E-01],
	[3.2870000000E+04, 2.4249662328E+01, 5.1719873441E+00, 8.4190926943E+00, 2.8299382036E+00, 9.3643241035E-01],
	[3.2875000000E+04, 2.4255862692E+01, 5.1719918128E+00, 8.4232568316E+00, 2.8304943266E+00, 9.3646209724E-01],
	[3.2880000000E+04, 2.4262063698E+01, 5.1719962809E+00, 8.4274223938E+00, 2.8310503293E+00, 9.3649176926E-01],
	[3.2885000000E+04, 2.4268265346E+01, 5.1720007483E+00, 8.4315893812E+00, 2.8316062116E+00, 9.3652142643E-01],
	[3.2890000000E+04, 2.4274467636E+01, 5.1720052150E+00, 8.4357577941E+00, 2.8321619737E+00, 9.3655106875E-01],
	[3.2895000000E+04, 2.4280670568E+01, 5.1720096810E+00, 8.4399276328E+00, 2.8327176154E+00, 9.3658069622E-01],
	[3.2900000000E+04, 2.4286874142E+01, 5.1720141463E+00, 8.4440988974E+00, 2.8332731368E+00, 9.3661030886E-01],
	[3.2905000000E+04, 2.4293078358E+01, 5.1720186110E+00, 8.4482715883E+00, 2.8338285378E+00, 9.3663990667E-01],
	[3.2910000000E+04, 2.4299283215E+01, 5.1720230750E+00, 8.4524457058E+00, 2.8343838184E+00, 9.3666948966E-01],
	[3.2915000000E+04, 2.4305488715E+01, 5.1720275383E+00, 8.4566212501E+00, 2.8349389787E+00, 9.3669905784E-01],
	[3.2920000000E+04, 2.4311713447E+01, 5.1720346591E+00, 8.4607982215E+00, 2.8354950704E+00, 9.3672861121E-01],
	[3.2925000000E+04, 2.4317940157E+01, 5.1720419686E+00, 8.4649766203E+00, 2.8360511174E+00, 9.3675814978E-01],
	[3.2930000000E+04, 2.4324167515E+01, 5.1720492771E+00, 8.4691564467E+00, 2.8366070446E+00, 9.3678767355E-01],
	[3.2935000000E+04, 2.4330395522E+01, 5.1720565844E+00, 8.4733377010E+00, 2.8371628520E+00, 9.3681718255E-01],
	[3.2940000000E+04, 2.4336624178E+01, 5.1720638907E+00, 8.4775203835E+00, 2.8377185395E+00, 9.3684667677E-01],
	[3.2945000000E+04, 2.4342853483E+01, 5.1720711958E+00, 8.4817044944E+00, 2.8382741072E+00, 9.3687615621E-01],
	[3.2950000000E+04, 2.4349083437E+01, 5.1720784999E+00, 8.4858900341E+00, 2.8388295550E+00, 9.3690562090E-01],
	[3.2955000000E+04, 2.4355314039E+01, 5.1720858029E+00, 8.4900770027E+00, 2.8393848830E+00, 9.3693507083E-01],
	[3.2960000000E+04, 2.4361545290E+01, 5.1720931047E+00, 8.4942654006E+00, 2.8399400911E+00, 9.3696450601E-01],
	[3.2965000000E+04, 2.4367777190E+01, 5.1721004055E+00, 8.4984552280E+00, 2.8404951793E+00, 9.3699392645E-01],
	[3.2970000000E+04, 2.4374009738E+01, 5.1721077051E+00, 8.5026464852E+00, 2.8410501476E+00, 9.3702333216E-01],
	[3.2975000000E+04, 2.4380242935E+01, 5.1721150037E+00, 8.5068391725E+00, 2.8416049961E+00, 9.3705272314E-01],
	[3.2980000000E+04, 2.4386476781E+01, 5.1721223012E+00, 8.5110332901E+00, 2.8421597246E+00, 9.3708209940E-01],
	[3.2985000000E+04, 2.4392711275E+01, 5.1721295976E+00, 8.5152288383E+00, 2.8427143332E+00, 9.3711146095E-01],
	[3.2990000000E+04, 2.4398946418E+01, 5.1721368928E+00, 8.5194258174E+00, 2.8432688219E+00, 9.3714080780E-01],
	[3.2995000000E+04, 2.4405182209E+01, 5.1721441870E+00, 8.5236242276E+00, 2.8438231907E+00, 9.3717013995E-01],
	[3.3000000000E+04, 2.4411418649E+01, 5.1721514801E+00, 8.5278240693E+00, 2.8443774396E+00, 9.3719945741E-01],
	[3.3005000000E+04, 2.4417655737E+01, 5.1721587721E+00, 8.5320253427E+00, 2.8449315685E+00, 9.3722876019E-01],
	[3.3010000000E+04, 2.4423893473E+01, 5.1721660630E+00, 8.5362280480E+00, 2.8454855775E+00, 9.3725804829E-01],
	[3.3015000000E+04, 2.4430131858E+01, 5.1721733528E+00, 8.5404321856E+00, 2.8460394665E+00, 9.3728732172E-01],
	[3.3020000000E+04, 2.4436370891E+01, 5.1721806415E+00, 8.5446377556E+00, 2.8465932356E+00, 9.3731658050E-01],
	[3.3025000000E+04, 2.4442610573E+01, 5.1721879292E+00, 8.5488447584E+00, 2.8471468847E+00, 9.3734582462E-01],
	[3.3030000000E+04, 2.4448850903E+01, 5.1721952157E+00, 8.5530531943E+00, 2.8477004138E+00, 9.3737505410E-01],
	[3.3035000000E+04, 2.4455091881E+01, 5.1722025011E+00, 8.5572630635E+00, 2.8482538229E+00, 9.3740426893E-01],
	[3.3040000000E+04, 2.4461333507E+01, 5.1722097855E+00, 8.5614743663E+00, 2.8488071121E+00, 9.3743346914E-01],
	[3.3045000000E+04, 2.4467575782E+01, 5.1722170687E+00, 8.5656871029E+00, 2.8493602812E+00, 9.3746265472E-01],
	[3.3050000000E+04, 2.4473818704E+01, 5.1722243509E+00, 8.5699012737E+00, 2.8499133304E+00, 9.3749182568E-01],
	[3.3055000000E+04, 2.4480062275E+01, 5.1722316319E+00, 8.5741168788E+00, 2.8504662595E+00, 9.3752098204E-01],
	[3.3060000000E+04, 2.4486306494E+01, 5.1722389119E+00, 8.5783339187E+00, 2.8510190686E+00, 9.3755012379E-01],
	[3.3065000000E+04, 2.4492551361E+01, 5.1722461908E+00, 8.5825523934E+00, 2.8515717577E+00, 9.3757925095E-01],
	[3.3070000000E+04, 2.4498796876E+01, 5.1722534686E+00, 8.5867723034E+00, 2.8521243268E+00, 9.3760836352E-01],
	[3.3075000000E+04, 2.4505043039E+01, 5.1722607453E+00, 8.5909936489E+00, 2.8526767758E+00, 9.3763746151E-01],
	[3.3080000000E+04, 2.4511289850E+01, 5.1722680209E+00, 8.5952164301E+00, 2.8532291048E+00, 9.3766654493E-01],
	[3.3085000000E+04, 2.4517537309E+01, 5.1722752954E+00, 8.5994406473E+00, 2.8537813137E+00, 9.3769561378E-01],
	[3.3090000000E+04, 2.4523785416E+01, 5.1722825689E+00, 8.6036663008E+00, 2.8543334026E+00, 9.3772466807E-01],
	[3.3095000000E+04, 2.4530034171E+01, 5.1722898412E+00, 8.6078933909E+00, 2.8548853714E+00, 9.3775370781E-01],
	[3.3100000000E+04, 2.4536283573E+01, 5.1722971125E+00, 8.6121219178E+00, 2.8554372201E+00, 9.3778273301E-01],
	[3.3105000000E+04, 2.4542533624E+01, 5.1723043827E+00, 8.6163518818E+00, 2.8559889488E+00, 9.3781174367E-01],
	[3.3110000000E+04, 2.4548784322E+01, 5.1723116517E+00, 8.6205832832E+00, 2.8565405573E+00, 9.3784073980E-01],
	[3.3115000000E+04, 2.4555035668E+01, 5.1723189197E+00, 8.6248161223E+00, 2.8570920458E+00, 9.3786972141E-01],
	[3.3120000000E+04, 2.4561287662E+01, 5.1723261867E+00, 8.6290503992E+00, 2.8576434142E+00, 9.3789868851E-01],
	[3.3125000000E+04, 2.4567540303E+01, 5.1723334525E+00, 8.6332861144E+00, 2.8581946624E+00, 9.3792764109E-01],
	[3.3130000000E+04, 2.4573793592E+01, 5.1723407172E+00, 8.6375232680E+00, 2.8587457906E+00, 9.3795657918E-01],
	[3.3135000000E+04, 2.4580047529E+01, 5.1723479809E+00, 8.6417618603E+00, 2.8592967986E+00, 9.3798550277E-01],
	[3.3140000000E+04, 2.4586302113E+01, 5.1723552434E+00, 8.6460018916E+00, 2.8598476866E+00, 9.3801441188E-01],
	[3.3145000000E+04, 2.4592557345E+01, 5.1723625049E+00, 8.6502433622E+00, 2.8603984543E+00, 9.3804330651E-01],
	[3.3150000000E+04, 2.4598813225E+01, 5.1723697653E+00, 8.6544862724E+00, 2.8609491020E+00, 9.3807218667E-01],
	[3.3155000000E+04, 2.4605069752E+01, 5.1723770246E+00, 8.6587306223E+00, 2.8614996295E+00, 9.3810105236E-01],
	[3.3160000000E+04, 2.4611326926E+01, 5.1723842828E+00, 8.6629764124E+00, 2.8620500369E+00, 9.3812990360E-01],
	[3.3165000000E+04, 2.4617584748E+01, 5.1723915400E+00, 8.6672236428E+00, 2.8626003241E+00, 9.3815874039E-01],
	[3.3170000000E+04, 2.4623843217E+01, 5.1723987960E+00, 8.6714723138E+00, 2.8631504911E+00, 9.3818756274E-01],
	[3.3175000000E+04, 2.4630102334E+01, 5.1724060510E+00, 8.6757224257E+00, 2.8637005380E+00, 9.3821637065E-01],
	[3.3180000000E+04, 2.4636362098E+01, 5.1724133049E+00, 8.6799739788E+00, 2.8642504647E+00, 9.3824516413E-01],
	[3.3185000000E+04, 2.4642622509E+01, 5.1724205577E+00, 8.6842269733E+00, 2.8648002712E+00, 9.3827394320E-01],
	[3.3190000000E+04, 2.4648883568E+01, 5.1724278094E+00, 8.6884814095E+00, 2.8653499575E+00, 9.3830270785E-01],
	[3.3195000000E+04, 2.4655145274E+01, 5.1724350601E+00, 8.6927372878E+00, 2.8658995237E+00, 9.3833145809E-01],
	[3.3200000000E+04, 2.4661407627E+01, 5.1724423096E+00, 8.6969946082E+00, 2.8664489696E+00, 9.3836019394E-01],
	[3.3205000000E+04, 2.4667670628E+01, 5.1724495581E+00, 8.7012533712E+00, 2.8669982954E+00, 9.3838891540E-01],
	[3.3210000000E+04, 2.4673934275E+01, 5.1724568055E+00, 8.7055135770E+00, 2.8675475009E+00, 9.3841762247E-01],
	[3.3215000000E+04, 2.4680198570E+01, 5.1724640518E+00, 8.7097752258E+00, 2.8680965862E+00, 9.3844631516E-01],
	[3.3220000000E+04, 2.4686463512E+01, 5.1724712971E+00, 8.7140383180E+00, 2.8686455513E+00, 9.3847499349E-01],
	[3.3225000000E+04, 2.4692729101E+01, 5.1724785412E+00, 8.7183028538E+00, 2.8691943962E+00, 9.3850365745E-01],
	[3.3230000000E+04, 2.4698995337E+01, 5.1724857843E+00, 8.7225688334E+00, 2.8697431208E+00, 9.3853230706E-01],
	[3.3235000000E+04, 2.4705262220E+01, 5.1724930263E+00, 8.7268362572E+00, 2.8702917252E+00, 9.3856094232E-01],
	[3.3240000000E+04, 2.4711529750E+01, 5.1725002672E+00, 8.7311051255E+00, 2.8708402094E+00, 9.3858956324E-01],
	[3.3245000000E+04, 2.4717797927E+01, 5.1725075070E+00, 8.7353754384E+00, 2.8713885733E+00, 9.3861816983E-01],
	[3.3250000000E+04, 2.4724066751E+01, 5.1725147458E+00, 8.7396471962E+00, 2.8719368169E+00, 9.3864676209E-01],
	[3.3255000000E+04, 2.4730336222E+01, 5.1725219835E+00, 8.7439203994E+00, 2.8724849403E+00, 9.3867534003E-01],
	[3.3260000000E+04, 2.4736606340E+01, 5.1725292201E+00, 8.7481950480E+00, 2.8730329434E+00, 9.3870390366E-01],
	[3.3265000000E+04, 2.4742877105E+01, 5.1725364556E+00, 8.7524711423E+00, 2.8735808263E+00, 9.3873245299E-01],
	[3.3270000000E+04, 2.4749148516E+01, 5.1725436901E+00, 8.7567486828E+00, 2.8741285889E+00, 9.3876098802E-01],
	[3.3275000000E+04, 2.4755420574E+01, 5.1725509234E+00, 8.7610276695E+00, 2.8746762312E+00, 9.3878950876E-01],
	[3.3280000000E+04, 2.4761693279E+01, 5.1725581557E+00, 8.7653081029E+00, 2.8752237532E+00, 9.3881801522E-01],
	[3.3285000000E+04, 2.4767966631E+01, 5.1725653869E+00, 8.7695899830E+00, 2.8757711549E+00, 9.3884650740E-01],
	[3.3290000000E+04, 2.4774240629E+01, 5.1725726171E+00, 8.7738733104E+00, 2.8763184363E+00, 9.3887498532E-01],
	[3.3295000000E+04, 2.4780515274E+01, 5.1725798461E+00, 8.7781580851E+00, 2.8768655974E+00, 9.3890344898E-01],
	[3.3300000000E+04, 2.4786790566E+01, 5.1725870741E+00, 8.7824443075E+00, 2.8774126383E+00, 9.3893189838E-01],
	[3.3305000000E+04, 2.4793066504E+01, 5.1725943011E+00, 8.7867319778E+00, 2.8779595588E+00, 9.3896033353E-01],
	[3.3310000000E+04, 2.4799343089E+01, 5.1726015269E+00, 8.7910210964E+00, 2.8785063589E+00, 9.3898875445E-01],
	[3.3315000000E+04, 2.4805620320E+01, 5.1726087517E+00, 8.7953116634E+00, 2.8790530388E+00, 9.3901716114E-01],
	[3.3320000000E+04, 2.4811898198E+01, 5.1726159754E+00, 8.7996036792E+00, 2.8795995983E+00, 9.3904555360E-01],
	[3.3325000000E+04, 2.4818176722E+01, 5.1726231980E+00, 8.8038971440E+00, 2.8801460375E+00, 9.3907393184E-01],
	[3.3330000000E+04, 2.4824455893E+01, 5.1726304195E+00, 8.8081920581E+00, 2.8806923564E+00, 9.3910229587E-01],
	[3.3335000000E+04, 2.4830735710E+01, 5.1726376400E+00, 8.8124884218E+00, 2.8812385549E+00, 9.3913064571E-01],
	[3.3340000000E+04, 2.4837016174E+01, 5.1726448594E+00, 8.8167862353E+00, 2.8817846331E+00, 9.3915898134E-01],
	[3.3345000000E+04, 2.4843297284E+01, 5.1726520777E+00, 8.8210854990E+00, 2.8823305909E+00, 9.3918730279E-01],
	[3.3350000000E+04, 2.4849579040E+01, 5.1726592950E+00, 8.8253862130E+00, 2.8828764284E+00, 9.3921561006E-01],
	[3.3355000000E+04, 2.4855861443E+01, 5.1726665111E+00, 8.8296883777E+00, 2.8834221455E+00, 9.3924390315E-01],
	[3.3360000000E+04, 2.4862144491E+01, 5.1726737263E+00, 8.8339919933E+00, 2.8839677422E+00, 9.3927218208E-01],
	[3.3365000000E+04, 2.4868428187E+01, 5.1726809403E+00, 8.8382970601E+00, 2.8845132186E+00, 9.3930044684E-01],
	[3.3370000000E+04, 2.4874712528E+01, 5.1726881533E+00, 8.8426035784E+00, 2.8850585746E+00, 9.3932869746E-01],
	[3.3375000000E+04, 2.4880997515E+01, 5.1726953652E+00, 8.8469115484E+00, 2.8856038102E+00, 9.3935693393E-01],
	[3.3380000000E+04, 2.4887283149E+01, 5.1727025760E+00, 8.8512209704E+00, 2.8861489254E+00, 9.3938515626E-01],
	[3.3385000000E+04, 2.4893569429E+01, 5.1727097858E+00, 8.8555318447E+00, 2.8866939203E+00, 9.3941336447E-01],
	[3.3390000000E+04, 2.4899856354E+01, 5.1727169944E+00, 8.8598441716E+00, 2.8872387947E+00, 9.3944155855E-01],
	[3.3395000000E+04, 2.4906143926E+01, 5.1727242021E+00, 8.8641579513E+00, 2.8877835488E+00, 9.3946973851E-01],
	[3.3400000000E+04, 2.4912432144E+01, 5.1727314086E+00, 8.8684731841E+00, 2.8883281824E+00, 9.3949790437E-01],
	[3.3405000000E+04, 2.4918721008E+01, 5.1727386141E+00, 8.8727898702E+00, 2.8888726957E+00, 9.3952605612E-01],
	[3.3410000000E+04, 2.4925010518E+01, 5.1727458185E+00, 8.8771080100E+00, 2.8894170885E+00, 9.3955419378E-01],
	[3.3415000000E+04, 2.4931300673E+01, 5.1727530218E+00, 8.8814276037E+00, 2.8899613609E+00, 9.3958231736E-01],
	[3.3420000000E+04, 2.4937591475E+01, 5.1727602241E+00, 8.8857486516E+00, 2.8905055129E+00, 9.3961042685E-01],
	[3.3425000000E+04, 2.4943882923E+01, 5.1727674253E+00, 8.8900711540E+00, 2.8910495445E+00, 9.3963852227E-01],
	[3.3430000000E+04, 2.4950175016E+01, 5.1727746255E+00, 8.8943951110E+00, 2.8915934556E+00, 9.3966660363E-01],
	[3.3435000000E+04, 2.4956467755E+01, 5.1727818245E+00, 8.8987205231E+00, 2.8921372463E+00, 9.3969467093E-01],
	[3.3440000000E+04, 2.4962761140E+01, 5.1727890226E+00, 8.9030473904E+00, 2.8926809166E+00, 9.3972272417E-01],
	[3.3445000000E+04, 2.4969055171E+01, 5.1727962195E+00, 8.9073757133E+00, 2.8932244665E+00, 9.3975076338E-01],
	[3.3450000000E+04, 2.4975368652E+01, 5.1728060799E+00, 8.9117054920E+00, 2.8937689822E+00, 9.3977878855E-01],
	[3.3455000000E+04, 2.4981683673E+01, 5.1728160647E+00, 8.9160367267E+00, 2.8943134293E+00, 9.3980679968E-01],
	[3.3460000000E+04, 2.4987999347E+01, 5.1728260480E+00, 8.9203694179E+00, 2.8948577565E+00, 9.3983479680E-01],
	[3.3465000000E+04, 2.4994315674E+01, 5.1728360298E+00, 8.9247035656E+00, 2.8954019637E+00, 9.3986277990E-01],
	[3.3470000000E+04, 2.5000632653E+01, 5.1728460102E+00, 8.9290391702E+00, 2.8959460511E+00, 9.3989074900E-01],
	[3.3475000000E+04, 2.5006950285E+01, 5.1728559891E+00, 8.9333762320E+00, 2.8964900186E+00, 9.3991870409E-01],
	[3.3480000000E+04, 2.5013268569E+01, 5.1728659665E+00, 8.9377147513E+00, 2.8970338661E+00, 9.3994664519E-01],
	[3.3485000000E+04, 2.5019587506E+01, 5.1728759424E+00, 8.9420547283E+00, 2.8975775937E+00, 9.3997457231E-01],
	[3.3490000000E+04, 2.5025907095E+01, 5.1728859169E+00, 8.9463961632E+00, 2.8981212014E+00, 9.4000248544E-01],
	[3.3495000000E+04, 2.5032227337E+01, 5.1728958899E+00, 8.9507390564E+00, 2.8986646892E+00, 9.4003038461E-01],
	[3.3500000000E+04, 2.5038548231E+01, 5.1729058614E+00, 8.9550834081E+00, 2.8992080570E+00, 9.4005826981E-01],
	[3.3505000000E+04, 2.5044869778E+01, 5.1729158315E+00, 8.9594292186E+00, 2.8997513049E+00, 9.4008614105E-01],
	[3.3510000000E+04, 2.5051191977E+01, 5.1729258000E+00, 8.9637764882E+00, 2.9002944328E+00, 9.4011399834E-01],
	[3.3515000000E+04, 2.5057514828E+01, 5.1729357672E+00, 8.9681252172E+00, 2.9008374408E+00, 9.4014184169E-01],
	[3.3520000000E+04, 2.5063838332E+01, 5.1729457328E+00, 8.9724754057E+00, 2.9013803288E+00, 9.4016967111E-01],
	[3.3525000000E+04, 2.5070162488E+01, 5.1729556970E+00, 8.9768270541E+00, 2.9019230969E+00, 9.4019748660E-01],
	[3.3530000000E+04, 2.5076487296E+01, 5.1729656597E+00, 8.9811801627E+00, 2.9024657451E+00, 9.4022528816E-01],
	[3.3535000000E+04, 2.5082812756E+01, 5.1729756210E+00, 8.9855347317E+00, 2.9030082732E+00, 9.4025307582E-01],
	[3.3540000000E+04, 2.5089138869E+01, 5.1729855808E+00, 8.9898907614E+00, 2.9035506815E+00, 9.4028084956E-01],
	[3.3545000000E+04, 2.5095465633E+01, 5.1729955391E+00, 8.9942482521E+00, 2.9040929697E+00, 9.4030860941E-01],
	[3.3550000000E+04, 2.5101793050E+01, 5.1730054960E+00, 8.9986072040E+00, 2.9046351380E+00, 9.4033635536E-01],
	[3.3555000000E+04, 2.5108121119E+01, 5.1730154513E+00, 9.0029676174E+00, 2.9051771863E+00, 9.4036408743E-01],
	[3.3560000000E+04, 2.5114449840E+01, 5.1730254053E+00, 9.0073294927E+00, 2.9057191146E+00, 9.4039180562E-01],
	[3.3565000000E+04, 2.5120779212E+01, 5.1730353577E+00, 9.0116928299E+00, 2.9062609229E+00, 9.4041950994E-01],
	[3.3570000000E+04, 2.5127109237E+01, 5.1730453087E+00, 9.0160576295E+00, 2.9068026113E+00, 9.4044720040E-01],
	[3.3575000000E+04, 2.5133439914E+01, 5.1730552583E+00, 9.0204238917E+00, 2.9073441796E+00, 9.4047487700E-01],
	[3.3580000000E+04, 2.5139771243E+01, 5.1730652064E+00, 9.0247916168E+00, 2.9078856280E+00, 9.4050253975E-01],
	[3.3585000000E+04, 2.5146103224E+01, 5.1730751530E+00, 9.0291608050E+00, 2.9084269564E+00, 9.4053018866E-01],
	[3.3590000000E+04, 2.5152435856E+01, 5.1730850981E+00, 9.0335314567E+00, 2.9089681648E+00, 9.4055782373E-01],
	[3.3595000000E+04, 2.5158769141E+01, 5.1730950418E+00, 9.0379035720E+00, 2.9095092531E+00, 9.4058544498E-01],
	[3.3600000000E+04, 2.5165103077E+01, 5.1731049841E+00, 9.0422771513E+00, 2.9100502215E+00, 9.4061305240E-01],
	[3.3605000000E+04, 2.5171437665E+01, 5.1731149248E+00, 9.0466521948E+00, 2.9105910699E+00, 9.4064064602E-01],
	[3.3610000000E+04, 2.5177772905E+01, 5.1731248641E+00, 9.0510287028E+00, 2.9111317982E+00, 9.4066822582E-01],
	[3.3615000000E+04, 2.5184108796E+01, 5.1731348020E+00, 9.0554066756E+00, 2.9116724066E+00, 9.4069579183E-01],
	[3.3620000000E+04, 2.5190445340E+01, 5.1731447384E+00, 9.0597861134E+00, 2.9122128949E+00, 9.4072334405E-01],
	[3.3625000000E+04, 2.5196782534E+01, 5.1731546733E+00, 9.0641670165E+00, 2.9127532632E+00, 9.4075088248E-01],
	[3.3630000000E+04, 2.5203120381E+01, 5.1731646068E+00, 9.0685493853E+00, 2.9132935115E+00, 9.4077840713E-01],
	[3.3635000000E+04, 2.5209458879E+01, 5.1731745388E+00, 9.0729332199E+00, 2.9138336398E+00, 9.4080591802E-01],
	[3.3640000000E+04, 2.5215798029E+01, 5.1731844694E+00, 9.0773185206E+00, 2.9143736480E+00, 9.4083341514E-01],
	[3.3645000000E+04, 2.5222137830E+01, 5.1731943985E+00, 9.0817052877E+00, 2.9149135362E+00, 9.4086089850E-01],
	[3.3650000000E+04, 2.5228478283E+01, 5.1732043261E+00, 9.0860935216E+00, 2.9154533044E+00, 9.4088836812E-01],
	[3.3655000000E+04, 2.5234819387E+01, 5.1732142523E+00, 9.0904832223E+00, 2.9159929525E+00, 9.4091582400E-01],
	[3.3660000000E+04, 2.5241161143E+01, 5.1732241771E+00, 9.0948743903E+00, 2.9165324806E+00, 9.4094326614E-01],
	[3.3665000000E+04, 2.5247503550E+01, 5.1732341003E+00, 9.0992670258E+00, 2.9170718887E+00, 9.4097069455E-01],
	[3.3670000000E+04, 2.5253846608E+01, 5.1732440222E+00, 9.1036611290E+00, 2.9176111767E+00, 9.4099810923E-01],
	[3.3675000000E+04, 2.5260190318E+01, 5.1732539425E+00, 9.1080567003E+00, 2.9181503447E+00, 9.4102551020E-01],
	[3.3680000000E+04, 2.5266534680E+01, 5.1732638615E+00, 9.1124537399E+00, 2.9186893926E+00, 9.4105289746E-01],
	[3.3685000000E+04, 2.5272879692E+01, 5.1732737789E+00, 9.1168522480E+00, 2.9192283204E+00, 9.4108027102E-01],
	[3.3690000000E+04, 2.5279225356E+01, 5.1732836949E+00, 9.1212522251E+00, 2.9197671282E+00, 9.4110763088E-01],
	[3.3695000000E+04, 2.5285571671E+01, 5.1732936095E+00, 9.1256536712E+00, 2.9203058160E+00, 9.4113497705E-01],
	[3.3700000000E+04, 2.5291918637E+01, 5.1733035226E+00, 9.1300565867E+00, 2.9208443837E+00, 9.4116230953E-01],
	[3.3705000000E+04, 2.5298266255E+01, 5.1733134343E+00, 9.1344609719E+00, 2.9213828313E+00, 9.4118962833E-01],
	[3.3710000000E+04, 2.5304614524E+01, 5.1733233445E+00, 9.1388668271E+00, 2.9219211589E+00, 9.4121693346E-01],
	[3.3715000000E+04, 2.5310963443E+01, 5.1733332532E+00, 9.1432741524E+00, 2.9224593664E+00, 9.4124422493E-01],
	[3.3720000000E+04, 2.5317313014E+01, 5.1733431605E+00, 9.1476829483E+00, 2.9229974538E+00, 9.4127150274E-01],
	[3.3725000000E+04, 2.5323663236E+01, 5.1733530664E+00, 9.1520932149E+00, 2.9235354212E+00, 9.4129876689E-01],
	[3.3730000000E+04, 2.5330014109E+01, 5.1733629708E+00, 9.1565049525E+00, 2.9240732685E+00, 9.4132601740E-01],
	[3.3735000000E+04, 2.5336365633E+01, 5.1733728737E+00, 9.1609181614E+00, 2.9246109957E+00, 9.4135325426E-01],
	[3.3740000000E+04, 2.5342717808E+01, 5.1733827752E+00, 9.1653328419E+00, 2.9251486029E+00, 9.4138047749E-01],
	[3.3745000000E+04, 2.5349070634E+01, 5.1733926753E+00, 9.1697489942E+00, 2.9256860899E+00, 9.4140768710E-01],
	[3.3750000000E+04, 2.5355424111E+01, 5.1734025739E+00, 9.1741666187E+00, 2.9262234569E+00, 9.4143488308E-01],
	[3.3755000000E+04, 2.5361778239E+01, 5.1734124711E+00, 9.1785857155E+00, 2.9267607038E+00, 9.4146206545E-01],
	[3.3760000000E+04, 2.5368133017E+01, 5.1734223668E+00, 9.1830062850E+00, 2.9272978306E+00, 9.4148923421E-01],
	[3.3765000000E+04, 2.5374488447E+01, 5.1734322610E+00, 9.1874283274E+00, 2.9278348373E+00, 9.4151638936E-01],
	[3.3770000000E+04, 2.5380844527E+01, 5.1734421539E+00, 9.1918518431E+00, 2.9283717240E+00, 9.4154353092E-01],
	[3.3775000000E+04, 2.5387201258E+01, 5.1734520452E+00, 9.1962768322E+00, 2.9289084905E+00, 9.4157065890E-01],
	[3.3780000000E+04, 2.5393558640E+01, 5.1734619352E+00, 9.2007032950E+00, 2.9294451370E+00, 9.4159777328E-01],
	[3.3785000000E+04, 2.5399916672E+01, 5.1734718237E+00, 9.2051312319E+00, 2.9299816633E+00, 9.4162487410E-01],
	[3.3790000000E+04, 2.5406275355E+01, 5.1734817107E+00, 9.2095606431E+00, 2.9305180696E+00, 9.4165196134E-01],
	[3.3795000000E+04, 2.5412634689E+01, 5.1734915963E+00, 9.2139915288E+00, 2.9310543558E+00, 9.4167903502E-01],
	[3.3800000000E+04, 2.5418994674E+01, 5.1735014805E+00, 9.2184238894E+00, 2.9315905218E+00, 9.4170609513E-01],
	[3.3805000000E+04, 2.5425355309E+01, 5.1735113632E+00, 9.2228577251E+00, 2.9321265678E+00, 9.4173314170E-01],
	[3.3810000000E+04, 2.5431716594E+01, 5.1735212444E+00, 9.2272930361E+00, 2.9326624937E+00, 9.4176017473E-01],
	[3.3815000000E+04, 2.5438078531E+01, 5.1735311243E+00, 9.2317298228E+00, 2.9331982994E+00, 9.4178719421E-01],
	[3.3820000000E+04, 2.5444441117E+01, 5.1735410027E+00, 9.2361680855E+00, 2.9337339851E+00, 9.4181420016E-01],
	[3.3825000000E+04, 2.5450804354E+01, 5.1735508796E+00, 9.2406078243E+00, 2.9342695506E+00, 9.4184119259E-01],
	[3.3830000000E+04, 2.5457168242E+01, 5.1735607551E+00, 9.2450490396E+00, 2.9348049961E+00, 9.4186817150E-01],
	[3.3835000000E+04, 2.5463532780E+01, 5.1735706292E+00, 9.2494917317E+00, 2.9353403214E+00, 9.4189513689E-01],
	[3.3840000000E+04, 2.5469897968E+01, 5.1735805018E+00, 9.2539359007E+00, 2.9358755266E+00, 9.4192208878E-01],
	[3.3845000000E+04, 2.5476263807E+01, 5.1735903730E+00, 9.2583815471E+00, 2.9364106117E+00, 9.4194902717E-01],
	[3.3850000000E+04, 2.5482630296E+01, 5.1736002427E+00, 9.2628286710E+00, 2.9369455767E+00, 9.4197595206E-01],
	[3.3855000000E+04, 2.5488997435E+01, 5.1736101110E+00, 9.2672772727E+00, 2.9374804216E+00, 9.4200286347E-01],
	[3.3860000000E+04, 2.5495365225E+01, 5.1736199779E+00, 9.2717273525E+00, 2.9380151463E+00, 9.4202976140E-01],
	[3.3865000000E+04, 2.5501733665E+01, 5.1736298433E+00, 9.2761789107E+00, 2.9385497509E+00, 9.4205664585E-01],
	[3.3870000000E+04, 2.5508102755E+01, 5.1736397073E+00, 9.2806319476E+00, 2.9390842354E+00, 9.4208351683E-01],
	[3.3875000000E+04, 2.5514472495E+01, 5.1736495698E+00, 9.2850864634E+00, 2.9396185998E+00, 9.4211037435E-01],
	[3.3880000000E+04, 2.5520842886E+01, 5.1736594310E+00, 9.2895424583E+00, 2.9401528441E+00, 9.4213721841E-01],
	[3.3885000000E+04, 2.5527213926E+01, 5.1736692906E+00, 9.2939999328E+00, 2.9406869683E+00, 9.4216404903E-01],
	[3.3890000000E+04, 2.5533585617E+01, 5.1736791489E+00, 9.2984588869E+00, 2.9412209723E+00, 9.4219086620E-01],
	[3.3895000000E+04, 2.5539957957E+01, 5.1736890057E+00, 9.3029193211E+00, 2.9417548562E+00, 9.4221766994E-01],
	[3.3900000000E+04, 2.5546330948E+01, 5.1736988611E+00, 9.3073812356E+00, 2.9422886200E+00, 9.4224446024E-01],
	[3.3905000000E+04, 2.5552704589E+01, 5.1737087150E+00, 9.3118446306E+00, 2.9428222636E+00, 9.4227123713E-01],
	[3.3910000000E+04, 2.5559078879E+01, 5.1737185675E+00, 9.3163095064E+00, 2.9433557871E+00, 9.4229800059E-01],
	[3.3915000000E+04, 2.5565453820E+01, 5.1737284186E+00, 9.3207758634E+00, 2.9438891905E+00, 9.4232475065E-01],
	[3.3920000000E+04, 2.5571829411E+01, 5.1737382682E+00, 9.3252437017E+00, 2.9444224738E+00, 9.4235148730E-01],
	[3.3925000000E+04, 2.5578205651E+01, 5.1737481164E+00, 9.3297130216E+00, 2.9449556369E+00, 9.4237821055E-01],
	[3.3930000000E+04, 2.5584582541E+01, 5.1737579632E+00, 9.3341838235E+00, 2.9454886799E+00, 9.4240492041E-01],
	[3.3935000000E+04, 2.5590960081E+01, 5.1737678085E+00, 9.3386561076E+00, 2.9460216027E+00, 9.4243161688E-01],
	[3.3940000000E+04, 2.5597338271E+01, 5.1737776524E+00, 9.3431298741E+00, 2.9465544055E+00, 9.4245829998E-01],
	[3.3945000000E+04, 2.5603717111E+01, 5.1737874949E+00, 9.3476051233E+00, 2.9470870881E+00, 9.4248496970E-01],
	[3.3950000000E+04, 2.5610096600E+01, 5.1737973359E+00, 9.3520818556E+00, 2.9476196505E+00, 9.4251162606E-01],
	[3.3955000000E+04, 2.5616476739E+01, 5.1738071756E+00, 9.3565600711E+00, 2.9481520928E+00, 9.4253826905E-01],
	[3.3960000000E+04, 2.5622857528E+01, 5.1738170137E+00, 9.3610397702E+00, 2.9486844150E+00, 9.4256489870E-01],
	[3.3965000000E+04, 2.5629238967E+01, 5.1738268505E+00, 9.3655209531E+00, 2.9492166171E+00, 9.4259151499E-01],
	[3.3970000000E+04, 2.5635621055E+01, 5.1738366858E+00, 9.3700036201E+00, 2.9497486990E+00, 9.4261811795E-01],
	[3.3975000000E+04, 2.5642003792E+01, 5.1738465197E+00, 9.3744877714E+00, 2.9502806608E+00, 9.4264470757E-01],
	[3.3980000000E+04, 2.5648387179E+01, 5.1738563522E+00, 9.3789734074E+00, 2.9508125024E+00, 9.4267128386E-01],
	[3.3985000000E+04, 2.5654776477E+01, 5.1738669225E+00, 9.3834605283E+00, 2.9513445341E+00, 9.4269784684E-01],
	[3.3990000000E+04, 2.5661180625E+01, 5.1738794860E+00, 9.3879491344E+00, 2.9518772830E+00, 9.4272439649E-01],
	[3.3995000000E+04, 2.5667585430E+01, 5.1738920477E+00, 9.3924392260E+00, 2.9524099123E+00, 9.4275093284E-01],
	[3.4000000000E+04, 2.5673990890E+01, 5.1739046076E+00, 9.3969308033E+00, 2.9529424219E+00, 9.4277745589E-01],
	[3.4005000000E+04, 2.5680397007E+01, 5.1739171656E+00, 9.4014238666E+00, 2.9534748119E+00, 9.4280396564E-01],
	[3.4010000000E+04, 2.5686803780E+01, 5.1739297218E+00, 9.4059184161E+00, 2.9540070824E+00, 9.4283046210E-01],
	[3.4015000000E+04, 2.5693211209E+01, 5.1739422762E+00, 9.4104144522E+00, 2.9545392332E+00, 9.4285694527E-01],
	[3.4020000000E+04, 2.5699619294E+01, 5.1739548288E+00, 9.4149119752E+00, 2.9550712643E+00, 9.4288341517E-01],
	[3.4025000000E+04, 2.5706028036E+01, 5.1739673796E+00, 9.4194109852E+00, 2.9556031759E+00, 9.4290987181E-01],
	[3.4030000000E+04, 2.5712437433E+01, 5.1739799286E+00, 9.4239114826E+00, 2.9561349679E+00, 9.4293631517E-01],
	[3.4035000000E+04, 2.5718847487E+01, 5.1739924758E+00, 9.4284134676E+00, 2.9566666402E+00, 9.4296274528E-01],
	[3.4040000000E+04, 2.5725258196E+01, 5.1740050211E+00, 9.4329169405E+00, 2.9571981929E+00, 9.4298916214E-01],
	[3.4045000000E+04, 2.5731669562E+01, 5.1740175646E+00, 9.4374219017E+00, 2.9577296261E+00, 9.4301556575E-01],
	[3.4050000000E+04, 2.5738081584E+01, 5.1740301064E+00, 9.4419283512E+00, 2.9582609395E+00, 9.4304195612E-01],
	[3.4055000000E+04, 2.5744494261E+01, 5.1740426463E+00, 9.4464362895E+00, 2.9587921334E+00, 9.4306833327E-01],
	[3.4060000000E+04, 2.5750907595E+01, 5.1740551844E+00, 9.4509457168E+00, 2.9593232077E+00, 9.4309469718E-01],
	[3.4065000000E+04, 2.5757321584E+01, 5.1740677207E+00, 9.4554566334E+00, 2.9598541623E+00, 9.4312104788E-01],
	[3.4070000000E+04, 2.5763736229E+01, 5.1740802551E+00, 9.4599690395E+00, 2.9603849973E+00, 9.4314738537E-01],
	[3.4075000000E+04, 2.5770151531E+01, 5.1740927878E+00, 9.4644829355E+00, 2.9609157127E+00, 9.4317370964E-01],
	[3.4080000000E+04, 2.5776567487E+01, 5.1741053187E+00, 9.4689983215E+00, 2.9614463085E+00, 9.4320002072E-01],
	[3.4085000000E+04, 2.5782984100E+01, 5.1741178477E+00, 9.4735151979E+00, 2.9619767847E+00, 9.4322631861E-01],
	[3.4090000000E+04, 2.5789401369E+01, 5.1741303750E+00, 9.4780335649E+00, 2.9625071412E+00, 9.4325260330E-01],
	[3.4095000000E+04, 2.5795819293E+01, 5.1741429004E+00, 9.4825534229E+00, 2.9630373782E+00, 9.4327887482E-01],
	[3.4100000000E+04, 2.5802237873E+01, 5.1741554240E+00, 9.4870747720E+00, 2.9635674955E+00, 9.4330513316E-01],
	[3.4105000000E+04, 2.5808657108E+01, 5.1741679459E+00, 9.4915976126E+00, 2.9640974932E+00, 9.4333137833E-01],
	[3.4110000000E+04, 2.5815077000E+01, 5.1741804659E+00, 9.4961219449E+00, 2.9646273713E+00, 9.4335761035E-01],
	[3.4115000000E+04, 2.5821497546E+01, 5.1741929841E+00, 9.5006477692E+00, 2.9651571297E+00, 9.4338382920E-01],
	[3.4120000000E+04, 2.5827918749E+01, 5.1742055005E+00, 9.5051750858E+00, 2.9656867686E+00, 9.4341003491E-01],
	[3.4125000000E+04, 2.5834340607E+01, 5.1742180151E+00, 9.5097038949E+00, 2.9662162878E+00, 9.4343622748E-01],
	[3.4130000000E+04, 2.5840763120E+01, 5.1742305279E+00, 9.5142341968E+00, 2.9667456874E+00, 9.4346240691E-01],
	[3.4135000000E+04, 2.5847186289E+01, 5.1742430389E+00, 9.5187659919E+00, 2.9672749674E+00, 9.4348857321E-01],
	[3.4140000000E+04, 2.5853610113E+01, 5.1742555481E+00, 9.5232992803E+00, 2.9678041278E+00, 9.4351472638E-01],
	[3.4145000000E+04, 2.5860034593E+01, 5.1742680555E+00, 9.5278340623E+00, 2.9683331686E+00, 9.4354086644E-01],
	[3.4150000000E+04, 2.5866459728E+01, 5.1742805611E+00, 9.5323703382E+00, 2.9688620897E+00, 9.4356699339E-01],
	[3.4155000000E+04, 2.5872885519E+01, 5.1742930649E+00, 9.5369081084E+00, 2.9693908912E+00, 9.4359310723E-01],
	[3.4160000000E+04, 2.5879311965E+01, 5.1743055669E+00, 9.5414473730E+00, 2.9699195732E+00, 9.4361920798E-01],
	[3.4165000000E+04, 2.5885739066E+01, 5.1743180671E+00, 9.5459881323E+00, 2.9704481355E+00, 9.4364529564E-01],
	[3.4170000000E+04, 2.5892166823E+01, 5.1743305655E+00, 9.5505303866E+00, 2.9709765782E+00, 9.4367137021E-01],
	[3.4175000000E+04, 2.5898595234E+01, 5.1743430621E+00, 9.5550741362E+00, 2.9715049013E+00, 9.4369743170E-01],
	[3.4180000000E+04, 2.5905024301E+01, 5.1743555569E+00, 9.5596193813E+00, 2.9720331047E+00, 9.4372348012E-01],
	[3.4185000000E+04, 2.5911454024E+01, 5.1743680499E+00, 9.5641661223E+00, 2.9725611886E+00, 9.4374951547E-01],
	[3.4190000000E+04, 2.5917884401E+01, 5.1743805411E+00, 9.5687143593E+00, 2.9730891529E+00, 9.4377553777E-01],
	[3.4195000000E+04, 2.5924315434E+01, 5.1743930305E+00, 9.5732640927E+00, 2.9736169975E+00, 9.4380154701E-01],
	[3.4200000000E+04, 2.5930747121E+01, 5.1744055182E+00, 9.5778153228E+00, 2.9741447225E+00, 9.4382754320E-01],
	[3.4205000000E+04, 2.5937179464E+01, 5.1744180040E+00, 9.5823680497E+00, 2.9746723280E+00, 9.4385352636E-01],
	[3.4210000000E+04, 2.5943612462E+01, 5.1744304880E+00, 9.5869222739E+00, 2.9751998138E+00, 9.4387949648E-01],
	[3.4215000000E+04, 2.5950046115E+01, 5.1744429702E+00, 9.5914779955E+00, 2.9757271800E+00, 9.4390545357E-01],
	[3.4220000000E+04, 2.5956480422E+01, 5.1744554507E+00, 9.5960352148E+00, 2.9762544266E+00, 9.4393139765E-01],
	[3.4225000000E+04, 2.5962915385E+01, 5.1744679293E+00, 9.6005939322E+00, 2.9767815536E+00, 9.4395732870E-01],
	[3.4230000000E+04, 2.5969351003E+01, 5.1744804062E+00, 9.6051541478E+00, 2.9773085610E+00, 9.4398324675E-01],
	[3.4235000000E+04, 2.5975787275E+01, 5.1744928812E+00, 9.6097158619E+00, 2.9778354488E+00, 9.4400915180E-01],
	[3.4240000000E+04, 2.5982224203E+01, 5.1745053545E+00, 9.6142790749E+00, 2.9783622170E+00, 9.4403504385E-01],
	[3.4245000000E+04, 2.5988661785E+01, 5.1745178260E+00, 9.6188437870E+00, 2.9788888656E+00, 9.4406092292E-01],
	[3.4250000000E+04, 2.5995100022E+01, 5.1745302957E+00, 9.6234099984E+00, 2.9794153946E+00, 9.4408678900E-01],
	[3.4255000000E+04, 2.6001538914E+01, 5.1745427635E+00, 9.6279777095E+00, 2.9799418040E+00, 9.4411264210E-01],
	[3.4260000000E+04, 2.6007978461E+01, 5.1745552296E+00, 9.6325469205E+00, 2.9804680938E+00, 9.4413848224E-01],
	[3.4265000000E+04, 2.6014418662E+01, 5.1745676940E+00, 9.6371176317E+00, 2.9809942640E+00, 9.4416430941E-01],
	[3.4270000000E+04, 2.6020859518E+01, 5.1745801565E+00, 9.6416898434E+00, 2.9815203146E+00, 9.4419012362E-01],
	[3.4275000000E+04, 2.6027301029E+01, 5.1745926172E+00, 9.6462635558E+00, 2.9820462457E+00, 9.4421592488E-01],
	[3.4280000000E+04, 2.6033743195E+01, 5.1746050762E+00, 9.6508387692E+00, 2.9825720571E+00, 9.4424171320E-01],
	[3.4285000000E+04, 2.6040186015E+01, 5.1746175333E+00, 9.6554154838E+00, 2.9830977489E+00, 9.4426748858E-01],
	[3.4290000000E+04, 2.6046629490E+01, 5.1746299887E+00, 9.6599937000E+00, 2.9836233212E+00, 9.4429325103E-01],
	[3.4295000000E+04, 2.6053073619E+01, 5.1746424423E+00, 9.6645734181E+00, 2.9841487738E+00, 9.4431900056E-01],
	[3.4300000000E+04, 2.6059518403E+01, 5.1746548941E+00, 9.6691546382E+00, 2.9846741069E+00, 9.4434473716E-01],
	[3.4305000000E+04, 2.6065963841E+01, 5.1746673441E+00, 9.6737373608E+00, 2.9851993204E+00, 9.4437046085E-01],
	[3.4310000000E+04, 2.6072409933E+01, 5.1746797924E+00, 9.6783215859E+00, 2.9857244143E+00, 9.4439617164E-01],
	[3.4315000000E+04, 2.6078856681E+01, 5.1746922388E+00, 9.6829073140E+00, 2.9862493886E+00, 9.4442186953E-01],
	[3.4320000000E+04, 2.6085304082E+01, 5.1747046835E+00, 9.6874945453E+00, 2.9867742434E+00, 9.4444755452E-01],
	[3.4325000000E+04, 2.6091752138E+01, 5.1747171264E+00, 9.6920832800E+00, 2.9872989785E+00, 9.4447322663E-01],
	[3.4330000000E+04, 2.6098200849E+01, 5.1747295675E+00, 9.6966735185E+00, 2.9878235941E+00, 9.4449888585E-01],
	[3.4335000000E+04, 2.6104650213E+01, 5.1747420068E+00, 9.7012652610E+00, 2.9883480901E+00, 9.4452453221E-01],
	[3.4340000000E+04, 2.6111100232E+01, 5.1747544443E+00, 9.7058585078E+00, 2.9888724665E+00, 9.4455016569E-01],
	[3.4345000000E+04, 2.6117550905E+01, 5.1747668801E+00, 9.7104532591E+00, 2.9893967234E+00, 9.4457578632E-01],
	[3.4350000000E+04, 2.6124002233E+01, 5.1747793141E+00, 9.7150495152E+00, 2.9899208607E+00, 9.4460139408E-01],
	[3.4355000000E+04, 2.6130454215E+01, 5.1747917463E+00, 9.7196472765E+00, 2.9904448784E+00, 9.4462698900E-01],
	[3.4360000000E+04, 2.6136906850E+01, 5.1748041767E+00, 9.7242465431E+00, 2.9909687766E+00, 9.4465257108E-01],
	[3.4365000000E+04, 2.6143360140E+01, 5.1748166053E+00, 9.7288473154E+00, 2.9914925551E+00, 9.4467814032E-01],
	[3.4370000000E+04, 2.6149814085E+01, 5.1748290322E+00, 9.7334495936E+00, 2.9920162142E+00, 9.4470369674E-01],
	[3.4375000000E+04, 2.6156268683E+01, 5.1748414573E+00, 9.7380533780E+00, 2.9925397536E+00, 9.4472924033E-01],
	[3.4380000000E+04, 2.6162723935E+01, 5.1748538806E+00, 9.7426586689E+00, 2.9930631735E+00, 9.4475477110E-01],
	[3.4385000000E+04, 2.6169179842E+01, 5.1748663021E+00, 9.7472654665E+00, 2.9935864739E+00, 9.4478028906E-01],
	[3.4390000000E+04, 2.6175636402E+01, 5.1748787219E+00, 9.7518737712E+00, 2.9941096546E+00, 9.4480579422E-01],
	[3.4395000000E+04, 2.6182093616E+01, 5.1748911399E+00, 9.7564835831E+00, 2.9946327159E+00, 9.4483128658E-01],
	[3.4400000000E+04, 2.6188551485E+01, 5.1749035561E+00, 9.7610949026E+00, 2.9951556576E+00, 9.4485676616E-01],
	[3.4405000000E+04, 2.6195010007E+01, 5.1749159705E+00, 9.7657077299E+00, 2.9956784797E+00, 9.4488223294E-01],
	[3.4410000000E+04, 2.6201469183E+01, 5.1749283831E+00, 9.7703220654E+00, 2.9962011823E+00, 9.4490768695E-01],
	[3.4415000000E+04, 2.6207929013E+01, 5.1749407940E+00, 9.7749379092E+00, 2.9967237653E+00, 9.4493312818E-01],
	[3.4420000000E+04, 2.6214389497E+01, 5.1749532031E+00, 9.7795552616E+00, 2.9972462288E+00, 9.4495855666E-01],
	[3.4425000000E+04, 2.6220850634E+01, 5.1749656105E+00, 9.7841741230E+00, 2.9977685727E+00, 9.4498397237E-01],
	[3.4430000000E+04, 2.6227312426E+01, 5.1749780160E+00, 9.7887944937E+00, 2.9982907971E+00, 9.4500937532E-01],
	[3.4435000000E+04, 2.6233774871E+01, 5.1749904198E+00, 9.7934163737E+00, 2.9988129020E+00, 9.4503476554E-01],
	[3.4440000000E+04, 2.6240237970E+01, 5.1750028218E+00, 9.7980397636E+00, 2.9993348873E+00, 9.4506014301E-01],
	[3.4445000000E+04, 2.6246701722E+01, 5.1750152221E+00, 9.8026646634E+00, 2.9998567532E+00, 9.4508550775E-01],
	[3.4450000000E+04, 2.6253166129E+01, 5.1750276206E+00, 9.8072910736E+00, 3.0003784994E+00, 9.4511085976E-01],
	[3.4455000000E+04, 2.6259631189E+01, 5.1750400173E+00, 9.8119189943E+00, 3.0009001262E+00, 9.4513619905E-01],
	[3.4460000000E+04, 2.6266096902E+01, 5.1750524122E+00, 9.8165484259E+00, 3.0014216334E+00, 9.4516152562E-01],
	[3.4465000000E+04, 2.6272563269E+01, 5.1750648054E+00, 9.8211793685E+00, 3.0019430211E+00, 9.4518683949E-01],
	[3.4470000000E+04, 2.6279030290E+01, 5.1750771968E+00, 9.8258118226E+00, 3.0024642893E+00, 9.4521214066E-01],
	[3.4475000000E+04, 2.6285497964E+01, 5.1750895864E+00, 9.8304457883E+00, 3.0029854379E+00, 9.4523742913E-01],
	[3.4480000000E+04, 2.6291966291E+01, 5.1751019743E+00, 9.8350812660E+00, 3.0035064671E+00, 9.4526270491E-01],
	[3.4485000000E+04, 2.6298435273E+01, 5.1751143604E+00, 9.8397182559E+00, 3.0040273767E+00, 9.4528796801E-01],
	[3.4490000000E+04, 2.6304904907E+01, 5.1751267447E+00, 9.8443567583E+00, 3.0045481668E+00, 9.4531321843E-01],
	[3.4495000000E+04, 2.6311375195E+01, 5.1751391273E+00, 9.8489967734E+00, 3.0050688374E+00, 9.4533845618E-01],
	[3.4500000000E+04, 2.6317846136E+01, 5.1751515081E+00, 9.8536383015E+00, 3.0055893885E+00, 9.4536368127E-01],
	[3.4505000000E+04, 2.6324317731E+01, 5.1751638871E+00, 9.8582813430E+00, 3.0061098201E+00, 9.4538889370E-01],
	[3.4510000000E+04, 2.6330789979E+01, 5.1751762644E+00, 9.8629258980E+00, 3.0066301322E+00, 9.4541409348E-01],
	[3.4515000000E+04, 2.6337262880E+01, 5.1751886399E+00, 9.8675719669E+00, 3.0071503248E+00, 9.4543928062E-01],
	[3.4520000000E+04, 2.6343736435E+01, 5.1752010137E+00, 9.8722195499E+00, 3.0076703979E+00, 9.4546445512E-01],
	[3.4525000000E+04, 2.6350210643E+01, 5.1752133856E+00, 9.8768686473E+00, 3.0081903515E+00, 9.4548961698E-01],
	[3.4530000000E+04, 2.6356685504E+01, 5.1752257559E+00, 9.8815192594E+00, 3.0087101857E+00, 9.4551476623E-01],
	[3.4535000000E+04, 2.6363177399E+01, 5.1752404076E+00, 9.8861713864E+00, 3.0092308857E+00, 9.4553990285E-01],
	[3.4540000000E+04, 2.6369672794E+01, 5.1752554528E+00, 9.8908250287E+00, 3.0097516375E+00, 9.4556502686E-01],
	[3.4545000000E+04, 2.6376168847E+01, 5.1752704959E+00, 9.8954801864E+00, 3.0102722703E+00, 9.4559013826E-01],
	[3.4550000000E+04, 2.6382665561E+01, 5.1752855369E+00, 9.9001368599E+00, 3.0107927842E+00, 9.4561523706E-01],
	[3.4555000000E+04, 2.6389162934E+01, 5.1753005758E+00, 9.9047950495E+00, 3.0113131791E+00, 9.4564032328E-01],
	[3.4560000000E+04, 2.6395660967E+01, 5.1753156125E+00, 9.9094547553E+00, 3.0118334550E+00, 9.4566539690E-01],
	[3.4565000000E+04, 2.6402159660E+01, 5.1753306471E+00, 9.9141159778E+00, 3.0123536119E+00, 9.4569045794E-01],
	[3.4570000000E+04, 2.6408659012E+01, 5.1753456795E+00, 9.9187787171E+00, 3.0128736499E+00, 9.4571550641E-01],
	[3.4575000000E+04, 2.6415159024E+01, 5.1753607098E+00, 9.9234429735E+00, 3.0133935689E+00, 9.4574054231E-01],
	[3.4580000000E+04, 2.6421659696E+01, 5.1753757380E+00, 9.9281087474E+00, 3.0139133690E+00, 9.4576556565E-01],
	[3.4585000000E+04, 2.6428161027E+01, 5.1753907641E+00, 9.9327760389E+00, 3.0144330501E+00, 9.4579057643E-01],
	[3.4590000000E+04, 2.6434663018E+01, 5.1754057880E+00, 9.9374448484E+00, 3.0149526122E+00, 9.4581557466E-01],
	[3.4595000000E+04, 2.6441165668E+01, 5.1754208098E+00, 9.9421151761E+00, 3.0154720554E+00, 9.4584056036E-01],
	[3.4600000000E+04, 2.6447668978E+01, 5.1754358295E+00, 9.9467870223E+00, 3.0159913797E+00, 9.4586553351E-01],
	[3.4605000000E+04, 2.6454172947E+01, 5.1754508471E+00, 9.9514603873E+00, 3.0165105850E+00, 9.4589049414E-01],
	[3.4610000000E+04, 2.6460677576E+01, 5.1754658625E+00, 9.9561352714E+00, 3.0170296714E+00, 9.4591544224E-01],
	[3.4615000000E+04, 2.6467182863E+01, 5.1754808758E+00, 9.9608116747E+00, 3.0175486389E+00, 9.4594037782E-01],
	[3.4620000000E+04, 2.6473688811E+01, 5.1754958870E+00, 9.9654895977E+00, 3.0180674874E+00, 9.4596530090E-01],
	[3.4625000000E+04, 2.6480195417E+01, 5.1755108960E+00, 9.9701690405E+00, 3.0185862170E+00, 9.4599021147E-01],
	[3.4630000000E+04, 2.6486702683E+01, 5.1755259029E+00, 9.9748500035E+00, 3.0191048276E+00, 9.4601510954E-01],
	[3.4635000000E+04, 2.6493210609E+01, 5.1755409077E+00, 9.9795324869E+00, 3.0196233193E+00, 9.4603999512E-01],
	[3.4640000000E+04, 2.6499719193E+01, 5.1755559104E+00, 9.9842164910E+00, 3.0201416922E+00, 9.4606486821E-01],
	[3.4645000000E+04, 2.6506228437E+01, 5.1755709110E+00, 9.9889020161E+00, 3.0206599461E+00, 9.4608972883E-01],
	[3.4650000000E+04, 2.6512738340E+01, 5.1755859094E+00, 9.9935890624E+00, 3.0211780810E+00, 9.4611457697E-01],
	[3.4655000000E+04, 2.6519248902E+01, 5.1756009057E+00, 9.9982776302E+00, 3.0216960971E+00, 9.4613941265E-01],
	[3.4660000000E+04, 2.6525760123E+01, 5.1756158999E+00, 1.0002967720E+01, 3.0222139943E+00, 9.4616423586E-01],
	[3.4665000000E+04, 2.6532272004E+01, 5.1756308920E+00, 1.0007659331E+01, 3.0227317725E+00, 9.4618904663E-01],
	[3.4670000000E+04, 2.6538784543E+01, 5.1756458820E+00, 1.0012352465E+01, 3.0232494319E+00, 9.4621384494E-01],
	[3.4675000000E+04, 2.6545297741E+01, 5.1756608698E+00, 1.0017047122E+01, 3.0237669724E+00, 9.4623863082E-01],
	[3.4680000000E+04, 2.6551811599E+01, 5.1756758555E+00, 1.0021743302E+01, 3.0242843940E+00, 9.4626340425E-01],
	[3.4685000000E+04, 2.6558326115E+01, 5.1756908391E+00, 1.0026441004E+01, 3.0248016966E+00, 9.4628816527E-01],
	[3.4690000000E+04, 2.6564841291E+01, 5.1757058206E+00, 1.0031140230E+01, 3.0253188804E+00, 9.4631291386E-01],
	[3.4695000000E+04, 2.6571357125E+01, 5.1757208000E+00, 1.0035840980E+01, 3.0258359454E+00, 9.4633765003E-01],
	[3.4700000000E+04, 2.6577873619E+01, 5.1757357773E+00, 1.0040543254E+01, 3.0263528914E+00, 9.4636237379E-01],
	[3.4705000000E+04, 2.6584390771E+01, 5.1757507524E+00, 1.0045247052E+01, 3.0268697186E+00, 9.4638708516E-01],
	[3.4710000000E+04, 2.6590908582E+01, 5.1757657254E+00, 1.0049952374E+01, 3.0273864269E+00, 9.4641178412E-01],
	[3.4715000000E+04, 2.6597427052E+01, 5.1757806964E+00, 1.0054659222E+01, 3.0279030163E+00, 9.4643647070E-01],
	[3.4720000000E+04, 2.6603946180E+01, 5.1757956652E+00, 1.0059367594E+01, 3.0284194868E+00, 9.4646114489E-01],
	[3.4725000000E+04, 2.6610465968E+01, 5.1758106319E+00, 1.0064077492E+01, 3.0289358385E+00, 9.4648580670E-01],
	[3.4730000000E+04, 2.6616986414E+01, 5.1758255964E+00, 1.0068788915E+01, 3.0294520714E+00, 9.4651045615E-01],
	[3.4735000000E+04, 2.6623507519E+01, 5.1758405589E+00, 1.0073501864E+01, 3.0299681854E+00, 9.4653509322E-01],
	[3.4740000000E+04, 2.6630029283E+01, 5.1758555193E+00, 1.0078216340E+01, 3.0304841805E+00, 9.4655971794E-01],
	[3.4745000000E+04, 2.6636551705E+01, 5.1758704775E+00, 1.0082932342E+01, 3.0310000568E+00, 9.4658433031E-01],
	[3.4750000000E+04, 2.6643074786E+01, 5.1758854337E+00, 1.0087649870E+01, 3.0315158143E+00, 9.4660893033E-01],
	[3.4755000000E+04, 2.6649598525E+01, 5.1759003877E+00, 1.0092368926E+01, 3.0320314529E+00, 9.4663351801E-01],
	[3.4760000000E+04, 2.6656122923E+01, 5.1759153396E+00, 1.0097089509E+01, 3.0325469727E+00, 9.4665809336E-01],
	[3.4765000000E+04, 2.6662647980E+01, 5.1759302894E+00, 1.0101811619E+01, 3.0330623736E+00, 9.4668265638E-01],
	[3.4770000000E+04, 2.6669173695E+01, 5.1759452371E+00, 1.0106535257E+01, 3.0335776558E+00, 9.4670720708E-01],
	[3.4775000000E+04, 2.6675700069E+01, 5.1759601827E+00, 1.0111260424E+01, 3.0340928191E+00, 9.4673174547E-01],
	[3.4780000000E+04, 2.6682227101E+01, 5.1759751262E+00, 1.0115987118E+01, 3.0346078636E+00, 9.4675627155E-01],
	[3.4785000000E+04, 2.6688754791E+01, 5.1759900676E+00, 1.0120715342E+01, 3.0351227892E+00, 9.4678078533E-01],
	[3.4790000000E+04, 2.6695283140E+01, 5.1760050069E+00, 1.0125445094E+01, 3.0356375961E+00, 9.4680528681E-01],
	[3.4795000000E+04, 2.6701812147E+01, 5.1760199441E+00, 1.0130176375E+01, 3.0361522842E+00, 9.4682977600E-01],
	[3.4800000000E+04, 2.6708341813E+01, 5.1760348792E+00, 1.0134909186E+01, 3.0366668534E+00, 9.4685425292E-01],
	[3.4805000000E+04, 2.6714872137E+01, 5.1760498122E+00, 1.0139643527E+01, 3.0371813039E+00, 9.4687871755E-01],
	[3.4810000000E+04, 2.6721403119E+01, 5.1760647430E+00, 1.0144379397E+01, 3.0376956356E+00, 9.4690316991E-01],
	[3.4815000000E+04, 2.6727934760E+01, 5.1760796718E+00, 1.0149116798E+01, 3.0382098485E+00, 9.4692761002E-01],
	[3.4820000000E+04, 2.6734467058E+01, 5.1760945985E+00, 1.0153855730E+01, 3.0387239426E+00, 9.4695203786E-01],
	[3.4825000000E+04, 2.6741000015E+01, 5.1761095231E+00, 1.0158596192E+01, 3.0392379179E+00, 9.4697645345E-01],
	[3.4830000000E+04, 2.6747533630E+01, 5.1761244455E+00, 1.0163338185E+01, 3.0397517744E+00, 9.4700085680E-01],
	[3.4835000000E+04, 2.6754067904E+01, 5.1761393659E+00, 1.0168081710E+01, 3.0402655122E+00, 9.4702524791E-01],
	[3.4840000000E+04, 2.6760602835E+01, 5.1761542842E+00, 1.0172826766E+01, 3.0407791312E+00, 9.4704962679E-01],
	[3.4845000000E+04, 2.6767138424E+01, 5.1761692004E+00, 1.0177573355E+01, 3.0412926315E+00, 9.4707399344E-01],
	[3.4850000000E+04, 2.6773674672E+01, 5.1761841145E+00, 1.0182321475E+01, 3.0418060130E+00, 9.4709834788E-01],
	[3.4855000000E+04, 2.6780211578E+01, 5.1761990264E+00, 1.0187071128E+01, 3.0423192757E+00, 9.4712269009E-01],
	[3.4860000000E+04, 2.6786749141E+01, 5.1762139363E+00, 1.0191822314E+01, 3.0428324197E+00, 9.4714702011E-01],
	[3.4865000000E+04, 2.6793287363E+01, 5.1762288441E+00, 1.0196575033E+01, 3.0433454450E+00, 9.4717133792E-01],
	[3.4870000000E+04, 2.6799826242E+01, 5.1762437498E+00, 1.0201329285E+01, 3.0438583515E+00, 9.4719564354E-01],
	[3.4875000000E+04, 2.6806365780E+01, 5.1762586534E+00, 1.0206085070E+01, 3.0443711392E+00, 9.4721993697E-01],
	[3.4880000000E+04, 2.6812905975E+01, 5.1762735549E+00, 1.0210842390E+01, 3.0448838083E+00, 9.4724421822E-01],
	[3.4885000000E+04, 2.6819446828E+01, 5.1762884544E+00, 1.0215601243E+01, 3.0453963586E+00, 9.4726848729E-01],
	[3.4890000000E+04, 2.6825988339E+01, 5.1763033517E+00, 1.0220361631E+01, 3.0459087902E+00, 9.4729274420E-01],
	[3.4895000000E+04, 2.6832530508E+01, 5.1763182469E+00, 1.0225123554E+01, 3.0464211031E+00, 9.4731698894E-01],
	[3.4900000000E+04, 2.6839073335E+01, 5.1763331401E+00, 1.0229887012E+01, 3.0469332973E+00, 9.4734122153E-01],
	[3.4905000000E+04, 2.6845616819E+01, 5.1763480311E+00, 1.0234652004E+01, 3.0474453727E+00, 9.4736544196E-01],
	[3.4910000000E+04, 2.6852160961E+01, 5.1763629201E+00, 1.0239418533E+01, 3.0479573295E+00, 9.4738965026E-01],
	[3.4915000000E+04, 2.6858705761E+01, 5.1763778069E+00, 1.0244186597E+01, 3.0484691675E+00, 9.4741384641E-01],
	[3.4920000000E+04, 2.6865251219E+01, 5.1763926917E+00, 1.0248956197E+01, 3.0489808869E+00, 9.4743803044E-01],
	[3.4925000000E+04, 2.6871797334E+01, 5.1764075744E+00, 1.0253727333E+01, 3.0494924876E+00, 9.4746220234E-01],
	[3.4930000000E+04, 2.6878344106E+01, 5.1764224550E+00, 1.0258500006E+01, 3.0500039696E+00, 9.4748636212E-01],
	[3.4935000000E+04, 2.6884891537E+01, 5.1764373335E+00, 1.0263274216E+01, 3.0505153329E+00, 9.4751050978E-01],
	[3.4940000000E+04, 2.6891439625E+01, 5.1764522100E+00, 1.0268049963E+01, 3.0510265776E+00, 9.4753464535E-01],
	[3.4945000000E+04, 2.6897988370E+01, 5.1764670843E+00, 1.0272827247E+01, 3.0515377036E+00, 9.4755876881E-01],
	[3.4950000000E+04, 2.6904537773E+01, 5.1764819566E+00, 1.0277606069E+01, 3.0520487109E+00, 9.4758288018E-01],
	[3.4955000000E+04, 2.6911087833E+01, 5.1764968268E+00, 1.0282386429E+01, 3.0525595996E+00, 9.4760697946E-01],
	[3.4960000000E+04, 2.6917638551E+01, 5.1765116949E+00, 1.0287168328E+01, 3.0530703696E+00, 9.4763106666E-01],
	[3.4965000000E+04, 2.6924189927E+01, 5.1765265609E+00, 1.0291951764E+01, 3.0535810210E+00, 9.4765514179E-01],
	[3.4970000000E+04, 2.6930741959E+01, 5.1765414248E+00, 1.0296736740E+01, 3.0540915537E+00, 9.4767920485E-01],
	[3.4975000000E+04, 2.6937294649E+01, 5.1765562866E+00, 1.0301523255E+01, 3.0546019678E+00, 9.4770325585E-01],
	[3.4980000000E+04, 2.6943847997E+01, 5.1765711464E+00, 1.0306311309E+01, 3.0551122632E+00, 9.4772729479E-01],
	[3.4985000000E+04, 2.6950402001E+01, 5.1765860041E+00, 1.0311100902E+01, 3.0556224401E+00, 9.4775132168E-01],
	[3.4990000000E+04, 2.6956956663E+01, 5.1766008597E+00, 1.0315892036E+01, 3.0561324983E+00, 9.4777533653E-01],
	[3.4995000000E+04, 2.6963511982E+01, 5.1766157132E+00, 1.0320684709E+01, 3.0566424379E+00, 9.4779933935E-01],
	[3.5000000000E+04, 2.6970067959E+01, 5.1766305646E+00, 1.0325478923E+01, 3.0571522588E+00, 9.4782333013E-01],
	[3.5005000000E+04, 2.6976624592E+01, 5.1766454140E+00, 1.0330280222E+01, 3.0576624470E+00, 9.4784730889E-01],
	[3.5010000000E+04, 2.6983181883E+01, 5.1766602613E+00, 1.0335083067E+01, 3.0581725163E+00, 9.4787127563E-01],
	[3.5015000000E+04, 2.6989739831E+01, 5.1766751065E+00, 1.0339887457E+01, 3.0586824669E+00, 9.4789523035E-01],
	[3.5020000000E+04, 2.6996298436E+01, 5.1766899496E+00, 1.0344693393E+01, 3.0591922986E+00, 9.4791917308E-01],
	[3.5025000000E+04, 2.7002857698E+01, 5.1767047907E+00, 1.0349500876E+01, 3.0597020116E+00, 9.4794310380E-01],
	[3.5030000000E+04, 2.7009417617E+01, 5.1767196297E+00, 1.0354309905E+01, 3.0602116059E+00, 9.4796702253E-01],
	[3.5035000000E+04, 2.7015978193E+01, 5.1767344666E+00, 1.0359120481E+01, 3.0607210813E+00, 9.4799092928E-01],
	[3.5040000000E+04, 2.7022539427E+01, 5.1767493014E+00, 1.0363932604E+01, 3.0612304381E+00, 9.4801482404E-01],
	[3.5045000000E+04, 2.7029101317E+01, 5.1767641341E+00, 1.0368746274E+01, 3.0617396760E+00, 9.4803870683E-01],
	[3.5050000000E+04, 2.7035663864E+01, 5.1767789648E+00, 1.0373561492E+01, 3.0622487953E+00, 9.4806257765E-01],
	[3.5055000000E+04, 2.7042227068E+01, 5.1767937934E+00, 1.0378378258E+01, 3.0627577958E+00, 9.4808643651E-01],
	[3.5060000000E+04, 2.7048790929E+01, 5.1768086199E+00, 1.0383196572E+01, 3.0632666775E+00, 9.4811028342E-01],
	[3.5065000000E+04, 2.7055355446E+01, 5.1768234444E+00, 1.0388016435E+01, 3.0637754406E+00, 9.4813411838E-01],
	[3.5070000000E+04, 2.7061920621E+01, 5.1768382668E+00, 1.0392837846E+01, 3.0642840849E+00, 9.4815794139E-01],
	[3.5075000000E+04, 2.7068486452E+01, 5.1768530871E+00, 1.0397660807E+01, 3.0647926105E+00, 9.4818175247E-01],
	[3.5080000000E+04, 2.7075052941E+01, 5.1768679054E+00, 1.0402485316E+01, 3.0653010173E+00, 9.4820555162E-01],
	[3.5085000000E+04, 2.7081620085E+01, 5.1768827215E+00, 1.0407311376E+01, 3.0658093055E+00, 9.4822933884E-01],
	[3.5090000000E+04, 2.7088200661E+01, 5.1768993008E+00, 1.0412138985E+01, 3.0663182580E+00, 9.4825311415E-01],
	[3.5095000000E+04, 2.7094788113E+01, 5.1769167364E+00, 1.0416968144E+01, 3.0668274730E+00, 9.4827687754E-01],
	[3.5100000000E+04, 2.7101376228E+01, 5.1769341696E+00, 1.0421798854E+01, 3.0673365698E+00, 9.4830062903E-01],
	[3.5105000000E+04, 2.7107965007E+01, 5.1769516003E+00, 1.0426631115E+01, 3.0678455484E+00, 9.4832436862E-01],
	[3.5110000000E+04, 2.7114554448E+01, 5.1769690286E+00, 1.0431464926E+01, 3.0683544088E+00, 9.4834809632E-01],
	[3.5115000000E+04, 2.7121144553E+01, 5.1769864545E+00, 1.0436300289E+01, 3.0688631511E+00, 9.4837181213E-01],
	[3.5120000000E+04, 2.7127735320E+01, 5.1770038780E+00, 1.0441137203E+01, 3.0693717751E+00, 9.4839551606E-01],
	[3.5125000000E+04, 2.7134326751E+01, 5.1770212991E+00, 1.0445975669E+01, 3.0698802810E+00, 9.4841920812E-01],
	[3.5130000000E+04, 2.7140918845E+01, 5.1770387177E+00, 1.0450815687E+01, 3.0703886687E+00, 9.4844288831E-01],
	[3.5135000000E+04, 2.7147511601E+01, 5.1770561339E+00, 1.0455657257E+01, 3.0708969383E+00, 9.4846655663E-01],
	[3.5140000000E+04, 2.7154105021E+01, 5.1770735477E+00, 1.0460500380E+01, 3.0714050897E+00, 9.4849021311E-01],
	[3.5145000000E+04, 2.7160699103E+01, 5.1770909591E+00, 1.0465345056E+01, 3.0719131229E+00, 9.4851385773E-01],
	[3.5150000000E+04, 2.7167293849E+01, 5.1771083681E+00, 1.0470191285E+01, 3.0724210380E+00, 9.4853749051E-01],
	[3.5155000000E+04, 2.7173889257E+01, 5.1771257746E+00, 1.0475039068E+01, 3.0729288349E+00, 9.4856111146E-01],
	[3.5160000000E+04, 2.7180485328E+01, 5.1771431787E+00, 1.0479888404E+01, 3.0734365137E+00, 9.4858472057E-01],
	[3.5165000000E+04, 2.7187082062E+01, 5.1771605804E+00, 1.0484739295E+01, 3.0739440744E+00, 9.4860831786E-01],
	[3.5170000000E+04, 2.7193679459E+01, 5.1771779797E+00, 1.0489591739E+01, 3.0744515170E+00, 9.4863190333E-01],
	[3.5175000000E+04, 2.7200277519E+01, 5.1771953766E+00, 1.0494445739E+01, 3.0749588414E+00, 9.4865547700E-01],
	[3.5180000000E+04, 2.7206876241E+01, 5.1772127710E+00, 1.0499301293E+01, 3.0754660477E+00, 9.4867903885E-01],
	[3.5185000000E+04, 2.7213475626E+01, 5.1772301631E+00, 1.0504158402E+01, 3.0759731360E+00, 9.4870258891E-01],
	[3.5190000000E+04, 2.7220075674E+01, 5.1772475527E+00, 1.0509017066E+01, 3.0764801061E+00, 9.4872612717E-01],
	[3.5195000000E+04, 2.7226676384E+01, 5.1772649400E+00, 1.0513877287E+01, 3.0769869581E+00, 9.4874965365E-01],
	[3.5200000000E+04, 2.7233277757E+01, 5.1772823248E+00, 1.0518739063E+01, 3.0774936920E+00, 9.4877316835E-01],
	[3.5205000000E+04, 2.7239879792E+01, 5.1772997072E+00, 1.0523602395E+01, 3.0780003079E+00, 9.4879667127E-01],
	[3.5210000000E+04, 2.7246482491E+01, 5.1773170872E+00, 1.0528467284E+01, 3.0785068057E+00, 9.4882016243E-01],
	[3.5215000000E+04, 2.7253085851E+01, 5.1773344647E+00, 1.0533333730E+01, 3.0790131854E+00, 9.4884364182E-01],
	[3.5220000000E+04, 2.7259689874E+01, 5.1773518399E+00, 1.0538201732E+01, 3.0795194470E+00, 9.4886710946E-01],
	[3.5225000000E+04, 2.7266294560E+01, 5.1773692127E+00, 1.0543071292E+01, 3.0800255906E+00, 9.4889056535E-01],
	[3.5230000000E+04, 2.7272899908E+01, 5.1773865830E+00, 1.0547942410E+01, 3.0805316162E+00, 9.4891400949E-01],
	[3.5235000000E+04, 2.7279505919E+01, 5.1774039510E+00, 1.0552815086E+01, 3.0810375237E+00, 9.4893744190E-01],
	[3.5240000000E+04, 2.7286112592E+01, 5.1774213165E+00, 1.0557689319E+01, 3.0815433131E+00, 9.4896086258E-01],
	[3.5245000000E+04, 2.7292719927E+01, 5.1774386797E+00, 1.0562565111E+01, 3.0820489846E+00, 9.4898427153E-01],
	[3.5250000000E+04, 2.7299327925E+01, 5.1774560404E+00, 1.0567442462E+01, 3.0825545380E+00, 9.4900766877E-01],
	[3.5255000000E+04, 2.7305936585E+01, 5.1774733987E+00, 1.0572321372E+01, 3.0830599734E+00, 9.4903105429E-01],
	[3.5260000000E+04, 2.7312545907E+01, 5.1774907546E+00, 1.0577201841E+01, 3.0835652907E+00, 9.4905442811E-01],
	[3.5265000000E+04, 2.7319155892E+01, 5.1775081082E+00, 1.0582083870E+01, 3.0840704901E+00, 9.4907779022E-01],
	[3.5270000000E+04, 2.7325766538E+01, 5.1775254593E+00, 1.0586967458E+01, 3.0845755715E+00, 9.4910114065E-01],
	[3.5275000000E+04, 2.7332377847E+01, 5.1775428080E+00, 1.0591852607E+01, 3.0850805348E+00, 9.4912447939E-01],
	[3.5280000000E+04, 2.7338989819E+01, 5.1775601543E+00, 1.0596739316E+01, 3.0855853802E+00, 9.4914780644E-01],
	[3.5285000000E+04, 2.7345602452E+01, 5.1775774982E+00, 1.0601627585E+01, 3.0860901076E+00, 9.4917112182E-01],
	[3.5290000000E+04, 2.7352215747E+01, 5.1775948398E+00, 1.0606517416E+01, 3.0865947171E+00, 9.4919442554E-01],
	[3.5295000000E+04, 2.7358829705E+01, 5.1776121789E+00, 1.0611408808E+01, 3.0870992086E+00, 9.4921771759E-01],
	[3.5300000000E+04, 2.7365444325E+01, 5.1776295156E+00, 1.0616301761E+01, 3.0876035821E+00, 9.4924099798E-01],
	[3.5305000000E+04, 2.7372059606E+01, 5.1776468499E+00, 1.0621196276E+01, 3.0881078376E+00, 9.4926426673E-01],
	[3.5310000000E+04, 2.7378675550E+01, 5.1776641818E+00, 1.0626092353E+01, 3.0886119752E+00, 9.4928752382E-01],
	[3.5315000000E+04, 2.7385292156E+01, 5.1776815114E+00, 1.0630989992E+01, 3.0891159949E+00, 9.4931076928E-01],
	[3.5320000000E+04, 2.7391909424E+01, 5.1776988385E+00, 1.0635889194E+01, 3.0896198966E+00, 9.4933400311E-01],
	[3.5325000000E+04, 2.7398527353E+01, 5.1777161633E+00, 1.0640789959E+01, 3.0901236805E+00, 9.4935722530E-01],
	[3.5330000000E+04, 2.7405145945E+01, 5.1777334856E+00, 1.0645692286E+01, 3.0906273463E+00, 9.4938043587E-01],
	[3.5335000000E+04, 2.7411765198E+01, 5.1777508056E+00, 1.0650596178E+01, 3.0911308943E+00, 9.4940363483E-01],
	[3.5340000000E+04, 2.7418385113E+01, 5.1777681231E+00, 1.0655501633E+01, 3.0916343244E+00, 9.4942682217E-01],
	[3.5345000000E+04, 2.7425005690E+01, 5.1777854383E+00, 1.0660408652E+01, 3.0921376366E+00, 9.4944999790E-01],
	[3.5350000000E+04, 2.7431626929E+01, 5.1778027511E+00, 1.0665317235E+01, 3.0926408309E+00, 9.4947316203E-01],
	[3.5355000000E+04, 2.7438248830E+01, 5.1778200614E+00, 1.0670227383E+01, 3.0931439073E+00, 9.4949631457E-01],
	[3.5360000000E+04, 2.7444871392E+01, 5.1778373694E+00, 1.0675139095E+01, 3.0936468658E+00, 9.4951945552E-01],
	[3.5365000000E+04, 2.7451494617E+01, 5.1778546751E+00, 1.0680052373E+01, 3.0941497064E+00, 9.4954258488E-01],
	[3.5370000000E+04, 2.7458118502E+01, 5.1778719783E+00, 1.0684967216E+01, 3.0946524292E+00, 9.4956570267E-01],
	[3.5375000000E+04, 2.7464743050E+01, 5.1778892791E+00, 1.0689883624E+01, 3.0951550341E+00, 9.4958880888E-01],
	[3.5380000000E+04, 2.7471368259E+01, 5.1779065775E+00, 1.0694801599E+01, 3.0956575212E+00, 9.4961190352E-01],
	[3.5385000000E+04, 2.7477994130E+01, 5.1779238736E+00, 1.0699721140E+01, 3.0961598904E+00, 9.4963498661E-01],
	[3.5390000000E+04, 2.7484620662E+01, 5.1779411673E+00, 1.0704642247E+01, 3.0966621418E+00, 9.4965805813E-01],
	[3.5395000000E+04, 2.7491247856E+01, 5.1779584586E+00, 1.0709564921E+01, 3.0971642754E+00, 9.4968111811E-01],
	[3.5400000000E+04, 2.7497875711E+01, 5.1779757475E+00, 1.0714489161E+01, 3.0976662912E+00, 9.4970416654E-01],
	[3.5405000000E+04, 2.7504504228E+01, 5.1779930340E+00, 1.0719414970E+01, 3.0981681891E+00, 9.4972720342E-01],
	[3.5410000000E+04, 2.7511133406E+01, 5.1780103181E+00, 1.0724342345E+01, 3.0986699692E+00, 9.4975022878E-01],
	[3.5415000000E+04, 2.7517763246E+01, 5.1780275999E+00, 1.0729271289E+01, 3.0991716315E+00, 9.4977324261E-01],
	[3.5420000000E+04, 2.7524393747E+01, 5.1780448792E+00, 1.0734201801E+01, 3.0996731761E+00, 9.4979624491E-01],
	[3.5425000000E+04, 2.7531024910E+01, 5.1780621562E+00, 1.0739133881E+01, 3.1001746028E+00, 9.4981923570E-01],
	[3.5430000000E+04, 2.7537656734E+01, 5.1780794308E+00, 1.0744067530E+01, 3.1006759118E+00, 9.4984221497E-01],
	[3.5435000000E+04, 2.7544289219E+01, 5.1780967030E+00, 1.0749002748E+01, 3.1011771030E+00, 9.4986518274E-01],
	[3.5440000000E+04, 2.7550922366E+01, 5.1781139729E+00, 1.0753939535E+01, 3.1016781764E+00, 9.4988813901E-01],
	[3.5445000000E+04, 2.7557556174E+01, 5.1781312404E+00, 1.0758877891E+01, 3.1021791321E+00, 9.4991108378E-01],
	[3.5450000000E+04, 2.7564190643E+01, 5.1781485054E+00, 1.0763817817E+01, 3.1026799700E+00, 9.4993401706E-01],
	[3.5455000000E+04, 2.7570825773E+01, 5.1781657682E+00, 1.0768759314E+01, 3.1031806902E+00, 9.4995693886E-01],
	[3.5460000000E+04, 2.7577461565E+01, 5.1781830285E+00, 1.0773702381E+01, 3.1036812927E+00, 9.4997984918E-01],
	[3.5465000000E+04, 2.7584098017E+01, 5.1782002865E+00, 1.0778647018E+01, 3.1041817774E+00, 9.5000274802E-01],
	[3.5470000000E+04, 2.7590735131E+01, 5.1782175420E+00, 1.0783593226E+01, 3.1046821444E+00, 9.5002563540E-01],
	[3.5475000000E+04, 2.7597372906E+01, 5.1782347952E+00, 1.0788541006E+01, 3.1051823937E+00, 9.5004851132E-01],
	[3.5480000000E+04, 2.7604011342E+01, 5.1782520461E+00, 1.0793490356E+01, 3.1056825253E+00, 9.5007137578E-01],
	[3.5485000000E+04, 2.7610650439E+01, 5.1782692945E+00, 1.0798441279E+01, 3.1061825392E+00, 9.5009422880E-01],
	[3.5490000000E+04, 2.7617290197E+01, 5.1782865406E+00, 1.0803393774E+01, 3.1066824354E+00, 9.5011707036E-01],
	[3.5495000000E+04, 2.7623930616E+01, 5.1783037843E+00, 1.0808347840E+01, 3.1071822139E+00, 9.5013990049E-01],
	[3.5500000000E+04, 2.7630571697E+01, 5.1783210257E+00, 1.0813303480E+01, 3.1076818747E+00, 9.5016271918E-01],
	[3.5505000000E+04, 2.7637213438E+01, 5.1783382647E+00, 1.0818260692E+01, 3.1081814179E+00, 9.5018552645E-01],
	[3.5510000000E+04, 2.7643855840E+01, 5.1783555013E+00, 1.0823219477E+01, 3.1086808434E+00, 9.5020832229E-01],
	[3.5515000000E+04, 2.7650498902E+01, 5.1783727355E+00, 1.0828179836E+01, 3.1091801513E+00, 9.5023110671E-01],
	[3.5520000000E+04, 2.7657142626E+01, 5.1783899674E+00, 1.0833141769E+01, 3.1096793416E+00, 9.5025387973E-01],
	[3.5525000000E+04, 2.7663787011E+01, 5.1784071969E+00, 1.0838105275E+01, 3.1101784141E+00, 9.5027664133E-01],
	[3.5530000000E+04, 2.7670432056E+01, 5.1784244240E+00, 1.0843070356E+01, 3.1106773691E+00, 9.5029939154E-01],
	[3.5535000000E+04, 2.7677077762E+01, 5.1784416488E+00, 1.0848037011E+01, 3.1111762065E+00, 9.5032213035E-01],
	[3.5540000000E+04, 2.7683724129E+01, 5.1784588712E+00, 1.0853005241E+01, 3.1116749262E+00, 9.5034485778E-01],
	[3.5545000000E+04, 2.7690371157E+01, 5.1784760912E+00, 1.0857975045E+01, 3.1121735283E+00, 9.5036757381E-01],
	[3.5550000000E+04, 2.7697018845E+01, 5.1784933089E+00, 1.0862946426E+01, 3.1126720129E+00, 9.5039027848E-01],
	[3.5555000000E+04, 2.7703667194E+01, 5.1785105242E+00, 1.0867919382E+01, 3.1131703798E+00, 9.5041297176E-01],
	[3.5560000000E+04, 2.7710316204E+01, 5.1785277371E+00, 1.0872893913E+01, 3.1136686292E+00, 9.5043565369E-01],
	[3.5565000000E+04, 2.7716965875E+01, 5.1785449477E+00, 1.0877870021E+01, 3.1141667610E+00, 9.5045832425E-01],
	[3.5570000000E+04, 2.7723616205E+01, 5.1785621559E+00, 1.0882847705E+01, 3.1146647752E+00, 9.5048098345E-01],
	[3.5575000000E+04, 2.7730267197E+01, 5.1785793617E+00, 1.0887826966E+01, 3.1151626719E+00, 9.5050363130E-01],
	[3.5580000000E+04, 2.7736918849E+01, 5.1785965652E+00, 1.0892807805E+01, 3.1156604510E+00, 9.5052626781E-01],
	[3.5585000000E+04, 2.7743571162E+01, 5.1786137664E+00, 1.0897790220E+01, 3.1161581126E+00, 9.5054889298E-01],
	[3.5590000000E+04, 2.7750224135E+01, 5.1786309651E+00, 1.0902774213E+01, 3.1166556567E+00, 9.5057150682E-01],
	[3.5595000000E+04, 2.7756877768E+01, 5.1786481616E+00, 1.0907759783E+01, 3.1171530832E+00, 9.5059410933E-01],
	[3.5600000000E+04, 2.7763532062E+01, 5.1786653556E+00, 1.0912746932E+01, 3.1176503922E+00, 9.5061670052E-01],
	[3.5605000000E+04, 2.7770187016E+01, 5.1786825473E+00, 1.0917735659E+01, 3.1181475837E+00, 9.5063928039E-01],
	[3.5610000000E+04, 2.7776842631E+01, 5.1786997366E+00, 1.0922725965E+01, 3.1186446577E+00, 9.5066184895E-01],
	[3.5615000000E+04, 2.7783498906E+01, 5.1787169236E+00, 1.0927717850E+01, 3.1191416143E+00, 9.5068440620E-01],
	[3.5620000000E+04, 2.7790155841E+01, 5.1787341083E+00, 1.0932711314E+01, 3.1196384533E+00, 9.5070695215E-01],
	[3.5625000000E+04, 2.7796813437E+01, 5.1787512905E+00, 1.0937706357E+01, 3.1201351748E+00, 9.5072948681E-01],
	[3.5630000000E+04, 2.7803471693E+01, 5.1787684704E+00, 1.0942702981E+01, 3.1206317789E+00, 9.5075201018E-01],
	[3.5635000000E+04, 2.7810130609E+01, 5.1787856480E+00, 1.0947701184E+01, 3.1211282656E+00, 9.5077452227E-01],
	[3.5640000000E+04, 2.7816790186E+01, 5.1788028232E+00, 1.0952700967E+01, 3.1216246348E+00, 9.5079702308E-01],
	[3.5645000000E+04, 2.7823450422E+01, 5.1788199961E+00, 1.0957702332E+01, 3.1221208865E+00, 9.5081951261E-01],
	[3.5650000000E+04, 2.7830111319E+01, 5.1788371666E+00, 1.0962705277E+01, 3.1226170208E+00, 9.5084199088E-01],
	[3.5655000000E+04, 2.7836786087E+01, 5.1788561402E+00, 1.0967709803E+01, 3.1231138606E+00, 9.5086445789E-01],
	[3.5660000000E+04, 2.7843467094E+01, 5.1788758729E+00, 1.0972715910E+01, 3.1236109305E+00, 9.5088691364E-01],
	[3.5665000000E+04, 2.7850148767E+01, 5.1788956028E+00, 1.0977723600E+01, 3.1241078835E+00, 9.5090935815E-01],
	[3.5670000000E+04, 2.7856831107E+01, 5.1789153301E+00, 1.0982732871E+01, 3.1246047195E+00, 9.5093179140E-01],
	[3.5675000000E+04, 2.7863514113E+01, 5.1789350547E+00, 1.0987743725E+01, 3.1251014385E+00, 9.5095421342E-01],
	[3.5680000000E+04, 2.7870197786E+01, 5.1789547765E+00, 1.0992756161E+01, 3.1255980407E+00, 9.5097662421E-01],
	[3.5685000000E+04, 2.7876882125E+01, 5.1789744957E+00, 1.0997770180E+01, 3.1260945259E+00, 9.5099902377E-01],
	[3.5690000000E+04, 2.7883567130E+01, 5.1789942122E+00, 1.1002785782E+01, 3.1265908943E+00, 9.5102141211E-01],
	[3.5695000000E+04, 2.7890252801E+01, 5.1790139260E+00, 1.1007802967E+01, 3.1270871457E+00, 9.5104378923E-01],
	[3.5700000000E+04, 2.7896939139E+01, 5.1790336372E+00, 1.1012821736E+01, 3.1275832802E+00, 9.5106615514E-01],
	[3.5705000000E+04, 2.7903626143E+01, 5.1790533456E+00, 1.1017842089E+01, 3.1280792979E+00, 9.5108850984E-01],
	[3.5710000000E+04, 2.7910313813E+01, 5.1790730514E+00, 1.1022864027E+01, 3.1285751987E+00, 9.5111085335E-01],
	[3.5715000000E+04, 2.7917002149E+01, 5.1790927544E+00, 1.1027887548E+01, 3.1290709826E+00, 9.5113318566E-01],
	[3.5720000000E+04, 2.7923691152E+01, 5.1791124548E+00, 1.1032912655E+01, 3.1295666497E+00, 9.5115550678E-01],
	[3.5725000000E+04, 2.7930380820E+01, 5.1791321525E+00, 1.1037939346E+01, 3.1300621999E+00, 9.5117781672E-01],
	[3.5730000000E+04, 2.7937071155E+01, 5.1791518476E+00, 1.1042967623E+01, 3.1305576333E+00, 9.5120011548E-01],
	[3.5735000000E+04, 2.7943762156E+01, 5.1791715399E+00, 1.1047997485E+01, 3.1310529498E+00, 9.5122240307E-01],
	[3.5740000000E+04, 2.7950453822E+01, 5.1791912296E+00, 1.1053028934E+01, 3.1315481495E+00, 9.5124467949E-01],
	[3.5745000000E+04, 2.7957146155E+01, 5.1792109165E+00, 1.1058061968E+01, 3.1320432325E+00, 9.5126694475E-01],
	[3.5750000000E+04, 2.7963839154E+01, 5.1792306009E+00, 1.1063096589E+01, 3.1325381986E+00, 9.5128919886E-01],
	[3.5755000000E+04, 2.7970532819E+01, 5.1792502825E+00, 1.1068132797E+01, 3.1330330479E+00, 9.5131144181E-01],
	[3.5760000000E+04, 2.7977227150E+01, 5.1792699614E+00, 1.1073170591E+01, 3.1335277804E+00, 9.5133367363E-01],
	[3.5765000000E+04, 2.7983922146E+01, 5.1792896377E+00, 1.1078209973E+01, 3.1340223961E+00, 9.5135589430E-01],
	[3.5770000000E+04, 2.7990617809E+01, 5.1793093113E+00, 1.1083250942E+01, 3.1345168951E+00, 9.5137810384E-01],
	[3.5775000000E+04, 2.7997314137E+01, 5.1793289822E+00, 1.1088293499E+01, 3.1350112773E+00, 9.5140030225E-01],
	[3.5780000000E+04, 2.8004011131E+01, 5.1793486505E+00, 1.1093337645E+01, 3.1355055428E+00, 9.5142248955E-01],
	[3.5785000000E+04, 2.8010708791E+01, 5.1793683161E+00, 1.1098383378E+01, 3.1359996915E+00, 9.5144466572E-01],
	[3.5790000000E+04, 2.8017407117E+01, 5.1793879790E+00, 1.1103430700E+01, 3.1364937235E+00, 9.5146683079E-01],
	[3.5795000000E+04, 2.8024106108E+01, 5.1794076392E+00, 1.1108479612E+01, 3.1369876388E+00, 9.5148898475E-01],
	[3.5800000000E+04, 2.8030805766E+01, 5.1794272967E+00, 1.1113530112E+01, 3.1374814373E+00, 9.5151112761E-01],
	[3.5805000000E+04, 2.8037506089E+01, 5.1794469516E+00, 1.1118582202E+01, 3.1379751191E+00, 9.5153325937E-01],
	[3.5810000000E+04, 2.8044207077E+01, 5.1794666039E+00, 1.1123635881E+01, 3.1384686843E+00, 9.5155538005E-01],
	[3.5815000000E+04, 2.8050908731E+01, 5.1794862534E+00, 1.1128691151E+01, 3.1389621327E+00, 9.5157748964E-01],
	[3.5820000000E+04, 2.8057611051E+01, 5.1795059003E+00, 1.1133748011E+01, 3.1394554645E+00, 9.5159958816E-01],
	[3.5825000000E+04, 2.8064314037E+01, 5.1795255445E+00, 1.1138806462E+01, 3.1399486795E+00, 9.5162167560E-01],
	[3.5830000000E+04, 2.8071017688E+01, 5.1795451860E+00, 1.1143866503E+01, 3.1404417780E+00, 9.5164375198E-01],
	[3.5835000000E+04, 2.8077722004E+01, 5.1795648249E+00, 1.1148928136E+01, 3.1409347597E+00, 9.5166581730E-01],
	[3.5840000000E+04, 2.8084426986E+01, 5.1795844611E+00, 1.1153991360E+01, 3.1414276248E+00, 9.5168787156E-01],
	[3.5845000000E+04, 2.8091132634E+01, 5.1796040947E+00, 1.1159056175E+01, 3.1419203733E+00, 9.5170991478E-01],
	[3.5850000000E+04, 2.8097838947E+01, 5.1796237256E+00, 1.1164122583E+01, 3.1424130052E+00, 9.5173194694E-01],
	[3.5855000000E+04, 2.8104545925E+01, 5.1796433538E+00, 1.1169190583E+01, 3.1429055204E+00, 9.5175396808E-01],
	[3.5860000000E+04, 2.8111253569E+01, 5.1796629793E+00, 1.1174260175E+01, 3.1433979191E+00, 9.5177597817E-01],
	[3.5865000000E+04, 2.8117961878E+01, 5.1796826022E+00, 1.1179331361E+01, 3.1438902011E+00, 9.5179797724E-01],
	[3.5870000000E+04, 2.8124670853E+01, 5.1797022225E+00, 1.1184404139E+01, 3.1443823665E+00, 9.5181996529E-01],
	[3.5875000000E+04, 2.8131380492E+01, 5.1797218401E+00, 1.1189478511E+01, 3.1448744154E+00, 9.5184194232E-01],
	[3.5880000000E+04, 2.8138090797E+01, 5.1797414550E+00, 1.1194554476E+01, 3.1453663477E+00, 9.5186390834E-01],
	[3.5885000000E+04, 2.8144801768E+01, 5.1797610672E+00, 1.1199632036E+01, 3.1458581634E+00, 9.5188586336E-01],
	[3.5890000000E+04, 2.8151513403E+01, 5.1797806768E+00, 1.1204711189E+01, 3.1463498625E+00, 9.5190780738E-01],
	[3.5895000000E+04, 2.8158225704E+01, 5.1798002838E+00, 1.1209791937E+01, 3.1468414452E+00, 9.5192974040E-01],
	[3.5900000000E+04, 2.8164938670E+01, 5.1798198881E+00, 1.1214874280E+01, 3.1473329112E+00, 9.5195166243E-01],
	[3.5905000000E+04, 2.8171652302E+01, 5.1798394897E+00, 1.1219958218E+01, 3.1478242608E+00, 9.5197357348E-01],
	[3.5910000000E+04, 2.8178366598E+01, 5.1798590887E+00, 1.1225043751E+01, 3.1483154938E+00, 9.5199547356E-01],
	[3.5915000000E+04, 2.8185081559E+01, 5.1798786850E+00, 1.1230130880E+01, 3.1488066104E+00, 9.5201736266E-01],
	[3.5920000000E+04, 2.8191797186E+01, 5.1798982786E+00, 1.1235219604E+01, 3.1492976104E+00, 9.5203924079E-01],
	[3.5925000000E+04, 2.8198513477E+01, 5.1799178696E+00, 1.1240309925E+01, 3.1497884939E+00, 9.5206110797E-01],
	[3.5930000000E+04, 2.8205230434E+01, 5.1799374580E+00, 1.1245401842E+01, 3.1502792610E+00, 9.5208296419E-01],
	[3.5935000000E+04, 2.8211948056E+01, 5.1799570437E+00, 1.1250495356E+01, 3.1507699116E+00, 9.5210480946E-01],
	[3.5940000000E+04, 2.8218666342E+01, 5.1799766268E+00, 1.1255590467E+01, 3.1512604457E+00, 9.5212664378E-01],
	[3.5945000000E+04, 2.8225385294E+01, 5.1799962072E+00, 1.1260687175E+01, 3.1517508634E+00, 9.5214846717E-01],
	[3.5950000000E+04, 2.8232104910E+01, 5.1800157849E+00, 1.1265785481E+01, 3.1522411647E+00, 9.5217027962E-01],
	[3.5955000000E+04, 2.8238825191E+01, 5.1800353600E+00, 1.1270885384E+01, 3.1527313495E+00, 9.5219208115E-01],
	[3.5960000000E+04, 2.8245546137E+01, 5.1800549325E+00, 1.1275986886E+01, 3.1532214179E+00, 9.5221387175E-01],
	[3.5965000000E+04, 2.8252267749E+01, 5.1800745023E+00, 1.1281089986E+01, 3.1537113698E+00, 9.5223565144E-01],
	[3.5970000000E+04, 2.8258990024E+01, 5.1800940695E+00, 1.1286194684E+01, 3.1542012054E+00, 9.5225742022E-01],
	[3.5975000000E+04, 2.8265712965E+01, 5.1801136340E+00, 1.1291300982E+01, 3.1546909246E+00, 9.5227917809E-01],
	[3.5980000000E+04, 2.8272436570E+01, 5.1801331959E+00, 1.1296408878E+01, 3.1551805274E+00, 9.5230092506E-01],
	[3.5985000000E+04, 2.8279160840E+01, 5.1801527551E+00, 1.1301518375E+01, 3.1556700138E+00, 9.5232266114E-01],
	[3.5990000000E+04, 2.8285885775E+01, 5.1801723117E+00, 1.1306629471E+01, 3.1561593839E+00, 9.5234438633E-01],
	[3.5995000000E+04, 2.8292611375E+01, 5.1801918656E+00, 1.1311742167E+01, 3.1566486376E+00, 9.5236610063E-01],
	[3.6000000000E+04, 2.8299337639E+01, 5.1802114169E+00, 1.1316856463E+01, 3.1571377749E+00, 9.5238780406E-01],
	[3.6005000000E+04, 2.8306064568E+01, 5.1802309656E+00, 1.1321972360E+01, 3.1576267960E+00, 9.5240949662E-01],
	[3.6010000000E+04, 2.8312792161E+01, 5.1802505116E+00, 1.1327089858E+01, 3.1581157007E+00, 9.5243117831E-01],
	[3.6015000000E+04, 2.8319520419E+01, 5.1802700550E+00, 1.1332208957E+01, 3.1586044890E+00, 9.5245284913E-01],
	[3.6020000000E+04, 2.8326249341E+01, 5.1802895957E+00, 1.1337329657E+01, 3.1590931611E+00, 9.5247450911E-01],
	[3.6025000000E+04, 2.8332978928E+01, 5.1803091338E+00, 1.1342451959E+01, 3.1595817169E+00, 9.5249615823E-01],
	[3.6030000000E+04, 2.8339709180E+01, 5.1803286693E+00, 1.1347575863E+01, 3.1600701564E+00, 9.5251779651E-01],
	[3.6035000000E+04, 2.8346440096E+01, 5.1803482021E+00, 1.1352701369E+01, 3.1605584796E+00, 9.5253942395E-01],
	[3.6040000000E+04, 2.8353171676E+01, 5.1803677323E+00, 1.1357828478E+01, 3.1610466866E+00, 9.5256104055E-01],
	[3.6045000000E+04, 2.8359903921E+01, 5.1803872599E+00, 1.1362957190E+01, 3.1615347773E+00, 9.5258264633E-01],
	[3.6050000000E+04, 2.8366636830E+01, 5.1804067848E+00, 1.1368087505E+01, 3.1620227517E+00, 9.5260424129E-01],
	[3.6055000000E+04, 2.8373370404E+01, 5.1804263071E+00, 1.1373219423E+01, 3.1625106099E+00, 9.5262582543E-01],
	[3.6060000000E+04, 2.8380104642E+01, 5.1804458267E+00, 1.1378352945E+01, 3.1629983519E+00, 9.5264739875E-01],
	[3.6065000000E+04, 2.8386839544E+01, 5.1804653438E+00, 1.1383488071E+01, 3.1634859777E+00, 9.5266896128E-01],
	[3.6070000000E+04, 2.8393575110E+01, 5.1804848581E+00, 1.1388624801E+01, 3.1639734873E+00, 9.5269051300E-01],
	[3.6075000000E+04, 2.8400311341E+01, 5.1805043699E+00, 1.1393763135E+01, 3.1644608806E+00, 9.5271205393E-01],
	[3.6080000000E+04, 2.8407048236E+01, 5.1805238790E+00, 1.1398903075E+01, 3.1649481578E+00, 9.5273358406E-01],
	[3.6085000000E+04, 2.8413785795E+01, 5.1805433855E+00, 1.1404044619E+01, 3.1654353188E+00, 9.5275510342E-01],
	[3.6090000000E+04, 2.8420524018E+01, 5.1805628894E+00, 1.1409187768E+01, 3.1659223637E+00, 9.5277661199E-01],
	[3.6095000000E+04, 2.8427262906E+01, 5.1805823906E+00, 1.1414332524E+01, 3.1664092923E+00, 9.5279810980E-01],
	[3.6100000000E+04, 2.8434002458E+01, 5.1806018892E+00, 1.1419478885E+01, 3.1668961049E+00, 9.5281959684E-01],
	[3.6105000000E+04, 2.8440742673E+01, 5.1806213852E+00, 1.1424626852E+01, 3.1673828013E+00, 9.5284107311E-01],
	[3.6110000000E+04, 2.8447483553E+01, 5.1806408786E+00, 1.1429776426E+01, 3.1678693816E+00, 9.5286253863E-01],
	[3.6115000000E+04, 2.8454225097E+01, 5.1806603693E+00, 1.1434927606E+01, 3.1683558457E+00, 9.5288399340E-01],
	[3.6120000000E+04, 2.8460967305E+01, 5.1806798574E+00, 1.1440080394E+01, 3.1688421938E+00, 9.5290543742E-01],
	[3.6125000000E+04, 2.8467710176E+01, 5.1806993429E+00, 1.1445234788E+01, 3.1693284258E+00, 9.5292687071E-01],
	[3.6130000000E+04, 2.8474453712E+01, 5.1807188257E+00, 1.1450390791E+01, 3.1698145416E+00, 9.5294829326E-01],
	[3.6135000000E+04, 2.8481197912E+01, 5.1807383060E+00, 1.1455548401E+01, 3.1703005415E+00, 9.5296970508E-01],
	[3.6140000000E+04, 2.8487942775E+01, 5.1807577836E+00, 1.1460707619E+01, 3.1707864252E+00, 9.5299110618E-01],
	[3.6145000000E+04, 2.8494688303E+01, 5.1807772586E+00, 1.1465868446E+01, 3.1712721929E+00, 9.5301249656E-01],
	[3.6150000000E+04, 2.8501434494E+01, 5.1807967310E+00, 1.1471030881E+01, 3.1717578446E+00, 9.5303387623E-01],
	[3.6155000000E+04, 2.8508181349E+01, 5.1808162007E+00, 1.1476194925E+01, 3.1722433802E+00, 9.5305524519E-01],
	[3.6160000000E+04, 2.8514928868E+01, 5.1808356678E+00, 1.1481360579E+01, 3.1727287998E+00, 9.5307660346E-01],
	[3.6165000000E+04, 2.8521677051E+01, 5.1808551324E+00, 1.1486527841E+01, 3.1732141034E+00, 9.5309795103E-01],
	[3.6170000000E+04, 2.8528425898E+01, 5.1808745942E+00, 1.1491696714E+01, 3.1736992909E+00, 9.5311928790E-01],
	[3.6175000000E+04, 2.8535175408E+01, 5.1808940535E+00, 1.1496867197E+01, 3.1741843625E+00, 9.5314061410E-01],
	[3.6180000000E+04, 2.8541925582E+01, 5.1809135102E+00, 1.1502039290E+01, 3.1746693182E+00, 9.5316192961E-01],
	[3.6185000000E+04, 2.8548676419E+01, 5.1809329642E+00, 1.1507212994E+01, 3.1751541578E+00, 9.5318323445E-01],
	[3.6190000000E+04, 2.8555427920E+01, 5.1809524157E+00, 1.1512388308E+01, 3.1756388815E+00, 9.5320452863E-01],
	[3.6195000000E+04, 2.8562180085E+01, 5.1809718645E+00, 1.1517565234E+01, 3.1761234892E+00, 9.5322581214E-01],
	[3.6200000000E+04, 2.8568932914E+01, 5.1809913107E+00, 1.1522743771E+01, 3.1766079811E+00, 9.5324708499E-01],
	[3.6205000000E+04, 2.8575686406E+01, 5.1810107543E+00, 1.1527923920E+01, 3.1770923569E+00, 9.5326834719E-01],
	[3.6210000000E+04, 2.8582440561E+01, 5.1810301953E+00, 1.1533105681E+01, 3.1775766169E+00, 9.5328959875E-01],
	[3.6215000000E+04, 2.8589195380E+01, 5.1810496336E+00, 1.1538289055E+01, 3.1780607609E+00, 9.5331083967E-01],
	[3.6220000000E+04, 2.8595950863E+01, 5.1810690694E+00, 1.1543474040E+01, 3.1785447891E+00, 9.5333206995E-01],
	[3.6225000000E+04, 2.8602707009E+01, 5.1810885025E+00, 1.1548660639E+01, 3.1790287014E+00, 9.5335328961E-01],
	[3.6230000000E+04, 2.8609480824E+01, 5.1811102314E+00, 1.1553848851E+01, 3.1795135734E+00, 9.5337449863E-01],
	[3.6235000000E+04, 2.8616256884E+01, 5.1811321702E+00, 1.1559038676E+01, 3.1799984296E+00, 9.5339569705E-01],
	[3.6240000000E+04, 2.8623033613E+01, 5.1811541061E+00, 1.1564230115E+01, 3.1804831703E+00, 9.5341688484E-01],
	[3.6245000000E+04, 2.8629811012E+01, 5.1811760391E+00, 1.1569423168E+01, 3.1809677956E+00, 9.5343806204E-01],
	[3.6250000000E+04, 2.8636589081E+01, 5.1811979691E+00, 1.1574617835E+01, 3.1814523056E+00, 9.5345922863E-01],
	[3.6255000000E+04, 2.8643367818E+01, 5.1812198961E+00, 1.1579814116E+01, 3.1819367002E+00, 9.5348038462E-01],
	[3.6260000000E+04, 2.8650147226E+01, 5.1812418203E+00, 1.1585012013E+01, 3.1824209794E+00, 9.5350153002E-01],
	[3.6265000000E+04, 2.8656927303E+01, 5.1812637415E+00, 1.1590211524E+01, 3.1829051432E+00, 9.5352266484E-01],
	[3.6270000000E+04, 2.8663708049E+01, 5.1812856598E+00, 1.1595412651E+01, 3.1833891917E+00, 9.5354378908E-01],
	[3.6275000000E+04, 2.8670489465E+01, 5.1813075751E+00, 1.1600615394E+01, 3.1838731248E+00, 9.5356490274E-01],
	[3.6280000000E+04, 2.8677271550E+01, 5.1813294876E+00, 1.1605819752E+01, 3.1843569426E+00, 9.5358600583E-01],
	[3.6285000000E+04, 2.8684054305E+01, 5.1813513971E+00, 1.1611025726E+01, 3.1848406451E+00, 9.5360709836E-01],
	[3.6290000000E+04, 2.8690837729E+01, 5.1813733037E+00, 1.1616233317E+01, 3.1853242323E+00, 9.5362818034E-01],
	[3.6295000000E+04, 2.8697621822E+01, 5.1813952073E+00, 1.1621442525E+01, 3.1858077042E+00, 9.5364925176E-01],
	[3.6300000000E+04, 2.8704406584E+01, 5.1814171080E+00, 1.1626653350E+01, 3.1862910608E+00, 9.5367031263E-01],
	[3.6305000000E+04, 2.8711192016E+01, 5.1814390058E+00, 1.1631865792E+01, 3.1867743022E+00, 9.5369136296E-01],
	[3.6310000000E+04, 2.8717978117E+01, 5.1814609007E+00, 1.1637079852E+01, 3.1872574282E+00, 9.5371240276E-01],
	[3.6315000000E+04, 2.8724764887E+01, 5.1814827927E+00, 1.1642295529E+01, 3.1877404390E+00, 9.5373343203E-01],
	[3.6320000000E+04, 2.8731552327E+01, 5.1815046817E+00, 1.1647512825E+01, 3.1882233346E+00, 9.5375445077E-01],
	[3.6325000000E+04, 2.8738340435E+01, 5.1815265678E+00, 1.1652731739E+01, 3.1887061149E+00, 9.5377545899E-01],
	[3.6330000000E+04, 2.8745129213E+01, 5.1815484510E+00, 1.1657952271E+01, 3.1891887801E+00, 9.5379645670E-01],
	[3.6335000000E+04, 2.8751918660E+01, 5.1815703313E+00, 1.1663174423E+01, 3.1896713300E+00, 9.5381744390E-01],
	[3.6340000000E+04, 2.8758708776E+01, 5.1815922086E+00, 1.1668398194E+01, 3.1901537647E+00, 9.5383842059E-01],
	[3.6345000000E+04, 2.8765499561E+01, 5.1816140831E+00, 1.1673623585E+01, 3.1906360842E+00, 9.5385938679E-01],
	[3.6350000000E+04, 2.8772291014E+01, 5.1816359546E+00, 1.1678850595E+01, 3.1911182886E+00, 9.5388034250E-01],
	[3.6355000000E+04, 2.8779083137E+01, 5.1816578232E+00, 1.1684079225E+01, 3.1916003777E+00, 9.5390128772E-01],
	[3.6360000000E+04, 2.8785875929E+01, 5.1816796889E+00, 1.1689309476E+01, 3.1920823518E+00, 9.5392222246E-01],
	[3.6365000000E+04, 2.8792669390E+01, 5.1817015517E+00, 1.1694541347E+01, 3.1925642107E+00, 9.5394314672E-01],
	[3.6370000000E+04, 2.8799463520E+01, 5.1817234116E+00, 1.1699774840E+01, 3.1930459544E+00, 9.5396406052E-01],
	[3.6375000000E+04, 2.8806258319E+01, 5.1817452685E+00, 1.1705009953E+01, 3.1935275830E+00, 9.5398496385E-01],
	[3.6380000000E+04, 2.8813053786E+01, 5.1817671225E+00, 1.1710246688E+01, 3.1940090966E+00, 9.5400585672E-01],
	[3.6385000000E+04, 2.8819849923E+01, 5.1817889737E+00, 1.1715485045E+01, 3.1944904950E+00, 9.5402673913E-01],
	[3.6390000000E+04, 2.8826646728E+01, 5.1818108219E+00, 1.1720725024E+01, 3.1949717783E+00, 9.5404761110E-01],
	[3.6395000000E+04, 2.8833444202E+01, 5.1818326672E+00, 1.1725966625E+01, 3.1954529466E+00, 9.5406847262E-01],
	[3.6400000000E+04, 2.8840242345E+01, 5.1818545096E+00, 1.1731209849E+01, 3.1959339998E+00, 9.5408932371E-01],
	[3.6405000000E+04, 2.8847041156E+01, 5.1818763491E+00, 1.1736454695E+01, 3.1964149379E+00, 9.5411016437E-01],
	[3.6410000000E+04, 2.8853840637E+01, 5.1818981857E+00, 1.1741701165E+01, 3.1968957610E+00, 9.5413099459E-01],
	[3.6415000000E+04, 2.8860640785E+01, 5.1819200193E+00, 1.1746949258E+01, 3.1973764690E+00, 9.5415181440E-01],
	[3.6420000000E+04, 2.8867441603E+01, 5.1819418501E+00, 1.1752198975E+01, 3.1978570621E+00, 9.5417262380E-01],
	[3.6425000000E+04, 2.8874243089E+01, 5.1819636780E+00, 1.1757450316E+01, 3.1983375401E+00, 9.5419342278E-01],
	[3.6430000000E+04, 2.8881045244E+01, 5.1819855029E+00, 1.1762703281E+01, 3.1988179032E+00, 9.5421421136E-01],
	[3.6435000000E+04, 2.8887848068E+01, 5.1820073250E+00, 1.1767957871E+01, 3.1992981512E+00, 9.5423498953E-01],
	[3.6440000000E+04, 2.8894651560E+01, 5.1820291442E+00, 1.1773214085E+01, 3.1997782843E+00, 9.5425575732E-01],
	[3.6445000000E+04, 2.8901455720E+01, 5.1820509604E+00, 1.1778471925E+01, 3.2002583024E+00, 9.5427651472E-01],
	[3.6450000000E+04, 2.8908260549E+01, 5.1820727738E+00, 1.1783731390E+01, 3.2007382055E+00, 9.5429726173E-01],
	[3.6455000000E+04, 2.8915066047E+01, 5.1820945842E+00, 1.1788992481E+01, 3.2012179938E+00, 9.5431799837E-01],
	[3.6460000000E+04, 2.8921872213E+01, 5.1821163918E+00, 1.1794255197E+01, 3.2016976670E+00, 9.5433872463E-01],
	[3.6465000000E+04, 2.8928679047E+01, 5.1821381964E+00, 1.1799519540E+01, 3.2021772254E+00, 9.5435944053E-01],
	[3.6470000000E+04, 2.8935486550E+01, 5.1821599982E+00, 1.1804785510E+01, 3.2026566689E+00, 9.5438014607E-01],
	[3.6475000000E+04, 2.8942294721E+01, 5.1821817971E+00, 1.1810053106E+01, 3.2031359974E+00, 9.5440084125E-01],
	[3.6480000000E+04, 2.8949103560E+01, 5.1822035930E+00, 1.1815322329E+01, 3.2036152111E+00, 9.5442152608E-01],
	[3.6485000000E+04, 2.8955913068E+01, 5.1822253861E+00, 1.1820593180E+01, 3.2040943099E+00, 9.5444220057E-01],
	[3.6490000000E+04, 2.8962723244E+01, 5.1822471763E+00, 1.1825865658E+01, 3.2045732939E+00, 9.5446286472E-01],
	[3.6495000000E+04, 2.8969534089E+01, 5.1822689635E+00, 1.1831139764E+01, 3.2050521630E+00, 9.5448351853E-01],
	[3.6500000000E+04, 2.8976345601E+01, 5.1822907479E+00, 1.1836415498E+01, 3.2055309173E+00, 9.5450416202E-01],
	[3.6505000000E+04, 2.8983157782E+01, 5.1823125294E+00, 1.1841692861E+01, 3.2060095567E+00, 9.5452479518E-01],
	[3.6510000000E+04, 2.8989970631E+01, 5.1823343080E+00, 1.1846971852E+01, 3.2064880813E+00, 9.5454541803E-01],
	[3.6515000000E+04, 2.8996784149E+01, 5.1823560837E+00, 1.1852252473E+01, 3.2069664911E+00, 9.5456603056E-01],
	[3.6520000000E+04, 2.9003598334E+01, 5.1823778566E+00, 1.1857534722E+01, 3.2074447862E+00, 9.5458663279E-01],
	[3.6525000000E+04, 2.9010413187E+01, 5.1823996265E+00, 1.1862818602E+01, 3.2079229664E+00, 9.5460722471E-01],
	[3.6530000000E+04, 2.9017228709E+01, 5.1824213935E+00, 1.1868104111E+01, 3.2084010319E+00, 9.5462780634E-01],
	[3.6535000000E+04, 2.9024044899E+01, 5.1824431577E+00, 1.1873391250E+01, 3.2088789826E+00, 9.5464837768E-01],
	[3.6540000000E+04, 2.9030861756E+01, 5.1824649190E+00, 1.1878680020E+01, 3.2093568186E+00, 9.5466893874E-01],
	[3.6545000000E+04, 2.9037679282E+01, 5.1824866773E+00, 1.1883970420E+01, 3.2098345399E+00, 9.5468948951E-01],
	[3.6550000000E+04, 2.9044497476E+01, 5.1825084328E+00, 1.1889262452E+01, 3.2103121464E+00, 9.5471003001E-01],
	[3.6555000000E+04, 2.9051316337E+01, 5.1825301855E+00, 1.1894556114E+01, 3.2107896383E+00, 9.5473056025E-01],
	[3.6560000000E+04, 2.9058135867E+01, 5.1825519352E+00, 1.1899851408E+01, 3.2112670154E+00, 9.5475108022E-01],
	[3.6565000000E+04, 2.9064956064E+01, 5.1825736820E+00, 1.1905148334E+01, 3.2117442778E+00, 9.5477158993E-01],
	[3.6570000000E+04, 2.9071776930E+01, 5.1825954260E+00, 1.1910446892E+01, 3.2122214256E+00, 9.5479208939E-01],
	[3.6575000000E+04, 2.9078598463E+01, 5.1826171671E+00, 1.1915747083E+01, 3.2126984587E+00, 9.5481257860E-01],
	[3.6580000000E+04, 2.9085420664E+01, 5.1826389053E+00, 1.1921048906E+01, 3.2131753772E+00, 9.5483305758E-01],
	[3.6585000000E+04, 2.9092243533E+01, 5.1826606406E+00, 1.1926352362E+01, 3.2136521810E+00, 9.5485352631E-01],
	[3.6590000000E+04, 2.9099067069E+01, 5.1826823730E+00, 1.1931657451E+01, 3.2141288702E+00, 9.5487398482E-01],
	[3.6595000000E+04, 2.9105891274E+01, 5.1827041026E+00, 1.1936964173E+01, 3.2146054448E+00, 9.5489443310E-01],
	[3.6600000000E+04, 2.9112716146E+01, 5.1827258293E+00, 1.1942272530E+01, 3.2150819048E+00, 9.5491487116E-01],
	[3.6605000000E+04, 2.9119541686E+01, 5.1827475531E+00, 1.1947582520E+01, 3.2155582502E+00, 9.5493529900E-01],
	[3.6610000000E+04, 2.9126367893E+01, 5.1827692740E+00, 1.1952894145E+01, 3.2160344810E+00, 9.5495571664E-01],
	[3.6615000000E+04, 2.9133194768E+01, 5.1827909921E+00, 1.1958207404E+01, 3.2165105973E+00, 9.5497612408E-01],
	[3.6620000000E+04, 2.9140022311E+01, 5.1828127073E+00, 1.1963522299E+01, 3.2169865990E+00, 9.5499652131E-01],
	[3.6625000000E+04, 2.9146850522E+01, 5.1828344196E+00, 1.1968838828E+01, 3.2174624861E+00, 9.5501690835E-01],
	[3.6630000000E+04, 2.9153679399E+01, 5.1828561290E+00, 1.1974156993E+01, 3.2179382588E+00, 9.5503728521E-01],
	[3.6635000000E+04, 2.9160508945E+01, 5.1828778356E+00, 1.1979476793E+01, 3.2184139169E+00, 9.5505765188E-01],
	[3.6640000000E+04, 2.9167339158E+01, 5.1828995393E+00, 1.1984798230E+01, 3.2188894605E+00, 9.5507800838E-01],
	[3.6645000000E+04, 2.9174170038E+01, 5.1829212401E+00, 1.1990121303E+01, 3.2193648896E+00, 9.5509835471E-01],
	[3.6650000000E+04, 2.9181001586E+01, 5.1829429381E+00, 1.1995446012E+01, 3.2198402043E+00, 9.5511869087E-01],
	[3.6655000000E+04, 2.9187833802E+01, 5.1829646331E+00, 1.2000772358E+01, 3.2203154044E+00, 9.5513901687E-01],
	[3.6660000000E+04, 2.9194666685E+01, 5.1829863254E+00, 1.2006100341E+01, 3.2207904902E+00, 9.5515933271E-01],
	[3.6665000000E+04, 2.9201500235E+01, 5.1830080147E+00, 1.2011429962E+01, 3.2212654614E+00, 9.5517963841E-01],
	[3.6670000000E+04, 2.9208334452E+01, 5.1830297012E+00, 1.2016761220E+01, 3.2217403183E+00, 9.5519993396E-01],
	[3.6675000000E+04, 2.9215169337E+01, 5.1830513848E+00, 1.2022094117E+01, 3.2222150607E+00, 9.5522021937E-01],
	[3.6680000000E+04, 2.9222004890E+01, 5.1830730656E+00, 1.2027428651E+01, 3.2226896887E+00, 9.5524049465E-01],
	[3.6685000000E+04, 2.9228841109E+01, 5.1830947434E+00, 1.2032764824E+01, 3.2231642023E+00, 9.5526075980E-01],
	[3.6690000000E+04, 2.9235677996E+01, 5.1831164185E+00, 1.2038102636E+01, 3.2236386016E+00, 9.5528101483E-01],
	[3.6695000000E+04, 2.9242515550E+01, 5.1831380906E+00, 1.2043442087E+01, 3.2241128865E+00, 9.5530125975E-01],
	[3.6700000000E+04, 2.9249353771E+01, 5.1831597599E+00, 1.2048783177E+01, 3.2245870570E+00, 9.5532149455E-01],
	[3.6705000000E+04, 2.9256192659E+01, 5.1831814264E+00, 1.2054125907E+01, 3.2250611131E+00, 9.5534171924E-01],
	[3.6710000000E+04, 2.9263032215E+01, 5.1832030899E+00, 1.2059470277E+01, 3.2255350550E+00, 9.5536193383E-01],
	[3.6715000000E+04, 2.9269872438E+01, 5.1832247506E+00, 1.2064816287E+01, 3.2260088825E+00, 9.5538213833E-01],
	[3.6720000000E+04, 2.9276713327E+01, 5.1832464085E+00, 1.2070163937E+01, 3.2264825957E+00, 9.5540233274E-01],
	[3.6725000000E+04, 2.9283554884E+01, 5.1832680635E+00, 1.2075513228E+01, 3.2269561946E+00, 9.5542251706E-01],
	[3.6730000000E+04, 2.9290397108E+01, 5.1832897156E+00, 1.2080864160E+01, 3.2274296793E+00, 9.5544269131E-01],
	[3.6735000000E+04, 2.9297239999E+01, 5.1833113649E+00, 1.2086216734E+01, 3.2279030496E+00, 9.5546285548E-01],
	[3.6740000000E+04, 2.9304083557E+01, 5.1833330113E+00, 1.2091570949E+01, 3.2283763057E+00, 9.5548300958E-01],
	[3.6745000000E+04, 2.9310927782E+01, 5.1833546549E+00, 1.2096926806E+01, 3.2288494476E+00, 9.5550315361E-01],
	[3.6750000000E+04, 2.9317772674E+01, 5.1833762956E+00, 1.2102284305E+01, 3.2293224752E+00, 9.5552328759E-01],
	[3.6755000000E+04, 2.9324618233E+01, 5.1833979335E+00, 1.2107643446E+01, 3.2297953886E+00, 9.5554341152E-01],
	[3.6760000000E+04, 2.9331464459E+01, 5.1834195685E+00, 1.2113004230E+01, 3.2302681878E+00, 9.5556352540E-01],
	[3.6765000000E+04, 2.9338311351E+01, 5.1834412007E+00, 1.2118366658E+01, 3.2307408728E+00, 9.5558362924E-01],
	[3.6770000000E+04, 2.9345158911E+01, 5.1834628300E+00, 1.2123730728E+01, 3.2312134436E+00, 9.5560372304E-01],
	[3.6775000000E+04, 2.9352007137E+01, 5.1834844564E+00, 1.2129096442E+01, 3.2316859003E+00, 9.5562380681E-01],
	[3.6780000000E+04, 2.9358856030E+01, 5.1835060800E+00, 1.2134463800E+01, 3.2321582428E+00, 9.5564388056E-01],
	[3.6785000000E+04, 2.9365705590E+01, 5.1835277008E+00, 1.2139832802E+01, 3.2326304711E+00, 9.5566394428E-01],
	[3.6790000000E+04, 2.9372555816E+01, 5.1835493187E+00, 1.2145203448E+01, 3.2331025853E+00, 9.5568399799E-01],
	[3.6795000000E+04, 2.9379406710E+01, 5.1835709337E+00, 1.2150575739E+01, 3.2335745854E+00, 9.5570404169E-01],
	[3.6800000000E+04, 2.9386258270E+01, 5.1835925460E+00, 1.2155949674E+01, 3.2340464714E+00, 9.5572407539E-01],
	[3.6805000000E+04, 2.9393110496E+01, 5.1836141553E+00, 1.2161325256E+01, 3.2345182433E+00, 9.5574409908E-01],
	[3.6810000000E+04, 2.9399968519E+01, 5.1836364479E+00, 1.2166702482E+01, 3.2349902304E+00, 9.5576411279E-01],
	[3.6815000000E+04, 2.9406840452E+01, 5.1836605080E+00, 1.2172081354E+01, 3.2354629536E+00, 9.5578411650E-01],
	[3.6820000000E+04, 2.9413713058E+01, 5.1836845649E+00, 1.2177461873E+01, 3.2359355632E+00, 9.5580411023E-01],
	[3.6825000000E+04, 2.9420586336E+01, 5.1837086188E+00, 1.2182844037E+01, 3.2364080592E+00, 9.5582409399E-01],
	[3.6830000000E+04, 2.9427460287E+01, 5.1837326694E+00, 1.2188227849E+01, 3.2368804415E+00, 9.5584406777E-01],
	[3.6835000000E+04, 2.9434334910E+01, 5.1837567169E+00, 1.2193613307E+01, 3.2373527102E+00, 9.5586403159E-01],
	[3.6840000000E+04, 2.9441210206E+01, 5.1837807613E+00, 1.2199000412E+01, 3.2378248654E+00, 9.5588398544E-01],
	[3.6845000000E+04, 2.9448086175E+01, 5.1838048025E+00, 1.2204389165E+01, 3.2382969069E+00, 9.5590392934E-01],
	[3.6850000000E+04, 2.9454962816E+01, 5.1838288405E+00, 1.2209779566E+01, 3.2387688350E+00, 9.5592386329E-01],
	[3.6855000000E+04, 2.9461840129E+01, 5.1838528754E+00, 1.2215171614E+01, 3.2392406494E+00, 9.5594378729E-01],
	[3.6860000000E+04, 2.9468718115E+01, 5.1838769072E+00, 1.2220565311E+01, 3.2397123503E+00, 9.5596370135E-01],
	[3.6865000000E+04, 2.9475596774E+01, 5.1839009358E+00, 1.2225960657E+01, 3.2401839377E+00, 9.5598360548E-01],
	[3.6870000000E+04, 2.9482476104E+01, 5.1839249613E+00, 1.2231357651E+01, 3.2406554116E+00, 9.5600349968E-01],
	[3.6875000000E+04, 2.9489356108E+01, 5.1839489836E+00, 1.2236756294E+01, 3.2411267720E+00, 9.5602338395E-01],
	[3.6880000000E+04, 2.9496236783E+01, 5.1839730027E+00, 1.2242156587E+01, 3.2415980189E+00, 9.5604325831E-01],
	[3.6885000000E+04, 2.9503118131E+01, 5.1839970187E+00, 1.2247558530E+01, 3.2420691523E+00, 9.5606312274E-01],
	[3.6890000000E+04, 2.9510000152E+01, 5.1840210316E+00, 1.2252962122E+01, 3.2425401722E+00, 9.5608297727E-01],
	[3.6895000000E+04, 2.9516882844E+01, 5.1840450414E+00, 1.2258367365E+01, 3.2430110788E+00, 9.5610282190E-01],
	[3.6900000000E+04, 2.9523766209E+01, 5.1840690479E+00, 1.2263774258E+01, 3.2434818718E+00, 9.5612265662E-01],
	[3.6905000000E+04, 2.9530650246E+01, 5.1840930514E+00, 1.2269182802E+01, 3.2439525515E+00, 9.5614248144E-01],
	[3.6910000000E+04, 2.9537534955E+01, 5.1841170517E+00, 1.2274592998E+01, 3.2444231177E+00, 9.5616229638E-01],
	[3.6915000000E+04, 2.9544420337E+01, 5.1841410489E+00, 1.2280004844E+01, 3.2448935706E+00, 9.5618210143E-01],
	[3.6920000000E+04, 2.9551306390E+01, 5.1841650429E+00, 1.2285418342E+01, 3.2453639100E+00, 9.5620189659E-01],
	[3.6925000000E+04, 2.9558193116E+01, 5.1841890338E+00, 1.2290833493E+01, 3.2458341361E+00, 9.5622168189E-01],
	[3.6930000000E+04, 2.9565080514E+01, 5.1842130215E+00, 1.2296250295E+01, 3.2463042489E+00, 9.5624145731E-01],
	[3.6935000000E+04, 2.9571968584E+01, 5.1842370062E+00, 1.2301668750E+01, 3.2467742482E+00, 9.5626122286E-01],
	[3.6940000000E+04, 2.9578857326E+01, 5.1842609876E+00, 1.2307088857E+01, 3.2472441343E+00, 9.5628097855E-01],
	[3.6945000000E+04, 2.9585746740E+01, 5.1842849660E+00, 1.2312510618E+01, 3.2477139070E+00, 9.5630072438E-01],
	[3.6950000000E+04, 2.9592636826E+01, 5.1843089412E+00, 1.2317934032E+01, 3.2481835665E+00, 9.5632046037E-01],
	[3.6955000000E+04, 2.9599527584E+01, 5.1843329133E+00, 1.2323359100E+01, 3.2486531126E+00, 9.5634018650E-01],
	[3.6960000000E+04, 2.9606419014E+01, 5.1843568822E+00, 1.2328785821E+01, 3.2491225455E+00, 9.5635990279E-01],
	[3.6965000000E+04, 2.9613311116E+01, 5.1843808480E+00, 1.2334214197E+01, 3.2495918651E+00, 9.5637960925E-01],
	[3.6970000000E+04, 2.9620203890E+01, 5.1844048107E+00, 1.2339644227E+01, 3.2500610714E+00, 9.5639930587E-01],
	[3.6975000000E+04, 2.9627097336E+01, 5.1844287703E+00, 1.2345075912E+01, 3.2505301645E+00, 9.5641899266E-01],
	[3.6980000000E+04, 2.9633991453E+01, 5.1844527267E+00, 1.2350509251E+01, 3.2509991444E+00, 9.5643866963E-01],
	[3.6985000000E+04, 2.9640886243E+01, 5.1844766800E+00, 1.2355944246E+01, 3.2514680110E+00, 9.5645833679E-01],
	[3.6990000000E+04, 2.9647781704E+01, 5.1845006302E+00, 1.2361380897E+01, 3.2519367645E+00, 9.5647799413E-01],
	[3.6995000000E+04, 2.9654677837E+01, 5.1845245772E+00, 1.2366819204E+01, 3.2524054048E+00, 9.5649764166E-01],
	[3.7000000000E+04, 2.9661574642E+01, 5.1845485211E+00, 1.2372259166E+01, 3.2528739319E+00, 9.5651727938E-01],
	[3.7005000000E+04, 2.9668472118E+01, 5.1845724619E+00, 1.2377700785E+01, 3.2533423458E+00, 9.5653690731E-01],
	[3.7010000000E+04, 2.9675370267E+01, 5.1845963996E+00, 1.2383144061E+01, 3.2538106466E+00, 9.5655652545E-01],
	[3.7015000000E+04, 2.9682269087E+01, 5.1846203341E+00, 1.2388588994E+01, 3.2542788342E+00, 9.5657613379E-01],
	[3.7020000000E+04, 2.9689168578E+01, 5.1846442656E+00, 1.2394035584E+01, 3.2547469088E+00, 9.5659573235E-01],
	[3.7025000000E+04, 2.9696068741E+01, 5.1846681939E+00, 1.2399483831E+01, 3.2552148702E+00, 9.5661532113E-01],
	[3.7030000000E+04, 2.9702969576E+01, 5.1846921190E+00, 1.2404933737E+01, 3.2556827185E+00, 9.5663490014E-01],
	[3.7035000000E+04, 2.9709871082E+01, 5.1847160411E+00, 1.2410385300E+01, 3.2561504538E+00, 9.5665446938E-01],
	[3.7040000000E+04, 2.9716773260E+01, 5.1847399600E+00, 1.2415838522E+01, 3.2566180759E+00, 9.5667402885E-01],
	[3.7045000000E+04, 2.9723676110E+01, 5.1847638759E+00, 1.2421293402E+01, 3.2570855851E+00, 9.5669357856E-01],
	[3.7050000000E+04, 2.9730579631E+01, 5.1847877886E+00, 1.2426749942E+01, 3.2575529811E+00, 9.5671311852E-01],
	[3.7055000000E+04, 2.9737483823E+01, 5.1848116982E+00, 1.2432208140E+01, 3.2580202642E+00, 9.5673264873E-01],
	[3.7060000000E+04, 2.9744388687E+01, 5.1848356046E+00, 1.2437667998E+01, 3.2584874342E+00, 9.5675216919E-01],
	[3.7065000000E+04, 2.9751294222E+01, 5.1848595080E+00, 1.2443129516E+01, 3.2589544913E+00, 9.5677167991E-01],
	[3.7070000000E+04, 2.9758200429E+01, 5.1848834082E+00, 1.2448592694E+01, 3.2594214353E+00, 9.5679118089E-01],
	[3.7075000000E+04, 2.9765107307E+01, 5.1849073054E+00, 1.2454057532E+01, 3.2598882664E+00, 9.5681067215E-01],
	[3.7080000000E+04, 2.9772014857E+01, 5.1849311994E+00, 1.2459524031E+01, 3.2603549845E+00, 9.5683015367E-01],
	[3.7085000000E+04, 2.9778923077E+01, 5.1849550903E+00, 1.2464992191E+01, 3.2608215897E+00, 9.5684962548E-01],
	[3.7090000000E+04, 2.9785831969E+01, 5.1849789781E+00, 1.2470462011E+01, 3.2612880819E+00, 9.5686908757E-01],
	[3.7095000000E+04, 2.9792741533E+01, 5.1850028628E+00, 1.2475933494E+01, 3.2617544613E+00, 9.5688853995E-01],
	[3.7100000000E+04, 2.9799651767E+01, 5.1850267444E+00, 1.2481406638E+01, 3.2622207277E+00, 9.5690798262E-01],
	[3.7105000000E+04, 2.9806562673E+01, 5.1850506228E+00, 1.2486881444E+01, 3.2626868812E+00, 9.5692741559E-01],
	[3.7110000000E+04, 2.9813474250E+01, 5.1850744982E+00, 1.2492357912E+01, 3.2631529218E+00, 9.5694683886E-01],
	[3.7115000000E+04, 2.9820386498E+01, 5.1850983704E+00, 1.2497836043E+01, 3.2636188496E+00, 9.5696625244E-01],
	[3.7120000000E+04, 2.9827299418E+01, 5.1851222396E+00, 1.2503315837E+01, 3.2640846645E+00, 9.5698565634E-01],
	[3.7125000000E+04, 2.9834213008E+01, 5.1851461056E+00, 1.2508797294E+01, 3.2645503666E+00, 9.5700505055E-01],
	[3.7130000000E+04, 2.9841127270E+01, 5.1851699686E+00, 1.2514280414E+01, 3.2650159559E+00, 9.5702443508E-01],
	[3.7135000000E+04, 2.9848042202E+01, 5.1851938284E+00, 1.2519765198E+01, 3.2654814323E+00, 9.5704380994E-01],
	[3.7140000000E+04, 2.9854957806E+01, 5.1852176851E+00, 1.2525251646E+01, 3.2659467960E+00, 9.5706317513E-01],
	[3.7145000000E+04, 2.9861874081E+01, 5.1852415388E+00, 1.2530739758E+01, 3.2664120469E+00, 9.5708253066E-01],
	[3.7150000000E+04, 2.9868791026E+01, 5.1852653893E+00, 1.2536229535E+01, 3.2668771850E+00, 9.5710187653E-01],
	[3.7155000000E+04, 2.9875708643E+01, 5.1852892367E+00, 1.2541720976E+01, 3.2673422103E+00, 9.5712121275E-01],
	[3.7160000000E+04, 2.9882626931E+01, 5.1853130811E+00, 1.2547214083E+01, 3.2678071229E+00, 9.5714053931E-01],
	[3.7165000000E+04, 2.9889545889E+01, 5.1853369223E+00, 1.2552708855E+01, 3.2682719228E+00, 9.5715985624E-01],
	[3.7170000000E+04, 2.9896465519E+01, 5.1853607604E+00, 1.2558205293E+01, 3.2687366099E+00, 9.5717916352E-01],
	[3.7175000000E+04, 2.9903385819E+01, 5.1853845955E+00, 1.2563703396E+01, 3.2692011844E+00, 9.5719846117E-01],
	[3.7180000000E+04, 2.9910306790E+01, 5.1854084274E+00, 1.2569203166E+01, 3.2696656462E+00, 9.5721774920E-01],
	[3.7185000000E+04, 2.9917228432E+01, 5.1854322563E+00, 1.2574704602E+01, 3.2701299953E+00, 9.5723702759E-01],
	[3.7190000000E+04, 2.9924150745E+01, 5.1854560820E+00, 1.2580207706E+01, 3.2705942317E+00, 9.5725629637E-01],
	[3.7195000000E+04, 2.9931073728E+01, 5.1854799047E+00, 1.2585712476E+01, 3.2710583555E+00, 9.5727555553E-01],
	[3.7200000000E+04, 2.9937997383E+01, 5.1855037242E+00, 1.2591218913E+01, 3.2715223666E+00, 9.5729480509E-01],
	[3.7205000000E+04, 2.9944921708E+01, 5.1855275407E+00, 1.2596727018E+01, 3.2719862652E+00, 9.5731404503E-01],
	[3.7210000000E+04, 2.9951846703E+01, 5.1855513541E+00, 1.2602236791E+01, 3.2724500511E+00, 9.5733327538E-01],
	[3.7215000000E+04, 2.9958772370E+01, 5.1855751644E+00, 1.2607748232E+01, 3.2729137245E+00, 9.5735249613E-01],
	[3.7220000000E+04, 2.9965698707E+01, 5.1855989716E+00, 1.2613261342E+01, 3.2733772853E+00, 9.5737170729E-01],
	[3.7225000000E+04, 2.9972625714E+01, 5.1856227757E+00, 1.2618776120E+01, 3.2738407335E+00, 9.5739090887E-01],
	[3.7230000000E+04, 2.9979553393E+01, 5.1856465767E+00, 1.2624292568E+01, 3.2743040691E+00, 9.5741010086E-01],
	[3.7235000000E+04, 2.9986481741E+01, 5.1856703747E+00, 1.2629810684E+01, 3.2747672923E+00, 9.5742928328E-01],
	[3.7240000000E+04, 2.9993410761E+01, 5.1856941695E+00, 1.2635330471E+01, 3.2752304029E+00, 9.5744845613E-01],
	[3.7245000000E+04, 3.0000340451E+01, 5.1857179613E+00, 1.2640851927E+01, 3.2756934010E+00, 9.5746761941E-01],
	[3.7250000000E+04, 3.0007270811E+01, 5.1857417500E+00, 1.2646375053E+01, 3.2761562866E+00, 9.5748677312E-01],
	[3.7255000000E+04, 3.0014201842E+01, 5.1857655356E+00, 1.2651899850E+01, 3.2766190597E+00, 9.5750591729E-01],
	[3.7260000000E+04, 3.0021133543E+01, 5.1857893181E+00, 1.2657426317E+01, 3.2770817204E+00, 9.5752505190E-01],
	[3.7265000000E+04, 3.0028065915E+01, 5.1858130975E+00, 1.2662954455E+01, 3.2775442686E+00, 9.5754417696E-01],
	[3.7270000000E+04, 3.0034998957E+01, 5.1858368739E+00, 1.2668484265E+01, 3.2780067044E+00, 9.5756329248E-01],
	[3.7275000000E+04, 3.0041932669E+01, 5.1858606472E+00, 1.2674015746E+01, 3.2784690278E+00, 9.5758239846E-01],
	[3.7280000000E+04, 3.0048867052E+01, 5.1858844174E+00, 1.2679548899E+01, 3.2789312387E+00, 9.5760149491E-01],
	[3.7285000000E+04, 3.0055802105E+01, 5.1859081845E+00, 1.2685083724E+01, 3.2793933373E+00, 9.5762058183E-01],
	[3.7290000000E+04, 3.0062737828E+01, 5.1859319485E+00, 1.2690620222E+01, 3.2798553235E+00, 9.5763965923E-01],
	[3.7295000000E+04, 3.0069674222E+01, 5.1859557095E+00, 1.2696158392E+01, 3.2803171973E+00, 9.5765872711E-01],
	[3.7300000000E+04, 3.0076611286E+01, 5.1859794673E+00, 1.2701698235E+01, 3.2807789588E+00, 9.5767778548E-01],
	[3.7305000000E+04, 3.0083549020E+01, 5.1860032222E+00, 1.2707239751E+01, 3.2812406079E+00, 9.5769683433E-01],
	[3.7310000000E+04, 3.0090487425E+01, 5.1860269739E+00, 1.2712782941E+01, 3.2817021447E+00, 9.5771587369E-01],
	[3.7315000000E+04, 3.0097426499E+01, 5.1860507225E+00, 1.2718327805E+01, 3.2821635692E+00, 9.5773490354E-01],
	[3.7320000000E+04, 3.0104366244E+01, 5.1860744681E+00, 1.2723874342E+01, 3.2826248814E+00, 9.5775392391E-01],
	[3.7325000000E+04, 3.0111306658E+01, 5.1860982106E+00, 1.2729422554E+01, 3.2830860814E+00, 9.5777293478E-01],
	[3.7330000000E+04, 3.0118247743E+01, 5.1861219501E+00, 1.2734972441E+01, 3.2835471690E+00, 9.5779193616E-01],
	[3.7335000000E+04, 3.0125189498E+01, 5.1861456864E+00, 1.2740524002E+01, 3.2840081444E+00, 9.5781092807E-01],
	[3.7340000000E+04, 3.0132131923E+01, 5.1861694197E+00, 1.2746077239E+01, 3.2844690076E+00, 9.5782991051E-01],
	[3.7345000000E+04, 3.0139075018E+01, 5.1861931500E+00, 1.2751632151E+01, 3.2849297586E+00, 9.5784888347E-01],
	[3.7350000000E+04, 3.0146018783E+01, 5.1862168771E+00, 1.2757188739E+01, 3.2853903973E+00, 9.5786784697E-01],
	[3.7355000000E+04, 3.0152963218E+01, 5.1862406012E+00, 1.2762747003E+01, 3.2858509239E+00, 9.5788680100E-01],
	[3.7360000000E+04, 3.0159908323E+01, 5.1862643223E+00, 1.2768306943E+01, 3.2863113383E+00, 9.5790574558E-01],
	[3.7365000000E+04, 3.0166854098E+01, 5.1862880402E+00, 1.2773868560E+01, 3.2867716405E+00, 9.5792468071E-01],
	[3.7370000000E+04, 3.0173800542E+01, 5.1863117551E+00, 1.2779431854E+01, 3.2872318305E+00, 9.5794360640E-01],
	[3.7375000000E+04, 3.0180747657E+01, 5.1863354669E+00, 1.2784996825E+01, 3.2876919085E+00, 9.5796252264E-01],
	[3.7380000000E+04, 3.0187695441E+01, 5.1863591757E+00, 1.2790563473E+01, 3.2881518743E+00, 9.5798142945E-01],
	[3.7385000000E+04, 3.0194643895E+01, 5.1863828814E+00, 1.2796131799E+01, 3.2886117280E+00, 9.5800032683E-01],
	[3.7390000000E+04, 3.0201593019E+01, 5.1864065841E+00, 1.2801701803E+01, 3.2890714696E+00, 9.5801921477E-01],
	[3.7395000000E+04, 3.0208542813E+01, 5.1864302837E+00, 1.2807273486E+01, 3.2895310991E+00, 9.5803809330E-01],
	[3.7400000000E+04, 3.0215493277E+01, 5.1864539802E+00, 1.2812846847E+01, 3.2899906166E+00, 9.5805696241E-01],
	[3.7405000000E+04, 3.0222458308E+01, 5.1864795134E+00, 1.2818421886E+01, 3.2904509273E+00, 9.5807582211E-01],
	[3.7410000000E+04, 3.0229428271E+01, 5.1865056067E+00, 1.2823998605E+01, 3.2909114035E+00, 9.5809467240E-01],
	[3.7415000000E+04, 3.0236398910E+01, 5.1865316966E+00, 1.2829577003E+01, 3.2913717681E+00, 9.5811351329E-01],
	[3.7420000000E+04, 3.0243370224E+01, 5.1865577832E+00, 1.2835157081E+01, 3.2918320210E+00, 9.5813234478E-01],
	[3.7425000000E+04, 3.0250342213E+01, 5.1865838664E+00, 1.2840738839E+01, 3.2922921624E+00, 9.5815116687E-01],
	[3.7430000000E+04, 3.0257314878E+01, 5.1866099463E+00, 1.2846322277E+01, 3.2927521922E+00, 9.5816997958E-01],
	[3.7435000000E+04, 3.0264288219E+01, 5.1866360228E+00, 1.2851907396E+01, 3.2932121104E+00, 9.5818878291E-01],
	[3.7440000000E+04, 3.0271262235E+01, 5.1866620960E+00, 1.2857494195E+01, 3.2936719171E+00, 9.5820757685E-01],
	[3.7445000000E+04, 3.0278236926E+01, 5.1866881658E+00, 1.2863082676E+01, 3.2941316122E+00, 9.5822636142E-01],
	[3.7450000000E+04, 3.0285212293E+01, 5.1867142323E+00, 1.2868672838E+01, 3.2945911958E+00, 9.5824513663E-01],
	[3.7455000000E+04, 3.0292188336E+01, 5.1867402954E+00, 1.2874264681E+01, 3.2950506679E+00, 9.5826390247E-01],
	[3.7460000000E+04, 3.0299165053E+01, 5.1867663551E+00, 1.2879858207E+01, 3.2955100285E+00, 9.5828265895E-01],
	[3.7465000000E+04, 3.0306142446E+01, 5.1867924116E+00, 1.2885453414E+01, 3.2959692776E+00, 9.5830140607E-01],
	[3.7470000000E+04, 3.0313120515E+01, 5.1868184646E+00, 1.2891050305E+01, 3.2964284153E+00, 9.5832014384E-01],
	[3.7475000000E+04, 3.0320099258E+01, 5.1868445144E+00, 1.2896648877E+01, 3.2968874415E+00, 9.5833887227E-01],
	[3.7480000000E+04, 3.0327078677E+01, 5.1868705607E+00, 1.2902249133E+01, 3.2973463563E+00, 9.5835759136E-01],
	[3.7485000000E+04, 3.0334058772E+01, 5.1868966038E+00, 1.2907851073E+01, 3.2978051596E+00, 9.5837630112E-01],
	[3.7490000000E+04, 3.0341039541E+01, 5.1869226435E+00, 1.2913454696E+01, 3.2982638516E+00, 9.5839500154E-01],
	[3.7495000000E+04, 3.0348020986E+01, 5.1869486798E+00, 1.2919060002E+01, 3.2987224321E+00, 9.5841369264E-01],
	[3.7500000000E+04, 3.0355003106E+01, 5.1869747129E+00, 1.2924666993E+01, 3.2991809013E+00, 9.5843237442E-01],
	[3.7505000000E+04, 3.0361985901E+01, 5.1870007425E+00, 1.2930275669E+01, 3.2996392591E+00, 9.5845104688E-01],
	[3.7510000000E+04, 3.0368969371E+01, 5.1870267689E+00, 1.2935886029E+01, 3.3000975055E+00, 9.5846971003E-01],
	[3.7515000000E+04, 3.0375953516E+01, 5.1870527919E+00, 1.2941498074E+01, 3.3005556407E+00, 9.5848836387E-01],
	[3.7520000000E+04, 3.0382938336E+01, 5.1870788115E+00, 1.2947111805E+01, 3.3010136645E+00, 9.5850700841E-01],
	[3.7525000000E+04, 3.0389923832E+01, 5.1871048278E+00, 1.2952727221E+01, 3.3014715770E+00, 9.5852564365E-01],
	[3.7530000000E+04, 3.0396910002E+01, 5.1871308408E+00, 1.2958344323E+01, 3.3019293782E+00, 9.5854426960E-01],
	[3.7535000000E+04, 3.0403896848E+01, 5.1871568505E+00, 1.2963963111E+01, 3.3023870681E+00, 9.5856288627E-01],
	[3.7540000000E+04, 3.0410884368E+01, 5.1871828568E+00, 1.2969583585E+01, 3.3028446468E+00, 9.5858149365E-01],
	[3.7545000000E+04, 3.0417872563E+01, 5.1872088598E+00, 1.2975205746E+01, 3.3033021142E+00, 9.5860009175E-01],
	[3.7550000000E+04, 3.0424861434E+01, 5.1872348594E+00, 1.2980829595E+01, 3.3037594704E+00, 9.5861868058E-01],
	[3.7555000000E+04, 3.0431850979E+01, 5.1872608558E+00, 1.2986455130E+01, 3.3042167154E+00, 9.5863726014E-01],
	[3.7560000000E+04, 3.0438841199E+01, 5.1872868487E+00, 1.2992082353E+01, 3.3046738491E+00, 9.5865583044E-01],
	[3.7565000000E+04, 3.0445832094E+01, 5.1873128384E+00, 1.2997711264E+01, 3.3051308717E+00, 9.5867439148E-01],
	[3.7570000000E+04, 3.0452823664E+01, 5.1873388247E+00, 1.3003341863E+01, 3.3055877831E+00, 9.5869294326E-01],
	[3.7575000000E+04, 3.0459815908E+01, 5.1873648077E+00, 1.3008974150E+01, 3.3060445834E+00, 9.5871148580E-01],
	[3.7580000000E+04, 3.0466808828E+01, 5.1873907874E+00, 1.3014608126E+01, 3.3065012725E+00, 9.5873001909E-01],
	[3.7585000000E+04, 3.0473802422E+01, 5.1874167638E+00, 1.3020243791E+01, 3.3069578505E+00, 9.5874854314E-01],
	[3.7590000000E+04, 3.0480796691E+01, 5.1874427368E+00, 1.3025881145E+01, 3.3074143174E+00, 9.5876705796E-01],
	[3.7595000000E+04, 3.0487791635E+01, 5.1874687065E+00, 1.3031520189E+01, 3.3078706732E+00, 9.5878556354E-01],
	[3.7600000000E+04, 3.0494787253E+01, 5.1874946729E+00, 1.3037160922E+01, 3.3083269179E+00, 9.5880405990E-01],
	[3.7605000000E+04, 3.0501783546E+01, 5.1875206359E+00, 1.3042803346E+01, 3.3087830515E+00, 9.5882254705E-01],
	[3.7610000000E+04, 3.0508780513E+01, 5.1875465957E+00, 1.3048447459E+01, 3.3092390741E+00, 9.5884102497E-01],
	[3.7615000000E+04, 3.0515778156E+01, 5.1875725521E+00, 1.3054093264E+01, 3.3096949856E+00, 9.5885949368E-01],
	[3.7620000000E+04, 3.0522776472E+01, 5.1875985052E+00, 1.3059740759E+01, 3.3101507861E+00, 9.5887795319E-01],
	[3.7625000000E+04, 3.0529775464E+01, 5.1876244549E+00, 1.3065389946E+01, 3.3106064756E+00, 9.5889640350E-01],
	[3.7630000000E+04, 3.0536775130E+01, 5.1876504014E+00, 1.3071040824E+01, 3.3110620541E+00, 9.5891484461E-01],
	[3.7635000000E+04, 3.0543775470E+01, 5.1876763445E+00, 1.3076693394E+01, 3.3115175217E+00, 9.5893327653E-01],
	[3.7640000000E+04, 3.0550776485E+01, 5.1877022843E+00, 1.3082347656E+01, 3.3119728782E+00, 9.5895169926E-01],
	[3.7645000000E+04, 3.0557778174E+01, 5.1877282208E+00, 1.3088003610E+01, 3.3124281239E+00, 9.5897011280E-01],
	[3.7650000000E+04, 3.0564780538E+01, 5.1877541540E+00, 1.3093661257E+01, 3.3128832586E+00, 9.5898851717E-01],
	[3.7655000000E+04, 3.0571783576E+01, 5.1877800839E+00, 1.3099320597E+01, 3.3133382823E+00, 9.5900691237E-01],
	[3.7660000000E+04, 3.0578787289E+01, 5.1878060105E+00, 1.3104981630E+01, 3.3137931952E+00, 9.5902529840E-01],
	[3.7665000000E+04, 3.0585791676E+01, 5.1878319337E+00, 1.3110644356E+01, 3.3142479972E+00, 9.5904367527E-01],
	[3.7670000000E+04, 3.0592796737E+01, 5.1878578536E+00, 1.3116308776E+01, 3.3147026883E+00, 9.5906204298E-01],
	[3.7675000000E+04, 3.0599802473E+01, 5.1878837703E+00, 1.3121974890E+01, 3.3151572686E+00, 9.5908040153E-01],
	[3.7680000000E+04, 3.0606808883E+01, 5.1879096836E+00, 1.3127642699E+01, 3.3156117380E+00, 9.5909875094E-01],
	[3.7685000000E+04, 3.0613815967E+01, 5.1879355936E+00, 1.3133312202E+01, 3.3160660966E+00, 9.5911709120E-01],
	[3.7690000000E+04, 3.0620823725E+01, 5.1879615003E+00, 1.3138983399E+01, 3.3165203443E+00, 9.5913542232E-01],
	[3.7695000000E+04, 3.0627832158E+01, 5.1879874037E+00, 1.3144656292E+01, 3.3169744813E+00, 9.5915374431E-01],
	[3.7700000000E+04, 3.0634841265E+01, 5.1880133038E+00, 1.3150330881E+01, 3.3174285075E+00, 9.5917205716E-01],
	[3.7705000000E+04, 3.0641851046E+01, 5.1880392005E+00, 1.3156007165E+01, 3.3178824230E+00, 9.5919036089E-01],
	[3.7710000000E+04, 3.0648861501E+01, 5.1880650940E+00, 1.3161685145E+01, 3.3183362276E+00, 9.5920865550E-01],
	[3.7715000000E+04, 3.0655872631E+01, 5.1880909842E+00, 1.3167364821E+01, 3.3187899216E+00, 9.5922694100E-01],
	[3.7720000000E+04, 3.0662884434E+01, 5.1881168711E+00, 1.3173046194E+01, 3.3192435048E+00, 9.5924521739E-01],
	[3.7725000000E+04, 3.0669896911E+01, 5.1881427546E+00, 1.3178729264E+01, 3.3196969773E+00, 9.5926348466E-01],
	[3.7730000000E+04, 3.0676910063E+01, 5.1881686349E+00, 1.3184414030E+01, 3.3201503392E+00, 9.5928174284E-01],
	[3.7735000000E+04, 3.0683923888E+01, 5.1881945118E+00, 1.3190100495E+01, 3.3206035903E+00, 9.5929999192E-01],
	[3.7740000000E+04, 3.0690938388E+01, 5.1882203855E+00, 1.3195788656E+01, 3.3210567308E+00, 9.5931823191E-01],
	[3.7745000000E+04, 3.0697953562E+01, 5.1882462559E+00, 1.3201478516E+01, 3.3215097607E+00, 9.5933646281E-01],
	[3.7750000000E+04, 3.0704969409E+01, 5.1882721229E+00, 1.3207170074E+01, 3.3219626799E+00, 9.5935468463E-01],
	[3.7755000000E+04, 3.0711985930E+01, 5.1882979867E+00, 1.3212863331E+01, 3.3224154885E+00, 9.5937289737E-01],
	[3.7760000000E+04, 3.0719003126E+01, 5.1883238472E+00, 1.3218558286E+01, 3.3228681865E+00, 9.5939110104E-01],
	[3.7765000000E+04, 3.0726020995E+01, 5.1883497044E+00, 1.3224254940E+01, 3.3233207739E+00, 9.5940929564E-01],
	[3.7770000000E+04, 3.0733039538E+01, 5.1883755583E+00, 1.3229953294E+01, 3.3237732508E+00, 9.5942748118E-01],
	[3.7775000000E+04, 3.0740058755E+01, 5.1884014089E+00, 1.3235653348E+01, 3.3242256171E+00, 9.5944565766E-01],
	[3.7780000000E+04, 3.0747078645E+01, 5.1884272561E+00, 1.3241355101E+01, 3.3246778729E+00, 9.5946382508E-01],
	[3.7785000000E+04, 3.0754099210E+01, 5.1884531002E+00, 1.3247058554E+01, 3.3251300181E+00, 9.5948198346E-01],
	[3.7790000000E+04, 3.0761120448E+01, 5.1884789409E+00, 1.3252763708E+01, 3.3255820529E+00, 9.5950013279E-01],
	[3.7795000000E+04, 3.0768142360E+01, 5.1885047783E+00, 1.3258470563E+01, 3.3260339772E+00, 9.5951827308E-01],
	[3.7800000000E+04, 3.0775164945E+01, 5.1885306124E+00, 1.3264179119E+01, 3.3264857909E+00, 9.5953640433E-01],
	[3.7805000000E+04, 3.0782188205E+01, 5.1885564433E+00, 1.3269889376E+01, 3.3269374943E+00, 9.5955452656E-01],
	[3.7810000000E+04, 3.0789212138E+01, 5.1885822708E+00, 1.3275601335E+01, 3.3273890872E+00, 9.5957263976E-01],
	[3.7815000000E+04, 3.0796236744E+01, 5.1886080951E+00, 1.3281314995E+01, 3.3278405696E+00, 9.5959074394E-01],
	[3.7820000000E+04, 3.0803262024E+01, 5.1886339161E+00, 1.3287030358E+01, 3.3282919417E+00, 9.5960883911E-01],
	[3.7825000000E+04, 3.0810287978E+01, 5.1886597338E+00, 1.3292747423E+01, 3.3287432033E+00, 9.5962692526E-01],
	[3.7830000000E+04, 3.0817314605E+01, 5.1886855482E+00, 1.3298466191E+01, 3.3291943546E+00, 9.5964500240E-01],
	[3.7835000000E+04, 3.0824341906E+01, 5.1887113594E+00, 1.3304186662E+01, 3.3296453955E+00, 9.5966307055E-01],
	[3.7840000000E+04, 3.0831369881E+01, 5.1887371672E+00, 1.3309908837E+01, 3.3300963260E+00, 9.5968112970E-01],
	[3.7845000000E+04, 3.0838398528E+01, 5.1887629718E+00, 1.3315632715E+01, 3.3305471463E+00, 9.5969917985E-01],
	[3.7850000000E+04, 3.0845427850E+01, 5.1887887731E+00, 1.3321358296E+01, 3.3309978562E+00, 9.5971722102E-01],
	[3.7855000000E+04, 3.0852457845E+01, 5.1888145711E+00, 1.3327085582E+01, 3.3314484557E+00, 9.5973525320E-01],
	[3.7860000000E+04, 3.0859488513E+01, 5.1888403658E+00, 1.3332814572E+01, 3.3318989451E+00, 9.5975327641E-01],
	[3.7865000000E+04, 3.0866519854E+01, 5.1888661573E+00, 1.3338545267E+01, 3.3323493241E+00, 9.5977129064E-01],
	[3.7870000000E+04, 3.0873551869E+01, 5.1888919455E+00, 1.3344277667E+01, 3.3327995929E+00, 9.5978929591E-01],
	[3.7875000000E+04, 3.0880584557E+01, 5.1889177304E+00, 1.3350011773E+01, 3.3332497514E+00, 9.5980729221E-01],
	[3.7880000000E+04, 3.0887617919E+01, 5.1889435120E+00, 1.3355747583E+01, 3.3336997997E+00, 9.5982527955E-01],
	[3.7885000000E+04, 3.0894651954E+01, 5.1889692903E+00, 1.3361485100E+01, 3.3341497378E+00, 9.5984325793E-01],
	[3.7890000000E+04, 3.0901686662E+01, 5.1889950654E+00, 1.3367224323E+01, 3.3345995658E+00, 9.5986122737E-01],
	[3.7895000000E+04, 3.0908722043E+01, 5.1890208372E+00, 1.3372965252E+01, 3.3350492835E+00, 9.5987918786E-01],
	[3.7900000000E+04, 3.0915758098E+01, 5.1890466058E+00, 1.3378707888E+01, 3.3354988911E+00, 9.5989713941E-01],
	[3.7905000000E+04, 3.0922794825E+01, 5.1890723710E+00, 1.3384452231E+01, 3.3359483885E+00, 9.5991508203E-01],
	[3.7910000000E+04, 3.0929832226E+01, 5.1890981330E+00, 1.3390198281E+01, 3.3363977758E+00, 9.5993301571E-01],
	[3.7915000000E+04, 3.0936870300E+01, 5.1891238917E+00, 1.3395946038E+01, 3.3368470530E+00, 9.5995094047E-01],
	[3.7920000000E+04, 3.0943909048E+01, 5.1891496472E+00, 1.3401695503E+01, 3.3372962201E+00, 9.5996885631E-01],
	[3.7925000000E+04, 3.0950948468E+01, 5.1891753994E+00, 1.3407446677E+01, 3.3377452771E+00, 9.5998676323E-01],
	[3.7930000000E+04, 3.0957988561E+01, 5.1892011483E+00, 1.3413199559E+01, 3.3381942240E+00, 9.6000466124E-01],
	[3.7935000000E+04, 3.0965029328E+01, 5.1892268939E+00, 1.3418954149E+01, 3.3386430609E+00, 9.6002255034E-01],
	[3.7940000000E+04, 3.0972070767E+01, 5.1892526363E+00, 1.3424710448E+01, 3.3390917878E+00, 9.6004043054E-01],
	[3.7945000000E+04, 3.0979112879E+01, 5.1892783754E+00, 1.3430468457E+01, 3.3395404046E+00, 9.6005830184E-01],
	[3.7950000000E+04, 3.0986155665E+01, 5.1893041113E+00, 1.3436228175E+01, 3.3399889114E+00, 9.6007616424E-01],
	[3.7955000000E+04, 3.0993199123E+01, 5.1893298439E+00, 1.3441989603E+01, 3.3404373083E+00, 9.6009401776E-01],
	[3.7960000000E+04, 3.1000243254E+01, 5.1893555732E+00, 1.3447752741E+01, 3.3408855951E+00, 9.6011186240E-01],
	[3.7965000000E+04, 3.1007288058E+01, 5.1893812993E+00, 1.3453517589E+01, 3.3413337721E+00, 9.6012969815E-01],
	[3.7970000000E+04, 3.1014333535E+01, 5.1894070221E+00, 1.3459284148E+01, 3.3417818390E+00, 9.6014752503E-01],
	[3.7975000000E+04, 3.1021379685E+01, 5.1894327416E+00, 1.3465052418E+01, 3.3422297961E+00, 9.6016534305E-01],
	[3.7980000000E+04, 3.1028426508E+01, 5.1894584579E+00, 1.3470822399E+01, 3.3426776432E+00, 9.6018315219E-01],
	[3.7985000000E+04, 3.1035474003E+01, 5.1894841710E+00, 1.3476594091E+01, 3.3431253805E+00, 9.6020095248E-01],
	[3.7990000000E+04, 3.1042522172E+01, 5.1895098807E+00, 1.3482367495E+01, 3.3435730079E+00, 9.6021874391E-01],
	[3.7995000000E+04, 3.1049571013E+01, 5.1895355873E+00, 1.3488142611E+01, 3.3440205254E+00, 9.6023652649E-01],
	[3.8000000000E+04, 3.1056620526E+01, 5.1895612905E+00, 1.3493919440E+01, 3.3444679330E+00, 9.6025430022E-01],
	[3.8005000000E+04, 3.1063676881E+01, 5.1895877992E+00, 1.3499697981E+01, 3.3449156384E+00, 9.6027206511E-01],
	[3.8010000000E+04, 3.1070745675E+01, 5.1896158467E+00, 1.3505478235E+01, 3.3453640112E+00, 9.6028982117E-01],
	[3.8015000000E+04, 3.1077815148E+01, 5.1896438907E+00, 1.3511260202E+01, 3.3458122747E+00, 9.6030756839E-01],
	[3.8020000000E+04, 3.1084885299E+01, 5.1896719312E+00, 1.3517043883E+01, 3.3462604287E+00, 9.6032530679E-01],
	[3.8025000000E+04, 3.1091956129E+01, 5.1896999681E+00, 1.3522829277E+01, 3.3467084734E+00, 9.6034303636E-01],
	[3.8030000000E+04, 3.1099027637E+01, 5.1897280015E+00, 1.3528616385E+01, 3.3471564087E+00, 9.6036075711E-01],
	[3.8035000000E+04, 3.1106099823E+01, 5.1897560314E+00, 1.3534405208E+01, 3.3476042346E+00, 9.6037846906E-01],
	[3.8040000000E+04, 3.1113172688E+01, 5.1897840577E+00, 1.3540195745E+01, 3.3480519512E+00, 9.6039617219E-01],
	[3.8045000000E+04, 3.1120246231E+01, 5.1898120805E+00, 1.3545987997E+01, 3.3484995585E+00, 9.6041386652E-01],
	[3.8050000000E+04, 3.1127320452E+01, 5.1898400998E+00, 1.3551781964E+01, 3.3489470564E+00, 9.6043155205E-01],
	[3.8055000000E+04, 3.1134395352E+01, 5.1898681155E+00, 1.3557577647E+01, 3.3493944451E+00, 9.6044922878E-01],
	[3.8060000000E+04, 3.1141470930E+01, 5.1898961277E+00, 1.3563375045E+01, 3.3498417244E+00, 9.6046689672E-01],
	[3.8065000000E+04, 3.1148547186E+01, 5.1899241364E+00, 1.3569174159E+01, 3.3502888945E+00, 9.6048455588E-01],
	[3.8070000000E+04, 3.1155624120E+01, 5.1899521415E+00, 1.3574974989E+01, 3.3507359554E+00, 9.6050220626E-01],
	[3.8075000000E+04, 3.1162701732E+01, 5.1899801431E+00, 1.3580777536E+01, 3.3511829070E+00, 9.6051984786E-01],
	[3.8080000000E+04, 3.1169780023E+01, 5.1900081412E+00, 1.3586581800E+01, 3.3516297495E+00, 9.6053748070E-01],
	[3.8085000000E+04, 3.1176858991E+01, 5.1900361358E+00, 1.3592387781E+01, 3.3520764827E+00, 9.6055510476E-01],
	[3.8090000000E+04, 3.1183938638E+01, 5.1900641268E+00, 1.3598195479E+01, 3.3525231067E+00, 9.6057272006E-01],
	[3.8095000000E+04, 3.1191018962E+01, 5.1900921144E+00, 1.3604004895E+01, 3.3529696216E+00, 9.6059032661E-01],
	[3.8100000000E+04, 3.1198099965E+01, 5.1901200984E+00, 1.3609816029E+01, 3.3534160273E+00, 9.6060792440E-01],
	[3.8105000000E+04, 3.1205181646E+01, 5.1901480788E+00, 1.3615628881E+01, 3.3538623239E+00, 9.6062551345E-01],
	[3.8110000000E+04, 3.1212264005E+01, 5.1901760558E+00, 1.3621443452E+01, 3.3543085114E+00, 9.6064309375E-01],
	[3.8115000000E+04, 3.1219347041E+01, 5.1902040292E+00, 1.3627259742E+01, 3.3547545898E+00, 9.6066066531E-01],
	[3.8120000000E+04, 3.1226430756E+01, 5.1902319992E+00, 1.3633077750E+01, 3.3552005590E+00, 9.6067822814E-01],
	[3.8125000000E+04, 3.1233515149E+01, 5.1902599656E+00, 1.3638897478E+01, 3.3556464193E+00, 9.6069578224E-01],
	[3.8130000000E+04, 3.1240600219E+01, 5.1902879284E+00, 1.3644718926E+01, 3.3560921704E+00, 9.6071332762E-01],
	[3.8135000000E+04, 3.1247685967E+01, 5.1903158878E+00, 1.3650542093E+01, 3.3565378125E+00, 9.6073086427E-01],
	[3.8140000000E+04, 3.1254772394E+01, 5.1903438437E+00, 1.3656366981E+01, 3.3569833457E+00, 9.6074839222E-01],
	[3.8145000000E+04, 3.1261859498E+01, 5.1903717960E+00, 1.3662193589E+01, 3.3574287697E+00, 9.6076591145E-01],
	[3.8150000000E+04, 3.1268947279E+01, 5.1903997448E+00, 1.3668021918E+01, 3.3578740849E+00, 9.6078342197E-01],
	[3.8155000000E+04, 3.1276035739E+01, 5.1904276901E+00, 1.3673851968E+01, 3.3583192910E+00, 9.6080092379E-01],
	[3.8160000000E+04, 3.1283124876E+01, 5.1904556319E+00, 1.3679683739E+01, 3.3587643882E+00, 9.6081841692E-01],
	[3.8165000000E+04, 3.1290214691E+01, 5.1904835702E+00, 1.3685517232E+01, 3.3592093764E+00, 9.6083590135E-01],
	[3.8170000000E+04, 3.1297305184E+01, 5.1905115050E+00, 1.3691352447E+01, 3.3596542557E+00, 9.6085337710E-01],
	[3.8175000000E+04, 3.1304396354E+01, 5.1905394363E+00, 1.3697189384E+01, 3.3600990261E+00, 9.6087084416E-01],
	[3.8180000000E+04, 3.1311488202E+01, 5.1905673640E+00, 1.3703028043E+01, 3.3605436877E+00, 9.6088830255E-01],
	[3.8185000000E+04, 3.1318580728E+01, 5.1905952883E+00, 1.3708868426E+01, 3.3609882403E+00, 9.6090575226E-01],
	[3.8190000000E+04, 3.1325673931E+01, 5.1906232091E+00, 1.3714710531E+01, 3.3614326841E+00, 9.6092319331E-01],
	[3.8195000000E+04, 3.1332767812E+01, 5.1906511263E+00, 1.3720554359E+01, 3.3618770190E+00, 9.6094062569E-01],
	[3.8200000000E+04, 3.1339862371E+01, 5.1906790400E+00, 1.3726399911E+01, 3.3623212451E+00, 9.6095804941E-01],
	[3.8205000000E+04, 3.1346957607E+01, 5.1907069503E+00, 1.3732247188E+01, 3.3627653625E+00, 9.6097546447E-01],
	[3.8210000000E+04, 3.1354053520E+01, 5.1907348570E+00, 1.3738096188E+01, 3.3632093710E+00, 9.6099287089E-01],
	[3.8215000000E+04, 3.1361150111E+01, 5.1907627603E+00, 1.3743946912E+01, 3.3636532707E+00, 9.6101026866E-01],
	[3.8220000000E+04, 3.1368247379E+01, 5.1907906600E+00, 1.3749799362E+01, 3.3640970617E+00, 9.6102765779E-01],
	[3.8225000000E+04, 3.1375345325E+01, 5.1908185562E+00, 1.3755653536E+01, 3.3645407439E+00, 9.6104503828E-01],
	[3.8230000000E+04, 3.1382443948E+01, 5.1908464490E+00, 1.3761509436E+01, 3.3649843174E+00, 9.6106241014E-01],
	[3.8235000000E+04, 3.1389543249E+01, 5.1908743382E+00, 1.3767367061E+01, 3.3654277822E+00, 9.6107977338E-01],
	[3.8240000000E+04, 3.1396643227E+01, 5.1909022239E+00, 1.3773226412E+01, 3.3658711383E+00, 9.6109712799E-01],
	[3.8245000000E+04, 3.1403743882E+01, 5.1909301062E+00, 1.3779087489E+01, 3.3663143857E+00, 9.6111447399E-01],
	[3.8250000000E+04, 3.1410845215E+01, 5.1909579849E+00, 1.3784950293E+01, 3.3667575245E+00, 9.6113181137E-01],
	[3.8255000000E+04, 3.1417947225E+01, 5.1909858602E+00, 1.3790814823E+01, 3.3672005546E+00, 9.6114914014E-01],
	[3.8260000000E+04, 3.1425049912E+01, 5.1910137320E+00, 1.3796681080E+01, 3.3676434761E+00, 9.6116646031E-01],
	[3.8265000000E+04, 3.1432153277E+01, 5.1910416002E+00, 1.3802549065E+01, 3.3680862890E+00, 9.6118377188E-01],
	[3.8270000000E+04, 3.1439257318E+01, 5.1910694650E+00, 1.3808418777E+01, 3.3685289932E+00, 9.6120107486E-01],
	[3.8275000000E+04, 3.1446362037E+01, 5.1910973263E+00, 1.3814290217E+01, 3.3689715889E+00, 9.6121836924E-01],
	[3.8280000000E+04, 3.1453467433E+01, 5.1911251841E+00, 1.3820163385E+01, 3.3694140761E+00, 9.6123565504E-01],
	[3.8285000000E+04, 3.1460573507E+01, 5.1911530384E+00, 1.3826038281E+01, 3.3698564546E+00, 9.6125293226E-01],
	[3.8290000000E+04, 3.1467680257E+01, 5.1911808892E+00, 1.3831914906E+01, 3.3702987247E+00, 9.6127020091E-01],
	[3.8295000000E+04, 3.1474787684E+01, 5.1912087366E+00, 1.3837793260E+01, 3.3707408862E+00, 9.6128746098E-01],
	[3.8300000000E+04, 3.1481895789E+01, 5.1912365804E+00, 1.3843673343E+01, 3.3711829393E+00, 9.6130471249E-01],
	[3.8305000000E+04, 3.1489004570E+01, 5.1912644208E+00, 1.3849555156E+01, 3.3716248838E+00, 9.6132195543E-01],
	[3.8310000000E+04, 3.1496114029E+01, 5.1912922576E+00, 1.3855438699E+01, 3.3720667199E+00, 9.6133918982E-01],
	[3.8315000000E+04, 3.1503224165E+01, 5.1913200910E+00, 1.3861323971E+01, 3.3725084476E+00, 9.6135641565E-01],
	[3.8320000000E+04, 3.1510334977E+01, 5.1913479210E+00, 1.3867210974E+01, 3.3729500668E+00, 9.6137363293E-01],
	[3.8325000000E+04, 3.1517446467E+01, 5.1913757474E+00, 1.3873099708E+01, 3.3733915776E+00, 9.6139084167E-01],
	[3.8330000000E+04, 3.1524558633E+01, 5.1914035703E+00, 1.3878990173E+01, 3.3738329800E+00, 9.6140804188E-01],
	[3.8335000000E+04, 3.1531671477E+01, 5.1914313898E+00, 1.3884882369E+01, 3.3742742741E+00, 9.6142523354E-01],
	[3.8340000000E+04, 3.1538784997E+01, 5.1914592058E+00, 1.3890776296E+01, 3.3747154597E+00, 9.6144241668E-01],
	[3.8345000000E+04, 3.1545899194E+01, 5.1914870183E+00, 1.3896671955E+01, 3.3751565371E+00, 9.6145959129E-01],
	[3.8350000000E+04, 3.1553014068E+01, 5.1915148273E+00, 1.3902569346E+01, 3.3755975061E+00, 9.6147675739E-01],
	[3.8355000000E+04, 3.1560129619E+01, 5.1915426329E+00, 1.3908468470E+01, 3.3760383667E+00, 9.6149391496E-01],
	[3.8360000000E+04, 3.1567245846E+01, 5.1915704350E+00, 1.3914369326E+01, 3.3764791191E+00, 9.6151106402E-01],
	[3.8365000000E+04, 3.1574362751E+01, 5.1915982336E+00, 1.3920271915E+01, 3.3769197632E+00, 9.6152820458E-01],
	[3.8370000000E+04, 3.1581480332E+01, 5.1916260287E+00, 1.3926176237E+01, 3.3773602990E+00, 9.6154533664E-01],
	[3.8375000000E+04, 3.1588598589E+01, 5.1916538204E+00, 1.3932082293E+01, 3.3778007266E+00, 9.6156246019E-01],
	[3.8380000000E+04, 3.1595717524E+01, 5.1916816086E+00, 1.3937990082E+01, 3.3782410460E+00, 9.6157957526E-01],
	[3.8385000000E+04, 3.1602837135E+01, 5.1917093933E+00, 1.3943899606E+01, 3.3786812571E+00, 9.6159668183E-01],
	[3.8390000000E+04, 3.1609957423E+01, 5.1917371745E+00, 1.3949810864E+01, 3.3791213601E+00, 9.6161377992E-01],
	[3.8395000000E+04, 3.1617078387E+01, 5.1917649523E+00, 1.3955723856E+01, 3.3795613549E+00, 9.6163086953E-01],
	[3.8400000000E+04, 3.1624200028E+01, 5.1917927266E+00, 1.3961638584E+01, 3.3800012415E+00, 9.6164795066E-01],
	[3.8405000000E+04, 3.1631322346E+01, 5.1918204974E+00, 1.3967555046E+01, 3.3804410199E+00, 9.6166502332E-01],
	[3.8410000000E+04, 3.1638445340E+01, 5.1918482648E+00, 1.3973473244E+01, 3.3808806903E+00, 9.6168208751E-01],
	[3.8415000000E+04, 3.1645569011E+01, 5.1918760287E+00, 1.3979393178E+01, 3.3813202525E+00, 9.6169914323E-01],
	[3.8420000000E+04, 3.1652693358E+01, 5.1919037892E+00, 1.3985314847E+01, 3.3817597066E+00, 9.6171619050E-01],
	[3.8425000000E+04, 3.1659818382E+01, 5.1919315461E+00, 1.3991238253E+01, 3.3821990526E+00, 9.6173322931E-01],
	[3.8430000000E+04, 3.1666944082E+01, 5.1919592997E+00, 1.3997163396E+01, 3.3826382906E+00, 9.6175025966E-01],
	[3.8435000000E+04, 3.1674070458E+01, 5.1919870497E+00, 1.4003090275E+01, 3.3830774206E+00, 9.6176728158E-01],
	[3.8440000000E+04, 3.1681197511E+01, 5.1920147963E+00, 1.4009018892E+01, 3.3835164425E+00, 9.6178429504E-01],
	[3.8445000000E+04, 3.1688325241E+01, 5.1920425394E+00, 1.4014949246E+01, 3.3839553564E+00, 9.6180130007E-01],
	[3.8450000000E+04, 3.1695453646E+01, 5.1920702791E+00, 1.4020881338E+01, 3.3843941623E+00, 9.6181829666E-01],
	[3.8455000000E+04, 3.1702582728E+01, 5.1920980153E+00, 1.4026815168E+01, 3.3848328602E+00, 9.6183528483E-01],
	[3.8460000000E+04, 3.1709712487E+01, 5.1921257481E+00, 1.4032750736E+01, 3.3852714502E+00, 9.6185226456E-01],
	[3.8465000000E+04, 3.1716842921E+01, 5.1921534774E+00, 1.4038688042E+01, 3.3857099322E+00, 9.6186923588E-01],
	[3.8470000000E+04, 3.1723974032E+01, 5.1921812032E+00, 1.4044627088E+01, 3.3861483063E+00, 9.6188619878E-01],
	[3.8475000000E+04, 3.1731105820E+01, 5.1922089256E+00, 1.4050567872E+01, 3.3865865725E+00, 9.6190315326E-01],
	[3.8480000000E+04, 3.1738238283E+01, 5.1922366445E+00, 1.4056510396E+01, 3.3870247308E+00, 9.6192009933E-01],
	[3.8485000000E+04, 3.1745371423E+01, 5.1922643600E+00, 1.4062454660E+01, 3.3874627812E+00, 9.6193703700E-01],
	[3.8490000000E+04, 3.1752505238E+01, 5.1922920720E+00, 1.4068400663E+01, 3.3879007237E+00, 9.6195396627E-01],
	[3.8495000000E+04, 3.1759639730E+01, 5.1923197806E+00, 1.4074348407E+01, 3.3883385585E+00, 9.6197088714E-01],
	[3.8500000000E+04, 3.1766774898E+01, 5.1923474857E+00, 1.4080297892E+01, 3.3887762853E+00, 9.6198779962E-01],
	[3.8505000000E+04, 3.1773910742E+01, 5.1923751874E+00, 1.4086249117E+01, 3.3892139044E+00, 9.6200470371E-01],
	[3.8510000000E+04, 3.1781047263E+01, 5.1924028856E+00, 1.4092202083E+01, 3.3896514157E+00, 9.6202159941E-01],
	[3.8515000000E+04, 3.1788184459E+01, 5.1924305804E+00, 1.4098156791E+01, 3.3900888193E+00, 9.6203848673E-01],
	[3.8520000000E+04, 3.1795322331E+01, 5.1924582717E+00, 1.4104113240E+01, 3.3905261150E+00, 9.6205536568E-01],
	[3.8525000000E+04, 3.1802460879E+01, 5.1924859596E+00, 1.4110071432E+01, 3.3909633030E+00, 9.6207223626E-01],
	[3.8530000000E+04, 3.1809600104E+01, 5.1925136440E+00, 1.4116031365E+01, 3.3914003833E+00, 9.6208909847E-01],
	[3.8535000000E+04, 3.1816740004E+01, 5.1925413250E+00, 1.4121993042E+01, 3.3918373560E+00, 9.6210595232E-01],
	[3.8540000000E+04, 3.1823880580E+01, 5.1925690026E+00, 1.4127956461E+01, 3.3922742209E+00, 9.6212279780E-01],
	[3.8545000000E+04, 3.1831021832E+01, 5.1925966767E+00, 1.4133921623E+01, 3.3927109781E+00, 9.6213963494E-01],
	[3.8550000000E+04, 3.1838163760E+01, 5.1926243473E+00, 1.4139888528E+01, 3.3931476277E+00, 9.6215646372E-01],
	[3.8555000000E+04, 3.1845306364E+01, 5.1926520146E+00, 1.4145857177E+01, 3.3935841696E+00, 9.6217328415E-01],
	[3.8560000000E+04, 3.1852449644E+01, 5.1926796783E+00, 1.4151827570E+01, 3.3940206040E+00, 9.6219009625E-01],
	[3.8565000000E+04, 3.1859593599E+01, 5.1927073387E+00, 1.4157799707E+01, 3.3944569307E+00, 9.6220690000E-01],
	[3.8570000000E+04, 3.1866738230E+01, 5.1927349956E+00, 1.4163773589E+01, 3.3948931499E+00, 9.6222369542E-01],
	[3.8575000000E+04, 3.1873883537E+01, 5.1927626490E+00, 1.4169749215E+01, 3.3953292614E+00, 9.6224048252E-01],
	[3.8580000000E+04, 3.1881029520E+01, 5.1927902991E+00, 1.4175726587E+01, 3.3957652655E+00, 9.6225726128E-01],
	[3.8585000000E+04, 3.1888176179E+01, 5.1928179457E+00, 1.4181705704E+01, 3.3962011620E+00, 9.6227403173E-01],
	[3.8590000000E+04, 3.1895323513E+01, 5.1928455888E+00, 1.4187686566E+01, 3.3966369509E+00, 9.6229079386E-01],
	[3.8595000000E+04, 3.1902471523E+01, 5.1928732285E+00, 1.4193669175E+01, 3.3970726324E+00, 9.6230754767E-01],
	[3.8600000000E+04, 3.1909620208E+01, 5.1929008648E+00, 1.4199653529E+01, 3.3975082064E+00, 9.6232429318E-01],
	[3.8605000000E+04, 3.1916769569E+01, 5.1929284977E+00, 1.4205639630E+01, 3.3979436729E+00, 9.6234103038E-01],
	[3.8610000000E+04, 3.1923919606E+01, 5.1929561271E+00, 1.4211627478E+01, 3.3983790320E+00, 9.6235775928E-01],
	[3.8615000000E+04, 3.1931070318E+01, 5.1929837531E+00, 1.4217617073E+01, 3.3988142837E+00, 9.6237447989E-01],
	[3.8620000000E+04, 3.1938239124E+01, 5.1930136381E+00, 1.4223608415E+01, 3.3992505946E+00, 9.6239119220E-01],
	[3.8625000000E+04, 3.1945408897E+01, 5.1930435568E+00, 1.4229601505E+01, 3.3996868178E+00, 9.6240789623E-01],
	[3.8630000000E+04, 3.1952579352E+01, 5.1930734718E+00, 1.4235596343E+01, 3.4001229340E+00, 9.6242459197E-01],
	[3.8635000000E+04, 3.1959750488E+01, 5.1931033830E+00, 1.4241592929E+01, 3.4005589431E+00, 9.6244127943E-01],
	[3.8640000000E+04, 3.1966922306E+01, 5.1931332906E+00, 1.4247591263E+01, 3.4009948453E+00, 9.6245795862E-01],
	[3.8645000000E+04, 3.1974094804E+01, 5.1931631945E+00, 1.4253591346E+01, 3.4014306404E+00, 9.6247462954E-01],
	[3.8650000000E+04, 3.1981267983E+01, 5.1931930947E+00, 1.4259593179E+01, 3.4018663287E+00, 9.6249129219E-01],
	[3.8655000000E+04, 3.1988441844E+01, 5.1932229912E+00, 1.4265596760E+01, 3.4023019099E+00, 9.6250794658E-01],
	[3.8660000000E+04, 3.1995616385E+01, 5.1932528839E+00, 1.4271602091E+01, 3.4027373843E+00, 9.6252459271E-01],
	[3.8665000000E+04, 3.2002791607E+01, 5.1932827730E+00, 1.4277609172E+01, 3.4031727518E+00, 9.6254123058E-01],
	[3.8670000000E+04, 3.2009967511E+01, 5.1933126584E+00, 1.4283618003E+01, 3.4036080123E+00, 9.6255786021E-01],
	[3.8675000000E+04, 3.2017144095E+01, 5.1933425402E+00, 1.4289628585E+01, 3.4040431660E+00, 9.6257448159E-01],
	[3.8680000000E+04, 3.2024321360E+01, 5.1933724182E+00, 1.4295640917E+01, 3.4044782129E+00, 9.6259109473E-01],
	[3.8685000000E+04, 3.2031499306E+01, 5.1934022925E+00, 1.4301655000E+01, 3.4049131529E+00, 9.6260769963E-01],
	[3.8690000000E+04, 3.2038677933E+01, 5.1934321631E+00, 1.4307670835E+01, 3.4053479861E+00, 9.6262429629E-01],
	[3.8695000000E+04, 3.2045857241E+01, 5.1934620301E+00, 1.4313688421E+01, 3.4057827125E+00, 9.6264088473E-01],
	[3.8700000000E+04, 3.2053037230E+01, 5.1934918934E+00, 1.4319707759E+01, 3.4062173321E+00, 9.6265746495E-01],
	[3.8705000000E+04, 3.2060217899E+01, 5.1935217529E+00, 1.4325728849E+01, 3.4066518449E+00, 9.6267403694E-01],
	[3.8710000000E+04, 3.2067399250E+01, 5.1935516088E+00, 1.4331751692E+01, 3.4070862510E+00, 9.6269060072E-01],
	[3.8715000000E+04, 3.2074581281E+01, 5.1935814610E+00, 1.4337776287E+01, 3.4075205504E+00, 9.6270715628E-01],
	[3.8720000000E+04, 3.2081763992E+01, 5.1936113096E+00, 1.4343802635E+01, 3.4079547430E+00, 9.6272370364E-01],
	[3.8725000000E+04, 3.2088947385E+01, 5.1936411544E+00, 1.4349830737E+01, 3.4083888290E+00, 9.6274024279E-01],
	[3.8730000000E+04, 3.2096131458E+01, 5.1936709956E+00, 1.4355860592E+01, 3.4088228083E+00, 9.6275677374E-01],
	[3.8735000000E+04, 3.2103316212E+01, 5.1937008331E+00, 1.4361892201E+01, 3.4092566809E+00, 9.6277329650E-01],
	[3.8740000000E+04, 3.2110501646E+01, 5.1937306669E+00, 1.4367925564E+01, 3.4096904468E+00, 9.6278981106E-01],
	[3.8745000000E+04, 3.2117687761E+01, 5.1937604970E+00, 1.4373960681E+01, 3.4101241062E+00, 9.6280631744E-01],
	[3.8750000000E+04, 3.2124874557E+01, 5.1937903234E+00, 1.4379997553E+01, 3.4105576589E+00, 9.6282281564E-01],
	[3.8755000000E+04, 3.2132062033E+01, 5.1938201462E+00, 1.4386036181E+01, 3.4109911050E+00, 9.6283930565E-01],
	[3.8760000000E+04, 3.2139250190E+01, 5.1938499653E+00, 1.4392076563E+01, 3.4114244446E+00, 9.6285578749E-01],
	[3.8765000000E+04, 3.2146439027E+01, 5.1938797807E+00, 1.4398118701E+01, 3.4118576776E+00, 9.6287226116E-01],
	[3.8770000000E+04, 3.2153628545E+01, 5.1939095924E+00, 1.4404162595E+01, 3.4122908041E+00, 9.6288872667E-01],
	[3.8775000000E+04, 3.2160818743E+01, 5.1939394005E+00, 1.4410208244E+01, 3.4127238240E+00, 9.6290518401E-01],
	[3.8780000000E+04, 3.2168009622E+01, 5.1939692049E+00, 1.4416255651E+01, 3.4131567374E+00, 9.6292163320E-01],
	[3.8785000000E+04, 3.2175201181E+01, 5.1939990056E+00, 1.4422304814E+01, 3.4135895444E+00, 9.6293807423E-01],
	[3.8790000000E+04, 3.2182393420E+01, 5.1940288027E+00, 1.4428355733E+01, 3.4140222449E+00, 9.6295450711E-01],
	[3.8795000000E+04, 3.2189586340E+01, 5.1940585961E+00, 1.4434408410E+01, 3.4144548389E+00, 9.6297093184E-01],
	[3.8800000000E+04, 3.2196779941E+01, 5.1940883858E+00, 1.4440462845E+01, 3.4148873265E+00, 9.6298734844E-01],
	[3.8805000000E+04, 3.2203974221E+01, 5.1941181718E+00, 1.4446519038E+01, 3.4153197076E+00, 9.6300375690E-01],
	[3.8810000000E+04, 3.2211169182E+01, 5.1941479542E+00, 1.4452576988E+01, 3.4157519824E+00, 9.6302015722E-01],
	[3.8815000000E+04, 3.2218364823E+01, 5.1941777329E+00, 1.4458636697E+01, 3.4161841508E+00, 9.6303654942E-01],
	[3.8820000000E+04, 3.2225561145E+01, 5.1942075080E+00, 1.4464698164E+01, 3.4166162128E+00, 9.6305293349E-01],
	[3.8825000000E+04, 3.2232758147E+01, 5.1942372793E+00, 1.4470761391E+01, 3.4170481684E+00, 9.6306930944E-01],
	[3.8830000000E+04, 3.2239955829E+01, 5.1942670471E+00, 1.4476826377E+01, 3.4174800178E+00, 9.6308567727E-01],
	[3.8835000000E+04, 3.2247154191E+01, 5.1942968111E+00, 1.4482893122E+01, 3.4179117608E+00, 9.6310203699E-01],
	[3.8840000000E+04, 3.2254353233E+01, 5.1943265715E+00, 1.4488961627E+01, 3.4183433975E+00, 9.6311838861E-01],
	[3.8845000000E+04, 3.2261552956E+01, 5.1943563283E+00, 1.4495031892E+01, 3.4187749280E+00, 9.6313473212E-01],
	[3.8850000000E+04, 3.2268753358E+01, 5.1943860813E+00, 1.4501103917E+01, 3.4192063522E+00, 9.6315106753E-01],
	[3.8855000000E+04, 3.2275954441E+01, 5.1944158308E+00, 1.4507177703E+01, 3.4196376701E+00, 9.6316739484E-01],
	[3.8860000000E+04, 3.2283156204E+01, 5.1944455765E+00, 1.4513253250E+01, 3.4200688818E+00, 9.6318371407E-01],
	[3.8865000000E+04, 3.2290358646E+01, 5.1944753186E+00, 1.4519330558E+01, 3.4204999874E+00, 9.6320002521E-01],
	[3.8870000000E+04, 3.2297561769E+01, 5.1945050571E+00, 1.4525409628E+01, 3.4209309867E+00, 9.6321632826E-01],
	[3.8875000000E+04, 3.2304765572E+01, 5.1945347919E+00, 1.4531490460E+01, 3.4213618798E+00, 9.6323262323E-01],
	[3.8880000000E+04, 3.2311970055E+01, 5.1945645230E+00, 1.4537573053E+01, 3.4217926668E+00, 9.6324891014E-01],
	[3.8885000000E+04, 3.2319175218E+01, 5.1945942505E+00, 1.4543657409E+01, 3.4222233477E+00, 9.6326518897E-01],
	[3.8890000000E+04, 3.2326381061E+01, 5.1946239743E+00, 1.4549743527E+01, 3.4226539224E+00, 9.6328145973E-01],
	[3.8895000000E+04, 3.2333587583E+01, 5.1946536945E+00, 1.4555831409E+01, 3.4230843911E+00, 9.6329772243E-01],
	[3.8900000000E+04, 3.2340794786E+01, 5.1946834111E+00, 1.4561921053E+01, 3.4235147536E+00, 9.6331397707E-01],
	[3.8905000000E+04, 3.2348002668E+01, 5.1947131239E+00, 1.4568012461E+01, 3.4239450101E+00, 9.6333022366E-01],
	[3.8910000000E+04, 3.2355211231E+01, 5.1947428332E+00, 1.4574105633E+01, 3.4243751605E+00, 9.6334646220E-01],
	[3.8915000000E+04, 3.2362420473E+01, 5.1947725388E+00, 1.4580200569E+01, 3.4248052049E+00, 9.6336269270E-01],
	[3.8920000000E+04, 3.2369630395E+01, 5.1948022407E+00, 1.4586297269E+01, 3.4252351433E+00, 9.6337891515E-01],
	[3.8925000000E+04, 3.2376840996E+01, 5.1948319390E+00, 1.4592395734E+01, 3.4256649757E+00, 9.6339512957E-01],
	[3.8930000000E+04, 3.2384052278E+01, 5.1948616337E+00, 1.4598495963E+01, 3.4260947021E+00, 9.6341133595E-01],
	[3.8935000000E+04, 3.2391264239E+01, 5.1948913247E+00, 1.4604597958E+01, 3.4265243226E+00, 9.6342753430E-01],
	[3.8940000000E+04, 3.2398476880E+01, 5.1949210120E+00, 1.4610701719E+01, 3.4269538371E+00, 9.6344372463E-01],
	[3.8945000000E+04, 3.2405690200E+01, 5.1949506957E+00, 1.4616807245E+01, 3.4273832457E+00, 9.6345990694E-01],
	[3.8950000000E+04, 3.2412904200E+01, 5.1949803758E+00, 1.4622914537E+01, 3.4278125484E+00, 9.6347608123E-01],
	[3.8955000000E+04, 3.2420118880E+01, 5.1950100523E+00, 1.4629023595E+01, 3.4282417452E+00, 9.6349224751E-01],
	[3.8960000000E+04, 3.2427334240E+01, 5.1950397251E+00, 1.4635134420E+01, 3.4286708361E+00, 9.6350840579E-01],
	[3.8965000000E+04, 3.2434550279E+01, 5.1950693942E+00, 1.4641247012E+01, 3.4290998212E+00, 9.6352455605E-01],
	[3.8970000000E+04, 3.2441766997E+01, 5.1950990598E+00, 1.4647361371E+01, 3.4295287004E+00, 9.6354069832E-01],
	[3.8975000000E+04, 3.2448984396E+01, 5.1951287216E+00, 1.4653477497E+01, 3.4299574738E+00, 9.6355683259E-01],
	[3.8980000000E+04, 3.2456202473E+01, 5.1951583799E+00, 1.4659595391E+01, 3.4303861415E+00, 9.6357295887E-01],
	[3.8985000000E+04, 3.2463421231E+01, 5.1951880345E+00, 1.4665715053E+01, 3.4308147033E+00, 9.6358907717E-01],
	[3.8990000000E+04, 3.2470640667E+01, 5.1952176855E+00, 1.4671836484E+01, 3.4312431594E+00, 9.6360518748E-01],
	[3.8995000000E+04, 3.2477860783E+01, 5.1952473329E+00, 1.4677959683E+01, 3.4316715097E+00, 9.6362128981E-01],
	[3.9000000000E+04, 3.2485081579E+01, 5.1952769766E+00, 1.4684084651E+01, 3.4320997543E+00, 9.6363738416E-01],
	[3.9005000000E+04, 3.2492303054E+01, 5.1953066167E+00, 1.4690211388E+01, 3.4325278932E+00, 9.6365347055E-01],
	[3.9010000000E+04, 3.2499525208E+01, 5.1953362531E+00, 1.4696339894E+01, 3.4329559264E+00, 9.6366954896E-01],
	[3.9015000000E+04, 3.2506748042E+01, 5.1953658859E+00, 1.4702470170E+01, 3.4333838539E+00, 9.6368561942E-01],
	[3.9020000000E+04, 3.2513971555E+01, 5.1953955151E+00, 1.4708602216E+01, 3.4338116758E+00, 9.6370168192E-01],
	[3.9025000000E+04, 3.2521195747E+01, 5.1954251407E+00, 1.4714736033E+01, 3.4342393920E+00, 9.6371773646E-01],
	[3.9030000000E+04, 3.2528420619E+01, 5.1954547627E+00, 1.4720871620E+01, 3.4346670026E+00, 9.6373378305E-01],
	[3.9035000000E+04, 3.2535646170E+01, 5.1954843810E+00, 1.4727008978E+01, 3.4350945076E+00, 9.6374982170E-01],
	[3.9040000000E+04, 3.2542872400E+01, 5.1955139957E+00, 1.4733148107E+01, 3.4355219070E+00, 9.6376585240E-01],
	[3.9045000000E+04, 3.2550099309E+01, 5.1955436068E+00, 1.4739289007E+01, 3.4359492008E+00, 9.6378187517E-01],
	[3.9050000000E+04, 3.2557326898E+01, 5.1955732142E+00, 1.4745431679E+01, 3.4363763891E+00, 9.6379789000E-01],
	[3.9055000000E+04, 3.2564555166E+01, 5.1956028180E+00, 1.4751576123E+01, 3.4368034719E+00, 9.6381389690E-01],
	[3.9060000000E+04, 3.2571784112E+01, 5.1956324182E+00, 1.4757722340E+01, 3.4372304492E+00, 9.6382989588E-01],
	[3.9065000000E+04, 3.2579013738E+01, 5.1956620148E+00, 1.4763870328E+01, 3.4376573209E+00, 9.6384588694E-01],
	[3.9070000000E+04, 3.2586244044E+01, 5.1956916078E+00, 1.4770020090E+01, 3.4380840872E+00, 9.6386187008E-01],
	[3.9075000000E+04, 3.2593475028E+01, 5.1957211971E+00, 1.4776171625E+01, 3.4385107480E+00, 9.6387784530E-01],
	[3.9080000000E+04, 3.2600706691E+01, 5.1957507829E+00, 1.4782324933E+01, 3.4389373034E+00, 9.6389381262E-01],
	[3.9085000000E+04, 3.2607939033E+01, 5.1957803650E+00, 1.4788480015E+01, 3.4393637534E+00, 9.6390977203E-01],
	[3.9090000000E+04, 3.2615172055E+01, 5.1958099435E+00, 1.4794636871E+01, 3.4397900979E+00, 9.6392572354E-01],
	[3.9095000000E+04, 3.2622405755E+01, 5.1958395184E+00, 1.4800795501E+01, 3.4402163371E+00, 9.6394166716E-01],
	[3.9100000000E+04, 3.2629640134E+01, 5.1958690896E+00, 1.4806955906E+01, 3.4406424709E+00, 9.6395760288E-01],
	[3.9105000000E+04, 3.2636875192E+01, 5.1958986573E+00, 1.4813118085E+01, 3.4410684993E+00, 9.6397353072E-01],
	[3.9110000000E+04, 3.2644110930E+01, 5.1959282213E+00, 1.4819282040E+01, 3.4414944224E+00, 9.6398945067E-01],
	[3.9115000000E+04, 3.2651347346E+01, 5.1959577818E+00, 1.4825447770E+01, 3.4419202402E+00, 9.6400536274E-01],
	[3.9120000000E+04, 3.2658584440E+01, 5.1959873386E+00, 1.4831615275E+01, 3.4423459527E+00, 9.6402126693E-01],
	[3.9125000000E+04, 3.2665822214E+01, 5.1960168918E+00, 1.4837784557E+01, 3.4427715599E+00, 9.6403716326E-01],
	[3.9130000000E+04, 3.2673060667E+01, 5.1960464414E+00, 1.4843955615E+01, 3.4431970619E+00, 9.6405305171E-01],
	[3.9135000000E+04, 3.2680299798E+01, 5.1960759874E+00, 1.4850128449E+01, 3.4436224586E+00, 9.6406893230E-01],
	[3.9140000000E+04, 3.2687539608E+01, 5.1961055298E+00, 1.4856303060E+01, 3.4440477501E+00, 9.6408480504E-01],
	[3.9145000000E+04, 3.2694780097E+01, 5.1961350686E+00, 1.4862479449E+01, 3.4444729364E+00, 9.6410066991E-01],
	[3.9150000000E+04, 3.2702021265E+01, 5.1961646038E+00, 1.4868657614E+01, 3.4448980175E+00, 9.6411652694E-01],
	[3.9155000000E+04, 3.2709263111E+01, 5.1961941353E+00, 1.4874837558E+01, 3.4453229934E+00, 9.6413237612E-01],
	[3.9160000000E+04, 3.2716505636E+01, 5.1962236633E+00, 1.4881019279E+01, 3.4457478642E+00, 9.6414821745E-01],
	[3.9165000000E+04, 3.2723748840E+01, 5.1962531877E+00, 1.4887202778E+01, 3.4461726299E+00, 9.6416405095E-01],
	[3.9170000000E+04, 3.2730992722E+01, 5.1962827085E+00, 1.4893388056E+01, 3.4465972904E+00, 9.6417987661E-01],
	[3.9175000000E+04, 3.2738237283E+01, 5.1963122256E+00, 1.4899575113E+01, 3.4470218458E+00, 9.6419569444E-01],
	[3.9180000000E+04, 3.2745482523E+01, 5.1963417392E+00, 1.4905763949E+01, 3.4474462962E+00, 9.6421150445E-01],
	[3.9185000000E+04, 3.2752728441E+01, 5.1963712492E+00, 1.4911954564E+01, 3.4478706415E+00, 9.6422730663E-01],
	[3.9190000000E+04, 3.2759975038E+01, 5.1964007555E+00, 1.4918146959E+01, 3.4482948817E+00, 9.6424310100E-01],
	[3.9195000000E+04, 3.2767222313E+01, 5.1964302583E+00, 1.4924341134E+01, 3.4487190170E+00, 9.6425888755E-01],
	[3.9200000000E+04, 3.2774470267E+01, 5.1964597575E+00, 1.4930537089E+01, 3.4491430472E+00, 9.6427466629E-01],
	[3.9205000000E+04, 3.2781718899E+01, 5.1964892531E+00, 1.4936734824E+01, 3.4495669724E+00, 9.6429043722E-01],
	[3.9210000000E+04, 3.2788968210E+01, 5.1965187451E+00, 1.4942934340E+01, 3.4499907927E+00, 9.6430620035E-01],
	[3.9215000000E+04, 3.2796218199E+01, 5.1965482335E+00, 1.4949135638E+01, 3.4504145080E+00, 9.6432195569E-01],
	[3.9220000000E+04, 3.2803468866E+01, 5.1965777183E+00, 1.4955338716E+01, 3.4508381184E+00, 9.6433770323E-01],
	[3.9225000000E+04, 3.2810720212E+01, 5.1966071995E+00, 1.4961543577E+01, 3.4512616238E+00, 9.6435344298E-01],
	[3.9230000000E+04, 3.2817972236E+01, 5.1966366771E+00, 1.4967750219E+01, 3.4516850244E+00, 9.6436917494E-01],
	[3.9235000000E+04, 3.2825224939E+01, 5.1966661512E+00, 1.4973958643E+01, 3.4521083201E+00, 9.6438489913E-01],
	[3.9240000000E+04, 3.2832489739E+01, 5.1966970924E+00, 1.4980168850E+01, 3.4525322864E+00, 9.6440061553E-01],
	[3.9245000000E+04, 3.2839761272E+01, 5.1967288090E+00, 1.4986380840E+01, 3.4529565589E+00, 9.6441632417E-01],
	[3.9250000000E+04, 3.2847033488E+01, 5.1967605217E+00, 1.4992594613E+01, 3.4533807269E+00, 9.6443202503E-01],
	[3.9255000000E+04, 3.2854306388E+01, 5.1967922305E+00, 1.4998810169E+01, 3.4538047905E+00, 9.6444771813E-01],
	[3.9260000000E+04, 3.2861579972E+01, 5.1968239356E+00, 1.5005027509E+01, 3.4542287496E+00, 9.6446340347E-01],
	[3.9265000000E+04, 3.2868854240E+01, 5.1968556367E+00, 1.5011246632E+01, 3.4546526043E+00, 9.6447908105E-01],
	[3.9270000000E+04, 3.2876129191E+01, 5.1968873341E+00, 1.5017467540E+01, 3.4550763545E+00, 9.6449475088E-01],
	[3.9275000000E+04, 3.2883404826E+01, 5.1969190275E+00, 1.5023690232E+01, 3.4555000004E+00, 9.6451041296E-01],
	[3.9280000000E+04, 3.2890681144E+01, 5.1969507172E+00, 1.5029914709E+01, 3.4559235419E+00, 9.6452606729E-01],
	[3.9285000000E+04, 3.2897958147E+01, 5.1969824030E+00, 1.5036140971E+01, 3.4563469790E+00, 9.6454171389E-01],
	[3.9290000000E+04, 3.2905235832E+01, 5.1970140850E+00, 1.5042369019E+01, 3.4567703117E+00, 9.6455735275E-01],
	[3.9295000000E+04, 3.2912514202E+01, 5.1970457631E+00, 1.5048598852E+01, 3.4571935402E+00, 9.6457298387E-01],
	[3.9300000000E+04, 3.2919793255E+01, 5.1970774374E+00, 1.5054830471E+01, 3.4576166643E+00, 9.6458860727E-01],
	[3.9305000000E+04, 3.2927072991E+01, 5.1971091078E+00, 1.5061063876E+01, 3.4580396842E+00, 9.6460422295E-01],
	[3.9310000000E+04, 3.2934353411E+01, 5.1971407745E+00, 1.5067299067E+01, 3.4584625997E+00, 9.6461983090E-01],
	[3.9315000000E+04, 3.2941634514E+01, 5.1971724372E+00, 1.5073536046E+01, 3.4588854111E+00, 9.6463543114E-01],
	[3.9320000000E+04, 3.2948916301E+01, 5.1972040962E+00, 1.5079774811E+01, 3.4593081182E+00, 9.6465102366E-01],
	[3.9325000000E+04, 3.2956198771E+01, 5.1972357513E+00, 1.5086015364E+01, 3.4597307210E+00, 9.6466660848E-01],
	[3.9330000000E+04, 3.2963481925E+01, 5.1972674026E+00, 1.5092257704E+01, 3.4601532197E+00, 9.6468218560E-01],
	[3.9335000000E+04, 3.2970765762E+01, 5.1972990500E+00, 1.5098501832E+01, 3.4605756142E+00, 9.6469775501E-01],
	[3.9340000000E+04, 3.2978050282E+01, 5.1973306937E+00, 1.5104747748E+01, 3.4609979045E+00, 9.6471331673E-01],
	[3.9345000000E+04, 3.2985335486E+01, 5.1973623335E+00, 1.5110995453E+01, 3.4614200907E+00, 9.6472887076E-01],
	[3.9350000000E+04, 3.2992621373E+01, 5.1973939694E+00, 1.5117244947E+01, 3.4618421728E+00, 9.6474441710E-01],
	[3.9355000000E+04, 3.2999907944E+01, 5.1974256016E+00, 1.5123496229E+01, 3.4622641508E+00, 9.6475995575E-01],
	[3.9360000000E+04, 3.3007195197E+01, 5.1974572299E+00, 1.5129749301E+01, 3.4626860246E+00, 9.6477548673E-01],
	[3.9365000000E+04, 3.3014483134E+01, 5.1974888544E+00, 1.5136004162E+01, 3.4631077944E+00, 9.6479101003E-01],
	[3.9370000000E+04, 3.3021771754E+01, 5.1975204750E+00, 1.5142260814E+01, 3.4635294602E+00, 9.6480652566E-01],
	[3.9375000000E+04, 3.3029061058E+01, 5.1975520919E+00, 1.5148519255E+01, 3.4639510219E+00, 9.6482203363E-01],
	[3.9380000000E+04, 3.3036351044E+01, 5.1975837049E+00, 1.5154779487E+01, 3.4643724796E+00, 9.6483753393E-01],
	[3.9385000000E+04, 3.3043641714E+01, 5.1976153141E+00, 1.5161041510E+01, 3.4647938333E+00, 9.6485302657E-01],
	[3.9390000000E+04, 3.3050933067E+01, 5.1976469195E+00, 1.5167305323E+01, 3.4652150831E+00, 9.6486851156E-01],
	[3.9395000000E+04, 3.3058225103E+01, 5.1976785210E+00, 1.5173570928E+01, 3.4656362288E+00, 9.6488398889E-01],
	[3.9400000000E+04, 3.3065517822E+01, 5.1977101188E+00, 1.5179838325E+01, 3.4660572707E+00, 9.6489945858E-01],
	[3.9405000000E+04, 3.3072811224E+01, 5.1977417127E+00, 1.5186107513E+01, 3.4664782086E+00, 9.6491492063E-01],
	[3.9410000000E+04, 3.3080105309E+01, 5.1977733028E+00, 1.5192378494E+01, 3.4668990426E+00, 9.6493037504E-01],
	[3.9415000000E+04, 3.3087400077E+01, 5.1978048891E+00, 1.5198651267E+01, 3.4673197727E+00, 9.6494582181E-01],
	[3.9420000000E+04, 3.3094695528E+01, 5.1978364716E+00, 1.5204925832E+01, 3.4677403990E+00, 9.6496126095E-01],
	[3.9425000000E+04, 3.3101991663E+01, 5.1978680502E+00, 1.5211202191E+01, 3.4681609214E+00, 9.6497669247E-01],
	[3.9430000000E+04, 3.3109288480E+01, 5.1978996251E+00, 1.5217480343E+01, 3.4685813399E+00, 9.6499211637E-01],
	[3.9435000000E+04, 3.3116585980E+01, 5.1979311961E+00, 1.5223760289E+01, 3.4690016547E+00, 9.6500753264E-01],
	[3.9440000000E+04, 3.3123884163E+01, 5.1979627633E+00, 1.5230042028E+01, 3.4694218657E+00, 9.6502294130E-01],
	[3.9445000000E+04, 3.3131183029E+01, 5.1979943268E+00, 1.5236325562E+01, 3.4698419729E+00, 9.6503834235E-01],
	[3.9450000000E+04, 3.3138482577E+01, 5.1980258864E+00, 1.5242610889E+01, 3.4702619763E+00, 9.6505373580E-01],
	[3.9455000000E+04, 3.3145782809E+01, 5.1980574422E+00, 1.5248898012E+01, 3.4706818760E+00, 9.6506912164E-01],
	[3.9460000000E+04, 3.3153083723E+01, 5.1980889942E+00, 1.5255186930E+01, 3.4711016720E+00, 9.6508449989E-01],
	[3.9465000000E+04, 3.3160385321E+01, 5.1981205423E+00, 1.5261477643E+01, 3.4715213643E+00, 9.6509987054E-01],
	[3.9470000000E+04, 3.3167687601E+01, 5.1981520867E+00, 1.5267770151E+01, 3.4719409528E+00, 9.6511523360E-01],
	[3.9475000000E+04, 3.3174990563E+01, 5.1981836273E+00, 1.5274064456E+01, 3.4723604378E+00, 9.6513058907E-01],
	[3.9480000000E+04, 3.3182294209E+01, 5.1982151641E+00, 1.5280360556E+01, 3.4727798191E+00, 9.6514593696E-01],
	[3.9485000000E+04, 3.3189598537E+01, 5.1982466970E+00, 1.5286658453E+01, 3.4731990967E+00, 9.6516127728E-01],
	[3.9490000000E+04, 3.3196903548E+01, 5.1982782262E+00, 1.5292958147E+01, 3.4736182708E+00, 9.6517661002E-01],
	[3.9495000000E+04, 3.3204209241E+01, 5.1983097516E+00, 1.5299259637E+01, 3.4740373412E+00, 9.6519193519E-01],
	[3.9500000000E+04, 3.3211515617E+01, 5.1983412731E+00, 1.5305562925E+01, 3.4744563081E+00, 9.6520725280E-01],
	[3.9505000000E+04, 3.3218822676E+01, 5.1983727909E+00, 1.5311868011E+01, 3.4748751715E+00, 9.6522256284E-01],
	[3.9510000000E+04, 3.3226130418E+01, 5.1984043049E+00, 1.5318174894E+01, 3.4752939313E+00, 9.6523786533E-01],
	[3.9515000000E+04, 3.3233438842E+01, 5.1984358151E+00, 1.5324483575E+01, 3.4757125876E+00, 9.6525316026E-01],
	[3.9520000000E+04, 3.3240747948E+01, 5.1984673214E+00, 1.5330794055E+01, 3.4761311404E+00, 9.6526844764E-01],
	[3.9525000000E+04, 3.3248057737E+01, 5.1984988240E+00, 1.5337106334E+01, 3.4765495897E+00, 9.6528372748E-01],
	[3.9530000000E+04, 3.3255368209E+01, 5.1985303228E+00, 1.5343420411E+01, 3.4769679355E+00, 9.6529899978E-01],
	[3.9535000000E+04, 3.3262679363E+01, 5.1985618178E+00, 1.5349736288E+01, 3.4773861779E+00, 9.6531426453E-01],
	[3.9540000000E+04, 3.3269991199E+01, 5.1985933090E+00, 1.5356053964E+01, 3.4778043169E+00, 9.6532952176E-01],
	[3.9545000000E+04, 3.3277303718E+01, 5.1986247964E+00, 1.5362373440E+01, 3.4782223525E+00, 9.6534477145E-01],
	[3.9550000000E+04, 3.3284616919E+01, 5.1986562801E+00, 1.5368694716E+01, 3.4786402847E+00, 9.6536001362E-01],
	[3.9555000000E+04, 3.3291930803E+01, 5.1986877599E+00, 1.5375017793E+01, 3.4790581136E+00, 9.6537524827E-01],
	[3.9560000000E+04, 3.3299245369E+01, 5.1987192359E+00, 1.5381342670E+01, 3.4794758390E+00, 9.6539047540E-01],
	[3.9565000000E+04, 3.3306560617E+01, 5.1987507082E+00, 1.5387669349E+01, 3.4798934612E+00, 9.6540569502E-01],
	[3.9570000000E+04, 3.3313876548E+01, 5.1987821767E+00, 1.5393997828E+01, 3.4803109801E+00, 9.6542090713E-01],
	[3.9575000000E+04, 3.3321193161E+01, 5.1988136414E+00, 1.5400328109E+01, 3.4807283956E+00, 9.6543611174E-01],
	[3.9580000000E+04, 3.3328510457E+01, 5.1988451023E+00, 1.5406660192E+01, 3.4811457079E+00, 9.6545130884E-01],
	[3.9585000000E+04, 3.3335828434E+01, 5.1988765594E+00, 1.5412994077E+01, 3.4815629169E+00, 9.6546649844E-01],
	[3.9590000000E+04, 3.3343147094E+01, 5.1989080127E+00, 1.5419329764E+01, 3.4819800227E+00, 9.6548168055E-01],
	[3.9595000000E+04, 3.3350466436E+01, 5.1989394623E+00, 1.5425667255E+01, 3.4823970253E+00, 9.6549685518E-01],
	[3.9600000000E+04, 3.3357786460E+01, 5.1989709080E+00, 1.5432006548E+01, 3.4828139247E+00, 9.6551202231E-01],
	[3.9605000000E+04, 3.3365107167E+01, 5.1990023500E+00, 1.5438347644E+01, 3.4832307209E+00, 9.6552718197E-01],
	[3.9610000000E+04, 3.3372428555E+01, 5.1990337882E+00, 1.5444690544E+01, 3.4836474139E+00, 9.6554233415E-01],
	[3.9615000000E+04, 3.3379750626E+01, 5.1990652227E+00, 1.5451035247E+01, 3.4840640038E+00, 9.6555747885E-01],
	[3.9620000000E+04, 3.3387073378E+01, 5.1990966533E+00, 1.5457381755E+01, 3.4844804906E+00, 9.6557261609E-01],
	[3.9625000000E+04, 3.3394396813E+01, 5.1991280802E+00, 1.5463730067E+01, 3.4848968742E+00, 9.6558774586E-01],
	[3.9630000000E+04, 3.3401720930E+01, 5.1991595033E+00, 1.5470080184E+01, 3.4853131548E+00, 9.6560286817E-01],
	[3.9635000000E+04, 3.3409045729E+01, 5.1991909226E+00, 1.5476432106E+01, 3.4857293323E+00, 9.6561798303E-01],
	[3.9640000000E+04, 3.3416371210E+01, 5.1992223382E+00, 1.5482785833E+01, 3.4861454068E+00, 9.6563309043E-01],
	[3.9645000000E+04, 3.3423697373E+01, 5.1992537500E+00, 1.5489141365E+01, 3.4865613782E+00, 9.6564819038E-01],
	[3.9650000000E+04, 3.3431024218E+01, 5.1992851580E+00, 1.5495498704E+01, 3.4869772467E+00, 9.6566328288E-01],
	[3.9655000000E+04, 3.3438351744E+01, 5.1993165622E+00, 1.5501857848E+01, 3.4873930121E+00, 9.6567836795E-01],
	[3.9660000000E+04, 3.3445679953E+01, 5.1993479627E+00, 1.5508218799E+01, 3.4878086746E+00, 9.6569344558E-01],
	[3.9665000000E+04, 3.3453008844E+01, 5.1993793594E+00, 1.5514581556E+01, 3.4882242341E+00, 9.6570851577E-01],
	[3.9670000000E+04, 3.3460338416E+01, 5.1994107524E+00, 1.5520946121E+01, 3.4886396906E+00, 9.6572357854E-01],
	[3.9675000000E+04, 3.3467668670E+01, 5.1994421415E+00, 1.5527312492E+01, 3.4890550443E+00, 9.6573863388E-01],
	[3.9680000000E+04, 3.3474999607E+01, 5.1994735269E+00, 1.5533680672E+01, 3.4894702950E+00, 9.6575368180E-01],
	[3.9685000000E+04, 3.3482331225E+01, 5.1995049086E+00, 1.5540050658E+01, 3.4898854429E+00, 9.6576872230E-01],
	[3.9690000000E+04, 3.3489663524E+01, 5.1995362864E+00, 1.5546422454E+01, 3.4903004879E+00, 9.6578375539E-01],
	[3.9695000000E+04, 3.3496996506E+01, 5.1995676606E+00, 1.5552796057E+01, 3.4907154301E+00, 9.6579878107E-01],
	[3.9700000000E+04, 3.3504330169E+01, 5.1995990309E+00, 1.5559171469E+01, 3.4911302695E+00, 9.6581379935E-01],
	[3.9705000000E+04, 3.3511664514E+01, 5.1996303975E+00, 1.5565548690E+01, 3.4915450060E+00, 9.6582881022E-01],
	[3.9710000000E+04, 3.3518999541E+01, 5.1996617603E+00, 1.5571927720E+01, 3.4919596398E+00, 9.6584381370E-01],
	[3.9715000000E+04, 3.3526335249E+01, 5.1996931194E+00, 1.5578308560E+01, 3.4923741708E+00, 9.6585880978E-01],
	[3.9720000000E+04, 3.3533671639E+01, 5.1997244747E+00, 1.5584691210E+01, 3.4927885991E+00, 9.6587379848E-01],
	[3.9725000000E+04, 3.3541008710E+01, 5.1997558262E+00, 1.5591075669E+01, 3.4932029246E+00, 9.6588877979E-01],
	[3.9730000000E+04, 3.3548346464E+01, 5.1997871740E+00, 1.5597461939E+01, 3.4936171474E+00, 9.6590375371E-01],
	[3.9735000000E+04, 3.3555684898E+01, 5.1998185181E+00, 1.5603850020E+01, 3.4940312675E+00, 9.6591872027E-01],
	[3.9740000000E+04, 3.3563024015E+01, 5.1998498584E+00, 1.5610239912E+01, 3.4944452850E+00, 9.6593367944E-01],
	[3.9745000000E+04, 3.3570363813E+01, 5.1998811949E+00, 1.5616631615E+01, 3.4948591998E+00, 9.6594863125E-01],
	[3.9750000000E+04, 3.3577704292E+01, 5.1999125277E+00, 1.5623025129E+01, 3.4952730120E+00, 9.6596357570E-01],
	[3.9755000000E+04, 3.3585045453E+01, 5.1999438567E+00, 1.5629420455E+01, 3.4956867215E+00, 9.6597851278E-01],
	[3.9760000000E+04, 3.3592387295E+01, 5.1999751820E+00, 1.5635817593E+01, 3.4961003285E+00, 9.6599344250E-01],
	[3.9765000000E+04, 3.3599729819E+01, 5.2000065035E+00, 1.5642216544E+01, 3.4965138329E+00, 9.6600836487E-01],
	[3.9770000000E+04, 3.3607073024E+01, 5.2000378212E+00, 1.5648617307E+01, 3.4969272347E+00, 9.6602327990E-01],
	[3.9775000000E+04, 3.3614416911E+01, 5.2000691353E+00, 1.5655019883E+01, 3.4973405340E+00, 9.6603818757E-01],
	[3.9780000000E+04, 3.3621761479E+01, 5.2001004455E+00, 1.5661424273E+01, 3.4977537308E+00, 9.6605308791E-01],
	[3.9785000000E+04, 3.3629106728E+01, 5.2001317521E+00, 1.5667830476E+01, 3.4981668250E+00, 9.6606798091E-01],
	[3.9790000000E+04, 3.3636452659E+01, 5.2001630549E+00, 1.5674238492E+01, 3.4985798168E+00, 9.6608286657E-01],
	[3.9795000000E+04, 3.3643799271E+01, 5.2001943539E+00, 1.5680648323E+01, 3.4989927061E+00, 9.6609774491E-01],
	[3.9800000000E+04, 3.3651146564E+01, 5.2002256492E+00, 1.5687059968E+01, 3.4994054930E+00, 9.6611261592E-01],
	[3.9805000000E+04, 3.3658494538E+01, 5.2002569407E+00, 1.5693473428E+01, 3.4998181775E+00, 9.6612747960E-01],
	[3.9810000000E+04, 3.3665843194E+01, 5.2002882286E+00, 1.5699888703E+01, 3.5002307595E+00, 9.6614233597E-01],
	[3.9815000000E+04, 3.3673192531E+01, 5.2003195126E+00, 1.5706305793E+01, 3.5006432392E+00, 9.6615718503E-01],
	[3.9820000000E+04, 3.3680542549E+01, 5.2003507929E+00, 1.5712724698E+01, 3.5010556165E+00, 9.6617202678E-01],
	[3.9825000000E+04, 3.3687893249E+01, 5.2003820695E+00, 1.5719145419E+01, 3.5014678915E+00, 9.6618686122E-01],
	[3.9830000000E+04, 3.3695244629E+01, 5.2004133424E+00, 1.5725567957E+01, 3.5018800641E+00, 9.6620168838E-01],
	[3.9835000000E+04, 3.3702596691E+01, 5.2004446115E+00, 1.5731992310E+01, 3.5022921344E+00, 9.6621650825E-01],
	[3.9840000000E+04, 3.3709949434E+01, 5.2004758769E+00, 1.5738418480E+01, 3.5027041024E+00, 9.6623132086E-01],
	[3.9845000000E+04, 3.3717302858E+01, 5.2005071385E+00, 1.5744846468E+01, 3.5031159682E+00, 9.6624612619E-01],
	[3.9850000000E+04, 3.3724656962E+01, 5.2005383964E+00, 1.5751276272E+01, 3.5035277317E+00, 9.6626092425E-01],
	[3.9855000000E+04, 3.3732011748E+01, 5.2005696506E+00, 1.5757707894E+01, 3.5039393929E+00, 9.6627571505E-01],
	[3.9860000000E+04, 3.3739367215E+01, 5.2006009010E+00, 1.5764141334E+01, 3.5043509520E+00, 9.6629049858E-01],
	[3.9865000000E+04, 3.3746723363E+01, 5.2006321477E+00, 1.5770576591E+01, 3.5047624088E+00, 9.6630527486E-01],
	[3.9870000000E+04, 3.3754085745E+01, 5.2006640997E+00, 1.5777013667E+01, 3.5051741455E+00, 9.6632004389E-01],
	[3.9875000000E+04, 3.3761460496E+01, 5.2006975400E+00, 1.5783452562E+01, 3.5055865840E+00, 9.6633480566E-01],
	[3.9880000000E+04, 3.3768835934E+01, 5.2007309762E+00, 1.5789893276E+01, 3.5059989207E+00, 9.6634956018E-01],
	[3.9885000000E+04, 3.3776212058E+01, 5.2007644085E+00, 1.5796335809E+01, 3.5064111555E+00, 9.6636430746E-01],
	[3.9890000000E+04, 3.3783588868E+01, 5.2007978368E+00, 1.5802780161E+01, 3.5068232886E+00, 9.6637904751E-01],
	[3.9895000000E+04, 3.3790966365E+01, 5.2008312611E+00, 1.5809226333E+01, 3.5072353199E+00, 9.6639378031E-01],
	[3.9900000000E+04, 3.3798344547E+01, 5.2008646815E+00, 1.5815674325E+01, 3.5076472495E+00, 9.6640850588E-01],
	[3.9905000000E+04, 3.3805723416E+01, 5.2008980979E+00, 1.5822124138E+01, 3.5080590774E+00, 9.6642322422E-01],
	[3.9910000000E+04, 3.3813102971E+01, 5.2009315103E+00, 1.5828575771E+01, 3.5084708035E+00, 9.6643793533E-01],
	[3.9915000000E+04, 3.3820483212E+01, 5.2009649187E+00, 1.5835029225E+01, 3.5088824280E+00, 9.6645263922E-01],
	[3.9920000000E+04, 3.3827864140E+01, 5.2009983232E+00, 1.5841484500E+01, 3.5092939507E+00, 9.6646733589E-01],
	[3.9925000000E+04, 3.3835245753E+01, 5.2010317237E+00, 1.5847941597E+01, 3.5097053719E+00, 9.6648202535E-01],
	[3.9930000000E+04, 3.3842628053E+01, 5.2010651202E+00, 1.5854400516E+01, 3.5101166914E+00, 9.6649670759E-01],
	[3.9935000000E+04, 3.3850011038E+01, 5.2010985127E+00, 1.5860861256E+01, 3.5105279092E+00, 9.6651138262E-01],
	[3.9940000000E+04, 3.3857394709E+01, 5.2011319013E+00, 1.5867323819E+01, 3.5109390255E+00, 9.6652605045E-01],
	[3.9945000000E+04, 3.3864779067E+01, 5.2011652860E+00, 1.5873788205E+01, 3.5113500402E+00, 9.6654071107E-01],
	[3.9950000000E+04, 3.3872164110E+01, 5.2011986666E+00, 1.5880254413E+01, 3.5117609534E+00, 9.6655536449E-01],
	[3.9955000000E+04, 3.3879549840E+01, 5.2012320433E+00, 1.5886722445E+01, 3.5121717650E+00, 9.6657001072E-01],
	[3.9960000000E+04, 3.3886936255E+01, 5.2012654161E+00, 1.5893192300E+01, 3.5125824751E+00, 9.6658464976E-01],
	[3.9965000000E+04, 3.3894323357E+01, 5.2012987848E+00, 1.5899663979E+01, 3.5129930837E+00, 9.6659928161E-01],
	[3.9970000000E+04, 3.3901711144E+01, 5.2013321497E+00, 1.5906137482E+01, 3.5134035908E+00, 9.6661390627E-01],
	[3.9975000000E+04, 3.3909099617E+01, 5.2013655105E+00, 1.5912612809E+01, 3.5138139964E+00, 9.6662852375E-01],
	[3.9980000000E+04, 3.3916488776E+01, 5.2013988674E+00, 1.5919089961E+01, 3.5142243006E+00, 9.6664313406E-01],
	[3.9985000000E+04, 3.3923878620E+01, 5.2014322204E+00, 1.5925568938E+01, 3.5146345034E+00, 9.6665773719E-01],
	[3.9990000000E+04, 3.3931269151E+01, 5.2014655693E+00, 1.5932049740E+01, 3.5150446048E+00, 9.6667233314E-01],
	[3.9995000000E+04, 3.3938660367E+01, 5.2014989144E+00, 1.5938532368E+01, 3.5154546048E+00, 9.6668692193E-01],
	[4.0000000000E+04, 3.3946052269E+01, 5.2015322554E+00, 1.5945016821E+01, 3.5158645034E+00, 9.6670150356E-01],
	[4.0005000000E+04, 3.3953444857E+01, 5.2015655926E+00, 1.5951527732E+01, 3.5162754976E+00, 9.6671607803E-01],
	[4.0010000000E+04, 3.3960838131E+01, 5.2015989257E+00, 1.5958040486E+01, 3.5166863899E+00, 9.6673064533E-01],
	[4.0015000000E+04, 3.3968232090E+01, 5.2016322549E+00, 1.5964555084E+01, 3.5170971803E+00, 9.6674520549E-01],
	[4.0020000000E+04, 3.3975626735E+01, 5.2016655802E+00, 1.5971071526E+01, 3.5175078688E+00, 9.6675975849E-01],
	[4.0025000000E+04, 3.3983022065E+01, 5.2016989015E+00, 1.5977589813E+01, 3.5179184555E+00, 9.6677430435E-01],
	[4.0030000000E+04, 3.3990418081E+01, 5.2017322189E+00, 1.5984109944E+01, 3.5183289404E+00, 9.6678884306E-01],
	[4.0035000000E+04, 3.3997814783E+01, 5.2017655323E+00, 1.5990631920E+01, 3.5187393236E+00, 9.6680337463E-01],
	[4.0040000000E+04, 3.4005212171E+01, 5.2017988418E+00, 1.5997155741E+01, 3.5191496049E+00, 9.6681789907E-01],
	[4.0045000000E+04, 3.4012610243E+01, 5.2018321473E+00, 1.6003681407E+01, 3.5195597845E+00, 9.6683241637E-01],
	[4.0050000000E+04, 3.4020009002E+01, 5.2018654489E+00, 1.6010208919E+01, 3.5199698623E+00, 9.6684692655E-01],
	[4.0055000000E+04, 3.4027408446E+01, 5.2018987465E+00, 1.6016738278E+01, 3.5203798385E+00, 9.6686142959E-01],
	[4.0060000000E+04, 3.4034808575E+01, 5.2019320402E+00, 1.6023269482E+01, 3.5207897129E+00, 9.6687592552E-01],
	[4.0065000000E+04, 3.4042209390E+01, 5.2019653300E+00, 1.6029802534E+01, 3.5211994857E+00, 9.6689041432E-01],
	[4.0070000000E+04, 3.4049610891E+01, 5.2019986158E+00, 1.6036337432E+01, 3.5216091568E+00, 9.6690489601E-01],
	[4.0075000000E+04, 3.4057013077E+01, 5.2020318976E+00, 1.6042874177E+01, 3.5220187262E+00, 9.6691937059E-01],
	[4.0080000000E+04, 3.4064415948E+01, 5.2020651756E+00, 1.6049412770E+01, 3.5224281941E+00, 9.6693383806E-01],
	[4.0085000000E+04, 3.4071819504E+01, 5.2020984496E+00, 1.6055953211E+01, 3.5228375603E+00, 9.6694829842E-01],
	[4.0090000000E+04, 3.4079223746E+01, 5.2021317196E+00, 1.6062495500E+01, 3.5232468250E+00, 9.6696275168E-01],
	[4.0095000000E+04, 3.4086628674E+01, 5.2021649857E+00, 1.6069039637E+01, 3.5236559881E+00, 9.6697719785E-01],
	[4.0100000000E+04, 3.4094034286E+01, 5.2021982479E+00, 1.6075585623E+01, 3.5240650496E+00, 9.6699163691E-01],
	[4.0105000000E+04, 3.4101440584E+01, 5.2022315062E+00, 1.6082133457E+01, 3.5244740096E+00, 9.6700606889E-01],
	[4.0110000000E+04, 3.4108847567E+01, 5.2022647605E+00, 1.6088683141E+01, 3.5248828682E+00, 9.6702049378E-01],
	[4.0115000000E+04, 3.4116255236E+01, 5.2022980109E+00, 1.6095234675E+01, 3.5252916252E+00, 9.6703491158E-01],
	[4.0120000000E+04, 3.4123663590E+01, 5.2023312573E+00, 1.6101788058E+01, 3.5257002808E+00, 9.6704932230E-01],
	[4.0125000000E+04, 3.4131072628E+01, 5.2023644998E+00, 1.6108343292E+01, 3.5261088349E+00, 9.6706372595E-01],
	[4.0130000000E+04, 3.4138482353E+01, 5.2023977384E+00, 1.6114900376E+01, 3.5265172876E+00, 9.6707812252E-01],
	[4.0135000000E+04, 3.4145892762E+01, 5.2024309731E+00, 1.6121459311E+01, 3.5269256389E+00, 9.6709251202E-01],
	[4.0140000000E+04, 3.4153303856E+01, 5.2024642038E+00, 1.6128020096E+01, 3.5273338888E+00, 9.6710689445E-01],
	[4.0145000000E+04, 3.4160715636E+01, 5.2024974306E+00, 1.6134582733E+01, 3.5277420374E+00, 9.6712126982E-01],
	[4.0150000000E+04, 3.4168128100E+01, 5.2025306535E+00, 1.6141147222E+01, 3.5281500846E+00, 9.6713563813E-01],
	[4.0155000000E+04, 3.4175541250E+01, 5.2025638725E+00, 1.6147713562E+01, 3.5285580304E+00, 9.6714999938E-01],
	[4.0160000000E+04, 3.4182955085E+01, 5.2025970875E+00, 1.6154281755E+01, 3.5289658750E+00, 9.6716435358E-01],
	[4.0165000000E+04, 3.4190369604E+01, 5.2026302986E+00, 1.6160851800E+01, 3.5293736182E+00, 9.6717870073E-01],
	[4.0170000000E+04, 3.4197784809E+01, 5.2026635058E+00, 1.6167423698E+01, 3.5297812602E+00, 9.6719304083E-01],
	[4.0175000000E+04, 3.4205200699E+01, 5.2026967091E+00, 1.6173997449E+01, 3.5301888010E+00, 9.6720737389E-01],
	[4.0180000000E+04, 3.4212617274E+01, 5.2027299084E+00, 1.6180573053E+01, 3.5305962405E+00, 9.6722169991E-01],
	[4.0185000000E+04, 3.4220034533E+01, 5.2027631038E+00, 1.6187150511E+01, 3.5310035788E+00, 9.6723601889E-01],
	[4.0190000000E+04, 3.4227452478E+01, 5.2027962953E+00, 1.6193729822E+01, 3.5314108159E+00, 9.6725033084E-01],
	[4.0195000000E+04, 3.4234871108E+01, 5.2028294829E+00, 1.6200310988E+01, 3.5318179518E+00, 9.6726463576E-01],
	[4.0200000000E+04, 3.4242290422E+01, 5.2028626666E+00, 1.6206894009E+01, 3.5322249866E+00, 9.6727893365E-01],
	[4.0205000000E+04, 3.4249710421E+01, 5.2028958464E+00, 1.6213478884E+01, 3.5326319202E+00, 9.6729322453E-01],
	[4.0210000000E+04, 3.4257131105E+01, 5.2029290222E+00, 1.6220065614E+01, 3.5330387527E+00, 9.6730750838E-01],
	[4.0215000000E+04, 3.4264552474E+01, 5.2029621941E+00, 1.6226654200E+01, 3.5334454841E+00, 9.6732178522E-01],
	[4.0220000000E+04, 3.4271974528E+01, 5.2029953621E+00, 1.6233244641E+01, 3.5338521145E+00, 9.6733605505E-01],
	[4.0225000000E+04, 3.4279397266E+01, 5.2030285262E+00, 1.6239836938E+01, 3.5342586438E+00, 9.6735031786E-01],
	[4.0230000000E+04, 3.4286820689E+01, 5.2030616864E+00, 1.6246431092E+01, 3.5346650720E+00, 9.6736457368E-01],
	[4.0235000000E+04, 3.4294244797E+01, 5.2030948427E+00, 1.6253027102E+01, 3.5350713993E+00, 9.6737882249E-01],
	[4.0240000000E+04, 3.4301669590E+01, 5.2031279951E+00, 1.6259624969E+01, 3.5354776255E+00, 9.6739306430E-01],
	[4.0245000000E+04, 3.4309095067E+01, 5.2031611436E+00, 1.6266224693E+01, 3.5358837508E+00, 9.6740729912E-01],
	[4.0250000000E+04, 3.4316521229E+01, 5.2031942881E+00, 1.6272826274E+01, 3.5362897751E+00, 9.6742152695E-01],
	[4.0255000000E+04, 3.4323948076E+01, 5.2032274288E+00, 1.6279429713E+01, 3.5366956984E+00, 9.6743574779E-01],
	[4.0260000000E+04, 3.4331375607E+01, 5.2032605655E+00, 1.6286035010E+01, 3.5371015209E+00, 9.6744996164E-01],
	[4.0265000000E+04, 3.4338803823E+01, 5.2032936984E+00, 1.6292642166E+01, 3.5375072424E+00, 9.6746416852E-01],
	[4.0270000000E+04, 3.4346232723E+01, 5.2033268273E+00, 1.6299251180E+01, 3.5379128631E+00, 9.6747836842E-01],
	[4.0275000000E+04, 3.4353662308E+01, 5.2033599524E+00, 1.6305862053E+01, 3.5383183829E+00, 9.6749256134E-01],
	[4.0280000000E+04, 3.4361092577E+01, 5.2033930735E+00, 1.6312474785E+01, 3.5387238018E+00, 9.6750674729E-01],
	[4.0285000000E+04, 3.4368523531E+01, 5.2034261907E+00, 1.6319089376E+01, 3.5391291199E+00, 9.6752092628E-01],
	[4.0290000000E+04, 3.4375955170E+01, 5.2034593041E+00, 1.6325705827E+01, 3.5395343373E+00, 9.6753509830E-01],
	[4.0295000000E+04, 3.4383387493E+01, 5.2034924135E+00, 1.6332324138E+01, 3.5399394538E+00, 9.6754926336E-01],
	[4.0300000000E+04, 3.4390820500E+01, 5.2035255191E+00, 1.6338944310E+01, 3.5403444696E+00, 9.6756342147E-01],
	[4.0305000000E+04, 3.4398254192E+01, 5.2035586207E+00, 1.6345566342E+01, 3.5407493846E+00, 9.6757757262E-01],
	[4.0310000000E+04, 3.4405688568E+01, 5.2035917185E+00, 1.6352190235E+01, 3.5411541989E+00, 9.6759171683E-01],
	[4.0315000000E+04, 3.4413123629E+01, 5.2036248123E+00, 1.6358815989E+01, 3.5415589125E+00, 9.6760585408E-01],
	[4.0320000000E+04, 3.4420559373E+01, 5.2036579023E+00, 1.6365443605E+01, 3.5419635255E+00, 9.6761998440E-01],
	[4.0325000000E+04, 3.4427995803E+01, 5.2036909884E+00, 1.6372073083E+01, 3.5423680377E+00, 9.6763410777E-01],
	[4.0330000000E+04, 3.4435432916E+01, 5.2037240705E+00, 1.6378704422E+01, 3.5427724493E+00, 9.6764822421E-01],
	[4.0335000000E+04, 3.4442870714E+01, 5.2037571488E+00, 1.6385337624E+01, 3.5431767603E+00, 9.6766233371E-01],
	[4.0340000000E+04, 3.4450309196E+01, 5.2037902232E+00, 1.6391972689E+01, 3.5435809707E+00, 9.6767643629E-01],
	[4.0345000000E+04, 3.4457748362E+01, 5.2038232937E+00, 1.6398609617E+01, 3.5439850805E+00, 9.6769053194E-01],
	[4.0350000000E+04, 3.4465188213E+01, 5.2038563604E+00, 1.6405248407E+01, 3.5443890897E+00, 9.6770462067E-01],
	[4.0355000000E+04, 3.4472628748E+01, 5.2038894231E+00, 1.6411889062E+01, 3.5447929984E+00, 9.6771870248E-01],
	[4.0360000000E+04, 3.4480069967E+01, 5.2039224819E+00, 1.6418531580E+01, 3.5451968065E+00, 9.6773277738E-01],
	[4.0365000000E+04, 3.4487511870E+01, 5.2039555369E+00, 1.6425175962E+01, 3.5456005142E+00, 9.6774684536E-01],
	[4.0370000000E+04, 3.4494954457E+01, 5.2039885880E+00, 1.6431822209E+01, 3.5460041213E+00, 9.6776090644E-01],
	[4.0375000000E+04, 3.4502397728E+01, 5.2040216352E+00, 1.6438470320E+01, 3.5464076280E+00, 9.6777496061E-01],
	[4.0380000000E+04, 3.4509841683E+01, 5.2040546785E+00, 1.6445120297E+01, 3.5468110342E+00, 9.6778900788E-01],
	[4.0385000000E+04, 3.4517286323E+01, 5.2040877179E+00, 1.6451772139E+01, 3.5472143400E+00, 9.6780304825E-01],
	[4.0390000000E+04, 3.4524731646E+01, 5.2041207535E+00, 1.6458425846E+01, 3.5476175454E+00, 9.6781708172E-01],
	[4.0395000000E+04, 3.4532177654E+01, 5.2041537851E+00, 1.6465081419E+01, 3.5480206504E+00, 9.6783110831E-01],
	[4.0400000000E+04, 3.4539624346E+01, 5.2041868129E+00, 1.6471738858E+01, 3.5484236550E+00, 9.6784512801E-01],
	[4.0405000000E+04, 3.4547071721E+01, 5.2042198368E+00, 1.6478398164E+01, 3.5488265593E+00, 9.6785914082E-01],
	[4.0410000000E+04, 3.4554519781E+01, 5.2042528569E+00, 1.6485059337E+01, 3.5492293632E+00, 9.6787314675E-01],
	[4.0415000000E+04, 3.4561968524E+01, 5.2042858730E+00, 1.6491722376E+01, 3.5496320669E+00, 9.6788714581E-01],
	[4.0420000000E+04, 3.4569417951E+01, 5.2043188853E+00, 1.6498387283E+01, 3.5500346702E+00, 9.6790113799E-01],
	[4.0425000000E+04, 3.4576868062E+01, 5.2043518937E+00, 1.6505054057E+01, 3.5504371733E+00, 9.6791512330E-01],
	[4.0430000000E+04, 3.4584318858E+01, 5.2043848983E+00, 1.6511722700E+01, 3.5508395761E+00, 9.6792910174E-01],
	[4.0435000000E+04, 3.4591770337E+01, 5.2044178989E+00, 1.6518393210E+01, 3.5512418787E+00, 9.6794307332E-01],
	[4.0440000000E+04, 3.4599222499E+01, 5.2044508957E+00, 1.6525065589E+01, 3.5516440811E+00, 9.6795703804E-01],
	[4.0445000000E+04, 3.4606675346E+01, 5.2044838887E+00, 1.6531739837E+01, 3.5520461832E+00, 9.6797099591E-01],
	[4.0450000000E+04, 3.4614128876E+01, 5.2045168777E+00, 1.6538415954E+01, 3.5524481852E+00, 9.6798494692E-01],
	[4.0455000000E+04, 3.4621583090E+01, 5.2045498629E+00, 1.6545093941E+01, 3.5528500871E+00, 9.6799889108E-01],
	[4.0460000000E+04, 3.4629037988E+01, 5.2045828442E+00, 1.6551773797E+01, 3.5532518888E+00, 9.6801282839E-01],
	[4.0465000000E+04, 3.4636493570E+01, 5.2046158217E+00, 1.6558455523E+01, 3.5536535904E+00, 9.6802675886E-01],
	[4.0470000000E+04, 3.4643949835E+01, 5.2046487953E+00, 1.6565139119E+01, 3.5540551919E+00, 9.6804068250E-01],
	[4.0475000000E+04, 3.4651406784E+01, 5.2046817650E+00, 1.6571824585E+01, 3.5544566933E+00, 9.6805459929E-01],
	[4.0480000000E+04, 3.4658864417E+01, 5.2047147309E+00, 1.6578511923E+01, 3.5548580947E+00, 9.6806850926E-01],
	[4.0485000000E+04, 3.4666322733E+01, 5.2047476929E+00, 1.6585201132E+01, 3.5552593961E+00, 9.6808241239E-01],
	[4.0490000000E+04, 3.4673781733E+01, 5.2047806510E+00, 1.6591892212E+01, 3.5556605974E+00, 9.6809630870E-01],
	[4.0495000000E+04, 3.4681241416E+01, 5.2048136053E+00, 1.6598585163E+01, 3.5560616987E+00, 9.6811019818E-01],
	[4.0500000000E+04, 3.4688701783E+01, 5.2048465557E+00, 1.6605279987E+01, 3.5564627001E+00, 9.6812408085E-01],
	[4.0505000000E+04, 3.4696162834E+01, 5.2048795022E+00, 1.6611976683E+01, 3.5568636015E+00, 9.6813795670E-01],
	[4.0510000000E+04, 3.4703624568E+01, 5.2049124449E+00, 1.6618675252E+01, 3.5572644030E+00, 9.6815182574E-01],
	[4.0515000000E+04, 3.4711103341E+01, 5.2049474442E+00, 1.6625375694E+01, 3.5576662390E+00, 9.6816568798E-01],
	[4.0520000000E+04, 3.4718583541E+01, 5.2049825326E+00, 1.6632078008E+01, 3.5580680266E+00, 9.6817954340E-01],
	[4.0525000000E+04, 3.4726064431E+01, 5.2050176168E+00, 1.6638782196E+01, 3.5584697147E+00, 9.6819339203E-01],
	[4.0530000000E+04, 3.4733546009E+01, 5.2050526970E+00, 1.6645488258E+01, 3.5588713033E+00, 9.6820723385E-01],
	[4.0535000000E+04, 3.4741028276E+01, 5.2050877731E+00, 1.6652196194E+01, 3.5592727923E+00, 9.6822106889E-01],
	[4.0540000000E+04, 3.4748511231E+01, 5.2051228451E+00, 1.6658906004E+01, 3.5596741818E+00, 9.6823489713E-01],
	[4.0545000000E+04, 3.4755994875E+01, 5.2051579130E+00, 1.6665617689E+01, 3.5600754717E+00, 9.6824871858E-01],
	[4.0550000000E+04, 3.4763479208E+01, 5.2051929768E+00, 1.6672331249E+01, 3.5604766622E+00, 9.6826253325E-01],
	[4.0555000000E+04, 3.4770964229E+01, 5.2052280365E+00, 1.6679046684E+01, 3.5608777533E+00, 9.6827634113E-01],
	[4.0560000000E+04, 3.4778449939E+01, 5.2052630921E+00, 1.6685763995E+01, 3.5612787449E+00, 9.6829014224E-01],
	[4.0565000000E+04, 3.4785936337E+01, 5.2052981437E+00, 1.6692483181E+01, 3.5616796370E+00, 9.6830393658E-01],
	[4.0570000000E+04, 3.4793423424E+01, 5.2053331911E+00, 1.6699204243E+01, 3.5620804298E+00, 9.6831772414E-01],
	[4.0575000000E+04, 3.4800911199E+01, 5.2053682345E+00, 1.6705927182E+01, 3.5624811232E+00, 9.6833150494E-01],
	[4.0580000000E+04, 3.4808399663E+01, 5.2054032738E+00, 1.6712651998E+01, 3.5628817172E+00, 9.6834527897E-01],
	[4.0585000000E+04, 3.4815888815E+01, 5.2054383090E+00, 1.6719378690E+01, 3.5632822119E+00, 9.6835904624E-01],
	[4.0590000000E+04, 3.4823378656E+01, 5.2054733401E+00, 1.6726107260E+01, 3.5636826073E+00, 9.6837280676E-01],
	[4.0595000000E+04, 3.4830869185E+01, 5.2055083672E+00, 1.6732837707E+01, 3.5640829034E+00, 9.6838656052E-01],
	[4.0600000000E+04, 3.4838360402E+01, 5.2055433902E+00, 1.6739570032E+01, 3.5644831002E+00, 9.6840030753E-01],
	[4.0605000000E+04, 3.4845852308E+01, 5.2055784091E+00, 1.6746304235E+01, 3.5648831977E+00, 9.6841404780E-01],
	[4.0610000000E+04, 3.4853344902E+01, 5.2056134239E+00, 1.6753040317E+01, 3.5652831960E+00, 9.6842778132E-01],
	[4.0615000000E+04, 3.4860838185E+01, 5.2056484346E+00, 1.6759778277E+01, 3.5656830950E+00, 9.6844150810E-01],
	[4.0620000000E+04, 3.4868332156E+01, 5.2056834413E+00, 1.6766518116E+01, 3.5660828949E+00, 9.6845522815E-01],
	[4.0625000000E+04, 3.4875826815E+01, 5.2057184439E+00, 1.6773259835E+01, 3.5664825955E+00, 9.6846894146E-01],
	[4.0630000000E+04, 3.4883322162E+01, 5.2057534424E+00, 1.6780003433E+01, 3.5668821970E+00, 9.6848264804E-01],
	[4.0635000000E+04, 3.4890818197E+01, 5.2057884369E+00, 1.6786748911E+01, 3.5672816994E+00, 9.6849634790E-01],
	[4.0640000000E+04, 3.4898314921E+01, 5.2058234273E+00, 1.6793496269E+01, 3.5676811026E+00, 9.6851004103E-01],
	[4.0645000000E+04, 3.4905812333E+01, 5.2058584136E+00, 1.6800245508E+01, 3.5680804067E+00, 9.6852372745E-01],
	[4.0650000000E+04, 3.4913310433E+01, 5.2058933959E+00, 1.6806996628E+01, 3.5684796118E+00, 9.6853740714E-01],
	[4.0655000000E+04, 3.4920809221E+01, 5.2059283740E+00, 1.6813749628E+01, 3.5688787178E+00, 9.6855108013E-01],
	[4.0660000000E+04, 3.4928308698E+01, 5.2059633481E+00, 1.6820504510E+01, 3.5692777247E+00, 9.6856474641E-01],
	[4.0665000000E+04, 3.4935808862E+01, 5.2059983182E+00, 1.6827261273E+01, 3.5696766326E+00, 9.6857840598E-01],
	[4.0670000000E+04, 3.4943309715E+01, 5.2060332842E+00, 1.6834019919E+01, 3.5700754415E+00, 9.6859205885E-01],
	[4.0675000000E+04, 3.4950811255E+01, 5.2060682461E+00, 1.6840780447E+01, 3.5704741514E+00, 9.6860570501E-01],
	[4.0680000000E+04, 3.4958313484E+01, 5.2061032040E+00, 1.6847542857E+01, 3.5708727624E+00, 9.6861934449E-01],
	[4.0685000000E+04, 3.4965816401E+01, 5.2061381578E+00, 1.6854307150E+01, 3.5712712744E+00, 9.6863297727E-01],
	[4.0690000000E+04, 3.4973320005E+01, 5.2061731075E+00, 1.6861073326E+01, 3.5716696875E+00, 9.6864660336E-01],
	[4.0695000000E+04, 3.4980824298E+01, 5.2062080532E+00, 1.6867841385E+01, 3.5720680016E+00, 9.6866022277E-01],
	[4.0700000000E+04, 3.4988329279E+01, 5.2062429948E+00, 1.6874611328E+01, 3.5724662169E+00, 9.6867383550E-01],
	[4.0705000000E+04, 3.4995834947E+01, 5.2062779323E+00, 1.6881383156E+01, 3.5728643333E+00, 9.6868744155E-01],
	[4.0710000000E+04, 3.5003341304E+01, 5.2063128658E+00, 1.6888156867E+01, 3.5732623509E+00, 9.6870104092E-01],
	[4.0715000000E+04, 3.5010848348E+01, 5.2063477953E+00, 1.6894932463E+01, 3.5736602697E+00, 9.6871463362E-01],
	[4.0720000000E+04, 3.5018356080E+01, 5.2063827207E+00, 1.6901709944E+01, 3.5740580896E+00, 9.6872821965E-01],
	[4.0725000000E+04, 3.5025864500E+01, 5.2064176420E+00, 1.6908489310E+01, 3.5744558108E+00, 9.6874179902E-01],
	[4.0730000000E+04, 3.5033373608E+01, 5.2064525593E+00, 1.6915270561E+01, 3.5748534331E+00, 9.6875537173E-01],
	[4.0735000000E+04, 3.5040883404E+01, 5.2064874725E+00, 1.6922053698E+01, 3.5752509568E+00, 9.6876893778E-01],
	[4.0740000000E+04, 3.5048393887E+01, 5.2065223817E+00, 1.6928838721E+01, 3.5756483817E+00, 9.6878249718E-01],
	[4.0745000000E+04, 3.5055905058E+01, 5.2065572868E+00, 1.6935625631E+01, 3.5760457079E+00, 9.6879604992E-01],
	[4.0750000000E+04, 3.5063416917E+01, 5.2065921879E+00, 1.6942414427E+01, 3.5764429354E+00, 9.6880959602E-01],
	[4.0755000000E+04, 3.5070929464E+01, 5.2066270849E+00, 1.6949205110E+01, 3.5768400642E+00, 9.6882313547E-01],
	[4.0760000000E+04, 3.5078442698E+01, 5.2066619779E+00, 1.6955997680E+01, 3.5772370944E+00, 9.6883666828E-01],
	[4.0765000000E+04, 3.5085956620E+01, 5.2066968669E+00, 1.6962792137E+01, 3.5776340260E+00, 9.6885019445E-01],
	[4.0770000000E+04, 3.5093471230E+01, 5.2067317518E+00, 1.6969588483E+01, 3.5780308590E+00, 9.6886371399E-01],
	[4.0775000000E+04, 3.5100986527E+01, 5.2067666326E+00, 1.6976386716E+01, 3.5784275934E+00, 9.6887722690E-01],
	[4.0780000000E+04, 3.5108502512E+01, 5.2068015094E+00, 1.6983186838E+01, 3.5788242292E+00, 9.6889073318E-01],
	[4.0785000000E+04, 3.5116019185E+01, 5.2068363822E+00, 1.6989988849E+01, 3.5792207664E+00, 9.6890423284E-01],
	[4.0790000000E+04, 3.5123536545E+01, 5.2068712509E+00, 1.6996792748E+01, 3.5796172051E+00, 9.6891772588E-01],
	[4.0795000000E+04, 3.5131054593E+01, 5.2069061156E+00, 1.7003598537E+01, 3.5800135454E+00, 9.6893121230E-01],
	[4.0800000000E+04, 3.5138573328E+01, 5.2069409762E+00, 1.7010406215E+01, 3.5804097871E+00, 9.6894469210E-01],
	[4.0805000000E+04, 3.5146092751E+01, 5.2069758328E+00, 1.7017215783E+01, 3.5808059304E+00, 9.6895816530E-01],
	[4.0810000000E+04, 3.5153612861E+01, 5.2070106854E+00, 1.7024027241E+01, 3.5812019752E+00, 9.6897163189E-01],
	[4.0815000000E+04, 3.5161133658E+01, 5.2070455339E+00, 1.7030840590E+01, 3.5815979216E+00, 9.6898509188E-01],
	[4.0820000000E+04, 3.5168655143E+01, 5.2070803784E+00, 1.7037655829E+01, 3.5819937695E+00, 9.6899854526E-01],
	[4.0825000000E+04, 3.5176177316E+01, 5.2071152189E+00, 1.7044472959E+01, 3.5823895191E+00, 9.6901199205E-01],
	[4.0830000000E+04, 3.5183700176E+01, 5.2071500553E+00, 1.7051291981E+01, 3.5827851704E+00, 9.6902543225E-01],
	[4.0835000000E+04, 3.5191223723E+01, 5.2071848877E+00, 1.7058112894E+01, 3.5831807232E+00, 9.6903886586E-01],
	[4.0840000000E+04, 3.5198747958E+01, 5.2072197161E+00, 1.7064935699E+01, 3.5835761778E+00, 9.6905229288E-01],
	[4.0845000000E+04, 3.5206272880E+01, 5.2072545404E+00, 1.7071760396E+01, 3.5839715340E+00, 9.6906571331E-01],
	[4.0850000000E+04, 3.5213798489E+01, 5.2072893607E+00, 1.7078586986E+01, 3.5843667920E+00, 9.6907912717E-01],
	[4.0855000000E+04, 3.5221324785E+01, 5.2073241770E+00, 1.7085415468E+01, 3.5847619516E+00, 9.6909253445E-01],
	[4.0860000000E+04, 3.5228851769E+01, 5.2073589892E+00, 1.7092245843E+01, 3.5851570131E+00, 9.6910593516E-01],
	[4.0865000000E+04, 3.5236379440E+01, 5.2073937974E+00, 1.7099078112E+01, 3.5855519763E+00, 9.6911932930E-01],
	[4.0870000000E+04, 3.5243907799E+01, 5.2074286016E+00, 1.7105912274E+01, 3.5859468413E+00, 9.6913271687E-01],
	[4.0875000000E+04, 3.5251436844E+01, 5.2074634018E+00, 1.7112748331E+01, 3.5863416081E+00, 9.6914609788E-01],
	[4.0880000000E+04, 3.5258966577E+01, 5.2074981979E+00, 1.7119586281E+01, 3.5867362767E+00, 9.6915947233E-01],
	[4.0885000000E+04, 3.5266496997E+01, 5.2075329901E+00, 1.7126426126E+01, 3.5871308472E+00, 9.6917284023E-01],
	[4.0890000000E+04, 3.5274028103E+01, 5.2075677782E+00, 1.7133267866E+01, 3.5875253195E+00, 9.6918620157E-01],
	[4.0895000000E+04, 3.5281559898E+01, 5.2076025622E+00, 1.7140111501E+01, 3.5879196938E+00, 9.6919955636E-01],
	[4.0900000000E+04, 3.5289092379E+01, 5.2076373423E+00, 1.7146957031E+01, 3.5883139700E+00, 9.6921290461E-01],
	[4.0905000000E+04, 3.5296625547E+01, 5.2076721183E+00, 1.7153804457E+01, 3.5887081480E+00, 9.6922624632E-01],
	[4.0910000000E+04, 3.5304159402E+01, 5.2077068903E+00, 1.7160653779E+01, 3.5891022281E+00, 9.6923958148E-01],
	[4.0915000000E+04, 3.5311693945E+01, 5.2077416583E+00, 1.7167504997E+01, 3.5894962101E+00, 9.6925291011E-01],
	[4.0920000000E+04, 3.5319229174E+01, 5.2077764223E+00, 1.7174358112E+01, 3.5898900941E+00, 9.6926623221E-01],
	[4.0925000000E+04, 3.5326765090E+01, 5.2078111823E+00, 1.7181213123E+01, 3.5902838801E+00, 9.6927954778E-01],
	[4.0930000000E+04, 3.5334301694E+01, 5.2078459382E+00, 1.7188070032E+01, 3.5906775682E+00, 9.6929285683E-01],
	[4.0935000000E+04, 3.5341838984E+01, 5.2078806902E+00, 1.7194928838E+01, 3.5910711583E+00, 9.6930615935E-01],
	[4.0940000000E+04, 3.5349376961E+01, 5.2079154381E+00, 1.7201789542E+01, 3.5914646505E+00, 9.6931945535E-01],
	[4.0945000000E+04, 3.5356915625E+01, 5.2079501820E+00, 1.7208652144E+01, 3.5918580447E+00, 9.6933274484E-01],
	[4.0950000000E+04, 3.5364454976E+01, 5.2079849219E+00, 1.7215516644E+01, 3.5922513411E+00, 9.6934602782E-01],
	[4.0955000000E+04, 3.5371995014E+01, 5.2080196578E+00, 1.7222383043E+01, 3.5926445396E+00, 9.6935930429E-01],
	[4.0960000000E+04, 3.5379535739E+01, 5.2080543897E+00, 1.7229251341E+01, 3.5930376403E+00, 9.6937257425E-01],
	[4.0965000000E+04, 3.5387077150E+01, 5.2080891176E+00, 1.7236121537E+01, 3.5934306431E+00, 9.6938583771E-01],
	[4.0970000000E+04, 3.5394619249E+01, 5.2081238415E+00, 1.7242993634E+01, 3.5938235482E+00, 9.6939909467E-01],
	[4.0975000000E+04, 3.5402162034E+01, 5.2081585613E+00, 1.7249867630E+01, 3.5942163554E+00, 9.6941234514E-01],
	[4.0980000000E+04, 3.5409705506E+01, 5.2081932772E+00, 1.7256743526E+01, 3.5946090649E+00, 9.6942558912E-01],
	[4.0985000000E+04, 3.5417249664E+01, 5.2082279890E+00, 1.7263621323E+01, 3.5950016766E+00, 9.6943882660E-01],
	[4.0990000000E+04, 3.5424794510E+01, 5.2082626969E+00, 1.7270501020E+01, 3.5953941906E+00, 9.6945205761E-01],
	[4.0995000000E+04, 3.5432340042E+01, 5.2082974007E+00, 1.7277382618E+01, 3.5957866069E+00, 9.6946528213E-01],
	[4.1000000000E+04, 3.5439886260E+01, 5.2083321006E+00, 1.7284266118E+01, 3.5961789255E+00, 9.6947850017E-01],
	[4.1005000000E+04, 3.5447433166E+01, 5.2083667964E+00, 1.7291151518E+01, 3.5965711465E+00, 9.6949171174E-01],
	[4.1010000000E+04, 3.5454980758E+01, 5.2084014883E+00, 1.7298038821E+01, 3.5969632698E+00, 9.6950491684E-01],
	[4.1015000000E+04, 3.5462529036E+01, 5.2084361761E+00, 1.7304928026E+01, 3.5973552954E+00, 9.6951811547E-01],
	[4.1020000000E+04, 3.5470078001E+01, 5.2084708600E+00, 1.7311819133E+01, 3.5977472235E+00, 9.6953130763E-01],
	[4.1025000000E+04, 3.5477627653E+01, 5.2085055399E+00, 1.7318712143E+01, 3.5981390540E+00, 9.6954449333E-01],
	[4.1030000000E+04, 3.5485177991E+01, 5.2085402157E+00, 1.7325607056E+01, 3.5985307869E+00, 9.6955767258E-01],
	[4.1035000000E+04, 3.5492729016E+01, 5.2085748876E+00, 1.7332503873E+01, 3.5989224223E+00, 9.6957084537E-01],
	[4.1040000000E+04, 3.5500280727E+01, 5.2086095555E+00, 1.7339402592E+01, 3.5993139601E+00, 9.6958401171E-01],
	[4.1045000000E+04, 3.5507833125E+01, 5.2086442193E+00, 1.7346303216E+01, 3.5997054004E+00, 9.6959717160E-01],
	[4.1050000000E+04, 3.5515386209E+01, 5.2086788792E+00, 1.7353205744E+01, 3.6000967433E+00, 9.6961032505E-01],
	[4.1055000000E+04, 3.5522939980E+01, 5.2087135351E+00, 1.7360110176E+01, 3.6004879887E+00, 9.6962347206E-01],
	[4.1060000000E+04, 3.5530494437E+01, 5.2087481870E+00, 1.7367016514E+01, 3.6008791366E+00, 9.6963661262E-01],
	[4.1065000000E+04, 3.5538049581E+01, 5.2087828350E+00, 1.7373924756E+01, 3.6012701871E+00, 9.6964974676E-01],
	[4.1070000000E+04, 3.5545605411E+01, 5.2088174789E+00, 1.7380834903E+01, 3.6016611402E+00, 9.6966287446E-01],
	[4.1075000000E+04, 3.5553161927E+01, 5.2088521188E+00, 1.7387746956E+01, 3.6020519960E+00, 9.6967599574E-01],
	[4.1080000000E+04, 3.5560719129E+01, 5.2088867548E+00, 1.7394660915E+01, 3.6024427543E+00, 9.6968911059E-01],
	[4.1085000000E+04, 3.5568277018E+01, 5.2089213868E+00, 1.7401576781E+01, 3.6028334154E+00, 9.6970221902E-01],
	[4.1090000000E+04, 3.5575835593E+01, 5.2089560148E+00, 1.7408494553E+01, 3.6032239791E+00, 9.6971532103E-01],
	[4.1095000000E+04, 3.5583394855E+01, 5.2089906388E+00, 1.7415414231E+01, 3.6036144455E+00, 9.6972841663E-01],
	[4.1100000000E+04, 3.5590954802E+01, 5.2090252588E+00, 1.7422335817E+01, 3.6040048146E+00, 9.6974150582E-01],
	[4.1105000000E+04, 3.5598515436E+01, 5.2090598748E+00, 1.7429259310E+01, 3.6043950864E+00, 9.6975458860E-01],
	[4.1110000000E+04, 3.5606076756E+01, 5.2090944869E+00, 1.7436184711E+01, 3.6047852610E+00, 9.6976766497E-01],
	[4.1115000000E+04, 3.5613638763E+01, 5.2091290950E+00, 1.7443112019E+01, 3.6051753384E+00, 9.6978073495E-01],
	[4.1120000000E+04, 3.5621201455E+01, 5.2091636991E+00, 1.7450041237E+01, 3.6055653186E+00, 9.6979379853E-01],
	[4.1125000000E+04, 3.5628764834E+01, 5.2091982992E+00, 1.7456972362E+01, 3.6059552016E+00, 9.6980685571E-01],
	[4.1130000000E+04, 3.5636328898E+01, 5.2092328953E+00, 1.7463905397E+01, 3.6063449874E+00, 9.6981990651E-01],
	[4.1135000000E+04, 3.5643893649E+01, 5.2092674875E+00, 1.7470840340E+01, 3.6067346761E+00, 9.6983295091E-01],
	[4.1140000000E+04, 3.5651459086E+01, 5.2093020757E+00, 1.7477777193E+01, 3.6071242677E+00, 9.6984598893E-01],
	[4.1145000000E+04, 3.5659025209E+01, 5.2093366599E+00, 1.7484715956E+01, 3.6075137622E+00, 9.6985902057E-01],
	[4.1150000000E+04, 3.5666592018E+01, 5.2093712402E+00, 1.7491656629E+01, 3.6079031596E+00, 9.6987204584E-01],
	[4.1155000000E+04, 3.5674159513E+01, 5.2094058165E+00, 1.7498599212E+01, 3.6082924599E+00, 9.6988506473E-01],
	[4.1160000000E+04, 3.5681727694E+01, 5.2094403888E+00, 1.7505543706E+01, 3.6086816632E+00, 9.6989807725E-01],
	[4.1165000000E+04, 3.5689305477E+01, 5.2094760633E+00, 1.7512490110E+01, 3.6090713916E+00, 9.6991108340E-01],
	[4.1170000000E+04, 3.5696892019E+01, 5.2095127348E+00, 1.7519438426E+01, 3.6094615862E+00, 9.6992408319E-01],
	[4.1175000000E+04, 3.5704479253E+01, 5.2095494021E+00, 1.7526388653E+01, 3.6098516841E+00, 9.6993707661E-01],
	[4.1180000000E+04, 3.5712067177E+01, 5.2095860653E+00, 1.7533340793E+01, 3.6102416853E+00, 9.6995006369E-01],
	[4.1185000000E+04, 3.5719655793E+01, 5.2096227242E+00, 1.7540294844E+01, 3.6106315899E+00, 9.6996304440E-01],
	[4.1190000000E+04, 3.5727245100E+01, 5.2096593789E+00, 1.7547250807E+01, 3.6110213979E+00, 9.6997601877E-01],
	[4.1195000000E+04, 3.5734835098E+01, 5.2096960295E+00, 1.7554208684E+01, 3.6114111092E+00, 9.6998898679E-01],
	[4.1200000000E+04, 3.5742425786E+01, 5.2097326759E+00, 1.7561168473E+01, 3.6118007239E+00, 9.7000194846E-01],
	[4.1205000000E+04, 3.5750017166E+01, 5.2097693181E+00, 1.7568130175E+01, 3.6121902420E+00, 9.7001490379E-01],
	[4.1210000000E+04, 3.5757609237E+01, 5.2098059561E+00, 1.7575093791E+01, 3.6125796636E+00, 9.7002785279E-01],
	[4.1215000000E+04, 3.5765201998E+01, 5.2098425899E+00, 1.7582059321E+01, 3.6129689887E+00, 9.7004079545E-01],
	[4.1220000000E+04, 3.5772795450E+01, 5.2098792195E+00, 1.7589026765E+01, 3.6133582172E+00, 9.7005373179E-01],
	[4.1225000000E+04, 3.5780389594E+01, 5.2099158449E+00, 1.7595996124E+01, 3.6137473492E+00, 9.7006666179E-01],
	[4.1230000000E+04, 3.5787984428E+01, 5.2099524662E+00, 1.7602967397E+01, 3.6141363848E+00, 9.7007958547E-01],
	[4.1235000000E+04, 3.5795579953E+01, 5.2099890832E+00, 1.7609940585E+01, 3.6145253239E+00, 9.7009250283E-01],
	[4.1240000000E+04, 3.5803176168E+01, 5.2100256961E+00, 1.7616915689E+01, 3.6149141666E+00, 9.7010541388E-01],
	[4.1245000000E+04, 3.5810773075E+01, 5.2100623048E+00, 1.7623892708E+01, 3.6153029128E+00, 9.7011831861E-01],
	[4.1250000000E+04, 3.5818370672E+01, 5.2100989093E+00, 1.7630871643E+01, 3.6156915626E+00, 9.7013121703E-01],
	[4.1255000000E+04, 3.5825968960E+01, 5.2101355097E+00, 1.7637852494E+01, 3.6160801161E+00, 9.7014410914E-01],
	[4.1260000000E+04, 3.5833567939E+01, 5.2101721058E+00, 1.7644835261E+01, 3.6164685732E+00, 9.7015699495E-01],
	[4.1265000000E+04, 3.5841167608E+01, 5.2102086978E+00, 1.7651819946E+01, 3.6168569340E+00, 9.7016987446E-01],
	[4.1270000000E+04, 3.5848767969E+01, 5.2102452856E+00, 1.7658806547E+01, 3.6172451985E+00, 9.7018274767E-01],
	[4.1275000000E+04, 3.5856369019E+01, 5.2102818693E+00, 1.7665795066E+01, 3.6176333666E+00, 9.7019561458E-01],
	[4.1280000000E+04, 3.5863970761E+01, 5.2103184487E+00, 1.7672785503E+01, 3.6180214385E+00, 9.7020847521E-01],
	[4.1285000000E+04, 3.5871573193E+01, 5.2103550240E+00, 1.7679777857E+01, 3.6184094141E+00, 9.7022132955E-01],
	[4.1290000000E+04, 3.5879176316E+01, 5.2103915951E+00, 1.7686772130E+01, 3.6187972935E+00, 9.7023417760E-01],
	[4.1295000000E+04, 3.5886780129E+01, 5.2104281620E+00, 1.7693768321E+01, 3.6191850767E+00, 9.7024701938E-01],
	[4.1300000000E+04, 3.5894384633E+01, 5.2104647248E+00, 1.7700766431E+01, 3.6195727637E+00, 9.7025985487E-01],
	[4.1305000000E+04, 3.5901989827E+01, 5.2105012834E+00, 1.7707766460E+01, 3.6199603545E+00, 9.7027268410E-01],
	[4.1310000000E+04, 3.5909595712E+01, 5.2105378378E+00, 1.7714768409E+01, 3.6203478492E+00, 9.7028550705E-01],
	[4.1315000000E+04, 3.5917202287E+01, 5.2105743881E+00, 1.7721772277E+01, 3.6207352477E+00, 9.7029832373E-01],
	[4.1320000000E+04, 3.5924809553E+01, 5.2106109342E+00, 1.7728778066E+01, 3.6211225501E+00, 9.7031113415E-01],
	[4.1325000000E+04, 3.5932417509E+01, 5.2106474761E+00, 1.7735785774E+01, 3.6215097564E+00, 9.7032393831E-01],
	[4.1330000000E+04, 3.5940026156E+01, 5.2106840139E+00, 1.7742795403E+01, 3.6218968666E+00, 9.7033673622E-01],
	[4.1335000000E+04, 3.5947635493E+01, 5.2107205475E+00, 1.7749806954E+01, 3.6222838808E+00, 9.7034952787E-01],
	[4.1340000000E+04, 3.5955245521E+01, 5.2107570769E+00, 1.7756820425E+01, 3.6226707990E+00, 9.7036231326E-01],
	[4.1345000000E+04, 3.5962856238E+01, 5.2107936022E+00, 1.7763835818E+01, 3.6230576211E+00, 9.7037509241E-01],
	[4.1350000000E+04, 3.5970467647E+01, 5.2108301233E+00, 1.7770853132E+01, 3.6234443472E+00, 9.7038786532E-01],
	[4.1355000000E+04, 3.5978079745E+01, 5.2108666403E+00, 1.7777872369E+01, 3.6238309774E+00, 9.7040063199E-01],
	[4.1360000000E+04, 3.5985692534E+01, 5.2109031531E+00, 1.7784893527E+01, 3.6242175116E+00, 9.7041339242E-01],
	[4.1365000000E+04, 3.5993306013E+01, 5.2109396617E+00, 1.7791916609E+01, 3.6246039499E+00, 9.7042614661E-01],
	[4.1370000000E+04, 3.6000920183E+01, 5.2109761662E+00, 1.7798941613E+01, 3.6249902923E+00, 9.7043889457E-01],
	[4.1375000000E+04, 3.6008535042E+01, 5.2110126665E+00, 1.7805968541E+01, 3.6253765388E+00, 9.7045163631E-01],
	[4.1380000000E+04, 3.6016150592E+01, 5.2110491627E+00, 1.7812997392E+01, 3.6257626894E+00, 9.7046437182E-01],
	[4.1385000000E+04, 3.6023766832E+01, 5.2110856547E+00, 1.7820028167E+01, 3.6261487442E+00, 9.7047710111E-01],
	[4.1390000000E+04, 3.6031383762E+01, 5.2111221426E+00, 1.7827060867E+01, 3.6265347031E+00, 9.7048982418E-01],
	[4.1395000000E+04, 3.6039001383E+01, 5.2111586263E+00, 1.7834095490E+01, 3.6269205662E+00, 9.7050254104E-01],
	[4.1400000000E+04, 3.6046619693E+01, 5.2111951059E+00, 1.7841132039E+01, 3.6273063335E+00, 9.7051525169E-01],
	[4.1405000000E+04, 3.6054238694E+01, 5.2112315813E+00, 1.7848170512E+01, 3.6276920051E+00, 9.7052795613E-01],
	[4.1410000000E+04, 3.6061858385E+01, 5.2112680525E+00, 1.7855210910E+01, 3.6280775809E+00, 9.7054065436E-01],
	[4.1415000000E+04, 3.6069478765E+01, 5.2113045197E+00, 1.7862253234E+01, 3.6284630610E+00, 9.7055334640E-01],
	[4.1420000000E+04, 3.6077099836E+01, 5.2113409826E+00, 1.7869297484E+01, 3.6288484453E+00, 9.7056603223E-01],
	[4.1425000000E+04, 3.6084721597E+01, 5.2113774414E+00, 1.7876343661E+01, 3.6292337340E+00, 9.7057871187E-01],
	[4.1430000000E+04, 3.6092344048E+01, 5.2114138961E+00, 1.7883391763E+01, 3.6296189270E+00, 9.7059138532E-01],
	[4.1435000000E+04, 3.6099967189E+01, 5.2114503467E+00, 1.7890441793E+01, 3.6300040244E+00, 9.7060405259E-01],
	[4.1440000000E+04, 3.6107591020E+01, 5.2114867930E+00, 1.7897493749E+01, 3.6303890261E+00, 9.7061671366E-01],
	[4.1445000000E+04, 3.6115215541E+01, 5.2115232353E+00, 1.7904547633E+01, 3.6307739323E+00, 9.7062936856E-01],
	[4.1450000000E+04, 3.6122840752E+01, 5.2115596734E+00, 1.7911603444E+01, 3.6311587428E+00, 9.7064201728E-01],
	[4.1455000000E+04, 3.6130466652E+01, 5.2115961074E+00, 1.7918661184E+01, 3.6315434578E+00, 9.7065465982E-01],
	[4.1460000000E+04, 3.6138093243E+01, 5.2116325372E+00, 1.7925720851E+01, 3.6319280772E+00, 9.7066729619E-01],
	[4.1465000000E+04, 3.6145720523E+01, 5.2116689629E+00, 1.7932782447E+01, 3.6323126011E+00, 9.7067992640E-01],
	[4.1470000000E+04, 3.6153348494E+01, 5.2117053844E+00, 1.7939845972E+01, 3.6326970295E+00, 9.7069255044E-01],
	[4.1475000000E+04, 3.6160977154E+01, 5.2117418018E+00, 1.7946911426E+01, 3.6330813624E+00, 9.7070516831E-01],
	[4.1480000000E+04, 3.6168606504E+01, 5.2117782151E+00, 1.7953978810E+01, 3.6334655998E+00, 9.7071778003E-01],
	[4.1485000000E+04, 3.6176236543E+01, 5.2118146242E+00, 1.7961048123E+01, 3.6338497418E+00, 9.7073038560E-01],
	[4.1490000000E+04, 3.6183867273E+01, 5.2118510292E+00, 1.7968119366E+01, 3.6342337884E+00, 9.7074298501E-01],
	[4.1495000000E+04, 3.6191498692E+01, 5.2118874301E+00, 1.7975192539E+01, 3.6346177396E+00, 9.7075557827E-01],
	[4.1500000000E+04, 3.6199130801E+01, 5.2119238269E+00, 1.7982267643E+01, 3.6350015954E+00, 9.7076816539E-01],
	[4.1505000000E+04, 3.6206763600E+01, 5.2119602195E+00, 1.7989344678E+01, 3.6353853558E+00, 9.7078074637E-01],
	[4.1510000000E+04, 3.6214397088E+01, 5.2119966080E+00, 1.7996423644E+01, 3.6357690209E+00, 9.7079332120E-01],
	[4.1515000000E+04, 3.6222031266E+01, 5.2120329923E+00, 1.8003504541E+01, 3.6361525906E+00, 9.7080588991E-01],
	[4.1520000000E+04, 3.6229666134E+01, 5.2120693725E+00, 1.8010587371E+01, 3.6365360651E+00, 9.7081845248E-01],
	[4.1525000000E+04, 3.6237301691E+01, 5.2121057486E+00, 1.8017672132E+01, 3.6369194442E+00, 9.7083100892E-01],
	[4.1530000000E+04, 3.6244937938E+01, 5.2121421206E+00, 1.8024758825E+01, 3.6373027281E+00, 9.7084355923E-01],
	[4.1535000000E+04, 3.6252574874E+01, 5.2121784885E+00, 1.8031847452E+01, 3.6376859168E+00, 9.7085610343E-01],
	[4.1540000000E+04, 3.6260212500E+01, 5.2122148522E+00, 1.8038938011E+01, 3.6380690103E+00, 9.7086864150E-01],
	[4.1545000000E+04, 3.6267850816E+01, 5.2122512118E+00, 1.8046030503E+01, 3.6384520085E+00, 9.7088117346E-01],
	[4.1550000000E+04, 3.6275489821E+01, 5.2122875673E+00, 1.8053124929E+01, 3.6388349116E+00, 9.7089369931E-01],
	[4.1555000000E+04, 3.6283129515E+01, 5.2123239186E+00, 1.8060221289E+01, 3.6392177195E+00, 9.7090621904E-01],
	[4.1560000000E+04, 3.6290769899E+01, 5.2123602659E+00, 1.8067319582E+01, 3.6396004322E+00, 9.7091873267E-01],
	[4.1565000000E+04, 3.6298410973E+01, 5.2123966090E+00, 1.8074419810E+01, 3.6399830499E+00, 9.7093124020E-01],
	[4.1570000000E+04, 3.6306052736E+01, 5.2124329480E+00, 1.8081521973E+01, 3.6403655724E+00, 9.7094374163E-01],
	[4.1575000000E+04, 3.6313695188E+01, 5.2124692829E+00, 1.8088626071E+01, 3.6407479999E+00, 9.7095623697E-01],
	[4.1580000000E+04, 3.6321338330E+01, 5.2125056136E+00, 1.8095732104E+01, 3.6411303323E+00, 9.7096872621E-01],
	[4.1585000000E+04, 3.6328982161E+01, 5.2125419403E+00, 1.8102840073E+01, 3.6415125697E+00, 9.7098120936E-01],
	[4.1590000000E+04, 3.6336626681E+01, 5.2125782628E+00, 1.8109949977E+01, 3.6418947120E+00, 9.7099368642E-01],
	[4.1595000000E+04, 3.6344271891E+01, 5.2126145812E+00, 1.8117061818E+01, 3.6422767594E+00, 9.7100615740E-01],
	[4.1600000000E+04, 3.6351917790E+01, 5.2126508955E+00, 1.8124175595E+01, 3.6426587117E+00, 9.7101862230E-01],
	[4.1605000000E+04, 3.6359564378E+01, 5.2126872057E+00, 1.8131291309E+01, 3.6430405692E+00, 9.7103108113E-01],
	[4.1610000000E+04, 3.6367211656E+01, 5.2127235118E+00, 1.8138408960E+01, 3.6434223316E+00, 9.7104353388E-01],
	[4.1615000000E+04, 3.6374859623E+01, 5.2127598138E+00, 1.8145528548E+01, 3.6438039992E+00, 9.7105598056E-01],
	[4.1620000000E+04, 3.6382508279E+01, 5.2127961117E+00, 1.8152650074E+01, 3.6441855719E+00, 9.7106842118E-01],
	[4.1625000000E+04, 3.6390157624E+01, 5.2128324054E+00, 1.8159773538E+01, 3.6445670497E+00, 9.7108085573E-01],
	[4.1630000000E+04, 3.6397807659E+01, 5.2128686951E+00, 1.8166898940E+01, 3.6449484326E+00, 9.7109328422E-01],
	[4.1635000000E+04, 3.6405458382E+01, 5.2129049806E+00, 1.8174026280E+01, 3.6453297208E+00, 9.7110570666E-01],
	[4.1640000000E+04, 3.6413109795E+01, 5.2129412621E+00, 1.8181155560E+01, 3.6457109141E+00, 9.7111812304E-01],
	[4.1645000000E+04, 3.6420761897E+01, 5.2129775394E+00, 1.8188286778E+01, 3.6460920126E+00, 9.7113053337E-01],
	[4.1650000000E+04, 3.6428414688E+01, 5.2130138127E+00, 1.8195419936E+01, 3.6464730163E+00, 9.7114293765E-01],
	[4.1655000000E+04, 3.6436068168E+01, 5.2130500818E+00, 1.8202555034E+01, 3.6468539253E+00, 9.7115533589E-01],
	[4.1660000000E+04, 3.6443722337E+01, 5.2130863468E+00, 1.8209692071E+01, 3.6472347395E+00, 9.7116772809E-01],
	[4.1665000000E+04, 3.6451377195E+01, 5.2131226078E+00, 1.8216831049E+01, 3.6476154591E+00, 9.7118011425E-01],
	[4.1670000000E+04, 3.6459032742E+01, 5.2131588646E+00, 1.8223971967E+01, 3.6479960839E+00, 9.7119249437E-01],
	[4.1675000000E+04, 3.6466688979E+01, 5.2131951174E+00, 1.8231114826E+01, 3.6483766141E+00, 9.7120486847E-01],
	[4.1680000000E+04, 3.6474345904E+01, 5.2132313660E+00, 1.8238259627E+01, 3.6487570496E+00, 9.7121723654E-01],
	[4.1685000000E+04, 3.6482003518E+01, 5.2132676105E+00, 1.8245406368E+01, 3.6491373905E+00, 9.7122959858E-01],
	[4.1690000000E+04, 3.6489661821E+01, 5.2133038510E+00, 1.8252555052E+01, 3.6495176368E+00, 9.7124195460E-01],
	[4.1695000000E+04, 3.6497320813E+01, 5.2133400874E+00, 1.8259705678E+01, 3.6498977885E+00, 9.7125430461E-01],
	[4.1700000000E+04, 3.6504980494E+01, 5.2133763196E+00, 1.8266858246E+01, 3.6502778457E+00, 9.7126664860E-01],
	[4.1705000000E+04, 3.6512640863E+01, 5.2134125478E+00, 1.8274012756E+01, 3.6506578083E+00, 9.7127898658E-01],
	[4.1710000000E+04, 3.6520301922E+01, 5.2134487719E+00, 1.8281169210E+01, 3.6510376763E+00, 9.7129131855E-01],
	[4.1715000000E+04, 3.6527963669E+01, 5.2134849919E+00, 1.8288327606E+01, 3.6514174499E+00, 9.7130364451E-01],
	[4.1720000000E+04, 3.6535626106E+01, 5.2135212078E+00, 1.8295487946E+01, 3.6517971289E+00, 9.7131596447E-01],
	[4.1725000000E+04, 3.6543289231E+01, 5.2135574196E+00, 1.8302650231E+01, 3.6521767135E+00, 9.7132827844E-01],
	[4.1730000000E+04, 3.6550953044E+01, 5.2135936273E+00, 1.8309814459E+01, 3.6525562037E+00, 9.7134058641E-01],
	[4.1735000000E+04, 3.6558617547E+01, 5.2136298309E+00, 1.8316980631E+01, 3.6529355994E+00, 9.7135288838E-01],
	[4.1740000000E+04, 3.6566282738E+01, 5.2136660305E+00, 1.8324148748E+01, 3.6533149008E+00, 9.7136518437E-01],
	[4.1745000000E+04, 3.6573948618E+01, 5.2137022259E+00, 1.8331318810E+01, 3.6536941077E+00, 9.7137747437E-01],
	[4.1750000000E+04, 3.6581615187E+01, 5.2137384173E+00, 1.8338490818E+01, 3.6540732203E+00, 9.7138975839E-01],
	[4.1755000000E+04, 3.6589282444E+01, 5.2137746046E+00, 1.8345664771E+01, 3.6544522385E+00, 9.7140203643E-01],
	[4.1760000000E+04, 3.6596950390E+01, 5.2138107878E+00, 1.8352840670E+01, 3.6548311625E+00, 9.7141430850E-01],
	[4.1765000000E+04, 3.6604619025E+01, 5.2138469670E+00, 1.8360018515E+01, 3.6552099921E+00, 9.7142657459E-01],
	[4.1770000000E+04, 3.6612288348E+01, 5.2138831420E+00, 1.8367198306E+01, 3.6555887274E+00, 9.7143883471E-01],
	[4.1775000000E+04, 3.6619958360E+01, 5.2139193130E+00, 1.8374380045E+01, 3.6559673685E+00, 9.7145108887E-01],
	[4.1780000000E+04, 3.6627629060E+01, 5.2139554799E+00, 1.8381563730E+01, 3.6563459153E+00, 9.7146333706E-01],
	[4.1785000000E+04, 3.6635300449E+01, 5.2139916427E+00, 1.8388749362E+01, 3.6567243680E+00, 9.7147557930E-01],
	[4.1790000000E+04, 3.6642972527E+01, 5.2140278015E+00, 1.8395936943E+01, 3.6571027264E+00, 9.7148781557E-01],
	[4.1795000000E+04, 3.6650645293E+01, 5.2140639561E+00, 1.8403126471E+01, 3.6574809906E+00, 9.7150004590E-01],
	[4.1800000000E+04, 3.6658318747E+01, 5.2141001067E+00, 1.8410317947E+01, 3.6578591607E+00, 9.7151227027E-01],
	[4.1805000000E+04, 3.6665992890E+01, 5.2141362533E+00, 1.8417511372E+01, 3.6582372366E+00, 9.7152448869E-01],
	[4.1810000000E+04, 3.6673667721E+01, 5.2141723957E+00, 1.8424706746E+01, 3.6586152185E+00, 9.7153670118E-01],
	[4.1815000000E+04, 3.6681343241E+01, 5.2142085341E+00, 1.8431904069E+01, 3.6589931062E+00, 9.7154890772E-01],
	[4.1820000000E+04, 3.6689019449E+01, 5.2142446684E+00, 1.8439103341E+01, 3.6593708999E+00, 9.7156110832E-01],
	[4.1825000000E+04, 3.6696696346E+01, 5.2142807986E+00, 1.8446304563E+01, 3.6597485995E+00, 9.7157330299E-01],
	[4.1830000000E+04, 3.6704390692E+01, 5.2143189729E+00, 1.8453507735E+01, 3.6601273808E+00, 9.7158549173E-01],
	[4.1835000000E+04, 3.6712085846E+01, 5.2143571567E+00, 1.8460712857E+01, 3.6605060764E+00, 9.7159767455E-01],
	[4.1840000000E+04, 3.6719781693E+01, 5.2143953363E+00, 1.8467919930E+01, 3.6608846783E+00, 9.7160985143E-01],
	[4.1845000000E+04, 3.6727478233E+01, 5.2144335116E+00, 1.8475128953E+01, 3.6612631864E+00, 9.7162202240E-01],
	[4.1850000000E+04, 3.6735175467E+01, 5.2144716826E+00, 1.8482339928E+01, 3.6616416009E+00, 9.7163418745E-01],
	[4.1855000000E+04, 3.6742873394E+01, 5.2145098494E+00, 1.8489552854E+01, 3.6620199217E+00, 9.7164634658E-01],
	[4.1860000000E+04, 3.6750572014E+01, 5.2145480118E+00, 1.8496767732E+01, 3.6623981488E+00, 9.7165849980E-01],
	[4.1865000000E+04, 3.6758271328E+01, 5.2145861700E+00, 1.8503984562E+01, 3.6627762823E+00, 9.7167064712E-01],
	[4.1870000000E+04, 3.6765971335E+01, 5.2146243239E+00, 1.8511203345E+01, 3.6631543222E+00, 9.7168278852E-01],
	[4.1875000000E+04, 3.6773672035E+01, 5.2146624735E+00, 1.8518424080E+01, 3.6635322685E+00, 9.7169492403E-01],
	[4.1880000000E+04, 3.6781373428E+01, 5.2147006188E+00, 1.8525646768E+01, 3.6639101213E+00, 9.7170705364E-01],
	[4.1885000000E+04, 3.6789075514E+01, 5.2147387599E+00, 1.8532871409E+01, 3.6642878805E+00, 9.7171917735E-01],
	[4.1890000000E+04, 3.6796778294E+01, 5.2147768967E+00, 1.8540098003E+01, 3.6646655461E+00, 9.7173129517E-01],
	[4.1895000000E+04, 3.6804481767E+01, 5.2148150292E+00, 1.8547326552E+01, 3.6650431183E+00, 9.7174340710E-01],
	[4.1900000000E+04, 3.6812185933E+01, 5.2148531575E+00, 1.8554557055E+01, 3.6654205970E+00, 9.7175551314E-01],
	[4.1905000000E+04, 3.6819890791E+01, 5.2148912814E+00, 1.8561789512E+01, 3.6657979822E+00, 9.7176761330E-01],
	[4.1910000000E+04, 3.6827596344E+01, 5.2149294012E+00, 1.8569023923E+01, 3.6661752740E+00, 9.7177970758E-01],
	[4.1915000000E+04, 3.6835302589E+01, 5.2149675166E+00, 1.8576260290E+01, 3.6665524723E+00, 9.7179179599E-01],
	[4.1920000000E+04, 3.6843009527E+01, 5.2150056278E+00, 1.8583498612E+01, 3.6669295773E+00, 9.7180387852E-01],
	[4.1925000000E+04, 3.6850717158E+01, 5.2150437347E+00, 1.8590738889E+01, 3.6673065888E+00, 9.7181595518E-01],
	[4.1930000000E+04, 3.6858425482E+01, 5.2150818373E+00, 1.8597981123E+01, 3.6676835070E+00, 9.7182802597E-01],
	[4.1935000000E+04, 3.6866134499E+01, 5.2151199357E+00, 1.8605225312E+01, 3.6680603318E+00, 9.7184009090E-01],
	[4.1940000000E+04, 3.6873844209E+01, 5.2151580298E+00, 1.8612471459E+01, 3.6684370634E+00, 9.7185214998E-01],
	[4.1945000000E+04, 3.6881554613E+01, 5.2151961196E+00, 1.8619719561E+01, 3.6688137016E+00, 9.7186420319E-01],
	[4.1950000000E+04, 3.6889265709E+01, 5.2152342052E+00, 1.8626969621E+01, 3.6691902465E+00, 9.7187625055E-01],
	[4.1955000000E+04, 3.6896977497E+01, 5.2152722865E+00, 1.8634221639E+01, 3.6695666982E+00, 9.7188829205E-01],
	[4.1960000000E+04, 3.6904689979E+01, 5.2153103636E+00, 1.8641475613E+01, 3.6699430567E+00, 9.7190032771E-01],
	[4.1965000000E+04, 3.6912403154E+01, 5.2153484364E+00, 1.8648731546E+01, 3.6703193219E+00, 9.7191235753E-01],
	[4.1970000000E+04, 3.6920117021E+01, 5.2153865050E+00, 1.8655989437E+01, 3.6706954939E+00, 9.7192438150E-01],
	[4.1975000000E+04, 3.6927831582E+01, 5.2154245693E+00, 1.8663249287E+01, 3.6710715727E+00, 9.7193639964E-01],
	[4.1980000000E+04, 3.6935546835E+01, 5.2154626293E+00, 1.8670511095E+01, 3.6714475584E+00, 9.7194841194E-01],
	[4.1985000000E+04, 3.6943262780E+01, 5.2155006851E+00, 1.8677774863E+01, 3.6718234510E+00, 9.7196041841E-01],
	[4.1990000000E+04, 3.6950979419E+01, 5.2155387366E+00, 1.8685040590E+01, 3.6721992504E+00, 9.7197241905E-01],
	[4.1995000000E+04, 3.6958696750E+01, 5.2155767839E+00, 1.8692308276E+01, 3.6725749567E+00, 9.7198441386E-01],
	[4.2000000000E+04, 3.6966414774E+01, 5.2156148269E+00, 1.8699577923E+01, 3.6729505699E+00, 9.7199640286E-01],
	[4.2005000000E+04, 3.6974133491E+01, 5.2156528656E+00, 1.8706849530E+01, 3.6733260901E+00, 9.7200838603E-01],
	[4.2010000000E+04, 3.6981852901E+01, 5.2156909002E+00, 1.8714123097E+01, 3.6737015173E+00, 9.7202036339E-01],
	[4.2015000000E+04, 3.6989573003E+01, 5.2157289304E+00, 1.8721398626E+01, 3.6740768514E+00, 9.7203233493E-01],
	[4.2020000000E+04, 3.6997293798E+01, 5.2157669564E+00, 1.8728676115E+01, 3.6744520926E+00, 9.7204430066E-01],
	[4.2025000000E+04, 3.7005015285E+01, 5.2158049782E+00, 1.8735955566E+01, 3.6748272407E+00, 9.7205626059E-01],
	[4.2030000000E+04, 3.7012737465E+01, 5.2158429957E+00, 1.8743236979E+01, 3.6752022960E+00, 9.7206821472E-01],
	[4.2035000000E+04, 3.7020460337E+01, 5.2158810090E+00, 1.8750520354E+01, 3.6755772582E+00, 9.7208016304E-01],
	[4.2040000000E+04, 3.7028183902E+01, 5.2159190181E+00, 1.8757805691E+01, 3.6759521276E+00, 9.7209210557E-01],
	[4.2045000000E+04, 3.7035908160E+01, 5.2159570229E+00, 1.8765092991E+01, 3.6763269041E+00, 9.7210404230E-01],
	[4.2050000000E+04, 3.7043633110E+01, 5.2159950234E+00, 1.8772382254E+01, 3.6767015877E+00, 9.7211597325E-01],
	[4.2055000000E+04, 3.7051358753E+01, 5.2160330197E+00, 1.8779673480E+01, 3.6770761784E+00, 9.7212789840E-01],
	[4.2060000000E+04, 3.7059085088E+01, 5.2160710118E+00, 1.8786966670E+01, 3.6774506763E+00, 9.7213981777E-01],
	[4.2065000000E+04, 3.7066812115E+01, 5.2161089996E+00, 1.8794261823E+01, 3.6778250814E+00, 9.7215173136E-01],
	[4.2070000000E+04, 3.7074539835E+01, 5.2161469832E+00, 1.8801558941E+01, 3.6781993938E+00, 9.7216363917E-01],
	[4.2075000000E+04, 3.7082268248E+01, 5.2161849625E+00, 1.8808858023E+01, 3.6785736133E+00, 9.7217554121E-01],
	[4.2080000000E+04, 3.7089997353E+01, 5.2162229377E+00, 1.8816159070E+01, 3.6789477401E+00, 9.7218743747E-01],
	[4.2085000000E+04, 3.7097727150E+01, 5.2162609085E+00, 1.8823462081E+01, 3.6793217742E+00, 9.7219932797E-01],
	[4.2090000000E+04, 3.7105457639E+01, 5.2162988752E+00, 1.8830767058E+01, 3.6796957155E+00, 9.7221121270E-01],
	[4.2095000000E+04, 3.7113188821E+01, 5.2163368376E+00, 1.8838074001E+01, 3.6800695642E+00, 9.7222309167E-01],
	[4.2100000000E+04, 3.7120920695E+01, 5.2163747958E+00, 1.8845382910E+01, 3.6804433202E+00, 9.7223496488E-01],
	[4.2105000000E+04, 3.7128653262E+01, 5.2164127497E+00, 1.8852693784E+01, 3.6808169835E+00, 9.7224683233E-01],
	[4.2110000000E+04, 3.7136386520E+01, 5.2164506994E+00, 1.8860006626E+01, 3.6811905543E+00, 9.7225869403E-01],
	[4.2115000000E+04, 3.7144120471E+01, 5.2164886449E+00, 1.8867321434E+01, 3.6815640324E+00, 9.7227054998E-01],
	[4.2120000000E+04, 3.7151855115E+01, 5.2165265862E+00, 1.8874638209E+01, 3.6819374179E+00, 9.7228240019E-01],
	[4.2125000000E+04, 3.7159590450E+01, 5.2165645232E+00, 1.8881956951E+01, 3.6823107109E+00, 9.7229424465E-01],
	[4.2130000000E+04, 3.7167326478E+01, 5.2166024560E+00, 1.8889277661E+01, 3.6826839113E+00, 9.7230608337E-01],
	[4.2135000000E+04, 3.7175063197E+01, 5.2166403846E+00, 1.8896600339E+01, 3.6830570192E+00, 9.7231791635E-01],
	[4.2140000000E+04, 3.7182800609E+01, 5.2166783090E+00, 1.8903924986E+01, 3.6834300346E+00, 9.7232974360E-01],
	[4.2145000000E+04, 3.7190538713E+01, 5.2167162291E+00, 1.8911251601E+01, 3.6838029576E+00, 9.7234156512E-01],
	[4.2150000000E+04, 3.7198277509E+01, 5.2167541450E+00, 1.8918580184E+01, 3.6841757880E+00, 9.7235338091E-01],
	[4.2155000000E+04, 3.7206016998E+01, 5.2167920567E+00, 1.8925910737E+01, 3.6845485260E+00, 9.7236519098E-01],
	[4.2160000000E+04, 3.7213757178E+01, 5.2168299641E+00, 1.8933243260E+01, 3.6849211716E+00, 9.7237699532E-01],
	[4.2165000000E+04, 3.7221498050E+01, 5.2168678674E+00, 1.8940577752E+01, 3.6852937248E+00, 9.7238879395E-01],
	[4.2170000000E+04, 3.7229239615E+01, 5.2169057664E+00, 1.8947914214E+01, 3.6856661856E+00, 9.7240058686E-01],
	[4.2175000000E+04, 3.7236981871E+01, 5.2169436612E+00, 1.8955252646E+01, 3.6860385541E+00, 9.7241237406E-01],
	[4.2180000000E+04, 3.7244724820E+01, 5.2169815518E+00, 1.8962593049E+01, 3.6864108302E+00, 9.7242415555E-01],
	[4.2185000000E+04, 3.7252468460E+01, 5.2170194382E+00, 1.8969935423E+01, 3.6867830140E+00, 9.7243593133E-01],
	[4.2190000000E+04, 3.7260212792E+01, 5.2170573203E+00, 1.8977279768E+01, 3.6871551055E+00, 9.7244770141E-01],
	[4.2195000000E+04, 3.7267957817E+01, 5.2170951983E+00, 1.8984626085E+01, 3.6875271047E+00, 9.7245946580E-01],
	[4.2200000000E+04, 3.7275703533E+01, 5.2171330720E+00, 1.8991974373E+01, 3.6878990116E+00, 9.7247122448E-01],
	[4.2205000000E+04, 3.7283449941E+01, 5.2171709415E+00, 1.8999324634E+01, 3.6882708264E+00, 9.7248297747E-01],
	[4.2210000000E+04, 3.7291197041E+01, 5.2172088069E+00, 1.9006676867E+01, 3.6886425489E+00, 9.7249472478E-01],
	[4.2215000000E+04, 3.7298944832E+01, 5.2172466679E+00, 1.9014031072E+01, 3.6890141792E+00, 9.7250646639E-01],
	[4.2220000000E+04, 3.7306693316E+01, 5.2172845248E+00, 1.9021387251E+01, 3.6893857173E+00, 9.7251820232E-01],
	[4.2225000000E+04, 3.7314442491E+01, 5.2173223775E+00, 1.9028745403E+01, 3.6897571633E+00, 9.7252993257E-01],
	[4.2230000000E+04, 3.7322192358E+01, 5.2173602260E+00, 1.9036105528E+01, 3.6901285171E+00, 9.7254165715E-01],
	[4.2235000000E+04, 3.7329942917E+01, 5.2173980703E+00, 1.9043467628E+01, 3.6904997789E+00, 9.7255337604E-01],
	[4.2240000000E+04, 3.7337694168E+01, 5.2174359103E+00, 1.9050831701E+01, 3.6908709485E+00, 9.7256508927E-01],
	[4.2245000000E+04, 3.7345446110E+01, 5.2174737462E+00, 1.9058197749E+01, 3.6912420261E+00, 9.7257679683E-01],
	[4.2250000000E+04, 3.7353198745E+01, 5.2175115778E+00, 1.9065565772E+01, 3.6916130116E+00, 9.7258849872E-01],
	[4.2255000000E+04, 3.7360952070E+01, 5.2175494053E+00, 1.9072935769E+01, 3.6919839051E+00, 9.7260019495E-01],
	[4.2260000000E+04, 3.7368706088E+01, 5.2175872285E+00, 1.9080307742E+01, 3.6923547066E+00, 9.7261188552E-01],
	[4.2265000000E+04, 3.7376460797E+01, 5.2176250476E+00, 1.9087681691E+01, 3.6927254161E+00, 9.7262357044E-01],
	[4.2270000000E+04, 3.7384216198E+01, 5.2176628624E+00, 1.9095057616E+01, 3.6930960336E+00, 9.7263524970E-01],
	[4.2275000000E+04, 3.7391972290E+01, 5.2177006731E+00, 1.9102435516E+01, 3.6934665592E+00, 9.7264692332E-01],
	[4.2280000000E+04, 3.7399729074E+01, 5.2177384795E+00, 1.9109815394E+01, 3.6938369928E+00, 9.7265859128E-01],
	[4.2285000000E+04, 3.7407486549E+01, 5.2177762818E+00, 1.9117197248E+01, 3.6942073345E+00, 9.7267025361E-01],
	[4.2290000000E+04, 3.7415244716E+01, 5.2178140798E+00, 1.9124581079E+01, 3.6945775844E+00, 9.7268191029E-01],
	[4.2295000000E+04, 3.7423003575E+01, 5.2178518737E+00, 1.9131966888E+01, 3.6949477424E+00, 9.7269356133E-01],
	[4.2300000000E+04, 3.7430763125E+01, 5.2178896634E+00, 1.9139354674E+01, 3.6953178085E+00, 9.7270520674E-01],
	[4.2305000000E+04, 3.7438523367E+01, 5.2179274488E+00, 1.9146744438E+01, 3.6956877828E+00, 9.7271684652E-01],
	[4.2310000000E+04, 3.7446284300E+01, 5.2179652301E+00, 1.9154136181E+01, 3.6960576653E+00, 9.7272848068E-01],
	[4.2315000000E+04, 3.7454045924E+01, 5.2180030072E+00, 1.9161529902E+01, 3.6964274560E+00, 9.7274010920E-01],
	[4.2320000000E+04, 3.7461808240E+01, 5.2180407801E+00, 1.9168925602E+01, 3.6967971550E+00, 9.7275173211E-01],
	[4.2325000000E+04, 3.7469571247E+01, 5.2180785488E+00, 1.9176323282E+01, 3.6971667622E+00, 9.7276334940E-01],
	[4.2330000000E+04, 3.7477334946E+01, 5.2181163134E+00, 1.9183722941E+01, 3.6975362777E+00, 9.7277496107E-01],
	[4.2335000000E+04, 3.7485099336E+01, 5.2181540737E+00, 1.9191124579E+01, 3.6979057015E+00, 9.7278656713E-01],
	[4.2340000000E+04, 3.7492864417E+01, 5.2181918299E+00, 1.9198528198E+01, 3.6982750336E+00, 9.7279816758E-01],
	[4.2345000000E+04, 3.7500630190E+01, 5.2182295818E+00, 1.9205933797E+01, 3.6986442741E+00, 9.7280976242E-01],
	[4.2350000000E+04, 3.7508396654E+01, 5.2182673296E+00, 1.9213341376E+01, 3.6990134229E+00, 9.7282135166E-01],
	[4.2355000000E+04, 3.7516163809E+01, 5.2183050732E+00, 1.9220750937E+01, 3.6993824801E+00, 9.7283293530E-01],
	[4.2360000000E+04, 3.7523931656E+01, 5.2183428126E+00, 1.9228162479E+01, 3.6997514457E+00, 9.7284451334E-01],
	[4.2365000000E+04, 3.7531700194E+01, 5.2183805479E+00, 1.9235576002E+01, 3.7001203197E+00, 9.7285608579E-01],
	[4.2370000000E+04, 3.7539469423E+01, 5.2184182789E+00, 1.9242991507E+01, 3.7004891022E+00, 9.7286765265E-01],
	[4.2375000000E+04, 3.7547239343E+01, 5.2184560058E+00, 1.9250408994E+01, 3.7008577931E+00, 9.7287921391E-01],
	[4.2380000000E+04, 3.7555009954E+01, 5.2184937285E+00, 1.9257828464E+01, 3.7012263925E+00, 9.7289076960E-01],
	[4.2385000000E+04, 3.7562781257E+01, 5.2185314470E+00, 1.9265249917E+01, 3.7015949004E+00, 9.7290231970E-01],
	[4.2390000000E+04, 3.7570553250E+01, 5.2185691613E+00, 1.9272673352E+01, 3.7019633168E+00, 9.7291386423E-01],
	[4.2395000000E+04, 3.7578325935E+01, 5.2186068715E+00, 1.9280098771E+01, 3.7023316418E+00, 9.7292540318E-01],
	[4.2400000000E+04, 3.7586099311E+01, 5.2186445775E+00, 1.9287526173E+01, 3.7026998754E+00, 9.7293693655E-01],
	[4.2405000000E+04, 3.7593873378E+01, 5.2186822793E+00, 1.9294955560E+01, 3.7030680175E+00, 9.7294846436E-01],
	[4.2410000000E+04, 3.7601648136E+01, 5.2187199770E+00, 1.9302386930E+01, 3.7034360682E+00, 9.7295998660E-01],
	[4.2415000000E+04, 3.7609423585E+01, 5.2187576704E+00, 1.9309820285E+01, 3.7038040276E+00, 9.7297150328E-01],
	[4.2420000000E+04, 3.7617199726E+01, 5.2187953597E+00, 1.9317255625E+01, 3.7041718956E+00, 9.7298301440E-01],
	[4.2425000000E+04, 3.7624976557E+01, 5.2188330449E+00, 1.9324692950E+01, 3.7045396723E+00, 9.7299451996E-01],
	[4.2430000000E+04, 3.7632754079E+01, 5.2188707258E+00, 1.9332132260E+01, 3.7049073577E+00, 9.7300601996E-01],
	[4.2435000000E+04, 3.7640532292E+01, 5.2189084026E+00, 1.9339573556E+01, 3.7052749518E+00, 9.7301751442E-01],
	[4.2440000000E+04, 3.7648311196E+01, 5.2189460753E+00, 1.9347016838E+01, 3.7056424546E+00, 9.7302900332E-01],
	[4.2445000000E+04, 3.7656090791E+01, 5.2189837437E+00, 1.9354462106E+01, 3.7060098662E+00, 9.7304048669E-01],
	[4.2450000000E+04, 3.7663871077E+01, 5.2190214080E+00, 1.9361909361E+01, 3.7063771865E+00, 9.7305196451E-01],
	[4.2455000000E+04, 3.7671652053E+01, 5.2190590682E+00, 1.9369358602E+01, 3.7067444157E+00, 9.7306343679E-01],
	[4.2460000000E+04, 3.7679433721E+01, 5.2190967241E+00, 1.9376809831E+01, 3.7071115536E+00, 9.7307490354E-01],
	[4.2465000000E+04, 3.7687216079E+01, 5.2191343759E+00, 1.9384263047E+01, 3.7074786004E+00, 9.7308636475E-01],
	[4.2470000000E+04, 3.7694999129E+01, 5.2191720236E+00, 1.9391718251E+01, 3.7078455561E+00, 9.7309782043E-01],
	[4.2475000000E+04, 3.7702782869E+01, 5.2192096671E+00, 1.9399175443E+01, 3.7082124206E+00, 9.7310927059E-01],
	[4.2480000000E+04, 3.7710567300E+01, 5.2192473064E+00, 1.9406634624E+01, 3.7085791940E+00, 9.7312071523E-01],
	[4.2485000000E+04, 3.7718352421E+01, 5.2192849416E+00, 1.9414095792E+01, 3.7089458764E+00, 9.7313215434E-01],
	[4.2490000000E+04, 3.7726138234E+01, 5.2193225726E+00, 1.9421558950E+01, 3.7093124676E+00, 9.7314358794E-01],
	[4.2495000000E+04, 3.7733924737E+01, 5.2193601994E+00, 1.9429024097E+01, 3.7096789679E+00, 9.7315501602E-01],
	[4.2500000000E+04, 3.7741717428E+01, 5.2193984840E+00, 1.9436491234E+01, 3.7100457646E+00, 9.7316643859E-01],
	[4.2505000000E+04, 3.7749522074E+01, 5.2194381202E+00, 1.9443960360E+01, 3.7104132644E+00, 9.7317785565E-01],
	[4.2510000000E+04, 3.7757327415E+01, 5.2194777519E+00, 1.9451431477E+01, 3.7107806735E+00, 9.7318926721E-01],
	[4.2515000000E+04, 3.7765133452E+01, 5.2195173793E+00, 1.9458904584E+01, 3.7111479918E+00, 9.7320067327E-01],
	[4.2520000000E+04, 3.7772940185E+01, 5.2195570024E+00, 1.9466379682E+01, 3.7115152195E+00, 9.7321207382E-01],
	[4.2525000000E+04, 3.7780747613E+01, 5.2195966211E+00, 1.9473856770E+01, 3.7118823565E+00, 9.7322346888E-01],
	[4.2530000000E+04, 3.7788555737E+01, 5.2196362354E+00, 1.9481335850E+01, 3.7122494028E+00, 9.7323485845E-01],
	[4.2535000000E+04, 3.7796364556E+01, 5.2196758454E+00, 1.9488816922E+01, 3.7126163585E+00, 9.7324624253E-01],
	[4.2540000000E+04, 3.7804174071E+01, 5.2197154510E+00, 1.9496299985E+01, 3.7129832236E+00, 9.7325762112E-01],
	[4.2545000000E+04, 3.7811984281E+01, 5.2197550523E+00, 1.9503785041E+01, 3.7133499981E+00, 9.7326899423E-01],
	[4.2550000000E+04, 3.7819795187E+01, 5.2197946492E+00, 1.9511272089E+01, 3.7137166820E+00, 9.7328036185E-01],
	[4.2555000000E+04, 3.7827606788E+01, 5.2198342418E+00, 1.9518761130E+01, 3.7140832754E+00, 9.7329172400E-01],
	[4.2560000000E+04, 3.7835419085E+01, 5.2198738300E+00, 1.9526252164E+01, 3.7144497783E+00, 9.7330308068E-01],
	[4.2565000000E+04, 3.7843232077E+01, 5.2199134139E+00, 1.9533745191E+01, 3.7148161906E+00, 9.7331443188E-01],
	[4.2570000000E+04, 3.7851045764E+01, 5.2199529934E+00, 1.9541240212E+01, 3.7151825125E+00, 9.7332577761E-01],
	[4.2575000000E+04, 3.7858860147E+01, 5.2199925686E+00, 1.9548737227E+01, 3.7155487439E+00, 9.7333711788E-01],
	[4.2580000000E+04, 3.7866675225E+01, 5.2200321394E+00, 1.9556236236E+01, 3.7159148848E+00, 9.7334845268E-01],
	[4.2585000000E+04, 3.7874490998E+01, 5.2200717059E+00, 1.9563737239E+01, 3.7162809354E+00, 9.7335978202E-01],
	[4.2590000000E+04, 3.7882307467E+01, 5.2201112680E+00, 1.9571240238E+01, 3.7166468955E+00, 9.7337110591E-01],
	[4.2595000000E+04, 3.7890124631E+01, 5.2201508258E+00, 1.9578745232E+01, 3.7170127652E+00, 9.7338242433E-01],
	[4.2600000000E+04, 3.7897942490E+01, 5.2201903792E+00, 1.9586252221E+01, 3.7173785446E+00, 9.7339373730E-01],
	[4.2605000000E+04, 3.7905761045E+01, 5.2202299283E+00, 1.9593761205E+01, 3.7177442336E+00, 9.7340504482E-01],
	[4.2610000000E+04, 3.7913580294E+01, 5.2202694731E+00, 1.9601272186E+01, 3.7181098323E+00, 9.7341634689E-01],
	[4.2615000000E+04, 3.7921400239E+01, 5.2203090135E+00, 1.9608785163E+01, 3.7184753407E+00, 9.7342764351E-01],
	[4.2620000000E+04, 3.7929220879E+01, 5.2203485496E+00, 1.9616300137E+01, 3.7188407588E+00, 9.7343893469E-01],
	[4.2625000000E+04, 3.7937042214E+01, 5.2203880813E+00, 1.9623817108E+01, 3.7192060867E+00, 9.7345022043E-01],
	[4.2630000000E+04, 3.7944864245E+01, 5.2204276087E+00, 1.9631336076E+01, 3.7195713243E+00, 9.7346150074E-01],
	[4.2635000000E+04, 3.7952686970E+01, 5.2204671318E+00, 1.9638857041E+01, 3.7199364717E+00, 9.7347277560E-01],
	[4.2640000000E+04, 3.7960510390E+01, 5.2205066505E+00, 1.9646380004E+01, 3.7203015289E+00, 9.7348404503E-01],
	[4.2645000000E+04, 3.7968334506E+01, 5.2205461649E+00, 1.9653904966E+01, 3.7206664959E+00, 9.7349530904E-01],
	[4.2650000000E+04, 3.7976159317E+01, 5.2205856750E+00, 1.9661431925E+01, 3.7210313728E+00, 9.7350656761E-01],
	[4.2655000000E+04, 3.7983984822E+01, 5.2206251807E+00, 1.9668960884E+01, 3.7213961595E+00, 9.7351782076E-01],
	[4.2660000000E+04, 3.7991811023E+01, 5.2206646821E+00, 1.9676491841E+01, 3.7217608561E+00, 9.7352906849E-01],
	[4.2665000000E+04, 3.7999637919E+01, 5.2207041792E+00, 1.9684024798E+01, 3.7221254626E+00, 9.7354031079E-01],
	[4.2670000000E+04, 3.8007465510E+01, 5.2207436719E+00, 1.9691559754E+01, 3.7224899790E+00, 9.7355154768E-01],
	[4.2675000000E+04, 3.8015293795E+01, 5.2207831603E+00, 1.9699096710E+01, 3.7228544054E+00, 9.7356277916E-01],
	[4.2680000000E+04, 3.8023122776E+01, 5.2208226444E+00, 1.9706635666E+01, 3.7232187418E+00, 9.7357400522E-01],
	[4.2685000000E+04, 3.8030952452E+01, 5.2208621241E+00, 1.9714176623E+01, 3.7235829881E+00, 9.7358522587E-01],
	[4.2690000000E+04, 3.8038782822E+01, 5.2209015996E+00, 1.9721719581E+01, 3.7239471444E+00, 9.7359644112E-01],
	[4.2695000000E+04, 3.8046613887E+01, 5.2209410707E+00, 1.9729264539E+01, 3.7243112108E+00, 9.7360765096E-01],
	[4.2700000000E+04, 3.8054445647E+01, 5.2209805374E+00, 1.9736811499E+01, 3.7246751872E+00, 9.7361885541E-01],
	[4.2705000000E+04, 3.8062278102E+01, 5.2210199999E+00, 1.9744360461E+01, 3.7250390736E+00, 9.7363005445E-01],
	[4.2710000000E+04, 3.8070111252E+01, 5.2210594580E+00, 1.9751911424E+01, 3.7254028702E+00, 9.7364124810E-01],
	[4.2715000000E+04, 3.8077945097E+01, 5.2210989118E+00, 1.9759464390E+01, 3.7257665769E+00, 9.7365243635E-01],
	[4.2720000000E+04, 3.8085779636E+01, 5.2211383613E+00, 1.9767019358E+01, 3.7261301937E+00, 9.7366361921E-01],
	[4.2725000000E+04, 3.8093614871E+01, 5.2211778065E+00, 1.9774576329E+01, 3.7264937206E+00, 9.7367479669E-01],
	[4.2730000000E+04, 3.8101450800E+01, 5.2212172474E+00, 1.9782135303E+01, 3.7268571577E+00, 9.7368596877E-01],
	[4.2735000000E+04, 3.8109287423E+01, 5.2212566839E+00, 1.9789696281E+01, 3.7272205050E+00, 9.7369713548E-01],
	[4.2740000000E+04, 3.8117124742E+01, 5.2212961161E+00, 1.9797259262E+01, 3.7275837625E+00, 9.7370829681E-01],
	[4.2745000000E+04, 3.8124962755E+01, 5.2213355440E+00, 1.9804824248E+01, 3.7279469303E+00, 9.7371945275E-01],
	[4.2750000000E+04, 3.8132801462E+01, 5.2213749676E+00, 1.9812391237E+01, 3.7283100083E+00, 9.7373060333E-01],
	[4.2755000000E+04, 3.8140640865E+01, 5.2214143869E+00, 1.9819960232E+01, 3.7286729966E+00, 9.7374174853E-01],
	[4.2760000000E+04, 3.8148480962E+01, 5.2214538019E+00, 1.9827531231E+01, 3.7290358951E+00, 9.7375288836E-01],
	[4.2765000000E+04, 3.8156321753E+01, 5.2214932125E+00, 1.9835104235E+01, 3.7293987040E+00, 9.7376402282E-01],
	[4.2770000000E+04, 3.8164163240E+01, 5.2215326189E+00, 1.9842679245E+01, 3.7297614232E+00, 9.7377515192E-01],
	[4.2775000000E+04, 3.8172005420E+01, 5.2215720209E+00, 1.9850256261E+01, 3.7301240528E+00, 9.7378627566E-01],
	[4.2780000000E+04, 3.8179848296E+01, 5.2216114187E+00, 1.9857835282E+01, 3.7304865928E+00, 9.7379739404E-01],
	[4.2785000000E+04, 3.8187691865E+01, 5.2216508121E+00, 1.9865416311E+01, 3.7308490431E+00, 9.7380850706E-01],
	[4.2790000000E+04, 3.8195536130E+01, 5.2216902012E+00, 1.9872999345E+01, 3.7312114039E+00, 9.7381961473E-01],
	[4.2795000000E+04, 3.8203381089E+01, 5.2217295860E+00, 1.9880584387E+01, 3.7315736751E+00, 9.7383071704E-01],
	[4.2800000000E+04, 3.8211226742E+01, 5.2217689665E+00, 1.9888171436E+01, 3.7319358567E+00, 9.7384181401E-01],
	[4.2805000000E+04, 3.8219073090E+01, 5.2218083427E+00, 1.9895760493E+01, 3.7322979489E+00, 9.7385290563E-01],
	[4.2810000000E+04, 3.8226920132E+01, 5.2218477146E+00, 1.9903351558E+01, 3.7326599515E+00, 9.7386399191E-01],
	[4.2815000000E+04, 3.8234767868E+01, 5.2218870822E+00, 1.9910944630E+01, 3.7330218646E+00, 9.7387507284E-01],
	[4.2820000000E+04, 3.8242616299E+01, 5.2219264455E+00, 1.9918539711E+01, 3.7333836883E+00, 9.7388614844E-01],
	[4.2825000000E+04, 3.8250465425E+01, 5.2219658045E+00, 1.9926136801E+01, 3.7337454226E+00, 9.7389721871E-01],
	[4.2830000000E+04, 3.8258315244E+01, 5.2220051592E+00, 1.9933735900E+01, 3.7341070674E+00, 9.7390828364E-01],
	[4.2835000000E+04, 3.8266165758E+01, 5.2220445096E+00, 1.9941337008E+01, 3.7344686229E+00, 9.7391934324E-01],
	[4.2840000000E+04, 3.8274016967E+01, 5.2220838557E+00, 1.9948940126E+01, 3.7348300889E+00, 9.7393039751E-01],
	[4.2845000000E+04, 3.8281868869E+01, 5.2221231975E+00, 1.9956545254E+01, 3.7351914656E+00, 9.7394144646E-01],
	[4.2850000000E+04, 3.8289721466E+01, 5.2221625351E+00, 1.9964152392E+01, 3.7355527530E+00, 9.7395249008E-01],
	[4.2855000000E+04, 3.8297574757E+01, 5.2222018683E+00, 1.9971761541E+01, 3.7359139511E+00, 9.7396352839E-01],
	[4.2860000000E+04, 3.8305428743E+01, 5.2222411972E+00, 1.9979372700E+01, 3.7362750598E+00, 9.7397456137E-01],
	[4.2865000000E+04, 3.8313283422E+01, 5.2222805219E+00, 1.9986985871E+01, 3.7366360793E+00, 9.7398558905E-01],
	[4.2870000000E+04, 3.8321138796E+01, 5.2223198422E+00, 1.9994601053E+01, 3.7369970095E+00, 9.7399661141E-01],
	[4.2875000000E+04, 3.8328994864E+01, 5.2223591583E+00, 2.0002218247E+01, 3.7373578505E+00, 9.7400762846E-01],
	[4.2880000000E+04, 3.8336851626E+01, 5.2223984700E+00, 2.0009837452E+01, 3.7377186023E+00, 9.7401864021E-01],
	[4.2885000000E+04, 3.8344709083E+01, 5.2224377775E+00, 2.0017458671E+01, 3.7380792649E+00, 9.7402964665E-01],
	[4.2890000000E+04, 3.8352567233E+01, 5.2224770807E+00, 2.0025081901E+01, 3.7384398383E+00, 9.7404064779E-01],
	[4.2895000000E+04, 3.8360426077E+01, 5.2225163796E+00, 2.0032707145E+01, 3.7388003226E+00, 9.7405164363E-01],
	[4.2900000000E+04, 3.8368285616E+01, 5.2225556742E+00, 2.0040334401E+01, 3.7391607178E+00, 9.7406263418E-01],
	[4.2905000000E+04, 3.8376145849E+01, 5.2225949646E+00, 2.0047963672E+01, 3.7395210238E+00, 9.7407361943E-01],
	[4.2910000000E+04, 3.8384006775E+01, 5.2226342506E+00, 2.0055594956E+01, 3.7398812407E+00, 9.7408459939E-01],
	[4.2915000000E+04, 3.8391868396E+01, 5.2226735324E+00, 2.0063228254E+01, 3.7402413686E+00, 9.7409557406E-01],
	[4.2920000000E+04, 3.8399730710E+01, 5.2227128099E+00, 2.0070863566E+01, 3.7406014074E+00, 9.7410654345E-01],
	[4.2925000000E+04, 3.8407593719E+01, 5.2227520831E+00, 2.0078500894E+01, 3.7409613572E+00, 9.7411750755E-01],
	[4.2930000000E+04, 3.8415457422E+01, 5.2227913521E+00, 2.0086140236E+01, 3.7413212180E+00, 9.7412846637E-01],
	[4.2935000000E+04, 3.8423321818E+01, 5.2228306167E+00, 2.0093781593E+01, 3.7416809898E+00, 9.7413941992E-01],
	[4.2940000000E+04, 3.8431186909E+01, 5.2228698771E+00, 2.0101424966E+01, 3.7420406727E+00, 9.7415036819E-01],
	[4.2945000000E+04, 3.8439052693E+01, 5.2229091332E+00, 2.0109070355E+01, 3.7424002666E+00, 9.7416131119E-01],
	[4.2950000000E+04, 3.8446919171E+01, 5.2229483850E+00, 2.0116717760E+01, 3.7427597715E+00, 9.7417224892E-01],
	[4.2955000000E+04, 3.8454786343E+01, 5.2229876326E+00, 2.0124367182E+01, 3.7431191876E+00, 9.7418318138E-01],
	[4.2960000000E+04, 3.8462654209E+01, 5.2230268759E+00, 2.0132018620E+01, 3.7434785148E+00, 9.7419410857E-01],
	[4.2965000000E+04, 3.8470522769E+01, 5.2230661149E+00, 2.0139672075E+01, 3.7438377531E+00, 9.7420503051E-01],
	[4.2970000000E+04, 3.8478392022E+01, 5.2231053496E+00, 2.0147327548E+01, 3.7441969026E+00, 9.7421594718E-01],
	[4.2975000000E+04, 3.8486261970E+01, 5.2231445801E+00, 2.0154985038E+01, 3.7445559633E+00, 9.7422685860E-01],
	[4.2980000000E+04, 3.8494132611E+01, 5.2231838063E+00, 2.0162644546E+01, 3.7449149351E+00, 9.7423776476E-01],
	[4.2985000000E+04, 3.8502003946E+01, 5.2232230282E+00, 2.0170306073E+01, 3.7452738182E+00, 9.7424866567E-01],
	[4.2990000000E+04, 3.8509875974E+01, 5.2232622459E+00, 2.0177969618E+01, 3.7456326125E+00, 9.7425956134E-01],
	[4.2995000000E+04, 3.8517748696E+01, 5.2233014593E+00, 2.0185635182E+01, 3.7459913181E+00, 9.7427045175E-01],
	[4.3000000000E+04, 3.8525622112E+01, 5.2233406684E+00, 2.0193302764E+01, 3.7463499350E+00, 9.7428133692E-01],
	[4.3005000000E+04, 3.8533496222E+01, 5.2233798733E+00, 2.0200972367E+01, 3.7467084631E+00, 9.7429221686E-01],
	[4.3010000000E+04, 3.8541371025E+01, 5.2234190739E+00, 2.0208643989E+01, 3.7470669026E+00, 9.7430309155E-01],
	[4.3015000000E+04, 3.8549246522E+01, 5.2234582702E+00, 2.0216317631E+01, 3.7474252534E+00, 9.7431396100E-01],
	[4.3020000000E+04, 3.8557122713E+01, 5.2234974623E+00, 2.0223993294E+01, 3.7477835156E+00, 9.7432482523E-01],
	[4.3025000000E+04, 3.8564999597E+01, 5.2235366501E+00, 2.0231670977E+01, 3.7481416892E+00, 9.7433568422E-01],
	[4.3030000000E+04, 3.8572877174E+01, 5.2235758337E+00, 2.0239350681E+01, 3.7484997742E+00, 9.7434653799E-01],
	[4.3035000000E+04, 3.8580755446E+01, 5.2236150130E+00, 2.0247032406E+01, 3.7488577706E+00, 9.7435738653E-01],
	[4.3040000000E+04, 3.8588634410E+01, 5.2236541880E+00, 2.0254716152E+01, 3.7492156785E+00, 9.7436822984E-01],
	[4.3045000000E+04, 3.8596514068E+01, 5.2236933588E+00, 2.0262401921E+01, 3.7495734978E+00, 9.7437906794E-01],
	[4.3050000000E+04, 3.8604394420E+01, 5.2237325253E+00, 2.0270089711E+01, 3.7499312286E+00, 9.7438990082E-01],
	[4.3055000000E+04, 3.8612275465E+01, 5.2237716876E+00, 2.0277779524E+01, 3.7502888710E+00, 9.7440072848E-01],
	[4.3060000000E+04, 3.8620157204E+01, 5.2238108456E+00, 2.0285471360E+01, 3.7506464248E+00, 9.7441155093E-01],
	[4.3065000000E+04, 3.8628039636E+01, 5.2238499994E+00, 2.0293165218E+01, 3.7510038902E+00, 9.7442236817E-01],
	[4.3070000000E+04, 3.8635922761E+01, 5.2238891489E+00, 2.0300861100E+01, 3.7513612672E+00, 9.7443318021E-01],
	[4.3075000000E+04, 3.8643806580E+01, 5.2239282941E+00, 2.0308559006E+01, 3.7517185557E+00, 9.7444398704E-01],
	[4.3080000000E+04, 3.8651691093E+01, 5.2239674351E+00, 2.0316258935E+01, 3.7520757559E+00, 9.7445478867E-01],
	[4.3085000000E+04, 3.8659576298E+01, 5.2240065719E+00, 2.0323960889E+01, 3.7524328677E+00, 9.7446558509E-01],
	[4.3090000000E+04, 3.8667462197E+01, 5.2240457044E+00, 2.0331664867E+01, 3.7527898912E+00, 9.7447637633E-01],
	[4.3095000000E+04, 3.8675348789E+01, 5.2240848327E+00, 2.0339370869E+01, 3.7531468263E+00, 9.7448716236E-01],
	[4.3100000000E+04, 3.8683236075E+01, 5.2241239567E+00, 2.0347078897E+01, 3.7535036732E+00, 9.7449794321E-01],
	[4.3105000000E+04, 3.8691124054E+01, 5.2241630765E+00, 2.0354788950E+01, 3.7538604317E+00, 9.7450871887E-01],
	[4.3110000000E+04, 3.8699012726E+01, 5.2242021920E+00, 2.0362501029E+01, 3.7542171020E+00, 9.7451948934E-01],
	[4.3115000000E+04, 3.8706902091E+01, 5.2242413033E+00, 2.0370215134E+01, 3.7545736840E+00, 9.7453025462E-01],
	[4.3120000000E+04, 3.8714792149E+01, 5.2242804103E+00, 2.0377931265E+01, 3.7549301778E+00, 9.7454101473E-01],
	[4.3125000000E+04, 3.8722682901E+01, 5.2243195131E+00, 2.0385649422E+01, 3.7552865834E+00, 9.7455176966E-01],
	[4.3130000000E+04, 3.8730574346E+01, 5.2243586117E+00, 2.0393369607E+01, 3.7556429009E+00, 9.7456251941E-01],
	[4.3135000000E+04, 3.8738466484E+01, 5.2243977060E+00, 2.0401091818E+01, 3.7559991301E+00, 9.7457326399E-01],
	[4.3140000000E+04, 3.8746359315E+01, 5.2244367961E+00, 2.0408816057E+01, 3.7563552712E+00, 9.7458400340E-01],
	[4.3145000000E+04, 3.8754252839E+01, 5.2244758819E+00, 2.0416542324E+01, 3.7567113242E+00, 9.7459473763E-01],
	[4.3150000000E+04, 3.8762147057E+01, 5.2245149635E+00, 2.0424270618E+01, 3.7570672892E+00, 9.7460546671E-01],
	[4.3155000000E+04, 3.8770041967E+01, 5.2245540409E+00, 2.0432000941E+01, 3.7574231660E+00, 9.7461619062E-01],
	[4.3160000000E+04, 3.8777937571E+01, 5.2245931141E+00, 2.0439733293E+01, 3.7577789547E+00, 9.7462690937E-01],
	[4.3165000000E+04, 3.8785833867E+01, 5.2246321830E+00, 2.0447467674E+01, 3.7581346555E+00, 9.7463762296E-01],
	[4.3170000000E+04, 3.8793730857E+01, 5.2246712476E+00, 2.0455204083E+01, 3.7584902682E+00, 9.7464833140E-01],
	[4.3175000000E+04, 3.8801628540E+01, 5.2247103081E+00, 2.0462942523E+01, 3.7588457929E+00, 9.7465903469E-01],
	[4.3180000000E+04, 3.8809526915E+01, 5.2247493643E+00, 2.0470682992E+01, 3.7592012296E+00, 9.7466973282E-01],
	[4.3185000000E+04, 3.8817434218E+01, 5.2247893933E+00, 2.0478425491E+01, 3.7595571616E+00, 9.7468042581E-01],
	[4.3190000000E+04, 3.8825350622E+01, 5.2248304153E+00, 2.0486170021E+01, 3.7599136009E+00, 9.7469111366E-01],
	[4.3195000000E+04, 3.8833267724E+01, 5.2248714328E+00, 2.0493916581E+01, 3.7602699526E+00, 9.7470179636E-01],
	[4.3200000000E+04, 3.8841185523E+01, 5.2249124459E+00, 2.0501665172E+01, 3.7606262166E+00, 9.7471247392E-01],
	[4.3205000000E+04, 3.8849104020E+01, 5.2249534546E+00, 2.0509415795E+01, 3.7609823930E+00, 9.7472314635E-01],
	[4.3210000000E+04, 3.8857023215E+01, 5.2249944589E+00, 2.0517168449E+01, 3.7613384818E+00, 9.7473381364E-01],
	[4.3215000000E+04, 3.8864943107E+01, 5.2250354587E+00, 2.0524923135E+01, 3.7616944829E+00, 9.7474447580E-01],
	[4.3220000000E+04, 3.8872863698E+01, 5.2250764541E+00, 2.0532679853E+01, 3.7620503965E+00, 9.7475513283E-01],
	[4.3225000000E+04, 3.8880784985E+01, 5.2251174451E+00, 2.0540438604E+01, 3.7624062225E+00, 9.7476578473E-01],
	[4.3230000000E+04, 3.8888706971E+01, 5.2251584317E+00, 2.0548199387E+01, 3.7627619610E+00, 9.7477643151E-01],
	[4.3235000000E+04, 3.8896629654E+01, 5.2251994139E+00, 2.0555962204E+01, 3.7631176119E+00, 9.7478707317E-01],
	[4.3240000000E+04, 3.8904553035E+01, 5.2252403916E+00, 2.0563727054E+01, 3.7634731754E+00, 9.7479770971E-01],
	[4.3245000000E+04, 3.8912477113E+01, 5.2252813649E+00, 2.0571493938E+01, 3.7638286514E+00, 9.7480834113E-01],
	[4.3250000000E+04, 3.8920401889E+01, 5.2253223338E+00, 2.0579262855E+01, 3.7641840399E+00, 9.7481896744E-01],
	[4.3255000000E+04, 3.8928327362E+01, 5.2253632983E+00, 2.0587033807E+01, 3.7645393409E+00, 9.7482958864E-01],
	[4.3260000000E+04, 3.8936253533E+01, 5.2254042584E+00, 2.0594806793E+01, 3.7648945546E+00, 9.7484020473E-01],
	[4.3265000000E+04, 3.8944180402E+01, 5.2254452141E+00, 2.0602581815E+01, 3.7652496809E+00, 9.7485081572E-01],
	[4.3270000000E+04, 3.8952107968E+01, 5.2254861653E+00, 2.0610358871E+01, 3.7656047198E+00, 9.7486142160E-01],
	[4.3275000000E+04, 3.8960036231E+01, 5.2255271122E+00, 2.0618137963E+01, 3.7659596713E+00, 9.7487202238E-01],
	[4.3280000000E+04, 3.8967965192E+01, 5.2255680546E+00, 2.0625919091E+01, 3.7663145355E+00, 9.7488261807E-01],
	[4.3285000000E+04, 3.8975894850E+01, 5.2256089926E+00, 2.0633702254E+01, 3.7666693124E+00, 9.7489320866E-01],
	[4.3290000000E+04, 3.8983825206E+01, 5.2256499262E+00, 2.0641487454E+01, 3.7670240019E+00, 9.7490379415E-01],
	[4.3295000000E+04, 3.8991756259E+01, 5.2256908555E+00, 2.0649274691E+01, 3.7673786043E+00, 9.7491437456E-01],
	[4.3300000000E+04, 3.8999688010E+01, 5.2257317803E+00, 2.0657063964E+01, 3.7677331193E+00, 9.7492494987E-01],
	[4.3305000000E+04, 3.9007620458E+01, 5.2257727007E+00, 2.0664855275E+01, 3.7680875471E+00, 9.7493552011E-01],
	[4.3310000000E+04, 3.9015553603E+01, 5.2258136166E+00, 2.0672648623E+01, 3.7684418878E+00, 9.7494608526E-01],
	[4.3315000000E+04, 3.9023487445E+01, 5.2258545282E+00, 2.0680444010E+01, 3.7687961412E+00, 9.7495664533E-01],
	[4.3320000000E+04, 3.9031421985E+01, 5.2258954354E+00, 2.0688241434E+01, 3.7691503074E+00, 9.7496720032E-01],
	[4.3325000000E+04, 3.9039357222E+01, 5.2259363382E+00, 2.0696040897E+01, 3.7695043865E+00, 9.7497775024E-01],
	[4.3330000000E+04, 3.9047293156E+01, 5.2259772366E+00, 2.0703842398E+01, 3.7698583785E+00, 9.7498829508E-01],
	[4.3335000000E+04, 3.9055229788E+01, 5.2260181306E+00, 2.0711645938E+01, 3.7702122834E+00, 9.7499883486E-01],
	[4.3340000000E+04, 3.9063167117E+01, 5.2260590202E+00, 2.0719451518E+01, 3.7705661011E+00, 9.7500936957E-01],
	[4.3345000000E+04, 3.9071105143E+01, 5.2260999054E+00, 2.0727259137E+01, 3.7709198318E+00, 9.7501989921E-01],
	[4.3350000000E+04, 3.9079043866E+01, 5.2261407862E+00, 2.0735068797E+01, 3.7712734755E+00, 9.7503042380E-01],
	[4.3355000000E+04, 3.9086983286E+01, 5.2261816626E+00, 2.0742880496E+01, 3.7716270321E+00, 9.7504094332E-01],
	[4.3360000000E+04, 3.9094923403E+01, 5.2262225346E+00, 2.0750694236E+01, 3.7719805017E+00, 9.7505145779E-01],
	[4.3365000000E+04, 3.9102864218E+01, 5.2262634022E+00, 2.0758510017E+01, 3.7723338844E+00, 9.7506196720E-01],
	[4.3370000000E+04, 3.9110805730E+01, 5.2263042654E+00, 2.0766327839E+01, 3.7726871800E+00, 9.7507247156E-01],
	[4.3375000000E+04, 3.9118747938E+01, 5.2263451242E+00, 2.0774147702E+01, 3.7730403888E+00, 9.7508297088E-01],
	[4.3380000000E+04, 3.9126690844E+01, 5.2263859787E+00, 2.0781969607E+01, 3.7733935106E+00, 9.7509346514E-01],
	[4.3385000000E+04, 3.9134634447E+01, 5.2264268287E+00, 2.0789793554E+01, 3.7737465454E+00, 9.7510395437E-01],
	[4.3390000000E+04, 3.9142578747E+01, 5.2264676744E+00, 2.0797619543E+01, 3.7740994935E+00, 9.7511443855E-01],
	[4.3395000000E+04, 3.9150523744E+01, 5.2265085157E+00, 2.0805447575E+01, 3.7744523546E+00, 9.7512491769E-01],
	[4.3400000000E+04, 3.9158469438E+01, 5.2265493526E+00, 2.0813277649E+01, 3.7748051289E+00, 9.7513539180E-01],
	[4.3405000000E+04, 3.9166415829E+01, 5.2265901851E+00, 2.0821109767E+01, 3.7751578164E+00, 9.7514586087E-01],
	[4.3410000000E+04, 3.9174362916E+01, 5.2266310132E+00, 2.0828943928E+01, 3.7755104170E+00, 9.7515632492E-01],
	[4.3415000000E+04, 3.9182310701E+01, 5.2266718369E+00, 2.0836780134E+01, 3.7758629309E+00, 9.7516678393E-01],
	[4.3420000000E+04, 3.9190259183E+01, 5.2267126563E+00, 2.0844618383E+01, 3.7762153581E+00, 9.7517723792E-01],
	[4.3425000000E+04, 3.9198208361E+01, 5.2267534712E+00, 2.0852458676E+01, 3.7765676985E+00, 9.7518768689E-01],
	[4.3430000000E+04, 3.9206158237E+01, 5.2267942818E+00, 2.0860301014E+01, 3.7769199521E+00, 9.7519813083E-01],
	[4.3435000000E+04, 3.9214108809E+01, 5.2268350881E+00, 2.0868145397E+01, 3.7772721191E+00, 9.7520856976E-01],
	[4.3440000000E+04, 3.9222060078E+01, 5.2268758899E+00, 2.0875991826E+01, 3.7776241994E+00, 9.7521900367E-01],
	[4.3445000000E+04, 3.9230012044E+01, 5.2269166873E+00, 2.0883840300E+01, 3.7779761930E+00, 9.7522943257E-01],
	[4.3450000000E+04, 3.9237964707E+01, 5.2269574804E+00, 2.0891690820E+01, 3.7783281000E+00, 9.7523985646E-01],
	[4.3455000000E+04, 3.9245918066E+01, 5.2269982691E+00, 2.0899543385E+01, 3.7786799204E+00, 9.7525027534E-01],
	[4.3460000000E+04, 3.9253872123E+01, 5.2270390535E+00, 2.0907397998E+01, 3.7790316542E+00, 9.7526068922E-01],
	[4.3465000000E+04, 3.9261826876E+01, 5.2270798334E+00, 2.0915254657E+01, 3.7793833014E+00, 9.7527109809E-01],
	[4.3470000000E+04, 3.9269782325E+01, 5.2271206090E+00, 2.0923113363E+01, 3.7797348620E+00, 9.7528150196E-01],
	[4.3475000000E+04, 3.9277738472E+01, 5.2271613802E+00, 2.0930974117E+01, 3.7800863361E+00, 9.7529190084E-01],
	[4.3480000000E+04, 3.9285695315E+01, 5.2272021470E+00, 2.0938836918E+01, 3.7804377237E+00, 9.7530229472E-01],
	[4.3485000000E+04, 3.9293652855E+01, 5.2272429095E+00, 2.0946701767E+01, 3.7807890248E+00, 9.7531268361E-01],
	[4.3490000000E+04, 3.9301611091E+01, 5.2272836676E+00, 2.0954568664E+01, 3.7811402394E+00, 9.7532306751E-01],
	[4.3495000000E+04, 3.9309570024E+01, 5.2273244213E+00, 2.0962437610E+01, 3.7814913676E+00, 9.7533344642E-01],
	[4.3500000000E+04, 3.9317529654E+01, 5.2273651707E+00, 2.0970308605E+01, 3.7818424094E+00, 9.7534382035E-01],
	[4.3505000000E+04, 3.9325489980E+01, 5.2274059157E+00, 2.0978181648E+01, 3.7821933647E+00, 9.7535418929E-01],
	[4.3510000000E+04, 3.9333451003E+01, 5.2274466563E+00, 2.0986056742E+01, 3.7825442336E+00, 9.7536455326E-01],
	[4.3515000000E+04, 3.9341412722E+01, 5.2274873926E+00, 2.0993933884E+01, 3.7828950162E+00, 9.7537491224E-01],
	[4.3520000000E+04, 3.9349375138E+01, 5.2275281245E+00, 2.1001813077E+01, 3.7832457124E+00, 9.7538526626E-01],
	[4.3525000000E+04, 3.9357338250E+01, 5.2275688521E+00, 2.1009694321E+01, 3.7835963223E+00, 9.7539561530E-01],
	[4.3530000000E+04, 3.9365302059E+01, 5.2276095752E+00, 2.1017577614E+01, 3.7839468458E+00, 9.7540595937E-01],
	[4.3535000000E+04, 3.9373266565E+01, 5.2276502941E+00, 2.1025462959E+01, 3.7842972831E+00, 9.7541629848E-01],
	[4.3540000000E+04, 3.9381231766E+01, 5.2276910085E+00, 2.1033350355E+01, 3.7846476341E+00, 9.7542663262E-01],
	[4.3545000000E+04, 3.9389197665E+01, 5.2277317186E+00, 2.1041239803E+01, 3.7849978989E+00, 9.7543696180E-01],
	[4.3550000000E+04, 3.9397164259E+01, 5.2277724244E+00, 2.1049131302E+01, 3.7853480774E+00, 9.7544728603E-01],
	[4.3555000000E+04, 3.9405131550E+01, 5.2278131258E+00, 2.1057024853E+01, 3.7856981698E+00, 9.7545760529E-01],
	[4.3560000000E+04, 3.9413099538E+01, 5.2278538228E+00, 2.1064920457E+01, 3.7860481759E+00, 9.7546791960E-01],
	[4.3565000000E+04, 3.9421068222E+01, 5.2278945155E+00, 2.1072818113E+01, 3.7863980959E+00, 9.7547822896E-01],
	[4.3570000000E+04, 3.9429037602E+01, 5.2279352038E+00, 2.1080717823E+01, 3.7867479297E+00, 9.7548853337E-01],
	[4.3575000000E+04, 3.9437007678E+01, 5.2279758878E+00, 2.1088619585E+01, 3.7870976774E+00, 9.7549883284E-01],
	[4.3580000000E+04, 3.9444978451E+01, 5.2280165674E+00, 2.1096523402E+01, 3.7874473390E+00, 9.7550912736E-01],
	[4.3585000000E+04, 3.9452949920E+01, 5.2280572427E+00, 2.1104429272E+01, 3.7877969145E+00, 9.7551941694E-01],
	[4.3590000000E+04, 3.9460922085E+01, 5.2280979136E+00, 2.1112337196E+01, 3.7881464039E+00, 9.7552970158E-01],
	[4.3595000000E+04, 3.9468894947E+01, 5.2281385802E+00, 2.1120247175E+01, 3.7884958073E+00, 9.7553998129E-01],
	[4.3600000000E+04, 3.9476868504E+01, 5.2281792425E+00, 2.1128159209E+01, 3.7888451247E+00, 9.7555025606E-01],
	[4.3605000000E+04, 3.9484842758E+01, 5.2282199003E+00, 2.1136073297E+01, 3.7891943561E+00, 9.7556052590E-01],
	[4.3610000000E+04, 3.9492817709E+01, 5.2282605539E+00, 2.1143989441E+01, 3.7895435015E+00, 9.7557079081E-01],
	[4.3615000000E+04, 3.9500793355E+01, 5.2283012031E+00, 2.1151907641E+01, 3.7898925609E+00, 9.7558105080E-01],
	[4.3620000000E+04, 3.9508769697E+01, 5.2283418479E+00, 2.1159827897E+01, 3.7902415344E+00, 9.7559130586E-01],
	[4.3625000000E+04, 3.9516746736E+01, 5.2283824884E+00, 2.1167750209E+01, 3.7905904220E+00, 9.7560155601E-01],
	[4.3630000000E+04, 3.9524724471E+01, 5.2284231246E+00, 2.1175674577E+01, 3.7909392237E+00, 9.7561180123E-01],
	[4.3635000000E+04, 3.9532702901E+01, 5.2284637564E+00, 2.1183601003E+01, 3.7912879395E+00, 9.7562204154E-01],
	[4.3640000000E+04, 3.9540682028E+01, 5.2285043839E+00, 2.1191529485E+01, 3.7916365694E+00, 9.7563227694E-01],
	[4.3645000000E+04, 3.9548661851E+01, 5.2285450070E+00, 2.1199460025E+01, 3.7919851135E+00, 9.7564250742E-01],
	[4.3650000000E+04, 3.9556642370E+01, 5.2285856259E+00, 2.1207392623E+01, 3.7923335718E+00, 9.7565273300E-01],
	[4.3655000000E+04, 3.9564623585E+01, 5.2286262403E+00, 2.1215327279E+01, 3.7926819442E+00, 9.7566295367E-01],
	[4.3660000000E+04, 3.9572605496E+01, 5.2286668505E+00, 2.1223263993E+01, 3.7930302309E+00, 9.7567316944E-01],
	[4.3665000000E+04, 3.9580588103E+01, 5.2287074563E+00, 2.1231202766E+01, 3.7933784319E+00, 9.7568338031E-01],
	[4.3670000000E+04, 3.9588571406E+01, 5.2287480577E+00, 2.1239143597E+01, 3.7937265471E+00, 9.7569358628E-01],
	[4.3675000000E+04, 3.9596555405E+01, 5.2287886549E+00, 2.1247086488E+01, 3.7940745766E+00, 9.7570378735E-01],
	[4.3680000000E+04, 3.9604540099E+01, 5.2288292477E+00, 2.1255031439E+01, 3.7944225204E+00, 9.7571398354E-01],
	[4.3685000000E+04, 3.9612525490E+01, 5.2288698361E+00, 2.1262978449E+01, 3.7947703785E+00, 9.7572417483E-01],
	[4.3690000000E+04, 3.9620511577E+01, 5.2289104203E+00, 2.1270927520E+01, 3.7951181510E+00, 9.7573436123E-01],
	[4.3695000000E+04, 3.9628498359E+01, 5.2289510001E+00, 2.1278878650E+01, 3.7954658378E+00, 9.7574454275E-01],
	[4.3700000000E+04, 3.9636485837E+01, 5.2289915755E+00, 2.1286831842E+01, 3.7958134390E+00, 9.7575471939E-01],
	[4.3705000000E+04, 3.9644474011E+01, 5.2290321467E+00, 2.1294787095E+01, 3.7961609547E+00, 9.7576489115E-01],
	[4.3710000000E+04, 3.9652462881E+01, 5.2290727135E+00, 2.1302744409E+01, 3.7965083847E+00, 9.7577505803E-01],
	[4.3715000000E+04, 3.9660452447E+01, 5.2291132760E+00, 2.1310703784E+01, 3.7968557292E+00, 9.7578522003E-01],
	[4.3720000000E+04, 3.9668442708E+01, 5.2291538342E+00, 2.1318665222E+01, 3.7972029882E+00, 9.7579537716E-01],
	[4.3725000000E+04, 3.9676433665E+01, 5.2291943881E+00, 2.1326628721E+01, 3.7975501617E+00, 9.7580552942E-01],
	[4.3730000000E+04, 3.9684425318E+01, 5.2292349376E+00, 2.1334594284E+01, 3.7978972496E+00, 9.7581567682E-01],
	[4.3735000000E+04, 3.9692417667E+01, 5.2292754828E+00, 2.1342561909E+01, 3.7982442521E+00, 9.7582581935E-01],
	[4.3740000000E+04, 3.9700410711E+01, 5.2293160237E+00, 2.1350531597E+01, 3.7985911692E+00, 9.7583595702E-01],
	[4.3745000000E+04, 3.9708404451E+01, 5.2293565602E+00, 2.1358503348E+01, 3.7989380008E+00, 9.7584608982E-01],
	[4.3750000000E+04, 3.9716398887E+01, 5.2293970925E+00, 2.1366477164E+01, 3.7992847470E+00, 9.7585621777E-01],
	[4.3755000000E+04, 3.9724394018E+01, 5.2294376204E+00, 2.1374453043E+01, 3.7996314079E+00, 9.7586634087E-01],
	[4.3760000000E+04, 3.9732389845E+01, 5.2294781440E+00, 2.1382430987E+01, 3.7999779833E+00, 9.7587645911E-01],
	[4.3765000000E+04, 3.9740386367E+01, 5.2295186633E+00, 2.1390410995E+01, 3.8003244735E+00, 9.7588657250E-01],
	[4.3770000000E+04, 3.9748383585E+01, 5.2295591783E+00, 2.1398393068E+01, 3.8006708783E+00, 9.7589668105E-01],
	[4.3775000000E+04, 3.9756381499E+01, 5.2295996890E+00, 2.1406377206E+01, 3.8010171977E+00, 9.7590678475E-01],
	[4.3780000000E+04, 3.9764380108E+01, 5.2296401953E+00, 2.1414363410E+01, 3.8013634319E+00, 9.7591688361E-01],
	[4.3785000000E+04, 3.9772379413E+01, 5.2296806974E+00, 2.1422351679E+01, 3.8017095809E+00, 9.7592697763E-01],
	[4.3790000000E+04, 3.9780379413E+01, 5.2297211951E+00, 2.1430342015E+01, 3.8020556446E+00, 9.7593706682E-01],
	[4.3795000000E+04, 3.9788380109E+01, 5.2297616885E+00, 2.1438334417E+01, 3.8024016230E+00, 9.7594715116E-01],
	[4.3800000000E+04, 3.9796381500E+01, 5.2298021777E+00, 2.1446328886E+01, 3.8027475163E+00, 9.7595723068E-01],
	[4.3805000000E+04, 3.9804383586E+01, 5.2298426625E+00, 2.1454325422E+01, 3.8030933244E+00, 9.7596730537E-01],
	[4.3810000000E+04, 3.9812386368E+01, 5.2298831430E+00, 2.1462324025E+01, 3.8034390473E+00, 9.7597737523E-01],
	[4.3815000000E+04, 3.9820389846E+01, 5.2299236192E+00, 2.1470324695E+01, 3.8037846851E+00, 9.7598744026E-01],
	[4.3820000000E+04, 3.9828394018E+01, 5.2299640910E+00, 2.1478327434E+01, 3.8041302377E+00, 9.7599750048E-01],
	[4.3825000000E+04, 3.9836398887E+01, 5.2300045586E+00, 2.1486332240E+01, 3.8044757053E+00, 9.7600755587E-01],
	[4.3830000000E+04, 3.9844404450E+01, 5.2300450219E+00, 2.1494339115E+01, 3.8048210878E+00, 9.7601760645E-01],
	[4.3835000000E+04, 3.9852410709E+01, 5.2300854809E+00, 2.1502348059E+01, 3.8051663852E+00, 9.7602765221E-01],
	[4.3840000000E+04, 3.9860417663E+01, 5.2301259355E+00, 2.1510359072E+01, 3.8055115976E+00, 9.7603769316E-01],
	[4.3845000000E+04, 3.9868425313E+01, 5.2301663859E+00, 2.1518372154E+01, 3.8058567249E+00, 9.7604772930E-01],
	[4.3850000000E+04, 3.9876433657E+01, 5.2302068320E+00, 2.1526387306E+01, 3.8062017673E+00, 9.7605776064E-01],
	[4.3855000000E+04, 3.9884442697E+01, 5.2302472738E+00, 2.1534404528E+01, 3.8065467247E+00, 9.7606778717E-01],
	[4.3860000000E+04, 3.9892452432E+01, 5.2302877112E+00, 2.1542423821E+01, 3.8068915971E+00, 9.7607780890E-01],
	[4.3865000000E+04, 3.9900462863E+01, 5.2303281444E+00, 2.1550445183E+01, 3.8072363846E+00, 9.7608782583E-01],
	[4.3870000000E+04, 3.9908473988E+01, 5.2303685733E+00, 2.1558468617E+01, 3.8075810872E+00, 9.7609783796E-01],
	[4.3875000000E+04, 3.9916485809E+01, 5.2304089979E+00, 2.1566494122E+01, 3.8079257048E+00, 9.7610784530E-01],
	[4.3880000000E+04, 3.9924505904E+01, 5.2304503048E+00, 2.1574521698E+01, 3.8082707766E+00, 9.7611784784E-01],
	[4.3885000000E+04, 3.9932535633E+01, 5.2304926526E+00, 2.1582551346E+01, 3.8086163992E+00, 9.7612784560E-01],
	[4.3890000000E+04, 3.9940566062E+01, 5.2305349960E+00, 2.1590583066E+01, 3.8089619371E+00, 9.7613783857E-01],
	[4.3895000000E+04, 3.9948597190E+01, 5.2305773348E+00, 2.1598616858E+01, 3.8093073904E+00, 9.7614782676E-01],
	[4.3900000000E+04, 3.9956629019E+01, 5.2306196692E+00, 2.1606652723E+01, 3.8096527592E+00, 9.7615781016E-01],
	[4.3905000000E+04, 3.9964661547E+01, 5.2306619991E+00, 2.1614690661E+01, 3.8099980433E+00, 9.7616778879E-01],
	[4.3910000000E+04, 3.9972694775E+01, 5.2307043245E+00, 2.1622730673E+01, 3.8103432430E+00, 9.7617776263E-01],
	[4.3915000000E+04, 3.9980728703E+01, 5.2307466455E+00, 2.1630772757E+01, 3.8106883581E+00, 9.7618773171E-01],
	[4.3920000000E+04, 3.9988763331E+01, 5.2307889619E+00, 2.1638816916E+01, 3.8110333888E+00, 9.7619769601E-01],
	[4.3925000000E+04, 3.9996798659E+01, 5.2308312739E+00, 2.1646863149E+01, 3.8113783349E+00, 9.7620765555E-01],
	[4.3930000000E+04, 4.0004834686E+01, 5.2308735815E+00, 2.1654911456E+01, 3.8117231966E+00, 9.7621761031E-01],
	[4.3935000000E+04, 4.0012871413E+01, 5.2309158845E+00, 2.1662961838E+01, 3.8120679739E+00, 9.7622756032E-01],
	[4.3940000000E+04, 4.0020908839E+01, 5.2309581831E+00, 2.1671014295E+01, 3.8124126668E+00, 9.7623750556E-01],
	[4.3945000000E+04, 4.0028946965E+01, 5.2310004772E+00, 2.1679068827E+01, 3.8127572752E+00, 9.7624744604E-01],
	[4.3950000000E+04, 4.0036985791E+01, 5.2310427668E+00, 2.1687125435E+01, 3.8131017993E+00, 9.7625738176E-01],
	[4.3955000000E+04, 4.0045025317E+01, 5.2310850520E+00, 2.1695184119E+01, 3.8134462390E+00, 9.7626731273E-01],
	[4.3960000000E+04, 4.0053065542E+01, 5.2311273327E+00, 2.1703244879E+01, 3.8137905944E+00, 9.7627723895E-01],
	[4.3965000000E+04, 4.0061106467E+01, 5.2311696089E+00, 2.1711307715E+01, 3.8141348655E+00, 9.7628716042E-01],
	[4.3970000000E+04, 4.0069148091E+01, 5.2312118807E+00, 2.1719372629E+01, 3.8144790523E+00, 9.7629707715E-01],
	[4.3975000000E+04, 4.0077190415E+01, 5.2312541480E+00, 2.1727439619E+01, 3.8148231548E+00, 9.7630698913E-01],
	[4.3980000000E+04, 4.0085233438E+01, 5.2312964109E+00, 2.1735508687E+01, 3.8151671731E+00, 9.7631689636E-01],
	[4.3985000000E+04, 4.0093277161E+01, 5.2313386692E+00, 2.1743579833E+01, 3.8155111071E+00, 9.7632679886E-01],
	[4.3990000000E+04, 4.0101321584E+01, 5.2313809231E+00, 2.1751653056E+01, 3.8158549569E+00, 9.7633669662E-01],
	[4.3995000000E+04, 4.0109366706E+01, 5.2314231726E+00, 2.1759728358E+01, 3.8161987225E+00, 9.7634658965E-01],
	[4.4000000000E+04, 4.0117412527E+01, 5.2314654176E+00, 2.1767805739E+01, 3.8165424040E+00, 9.7635647795E-01],
	[4.4005000000E+04, 4.0125459048E+01, 5.2315076581E+00, 2.1775885198E+01, 3.8168860013E+00, 9.7636636151E-01],
	[4.4010000000E+04, 4.0133506268E+01, 5.2315498942E+00, 2.1783966737E+01, 3.8172295144E+00, 9.7637624035E-01],
	[4.4015000000E+04, 4.0141554188E+01, 5.2315921258E+00, 2.1792050355E+01, 3.8175729435E+00, 9.7638611447E-01],
	[4.4020000000E+04, 4.0149602807E+01, 5.2316343530E+00, 2.1800136053E+01, 3.8179162885E+00, 9.7639598386E-01],
	[4.4025000000E+04, 4.0157652125E+01, 5.2316765757E+00, 2.1808223831E+01, 3.8182595494E+00, 9.7640584854E-01],
	[4.4030000000E+04, 4.0165702143E+01, 5.2317187939E+00, 2.1816313690E+01, 3.8186027262E+00, 9.7641570849E-01],
	[4.4035000000E+04, 4.0173752860E+01, 5.2317610077E+00, 2.1824405629E+01, 3.8189458190E+00, 9.7642556374E-01],
	[4.4040000000E+04, 4.0181804277E+01, 5.2318032171E+00, 2.1832499649E+01, 3.8192888279E+00, 9.7643541427E-01],
	[4.4045000000E+04, 4.0189856392E+01, 5.2318454220E+00, 2.1840595751E+01, 3.8196317527E+00, 9.7644526009E-01],
	[4.4050000000E+04, 4.0197909208E+01, 5.2318876224E+00, 2.1848693934E+01, 3.8199745935E+00, 9.7645510121E-01],
	[4.4055000000E+04, 4.0205962722E+01, 5.2319298184E+00, 2.1856794199E+01, 3.8203173504E+00, 9.7646493762E-01],
	[4.4060000000E+04, 4.0214016935E+01, 5.2319720100E+00, 2.1864896546E+01, 3.8206600234E+00, 9.7647476933E-01],
	[4.4065000000E+04, 4.0222071848E+01, 5.2320141971E+00, 2.1873000976E+01, 3.8210026125E+00, 9.7648459634E-01],
	[4.4070000000E+04, 4.0230127460E+01, 5.2320563797E+00, 2.1881107488E+01, 3.8213451177E+00, 9.7649441865E-01],
	[4.4075000000E+04, 4.0238183771E+01, 5.2320985579E+00, 2.1889216084E+01, 3.8216875390E+00, 9.7650423627E-01],
	[4.4080000000E+04, 4.0246240781E+01, 5.2321407317E+00, 2.1897326763E+01, 3.8220298765E+00, 9.7651404919E-01],
	[4.4085000000E+04, 4.0254298491E+01, 5.2321829010E+00, 2.1905439525E+01, 3.8223721301E+00, 9.7652385743E-01],
	[4.4090000000E+04, 4.0262356900E+01, 5.2322250659E+00, 2.1913554372E+01, 3.8227143000E+00, 9.7653366098E-01],
	[4.4095000000E+04, 4.0270416007E+01, 5.2322672263E+00, 2.1921671303E+01, 3.8230563860E+00, 9.7654345985E-01],
	[4.4100000000E+04, 4.0278475814E+01, 5.2323093823E+00, 2.1929790318E+01, 3.8233983883E+00, 9.7655325403E-01],
	[4.4105000000E+04, 4.0286536320E+01, 5.2323515339E+00, 2.1937911419E+01, 3.8237403069E+00, 9.7656304353E-01],
	[4.4110000000E+04, 4.0294597525E+01, 5.2323936810E+00, 2.1946034604E+01, 3.8240821417E+00, 9.7657282836E-01],
	[4.4115000000E+04, 4.0302659429E+01, 5.2324358236E+00, 2.1954159875E+01, 3.8244238928E+00, 9.7658260851E-01],
	[4.4120000000E+04, 4.0310722032E+01, 5.2324779619E+00, 2.1962287232E+01, 3.8247655602E+00, 9.7659238399E-01],
	[4.4125000000E+04, 4.0318785334E+01, 5.2325200957E+00, 2.1970416675E+01, 3.8251071440E+00, 9.7660215480E-01],
	[4.4130000000E+04, 4.0326849335E+01, 5.2325622251E+00, 2.1978548204E+01, 3.8254486442E+00, 9.7661192095E-01],
	[4.4135000000E+04, 4.0334914035E+01, 5.2326043500E+00, 2.1986681820E+01, 3.8257900607E+00, 9.7662168242E-01],
	[4.4140000000E+04, 4.0342979433E+01, 5.2326464705E+00, 2.1994817523E+01, 3.8261313936E+00, 9.7663143924E-01],
	[4.4145000000E+04, 4.0351045531E+01, 5.2326885866E+00, 2.2002955313E+01, 3.8264726429E+00, 9.7664119140E-01],
	[4.4150000000E+04, 4.0359112328E+01, 5.2327306982E+00, 2.2011095190E+01, 3.8268138087E+00, 9.7665093890E-01],
	[4.4155000000E+04, 4.0367179824E+01, 5.2327728054E+00, 2.2019237156E+01, 3.8271548909E+00, 9.7666068174E-01],
	[4.4160000000E+04, 4.0375248018E+01, 5.2328149082E+00, 2.2027381210E+01, 3.8274958896E+00, 9.7667041993E-01],
	[4.4165000000E+04, 4.0383316911E+01, 5.2328570065E+00, 2.2035527352E+01, 3.8278368048E+00, 9.7668015347E-01],
	[4.4170000000E+04, 4.0391386503E+01, 5.2328991005E+00, 2.2043675583E+01, 3.8281776365E+00, 9.7668988237E-01],
	[4.4175000000E+04, 4.0399456794E+01, 5.2329411900E+00, 2.2051825903E+01, 3.8285183848E+00, 9.7669960662E-01],
	[4.4180000000E+04, 4.0407527784E+01, 5.2329832750E+00, 2.2059978312E+01, 3.8288590496E+00, 9.7670932622E-01],
	[4.4185000000E+04, 4.0415599473E+01, 5.2330253557E+00, 2.2068132811E+01, 3.8291996310E+00, 9.7671904119E-01],
	[4.4190000000E+04, 4.0423671860E+01, 5.2330674319E+00, 2.2076289400E+01, 3.8295401290E+00, 9.7672875152E-01],
	[4.4195000000E+04, 4.0431744946E+01, 5.2331095037E+00, 2.2084448079E+01, 3.8298805436E+00, 9.7673845722E-01],
	[4.4200000000E+04, 4.0439818731E+01, 5.2331515711E+00, 2.2092608849E+01, 3.8302208749E+00, 9.7674815828E-01],
	[4.4205000000E+04, 4.0447893214E+01, 5.2331936341E+00, 2.2100771709E+01, 3.8305611228E+00, 9.7675785471E-01],
	[4.4210000000E+04, 4.0455968396E+01, 5.2332356926E+00, 2.2108936661E+01, 3.8309012874E+00, 9.7676754651E-01],
	[4.4215000000E+04, 4.0464044277E+01, 5.2332777467E+00, 2.2117103704E+01, 3.8312413687E+00, 9.7677723369E-01],
	[4.4220000000E+04, 4.0472120856E+01, 5.2333197964E+00, 2.2125272839E+01, 3.8315813668E+00, 9.7678691624E-01],
	[4.4225000000E+04, 4.0480198135E+01, 5.2333618417E+00, 2.2133444066E+01, 3.8319212816E+00, 9.7679659418E-01],
	[4.4230000000E+04, 4.0488276111E+01, 5.2334038826E+00, 2.2141617385E+01, 3.8322611131E+00, 9.7680626750E-01],
	[4.4235000000E+04, 4.0496354786E+01, 5.2334459191E+00, 2.2149792797E+01, 3.8326008614E+00, 9.7681593620E-01],
	[4.4240000000E+04, 4.0504434160E+01, 5.2334879511E+00, 2.2157970302E+01, 3.8329405266E+00, 9.7682560029E-01],
	[4.4245000000E+04, 4.0512514233E+01, 5.2335299788E+00, 2.2166149900E+01, 3.8332801085E+00, 9.7683525977E-01],
	[4.4250000000E+04, 4.0520595004E+01, 5.2335720020E+00, 2.2174331592E+01, 3.8336196073E+00, 9.7684491463E-01],
	[4.4255000000E+04, 4.0528676473E+01, 5.2336140208E+00, 2.2182515377E+01, 3.8339590230E+00, 9.7685456490E-01],
	[4.4260000000E+04, 4.0536758641E+01, 5.2336560352E+00, 2.2190701257E+01, 3.8342983555E+00, 9.7686421056E-01],
	[4.4265000000E+04, 4.0544841507E+01, 5.2336980452E+00, 2.2198889231E+01, 3.8346376050E+00, 9.7687385162E-01],
	[4.4270000000E+04, 4.0552925072E+01, 5.2337400508E+00, 2.2207079300E+01, 3.8349767714E+00, 9.7688348808E-01],
	[4.4275000000E+04, 4.0561009336E+01, 5.2337820519E+00, 2.2215271464E+01, 3.8353158547E+00, 9.7689311995E-01],
	[4.4280000000E+04, 4.0569094297E+01, 5.2338240487E+00, 2.2223465723E+01, 3.8356548550E+00, 9.7690274722E-01],
	[4.4285000000E+04, 4.0577179957E+01, 5.2338660411E+00, 2.2231662078E+01, 3.8359937723E+00, 9.7691236990E-01],
	[4.4290000000E+04, 4.0585266316E+01, 5.2339080290E+00, 2.2239860528E+01, 3.8363326066E+00, 9.7692198800E-01],
	[4.4295000000E+04, 4.0593353373E+01, 5.2339500126E+00, 2.2248061075E+01, 3.8366713579E+00, 9.7693160150E-01],
	[4.4300000000E+04, 4.0601441128E+01, 5.2339919918E+00, 2.2256263719E+01, 3.8370100263E+00, 9.7694121043E-01],
	[4.4305000000E+04, 4.0609529582E+01, 5.2340339665E+00, 2.2264468459E+01, 3.8373486117E+00, 9.7695081477E-01],
	[4.4310000000E+04, 4.0617618734E+01, 5.2340759369E+00, 2.2272675296E+01, 3.8376871142E+00, 9.7696041453E-01],
	[4.4315000000E+04, 4.0625708584E+01, 5.2341179028E+00, 2.2280884231E+01, 3.8380255338E+00, 9.7697000972E-01],
	[4.4320000000E+04, 4.0633799132E+01, 5.2341598644E+00, 2.2289095264E+01, 3.8383638706E+00, 9.7697960033E-01],
	[4.4325000000E+04, 4.0641890379E+01, 5.2342018216E+00, 2.2297308394E+01, 3.8387021245E+00, 9.7698918637E-01],
	[4.4330000000E+04, 4.0649982324E+01, 5.2342437743E+00, 2.2305523623E+01, 3.8390402956E+00, 9.7699876784E-01],
	[4.4335000000E+04, 4.0658074967E+01, 5.2342857227E+00, 2.2313740951E+01, 3.8393783839E+00, 9.7700834475E-01],
	[4.4340000000E+04, 4.0666168309E+01, 5.2343276667E+00, 2.2321960377E+01, 3.8397163893E+00, 9.7701791709E-01],
	[4.4345000000E+04, 4.0674262348E+01, 5.2343696062E+00, 2.2330181903E+01, 3.8400543121E+00, 9.7702748487E-01],
	[4.4350000000E+04, 4.0682357086E+01, 5.2344115414E+00, 2.2338405528E+01, 3.8403921520E+00, 9.7703704809E-01],
	[4.4355000000E+04, 4.0690452522E+01, 5.2344534722E+00, 2.2346631253E+01, 3.8407299093E+00, 9.7704660676E-01],
	[4.4360000000E+04, 4.0698548656E+01, 5.2344953986E+00, 2.2354859078E+01, 3.8410675838E+00, 9.7705616087E-01],
	[4.4365000000E+04, 4.0706645488E+01, 5.2345373207E+00, 2.2363089003E+01, 3.8414051756E+00, 9.7706571043E-01],
	[4.4370000000E+04, 4.0714743018E+01, 5.2345792383E+00, 2.2371321029E+01, 3.8417426848E+00, 9.7707525543E-01],
	[4.4375000000E+04, 4.0722841246E+01, 5.2346211515E+00, 2.2379555157E+01, 3.8420801113E+00, 9.7708479589E-01],
	[4.4380000000E+04, 4.0730940173E+01, 5.2346630604E+00, 2.2387791385E+01, 3.8424174552E+00, 9.7709433181E-01],
	[4.4385000000E+04, 4.0739039797E+01, 5.2347049649E+00, 2.2396029715E+01, 3.8427547165E+00, 9.7710386319E-01],
	[4.4390000000E+04, 4.0747140119E+01, 5.2347468649E+00, 2.2404270147E+01, 3.8430918952E+00, 9.7711339002E-01],
	[4.4395000000E+04, 4.0755241140E+01, 5.2347887606E+00, 2.2412512681E+01, 3.8434289913E+00, 9.7712291232E-01],
	[4.4400000000E+04, 4.0763342858E+01, 5.2348306520E+00, 2.2420757318E+01, 3.8437660049E+00, 9.7713243008E-01],
	[4.4405000000E+04, 4.0771445274E+01, 5.2348725389E+00, 2.2429004058E+01, 3.8441029360E+00, 9.7714194331E-01],
	[4.4410000000E+04, 4.0779548389E+01, 5.2349144214E+00, 2.2437252900E+01, 3.8444397845E+00, 9.7715145201E-01],
	[4.4415000000E+04, 4.0787652201E+01, 5.2349562996E+00, 2.2445503846E+01, 3.8447765506E+00, 9.7716095618E-01],
	[4.4420000000E+04, 4.0795756711E+01, 5.2349981734E+00, 2.2453756896E+01, 3.8451132342E+00, 9.7717045583E-01],
	[4.4425000000E+04, 4.0803861919E+01, 5.2350400428E+00, 2.2462012050E+01, 3.8454498353E+00, 9.7717995095E-01],
	[4.4430000000E+04, 4.0811967825E+01, 5.2350819079E+00, 2.2470269308E+01, 3.8457863541E+00, 9.7718944155E-01],
	[4.4435000000E+04, 4.0820074428E+01, 5.2351237685E+00, 2.2478528670E+01, 3.8461227904E+00, 9.7719892764E-01],
	[4.4440000000E+04, 4.0828181730E+01, 5.2351656248E+00, 2.2486790138E+01, 3.8464591444E+00, 9.7720840921E-01],
	[4.4445000000E+04, 4.0836289729E+01, 5.2352074767E+00, 2.2495053711E+01, 3.8467954159E+00, 9.7721788626E-01],
	[4.4450000000E+04, 4.0844398426E+01, 5.2352493243E+00, 2.2503319389E+01, 3.8471316052E+00, 9.7722735881E-01],
	[4.4455000000E+04, 4.0852507821E+01, 5.2352911674E+00, 2.2511587173E+01, 3.8474677121E+00, 9.7723682685E-01],
	[4.4460000000E+04, 4.0860617914E+01, 5.2353330062E+00, 2.2519857063E+01, 3.8478037367E+00, 9.7724629038E-01],
	[4.4465000000E+04, 4.0868728704E+01, 5.2353748407E+00, 2.2528129059E+01, 3.8481396790E+00, 9.7725574940E-01],
	[4.4470000000E+04, 4.0876840193E+01, 5.2354166707E+00, 2.2536403163E+01, 3.8484755391E+00, 9.7726520393E-01],
	[4.4475000000E+04, 4.0884952378E+01, 5.2354584964E+00, 2.2544679373E+01, 3.8488113169E+00, 9.7727465396E-01],
	[4.4480000000E+04, 4.0893065262E+01, 5.2355003177E+00, 2.2552957690E+01, 3.8491470125E+00, 9.7728409949E-01],
	[4.4485000000E+04, 4.0901178843E+01, 5.2355421347E+00, 2.2561238115E+01, 3.8494826260E+00, 9.7729354053E-01],
	[4.4490000000E+04, 4.0909293122E+01, 5.2355839472E+00, 2.2569520648E+01, 3.8498181572E+00, 9.7730297707E-01],
	[4.4495000000E+04, 4.0917408098E+01, 5.2356257555E+00, 2.2577805289E+01, 3.8501536062E+00, 9.7731240913E-01],
	[4.4500000000E+04, 4.0925523773E+01, 5.2356675593E+00, 2.2586092039E+01, 3.8504889732E+00, 9.7732183670E-01],
	[4.4505000000E+04, 4.0933640144E+01, 5.2357093588E+00, 2.2594380897E+01, 3.8508242580E+00, 9.7733125979E-01],
	[4.4510000000E+04, 4.0941757213E+01, 5.2357511539E+00, 2.2602671865E+01, 3.8511594607E+00, 9.7734067839E-01],
	[4.4515000000E+04, 4.0949874980E+01, 5.2357929447E+00, 2.2610964942E+01, 3.8514945813E+00, 9.7735009252E-01],
	[4.4520000000E+04, 4.0957993445E+01, 5.2358347311E+00, 2.2619260128E+01, 3.8518296198E+00, 9.7735950217E-01],
	[4.4525000000E+04, 4.0966112606E+01, 5.2358765132E+00, 2.2627557425E+01, 3.8521645764E+00, 9.7736890734E-01],
	[4.4530000000E+04, 4.0974232466E+01, 5.2359182909E+00, 2.2635856831E+01, 3.8524994509E+00, 9.7737830804E-01],
	[4.4535000000E+04, 4.0982353023E+01, 5.2359600642E+00, 2.2644158349E+01, 3.8528342434E+00, 9.7738770427E-01],
	[4.4540000000E+04, 4.0990474277E+01, 5.2360018332E+00, 2.2652461977E+01, 3.8531689539E+00, 9.7739709604E-01],
	[4.4545000000E+04, 4.0998596229E+01, 5.2360435978E+00, 2.2660767716E+01, 3.8535035824E+00, 9.7740648334E-01],
	[4.4550000000E+04, 4.1006718878E+01, 5.2360853581E+00, 2.2669075567E+01, 3.8538381291E+00, 9.7741586617E-01],
	[4.4555000000E+04, 4.1014842224E+01, 5.2361271140E+00, 2.2677385530E+01, 3.8541725938E+00, 9.7742524455E-01],
	[4.4560000000E+04, 4.1022966268E+01, 5.2361688656E+00, 2.2685697605E+01, 3.8545069766E+00, 9.7743461847E-01],
	[4.4565000000E+04, 4.1031091010E+01, 5.2362106128E+00, 2.2694011792E+01, 3.8548412775E+00, 9.7744398793E-01],
	[4.4570000000E+04, 4.1039216448E+01, 5.2362523556E+00, 2.2702328092E+01, 3.8551754966E+00, 9.7745335294E-01],
	[4.4575000000E+04, 4.1047342584E+01, 5.2362940941E+00, 2.2710646504E+01, 3.8555096338E+00, 9.7746271350E-01],
	[4.4580000000E+04, 4.1055469418E+01, 5.2363358283E+00, 2.2718967030E+01, 3.8558436893E+00, 9.7747206961E-01],
	[4.4585000000E+04, 4.1063599974E+01, 5.2363779072E+00, 2.2727289670E+01, 3.8561778789E+00, 9.7748142128E-01],
	[4.4590000000E+04, 4.1071744591E+01, 5.2364215230E+00, 2.2735614424E+01, 3.8565129406E+00, 9.7749076850E-01],
	[4.4595000000E+04, 4.1079889910E+01, 5.2364651343E+00, 2.2743941291E+01, 3.8568479208E+00, 9.7750011128E-01],
	[4.4600000000E+04, 4.1088035931E+01, 5.2365087411E+00, 2.2752270273E+01, 3.8571828194E+00, 9.7750944962E-01],
	[4.4605000000E+04, 4.1096182653E+01, 5.2365523434E+00, 2.2760601370E+01, 3.8575176365E+00, 9.7751878353E-01],
	[4.4610000000E+04, 4.1104330078E+01, 5.2365959411E+00, 2.2768934582E+01, 3.8578523721E+00, 9.7752811300E-01],
	[4.4615000000E+04, 4.1112478204E+01, 5.2366395344E+00, 2.2777269910E+01, 3.8581870262E+00, 9.7753743804E-01],
	[4.4620000000E+04, 4.1120627033E+01, 5.2366831231E+00, 2.2785607353E+01, 3.8585215989E+00, 9.7754675865E-01],
	[4.4625000000E+04, 4.1128776563E+01, 5.2367267072E+00, 2.2793946912E+01, 3.8588560902E+00, 9.7755607484E-01],
	[4.4630000000E+04, 4.1136926795E+01, 5.2367702869E+00, 2.2802288587E+01, 3.8591905000E+00, 9.7756538660E-01],
	[4.4635000000E+04, 4.1145077728E+01, 5.2368138620E+00, 2.2810632379E+01, 3.8595248285E+00, 9.7757469394E-01],
	[4.4640000000E+04, 4.1153229363E+01, 5.2368574326E+00, 2.2818978287E+01, 3.8598590755E+00, 9.7758399685E-01],
	[4.4645000000E+04, 4.1161381701E+01, 5.2369009987E+00, 2.2827326313E+01, 3.8601932412E+00, 9.7759329536E-01],
	[4.4650000000E+04, 4.1169534739E+01, 5.2369445603E+00, 2.2835676456E+01, 3.8605273256E+00, 9.7760258944E-01],
	[4.4655000000E+04, 4.1177688480E+01, 5.2369881174E+00, 2.2844028717E+01, 3.8608613287E+00, 9.7761187912E-01],
	[4.4660000000E+04, 4.1185842922E+01, 5.2370316699E+00, 2.2852383097E+01, 3.8611952504E+00, 9.7762116438E-01],
	[4.4665000000E+04, 4.1193998066E+01, 5.2370752180E+00, 2.2860739594E+01, 3.8615290909E+00, 9.7763044524E-01],
	[4.4670000000E+04, 4.1202153911E+01, 5.2371187615E+00, 2.2869098210E+01, 3.8618628502E+00, 9.7763972169E-01],
	[4.4675000000E+04, 4.1210310458E+01, 5.2371623005E+00, 2.2877458945E+01, 3.8621965282E+00, 9.7764899374E-01],
	[4.4680000000E+04, 4.1218467707E+01, 5.2372058350E+00, 2.2885821800E+01, 3.8625301250E+00, 9.7765826139E-01],
	[4.4685000000E+04, 4.1226625657E+01, 5.2372493650E+00, 2.2894186774E+01, 3.8628636406E+00, 9.7766752464E-01],
	[4.4690000000E+04, 4.1234784309E+01, 5.2372928905E+00, 2.2902553867E+01, 3.8631970750E+00, 9.7767678349E-01],
	[4.4695000000E+04, 4.1242943663E+01, 5.2373364115E+00, 2.2910923081E+01, 3.8635304283E+00, 9.7768603795E-01],
	[4.4700000000E+04, 4.1251103718E+01, 5.2373799279E+00, 2.2919294416E+01, 3.8638637004E+00, 9.7769528802E-01],
	[4.4705000000E+04, 4.1259264474E+01, 5.2374234399E+00, 2.2927667871E+01, 3.8641968914E+00, 9.7770453370E-01],
	[4.4710000000E+04, 4.1267425932E+01, 5.2374669473E+00, 2.2936043447E+01, 3.8645300014E+00, 9.7771377499E-01],
	[4.4715000000E+04, 4.1275588092E+01, 5.2375104503E+00, 2.2944421145E+01, 3.8648630302E+00, 9.7772301191E-01],
	[4.4720000000E+04, 4.1283750953E+01, 5.2375539488E+00, 2.2952800964E+01, 3.8651959780E+00, 9.7773224443E-01],
	[4.4725000000E+04, 4.1291914515E+01, 5.2375974427E+00, 2.2961182905E+01, 3.8655288448E+00, 9.7774147258E-01],
	[4.4730000000E+04, 4.1300078779E+01, 5.2376409322E+00, 2.2969566969E+01, 3.8658616306E+00, 9.7775069636E-01],
	[4.4735000000E+04, 4.1308243744E+01, 5.2376844171E+00, 2.2977953155E+01, 3.8661943354E+00, 9.7775991575E-01],
	[4.4740000000E+04, 4.1316409411E+01, 5.2377278976E+00, 2.2986341464E+01, 3.8665269592E+00, 9.7776913078E-01],
	[4.4745000000E+04, 4.1324575779E+01, 5.2377713735E+00, 2.2994731896E+01, 3.8668595020E+00, 9.7777834144E-01],
	[4.4750000000E+04, 4.1332742848E+01, 5.2378148450E+00, 2.3003124451E+01, 3.8671919639E+00, 9.7778754773E-01],
	[4.4755000000E+04, 4.1340910618E+01, 5.2378583119E+00, 2.3011519130E+01, 3.8675243449E+00, 9.7779674965E-01],
	[4.4760000000E+04, 4.1349079090E+01, 5.2379017744E+00, 2.3019915934E+01, 3.8678566450E+00, 9.7780594721E-01],
	[4.4765000000E+04, 4.1357248264E+01, 5.2379452324E+00, 2.3028314861E+01, 3.8681888643E+00, 9.7781514041E-01],
	[4.4770000000E+04, 4.1365418138E+01, 5.2379886858E+00, 2.3036715914E+01, 3.8685210026E+00, 9.7782432926E-01],
	[4.4775000000E+04, 4.1373588714E+01, 5.2380321348E+00, 2.3045119091E+01, 3.8688530602E+00, 9.7783351374E-01],
	[4.4780000000E+04, 4.1381759991E+01, 5.2380755793E+00, 2.3053524393E+01, 3.8691850369E+00, 9.7784269388E-01],
	[4.4785000000E+04, 4.1389931969E+01, 5.2381190193E+00, 2.3061931821E+01, 3.8695169329E+00, 9.7785186966E-01],
	[4.4790000000E+04, 4.1398104649E+01, 5.2381624548E+00, 2.3070341375E+01, 3.8698487480E+00, 9.7786104110E-01],
	[4.4795000000E+04, 4.1406278030E+01, 5.2382058858E+00, 2.3078753055E+01, 3.8701804825E+00, 9.7787020818E-01],
	[4.4800000000E+04, 4.1414452111E+01, 5.2382493124E+00, 2.3087166862E+01, 3.8705121362E+00, 9.7787937093E-01],
	[4.4805000000E+04, 4.1422626894E+01, 5.2382927344E+00, 2.3095582795E+01, 3.8708437091E+00, 9.7788852933E-01],
	[4.4810000000E+04, 4.1430802379E+01, 5.2383361520E+00, 2.3104000856E+01, 3.8711752014E+00, 9.7789768340E-01],
	[4.4815000000E+04, 4.1438978564E+01, 5.2383795651E+00, 2.3112421043E+01, 3.8715066130E+00, 9.7790683312E-01],
	[4.4820000000E+04, 4.1447155450E+01, 5.2384229737E+00, 2.3120843359E+01, 3.8718379440E+00, 9.7791597852E-01],
	[4.4825000000E+04, 4.1455333038E+01, 5.2384663778E+00, 2.3129267802E+01, 3.8721691943E+00, 9.7792511958E-01],
	[4.4830000000E+04, 4.1463511326E+01, 5.2385097774E+00, 2.3137694373E+01, 3.8725003641E+00, 9.7793425631E-01],
	[4.4835000000E+04, 4.1471690316E+01, 5.2385531726E+00, 2.3146123073E+01, 3.8728314532E+00, 9.7794338871E-01],
	[4.4840000000E+04, 4.1479870006E+01, 5.2385965632E+00, 2.3154553902E+01, 3.8731624618E+00, 9.7795251679E-01],
	[4.4845000000E+04, 4.1488050398E+01, 5.2386399494E+00, 2.3162986860E+01, 3.8734933898E+00, 9.7796164055E-01],
	[4.4850000000E+04, 4.1496231490E+01, 5.2386833312E+00, 2.3171421948E+01, 3.8738242372E+00, 9.7797075998E-01],
	[4.4855000000E+04, 4.1504413284E+01, 5.2387267084E+00, 2.3179859165E+01, 3.8741550042E+00, 9.7797987510E-01],
	[4.4860000000E+04, 4.1512595778E+01, 5.2387700812E+00, 2.3188298512E+01, 3.8744856907E+00, 9.7798898590E-01],
	[4.4865000000E+04, 4.1520778974E+01, 5.2388134494E+00, 2.3196739990E+01, 3.8748162967E+00, 9.7799809239E-01],
	[4.4870000000E+04, 4.1528962870E+01, 5.2388568133E+00, 2.3205183598E+01, 3.8751468222E+00, 9.7800719457E-01],
	[4.4875000000E+04, 4.1537147468E+01, 5.2389001726E+00, 2.3213629338E+01, 3.8754772674E+00, 9.7801629244E-01],
	[4.4880000000E+04, 4.1545332766E+01, 5.2389435275E+00, 2.3222077208E+01, 3.8758076321E+00, 9.7802538600E-01],
	[4.4885000000E+04, 4.1553518765E+01, 5.2389868779E+00, 2.3230527210E+01, 3.8761379164E+00, 9.7803447526E-01],
	[4.4890000000E+04, 4.1561705465E+01, 5.2390302238E+00, 2.3238979344E+01, 3.8764681203E+00, 9.7804356022E-01],
	[4.4895000000E+04, 4.1569892865E+01, 5.2390735652E+00, 2.3247433610E+01, 3.8767982439E+00, 9.7805264088E-01],
	[4.4900000000E+04, 4.1578080967E+01, 5.2391169022E+00, 2.3255890009E+01, 3.8771282872E+00, 9.7806171724E-01],
	[4.4905000000E+04, 4.1586269769E+01, 5.2391602348E+00, 2.3264348540E+01, 3.8774582502E+00, 9.7807078930E-01],
	[4.4910000000E+04, 4.1594459272E+01, 5.2392035628E+00, 2.3272809204E+01, 3.8777881328E+00, 9.7807985708E-01],
	[4.4915000000E+04, 4.1602649476E+01, 5.2392468864E+00, 2.3281272002E+01, 3.8781179352E+00, 9.7808892056E-01],
	[4.4920000000E+04, 4.1610840380E+01, 5.2392902055E+00, 2.3289736933E+01, 3.8784476574E+00, 9.7809797976E-01],
	[4.4925000000E+04, 4.1619031986E+01, 5.2393335202E+00, 2.3298203998E+01, 3.8787772993E+00, 9.7810703467E-01],
	[4.4930000000E+04, 4.1627224292E+01, 5.2393768304E+00, 2.3306673198E+01, 3.8791068610E+00, 9.7811608530E-01],
	[4.4935000000E+04, 4.1635417298E+01, 5.2394201361E+00, 2.3315144532E+01, 3.8794363425E+00, 9.7812513164E-01],
	[4.4940000000E+04, 4.1643611006E+01, 5.2394634374E+00, 2.3323618001E+01, 3.8797657439E+00, 9.7813417371E-01],
	[4.4945000000E+04, 4.1651805414E+01, 5.2395067342E+00, 2.3332093605E+01, 3.8800950650E+00, 9.7814321151E-01],
	[4.4950000000E+04, 4.1660000522E+01, 5.2395500266E+00, 2.3340571344E+01, 3.8804243061E+00, 9.7815224503E-01],
	[4.4955000000E+04, 4.1668196331E+01, 5.2395933145E+00, 2.3349051219E+01, 3.8807534671E+00, 9.7816127427E-01],
	[4.4960000000E+04, 4.1676392841E+01, 5.2396365979E+00, 2.3357533231E+01, 3.8810825479E+00, 9.7817029925E-01],
	[4.4965000000E+04, 4.1684590052E+01, 5.2396798769E+00, 2.3366017378E+01, 3.8814115487E+00, 9.7817931996E-01],
	[4.4970000000E+04, 4.1692787962E+01, 5.2397231515E+00, 2.3374503663E+01, 3.8817404695E+00, 9.7818833641E-01],
	[4.4975000000E+04, 4.1700986574E+01, 5.2397664216E+00, 2.3382992084E+01, 3.8820693102E+00, 9.7819734860E-01],
	[4.4980000000E+04, 4.1709185886E+01, 5.2398096872E+00, 2.3391482642E+01, 3.8823980709E+00, 9.7820635652E-01],
	[4.4985000000E+04, 4.1717385898E+01, 5.2398529484E+00, 2.3399975338E+01, 3.8827267516E+00, 9.7821536019E-01],
	[4.4990000000E+04, 4.1725586611E+01, 5.2398962051E+00, 2.3408470172E+01, 3.8830553523E+00, 9.7822435961E-01],
	[4.4995000000E+04, 4.1733788025E+01, 5.2399394574E+00, 2.3416967144E+01, 3.8833838731E+00, 9.7823335477E-01],
	[4.5000000000E+04, 4.1741990139E+01, 5.2399827052E+00, 2.3425466254E+01, 3.8837123140E+00, 9.7824234568E-01],
	[4.5005000000E+04, 4.1750192953E+01, 5.2400259486E+00, 2.3433985707E+01, 3.8840411750E+00, 9.7825133234E-01],
	[4.5010000000E+04, 4.1758396468E+01, 5.2400691875E+00, 2.3442507310E+01, 3.8843699558E+00, 9.7826031475E-01],
	[4.5015000000E+04, 4.1766600683E+01, 5.2401124220E+00, 2.3451031063E+01, 3.8846986566E+00, 9.7826929293E-01],
	[4.5020000000E+04, 4.1774805599E+01, 5.2401556520E+00, 2.3459556968E+01, 3.8850272773E+00, 9.7827826686E-01],
	[4.5025000000E+04, 4.1783011214E+01, 5.2401988776E+00, 2.3468085023E+01, 3.8853558178E+00, 9.7828723655E-01],
	[4.5030000000E+04, 4.1791217531E+01, 5.2402420988E+00, 2.3476615230E+01, 3.8856842783E+00, 9.7829620201E-01],
	[4.5035000000E+04, 4.1799424547E+01, 5.2402853155E+00, 2.3485147589E+01, 3.8860126588E+00, 9.7830516323E-01],
	[4.5040000000E+04, 4.1807632264E+01, 5.2403285277E+00, 2.3493682100E+01, 3.8863409593E+00, 9.7831412022E-01],
	[4.5045000000E+04, 4.1815840681E+01, 5.2403717356E+00, 2.3502218763E+01, 3.8866691797E+00, 9.7832307298E-01],
	[4.5050000000E+04, 4.1824049799E+01, 5.2404149390E+00, 2.3510757579E+01, 3.8869973202E+00, 9.7833202151E-01],
	[4.5055000000E+04, 4.1832259616E+01, 5.2404581379E+00, 2.3519298548E+01, 3.8873253808E+00, 9.7834096582E-01],
	[4.5060000000E+04, 4.1840470134E+01, 5.2405013324E+00, 2.3527841670E+01, 3.8876533613E+00, 9.7834990590E-01],
	[4.5065000000E+04, 4.1848681352E+01, 5.2405445225E+00, 2.3536386946E+01, 3.8879812620E+00, 9.7835884176E-01],
	[4.5070000000E+04, 4.1856893271E+01, 5.2405877081E+00, 2.3544934376E+01, 3.8883090828E+00, 9.7836777341E-01],
	[4.5075000000E+04, 4.1865105889E+01, 5.2406308893E+00, 2.3553483960E+01, 3.8886368237E+00, 9.7837670084E-01],
	[4.5080000000E+04, 4.1873319208E+01, 5.2406740661E+00, 2.3562035698E+01, 3.8889644847E+00, 9.7838562406E-01],
	[4.5085000000E+04, 4.1881533226E+01, 5.2407172384E+00, 2.3570589591E+01, 3.8892920659E+00, 9.7839454306E-01],
	[4.5090000000E+04, 4.1889747945E+01, 5.2407604064E+00, 2.3579145640E+01, 3.8896195673E+00, 9.7840345786E-01],
	[4.5095000000E+04, 4.1897963364E+01, 5.2408035698E+00, 2.3587703844E+01, 3.8899469889E+00, 9.7841236844E-01],
	[4.5100000000E+04, 4.1906179483E+01, 5.2408467289E+00, 2.3596264203E+01, 3.8902743307E+00, 9.7842127483E-01],
	[4.5105000000E+04, 4.1914396303E+01, 5.2408898835E+00, 2.3604826719E+01, 3.8906015927E+00, 9.7843017701E-01],
	[4.5110000000E+04, 4.1922613822E+01, 5.2409330337E+00, 2.3613391391E+01, 3.8909287750E+00, 9.7843907499E-01],
	[4.5115000000E+04, 4.1930832041E+01, 5.2409761794E+00, 2.3621958220E+01, 3.8912558776E+00, 9.7844796878E-01],
	[4.5120000000E+04, 4.1939050960E+01, 5.2410193208E+00, 2.3630527205E+01, 3.8915829005E+00, 9.7845685837E-01],
	[4.5125000000E+04, 4.1947270580E+01, 5.2410624577E+00, 2.3639098348E+01, 3.8919098437E+00, 9.7846574377E-01],
	[4.5130000000E+04, 4.1955490899E+01, 5.2411055902E+00, 2.3647671649E+01, 3.8922367072E+00, 9.7847462497E-01],
	[4.5135000000E+04, 4.1963711918E+01, 5.2411487182E+00, 2.3656247107E+01, 3.8925634912E+00, 9.7848350199E-01],
	[4.5140000000E+04, 4.1971933637E+01, 5.2411918418E+00, 2.3664824723E+01, 3.8928901954E+00, 9.7849237482E-01],
	[4.5145000000E+04, 4.1980156057E+01, 5.2412349611E+00, 2.3673404498E+01, 3.8932168201E+00, 9.7850124347E-01],
	[4.5150000000E+04, 4.1988379176E+01, 5.2412780759E+00, 2.3681986432E+01, 3.8935433653E+00, 9.7851010794E-01],
	[4.5155000000E+04, 4.1996602994E+01, 5.2413211862E+00, 2.3690570525E+01, 3.8938698308E+00, 9.7851896822E-01],
	[4.5160000000E+04, 4.2004827513E+01, 5.2413642922E+00, 2.3699156777E+01, 3.8941962169E+00, 9.7852782433E-01],
	[4.5165000000E+04, 4.2013052732E+01, 5.2414073937E+00, 2.3707745188E+01, 3.8945225234E+00, 9.7853667627E-01],
	[4.5170000000E+04, 4.2021278650E+01, 5.2414504908E+00, 2.3716335760E+01, 3.8948487504E+00, 9.7854552403E-01],
	[4.5175000000E+04, 4.2029505269E+01, 5.2414935836E+00, 2.3724928492E+01, 3.8951748979E+00, 9.7855436761E-01],
	[4.5180000000E+04, 4.2037732587E+01, 5.2415366718E+00, 2.3733523385E+01, 3.8955009660E+00, 9.7856320703E-01],
	[4.5185000000E+04, 4.2045960605E+01, 5.2415797557E+00, 2.3742120439E+01, 3.8958269546E+00, 9.7857204228E-01],
	[4.5190000000E+04, 4.2054189322E+01, 5.2416228352E+00, 2.3750719653E+01, 3.8961528639E+00, 9.7858087337E-01],
	[4.5195000000E+04, 4.2062418740E+01, 5.2416659102E+00, 2.3759321030E+01, 3.8964786937E+00, 9.7858970029E-01],
	[4.5200000000E+04, 4.2070648857E+01, 5.2417089809E+00, 2.3767924568E+01, 3.8968044441E+00, 9.7859852304E-01],
	[4.5205000000E+04, 4.2078879674E+01, 5.2417520471E+00, 2.3776530268E+01, 3.8971301152E+00, 9.7860734164E-01],
	[4.5210000000E+04, 4.2087111190E+01, 5.2417951089E+00, 2.3785138130E+01, 3.8974557070E+00, 9.7861615608E-01],
	[4.5215000000E+04, 4.2095343406E+01, 5.2418381663E+00, 2.3793748156E+01, 3.8977812194E+00, 9.7862496637E-01],
	[4.5220000000E+04, 4.2103576322E+01, 5.2418812193E+00, 2.3802360344E+01, 3.8981066526E+00, 9.7863377250E-01],
	[4.5225000000E+04, 4.2111809938E+01, 5.2419242679E+00, 2.3810974696E+01, 3.8984320064E+00, 9.7864257448E-01],
	[4.5230000000E+04, 4.2120044253E+01, 5.2419673121E+00, 2.3819591211E+01, 3.8987572810E+00, 9.7865137231E-01],
	[4.5235000000E+04, 4.2128279268E+01, 5.2420103519E+00, 2.3828209890E+01, 3.8990824764E+00, 9.7866016599E-01],
	[4.5240000000E+04, 4.2136514982E+01, 5.2420533873E+00, 2.3836830734E+01, 3.8994075925E+00, 9.7866895552E-01],
	[4.5245000000E+04, 4.2144751396E+01, 5.2420964183E+00, 2.3845453742E+01, 3.8997326295E+00, 9.7867774092E-01],
	[4.5250000000E+04, 4.2152988509E+01, 5.2421394449E+00, 2.3854078914E+01, 3.9000575873E+00, 9.7868652217E-01],
	[4.5255000000E+04, 4.2161226322E+01, 5.2421824670E+00, 2.3862706252E+01, 3.9003824659E+00, 9.7869529928E-01],
	[4.5260000000E+04, 4.2169464835E+01, 5.2422254848E+00, 2.3871335756E+01, 3.9007072654E+00, 9.7870407225E-01],
	[4.5265000000E+04, 4.2177704047E+01, 5.2422684982E+00, 2.3879967425E+01, 3.9010319857E+00, 9.7871284109E-01],
	[4.5270000000E+04, 4.2185943958E+01, 5.2423115072E+00, 2.3888601260E+01, 3.9013566270E+00, 9.7872160579E-01],
	[4.5275000000E+04, 4.2194184569E+01, 5.2423545117E+00, 2.3897237262E+01, 3.9016811892E+00, 9.7873036637E-01],
	[4.5280000000E+04, 4.2202425880E+01, 5.2423975119E+00, 2.3905875430E+01, 3.9020056723E+00, 9.7873912281E-01],
	[4.5285000000E+04, 4.2210667889E+01, 5.2424405077E+00, 2.3914515765E+01, 3.9023300764E+00, 9.7874787513E-01],
	[4.5290000000E+04, 4.2218910599E+01, 5.2424834991E+00, 2.3923158268E+01, 3.9026544015E+00, 9.7875662332E-01],
	[4.5295000000E+04, 4.2227154007E+01, 5.2425264861E+00, 2.3931802938E+01, 3.9029786476E+00, 9.7876536738E-01],
	[4.5300000000E+04, 4.2235398115E+01, 5.2425694687E+00, 2.3940449776E+01, 3.9033028147E+00, 9.7877410733E-01],
	[4.5305000000E+04, 4.2243653295E+01, 5.2426136232E+00, 2.3949098782E+01, 3.9036276436E+00, 9.7878284315E-01],
	[4.5310000000E+04, 4.2251915111E+01, 5.2426584462E+00, 2.3957749957E+01, 3.9039528175E+00, 9.7879157486E-01],
	[4.5315000000E+04, 4.2260177632E+01, 5.2427032646E+00, 2.3966403300E+01, 3.9042779126E+00, 9.7880030246E-01],
	[4.5320000000E+04, 4.2268440857E+01, 5.2427480785E+00, 2.3975058813E+01, 3.9046029291E+00, 9.7880902594E-01],
	[4.5325000000E+04, 4.2276704785E+01, 5.2427928878E+00, 2.3983716494E+01, 3.9049278668E+00, 9.7881774530E-01],
	[4.5330000000E+04, 4.2284969418E+01, 5.2428376925E+00, 2.3992376346E+01, 3.9052527259E+00, 9.7882646056E-01],
	[4.5335000000E+04, 4.2293234754E+01, 5.2428824927E+00, 2.4001038368E+01, 3.9055775064E+00, 9.7883517171E-01],
	[4.5340000000E+04, 4.2301500794E+01, 5.2429272883E+00, 2.4009702560E+01, 3.9059022082E+00, 9.7884387876E-01],
	[4.5345000000E+04, 4.2309767538E+01, 5.2429720794E+00, 2.4018368922E+01, 3.9062268314E+00, 9.7885258170E-01],
	[4.5350000000E+04, 4.2318034985E+01, 5.2430168659E+00, 2.4027037456E+01, 3.9065513760E+00, 9.7886128055E-01],
	[4.5355000000E+04, 4.2326303137E+01, 5.2430616478E+00, 2.4035708160E+01, 3.9068758421E+00, 9.7886997529E-01],
	[4.5360000000E+04, 4.2334571992E+01, 5.2431064252E+00, 2.4044381037E+01, 3.9072002295E+00, 9.7887866593E-01],
	[4.5365000000E+04, 4.2342841550E+01, 5.2431511981E+00, 2.4053056085E+01, 3.9075245385E+00, 9.7888735248E-01],
	[4.5370000000E+04, 4.2351111813E+01, 5.2431959664E+00, 2.4061733305E+01, 3.9078487690E+00, 9.7889603494E-01],
	[4.5375000000E+04, 4.2359382779E+01, 5.2432407301E+00, 2.4070412698E+01, 3.9081729209E+00, 9.7890471331E-01],
	[4.5380000000E+04, 4.2367654449E+01, 5.2432854893E+00, 2.4079094263E+01, 3.9084969944E+00, 9.7891338758E-01],
	[4.5385000000E+04, 4.2375926822E+01, 5.2433302440E+00, 2.4087778001E+01, 3.9088209894E+00, 9.7892205777E-01],
	[4.5390000000E+04, 4.2384199899E+01, 5.2433749940E+00, 2.4096463913E+01, 3.9091449060E+00, 9.7893072388E-01],
	[4.5395000000E+04, 4.2392473680E+01, 5.2434197396E+00, 2.4105151999E+01, 3.9094687442E+00, 9.7893938590E-01],
	[4.5400000000E+04, 4.2400748164E+01, 5.2434644806E+00, 2.4113842258E+01, 3.9097925040E+00, 9.7894804384E-01],
	[4.5405000000E+04, 4.2409023352E+01, 5.2435092170E+00, 2.4122534692E+01, 3.9101161854E+00, 9.7895669770E-01],
	[4.5410000000E+04, 4.2417299243E+01, 5.2435539490E+00, 2.4131229300E+01, 3.9104397885E+00, 9.7896534748E-01],
	[4.5415000000E+04, 4.2425575838E+01, 5.2435986763E+00, 2.4139926083E+01, 3.9107633132E+00, 9.7897399319E-01],
	[4.5420000000E+04, 4.2433853136E+01, 5.2436433991E+00, 2.4148625041E+01, 3.9110867596E+00, 9.7898263482E-01],
	[4.5425000000E+04, 4.2442131138E+01, 5.2436881174E+00, 2.4157326175E+01, 3.9114101278E+00, 9.7899127239E-01],
	[4.5430000000E+04, 4.2450409844E+01, 5.2437328312E+00, 2.4166029485E+01, 3.9117334176E+00, 9.7899990588E-01],
	[4.5435000000E+04, 4.2458689252E+01, 5.2437775404E+00, 2.4174734970E+01, 3.9120566292E+00, 9.7900853531E-01],
	[4.5440000000E+04, 4.2466969365E+01, 5.2438222450E+00, 2.4183442632E+01, 3.9123797626E+00, 9.7901716067E-01],
	[4.5445000000E+04, 4.2475250181E+01, 5.2438669452E+00, 2.4192152471E+01, 3.9127028177E+00, 9.7902578197E-01],
	[4.5450000000E+04, 4.2483531700E+01, 5.2439116407E+00, 2.4200864487E+01, 3.9130257947E+00, 9.7903439921E-01],
	[4.5455000000E+04, 4.2491813922E+01, 5.2439563318E+00, 2.4209578680E+01, 3.9133486934E+00, 9.7904301239E-01],
	[4.5460000000E+04, 4.2500096848E+01, 5.2440010183E+00, 2.4218295051E+01, 3.9136715141E+00, 9.7905162151E-01],
	[4.5465000000E+04, 4.2508380478E+01, 5.2440457003E+00, 2.4227013599E+01, 3.9139942566E+00, 9.7906022658E-01],
	[4.5470000000E+04, 4.2516664810E+01, 5.2440903777E+00, 2.4235734326E+01, 3.9143169209E+00, 9.7906882759E-01],
	[4.5475000000E+04, 4.2524949846E+01, 5.2441350507E+00, 2.4244457231E+01, 3.9146395072E+00, 9.7907742455E-01],
	[4.5480000000E+04, 4.2533235585E+01, 5.2441797191E+00, 2.4253182315E+01, 3.9149620154E+00, 9.7908601747E-01],
	[4.5485000000E+04, 4.2541522028E+01, 5.2442243829E+00, 2.4261909579E+01, 3.9152844456E+00, 9.7909460634E-01],
	[4.5490000000E+04, 4.2549809174E+01, 5.2442690422E+00, 2.4270639021E+01, 3.9156067977E+00, 9.7910319116E-01],
	[4.5495000000E+04, 4.2558097023E+01, 5.2443136970E+00, 2.4279370644E+01, 3.9159290718E+00, 9.7911177194E-01],
	[4.5500000000E+04, 4.2566385575E+01, 5.2443583473E+00, 2.4288104446E+01, 3.9162512679E+00, 9.7912034867E-01],
	[4.5505000000E+04, 4.2574674831E+01, 5.2444029931E+00, 2.4296840429E+01, 3.9165733860E+00, 9.7912892137E-01],
	[4.5510000000E+04, 4.2582964790E+01, 5.2444476343E+00, 2.4305578592E+01, 3.9168954261E+00, 9.7913749003E-01],
	[4.5515000000E+04, 4.2591255452E+01, 5.2444922710E+00, 2.4314318937E+01, 3.9172173884E+00, 9.7914605466E-01],
	[4.5520000000E+04, 4.2599546817E+01, 5.2445369032E+00, 2.4323061462E+01, 3.9175392727E+00, 9.7915461525E-01],
	[4.5525000000E+04, 4.2607838885E+01, 5.2445815308E+00, 2.4331806170E+01, 3.9178610791E+00, 9.7916317182E-01],
	[4.5530000000E+04, 4.2616131656E+01, 5.2446261539E+00, 2.4340553059E+01, 3.9181828076E+00, 9.7917172435E-01],
	[4.5535000000E+04, 4.2624425131E+01, 5.2446707725E+00, 2.4349302130E+01, 3.9185044583E+00, 9.7918027286E-01],
	[4.5540000000E+04, 4.2632719308E+01, 5.2447153866E+00, 2.4358053384E+01, 3.9188260311E+00, 9.7918881734E-01],
	[4.5545000000E+04, 4.2641014189E+01, 5.2447599962E+00, 2.4366806820E+01, 3.9191475262E+00, 9.7919735780E-01],
	[4.5550000000E+04, 4.2649309773E+01, 5.2448046013E+00, 2.4375562440E+01, 3.9194689434E+00, 9.7920589424E-01],
	[4.5555000000E+04, 4.2657606060E+01, 5.2448492018E+00, 2.4384320243E+01, 3.9197902828E+00, 9.7921442665E-01],
	[4.5560000000E+04, 4.2665903049E+01, 5.2448937978E+00, 2.4393080230E+01, 3.9201115445E+00, 9.7922295506E-01],
	[4.5565000000E+04, 4.2674200742E+01, 5.2449383893E+00, 2.4401842400E+01, 3.9204327284E+00, 9.7923147944E-01],
	[4.5570000000E+04, 4.2682499138E+01, 5.2449829763E+00, 2.4410606755E+01, 3.9207538347E+00, 9.7923999982E-01],
	[4.5575000000E+04, 4.2690798237E+01, 5.2450275588E+00, 2.4419373295E+01, 3.9210748632E+00, 9.7924851618E-01],
	[4.5580000000E+04, 4.2699098039E+01, 5.2450721368E+00, 2.4428142019E+01, 3.9213958140E+00, 9.7925702853E-01],
	[4.5585000000E+04, 4.2707398543E+01, 5.2451167102E+00, 2.4436912929E+01, 3.9217166872E+00, 9.7926553688E-01],
	[4.5590000000E+04, 4.2715699751E+01, 5.2451612792E+00, 2.4445686024E+01, 3.9220374827E+00, 9.7927404122E-01],
	[4.5595000000E+04, 4.2724001661E+01, 5.2452058436E+00, 2.4454461305E+01, 3.9223582007E+00, 9.7928254156E-01],
	[4.5600000000E+04, 4.2732304275E+01, 5.2452504035E+00, 2.4463238773E+01, 3.9226788410E+00, 9.7929103790E-01],
	[4.5605000000E+04, 4.2740607591E+01, 5.2452949590E+00, 2.4472018426E+01, 3.9229994037E+00, 9.7929953023E-01],
	[4.5610000000E+04, 4.2748911610E+01, 5.2453395099E+00, 2.4480800267E+01, 3.9233198889E+00, 9.7930801858E-01],
	[4.5615000000E+04, 4.2757216332E+01, 5.2453840563E+00, 2.4489584294E+01, 3.9236402965E+00, 9.7931650292E-01],
	[4.5620000000E+04, 4.2765521757E+01, 5.2454285982E+00, 2.4498370509E+01, 3.9239606266E+00, 9.7932498327E-01],
	[4.5625000000E+04, 4.2773827885E+01, 5.2454731356E+00, 2.4507158911E+01, 3.9242808792E+00, 9.7933345964E-01],
	[4.5630000000E+04, 4.2782134715E+01, 5.2455176685E+00, 2.4515949502E+01, 3.9246010544E+00, 9.7934193201E-01],
	[4.5635000000E+04, 4.2790442248E+01, 5.2455621969E+00, 2.4524742280E+01, 3.9249211520E+00, 9.7935040039E-01],
	[4.5640000000E+04, 4.2798750484E+01, 5.2456067208E+00, 2.4533537247E+01, 3.9252411723E+00, 9.7935886480E-01],
	[4.5645000000E+04, 4.2807059422E+01, 5.2456512402E+00, 2.4542334403E+01, 3.9255611151E+00, 9.7936732521E-01],
	[4.5650000000E+04, 4.2815369064E+01, 5.2456957551E+00, 2.4551133749E+01, 3.9258809804E+00, 9.7937578165E-01],
	[4.5655000000E+04, 4.2823679408E+01, 5.2457402655E+00, 2.4559935283E+01, 3.9262007685E+00, 9.7938423411E-01],
	[4.5660000000E+04, 4.2831990454E+01, 5.2457847714E+00, 2.4568739008E+01, 3.9265204791E+00, 9.7939268259E-01],
	[4.5665000000E+04, 4.2840302204E+01, 5.2458292728E+00, 2.4577544922E+01, 3.9268401124E+00, 9.7940112709E-01],
	[4.5670000000E+04, 4.2848614656E+01, 5.2458737697E+00, 2.4586353027E+01, 3.9271596684E+00, 9.7940956762E-01],
	[4.5675000000E+04, 4.2856927810E+01, 5.2459182621E+00, 2.4595163323E+01, 3.9274791470E+00, 9.7941800418E-01],
	[4.5680000000E+04, 4.2865241667E+01, 5.2459627501E+00, 2.4603975810E+01, 3.9277985484E+00, 9.7942643678E-01],
	[4.5685000000E+04, 4.2873556227E+01, 5.2460072335E+00, 2.4612790488E+01, 3.9281178725E+00, 9.7943486540E-01],
	[4.5690000000E+04, 4.2881871490E+01, 5.2460517124E+00, 2.4621607357E+01, 3.9284371194E+00, 9.7944329006E-01],
	[4.5695000000E+04, 4.2890187454E+01, 5.2460961869E+00, 2.4630426419E+01, 3.9287562891E+00, 9.7945171076E-01],
	[4.5700000000E+04, 4.2898504122E+01, 5.2461406569E+00, 2.4639247672E+01, 3.9290753815E+00, 9.7946012749E-01],
	[4.5705000000E+04, 4.2906821492E+01, 5.2461851223E+00, 2.4648071118E+01, 3.9293943968E+00, 9.7946854027E-01],
	[4.5710000000E+04, 4.2915139564E+01, 5.2462295833E+00, 2.4656896757E+01, 3.9297133348E+00, 9.7947694908E-01],
	[4.5715000000E+04, 4.2923458339E+01, 5.2462740398E+00, 2.4665724590E+01, 3.9300321958E+00, 9.7948535395E-01],
	[4.5720000000E+04, 4.2931777817E+01, 5.2463184919E+00, 2.4674554615E+01, 3.9303509796E+00, 9.7949375486E-01],
	[4.5725000000E+04, 4.2940097996E+01, 5.2463629394E+00, 2.4683386835E+01, 3.9306696863E+00, 9.7950215181E-01],
	[4.5730000000E+04, 4.2948418879E+01, 5.2464073824E+00, 2.4692221248E+01, 3.9309883159E+00, 9.7951054482E-01],
	[4.5735000000E+04, 4.2956740463E+01, 5.2464518210E+00, 2.4701057856E+01, 3.9313068685E+00, 9.7951893388E-01],
	[4.5740000000E+04, 4.2965062750E+01, 5.2464962551E+00, 2.4709896658E+01, 3.9316253440E+00, 9.7952731900E-01],
	[4.5745000000E+04, 4.2973385740E+01, 5.2465406847E+00, 2.4718737655E+01, 3.9319437424E+00, 9.7953570017E-01],
	[4.5750000000E+04, 4.2981709432E+01, 5.2465851098E+00, 2.4727580848E+01, 3.9322620639E+00, 9.7954407741E-01],
	[4.5755000000E+04, 4.2990033826E+01, 5.2466295305E+00, 2.4736426236E+01, 3.9325803084E+00, 9.7955245070E-01],
	[4.5760000000E+04, 4.2998358922E+01, 5.2466739466E+00, 2.4745273820E+01, 3.9328984759E+00, 9.7956082005E-01],
	[4.5765000000E+04, 4.3006684721E+01, 5.2467183583E+00, 2.4754123601E+01, 3.9332165664E+00, 9.7956918547E-01],
	[4.5770000000E+04, 4.3015011222E+01, 5.2467627655E+00, 2.4762975577E+01, 3.9335345800E+00, 9.7957754696E-01],
	[4.5775000000E+04, 4.3023338426E+01, 5.2468071683E+00, 2.4771829751E+01, 3.9338525167E+00, 9.7958590451E-01],
	[4.5780000000E+04, 4.3031666331E+01, 5.2468515665E+00, 2.4780686121E+01, 3.9341703766E+00, 9.7959425814E-01],
	[4.5785000000E+04, 4.3039994939E+01, 5.2468959603E+00, 2.4789544689E+01, 3.9344881595E+00, 9.7960260783E-01],
	[4.5790000000E+04, 4.3048324249E+01, 5.2469403497E+00, 2.4798405455E+01, 3.9348058656E+00, 9.7961095360E-01],
	[4.5795000000E+04, 4.3056654261E+01, 5.2469847345E+00, 2.4807268419E+01, 3.9351234948E+00, 9.7961929545E-01],
	[4.5800000000E+04, 4.3064984976E+01, 5.2470291149E+00, 2.4816133581E+01, 3.9354410473E+00, 9.7962763338E-01],
	[4.5805000000E+04, 4.3073316393E+01, 5.2470734908E+00, 2.4825000941E+01, 3.9357585229E+00, 9.7963596739E-01],
	[4.5810000000E+04, 4.3081648511E+01, 5.2471178622E+00, 2.4833870501E+01, 3.9360759218E+00, 9.7964429747E-01],
	[4.5815000000E+04, 4.3089981332E+01, 5.2471622292E+00, 2.4842742260E+01, 3.9363932440E+00, 9.7965262365E-01],
	[4.5820000000E+04, 4.3098314855E+01, 5.2472065917E+00, 2.4851616218E+01, 3.9367104893E+00, 9.7966094591E-01],
	[4.5825000000E+04, 4.3106649080E+01, 5.2472509498E+00, 2.4860492376E+01, 3.9370276580E+00, 9.7966926426E-01],
	[4.5830000000E+04, 4.3114984008E+01, 5.2472953033E+00, 2.4869370734E+01, 3.9373447500E+00, 9.7967757869E-01],
	[4.5835000000E+04, 4.3123319637E+01, 5.2473396525E+00, 2.4878251293E+01, 3.9376617653E+00, 9.7968588922E-01],
	[4.5840000000E+04, 4.3131655968E+01, 5.2473839971E+00, 2.4887134052E+01, 3.9379787040E+00, 9.7969419585E-01],
	[4.5845000000E+04, 4.3139993001E+01, 5.2474283373E+00, 2.4896019013E+01, 3.9382955660E+00, 9.7970249857E-01],
	[4.5850000000E+04, 4.3148330737E+01, 5.2474726730E+00, 2.4904906175E+01, 3.9386123514E+00, 9.7971079739E-01],
	[4.5855000000E+04, 4.3156669174E+01, 5.2475170043E+00, 2.4913795538E+01, 3.9389290602E+00, 9.7971909231E-01],
	[4.5860000000E+04, 4.3165008313E+01, 5.2475613311E+00, 2.4922687104E+01, 3.9392456924E+00, 9.7972738333E-01],
	[4.5865000000E+04, 4.3173348155E+01, 5.2476056534E+00, 2.4931580872E+01, 3.9395622481E+00, 9.7973567045E-01],
	[4.5870000000E+04, 4.3181688698E+01, 5.2476499713E+00, 2.4940476842E+01, 3.9398787272E+00, 9.7974395369E-01],
	[4.5875000000E+04, 4.3190029943E+01, 5.2476942848E+00, 2.4949375015E+01, 3.9401951299E+00, 9.7975223303E-01],
	[4.5880000000E+04, 4.3198371890E+01, 5.2477385937E+00, 2.4958275392E+01, 3.9405114560E+00, 9.7976050847E-01],
	[4.5885000000E+04, 4.3206714539E+01, 5.2477828983E+00, 2.4967177971E+01, 3.9408277056E+00, 9.7976878004E-01],
	[4.5890000000E+04, 4.3215057890E+01, 5.2478271983E+00, 2.4976082755E+01, 3.9411438788E+00, 9.7977704771E-01],
	[4.5895000000E+04, 4.3223401943E+01, 5.2478714940E+00, 2.4984989743E+01, 3.9414599755E+00, 9.7978531150E-01],
	[4.5900000000E+04, 4.3231746697E+01, 5.2479157851E+00, 2.4993898935E+01, 3.9417759959E+00, 9.7979357141E-01],
	[4.5905000000E+04, 4.3240092153E+01, 5.2479600719E+00, 2.5002810332E+01, 3.9420919398E+00, 9.7980182744E-01],
	[4.5910000000E+04, 4.3248438311E+01, 5.2480043541E+00, 2.5011723934E+01, 3.9424078073E+00, 9.7981007959E-01],
	[4.5915000000E+04, 4.3256785171E+01, 5.2480486319E+00, 2.5020639741E+01, 3.9427235985E+00, 9.7981832786E-01],
	[4.5920000000E+04, 4.3265132733E+01, 5.2480929053E+00, 2.5029557754E+01, 3.9430393133E+00, 9.7982657226E-01],
	[4.5925000000E+04, 4.3273480996E+01, 5.2481371742E+00, 2.5038477973E+01, 3.9433549519E+00, 9.7983481279E-01],
	[4.5930000000E+04, 4.3281829962E+01, 5.2481814387E+00, 2.5047400398E+01, 3.9436705141E+00, 9.7984304945E-01],
	[4.5935000000E+04, 4.3290179628E+01, 5.2482256987E+00, 2.5056325030E+01, 3.9439860000E+00, 9.7985128224E-01],
	[4.5940000000E+04, 4.3298529997E+01, 5.2482699543E+00, 2.5065251868E+01, 3.9443014097E+00, 9.7985951116E-01],
	[4.5945000000E+04, 4.3306881067E+01, 5.2483142055E+00, 2.5074180914E+01, 3.9446167431E+00, 9.7986773622E-01],
	[4.5950000000E+04, 4.3315232839E+01, 5.2483584522E+00, 2.5083112167E+01, 3.9449320003E+00, 9.7987595741E-01],
	[4.5955000000E+04, 4.3323585313E+01, 5.2484026944E+00, 2.5092045628E+01, 3.9452471813E+00, 9.7988417475E-01],
	[4.5960000000E+04, 4.3331938488E+01, 5.2484469323E+00, 2.5100981296E+01, 3.9455622861E+00, 9.7989238822E-01],
	[4.5965000000E+04, 4.3340292365E+01, 5.2484911656E+00, 2.5109919174E+01, 3.9458773148E+00, 9.7990059784E-01],
	[4.5970000000E+04, 4.3348646943E+01, 5.2485353946E+00, 2.5118859260E+01, 3.9461922673E+00, 9.7990880361E-01],
	[4.5975000000E+04, 4.3357002223E+01, 5.2485796191E+00, 2.5127801554E+01, 3.9465071437E+00, 9.7991700552E-01],
	[4.5980000000E+04, 4.3365358204E+01, 5.2486238392E+00, 2.5136746059E+01, 3.9468219440E+00, 9.7992520358E-01],
	[4.5985000000E+04, 4.3373714887E+01, 5.2486680548E+00, 2.5145692772E+01, 3.9471366682E+00, 9.7993339779E-01],
	[4.5990000000E+04, 4.3382072272E+01, 5.2487122660E+00, 2.5154641696E+01, 3.9474513163E+00, 9.7994158816E-01],
	[4.5995000000E+04, 4.3390430358E+01, 5.2487564728E+00, 2.5163592830E+01, 3.9477658884E+00, 9.7994977468E-01],
	[4.6000000000E+04, 4.3398789146E+01, 5.2488006751E+00, 2.5172546174E+01, 3.9480803844E+00, 9.7995795736E-01],
	[4.6005000000E+04, 4.3407148635E+01, 5.2488448730E+00, 2.5181501730E+01, 3.9483948044E+00, 9.7996613619E-01],
	[4.6010000000E+04, 4.3415508825E+01, 5.2488890665E+00, 2.5190459496E+01, 3.9487091485E+00, 9.7997431119E-01],
	[4.6015000000E+04, 4.3423869717E+01, 5.2489332555E+00, 2.5199419474E+01, 3.9490234166E+00, 9.7998248235E-01],
	[4.6020000000E+04, 4.3432231310E+01, 5.2489774401E+00, 2.5208381663E+01, 3.9493376087E+00, 9.7999064968E-01],
	[4.6025000000E+04, 4.3440593605E+01, 5.2490216203E+00, 2.5217346065E+01, 3.9496517249E+00, 9.7999881317E-01],
	[4.6030000000E+04, 4.3448956601E+01, 5.2490657960E+00, 2.5226312678E+01, 3.9499657652E+00, 9.8000697283E-01],
	[4.6035000000E+04, 4.3457332946E+01, 5.2491113716E+00, 2.5235281505E+01, 3.9502806294E+00, 9.8001512867E-01],
	[4.6040000000E+04, 4.3465713635E+01, 5.2491573467E+00, 2.5244252544E+01, 3.9505956769E+00, 9.8002328067E-01],
	[4.6045000000E+04, 4.3474095030E+01, 5.2492033173E+00, 2.5253225797E+01, 3.9509106486E+00, 9.8003142885E-01],
	[4.6050000000E+04, 4.3482477131E+01, 5.2492492832E+00, 2.5262201263E+01, 3.9512255447E+00, 9.8003957321E-01],
	[4.6055000000E+04, 4.3490859938E+01, 5.2492952445E+00, 2.5271178943E+01, 3.9515403651E+00, 9.8004771374E-01],
	[4.6060000000E+04, 4.3499243450E+01, 5.2493412013E+00, 2.5280158838E+01, 3.9518551100E+00, 9.8005585046E-01],
	[4.6065000000E+04, 4.3507627669E+01, 5.2493871535E+00, 2.5289140946E+01, 3.9521697792E+00, 9.8006398335E-01],
	[4.6070000000E+04, 4.3516012593E+01, 5.2494331011E+00, 2.5298125270E+01, 3.9524843729E+00, 9.8007211244E-01],
	[4.6075000000E+04, 4.3524398222E+01, 5.2494790441E+00, 2.5307111808E+01, 3.9527988910E+00, 9.8008023771E-01],
	[4.6080000000E+04, 4.3532784558E+01, 5.2495249825E+00, 2.5316100562E+01, 3.9531133335E+00, 9.8008835916E-01],
	[4.6085000000E+04, 4.3541171599E+01, 5.2495709163E+00, 2.5325091532E+01, 3.9534277005E+00, 9.8009647681E-01],
	[4.6090000000E+04, 4.3549559346E+01, 5.2496168456E+00, 2.5334084718E+01, 3.9537419921E+00, 9.8010459065E-01],
	[4.6095000000E+04, 4.3557947798E+01, 5.2496627703E+00, 2.5343080120E+01, 3.9540562081E+00, 9.8011270068E-01],
	[4.6100000000E+04, 4.3566336957E+01, 5.2497086903E+00, 2.5352077738E+01, 3.9543703487E+00, 9.8012080691E-01],
	[4.6105000000E+04, 4.3574726820E+01, 5.2497546059E+00, 2.5361077574E+01, 3.9546844138E+00, 9.8012890934E-01],
	[4.6110000000E+04, 4.3583117390E+01, 5.2498005168E+00, 2.5370079627E+01, 3.9549984035E+00, 9.8013700797E-01],
	[4.6115000000E+04, 4.3591508665E+01, 5.2498464232E+00, 2.5379083897E+01, 3.9553123178E+00, 9.8014510280E-01],
	[4.6120000000E+04, 4.3599900646E+01, 5.2498923250E+00, 2.5388090385E+01, 3.9556261567E+00, 9.8015319383E-01],
	[4.6125000000E+04, 4.3608293332E+01, 5.2499382222E+00, 2.5397099091E+01, 3.9559399203E+00, 9.8016128107E-01],
	[4.6130000000E+04, 4.3616686723E+01, 5.2499841148E+00, 2.5406110016E+01, 3.9562536085E+00, 9.8016936452E-01],
	[4.6135000000E+04, 4.3625080821E+01, 5.2500300029E+00, 2.5415123159E+01, 3.9565672213E+00, 9.8017744417E-01],
	[4.6140000000E+04, 4.3633475623E+01, 5.2500758864E+00, 2.5424138522E+01, 3.9568807589E+00, 9.8018552004E-01],
	[4.6145000000E+04, 4.3641871132E+01, 5.2501217653E+00, 2.5433156104E+01, 3.9571942212E+00, 9.8019359212E-01],
	[4.6150000000E+04, 4.3650267345E+01, 5.2501676396E+00, 2.5442175905E+01, 3.9575076082E+00, 9.8020166042E-01],
	[4.6155000000E+04, 4.3658664265E+01, 5.2502135094E+00, 2.5451197927E+01, 3.9578209199E+00, 9.8020972494E-01],
	[4.6160000000E+04, 4.3667061889E+01, 5.2502593746E+00, 2.5460222168E+01, 3.9581341565E+00, 9.8021778567E-01],
	[4.6165000000E+04, 4.3675460219E+01, 5.2503052353E+00, 2.5469248631E+01, 3.9584473178E+00, 9.8022584263E-01],
	[4.6170000000E+04, 4.3683859255E+01, 5.2503510914E+00, 2.5478277314E+01, 3.9587604039E+00, 9.8023389581E-01],
	[4.6175000000E+04, 4.3692258996E+01, 5.2503969429E+00, 2.5487308218E+01, 3.9590734148E+00, 9.8024194521E-01],
	[4.6180000000E+04, 4.3700659442E+01, 5.2504427898E+00, 2.5496341344E+01, 3.9593863506E+00, 9.8024999084E-01],
	[4.6185000000E+04, 4.3709060594E+01, 5.2504886322E+00, 2.5505376692E+01, 3.9596992113E+00, 9.8025803270E-01],
	[4.6190000000E+04, 4.3717462450E+01, 5.2505344701E+00, 2.5514414262E+01, 3.9600119968E+00, 9.8026607080E-01],
	[4.6195000000E+04, 4.3725865013E+01, 5.2505803033E+00, 2.5523454054E+01, 3.9603247073E+00, 9.8027410512E-01],
	[4.6200000000E+04, 4.3734268280E+01, 5.2506261320E+00, 2.5532496069E+01, 3.9606373427E+00, 9.8028213568E-01],
	[4.6205000000E+04, 4.3742672253E+01, 5.2506719562E+00, 2.5541540307E+01, 3.9609499030E+00, 9.8029016248E-01],
	[4.6210000000E+04, 4.3751076931E+01, 5.2507177758E+00, 2.5550586768E+01, 3.9612623883E+00, 9.8029818551E-01],
	[4.6215000000E+04, 4.3759482315E+01, 5.2507635908E+00, 2.5559635453E+01, 3.9615747985E+00, 9.8030620479E-01],
	[4.6220000000E+04, 4.3767888403E+01, 5.2508094013E+00, 2.5568686362E+01, 3.9618871338E+00, 9.8031422031E-01],
	[4.6225000000E+04, 4.3776295197E+01, 5.2508552072E+00, 2.5577739495E+01, 3.9621993941E+00, 9.8032223207E-01],
	[4.6230000000E+04, 4.3784702696E+01, 5.2509010085E+00, 2.5586794852E+01, 3.9625115794E+00, 9.8033024008E-01],
	[4.6235000000E+04, 4.3793110900E+01, 5.2509468053E+00, 2.5595852435E+01, 3.9628236898E+00, 9.8033824434E-01],
	[4.6240000000E+04, 4.3801519810E+01, 5.2509925976E+00, 2.5604912243E+01, 3.9631357252E+00, 9.8034624485E-01],
	[4.6245000000E+04, 4.3809929424E+01, 5.2510383853E+00, 2.5613974276E+01, 3.9634476858E+00, 9.8035424161E-01],
	[4.6250000000E+04, 4.3818339744E+01, 5.2510841685E+00, 2.5623038535E+01, 3.9637595715E+00, 9.8036223462E-01],
	[4.6255000000E+04, 4.3826750769E+01, 5.2511299471E+00, 2.5632105020E+01, 3.9640713823E+00, 9.8037022389E-01],
	[4.6260000000E+04, 4.3835162499E+01, 5.2511757211E+00, 2.5641173731E+01, 3.9643831183E+00, 9.8037820942E-01],
	[4.6265000000E+04, 4.3843574934E+01, 5.2512214906E+00, 2.5650244669E+01, 3.9646947794E+00, 9.8038619121E-01],
	[4.6270000000E+04, 4.3851988074E+01, 5.2512672556E+00, 2.5659317834E+01, 3.9650063658E+00, 9.8039416926E-01],
	[4.6275000000E+04, 4.3860401919E+01, 5.2513130160E+00, 2.5668393226E+01, 3.9653178773E+00, 9.8040214358E-01],
	[4.6280000000E+04, 4.3868816469E+01, 5.2513587718E+00, 2.5677470846E+01, 3.9656293141E+00, 9.8041011416E-01],
	[4.6285000000E+04, 4.3877231724E+01, 5.2514045232E+00, 2.5686550694E+01, 3.9659406762E+00, 9.8041808101E-01],
	[4.6290000000E+04, 4.3885647684E+01, 5.2514502699E+00, 2.5695632770E+01, 3.9662519635E+00, 9.8042604413E-01],
	[4.6295000000E+04, 4.3894064349E+01, 5.2514960122E+00, 2.5704717075E+01, 3.9665631761E+00, 9.8043400352E-01],
	[4.6300000000E+04, 4.3902481719E+01, 5.2515417499E+00, 2.5713803608E+01, 3.9668743140E+00, 9.8044195918E-01],
	[4.6305000000E+04, 4.3910899794E+01, 5.2515874830E+00, 2.5722892371E+01, 3.9671853773E+00, 9.8044991112E-01],
	[4.6310000000E+04, 4.3919318574E+01, 5.2516332116E+00, 2.5731983363E+01, 3.9674963659E+00, 9.8045785934E-01],
	[4.6315000000E+04, 4.3927738059E+01, 5.2516789357E+00, 2.5741076585E+01, 3.9678072798E+00, 9.8046580383E-01],
	[4.6320000000E+04, 4.3936158249E+01, 5.2517246552E+00, 2.5750172036E+01, 3.9681181192E+00, 9.8047374461E-01],
	[4.6325000000E+04, 4.3944579143E+01, 5.2517703702E+00, 2.5759269719E+01, 3.9684288840E+00, 9.8048168167E-01],
	[4.6330000000E+04, 4.3953000743E+01, 5.2518160807E+00, 2.5768369631E+01, 3.9687395741E+00, 9.8048961501E-01],
	[4.6335000000E+04, 4.3961423047E+01, 5.2518617866E+00, 2.5777471775E+01, 3.9690501898E+00, 9.8049754464E-01],
	[4.6340000000E+04, 4.3969846056E+01, 5.2519074880E+00, 2.5786576150E+01, 3.9693607309E+00, 9.8050547056E-01],
	[4.6345000000E+04, 4.3978269770E+01, 5.2519531849E+00, 2.5795682757E+01, 3.9696711975E+00, 9.8051339278E-01],
	[4.6350000000E+04, 4.3986694189E+01, 5.2519988772E+00, 2.5804791595E+01, 3.9699815896E+00, 9.8052131128E-01],
	[4.6355000000E+04, 4.3995119313E+01, 5.2520445650E+00, 2.5813902666E+01, 3.9702919072E+00, 9.8052922608E-01],
	[4.6360000000E+04, 4.4003545141E+01, 5.2520902483E+00, 2.5823015969E+01, 3.9706021504E+00, 9.8053713717E-01],
	[4.6365000000E+04, 4.4011971674E+01, 5.2521359270E+00, 2.5832131505E+01, 3.9709123191E+00, 9.8054504457E-01],
	[4.6370000000E+04, 4.4020398912E+01, 5.2521816012E+00, 2.5841249274E+01, 3.9712224134E+00, 9.8055294826E-01],
	[4.6375000000E+04, 4.4028826854E+01, 5.2522272709E+00, 2.5850369277E+01, 3.9715324333E+00, 9.8056084826E-01],
	[4.6380000000E+04, 4.4037255501E+01, 5.2522729360E+00, 2.5859491513E+01, 3.9718423788E+00, 9.8056874456E-01],
	[4.6385000000E+04, 4.4045684853E+01, 5.2523185967E+00, 2.5868615983E+01, 3.9721522500E+00, 9.8057663716E-01],
	[4.6390000000E+04, 4.4054114910E+01, 5.2523642528E+00, 2.5877742688E+01, 3.9724620468E+00, 9.8058452608E-01],
	[4.6395000000E+04, 4.4062545671E+01, 5.2524099044E+00, 2.5886871627E+01, 3.9727717693E+00, 9.8059241130E-01],
	[4.6400000000E+04, 4.4070977137E+01, 5.2524555514E+00, 2.5896002801E+01, 3.9730814175E+00, 9.8060029284E-01],
	[4.6405000000E+04, 4.4079409307E+01, 5.2525011939E+00, 2.5905136211E+01, 3.9733909914E+00, 9.8060817069E-01],
	[4.6410000000E+04, 4.4087842182E+01, 5.2525468320E+00, 2.5914271856E+01, 3.9737004911E+00, 9.8061604485E-01],
	[4.6415000000E+04, 4.4096275762E+01, 5.2525924655E+00, 2.5923409737E+01, 3.9740099165E+00, 9.8062391534E-01],
	[4.6420000000E+04, 4.4104710046E+01, 5.2526380944E+00, 2.5932549854E+01, 3.9743192677E+00, 9.8063178214E-01],
	[4.6425000000E+04, 4.4113145034E+01, 5.2526837189E+00, 2.5941692207E+01, 3.9746285446E+00, 9.8063964526E-01],
	[4.6430000000E+04, 4.4121580727E+01, 5.2527293388E+00, 2.5950836797E+01, 3.9749377474E+00, 9.8064750471E-01],
	[4.6435000000E+04, 4.4130017125E+01, 5.2527749542E+00, 2.5959983625E+01, 3.9752468761E+00, 9.8065536048E-01],
	[4.6440000000E+04, 4.4138454227E+01, 5.2528205651E+00, 2.5969132689E+01, 3.9755559305E+00, 9.8066321258E-01],
	[4.6445000000E+04, 4.4146892034E+01, 5.2528661715E+00, 2.5978283992E+01, 3.9758649109E+00, 9.8067106101E-01],
	[4.6450000000E+04, 4.4155330545E+01, 5.2529117734E+00, 2.5987437532E+01, 3.9761738171E+00, 9.8067890577E-01],
	[4.6455000000E+04, 4.4163769760E+01, 5.2529573708E+00, 2.5996593311E+01, 3.9764826492E+00, 9.8068674686E-01],
	[4.6460000000E+04, 4.4172209680E+01, 5.2530029636E+00, 2.6005751328E+01, 3.9767914073E+00, 9.8069458429E-01],
	[4.6465000000E+04, 4.4180650304E+01, 5.2530485520E+00, 2.6014911584E+01, 3.9771000913E+00, 9.8070241806E-01],
	[4.6470000000E+04, 4.4189091633E+01, 5.2530941358E+00, 2.6024074080E+01, 3.9774087013E+00, 9.8071024816E-01],
	[4.6475000000E+04, 4.4197533666E+01, 5.2531397151E+00, 2.6033238815E+01, 3.9777172373E+00, 9.8071807460E-01],
	[4.6480000000E+04, 4.4205976403E+01, 5.2531852900E+00, 2.6042405790E+01, 3.9780256993E+00, 9.8072589739E-01],
	[4.6485000000E+04, 4.4214419845E+01, 5.2532308603E+00, 2.6051575005E+01, 3.9783340873E+00, 9.8073371652E-01],
	[4.6490000000E+04, 4.4222863991E+01, 5.2532764261E+00, 2.6060746460E+01, 3.9786424013E+00, 9.8074153199E-01],
	[4.6495000000E+04, 4.4231308841E+01, 5.2533219874E+00, 2.6069920156E+01, 3.9789506414E+00, 9.8074934381E-01],
	[4.6500000000E+04, 4.4239754396E+01, 5.2533675442E+00, 2.6079096094E+01, 3.9792588076E+00, 9.8075715199E-01],
	[4.6505000000E+04, 4.4248200655E+01, 5.2534130965E+00, 2.6088274272E+01, 3.9795668999E+00, 9.8076495651E-01],
	[4.6510000000E+04, 4.4256647618E+01, 5.2534586442E+00, 2.6097454692E+01, 3.9798749183E+00, 9.8077275739E-01],
	[4.6515000000E+04, 4.4265095285E+01, 5.2535041875E+00, 2.6106637355E+01, 3.9801828629E+00, 9.8078055463E-01],
	[4.6520000000E+04, 4.4273543657E+01, 5.2535497263E+00, 2.6115822259E+01, 3.9804907336E+00, 9.8078834822E-01],
	[4.6525000000E+04, 4.4281992733E+01, 5.2535952606E+00, 2.6125009406E+01, 3.9807985305E+00, 9.8079613817E-01],
	[4.6530000000E+04, 4.4290442513E+01, 5.2536407904E+00, 2.6134198796E+01, 3.9811062536E+00, 9.8080392448E-01],
	[4.6535000000E+04, 4.4298892997E+01, 5.2536863157E+00, 2.6143390430E+01, 3.9814139029E+00, 9.8081170716E-01],
	[4.6540000000E+04, 4.4307344185E+01, 5.2537318365E+00, 2.6152584306E+01, 3.9817214784E+00, 9.8081948620E-01],
	[4.6545000000E+04, 4.4315796077E+01, 5.2537773528E+00, 2.6161780427E+01, 3.9820289802E+00, 9.8082726161E-01],
	[4.6550000000E+04, 4.4324248674E+01, 5.2538228646E+00, 2.6170978791E+01, 3.9823364083E+00, 9.8083503338E-01],
	[4.6555000000E+04, 4.4332701974E+01, 5.2538683719E+00, 2.6180179401E+01, 3.9826437627E+00, 9.8084280153E-01],
	[4.6560000000E+04, 4.4341155979E+01, 5.2539138747E+00, 2.6189382254E+01, 3.9829510433E+00, 9.8085056605E-01],
	[4.6565000000E+04, 4.4349610688E+01, 5.2539593730E+00, 2.6198587353E+01, 3.9832582503E+00, 9.8085832695E-01],
	[4.6570000000E+04, 4.4358066101E+01, 5.2540048669E+00, 2.6207794697E+01, 3.9835653837E+00, 9.8086608422E-01],
	[4.6575000000E+04, 4.4366522217E+01, 5.2540503562E+00, 2.6217004287E+01, 3.9838724434E+00, 9.8087383787E-01],
	[4.6580000000E+04, 4.4374979038E+01, 5.2540958411E+00, 2.6226216123E+01, 3.9841794296E+00, 9.8088158790E-01],
	[4.6585000000E+04, 4.4383436563E+01, 5.2541413214E+00, 2.6235430205E+01, 3.9844863421E+00, 9.8088933431E-01],
	[4.6590000000E+04, 4.4391894792E+01, 5.2541867973E+00, 2.6244646534E+01, 3.9847931811E+00, 9.8089707711E-01],
	[4.6595000000E+04, 4.4400353725E+01, 5.2542322687E+00, 2.6253865109E+01, 3.9850999465E+00, 9.8090481629E-01],
	[4.6600000000E+04, 4.4408813361E+01, 5.2542777356E+00, 2.6263085932E+01, 3.9854066383E+00, 9.8091255186E-01],
	[4.6605000000E+04, 4.4417273702E+01, 5.2543231980E+00, 2.6272309002E+01, 3.9857132567E+00, 9.8092028382E-01],
	[4.6610000000E+04, 4.4425734746E+01, 5.2543686559E+00, 2.6281534320E+01, 3.9860198016E+00, 9.8092801217E-01],
	[4.6615000000E+04, 4.4434196495E+01, 5.2544141094E+00, 2.6290761886E+01, 3.9863262729E+00, 9.8093573691E-01],
	[4.6620000000E+04, 4.4442658947E+01, 5.2544595584E+00, 2.6299991701E+01, 3.9866326709E+00, 9.8094345805E-01],
	[4.6625000000E+04, 4.4451122103E+01, 5.2545050029E+00, 2.6309223764E+01, 3.9869389954E+00, 9.8095117559E-01],
	[4.6630000000E+04, 4.4459585963E+01, 5.2545504429E+00, 2.6318458076E+01, 3.9872452465E+00, 9.8095888953E-01],
	[4.6635000000E+04, 4.4468050527E+01, 5.2545958784E+00, 2.6327694638E+01, 3.9875514241E+00, 9.8096659986E-01],
	[4.6640000000E+04, 4.4476515794E+01, 5.2546413095E+00, 2.6336933449E+01, 3.9878575284E+00, 9.8097430660E-01],
	[4.6645000000E+04, 4.4484981766E+01, 5.2546867360E+00, 2.6346174510E+01, 3.9881635594E+00, 9.8098200975E-01],
	[4.6650000000E+04, 4.4493448441E+01, 5.2547321581E+00, 2.6355417821E+01, 3.9884695170E+00, 9.8098970930E-01],
	[4.6655000000E+04, 4.4501915820E+01, 5.2547775757E+00, 2.6364663383E+01, 3.9887754012E+00, 9.8099740526E-01],
	[4.6660000000E+04, 4.4510383902E+01, 5.2548229889E+00, 2.6373911196E+01, 3.9890812122E+00, 9.8100509763E-01],
	[4.6665000000E+04, 4.4518852689E+01, 5.2548683976E+00, 2.6383161260E+01, 3.9893869499E+00, 9.8101278641E-01],
	[4.6670000000E+04, 4.4527322179E+01, 5.2549138018E+00, 2.6392413575E+01, 3.9896926143E+00, 9.8102047161E-01],
	[4.6675000000E+04, 4.4535792373E+01, 5.2549592015E+00, 2.6401668142E+01, 3.9899982055E+00, 9.8102815322E-01],
	[4.6680000000E+04, 4.4544263270E+01, 5.2550045968E+00, 2.6410924962E+01, 3.9903037234E+00, 9.8103583125E-01],
	[4.6685000000E+04, 4.4552734871E+01, 5.2550499875E+00, 2.6420184033E+01, 3.9906091682E+00, 9.8104350570E-01],
	[4.6690000000E+04, 4.4561207176E+01, 5.2550953739E+00, 2.6429445357E+01, 3.9909145397E+00, 9.8105117657E-01],
	[4.6695000000E+04, 4.4569680184E+01, 5.2551407557E+00, 2.6438708935E+01, 3.9912198381E+00, 9.8105884386E-01],
	[4.6700000000E+04, 4.4578153896E+01, 5.2551861331E+00, 2.6447974765E+01, 3.9915250633E+00, 9.8106650758E-01],
	[4.6705000000E+04, 4.4586628312E+01, 5.2552315060E+00, 2.6457242850E+01, 3.9918302154E+00, 9.8107416773E-01],
	[4.6710000000E+04, 4.4595103431E+01, 5.2552768745E+00, 2.6466513188E+01, 3.9921352944E+00, 9.8108182431E-01],
	[4.6715000000E+04, 4.4603579253E+01, 5.2553222385E+00, 2.6475785780E+01, 3.9924403003E+00, 9.8108947732E-01],
	[4.6720000000E+04, 4.4612055780E+01, 5.2553675980E+00, 2.6485060627E+01, 3.9927452331E+00, 9.8109712676E-01],
	[4.6725000000E+04, 4.4620533009E+01, 5.2554129530E+00, 2.6494337729E+01, 3.9930500929E+00, 9.8110477263E-01],
	[4.6730000000E+04, 4.4629010943E+01, 5.2554583036E+00, 2.6503617086E+01, 3.9933548796E+00, 9.8111241494E-01],
	[4.6735000000E+04, 4.4637489579E+01, 5.2555036498E+00, 2.6512898698E+01, 3.9936595933E+00, 9.8112005369E-01],
	[4.6740000000E+04, 4.4645968919E+01, 5.2555489915E+00, 2.6522182566E+01, 3.9939642340E+00, 9.8112768888E-01],
	[4.6745000000E+04, 4.4654448963E+01, 5.2555943287E+00, 2.6531468690E+01, 3.9942688018E+00, 9.8113532052E-01],
	[4.6750000000E+04, 4.4662929710E+01, 5.2556396614E+00, 2.6540757071E+01, 3.9945732965E+00, 9.8114294859E-01],
	[4.6755000000E+04, 4.4671411160E+01, 5.2556849897E+00, 2.6550047708E+01, 3.9948777184E+00, 9.8115057312E-01],
	[4.6760000000E+04, 4.4679893314E+01, 5.2557303136E+00, 2.6559340602E+01, 3.9951820673E+00, 9.8115819409E-01],
	[4.6765000000E+04, 4.4688376172E+01, 5.2557756330E+00, 2.6568635753E+01, 3.9954863433E+00, 9.8116581151E-01],
	[4.6770000000E+04, 4.4696859732E+01, 5.2558209479E+00, 2.6577933162E+01, 3.9957905464E+00, 9.8117342538E-01],
	[4.6775000000E+04, 4.4705353250E+01, 5.2558672644E+00, 2.6587232829E+01, 3.9960953322E+00, 9.8118103570E-01],
	[4.6780000000E+04, 4.4713854489E+01, 5.2559143386E+00, 2.6596534755E+01, 3.9964005419E+00, 9.8118864248E-01],
	[4.6785000000E+04, 4.4722356435E+01, 5.2559614082E+00, 2.6605838938E+01, 3.9967056790E+00, 9.8119624572E-01],
	[4.6790000000E+04, 4.4730859088E+01, 5.2560084732E+00, 2.6615145381E+01, 3.9970107434E+00, 9.8120384542E-01],
	[4.6795000000E+04, 4.4739362450E+01, 5.2560555336E+00, 2.6624454082E+01, 3.9973157352E+00, 9.8121144157E-01],
	[4.6800000000E+04, 4.4747866519E+01, 5.2561025893E+00, 2.6633765043E+01, 3.9976206544E+00, 9.8121903419E-01],
	[4.6805000000E+04, 4.4756371296E+01, 5.2561496405E+00, 2.6643078264E+01, 3.9979255010E+00, 9.8122662328E-01],
	[4.6810000000E+04, 4.4764876781E+01, 5.2561966871E+00, 2.6652393745E+01, 3.9982302750E+00, 9.8123420883E-01],
	[4.6815000000E+04, 4.4773382973E+01, 5.2562437291E+00, 2.6661711486E+01, 3.9985349765E+00, 9.8124179085E-01],
	[4.6820000000E+04, 4.4781889873E+01, 5.2562907664E+00, 2.6671031488E+01, 3.9988396055E+00, 9.8124936934E-01],
	[4.6825000000E+04, 4.4790397480E+01, 5.2563377992E+00, 2.6680353751E+01, 3.9991441619E+00, 9.8125694430E-01],
	[4.6830000000E+04, 4.4798905796E+01, 5.2563848274E+00, 2.6689678275E+01, 3.9994486458E+00, 9.8126451573E-01],
	[4.6835000000E+04, 4.4807414818E+01, 5.2564318509E+00, 2.6699005061E+01, 3.9997530573E+00, 9.8127208364E-01],
	[4.6840000000E+04, 4.4815924549E+01, 5.2564788699E+00, 2.6708334108E+01, 4.0000573963E+00, 9.8127964803E-01],
	[4.6845000000E+04, 4.4824434986E+01, 5.2565258842E+00, 2.6717665418E+01, 4.0003616629E+00, 9.8128720890E-01],
	[4.6850000000E+04, 4.4832946132E+01, 5.2565728940E+00, 2.6726998990E+01, 4.0006658571E+00, 9.8129476625E-01],
	[4.6855000000E+04, 4.4841457985E+01, 5.2566198992E+00, 2.6736334825E+01, 4.0009699788E+00, 9.8130232008E-01],
	[4.6860000000E+04, 4.4849970545E+01, 5.2566668997E+00, 2.6745672923E+01, 4.0012740282E+00, 9.8130987039E-01],
	[4.6865000000E+04, 4.4858483813E+01, 5.2567138957E+00, 2.6755013285E+01, 4.0015780052E+00, 9.8131741720E-01],
	[4.6870000000E+04, 4.4866997788E+01, 5.2567608871E+00, 2.6764355910E+01, 4.0018819099E+00, 9.8132496049E-01],
	[4.6875000000E+04, 4.4875512471E+01, 5.2568078739E+00, 2.6773700800E+01, 4.0021857422E+00, 9.8133250027E-01],
	[4.6880000000E+04, 4.4884027862E+01, 5.2568548561E+00, 2.6783047953E+01, 4.0024895023E+00, 9.8134003655E-01],
	[4.6885000000E+04, 4.4892543959E+01, 5.2569018337E+00, 2.6792397372E+01, 4.0027931900E+00, 9.8134756932E-01],
	[4.6890000000E+04, 4.4901060764E+01, 5.2569488067E+00, 2.6801749055E+01, 4.0030968055E+00, 9.8135509858E-01],
	[4.6895000000E+04, 4.4909578277E+01, 5.2569957752E+00, 2.6811103003E+01, 4.0034003488E+00, 9.8136262434E-01],
	[4.6900000000E+04, 4.4918096497E+01, 5.2570427390E+00, 2.6820459218E+01, 4.0037038198E+00, 9.8137014661E-01],
	[4.6905000000E+04, 4.4926615424E+01, 5.2570896983E+00, 2.6829817697E+01, 4.0040072186E+00, 9.8137766537E-01],
	[4.6910000000E+04, 4.4935135058E+01, 5.2571366529E+00, 2.6839178444E+01, 4.0043105452E+00, 9.8138518064E-01],
	[4.6915000000E+04, 4.4943655400E+01, 5.2571836030E+00, 2.6848541456E+01, 4.0046137996E+00, 9.8139269241E-01],
	[4.6920000000E+04, 4.4952176450E+01, 5.2572305485E+00, 2.6857906736E+01, 4.0049169819E+00, 9.8140020069E-01],
	[4.6925000000E+04, 4.4960698206E+01, 5.2572774894E+00, 2.6867274282E+01, 4.0052200921E+00, 9.8140770548E-01],
	[4.6930000000E+04, 4.4969220670E+01, 5.2573244258E+00, 2.6876644096E+01, 4.0055231301E+00, 9.8141520678E-01],
	[4.6935000000E+04, 4.4977743841E+01, 5.2573713575E+00, 2.6886016178E+01, 4.0058260960E+00, 9.8142270459E-01],
	[4.6940000000E+04, 4.4986267719E+01, 5.2574182847E+00, 2.6895390527E+01, 4.0061289899E+00, 9.8143019892E-01],
	[4.6945000000E+04, 4.4994792305E+01, 5.2574652073E+00, 2.6904767145E+01, 4.0064318117E+00, 9.8143768976E-01],
	[4.6950000000E+04, 4.5003317597E+01, 5.2575121253E+00, 2.6914146032E+01, 4.0067345615E+00, 9.8144517712E-01],
	[4.6955000000E+04, 4.5011843597E+01, 5.2575590388E+00, 2.6923527188E+01, 4.0070372392E+00, 9.8145266101E-01],
	[4.6960000000E+04, 4.5020370304E+01, 5.2576059476E+00, 2.6932910612E+01, 4.0073398449E+00, 9.8146014141E-01],
	[4.6965000000E+04, 4.5028897718E+01, 5.2576528519E+00, 2.6942296307E+01, 4.0076423787E+00, 9.8146761834E-01],
	[4.6970000000E+04, 4.5037425840E+01, 5.2576997516E+00, 2.6951684271E+01, 4.0079448405E+00, 9.8147509179E-01],
	[4.6975000000E+04, 4.5045954668E+01, 5.2577466467E+00, 2.6961074505E+01, 4.0082472303E+00, 9.8148256177E-01],
	[4.6980000000E+04, 4.5054484204E+01, 5.2577935373E+00, 2.6970467010E+01, 4.0085495482E+00, 9.8149002828E-01],
	[4.6985000000E+04, 4.5063014447E+01, 5.2578404233E+00, 2.6979861786E+01, 4.0088517943E+00, 9.8149749132E-01],
	[4.6990000000E+04, 4.5071545396E+01, 5.2578873047E+00, 2.6989258832E+01, 4.0091539684E+00, 9.8150495089E-01],
	[4.6995000000E+04, 4.5080077053E+01, 5.2579341816E+00, 2.6998658151E+01, 4.0094560706E+00, 9.8151240700E-01],
	[4.7000000000E+04, 4.5088609417E+01, 5.2579810539E+00, 2.7008059740E+01, 4.0097581010E+00, 9.8151985964E-01],
	[4.7005000000E+04, 4.5097142488E+01, 5.2580279216E+00, 2.7017463602E+01, 4.0100600596E+00, 9.8152730882E-01],
	[4.7010000000E+04, 4.5105676266E+01, 5.2580747847E+00, 2.7026869736E+01, 4.0103619463E+00, 9.8153475454E-01],
	[4.7015000000E+04, 4.5114210750E+01, 5.2581216433E+00, 2.7036278143E+01, 4.0106637613E+00, 9.8154219681E-01],
	[4.7020000000E+04, 4.5122745942E+01, 5.2581684973E+00, 2.7045688823E+01, 4.0109655045E+00, 9.8154963562E-01],
	[4.7025000000E+04, 4.5131281841E+01, 5.2582153467E+00, 2.7055101776E+01, 4.0112671759E+00, 9.8155707097E-01],
	[4.7030000000E+04, 4.5139818447E+01, 5.2582621916E+00, 2.7064517002E+01, 4.0115687756E+00, 9.8156450287E-01],
	[4.7035000000E+04, 4.5148355760E+01, 5.2583090320E+00, 2.7073934502E+01, 4.0118703035E+00, 9.8157193132E-01],
	[4.7040000000E+04, 4.5156893779E+01, 5.2583558677E+00, 2.7083354277E+01, 4.0121717598E+00, 9.8157935632E-01],
	[4.7045000000E+04, 4.5165432506E+01, 5.2584026989E+00, 2.7092776326E+01, 4.0124731444E+00, 9.8158677788E-01],
	[4.7050000000E+04, 4.5173971939E+01, 5.2584495255E+00, 2.7102200649E+01, 4.0127744573E+00, 9.8159419599E-01],
	[4.7055000000E+04, 4.5182512079E+01, 5.2584963476E+00, 2.7111627248E+01, 4.0130756986E+00, 9.8160161065E-01],
	[4.7060000000E+04, 4.5191052926E+01, 5.2585431652E+00, 2.7121056122E+01, 4.0133768682E+00, 9.8160902188E-01],
	[4.7065000000E+04, 4.5199594480E+01, 5.2585899781E+00, 2.7130487272E+01, 4.0136779663E+00, 9.8161642966E-01],
	[4.7070000000E+04, 4.5208136741E+01, 5.2586367865E+00, 2.7139920698E+01, 4.0139789927E+00, 9.8162383401E-01],
	[4.7075000000E+04, 4.5216679708E+01, 5.2586835904E+00, 2.7149356400E+01, 4.0142799476E+00, 9.8163123492E-01],
	[4.7080000000E+04, 4.5225223382E+01, 5.2587303897E+00, 2.7158794379E+01, 4.0145808309E+00, 9.8163863239E-01],
	[4.7085000000E+04, 4.5233767763E+01, 5.2587771844E+00, 2.7168234634E+01, 4.0148816428E+00, 9.8164602644E-01],
	[4.7090000000E+04, 4.5242312851E+01, 5.2588239746E+00, 2.7177677167E+01, 4.0151823830E+00, 9.8165341705E-01],
	[4.7095000000E+04, 4.5250858645E+01, 5.2588707603E+00, 2.7187121978E+01, 4.0154830518E+00, 9.8166080424E-01],
	[4.7100000000E+04, 4.5259405147E+01, 5.2589175413E+00, 2.7196569066E+01, 4.0157836492E+00, 9.8166818799E-01],
	[4.7105000000E+04, 4.5267952354E+01, 5.2589643179E+00, 2.7206018432E+01, 4.0160841750E+00, 9.8167556832E-01],
	[4.7110000000E+04, 4.5276500269E+01, 5.2590110899E+00, 2.7215470077E+01, 4.0163846295E+00, 9.8168294523E-01],
	[4.7115000000E+04, 4.5285048890E+01, 5.2590578573E+00, 2.7224924001E+01, 4.0166850125E+00, 9.8169031872E-01],
	[4.7120000000E+04, 4.5293598218E+01, 5.2591046202E+00, 2.7234380204E+01, 4.0169853241E+00, 9.8169768879E-01],
	[4.7125000000E+04, 4.5302148252E+01, 5.2591513786E+00, 2.7243838686E+01, 4.0172855643E+00, 9.8170505544E-01],
	[4.7130000000E+04, 4.5310698994E+01, 5.2591981324E+00, 2.7253299447E+01, 4.0175857332E+00, 9.8171241867E-01],
	[4.7135000000E+04, 4.5319250441E+01, 5.2592448816E+00, 2.7262762489E+01, 4.0178858307E+00, 9.8171977849E-01],
	[4.7140000000E+04, 4.5327802595E+01, 5.2592916263E+00, 2.7272227811E+01, 4.0181858569E+00, 9.8172713490E-01],
	[4.7145000000E+04, 4.5336355456E+01, 5.2593383665E+00, 2.7281695414E+01, 4.0184858118E+00, 9.8173448789E-01],
	[4.7150000000E+04, 4.5344909023E+01, 5.2593851022E+00, 2.7291165297E+01, 4.0187856954E+00, 9.8174183748E-01],
	[4.7155000000E+04, 4.5353463297E+01, 5.2594318332E+00, 2.7300637462E+01, 4.0190855078E+00, 9.8174918366E-01],
	[4.7160000000E+04, 4.5362018278E+01, 5.2594785598E+00, 2.7310111908E+01, 4.0193852488E+00, 9.8175652643E-01],
	[4.7165000000E+04, 4.5370573965E+01, 5.2595252818E+00, 2.7319588636E+01, 4.0196849187E+00, 9.8176386580E-01],
	[4.7170000000E+04, 4.5379130358E+01, 5.2595719993E+00, 2.7329067647E+01, 4.0199845173E+00, 9.8177120177E-01],
	[4.7175000000E+04, 4.5387687458E+01, 5.2596187122E+00, 2.7338548939E+01, 4.0202840448E+00, 9.8177853434E-01],
	[4.7180000000E+04, 4.5396245264E+01, 5.2596654206E+00, 2.7348032515E+01, 4.0205835011E+00, 9.8178586352E-01],
	[4.7185000000E+04, 4.5404803777E+01, 5.2597121245E+00, 2.7357518373E+01, 4.0208828862E+00, 9.8179318929E-01],
	[4.7190000000E+04, 4.5413362996E+01, 5.2597588238E+00, 2.7367006515E+01, 4.0211822002E+00, 9.8180051167E-01],
	[4.7195000000E+04, 4.5421922921E+01, 5.2598055186E+00, 2.7376496940E+01, 4.0214814431E+00, 9.8180783066E-01],
	[4.7200000000E+04, 4.5430483553E+01, 5.2598522089E+00, 2.7385989650E+01, 4.0217806148E+00, 9.8181514626E-01],
	[4.7205000000E+04, 4.5439044891E+01, 5.2598988946E+00, 2.7395484644E+01, 4.0220797155E+00, 9.8182245847E-01],
	[4.7210000000E+04, 4.5447606936E+01, 5.2599455759E+00, 2.7404981922E+01, 4.0223787451E+00, 9.8182976729E-01],
	[4.7215000000E+04, 4.5456169687E+01, 5.2599922525E+00, 2.7414481485E+01, 4.0226777037E+00, 9.8183707272E-01],
	[4.7220000000E+04, 4.5464733144E+01, 5.2600389247E+00, 2.7423983334E+01, 4.0229765913E+00, 9.8184437478E-01],
	[4.7225000000E+04, 4.5473297307E+01, 5.2600855923E+00, 2.7433487468E+01, 4.0232754078E+00, 9.8185167345E-01],
	[4.7230000000E+04, 4.5481862177E+01, 5.2601322554E+00, 2.7442993888E+01, 4.0235741534E+00, 9.8185896874E-01],
	[4.7235000000E+04, 4.5490427753E+01, 5.2601789140E+00, 2.7452502594E+01, 4.0238728280E+00, 9.8186626065E-01],
	[4.7240000000E+04, 4.5498994035E+01, 5.2602255680E+00, 2.7462013586E+01, 4.0241714317E+00, 9.8187354919E-01],
	[4.7245000000E+04, 4.5507561024E+01, 5.2602722175E+00, 2.7471526865E+01, 4.0244699644E+00, 9.8188083435E-01],
	[4.7250000000E+04, 4.5516128718E+01, 5.2603188625E+00, 2.7481042432E+01, 4.0247684262E+00, 9.8188811614E-01],
	[4.7255000000E+04, 4.5524697119E+01, 5.2603655030E+00, 2.7490560285E+01, 4.0250668171E+00, 9.8189539455E-01],
	[4.7260000000E+04, 4.5533266226E+01, 5.2604121390E+00, 2.7500080426E+01, 4.0253651371E+00, 9.8190266960E-01],
	[4.7265000000E+04, 4.5541836040E+01, 5.2604587704E+00, 2.7509602856E+01, 4.0256633863E+00, 9.8190994128E-01],
	[4.7270000000E+04, 4.5550406559E+01, 5.2605053973E+00, 2.7519127573E+01, 4.0259615646E+00, 9.8191720960E-01],
	[4.7275000000E+04, 4.5558977785E+01, 5.2605520197E+00, 2.7528654579E+01, 4.0262596722E+00, 9.8192447455E-01],
	[4.7280000000E+04, 4.5567549716E+01, 5.2605986376E+00, 2.7538183874E+01, 4.0265577089E+00, 9.8193173614E-01],
	[4.7285000000E+04, 4.5576122354E+01, 5.2606452509E+00, 2.7547715458E+01, 4.0268556748E+00, 9.8193899437E-01],
	[4.7290000000E+04, 4.5584695698E+01, 5.2606918598E+00, 2.7557249332E+01, 4.0271535700E+00, 9.8194624924E-01],
	[4.7295000000E+04, 4.5593269748E+01, 5.2607384641E+00, 2.7566785496E+01, 4.0274513945E+00, 9.8195350075E-01],
	[4.7300000000E+04, 4.5601844503E+01, 5.2607850639E+00, 2.7576323949E+01, 4.0277491482E+00, 9.8196074891E-01],
	[4.7305000000E+04, 4.5610419965E+01, 5.2608316592E+00, 2.7585864693E+01, 4.0280468312E+00, 9.8196799372E-01],
	[4.7310000000E+04, 4.5618996133E+01, 5.2608782500E+00, 2.7595407728E+01, 4.0283444435E+00, 9.8197523517E-01],
	[4.7315000000E+04, 4.5627573007E+01, 5.2609248363E+00, 2.7604953054E+01, 4.0286419851E+00, 9.8198247328E-01],
	[4.7320000000E+04, 4.5636150587E+01, 5.2609714181E+00, 2.7614500671E+01, 4.0289394561E+00, 9.8198970803E-01],
	[4.7325000000E+04, 4.5644728873E+01, 5.2610179953E+00, 2.7624050580E+01, 4.0292368565E+00, 9.8199693945E-01],
	[4.7330000000E+04, 4.5653307865E+01, 5.2610645681E+00, 2.7633602781E+01, 4.0295341863E+00, 9.8200416751E-01],
	[4.7335000000E+04, 4.5661887563E+01, 5.2611111363E+00, 2.7643157274E+01, 4.0298314454E+00, 9.8201139224E-01],
	[4.7340000000E+04, 4.5670467966E+01, 5.2611577001E+00, 2.7652714060E+01, 4.0301286340E+00, 9.8201861362E-01],
	[4.7345000000E+04, 4.5679049076E+01, 5.2612042593E+00, 2.7662273138E+01, 4.0304257520E+00, 9.8202583167E-01],
	[4.7350000000E+04, 4.5687630891E+01, 5.2612508140E+00, 2.7671834510E+01, 4.0307227995E+00, 9.8203304638E-01],
	[4.7355000000E+04, 4.5696213413E+01, 5.2612973643E+00, 2.7681398175E+01, 4.0310197765E+00, 9.8204025775E-01],
	[4.7360000000E+04, 4.5704796640E+01, 5.2613439100E+00, 2.7690964135E+01, 4.0313166829E+00, 9.8204746579E-01],
	[4.7365000000E+04, 4.5713380573E+01, 5.2613904512E+00, 2.7700532388E+01, 4.0316135189E+00, 9.8205467050E-01],
	[4.7370000000E+04, 4.5721965212E+01, 5.2614369879E+00, 2.7710102935E+01, 4.0319102844E+00, 9.8206187187E-01],
	[4.7375000000E+04, 4.5730550556E+01, 5.2614835201E+00, 2.7719675778E+01, 4.0322069795E+00, 9.8206906992E-01],
	[4.7380000000E+04, 4.5739136607E+01, 5.2615300478E+00, 2.7729250915E+01, 4.0325036042E+00, 9.8207626465E-01],
	[4.7385000000E+04, 4.5747723363E+01, 5.2615765711E+00, 2.7738828348E+01, 4.0328001584E+00, 9.8208345605E-01],
	[4.7390000000E+04, 4.5756310825E+01, 5.2616230898E+00, 2.7748408077E+01, 4.0330966423E+00, 9.8209064412E-01],
	[4.7395000000E+04, 4.5764898992E+01, 5.2616696040E+00, 2.7757990101E+01, 4.0333930557E+00, 9.8209782888E-01],
	[4.7400000000E+04, 4.5773487866E+01, 5.2617161137E+00, 2.7767574422E+01, 4.0336893989E+00, 9.8210501031E-01],
	[4.7405000000E+04, 4.5782077445E+01, 5.2617626190E+00, 2.7777161039E+01, 4.0339856717E+00, 9.8211218843E-01],
	[4.7410000000E+04, 4.5790667730E+01, 5.2618091197E+00, 2.7786749953E+01, 4.0342818741E+00, 9.8211936323E-01],
	[4.7415000000E+04, 4.5799258720E+01, 5.2618556160E+00, 2.7796341165E+01, 4.0345780063E+00, 9.8212653472E-01],
	[4.7420000000E+04, 4.5807850416E+01, 5.2619021077E+00, 2.7805934674E+01, 4.0348740682E+00, 9.8213370290E-01],
	[4.7425000000E+04, 4.5816442818E+01, 5.2619485950E+00, 2.7815530480E+01, 4.0351700599E+00, 9.8214086776E-01],
	[4.7430000000E+04, 4.5825035925E+01, 5.2619950778E+00, 2.7825128585E+01, 4.0354659813E+00, 9.8214802932E-01],
	[4.7435000000E+04, 4.5833629738E+01, 5.2620415561E+00, 2.7834728988E+01, 4.0357618325E+00, 9.8215518757E-01],
	[4.7440000000E+04, 4.5842224257E+01, 5.2620880298E+00, 2.7844331690E+01, 4.0360576135E+00, 9.8216234252E-01],
	[4.7445000000E+04, 4.5850819481E+01, 5.2621344992E+00, 2.7853936691E+01, 4.0363533243E+00, 9.8216949416E-01],
	[4.7450000000E+04, 4.5859415410E+01, 5.2621809640E+00, 2.7863543992E+01, 4.0366489649E+00, 9.8217664250E-01],
	[4.7455000000E+04, 4.5868012045E+01, 5.2622274243E+00, 2.7873153592E+01, 4.0369445354E+00, 9.8218378754E-01],
	[4.7460000000E+04, 4.5876609386E+01, 5.2622738802E+00, 2.7882765492E+01, 4.0372400357E+00, 9.8219092928E-01],
	[4.7465000000E+04, 4.5885207432E+01, 5.2623203315E+00, 2.7892379692E+01, 4.0375354660E+00, 9.8219806773E-01],
	[4.7470000000E+04, 4.5893806184E+01, 5.2623667784E+00, 2.7901996193E+01, 4.0378308261E+00, 9.8220520288E-01],
	[4.7475000000E+04, 4.5902405641E+01, 5.2624132208E+00, 2.7911614995E+01, 4.0381261162E+00, 9.8221233474E-01],
	[4.7480000000E+04, 4.5911005804E+01, 5.2624596588E+00, 2.7921236098E+01, 4.0384213362E+00, 9.8221946331E-01],
	[4.7485000000E+04, 4.5919606672E+01, 5.2625060922E+00, 2.7930859502E+01, 4.0387164862E+00, 9.8222658859E-01],
	[4.7490000000E+04, 4.5928208245E+01, 5.2625525212E+00, 2.7940485208E+01, 4.0390115662E+00, 9.8223371058E-01],
	[4.7495000000E+04, 4.5936810524E+01, 5.2625989456E+00, 2.7950113217E+01, 4.0393065762E+00, 9.8224082928E-01],
	[4.7500000000E+04, 4.5945413508E+01, 5.2626453656E+00, 2.7959743527E+01, 4.0396015162E+00, 9.8224794470E-01],
	[4.7505000000E+04, 4.5954017198E+01, 5.2626917812E+00, 2.7969376141E+01, 4.0398963862E+00, 9.8225505684E-01],
	[4.7510000000E+04, 4.5962621593E+01, 5.2627381922E+00, 2.7979011058E+01, 4.0401911863E+00, 9.8226216570E-01],
	[4.7515000000E+04, 4.5971226693E+01, 5.2627845988E+00, 2.7988648278E+01, 4.0404859165E+00, 9.8226927128E-01],
	[4.7520000000E+04, 4.5979832499E+01, 5.2628310009E+00, 2.7998287801E+01, 4.0407805767E+00, 9.8227637359E-01],
	[4.7525000000E+04, 4.5988439010E+01, 5.2628773985E+00, 2.8007929629E+01, 4.0410751671E+00, 9.8228347261E-01],
	[4.7530000000E+04, 4.5997062072E+01, 5.2629254780E+00, 2.8017573760E+01, 4.0413708043E+00, 9.8229056837E-01],
	[4.7535000000E+04, 4.6005686246E+01, 5.2629735956E+00, 2.8027220197E+01, 4.0416664001E+00, 9.8229766085E-01],
	[4.7540000000E+04, 4.6014311129E+01, 5.2630217086E+00, 2.8036868938E+01, 4.0419619262E+00, 9.8230475007E-01],
	[4.7545000000E+04, 4.6022936722E+01, 5.2630698170E+00, 2.8046519985E+01, 4.0422573827E+00, 9.8231183601E-01],
	[4.7550000000E+04, 4.6031563025E+01, 5.2631179208E+00, 2.8056173337E+01, 4.0425527695E+00, 9.8231891869E-01],
	[4.7555000000E+04, 4.6040190037E+01, 5.2631660199E+00, 2.8065828995E+01, 4.0428480867E+00, 9.8232599810E-01],
	[4.7560000000E+04, 4.6048817758E+01, 5.2632141144E+00, 2.8075486958E+01, 4.0431433342E+00, 9.8233307426E-01],
	[4.7565000000E+04, 4.6057446190E+01, 5.2632622043E+00, 2.8085147229E+01, 4.0434385122E+00, 9.8234014715E-01],
	[4.7570000000E+04, 4.6066075330E+01, 5.2633102896E+00, 2.8094809806E+01, 4.0437336206E+00, 9.8234721678E-01],
	[4.7575000000E+04, 4.6074705181E+01, 5.2633583703E+00, 2.8104474690E+01, 4.0440286595E+00, 9.8235428315E-01],
	[4.7580000000E+04, 4.6083335741E+01, 5.2634064463E+00, 2.8114141882E+01, 4.0443236288E+00, 9.8236134627E-01],
	[4.7585000000E+04, 4.6091967010E+01, 5.2634545178E+00, 2.8123811381E+01, 4.0446185286E+00, 9.8236840613E-01],
	[4.7590000000E+04, 4.6100598989E+01, 5.2635025846E+00, 2.8133483188E+01, 4.0449133589E+00, 9.8237546274E-01],
	[4.7595000000E+04, 4.6109231677E+01, 5.2635506468E+00, 2.8143157303E+01, 4.0452081197E+00, 9.8238251610E-01],
	[4.7600000000E+04, 4.6117865075E+01, 5.2635987044E+00, 2.8152833727E+01, 4.0455028110E+00, 9.8238956621E-01],
	[4.7605000000E+04, 4.6126499182E+01, 5.2636467574E+00, 2.8162512460E+01, 4.0457974330E+00, 9.8239661307E-01],
	[4.7610000000E+04, 4.6135133998E+01, 5.2636948058E+00, 2.8172193502E+01, 4.0460919854E+00, 9.8240365669E-01],
	[4.7615000000E+04, 4.6143769524E+01, 5.2637428496E+00, 2.8181876854E+01, 4.0463864685E+00, 9.8241069706E-01],
	[4.7620000000E+04, 4.6152405759E+01, 5.2637908888E+00, 2.8191562515E+01, 4.0466808822E+00, 9.8241773419E-01],
	[4.7625000000E+04, 4.6161042704E+01, 5.2638389234E+00, 2.8201250487E+01, 4.0469752265E+00, 9.8242476808E-01],
	[4.7630000000E+04, 4.6169680358E+01, 5.2638869534E+00, 2.8210940769E+01, 4.0472695015E+00, 9.8243179872E-01],
	[4.7635000000E+04, 4.6178318721E+01, 5.2639349787E+00, 2.8220633361E+01, 4.0475637071E+00, 9.8243882613E-01],
	[4.7640000000E+04, 4.6186957794E+01, 5.2639829995E+00, 2.8230328265E+01, 4.0478578435E+00, 9.8244585030E-01],
	[4.7645000000E+04, 4.6195597576E+01, 5.2640310157E+00, 2.8240025480E+01, 4.0481519105E+00, 9.8245287124E-01],
	[4.7650000000E+04, 4.6204238067E+01, 5.2640790272E+00, 2.8249725007E+01, 4.0484459082E+00, 9.8245988894E-01],
	[4.7655000000E+04, 4.6212879267E+01, 5.2641270342E+00, 2.8259426846E+01, 4.0487398367E+00, 9.8246690341E-01],
	[4.7660000000E+04, 4.6221521177E+01, 5.2641750365E+00, 2.8269130997E+01, 4.0490336960E+00, 9.8247391465E-01],
	[4.7665000000E+04, 4.6230163796E+01, 5.2642230343E+00, 2.8278837460E+01, 4.0493274860E+00, 9.8248092266E-01],
	[4.7670000000E+04, 4.6238807124E+01, 5.2642710275E+00, 2.8288546237E+01, 4.0496212068E+00, 9.8248792744E-01],
	[4.7675000000E+04, 4.6247451161E+01, 5.2643190160E+00, 2.8298257326E+01, 4.0499148585E+00, 9.8249492900E-01],
	[4.7680000000E+04, 4.6256095908E+01, 5.2643670000E+00, 2.8307970730E+01, 4.0502084409E+00, 9.8250192733E-01],
	[4.7685000000E+04, 4.6264741364E+01, 5.2644149794E+00, 2.8317686447E+01, 4.0505019542E+00, 9.8250892244E-01],
	[4.7690000000E+04, 4.6273387528E+01, 5.2644629542E+00, 2.8327404478E+01, 4.0507953984E+00, 9.8251591433E-01],
	[4.7695000000E+04, 4.6282034402E+01, 5.2645109244E+00, 2.8337124823E+01, 4.0510887735E+00, 9.8252290300E-01],
	[4.7700000000E+04, 4.6290681985E+01, 5.2645588900E+00, 2.8346847484E+01, 4.0513820795E+00, 9.8252988845E-01],
	[4.7705000000E+04, 4.6299330277E+01, 5.2646068510E+00, 2.8356572459E+01, 4.0516753164E+00, 9.8253687068E-01],
	[4.7710000000E+04, 4.6307979279E+01, 5.2646548074E+00, 2.8366299750E+01, 4.0519684842E+00, 9.8254384970E-01],
	[4.7715000000E+04, 4.6316628989E+01, 5.2647027593E+00, 2.8376029356E+01, 4.0522615830E+00, 9.8255082551E-01],
	[4.7720000000E+04, 4.6325279408E+01, 5.2647507065E+00, 2.8385761278E+01, 4.0525546128E+00, 9.8255779810E-01],
	[4.7725000000E+04, 4.6333930537E+01, 5.2647986492E+00, 2.8395495517E+01, 4.0528475736E+00, 9.8256476748E-01],
	[4.7730000000E+04, 4.6342582374E+01, 5.2648465873E+00, 2.8405232072E+01, 4.0531404654E+00, 9.8257173366E-01],
	[4.7735000000E+04, 4.6351234921E+01, 5.2648945208E+00, 2.8414970944E+01, 4.0534332882E+00, 9.8257869662E-01],
	[4.7740000000E+04, 4.6359888176E+01, 5.2649424497E+00, 2.8424712134E+01, 4.0537260421E+00, 9.8258565638E-01],
	[4.7745000000E+04, 4.6368542140E+01, 5.2649903740E+00, 2.8434455641E+01, 4.0540187270E+00, 9.8259261294E-01],
	[4.7750000000E+04, 4.6377196814E+01, 5.2650382937E+00, 2.8444201465E+01, 4.0543113431E+00, 9.8259956629E-01],
	[4.7755000000E+04, 4.6385852196E+01, 5.2650862089E+00, 2.8453949608E+01, 4.0546038902E+00, 9.8260651645E-01],
	[4.7760000000E+04, 4.6394508287E+01, 5.2651341195E+00, 2.8463700069E+01, 4.0548963685E+00, 9.8261346340E-01],
	[4.7765000000E+04, 4.6403165087E+01, 5.2651820255E+00, 2.8473452849E+01, 4.0551887779E+00, 9.8262040716E-01],
	[4.7770000000E+04, 4.6411822596E+01, 5.2652299269E+00, 2.8483207948E+01, 4.0554811185E+00, 9.8262734772E-01],
	[4.7775000000E+04, 4.6420480814E+01, 5.2652778237E+00, 2.8492965367E+01, 4.0557733902E+00, 9.8263428508E-01],
	[4.7780000000E+04, 4.6429139741E+01, 5.2653257160E+00, 2.8502725105E+01, 4.0560655932E+00, 9.8264121925E-01],
	[4.7785000000E+04, 4.6437799376E+01, 5.2653736037E+00, 2.8512487163E+01, 4.0563577274E+00, 9.8264815023E-01],
	[4.7790000000E+04, 4.6446459721E+01, 5.2654214868E+00, 2.8522251541E+01, 4.0566497928E+00, 9.8265507802E-01],
	[4.7795000000E+04, 4.6455120774E+01, 5.2654693653E+00, 2.8532018240E+01, 4.0569417894E+00, 9.8266200262E-01],
	[4.7800000000E+04, 4.6463782536E+01, 5.2655172393E+00, 2.8541787260E+01, 4.0572337174E+00, 9.8266892404E-01],
	[4.7805000000E+04, 4.6472445006E+01, 5.2655651087E+00, 2.8551558601E+01, 4.0575255766E+00, 9.8267584227E-01],
	[4.7810000000E+04, 4.6481108186E+01, 5.2656129735E+00, 2.8561332264E+01, 4.0578173671E+00, 9.8268275731E-01],
	[4.7815000000E+04, 4.6489772074E+01, 5.2656608338E+00, 2.8571108248E+01, 4.0581090890E+00, 9.8268966917E-01],
	[4.7820000000E+04, 4.6498436671E+01, 5.2657086895E+00, 2.8580886555E+01, 4.0584007422E+00, 9.8269657785E-01],
	[4.7825000000E+04, 4.6507101977E+01, 5.2657565406E+00, 2.8590667184E+01, 4.0586923268E+00, 9.8270348336E-01],
	[4.7830000000E+04, 4.6515767991E+01, 5.2658043871E+00, 2.8600450136E+01, 4.0589838427E+00, 9.8271038568E-01],
	[4.7835000000E+04, 4.6524434714E+01, 5.2658522291E+00, 2.8610235410E+01, 4.0592752901E+00, 9.8271728483E-01],
	[4.7840000000E+04, 4.6533102146E+01, 5.2659000665E+00, 2.8620023009E+01, 4.0595666688E+00, 9.8272418080E-01],
	[4.7845000000E+04, 4.6541770286E+01, 5.2659478994E+00, 2.8629812930E+01, 4.0598579790E+00, 9.8273107361E-01],
	[4.7850000000E+04, 4.6550439135E+01, 5.2659957277E+00, 2.8639605176E+01, 4.0601492207E+00, 9.8273796323E-01],
	[4.7855000000E+04, 4.6559108693E+01, 5.2660435514E+00, 2.8649399746E+01, 4.0604403938E+00, 9.8274484969E-01],
	[4.7860000000E+04, 4.6567778959E+01, 5.2660913705E+00, 2.8659196641E+01, 4.0607314984E+00, 9.8275173299E-01],
	[4.7865000000E+04, 4.6576449934E+01, 5.2661391851E+00, 2.8668995861E+01, 4.0610225346E+00, 9.8275861311E-01],
	[4.7870000000E+04, 4.6585121617E+01, 5.2661869952E+00, 2.8678797406E+01, 4.0613135022E+00, 9.8276549007E-01],
	[4.7875000000E+04, 4.6593794009E+01, 5.2662348007E+00, 2.8688601276E+01, 4.0616044014E+00, 9.8277236387E-01],
	[4.7880000000E+04, 4.6602467110E+01, 5.2662826016E+00, 2.8698407473E+01, 4.0618952322E+00, 9.8277923450E-01],
	[4.7885000000E+04, 4.6611140918E+01, 5.2663303979E+00, 2.8708215995E+01, 4.0621859945E+00, 9.8278610197E-01],
	[4.7890000000E+04, 4.6619815436E+01, 5.2663781898E+00, 2.8718026844E+01, 4.0624766885E+00, 9.8279296629E-01],
	[4.7895000000E+04, 4.6628490662E+01, 5.2664259770E+00, 2.8727840019E+01, 4.0627673141E+00, 9.8279982744E-01],
	[4.7900000000E+04, 4.6637166596E+01, 5.2664737597E+00, 2.8737655522E+01, 4.0630578713E+00, 9.8280668544E-01],
	[4.7905000000E+04, 4.6645843239E+01, 5.2665215378E+00, 2.8747473352E+01, 4.0633483601E+00, 9.8281354029E-01],
	[4.7910000000E+04, 4.6654520590E+01, 5.2665693114E+00, 2.8757293510E+01, 4.0636387806E+00, 9.8282039198E-01],
	[4.7915000000E+04, 4.6663198650E+01, 5.2666170805E+00, 2.8767115996E+01, 4.0639291329E+00, 9.8282724052E-01],
	[4.7920000000E+04, 4.6671877418E+01, 5.2666648450E+00, 2.8776940810E+01, 4.0642194168E+00, 9.8283408592E-01],
	[4.7925000000E+04, 4.6680556895E+01, 5.2667126049E+00, 2.8786767952E+01, 4.0645096325E+00, 9.8284092816E-01],
	[4.7930000000E+04, 4.6689237080E+01, 5.2667603603E+00, 2.8796597424E+01, 4.0647997799E+00, 9.8284776726E-01],
	[4.7935000000E+04, 4.6697917973E+01, 5.2668081111E+00, 2.8806429225E+01, 4.0650898590E+00, 9.8285460321E-01],
	[4.7940000000E+04, 4.6706599574E+01, 5.2668558574E+00, 2.8816263355E+01, 4.0653798700E+00, 9.8286143602E-01],
	[4.7945000000E+04, 4.6715281884E+01, 5.2669035991E+00, 2.8826099816E+01, 4.0656698128E+00, 9.8286826568E-01],
	[4.7950000000E+04, 4.6723964903E+01, 5.2669513363E+00, 2.8835938606E+01, 4.0659596873E+00, 9.8287509221E-01],
	[4.7955000000E+04, 4.6732648629E+01, 5.2669990690E+00, 2.8845779727E+01, 4.0662494937E+00, 9.8288191560E-01],
	[4.7960000000E+04, 4.6741333064E+01, 5.2670467971E+00, 2.8855623178E+01, 4.0665392320E+00, 9.8288873585E-01],
	[4.7965000000E+04, 4.6750018207E+01, 5.2670945207E+00, 2.8865468961E+01, 4.0668289021E+00, 9.8289555296E-01],
	[4.7970000000E+04, 4.6758704058E+01, 5.2671422397E+00, 2.8875317075E+01, 4.0671185042E+00, 9.8290236694E-01],
	[4.7975000000E+04, 4.6767390618E+01, 5.2671899542E+00, 2.8885167521E+01, 4.0674080381E+00, 9.8290917779E-01],
	[4.7980000000E+04, 4.6776077885E+01, 5.2672376641E+00, 2.8895020299E+01, 4.0676975040E+00, 9.8291598550E-01],
	[4.7985000000E+04, 4.6784765861E+01, 5.2672853695E+00, 2.8904875409E+01, 4.0679869018E+00, 9.8292279009E-01],
	[4.7990000000E+04, 4.6793454545E+01, 5.2673330704E+00, 2.8914732852E+01, 4.0682762316E+00, 9.8292959155E-01],
	[4.7995000000E+04, 4.6802143938E+01, 5.2673807667E+00, 2.8924592627E+01, 4.0685654933E+00, 9.8293638988E-01],
	[4.8000000000E+04, 4.6810834038E+01, 5.2674284585E+00, 2.8934454736E+01, 4.0688546871E+00, 9.8294318508E-01],
	[4.8005000000E+04, 4.6819524847E+01, 5.2674761457E+00, 2.8944319179E+01, 4.0691438129E+00, 9.8294997717E-01],
	[4.8010000000E+04, 4.6828216363E+01, 5.2675238285E+00, 2.8954185955E+01, 4.0694328707E+00, 9.8295676613E-01],
	[4.8015000000E+04, 4.6836908588E+01, 5.2675715066E+00, 2.8964055065E+01, 4.0697218606E+00, 9.8296355197E-01],
	[4.8020000000E+04, 4.6845601521E+01, 5.2676191803E+00, 2.8973926510E+01, 4.0700107825E+00, 9.8297033469E-01],
	[4.8025000000E+04, 4.6854295162E+01, 5.2676668494E+00, 2.8983800290E+01, 4.0702996366E+00, 9.8297711429E-01],
	[4.8030000000E+04, 4.6862989511E+01, 5.2677145140E+00, 2.8993676405E+01, 4.0705884227E+00, 9.8298389078E-01],
	[4.8035000000E+04, 4.6871684568E+01, 5.2677621740E+00, 2.9003554855E+01, 4.0708771410E+00, 9.8299066416E-01],
	[4.8040000000E+04, 4.6880380333E+01, 5.2678098296E+00, 2.9013435641E+01, 4.0711657914E+00, 9.8299743442E-01],
	[4.8045000000E+04, 4.6889076806E+01, 5.2678574806E+00, 2.9023318763E+01, 4.0714543740E+00, 9.8300420157E-01],
	[4.8050000000E+04, 4.6897773987E+01, 5.2679051270E+00, 2.9033204221E+01, 4.0717428888E+00, 9.8301096561E-01],
	[4.8055000000E+04, 4.6906471876E+01, 5.2679527690E+00, 2.9043092016E+01, 4.0720313357E+00, 9.8301772654E-01],
	[4.8060000000E+04, 4.6915170473E+01, 5.2680004064E+00, 2.9052982148E+01, 4.0723197149E+00, 9.8302448437E-01],
	[4.8065000000E+04, 4.6923869778E+01, 5.2680480393E+00, 2.9062874617E+01, 4.0726080263E+00, 9.8303123909E-01],
	[4.8070000000E+04, 4.6932569790E+01, 5.2680956677E+00, 2.9072769424E+01, 4.0728962700E+00, 9.8303799071E-01],
	[4.8075000000E+04, 4.6941270511E+01, 5.2681432915E+00, 2.9082666568E+01, 4.0731844459E+00, 9.8304473922E-01],
	[4.8080000000E+04, 4.6949971940E+01, 5.2681909108E+00, 2.9092566051E+01, 4.0734725542E+00, 9.8305148464E-01],
	[4.8085000000E+04, 4.6958674076E+01, 5.2682385256E+00, 2.9102467872E+01, 4.0737605947E+00, 9.8305822695E-01],
	[4.8090000000E+04, 4.6967376921E+01, 5.2682861359E+00, 2.9112372032E+01, 4.0740485676E+00, 9.8306496617E-01],
	[4.8095000000E+04, 4.6976080473E+01, 5.2683337417E+00, 2.9122278531E+01, 4.0743364728E+00, 9.8307170230E-01],
	[4.8100000000E+04, 4.6984784733E+01, 5.2683813429E+00, 2.9132187370E+01, 4.0746243104E+00, 9.8307843532E-01],
	[4.8105000000E+04, 4.6993489701E+01, 5.2684289396E+00, 2.9142098548E+01, 4.0749120804E+00, 9.8308516526E-01],
	[4.8110000000E+04, 4.7002195376E+01, 5.2684765318E+00, 2.9152012066E+01, 4.0751997827E+00, 9.8309189211E-01],
	[4.8115000000E+04, 4.7010901759E+01, 5.2685241195E+00, 2.9161927925E+01, 4.0754874175E+00, 9.8309861586E-01],
	[4.8120000000E+04, 4.7019608851E+01, 5.2685717027E+00, 2.9171846124E+01, 4.0757749847E+00, 9.8310533653E-01],
	[4.8125000000E+04, 4.7028316650E+01, 5.2686192814E+00, 2.9181766665E+01, 4.0760624844E+00, 9.8311205411E-01],
	[4.8130000000E+04, 4.7037025156E+01, 5.2686668555E+00, 2.9191689546E+01, 4.0763499165E+00, 9.8311876860E-01],
	[4.8135000000E+04, 4.7045734370E+01, 5.2687144251E+00, 2.9201614769E+01, 4.0766372812E+00, 9.8312548002E-01],
	[4.8140000000E+04, 4.7054444292E+01, 5.2687619903E+00, 2.9211542334E+01, 4.0769245783E+00, 9.8313218835E-01],
	[4.8145000000E+04, 4.7063154922E+01, 5.2688095509E+00, 2.9221472241E+01, 4.0772118080E+00, 9.8313889360E-01],
	[4.8150000000E+04, 4.7071866260E+01, 5.2688571070E+00, 2.9231404491E+01, 4.0774989702E+00, 9.8314559577E-01],
	[4.8155000000E+04, 4.7080578305E+01, 5.2689046586E+00, 2.9241339083E+01, 4.0777860650E+00, 9.8315229486E-01],
	[4.8160000000E+04, 4.7089291057E+01, 5.2689522057E+00, 2.9251276019E+01, 4.0780730923E+00, 9.8315899088E-01],
	[4.8165000000E+04, 4.7098004518E+01, 5.2689997482E+00, 2.9261215298E+01, 4.0783600523E+00, 9.8316568382E-01],
	[4.8170000000E+04, 4.7106718685E+01, 5.2690472863E+00, 2.9271156921E+01, 4.0786469448E+00, 9.8317237369E-01],
	[4.8175000000E+04, 4.7115433561E+01, 5.2690948199E+00, 2.9281100887E+01, 4.0789337700E+00, 9.8317906049E-01],
	[4.8180000000E+04, 4.7124149144E+01, 5.2691423489E+00, 2.9291047198E+01, 4.0792205279E+00, 9.8318574422E-01],
	[4.8185000000E+04, 4.7132865435E+01, 5.2691898735E+00, 2.9300995854E+01, 4.0795072184E+00, 9.8319242488E-01],
	[4.8190000000E+04, 4.7141582433E+01, 5.2692373936E+00, 2.9310946855E+01, 4.0797938416E+00, 9.8319910247E-01],
	[4.8195000000E+04, 4.7150300138E+01, 5.2692849091E+00, 2.9320900201E+01, 4.0800803975E+00, 9.8320577700E-01],
	[4.8200000000E+04, 4.7159018552E+01, 5.2693324202E+00, 2.9330855893E+01, 4.0803668862E+00, 9.8321244847E-01],
	[4.8205000000E+04, 4.7167737672E+01, 5.2693799267E+00, 2.9340813930E+01, 4.0806533076E+00, 9.8321911687E-01],
	[4.8210000000E+04, 4.7176457500E+01, 5.2694274288E+00, 2.9350774314E+01, 4.0809396617E+00, 9.8322578221E-01],
	[4.8215000000E+04, 4.7185178036E+01, 5.2694749263E+00, 2.9360737044E+01, 4.0812259486E+00, 9.8323244450E-01],
	[4.8220000000E+04, 4.7193899279E+01, 5.2695224194E+00, 2.9370702121E+01, 4.0815121683E+00, 9.8323910372E-01],
	[4.8225000000E+04, 4.7202621229E+01, 5.2695699080E+00, 2.9380669546E+01, 4.0817983209E+00, 9.8324575989E-01],
	[4.8230000000E+04, 4.7211343887E+01, 5.2696173920E+00, 2.9390639317E+01, 4.0820844062E+00, 9.8325241301E-01],
	[4.8235000000E+04, 4.7220067253E+01, 5.2696648716E+00, 2.9400611437E+01, 4.0823704245E+00, 9.8325906307E-01],
	[4.8240000000E+04, 4.7228791325E+01, 5.2697123467E+00, 2.9410585904E+01, 4.0826563755E+00, 9.8326571008E-01],
	[4.8245000000E+04, 4.7237516105E+01, 5.2697598173E+00, 2.9420562720E+01, 4.0829422595E+00, 9.8327235404E-01],
	[4.8250000000E+04, 4.7246241593E+01, 5.2698072834E+00, 2.9430541885E+01, 4.0832280764E+00, 9.8327899496E-01],
	[4.8255000000E+04, 4.7254967787E+01, 5.2698547450E+00, 2.9440523398E+01, 4.0835138262E+00, 9.8328563282E-01],
	[4.8260000000E+04, 4.7263694689E+01, 5.2699022021E+00, 2.9450507261E+01, 4.0837995089E+00, 9.8329226764E-01],
	[4.8265000000E+04, 4.7272422298E+01, 5.2699496547E+00, 2.9460493473E+01, 4.0840851246E+00, 9.8329889942E-01],
	[4.8270000000E+04, 4.7281150615E+01, 5.2699971028E+00, 2.9470482036E+01, 4.0843706733E+00, 9.8330552815E-01],
	[4.8275000000E+04, 4.7289879639E+01, 5.2700445465E+00, 2.9480472948E+01, 4.0846561550E+00, 9.8331215385E-01],
	[4.8280000000E+04, 4.7298609370E+01, 5.2700919857E+00, 2.9490466211E+01, 4.0849415696E+00, 9.8331877650E-01],
	[4.8285000000E+04, 4.7307339808E+01, 5.2701394203E+00, 2.9500461825E+01, 4.0852269174E+00, 9.8332539612E-01],
	[4.8290000000E+04, 4.7316070954E+01, 5.2701868505E+00, 2.9510459791E+01, 4.0855121981E+00, 9.8333201270E-01],
	[4.8295000000E+04, 4.7324818339E+01, 5.2702358948E+00, 2.9520460107E+01, 4.0857985005E+00, 9.8333862624E-01],
	[4.8300000000E+04, 4.7333567128E+01, 5.2702850066E+00, 2.9530462775E+01, 4.0860847847E+00, 9.8334523675E-01],
	[4.8305000000E+04, 4.7342316629E+01, 5.2703341138E+00, 2.9540467796E+01, 4.0863710021E+00, 9.8335184423E-01],
	[4.8310000000E+04, 4.7351066841E+01, 5.2703832163E+00, 2.9550475169E+01, 4.0866571527E+00, 9.8335844869E-01],
	[4.8315000000E+04, 4.7359817765E+01, 5.2704323143E+00, 2.9560484894E+01, 4.0869432366E+00, 9.8336505011E-01],
	[4.8320000000E+04, 4.7368569400E+01, 5.2704814076E+00, 2.9570496973E+01, 4.0872292539E+00, 9.8337164850E-01],
	[4.8325000000E+04, 4.7377321747E+01, 5.2705304963E+00, 2.9580511404E+01, 4.0875152044E+00, 9.8337824387E-01],
	[4.8330000000E+04, 4.7386074805E+01, 5.2705795803E+00, 2.9590528190E+01, 4.0878010883E+00, 9.8338483622E-01],
	[4.8335000000E+04, 4.7394828574E+01, 5.2706286598E+00, 2.9600547329E+01, 4.0880869055E+00, 9.8339142554E-01],
	[4.8340000000E+04, 4.7403583055E+01, 5.2706777346E+00, 2.9610568823E+01, 4.0883726560E+00, 9.8339801184E-01],
	[4.8345000000E+04, 4.7412338247E+01, 5.2707268048E+00, 2.9620592671E+01, 4.0886583400E+00, 9.8340459512E-01],
	[4.8350000000E+04, 4.7421094150E+01, 5.2707758704E+00, 2.9630618874E+01, 4.0889439573E+00, 9.8341117538E-01],
	[4.8355000000E+04, 4.7429850765E+01, 5.2708249314E+00, 2.9640647432E+01, 4.0892295081E+00, 9.8341775263E-01],
	[4.8360000000E+04, 4.7438608091E+01, 5.2708739877E+00, 2.9650678346E+01, 4.0895149923E+00, 9.8342432686E-01],
	[4.8365000000E+04, 4.7447366128E+01, 5.2709230395E+00, 2.9660711615E+01, 4.0898004100E+00, 9.8343089808E-01],
	[4.8370000000E+04, 4.7456124877E+01, 5.2709720866E+00, 2.9670747241E+01, 4.0900857611E+00, 9.8343746629E-01],
	[4.8375000000E+04, 4.7464884337E+01, 5.2710211291E+00, 2.9680785223E+01, 4.0903710457E+00, 9.8344403149E-01],
	[4.8380000000E+04, 4.7473644508E+01, 5.2710701670E+00, 2.9690825562E+01, 4.0906562638E+00, 9.8345059367E-01],
	[4.8385000000E+04, 4.7482405390E+01, 5.2711192003E+00, 2.9700868257E+01, 4.0909414155E+00, 9.8345715285E-01],
	[4.8390000000E+04, 4.7491166984E+01, 5.2711682290E+00, 2.9710913310E+01, 4.0912265007E+00, 9.8346370903E-01],
	[4.8395000000E+04, 4.7499929288E+01, 5.2712172530E+00, 2.9720960721E+01, 4.0915115194E+00, 9.8347026220E-01],
	[4.8400000000E+04, 4.7508692304E+01, 5.2712662725E+00, 2.9731010490E+01, 4.0917964718E+00, 9.8347681236E-01],
	[4.8405000000E+04, 4.7517456031E+01, 5.2713152873E+00, 2.9741062617E+01, 4.0920813577E+00, 9.8348335953E-01],
	[4.8410000000E+04, 4.7526220470E+01, 5.2713642976E+00, 2.9751117102E+01, 4.0923661772E+00, 9.8348990369E-01],
	[4.8415000000E+04, 4.7534985619E+01, 5.2714133032E+00, 2.9761173947E+01, 4.0926509304E+00, 9.8349644486E-01],
	[4.8420000000E+04, 4.7543751480E+01, 5.2714623043E+00, 2.9771233150E+01, 4.0929356172E+00, 9.8350298303E-01],
	[4.8425000000E+04, 4.7552518051E+01, 5.2715113007E+00, 2.9781294713E+01, 4.0932202377E+00, 9.8350951820E-01],
	[4.8430000000E+04, 4.7561285334E+01, 5.2715602925E+00, 2.9791358636E+01, 4.0935047919E+00, 9.8351605038E-01],
	[4.8435000000E+04, 4.7570053328E+01, 5.2716092797E+00, 2.9801424919E+01, 4.0937892798E+00, 9.8352257957E-01],
	[4.8440000000E+04, 4.7578822033E+01, 5.2716582624E+00, 2.9811493562E+01, 4.0940737014E+00, 9.8352910577E-01],
	[4.8445000000E+04, 4.7587591449E+01, 5.2717072404E+00, 2.9821564567E+01, 4.0943580567E+00, 9.8353562898E-01],
	[4.8450000000E+04, 4.7596361576E+01, 5.2717562138E+00, 2.9831637932E+01, 4.0946423458E+00, 9.8354214920E-01],
	[4.8455000000E+04, 4.7605132413E+01, 5.2718051826E+00, 2.9841713658E+01, 4.0949265686E+00, 9.8354866643E-01],
	[4.8460000000E+04, 4.7613903962E+01, 5.2718541468E+00, 2.9851791746E+01, 4.0952107253E+00, 9.8355518068E-01],
	[4.8465000000E+04, 4.7622676222E+01, 5.2719031065E+00, 2.9861872197E+01, 4.0954948158E+00, 9.8356169195E-01],
	[4.8470000000E+04, 4.7631449193E+01, 5.2719520615E+00, 2.9871955009E+01, 4.0957788401E+00, 9.8356820023E-01],
	[4.8475000000E+04, 4.7640222875E+01, 5.2720010119E+00, 2.9882040184E+01, 4.0960627982E+00, 9.8357470553E-01],
	[4.8480000000E+04, 4.7648997268E+01, 5.2720499578E+00, 2.9892127722E+01, 4.0963466902E+00, 9.8358120786E-01],
	[4.8485000000E+04, 4.7657772372E+01, 5.2720988990E+00, 2.9902217623E+01, 4.0966305161E+00, 9.8358770721E-01],
	[4.8490000000E+04, 4.7666548186E+01, 5.2721478357E+00, 2.9912309888E+01, 4.0969142759E+00, 9.8359420358E-01],
	[4.8495000000E+04, 4.7675324712E+01, 5.2721967677E+00, 2.9922404517E+01, 4.0971979696E+00, 9.8360069698E-01],
	[4.8500000000E+04, 4.7684101948E+01, 5.2722456952E+00, 2.9932501509E+01, 4.0974815972E+00, 9.8360718740E-01],
	[4.8505000000E+04, 4.7692879895E+01, 5.2722946181E+00, 2.9942600866E+01, 4.0977651588E+00, 9.8361367485E-01],
	[4.8510000000E+04, 4.7701658553E+01, 5.2723435364E+00, 2.9952702588E+01, 4.0980486543E+00, 9.8362015934E-01],
	[4.8515000000E+04, 4.7710437922E+01, 5.2723924501E+00, 2.9962806675E+01, 4.0983320838E+00, 9.8362664085E-01],
	[4.8520000000E+04, 4.7719218002E+01, 5.2724413592E+00, 2.9972913127E+01, 4.0986154474E+00, 9.8363311940E-01],
	[4.8525000000E+04, 4.7727998792E+01, 5.2724902638E+00, 2.9983021945E+01, 4.0988987449E+00, 9.8363959498E-01],
	[4.8530000000E+04, 4.7736780293E+01, 5.2725391637E+00, 2.9993133129E+01, 4.0991819766E+00, 9.8364606760E-01],
	[4.8535000000E+04, 4.7745562505E+01, 5.2725880591E+00, 3.0003246680E+01, 4.0994651422E+00, 9.8365253726E-01],
	[4.8540000000E+04, 4.7754345428E+01, 5.2726369498E+00, 3.0013362597E+01, 4.0997482419E+00, 9.8365900396E-01],
	[4.8545000000E+04, 4.7763129062E+01, 5.2726858360E+00, 3.0023480881E+01, 4.1000312758E+00, 9.8366546769E-01],
	[4.8550000000E+04, 4.7771913406E+01, 5.2727347177E+00, 3.0033601532E+01, 4.1003142437E+00, 9.8367192847E-01],
	[4.8555000000E+04, 4.7780698461E+01, 5.2727835947E+00, 3.0043724550E+01, 4.1005971458E+00, 9.8367838629E-01],
	[4.8560000000E+04, 4.7789484226E+01, 5.2728324671E+00, 3.0053849937E+01, 4.1008799820E+00, 9.8368484116E-01],
	[4.8565000000E+04, 4.7798270703E+01, 5.2728813350E+00, 3.0063977691E+01, 4.1011627524E+00, 9.8369129308E-01],
	[4.8570000000E+04, 4.7807057889E+01, 5.2729301983E+00, 3.0074107814E+01, 4.1014454569E+00, 9.8369774204E-01],
	[4.8575000000E+04, 4.7815845787E+01, 5.2729790570E+00, 3.0084240306E+01, 4.1017280957E+00, 9.8370418805E-01],
	[4.8580000000E+04, 4.7824634395E+01, 5.2730279112E+00, 3.0094375167E+01, 4.1020106687E+00, 9.8371063111E-01],
	[4.8585000000E+04, 4.7833423714E+01, 5.2730767608E+00, 3.0104512398E+01, 4.1022931759E+00, 9.8371707123E-01],
	[4.8590000000E+04, 4.7842213743E+01, 5.2731256057E+00, 3.0114651998E+01, 4.1025756173E+00, 9.8372350840E-01],
	[4.8595000000E+04, 4.7851004483E+01, 5.2731744462E+00, 3.0124793968E+01, 4.1028579931E+00, 9.8372994262E-01],
	[4.8600000000E+04, 4.7859795934E+01, 5.2732232820E+00, 3.0134938308E+01, 4.1031403031E+00, 9.8373637391E-01],
	[4.8605000000E+04, 4.7868588095E+01, 5.2732721133E+00, 3.0145085020E+01, 4.1034225474E+00, 9.8374280225E-01],
	[4.8610000000E+04, 4.7877380966E+01, 5.2733209400E+00, 3.0155234102E+01, 4.1037047261E+00, 9.8374922765E-01],
	[4.8615000000E+04, 4.7886174548E+01, 5.2733697621E+00, 3.0165385555E+01, 4.1039868391E+00, 9.8375565011E-01],
	[4.8620000000E+04, 4.7894968841E+01, 5.2734185797E+00, 3.0175539380E+01, 4.1042688864E+00, 9.8376206964E-01],
	[4.8625000000E+04, 4.7903763844E+01, 5.2734673927E+00, 3.0185695576E+01, 4.1045508681E+00, 9.8376848623E-01],
	[4.8630000000E+04, 4.7912559557E+01, 5.2735162011E+00, 3.0195854145E+01, 4.1048327842E+00, 9.8377489989E-01],
	[4.8635000000E+04, 4.7921355981E+01, 5.2735650050E+00, 3.0206015087E+01, 4.1051146348E+00, 9.8378131061E-01],
	[4.8640000000E+04, 4.7930153115E+01, 5.2736138043E+00, 3.0216178401E+01, 4.1053964197E+00, 9.8378771841E-01],
	[4.8645000000E+04, 4.7938950960E+01, 5.2736625990E+00, 3.0226344088E+01, 4.1056781391E+00, 9.8379412327E-01],
	[4.8650000000E+04, 4.7947749515E+01, 5.2737113892E+00, 3.0236512149E+01, 4.1059597930E+00, 9.8380052520E-01],
	[4.8655000000E+04, 4.7956548781E+01, 5.2737601748E+00, 3.0246682584E+01, 4.1062413814E+00, 9.8380692421E-01],
	[4.8660000000E+04, 4.7965348757E+01, 5.2738089558E+00, 3.0256855392E+01, 4.1065229042E+00, 9.8381332030E-01],
	[4.8665000000E+04, 4.7974149443E+01, 5.2738577323E+00, 3.0267030575E+01, 4.1068043616E+00, 9.8381971346E-01],
	[4.8670000000E+04, 4.7982950840E+01, 5.2739065043E+00, 3.0277208133E+01, 4.1070857535E+00, 9.8382610370E-01],
	[4.8675000000E+04, 4.7991752947E+01, 5.2739552716E+00, 3.0287388065E+01, 4.1073670799E+00, 9.8383249102E-01],
	[4.8680000000E+04, 4.8000555764E+01, 5.2740040344E+00, 3.0297570373E+01, 4.1076483409E+00, 9.8383887542E-01],
	[4.8685000000E+04, 4.8009359291E+01, 5.2740527927E+00, 3.0307755057E+01, 4.1079295366E+00, 9.8384525690E-01],
	[4.8690000000E+04, 4.8018163529E+01, 5.2741015464E+00, 3.0317942116E+01, 4.1082106668E+00, 9.8385163546E-01],
	[4.8695000000E+04, 4.8026968477E+01, 5.2741502955E+00, 3.0328131551E+01, 4.1084917316E+00, 9.8385801111E-01],
	[4.8700000000E+04, 4.8035774135E+01, 5.2741990401E+00, 3.0338323364E+01, 4.1087727311E+00, 9.8386438385E-01],
	[4.8705000000E+04, 4.8044580504E+01, 5.2742477801E+00, 3.0348517552E+01, 4.1090536652E+00, 9.8387075368E-01],
	[4.8710000000E+04, 4.8053387583E+01, 5.2742965156E+00, 3.0358714118E+01, 4.1093345340E+00, 9.8387712059E-01],
	[4.8715000000E+04, 4.8062195372E+01, 5.2743452465E+00, 3.0368913062E+01, 4.1096153376E+00, 9.8388348460E-01],
	[4.8720000000E+04, 4.8071003871E+01, 5.2743939729E+00, 3.0379114383E+01, 4.1098960758E+00, 9.8388984570E-01],
	[4.8725000000E+04, 4.8079813080E+01, 5.2744426947E+00, 3.0389318083E+01, 4.1101767487E+00, 9.8389620389E-01],
	[4.8730000000E+04, 4.8088623000E+01, 5.2744914120E+00, 3.0399524160E+01, 4.1104573564E+00, 9.8390255918E-01],
	[4.8735000000E+04, 4.8097433629E+01, 5.2745401247E+00, 3.0409732617E+01, 4.1107378989E+00, 9.8390891157E-01],
	[4.8740000000E+04, 4.8106244969E+01, 5.2745888329E+00, 3.0419943452E+01, 4.1110183761E+00, 9.8391526106E-01],
	[4.8745000000E+04, 4.8115057019E+01, 5.2746375365E+00, 3.0430156667E+01, 4.1112987881E+00, 9.8392160764E-01],
	[4.8750000000E+04, 4.8123869778E+01, 5.2746862356E+00, 3.0440372261E+01, 4.1115791350E+00, 9.8392795133E-01],
	[4.8755000000E+04, 4.8132683248E+01, 5.2747349301E+00, 3.0450590235E+01, 4.1118594167E+00, 9.8393429212E-01],
	[4.8760000000E+04, 4.8141497428E+01, 5.2747836201E+00, 3.0460810590E+01, 4.1121396332E+00, 9.8394063002E-01],
	[4.8765000000E+04, 4.8150312318E+01, 5.2748323056E+00, 3.0471033325E+01, 4.1124197846E+00, 9.8394696502E-01],
	[4.8770000000E+04, 4.8159127918E+01, 5.2748809865E+00, 3.0481258441E+01, 4.1126998709E+00, 9.8395329713E-01],
	[4.8775000000E+04, 4.8167944229E+01, 5.2749296629E+00, 3.0491485938E+01, 4.1129798921E+00, 9.8395962634E-01],
	[4.8780000000E+04, 4.8176761249E+01, 5.2749783347E+00, 3.0501715817E+01, 4.1132598482E+00, 9.8396595267E-01],
	[4.8785000000E+04, 4.8185578979E+01, 5.2750270020E+00, 3.0511948077E+01, 4.1135397393E+00, 9.8397227611E-01],
	[4.8790000000E+04, 4.8194397419E+01, 5.2750756647E+00, 3.0522182719E+01, 4.1138195653E+00, 9.8397859667E-01],
	[4.8795000000E+04, 4.8203216569E+01, 5.2751243229E+00, 3.0532419744E+01, 4.1140993263E+00, 9.8398491434E-01],
	[4.8800000000E+04, 4.8212036429E+01, 5.2751729766E+00, 3.0542659152E+01, 4.1143790223E+00, 9.8399122912E-01],
	[4.8805000000E+04, 4.8220856998E+01, 5.2752216257E+00, 3.0552900942E+01, 4.1146586533E+00, 9.8399754102E-01],
	[4.8810000000E+04, 4.8229678278E+01, 5.2752702703E+00, 3.0563145116E+01, 4.1149382193E+00, 9.8400385005E-01],
	[4.8815000000E+04, 4.8238500268E+01, 5.2753189104E+00, 3.0573391674E+01, 4.1152177204E+00, 9.8401015619E-01],
	[4.8820000000E+04, 4.8247322967E+01, 5.2753675459E+00, 3.0583640616E+01, 4.1154971565E+00, 9.8401645946E-01],
	[4.8825000000E+04, 4.8256146376E+01, 5.2754161769E+00, 3.0593891941E+01, 4.1157765277E+00, 9.8402275984E-01],
	[4.8830000000E+04, 4.8264970496E+01, 5.2754648034E+00, 3.0604145652E+01, 4.1160558340E+00, 9.8402905736E-01],
	[4.8835000000E+04, 4.8273795324E+01, 5.2755134254E+00, 3.0614401747E+01, 4.1163350754E+00, 9.8403535200E-01],
	[4.8840000000E+04, 4.8282620863E+01, 5.2755620428E+00, 3.0624660228E+01, 4.1166142520E+00, 9.8404164377E-01],
	[4.8845000000E+04, 4.8291447112E+01, 5.2756106556E+00, 3.0634921094E+01, 4.1168933637E+00, 9.8404793267E-01],
	[4.8850000000E+04, 4.8300274070E+01, 5.2756592640E+00, 3.0645184346E+01, 4.1171724105E+00, 9.8405421870E-01],
	[4.8855000000E+04, 4.8309101738E+01, 5.2757078678E+00, 3.0655449984E+01, 4.1174513926E+00, 9.8406050186E-01],
	[4.8860000000E+04, 4.8317930116E+01, 5.2757564671E+00, 3.0665718008E+01, 4.1177303098E+00, 9.8406678216E-01],
	[4.8865000000E+04, 4.8326759204E+01, 5.2758050619E+00, 3.0675988419E+01, 4.1180091623E+00, 9.8407305959E-01],
	[4.8870000000E+04, 4.8335589001E+01, 5.2758536521E+00, 3.0686261217E+01, 4.1182879500E+00, 9.8407933416E-01],
	[4.8875000000E+04, 4.8344419508E+01, 5.2759022379E+00, 3.0696536403E+01, 4.1185666730E+00, 9.8408560587E-01],
	[4.8880000000E+04, 4.8353250725E+01, 5.2759508191E+00, 3.0706813976E+01, 4.1188453312E+00, 9.8409187472E-01],
	[4.8885000000E+04, 4.8362082651E+01, 5.2759993958E+00, 3.0717093937E+01, 4.1191239247E+00, 9.8409814070E-01],
	[4.8890000000E+04, 4.8370915287E+01, 5.2760479679E+00, 3.0727376287E+01, 4.1194024536E+00, 9.8410440384E-01],
	[4.8895000000E+04, 4.8379748633E+01, 5.2760965356E+00, 3.0737661025E+01, 4.1196809177E+00, 9.8411066411E-01],
	[4.8900000000E+04, 4.8388582688E+01, 5.2761450987E+00, 3.0747948152E+01, 4.1199593172E+00, 9.8411692153E-01],
	[4.8905000000E+04, 4.8397417453E+01, 5.2761936573E+00, 3.0758237669E+01, 4.1202376521E+00, 9.8412317610E-01],
	[4.8910000000E+04, 4.8406252927E+01, 5.2762422114E+00, 3.0768529574E+01, 4.1205159223E+00, 9.8412942782E-01],
	[4.8915000000E+04, 4.8415089111E+01, 5.2762907609E+00, 3.0778823870E+01, 4.1207941279E+00, 9.8413567669E-01],
	[4.8920000000E+04, 4.8423926005E+01, 5.2763393060E+00, 3.0789120556E+01, 4.1210722690E+00, 9.8414192271E-01],
	[4.8925000000E+04, 4.8432763608E+01, 5.2763878465E+00, 3.0799419632E+01, 4.1213503454E+00, 9.8414816588E-01],
	[4.8930000000E+04, 4.8441601920E+01, 5.2764363825E+00, 3.0809721099E+01, 4.1216283574E+00, 9.8415440621E-01],
	[4.8935000000E+04, 4.8450440942E+01, 5.2764849141E+00, 3.0820024958E+01, 4.1219063047E+00, 9.8416064369E-01],
	[4.8940000000E+04, 4.8459280674E+01, 5.2765334411E+00, 3.0830331207E+01, 4.1221841876E+00, 9.8416687833E-01],
	[4.8945000000E+04, 4.8468121115E+01, 5.2765819635E+00, 3.0840639849E+01, 4.1224620060E+00, 9.8417311013E-01],
	[4.8950000000E+04, 4.8476962266E+01, 5.2766304815E+00, 3.0850950882E+01, 4.1227397599E+00, 9.8417933909E-01],
	[4.8955000000E+04, 4.8485804126E+01, 5.2766789950E+00, 3.0861264308E+01, 4.1230174493E+00, 9.8418556521E-01],
	[4.8960000000E+04, 4.8494646695E+01, 5.2767275039E+00, 3.0871580126E+01, 4.1232950742E+00, 9.8419178849E-01],
	[4.8965000000E+04, 4.8503489974E+01, 5.2767760084E+00, 3.0881898337E+01, 4.1235726348E+00, 9.8419800894E-01],
	[4.8970000000E+04, 4.8512333962E+01, 5.2768245083E+00, 3.0892218942E+01, 4.1238501309E+00, 9.8420422656E-01],
	[4.8975000000E+04, 4.8521178660E+01, 5.2768730038E+00, 3.0902541940E+01, 4.1241275626E+00, 9.8421044134E-01],
	[4.8980000000E+04, 4.8530024067E+01, 5.2769214947E+00, 3.0912867332E+01, 4.1244049299E+00, 9.8421665329E-01],
	[4.8985000000E+04, 4.8538870183E+01, 5.2769699811E+00, 3.0923195118E+01, 4.1246822329E+00, 9.8422286242E-01],
	[4.8990000000E+04, 4.8547717009E+01, 5.2770184631E+00, 3.0933525299E+01, 4.1249594716E+00, 9.8422906871E-01],
	[4.8995000000E+04, 4.8556564544E+01, 5.2770669405E+00, 3.0943857874E+01, 4.1252366459E+00, 9.8423527218E-01],
	[4.9000000000E+04, 4.8565412788E+01, 5.2771154134E+00, 3.0954192845E+01, 4.1255137559E+00, 9.8424147282E-01],
	[4.9005000000E+04, 4.8574261742E+01, 5.2771638818E+00, 3.0964530211E+01, 4.1257908016E+00, 9.8424767064E-01],
	[4.9010000000E+04, 4.8583111405E+01, 5.2772123457E+00, 3.0974869973E+01, 4.1260677830E+00, 9.8425386564E-01],
	[4.9015000000E+04, 4.8591961777E+01, 5.2772608052E+00, 3.0985212131E+01, 4.1263447002E+00, 9.8426005782E-01],
	[4.9020000000E+04, 4.8600812859E+01, 5.2773092601E+00, 3.0995556685E+01, 4.1266215532E+00, 9.8426624717E-01],
	[4.9025000000E+04, 4.8609664649E+01, 5.2773577105E+00, 3.1005903636E+01, 4.1268983419E+00, 9.8427243371E-01],
	[4.9030000000E+04, 4.8618517149E+01, 5.2774061564E+00, 3.1016252984E+01, 4.1271750664E+00, 9.8427861744E-01],
	[4.9035000000E+04, 4.8627370358E+01, 5.2774545979E+00, 3.1026604729E+01, 4.1274517267E+00, 9.8428479834E-01],
	[4.9040000000E+04, 4.8636224277E+01, 5.2775030348E+00, 3.1036958872E+01, 4.1277283229E+00, 9.8429097644E-01],
	[4.9045000000E+04, 4.8645078904E+01, 5.2775514673E+00, 3.1047315412E+01, 4.1280048549E+00, 9.8429715172E-01],
	[4.9050000000E+04, 4.8653934241E+01, 5.2775998952E+00, 3.1057674351E+01, 4.1282813227E+00, 9.8430332419E-01],
	[4.9055000000E+04, 4.8662790286E+01, 5.2776483187E+00, 3.1068035689E+01, 4.1285577265E+00, 9.8430949385E-01],
	[4.9060000000E+04, 4.8671647041E+01, 5.2776967376E+00, 3.1078399425E+01, 4.1288340661E+00, 9.8431566071E-01],
	[4.9065000000E+04, 4.8680504505E+01, 5.2777451521E+00, 3.1088765560E+01, 4.1291103417E+00, 9.8432182476E-01],
	[4.9070000000E+04, 4.8689370388E+01, 5.2777943490E+00, 3.1099134095E+01, 4.1293870904E+00, 9.8432798600E-01],
	[4.9075000000E+04, 4.8698245473E+01, 5.2778444076E+00, 3.1109505030E+01, 4.1296643665E+00, 9.8433414444E-01],
	[4.9080000000E+04, 4.8707121270E+01, 5.2778944617E+00, 3.1119878365E+01, 4.1299415787E+00, 9.8434030008E-01],
	[4.9085000000E+04, 4.8715997781E+01, 5.2779445110E+00, 3.1130254100E+01, 4.1302187270E+00, 9.8434645292E-01],
	[4.9090000000E+04, 4.8724875005E+01, 5.2779945558E+00, 3.1140632236E+01, 4.1304958114E+00, 9.8435260296E-01],
	[4.9095000000E+04, 4.8733752943E+01, 5.2780445960E+00, 3.1151012773E+01, 4.1307728320E+00, 9.8435875020E-01],
	[4.9100000000E+04, 4.8742631594E+01, 5.2780946315E+00, 3.1161395711E+01, 4.1310497888E+00, 9.8436489464E-01],
	[4.9105000000E+04, 4.8751510957E+01, 5.2781446624E+00, 3.1171781051E+01, 4.1313266817E+00, 9.8437103630E-01],
	[4.9110000000E+04, 4.8760391035E+01, 5.2781946887E+00, 3.1182168793E+01, 4.1316035109E+00, 9.8437717515E-01],
	[4.9115000000E+04, 4.8769271825E+01, 5.2782447103E+00, 3.1192558937E+01, 4.1318802762E+00, 9.8438331122E-01],
	[4.9120000000E+04, 4.8778153328E+01, 5.2782947274E+00, 3.1202951484E+01, 4.1321569778E+00, 9.8438944449E-01],
	[4.9125000000E+04, 4.8787035545E+01, 5.2783447398E+00, 3.1213346433E+01, 4.1324336157E+00, 9.8439557498E-01],
	[4.9130000000E+04, 4.8795918475E+01, 5.2783947476E+00, 3.1223743786E+01, 4.1327101898E+00, 9.8440170268E-01],
	[4.9135000000E+04, 4.8804802118E+01, 5.2784447508E+00, 3.1234143542E+01, 4.1329867001E+00, 9.8440782759E-01],
	[4.9140000000E+04, 4.8813686474E+01, 5.2784947494E+00, 3.1244545702E+01, 4.1332631468E+00, 9.8441394972E-01],
	[4.9145000000E+04, 4.8822571543E+01, 5.2785447433E+00, 3.1254950267E+01, 4.1335395298E+00, 9.8442006906E-01],
	[4.9150000000E+04, 4.8831457326E+01, 5.2785947327E+00, 3.1265357235E+01, 4.1338158492E+00, 9.8442618562E-01],
	[4.9155000000E+04, 4.8840343821E+01, 5.2786447174E+00, 3.1275766609E+01, 4.1340921049E+00, 9.8443229941E-01],
	[4.9160000000E+04, 4.8849231030E+01, 5.2786946976E+00, 3.1286178387E+01, 4.1343682970E+00, 9.8443841041E-01],
	[4.9165000000E+04, 4.8858118951E+01, 5.2787446731E+00, 3.1296592571E+01, 4.1346444254E+00, 9.8444451864E-01],
	[4.9170000000E+04, 4.8867007586E+01, 5.2787946440E+00, 3.1307009160E+01, 4.1349204903E+00, 9.8445062409E-01],
	[4.9175000000E+04, 4.8875896933E+01, 5.2788446103E+00, 3.1317428156E+01, 4.1351964916E+00, 9.8445672676E-01],
	[4.9180000000E+04, 4.8884786994E+01, 5.2788945720E+00, 3.1327849558E+01, 4.1354724293E+00, 9.8446282666E-01],
	[4.9185000000E+04, 4.8893677767E+01, 5.2789445291E+00, 3.1338273366E+01, 4.1357483035E+00, 9.8446892380E-01],
	[4.9190000000E+04, 4.8902569254E+01, 5.2789944816E+00, 3.1348699581E+01, 4.1360241141E+00, 9.8447501816E-01],
	[4.9195000000E+04, 4.8911461453E+01, 5.2790444295E+00, 3.1359128204E+01, 4.1362998612E+00, 9.8448110975E-01],
	[4.9200000000E+04, 4.8920354366E+01, 5.2790943727E+00, 3.1369559234E+01, 4.1365755449E+00, 9.8448719857E-01],
	[4.9205000000E+04, 4.8929247991E+01, 5.2791443114E+00, 3.1379992672E+01, 4.1368511651E+00, 9.8449328463E-01],
	[4.9210000000E+04, 4.8938142329E+01, 5.2791942455E+00, 3.1390428518E+01, 4.1371267218E+00, 9.8449936792E-01],
	[4.9215000000E+04, 4.8947037381E+01, 5.2792441749E+00, 3.1400866772E+01, 4.1374022151E+00, 9.8450544845E-01],
	[4.9220000000E+04, 4.8955933145E+01, 5.2792940998E+00, 3.1411307436E+01, 4.1376776449E+00, 9.8451152622E-01],
	[4.9225000000E+04, 4.8964829622E+01, 5.2793440201E+00, 3.1421750508E+01, 4.1379530114E+00, 9.8451760123E-01],
	[4.9230000000E+04, 4.8973726811E+01, 5.2793939358E+00, 3.1432195990E+01, 4.1382283144E+00, 9.8452367348E-01],
	[4.9235000000E+04, 4.8982624714E+01, 5.2794438468E+00, 3.1442643882E+01, 4.1385035541E+00, 9.8452974297E-01],
	[4.9240000000E+04, 4.8991523329E+01, 5.2794937533E+00, 3.1453094183E+01, 4.1387787305E+00, 9.8453580971E-01],
	[4.9245000000E+04, 4.9000422658E+01, 5.2795436552E+00, 3.1463546895E+01, 4.1390538435E+00, 9.8454187369E-01],
	[4.9250000000E+04, 4.9009322699E+01, 5.2795935525E+00, 3.1474002018E+01, 4.1393288931E+00, 9.8454793492E-01],
	[4.9255000000E+04, 4.9018223452E+01, 5.2796434452E+00, 3.1484459551E+01, 4.1396038795E+00, 9.8455399339E-01],
	[4.9260000000E+04, 4.9027124919E+01, 5.2796933333E+00, 3.1494919496E+01, 4.1398788026E+00, 9.8456004912E-01],
	[4.9265000000E+04, 4.9036027098E+01, 5.2797432168E+00, 3.1505381852E+01, 4.1401536624E+00, 9.8456610210E-01],
	[4.9270000000E+04, 4.9044929990E+01, 5.2797930957E+00, 3.1515846621E+01, 4.1404284590E+00, 9.8457215233E-01],
	[4.9275000000E+04, 4.9053833595E+01, 5.2798429700E+00, 3.1526313801E+01, 4.1407031923E+00, 9.8457819981E-01],
	[4.9280000000E+04, 4.9062737912E+01, 5.2798928398E+00, 3.1536783394E+01, 4.1409778624E+00, 9.8458424455E-01],
	[4.9285000000E+04, 4.9071642942E+01, 5.2799427049E+00, 3.1547255400E+01, 4.1412524693E+00, 9.8459028655E-01],
	[4.9290000000E+04, 4.9080548685E+01, 5.2799925655E+00, 3.1557729819E+01, 4.1415270131E+00, 9.8459632580E-01],
	[4.9295000000E+04, 4.9089455141E+01, 5.2800424214E+00, 3.1568206651E+01, 4.1418014936E+00, 9.8460236231E-01],
	[4.9300000000E+04, 4.9098362309E+01, 5.2800922728E+00, 3.1578685897E+01, 4.1420759110E+00, 9.8460839609E-01],
	[4.9305000000E+04, 4.9107270189E+01, 5.2801421196E+00, 3.1589167557E+01, 4.1423502653E+00, 9.8461442713E-01],
	[4.9310000000E+04, 4.9116178783E+01, 5.2801919619E+00, 3.1599651632E+01, 4.1426245565E+00, 9.8462045543E-01],
	[4.9315000000E+04, 4.9125088089E+01, 5.2802417995E+00, 3.1610138121E+01, 4.1428987846E+00, 9.8462648100E-01],
	[4.9320000000E+04, 4.9133998107E+01, 5.2802916325E+00, 3.1620627026E+01, 4.1431729496E+00, 9.8463250383E-01],
	[4.9325000000E+04, 4.9142908838E+01, 5.2803414610E+00, 3.1631118345E+01, 4.1434470515E+00, 9.8463852393E-01],
	[4.9330000000E+04, 4.9151820282E+01, 5.2803912849E+00, 3.1641612080E+01, 4.1437210904E+00, 9.8464454130E-01],
	[4.9335000000E+04, 4.9160732438E+01, 5.2804411042E+00, 3.1652108231E+01, 4.1439950662E+00, 9.8465055594E-01],
	[4.9340000000E+04, 4.9169645306E+01, 5.2804909190E+00, 3.1662606799E+01, 4.1442689790E+00, 9.8465656786E-01],
	[4.9345000000E+04, 4.9178558887E+01, 5.2805407291E+00, 3.1673107783E+01, 4.1445428289E+00, 9.8466257705E-01],
	[4.9350000000E+04, 4.9187473181E+01, 5.2805905347E+00, 3.1683611183E+01, 4.1448166157E+00, 9.8466858351E-01],
	[4.9355000000E+04, 4.9196388187E+01, 5.2806403357E+00, 3.1694117001E+01, 4.1450903396E+00, 9.8467458725E-01],
	[4.9360000000E+04, 4.9205303906E+01, 5.2806901321E+00, 3.1704625237E+01, 4.1453640006E+00, 9.8468058827E-01],
	[4.9365000000E+04, 4.9214220336E+01, 5.2807399240E+00, 3.1715135890E+01, 4.1456375986E+00, 9.8468658657E-01],
	[4.9370000000E+04, 4.9223137480E+01, 5.2807897112E+00, 3.1725648961E+01, 4.1459111338E+00, 9.8469258215E-01],
	[4.9375000000E+04, 4.9232055336E+01, 5.2808394939E+00, 3.1736164451E+01, 4.1461846060E+00, 9.8469857501E-01],
	[4.9380000000E+04, 4.9240973904E+01, 5.2808892721E+00, 3.1746682359E+01, 4.1464580153E+00, 9.8470456516E-01],
	[4.9385000000E+04, 4.9249893184E+01, 5.2809390456E+00, 3.1757202687E+01, 4.1467313618E+00, 9.8471055259E-01],
	[4.9390000000E+04, 4.9258813177E+01, 5.2809888146E+00, 3.1767725434E+01, 4.1470046455E+00, 9.8471653730E-01],
	[4.9395000000E+04, 4.9267733883E+01, 5.2810385791E+00, 3.1778250600E+01, 4.1472778663E+00, 9.8472251931E-01],
	[4.9400000000E+04, 4.9276655300E+01, 5.2810883389E+00, 3.1788778187E+01, 4.1475510243E+00, 9.8472849860E-01],
	[4.9405000000E+04, 4.9285577430E+01, 5.2811380942E+00, 3.1799308194E+01, 4.1478241196E+00, 9.8473447519E-01],
	[4.9410000000E+04, 4.9294500272E+01, 5.2811878449E+00, 3.1809840621E+01, 4.1480971520E+00, 9.8474044906E-01],
	[4.9415000000E+04, 4.9303423827E+01, 5.2812375911E+00, 3.1820375469E+01, 4.1483701217E+00, 9.8474642024E-01],
	[4.9420000000E+04, 4.9312348093E+01, 5.2812873327E+00, 3.1830912739E+01, 4.1486430287E+00, 9.8475238870E-01],
	[4.9425000000E+04, 4.9321273072E+01, 5.2813370697E+00, 3.1841452430E+01, 4.1489158729E+00, 9.8475835446E-01],
	[4.9430000000E+04, 4.9330198764E+01, 5.2813868022E+00, 3.1851994543E+01, 4.1491886544E+00, 9.8476431752E-01],
	[4.9435000000E+04, 4.9339125167E+01, 5.2814365301E+00, 3.1862539078E+01, 4.1494613733E+00, 9.8477027788E-01],
	[4.9440000000E+04, 4.9348052283E+01, 5.2814862534E+00, 3.1873086035E+01, 4.1497340294E+00, 9.8477623554E-01],
	[4.9445000000E+04, 4.9356980111E+01, 5.2815359722E+00, 3.1883635415E+01, 4.1500066230E+00, 9.8478219051E-01],
	[4.9450000000E+04, 4.9365908651E+01, 5.2815856864E+00, 3.1894187218E+01, 4.1502791538E+00, 9.8478814277E-01],
	[4.9455000000E+04, 4.9374837903E+01, 5.2816353961E+00, 3.1904741445E+01, 4.1505516221E+00, 9.8479409234E-01],
	[4.9460000000E+04, 4.9383767867E+01, 5.2816851012E+00, 3.1915298096E+01, 4.1508240277E+00, 9.8480003922E-01],
	[4.9465000000E+04, 4.9392698544E+01, 5.2817348017E+00, 3.1925857170E+01, 4.1510963708E+00, 9.8480598340E-01],
	[4.9470000000E+04, 4.9401629933E+01, 5.2817844977E+00, 3.1936418669E+01, 4.1513686513E+00, 9.8481192490E-01],
	[4.9475000000E+04, 4.9410562033E+01, 5.2818341891E+00, 3.1946982592E+01, 4.1516408693E+00, 9.8481786370E-01],
	[4.9480000000E+04, 4.9419494846E+01, 5.2818838760E+00, 3.1957548940E+01, 4.1519130247E+00, 9.8482379981E-01],
	[4.9485000000E+04, 4.9428428371E+01, 5.2819335584E+00, 3.1968117714E+01, 4.1521851176E+00, 9.8482973324E-01],
	[4.9490000000E+04, 4.9437362608E+01, 5.2819832361E+00, 3.1978688913E+01, 4.1524571479E+00, 9.8483566399E-01],
	[4.9495000000E+04, 4.9446297557E+01, 5.2820329094E+00, 3.1989262538E+01, 4.1527291158E+00, 9.8484159205E-01],
	[4.9500000000E+04, 4.9455233218E+01, 5.2820825780E+00, 3.1999838589E+01, 4.1530010213E+00, 9.8484751742E-01],
	[4.9505000000E+04, 4.9464169591E+01, 5.2821322422E+00, 3.2010417067E+01, 4.1532728643E+00, 9.8485344012E-01],
	[4.9510000000E+04, 4.9473106676E+01, 5.2821819017E+00, 3.2020997972E+01, 4.1535446448E+00, 9.8485936014E-01],
	[4.9515000000E+04, 4.9482044473E+01, 5.2822315568E+00, 3.2031581303E+01, 4.1538163630E+00, 9.8486527747E-01],
	[4.9520000000E+04, 4.9490982982E+01, 5.2822812072E+00, 3.2042167062E+01, 4.1540880187E+00, 9.8487119214E-01],
	[4.9525000000E+04, 4.9499922203E+01, 5.2823308532E+00, 3.2052755249E+01, 4.1543596120E+00, 9.8487710412E-01],
	[4.9530000000E+04, 4.9508862136E+01, 5.2823804946E+00, 3.2063345864E+01, 4.1546311430E+00, 9.8488301343E-01],
	[4.9535000000E+04, 4.9517802781E+01, 5.2824301314E+00, 3.2073938907E+01, 4.1549026117E+00, 9.8488892007E-01],
	[4.9540000000E+04, 4.9526744137E+01, 5.2824797637E+00, 3.2084534379E+01, 4.1551740180E+00, 9.8489482404E-01],
	[4.9545000000E+04, 4.9535686206E+01, 5.2825293915E+00, 3.2095132280E+01, 4.1554453620E+00, 9.8490072533E-01],
	[4.9550000000E+04, 4.9544628986E+01, 5.2825790147E+00, 3.2105732611E+01, 4.1557166437E+00, 9.8490662396E-01],
	[4.9555000000E+04, 4.9553572479E+01, 5.2826286334E+00, 3.2116335370E+01, 4.1559878631E+00, 9.8491251992E-01],
	[4.9560000000E+04, 4.9562516683E+01, 5.2826782475E+00, 3.2126940560E+01, 4.1562590202E+00, 9.8491841322E-01],
	[4.9565000000E+04, 4.9571461599E+01, 5.2827278571E+00, 3.2137548180E+01, 4.1565301151E+00, 9.8492430385E-01],
	[4.9570000000E+04, 4.9580407227E+01, 5.2827774621E+00, 3.2148158231E+01, 4.1568011478E+00, 9.8493019182E-01],
	[4.9575000000E+04, 4.9589353566E+01, 5.2828270627E+00, 3.2158770712E+01, 4.1570721182E+00, 9.8493607713E-01],
	[4.9580000000E+04, 4.9598300618E+01, 5.2828766586E+00, 3.2169385625E+01, 4.1573430265E+00, 9.8494195977E-01],
	[4.9585000000E+04, 4.9607248381E+01, 5.2829262501E+00, 3.2180002969E+01, 4.1576138726E+00, 9.8494783976E-01],
	[4.9590000000E+04, 4.9616196856E+01, 5.2829758370E+00, 3.2190622745E+01, 4.1578846565E+00, 9.8495371709E-01],
	[4.9595000000E+04, 4.9625146042E+01, 5.2830254194E+00, 3.2201244953E+01, 4.1581553783E+00, 9.8495959176E-01],
	[4.9600000000E+04, 4.9634095941E+01, 5.2830749972E+00, 3.2211869593E+01, 4.1584260379E+00, 9.8496546378E-01],
	[4.9605000000E+04, 4.9643046551E+01, 5.2831245705E+00, 3.2222496666E+01, 4.1586966354E+00, 9.8497133315E-01],
	[4.9610000000E+04, 4.9651997873E+01, 5.2831741393E+00, 3.2233126172E+01, 4.1589671709E+00, 9.8497719986E-01],
	[4.9615000000E+04, 4.9660949906E+01, 5.2832237036E+00, 3.2243758112E+01, 4.1592376442E+00, 9.8498306393E-01],
	[4.9620000000E+04, 4.9669902651E+01, 5.2832732633E+00, 3.2254392485E+01, 4.1595080555E+00, 9.8498892534E-01],
	[4.9625000000E+04, 4.9678856108E+01, 5.2833228185E+00, 3.2265029292E+01, 4.1597784048E+00, 9.8499478411E-01],
	[4.9630000000E+04, 4.9687810276E+01, 5.2833723691E+00, 3.2275668534E+01, 4.1600486920E+00, 9.8500064023E-01],
	[4.9635000000E+04, 4.9696765156E+01, 5.2834219153E+00, 3.2286310210E+01, 4.1603189172E+00, 9.8500649370E-01],
	[4.9640000000E+04, 4.9705720748E+01, 5.2834714569E+00, 3.2296954321E+01, 4.1605890804E+00, 9.8501234453E-01],
	[4.9645000000E+04, 4.9714677051E+01, 5.2835209940E+00, 3.2307600867E+01, 4.1608591816E+00, 9.8501819272E-01],
	[4.9650000000E+04, 4.9723634066E+01, 5.2835705265E+00, 3.2318249848E+01, 4.1611292209E+00, 9.8502403827E-01],
	[4.9655000000E+04, 4.9732591792E+01, 5.2836200546E+00, 3.2328901266E+01, 4.1613991983E+00, 9.8502988118E-01],
	[4.9660000000E+04, 4.9741550230E+01, 5.2836695781E+00, 3.2339555120E+01, 4.1616691137E+00, 9.8503572145E-01],
	[4.9665000000E+04, 4.9750509380E+01, 5.2837190971E+00, 3.2350211410E+01, 4.1619389672E+00, 9.8504155909E-01],
	[4.9670000000E+04, 4.9759469241E+01, 5.2837686115E+00, 3.2360870137E+01, 4.1622087588E+00, 9.8504739409E-01],
	[4.9675000000E+04, 4.9768429813E+01, 5.2838181215E+00, 3.2371531301E+01, 4.1624784885E+00, 9.8505322645E-01],
	[4.9680000000E+04, 4.9777391097E+01, 5.2838676269E+00, 3.2382194902E+01, 4.1627481564E+00, 9.8505905618E-01],
	[4.9685000000E+04, 4.9786353092E+01, 5.2839171278E+00, 3.2392860941E+01, 4.1630177624E+00, 9.8506488328E-01],
	[4.9690000000E+04, 4.9795315799E+01, 5.2839666242E+00, 3.2403529418E+01, 4.1632873066E+00, 9.8507070776E-01],
	[4.9695000000E+04, 4.9804279217E+01, 5.2840161161E+00, 3.2414200334E+01, 4.1635567890E+00, 9.8507652960E-01],
	[4.9700000000E+04, 4.9813243347E+01, 5.2840656035E+00, 3.2424873688E+01, 4.1638262096E+00, 9.8508234882E-01],
	[4.9705000000E+04, 4.9822208188E+01, 5.2841150863E+00, 3.2435549481E+01, 4.1640955684E+00, 9.8508816541E-01],
	[4.9710000000E+04, 4.9831173741E+01, 5.2841645647E+00, 3.2446227713E+01, 4.1643648655E+00, 9.8509397937E-01],
	[4.9715000000E+04, 4.9840140004E+01, 5.2842140385E+00, 3.2456908385E+01, 4.1646341008E+00, 9.8509979071E-01],
	[4.9720000000E+04, 4.9849106980E+01, 5.2842635078E+00, 3.2467591497E+01, 4.1649032744E+00, 9.8510559944E-01],
	[4.9725000000E+04, 4.9858074666E+01, 5.2843129726E+00, 3.2478277049E+01, 4.1651723863E+00, 9.8511140554E-01],
	[4.9730000000E+04, 4.9867043064E+01, 5.2843624329E+00, 3.2488965041E+01, 4.1654414365E+00, 9.8511720902E-01],
	[4.9735000000E+04, 4.9876012173E+01, 5.2844118887E+00, 3.2499655474E+01, 4.1657104251E+00, 9.8512300989E-01],
	[4.9740000000E+04, 4.9884981994E+01, 5.2844613399E+00, 3.2510348349E+01, 4.1659793519E+00, 9.8512880813E-01],
	[4.9745000000E+04, 4.9893952526E+01, 5.2845107867E+00, 3.2521043665E+01, 4.1662482172E+00, 9.8513460377E-01],
	[4.9750000000E+04, 4.9902923769E+01, 5.2845602289E+00, 3.2531741422E+01, 4.1665170208E+00, 9.8514039679E-01],
	[4.9755000000E+04, 4.9911895723E+01, 5.2846096667E+00, 3.2542441622E+01, 4.1667857628E+00, 9.8514618720E-01],
	[4.9760000000E+04, 4.9920868388E+01, 5.2846590999E+00, 3.2553144264E+01, 4.1670544432E+00, 9.8515197500E-01],
	[4.9765000000E+04, 4.9929841765E+01, 5.2847085287E+00, 3.2563849349E+01, 4.1673230620E+00, 9.8515776019E-01],
	[4.9770000000E+04, 4.9938815853E+01, 5.2847579529E+00, 3.2574556877E+01, 4.1675916193E+00, 9.8516354277E-01],
	[4.9775000000E+04, 4.9947790652E+01, 5.2848073726E+00, 3.2585266848E+01, 4.1678601150E+00, 9.8516932274E-01],
	[4.9780000000E+04, 4.9956766163E+01, 5.2848567879E+00, 3.2595979262E+01, 4.1681285493E+00, 9.8517510011E-01],
	[4.9785000000E+04, 4.9965742384E+01, 5.2849061986E+00, 3.2606694121E+01, 4.1683969220E+00, 9.8518087488E-01],
	[4.9790000000E+04, 4.9974719317E+01, 5.2849556048E+00, 3.2617411424E+01, 4.1686652332E+00, 9.8518664704E-01],
	[4.9795000000E+04, 4.9983696961E+01, 5.2850050065E+00, 3.2628131172E+01, 4.1689334830E+00, 9.8519241661E-01],
	[4.9800000000E+04, 4.9992675316E+01, 5.2850544038E+00, 3.2638853364E+01, 4.1692016712E+00, 9.8519818357E-01],
	[4.9805000000E+04, 5.0001654382E+01, 5.2851037965E+00, 3.2649578001E+01, 4.1694697981E+00, 9.8520394793E-01],
	[4.9810000000E+04, 5.0010634159E+01, 5.2851531847E+00, 3.2660305084E+01, 4.1697378635E+00, 9.8520970970E-01],
	[4.9815000000E+04, 5.0019614647E+01, 5.2852025685E+00, 3.2671034613E+01, 4.1700058676E+00, 9.8521546887E-01],
	[4.9820000000E+04, 5.0028595846E+01, 5.2852519477E+00, 3.2681766588E+01, 4.1702738102E+00, 9.8522122545E-01],
	[4.9825000000E+04, 5.0037577757E+01, 5.2853013225E+00, 3.2692501010E+01, 4.1705416915E+00, 9.8522697944E-01],
	[4.9830000000E+04, 5.0046560378E+01, 5.2853506927E+00, 3.2703237878E+01, 4.1708095114E+00, 9.8523273083E-01],
	[4.9835000000E+04, 5.0055543710E+01, 5.2854000585E+00, 3.2713977193E+01, 4.1710772699E+00, 9.8523847963E-01],
	[4.9840000000E+04, 5.0064527754E+01, 5.2854494197E+00, 3.2724718955E+01, 4.1713449672E+00, 9.8524422585E-01],
	[4.9845000000E+04, 5.0073512508E+01, 5.2854987765E+00, 3.2735463166E+01, 4.1716126031E+00, 9.8524996948E-01],
	[4.9850000000E+04, 5.0082497973E+01, 5.2855481288E+00, 3.2746209824E+01, 4.1718801778E+00, 9.8525571052E-01],
	[4.9855000000E+04, 5.0091484149E+01, 5.2855974766E+00, 3.2756958930E+01, 4.1721476912E+00, 9.8526144897E-01],
	[4.9860000000E+04, 5.0100478992E+01, 5.2856476148E+00, 3.2767710485E+01, 4.1724156938E+00, 9.8526718485E-01],
	[4.9865000000E+04, 5.0109482776E+01, 5.2856985705E+00, 3.2778464489E+01, 4.1726842046E+00, 9.8527291814E-01],
	[4.9870000000E+04, 5.0118487275E+01, 5.2857495215E+00, 3.2789220943E+01, 4.1729526543E+00, 9.8527864885E-01],
	[4.9875000000E+04, 5.0127492489E+01, 5.2858004680E+00, 3.2799979846E+01, 4.1732210428E+00, 9.8528437698E-01],
	[4.9880000000E+04, 5.0136498418E+01, 5.2858514098E+00, 3.2810741198E+01, 4.1734893704E+00, 9.8529010254E-01],
	[4.9885000000E+04, 5.0145505062E+01, 5.2859023470E+00, 3.2821505001E+01, 4.1737576368E+00, 9.8529582551E-01],
	[4.9890000000E+04, 5.0154512421E+01, 5.2859532796E+00, 3.2832271254E+01, 4.1740258422E+00, 9.8530154591E-01],
	[4.9895000000E+04, 5.0163520495E+01, 5.2860042076E+00, 3.2843039959E+01, 4.1742939866E+00, 9.8530726374E-01],
	[4.9900000000E+04, 5.0172529285E+01, 5.2860551310E+00, 3.2853811114E+01, 4.1745620700E+00, 9.8531297900E-01],
	[4.9905000000E+04, 5.0181538789E+01, 5.2861060497E+00, 3.2864584720E+01, 4.1748300924E+00, 9.8531869168E-01],
	[4.9910000000E+04, 5.0190549008E+01, 5.2861569639E+00, 3.2875360779E+01, 4.1750980538E+00, 9.8532440180E-01],
	[4.9915000000E+04, 5.0199559942E+01, 5.2862078734E+00, 3.2886139289E+01, 4.1753659543E+00, 9.8533010934E-01],
	[4.9920000000E+04, 5.0208571591E+01, 5.2862587783E+00, 3.2896920252E+01, 4.1756337939E+00, 9.8533581432E-01],
	[4.9925000000E+04, 5.0217583955E+01, 5.2863096787E+00, 3.2907703667E+01, 4.1759015725E+00, 9.8534151674E-01],
	[4.9930000000E+04, 5.0226597034E+01, 5.2863605744E+00, 3.2918489536E+01, 4.1761692902E+00, 9.8534721658E-01],
	[4.9935000000E+04, 5.0235610828E+01, 5.2864114655E+00, 3.2929277858E+01, 4.1764369470E+00, 9.8535291387E-01],
	[4.9940000000E+04, 5.0244625337E+01, 5.2864623520E+00, 3.2940068633E+01, 4.1767045429E+00, 9.8535860859E-01],
	[4.9945000000E+04, 5.0253640560E+01, 5.2865132339E+00, 3.2950861862E+01, 4.1769720780E+00, 9.8536430075E-01],
	[4.9950000000E+04, 5.0262656499E+01, 5.2865641111E+00, 3.2961657546E+01, 4.1772395522E+00, 9.8536999035E-01],
	[4.9955000000E+04, 5.0271673152E+01, 5.2866149838E+00, 3.2972455684E+01, 4.1775069656E+00, 9.8537567740E-01],
	[4.9960000000E+04, 5.0280690520E+01, 5.2866658519E+00, 3.2983256276E+01, 4.1777743182E+00, 9.8538136188E-01],
	[4.9965000000E+04, 5.0289708603E+01, 5.2867167154E+00, 3.2994059324E+01, 4.1780416101E+00, 9.8538704381E-01],
	[4.9970000000E+04, 5.0298727401E+01, 5.2867675743E+00, 3.3004864828E+01, 4.1783088411E+00, 9.8539272318E-01],
	[4.9975000000E+04, 5.0307746913E+01, 5.2868184286E+00, 3.3015672787E+01, 4.1785760114E+00, 9.8539840000E-01],
	[4.9980000000E+04, 5.0316767141E+01, 5.2868692783E+00, 3.3026483202E+01, 4.1788431209E+00, 9.8540407427E-01],
	[4.9985000000E+04, 5.0325788083E+01, 5.2869201233E+00, 3.3037296074E+01, 4.1791101698E+00, 9.8540974599E-01],
	[4.9990000000E+04, 5.0334809740E+01, 5.2869709638E+00, 3.3048111403E+01, 4.1793771579E+00, 9.8541541515E-01],
	[4.9995000000E+04, 5.0343832111E+01, 5.2870217997E+00, 3.3058929188E+01, 4.1796440853E+00, 9.8542108177E-01],
	[5.0000000000E+04, 5.0352855197E+01, 5.2870726310E+00, 3.3069749431E+01, 4.1799109520E+00, 9.8542674584E-01],
	[5.0005000000E+04, 5.0361878998E+01, 5.2871234577E+00, 3.3080585308E+01, 4.1801779685E+00, 9.8543240736E-01],
	[5.0010000000E+04, 5.0370903514E+01, 5.2871742798E+00, 3.3091423650E+01, 4.1804449242E+00, 9.8543806634E-01],
	[5.0015000000E+04, 5.0379928744E+01, 5.2872250974E+00, 3.3102264458E+01, 4.1807118193E+00, 9.8544372277E-01],
	[5.0020000000E+04, 5.0388954689E+01, 5.2872759103E+00, 3.3113107732E+01, 4.1809786536E+00, 9.8544937666E-01],
	[5.0025000000E+04, 5.0397981348E+