import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

glands_others_ICRP110_MFP = np.array([
	[5.0000000000E+03, 1.9226153378E+00, 7.7059557613E+00, 2.5372890183E-02, 2.4961285959E-02, 3.4308226243E-01],
	[5.0050000000E+03, 1.9248097036E+00, 7.7021850223E+00, 2.5449413919E-02, 2.5035675279E-02, 3.4333933656E-01],
	[5.0100000000E+03, 1.9270043790E+00, 7.6984198907E+00, 2.5526091411E-02, 2.5110209301E-02, 3.4359613305E-01],
	[5.0150000000E+03, 1.9291993640E+00, 7.6946603527E+00, 2.5602922813E-02, 2.5184888151E-02, 3.4385265261E-01],
	[5.0200000000E+03, 1.9313946580E+00, 7.6909063943E+00, 2.5679908279E-02, 2.5259711953E-02, 3.4410889594E-01],
	[5.0250000000E+03, 1.9335902610E+00, 7.6871580017E+00, 2.5757047964E-02, 2.5334680829E-02, 3.4436486373E-01],
	[5.0300000000E+03, 1.9357861726E+00, 7.6834151612E+00, 2.5834342021E-02, 2.5409794904E-02, 3.4462055670E-01],
	[5.0350000000E+03, 1.9379823926E+00, 7.6796778591E+00, 2.5911790605E-02, 2.5485054302E-02, 3.4487597553E-01],
	[5.0400000000E+03, 1.9401789207E+00, 7.6759460815E+00, 2.5989393870E-02, 2.5560459146E-02, 3.4513112091E-01],
	[5.0450000000E+03, 1.9423757566E+00, 7.6722198150E+00, 2.6067151969E-02, 2.5636009561E-02, 3.4538599354E-01],
	[5.0500000000E+03, 1.9445729002E+00, 7.6684990459E+00, 2.6145065057E-02, 2.5711705668E-02, 3.4564059410E-01],
	[5.0550000000E+03, 1.9467703510E+00, 7.6647837607E+00, 2.6223133289E-02, 2.5787547593E-02, 3.4589492328E-01],
	[5.0600000000E+03, 1.9489681090E+00, 7.6610739459E+00, 2.6301356817E-02, 2.5863535457E-02, 3.4614898175E-01],
	[5.0650000000E+03, 1.9511661737E+00, 7.6573695880E+00, 2.6379735797E-02, 2.5939669386E-02, 3.4640277021E-01],
	[5.0700000000E+03, 1.9533645450E+00, 7.6536706736E+00, 2.6458270382E-02, 2.6015949501E-02, 3.4665628933E-01],
	[5.0750000000E+03, 1.9555632225E+00, 7.6499771894E+00, 2.6536960726E-02, 2.6092375925E-02, 3.4690953977E-01],
	[5.0800000000E+03, 1.9577622061E+00, 7.6462891221E+00, 2.6615806984E-02, 2.6168948783E-02, 3.4716252223E-01],
	[5.0850000000E+03, 1.9599750126E+00, 7.6426600412E+00, 2.6694809309E-02, 2.6245671253E-02, 3.4741523735E-01],
	[5.0900000000E+03, 1.9621894547E+00, 7.6390414430E+00, 2.6773967855E-02, 2.6322540727E-02, 3.4766768582E-01],
	[5.0950000000E+03, 1.9644042208E+00, 7.6354281084E+00, 2.6853282778E-02, 2.6399557033E-02, 3.4791986829E-01],
	[5.1000000000E+03, 1.9666193106E+00, 7.6318200246E+00, 2.6932754230E-02, 2.6476720296E-02, 3.4817178543E-01],
	[5.1050000000E+03, 1.9688347240E+00, 7.6282171790E+00, 2.7012382366E-02, 2.6554030636E-02, 3.4842343789E-01],
	[5.1100000000E+03, 1.9710504606E+00, 7.6246195587E+00, 2.7092167340E-02, 2.6631488177E-02, 3.4867482634E-01],
	[5.1150000000E+03, 1.9732665202E+00, 7.6210271511E+00, 2.7172109305E-02, 2.6709093042E-02, 3.4892595144E-01],
	[5.1200000000E+03, 1.9754829025E+00, 7.6174399435E+00, 2.7252208417E-02, 2.6786845354E-02, 3.4917681382E-01],
	[5.1250000000E+03, 1.9776996072E+00, 7.6138579234E+00, 2.7332464829E-02, 2.6864745234E-02, 3.4942741415E-01],
	[5.1300000000E+03, 1.9799166340E+00, 7.6102810781E+00, 2.7412878695E-02, 2.6942792806E-02, 3.4967775307E-01],
	[5.1350000000E+03, 1.9821339828E+00, 7.6067093953E+00, 2.7493450169E-02, 2.7020988191E-02, 3.4992783122E-01],
	[5.1400000000E+03, 1.9843516531E+00, 7.6031428623E+00, 2.7574179406E-02, 2.7099331513E-02, 3.5017764926E-01],
	[5.1450000000E+03, 1.9865696449E+00, 7.5995814669E+00, 2.7655066558E-02, 2.7177822893E-02, 3.5042720781E-01],
	[5.1500000000E+03, 1.9887879577E+00, 7.5960251965E+00, 2.7736111782E-02, 2.7256462453E-02, 3.5067650752E-01],
	[5.1550000000E+03, 1.9910065913E+00, 7.5924740390E+00, 2.7817315229E-02, 2.7335250316E-02, 3.5092554903E-01],
	[5.1600000000E+03, 1.9932255455E+00, 7.5889279819E+00, 2.7898677055E-02, 2.7414186603E-02, 3.5117433297E-01],
	[5.1650000000E+03, 1.9954527935E+00, 7.5854184742E+00, 2.7980197414E-02, 2.7493273364E-02, 3.5142285997E-01],
	[5.1700000000E+03, 1.9976867977E+00, 7.5819392990E+00, 2.8061876460E-02, 2.7572510369E-02, 3.5167113066E-01],
	[5.1750000000E+03, 1.9999211399E+00, 7.5784650805E+00, 2.8143714346E-02, 2.7651896196E-02, 3.5191914566E-01],
	[5.1800000000E+03, 2.0021558197E+00, 7.5749958067E+00, 2.8225711227E-02, 2.7731430966E-02, 3.5216690561E-01],
	[5.1850000000E+03, 2.0043908370E+00, 7.5715314659E+00, 2.8307867256E-02, 2.7811114802E-02, 3.5241441112E-01],
	[5.1900000000E+03, 2.0066261914E+00, 7.5680720463E+00, 2.8390182589E-02, 2.7890947824E-02, 3.5266166281E-01],
	[5.1950000000E+03, 2.0088618826E+00, 7.5646175362E+00, 2.8472657378E-02, 2.7970930155E-02, 3.5290866131E-01],
	[5.2000000000E+03, 2.0110979103E+00, 7.5611679240E+00, 2.8555291778E-02, 2.8051061916E-02, 3.5315540722E-01],
	[5.2050000000E+03, 2.0133342744E+00, 7.5577231978E+00, 2.8638085943E-02, 2.8131343229E-02, 3.5340190117E-01],
	[5.2100000000E+03, 2.0155709745E+00, 7.5542833463E+00, 2.8721040027E-02, 2.8211774215E-02, 3.5364814376E-01],
	[5.2150000000E+03, 2.0178080104E+00, 7.5508483577E+00, 2.8804154184E-02, 2.8292354995E-02, 3.5389413561E-01],
	[5.2200000000E+03, 2.0200453818E+00, 7.5474182206E+00, 2.8887428569E-02, 2.8373085690E-02, 3.5413987731E-01],
	[5.2250000000E+03, 2.0222830883E+00, 7.5439929235E+00, 2.8970863334E-02, 2.8453966423E-02, 3.5438536948E-01],
	[5.2300000000E+03, 2.0245211298E+00, 7.5405724549E+00, 2.9054458634E-02, 2.8534997313E-02, 3.5463061272E-01],
	[5.2350000000E+03, 2.0267595060E+00, 7.5371568034E+00, 2.9138214624E-02, 2.8616178481E-02, 3.5487560763E-01],
	[5.2400000000E+03, 2.0289982166E+00, 7.5337459577E+00, 2.9222131457E-02, 2.8697510050E-02, 3.5512035481E-01],
	[5.2450000000E+03, 2.0312372613E+00, 7.5303399063E+00, 2.9306209287E-02, 2.8778992139E-02, 3.5536485485E-01],
	[5.2500000000E+03, 2.0334896708E+00, 7.5269898053E+00, 2.9390448268E-02, 2.8860628247E-02, 3.5560910835E-01],
	[5.2550000000E+03, 2.0357433681E+00, 7.5236480581E+00, 2.9474848554E-02, 2.8942415390E-02, 3.5585311590E-01],
	[5.2600000000E+03, 2.0379974162E+00, 7.5203109706E+00, 2.9559410300E-02, 2.9024353449E-02, 3.5609687809E-01],
	[5.2650000000E+03, 2.0402518149E+00, 7.5169785317E+00, 2.9644133660E-02, 2.9106442543E-02, 3.5634039552E-01],
	[5.2700000000E+03, 2.0425065639E+00, 7.5136507307E+00, 2.9729018786E-02, 2.9188682793E-02, 3.5658366876E-01],
	[5.2750000000E+03, 2.0447616630E+00, 7.5103275566E+00, 2.9814065834E-02, 2.9271074320E-02, 3.5682669840E-01],
	[5.2800000000E+03, 2.0470171118E+00, 7.5070089986E+00, 2.9899274957E-02, 2.9353617244E-02, 3.5706948502E-01],
	[5.2850000000E+03, 2.0492729101E+00, 7.5036950460E+00, 2.9984646310E-02, 2.9436311686E-02, 3.5731202921E-01],
	[5.2900000000E+03, 2.0515290576E+00, 7.5003856880E+00, 3.0070180046E-02, 2.9519157766E-02, 3.5755433154E-01],
	[5.2950000000E+03, 2.0537855540E+00, 7.4970809139E+00, 3.0155876319E-02, 2.9602155605E-02, 3.5779639259E-01],
	[5.3000000000E+03, 2.0560423991E+00, 7.4937807131E+00, 3.0241735284E-02, 2.9685305321E-02, 3.5803821293E-01],
	[5.3050000000E+03, 2.0582995926E+00, 7.4904850749E+00, 3.0327757095E-02, 2.9768607036E-02, 3.5827979313E-01],
	[5.3100000000E+03, 2.0605571341E+00, 7.4871939887E+00, 3.0413941904E-02, 2.9852060869E-02, 3.5852113377E-01],
	[5.3150000000E+03, 2.0628150235E+00, 7.4839074440E+00, 3.0500289868E-02, 2.9935666941E-02, 3.5876223541E-01],
	[5.3200000000E+03, 2.0650732605E+00, 7.4806254301E+00, 3.0586801139E-02, 3.0019425371E-02, 3.5900309861E-01],
	[5.3250000000E+03, 2.0673318447E+00, 7.4773479368E+00, 3.0673475871E-02, 3.0103336278E-02, 3.5924372400E-01],
	[5.3300000000E+03, 2.0695913760E+00, 7.4740773050E+00, 3.0760314218E-02, 3.0187399950E-02, 3.5948411227E-01],
	[5.3350000000E+03, 2.0718641918E+00, 7.4708617928E+00, 3.0847316335E-02, 3.0271619933E-02, 3.5972426408E-01],
	[5.3400000000E+03, 2.0741373710E+00, 7.4676506743E+00, 3.0934482376E-02, 3.0355992785E-02, 3.5996418006E-01],
	[5.3450000000E+03, 2.0764109133E+00, 7.4644439393E+00, 3.1021812494E-02, 3.0440518627E-02, 3.6020386085E-01],
	[5.3500000000E+03, 2.0786848185E+00, 7.4612415777E+00, 3.1109306844E-02, 3.0525197577E-02, 3.6044330708E-01],
	[5.3550000000E+03, 2.0809590861E+00, 7.4580435796E+00, 3.1196965578E-02, 3.0610029755E-02, 3.6068251937E-01],
	[5.3600000000E+03, 2.0832337160E+00, 7.4548499348E+00, 3.1284788853E-02, 3.0695015281E-02, 3.6092149836E-01],
	[5.3650000000E+03, 2.0855087080E+00, 7.4516606334E+00, 3.1372776821E-02, 3.0780154273E-02, 3.6116024466E-01],
	[5.3700000000E+03, 2.0877840616E+00, 7.4484756655E+00, 3.1460929636E-02, 3.0865446852E-02, 3.6139875890E-01],
	[5.3750000000E+03, 2.0900597766E+00, 7.4452950212E+00, 3.1549247452E-02, 3.0950893135E-02, 3.6163704170E-01],
	[5.3800000000E+03, 2.0923358528E+00, 7.4421186905E+00, 3.1637730424E-02, 3.1036493243E-02, 3.6187509368E-01],
	[5.3850000000E+03, 2.0946122898E+00, 7.4389466637E+00, 3.1726378706E-02, 3.1122247294E-02, 3.6211291544E-01],
	[5.3900000000E+03, 2.0968890874E+00, 7.4357789308E+00, 3.1815192450E-02, 3.1208155407E-02, 3.6235050761E-01],
	[5.3950000000E+03, 2.0991662454E+00, 7.4326154821E+00, 3.1904171812E-02, 3.1294217700E-02, 3.6258787079E-01],
	[5.4000000000E+03, 2.1014437633E+00, 7.4294563079E+00, 3.1993316946E-02, 3.1380434293E-02, 3.6282500559E-01],
	[5.4050000000E+03, 2.1037216410E+00, 7.4263013985E+00, 3.2082628004E-02, 3.1466805304E-02, 3.6306191261E-01],
	[5.4100000000E+03, 2.1059998782E+00, 7.4231507440E+00, 3.2172105142E-02, 3.1553330852E-02, 3.6329859247E-01],
	[5.4150000000E+03, 2.1082784746E+00, 7.4200043349E+00, 3.2261748513E-02, 3.1640011055E-02, 3.6353504575E-01],
	[5.4200000000E+03, 2.1105690125E+00, 7.4169073975E+00, 3.2351558271E-02, 3.1726849476E-02, 3.6377127307E-01],
	[5.4250000000E+03, 2.1128614454E+00, 7.4138205420E+00, 3.2441534571E-02, 3.1813843274E-02, 3.6400727501E-01],
	[5.4300000000E+03, 2.1151542531E+00, 7.4107378132E+00, 3.2531677565E-02, 3.1900992115E-02, 3.6424305218E-01],
	[5.4350000000E+03, 2.1174474350E+00, 7.4076592017E+00, 3.2621987409E-02, 3.1988296119E-02, 3.6447860516E-01],
	[5.4400000000E+03, 2.1197409911E+00, 7.4045846983E+00, 3.2712464256E-02, 3.2075755402E-02, 3.6471393454E-01],
	[5.4450000000E+03, 2.1220349210E+00, 7.4015142938E+00, 3.2803108259E-02, 3.2163370085E-02, 3.6494904092E-01],
	[5.4500000000E+03, 2.1243292244E+00, 7.3984479788E+00, 3.2893919574E-02, 3.2251140283E-02, 3.6518392487E-01],
	[5.4550000000E+03, 2.1266239010E+00, 7.3953857443E+00, 3.2984898354E-02, 3.2339066117E-02, 3.6541858699E-01],
	[5.4600000000E+03, 2.1289189507E+00, 7.3923275810E+00, 3.3076044752E-02, 3.2427147703E-02, 3.6565302785E-01],
	[5.4650000000E+03, 2.1312143730E+00, 7.3892734798E+00, 3.3167358924E-02, 3.2515385159E-02, 3.6588724803E-01],
	[5.4700000000E+03, 2.1335101677E+00, 7.3862234317E+00, 3.3258841022E-02, 3.2603778604E-02, 3.6612124812E-01],
	[5.4750000000E+03, 2.1358063345E+00, 7.3831774274E+00, 3.3350491201E-02, 3.2692328154E-02, 3.6635502869E-01],
	[5.4800000000E+03, 2.1381028731E+00, 7.3801354581E+00, 3.3442669831E-02, 3.2781380039E-02, 3.6658859030E-01],
	[5.4850000000E+03, 2.1403997834E+00, 7.3770975147E+00, 3.3535309179E-02, 3.2870869070E-02, 3.6682193354E-01],
	[5.4900000000E+03, 2.1426970649E+00, 7.3740635881E+00, 3.3628120080E-02, 3.2960517351E-02, 3.6705505898E-01],
	[5.4950000000E+03, 2.1449947174E+00, 7.3710336695E+00, 3.3721102696E-02, 3.3050325007E-02, 3.6728796717E-01],
	[5.5000000000E+03, 2.1472927406E+00, 7.3680077498E+00, 3.3814257187E-02, 3.3140292158E-02, 3.6752065868E-01],
	[5.5050000000E+03, 2.1495967991E+00, 7.3650079360E+00, 3.3907583711E-02, 3.3230420731E-02, 3.6775313409E-01],
	[5.5100000000E+03, 2.1519082409E+00, 7.3620393772E+00, 3.4001082430E-02, 3.3320711298E-02, 3.6798539394E-01],
	[5.5150000000E+03, 2.1542200683E+00, 7.3590747059E+00, 3.4094753503E-02, 3.3411161763E-02, 3.6821743880E-01],
	[5.5200000000E+03, 2.1565322809E+00, 7.3561139134E+00, 3.4188597091E-02, 3.3501772246E-02, 3.6844926923E-01],
	[5.5250000000E+03, 2.1588448785E+00, 7.3531569912E+00, 3.4282613354E-02, 3.3592542870E-02, 3.6868088578E-01],
	[5.5300000000E+03, 2.1611578608E+00, 7.3502039307E+00, 3.4376802451E-02, 3.3683473757E-02, 3.6891228901E-01],
	[5.5350000000E+03, 2.1634712275E+00, 7.3472547234E+00, 3.4471164544E-02, 3.3774565029E-02, 3.6914347947E-01],
	[5.5400000000E+03, 2.1657849783E+00, 7.3443093608E+00, 3.4565699791E-02, 3.3865816808E-02, 3.6937445770E-01],
	[5.5450000000E+03, 2.1680991130E+00, 7.3413678344E+00, 3.4660408353E-02, 3.3957229214E-02, 3.6960522425E-01],
	[5.5500000000E+03, 2.1704136312E+00, 7.3384301358E+00, 3.4755290391E-02, 3.4048802371E-02, 3.6983577968E-01],
	[5.5550000000E+03, 2.1727285327E+00, 7.3354962565E+00, 3.4850346064E-02, 3.4140536399E-02, 3.7006612452E-01],
	[5.5600000000E+03, 2.1750438172E+00, 7.3325661881E+00, 3.4945575533E-02, 3.4232431420E-02, 3.7029625932E-01],
	[5.5650000000E+03, 2.1773594844E+00, 7.3296399223E+00, 3.5040978957E-02, 3.4324487556E-02, 3.7052618461E-01],
	[5.5700000000E+03, 2.1796755340E+00, 7.3267174507E+00, 3.5136556496E-02, 3.4416704927E-02, 3.7075590094E-01],
	[5.5750000000E+03, 2.1819919658E+00, 7.3237987651E+00, 3.5232308312E-02, 3.4509083655E-02, 3.7098540884E-01],
	[5.5800000000E+03, 2.1843087794E+00, 7.3208838570E+00, 3.5328234563E-02, 3.4601623861E-02, 3.7121470884E-01],
	[5.5850000000E+03, 2.1866259747E+00, 7.3179727183E+00, 3.5424335411E-02, 3.4694325666E-02, 3.7144380148E-01],
	[5.5900000000E+03, 2.1889435512E+00, 7.3150653407E+00, 3.5520611015E-02, 3.4787189190E-02, 3.7167268730E-01],
	[5.5950000000E+03, 2.1912704375E+00, 7.3121965675E+00, 3.5617061535E-02, 3.4880217611E-02, 3.7190136681E-01],
	[5.6000000000E+03, 2.1936010228E+00, 7.3093443715E+00, 3.5713687131E-02, 3.4973409156E-02, 3.7212984054E-01],
	[5.6050000000E+03, 2.1959320037E+00, 7.3064958320E+00, 3.5810487964E-02, 3.5066762818E-02, 3.7235810903E-01],
	[5.6100000000E+03, 2.1982633797E+00, 7.3036509410E+00, 3.5907464194E-02, 3.5160278718E-02, 3.7258617279E-01],
	[5.6150000000E+03, 2.2005951507E+00, 7.3008096907E+00, 3.6004615980E-02, 3.5253956978E-02, 3.7281403235E-01],
	[5.6200000000E+03, 2.2029273163E+00, 7.2979720732E+00, 3.6101943484E-02, 3.5347797718E-02, 3.7304168823E-01],
	[5.6250000000E+03, 2.2052598762E+00, 7.2951380805E+00, 3.6199446864E-02, 3.5441801059E-02, 3.7326914094E-01],
	[5.6300000000E+03, 2.2075928302E+00, 7.2923077049E+00, 3.6297126282E-02, 3.5535967120E-02, 3.7349639100E-01],
	[5.6350000000E+03, 2.2099261780E+00, 7.2894809385E+00, 3.6394981897E-02, 3.5630296022E-02, 3.7372343893E-01],
	[5.6400000000E+03, 2.2122599193E+00, 7.2866577735E+00, 3.6493013869E-02, 3.5724787887E-02, 3.7395028524E-01],
	[5.6450000000E+03, 2.2145940538E+00, 7.2838382021E+00, 3.6591222360E-02, 3.5819442833E-02, 3.7417693044E-01],
	[5.6500000000E+03, 2.2169285812E+00, 7.2810222167E+00, 3.6689607527E-02, 3.5914260980E-02, 3.7440337512E-01],
	[5.6550000000E+03, 2.2192635013E+00, 7.2782098093E+00, 3.6788169533E-02, 3.6009242450E-02, 3.7462961986E-01],
	[5.6600000000E+03, 2.2215988138E+00, 7.2754009725E+00, 3.6886908537E-02, 3.6104387362E-02, 3.7485566522E-01],
	[5.6650000000E+03, 2.2239345183E+00, 7.2725956984E+00, 3.6985824699E-02, 3.6199695835E-02, 3.7508151176E-01],
	[5.6700000000E+03, 2.2262706147E+00, 7.2697939794E+00, 3.7084918179E-02, 3.6295167990E-02, 3.7530716003E-01],
	[5.6750000000E+03, 2.2286071025E+00, 7.2669958079E+00, 3.7184189138E-02, 3.6390803946E-02, 3.7553261056E-01],
	[5.6800000000E+03, 2.2309439817E+00, 7.2642011762E+00, 3.7283637736E-02, 3.6486603823E-02, 3.7575786391E-01],
	[5.6850000000E+03, 2.2332898310E+00, 7.2614436182E+00, 3.7383264132E-02, 3.6582570893E-02, 3.7598292062E-01],
	[5.6900000000E+03, 2.2356393019E+00, 7.2587021025E+00, 3.7483068487E-02, 3.6678703337E-02, 3.7620778124E-01],
	[5.6950000000E+03, 2.2379891775E+00, 7.2559640285E+00, 3.7583050961E-02, 3.6775000097E-02, 3.7643244630E-01],
	[5.7000000000E+03, 2.2403394577E+00, 7.2532293888E+00, 3.7683211715E-02, 3.6871461291E-02, 3.7665691634E-01],
	[5.7050000000E+03, 2.2426901421E+00, 7.2504981762E+00, 3.7783550907E-02, 3.6968087039E-02, 3.7688119191E-01],
	[5.7100000000E+03, 2.2450412304E+00, 7.2477703833E+00, 3.7884068700E-02, 3.7064877460E-02, 3.7710527352E-01],
	[5.7150000000E+03, 2.2473927224E+00, 7.2450460029E+00, 3.7984765252E-02, 3.7161832674E-02, 3.7732916173E-01],
	[5.7200000000E+03, 2.2497446177E+00, 7.2423250277E+00, 3.8085640724E-02, 3.7258952800E-02, 3.7755285704E-01],
	[5.7250000000E+03, 2.2520969161E+00, 7.2396074505E+00, 3.8186695276E-02, 3.7356237956E-02, 3.7777636001E-01],
	[5.7300000000E+03, 2.2544496173E+00, 7.2368932641E+00, 3.8287929068E-02, 3.7453688261E-02, 3.7799967115E-01],
	[5.7350000000E+03, 2.2568027210E+00, 7.2341824613E+00, 3.8389366704E-02, 3.7551327223E-02, 3.7822279099E-01],
	[5.7400000000E+03, 2.2591562270E+00, 7.2314750349E+00, 3.8491011881E-02, 3.7649158338E-02, 3.7844572004E-01],
	[5.7450000000E+03, 2.2615101349E+00, 7.2287709778E+00, 3.8592837044E-02, 3.7747155203E-02, 3.7866845885E-01],
	[5.7500000000E+03, 2.2638644444E+00, 7.2260702830E+00, 3.8694842353E-02, 3.7845317938E-02, 3.7889100791E-01],
	[5.7550000000E+03, 2.2662191554E+00, 7.2233729432E+00, 3.8797027969E-02, 3.7943646661E-02, 3.7911336776E-01],
	[5.7600000000E+03, 2.2685742674E+00, 7.2206789514E+00, 3.8899394053E-02, 3.8042141492E-02, 3.7933553890E-01],
	[5.7650000000E+03, 2.2709297803E+00, 7.2179883006E+00, 3.9001940766E-02, 3.8140802549E-02, 3.7955752186E-01],
	[5.7700000000E+03, 2.2732856937E+00, 7.2153009836E+00, 3.9104668268E-02, 3.8239629951E-02, 3.7977931714E-01],
	[5.7750000000E+03, 2.2756469451E+00, 7.2126363660E+00, 3.9207576721E-02, 3.8338625766E-02, 3.8000092525E-01],
	[5.7800000000E+03, 2.2780150263E+00, 7.2100002046E+00, 3.9310666284E-02, 3.8437790723E-02, 3.8022234671E-01],
	[5.7850000000E+03, 2.2803835210E+00, 7.2073672849E+00, 3.9413937120E-02, 3.8537122418E-02, 3.8044358203E-01],
	[5.7900000000E+03, 2.2827524288E+00, 7.2047376001E+00, 3.9517389389E-02, 3.8636620969E-02, 3.8066463169E-01],
	[5.7950000000E+03, 2.2851217495E+00, 7.2021111434E+00, 3.9621023251E-02, 3.8736286495E-02, 3.8088549623E-01],
	[5.8000000000E+03, 2.2874914828E+00, 7.1994879081E+00, 3.9724838868E-02, 3.8836119114E-02, 3.8110617612E-01],
	[5.8050000000E+03, 2.2898616284E+00, 7.1968678874E+00, 3.9828836400E-02, 3.8936118944E-02, 3.8132667188E-01],
	[5.8100000000E+03, 2.2922321861E+00, 7.1942510748E+00, 3.9933016008E-02, 3.9036286104E-02, 3.8154698400E-01],
	[5.8150000000E+03, 2.2946031555E+00, 7.1916374634E+00, 4.0037377853E-02, 3.9136620712E-02, 3.8176711298E-01],
	[5.8200000000E+03, 2.2969745363E+00, 7.1890270466E+00, 4.0141922097E-02, 3.9237122886E-02, 3.8198705932E-01],
	[5.8250000000E+03, 2.2993463283E+00, 7.1864198178E+00, 4.0246648898E-02, 3.9337792744E-02, 3.8220682351E-01],
	[5.8300000000E+03, 2.3017185312E+00, 7.1838157703E+00, 4.0351558420E-02, 3.9438630403E-02, 3.8242640604E-01],
	[5.8350000000E+03, 2.3040911447E+00, 7.1812148976E+00, 4.0456650821E-02, 3.9539635982E-02, 3.8264580740E-01],
	[5.8400000000E+03, 2.3064641686E+00, 7.1786171930E+00, 4.0561926264E-02, 3.9640809597E-02, 3.8286502808E-01],
	[5.8450000000E+03, 2.3088376025E+00, 7.1760226500E+00, 4.0667384909E-02, 3.9742151368E-02, 3.8308406857E-01],
	[5.8500000000E+03, 2.3112114461E+00, 7.1734312621E+00, 4.0773026917E-02, 3.9843661411E-02, 3.8330292936E-01],
	[5.8550000000E+03, 2.3135856993E+00, 7.1708430226E+00, 4.0878852449E-02, 3.9945339843E-02, 3.8352161092E-01],
	[5.8600000000E+03, 2.3159603617E+00, 7.1682579252E+00, 4.0984861665E-02, 4.0047186783E-02, 3.8374011374E-01],
	[5.8650000000E+03, 2.3183354330E+00, 7.1656759633E+00, 4.1091054727E-02, 4.0149202347E-02, 3.8395843830E-01],
	[5.8700000000E+03, 2.3207201717E+00, 7.1631336063E+00, 4.1197431795E-02, 4.0251390589E-02, 3.8417658509E-01],
	[5.8750000000E+03, 2.3231069929E+00, 7.1606008569E+00, 4.1303993030E-02, 4.0353748431E-02, 3.8439455457E-01],
	[5.8800000000E+03, 2.3254942352E+00, 7.1580711566E+00, 4.1410738593E-02, 4.0456275287E-02, 3.8461234723E-01],
	[5.8850000000E+03, 2.3278818984E+00, 7.1555444990E+00, 4.1517668645E-02, 4.0558971272E-02, 3.8482996353E-01],
	[5.8900000000E+03, 2.3302699823E+00, 7.1530208779E+00, 4.1624783347E-02, 4.0661836505E-02, 3.8504740396E-01],
	[5.8950000000E+03, 2.3326584865E+00, 7.1505002870E+00, 4.1732082860E-02, 4.0764871102E-02, 3.8526466897E-01],
	[5.9000000000E+03, 2.3350474107E+00, 7.1479827203E+00, 4.1839567344E-02, 4.0868075179E-02, 3.8548175906E-01],
	[5.9050000000E+03, 2.3374367548E+00, 7.1454681715E+00, 4.1947236960E-02, 4.0971448855E-02, 3.8569867467E-01],
	[5.9100000000E+03, 2.3398265184E+00, 7.1429566343E+00, 4.2055091870E-02, 4.1074992244E-02, 3.8591541628E-01],
	[5.9150000000E+03, 2.3422167012E+00, 7.1404481028E+00, 4.2163132234E-02, 4.1178705465E-02, 3.8613198435E-01],
	[5.9200000000E+03, 2.3446073029E+00, 7.1379425707E+00, 4.2271358213E-02, 4.1282588632E-02, 3.8634837935E-01],
	[5.9250000000E+03, 2.3469983233E+00, 7.1354400319E+00, 4.2379769968E-02, 4.1386641863E-02, 3.8656460174E-01],
	[5.9300000000E+03, 2.3493897620E+00, 7.1329404803E+00, 4.2488367659E-02, 4.1490865274E-02, 3.8678065198E-01],
	[5.9350000000E+03, 2.3517816189E+00, 7.1304439099E+00, 4.2597151448E-02, 4.1595258981E-02, 3.8699653053E-01],
	[5.9400000000E+03, 2.3541738936E+00, 7.1279503146E+00, 4.2706121496E-02, 4.1699823099E-02, 3.8721223785E-01],
	[5.9450000000E+03, 2.3565665858E+00, 7.1254596883E+00, 4.2815277963E-02, 4.1804557746E-02, 3.8742777439E-01],
	[5.9500000000E+03, 2.3589596953E+00, 7.1229720251E+00, 4.2924621011E-02, 4.1909463037E-02, 3.8764314061E-01],
	[5.9550000000E+03, 2.3613532217E+00, 7.1204873188E+00, 4.3034150799E-02, 4.2014539087E-02, 3.8785833691E-01],
	[5.9600000000E+03, 2.3637471649E+00, 7.1180055635E+00, 4.3143867490E-02, 4.2119786013E-02, 3.8807336374E-01],
	[5.9650000000E+03, 2.3661516054E+00, 7.1155667043E+00, 4.3253771244E-02, 4.2225208547E-02, 3.8828822158E-01],
	[5.9700000000E+03, 2.3685568762E+00, 7.1131323144E+00, 4.3363862221E-02, 4.2330802410E-02, 3.8850291091E-01],
	[5.9750000000E+03, 2.3709625752E+00, 7.1107007943E+00, 4.3474140583E-02, 4.2436567533E-02, 3.8871743222E-01],
	[5.9800000000E+03, 2.3733687024E+00, 7.1082721382E+00, 4.3584606491E-02, 4.2542504031E-02, 3.8893178597E-01],
	[5.9850000000E+03, 2.3757752573E+00, 7.1058463404E+00, 4.3695260106E-02, 4.2648612021E-02, 3.8914597264E-01],
	[5.9900000000E+03, 2.3781822397E+00, 7.1034233951E+00, 4.3806101588E-02, 4.2754891618E-02, 3.8935999272E-01],
	[5.9950000000E+03, 2.3805896493E+00, 7.1010032966E+00, 4.3917131098E-02, 4.2861342937E-02, 3.8957384667E-01],
	[6.0000000000E+03, 2.3829974859E+00, 7.0985860391E+00, 4.4028348798E-02, 4.2967966093E-02, 3.8978753496E-01],
	[6.0050000000E+03, 2.3854057491E+00, 7.0961716170E+00, 4.4140321729E-02, 4.3075301058E-02, 3.9000105808E-01],
	[6.0100000000E+03, 2.3878144387E+00, 7.0937600247E+00, 4.4252485584E-02, 4.3182810290E-02, 3.9021441648E-01],
	[6.0150000000E+03, 2.3902235544E+00, 7.0913512563E+00, 4.4364840529E-02, 4.3290493909E-02, 3.9042761063E-01],
	[6.0200000000E+03, 2.3926330959E+00, 7.0889453064E+00, 4.4477386729E-02, 4.3398352032E-02, 3.9064064100E-01],
	[6.0250000000E+03, 2.3950430630E+00, 7.0865421691E+00, 4.4590124350E-02, 4.3506384779E-02, 3.9085350805E-01],
	[6.0300000000E+03, 2.3974534553E+00, 7.0841418390E+00, 4.4703053557E-02, 4.3614592268E-02, 3.9106621225E-01],
	[6.0350000000E+03, 2.3998642726E+00, 7.0817443104E+00, 4.4816174517E-02, 4.3722974616E-02, 3.9127875406E-01],
	[6.0400000000E+03, 2.4022755146E+00, 7.0793495778E+00, 4.4929487393E-02, 4.3831531941E-02, 3.9149113393E-01],
	[6.0450000000E+03, 2.4046871811E+00, 7.0769576355E+00, 4.5042992352E-02, 4.3940264362E-02, 3.9170335233E-01],
	[6.0500000000E+03, 2.4070992717E+00, 7.0745684780E+00, 4.5156689560E-02, 4.4049171996E-02, 3.9191540971E-01],
	[6.0550000000E+03, 2.4095117861E+00, 7.0721820998E+00, 4.5270579181E-02, 4.4158254961E-02, 3.9212730653E-01],
	[6.0600000000E+03, 2.4119325108E+00, 7.0698293944E+00, 4.5384661382E-02, 4.4267517208E-02, 3.9233904324E-01],
	[6.0650000000E+03, 2.4143559760E+00, 7.0674885572E+00, 4.5498936327E-02, 4.4376956193E-02, 3.9255062029E-01],
	[6.0700000000E+03, 2.4167798761E+00, 7.0651504231E+00, 4.5613404183E-02, 4.4486570901E-02, 3.9276203814E-01],
	[6.0750000000E+03, 2.4192042108E+00, 7.0628149868E+00, 4.5728065115E-02, 4.4596361449E-02, 3.9297329723E-01],
	[6.0800000000E+03, 2.4216289800E+00, 7.0604822428E+00, 4.5842919289E-02, 4.4706327955E-02, 3.9318439801E-01],
	[6.0850000000E+03, 2.4240541833E+00, 7.0581521860E+00, 4.5957966869E-02, 4.4816470537E-02, 3.9339534094E-01],
	[6.0900000000E+03, 2.4264798204E+00, 7.0558248110E+00, 4.6073208023E-02, 4.4926789311E-02, 3.9360612644E-01],
	[6.0950000000E+03, 2.4289058911E+00, 7.0535001126E+00, 4.6188642914E-02, 4.5037284395E-02, 3.9381675498E-01],
	[6.1000000000E+03, 2.4313323950E+00, 7.0511780853E+00, 4.6304271709E-02, 4.5147955905E-02, 3.9402722698E-01],
	[6.1050000000E+03, 2.4337593320E+00, 7.0488587241E+00, 4.6420094574E-02, 4.5258803960E-02, 3.9423754289E-01],
	[6.1100000000E+03, 2.4361867017E+00, 7.0465420236E+00, 4.6536111673E-02, 4.5369828675E-02, 3.9444770316E-01],
	[6.1150000000E+03, 2.4386145038E+00, 7.0442279787E+00, 4.6652323173E-02, 4.5481030168E-02, 3.9465770821E-01],
	[6.1200000000E+03, 2.4410427381E+00, 7.0419165841E+00, 4.6768729239E-02, 4.5592408554E-02, 3.9486755850E-01],
	[6.1250000000E+03, 2.4434714043E+00, 7.0396078346E+00, 4.6885330036E-02, 4.5703963952E-02, 3.9507725444E-01],
	[6.1300000000E+03, 2.4459005021E+00, 7.0373017251E+00, 4.7002125731E-02, 4.5815696476E-02, 3.9528679647E-01],
	[6.1350000000E+03, 2.4483300313E+00, 7.0349982503E+00, 4.7119116488E-02, 4.5927606245E-02, 3.9549618504E-01],
	[6.1400000000E+03, 2.4507599915E+00, 7.0326974051E+00, 4.7236302474E-02, 4.6039693373E-02, 3.9570542056E-01],
	[6.1450000000E+03, 2.4531903825E+00, 7.0303991845E+00, 4.7353683853E-02, 4.6151957977E-02, 3.9591450348E-01],
	[6.1500000000E+03, 2.4556212041E+00, 7.0281035831E+00, 4.7471260793E-02, 4.6264400173E-02, 3.9612343421E-01],
	[6.1550000000E+03, 2.4580551091E+00, 7.0258210986E+00, 4.7589033457E-02, 4.6377021480E-02, 3.9633221319E-01],
	[6.1600000000E+03, 2.4604965404E+00, 7.0235692483E+00, 4.7707002012E-02, 4.6489824383E-02, 3.9654084084E-01],
	[6.1650000000E+03, 2.4629384129E+00, 7.0213199461E+00, 4.7825166624E-02, 4.6602805266E-02, 3.9674931759E-01],
	[6.1700000000E+03, 2.4653807261E+00, 7.0190731867E+00, 4.7943527457E-02, 4.6715964245E-02, 3.9695764386E-01],
	[6.1750000000E+03, 2.4678234799E+00, 7.0168289655E+00, 4.8062084678E-02, 4.6829301436E-02, 3.9716582007E-01],
	[6.1800000000E+03, 2.4702666740E+00, 7.0145872773E+00, 4.8180838453E-02, 4.6942816955E-02, 3.9737384664E-01],
	[6.1850000000E+03, 2.4727103080E+00, 7.0123481174E+00, 4.8299788946E-02, 4.7056510917E-02, 3.9758172400E-01],
	[6.1900000000E+03, 2.4751543817E+00, 7.0101114808E+00, 4.8418936324E-02, 4.7170383438E-02, 3.9778945256E-01],
	[6.1950000000E+03, 2.4775988949E+00, 7.0078773627E+00, 4.8538280751E-02, 4.7284434634E-02, 3.9799703273E-01],
	[6.2000000000E+03, 2.4800438472E+00, 7.0056457581E+00, 4.8657822395E-02, 4.7398664619E-02, 3.9820446495E-01],
	[6.2050000000E+03, 2.4824892384E+00, 7.0034166623E+00, 4.8777561420E-02, 4.7513073509E-02, 3.9841174961E-01],
	[6.2100000000E+03, 2.4849350682E+00, 7.0011900704E+00, 4.8897497992E-02, 4.7627661419E-02, 3.9861888713E-01],
	[6.2150000000E+03, 2.4873813363E+00, 6.9989659775E+00, 4.9017632277E-02, 4.7742428464E-02, 3.9882587793E-01],
	[6.2200000000E+03, 2.4898280425E+00, 6.9967443789E+00, 4.9137964440E-02, 4.7857374759E-02, 3.9903272241E-01],
	[6.2250000000E+03, 2.4922751864E+00, 6.9945252698E+00, 4.9258494648E-02, 4.7972500419E-02, 3.9923942099E-01],
	[6.2300000000E+03, 2.4947227679E+00, 6.9923086453E+00, 4.9379223065E-02, 4.8087805559E-02, 3.9944597407E-01],
	[6.2350000000E+03, 2.4971707866E+00, 6.9900945008E+00, 4.9500149857E-02, 4.8203290293E-02, 3.9965238207E-01],
	[6.2400000000E+03, 2.4996192422E+00, 6.9878828313E+00, 4.9621275190E-02, 4.8318954736E-02, 3.9985864537E-01],
	[6.2450000000E+03, 2.5020681346E+00, 6.9856736323E+00, 4.9742599230E-02, 4.8434799002E-02, 4.0006476441E-01],
	[6.2500000000E+03, 2.5045174633E+00, 6.9834668989E+00, 4.9864122143E-02, 4.8550823206E-02, 4.0027073956E-01],
	[6.2550000000E+03, 2.5069715433E+00, 6.9812796688E+00, 4.9985844093E-02, 4.8667029916E-02, 4.0047657125E-01],
	[6.2600000000E+03, 2.5094311469E+00, 6.9791149185E+00, 5.0107765247E-02, 4.8783419712E-02, 4.0068225986E-01],
	[6.2650000000E+03, 2.5118911970E+00, 6.9769525671E+00, 5.0229885771E-02, 4.8899989829E-02, 4.0088780580E-01],
	[6.2700000000E+03, 2.5143516933E+00, 6.9747926098E+00, 5.0352205830E-02, 4.9016740382E-02, 4.0109320947E-01],
	[6.2750000000E+03, 2.5168126356E+00, 6.9726350422E+00, 5.0474725590E-02, 4.9133671484E-02, 4.0129847126E-01],
	[6.2800000000E+03, 2.5192740234E+00, 6.9704798597E+00, 5.0597445216E-02, 4.9250783250E-02, 4.0150359158E-01],
	[6.2850000000E+03, 2.5217358567E+00, 6.9683270579E+00, 5.0720364874E-02, 4.9368075794E-02, 4.0170857082E-01],
	[6.2900000000E+03, 2.5241981351E+00, 6.9661766320E+00, 5.0843484730E-02, 4.9485549229E-02, 4.0191340936E-01],
	[6.2950000000E+03, 2.5266608584E+00, 6.9640285777E+00, 5.0966804951E-02, 4.9603203669E-02, 4.0211810761E-01],
	[6.3000000000E+03, 2.5291240261E+00, 6.9618828905E+00, 5.1090325700E-02, 4.9721039227E-02, 4.0232266596E-01],
	[6.3050000000E+03, 2.5315876382E+00, 6.9597395659E+00, 5.1214047144E-02, 4.9839056018E-02, 4.0252708480E-01],
	[6.3100000000E+03, 2.5340516943E+00, 6.9575985993E+00, 5.1337969450E-02, 4.9957254154E-02, 4.0273136451E-01],
	[6.3150000000E+03, 2.5365161942E+00, 6.9554599864E+00, 5.1462092782E-02, 5.0075633749E-02, 4.0293550549E-01],
	[6.3200000000E+03, 2.5389811375E+00, 6.9533237227E+00, 5.1586417306E-02, 5.0194194915E-02, 4.0313950813E-01],
	[6.3250000000E+03, 2.5414465241E+00, 6.9511898037E+00, 5.1710943188E-02, 5.0312937767E-02, 4.0334337280E-01],
	[6.3300000000E+03, 2.5439123536E+00, 6.9490582251E+00, 5.1835670594E-02, 5.0431862417E-02, 4.0354709991E-01],
	[6.3350000000E+03, 2.5463786257E+00, 6.9469289824E+00, 5.1960599690E-02, 5.0550968977E-02, 4.0375068982E-01],
	[6.3400000000E+03, 2.5488453402E+00, 6.9448020712E+00, 5.2085730640E-02, 5.0670257561E-02, 4.0395414292E-01],
	[6.3450000000E+03, 2.5513124969E+00, 6.9426774871E+00, 5.2211063612E-02, 5.0789728281E-02, 4.0415745960E-01],
	[6.3500000000E+03, 2.5537800954E+00, 6.9405552258E+00, 5.2336598771E-02, 5.0909381251E-02, 4.0436064024E-01],
	[6.3550000000E+03, 2.5562510956E+00, 6.9384469686E+00, 5.2462336282E-02, 5.1029218393E-02, 4.0456368521E-01],
	[6.3600000000E+03, 2.5587286276E+00, 6.9363650099E+00, 5.2588276311E-02, 5.1149241761E-02, 4.0476659490E-01],
	[6.3650000000E+03, 2.5612066111E+00, 6.9342853114E+00, 5.2714419025E-02, 5.1269447756E-02, 4.0496936968E-01],
	[6.3700000000E+03, 2.5636850458E+00, 6.9322078686E+00, 5.2840764588E-02, 5.1389836493E-02, 4.0517200993E-01],
	[6.3750000000E+03, 2.5661639313E+00, 6.9301326776E+00, 5.2967313167E-02, 5.1510408082E-02, 4.0537451603E-01],
	[6.3800000000E+03, 2.5686432674E+00, 6.9280597340E+00, 5.3094064927E-02, 5.1631162636E-02, 4.0557688834E-01],
	[6.3850000000E+03, 2.5711230539E+00, 6.9259890336E+00, 5.3221020034E-02, 5.1752100267E-02, 4.0577912725E-01],
	[6.3900000000E+03, 2.5736032904E+00, 6.9239205724E+00, 5.3348178655E-02, 5.1873221087E-02, 4.0598123313E-01],
	[6.3950000000E+03, 2.5760839768E+00, 6.9218543460E+00, 5.3475540954E-02, 5.1994525208E-02, 4.0618320635E-01],
	[6.4000000000E+03, 2.5785651126E+00, 6.9197903504E+00, 5.3603107097E-02, 5.2116012742E-02, 4.0638504727E-01],
	[6.4050000000E+03, 2.5810466978E+00, 6.9177285814E+00, 5.3730877251E-02, 5.2237683801E-02, 4.0658675627E-01],
	[6.4100000000E+03, 2.5835287319E+00, 6.9156690348E+00, 5.3858851581E-02, 5.2359538495E-02, 4.0678833373E-01],
	[6.4150000000E+03, 2.5860112147E+00, 6.9136117066E+00, 5.3987030253E-02, 5.2481576937E-02, 4.0698977999E-01],
	[6.4200000000E+03, 2.5884941460E+00, 6.9115565926E+00, 5.4115413433E-02, 5.2603799238E-02, 4.0719109544E-01],
	[6.4250000000E+03, 2.5909775254E+00, 6.9095036888E+00, 5.4244001286E-02, 5.2726205508E-02, 4.0739228043E-01],
	[6.4300000000E+03, 2.5934613528E+00, 6.9074529909E+00, 5.4372793978E-02, 5.2848795861E-02, 4.0759333533E-01],
	[6.4350000000E+03, 2.5959456278E+00, 6.9054044950E+00, 5.4501791676E-02, 5.2971570405E-02, 4.0779426051E-01],
	[6.4400000000E+03, 2.5984303502E+00, 6.9033581969E+00, 5.4630994545E-02, 5.3094529253E-02, 4.0799505633E-01],
	[6.4450000000E+03, 2.6009155197E+00, 6.9013140927E+00, 5.4760402751E-02, 5.3217672515E-02, 4.0819572315E-01],
	[6.4500000000E+03, 2.6034011361E+00, 6.8992721782E+00, 5.4890016459E-02, 5.3341000302E-02, 4.0839626133E-01],
	[6.4550000000E+03, 2.6058871990E+00, 6.8972324494E+00, 5.5019835836E-02, 5.3464512725E-02, 4.0859667122E-01],
	[6.4600000000E+03, 2.6083812825E+00, 6.8952248132E+00, 5.5149861047E-02, 5.3588214898E-02, 4.0879695320E-01],
	[6.4650000000E+03, 2.6108769410E+00, 6.8932237331E+00, 5.5280092258E-02, 5.3712102707E-02, 4.0899710761E-01],
	[6.4700000000E+03, 2.6133730552E+00, 6.8912247801E+00, 5.5410529636E-02, 5.3836175526E-02, 4.0919713482E-01],
	[6.4750000000E+03, 2.6158696247E+00, 6.8892279503E+00, 5.5541173345E-02, 5.3960433466E-02, 4.0939703517E-01],
	[6.4800000000E+03, 2.6183666494E+00, 6.8872332398E+00, 5.5672023552E-02, 5.4084876637E-02, 4.0959680903E-01],
	[6.4850000000E+03, 2.6208641289E+00, 6.8852406447E+00, 5.5803083789E-02, 5.4209508327E-02, 4.0979645675E-01],
	[6.4900000000E+03, 2.6233620630E+00, 6.8832501611E+00, 5.5934351456E-02, 5.4334326033E-02, 4.0999597868E-01],
	[6.4950000000E+03, 2.6258604514E+00, 6.8812617852E+00, 5.6065826134E-02, 5.4459329315E-02, 4.1019537518E-01],
	[6.5000000000E+03, 2.6283592938E+00, 6.8792755132E+00, 5.6197507989E-02, 5.4584518283E-02, 4.1039464659E-01],
	[6.5050000000E+03, 2.6308585901E+00, 6.8772913411E+00, 5.6329397188E-02, 5.4709893046E-02, 4.1059379326E-01],
	[6.5100000000E+03, 2.6333583398E+00, 6.8753092652E+00, 5.6461493896E-02, 5.4835453715E-02, 4.1079281555E-01],
	[6.5150000000E+03, 2.6358585428E+00, 6.8733292817E+00, 5.6593798278E-02, 5.4961200399E-02, 4.1099171380E-01],
	[6.5200000000E+03, 2.6383591987E+00, 6.8713513866E+00, 5.6726310502E-02, 5.5087133208E-02, 4.1119048839E-01],
	[6.5250000000E+03, 2.6408603074E+00, 6.8693755763E+00, 5.6859030732E-02, 5.5213252251E-02, 4.1138913984E-01],
	[6.5300000000E+03, 2.6433618685E+00, 6.8674018469E+00, 5.6991959136E-02, 5.5339557637E-02, 4.1158766853E-01],
	[6.5350000000E+03, 2.6458638819E+00, 6.8654301947E+00, 5.7125095877E-02, 5.5466049476E-02, 4.1178607480E-01],
	[6.5400000000E+03, 2.6483663471E+00, 6.8634606158E+00, 5.7258441124E-02, 5.5592727877E-02, 4.1198435899E-01],
	[6.5450000000E+03, 2.6508692640E+00, 6.8614931066E+00, 5.7391995041E-02, 5.5719592949E-02, 4.1218252145E-01],
	[6.5500000000E+03, 2.6533726323E+00, 6.8595276632E+00, 5.7525757795E-02, 5.5846644801E-02, 4.1238056253E-01],
	[6.5550000000E+03, 2.6558764517E+00, 6.8575642819E+00, 5.7659729551E-02, 5.5973883541E-02, 4.1257848255E-01],
	[6.5600000000E+03, 2.6583814370E+00, 6.8556057932E+00, 5.7793910475E-02, 5.6101309787E-02, 4.1277628187E-01],
	[6.5650000000E+03, 2.6608944985E+00, 6.8536795403E+00, 5.7928300734E-02, 5.6228928579E-02, 4.1297396082E-01],
	[6.5700000000E+03, 2.6634080197E+00, 6.8517552945E+00, 5.8062900492E-02, 5.6356734630E-02, 4.1317151973E-01],
	[6.5750000000E+03, 2.6659220004E+00, 6.8498330521E+00, 5.8197709917E-02, 5.6484728048E-02, 4.1336895896E-01],
	[6.5800000000E+03, 2.6684364403E+00, 6.8479128097E+00, 5.8332729175E-02, 5.6612908941E-02, 4.1356627883E-01],
	[6.5850000000E+03, 2.6709513390E+00, 6.8459945635E+00, 5.8467958430E-02, 5.6741277418E-02, 4.1376347968E-01],
	[6.5900000000E+03, 2.6734666965E+00, 6.8440783101E+00, 5.8603397849E-02, 5.6869833587E-02, 4.1396056185E-01],
	[6.5950000000E+03, 2.6759825123E+00, 6.8421640458E+00, 5.8739047599E-02, 5.6998577557E-02, 4.1415752566E-01],
	[6.6000000000E+03, 2.6784987862E+00, 6.8402517670E+00, 5.8874907844E-02, 5.7127509435E-02, 4.1435437146E-01],
	[6.6050000000E+03, 2.6810155180E+00, 6.8383414702E+00, 5.9010978752E-02, 5.7256629329E-02, 4.1455109957E-01],
	[6.6100000000E+03, 2.6835327074E+00, 6.8364331519E+00, 5.9147260487E-02, 5.7385937348E-02, 4.1474771033E-01],
	[6.6150000000E+03, 2.6860503542E+00, 6.8345268085E+00, 5.9283753217E-02, 5.7515433599E-02, 4.1494420406E-01],
	[6.6200000000E+03, 2.6885684580E+00, 6.8326224364E+00, 5.9420457106E-02, 5.7645118190E-02, 4.1514058110E-01],
	[6.6250000000E+03, 2.6910870186E+00, 6.8307200322E+00, 5.9557372321E-02, 5.7774991228E-02, 4.1533684178E-01],
	[6.6300000000E+03, 2.6936060358E+00, 6.8288195922E+00, 5.9694499028E-02, 5.7905052822E-02, 4.1553298642E-01],
	[6.6350000000E+03, 2.6961255093E+00, 6.8269211131E+00, 5.9831837393E-02, 5.8035303077E-02, 4.1572901535E-01],
	[6.6400000000E+03, 2.6986454388E+00, 6.8250245914E+00, 5.9969387582E-02, 5.8165742102E-02, 4.1592492889E-01],
	[6.6450000000E+03, 2.7011658240E+00, 6.8231300234E+00, 6.0107149761E-02, 5.8296370003E-02, 4.1612072738E-01],
	[6.6500000000E+03, 2.7036866648E+00, 6.8212374058E+00, 6.0245124096E-02, 5.8427186888E-02, 4.1631641113E-01],
	[6.6550000000E+03, 2.7062079608E+00, 6.8193467351E+00, 6.0383310753E-02, 5.8558192864E-02, 4.1651198047E-01],
	[6.6600000000E+03, 2.7087297118E+00, 6.8174580077E+00, 6.0521709897E-02, 5.8689388037E-02, 4.1670743572E-01],
	[6.6650000000E+03, 2.7112519175E+00, 6.8155712204E+00, 6.0660321696E-02, 5.8820772515E-02, 4.1690277721E-01],
	[6.6700000000E+03, 2.7137822869E+00, 6.8137170348E+00, 6.0799146314E-02, 5.8952352337E-02, 4.1709800526E-01],
	[6.6750000000E+03, 2.7163133926E+00, 6.8118658294E+00, 6.0938183919E-02, 5.9084121930E-02, 4.1729312018E-01],
	[6.6800000000E+03, 2.7188449611E+00, 6.8100165124E+00, 6.1077434675E-02, 5.9216081192E-02, 4.1748812230E-01],
	[6.6850000000E+03, 2.7213769922E+00, 6.8081690807E+00, 6.1216898750E-02, 5.9348230229E-02, 4.1768301193E-01],
	[6.6900000000E+03, 2.7239094856E+00, 6.8063235308E+00, 6.1356576309E-02, 5.9480569147E-02, 4.1787778939E-01],
	[6.6950000000E+03, 2.7264424411E+00, 6.8044798595E+00, 6.1496467518E-02, 5.9613098054E-02, 4.1807245501E-01],
	[6.7000000000E+03, 2.7289758583E+00, 6.8026380634E+00, 6.1636572543E-02, 5.9745817054E-02, 4.1826700909E-01],
	[6.7050000000E+03, 2.7315097370E+00, 6.8007981392E+00, 6.1776891550E-02, 5.9878726254E-02, 4.1846145195E-01],
	[6.7100000000E+03, 2.7340440770E+00, 6.7989600837E+00, 6.1917424705E-02, 6.0011825760E-02, 4.1865578391E-01],
	[6.7150000000E+03, 2.7365788780E+00, 6.7971238935E+00, 6.2058172175E-02, 6.0145115678E-02, 4.1885000528E-01],
	[6.7200000000E+03, 2.7391141397E+00, 6.7952895654E+00, 6.2199134125E-02, 6.0278596114E-02, 4.1904411637E-01],
	[6.7250000000E+03, 2.7416498619E+00, 6.7934570961E+00, 6.2340310722E-02, 6.0412267173E-02, 4.1923811750E-01],
	[6.7300000000E+03, 2.7441860444E+00, 6.7916264823E+00, 6.2481702131E-02, 6.0546128961E-02, 4.1943200898E-01],
	[6.7350000000E+03, 2.7467226868E+00, 6.7897977208E+00, 6.2623308518E-02, 6.0680181583E-02, 4.1962579112E-01],
	[6.7400000000E+03, 2.7492597889E+00, 6.7879708083E+00, 6.2765130051E-02, 6.0814425144E-02, 4.1981946423E-01],
	[6.7450000000E+03, 2.7517973504E+00, 6.7861457416E+00, 6.2907166893E-02, 6.0948859751E-02, 4.2001302861E-01],
	[6.7500000000E+03, 2.7543353712E+00, 6.7843225175E+00, 6.3049419213E-02, 6.1083485507E-02, 4.2020648458E-01],
	[6.7550000000E+03, 2.7568738508E+00, 6.7825011327E+00, 6.3191887176E-02, 6.1218302518E-02, 4.2039983245E-01],
	[6.7600000000E+03, 2.7594127892E+00, 6.7806815840E+00, 6.3334570947E-02, 6.1353310889E-02, 4.2059307252E-01],
	[6.7650000000E+03, 2.7619521859E+00, 6.7788638682E+00, 6.3477470694E-02, 6.1488510725E-02, 4.2078620510E-01],
	[6.7700000000E+03, 2.7644920409E+00, 6.7770479822E+00, 6.3620586581E-02, 6.1623902130E-02, 4.2097923049E-01],
	[6.7750000000E+03, 2.7670362079E+00, 6.7752493657E+00, 6.3763918776E-02, 6.1759488412E-02, 4.2117214900E-01],
	[6.7800000000E+03, 2.7695846059E+00, 6.7734676374E+00, 6.3907467444E-02, 6.1895269638E-02, 4.2136496094E-01],
	[6.7850000000E+03, 2.7721334697E+00, 6.7716876906E+00, 6.4051232752E-02, 6.2031242791E-02, 4.2155766660E-01],
	[6.7900000000E+03, 2.7746827990E+00, 6.7699095222E+00, 6.4195214865E-02, 6.2167407978E-02, 4.2175026630E-01],
	[6.7950000000E+03, 2.7772325936E+00, 6.7681331291E+00, 6.4339413949E-02, 6.2303765302E-02, 4.2194276032E-01],
	[6.8000000000E+03, 2.7797828532E+00, 6.7663585083E+00, 6.4483830172E-02, 6.2440314867E-02, 4.2213514898E-01],
	[6.8050000000E+03, 2.7823335775E+00, 6.7645856567E+00, 6.4628463698E-02, 6.2577056777E-02, 4.2232743257E-01],
	[6.8100000000E+03, 2.7848847664E+00, 6.7628145712E+00, 6.4773314694E-02, 6.2713991137E-02, 4.2251961139E-01],
	[6.8150000000E+03, 2.7874364194E+00, 6.7610452488E+00, 6.4918383327E-02, 6.2851118051E-02, 4.2271168575E-01],
	[6.8200000000E+03, 2.7899885365E+00, 6.7592776864E+00, 6.5063669761E-02, 6.2988437621E-02, 4.2290365594E-01],
	[6.8250000000E+03, 2.7925411173E+00, 6.7575118810E+00, 6.5209174164E-02, 6.3125949953E-02, 4.2309552225E-01],
	[6.8300000000E+03, 2.7950941616E+00, 6.7557478295E+00, 6.5354896701E-02, 6.3263655149E-02, 4.2328728500E-01],
	[6.8350000000E+03, 2.7976476691E+00, 6.7539855290E+00, 6.5500837539E-02, 6.3401553313E-02, 4.2347894446E-01],
	[6.8400000000E+03, 2.8002016395E+00, 6.7522249764E+00, 6.5646996844E-02, 6.3539644548E-02, 4.2367050095E-01],
	[6.8450000000E+03, 2.8027560726E+00, 6.7504661687E+00, 6.5793374781E-02, 6.3677928958E-02, 4.2386195474E-01],
	[6.8500000000E+03, 2.8053109682E+00, 6.7487091028E+00, 6.5939971518E-02, 6.3816406646E-02, 4.2405330615E-01],
	[6.8550000000E+03, 2.8078663260E+00, 6.7469537759E+00, 6.6086787219E-02, 6.3955077714E-02, 4.2424455545E-01],
	[6.8600000000E+03, 2.8104221458E+00, 6.7452001849E+00, 6.6233822052E-02, 6.4093942267E-02, 4.2443570295E-01],
	[6.8650000000E+03, 2.8129784272E+00, 6.7434483269E+00, 6.6381076183E-02, 6.4233000405E-02, 4.2462674894E-01],
	[6.8700000000E+03, 2.8155351701E+00, 6.7416981988E+00, 6.6528549777E-02, 6.4372252234E-02, 4.2481769370E-01],
	[6.8750000000E+03, 2.8180923742E+00, 6.7399497977E+00, 6.6676243001E-02, 6.4511697853E-02, 4.2500853753E-01],
	[6.8800000000E+03, 2.8206500392E+00, 6.7382031206E+00, 6.6824156021E-02, 6.4651337368E-02, 4.2519928073E-01],
	[6.8850000000E+03, 2.8232132484E+00, 6.7364787150E+00, 6.6972289003E-02, 6.4791175457E-02, 4.2538992357E-01],
	[6.8900000000E+03, 2.8257791014E+00, 6.7347647953E+00, 6.7120642113E-02, 6.4931209645E-02, 4.2558046635E-01],
	[6.8950000000E+03, 2.8283454224E+00, 6.7330525546E+00, 6.7269215518E-02, 6.5071438081E-02, 4.2577090935E-01],
	[6.9000000000E+03, 2.8309122113E+00, 6.7313419900E+00, 6.7418009384E-02, 6.5211860866E-02, 4.2596125287E-01],
	[6.9050000000E+03, 2.8334794678E+00, 6.7296330985E+00, 6.7567023876E-02, 6.5352478104E-02, 4.2615149719E-01],
	[6.9100000000E+03, 2.8360471915E+00, 6.7279258774E+00, 6.7716259162E-02, 6.5493289896E-02, 4.2634164260E-01],
	[6.9150000000E+03, 2.8386153823E+00, 6.7262203238E+00, 6.7865715406E-02, 6.5634296343E-02, 4.2653168939E-01],
	[6.9200000000E+03, 2.8411840400E+00, 6.7245164349E+00, 6.8015392776E-02, 6.5775497549E-02, 4.2672163783E-01],
	[6.9250000000E+03, 2.8437531642E+00, 6.7228142078E+00, 6.8165291438E-02, 6.5916893613E-02, 4.2691148821E-01],
	[6.9300000000E+03, 2.8463227547E+00, 6.7211136398E+00, 6.8315411558E-02, 6.6058484639E-02, 4.2710124082E-01],
	[6.9350000000E+03, 2.8488928113E+00, 6.7194147280E+00, 6.8465753301E-02, 6.6200270728E-02, 4.2729089594E-01],
	[6.9400000000E+03, 2.8514633336E+00, 6.7177174696E+00, 6.8616316835E-02, 6.6342251980E-02, 4.2748045386E-01],
	[6.9450000000E+03, 2.8540343215E+00, 6.7160218618E+00, 6.8767102325E-02, 6.6484428498E-02, 4.2766991485E-01],
	[6.9500000000E+03, 2.8566057748E+00, 6.7143279018E+00, 6.8918109938E-02, 6.6626800382E-02, 4.2785927920E-01],
	[6.9550000000E+03, 2.8591776930E+00, 6.7126355869E+00, 6.9069339839E-02, 6.6769367733E-02, 4.2804854718E-01],
	[6.9600000000E+03, 2.8617500761E+00, 6.7109449142E+00, 6.9220792196E-02, 6.6912130652E-02, 4.2823771908E-01],
	[6.9650000000E+03, 2.8643229237E+00, 6.7092558811E+00, 6.9372467174E-02, 6.7055089241E-02, 4.2842679518E-01],
	[6.9700000000E+03, 2.8668962356E+00, 6.7075684846E+00, 6.9524364940E-02, 6.7198243599E-02, 4.2861577576E-01],
	[6.9750000000E+03, 2.8694700116E+00, 6.7058827221E+00, 6.9676485659E-02, 6.7341593828E-02, 4.2880466109E-01],
	[6.9800000000E+03, 2.8720442514E+00, 6.7041985909E+00, 6.9828829499E-02, 6.7485140028E-02, 4.2899345145E-01],
	[6.9850000000E+03, 2.8746189547E+00, 6.7025160881E+00, 6.9981396624E-02, 6.7628882299E-02, 4.2918214712E-01],
	[6.9900000000E+03, 2.8771941213E+00, 6.7008352110E+00, 7.0134187202E-02, 6.7772820741E-02, 4.2937074838E-01],
	[6.9950000000E+03, 2.8797735090E+00, 6.6991712901E+00, 7.0287201399E-02, 6.7916959122E-02, 4.2955925550E-01],
	[7.0000000000E+03, 2.8823565199E+00, 6.6975218342E+00, 7.0440439381E-02, 6.8061296988E-02, 4.2974766876E-01],
	[7.0050000000E+03, 2.8849400008E+00, 6.6958739617E+00, 7.0595398089E-02, 6.8207228593E-02, 4.2993598843E-01],
	[7.0100000000E+03, 2.8875239514E+00, 6.6942276701E+00, 7.0750586437E-02, 6.8353361663E-02, 4.3012421479E-01],
	[7.0150000000E+03, 2.8901083715E+00, 6.6925829565E+00, 7.0906004600E-02, 6.8499696302E-02, 4.3031234812E-01],
	[7.0200000000E+03, 2.8926932609E+00, 6.6909398186E+00, 7.1061652754E-02, 6.8646232619E-02, 4.3050038867E-01],
	[7.0250000000E+03, 2.8952786192E+00, 6.6892982535E+00, 7.1217531074E-02, 6.8792970719E-02, 4.3068833673E-01],
	[7.0300000000E+03, 2.8978644464E+00, 6.6876582587E+00, 7.1373639735E-02, 6.8939910707E-02, 4.3087619258E-01],
	[7.0350000000E+03, 2.9004507420E+00, 6.6860198315E+00, 7.1529978913E-02, 6.9087052689E-02, 4.3106395647E-01],
	[7.0400000000E+03, 2.9030375059E+00, 6.6843829694E+00, 7.1686548783E-02, 6.9234396772E-02, 4.3125162868E-01],
	[7.0450000000E+03, 2.9056247378E+00, 6.6827476697E+00, 7.1843349522E-02, 6.9381943061E-02, 4.3143920952E-01],
	[7.0500000000E+03, 2.9082124374E+00, 6.6811139299E+00, 7.2000381303E-02, 6.9529691661E-02, 4.3162669928E-01],
	[7.0550000000E+03, 2.9108006046E+00, 6.6794817473E+00, 7.2157644304E-02, 6.9677642678E-02, 4.3181409819E-01],
	[7.0600000000E+03, 2.9133892390E+00, 6.6778511193E+00, 7.2315138698E-02, 6.9825796216E-02, 4.3200140651E-01],
	[7.0650000000E+03, 2.9159783404E+00, 6.6762220435E+00, 7.2472864662E-02, 6.9974152382E-02, 4.3218862449E-01],
	[7.0700000000E+03, 2.9185679086E+00, 6.6745945172E+00, 7.2630822372E-02, 7.0122711280E-02, 4.3237575237E-01],
	[7.0750000000E+03, 2.9211579434E+00, 6.6729685378E+00, 7.2789012002E-02, 7.0271473015E-02, 4.3256279039E-01],
	[7.0800000000E+03, 2.9237484444E+00, 6.6713441027E+00, 7.2947433728E-02, 7.0420437692E-02, 4.3274973881E-01],
	[7.0850000000E+03, 2.9263394115E+00, 6.6697212095E+00, 7.3106087726E-02, 7.0569605416E-02, 4.3293659786E-01],
	[7.0900000000E+03, 2.9289308443E+00, 6.6680998556E+00, 7.3264974171E-02, 7.0718976290E-02, 4.3312336779E-01],
	[7.0950000000E+03, 2.9315227427E+00, 6.6664800384E+00, 7.3424093239E-02, 7.0868550420E-02, 4.3331004885E-01],
	[7.1000000000E+03, 2.9341151064E+00, 6.6648617554E+00, 7.3583445105E-02, 7.1018327910E-02, 4.3349664127E-01],
	[7.1050000000E+03, 2.9367081373E+00, 6.6632458277E+00, 7.3743029946E-02, 7.1168309077E-02, 4.3368314530E-01],
	[7.1100000000E+03, 2.9393080826E+00, 6.6616576781E+00, 7.3902847935E-02, 7.1318500619E-02, 4.3386956119E-01],
	[7.1150000000E+03, 2.9419084995E+00, 6.6600710231E+00, 7.4062899250E-02, 7.1468895882E-02, 4.3405588916E-01],
	[7.1200000000E+03, 2.9445093879E+00, 6.6584858603E+00, 7.4223184064E-02, 7.1619494970E-02, 4.3424212947E-01],
	[7.1250000000E+03, 2.9471107474E+00, 6.6569021871E+00, 7.4383702556E-02, 7.1770297987E-02, 4.3442828236E-01],
	[7.1300000000E+03, 2.9497125778E+00, 6.6553200011E+00, 7.4544454898E-02, 7.1921305037E-02, 4.3461434806E-01],
	[7.1350000000E+03, 2.9523148788E+00, 6.6537392999E+00, 7.4705441268E-02, 7.2072516223E-02, 4.3480032682E-01],
	[7.1400000000E+03, 2.9549176503E+00, 6.6521600811E+00, 7.4866661841E-02, 7.2223931650E-02, 4.3498621887E-01],
	[7.1450000000E+03, 2.9575208920E+00, 6.6505823423E+00, 7.5028116793E-02, 7.2375551420E-02, 4.3517202445E-01],
	[7.1500000000E+03, 2.9601246035E+00, 6.6490060809E+00, 7.5189806298E-02, 7.2527375637E-02, 4.3535774380E-01],
	[7.1550000000E+03, 2.9627287848E+00, 6.6474312946E+00, 7.5351730533E-02, 7.2679404404E-02, 4.3554337716E-01],
	[7.1600000000E+03, 2.9653334355E+00, 6.6458579810E+00, 7.5513889674E-02, 7.2831637824E-02, 4.3572892477E-01],
	[7.1650000000E+03, 2.9679385554E+00, 6.6442861377E+00, 7.5676283895E-02, 7.2984076001E-02, 4.3591438685E-01],
	[7.1700000000E+03, 2.9705441442E+00, 6.6427157623E+00, 7.5838913373E-02, 7.3136719037E-02, 4.3609976366E-01],
	[7.1750000000E+03, 2.9731502018E+00, 6.6411468523E+00, 7.6001778283E-02, 7.3289567035E-02, 4.3628505542E-01],
	[7.1800000000E+03, 2.9757567278E+00, 6.6395794055E+00, 7.6164878802E-02, 7.3442620098E-02, 4.3647026237E-01],
	[7.1850000000E+03, 2.9783637221E+00, 6.6380134194E+00, 7.6328215103E-02, 7.3595878327E-02, 4.3665538475E-01],
	[7.1900000000E+03, 2.9809711843E+00, 6.6364488916E+00, 7.6491787364E-02, 7.3749341827E-02, 4.3684042278E-01],
	[7.1950000000E+03, 2.9835791143E+00, 6.6348858198E+00, 7.6655595760E-02, 7.3903010698E-02, 4.3702537671E-01],
	[7.2000000000E+03, 2.9861875118E+00, 6.6333242016E+00, 7.6819640467E-02, 7.4056885043E-02, 4.3721024676E-01],
	[7.2050000000E+03, 2.9887963766E+00, 6.6317640347E+00, 7.6983921659E-02, 7.4210964964E-02, 4.3739503317E-01],
	[7.2100000000E+03, 2.9914057083E+00, 6.6302053166E+00, 7.7148439514E-02, 7.4365250563E-02, 4.3757973617E-01],
	[7.2150000000E+03, 2.9940155069E+00, 6.6286480451E+00, 7.7313194207E-02, 7.4519741941E-02, 4.3776435600E-01],
	[7.2200000000E+03, 2.9966267639E+00, 6.6270962403E+00, 7.7478185913E-02, 7.4674440328E-02, 4.3794889288E-01],
	[7.2250000000E+03, 2.9992439099E+00, 6.6255678343E+00, 7.7643414808E-02, 7.4829350882E-02, 4.3813334705E-01],
	[7.2300000000E+03, 3.0018615287E+00, 6.6240408378E+00, 7.7808881068E-02, 7.4984467571E-02, 4.3831771874E-01],
	[7.2350000000E+03, 3.0044796200E+00, 6.6225152484E+00, 7.7974584868E-02, 7.5139790495E-02, 4.3850200818E-01],
	[7.2400000000E+03, 3.0070981837E+00, 6.6209910641E+00, 7.8140526385E-02, 7.5295319757E-02, 4.3868621559E-01],
	[7.2450000000E+03, 3.0097172194E+00, 6.6194682824E+00, 7.8306705794E-02, 7.5451055458E-02, 4.3887034121E-01],
	[7.2500000000E+03, 3.0123367270E+00, 6.6179469011E+00, 7.8473123271E-02, 7.5606997700E-02, 4.3905438526E-01],
	[7.2550000000E+03, 3.0149567061E+00, 6.6164269180E+00, 7.8639778991E-02, 7.5763146582E-02, 4.3923834799E-01],
	[7.2600000000E+03, 3.0175771567E+00, 6.6149083308E+00, 7.8806673131E-02, 7.5919502206E-02, 4.3942222960E-01],
	[7.2650000000E+03, 3.0201980783E+00, 6.6133911373E+00, 7.8973805866E-02, 7.6076064673E-02, 4.3960603033E-01],
	[7.2700000000E+03, 3.0228194708E+00, 6.6118753353E+00, 7.9141177372E-02, 7.6232834084E-02, 4.3978975042E-01],
	[7.2750000000E+03, 3.0254413340E+00, 6.6103609224E+00, 7.9308787825E-02, 7.6389810539E-02, 4.3997339008E-01],
	[7.2800000000E+03, 3.0280636675E+00, 6.6088478966E+00, 7.9476637400E-02, 7.6546994139E-02, 4.4015694954E-01],
	[7.2850000000E+03, 3.0306864712E+00, 6.6073362555E+00, 7.9644726274E-02, 7.6704384983E-02, 4.4034042902E-01],
	[7.2900000000E+03, 3.0333097449E+00, 6.6058259970E+00, 7.9813054622E-02, 7.6861983173E-02, 4.4052382876E-01],
	[7.2950000000E+03, 3.0359334882E+00, 6.6043171188E+00, 7.9981622620E-02, 7.7019788808E-02, 4.4070714898E-01],
	[7.3000000000E+03, 3.0385577010E+00, 6.6028096187E+00, 8.0150430443E-02, 7.7177801988E-02, 4.4089038990E-01],
	[7.3050000000E+03, 3.0411823829E+00, 6.6013034945E+00, 8.0319478269E-02, 7.7336022813E-02, 4.4107355175E-01],
	[7.3100000000E+03, 3.0438075339E+00, 6.5997987441E+00, 8.0488766272E-02, 7.7494451383E-02, 4.4125663475E-01],
	[7.3150000000E+03, 3.0464331535E+00, 6.5982953653E+00, 8.0658294628E-02, 7.7653087797E-02, 4.4143963912E-01],
	[7.3200000000E+03, 3.0490592417E+00, 6.5967933558E+00, 8.0828063513E-02, 7.7811932156E-02, 4.4162256510E-01],
	[7.3250000000E+03, 3.0516857981E+00, 6.5952927134E+00, 8.0998073104E-02, 7.7970984557E-02, 4.4180541289E-01],
	[7.3300000000E+03, 3.0543128226E+00, 6.5937934361E+00, 8.1168323576E-02, 7.8130245101E-02, 4.4198818273E-01],
	[7.3350000000E+03, 3.0569403148E+00, 6.5922955216E+00, 8.1338815104E-02, 7.8289713887E-02, 4.4217087483E-01],
	[7.3400000000E+03, 3.0595738974E+00, 6.5908216754E+00, 8.1509547865E-02, 7.8449397927E-02, 4.4235348942E-01],
	[7.3450000000E+03, 3.0622085041E+00, 6.5893513851E+00, 8.1680522035E-02, 7.8609291133E-02, 4.4253602672E-01],
	[7.3500000000E+03, 3.0648435844E+00, 6.5878824230E+00, 8.1851737789E-02, 7.8769392928E-02, 4.4271848694E-01],
	[7.3550000000E+03, 3.0674791379E+00, 6.5864147870E+00, 8.2023195304E-02, 7.8929703413E-02, 4.4290087031E-01],
	[7.3600000000E+03, 3.0701151644E+00, 6.5849484750E+00, 8.2194894755E-02, 7.9090222684E-02, 4.4308317706E-01],
	[7.3650000000E+03, 3.0727516637E+00, 6.5834834849E+00, 8.2366836319E-02, 7.9250950842E-02, 4.4326540739E-01],
	[7.3700000000E+03, 3.0753886355E+00, 6.5820198146E+00, 8.2539020170E-02, 7.9411887984E-02, 4.4344756153E-01],
	[7.3750000000E+03, 3.0780260796E+00, 6.5805574620E+00, 8.2711446486E-02, 7.9573034209E-02, 4.4362963970E-01],
	[7.3800000000E+03, 3.0806639959E+00, 6.5790964251E+00, 8.2884115442E-02, 7.9734389615E-02, 4.4381164211E-01],
	[7.3850000000E+03, 3.0833023839E+00, 6.5776367018E+00, 8.3057027214E-02, 7.9895954300E-02, 4.4399356898E-01],
	[7.3900000000E+03, 3.0859412436E+00, 6.5761782900E+00, 8.3230181978E-02, 8.0057728362E-02, 4.4417542054E-01],
	[7.3950000000E+03, 3.0885805746E+00, 6.5747211877E+00, 8.3403579910E-02, 8.0219711898E-02, 4.4435719699E-01],
	[7.4000000000E+03, 3.0912203767E+00, 6.5732653927E+00, 8.3577221186E-02, 8.0381905008E-02, 4.4453889856E-01],
	[7.4050000000E+03, 3.0938606498E+00, 6.5718109031E+00, 8.3751105982E-02, 8.0544307788E-02, 4.4472052546E-01],
	[7.4100000000E+03, 3.0965013935E+00, 6.5703577167E+00, 8.3925234474E-02, 8.0706920336E-02, 4.4490207791E-01],
	[7.4150000000E+03, 3.0991426077E+00, 6.5689058316E+00, 8.4099606838E-02, 8.0869742749E-02, 4.4508355612E-01],
	[7.4200000000E+03, 3.1017842920E+00, 6.5674552457E+00, 8.4274223249E-02, 8.1032775124E-02, 4.4526496031E-01],
	[7.4250000000E+03, 3.1044264463E+00, 6.5660059569E+00, 8.4449083885E-02, 8.1196017559E-02, 4.4544629070E-01],
	[7.4300000000E+03, 3.1070690704E+00, 6.5645579633E+00, 8.4624188920E-02, 8.1359470150E-02, 4.4562754749E-01],
	[7.4350000000E+03, 3.1097121639E+00, 6.5631112627E+00, 8.4799538532E-02, 8.1523132995E-02, 4.4580873091E-01],
	[7.4400000000E+03, 3.1123557267E+00, 6.5616658533E+00, 8.4975132896E-02, 8.1687006190E-02, 4.4598984117E-01],
	[7.4450000000E+03, 3.1149997586E+00, 6.5602217329E+00, 8.5150972187E-02, 8.1851089831E-02, 4.4617087847E-01],
	[7.4500000000E+03, 3.1176442592E+00, 6.5587788995E+00, 8.5327056583E-02, 8.2015384016E-02, 4.4635184305E-01],
	[7.4550000000E+03, 3.1202909639E+00, 6.5573443518E+00, 8.5503386259E-02, 8.2179891144E-02, 4.4653273510E-01],
	[7.4600000000E+03, 3.1229423354E+00, 6.5559279911E+00, 8.5679961391E-02, 8.2344614609E-02, 4.4671355484E-01],
	[7.4650000000E+03, 3.1255941812E+00, 6.5545128850E+00, 8.5856782155E-02, 8.2509548958E-02, 4.4689430248E-01],
	[7.4700000000E+03, 3.1282465009E+00, 6.5530990315E+00, 8.6033848727E-02, 8.2674694289E-02, 4.4707497823E-01],
	[7.4750000000E+03, 3.1308992943E+00, 6.5516864288E+00, 8.6211161284E-02, 8.2840050696E-02, 4.4725558232E-01],
	[7.4800000000E+03, 3.1335525613E+00, 6.5502750748E+00, 8.6388720002E-02, 8.3005618276E-02, 4.4743611494E-01],
	[7.4850000000E+03, 3.1362063015E+00, 6.5488649676E+00, 8.6566525056E-02, 8.3171397125E-02, 4.4761657630E-01],
	[7.4900000000E+03, 3.1388605147E+00, 6.5474561054E+00, 8.6744576623E-02, 8.3337387339E-02, 4.4779696663E-01],
	[7.4950000000E+03, 3.1415152007E+00, 6.5460484861E+00, 8.6922874879E-02, 8.3503589012E-02, 4.4797728613E-01],
	[7.5000000000E+03, 3.1441703594E+00, 6.5446421079E+00, 8.7101419999E-02, 8.3670002242E-02, 4.4815753500E-01],
	[7.5050000000E+03, 3.1468259903E+00, 6.5432369688E+00, 8.7280212161E-02, 8.3836627121E-02, 4.4833771346E-01],
	[7.5100000000E+03, 3.1494820934E+00, 6.5418330668E+00, 8.7459251539E-02, 8.4003463747E-02, 4.4851782172E-01],
	[7.5150000000E+03, 3.1521386683E+00, 6.5404304002E+00, 8.7638538311E-02, 8.4170512214E-02, 4.4869785999E-01],
	[7.5200000000E+03, 3.1547957149E+00, 6.5390289670E+00, 8.7818072653E-02, 8.4337772618E-02, 4.4887782847E-01],
	[7.5250000000E+03, 3.1574532329E+00, 6.5376287653E+00, 8.7997854740E-02, 8.4505245052E-02, 4.4905772738E-01],
	[7.5300000000E+03, 3.1601112220E+00, 6.5362297931E+00, 8.8177884749E-02, 8.4672929612E-02, 4.4923755691E-01],
	[7.5350000000E+03, 3.1627696822E+00, 6.5348320486E+00, 8.8358162856E-02, 8.4840826392E-02, 4.4941731727E-01],
	[7.5400000000E+03, 3.1654286130E+00, 6.5334355300E+00, 8.8538689236E-02, 8.5008935486E-02, 4.4959700863E-01],
	[7.5450000000E+03, 3.1680880144E+00, 6.5320402352E+00, 8.8719464068E-02, 8.5177256990E-02, 4.4977663116E-01],
	[7.5500000000E+03, 3.1707478861E+00, 6.5306461625E+00, 8.8900487525E-02, 8.5345790997E-02, 4.4995618505E-01],
	[7.5550000000E+03, 3.1734082277E+00, 6.5292533099E+00, 8.9081759785E-02, 8.5514537601E-02, 4.5013567048E-01],
	[7.5600000000E+03, 3.1760690392E+00, 6.5278616756E+00, 8.9263281024E-02, 8.5683496897E-02, 4.5031508762E-01],
	[7.5650000000E+03, 3.1787303203E+00, 6.5264712577E+00, 8.9445051419E-02, 8.5852668977E-02, 4.5049443664E-01],
	[7.5700000000E+03, 3.1813920708E+00, 6.5250820543E+00, 8.9627071144E-02, 8.6022053936E-02, 4.5067371774E-01],
	[7.5750000000E+03, 3.1840559639E+00, 6.5237008136E+00, 8.9809340377E-02, 8.6191654272E-02, 4.5085293107E-01],
	[7.5800000000E+03, 3.1867243428E+00, 6.5223369541E+00, 8.9991859293E-02, 8.6361473475E-02, 4.5103207683E-01],
	[7.5850000000E+03, 3.1893931962E+00, 6.5209742788E+00, 9.0174628070E-02, 8.6531505891E-02, 4.5121115518E-01],
	[7.5900000000E+03, 3.1920625238E+00, 6.5196127858E+00, 9.0357646882E-02, 8.6701751614E-02, 4.5139016630E-01],
	[7.5950000000E+03, 3.1947323254E+00, 6.5182524735E+00, 9.0540915907E-02, 8.6872210736E-02, 4.5156911037E-01],
	[7.6000000000E+03, 3.1974026007E+00, 6.5168933400E+00, 9.0724435321E-02, 8.7042883351E-02, 4.5174798756E-01],
	[7.6050000000E+03, 3.2000733496E+00, 6.5155353834E+00, 9.0908205300E-02, 8.7213769551E-02, 4.5192679805E-01],
	[7.6100000000E+03, 3.2027445718E+00, 6.5141786020E+00, 9.1092226020E-02, 8.7384869431E-02, 4.5210554201E-01],
	[7.6150000000E+03, 3.2054162670E+00, 6.5128229941E+00, 9.1276497657E-02, 8.7556183082E-02, 4.5228421962E-01],
	[7.6200000000E+03, 3.2080884351E+00, 6.5114685578E+00, 9.1461020388E-02, 8.7727710597E-02, 4.5246283105E-01],
	[7.6250000000E+03, 3.2107610758E+00, 6.5101152913E+00, 9.1645794389E-02, 8.7899452068E-02, 4.5264137647E-01],
	[7.6300000000E+03, 3.2134341890E+00, 6.5087631929E+00, 9.1830819837E-02, 8.8071407589E-02, 4.5281985607E-01],
	[7.6350000000E+03, 3.2161077743E+00, 6.5074122607E+00, 9.2016096907E-02, 8.8243577251E-02, 4.5299827000E-01],
	[7.6400000000E+03, 3.2187818315E+00, 6.5060624931E+00, 9.2201625776E-02, 8.8415961146E-02, 4.5317661846E-01],
	[7.6450000000E+03, 3.2214563604E+00, 6.5047138883E+00, 9.2387406621E-02, 8.8588559367E-02, 4.5335490160E-01],
	[7.6500000000E+03, 3.2241313609E+00, 6.5033664445E+00, 9.2573439617E-02, 8.8761372005E-02, 4.5353311960E-01],
	[7.6550000000E+03, 3.2268068326E+00, 6.5020201599E+00, 9.2759724941E-02, 8.8934399152E-02, 4.5371127264E-01],
	[7.6600000000E+03, 3.2294827753E+00, 6.5006750328E+00, 9.2946262769E-02, 8.9107640900E-02, 4.5388936088E-01],
	[7.6650000000E+03, 3.2321591889E+00, 6.4993310614E+00, 9.3133053277E-02, 8.9281097340E-02, 4.5406738451E-01],
	[7.6700000000E+03, 3.2348360731E+00, 6.4979882440E+00, 9.3320096643E-02, 8.9454768563E-02, 4.5424534368E-01],
	[7.6750000000E+03, 3.2375134276E+00, 6.4966465789E+00, 9.3507393042E-02, 8.9628654661E-02, 4.5442323857E-01],
	[7.6800000000E+03, 3.2401912523E+00, 6.4953060643E+00, 9.3694942651E-02, 8.9802755725E-02, 4.5460106936E-01],
	[7.6850000000E+03, 3.2428695469E+00, 6.4939666985E+00, 9.3882745645E-02, 8.9977071845E-02, 4.5477883621E-01],
	[7.6900000000E+03, 3.2455483112E+00, 6.4926284797E+00, 9.4070802203E-02, 9.0151603113E-02, 4.5495653930E-01],
	[7.6950000000E+03, 3.2482275450E+00, 6.4912914062E+00, 9.4259112498E-02, 9.0326349620E-02, 4.5513417879E-01],
	[7.7000000000E+03, 3.2509121990E+00, 6.4899754660E+00, 9.4447676709E-02, 9.0501319179E-02, 4.5531175486E-01],
	[7.7050000000E+03, 3.2535978194E+00, 6.4886626325E+00, 9.4636495012E-02, 9.0676504978E-02, 4.5548926767E-01],
	[7.7100000000E+03, 3.2562839140E+00, 6.4873509159E+00, 9.4825567583E-02, 9.0851906342E-02, 4.5566671740E-01],
	[7.7150000000E+03, 3.2589704826E+00, 6.4860403146E+00, 9.5014894598E-02, 9.1027523362E-02, 4.5584410422E-01],
	[7.7200000000E+03, 3.2616575251E+00, 6.4847308269E+00, 9.5204476234E-02, 9.1203356127E-02, 4.5602142829E-01],
	[7.7250000000E+03, 3.2643450411E+00, 6.4834224512E+00, 9.5394312667E-02, 9.1379404728E-02, 4.5619868978E-01],
	[7.7300000000E+03, 3.2670330305E+00, 6.4821151858E+00, 9.5584404074E-02, 9.1555669254E-02, 4.5637588886E-01],
	[7.7350000000E+03, 3.2697214931E+00, 6.4808090290E+00, 9.5774750631E-02, 9.1732149797E-02, 4.5655302571E-01],
	[7.7400000000E+03, 3.2724104285E+00, 6.4795039792E+00, 9.5965352514E-02, 9.1908846444E-02, 4.5673010048E-01],
	[7.7450000000E+03, 3.2750998367E+00, 6.4782000347E+00, 9.6156209900E-02, 9.2085759287E-02, 4.5690711335E-01],
	[7.7500000000E+03, 3.2777897173E+00, 6.4768971939E+00, 9.6347322966E-02, 9.2262888414E-02, 4.5708406449E-01],
	[7.7550000000E+03, 3.2804800702E+00, 6.4755954552E+00, 9.6538691888E-02, 9.2440233916E-02, 4.5726095406E-01],
	[7.7600000000E+03, 3.2831708951E+00, 6.4742948168E+00, 9.6730316842E-02, 9.2617795880E-02, 4.5743778223E-01],
	[7.7650000000E+03, 3.2858621918E+00, 6.4729952772E+00, 9.6922198006E-02, 9.2795574397E-02, 4.5761454916E-01],
	[7.7700000000E+03, 3.2885539600E+00, 6.4716968347E+00, 9.7114335554E-02, 9.2973569555E-02, 4.5779125503E-01],
	[7.7750000000E+03, 3.2912461997E+00, 6.4703994877E+00, 9.7306729664E-02, 9.3151781443E-02, 4.5796790001E-01],
	[7.7800000000E+03, 3.2939389105E+00, 6.4691032345E+00, 9.7499380513E-02, 9.3330210149E-02, 4.5814448425E-01],
	[7.7850000000E+03, 3.2966320922E+00, 6.4678080736E+00, 9.7692288276E-02, 9.3508855764E-02, 4.5832100792E-01],
	[7.7900000000E+03, 3.2993257446E+00, 6.4665140033E+00, 9.7885453131E-02, 9.3687718374E-02, 4.5849747120E-01],
	[7.7950000000E+03, 3.3020198675E+00, 6.4652210220E+00, 9.8078875254E-02, 9.3866798068E-02, 4.5867387424E-01],
	[7.8000000000E+03, 3.3047144606E+00, 6.4639291281E+00, 9.8272554821E-02, 9.4046094935E-02, 4.5885021721E-01],
	[7.8050000000E+03, 3.3074095238E+00, 6.4626383200E+00, 9.8466492009E-02, 9.4225609062E-02, 4.5902650028E-01],
	[7.8100000000E+03, 3.3101050568E+00, 6.4613485960E+00, 9.8660686995E-02, 9.4405340537E-02, 4.5920272362E-01],
	[7.8150000000E+03, 3.3128010595E+00, 6.4600599546E+00, 9.8855139955E-02, 9.4585289449E-02, 4.5937888738E-01],
	[7.8200000000E+03, 3.3154982187E+00, 6.4587751815E+00, 9.9049851065E-02, 9.4765457046E-02, 4.5955499173E-01],
	[7.8250000000E+03, 3.3182003565E+00, 6.4575097524E+00, 9.9244820502E-02, 9.4945849902E-02, 4.5973103684E-01],
	[7.8300000000E+03, 3.3209029684E+00, 6.4562453794E+00, 9.9440048443E-02, 9.5126460514E-02, 4.5990702287E-01],
	[7.8350000000E+03, 3.3236060541E+00, 6.4549820607E+00, 9.9635535065E-02, 9.5307288968E-02, 4.6008294998E-01],
	[7.8400000000E+03, 3.3263096135E+00, 6.4537197950E+00, 9.9831280543E-02, 9.5488335352E-02, 4.6025881835E-01],
	[7.8450000000E+03, 3.3290136463E+00, 6.4524585807E+00, 1.0002728505E-01, 9.5669599753E-02, 4.6043462813E-01],
	[7.8500000000E+03, 3.3317181523E+00, 6.4511984161E+00, 1.0022354878E-01, 9.5851082258E-02, 4.6061037948E-01],
	[7.8550000000E+03, 3.3344231313E+00, 6.4499392998E+00, 1.0042007188E-01, 9.6032782954E-02, 4.6078607257E-01],
	[7.8600000000E+03, 3.3371285831E+00, 6.4486812303E+00, 1.0061685456E-01, 9.6214701929E-02, 4.6096170757E-01],
	[7.8650000000E+03, 3.3398345074E+00, 6.4474242060E+00, 1.0081389697E-01, 9.6396839268E-02, 4.6113728463E-01],
	[7.8700000000E+03, 3.3425409041E+00, 6.4461682253E+00, 1.0101119929E-01, 9.6579195058E-02, 4.6131280393E-01],
	[7.8750000000E+03, 3.3452477728E+00, 6.4449132868E+00, 1.0120876172E-01, 9.6761769386E-02, 4.6148826561E-01],
	[7.8800000000E+03, 3.3479551135E+00, 6.4436593888E+00, 1.0140658441E-01, 9.6944562338E-02, 4.6166366984E-01],
	[7.8850000000E+03, 3.3506629259E+00, 6.4424065300E+00, 1.0160466754E-01, 9.7127574000E-02, 4.6183901679E-01],
	[7.8900000000E+03, 3.3533712097E+00, 6.4411547087E+00, 1.0180301130E-01, 9.7310804458E-02, 4.6201430662E-01],
	[7.8950000000E+03, 3.3560799647E+00, 6.4399039235E+00, 1.0200161586E-01, 9.7494253799E-02, 4.6218953949E-01],
	[7.9000000000E+03, 3.3587891908E+00, 6.4386541729E+00, 1.0220048140E-01, 9.7677922107E-02, 4.6236471556E-01],
	[7.9050000000E+03, 3.3614988877E+00, 6.4374054552E+00, 1.0239960809E-01, 9.7861809468E-02, 4.6253983499E-01],
	[7.9100000000E+03, 3.3642090552E+00, 6.4361577691E+00, 1.0259899611E-01, 9.8045915969E-02, 4.6271489794E-01],
	[7.9150000000E+03, 3.3669196931E+00, 6.4349111130E+00, 1.0279864563E-01, 9.8230241694E-02, 4.6288990457E-01],
	[7.9200000000E+03, 3.3696308011E+00, 6.4336654855E+00, 1.0299855684E-01, 9.8414786728E-02, 4.6306485505E-01],
	[7.9250000000E+03, 3.3723423791E+00, 6.4324208849E+00, 1.0319872991E-01, 9.8599551158E-02, 4.6323974954E-01],
	[7.9300000000E+03, 3.3750544269E+00, 6.4311773099E+00, 1.0339916501E-01, 9.8784535066E-02, 4.6341458819E-01],
	[7.9350000000E+03, 3.3777669441E+00, 6.4299347589E+00, 1.0359986233E-01, 9.8969738540E-02, 4.6358937116E-01],
	[7.9400000000E+03, 3.3804799307E+00, 6.4286932305E+00, 1.0380082203E-01, 9.9155161662E-02, 4.6376409863E-01],
	[7.9450000000E+03, 3.3831933864E+00, 6.4274527232E+00, 1.0400204431E-01, 9.9340804518E-02, 4.6393877073E-01],
	[7.9500000000E+03, 3.3859120446E+00, 6.4262325175E+00, 1.0420352932E-01, 9.9526675908E-02, 4.6411338764E-01],
	[7.9550000000E+03, 3.3886313932E+00, 6.4250141935E+00, 1.0440527726E-01, 9.9712767655E-02, 4.6428794952E-01],
	[7.9600000000E+03, 3.3913512151E+00, 6.4237968657E+00, 1.0460728829E-01, 9.9899079447E-02, 4.6446245651E-01],
	[7.9650000000E+03, 3.3940715100E+00, 6.4225805328E+00, 1.0480956260E-01, 1.0008561137E-01, 4.6463690879E-01],
	[7.9700000000E+03, 3.3967922777E+00, 6.4213651933E+00, 1.0501210036E-01, 1.0027236350E-01, 4.6481130652E-01],
	[7.9750000000E+03, 3.3995135181E+00, 6.4201508458E+00, 1.0521490174E-01, 1.0045933593E-01, 4.6498564984E-01],
	[7.9800000000E+03, 3.4022352309E+00, 6.4189374888E+00, 1.0541796693E-01, 1.0064652874E-01, 4.6515993892E-01],
	[7.9850000000E+03, 3.4049574160E+00, 6.4177251209E+00, 1.0562129610E-01, 1.0083394201E-01, 4.6533417391E-01],
	[7.9900000000E+03, 3.4076800730E+00, 6.4165137408E+00, 1.0582488942E-01, 1.0102157584E-01, 4.6550835494E-01],
	[7.9950000000E+03, 3.4104032018E+00, 6.4153033468E+00, 1.0602874708E-01, 1.0120943029E-01, 4.6568248215E-01],
	[8.0000000000E+03, 3.4131268021E+00, 6.4140939377E+00, 1.0623286925E-01, 1.0139750546E-01, 4.6585655565E-01],
	[8.0050000000E+03, 3.4158508738E+00, 6.4128855121E+00, 1.0643835717E-01, 1.0158680440E-01, 4.6603057558E-01],
	[8.0100000000E+03, 3.4185754167E+00, 6.4116780684E+00, 1.0664411353E-01, 1.0177632720E-01, 4.6620454206E-01],
	[8.0150000000E+03, 3.4213004304E+00, 6.4104716054E+00, 1.0685013850E-01, 1.0196607396E-01, 4.6637845523E-01],
	[8.0200000000E+03, 3.4240259149E+00, 6.4092661215E+00, 1.0705643227E-01, 1.0215604474E-01, 4.6655231521E-01],
	[8.0250000000E+03, 3.4267518699E+00, 6.4080616155E+00, 1.0726299502E-01, 1.0234623965E-01, 4.6672612214E-01],
	[8.0300000000E+03, 3.4294782952E+00, 6.4068580858E+00, 1.0746982693E-01, 1.0253665876E-01, 4.6689987613E-01],
	[8.0350000000E+03, 3.4322051906E+00, 6.4056555312E+00, 1.0767692818E-01, 1.0272730216E-01, 4.6707357732E-01],
	[8.0400000000E+03, 3.4349325558E+00, 6.4044539501E+00, 1.0788429895E-01, 1.0291816994E-01, 4.6724722583E-01],
	[8.0450000000E+03, 3.4376603907E+00, 6.4032533412E+00, 1.0809193944E-01, 1.0310926218E-01, 4.6742082180E-01],
	[8.0500000000E+03, 3.4403886950E+00, 6.4020537032E+00, 1.0829984981E-01, 1.0330057896E-01, 4.6759436535E-01],
	[8.0550000000E+03, 3.4431174685E+00, 6.4008550346E+00, 1.0850803026E-01, 1.0349212037E-01, 4.6776785660E-01],
	[8.0600000000E+03, 3.4458467111E+00, 6.3996573340E+00, 1.0871648096E-01, 1.0368388650E-01, 4.6794129569E-01],
	[8.0650000000E+03, 3.4485764225E+00, 6.3984606001E+00, 1.0892520210E-01, 1.0387587744E-01, 4.6811468274E-01],
	[8.0700000000E+03, 3.4513066025E+00, 6.3972648314E+00, 1.0913419385E-01, 1.0406809325E-01, 4.6828801788E-01],
	[8.0750000000E+03, 3.4540390403E+00, 6.3960772669E+00, 1.0934345640E-01, 1.0426053759E-01, 4.6846130123E-01],
	[8.0800000000E+03, 3.4567749351E+00, 6.3949027318E+00, 1.0955298994E-01, 1.0445321295E-01, 4.6863453293E-01],
	[8.0850000000E+03, 3.4595113025E+00, 6.3937291387E+00, 1.0976279464E-01, 1.0464611351E-01, 4.6880771310E-01],
	[8.0900000000E+03, 3.4622481423E+00, 6.3925564864E+00, 1.0997287068E-01, 1.0483923935E-01, 4.6898084186E-01],
	[8.0950000000E+03, 3.4649854542E+00, 6.3913847735E+00, 1.1018321826E-01, 1.0503259056E-01, 4.6915391935E-01],
	[8.1000000000E+03, 3.4677232380E+00, 6.3902139987E+00, 1.1039383755E-01, 1.0522616721E-01, 4.6932694568E-01],
	[8.1050000000E+03, 3.4704614936E+00, 6.3890441607E+00, 1.1060472872E-01, 1.0541996940E-01, 4.6949992099E-01],
	[8.1100000000E+03, 3.4732002207E+00, 6.3878752580E+00, 1.1081589198E-01, 1.0561399721E-01, 4.6967284540E-01],
	[8.1150000000E+03, 3.4759394191E+00, 6.3867072894E+00, 1.1102732749E-01, 1.0580825071E-01, 4.6984571904E-01],
	[8.1200000000E+03, 3.4786790886E+00, 6.3855402536E+00, 1.1123903544E-01, 1.0600273000E-01, 4.7001854202E-01],
	[8.1250000000E+03, 3.4814192290E+00, 6.3843741493E+00, 1.1145101601E-01, 1.0619743515E-01, 4.7019131449E-01],
	[8.1300000000E+03, 3.4841598400E+00, 6.3832089751E+00, 1.1166326939E-01, 1.0639236625E-01, 4.7036403656E-01],
	[8.1350000000E+03, 3.4869009216E+00, 6.3820447297E+00, 1.1187579575E-01, 1.0658752339E-01, 4.7053670835E-01],
	[8.1400000000E+03, 3.4896424734E+00, 6.3808814118E+00, 1.1208859528E-01, 1.0678290663E-01, 4.7070933000E-01],
	[8.1450000000E+03, 3.4923844953E+00, 6.3797190201E+00, 1.1230166817E-01, 1.0697851608E-01, 4.7088190163E-01],
	[8.1500000000E+03, 3.4951269870E+00, 6.3785575534E+00, 1.1251501458E-01, 1.0717435181E-01, 4.7105442336E-01],
	[8.1550000000E+03, 3.4978699484E+00, 6.3773970102E+00, 1.1272863471E-01, 1.0737041390E-01, 4.7122689532E-01],
	[8.1600000000E+03, 3.5006133792E+00, 6.3762373893E+00, 1.1294252874E-01, 1.0756670243E-01, 4.7139931764E-01],
	[8.1650000000E+03, 3.5033572792E+00, 6.3750786894E+00, 1.1315669685E-01, 1.0776321749E-01, 4.7157169043E-01],
	[8.1700000000E+03, 3.5061016483E+00, 6.3739209092E+00, 1.1337113922E-01, 1.0795995916E-01, 4.7174401382E-01],
	[8.1750000000E+03, 3.5088464861E+00, 6.3727640475E+00, 1.1358585603E-01, 1.0815692752E-01, 4.7191628794E-01],
	[8.1800000000E+03, 3.5115917926E+00, 6.3716081028E+00, 1.1380084747E-01, 1.0835412265E-01, 4.7208851291E-01],
	[8.1850000000E+03, 3.5143375675E+00, 6.3704530740E+00, 1.1401611372E-01, 1.0855154463E-01, 4.7226068886E-01],
	[8.1900000000E+03, 3.5170838105E+00, 6.3692989597E+00, 1.1423165496E-01, 1.0874919355E-01, 4.7243281590E-01],
	[8.1950000000E+03, 3.5198305216E+00, 6.3681457587E+00, 1.1444747137E-01, 1.0894706949E-01, 4.7260489417E-01],
	[8.2000000000E+03, 3.5225777004E+00, 6.3669934697E+00, 1.1466356314E-01, 1.0914517252E-01, 4.7277692378E-01],
	[8.2050000000E+03, 3.5253271247E+00, 6.3658491505E+00, 1.1487993045E-01, 1.0934350652E-01, 4.7294890487E-01],
	[8.2100000000E+03, 3.5280799021E+00, 6.3647171740E+00, 1.1509657348E-01, 1.0954207398E-01, 4.7312083755E-01],
	[8.2150000000E+03, 3.5308331512E+00, 6.3635860877E+00, 1.1531349241E-01, 1.0974086883E-01, 4.7329272194E-01],
	[8.2200000000E+03, 3.5335868716E+00, 6.3624558904E+00, 1.1553068743E-01, 1.0993989117E-01, 4.7346455818E-01],
	[8.2250000000E+03, 3.5363410632E+00, 6.3613265810E+00, 1.1574815872E-01, 1.1013914107E-01, 4.7363634638E-01],
	[8.2300000000E+03, 3.5390957257E+00, 6.3601981581E+00, 1.1596590645E-01, 1.1033861861E-01, 4.7380808666E-01],
	[8.2350000000E+03, 3.5418508591E+00, 6.3590706206E+00, 1.1618393082E-01, 1.1053832387E-01, 4.7397977916E-01],
	[8.2400000000E+03, 3.5446064630E+00, 6.3579439671E+00, 1.1640223200E-01, 1.1073825694E-01, 4.7415142399E-01],
	[8.2450000000E+03, 3.5473625373E+00, 6.3568181966E+00, 1.1662081018E-01, 1.1093841788E-01, 4.7432302127E-01],
	[8.2500000000E+03, 3.5501190817E+00, 6.3556933076E+00, 1.1683966554E-01, 1.1113880680E-01, 4.7449457113E-01],
	[8.2550000000E+03, 3.5528760961E+00, 6.3545692991E+00, 1.1705879826E-01, 1.1133942375E-01, 4.7466607369E-01],
	[8.2600000000E+03, 3.5556335802E+00, 6.3534461698E+00, 1.1727820853E-01, 1.1154026883E-01, 4.7483752908E-01],
	[8.2650000000E+03, 3.5583915338E+00, 6.3523239185E+00, 1.1749789652E-01, 1.1174134211E-01, 4.7500893740E-01],
	[8.2700000000E+03, 3.5611499568E+00, 6.3512025440E+00, 1.1771786243E-01, 1.1194264366E-01, 4.7518029880E-01],
	[8.2750000000E+03, 3.5639088490E+00, 6.3500820449E+00, 1.1793810642E-01, 1.1214417358E-01, 4.7535161339E-01],
	[8.2800000000E+03, 3.5666682100E+00, 6.3489624203E+00, 1.1815862869E-01, 1.1234593194E-01, 4.7552288128E-01],
	[8.2850000000E+03, 3.5694280398E+00, 6.3478436687E+00, 1.1837942942E-01, 1.1254791882E-01, 4.7569410261E-01],
	[8.2900000000E+03, 3.5721883381E+00, 6.3467257891E+00, 1.1860050878E-01, 1.1275013429E-01, 4.7586527750E-01],
	[8.2950000000E+03, 3.5749491048E+00, 6.3456087802E+00, 1.1882186697E-01, 1.1295257844E-01, 4.7603640606E-01],
	[8.3000000000E+03, 3.5777103395E+00, 6.3444926408E+00, 1.1904350416E-01, 1.1315525134E-01, 4.7620748842E-01],
	[8.3050000000E+03, 3.5804720422E+00, 6.3433773697E+00, 1.1926542054E-01, 1.1335815307E-01, 4.7637852469E-01],
	[8.3100000000E+03, 3.5832342126E+00, 6.3422629658E+00, 1.1948761629E-01, 1.1356128372E-01, 4.7654951501E-01],
	[8.3150000000E+03, 3.5859968504E+00, 6.3411494277E+00, 1.1971009159E-01, 1.1376464335E-01, 4.7672045949E-01],
	[8.3200000000E+03, 3.5887599556E+00, 6.3400367544E+00, 1.1993284663E-01, 1.1396823205E-01, 4.7689135826E-01],
	[8.3250000000E+03, 3.5915235279E+00, 6.3389249446E+00, 1.2015588158E-01, 1.1417204989E-01, 4.7706221142E-01],
	[8.3300000000E+03, 3.5942875671E+00, 6.3378139972E+00, 1.2037919663E-01, 1.1437609695E-01, 4.7723301912E-01],
	[8.3350000000E+03, 3.5970520730E+00, 6.3367039109E+00, 1.2060279197E-01, 1.1458037331E-01, 4.7740378146E-01],
	[8.3400000000E+03, 3.5998214561E+00, 6.3356118600E+00, 1.2082666776E-01, 1.1478488917E-01, 4.7757449856E-01],
	[8.3450000000E+03, 3.6025914473E+00, 6.3345211871E+00, 1.2105082421E-01, 1.1498963486E-01, 4.7774517055E-01],
	[8.3500000000E+03, 3.6053619088E+00, 6.3334313551E+00, 1.2127526149E-01, 1.1519461015E-01, 4.7791579755E-01],
	[8.3550000000E+03, 3.6081328405E+00, 6.3323423628E+00, 1.2149997978E-01, 1.1539981510E-01, 4.7808637968E-01],
	[8.3600000000E+03, 3.6109042421E+00, 6.3312542091E+00, 1.2172497926E-01, 1.1560524980E-01, 4.7825691705E-01],
	[8.3650000000E+03, 3.6136761135E+00, 6.3301668928E+00, 1.2195026012E-01, 1.1581091433E-01, 4.7842740980E-01],
	[8.3700000000E+03, 3.6164484545E+00, 6.3290804128E+00, 1.2217582254E-01, 1.1601680876E-01, 4.7859785803E-01],
	[8.3750000000E+03, 3.6192212648E+00, 6.3279947680E+00, 1.2240166671E-01, 1.1622293316E-01, 4.7876826187E-01],
	[8.3800000000E+03, 3.6219945443E+00, 6.3269099572E+00, 1.2262779280E-01, 1.1642928762E-01, 4.7893862144E-01],
	[8.3850000000E+03, 3.6247682927E+00, 6.3258259792E+00, 1.2285420100E-01, 1.1663587221E-01, 4.7910893686E-01],
	[8.3900000000E+03, 3.6275425099E+00, 6.3247428330E+00, 1.2308089149E-01, 1.1684268701E-01, 4.7927920825E-01],
	[8.3950000000E+03, 3.6303171956E+00, 6.3236605174E+00, 1.2330786445E-01, 1.1704973209E-01, 4.7944943572E-01],
	[8.4000000000E+03, 3.6330923497E+00, 6.3225790313E+00, 1.2353512007E-01, 1.1725700752E-01, 4.7961961940E-01],
	[8.4050000000E+03, 3.6358679720E+00, 6.3214983735E+00, 1.2376265853E-01, 1.1746451339E-01, 4.7978975941E-01],
	[8.4100000000E+03, 3.6386440622E+00, 6.3204185429E+00, 1.2399048001E-01, 1.1767224977E-01, 4.7995985586E-01],
	[8.4150000000E+03, 3.6414206201E+00, 6.3193395384E+00, 1.2421858469E-01, 1.1788021673E-01, 4.8012990888E-01],
	[8.4200000000E+03, 3.6441976456E+00, 6.3182613589E+00, 1.2444697276E-01, 1.1808841435E-01, 4.8029991856E-01],
	[8.4250000000E+03, 3.6469751385E+00, 6.3171840033E+00, 1.2467564440E-01, 1.1829684271E-01, 4.8046988499E-01],
	[8.4300000000E+03, 3.6497530985E+00, 6.3161074703E+00, 1.2490459980E-01, 1.1850550188E-01, 4.8063980826E-01],
	[8.4350000000E+03, 3.6525315255E+00, 6.3150317590E+00, 1.2513383913E-01, 1.1871439193E-01, 4.8080968845E-01],
	[8.4400000000E+03, 3.6553104193E+00, 6.3139568682E+00, 1.2536336257E-01, 1.1892351294E-01, 4.8097952568E-01],
	[8.4450000000E+03, 3.6580897796E+00, 6.3128827968E+00, 1.2559317032E-01, 1.1913286498E-01, 4.8114932002E-01],
	[8.4500000000E+03, 3.6608696063E+00, 6.3118095436E+00, 1.2582326255E-01, 1.1934244814E-01, 4.8131907157E-01],
	[8.4550000000E+03, 3.6636498991E+00, 6.3107371077E+00, 1.2605363945E-01, 1.1955226247E-01, 4.8148878043E-01],
	[8.4600000000E+03, 3.6664306580E+00, 6.3096654878E+00, 1.2628430119E-01, 1.1976230806E-01, 4.8165844667E-01],
	[8.4650000000E+03, 3.6692118825E+00, 6.3085946829E+00, 1.2651524797E-01, 1.1997258498E-01, 4.8182807041E-01],
	[8.4700000000E+03, 3.6719941614E+00, 6.3075269440E+00, 1.2674647996E-01, 1.2018309475E-01, 4.8199765173E-01],
	[8.4750000000E+03, 3.6747807512E+00, 6.3064747120E+00, 1.2697799735E-01, 1.2039384549E-01, 4.8216719071E-01],
	[8.4800000000E+03, 3.6775678103E+00, 6.3054232759E+00, 1.2720980032E-01, 1.2060482784E-01, 4.8233668747E-01],
	[8.4850000000E+03, 3.6803553385E+00, 6.3043726347E+00, 1.2744188906E-01, 1.2081604189E-01, 4.8250614207E-01],
	[8.4900000000E+03, 3.6831433355E+00, 6.3033227874E+00, 1.2767432706E-01, 1.2102754460E-01, 4.8267555463E-01],
	[8.4950000000E+03, 3.6859318013E+00, 6.3022737328E+00, 1.2790705517E-01, 1.2123928271E-01, 4.8284492522E-01],
	[8.5000000000E+03, 3.6887207355E+00, 6.3012254699E+00, 1.2814006982E-01, 1.2145125291E-01, 4.8301425395E-01],
	[8.5050000000E+03, 3.6915101381E+00, 6.3001779977E+00, 1.2837337118E-01, 1.2166345527E-01, 4.8318354090E-01],
	[8.5100000000E+03, 3.6943000087E+00, 6.2991313151E+00, 1.2860695946E-01, 1.2187588988E-01, 4.8335278617E-01],
	[8.5150000000E+03, 3.6970903472E+00, 6.2980854210E+00, 1.2884083481E-01, 1.2208855680E-01, 4.8352198984E-01],
	[8.5200000000E+03, 3.6998811535E+00, 6.2970403144E+00, 1.2907499744E-01, 1.2230145610E-01, 4.8369115201E-01],
	[8.5250000000E+03, 3.7026724273E+00, 6.2959959942E+00, 1.2930944752E-01, 1.2251458787E-01, 4.8386027278E-01],
	[8.5300000000E+03, 3.7054641684E+00, 6.2949524594E+00, 1.2954418524E-01, 1.2272795216E-01, 4.8402935222E-01],
	[8.5350000000E+03, 3.7082563766E+00, 6.2939097089E+00, 1.2977921078E-01, 1.2294154906E-01, 4.8419839044E-01],
	[8.5400000000E+03, 3.7110490517E+00, 6.2928677416E+00, 1.3001452432E-01, 1.2315537863E-01, 4.8436738752E-01],
	[8.5450000000E+03, 3.7138421936E+00, 6.2918265566E+00, 1.3025012604E-01, 1.2336944095E-01, 4.8453634356E-01],
	[8.5500000000E+03, 3.7166358020E+00, 6.2907861528E+00, 1.3048601614E-01, 1.2358373609E-01, 4.8470525865E-01],
	[8.5550000000E+03, 3.7194298767E+00, 6.2897465291E+00, 1.3072219479E-01, 1.2379826412E-01, 4.8487413287E-01],
	[8.5600000000E+03, 3.7222244176E+00, 6.2887076844E+00, 1.3095866217E-01, 1.2401302512E-01, 4.8504296633E-01],
	[8.5650000000E+03, 3.7250194244E+00, 6.2876696179E+00, 1.3119541848E-01, 1.2422801914E-01, 4.8521175911E-01],
	[8.5700000000E+03, 3.7278148970E+00, 6.2866323283E+00, 1.3143246388E-01, 1.2444324627E-01, 4.8538051129E-01],
	[8.5750000000E+03, 3.7306108352E+00, 6.2855958148E+00, 1.3166979858E-01, 1.2465870658E-01, 4.8554922299E-01],
	[8.5800000000E+03, 3.7334072387E+00, 6.2845600761E+00, 1.3190742274E-01, 1.2487440014E-01, 4.8571789427E-01],
	[8.5850000000E+03, 3.7362041074E+00, 6.2835251115E+00, 1.3214533655E-01, 1.2509032701E-01, 4.8588652525E-01],
	[8.5900000000E+03, 3.7390014411E+00, 6.2824909197E+00, 1.3238354020E-01, 1.2530648727E-01, 4.8605511599E-01],
	[8.5950000000E+03, 3.7417992396E+00, 6.2814574997E+00, 1.3262203387E-01, 1.2552288099E-01, 4.8622366661E-01],
	[8.6000000000E+03, 3.7445975026E+00, 6.2804248506E+00, 1.3286081775E-01, 1.2573950824E-01, 4.8639217718E-01],
	[8.6050000000E+03, 3.7473962301E+00, 6.2793929714E+00, 1.3309989201E-01, 1.2595636909E-01, 4.8656064780E-01],
	[8.6100000000E+03, 3.7501991518E+00, 6.2783758658E+00, 1.3333925684E-01, 1.2617347348E-01, 4.8672907856E-01],
	[8.6150000000E+03, 3.7530031290E+00, 6.2773617210E+00, 1.3357891242E-01, 1.2639081324E-01, 4.8689746955E-01],
	[8.6200000000E+03, 3.7558075740E+00, 6.2763483283E+00, 1.3381885894E-01, 1.2660838687E-01, 4.8706582086E-01],
	[8.6250000000E+03, 3.7586124865E+00, 6.2753356868E+00, 1.3405909657E-01, 1.2682619445E-01, 4.8723413258E-01],
	[8.6300000000E+03, 3.7614178664E+00, 6.2743237953E+00, 1.3429962552E-01, 1.2704423604E-01, 4.8740240481E-01],
	[8.6350000000E+03, 3.7642237135E+00, 6.2733126530E+00, 1.3454044594E-01, 1.2726251172E-01, 4.8757063762E-01],
	[8.6400000000E+03, 3.7670300276E+00, 6.2723022588E+00, 1.3478155804E-01, 1.2748102156E-01, 4.8773883112E-01],
	[8.6450000000E+03, 3.7698368084E+00, 6.2712926117E+00, 1.3502296199E-01, 1.2769976561E-01, 4.8790698539E-01],
	[8.6500000000E+03, 3.7726440559E+00, 6.2702837108E+00, 1.3526465798E-01, 1.2791874397E-01, 4.8807510052E-01],
	[8.6550000000E+03, 3.7754517698E+00, 6.2692755551E+00, 1.3550664619E-01, 1.2813795668E-01, 4.8824317660E-01],
	[8.6600000000E+03, 3.7782599499E+00, 6.2682681435E+00, 1.3574892680E-01, 1.2835740382E-01, 4.8841121373E-01],
	[8.6650000000E+03, 3.7810685961E+00, 6.2672614752E+00, 1.3599150000E-01, 1.2857708547E-01, 4.8857921199E-01],
	[8.6700000000E+03, 3.7838777081E+00, 6.2662555492E+00, 1.3623436597E-01, 1.2879700168E-01, 4.8874717147E-01],
	[8.6750000000E+03, 3.7866872857E+00, 6.2652503644E+00, 1.3647752489E-01, 1.2901715253E-01, 4.8891509227E-01],
	[8.6800000000E+03, 3.7894973289E+00, 6.2642459199E+00, 1.3672097695E-01, 1.2923753808E-01, 4.8908297446E-01],
	[8.6850000000E+03, 3.7923078372E+00, 6.2632422147E+00, 1.3696472234E-01, 1.2945815841E-01, 4.8925081816E-01],
	[8.6900000000E+03, 3.7951188107E+00, 6.2622392479E+00, 1.3720876122E-01, 1.2967901358E-01, 4.8941862343E-01],
	[8.6950000000E+03, 3.7979302490E+00, 6.2612370184E+00, 1.3745309380E-01, 1.2990010365E-01, 4.8958639038E-01],
	[8.7000000000E+03, 3.8007421520E+00, 6.2602355254E+00, 1.3769772025E-01, 1.3012142870E-01, 4.8975411909E-01],
	[8.7050000000E+03, 3.8035545196E+00, 6.2592347678E+00, 1.3794264075E-01, 1.3034298880E-01, 4.8992180965E-01],
	[8.7100000000E+03, 3.8063673514E+00, 6.2582347448E+00, 1.3818785549E-01, 1.3056478400E-01, 4.9008946215E-01],
	[8.7150000000E+03, 3.8091806474E+00, 6.2572354553E+00, 1.3843336465E-01, 1.3078681439E-01, 4.9025707669E-01],
	[8.7200000000E+03, 3.8119944073E+00, 6.2562368983E+00, 1.3867916842E-01, 1.3100908001E-01, 4.9042465334E-01],
	[8.7250000000E+03, 3.8148086309E+00, 6.2552390730E+00, 1.3892526698E-01, 1.3123158095E-01, 4.9059219221E-01],
	[8.7300000000E+03, 3.8176233181E+00, 6.2542419783E+00, 1.3917166051E-01, 1.3145431727E-01, 4.9075969338E-01],
	[8.7350000000E+03, 3.8204384687E+00, 6.2532456134E+00, 1.3941834920E-01, 1.3167728903E-01, 4.9092715693E-01],
	[8.7400000000E+03, 3.8232540825E+00, 6.2522499772E+00, 1.3966533323E-01, 1.3190049631E-01, 4.9109458297E-01],
	[8.7450000000E+03, 3.8260708141E+00, 6.2512574862E+00, 1.3991261279E-01, 1.3212394102E-01, 4.9126197157E-01],
	[8.7500000000E+03, 3.8288915557E+00, 6.2502787995E+00, 1.4016018805E-01, 1.3234763148E-01, 4.9142932283E-01],
	[8.7550000000E+03, 3.8317127637E+00, 6.2493008250E+00, 1.4040805920E-01, 1.3257155773E-01, 4.9159663684E-01],
	[8.7600000000E+03, 3.8345344379E+00, 6.2483235617E+00, 1.4065622642E-01, 1.3279571982E-01, 4.9176391368E-01],
	[8.7650000000E+03, 3.8373565781E+00, 6.2473470088E+00, 1.4090468991E-01, 1.3302011782E-01, 4.9193115345E-01],
	[8.7700000000E+03, 3.8401791841E+00, 6.2463711653E+00, 1.4115344983E-01, 1.3324475180E-01, 4.9209835623E-01],
	[8.7750000000E+03, 3.8430022558E+00, 6.2453960303E+00, 1.4140250638E-01, 1.3346962182E-01, 4.9226552212E-01],
	[8.7800000000E+03, 3.8458257930E+00, 6.2444216029E+00, 1.4165185974E-01, 1.3369472794E-01, 4.9243265120E-01],
	[8.7850000000E+03, 3.8486497954E+00, 6.2434478821E+00, 1.4190151010E-01, 1.3392007024E-01, 4.9259974356E-01],
	[8.7900000000E+03, 3.8514742628E+00, 6.2424748671E+00, 1.4215145763E-01, 1.3414564877E-01, 4.9276679929E-01],
	[8.7950000000E+03, 3.8542991952E+00, 6.2415025569E+00, 1.4240170252E-01, 1.3437146361E-01, 4.9293381848E-01],
	[8.8000000000E+03, 3.8571245923E+00, 6.2405309506E+00, 1.4265224495E-01, 1.3459751481E-01, 4.9310080121E-01],
	[8.8050000000E+03, 3.8599504538E+00, 6.2395600473E+00, 1.4290308511E-01, 1.3482380245E-01, 4.9326774759E-01],
	[8.8100000000E+03, 3.8627767797E+00, 6.2385898461E+00, 1.4315422319E-01, 1.3505032658E-01, 4.9343465769E-01],
	[8.8150000000E+03, 3.8656035698E+00, 6.2376203462E+00, 1.4340565935E-01, 1.3527708727E-01, 4.9360153160E-01],
	[8.8200000000E+03, 3.8684308238E+00, 6.2366515465E+00, 1.4365739380E-01, 1.3550408459E-01, 4.9376836942E-01],
	[8.8250000000E+03, 3.8712585415E+00, 6.2356834462E+00, 1.4390942671E-01, 1.3573131860E-01, 4.9393517123E-01],
	[8.8300000000E+03, 3.8740867228E+00, 6.2347160444E+00, 1.4416175826E-01, 1.3595878936E-01, 4.9410193710E-01],
	[8.8350000000E+03, 3.8769153675E+00, 6.2337493403E+00, 1.4441438865E-01, 1.3618649693E-01, 4.9426866710E-01],
	[8.8400000000E+03, 3.8797444755E+00, 6.2327833328E+00, 1.4466731805E-01, 1.3641444139E-01, 4.9443536128E-01],
	[8.8450000000E+03, 3.8825740464E+00, 6.2318180211E+00, 1.4492054664E-01, 1.3664262278E-01, 4.9460201971E-01],
	[8.8500000000E+03, 3.8854040801E+00, 6.2308534043E+00, 1.4517407462E-01, 1.3687104119E-01, 4.9476864246E-01],
	[8.8550000000E+03, 3.8882345766E+00, 6.2298894815E+00, 1.4542790216E-01, 1.3709969666E-01, 4.9493522959E-01],
	[8.8600000000E+03, 3.8910655354E+00, 6.2289262518E+00, 1.4568202945E-01, 1.3732858927E-01, 4.9510178117E-01],
	[8.8650000000E+03, 3.8938969566E+00, 6.2279637144E+00, 1.4593645668E-01, 1.3755771907E-01, 4.9526829727E-01],
	[8.8700000000E+03, 3.8967288398E+00, 6.2270018683E+00, 1.4619118402E-01, 1.3778708613E-01, 4.9543477795E-01],
	[8.8750000000E+03, 3.8995611849E+00, 6.2260407127E+00, 1.4644621166E-01, 1.3801669052E-01, 4.9560122327E-01],
	[8.8800000000E+03, 3.9023939918E+00, 6.2250802467E+00, 1.4670153978E-01, 1.3824653228E-01, 4.9576763331E-01],
	[8.8850000000E+03, 3.9052272680E+00, 6.2241204978E+00, 1.4695716857E-01, 1.3847661151E-01, 4.9593400812E-01],
	[8.8900000000E+03, 3.9080650817E+00, 6.2231762149E+00, 1.4721309822E-01, 1.3870694073E-01, 4.9610034778E-01],
	[8.8950000000E+03, 3.9109033601E+00, 6.2222326061E+00, 1.4746932890E-01, 1.3893750759E-01, 4.9626665235E-01],
	[8.9000000000E+03, 3.9137421032E+00, 6.2212896706E+00, 1.4772586079E-01, 1.3916831215E-01, 4.9643292189E-01],
	[8.9050000000E+03, 3.9165813107E+00, 6.2203474073E+00, 1.4798269409E-01, 1.3939935447E-01, 4.9659915647E-01],
	[8.9100000000E+03, 3.9194209824E+00, 6.2194058156E+00, 1.4823982898E-01, 1.3963063462E-01, 4.9676535615E-01],
	[8.9150000000E+03, 3.9222611182E+00, 6.2184648946E+00, 1.4849726564E-01, 1.3986215266E-01, 4.9693152101E-01],
	[8.9200000000E+03, 3.9251017179E+00, 6.2175246434E+00, 1.4875500426E-01, 1.4009390864E-01, 4.9709765110E-01],
	[8.9250000000E+03, 3.9279427812E+00, 6.2165850611E+00, 1.4901304501E-01, 1.4032590264E-01, 4.9726374650E-01],
	[8.9300000000E+03, 3.9307843081E+00, 6.2156461469E+00, 1.4927138808E-01, 1.4055813470E-01, 4.9742980726E-01],
	[8.9350000000E+03, 3.9336262982E+00, 6.2147078999E+00, 1.4953003366E-01, 1.4079060490E-01, 4.9759583346E-01],
	[8.9400000000E+03, 3.9364687515E+00, 6.2137703194E+00, 1.4978898194E-01, 1.4102331329E-01, 4.9776182515E-01],
	[8.9450000000E+03, 3.9393116678E+00, 6.2128334044E+00, 1.5004823308E-01, 1.4125625993E-01, 4.9792778241E-01],
	[8.9500000000E+03, 3.9421550468E+00, 6.2118971541E+00, 1.5030778729E-01, 1.4148944488E-01, 4.9809370530E-01],
	[8.9550000000E+03, 3.9449988884E+00, 6.2109615677E+00, 1.5056764473E-01, 1.4172286821E-01, 4.9825959388E-01],
	[8.9600000000E+03, 3.9478431924E+00, 6.2100266443E+00, 1.5082780560E-01, 1.4195652997E-01, 4.9842544823E-01],
	[8.9650000000E+03, 3.9506879586E+00, 6.2090923831E+00, 1.5108827009E-01, 1.4219043023E-01, 4.9859126840E-01],
	[8.9700000000E+03, 3.9535331868E+00, 6.2081587833E+00, 1.5134903836E-01, 1.4242456904E-01, 4.9875705445E-01],
	[8.9750000000E+03, 3.9563788770E+00, 6.2072258440E+00, 1.5161011062E-01, 1.4265894646E-01, 4.9892280647E-01],
	[8.9800000000E+03, 3.9592250287E+00, 6.2062935643E+00, 1.5187148703E-01, 1.4289356256E-01, 4.9908852451E-01],
	[8.9850000000E+03, 3.9620716420E+00, 6.2053619435E+00, 1.5213316779E-01, 1.4312841738E-01, 4.9925420863E-01],
	[8.9900000000E+03, 3.9649187166E+00, 6.2044309807E+00, 1.5239515309E-01, 1.4336351100E-01, 4.9941985891E-01],
	[8.9950000000E+03, 3.9677662522E+00, 6.2035006751E+00, 1.5265744309E-01, 1.4359884347E-01, 4.9958547540E-01],
	[9.0000000000E+03, 3.9706142489E+00, 6.2025710259E+00, 1.5292003799E-01, 1.4383441485E-01, 4.9975105817E-01],
	[9.0050000000E+03, 3.9734627063E+00, 6.2016420322E+00, 1.5318442899E-01, 1.4407154408E-01, 4.9991660730E-01],
	[9.0100000000E+03, 3.9763116242E+00, 6.2007136932E+00, 1.5344912957E-01, 1.4430891573E-01, 5.0008212283E-01],
	[9.0150000000E+03, 3.9791610026E+00, 6.1997860081E+00, 1.5371413990E-01, 1.4454652986E-01, 5.0024760485E-01],
	[9.0200000000E+03, 3.9820108412E+00, 6.1988589760E+00, 1.5397946019E-01, 1.4478438653E-01, 5.0041305341E-01],
	[9.0250000000E+03, 3.9848611398E+00, 6.1979325961E+00, 1.5424509062E-01, 1.4502248579E-01, 5.0057846857E-01],
	[9.0300000000E+03, 3.9877134731E+00, 6.1970124592E+00, 1.5451103139E-01, 1.4526083287E-01, 5.0074385041E-01],
	[9.0350000000E+03, 3.9905686837E+00, 6.1961015405E+00, 1.5477728267E-01, 1.4549943064E-01, 5.0090919899E-01],
	[9.0400000000E+03, 3.9934243573E+00, 6.1951912595E+00, 1.5504384467E-01, 1.4573827126E-01, 5.0107451438E-01],
	[9.0450000000E+03, 3.9962804937E+00, 6.1942816154E+00, 1.5531071757E-01, 1.4597735479E-01, 5.0123979663E-01],
	[9.0500000000E+03, 3.9991370928E+00, 6.1933726075E+00, 1.5557790156E-01, 1.4621668129E-01, 5.0140504581E-01],
	[9.0550000000E+03, 4.0019941543E+00, 6.1924642350E+00, 1.5584539683E-01, 1.4645625083E-01, 5.0157026200E-01],
	[9.0600000000E+03, 4.0048516781E+00, 6.1915564970E+00, 1.5611320357E-01, 1.4669606347E-01, 5.0173544525E-01],
	[9.0650000000E+03, 4.0077096640E+00, 6.1906493929E+00, 1.5638132197E-01, 1.4693611925E-01, 5.0190059563E-01],
	[9.0700000000E+03, 4.0105681118E+00, 6.1897429216E+00, 1.5664975222E-01, 1.4717641825E-01, 5.0206571321E-01],
	[9.0750000000E+03, 4.0134270213E+00, 6.1888370826E+00, 1.5691849452E-01, 1.4741696052E-01, 5.0223079804E-01],
	[9.0800000000E+03, 4.0162863924E+00, 6.1879318750E+00, 1.5718754904E-01, 1.4765774612E-01, 5.0239585020E-01],
	[9.0850000000E+03, 4.0191462248E+00, 6.1870272980E+00, 1.5745691598E-01, 1.4789877511E-01, 5.0256086975E-01],
	[9.0900000000E+03, 4.0220065184E+00, 6.1861233509E+00, 1.5772659553E-01, 1.4814004755E-01, 5.0272585676E-01],
	[9.0950000000E+03, 4.0248672731E+00, 6.1852200327E+00, 1.5799658787E-01, 1.4838156350E-01, 5.0289081128E-01],
	[9.1000000000E+03, 4.0277284886E+00, 6.1843173429E+00, 1.5826689321E-01, 1.4862332302E-01, 5.0305573339E-01],
	[9.1050000000E+03, 4.0305901647E+00, 6.1834152805E+00, 1.5853751173E-01, 1.4886532616E-01, 5.0322062315E-01],
	[9.1100000000E+03, 4.0334523013E+00, 6.1825138448E+00, 1.5880844361E-01, 1.4910757298E-01, 5.0338548062E-01],
	[9.1150000000E+03, 4.0363148982E+00, 6.1816130350E+00, 1.5907968905E-01, 1.4935006355E-01, 5.0355030588E-01],
	[9.1200000000E+03, 4.0391779552E+00, 6.1807128504E+00, 1.5935124824E-01, 1.4959279791E-01, 5.0371509897E-01],
	[9.1250000000E+03, 4.0420414721E+00, 6.1798132902E+00, 1.5962312137E-01, 1.4983577614E-01, 5.0387985998E-01],
	[9.1300000000E+03, 4.0449054488E+00, 6.1789143535E+00, 1.5989530862E-01, 1.5007899827E-01, 5.0404458896E-01],
	[9.1350000000E+03, 4.0477698851E+00, 6.1780160397E+00, 1.6016781020E-01, 1.5032246438E-01, 5.0420928598E-01],
	[9.1400000000E+03, 4.0506347808E+00, 6.1771183479E+00, 1.6044062628E-01, 1.5056617453E-01, 5.0437395111E-01],
	[9.1450000000E+03, 4.0535001358E+00, 6.1762212774E+00, 1.6071375705E-01, 1.5081012875E-01, 5.0453858440E-01],
	[9.1500000000E+03, 4.0563659497E+00, 6.1753248274E+00, 1.6098720272E-01, 1.5105432713E-01, 5.0470318593E-01],
	[9.1550000000E+03, 4.0592322226E+00, 6.1744289971E+00, 1.6126096346E-01, 1.5129876970E-01, 5.0486775576E-01],
	[9.1600000000E+03, 4.0620989541E+00, 6.1735337858E+00, 1.6153503947E-01, 1.5154345653E-01, 5.0503229395E-01],
	[9.1650000000E+03, 4.0649661442E+00, 6.1726391927E+00, 1.6180943094E-01, 1.5178838768E-01, 5.0519680057E-01],
	[9.1700000000E+03, 4.0678337926E+00, 6.1717452170E+00, 1.6208413805E-01, 1.5203356320E-01, 5.0536127568E-01],
	[9.1750000000E+03, 4.0707031919E+00, 6.1708563040E+00, 1.6235916100E-01, 1.5227898766E-01, 5.0552571935E-01],
	[9.1800000000E+03, 4.0735757137E+00, 6.1699771544E+00, 1.6263449998E-01, 1.5252466595E-01, 5.0569013164E-01],
	[9.1850000000E+03, 4.0764486966E+00, 6.1690986086E+00, 1.6291015517E-01, 1.5277058886E-01, 5.0585451262E-01],
	[9.1900000000E+03, 4.0793221407E+00, 6.1682206659E+00, 1.6318612677E-01, 1.5301675644E-01, 5.0601886235E-01],
	[9.1950000000E+03, 4.0821960456E+00, 6.1673433256E+00, 1.6346241497E-01, 1.5326316875E-01, 5.0618318090E-01],
	[9.2000000000E+03, 4.0850704112E+00, 6.1664665869E+00, 1.6373901995E-01, 1.5350982584E-01, 5.0634746834E-01],
	[9.2050000000E+03, 4.0879452373E+00, 6.1655904491E+00, 1.6401594191E-01, 1.5375672777E-01, 5.0651172471E-01],
	[9.2100000000E+03, 4.0908205238E+00, 6.1647149115E+00, 1.6429318104E-01, 1.5400387460E-01, 5.0667595011E-01],
	[9.2150000000E+03, 4.0936962704E+00, 6.1638399733E+00, 1.6457073753E-01, 1.5425126637E-01, 5.0684014457E-01],
	[9.2200000000E+03, 4.0965724771E+00, 6.1629656338E+00, 1.6484861156E-01, 1.5449890314E-01, 5.0700430818E-01],
	[9.2250000000E+03, 4.0994491435E+00, 6.1620918922E+00, 1.6512680333E-01, 1.5474678498E-01, 5.0716844095E-01],
	[9.2300000000E+03, 4.1023262696E+00, 6.1612187479E+00, 1.6540531302E-01, 1.5499491193E-01, 5.0733254295E-01],
	[9.2350000000E+03, 4.1052038552E+00, 6.1603462000E+00, 1.6568414083E-01, 1.5524328404E-01, 5.0749661421E-01],
	[9.2400000000E+03, 4.1080819001E+00, 6.1594742479E+00, 1.6596328695E-01, 1.5549190138E-01, 5.0766065478E-01],
	[9.2450000000E+03, 4.1109604041E+00, 6.1586028908E+00, 1.6624275157E-01, 1.5574076400E-01, 5.0782466471E-01],
	[9.2500000000E+03, 4.1138393670E+00, 6.1577321280E+00, 1.6652253488E-01, 1.5598987194E-01, 5.0798864404E-01],
	[9.2550000000E+03, 4.1167187887E+00, 6.1568619588E+00, 1.6680263706E-01, 1.5623922527E-01, 5.0815259281E-01],
	[9.2600000000E+03, 4.1195986690E+00, 6.1559923824E+00, 1.6708305831E-01, 1.5648882404E-01, 5.0831651107E-01],
	[9.2650000000E+03, 4.1224790077E+00, 6.1551233982E+00, 1.6736379881E-01, 1.5673866830E-01, 5.0848039888E-01],
	[9.2700000000E+03, 4.1253598046E+00, 6.1542550053E+00, 1.6764485877E-01, 1.5698875811E-01, 5.0864425626E-01],
	[9.2750000000E+03, 4.1282410597E+00, 6.1533872031E+00, 1.6792623836E-01, 1.5723909351E-01, 5.0880808327E-01],
	[9.2800000000E+03, 4.1311227726E+00, 6.1525199909E+00, 1.6820793778E-01, 1.5748967457E-01, 5.0897187995E-01],
	[9.2850000000E+03, 4.1340049432E+00, 6.1516533680E+00, 1.6848995722E-01, 1.5774050132E-01, 5.0913564636E-01],
	[9.2900000000E+03, 4.1368875714E+00, 6.1507873335E+00, 1.6877229687E-01, 1.5799157384E-01, 5.0929938253E-01],
	[9.2950000000E+03, 4.1397706570E+00, 6.1499218869E+00, 1.6905495692E-01, 1.5824289217E-01, 5.0946308850E-01],
	[9.3000000000E+03, 4.1426541997E+00, 6.1490570274E+00, 1.6933793755E-01, 1.5849445635E-01, 5.0962676434E-01],
	[9.3050000000E+03, 4.1455381995E+00, 6.1481927542E+00, 1.6962123896E-01, 1.5874626645E-01, 5.0979041007E-01],
	[9.3100000000E+03, 4.1484226562E+00, 6.1473290667E+00, 1.6990486135E-01, 1.5899832252E-01, 5.0995402575E-01],
	[9.3150000000E+03, 4.1513075695E+00, 6.1464659642E+00, 1.7018880489E-01, 1.5925062461E-01, 5.1011761143E-01],
	[9.3200000000E+03, 4.1541929393E+00, 6.1456034459E+00, 1.7047306978E-01, 1.5950317276E-01, 5.1028116714E-01],
	[9.3250000000E+03, 4.1570818735E+00, 6.1447518410E+00, 1.7075765622E-01, 1.5975597861E-01, 5.1044469293E-01],
	[9.3300000000E+03, 4.1599720873E+00, 6.1439035364E+00, 1.7104256438E-01, 1.6000903376E-01, 5.1060818886E-01],
	[9.3350000000E+03, 4.1628627605E+00, 6.1430558032E+00, 1.7132779446E-01, 1.6026233521E-01, 5.1077165495E-01],
	[9.3400000000E+03, 4.1657538929E+00, 6.1422086409E+00, 1.7161334666E-01, 1.6051588302E-01, 5.1093509127E-01],
	[9.3450000000E+03, 4.1686454842E+00, 6.1413620487E+00, 1.7189922115E-01, 1.6076967723E-01, 5.1109849786E-01],
	[9.3500000000E+03, 4.1715375343E+00, 6.1405160260E+00, 1.7218541814E-01, 1.6102371790E-01, 5.1126187475E-01],
	[9.3550000000E+03, 4.1744300431E+00, 6.1396705720E+00, 1.7247193780E-01, 1.6127800508E-01, 5.1142522200E-01],
	[9.3600000000E+03, 4.1773230104E+00, 6.1388256861E+00, 1.7275878034E-01, 1.6153253881E-01, 5.1158853965E-01],
	[9.3650000000E+03, 4.1802164360E+00, 6.1379813675E+00, 1.7304594595E-01, 1.6178731916E-01, 5.1175182776E-01],
	[9.3700000000E+03, 4.1831103197E+00, 6.1371376157E+00, 1.7333343480E-01, 1.6204234616E-01, 5.1191508635E-01],
	[9.3750000000E+03, 4.1860046614E+00, 6.1362944298E+00, 1.7362124710E-01, 1.6229761988E-01, 5.1207831549E-01],
	[9.3800000000E+03, 4.1888994609E+00, 6.1354518093E+00, 1.7390938303E-01, 1.6255314035E-01, 5.1224151521E-01],
	[9.3850000000E+03, 4.1917947180E+00, 6.1346097534E+00, 1.7419784278E-01, 1.6280890764E-01, 5.1240468556E-01],
	[9.3900000000E+03, 4.1946904325E+00, 6.1337682616E+00, 1.7448662655E-01, 1.6306492178E-01, 5.1256782658E-01],
	[9.3950000000E+03, 4.1975866043E+00, 6.1329273330E+00, 1.7477573452E-01, 1.6332118283E-01, 5.1273093833E-01],
	[9.4000000000E+03, 4.2004832332E+00, 6.1320869670E+00, 1.7506516689E-01, 1.6357769084E-01, 5.1289402085E-01],
	[9.4050000000E+03, 4.2033803191E+00, 6.1312471630E+00, 1.7535492384E-01, 1.6383444586E-01, 5.1305707417E-01],
	[9.4100000000E+03, 4.2062778617E+00, 6.1304079202E+00, 1.7564500557E-01, 1.6409144793E-01, 5.1322009836E-01],
	[9.4150000000E+03, 4.2091758609E+00, 6.1295692381E+00, 1.7593541226E-01, 1.6434869711E-01, 5.1338309346E-01],
	[9.4200000000E+03, 4.2120743165E+00, 6.1287311158E+00, 1.7622614411E-01, 1.6460619344E-01, 5.1354605950E-01],
	[9.4250000000E+03, 4.2149732283E+00, 6.1278935528E+00, 1.7651720131E-01, 1.6486393698E-01, 5.1370899654E-01],
	[9.4300000000E+03, 4.2178725963E+00, 6.1270565485E+00, 1.7680858404E-01, 1.6512192777E-01, 5.1387190462E-01],
	[9.4350000000E+03, 4.2207724201E+00, 6.1262201020E+00, 1.7710029250E-01, 1.6538016585E-01, 5.1403478379E-01],
	[9.4400000000E+03, 4.2236726997E+00, 6.1253842127E+00, 1.7739232688E-01, 1.6563865128E-01, 5.1419763409E-01],
	[9.4450000000E+03, 4.2265734349E+00, 6.1245488801E+00, 1.7768468737E-01, 1.6589738411E-01, 5.1436045557E-01],
	[9.4500000000E+03, 4.2294746254E+00, 6.1237141034E+00, 1.7797737415E-01, 1.6615636438E-01, 5.1452324827E-01],
	[9.4550000000E+03, 4.2323762712E+00, 6.1228798819E+00, 1.7827038743E-01, 1.6641559214E-01, 5.1468601225E-01],
	[9.4600000000E+03, 4.2352783721E+00, 6.1220462150E+00, 1.7856372739E-01, 1.6667506744E-01, 5.1484874754E-01],
	[9.4650000000E+03, 4.2381809278E+00, 6.1212131020E+00, 1.7885739421E-01, 1.6693479032E-01, 5.1501145419E-01],
	[9.4700000000E+03, 4.2410839383E+00, 6.1203805424E+00, 1.7915138810E-01, 1.6719476084E-01, 5.1517413225E-01],
	[9.4750000000E+03, 4.2439904458E+00, 6.1195583096E+00, 1.7944570924E-01, 1.6745499109E-01, 5.1533678177E-01],
	[9.4800000000E+03, 4.2468982691E+00, 6.1187393779E+00, 1.7974035782E-01, 1.6771547254E-01, 5.1549940278E-01],
	[9.4850000000E+03, 4.2498065500E+00, 6.1179209876E+00, 1.8003533404E-01, 1.6797620184E-01, 5.1566199534E-01],
	[9.4900000000E+03, 4.2527152882E+00, 6.1171031379E+00, 1.8033072411E-01, 1.6823725393E-01, 5.1582455949E-01],
	[9.4950000000E+03, 4.2556244835E+00, 6.1162858283E+00, 1.8062649219E-01, 1.6849859745E-01, 5.1598709528E-01],
	[9.5000000000E+03, 4.2585341358E+00, 6.1154690580E+00, 1.8092258890E-01, 1.6876018928E-01, 5.1614960274E-01],
	[9.5050000000E+03, 4.2614442450E+00, 6.1146528265E+00, 1.8121901442E-01, 1.6902202948E-01, 5.1631208194E-01],
	[9.5100000000E+03, 4.2643548108E+00, 6.1138371332E+00, 1.8151576894E-01, 1.6928411809E-01, 5.1647453291E-01],
	[9.5150000000E+03, 4.2672658331E+00, 6.1130219773E+00, 1.8181285266E-01, 1.6954645515E-01, 5.1663695570E-01],
	[9.5200000000E+03, 4.2701773117E+00, 6.1122073582E+00, 1.8211026576E-01, 1.6980904071E-01, 5.1679935036E-01],
	[9.5250000000E+03, 4.2730892464E+00, 6.1113932753E+00, 1.8240800845E-01, 1.7007187481E-01, 5.1696171693E-01],
	[9.5300000000E+03, 4.2760016372E+00, 6.1105797281E+00, 1.8270608089E-01, 1.7033495751E-01, 5.1712405546E-01],
	[9.5350000000E+03, 4.2789144837E+00, 6.1097667157E+00, 1.8300448330E-01, 1.7059828885E-01, 5.1728636599E-01],
	[9.5400000000E+03, 4.2818277859E+00, 6.1089542377E+00, 1.8330321586E-01, 1.7086186887E-01, 5.1744864856E-01],
	[9.5450000000E+03, 4.2847415436E+00, 6.1081422933E+00, 1.8360227876E-01, 1.7112569761E-01, 5.1761090324E-01],
	[9.5500000000E+03, 4.2876557566E+00, 6.1073308820E+00, 1.8390167220E-01, 1.7138977513E-01, 5.1777313005E-01],
	[9.5550000000E+03, 4.2905704247E+00, 6.1065200030E+00, 1.8420139636E-01, 1.7165410146E-01, 5.1793532906E-01],
	[9.5600000000E+03, 4.2934855478E+00, 6.1057096559E+00, 1.8450145144E-01, 1.7191867666E-01, 5.1809750029E-01],
	[9.5650000000E+03, 4.2964011257E+00, 6.1048998400E+00, 1.8480183762E-01, 1.7218350076E-01, 5.1825964380E-01],
	[9.5700000000E+03, 4.2993171582E+00, 6.1040905545E+00, 1.8510255510E-01, 1.7244857381E-01, 5.1842175964E-01],
	[9.5750000000E+03, 4.3022336452E+00, 6.1032817990E+00, 1.8540360407E-01, 1.7271389586E-01, 5.1858384785E-01],
	[9.5800000000E+03, 4.3051505866E+00, 6.1024735728E+00, 1.8570498473E-01, 1.7297946695E-01, 5.1874590848E-01],
	[9.5850000000E+03, 4.3080679820E+00, 6.1016658752E+00, 1.8600669725E-01, 1.7324528712E-01, 5.1890794156E-01],
	[9.5900000000E+03, 4.3109858315E+00, 6.1008587057E+00, 1.8630874184E-01, 1.7351135641E-01, 5.1906994716E-01],
	[9.5950000000E+03, 4.3139041347E+00, 6.1000520636E+00, 1.8661111869E-01, 1.7377767487E-01, 5.1923192531E-01],
	[9.6000000000E+03, 4.3168228916E+00, 6.0992459483E+00, 1.8691382798E-01, 1.7404424255E-01, 5.1939387604E-01],
	[9.6050000000E+03, 4.3197421020E+00, 6.0984403592E+00, 1.8721686991E-01, 1.7431105948E-01, 5.1955579938E-01],
	[9.6100000000E+03, 4.3226617657E+00, 6.0976352957E+00, 1.8752024467E-01, 1.7457812571E-01, 5.1971769536E-01],
	[9.6150000000E+03, 4.3255818825E+00, 6.0968307571E+00, 1.8782395246E-01, 1.7484544128E-01, 5.1987956401E-01],
	[9.6200000000E+03, 4.3285024523E+00, 6.0960267429E+00, 1.8812799345E-01, 1.7511300624E-01, 5.2004140535E-01],
	[9.6250000000E+03, 4.3314245808E+00, 6.0952266867E+00, 1.8843236785E-01, 1.7538082528E-01, 5.2020321942E-01],
	[9.6300000000E+03, 4.3343499307E+00, 6.0944357398E+00, 1.8873707584E-01, 1.7564890549E-01, 5.2036500625E-01],
	[9.6350000000E+03, 4.3372757363E+00, 6.0936453061E+00, 1.8904211762E-01, 1.7591723529E-01, 5.2052676587E-01],
	[9.6400000000E+03, 4.3402019974E+00, 6.0928553849E+00, 1.8934749338E-01, 1.7618581474E-01, 5.2068849830E-01],
	[9.6450000000E+03, 4.3431287139E+00, 6.0920659757E+00, 1.8965320331E-01, 1.7645464387E-01, 5.2085020358E-01],
	[9.6500000000E+03, 4.3460558856E+00, 6.0912770777E+00, 1.8995924760E-01, 1.7672372271E-01, 5.2101188174E-01],
	[9.6550000000E+03, 4.3489835124E+00, 6.0904886905E+00, 1.9026562644E-01, 1.7699305133E-01, 5.2117353281E-01],
	[9.6600000000E+03, 4.3519115940E+00, 6.0897008134E+00, 1.9057234002E-01, 1.7726262974E-01, 5.2133515682E-01],
	[9.6650000000E+03, 4.3548401303E+00, 6.0889134459E+00, 1.9087938854E-01, 1.7753245801E-01, 5.2149675379E-01],
	[9.6700000000E+03, 4.3577691212E+00, 6.0881265873E+00, 1.9118677219E-01, 1.7780253616E-01, 5.2165832376E-01],
	[9.6750000000E+03, 4.3606985664E+00, 6.0873402371E+00, 1.9149449116E-01, 1.7807286424E-01, 5.2181986676E-01],
	[9.6800000000E+03, 4.3636284659E+00, 6.0865543946E+00, 1.9180254564E-01, 1.7834344229E-01, 5.2198138282E-01],
	[9.6850000000E+03, 4.3665588194E+00, 6.0857690593E+00, 1.9211093582E-01, 1.7861427035E-01, 5.2214287197E-01],
	[9.6900000000E+03, 4.3694896268E+00, 6.0849842306E+00, 1.9241966189E-01, 1.7888534846E-01, 5.2230433424E-01],
	[9.6950000000E+03, 4.3724208879E+00, 6.0841999079E+00, 1.9272872405E-01, 1.7915667666E-01, 5.2246576966E-01],
	[9.7000000000E+03, 4.3753526026E+00, 6.0834160906E+00, 1.9303812248E-01, 1.7942825500E-01, 5.2262717826E-01],
	[9.7050000000E+03, 4.3782847707E+00, 6.0826327781E+00, 1.9334785738E-01, 1.7970008350E-01, 5.2278856007E-01],
	[9.7100000000E+03, 4.3812173920E+00, 6.0818499699E+00, 1.9365792895E-01, 1.7997216222E-01, 5.2294991511E-01],
	[9.7150000000E+03, 4.3841504664E+00, 6.0810676653E+00, 1.9396833736E-01, 1.8024449119E-01, 5.2311124343E-01],
	[9.7200000000E+03, 4.3870839937E+00, 6.0802858638E+00, 1.9427908282E-01, 1.8051707044E-01, 5.2327254505E-01],
	[9.7250000000E+03, 4.3900179737E+00, 6.0795045648E+00, 1.9459016551E-01, 1.8078990003E-01, 5.2343382000E-01],
	[9.7300000000E+03, 4.3929524063E+00, 6.0787237677E+00, 1.9490158562E-01, 1.8106297999E-01, 5.2359506832E-01],
	[9.7350000000E+03, 4.3958872914E+00, 6.0779434719E+00, 1.9521334336E-01, 1.8133631035E-01, 5.2375629002E-01],
	[9.7400000000E+03, 4.3988226286E+00, 6.0771636769E+00, 1.9552543890E-01, 1.8160989116E-01, 5.2391748515E-01],
	[9.7450000000E+03, 4.4017584180E+00, 6.0763843821E+00, 1.9583787245E-01, 1.8188372245E-01, 5.2407865373E-01],
	[9.7500000000E+03, 4.4046946593E+00, 6.0756055868E+00, 1.9615064418E-01, 1.8215780427E-01, 5.2423979579E-01],
	[9.7550000000E+03, 4.4076313524E+00, 6.0748272906E+00, 1.9646375430E-01, 1.8243213665E-01, 5.2440091137E-01],
	[9.7600000000E+03, 4.4105684970E+00, 6.0740494928E+00, 1.9677720300E-01, 1.8270671963E-01, 5.2456200050E-01],
	[9.7650000000E+03, 4.4135060932E+00, 6.0732721929E+00, 1.9709099047E-01, 1.8298155324E-01, 5.2472306319E-01],
	[9.7700000000E+03, 4.4164441406E+00, 6.0724953902E+00, 1.9740511689E-01, 1.8325663754E-01, 5.2488409950E-01],
	[9.7750000000E+03, 4.4193826391E+00, 6.0717190843E+00, 1.9771958247E-01, 1.8353197254E-01, 5.2504510944E-01],
	[9.7800000000E+03, 4.4223227430E+00, 6.0709467381E+00, 1.9803438739E-01, 1.8380756347E-01, 5.2520609304E-01],
	[9.7850000000E+03, 4.4252659900E+00, 6.0701829524E+00, 1.9834953184E-01, 1.8408341728E-01, 5.2536705035E-01],
	[9.7900000000E+03, 4.4282096907E+00, 6.0694196530E+00, 1.9866501602E-01, 1.8435952201E-01, 5.2552798138E-01],
	[9.7950000000E+03, 4.4311538451E+00, 6.0686568392E+00, 1.9898084012E-01, 1.8463587769E-01, 5.2568888617E-01],
	[9.8000000000E+03, 4.4340984529E+00, 6.0678945105E+00, 1.9929700433E-01, 1.8491248436E-01, 5.2584976475E-01],
	[9.8050000000E+03, 4.4370435140E+00, 6.0671326663E+00, 1.9961350884E-01, 1.8518934206E-01, 5.2601061715E-01],
	[9.8100000000E+03, 4.4399890283E+00, 6.0663713061E+00, 1.9993035385E-01, 1.8546645081E-01, 5.2617144340E-01],
	[9.8150000000E+03, 4.4429349955E+00, 6.0656104293E+00, 2.0024753954E-01, 1.8574381066E-01, 5.2633224354E-01],
	[9.8200000000E+03, 4.4458814156E+00, 6.0648500354E+00, 2.0056506610E-01, 1.8602142165E-01, 5.2649301758E-01],
	[9.8250000000E+03, 4.4488282883E+00, 6.0640901238E+00, 2.0088293374E-01, 1.8629928381E-01, 5.2665376557E-01],
	[9.8300000000E+03, 4.4517756135E+00, 6.0633306940E+00, 2.0120114263E-01, 1.8657739717E-01, 5.2681448753E-01],
	[9.8350000000E+03, 4.4547233910E+00, 6.0625717454E+00, 2.0151969298E-01, 1.8685576177E-01, 5.2697518350E-01],
	[9.8400000000E+03, 4.4576716207E+00, 6.0618132775E+00, 2.0183858497E-01, 1.8713437766E-01, 5.2713585350E-01],
	[9.8450000000E+03, 4.4606203024E+00, 6.0610552897E+00, 2.0215781880E-01, 1.8741324485E-01, 5.2729649757E-01],
	[9.8500000000E+03, 4.4635694360E+00, 6.0602977814E+00, 2.0247739466E-01, 1.8769236340E-01, 5.2745711573E-01],
	[9.8550000000E+03, 4.4665190212E+00, 6.0595407522E+00, 2.0279731274E-01, 1.8797173332E-01, 5.2761770803E-01],
	[9.8600000000E+03, 4.4694690580E+00, 6.0587842015E+00, 2.0311757323E-01, 1.8825135467E-01, 5.2777827448E-01],
	[9.8650000000E+03, 4.4724195461E+00, 6.0580281287E+00, 2.0343817632E-01, 1.8853122747E-01, 5.2793881512E-01],
	[9.8700000000E+03, 4.4753704855E+00, 6.0572725333E+00, 2.0375912221E-01, 1.8881135176E-01, 5.2809932998E-01],
	[9.8750000000E+03, 4.4783218759E+00, 6.0565174147E+00, 2.0408041108E-01, 1.8909172757E-01, 5.2825981910E-01],
	[9.8800000000E+03, 4.4812737172E+00, 6.0557627725E+00, 2.0440204314E-01, 1.8937235494E-01, 5.2842028249E-01],
	[9.8850000000E+03, 4.4842260092E+00, 6.0550086060E+00, 2.0472401856E-01, 1.8965323389E-01, 5.2858072020E-01],
	[9.8900000000E+03, 4.4871787518E+00, 6.0542549147E+00, 2.0504633755E-01, 1.8993436448E-01, 5.2874113226E-01],
	[9.8950000000E+03, 4.4901319448E+00, 6.0535016981E+00, 2.0536900030E-01, 1.9021574672E-01, 5.2890151869E-01],
	[9.9000000000E+03, 4.4930855881E+00, 6.0527489557E+00, 2.0569200699E-01, 1.9049738065E-01, 5.2906187953E-01],
	[9.9050000000E+03, 4.4960396814E+00, 6.0519966869E+00, 2.0601535782E-01, 1.9077926631E-01, 5.2922221480E-01],
	[9.9100000000E+03, 4.4989942247E+00, 6.0512448911E+00, 2.0633905299E-01, 1.9106140373E-01, 5.2938252455E-01],
	[9.9150000000E+03, 4.5019492178E+00, 6.0504935679E+00, 2.0666309267E-01, 1.9134379294E-01, 5.2954280879E-01],
	[9.9200000000E+03, 4.5049046605E+00, 6.0497427167E+00, 2.0698747707E-01, 1.9162643397E-01, 5.2970306756E-01],
	[9.9250000000E+03, 4.5078605526E+00, 6.0489923369E+00, 2.0731220638E-01, 1.9190932687E-01, 5.2986330090E-01],
	[9.9300000000E+03, 4.5108168941E+00, 6.0482424281E+00, 2.0763728079E-01, 1.9219247165E-01, 5.3002350883E-01],
	[9.9350000000E+03, 4.5137736847E+00, 6.0474929897E+00, 2.0796270048E-01, 1.9247586835E-01, 5.3018369139E-01],
	[9.9400000000E+03, 4.5167340462E+00, 6.0467530481E+00, 2.0828846566E-01, 1.9275953187E-01, 5.3034384860E-01],
	[9.9450000000E+03, 4.5196955625E+00, 6.0460156016E+00, 2.0861457652E-01, 1.9304345081E-01, 5.3050398049E-01],
	[9.9500000000E+03, 4.5226575305E+00, 6.0452786155E+00, 2.0894103324E-01, 1.9332762185E-01, 5.3066408711E-01],
	[9.9550000000E+03, 4.5256199501E+00, 6.0445420895E+00, 2.0926783603E-01, 1.9361204504E-01, 5.3082416847E-01],
	[9.9600000000E+03, 4.5285828212E+00, 6.0438060230E+00, 2.0959498506E-01, 1.9389672041E-01, 5.3098422468E-01],
	[9.9650000000E+03, 4.5315461436E+00, 6.0430704155E+00, 2.0992248054E-01, 1.9418164798E-01, 5.3114425586E-01],
	[9.9700000000E+03, 4.5345099171E+00, 6.0423352665E+00, 2.1025032265E-01, 1.9446682779E-01, 5.3130426203E-01],
	[9.9750000000E+03, 4.5374741415E+00, 6.0416005754E+00, 2.1057851159E-01, 1.9475225986E-01, 5.3146424319E-01],
	[9.9800000000E+03, 4.5404388168E+00, 6.0408663417E+00, 2.1090704755E-01, 1.9503794424E-01, 5.3162419937E-01],
	[9.9850000000E+03, 4.5434039428E+00, 6.0401325650E+00, 2.1123593072E-01, 1.9532388094E-01, 5.3178413057E-01],
	[9.9900000000E+03, 4.5463695192E+00, 6.0393992446E+00, 2.1156516130E-01, 1.9561007001E-01, 5.3194403681E-01],
	[9.9950000000E+03, 4.5493355460E+00, 6.0386663802E+00, 2.1189473947E-01, 1.9589651147E-01, 5.3210391810E-01],
	[1.0000000000E+04, 4.5523020229E+00, 6.0379339712E+00, 2.1222466543E-01, 1.9618320536E-01, 5.3226377445E-01],
	[1.0005000000E+04, 4.5552689499E+00, 6.0372020170E+00, 2.1255647072E-01, 1.9647146005E-01, 5.3242360587E-01],
	[1.0010000000E+04, 4.5582363267E+00, 6.0364705172E+00, 2.1288862821E-01, 1.9675997017E-01, 5.3258341238E-01],
	[1.0015000000E+04, 4.5612041533E+00, 6.0357394713E+00, 2.1322113809E-01, 1.9704873575E-01, 5.3274319399E-01],
	[1.0020000000E+04, 4.5641724294E+00, 6.0350088787E+00, 2.1355400058E-01, 1.9733775684E-01, 5.3290295070E-01],
	[1.0025000000E+04, 4.5671411549E+00, 6.0342787390E+00, 2.1388721585E-01, 1.9762703345E-01, 5.3306268255E-01],
	[1.0030000000E+04, 4.5701103297E+00, 6.0335490516E+00, 2.1422078411E-01, 1.9791656561E-01, 5.3322238952E-01],
	[1.0035000000E+04, 4.5730799536E+00, 6.0328198160E+00, 2.1455470556E-01, 1.9820635337E-01, 5.3338207165E-01],
	[1.0040000000E+04, 4.5760500264E+00, 6.0320910318E+00, 2.1488898038E-01, 1.9849639675E-01, 5.3354172894E-01],
	[1.0045000000E+04, 4.5790205479E+00, 6.0313626984E+00, 2.1522360879E-01, 1.9878669577E-01, 5.3370136140E-01],
	[1.0050000000E+04, 4.5819915181E+00, 6.0306348153E+00, 2.1555859098E-01, 1.9907725048E-01, 5.3386096906E-01],
	[1.0055000000E+04, 4.5849629368E+00, 6.0299073820E+00, 2.1589392713E-01, 1.9936806090E-01, 5.3402055191E-01],
	[1.0060000000E+04, 4.5879348037E+00, 6.0291803981E+00, 2.1622961746E-01, 1.9965912706E-01, 5.3418010997E-01],
	[1.0065000000E+04, 4.5909071189E+00, 6.0284538629E+00, 2.1656566216E-01, 1.9995044900E-01, 5.3433964326E-01],
	[1.0070000000E+04, 4.5938798820E+00, 6.0277277761E+00, 2.1690206142E-01, 2.0024202673E-01, 5.3449915178E-01],
	[1.0075000000E+04, 4.5968530930E+00, 6.0270021371E+00, 2.1723881544E-01, 2.0053386029E-01, 5.3465863556E-01],
	[1.0080000000E+04, 4.5998267516E+00, 6.0262769454E+00, 2.1757592442E-01, 2.0082594972E-01, 5.3481809460E-01],
	[1.0085000000E+04, 4.6028008578E+00, 6.0255522005E+00, 2.1791338856E-01, 2.0111829503E-01, 5.3497752892E-01],
	[1.0090000000E+04, 4.6057754114E+00, 6.0248279020E+00, 2.1825120805E-01, 2.0141089626E-01, 5.3513693853E-01],
	[1.0095000000E+04, 4.6087504122E+00, 6.0241040493E+00, 2.1858938309E-01, 2.0170375344E-01, 5.3529632344E-01],
	[1.0100000000E+04, 4.6117290971E+00, 6.0233894520E+00, 2.1892791388E-01, 2.0199688271E-01, 5.3545568367E-01],
	[1.0105000000E+04, 4.6147089175E+00, 6.0226771584E+00, 2.1926680062E-01, 2.0229027149E-01, 5.3561501923E-01],
	[1.0110000000E+04, 4.6176891877E+00, 6.0219653013E+00, 2.1960604349E-01, 2.0258391639E-01, 5.3577433013E-01],
	[1.0115000000E+04, 4.6206699077E+00, 6.0212538802E+00, 2.1994564271E-01, 2.0287781746E-01, 5.3593361638E-01],
	[1.0120000000E+04, 4.6236510772E+00, 6.0205428947E+00, 2.2028559846E-01, 2.0317197471E-01, 5.3609287800E-01],
	[1.0125000000E+04, 4.6266326962E+00, 6.0198323443E+00, 2.2062591095E-01, 2.0346638818E-01, 5.3625211501E-01],
	[1.0130000000E+04, 4.6296147644E+00, 6.0191222285E+00, 2.2096658036E-01, 2.0376105789E-01, 5.3641132741E-01],
	[1.0135000000E+04, 4.6325972817E+00, 6.0184125468E+00, 2.2130760691E-01, 2.0405598386E-01, 5.3657051522E-01],
	[1.0140000000E+04, 4.6355802480E+00, 6.0177032987E+00, 2.2164899078E-01, 2.0435116614E-01, 5.3672967845E-01],
	[1.0145000000E+04, 4.6385636631E+00, 6.0169944838E+00, 2.2199073217E-01, 2.0464660474E-01, 5.3688881711E-01],
	[1.0150000000E+04, 4.6415475269E+00, 6.0162861016E+00, 2.2233283128E-01, 2.0494229969E-01, 5.3704793123E-01],
	[1.0155000000E+04, 4.6445318392E+00, 6.0155781516E+00, 2.2267528831E-01, 2.0523825102E-01, 5.3720702080E-01],
	[1.0160000000E+04, 4.6475165998E+00, 6.0148706334E+00, 2.2301810346E-01, 2.0553445876E-01, 5.3736608585E-01],
	[1.0165000000E+04, 4.6505018086E+00, 6.0141635464E+00, 2.2336127691E-01, 2.0583092292E-01, 5.3752512639E-01],
	[1.0170000000E+04, 4.6534874654E+00, 6.0134568901E+00, 2.2370480888E-01, 2.0612764355E-01, 5.3768414243E-01],
	[1.0175000000E+04, 4.6564735702E+00, 6.0127506642E+00, 2.2404869955E-01, 2.0642462066E-01, 5.3784313399E-01],
	[1.0180000000E+04, 4.6594601226E+00, 6.0120448681E+00, 2.2439294913E-01, 2.0672185428E-01, 5.3800210107E-01],
	[1.0185000000E+04, 4.6624471227E+00, 6.0113395014E+00, 2.2473755781E-01, 2.0701934444E-01, 5.3816104370E-01],
	[1.0190000000E+04, 4.6654345701E+00, 6.0106345635E+00, 2.2508252578E-01, 2.0731709117E-01, 5.3831996189E-01],
	[1.0195000000E+04, 4.6684224649E+00, 6.0099300541E+00, 2.2542785326E-01, 2.0761509448E-01, 5.3847885564E-01],
	[1.0200000000E+04, 4.6714108068E+00, 6.0092259726E+00, 2.2577354042E-01, 2.0791335440E-01, 5.3863772498E-01],
	[1.0205000000E+04, 4.6743995956E+00, 6.0085223186E+00, 2.2611958748E-01, 2.0821187096E-01, 5.3879656991E-01],
	[1.0210000000E+04, 4.6773888313E+00, 6.0078190916E+00, 2.2646599462E-01, 2.0851064419E-01, 5.3895539046E-01],
	[1.0215000000E+04, 4.6803785136E+00, 6.0071162912E+00, 2.2681276205E-01, 2.0880967411E-01, 5.3911418663E-01],
	[1.0220000000E+04, 4.6833686425E+00, 6.0064139168E+00, 2.2715988997E-01, 2.0910896073E-01, 5.3927295844E-01],
	[1.0225000000E+04, 4.6863592177E+00, 6.0057119680E+00, 2.2750737856E-01, 2.0940850410E-01, 5.3943170590E-01],
	[1.0230000000E+04, 4.6893502391E+00, 6.0050104444E+00, 2.2785522803E-01, 2.0970830423E-01, 5.3959042903E-01],
	[1.0235000000E+04, 4.6923417066E+00, 6.0043093455E+00, 2.2820343858E-01, 2.1000836114E-01, 5.3974912784E-01],
	[1.0240000000E+04, 4.6953336200E+00, 6.0036086707E+00, 2.2855201040E-01, 2.1030867487E-01, 5.3990780234E-01],
	[1.0245000000E+04, 4.6983259791E+00, 6.0029084197E+00, 2.2890094369E-01, 2.1060924543E-01, 5.4006645255E-01],
	[1.0250000000E+04, 4.7013187839E+00, 6.0022085920E+00, 2.2925023865E-01, 2.1091007284E-01, 5.4022507849E-01],
	[1.0255000000E+04, 4.7043120341E+00, 6.0015091872E+00, 2.2959989547E-01, 2.1121115714E-01, 5.4038368016E-01],
	[1.0260000000E+04, 4.7073070425E+00, 6.0008135123E+00, 2.2994991436E-01, 2.1151250510E-01, 5.4054225758E-01],
	[1.0265000000E+04, 4.7103052978E+00, 6.0001253075E+00, 2.3030029551E-01, 2.1181412448E-01, 5.4070081076E-01],
	[1.0270000000E+04, 4.7133040014E+00, 5.9994375167E+00, 2.3065103911E-01, 2.1211600090E-01, 5.4085933972E-01],
	[1.0275000000E+04, 4.7163031530E+00, 5.9987501395E+00, 2.3100214537E-01, 2.1241813440E-01, 5.4101784447E-01],
	[1.0280000000E+04, 4.7193027526E+00, 5.9980631754E+00, 2.3135361448E-01, 2.1272052500E-01, 5.4117632503E-01],
	[1.0285000000E+04, 4.7223028000E+00, 5.9973766239E+00, 2.3170544665E-01, 2.1302317272E-01, 5.4133478141E-01],
	[1.0290000000E+04, 4.7253032949E+00, 5.9966904846E+00, 2.3205764206E-01, 2.1332607759E-01, 5.4149321363E-01],
	[1.0295000000E+04, 4.7283042374E+00, 5.9960047571E+00, 2.3241020092E-01, 2.1362923962E-01, 5.4165162169E-01],
	[1.0300000000E+04, 4.7313056272E+00, 5.9953194409E+00, 2.3276312342E-01, 2.1393265884E-01, 5.4181000562E-01],
	[1.0305000000E+04, 4.7343074641E+00, 5.9946345356E+00, 2.3311640976E-01, 2.1423633527E-01, 5.4196836543E-01],
	[1.0310000000E+04, 4.7373097481E+00, 5.9939500407E+00, 2.3347006015E-01, 2.1454026894E-01, 5.4212670112E-01],
	[1.0315000000E+04, 4.7403124790E+00, 5.9932659558E+00, 2.3382407476E-01, 2.1484445985E-01, 5.4228501273E-01],
	[1.0320000000E+04, 4.7433156566E+00, 5.9925822804E+00, 2.3417845382E-01, 2.1514890805E-01, 5.4244330025E-01],
	[1.0325000000E+04, 4.7463192807E+00, 5.9918990141E+00, 2.3453319750E-01, 2.1545361354E-01, 5.4260156371E-01],
	[1.0330000000E+04, 4.7493233513E+00, 5.9912161564E+00, 2.3488830601E-01, 2.1575857634E-01, 5.4275980312E-01],
	[1.0335000000E+04, 4.7523278682E+00, 5.9905337070E+00, 2.3524377955E-01, 2.1606379649E-01, 5.4291801849E-01],
	[1.0340000000E+04, 4.7553328311E+00, 5.9898516653E+00, 2.3559961832E-01, 2.1636927399E-01, 5.4307620984E-01],
	[1.0345000000E+04, 4.7583382401E+00, 5.9891700309E+00, 2.3595582250E-01, 2.1667500887E-01, 5.4323437719E-01],
	[1.0350000000E+04, 4.7613440949E+00, 5.9884888035E+00, 2.3631239231E-01, 2.1698100115E-01, 5.4339252054E-01],
	[1.0355000000E+04, 4.7643503954E+00, 5.9878079825E+00, 2.3666932793E-01, 2.1728725085E-01, 5.4355063991E-01],
	[1.0360000000E+04, 4.7673571414E+00, 5.9871275674E+00, 2.3702662957E-01, 2.1759375799E-01, 5.4370873532E-01],
	[1.0365000000E+04, 4.7703643327E+00, 5.9864475580E+00, 2.3738429743E-01, 2.1790052259E-01, 5.4386680679E-01],
	[1.0370000000E+04, 4.7733719693E+00, 5.9857679537E+00, 2.3774233169E-01, 2.1820754467E-01, 5.4402485431E-01],
	[1.0375000000E+04, 4.7763800510E+00, 5.9850887540E+00, 2.3810073257E-01, 2.1851482425E-01, 5.4418287792E-01],
	[1.0380000000E+04, 4.7793885776E+00, 5.9844099587E+00, 2.3845950025E-01, 2.1882236135E-01, 5.4434087763E-01],
	[1.0385000000E+04, 4.7823975490E+00, 5.9837315671E+00, 2.3881863493E-01, 2.1913015598E-01, 5.4449885344E-01],
	[1.0390000000E+04, 4.7854069651E+00, 5.9830535790E+00, 2.3917813682E-01, 2.1943820817E-01, 5.4465680538E-01],
	[1.0395000000E+04, 4.7884168256E+00, 5.9823759938E+00, 2.3953800610E-01, 2.1974651793E-01, 5.4481473346E-01],
	[1.0400000000E+04, 4.7914271305E+00, 5.9816988111E+00, 2.3989824299E-01, 2.2005508528E-01, 5.4497263769E-01],
	[1.0405000000E+04, 4.7944378795E+00, 5.9810220305E+00, 2.4025884766E-01, 2.2036391025E-01, 5.4513051809E-01],
	[1.0410000000E+04, 4.7974490726E+00, 5.9803456516E+00, 2.4061982034E-01, 2.2067299284E-01, 5.4528837468E-01],
	[1.0415000000E+04, 4.8004607096E+00, 5.9796696739E+00, 2.4098116120E-01, 2.2098233309E-01, 5.4544620747E-01],
	[1.0420000000E+04, 4.8034727904E+00, 5.9789940970E+00, 2.4134287045E-01, 2.2129193099E-01, 5.4560401647E-01],
	[1.0425000000E+04, 4.8064865638E+00, 5.9783218359E+00, 2.4170494829E-01, 2.2160179324E-01, 5.4576180170E-01],
	[1.0430000000E+04, 4.8095038412E+00, 5.9776571086E+00, 2.4206739492E-01, 2.2191192957E-01, 5.4591956317E-01],
	[1.0435000000E+04, 4.8125215652E+00, 5.9769927737E+00, 2.4243021053E-01, 2.2222232373E-01, 5.4607730090E-01],
	[1.0440000000E+04, 4.8155397357E+00, 5.9763288308E+00, 2.4279339532E-01, 2.2253297573E-01, 5.4623501491E-01],
	[1.0445000000E+04, 4.8185583526E+00, 5.9756652796E+00, 2.4315694948E-01, 2.2284388559E-01, 5.4639270521E-01],
	[1.0450000000E+04, 4.8215774156E+00, 5.9750021195E+00, 2.4352087323E-01, 2.2315505333E-01, 5.4655037181E-01],
	[1.0455000000E+04, 4.8245969247E+00, 5.9743393502E+00, 2.4388516674E-01, 2.2346647897E-01, 5.4670801473E-01],
	[1.0460000000E+04, 4.8276168798E+00, 5.9736769712E+00, 2.4424983023E-01, 2.2377816251E-01, 5.4686563398E-01],
	[1.0465000000E+04, 4.8306372805E+00, 5.9730149822E+00, 2.4461486389E-01, 2.2409010399E-01, 5.4702322959E-01],
	[1.0470000000E+04, 4.8336581269E+00, 5.9723533827E+00, 2.4498026792E-01, 2.2440230340E-01, 5.4718080156E-01],
	[1.0475000000E+04, 4.8366794187E+00, 5.9716921723E+00, 2.4534604252E-01, 2.2471476078E-01, 5.4733834991E-01],
	[1.0480000000E+04, 4.8397011559E+00, 5.9710313506E+00, 2.4571218788E-01, 2.2502747614E-01, 5.4749587465E-01],
	[1.0485000000E+04, 4.8427233382E+00, 5.9703709172E+00, 2.4607870420E-01, 2.2534044949E-01, 5.4765337581E-01],
	[1.0490000000E+04, 4.8457459656E+00, 5.9697108716E+00, 2.4644559168E-01, 2.2565368084E-01, 5.4781085339E-01],
	[1.0495000000E+04, 4.8487690378E+00, 5.9690512135E+00, 2.4681285052E-01, 2.2596717022E-01, 5.4796830741E-01],
	[1.0500000000E+04, 4.8517925547E+00, 5.9683919424E+00, 2.4718048092E-01, 2.2628091764E-01, 5.4812573789E-01],
	[1.0505000000E+04, 4.8548165163E+00, 5.9677330580E+00, 2.4754848307E-01, 2.2659492311E-01, 5.4828314484E-01],
	[1.0510000000E+04, 4.8578409222E+00, 5.9670745597E+00, 2.4791685717E-01, 2.2690918665E-01, 5.4844052828E-01],
	[1.0515000000E+04, 4.8608657725E+00, 5.9664164473E+00, 2.4828560342E-01, 2.2722370827E-01, 5.4859788823E-01],
	[1.0520000000E+04, 4.8638910669E+00, 5.9657587203E+00, 2.4865472203E-01, 2.2753848799E-01, 5.4875522469E-01],
	[1.0525000000E+04, 4.8669168053E+00, 5.9651013782E+00, 2.4902421317E-01, 2.2785352582E-01, 5.4891253768E-01],
	[1.0530000000E+04, 4.8699429875E+00, 5.9644444208E+00, 2.4939407707E-01, 2.2816882177E-01, 5.4906982723E-01],
	[1.0535000000E+04, 4.8729696135E+00, 5.9637878475E+00, 2.4976431390E-01, 2.2848437587E-01, 5.4922709334E-01],
	[1.0540000000E+04, 4.8759966830E+00, 5.9631316580E+00, 2.5013492388E-01, 2.2880018811E-01, 5.4938433603E-01],
	[1.0545000000E+04, 4.8790241959E+00, 5.9624758518E+00, 2.5050590720E-01, 2.2911625853E-01, 5.4954155532E-01],
	[1.0550000000E+04, 4.8820521521E+00, 5.9618204286E+00, 2.5087726405E-01, 2.2943258713E-01, 5.4969875122E-01],
	[1.0555000000E+04, 4.8850805515E+00, 5.9611653879E+00, 2.5124899464E-01, 2.2974917392E-01, 5.4985592374E-01],
	[1.0560000000E+04, 4.8881093938E+00, 5.9605107294E+00, 2.5162109916E-01, 2.3006601891E-01, 5.5001307291E-01],
	[1.0565000000E+04, 4.8911386789E+00, 5.9598564527E+00, 2.5199357781E-01, 2.3038312213E-01, 5.5017019874E-01],
	[1.0570000000E+04, 4.8941684067E+00, 5.9592025572E+00, 2.5236643079E-01, 2.3070048357E-01, 5.5032730125E-01],
	[1.0575000000E+04, 4.8971985771E+00, 5.9585490427E+00, 2.5273965831E-01, 2.3101810327E-01, 5.5048438044E-01],
	[1.0580000000E+04, 4.9002291899E+00, 5.9578959088E+00, 2.5311326054E-01, 2.3133598121E-01, 5.5064143634E-01],
	[1.0585000000E+04, 4.9032602449E+00, 5.9572431549E+00, 2.5348723770E-01, 2.3165411743E-01, 5.5079846896E-01],
	[1.0590000000E+04, 4.9062917421E+00, 5.9565907808E+00, 2.5386158999E-01, 2.3197251193E-01, 5.5095547832E-01],
	[1.0595000000E+04, 4.9093269653E+00, 5.9559458966E+00, 2.5423631759E-01, 2.3229118289E-01, 5.5111246444E-01],
	[1.0600000000E+04, 4.9123638543E+00, 5.9553040290E+00, 2.5461142072E-01, 2.3261011901E-01, 5.5126942732E-01],
	[1.0605000000E+04, 4.9154011884E+00, 5.9546625331E+00, 2.5498689956E-01, 2.3292931356E-01, 5.5142636699E-01],
	[1.0610000000E+04, 4.9184389675E+00, 5.9540214086E+00, 2.5536275431E-01, 2.3324876655E-01, 5.5158328346E-01],
	[1.0615000000E+04, 4.9214771914E+00, 5.9533806552E+00, 2.5573898518E-01, 2.3356847800E-01, 5.5174017674E-01],
	[1.0620000000E+04, 4.9245158599E+00, 5.9527402725E+00, 2.5611559236E-01, 2.3388844792E-01, 5.5189704687E-01],
	[1.0625000000E+04, 4.9275549731E+00, 5.9521002600E+00, 2.5649257606E-01, 2.3420867631E-01, 5.5205389384E-01],
	[1.0630000000E+04, 4.9305945306E+00, 5.9514606174E+00, 2.5686993646E-01, 2.3452916319E-01, 5.5221071767E-01],
	[1.0635000000E+04, 4.9336345324E+00, 5.9508213443E+00, 2.5724767377E-01, 2.3484990857E-01, 5.5236751839E-01],
	[1.0640000000E+04, 4.9366749783E+00, 5.9501824403E+00, 2.5762578818E-01, 2.3517091245E-01, 5.5252429600E-01],
	[1.0645000000E+04, 4.9397158681E+00, 5.9495439050E+00, 2.5800427990E-01, 2.3549217486E-01, 5.5268105053E-01],
	[1.0650000000E+04, 4.9427572018E+00, 5.9489057380E+00, 2.5838314911E-01, 2.3581369579E-01, 5.5283778191E-01],
	[1.0655000000E+04, 4.9457989792E+00, 5.9482679389E+00, 2.5876239603E-01, 2.3613547526E-01, 5.5299449015E-01],
	[1.0660000000E+04, 4.9488412001E+00, 5.9476305075E+00, 2.5914202085E-01, 2.3645751329E-01, 5.5315117523E-01],
	[1.0665000000E+04, 4.9518838643E+00, 5.9469934431E+00, 2.5952202377E-01, 2.3677980987E-01, 5.5330783715E-01],
	[1.0670000000E+04, 4.9549269719E+00, 5.9463567456E+00, 2.5990240498E-01, 2.3710236501E-01, 5.5346447592E-01],
	[1.0675000000E+04, 4.9579705225E+00, 5.9457204145E+00, 2.6028316468E-01, 2.3742517874E-01, 5.5362109152E-01],
	[1.0680000000E+04, 4.9610145161E+00, 5.9450844494E+00, 2.6066430308E-01, 2.3774825105E-01, 5.5377768396E-01],
	[1.0685000000E+04, 4.9640589526E+00, 5.9444488500E+00, 2.6104582036E-01, 2.3807158195E-01, 5.5393425324E-01],
	[1.0690000000E+04, 4.9671038317E+00, 5.9438136158E+00, 2.6142771674E-01, 2.3839517146E-01, 5.5409079934E-01],
	[1.0695000000E+04, 4.9701491533E+00, 5.9431787465E+00, 2.6180999240E-01, 2.3871901958E-01, 5.5424732228E-01],
	[1.0700000000E+04, 4.9731949173E+00, 5.9425442417E+00, 2.6219264755E-01, 2.3904312632E-01, 5.5440382204E-01],
	[1.0705000000E+04, 4.9762411236E+00, 5.9419101010E+00, 2.6257568238E-01, 2.3936749169E-01, 5.5456029863E-01],
	[1.0710000000E+04, 4.9792877720E+00, 5.9412763241E+00, 2.6295909710E-01, 2.3969211569E-01, 5.5471675205E-01],
	[1.0715000000E+04, 4.9823348623E+00, 5.9406429105E+00, 2.6334289190E-01, 2.4001699834E-01, 5.5487318228E-01],
	[1.0720000000E+04, 4.9853823945E+00, 5.9400098599E+00, 2.6372706697E-01, 2.4034213963E-01, 5.5502958934E-01],
	[1.0725000000E+04, 4.9884303684E+00, 5.9393771720E+00, 2.6411162253E-01, 2.4066753959E-01, 5.5518597321E-01],
	[1.0730000000E+04, 4.9914787838E+00, 5.9387448462E+00, 2.6449655876E-01, 2.4099319821E-01, 5.5534233390E-01],
	[1.0735000000E+04, 4.9945276405E+00, 5.9381128823E+00, 2.6488187587E-01, 2.4131911551E-01, 5.5549867141E-01],
	[1.0740000000E+04, 4.9975769386E+00, 5.9374812799E+00, 2.6526757405E-01, 2.4164529148E-01, 5.5565498573E-01],
	[1.0745000000E+04, 5.0006266777E+00, 5.9368500386E+00, 2.6565365350E-01, 2.4197172614E-01, 5.5581127686E-01],
	[1.0750000000E+04, 5.0036768579E+00, 5.9362191581E+00, 2.6604011442E-01, 2.4229841949E-01, 5.5596754480E-01],
	[1.0755000000E+04, 5.0067274788E+00, 5.9355886379E+00, 2.6642695702E-01, 2.4262537154E-01, 5.5612378954E-01],
	[1.0760000000E+04, 5.0097785405E+00, 5.9349584777E+00, 2.6681418148E-01, 2.4295258230E-01, 5.5628001110E-01],
	[1.0765000000E+04, 5.0128329953E+00, 5.9343346179E+00, 2.6720178801E-01, 2.4328006870E-01, 5.5643620945E-01],
	[1.0770000000E+04, 5.0158896446E+00, 5.9337146356E+00, 2.6758977680E-01, 2.4360782397E-01, 5.5659238462E-01],
	[1.0775000000E+04, 5.0189467376E+00, 5.9330950058E+00, 2.6797814806E-01, 2.4393583808E-01, 5.5674853658E-01],
	[1.0780000000E+04, 5.0220042744E+00, 5.9324757282E+00, 2.6836690198E-01, 2.4426411105E-01, 5.5690466534E-01],
	[1.0785000000E+04, 5.0250622546E+00, 5.9318568023E+00, 2.6875603876E-01, 2.4459264286E-01, 5.5706077090E-01],
	[1.0790000000E+04, 5.0281206783E+00, 5.9312382277E+00, 2.6914555860E-01, 2.4492143354E-01, 5.5721685326E-01],
	[1.0795000000E+04, 5.0311795452E+00, 5.9306200043E+00, 2.6953546169E-01, 2.4525048309E-01, 5.5737291242E-01],
	[1.0800000000E+04, 5.0342388552E+00, 5.9300021315E+00, 2.6992574825E-01, 2.4557979151E-01, 5.5752894837E-01],
	[1.0805000000E+04, 5.0372986082E+00, 5.9293846090E+00, 2.7031641846E-01, 2.4590935881E-01, 5.5768496111E-01],
	[1.0810000000E+04, 5.0403588040E+00, 5.9287674364E+00, 2.7070747252E-01, 2.4623918498E-01, 5.5784095064E-01],
	[1.0815000000E+04, 5.0434194425E+00, 5.9281506135E+00, 2.7109891064E-01, 2.4656927004E-01, 5.5799691697E-01],
	[1.0820000000E+04, 5.0464805235E+00, 5.9275341398E+00, 2.7149073301E-01, 2.4689961399E-01, 5.5815286009E-01],
	[1.0825000000E+04, 5.0495420469E+00, 5.9269180150E+00, 2.7188293983E-01, 2.4723021684E-01, 5.5830877999E-01],
	[1.0830000000E+04, 5.0526040126E+00, 5.9263022386E+00, 2.7227553130E-01, 2.4756107858E-01, 5.5846467668E-01],
	[1.0835000000E+04, 5.0556664204E+00, 5.9256868105E+00, 2.7266850761E-01, 2.4789219922E-01, 5.5862055016E-01],
	[1.0840000000E+04, 5.0587292702E+00, 5.9250717301E+00, 2.7306186898E-01, 2.4822357877E-01, 5.5877640042E-01],
	[1.0845000000E+04, 5.0617925618E+00, 5.9244569972E+00, 2.7345561558E-01, 2.4855521722E-01, 5.5893222747E-01],
	[1.0850000000E+04, 5.0648562952E+00, 5.9238426114E+00, 2.7384974763E-01, 2.4888711459E-01, 5.5908803131E-01],
	[1.0855000000E+04, 5.0679204700E+00, 5.9232285723E+00, 2.7424426533E-01, 2.4921927087E-01, 5.5924381192E-01],
	[1.0860000000E+04, 5.0709850863E+00, 5.9226148796E+00, 2.7463916886E-01, 2.4955168606E-01, 5.5939956932E-01],
	[1.0865000000E+04, 5.0740501439E+00, 5.9220015329E+00, 2.7503445844E-01, 2.4988436018E-01, 5.5955530349E-01],
	[1.0870000000E+04, 5.0771156427E+00, 5.9213885318E+00, 2.7543013425E-01, 2.5021729321E-01, 5.5971101445E-01],
	[1.0875000000E+04, 5.0801815824E+00, 5.9207758761E+00, 2.7582619650E-01, 2.5055048517E-01, 5.5986670219E-01],
	[1.0880000000E+04, 5.0832479630E+00, 5.9201635654E+00, 2.7622264539E-01, 2.5088393606E-01, 5.6002236670E-01],
	[1.0885000000E+04, 5.0863147843E+00, 5.9195515992E+00, 2.7661948112E-01, 2.5121764587E-01, 5.6017800800E-01],
	[1.0890000000E+04, 5.0893820462E+00, 5.9189399773E+00, 2.7701670387E-01, 2.5155161462E-01, 5.6033362607E-01],
	[1.0895000000E+04, 5.0924497485E+00, 5.9183286993E+00, 2.7741431387E-01, 2.5188584229E-01, 5.6048922091E-01],
	[1.0900000000E+04, 5.0955178912E+00, 5.9177177649E+00, 2.7781231129E-01, 2.5222032890E-01, 5.6064479254E-01],
	[1.0905000000E+04, 5.0985864740E+00, 5.9171071737E+00, 2.7821069634E-01, 2.5255507444E-01, 5.6080034093E-01],
	[1.0910000000E+04, 5.1016554968E+00, 5.9164969253E+00, 2.7860946923E-01, 2.5289007891E-01, 5.6095586611E-01],
	[1.0915000000E+04, 5.1047249596E+00, 5.9158870194E+00, 2.7900863014E-01, 2.5322534232E-01, 5.6111136805E-01],
	[1.0920000000E+04, 5.1077948621E+00, 5.9152774557E+00, 2.7940817928E-01, 2.5356086466E-01, 5.6126684677E-01],
	[1.0925000000E+04, 5.1108652042E+00, 5.9146682338E+00, 2.7980811684E-01, 2.5389664594E-01, 5.6142230227E-01],
	[1.0930000000E+04, 5.1139359857E+00, 5.9140593533E+00, 2.8020844303E-01, 2.5423268616E-01, 5.6157773453E-01],
	[1.0935000000E+04, 5.1170072066E+00, 5.9134508140E+00, 2.8060915805E-01, 2.5456898531E-01, 5.6173314357E-01],
	[1.0940000000E+04, 5.1200836615E+00, 5.9128515896E+00, 2.8101026209E-01, 2.5490557196E-01, 5.6188852938E-01],
	[1.0945000000E+04, 5.1231606696E+00, 5.9122529068E+00, 2.8141175535E-01, 2.5524241833E-01, 5.6204389197E-01],
	[1.0950000000E+04, 5.1262381202E+00, 5.9116545579E+00, 2.8181363803E-01, 2.5557952377E-01, 5.6219923132E-01],
	[1.0955000000E+04, 5.1293160134E+00, 5.9110565427E+00, 2.8221591033E-01, 2.5591688827E-01, 5.6235454745E-01],
	[1.0960000000E+04, 5.1323943488E+00, 5.9104588608E+00, 2.8261857245E-01, 2.5625451184E-01, 5.6250984035E-01],
	[1.0965000000E+04, 5.1354731263E+00, 5.9098615120E+00, 2.8302162459E-01, 2.5659239447E-01, 5.6266511002E-01],
	[1.0970000000E+04, 5.1385523459E+00, 5.9092644958E+00, 2.8342506694E-01, 2.5693053617E-01, 5.6282035646E-01],
	[1.0975000000E+04, 5.1416320073E+00, 5.9086678119E+00, 2.8382889971E-01, 2.5726893692E-01, 5.6297557967E-01],
	[1.0980000000E+04, 5.1447121105E+00, 5.9080714600E+00, 2.8423312310E-01, 2.5760759674E-01, 5.6313077965E-01],
	[1.0985000000E+04, 5.1477926553E+00, 5.9074754397E+00, 2.8463773730E-01, 2.5794651561E-01, 5.6328595640E-01],
	[1.0990000000E+04, 5.1508736416E+00, 5.9068797508E+00, 2.8504274251E-01, 2.5828569355E-01, 5.6344110992E-01],
	[1.0995000000E+04, 5.1539550692E+00, 5.9062843928E+00, 2.8544813893E-01, 2.5862513053E-01, 5.6359624022E-01],
	[1.1000000000E+04, 5.1570369379E+00, 5.9056893655E+00, 2.8585392677E-01, 2.5896482658E-01, 5.6375134728E-01],
	[1.1005000000E+04, 5.1601192478E+00, 5.9050946685E+00, 2.8626010621E-01, 2.5930478167E-01, 5.6390643112E-01],
	[1.1010000000E+04, 5.1632019985E+00, 5.9045003014E+00, 2.8666667747E-01, 2.5964499581E-01, 5.6406149172E-01],
	[1.1015000000E+04, 5.1662851900E+00, 5.9039062640E+00, 2.8707364073E-01, 2.5998546899E-01, 5.6421652910E-01],
	[1.1020000000E+04, 5.1693688222E+00, 5.9033125560E+00, 2.8748099620E-01, 2.6032620122E-01, 5.6437154325E-01],
	[1.1025000000E+04, 5.1724528949E+00, 5.9027191769E+00, 2.8788874408E-01, 2.6066719249E-01, 5.6452653417E-01],
	[1.1030000000E+04, 5.1755374079E+00, 5.9021261264E+00, 2.8829688456E-01, 2.6100844280E-01, 5.6468150186E-01],
	[1.1035000000E+04, 5.1786223612E+00, 5.9015334043E+00, 2.8870541785E-01, 2.6134995214E-01, 5.6483644633E-01],
	[1.1040000000E+04, 5.1817077545E+00, 5.9009410101E+00, 2.8911434414E-01, 2.6169172052E-01, 5.6499136757E-01],
	[1.1045000000E+04, 5.1847935878E+00, 5.9003489437E+00, 2.8952366363E-01, 2.6203374791E-01, 5.6514626558E-01],
	[1.1050000000E+04, 5.1878798610E+00, 5.8997572045E+00, 2.8993337652E-01, 2.6237603434E-01, 5.6530114036E-01],
	[1.1055000000E+04, 5.1909665738E+00, 5.8991657923E+00, 2.9034348302E-01, 2.6271857978E-01, 5.6545599192E-01],
	[1.1060000000E+04, 5.1940537262E+00, 5.8985747069E+00, 2.9075398332E-01, 2.6306138423E-01, 5.6561082025E-01],
	[1.1065000000E+04, 5.1971413179E+00, 5.8979839477E+00, 2.9116487761E-01, 2.6340444770E-01, 5.6576562536E-01],
	[1.1070000000E+04, 5.2002293490E+00, 5.8973935146E+00, 2.9157616611E-01, 2.6374777017E-01, 5.6592040724E-01],
	[1.1075000000E+04, 5.2033178192E+00, 5.8968034071E+00, 2.9198784900E-01, 2.6409135164E-01, 5.6607516589E-01],
	[1.1080000000E+04, 5.2064067284E+00, 5.8962136251E+00, 2.9239992649E-01, 2.6443519211E-01, 5.6622990133E-01],
	[1.1085000000E+04, 5.2094960765E+00, 5.8956241680E+00, 2.9281239878E-01, 2.6477929157E-01, 5.6638461354E-01],
	[1.1090000000E+04, 5.2125858633E+00, 5.8950350357E+00, 2.9322526606E-01, 2.6512365001E-01, 5.6653930253E-01],
	[1.1095000000E+04, 5.2156760887E+00, 5.8944462277E+00, 2.9363852854E-01, 2.6546826744E-01, 5.6669396829E-01],
	[1.1100000000E+04, 5.2187667525E+00, 5.8938577439E+00, 2.9405218641E-01, 2.6581314384E-01, 5.6684861084E-01],
	[1.1105000000E+04, 5.2218578547E+00, 5.8932695837E+00, 2.9446623987E-01, 2.6615827921E-01, 5.6700323016E-01],
	[1.1110000000E+04, 5.2249493951E+00, 5.8926817470E+00, 2.9488068913E-01, 2.6650367354E-01, 5.6715782627E-01],
	[1.1115000000E+04, 5.2280453034E+00, 5.8921010867E+00, 2.9529553438E-01, 2.6684935112E-01, 5.6731239916E-01],
	[1.1120000000E+04, 5.2311428310E+00, 5.8915227986E+00, 2.9571077582E-01, 2.6719529505E-01, 5.6746694883E-01],
	[1.1125000000E+04, 5.2342408002E+00, 5.8909448272E+00, 2.9612641365E-01, 2.6754149807E-01, 5.6762147528E-01],
	[1.1130000000E+04, 5.2373392107E+00, 5.8903671721E+00, 2.9654244807E-01, 2.6788796016E-01, 5.6777597851E-01],
	[1.1135000000E+04, 5.2404380625E+00, 5.8897898331E+00, 2.9695887928E-01, 2.6823468132E-01, 5.6793045854E-01],
	[1.1140000000E+04, 5.2435373554E+00, 5.8892128098E+00, 2.9737570747E-01, 2.6858166154E-01, 5.6808491534E-01],
	[1.1145000000E+04, 5.2466370894E+00, 5.8886361020E+00, 2.9779293286E-01, 2.6892890082E-01, 5.6823934894E-01],
	[1.1150000000E+04, 5.2497372642E+00, 5.8880597092E+00, 2.9821055563E-01, 2.6927639914E-01, 5.6839375932E-01],
	[1.1155000000E+04, 5.2528378797E+00, 5.8874836312E+00, 2.9862857599E-01, 2.6962415650E-01, 5.6854814649E-01],
	[1.1160000000E+04, 5.2559389358E+00, 5.8869078678E+00, 2.9904699414E-01, 2.6997217289E-01, 5.6870251045E-01],
	[1.1165000000E+04, 5.2590404323E+00, 5.8863324185E+00, 2.9946581027E-01, 2.7032044831E-01, 5.6885685120E-01],
	[1.1170000000E+04, 5.2621423692E+00, 5.8857572830E+00, 2.9988502458E-01, 2.7066898274E-01, 5.6901116874E-01],
	[1.1175000000E+04, 5.2652447462E+00, 5.8851824611E+00, 3.0030463728E-01, 2.7101777619E-01, 5.6916546308E-01],
	[1.1180000000E+04, 5.2683475633E+00, 5.8846079524E+00, 3.0072464856E-01, 2.7136682863E-01, 5.6931973421E-01],
	[1.1185000000E+04, 5.2714508203E+00, 5.8840337567E+00, 3.0114758661E-01, 2.7171819810E-01, 5.6947398214E-01],
	[1.1190000000E+04, 5.2745545171E+00, 5.8834598736E+00, 3.0157109115E-01, 2.7206996197E-01, 5.6962820686E-01],
	[1.1195000000E+04, 5.2776586536E+00, 5.8828863028E+00, 3.0199500122E-01, 2.7242198902E-01, 5.6978240839E-01],
	[1.1200000000E+04, 5.2807632295E+00, 5.8823130439E+00, 3.0241931703E-01, 2.7277427922E-01, 5.6993658671E-01],
	[1.1205000000E+04, 5.2838682449E+00, 5.8817400968E+00, 3.0284403879E-01, 2.7312683258E-01, 5.7009074183E-01],
	[1.1210000000E+04, 5.2869736994E+00, 5.8811674610E+00, 3.0326916671E-01, 2.7347964908E-01, 5.7024487376E-01],
	[1.1215000000E+04, 5.2900795931E+00, 5.8805951363E+00, 3.0369470098E-01, 2.7383272872E-01, 5.7039898249E-01],
	[1.1220000000E+04, 5.2931859258E+00, 5.8800231224E+00, 3.0412064181E-01, 2.7418607148E-01, 5.7055306803E-01],
	[1.1225000000E+04, 5.2962926973E+00, 5.8794514189E+00, 3.0454698942E-01, 2.7453967736E-01, 5.7070713037E-01],
	[1.1230000000E+04, 5.2993999075E+00, 5.8788800256E+00, 3.0497374401E-01, 2.7489354636E-01, 5.7086116952E-01],
	[1.1235000000E+04, 5.3025075563E+00, 5.8783089421E+00, 3.0540090578E-01, 2.7524767845E-01, 5.7101518548E-01],
	[1.1240000000E+04, 5.3056156435E+00, 5.8777381681E+00, 3.0582847494E-01, 2.7560207364E-01, 5.7116917825E-01],
	[1.1245000000E+04, 5.3087241691E+00, 5.8771677034E+00, 3.0625645170E-01, 2.7595673190E-01, 5.7132314784E-01],
	[1.1250000000E+04, 5.3118331328E+00, 5.8765975476E+00, 3.0668483626E-01, 2.7631165325E-01, 5.7147709424E-01],
	[1.1255000000E+04, 5.3149425345E+00, 5.8760277004E+00, 3.0711362883E-01, 2.7666683765E-01, 5.7163101745E-01],
	[1.1260000000E+04, 5.3180523742E+00, 5.8754581616E+00, 3.0754282962E-01, 2.7702228511E-01, 5.7178491749E-01],
	[1.1265000000E+04, 5.3211626517E+00, 5.8748889307E+00, 3.0797243883E-01, 2.7737799561E-01, 5.7193879434E-01],
	[1.1270000000E+04, 5.3242733668E+00, 5.8743200076E+00, 3.0840245667E-01, 2.7773396915E-01, 5.7209264802E-01],
	[1.1275000000E+04, 5.3273845194E+00, 5.8737513919E+00, 3.0883288334E-01, 2.7809020571E-01, 5.7224647852E-01],
	[1.1280000000E+04, 5.3304961094E+00, 5.8731830832E+00, 3.0926371906E-01, 2.7844670528E-01, 5.7240028584E-01],
	[1.1285000000E+04, 5.3336081366E+00, 5.8726150814E+00, 3.0969496402E-01, 2.7880346786E-01, 5.7255406999E-01],
	[1.1290000000E+04, 5.3367206009E+00, 5.8720473861E+00, 3.1012661844E-01, 2.7916049342E-01, 5.7270783097E-01],
	[1.1295000000E+04, 5.3398387864E+00, 5.8714885901E+00, 3.1055868252E-01, 2.7951781592E-01, 5.7286156874E-01],
	[1.1300000000E+04, 5.3429574419E+00, 5.8709301423E+00, 3.1099115647E-01, 2.7987540172E-01, 5.7301528329E-01],
	[1.1305000000E+04, 5.3460765379E+00, 5.8703719945E+00, 3.1142404049E-01, 2.8023325063E-01, 5.7316897459E-01],
	[1.1310000000E+04, 5.3491960744E+00, 5.8698141466E+00, 3.1185733480E-01, 2.8059136263E-01, 5.7332264265E-01],
	[1.1315000000E+04, 5.3523160512E+00, 5.8692565983E+00, 3.1229103959E-01, 2.8094973771E-01, 5.7347628745E-01],
	[1.1320000000E+04, 5.3554364681E+00, 5.8686993492E+00, 3.1272515508E-01, 2.8130837585E-01, 5.7362990897E-01],
	[1.1325000000E+04, 5.3585573251E+00, 5.8681423990E+00, 3.1315968146E-01, 2.8166727706E-01, 5.7378350721E-01],
	[1.1330000000E+04, 5.3616786220E+00, 5.8675857475E+00, 3.1359461896E-01, 2.8202644131E-01, 5.7393708216E-01],
	[1.1335000000E+04, 5.3648003586E+00, 5.8670293944E+00, 3.1402996776E-01, 2.8238586859E-01, 5.7409063381E-01],
	[1.1340000000E+04, 5.3679225349E+00, 5.8664733393E+00, 3.1446572809E-01, 2.8274555889E-01, 5.7424416214E-01],
	[1.1345000000E+04, 5.3710451508E+00, 5.8659175820E+00, 3.1490190015E-01, 2.8310551220E-01, 5.7439766715E-01],
	[1.1350000000E+04, 5.3741682059E+00, 5.8653621223E+00, 3.1533848413E-01, 2.8346572850E-01, 5.7455114882E-01],
	[1.1355000000E+04, 5.3772917004E+00, 5.8648069597E+00, 3.1577548026E-01, 2.8382620778E-01, 5.7470460715E-01],
	[1.1360000000E+04, 5.3804156339E+00, 5.8642520941E+00, 3.1621288874E-01, 2.8418695004E-01, 5.7485804212E-01],
	[1.1365000000E+04, 5.3835400064E+00, 5.8636975250E+00, 3.1665070977E-01, 2.8454795524E-01, 5.7501145372E-01],
	[1.1370000000E+04, 5.3866648178E+00, 5.8631432523E+00, 3.1708894356E-01, 2.8490922339E-01, 5.7516484195E-01],
	[1.1375000000E+04, 5.3897900679E+00, 5.8625892757E+00, 3.1752759031E-01, 2.8527075447E-01, 5.7531820679E-01],
	[1.1380000000E+04, 5.3929157565E+00, 5.8620355948E+00, 3.1796665024E-01, 2.8563254845E-01, 5.7547154823E-01],
	[1.1385000000E+04, 5.3960418837E+00, 5.8614822094E+00, 3.1840612355E-01, 2.8599460534E-01, 5.7562486626E-01],
	[1.1390000000E+04, 5.3991684491E+00, 5.8609291192E+00, 3.1884601045E-01, 2.8635692511E-01, 5.7577816088E-01],
	[1.1395000000E+04, 5.4022954528E+00, 5.8603763239E+00, 3.1928631114E-01, 2.8671950776E-01, 5.7593143207E-01],
	[1.1400000000E+04, 5.4054228945E+00, 5.8598238232E+00, 3.1972702583E-01, 2.8708235325E-01, 5.7608467982E-01],
	[1.1405000000E+04, 5.4085507741E+00, 5.8592716168E+00, 3.2016815473E-01, 2.8744546159E-01, 5.7623790412E-01],
	[1.1410000000E+04, 5.4116790916E+00, 5.8587197044E+00, 3.2060969805E-01, 2.8780883275E-01, 5.7639110496E-01],
	[1.1415000000E+04, 5.4148078467E+00, 5.8581680859E+00, 3.2105165598E-01, 2.8817246673E-01, 5.7654428233E-01],
	[1.1420000000E+04, 5.4179370393E+00, 5.8576167607E+00, 3.2149402874E-01, 2.8853636349E-01, 5.7669743623E-01],
	[1.1425000000E+04, 5.4210666694E+00, 5.8570657288E+00, 3.2193681654E-01, 2.8890052304E-01, 5.7685056663E-01],
	[1.1430000000E+04, 5.4241967367E+00, 5.8565149898E+00, 3.2238001958E-01, 2.8926494535E-01, 5.7700367354E-01],
	[1.1435000000E+04, 5.4273272412E+00, 5.8559645434E+00, 3.2282363806E-01, 2.8962963040E-01, 5.7715675694E-01],
	[1.1440000000E+04, 5.4304581827E+00, 5.8554143893E+00, 3.2326767221E-01, 2.8999457818E-01, 5.7730981682E-01],
	[1.1445000000E+04, 5.4335895611E+00, 5.8548645272E+00, 3.2371212221E-01, 2.9035978868E-01, 5.7746285317E-01],
	[1.1450000000E+04, 5.4367213762E+00, 5.8543149570E+00, 3.2415698828E-01, 2.9072526188E-01, 5.7761586599E-01],
	[1.1455000000E+04, 5.4398536280E+00, 5.8537656782E+00, 3.2460227063E-01, 2.9109099775E-01, 5.7776885525E-01],
	[1.1460000000E+04, 5.4429863163E+00, 5.8532166906E+00, 3.2504796946E-01, 2.9145699629E-01, 5.7792182096E-01],
	[1.1465000000E+04, 5.4461194410E+00, 5.8526679940E+00, 3.2549408498E-01, 2.9182325748E-01, 5.7807476311E-01],
	[1.1470000000E+04, 5.4492530018E+00, 5.8521195880E+00, 3.2594061739E-01, 2.9218978129E-01, 5.7822768167E-01],
	[1.1475000000E+04, 5.4523905519E+00, 5.8515768680E+00, 3.2638756691E-01, 2.9255659143E-01, 5.7838057665E-01],
	[1.1480000000E+04, 5.4555305081E+00, 5.8510374209E+00, 3.2683493374E-01, 2.9292367742E-01, 5.7853344804E-01],
	[1.1485000000E+04, 5.4586709041E+00, 5.8504982584E+00, 3.2728271808E-01, 2.9329102614E-01, 5.7868629581E-01],
	[1.1490000000E+04, 5.4618117399E+00, 5.8499593802E+00, 3.2773092015E-01, 2.9365863758E-01, 5.7883911998E-01],
	[1.1495000000E+04, 5.4649530151E+00, 5.8494207861E+00, 3.2817954015E-01, 2.9402651170E-01, 5.7899192052E-01],
	[1.1500000000E+04, 5.4680947297E+00, 5.8488824758E+00, 3.2862857829E-01, 2.9439464851E-01, 5.7914469742E-01],
	[1.1505000000E+04, 5.4712368837E+00, 5.8483444489E+00, 3.2907803478E-01, 2.9476304797E-01, 5.7929745068E-01],
	[1.1510000000E+04, 5.4743794767E+00, 5.8478067053E+00, 3.2952790981E-01, 2.9513171007E-01, 5.7945018029E-01],
	[1.1515000000E+04, 5.4775225088E+00, 5.8472692447E+00, 3.2997820361E-01, 2.9550063479E-01, 5.7960288624E-01],
	[1.1520000000E+04, 5.4806659798E+00, 5.8467320667E+00, 3.3042891637E-01, 2.9586982211E-01, 5.7975556852E-01],
	[1.1525000000E+04, 5.4838098896E+00, 5.8461951712E+00, 3.3088004830E-01, 2.9623927202E-01, 5.7990822712E-01],
	[1.1530000000E+04, 5.4869542379E+00, 5.8456585578E+00, 3.3133159962E-01, 2.9660898449E-01, 5.8006086203E-01],
	[1.1535000000E+04, 5.4900990248E+00, 5.8451222262E+00, 3.3178357052E-01, 2.9697895950E-01, 5.8021347324E-01],
	[1.1540000000E+04, 5.4932442501E+00, 5.8445861763E+00, 3.3223596121E-01, 2.9734919703E-01, 5.8036606074E-01],
	[1.1545000000E+04, 5.4963899136E+00, 5.8440504077E+00, 3.3268877191E-01, 2.9771969707E-01, 5.8051862452E-01],
	[1.1550000000E+04, 5.4995360152E+00, 5.8435149202E+00, 3.3314200282E-01, 2.9809045959E-01, 5.8067116458E-01],
	[1.1555000000E+04, 5.5026825548E+00, 5.8429797135E+00, 3.3359565414E-01, 2.9846148458E-01, 5.8082368091E-01],
	[1.1560000000E+04, 5.5058295322E+00, 5.8424447873E+00, 3.3404972608E-01, 2.9883277201E-01, 5.8097617349E-01],
	[1.1565000000E+04, 5.5089769474E+00, 5.8419101414E+00, 3.3450421885E-01, 2.9920432186E-01, 5.8112864232E-01],
	[1.1570000000E+04, 5.5121248002E+00, 5.8413757755E+00, 3.3495913266E-01, 2.9957613412E-01, 5.8128108738E-01],
	[1.1575000000E+04, 5.5152730905E+00, 5.8408416892E+00, 3.3541446772E-01, 2.9994820875E-01, 5.8143350868E-01],
	[1.1580000000E+04, 5.5184218181E+00, 5.8403078825E+00, 3.3587022423E-01, 3.0032054575E-01, 5.8158590620E-01],
	[1.1585000000E+04, 5.5215709829E+00, 5.8397743549E+00, 3.3632640239E-01, 3.0069314508E-01, 5.8173827993E-01],
	[1.1590000000E+04, 5.5247205848E+00, 5.8392411063E+00, 3.3678300242E-01, 3.0106600673E-01, 5.8189062986E-01],
	[1.1595000000E+04, 5.5278706237E+00, 5.8387081363E+00, 3.3724002452E-01, 3.0143913068E-01, 5.8204295599E-01],
	[1.1600000000E+04, 5.5310210994E+00, 5.8381754447E+00, 3.3769746891E-01, 3.0181251689E-01, 5.8219525830E-01],
	[1.1605000000E+04, 5.5341720118E+00, 5.8376430313E+00, 3.3815533578E-01, 3.0218616536E-01, 5.8234753679E-01],
	[1.1610000000E+04, 5.5373233608E+00, 5.8371108957E+00, 3.3861362534E-01, 3.0256007606E-01, 5.8249979145E-01],
	[1.1615000000E+04, 5.5404751463E+00, 5.8365790377E+00, 3.3907233781E-01, 3.0293424896E-01, 5.8265202226E-01],
	[1.1620000000E+04, 5.5436273680E+00, 5.8360474570E+00, 3.3953147339E-01, 3.0330868404E-01, 5.8280422923E-01],
	[1.1625000000E+04, 5.5467800260E+00, 5.8355161534E+00, 3.3999103228E-01, 3.0368338129E-01, 5.8295641235E-01],
	[1.1630000000E+04, 5.5499331200E+00, 5.8349851266E+00, 3.4045101469E-01, 3.0405834067E-01, 5.8310857159E-01],
	[1.1635000000E+04, 5.5530866500E+00, 5.8344543764E+00, 3.4091142084E-01, 3.0443356217E-01, 5.8326070696E-01],
	[1.1640000000E+04, 5.5562406158E+00, 5.8339239024E+00, 3.4137225093E-01, 3.0480904576E-01, 5.8341281845E-01],
	[1.1645000000E+04, 5.5593950172E+00, 5.8333937044E+00, 3.4183350516E-01, 3.0518479141E-01, 5.8356490605E-01],
	[1.1650000000E+04, 5.5625498543E+00, 5.8328637822E+00, 3.4229518374E-01, 3.0556079911E-01, 5.8371696975E-01],
	[1.1655000000E+04, 5.5657051267E+00, 5.8323341355E+00, 3.4275728689E-01, 3.0593706883E-01, 5.8386900955E-01],
	[1.1660000000E+04, 5.5688648890E+00, 5.8318105178E+00, 3.4321981480E-01, 3.0631362868E-01, 5.8402102542E-01],
	[1.1665000000E+04, 5.5720267650E+00, 5.8312895478E+00, 3.4368276768E-01, 3.0669046227E-01, 5.8417301738E-01],
	[1.1670000000E+04, 5.5751890801E+00, 5.8307688476E+00, 3.4414614575E-01, 3.0706755796E-01, 5.8432498540E-01],
	[1.1675000000E+04, 5.5783518341E+00, 5.8302484169E+00, 3.4460994921E-01, 3.0744491574E-01, 5.8447692948E-01],
	[1.1680000000E+04, 5.5815150270E+00, 5.8297282554E+00, 3.4507417827E-01, 3.0782253558E-01, 5.8462884961E-01],
	[1.1685000000E+04, 5.5846786585E+00, 5.8292083630E+00, 3.4553883313E-01, 3.0820041746E-01, 5.8478074578E-01],
	[1.1690000000E+04, 5.5878427287E+00, 5.8286887393E+00, 3.4600391400E-01, 3.0857856135E-01, 5.8493261799E-01],
	[1.1695000000E+04, 5.5910072373E+00, 5.8281693841E+00, 3.4646942109E-01, 3.0895696722E-01, 5.8508446623E-01],
	[1.1700000000E+04, 5.5941721843E+00, 5.8276502971E+00, 3.4693535461E-01, 3.0933563505E-01, 5.8523629049E-01],
	[1.1705000000E+04, 5.5973375695E+00, 5.8271314781E+00, 3.4740171477E-01, 3.0971456482E-01, 5.8538809075E-01],
	[1.1710000000E+04, 5.6005033927E+00, 5.8266129269E+00, 3.4786850176E-01, 3.1009375649E-01, 5.8553986702E-01],
	[1.1715000000E+04, 5.6036696539E+00, 5.8260946431E+00, 3.4833571581E-01, 3.1047321005E-01, 5.8569161929E-01],
	[1.1720000000E+04, 5.6068363530E+00, 5.8255766266E+00, 3.4880335711E-01, 3.1085292547E-01, 5.8584334754E-01],
	[1.1725000000E+04, 5.6100034897E+00, 5.8250588770E+00, 3.4927142587E-01, 3.1123290271E-01, 5.8599505178E-01],
	[1.1730000000E+04, 5.6131710640E+00, 5.8245413942E+00, 3.4973992231E-01, 3.1161314176E-01, 5.8614673199E-01],
	[1.1735000000E+04, 5.6163390758E+00, 5.8240241779E+00, 3.5020884663E-01, 3.1199364259E-01, 5.8629838816E-01],
	[1.1740000000E+04, 5.6195075248E+00, 5.8235072277E+00, 3.5067819903E-01, 3.1237440517E-01, 5.8645002028E-01],
	[1.1745000000E+04, 5.6226764111E+00, 5.8229905436E+00, 3.5114797973E-01, 3.1275542947E-01, 5.8660162836E-01],
	[1.1750000000E+04, 5.6258457345E+00, 5.8224741252E+00, 3.5161818893E-01, 3.1313671546E-01, 5.8675321237E-01],
	[1.1755000000E+04, 5.6290154948E+00, 5.8219579722E+00, 3.5208882684E-01, 3.1351826313E-01, 5.8690477232E-01],
	[1.1760000000E+04, 5.6321856919E+00, 5.8214420845E+00, 3.5255989367E-01, 3.1390007243E-01, 5.8705630820E-01],
	[1.1765000000E+04, 5.6353563257E+00, 5.8209264618E+00, 3.5303138962E-01, 3.1428214335E-01, 5.8720781999E-01],
	[1.1770000000E+04, 5.6385273960E+00, 5.8204111037E+00, 3.5350331490E-01, 3.1466447586E-01, 5.8735930770E-01],
	[1.1775000000E+04, 5.6416989029E+00, 5.8198960102E+00, 3.5397566973E-01, 3.1504706992E-01, 5.8751077131E-01],
	[1.1780000000E+04, 5.6448708460E+00, 5.8193811809E+00, 3.5444845430E-01, 3.1542992551E-01, 5.8766221081E-01],
	[1.1785000000E+04, 5.6480432253E+00, 5.8188666156E+00, 3.5492166882E-01, 3.1581304260E-01, 5.8781362621E-01],
	[1.1790000000E+04, 5.6512160407E+00, 5.8183523140E+00, 3.5539531351E-01, 3.1619642117E-01, 5.8796501748E-01],
	[1.1795000000E+04, 5.6543892921E+00, 5.8178382759E+00, 3.5586938857E-01, 3.1658006117E-01, 5.8811638463E-01],
	[1.1800000000E+04, 5.6575629792E+00, 5.8173245011E+00, 3.5634389421E-01, 3.1696396259E-01, 5.8826772764E-01],
	[1.1805000000E+04, 5.6607371021E+00, 5.8168109892E+00, 3.5681883064E-01, 3.1734812540E-01, 5.8841904651E-01],
	[1.1810000000E+04, 5.6639116605E+00, 5.8162977401E+00, 3.5729419806E-01, 3.1773254956E-01, 5.8857034124E-01],
	[1.1815000000E+04, 5.6670866543E+00, 5.8157847536E+00, 3.5776999668E-01, 3.1811723504E-01, 5.8872161181E-01],
	[1.1820000000E+04, 5.6702620835E+00, 5.8152720292E+00, 3.5824622671E-01, 3.1850218182E-01, 5.8887285821E-01],
	[1.1825000000E+04, 5.6734379479E+00, 5.8147595669E+00, 3.5872288835E-01, 3.1888738986E-01, 5.8902408045E-01],
	[1.1830000000E+04, 5.6766142473E+00, 5.8142473664E+00, 3.5919998182E-01, 3.1927285914E-01, 5.8917527851E-01],
	[1.1835000000E+04, 5.6797909817E+00, 5.8137354274E+00, 3.5967750732E-01, 3.1965858963E-01, 5.8932645238E-01],
	[1.1840000000E+04, 5.6829681509E+00, 5.8132237496E+00, 3.6015546507E-01, 3.2004458129E-01, 5.8947760207E-01],
	[1.1845000000E+04, 5.6861468063E+00, 5.8127137291E+00, 3.6063385526E-01, 3.2043084167E-01, 5.8962872756E-01],
	[1.1850000000E+04, 5.6893307874E+00, 5.8122104576E+00, 3.6111267810E-01, 3.2081739852E-01, 5.8977982884E-01],
	[1.1855000000E+04, 5.6925152070E+00, 5.8117074419E+00, 3.6159193381E-01, 3.2120421662E-01, 5.8993090590E-01],
	[1.1860000000E+04, 5.6957000651E+00, 5.8112046818E+00, 3.6207162260E-01, 3.2159129594E-01, 5.9008195875E-01],
	[1.1865000000E+04, 5.6988853615E+00, 5.8107021771E+00, 3.6255174466E-01, 3.2197863645E-01, 5.9023298738E-01],
	[1.1870000000E+04, 5.7020710961E+00, 5.8101999276E+00, 3.6303230020E-01, 3.2236623812E-01, 5.9038399177E-01],
	[1.1875000000E+04, 5.7052572689E+00, 5.8096979329E+00, 3.6351328945E-01, 3.2275410092E-01, 5.9053497192E-01],
	[1.1880000000E+04, 5.7084438796E+00, 5.8091961929E+00, 3.6399471259E-01, 3.2314222482E-01, 5.9068592782E-01],
	[1.1885000000E+04, 5.7116309281E+00, 5.8086947073E+00, 3.6447656985E-01, 3.2353060978E-01, 5.9083685947E-01],
	[1.1890000000E+04, 5.7148184144E+00, 5.8081934760E+00, 3.6495886142E-01, 3.2391925578E-01, 5.9098776686E-01],
	[1.1895000000E+04, 5.7180063382E+00, 5.8076924986E+00, 3.6544158752E-01, 3.2430816277E-01, 5.9113864999E-01],
	[1.1900000000E+04, 5.7211946995E+00, 5.8071917749E+00, 3.6592474835E-01, 3.2469733073E-01, 5.9128950884E-01],
	[1.1905000000E+04, 5.7243834982E+00, 5.8066913047E+00, 3.6640834413E-01, 3.2508675963E-01, 5.9144034339E-01],
	[1.1910000000E+04, 5.7275727340E+00, 5.8061910878E+00, 3.6689237506E-01, 3.2547644943E-01, 5.9159115361E-01],
	[1.1915000000E+04, 5.7307624070E+00, 5.8056911238E+00, 3.6737684134E-01, 3.2586640010E-01, 5.9174193950E-01],
	[1.1920000000E+04, 5.7339525170E+00, 5.8051914127E+00, 3.6786174319E-01, 3.2625661160E-01, 5.9189270103E-01],
	[1.1925000000E+04, 5.7371430638E+00, 5.8046919541E+00, 3.6834708082E-01, 3.2664708391E-01, 5.9204343819E-01],
	[1.1930000000E+04, 5.7403340473E+00, 5.8041927478E+00, 3.6883285443E-01, 3.2703781698E-01, 5.9219415096E-01],
	[1.1935000000E+04, 5.7435254674E+00, 5.8036937936E+00, 3.6931906422E-01, 3.2742881079E-01, 5.9234483933E-01],
	[1.1940000000E+04, 5.7467173240E+00, 5.8031950913E+00, 3.6980571042E-01, 3.2782006531E-01, 5.9249550328E-01],
	[1.1945000000E+04, 5.7499096170E+00, 5.8026966406E+00, 3.7029279322E-01, 3.2821158049E-01, 5.9264614280E-01],
	[1.1950000000E+04, 5.7531023462E+00, 5.8021984413E+00, 3.7078031283E-01, 3.2860335630E-01, 5.9279675787E-01],
	[1.1955000000E+04, 5.7562955115E+00, 5.8017004931E+00, 3.7126826947E-01, 3.2899539271E-01, 5.9294734847E-01],
	[1.1960000000E+04, 5.7594891128E+00, 5.8012027958E+00, 3.7175666334E-01, 3.2938768968E-01, 5.9309791460E-01],
	[1.1965000000E+04, 5.7626831499E+00, 5.8007053493E+00, 3.7224549464E-01, 3.2978024718E-01, 5.9324845623E-01],
	[1.1970000000E+04, 5.7658776228E+00, 5.8002081532E+00, 3.7273476359E-01, 3.3017306518E-01, 5.9339897335E-01],
	[1.1975000000E+04, 5.7690725314E+00, 5.7997112073E+00, 3.7322447040E-01, 3.3056614363E-01, 5.9354946595E-01],
	[1.1980000000E+04, 5.7722678754E+00, 5.7992145114E+00, 3.7371461526E-01, 3.3095948251E-01, 5.9369993400E-01],
	[1.1985000000E+04, 5.7754636548E+00, 5.7987180653E+00, 3.7420519840E-01, 3.3135308177E-01, 5.9385037750E-01],
	[1.1990000000E+04, 5.7786598694E+00, 5.7982218688E+00, 3.7469622002E-01, 3.3174694139E-01, 5.9400079643E-01],
	[1.1995000000E+04, 5.7818565192E+00, 5.7977259215E+00, 3.7518768032E-01, 3.3214106132E-01, 5.9415119078E-01],
	[1.2000000000E+04, 5.7850536040E+00, 5.7972302234E+00, 3.7567957952E-01, 3.3253544153E-01, 5.9430156052E-01],
	[1.2005000000E+04, 5.7882511237E+00, 5.7967347740E+00, 3.7617191782E-01, 3.3293008198E-01, 5.9445190565E-01],
	[1.2010000000E+04, 5.7914490781E+00, 5.7962395734E+00, 3.7666469543E-01, 3.3332498264E-01, 5.9460222615E-01],
	[1.2015000000E+04, 5.7946474672E+00, 5.7957446211E+00, 3.7715791256E-01, 3.3372014347E-01, 5.9475252200E-01],
	[1.2020000000E+04, 5.7978462908E+00, 5.7952499169E+00, 3.7765156942E-01, 3.3411556443E-01, 5.9490279320E-01],
	[1.2025000000E+04, 5.8010455488E+00, 5.7947554608E+00, 3.7814566621E-01, 3.3451124548E-01, 5.9505303971E-01],
	[1.2030000000E+04, 5.8042452411E+00, 5.7942612523E+00, 3.7864020315E-01, 3.3490718659E-01, 5.9520326154E-01],
	[1.2035000000E+04, 5.8074456272E+00, 5.7937676140E+00, 3.7913518044E-01, 3.3530338967E-01, 5.9535345867E-01],
	[1.2040000000E+04, 5.8106523436E+00, 5.7932815473E+00, 3.7963059829E-01, 3.3569989702E-01, 5.9550363108E-01],
	[1.2045000000E+04, 5.8138594982E+00, 5.7927957231E+00, 3.8012645691E-01, 3.3609666449E-01, 5.9565377875E-01],
	[1.2050000000E+04, 5.8170670908E+00, 5.7923101412E+00, 3.8062275651E-01, 3.3649369205E-01, 5.9580390167E-01],
	[1.2055000000E+04, 5.8202751213E+00, 5.7918248015E+00, 3.8111949729E-01, 3.3689097966E-01, 5.9595399983E-01],
	[1.2060000000E+04, 5.8234835896E+00, 5.7913397036E+00, 3.8161667946E-01, 3.3728852728E-01, 5.9610407322E-01],
	[1.2065000000E+04, 5.8266924955E+00, 5.7908548475E+00, 3.8211430324E-01, 3.3768633487E-01, 5.9625412181E-01],
	[1.2070000000E+04, 5.8299018390E+00, 5.7903702328E+00, 3.8261236882E-01, 3.3808440240E-01, 5.9640414560E-01],
	[1.2075000000E+04, 5.8331116199E+00, 5.7898858593E+00, 3.8311087642E-01, 3.3848272983E-01, 5.9655414456E-01],
	[1.2080000000E+04, 5.8363218381E+00, 5.7894017269E+00, 3.8360982625E-01, 3.3888131712E-01, 5.9670411869E-01],
	[1.2085000000E+04, 5.8395324934E+00, 5.7889178352E+00, 3.8410921852E-01, 3.3928016422E-01, 5.9685406798E-01],
	[1.2090000000E+04, 5.8427435858E+00, 5.7884341842E+00, 3.8460905343E-01, 3.3967927111E-01, 5.9700399239E-01],
	[1.2095000000E+04, 5.8459551152E+00, 5.7879507735E+00, 3.8510933118E-01, 3.4007863773E-01, 5.9715389193E-01],
	[1.2100000000E+04, 5.8491670813E+00, 5.7874676029E+00, 3.8561005200E-01, 3.4047826406E-01, 5.9730376658E-01],
	[1.2105000000E+04, 5.8523794841E+00, 5.7869846723E+00, 3.8611121609E-01, 3.4087815005E-01, 5.9745361632E-01],
	[1.2110000000E+04, 5.8555923235E+00, 5.7865019814E+00, 3.8661282365E-01, 3.4127829566E-01, 5.9760344114E-01],
	[1.2115000000E+04, 5.8588055993E+00, 5.7860195300E+00, 3.8711487490E-01, 3.4167870085E-01, 5.9775324103E-01],
	[1.2120000000E+04, 5.8620193115E+00, 5.7855373178E+00, 3.8761737004E-01, 3.4207936559E-01, 5.9790301597E-01],
	[1.2125000000E+04, 5.8652334598E+00, 5.7850553447E+00, 3.8812030929E-01, 3.4248028982E-01, 5.9805276594E-01],
	[1.2130000000E+04, 5.8684480442E+00, 5.7845736105E+00, 3.8862369284E-01, 3.4288147352E-01, 5.9820249094E-01],
	[1.2135000000E+04, 5.8716630646E+00, 5.7840921148E+00, 3.8912752091E-01, 3.4328291663E-01, 5.9835219095E-01],
	[1.2140000000E+04, 5.8748785209E+00, 5.7836108576E+00, 3.8963179371E-01, 3.4368461912E-01, 5.9850186595E-01],
	[1.2145000000E+04, 5.8780944128E+00, 5.7831298385E+00, 3.9013651145E-01, 3.4408658095E-01, 5.9865151593E-01],
	[1.2150000000E+04, 5.8813107404E+00, 5.7826490575E+00, 3.9064167433E-01, 3.4448880208E-01, 5.9880114089E-01],
	[1.2155000000E+04, 5.8845275034E+00, 5.7821685142E+00, 3.9114728256E-01, 3.4489128246E-01, 5.9895074079E-01],
	[1.2160000000E+04, 5.8877447018E+00, 5.7816882084E+00, 3.9165333635E-01, 3.4529402205E-01, 5.9910031564E-01],
	[1.2165000000E+04, 5.8909623354E+00, 5.7812081399E+00, 3.9215983591E-01, 3.4569702081E-01, 5.9924986541E-01],
	[1.2170000000E+04, 5.8941804041E+00, 5.7807283086E+00, 3.9266678145E-01, 3.4610027870E-01, 5.9939939009E-01],
	[1.2175000000E+04, 5.8973989079E+00, 5.7802487141E+00, 3.9317417318E-01, 3.4650379567E-01, 5.9954888968E-01],
	[1.2180000000E+04, 5.9006178465E+00, 5.7797693564E+00, 3.9368201130E-01, 3.4690757169E-01, 5.9969836414E-01],
	[1.2185000000E+04, 5.9038372199E+00, 5.7792902351E+00, 3.9419029603E-01, 3.4731160671E-01, 5.9984781348E-01],
	[1.2190000000E+04, 5.9070570279E+00, 5.7788113501E+00, 3.9469902756E-01, 3.4771590069E-01, 5.9999723768E-01],
	[1.2195000000E+04, 5.9102772704E+00, 5.7783327011E+00, 3.9520820612E-01, 3.4812045359E-01, 6.0014663672E-01],
	[1.2200000000E+04, 5.9134979473E+00, 5.7778542879E+00, 3.9571783191E-01, 3.4852526535E-01, 6.0029601060E-01],
	[1.2205000000E+04, 5.9167190585E+00, 5.7773761104E+00, 3.9622790513E-01, 3.4893033594E-01, 6.0044535929E-01],
	[1.2210000000E+04, 5.9199406039E+00, 5.7768981682E+00, 3.9673842601E-01, 3.4933566532E-01, 6.0059468278E-01],
	[1.2215000000E+04, 5.9231625833E+00, 5.7764204613E+00, 3.9724939473E-01, 3.4974125344E-01, 6.0074398107E-01],
	[1.2220000000E+04, 5.9263849967E+00, 5.7759429893E+00, 3.9776081152E-01, 3.5014710025E-01, 6.0089325413E-01],
	[1.2225000000E+04, 5.9296078438E+00, 5.7754657521E+00, 3.9827267659E-01, 3.5055320572E-01, 6.0104250196E-01],
	[1.2230000000E+04, 5.9328329940E+00, 5.7749909260E+00, 3.9878499013E-01, 3.5095958438E-01, 6.0119172454E-01],
	[1.2235000000E+04, 5.9360630818E+00, 5.7745215721E+00, 3.9929775237E-01, 3.5136625682E-01, 6.0134092185E-01],
	[1.2240000000E+04, 5.9392936073E+00, 5.7740524482E+00, 3.9981096350E-01, 3.5177318798E-01, 6.0149009389E-01],
	[1.2245000000E+04, 5.9425245705E+00, 5.7735835539E+00, 4.0032462374E-01, 3.5218037781E-01, 6.0163924064E-01],
	[1.2250000000E+04, 5.9457559712E+00, 5.7731148890E+00, 4.0083873329E-01, 3.5258782625E-01, 6.0178836209E-01],
	[1.2255000000E+04, 5.9489878093E+00, 5.7726464535E+00, 4.0135329237E-01, 3.5299553327E-01, 6.0193745823E-01],
	[1.2260000000E+04, 5.9522200847E+00, 5.7721782470E+00, 4.0186830118E-01, 3.5340349882E-01, 6.0208652903E-01],
	[1.2265000000E+04, 5.9554527973E+00, 5.7717102694E+00, 4.0238375994E-01, 3.5381172285E-01, 6.0223557450E-01],
	[1.2270000000E+04, 5.9586859469E+00, 5.7712425205E+00, 4.0289966884E-01, 3.5422020533E-01, 6.0238459461E-01],
	[1.2275000000E+04, 5.9619195335E+00, 5.7707749999E+00, 4.0341602811E-01, 3.5462894620E-01, 6.0253358935E-01],
	[1.2280000000E+04, 5.9651535568E+00, 5.7703077077E+00, 4.0393283794E-01, 3.5503794541E-01, 6.0268255872E-01],
	[1.2285000000E+04, 5.9683880169E+00, 5.7698406435E+00, 4.0445009855E-01, 3.5544720293E-01, 6.0283150269E-01],
	[1.2290000000E+04, 5.9716229136E+00, 5.7693738071E+00, 4.0496781015E-01, 3.5585671871E-01, 6.0298042125E-01],
	[1.2295000000E+04, 5.9748582467E+00, 5.7689071984E+00, 4.0548597294E-01, 3.5626649269E-01, 6.0312931440E-01],
	[1.2300000000E+04, 5.9780940161E+00, 5.7684408170E+00, 4.0600458713E-01, 3.5667652484E-01, 6.0327818211E-01],
	[1.2305000000E+04, 5.9813302218E+00, 5.7679746630E+00, 4.0652365293E-01, 3.5708681510E-01, 6.0342702438E-01],
	[1.2310000000E+04, 5.9845668636E+00, 5.7675087359E+00, 4.0704317056E-01, 3.5749736344E-01, 6.0357584120E-01],
	[1.2315000000E+04, 5.9878039414E+00, 5.7670430357E+00, 4.0756314022E-01, 3.5790816979E-01, 6.0372463254E-01],
	[1.2320000000E+04, 5.9910414550E+00, 5.7665775621E+00, 4.0808356211E-01, 3.5831923413E-01, 6.0387339841E-01],
	[1.2325000000E+04, 5.9942794044E+00, 5.7661123149E+00, 4.0860443645E-01, 3.5873055639E-01, 6.0402213877E-01],
	[1.2330000000E+04, 5.9975177894E+00, 5.7656472939E+00, 4.0912576345E-01, 3.5914213653E-01, 6.0417085363E-01],
	[1.2335000000E+04, 6.0007566099E+00, 5.7651824989E+00, 4.0964754331E-01, 3.5955397450E-01, 6.0431954297E-01],
	[1.2340000000E+04, 6.0039958659E+00, 5.7647179298E+00, 4.1016977625E-01, 3.5996607026E-01, 6.0446820678E-01],
	[1.2345000000E+04, 6.0072355571E+00, 5.7642535862E+00, 4.1069246247E-01, 3.6037842375E-01, 6.0461684505E-01],
	[1.2350000000E+04, 6.0104756834E+00, 5.7637894681E+00, 4.1121560218E-01, 3.6079103493E-01, 6.0476545775E-01],
	[1.2355000000E+04, 6.0137162448E+00, 5.7633255752E+00, 4.1173919560E-01, 3.6120390375E-01, 6.0491404489E-01],
	[1.2360000000E+04, 6.0169572412E+00, 5.7628619073E+00, 4.1226324292E-01, 3.6161703016E-01, 6.0506260644E-01],
	[1.2365000000E+04, 6.0201986723E+00, 5.7623984642E+00, 4.1278774436E-01, 3.6203041411E-01, 6.0521114240E-01],
	[1.2370000000E+04, 6.0234405381E+00, 5.7619352457E+00, 4.1331270013E-01, 3.6244405555E-01, 6.0535965276E-01],
	[1.2375000000E+04, 6.0266828385E+00, 5.7614722516E+00, 4.1383811043E-01, 3.6285795444E-01, 6.0550813749E-01],
	[1.2380000000E+04, 6.0299255734E+00, 5.7610094818E+00, 4.1436397549E-01, 3.6327211072E-01, 6.0565659659E-01],
	[1.2385000000E+04, 6.0331687425E+00, 5.7605469359E+00, 4.1489029549E-01, 3.6368652435E-01, 6.0580503006E-01],
	[1.2390000000E+04, 6.0364123459E+00, 5.7600846139E+00, 4.1541707066E-01, 3.6410119527E-01, 6.0595343786E-01],
	[1.2395000000E+04, 6.0396563834E+00, 5.7596225154E+00, 4.1594430120E-01, 3.6451612343E-01, 6.0610182000E-01],
	[1.2400000000E+04, 6.0429008549E+00, 5.7591606404E+00, 4.1647198733E-01, 3.6493130879E-01, 6.0625017645E-01],
	[1.2405000000E+04, 6.0461457603E+00, 5.7586989887E+00, 4.1700012924E-01, 3.6534675129E-01, 6.0639850722E-01],
	[1.2410000000E+04, 6.0493910994E+00, 5.7582375599E+00, 4.1752872716E-01, 3.6576245088E-01, 6.0654681228E-01],
	[1.2415000000E+04, 6.0526368721E+00, 5.7577763539E+00, 4.1805778128E-01, 3.6617840752E-01, 6.0669509163E-01],
	[1.2420000000E+04, 6.0558830784E+00, 5.7573153706E+00, 4.1858729182E-01, 3.6659462115E-01, 6.0684334525E-01],
	[1.2425000000E+04, 6.0591297180E+00, 5.7568546097E+00, 4.1911725899E-01, 3.6701109171E-01, 6.0699157313E-01],
	[1.2430000000E+04, 6.0623828684E+00, 5.7564006971E+00, 4.1964768299E-01, 3.6742786849E-01, 6.0713977525E-01],
	[1.2435000000E+04, 6.0656369781E+00, 5.7559475718E+00, 4.2017856404E-01, 3.6784490653E-01, 6.0728795162E-01],
	[1.2440000000E+04, 6.0688915253E+00, 5.7554946643E+00, 4.2070990234E-01, 3.6826220156E-01, 6.0743610221E-01],
	[1.2445000000E+04, 6.0721465098E+00, 5.7550419744E+00, 4.2124169811E-01, 3.6867975352E-01, 6.0758422701E-01],
	[1.2450000000E+04, 6.0754019316E+00, 5.7545895019E+00, 4.2177395155E-01, 3.6909756237E-01, 6.0773232601E-01],
	[1.2455000000E+04, 6.0786577906E+00, 5.7541372467E+00, 4.2230666287E-01, 3.6951562805E-01, 6.0788039920E-01],
	[1.2460000000E+04, 6.0819140865E+00, 5.7536852085E+00, 4.2283983228E-01, 3.6993395050E-01, 6.0802844657E-01],
	[1.2465000000E+04, 6.0851708193E+00, 5.7532333872E+00, 4.2337345999E-01, 3.7035252969E-01, 6.0817646811E-01],
	[1.2470000000E+04, 6.0884279889E+00, 5.7527817825E+00, 4.2390754621E-01, 3.7077136555E-01, 6.0832446380E-01],
	[1.2475000000E+04, 6.0916855951E+00, 5.7523303943E+00, 4.2444209115E-01, 3.7119045803E-01, 6.0847243364E-01],
	[1.2480000000E+04, 6.0949436379E+00, 5.7518792223E+00, 4.2497709501E-01, 3.7160980708E-01, 6.0862037760E-01],
	[1.2485000000E+04, 6.0982021171E+00, 5.7514282664E+00, 4.2551255802E-01, 3.7202941265E-01, 6.0876829574E-01],
	[1.2490000000E+04, 6.1014610326E+00, 5.7509775265E+00, 4.2604848036E-01, 3.7244927468E-01, 6.0891618811E-01],
	[1.2495000000E+04, 6.1047203843E+00, 5.7505270022E+00, 4.2658486227E-01, 3.7286939312E-01, 6.0906405469E-01],
	[1.2500000000E+04, 6.1079801720E+00, 5.7500766935E+00, 4.2712170393E-01, 3.7328976792E-01, 6.0921189546E-01],
	[1.2505000000E+04, 6.1112403957E+00, 5.7496266001E+00, 4.2766017340E-01, 3.7371129079E-01, 6.0935971040E-01],
	[1.2510000000E+04, 6.1145010553E+00, 5.7491767218E+00, 4.2819910557E-01, 3.7413307137E-01, 6.0950749950E-01],
	[1.2515000000E+04, 6.1177621506E+00, 5.7487270585E+00, 4.2873850066E-01, 3.7455510960E-01, 6.0965526274E-01],
	[1.2520000000E+04, 6.1210236815E+00, 5.7482776100E+00, 4.2927835887E-01, 3.7497740543E-01, 6.0980300011E-01],
	[1.2525000000E+04, 6.1242856479E+00, 5.7478283760E+00, 4.2981868043E-01, 3.7539995880E-01, 6.0995071157E-01],
	[1.2530000000E+04, 6.1275480497E+00, 5.7473793564E+00, 4.3035946553E-01, 3.7582276967E-01, 6.1009839713E-01],
	[1.2535000000E+04, 6.1308108867E+00, 5.7469305510E+00, 4.3090071440E-01, 3.7624583797E-01, 6.1024605675E-01],
	[1.2540000000E+04, 6.1340741589E+00, 5.7464819596E+00, 4.3144242725E-01, 3.7666916365E-01, 6.1039369043E-01],
	[1.2545000000E+04, 6.1373378661E+00, 5.7460335821E+00, 4.3198460428E-01, 3.7709274665E-01, 6.1054129814E-01],
	[1.2550000000E+04, 6.1406020082E+00, 5.7455854181E+00, 4.3252724571E-01, 3.7751658693E-01, 6.1068887988E-01],
	[1.2555000000E+04, 6.1438665851E+00, 5.7451374677E+00, 4.3307035176E-01, 3.7794068442E-01, 6.1083643561E-01],
	[1.2560000000E+04, 6.1471315967E+00, 5.7446897305E+00, 4.3361392263E-01, 3.7836503908E-01, 6.1098396533E-01],
	[1.2565000000E+04, 6.1503970429E+00, 5.7442422063E+00, 4.3415795853E-01, 3.7878965083E-01, 6.1113146901E-01],
	[1.2570000000E+04, 6.1536629235E+00, 5.7437948951E+00, 4.3470245968E-01, 3.7921451964E-01, 6.1127894664E-01],
	[1.2575000000E+04, 6.1569292385E+00, 5.7433477965E+00, 4.3524742628E-01, 3.7963964544E-01, 6.1142639821E-01],
	[1.2580000000E+04, 6.1601959877E+00, 5.7429009105E+00, 4.3579285856E-01, 3.8006502817E-01, 6.1157382369E-01],
	[1.2585000000E+04, 6.1634631710E+00, 5.7424542368E+00, 4.3633875673E-01, 3.8049066779E-01, 6.1172122308E-01],
	[1.2590000000E+04, 6.1667307883E+00, 5.7420077753E+00, 4.3688512098E-01, 3.8091656423E-01, 6.1186859634E-01],
	[1.2595000000E+04, 6.1699988395E+00, 5.7415615257E+00, 4.3743195155E-01, 3.8134271743E-01, 6.1201594347E-01],
	[1.2600000000E+04, 6.1732673244E+00, 5.7411154879E+00, 4.3797924863E-01, 3.8176912734E-01, 6.1216326445E-01],
	[1.2605000000E+04, 6.1765362430E+00, 5.7406696617E+00, 4.3852701244E-01, 3.8219579391E-01, 6.1231055926E-01],
	[1.2610000000E+04, 6.1798055952E+00, 5.7402240469E+00, 4.3907524320E-01, 3.8262271707E-01, 6.1245782788E-01],
	[1.2615000000E+04, 6.1830753807E+00, 5.7397786434E+00, 4.3962394111E-01, 3.8304989677E-01, 6.1260507030E-01],
	[1.2620000000E+04, 6.1863455996E+00, 5.7393334509E+00, 4.4017310638E-01, 3.8347733295E-01, 6.1275228651E-01],
	[1.2625000000E+04, 6.1896162516E+00, 5.7388884692E+00, 4.4072273924E-01, 3.8390502555E-01, 6.1289947648E-01],
	[1.2630000000E+04, 6.1928936917E+00, 5.7384501357E+00, 4.4127283989E-01, 3.8433302787E-01, 6.1304664019E-01],
	[1.2635000000E+04, 6.1961721632E+00, 5.7380126108E+00, 4.4182340854E-01, 3.8476129169E-01, 6.1319377764E-01],
	[1.2640000000E+04, 6.1994510722E+00, 5.7375752923E+00, 4.4237444540E-01, 3.8518981196E-01, 6.1334088881E-01],
	[1.2645000000E+04, 6.2027304184E+00, 5.7371381801E+00, 4.4292595070E-01, 3.8561858864E-01, 6.1348797367E-01],
	[1.2650000000E+04, 6.2060102019E+00, 5.7367012739E+00, 4.4347792463E-01, 3.8604762167E-01, 6.1363503222E-01],
	[1.2655000000E+04, 6.2092904225E+00, 5.7362645737E+00, 4.4403036741E-01, 3.8647691098E-01, 6.1378206443E-01],
	[1.2660000000E+04, 6.2125710801E+00, 5.7358280792E+00, 4.4458327926E-01, 3.8690645652E-01, 6.1392907029E-01],
	[1.2665000000E+04, 6.2158521746E+00, 5.7353917903E+00, 4.4513666038E-01, 3.8733625823E-01, 6.1407604978E-01],
	[1.2670000000E+04, 6.2191337058E+00, 5.7349557067E+00, 4.4569051099E-01, 3.8776631605E-01, 6.1422300289E-01],
	[1.2675000000E+04, 6.2224156737E+00, 5.7345198283E+00, 4.4624483130E-01, 3.8819662992E-01, 6.1436992961E-01],
	[1.2680000000E+04, 6.2256980781E+00, 5.7340841550E+00, 4.4679962153E-01, 3.8862719978E-01, 6.1451682990E-01],
	[1.2685000000E+04, 6.2289809189E+00, 5.7336486865E+00, 4.4735488187E-01, 3.8905802557E-01, 6.1466370377E-01],
	[1.2690000000E+04, 6.2322641960E+00, 5.7332134226E+00, 4.4791061256E-01, 3.8948910723E-01, 6.1481055119E-01],
	[1.2695000000E+04, 6.2355479094E+00, 5.7327783633E+00, 4.4846681379E-01, 3.8992044470E-01, 6.1495737214E-01],
	[1.2700000000E+04, 6.2388320588E+00, 5.7323435082E+00, 4.4902348579E-01, 3.9035203793E-01, 6.1510416661E-01],
	[1.2705000000E+04, 6.2421166441E+00, 5.7319088573E+00, 4.4958062875E-01, 3.9078388684E-01, 6.1525093459E-01],
	[1.2710000000E+04, 6.2454016653E+00, 5.7314744104E+00, 4.5013824291E-01, 3.9121599139E-01, 6.1539767606E-01],
	[1.2715000000E+04, 6.2486871223E+00, 5.7310401672E+00, 4.5069632846E-01, 3.9164835151E-01, 6.1554439099E-01],
	[1.2720000000E+04, 6.2519730148E+00, 5.7306061276E+00, 4.5125488562E-01, 3.9208096713E-01, 6.1569107939E-01],
	[1.2725000000E+04, 6.2552593429E+00, 5.7301722915E+00, 4.5181391461E-01, 3.9251383821E-01, 6.1583774122E-01],
	[1.2730000000E+04, 6.2585461064E+00, 5.7297386586E+00, 4.5237341562E-01, 3.9294696467E-01, 6.1598437648E-01],
	[1.2735000000E+04, 6.2618333051E+00, 5.7293052288E+00, 4.5293338889E-01, 3.9338034645E-01, 6.1613098515E-01],
	[1.2740000000E+04, 6.2651209390E+00, 5.7288720020E+00, 4.5349383462E-01, 3.9381398350E-01, 6.1627756721E-01],
	[1.2745000000E+04, 6.2684090080E+00, 5.7284389778E+00, 4.5405475301E-01, 3.9424787575E-01, 6.1642412264E-01],
	[1.2750000000E+04, 6.2716975119E+00, 5.7280061562E+00, 4.5461614429E-01, 3.9468202314E-01, 6.1657065144E-01],
	[1.2755000000E+04, 6.2749864506E+00, 5.7275735370E+00, 4.5517800867E-01, 3.9511642561E-01, 6.1671715359E-01],
	[1.2760000000E+04, 6.2782758241E+00, 5.7271411200E+00, 4.5574034636E-01, 3.9555108309E-01, 6.1686362906E-01],
	[1.2765000000E+04, 6.2815656322E+00, 5.7267089050E+00, 4.5630315756E-01, 3.9598599553E-01, 6.1701007785E-01],
	[1.2770000000E+04, 6.2848558747E+00, 5.7262768919E+00, 4.5686644251E-01, 3.9642116286E-01, 6.1715649994E-01],
	[1.2775000000E+04, 6.2881465516E+00, 5.7258450805E+00, 4.5743020139E-01, 3.9685658501E-01, 6.1730289531E-01],
	[1.2780000000E+04, 6.2914376628E+00, 5.7254134706E+00, 4.5799443444E-01, 3.9729226193E-01, 6.1744926395E-01],
	[1.2785000000E+04, 6.2947292082E+00, 5.7249820621E+00, 4.5855914185E-01, 3.9772819354E-01, 6.1759560584E-01],
	[1.2790000000E+04, 6.2980211875E+00, 5.7245508547E+00, 4.5912432385E-01, 3.9816437980E-01, 6.1774192097E-01],
	[1.2795000000E+04, 6.3013136009E+00, 5.7241198483E+00, 4.5968998065E-01, 3.9860082063E-01, 6.1788820932E-01],
	[1.2800000000E+04, 6.3046064480E+00, 5.7236890428E+00, 4.6025611245E-01, 3.9903751597E-01, 6.1803447088E-01],
	[1.2805000000E+04, 6.3078997288E+00, 5.7232584379E+00, 4.6082271947E-01, 3.9947446575E-01, 6.1818070563E-01],
	[1.2810000000E+04, 6.3111934432E+00, 5.7228280335E+00, 4.6138980193E-01, 3.9991166992E-01, 6.1832691356E-01],
	[1.2815000000E+04, 6.3144875911E+00, 5.7223978294E+00, 4.6195736003E-01, 4.0034912840E-01, 6.1847309464E-01],
	[1.2820000000E+04, 6.3177821724E+00, 5.7219678254E+00, 4.6252539399E-01, 4.0078684114E-01, 6.1861924887E-01],
	[1.2825000000E+04, 6.3210771869E+00, 5.7215380214E+00, 4.6309390402E-01, 4.0122480807E-01, 6.1876537624E-01],
	[1.2830000000E+04, 6.3243745854E+00, 5.7211102472E+00, 4.6366289034E-01, 4.0166304601E-01, 6.1891147671E-01],
	[1.2835000000E+04, 6.3276778568E+00, 5.7206877699E+00, 4.6423235314E-01, 4.0210158521E-01, 6.1905755029E-01],
	[1.2840000000E+04, 6.3309815659E+00, 5.7202654884E+00, 4.6480229266E-01, 4.0254037864E-01, 6.1920359695E-01],
	[1.2845000000E+04, 6.3342857126E+00, 5.7198434025E+00, 4.6537270910E-01, 4.0297942623E-01, 6.1934961669E-01],
	[1.2850000000E+04, 6.3375902968E+00, 5.7194215120E+00, 4.6594360267E-01, 4.0341872791E-01, 6.1949560947E-01],
	[1.2855000000E+04, 6.3408953185E+00, 5.7189998167E+00, 4.6651497359E-01, 4.0385828361E-01, 6.1964157530E-01],
	[1.2860000000E+04, 6.3442007775E+00, 5.7185783164E+00, 4.6708682207E-01, 4.0429809328E-01, 6.1978751415E-01],
	[1.2865000000E+04, 6.3475066736E+00, 5.7181570111E+00, 4.6765914831E-01, 4.0473815684E-01, 6.1993342602E-01],
	[1.2870000000E+04, 6.3508130068E+00, 5.7177359004E+00, 4.6823195254E-01, 4.0517847423E-01, 6.2007931088E-01],
	[1.2875000000E+04, 6.3541197770E+00, 5.7173149844E+00, 4.6880523497E-01, 4.0561904538E-01, 6.2022516872E-01],
	[1.2880000000E+04, 6.3574269840E+00, 5.7168942627E+00, 4.6937899581E-01, 4.0605987023E-01, 6.2037099953E-01],
	[1.2885000000E+04, 6.3607346278E+00, 5.7164737353E+00, 4.6995323526E-01, 4.0650094871E-01, 6.2051680328E-01],
	[1.2890000000E+04, 6.3640427081E+00, 5.7160534019E+00, 4.7052795355E-01, 4.0694228076E-01, 6.2066257998E-01],
	[1.2895000000E+04, 6.3673512250E+00, 5.7156332625E+00, 4.7110315089E-01, 4.0738386630E-01, 6.2080832959E-01],
	[1.2900000000E+04, 6.3706601783E+00, 5.7152133168E+00, 4.7167882749E-01, 4.0782570527E-01, 6.2095405212E-01],
	[1.2905000000E+04, 6.3739695679E+00, 5.7147935646E+00, 4.7225498356E-01, 4.0826779761E-01, 6.2109974754E-01],
	[1.2910000000E+04, 6.3772793937E+00, 5.7143740059E+00, 4.7283161932E-01, 4.0871014324E-01, 6.2124541583E-01],
	[1.2915000000E+04, 6.3805896555E+00, 5.7139546404E+00, 4.7340873497E-01, 4.0915274210E-01, 6.2139105699E-01],
	[1.2920000000E+04, 6.3839003533E+00, 5.7135354680E+00, 4.7398633074E-01, 4.0959559413E-01, 6.2153667100E-01],
	[1.2925000000E+04, 6.3872114869E+00, 5.7131164886E+00, 4.7456440682E-01, 4.1003869924E-01, 6.2168225784E-01],
	[1.2930000000E+04, 6.3905230563E+00, 5.7126977018E+00, 4.7514296345E-01, 4.1048205738E-01, 6.2182781750E-01],
	[1.2935000000E+04, 6.3938350613E+00, 5.7122791077E+00, 4.7572200082E-01, 4.1092566848E-01, 6.2197334997E-01],
	[1.2940000000E+04, 6.3971475018E+00, 5.7118607060E+00, 4.7630151915E-01, 4.1136953246E-01, 6.2211885524E-01],
	[1.2945000000E+04, 6.4004603776E+00, 5.7114424966E+00, 4.7688151866E-01, 4.1181364927E-01, 6.2226433328E-01],
	[1.2950000000E+04, 6.4037736888E+00, 5.7110244792E+00, 4.7746199956E-01, 4.1225801882E-01, 6.2240978408E-01],
	[1.2955000000E+04, 6.4070874352E+00, 5.7106066539E+00, 4.7804296205E-01, 4.1270264106E-01, 6.2255520763E-01],
	[1.2960000000E+04, 6.4104016166E+00, 5.7101890203E+00, 4.7862440636E-01, 4.1314751591E-01, 6.2270060391E-01],
	[1.2965000000E+04, 6.4137162330E+00, 5.7097715783E+00, 4.7920633269E-01, 4.1359264331E-01, 6.2284597292E-01],
	[1.2970000000E+04, 6.4170312842E+00, 5.7093543277E+00, 4.7978874126E-01, 4.1403802318E-01, 6.2299131463E-01],
	[1.2975000000E+04, 6.4203467701E+00, 5.7089372685E+00, 4.8037163229E-01, 4.1448365545E-01, 6.2313662904E-01],
	[1.2980000000E+04, 6.4236626907E+00, 5.7085204004E+00, 4.8095500597E-01, 4.1492954006E-01, 6.2328191612E-01],
	[1.2985000000E+04, 6.4269790458E+00, 5.7081037233E+00, 4.8153886254E-01, 4.1537567693E-01, 6.2342717587E-01],
	[1.2990000000E+04, 6.4302958353E+00, 5.7076872369E+00, 4.8212320219E-01, 4.1582206600E-01, 6.2357240827E-01],
	[1.2995000000E+04, 6.4336130591E+00, 5.7072709413E+00, 4.8270802515E-01, 4.1626870720E-01, 6.2371761330E-01],
	[1.3000000000E+04, 6.4369307171E+00, 5.7068548361E+00, 4.8329333162E-01, 4.1671560045E-01, 6.2386279096E-01],
	[1.3005000000E+04, 6.4402488091E+00, 5.7064389212E+00, 4.8387912182E-01, 4.1716274568E-01, 6.2400794123E-01],
	[1.3010000000E+04, 6.4435673351E+00, 5.7060231966E+00, 4.8446539597E-01, 4.1761014282E-01, 6.2415306409E-01],
	[1.3015000000E+04, 6.4468862950E+00, 5.7056076619E+00, 4.8505215426E-01, 4.1805779181E-01, 6.2429815953E-01],
	[1.3020000000E+04, 6.4502056886E+00, 5.7051923171E+00, 4.8563939693E-01, 4.1850569256E-01, 6.2444322754E-01],
	[1.3025000000E+04, 6.4535255158E+00, 5.7047771619E+00, 4.8622712417E-01, 4.1895384501E-01, 6.2458826810E-01],
	[1.3030000000E+04, 6.4568457765E+00, 5.7043621963E+00, 4.8681533621E-01, 4.1940224910E-01, 6.2473328120E-01],
	[1.3035000000E+04, 6.4601664707E+00, 5.7039474201E+00, 4.8740403326E-01, 4.1985090473E-01, 6.2487826683E-01],
	[1.3040000000E+04, 6.4634951149E+00, 5.7035393755E+00, 4.8799321552E-01, 4.2029987917E-01, 6.2502322500E-01],
	[1.3045000000E+04, 6.4668245169E+00, 5.7031317946E+00, 4.8858288322E-01, 4.2074910811E-01, 6.2516815573E-01],
	[1.3050000000E+04, 6.4701543570E+00, 5.7027243989E+00, 4.8917303656E-01, 4.2119858864E-01, 6.2531305900E-01],
	[1.3055000000E+04, 6.4734846351E+00, 5.7023171884E+00, 4.8976367576E-01, 4.2164832068E-01, 6.2545793480E-01],
	[1.3060000000E+04, 6.4768153511E+00, 5.7019101629E+00, 4.9035480103E-01, 4.2209830416E-01, 6.2560278309E-01],
	[1.3065000000E+04, 6.4801465050E+00, 5.7015033223E+00, 4.9094641259E-01, 4.2254853901E-01, 6.2574760386E-01],
	[1.3070000000E+04, 6.4834780965E+00, 5.7010966663E+00, 4.9153851065E-01, 4.2299902515E-01, 6.2589239709E-01],
	[1.3075000000E+04, 6.4868101257E+00, 5.7006901948E+00, 4.9213109541E-01, 4.2344976252E-01, 6.2603716276E-01],
	[1.3080000000E+04, 6.4901425923E+00, 5.7002839077E+00, 4.9272416710E-01, 4.2390075103E-01, 6.2618190084E-01],
	[1.3085000000E+04, 6.4934754963E+00, 5.6998778049E+00, 4.9331772593E-01, 4.2435199063E-01, 6.2632661132E-01],
	[1.3090000000E+04, 6.4968088375E+00, 5.6994718861E+00, 4.9391177210E-01, 4.2480348122E-01, 6.2647129417E-01],
	[1.3095000000E+04, 6.5001426160E+00, 5.6990661512E+00, 4.9450630584E-01, 4.2525522274E-01, 6.2661594938E-01],
	[1.3100000000E+04, 6.5034768314E+00, 5.6986606001E+00, 4.9510132736E-01, 4.2570721512E-01, 6.2676057692E-01],
	[1.3105000000E+04, 6.5068114838E+00, 5.6982552325E+00, 4.9569683686E-01, 4.2615945829E-01, 6.2690517678E-01],
	[1.3110000000E+04, 6.5101465730E+00, 5.6978500484E+00, 4.9629283457E-01, 4.2661195216E-01, 6.2704974893E-01],
	[1.3115000000E+04, 6.5134820989E+00, 5.6974450477E+00, 4.9688932070E-01, 4.2706469666E-01, 6.2719429335E-01],
	[1.3120000000E+04, 6.5168180614E+00, 5.6970402300E+00, 4.9748629545E-01, 4.2751769173E-01, 6.2733881003E-01],
	[1.3125000000E+04, 6.5201544604E+00, 5.6966355954E+00, 4.9808375904E-01, 4.2797093728E-01, 6.2748329894E-01],
	[1.3130000000E+04, 6.5234912958E+00, 5.6962311436E+00, 4.9868171169E-01, 4.2842443324E-01, 6.2762776006E-01],
	[1.3135000000E+04, 6.5268285675E+00, 5.6958268745E+00, 4.9928015361E-01, 4.2887817954E-01, 6.2777219337E-01],
	[1.3140000000E+04, 6.5301662753E+00, 5.6954227879E+00, 4.9987908501E-01, 4.2933217609E-01, 6.2791659886E-01],
	[1.3145000000E+04, 6.5335044192E+00, 5.6950188837E+00, 5.0047850611E-01, 4.2978642284E-01, 6.2806097650E-01],
	[1.3150000000E+04, 6.5368429990E+00, 5.6946151617E+00, 5.0107841711E-01, 4.3024091969E-01, 6.2820532627E-01],
	[1.3155000000E+04, 6.5401820147E+00, 5.6942116218E+00, 5.0167881824E-01, 4.3069566658E-01, 6.2834964815E-01],
	[1.3160000000E+04, 6.5435214661E+00, 5.6938082639E+00, 5.0227970970E-01, 4.3115066343E-01, 6.2849394212E-01],
	[1.3165000000E+04, 6.5468613532E+00, 5.6934050877E+00, 5.0288109171E-01, 4.3160591016E-01, 6.2863820817E-01],
	[1.3170000000E+04, 6.5502016757E+00, 5.6930020932E+00, 5.0348296448E-01, 4.3206140670E-01, 6.2878244626E-01],
	[1.3175000000E+04, 6.5535424337E+00, 5.6925992801E+00, 5.0408532822E-01, 4.3251715298E-01, 6.2892665639E-01],
	[1.3180000000E+04, 6.5568836269E+00, 5.6921966484E+00, 5.0468818315E-01, 4.3297314890E-01, 6.2907083854E-01],
	[1.3185000000E+04, 6.5602252554E+00, 5.6917941978E+00, 5.0529152949E-01, 4.3342939440E-01, 6.2921499267E-01],
	[1.3190000000E+04, 6.5635673189E+00, 5.6913919282E+00, 5.0589536743E-01, 4.3388588941E-01, 6.2935911878E-01],
	[1.3195000000E+04, 6.5669098174E+00, 5.6909898396E+00, 5.0649969721E-01, 4.3434263384E-01, 6.2950321684E-01],
	[1.3200000000E+04, 6.5702527507E+00, 5.6905879316E+00, 5.0710451903E-01, 4.3479962762E-01, 6.2964728683E-01],
	[1.3205000000E+04, 6.5735961188E+00, 5.6901862043E+00, 5.0770983310E-01, 4.3525687067E-01, 6.2979132874E-01],
	[1.3210000000E+04, 6.5769399216E+00, 5.6897846573E+00, 5.0831563964E-01, 4.3571436291E-01, 6.2993534255E-01],
	[1.3215000000E+04, 6.5802841589E+00, 5.6893832907E+00, 5.0892193886E-01, 4.3617210426E-01, 6.3007932822E-01],
	[1.3220000000E+04, 6.5836288306E+00, 5.6889821041E+00, 5.0952873098E-01, 4.3663009465E-01, 6.3022328576E-01],
	[1.3225000000E+04, 6.5869739367E+00, 5.6885810976E+00, 5.1013601621E-01, 4.3708833401E-01, 6.3036721513E-01],
	[1.3230000000E+04, 6.5903194769E+00, 5.6881802709E+00, 5.1074379475E-01, 4.3754682224E-01, 6.3051111631E-01],
	[1.3235000000E+04, 6.5936654513E+00, 5.6877796238E+00, 5.1135206684E-01, 4.3800555928E-01, 6.3065498929E-01],
	[1.3240000000E+04, 6.5970118597E+00, 5.6873791563E+00, 5.1196083267E-01, 4.3846454504E-01, 6.3079883406E-01],
	[1.3245000000E+04, 6.6003587019E+00, 5.6869788682E+00, 5.1257009246E-01, 4.3892377945E-01, 6.3094265057E-01],
	[1.3250000000E+04, 6.6037141788E+00, 5.6865854028E+00, 5.1317984643E-01, 4.3938333839E-01, 6.3108643883E-01],
	[1.3255000000E+04, 6.6070701823E+00, 5.6861921842E+00, 5.1379009479E-01, 4.3984314689E-01, 6.3123019881E-01],
	[1.3260000000E+04, 6.6104266246E+00, 5.6857991410E+00, 5.1440083775E-01, 4.4030320406E-01, 6.3137393049E-01],
	[1.3265000000E+04, 6.6137835058E+00, 5.6854062731E+00, 5.1501207552E-01, 4.4076350982E-01, 6.3151763385E-01],
	[1.3270000000E+04, 6.6171408255E+00, 5.6850135804E+00, 5.1562380833E-01, 4.4122406410E-01, 6.3166130888E-01],
	[1.3275000000E+04, 6.6204985838E+00, 5.6846210628E+00, 5.1623603638E-01, 4.4168486681E-01, 6.3180495555E-01],
	[1.3280000000E+04, 6.6238567805E+00, 5.6842287201E+00, 5.1684875988E-01, 4.4214591787E-01, 6.3194857384E-01],
	[1.3285000000E+04, 6.6272154155E+00, 5.6838365521E+00, 5.1746197906E-01, 4.4260721721E-01, 6.3209216374E-01],
	[1.3290000000E+04, 6.6305744887E+00, 5.6834445587E+00, 5.1807569412E-01, 4.4306876474E-01, 6.3223572523E-01],
	[1.3295000000E+04, 6.6339340001E+00, 5.6830527399E+00, 5.1868990528E-01, 4.4353056038E-01, 6.3237925828E-01],
	[1.3300000000E+04, 6.6372939494E+00, 5.6826610953E+00, 5.1930461274E-01, 4.4399260406E-01, 6.3252276288E-01],
	[1.3305000000E+04, 6.6406543366E+00, 5.6822696249E+00, 5.1991981674E-01, 4.4445489569E-01, 6.3266623902E-01],
	[1.3310000000E+04, 6.6440151616E+00, 5.6818783285E+00, 5.2053551747E-01, 4.4491743520E-01, 6.3280968666E-01],
	[1.3315000000E+04, 6.6473764242E+00, 5.6814872061E+00, 5.2115171515E-01, 4.4538022250E-01, 6.3295310580E-01],
	[1.3320000000E+04, 6.6507381244E+00, 5.6810962574E+00, 5.2176841000E-01, 4.4584325751E-01, 6.3309649641E-01],
	[1.3325000000E+04, 6.6541002621E+00, 5.6807054823E+00, 5.2238560222E-01, 4.4630654015E-01, 6.3323985848E-01],
	[1.3330000000E+04, 6.6574628371E+00, 5.6803148807E+00, 5.2300329204E-01, 4.4677007035E-01, 6.3338319198E-01],
	[1.3335000000E+04, 6.6608258493E+00, 5.6799244524E+00, 5.2362147967E-01, 4.4723384801E-01, 6.3352649691E-01],
	[1.3340000000E+04, 6.6641892987E+00, 5.6795341973E+00, 5.2424016531E-01, 4.4769787306E-01, 6.3366977323E-01],
	[1.3345000000E+04, 6.6675531851E+00, 5.6791441152E+00, 5.2485934919E-01, 4.4816214541E-01, 6.3381302093E-01],
	[1.3350000000E+04, 6.6709175084E+00, 5.6787542061E+00, 5.2547903151E-01, 4.4862666499E-01, 6.3395624000E-01],
	[1.3355000000E+04, 6.6742822685E+00, 5.6783644697E+00, 5.2609921250E-01, 4.4909143171E-01, 6.3409943041E-01],
	[1.3360000000E+04, 6.6776474654E+00, 5.6779749059E+00, 5.2671989236E-01, 4.4955644550E-01, 6.3424259215E-01],
	[1.3365000000E+04, 6.6810130988E+00, 5.6775855146E+00, 5.2734107131E-01, 4.5002170625E-01, 6.3438572519E-01],
	[1.3370000000E+04, 6.6843791687E+00, 5.6771962956E+00, 5.2796274957E-01, 4.5048721391E-01, 6.3452882953E-01],
	[1.3375000000E+04, 6.6877456750E+00, 5.6768072489E+00, 5.2858492733E-01, 4.5095296837E-01, 6.3467190514E-01],
	[1.3380000000E+04, 6.6911126176E+00, 5.6764183742E+00, 5.2920760483E-01, 4.5141896957E-01, 6.3481495199E-01],
	[1.3385000000E+04, 6.6944799964E+00, 5.6760296714E+00, 5.2983078227E-01, 4.5188521741E-01, 6.3495797009E-01],
	[1.3390000000E+04, 6.6978478112E+00, 5.6756411404E+00, 5.3045445987E-01, 4.5235171182E-01, 6.3510095940E-01],
	[1.3395000000E+04, 6.7012160620E+00, 5.6752527810E+00, 5.3107863784E-01, 4.5281845270E-01, 6.3524391991E-01],
	[1.3400000000E+04, 6.7045847486E+00, 5.6748645931E+00, 5.3170331639E-01, 4.5328543998E-01, 6.3538685160E-01],
	[1.3405000000E+04, 6.7079538710E+00, 5.6744765766E+00, 5.3232849575E-01, 4.5375267358E-01, 6.3552975446E-01],
	[1.3410000000E+04, 6.7113234290E+00, 5.6740887312E+00, 5.3295417611E-01, 4.5422015340E-01, 6.3567262845E-01],
	[1.3415000000E+04, 6.7146934225E+00, 5.6737010570E+00, 5.3358035770E-01, 4.5468787937E-01, 6.3581547358E-01],
	[1.3420000000E+04, 6.7180638515E+00, 5.6733135537E+00, 5.3420704074E-01, 4.5515585140E-01, 6.3595828981E-01],
	[1.3425000000E+04, 6.7214347158E+00, 5.6729262212E+00, 5.3483422542E-01, 4.5562406941E-01, 6.3610107714E-01],
	[1.3430000000E+04, 6.7248060153E+00, 5.6725390594E+00, 5.3546191197E-01, 4.5609253331E-01, 6.3624383553E-01],
	[1.3435000000E+04, 6.7281777499E+00, 5.6721520681E+00, 5.3609010061E-01, 4.5656124301E-01, 6.3638656499E-01],
	[1.3440000000E+04, 6.7315499196E+00, 5.6717652471E+00, 5.3671879154E-01, 4.5703019844E-01, 6.3652926548E-01],
	[1.3445000000E+04, 6.7349225241E+00, 5.6713785965E+00, 5.3734798498E-01, 4.5749939950E-01, 6.3667193699E-01],
	[1.3450000000E+04, 6.7382955634E+00, 5.6709921159E+00, 5.3797768114E-01, 4.5796884612E-01, 6.3681457950E-01],
	[1.3455000000E+04, 6.7416690374E+00, 5.6706058053E+00, 5.3860788024E-01, 4.5843853820E-01, 6.3695719300E-01],
	[1.3460000000E+04, 6.7450459535E+00, 5.6702219385E+00, 5.3923858250E-01, 4.5890850449E-01, 6.3709977747E-01],
	[1.3465000000E+04, 6.7484290443E+00, 5.6698425769E+00, 5.3986978811E-01, 4.5937877121E-01, 6.3724233288E-01],
	[1.3470000000E+04, 6.7518125750E+00, 5.6694633814E+00, 5.4050149731E-01, 4.5984928343E-01, 6.3738485923E-01],
	[1.3475000000E+04, 6.7551965455E+00, 5.6690843520E+00, 5.4113371030E-01, 4.6032004105E-01, 6.3752735649E-01],
	[1.3480000000E+04, 6.7585809556E+00, 5.6687054885E+00, 5.4176642730E-01, 4.6079104399E-01, 6.3766982465E-01],
	[1.3485000000E+04, 6.7619658054E+00, 5.6683267908E+00, 5.4239964852E-01, 4.6126229215E-01, 6.3781226369E-01],
	[1.3490000000E+04, 6.7653510945E+00, 5.6679482589E+00, 5.4303337417E-01, 4.6173378546E-01, 6.3795467359E-01],
	[1.3495000000E+04, 6.7687368230E+00, 5.6675698924E+00, 5.4366760447E-01, 4.6220552383E-01, 6.3809705433E-01],
	[1.3500000000E+04, 6.7721229908E+00, 5.6671916914E+00, 5.4430233964E-01, 4.6267750717E-01, 6.3823940591E-01],
	[1.3505000000E+04, 6.7755095977E+00, 5.6668136556E+00, 5.4493757988E-01, 4.6314973539E-01, 6.3838172829E-01],
	[1.3510000000E+04, 6.7788966437E+00, 5.6664357850E+00, 5.4557332541E-01, 4.6362220841E-01, 6.3852402147E-01],
	[1.3515000000E+04, 6.7822841285E+00, 5.6660580793E+00, 5.4620957645E-01, 4.6409492615E-01, 6.3866628542E-01],
	[1.3520000000E+04, 6.7856720522E+00, 5.6656805386E+00, 5.4684633321E-01, 4.6456788851E-01, 6.3880852014E-01],
	[1.3525000000E+04, 6.7890604146E+00, 5.6653031626E+00, 5.4748359590E-01, 4.6504109540E-01, 6.3895072559E-01],
	[1.3530000000E+04, 6.7924492156E+00, 5.6649259512E+00, 5.4812136474E-01, 4.6551454674E-01, 6.3909290177E-01],
	[1.3535000000E+04, 6.7958384551E+00, 5.6645489042E+00, 5.4875963994E-01, 4.6598824245E-01, 6.3923504866E-01],
	[1.3540000000E+04, 6.7992281331E+00, 5.6641720217E+00, 5.4939842171E-01, 4.6646218243E-01, 6.3937716624E-01],
	[1.3545000000E+04, 6.8026182493E+00, 5.6637953033E+00, 5.5003771028E-01, 4.6693636660E-01, 6.3951925449E-01],
	[1.3550000000E+04, 6.8060088037E+00, 5.6634187490E+00, 5.5067750585E-01, 4.6741079486E-01, 6.3966131340E-01],
	[1.3555000000E+04, 6.8093997962E+00, 5.6630423586E+00, 5.5131780864E-01, 4.6788546713E-01, 6.3980334296E-01],
	[1.3560000000E+04, 6.8127912267E+00, 5.6626661321E+00, 5.5195861886E-01, 4.6836038333E-01, 6.3994534313E-01],
	[1.3565000000E+04, 6.8161830950E+00, 5.6622900692E+00, 5.5259993672E-01, 4.6883554336E-01, 6.4008731391E-01],
	[1.3570000000E+04, 6.8195754011E+00, 5.6619141699E+00, 5.5324176245E-01, 4.6931094713E-01, 6.4022925528E-01],
	[1.3575000000E+04, 6.8229681449E+00, 5.6615384340E+00, 5.5388409625E-01, 4.6978659456E-01, 6.4037116723E-01],
	[1.3580000000E+04, 6.8263613263E+00, 5.6611628614E+00, 5.5452693834E-01, 4.7026248555E-01, 6.4051304973E-01],
	[1.3585000000E+04, 6.8297549451E+00, 5.6607874520E+00, 5.5517028894E-01, 4.7073862002E-01, 6.4065490277E-01],
	[1.3590000000E+04, 6.8331490012E+00, 5.6604122055E+00, 5.5581414825E-01, 4.7121499788E-01, 6.4079672633E-01],
	[1.3595000000E+04, 6.8365434946E+00, 5.6600371220E+00, 5.5645851649E-01, 4.7169161903E-01, 6.4093852040E-01],
	[1.3600000000E+04, 6.8399384252E+00, 5.6596622013E+00, 5.5710339388E-01, 4.7216848339E-01, 6.4108028497E-01],
	[1.3605000000E+04, 6.8433337928E+00, 5.6592874431E+00, 5.5774878062E-01, 4.7264559087E-01, 6.4122202000E-01],
	[1.3610000000E+04, 6.8467295973E+00, 5.6589128475E+00, 5.5839467695E-01, 4.7312294138E-01, 6.4136372549E-01],
	[1.3615000000E+04, 6.8501258386E+00, 5.6585384143E+00, 5.5904108306E-01, 4.7360053483E-01, 6.4150540143E-01],
	[1.3620000000E+04, 6.8535225167E+00, 5.6581641433E+00, 5.5968799917E-01, 4.7407837112E-01, 6.4164704779E-01],
	[1.3625000000E+04, 6.8569196314E+00, 5.6577900344E+00, 5.6033542550E-01, 4.7455645017E-01, 6.4178866455E-01],
	[1.3630000000E+04, 6.8603171826E+00, 5.6574160875E+00, 5.6098336226E-01, 4.7503477189E-01, 6.4193025171E-01],
	[1.3635000000E+04, 6.8637151702E+00, 5.6570423024E+00, 5.6163180967E-01, 4.7551333618E-01, 6.4207180925E-01],
	[1.3640000000E+04, 6.8671135941E+00, 5.6566686791E+00, 5.6228076794E-01, 4.7599214295E-01, 6.4221333714E-01],
	[1.3645000000E+04, 6.8705124543E+00, 5.6562952174E+00, 5.6293023728E-01, 4.7647119212E-01, 6.4235483538E-01],
	[1.3650000000E+04, 6.8739117505E+00, 5.6559219171E+00, 5.6358021791E-01, 4.7695048358E-01, 6.4249630394E-01],
	[1.3655000000E+04, 6.8773114827E+00, 5.6555487782E+00, 5.6423071004E-01, 4.7743001726E-01, 6.4263774282E-01],
	[1.3660000000E+04, 6.8807116508E+00, 5.6551758004E+00, 5.6488171390E-01, 4.7790979306E-01, 6.4277915199E-01],
	[1.3665000000E+04, 6.8841122548E+00, 5.6548029838E+00, 5.6553322968E-01, 4.7838981088E-01, 6.4292053144E-01],
	[1.3670000000E+04, 6.8875132944E+00, 5.6544303281E+00, 5.6618525761E-01, 4.7887007063E-01, 6.4306188115E-01],
	[1.3675000000E+04, 6.8909148795E+00, 5.6540579111E+00, 5.6683779790E-01, 4.7935057332E-01, 6.4320320111E-01],
	[1.3680000000E+04, 6.8943259988E+00, 5.6536920853E+00, 5.6749085076E-01, 4.7983140815E-01, 6.4334449130E-01],
	[1.3685000000E+04, 6.8977375592E+00, 5.6533264168E+00, 5.6814441642E-01, 4.8031248493E-01, 6.4348575171E-01],
	[1.3690000000E+04, 6.9011495605E+00, 5.6529609056E+00, 5.6879849508E-01, 4.8079380357E-01, 6.4362698231E-01],
	[1.3695000000E+04, 6.9045620028E+00, 5.6525955514E+00, 5.6945462516E-01, 4.8127646270E-01, 6.4376818310E-01],
	[1.3700000000E+04, 6.9079748858E+00, 5.6522303542E+00, 5.7011378383E-01, 4.8176115884E-01, 6.4390935406E-01],
	[1.3705000000E+04, 6.9113882096E+00, 5.6518653139E+00, 5.7077346403E-01, 4.8224610046E-01, 6.4405049517E-01],
	[1.3710000000E+04, 6.9148019739E+00, 5.6515004302E+00, 5.7143366598E-01, 4.8273128746E-01, 6.4419160641E-01],
	[1.3715000000E+04, 6.9182161788E+00, 5.6511357032E+00, 5.7209438991E-01, 4.8321671975E-01, 6.4433268778E-01],
	[1.3720000000E+04, 6.9216308240E+00, 5.6507711326E+00, 5.7275563604E-01, 4.8370239723E-01, 6.4447373925E-01],
	[1.3725000000E+04, 6.9250459095E+00, 5.6504067184E+00, 5.7341740458E-01, 4.8418831982E-01, 6.4461476081E-01],
	[1.3730000000E+04, 6.9284614352E+00, 5.6500424604E+00, 5.7407969577E-01, 4.8467448741E-01, 6.4475575244E-01],
	[1.3735000000E+04, 6.9318774009E+00, 5.6496783584E+00, 5.7474250981E-01, 4.8516089992E-01, 6.4489671414E-01],
	[1.3740000000E+04, 6.9352938066E+00, 5.6493144125E+00, 5.7540584694E-01, 4.8564755725E-01, 6.4503764587E-01],
	[1.3745000000E+04, 6.9387106522E+00, 5.6489506224E+00, 5.7606970737E-01, 4.8613445930E-01, 6.4517854764E-01],
	[1.3750000000E+04, 6.9421279375E+00, 5.6485869880E+00, 5.7673409133E-01, 4.8662160597E-01, 6.4531941941E-01],
	[1.3755000000E+04, 6.9455456625E+00, 5.6482235092E+00, 5.7739899904E-01, 4.8710899718E-01, 6.4546026118E-01],
	[1.3760000000E+04, 6.9489638270E+00, 5.6478601860E+00, 5.7806443072E-01, 4.8759663283E-01, 6.4560107294E-01],
	[1.3765000000E+04, 6.9523824310E+00, 5.6474970180E+00, 5.7873038659E-01, 4.8808451282E-01, 6.4574185466E-01],
	[1.3770000000E+04, 6.9558014744E+00, 5.6471340053E+00, 5.7939686687E-01, 4.8857263706E-01, 6.4588260632E-01],
	[1.3775000000E+04, 6.9592209569E+00, 5.6467711477E+00, 5.8006387178E-01, 4.8906100546E-01, 6.4602332793E-01],
	[1.3780000000E+04, 6.9626408787E+00, 5.6464084451E+00, 5.8073140156E-01, 4.8954961790E-01, 6.4616401946E-01],
	[1.3785000000E+04, 6.9660612394E+00, 5.6460458974E+00, 5.8139945641E-01, 4.9003847431E-01, 6.4630468089E-01],
	[1.3790000000E+04, 6.9694820391E+00, 5.6456835044E+00, 5.8206803655E-01, 4.9052757458E-01, 6.4644531221E-01],
	[1.3795000000E+04, 6.9729032777E+00, 5.6453212660E+00, 5.8273714223E-01, 4.9101691862E-01, 6.4658591340E-01],
	[1.3800000000E+04, 6.9763249549E+00, 5.6449591821E+00, 5.8340677364E-01, 4.9150650632E-01, 6.4672648446E-01],
	[1.3805000000E+04, 6.9797470708E+00, 5.6445972526E+00, 5.8407693102E-01, 4.9199633761E-01, 6.4686702536E-01],
	[1.3810000000E+04, 6.9831696252E+00, 5.6442354774E+00, 5.8474761458E-01, 4.9248641236E-01, 6.4700753609E-01],
	[1.3815000000E+04, 6.9865926181E+00, 5.6438738563E+00, 5.8541882456E-01, 4.9297673050E-01, 6.4714801664E-01],
	[1.3820000000E+04, 6.9900160492E+00, 5.6435123892E+00, 5.8609056116E-01, 4.9346729192E-01, 6.4728846698E-01],
	[1.3825000000E+04, 6.9934399186E+00, 5.6431510760E+00, 5.8676282462E-01, 4.9395809653E-01, 6.4742888711E-01],
	[1.3830000000E+04, 6.9968642261E+00, 5.6427899165E+00, 5.8743561515E-01, 4.9444914422E-01, 6.4756927701E-01],
	[1.3835000000E+04, 7.0002889716E+00, 5.6424289107E+00, 5.8810893297E-01, 4.9494043490E-01, 6.4770963667E-01],
	[1.3840000000E+04, 7.0037141550E+00, 5.6420680585E+00, 5.8878277832E-01, 4.9543196847E-01, 6.4784996607E-01],
	[1.3845000000E+04, 7.0071397762E+00, 5.6417073596E+00, 5.8945715140E-01, 4.9592374484E-01, 6.4799026519E-01],
	[1.3850000000E+04, 7.0105658351E+00, 5.6413468141E+00, 5.9013205244E-01, 4.9641576390E-01, 6.4813053403E-01],
	[1.3855000000E+04, 7.0139923316E+00, 5.6409864217E+00, 5.9080748167E-01, 4.9690802556E-01, 6.4827077256E-01],
	[1.3860000000E+04, 7.0174192657E+00, 5.6406261823E+00, 5.9148343930E-01, 4.9740052972E-01, 6.4841098077E-01],
	[1.3865000000E+04, 7.0208466371E+00, 5.6402660959E+00, 5.9215992556E-01, 4.9789327628E-01, 6.4855115865E-01],
	[1.3870000000E+04, 7.0242744458E+00, 5.6399061622E+00, 5.9283694066E-01, 4.9838626513E-01, 6.4869130619E-01],
	[1.3875000000E+04, 7.0277026917E+00, 5.6395463813E+00, 5.9351448484E-01, 4.9887949619E-01, 6.4883142336E-01],
	[1.3880000000E+04, 7.0311313747E+00, 5.6391867529E+00, 5.9419255831E-01, 4.9937296935E-01, 6.4897151016E-01],
	[1.3885000000E+04, 7.0345604947E+00, 5.6388272770E+00, 5.9487116130E-01, 4.9986668452E-01, 6.4911156656E-01],
	[1.3890000000E+04, 7.0379900516E+00, 5.6384679534E+00, 5.9555029402E-01, 5.0036064159E-01, 6.4925159257E-01],
	[1.3895000000E+04, 7.0414200453E+00, 5.6381087820E+00, 5.9622995670E-01, 5.0085484046E-01, 6.4939158815E-01],
	[1.3900000000E+04, 7.0448599816E+00, 5.6377560578E+00, 5.9691014956E-01, 5.0134937896E-01, 6.4953155330E-01],
	[1.3905000000E+04, 7.0483005311E+00, 5.6374035955E+00, 5.9759087282E-01, 5.0184416113E-01, 6.4967148800E-01],
	[1.3910000000E+04, 7.0517415230E+00, 5.6370512820E+00, 5.9827212671E-01, 5.0233918513E-01, 6.4981139224E-01],
	[1.3915000000E+04, 7.0551829572E+00, 5.6366991170E+00, 5.9895391144E-01, 5.0283445084E-01, 6.4995126600E-01],
	[1.3920000000E+04, 7.0586248337E+00, 5.6363471006E+00, 5.9963622725E-01, 5.0332995817E-01, 6.5009110927E-01],
	[1.3925000000E+04, 7.0620671522E+00, 5.6359952325E+00, 6.0031907434E-01, 5.0382570703E-01, 6.5023092204E-01],
	[1.3930000000E+04, 7.0655099129E+00, 5.6356435128E+00, 6.0100245295E-01, 5.0432169730E-01, 6.5037070428E-01],
	[1.3935000000E+04, 7.0689531154E+00, 5.6352919411E+00, 6.0168636329E-01, 5.0481792889E-01, 6.5051045600E-01],
	[1.3940000000E+04, 7.0723967598E+00, 5.6349405176E+00, 6.0237080559E-01, 5.0531440171E-01, 6.5065017717E-01],
	[1.3945000000E+04, 7.0758408459E+00, 5.6345892419E+00, 6.0305578006E-01, 5.0581111563E-01, 6.5078986777E-01],
	[1.3950000000E+04, 7.0792853736E+00, 5.6342381141E+00, 6.0374128694E-01, 5.0630807058E-01, 6.5092952780E-01],
	[1.3955000000E+04, 7.0827303429E+00, 5.6338871340E+00, 6.0442732644E-01, 5.0680526644E-01, 6.5106915725E-01],
	[1.3960000000E+04, 7.0861757536E+00, 5.6335363015E+00, 6.0511389879E-01, 5.0730270311E-01, 6.5120875608E-01],
	[1.3965000000E+04, 7.0896216056E+00, 5.6331856164E+00, 6.0580100420E-01, 5.0780038050E-01, 6.5134832431E-01],
	[1.3970000000E+04, 7.0930678988E+00, 5.6328350787E+00, 6.0648864291E-01, 5.0829829849E-01, 6.5148786190E-01],
	[1.3975000000E+04, 7.0965146331E+00, 5.6324846882E+00, 6.0717681512E-01, 5.0879645699E-01, 6.5162736885E-01],
	[1.3980000000E+04, 7.0999618084E+00, 5.6321344449E+00, 6.0786552107E-01, 5.0929485590E-01, 6.5176684514E-01],
	[1.3985000000E+04, 7.1034094247E+00, 5.6317843485E+00, 6.0855476098E-01, 5.0979349512E-01, 6.5190629075E-01],
	[1.3990000000E+04, 7.1068574818E+00, 5.6314343991E+00, 6.0924453506E-01, 5.1029237454E-01, 6.5204570568E-01],
	[1.3995000000E+04, 7.1103059795E+00, 5.6310845964E+00, 6.0993484355E-01, 5.1079149405E-01, 6.5218508991E-01],
	[1.4000000000E+04, 7.1137549179E+00, 5.6307349404E+00, 6.1062568665E-01, 5.1129085356E-01, 6.5232444343E-01],
	[1.4005000000E+04, 7.1172042968E+00, 5.6303854310E+00, 6.1131706461E-01, 5.1179045297E-01, 6.5246376622E-01],
	[1.4010000000E+04, 7.1206541161E+00, 5.6300360680E+00, 6.1200897763E-01, 5.1229029217E-01, 6.5260305828E-01],
	[1.4015000000E+04, 7.1241043757E+00, 5.6296868513E+00, 6.1270142594E-01, 5.1279037105E-01, 6.5274231957E-01],
	[1.4020000000E+04, 7.1275550756E+00, 5.6293377809E+00, 6.1339440976E-01, 5.1329068952E-01, 6.5288155010E-01],
	[1.4025000000E+04, 7.1310062155E+00, 5.6289888565E+00, 6.1408792932E-01, 5.1379124747E-01, 6.5302074985E-01],
	[1.4030000000E+04, 7.1344577954E+00, 5.6286400782E+00, 6.1478198483E-01, 5.1429204480E-01, 6.5315991881E-01],
	[1.4035000000E+04, 7.1379098152E+00, 5.6282914457E+00, 6.1547657652E-01, 5.1479308140E-01, 6.5329905696E-01],
	[1.4040000000E+04, 7.1413622749E+00, 5.6279429589E+00, 6.1617170462E-01, 5.1529435717E-01, 6.5343816428E-01],
	[1.4045000000E+04, 7.1448151742E+00, 5.6275946179E+00, 6.1686736934E-01, 5.1579587200E-01, 6.5357724077E-01],
	[1.4050000000E+04, 7.1482685131E+00, 5.6272464223E+00, 6.1756357090E-01, 5.1629762580E-01, 6.5371628642E-01],
	[1.4055000000E+04, 7.1517222916E+00, 5.6268983722E+00, 6.1826030953E-01, 5.1679961845E-01, 6.5385530120E-01],
	[1.4060000000E+04, 7.1551765094E+00, 5.6265504674E+00, 6.1895758545E-01, 5.1730184986E-01, 6.5399428511E-01],
	[1.4065000000E+04, 7.1586311665E+00, 5.6262027078E+00, 6.1965539889E-01, 5.1780431991E-01, 6.5413323813E-01],
	[1.4070000000E+04, 7.1620862629E+00, 5.6258550932E+00, 6.2035375006E-01, 5.1830702850E-01, 6.5427216025E-01],
	[1.4075000000E+04, 7.1655417983E+00, 5.6255076237E+00, 6.2105263919E-01, 5.1880997553E-01, 6.5441105146E-01],
	[1.4080000000E+04, 7.1689977727E+00, 5.6251602990E+00, 6.2175206650E-01, 5.1931316089E-01, 6.5454991174E-01],
	[1.4085000000E+04, 7.1724541861E+00, 5.6248131191E+00, 6.2245203221E-01, 5.1981658448E-01, 6.5468874106E-01],
	[1.4090000000E+04, 7.1759110382E+00, 5.6244660838E+00, 6.2315253655E-01, 5.2032024619E-01, 6.5482753938E-01],
	[1.4095000000E+04, 7.1793683290E+00, 5.6241191930E+00, 6.2385357974E-01, 5.2082414591E-01, 6.5496630668E-01],
	[1.4100000000E+04, 7.1828260585E+00, 5.6237724466E+00, 6.2455516200E-01, 5.2132828354E-01, 6.5510504294E-01],
	[1.4105000000E+04, 7.1862842264E+00, 5.6234258446E+00, 6.2525728354E-01, 5.2183265897E-01, 6.5524374815E-01],
	[1.4110000000E+04, 7.1897428327E+00, 5.6230793867E+00, 6.2595994461E-01, 5.2233727210E-01, 6.5538242229E-01],
	[1.4115000000E+04, 7.1932018774E+00, 5.6227330730E+00, 6.2666314541E-01, 5.2284212283E-01, 6.5552106533E-01],
	[1.4120000000E+04, 7.1966638360E+00, 5.6223884427E+00, 6.2736688618E-01, 5.2334723746E-01, 6.5565967726E-01],
	[1.4125000000E+04, 7.2001339088E+00, 5.6220487256E+00, 6.2807116712E-01, 5.2385267160E-01, 6.5579825806E-01],
	[1.4130000000E+04, 7.2036044258E+00, 5.6217091493E+00, 6.2877598847E-01, 5.2435834333E-01, 6.5593680772E-01],
	[1.4135000000E+04, 7.2070753869E+00, 5.6213697135E+00, 6.2948135045E-01, 5.2486425257E-01, 6.5607532620E-01],
	[1.4140000000E+04, 7.2105467919E+00, 5.6210304183E+00, 6.3018725328E-01, 5.2537039920E-01, 6.5621381351E-01],
	[1.4145000000E+04, 7.2140186409E+00, 5.6206912636E+00, 6.3089369719E-01, 5.2587678312E-01, 6.5635226960E-01],
	[1.4150000000E+04, 7.2174909336E+00, 5.6203522491E+00, 6.3160068239E-01, 5.2638340421E-01, 6.5649069448E-01],
	[1.4155000000E+04, 7.2209636700E+00, 5.6200133749E+00, 6.3230820911E-01, 5.2689026238E-01, 6.5662908812E-01],
	[1.4160000000E+04, 7.2244368499E+00, 5.6196746407E+00, 6.3301627756E-01, 5.2739735751E-01, 6.5676745049E-01],
	[1.4165000000E+04, 7.2279104734E+00, 5.6193360466E+00, 6.3372488799E-01, 5.2790468950E-01, 6.5690578159E-01],
	[1.4170000000E+04, 7.2313845402E+00, 5.6189975923E+00, 6.3443404060E-01, 5.2841225823E-01, 6.5704408140E-01],
	[1.4175000000E+04, 7.2348590503E+00, 5.6186592778E+00, 6.3514373562E-01, 5.2892006361E-01, 6.5718234989E-01],
	[1.4180000000E+04, 7.2383340035E+00, 5.6183211030E+00, 6.3585397327E-01, 5.2942810552E-01, 6.5732058705E-01],
	[1.4185000000E+04, 7.2418093999E+00, 5.6179830678E+00, 6.3656475377E-01, 5.2993638385E-01, 6.5745879286E-01],
	[1.4190000000E+04, 7.2452852392E+00, 5.6176451720E+00, 6.3727607736E-01, 5.3044489850E-01, 6.5759696730E-01],
	[1.4195000000E+04, 7.2487615214E+00, 5.6173074156E+00, 6.3798794424E-01, 5.3095364936E-01, 6.5773511036E-01],
	[1.4200000000E+04, 7.2522382464E+00, 5.6169697984E+00, 6.3870035464E-01, 5.3146263632E-01, 6.5787322202E-01],
	[1.4205000000E+04, 7.2557154140E+00, 5.6166323203E+00, 6.3941330879E-01, 5.3197185927E-01, 6.5801130225E-01],
	[1.4210000000E+04, 7.2591930243E+00, 5.6162949813E+00, 6.4012680691E-01, 5.3248131810E-01, 6.5814935104E-01],
	[1.4215000000E+04, 7.2626710770E+00, 5.6159577812E+00, 6.4084084922E-01, 5.3299101271E-01, 6.5828736838E-01],
	[1.4220000000E+04, 7.2661495721E+00, 5.6156207200E+00, 6.4155543595E-01, 5.3350094298E-01, 6.5842535424E-01],
	[1.4225000000E+04, 7.2696285095E+00, 5.6152837974E+00, 6.4227056731E-01, 5.3401110880E-01, 6.5856330860E-01],
	[1.4230000000E+04, 7.2731078890E+00, 5.6149470135E+00, 6.4298624353E-01, 5.3452151007E-01, 6.5870123146E-01],
	[1.4235000000E+04, 7.2765877106E+00, 5.6146103680E+00, 6.4370246483E-01, 5.3503214667E-01, 6.5883912279E-01],
	[1.4240000000E+04, 7.2800679743E+00, 5.6142738610E+00, 6.4441923143E-01, 5.3554301850E-01, 6.5897698257E-01],
	[1.4245000000E+04, 7.2835486798E+00, 5.6139374922E+00, 6.4513654357E-01, 5.3605412545E-01, 6.5911481079E-01],
	[1.4250000000E+04, 7.2870298271E+00, 5.6136012617E+00, 6.4585440145E-01, 5.3656546740E-01, 6.5925260743E-01],
	[1.4255000000E+04, 7.2905114160E+00, 5.6132651692E+00, 6.4657280531E-01, 5.3707704424E-01, 6.5939037246E-01],
	[1.4260000000E+04, 7.2939934466E+00, 5.6129292147E+00, 6.4729175537E-01, 5.3758885587E-01, 6.5952810589E-01],
	[1.4265000000E+04, 7.2974759187E+00, 5.6125933981E+00, 6.4801125184E-01, 5.3810090217E-01, 6.5966580768E-01],
	[1.4270000000E+04, 7.3009588321E+00, 5.6122577192E+00, 6.4873129496E-01, 5.3861318304E-01, 6.5980347781E-01],
	[1.4275000000E+04, 7.3044421868E+00, 5.6119221780E+00, 6.4945188494E-01, 5.3912569835E-01, 6.5994111628E-01],
	[1.4280000000E+04, 7.3079259827E+00, 5.6115867744E+00, 6.5017302201E-01, 5.3963844801E-01, 6.6007872307E-01],
	[1.4285000000E+04, 7.3114102198E+00, 5.6112515082E+00, 6.5089470640E-01, 5.4015143190E-01, 6.6021629815E-01],
	[1.4290000000E+04, 7.3148948978E+00, 5.6109163793E+00, 6.5161693831E-01, 5.4066464991E-01, 6.6035384151E-01],
	[1.4295000000E+04, 7.3183800167E+00, 5.6105813877E+00, 6.5233971798E-01, 5.4117810192E-01, 6.6049135313E-01],
	[1.4300000000E+04, 7.3218655764E+00, 5.6102465333E+00, 6.5306304564E-01, 5.4169178783E-01, 6.6062883300E-01],
	[1.4305000000E+04, 7.3253515768E+00, 5.6099118158E+00, 6.5378692149E-01, 5.4220570752E-01, 6.6076628109E-01],
	[1.4310000000E+04, 7.3288380178E+00, 5.6095772354E+00, 6.5451134577E-01, 5.4271986088E-01, 6.6090369740E-01],
	[1.4315000000E+04, 7.3323248993E+00, 5.6092427917E+00, 6.5523631871E-01, 5.4323424780E-01, 6.6104108190E-01],
	[1.4320000000E+04, 7.3358122212E+00, 5.6089084848E+00, 6.5596184051E-01, 5.4374886817E-01, 6.6117843458E-01],
	[1.4325000000E+04, 7.3392999834E+00, 5.6085743144E+00, 6.5668791141E-01, 5.4426372187E-01, 6.6131575542E-01],
	[1.4330000000E+04, 7.3427881859E+00, 5.6082402806E+00, 6.5741453162E-01, 5.4477880880E-01, 6.6145304440E-01],
	[1.4335000000E+04, 7.3462768284E+00, 5.6079063833E+00, 6.5814170138E-01, 5.4529412883E-01, 6.6159030150E-01],
	[1.4340000000E+04, 7.3497659110E+00, 5.6075726222E+00, 6.5886942090E-01, 5.4580968186E-01, 6.6172752672E-01],
	[1.4345000000E+04, 7.3532554334E+00, 5.6072389973E+00, 6.5959769041E-01, 5.4632546777E-01, 6.6186472003E-01],
	[1.4350000000E+04, 7.3567537432E+00, 5.6069103880E+00, 6.6032651013E-01, 5.4684157898E-01, 6.6200188141E-01],
	[1.4355000000E+04, 7.3602547802E+00, 5.6065832457E+00, 6.6105588028E-01, 5.4735794846E-01, 6.6213901086E-01],
	[1.4360000000E+04, 7.3637562631E+00, 5.6062562365E+00, 6.6178580109E-01, 5.4787455084E-01, 6.6227610834E-01],
	[1.4365000000E+04, 7.3672581920E+00, 5.6059293602E+00, 6.6251627278E-01, 5.4839138600E-01, 6.6241317386E-01],
	[1.4370000000E+04, 7.3707605667E+00, 5.6056026167E+00, 6.6324729557E-01, 5.4890845384E-01, 6.6255020738E-01],
	[1.4375000000E+04, 7.3742633871E+00, 5.6052760059E+00, 6.6397886969E-01, 5.4942575423E-01, 6.6268720889E-01],
	[1.4380000000E+04, 7.3777666532E+00, 5.6049495277E+00, 6.6471099536E-01, 5.4994328707E-01, 6.6282417838E-01],
	[1.4385000000E+04, 7.3812703648E+00, 5.6046231820E+00, 6.6544367280E-01, 5.5046105223E-01, 6.6296111583E-01],
	[1.4390000000E+04, 7.3847745218E+00, 5.6042969687E+00, 6.6617690223E-01, 5.5097904962E-01, 6.6309802122E-01],
	[1.4395000000E+04, 7.3882791241E+00, 5.6039708877E+00, 6.6691068389E-01, 5.5149727910E-01, 6.6323489454E-01],
	[1.4400000000E+04, 7.3917841716E+00, 5.6036449389E+00, 6.6764501799E-01, 5.5201574058E-01, 6.6337173577E-01],
	[1.4405000000E+04, 7.3952896643E+00, 5.6033191222E+00, 6.6837990475E-01, 5.5253443392E-01, 6.6350854489E-01],
	[1.4410000000E+04, 7.3987956020E+00, 5.6029934375E+00, 6.6911534440E-01, 5.5305335903E-01, 6.6364532189E-01],
	[1.4415000000E+04, 7.4023019847E+00, 5.6026678847E+00, 6.6985133716E-01, 5.5357251578E-01, 6.6378206675E-01],
	[1.4420000000E+04, 7.4058088122E+00, 5.6023424638E+00, 6.7058788326E-01, 5.5409190406E-01, 6.6391877946E-01],
	[1.4425000000E+04, 7.4093160844E+00, 5.6020171745E+00, 6.7132498292E-01, 5.5461152376E-01, 6.6405545999E-01],
	[1.4430000000E+04, 7.4128238013E+00, 5.6016920169E+00, 6.7206263636E-01, 5.5513137475E-01, 6.6419210834E-01],
	[1.4435000000E+04, 7.4163319627E+00, 5.6013669908E+00, 6.7280084380E-01, 5.5565145693E-01, 6.6432872449E-01],
	[1.4440000000E+04, 7.4198405686E+00, 5.6010420960E+00, 6.7353960547E-01, 5.5617177018E-01, 6.6446530841E-01],
	[1.4445000000E+04, 7.4233496188E+00, 5.6007173326E+00, 6.7427892159E-01, 5.5669231438E-01, 6.6460186010E-01],
	[1.4450000000E+04, 7.4268591133E+00, 5.6003927004E+00, 6.7501879239E-01, 5.5721308941E-01, 6.6473837954E-01],
	[1.4455000000E+04, 7.4303690519E+00, 5.6000681994E+00, 6.7575921809E-01, 5.5773409517E-01, 6.6487486671E-01],
	[1.4460000000E+04, 7.4338794346E+00, 5.5997438293E+00, 6.7650019891E-01, 5.5825533153E-01, 6.6501132160E-01],
	[1.4465000000E+04, 7.4373902612E+00, 5.5994195902E+00, 6.7724173507E-01, 5.5877679838E-01, 6.6514774419E-01],
	[1.4470000000E+04, 7.4409015317E+00, 5.5990954819E+00, 6.7798382681E-01, 5.5929849561E-01, 6.6528413446E-01],
	[1.4475000000E+04, 7.4444132460E+00, 5.5987715043E+00, 6.7872647433E-01, 5.5982042309E-01, 6.6542049240E-01],
	[1.4480000000E+04, 7.4479254040E+00, 5.5984476573E+00, 6.7946967787E-01, 5.6034258070E-01, 6.6555681800E-01],
	[1.4485000000E+04, 7.4514380055E+00, 5.5981239409E+00, 6.8021343765E-01, 5.6086496834E-01, 6.6569311123E-01],
	[1.4490000000E+04, 7.4549510504E+00, 5.5978003549E+00, 6.8095775389E-01, 5.6138758589E-01, 6.6582937209E-01],
	[1.4495000000E+04, 7.4584645388E+00, 5.5974768992E+00, 6.8170262682E-01, 5.6191043322E-01, 6.6596560055E-01],
	[1.4500000000E+04, 7.4619784704E+00, 5.5971535738E+00, 6.8244805665E-01, 5.6243351023E-01, 6.6610179660E-01],
	[1.4505000000E+04, 7.4654928453E+00, 5.5968303785E+00, 6.8319404362E-01, 5.6295681679E-01, 6.6623796023E-01],
	[1.4510000000E+04, 7.4690076632E+00, 5.5965073132E+00, 6.8394058794E-01, 5.6348035278E-01, 6.6637409142E-01],
	[1.4515000000E+04, 7.4725229241E+00, 5.5961843779E+00, 6.8468768985E-01, 5.6400411809E-01, 6.6651019015E-01],
	[1.4520000000E+04, 7.4760386279E+00, 5.5958615725E+00, 6.8543534956E-01, 5.6452811261E-01, 6.6664625641E-01],
	[1.4525000000E+04, 7.4795547745E+00, 5.5955388968E+00, 6.8618356729E-01, 5.6505233620E-01, 6.6678229018E-01],
	[1.4530000000E+04, 7.4830713637E+00, 5.5952163507E+00, 6.8693234327E-01, 5.6557678876E-01, 6.6691829146E-01],
	[1.4535000000E+04, 7.4865883956E+00, 5.5948939342E+00, 6.8768167773E-01, 5.6610147016E-01, 6.6705426021E-01],
	[1.4540000000E+04, 7.4901058700E+00, 5.5945716472E+00, 6.8843157089E-01, 5.6662638029E-01, 6.6719019643E-01],
	[1.4545000000E+04, 7.4936237868E+00, 5.5942494895E+00, 6.8918202296E-01, 5.6715151903E-01, 6.6732610011E-01],
	[1.4550000000E+04, 7.4971421459E+00, 5.5939274611E+00, 6.8993303418E-01, 5.6767688626E-01, 6.6746197122E-01],
	[1.4555000000E+04, 7.5006609473E+00, 5.5936055619E+00, 6.9068460477E-01, 5.6820248186E-01, 6.6759780975E-01],
	[1.4560000000E+04, 7.5041801907E+00, 5.5932837917E+00, 6.9143673495E-01, 5.6872830571E-01, 6.6773361569E-01],
	[1.4565000000E+04, 7.5076998762E+00, 5.5929621505E+00, 6.9218942495E-01, 5.6925435770E-01, 6.6786938902E-01],
	[1.4570000000E+04, 7.5112200036E+00, 5.5926406382E+00, 6.9294267498E-01, 5.6978063769E-01, 6.6800512973E-01],
	[1.4575000000E+04, 7.5147405728E+00, 5.5923192547E+00, 6.9369648528E-01, 5.7030714558E-01, 6.6814083780E-01],
	[1.4580000000E+04, 7.5182681954E+00, 5.5920016396E+00, 6.9445085606E-01, 5.7083395729E-01, 6.6827651321E-01],
	[1.4585000000E+04, 7.5218007673E+00, 5.5916866295E+00, 6.9520578756E-01, 5.7136104873E-01, 6.6841215596E-01],
	[1.4590000000E+04, 7.5253337874E+00, 5.5913717451E+00, 6.9596127998E-01, 5.7188836808E-01, 6.6854776602E-01],
	[1.4595000000E+04, 7.5288672556E+00, 5.5910569863E+00, 6.9671733357E-01, 5.7241591523E-01, 6.6868334338E-01],
	[1.4600000000E+04, 7.5324011717E+00, 5.5907423531E+00, 6.9747394853E-01, 5.7294369004E-01, 6.6881888803E-01],
	[1.4605000000E+04, 7.5359355357E+00, 5.5904278453E+00, 6.9823112510E-01, 5.7347169241E-01, 6.6895439996E-01],
	[1.4610000000E+04, 7.5394703474E+00, 5.5901134628E+00, 6.9898886350E-01, 5.7399992220E-01, 6.6908987914E-01],
	[1.4615000000E+04, 7.5430056069E+00, 5.5897992055E+00, 6.9974716395E-01, 5.7452837931E-01, 6.6922532556E-01],
	[1.4620000000E+04, 7.5465413139E+00, 5.5894850734E+00, 7.0050602668E-01, 5.7505706361E-01, 6.6936073921E-01],
	[1.4625000000E+04, 7.5500774684E+00, 5.5891710664E+00, 7.0126545191E-01, 5.7558597497E-01, 6.6949612007E-01],
	[1.4630000000E+04, 7.5536140702E+00, 5.5888571843E+00, 7.0202543986E-01, 5.7611511329E-01, 6.6963146813E-01],
	[1.4635000000E+04, 7.5571511194E+00, 5.5885434271E+00, 7.0278599075E-01, 5.7664447843E-01, 6.6976678338E-01],
	[1.4640000000E+04, 7.5606886158E+00, 5.5882297947E+00, 7.0354710482E-01, 5.7717407028E-01, 6.6990206579E-01],
	[1.4645000000E+04, 7.5642265592E+00, 5.5879162870E+00, 7.0430878229E-01, 5.7770388872E-01, 6.7003731536E-01],
	[1.4650000000E+04, 7.5677649497E+00, 5.5876029038E+00, 7.0507102337E-01, 5.7823393362E-01, 6.7017253207E-01],
	[1.4655000000E+04, 7.5713037870E+00, 5.5872896452E+00, 7.0583382829E-01, 5.7876420487E-01, 6.7030771591E-01],
	[1.4660000000E+04, 7.5748430712E+00, 5.5869765110E+00, 7.0659719728E-01, 5.7929470234E-01, 6.7044286686E-01],
	[1.4665000000E+04, 7.5783828021E+00, 5.5866635011E+00, 7.0736113056E-01, 5.7982542591E-01, 6.7057798490E-01],
	[1.4670000000E+04, 7.5819229796E+00, 5.5863506154E+00, 7.0812562836E-01, 5.8035637546E-01, 6.7071307003E-01],
	[1.4675000000E+04, 7.5854636036E+00, 5.5860378539E+00, 7.0889069089E-01, 5.8088755087E-01, 6.7084812223E-01],
	[1.4680000000E+04, 7.5890046740E+00, 5.5857252164E+00, 7.0965631839E-01, 5.8141895201E-01, 6.7098314148E-01],
	[1.4685000000E+04, 7.5925461908E+00, 5.5854127029E+00, 7.1042251107E-01, 5.8195057877E-01, 6.7111812777E-01],
	[1.4690000000E+04, 7.5960881538E+00, 5.5851003132E+00, 7.1118926916E-01, 5.8248243101E-01, 6.7125308109E-01],
	[1.4695000000E+04, 7.5996305629E+00, 5.5847880473E+00, 7.1195659289E-01, 5.8301450862E-01, 6.7138800142E-01],
	[1.4700000000E+04, 7.6031734181E+00, 5.5844759051E+00, 7.1272448247E-01, 5.8354681148E-01, 6.7152288874E-01],
	[1.4705000000E+04, 7.6067167192E+00, 5.5841638865E+00, 7.1349293813E-01, 5.8407933947E-01, 6.7165774305E-01],
	[1.4710000000E+04, 7.6102604661E+00, 5.5838519914E+00, 7.1426196010E-01, 5.8461209245E-01, 6.7179256433E-01],
	[1.4715000000E+04, 7.6138046589E+00, 5.5835402197E+00, 7.1503154860E-01, 5.8514507031E-01, 6.7192735257E-01],
	[1.4720000000E+04, 7.6173492972E+00, 5.5832285713E+00, 7.1580170385E-01, 5.8567827292E-01, 6.7206210775E-01],
	[1.4725000000E+04, 7.6208943812E+00, 5.5829170461E+00, 7.1657242608E-01, 5.8621170016E-01, 6.7219682985E-01],
	[1.4730000000E+04, 7.6244399106E+00, 5.5826056441E+00, 7.1734371552E-01, 5.8674535191E-01, 6.7233151887E-01],
	[1.4735000000E+04, 7.6279858854E+00, 5.5822943651E+00, 7.1811557237E-01, 5.8727922804E-01, 6.7246617480E-01],
	[1.4740000000E+04, 7.6315323055E+00, 5.5819832091E+00, 7.1888799688E-01, 5.8781332843E-01, 6.7260079760E-01],
	[1.4745000000E+04, 7.6350791707E+00, 5.5816721759E+00, 7.1966098926E-01, 5.8834765296E-01, 6.7273538728E-01],
	[1.4750000000E+04, 7.6386264810E+00, 5.5813612655E+00, 7.2043454974E-01, 5.8888220149E-01, 6.7286994382E-01],
	[1.4755000000E+04, 7.6421742364E+00, 5.5810504778E+00, 7.2120867854E-01, 5.8941697392E-01, 6.7300446720E-01],
	[1.4760000000E+04, 7.6457224366E+00, 5.5807398127E+00, 7.2198337589E-01, 5.8995197011E-01, 6.7313895742E-01],
	[1.4765000000E+04, 7.6492710816E+00, 5.5804292701E+00, 7.2275864200E-01, 5.9048718993E-01, 6.7327341445E-01],
	[1.4770000000E+04, 7.6528201714E+00, 5.5801188499E+00, 7.2353447711E-01, 5.9102263327E-01, 6.7340783829E-01],
	[1.4775000000E+04, 7.6563697057E+00, 5.5798085520E+00, 7.2431088144E-01, 5.9155830000E-01, 6.7354222892E-01],
	[1.4780000000E+04, 7.6599196846E+00, 5.5794983764E+00, 7.2508785521E-01, 5.9209418999E-01, 6.7367658632E-01],
	[1.4785000000E+04, 7.6634701079E+00, 5.5791883229E+00, 7.2586539865E-01, 5.9263030312E-01, 6.7381091049E-01],
	[1.4790000000E+04, 7.6670209755E+00, 5.5788783915E+00, 7.2664351198E-01, 5.9316663926E-01, 6.7394520141E-01],
	[1.4795000000E+04, 7.6705722873E+00, 5.5785685821E+00, 7.2742219542E-01, 5.9370319829E-01, 6.7407945907E-01],
	[1.4800000000E+04, 7.6741240433E+00, 5.5782588945E+00, 7.2820144921E-01, 5.9423998008E-01, 6.7421368345E-01],
	[1.4805000000E+04, 7.6776762434E+00, 5.5779493287E+00, 7.2898127355E-01, 5.9477698451E-01, 6.7434787454E-01],
	[1.4810000000E+04, 7.6812288873E+00, 5.5776398846E+00, 7.2976166868E-01, 5.9531421146E-01, 6.7448203233E-01],
	[1.4815000000E+04, 7.6847896447E+00, 5.5773345436E+00, 7.3054263483E-01, 5.9585175233E-01, 6.7461615680E-01],
	[1.4820000000E+04, 7.6883547878E+00, 5.5770313653E+00, 7.3132417221E-01, 5.9638956279E-01, 6.7475024794E-01],
	[1.4825000000E+04, 7.6919203814E+00, 5.5767283058E+00, 7.3210628105E-01, 5.9692759577E-01, 6.7488430574E-01],
	[1.4830000000E+04, 7.6954864253E+00, 5.5764253649E+00, 7.3288896158E-01, 5.9746585116E-01, 6.7501833018E-01],
	[1.4835000000E+04, 7.6990529196E+00, 5.5761225426E+00, 7.3367221401E-01, 5.9800432883E-01, 6.7515232126E-01],
	[1.4840000000E+04, 7.7026198641E+00, 5.5758198388E+00, 7.3445603858E-01, 5.9854302865E-01, 6.7528627895E-01],
	[1.4845000000E+04, 7.7061872587E+00, 5.5755172534E+00, 7.3524043550E-01, 5.9908195049E-01, 6.7542020325E-01],
	[1.4850000000E+04, 7.7097551034E+00, 5.5752147863E+00, 7.3602540501E-01, 5.9962109423E-01, 6.7555409414E-01],
	[1.4855000000E+04, 7.7133233980E+00, 5.5749124374E+00, 7.3681094732E-01, 6.0016045975E-01, 6.7568795161E-01],
	[1.4860000000E+04, 7.7168921424E+00, 5.5746102067E+00, 7.3759706266E-01, 6.0070004691E-01, 6.7582177564E-01],
	[1.4865000000E+04, 7.7204613365E+00, 5.5743080940E+00, 7.3838375125E-01, 6.0123985560E-01, 6.7595556623E-01],
	[1.4870000000E+04, 7.7240309803E+00, 5.5740060992E+00, 7.3917101333E-01, 6.0177988567E-01, 6.7608932336E-01],
	[1.4875000000E+04, 7.7276010737E+00, 5.5737042224E+00, 7.3995884911E-01, 6.0232013701E-01, 6.7622304702E-01],
	[1.4880000000E+04, 7.7311716165E+00, 5.5734024633E+00, 7.4074725881E-01, 6.0286060949E-01, 6.7635673719E-01],
	[1.4885000000E+04, 7.7347426087E+00, 5.5731008220E+00, 7.4153624267E-01, 6.0340130299E-01, 6.7649039386E-01],
	[1.4890000000E+04, 7.7383140501E+00, 5.5727992983E+00, 7.4232580091E-01, 6.0394221736E-01, 6.7662401703E-01],
	[1.4895000000E+04, 7.7418859407E+00, 5.5724978921E+00, 7.4311593374E-01, 6.0448335249E-01, 6.7675760667E-01],
	[1.4900000000E+04, 7.7454582804E+00, 5.5721966033E+00, 7.4390664140E-01, 6.0502470825E-01, 6.7689116277E-01],
	[1.4905000000E+04, 7.7490310691E+00, 5.5718954320E+00, 7.4469792411E-01, 6.0556628451E-01, 6.7702468533E-01],
	[1.4910000000E+04, 7.7526043066E+00, 5.5715943779E+00, 7.4548978209E-01, 6.0610808114E-01, 6.7715817432E-01],
	[1.4915000000E+04, 7.7561779930E+00, 5.5712934410E+00, 7.4628221558E-01, 6.0665009802E-01, 6.7729162974E-01],
	[1.4920000000E+04, 7.7597521281E+00, 5.5709926213E+00, 7.4707522478E-01, 6.0719233501E-01, 6.7742505157E-01],
	[1.4925000000E+04, 7.7633267118E+00, 5.5706919185E+00, 7.4786880994E-01, 6.0773479199E-01, 6.7755843981E-01],
	[1.4930000000E+04, 7.7669017439E+00, 5.5703913327E+00, 7.4866297126E-01, 6.0827746883E-01, 6.7769179443E-01],
	[1.4935000000E+04, 7.7704772246E+00, 5.5700908638E+00, 7.4945770898E-01, 6.0882036540E-01, 6.7782511543E-01],
	[1.4940000000E+04, 7.7740531535E+00, 5.5697905116E+00, 7.5025302332E-01, 6.0936348157E-01, 6.7795840280E-01],
	[1.4945000000E+04, 7.7776295307E+00, 5.5694902762E+00, 7.5104891451E-01, 6.0990681721E-01, 6.7809165652E-01],
	[1.4950000000E+04, 7.7812063560E+00, 5.5691901573E+00, 7.5184538277E-01, 6.1045037220E-01, 6.7822487657E-01],
	[1.4955000000E+04, 7.7847836293E+00, 5.5688901550E+00, 7.5264242832E-01, 6.1099414640E-01, 6.7835806296E-01],
	[1.4960000000E+04, 7.7883613506E+00, 5.5685902690E+00, 7.5344005139E-01, 6.1153813968E-01, 6.7849121566E-01],
	[1.4965000000E+04, 7.7919395198E+00, 5.5682904995E+00, 7.5423825221E-01, 6.1208235192E-01, 6.7862433466E-01],
	[1.4970000000E+04, 7.7955181367E+00, 5.5679908462E+00, 7.5503703099E-01, 6.1262678299E-01, 6.7875741995E-01],
	[1.4975000000E+04, 7.7990972013E+00, 5.5676913091E+00, 7.5583638797E-01, 6.1317143275E-01, 6.7889047152E-01],
	[1.4980000000E+04, 7.8026767135E+00, 5.5673918881E+00, 7.5663632336E-01, 6.1371630108E-01, 6.7902348936E-01],
	[1.4985000000E+04, 7.8062566732E+00, 5.5670925831E+00, 7.5743683740E-01, 6.1426138784E-01, 6.7915647345E-01],
	[1.4990000000E+04, 7.8098370802E+00, 5.5667933941E+00, 7.5823793030E-01, 6.1480669291E-01, 6.7928942379E-01],
	[1.4995000000E+04, 7.8134179345E+00, 5.5664943209E+00, 7.5903960230E-01, 6.1535221616E-01, 6.7942234035E-01],
	[1.5000000000E+04, 7.8169992361E+00, 5.5661953635E+00, 7.5984185361E-01, 6.1589795745E-01, 6.7955522314E-01],
	[1.5005000000E+04, 7.8205809848E+00, 5.5658965217E+00, 7.6064713539E-01, 6.1644552638E-01, 6.7968807213E-01],
	[1.5010000000E+04, 7.8241631804E+00, 5.5655977956E+00, 7.6145300136E-01, 6.1699331491E-01, 6.7982088731E-01],
	[1.5015000000E+04, 7.8277458230E+00, 5.5652991850E+00, 7.6225945176E-01, 6.1754132291E-01, 6.7995366868E-01],
	[1.5020000000E+04, 7.8313289125E+00, 5.5650006898E+00, 7.6306648681E-01, 6.1808955023E-01, 6.8008641622E-01],
	[1.5025000000E+04, 7.8349124486E+00, 5.5647023099E+00, 7.6387410673E-01, 6.1863799675E-01, 6.8021912992E-01],
	[1.5030000000E+04, 7.8384964315E+00, 5.5644040454E+00, 7.6468231177E-01, 6.1918666234E-01, 6.8035180977E-01],
	[1.5035000000E+04, 7.8420808608E+00, 5.5641058960E+00, 7.6549110214E-01, 6.1973554687E-01, 6.8048445575E-01],
	[1.5040000000E+04, 7.8456657367E+00, 5.5638078617E+00, 7.6630047808E-01, 6.2028465020E-01, 6.8061706786E-01],
	[1.5045000000E+04, 7.8492510589E+00, 5.5635099424E+00, 7.6711043981E-01, 6.2083397220E-01, 6.8074964608E-01],
	[1.5050000000E+04, 7.8528368273E+00, 5.5632121381E+00, 7.6792098756E-01, 6.2138351273E-01, 6.8088219040E-01],
	[1.5055000000E+04, 7.8564347899E+00, 5.5629202133E+00, 7.6873212156E-01, 6.2193341735E-01, 6.8101470080E-01],
	[1.5060000000E+04, 7.8600335539E+00, 5.5626285717E+00, 7.6954384204E-01, 6.2248354496E-01, 6.8114717727E-01],
	[1.5065000000E+04, 7.8636327709E+00, 5.5623370421E+00, 7.7035614923E-01, 6.2303389114E-01, 6.8127961978E-01],
	[1.5070000000E+04, 7.8672324408E+00, 5.5620456245E+00, 7.7116904335E-01, 6.2358445575E-01, 6.8141202831E-01],
	[1.5075000000E+04, 7.8708325636E+00, 5.5617543189E+00, 7.7198252464E-01, 6.2413523864E-01, 6.8154440285E-01],
	[1.5080000000E+04, 7.8744331391E+00, 5.5614631251E+00, 7.7279659332E-01, 6.2468623970E-01, 6.8167674340E-01],
	[1.5085000000E+04, 7.8780341673E+00, 5.5611720431E+00, 7.7361124962E-01, 6.2523745879E-01, 6.8180904992E-01],
	[1.5090000000E+04, 7.8816356481E+00, 5.5608810727E+00, 7.7442649377E-01, 6.2578889577E-01, 6.8194132241E-01],
	[1.5095000000E+04, 7.8852375813E+00, 5.5605902140E+00, 7.7524232600E-01, 6.2634055051E-01, 6.8207356084E-01],
	[1.5100000000E+04, 7.8888399670E+00, 5.5602994668E+00, 7.7605874654E-01, 6.2689242288E-01, 6.8220576522E-01],
	[1.5105000000E+04, 7.8924428049E+00, 5.5600088311E+00, 7.7687575561E-01, 6.2744451275E-01, 6.8233793551E-01],
	[1.5110000000E+04, 7.8960460951E+00, 5.5597183068E+00, 7.7769335345E-01, 6.2799681998E-01, 6.8247007171E-01],
	[1.5115000000E+04, 7.8996498373E+00, 5.5594278937E+00, 7.7851154028E-01, 6.2854934443E-01, 6.8260217380E-01],
	[1.5120000000E+04, 7.9032540316E+00, 5.5591375919E+00, 7.7933031633E-01, 6.2910208598E-01, 6.8273424176E-01],
	[1.5125000000E+04, 7.9068586778E+00, 5.5588474012E+00, 7.8014968184E-01, 6.2965504448E-01, 6.8286627559E-01],
	[1.5130000000E+04, 7.9104637758E+00, 5.5585573215E+00, 7.8096963702E-01, 6.3020821982E-01, 6.8299827526E-01],
	[1.5135000000E+04, 7.9140693255E+00, 5.5582673528E+00, 7.8179018211E-01, 6.3076161184E-01, 6.8313024076E-01],
	[1.5140000000E+04, 7.9176753269E+00, 5.5579774950E+00, 7.8261131734E-01, 6.3131522042E-01, 6.8326217208E-01],
	[1.5145000000E+04, 7.9212817799E+00, 5.5576877481E+00, 7.8343304294E-01, 6.3186904542E-01, 6.8339406920E-01],
	[1.5150000000E+04, 7.9248886843E+00, 5.5573981119E+00, 7.8425535912E-01, 6.3242308671E-01, 6.8352593210E-01],
	[1.5155000000E+04, 7.9284960400E+00, 5.5571085863E+00, 7.8507826613E-01, 6.3297734415E-01, 6.8365776078E-01],
	[1.5160000000E+04, 7.9321038471E+00, 5.5568191713E+00, 7.8590176420E-01, 6.3353181760E-01, 6.8378955522E-01],
	[1.5165000000E+04, 7.9357121053E+00, 5.5565298668E+00, 7.8672585354E-01, 6.3408650694E-01, 6.8392131539E-01],
	[1.5170000000E+04, 7.9393208146E+00, 5.5562406728E+00, 7.8755053439E-01, 6.3464141203E-01, 6.8405304130E-01],
	[1.5175000000E+04, 7.9429299749E+00, 5.5559515891E+00, 7.8837580698E-01, 6.3519653273E-01, 6.8418473292E-01],
	[1.5180000000E+04, 7.9465395862E+00, 5.5556626156E+00, 7.8920167154E-01, 6.3575186890E-01, 6.8431639024E-01],
	[1.5185000000E+04, 7.9501496482E+00, 5.5553737524E+00, 7.9002812830E-01, 6.3630742042E-01, 6.8444801324E-01],
	[1.5190000000E+04, 7.9537601609E+00, 5.5550849993E+00, 7.9085517747E-01, 6.3686318714E-01, 6.8457960191E-01],
	[1.5195000000E+04, 7.9573711243E+00, 5.5547963561E+00, 7.9168281931E-01, 6.3741916892E-01, 6.8471115624E-01],
	[1.5200000000E+04, 7.9609825382E+00, 5.5545078230E+00, 7.9251105402E-01, 6.3797536564E-01, 6.8484267621E-01],
	[1.5205000000E+04, 7.9645944026E+00, 5.5542193997E+00, 7.9333988185E-01, 6.3853177716E-01, 6.8497416181E-01],
	[1.5210000000E+04, 7.9682067173E+00, 5.5539310862E+00, 7.9416930301E-01, 6.3908840334E-01, 6.8510561302E-01],
	[1.5215000000E+04, 7.9718194823E+00, 5.5536428825E+00, 7.9499931775E-01, 6.3964524404E-01, 6.8523702983E-01],
	[1.5220000000E+04, 7.9754326974E+00, 5.5533547884E+00, 7.9582992628E-01, 6.4020229913E-01, 6.8536841223E-01],
	[1.5225000000E+04, 7.9790463626E+00, 5.5530668038E+00, 7.9666112884E-01, 6.4075956847E-01, 6.8549976020E-01],
	[1.5230000000E+04, 7.9826604778E+00, 5.5527789288E+00, 7.9749292566E-01, 6.4131705192E-01, 6.8563107372E-01],
	[1.5235000000E+04, 7.9862750429E+00, 5.5524911631E+00, 7.9832531696E-01, 6.4187474935E-01, 6.8576235278E-01],
	[1.5240000000E+04, 7.9898900578E+00, 5.5522035068E+00, 7.9915830297E-01, 6.4243266062E-01, 6.8589359738E-01],
	[1.5245000000E+04, 7.9935055224E+00, 5.5519159597E+00, 7.9999188393E-01, 6.4299078559E-01, 6.8602480749E-01],
	[1.5250000000E+04, 7.9971214367E+00, 5.5516285218E+00, 8.0082606006E-01, 6.4354912413E-01, 6.8615598310E-01],
	[1.5255000000E+04, 8.0007378004E+00, 5.5513411931E+00, 8.0166083159E-01, 6.4410767609E-01, 6.8628712419E-01],
	[1.5260000000E+04, 8.0043546136E+00, 5.5510539733E+00, 8.0249619875E-01, 6.4466644134E-01, 6.8641823076E-01],
	[1.5265000000E+04, 8.0079718761E+00, 5.5507668625E+00, 8.0333216177E-01, 6.4522541975E-01, 6.8654930279E-01],
	[1.5270000000E+04, 8.0115895879E+00, 5.5504798605E+00, 8.0416872088E-01, 6.4578461117E-01, 6.8668034027E-01],
	[1.5275000000E+04, 8.0152077489E+00, 5.5501929674E+00, 8.0500587630E-01, 6.4634401547E-01, 6.8681134317E-01],
	[1.5280000000E+04, 8.0188263589E+00, 5.5499061829E+00, 8.0584362827E-01, 6.4690363251E-01, 6.8694231150E-01],
	[1.5285000000E+04, 8.0224454179E+00, 5.5496195072E+00, 8.0668197702E-01, 6.4746346214E-01, 6.8707324522E-01],
	[1.5290000000E+04, 8.0260649258E+00, 5.5493329399E+00, 8.0752092277E-01, 6.4802350424E-01, 6.8720414434E-01],
	[1.5295000000E+04, 8.0296913424E+00, 5.5490494895E+00, 8.0836046575E-01, 6.4858384190E-01, 6.8733500884E-01],
	[1.5300000000E+04, 8.0333243252E+00, 5.5487689919E+00, 8.0920060620E-01, 6.4914447085E-01, 6.8746583870E-01],
	[1.5305000000E+04, 8.0369577638E+00, 5.5484886000E+00, 8.1004134434E-01, 6.4970531228E-01, 6.8759663391E-01],
	[1.5310000000E+04, 8.0405916582E+00, 5.5482083140E+00, 8.1088268039E-01, 6.5026636606E-01, 6.8772739446E-01],
	[1.5315000000E+04, 8.0442260083E+00, 5.5479281336E+00, 8.1172461460E-01, 6.5082763205E-01, 6.8785812033E-01],
	[1.5320000000E+04, 8.0478608139E+00, 5.5476480588E+00, 8.1256714719E-01, 6.5138911012E-01, 6.8798881151E-01],
	[1.5325000000E+04, 8.0514960751E+00, 5.5473680895E+00, 8.1341027839E-01, 6.5195080012E-01, 6.8811946799E-01],
	[1.5330000000E+04, 8.0551317916E+00, 5.5470882257E+00, 8.1425400842E-01, 6.5251270191E-01, 6.8825008975E-01],
	[1.5335000000E+04, 8.0587679635E+00, 5.5468084673E+00, 8.1509833752E-01, 6.5307481536E-01, 6.8838067678E-01],
	[1.5340000000E+04, 8.0624045905E+00, 5.5465288141E+00, 8.1594326592E-01, 6.5363714032E-01, 6.8851122906E-01],
	[1.5345000000E+04, 8.0660416727E+00, 5.5462492662E+00, 8.1678879384E-01, 6.5419967666E-01, 6.8864174660E-01],
	[1.5350000000E+04, 8.0696792100E+00, 5.5459698235E+00, 8.1763492152E-01, 6.5476242424E-01, 6.8877222936E-01],
	[1.5355000000E+04, 8.0733172022E+00, 5.5456904858E+00, 8.1848164918E-01, 6.5532538292E-01, 6.8890267734E-01],
	[1.5360000000E+04, 8.0769556492E+00, 5.5454112531E+00, 8.1932897705E-01, 6.5588855256E-01, 6.8903309052E-01],
	[1.5365000000E+04, 8.0805945510E+00, 5.5451321254E+00, 8.2017690537E-01, 6.5645193302E-01, 6.8916346890E-01],
	[1.5370000000E+04, 8.0842339074E+00, 5.5448531025E+00, 8.2102543435E-01, 6.5701552415E-01, 6.8929381245E-01],
	[1.5375000000E+04, 8.0878737185E+00, 5.5445741844E+00, 8.2187456424E-01, 6.5757932583E-01, 6.8942412117E-01],
	[1.5380000000E+04, 8.0915139840E+00, 5.5442953711E+00, 8.2272429526E-01, 6.5814333790E-01, 6.8955439504E-01],
	[1.5385000000E+04, 8.0951547039E+00, 5.5440166623E+00, 8.2357462764E-01, 6.5870756024E-01, 6.8968463405E-01],
	[1.5390000000E+04, 8.0987958782E+00, 5.5437380582E+00, 8.2442556161E-01, 6.5927199269E-01, 6.8981483819E-01],
	[1.5395000000E+04, 8.1024375066E+00, 5.5434595585E+00, 8.2527709739E-01, 6.5983663512E-01, 6.8994500744E-01],
	[1.5400000000E+04, 8.1060795892E+00, 5.5431811632E+00, 8.2612923523E-01, 6.6040148739E-01, 6.9007514179E-01],
	[1.5405000000E+04, 8.1097221258E+00, 5.5429028723E+00, 8.2698197534E-01, 6.6096654936E-01, 6.9020524123E-01],
	[1.5410000000E+04, 8.1133651163E+00, 5.5426246857E+00, 8.2783531795E-01, 6.6153182088E-01, 6.9033530575E-01],
	[1.5415000000E+04, 8.1170085607E+00, 5.5423466033E+00, 8.2868926331E-01, 6.6209730182E-01, 6.9046533533E-01],
	[1.5420000000E+04, 8.1206524589E+00, 5.5420686250E+00, 8.2954381162E-01, 6.6266299203E-01, 6.9059532996E-01],
	[1.5425000000E+04, 8.1242968107E+00, 5.5417907508E+00, 8.3039896314E-01, 6.6322889137E-01, 6.9072528963E-01],
	[1.5430000000E+04, 8.1279416161E+00, 5.5415129805E+00, 8.3125471807E-01, 6.6379499971E-01, 6.9085521432E-01],
	[1.5435000000E+04, 8.1315868750E+00, 5.5412353142E+00, 8.3211107666E-01, 6.6436131689E-01, 6.9098510403E-01],
	[1.5440000000E+04, 8.1352325873E+00, 5.5409577517E+00, 8.3296803914E-01, 6.6492784279E-01, 6.9111495874E-01],
	[1.5445000000E+04, 8.1388787529E+00, 5.5406802929E+00, 8.3382560573E-01, 6.6549457725E-01, 6.9124477843E-01],
	[1.5450000000E+04, 8.1425253717E+00, 5.5404029379E+00, 8.3468377665E-01, 6.6606152013E-01, 6.9137456311E-01],
	[1.5455000000E+04, 8.1461724437E+00, 5.5401256865E+00, 8.3554255215E-01, 6.6662867130E-01, 6.9150431274E-01],
	[1.5460000000E+04, 8.1498199687E+00, 5.5398485386E+00, 8.3640193246E-01, 6.6719603061E-01, 6.9163402733E-01],
	[1.5465000000E+04, 8.1534679466E+00, 5.5395714942E+00, 8.3726191779E-01, 6.6776359792E-01, 6.9176370685E-01],
	[1.5470000000E+04, 8.1571163774E+00, 5.5392945532E+00, 8.3812250838E-01, 6.6833137308E-01, 6.9189335130E-01],
	[1.5475000000E+04, 8.1607652609E+00, 5.5390177155E+00, 8.3898370446E-01, 6.6889935596E-01, 6.9202296067E-01],
	[1.5480000000E+04, 8.1644145972E+00, 5.5387409811E+00, 8.3984550627E-01, 6.6946754641E-01, 6.9215253493E-01],
	[1.5485000000E+04, 8.1680643860E+00, 5.5384643499E+00, 8.4070791402E-01, 6.7003594429E-01, 6.9228207409E-01],
	[1.5490000000E+04, 8.1717146273E+00, 5.5381878218E+00, 8.4157092795E-01, 6.7060454945E-01, 6.9241157813E-01],
	[1.5495000000E+04, 8.1753653210E+00, 5.5379113968E+00, 8.4243454829E-01, 6.7117336176E-01, 6.9254104703E-01],
	[1.5500000000E+04, 8.1790164671E+00, 5.5376350747E+00, 8.4329877526E-01, 6.7174238106E-01, 6.9267048078E-01],
	[1.5505000000E+04, 8.1826680653E+00, 5.5373588556E+00, 8.4416360910E-01, 6.7231160723E-01, 6.9279987938E-01],
	[1.5510000000E+04, 8.1863201157E+00, 5.5370827392E+00, 8.4502905005E-01, 6.7288104010E-01, 6.9292924280E-01],
	[1.5515000000E+04, 8.1899726182E+00, 5.5368067256E+00, 8.4589509831E-01, 6.7345067955E-01, 6.9305857105E-01],
	[1.5520000000E+04, 8.1936255726E+00, 5.5365308147E+00, 8.4676175414E-01, 6.7402052542E-01, 6.9318786410E-01],
	[1.5525000000E+04, 8.1972789788E+00, 5.5362550065E+00, 8.4762901775E-01, 6.7459057757E-01, 6.9331712195E-01],
	[1.5530000000E+04, 8.2009328369E+00, 5.5359793007E+00, 8.4849688937E-01, 6.7516083586E-01, 6.9344634457E-01],
	[1.5535000000E+04, 8.2045871466E+00, 5.5357036975E+00, 8.4936536924E-01, 6.7573130015E-01, 6.9357553197E-01],
	[1.5540000000E+04, 8.2082455153E+00, 5.5354297928E+00, 8.5023445759E-01, 6.7630201860E-01, 6.9370468413E-01],
	[1.5545000000E+04, 8.2119137851E+00, 5.5351601681E+00, 8.5110415464E-01, 6.7687306956E-01, 6.9383380104E-01],
	[1.5550000000E+04, 8.2155825137E+00, 5.5348906433E+00, 8.5197446063E-01, 6.7744432654E-01, 6.9396288268E-01],
	[1.5555000000E+04, 8.2192517011E+00, 5.5346212182E+00, 8.5284537578E-01, 6.7801578941E-01, 6.9409192904E-01],
	[1.5560000000E+04, 8.2229213472E+00, 5.5343518928E+00, 8.5371690032E-01, 6.7858745801E-01, 6.9422094012E-01],
	[1.5565000000E+04, 8.2265914519E+00, 5.5340826670E+00, 8.5458903449E-01, 6.7915933221E-01, 6.9434991590E-01],
	[1.5570000000E+04, 8.2302620151E+00, 5.5338135408E+00, 8.5546177852E-01, 6.7973141186E-01, 6.9447885637E-01],
	[1.5575000000E+04, 8.2339330367E+00, 5.5335445141E+00, 8.5633513262E-01, 6.8030369681E-01, 6.9460776151E-01],
	[1.5580000000E+04, 8.2376045166E+00, 5.5332755868E+00, 8.5720909704E-01, 6.8087618693E-01, 6.9473663133E-01],
	[1.5585000000E+04, 8.2412764547E+00, 5.5330067588E+00, 8.5808367201E-01, 6.8144888206E-01, 6.9486546580E-01],
	[1.5590000000E+04, 8.2449488510E+00, 5.5327380302E+00, 8.5895885774E-01, 6.8202178206E-01, 6.9499426491E-01],
	[1.5595000000E+04, 8.2486217054E+00, 5.5324694007E+00, 8.5983465448E-01, 6.8259488680E-01, 6.9512302865E-01],
	[1.5600000000E+04, 8.2522950177E+00, 5.5322008705E+00, 8.6071106246E-01, 6.8316819611E-01, 6.9525175702E-01],
	[1.5605000000E+04, 8.2559687879E+00, 5.5319324392E+00, 8.6158808189E-01, 6.8374170987E-01, 6.9538045000E-01],
	[1.5610000000E+04, 8.2596430159E+00, 5.5316641071E+00, 8.6246571302E-01, 6.8431542791E-01, 6.9550910757E-01],
	[1.5615000000E+04, 8.2633177015E+00, 5.5313958738E+00, 8.6334395607E-01, 6.8488935010E-01, 6.9563772974E-01],
	[1.5620000000E+04, 8.2669928448E+00, 5.5311277394E+00, 8.6422281128E-01, 6.8546347630E-01, 6.9576631648E-01],
	[1.5625000000E+04, 8.2706684456E+00, 5.5308597039E+00, 8.6510227886E-01, 6.8603780635E-01, 6.9589486778E-01],
	[1.5630000000E+04, 8.2743445038E+00, 5.5305917670E+00, 8.6598235906E-01, 6.8661234011E-01, 6.9602338364E-01],
	[1.5635000000E+04, 8.2780210194E+00, 5.5303239289E+00, 8.6686305210E-01, 6.8718707744E-01, 6.9615186405E-01],
	[1.5640000000E+04, 8.2816979922E+00, 5.5300561894E+00, 8.6774435821E-01, 6.8776201819E-01, 6.9628030898E-01],
	[1.5645000000E+04, 8.2853754221E+00, 5.5297885483E+00, 8.6862627763E-01, 6.8833716221E-01, 6.9640871844E-01],
	[1.5650000000E+04, 8.2890533092E+00, 5.5295210058E+00, 8.6950881058E-01, 6.8891250935E-01, 6.9653709241E-01],
	[1.5655000000E+04, 8.2927316532E+00, 5.5292535617E+00, 8.7039195729E-01, 6.8948805948E-01, 6.9666543088E-01],
	[1.5660000000E+04, 8.2964104541E+00, 5.5289862159E+00, 8.7127571799E-01, 6.9006381244E-01, 6.9679373383E-01],
	[1.5665000000E+04, 8.3000897118E+00, 5.5287189683E+00, 8.7216009291E-01, 6.9063976809E-01, 6.9692200127E-01],
	[1.5670000000E+04, 8.3037694262E+00, 5.5284518190E+00, 8.7304508229E-01, 6.9121592629E-01, 6.9705023317E-01],
	[1.5675000000E+04, 8.3074495972E+00, 5.5281847678E+00, 8.7393068635E-01, 6.9179228687E-01, 6.9717842953E-01],
	[1.5680000000E+04, 8.3111302248E+00, 5.5279178146E+00, 8.7481690532E-01, 6.9236884971E-01, 6.9730659033E-01],
	[1.5685000000E+04, 8.3148113088E+00, 5.5276509595E+00, 8.7570373944E-01, 6.9294561465E-01, 6.9743471557E-01],
	[1.5690000000E+04, 8.3184928492E+00, 5.5273842023E+00, 8.7659118893E-01, 6.9352258154E-01, 6.9756280524E-01],
	[1.5695000000E+04, 8.3221748458E+00, 5.5271175429E+00, 8.7747925402E-01, 6.9409975024E-01, 6.9769085932E-01],
	[1.5700000000E+04, 8.3258572986E+00, 5.5268509813E+00, 8.7836793494E-01, 6.9467712060E-01, 6.9781887780E-01],
	[1.5705000000E+04, 8.3295402075E+00, 5.5265845175E+00, 8.7925723193E-01, 6.9525469247E-01, 6.9794686067E-01],
	[1.5710000000E+04, 8.3332235724E+00, 5.5263181513E+00, 8.8014714521E-01, 6.9583246571E-01, 6.9807480793E-01],
	[1.5715000000E+04, 8.3369073932E+00, 5.5260518827E+00, 8.8103767501E-01, 6.9641044016E-01, 6.9820271956E-01],
	[1.5720000000E+04, 8.3405916699E+00, 5.5257857117E+00, 8.8192882157E-01, 6.9698861569E-01, 6.9833059555E-01],
	[1.5725000000E+04, 8.3442764022E+00, 5.5255196381E+00, 8.8282058511E-01, 6.9756699214E-01, 6.9845843590E-01],
	[1.5730000000E+04, 8.3479615903E+00, 5.5252536619E+00, 8.8371296586E-01, 6.9814556936E-01, 6.9858624058E-01],
	[1.5735000000E+04, 8.3516472339E+00, 5.5249877830E+00, 8.8460596406E-01, 6.9872434720E-01, 6.9871400959E-01],
	[1.5740000000E+04, 8.3553333329E+00, 5.5247220014E+00, 8.8549957993E-01, 6.9930332553E-01, 6.9884174293E-01],
	[1.5745000000E+04, 8.3590198873E+00, 5.5244563170E+00, 8.8639381371E-01, 6.9988250419E-01, 6.9896944057E-01],
	[1.5750000000E+04, 8.3627068971E+00, 5.5241907297E+00, 8.8728866562E-01, 7.0046188302E-01, 6.9909710252E-01],
	[1.5755000000E+04, 8.3663943620E+00, 5.5239252395E+00, 8.8818413590E-01, 7.0104146189E-01, 6.9922472875E-01],
	[1.5760000000E+04, 8.3700822820E+00, 5.5236598463E+00, 8.8908022477E-01, 7.0162124065E-01, 6.9935231926E-01],
	[1.5765000000E+04, 8.3737706571E+00, 5.5233945500E+00, 8.8997693246E-01, 7.0220121914E-01, 6.9947987405E-01],
	[1.5770000000E+04, 8.3774594871E+00, 5.5231293506E+00, 8.9087425922E-01, 7.0278139721E-01, 6.9960739309E-01],
	[1.5775000000E+04, 8.3811487720E+00, 5.5228642479E+00, 8.9177220526E-01, 7.0336177473E-01, 6.9973487638E-01],
	[1.5780000000E+04, 8.3848385116E+00, 5.5225992420E+00, 8.9267077081E-01, 7.0394235153E-01, 6.9986232391E-01],
	[1.5785000000E+04, 8.3885287059E+00, 5.5223343328E+00, 8.9356995612E-01, 7.0452312747E-01, 6.9998973567E-01],
	[1.5790000000E+04, 8.3922226891E+00, 5.5220709231E+00, 8.9446976140E-01, 7.0510414882E-01, 7.0011711165E-01],
	[1.5795000000E+04, 8.3959273369E+00, 5.5218119027E+00, 8.9537018688E-01, 7.0568551136E-01, 7.0024445184E-01],
	[1.5800000000E+04, 8.3996324468E+00, 5.5215529763E+00, 8.9627123281E-01, 7.0626707308E-01, 7.0037175623E-01],
	[1.5805000000E+04, 8.4033380187E+00, 5.5212941440E+00, 8.9717289940E-01, 7.0684883383E-01, 7.0049902481E-01],
	[1.5810000000E+04, 8.4070440525E+00, 5.5210354058E+00, 8.9807518689E-01, 7.0743079346E-01, 7.0062625757E-01],
	[1.5815000000E+04, 8.4107505480E+00, 5.5207767614E+00, 8.9897809552E-01, 7.0801295182E-01, 7.0075345451E-01],
	[1.5820000000E+04, 8.4144575052E+00, 5.5205182109E+00, 8.9988162550E-01, 7.0859530877E-01, 7.0088061560E-01],
	[1.5825000000E+04, 8.4181649241E+00, 5.5202597543E+00, 9.0078577707E-01, 7.0917786414E-01, 7.0100774084E-01],
	[1.5830000000E+04, 8.4218728045E+00, 5.5200013913E+00, 9.0169055046E-01, 7.0976061780E-01, 7.0113483022E-01],
	[1.5835000000E+04, 8.4255811463E+00, 5.5197431221E+00, 9.0259594590E-01, 7.1034356959E-01, 7.0126188374E-01],
	[1.5840000000E+04, 8.4292899494E+00, 5.5194849465E+00, 9.0350196362E-01, 7.1092671936E-01, 7.0138890138E-01],
	[1.5845000000E+04, 8.4329992139E+00, 5.5192268644E+00, 9.0440860385E-01, 7.1151006697E-01, 7.0151588313E-01],
	[1.5850000000E+04, 8.4367089394E+00, 5.5189688758E+00, 9.0531586683E-01, 7.1209361226E-01, 7.0164282898E-01],
	[1.5855000000E+04, 8.4404191261E+00, 5.5187109806E+00, 9.0622375278E-01, 7.1267735508E-01, 7.0176973893E-01],
	[1.5860000000E+04, 8.4441297738E+00, 5.5184531788E+00, 9.0713226193E-01, 7.1326129528E-01, 7.0189661296E-01],
	[1.5865000000E+04, 8.4478408823E+00, 5.5181954703E+00, 9.0804139452E-01, 7.1384543272E-01, 7.0202345107E-01],
	[1.5870000000E+04, 8.4515524517E+00, 5.5179378550E+00, 9.0895115076E-01, 7.1442976724E-01, 7.0215025325E-01],
	[1.5875000000E+04, 8.4552644818E+00, 5.5176803329E+00, 9.0986153091E-01, 7.1501429868E-01, 7.0227701948E-01],
	[1.5880000000E+04, 8.4589769726E+00, 5.5174229040E+00, 9.1077253518E-01, 7.1559902691E-01, 7.0240374975E-01],
	[1.5885000000E+04, 8.4626899239E+00, 5.5171655680E+00, 9.1168416380E-01, 7.1618395177E-01, 7.0253044407E-01],
	[1.5890000000E+04, 8.4664033357E+00, 5.5169083250E+00, 9.1259641702E-01, 7.1676907311E-01, 7.0265710241E-01],
	[1.5895000000E+04, 8.4701172078E+00, 5.5166511750E+00, 9.1350929504E-01, 7.1735439078E-01, 7.0278372477E-01],
	[1.5900000000E+04, 8.4738315403E+00, 5.5163941178E+00, 9.1442279812E-01, 7.1793990462E-01, 7.0291031114E-01],
	[1.5905000000E+04, 8.4775463329E+00, 5.5161371534E+00, 9.1533692647E-01, 7.1852561449E-01, 7.0303686152E-01],
	[1.5910000000E+04, 8.4812615857E+00, 5.5158802818E+00, 9.1625168034E-01, 7.1911152023E-01, 7.0316337588E-01],
	[1.5915000000E+04, 8.4849772985E+00, 5.5156235028E+00, 9.1716705994E-01, 7.1969762169E-01, 7.0328985423E-01],
	[1.5920000000E+04, 8.4886934712E+00, 5.5153668164E+00, 9.1808306551E-01, 7.2028391873E-01, 7.0341629655E-01],
	[1.5925000000E+04, 8.4924101038E+00, 5.5151102226E+00, 9.1899969729E-01, 7.2087041118E-01, 7.0354270284E-01],
	[1.5930000000E+04, 8.4961271961E+00, 5.5148537213E+00, 9.1991695549E-01, 7.2145709890E-01, 7.0366907308E-01],
	[1.5935000000E+04, 8.4998447482E+00, 5.5145973123E+00, 9.2083484036E-01, 7.2204398174E-01, 7.0379540727E-01],
	[1.5940000000E+04, 8.5035627598E+00, 5.5143409958E+00, 9.2175335212E-01, 7.2263105954E-01, 7.0392170540E-01],
	[1.5945000000E+04, 8.5072812309E+00, 5.5140847715E+00, 9.2267249100E-01, 7.2321833216E-01, 7.0404796746E-01],
	[1.5950000000E+04, 8.5110001614E+00, 5.5138286394E+00, 9.2359225724E-01, 7.2380579943E-01, 7.0417419344E-01],
	[1.5955000000E+04, 8.5147195513E+00, 5.5135725996E+00, 9.2451265106E-01, 7.2439346121E-01, 7.0430038333E-01],
	[1.5960000000E+04, 8.5184394004E+00, 5.5133166518E+00, 9.2543367270E-01, 7.2498131734E-01, 7.0442653712E-01],
	[1.5965000000E+04, 8.5221597086E+00, 5.5130607961E+00, 9.2635532239E-01, 7.2556936768E-01, 7.0455265481E-01],
	[1.5970000000E+04, 8.5258804760E+00, 5.5128050324E+00, 9.2727760035E-01, 7.2615761207E-01, 7.0467873637E-01],
	[1.5975000000E+04, 8.5296017023E+00, 5.5125493606E+00, 9.2820050682E-01, 7.2674605035E-01, 7.0480478181E-01],
	[1.5980000000E+04, 8.5333233874E+00, 5.5122937806E+00, 9.2912404203E-01, 7.2733468238E-01, 7.0493079109E-01],
	[1.5985000000E+04, 8.5370455314E+00, 5.5120382925E+00, 9.3004820621E-01, 7.2792350799E-01, 7.0505676422E-01],
	[1.5990000000E+04, 8.5407681342E+00, 5.5117828961E+00, 9.3097299959E-01, 7.2851252705E-01, 7.0518270118E-01],
	[1.5995000000E+04, 8.5444911955E+00, 5.5115275914E+00, 9.3189842240E-01, 7.2910173939E-01, 7.0530860196E-01],
	[1.6000000000E+04, 8.5482147154E+00, 5.5112723783E+00, 9.3282447488E-01, 7.2969114486E-01, 7.0543446654E-01],
	[1.6005000000E+04, 8.5519386937E+00, 5.5110172567E+00, 9.3375115724E-01, 7.3028074331E-01, 7.0556029492E-01],
	[1.6010000000E+04, 8.5556631305E+00, 5.5107622266E+00, 9.3467846973E-01, 7.3087053459E-01, 7.0568608709E-01],
	[1.6015000000E+04, 8.5593880255E+00, 5.5105072880E+00, 9.3560641258E-01, 7.3146051853E-01, 7.0581184303E-01],
	[1.6020000000E+04, 8.5631133787E+00, 5.5102524407E+00, 9.3653498601E-01, 7.3205069500E-01, 7.0593756274E-01],
	[1.6025000000E+04, 8.5668391900E+00, 5.5099976848E+00, 9.3746419026E-01, 7.3264106382E-01, 7.0606324619E-01],
	[1.6030000000E+04, 8.5705654593E+00, 5.5097430201E+00, 9.3839402555E-01, 7.3323162486E-01, 7.0618889339E-01],
	[1.6035000000E+04, 8.5742921866E+00, 5.5094884465E+00, 9.3932449212E-01, 7.3382237796E-01, 7.0631450432E-01],
	[1.6040000000E+04, 8.5780193717E+00, 5.5092339642E+00, 9.4025559021E-01, 7.3441332295E-01, 7.0644007896E-01],
	[1.6045000000E+04, 8.5817527790E+00, 5.5089818810E+00, 9.4118732003E-01, 7.3500454306E-01, 7.0656561731E-01],
	[1.6050000000E+04, 8.5854949198E+00, 5.5087331989E+00, 9.4211968182E-01, 7.3559607475E-01, 7.0669111936E-01],
	[1.6055000000E+04, 8.5892375260E+00, 5.5084846055E+00, 9.4305267582E-01, 7.3618779838E-01, 7.0681658509E-01],
	[1.6060000000E+04, 8.5929805976E+00, 5.5082361008E+00, 9.4398630225E-01, 7.3677971381E-01, 7.0694201450E-01],
	[1.6065000000E+04, 8.5967241344E+00, 5.5079876845E+00, 9.4492056135E-01, 7.3737182088E-01, 7.0706740758E-01],
	[1.6070000000E+04, 8.6004681364E+00, 5.5077393568E+00, 9.4585545334E-01, 7.3796411943E-01, 7.0719276430E-01],
	[1.6075000000E+04, 8.6042126035E+00, 5.5074911176E+00, 9.4679097845E-01, 7.3855660932E-01, 7.0731808467E-01],
	[1.6080000000E+04, 8.6079575356E+00, 5.5072429667E+00, 9.4772713692E-01, 7.3914929039E-01, 7.0744336867E-01],
	[1.6085000000E+04, 8.6117029326E+00, 5.5069949041E+00, 9.4866392899E-01, 7.3974216248E-01, 7.0756861629E-01],
	[1.6090000000E+04, 8.6154487944E+00, 5.5067469298E+00, 9.4960135487E-01, 7.4033522544E-01, 7.0769382752E-01],
	[1.6095000000E+04, 8.6191951210E+00, 5.5064990437E+00, 9.5053941480E-01, 7.4092847912E-01, 7.0781900235E-01],
	[1.6100000000E+04, 8.6229419122E+00, 5.5062512458E+00, 9.5147810901E-01, 7.4152192335E-01, 7.0794414077E-01],
	[1.6105000000E+04, 8.6266891680E+00, 5.5060035359E+00, 9.5241743774E-01, 7.4211555799E-01, 7.0806924277E-01],
	[1.6110000000E+04, 8.6304368883E+00, 5.5057559141E+00, 9.5335740121E-01, 7.4270938288E-01, 7.0819430833E-01],
	[1.6115000000E+04, 8.6341850729E+00, 5.5055083803E+00, 9.5429799965E-01, 7.4330339787E-01, 7.0831933745E-01],
	[1.6120000000E+04, 8.6379337219E+00, 5.5052609343E+00, 9.5523923330E-01, 7.4389760280E-01, 7.0844433012E-01],
	[1.6125000000E+04, 8.6416828350E+00, 5.5050135762E+00, 9.5618110239E-01, 7.4449199751E-01, 7.0856928633E-01],
	[1.6130000000E+04, 8.6454324123E+00, 5.5047663060E+00, 9.5712360715E-01, 7.4508658185E-01, 7.0869420606E-01],
	[1.6135000000E+04, 8.6491824537E+00, 5.5045191234E+00, 9.5806674780E-01, 7.4568135566E-01, 7.0881908931E-01],
	[1.6140000000E+04, 8.6529329590E+00, 5.5042720286E+00, 9.5901052459E-01, 7.4627631880E-01, 7.0894393606E-01],
	[1.6145000000E+04, 8.6566839282E+00, 5.5040250213E+00, 9.5995493774E-01, 7.4687147109E-01, 7.0906874631E-01],
	[1.6150000000E+04, 8.6604353611E+00, 5.5037781017E+00, 9.6089998748E-01, 7.4746681240E-01, 7.0919352005E-01],
	[1.6155000000E+04, 8.6641872578E+00, 5.5035312695E+00, 9.6184567405E-01, 7.4806234255E-01, 7.0931825726E-01],
	[1.6160000000E+04, 8.6679396181E+00, 5.5032845248E+00, 9.6279199767E-01, 7.4865806140E-01, 7.0944295793E-01],
	[1.6165000000E+04, 8.6716924419E+00, 5.5030378674E+00, 9.6373895858E-01, 7.4925396879E-01, 7.0956762206E-01],
	[1.6170000000E+04, 8.6754457291E+00, 5.5027912974E+00, 9.6468655700E-01, 7.4985006456E-01, 7.0969224964E-01],
	[1.6175000000E+04, 8.6791994797E+00, 5.5025448147E+00, 9.6563479318E-01, 7.5044634856E-01, 7.0981684064E-01],
	[1.6180000000E+04, 8.6829536936E+00, 5.5022984192E+00, 9.6658366734E-01, 7.5104282063E-01, 7.0994139508E-01],
	[1.6185000000E+04, 8.6867083706E+00, 5.5020521108E+00, 9.6753317970E-01, 7.5163948062E-01, 7.1006591293E-01],
	[1.6190000000E+04, 8.6904635108E+00, 5.5018058896E+00, 9.6848333052E-01, 7.5223632836E-01, 7.1019039418E-01],
	[1.6195000000E+04, 8.6942191139E+00, 5.5015597554E+00, 9.6943412000E-01, 7.5283336370E-01, 7.1031483883E-01],
	[1.6200000000E+04, 8.6979751800E+00, 5.5013137082E+00, 9.7038554839E-01, 7.5343058649E-01, 7.1043924686E-01],
	[1.6205000000E+04, 8.7017317089E+00, 5.5010677479E+00, 9.7133761592E-01, 7.5402799657E-01, 7.1056361827E-01],
	[1.6210000000E+04, 8.7054887006E+00, 5.5008218744E+00, 9.7229032282E-01, 7.5462559377E-01, 7.1068795304E-01],
	[1.6215000000E+04, 8.7092461550E+00, 5.5005760878E+00, 9.7324366932E-01, 7.5522337795E-01, 7.1081225117E-01],
	[1.6220000000E+04, 8.7130040719E+00, 5.5003303880E+00, 9.7419765565E-01, 7.5582134895E-01, 7.1093651265E-01],
	[1.6225000000E+04, 8.7167624513E+00, 5.5000847748E+00, 9.7515228204E-01, 7.5641950660E-01, 7.1106073746E-01],
	[1.6230000000E+04, 8.7205212932E+00, 5.4998392483E+00, 9.7610754872E-01, 7.5701785076E-01, 7.1118492560E-01],
	[1.6235000000E+04, 8.7242805973E+00, 5.4995938084E+00, 9.7706345593E-01, 7.5761638126E-01, 7.1130907705E-01],
	[1.6240000000E+04, 8.7280403637E+00, 5.4993484550E+00, 9.7802000390E-01, 7.5821509795E-01, 7.1143319182E-01],
	[1.6245000000E+04, 8.7318005923E+00, 5.4991031880E+00, 9.7897719286E-01, 7.5881400067E-01, 7.1155726988E-01],
	[1.6250000000E+04, 8.7355612829E+00, 5.4988580075E+00, 9.7993502303E-01, 7.5941308926E-01, 7.1168131123E-01],
	[1.6255000000E+04, 8.7393224355E+00, 5.4986129133E+00, 9.8089349466E-01, 7.6001236356E-01, 7.1180531586E-01],
	[1.6260000000E+04, 8.7430840500E+00, 5.4983679055E+00, 9.8185260797E-01, 7.6061182342E-01, 7.1192928376E-01],
	[1.6265000000E+04, 8.7468461263E+00, 5.4981229838E+00, 9.8281236319E-01, 7.6121146867E-01, 7.1205321492E-01],
	[1.6270000000E+04, 8.7506086643E+00, 5.4978781484E+00, 9.8377276056E-01, 7.6181129917E-01, 7.1217710934E-01],
	[1.6275000000E+04, 8.7543716640E+00, 5.4976333991E+00, 9.8473380031E-01, 7.6241131475E-01, 7.1230096699E-01],
	[1.6280000000E+04, 8.7581351253E+00, 5.4973887358E+00, 9.8569548266E-01, 7.6301151525E-01, 7.1242478788E-01],
	[1.6285000000E+04, 8.7618990480E+00, 5.4971441586E+00, 9.8665780786E-01, 7.6361190052E-01, 7.1254857199E-01],
	[1.6290000000E+04, 8.7656634321E+00, 5.4968996673E+00, 9.8762077612E-01, 7.6421247039E-01, 7.1267231931E-01],
	[1.6295000000E+04, 8.7694282775E+00, 5.4966552619E+00, 9.8858438769E-01, 7.6481322472E-01, 7.1279602984E-01],
	[1.6300000000E+04, 8.7731935841E+00, 5.4964109424E+00, 9.8954864280E-01, 7.6541416333E-01, 7.1291970357E-01],
	[1.6305000000E+04, 8.7769703538E+00, 5.4961709041E+00, 9.9051354167E-01, 7.6601545137E-01, 7.1304334048E-01],
	[1.6310000000E+04, 8.7807511270E+00, 5.4959322978E+00, 9.9147908454E-01, 7.6661697696E-01, 7.1316694057E-01],
	[1.6315000000E+04, 8.7845323693E+00, 5.4956937749E+00, 9.9244527164E-01, 7.6721868691E-01, 7.1329050383E-01],
	[1.6320000000E+04, 8.7883140804E+00, 5.4954553355E+00, 9.9341210320E-01, 7.6782058104E-01, 7.1341403025E-01],
	[1.6325000000E+04, 8.7920962604E+00, 5.4952169795E+00, 9.9437957945E-01, 7.6842265920E-01, 7.1353751982E-01],
	[1.6330000000E+04, 8.7958789091E+00, 5.4949787068E+00, 9.9534770063E-01, 7.6902492124E-01, 7.1366097253E-01],
	[1.6335000000E+04, 8.7996620265E+00, 5.4947405174E+00, 9.9631646696E-01, 7.6962736698E-01, 7.1378438838E-01],
	[1.6340000000E+04, 8.8034456125E+00, 5.4945024112E+00, 9.9728587868E-01, 7.7022999628E-01, 7.1390776735E-01],
	[1.6345000000E+04, 8.8072296669E+00, 5.4942643882E+00, 9.9825593602E-01, 7.7083280898E-01, 7.1403110943E-01],
	[1.6350000000E+04, 8.8110141898E+00, 5.4940264483E+00, 9.9922663921E-01, 7.7143580491E-01, 7.1415441463E-01],
	[1.6355000000E+04, 8.8147991810E+00, 5.4937885914E+00, 1.0001979885E+00, 7.7203898391E-01, 7.1427768292E-01],
	[1.6360000000E+04, 8.8185846404E+00, 5.4935508175E+00, 1.0011699841E+00, 7.7264234584E-01, 7.1440091430E-01],
	[1.6365000000E+04, 8.8223705679E+00, 5.4933131266E+00, 1.0021426262E+00, 7.7324589052E-01, 7.1452410876E-01],
	[1.6370000000E+04, 8.8261569636E+00, 5.4930755185E+00, 1.0031159151E+00, 7.7384961780E-01, 7.1464726629E-01],
	[1.6375000000E+04, 8.8299438271E+00, 5.4928379933E+00, 1.0040898510E+00, 7.7445352752E-01, 7.1477038689E-01],
	[1.6380000000E+04, 8.8337311586E+00, 5.4926005509E+00, 1.0050644342E+00, 7.7505761952E-01, 7.1489347054E-01],
	[1.6385000000E+04, 8.8375189579E+00, 5.4923631912E+00, 1.0060396648E+00, 7.7566189364E-01, 7.1501651724E-01],
	[1.6390000000E+04, 8.8413072250E+00, 5.4921259142E+00, 1.0070155432E+00, 7.7626634972E-01, 7.1513952698E-01],
	[1.6395000000E+04, 8.8450959596E+00, 5.4918887198E+00, 1.0079920695E+00, 7.7687098760E-01, 7.1526249975E-01],
	[1.6400000000E+04, 8.8488851618E+00, 5.4916516079E+00, 1.0089692439E+00, 7.7747580712E-01, 7.1538543554E-01],
	[1.6405000000E+04, 8.8526748315E+00, 5.4914145786E+00, 1.0099470668E+00, 7.7808080812E-01, 7.1550833434E-01],
	[1.6410000000E+04, 8.8564649686E+00, 5.4911776318E+00, 1.0109255382E+00, 7.7868599045E-01, 7.1563119615E-01],
	[1.6415000000E+04, 8.8602555729E+00, 5.4909407673E+00, 1.0119046586E+00, 7.7929135393E-01, 7.1575402095E-01],
	[1.6420000000E+04, 8.8640466445E+00, 5.4907039852E+00, 1.0128844280E+00, 7.7989689841E-01, 7.1587680874E-01],
	[1.6425000000E+04, 8.8678381832E+00, 5.4904672854E+00, 1.0138648468E+00, 7.8050262373E-01, 7.1599955951E-01],
	[1.6430000000E+04, 8.8716301889E+00, 5.4902306678E+00, 1.0148459151E+00, 7.8110852973E-01, 7.1612227326E-01],
	[1.6435000000E+04, 8.8754226616E+00, 5.4899941324E+00, 1.0158276332E+00, 7.8171461626E-01, 7.1624494996E-01],
	[1.6440000000E+04, 8.8792156012E+00, 5.4897576792E+00, 1.0168100014E+00, 7.8232088313E-01, 7.1636758963E-01],
	[1.6445000000E+04, 8.8830090076E+00, 5.4895213080E+00, 1.0177930198E+00, 7.8292733021E-01, 7.1649019223E-01],
	[1.6450000000E+04, 8.8868028806E+00, 5.4892850188E+00, 1.0187766886E+00, 7.8353395732E-01, 7.1661275778E-01],
	[1.6455000000E+04, 8.8905972203E+00, 5.4890488117E+00, 1.0197610082E+00, 7.8414076431E-01, 7.1673528626E-01],
	[1.6460000000E+04, 8.8943920266E+00, 5.4888126864E+00, 1.0207459788E+00, 7.8474775101E-01, 7.1685777767E-01],
	[1.6465000000E+04, 8.8981872993E+00, 5.4885766431E+00, 1.0217316005E+00, 7.8535491727E-01, 7.1698023199E-01],
	[1.6470000000E+04, 8.9019830383E+00, 5.4883406815E+00, 1.0227178737E+00, 7.8596226292E-01, 7.1710264921E-01],
	[1.6475000000E+04, 8.9057792436E+00, 5.4881048017E+00, 1.0237047985E+00, 7.8656978779E-01, 7.1722502934E-01],
	[1.6480000000E+04, 8.9095759152E+00, 5.4878690037E+00, 1.0246923752E+00, 7.8717749174E-01, 7.1734737236E-01],
	[1.6485000000E+04, 8.9133730528E+00, 5.4876332872E+00, 1.0256806039E+00, 7.8778537460E-01, 7.1746967826E-01],
	[1.6490000000E+04, 8.9171706565E+00, 5.4873976524E+00, 1.0266694851E+00, 7.8839343620E-01, 7.1759194704E-01],
	[1.6495000000E+04, 8.9209687261E+00, 5.4871620991E+00, 1.0276590188E+00, 7.8900167639E-01, 7.1771417869E-01],
	[1.6500000000E+04, 8.9247672616E+00, 5.4869266274E+00, 1.0286492053E+00, 7.8961009501E-01, 7.1783637320E-01],
	[1.6505000000E+04, 8.9285662629E+00, 5.4866912370E+00, 1.0296400448E+00, 7.9021869188E-01, 7.1795853056E-01],
	[1.6510000000E+04, 8.9323657299E+00, 5.4864559281E+00, 1.0306315377E+00, 7.9082746685E-01, 7.1808065077E-01],
	[1.6515000000E+04, 8.9361656624E+00, 5.4862207005E+00, 1.0316236840E+00, 7.9143641977E-01, 7.1820273381E-01],
	[1.6520000000E+04, 8.9399660605E+00, 5.4859855542E+00, 1.0326164841E+00, 7.9204555045E-01, 7.1832477969E-01],
	[1.6525000000E+04, 8.9437669241E+00, 5.4857504891E+00, 1.0336099381E+00, 7.9265485875E-01, 7.1844678839E-01],
	[1.6530000000E+04, 8.9475682530E+00, 5.4855155052E+00, 1.0346040463E+00, 7.9326434451E-01, 7.1856875990E-01],
	[1.6535000000E+04, 8.9513700472E+00, 5.4852806024E+00, 1.0355988090E+00, 7.9387400755E-01, 7.1869069423E-01],
	[1.6540000000E+04, 8.9551723065E+00, 5.4850457807E+00, 1.0365942263E+00, 7.9448384772E-01, 7.1881259135E-01],
	[1.6545000000E+04, 8.9589750310E+00, 5.4848110401E+00, 1.0375902985E+00, 7.9509386485E-01, 7.1893445127E-01],
	[1.6550000000E+04, 8.9627782205E+00, 5.4845763804E+00, 1.0385870259E+00, 7.9570405878E-01, 7.1905627397E-01],
	[1.6555000000E+04, 8.9665818750E+00, 5.4843418016E+00, 1.0395844086E+00, 7.9631442936E-01, 7.1917805945E-01],
	[1.6560000000E+04, 8.9703859943E+00, 5.4841073037E+00, 1.0405824469E+00, 7.9692497641E-01, 7.1929980770E-01],
	[1.6565000000E+04, 8.9741946601E+00, 5.4838743706E+00, 1.0415811410E+00, 7.9753576340E-01, 7.1942151872E-01],
	[1.6570000000E+04, 8.9780147580E+00, 5.4836455024E+00, 1.0425804912E+00, 7.9814689776E-01, 7.1954319249E-01],
	[1.6575000000E+04, 8.9818353287E+00, 5.4834167128E+00, 1.0435804976E+00, 7.9875820867E-01, 7.1966482901E-01],
	[1.6580000000E+04, 8.9856563721E+00, 5.4831880017E+00, 1.0445811606E+00, 7.9936969597E-01, 7.1978642828E-01],
	[1.6585000000E+04, 8.9894778882E+00, 5.4829593692E+00, 1.0455824804E+00, 7.9998135948E-01, 7.1990799028E-01],
	[1.6590000000E+04, 8.9932998770E+00, 5.4827308151E+00, 1.0465844571E+00, 8.0059319905E-01, 7.2002951501E-01],
	[1.6595000000E+04, 8.9971223382E+00, 5.4825023393E+00, 1.0475870910E+00, 8.0120521451E-01, 7.2015100246E-01],
	[1.6600000000E+04, 9.0009452718E+00, 5.4822739420E+00, 1.0485903824E+00, 8.0181740571E-01, 7.2027245262E-01],
	[1.6605000000E+04, 9.0047686778E+00, 5.4820456229E+00, 1.0495943315E+00, 8.0242977247E-01, 7.2039386549E-01],
	[1.6610000000E+04, 9.0085925561E+00, 5.4818173821E+00, 1.0505989385E+00, 8.0304231464E-01, 7.2051524106E-01],
	[1.6615000000E+04, 9.0124169065E+00, 5.4815892194E+00, 1.0516042036E+00, 8.0365503205E-01, 7.2063657933E-01],
	[1.6620000000E+04, 9.0162417291E+00, 5.4813611349E+00, 1.0526101271E+00, 8.0426792455E-01, 7.2075788028E-01],
	[1.6625000000E+04, 9.0200670236E+00, 5.4811331285E+00, 1.0536167093E+00, 8.0488099195E-01, 7.2087914391E-01],
	[1.6630000000E+04, 9.0238927900E+00, 5.4809052002E+00, 1.0546239503E+00, 8.0549423411E-01, 7.2100037022E-01],
	[1.6635000000E+04, 9.0277190283E+00, 5.4806773498E+00, 1.0556318503E+00, 8.0610765086E-01, 7.2112155919E-01],
	[1.6640000000E+04, 9.0315457384E+00, 5.4804495774E+00, 1.0566404097E+00, 8.0672124204E-01, 7.2124271082E-01],
	[1.6645000000E+04, 9.0353729201E+00, 5.4802218828E+00, 1.0576496286E+00, 8.0733500748E-01, 7.2136382510E-01],
	[1.6650000000E+04, 9.0392005734E+00, 5.4799942662E+00, 1.0586595072E+00, 8.0794894702E-01, 7.2148490203E-01],
	[1.6655000000E+04, 9.0430286982E+00, 5.4797667273E+00, 1.0596700459E+00, 8.0856306049E-01, 7.2160594160E-01],
	[1.6660000000E+04, 9.0468572944E+00, 5.4795392661E+00, 1.0606812448E+00, 8.0917734773E-01, 7.2172694380E-01],
	[1.6665000000E+04, 9.0506863620E+00, 5.4793118826E+00, 1.0616931042E+00, 8.0979180858E-01, 7.2184790863E-01],
	[1.6670000000E+04, 9.0545159008E+00, 5.4790845768E+00, 1.0627056243E+00, 8.1040644288E-01, 7.2196883607E-01],
	[1.6675000000E+04, 9.0583459108E+00, 5.4788573486E+00, 1.0637188053E+00, 8.1102125045E-01, 7.2208972613E-01],
	[1.6680000000E+04, 9.0621763919E+00, 5.4786301979E+00, 1.0647326475E+00, 8.1163623114E-01, 7.2221057880E-01],
	[1.6685000000E+04, 9.0660073440E+00, 5.4784031247E+00, 1.0657471511E+00, 8.1225138478E-01, 7.2233139407E-01],
	[1.6690000000E+04, 9.0698387670E+00, 5.4781761290E+00, 1.0667623163E+00, 8.1286671120E-01, 7.2245217193E-01],
	[1.6695000000E+04, 9.0736706609E+00, 5.4779492107E+00, 1.0677781434E+00, 8.1348221025E-01, 7.2257291238E-01],
	[1.6700000000E+04, 9.0775030255E+00, 5.4777223697E+00, 1.0687946326E+00, 8.1409788176E-01, 7.2269361540E-01],
	[1.6705000000E+04, 9.0813358607E+00, 5.4774956059E+00, 1.0698117841E+00, 8.1471372556E-01, 7.2281428101E-01],
	[1.6710000000E+04, 9.0851691666E+00, 5.4772689195E+00, 1.0708295982E+00, 8.1532974148E-01, 7.2293490918E-01],
	[1.6715000000E+04, 9.0890029430E+00, 5.4770423102E+00, 1.0718480751E+00, 8.1594592938E-01, 7.2305549992E-01],
	[1.6720000000E+04, 9.0928371897E+00, 5.4768157781E+00, 1.0728672150E+00, 8.1656228907E-01, 7.2317605321E-01],
	[1.6725000000E+04, 9.0966719069E+00, 5.4765893231E+00, 1.0738870182E+00, 8.1717882039E-01, 7.2329656905E-01],
	[1.6730000000E+04, 9.1005070943E+00, 5.4763629451E+00, 1.0749074848E+00, 8.1779552318E-01, 7.2341704743E-01],
	[1.6735000000E+04, 9.1043427518E+00, 5.4761366442E+00, 1.0759286152E+00, 8.1841239728E-01, 7.2353748836E-01],
	[1.6740000000E+04, 9.1081788795E+00, 5.4759104201E+00, 1.0769504096E+00, 8.1902944252E-01, 7.2365789181E-01],
	[1.6745000000E+04, 9.1120154771E+00, 5.4756842730E+00, 1.0779728681E+00, 8.1964665873E-01, 7.2377825779E-01],
	[1.6750000000E+04, 9.1158525447E+00, 5.4754582027E+00, 1.0789959911E+00, 8.2026404575E-01, 7.2389858629E-01],
	[1.6755000000E+04, 9.1196900821E+00, 5.4752322093E+00, 1.0800197787E+00, 8.2088160342E-01, 7.2401887730E-01],
	[1.6760000000E+04, 9.1235280893E+00, 5.4750062926E+00, 1.0810442312E+00, 8.2149933156E-01, 7.2413913082E-01],
	[1.6765000000E+04, 9.1273665662E+00, 5.4747804526E+00, 1.0820693488E+00, 8.2211723001E-01, 7.2425934684E-01],
	[1.6770000000E+04, 9.1312055127E+00, 5.4745546892E+00, 1.0830951318E+00, 8.2273529861E-01, 7.2437952536E-01],
	[1.6775000000E+04, 9.1350449286E+00, 5.4743290025E+00, 1.0841215803E+00, 8.2335353720E-01, 7.2449966637E-01],
	[1.6780000000E+04, 9.1388848140E+00, 5.4741033923E+00, 1.0851486947E+00, 8.2397194559E-01, 7.2461976986E-01],
	[1.6785000000E+04, 9.1427251688E+00, 5.4738778586E+00, 1.0861764751E+00, 8.2459052364E-01, 7.2473983583E-01],
	[1.6790000000E+04, 9.1465659928E+00, 5.4736524014E+00, 1.0872049219E+00, 8.2520927117E-01, 7.2485986428E-01],
	[1.6795000000E+04, 9.1504072860E+00, 5.4734270206E+00, 1.0882340351E+00, 8.2582818802E-01, 7.2497985519E-01],
	[1.6800000000E+04, 9.1542490483E+00, 5.4732017162E+00, 1.0892638151E+00, 8.2644727403E-01, 7.2509980856E-01],
	[1.6805000000E+04, 9.1580912796E+00, 5.4729764881E+00, 1.0902942621E+00, 8.2706652901E-01, 7.2521972438E-01],
	[1.6810000000E+04, 9.1619339798E+00, 5.4727513362E+00, 1.0913253762E+00, 8.2768595282E-01, 7.2533960266E-01],
	[1.6815000000E+04, 9.1657771489E+00, 5.4725262606E+00, 1.0923571579E+00, 8.2830554528E-01, 7.2545944338E-01],
	[1.6820000000E+04, 9.1696207868E+00, 5.4723012611E+00, 1.0933896072E+00, 8.2892530623E-01, 7.2557924654E-01],
	[1.6825000000E+04, 9.1734648933E+00, 5.4720763378E+00, 1.0944227244E+00, 8.2954523550E-01, 7.2569901213E-01],
	[1.6830000000E+04, 9.1773094685E+00, 5.4718514905E+00, 1.0954565098E+00, 8.3016533292E-01, 7.2581874015E-01],
	[1.6835000000E+04, 9.1811691550E+00, 5.4716317957E+00, 1.0964909636E+00, 8.3078583526E-01, 7.2593843059E-01],
	[1.6840000000E+04, 9.1850302377E+00, 5.4714124938E+00, 1.0975260859E+00, 8.3140652086E-01, 7.2605808344E-01],
	[1.6845000000E+04, 9.1888917973E+00, 5.4711932657E+00, 1.0985618771E+00, 8.3202737471E-01, 7.2617769869E-01],
	[1.6850000000E+04, 9.1927538335E+00, 5.4709741115E+00, 1.0995983374E+00, 8.3264839662E-01, 7.2629727633E-01],
	[1.6855000000E+04, 9.1966163464E+00, 5.4707550311E+00, 1.1006354670E+00, 8.3326958643E-01, 7.2641681636E-01],
	[1.6860000000E+04, 9.2004793359E+00, 5.4705360244E+00, 1.1016732662E+00, 8.3389094398E-01, 7.2653631876E-01],
	[1.6865000000E+04, 9.2043428018E+00, 5.4703170914E+00, 1.1027117351E+00, 8.3451246910E-01, 7.2665578354E-01],
	[1.6870000000E+04, 9.2082067441E+00, 5.4700982321E+00, 1.1037508740E+00, 8.3513416162E-01, 7.2677521068E-01],
	[1.6875000000E+04, 9.2120711627E+00, 5.4698794464E+00, 1.1047906832E+00, 8.3575602138E-01, 7.2689460018E-01],
	[1.6880000000E+04, 9.2159360576E+00, 5.4696607343E+00, 1.1058311629E+00, 8.3637804822E-01, 7.2701395202E-01],
	[1.6885000000E+04, 9.2198014285E+00, 5.4694420957E+00, 1.1068723132E+00, 8.3700024195E-01, 7.2713326621E-01],
	[1.6890000000E+04, 9.2236672756E+00, 5.4692235305E+00, 1.1079141345E+00, 8.3762260243E-01, 7.2725254273E-01],
	[1.6895000000E+04, 9.2275335986E+00, 5.4690050388E+00, 1.1089566270E+00, 8.3824512947E-01, 7.2737178158E-01],
	[1.6900000000E+04, 9.2314003974E+00, 5.4687866204E+00, 1.1099997909E+00, 8.3886782292E-01, 7.2749098274E-01],
	[1.6905000000E+04, 9.2352676721E+00, 5.4685682754E+00, 1.1110436264E+00, 8.3949068260E-01, 7.2761014622E-01],
	[1.6910000000E+04, 9.2391354226E+00, 5.4683500037E+00, 1.1120881338E+00, 8.4011370835E-01, 7.2772927199E-01],
	[1.6915000000E+04, 9.2430036486E+00, 5.4681318052E+00, 1.1131333133E+00, 8.4073690001E-01, 7.2784836007E-01],
	[1.6920000000E+04, 9.2468723503E+00, 5.4679136799E+00, 1.1141791651E+00, 8.4136025740E-01, 7.2796741044E-01],
	[1.6925000000E+04, 9.2507415274E+00, 5.4676956277E+00, 1.1152256895E+00, 8.4198378036E-01, 7.2808642309E-01],
	[1.6930000000E+04, 9.2546111799E+00, 5.4674776487E+00, 1.1162728868E+00, 8.4260746871E-01, 7.2820539801E-01],
	[1.6935000000E+04, 9.2584813077E+00, 5.4672597426E+00, 1.1173207570E+00, 8.4323132230E-01, 7.2832433521E-01],
	[1.6940000000E+04, 9.2623519108E+00, 5.4670419096E+00, 1.1183693005E+00, 8.4385534096E-01, 7.2844323466E-01],
	[1.6945000000E+04, 9.2662229890E+00, 5.4668241496E+00, 1.1194185176E+00, 8.4447952451E-01, 7.2856209637E-01],
	[1.6950000000E+04, 9.2700945423E+00, 5.4666064625E+00, 1.1204684083E+00, 8.4510387279E-01, 7.2868092033E-01],
	[1.6955000000E+04, 9.2739665706E+00, 5.4663888482E+00, 1.1215189731E+00, 8.4572838564E-01, 7.2879970653E-01],
	[1.6960000000E+04, 9.2778390738E+00, 5.4661713068E+00, 1.1225702120E+00, 8.4635306288E-01, 7.2891845496E-01],
	[1.6965000000E+04, 9.2817120518E+00, 5.4659538381E+00, 1.1236221254E+00, 8.4697790435E-01, 7.2903716562E-01],
	[1.6970000000E+04, 9.2855855045E+00, 5.4657364422E+00, 1.1246747135E+00, 8.4760290987E-01, 7.2915583849E-01],
	[1.6975000000E+04, 9.2894594319E+00, 5.4655191190E+00, 1.1257279764E+00, 8.4822807929E-01, 7.2927447358E-01],
	[1.6980000000E+04, 9.2933338339E+00, 5.4653018684E+00, 1.1267819145E+00, 8.4885341242E-01, 7.2939307088E-01],
	[1.6985000000E+04, 9.2972087104E+00, 5.4650846904E+00, 1.1278365280E+00, 8.4947890912E-01, 7.2951163038E-01],
	[1.6990000000E+04, 9.3010840613E+00, 5.4648675849E+00, 1.1288918170E+00, 8.5010456920E-01, 7.2963015207E-01],
	[1.6995000000E+04, 9.3049598866E+00, 5.4646505520E+00, 1.1299477819E+00, 8.5073039249E-01, 7.2974863595E-01],
	[1.7000000000E+04, 9.3088361861E+00, 5.4644335915E+00, 1.1310044229E+00, 8.5135637884E-01, 7.2986708200E-01],
	[1.7005000000E+04, 9.3127129598E+00, 5.4642167034E+00, 1.1320617401E+00, 8.5198252807E-01, 7.2998549023E-01],
	[1.7010000000E+04, 9.3165902075E+00, 5.4639998877E+00, 1.1331197339E+00, 8.5260884000E-01, 7.3010386063E-01],
	[1.7015000000E+04, 9.3204679293E+00, 5.4637831443E+00, 1.1341784045E+00, 8.5323531449E-01, 7.3022219318E-01],
	[1.7020000000E+04, 9.3243461250E+00, 5.4635664732E+00, 1.1352377521E+00, 8.5386195135E-01, 7.3034048789E-01],
	[1.7025000000E+04, 9.3282247946E+00, 5.4633498743E+00, 1.1362977769E+00, 8.5448875041E-01, 7.3045874475E-01],
	[1.7030000000E+04, 9.3321039379E+00, 5.4631333476E+00, 1.1373584792E+00, 8.5511571152E-01, 7.3057696375E-01],
	[1.7035000000E+04, 9.3359835549E+00, 5.4629168931E+00, 1.1384198591E+00, 8.5574283449E-01, 7.3069514488E-01],
	[1.7040000000E+04, 9.3398636455E+00, 5.4627005106E+00, 1.1394819171E+00, 8.5637011916E-01, 7.3081328814E-01],
	[1.7045000000E+04, 9.3437442096E+00, 5.4624842002E+00, 1.1405446531E+00, 8.5699756536E-01, 7.3093139352E-01],
	[1.7050000000E+04, 9.3476252472E+00, 5.4622679618E+00, 1.1416080676E+00, 8.5762517293E-01, 7.3104946102E-01],
	[1.7055000000E+04, 9.3515067581E+00, 5.4620517953E+00, 1.1426721607E+00, 8.5825294169E-01, 7.3116749063E-01],
	[1.7060000000E+04, 9.3553887423E+00, 5.4618357008E+00, 1.1437369327E+00, 8.5888087147E-01, 7.3128548234E-01],
	[1.7065000000E+04, 9.3592711997E+00, 5.4616196782E+00, 1.1448023838E+00, 8.5950896211E-01, 7.3140343614E-01],
	[1.7070000000E+04, 9.3631541302E+00, 5.4614037273E+00, 1.1458685142E+00, 8.6013721343E-01, 7.3152135204E-01],
	[1.7075000000E+04, 9.3670375338E+00, 5.4611878483E+00, 1.1469353242E+00, 8.6076562527E-01, 7.3163923002E-01],
	[1.7080000000E+04, 9.3709214103E+00, 5.4609720409E+00, 1.1480028140E+00, 8.6139419745E-01, 7.3175707009E-01],
	[1.7085000000E+04, 9.3748057596E+00, 5.4607563053E+00, 1.1490709838E+00, 8.6202292982E-01, 7.3187487222E-01],
	[1.7090000000E+04, 9.3786905818E+00, 5.4605406413E+00, 1.1501398339E+00, 8.6265182218E-01, 7.3199263642E-01],
	[1.7095000000E+04, 9.3825758767E+00, 5.4603250490E+00, 1.1512093645E+00, 8.6328087439E-01, 7.3211036268E-01],
	[1.7100000000E+04, 9.3864616442E+00, 5.4601095281E+00, 1.1522795758E+00, 8.6391008626E-01, 7.3222805099E-01],
	[1.7105000000E+04, 9.3903599792E+00, 5.4598980815E+00, 1.1533504681E+00, 8.6453966052E-01, 7.3234570136E-01],
	[1.7110000000E+04, 9.3942627844E+00, 5.4596880251E+00, 1.1544220416E+00, 8.6516946155E-01, 7.3246331377E-01],
	[1.7115000000E+04, 9.3981660706E+00, 5.4594780382E+00, 1.1554942965E+00, 8.6579942236E-01, 7.3258088821E-01],
	[1.7120000000E+04, 9.4020698377E+00, 5.4592681206E+00, 1.1565672331E+00, 8.6642954275E-01, 7.3269842468E-01],
	[1.7125000000E+04, 9.4059740857E+00, 5.4590582725E+00, 1.1576408516E+00, 8.6705982257E-01, 7.3281592319E-01],
	[1.7130000000E+04, 9.4098788145E+00, 5.4588484936E+00, 1.1587151523E+00, 8.6769026165E-01, 7.3293338371E-01],
	[1.7135000000E+04, 9.4137840240E+00, 5.4586387841E+00, 1.1597901353E+00, 8.6832085981E-01, 7.3305080624E-01],
	[1.7140000000E+04, 9.4176897141E+00, 5.4584291437E+00, 1.1608658009E+00, 8.6895161689E-01, 7.3316819079E-01],
	[1.7145000000E+04, 9.4215958848E+00, 5.4582195726E+00, 1.1619421493E+00, 8.6958253271E-01, 7.3328553733E-01],
	[1.7150000000E+04, 9.4255025359E+00, 5.4580100706E+00, 1.1630191809E+00, 8.7021360711E-01, 7.3340284588E-01],
	[1.7155000000E+04, 9.4294096674E+00, 5.4578006378E+00, 1.1640968957E+00, 8.7084483992E-01, 7.3352011641E-01],
	[1.7160000000E+04, 9.4333172792E+00, 5.4575912740E+00, 1.1651752940E+00, 8.7147623096E-01, 7.3363734893E-01],
	[1.7165000000E+04, 9.4372253712E+00, 5.4573819792E+00, 1.1662543762E+00, 8.7210778007E-01, 7.3375454344E-01],
	[1.7170000000E+04, 9.4411339433E+00, 5.4571727534E+00, 1.1673341423E+00, 8.7273948708E-01, 7.3387169991E-01],
	[1.7175000000E+04, 9.4450429955E+00, 5.4569635965E+00, 1.1684145927E+00, 8.7337135181E-01, 7.3398881836E-01],
	[1.7180000000E+04, 9.4489525277E+00, 5.4567545085E+00, 1.1694957275E+00, 8.7400337410E-01, 7.3410589878E-01],
	[1.7185000000E+04, 9.4528625398E+00, 5.4565454894E+00, 1.1705775470E+00, 8.7463555377E-01, 7.3422294115E-01],
	[1.7190000000E+04, 9.4567730316E+00, 5.4563365391E+00, 1.1716600515E+00, 8.7526789066E-01, 7.3433994547E-01],
	[1.7195000000E+04, 9.4606840033E+00, 5.4561276576E+00, 1.1727432412E+00, 8.7590038460E-01, 7.3445691175E-01],
	[1.7200000000E+04, 9.4645954545E+00, 5.4559188447E+00, 1.1738271162E+00, 8.7653303541E-01, 7.3457383996E-01],
	[1.7205000000E+04, 9.4685073854E+00, 5.4557101006E+00, 1.1749116769E+00, 8.7716584292E-01, 7.3469073012E-01],
	[1.7210000000E+04, 9.4724197957E+00, 5.4555014251E+00, 1.1759969235E+00, 8.7779880697E-01, 7.3480758221E-01],
	[1.7215000000E+04, 9.4763326855E+00, 5.4552928182E+00, 1.1770828562E+00, 8.7843192739E-01, 7.3492439623E-01],
	[1.7220000000E+04, 9.4802460545E+00, 5.4550842798E+00, 1.1781694752E+00, 8.7906520399E-01, 7.3504117216E-01],
	[1.7225000000E+04, 9.4841599028E+00, 5.4548758100E+00, 1.1792567808E+00, 8.7969863662E-01, 7.3515791002E-01],
	[1.7230000000E+04, 9.4880742303E+00, 5.4546674086E+00, 1.1803447732E+00, 8.8033222510E-01, 7.3527460979E-01],
	[1.7235000000E+04, 9.4919890369E+00, 5.4544590756E+00, 1.1814334527E+00, 8.8096596926E-01, 7.3539127147E-01],
	[1.7240000000E+04, 9.4959043225E+00, 5.4542508111E+00, 1.1825228194E+00, 8.8159986893E-01, 7.3550789505E-01],
	[1.7245000000E+04, 9.4998200870E+00, 5.4540426148E+00, 1.1836128736E+00, 8.8223392393E-01, 7.3562448052E-01],
	[1.7250000000E+04, 9.5037363304E+00, 5.4538344869E+00, 1.1847036156E+00, 8.8286813411E-01, 7.3574102789E-01],
	[1.7255000000E+04, 9.5076530525E+00, 5.4536264272E+00, 1.1857950455E+00, 8.8350249928E-01, 7.3585753715E-01],
	[1.7260000000E+04, 9.5115702533E+00, 5.4534184358E+00, 1.1868871637E+00, 8.8413701927E-01, 7.3597400829E-01],
	[1.7265000000E+04, 9.5154879328E+00, 5.4532105125E+00, 1.1879799703E+00, 8.8477169392E-01, 7.3609044131E-01],
	[1.7270000000E+04, 9.5194060907E+00, 5.4530026574E+00, 1.1890734655E+00, 8.8540652306E-01, 7.3620683620E-01],
	[1.7275000000E+04, 9.5233247271E+00, 5.4527948703E+00, 1.1901676497E+00, 8.8604150650E-01, 7.3632319296E-01],
	[1.7280000000E+04, 9.5272438419E+00, 5.4525871513E+00, 1.1912625231E+00, 8.8667664408E-01, 7.3643951159E-01],
	[1.7285000000E+04, 9.5311634349E+00, 5.4523795003E+00, 1.1923580858E+00, 8.8731193564E-01, 7.3655579207E-01],
	[1.7290000000E+04, 9.5350835062E+00, 5.4521719172E+00, 1.1934543381E+00, 8.8794738098E-01, 7.3667203441E-01],
	[1.7295000000E+04, 9.5390040556E+00, 5.4519644021E+00, 1.1945512803E+00, 8.8858297996E-01, 7.3678823860E-01],
	[1.7300000000E+04, 9.5429250830E+00, 5.4517569548E+00, 1.1956489125E+00, 8.8921873239E-01, 7.3690440463E-01],
	[1.7305000000E+04, 9.5468465884E+00, 5.4515495754E+00, 1.1967472351E+00, 8.8985463810E-01, 7.3702053250E-01],
	[1.7310000000E+04, 9.5507685717E+00, 5.4513422638E+00, 1.1978462482E+00, 8.9049069692E-01, 7.3713662221E-01],
	[1.7315000000E+04, 9.5546910328E+00, 5.4511350199E+00, 1.1989459521E+00, 8.9112690868E-01, 7.3725267376E-01],
	[1.7320000000E+04, 9.5586139716E+00, 5.4509278438E+00, 1.2000463471E+00, 8.9176327321E-01, 7.3736868713E-01],
	[1.7325000000E+04, 9.5625373881E+00, 5.4507207353E+00, 1.2011474332E+00, 8.9239979033E-01, 7.3748466232E-01],
	[1.7330000000E+04, 9.5664612821E+00, 5.4505136944E+00, 1.2022492109E+00, 8.9303645987E-01, 7.3760059933E-01],
	[1.7335000000E+04, 9.5703856536E+00, 5.4503067212E+00, 1.2033516802E+00, 8.9367328167E-01, 7.3771649816E-01],
	[1.7340000000E+04, 9.5743105025E+00, 5.4500998155E+00, 1.2044548416E+00, 8.9431025554E-01, 7.3783235879E-01],
	[1.7345000000E+04, 9.5782358288E+00, 5.4498929772E+00, 1.2055586951E+00, 8.9494738132E-01, 7.3794818123E-01],
	[1.7350000000E+04, 9.5821616323E+00, 5.4496862065E+00, 1.2066632410E+00, 8.9558465884E-01, 7.3806396547E-01],
	[1.7355000000E+04, 9.5860879130E+00, 5.4494795032E+00, 1.2077684796E+00, 8.9622208792E-01, 7.3817971151E-01],
	[1.7360000000E+04, 9.5900146707E+00, 5.4492728672E+00, 1.2088744111E+00, 8.9685966838E-01, 7.3829541934E-01],
	[1.7365000000E+04, 9.5939419055E+00, 5.4490662986E+00, 1.2099810356E+00, 8.9749740007E-01, 7.3841108896E-01],
	[1.7370000000E+04, 9.5978696172E+00, 5.4488597973E+00, 1.2110883536E+00, 8.9813528280E-01, 7.3852672037E-01],
	[1.7375000000E+04, 9.6017978058E+00, 5.4486533632E+00, 1.2121963651E+00, 8.9877331640E-01, 7.3864231355E-01],
	[1.7380000000E+04, 9.6057379433E+00, 5.4484506235E+00, 1.2133050705E+00, 8.9941170012E-01, 7.3875786852E-01],
	[1.7385000000E+04, 9.6096837046E+00, 5.4482495745E+00, 1.2144144699E+00, 9.0005032425E-01, 7.3887338525E-01],
	[1.7390000000E+04, 9.6136299514E+00, 5.4480485907E+00, 1.2155245636E+00, 9.0068909936E-01, 7.3898886375E-01],
	[1.7395000000E+04, 9.6175766835E+00, 5.4478476720E+00, 1.2166353519E+00, 9.0132802527E-01, 7.3910430402E-01],
	[1.7400000000E+04, 9.6215239010E+00, 5.4476468186E+00, 1.2177468349E+00, 9.0196710183E-01, 7.3921970604E-01],
	[1.7405000000E+04, 9.6254716036E+00, 5.4474460302E+00, 1.2188590129E+00, 9.0260632886E-01, 7.3933506983E-01],
	[1.7410000000E+04, 9.6294197914E+00, 5.4472453069E+00, 1.2199718861E+00, 9.0324570618E-01, 7.3945039536E-01],
	[1.7415000000E+04, 9.6333684643E+00, 5.4470446486E+00, 1.2210854548E+00, 9.0388523362E-01, 7.3956568265E-01],
	[1.7420000000E+04, 9.6373176221E+00, 5.4468440553E+00, 1.2221997192E+00, 9.0452491101E-01, 7.3968093168E-01],
	[1.7425000000E+04, 9.6412672648E+00, 5.4466435270E+00, 1.2233146795E+00, 9.0516473818E-01, 7.3979614245E-01],
	[1.7430000000E+04, 9.6452173923E+00, 5.4464430636E+00, 1.2244303360E+00, 9.0580471496E-01, 7.3991131496E-01],
	[1.7435000000E+04, 9.6491680046E+00, 5.4462426651E+00, 1.2255466889E+00, 9.0644484116E-01, 7.4002644920E-01],
	[1.7440000000E+04, 9.6531191015E+00, 5.4460423313E+00, 1.2266637384E+00, 9.0708511663E-01, 7.4014154517E-01],
	[1.7445000000E+04, 9.6570706830E+00, 5.4458420624E+00, 1.2277814847E+00, 9.0772554118E-01, 7.4025660287E-01],
	[1.7450000000E+04, 9.6610227489E+00, 5.4456418583E+00, 1.2288999282E+00, 9.0836611465E-01, 7.4037162229E-01],
	[1.7455000000E+04, 9.6649752993E+00, 5.4454417188E+00, 1.2300190691E+00, 9.0900683686E-01, 7.4048660343E-01],
	[1.7460000000E+04, 9.6689283341E+00, 5.4452416440E+00, 1.2311389074E+00, 9.0964770764E-01, 7.4060154629E-01],
	[1.7465000000E+04, 9.6728818531E+00, 5.4450416339E+00, 1.2322594436E+00, 9.1028872682E-01, 7.4071645085E-01],
	[1.7470000000E+04, 9.6768358562E+00, 5.4448416883E+00, 1.2333806779E+00, 9.1092989421E-01, 7.4083131713E-01],
	[1.7475000000E+04, 9.6807903435E+00, 5.4446418073E+00, 1.2345026104E+00, 9.1157120966E-01, 7.4094614511E-01],
	[1.7480000000E+04, 9.6847453148E+00, 5.4444419909E+00, 1.2356252414E+00, 9.1221267298E-01, 7.4106093479E-01],
	[1.7485000000E+04, 9.6887007700E+00, 5.4442422389E+00, 1.2367485712E+00, 9.1285428401E-01, 7.4117568617E-01],
	[1.7490000000E+04, 9.6926567091E+00, 5.4440425513E+00, 1.2378725999E+00, 9.1349604257E-01, 7.4129039925E-01],
	[1.7495000000E+04, 9.6966131320E+00, 5.4438429282E+00, 1.2389973278E+00, 9.1413794849E-01, 7.4140507402E-01],
	[1.7500000000E+04, 9.7005700385E+00, 5.4436433694E+00, 1.2401227552E+00, 9.1478000159E-01, 7.4151971047E-01],
	[1.7505000000E+04, 9.7045274287E+00, 5.4434438749E+00, 1.2412579119E+00, 9.1542711294E-01, 7.4163430861E-01],
	[1.7510000000E+04, 9.7084853025E+00, 5.4432444447E+00, 1.2423937823E+00, 9.1607437463E-01, 7.4174886843E-01],
	[1.7515000000E+04, 9.7124436597E+00, 5.4430450787E+00, 1.2435303668E+00, 9.1672178648E-01, 7.4186338993E-01],
	[1.7520000000E+04, 9.7164025003E+00, 5.4428457770E+00, 1.2446676657E+00, 9.1736934830E-01, 7.4197787311E-01],
	[1.7525000000E+04, 9.7203618242E+00, 5.4426465394E+00, 1.2458056790E+00, 9.1801705992E-01, 7.4209231796E-01],
	[1.7530000000E+04, 9.7243216313E+00, 5.4424473659E+00, 1.2469444072E+00, 9.1866492117E-01, 7.4220672447E-01],
	[1.7535000000E+04, 9.7282819216E+00, 5.4422482566E+00, 1.2480838504E+00, 9.1931293186E-01, 7.4232109265E-01],
	[1.7540000000E+04, 9.7322426949E+00, 5.4420492112E+00, 1.2492240089E+00, 9.1996109182E-01, 7.4243542250E-01],
	[1.7545000000E+04, 9.7362039513E+00, 5.4418502299E+00, 1.2503648829E+00, 9.2060940087E-01, 7.4254971400E-01],
	[1.7550000000E+04, 9.7401656905E+00, 5.4416513126E+00, 1.2515064727E+00, 9.2125785884E-01, 7.4266396716E-01],
	[1.7555000000E+04, 9.7441279126E+00, 5.4414524592E+00, 1.2526487785E+00, 9.2190646555E-01, 7.4277818198E-01],
	[1.7560000000E+04, 9.7480906175E+00, 5.4412536696E+00, 1.2537918005E+00, 9.2255522081E-01, 7.4289235845E-01],
	[1.7565000000E+04, 9.7520538050E+00, 5.4410549440E+00, 1.2549355391E+00, 9.2320412445E-01, 7.4300649656E-01],
	[1.7570000000E+04, 9.7560174751E+00, 5.4408562821E+00, 1.2560799944E+00, 9.2385317630E-01, 7.4312059632E-01],
	[1.7575000000E+04, 9.7599816278E+00, 5.4406576840E+00, 1.2572251667E+00, 9.2450237618E-01, 7.4323465772E-01],
	[1.7580000000E+04, 9.7639462629E+00, 5.4404591497E+00, 1.2583710562E+00, 9.2515172390E-01, 7.4334868076E-01],
	[1.7585000000E+04, 9.7679113803E+00, 5.4402606791E+00, 1.2595176633E+00, 9.2580121929E-01, 7.4346266543E-01],
	[1.7590000000E+04, 9.7718769800E+00, 5.4400622721E+00, 1.2606649880E+00, 9.2645086218E-01, 7.4357661174E-01],
	[1.7595000000E+04, 9.7758430620E+00, 5.4398639287E+00, 1.2618130307E+00, 9.2710065238E-01, 7.4369051968E-01],
	[1.7600000000E+04, 9.7798096260E+00, 5.4396656490E+00, 1.2629617916E+00, 9.2775058972E-01, 7.4380438925E-01],
	[1.7605000000E+04, 9.7837766722E+00, 5.4394674328E+00, 1.2641112710E+00, 9.2840067402E-01, 7.4391822045E-01],
	[1.7610000000E+04, 9.7877442002E+00, 5.4392692800E+00, 1.2652614691E+00, 9.2905090510E-01, 7.4403201327E-01],
	[1.7615000000E+04, 9.7917122102E+00, 5.4390711908E+00, 1.2664123861E+00, 9.2970128278E-01, 7.4414576770E-01],
	[1.7620000000E+04, 9.7956807020E+00, 5.4388731650E+00, 1.2675640224E+00, 9.3035180688E-01, 7.4425948376E-01],
	[1.7625000000E+04, 9.7996496755E+00, 5.4386752025E+00, 1.2687163780E+00, 9.3100247724E-01, 7.4437316143E-01],
	[1.7630000000E+04, 9.8036191307E+00, 5.4384773035E+00, 1.2698694534E+00, 9.3165329366E-01, 7.4448680072E-01],
	[1.7635000000E+04, 9.8075890675E+00, 5.4382794677E+00, 1.2710232486E+00, 9.3230425597E-01, 7.4460040161E-01],
	[1.7640000000E+04, 9.8115594858E+00, 5.4380816952E+00, 1.2721777641E+00, 9.3295536399E-01, 7.4471396411E-01],
	[1.7645000000E+04, 9.8155303855E+00, 5.4378839860E+00, 1.2733329999E+00, 9.3360661755E-01, 7.4482748822E-01],
	[1.7650000000E+04, 9.8195017665E+00, 5.4376863400E+00, 1.2744889564E+00, 9.3425801646E-01, 7.4494097393E-01],
	[1.7655000000E+04, 9.8234736288E+00, 5.4374887571E+00, 1.2756456339E+00, 9.3490956055E-01, 7.4505442138E-01],
	[1.7660000000E+04, 9.8274586540E+00, 5.4372950893E+00, 1.2768030324E+00, 9.3556147861E-01, 7.4516783067E-01],
	[1.7665000000E+04, 9.8314485580E+00, 5.4371028165E+00, 1.2779611524E+00, 9.3621362132E-01, 7.4528120181E-01],
	[1.7670000000E+04, 9.8354389521E+00, 5.4369106049E+00, 1.2791199940E+00, 9.3686590933E-01, 7.4539453479E-01],
	[1.7675000000E+04, 9.8394298362E+00, 5.4367184544E+00, 1.2802795575E+00, 9.3751834247E-01, 7.4550782961E-01],
	[1.7680000000E+04, 9.8434212101E+00, 5.4365263651E+00, 1.2814398431E+00, 9.3817092054E-01, 7.4562108626E-01],
	[1.7685000000E+04, 9.8474130738E+00, 5.4363343369E+00, 1.2826008511E+00, 9.3882364338E-01, 7.4573430474E-01],
	[1.7690000000E+04, 9.8514054273E+00, 5.4361423698E+00, 1.2837625817E+00, 9.3947651081E-01, 7.4584748505E-01],
	[1.7695000000E+04, 9.8553982703E+00, 5.4359504636E+00, 1.2849250351E+00, 9.4012952264E-01, 7.4596062718E-01],
	[1.7700000000E+04, 9.8593916030E+00, 5.4357586185E+00, 1.2860882117E+00, 9.4078267871E-01, 7.4607373113E-01],
	[1.7705000000E+04, 9.8633854251E+00, 5.4355668343E+00, 1.2872521116E+00, 9.4143597882E-01, 7.4618679691E-01],
	[1.7710000000E+04, 9.8673797366E+00, 5.4353751111E+00, 1.2884167351E+00, 9.4208942281E-01, 7.4629982449E-01],
	[1.7715000000E+04, 9.8713745375E+00, 5.4351834487E+00, 1.2895820825E+00, 9.4274301049E-01, 7.4641281389E-01],
	[1.7720000000E+04, 9.8753698276E+00, 5.4349918472E+00, 1.2907481539E+00, 9.4339674168E-01, 7.4652576509E-01],
	[1.7725000000E+04, 9.8793656068E+00, 5.4348003064E+00, 1.2919149497E+00, 9.4405061622E-01, 7.4663867811E-01],
	[1.7730000000E+04, 9.8833618752E+00, 5.4346088265E+00, 1.2930824701E+00, 9.4470463391E-01, 7.4675155292E-01],
	[1.7735000000E+04, 9.8873586325E+00, 5.4344174073E+00, 1.2942507152E+00, 9.4535879458E-01, 7.4686438953E-01],
	[1.7740000000E+04, 9.8913558788E+00, 5.4342260487E+00, 1.2954196855E+00, 9.4601309805E-01, 7.4697718794E-01],
	[1.7745000000E+04, 9.8953536140E+00, 5.4340347509E+00, 1.2965893810E+00, 9.4666754414E-01, 7.4708994814E-01],
	[1.7750000000E+04, 9.8993518379E+00, 5.4338435136E+00, 1.2977598021E+00, 9.4732213268E-01, 7.4720267013E-01],
	[1.7755000000E+04, 9.9033505506E+00, 5.4336523370E+00, 1.2989309490E+00, 9.4797686348E-01, 7.4731535391E-01],
	[1.7760000000E+04, 9.9073497518E+00, 5.4334612209E+00, 1.3001028219E+00, 9.4863173636E-01, 7.4742799947E-01],
	[1.7765000000E+04, 9.9113494416E+00, 5.4332701653E+00, 1.3012754212E+00, 9.4928675115E-01, 7.4754060682E-01],
	[1.7770000000E+04, 9.9153496199E+00, 5.4330791702E+00, 1.3024487469E+00, 9.4994190767E-01, 7.4765317594E-01],
	[1.7775000000E+04, 9.9193502866E+00, 5.4328882356E+00, 1.3036227995E+00, 9.5059720574E-01, 7.4776570684E-01],
	[1.7780000000E+04, 9.9233514415E+00, 5.4326973613E+00, 1.3047975790E+00, 9.5125264517E-01, 7.4787819952E-01],
	[1.7785000000E+04, 9.9273530847E+00, 5.4325065474E+00, 1.3059730859E+00, 9.5190822580E-01, 7.4799065396E-01],
	[1.7790000000E+04, 9.9313552161E+00, 5.4323157939E+00, 1.3071493202E+00, 9.5256394743E-01, 7.4810307017E-01],
	[1.7795000000E+04, 9.9353578356E+00, 5.4321251007E+00, 1.3083262823E+00, 9.5321980990E-01, 7.4821544815E-01],
	[1.7800000000E+04, 9.9393609430E+00, 5.4319344677E+00, 1.3095039725E+00, 9.5387581302E-01, 7.4832778789E-01],
	[1.7805000000E+04, 9.9433645384E+00, 5.4317438950E+00, 1.3106823908E+00, 9.5453195661E-01, 7.4844008939E-01],
	[1.7810000000E+04, 9.9473686216E+00, 5.4315533824E+00, 1.3118615377E+00, 9.5518824050E-01, 7.4855235265E-01],
	[1.7815000000E+04, 9.9513731925E+00, 5.4313629300E+00, 1.3130414133E+00, 9.5584466450E-01, 7.4866457766E-01],
	[1.7820000000E+04, 9.9553782512E+00, 5.4311725377E+00, 1.3142220178E+00, 9.5650122843E-01, 7.4877676443E-01],
	[1.7825000000E+04, 9.9593837975E+00, 5.4309822056E+00, 1.3154033517E+00, 9.5715793212E-01, 7.4888891294E-01],
	[1.7830000000E+04, 9.9633898313E+00, 5.4307919334E+00, 1.3165854149E+00, 9.5781477538E-01, 7.4900102321E-01],
	[1.7835000000E+04, 9.9673963526E+00, 5.4306017213E+00, 1.3177682079E+00, 9.5847175805E-01, 7.4911309522E-01],
	[1.7840000000E+04, 9.9714033613E+00, 5.4304115691E+00, 1.3189517309E+00, 9.5912887992E-01, 7.4922512897E-01],
	[1.7845000000E+04, 9.9754108572E+00, 5.4302214769E+00, 1.3201359841E+00, 9.5978614084E-01, 7.4933712446E-01],
	[1.7850000000E+04, 9.9794188404E+00, 5.4300314446E+00, 1.3213209677E+00, 9.6044354061E-01, 7.4944908169E-01],
	[1.7855000000E+04, 9.9834273107E+00, 5.4298414722E+00, 1.3225066820E+00, 9.6110107905E-01, 7.4956100066E-01],
	[1.7860000000E+04, 9.9874362681E+00, 5.4296515596E+00, 1.3236931273E+00, 9.6175875600E-01, 7.4967288136E-01],
	[1.7865000000E+04, 9.9914457125E+00, 5.4294617068E+00, 1.3248803038E+00, 9.6241657126E-01, 7.4978472379E-01],
	[1.7870000000E+04, 9.9954556439E+00, 5.4292719138E+00, 1.3260682117E+00, 9.6307452466E-01, 7.4989652795E-01],
	[1.7875000000E+04, 9.9994660620E+00, 5.4290821805E+00, 1.3272568513E+00, 9.6373261602E-01, 7.5000829384E-01],
	[1.7880000000E+04, 1.0003476967E+01, 5.4288925069E+00, 1.3284462228E+00, 9.6439084515E-01, 7.5012002145E-01],
	[1.7885000000E+04, 1.0007488359E+01, 5.4287028929E+00, 1.3296363265E+00, 9.6504921189E-01, 7.5023171078E-01],
	[1.7890000000E+04, 1.0011500237E+01, 5.4285133386E+00, 1.3308271626E+00, 9.6570771604E-01, 7.5034336184E-01],
	[1.7895000000E+04, 1.0015512602E+01, 5.4283238438E+00, 1.3320187313E+00, 9.6636635743E-01, 7.5045497462E-01],
	[1.7900000000E+04, 1.0019525453E+01, 5.4281344086E+00, 1.3332110330E+00, 9.6702513587E-01, 7.5056654911E-01],
	[1.7905000000E+04, 1.0023538790E+01, 5.4279450329E+00, 1.3344040678E+00, 9.6768405119E-01, 7.5067808531E-01],
	[1.7910000000E+04, 1.0027552614E+01, 5.4277557167E+00, 1.3355978360E+00, 9.6834310321E-01, 7.5078958323E-01],
	[1.7915000000E+04, 1.0031566924E+01, 5.4275664600E+00, 1.3367923379E+00, 9.6900229175E-01, 7.5090104286E-01],
	[1.7920000000E+04, 1.0035581721E+01, 5.4273772626E+00, 1.3379875736E+00, 9.6966161662E-01, 7.5101246420E-01],
	[1.7925000000E+04, 1.0039597003E+01, 5.4271881247E+00, 1.3391835435E+00, 9.7032107765E-01, 7.5112384725E-01],
	[1.7930000000E+04, 1.0043612771E+01, 5.4269990460E+00, 1.3403802478E+00, 9.7098067466E-01, 7.5123519200E-01],
	[1.7935000000E+04, 1.0047629025E+01, 5.4268100267E+00, 1.3415776866E+00, 9.7164040746E-01, 7.5134649845E-01],
	[1.7940000000E+04, 1.0051645766E+01, 5.4266210666E+00, 1.3427758604E+00, 9.7230027587E-01, 7.5145776661E-01],
	[1.7945000000E+04, 1.0055678620E+01, 5.4264367472E+00, 1.3439747692E+00, 9.7296057332E-01, 7.5156899647E-01],
	[1.7950000000E+04, 1.0059713814E+01, 5.4262530261E+00, 1.3451744135E+00, 9.7362104133E-01, 7.5168018802E-01],
	[1.7955000000E+04, 1.0063749502E+01, 5.4260693623E+00, 1.3463747933E+00, 9.7428164509E-01, 7.5179134127E-01],
	[1.7960000000E+04, 1.0067785685E+01, 5.4258857560E+00, 1.3475759090E+00, 9.7494238442E-01, 7.5190245622E-01],
	[1.7965000000E+04, 1.0071822363E+01, 5.4257022069E+00, 1.3487777608E+00, 9.7560325915E-01, 7.5201353286E-01],
	[1.7970000000E+04, 1.0075859535E+01, 5.4255187151E+00, 1.3499803489E+00, 9.7626426909E-01, 7.5212457119E-01],
	[1.7975000000E+04, 1.0079897202E+01, 5.4253352806E+00, 1.3511836736E+00, 9.7692541407E-01, 7.5223557121E-01],
	[1.7980000000E+04, 1.0083935363E+01, 5.4251519033E+00, 1.3523877351E+00, 9.7758669390E-01, 7.5234653292E-01],
	[1.7985000000E+04, 1.0087974018E+01, 5.4249685832E+00, 1.3535925338E+00, 9.7824810840E-01, 7.5245745631E-01],
	[1.7990000000E+04, 1.0092013167E+01, 5.4247853202E+00, 1.3547980697E+00, 9.7890965739E-01, 7.5256834139E-01],
	[1.7995000000E+04, 1.0096052811E+01, 5.4246021143E+00, 1.3560043432E+00, 9.7957134070E-01, 7.5267918816E-01],
	[1.8000000000E+04, 1.0100092948E+01, 5.4244189656E+00, 1.3572113545E+00, 9.8023315813E-01, 7.5278999661E-01],
	[1.8005000000E+04, 1.0104133580E+01, 5.4242358738E+00, 1.3584191039E+00, 9.8089510952E-01, 7.5290076674E-01],
	[1.8010000000E+04, 1.0108174705E+01, 5.4240528391E+00, 1.3596275916E+00, 9.8155719469E-01, 7.5301149855E-01],
	[1.8015000000E+04, 1.0112216325E+01, 5.4238698614E+00, 1.3608368179E+00, 9.8221941344E-01, 7.5312219203E-01],
	[1.8020000000E+04, 1.0116258438E+01, 5.4236869406E+00, 1.3620467829E+00, 9.8288176560E-01, 7.5323284720E-01],
	[1.8025000000E+04, 1.0120301044E+01, 5.4235040767E+00, 1.3632574870E+00, 9.8354425099E-01, 7.5334346404E-01],
	[1.8030000000E+04, 1.0124344144E+01, 5.4233212697E+00, 1.3644689304E+00, 9.8420686944E-01, 7.5345404255E-01],
	[1.8035000000E+04, 1.0128387738E+01, 5.4231385196E+00, 1.3656811133E+00, 9.8486962075E-01, 7.5356458274E-01],
	[1.8040000000E+04, 1.0132431825E+01, 5.4229558263E+00, 1.3668940360E+00, 9.8553250474E-01, 7.5367508460E-01],
	[1.8045000000E+04, 1.0136476406E+01, 5.4227731897E+00, 1.3681076987E+00, 9.8619552125E-01, 7.5378554813E-01],
	[1.8050000000E+04, 1.0140521479E+01, 5.4225906099E+00, 1.3693221017E+00, 9.8685867008E-01, 7.5389597333E-01],
	[1.8055000000E+04, 1.0144567046E+01, 5.4224080868E+00, 1.3705372452E+00, 9.8752195106E-01, 7.5400636020E-01],
	[1.8060000000E+04, 1.0148613106E+01, 5.4222256204E+00, 1.3717531294E+00, 9.8818536400E-01, 7.5411670873E-01],
	[1.8065000000E+04, 1.0152659660E+01, 5.4220432107E+00, 1.3729697547E+00, 9.8884890873E-01, 7.5422701894E-01],
	[1.8070000000E+04, 1.0156706706E+01, 5.4218608575E+00, 1.3741871212E+00, 9.8951258506E-01, 7.5433729080E-01],
	[1.8075000000E+04, 1.0160754245E+01, 5.4216785610E+00, 1.3754052292E+00, 9.9017639281E-01, 7.5444752434E-01],
	[1.8080000000E+04, 1.0164802276E+01, 5.4214963210E+00, 1.3766240790E+00, 9.9084033181E-01, 7.5455771953E-01],
	[1.8085000000E+04, 1.0168850801E+01, 5.4213141375E+00, 1.3778436708E+00, 9.9150440186E-01, 7.5466787639E-01],
	[1.8090000000E+04, 1.0172899818E+01, 5.4211320104E+00, 1.3790640048E+00, 9.9216860280E-01, 7.5477799491E-01],
	[1.8095000000E+04, 1.0176949328E+01, 5.4209499399E+00, 1.3802850812E+00, 9.9283293443E-01, 7.5488807509E-01],
	[1.8100000000E+04, 1.0180999330E+01, 5.4207679257E+00, 1.3815069004E+00, 9.9349739659E-01, 7.5499811693E-01],
	[1.8105000000E+04, 1.0185049825E+01, 5.4205859679E+00, 1.3827294626E+00, 9.9416198907E-01, 7.5510812043E-01],
	[1.8110000000E+04, 1.0189100812E+01, 5.4204040665E+00, 1.3839527680E+00, 9.9482671172E-01, 7.5521808559E-01],
	[1.8115000000E+04, 1.0193152291E+01, 5.4202222214E+00, 1.3851768169E+00, 9.9549156433E-01, 7.5532801240E-01],
	[1.8120000000E+04, 1.0197204263E+01, 5.4200404326E+00, 1.3864016095E+00, 9.9615654675E-01, 7.5543790088E-01],
	[1.8125000000E+04, 1.0201256727E+01, 5.4198587000E+00, 1.3876271460E+00, 9.9682165877E-01, 7.5554775100E-01],
	[1.8130000000E+04, 1.0205309682E+01, 5.4196770236E+00, 1.3888534267E+00, 9.9748690022E-01, 7.5565756279E-01],
	[1.8135000000E+04, 1.0209363130E+01, 5.4194954035E+00, 1.3900804519E+00, 9.9815227092E-01, 7.5576733622E-01],
	[1.8140000000E+04, 1.0213417070E+01, 5.4193138394E+00, 1.3913082218E+00, 9.9881777069E-01, 7.5587707131E-01],
	[1.8145000000E+04, 1.0217471501E+01, 5.4191323315E+00, 1.3925367366E+00, 9.9948339935E-01, 7.5598676806E-01],
	[1.8150000000E+04, 1.0221526425E+01, 5.4189508797E+00, 1.3937659967E+00, 1.0001491567E+00, 7.5609642646E-01],
	[1.8155000000E+04, 1.0225581839E+01, 5.4187694839E+00, 1.3949960021E+00, 1.0008150426E+00, 7.5620604651E-01],
	[1.8160000000E+04, 1.0229637746E+01, 5.4185881442E+00, 1.3962267532E+00, 1.0014810568E+00, 7.5631562821E-01],
	[1.8165000000E+04, 1.0233694144E+01, 5.4184068604E+00, 1.3974582503E+00, 1.0021471992E+00, 7.5642517156E-01],
	[1.8170000000E+04, 1.0237751033E+01, 5.4182256326E+00, 1.3986904935E+00, 1.0028134696E+00, 7.5653467656E-01],
	[1.8175000000E+04, 1.0241808414E+01, 5.4180444608E+00, 1.3999234831E+00, 1.0034798678E+00, 7.5664414321E-01],
	[1.8180000000E+04, 1.0245866286E+01, 5.4178633448E+00, 1.4011572194E+00, 1.0041463935E+00, 7.5675357151E-01],
	[1.8185000000E+04, 1.0249924650E+01, 5.4176822846E+00, 1.4023917026E+00, 1.0048130468E+00, 7.5686296146E-01],
	[1.8190000000E+04, 1.0253983504E+01, 5.4175012803E+00, 1.4036269330E+00, 1.0054798272E+00, 7.5697231306E-01],
	[1.8195000000E+04, 1.0258042850E+01, 5.4173203318E+00, 1.4048629107E+00, 1.0061467348E+00, 7.5708162631E-01],
	[1.8200000000E+04, 1.0262102686E+01, 5.4171394390E+00, 1.4060996362E+00, 1.0068137692E+00, 7.5719090121E-01],
	[1.8205000000E+04, 1.0266163014E+01, 5.4169586020E+00, 1.4073371095E+00, 1.0074809303E+00, 7.5730013775E-01],
	[1.8210000000E+04, 1.0270223832E+01, 5.4167778207E+00, 1.4085753309E+00, 1.0081482180E+00, 7.5740933595E-01],
	[1.8215000000E+04, 1.0274285141E+01, 5.4165970950E+00, 1.4098143007E+00, 1.0088156320E+00, 7.5751849579E-01],
	[1.8220000000E+04, 1.0278346941E+01, 5.4164164249E+00, 1.4110540192E+00, 1.0094831722E+00, 7.5762761727E-01],
	[1.8225000000E+04, 1.0282409231E+01, 5.4162358105E+00, 1.4122944865E+00, 1.0101508384E+00, 7.5773670041E-01],
	[1.8230000000E+04, 1.0286474350E+01, 5.4160559136E+00, 1.4135357030E+00, 1.0108186760E+00, 7.5784574519E-01],
	[1.8235000000E+04, 1.0290555502E+01, 5.4158804699E+00, 1.4147776688E+00, 1.0114869428E+00, 7.5795475162E-01],
	[1.8240000000E+04, 1.0294637154E+01, 5.4157050801E+00, 1.4160203842E+00, 1.0121553358E+00, 7.5806371969E-01],
	[1.8245000000E+04, 1.0298719306E+01, 5.4155297440E+00, 1.4172638495E+00, 1.0128238548E+00, 7.5817264941E-01],
	[1.8250000000E+04, 1.0302801957E+01, 5.4153544617E+00, 1.4185080649E+00, 1.0134924995E+00, 7.5828154078E-01],
	[1.8255000000E+04, 1.0306885107E+01, 5.4151792330E+00, 1.4197530307E+00, 1.0141612698E+00, 7.5839039380E-01],
	[1.8260000000E+04, 1.0310968757E+01, 5.4150040580E+00, 1.4209987471E+00, 1.0148301655E+00, 7.5849920846E-01],
	[1.8265000000E+04, 1.0315052905E+01, 5.4148289366E+00, 1.4222452143E+00, 1.0154991865E+00, 7.5860798476E-01],
	[1.8270000000E+04, 1.0319137554E+01, 5.4146538688E+00, 1.4234924326E+00, 1.0161683325E+00, 7.5871672272E-01],
	[1.8275000000E+04, 1.0323222701E+01, 5.4144788545E+00, 1.4247404022E+00, 1.0168376034E+00, 7.5882542232E-01],
	[1.8280000000E+04, 1.0327308347E+01, 5.4143038938E+00, 1.4259891235E+00, 1.0175069989E+00, 7.5893408357E-01],
	[1.8285000000E+04, 1.0331394492E+01, 5.4141289866E+00, 1.4272385965E+00, 1.0181765190E+00, 7.5904270646E-01],
	[1.8290000000E+04, 1.0335481136E+01, 5.4139541329E+00, 1.4284888217E+00, 1.0188461634E+00, 7.5915129100E-01],
	[1.8295000000E+04, 1.0339568279E+01, 5.4137793326E+00, 1.4297397991E+00, 1.0195159319E+00, 7.5925983719E-01],
	[1.8300000000E+04, 1.0343655921E+01, 5.4136045857E+00, 1.4309915292E+00, 1.0201858244E+00, 7.5936834503E-01],
	[1.8305000000E+04, 1.0347744061E+01, 5.4134298922E+00, 1.4322440120E+00, 1.0208558407E+00, 7.5947681451E-01],
	[1.8310000000E+04, 1.0351832700E+01, 5.4132552520E+00, 1.4334972479E+00, 1.0215259806E+00, 7.5958524565E-01],
	[1.8315000000E+04, 1.0355921837E+01, 5.4130806651E+00, 1.4347512371E+00, 1.0221962438E+00, 7.5969363843E-01],
	[1.8320000000E+04, 1.0360011473E+01, 5.4129061316E+00, 1.4360059799E+00, 1.0228666303E+00, 7.5980199286E-01],
	[1.8325000000E+04, 1.0364101607E+01, 5.4127316513E+00, 1.4372614765E+00, 1.0235371399E+00, 7.5991030894E-01],
	[1.8330000000E+04, 1.0368192239E+01, 5.4125572242E+00, 1.4385177271E+00, 1.0242077723E+00, 7.6001858666E-01],
	[1.8335000000E+04, 1.0372283370E+01, 5.4123828503E+00, 1.4397747321E+00, 1.0248785274E+00, 7.6012682604E-01],
	[1.8340000000E+04, 1.0376374999E+01, 5.4122085295E+00, 1.4410324915E+00, 1.0255494050E+00, 7.6023502707E-01],
	[1.8345000000E+04, 1.0380467125E+01, 5.4120342619E+00, 1.4422910058E+00, 1.0262204050E+00, 7.6034318975E-01],
	[1.8350000000E+04, 1.0384559750E+01, 5.4118600474E+00, 1.4435502751E+00, 1.0268915271E+00, 7.6045131408E-01],
	[1.8355000000E+04, 1.0388652873E+01, 5.4116858859E+00, 1.4448102996E+00, 1.0275627711E+00, 7.6055940006E-01],
	[1.8360000000E+04, 1.0392746493E+01, 5.4115117775E+00, 1.4460710797E+00, 1.0282341369E+00, 7.6066744769E-01],
	[1.8365000000E+04, 1.0396840612E+01, 5.4113377221E+00, 1.4473326156E+00, 1.0289056243E+00, 7.6077545698E-01],
	[1.8370000000E+04, 1.0400935228E+01, 5.4111637197E+00, 1.4485949075E+00, 1.0295772331E+00, 7.6088342792E-01],
	[1.8375000000E+04, 1.0405030341E+01, 5.4109897703E+00, 1.4498579557E+00, 1.0302489632E+00, 7.6099136051E-01],
	[1.8380000000E+04, 1.0409125952E+01, 5.4108158737E+00, 1.4511217603E+00, 1.0309208143E+00, 7.6109925476E-01],
	[1.8385000000E+04, 1.0413222061E+01, 5.4106420300E+00, 1.4523863218E+00, 1.0315927862E+00, 7.6120711067E-01],
	[1.8390000000E+04, 1.0417318667E+01, 5.4104682392E+00, 1.4536516402E+00, 1.0322648789E+00, 7.6131492823E-01],
	[1.8395000000E+04, 1.0421415770E+01, 5.4102945012E+00, 1.4549177159E+00, 1.0329370920E+00, 7.6142270744E-01],
	[1.8400000000E+04, 1.0425513370E+01, 5.4101208160E+00, 1.4561845491E+00, 1.0336094255E+00, 7.6153044832E-01],
	[1.8405000000E+04, 1.0429611468E+01, 5.4099471836E+00, 1.4574521400E+00, 1.0342818791E+00, 7.6163815085E-01],
	[1.8410000000E+04, 1.0433710062E+01, 5.4097736039E+00, 1.4587204889E+00, 1.0349544527E+00, 7.6174581504E-01],
	[1.8415000000E+04, 1.0437809154E+01, 5.4096000769E+00, 1.4599895961E+00, 1.0356271460E+00, 7.6185344089E-01],
	[1.8420000000E+04, 1.0441908743E+01, 5.4094266026E+00, 1.4612594617E+00, 1.0362999589E+00, 7.6196102840E-01],
	[1.8425000000E+04, 1.0446008828E+01, 5.4092531809E+00, 1.4625300861E+00, 1.0369728913E+00, 7.6206857757E-01],
	[1.8430000000E+04, 1.0450109410E+01, 5.4090798119E+00, 1.4638014695E+00, 1.0376459428E+00, 7.6217608841E-01],
	[1.8435000000E+04, 1.0454210489E+01, 5.4089064954E+00, 1.4650736121E+00, 1.0383191135E+00, 7.6228356091E-01],
	[1.8440000000E+04, 1.0458312065E+01, 5.4087332314E+00, 1.4663465141E+00, 1.0389924029E+00, 7.6239099494E-01],
	[1.8445000000E+04, 1.0462414137E+01, 5.4085600200E+00, 1.4676201759E+00, 1.0396658111E+00, 7.6249839042E-01],
	[1.8450000000E+04, 1.0466516705E+01, 5.4083868611E+00, 1.4688945977E+00, 1.0403393377E+00, 7.6260574736E-01],
	[1.8455000000E+04, 1.0470619770E+01, 5.4082137547E+00, 1.4701697796E+00, 1.0410129827E+00, 7.6271306576E-01],
	[1.8460000000E+04, 1.0474723332E+01, 5.4080407006E+00, 1.4714457220E+00, 1.0416867457E+00, 7.6282034562E-01],
	[1.8465000000E+04, 1.0478827389E+01, 5.4078676990E+00, 1.4727224252E+00, 1.0423606268E+00, 7.6292758695E-01],
	[1.8470000000E+04, 1.0482931943E+01, 5.4076947498E+00, 1.4739998892E+00, 1.0430346256E+00, 7.6303478975E-01],
	[1.8475000000E+04, 1.0487036993E+01, 5.4075218529E+00, 1.4752781145E+00, 1.0437087420E+00, 7.6314195402E-01],
	[1.8480000000E+04, 1.0491142539E+01, 5.4073490083E+00, 1.4765571012E+00, 1.0443829758E+00, 7.6324907978E-01],
	[1.8485000000E+04, 1.0495248581E+01, 5.4071762159E+00, 1.4778368497E+00, 1.0450573268E+00, 7.6335616703E-01],
	[1.8490000000E+04, 1.0499355118E+01, 5.4070034759E+00, 1.4791173600E+00, 1.0457317948E+00, 7.6346321577E-01],
	[1.8495000000E+04, 1.0503462152E+01, 5.4068307880E+00, 1.4803986325E+00, 1.0464063797E+00, 7.6357022600E-01],
	[1.8500000000E+04, 1.0507569681E+01, 5.4066581524E+00, 1.4816806675E+00, 1.0470810813E+00, 7.6367719774E-01],
	[1.8505000000E+04, 1.0511677706E+01, 5.4064855689E+00, 1.4829634652E+00, 1.0477558993E+00, 7.6378413098E-01],
	[1.8510000000E+04, 1.0515786227E+01, 5.4063130375E+00, 1.4842470258E+00, 1.0484308337E+00, 7.6389102573E-01],
	[1.8515000000E+04, 1.0519895243E+01, 5.4061405583E+00, 1.4855313495E+00, 1.0491058842E+00, 7.6399788200E-01],
	[1.8520000000E+04, 1.0524004755E+01, 5.4059681311E+00, 1.4868164367E+00, 1.0497810506E+00, 7.6410469979E-01],
	[1.8525000000E+04, 1.0528122759E+01, 5.4057979420E+00, 1.4881022875E+00, 1.0504564950E+00, 7.6421147910E-01],
	[1.8530000000E+04, 1.0532251557E+01, 5.4056306168E+00, 1.4893889023E+00, 1.0511322641E+00, 7.6431821995E-01],
	[1.8535000000E+04, 1.0536380860E+01, 5.4054633420E+00, 1.4906762812E+00, 1.0518081494E+00, 7.6442492233E-01],
	[1.8540000000E+04, 1.0540510667E+01, 5.4052961174E+00, 1.4919644245E+00, 1.0524841505E+00, 7.6453158625E-01],
	[1.8545000000E+04, 1.0544640979E+01, 5.4051289431E+00, 1.4932533325E+00, 1.0531602675E+00, 7.6463821171E-01],
	[1.8550000000E+04, 1.0548771795E+01, 5.4049618191E+00, 1.4945430054E+00, 1.0538365000E+00, 7.6474479873E-01],
	[1.8555000000E+04, 1.0552903115E+01, 5.4047947453E+00, 1.4958334435E+00, 1.0545128479E+00, 7.6485134730E-01],
	[1.8560000000E+04, 1.0557034940E+01, 5.4046277216E+00, 1.4971246469E+00, 1.0551893110E+00, 7.6495785743E-01],
	[1.8565000000E+04, 1.0561167269E+01, 5.4044607481E+00, 1.4984166160E+00, 1.0558658891E+00, 7.6506432913E-01],
	[1.8570000000E+04, 1.0565300102E+01, 5.4042938247E+00, 1.4997093509E+00, 1.0565425820E+00, 7.6517076240E-01],
	[1.8575000000E+04, 1.0569433439E+01, 5.4041269514E+00, 1.5010028520E+00, 1.0572193896E+00, 7.6527715725E-01],
	[1.8580000000E+04, 1.0573567280E+01, 5.4039601281E+00, 1.5022971195E+00, 1.0578963117E+00, 7.6538351367E-01],
	[1.8585000000E+04, 1.0577701624E+01, 5.4037933549E+00, 1.5035921536E+00, 1.0585733481E+00, 7.6548983168E-01],
	[1.8590000000E+04, 1.0581836473E+01, 5.4036266317E+00, 1.5048879546E+00, 1.0592504986E+00, 7.6559611129E-01],
	[1.8595000000E+04, 1.0585971825E+01, 5.4034599585E+00, 1.5061845228E+00, 1.0599277630E+00, 7.6570235248E-01],
	[1.8600000000E+04, 1.0590107681E+01, 5.4032933353E+00, 1.5074818582E+00, 1.0606051412E+00, 7.6580855528E-01],
	[1.8605000000E+04, 1.0594244040E+01, 5.4031267619E+00, 1.5087799614E+00, 1.0612826329E+00, 7.6591471969E-01],
	[1.8610000000E+04, 1.0598380903E+01, 5.4029602384E+00, 1.5100788323E+00, 1.0619602381E+00, 7.6602084571E-01],
	[1.8615000000E+04, 1.0602518269E+01, 5.4027937649E+00, 1.5113784714E+00, 1.0626379564E+00, 7.6612693334E-01],
	[1.8620000000E+04, 1.0606656138E+01, 5.4026273411E+00, 1.5126788789E+00, 1.0633157877E+00, 7.6623298260E-01],
	[1.8625000000E+04, 1.0610794511E+01, 5.4024609672E+00, 1.5139800550E+00, 1.0639937319E+00, 7.6633899348E-01],
	[1.8630000000E+04, 1.0614933387E+01, 5.4022946430E+00, 1.5152819999E+00, 1.0646717887E+00, 7.6644496600E-01],
	[1.8635000000E+04, 1.0619072766E+01, 5.4021283686E+00, 1.5165847139E+00, 1.0653499580E+00, 7.6655090016E-01],
	[1.8640000000E+04, 1.0623212648E+01, 5.4019621439E+00, 1.5178881973E+00, 1.0660282395E+00, 7.6665679596E-01],
	[1.8645000000E+04, 1.0627353034E+01, 5.4017959689E+00, 1.5191924502E+00, 1.0667066332E+00, 7.6676265340E-01],
	[1.8650000000E+04, 1.0631493922E+01, 5.4016298435E+00, 1.5204974730E+00, 1.0673851388E+00, 7.6686847250E-01],
	[1.8655000000E+04, 1.0635635312E+01, 5.4014637679E+00, 1.5218032660E+00, 1.0680637562E+00, 7.6697425326E-01],
	[1.8660000000E+04, 1.0639777206E+01, 5.4012977418E+00, 1.5231098292E+00, 1.0687424850E+00, 7.6707999569E-01],
	[1.8665000000E+04, 1.0643919602E+01, 5.4011317653E+00, 1.5244171630E+00, 1.0694213253E+00, 7.6718569978E-01],
	[1.8670000000E+04, 1.0648062501E+01, 5.4009658383E+00, 1.5257252677E+00, 1.0701002768E+00, 7.6729136556E-01],
	[1.8675000000E+04, 1.0652205902E+01, 5.4007999609E+00, 1.5270341434E+00, 1.0707793392E+00, 7.6739699301E-01],
	[1.8680000000E+04, 1.0656349806E+01, 5.4006341330E+00, 1.5283437905E+00, 1.0714585125E+00, 7.6750258214E-01],
	[1.8685000000E+04, 1.0660494212E+01, 5.4004683545E+00, 1.5296542091E+00, 1.0721377964E+00, 7.6760813297E-01],
	[1.8690000000E+04, 1.0664639121E+01, 5.4003026255E+00, 1.5309653996E+00, 1.0728171908E+00, 7.6771364550E-01],
	[1.8695000000E+04, 1.0668784531E+01, 5.4001369459E+00, 1.5322773621E+00, 1.0734966955E+00, 7.6781911973E-01],
	[1.8700000000E+04, 1.0672930444E+01, 5.3999713157E+00, 1.5335900970E+00, 1.0741763103E+00, 7.6792455567E-01],
	[1.8705000000E+04, 1.0677076859E+01, 5.3998057349E+00, 1.5349036044E+00, 1.0748560349E+00, 7.6802995332E-01],
	[1.8710000000E+04, 1.0681223776E+01, 5.3996402033E+00, 1.5362179680E+00, 1.0755359102E+00, 7.6813531269E-01],
	[1.8715000000E+04, 1.0685371195E+01, 5.3994747211E+00, 1.5375332669E+00, 1.0762159745E+00, 7.6824063378E-01],
	[1.8720000000E+04, 1.0689519116E+01, 5.3993092882E+00, 1.5388493395E+00, 1.0768961482E+00, 7.6834591661E-01],
	[1.8725000000E+04, 1.0693667538E+01, 5.3991439045E+00, 1.5401661859E+00, 1.0775764311E+00, 7.6845116117E-01],
	[1.8730000000E+04, 1.0697816462E+01, 5.3989785700E+00, 1.5414838066E+00, 1.0782568231E+00, 7.6855636747E-01],
	[1.8735000000E+04, 1.0701965888E+01, 5.3988132847E+00, 1.5428022017E+00, 1.0789373241E+00, 7.6866153552E-01],
	[1.8740000000E+04, 1.0706115816E+01, 5.3986480486E+00, 1.5441213714E+00, 1.0796179337E+00, 7.6876666533E-01],
	[1.8745000000E+04, 1.0710266244E+01, 5.3984828616E+00, 1.5454413161E+00, 1.0802986518E+00, 7.6887175689E-01],
	[1.8750000000E+04, 1.0714417175E+01, 5.3983177237E+00, 1.5467620359E+00, 1.0809794783E+00, 7.6897681021E-01],
	[1.8755000000E+04, 1.0718568606E+01, 5.3981526349E+00, 1.5480835312E+00, 1.0816604130E+00, 7.6908182531E-01],
	[1.8760000000E+04, 1.0722720539E+01, 5.3979875952E+00, 1.5494058021E+00, 1.0823414556E+00, 7.6918680218E-01],
	[1.8765000000E+04, 1.0726872974E+01, 5.3978226045E+00, 1.5507288489E+00, 1.0830226060E+00, 7.6929174083E-01],
	[1.8770000000E+04, 1.0731025909E+01, 5.3976576628E+00, 1.5520526719E+00, 1.0837038640E+00, 7.6939664127E-01],
	[1.8775000000E+04, 1.0735179345E+01, 5.3974927700E+00, 1.5533772713E+00, 1.0843852295E+00, 7.6950150350E-01],
	[1.8780000000E+04, 1.0739333283E+01, 5.3973279262E+00, 1.5547026474E+00, 1.0850667022E+00, 7.6960632752E-01],
	[1.8785000000E+04, 1.0743487721E+01, 5.3971631313E+00, 1.5560288003E+00, 1.0857482820E+00, 7.6971111336E-01],
	[1.8790000000E+04, 1.0747642660E+01, 5.3969983853E+00, 1.5573557304E+00, 1.0864299686E+00, 7.6981586100E-01],
	[1.8795000000E+04, 1.0751798100E+01, 5.3968336881E+00, 1.5586834379E+00, 1.0871117620E+00, 7.6992057046E-01],
	[1.8800000000E+04, 1.0755954040E+01, 5.3966690398E+00, 1.5600119231E+00, 1.0877936618E+00, 7.7002524174E-01],
	[1.8805000000E+04, 1.0760110481E+01, 5.3965044403E+00, 1.5613411861E+00, 1.0884756680E+00, 7.7012987485E-01],
	[1.8810000000E+04, 1.0764267423E+01, 5.3963398896E+00, 1.5626712273E+00, 1.0891577803E+00, 7.7023446979E-01],
	[1.8815000000E+04, 1.0768424865E+01, 5.3961753876E+00, 1.5640020469E+00, 1.0898399986E+00, 7.7033902656E-01],
	[1.8820000000E+04, 1.0772582808E+01, 5.3960109343E+00, 1.5653336451E+00, 1.0905223227E+00, 7.7044354519E-01],
	[1.8825000000E+04, 1.0776756197E+01, 5.3958504749E+00, 1.5666660222E+00, 1.0912050669E+00, 7.7054802566E-01],
	[1.8830000000E+04, 1.0780933859E+01, 5.3956910560E+00, 1.5679991784E+00, 1.0918879965E+00, 7.7065246799E-01],
	[1.8835000000E+04, 1.0785112031E+01, 5.3955316841E+00, 1.5693331140E+00, 1.0925710320E+00, 7.7075687219E-01],
	[1.8840000000E+04, 1.0789290712E+01, 5.3953723592E+00, 1.5706678293E+00, 1.0932541733E+00, 7.7086123825E-01],
	[1.8845000000E+04, 1.0793469903E+01, 5.3952130813E+00, 1.5720033244E+00, 1.0939374203E+00, 7.7096556619E-01],
	[1.8850000000E+04, 1.0797649603E+01, 5.3950538504E+00, 1.5733395996E+00, 1.0946207726E+00, 7.7106985600E-01],
	[1.8855000000E+04, 1.0801829812E+01, 5.3948946664E+00, 1.5746766552E+00, 1.0953042303E+00, 7.7117410771E-01],
	[1.8860000000E+04, 1.0806010531E+01, 5.3947355293E+00, 1.5760144915E+00, 1.0959877929E+00, 7.7127832130E-01],
	[1.8865000000E+04, 1.0810191759E+01, 5.3945764391E+00, 1.5773531086E+00, 1.0966714605E+00, 7.7138249680E-01],
	[1.8870000000E+04, 1.0814373496E+01, 5.3944173957E+00, 1.5786925068E+00, 1.0973552327E+00, 7.7148663420E-01],
	[1.8875000000E+04, 1.0818555743E+01, 5.3942583992E+00, 1.5800326864E+00, 1.0980391095E+00, 7.7159073351E-01],
	[1.8880000000E+04, 1.0822738498E+01, 5.3940994494E+00, 1.5813736476E+00, 1.0987230906E+00, 7.7169479473E-01],
	[1.8885000000E+04, 1.0826921763E+01, 5.3939405464E+00, 1.5827153907E+00, 1.0994071759E+00, 7.7179881788E-01],
	[1.8890000000E+04, 1.0831105536E+01, 5.3937816902E+00, 1.5840579158E+00, 1.1000913651E+00, 7.7190280296E-01],
	[1.8895000000E+04, 1.0835289818E+01, 5.3936228807E+00, 1.5854012234E+00, 1.1007756581E+00, 7.7200674997E-01],
	[1.8900000000E+04, 1.0839474609E+01, 5.3934641179E+00, 1.5867453135E+00, 1.1014600547E+00, 7.7211065893E-01],
	[1.8905000000E+04, 1.0843659908E+01, 5.3933054017E+00, 1.5880901865E+00, 1.1021445547E+00, 7.7221452983E-01],
	[1.8910000000E+04, 1.0847845716E+01, 5.3931467322E+00, 1.5894358426E+00, 1.1028291580E+00, 7.7231836268E-01],
	[1.8915000000E+04, 1.0852032033E+01, 5.3929881093E+00, 1.5907822820E+00, 1.1035138643E+00, 7.7242215749E-01],
	[1.8920000000E+04, 1.0856218858E+01, 5.3928295330E+00, 1.5921295051E+00, 1.1041986735E+00, 7.7252591427E-01],
	[1.8925000000E+04, 1.0860406191E+01, 5.3926710032E+00, 1.5934775119E+00, 1.1048835854E+00, 7.7262963302E-01],
	[1.8930000000E+04, 1.0864594033E+01, 5.3925125200E+00, 1.5948263029E+00, 1.1055685998E+00, 7.7273331375E-01],
	[1.8935000000E+04, 1.0868782382E+01, 5.3923540833E+00, 1.5961758782E+00, 1.1062537165E+00, 7.7283695646E-01],
	[1.8940000000E+04, 1.0872971241E+01, 5.3921956931E+00, 1.5975262382E+00, 1.1069389353E+00, 7.7294056116E-01],
	[1.8945000000E+04, 1.0877160607E+01, 5.3920373493E+00, 1.5988773829E+00, 1.1076242561E+00, 7.7304412786E-01],
	[1.8950000000E+04, 1.0881350481E+01, 5.3918790520E+00, 1.6002293128E+00, 1.1083096787E+00, 7.7314765657E-01],
	[1.8955000000E+04, 1.0885540863E+01, 5.3917208011E+00, 1.6015820279E+00, 1.1089952029E+00, 7.7325114728E-01],
	[1.8960000000E+04, 1.0889731753E+01, 5.3915625965E+00, 1.6029355287E+00, 1.1096808285E+00, 7.7335460000E-01],
	[1.8965000000E+04, 1.0893923150E+01, 5.3914044383E+00, 1.6042898153E+00, 1.1103665553E+00, 7.7345801475E-01],
	[1.8970000000E+04, 1.0898115056E+01, 5.3912463265E+00, 1.6056448880E+00, 1.1110523832E+00, 7.7356139153E-01],
	[1.8975000000E+04, 1.0902307469E+01, 5.3910882609E+00, 1.6070007470E+00, 1.1117383119E+00, 7.7366473034E-01],
	[1.8980000000E+04, 1.0906500390E+01, 5.3909302417E+00, 1.6083573926E+00, 1.1124243413E+00, 7.7376803119E-01],
	[1.8985000000E+04, 1.0910693818E+01, 5.3907722686E+00, 1.6097148250E+00, 1.1131104712E+00, 7.7387129409E-01],
	[1.8990000000E+04, 1.0914887753E+01, 5.3906143419E+00, 1.6110730444E+00, 1.1137967014E+00, 7.7397451905E-01],
	[1.8995000000E+04, 1.0919082196E+01, 5.3904564613E+00, 1.6124320512E+00, 1.1144830318E+00, 7.7407770606E-01],
	[1.9000000000E+04, 1.0923277147E+01, 5.3902986268E+00, 1.6137918456E+00, 1.1151694621E+00, 7.7418085514E-01],
	[1.9005000000E+04, 1.0927472604E+01, 5.3901408386E+00, 1.6151524278E+00, 1.1158559921E+00, 7.7428396629E-01],
	[1.9010000000E+04, 1.0931668569E+01, 5.3899830964E+00, 1.6165137981E+00, 1.1165426218E+00, 7.7438703952E-01],
	[1.9015000000E+04, 1.0935865040E+01, 5.3898254004E+00, 1.6178759567E+00, 1.1172293508E+00, 7.7449007484E-01],
	[1.9020000000E+04, 1.0940062019E+01, 5.3896677504E+00, 1.6192389038E+00, 1.1179161791E+00, 7.7459307225E-01],
	[1.9025000000E+04, 1.0944259504E+01, 5.3895101465E+00, 1.6206026397E+00, 1.1186031064E+00, 7.7469603176E-01],
	[1.9030000000E+04, 1.0948457497E+01, 5.3893525886E+00, 1.6219671648E+00, 1.1192901325E+00, 7.7479895337E-01],
	[1.9035000000E+04, 1.0952655996E+01, 5.3891950767E+00, 1.6233324791E+00, 1.1199772573E+00, 7.7490183710E-01],
	[1.9040000000E+04, 1.0956855002E+01, 5.3890376107E+00, 1.6246985830E+00, 1.1206644806E+00, 7.7500468294E-01],
	[1.9045000000E+04, 1.0961054514E+01, 5.3888801907E+00, 1.6260654767E+00, 1.1213518022E+00, 7.7510749091E-01],
	[1.9050000000E+04, 1.0965254534E+01, 5.3887228167E+00, 1.6274331604E+00, 1.1220392219E+00, 7.7521026101E-01],
	[1.9055000000E+04, 1.0969455059E+01, 5.3885654885E+00, 1.6288016344E+00, 1.1227267396E+00, 7.7531299325E-01],
	[1.9060000000E+04, 1.0973656091E+01, 5.3884082062E+00, 1.6301708990E+00, 1.1234143550E+00, 7.7541568763E-01],
	[1.9065000000E+04, 1.0977857630E+01, 5.3882509697E+00, 1.6315409544E+00, 1.1241020680E+00, 7.7551834416E-01],
	[1.9070000000E+04, 1.0982059674E+01, 5.3880937790E+00, 1.6329118009E+00, 1.1247898784E+00, 7.7562096285E-01],
	[1.9075000000E+04, 1.0986262225E+01, 5.3879366342E+00, 1.6342834386E+00, 1.1254777860E+00, 7.7572354371E-01],
	[1.9080000000E+04, 1.0990465282E+01, 5.3877795351E+00, 1.6356558679E+00, 1.1261657906E+00, 7.7582608673E-01],
	[1.9085000000E+04, 1.0994668845E+01, 5.3876224817E+00, 1.6370290890E+00, 1.1268538921E+00, 7.7592859194E-01],
	[1.9090000000E+04, 1.0998872914E+01, 5.3874654741E+00, 1.6384031022E+00, 1.1275420902E+00, 7.7603105933E-01],
	[1.9095000000E+04, 1.1003077489E+01, 5.3873085122E+00, 1.6397779076E+00, 1.1282303848E+00, 7.7613348890E-01],
	[1.9100000000E+04, 1.1007282570E+01, 5.3871515959E+00, 1.6411535055E+00, 1.1289187757E+00, 7.7623588068E-01],
	[1.9105000000E+04, 1.1011488157E+01, 5.3869947253E+00, 1.6425298963E+00, 1.1296072627E+00, 7.7633823466E-01],
	[1.9110000000E+04, 1.1015694249E+01, 5.3868379002E+00, 1.6439070801E+00, 1.1302958456E+00, 7.7644055085E-01],
	[1.9115000000E+04, 1.1019900847E+01, 5.3866811208E+00, 1.6452850572E+00, 1.1309845243E+00, 7.7654282926E-01],
	[1.9120000000E+04, 1.1024107950E+01, 5.3865243870E+00, 1.6466638278E+00, 1.1316732985E+00, 7.7664506990E-01],
	[1.9125000000E+04, 1.1028319392E+01, 5.3863686762E+00, 1.6480433922E+00, 1.1323622517E+00, 7.7674727276E-01],
	[1.9130000000E+04, 1.1032546646E+01, 5.3862169118E+00, 1.6494237506E+00, 1.1330516343E+00, 7.7684943787E-01],
	[1.9135000000E+04, 1.1036774415E+01, 5.3860651913E+00, 1.6508049033E+00, 1.1337411128E+00, 7.7695156521E-01],
	[1.9140000000E+04, 1.1041002699E+01, 5.3859135147E+00, 1.6521868506E+00, 1.1344306868E+00, 7.7705365481E-01],
	[1.9145000000E+04, 1.1045231497E+01, 5.3857618820E+00, 1.6535695926E+00, 1.1351203562E+00, 7.7715570667E-01],
	[1.9150000000E+04, 1.1049460810E+01, 5.3856102932E+00, 1.6549531296E+00, 1.1358101209E+00, 7.7725772080E-01],
	[1.9155000000E+04, 1.1053690638E+01, 5.3854587483E+00, 1.6563374620E+00, 1.1364999806E+00, 7.7735969719E-01],
	[1.9160000000E+04, 1.1057920981E+01, 5.3853072471E+00, 1.6577225898E+00, 1.1371899351E+00, 7.7746163587E-01],
	[1.9165000000E+04, 1.1062151838E+01, 5.3851557897E+00, 1.6591085134E+00, 1.1378799844E+00, 7.7756353683E-01],
	[1.9170000000E+04, 1.1066383210E+01, 5.3850043761E+00, 1.6604952331E+00, 1.1385701282E+00, 7.7766540008E-01],
	[1.9175000000E+04, 1.1070615096E+01, 5.3848530063E+00, 1.6618827490E+00, 1.1392603663E+00, 7.7776722564E-01],
	[1.9180000000E+04, 1.1074847496E+01, 5.3847016801E+00, 1.6632710614E+00, 1.1399506985E+00, 7.7786901350E-01],
	[1.9185000000E+04, 1.1079080411E+01, 5.3845503977E+00, 1.6646601706E+00, 1.1406411247E+00, 7.7797076367E-01],
	[1.9190000000E+04, 1.1083313839E+01, 5.3843991589E+00, 1.6660500769E+00, 1.1413316446E+00, 7.7807247615E-01],
	[1.9195000000E+04, 1.1087547782E+01, 5.3842479638E+00, 1.6674407804E+00, 1.1420222582E+00, 7.7817415086E-01],
	[1.9200000000E+04, 1.1091782239E+01, 5.3840968123E+00, 1.6688322814E+00, 1.1427129651E+00, 7.7827578778E-01],
	[1.9205000000E+04, 1.1096017210E+01, 5.3839457044E+00, 1.6702245801E+00, 1.1434037653E+00, 7.7837738692E-01],
	[1.9210000000E+04, 1.1100252695E+01, 5.3837946400E+00, 1.6716176769E+00, 1.1440946586E+00, 7.7847894828E-01],
	[1.9215000000E+04, 1.1104488694E+01, 5.3836436193E+00, 1.6730115720E+00, 1.1447856447E+00, 7.7858047186E-01],
	[1.9220000000E+04, 1.1108725206E+01, 5.3834926420E+00, 1.6744062655E+00, 1.1454767234E+00, 7.7868195765E-01],
	[1.9225000000E+04, 1.1112962232E+01, 5.3833417083E+00, 1.6758017578E+00, 1.1461678947E+00, 7.7878340567E-01],
	[1.9230000000E+04, 1.1117199772E+01, 5.3831908180E+00, 1.6771980492E+00, 1.1468591583E+00, 7.7888481590E-01],
	[1.9235000000E+04, 1.1121437825E+01, 5.3830399712E+00, 1.6785951398E+00, 1.1475505141E+00, 7.7898618836E-01],
	[1.9240000000E+04, 1.1125676392E+01, 5.3828891678E+00, 1.6799930298E+00, 1.1482419617E+00, 7.7908752304E-01],
	[1.9245000000E+04, 1.1129915472E+01, 5.3827384078E+00, 1.6813917197E+00, 1.1489335012E+00, 7.7918881994E-01],
	[1.9250000000E+04, 1.1134155066E+01, 5.3825876912E+00, 1.6827912096E+00, 1.1496251322E+00, 7.7929007907E-01],
	[1.9255000000E+04, 1.1138395172E+01, 5.3824370180E+00, 1.6841914997E+00, 1.1503168547E+00, 7.7939130042E-01],
	[1.9260000000E+04, 1.1142635792E+01, 5.3822863881E+00, 1.6855925903E+00, 1.1510086684E+00, 7.7949248399E-01],
	[1.9265000000E+04, 1.1146876925E+01, 5.3821358015E+00, 1.6869944816E+00, 1.1517005731E+00, 7.7959362979E-01],
	[1.9270000000E+04, 1.1151118571E+01, 5.3819852582E+00, 1.6883971740E+00, 1.1523925687E+00, 7.7969473782E-01],
	[1.9275000000E+04, 1.1155360730E+01, 5.3818347582E+00, 1.6898006676E+00, 1.1530846549E+00, 7.7979580808E-01],
	[1.9280000000E+04, 1.1159603402E+01, 5.3816843014E+00, 1.6912049627E+00, 1.1537768317E+00, 7.7989684056E-01],
	[1.9285000000E+04, 1.1163846587E+01, 5.3815338879E+00, 1.6926100596E+00, 1.1544690987E+00, 7.7999783527E-01],
	[1.9290000000E+04, 1.1168090285E+01, 5.3813835175E+00, 1.6940159584E+00, 1.1551614559E+00, 7.8009879222E-01],
	[1.9295000000E+04, 1.1172334495E+01, 5.3812331903E+00, 1.6954226596E+00, 1.1558539031E+00, 7.8019971139E-01],
	[1.9300000000E+04, 1.1176579218E+01, 5.3810829062E+00, 1.6968301632E+00, 1.1565464400E+00, 7.8030059280E-01],
	[1.9305000000E+04, 1.1180824454E+01, 5.3809326653E+00, 1.6982384695E+00, 1.1572390665E+00, 7.8040143645E-01],
	[1.9310000000E+04, 1.1185070201E+01, 5.3807824675E+00, 1.6996475788E+00, 1.1579317824E+00, 7.8050224232E-01],
	[1.9315000000E+04, 1.1189316462E+01, 5.3806323127E+00, 1.7010574914E+00, 1.1586245875E+00, 7.8060301044E-01],
	[1.9320000000E+04, 1.1193563234E+01, 5.3804822010E+00, 1.7024682075E+00, 1.1593174817E+00, 7.8070374079E-01],
	[1.9325000000E+04, 1.1197810519E+01, 5.3803321324E+00, 1.7038797273E+00, 1.1600104647E+00, 7.8080443338E-01],
	[1.9330000000E+04, 1.1202058317E+01, 5.3801821067E+00, 1.7052920511E+00, 1.1607035364E+00, 7.8090508821E-01],
	[1.9335000000E+04, 1.1206306626E+01, 5.3800321240E+00, 1.7067051792E+00, 1.1613966965E+00, 7.8100570528E-01],
	[1.9340000000E+04, 1.1210555447E+01, 5.3798821843E+00, 1.7081191117E+00, 1.1620899450E+00, 7.8110628459E-01],
	[1.9345000000E+04, 1.1214804780E+01, 5.3797322876E+00, 1.7095338490E+00, 1.1627832817E+00, 7.8120682615E-01],
	[1.9350000000E+04, 1.1219054626E+01, 5.3795824337E+00, 1.7109493912E+00, 1.1634767062E+00, 7.8130732995E-01],
	[1.9355000000E+04, 1.1223304983E+01, 5.3794326227E+00, 1.7123657387E+00, 1.1641702186E+00, 7.8140779599E-01],
	[1.9360000000E+04, 1.1227555852E+01, 5.3792828546E+00, 1.7137828917E+00, 1.1648638185E+00, 7.8150822429E-01],
	[1.9365000000E+04, 1.1231807232E+01, 5.3791331293E+00, 1.7152008504E+00, 1.1655575058E+00, 7.8160861483E-01],
	[1.9370000000E+04, 1.1236059124E+01, 5.3789834469E+00, 1.7166196151E+00, 1.1662512803E+00, 7.8170896763E-01],
	[1.9375000000E+04, 1.1240311528E+01, 5.3788338072E+00, 1.7180391861E+00, 1.1669451419E+00, 7.8180928267E-01],
	[1.9380000000E+04, 1.1244564443E+01, 5.3786842103E+00, 1.7194595635E+00, 1.1676390903E+00, 7.8190955997E-01],
	[1.9385000000E+04, 1.1248817870E+01, 5.3785346562E+00, 1.7208807477E+00, 1.1683331254E+00, 7.8200979952E-01],
	[1.9390000000E+04, 1.1253071808E+01, 5.3783851448E+00, 1.7223027388E+00, 1.1690272470E+00, 7.8211000134E-01],
	[1.9395000000E+04, 1.1257326257E+01, 5.3782356761E+00, 1.7237255372E+00, 1.1697214549E+00, 7.8221016540E-01],
	[1.9400000000E+04, 1.1261581218E+01, 5.3780862501E+00, 1.7251491430E+00, 1.1704157489E+00, 7.8231029173E-01],
	[1.9405000000E+04, 1.1265836689E+01, 5.3779368667E+00, 1.7265735566E+00, 1.1711101289E+00, 7.8241038032E-01],
	[1.9410000000E+04, 1.1270092672E+01, 5.3777875260E+00, 1.7279987781E+00, 1.1718045946E+00, 7.8251043117E-01],
	[1.9415000000E+04, 1.1274349166E+01, 5.3776382279E+00, 1.7294248079E+00, 1.1724991459E+00, 7.8261044429E-01],
	[1.9420000000E+04, 1.1278606170E+01, 5.3774889723E+00, 1.7308516462E+00, 1.1731937826E+00, 7.8271041967E-01],
	[1.9425000000E+04, 1.1282863686E+01, 5.3773397594E+00, 1.7322792932E+00, 1.1738885045E+00, 7.8281035732E-01],
	[1.9430000000E+04, 1.1287121712E+01, 5.3771905890E+00, 1.7337077491E+00, 1.1745833115E+00, 7.8291025724E-01],
	[1.9435000000E+04, 1.1291392505E+01, 5.3770444799E+00, 1.7351370143E+00, 1.1752784803E+00, 7.8301011943E-01],
	[1.9440000000E+04, 1.1295671130E+01, 5.3769002135E+00, 1.7365670890E+00, 1.1759738997E+00, 7.8310994390E-01],
	[1.9445000000E+04, 1.1299950275E+01, 5.3767559881E+00, 1.7379979734E+00, 1.1766694044E+00, 7.8320973064E-01],
	[1.9450000000E+04, 1.1304229940E+01, 5.3766118036E+00, 1.7394296678E+00, 1.1773649942E+00, 7.8330947966E-01],
	[1.9455000000E+04, 1.1308510126E+01, 5.3764676600E+00, 1.7408621724E+00, 1.1780606689E+00, 7.8340919095E-01],
	[1.9460000000E+04, 1.1312790832E+01, 5.3763235574E+00, 1.7422954874E+00, 1.1787564283E+00, 7.8350886453E-01],
	[1.9465000000E+04, 1.1317072058E+01, 5.3761794956E+00, 1.7437296132E+00, 1.1794522723E+00, 7.8360850039E-01],
	[1.9470000000E+04, 1.1321353804E+01, 5.3760354747E+00, 1.7451645500E+00, 1.1801482007E+00, 7.8370809853E-01],
	[1.9475000000E+04, 1.1325636069E+01, 5.3758914947E+00, 1.7466002980E+00, 1.1808442132E+00, 7.8380765896E-01],
	[1.9480000000E+04, 1.1329918855E+01, 5.3757475554E+00, 1.7480368574E+00, 1.1815403097E+00, 7.8390718168E-01],
	[1.9485000000E+04, 1.1334202160E+01, 5.3756036570E+00, 1.7494742286E+00, 1.1822364901E+00, 7.8400666669E-01],
	[1.9490000000E+04, 1.1338485985E+01, 5.3754597993E+00, 1.7509124118E+00, 1.1829327541E+00, 7.8410611399E-01],
	[1.9495000000E+04, 1.1342770330E+01, 5.3753159824E+00, 1.7523514071E+00, 1.1836291016E+00, 7.8420552359E-01],
	[1.9500000000E+04, 1.1347055194E+01, 5.3751722062E+00, 1.7537912150E+00, 1.1843255323E+00, 7.8430489548E-01],
	[1.9505000000E+04, 1.1351340578E+01, 5.3750284707E+00, 1.7552318356E+00, 1.1850220462E+00, 7.8440422968E-01],
	[1.9510000000E+04, 1.1355626481E+01, 5.3748847759E+00, 1.7566732691E+00, 1.1857186429E+00, 7.8450352617E-01],
	[1.9515000000E+04, 1.1359912904E+01, 5.3747411217E+00, 1.7581155158E+00, 1.1864153224E+00, 7.8460278497E-01],
	[1.9520000000E+04, 1.1364199846E+01, 5.3745975082E+00, 1.7595585761E+00, 1.1871120845E+00, 7.8470200607E-01],
	[1.9525000000E+04, 1.1368487307E+01, 5.3744539353E+00, 1.7610024500E+00, 1.1878089289E+00, 7.8480118948E-01],
	[1.9530000000E+04, 1.1372775287E+01, 5.3743104030E+00, 1.7624471379E+00, 1.1885058556E+00, 7.8490033520E-01],
	[1.9535000000E+04, 1.1377063786E+01, 5.3741669113E+00, 1.7638926400E+00, 1.1892028642E+00, 7.8499944323E-01],
	[1.9540000000E+04, 1.1381352804E+01, 5.3740234601E+00, 1.7653389566E+00, 1.1898999547E+00, 7.8509851358E-01],
	[1.9545000000E+04, 1.1385642342E+01, 5.3738800494E+00, 1.7667860879E+00, 1.1905971268E+00, 7.8519754624E-01],
	[1.9550000000E+04, 1.1389932398E+01, 5.3737366793E+00, 1.7682340342E+00, 1.1912943804E+00, 7.8529654123E-01],
	[1.9555000000E+04, 1.1394222972E+01, 5.3735933496E+00, 1.7696827957E+00, 1.1919917153E+00, 7.8539549853E-01],
	[1.9560000000E+04, 1.1398514066E+01, 5.3734500605E+00, 1.7711323727E+00, 1.1926891313E+00, 7.8549441816E-01],
	[1.9565000000E+04, 1.1402805678E+01, 5.3733068117E+00, 1.7725827654E+00, 1.1933866282E+00, 7.8559330012E-01],
	[1.9570000000E+04, 1.1407097809E+01, 5.3731636034E+00, 1.7740339740E+00, 1.1940842058E+00, 7.8569214440E-01],
	[1.9575000000E+04, 1.1411390458E+01, 5.3730204355E+00, 1.7754859989E+00, 1.1947818641E+00, 7.8579095102E-01],
	[1.9580000000E+04, 1.1415683626E+01, 5.3728773079E+00, 1.7769388402E+00, 1.1954796027E+00, 7.8588971997E-01],
	[1.9585000000E+04, 1.1419977312E+01, 5.3727342207E+00, 1.7783924982E+00, 1.1961774215E+00, 7.8598845125E-01],
	[1.9590000000E+04, 1.1424271517E+01, 5.3725911739E+00, 1.7798469732E+00, 1.1968753203E+00, 7.8608714488E-01],
	[1.9595000000E+04, 1.1428566239E+01, 5.3724481673E+00, 1.7813022655E+00, 1.1975732989E+00, 7.8618580085E-01],
	[1.9600000000E+04, 1.1432861480E+01, 5.3723052011E+00, 1.7827583751E+00, 1.1982713573E+00, 7.8628441916E-01],
	[1.9605000000E+04, 1.1437157239E+01, 5.3721622751E+00, 1.7842153026E+00, 1.1989694951E+00, 7.8638299982E-01],
	[1.9610000000E+04, 1.1441453516E+01, 5.3720193893E+00, 1.7856730479E+00, 1.1996677122E+00, 7.8648154283E-01],
	[1.9615000000E+04, 1.1445750311E+01, 5.3718765438E+00, 1.7871316115E+00, 1.2003660084E+00, 7.8658004819E-01],
	[1.9620000000E+04, 1.1450047624E+01, 5.3717337385E+00, 1.7885909936E+00, 1.2010643835E+00, 7.8667851590E-01],
	[1.9625000000E+04, 1.1454345454E+01, 5.3715909734E+00, 1.7900511943E+00, 1.2017628374E+00, 7.8677694597E-01],
	[1.9630000000E+04, 1.1458643803E+01, 5.3714482484E+00, 1.7915122140E+00, 1.2024613699E+00, 7.8687533841E-01],
	[1.9635000000E+04, 1.1462942669E+01, 5.3713055636E+00, 1.7929740530E+00, 1.2031599808E+00, 7.8697369320E-01],
	[1.9640000000E+04, 1.1467242052E+01, 5.3711629189E+00, 1.7944367114E+00, 1.2038586698E+00, 7.8707201037E-01],
	[1.9645000000E+04, 1.1471541953E+01, 5.3710203143E+00, 1.7959001895E+00, 1.2045574370E+00, 7.8717028990E-01],
	[1.9650000000E+04, 1.1475842372E+01, 5.3708777498E+00, 1.7973644876E+00, 1.2052562819E+00, 7.8726853180E-01],
	[1.9655000000E+04, 1.1480143308E+01, 5.3707352253E+00, 1.7988296059E+00, 1.2059552045E+00, 7.8736673608E-01],
	[1.9660000000E+04, 1.1484444761E+01, 5.3705927409E+00, 1.8002955447E+00, 1.2066542047E+00, 7.8746490273E-01],
	[1.9665000000E+04, 1.1488746732E+01, 5.3704502964E+00, 1.8017623041E+00, 1.2073532821E+00, 7.8756303177E-01],
	[1.9670000000E+04, 1.1493049220E+01, 5.3703078920E+00, 1.8032298846E+00, 1.2080524366E+00, 7.8766112319E-01],
	[1.9675000000E+04, 1.1497352225E+01, 5.3701655275E+00, 1.8046982862E+00, 1.2087516681E+00, 7.8775917699E-01],
	[1.9680000000E+04, 1.1501655747E+01, 5.3700232030E+00, 1.8061675094E+00, 1.2094509764E+00, 7.8785719318E-01],
	[1.9685000000E+04, 1.1505959786E+01, 5.3698809184E+00, 1.8076375542E+00, 1.2101503613E+00, 7.8795517177E-01],
	[1.9690000000E+04, 1.1510264342E+01, 5.3697386737E+00, 1.8091084210E+00, 1.2108498225E+00, 7.8805311275E-01],
	[1.9695000000E+04, 1.1514569414E+01, 5.3695964689E+00, 1.8105801100E+00, 1.2115493600E+00, 7.8815101613E-01],
	[1.9700000000E+04, 1.1518875004E+01, 5.3694543039E+00, 1.8120526215E+00, 1.2122489735E+00, 7.8824888191E-01],
	[1.9705000000E+04, 1.1523181110E+01, 5.3693121788E+00, 1.8135259557E+00, 1.2129486629E+00, 7.8834671010E-01],
	[1.9710000000E+04, 1.1527487733E+01, 5.3691700935E+00, 1.8150001129E+00, 1.2136484280E+00, 7.8844450069E-01],
	[1.9715000000E+04, 1.1531794872E+01, 5.3690280480E+00, 1.8164750932E+00, 1.2143482685E+00, 7.8854225370E-01],
	[1.9720000000E+04, 1.1536102528E+01, 5.3688860423E+00, 1.8179508971E+00, 1.2150481844E+00, 7.8863996912E-01],
	[1.9725000000E+04, 1.1540410701E+01, 5.3687440763E+00, 1.8194275246E+00, 1.2157481755E+00, 7.8873764695E-01],
	[1.9730000000E+04, 1.1544719389E+01, 5.3686021501E+00, 1.8209049762E+00, 1.2164482414E+00, 7.8883528721E-01],
	[1.9735000000E+04, 1.1549028594E+01, 5.3684602636E+00, 1.8223832519E+00, 1.2171483822E+00, 7.8893288989E-01],
	[1.9740000000E+04, 1.1553338315E+01, 5.3683184168E+00, 1.8238623521E+00, 1.2178485976E+00, 7.8903045500E-01],
	[1.9745000000E+04, 1.1557649772E+01, 5.3681768999E+00, 1.8253422770E+00, 1.2185489159E+00, 7.8912798253E-01],
	[1.9750000000E+04, 1.1561980538E+01, 5.3680398944E+00, 1.8268230269E+00, 1.2192497481E+00, 7.8922547250E-01],
	[1.9755000000E+04, 1.1566311830E+01, 5.3679029270E+00, 1.8283046020E+00, 1.2199506553E+00, 7.8932292491E-01],
	[1.9760000000E+04, 1.1570643648E+01, 5.3677659978E+00, 1.8297870026E+00, 1.2206516371E+00, 7.8942033976E-01],
	[1.9765000000E+04, 1.1574975992E+01, 5.3676291067E+00, 1.8312702289E+00, 1.2213526934E+00, 7.8951771705E-01],
	[1.9770000000E+04, 1.1579308861E+01, 5.3674922537E+00, 1.8327542811E+00, 1.2220538240E+00, 7.8961505679E-01],
	[1.9775000000E+04, 1.1583642256E+01, 5.3673554388E+00, 1.8342391596E+00, 1.2227550288E+00, 7.8971235898E-01],
	[1.9780000000E+04, 1.1587976177E+01, 5.3672186620E+00, 1.8357248646E+00, 1.2234563075E+00, 7.8980962363E-01],
	[1.9785000000E+04, 1.1592310623E+01, 5.3670819233E+00, 1.8372113962E+00, 1.2241576600E+00, 7.8990685073E-01],
	[1.9790000000E+04, 1.1596645594E+01, 5.3669452226E+00, 1.8386987548E+00, 1.2248590862E+00, 7.9000404029E-01],
	[1.9795000000E+04, 1.1600981091E+01, 5.3668085599E+00, 1.8401869407E+00, 1.2255605857E+00, 7.9010119232E-01],
	[1.9800000000E+04, 1.1605317113E+01, 5.3666719352E+00, 1.8416759540E+00, 1.2262621585E+00, 7.9019830682E-01],
	[1.9805000000E+04, 1.1609653660E+01, 5.3665353484E+00, 1.8431657951E+00, 1.2269638044E+00, 7.9029538378E-01],
	[1.9810000000E+04, 1.1613990733E+01, 5.3663987997E+00, 1.8446564641E+00, 1.2276655231E+00, 7.9039242323E-01],
	[1.9815000000E+04, 1.1618328330E+01, 5.3662622888E+00, 1.8461479613E+00, 1.2283673145E+00, 7.9048942515E-01],
	[1.9820000000E+04, 1.1622666453E+01, 5.3661258159E+00, 1.8476402870E+00, 1.2290691785E+00, 7.9058638955E-01],
	[1.9825000000E+04, 1.1627005100E+01, 5.3659893808E+00, 1.8491334414E+00, 1.2297711148E+00, 7.9068331644E-01],
	[1.9830000000E+04, 1.1631344272E+01, 5.3658529837E+00, 1.8506274248E+00, 1.2304731233E+00, 7.9078020582E-01],
	[1.9835000000E+04, 1.1635683970E+01, 5.3657166244E+00, 1.8521222374E+00, 1.2311752038E+00, 7.9087705770E-01],
	[1.9840000000E+04, 1.1640024191E+01, 5.3655803029E+00, 1.8536178795E+00, 1.2318773560E+00, 7.9097387207E-01],
	[1.9845000000E+04, 1.1644364938E+01, 5.3654440192E+00, 1.8551143513E+00, 1.2325795799E+00, 7.9107064894E-01],
	[1.9850000000E+04, 1.1648706209E+01, 5.3653077733E+00, 1.8566116531E+00, 1.2332818753E+00, 7.9116738832E-01],
	[1.9855000000E+04, 1.1653048005E+01, 5.3651715652E+00, 1.8581097851E+00, 1.2339842419E+00, 7.9126409021E-01],
	[1.9860000000E+04, 1.1657390325E+01, 5.3650353949E+00, 1.8596087476E+00, 1.2346866796E+00, 7.9136075461E-01],
	[1.9865000000E+04, 1.1661733169E+01, 5.3648992623E+00, 1.8611085408E+00, 1.2353891882E+00, 7.9145738153E-01],
	[1.9870000000E+04, 1.1666076538E+01, 5.3647631674E+00, 1.8626091650E+00, 1.2360917676E+00, 7.9155397096E-01],
	[1.9875000000E+04, 1.1670420431E+01, 5.3646271102E+00, 1.8641106204E+00, 1.2367944175E+00, 7.9165052292E-01],
	[1.9880000000E+04, 1.1674764848E+01, 5.3644910906E+00, 1.8656129073E+00, 1.2374971377E+00, 7.9174703741E-01],
	[1.9885000000E+04, 1.1679109790E+01, 5.3643551088E+00, 1.8671160259E+00, 1.2381999282E+00, 7.9184351443E-01],
	[1.9890000000E+04, 1.1683455255E+01, 5.3642191645E+00, 1.8686199765E+00, 1.2389027886E+00, 7.9193995399E-01],
	[1.9895000000E+04, 1.1687801245E+01, 5.3640832579E+00, 1.8701247593E+00, 1.2396057189E+00, 7.9203635609E-01],
	[1.9900000000E+04, 1.1692147758E+01, 5.3639473888E+00, 1.8716303746E+00, 1.2403087189E+00, 7.9213272073E-01],
	[1.9905000000E+04, 1.1696494795E+01, 5.3638115574E+00, 1.8731368227E+00, 1.2410117883E+00, 7.9222904792E-01],
	[1.9910000000E+04, 1.1700842356E+01, 5.3636757635E+00, 1.8746441037E+00, 1.2417149271E+00, 7.9232533766E-01],
	[1.9915000000E+04, 1.1705190441E+01, 5.3635400071E+00, 1.8761522179E+00, 1.2424181349E+00, 7.9242158996E-01],
	[1.9920000000E+04, 1.1709539049E+01, 5.3634042882E+00, 1.8776611656E+00, 1.2431214117E+00, 7.9251780482E-01],
	[1.9925000000E+04, 1.1713888181E+01, 5.3632686068E+00, 1.8791709471E+00, 1.2438247572E+00, 7.9261398223E-01],
	[1.9930000000E+04, 1.1718237836E+01, 5.3631329630E+00, 1.8806815625E+00, 1.2445281713E+00, 7.9271012222E-01],
	[1.9935000000E+04, 1.1722588015E+01, 5.3629973565E+00, 1.8821930122E+00, 1.2452316538E+00, 7.9280622476E-01],
	[1.9940000000E+04, 1.1726938717E+01, 5.3628617875E+00, 1.8837052963E+00, 1.2459352046E+00, 7.9290228988E-01],
	[1.9945000000E+04, 1.1731289942E+01, 5.3627262559E+00, 1.8852184152E+00, 1.2466388233E+00, 7.9299831758E-01],
	[1.9950000000E+04, 1.1735641691E+01, 5.3625907617E+00, 1.8867323691E+00, 1.2473425100E+00, 7.9309430784E-01],
	[1.9955000000E+04, 1.1739993963E+01, 5.3624553049E+00, 1.8882471582E+00, 1.2480462643E+00, 7.9319026069E-01],
	[1.9960000000E+04, 1.1744346757E+01, 5.3623198854E+00, 1.8897627828E+00, 1.2487500861E+00, 7.9328617611E-01],
	[1.9965000000E+04, 1.1748700075E+01, 5.3621845033E+00, 1.8912792431E+00, 1.2494539752E+00, 7.9338205413E-01],
	[1.9970000000E+04, 1.1753053916E+01, 5.3620491585E+00, 1.8927965395E+00, 1.2501579315E+00, 7.9347789472E-01],
	[1.9975000000E+04, 1.1757408280E+01, 5.3619138510E+00, 1.8943146720E+00, 1.2508619548E+00, 7.9357369791E-01],
	[1.9980000000E+04, 1.1761763166E+01, 5.3617785808E+00, 1.8958336411E+00, 1.2515660449E+00, 7.9366946369E-01],
	[1.9985000000E+04, 1.1766118576E+01, 5.3616433478E+00, 1.8973534469E+00, 1.2522702015E+00, 7.9376519207E-01],
	[1.9990000000E+04, 1.1770474508E+01, 5.3615081521E+00, 1.8988740896E+00, 1.2529744246E+00, 7.9386088305E-01],
	[1.9995000000E+04, 1.1774830962E+01, 5.3613729936E+00, 1.9003955697E+00, 1.2536787139E+00, 7.9395653663E-01],
	[2.0000000000E+04, 1.1779187939E+01, 5.3612378723E+00, 1.9019178872E+00, 1.2543830694E+00, 7.9405215281E-01],
	[2.0005000000E+04, 1.1783545439E+01, 5.3611027881E+00, 1.9034433631E+00, 1.2550884996E+00, 7.9414773161E-01],
	[2.0010000000E+04, 1.1787903461E+01, 5.3609677411E+00, 1.9049696802E+00, 1.2557939961E+00, 7.9424327301E-01],
	[2.0015000000E+04, 1.1792262005E+01, 5.3608327313E+00, 1.9064968388E+00, 1.2564995585E+00, 7.9433877703E-01],
	[2.0020000000E+04, 1.1796621072E+01, 5.3606977586E+00, 1.9080248392E+00, 1.2572051867E+00, 7.9443424367E-01],
	[2.0025000000E+04, 1.1800980661E+01, 5.3605628230E+00, 1.9095536815E+00, 1.2579108805E+00, 7.9452967293E-01],
	[2.0030000000E+04, 1.1805340772E+01, 5.3604279245E+00, 1.9110833661E+00, 1.2586166398E+00, 7.9462506482E-01],
	[2.0035000000E+04, 1.1809701405E+01, 5.3602930630E+00, 1.9126138932E+00, 1.2593224643E+00, 7.9472041933E-01],
	[2.0040000000E+04, 1.1814062560E+01, 5.3601582386E+00, 1.9141452631E+00, 1.2600283539E+00, 7.9481573648E-01],
	[2.0045000000E+04, 1.1818424237E+01, 5.3600234512E+00, 1.9156774759E+00, 1.2607343084E+00, 7.9491101626E-01],
	[2.0050000000E+04, 1.1822786436E+01, 5.3598887008E+00, 1.9172105320E+00, 1.2614403277E+00, 7.9500625867E-01],
	[2.0055000000E+04, 1.1827149156E+01, 5.3597539874E+00, 1.9187444317E+00, 1.2621464114E+00, 7.9510146373E-01],
	[2.0060000000E+04, 1.1831512399E+01, 5.3596193110E+00, 1.9202791750E+00, 1.2628525596E+00, 7.9519663143E-01],
	[2.0065000000E+04, 1.1835886120E+01, 5.3594869679E+00, 1.9218147624E+00, 1.2635590130E+00, 7.9529176179E-01],
	[2.0070000000E+04, 1.1840270800E+01, 5.3593570662E+00, 1.9233511941E+00, 1.2642657837E+00, 7.9538685479E-01],
	[2.0075000000E+04, 1.1844656012E+01, 5.3592271999E+00, 1.9248884703E+00, 1.2649726190E+00, 7.9548191045E-01],
	[2.0080000000E+04, 1.1849041755E+01, 5.3590973691E+00, 1.9264265913E+00, 1.2656795187E+00, 7.9557692876E-01],
	[2.0085000000E+04, 1.1853428029E+01, 5.3589675738E+00, 1.9279655573E+00, 1.2663864828E+00, 7.9567190974E-01],
	[2.0090000000E+04, 1.1857814835E+01, 5.3588378140E+00, 1.9295053686E+00, 1.2670935110E+00, 7.9576685339E-01],
	[2.0095000000E+04, 1.1862202172E+01, 5.3587080896E+00, 1.9310460254E+00, 1.2678006031E+00, 7.9586175970E-01],
	[2.0100000000E+04, 1.1866590040E+01, 5.3585784006E+00, 1.9325875281E+00, 1.2685077589E+00, 7.9595662869E-01],
	[2.0105000000E+04, 1.1870978439E+01, 5.3584487470E+00, 1.9341298767E+00, 1.2692149784E+00, 7.9605146035E-01],
	[2.0110000000E+04, 1.1875367369E+01, 5.3583191287E+00, 1.9356730717E+00, 1.2699222612E+00, 7.9614625469E-01],
	[2.0115000000E+04, 1.1879756831E+01, 5.3581895458E+00, 1.9372171132E+00, 1.2706296073E+00, 7.9624101172E-01],
	[2.0120000000E+04, 1.1884146823E+01, 5.3580599983E+00, 1.9387620015E+00, 1.2713370164E+00, 7.9633573144E-01],
	[2.0125000000E+04, 1.1888537346E+01, 5.3579304861E+00, 1.9403077369E+00, 1.2720444884E+00, 7.9643041384E-01],
	[2.0130000000E+04, 1.1892928400E+01, 5.3578010092E+00, 1.9418543196E+00, 1.2727520230E+00, 7.9652505894E-01],
	[2.0135000000E+04, 1.1897319984E+01, 5.3576715676E+00, 1.9434017498E+00, 1.2734596202E+00, 7.9661966674E-01],
	[2.0140000000E+04, 1.1901712099E+01, 5.3575421612E+00, 1.9449500279E+00, 1.2741672797E+00, 7.9671423724E-01],
	[2.0145000000E+04, 1.1906104745E+01, 5.3574127901E+00, 1.9464991540E+00, 1.2748750013E+00, 7.9680877045E-01],
	[2.0150000000E+04, 1.1910497921E+01, 5.3572834542E+00, 1.9480491285E+00, 1.2755827850E+00, 7.9690326637E-01],
	[2.0155000000E+04, 1.1914891628E+01, 5.3571541535E+00, 1.9495999515E+00, 1.2762906304E+00, 7.9699772500E-01],
	[2.0160000000E+04, 1.1919285864E+01, 5.3570248880E+00, 1.9511516233E+00, 1.2769985374E+00, 7.9709214635E-01],
	[2.0165000000E+04, 1.1923680632E+01, 5.3568956577E+00, 1.9527041443E+00, 1.2777065059E+00, 7.9718653043E-01],
	[2.0170000000E+04, 1.1928075929E+01, 5.3567664626E+00, 1.9542575146E+00, 1.2784145356E+00, 7.9728087722E-01],
	[2.0175000000E+04, 1.1932471757E+01, 5.3566373025E+00, 1.9558117344E+00, 1.2791226264E+00, 7.9737518675E-01],
	[2.0180000000E+04, 1.1936868115E+01, 5.3565081776E+00, 1.9573668042E+00, 1.2798307782E+00, 7.9746945901E-01],
	[2.0185000000E+04, 1.1941265002E+01, 5.3563790878E+00, 1.9589227240E+00, 1.2805389906E+00, 7.9756369401E-01],
	[2.0190000000E+04, 1.1945662420E+01, 5.3562500331E+00, 1.9604794941E+00, 1.2812472636E+00, 7.9765789175E-01],
	[2.0195000000E+04, 1.1950060368E+01, 5.3561210135E+00, 1.9620371149E+00, 1.2819555970E+00, 7.9775205223E-01],
	[2.0200000000E+04, 1.1954458845E+01, 5.3559920289E+00, 1.9635955865E+00, 1.2826639905E+00, 7.9784617547E-01],
	[2.0205000000E+04, 1.1958857852E+01, 5.3558630793E+00, 1.9651549092E+00, 1.2833724441E+00, 7.9794026146E-01],
	[2.0210000000E+04, 1.1963257389E+01, 5.3557341647E+00, 1.9667150833E+00, 1.2840809575E+00, 7.9803431020E-01],
	[2.0215000000E+04, 1.1967657456E+01, 5.3556052851E+00, 1.9682761091E+00, 1.2847895306E+00, 7.9812832171E-01],
	[2.0220000000E+04, 1.1972058052E+01, 5.3554764405E+00, 1.9698379866E+00, 1.2854981631E+00, 7.9822229599E-01],
	[2.0225000000E+04, 1.1976459177E+01, 5.3553476309E+00, 1.9714007164E+00, 1.2862068550E+00, 7.9831623303E-01],
	[2.0230000000E+04, 1.1980860832E+01, 5.3552188562E+00, 1.9729642984E+00, 1.2869156060E+00, 7.9841013285E-01],
	[2.0235000000E+04, 1.1985263017E+01, 5.3550901164E+00, 1.9745287332E+00, 1.2876244159E+00, 7.9850399545E-01],
	[2.0240000000E+04, 1.1989665730E+01, 5.3549614115E+00, 1.9760940208E+00, 1.2883332846E+00, 7.9859782083E-01],
	[2.0245000000E+04, 1.1994068973E+01, 5.3548327415E+00, 1.9776601615E+00, 1.2890422119E+00, 7.9869160900E-01],
	[2.0250000000E+04, 1.1998472745E+01, 5.3547041063E+00, 1.9792271557E+00, 1.2897511976E+00, 7.9878535996E-01],
	[2.0255000000E+04, 1.2002877046E+01, 5.3545755060E+00, 1.9807950034E+00, 1.2904602415E+00, 7.9887907371E-01],
	[2.0260000000E+04, 1.2007281876E+01, 5.3544469406E+00, 1.9823637051E+00, 1.2911693435E+00, 7.9897275027E-01],
	[2.0265000000E+04, 1.2011687235E+01, 5.3543184099E+00, 1.9839332610E+00, 1.2918785034E+00, 7.9906638963E-01],
	[2.0270000000E+04, 1.2016093123E+01, 5.3541899141E+00, 1.9855036712E+00, 1.2925877210E+00, 7.9915999180E-01],
	[2.0275000000E+04, 1.2020499540E+01, 5.3540614530E+00, 1.9870749361E+00, 1.2932969961E+00, 7.9925355678E-01],
	[2.0280000000E+04, 1.2024906485E+01, 5.3539330266E+00, 1.9886470559E+00, 1.2940063286E+00, 7.9934708458E-01],
	[2.0285000000E+04, 1.2029313959E+01, 5.3538046350E+00, 1.9902200309E+00, 1.2947157183E+00, 7.9944057520E-01],
	[2.0290000000E+04, 1.2033721962E+01, 5.3536762782E+00, 1.9917938613E+00, 1.2954251649E+00, 7.9953402865E-01],
	[2.0295000000E+04, 1.2038130493E+01, 5.3535479560E+00, 1.9933685474E+00, 1.2961346684E+00, 7.9962744493E-01],
	[2.0300000000E+04, 1.2042539553E+01, 5.3534196685E+00, 1.9949440894E+00, 1.2968442285E+00, 7.9972082405E-01],
	[2.0305000000E+04, 1.2046949141E+01, 5.3532914157E+00, 1.9965204876E+00, 1.2975538450E+00, 7.9981416600E-01],
	[2.0310000000E+04, 1.2051359258E+01, 5.3531631975E+00, 1.9980977423E+00, 1.2982635179E+00, 7.9990747080E-01],
	[2.0315000000E+04, 1.2055769903E+01, 5.3530350140E+00, 1.9996758536E+00, 1.2989732468E+00, 8.0000073845E-01],
	[2.0320000000E+04, 1.2060181076E+01, 5.3529068651E+00, 2.0012548219E+00, 1.2996830317E+00, 8.0009396895E-01],
	[2.0325000000E+04, 1.2064592777E+01, 5.3527787507E+00, 2.0028346474E+00, 1.3003928724E+00, 8.0018716231E-01],
	[2.0330000000E+04, 1.2069005006E+01, 5.3526506710E+00, 2.0044153303E+00, 1.3011027686E+00, 8.0028031854E-01],
	[2.0335000000E+04, 1.2073417764E+01, 5.3525226258E+00, 2.0059968709E+00, 1.3018127203E+00, 8.0037343763E-01],
	[2.0340000000E+04, 1.2077831049E+01, 5.3523946151E+00, 2.0075792695E+00, 1.3025227271E+00, 8.0046651959E-01],
	[2.0345000000E+04, 1.2082244862E+01, 5.3522666390E+00, 2.0091625263E+00, 1.3032327890E+00, 8.0055956444E-01],
	[2.0350000000E+04, 1.2086659203E+01, 5.3521386974E+00, 2.0107466416E+00, 1.3039429058E+00, 8.0065257216E-01],
	[2.0355000000E+04, 1.2091074072E+01, 5.3520107903E+00, 2.0123316155E+00, 1.3046530773E+00, 8.0074554277E-01],
	[2.0360000000E+04, 1.2095489468E+01, 5.3518829176E+00, 2.0139174485E+00, 1.3053633033E+00, 8.0083847627E-01],
	[2.0365000000E+04, 1.2099905392E+01, 5.3517550794E+00, 2.0155041407E+00, 1.3060735836E+00, 8.0093137267E-01],
	[2.0370000000E+04, 1.2104321844E+01, 5.3516272756E+00, 2.0170916924E+00, 1.3067839181E+00, 8.0102423197E-01],
	[2.0375000000E+04, 1.2108738823E+01, 5.3514995063E+00, 2.0186801038E+00, 1.3074943066E+00, 8.0111705417E-01],
	[2.0380000000E+04, 1.2113156329E+01, 5.3513717713E+00, 2.0202693752E+00, 1.3082047489E+00, 8.0120983928E-01],
	[2.0385000000E+04, 1.2117574363E+01, 5.3512440708E+00, 2.0218595068E+00, 1.3089152448E+00, 8.0130258731E-01],
	[2.0390000000E+04, 1.2122011318E+01, 5.3511205404E+00, 2.0234504990E+00, 1.3096262566E+00, 8.0139529827E-01],
	[2.0395000000E+04, 1.2126451027E+01, 5.3509975415E+00, 2.0250423519E+00, 1.3103373782E+00, 8.0148797214E-01],
	[2.0400000000E+04, 1.2130891273E+01, 5.3508745756E+00, 2.0266350658E+00, 1.3110485538E+00, 8.0158060895E-01],
	[2.0405000000E+04, 1.2135332057E+01, 5.3507516427E+00, 2.0282286409E+00, 1.3117597831E+00, 8.0167320869E-01],
	[2.0410000000E+04, 1.2139773377E+01, 5.3506287428E+00, 2.0298230776E+00, 1.3124710660E+00, 8.0176577137E-01],
	[2.0415000000E+04, 1.2144215234E+01, 5.3505058757E+00, 2.0314183761E+00, 1.3131824023E+00, 8.0185829700E-01],
	[2.0420000000E+04, 1.2148657628E+01, 5.3503830416E+00, 2.0330145365E+00, 1.3138937919E+00, 8.0195078557E-01],
	[2.0425000000E+04, 1.2153100559E+01, 5.3502602404E+00, 2.0346115593E+00, 1.3146052345E+00, 8.0204323711E-01],
	[2.0430000000E+04, 1.2157544027E+01, 5.3501374720E+00, 2.0362094445E+00, 1.3153167300E+00, 8.0213565160E-01],
	[2.0435000000E+04, 1.2161988032E+01, 5.3500147365E+00, 2.0378081926E+00, 1.3160282782E+00, 8.0222802906E-01],
	[2.0440000000E+04, 1.2166432573E+01, 5.3498920338E+00, 2.0394078037E+00, 1.3167398789E+00, 8.0232036949E-01],
	[2.0445000000E+04, 1.2170877650E+01, 5.3497693640E+00, 2.0410082781E+00, 1.3174515320E+00, 8.0241267289E-01],
	[2.0450000000E+04, 1.2175323265E+01, 5.3496467270E+00, 2.0426096160E+00, 1.3181632373E+00, 8.0250493928E-01],
	[2.0455000000E+04, 1.2179769415E+01, 5.3495241227E+00, 2.0442118178E+00, 1.3188749946E+00, 8.0259716865E-01],
	[2.0460000000E+04, 1.2184216102E+01, 5.3494015513E+00, 2.0458148835E+00, 1.3195868037E+00, 8.0268936101E-01],
	[2.0465000000E+04, 1.2188663325E+01, 5.3492790126E+00, 2.0474188136E+00, 1.3202986644E+00, 8.0278151637E-01],
	[2.0470000000E+04, 1.2193111085E+01, 5.3491565066E+00, 2.0490236083E+00, 1.3210105767E+00, 8.0287363473E-01],
	[2.0475000000E+04, 1.2197559380E+01, 5.3490340334E+00, 2.0506292678E+00, 1.3217225402E+00, 8.0296571609E-01],
	[2.0480000000E+04, 1.2202008212E+01, 5.3489115928E+00, 2.0522357923E+00, 1.3224345549E+00, 8.0305776047E-01],
	[2.0485000000E+04, 1.2206457580E+01, 5.3487891850E+00, 2.0538431822E+00, 1.3231466205E+00, 8.0314976787E-01],
	[2.0490000000E+04, 1.2210907483E+01, 5.3486668098E+00, 2.0554514377E+00, 1.3238587369E+00, 8.0324173829E-01],
	[2.0495000000E+04, 1.2215357923E+01, 5.3485444673E+00, 2.0570605590E+00, 1.3245709039E+00, 8.0333367174E-01],
	[2.0500000000E+04, 1.2219808898E+01, 5.3484221574E+00, 2.0586705463E+00, 1.3252831214E+00, 8.0342556822E-01],
	[2.0505000000E+04, 1.2224260409E+01, 5.3482998802E+00, 2.0602814001E+00, 1.3259953891E+00, 8.0351742774E-01],
	[2.0510000000E+04, 1.2228712456E+01, 5.3481776356E+00, 2.0618931204E+00, 1.3267077068E+00, 8.0360925030E-01],
	[2.0515000000E+04, 1.2233165039E+01, 5.3480554235E+00, 2.0635057076E+00, 1.3274200745E+00, 8.0370103592E-01],
	[2.0520000000E+04, 1.2237618157E+01, 5.3479332440E+00, 2.0651191618E+00, 1.3281324919E+00, 8.0379278458E-01],
	[2.0525000000E+04, 1.2242071810E+01, 5.3478110971E+00, 2.0667334835E+00, 1.3288449588E+00, 8.0388449631E-01],
	[2.0530000000E+04, 1.2246525999E+01, 5.3476889827E+00, 2.0683486727E+00, 1.3295574751E+00, 8.0397617111E-01],
	[2.0535000000E+04, 1.2250980723E+01, 5.3475669009E+00, 2.0699647298E+00, 1.3302700406E+00, 8.0406780898E-01],
	[2.0540000000E+04, 1.2255435983E+01, 5.3474448516E+00, 2.0715816551E+00, 1.3309826551E+00, 8.0415940992E-01],
	[2.0545000000E+04, 1.2259891778E+01, 5.3473228347E+00, 2.0731994487E+00, 1.3316953185E+00, 8.0425097394E-01],
	[2.0550000000E+04, 1.2264348108E+01, 5.3472008503E+00, 2.0748181109E+00, 1.3324080306E+00, 8.0434250106E-01],
	[2.0555000000E+04, 1.2268804973E+01, 5.3470788984E+00, 2.0764376421E+00, 1.3331207911E+00, 8.0443399127E-01],
	[2.0560000000E+04, 1.2273262373E+01, 5.3469569789E+00, 2.0780580423E+00, 1.3338336000E+00, 8.0452544457E-01],
	[2.0565000000E+04, 1.2277720308E+01, 5.3468350919E+00, 2.0796793120E+00, 1.3345464571E+00, 8.0461686099E-01],
	[2.0570000000E+04, 1.2282178778E+01, 5.3467132372E+00, 2.0813014513E+00, 1.3352593621E+00, 8.0470824051E-01],
	[2.0575000000E+04, 1.2286637783E+01, 5.3465914150E+00, 2.0829244605E+00, 1.3359723149E+00, 8.0479958315E-01],
	[2.0580000000E+04, 1.2291097323E+01, 5.3464696251E+00, 2.0845483399E+00, 1.3366853153E+00, 8.0489088891E-01],
	[2.0585000000E+04, 1.2295557397E+01, 5.3463478676E+00, 2.0861730897E+00, 1.3373983632E+00, 8.0498215780E-01],
	[2.0590000000E+04, 1.2300018006E+01, 5.3462261424E+00, 2.0877987101E+00, 1.3381114584E+00, 8.0507338982E-01],
	[2.0595000000E+04, 1.2304479150E+01, 5.3461044495E+00, 2.0894252015E+00, 1.3388246006E+00, 8.0516458498E-01],
	[2.0600000000E+04, 1.2308940828E+01, 5.3459827890E+00, 2.0910525640E+00, 1.3395377898E+00, 8.0525574328E-01],
	[2.0605000000E+04, 1.2313403040E+01, 5.3458611608E+00, 2.0926807980E+00, 1.3402510258E+00, 8.0534686474E-01],
	[2.0610000000E+04, 1.2317865787E+01, 5.3457395648E+00, 2.0943099037E+00, 1.3409643083E+00, 8.0543794935E-01],
	[2.0615000000E+04, 1.2322329068E+01, 5.3456180011E+00, 2.0959398813E+00, 1.3416776373E+00, 8.0552899709E-01],
	[2.0620000000E+04, 1.2326792884E+01, 5.3454964696E+00, 2.0975707311E+00, 1.3423910124E+00, 8.0562000790E-01],
	[2.0625000000E+04, 1.2331257233E+01, 5.3453749704E+00, 2.0992024533E+00, 1.3431044337E+00, 8.0571098180E-01],
	[2.0630000000E+04, 1.2335722117E+01, 5.3452535033E+00, 2.1008350482E+00, 1.3438179008E+00, 8.0580191879E-01],
	[2.0635000000E+04, 1.2340187535E+01, 5.3451320685E+00, 2.1024685161E+00, 1.3445314136E+00, 8.0589281888E-01],
	[2.0640000000E+04, 1.2344653487E+01, 5.3450106659E+00, 2.1041028572E+00, 1.3452449719E+00, 8.0598368207E-01],
	[2.0645000000E+04, 1.2349119972E+01, 5.3448892954E+00, 2.1057380718E+00, 1.3459585756E+00, 8.0607450839E-01],
	[2.0650000000E+04, 1.2353586992E+01, 5.3447679570E+00, 2.1073741601E+00, 1.3466722245E+00, 8.0616529784E-01],
	[2.0655000000E+04, 1.2358054545E+01, 5.3446466508E+00, 2.1090111224E+00, 1.3473859184E+00, 8.0625605042E-01],
	[2.0660000000E+04, 1.2362522632E+01, 5.3445253767E+00, 2.1106489589E+00, 1.3480996572E+00, 8.0634676614E-01],
	[2.0665000000E+04, 1.2366991253E+01, 5.3444041347E+00, 2.1122876699E+00, 1.3488134406E+00, 8.0643744502E-01],
	[2.0670000000E+04, 1.2371460407E+01, 5.3442829248E+00, 2.1139272556E+00, 1.3495272685E+00, 8.0652808706E-01],
	[2.0675000000E+04, 1.2375930095E+01, 5.3441617469E+00, 2.1155677163E+00, 1.3502411407E+00, 8.0661869227E-01],
	[2.0680000000E+04, 1.2380400316E+01, 5.3440406011E+00, 2.1172090522E+00, 1.3509550570E+00, 8.0670926066E-01],
	[2.0685000000E+04, 1.2384871071E+01, 5.3439194873E+00, 2.1188512637E+00, 1.3516690173E+00, 8.0679979223E-01],
	[2.0690000000E+04, 1.2389342359E+01, 5.3437984056E+00, 2.1204943509E+00, 1.3523830215E+00, 8.0689028701E-01],
	[2.0695000000E+04, 1.2393814180E+01, 5.3436773558E+00, 2.1221383142E+00, 1.3530970692E+00, 8.0698074499E-01],
	[2.0700000000E+04, 1.2398286535E+01, 5.3435563380E+00, 2.1237831537E+00, 1.3538111604E+00, 8.0707116618E-01],
	[2.0705000000E+04, 1.2402759422E+01, 5.3434353522E+00, 2.1254288697E+00, 1.3545252948E+00, 8.0716155059E-01],
	[2.0710000000E+04, 1.2407232843E+01, 5.3433143984E+00, 2.1270754625E+00, 1.3552394724E+00, 8.0725189824E-01],
	[2.0715000000E+04, 1.2411712136E+01, 5.3431946483E+00, 2.1287229323E+00, 1.3559538321E+00, 8.0734220913E-01],
	[2.0720000000E+04, 1.2416207441E+01, 5.3430783250E+00, 2.1303712794E+00, 1.3566686384E+00, 8.0743248326E-01],
	[2.0725000000E+04, 1.2420703290E+01, 5.3429620324E+00, 2.1320205041E+00, 1.3573834882E+00, 8.0752272066E-01],
	[2.0730000000E+04, 1.2425199681E+01, 5.3428457704E+00, 2.1336706065E+00, 1.3580983812E+00, 8.0761292132E-01],
	[2.0735000000E+04, 1.2429696615E+01, 5.3427295389E+00, 2.1353215870E+00, 1.3588133173E+00, 8.0770308526E-01],
	[2.0740000000E+04, 1.2434194091E+01, 5.3426133379E+00, 2.1369734458E+00, 1.3595282963E+00, 8.0779321248E-01],
	[2.0745000000E+04, 1.2438692111E+01, 5.3424971675E+00, 2.1386261832E+00, 1.3602433180E+00, 8.0788330299E-01],
	[2.0750000000E+04, 1.2443190672E+01, 5.3423810277E+00, 2.1402797994E+00, 1.3609583823E+00, 8.0797335681E-01],
	[2.0755000000E+04, 1.2447689777E+01, 5.3422649183E+00, 2.1419342946E+00, 1.3616734890E+00, 8.0806337394E-01],
	[2.0760000000E+04, 1.2452189423E+01, 5.3421488394E+00, 2.1435896692E+00, 1.3623886379E+00, 8.0815335439E-01],
	[2.0765000000E+04, 1.2456689612E+01, 5.3420327910E+00, 2.1452459233E+00, 1.3631038288E+00, 8.0824329816E-01],
	[2.0770000000E+04, 1.2461190344E+01, 5.3419167731E+00, 2.1469030573E+00, 1.3638190616E+00, 8.0833320528E-01],
	[2.0775000000E+04, 1.2465691617E+01, 5.3418007856E+00, 2.1485610714E+00, 1.3645343361E+00, 8.0842307574E-01],
	[2.0780000000E+04, 1.2470193433E+01, 5.3416848285E+00, 2.1502199658E+00, 1.3652496522E+00, 8.0851290956E-01],
	[2.0785000000E+04, 1.2474695791E+01, 5.3415689018E+00, 2.1518797408E+00, 1.3659650096E+00, 8.0860270674E-01],
	[2.0790000000E+04, 1.2479198691E+01, 5.3414530056E+00, 2.1535403967E+00, 1.3666804081E+00, 8.0869246730E-01],
	[2.0795000000E+04, 1.2483702133E+01, 5.3413371397E+00, 2.1552019337E+00, 1.3673958477E+00, 8.0878219124E-01],
	[2.0800000000E+04, 1.2488206117E+01, 5.3412213042E+00, 2.1568643520E+00, 1.3681113282E+00, 8.0887187857E-01],
	[2.0805000000E+04, 1.2492710642E+01, 5.3411054991E+00, 2.1585276520E+00, 1.3688268492E+00, 8.0896152930E-01],
	[2.0810000000E+04, 1.2497215710E+01, 5.3409897243E+00, 2.1601918338E+00, 1.3695424108E+00, 8.0905114345E-01],
	[2.0815000000E+04, 1.2501721319E+01, 5.3408739798E+00, 2.1618568977E+00, 1.3702580127E+00, 8.0914072101E-01],
	[2.0820000000E+04, 1.2506227470E+01, 5.3407582656E+00, 2.1635228441E+00, 1.3709736548E+00, 8.0923026200E-01],
	[2.0825000000E+04, 1.2510734162E+01, 5.3406425817E+00, 2.1651896731E+00, 1.3716893368E+00, 8.0931976642E-01],
	[2.0830000000E+04, 1.2515241396E+01, 5.3405269281E+00, 2.1668573849E+00, 1.3724050586E+00, 8.0940923429E-01],
	[2.0835000000E+04, 1.2519749171E+01, 5.3404113047E+00, 2.1685259800E+00, 1.3731208201E+00, 8.0949866562E-01],
	[2.0840000000E+04, 1.2524257488E+01, 5.3402957116E+00, 2.1701954584E+00, 1.3738366210E+00, 8.0958806041E-01],
	[2.0845000000E+04, 1.2528766346E+01, 5.3401801487E+00, 2.1718658205E+00, 1.3745524612E+00, 8.0967741868E-01],
	[2.0850000000E+04, 1.2533275746E+01, 5.3400646161E+00, 2.1735370665E+00, 1.3752683405E+00, 8.0976674043E-01],
	[2.0855000000E+04, 1.2537785686E+01, 5.3399491136E+00, 2.1752091966E+00, 1.3759842588E+00, 8.0985602567E-01],
	[2.0860000000E+04, 1.2542296168E+01, 5.3398336413E+00, 2.1768822112E+00, 1.3767002158E+00, 8.0994527441E-01],
	[2.0865000000E+04, 1.2546807190E+01, 5.3397181992E+00, 2.1785561105E+00, 1.3774162115E+00, 8.1003448666E-01],
	[2.0870000000E+04, 1.2551318754E+01, 5.3396027873E+00, 2.1802308947E+00, 1.3781322455E+00, 8.1012366242E-01],
	[2.0875000000E+04, 1.2555830859E+01, 5.3394874055E+00, 2.1819065641E+00, 1.3788483179E+00, 8.1021280172E-01],
	[2.0880000000E+04, 1.2560343504E+01, 5.3393720538E+00, 2.1835831189E+00, 1.3795644283E+00, 8.1030190456E-01],
	[2.0885000000E+04, 1.2564856691E+01, 5.3392567322E+00, 2.1852605594E+00, 1.3802805766E+00, 8.1039097094E-01],
	[2.0890000000E+04, 1.2569370418E+01, 5.3391414408E+00, 2.1869388859E+00, 1.3809967627E+00, 8.1048000088E-01],
	[2.0895000000E+04, 1.2573884685E+01, 5.3390261794E+00, 2.1886180986E+00, 1.3817129863E+00, 8.1056899438E-01],
	[2.0900000000E+04, 1.2578399494E+01, 5.3389109480E+00, 2.1902981978E+00, 1.3824292474E+00, 8.1065795146E-01],
	[2.0905000000E+04, 1.2582914843E+01, 5.3387957467E+00, 2.1919791837E+00, 1.3831455457E+00, 8.1074687212E-01],
	[2.0910000000E+04, 1.2587430732E+01, 5.3386805755E+00, 2.1936610565E+00, 1.3838618810E+00, 8.1083575637E-01],
	[2.0915000000E+04, 1.2591947162E+01, 5.3385654343E+00, 2.1953438166E+00, 1.3845782532E+00, 8.1092460422E-01],
	[2.0920000000E+04, 1.2596464132E+01, 5.3384503231E+00, 2.1970274642E+00, 1.3852946621E+00, 8.1101341569E-01],
	[2.0925000000E+04, 1.2600981642E+01, 5.3383352418E+00, 2.1987119995E+00, 1.3860111076E+00, 8.1110219078E-01],
	[2.0930000000E+04, 1.2605499693E+01, 5.3382201906E+00, 2.2003974228E+00, 1.3867275895E+00, 8.1119092950E-01],
	[2.0935000000E+04, 1.2610018284E+01, 5.3381051693E+00, 2.2020837344E+00, 1.3874441075E+00, 8.1127963185E-01],
	[2.0940000000E+04, 1.2614537415E+01, 5.3379901779E+00, 2.2037709344E+00, 1.3881606616E+00, 8.1136829786E-01],
	[2.0945000000E+04, 1.2619057086E+01, 5.3378752165E+00, 2.2054590233E+00, 1.3888772516E+00, 8.1145692752E-01],
	[2.0950000000E+04, 1.2623577297E+01, 5.3377602850E+00, 2.2071480011E+00, 1.3895938772E+00, 8.1154552086E-01],
	[2.0955000000E+04, 1.2628098048E+01, 5.3376453834E+00, 2.2088378682E+00, 1.3903105384E+00, 8.1163407786E-01],
	[2.0960000000E+04, 1.2632619338E+01, 5.3375305117E+00, 2.2105286249E+00, 1.3910272349E+00, 8.1172259856E-01],
	[2.0965000000E+04, 1.2637141169E+01, 5.3374156698E+00, 2.2122202713E+00, 1.3917439665E+00, 8.1181108295E-01],
	[2.0970000000E+04, 1.2641663539E+01, 5.3373008578E+00, 2.2139128078E+00, 1.3924607332E+00, 8.1189953104E-01],
	[2.0975000000E+04, 1.2646186449E+01, 5.3371860757E+00, 2.2156062345E+00, 1.3931775348E+00, 8.1198794285E-01],
	[2.0980000000E+04, 1.2650709898E+01, 5.3370713234E+00, 2.2173005518E+00, 1.3938943709E+00, 8.1207631838E-01],
	[2.0985000000E+04, 1.2655233887E+01, 5.3369566009E+00, 2.2189957600E+00, 1.3946112416E+00, 8.1216465765E-01],
	[2.0990000000E+04, 1.2659758415E+01, 5.3368419081E+00, 2.2206918591E+00, 1.3953281466E+00, 8.1225296066E-01],
	[2.0995000000E+04, 1.2664283483E+01, 5.3367272452E+00, 2.2223888496E+00, 1.3960450858E+00, 8.1234122742E-01],
	[2.1000000000E+04, 1.2668809090E+01, 5.3366126120E+00, 2.2240867317E+00, 1.3967620589E+00, 8.1242945794E-01],
	[2.1005000000E+04, 1.2673335236E+01, 5.3364980086E+00, 2.2257855056E+00, 1.3974790659E+00, 8.1251765223E-01],
	[2.1010000000E+04, 1.2677861922E+01, 5.3363834349E+00, 2.2274851715E+00, 1.3981961065E+00, 8.1260581030E-01],
	[2.1015000000E+04, 1.2682389147E+01, 5.3362688910E+00, 2.2291857299E+00, 1.3989131806E+00, 8.1269393217E-01],
	[2.1020000000E+04, 1.2686916910E+01, 5.3361543767E+00, 2.2308871808E+00, 1.3996302880E+00, 8.1278201783E-01],
	[2.1025000000E+04, 1.2691445213E+01, 5.3360398922E+00, 2.2325895245E+00, 1.4003474285E+00, 8.1287006730E-01],
	[2.1030000000E+04, 1.2695974055E+01, 5.3359254373E+00, 2.2342927614E+00, 1.4010646020E+00, 8.1295808059E-01],
	[2.1035000000E+04, 1.2700503435E+01, 5.3358110121E+00, 2.2359968916E+00, 1.4017818082E+00, 8.1304605771E-01],
	[2.1040000000E+04, 1.2705033355E+01, 5.3356966165E+00, 2.2377019154E+00, 1.4024990471E+00, 8.1313399866E-01],
	[2.1045000000E+04, 1.2709563813E+01, 5.3355822506E+00, 2.2394078331E+00, 1.4032163185E+00, 8.1322190347E-01],
	[2.1050000000E+04, 1.2714106667E+01, 5.3354704532E+00, 2.2411146449E+00, 1.4039339425E+00, 8.1330977212E-01],
	[2.1055000000E+04, 1.2718659233E+01, 5.3353606469E+00, 2.2428223511E+00, 1.4046518469E+00, 8.1339760465E-01],
	[2.1060000000E+04, 1.2723212347E+01, 5.3352508690E+00, 2.2445309520E+00, 1.4053697841E+00, 8.1348540105E-01],
	[2.1065000000E+04, 1.2727766010E+01, 5.3351411194E+00, 2.2462404477E+00, 1.4060877540E+00, 8.1357316134E-01],
	[2.1070000000E+04, 1.2732320222E+01, 5.3350313981E+00, 2.2479508386E+00, 1.4068057563E+00, 8.1366088552E-01],
	[2.1075000000E+04, 1.2736874982E+01, 5.3349217051E+00, 2.2496621249E+00, 1.4075237909E+00, 8.1374857360E-01],
	[2.1080000000E+04, 1.2741430290E+01, 5.3348120404E+00, 2.2513743068E+00, 1.4082418577E+00, 8.1383622560E-01],
	[2.1085000000E+04, 1.2745986147E+01, 5.3347024040E+00, 2.2530873847E+00, 1.4089599564E+00, 8.1392384153E-01],
	[2.1090000000E+04, 1.2750542552E+01, 5.3345927957E+00, 2.2548013587E+00, 1.4096780868E+00, 8.1401142139E-01],
	[2.1095000000E+04, 1.2755099504E+01, 5.3344832158E+00, 2.2565162292E+00, 1.4103962489E+00, 8.1409896519E-01],
	[2.1100000000E+04, 1.2759657005E+01, 5.3343736640E+00, 2.2582319963E+00, 1.4111144425E+00, 8.1418647294E-01],
	[2.1105000000E+04, 1.2764215054E+01, 5.3342641405E+00, 2.2599486604E+00, 1.4118326673E+00, 8.1427394466E-01],
	[2.1110000000E+04, 1.2768773651E+01, 5.3341546451E+00, 2.2616662217E+00, 1.4125509232E+00, 8.1436138034E-01],
	[2.1115000000E+04, 1.2773332796E+01, 5.3340451779E+00, 2.2633846804E+00, 1.4132692101E+00, 8.1444878001E-01],
	[2.1120000000E+04, 1.2777892489E+01, 5.3339357389E+00, 2.2651040368E+00, 1.4139875278E+00, 8.1453614368E-01],
	[2.1125000000E+04, 1.2782452729E+01, 5.3338263280E+00, 2.2668242912E+00, 1.4147058760E+00, 8.1462347134E-01],
	[2.1130000000E+04, 1.2787013517E+01, 5.3337169453E+00, 2.2685454438E+00, 1.4154242547E+00, 8.1471076301E-01],
	[2.1135000000E+04, 1.2791574852E+01, 5.3336075907E+00, 2.2702674949E+00, 1.4161426637E+00, 8.1479801871E-01],
	[2.1140000000E+04, 1.2796136736E+01, 5.3334982642E+00, 2.2719904447E+00, 1.4168611027E+00, 8.1488523844E-01],
	[2.1145000000E+04, 1.2800699166E+01, 5.3333889658E+00, 2.2737142935E+00, 1.4175795717E+00, 8.1497242220E-01],
	[2.1150000000E+04, 1.2805262144E+01, 5.3332796954E+00, 2.2754390415E+00, 1.4182980704E+00, 8.1505957002E-01],
	[2.1155000000E+04, 1.2809825670E+01, 5.3331704532E+00, 2.2771646890E+00, 1.4190165988E+00, 8.1514668190E-01],
	[2.1160000000E+04, 1.2814389743E+01, 5.3330612390E+00, 2.2788912363E+00, 1.4197351565E+00, 8.1523375784E-01],
	[2.1165000000E+04, 1.2818954363E+01, 5.3329520528E+00, 2.2806186836E+00, 1.4204537435E+00, 8.1532079787E-01],
	[2.1170000000E+04, 1.2823519530E+01, 5.3328428947E+00, 2.2823470311E+00, 1.4211723596E+00, 8.1540780198E-01],
	[2.1175000000E+04, 1.2828085244E+01, 5.3327337646E+00, 2.2840762792E+00, 1.4218910047E+00, 8.1549477020E-01],
	[2.1180000000E+04, 1.2832651506E+01, 5.3326246624E+00, 2.2858064280E+00, 1.4226096784E+00, 8.1558170252E-01],
	[2.1185000000E+04, 1.2837218314E+01, 5.3325155883E+00, 2.2875374779E+00, 1.4233283808E+00, 8.1566859896E-01],
	[2.1190000000E+04, 1.2841785669E+01, 5.3324065421E+00, 2.2892694290E+00, 1.4240471116E+00, 8.1575545953E-01],
	[2.1195000000E+04, 1.2846353571E+01, 5.3322975239E+00, 2.2910022817E+00, 1.4247658706E+00, 8.1584228424E-01],
	[2.1200000000E+04, 1.2850922020E+01, 5.3321885336E+00, 2.2927360362E+00, 1.4254846577E+00, 8.1592907310E-01],
	[2.1205000000E+04, 1.2855491016E+01, 5.3320795713E+00, 2.2944706928E+00, 1.4262034727E+00, 8.1601582611E-01],
	[2.1210000000E+04, 1.2860060558E+01, 5.3319706368E+00, 2.2962062516E+00, 1.4269223155E+00, 8.1610254329E-01],
	[2.1215000000E+04, 1.2864630647E+01, 5.3318617303E+00, 2.2979427130E+00, 1.4276411858E+00, 8.1618922466E-01],
	[2.1220000000E+04, 1.2869201283E+01, 5.3317528517E+00, 2.2996800773E+00, 1.4283600836E+00, 8.1627587021E-01],
	[2.1225000000E+04, 1.2873772464E+01, 5.3316440009E+00, 2.3014183446E+00, 1.4290790086E+00, 8.1636247995E-01],
	[2.1230000000E+04, 1.2878344193E+01, 5.3315351780E+00, 2.3031575153E+00, 1.4297979606E+00, 8.1644905391E-01],
	[2.1235000000E+04, 1.2882916467E+01, 5.3314263829E+00, 2.3048975895E+00, 1.4305169396E+00, 8.1653559208E-01],
	[2.1240000000E+04, 1.2887489288E+01, 5.3313176157E+00, 2.3066385676E+00, 1.4312359453E+00, 8.1662209448E-01],
	[2.1245000000E+04, 1.2892062656E+01, 5.3312088763E+00, 2.3083804498E+00, 1.4319549776E+00, 8.1670856112E-01],
	[2.1250000000E+04, 1.2896636569E+01, 5.3311001647E+00, 2.3101232363E+00, 1.4326740363E+00, 8.1679499200E-01],
	[2.1255000000E+04, 1.2901211028E+01, 5.3309914809E+00, 2.3118669275E+00, 1.4333931212E+00, 8.1688138715E-01],
	[2.1260000000E+04, 1.2905786034E+01, 5.3308828249E+00, 2.3136115235E+00, 1.4341122322E+00, 8.1696774656E-01],
	[2.1265000000E+04, 1.2910361585E+01, 5.3307741966E+00, 2.3153570247E+00, 1.4348313691E+00, 8.1705407025E-01],
	[2.1270000000E+04, 1.2914937683E+01, 5.3306655961E+00, 2.3171034312E+00, 1.4355505318E+00, 8.1714035822E-01],
	[2.1275000000E+04, 1.2919514326E+01, 5.3305570233E+00, 2.3188507434E+00, 1.4362697200E+00, 8.1722661050E-01],
	[2.1280000000E+04, 1.2924091515E+01, 5.3304484782E+00, 2.3205989615E+00, 1.4369889336E+00, 8.1731282708E-01],
	[2.1285000000E+04, 1.2928669250E+01, 5.3303399609E+00, 2.3223480857E+00, 1.4377081724E+00, 8.1739900797E-01],
	[2.1290000000E+04, 1.2933247530E+01, 5.3302314713E+00, 2.3240981164E+00, 1.4384274363E+00, 8.1748515319E-01],
	[2.1295000000E+04, 1.2937826356E+01, 5.3301230093E+00, 2.3258490537E+00, 1.4391467252E+00, 8.1757126272E-01],
	[2.1300000000E+04, 1.2942405727E+01, 5.3300145750E+00, 2.3276008979E+00, 1.4398660387E+00, 8.1765733656E-01],
	[2.1305000000E+04, 1.2946985644E+01, 5.3299061684E+00, 2.3293536493E+00, 1.4405853768E+00, 8.1774337471E-01],
	[2.1310000000E+04, 1.2951566107E+01, 5.3297977894E+00, 2.3311073081E+00, 1.4413047394E+00, 8.1782937719E-01],
	[2.1315000000E+04, 1.2956147114E+01, 5.3296894380E+00, 2.3328618746E+00, 1.4420241261E+00, 8.1791534399E-01],
	[2.1320000000E+04, 1.2960728667E+01, 5.3295811143E+00, 2.3346173490E+00, 1.4427435370E+00, 8.1800127512E-01],
	[2.1325000000E+04, 1.2965310765E+01, 5.3294728181E+00, 2.3363737317E+00, 1.4434629717E+00, 8.1808717060E-01],
	[2.1330000000E+04, 1.2969893409E+01, 5.3293645496E+00, 2.3381310228E+00, 1.4441824302E+00, 8.1817303041E-01],
	[2.1335000000E+04, 1.2974476597E+01, 5.3292563086E+00, 2.3398892226E+00, 1.4449019122E+00, 8.1825885458E-01],
	[2.1340000000E+04, 1.2979060331E+01, 5.3291480952E+00, 2.3416483314E+00, 1.4456214176E+00, 8.1834464309E-01],
	[2.1345000000E+04, 1.2983644609E+01, 5.3290399093E+00, 2.3434083494E+00, 1.4463409463E+00, 8.1843039597E-01],
	[2.1350000000E+04, 1.2988229432E+01, 5.3289317509E+00, 2.3451692769E+00, 1.4470604981E+00, 8.1851611321E-01],
	[2.1355000000E+04, 1.2992814800E+01, 5.3288236201E+00, 2.3469311141E+00, 1.4477800727E+00, 8.1860179482E-01],
	[2.1360000000E+04, 1.2997400713E+01, 5.3287155168E+00, 2.3486938613E+00, 1.4484996701E+00, 8.1868744081E-01],
	[2.1365000000E+04, 1.3001987171E+01, 5.3286074410E+00, 2.3504575188E+00, 1.4492192901E+00, 8.1877305117E-01],
	[2.1370000000E+04, 1.3006574173E+01, 5.3284993927E+00, 2.3522220868E+00, 1.4499389325E+00, 8.1885862592E-01],
	[2.1375000000E+04, 1.3011161720E+01, 5.3283913718E+00, 2.3539875655E+00, 1.4506585971E+00, 8.1894416507E-01],
	[2.1380000000E+04, 1.3015749811E+01, 5.3282833784E+00, 2.3557539553E+00, 1.4513782838E+00, 8.1902966861E-01],
	[2.1385000000E+04, 1.3020338447E+01, 5.3281754124E+00, 2.3575212563E+00, 1.4520979924E+00, 8.1911513655E-01],
	[2.1390000000E+04, 1.3024944571E+01, 5.3280710135E+00, 2.3592894689E+00, 1.4528181967E+00, 8.1920056890E-01],
	[2.1395000000E+04, 1.3029555541E+01, 5.3279675378E+00, 2.3610585932E+00, 1.4535385435E+00, 8.1928596567E-01],
	[2.1400000000E+04, 1.3034167066E+01, 5.3278640883E+00, 2.3628286296E+00, 1.4542589126E+00, 8.1937132685E-01],
	[2.1405000000E+04, 1.3038779145E+01, 5.3277606650E+00, 2.3645995783E+00, 1.4549793038E+00, 8.1945665246E-01],
	[2.1410000000E+04, 1.3043391779E+01, 5.3276572679E+00, 2.3663714396E+00, 1.4556997169E+00, 8.1954194250E-01],
	[2.1415000000E+04, 1.3048004966E+01, 5.3275538969E+00, 2.3681442136E+00, 1.4564201518E+00, 8.1962719698E-01],
	[2.1420000000E+04, 1.3052618707E+01, 5.3274505520E+00, 2.3699179008E+00, 1.4571406083E+00, 8.1971241590E-01],
	[2.1425000000E+04, 1.3057233003E+01, 5.3273472333E+00, 2.3716925012E+00, 1.4578610863E+00, 8.1979759926E-01],
	[2.1430000000E+04, 1.3061847852E+01, 5.3272439406E+00, 2.3734680153E+00, 1.4585815856E+00, 8.1988274708E-01],
	[2.1435000000E+04, 1.3066463255E+01, 5.3271406741E+00, 2.3752444432E+00, 1.4593021060E+00, 8.1996785936E-01],
	[2.1440000000E+04, 1.3071079212E+01, 5.3270374336E+00, 2.3770217851E+00, 1.4600226474E+00, 8.2005293610E-01],
	[2.1445000000E+04, 1.3075695723E+01, 5.3269342193E+00, 2.3788000415E+00, 1.4607432095E+00, 8.2013797732E-01],
	[2.1450000000E+04, 1.3080312788E+01, 5.3268310310E+00, 2.3805792124E+00, 1.4614637923E+00, 8.2022298301E-01],
	[2.1455000000E+04, 1.3084930406E+01, 5.3267278687E+00, 2.3823592982E+00, 1.4621843956E+00, 8.2030795318E-01],
	[2.1460000000E+04, 1.3089548577E+01, 5.3266247325E+00, 2.3841402991E+00, 1.4629050191E+00, 8.2039288784E-01],
	[2.1465000000E+04, 1.3094167302E+01, 5.3265216223E+00, 2.3859222155E+00, 1.4636256628E+00, 8.2047778699E-01],
	[2.1470000000E+04, 1.3098786581E+01, 5.3264185381E+00, 2.3877050474E+00, 1.4643463265E+00, 8.2056265065E-01],
	[2.1475000000E+04, 1.3103406413E+01, 5.3263154799E+00, 2.3894887952E+00, 1.4650670100E+00, 8.2064747881E-01],
	[2.1480000000E+04, 1.3108026798E+01, 5.3262124477E+00, 2.3912734592E+00, 1.4657877131E+00, 8.2073227148E-01],
	[2.1485000000E+04, 1.3112647737E+01, 5.3261094415E+00, 2.3930590396E+00, 1.4665084357E+00, 8.2081702867E-01],
	[2.1490000000E+04, 1.3117269228E+01, 5.3260064612E+00, 2.3948455366E+00, 1.4672291776E+00, 8.2090175038E-01],
	[2.1495000000E+04, 1.3121891273E+01, 5.3259035069E+00, 2.3966329506E+00, 1.4679499387E+00, 8.2098643662E-01],
	[2.1500000000E+04, 1.3126513871E+01, 5.3258005785E+00, 2.3984212817E+00, 1.4686707187E+00, 8.2107108740E-01],
	[2.1505000000E+04, 1.3131137021E+01, 5.3256976760E+00, 2.4002105303E+00, 1.4693915176E+00, 8.2115570271E-01],
	[2.1510000000E+04, 1.3135760725E+01, 5.3255947994E+00, 2.4020006966E+00, 1.4701123352E+00, 8.2124028258E-01],
	[2.1515000000E+04, 1.3140384982E+01, 5.3254919488E+00, 2.4037917808E+00, 1.4708331712E+00, 8.2132482700E-01],
	[2.1520000000E+04, 1.3145009791E+01, 5.3253891240E+00, 2.4055837832E+00, 1.4715540256E+00, 8.2140933598E-01],
	[2.1525000000E+04, 1.3149635153E+01, 5.3252863251E+00, 2.4073767040E+00, 1.4722748981E+00, 8.2149380952E-01],
	[2.1530000000E+04, 1.3154261068E+01, 5.3251835521E+00, 2.4091705436E+00, 1.4729957887E+00, 8.2157824764E-01],
	[2.1535000000E+04, 1.3158887535E+01, 5.3250808049E+00, 2.4109653022E+00, 1.4737166970E+00, 8.2166265033E-01],
	[2.1540000000E+04, 1.3163514555E+01, 5.3249780835E+00, 2.4127609799E+00, 1.4744376231E+00, 8.2174701761E-01],
	[2.1545000000E+04, 1.3168142128E+01, 5.3248753880E+00, 2.4145575772E+00, 1.4751585667E+00, 8.2183134948E-01],
	[2.1550000000E+04, 1.3172770253E+01, 5.3247727182E+00, 2.4163550942E+00, 1.4758795276E+00, 8.2191564595E-01],
	[2.1555000000E+04, 1.3177398930E+01, 5.3246700743E+00, 2.4181535312E+00, 1.4766005057E+00, 8.2199990702E-01],
	[2.1560000000E+04, 1.3182028159E+01, 5.3245674561E+00, 2.4199528884E+00, 1.4773215009E+00, 8.2208413269E-01],
	[2.1565000000E+04, 1.3186657941E+01, 5.3244648638E+00, 2.4217531662E+00, 1.4780425129E+00, 8.2216832298E-01],
	[2.1570000000E+04, 1.3191288275E+01, 5.3243622972E+00, 2.4235543647E+00, 1.4787635416E+00, 8.2225247790E-01],
	[2.1575000000E+04, 1.3195919161E+01, 5.3242597563E+00, 2.4253564843E+00, 1.4794845868E+00, 8.2233659744E-01],
	[2.1580000000E+04, 1.3200550599E+01, 5.3241572412E+00, 2.4271595251E+00, 1.4802056484E+00, 8.2242068161E-01],
	[2.1585000000E+04, 1.3205182590E+01, 5.3240547517E+00, 2.4289634875E+00, 1.4809267263E+00, 8.2250473043E-01],
	[2.1590000000E+04, 1.3209815132E+01, 5.3239522880E+00, 2.4307683717E+00, 1.4816478201E+00, 8.2258874389E-01],
	[2.1595000000E+04, 1.3214448226E+01, 5.3238498500E+00, 2.4325741779E+00, 1.4823689299E+00, 8.2267272201E-01],
	[2.1600000000E+04, 1.3219081871E+01, 5.3237474377E+00, 2.4343809064E+00, 1.4830900553E+00, 8.2275666478E-01],
	[2.1605000000E+04, 1.3223716069E+01, 5.3236450511E+00, 2.4361885575E+00, 1.4838111964E+00, 8.2284057222E-01],
	[2.1610000000E+04, 1.3228350818E+01, 5.3235426901E+00, 2.4379971315E+00, 1.4845323528E+00, 8.2292444434E-01],
	[2.1615000000E+04, 1.3232986119E+01, 5.3234403548E+00, 2.4398066285E+00, 1.4852535245E+00, 8.2300828113E-01],
	[2.1620000000E+04, 1.3237621971E+01, 5.3233380451E+00, 2.4416170488E+00, 1.4859747112E+00, 8.2309208261E-01],
	[2.1625000000E+04, 1.3242258375E+01, 5.3232357610E+00, 2.4434283928E+00, 1.4866959128E+00, 8.2317584877E-01],
	[2.1630000000E+04, 1.3246895330E+01, 5.3231335025E+00, 2.4452406605E+00, 1.4874171292E+00, 8.2325957964E-01],
	[2.1635000000E+04, 1.3251532837E+01, 5.3230312697E+00, 2.4470538524E+00, 1.4881383602E+00, 8.2334327521E-01],
	[2.1640000000E+04, 1.3256170895E+01, 5.3229290624E+00, 2.4488679687E+00, 1.4888596056E+00, 8.2342693550E-01],
	[2.1645000000E+04, 1.3260809504E+01, 5.3228268807E+00, 2.4506830096E+00, 1.4895808652E+00, 8.2351056050E-01],
	[2.1650000000E+04, 1.3265448664E+01, 5.3227247246E+00, 2.4524989753E+00, 1.4903021390E+00, 8.2359415022E-01],
	[2.1655000000E+04, 1.3270088376E+01, 5.3226225940E+00, 2.4543158662E+00, 1.4910234266E+00, 8.2367770468E-01],
	[2.1660000000E+04, 1.3274728638E+01, 5.3225204889E+00, 2.4561336825E+00, 1.4917447281E+00, 8.2376122387E-01],
	[2.1665000000E+04, 1.3279369452E+01, 5.3224184094E+00, 2.4579524244E+00, 1.4924660432E+00, 8.2384470781E-01],
	[2.1670000000E+04, 1.3284010817E+01, 5.3223163554E+00, 2.4597720923E+00, 1.4931873717E+00, 8.2392815649E-01],
	[2.1675000000E+04, 1.3288652732E+01, 5.3222143269E+00, 2.4615926863E+00, 1.4939087135E+00, 8.2401156994E-01],
	[2.1680000000E+04, 1.3293295198E+01, 5.3221123238E+00, 2.4634142067E+00, 1.4946300684E+00, 8.2409494815E-01],
	[2.1685000000E+04, 1.3297938215E+01, 5.3220103463E+00, 2.4652366538E+00, 1.4953514363E+00, 8.2417829113E-01],
	[2.1690000000E+04, 1.3302581783E+01, 5.3219083942E+00, 2.4670600279E+00, 1.4960728170E+00, 8.2426159889E-01],
	[2.1695000000E+04, 1.3307225901E+01, 5.3218064676E+00, 2.4688843291E+00, 1.4967942103E+00, 8.2434487143E-01],
	[2.1700000000E+04, 1.3311870570E+01, 5.3217045664E+00, 2.4707095578E+00, 1.4975156162E+00, 8.2442810876E-01],
	[2.1705000000E+04, 1.3316515789E+01, 5.3216026906E+00, 2.4725357142E+00, 1.4982370343E+00, 8.2451131089E-01],
	[2.1710000000E+04, 1.3321161559E+01, 5.3215008403E+00, 2.4743627985E+00, 1.4989584646E+00, 8.2459447783E-01],
	[2.1715000000E+04, 1.3325807879E+01, 5.3213990153E+00, 2.4761908111E+00, 1.4996799069E+00, 8.2467760958E-01],
	[2.1720000000E+04, 1.3330454750E+01, 5.3212972158E+00, 2.4780197521E+00, 1.5004013610E+00, 8.2476070614E-01],
	[2.1725000000E+04, 1.3335102171E+01, 5.3211954416E+00, 2.4798496219E+00, 1.5011228268E+00, 8.2484376753E-01],
	[2.1730000000E+04, 1.3339750142E+01, 5.3210936928E+00, 2.4816804207E+00, 1.5018443041E+00, 8.2492679375E-01],
	[2.1735000000E+04, 1.3344418846E+01, 5.3209960829E+00, 2.4835121487E+00, 1.5025663767E+00, 8.2500978482E-01],
	[2.1740000000E+04, 1.3349089382E+01, 5.3208987564E+00, 2.4853448062E+00, 1.5032884981E+00, 8.2509274072E-01],
	[2.1745000000E+04, 1.3353760478E+01, 5.3208014542E+00, 2.4871783935E+00, 1.5040106314E+00, 8.2517566148E-01],
	[2.1750000000E+04, 1.3358432135E+01, 5.3207041761E+00, 2.4890129108E+00, 1.5047327765E+00, 8.2525854710E-01],
	[2.1755000000E+04, 1.3363104351E+01, 5.3206069221E+00, 2.4908483584E+00, 1.5054549331E+00, 8.2534139759E-01],
	[2.1760000000E+04, 1.3367777127E+01, 5.3205096923E+00, 2.4926847366E+00, 1.5061771012E+00, 8.2542421294E-01],
	[2.1765000000E+04, 1.3372450463E+01, 5.3204124866E+00, 2.4945220455E+00, 1.5068992805E+00, 8.2550699318E-01],
	[2.1770000000E+04, 1.3377124358E+01, 5.3203153049E+00, 2.4963602854E+00, 1.5076214709E+00, 8.2558973831E-01],
	[2.1775000000E+04, 1.3381798814E+01, 5.3202181474E+00, 2.4981994567E+00, 1.5083436723E+00, 8.2567244833E-01],
	[2.1780000000E+04, 1.3386473829E+01, 5.3201210139E+00, 2.5000395596E+00, 1.5090658845E+00, 8.2575512325E-01],
	[2.1785000000E+04, 1.3391149403E+01, 5.3200239046E+00, 2.5018805942E+00, 1.5097881072E+00, 8.2583776309E-01],
	[2.1790000000E+04, 1.3395825537E+01, 5.3199268192E+00, 2.5037225610E+00, 1.5105103405E+00, 8.2592036783E-01],
	[2.1795000000E+04, 1.3400502231E+01, 5.3198297580E+00, 2.5055654600E+00, 1.5112325840E+00, 8.2600293750E-01],
	[2.1800000000E+04, 1.3405179484E+01, 5.3197327207E+00, 2.5074092917E+00, 1.5119548377E+00, 8.2608547210E-01],
	[2.1805000000E+04, 1.3409857296E+01, 5.3196357075E+00, 2.5092540562E+00, 1.5126771013E+00, 8.2616797164E-01],
	[2.1810000000E+04, 1.3414535667E+01, 5.3195387183E+00, 2.5110997538E+00, 1.5133993748E+00, 8.2625043612E-01],
	[2.1815000000E+04, 1.3419214598E+01, 5.3194417531E+00, 2.5129463848E+00, 1.5141216579E+00, 8.2633286555E-01],
	[2.1820000000E+04, 1.3423894088E+01, 5.3193448119E+00, 2.5147939494E+00, 1.5148439506E+00, 8.2641525994E-01],
	[2.1825000000E+04, 1.3428574137E+01, 5.3192478946E+00, 2.5166424479E+00, 1.5155662526E+00, 8.2649761930E-01],
	[2.1830000000E+04, 1.3433254745E+01, 5.3191510014E+00, 2.5184918806E+00, 1.5162885637E+00, 8.2657994363E-01],
	[2.1835000000E+04, 1.3437935912E+01, 5.3190541320E+00, 2.5203422476E+00, 1.5170108839E+00, 8.2666223293E-01],
	[2.1840000000E+04, 1.3442617637E+01, 5.3189572867E+00, 2.5221935493E+00, 1.5177332130E+00, 8.2674448723E-01],
	[2.1845000000E+04, 1.3447299922E+01, 5.3188604652E+00, 2.5240457859E+00, 1.5184555507E+00, 8.2682670652E-01],
	[2.1850000000E+04, 1.3451982765E+01, 5.3187636677E+00, 2.5258989576E+00, 1.5191778971E+00, 8.2690889081E-01],
	[2.1855000000E+04, 1.3456666168E+01, 5.3186668941E+00, 2.5277530648E+00, 1.5199002517E+00, 8.2699104012E-01],
	[2.1860000000E+04, 1.3461350128E+01, 5.3185701443E+00, 2.5296081077E+00, 1.5206226147E+00, 8.2707315443E-01],
	[2.1865000000E+04, 1.3466034648E+01, 5.3184734185E+00, 2.5314640865E+00, 1.5213449857E+00, 8.2715523378E-01],
	[2.1870000000E+04, 1.3470719726E+01, 5.3183767166E+00, 2.5333210015E+00, 1.5220673646E+00, 8.2723727815E-01],
	[2.1875000000E+04, 1.3475405362E+01, 5.3182800385E+00, 2.5351788529E+00, 1.5227897512E+00, 8.2731928756E-01],
	[2.1880000000E+04, 1.3480091557E+01, 5.3181833842E+00, 2.5370376411E+00, 1.5235121455E+00, 8.2740126202E-01],
	[2.1885000000E+04, 1.3484778310E+01, 5.3180867538E+00, 2.5388973662E+00, 1.5242345471E+00, 8.2748320153E-01],
	[2.1890000000E+04, 1.3489465621E+01, 5.3179901472E+00, 2.5407580286E+00, 1.5249569561E+00, 8.2756510610E-01],
	[2.1895000000E+04, 1.3494153491E+01, 5.3178935645E+00, 2.5426196284E+00, 1.5256793722E+00, 8.2764697574E-01],
	[2.1900000000E+04, 1.3498841918E+01, 5.3177970055E+00, 2.5444821660E+00, 1.5264017952E+00, 8.2772881046E-01],
	[2.1905000000E+04, 1.3503530904E+01, 5.3177004704E+00, 2.5463456416E+00, 1.5271242250E+00, 8.2781061026E-01],
	[2.1910000000E+04, 1.3508220448E+01, 5.3176039590E+00, 2.5482100555E+00, 1.5278466615E+00, 8.2789237515E-01],
	[2.1915000000E+04, 1.3512910550E+01, 5.3175074714E+00, 2.5500754078E+00, 1.5285691045E+00, 8.2797410513E-01],
	[2.1920000000E+04, 1.3517601210E+01, 5.3174110076E+00, 2.5519416990E+00, 1.5292915538E+00, 8.2805580023E-01],
	[2.1925000000E+04, 1.3522292427E+01, 5.3173145675E+00, 2.5538089291E+00, 1.5300140092E+00, 8.2813746043E-01],
	[2.1930000000E+04, 1.3526984203E+01, 5.3172181512E+00, 2.5556770986E+00, 1.5307364707E+00, 8.2821908576E-01],
	[2.1935000000E+04, 1.3531676536E+01, 5.3171217586E+00, 2.5575462076E+00, 1.5314589380E+00, 8.2830067622E-01],
	[2.1940000000E+04, 1.3536369427E+01, 5.3170253897E+00, 2.5594162564E+00, 1.5321814110E+00, 8.2838223181E-01],
	[2.1945000000E+04, 1.3541062875E+01, 5.3169290445E+00, 2.5612872452E+00, 1.5329038895E+00, 8.2846375254E-01],
	[2.1950000000E+04, 1.3545756881E+01, 5.3168327230E+00, 2.5631591744E+00, 1.5336263734E+00, 8.2854523843E-01],
	[2.1955000000E+04, 1.3550451445E+01, 5.3167364252E+00, 2.5650320442E+00, 1.5343488625E+00, 8.2862668947E-01],
	[2.1960000000E+04, 1.3555146566E+01, 5.3166401510E+00, 2.5669058548E+00, 1.5350713567E+00, 8.2870810568E-01],
	[2.1965000000E+04, 1.3559842244E+01, 5.3165439005E+00, 2.5687806065E+00, 1.5357938558E+00, 8.2878948706E-01],
	[2.1970000000E+04, 1.3564538480E+01, 5.3164476737E+00, 2.5706562995E+00, 1.5365163597E+00, 8.2887083363E-01],
	[2.1975000000E+04, 1.3569235273E+01, 5.3163514705E+00, 2.5725329341E+00, 1.5372388681E+00, 8.2895214538E-01],
	[2.1980000000E+04, 1.3573932623E+01, 5.3162552909E+00, 2.5744105106E+00, 1.5379613810E+00, 8.2903342234E-01],
	[2.1985000000E+04, 1.3578630530E+01, 5.3161591350E+00, 2.5762890293E+00, 1.5386838981E+00, 8.2911466449E-01],
	[2.1990000000E+04, 1.3583328994E+01, 5.3160630026E+00, 2.5781684903E+00, 1.5394064194E+00, 8.2919587186E-01],
	[2.1995000000E+04, 1.3588028016E+01, 5.3159668939E+00, 2.5800488939E+00, 1.5401289446E+00, 8.2927704445E-01],
	[2.2000000000E+04, 1.3592727594E+01, 5.3158708087E+00, 2.5819302405E+00, 1.5408514736E+00, 8.2935818227E-01],
	[2.2005000000E+04, 1.3597427729E+01, 5.3157747471E+00, 2.5838125302E+00, 1.5415740063E+00, 8.2943928532E-01],
	[2.2010000000E+04, 1.3602128421E+01, 5.3156787091E+00, 2.5856957633E+00, 1.5422965424E+00, 8.2952035362E-01],
	[2.2015000000E+04, 1.3606829669E+01, 5.3155826946E+00, 2.5875799401E+00, 1.5430190819E+00, 8.2960138717E-01],
	[2.2020000000E+04, 1.3611531475E+01, 5.3154867036E+00, 2.5894650608E+00, 1.5437416246E+00, 8.2968238597E-01],
	[2.2025000000E+04, 1.3616233837E+01, 5.3153907362E+00, 2.5913511256E+00, 1.5444641703E+00, 8.2976335005E-01],
	[2.2030000000E+04, 1.3620936755E+01, 5.3152947923E+00, 2.5932381350E+00, 1.5451867188E+00, 8.2984427940E-01],
	[2.2035000000E+04, 1.3625640231E+01, 5.3151988719E+00, 2.5951260890E+00, 1.5459092701E+00, 8.2992517403E-01],
	[2.2040000000E+04, 1.3630344262E+01, 5.3151029749E+00, 2.5970149880E+00, 1.5466318239E+00, 8.3000603395E-01],
	[2.2045000000E+04, 1.3635048850E+01, 5.3150071015E+00, 2.5989048322E+00, 1.5473543801E+00, 8.3008685917E-01],
	[2.2050000000E+04, 1.3639753995E+01, 5.3149112515E+00, 2.6007956219E+00, 1.5480769385E+00, 8.3016764970E-01],
	[2.2055000000E+04, 1.3644459695E+01, 5.3148154250E+00, 2.6026873573E+00, 1.5487994990E+00, 8.3024840555E-01],
	[2.2060000000E+04, 1.3649165952E+01, 5.3147196220E+00, 2.6045800387E+00, 1.5495220614E+00, 8.3032912671E-01],
	[2.2065000000E+04, 1.3653872765E+01, 5.3146238424E+00, 2.6064736664E+00, 1.5502446256E+00, 8.3040981321E-01],
	[2.2070000000E+04, 1.3658580134E+01, 5.3145280862E+00, 2.6083682405E+00, 1.5509671914E+00, 8.3049046504E-01],
	[2.2075000000E+04, 1.3663288059E+01, 5.3144323534E+00, 2.6102637615E+00, 1.5516897587E+00, 8.3057108222E-01],
	[2.2080000000E+04, 1.3667996540E+01, 5.3143366441E+00, 2.6121602294E+00, 1.5524123273E+00, 8.3065166476E-01],
	[2.2085000000E+04, 1.3672726714E+01, 5.3142451609E+00, 2.6140576446E+00, 1.5531355287E+00, 8.3073221266E-01],
	[2.2090000000E+04, 1.3677457995E+01, 5.3141538075E+00, 2.6159560074E+00, 1.5538587481E+00, 8.3081272592E-01],
	[2.2095000000E+04, 1.3682189841E+01, 5.3140624764E+00, 2.6178553180E+00, 1.5545819693E+00, 8.3089320457E-01],
	[2.2100000000E+04, 1.3686922253E+01, 5.3139711675E+00, 2.6197555766E+00, 1.5553051920E+00, 8.3097364861E-01],
	[2.2105000000E+04, 1.3691655231E+01, 5.3138798808E+00, 2.6216567835E+00, 1.5560284161E+00, 8.3105405803E-01],
	[2.2110000000E+04, 1.3696388774E+01, 5.3137886164E+00, 2.6235589390E+00, 1.5567516415E+00, 8.3113443287E-01],
	[2.2115000000E+04, 1.3701122883E+01, 5.3136973741E+00, 2.6254620433E+00, 1.5574748679E+00, 8.3121477311E-01],
	[2.2120000000E+04, 1.3705857558E+01, 5.3136061540E+00, 2.6273660968E+00, 1.5581980953E+00, 8.3129507877E-01],
	[2.2125000000E+04, 1.3710592798E+01, 5.3135149561E+00, 2.6292710995E+00, 1.5589213235E+00, 8.3137534986E-01],
	[2.2130000000E+04, 1.3715328603E+01, 5.3134237804E+00, 2.6311770519E+00, 1.5596445523E+00, 8.3145558639E-01],
	[2.2135000000E+04, 1.3720064974E+01, 5.3133326269E+00, 2.6330839541E+00, 1.5603677815E+00, 8.3153578836E-01],
	[2.2140000000E+04, 1.3724801910E+01, 5.3132414955E+00, 2.6349918064E+00, 1.5610910111E+00, 8.3161595578E-01],
	[2.2145000000E+04, 1.3729539412E+01, 5.3131503862E+00, 2.6369006092E+00, 1.5618142408E+00, 8.3169608866E-01],
	[2.2150000000E+04, 1.3734277478E+01, 5.3130592991E+00, 2.6388103625E+00, 1.5625374706E+00, 8.3177618701E-01],
	[2.2155000000E+04, 1.3739016110E+01, 5.3129682341E+00, 2.6407210668E+00, 1.5632607001E+00, 8.3185625083E-01],
	[2.2160000000E+04, 1.3743755307E+01, 5.3128771912E+00, 2.6426327222E+00, 1.5639839294E+00, 8.3193628014E-01],
	[2.2165000000E+04, 1.3748495069E+01, 5.3127861704E+00, 2.6445453290E+00, 1.5647071583E+00, 8.3201627495E-01],
	[2.2170000000E+04, 1.3753235396E+01, 5.3126951717E+00, 2.6464588874E+00, 1.5654303865E+00, 8.3209623525E-01],
	[2.2175000000E+04, 1.3757976287E+01, 5.3126041950E+00, 2.6483733979E+00, 1.5661536139E+00, 8.3217616107E-01],
	[2.2180000000E+04, 1.3762717744E+01, 5.3125132405E+00, 2.6502888604E+00, 1.5668768405E+00, 8.3225605240E-01],
	[2.2185000000E+04, 1.3767459765E+01, 5.3124223079E+00, 2.6522052755E+00, 1.5676000659E+00, 8.3233590926E-01],
	[2.2190000000E+04, 1.3772202351E+01, 5.3123313975E+00, 2.6541226432E+00, 1.5683232901E+00, 8.3241573166E-01],
	[2.2195000000E+04, 1.3776945502E+01, 5.3122405091E+00, 2.6560409639E+00, 1.5690465130E+00, 8.3249551960E-01],
	[2.2200000000E+04, 1.3781689217E+01, 5.3121496427E+00, 2.6579602378E+00, 1.5697697343E+00, 8.3257527309E-01],
	[2.2205000000E+04, 1.3786433497E+01, 5.3120587983E+00, 2.6598804652E+00, 1.5704929539E+00, 8.3265499213E-01],
	[2.2210000000E+04, 1.3791178341E+01, 5.3119679759E+00, 2.6618016463E+00, 1.5712161716E+00, 8.3273467675E-01],
	[2.2215000000E+04, 1.3795923750E+01, 5.3118771755E+00, 2.6637237814E+00, 1.5719393874E+00, 8.3281432695E-01],
	[2.2220000000E+04, 1.3800669723E+01, 5.3117863972E+00, 2.6656468708E+00, 1.5726626010E+00, 8.3289394273E-01],
	[2.2225000000E+04, 1.3805416260E+01, 5.3116956407E+00, 2.6675709146E+00, 1.5733858123E+00, 8.3297352410E-01],
	[2.2230000000E+04, 1.3810163362E+01, 5.3116049063E+00, 2.6694959133E+00, 1.5741090212E+00, 8.3305307108E-01],
	[2.2235000000E+04, 1.3814911028E+01, 5.3115141938E+00, 2.6714218669E+00, 1.5748322274E+00, 8.3313258366E-01],
	[2.2240000000E+04, 1.3819659257E+01, 5.3114235033E+00, 2.6733487759E+00, 1.5755554309E+00, 8.3321206187E-01],
	[2.2245000000E+04, 1.3824408051E+01, 5.3113328346E+00, 2.6752766403E+00, 1.5762786314E+00, 8.3329150570E-01],
	[2.2250000000E+04, 1.3829157409E+01, 5.3112421880E+00, 2.6772054606E+00, 1.5770018289E+00, 8.3337091517E-01],
	[2.2255000000E+04, 1.3833907331E+01, 5.3111515632E+00, 2.6791352370E+00, 1.5777250231E+00, 8.3345029028E-01],
	[2.2260000000E+04, 1.3838657817E+01, 5.3110609603E+00, 2.6810659696E+00, 1.5784482140E+00, 8.3352963105E-01],
	[2.2265000000E+04, 1.3843408866E+01, 5.3109703793E+00, 2.6829976589E+00, 1.5791714013E+00, 8.3360893748E-01],
	[2.2270000000E+04, 1.3848160480E+01, 5.3108798202E+00, 2.6849303049E+00, 1.5798945849E+00, 8.3368820958E-01],
	[2.2275000000E+04, 1.3852912657E+01, 5.3107892830E+00, 2.6868639081E+00, 1.5806177648E+00, 8.3376744736E-01],
	[2.2280000000E+04, 1.3857665397E+01, 5.3106987677E+00, 2.6887984686E+00, 1.5813409406E+00, 8.3384665082E-01],
	[2.2285000000E+04, 1.3862418701E+01, 5.3106082742E+00, 2.6907339867E+00, 1.5820641122E+00, 8.3392581998E-01],
	[2.2290000000E+04, 1.3867172569E+01, 5.3105178025E+00, 2.6926704627E+00, 1.5827872796E+00, 8.3400495485E-01],
	[2.2295000000E+04, 1.3871927000E+01, 5.3104273527E+00, 2.6946078968E+00, 1.5835104425E+00, 8.3408405543E-01],
	[2.2300000000E+04, 1.3876681995E+01, 5.3103369247E+00, 2.6965462893E+00, 1.5842336009E+00, 8.3416312173E-01],
	[2.2305000000E+04, 1.3881437553E+01, 5.3102465185E+00, 2.6984856405E+00, 1.5849567544E+00, 8.3424215376E-01],
	[2.2310000000E+04, 1.3886193674E+01, 5.3101561341E+00, 2.7004259505E+00, 1.5856799031E+00, 8.3432115153E-01],
	[2.2315000000E+04, 1.3890950358E+01, 5.3100657715E+00, 2.7023672197E+00, 1.5864030467E+00, 8.3440011506E-01],
	[2.2320000000E+04, 1.3895707606E+01, 5.3099754307E+00, 2.7043094484E+00, 1.5871261851E+00, 8.3447904433E-01],
	[2.2325000000E+04, 1.3900465417E+01, 5.3098851116E+00, 2.7062526367E+00, 1.5878493181E+00, 8.3455793937E-01],
	[2.2330000000E+04, 1.3905223790E+01, 5.3097948144E+00, 2.7081967849E+00, 1.5885724456E+00, 8.3463680019E-01],
	[2.2335000000E+04, 1.3909982727E+01, 5.3097045388E+00, 2.7101418933E+00, 1.5892955675E+00, 8.3471562679E-01],
	[2.2340000000E+04, 1.3914742227E+01, 5.3096142850E+00, 2.7120879622E+00, 1.5900186835E+00, 8.3479441918E-01],
	[2.2345000000E+04, 1.3919502289E+01, 5.3095240530E+00, 2.7140349918E+00, 1.5907417935E+00, 8.3487317738E-01],
	[2.2350000000E+04, 1.3924262914E+01, 5.3094338426E+00, 2.7159829824E+00, 1.5914648975E+00, 8.3495190138E-01],
	[2.2355000000E+04, 1.3929024102E+01, 5.3093436540E+00, 2.7179319342E+00, 1.5921879951E+00, 8.3503059120E-01],
	[2.2360000000E+04, 1.3933785853E+01, 5.3092534871E+00, 2.7198818475E+00, 1.5929110863E+00, 8.3510924685E-01],
	[2.2365000000E+04, 1.3938548166E+01, 5.3091633419E+00, 2.7218436549E+00, 1.5936379187E+00, 8.3518786833E-01],
	[2.2370000000E+04, 1.3943311042E+01, 5.3090732183E+00, 2.7238082184E+00, 1.5943653551E+00, 8.3526645566E-01],
	[2.2375000000E+04, 1.3948074481E+01, 5.3089831164E+00, 2.7257737596E+00, 1.5950927853E+00, 8.3534500884E-01],
	[2.2380000000E+04, 1.3952838481E+01, 5.3088930362E+00, 2.7277402786E+00, 1.5958202091E+00, 8.3542352788E-01],
	[2.2385000000E+04, 1.3957603045E+01, 5.3088029776E+00, 2.7297077759E+00, 1.5965476264E+00, 8.3550201280E-01],
	[2.2390000000E+04, 1.3962368170E+01, 5.3087129407E+00, 2.7316762516E+00, 1.5972750370E+00, 8.3558046360E-01],
	[2.2395000000E+04, 1.3967133858E+01, 5.3086229254E+00, 2.7336457061E+00, 1.5980024408E+00, 8.3565888028E-01],
	[2.2400000000E+04, 1.3971900108E+01, 5.3085329317E+00, 2.7356161396E+00, 1.5987298376E+00, 8.3573726286E-01],
	[2.2405000000E+04, 1.3976666920E+01, 5.3084429597E+00, 2.7375875523E+00, 1.5994572272E+00, 8.3581561135E-01],
	[2.2410000000E+04, 1.3981434294E+01, 5.3083530092E+00, 2.7395599446E+00, 1.6001846096E+00, 8.3589392576E-01],
	[2.2415000000E+04, 1.3986202231E+01, 5.3082630803E+00, 2.7415333166E+00, 1.6009119845E+00, 8.3597220609E-01],
	[2.2420000000E+04, 1.3990970729E+01, 5.3081731730E+00, 2.7435076688E+00, 1.6016393518E+00, 8.3605045236E-01],
	[2.2425000000E+04, 1.3995739789E+01, 5.3080832873E+00, 2.7454830013E+00, 1.6023667114E+00, 8.3612866457E-01],
	[2.2430000000E+04, 1.4000509411E+01, 5.3079934231E+00, 2.7474593143E+00, 1.6030940631E+00, 8.3620684273E-01],
	[2.2435000000E+04, 1.4005279595E+01, 5.3079035805E+00, 2.7494366083E+00, 1.6038214066E+00, 8.3628498685E-01],
	[2.2440000000E+04, 1.4010069683E+01, 5.3078175116E+00, 2.7514148834E+00, 1.6045493386E+00, 8.3636309694E-01],
	[2.2445000000E+04, 1.4014862904E+01, 5.3077319600E+00, 2.7533941399E+00, 1.6052773421E+00, 8.3644117301E-01],
	[2.2450000000E+04, 1.4019656696E+01, 5.3076464289E+00, 2.7553743781E+00, 1.6060053379E+00, 8.3651921507E-01],
	[2.2455000000E+04, 1.4024451060E+01, 5.3075609182E+00, 2.7573555982E+00, 1.6067333259E+00, 8.3659722312E-01],
	[2.2460000000E+04, 1.4029245995E+01, 5.3074754278E+00, 2.7593378005E+00, 1.6074613060E+00, 8.3667519718E-01],
	[2.2465000000E+04, 1.4034041502E+01, 5.3073899579E+00, 2.7613209853E+00, 1.6081892781E+00, 8.3675313726E-01],
	[2.2470000000E+04, 1.4038837581E+01, 5.3073045084E+00, 2.7633051529E+00, 1.6089172418E+00, 8.3683104336E-01],
	[2.2475000000E+04, 1.4043634230E+01, 5.3072190793E+00, 2.7652903034E+00, 1.6096451972E+00, 8.3690891550E-01],
	[2.2480000000E+04, 1.4048431451E+01, 5.3071336706E+00, 2.7672764373E+00, 1.6103731441E+00, 8.3698675368E-01],
	[2.2485000000E+04, 1.4053229244E+01, 5.3070482822E+00, 2.7692635547E+00, 1.6111010822E+00, 8.3706455791E-01],
	[2.2490000000E+04, 1.4058027607E+01, 5.3069629142E+00, 2.7712516559E+00, 1.6118290115E+00, 8.3714232820E-01],
	[2.2495000000E+04, 1.4062826542E+01, 5.3068775665E+00, 2.7732407411E+00, 1.6125569318E+00, 8.3722006456E-01],
	[2.2500000000E+04, 1.4067626048E+01, 5.3067922392E+00, 2.7752308108E+00, 1.6132848429E+00, 8.3729776700E-01],
	[2.2505000000E+04, 1.4072426125E+01, 5.3067069322E+00, 2.7772218650E+00, 1.6140127447E+00, 8.3737543553E-01],
	[2.2510000000E+04, 1.4077226773E+01, 5.3066216455E+00, 2.7792139042E+00, 1.6147406371E+00, 8.3745307016E-01],
	[2.2515000000E+04, 1.4082027992E+01, 5.3065363791E+00, 2.7812069285E+00, 1.6154685198E+00, 8.3753067089E-01],
	[2.2520000000E+04, 1.4086829781E+01, 5.3064511331E+00, 2.7832009382E+00, 1.6161963928E+00, 8.3760823774E-01],
	[2.2525000000E+04, 1.4091632142E+01, 5.3063659073E+00, 2.7851959336E+00, 1.6169242559E+00, 8.3768577072E-01],
	[2.2530000000E+04, 1.4096435073E+01, 5.3062807018E+00, 2.7871919149E+00, 1.6176521089E+00, 8.3776326983E-01],
	[2.2535000000E+04, 1.4101238575E+01, 5.3061955166E+00, 2.7891888825E+00, 1.6183799517E+00, 8.3784073508E-01],
	[2.2540000000E+04, 1.4106042647E+01, 5.3061103517E+00, 2.7911868366E+00, 1.6191077841E+00, 8.3791816649E-01],
	[2.2545000000E+04, 1.4110847290E+01, 5.3060252070E+00, 2.7931857774E+00, 1.6198356060E+00, 8.3799556406E-01],
	[2.2550000000E+04, 1.4115652504E+01, 5.3059400826E+00, 2.7951857053E+00, 1.6205634172E+00, 8.3807292780E-01],
	[2.2555000000E+04, 1.4120458288E+01, 5.3058549784E+00, 2.7971866204E+00, 1.6212912176E+00, 8.3815025772E-01],
	[2.2560000000E+04, 1.4125264643E+01, 5.3057698944E+00, 2.7991885232E+00, 1.6220190070E+00, 8.3822755384E-01],
	[2.2565000000E+04, 1.4130071567E+01, 5.3056848307E+00, 2.8011914137E+00, 1.6227467853E+00, 8.3830481615E-01],
	[2.2570000000E+04, 1.4134879062E+01, 5.3055997871E+00, 2.8031952923E+00, 1.6234745523E+00, 8.3838204467E-01],
	[2.2575000000E+04, 1.4139687128E+01, 5.3055147638E+00, 2.8052001594E+00, 1.6242023079E+00, 8.3845923941E-01],
	[2.2580000000E+04, 1.4144495763E+01, 5.3054297606E+00, 2.8072060150E+00, 1.6249300518E+00, 8.3853640038E-01],
	[2.2585000000E+04, 1.4149304969E+01, 5.3053447776E+00, 2.8092128595E+00, 1.6256577841E+00, 8.3861352759E-01],
	[2.2590000000E+04, 1.4154114744E+01, 5.3052598149E+00, 2.8112206933E+00, 1.6263855045E+00, 8.3869062103E-01],
	[2.2595000000E+04, 1.4158925090E+01, 5.3051748722E+00, 2.8132295164E+00, 1.6271132128E+00, 8.3876768073E-01],
	[2.2600000000E+04, 1.4163736005E+01, 5.3050899497E+00, 2.8152393293E+00, 1.6278409090E+00, 8.3884470668E-01],
	[2.2605000000E+04, 1.4168547491E+01, 5.3050050474E+00, 2.8172501321E+00, 1.6285685928E+00, 8.3892169889E-01],
	[2.2610000000E+04, 1.4173359546E+01, 5.3049201652E+00, 2.8192619252E+00, 1.6292962642E+00, 8.3899865738E-01],
	[2.2615000000E+04, 1.4178172171E+01, 5.3048353031E+00, 2.8212747088E+00, 1.6300239229E+00, 8.3907558214E-01],
	[2.2620000000E+04, 1.4182985365E+01, 5.3047504612E+00, 2.8232884831E+00, 1.6307515688E+00, 8.3915247319E-01],
	[2.2625000000E+04, 1.4187799129E+01, 5.3046656393E+00, 2.8253032485E+00, 1.6314792017E+00, 8.3922933054E-01],
	[2.2630000000E+04, 1.4192613463E+01, 5.3045808376E+00, 2.8273190052E+00, 1.6322068216E+00, 8.3930615418E-01],
	[2.2635000000E+04, 1.4197428367E+01, 5.3044960559E+00, 2.8293357535E+00, 1.6329344283E+00, 8.3938294414E-01],
	[2.2640000000E+04, 1.4202243839E+01, 5.3044112944E+00, 2.8313534937E+00, 1.6336620216E+00, 8.3945970041E-01],
	[2.2645000000E+04, 1.4207059881E+01, 5.3043265529E+00, 2.8333722259E+00, 1.6343896013E+00, 8.3953642301E-01],
	[2.2650000000E+04, 1.4211876493E+01, 5.3042418314E+00, 2.8353919506E+00, 1.6351171673E+00, 8.3961311194E-01],
	[2.2655000000E+04, 1.4216693674E+01, 5.3041571300E+00, 2.8374126679E+00, 1.6358447195E+00, 8.3968976721E-01],
	[2.2660000000E+04, 1.4221511424E+01, 5.3040724487E+00, 2.8394343781E+00, 1.6365722577E+00, 8.3976638882E-01],
	[2.2665000000E+04, 1.4226329743E+01, 5.3039877874E+00, 2.8414570815E+00, 1.6372997818E+00, 8.3984297679E-01],
	[2.2670000000E+04, 1.4231148631E+01, 5.3039031461E+00, 2.8434807784E+00, 1.6380272916E+00, 8.3991953112E-01],
	[2.2675000000E+04, 1.4235968088E+01, 5.3038185248E+00, 2.8455054690E+00, 1.6387547870E+00, 8.3999605183E-01],
	[2.2680000000E+04, 1.4240788115E+01, 5.3037339236E+00, 2.8475311536E+00, 1.6394822677E+00, 8.4007253891E-01],
	[2.2685000000E+04, 1.4245608710E+01, 5.3036493423E+00, 2.8495578324E+00, 1.6402097338E+00, 8.4014899237E-01],
	[2.2690000000E+04, 1.4250429874E+01, 5.3035647810E+00, 2.8515855058E+00, 1.6409371849E+00, 8.4022541223E-01],
	[2.2695000000E+04, 1.4255251607E+01, 5.3034802397E+00, 2.8536141739E+00, 1.6416646210E+00, 8.4030179849E-01],
	[2.2700000000E+04, 1.4260073909E+01, 5.3033957184E+00, 2.8556438372E+00, 1.6423920420E+00, 8.4037815116E-01],
	[2.2705000000E+04, 1.4264896779E+01, 5.3033112170E+00, 2.8576744957E+00, 1.6431194476E+00, 8.4045447024E-01],
	[2.2710000000E+04, 1.4269720218E+01, 5.3032267356E+00, 2.8597061499E+00, 1.6438468377E+00, 8.4053075575E-01],
	[2.2715000000E+04, 1.4274544226E+01, 5.3031422742E+00, 2.8617388000E+00, 1.6445742122E+00, 8.4060700770E-01],
	[2.2720000000E+04, 1.4279368802E+01, 5.3030578326E+00, 2.8637724461E+00, 1.6453015709E+00, 8.4068322608E-01],
	[2.2725000000E+04, 1.4284193946E+01, 5.3029734110E+00, 2.8658070887E+00, 1.6460289137E+00, 8.4075941091E-01],
	[2.2730000000E+04, 1.4289019659E+01, 5.3028890093E+00, 2.8678427280E+00, 1.6467562404E+00, 8.4083556219E-01],
	[2.2735000000E+04, 1.4293845941E+01, 5.3028046275E+00, 2.8698793642E+00, 1.6474835509E+00, 8.4091167994E-01],
	[2.2740000000E+04, 1.4298672790E+01, 5.3027202657E+00, 2.8719169976E+00, 1.6482108451E+00, 8.4098776417E-01],
	[2.2745000000E+04, 1.4303500208E+01, 5.3026359237E+00, 2.8739556285E+00, 1.6489381227E+00, 8.4106381487E-01],
	[2.2750000000E+04, 1.4308328194E+01, 5.3025516015E+00, 2.8759952571E+00, 1.6496653836E+00, 8.4113983205E-01],
	[2.2755000000E+04, 1.4313156748E+01, 5.3024672993E+00, 2.8780358838E+00, 1.6503926277E+00, 8.4121581574E-01],
	[2.2760000000E+04, 1.4317985870E+01, 5.3023830169E+00, 2.8800775087E+00, 1.6511198549E+00, 8.4129176592E-01],
	[2.2765000000E+04, 1.4322815561E+01, 5.3022987544E+00, 2.8821201322E+00, 1.6518470649E+00, 8.4136768262E-01],
	[2.2770000000E+04, 1.4327645819E+01, 5.3022145117E+00, 2.8841637545E+00, 1.6525742577E+00, 8.4144356584E-01],
	[2.2775000000E+04, 1.4332476645E+01, 5.3021302888E+00, 2.8862083759E+00, 1.6533014330E+00, 8.4151941558E-01],
	[2.2780000000E+04, 1.4337308039E+01, 5.3020460858E+00, 2.8882539967E+00, 1.6540285908E+00, 8.4159523186E-01],
	[2.2785000000E+04, 1.4342140000E+01, 5.3019619026E+00, 2.8903006171E+00, 1.6547557310E+00, 8.4167101469E-01],
	[2.2790000000E+04, 1.4346972530E+01, 5.3018777392E+00, 2.8923482374E+00, 1.6554828532E+00, 8.4174676406E-01],
	[2.2795000000E+04, 1.4351805627E+01, 5.3017935956E+00, 2.8943968578E+00, 1.6562099575E+00, 8.4182247999E-01],
	[2.2800000000E+04, 1.4356653603E+01, 5.3017121802E+00, 2.8964464787E+00, 1.6569374988E+00, 8.4189816250E-01],
	[2.2805000000E+04, 1.4361509978E+01, 5.3016322641E+00, 2.8984971003E+00, 1.6576652713E+00, 8.4197381157E-01],
	[2.2810000000E+04, 1.4366366930E+01, 5.3015523667E+00, 2.9005487228E+00, 1.6583930262E+00, 8.4204942723E-01],
	[2.2815000000E+04, 1.4371224459E+01, 5.3014724881E+00, 2.9026013466E+00, 1.6591207635E+00, 8.4212500949E-01],
	[2.2820000000E+04, 1.4376082566E+01, 5.3013926281E+00, 2.9046549719E+00, 1.6598484830E+00, 8.4220055834E-01],
	[2.2825000000E+04, 1.4380941251E+01, 5.3013127868E+00, 2.9067095989E+00, 1.6605761844E+00, 8.4227607380E-01],
	[2.2830000000E+04, 1.4385800513E+01, 5.3012329642E+00, 2.9087652280E+00, 1.6613038677E+00, 8.4235155588E-01],
	[2.2835000000E+04, 1.4390660352E+01, 5.3011531604E+00, 2.9108218594E+00, 1.6620315328E+00, 8.4242700458E-01],
	[2.2840000000E+04, 1.4395520768E+01, 5.3010733751E+00, 2.9128794934E+00, 1.6627591794E+00, 8.4250241992E-01],
	[2.2845000000E+04, 1.4400381761E+01, 5.3009936086E+00, 2.9149381302E+00, 1.6634868074E+00, 8.4257780189E-01],
	[2.2850000000E+04, 1.4405243332E+01, 5.3009138607E+00, 2.9169977702E+00, 1.6642144167E+00, 8.4265315052E-01],
	[2.2855000000E+04, 1.4410105479E+01, 5.3008341314E+00, 2.9190584135E+00, 1.6649420072E+00, 8.4272846580E-01],
	[2.2860000000E+04, 1.4414968204E+01, 5.3007544208E+00, 2.9211200605E+00, 1.6656695786E+00, 8.4280374775E-01],
	[2.2865000000E+04, 1.4419831505E+01, 5.3006747288E+00, 2.9231827114E+00, 1.6663971309E+00, 8.4287899637E-01],
	[2.2870000000E+04, 1.4424695384E+01, 5.3005950554E+00, 2.9252463665E+00, 1.6671246638E+00, 8.4295421168E-01],
	[2.2875000000E+04, 1.4429559839E+01, 5.3005154007E+00, 2.9273110260E+00, 1.6678521774E+00, 8.4302939367E-01],
	[2.2880000000E+04, 1.4434424871E+01, 5.3004357646E+00, 2.9293766903E+00, 1.6685796713E+00, 8.4310454237E-01],
	[2.2885000000E+04, 1.4439290479E+01, 5.3003561470E+00, 2.9314433596E+00, 1.6693071455E+00, 8.4317965777E-01],
	[2.2890000000E+04, 1.4444156665E+01, 5.3002765481E+00, 2.9335110341E+00, 1.6700345997E+00, 8.4325473988E-01],
	[2.2895000000E+04, 1.4449023427E+01, 5.3001969677E+00, 2.9355797142E+00, 1.6707620340E+00, 8.4332978873E-01],
	[2.2900000000E+04, 1.4453890765E+01, 5.3001174059E+00, 2.9376494001E+00, 1.6714894481E+00, 8.4340480430E-01],
	[2.2905000000E+04, 1.4458758680E+01, 5.3000378626E+00, 2.9397200920E+00, 1.6722168418E+00, 8.4347978661E-01],
	[2.2910000000E+04, 1.4463627171E+01, 5.2999583379E+00, 2.9417917903E+00, 1.6729442151E+00, 8.4355473568E-01],
	[2.2915000000E+04, 1.4468496239E+01, 5.2998788318E+00, 2.9438644952E+00, 1.6736715678E+00, 8.4362965150E-01],
	[2.2920000000E+04, 1.4473365882E+01, 5.2997993442E+00, 2.9459382070E+00, 1.6743988997E+00, 8.4370453409E-01],
	[2.2925000000E+04, 1.4478236103E+01, 5.2997198751E+00, 2.9480129259E+00, 1.6751262106E+00, 8.4377938345E-01],
	[2.2930000000E+04, 1.4483106899E+01, 5.2996404246E+00, 2.9500886522E+00, 1.6758535006E+00, 8.4385419960E-01],
	[2.2935000000E+04, 1.4487978271E+01, 5.2995609926E+00, 2.9521653862E+00, 1.6765807693E+00, 8.4392898253E-01],
	[2.2940000000E+04, 1.4492850220E+01, 5.2994815790E+00, 2.9542431281E+00, 1.6773080167E+00, 8.4400373227E-01],
	[2.2945000000E+04, 1.4497722744E+01, 5.2994021840E+00, 2.9563218783E+00, 1.6780352426E+00, 8.4407844881E-01],
	[2.2950000000E+04, 1.4502595845E+01, 5.2993228074E+00, 2.9584016370E+00, 1.6787624469E+00, 8.4415313218E-01],
	[2.2955000000E+04, 1.4507469521E+01, 5.2992434494E+00, 2.9604824044E+00, 1.6794896294E+00, 8.4422778237E-01],
	[2.2960000000E+04, 1.4512343773E+01, 5.2991641098E+00, 2.9625641809E+00, 1.6802167900E+00, 8.4430239939E-01],
	[2.2965000000E+04, 1.4517218601E+01, 5.2990847887E+00, 2.9646469666E+00, 1.6809439285E+00, 8.4437698325E-01],
	[2.2970000000E+04, 1.4522094005E+01, 5.2990054860E+00, 2.9667307619E+00, 1.6816710448E+00, 8.4445153397E-01],
	[2.2975000000E+04, 1.4526969984E+01, 5.2989262018E+00, 2.9688155670E+00, 1.6823981387E+00, 8.4452605154E-01],
	[2.2980000000E+04, 1.4531846539E+01, 5.2988469360E+00, 2.9709013823E+00, 1.6831252102E+00, 8.4460053599E-01],
	[2.2985000000E+04, 1.4536723669E+01, 5.2987676886E+00, 2.9729882079E+00, 1.6838522590E+00, 8.4467498731E-01],
	[2.2990000000E+04, 1.4541601375E+01, 5.2986884597E+00, 2.9750760442E+00, 1.6845792850E+00, 8.4474940552E-01],
	[2.2995000000E+04, 1.4546479657E+01, 5.2986092491E+00, 2.9771648913E+00, 1.6853062881E+00, 8.4482379062E-01],
	[2.3000000000E+04, 1.4551358514E+01, 5.2985300570E+00, 2.9792547496E+00, 1.6860332681E+00, 8.4489814263E-01],
	[2.3005000000E+04, 1.4556237946E+01, 5.2984508833E+00, 2.9813456194E+00, 1.6867602249E+00, 8.4497246154E-01],
	[2.3010000000E+04, 1.4561117953E+01, 5.2983717280E+00, 2.9834375009E+00, 1.6874871583E+00, 8.4504674738E-01],
	[2.3015000000E+04, 1.4565998535E+01, 5.2982925910E+00, 2.9855303944E+00, 1.6882140682E+00, 8.4512100015E-01],
	[2.3020000000E+04, 1.4570879693E+01, 5.2982134724E+00, 2.9876243001E+00, 1.6889409545E+00, 8.4519521985E-01],
	[2.3025000000E+04, 1.4575761426E+01, 5.2981343722E+00, 2.9897192184E+00, 1.6896678170E+00, 8.4526940650E-01],
	[2.3030000000E+04, 1.4580643734E+01, 5.2980552904E+00, 2.9918151494E+00, 1.6903946555E+00, 8.4534356011E-01],
	[2.3035000000E+04, 1.4585526617E+01, 5.2979762268E+00, 2.9939120935E+00, 1.6911214700E+00, 8.4541768068E-01],
	[2.3040000000E+04, 1.4590410074E+01, 5.2978971817E+00, 2.9960100510E+00, 1.6918482602E+00, 8.4549176822E-01],
	[2.3045000000E+04, 1.4595294107E+01, 5.2978181548E+00, 2.9981090220E+00, 1.6925750260E+00, 8.4556582275E-01],
	[2.3050000000E+04, 1.4600178714E+01, 5.2977391463E+00, 3.0002090069E+00, 1.6933017674E+00, 8.4563984426E-01],
	[2.3055000000E+04, 1.4605063896E+01, 5.2976601561E+00, 3.0023100059E+00, 1.6940284841E+00, 8.4571383278E-01],
	[2.3060000000E+04, 1.4609949653E+01, 5.2975811842E+00, 3.0044120194E+00, 1.6947551760E+00, 8.4578778830E-01],
	[2.3065000000E+04, 1.4614835985E+01, 5.2975022306E+00, 3.0065150475E+00, 1.6954818429E+00, 8.4586171084E-01],
	[2.3070000000E+04, 1.4619722891E+01, 5.2974232953E+00, 3.0086190906E+00, 1.6962084848E+00, 8.4593560041E-01],
	[2.3075000000E+04, 1.4624610371E+01, 5.2973443783E+00, 3.0107241488E+00, 1.6969351015E+00, 8.4600945701E-01],
	[2.3080000000E+04, 1.4629498426E+01, 5.2972654795E+00, 3.0128302226E+00, 1.6976616927E+00, 8.4608328065E-01],
	[2.3085000000E+04, 1.4634387056E+01, 5.2971865990E+00, 3.0149373121E+00, 1.6983882585E+00, 8.4615707135E-01],
	[2.3090000000E+04, 1.4639276259E+01, 5.2971077368E+00, 3.0170454176E+00, 1.6991147986E+00, 8.4623082911E-01],
	[2.3095000000E+04, 1.4644166037E+01, 5.2970288928E+00, 3.0191545394E+00, 1.6998413130E+00, 8.4630455394E-01],
	[2.3100000000E+04, 1.4649056390E+01, 5.2969500671E+00, 3.0212646778E+00, 1.7005678013E+00, 8.4637824585E-01],
	[2.3105000000E+04, 1.4653947316E+01, 5.2968712595E+00, 3.0233758330E+00, 1.7012942636E+00, 8.4645190484E-01],
	[2.3110000000E+04, 1.4658838817E+01, 5.2967924703E+00, 3.0254880052E+00, 1.7020206997E+00, 8.4652553094E-01],
	[2.3115000000E+04, 1.4663730891E+01, 5.2967136992E+00, 3.0276011949E+00, 1.7027471094E+00, 8.4659912414E-01],
	[2.3120000000E+04, 1.4668623540E+01, 5.2966349463E+00, 3.0297154022E+00, 1.7034734927E+00, 8.4667268445E-01],
	[2.3125000000E+04, 1.4673516763E+01, 5.2965562117E+00, 3.0318306274E+00, 1.7041998492E+00, 8.4674621189E-01],
	[2.3130000000E+04, 1.4678410559E+01, 5.2964774952E+00, 3.0339468707E+00, 1.7049261790E+00, 8.4681970646E-01],
	[2.3135000000E+04, 1.4683304929E+01, 5.2963987969E+00, 3.0360641326E+00, 1.7056524818E+00, 8.4689316818E-01],
	[2.3140000000E+04, 1.4688199874E+01, 5.2963201168E+00, 3.0381824131E+00, 1.7063787576E+00, 8.4696659704E-01],
	[2.3145000000E+04, 1.4693095391E+01, 5.2962414548E+00, 3.0403017126E+00, 1.7071050062E+00, 8.4703999307E-01],
	[2.3150000000E+04, 1.4697991483E+01, 5.2961628111E+00, 3.0424220313E+00, 1.7078312274E+00, 8.4711335627E-01],
	[2.3155000000E+04, 1.4702888148E+01, 5.2960841854E+00, 3.0445433696E+00, 1.7085574211E+00, 8.4718668664E-01],
	[2.3160000000E+04, 1.4707785387E+01, 5.2960055779E+00, 3.0466657277E+00, 1.7092835871E+00, 8.4725998420E-01],
	[2.3165000000E+04, 1.4712688729E+01, 5.2959280095E+00, 3.0487891058E+00, 1.7100099066E+00, 8.4733324896E-01],
	[2.3170000000E+04, 1.4717609489E+01, 5.2958535674E+00, 3.0509135042E+00, 1.7107367502E+00, 8.4740648092E-01],
	[2.3175000000E+04, 1.4722530833E+01, 5.2957791424E+00, 3.0530389232E+00, 1.7114635667E+00, 8.4747968010E-01],
	[2.3180000000E+04, 1.4727452760E+01, 5.2957047345E+00, 3.0551653632E+00, 1.7121903559E+00, 8.4755284651E-01],
	[2.3185000000E+04, 1.4732375271E+01, 5.2956303437E+00, 3.0572928242E+00, 1.7129171177E+00, 8.4762598014E-01],
	[2.3190000000E+04, 1.4737298365E+01, 5.2955559699E+00, 3.0594213066E+00, 1.7136438518E+00, 8.4769908102E-01],
	[2.3195000000E+04, 1.4742222042E+01, 5.2954816133E+00, 3.0615508108E+00, 1.7143705582E+00, 8.4777214915E-01],
	[2.3200000000E+04, 1.4747146302E+01, 5.2954072737E+00, 3.0636813368E+00, 1.7150972368E+00, 8.4784518454E-01],
	[2.3205000000E+04, 1.4752071146E+01, 5.2953329511E+00, 3.0658128851E+00, 1.7158238874E+00, 8.4791818720E-01],
	[2.3210000000E+04, 1.4756996573E+01, 5.2952586457E+00, 3.0679454559E+00, 1.7165505098E+00, 8.4799115714E-01],
	[2.3215000000E+04, 1.4761922582E+01, 5.2951843572E+00, 3.0700790494E+00, 1.7172771039E+00, 8.4806409437E-01],
	[2.3220000000E+04, 1.4766849175E+01, 5.2951100859E+00, 3.0722136659E+00, 1.7180036696E+00, 8.4813699890E-01],
	[2.3225000000E+04, 1.4771776351E+01, 5.2950358315E+00, 3.0743493057E+00, 1.7187302067E+00, 8.4820987073E-01],
	[2.3230000000E+04, 1.4776704109E+01, 5.2949615942E+00, 3.0764859691E+00, 1.7194567152E+00, 8.4828270988E-01],
	[2.3235000000E+04, 1.4781632450E+01, 5.2948873739E+00, 3.0786236563E+00, 1.7201831947E+00, 8.4835551635E-01],
	[2.3240000000E+04, 1.4786561374E+01, 5.2948131706E+00, 3.0807623676E+00, 1.7209096453E+00, 8.4842829016E-01],
	[2.3245000000E+04, 1.4791490881E+01, 5.2947389843E+00, 3.0829021033E+00, 1.7216360668E+00, 8.4850103132E-01],
	[2.3250000000E+04, 1.4796420970E+01, 5.2946648150E+00, 3.0850428636E+00, 1.7223624590E+00, 8.4857373982E-01],
	[2.3255000000E+04, 1.4801351642E+01, 5.2945906627E+00, 3.0871846489E+00, 1.7230888218E+00, 8.4864641569E-01],
	[2.3260000000E+04, 1.4806282896E+01, 5.2945165273E+00, 3.0893274593E+00, 1.7238151550E+00, 8.4871905894E-01],
	[2.3265000000E+04, 1.4811214733E+01, 5.2944424090E+00, 3.0914712951E+00, 1.7245414586E+00, 8.4879166956E-01],
	[2.3270000000E+04, 1.4816147152E+01, 5.2943683076E+00, 3.0936161567E+00, 1.7252677323E+00, 8.4886424757E-01],
	[2.3275000000E+04, 1.4821080154E+01, 5.2942942231E+00, 3.0957620442E+00, 1.7259939761E+00, 8.4893679299E-01],
	[2.3280000000E+04, 1.4826013738E+01, 5.2942201557E+00, 3.0979089581E+00, 1.7267201897E+00, 8.4900930581E-01],
	[2.3285000000E+04, 1.4830947904E+01, 5.2941461051E+00, 3.1000568984E+00, 1.7274463732E+00, 8.4908178605E-01],
	[2.3290000000E+04, 1.4835882652E+01, 5.2940720715E+00, 3.1022058655E+00, 1.7281725262E+00, 8.4915423372E-01],
	[2.3295000000E+04, 1.4840817983E+01, 5.2939980548E+00, 3.1043558597E+00, 1.7288986487E+00, 8.4922664883E-01],
	[2.3300000000E+04, 1.4845753895E+01, 5.2939240550E+00, 3.1065068812E+00, 1.7296247406E+00, 8.4929903139E-01],
	[2.3305000000E+04, 1.4850690390E+01, 5.2938500722E+00, 3.1086589304E+00, 1.7303508017E+00, 8.4937138140E-01],
	[2.3310000000E+04, 1.4855627466E+01, 5.2937761062E+00, 3.1108120074E+00, 1.7310768318E+00, 8.4944369888E-01],
	[2.3315000000E+04, 1.4860565125E+01, 5.2937021572E+00, 3.1129661125E+00, 1.7318028309E+00, 8.4951598383E-01],
	[2.3320000000E+04, 1.4865503365E+01, 5.2936282250E+00, 3.1151212461E+00, 1.7325287988E+00, 8.4958823627E-01],
	[2.3325000000E+04, 1.4870442187E+01, 5.2935543097E+00, 3.1172774084E+00, 1.7332547353E+00, 8.4966045620E-01],
	[2.3330000000E+04, 1.4875381591E+01, 5.2934804113E+00, 3.1194345996E+00, 1.7339806403E+00, 8.4973264364E-01],
	[2.3335000000E+04, 1.4880321576E+01, 5.2934065298E+00, 3.1215928200E+00, 1.7347065137E+00, 8.4980479859E-01],
	[2.3340000000E+04, 1.4885262143E+01, 5.2933326651E+00, 3.1237520699E+00, 1.7354323553E+00, 8.4987692106E-01],
	[2.3345000000E+04, 1.4890203292E+01, 5.2932588173E+00, 3.1259123496E+00, 1.7361581651E+00, 8.4994901107E-01],
	[2.3350000000E+04, 1.4895145022E+01, 5.2931849863E+00, 3.1280736593E+00, 1.7368839428E+00, 8.5002106862E-01],
	[2.3355000000E+04, 1.4900087334E+01, 5.2931111722E+00, 3.1302359993E+00, 1.7376096883E+00, 8.5009309372E-01],
	[2.3360000000E+04, 1.4905030226E+01, 5.2930373749E+00, 3.1323993699E+00, 1.7383354015E+00, 8.5016508638E-01],
	[2.3365000000E+04, 1.4909973701E+01, 5.2929635944E+00, 3.1345637713E+00, 1.7390610822E+00, 8.5023704661E-01],
	[2.3370000000E+04, 1.4914917756E+01, 5.2928898307E+00, 3.1367292038E+00, 1.7397867304E+00, 8.5030897443E-01],
	[2.3375000000E+04, 1.4919862393E+01, 5.2928160838E+00, 3.1388956677E+00, 1.7405123458E+00, 8.5038086983E-01],
	[2.3380000000E+04, 1.4924807611E+01, 5.2927423538E+00, 3.1410631633E+00, 1.7412379284E+00, 8.5045273283E-01],
	[2.3385000000E+04, 1.4929753410E+01, 5.2926686405E+00, 3.1432316908E+00, 1.7419634779E+00, 8.5052456344E-01],
	[2.3390000000E+04, 1.4934699790E+01, 5.2925949440E+00, 3.1454012505E+00, 1.7426889944E+00, 8.5059636167E-01],
	[2.3395000000E+04, 1.4939646752E+01, 5.2925212643E+00, 3.1475718426E+00, 1.7434144775E+00, 8.5066812753E-01],
	[2.3400000000E+04, 1.4944594294E+01, 5.2924476013E+00, 3.1497434675E+00, 1.7441399273E+00, 8.5073986103E-01],
	[2.3405000000E+04, 1.4949542417E+01, 5.2923739552E+00, 3.1519161253E+00, 1.7448653434E+00, 8.5081156218E-01],
	[2.3410000000E+04, 1.4954491121E+01, 5.2923003257E+00, 3.1540898165E+00, 1.7455907259E+00, 8.5088323098E-01],
	[2.3415000000E+04, 1.4959440405E+01, 5.2922267131E+00, 3.1562645412E+00, 1.7463160746E+00, 8.5095486745E-01],
	[2.3420000000E+04, 1.4964390271E+01, 5.2921531171E+00, 3.1584402996E+00, 1.7470413893E+00, 8.5102647160E-01],
	[2.3425000000E+04, 1.4969340717E+01, 5.2920795379E+00, 3.1606170922E+00, 1.7477666700E+00, 8.5109804344E-01],
	[2.3430000000E+04, 1.4974291743E+01, 5.2920059754E+00, 3.1627949191E+00, 1.7484919163E+00, 8.5116958297E-01],
	[2.3435000000E+04, 1.4979243350E+01, 5.2919324297E+00, 3.1649737807E+00, 1.7492171284E+00, 8.5124109020E-01],
	[2.3440000000E+04, 1.4984195538E+01, 5.2918589007E+00, 3.1671536771E+00, 1.7499423059E+00, 8.5131256516E-01],
	[2.3445000000E+04, 1.4989148306E+01, 5.2917853883E+00, 3.1693346087E+00, 1.7506674487E+00, 8.5138400784E-01],
	[2.3450000000E+04, 1.4994101655E+01, 5.2917118927E+00, 3.1715165757E+00, 1.7513925568E+00, 8.5145541825E-01],
	[2.3455000000E+04, 1.4999055584E+01, 5.2916384137E+00, 3.1736995784E+00, 1.7521176300E+00, 8.5152679641E-01],
	[2.3460000000E+04, 1.5004010093E+01, 5.2915649514E+00, 3.1758836171E+00, 1.7528426681E+00, 8.5159814233E-01],
	[2.3465000000E+04, 1.5008965182E+01, 5.2914915059E+00, 3.1780686920E+00, 1.7535676711E+00, 8.5166945601E-01],
	[2.3470000000E+04, 1.5013920852E+01, 5.2914180769E+00, 3.1802548035E+00, 1.7542926387E+00, 8.5174073746E-01],
	[2.3475000000E+04, 1.5018877101E+01, 5.2913446647E+00, 3.1824419517E+00, 1.7550175709E+00, 8.5181198670E-01],
	[2.3480000000E+04, 1.5023833931E+01, 5.2912712690E+00, 3.1846301370E+00, 1.7557424674E+00, 8.5188320373E-01],
	[2.3485000000E+04, 1.5028791340E+01, 5.2911978901E+00, 3.1868193596E+00, 1.7564673283E+00, 8.5195438857E-01],
	[2.3490000000E+04, 1.5033749330E+01, 5.2911245277E+00, 3.1890096198E+00, 1.7571921533E+00, 8.5202554122E-01],
	[2.3495000000E+04, 1.5038707900E+01, 5.2910511820E+00, 3.1912009178E+00, 1.7579169423E+00, 8.5209666170E-01],
	[2.3500000000E+04, 1.5043667049E+01, 5.2909778530E+00, 3.1933932540E+00, 1.7586416951E+00, 8.5216775001E-01],
	[2.3505000000E+04, 1.5048626778E+01, 5.2909045405E+00, 3.1955866286E+00, 1.7593664117E+00, 8.5223880616E-01],
	[2.3510000000E+04, 1.5053587087E+01, 5.2908312446E+00, 3.1977810418E+00, 1.7600910919E+00, 8.5230983017E-01],
	[2.3515000000E+04, 1.5058547975E+01, 5.2907579654E+00, 3.1999764940E+00, 1.7608157355E+00, 8.5238082204E-01],
	[2.3520000000E+04, 1.5063509444E+01, 5.2906847027E+00, 3.2021729854E+00, 1.7615403425E+00, 8.5245178179E-01],
	[2.3525000000E+04, 1.5068471491E+01, 5.2906114567E+00, 3.2043705163E+00, 1.7622649126E+00, 8.5252270941E-01],
	[2.3530000000E+04, 1.5073434118E+01, 5.2905382272E+00, 3.2065690869E+00, 1.7629894459E+00, 8.5259360493E-01],
	[2.3535000000E+04, 1.5078397325E+01, 5.2904650143E+00, 3.2087686976E+00, 1.7637139420E+00, 8.5266446836E-01],
	[2.3540000000E+04, 1.5083376175E+01, 5.2903945302E+00, 3.2109693485E+00, 1.7644389088E+00, 8.5273529970E-01],
	[2.3545000000E+04, 1.5088363161E+01, 5.2903254209E+00, 3.2131710400E+00, 1.7651640934E+00, 8.5280609896E-01],
	[2.3550000000E+04, 1.5093350736E+01, 5.2902563272E+00, 3.2153737724E+00, 1.7658892414E+00, 8.5287686615E-01],
	[2.3555000000E+04, 1.5098338900E+01, 5.2901872491E+00, 3.2175775459E+00, 1.7666143527E+00, 8.5294760129E-01],
	[2.3560000000E+04, 1.5103327654E+01, 5.2901181865E+00, 3.2197823607E+00, 1.7673394272E+00, 8.5301830438E-01],
	[2.3565000000E+04, 1.5108316997E+01, 5.2900491394E+00, 3.2219882172E+00, 1.7680644647E+00, 8.5308897543E-01],
	[2.3570000000E+04, 1.5113306929E+01, 5.2899801080E+00, 3.2241951155E+00, 1.7687894651E+00, 8.5315961446E-01],
	[2.3575000000E+04, 1.5118297450E+01, 5.2899110920E+00, 3.2264030561E+00, 1.7695144282E+00, 8.5323022147E-01],
	[2.3580000000E+04, 1.5123288561E+01, 5.2898420916E+00, 3.2286120391E+00, 1.7702393539E+00, 8.5330079647E-01],
	[2.3585000000E+04, 1.5128280260E+01, 5.2897731067E+00, 3.2308220649E+00, 1.7709642421E+00, 8.5337133948E-01],
	[2.3590000000E+04, 1.5133272548E+01, 5.2897041374E+00, 3.2330331336E+00, 1.7716890927E+00, 8.5344185050E-01],
	[2.3595000000E+04, 1.5138265425E+01, 5.2896351835E+00, 3.2352452457E+00, 1.7724139055E+00, 8.5351232954E-01],
	[2.3600000000E+04, 1.5143258891E+01, 5.2895662452E+00, 3.2374584012E+00, 1.7731386803E+00, 8.5358277662E-01],
	[2.3605000000E+04, 1.5148252946E+01, 5.2894973224E+00, 3.2396726006E+00, 1.7738634171E+00, 8.5365319174E-01],
	[2.3610000000E+04, 1.5153247589E+01, 5.2894284150E+00, 3.2418878440E+00, 1.7745881157E+00, 8.5372357491E-01],
	[2.3615000000E+04, 1.5158242822E+01, 5.2893595232E+00, 3.2441041318E+00, 1.7753127760E+00, 8.5379392615E-01],
	[2.3620000000E+04, 1.5163238642E+01, 5.2892906468E+00, 3.2463214642E+00, 1.7760373979E+00, 8.5386424546E-01],
	[2.3625000000E+04, 1.5168235052E+01, 5.2892217859E+00, 3.2485398415E+00, 1.7767619812E+00, 8.5393453286E-01],
	[2.3630000000E+04, 1.5173232049E+01, 5.2891529405E+00, 3.2507592640E+00, 1.7774865257E+00, 8.5400478835E-01],
	[2.3635000000E+04, 1.5178229636E+01, 5.2890841106E+00, 3.2529797319E+00, 1.7782110314E+00, 8.5407501194E-01],
	[2.3640000000E+04, 1.5183227810E+01, 5.2890152961E+00, 3.2552012454E+00, 1.7789354981E+00, 8.5414520365E-01],
	[2.3645000000E+04, 1.5188226573E+01, 5.2889464970E+00, 3.2574238050E+00, 1.7796599257E+00, 8.5421536349E-01],
	[2.3650000000E+04, 1.5193225925E+01, 5.2888777134E+00, 3.2596474108E+00, 1.7803843141E+00, 8.5428549146E-01],
	[2.3655000000E+04, 1.5198225864E+01, 5.2888089452E+00, 3.2618720631E+00, 1.7811086630E+00, 8.5435558757E-01],
	[2.3660000000E+04, 1.5203226392E+01, 5.2887401925E+00, 3.2640977622E+00, 1.7818329725E+00, 8.5442565184E-01],
	[2.3665000000E+04, 1.5208227508E+01, 5.2886714551E+00, 3.2663245084E+00, 1.7825572423E+00, 8.5449568428E-01],
	[2.3670000000E+04, 1.5213229212E+01, 5.2886027332E+00, 3.2685523018E+00, 1.7832814724E+00, 8.5456568489E-01],
	[2.3675000000E+04, 1.5218231503E+01, 5.2885340267E+00, 3.2707811429E+00, 1.7840056625E+00, 8.5463565368E-01],
	[2.3680000000E+04, 1.5223234383E+01, 5.2884653356E+00, 3.2730110319E+00, 1.7847298126E+00, 8.5470559068E-01],
	[2.3685000000E+04, 1.5228237851E+01, 5.2883966599E+00, 3.2752419689E+00, 1.7854539225E+00, 8.5477549588E-01],
	[2.3690000000E+04, 1.5233241907E+01, 5.2883279996E+00, 3.2774739544E+00, 1.7861779921E+00, 8.5484536929E-01],
	[2.3695000000E+04, 1.5238246550E+01, 5.2882593546E+00, 3.2797069886E+00, 1.7869020213E+00, 8.5491521094E-01],
	[2.3700000000E+04, 1.5243251781E+01, 5.2881907251E+00, 3.2819410717E+00, 1.7876260099E+00, 8.5498502082E-01],
	[2.3705000000E+04, 1.5248257600E+01, 5.2881221109E+00, 3.2841762040E+00, 1.7883499578E+00, 8.5505479894E-01],
	[2.3710000000E+04, 1.5253264006E+01, 5.2880535120E+00, 3.2864123858E+00, 1.7890738649E+00, 8.5512454533E-01],
	[2.3715000000E+04, 1.5258271000E+01, 5.2879849286E+00, 3.2886496174E+00, 1.7897977311E+00, 8.5519425998E-01],
	[2.3720000000E+04, 1.5263278582E+01, 5.2879163604E+00, 3.2908878990E+00, 1.7905215561E+00, 8.5526394292E-01],
	[2.3725000000E+04, 1.5268286751E+01, 5.2878478076E+00, 3.2931272309E+00, 1.7912453399E+00, 8.5533359414E-01],
	[2.3730000000E+04, 1.5273295507E+01, 5.2877792702E+00, 3.2953676134E+00, 1.7919690824E+00, 8.5540321366E-01],
	[2.3735000000E+04, 1.5278304851E+01, 5.2877107480E+00, 3.2976090467E+00, 1.7926927833E+00, 8.5547280149E-01],
	[2.3740000000E+04, 1.5283314782E+01, 5.2876422412E+00, 3.2998515311E+00, 1.7934164427E+00, 8.5554235764E-01],
	[2.3745000000E+04, 1.5288325300E+01, 5.2875737497E+00, 3.3020950669E+00, 1.7941400603E+00, 8.5561188211E-01],
	[2.3750000000E+04, 1.5293336405E+01, 5.2875052735E+00, 3.3043396544E+00, 1.7948636360E+00, 8.5568137493E-01],
	[2.3755000000E+04, 1.5298348098E+01, 5.2874368126E+00, 3.3065852938E+00, 1.7955871698E+00, 8.5575083610E-01],
	[2.3760000000E+04, 1.5303360378E+01, 5.2873683670E+00, 3.3088319854E+00, 1.7963106614E+00, 8.5582026564E-01],
	[2.3765000000E+04, 1.5308373244E+01, 5.2872999367E+00, 3.3110797295E+00, 1.7970341107E+00, 8.5588966354E-01],
	[2.3770000000E+04, 1.5313386698E+01, 5.2872315217E+00, 3.3133285263E+00, 1.7977575176E+00, 8.5595902982E-01],
	[2.3775000000E+04, 1.5318400738E+01, 5.2871631220E+00, 3.3155783761E+00, 1.7984808820E+00, 8.5602836450E-01],
	[2.3780000000E+04, 1.5323415366E+01, 5.2870947375E+00, 3.3178292792E+00, 1.7992042037E+00, 8.5609766758E-01],
	[2.3785000000E+04, 1.5328430580E+01, 5.2870263682E+00, 3.3200812358E+00, 1.7999274827E+00, 8.5616693908E-01],
	[2.3790000000E+04, 1.5333446381E+01, 5.2869580143E+00, 3.3223342463E+00, 1.8006507187E+00, 8.5623617899E-01],
	[2.3795000000E+04, 1.5338462768E+01, 5.2868896756E+00, 3.3245883109E+00, 1.8013739117E+00, 8.5630538734E-01],
	[2.3800000000E+04, 1.5343479743E+01, 5.2868213521E+00, 3.3268434298E+00, 1.8020970615E+00, 8.5637456414E-01],
	[2.3805000000E+04, 1.5348497303E+01, 5.2867530438E+00, 3.3290996034E+00, 1.8028201680E+00, 8.5644370939E-01],
	[2.3810000000E+04, 1.5353515451E+01, 5.2866847508E+00, 3.3313568318E+00, 1.8035432310E+00, 8.5651282310E-01],
	[2.3815000000E+04, 1.5358534185E+01, 5.2866164730E+00, 3.3336151155E+00, 1.8042662505E+00, 8.5658190528E-01],
	[2.3820000000E+04, 1.5363553505E+01, 5.2865482104E+00, 3.3358744546E+00, 1.8049892263E+00, 8.5665095594E-01],
	[2.3825000000E+04, 1.5368573411E+01, 5.2864799631E+00, 3.3381348494E+00, 1.8057121582E+00, 8.5671997509E-01],
	[2.3830000000E+04, 1.5373593904E+01, 5.2864117309E+00, 3.3403963002E+00, 1.8064350463E+00, 8.5678896274E-01],
	[2.3835000000E+04, 1.5378614984E+01, 5.2863435139E+00, 3.3426588072E+00, 1.8071578902E+00, 8.5685791889E-01],
	[2.3840000000E+04, 1.5383636649E+01, 5.2862753121E+00, 3.3449223708E+00, 1.8078806899E+00, 8.5692684356E-01],
	[2.3845000000E+04, 1.5388658900E+01, 5.2862071255E+00, 3.3471869912E+00, 1.8086034453E+00, 8.5699573675E-01],
	[2.3850000000E+04, 1.5393681738E+01, 5.2861389541E+00, 3.3494526687E+00, 1.8093261562E+00, 8.5706459847E-01],
	[2.3855000000E+04, 1.5398705162E+01, 5.2860707979E+00, 3.3517194035E+00, 1.8100488224E+00, 8.5713342873E-01],
	[2.3860000000E+04, 1.5403729171E+01, 5.2860026568E+00, 3.3539871959E+00, 1.8107714440E+00, 8.5720222754E-01],
	[2.3865000000E+04, 1.5408753767E+01, 5.2859345308E+00, 3.3562560462E+00, 1.8114940207E+00, 8.5727099492E-01],
	[2.3870000000E+04, 1.5413778948E+01, 5.2858664200E+00, 3.3585259547E+00, 1.8122165525E+00, 8.5733973086E-01],
	[2.3875000000E+04, 1.5418804716E+01, 5.2857983244E+00, 3.3607969216E+00, 1.8129390391E+00, 8.5740843537E-01],
	[2.3880000000E+04, 1.5423831069E+01, 5.2857302439E+00, 3.3630689472E+00, 1.8136614804E+00, 8.5747710847E-01],
	[2.3885000000E+04, 1.5428858007E+01, 5.2856621785E+00, 3.3653420318E+00, 1.8143838765E+00, 8.5754575017E-01],
	[2.3890000000E+04, 1.5433885532E+01, 5.2855941282E+00, 3.3676161756E+00, 1.8151062270E+00, 8.5761436047E-01],
	[2.3895000000E+04, 1.5438913642E+01, 5.2855260931E+00, 3.3698913789E+00, 1.8158285318E+00, 8.5768293938E-01],
	[2.3900000000E+04, 1.5443942337E+01, 5.2854580731E+00, 3.3721676420E+00, 1.8165507910E+00, 8.5775148691E-01],
	[2.3905000000E+04, 1.5448971618E+01, 5.2853900681E+00, 3.3744449652E+00, 1.8172730042E+00, 8.5782000308E-01],
	[2.3910000000E+04, 1.5454001485E+01, 5.2853220783E+00, 3.3767233487E+00, 1.8179951714E+00, 8.5788848788E-01],
	[2.3915000000E+04, 1.5459031937E+01, 5.2852541036E+00, 3.3790027928E+00, 1.8187172925E+00, 8.5795694133E-01],
	[2.3920000000E+04, 1.5464083194E+01, 5.2851896945E+00, 3.3812832978E+00, 1.8194400680E+00, 8.5802536344E-01],
	[2.3925000000E+04, 1.5469137685E+01, 5.2851257630E+00, 3.3835648639E+00, 1.8201628895E+00, 8.5809375421E-01],
	[2.3930000000E+04, 1.5474192772E+01, 5.2850618457E+00, 3.3858474914E+00, 1.8208856653E+00, 8.5816211366E-01],
	[2.3935000000E+04, 1.5479248454E+01, 5.2849979425E+00, 3.3881311806E+00, 1.8216083953E+00, 8.5823044180E-01],
	[2.3940000000E+04, 1.5484304732E+01, 5.2849340534E+00, 3.3904159318E+00, 1.8223310795E+00, 8.5829873863E-01],
	[2.3945000000E+04, 1.5489361604E+01, 5.2848701785E+00, 3.3927017452E+00, 1.8230537177E+00, 8.5836700416E-01],
	[2.3950000000E+04, 1.5494419072E+01, 5.2848063176E+00, 3.3949886210E+00, 1.8237763097E+00, 8.5843523840E-01],
	[2.3955000000E+04, 1.5499477135E+01, 5.2847424709E+00, 3.3972765597E+00, 1.8244988555E+00, 8.5850344137E-01],
	[2.3960000000E+04, 1.5504535793E+01, 5.2846786382E+00, 3.3995655614E+00, 1.8252213549E+00, 8.5857161306E-01],
	[2.3965000000E+04, 1.5509595046E+01, 5.2846148196E+00, 3.4018556264E+00, 1.8259438078E+00, 8.5863975349E-01],
	[2.3970000000E+04, 1.5514654893E+01, 5.2845510151E+00, 3.4041467549E+00, 1.8266662141E+00, 8.5870786268E-01],
	[2.3975000000E+04, 1.5519715336E+01, 5.2844872247E+00, 3.4064389474E+00, 1.8273885736E+00, 8.5877594061E-01],
	[2.3980000000E+04, 1.5524776373E+01, 5.2844234484E+00, 3.4087322039E+00, 1.8281108862E+00, 8.5884398732E-01],
	[2.3985000000E+04, 1.5529838005E+01, 5.2843596861E+00, 3.4110265249E+00, 1.8288331518E+00, 8.5891200280E-01],
	[2.3990000000E+04, 1.5534900232E+01, 5.2842959379E+00, 3.4133219105E+00, 1.8295553702E+00, 8.5897998707E-01],
	[2.3995000000E+04, 1.5539963054E+01, 5.2842322038E+00, 3.4156183611E+00, 1.8302775414E+00, 8.5904794013E-01],
	[2.4000000000E+04, 1.5545026470E+01, 5.2841684837E+00, 3.4179158769E+00, 1.8309996652E+00, 8.5911586199E-01],
	[2.4005000000E+04, 1.5550090480E+01, 5.2841047776E+00, 3.4202144581E+00, 1.8317217415E+00, 8.5918375267E-01],
	[2.4010000000E+04, 1.5555155085E+01, 5.2840410856E+00, 3.4225141051E+00, 1.8324437701E+00, 8.5925161217E-01],
	[2.4015000000E+04, 1.5560220285E+01, 5.2839774076E+00, 3.4248148182E+00, 1.8331657509E+00, 8.5931944050E-01],
	[2.4020000000E+04, 1.5565286079E+01, 5.2839137436E+00, 3.4271165975E+00, 1.8338876839E+00, 8.5938723767E-01],
	[2.4025000000E+04, 1.5570352467E+01, 5.2838500937E+00, 3.4294194434E+00, 1.8346095688E+00, 8.5945500369E-01],
	[2.4030000000E+04, 1.5575419450E+01, 5.2837864577E+00, 3.4317233561E+00, 1.8353314056E+00, 8.5952273857E-01],
	[2.4035000000E+04, 1.5580487026E+01, 5.2837228358E+00, 3.4340283360E+00, 1.8360531941E+00, 8.5959044231E-01],
	[2.4040000000E+04, 1.5585555197E+01, 5.2836592278E+00, 3.4363343832E+00, 1.8367749342E+00, 8.5965811494E-01],
	[2.4045000000E+04, 1.5590623962E+01, 5.2835956339E+00, 3.4386414981E+00, 1.8374966258E+00, 8.5972575645E-01],
	[2.4050000000E+04, 1.5595693321E+01, 5.2835320539E+00, 3.4409496809E+00, 1.8382182687E+00, 8.5979336686E-01],
	[2.4055000000E+04, 1.5600763274E+01, 5.2834684880E+00, 3.4432589319E+00, 1.8389398629E+00, 8.5986094617E-01],
	[2.4060000000E+04, 1.5605833821E+01, 5.2834049360E+00, 3.4455692514E+00, 1.8396614082E+00, 8.5992849440E-01],
	[2.4065000000E+04, 1.5610904962E+01, 5.2833413979E+00, 3.4478806396E+00, 1.8403829044E+00, 8.5999601155E-01],
	[2.4070000000E+04, 1.5615976697E+01, 5.2832778739E+00, 3.4501930968E+00, 1.8411043515E+00, 8.6006349764E-01],
	[2.4075000000E+04, 1.5621049025E+01, 5.2832143637E+00, 3.4525066233E+00, 1.8418257493E+00, 8.6013095267E-01],
	[2.4080000000E+04, 1.5626121948E+01, 5.2831508676E+00, 3.4548212194E+00, 1.8425470977E+00, 8.6019837665E-01],
	[2.4085000000E+04, 1.5631195464E+01, 5.2830873854E+00, 3.4571368853E+00, 1.8432683966E+00, 8.6026576960E-01],
	[2.4090000000E+04, 1.5636269573E+01, 5.2830239171E+00, 3.4594536213E+00, 1.8439896458E+00, 8.6033313151E-01],
	[2.4095000000E+04, 1.5641344276E+01, 5.2829604628E+00, 3.4617714276E+00, 1.8447108453E+00, 8.6040046241E-01],
	[2.4100000000E+04, 1.5646419573E+01, 5.2828970224E+00, 3.4640903046E+00, 1.8454319949E+00, 8.6046776230E-01],
	[2.4105000000E+04, 1.5651495463E+01, 5.2828335959E+00, 3.4664102526E+00, 1.8461530944E+00, 8.6053503118E-01],
	[2.4110000000E+04, 1.5656571946E+01, 5.2827701833E+00, 3.4687312717E+00, 1.8468741439E+00, 8.6060226908E-01],
	[2.4115000000E+04, 1.5661649023E+01, 5.2827067846E+00, 3.4710533622E+00, 1.8475951430E+00, 8.6066947599E-01],
	[2.4120000000E+04, 1.5666726693E+01, 5.2826433999E+00, 3.4733765245E+00, 1.8483160918E+00, 8.6073665193E-01],
	[2.4125000000E+04, 1.5671804957E+01, 5.2825800290E+00, 3.4757007588E+00, 1.8490369900E+00, 8.6080379691E-01],
	[2.4130000000E+04, 1.5676883813E+01, 5.2825166721E+00, 3.4780260653E+00, 1.8497578376E+00, 8.6087091094E-01],
	[2.4135000000E+04, 1.5681963263E+01, 5.2824533290E+00, 3.4803524444E+00, 1.8504786344E+00, 8.6093799402E-01],
	[2.4140000000E+04, 1.5687043306E+01, 5.2823899998E+00, 3.4826798963E+00, 1.8511993804E+00, 8.6100504617E-01],
	[2.4145000000E+04, 1.5692123941E+01, 5.2823266845E+00, 3.4850084213E+00, 1.8519200753E+00, 8.6107206740E-01],
	[2.4150000000E+04, 1.5697205170E+01, 5.2822633830E+00, 3.4873380197E+00, 1.8526407191E+00, 8.6113905771E-01],
	[2.4155000000E+04, 1.5702286992E+01, 5.2822000954E+00, 3.4896686917E+00, 1.8533613117E+00, 8.6120601712E-01],
	[2.4160000000E+04, 1.5707369407E+01, 5.2821368217E+00, 3.4920004376E+00, 1.8540818529E+00, 8.6127294563E-01],
	[2.4165000000E+04, 1.5712452414E+01, 5.2820735618E+00, 3.4943332576E+00, 1.8548023425E+00, 8.6133984325E-01],
	[2.4170000000E+04, 1.5717536014E+01, 5.2820103158E+00, 3.4966671521E+00, 1.8555227806E+00, 8.6140671000E-01],
	[2.4175000000E+04, 1.5722620207E+01, 5.2819470836E+00, 3.4990021214E+00, 1.8562431669E+00, 8.6147354588E-01],
	[2.4180000000E+04, 1.5727704993E+01, 5.2818838652E+00, 3.5013381656E+00, 1.8569635013E+00, 8.6154035091E-01],
	[2.4185000000E+04, 1.5732790371E+01, 5.2818206607E+00, 3.5036752850E+00, 1.8576837838E+00, 8.6160712508E-01],
	[2.4190000000E+04, 1.5737876341E+01, 5.2817574699E+00, 3.5060134801E+00, 1.8584040141E+00, 8.6167386842E-01],
	[2.4195000000E+04, 1.5742962905E+01, 5.2816942930E+00, 3.5083527509E+00, 1.8591241922E+00, 8.6174058093E-01],
	[2.4200000000E+04, 1.5748050060E+01, 5.2816311299E+00, 3.5106930978E+00, 1.8598443179E+00, 8.6180726263E-01],
	[2.4205000000E+04, 1.5753137808E+01, 5.2815679807E+00, 3.5130345210E+00, 1.8605643911E+00, 8.6187391351E-01],
	[2.4210000000E+04, 1.5758226149E+01, 5.2815048452E+00, 3.5153770209E+00, 1.8612844118E+00, 8.6194053360E-01],
	[2.4215000000E+04, 1.5763315081E+01, 5.2814417235E+00, 3.5177205976E+00, 1.8620043797E+00, 8.6200712289E-01],
	[2.4220000000E+04, 1.5768404606E+01, 5.2813786156E+00, 3.5200652515E+00, 1.8627242947E+00, 8.6207368141E-01],
	[2.4225000000E+04, 1.5773494723E+01, 5.2813155214E+00, 3.5224109829E+00, 1.8634441568E+00, 8.6214020915E-01],
	[2.4230000000E+04, 1.5778585432E+01, 5.2812524411E+00, 3.5247577920E+00, 1.8641639658E+00, 8.6220670614E-01],
	[2.4235000000E+04, 1.5783676734E+01, 5.2811893745E+00, 3.5271056790E+00, 1.8648837216E+00, 8.6227317237E-01],
	[2.4240000000E+04, 1.5788768627E+01, 5.2811263217E+00, 3.5294546443E+00, 1.8656034241E+00, 8.6233960787E-01],
	[2.4245000000E+04, 1.5793861112E+01, 5.2810632826E+00, 3.5318046881E+00, 1.8663230730E+00, 8.6240601263E-01],
	[2.4250000000E+04, 1.5798954189E+01, 5.2810002573E+00, 3.5341558107E+00, 1.8670426684E+00, 8.6247238667E-01],
	[2.4255000000E+04, 1.5804047858E+01, 5.2809372457E+00, 3.5365080124E+00, 1.8677622102E+00, 8.6253873000E-01],
	[2.4260000000E+04, 1.5809142119E+01, 5.2808742479E+00, 3.5388612934E+00, 1.8684816980E+00, 8.6260504263E-01],
	[2.4265000000E+04, 1.5814236971E+01, 5.2808112638E+00, 3.5412156541E+00, 1.8692011320E+00, 8.6267132457E-01],
	[2.4270000000E+04, 1.5819332416E+01, 5.2807482934E+00, 3.5435710946E+00, 1.8699205119E+00, 8.6273757582E-01],
	[2.4275000000E+04, 1.5824428451E+01, 5.2806853368E+00, 3.5459276153E+00, 1.8706398376E+00, 8.6280379640E-01],
	[2.4280000000E+04, 1.5829525079E+01, 5.2806223938E+00, 3.5482852164E+00, 1.8713591090E+00, 8.6286998632E-01],
	[2.4285000000E+04, 1.5834622298E+01, 5.2805594646E+00, 3.5506438982E+00, 1.8720783259E+00, 8.6293614559E-01],
	[2.4290000000E+04, 1.5839720108E+01, 5.2804965491E+00, 3.5530036610E+00, 1.8727974883E+00, 8.6300227422E-01],
	[2.4295000000E+04, 1.5844818510E+01, 5.2804336473E+00, 3.5553645050E+00, 1.8735165961E+00, 8.6306837221E-01],
	[2.4300000000E+04, 1.5849917504E+01, 5.2803707592E+00, 3.5577264306E+00, 1.8742356491E+00, 8.6313443958E-01],
	[2.4305000000E+04, 1.5855037493E+01, 5.2803113791E+00, 3.5600894379E+00, 1.8749553730E+00, 8.6320047633E-01],
	[2.4310000000E+04, 1.5860160790E+01, 5.2802524753E+00, 3.5624535273E+00, 1.8756751391E+00, 8.6326648249E-01],
	[2.4315000000E+04, 1.5865284688E+01, 5.2801935843E+00, 3.5648186990E+00, 1.8763948510E+00, 8.6333245805E-01],
	[2.4320000000E+04, 1.5870409187E+01, 5.2801347060E+00, 3.5671849534E+00, 1.8771145084E+00, 8.6339840302E-01],
	[2.4325000000E+04, 1.5875534287E+01, 5.2800758405E+00, 3.5695522906E+00, 1.8778341114E+00, 8.6346431742E-01],
	[2.4330000000E+04, 1.5880659989E+01, 5.2800169878E+00, 3.5719207109E+00, 1.8785536597E+00, 8.6353020126E-01],
	[2.4335000000E+04, 1.5885786292E+01, 5.2799581478E+00, 3.5742902147E+00, 1.8792731534E+00, 8.6359605455E-01],
	[2.4340000000E+04, 1.5890913196E+01, 5.2798993206E+00, 3.5766608022E+00, 1.8799925921E+00, 8.6366187729E-01],
	[2.4345000000E+04, 1.5896040701E+01, 5.2798405061E+00, 3.5790324737E+00, 1.8807119759E+00, 8.6372766950E-01],
	[2.4350000000E+04, 1.5901168807E+01, 5.2797817043E+00, 3.5814052293E+00, 1.8814313046E+00, 8.6379343118E-01],
	[2.4355000000E+04, 1.5906297514E+01, 5.2797229152E+00, 3.5837790695E+00, 1.8821505781E+00, 8.6385916235E-01],
	[2.4360000000E+04, 1.5911426822E+01, 5.2796641389E+00, 3.5861539945E+00, 1.8828697963E+00, 8.6392486302E-01],
	[2.4365000000E+04, 1.5916556731E+01, 5.2796053753E+00, 3.5885300046E+00, 1.8835889590E+00, 8.6399053319E-01],
	[2.4370000000E+04, 1.5921687240E+01, 5.2795466244E+00, 3.5909070999E+00, 1.8843080661E+00, 8.6405617288E-01],
	[2.4375000000E+04, 1.5926818350E+01, 5.2794878862E+00, 3.5932852809E+00, 1.8850271176E+00, 8.6412178210E-01],
	[2.4380000000E+04, 1.5931950061E+01, 5.2794291607E+00, 3.5956645478E+00, 1.8857461132E+00, 8.6418736085E-01],
	[2.4385000000E+04, 1.5937082373E+01, 5.2793704479E+00, 3.5980449007E+00, 1.8864650529E+00, 8.6425290915E-01],
	[2.4390000000E+04, 1.5942215285E+01, 5.2793117478E+00, 3.6004263402E+00, 1.8871839366E+00, 8.6431842700E-01],
	[2.4395000000E+04, 1.5947348797E+01, 5.2792530604E+00, 3.6028088663E+00, 1.8879027641E+00, 8.6438391442E-01],
	[2.4400000000E+04, 1.5952482910E+01, 5.2791943857E+00, 3.6051924793E+00, 1.8886215353E+00, 8.6444937142E-01],
	[2.4405000000E+04, 1.5957617624E+01, 5.2791357236E+00, 3.6075771796E+00, 1.8893402502E+00, 8.6451479800E-01],
	[2.4410000000E+04, 1.5962752938E+01, 5.2790770742E+00, 3.6099629674E+00, 1.8900589085E+00, 8.6458019418E-01],
	[2.4415000000E+04, 1.5967888852E+01, 5.2790184375E+00, 3.6123498430E+00, 1.8907775101E+00, 8.6464555997E-01],
	[2.4420000000E+04, 1.5973025366E+01, 5.2789598134E+00, 3.6147378066E+00, 1.8914960550E+00, 8.6471089537E-01],
	[2.4425000000E+04, 1.5978162481E+01, 5.2789012020E+00, 3.6171268586E+00, 1.8922145431E+00, 8.6477620041E-01],
	[2.4430000000E+04, 1.5983300196E+01, 5.2788426032E+00, 3.6195169991E+00, 1.8929329741E+00, 8.6484147507E-01],
	[2.4435000000E+04, 1.5988438510E+01, 5.2787840171E+00, 3.6219082286E+00, 1.8936513480E+00, 8.6490671939E-01],
	[2.4440000000E+04, 1.5993577425E+01, 5.2787254436E+00, 3.6243005471E+00, 1.8943696648E+00, 8.6497193336E-01],
	[2.4445000000E+04, 1.5998716940E+01, 5.2786668827E+00, 3.6266939551E+00, 1.8950879241E+00, 8.6503711700E-01],
	[2.4450000000E+04, 1.6003857055E+01, 5.2786083345E+00, 3.6290884528E+00, 1.8958061260E+00, 8.6510227032E-01],
	[2.4455000000E+04, 1.6008997770E+01, 5.2785497989E+00, 3.6314840404E+00, 1.8965242703E+00, 8.6516739332E-01],
	[2.4460000000E+04, 1.6014139084E+01, 5.2784912759E+00, 3.6338807183E+00, 1.8972423569E+00, 8.6523248603E-01],
	[2.4465000000E+04, 1.6019280998E+01, 5.2784327655E+00, 3.6362784867E+00, 1.8979603857E+00, 8.6529754844E-01],
	[2.4470000000E+04, 1.6024423512E+01, 5.2783742677E+00, 3.6386773458E+00, 1.8986783566E+00, 8.6536258057E-01],
	[2.4475000000E+04, 1.6029566626E+01, 5.2783157825E+00, 3.6410772960E+00, 1.8993962694E+00, 8.6542758243E-01],
	[2.4480000000E+04, 1.6034710339E+01, 5.2782573100E+00, 3.6434783375E+00, 1.9001141240E+00, 8.6549255402E-01],
	[2.4485000000E+04, 1.6039854652E+01, 5.2781988500E+00, 3.6458804706E+00, 1.9008319204E+00, 8.6555749537E-01],
	[2.4490000000E+04, 1.6044999565E+01, 5.2781404025E+00, 3.6482836956E+00, 1.9015496584E+00, 8.6562240647E-01],
	[2.4495000000E+04, 1.6050145077E+01, 5.2780819677E+00, 3.6506880127E+00, 1.9022673378E+00, 8.6568728735E-01],
	[2.4500000000E+04, 1.6055291188E+01, 5.2780235454E+00, 3.6530934223E+00, 1.9029849586E+00, 8.6575213800E-01],
	[2.4505000000E+04, 1.6060437898E+01, 5.2779651357E+00, 3.6554999245E+00, 1.9037025206E+00, 8.6581695844E-01],
	[2.4510000000E+04, 1.6065585208E+01, 5.2779067386E+00, 3.6579075197E+00, 1.9044200238E+00, 8.6588174869E-01],
	[2.4515000000E+04, 1.6070733118E+01, 5.2778483540E+00, 3.6603162081E+00, 1.9051374680E+00, 8.6594650874E-01],
	[2.4520000000E+04, 1.6075881626E+01, 5.2777899820E+00, 3.6627259900E+00, 1.9058548531E+00, 8.6601123862E-01],
	[2.4525000000E+04, 1.6081030733E+01, 5.2777316225E+00, 3.6651368657E+00, 1.9065721790E+00, 8.6607593832E-01],
	[2.4530000000E+04, 1.6086180440E+01, 5.2776732756E+00, 3.6675488354E+00, 1.9072894455E+00, 8.6614060787E-01],
	[2.4535000000E+04, 1.6091330746E+01, 5.2776149412E+00, 3.6699618995E+00, 1.9080066526E+00, 8.6620524727E-01],
	[2.4540000000E+04, 1.6096481650E+01, 5.2775566193E+00, 3.6723760581E+00, 1.9087238001E+00, 8.6626985653E-01],
	[2.4545000000E+04, 1.6101633154E+01, 5.2774983100E+00, 3.6747913116E+00, 1.9094408880E+00, 8.6633443566E-01],
	[2.4550000000E+04, 1.6106785257E+01, 5.2774400132E+00, 3.6772076603E+00, 1.9101579160E+00, 8.6639898468E-01],
	[2.4555000000E+04, 1.6111937958E+01, 5.2773817289E+00, 3.6796251044E+00, 1.9108748841E+00, 8.6646350359E-01],
	[2.4560000000E+04, 1.6117091258E+01, 5.2773234571E+00, 3.6820436441E+00, 1.9115917922E+00, 8.6652799240E-01],
	[2.4565000000E+04, 1.6122245157E+01, 5.2772651978E+00, 3.6844632798E+00, 1.9123086402E+00, 8.6659245112E-01],
	[2.4570000000E+04, 1.6127399654E+01, 5.2772069510E+00, 3.6868840118E+00, 1.9130254279E+00, 8.6665687977E-01],
	[2.4575000000E+04, 1.6132554750E+01, 5.2771487167E+00, 3.6893058402E+00, 1.9137421552E+00, 8.6672127835E-01],
	[2.4580000000E+04, 1.6137710445E+01, 5.2770904949E+00, 3.6917287655E+00, 1.9144588220E+00, 8.6678564688E-01],
	[2.4585000000E+04, 1.6142866738E+01, 5.2770322856E+00, 3.6941527877E+00, 1.9151754282E+00, 8.6684998536E-01],
	[2.4590000000E+04, 1.6148023630E+01, 5.2769740888E+00, 3.6965779073E+00, 1.9158919737E+00, 8.6691429381E-01],
	[2.4595000000E+04, 1.6153181120E+01, 5.2769159044E+00, 3.6990041245E+00, 1.9166084583E+00, 8.6697857224E-01],
	[2.4600000000E+04, 1.6158339209E+01, 5.2768577325E+00, 3.7014314396E+00, 1.9173248821E+00, 8.6704282065E-01],
	[2.4605000000E+04, 1.6163497895E+01, 5.2767995731E+00, 3.7038598528E+00, 1.9180412447E+00, 8.6710703905E-01],
	[2.4610000000E+04, 1.6168657180E+01, 5.2767414261E+00, 3.7062893644E+00, 1.9187575461E+00, 8.6717122747E-01],
	[2.4615000000E+04, 1.6173817064E+01, 5.2766832916E+00, 3.7087199747E+00, 1.9194737863E+00, 8.6723538590E-01],
	[2.4620000000E+04, 1.6178977545E+01, 5.2766251695E+00, 3.7111516840E+00, 1.9201899650E+00, 8.6729951436E-01],
	[2.4625000000E+04, 1.6184138625E+01, 5.2765670599E+00, 3.7135844925E+00, 1.9209060823E+00, 8.6736361286E-01],
	[2.4630000000E+04, 1.6189300302E+01, 5.2765089627E+00, 3.7160184005E+00, 1.9216221379E+00, 8.6742768140E-01],
	[2.4635000000E+04, 1.6194462578E+01, 5.2764508779E+00, 3.7184534082E+00, 1.9223381317E+00, 8.6749172001E-01],
	[2.4640000000E+04, 1.6199625451E+01, 5.2763928056E+00, 3.7208895161E+00, 1.9230540636E+00, 8.6755572869E-01],
	[2.4645000000E+04, 1.6204788923E+01, 5.2763347457E+00, 3.7233267242E+00, 1.9237699336E+00, 8.6761970744E-01],
	[2.4650000000E+04, 1.6209952992E+01, 5.2762766982E+00, 3.7257650330E+00, 1.9244857415E+00, 8.6768365629E-01],
	[2.4655000000E+04, 1.6215117659E+01, 5.2762186631E+00, 3.7282044426E+00, 1.9252014872E+00, 8.6774757524E-01],
	[2.4660000000E+04, 1.6220282924E+01, 5.2761606404E+00, 3.7306449534E+00, 1.9259171705E+00, 8.6781146430E-01],
	[2.4665000000E+04, 1.6225448786E+01, 5.2761026301E+00, 3.7330865655E+00, 1.9266327914E+00, 8.6787532348E-01],
	[2.4670000000E+04, 1.6230615246E+01, 5.2760446323E+00, 3.7355292794E+00, 1.9273483498E+00, 8.6793915280E-01],
	[2.4675000000E+04, 1.6235782304E+01, 5.2759866468E+00, 3.7379730952E+00, 1.9280638455E+00, 8.6800295225E-01],
	[2.4680000000E+04, 1.6240949959E+01, 5.2759286737E+00, 3.7404180133E+00, 1.9287792784E+00, 8.6806672187E-01],
	[2.4685000000E+04, 1.6246118212E+01, 5.2758707129E+00, 3.7428640339E+00, 1.9294946484E+00, 8.6813046164E-01],
	[2.4690000000E+04, 1.6251287062E+01, 5.2758127646E+00, 3.7453111572E+00, 1.9302099555E+00, 8.6819417160E-01],
	[2.4695000000E+04, 1.6256471502E+01, 5.2757573327E+00, 3.7477593837E+00, 1.9309257463E+00, 8.6825785173E-01],
	[2.4700000000E+04, 1.6261664921E+01, 5.2757033110E+00, 3.7502087134E+00, 1.9316417802E+00, 8.6832150207E-01],
	[2.4705000000E+04, 1.6266858948E+01, 5.2756493009E+00, 3.7526591467E+00, 1.9323577516E+00, 8.6838512261E-01],
	[2.4710000000E+04, 1.6272053582E+01, 5.2755953022E+00, 3.7551106839E+00, 1.9330736604E+00, 8.6844871336E-01],
	[2.4715000000E+04, 1.6277248823E+01, 5.2755413150E+00, 3.7575633253E+00, 1.9337895066E+00, 8.6851227435E-01],
	[2.4720000000E+04, 1.6282444672E+01, 5.2754873393E+00, 3.7600170711E+00, 1.9345052900E+00, 8.6857580557E-01],
	[2.4725000000E+04, 1.6287641128E+01, 5.2754333750E+00, 3.7624719216E+00, 1.9352210104E+00, 8.6863930705E-01],
	[2.4730000000E+04, 1.6292838191E+01, 5.2753794222E+00, 3.7649278770E+00, 1.9359366679E+00, 8.6870277878E-01],
	[2.4735000000E+04, 1.6298035862E+01, 5.2753254809E+00, 3.7673849377E+00, 1.9366522622E+00, 8.6876622078E-01],
	[2.4740000000E+04, 1.6303234139E+01, 5.2752715510E+00, 3.7698431039E+00, 1.9373677933E+00, 8.6882963306E-01],
	[2.4745000000E+04, 1.6308433024E+01, 5.2752176326E+00, 3.7723023759E+00, 1.9380832610E+00, 8.6889301564E-01],
	[2.4750000000E+04, 1.6313632515E+01, 5.2751637256E+00, 3.7747627539E+00, 1.9387986653E+00, 8.6895636852E-01],
	[2.4755000000E+04, 1.6318832613E+01, 5.2751098301E+00, 3.7772242383E+00, 1.9395140060E+00, 8.6901969171E-01],
	[2.4760000000E+04, 1.6324033318E+01, 5.2750559460E+00, 3.7796868293E+00, 1.9402292830E+00, 8.6908298522E-01],
	[2.4765000000E+04, 1.6329234630E+01, 5.2750020733E+00, 3.7821505271E+00, 1.9409444962E+00, 8.6914624907E-01],
	[2.4770000000E+04, 1.6334436549E+01, 5.2749482120E+00, 3.7846153321E+00, 1.9416596455E+00, 8.6920948326E-01],
	[2.4775000000E+04, 1.6339639075E+01, 5.2748943622E+00, 3.7870812446E+00, 1.9423747308E+00, 8.6927268781E-01],
	[2.4780000000E+04, 1.6344842207E+01, 5.2748405238E+00, 3.7895482647E+00, 1.9430897519E+00, 8.6933586272E-01],
	[2.4785000000E+04, 1.6350045945E+01, 5.2747866968E+00, 3.7920163928E+00, 1.9438047088E+00, 8.6939900801E-01],
	[2.4790000000E+04, 1.6355250291E+01, 5.2747328812E+00, 3.7944856292E+00, 1.9445196014E+00, 8.6946212369E-01],
	[2.4795000000E+04, 1.6360455242E+01, 5.2746790770E+00, 3.7969559741E+00, 1.9452344294E+00, 8.6952520977E-01],
	[2.4800000000E+04, 1.6365660801E+01, 5.2746252842E+00, 3.7994274277E+00, 1.9459491929E+00, 8.6958826626E-01],
	[2.4805000000E+04, 1.6370866965E+01, 5.2745715028E+00, 3.8018999905E+00, 1.9466638917E+00, 8.6965129316E-01],
	[2.4810000000E+04, 1.6376073736E+01, 5.2745177328E+00, 3.8043736625E+00, 1.9473785257E+00, 8.6971429050E-01],
	[2.4815000000E+04, 1.6381281113E+01, 5.2744639741E+00, 3.8068484442E+00, 1.9480930948E+00, 8.6977725827E-01],
	[2.4820000000E+04, 1.6386489097E+01, 5.2744102269E+00, 3.8093243358E+00, 1.9488075988E+00, 8.6984019650E-01],
	[2.4825000000E+04, 1.6391697687E+01, 5.2743564910E+00, 3.8118013375E+00, 1.9495220377E+00, 8.6990310519E-01],
	[2.4830000000E+04, 1.6396906882E+01, 5.2743027665E+00, 3.8142794497E+00, 1.9502364114E+00, 8.6996598436E-01],
	[2.4835000000E+04, 1.6402116684E+01, 5.2742490533E+00, 3.8167586725E+00, 1.9509507197E+00, 8.7002883401E-01],
	[2.4840000000E+04, 1.6407327092E+01, 5.2741953515E+00, 3.8192390064E+00, 1.9516649626E+00, 8.7009165415E-01],
	[2.4845000000E+04, 1.6412538106E+01, 5.2741416611E+00, 3.8217204515E+00, 1.9523791399E+00, 8.7015444480E-01],
	[2.4850000000E+04, 1.6417749726E+01, 5.2740879820E+00, 3.8242030081E+00, 1.9530932515E+00, 8.7021720597E-01],
	[2.4855000000E+04, 1.6422961952E+01, 5.2740343143E+00, 3.8266866765E+00, 1.9538072973E+00, 8.7027993766E-01],
	[2.4860000000E+04, 1.6428174783E+01, 5.2739806579E+00, 3.8291714570E+00, 1.9545212771E+00, 8.7034263989E-01],
	[2.4865000000E+04, 1.6433388221E+01, 5.2739270128E+00, 3.8316573499E+00, 1.9552351910E+00, 8.7040531267E-01],
	[2.4870000000E+04, 1.6438602264E+01, 5.2738733791E+00, 3.8341443554E+00, 1.9559490388E+00, 8.7046795601E-01],
	[2.4875000000E+04, 1.6443816912E+01, 5.2738197567E+00, 3.8366324737E+00, 1.9566628203E+00, 8.7053056992E-01],
	[2.4880000000E+04, 1.6449032167E+01, 5.2737661456E+00, 3.8391217053E+00, 1.9573765354E+00, 8.7059315441E-01],
	[2.4885000000E+04, 1.6454248027E+01, 5.2737125458E+00, 3.8416120502E+00, 1.9580901841E+00, 8.7065570949E-01],
	[2.4890000000E+04, 1.6459464492E+01, 5.2736589574E+00, 3.8441035089E+00, 1.9588037663E+00, 8.7071823518E-01],
	[2.4895000000E+04, 1.6464681563E+01, 5.2736053803E+00, 3.8465960816E+00, 1.9595172817E+00, 8.7078073148E-01],
	[2.4900000000E+04, 1.6469899240E+01, 5.2735518144E+00, 3.8490897685E+00, 1.9602307304E+00, 8.7084319840E-01],
	[2.4905000000E+04, 1.6475117521E+01, 5.2734982599E+00, 3.8515845700E+00, 1.9609441122E+00, 8.7090563596E-01],
	[2.4910000000E+04, 1.6480336408E+01, 5.2734447166E+00, 3.8540804863E+00, 1.9616574270E+00, 8.7096804417E-01],
	[2.4915000000E+04, 1.6485555901E+01, 5.2733911847E+00, 3.8565775176E+00, 1.9623706746E+00, 8.7103042303E-01],
	[2.4920000000E+04, 1.6490775998E+01, 5.2733376640E+00, 3.8590756644E+00, 1.9630838551E+00, 8.7109277257E-01],
	[2.4925000000E+04, 1.6495996701E+01, 5.2732841546E+00, 3.8615749267E+00, 1.9637969682E+00, 8.7115509278E-01],
	[2.4930000000E+04, 1.6501218009E+01, 5.2732306565E+00, 3.8640753050E+00, 1.9645100139E+00, 8.7121738368E-01],
	[2.4935000000E+04, 1.6506439922E+01, 5.2731771697E+00, 3.8665767994E+00, 1.9652229920E+00, 8.7127964528E-01],
	[2.4940000000E+04, 1.6511662440E+01, 5.2731236941E+00, 3.8690794103E+00, 1.9659359025E+00, 8.7134187759E-01],
	[2.4945000000E+04, 1.6516885562E+01, 5.2730702298E+00, 3.8715831379E+00, 1.9666487452E+00, 8.7140408062E-01],
	[2.4950000000E+04, 1.6522109290E+01, 5.2730167767E+00, 3.8740879825E+00, 1.9673615201E+00, 8.7146625439E-01],
	[2.4955000000E+04, 1.6527333623E+01, 5.2729633349E+00, 3.8765939444E+00, 1.9680742269E+00, 8.7152839890E-01],
	[2.4960000000E+04, 1.6532558560E+01, 5.2729099044E+00, 3.8791010238E+00, 1.9687868657E+00, 8.7159051417E-01],
	[2.4965000000E+04, 1.6537784102E+01, 5.2728564851E+00, 3.8816092210E+00, 1.9694994363E+00, 8.7165260026E-01],
	[2.4970000000E+04, 1.6543010249E+01, 5.2728030770E+00, 3.8841185364E+00, 1.9702119386E+00, 8.7171465725E-01],
	[2.4975000000E+04, 1.6548237001E+01, 5.2727496802E+00, 3.8866289701E+00, 1.9709243724E+00, 8.7177668516E-01],
	[2.4980000000E+04, 1.6553464357E+01, 5.2726962946E+00, 3.8891405224E+00, 1.9716367377E+00, 8.7183868400E-01],
	[2.4985000000E+04, 1.6558692318E+01, 5.2726429202E+00, 3.8916531937E+00, 1.9723490345E+00, 8.7190065378E-01],
	[2.4990000000E+04, 1.6563920883E+01, 5.2725895570E+00, 3.8941669841E+00, 1.9730612624E+00, 8.7196259450E-01],
	[2.4995000000E+04, 1.6569150052E+01, 5.2725362051E+00, 3.8966818940E+00, 1.9737734216E+00, 8.7202450619E-01],
	[2.5000000000E+04, 1.6574379826E+01, 5.2724828643E+00, 3.8991979237E+00, 1.9744855117E+00, 8.7208638884E-01],
	[2.5005000000E+04, 1.6579610205E+01, 5.2724295348E+00, 3.9017213984E+00, 1.9751991538E+00, 8.7214824247E-01],
	[2.5010000000E+04, 1.6584841187E+01, 5.2723762165E+00, 3.9042460004E+00, 1.9759127267E+00, 8.7221006710E-01],
	[2.5015000000E+04, 1.6590072774E+01, 5.2723229093E+00, 3.9067717301E+00, 1.9766262303E+00, 8.7227186272E-01],
	[2.5020000000E+04, 1.6595304965E+01, 5.2722696134E+00, 3.9092985876E+00, 1.9773396644E+00, 8.7233362935E-01],
	[2.5025000000E+04, 1.6600537761E+01, 5.2722163286E+00, 3.9118265733E+00, 1.9780530290E+00, 8.7239536701E-01],
	[2.5030000000E+04, 1.6605771160E+01, 5.2721630551E+00, 3.9143556874E+00, 1.9787663239E+00, 8.7245707569E-01],
	[2.5035000000E+04, 1.6611005163E+01, 5.2721097927E+00, 3.9168859303E+00, 1.9794795492E+00, 8.7251875542E-01],
	[2.5040000000E+04, 1.6616239771E+01, 5.2720565415E+00, 3.9194173022E+00, 1.9801927045E+00, 8.7258040620E-01],
	[2.5045000000E+04, 1.6621474982E+01, 5.2720033014E+00, 3.9219498033E+00, 1.9809057899E+00, 8.7264202804E-01],
	[2.5050000000E+04, 1.6626710797E+01, 5.2719500726E+00, 3.9244834340E+00, 1.9816188052E+00, 8.7270362096E-01],
	[2.5055000000E+04, 1.6631947216E+01, 5.2718968548E+00, 3.9270181946E+00, 1.9823317504E+00, 8.7276518495E-01],
	[2.5060000000E+04, 1.6637184239E+01, 5.2718436483E+00, 3.9295540852E+00, 1.9830446252E+00, 8.7282672004E-01],
	[2.5065000000E+04, 1.6642421865E+01, 5.2717904529E+00, 3.9320911063E+00, 1.9837574297E+00, 8.7288822624E-01],
	[2.5070000000E+04, 1.6647660096E+01, 5.2717372686E+00, 3.9346292580E+00, 1.9844701637E+00, 8.7294970355E-01],
	[2.5075000000E+04, 1.6652898929E+01, 5.2716840955E+00, 3.9371685407E+00, 1.9851828270E+00, 8.7301115198E-01],
	[2.5080000000E+04, 1.6658138367E+01, 5.2716309335E+00, 3.9397089545E+00, 1.9858954197E+00, 8.7307257155E-01],
	[2.5085000000E+04, 1.6663378408E+01, 5.2715777827E+00, 3.9422504999E+00, 1.9866079415E+00, 8.7313396226E-01],
	[2.5090000000E+04, 1.6668622362E+01, 5.2715251841E+00, 3.9447931771E+00, 1.9873205164E+00, 8.7319532413E-01],
	[2.5095000000E+04, 1.6673887130E+01, 5.2714758988E+00, 3.9473369863E+00, 1.9880337773E+00, 8.7325665717E-01],
	[2.5100000000E+04, 1.6679152510E+01, 5.2714266239E+00, 3.9498819278E+00, 1.9887469679E+00, 8.7331796138E-01],
	[2.5105000000E+04, 1.6684418505E+01, 5.2713773592E+00, 3.9524280020E+00, 1.9894600882E+00, 8.7337923678E-01],
	[2.5110000000E+04, 1.6689685112E+01, 5.2713281048E+00, 3.9549752091E+00, 1.9901731381E+00, 8.7344048337E-01],
	[2.5115000000E+04, 1.6694952333E+01, 5.2712788606E+00, 3.9575235493E+00, 1.9908861173E+00, 8.7350170118E-01],
	[2.5120000000E+04, 1.6700220168E+01, 5.2712296267E+00, 3.9600730229E+00, 1.9915990259E+00, 8.7356289020E-01],
	[2.5125000000E+04, 1.6705488615E+01, 5.2711804031E+00, 3.9626236303E+00, 1.9923118637E+00, 8.7362405045E-01],
	[2.5130000000E+04, 1.6710757676E+01, 5.2711311897E+00, 3.9651753717E+00, 1.9930246307E+00, 8.7368518195E-01],
	[2.5135000000E+04, 1.6716027350E+01, 5.2710819866E+00, 3.9677282474E+00, 1.9937373266E+00, 8.7374628469E-01],
	[2.5140000000E+04, 1.6721297637E+01, 5.2710327937E+00, 3.9702822576E+00, 1.9944499514E+00, 8.7380735869E-01],
	[2.5145000000E+04, 1.6726568537E+01, 5.2709836110E+00, 3.9728374026E+00, 1.9951625050E+00, 8.7386840396E-01],
	[2.5150000000E+04, 1.6731840050E+01, 5.2709344386E+00, 3.9753936828E+00, 1.9958749873E+00, 8.7392942052E-01],
	[2.5155000000E+04, 1.6737112176E+01, 5.2708852765E+00, 3.9779510984E+00, 1.9965873982E+00, 8.7399040836E-01],
	[2.5160000000E+04, 1.6742384915E+01, 5.2708361245E+00, 3.9805096496E+00, 1.9972997376E+00, 8.7405136751E-01],
	[2.5165000000E+04, 1.6747658267E+01, 5.2707869828E+00, 3.9830693368E+00, 1.9980120053E+00, 8.7411229797E-01],
	[2.5170000000E+04, 1.6752932232E+01, 5.2707378513E+00, 3.9856301602E+00, 1.9987242013E+00, 8.7417319976E-01],
	[2.5175000000E+04, 1.6758206809E+01, 5.2706887300E+00, 3.9881921201E+00, 1.9994363255E+00, 8.7423407288E-01],
	[2.5180000000E+04, 1.6763481999E+01, 5.2706396190E+00, 3.9907552167E+00, 2.0001483777E+00, 8.7429491734E-01],
	[2.5185000000E+04, 1.6768757802E+01, 5.2705905181E+00, 3.9933194505E+00, 2.0008603579E+00, 8.7435573316E-01],
	[2.5190000000E+04, 1.6774034217E+01, 5.2705414274E+00, 3.9958848216E+00, 2.0015722659E+00, 8.7441652034E-01],
	[2.5195000000E+04, 1.6779311245E+01, 5.2704923470E+00, 3.9984513302E+00, 2.0022841017E+00, 8.7447727890E-01],
	[2.5200000000E+04, 1.6784588886E+01, 5.2704432767E+00, 4.0010189768E+00, 2.0029958651E+00, 8.7453800885E-01],
	[2.5205000000E+04, 1.6789867138E+01, 5.2703942167E+00, 4.0035877616E+00, 2.0037075560E+00, 8.7459871020E-01],
	[2.5210000000E+04, 1.6795146004E+01, 5.2703451668E+00, 4.0061576848E+00, 2.0044191744E+00, 8.7465938295E-01],
	[2.5215000000E+04, 1.6800425481E+01, 5.2702961271E+00, 4.0087287467E+00, 2.0051307200E+00, 8.7472002712E-01],
	[2.5220000000E+04, 1.6805705571E+01, 5.2702470976E+00, 4.0113009476E+00, 2.0058421930E+00, 8.7478064272E-01],
	[2.5225000000E+04, 1.6810986273E+01, 5.2701980782E+00, 4.0138742878E+00, 2.0065535930E+00, 8.7484122976E-01],
	[2.5230000000E+04, 1.6816267588E+01, 5.2701490691E+00, 4.0164487676E+00, 2.0072649200E+00, 8.7490178825E-01],
	[2.5235000000E+04, 1.6821549514E+01, 5.2701000701E+00, 4.0190243872E+00, 2.0079761740E+00, 8.7496231820E-01],
	[2.5240000000E+04, 1.6826832053E+01, 5.2700510812E+00, 4.0216011470E+00, 2.0086873547E+00, 8.7502281963E-01],
	[2.5245000000E+04, 1.6832115203E+01, 5.2700021026E+00, 4.0241790471E+00, 2.0093984622E+00, 8.7508329253E-01],
	[2.5250000000E+04, 1.6837398966E+01, 5.2699531340E+00, 4.0267580879E+00, 2.0101094962E+00, 8.7514373693E-01],
	[2.5255000000E+04, 1.6842683340E+01, 5.2699041757E+00, 4.0293382696E+00, 2.0108204568E+00, 8.7520415283E-01],
	[2.5260000000E+04, 1.6847968327E+01, 5.2698552274E+00, 4.0319195926E+00, 2.0115313437E+00, 8.7526454025E-01],
	[2.5265000000E+04, 1.6853253925E+01, 5.2698062893E+00, 4.0345020571E+00, 2.0122421569E+00, 8.7532489919E-01],
	[2.5270000000E+04, 1.6858540135E+01, 5.2697573614E+00, 4.0370856634E+00, 2.0129528963E+00, 8.7538522966E-01],
	[2.5275000000E+04, 1.6863826957E+01, 5.2697084436E+00, 4.0396704117E+00, 2.0136635618E+00, 8.7544553169E-01],
	[2.5280000000E+04, 1.6869114390E+01, 5.2696595359E+00, 4.0422563024E+00, 2.0143741532E+00, 8.7550580527E-01],
	[2.5285000000E+04, 1.6874402436E+01, 5.2696106383E+00, 4.0448433357E+00, 2.0150846706E+00, 8.7556605041E-01],
	[2.5290000000E+04, 1.6879691092E+01, 5.2695617509E+00, 4.0474315119E+00, 2.0157951137E+00, 8.7562626714E-01],
	[2.5295000000E+04, 1.6884980361E+01, 5.2695128736E+00, 4.0500208313E+00, 2.0165054824E+00, 8.7568645545E-01],
	[2.5300000000E+04, 1.6890270241E+01, 5.2694640064E+00, 4.0526112941E+00, 2.0172157768E+00, 8.7574661536E-01],
	[2.5305000000E+04, 1.6895560732E+01, 5.2694151493E+00, 4.0552029007E+00, 2.0179259966E+00, 8.7580674688E-01],
	[2.5310000000E+04, 1.6900851834E+01, 5.2693663023E+00, 4.0577956513E+00, 2.0186361417E+00, 8.7586685003E-01],
	[2.5315000000E+04, 1.6906143548E+01, 5.2693174654E+00, 4.0603895462E+00, 2.0193462121E+00, 8.7592692480E-01],
	[2.5320000000E+04, 1.6911435874E+01, 5.2692686386E+00, 4.0629845856E+00, 2.0200562077E+00, 8.7598697122E-01],
	[2.5325000000E+04, 1.6916728810E+01, 5.2692198219E+00, 4.0655807699E+00, 2.0207661283E+00, 8.7604698929E-01],
	[2.5330000000E+04, 1.6922022358E+01, 5.2691710153E+00, 4.0681780993E+00, 2.0214759739E+00, 8.7610697902E-01],
	[2.5335000000E+04, 1.6927316517E+01, 5.2691222188E+00, 4.0707765741E+00, 2.0221857443E+00, 8.7616694043E-01],
	[2.5340000000E+04, 1.6932611287E+01, 5.2690734324E+00, 4.0733761946E+00, 2.0228954395E+00, 8.7622687353E-01],
	[2.5345000000E+04, 1.6937906668E+01, 5.2690246560E+00, 4.0759769611E+00, 2.0236050593E+00, 8.7628677832E-01],
	[2.5350000000E+04, 1.6943202660E+01, 5.2689758897E+00, 4.0785788738E+00, 2.0243146036E+00, 8.7634665481E-01],
	[2.5355000000E+04, 1.6948499262E+01, 5.2689271335E+00, 4.0811819330E+00, 2.0250240724E+00, 8.7640650303E-01],
	[2.5360000000E+04, 1.6953796476E+01, 5.2688783873E+00, 4.0837861390E+00, 2.0257334655E+00, 8.7646632297E-01],
	[2.5365000000E+04, 1.6959094301E+01, 5.2688296512E+00, 4.0863914921E+00, 2.0264427829E+00, 8.7652611465E-01],
	[2.5370000000E+04, 1.6964392736E+01, 5.2687809252E+00, 4.0889979926E+00, 2.0271520244E+00, 8.7658587808E-01],
	[2.5375000000E+04, 1.6969691782E+01, 5.2687322092E+00, 4.0916056406E+00, 2.0278611899E+00, 8.7664561327E-01],
	[2.5380000000E+04, 1.6974991439E+01, 5.2686835033E+00, 4.0942144366E+00, 2.0285702794E+00, 8.7670532023E-01],
	[2.5385000000E+04, 1.6980291707E+01, 5.2686348074E+00, 4.0968243808E+00, 2.0292792927E+00, 8.7676499898E-01],
	[2.5390000000E+04, 1.6985592585E+01, 5.2685861215E+00, 4.0994354734E+00, 2.0299882298E+00, 8.7682464951E-01],
	[2.5395000000E+04, 1.6990894074E+01, 5.2685374457E+00, 4.1020477148E+00, 2.0306970904E+00, 8.7688427185E-01],
	[2.5400000000E+04, 1.6996196173E+01, 5.2684887799E+00, 4.1046611052E+00, 2.0314058746E+00, 8.7694386601E-01],
	[2.5405000000E+04, 1.7001498882E+01, 5.2684401242E+00, 4.1072756450E+00, 2.0321145823E+00, 8.7700343199E-01],
	[2.5410000000E+04, 1.7006802202E+01, 5.2683914785E+00, 4.1098913343E+00, 2.0328232132E+00, 8.7706296981E-01],
	[2.5415000000E+04, 1.7012106133E+01, 5.2683428427E+00, 4.1125081734E+00, 2.0335317674E+00, 8.7712247947E-01],
	[2.5420000000E+04, 1.7017410673E+01, 5.2682942170E+00, 4.1151261627E+00, 2.0342402447E+00, 8.7718196099E-01],
	[2.5425000000E+04, 1.7022715824E+01, 5.2682456014E+00, 4.1177453024E+00, 2.0349486450E+00, 8.7724141438E-01],
	[2.5430000000E+04, 1.7028021585E+01, 5.2681969957E+00, 4.1203655928E+00, 2.0356569683E+00, 8.7730083965E-01],
	[2.5435000000E+04, 1.7033327956E+01, 5.2681484000E+00, 4.1229870342E+00, 2.0363652144E+00, 8.7736023681E-01],
	[2.5440000000E+04, 1.7038634938E+01, 5.2680998144E+00, 4.1256096268E+00, 2.0370733832E+00, 8.7741960587E-01],
	[2.5445000000E+04, 1.7043942529E+01, 5.2680512387E+00, 4.1282333710E+00, 2.0377814746E+00, 8.7747894684E-01],
	[2.5450000000E+04, 1.7049250730E+01, 5.2680026730E+00, 4.1308582670E+00, 2.0384894886E+00, 8.7753825973E-01],
	[2.5455000000E+04, 1.7054559541E+01, 5.2679541173E+00, 4.1334843151E+00, 2.0391974250E+00, 8.7759754456E-01],
	[2.5460000000E+04, 1.7059868963E+01, 5.2679055716E+00, 4.1361115155E+00, 2.0399052837E+00, 8.7765680133E-01],
	[2.5465000000E+04, 1.7065178994E+01, 5.2678570359E+00, 4.1387398686E+00, 2.0406130647E+00, 8.7771603006E-01],
	[2.5470000000E+04, 1.7070489634E+01, 5.2678085101E+00, 4.1413693746E+00, 2.0413207677E+00, 8.7777523075E-01],
	[2.5475000000E+04, 1.7075800885E+01, 5.2677599943E+00, 4.1440000338E+00, 2.0420283928E+00, 8.7783440342E-01],
	[2.5480000000E+04, 1.7081112745E+01, 5.2677114885E+00, 4.1466318465E+00, 2.0427359399E+00, 8.7789354808E-01],
	[2.5485000000E+04, 1.7086425215E+01, 5.2676629927E+00, 4.1492648129E+00, 2.0434434087E+00, 8.7795266474E-01],
	[2.5490000000E+04, 1.7091738294E+01, 5.2676145068E+00, 4.1518989334E+00, 2.0441507993E+00, 8.7801175341E-01],
	[2.5495000000E+04, 1.7097060421E+01, 5.2675673905E+00, 4.1545342082E+00, 2.0448584371E+00, 8.7807081410E-01],
	[2.5500000000E+04, 1.7102398158E+01, 5.2675226998E+00, 4.1571706377E+00, 2.0455665757E+00, 8.7812984682E-01],
	[2.5505000000E+04, 1.7107736515E+01, 5.2674780184E+00, 4.1598082219E+00, 2.0462746365E+00, 8.7818885158E-01],
	[2.5510000000E+04, 1.7113075492E+01, 5.2674333460E+00, 4.1624469614E+00, 2.0469826196E+00, 8.7824782839E-01],
	[2.5515000000E+04, 1.7118415087E+01, 5.2673886828E+00, 4.1650868563E+00, 2.0476905248E+00, 8.7830677727E-01],
	[2.5520000000E+04, 1.7123755302E+01, 5.2673440287E+00, 4.1677279069E+00, 2.0483983520E+00, 8.7836569823E-01],
	[2.5525000000E+04, 1.7129096137E+01, 5.2672993838E+00, 4.1703701134E+00, 2.0491061011E+00, 8.7842459127E-01],
	[2.5530000000E+04, 1.7134437590E+01, 5.2672547479E+00, 4.1730134763E+00, 2.0498137720E+00, 8.7848345640E-01],
	[2.5535000000E+04, 1.7139779663E+01, 5.2672101212E+00, 4.1756579957E+00, 2.0505213647E+00, 8.7854229365E-01],
	[2.5540000000E+04, 1.7145122354E+01, 5.2671655036E+00, 4.1783036719E+00, 2.0512288789E+00, 8.7860110301E-01],
	[2.5545000000E+04, 1.7150465665E+01, 5.2671208951E+00, 4.1809505053E+00, 2.0519363147E+00, 8.7865988451E-01],
	[2.5550000000E+04, 1.7155809595E+01, 5.2670762958E+00, 4.1835984960E+00, 2.0526436719E+00, 8.7871863814E-01],
	[2.5555000000E+04, 1.7161154143E+01, 5.2670317055E+00, 4.1862476444E+00, 2.0533509505E+00, 8.7877736393E-01],
	[2.5560000000E+04, 1.7166499311E+01, 5.2669871243E+00, 4.1888979507E+00, 2.0540581502E+00, 8.7883606188E-01],
	[2.5565000000E+04, 1.7171845098E+01, 5.2669425522E+00, 4.1915494153E+00, 2.0547652711E+00, 8.7889473200E-01],
	[2.5570000000E+04, 1.7177191503E+01, 5.2668979893E+00, 4.1942020383E+00, 2.0554723130E+00, 8.7895337431E-01],
	[2.5575000000E+04, 1.7182538527E+01, 5.2668534354E+00, 4.1968558202E+00, 2.0561792759E+00, 8.7901198881E-01],
	[2.5580000000E+04, 1.7187886170E+01, 5.2668088906E+00, 4.1995107611E+00, 2.0568861595E+00, 8.7907057552E-01],
	[2.5585000000E+04, 1.7193234431E+01, 5.2667643548E+00, 4.2021668613E+00, 2.0575929640E+00, 8.7912913445E-01],
	[2.5590000000E+04, 1.7198583311E+01, 5.2667198282E+00, 4.2048241212E+00, 2.0582996890E+00, 8.7918766560E-01],
	[2.5595000000E+04, 1.7203932810E+01, 5.2666753106E+00, 4.2074825409E+00, 2.0590063346E+00, 8.7924616900E-01],
	[2.5600000000E+04, 1.7209282927E+01, 5.2666308021E+00, 4.2101421209E+00, 2.0597129007E+00, 8.7930464464E-01],
	[2.5605000000E+04, 1.7214633662E+01, 5.2665863027E+00, 4.2128028613E+00, 2.0604193871E+00, 8.7936309255E-01],
	[2.5610000000E+04, 1.7219985016E+01, 5.2665418123E+00, 4.2154647624E+00, 2.0611257937E+00, 8.7942151273E-01],
	[2.5615000000E+04, 1.7225336988E+01, 5.2664973310E+00, 4.2181278245E+00, 2.0618321205E+00, 8.7947990519E-01],
	[2.5620000000E+04, 1.7230689579E+01, 5.2664528588E+00, 4.2207920479E+00, 2.0625383674E+00, 8.7953826995E-01],
	[2.5625000000E+04, 1.7236042788E+01, 5.2664083956E+00, 4.2234574329E+00, 2.0632445342E+00, 8.7959660701E-01],
	[2.5630000000E+04, 1.7241396615E+01, 5.2663639415E+00, 4.2261239798E+00, 2.0639506209E+00, 8.7965491639E-01],
	[2.5635000000E+04, 1.7246751060E+01, 5.2663194964E+00, 4.2287916888E+00, 2.0646566273E+00, 8.7971319810E-01],
	[2.5640000000E+04, 1.7252106124E+01, 5.2662750603E+00, 4.2314605602E+00, 2.0653625535E+00, 8.7977145214E-01],
	[2.5645000000E+04, 1.7257461805E+01, 5.2662306333E+00, 4.2341305942E+00, 2.0660683992E+00, 8.7982967854E-01],
	[2.5650000000E+04, 1.7262818105E+01, 5.2661862153E+00, 4.2368017913E+00, 2.0667741644E+00, 8.7988787730E-01],
	[2.5655000000E+04, 1.7268175022E+01, 5.2661418064E+00, 4.2394741516E+00, 2.0674798489E+00, 8.7994604842E-01],
	[2.5660000000E+04, 1.7273532557E+01, 5.2660974065E+00, 4.2421476754E+00, 2.0681854528E+00, 8.8000419193E-01],
	[2.5665000000E+04, 1.7278890711E+01, 5.2660530156E+00, 4.2448223630E+00, 2.0688909758E+00, 8.8006230784E-01],
	[2.5670000000E+04, 1.7284249482E+01, 5.2660086337E+00, 4.2474982147E+00, 2.0695964180E+00, 8.8012039615E-01],
	[2.5675000000E+04, 1.7289608871E+01, 5.2659642609E+00, 4.2501752308E+00, 2.0703017791E+00, 8.8017845687E-01],
	[2.5680000000E+04, 1.7294968877E+01, 5.2659198970E+00, 4.2528534115E+00, 2.0710070591E+00, 8.8023649002E-01],
	[2.5685000000E+04, 1.7300329501E+01, 5.2658755422E+00, 4.2555327571E+00, 2.0717122580E+00, 8.8029449561E-01],
	[2.5690000000E+04, 1.7305690743E+01, 5.2658311964E+00, 4.2582132680E+00, 2.0724173755E+00, 8.8035247365E-01],
	[2.5695000000E+04, 1.7311052603E+01, 5.2657868596E+00, 4.2608949443E+00, 2.0731224117E+00, 8.8041042415E-01],
	[2.5700000000E+04, 1.7316415080E+01, 5.2657425318E+00, 4.2635777863E+00, 2.0738273664E+00, 8.8046834712E-01],
	[2.5705000000E+04, 1.7321778174E+01, 5.2656982129E+00, 4.2662617945E+00, 2.0745322395E+00, 8.8052624257E-01],
	[2.5710000000E+04, 1.7327141886E+01, 5.2656539031E+00, 4.2689469689E+00, 2.0752370310E+00, 8.8058411052E-01],
	[2.5715000000E+04, 1.7332506215E+01, 5.2656096023E+00, 4.2716333099E+00, 2.0759417407E+00, 8.8064195097E-01],
	[2.5720000000E+04, 1.7337871162E+01, 5.2655653104E+00, 4.2743208178E+00, 2.0766463685E+00, 8.8069976394E-01],
	[2.5725000000E+04, 1.7343236725E+01, 5.2655210275E+00, 4.2770094929E+00, 2.0773509144E+00, 8.8075754943E-01],
	[2.5730000000E+04, 1.7348602907E+01, 5.2654767537E+00, 4.2796993354E+00, 2.0780553782E+00, 8.8081530746E-01],
	[2.5735000000E+04, 1.7353969705E+01, 5.2654324887E+00, 4.2823903456E+00, 2.0787597599E+00, 8.8087303804E-01],
	[2.5740000000E+04, 1.7359337120E+01, 5.2653882328E+00, 4.2850825238E+00, 2.0794640594E+00, 8.8093074118E-01],
	[2.5745000000E+04, 1.7364705153E+01, 5.2653439858E+00, 4.2877758703E+00, 2.0801682765E+00, 8.8098841689E-01],
	[2.5750000000E+04, 1.7370073802E+01, 5.2652997478E+00, 4.2904703853E+00, 2.0808724112E+00, 8.8104606518E-01],
	[2.5755000000E+04, 1.7375443069E+01, 5.2652555188E+00, 4.2931660692E+00, 2.0815764633E+00, 8.8110368607E-01],
	[2.5760000000E+04, 1.7380812952E+01, 5.2652112987E+00, 4.2958629221E+00, 2.0822804329E+00, 8.8116127956E-01],
	[2.5765000000E+04, 1.7386183453E+01, 5.2651670875E+00, 4.2985609445E+00, 2.0829843197E+00, 8.8121884566E-01],
	[2.5770000000E+04, 1.7391554570E+01, 5.2651228853E+00, 4.3012601366E+00, 2.0836881238E+00, 8.8127638440E-01],
	[2.5775000000E+04, 1.7396926304E+01, 5.2650786921E+00, 4.3039604985E+00, 2.0843918449E+00, 8.8133389577E-01],
	[2.5780000000E+04, 1.7402298654E+01, 5.2650345078E+00, 4.3066620308E+00, 2.0850954831E+00, 8.8139137978E-01],
	[2.5785000000E+04, 1.7407671622E+01, 5.2649903324E+00, 4.3093647335E+00, 2.0857990381E+00, 8.8144883646E-01],
	[2.5790000000E+04, 1.7413045206E+01, 5.2649461660E+00, 4.3120686070E+00, 2.0865025100E+00, 8.8150626581E-01],
	[2.5795000000E+04, 1.7418419407E+01, 5.2649020085E+00, 4.3147736516E+00, 2.0872058986E+00, 8.8156366785E-01],
	[2.5800000000E+04, 1.7423794224E+01, 5.2648578599E+00, 4.3174798675E+00, 2.0879092039E+00, 8.8162104257E-01],
	[2.5805000000E+04, 1.7429169657E+01, 5.2648137203E+00, 4.3201872551E+00, 2.0886124257E+00, 8.8167839001E-01],
	[2.5810000000E+04, 1.7434545708E+01, 5.2647695896E+00, 4.3228958146E+00, 2.0893155639E+00, 8.8173571015E-01],
	[2.5815000000E+04, 1.7439922374E+01, 5.2647254678E+00, 4.3256055462E+00, 2.0900186185E+00, 8.8179300303E-01],
	[2.5820000000E+04, 1.7445299657E+01, 5.2646813549E+00, 4.3283164503E+00, 2.0907215894E+00, 8.8185026864E-01],
	[2.5825000000E+04, 1.7450677556E+01, 5.2646372509E+00, 4.3310285272E+00, 2.0914244764E+00, 8.8190750700E-01],
	[2.5830000000E+04, 1.7456056072E+01, 5.2645931558E+00, 4.3337417771E+00, 2.0921272795E+00, 8.8196471812E-01],
	[2.5835000000E+04, 1.7461435203E+01, 5.2645490697E+00, 4.3364562003E+00, 2.0928299986E+00, 8.8202190202E-01],
	[2.5840000000E+04, 1.7466814951E+01, 5.2645049924E+00, 4.3391717971E+00, 2.0935326336E+00, 8.8207905869E-01],
	[2.5845000000E+04, 1.7472195315E+01, 5.2644609240E+00, 4.3418885677E+00, 2.0942351843E+00, 8.8213618816E-01],
	[2.5850000000E+04, 1.7477576295E+01, 5.2644168646E+00, 4.3446065125E+00, 2.0949376508E+00, 8.8219329044E-01],
	[2.5855000000E+04, 1.7482957891E+01, 5.2643728140E+00, 4.3473256317E+00, 2.0956400329E+00, 8.8225036553E-01],
	[2.5860000000E+04, 1.7488340103E+01, 5.2643287723E+00, 4.3500459256E+00, 2.0963423305E+00, 8.8230741345E-01],
	[2.5865000000E+04, 1.7493722931E+01, 5.2642847395E+00, 4.3527673945E+00, 2.0970445435E+00, 8.8236443421E-01],
	[2.5870000000E+04, 1.7499106375E+01, 5.2642407155E+00, 4.3554900387E+00, 2.0977466719E+00, 8.8242142782E-01],
	[2.5875000000E+04, 1.7504490435E+01, 5.2641967005E+00, 4.3582138584E+00, 2.0984487155E+00, 8.8247839429E-01],
	[2.5880000000E+04, 1.7509875110E+01, 5.2641526943E+00, 4.3609388539E+00, 2.0991506743E+00, 8.8253533363E-01],
	[2.5885000000E+04, 1.7515260401E+01, 5.2641086970E+00, 4.3636650256E+00, 2.0998525481E+00, 8.8259224586E-01],
	[2.5890000000E+04, 1.7520646308E+01, 5.2640647085E+00, 4.3663923736E+00, 2.1005543369E+00, 8.8264913098E-01],
	[2.5895000000E+04, 1.7526032830E+01, 5.2640207289E+00, 4.3691208982E+00, 2.1012560406E+00, 8.8270598900E-01],
	[2.5900000000E+04, 1.7531419968E+01, 5.2639767582E+00, 4.3718505998E+00, 2.1019576590E+00, 8.8276281995E-01],
	[2.5905000000E+04, 1.7536814225E+01, 5.2639338306E+00, 4.3745814787E+00, 2.1026594507E+00, 8.8281962382E-01],
	[2.5910000000E+04, 1.7542225919E+01, 5.2638935854E+00, 4.3773135350E+00, 2.1033618259E+00, 8.8287640063E-01],
	[2.5915000000E+04, 1.7547638238E+01, 5.2638533483E+00, 4.3800467691E+00, 2.1040641165E+00, 8.8293315039E-01],
	[2.5920000000E+04, 1.7553051182E+01, 5.2638131192E+00, 4.3827811813E+00, 2.1047663223E+00, 8.8298987312E-01],
	[2.5925000000E+04, 1.7558464751E+01, 5.2637728982E+00, 4.3855167718E+00, 2.1054684434E+00, 8.8304656882E-01],
	[2.5930000000E+04, 1.7563878945E+01, 5.2637326852E+00, 4.3882535409E+00, 2.1061704795E+00, 8.8310323750E-01],
	[2.5935000000E+04, 1.7569293765E+01, 5.2636924804E+00, 4.3909914890E+00, 2.1068724307E+00, 8.8315987918E-01],
	[2.5940000000E+04, 1.7574709209E+01, 5.2636522835E+00, 4.3937306162E+00, 2.1075742968E+00, 8.8321649386E-01],
	[2.5945000000E+04, 1.7580125279E+01, 5.2636120948E+00, 4.3964709229E+00, 2.1082760776E+00, 8.8327308157E-01],
	[2.5950000000E+04, 1.7585541973E+01, 5.2635719141E+00, 4.3992124093E+00, 2.1089777733E+00, 8.8332964230E-01],
	[2.5955000000E+04, 1.7590959293E+01, 5.2635317414E+00, 4.4019550757E+00, 2.1096793836E+00, 8.8338617608E-01],
	[2.5960000000E+04, 1.7596377237E+01, 5.2634915768E+00, 4.4046989224E+00, 2.1103809084E+00, 8.8344268290E-01],
	[2.5965000000E+04, 1.7601795806E+01, 5.2634514202E+00, 4.4074439498E+00, 2.1110823477E+00, 8.8349916279E-01],
	[2.5970000000E+04, 1.7607215000E+01, 5.2634112716E+00, 4.4101901579E+00, 2.1117837013E+00, 8.8355561576E-01],
	[2.5975000000E+04, 1.7612634818E+01, 5.2633711311E+00, 4.4129375472E+00, 2.1124849693E+00, 8.8361204181E-01],
	[2.5980000000E+04, 1.7618055262E+01, 5.2633309986E+00, 4.4156861180E+00, 2.1131861514E+00, 8.8366844095E-01],
	[2.5985000000E+04, 1.7623476329E+01, 5.2632908742E+00, 4.4184358704E+00, 2.1138872477E+00, 8.8372481321E-01],
	[2.5990000000E+04, 1.7628898022E+01, 5.2632507578E+00, 4.4211868048E+00, 2.1145882579E+00, 8.8378115858E-01],
	[2.5995000000E+04, 1.7634320339E+01, 5.2632106494E+00, 4.4239389215E+00, 2.1152891821E+00, 8.8383747709E-01],
	[2.6000000000E+04, 1.7639743280E+01, 5.2631705490E+00, 4.4266922207E+00, 2.1159900201E+00, 8.8389376874E-01],
	[2.6005000000E+04, 1.7645166846E+01, 5.2631304566E+00, 4.4294467027E+00, 2.1166907718E+00, 8.8395003354E-01],
	[2.6010000000E+04, 1.7650591036E+01, 5.2630903723E+00, 4.4322023678E+00, 2.1173914372E+00, 8.8400627151E-01],
	[2.6015000000E+04, 1.7656015850E+01, 5.2630502959E+00, 4.4349592163E+00, 2.1180920162E+00, 8.8406248265E-01],
	[2.6020000000E+04, 1.7661441289E+01, 5.2630102276E+00, 4.4377172485E+00, 2.1187925086E+00, 8.8411866698E-01],
	[2.6025000000E+04, 1.7666867352E+01, 5.2629701672E+00, 4.4404764646E+00, 2.1194929144E+00, 8.8417482451E-01],
	[2.6030000000E+04, 1.7672294039E+01, 5.2629301149E+00, 4.4432368649E+00, 2.1201932335E+00, 8.8423095524E-01],
	[2.6035000000E+04, 1.7677721350E+01, 5.2628900706E+00, 4.4459984497E+00, 2.1208934659E+00, 8.8428705920E-01],
	[2.6040000000E+04, 1.7683149286E+01, 5.2628500342E+00, 4.4487612193E+00, 2.1215936113E+00, 8.8434313640E-01],
	[2.6045000000E+04, 1.7688577845E+01, 5.2628100059E+00, 4.4515251740E+00, 2.1222936698E+00, 8.8439918683E-01],
	[2.6050000000E+04, 1.7694007028E+01, 5.2627699855E+00, 4.4542903140E+00, 2.1229936412E+00, 8.8445521052E-01],
	[2.6055000000E+04, 1.7699436836E+01, 5.2627299731E+00, 4.4570566396E+00, 2.1236935254E+00, 8.8451120748E-01],
	[2.6060000000E+04, 1.7704867267E+01, 5.2626899688E+00, 4.4598241511E+00, 2.1243933224E+00, 8.8456717771E-01],
	[2.6065000000E+04, 1.7710298322E+01, 5.2626499723E+00, 4.4625928488E+00, 2.1250930321E+00, 8.8462312124E-01],
	[2.6070000000E+04, 1.7715730001E+01, 5.2626099839E+00, 4.4653627330E+00, 2.1257926544E+00, 8.8467903806E-01],
	[2.6075000000E+04, 1.7721162303E+01, 5.2625700034E+00, 4.4681338039E+00, 2.1264921891E+00, 8.8473492818E-01],
	[2.6080000000E+04, 1.7726595229E+01, 5.2625300309E+00, 4.4709060618E+00, 2.1271916363E+00, 8.8479079157E-01],
	[2.6085000000E+04, 1.7732028779E+01, 5.2624900664E+00, 4.4736795070E+00, 2.1278909958E+00, 8.8484662825E-01],
	[2.6090000000E+04, 1.7737462953E+01, 5.2624501098E+00, 4.4764541399E+00, 2.1285902675E+00, 8.8490243824E-01],
	[2.6095000000E+04, 1.7742897750E+01, 5.2624101612E+00, 4.4792299605E+00, 2.1292894513E+00, 8.8495822152E-01],
	[2.6100000000E+04, 1.7748333171E+01, 5.2623702206E+00, 4.4820069693E+00, 2.1299885473E+00, 8.8501397813E-01],
	[2.6105000000E+04, 1.7753769215E+01, 5.2623302879E+00, 4.4847851666E+00, 2.1306875551E+00, 8.8506970806E-01],
	[2.6110000000E+04, 1.7759205882E+01, 5.2622903631E+00, 4.4875645525E+00, 2.1313864749E+00, 8.8512541132E-01],
	[2.6115000000E+04, 1.7764643173E+01, 5.2622504463E+00, 4.4903451274E+00, 2.1320853064E+00, 8.8518108793E-01],
	[2.6120000000E+04, 1.7770081087E+01, 5.2622105375E+00, 4.4931268916E+00, 2.1327840497E+00, 8.8523673790E-01],
	[2.6125000000E+04, 1.7775519624E+01, 5.2621706366E+00, 4.4959098453E+00, 2.1334827045E+00, 8.8529236123E-01],
	[2.6130000000E+04, 1.7780958785E+01, 5.2621307436E+00, 4.4986939889E+00, 2.1341812709E+00, 8.8534795794E-01],
	[2.6135000000E+04, 1.7786398569E+01, 5.2620908585E+00, 4.5014793226E+00, 2.1348797488E+00, 8.8540352802E-01],
	[2.6140000000E+04, 1.7791838976E+01, 5.2620509814E+00, 4.5042658466E+00, 2.1355781380E+00, 8.8545907151E-01],
	[2.6145000000E+04, 1.7797280006E+01, 5.2620111122E+00, 4.5070535613E+00, 2.1362764384E+00, 8.8551458839E-01],
	[2.6150000000E+04, 1.7802721659E+01, 5.2619712510E+00, 4.5098424669E+00, 2.1369746500E+00, 8.8557007869E-01],
	[2.6155000000E+04, 1.7808163935E+01, 5.2619313977E+00, 4.5126325638E+00, 2.1376727728E+00, 8.8562554241E-01],
	[2.6160000000E+04, 1.7813606834E+01, 5.2618915523E+00, 4.5154238522E+00, 2.1383708065E+00, 8.8568097956E-01],
	[2.6165000000E+04, 1.7819050355E+01, 5.2618517148E+00, 4.5182163324E+00, 2.1390687511E+00, 8.8573639016E-01],
	[2.6170000000E+04, 1.7824494500E+01, 5.2618118852E+00, 4.5210100046E+00, 2.1397666066E+00, 8.8579177421E-01],
	[2.6175000000E+04, 1.7829939268E+01, 5.2617720635E+00, 4.5238048692E+00, 2.1404643728E+00, 8.8584713171E-01],
	[2.6180000000E+04, 1.7835384658E+01, 5.2617322497E+00, 4.5266009264E+00, 2.1411620497E+00, 8.8590246269E-01],
	[2.6185000000E+04, 1.7840830671E+01, 5.2616924439E+00, 4.5293981765E+00, 2.1418596371E+00, 8.8595776715E-01],
	[2.6190000000E+04, 1.7846277306E+01, 5.2616526459E+00, 4.5321966199E+00, 2.1425571351E+00, 8.8601304510E-01],
	[2.6195000000E+04, 1.7851724564E+01, 5.2616128559E+00, 4.5349962566E+00, 2.1432545434E+00, 8.8606829655E-01],
	[2.6200000000E+04, 1.7857172445E+01, 5.2615730737E+00, 4.5377970872E+00, 2.1439518621E+00, 8.8612352151E-01],
	[2.6205000000E+04, 1.7862620948E+01, 5.2615332994E+00, 4.5405991117E+00, 2.1446490909E+00, 8.8617871999E-01],
	[2.6210000000E+04, 1.7868070074E+01, 5.2614935330E+00, 4.5434023306E+00, 2.1453462299E+00, 8.8623389200E-01],
	[2.6215000000E+04, 1.7873519822E+01, 5.2614537745E+00, 4.5462067441E+00, 2.1460432790E+00, 8.8628903754E-01],
	[2.6220000000E+04, 1.7878970192E+01, 5.2614140239E+00, 4.5490123524E+00, 2.1467402381E+00, 8.8634415664E-01],
	[2.6225000000E+04, 1.7884421185E+01, 5.2613742812E+00, 4.5518191559E+00, 2.1474371070E+00, 8.8639924929E-01],
	[2.6230000000E+04, 1.7889872800E+01, 5.2613345463E+00, 4.5546271548E+00, 2.1481338857E+00, 8.8645431552E-01],
	[2.6235000000E+04, 1.7895325037E+01, 5.2612948194E+00, 4.5574363494E+00, 2.1488305741E+00, 8.8650935532E-01],
	[2.6240000000E+04, 1.7900777896E+01, 5.2612551002E+00, 4.5602467401E+00, 2.1495271722E+00, 8.8656436870E-01],
	[2.6245000000E+04, 1.7906231378E+01, 5.2612153890E+00, 4.5630583270E+00, 2.1502236798E+00, 8.8661935569E-01],
	[2.6250000000E+04, 1.7911685481E+01, 5.2611756856E+00, 4.5658711104E+00, 2.1509200968E+00, 8.8667431629E-01],
	[2.6255000000E+04, 1.7917140207E+01, 5.2611359901E+00, 4.5686850907E+00, 2.1516164233E+00, 8.8672925050E-01],
	[2.6260000000E+04, 1.7922595554E+01, 5.2610963024E+00, 4.5715002682E+00, 2.1523126590E+00, 8.8678415833E-01],
	[2.6265000000E+04, 1.7928051524E+01, 5.2610566226E+00, 4.5743166430E+00, 2.1530088039E+00, 8.8683903981E-01],
	[2.6270000000E+04, 1.7933508115E+01, 5.2610169507E+00, 4.5771342155E+00, 2.1537048579E+00, 8.8689389493E-01],
	[2.6275000000E+04, 1.7938965328E+01, 5.2609772866E+00, 4.5799529859E+00, 2.1544008210E+00, 8.8694872371E-01],
	[2.6280000000E+04, 1.7944423163E+01, 5.2609376303E+00, 4.5827729546E+00, 2.1550966930E+00, 8.8700352616E-01],
	[2.6285000000E+04, 1.7949881620E+01, 5.2608979819E+00, 4.5855941218E+00, 2.1557924738E+00, 8.8705830228E-01],
	[2.6290000000E+04, 1.7955340699E+01, 5.2608583413E+00, 4.5884164878E+00, 2.1564881635E+00, 8.8711305208E-01],
	[2.6295000000E+04, 1.7960800399E+01, 5.2608187086E+00, 4.5912400529E+00, 2.1571837618E+00, 8.8716777559E-01],
	[2.6300000000E+04, 1.7966260720E+01, 5.2607790837E+00, 4.5940648174E+00, 2.1578792687E+00, 8.8722247280E-01],
	[2.6305000000E+04, 1.7971721664E+01, 5.2607394666E+00, 4.5968907815E+00, 2.1585746842E+00, 8.8727714372E-01],
	[2.6310000000E+04, 1.7977183228E+01, 5.2606998573E+00, 4.5997179455E+00, 2.1592700081E+00, 8.8733178837E-01],
	[2.6315000000E+04, 1.7982645414E+01, 5.2606602559E+00, 4.6025463097E+00, 2.1599652404E+00, 8.8738640676E-01],
	[2.6320000000E+04, 1.7988108222E+01, 5.2606206623E+00, 4.6053758744E+00, 2.1606603809E+00, 8.8744099889E-01],
	[2.6325000000E+04, 1.7993591988E+01, 5.2605842681E+00, 4.6082066399E+00, 2.1613562618E+00, 8.8749556477E-01],
	[2.6330000000E+04, 1.7999079253E+01, 5.2605483313E+00, 4.6110386065E+00, 2.1620521690E+00, 8.8755010443E-01],
	[2.6335000000E+04, 1.8004567149E+01, 5.2605124016E+00, 4.6138717743E+00, 2.1627479851E+00, 8.8760461785E-01],
	[2.6340000000E+04, 1.8010055677E+01, 5.2604764789E+00, 4.6167061438E+00, 2.1634437099E+00, 8.8765910506E-01],
	[2.6345000000E+04, 1.8015544835E+01, 5.2604405633E+00, 4.6195417151E+00, 2.1641393435E+00, 8.8771356607E-01],
	[2.6350000000E+04, 1.8021034624E+01, 5.2604046548E+00, 4.6223784887E+00, 2.1648348857E+00, 8.8776800088E-01],
	[2.6355000000E+04, 1.8026525044E+01, 5.2603687533E+00, 4.6252164647E+00, 2.1655303364E+00, 8.8782240951E-01],
	[2.6360000000E+04, 1.8032016094E+01, 5.2603328589E+00, 4.6280556434E+00, 2.1662256955E+00, 8.8787679196E-01],
	[2.6365000000E+04, 1.8037507775E+01, 5.2602969715E+00, 4.6308960251E+00, 2.1669209630E+00, 8.8793114824E-01],
	[2.6370000000E+04, 1.8043000087E+01, 5.2602610912E+00, 4.6337376101E+00, 2.1676161389E+00, 8.8798547837E-01],
	[2.6375000000E+04, 1.8048493030E+01, 5.2602252179E+00, 4.6365803987E+00, 2.1683112229E+00, 8.8803978235E-01],
	[2.6380000000E+04, 1.8053986603E+01, 5.2601893517E+00, 4.6394243912E+00, 2.1690062150E+00, 8.8809406020E-01],
	[2.6385000000E+04, 1.8059480806E+01, 5.2601534925E+00, 4.6422695878E+00, 2.1697011151E+00, 8.8814831192E-01],
	[2.6390000000E+04, 1.8064975640E+01, 5.2601176403E+00, 4.6451159888E+00, 2.1703959232E+00, 8.8820253753E-01],
	[2.6395000000E+04, 1.8070471105E+01, 5.2600817952E+00, 4.6479635945E+00, 2.1710906392E+00, 8.8825673703E-01],
	[2.6400000000E+04, 1.8075967200E+01, 5.2600459571E+00, 4.6508124052E+00, 2.1717852629E+00, 8.8831091044E-01],
	[2.6405000000E+04, 1.8081463925E+01, 5.2600101261E+00, 4.6536624211E+00, 2.1724797944E+00, 8.8836505776E-01],
	[2.6410000000E+04, 1.8086961280E+01, 5.2599743021E+00, 4.6565136426E+00, 2.1731742335E+00, 8.8841917900E-01],
	[2.6415000000E+04, 1.8092459266E+01, 5.2599384851E+00, 4.6593660699E+00, 2.1738685801E+00, 8.8847327418E-01],
	[2.6420000000E+04, 1.8097957882E+01, 5.2599026751E+00, 4.6622197034E+00, 2.1745628342E+00, 8.8852734330E-01],
	[2.6425000000E+04, 1.8103457127E+01, 5.2598668721E+00, 4.6650745432E+00, 2.1752569956E+00, 8.8858138638E-01],
	[2.6430000000E+04, 1.8108957003E+01, 5.2598310762E+00, 4.6679305896E+00, 2.1759510643E+00, 8.8863540342E-01],
	[2.6435000000E+04, 1.8114457510E+01, 5.2597952873E+00, 4.6707878430E+00, 2.1766450403E+00, 8.8868939444E-01],
	[2.6440000000E+04, 1.8119958646E+01, 5.2597595054E+00, 4.6736463037E+00, 2.1773389234E+00, 8.8874335944E-01],
	[2.6445000000E+04, 1.8125460412E+01, 5.2597237305E+00, 4.6765059719E+00, 2.1780327135E+00, 8.8879729843E-01],
	[2.6450000000E+04, 1.8130962808E+01, 5.2596879626E+00, 4.6793668478E+00, 2.1787264106E+00, 8.8885121143E-01],
	[2.6455000000E+04, 1.8136465833E+01, 5.2596522017E+00, 4.6822289318E+00, 2.1794200145E+00, 8.8890509845E-01],
	[2.6460000000E+04, 1.8141969489E+01, 5.2596164478E+00, 4.6850922242E+00, 2.1801135253E+00, 8.8895895949E-01],
	[2.6465000000E+04, 1.8147473774E+01, 5.2595807009E+00, 4.6879567252E+00, 2.1808069428E+00, 8.8901279456E-01],
	[2.6470000000E+04, 1.8152978689E+01, 5.2595449610E+00, 4.6908224351E+00, 2.1815002669E+00, 8.8906660368E-01],
	[2.6475000000E+04, 1.8158484234E+01, 5.2595092281E+00, 4.6936893543E+00, 2.1821934976E+00, 8.8912038685E-01],
	[2.6480000000E+04, 1.8163990408E+01, 5.2594735022E+00, 4.6965574829E+00, 2.1828866347E+00, 8.8917414409E-01],
	[2.6485000000E+04, 1.8169497212E+01, 5.2594377833E+00, 4.6994268212E+00, 2.1835796782E+00, 8.8922787540E-01],
	[2.6490000000E+04, 1.8175004645E+01, 5.2594020713E+00, 4.7022973696E+00, 2.1842726281E+00, 8.8928158079E-01],
	[2.6495000000E+04, 1.8180512708E+01, 5.2593663664E+00, 4.7051691283E+00, 2.1849654842E+00, 8.8933526029E-01],
	[2.6500000000E+04, 1.8186021401E+01, 5.2593306684E+00, 4.7080420977E+00, 2.1856582464E+00, 8.8938891388E-01],
	[2.6505000000E+04, 1.8191530722E+01, 5.2592949774E+00, 4.7109162779E+00, 2.1863509147E+00, 8.8944254160E-01],
	[2.6510000000E+04, 1.8197040673E+01, 5.2592592934E+00, 4.7137916692E+00, 2.1870434890E+00, 8.8949614344E-01],
	[2.6515000000E+04, 1.8202551254E+01, 5.2592236163E+00, 4.7166682721E+00, 2.1877359692E+00, 8.8954971941E-01],
	[2.6520000000E+04, 1.8208062463E+01, 5.2591879463E+00, 4.7195460866E+00, 2.1884283553E+00, 8.8960326953E-01],
	[2.6525000000E+04, 1.8213574302E+01, 5.2591522831E+00, 4.7224251132E+00, 2.1891206471E+00, 8.8965679380E-01],
	[2.6530000000E+04, 1.8219086770E+01, 5.2591166270E+00, 4.7253053520E+00, 2.1898128445E+00, 8.8971029224E-01],
	[2.6535000000E+04, 1.8224599867E+01, 5.2590809778E+00, 4.7281868034E+00, 2.1905049476E+00, 8.8976376486E-01],
	[2.6540000000E+04, 1.8230113593E+01, 5.2590453356E+00, 4.7310694677E+00, 2.1911969561E+00, 8.8981721166E-01],
	[2.6545000000E+04, 1.8235627948E+01, 5.2590097003E+00, 4.7339533451E+00, 2.1918888701E+00, 8.8987063266E-01],
	[2.6550000000E+04, 1.8241142932E+01, 5.2589740720E+00, 4.7368384359E+00, 2.1925806894E+00, 8.8992402787E-01],
	[2.6555000000E+04, 1.8246658545E+01, 5.2589384506E+00, 4.7397247404E+00, 2.1932724140E+00, 8.8997739729E-01],
	[2.6560000000E+04, 1.8252174787E+01, 5.2589028362E+00, 4.7426122589E+00, 2.1939640438E+00, 8.9003074094E-01],
	[2.6565000000E+04, 1.8257691657E+01, 5.2588672287E+00, 4.7455009917E+00, 2.1946555786E+00, 8.9008405882E-01],
	[2.6570000000E+04, 1.8263209157E+01, 5.2588316281E+00, 4.7483909390E+00, 2.1953470186E+00, 8.9013735096E-01],
	[2.6575000000E+04, 1.8268727285E+01, 5.2587960345E+00, 4.7512821011E+00, 2.1960383634E+00, 8.9019061735E-01],
	[2.6580000000E+04, 1.8274246042E+01, 5.2587604479E+00, 4.7541744783E+00, 2.1967296131E+00, 8.9024385800E-01],
	[2.6585000000E+04, 1.8279765427E+01, 5.2587248681E+00, 4.7570680709E+00, 2.1974207677E+00, 8.9029707294E-01],
	[2.6590000000E+04, 1.8285285441E+01, 5.2586892953E+00, 4.7599628792E+00, 2.1981118269E+00, 8.9035026216E-01],
	[2.6595000000E+04, 1.8290806084E+01, 5.2586537295E+00, 4.7628589034E+00, 2.1988027908E+00, 8.9040342568E-01],
	[2.6600000000E+04, 1.8296327355E+01, 5.2586181705E+00, 4.7657561439E+00, 2.1994936592E+00, 8.9045656351E-01],
	[2.6605000000E+04, 1.8301849254E+01, 5.2585826185E+00, 4.7686546009E+00, 2.2001844321E+00, 8.9050967565E-01],
	[2.6610000000E+04, 1.8307371782E+01, 5.2585470734E+00, 4.7715542746E+00, 2.2008751093E+00, 8.9056276213E-01],
	[2.6615000000E+04, 1.8312894939E+01, 5.2585115352E+00, 4.7744551655E+00, 2.2015656909E+00, 8.9061582294E-01],
	[2.6620000000E+04, 1.8318418723E+01, 5.2584760040E+00, 4.7773572736E+00, 2.2022561768E+00, 8.9066885811E-01],
	[2.6625000000E+04, 1.8323943136E+01, 5.2584404796E+00, 4.7802605995E+00, 2.2029465668E+00, 8.9072186763E-01],
	[2.6630000000E+04, 1.8329468177E+01, 5.2584049622E+00, 4.7831651432E+00, 2.2036368609E+00, 8.9077485152E-01],
	[2.6635000000E+04, 1.8334993846E+01, 5.2583694517E+00, 4.7860709052E+00, 2.2043270589E+00, 8.9082780979E-01],
	[2.6640000000E+04, 1.8340520144E+01, 5.2583339480E+00, 4.7889778856E+00, 2.2050171609E+00, 8.9088074245E-01],
	[2.6645000000E+04, 1.8346047069E+01, 5.2582984513E+00, 4.7918860848E+00, 2.2057071668E+00, 8.9093364951E-01],
	[2.6650000000E+04, 1.8351574623E+01, 5.2582629615E+00, 4.7947955030E+00, 2.2063970764E+00, 8.9098653099E-01],
	[2.6655000000E+04, 1.8357102804E+01, 5.2582274786E+00, 4.7977061406E+00, 2.2070868897E+00, 8.9103938688E-01],
	[2.6660000000E+04, 1.8362631613E+01, 5.2581920025E+00, 4.8006179978E+00, 2.2077766066E+00, 8.9109221720E-01],
	[2.6665000000E+04, 1.8368161051E+01, 5.2581565334E+00, 4.8035310748E+00, 2.2084662270E+00, 8.9114502196E-01],
	[2.6670000000E+04, 1.8373691116E+01, 5.2581210712E+00, 4.8064453721E+00, 2.2091557509E+00, 8.9119780118E-01],
	[2.6675000000E+04, 1.8379221809E+01, 5.2580856158E+00, 4.8093608897E+00, 2.2098451782E+00, 8.9125055486E-01],
	[2.6680000000E+04, 1.8384753129E+01, 5.2580501673E+00, 4.8122776282E+00, 2.2105345088E+00, 8.9130328300E-01],
	[2.6685000000E+04, 1.8390285078E+01, 5.2580147257E+00, 4.8151955876E+00, 2.2112237426E+00, 8.9135598564E-01],
	[2.6690000000E+04, 1.8395817654E+01, 5.2579792910E+00, 4.8181147684E+00, 2.2119128795E+00, 8.9140866276E-01],
	[2.6695000000E+04, 1.8401350857E+01, 5.2579438632E+00, 4.8210351707E+00, 2.2126019195E+00, 8.9146131439E-01],
	[2.6700000000E+04, 1.8406884689E+01, 5.2579084422E+00, 4.8239567949E+00, 2.2132908625E+00, 8.9151394052E-01],
	[2.6705000000E+04, 1.8412419147E+01, 5.2578730281E+00, 4.8268796412E+00, 2.2139797084E+00, 8.9156654119E-01],
	[2.6710000000E+04, 1.8417954234E+01, 5.2578376209E+00, 4.8298037099E+00, 2.2146684572E+00, 8.9161911638E-01],
	[2.6715000000E+04, 1.8423489947E+01, 5.2578022205E+00, 4.8327290014E+00, 2.2153571087E+00, 8.9167166612E-01],
	[2.6720000000E+04, 1.8429026288E+01, 5.2577668270E+00, 4.8356555158E+00, 2.2160456629E+00, 8.9172419042E-01],
	[2.6725000000E+04, 1.8434563256E+01, 5.2577314404E+00, 4.8385832535E+00, 2.2167341197E+00, 8.9177668928E-01],
	[2.6730000000E+04, 1.8440100852E+01, 5.2576960606E+00, 4.8415122148E+00, 2.2174224790E+00, 8.9182916271E-01],
	[2.6735000000E+04, 1.8445639075E+01, 5.2576606877E+00, 4.8444423999E+00, 2.2181107408E+00, 8.9188161073E-01],
	[2.6740000000E+04, 1.8451177925E+01, 5.2576253216E+00, 4.8473738091E+00, 2.2187989049E+00, 8.9193403334E-01],
	[2.6745000000E+04, 1.8456720430E+01, 5.2575904315E+00, 4.8503064428E+00, 2.2194870987E+00, 8.9198643056E-01],
	[2.6750000000E+04, 1.8462283624E+01, 5.2575586560E+00, 4.8532403011E+00, 2.2201760392E+00, 8.9203880240E-01],
	[2.6755000000E+04, 1.8467847456E+01, 5.2575268867E+00, 4.8561753843E+00, 2.2208648827E+00, 8.9209114886E-01],
	[2.6760000000E+04, 1.8473411924E+01, 5.2574951235E+00, 4.8591116928E+00, 2.2215536290E+00, 8.9214346996E-01],
	[2.6765000000E+04, 1.8478977029E+01, 5.2574633664E+00, 4.8620492268E+00, 2.2222422782E+00, 8.9219576570E-01],
	[2.6770000000E+04, 1.8484542770E+01, 5.2574316154E+00, 4.8649879867E+00, 2.2229308302E+00, 8.9224803611E-01],
	[2.6775000000E+04, 1.8490109148E+01, 5.2573998706E+00, 4.8679279726E+00, 2.2236192848E+00, 8.9230028118E-01],
	[2.6780000000E+04, 1.8495676162E+01, 5.2573681318E+00, 4.8708691849E+00, 2.2243076420E+00, 8.9235250093E-01],
	[2.6785000000E+04, 1.8501243812E+01, 5.2573363992E+00, 4.8738116238E+00, 2.2249959017E+00, 8.9240469537E-01],
	[2.6790000000E+04, 1.8506812099E+01, 5.2573046727E+00, 4.8767552897E+00, 2.2256840638E+00, 8.9245686451E-01],
	[2.6795000000E+04, 1.8512381022E+01, 5.2572729523E+00, 4.8797001828E+00, 2.2263721284E+00, 8.9250900835E-01],
	[2.6800000000E+04, 1.8517950581E+01, 5.2572412381E+00, 4.8826463034E+00, 2.2270600952E+00, 8.9256112692E-01],
	[2.6805000000E+04, 1.8523520777E+01, 5.2572095299E+00, 4.8855936518E+00, 2.2277479642E+00, 8.9261322021E-01],
	[2.6810000000E+04, 1.8529091608E+01, 5.2571778278E+00, 4.8885422282E+00, 2.2284357354E+00, 8.9266528825E-01],
	[2.6815000000E+04, 1.8534663076E+01, 5.2571461319E+00, 4.8914920330E+00, 2.2291234087E+00, 8.9271733104E-01],
	[2.6820000000E+04, 1.8540235179E+01, 5.2571144420E+00, 4.8944430664E+00, 2.2298109839E+00, 8.9276934859E-01],
	[2.6825000000E+04, 1.8545807919E+01, 5.2570827583E+00, 4.8973953288E+00, 2.2304984611E+00, 8.9282134091E-01],
	[2.6830000000E+04, 1.8551381294E+01, 5.2570510806E+00, 4.9003488203E+00, 2.2311858401E+00, 8.9287330801E-01],
	[2.6835000000E+04, 1.8556955306E+01, 5.2570194090E+00, 4.9033035412E+00, 2.2318731208E+00, 8.9292524990E-01],
	[2.6840000000E+04, 1.8562529953E+01, 5.2569877436E+00, 4.9062594920E+00, 2.2325603033E+00, 8.9297716660E-01],
	[2.6845000000E+04, 1.8568105236E+01, 5.2569560842E+00, 4.9092166728E+00, 2.2332473873E+00, 8.9302905811E-01],
	[2.6850000000E+04, 1.8573681155E+01, 5.2569244309E+00, 4.9121750839E+00, 2.2339343729E+00, 8.9308092444E-01],
	[2.6855000000E+04, 1.8579257709E+01, 5.2568927837E+00, 4.9151347256E+00, 2.2346212600E+00, 8.9313276561E-01],
	[2.6860000000E+04, 1.8584834899E+01, 5.2568611425E+00, 4.9180955981E+00, 2.2353080485E+00, 8.9318458162E-01],
	[2.6865000000E+04, 1.8590412725E+01, 5.2568295075E+00, 4.9210577019E+00, 2.2359947383E+00, 8.9323637249E-01],
	[2.6870000000E+04, 1.8595991186E+01, 5.2567978785E+00, 4.9240210371E+00, 2.2366813293E+00, 8.9328813822E-01],
	[2.6875000000E+04, 1.8601570283E+01, 5.2567662556E+00, 4.9269856040E+00, 2.2373678215E+00, 8.9333987883E-01],
	[2.6880000000E+04, 1.8607150015E+01, 5.2567346388E+00, 4.9299514029E+00, 2.2380542148E+00, 8.9339159432E-01],
	[2.6885000000E+04, 1.8612730383E+01, 5.2567030280E+00, 4.9329184341E+00, 2.2387405091E+00, 8.9344328471E-01],
	[2.6890000000E+04, 1.8618311386E+01, 5.2566714233E+00, 4.9358866979E+00, 2.2394267044E+00, 8.9349495001E-01],
	[2.6895000000E+04, 1.8623893025E+01, 5.2566398247E+00, 4.9388561946E+00, 2.2401128005E+00, 8.9354659022E-01],
	[2.6900000000E+04, 1.8629475299E+01, 5.2566082321E+00, 4.9418269244E+00, 2.2407987974E+00, 8.9359820537E-01],
	[2.6905000000E+04, 1.8635058208E+01, 5.2565766456E+00, 4.9447988876E+00, 2.2414846951E+00, 8.9364979545E-01],
	[2.6910000000E+04, 1.8640641752E+01, 5.2565450652E+00, 4.9477720845E+00, 2.2421704934E+00, 8.9370136048E-01],
	[2.6915000000E+04, 1.8646225931E+01, 5.2565134908E+00, 4.9507465155E+00, 2.2428561922E+00, 8.9375290047E-01],
	[2.6920000000E+04, 1.8651810746E+01, 5.2564819225E+00, 4.9537221806E+00, 2.2435417916E+00, 8.9380441542E-01],
	[2.6925000000E+04, 1.8657396195E+01, 5.2564503602E+00, 4.9566990804E+00, 2.2442272914E+00, 8.9385590536E-01],
	[2.6930000000E+04, 1.8662982280E+01, 5.2564188040E+00, 4.9596772149E+00, 2.2449126916E+00, 8.9390737029E-01],
	[2.6935000000E+04, 1.8668568999E+01, 5.2563872538E+00, 4.9626565846E+00, 2.2455979921E+00, 8.9395881022E-01],
	[2.6940000000E+04, 1.8674156354E+01, 5.2563557097E+00, 4.9656371897E+00, 2.2462831927E+00, 8.9401022516E-01],
	[2.6945000000E+04, 1.8679744343E+01, 5.2563241716E+00, 4.9686190305E+00, 2.2469682935E+00, 8.9406161513E-01],
	[2.6950000000E+04, 1.8685332967E+01, 5.2562926396E+00, 4.9716021072E+00, 2.2476532944E+00, 8.9411298012E-01],
	[2.6955000000E+04, 1.8690922226E+01, 5.2562611135E+00, 4.9745864202E+00, 2.2483381952E+00, 8.9416432016E-01],
	[2.6960000000E+04, 1.8696512120E+01, 5.2562295936E+00, 4.9775719697E+00, 2.2490229960E+00, 8.9421563525E-01],
	[2.6965000000E+04, 1.8702102648E+01, 5.2561980796E+00, 4.9805587560E+00, 2.2497076966E+00, 8.9426692541E-01],
	[2.6970000000E+04, 1.8707693811E+01, 5.2561665717E+00, 4.9835467794E+00, 2.2503922970E+00, 8.9431819064E-01],
	[2.6975000000E+04, 1.8713285609E+01, 5.2561350698E+00, 4.9865360401E+00, 2.2510767971E+00, 8.9436943096E-01],
	[2.6980000000E+04, 1.8718878041E+01, 5.2561035740E+00, 4.9895265386E+00, 2.2517611969E+00, 8.9442064637E-01],
	[2.6985000000E+04, 1.8724471108E+01, 5.2560720842E+00, 4.9925182749E+00, 2.2524454961E+00, 8.9447183688E-01],
	[2.6990000000E+04, 1.8730064809E+01, 5.2560406004E+00, 4.9955112495E+00, 2.2531296949E+00, 8.9452300252E-01],
	[2.6995000000E+04, 1.8735659145E+01, 5.2560091226E+00, 4.9985054626E+00, 2.2538137931E+00, 8.9457414328E-01],
	[2.7000000000E+04, 1.8741254115E+01, 5.2559776508E+00, 5.0015009145E+00, 2.2544977906E+00, 8.9462525918E-01],
	[2.7005000000E+04, 1.8746849719E+01, 5.2559461851E+00, 5.0044976055E+00, 2.2551816874E+00, 8.9467635022E-01],
	[2.7010000000E+04, 1.8752445958E+01, 5.2559147253E+00, 5.0074955358E+00, 2.2558654833E+00, 8.9472741642E-01],
	[2.7015000000E+04, 1.8758042831E+01, 5.2558832716E+00, 5.0104947057E+00, 2.2565491784E+00, 8.9477845780E-01],
	[2.7020000000E+04, 1.8763640338E+01, 5.2558518239E+00, 5.0134951155E+00, 2.2572327726E+00, 8.9482947435E-01],
	[2.7025000000E+04, 1.8769238479E+01, 5.2558203822E+00, 5.0164967656E+00, 2.2579162657E+00, 8.9488046609E-01],
	[2.7030000000E+04, 1.8774837255E+01, 5.2557889465E+00, 5.0194996561E+00, 2.2585996577E+00, 8.9493143304E-01],
	[2.7035000000E+04, 1.8780436664E+01, 5.2557575168E+00, 5.0225037874E+00, 2.2592829486E+00, 8.9498237519E-01],
	[2.7040000000E+04, 1.8786036708E+01, 5.2557260931E+00, 5.0255091598E+00, 2.2599661383E+00, 8.9503329257E-01],
	[2.7045000000E+04, 1.8791637385E+01, 5.2556946754E+00, 5.0285157734E+00, 2.2606492266E+00, 8.9508418517E-01],
	[2.7050000000E+04, 1.8797238696E+01, 5.2556632637E+00, 5.0315236287E+00, 2.2613322135E+00, 8.9513505303E-01],
	[2.7055000000E+04, 1.8802840642E+01, 5.2556318580E+00, 5.0345327259E+00, 2.2620150990E+00, 8.9518589613E-01],
	[2.7060000000E+04, 1.8808443221E+01, 5.2556004583E+00, 5.0375430652E+00, 2.2626978830E+00, 8.9523671450E-01],
	[2.7065000000E+04, 1.8814046433E+01, 5.2555690645E+00, 5.0405546471E+00, 2.2633805654E+00, 8.9528750814E-01],
	[2.7070000000E+04, 1.8819650280E+01, 5.2555376768E+00, 5.0435674716E+00, 2.2640631462E+00, 8.9533827707E-01],
	[2.7075000000E+04, 1.8825254760E+01, 5.2555062950E+00, 5.0465815392E+00, 2.2647456252E+00, 8.9538902129E-01],
	[2.7080000000E+04, 1.8830859874E+01, 5.2554749193E+00, 5.0495968501E+00, 2.2654280024E+00, 8.9543974082E-01],
	[2.7085000000E+04, 1.8836465622E+01, 5.2554435495E+00, 5.0526134046E+00, 2.2661102777E+00, 8.9549043566E-01],
	[2.7090000000E+04, 1.8842072003E+01, 5.2554121856E+00, 5.0556312029E+00, 2.2667924511E+00, 8.9554110583E-01],
	[2.7095000000E+04, 1.8847679017E+01, 5.2553808278E+00, 5.0586502454E+00, 2.2674745224E+00, 8.9559175134E-01],
	[2.7100000000E+04, 1.8853286666E+01, 5.2553494759E+00, 5.0616705323E+00, 2.2681564917E+00, 8.9564237220E-01],
	[2.7105000000E+04, 1.8858894947E+01, 5.2553181300E+00, 5.0646920640E+00, 2.2688383588E+00, 8.9569296842E-01],
	[2.7110000000E+04, 1.8864503862E+01, 5.2552867901E+00, 5.0677148407E+00, 2.2695201237E+00, 8.9574354000E-01],
	[2.7115000000E+04, 1.8870113410E+01, 5.2552554561E+00, 5.0707388626E+00, 2.2702017863E+00, 8.9579408697E-01],
	[2.7120000000E+04, 1.8875723592E+01, 5.2552241281E+00, 5.0737641301E+00, 2.2708833465E+00, 8.9584460933E-01],
	[2.7125000000E+04, 1.8881334406E+01, 5.2551928061E+00, 5.0767906435E+00, 2.2715648043E+00, 8.9589510709E-01],
	[2.7130000000E+04, 1.8886945854E+01, 5.2551614900E+00, 5.0798184030E+00, 2.2722461596E+00, 8.9594558026E-01],
	[2.7135000000E+04, 1.8892557936E+01, 5.2551301799E+00, 5.0828474089E+00, 2.2729274123E+00, 8.9599602885E-01],
	[2.7140000000E+04, 1.8898170650E+01, 5.2550988757E+00, 5.0858776615E+00, 2.2736085624E+00, 8.9604645287E-01],
	[2.7145000000E+04, 1.8903783997E+01, 5.2550675775E+00, 5.0889091611E+00, 2.2742896098E+00, 8.9609685234E-01],
	[2.7150000000E+04, 1.8909397977E+01, 5.2550362852E+00, 5.0919419080E+00, 2.2749705543E+00, 8.9614722725E-01],
	[2.7155000000E+04, 1.8915012591E+01, 5.2550049989E+00, 5.0949759024E+00, 2.2756513961E+00, 8.9619757763E-01],
	[2.7160000000E+04, 1.8920627837E+01, 5.2549737185E+00, 5.0980111446E+00, 2.2763321349E+00, 8.9624790348E-01],
	[2.7165000000E+04, 1.8926243716E+01, 5.2549424441E+00, 5.1010476350E+00, 2.2770127706E+00, 8.9629820481E-01],
	[2.7170000000E+04, 1.8931860228E+01, 5.2549111756E+00, 5.1040853738E+00, 2.2776933034E+00, 8.9634848163E-01],
	[2.7175000000E+04, 1.8937477869E+01, 5.2548799891E+00, 5.1071243612E+00, 2.2783737545E+00, 8.9639873394E-01],
	[2.7180000000E+04, 1.8943118617E+01, 5.2548522460E+00, 5.1101645976E+00, 2.2790550743E+00, 8.9644896177E-01],
	[2.7185000000E+04, 1.8948760007E+01, 5.2548245081E+00, 5.1132060832E+00, 2.2797362916E+00, 8.9649916511E-01],
	[2.7190000000E+04, 1.8954402040E+01, 5.2547967755E+00, 5.1162488184E+00, 2.2804174064E+00, 8.9654934398E-01],
	[2.7195000000E+04, 1.8960044714E+01, 5.2547690482E+00, 5.1192928033E+00, 2.2810984186E+00, 8.9659949839E-01],
	[2.7200000000E+04, 1.8965688030E+01, 5.2547413261E+00, 5.1223380384E+00, 2.2817793282E+00, 8.9664962834E-01],
	[2.7205000000E+04, 1.8971331988E+01, 5.2547136092E+00, 5.1253845239E+00, 2.2824601350E+00, 8.9669973385E-01],
	[2.7210000000E+04, 1.8976976588E+01, 5.2546858976E+00, 5.1284322600E+00, 2.2831408391E+00, 8.9674981493E-01],
	[2.7215000000E+04, 1.8982621830E+01, 5.2546581912E+00, 5.1314812470E+00, 2.2838214402E+00, 8.9679987158E-01],
	[2.7220000000E+04, 1.8988267714E+01, 5.2546304900E+00, 5.1345314853E+00, 2.2845019384E+00, 8.9684990381E-01],
	[2.7225000000E+04, 1.8993914239E+01, 5.2546027941E+00, 5.1375829751E+00, 2.2851823337E+00, 8.9689991165E-01],
	[2.7230000000E+04, 1.8999561407E+01, 5.2545751034E+00, 5.1406357166E+00, 2.2858626258E+00, 8.9694989508E-01],
	[2.7235000000E+04, 1.9005209215E+01, 5.2545474179E+00, 5.1436897103E+00, 2.2865428148E+00, 8.9699985413E-01],
	[2.7240000000E+04, 1.9010857666E+01, 5.2545197377E+00, 5.1467449563E+00, 2.2872229006E+00, 8.9704978881E-01],
	[2.7245000000E+04, 1.9016506758E+01, 5.2544920627E+00, 5.1498014549E+00, 2.2879028831E+00, 8.9709969911E-01],
	[2.7250000000E+04, 1.9022156492E+01, 5.2544643929E+00, 5.1528592065E+00, 2.2885827623E+00, 8.9714958506E-01],
	[2.7255000000E+04, 1.9027806867E+01, 5.2544367283E+00, 5.1559182112E+00, 2.2892625381E+00, 8.9719944666E-01],
	[2.7260000000E+04, 1.9033457884E+01, 5.2544090690E+00, 5.1589784695E+00, 2.2899422104E+00, 8.9724928393E-01],
	[2.7265000000E+04, 1.9039109542E+01, 5.2543814149E+00, 5.1620399815E+00, 2.2906217791E+00, 8.9729909686E-01],
	[2.7270000000E+04, 1.9044761841E+01, 5.2543537659E+00, 5.1651027476E+00, 2.2913012442E+00, 8.9734888548E-01],
	[2.7275000000E+04, 1.9050414782E+01, 5.2543261223E+00, 5.1681667680E+00, 2.2919806056E+00, 8.9739864979E-01],
	[2.7280000000E+04, 1.9056068364E+01, 5.2542984838E+00, 5.1712320431E+00, 2.2926598633E+00, 8.9744838980E-01],
	[2.7285000000E+04, 1.9061722587E+01, 5.2542708505E+00, 5.1742985730E+00, 2.2933390172E+00, 8.9749810552E-01],
	[2.7290000000E+04, 1.9067377451E+01, 5.2542432224E+00, 5.1773663582E+00, 2.2940180671E+00, 8.9754779696E-01],
	[2.7295000000E+04, 1.9073032957E+01, 5.2542155996E+00, 5.1804353988E+00, 2.2946970132E+00, 8.9759746413E-01],
	[2.7300000000E+04, 1.9078689104E+01, 5.2541879819E+00, 5.1835056951E+00, 2.2953758552E+00, 8.9764710704E-01],
	[2.7305000000E+04, 1.9084345891E+01, 5.2541603695E+00, 5.1865772475E+00, 2.2960545931E+00, 8.9769672570E-01],
	[2.7310000000E+04, 1.9090003320E+01, 5.2541327622E+00, 5.1896500562E+00, 2.2967332268E+00, 8.9774632012E-01],
	[2.7315000000E+04, 1.9095661390E+01, 5.2541051602E+00, 5.1927241216E+00, 2.2974117564E+00, 8.9779589030E-01],
	[2.7320000000E+04, 1.9101320100E+01, 5.2540775633E+00, 5.1957994438E+00, 2.2980901816E+00, 8.9784543627E-01],
	[2.7325000000E+04, 1.9106979452E+01, 5.2540499717E+00, 5.1988760231E+00, 2.2987685025E+00, 8.9789495802E-01],
	[2.7330000000E+04, 1.9112639444E+01, 5.2540223852E+00, 5.2019538600E+00, 2.2994467190E+00, 8.9794445557E-01],
	[2.7335000000E+04, 1.9118300077E+01, 5.2539948039E+00, 5.2050329545E+00, 2.3001248310E+00, 8.9799392893E-01],
	[2.7340000000E+04, 1.9123961351E+01, 5.2539672279E+00, 5.2081133071E+00, 2.3008028384E+00, 8.9804337810E-01],
	[2.7345000000E+04, 1.9129623265E+01, 5.2539396570E+00, 5.2111949180E+00, 2.3014807412E+00, 8.9809280310E-01],
	[2.7350000000E+04, 1.9135285821E+01, 5.2539120913E+00, 5.2142777875E+00, 2.3021585394E+00, 8.9814220394E-01],
	[2.7355000000E+04, 1.9140949016E+01, 5.2538845307E+00, 5.2173619158E+00, 2.3028362327E+00, 8.9819158063E-01],
	[2.7360000000E+04, 1.9146612853E+01, 5.2538569754E+00, 5.2204473033E+00, 2.3035138213E+00, 8.9824093317E-01],
	[2.7365000000E+04, 1.9152277329E+01, 5.2538294252E+00, 5.2235339503E+00, 2.3041913049E+00, 8.9829026157E-01],
	[2.7370000000E+04, 1.9157942447E+01, 5.2538018802E+00, 5.2266218569E+00, 2.3048686837E+00, 8.9833956586E-01],
	[2.7375000000E+04, 1.9163608205E+01, 5.2537743404E+00, 5.2297110236E+00, 2.3055459574E+00, 8.9838884603E-01],
	[2.7380000000E+04, 1.9169274603E+01, 5.2537468058E+00, 5.2328014505E+00, 2.3062231260E+00, 8.9843810209E-01],
	[2.7385000000E+04, 1.9174941641E+01, 5.2537192763E+00, 5.2358931380E+00, 2.3069001894E+00, 8.9848733406E-01],
	[2.7390000000E+04, 1.9180609320E+01, 5.2536917520E+00, 5.2389868195E+00, 2.3075772899E+00, 8.9853654194E-01],
	[2.7395000000E+04, 1.9186277639E+01, 5.2536642329E+00, 5.2420819698E+00, 2.3082543252E+00, 8.9858572575E-01],
	[2.7400000000E+04, 1.9191946598E+01, 5.2536367190E+00, 5.2451783825E+00, 2.3089312552E+00, 8.9863488549E-01],
	[2.7405000000E+04, 1.9197616197E+01, 5.2536092102E+00, 5.2482760580E+00, 2.3096080797E+00, 8.9868402117E-01],
	[2.7410000000E+04, 1.9203286437E+01, 5.2535817065E+00, 5.2513749963E+00, 2.3102847987E+00, 8.9873313281E-01],
	[2.7415000000E+04, 1.9208957316E+01, 5.2535542080E+00, 5.2544751980E+00, 2.3109614121E+00, 8.9878222041E-01],
	[2.7420000000E+04, 1.9214628836E+01, 5.2535267147E+00, 5.2575766632E+00, 2.3116379199E+00, 8.9883128399E-01],
	[2.7425000000E+04, 1.9220300995E+01, 5.2534992266E+00, 5.2606793922E+00, 2.3123143220E+00, 8.9888032355E-01],
	[2.7430000000E+04, 1.9225973795E+01, 5.2534717436E+00, 5.2637833854E+00, 2.3129906184E+00, 8.9892933910E-01],
	[2.7435000000E+04, 1.9231647234E+01, 5.2534442657E+00, 5.2668886429E+00, 2.3136668089E+00, 8.9897833065E-01],
	[2.7440000000E+04, 1.9237321314E+01, 5.2534167930E+00, 5.2699951651E+00, 2.3143428935E+00, 8.9902729822E-01],
	[2.7445000000E+04, 1.9242996033E+01, 5.2533893255E+00, 5.2731029523E+00, 2.3150188722E+00, 8.9907624181E-01],
	[2.7450000000E+04, 1.9248671391E+01, 5.2533618631E+00, 5.2762120047E+00, 2.3156947449E+00, 8.9912516143E-01],
	[2.7455000000E+04, 1.9254347390E+01, 5.2533344058E+00, 5.2793223227E+00, 2.3163705114E+00, 8.9917405710E-01],
	[2.7460000000E+04, 1.9260024028E+01, 5.2533069537E+00, 5.2824339065E+00, 2.3170461719E+00, 8.9922292881E-01],
	[2.7465000000E+04, 1.9265701306E+01, 5.2532795067E+00, 5.2855467564E+00, 2.3177217261E+00, 8.9927177659E-01],
	[2.7470000000E+04, 1.9271379223E+01, 5.2532520649E+00, 5.2886608727E+00, 2.3183971740E+00, 8.9932060044E-01],
	[2.7475000000E+04, 1.9277057780E+01, 5.2532246282E+00, 5.2917762556E+00, 2.3190725156E+00, 8.9936940037E-01],
	[2.7480000000E+04, 1.9282736976E+01, 5.2531971967E+00, 5.2948929055E+00, 2.3197477508E+00, 8.9941817639E-01],
	[2.7485000000E+04, 1.9288416812E+01, 5.2531697702E+00, 5.2980108226E+00, 2.3204228795E+00, 8.9946692852E-01],
	[2.7490000000E+04, 1.9294097288E+01, 5.2531423489E+00, 5.3011300073E+00, 2.3210979017E+00, 8.9951565675E-01],
	[2.7495000000E+04, 1.9299778402E+01, 5.2531149328E+00, 5.3042504597E+00, 2.3217728173E+00, 8.9956436111E-01],
	[2.7500000000E+04, 1.9305460156E+01, 5.2530875217E+00, 5.3073721803E+00, 2.3224476262E+00, 8.9961304159E-01],
	[2.7505000000E+04, 1.9311142549E+01, 5.2530601158E+00, 5.3104951692E+00, 2.3231223284E+00, 8.9966169822E-01],
	[2.7510000000E+04, 1.9316825582E+01, 5.2530327150E+00, 5.3136194268E+00, 2.3237969238E+00, 8.9971033099E-01],
	[2.7515000000E+04, 1.9322509253E+01, 5.2530053194E+00, 5.3167449533E+00, 2.3244714123E+00, 8.9975893993E-01],
	[2.7520000000E+04, 1.9328193564E+01, 5.2529779288E+00, 5.3198717491E+00, 2.3251457940E+00, 8.9980752504E-01],
	[2.7525000000E+04, 1.9333878514E+01, 5.2529505434E+00, 5.3229998143E+00, 2.3258200686E+00, 8.9985608633E-01],
	[2.7530000000E+04, 1.9339564103E+01, 5.2529231631E+00, 5.3261291494E+00, 2.3264942362E+00, 8.9990462380E-01],
	[2.7535000000E+04, 1.9345250331E+01, 5.2528957879E+00, 5.3292597545E+00, 2.3271682967E+00, 8.9995313748E-01],
	[2.7540000000E+04, 1.9350937197E+01, 5.2528684179E+00, 5.3323916300E+00, 2.3278422501E+00, 9.0000162737E-01],
	[2.7545000000E+04, 1.9356624703E+01, 5.2528410529E+00, 5.3355247761E+00, 2.3285160962E+00, 9.0005009347E-01],
	[2.7550000000E+04, 1.9362312848E+01, 5.2528136930E+00, 5.3386591932E+00, 2.3291898350E+00, 9.0009853581E-01],
	[2.7555000000E+04, 1.9368001631E+01, 5.2527863383E+00, 5.3417948815E+00, 2.3298634664E+00, 9.0014695438E-01],
	[2.7560000000E+04, 1.9373691054E+01, 5.2527589886E+00, 5.3449318413E+00, 2.3305369905E+00, 9.0019534921E-01],
	[2.7565000000E+04, 1.9379381115E+01, 5.2527316441E+00, 5.3480700729E+00, 2.3312104070E+00, 9.0024372029E-01],
	[2.7570000000E+04, 1.9385071814E+01, 5.2527043047E+00, 5.3512095765E+00, 2.3318837160E+00, 9.0029206764E-01],
	[2.7575000000E+04, 1.9390763153E+01, 5.2526769703E+00, 5.3543503525E+00, 2.3325569174E+00, 9.0034039128E-01],
	[2.7580000000E+04, 1.9396455129E+01, 5.2526496411E+00, 5.3574924011E+00, 2.3332300111E+00, 9.0038869120E-01],
	[2.7585000000E+04, 1.9402147745E+01, 5.2526223170E+00, 5.3606357227E+00, 2.3339029971E+00, 9.0043696742E-01],
	[2.7590000000E+04, 1.9407840999E+01, 5.2525949979E+00, 5.3637803175E+00, 2.3345758753E+00, 9.0048521994E-01],
	[2.7595000000E+04, 1.9413534891E+01, 5.2525676840E+00, 5.3669261857E+00, 2.3352486456E+00, 9.0053344879E-01],
	[2.7600000000E+04, 1.9419229422E+01, 5.2525403751E+00, 5.3700733277E+00, 2.3359213080E+00, 9.0058165397E-01],
	[2.7605000000E+04, 1.9424924592E+01, 5.2525130713E+00, 5.3732217438E+00, 2.3365938624E+00, 9.0062983548E-01],
	[2.7610000000E+04, 1.9430620399E+01, 5.2524857726E+00, 5.3763714342E+00, 2.3372663088E+00, 9.0067799335E-01],
	[2.7615000000E+04, 1.9436328860E+01, 5.2524602941E+00, 5.3795223993E+00, 2.3379391805E+00, 9.0072612757E-01],
	[2.7620000000E+04, 1.9442048798E+01, 5.2524364566E+00, 5.3826746393E+00, 2.3386124257E+00, 9.0077423816E-01],
	[2.7625000000E+04, 1.9447769384E+01, 5.2524126235E+00, 5.3858281544E+00, 2.3392855633E+00, 9.0082232513E-01],
	[2.7630000000E+04, 1.9453490617E+01, 5.2523887949E+00, 5.3889829451E+00, 2.3399585935E+00, 9.0087038848E-01],
	[2.7635000000E+04, 1.9459212497E+01, 5.2523649706E+00, 5.3921390115E+00, 2.3406315162E+00, 9.0091842824E-01],
	[2.7640000000E+04, 1.9464935025E+01, 5.2523411508E+00, 5.3952963539E+00, 2.3413043312E+00, 9.0096644440E-01],
	[2.7645000000E+04, 1.9470658200E+01, 5.2523173354E+00, 5.3984549727E+00, 2.3419770385E+00, 9.0101443698E-01],
	[2.7650000000E+04, 1.9476382022E+01, 5.2522935244E+00, 5.4016148681E+00, 2.3426496381E+00, 9.0106240599E-01],
	[2.7655000000E+04, 1.9482106492E+01, 5.2522697178E+00, 5.4047760404E+00, 2.3433221299E+00, 9.0111035144E-01],
	[2.7660000000E+04, 1.9487831609E+01, 5.2522459157E+00, 5.4079384899E+00, 2.3439945138E+00, 9.0115827334E-01],
	[2.7665000000E+04, 1.9493557373E+01, 5.2522221179E+00, 5.4111022169E+00, 2.3446667898E+00, 9.0120617170E-01],
	[2.7670000000E+04, 1.9499283784E+01, 5.2521983246E+00, 5.4142672216E+00, 2.3453389578E+00, 9.0125404652E-01],
	[2.7675000000E+04, 1.9505010842E+01, 5.2521745356E+00, 5.4174335044E+00, 2.3460110177E+00, 9.0130189782E-01],
	[2.7680000000E+04, 1.9510738547E+01, 5.2521507511E+00, 5.4206010655E+00, 2.3466829696E+00, 9.0134972561E-01],
	[2.7685000000E+04, 1.9516466899E+01, 5.2521269710E+00, 5.4237699052E+00, 2.3473548133E+00, 9.0139752990E-01],
	[2.7690000000E+04, 1.9522195898E+01, 5.2521031952E+00, 5.4269400238E+00, 2.3480265487E+00, 9.0144531069E-01],
	[2.7695000000E+04, 1.9527925544E+01, 5.2520794239E+00, 5.4301114216E+00, 2.3486981759E+00, 9.0149306801E-01],
	[2.7700000000E+04, 1.9533655836E+01, 5.2520556570E+00, 5.4332840988E+00, 2.3493696947E+00, 9.0154080185E-01],
	[2.7705000000E+04, 1.9539386776E+01, 5.2520318945E+00, 5.4364580558E+00, 2.3500411051E+00, 9.0158851223E-01],
	[2.7710000000E+04, 1.9545118362E+01, 5.2520081363E+00, 5.4396332929E+00, 2.3507124070E+00, 9.0163619916E-01],
	[2.7715000000E+04, 1.9550850595E+01, 5.2519843826E+00, 5.4428098102E+00, 2.3513836004E+00, 9.0168386264E-01],
	[2.7720000000E+04, 1.9556583475E+01, 5.2519606332E+00, 5.4459876081E+00, 2.3520546851E+00, 9.0173150270E-01],
	[2.7725000000E+04, 1.9562317001E+01, 5.2519368883E+00, 5.4491666870E+00, 2.3527256613E+00, 9.0177911933E-01],
	[2.7730000000E+04, 1.9568051174E+01, 5.2519131477E+00, 5.4523470470E+00, 2.3533965287E+00, 9.0182671255E-01],
	[2.7735000000E+04, 1.9573785993E+01, 5.2518894115E+00, 5.4555286884E+00, 2.3540672873E+00, 9.0187428237E-01],
	[2.7740000000E+04, 1.9579521459E+01, 5.2518656797E+00, 5.4587116116E+00, 2.3547379371E+00, 9.0192182880E-01],
	[2.7745000000E+04, 1.9585257571E+01, 5.2518419523E+00, 5.4618958168E+00, 2.3554084781E+00, 9.0196935185E-01],
	[2.7750000000E+04, 1.9590994330E+01, 5.2518182293E+00, 5.4650813044E+00, 2.3560789100E+00, 9.0201685152E-01],
	[2.7755000000E+04, 1.9596731735E+01, 5.2517945106E+00, 5.4682680745E+00, 2.3567492330E+00, 9.0206432783E-01],
	[2.7760000000E+04, 1.9602469786E+01, 5.2517707964E+00, 5.4714561275E+00, 2.3574194468E+00, 9.0211178080E-01],
	[2.7765000000E+04, 1.9608208484E+01, 5.2517470865E+00, 5.4746454637E+00, 2.3580895516E+00, 9.0215921042E-01],
	[2.7770000000E+04, 1.9613947828E+01, 5.2517233810E+00, 5.4778360833E+00, 2.3587595471E+00, 9.0220661670E-01],
	[2.7775000000E+04, 1.9619687818E+01, 5.2516996798E+00, 5.4810279867E+00, 2.3594294334E+00, 9.0225399967E-01],
	[2.7780000000E+04, 1.9625428454E+01, 5.2516759831E+00, 5.4842211740E+00, 2.3600992104E+00, 9.0230135933E-01],
	[2.7785000000E+04, 1.9631169736E+01, 5.2516522907E+00, 5.4874156457E+00, 2.3607688780E+00, 9.0234869568E-01],
	[2.7790000000E+04, 1.9636911664E+01, 5.2516286026E+00, 5.4906114020E+00, 2.3614384362E+00, 9.0239600874E-01],
	[2.7795000000E+04, 1.9642654238E+01, 5.2516049190E+00, 5.4938084431E+00, 2.3621078849E+00, 9.0244329853E-01],
	[2.7800000000E+04, 1.9648397459E+01, 5.2515812397E+00, 5.4970067694E+00, 2.3627772240E+00, 9.0249056504E-01],
	[2.7805000000E+04, 1.9654141325E+01, 5.2515575648E+00, 5.5002063812E+00, 2.3634464535E+00, 9.0253780829E-01],
	[2.7810000000E+04, 1.9659885837E+01, 5.2515338942E+00, 5.5034072786E+00, 2.3641155734E+00, 9.0258502828E-01],
	[2.7815000000E+04, 1.9665630995E+01, 5.2515102280E+00, 5.5066094621E+00, 2.3647845836E+00, 9.0263222504E-01],
	[2.7820000000E+04, 1.9671376798E+01, 5.2514865662E+00, 5.5098129319E+00, 2.3654534839E+00, 9.0267939857E-01],
	[2.7825000000E+04, 1.9677123248E+01, 5.2514629087E+00, 5.5130176882E+00, 2.3661222744E+00, 9.0272654887E-01],
	[2.7830000000E+04, 1.9682870343E+01, 5.2514392556E+00, 5.5162237314E+00, 2.3667909550E+00, 9.0277367597E-01],
	[2.7835000000E+04, 1.9688618084E+01, 5.2514156068E+00, 5.5194310618E+00, 2.3674595257E+00, 9.0282077986E-01],
	[2.7840000000E+04, 1.9694366470E+01, 5.2513919624E+00, 5.5226396796E+00, 2.3681279863E+00, 9.0286786057E-01],
	[2.7845000000E+04, 1.9700115502E+01, 5.2513683223E+00, 5.5258495852E+00, 2.3687963369E+00, 9.0291491809E-01],
	[2.7850000000E+04, 1.9705865179E+01, 5.2513446866E+00, 5.5290607787E+00, 2.3694645773E+00, 9.0296195244E-01],
	[2.7855000000E+04, 1.9711615502E+01, 5.2513210553E+00, 5.5322732605E+00, 2.3701327076E+00, 9.0300896363E-01],
	[2.7860000000E+04, 1.9717366471E+01, 5.2512974283E+00, 5.5354870309E+00, 2.3708007275E+00, 9.0305595168E-01],
	[2.7865000000E+04, 1.9723118085E+01, 5.2512738056E+00, 5.5387020902E+00, 2.3714686372E+00, 9.0310291658E-01],
	[2.7870000000E+04, 1.9728870344E+01, 5.2512501873E+00, 5.5419184386E+00, 2.3721364365E+00, 9.0314985835E-01],
	[2.7875000000E+04, 1.9734623248E+01, 5.2512265733E+00, 5.5451360765E+00, 2.3728041254E+00, 9.0319677700E-01],
	[2.7880000000E+04, 1.9740376798E+01, 5.2512029637E+00, 5.5483550040E+00, 2.3734717038E+00, 9.0324367255E-01],
	[2.7885000000E+04, 1.9746130993E+01, 5.2511793584E+00, 5.5515752216E+00, 2.3741391717E+00, 9.0329054499E-01],
	[2.7890000000E+04, 1.9751885833E+01, 5.2511557574E+00, 5.5547967295E+00, 2.3748065290E+00, 9.0333739434E-01],
	[2.7895000000E+04, 1.9757641318E+01, 5.2511321608E+00, 5.5580195279E+00, 2.3754737756E+00, 9.0338422062E-01],
	[2.7900000000E+04, 1.9763397449E+01, 5.2511085685E+00, 5.5612436172E+00, 2.3761409115E+00, 9.0343102382E-01],
	[2.7905000000E+04, 1.9769154224E+01, 5.2510849806E+00, 5.5644689976E+00, 2.3768079366E+00, 9.0347780397E-01],
	[2.7910000000E+04, 1.9774911644E+01, 5.2510613969E+00, 5.5676956694E+00, 2.3774748509E+00, 9.0352456106E-01],
	[2.7915000000E+04, 1.9780669710E+01, 5.2510378176E+00, 5.5709236330E+00, 2.3781416543E+00, 9.0357129512E-01],
	[2.7920000000E+04, 1.9786428420E+01, 5.2510142427E+00, 5.5741528885E+00, 2.3788083468E+00, 9.0361800615E-01],
	[2.7925000000E+04, 1.9792187775E+01, 5.2509906721E+00, 5.5773834364E+00, 2.3794749283E+00, 9.0366469416E-01],
	[2.7930000000E+04, 1.9797947775E+01, 5.2509671057E+00, 5.5806152768E+00, 2.3801413987E+00, 9.0371135916E-01],
	[2.7935000000E+04, 1.9803708420E+01, 5.2509435438E+00, 5.5838484100E+00, 2.3808077581E+00, 9.0375800116E-01],
	[2.7940000000E+04, 1.9809469710E+01, 5.2509199861E+00, 5.5870828364E+00, 2.3814740062E+00, 9.0380462017E-01],
	[2.7945000000E+04, 1.9815231644E+01, 5.2508964328E+00, 5.5903185562E+00, 2.3821401431E+00, 9.0385121621E-01],
	[2.7950000000E+04, 1.9820994223E+01, 5.2508728837E+00, 5.5935555698E+00, 2.3828061688E+00, 9.0389778927E-01],
	[2.7955000000E+04, 1.9826757446E+01, 5.2508493390E+00, 5.5967938773E+00, 2.3834720831E+00, 9.0394433938E-01],
	[2.7960000000E+04, 1.9832521314E+01, 5.2508257987E+00, 5.6000334791E+00, 2.3841378860E+00, 9.0399086654E-01],
	[2.7965000000E+04, 1.9838285827E+01, 5.2508022626E+00, 5.6032743754E+00, 2.3848035775E+00, 9.0403737077E-01],
	[2.7970000000E+04, 1.9844050984E+01, 5.2507787308E+00, 5.6065165666E+00, 2.3854691574E+00, 9.0408385206E-01],
	[2.7975000000E+04, 1.9849816786E+01, 5.2507552034E+00, 5.6097600530E+00, 2.3861346258E+00, 9.0413031044E-01],
	[2.7980000000E+04, 1.9855583232E+01, 5.2507316802E+00, 5.6130048347E+00, 2.3867999826E+00, 9.0417674591E-01],
	[2.7985000000E+04, 1.9861350322E+01, 5.2507081614E+00, 5.6162509122E+00, 2.3874652277E+00, 9.0422315849E-01],
	[2.7990000000E+04, 1.9867118057E+01, 5.2506846469E+00, 5.6194982856E+00, 2.3881303611E+00, 9.0426954818E-01],
	[2.7995000000E+04, 1.9872886436E+01, 5.2506611367E+00, 5.6227469553E+00, 2.3887953827E+00, 9.0431591499E-01],
	[2.8000000000E+04, 1.9878655459E+01, 5.2506376308E+00, 5.6259969216E+00, 2.3894602924E+00, 9.0436225893E-01],
	[2.8005000000E+04, 1.9884425126E+01, 5.2506141292E+00, 5.6292481848E+00, 2.3901250902E+00, 9.0440858002E-01],
	[2.8010000000E+04, 1.9890195438E+01, 5.2505906319E+00, 5.6325007450E+00, 2.3907897761E+00, 9.0445487826E-01],
	[2.8015000000E+04, 1.9895966393E+01, 5.2505671388E+00, 5.6357546027E+00, 2.3914543500E+00, 9.0450115366E-01],
	[2.8020000000E+04, 1.9901737993E+01, 5.2505436501E+00, 5.6390097581E+00, 2.3921188118E+00, 9.0454740624E-01],
	[2.8025000000E+04, 1.9907510236E+01, 5.2505201657E+00, 5.6422662114E+00, 2.3927831615E+00, 9.0459363600E-01],
	[2.8030000000E+04, 1.9913283124E+01, 5.2504966856E+00, 5.6455239631E+00, 2.3934473990E+00, 9.0463984296E-01],
	[2.8035000000E+04, 1.9919056656E+01, 5.2504732098E+00, 5.6487830132E+00, 2.3941115243E+00, 9.0468602712E-01],
	[2.8040000000E+04, 1.9924830831E+01, 5.2504497382E+00, 5.6520433623E+00, 2.3947755373E+00, 9.0473218850E-01],
	[2.8045000000E+04, 1.9930605650E+01, 5.2504262710E+00, 5.6553050104E+00, 2.3954394379E+00, 9.0477832710E-01],
	[2.8050000000E+04, 1.9936381113E+01, 5.2504028080E+00, 5.6585679580E+00, 2.3961032262E+00, 9.0482444294E-01],
	[2.8055000000E+04, 1.9942157220E+01, 5.2503793494E+00, 5.6618322053E+00, 2.3967669020E+00, 9.0487053602E-01],
	[2.8060000000E+04, 1.9947948095E+01, 5.2503580025E+00, 5.6650977525E+00, 2.3974311087E+00, 9.0491660635E-01],
	[2.8065000000E+04, 1.9953748220E+01, 5.2503379425E+00, 5.6683646001E+00, 2.3980955953E+00, 9.0496265396E-01],
	[2.8070000000E+04, 1.9959548998E+01, 5.2503178861E+00, 5.6716327481E+00, 2.3987599700E+00, 9.0500867883E-01],
	[2.8075000000E+04, 1.9965350429E+01, 5.2502978334E+00, 5.6749021971E+00, 2.3994242328E+00, 9.0505468100E-01],
	[2.8080000000E+04, 1.9971152513E+01, 5.2502777844E+00, 5.6781729471E+00, 2.4000883837E+00, 9.0510066046E-01],
	[2.8085000000E+04, 1.9976955249E+01, 5.2502577390E+00, 5.6814449986E+00, 2.4007524226E+00, 9.0514661722E-01],
	[2.8090000000E+04, 1.9982758637E+01, 5.2502376972E+00, 5.6847183517E+00, 2.4014163494E+00, 9.0519255131E-01],
	[2.8095000000E+04, 1.9988562678E+01, 5.2502176591E+00, 5.6879930068E+00, 2.4020801641E+00, 9.0523846271E-01],
	[2.8100000000E+04, 1.9994367372E+01, 5.2501976246E+00, 5.6912689642E+00, 2.4027438667E+00, 9.0528435146E-01],
	[2.8105000000E+04, 2.0000172718E+01, 5.2501775938E+00, 5.6945462242E+00, 2.4034074570E+00, 9.0533021755E-01],
	[2.8110000000E+04, 2.0005978717E+01, 5.2501575666E+00, 5.6978247870E+00, 2.4040709350E+00, 9.0537606100E-01],
	[2.8115000000E+04, 2.0011785368E+01, 5.2501375430E+00, 5.7011046529E+00, 2.4047343008E+00, 9.0542188182E-01],
	[2.8120000000E+04, 2.0017592671E+01, 5.2501175231E+00, 5.7043858222E+00, 2.4053975541E+00, 9.0546768002E-01],
	[2.8125000000E+04, 2.0023400627E+01, 5.2500975068E+00, 5.7076682953E+00, 2.4060606950E+00, 9.0551345560E-01],
	[2.8130000000E+04, 2.0029209235E+01, 5.2500774942E+00, 5.7109520723E+00, 2.4067237234E+00, 9.0555920858E-01],
	[2.8135000000E+04, 2.0035018495E+01, 5.2500574852E+00, 5.7142371535E+00, 2.4073866393E+00, 9.0560493897E-01],
	[2.8140000000E+04, 2.0040828407E+01, 5.2500374798E+00, 5.7175235394E+00, 2.4080494426E+00, 9.0565064678E-01],
	[2.8145000000E+04, 2.0046638972E+01, 5.2500174781E+00, 5.7208112300E+00, 2.4087121332E+00, 9.0569633201E-01],
	[2.8150000000E+04, 2.0052450188E+01, 5.2499974799E+00, 5.7241002258E+00, 2.4093747111E+00, 9.0574199469E-01],
	[2.8155000000E+04, 2.0058262057E+01, 5.2499774854E+00, 5.7273905270E+00, 2.4100371763E+00, 9.0578763481E-01],
	[2.8160000000E+04, 2.0064074577E+01, 5.2499574946E+00, 5.7306821339E+00, 2.4106995286E+00, 9.0583325240E-01],
	[2.8165000000E+04, 2.0069887749E+01, 5.2499375073E+00, 5.7339750468E+00, 2.4113617681E+00, 9.0587884745E-01],
	[2.8170000000E+04, 2.0075701574E+01, 5.2499175237E+00, 5.7372692659E+00, 2.4120238947E+00, 9.0592441998E-01],
	[2.8175000000E+04, 2.0081516050E+01, 5.2498975437E+00, 5.7405647916E+00, 2.4126859083E+00, 9.0596997000E-01],
	[2.8180000000E+04, 2.0087331178E+01, 5.2498775673E+00, 5.7438616241E+00, 2.4133478088E+00, 9.0601549751E-01],
	[2.8185000000E+04, 2.0093146958E+01, 5.2498575946E+00, 5.7471597638E+00, 2.4140095963E+00, 9.0606100253E-01],
	[2.8190000000E+04, 2.0098963390E+01, 5.2498376254E+00, 5.7504592108E+00, 2.4146712707E+00, 9.0610648507E-01],
	[2.8195000000E+04, 2.0104780473E+01, 5.2498176599E+00, 5.7537599656E+00, 2.4153328319E+00, 9.0615194513E-01],
	[2.8200000000E+04, 2.0110598208E+01, 5.2497976980E+00, 5.7570620283E+00, 2.4159942798E+00, 9.0619738272E-01],
	[2.8205000000E+04, 2.0116416594E+01, 5.2497777397E+00, 5.7603653993E+00, 2.4166556144E+00, 9.0624279786E-01],
	[2.8210000000E+04, 2.0122235632E+01, 5.2497577851E+00, 5.7636700788E+00, 2.4173168358E+00, 9.0628819055E-01],
	[2.8215000000E+04, 2.0128055322E+01, 5.2497378340E+00, 5.7669760672E+00, 2.4179779437E+00, 9.0633356080E-01],
	[2.8220000000E+04, 2.0133875663E+01, 5.2497178866E+00, 5.7702833647E+00, 2.4186389381E+00, 9.0637890862E-01],
	[2.8225000000E+04, 2.0139696656E+01, 5.2496979427E+00, 5.7735919716E+00, 2.4192998191E+00, 9.0642423402E-01],
	[2.8230000000E+04, 2.0145518300E+01, 5.2496780025E+00, 5.7769018883E+00, 2.4199605865E+00, 9.0646953702E-01],
	[2.8235000000E+04, 2.0151340595E+01, 5.2496580659E+00, 5.7802131149E+00, 2.4206212403E+00, 9.0651481761E-01],
	[2.8240000000E+04, 2.0157163542E+01, 5.2496381328E+00, 5.7835256517E+00, 2.4212817805E+00, 9.0656007581E-01],
	[2.8245000000E+04, 2.0162987140E+01, 5.2496182034E+00, 5.7868394991E+00, 2.4219422069E+00, 9.0660531163E-01],
	[2.8250000000E+04, 2.0168811389E+01, 5.2495982776E+00, 5.7901546574E+00, 2.4226025196E+00, 9.0665052507E-01],
	[2.8255000000E+04, 2.0174636289E+01, 5.2495783554E+00, 5.7934711268E+00, 2.4232627185E+00, 9.0669571615E-01],
	[2.8260000000E+04, 2.0180461841E+01, 5.2495584368E+00, 5.7967889075E+00, 2.4239228035E+00, 9.0674088488E-01],
	[2.8265000000E+04, 2.0186288043E+01, 5.2495385218E+00, 5.8001080000E+00, 2.4245827746E+00, 9.0678603126E-01],
	[2.8270000000E+04, 2.0192114897E+01, 5.2495186104E+00, 5.8034284045E+00, 2.4252426318E+00, 9.0683115531E-01],
	[2.8275000000E+04, 2.0197942401E+01, 5.2494987026E+00, 5.8067501212E+00, 2.4259023749E+00, 9.0687625703E-01],
	[2.8280000000E+04, 2.0203770557E+01, 5.2494787984E+00, 5.8100731505E+00, 2.4265620039E+00, 9.0692133644E-01],
	[2.8285000000E+04, 2.0209599364E+01, 5.2494588977E+00, 5.8133974926E+00, 2.4272215188E+00, 9.0696639354E-01],
	[2.8290000000E+04, 2.0215428821E+01, 5.2494390007E+00, 5.8167231479E+00, 2.4278809196E+00, 9.0701142834E-01],
	[2.8295000000E+04, 2.0221258929E+01, 5.2494191073E+00, 5.8200501165E+00, 2.4285402061E+00, 9.0705644085E-01],
	[2.8300000000E+04, 2.0227089689E+01, 5.2493992174E+00, 5.8233783989E+00, 2.4291993784E+00, 9.0710143108E-01],
	[2.8305000000E+04, 2.0232921098E+01, 5.2493793312E+00, 5.8267079952E+00, 2.4298584363E+00, 9.0714639904E-01],
	[2.8310000000E+04, 2.0238753159E+01, 5.2493594485E+00, 5.8300389059E+00, 2.4305173798E+00, 9.0719134474E-01],
	[2.8315000000E+04, 2.0244585870E+01, 5.2493395694E+00, 5.8333711310E+00, 2.4311762089E+00, 9.0723626819E-01],
	[2.8320000000E+04, 2.0250419232E+01, 5.2493196939E+00, 5.8367046710E+00, 2.4318349236E+00, 9.0728116940E-01],
	[2.8325000000E+04, 2.0256253245E+01, 5.2492998220E+00, 5.8400395262E+00, 2.4324935237E+00, 9.0732604838E-01],
	[2.8330000000E+04, 2.0262087908E+01, 5.2492799537E+00, 5.8433756967E+00, 2.4331520092E+00, 9.0737090514E-01],
	[2.8335000000E+04, 2.0267923221E+01, 5.2492600889E+00, 5.8467131830E+00, 2.4338103801E+00, 9.0741573968E-01],
	[2.8340000000E+04, 2.0273759185E+01, 5.2492402277E+00, 5.8500519852E+00, 2.4344686363E+00, 9.0746055202E-01],
	[2.8345000000E+04, 2.0279595800E+01, 5.2492203701E+00, 5.8533921037E+00, 2.4351267777E+00, 9.0750534216E-01],
	[2.8350000000E+04, 2.0285433065E+01, 5.2492005161E+00, 5.8567335388E+00, 2.4357848044E+00, 9.0755011012E-01],
	[2.8355000000E+04, 2.0291270980E+01, 5.2491806657E+00, 5.8600762907E+00, 2.4364427163E+00, 9.0759485590E-01],
	[2.8360000000E+04, 2.0297109545E+01, 5.2491608188E+00, 5.8634203597E+00, 2.4371005132E+00, 9.0763957952E-01],
	[2.8365000000E+04, 2.0302948761E+01, 5.2491409755E+00, 5.8667657462E+00, 2.4377581953E+00, 9.0768428098E-01],
	[2.8370000000E+04, 2.0308788627E+01, 5.2491211358E+00, 5.8701124503E+00, 2.4384157623E+00, 9.0772896029E-01],
	[2.8375000000E+04, 2.0314629143E+01, 5.2491012997E+00, 5.8734604725E+00, 2.4390732143E+00, 9.0777361747E-01],
	[2.8380000000E+04, 2.0320470309E+01, 5.2490814671E+00, 5.8768098129E+00, 2.4397305513E+00, 9.0781825252E-01],
	[2.8385000000E+04, 2.0326312126E+01, 5.2490616381E+00, 5.8801604719E+00, 2.4403877731E+00, 9.0786286544E-01],
	[2.8390000000E+04, 2.0332154592E+01, 5.2490418127E+00, 5.8835124497E+00, 2.4410448797E+00, 9.0790745626E-01],
	[2.8395000000E+04, 2.0337997709E+01, 5.2490219908E+00, 5.8868657467E+00, 2.4417018710E+00, 9.0795202498E-01],
	[2.8400000000E+04, 2.0343841475E+01, 5.2490021725E+00, 5.8902203630E+00, 2.4423587471E+00, 9.0799657161E-01],
	[2.8405000000E+04, 2.0349685891E+01, 5.2489823577E+00, 5.8935762991E+00, 2.4430155079E+00, 9.0804109615E-01],
	[2.8410000000E+04, 2.0355530957E+01, 5.2489625465E+00, 5.8969335552E+00, 2.4436721532E+00, 9.0808559863E-01],
	[2.8415000000E+04, 2.0361376673E+01, 5.2489427389E+00, 5.9002921316E+00, 2.4443286832E+00, 9.0813007904E-01],
	[2.8420000000E+04, 2.0367223039E+01, 5.2489229349E+00, 5.9036520285E+00, 2.4449850976E+00, 9.0817453740E-01],
	[2.8425000000E+04, 2.0373070055E+01, 5.2489031344E+00, 5.9070132462E+00, 2.4456413966E+00, 9.0821897372E-01],
	[2.8430000000E+04, 2.0378917720E+01, 5.2488833374E+00, 5.9103757852E+00, 2.4462975799E+00, 9.0826338800E-01],
	[2.8435000000E+04, 2.0384766035E+01, 5.2488635440E+00, 5.9137396455E+00, 2.4469536476E+00, 9.0830778026E-01],
	[2.8440000000E+04, 2.0390614999E+01, 5.2488437542E+00, 5.9171048275E+00, 2.4476095996E+00, 9.0835215051E-01],
	[2.8445000000E+04, 2.0396464613E+01, 5.2488239679E+00, 5.9204713316E+00, 2.4482654359E+00, 9.0839649874E-01],
	[2.8450000000E+04, 2.0402314877E+01, 5.2488041852E+00, 5.9238391579E+00, 2.4489211565E+00, 9.0844082499E-01],
	[2.8455000000E+04, 2.0408165790E+01, 5.2487844060E+00, 5.9272083068E+00, 2.4495767612E+00, 9.0848512924E-01],
	[2.8460000000E+04, 2.0414017353E+01, 5.2487646304E+00, 5.9305787785E+00, 2.4502322500E+00, 9.0852941152E-01],
	[2.8465000000E+04, 2.0419869565E+01, 5.2487448583E+00, 5.9339505734E+00, 2.4508876229E+00, 9.0857367184E-01],
	[2.8470000000E+04, 2.0425722426E+01, 5.2487250898E+00, 5.9373236917E+00, 2.4515428798E+00, 9.0861791019E-01],
	[2.8475000000E+04, 2.0431575937E+01, 5.2487053248E+00, 5.9406981337E+00, 2.4521980207E+00, 9.0866212660E-01],
	[2.8480000000E+04, 2.0437430097E+01, 5.2486855633E+00, 5.9440738997E+00, 2.4528530456E+00, 9.0870632107E-01],
	[2.8485000000E+04, 2.0443284906E+01, 5.2486658054E+00, 5.9474509900E+00, 2.4535079543E+00, 9.0875049360E-01],
	[2.8490000000E+04, 2.0449140364E+01, 5.2486460511E+00, 5.9508294049E+00, 2.4541627469E+00, 9.0879464422E-01],
	[2.8495000000E+04, 2.0454996472E+01, 5.2486263003E+00, 5.9542091447E+00, 2.4548174232E+00, 9.0883877293E-01],
	[2.8500000000E+04, 2.0460853229E+01, 5.2486065530E+00, 5.9575902095E+00, 2.4554719833E+00, 9.0888287974E-01],
	[2.8505000000E+04, 2.0466710635E+01, 5.2485868092E+00, 5.9609725999E+00, 2.4561264270E+00, 9.0892696465E-01],
	[2.8510000000E+04, 2.0472575152E+01, 5.2485680218E+00, 5.9643563159E+00, 2.4567810563E+00, 9.0897102769E-01],
	[2.8515000000E+04, 2.0478456458E+01, 5.2485516158E+00, 5.9677413579E+00, 2.4574363230E+00, 9.0901506885E-01],
	[2.8520000000E+04, 2.0484338422E+01, 5.2485352128E+00, 5.9711277263E+00, 2.4580914741E+00, 9.0905908815E-01],
	[2.8525000000E+04, 2.0490221043E+01, 5.2485188127E+00, 5.9745154212E+00, 2.4587465094E+00, 9.0910308560E-01],
	[2.8530000000E+04, 2.0496104322E+01, 5.2485024156E+00, 5.9779044430E+00, 2.4594014289E+00, 9.0914706120E-01],
	[2.8535000000E+04, 2.0501988260E+01, 5.2484860213E+00, 5.9812947919E+00, 2.4600562326E+00, 9.0919101497E-01],
	[2.8540000000E+04, 2.0507872855E+01, 5.2484696300E+00, 5.9846864682E+00, 2.4607109204E+00, 9.0923494691E-01],
	[2.8545000000E+04, 2.0513758107E+01, 5.2484532416E+00, 5.9880794723E+00, 2.4613654923E+00, 9.0927885704E-01],
	[2.8550000000E+04, 2.0519644018E+01, 5.2484368561E+00, 5.9914738044E+00, 2.4620199481E+00, 9.0932274536E-01],
	[2.8555000000E+04, 2.0525530586E+01, 5.2484204736E+00, 5.9948694648E+00, 2.4626742880E+00, 9.0936661189E-01],
	[2.8560000000E+04, 2.0531417812E+01, 5.2484040940E+00, 5.9982664538E+00, 2.4633285118E+00, 9.0941045663E-01],
	[2.8565000000E+04, 2.0537305695E+01, 5.2483877172E+00, 6.0016647717E+00, 2.4639826194E+00, 9.0945427959E-01],
	[2.8570000000E+04, 2.0543194236E+01, 5.2483713434E+00, 6.0050644187E+00, 2.4646366109E+00, 9.0949808079E-01],
	[2.8575000000E+04, 2.0549083434E+01, 5.2483549726E+00, 6.0084653951E+00, 2.4652904861E+00, 9.0954186023E-01],
	[2.8580000000E+04, 2.0554973290E+01, 5.2483386046E+00, 6.0118677013E+00, 2.4659442451E+00, 9.0958561792E-01],
	[2.8585000000E+04, 2.0560863803E+01, 5.2483222396E+00, 6.0152713375E+00, 2.4665978878E+00, 9.0962935387E-01],
	[2.8590000000E+04, 2.0566754974E+01, 5.2483058774E+00, 6.0186763040E+00, 2.4672514141E+00, 9.0967306810E-01],
	[2.8595000000E+04, 2.0572646801E+01, 5.2482895182E+00, 6.0220826011E+00, 2.4679048240E+00, 9.0971676060E-01],
	[2.8600000000E+04, 2.0578539286E+01, 5.2482731619E+00, 6.0254902290E+00, 2.4685581174E+00, 9.0976043139E-01],
	[2.8605000000E+04, 2.0584432429E+01, 5.2482568085E+00, 6.0288991882E+00, 2.4692112944E+00, 9.0980408049E-01],
	[2.8610000000E+04, 2.0590326228E+01, 5.2482404580E+00, 6.0323094787E+00, 2.4698643548E+00, 9.0984770789E-01],
	[2.8615000000E+04, 2.0596220685E+01, 5.2482241104E+00, 6.0357211011E+00, 2.4705172986E+00, 9.0989131361E-01],
	[2.8620000000E+04, 2.0602115799E+01, 5.2482077657E+00, 6.0391340554E+00, 2.4711701258E+00, 9.0993489766E-01],
	[2.8625000000E+04, 2.0608011570E+01, 5.2481914239E+00, 6.0425483421E+00, 2.4718228362E+00, 9.0997846005E-01],
	[2.8630000000E+04, 2.0613907998E+01, 5.2481750851E+00, 6.0459639613E+00, 2.4724754300E+00, 9.1002200079E-01],
	[2.8635000000E+04, 2.0619805083E+01, 5.2481587491E+00, 6.0493809134E+00, 2.4731279069E+00, 9.1006551988E-01],
	[2.8640000000E+04, 2.0625702824E+01, 5.2481424160E+00, 6.0527991987E+00, 2.4737802671E+00, 9.1010901734E-01],
	[2.8645000000E+04, 2.0631601223E+01, 5.2481260859E+00, 6.0562188175E+00, 2.4744325103E+00, 9.1015249317E-01],
	[2.8650000000E+04, 2.0637500279E+01, 5.2481097586E+00, 6.0596397700E+00, 2.4750846367E+00, 9.1019594739E-01],
	[2.8655000000E+04, 2.0643399991E+01, 5.2480934343E+00, 6.0630620565E+00, 2.4757366460E+00, 9.1023938001E-01],
	[2.8660000000E+04, 2.0649300360E+01, 5.2480771128E+00, 6.0664856774E+00, 2.4763885384E+00, 9.1028279103E-01],
	[2.8665000000E+04, 2.0655201386E+01, 5.2480607943E+00, 6.0699106328E+00, 2.4770403137E+00, 9.1032618047E-01],
	[2.8670000000E+04, 2.0661103069E+01, 5.2480444786E+00, 6.0733369232E+00, 2.4776919719E+00, 9.1036954833E-01],
	[2.8675000000E+04, 2.0667005408E+01, 5.2480281658E+00, 6.0767645487E+00, 2.4783435130E+00, 9.1041289463E-01],
	[2.8680000000E+04, 2.0672908404E+01, 5.2480118559E+00, 6.0801935097E+00, 2.4789949368E+00, 9.1045621936E-01],
	[2.8685000000E+04, 2.0678812057E+01, 5.2479955490E+00, 6.0836238064E+00, 2.4796462435E+00, 9.1049952256E-01],
	[2.8690000000E+04, 2.0684716366E+01, 5.2479792449E+00, 6.0870554392E+00, 2.4802974328E+00, 9.1054280421E-01],
	[2.8695000000E+04, 2.0690621331E+01, 5.2479629437E+00, 6.0904884083E+00, 2.4809485048E+00, 9.1058606434E-01],
	[2.8700000000E+04, 2.0696526953E+01, 5.2479466454E+00, 6.0939227140E+00, 2.4815994594E+00, 9.1062930294E-01],
	[2.8705000000E+04, 2.0702433232E+01, 5.2479303500E+00, 6.0973583566E+00, 2.4822502966E+00, 9.1067252004E-01],
	[2.8710000000E+04, 2.0708340166E+01, 5.2479140574E+00, 6.1007953364E+00, 2.4829010164E+00, 9.1071571564E-01],
	[2.8715000000E+04, 2.0714247758E+01, 5.2478977678E+00, 6.1042336537E+00, 2.4835516186E+00, 9.1075888976E-01],
	[2.8720000000E+04, 2.0720156005E+01, 5.2478814811E+00, 6.1076733087E+00, 2.4842021033E+00, 9.1080204239E-01],
	[2.8725000000E+04, 2.0726064908E+01, 5.2478651972E+00, 6.1111143018E+00, 2.4848524703E+00, 9.1084517355E-01],
	[2.8730000000E+04, 2.0731974468E+01, 5.2478489162E+00, 6.1145566332E+00, 2.4855027198E+00, 9.1088828325E-01],
	[2.8735000000E+04, 2.0737884684E+01, 5.2478326381E+00, 6.1180003033E+00, 2.4861528515E+00, 9.1093137150E-01],
	[2.8740000000E+04, 2.0743795556E+01, 5.2478163629E+00, 6.1214453122E+00, 2.4868028655E+00, 9.1097443831E-01],
	[2.8745000000E+04, 2.0749707084E+01, 5.2478000906E+00, 6.1248916604E+00, 2.4874527617E+00, 9.1101748369E-01],
	[2.8750000000E+04, 2.0755619269E+01, 5.2477838211E+00, 6.1283393480E+00, 2.4881025401E+00, 9.1106050765E-01],
	[2.8755000000E+04, 2.0761532109E+01, 5.2477675545E+00, 6.1317883754E+00, 2.4887522006E+00, 9.1110351019E-01],
	[2.8760000000E+04, 2.0767445605E+01, 5.2477512908E+00, 6.1352387428E+00, 2.4894017432E+00, 9.1114649133E-01],
	[2.8765000000E+04, 2.0773359757E+01, 5.2477350300E+00, 6.1386904506E+00, 2.4900511679E+00, 9.1118945108E-01],
	[2.8770000000E+04, 2.0779274565E+01, 5.2477187721E+00, 6.1421434990E+00, 2.4907004745E+00, 9.1123238945E-01],
	[2.8775000000E+04, 2.0785190029E+01, 5.2477025170E+00, 6.1455978883E+00, 2.4913496631E+00, 9.1127530644E-01],
	[2.8780000000E+04, 2.0791106148E+01, 5.2476862648E+00, 6.1490536189E+00, 2.4919987336E+00, 9.1131820207E-01],
	[2.8785000000E+04, 2.0797022924E+01, 5.2476700155E+00, 6.1525106909E+00, 2.4926476860E+00, 9.1136107634E-01],
	[2.8790000000E+04, 2.0802940354E+01, 5.2476537691E+00, 6.1559691047E+00, 2.4932965202E+00, 9.1140392927E-01],
	[2.8795000000E+04, 2.0808858441E+01, 5.2476375255E+00, 6.1594288606E+00, 2.4939452361E+00, 9.1144676086E-01],
	[2.8800000000E+04, 2.0814777183E+01, 5.2476212848E+00, 6.1628899588E+00, 2.4945938338E+00, 9.1148957113E-01],
	[2.8805000000E+04, 2.0820696581E+01, 5.2476050470E+00, 6.1663523997E+00, 2.4952423132E+00, 9.1153236008E-01],
	[2.8810000000E+04, 2.0826616635E+01, 5.2475888120E+00, 6.1698161835E+00, 2.4958906742E+00, 9.1157512773E-01],
	[2.8815000000E+04, 2.0832537344E+01, 5.2475725799E+00, 6.1732813105E+00, 2.4965389169E+00, 9.1161787407E-01],
	[2.8820000000E+04, 2.0838458708E+01, 5.2475563507E+00, 6.1767477810E+00, 2.4971870410E+00, 9.1166059914E-01],
	[2.8825000000E+04, 2.0844380728E+01, 5.2475401243E+00, 6.1802155953E+00, 2.4978350468E+00, 9.1170330292E-01],
	[2.8830000000E+04, 2.0850303403E+01, 5.2475239008E+00, 6.1836847536E+00, 2.4984829339E+00, 9.1174598544E-01],
	[2.8835000000E+04, 2.0856226733E+01, 5.2475076802E+00, 6.1871552564E+00, 2.4991307025E+00, 9.1178864670E-01],
	[2.8840000000E+04, 2.0862150719E+01, 5.2474914624E+00, 6.1906271037E+00, 2.4997783525E+00, 9.1183128671E-01],
	[2.8845000000E+04, 2.0868075360E+01, 5.2474752475E+00, 6.1941002961E+00, 2.5004258838E+00, 9.1187390548E-01],
	[2.8850000000E+04, 2.0874000656E+01, 5.2474590355E+00, 6.1975748336E+00, 2.5010732964E+00, 9.1191650303E-01],
	[2.8855000000E+04, 2.0879926608E+01, 5.2474428263E+00, 6.2010507166E+00, 2.5017205903E+00, 9.1195907935E-01],
	[2.8860000000E+04, 2.0885853214E+01, 5.2474266199E+00, 6.2045279455E+00, 2.5023677654E+00, 9.1200163447E-01],
	[2.8865000000E+04, 2.0891780476E+01, 5.2474104165E+00, 6.2080065204E+00, 2.5030148217E+00, 9.1204416838E-01],
	[2.8870000000E+04, 2.0897708393E+01, 5.2473942158E+00, 6.2114864417E+00, 2.5036617590E+00, 9.1208668111E-01],
	[2.8875000000E+04, 2.0903636964E+01, 5.2473780181E+00, 6.2149677097E+00, 2.5043085775E+00, 9.1212917265E-01],
	[2.8880000000E+04, 2.0909566191E+01, 5.2473618232E+00, 6.2184503246E+00, 2.5049552770E+00, 9.1217164303E-01],
	[2.8885000000E+04, 2.0915496072E+01, 5.2473456311E+00, 6.2219342868E+00, 2.5056018575E+00, 9.1221409224E-01],
	[2.8890000000E+04, 2.0921426609E+01, 5.2473294419E+00, 6.2254195964E+00, 2.5062483189E+00, 9.1225652030E-01],
	[2.8895000000E+04, 2.0927357800E+01, 5.2473132556E+00, 6.2289062539E+00, 2.5068946613E+00, 9.1229892722E-01],
	[2.8900000000E+04, 2.0933289646E+01, 5.2472970721E+00, 6.2323942595E+00, 2.5075408845E+00, 9.1234131301E-01],
	[2.8905000000E+04, 2.0939222147E+01, 5.2472808914E+00, 6.2358836135E+00, 2.5081869886E+00, 9.1238367767E-01],
	[2.8910000000E+04, 2.0945155303E+01, 5.2472647136E+00, 6.2393743161E+00, 2.5088329735E+00, 9.1242602123E-01],
	[2.8915000000E+04, 2.0951089113E+01, 5.2472485387E+00, 6.2428663677E+00, 2.5094788391E+00, 9.1246834368E-01],
	[2.8920000000E+04, 2.0957023578E+01, 5.2472323666E+00, 6.2463597686E+00, 2.5101245853E+00, 9.1251064503E-01],
	[2.8925000000E+04, 2.0962958697E+01, 5.2472161973E+00, 6.2498545189E+00, 2.5107702123E+00, 9.1255292530E-01],
	[2.8930000000E+04, 2.0968894471E+01, 5.2472000309E+00, 6.2533506191E+00, 2.5114157199E+00, 9.1259518450E-01],
	[2.8935000000E+04, 2.0974830900E+01, 5.2471838673E+00, 6.2568480694E+00, 2.5120611080E+00, 9.1263742263E-01],
	[2.8940000000E+04, 2.0980767983E+01, 5.2471677066E+00, 6.2603468701E+00, 2.5127063767E+00, 9.1267963971E-01],
	[2.8945000000E+04, 2.0986705720E+01, 5.2471515487E+00, 6.2638470215E+00, 2.5133515259E+00, 9.1272183575E-01],
	[2.8950000000E+04, 2.0992644112E+01, 5.2471353936E+00, 6.2673485239E+00, 2.5139965555E+00, 9.1276401074E-01],
	[2.8955000000E+04, 2.0998583158E+01, 5.2471192414E+00, 6.2708513775E+00, 2.5146414655E+00, 9.1280616472E-01],
	[2.8960000000E+04, 2.1004522859E+01, 5.2471030920E+00, 6.2743555826E+00, 2.5152862559E+00, 9.1284829767E-01],
	[2.8965000000E+04, 2.1010463214E+01, 5.2470869455E+00, 6.2778611396E+00, 2.5159309266E+00, 9.1289040962E-01],
	[2.8970000000E+04, 2.1016415371E+01, 5.2470724256E+00, 6.2813680488E+00, 2.5165760110E+00, 9.1293250058E-01],
	[2.8975000000E+04, 2.1022379509E+01, 5.2470595570E+00, 6.2848763103E+00, 2.5172215178E+00, 9.1297457055E-01],
	[2.8980000000E+04, 2.1028344310E+01, 5.2470466906E+00, 6.2883859245E+00, 2.5178669055E+00, 9.1301661954E-01],
	[2.8985000000E+04, 2.1034309774E+01, 5.2470338265E+00, 6.2918968917E+00, 2.5185121741E+00, 9.1305864756E-01],
	[2.8990000000E+04, 2.1040275901E+01, 5.2470209646E+00, 6.2954092122E+00, 2.5191573235E+00, 9.1310065462E-01],
	[2.8995000000E+04, 2.1046242691E+01, 5.2470081050E+00, 6.2989228862E+00, 2.5198023538E+00, 9.1314264074E-01],
	[2.9000000000E+04, 2.1052210144E+01, 5.2469952476E+00, 6.3024379141E+00, 2.5204472649E+00, 9.1318460592E-01],
	[2.9005000000E+04, 2.1058178259E+01, 5.2469823925E+00, 6.3059542961E+00, 2.5210920566E+00, 9.1322655017E-01],
	[2.9010000000E+04, 2.1064147038E+01, 5.2469695396E+00, 6.3094720325E+00, 2.5217367291E+00, 9.1326847350E-01],
	[2.9015000000E+04, 2.1070116479E+01, 5.2469566890E+00, 6.3129911237E+00, 2.5223812822E+00, 9.1331037592E-01],
	[2.9020000000E+04, 2.1076086582E+01, 5.2469438406E+00, 6.3165115698E+00, 2.5230257160E+00, 9.1335225745E-01],
	[2.9025000000E+04, 2.1082057348E+01, 5.2469309944E+00, 6.3200333712E+00, 2.5236700303E+00, 9.1339411808E-01],
	[2.9030000000E+04, 2.1088028777E+01, 5.2469181505E+00, 6.3235565282E+00, 2.5243142251E+00, 9.1343595783E-01],
	[2.9035000000E+04, 2.1094000869E+01, 5.2469053089E+00, 6.3270810411E+00, 2.5249583004E+00, 9.1347777672E-01],
	[2.9040000000E+04, 2.1099973623E+01, 5.2468924694E+00, 6.3306069101E+00, 2.5256022562E+00, 9.1351957474E-01],
	[2.9045000000E+04, 2.1105947039E+01, 5.2468796323E+00, 6.3341341355E+00, 2.5262460924E+00, 9.1356135191E-01],
	[2.9050000000E+04, 2.1111921118E+01, 5.2468667973E+00, 6.3376627177E+00, 2.5268898089E+00, 9.1360310824E-01],
	[2.9055000000E+04, 2.1117895859E+01, 5.2468539646E+00, 6.3411926568E+00, 2.5275334058E+00, 9.1364484374E-01],
	[2.9060000000E+04, 2.1123871262E+01, 5.2468411342E+00, 6.3447239533E+00, 2.5281768829E+00, 9.1368655841E-01],
	[2.9065000000E+04, 2.1129847328E+01, 5.2468283060E+00, 6.3482566074E+00, 2.5288202403E+00, 9.1372825228E-01],
	[2.9070000000E+04, 2.1135824056E+01, 5.2468154800E+00, 6.3517906193E+00, 2.5294634779E+00, 9.1376992534E-01],
	[2.9075000000E+04, 2.1141801447E+01, 5.2468026562E+00, 6.3553259894E+00, 2.5301065957E+00, 9.1381157761E-01],
	[2.9080000000E+04, 2.1147779499E+01, 5.2467898347E+00, 6.3588627179E+00, 2.5307495936E+00, 9.1385320910E-01],
	[2.9085000000E+04, 2.1153758214E+01, 5.2467770155E+00, 6.3624008052E+00, 2.5313924715E+00, 9.1389481981E-01],
	[2.9090000000E+04, 2.1159737591E+01, 5.2467641984E+00, 6.3659402515E+00, 2.5320352296E+00, 9.1393640976E-01],
	[2.9095000000E+04, 2.1165717629E+01, 5.2467513836E+00, 6.3694810571E+00, 2.5326778676E+00, 9.1397797895E-01],
	[2.9100000000E+04, 2.1171698330E+01, 5.2467385711E+00, 6.3730232223E+00, 2.5333203856E+00, 9.1401952741E-01],
	[2.9105000000E+04, 2.1177679693E+01, 5.2467257607E+00, 6.3765667474E+00, 2.5339627835E+00, 9.1406105512E-01],
	[2.9110000000E+04, 2.1183661718E+01, 5.2467129526E+00, 6.3801116326E+00, 2.5346050613E+00, 9.1410256212E-01],
	[2.9115000000E+04, 2.1189644404E+01, 5.2467001468E+00, 6.3836578784E+00, 2.5352472189E+00, 9.1414404840E-01],
	[2.9120000000E+04, 2.1195627753E+01, 5.2466873431E+00, 6.3872054848E+00, 2.5358892564E+00, 9.1418551397E-01],
	[2.9125000000E+04, 2.1201611763E+01, 5.2466745417E+00, 6.3907544524E+00, 2.5365311736E+00, 9.1422695885E-01],
	[2.9130000000E+04, 2.1207596435E+01, 5.2466617425E+00, 6.3943047812E+00, 2.5371729705E+00, 9.1426838304E-01],
	[2.9135000000E+04, 2.1213581769E+01, 5.2466489456E+00, 6.3978564717E+00, 2.5378146472E+00, 9.1430978655E-01],
	[2.9140000000E+04, 2.1219567765E+01, 5.2466361508E+00, 6.4014095240E+00, 2.5384562034E+00, 9.1435116940E-01],
	[2.9145000000E+04, 2.1225554422E+01, 5.2466233583E+00, 6.4049639386E+00, 2.5390976393E+00, 9.1439253160E-01],
	[2.9150000000E+04, 2.1231541741E+01, 5.2466105681E+00, 6.4085197156E+00, 2.5397389548E+00, 9.1443387314E-01],
	[2.9155000000E+04, 2.1237529721E+01, 5.2465977800E+00, 6.4120768554E+00, 2.5403801498E+00, 9.1447519405E-01],
	[2.9160000000E+04, 2.1243518363E+01, 5.2465849942E+00, 6.4156353583E+00, 2.5410212243E+00, 9.1451649433E-01],
	[2.9165000000E+04, 2.1249507666E+01, 5.2465722106E+00, 6.4191952245E+00, 2.5416621782E+00, 9.1455777399E-01],
	[2.9170000000E+04, 2.1255497631E+01, 5.2465594292E+00, 6.4227564543E+00, 2.5423030116E+00, 9.1459903304E-01],
	[2.9175000000E+04, 2.1261488258E+01, 5.2465466501E+00, 6.4263190481E+00, 2.5429437243E+00, 9.1464027149E-01],
	[2.9180000000E+04, 2.1267479545E+01, 5.2465338731E+00, 6.4298830060E+00, 2.5435843164E+00, 9.1468148934E-01],
	[2.9185000000E+04, 2.1273471494E+01, 5.2465210984E+00, 6.4334483285E+00, 2.5442247878E+00, 9.1472268661E-01],
	[2.9190000000E+04, 2.1279464105E+01, 5.2465083259E+00, 6.4370150157E+00, 2.5448651384E+00, 9.1476386330E-01],
	[2.9195000000E+04, 2.1285457376E+01, 5.2464955556E+00, 6.4405830680E+00, 2.5455053683E+00, 9.1480501943E-01],
	[2.9200000000E+04, 2.1291451309E+01, 5.2464827876E+00, 6.4441524856E+00, 2.5461454773E+00, 9.1484615500E-01],
	[2.9205000000E+04, 2.1297445903E+01, 5.2464700217E+00, 6.4477232689E+00, 2.5467854655E+00, 9.1488727002E-01],
	[2.9210000000E+04, 2.1303441158E+01, 5.2464572581E+00, 6.4512954182E+00, 2.5474253328E+00, 9.1492836450E-01],
	[2.9215000000E+04, 2.1309437074E+01, 5.2464444967E+00, 6.4548689336E+00, 2.5480650791E+00, 9.1496943845E-01],
	[2.9220000000E+04, 2.1315433651E+01, 5.2464317375E+00, 6.4584438156E+00, 2.5487047045E+00, 9.1501049188E-01],
	[2.9225000000E+04, 2.1321430889E+01, 5.2464189805E+00, 6.4620200644E+00, 2.5493442089E+00, 9.1505152479E-01],
	[2.9230000000E+04, 2.1327428789E+01, 5.2464062257E+00, 6.4655976802E+00, 2.5499835923E+00, 9.1509253721E-01],
	[2.9235000000E+04, 2.1333427349E+01, 5.2463934732E+00, 6.4691766634E+00, 2.5506228545E+00, 9.1513352912E-01],
	[2.9240000000E+04, 2.1339426570E+01, 5.2463807228E+00, 6.4727570143E+00, 2.5512619957E+00, 9.1517450056E-01],
	[2.9245000000E+04, 2.1345426452E+01, 5.2463679747E+00, 6.4763387332E+00, 2.5519010157E+00, 9.1521545151E-01],
	[2.9250000000E+04, 2.1351426994E+01, 5.2463552288E+00, 6.4799218202E+00, 2.5525399145E+00, 9.1525638200E-01],
	[2.9255000000E+04, 2.1357428198E+01, 5.2463424850E+00, 6.4835062758E+00, 2.5531786920E+00, 9.1529729203E-01],
	[2.9260000000E+04, 2.1363430062E+01, 5.2463297435E+00, 6.4870921003E+00, 2.5538173483E+00, 9.1533818161E-01],
	[2.9265000000E+04, 2.1369432587E+01, 5.2463170042E+00, 6.4906792938E+00, 2.5544558833E+00, 9.1537905074E-01],
	[2.9270000000E+04, 2.1375435772E+01, 5.2463042672E+00, 6.4942678567E+00, 2.5550942969E+00, 9.1541989945E-01],
	[2.9275000000E+04, 2.1381439618E+01, 5.2462915323E+00, 6.4978577893E+00, 2.5557325892E+00, 9.1546072773E-01],
	[2.9280000000E+04, 2.1387444125E+01, 5.2462787996E+00, 6.5014490918E+00, 2.5563707600E+00, 9.1550153560E-01],
	[2.9285000000E+04, 2.1393449292E+01, 5.2462660691E+00, 6.5050417647E+00, 2.5570088094E+00, 9.1554232307E-01],
	[2.9290000000E+04, 2.1399455120E+01, 5.2462533409E+00, 6.5086358080E+00, 2.5576467373E+00, 9.1558309014E-01],
	[2.9295000000E+04, 2.1405461608E+01, 5.2462406148E+00, 6.5122312222E+00, 2.5582845436E+00, 9.1562383682E-01],
	[2.9300000000E+04, 2.1411468757E+01, 5.2462278909E+00, 6.5158280075E+00, 2.5589222284E+00, 9.1566456312E-01],
	[2.9305000000E+04, 2.1417476566E+01, 5.2462151693E+00, 6.5194261642E+00, 2.5595597916E+00, 9.1570526906E-01],
	[2.9310000000E+04, 2.1423485035E+01, 5.2462024498E+00, 6.5230256927E+00, 2.5601972331E+00, 9.1574595463E-01],
	[2.9315000000E+04, 2.1429494164E+01, 5.2461897325E+00, 6.5266265931E+00, 2.5608345530E+00, 9.1578661986E-01],
	[2.9320000000E+04, 2.1435503954E+01, 5.2461770175E+00, 6.5302288657E+00, 2.5614717511E+00, 9.1582726474E-01],
	[2.9325000000E+04, 2.1441514404E+01, 5.2461643046E+00, 6.5338325110E+00, 2.5621088275E+00, 9.1586788929E-01],
	[2.9330000000E+04, 2.1447525514E+01, 5.2461515940E+00, 6.5374375291E+00, 2.5627457821E+00, 9.1590849352E-01],
	[2.9335000000E+04, 2.1453537285E+01, 5.2461388855E+00, 6.5410439203E+00, 2.5633826149E+00, 9.1594907743E-01],
	[2.9340000000E+04, 2.1459549715E+01, 5.2461261792E+00, 6.5446516850E+00, 2.5640193258E+00, 9.1598964104E-01],
	[2.9345000000E+04, 2.1465562806E+01, 5.2461134752E+00, 6.5482608233E+00, 2.5646559148E+00, 9.1603018435E-01],
	[2.9350000000E+04, 2.1471576556E+01, 5.2461007733E+00, 6.5518713357E+00, 2.5652923819E+00, 9.1607070737E-01],
	[2.9355000000E+04, 2.1477590966E+01, 5.2460880736E+00, 6.5554832224E+00, 2.5659287270E+00, 9.1611121011E-01],
	[2.9360000000E+04, 2.1483606037E+01, 5.2460753761E+00, 6.5590964836E+00, 2.5665649501E+00, 9.1615169258E-01],
	[2.9365000000E+04, 2.1489621767E+01, 5.2460626808E+00, 6.5627111197E+00, 2.5672010512E+00, 9.1619215480E-01],
	[2.9370000000E+04, 2.1495638157E+01, 5.2460499877E+00, 6.5663271310E+00, 2.5678370302E+00, 9.1623259676E-01],
	[2.9375000000E+04, 2.1501655207E+01, 5.2460372968E+00, 6.5699445177E+00, 2.5684728870E+00, 9.1627301848E-01],
	[2.9380000000E+04, 2.1507672917E+01, 5.2460246081E+00, 6.5735632802E+00, 2.5691086217E+00, 9.1631341996E-01],
	[2.9385000000E+04, 2.1513691286E+01, 5.2460119216E+00, 6.5771834187E+00, 2.5697442343E+00, 9.1635380122E-01],
	[2.9390000000E+04, 2.1519710315E+01, 5.2459992372E+00, 6.5808049334E+00, 2.5703797246E+00, 9.1639416227E-01],
	[2.9395000000E+04, 2.1525730004E+01, 5.2459865551E+00, 6.5844278248E+00, 2.5710150926E+00, 9.1643450311E-01],
	[2.9400000000E+04, 2.1531750352E+01, 5.2459738751E+00, 6.5880520931E+00, 2.5716503384E+00, 9.1647482375E-01],
	[2.9405000000E+04, 2.1537771360E+01, 5.2459611973E+00, 6.5916777386E+00, 2.5722854618E+00, 9.1651512421E-01],
	[2.9410000000E+04, 2.1543793028E+01, 5.2459485217E+00, 6.5953047615E+00, 2.5729204629E+00, 9.1655540448E-01],
	[2.9415000000E+04, 2.1549815355E+01, 5.2459358483E+00, 6.5989331621E+00, 2.5735553416E+00, 9.1659566459E-01],
	[2.9420000000E+04, 2.1555838341E+01, 5.2459231771E+00, 6.6025629408E+00, 2.5741900978E+00, 9.1663590453E-01],
	[2.9425000000E+04, 2.1561861987E+01, 5.2459105080E+00, 6.6061940979E+00, 2.5748247316E+00, 9.1667612432E-01],
	[2.9430000000E+04, 2.1567886292E+01, 5.2458978412E+00, 6.6098266335E+00, 2.5754592428E+00, 9.1671632397E-01],
	[2.9435000000E+04, 2.1573916364E+01, 5.2458859118E+00, 6.6134605481E+00, 2.5760938817E+00, 9.1675650349E-01],
	[2.9440000000E+04, 2.1579964328E+01, 5.2458764645E+00, 6.6170958419E+00, 2.5767292422E+00, 9.1679666288E-01],
	[2.9445000000E+04, 2.1586012961E+01, 5.2458670188E+00, 6.6207325151E+00, 2.5773644807E+00, 9.1683680215E-01],
	[2.9450000000E+04, 2.1592062262E+01, 5.2458575748E+00, 6.6243705681E+00, 2.5779995974E+00, 9.1687692132E-01],
	[2.9455000000E+04, 2.1598112230E+01, 5.2458481324E+00, 6.6280100012E+00, 2.5786345921E+00, 9.1691702039E-01],
	[2.9460000000E+04, 2.1604162867E+01, 5.2458386916E+00, 6.6316508146E+00, 2.5792694648E+00, 9.1695709937E-01],
	[2.9465000000E+04, 2.1610214171E+01, 5.2458292524E+00, 6.6352930087E+00, 2.5799042155E+00, 9.1699715828E-01],
	[2.9470000000E+04, 2.1616266143E+01, 5.2458198149E+00, 6.6389365837E+00, 2.5805388441E+00, 9.1703719711E-01],
	[2.9475000000E+04, 2.1622318783E+01, 5.2458103789E+00, 6.6425815399E+00, 2.5811733505E+00, 9.1707721588E-01],
	[2.9480000000E+04, 2.1628372090E+01, 5.2458009446E+00, 6.6462278776E+00, 2.5818077349E+00, 9.1711721460E-01],
	[2.9485000000E+04, 2.1634426065E+01, 5.2457915119E+00, 6.6498755971E+00, 2.5824419971E+00, 9.1715719328E-01],
	[2.9490000000E+04, 2.1640480707E+01, 5.2457820808E+00, 6.6535246987E+00, 2.5830761371E+00, 9.1719715192E-01],
	[2.9495000000E+04, 2.1646536018E+01, 5.2457726513E+00, 6.6571751827E+00, 2.5837101548E+00, 9.1723709054E-01],
	[2.9500000000E+04, 2.1652591995E+01, 5.2457632235E+00, 6.6608270493E+00, 2.5843440502E+00, 9.1727700914E-01],
	[2.9505000000E+04, 2.1658648640E+01, 5.2457537972E+00, 6.6644802989E+00, 2.5849778234E+00, 9.1731690773E-01],
	[2.9510000000E+04, 2.1664705953E+01, 5.2457443726E+00, 6.6681349317E+00, 2.5856114742E+00, 9.1735678633E-01],
	[2.9515000000E+04, 2.1670763933E+01, 5.2457349496E+00, 6.6717909480E+00, 2.5862450026E+00, 9.1739664494E-01],
	[2.9520000000E+04, 2.1676822580E+01, 5.2457255282E+00, 6.6754483482E+00, 2.5868784086E+00, 9.1743648357E-01],
	[2.9525000000E+04, 2.1682881895E+01, 5.2457161084E+00, 6.6791071324E+00, 2.5875116922E+00, 9.1747630223E-01],
	[2.9530000000E+04, 2.1688941877E+01, 5.2457066902E+00, 6.6827673011E+00, 2.5881448533E+00, 9.1751610092E-01],
	[2.9535000000E+04, 2.1695002526E+01, 5.2456972737E+00, 6.6864288544E+00, 2.5887778919E+00, 9.1755587967E-01],
	[2.9540000000E+04, 2.1701063842E+01, 5.2456878587E+00, 6.6900917927E+00, 2.5894108079E+00, 9.1759563847E-01],
	[2.9545000000E+04, 2.1707125826E+01, 5.2456784454E+00, 6.6937561162E+00, 2.5900436013E+00, 9.1763537734E-01],
	[2.9550000000E+04, 2.1713188477E+01, 5.2456690336E+00, 6.6974218253E+00, 2.5906762721E+00, 9.1767509628E-01],
	[2.9555000000E+04, 2.1719251794E+01, 5.2456596235E+00, 6.7010889202E+00, 2.5913088203E+00, 9.1771479531E-01],
	[2.9560000000E+04, 2.1725315779E+01, 5.2456502150E+00, 6.7047574013E+00, 2.5919412458E+00, 9.1775447443E-01],
	[2.9565000000E+04, 2.1731380431E+01, 5.2456408081E+00, 6.7084272688E+00, 2.5925735485E+00, 9.1779413366E-01],
	[2.9570000000E+04, 2.1737445750E+01, 5.2456314028E+00, 6.7120985229E+00, 2.5932057286E+00, 9.1783377299E-01],
	[2.9575000000E+04, 2.1743511735E+01, 5.2456219991E+00, 6.7157711641E+00, 2.5938377858E+00, 9.1787339245E-01],
	[2.9580000000E+04, 2.1749578388E+01, 5.2456125970E+00, 6.7194451925E+00, 2.5944697202E+00, 9.1791299203E-01],
	[2.9585000000E+04, 2.1755645707E+01, 5.2456031965E+00, 6.7231206086E+00, 2.5951015318E+00, 9.1795257176E-01],
	[2.9590000000E+04, 2.1761713694E+01, 5.2455937976E+00, 6.7267974124E+00, 2.5957332204E+00, 9.1799213163E-01],
	[2.9595000000E+04, 2.1767782347E+01, 5.2455844004E+00, 6.7304756044E+00, 2.5963647862E+00, 9.1803167166E-01],
	[2.9600000000E+04, 2.1773851666E+01, 5.2455750047E+00, 6.7341551849E+00, 2.5969962290E+00, 9.1807119186E-01],
	[2.9605000000E+04, 2.1779921653E+01, 5.2455656106E+00, 6.7378361541E+00, 2.5976275488E+00, 9.1811069223E-01],
	[2.9610000000E+04, 2.1785992306E+01, 5.2455562182E+00, 6.7415185122E+00, 2.5982587456E+00, 9.1815017279E-01],
	[2.9615000000E+04, 2.1792063626E+01, 5.2455468273E+00, 6.7452022597E+00, 2.5988898194E+00, 9.1818963354E-01],
	[2.9620000000E+04, 2.1798135612E+01, 5.2455374381E+00, 6.7488873968E+00, 2.5995207701E+00, 9.1822907449E-01],
	[2.9625000000E+04, 2.1804208265E+01, 5.2455280504E+00, 6.7525739238E+00, 2.6001515976E+00, 9.1826849566E-01],
	[2.9630000000E+04, 2.1810281584E+01, 5.2455186644E+00, 6.7562618409E+00, 2.6007823020E+00, 9.1830789704E-01],
	[2.9635000000E+04, 2.1816355570E+01, 5.2455092799E+00, 6.7599511485E+00, 2.6014128833E+00, 9.1834727866E-01],
	[2.9640000000E+04, 2.1822430222E+01, 5.2454998971E+00, 6.7636418468E+00, 2.6020433413E+00, 9.1838664051E-01],
	[2.9645000000E+04, 2.1828505540E+01, 5.2454905158E+00, 6.7673339362E+00, 2.6026736760E+00, 9.1842598262E-01],
	[2.9650000000E+04, 2.1834581525E+01, 5.2454811362E+00, 6.7710274169E+00, 2.6033038875E+00, 9.1846530498E-01],
	[2.9655000000E+04, 2.1840658176E+01, 5.2454717581E+00, 6.7747222892E+00, 2.6039339757E+00, 9.1850460761E-01],
	[2.9660000000E+04, 2.1846735494E+01, 5.2454623817E+00, 6.7784185534E+00, 2.6045639405E+00, 9.1854389051E-01],
	[2.9665000000E+04, 2.1852813478E+01, 5.2454530068E+00, 6.7821162098E+00, 2.6051937820E+00, 9.1858315370E-01],
	[2.9670000000E+04, 2.1858892127E+01, 5.2454436335E+00, 6.7858152587E+00, 2.6058235000E+00, 9.1862239718E-01],
	[2.9675000000E+04, 2.1864971443E+01, 5.2454342619E+00, 6.7895157004E+00, 2.6064530947E+00, 9.1866162097E-01],
	[2.9680000000E+04, 2.1871051425E+01, 5.2454248918E+00, 6.7932175351E+00, 2.6070825658E+00, 9.1870082507E-01],
	[2.9685000000E+04, 2.1877132073E+01, 5.2454155233E+00, 6.7969207631E+00, 2.6077119134E+00, 9.1874000949E-01],
	[2.9690000000E+04, 2.1883213388E+01, 5.2454061564E+00, 6.8006253849E+00, 2.6083411375E+00, 9.1877917424E-01],
	[2.9695000000E+04, 2.1889295368E+01, 5.2453967911E+00, 6.8043314005E+00, 2.6089702381E+00, 9.1881831933E-01],
	[2.9700000000E+04, 2.1895378014E+01, 5.2453874275E+00, 6.8080388103E+00, 2.6095992150E+00, 9.1885744477E-01],
	[2.9705000000E+04, 2.1901461326E+01, 5.2453780654E+00, 6.8117476147E+00, 2.6102280683E+00, 9.1889655057E-01],
	[2.9710000000E+04, 2.1907545304E+01, 5.2453687048E+00, 6.8154578138E+00, 2.6108567979E+00, 9.1893563673E-01],
	[2.9715000000E+04, 2.1913629947E+01, 5.2453593459E+00, 6.8191694080E+00, 2.6114854039E+00, 9.1897470327E-01],
	[2.9720000000E+04, 2.1919715257E+01, 5.2453499886E+00, 6.8228823976E+00, 2.6121138861E+00, 9.1901375020E-01],
	[2.9725000000E+04, 2.1925801232E+01, 5.2453406329E+00, 6.8265967829E+00, 2.6127422445E+00, 9.1905277752E-01],
	[2.9730000000E+04, 2.1931887873E+01, 5.2453312787E+00, 6.8303125641E+00, 2.6133704792E+00, 9.1909178525E-01],
	[2.9735000000E+04, 2.1937975179E+01, 5.2453219262E+00, 6.8340297416E+00, 2.6139985900E+00, 9.1913077339E-01],
	[2.9740000000E+04, 2.1944063152E+01, 5.2453125752E+00, 6.8377483156E+00, 2.6146265770E+00, 9.1916974195E-01],
	[2.9745000000E+04, 2.1950151789E+01, 5.2453032258E+00, 6.8414682864E+00, 2.6152544402E+00, 9.1920869094E-01],
	[2.9750000000E+04, 2.1956241093E+01, 5.2452938780E+00, 6.8451896543E+00, 2.6158821794E+00, 9.1924762037E-01],
	[2.9755000000E+04, 2.1962331062E+01, 5.2452845318E+00, 6.8489124196E+00, 2.6165097946E+00, 9.1928653026E-01],
	[2.9760000000E+04, 2.1968421696E+01, 5.2452751872E+00, 6.8526365826E+00, 2.6171372859E+00, 9.1932542060E-01],
	[2.9765000000E+04, 2.1974512996E+01, 5.2452658442E+00, 6.8563621435E+00, 2.6177646531E+00, 9.1936429141E-01],
	[2.9770000000E+04, 2.1980604961E+01, 5.2452565028E+00, 6.8600891028E+00, 2.6183918964E+00, 9.1940314269E-01],
	[2.9775000000E+04, 2.1986697591E+01, 5.2452471629E+00, 6.8638174605E+00, 2.6190190155E+00, 9.1944197447E-01],
	[2.9780000000E+04, 2.1992790887E+01, 5.2452378246E+00, 6.8675472172E+00, 2.6196460106E+00, 9.1948078673E-01],
	[2.9785000000E+04, 2.1998884848E+01, 5.2452284879E+00, 6.8712783729E+00, 2.6202728815E+00, 9.1951957951E-01],
	[2.9790000000E+04, 2.2004979475E+01, 5.2452191528E+00, 6.8750109281E+00, 2.6208996283E+00, 9.1955835279E-01],
	[2.9795000000E+04, 2.2011074766E+01, 5.2452098193E+00, 6.8787448830E+00, 2.6215262509E+00, 9.1959710660E-01],
	[2.9800000000E+04, 2.2017170723E+01, 5.2452004874E+00, 6.8824802379E+00, 2.6221527492E+00, 9.1963584094E-01],
	[2.9805000000E+04, 2.2023267345E+01, 5.2451911570E+00, 6.8862169931E+00, 2.6227791233E+00, 9.1967455583E-01],
	[2.9810000000E+04, 2.2029364632E+01, 5.2451818283E+00, 6.8899551489E+00, 2.6234053732E+00, 9.1971325126E-01],
	[2.9815000000E+04, 2.2035462584E+01, 5.2451725011E+00, 6.8936947055E+00, 2.6240314987E+00, 9.1975192725E-01],
	[2.9820000000E+04, 2.2041561201E+01, 5.2451631755E+00, 6.8974356633E+00, 2.6246574998E+00, 9.1979058381E-01],
	[2.9825000000E+04, 2.2047660483E+01, 5.2451538514E+00, 6.9011780225E+00, 2.6252833766E+00, 9.1982922095E-01],
	[2.9830000000E+04, 2.2053760429E+01, 5.2451445290E+00, 6.9049217835E+00, 2.6259091290E+00, 9.1986783868E-01],
	[2.9835000000E+04, 2.2059861041E+01, 5.2451352081E+00, 6.9086669465E+00, 2.6265347569E+00, 9.1990643700E-01],
	[2.9840000000E+04, 2.2065962318E+01, 5.2451258888E+00, 6.9124135118E+00, 2.6271602604E+00, 9.1994501593E-01],
	[2.9845000000E+04, 2.2072064259E+01, 5.2451165711E+00, 6.9161614798E+00, 2.6277856394E+00, 9.1998357547E-01],
	[2.9850000000E+04, 2.2078166865E+01, 5.2451072550E+00, 6.9199108506E+00, 2.6284108939E+00, 9.2002211564E-01],
	[2.9855000000E+04, 2.2084270136E+01, 5.2450979404E+00, 6.9236616246E+00, 2.6290360238E+00, 9.2006063644E-01],
	[2.9860000000E+04, 2.2090374072E+01, 5.2450886274E+00, 6.9274138021E+00, 2.6296610291E+00, 9.2009913788E-01],
	[2.9865000000E+04, 2.2096478672E+01, 5.2450793160E+00, 6.9311673833E+00, 2.6302859099E+00, 9.2013761997E-01],
	[2.9870000000E+04, 2.2102583937E+01, 5.2450700062E+00, 6.9349223686E+00, 2.6309106659E+00, 9.2017608272E-01],
	[2.9875000000E+04, 2.2108689866E+01, 5.2450606979E+00, 6.9386787583E+00, 2.6315352973E+00, 9.2021452615E-01],
	[2.9880000000E+04, 2.2114796460E+01, 5.2450513912E+00, 6.9424365525E+00, 2.6321598040E+00, 9.2025295025E-01],
	[2.9885000000E+04, 2.2120903719E+01, 5.2450420861E+00, 6.9461957517E+00, 2.6327841860E+00, 9.2029135504E-01],
	[2.9890000000E+04, 2.2127011642E+01, 5.2450327826E+00, 6.9499563561E+00, 2.6334084432E+00, 9.2032974053E-01],
	[2.9895000000E+04, 2.2133120229E+01, 5.2450234806E+00, 6.9537183660E+00, 2.6340325756E+00, 9.2036810672E-01],
	[2.9900000000E+04, 2.2139229481E+01, 5.2450141802E+00, 6.9574817817E+00, 2.6346565832E+00, 9.2040645363E-01],
	[2.9905000000E+04, 2.2145339397E+01, 5.2450048814E+00, 6.9612466035E+00, 2.6352804660E+00, 9.2044478126E-01],
	[2.9910000000E+04, 2.2151460180E+01, 5.2449970361E+00, 6.9650128316E+00, 2.6359047351E+00, 9.2048308963E-01],
	[2.9915000000E+04, 2.2157593628E+01, 5.2449908989E+00, 6.9687804664E+00, 2.6365294806E+00, 9.2052137874E-01],
	[2.9920000000E+04, 2.2163727748E+01, 5.2449847626E+00, 6.9725495082E+00, 2.6371541020E+00, 9.2055964860E-01],
	[2.9925000000E+04, 2.2169862541E+01, 5.2449786275E+00, 6.9763199572E+00, 2.6377785990E+00, 9.2059789923E-01],
	[2.9930000000E+04, 2.2175998007E+01, 5.2449724933E+00, 6.9800918137E+00, 2.6384029718E+00, 9.2063613062E-01],
	[2.9935000000E+04, 2.2182134146E+01, 5.2449663602E+00, 6.9838650780E+00, 2.6390272203E+00, 9.2067434279E-01],
	[2.9940000000E+04, 2.2188270957E+01, 5.2449602281E+00, 6.9876397505E+00, 2.6396513444E+00, 9.2071253576E-01],
	[2.9945000000E+04, 2.2194408441E+01, 5.2449540970E+00, 6.9914158313E+00, 2.6402753441E+00, 9.2075070952E-01],
	[2.9950000000E+04, 2.2200546597E+01, 5.2449479670E+00, 6.9951933208E+00, 2.6408992194E+00, 9.2078886409E-01],
	[2.9955000000E+04, 2.2206685426E+01, 5.2449418380E+00, 6.9989722193E+00, 2.6415229702E+00, 9.2082699947E-01],
	[2.9960000000E+04, 2.2212824927E+01, 5.2449357101E+00, 7.0027525271E+00, 2.6421465966E+00, 9.2086511568E-01],
	[2.9965000000E+04, 2.2218965101E+01, 5.2449295831E+00, 7.0065342444E+00, 2.6427700985E+00, 9.2090321273E-01],
	[2.9970000000E+04, 2.2225105947E+01, 5.2449234572E+00, 7.0103173716E+00, 2.6433934758E+00, 9.2094129062E-01],
	[2.9975000000E+04, 2.2231247465E+01, 5.2449173323E+00, 7.0141019089E+00, 2.6440167286E+00, 9.2097934936E-01],
	[2.9980000000E+04, 2.2237389656E+01, 5.2449112085E+00, 7.0178878566E+00, 2.6446398568E+00, 9.2101738897E-01],
	[2.9985000000E+04, 2.2243532519E+01, 5.2449050857E+00, 7.0216752150E+00, 2.6452628604E+00, 9.2105540945E-01],
	[2.9990000000E+04, 2.2249676055E+01, 5.2448989639E+00, 7.0254639845E+00, 2.6458857394E+00, 9.2109341080E-01],
	[2.9995000000E+04, 2.2255820262E+01, 5.2448928431E+00, 7.0292541652E+00, 2.6465084937E+00, 9.2113139305E-01],
	[3.0000000000E+04, 2.2261965142E+01, 5.2448867234E+00, 7.0330457576E+00, 2.6471311233E+00, 9.2116935620E-01],
	[3.0005000000E+04, 2.2268110694E+01, 5.2448806047E+00, 7.0368617087E+00, 2.6477568770E+00, 9.2120730025E-01],
	[3.0010000000E+04, 2.2274256918E+01, 5.2448744870E+00, 7.0406790931E+00, 2.6483825049E+00, 9.2124522523E-01],
	[3.0015000000E+04, 2.2280403814E+01, 5.2448683703E+00, 7.0444979109E+00, 2.6490080070E+00, 9.2128313113E-01],
	[3.0020000000E+04, 2.2286551382E+01, 5.2448622547E+00, 7.0483181624E+00, 2.6496333834E+00, 9.2132101796E-01],
	[3.0025000000E+04, 2.2292699622E+01, 5.2448561401E+00, 7.0521398480E+00, 2.6502586339E+00, 9.2135888574E-01],
	[3.0030000000E+04, 2.2298848533E+01, 5.2448500265E+00, 7.0559629680E+00, 2.6508837586E+00, 9.2139673448E-01],
	[3.0035000000E+04, 2.2304998117E+01, 5.2448439140E+00, 7.0597875226E+00, 2.6515087573E+00, 9.2143456417E-01],
	[3.0040000000E+04, 2.2311148373E+01, 5.2448378024E+00, 7.0636135121E+00, 2.6521336302E+00, 9.2147237485E-01],
	[3.0045000000E+04, 2.2317299300E+01, 5.2448316919E+00, 7.0674409369E+00, 2.6527583771E+00, 9.2151016650E-01],
	[3.0050000000E+04, 2.2323450900E+01, 5.2448255824E+00, 7.0712697973E+00, 2.6533829980E+00, 9.2154793914E-01],
	[3.0055000000E+04, 2.2329603171E+01, 5.2448194740E+00, 7.0751000935E+00, 2.6540074929E+00, 9.2158569279E-01],
	[3.0060000000E+04, 2.2335756113E+01, 5.2448133665E+00, 7.0789318258E+00, 2.6546318618E+00, 9.2162342744E-01],
	[3.0065000000E+04, 2.2341909728E+01, 5.2448072601E+00, 7.0827649946E+00, 2.6552561046E+00, 9.2166114311E-01],
	[3.0070000000E+04, 2.2348064014E+01, 5.2448011547E+00, 7.0865996001E+00, 2.6558802214E+00, 9.2169883981E-01],
	[3.0075000000E+04, 2.2354218971E+01, 5.2447950504E+00, 7.0904356426E+00, 2.6565042120E+00, 9.2173651755E-01],
	[3.0080000000E+04, 2.2360374601E+01, 5.2447889470E+00, 7.0942731225E+00, 2.6571280765E+00, 9.2177417633E-01],
	[3.0085000000E+04, 2.2366530901E+01, 5.2447828447E+00, 7.0981120400E+00, 2.6577518148E+00, 9.2181181617E-01],
	[3.0090000000E+04, 2.2372687873E+01, 5.2447767434E+00, 7.1019523955E+00, 2.6583754269E+00, 9.2184943707E-01],
	[3.0095000000E+04, 2.2378845517E+01, 5.2447706431E+00, 7.1057941892E+00, 2.6589989128E+00, 9.2188703905E-01],
	[3.0100000000E+04, 2.2385003832E+01, 5.2447645439E+00, 7.1096374214E+00, 2.6596222724E+00, 9.2192462211E-01],
	[3.0105000000E+04, 2.2391162818E+01, 5.2447584456E+00, 7.1134820925E+00, 2.6602455057E+00, 9.2196218626E-01],
	[3.0110000000E+04, 2.2397322476E+01, 5.2447523484E+00, 7.1173282027E+00, 2.6608686128E+00, 9.2199973154E-01],
	[3.0115000000E+04, 2.2403482805E+01, 5.2447462522E+00, 7.1211757523E+00, 2.6614915935E+00, 9.2203725795E-01],
	[3.0120000000E+04, 2.2409643805E+01, 5.2447401570E+00, 7.1250247417E+00, 2.6621144478E+00, 9.2207476552E-01],
	[3.0125000000E+04, 2.2415805477E+01, 5.2447340628E+00, 7.1288751711E+00, 2.6627371757E+00, 9.2211225424E-01],
	[3.0130000000E+04, 2.2421967819E+01, 5.2447279697E+00, 7.1327270408E+00, 2.6633597772E+00, 9.2214972413E-01],
	[3.0135000000E+04, 2.2428130833E+01, 5.2447218776E+00, 7.1365803511E+00, 2.6639822523E+00, 9.2218717518E-01],
	[3.0140000000E+04, 2.2434294518E+01, 5.2447157865E+00, 7.1404351024E+00, 2.6646046009E+00, 9.2222460742E-01],
	[3.0145000000E+04, 2.2440458874E+01, 5.2447096964E+00, 7.1442912949E+00, 2.6652268230E+00, 9.2226202085E-01],
	[3.0150000000E+04, 2.2446623900E+01, 5.2447036073E+00, 7.1481489289E+00, 2.6658489185E+00, 9.2229941547E-01],
	[3.0155000000E+04, 2.2452789598E+01, 5.2446975192E+00, 7.1520080048E+00, 2.6664708875E+00, 9.2233679130E-01],
	[3.0160000000E+04, 2.2458955967E+01, 5.2446914322E+00, 7.1558685228E+00, 2.6670927300E+00, 9.2237414834E-01],
	[3.0165000000E+04, 2.2465123007E+01, 5.2446853462E+00, 7.1597304832E+00, 2.6677144458E+00, 9.2241148661E-01],
	[3.0170000000E+04, 2.2471290717E+01, 5.2446792612E+00, 7.1635938863E+00, 2.6683360349E+00, 9.2244880610E-01],
	[3.0175000000E+04, 2.2477459099E+01, 5.2446731772E+00, 7.1674587324E+00, 2.6689574974E+00, 9.2248610683E-01],
	[3.0180000000E+04, 2.2483628151E+01, 5.2446670942E+00, 7.1713250219E+00, 2.6695788333E+00, 9.2252338880E-01],
	[3.0185000000E+04, 2.2489797874E+01, 5.2446610122E+00, 7.1751927550E+00, 2.6702000424E+00, 9.2256065203E-01],
	[3.0190000000E+04, 2.2495968267E+01, 5.2446549313E+00, 7.1790619320E+00, 2.6708211247E+00, 9.2259789652E-01],
	[3.0195000000E+04, 2.2502139332E+01, 5.2446488513E+00, 7.1829325532E+00, 2.6714420803E+00, 9.2263512228E-01],
	[3.0200000000E+04, 2.2508311067E+01, 5.2446427724E+00, 7.1868046190E+00, 2.6720629091E+00, 9.2267232932E-01],
	[3.0205000000E+04, 2.2514483472E+01, 5.2446366945E+00, 7.1906781295E+00, 2.6726836111E+00, 9.2270951764E-01],
	[3.0210000000E+04, 2.2520656548E+01, 5.2446306176E+00, 7.1945530852E+00, 2.6733041862E+00, 9.2274668726E-01],
	[3.0215000000E+04, 2.2526830295E+01, 5.2446245417E+00, 7.1984294863E+00, 2.6739246344E+00, 9.2278383818E-01],
	[3.0220000000E+04, 2.2533004712E+01, 5.2446184669E+00, 7.2023073331E+00, 2.6745449558E+00, 9.2282097041E-01],
	[3.0225000000E+04, 2.2539179799E+01, 5.2446123930E+00, 7.2061866259E+00, 2.6751651502E+00, 9.2285808396E-01],
	[3.0230000000E+04, 2.2545355557E+01, 5.2446063202E+00, 7.2100673650E+00, 2.6757852176E+00, 9.2289517883E-01],
	[3.0235000000E+04, 2.2551531986E+01, 5.2446002483E+00, 7.2139495508E+00, 2.6764051581E+00, 9.2293225504E-01],
	[3.0240000000E+04, 2.2557709084E+01, 5.2445941775E+00, 7.2178331834E+00, 2.6770249716E+00, 9.2296931260E-01],
	[3.0245000000E+04, 2.2563886853E+01, 5.2445881077E+00, 7.2217182633E+00, 2.6776446580E+00, 9.2300635150E-01],
	[3.0250000000E+04, 2.2570065292E+01, 5.2445820389E+00, 7.2256047907E+00, 2.6782642174E+00, 9.2304337177E-01],
	[3.0255000000E+04, 2.2576244402E+01, 5.2445759711E+00, 7.2294927659E+00, 2.6788836497E+00, 9.2308037340E-01],
	[3.0260000000E+04, 2.2582424181E+01, 5.2445699043E+00, 7.2333821892E+00, 2.6795029549E+00, 9.2311735641E-01],
	[3.0265000000E+04, 2.2588604631E+01, 5.2445638385E+00, 7.2372730609E+00, 2.6801221330E+00, 9.2315432080E-01],
	[3.0270000000E+04, 2.2594785751E+01, 5.2445577738E+00, 7.2411653813E+00, 2.6807411839E+00, 9.2319126658E-01],
	[3.0275000000E+04, 2.2600967541E+01, 5.2445517100E+00, 7.2450591507E+00, 2.6813601076E+00, 9.2322819377E-01],
	[3.0280000000E+04, 2.2607150001E+01, 5.2445456473E+00, 7.2489543695E+00, 2.6819789041E+00, 9.2326510236E-01],
	[3.0285000000E+04, 2.2613333130E+01, 5.2445395855E+00, 7.2528510378E+00, 2.6825975734E+00, 9.2330199237E-01],
	[3.0290000000E+04, 2.2619516930E+01, 5.2445335248E+00, 7.2567491560E+00, 2.6832161154E+00, 9.2333886380E-01],
	[3.0295000000E+04, 2.2625701400E+01, 5.2445274651E+00, 7.2606487245E+00, 2.6838345301E+00, 9.2337571667E-01],
	[3.0300000000E+04, 2.2631886540E+01, 5.2445214063E+00, 7.2645497435E+00, 2.6844528175E+00, 9.2341255098E-01],
	[3.0305000000E+04, 2.2638072349E+01, 5.2445153486E+00, 7.2684522132E+00, 2.6850709776E+00, 9.2344936673E-01],
	[3.0310000000E+04, 2.2644258828E+01, 5.2445092919E+00, 7.2723561341E+00, 2.6856890103E+00, 9.2348616395E-01],
	[3.0315000000E+04, 2.2650445977E+01, 5.2445032362E+00, 7.2762615064E+00, 2.6863069156E+00, 9.2352294263E-01],
	[3.0320000000E+04, 2.2656633796E+01, 5.2444971815E+00, 7.2801683303E+00, 2.6869246935E+00, 9.2355970279E-01],
	[3.0325000000E+04, 2.2662822284E+01, 5.2444911278E+00, 7.2840766063E+00, 2.6875423439E+00, 9.2359644442E-01],
	[3.0330000000E+04, 2.2669011442E+01, 5.2444850752E+00, 7.2879863346E+00, 2.6881598669E+00, 9.2363316755E-01],
	[3.0335000000E+04, 2.2675201270E+01, 5.2444790235E+00, 7.2918975155E+00, 2.6887772625E+00, 9.2366987218E-01],
	[3.0340000000E+04, 2.2681391767E+01, 5.2444729728E+00, 7.2958101493E+00, 2.6893945305E+00, 9.2370655831E-01],
	[3.0345000000E+04, 2.2687582934E+01, 5.2444669231E+00, 7.2997242362E+00, 2.6900116709E+00, 9.2374322596E-01],
	[3.0350000000E+04, 2.2693774770E+01, 5.2444608745E+00, 7.3036397767E+00, 2.6906286838E+00, 9.2377987513E-01],
	[3.0355000000E+04, 2.2699967276E+01, 5.2444548268E+00, 7.3075567710E+00, 2.6912455692E+00, 9.2381650583E-01],
	[3.0360000000E+04, 2.2706160451E+01, 5.2444487801E+00, 7.3114752194E+00, 2.6918623269E+00, 9.2385311807E-01],
	[3.0365000000E+04, 2.2712354296E+01, 5.2444427345E+00, 7.3153951222E+00, 2.6924789570E+00, 9.2388971186E-01],
	[3.0370000000E+04, 2.2718548809E+01, 5.2444366898E+00, 7.3193164797E+00, 2.6930954594E+00, 9.2392628721E-01],
	[3.0375000000E+04, 2.2724743992E+01, 5.2444306462E+00, 7.3232392922E+00, 2.6937118341E+00, 9.2396284412E-01],
	[3.0380000000E+04, 2.2730939845E+01, 5.2444246035E+00, 7.3271635600E+00, 2.6943280811E+00, 9.2399938260E-01],
	[3.0385000000E+04, 2.2737136366E+01, 5.2444185619E+00, 7.3310892834E+00, 2.6949442004E+00, 9.2403590266E-01],
	[3.0390000000E+04, 2.2743337189E+01, 5.2444130325E+00, 7.3350164626E+00, 2.6955603780E+00, 9.2407240432E-01],
	[3.0395000000E+04, 2.2749557066E+01, 5.2444100912E+00, 7.3389450981E+00, 2.6961773700E+00, 9.2410888756E-01],
	[3.0400000000E+04, 2.2755777620E+01, 5.2444071504E+00, 7.3428751901E+00, 2.6967942349E+00, 9.2414535242E-01],
	[3.0405000000E+04, 2.2761998852E+01, 5.2444042101E+00, 7.3468067389E+00, 2.6974109726E+00, 9.2418179889E-01],
	[3.0410000000E+04, 2.2768220761E+01, 5.2444012703E+00, 7.3507397448E+00, 2.6980275831E+00, 9.2421822698E-01],
	[3.0415000000E+04, 2.2774443348E+01, 5.2443983309E+00, 7.3546742080E+00, 2.6986440664E+00, 9.2425463670E-01],
	[3.0420000000E+04, 2.2780666611E+01, 5.2443953921E+00, 7.3586101290E+00, 2.6992604225E+00, 9.2429102806E-01],
	[3.0425000000E+04, 2.2786890553E+01, 5.2443924537E+00, 7.3625475080E+00, 2.6998766514E+00, 9.2432740106E-01],
	[3.0430000000E+04, 2.2793115171E+01, 5.2443895158E+00, 7.3664863452E+00, 2.7004927530E+00, 9.2436375572E-01],
	[3.0435000000E+04, 2.2799340467E+01, 5.2443865784E+00, 7.3704266411E+00, 2.7011087273E+00, 9.2440009205E-01],
	[3.0440000000E+04, 2.2805566440E+01, 5.2443836415E+00, 7.3743683959E+00, 2.7017245743E+00, 9.2443641004E-01],
	[3.0445000000E+04, 2.2811793090E+01, 5.2443807051E+00, 7.3783116098E+00, 2.7023402939E+00, 9.2447270972E-01],
	[3.0450000000E+04, 2.2818020417E+01, 5.2443777691E+00, 7.3822562833E+00, 2.7029558862E+00, 9.2450899108E-01],
	[3.0455000000E+04, 2.2824248422E+01, 5.2443748337E+00, 7.3862024165E+00, 2.7035713511E+00, 9.2454525414E-01],
	[3.0460000000E+04, 2.2830477103E+01, 5.2443718987E+00, 7.3901500099E+00, 2.7041866886E+00, 9.2458149890E-01],
	[3.0465000000E+04, 2.2836706462E+01, 5.2443689642E+00, 7.3940990636E+00, 2.7048018986E+00, 9.2461772538E-01],
	[3.0470000000E+04, 2.2842936497E+01, 5.2443660302E+00, 7.3980495780E+00, 2.7054169812E+00, 9.2465393358E-01],
	[3.0475000000E+04, 2.2849167209E+01, 5.2443630966E+00, 7.4020015535E+00, 2.7060319363E+00, 9.2469012350E-01],
	[3.0480000000E+04, 2.2855398599E+01, 5.2443601636E+00, 7.4059549902E+00, 2.7066467639E+00, 9.2472629517E-01],
	[3.0485000000E+04, 2.2861630665E+01, 5.2443572310E+00, 7.4099098885E+00, 2.7072614640E+00, 9.2476244857E-01],
	[3.0490000000E+04, 2.2867863408E+01, 5.2443542989E+00, 7.4138662487E+00, 2.7078760365E+00, 9.2479858374E-01],
	[3.0495000000E+04, 2.2874096828E+01, 5.2443513673E+00, 7.4178240711E+00, 2.7084904815E+00, 9.2483470066E-01],
	[3.0500000000E+04, 2.2880330924E+01, 5.2443484362E+00, 7.4217833561E+00, 2.7091047988E+00, 9.2487079936E-01],
	[3.0505000000E+04, 2.2886565698E+01, 5.2443455056E+00, 7.4257441038E+00, 2.7097189885E+00, 9.2490687983E-01],
	[3.0510000000E+04, 2.2892801147E+01, 5.2443425754E+00, 7.4297063146E+00, 2.7103330506E+00, 9.2494294210E-01],
	[3.0515000000E+04, 2.2899037274E+01, 5.2443396458E+00, 7.4336699888E+00, 2.7109469851E+00, 9.2497898615E-01],
	[3.0520000000E+04, 2.2905274077E+01, 5.2443367166E+00, 7.4376351267E+00, 2.7115607918E+00, 9.2501501201E-01],
	[3.0525000000E+04, 2.2911511557E+01, 5.2443337879E+00, 7.4416017285E+00, 2.7121744708E+00, 9.2505101969E-01],
	[3.0530000000E+04, 2.2917749713E+01, 5.2443308596E+00, 7.4455697947E+00, 2.7127880221E+00, 9.2508700918E-01],
	[3.0535000000E+04, 2.2923988546E+01, 5.2443279319E+00, 7.4495393255E+00, 2.7134014456E+00, 9.2512298050E-01],
	[3.0540000000E+04, 2.2930228055E+01, 5.2443250046E+00, 7.4535103212E+00, 2.7140147414E+00, 9.2515893366E-01],
	[3.0545000000E+04, 2.2936468241E+01, 5.2443220778E+00, 7.4574827821E+00, 2.7146279093E+00, 9.2519486867E-01],
	[3.0550000000E+04, 2.2942709103E+01, 5.2443191515E+00, 7.4614567084E+00, 2.7152409495E+00, 9.2523078552E-01],
	[3.0555000000E+04, 2.2948950642E+01, 5.2443162257E+00, 7.4654321006E+00, 2.7158538617E+00, 9.2526668424E-01],
	[3.0560000000E+04, 2.2955192856E+01, 5.2443133003E+00, 7.4694089589E+00, 2.7164666461E+00, 9.2530256483E-01],
	[3.0565000000E+04, 2.2961435747E+01, 5.2443103755E+00, 7.4733872835E+00, 2.7170793027E+00, 9.2533842730E-01],
	[3.0570000000E+04, 2.2967679315E+01, 5.2443074511E+00, 7.4773670749E+00, 2.7176918313E+00, 9.2537427165E-01],
	[3.0575000000E+04, 2.2973923558E+01, 5.2443045272E+00, 7.4813483332E+00, 2.7183042319E+00, 9.2541009790E-01],
	[3.0580000000E+04, 2.2980168478E+01, 5.2443016038E+00, 7.4853310589E+00, 2.7189165047E+00, 9.2544590605E-01],
	[3.0585000000E+04, 2.2986414073E+01, 5.2442986808E+00, 7.4893152521E+00, 2.7195286494E+00, 9.2548169611E-01],
	[3.0590000000E+04, 2.2992660345E+01, 5.2442957584E+00, 7.4933009133E+00, 2.7201406661E+00, 9.2551746810E-01],
	[3.0595000000E+04, 2.2998907293E+01, 5.2442928364E+00, 7.4972880426E+00, 2.7207525548E+00, 9.2555322201E-01],
	[3.0600000000E+04, 2.3005154917E+01, 5.2442899149E+00, 7.5012766404E+00, 2.7213643155E+00, 9.2558895786E-01],
	[3.0605000000E+04, 2.3011403217E+01, 5.2442869938E+00, 7.5052667071E+00, 2.7219759481E+00, 9.2562467565E-01],
	[3.0610000000E+04, 2.3017652192E+01, 5.2442840733E+00, 7.5092582428E+00, 2.7225874526E+00, 9.2566037539E-01],
	[3.0615000000E+04, 2.3023901844E+01, 5.2442811532E+00, 7.5132512480E+00, 2.7231988290E+00, 9.2569605710E-01],
	[3.0620000000E+04, 2.3030152172E+01, 5.2442782336E+00, 7.5172457228E+00, 2.7238100773E+00, 9.2573172078E-01],
	[3.0625000000E+04, 2.3036403175E+01, 5.2442753145E+00, 7.5212416676E+00, 2.7244211974E+00, 9.2576736643E-01],
	[3.0630000000E+04, 2.3042654854E+01, 5.2442723959E+00, 7.5252390828E+00, 2.7250321893E+00, 9.2580299407E-01],
	[3.0635000000E+04, 2.3048907209E+01, 5.2442694777E+00, 7.5292379685E+00, 2.7256430531E+00, 9.2583860371E-01],
	[3.0640000000E+04, 2.3055160240E+01, 5.2442665600E+00, 7.5332383251E+00, 2.7262537886E+00, 9.2587419535E-01],
	[3.0645000000E+04, 2.3061413946E+01, 5.2442636428E+00, 7.5372401530E+00, 2.7268643959E+00, 9.2590976900E-01],
	[3.0650000000E+04, 2.3067668328E+01, 5.2442607261E+00, 7.5412434523E+00, 2.7274748749E+00, 9.2594532466E-01],
	[3.0655000000E+04, 2.3073923385E+01, 5.2442578099E+00, 7.5452482234E+00, 2.7280852256E+00, 9.2598086236E-01],
	[3.0660000000E+04, 2.3080179118E+01, 5.2442548941E+00, 7.5492544667E+00, 2.7286954481E+00, 9.2601638209E-01],
	[3.0665000000E+04, 2.3086435527E+01, 5.2442519788E+00, 7.5532621823E+00, 2.7293055422E+00, 9.2605188387E-01],
	[3.0670000000E+04, 2.3092692611E+01, 5.2442490640E+00, 7.5572713707E+00, 2.7299155080E+00, 9.2608736770E-01],
	[3.0675000000E+04, 2.3098950371E+01, 5.2442461497E+00, 7.5612820320E+00, 2.7305253454E+00, 9.2612283359E-01],
	[3.0680000000E+04, 2.3105208806E+01, 5.2442432358E+00, 7.5652941667E+00, 2.7311350544E+00, 9.2615828156E-01],
	[3.0685000000E+04, 2.3111467916E+01, 5.2442403224E+00, 7.5693077749E+00, 2.7317446350E+00, 9.2619371160E-01],
	[3.0690000000E+04, 2.3117727702E+01, 5.2442374095E+00, 7.5733228571E+00, 2.7323540872E+00, 9.2622912372E-01],
	[3.0695000000E+04, 2.3123988163E+01, 5.2442344971E+00, 7.5773394134E+00, 2.7329634109E+00, 9.2626451794E-01],
	[3.0700000000E+04, 2.3130249299E+01, 5.2442315851E+00, 7.5813574443E+00, 2.7335726062E+00, 9.2629989426E-01],
	[3.0705000000E+04, 2.3136511110E+01, 5.2442286736E+00, 7.5853769500E+00, 2.7341816730E+00, 9.2633525270E-01],
	[3.0710000000E+04, 2.3142773597E+01, 5.2442257626E+00, 7.5893979308E+00, 2.7347906112E+00, 9.2637059325E-01],
	[3.0715000000E+04, 2.3149036759E+01, 5.2442228521E+00, 7.5934203870E+00, 2.7353994209E+00, 9.2640591593E-01],
	[3.0720000000E+04, 2.3155300596E+01, 5.2442199420E+00, 7.5974443189E+00, 2.7360081021E+00, 9.2644122075E-01],
	[3.0725000000E+04, 2.3161565108E+01, 5.2442170324E+00, 7.6014697268E+00, 2.7366166547E+00, 9.2647650771E-01],
	[3.0730000000E+04, 2.3167830295E+01, 5.2442141233E+00, 7.6054966110E+00, 2.7372250787E+00, 9.2651177683E-01],
	[3.0735000000E+04, 2.3174096157E+01, 5.2442112147E+00, 7.6095249718E+00, 2.7378333741E+00, 9.2654702811E-01],
	[3.0740000000E+04, 2.3180362694E+01, 5.2442083066E+00, 7.6135548095E+00, 2.7384415409E+00, 9.2658226155E-01],
	[3.0745000000E+04, 2.3186629906E+01, 5.2442053989E+00, 7.6175861245E+00, 2.7390495790E+00, 9.2661747718E-01],
	[3.0750000000E+04, 2.3192897793E+01, 5.2442024917E+00, 7.6216189169E+00, 2.7396574885E+00, 9.2665267499E-01],
	[3.0755000000E+04, 2.3199166354E+01, 5.2441995849E+00, 7.6256531872E+00, 2.7402652692E+00, 9.2668785499E-01],
	[3.0760000000E+04, 2.3205435591E+01, 5.2441966787E+00, 7.6296889355E+00, 2.7408729213E+00, 9.2672301720E-01],
	[3.0765000000E+04, 2.3211705502E+01, 5.2441937729E+00, 7.6337261623E+00, 2.7414804446E+00, 9.2675816162E-01],
	[3.0770000000E+04, 2.3217976088E+01, 5.2441908676E+00, 7.6377648678E+00, 2.7420878391E+00, 9.2679328826E-01],
	[3.0775000000E+04, 2.3224247349E+01, 5.2441879628E+00, 7.6418050523E+00, 2.7426951049E+00, 9.2682839713E-01],
	[3.0780000000E+04, 2.3230519284E+01, 5.2441850584E+00, 7.6458467162E+00, 2.7433022419E+00, 9.2686348823E-01],
	[3.0785000000E+04, 2.3236791894E+01, 5.2441821545E+00, 7.6498898596E+00, 2.7439092500E+00, 9.2689856158E-01],
	[3.0790000000E+04, 2.3243065179E+01, 5.2441792511E+00, 7.6539344830E+00, 2.7445161294E+00, 9.2693361718E-01],
	[3.0795000000E+04, 2.3249339138E+01, 5.2441763481E+00, 7.6579805866E+00, 2.7451228798E+00, 9.2696865504E-01],
	[3.0800000000E+04, 2.3255613772E+01, 5.2441734457E+00, 7.6620281706E+00, 2.7457295015E+00, 9.2700367518E-01],
	[3.0805000000E+04, 2.3261889080E+01, 5.2441705437E+00, 7.6660772356E+00, 2.7463359942E+00, 9.2703867759E-01],
	[3.0810000000E+04, 2.3268165063E+01, 5.2441676421E+00, 7.6701277816E+00, 2.7469423580E+00, 9.2707366229E-01],
	[3.0815000000E+04, 2.3274441720E+01, 5.2441647411E+00, 7.6741798090E+00, 2.7475485929E+00, 9.2710862928E-01],
	[3.0820000000E+04, 2.3280719052E+01, 5.2441618405E+00, 7.6782333182E+00, 2.7481546988E+00, 9.2714357858E-01],
	[3.0825000000E+04, 2.3286997057E+01, 5.2441589404E+00, 7.6822883094E+00, 2.7487606758E+00, 9.2717851018E-01],
	[3.0830000000E+04, 2.3293275738E+01, 5.2441560408E+00, 7.6863447829E+00, 2.7493665237E+00, 9.2721342411E-01],
	[3.0835000000E+04, 2.3299555092E+01, 5.2441531416E+00, 7.6904027391E+00, 2.7499722427E+00, 9.2724832037E-01],
	[3.0840000000E+04, 2.3305835121E+01, 5.2441502429E+00, 7.6944621781E+00, 2.7505778327E+00, 9.2728319896E-01],
	[3.0845000000E+04, 2.3312115823E+01, 5.2441473447E+00, 7.6985231004E+00, 2.7511832936E+00, 9.2731805990E-01],
	[3.0850000000E+04, 2.3318397200E+01, 5.2441444469E+00, 7.7025855062E+00, 2.7517886254E+00, 9.2735290319E-01],
	[3.0855000000E+04, 2.3324679251E+01, 5.2441415497E+00, 7.7066493958E+00, 2.7523938282E+00, 9.2738772884E-01],
	[3.0860000000E+04, 2.3330961977E+01, 5.2441386529E+00, 7.7107147696E+00, 2.7529989018E+00, 9.2742253687E-01],
	[3.0865000000E+04, 2.3337245376E+01, 5.2441357565E+00, 7.7147816278E+00, 2.7536038463E+00, 9.2745732727E-01],
	[3.0870000000E+04, 2.3343529449E+01, 5.2441328607E+00, 7.7188499707E+00, 2.7542086617E+00, 9.2749210006E-01],
	[3.0875000000E+04, 2.3349814196E+01, 5.2441299653E+00, 7.7229197987E+00, 2.7548133480E+00, 9.2752685524E-01],
	[3.0880000000E+04, 2.3356106598E+01, 5.2441280428E+00, 7.7269911119E+00, 2.7554182707E+00, 9.2756159283E-01],
	[3.0885000000E+04, 2.3362414505E+01, 5.2441281856E+00, 7.7310639108E+00, 2.7560238411E+00, 9.2759631283E-01],
	[3.0890000000E+04, 2.3368723095E+01, 5.2441283285E+00, 7.7351381957E+00, 2.7566292830E+00, 9.2763101525E-01],
	[3.0895000000E+04, 2.3375032366E+01, 5.2441284713E+00, 7.7392139668E+00, 2.7572345962E+00, 9.2766570010E-01],
	[3.0900000000E+04, 2.3381342319E+01, 5.2441286141E+00, 7.7432912244E+00, 2.7578397809E+00, 9.2770036739E-01],
	[3.0905000000E+04, 2.3387652954E+01, 5.2441287568E+00, 7.7473699688E+00, 2.7584448370E+00, 9.2773501712E-01],
	[3.0910000000E+04, 2.3393964272E+01, 5.2441288996E+00, 7.7514502004E+00, 2.7590497645E+00, 9.2776964931E-01],
	[3.0915000000E+04, 2.3400276271E+01, 5.2441290423E+00, 7.7555319194E+00, 2.7596545633E+00, 9.2780426396E-01],
	[3.0920000000E+04, 2.3406588952E+01, 5.2441291850E+00, 7.7596151262E+00, 2.7602592334E+00, 9.2783886108E-01],
	[3.0925000000E+04, 2.3412902315E+01, 5.2441293277E+00, 7.7636998210E+00, 2.7608637748E+00, 9.2787344068E-01],
	[3.0930000000E+04, 2.3419216359E+01, 5.2441294703E+00, 7.7677860041E+00, 2.7614681875E+00, 9.2790800276E-01],
	[3.0935000000E+04, 2.3425531086E+01, 5.2441296130E+00, 7.7718736759E+00, 2.7620724715E+00, 9.2794254734E-01],
	[3.0940000000E+04, 2.3431846494E+01, 5.2441297556E+00, 7.7759628366E+00, 2.7626766268E+00, 9.2797707443E-01],
	[3.0945000000E+04, 2.3438162584E+01, 5.2441298982E+00, 7.7800534866E+00, 2.7632806533E+00, 9.2801158403E-01],
	[3.0950000000E+04, 2.3444479355E+01, 5.2441300407E+00, 7.7841456261E+00, 2.7638845510E+00, 9.2804607615E-01],
	[3.0955000000E+04, 2.3450796808E+01, 5.2441301833E+00, 7.7882392554E+00, 2.7644883200E+00, 9.2808055080E-01],
	[3.0960000000E+04, 2.3457114943E+01, 5.2441303258E+00, 7.7923343749E+00, 2.7650919601E+00, 9.2811500798E-01],
	[3.0965000000E+04, 2.3463433759E+01, 5.2441304683E+00, 7.7964309849E+00, 2.7656954713E+00, 9.2814944772E-01],
	[3.0970000000E+04, 2.3469753257E+01, 5.2441306107E+00, 7.8005290856E+00, 2.7662988538E+00, 9.2818387000E-01],
	[3.0975000000E+04, 2.3476073436E+01, 5.2441307532E+00, 7.8046286773E+00, 2.7669021073E+00, 9.2821827485E-01],
	[3.0980000000E+04, 2.3482394296E+01, 5.2441308956E+00, 7.8087297604E+00, 2.7675052320E+00, 9.2825266228E-01],
	[3.0985000000E+04, 2.3488715838E+01, 5.2441310380E+00, 7.8128323352E+00, 2.7681082278E+00, 9.2828703228E-01],
	[3.0990000000E+04, 2.3495038061E+01, 5.2441311804E+00, 7.8169364019E+00, 2.7687110946E+00, 9.2832138487E-01],
	[3.0995000000E+04, 2.3501360966E+01, 5.2441313227E+00, 7.8210419608E+00, 2.7693138325E+00, 9.2835572005E-01],
	[3.1000000000E+04, 2.3507684552E+01, 5.2441314651E+00, 7.8251490124E+00, 2.7699164414E+00, 9.2839003784E-01],
	[3.1005000000E+04, 2.3514008819E+01, 5.2441316074E+00, 7.8292575567E+00, 2.7705189214E+00, 9.2842433825E-01],
	[3.1010000000E+04, 2.3520333767E+01, 5.2441317497E+00, 7.8333675943E+00, 2.7711212724E+00, 9.2845862127E-01],
	[3.1015000000E+04, 2.3526659397E+01, 5.2441318919E+00, 7.8374791252E+00, 2.7717234944E+00, 9.2849288693E-01],
	[3.1020000000E+04, 2.3532985708E+01, 5.2441320342E+00, 7.8415921500E+00, 2.7723255873E+00, 9.2852713522E-01],
	[3.1025000000E+04, 2.3539312699E+01, 5.2441321764E+00, 7.8457066688E+00, 2.7729275512E+00, 9.2856136616E-01],
	[3.1030000000E+04, 2.3545640372E+01, 5.2441323186E+00, 7.8498226820E+00, 2.7735293861E+00, 9.2859557976E-01],
	[3.1035000000E+04, 2.3551968726E+01, 5.2441324607E+00, 7.8539401898E+00, 2.7741310918E+00, 9.2862977602E-01],
	[3.1040000000E+04, 2.3558297761E+01, 5.2441326029E+00, 7.8580591926E+00, 2.7747326685E+00, 9.2866395495E-01],
	[3.1045000000E+04, 2.3564627477E+01, 5.2441327450E+00, 7.8621796907E+00, 2.7753341160E+00, 9.2869811656E-01],
	[3.1050000000E+04, 2.3570957873E+01, 5.2441328871E+00, 7.8663016843E+00, 2.7759354345E+00, 9.2873226086E-01],
	[3.1055000000E+04, 2.3577288951E+01, 5.2441330292E+00, 7.8704251739E+00, 2.7765366237E+00, 9.2876638786E-01],
	[3.1060000000E+04, 2.3583620709E+01, 5.2441331712E+00, 7.8745501595E+00, 2.7771376839E+00, 9.2880049756E-01],
	[3.1065000000E+04, 2.3589953149E+01, 5.2441333133E+00, 7.8786766417E+00, 2.7777386148E+00, 9.2883458998E-01],
	[3.1070000000E+04, 2.3596286269E+01, 5.2441334553E+00, 7.8828046206E+00, 2.7783394165E+00, 9.2886866512E-01],
	[3.1075000000E+04, 2.3602620069E+01, 5.2441335973E+00, 7.8869340966E+00, 2.7789400891E+00, 9.2890272299E-01],
	[3.1080000000E+04, 2.3608954551E+01, 5.2441337392E+00, 7.8910650700E+00, 2.7795406324E+00, 9.2893676359E-01],
	[3.1085000000E+04, 2.3615289713E+01, 5.2441338812E+00, 7.8951975411E+00, 2.7801410464E+00, 9.2897078695E-01],
	[3.1090000000E+04, 2.3621625556E+01, 5.2441340231E+00, 7.8993315101E+00, 2.7807413312E+00, 9.2900479306E-01],
	[3.1095000000E+04, 2.3627962079E+01, 5.2441341650E+00, 7.9034669774E+00, 2.7813414867E+00, 9.2903878194E-01],
	[3.1100000000E+04, 2.3634299283E+01, 5.2441343069E+00, 7.9076039433E+00, 2.7819415129E+00, 9.2907275359E-01],
	[3.1105000000E+04, 2.3640637167E+01, 5.2441344487E+00, 7.9117424081E+00, 2.7825414098E+00, 9.2910670802E-01],
	[3.1110000000E+04, 2.3646975732E+01, 5.2441345906E+00, 7.9158823721E+00, 2.7831411774E+00, 9.2914064524E-01],
	[3.1115000000E+04, 2.3653314977E+01, 5.2441347324E+00, 7.9200238356E+00, 2.7837408156E+00, 9.2917456525E-01],
	[3.1120000000E+04, 2.3659654903E+01, 5.2441348741E+00, 7.9241667988E+00, 2.7843403244E+00, 9.2920846808E-01],
	[3.1125000000E+04, 2.3665995509E+01, 5.2441350159E+00, 7.9283112622E+00, 2.7849397039E+00, 9.2924235372E-01],
	[3.1130000000E+04, 2.3672336796E+01, 5.2441351576E+00, 7.9324572259E+00, 2.7855389540E+00, 9.2927622218E-01],
	[3.1135000000E+04, 2.3678678762E+01, 5.2441352993E+00, 7.9366046903E+00, 2.7861380747E+00, 9.2931007347E-01],
	[3.1140000000E+04, 2.3685021409E+01, 5.2441354410E+00, 7.9407536557E+00, 2.7867370660E+00, 9.2934390760E-01],
	[3.1145000000E+04, 2.3691364737E+01, 5.2441355827E+00, 7.9449041224E+00, 2.7873359278E+00, 9.2937772458E-01],
	[3.1150000000E+04, 2.3697708744E+01, 5.2441357244E+00, 7.9490560907E+00, 2.7879346601E+00, 9.2941152442E-01],
	[3.1155000000E+04, 2.3704053431E+01, 5.2441358660E+00, 7.9532095609E+00, 2.7885332630E+00, 9.2944530712E-01],
	[3.1160000000E+04, 2.3710398799E+01, 5.2441360076E+00, 7.9573645334E+00, 2.7891317364E+00, 9.2947907269E-01],
	[3.1165000000E+04, 2.3716744847E+01, 5.2441361492E+00, 7.9615210083E+00, 2.7897300803E+00, 9.2951282115E-01],
	[3.1170000000E+04, 2.3723091575E+01, 5.2441362907E+00, 7.9656789860E+00, 2.7903282946E+00, 9.2954655250E-01],
	[3.1175000000E+04, 2.3729438982E+01, 5.2441364322E+00, 7.9698384668E+00, 2.7909263795E+00, 9.2958026674E-01],
	[3.1180000000E+04, 2.3735787070E+01, 5.2441365738E+00, 7.9739994510E+00, 2.7915243348E+00, 9.2961396389E-01],
	[3.1185000000E+04, 2.3742135838E+01, 5.2441367152E+00, 7.9781619390E+00, 2.7921221605E+00, 9.2964764396E-01],
	[3.1190000000E+04, 2.3748485286E+01, 5.2441368567E+00, 7.9823259309E+00, 2.7927198566E+00, 9.2968130695E-01],
	[3.1195000000E+04, 2.3754835413E+01, 5.2441369981E+00, 7.9864914272E+00, 2.7933174231E+00, 9.2971495288E-01],
	[3.1200000000E+04, 2.3761186220E+01, 5.2441371396E+00, 7.9906584280E+00, 2.7939148600E+00, 9.2974858174E-01],
	[3.1205000000E+04, 2.3767537707E+01, 5.2441372810E+00, 7.9948269338E+00, 2.7945121673E+00, 9.2978219355E-01],
	[3.1210000000E+04, 2.3773889874E+01, 5.2441374223E+00, 7.9989969448E+00, 2.7951093450E+00, 9.2981578832E-01],
	[3.1215000000E+04, 2.3780242721E+01, 5.2441375637E+00, 8.0031684614E+00, 2.7957063929E+00, 9.2984936606E-01],
	[3.1220000000E+04, 2.3786596247E+01, 5.2441377050E+00, 8.0073414837E+00, 2.7963033113E+00, 9.2988292677E-01],
	[3.1225000000E+04, 2.3792950453E+01, 5.2441378463E+00, 8.0115160122E+00, 2.7969000999E+00, 9.2991647046E-01],
	[3.1230000000E+04, 2.3799305339E+01, 5.2441379876E+00, 8.0156920471E+00, 2.7974967588E+00, 9.2994999714E-01],
	[3.1235000000E+04, 2.3805660904E+01, 5.2441381289E+00, 8.0198695887E+00, 2.7980932880E+00, 9.2998350683E-01],
	[3.1240000000E+04, 2.3812017148E+01, 5.2441382701E+00, 8.0240486373E+00, 2.7986896874E+00, 9.3001699952E-01],
	[3.1245000000E+04, 2.3818374072E+01, 5.2441384113E+00, 8.0282291933E+00, 2.7992859571E+00, 9.3005047522E-01],
	[3.1250000000E+04, 2.3824731676E+01, 5.2441385525E+00, 8.0324112569E+00, 2.7998820971E+00, 9.3008393395E-01],
	[3.1255000000E+04, 2.3831089959E+01, 5.2441386937E+00, 8.0365948284E+00, 2.8004781073E+00, 9.3011737571E-01],
	[3.1260000000E+04, 2.3837448921E+01, 5.2441388348E+00, 8.0407799082E+00, 2.8010739876E+00, 9.3015080052E-01],
	[3.1265000000E+04, 2.3843808563E+01, 5.2441389759E+00, 8.0449664965E+00, 2.8016697382E+00, 9.3018420837E-01],
	[3.1270000000E+04, 2.3850168884E+01, 5.2441391170E+00, 8.0491545937E+00, 2.8022653589E+00, 9.3021759928E-01],
	[3.1275000000E+04, 2.3856529885E+01, 5.2441392581E+00, 8.0533442000E+00, 2.8028608498E+00, 9.3025097326E-01],
	[3.1280000000E+04, 2.3862891564E+01, 5.2441393992E+00, 8.0575353157E+00, 2.8034562109E+00, 9.3028433032E-01],
	[3.1285000000E+04, 2.3869253923E+01, 5.2441395402E+00, 8.0617279412E+00, 2.8040514421E+00, 9.3031767045E-01],
	[3.1290000000E+04, 2.3875616961E+01, 5.2441396812E+00, 8.0659220767E+00, 2.8046465434E+00, 9.3035099368E-01],
	[3.1295000000E+04, 2.3881980678E+01, 5.2441398222E+00, 8.0701177226E+00, 2.8052415148E+00, 9.3038430001E-01],
	[3.1300000000E+04, 2.3888345075E+01, 5.2441399632E+00, 8.0743148791E+00, 2.8058363563E+00, 9.3041758944E-01],
	[3.1305000000E+04, 2.3894710150E+01, 5.2441401041E+00, 8.0785135465E+00, 2.8064310678E+00, 9.3045086200E-01],
	[3.1310000000E+04, 2.3901075904E+01, 5.2441402451E+00, 8.0827137253E+00, 2.8070256495E+00, 9.3048411767E-01],
	[3.1315000000E+04, 2.3907442338E+01, 5.2441403860E+00, 8.0869154155E+00, 2.8076201011E+00, 9.3051735648E-01],
	[3.1320000000E+04, 2.3913809450E+01, 5.2441405268E+00, 8.0911186177E+00, 2.8082144228E+00, 9.3055057844E-01],
	[3.1325000000E+04, 2.3920177241E+01, 5.2441406677E+00, 8.0953233320E+00, 2.8088086146E+00, 9.3058378354E-01],
	[3.1330000000E+04, 2.3926545711E+01, 5.2441408085E+00, 8.0995295587E+00, 2.8094026763E+00, 9.3061697180E-01],
	[3.1335000000E+04, 2.3932914860E+01, 5.2441409493E+00, 8.1037372982E+00, 2.8099966080E+00, 9.3065014323E-01],
	[3.1340000000E+04, 2.3939284688E+01, 5.2441410901E+00, 8.1079465508E+00, 2.8105904097E+00, 9.3068329784E-01],
	[3.1345000000E+04, 2.3945655195E+01, 5.2441412309E+00, 8.1121573168E+00, 2.8111840814E+00, 9.3071643563E-01],
	[3.1350000000E+04, 2.3952026380E+01, 5.2441413716E+00, 8.1163695964E+00, 2.8117776230E+00, 9.3074955661E-01],
	[3.1355000000E+04, 2.3958398244E+01, 5.2441415123E+00, 8.1205833900E+00, 2.8123710346E+00, 9.3078266079E-01],
	[3.1360000000E+04, 2.3964770787E+01, 5.2441416530E+00, 8.1247986979E+00, 2.8129643161E+00, 9.3081574818E-01],
	[3.1365000000E+04, 2.3971144008E+01, 5.2441417937E+00, 8.1290155203E+00, 2.8135574675E+00, 9.3084881878E-01],
	[3.1370000000E+04, 2.3977517908E+01, 5.2441419344E+00, 8.1332338576E+00, 2.8141504887E+00, 9.3088187262E-01],
	[3.1375000000E+04, 2.3983892487E+01, 5.2441420750E+00, 8.1374537101E+00, 2.8147433799E+00, 9.3091490968E-01],
	[3.1380000000E+04, 2.3990287184E+01, 5.2441448959E+00, 8.1416750781E+00, 2.8153371812E+00, 9.3094792999E-01],
	[3.1385000000E+04, 2.3996684726E+01, 5.2441480139E+00, 8.1458979619E+00, 2.8159309683E+00, 9.3098093356E-01],
	[3.1390000000E+04, 2.4003082954E+01, 5.2441511314E+00, 8.1501223617E+00, 2.8165246260E+00, 9.3101392038E-01],
	[3.1395000000E+04, 2.4009481868E+01, 5.2441542483E+00, 8.1543482780E+00, 2.8171181541E+00, 9.3104689046E-01],
	[3.1400000000E+04, 2.4015881469E+01, 5.2441573648E+00, 8.1585757109E+00, 2.8177115527E+00, 9.3107984383E-01],
	[3.1405000000E+04, 2.4022281757E+01, 5.2441604808E+00, 8.1628046608E+00, 2.8183048216E+00, 9.3111278047E-01],
	[3.1410000000E+04, 2.4028682730E+01, 5.2441635963E+00, 8.1670351281E+00, 2.8188979610E+00, 9.3114570042E-01],
	[3.1415000000E+04, 2.4035084391E+01, 5.2441667113E+00, 8.1712671129E+00, 2.8194909709E+00, 9.3117860366E-01],
	[3.1420000000E+04, 2.4041486737E+01, 5.2441698258E+00, 8.1755006156E+00, 2.8200838511E+00, 9.3121149021E-01],
	[3.1425000000E+04, 2.4047889770E+01, 5.2441729399E+00, 8.1797356365E+00, 2.8206766016E+00, 9.3124436008E-01],
	[3.1430000000E+04, 2.4054293489E+01, 5.2441760534E+00, 8.1839721759E+00, 2.8212692226E+00, 9.3127721328E-01],
	[3.1435000000E+04, 2.4060697894E+01, 5.2441791664E+00, 8.1882102342E+00, 2.8218617139E+00, 9.3131004981E-01],
	[3.1440000000E+04, 2.4067102985E+01, 5.2441822789E+00, 8.1924498115E+00, 2.8224540755E+00, 9.3134286968E-01],
	[3.1445000000E+04, 2.4073508762E+01, 5.2441853910E+00, 8.1966909082E+00, 2.8230463075E+00, 9.3137567290E-01],
	[3.1450000000E+04, 2.4079915226E+01, 5.2441885025E+00, 8.2009335247E+00, 2.8236384097E+00, 9.3140845949E-01],
	[3.1455000000E+04, 2.4086322375E+01, 5.2441916136E+00, 8.2051776612E+00, 2.8242303823E+00, 9.3144122944E-01],
	[3.1460000000E+04, 2.4092730211E+01, 5.2441947242E+00, 8.2094233180E+00, 2.8248222252E+00, 9.3147398277E-01],
	[3.1465000000E+04, 2.4099138732E+01, 5.2441978342E+00, 8.2136704954E+00, 2.8254139383E+00, 9.3150671949E-01],
	[3.1470000000E+04, 2.4105547940E+01, 5.2442009438E+00, 8.2179191937E+00, 2.8260055217E+00, 9.3153943960E-01],
	[3.1475000000E+04, 2.4111957833E+01, 5.2442040529E+00, 8.2221694133E+00, 2.8265969754E+00, 9.3157214311E-01],
	[3.1480000000E+04, 2.4118368412E+01, 5.2442071615E+00, 8.2264211544E+00, 2.8271882992E+00, 9.3160483003E-01],
	[3.1485000000E+04, 2.4124779677E+01, 5.2442102696E+00, 8.2306744173E+00, 2.8277794933E+00, 9.3163750036E-01],
	[3.1490000000E+04, 2.4131191628E+01, 5.2442133772E+00, 8.2349292023E+00, 2.8283705577E+00, 9.3167015413E-01],
	[3.1495000000E+04, 2.4137604265E+01, 5.2442164843E+00, 8.2391855098E+00, 2.8289614922E+00, 9.3170279133E-01],
	[3.1500000000E+04, 2.4144017587E+01, 5.2442195910E+00, 8.2434433400E+00, 2.8295522969E+00, 9.3173541197E-01],
	[3.1505000000E+04, 2.4150431596E+01, 5.2442226971E+00, 8.2477026933E+00, 2.8301429717E+00, 9.3176801607E-01],
	[3.1510000000E+04, 2.4156846289E+01, 5.2442258028E+00, 8.2519635699E+00, 2.8307335168E+00, 9.3180060363E-01],
	[3.1515000000E+04, 2.4163261669E+01, 5.2442289079E+00, 8.2562259701E+00, 2.8313239319E+00, 9.3183317465E-01],
	[3.1520000000E+04, 2.4169677734E+01, 5.2442320126E+00, 8.2604898943E+00, 2.8319142173E+00, 9.3186572915E-01],
	[3.1525000000E+04, 2.4176094484E+01, 5.2442351168E+00, 8.2647553427E+00, 2.8325043727E+00, 9.3189826714E-01],
	[3.1530000000E+04, 2.4182511920E+01, 5.2442382204E+00, 8.2690223157E+00, 2.8330943982E+00, 9.3193078862E-01],
	[3.1535000000E+04, 2.4188930042E+01, 5.2442413236E+00, 8.2732908135E+00, 2.8336842939E+00, 9.3196329360E-01],
	[3.1540000000E+04, 2.4195348849E+01, 5.2442444263E+00, 8.2775608365E+00, 2.8342740596E+00, 9.3199578210E-01],
	[3.1545000000E+04, 2.4201768341E+01, 5.2442475285E+00, 8.2818323850E+00, 2.8348636954E+00, 9.3202825411E-01],
	[3.1550000000E+04, 2.4208188519E+01, 5.2442506303E+00, 8.2861054592E+00, 2.8354532013E+00, 9.3206070965E-01],
	[3.1555000000E+04, 2.4214609382E+01, 5.2442537315E+00, 8.2903800594E+00, 2.8360425772E+00, 9.3209314873E-01],
	[3.1560000000E+04, 2.4221030930E+01, 5.2442568323E+00, 8.2946561861E+00, 2.8366318232E+00, 9.3212557135E-01],
	[3.1565000000E+04, 2.4227453164E+01, 5.2442599325E+00, 8.2989338394E+00, 2.8372209392E+00, 9.3215797752E-01],
	[3.1570000000E+04, 2.4233876083E+01, 5.2442630323E+00, 8.3032130197E+00, 2.8378099252E+00, 9.3219036725E-01],
	[3.1575000000E+04, 2.4240299687E+01, 5.2442661316E+00, 8.3074937272E+00, 2.8383987812E+00, 9.3222274055E-01],
	[3.1580000000E+04, 2.4246723976E+01, 5.2442692303E+00, 8.3117759623E+00, 2.8389875072E+00, 9.3225509743E-01],
	[3.1585000000E+04, 2.4253148951E+01, 5.2442723286E+00, 8.3160597253E+00, 2.8395761032E+00, 9.3228743789E-01],
	[3.1590000000E+04, 2.4259574610E+01, 5.2442754265E+00, 8.3203450165E+00, 2.8401645692E+00, 9.3231976195E-01],
	[3.1595000000E+04, 2.4266000955E+01, 5.2442785238E+00, 8.3246318362E+00, 2.8407529051E+00, 9.3235206961E-01],
	[3.1600000000E+04, 2.4272427984E+01, 5.2442816206E+00, 8.3289201847E+00, 2.8413411110E+00, 9.3238436089E-01],
	[3.1605000000E+04, 2.4278855699E+01, 5.2442847170E+00, 8.3332100622E+00, 2.8419291867E+00, 9.3241663578E-01],
	[3.1610000000E+04, 2.4285284099E+01, 5.2442878128E+00, 8.3375014691E+00, 2.8425171325E+00, 9.3244889430E-01],
	[3.1615000000E+04, 2.4291713183E+01, 5.2442909082E+00, 8.3417944058E+00, 2.8431049481E+00, 9.3248113645E-01],
	[3.1620000000E+04, 2.4298142952E+01, 5.2442940031E+00, 8.3460888724E+00, 2.8436926336E+00, 9.3251336225E-01],
	[3.1625000000E+04, 2.4304573406E+01, 5.2442970975E+00, 8.3503848693E+00, 2.8442801890E+00, 9.3254557170E-01],
	[3.1630000000E+04, 2.4311004545E+01, 5.2443001914E+00, 8.3546823969E+00, 2.8448676143E+00, 9.3257776481E-01],
	[3.1635000000E+04, 2.4317436369E+01, 5.2443032848E+00, 8.3589814553E+00, 2.8454549095E+00, 9.3260994159E-01],
	[3.1640000000E+04, 2.4323868878E+01, 5.2443063777E+00, 8.3632820449E+00, 2.8460420745E+00, 9.3264210205E-01],
	[3.1645000000E+04, 2.4330302071E+01, 5.2443094702E+00, 8.3675841661E+00, 2.8466291094E+00, 9.3267424620E-01],
	[3.1650000000E+04, 2.4336735949E+01, 5.2443125621E+00, 8.3718878191E+00, 2.8472160141E+00, 9.3270637404E-01],
	[3.1655000000E+04, 2.4343170511E+01, 5.2443156536E+00, 8.3761930041E+00, 2.8478027886E+00, 9.3273848558E-01],
	[3.1660000000E+04, 2.4349605758E+01, 5.2443187446E+00, 8.3804997217E+00, 2.8483894329E+00, 9.3277058083E-01],
	[3.1665000000E+04, 2.4356041690E+01, 5.2443218351E+00, 8.3848079719E+00, 2.8489759471E+00, 9.3280265980E-01],
	[3.1670000000E+04, 2.4362478306E+01, 5.2443249251E+00, 8.3891177551E+00, 2.8495623310E+00, 9.3283472250E-01],
	[3.1675000000E+04, 2.4368915607E+01, 5.2443280146E+00, 8.3934290717E+00, 2.8501485847E+00, 9.3286676894E-01],
	[3.1680000000E+04, 2.4375353592E+01, 5.2443311037E+00, 8.3977419219E+00, 2.8507347082E+00, 9.3289879912E-01],
	[3.1685000000E+04, 2.4381792262E+01, 5.2443341922E+00, 8.4020563060E+00, 2.8513207014E+00, 9.3293081305E-01],
	[3.1690000000E+04, 2.4388231616E+01, 5.2443372803E+00, 8.4063722244E+00, 2.8519065644E+00, 9.3296281074E-01],
	[3.1695000000E+04, 2.4394671654E+01, 5.2443403679E+00, 8.4106896773E+00, 2.8524922971E+00, 9.3299479221E-01],
	[3.1700000000E+04, 2.4401112377E+01, 5.2443434550E+00, 8.4150086651E+00, 2.8530778996E+00, 9.3302675745E-01],
	[3.1705000000E+04, 2.4407553783E+01, 5.2443465416E+00, 8.4193291880E+00, 2.8536633717E+00, 9.3305870647E-01],
	[3.1710000000E+04, 2.4413995875E+01, 5.2443496277E+00, 8.4236512463E+00, 2.8542487136E+00, 9.3309063930E-01],
	[3.1715000000E+04, 2.4420438650E+01, 5.2443527134E+00, 8.4279748404E+00, 2.8548339252E+00, 9.3312255592E-01],
	[3.1720000000E+04, 2.4426882110E+01, 5.2443557985E+00, 8.4322999706E+00, 2.8554190064E+00, 9.3315445635E-01],
	[3.1725000000E+04, 2.4433326253E+01, 5.2443588832E+00, 8.4366266371E+00, 2.8560039573E+00, 9.3318634061E-01],
	[3.1730000000E+04, 2.4439771081E+01, 5.2443619674E+00, 8.4409548402E+00, 2.8565887779E+00, 9.3321820869E-01],
	[3.1735000000E+04, 2.4446216593E+01, 5.2443650511E+00, 8.4452845804E+00, 2.8571734681E+00, 9.3325006061E-01],
	[3.1740000000E+04, 2.4452662789E+01, 5.2443681343E+00, 8.4496158578E+00, 2.8577580280E+00, 9.3328189637E-01],
	[3.1745000000E+04, 2.4459109669E+01, 5.2443712171E+00, 8.4539486727E+00, 2.8583424576E+00, 9.3331371599E-01],
	[3.1750000000E+04, 2.4465557233E+01, 5.2443742993E+00, 8.4582830255E+00, 2.8589267567E+00, 9.3334551946E-01],
	[3.1755000000E+04, 2.4472005480E+01, 5.2443773811E+00, 8.4626189166E+00, 2.8595109255E+00, 9.3337730681E-01],
	[3.1760000000E+04, 2.4478454412E+01, 5.2443804624E+00, 8.4669563460E+00, 2.8600949638E+00, 9.3340907803E-01],
	[3.1765000000E+04, 2.4484904028E+01, 5.2443835432E+00, 8.4712953143E+00, 2.8606788718E+00, 9.3344083314E-01],
	[3.1770000000E+04, 2.4491354327E+01, 5.2443866235E+00, 8.4756358216E+00, 2.8612626493E+00, 9.3347257214E-01],
	[3.1775000000E+04, 2.4497805310E+01, 5.2443897034E+00, 8.4799778684E+00, 2.8618462964E+00, 9.3350429505E-01],
	[3.1780000000E+04, 2.4504256977E+01, 5.2443927827E+00, 8.4843214548E+00, 2.8624298131E+00, 9.3353600186E-01],
	[3.1785000000E+04, 2.4510709328E+01, 5.2443958616E+00, 8.4886665812E+00, 2.8630131993E+00, 9.3356769260E-01],
	[3.1790000000E+04, 2.4517162362E+01, 5.2443989400E+00, 8.4930132479E+00, 2.8635964551E+00, 9.3359936726E-01],
	[3.1795000000E+04, 2.4523616080E+01, 5.2444020179E+00, 8.4973614552E+00, 2.8641795805E+00, 9.3363102586E-01],
	[3.1800000000E+04, 2.4530070481E+01, 5.2444050953E+00, 8.5017112034E+00, 2.8647625753E+00, 9.3366266840E-01],
	[3.1805000000E+04, 2.4536525567E+01, 5.2444081723E+00, 8.5060624928E+00, 2.8653454397E+00, 9.3369429490E-01],
	[3.1810000000E+04, 2.4542981335E+01, 5.2444112488E+00, 8.5104153237E+00, 2.8659281735E+00, 9.3372590535E-01],
	[3.1815000000E+04, 2.4549437787E+01, 5.2444143247E+00, 8.5147696964E+00, 2.8665107769E+00, 9.3375749978E-01],
	[3.1820000000E+04, 2.4555894923E+01, 5.2444174002E+00, 8.5191256113E+00, 2.8670932498E+00, 9.3378907818E-01],
	[3.1825000000E+04, 2.4562352742E+01, 5.2444204753E+00, 8.5234830685E+00, 2.8676755921E+00, 9.3382064057E-01],
	[3.1830000000E+04, 2.4568811245E+01, 5.2444235498E+00, 8.5278420685E+00, 2.8682578039E+00, 9.3385218695E-01],
	[3.1835000000E+04, 2.4575270431E+01, 5.2444266239E+00, 8.5322026115E+00, 2.8688398852E+00, 9.3388371733E-01],
	[3.1840000000E+04, 2.4581730300E+01, 5.2444296974E+00, 8.5365646978E+00, 2.8694218359E+00, 9.3391523173E-01],
	[3.1845000000E+04, 2.4588190852E+01, 5.2444327705E+00, 8.5409283278E+00, 2.8700036561E+00, 9.3394673014E-01],
	[3.1850000000E+04, 2.4594652088E+01, 5.2444358431E+00, 8.5452935017E+00, 2.8705853457E+00, 9.3397821258E-01],
	[3.1855000000E+04, 2.4601114007E+01, 5.2444389153E+00, 8.5496602198E+00, 2.8711669047E+00, 9.3400967906E-01],
	[3.1860000000E+04, 2.4607576609E+01, 5.2444419869E+00, 8.5540284824E+00, 2.8717483331E+00, 9.3404112958E-01],
	[3.1865000000E+04, 2.4614039895E+01, 5.2444450581E+00, 8.5583982899E+00, 2.8723296310E+00, 9.3407256415E-01],
	[3.1870000000E+04, 2.4620503863E+01, 5.2444481288E+00, 8.5627696426E+00, 2.8729107982E+00, 9.3410398278E-01],
	[3.1875000000E+04, 2.4626968515E+01, 5.2444511990E+00, 8.5671425407E+00, 2.8734918349E+00, 9.3413538549E-01],
	[3.1880000000E+04, 2.4633433849E+01, 5.2444542687E+00, 8.5715169845E+00, 2.8740727409E+00, 9.3416677226E-01],
	[3.1885000000E+04, 2.4639918673E+01, 5.2444599057E+00, 8.5758929745E+00, 2.8746545437E+00, 9.3419814313E-01],
	[3.1890000000E+04, 2.4646406764E+01, 5.2444658936E+00, 8.5802705107E+00, 2.8752363572E+00, 9.3422949808E-01],
	[3.1895000000E+04, 2.4652895545E+01, 5.2444718804E+00, 8.5846495936E+00, 2.8758180407E+00, 9.3426083714E-01],
	[3.1900000000E+04, 2.4659385017E+01, 5.2444778664E+00, 8.5890302235E+00, 2.8763995941E+00, 9.3429216031E-01],
	[3.1905000000E+04, 2.4665875180E+01, 5.2444838514E+00, 8.5934124007E+00, 2.8769810175E+00, 9.3432346760E-01],
	[3.1910000000E+04, 2.4672366033E+01, 5.2444898355E+00, 8.5977961254E+00, 2.8775623108E+00, 9.3435475901E-01],
	[3.1915000000E+04, 2.4678857577E+01, 5.2444958187E+00, 8.6021813980E+00, 2.8781434740E+00, 9.3438603456E-01],
	[3.1920000000E+04, 2.4685349812E+01, 5.2445018009E+00, 8.6065682188E+00, 2.8787245072E+00, 9.3441729425E-01],
	[3.1925000000E+04, 2.4691842738E+01, 5.2445077822E+00, 8.6109565881E+00, 2.8793054102E+00, 9.3444853809E-01],
	[3.1930000000E+04, 2.4698336354E+01, 5.2445137626E+00, 8.6153465062E+00, 2.8798861832E+00, 9.3447976609E-01],
	[3.1935000000E+04, 2.4704830661E+01, 5.2445197420E+00, 8.6197379733E+00, 2.8804668260E+00, 9.3451097826E-01],
	[3.1940000000E+04, 2.4711325658E+01, 5.2445257206E+00, 8.6241309899E+00, 2.8810473388E+00, 9.3454217461E-01],
	[3.1945000000E+04, 2.4717821346E+01, 5.2445316981E+00, 8.6285255561E+00, 2.8816277214E+00, 9.3457335513E-01],
	[3.1950000000E+04, 2.4724317724E+01, 5.2445376748E+00, 8.6329216723E+00, 2.8822079739E+00, 9.3460451984E-01],
	[3.1955000000E+04, 2.4730814792E+01, 5.2445436505E+00, 8.6373193389E+00, 2.8827880962E+00, 9.3463566874E-01],
	[3.1960000000E+04, 2.4737312551E+01, 5.2445496253E+00, 8.6417185560E+00, 2.8833680884E+00, 9.3466680185E-01],
	[3.1965000000E+04, 2.4743811000E+01, 5.2445555992E+00, 8.6461193241E+00, 2.8839479504E+00, 9.3469791916E-01],
	[3.1970000000E+04, 2.4750310140E+01, 5.2445615721E+00, 8.6505216433E+00, 2.8845276823E+00, 9.3472902069E-01],
	[3.1975000000E+04, 2.4756809970E+01, 5.2445675442E+00, 8.6549255141E+00, 2.8851072839E+00, 9.3476010644E-01],
	[3.1980000000E+04, 2.4763310490E+01, 5.2445735152E+00, 8.6593309367E+00, 2.8856867555E+00, 9.3479117643E-01],
	[3.1985000000E+04, 2.4769811700E+01, 5.2445794854E+00, 8.6637379115E+00, 2.8862660968E+00, 9.3482223065E-01],
	[3.1990000000E+04, 2.4776313601E+01, 5.2445854546E+00, 8.6681464386E+00, 2.8868453079E+00, 9.3485326912E-01],
	[3.1995000000E+04, 2.4782816192E+01, 5.2445914230E+00, 8.6725565185E+00, 2.8874243888E+00, 9.3488429184E-01],
	[3.2000000000E+04, 2.4789319472E+01, 5.2445973903E+00, 8.6769681514E+00, 2.8880033395E+00, 9.3491529882E-01],
	[3.2005000000E+04, 2.4795823443E+01, 5.2446033568E+00, 8.6813813377E+00, 2.8885821600E+00, 9.3494629006E-01],
	[3.2010000000E+04, 2.4802328104E+01, 5.2446093223E+00, 8.6857960776E+00, 2.8891608502E+00, 9.3497726558E-01],
	[3.2015000000E+04, 2.4808833455E+01, 5.2446152869E+00, 8.6902123714E+00, 2.8897394102E+00, 9.3500822538E-01],
	[3.2020000000E+04, 2.4815339496E+01, 5.2446212506E+00, 8.6946302195E+00, 2.8903178400E+00, 9.3503916947E-01],
	[3.2025000000E+04, 2.4821846227E+01, 5.2446272134E+00, 8.6990496222E+00, 2.8908961395E+00, 9.3507009786E-01],
	[3.2030000000E+04, 2.4828353647E+01, 5.2446331752E+00, 8.7034705797E+00, 2.8914743087E+00, 9.3510101055E-01],
	[3.2035000000E+04, 2.4834861758E+01, 5.2446391361E+00, 8.7078930924E+00, 2.8920523477E+00, 9.3513190755E-01],
	[3.2040000000E+04, 2.4841370558E+01, 5.2446450961E+00, 8.7123171605E+00, 2.8926302564E+00, 9.3516278886E-01],
	[3.2045000000E+04, 2.4847880049E+01, 5.2446510552E+00, 8.7167427844E+00, 2.8932080348E+00, 9.3519365451E-01],
	[3.2050000000E+04, 2.4854390229E+01, 5.2446570133E+00, 8.7211699643E+00, 2.8937856830E+00, 9.3522450448E-01],
	[3.2055000000E+04, 2.4860901098E+01, 5.2446629706E+00, 8.7255987007E+00, 2.8943632008E+00, 9.3525533879E-01],
	[3.2060000000E+04, 2.4867412658E+01, 5.2446689268E+00, 8.7300289937E+00, 2.8949405883E+00, 9.3528615745E-01],
	[3.2065000000E+04, 2.4873924907E+01, 5.2446748822E+00, 8.7344608437E+00, 2.8955178455E+00, 9.3531696047E-01],
	[3.2070000000E+04, 2.4880437845E+01, 5.2446808367E+00, 8.7388942510E+00, 2.8960949724E+00, 9.3534774784E-01],
	[3.2075000000E+04, 2.4886951474E+01, 5.2446867902E+00, 8.7433292159E+00, 2.8966719690E+00, 9.3537851958E-01],
	[3.2080000000E+04, 2.4893465791E+01, 5.2446927428E+00, 8.7477657387E+00, 2.8972488352E+00, 9.3540927570E-01],
	[3.2085000000E+04, 2.4899980799E+01, 5.2446986945E+00, 8.7522038196E+00, 2.8978255711E+00, 9.3544001620E-01],
	[3.2090000000E+04, 2.4906496496E+01, 5.2447046453E+00, 8.7566434591E+00, 2.8984021767E+00, 9.3547074110E-01],
	[3.2095000000E+04, 2.4913012882E+01, 5.2447105951E+00, 8.7610846574E+00, 2.8989786519E+00, 9.3550145039E-01],
	[3.2100000000E+04, 2.4919529958E+01, 5.2447165441E+00, 8.7655274148E+00, 2.8995549967E+00, 9.3553214408E-01],
	[3.2105000000E+04, 2.4926047723E+01, 5.2447224921E+00, 8.7699717316E+00, 2.9001312112E+00, 9.3556282219E-01],
	[3.2110000000E+04, 2.4932566177E+01, 5.2447284392E+00, 8.7744176081E+00, 2.9007072952E+00, 9.3559348471E-01],
	[3.2115000000E+04, 2.4939085321E+01, 5.2447343853E+00, 8.7788650446E+00, 2.9012832489E+00, 9.3562413166E-01],
	[3.2120000000E+04, 2.4945605154E+01, 5.2447403306E+00, 8.7833140415E+00, 2.9018590722E+00, 9.3565476305E-01],
	[3.2125000000E+04, 2.4952125676E+01, 5.2447462749E+00, 8.7877645989E+00, 2.9024347652E+00, 9.3568537888E-01],
	[3.2130000000E+04, 2.4958646887E+01, 5.2447522183E+00, 8.7922167174E+00, 2.9030103277E+00, 9.3571597915E-01],
	[3.2135000000E+04, 2.4965168788E+01, 5.2447581608E+00, 8.7966703970E+00, 2.9035857598E+00, 9.3574656388E-01],
	[3.2140000000E+04, 2.4971691378E+01, 5.2447641024E+00, 8.8011256382E+00, 2.9041610614E+00, 9.3577713308E-01],
	[3.2145000000E+04, 2.4978214657E+01, 5.2447700431E+00, 8.8055824412E+00, 2.9047362327E+00, 9.3580768674E-01],
	[3.2150000000E+04, 2.4984738625E+01, 5.2447759828E+00, 8.8100408064E+00, 2.9053112735E+00, 9.3583822488E-01],
	[3.2155000000E+04, 2.4991263282E+01, 5.2447819216E+00, 8.8145007340E+00, 2.9058861839E+00, 9.3586874751E-01],
	[3.2160000000E+04, 2.4997788628E+01, 5.2447878595E+00, 8.8189622244E+00, 2.9064609639E+00, 9.3589925463E-01],
	[3.2165000000E+04, 2.5004314663E+01, 5.2447937965E+00, 8.8234252779E+00, 2.9070356134E+00, 9.3592974625E-01],
	[3.2170000000E+04, 2.5010841387E+01, 5.2447997326E+00, 8.8278898947E+00, 2.9076101324E+00, 9.3596022237E-01],
	[3.2175000000E+04, 2.5017368799E+01, 5.2448056678E+00, 8.8323560752E+00, 2.9081845210E+00, 9.3599068301E-01],
	[3.2180000000E+04, 2.5023896901E+01, 5.2448116020E+00, 8.8368238196E+00, 2.9087587791E+00, 9.3602112817E-01],
	[3.2185000000E+04, 2.5030425692E+01, 5.2448175353E+00, 8.8412931283E+00, 2.9093329068E+00, 9.3605155786E-01],
	[3.2190000000E+04, 2.5036955171E+01, 5.2448234678E+00, 8.8457640016E+00, 2.9099069039E+00, 9.3608197208E-01],
	[3.2195000000E+04, 2.5043485339E+01, 5.2448293993E+00, 8.8502364398E+00, 2.9104807706E+00, 9.3611237085E-01],
	[3.2200000000E+04, 2.5050016196E+01, 5.2448353298E+00, 8.8547104432E+00, 2.9110545068E+00, 9.3614275416E-01],
	[3.2205000000E+04, 2.5056547741E+01, 5.2448412595E+00, 8.8591860120E+00, 2.9116281125E+00, 9.3617312204E-01],
	[3.2210000000E+04, 2.5063079975E+01, 5.2448471883E+00, 8.8636631467E+00, 2.9122015877E+00, 9.3620347448E-01],
	[3.2215000000E+04, 2.5069612898E+01, 5.2448531161E+00, 8.8681418474E+00, 2.9127749323E+00, 9.3623381149E-01],
	[3.2220000000E+04, 2.5076146510E+01, 5.2448590431E+00, 8.8726221146E+00, 2.9133481465E+00, 9.3626413308E-01],
	[3.2225000000E+04, 2.5082680810E+01, 5.2448649691E+00, 8.8771039485E+00, 2.9139212301E+00, 9.3629443926E-01],
	[3.2230000000E+04, 2.5089215798E+01, 5.2448708942E+00, 8.8815873493E+00, 2.9144941832E+00, 9.3632473004E-01],
	[3.2235000000E+04, 2.5095751475E+01, 5.2448768184E+00, 8.8860723175E+00, 2.9150670058E+00, 9.3635500541E-01],
	[3.2240000000E+04, 2.5102287840E+01, 5.2448827417E+00, 8.8905588534E+00, 2.9156396978E+00, 9.3638526539E-01],
	[3.2245000000E+04, 2.5108824894E+01, 5.2448886640E+00, 8.8950469571E+00, 2.9162122593E+00, 9.3641550999E-01],
	[3.2250000000E+04, 2.5115362636E+01, 5.2448945855E+00, 8.8995366291E+00, 2.9167846902E+00, 9.3644573921E-01],
	[3.2255000000E+04, 2.5121901067E+01, 5.2449005060E+00, 8.9040278695E+00, 2.9173569906E+00, 9.3647595307E-01],
	[3.2260000000E+04, 2.5128440186E+01, 5.2449064257E+00, 8.9085206789E+00, 2.9179291604E+00, 9.3650615156E-01],
	[3.2265000000E+04, 2.5134979993E+01, 5.2449123444E+00, 8.9130150574E+00, 2.9185011997E+00, 9.3653633469E-01],
	[3.2270000000E+04, 2.5141520488E+01, 5.2449182622E+00, 8.9175110053E+00, 2.9190731084E+00, 9.3656650248E-01],
	[3.2275000000E+04, 2.5148061672E+01, 5.2449241791E+00, 8.9220085229E+00, 2.9196448865E+00, 9.3659665493E-01],
	[3.2280000000E+04, 2.5154603544E+01, 5.2449300951E+00, 8.9265076107E+00, 2.9202165340E+00, 9.3662679205E-01],
	[3.2285000000E+04, 2.5161146104E+01, 5.2449360102E+00, 8.9310082687E+00, 2.9207880509E+00, 9.3665691384E-01],
	[3.2290000000E+04, 2.5167689352E+01, 5.2449419244E+00, 8.9355104975E+00, 2.9213594372E+00, 9.3668702031E-01],
	[3.2295000000E+04, 2.5174233288E+01, 5.2449478376E+00, 8.9400142972E+00, 2.9219306930E+00, 9.3671711147E-01],
	[3.2300000000E+04, 2.5180777912E+01, 5.2449537500E+00, 8.9445196681E+00, 2.9225018181E+00, 9.3674718733E-01],
	[3.2305000000E+04, 2.5187323224E+01, 5.2449596614E+00, 8.9490266107E+00, 2.9230728126E+00, 9.3677724789E-01],
	[3.2310000000E+04, 2.5193869225E+01, 5.2449655720E+00, 8.9535351251E+00, 2.9236436765E+00, 9.3680729316E-01],
	[3.2315000000E+04, 2.5200415913E+01, 5.2449714816E+00, 8.9580452117E+00, 2.9242144098E+00, 9.3683732315E-01],
	[3.2320000000E+04, 2.5206963289E+01, 5.2449773903E+00, 8.9625568708E+00, 2.9247850125E+00, 9.3686733787E-01],
	[3.2325000000E+04, 2.5213511353E+01, 5.2449832982E+00, 8.9670701027E+00, 2.9253554845E+00, 9.3689733732E-01],
	[3.2330000000E+04, 2.5220060104E+01, 5.2449892051E+00, 8.9715849077E+00, 2.9259258259E+00, 9.3692732151E-01],
	[3.2335000000E+04, 2.5226609544E+01, 5.2449951111E+00, 8.9761012861E+00, 2.9264960366E+00, 9.3695729044E-01],
	[3.2340000000E+04, 2.5233159671E+01, 5.2450010162E+00, 8.9806192382E+00, 2.9270661168E+00, 9.3698724414E-01],
	[3.2345000000E+04, 2.5239710486E+01, 5.2450069204E+00, 8.9851387643E+00, 2.9276360662E+00, 9.3701718259E-01],
	[3.2350000000E+04, 2.5246261989E+01, 5.2450128236E+00, 8.9896598647E+00, 2.9282058850E+00, 9.3704710581E-01],
	[3.2355000000E+04, 2.5252814179E+01, 5.2450187260E+00, 8.9941825397E+00, 2.9287755732E+00, 9.3707701381E-01],
	[3.2360000000E+04, 2.5259367058E+01, 5.2450246275E+00, 8.9987067897E+00, 2.9293451307E+00, 9.3710690660E-01],
	[3.2365000000E+04, 2.5265920623E+01, 5.2450305281E+00, 9.0032326149E+00, 2.9299145575E+00, 9.3713678418E-01],
	[3.2370000000E+04, 2.5272474876E+01, 5.2450364277E+00, 9.0077600156E+00, 2.9304838536E+00, 9.3716664655E-01],
	[3.2375000000E+04, 2.5279029817E+01, 5.2450423265E+00, 9.0122889921E+00, 2.9310530191E+00, 9.3719649373E-01],
	[3.2380000000E+04, 2.5285585445E+01, 5.2450482243E+00, 9.0168195448E+00, 2.9316220539E+00, 9.3722632573E-01],
	[3.2385000000E+04, 2.5292141761E+01, 5.2450541213E+00, 9.0213516739E+00, 2.9321909580E+00, 9.3725614254E-01],
	[3.2390000000E+04, 2.5298698764E+01, 5.2450600173E+00, 9.0258853798E+00, 2.9327597314E+00, 9.3728594418E-01],
	[3.2395000000E+04, 2.5305261378E+01, 5.2450665785E+00, 9.0304206627E+00, 2.9333286485E+00, 9.3731573066E-01],
	[3.2400000000E+04, 2.5311840919E+01, 5.2450753350E+00, 9.0349575230E+00, 2.9338983405E+00, 9.3734550198E-01],
	[3.2405000000E+04, 2.5318421155E+01, 5.2450840901E+00, 9.0394963172E+00, 2.9344679399E+00, 9.3737525815E-01],
	[3.2410000000E+04, 2.5325002087E+01, 5.2450928439E+00, 9.0440377038E+00, 2.9350375160E+00, 9.3740499918E-01],
	[3.2415000000E+04, 2.5331583713E+01, 5.2451015964E+00, 9.0485806700E+00, 2.9356069619E+00, 9.3743472508E-01],
	[3.2420000000E+04, 2.5338166034E+01, 5.2451103475E+00, 9.0531252160E+00, 2.9361762776E+00, 9.3746443584E-01],
	[3.2425000000E+04, 2.5344749051E+01, 5.2451190973E+00, 9.0576713421E+00, 2.9367454631E+00, 9.3749413149E-01],
	[3.2430000000E+04, 2.5351332762E+01, 5.2451278458E+00, 9.0622190486E+00, 2.9373145184E+00, 9.3752381202E-01],
	[3.2435000000E+04, 2.5357917168E+01, 5.2451365929E+00, 9.0667683358E+00, 2.9378834436E+00, 9.3755347744E-01],
	[3.2440000000E+04, 2.5364502268E+01, 5.2451453387E+00, 9.0713192041E+00, 2.9384522385E+00, 9.3758312777E-01],
	[3.2445000000E+04, 2.5371088064E+01, 5.2451540832E+00, 9.0758716537E+00, 2.9390209032E+00, 9.3761276300E-01],
	[3.2450000000E+04, 2.5377674554E+01, 5.2451628263E+00, 9.0804256850E+00, 2.9395894378E+00, 9.3764238315E-01],
	[3.2455000000E+04, 2.5384261739E+01, 5.2451715681E+00, 9.0849812982E+00, 2.9401578421E+00, 9.3767198823E-01],
	[3.2460000000E+04, 2.5390849619E+01, 5.2451803086E+00, 9.0895384936E+00, 2.9407261162E+00, 9.3770157823E-01],
	[3.2465000000E+04, 2.5397438193E+01, 5.2451890477E+00, 9.0940972716E+00, 2.9412942601E+00, 9.3773115317E-01],
	[3.2470000000E+04, 2.5404027462E+01, 5.2451977855E+00, 9.0986576325E+00, 2.9418622737E+00, 9.3776071306E-01],
	[3.2475000000E+04, 2.5410617425E+01, 5.2452065220E+00, 9.1032195765E+00, 2.9424301572E+00, 9.3779025790E-01],
	[3.2480000000E+04, 2.5417208083E+01, 5.2452152571E+00, 9.1077831041E+00, 2.9429979104E+00, 9.3781978770E-01],
	[3.2485000000E+04, 2.5423799436E+01, 5.2452239909E+00, 9.1123482154E+00, 2.9435655333E+00, 9.3784930247E-01],
	[3.2490000000E+04, 2.5430391483E+01, 5.2452327234E+00, 9.1169149107E+00, 2.9441330260E+00, 9.3787880221E-01],
	[3.2495000000E+04, 2.5436984224E+01, 5.2452414546E+00, 9.1214831905E+00, 2.9447003885E+00, 9.3790828694E-01],
	[3.2500000000E+04, 2.5443577660E+01, 5.2452501844E+00, 9.1260530550E+00, 2.9452676208E+00, 9.3793775665E-01],
	[3.2505000000E+04, 2.5450171790E+01, 5.2452589129E+00, 9.1306245044E+00, 2.9458347228E+00, 9.3796721136E-01],
	[3.2510000000E+04, 2.5456766615E+01, 5.2452676401E+00, 9.1351975392E+00, 2.9464016945E+00, 9.3799665107E-01],
	[3.2515000000E+04, 2.5463362134E+01, 5.2452763659E+00, 9.1397721596E+00, 2.9469685360E+00, 9.3802607580E-01],
	[3.2520000000E+04, 2.5469958347E+01, 5.2452850904E+00, 9.1443483659E+00, 2.9475352472E+00, 9.3805548554E-01],
	[3.2525000000E+04, 2.5476555254E+01, 5.2452938136E+00, 9.1489261584E+00, 2.9481018281E+00, 9.3808488031E-01],
	[3.2530000000E+04, 2.5483152856E+01, 5.2453025355E+00, 9.1535055375E+00, 2.9486682788E+00, 9.3811426011E-01],
	[3.2535000000E+04, 2.5489751152E+01, 5.2453112560E+00, 9.1580865033E+00, 2.9492345992E+00, 9.3814362495E-01],
	[3.2540000000E+04, 2.5496350141E+01, 5.2453199752E+00, 9.1626690564E+00, 2.9498007893E+00, 9.3817297484E-01],
	[3.2545000000E+04, 2.5502949825E+01, 5.2453286931E+00, 9.1672531968E+00, 2.9503668492E+00, 9.3820230979E-01],
	[3.2550000000E+04, 2.5509550203E+01, 5.2453374096E+00, 9.1718389250E+00, 2.9509327788E+00, 9.3823162979E-01],
	[3.2555000000E+04, 2.5516151275E+01, 5.2453461249E+00, 9.1764262413E+00, 2.9514985781E+00, 9.3826093487E-01],
	[3.2560000000E+04, 2.5522753042E+01, 5.2453548388E+00, 9.1810151459E+00, 2.9520642471E+00, 9.3829022503E-01],
	[3.2565000000E+04, 2.5529355502E+01, 5.2453635514E+00, 9.1856056392E+00, 2.9526297858E+00, 9.3831950027E-01],
	[3.2570000000E+04, 2.5535958656E+01, 5.2453722626E+00, 9.1901977214E+00, 2.9531951942E+00, 9.3834876060E-01],
	[3.2575000000E+04, 2.5542562503E+01, 5.2453809726E+00, 9.1947913930E+00, 2.9537604723E+00, 9.3837800603E-01],
	[3.2580000000E+04, 2.5549167045E+01, 5.2453896812E+00, 9.1993866541E+00, 2.9543256201E+00, 9.3840723656E-01],
	[3.2585000000E+04, 2.5555772281E+01, 5.2453983885E+00, 9.2039835051E+00, 2.9548906376E+00, 9.3843645221E-01],
	[3.2590000000E+04, 2.5562378210E+01, 5.2454070945E+00, 9.2085819462E+00, 2.9554555248E+00, 9.3846565298E-01],
	[3.2595000000E+04, 2.5568984833E+01, 5.2454157991E+00, 9.2131819779E+00, 2.9560202817E+00, 9.3849483888E-01],
	[3.2600000000E+04, 2.5575592150E+01, 5.2454245024E+00, 9.2177836004E+00, 2.9565849083E+00, 9.3852400992E-01],
	[3.2605000000E+04, 2.5582200161E+01, 5.2454332045E+00, 9.2223868140E+00, 2.9571494046E+00, 9.3855316610E-01],
	[3.2610000000E+04, 2.5588808865E+01, 5.2454419052E+00, 9.2269916190E+00, 2.9577137705E+00, 9.3858230743E-01],
	[3.2615000000E+04, 2.5595418263E+01, 5.2454506045E+00, 9.2315980157E+00, 2.9582780061E+00, 9.3861143391E-01],
	[3.2620000000E+04, 2.5602028354E+01, 5.2454593026E+00, 9.2362060045E+00, 2.9588421114E+00, 9.3864054557E-01],
	[3.2625000000E+04, 2.5608639139E+01, 5.2454679993E+00, 9.2408155856E+00, 2.9594060864E+00, 9.3866964239E-01],
	[3.2630000000E+04, 2.5615250618E+01, 5.2454766947E+00, 9.2454267593E+00, 2.9599699311E+00, 9.3869872439E-01],
	[3.2635000000E+04, 2.5621862790E+01, 5.2454853888E+00, 9.2500395259E+00, 2.9605336454E+00, 9.3872779159E-01],
	[3.2640000000E+04, 2.5628475655E+01, 5.2454940816E+00, 9.2546538858E+00, 2.9610972294E+00, 9.3875684397E-01],
	[3.2645000000E+04, 2.5635089214E+01, 5.2455027731E+00, 9.2592698393E+00, 2.9616606830E+00, 9.3878588156E-01],
	[3.2650000000E+04, 2.5641703467E+01, 5.2455114632E+00, 9.2638873866E+00, 2.9622240063E+00, 9.3881490435E-01],
	[3.2655000000E+04, 2.5648318412E+01, 5.2455201521E+00, 9.2685065281E+00, 2.9627871993E+00, 9.3884391237E-01],
	[3.2660000000E+04, 2.5654934051E+01, 5.2455288396E+00, 9.2731272640E+00, 2.9633502619E+00, 9.3887290560E-01],
	[3.2665000000E+04, 2.5661550384E+01, 5.2455375258E+00, 9.2777495948E+00, 2.9639131942E+00, 9.3890188407E-01],
	[3.2670000000E+04, 2.5668167409E+01, 5.2455462107E+00, 9.2823735206E+00, 2.9644759961E+00, 9.3893084778E-01],
	[3.2675000000E+04, 2.5674785128E+01, 5.2455548942E+00, 9.2869990418E+00, 2.9650386677E+00, 9.3895979673E-01],
	[3.2680000000E+04, 2.5681403540E+01, 5.2455635765E+00, 9.2916261586E+00, 2.9656012089E+00, 9.3898873093E-01],
	[3.2685000000E+04, 2.5688022645E+01, 5.2455722574E+00, 9.2962548715E+00, 2.9661636197E+00, 9.3901765040E-01],
	[3.2690000000E+04, 2.5694642444E+01, 5.2455809370E+00, 9.3008851807E+00, 2.9667259002E+00, 9.3904655513E-01],
	[3.2695000000E+04, 2.5701262935E+01, 5.2455896154E+00, 9.3055170865E+00, 2.9672880504E+00, 9.3907544514E-01],
	[3.2700000000E+04, 2.5707884119E+01, 5.2455982924E+00, 9.3101505892E+00, 2.9678500702E+00, 9.3910432043E-01],
	[3.2705000000E+04, 2.5714505997E+01, 5.2456069681E+00, 9.3147856892E+00, 2.9684119596E+00, 9.3913318101E-01],
	[3.2710000000E+04, 2.5721128567E+01, 5.2456156424E+00, 9.3194223866E+00, 2.9689737186E+00, 9.3916202689E-01],
	[3.2715000000E+04, 2.5727751831E+01, 5.2456243155E+00, 9.3240606819E+00, 2.9695353473E+00, 9.3919085807E-01],
	[3.2720000000E+04, 2.5734375787E+01, 5.2456329873E+00, 9.3287005753E+00, 2.9700968456E+00, 9.3921967456E-01],
	[3.2725000000E+04, 2.5741000437E+01, 5.2456416577E+00, 9.3333420672E+00, 2.9706582136E+00, 9.3924847637E-01],
	[3.2730000000E+04, 2.5747625779E+01, 5.2456503268E+00, 9.3379851578E+00, 2.9712194511E+00, 9.3927726351E-01],
	[3.2735000000E+04, 2.5754251814E+01, 5.2456589947E+00, 9.3426298475E+00, 2.9717805583E+00, 9.3930603598E-01],
	[3.2740000000E+04, 2.5760878541E+01, 5.2456676612E+00, 9.3472761365E+00, 2.9723415351E+00, 9.3933479380E-01],
	[3.2745000000E+04, 2.5767505962E+01, 5.2456763264E+00, 9.3519240252E+00, 2.9729023816E+00, 9.3936353696E-01],
	[3.2750000000E+04, 2.5774134075E+01, 5.2456849903E+00, 9.3565735139E+00, 2.9734630976E+00, 9.3939226547E-01],
	[3.2755000000E+04, 2.5780762881E+01, 5.2456936529E+00, 9.3612246029E+00, 2.9740236833E+00, 9.3942097935E-01],
	[3.2760000000E+04, 2.5787392380E+01, 5.2457023142E+00, 9.3658772924E+00, 2.9745841386E+00, 9.3944967860E-01],
	[3.2765000000E+04, 2.5794022571E+01, 5.2457109741E+00, 9.3705315829E+00, 2.9751444635E+00, 9.3947836323E-01],
	[3.2770000000E+04, 2.5800653455E+01, 5.2457196328E+00, 9.3751874745E+00, 2.9757046580E+00, 9.3950703325E-01],
	[3.2775000000E+04, 2.5807285031E+01, 5.2457282901E+00, 9.3798449676E+00, 2.9762647221E+00, 9.3953568865E-01],
	[3.2780000000E+04, 2.5813917300E+01, 5.2457369462E+00, 9.3845040626E+00, 2.9768246559E+00, 9.3956432946E-01],
	[3.2785000000E+04, 2.5820550262E+01, 5.2457456010E+00, 9.3891647596E+00, 2.9773844592E+00, 9.3959295567E-01],
	[3.2790000000E+04, 2.5827183915E+01, 5.2457542544E+00, 9.3938270591E+00, 2.9779441322E+00, 9.3962156729E-01],
	[3.2795000000E+04, 2.5833818262E+01, 5.2457629065E+00, 9.3984909613E+00, 2.9785036747E+00, 9.3965016434E-01],
	[3.2800000000E+04, 2.5840453300E+01, 5.2457715574E+00, 9.4031564665E+00, 2.9790630869E+00, 9.3967874682E-01],
	[3.2805000000E+04, 2.5847089032E+01, 5.2457802069E+00, 9.4078235751E+00, 2.9796223687E+00, 9.3970731473E-01],
	[3.2810000000E+04, 2.5853725455E+01, 5.2457888551E+00, 9.4124922873E+00, 2.9801815200E+00, 9.3973586809E-01],
	[3.2815000000E+04, 2.5860362571E+01, 5.2457975020E+00, 9.4171626035E+00, 2.9807405410E+00, 9.3976440689E-01],
	[3.2820000000E+04, 2.5867000379E+01, 5.2458061476E+00, 9.4218345239E+00, 2.9812994316E+00, 9.3979293116E-01],
	[3.2825000000E+04, 2.5873638879E+01, 5.2458147920E+00, 9.4265080489E+00, 2.9818581917E+00, 9.3982144089E-01],
	[3.2830000000E+04, 2.5880278071E+01, 5.2458234350E+00, 9.4311831787E+00, 2.9824168215E+00, 9.3984993609E-01],
	[3.2835000000E+04, 2.5886917956E+01, 5.2458320767E+00, 9.4358599138E+00, 2.9829753209E+00, 9.3987841678E-01],
	[3.2840000000E+04, 2.5893558532E+01, 5.2458407171E+00, 9.4405382543E+00, 2.9835336898E+00, 9.3990688295E-01],
	[3.2845000000E+04, 2.5900199801E+01, 5.2458493562E+00, 9.4452182006E+00, 2.9840919284E+00, 9.3993533461E-01],
	[3.2850000000E+04, 2.5906841762E+01, 5.2458579940E+00, 9.4498997530E+00, 2.9846500365E+00, 9.3996377178E-01],
	[3.2855000000E+04, 2.5913484415E+01, 5.2458666305E+00, 9.4545829117E+00, 2.9852080143E+00, 9.3999219446E-01],
	[3.2860000000E+04, 2.5920127759E+01, 5.2458752657E+00, 9.4592676772E+00, 2.9857658616E+00, 9.4002060265E-01],
	[3.2865000000E+04, 2.5926771796E+01, 5.2458838996E+00, 9.4639540497E+00, 2.9863235785E+00, 9.4004899637E-01],
	[3.2870000000E+04, 2.5933416525E+01, 5.2458925322E+00, 9.4686420296E+00, 2.9868811650E+00, 9.4007737562E-01],
	[3.2875000000E+04, 2.5940061946E+01, 5.2459011635E+00, 9.4733316170E+00, 2.9874386211E+00, 9.4010574041E-01],
	[3.2880000000E+04, 2.5946708058E+01, 5.2459097935E+00, 9.4780228124E+00, 2.9879959468E+00, 9.4013409074E-01],
	[3.2885000000E+04, 2.5953354862E+01, 5.2459184223E+00, 9.4827156160E+00, 2.9885531421E+00, 9.4016242663E-01],
	[3.2890000000E+04, 2.5960002359E+01, 5.2459270497E+00, 9.4874100281E+00, 2.9891102070E+00, 9.4019074808E-01],
	[3.2895000000E+04, 2.5966650546E+01, 5.2459356758E+00, 9.4921060491E+00, 2.9896671415E+00, 9.4021905510E-01],
	[3.2900000000E+04, 2.5973299426E+01, 5.2459443006E+00, 9.4968036793E+00, 2.9902239455E+00, 9.4024734769E-01],
	[3.2905000000E+04, 2.5979948997E+01, 5.2459529241E+00, 9.5015029189E+00, 2.9907806191E+00, 9.4027562586E-01],
	[3.2910000000E+04, 2.5986599260E+01, 5.2459615464E+00, 9.5062037683E+00, 2.9913371624E+00, 9.4030388963E-01],
	[3.2915000000E+04, 2.5993250215E+01, 5.2459701673E+00, 9.5109062277E+00, 2.9918935752E+00, 9.4033213899E-01],
	[3.2920000000E+04, 2.5999921400E+01, 5.2459814063E+00, 9.5156102975E+00, 2.9924509687E+00, 9.4036037396E-01],
	[3.2925000000E+04, 2.6006594680E+01, 5.2459928307E+00, 9.5203159781E+00, 2.9930083117E+00, 9.4038859453E-01],
	[3.2930000000E+04, 2.6013268658E+01, 5.2460042534E+00, 9.5250232696E+00, 2.9935655249E+00, 9.4041680073E-01],
	[3.2935000000E+04, 2.6019943336E+01, 5.2460156744E+00, 9.5297321724E+00, 2.9941226082E+00, 9.4044499255E-01],
	[3.2940000000E+04, 2.6026618713E+01, 5.2460270937E+00, 9.5344426868E+00, 2.9946795617E+00, 9.4047317001E-01],
	[3.2945000000E+04, 2.6033294789E+01, 5.2460385113E+00, 9.5391548131E+00, 2.9952363853E+00, 9.4050133311E-01],
	[3.2950000000E+04, 2.6039971563E+01, 5.2460499272E+00, 9.5438685516E+00, 2.9957930790E+00, 9.4052948186E-01],
	[3.2955000000E+04, 2.6046649037E+01, 5.2460613413E+00, 9.5485839027E+00, 2.9963496429E+00, 9.4055761626E-01],
	[3.2960000000E+04, 2.6053327209E+01, 5.2460727538E+00, 9.5533008666E+00, 2.9969060769E+00, 9.4058573633E-01],
	[3.2965000000E+04, 2.6060006081E+01, 5.2460841645E+00, 9.5580194436E+00, 2.9974623811E+00, 9.4061384206E-01],
	[3.2970000000E+04, 2.6066685651E+01, 5.2460955736E+00, 9.5627396341E+00, 2.9980185554E+00, 9.4064193347E-01],
	[3.2975000000E+04, 2.6073365920E+01, 5.2461069809E+00, 9.5674614383E+00, 2.9985745999E+00, 9.4067001057E-01],
	[3.2980000000E+04, 2.6080046888E+01, 5.2461183866E+00, 9.5721848565E+00, 2.9991305145E+00, 9.4069807336E-01],
	[3.2985000000E+04, 2.6086728554E+01, 5.2461297905E+00, 9.5769098892E+00, 2.9996862992E+00, 9.4072612185E-01],
	[3.2990000000E+04, 2.6093410919E+01, 5.2461411927E+00, 9.5816365365E+00, 3.0002419541E+00, 9.4075415605E-01],
	[3.2995000000E+04, 2.6100093983E+01, 5.2461525933E+00, 9.5863647987E+00, 3.0007974791E+00, 9.4078217596E-01],
	[3.3000000000E+04, 2.6106777745E+01, 5.2461639921E+00, 9.5910946763E+00, 3.0013528743E+00, 9.4081018160E-01],
	[3.3005000000E+04, 2.6113462206E+01, 5.2461753892E+00, 9.5958261694E+00, 3.0019081396E+00, 9.4083817296E-01],
	[3.3010000000E+04, 2.6120147366E+01, 5.2461867846E+00, 9.6005592784E+00, 3.0024632750E+00, 9.4086615005E-01],
	[3.3015000000E+04, 2.6126833224E+01, 5.2461981784E+00, 9.6052940037E+00, 3.0030182806E+00, 9.4089411290E-01],
	[3.3020000000E+04, 2.6133519781E+01, 5.2462095704E+00, 9.6100303454E+00, 3.0035731564E+00, 9.4092206149E-01],
	[3.3025000000E+04, 2.6140207036E+01, 5.2462209607E+00, 9.6147683040E+00, 3.0041279022E+00, 9.4094999584E-01],
	[3.3030000000E+04, 2.6146894989E+01, 5.2462323493E+00, 9.6195078796E+00, 3.0046825183E+00, 9.4097791595E-01],
	[3.3035000000E+04, 2.6153583641E+01, 5.2462437362E+00, 9.6242490727E+00, 3.0052370044E+00, 9.4100582184E-01],
	[3.3040000000E+04, 2.6160272991E+01, 5.2462551214E+00, 9.6289918836E+00, 3.0057913607E+00, 9.4103371351E-01],
	[3.3045000000E+04, 2.6166963039E+01, 5.2462665050E+00, 9.6337363124E+00, 3.0063455872E+00, 9.4106159096E-01],
	[3.3050000000E+04, 2.6173653786E+01, 5.2462778868E+00, 9.6384823596E+00, 3.0068996838E+00, 9.4108945421E-01],
	[3.3055000000E+04, 2.6180345231E+01, 5.2462892669E+00, 9.6432300255E+00, 3.0074536505E+00, 9.4111730326E-01],
	[3.3060000000E+04, 2.6187037375E+01, 5.2463006454E+00, 9.6479793103E+00, 3.0080074874E+00, 9.4114513812E-01],
	[3.3065000000E+04, 2.6193730216E+01, 5.2463120221E+00, 9.6527302144E+00, 3.0085611944E+00, 9.4117295880E-01],
	[3.3070000000E+04, 2.6200423756E+01, 5.2463233971E+00, 9.6574827381E+00, 3.0091147716E+00, 9.4120076530E-01],
	[3.3075000000E+04, 2.6207117993E+01, 5.2463347705E+00, 9.6622368816E+00, 3.0096682189E+00, 9.4122855763E-01],
	[3.3080000000E+04, 2.6213812929E+01, 5.2463461421E+00, 9.6669926453E+00, 3.0102215363E+00, 9.4125633579E-01],
	[3.3085000000E+04, 2.6220508563E+01, 5.2463575121E+00, 9.6717500295E+00, 3.0107747240E+00, 9.4128409981E-01],
	[3.3090000000E+04, 2.6227204895E+01, 5.2463688803E+00, 9.6765090345E+00, 3.0113277817E+00, 9.4131184968E-01],
	[3.3095000000E+04, 2.6233901925E+01, 5.2463802469E+00, 9.6812696607E+00, 3.0118807096E+00, 9.4133958540E-01],
	[3.3100000000E+04, 2.6240599653E+01, 5.2463916118E+00, 9.6860319082E+00, 3.0124335077E+00, 9.4136730700E-01],
	[3.3105000000E+04, 2.6247298079E+01, 5.2464029750E+00, 9.6907957774E+00, 3.0129861759E+00, 9.4139501447E-01],
	[3.3110000000E+04, 2.6253997202E+01, 5.2464143365E+00, 9.6955612687E+00, 3.0135387143E+00, 9.4142270782E-01],
	[3.3115000000E+04, 2.6260697024E+01, 5.2464256963E+00, 9.7003283823E+00, 3.0140911228E+00, 9.4145038706E-01],
	[3.3120000000E+04, 2.6267397544E+01, 5.2464370544E+00, 9.7050971185E+00, 3.0146434015E+00, 9.4147805219E-01],
	[3.3125000000E+04, 2.6274098761E+01, 5.2464484108E+00, 9.7098674777E+00, 3.0151955503E+00, 9.4150570323E-01],
	[3.3130000000E+04, 2.6280800676E+01, 5.2464597655E+00, 9.7146394602E+00, 3.0157475693E+00, 9.4153334018E-01],
	[3.3135000000E+04, 2.6287503289E+01, 5.2464711186E+00, 9.7194130662E+00, 3.0162994584E+00, 9.4156096305E-01],
	[3.3140000000E+04, 2.6294206599E+01, 5.2464824699E+00, 9.7241882960E+00, 3.0168512177E+00, 9.4158857185E-01],
	[3.3145000000E+04, 2.6300910607E+01, 5.2464938196E+00, 9.7289651500E+00, 3.0174028471E+00, 9.4161616658E-01],
	[3.3150000000E+04, 2.6307615313E+01, 5.2465051676E+00, 9.7337436286E+00, 3.0179543468E+00, 9.4164374725E-01],
	[3.3155000000E+04, 2.6314320716E+01, 5.2465165139E+00, 9.7385237319E+00, 3.0185057165E+00, 9.4167131386E-01],
	[3.3160000000E+04, 2.6321026817E+01, 5.2465278585E+00, 9.7433054602E+00, 3.0190569565E+00, 9.4169886643E-01],
	[3.3165000000E+04, 2.6327733616E+01, 5.2465392014E+00, 9.7480888140E+00, 3.0196080666E+00, 9.4172640496E-01],
	[3.3170000000E+04, 2.6334441112E+01, 5.2465505426E+00, 9.7528737935E+00, 3.0201590468E+00, 9.4175392946E-01],
	[3.3175000000E+04, 2.6341149305E+01, 5.2465618822E+00, 9.7576603990E+00, 3.0207098973E+00, 9.4178143994E-01],
	[3.3180000000E+04, 2.6347858196E+01, 5.2465732201E+00, 9.7624486308E+00, 3.0212606179E+00, 9.4180893640E-01],
	[3.3185000000E+04, 2.6354567784E+01, 5.2465845562E+00, 9.7672384893E+00, 3.0218112086E+00, 9.4183641886E-01],
	[3.3190000000E+04, 2.6361278070E+01, 5.2465958907E+00, 9.7720299747E+00, 3.0223616696E+00, 9.4186388731E-01],
	[3.3195000000E+04, 2.6367989053E+01, 5.2466072236E+00, 9.7768230873E+00, 3.0229120007E+00, 9.4189134177E-01],
	[3.3200000000E+04, 2.6374700733E+01, 5.2466185547E+00, 9.7816178275E+00, 3.0234622020E+00, 9.4191878223E-01],
	[3.3205000000E+04, 2.6381413111E+01, 5.2466298841E+00, 9.7864141955E+00, 3.0240122734E+00, 9.4194620872E-01],
	[3.3210000000E+04, 2.6388126186E+01, 5.2466412119E+00, 9.7912121917E+00, 3.0245622151E+00, 9.4197362124E-01],
	[3.3215000000E+04, 2.6394839958E+01, 5.2466525380E+00, 9.7960118164E+00, 3.0251120269E+00, 9.4200101979E-01],
	[3.3220000000E+04, 2.6401554427E+01, 5.2466638624E+00, 9.8008130698E+00, 3.0256617089E+00, 9.4202840439E-01],
	[3.3225000000E+04, 2.6408269593E+01, 5.2466751851E+00, 9.8056159523E+00, 3.0262112611E+00, 9.4205577503E-01],
	[3.3230000000E+04, 2.6414985457E+01, 5.2466865062E+00, 9.8104204642E+00, 3.0267606834E+00, 9.4208313173E-01],
	[3.3235000000E+04, 2.6421702018E+01, 5.2466978255E+00, 9.8152266058E+00, 3.0273099760E+00, 9.4211047449E-01],
	[3.3240000000E+04, 2.6428419275E+01, 5.2467091432E+00, 9.8200343774E+00, 3.0278591387E+00, 9.4213780333E-01],
	[3.3245000000E+04, 2.6435137230E+01, 5.2467204593E+00, 9.8248437793E+00, 3.0284081716E+00, 9.4216511824E-01],
	[3.3250000000E+04, 2.6441855882E+01, 5.2467317736E+00, 9.8296548118E+00, 3.0289570748E+00, 9.4219241924E-01],
	[3.3255000000E+04, 2.6448575230E+01, 5.2467430863E+00, 9.8344674753E+00, 3.0295058481E+00, 9.4221970633E-01],
	[3.3260000000E+04, 2.6455295276E+01, 5.2467543972E+00, 9.8392817699E+00, 3.0300544916E+00, 9.4224697952E-01],
	[3.3265000000E+04, 2.6462016018E+01, 5.2467657065E+00, 9.8440976962E+00, 3.0306030053E+00, 9.4227423881E-01],
	[3.3270000000E+04, 2.6468737457E+01, 5.2467770142E+00, 9.8489152542E+00, 3.0311513892E+00, 9.4230148423E-01],
	[3.3275000000E+04, 2.6475459594E+01, 5.2467883201E+00, 9.8537344444E+00, 3.0316996433E+00, 9.4232871576E-01],
	[3.3280000000E+04, 2.6482182426E+01, 5.2467996244E+00, 9.8585552671E+00, 3.0322477676E+00, 9.4235593342E-01],
	[3.3285000000E+04, 2.6488905956E+01, 5.2468109270E+00, 9.8633777225E+00, 3.0327957621E+00, 9.4238313722E-01],
	[3.3290000000E+04, 2.6495630182E+01, 5.2468222280E+00, 9.8682018110E+00, 3.0333436268E+00, 9.4241032716E-01],
	[3.3295000000E+04, 2.6502355106E+01, 5.2468335272E+00, 9.8730275329E+00, 3.0338913617E+00, 9.4243750326E-01],
	[3.3300000000E+04, 2.6509080725E+01, 5.2468448248E+00, 9.8778548885E+00, 3.0344389669E+00, 9.4246466551E-01],
	[3.3305000000E+04, 2.6515807042E+01, 5.2468561207E+00, 9.8826838781E+00, 3.0349864422E+00, 9.4249181392E-01],
	[3.3310000000E+04, 2.6522534055E+01, 5.2468674150E+00, 9.8875145020E+00, 3.0355337878E+00, 9.4251894851E-01],
	[3.3315000000E+04, 2.6529261764E+01, 5.2468787076E+00, 9.8923467604E+00, 3.0360810036E+00, 9.4254606928E-01],
	[3.3320000000E+04, 2.6535990170E+01, 5.2468899985E+00, 9.8971806538E+00, 3.0366280896E+00, 9.4257317624E-01],
	[3.3325000000E+04, 2.6542719273E+01, 5.2469012877E+00, 9.9020161825E+00, 3.0371750458E+00, 9.4260026939E-01],
	[3.3330000000E+04, 2.6549449072E+01, 5.2469125753E+00, 9.9068533466E+00, 3.0377218723E+00, 9.4262734874E-01],
	[3.3335000000E+04, 2.6556179567E+01, 5.2469238612E+00, 9.9116921466E+00, 3.0382685690E+00, 9.4265441430E-01],
	[3.3340000000E+04, 2.6562910759E+01, 5.2469351454E+00, 9.9165325827E+00, 3.0388151359E+00, 9.4268146607E-01],
	[3.3345000000E+04, 2.6569642647E+01, 5.2469464279E+00, 9.9213746553E+00, 3.0393615731E+00, 9.4270850407E-01],
	[3.3350000000E+04, 2.6576375232E+01, 5.2469577088E+00, 9.9262183647E+00, 3.0399078805E+00, 9.4273552830E-01],
	[3.3355000000E+04, 2.6583108513E+01, 5.2469689881E+00, 9.9310637111E+00, 3.0404540581E+00, 9.4276253877E-01],
	[3.3360000000E+04, 2.6589842490E+01, 5.2469802656E+00, 9.9359106948E+00, 3.0410001060E+00, 9.4278953548E-01],
	[3.3365000000E+04, 2.6596577163E+01, 5.2469915415E+00, 9.9407593163E+00, 3.0415460241E+00, 9.4281651844E-01],
	[3.3370000000E+04, 2.6603312533E+01, 5.2470028158E+00, 9.9456095758E+00, 3.0420918125E+00, 9.4284348766E-01],
	[3.3375000000E+04, 2.6610048599E+01, 5.2470140883E+00, 9.9504614735E+00, 3.0426374711E+00, 9.4287044315E-01],
	[3.3380000000E+04, 2.6616785361E+01, 5.2470253592E+00, 9.9553150099E+00, 3.0431830000E+00, 9.4289738491E-01],
	[3.3385000000E+04, 2.6623522819E+01, 5.2470366285E+00, 9.9601701851E+00, 3.0437283991E+00, 9.4292431296E-01],
	[3.3390000000E+04, 2.6630260973E+01, 5.2470478960E+00, 9.9650269996E+00, 3.0442736685E+00, 9.4295122729E-01],
	[3.3395000000E+04, 2.6636999823E+01, 5.2470591619E+00, 9.9698854536E+00, 3.0448188081E+00, 9.4297812792E-01],
	[3.3400000000E+04, 2.6643739369E+01, 5.2470704262E+00, 9.9747455474E+00, 3.0453638180E+00, 9.4300501485E-01],
	[3.3405000000E+04, 2.6650479611E+01, 5.2470816888E+00, 9.9796072814E+00, 3.0459086982E+00, 9.4303188809E-01],
	[3.3410000000E+04, 2.6657220549E+01, 5.2470929497E+00, 9.9844706558E+00, 3.0464534487E+00, 9.4305874764E-01],
	[3.3415000000E+04, 2.6663962183E+01, 5.2471042090E+00, 9.9893356710E+00, 3.0469980694E+00, 9.4308559352E-01],
	[3.3420000000E+04, 2.6670704513E+01, 5.2471154666E+00, 9.9942023272E+00, 3.0475425604E+00, 9.4311242574E-01],
	[3.3425000000E+04, 2.6677447539E+01, 5.2471267225E+00, 9.9990706248E+00, 3.0480869217E+00, 9.4313924429E-01],
	[3.3430000000E+04, 2.6684191260E+01, 5.2471379768E+00, 1.0003940564E+01, 3.0486311532E+00, 9.4316604918E-01],
	[3.3435000000E+04, 2.6690935678E+01, 5.2471492294E+00, 1.0008812145E+01, 3.0491752551E+00, 9.4319284043E-01],
	[3.3440000000E+04, 2.6697680791E+01, 5.2471604804E+00, 1.0013685369E+01, 3.0497192272E+00, 9.4321961804E-01],
	[3.3445000000E+04, 2.6704426600E+01, 5.2471717297E+00, 1.0018560235E+01, 3.0502630697E+00, 9.4324638202E-01],
	[3.3450000000E+04, 2.6711192873E+01, 5.2471856051E+00, 1.0023436744E+01, 3.0508079286E+00, 9.4327313237E-01],
	[3.3455000000E+04, 2.6717960782E+01, 5.2471996025E+00, 1.0028314896E+01, 3.0513527124E+00, 9.4329986911E-01],
	[3.3460000000E+04, 2.6724729395E+01, 5.2472135978E+00, 1.0033194692E+01, 3.0518973671E+00, 9.4332659223E-01],
	[3.3465000000E+04, 2.6731498710E+01, 5.2472275911E+00, 1.0038076132E+01, 3.0524418927E+00, 9.4335330175E-01],
	[3.3470000000E+04, 2.6738268729E+01, 5.2472415824E+00, 1.0042959216E+01, 3.0529862891E+00, 9.4337999767E-01],
	[3.3475000000E+04, 2.6745039450E+01, 5.2472555716E+00, 1.0047843944E+01, 3.0535305563E+00, 9.4340668000E-01],
	[3.3480000000E+04, 2.6751810874E+01, 5.2472695587E+00, 1.0052730317E+01, 3.0540746944E+00, 9.4343334876E-01],
	[3.3485000000E+04, 2.6758583001E+01, 5.2472835438E+00, 1.0057618335E+01, 3.0546187033E+00, 9.4346000393E-01],
	[3.3490000000E+04, 2.6765355831E+01, 5.2472975268E+00, 1.0062507998E+01, 3.0551625831E+00, 9.4348664554E-01],
	[3.3495000000E+04, 2.6772129364E+01, 5.2473115078E+00, 1.0067399307E+01, 3.0557063337E+00, 9.4351327359E-01],
	[3.3500000000E+04, 2.6778903599E+01, 5.2473254868E+00, 1.0072292262E+01, 3.0562499553E+00, 9.4353988808E-01],
	[3.3505000000E+04, 2.6785678537E+01, 5.2473394637E+00, 1.0077186864E+01, 3.0567934477E+00, 9.4356648903E-01],
	[3.3510000000E+04, 2.6792454178E+01, 5.2473534385E+00, 1.0082083111E+01, 3.0573368109E+00, 9.4359307644E-01],
	[3.3515000000E+04, 2.6799230522E+01, 5.2473674113E+00, 1.0086981006E+01, 3.0578800451E+00, 9.4361965032E-01],
	[3.3520000000E+04, 2.6806007568E+01, 5.2473813820E+00, 1.0091880548E+01, 3.0584231501E+00, 9.4364621068E-01],
	[3.3525000000E+04, 2.6812785316E+01, 5.2473953508E+00, 1.0096781738E+01, 3.0589661260E+00, 9.4367275751E-01],
	[3.3530000000E+04, 2.6819563767E+01, 5.2474093174E+00, 1.0101684575E+01, 3.0595089728E+00, 9.4369929084E-01],
	[3.3535000000E+04, 2.6826342921E+01, 5.2474232820E+00, 1.0106589061E+01, 3.0600516904E+00, 9.4372581066E-01],
	[3.3540000000E+04, 2.6833122777E+01, 5.2474372446E+00, 1.0111495195E+01, 3.0605942790E+00, 9.4375231699E-01],
	[3.3545000000E+04, 2.6839903336E+01, 5.2474512051E+00, 1.0116402977E+01, 3.0611367385E+00, 9.4377880982E-01],
	[3.3550000000E+04, 2.6846684597E+01, 5.2474651636E+00, 1.0121312409E+01, 3.0616790689E+00, 9.4380528918E-01],
	[3.3555000000E+04, 2.6853466561E+01, 5.2474791200E+00, 1.0126223490E+01, 3.0622212701E+00, 9.4383175506E-01],
	[3.3560000000E+04, 2.6860249227E+01, 5.2474930744E+00, 1.0131136221E+01, 3.0627633423E+00, 9.4385820748E-01],
	[3.3565000000E+04, 2.6867032595E+01, 5.2475070267E+00, 1.0136050602E+01, 3.0633052854E+00, 9.4388464643E-01],
	[3.3570000000E+04, 2.6873816665E+01, 5.2475209771E+00, 1.0140966633E+01, 3.0638470994E+00, 9.4391107194E-01],
	[3.3575000000E+04, 2.6880601438E+01, 5.2475349253E+00, 1.0145884315E+01, 3.0643887844E+00, 9.4393748399E-01],
	[3.3580000000E+04, 2.6887386913E+01, 5.2475488716E+00, 1.0150803647E+01, 3.0649303402E+00, 9.4396388261E-01],
	[3.3585000000E+04, 2.6894173090E+01, 5.2475628157E+00, 1.0155724631E+01, 3.0654717670E+00, 9.4399026780E-01],
	[3.3590000000E+04, 2.6900959970E+01, 5.2475767579E+00, 1.0160647266E+01, 3.0660130647E+00, 9.4401663956E-01],
	[3.3595000000E+04, 2.6907747551E+01, 5.2475906980E+00, 1.0165571553E+01, 3.0665542334E+00, 9.4404299791E-01],
	[3.3600000000E+04, 2.6914535835E+01, 5.2476046361E+00, 1.0170497493E+01, 3.0670952730E+00, 9.4406934284E-01],
	[3.3605000000E+04, 2.6921324821E+01, 5.2476185721E+00, 1.0175425084E+01, 3.0676361835E+00, 9.4409567438E-01],
	[3.3610000000E+04, 2.6928114509E+01, 5.2476325061E+00, 1.0180354329E+01, 3.0681769650E+00, 9.4412199251E-01],
	[3.3615000000E+04, 2.6934904898E+01, 5.2476464381E+00, 1.0185285226E+01, 3.0687176175E+00, 9.4414829726E-01],
	[3.3620000000E+04, 2.6941695990E+01, 5.2476603680E+00, 1.0190217777E+01, 3.0692581409E+00, 9.4417458863E-01],
	[3.3625000000E+04, 2.6948487784E+01, 5.2476742959E+00, 1.0195151982E+01, 3.0697985352E+00, 9.4420086662E-01],
	[3.3630000000E+04, 2.6955280280E+01, 5.2476882218E+00, 1.0200087840E+01, 3.0703388006E+00, 9.4422713125E-01],
	[3.3635000000E+04, 2.6962073477E+01, 5.2477021456E+00, 1.0205025353E+01, 3.0708789369E+00, 9.4425338252E-01],
	[3.3640000000E+04, 2.6968867377E+01, 5.2477160674E+00, 1.0209964521E+01, 3.0714189442E+00, 9.4427962043E-01],
	[3.3645000000E+04, 2.6975661978E+01, 5.2477299871E+00, 1.0214905343E+01, 3.0719588224E+00, 9.4430584500E-01],
	[3.3650000000E+04, 2.6982457281E+01, 5.2477439049E+00, 1.0219847821E+01, 3.0724985717E+00, 9.4433205623E-01],
	[3.3655000000E+04, 2.6989253286E+01, 5.2477578206E+00, 1.0224791954E+01, 3.0730381919E+00, 9.4435825413E-01],
	[3.3660000000E+04, 2.6996049992E+01, 5.2477717343E+00, 1.0229737743E+01, 3.0735776831E+00, 9.4438443871E-01],
	[3.3665000000E+04, 2.7002847400E+01, 5.2477856459E+00, 1.0234685188E+01, 3.0741170453E+00, 9.4441060996E-01],
	[3.3670000000E+04, 2.7009645510E+01, 5.2477995555E+00, 1.0239634289E+01, 3.0746562786E+00, 9.4443676791E-01],
	[3.3675000000E+04, 2.7016444322E+01, 5.2478134631E+00, 1.0244585047E+01, 3.0751953828E+00, 9.4446291254E-01],
	[3.3680000000E+04, 2.7023243835E+01, 5.2478273686E+00, 1.0249537463E+01, 3.0757343580E+00, 9.4448904388E-01],
	[3.3685000000E+04, 2.7030044050E+01, 5.2478412722E+00, 1.0254491535E+01, 3.0762732043E+00, 9.4451516192E-01],
	[3.3690000000E+04, 2.7036844966E+01, 5.2478551737E+00, 1.0259447266E+01, 3.0768119216E+00, 9.4454126668E-01],
	[3.3695000000E+04, 2.7043646584E+01, 5.2478690731E+00, 1.0264404654E+01, 3.0773505099E+00, 9.4456735815E-01],
	[3.3700000000E+04, 2.7050448903E+01, 5.2478829706E+00, 1.0269363701E+01, 3.0778889692E+00, 9.4459343636E-01],
	[3.3705000000E+04, 2.7057251923E+01, 5.2478968660E+00, 1.0274324406E+01, 3.0784272996E+00, 9.4461950129E-01],
	[3.3710000000E+04, 2.7064055645E+01, 5.2479107594E+00, 1.0279286770E+01, 3.0789655010E+00, 9.4464555296E-01],
	[3.3715000000E+04, 2.7070860069E+01, 5.2479246508E+00, 1.0284250793E+01, 3.0795035734E+00, 9.4467159137E-01],
	[3.3720000000E+04, 2.7077665194E+01, 5.2479385401E+00, 1.0289216476E+01, 3.0800415169E+00, 9.4469761654E-01],
	[3.3725000000E+04, 2.7084471020E+01, 5.2479524275E+00, 1.0294183819E+01, 3.0805793315E+00, 9.4472362846E-01],
	[3.3730000000E+04, 2.7091277547E+01, 5.2479663128E+00, 1.0299152822E+01, 3.0811170171E+00, 9.4474962714E-01],
	[3.3735000000E+04, 2.7098084776E+01, 5.2479801961E+00, 1.0304123485E+01, 3.0816545738E+00, 9.4477561260E-01],
	[3.3740000000E+04, 2.7104892706E+01, 5.2479940773E+00, 1.0309095809E+01, 3.0821920015E+00, 9.4480158483E-01],
	[3.3745000000E+04, 2.7111701337E+01, 5.2480079566E+00, 1.0314069794E+01, 3.0827293004E+00, 9.4482754384E-01],
	[3.3750000000E+04, 2.7118510669E+01, 5.2480218338E+00, 1.0319045441E+01, 3.0832664703E+00, 9.4485348965E-01],
	[3.3755000000E+04, 2.7125320702E+01, 5.2480357090E+00, 1.0324022749E+01, 3.0838035112E+00, 9.4487942224E-01],
	[3.3760000000E+04, 2.7132131437E+01, 5.2480495822E+00, 1.0329001719E+01, 3.0843404233E+00, 9.4490534164E-01],
	[3.3765000000E+04, 2.7138942872E+01, 5.2480634534E+00, 1.0333982352E+01, 3.0848772065E+00, 9.4493124785E-01],
	[3.3770000000E+04, 2.7145755009E+01, 5.2480773225E+00, 1.0338964647E+01, 3.0854138608E+00, 9.4495714087E-01],
	[3.3775000000E+04, 2.7152567846E+01, 5.2480911897E+00, 1.0343948605E+01, 3.0859503862E+00, 9.4498302071E-01],
	[3.3780000000E+04, 2.7159381385E+01, 5.2481050548E+00, 1.0348934226E+01, 3.0864867826E+00, 9.4500888738E-01],
	[3.3785000000E+04, 2.7166195624E+01, 5.2481189179E+00, 1.0353921511E+01, 3.0870230503E+00, 9.4503474088E-01],
	[3.3790000000E+04, 2.7173010564E+01, 5.2481327790E+00, 1.0358910459E+01, 3.0875591890E+00, 9.4506058122E-01],
	[3.3795000000E+04, 2.7179826206E+01, 5.2481466380E+00, 1.0363901072E+01, 3.0880951988E+00, 9.4508640841E-01],
	[3.3800000000E+04, 2.7186642548E+01, 5.2481604951E+00, 1.0368893349E+01, 3.0886310798E+00, 9.4511222245E-01],
	[3.3805000000E+04, 2.7193459590E+01, 5.2481743502E+00, 1.0373887291E+01, 3.0891668319E+00, 9.4513802335E-01],
	[3.3810000000E+04, 2.7200277334E+01, 5.2481882032E+00, 1.0378882898E+01, 3.0897024552E+00, 9.4516381111E-01],
	[3.3815000000E+04, 2.7207095778E+01, 5.2482020542E+00, 1.0383880171E+01, 3.0902379496E+00, 9.4518958575E-01],
	[3.3820000000E+04, 2.7213914924E+01, 5.2482159032E+00, 1.0388879109E+01, 3.0907733152E+00, 9.4521534726E-01],
	[3.3825000000E+04, 2.7220734769E+01, 5.2482297502E+00, 1.0393879713E+01, 3.0913085519E+00, 9.4524109566E-01],
	[3.3830000000E+04, 2.7227555316E+01, 5.2482435952E+00, 1.0398881983E+01, 3.0918436598E+00, 9.4526683094E-01],
	[3.3835000000E+04, 2.7234376563E+01, 5.2482574382E+00, 1.0403885920E+01, 3.0923786389E+00, 9.4529255313E-01],
	[3.3840000000E+04, 2.7241198510E+01, 5.2482712792E+00, 1.0408891524E+01, 3.0929134892E+00, 9.4531826222E-01],
	[3.3845000000E+04, 2.7248021159E+01, 5.2482851181E+00, 1.0413898795E+01, 3.0934482106E+00, 9.4534395821E-01],
	[3.3850000000E+04, 2.7254844507E+01, 5.2482989551E+00, 1.0418907734E+01, 3.0939828032E+00, 9.4536964112E-01],
	[3.3855000000E+04, 2.7261668557E+01, 5.2483127900E+00, 1.0423918341E+01, 3.0945172670E+00, 9.4539531096E-01],
	[3.3860000000E+04, 2.7268493306E+01, 5.2483266230E+00, 1.0428930615E+01, 3.0950516020E+00, 9.4542096772E-01],
	[3.3865000000E+04, 2.7275318756E+01, 5.2483404539E+00, 1.0433944559E+01, 3.0955858083E+00, 9.4544661142E-01],
	[3.3870000000E+04, 2.7282144907E+01, 5.2483542829E+00, 1.0438960171E+01, 3.0961198857E+00, 9.4547224206E-01],
	[3.3875000000E+04, 2.7288971758E+01, 5.2483681098E+00, 1.0443977452E+01, 3.0966538343E+00, 9.4549785965E-01],
	[3.3880000000E+04, 2.7295799309E+01, 5.2483819347E+00, 1.0448996402E+01, 3.0971876542E+00, 9.4552346419E-01],
	[3.3885000000E+04, 2.7302627560E+01, 5.2483957576E+00, 1.0454017022E+01, 3.0977213453E+00, 9.4554905569E-01],
	[3.3890000000E+04, 2.7309456512E+01, 5.2484095785E+00, 1.0459039312E+01, 3.0982549076E+00, 9.4557463416E-01],
	[3.3895000000E+04, 2.7316286164E+01, 5.2484233975E+00, 1.0464063273E+01, 3.0987883412E+00, 9.4560019960E-01],
	[3.3900000000E+04, 2.7323116516E+01, 5.2484372144E+00, 1.0469088904E+01, 3.0993216461E+00, 9.4562575202E-01],
	[3.3905000000E+04, 2.7329947569E+01, 5.2484510293E+00, 1.0474116206E+01, 3.0998548221E+00, 9.4565129143E-01],
	[3.3910000000E+04, 2.7336779321E+01, 5.2484648422E+00, 1.0479145179E+01, 3.1003878695E+00, 9.4567681783E-01],
	[3.3915000000E+04, 2.7343611774E+01, 5.2484786531E+00, 1.0484175824E+01, 3.1009207881E+00, 9.4570233123E-01],
	[3.3920000000E+04, 2.7350444927E+01, 5.2484924620E+00, 1.0489208141E+01, 3.1014535780E+00, 9.4572783163E-01],
	[3.3925000000E+04, 2.7357278780E+01, 5.2485062689E+00, 1.0494242129E+01, 3.1019862391E+00, 9.4575331905E-01],
	[3.3930000000E+04, 2.7364113332E+01, 5.2485200738E+00, 1.0499277791E+01, 3.1025187716E+00, 9.4577879348E-01],
	[3.3935000000E+04, 2.7370948585E+01, 5.2485338767E+00, 1.0504315125E+01, 3.1030511753E+00, 9.4580425493E-01],
	[3.3940000000E+04, 2.7377784538E+01, 5.2485476777E+00, 1.0509354132E+01, 3.1035834503E+00, 9.4582970342E-01],
	[3.3945000000E+04, 2.7384621191E+01, 5.2485614766E+00, 1.0514394813E+01, 3.1041155967E+00, 9.4585513894E-01],
	[3.3950000000E+04, 2.7391458543E+01, 5.2485752735E+00, 1.0519437167E+01, 3.1046476143E+00, 9.4588056151E-01],
	[3.3955000000E+04, 2.7398296596E+01, 5.2485890684E+00, 1.0524481195E+01, 3.1051795033E+00, 9.4590597113E-01],
	[3.3960000000E+04, 2.7405135348E+01, 5.2486028614E+00, 1.0529526898E+01, 3.1057112636E+00, 9.4593136780E-01],
	[3.3965000000E+04, 2.7411974800E+01, 5.2486166523E+00, 1.0534574275E+01, 3.1062428952E+00, 9.4595675153E-01],
	[3.3970000000E+04, 2.7418814952E+01, 5.2486304412E+00, 1.0539623327E+01, 3.1067743981E+00, 9.4598212233E-01],
	[3.3975000000E+04, 2.7425655804E+01, 5.2486442282E+00, 1.0544674055E+01, 3.1073057724E+00, 9.4600748021E-01],
	[3.3980000000E+04, 2.7432497355E+01, 5.2486580132E+00, 1.0549726458E+01, 3.1078370181E+00, 9.4603282517E-01],
	[3.3985000000E+04, 2.7439345138E+01, 5.2486725258E+00, 1.0554780537E+01, 3.1083684620E+00, 9.4605815722E-01],
	[3.3990000000E+04, 2.7446208555E+01, 5.2486890049E+00, 1.0559836292E+01, 3.1089006596E+00, 9.4608347636E-01],
	[3.3995000000E+04, 2.7453072678E+01, 5.2487054817E+00, 1.0564893723E+01, 3.1094327292E+00, 9.4610878260E-01],
	[3.4000000000E+04, 2.7459937508E+01, 5.2487219562E+00, 1.0569952832E+01, 3.1099646706E+00, 9.4613407595E-01],
	[3.4005000000E+04, 2.7466803044E+01, 5.2487384282E+00, 1.0575013617E+01, 3.1104964840E+00, 9.4615935641E-01],
	[3.4010000000E+04, 2.7473669288E+01, 5.2487548979E+00, 1.0580076080E+01, 3.1110281692E+00, 9.4618462399E-01],
	[3.4015000000E+04, 2.7480536238E+01, 5.2487713652E+00, 1.0585140221E+01, 3.1115597263E+00, 9.4620987869E-01],
	[3.4020000000E+04, 2.7487403894E+01, 5.2487878302E+00, 1.0590206039E+01, 3.1120911554E+00, 9.4623512053E-01],
	[3.4025000000E+04, 2.7494272258E+01, 5.2488042928E+00, 1.0595273536E+01, 3.1126224564E+00, 9.4626034951E-01],
	[3.4030000000E+04, 2.7501141328E+01, 5.2488207530E+00, 1.0600342712E+01, 3.1131536293E+00, 9.4628556563E-01],
	[3.4035000000E+04, 2.7508011104E+01, 5.2488372108E+00, 1.0605413567E+01, 3.1136846741E+00, 9.4631076891E-01],
	[3.4040000000E+04, 2.7514881587E+01, 5.2488536663E+00, 1.0610486100E+01, 3.1142155909E+00, 9.4633595934E-01],
	[3.4045000000E+04, 2.7521752777E+01, 5.2488701194E+00, 1.0615560314E+01, 3.1147463796E+00, 9.4636113693E-01],
	[3.4050000000E+04, 2.7528624673E+01, 5.2488865702E+00, 1.0620636207E+01, 3.1152770403E+00, 9.4638630170E-01],
	[3.4055000000E+04, 2.7535497275E+01, 5.2489030186E+00, 1.0625713781E+01, 3.1158075729E+00, 9.4641145364E-01],
	[3.4060000000E+04, 2.7542370584E+01, 5.2489194646E+00, 1.0630793035E+01, 3.1163379775E+00, 9.4643659277E-01],
	[3.4065000000E+04, 2.7549244600E+01, 5.2489359083E+00, 1.0635873969E+01, 3.1168682541E+00, 9.4646171908E-01],
	[3.4070000000E+04, 2.7556119321E+01, 5.2489523496E+00, 1.0640956585E+01, 3.1173984026E+00, 9.4648683259E-01],
	[3.4075000000E+04, 2.7562994749E+01, 5.2489687885E+00, 1.0646040883E+01, 3.1179284232E+00, 9.4651193330E-01],
	[3.4080000000E+04, 2.7569870883E+01, 5.2489852251E+00, 1.0651126862E+01, 3.1184583157E+00, 9.4653702123E-01],
	[3.4085000000E+04, 2.7576747724E+01, 5.2490016593E+00, 1.0656214523E+01, 3.1189880803E+00, 9.4656209636E-01],
	[3.4090000000E+04, 2.7583625271E+01, 5.2490180911E+00, 1.0661303866E+01, 3.1195177168E+00, 9.4658715872E-01],
	[3.4095000000E+04, 2.7590503524E+01, 5.2490345206E+00, 1.0666394892E+01, 3.1200472254E+00, 9.4661220831E-01],
	[3.4100000000E+04, 2.7597382483E+01, 5.2490509478E+00, 1.0671487602E+01, 3.1205766060E+00, 9.4663724513E-01],
	[3.4105000000E+04, 2.7604262148E+01, 5.2490673726E+00, 1.0676581994E+01, 3.1211058586E+00, 9.4666226919E-01],
	[3.4110000000E+04, 2.7611142520E+01, 5.2490837950E+00, 1.0681678070E+01, 3.1216349833E+00, 9.4668728049E-01],
	[3.4115000000E+04, 2.7618023597E+01, 5.2491002151E+00, 1.0686775830E+01, 3.1221639800E+00, 9.4671227905E-01],
	[3.4120000000E+04, 2.7624905380E+01, 5.2491166328E+00, 1.0691875274E+01, 3.1226928488E+00, 9.4673726487E-01],
	[3.4125000000E+04, 2.7631787870E+01, 5.2491330482E+00, 1.0696976403E+01, 3.1232215896E+00, 9.4676223796E-01],
	[3.4130000000E+04, 2.7638671065E+01, 5.2491494612E+00, 1.0702079216E+01, 3.1237502025E+00, 9.4678719832E-01],
	[3.4135000000E+04, 2.7645554967E+01, 5.2491658718E+00, 1.0707183715E+01, 3.1242786874E+00, 9.4681214595E-01],
	[3.4140000000E+04, 2.7652439574E+01, 5.2491822801E+00, 1.0712289899E+01, 3.1248070445E+00, 9.4683708088E-01],
	[3.4145000000E+04, 2.7659324888E+01, 5.2491986861E+00, 1.0717397768E+01, 3.1253352736E+00, 9.4686200309E-01],
	[3.4150000000E+04, 2.7666210907E+01, 5.2492150897E+00, 1.0722507324E+01, 3.1258633748E+00, 9.4688691260E-01],
	[3.4155000000E+04, 2.7673097632E+01, 5.2492314909E+00, 1.0727618567E+01, 3.1263913481E+00, 9.4691180941E-01],
	[3.4160000000E+04, 2.7679985062E+01, 5.2492478898E+00, 1.0732731495E+01, 3.1269191936E+00, 9.4693669354E-01],
	[3.4165000000E+04, 2.7686873199E+01, 5.2492642864E+00, 1.0737846111E+01, 3.1274469111E+00, 9.4696156498E-01],
	[3.4170000000E+04, 2.7693762041E+01, 5.2492806806E+00, 1.0742962414E+01, 3.1279745008E+00, 9.4698642374E-01],
	[3.4175000000E+04, 2.7700651589E+01, 5.2492970725E+00, 1.0748080405E+01, 3.1285019626E+00, 9.4701126984E-01],
	[3.4180000000E+04, 2.7707541843E+01, 5.2493134620E+00, 1.0753200084E+01, 3.1290292966E+00, 9.4703610327E-01],
	[3.4185000000E+04, 2.7714432802E+01, 5.2493298491E+00, 1.0758321451E+01, 3.1295565027E+00, 9.4706092404E-01],
	[3.4190000000E+04, 2.7721324467E+01, 5.2493462339E+00, 1.0763444506E+01, 3.1300835809E+00, 9.4708573216E-01],
	[3.4195000000E+04, 2.7728216837E+01, 5.2493626164E+00, 1.0768569251E+01, 3.1306105314E+00, 9.4711052764E-01],
	[3.4200000000E+04, 2.7735109913E+01, 5.2493789966E+00, 1.0773695684E+01, 3.1311373539E+00, 9.4713531048E-01],
	[3.4205000000E+04, 2.7742003695E+01, 5.2493953743E+00, 1.0778823807E+01, 3.1316640487E+00, 9.4716008068E-01],
	[3.4210000000E+04, 2.7748898182E+01, 5.2494117498E+00, 1.0783953620E+01, 3.1321906157E+00, 9.4718483826E-01],
	[3.4215000000E+04, 2.7755793374E+01, 5.2494281229E+00, 1.0789085123E+01, 3.1327170548E+00, 9.4720958322E-01],
	[3.4220000000E+04, 2.7762689272E+01, 5.2494444936E+00, 1.0794218316E+01, 3.1332433662E+00, 9.4723431557E-01],
	[3.4225000000E+04, 2.7769585875E+01, 5.2494608621E+00, 1.0799353200E+01, 3.1337695497E+00, 9.4725903531E-01],
	[3.4230000000E+04, 2.7776483184E+01, 5.2494772281E+00, 1.0804489775E+01, 3.1342956055E+00, 9.4728374244E-01],
	[3.4235000000E+04, 2.7783381198E+01, 5.2494935919E+00, 1.0809628041E+01, 3.1348215335E+00, 9.4730843699E-01],
	[3.4240000000E+04, 2.7790279917E+01, 5.2495099533E+00, 1.0814767999E+01, 3.1353473338E+00, 9.4733311895E-01],
	[3.4245000000E+04, 2.7797179342E+01, 5.2495263123E+00, 1.0819909648E+01, 3.1358730062E+00, 9.4735778832E-01],
	[3.4250000000E+04, 2.7804079471E+01, 5.2495426691E+00, 1.0825052990E+01, 3.1363985510E+00, 9.4738244512E-01],
	[3.4255000000E+04, 2.7810980306E+01, 5.2495590235E+00, 1.0830198025E+01, 3.1369239679E+00, 9.4740708935E-01],
	[3.4260000000E+04, 2.7817881847E+01, 5.2495753755E+00, 1.0835344752E+01, 3.1374492572E+00, 9.4743172102E-01],
	[3.4265000000E+04, 2.7824784092E+01, 5.2495917252E+00, 1.0840493173E+01, 3.1379744187E+00, 9.4745634013E-01],
	[3.4270000000E+04, 2.7831687042E+01, 5.2496080726E+00, 1.0845643287E+01, 3.1384994525E+00, 9.4748094670E-01],
	[3.4275000000E+04, 2.7838590698E+01, 5.2496244177E+00, 1.0850795095E+01, 3.1390243586E+00, 9.4750554072E-01],
	[3.4280000000E+04, 2.7845495058E+01, 5.2496407604E+00, 1.0855948597E+01, 3.1395491370E+00, 9.4753012220E-01],
	[3.4285000000E+04, 2.7852400124E+01, 5.2496571008E+00, 1.0861103793E+01, 3.1400737877E+00, 9.4755469115E-01],
	[3.4290000000E+04, 2.7859305895E+01, 5.2496734388E+00, 1.0866260684E+01, 3.1405983107E+00, 9.4757924758E-01],
	[3.4295000000E+04, 2.7866212370E+01, 5.2496897745E+00, 1.0871419270E+01, 3.1411227060E+00, 9.4760379149E-01],
	[3.4300000000E+04, 2.7873119551E+01, 5.2497061079E+00, 1.0876579552E+01, 3.1416469737E+00, 9.4762832289E-01],
	[3.4305000000E+04, 2.7880027436E+01, 5.2497224390E+00, 1.0881741529E+01, 3.1421711137E+00, 9.4765284178E-01],
	[3.4310000000E+04, 2.7886936026E+01, 5.2497387677E+00, 1.0886905202E+01, 3.1426951260E+00, 9.4767734818E-01],
	[3.4315000000E+04, 2.7893845321E+01, 5.2497550941E+00, 1.0892070571E+01, 3.1432190107E+00, 9.4770184208E-01],
	[3.4320000000E+04, 2.7900755321E+01, 5.2497714182E+00, 1.0897237637E+01, 3.1437427678E+00, 9.4772632349E-01],
	[3.4325000000E+04, 2.7907666026E+01, 5.2497877399E+00, 1.0902406400E+01, 3.1442663972E+00, 9.4775079243E-01],
	[3.4330000000E+04, 2.7914577435E+01, 5.2498040594E+00, 1.0907576860E+01, 3.1447898991E+00, 9.4777524889E-01],
	[3.4335000000E+04, 2.7921489549E+01, 5.2498203764E+00, 1.0912749018E+01, 3.1453132733E+00, 9.4779969289E-01],
	[3.4340000000E+04, 2.7928402368E+01, 5.2498366912E+00, 1.0917922873E+01, 3.1458365199E+00, 9.4782412442E-01],
	[3.4345000000E+04, 2.7935315892E+01, 5.2498530037E+00, 1.0923098426E+01, 3.1463596389E+00, 9.4784854350E-01],
	[3.4350000000E+04, 2.7942230120E+01, 5.2498693138E+00, 1.0928275678E+01, 3.1468826303E+00, 9.4787295013E-01],
	[3.4355000000E+04, 2.7949145052E+01, 5.2498856216E+00, 1.0933454629E+01, 3.1474054941E+00, 9.4789734432E-01],
	[3.4360000000E+04, 2.7956060690E+01, 5.2499019270E+00, 1.0938635279E+01, 3.1479282304E+00, 9.4792172608E-01],
	[3.4365000000E+04, 2.7962977031E+01, 5.2499182302E+00, 1.0943817628E+01, 3.1484508391E+00, 9.4794609541E-01],
	[3.4370000000E+04, 2.7969894078E+01, 5.2499345310E+00, 1.0949001676E+01, 3.1489733203E+00, 9.4797045231E-01],
	[3.4375000000E+04, 2.7976811828E+01, 5.2499508295E+00, 1.0954187425E+01, 3.1494956739E+00, 9.4799479680E-01],
	[3.4380000000E+04, 2.7983730283E+01, 5.2499671257E+00, 1.0959374874E+01, 3.1500179000E+00, 9.4801912887E-01],
	[3.4385000000E+04, 2.7990649443E+01, 5.2499834196E+00, 1.0964564024E+01, 3.1505399986E+00, 9.4804344854E-01],
	[3.4390000000E+04, 2.7997569307E+01, 5.2499997112E+00, 1.0969754874E+01, 3.1510619696E+00, 9.4806775582E-01],
	[3.4395000000E+04, 2.8004489875E+01, 5.2500160004E+00, 1.0974947426E+01, 3.1515838132E+00, 9.4809205071E-01],
	[3.4400000000E+04, 2.8011411148E+01, 5.2500322873E+00, 1.0980141679E+01, 3.1521055292E+00, 9.4811633321E-01],
	[3.4405000000E+04, 2.8018333125E+01, 5.2500485719E+00, 1.0985337634E+01, 3.1526271177E+00, 9.4814060333E-01],
	[3.4410000000E+04, 2.8025255806E+01, 5.2500648542E+00, 1.0990535291E+01, 3.1531485788E+00, 9.4816486108E-01],
	[3.4415000000E+04, 2.8032179191E+01, 5.2500811342E+00, 1.0995734651E+01, 3.1536699124E+00, 9.4818910646E-01],
	[3.4420000000E+04, 2.8039103281E+01, 5.2500974118E+00, 1.1000935713E+01, 3.1541911185E+00, 9.4821333949E-01],
	[3.4425000000E+04, 2.8046028075E+01, 5.2501136871E+00, 1.1006138479E+01, 3.1547121972E+00, 9.4823756016E-01],
	[3.4430000000E+04, 2.8052953573E+01, 5.2501299602E+00, 1.1011342948E+01, 3.1552331485E+00, 9.4826176848E-01],
	[3.4435000000E+04, 2.8059879774E+01, 5.2501462309E+00, 1.1016549121E+01, 3.1557539722E+00, 9.4828596447E-01],
	[3.4440000000E+04, 2.8066806681E+01, 5.2501624993E+00, 1.1021756997E+01, 3.1562746686E+00, 9.4831014812E-01],
	[3.4445000000E+04, 2.8073734291E+01, 5.2501787654E+00, 1.1026966578E+01, 3.1567952376E+00, 9.4833431944E-01],
	[3.4450000000E+04, 2.8080662605E+01, 5.2501950292E+00, 1.1032177864E+01, 3.1573156791E+00, 9.4835847845E-01],
	[3.4455000000E+04, 2.8087591623E+01, 5.2502112906E+00, 1.1037390854E+01, 3.1578359933E+00, 9.4838262513E-01],
	[3.4460000000E+04, 2.8094521345E+01, 5.2502275498E+00, 1.1042605550E+01, 3.1583561800E+00, 9.4840675951E-01],
	[3.4465000000E+04, 2.8101451771E+01, 5.2502438067E+00, 1.1047821951E+01, 3.1588762394E+00, 9.4843088159E-01],
	[3.4470000000E+04, 2.8108382900E+01, 5.2502600612E+00, 1.1053040058E+01, 3.1593961714E+00, 9.4845499137E-01],
	[3.4475000000E+04, 2.8115314734E+01, 5.2502763134E+00, 1.1058259872E+01, 3.1599159760E+00, 9.4847908886E-01],
	[3.4480000000E+04, 2.8122247272E+01, 5.2502925634E+00, 1.1063481391E+01, 3.1604356533E+00, 9.4850317407E-01],
	[3.4485000000E+04, 2.8129180513E+01, 5.2503088110E+00, 1.1068704618E+01, 3.1609552032E+00, 9.4852724700E-01],
	[3.4490000000E+04, 2.8136114458E+01, 5.2503250563E+00, 1.1073929552E+01, 3.1614746258E+00, 9.4855130766E-01],
	[3.4495000000E+04, 2.8143049107E+01, 5.2503412993E+00, 1.1079156193E+01, 3.1619939211E+00, 9.4857535606E-01],
	[3.4500000000E+04, 2.8149984459E+01, 5.2503575400E+00, 1.1084384542E+01, 3.1625130890E+00, 9.4859939219E-01],
	[3.4505000000E+04, 2.8156920515E+01, 5.2503737784E+00, 1.1089614599E+01, 3.1630321297E+00, 9.4862341608E-01],
	[3.4510000000E+04, 2.8163857275E+01, 5.2503900145E+00, 1.1094846364E+01, 3.1635510430E+00, 9.4864742772E-01],
	[3.4515000000E+04, 2.8170794739E+01, 5.2504062483E+00, 1.1100079838E+01, 3.1640698291E+00, 9.4867142712E-01],
	[3.4520000000E+04, 2.8177732906E+01, 5.2504224799E+00, 1.1105315020E+01, 3.1645884879E+00, 9.4869541429E-01],
	[3.4525000000E+04, 2.8184671776E+01, 5.2504387091E+00, 1.1110551913E+01, 3.1651070194E+00, 9.4871938924E-01],
	[3.4530000000E+04, 2.8191611350E+01, 5.2504549360E+00, 1.1115790514E+01, 3.1656254236E+00, 9.4874335196E-01],
	[3.4535000000E+04, 2.8198568860E+01, 5.2504734157E+00, 1.1121030826E+01, 3.1661447380E+00, 9.4876730247E-01],
	[3.4540000000E+04, 2.8205530066E+01, 5.2504922837E+00, 1.1126272848E+01, 3.1666641052E+00, 9.4879124077E-01],
	[3.4545000000E+04, 2.8212491982E+01, 5.2505111489E+00, 1.1131516580E+01, 3.1671833458E+00, 9.4881516687E-01],
	[3.4550000000E+04, 2.8219454609E+01, 5.2505300116E+00, 1.1136762023E+01, 3.1677024596E+00, 9.4883908078E-01],
	[3.4555000000E+04, 2.8226417946E+01, 5.2505488715E+00, 1.1142009177E+01, 3.1682214466E+00, 9.4886298250E-01],
	[3.4560000000E+04, 2.8233381994E+01, 5.2505677288E+00, 1.1147258043E+01, 3.1687403070E+00, 9.4888687203E-01],
	[3.4565000000E+04, 2.8240346751E+01, 5.2505865834E+00, 1.1152508620E+01, 3.1692590406E+00, 9.4891074939E-01],
	[3.4570000000E+04, 2.8247312220E+01, 5.2506054354E+00, 1.1157760910E+01, 3.1697776476E+00, 9.4893461458E-01],
	[3.4575000000E+04, 2.8254278398E+01, 5.2506242847E+00, 1.1163014912E+01, 3.1702961279E+00, 9.4895846761E-01],
	[3.4580000000E+04, 2.8261245287E+01, 5.2506431313E+00, 1.1168270626E+01, 3.1708144815E+00, 9.4898230848E-01],
	[3.4585000000E+04, 2.8268212886E+01, 5.2506619753E+00, 1.1173528054E+01, 3.1713327084E+00, 9.4900613720E-01],
	[3.4590000000E+04, 2.8275181195E+01, 5.2506808167E+00, 1.1178787195E+01, 3.1718508087E+00, 9.4902995378E-01],
	[3.4595000000E+04, 2.8282150214E+01, 5.2506996554E+00, 1.1184048049E+01, 3.1723687823E+00, 9.4905375821E-01],
	[3.4600000000E+04, 2.8289119944E+01, 5.2507184914E+00, 1.1189310618E+01, 3.1728866293E+00, 9.4907755052E-01],
	[3.4605000000E+04, 2.8296090383E+01, 5.2507373248E+00, 1.1194574900E+01, 3.1734043497E+00, 9.4910133070E-01],
	[3.4610000000E+04, 2.8303061533E+01, 5.2507561555E+00, 1.1199840897E+01, 3.1739219434E+00, 9.4912509876E-01],
	[3.4615000000E+04, 2.8310033393E+01, 5.2507749835E+00, 1.1205108609E+01, 3.1744394106E+00, 9.4914885471E-01],
	[3.4620000000E+04, 2.8317005962E+01, 5.2507938090E+00, 1.1210378037E+01, 3.1749567511E+00, 9.4917259856E-01],
	[3.4625000000E+04, 2.8323979242E+01, 5.2508126317E+00, 1.1215649179E+01, 3.1754739651E+00, 9.4919633030E-01],
	[3.4630000000E+04, 2.8330953232E+01, 5.2508314518E+00, 1.1220922038E+01, 3.1759910525E+00, 9.4922004995E-01],
	[3.4635000000E+04, 2.8337927931E+01, 5.2508502693E+00, 1.1226196612E+01, 3.1765080133E+00, 9.4924375751E-01],
	[3.4640000000E+04, 2.8344903341E+01, 5.2508690841E+00, 1.1231472903E+01, 3.1770248475E+00, 9.4926745299E-01],
	[3.4645000000E+04, 2.8351879460E+01, 5.2508878963E+00, 1.1236750911E+01, 3.1775415552E+00, 9.4929113640E-01],
	[3.4650000000E+04, 2.8358856289E+01, 5.2509067058E+00, 1.1242030635E+01, 3.1780581364E+00, 9.4931480774E-01],
	[3.4655000000E+04, 2.8365833828E+01, 5.2509255127E+00, 1.1247312077E+01, 3.1785745910E+00, 9.4933846701E-01],
	[3.4660000000E+04, 2.8372812077E+01, 5.2509443169E+00, 1.1252595237E+01, 3.1790909191E+00, 9.4936211423E-01],
	[3.4665000000E+04, 2.8379791035E+01, 5.2509631185E+00, 1.1257880115E+01, 3.1796071207E+00, 9.4938574940E-01],
	[3.4670000000E+04, 2.8386770703E+01, 5.2509819174E+00, 1.1263166711E+01, 3.1801231958E+00, 9.4940937253E-01],
	[3.4675000000E+04, 2.8393751081E+01, 5.2510007137E+00, 1.1268455025E+01, 3.1806391445E+00, 9.4943298362E-01],
	[3.4680000000E+04, 2.8400732169E+01, 5.2510195074E+00, 1.1273745058E+01, 3.1811549666E+00, 9.4945658268E-01],
	[3.4685000000E+04, 2.8407713966E+01, 5.2510382984E+00, 1.1279036811E+01, 3.1816706623E+00, 9.4948016971E-01],
	[3.4690000000E+04, 2.8414696472E+01, 5.2510570867E+00, 1.1284330283E+01, 3.1821862315E+00, 9.4950374473E-01],
	[3.4695000000E+04, 2.8421679689E+01, 5.2510758725E+00, 1.1289625475E+01, 3.1827016743E+00, 9.4952730773E-01],
	[3.4700000000E+04, 2.8428663615E+01, 5.2510946555E+00, 1.1294922387E+01, 3.1832169906E+00, 9.4955085873E-01],
	[3.4705000000E+04, 2.8435648250E+01, 5.2511134360E+00, 1.1300221019E+01, 3.1837321805E+00, 9.4957439773E-01],
	[3.4710000000E+04, 2.8442633595E+01, 5.2511322138E+00, 1.1305521372E+01, 3.1842472440E+00, 9.4959792474E-01],
	[3.4715000000E+04, 2.8449619649E+01, 5.2511509890E+00, 1.1310823446E+01, 3.1847621810E+00, 9.4962143976E-01],
	[3.4720000000E+04, 2.8456606412E+01, 5.2511697615E+00, 1.1316127242E+01, 3.1852769917E+00, 9.4964494280E-01],
	[3.4725000000E+04, 2.8463593885E+01, 5.2511885314E+00, 1.1321432759E+01, 3.1857916760E+00, 9.4966843386E-01],
	[3.4730000000E+04, 2.8470582068E+01, 5.2512072987E+00, 1.1326739998E+01, 3.1863062339E+00, 9.4969191296E-01],
	[3.4735000000E+04, 2.8477570959E+01, 5.2512260633E+00, 1.1332048960E+01, 3.1868206655E+00, 9.4971538009E-01],
	[3.4740000000E+04, 2.8484560560E+01, 5.2512448253E+00, 1.1337359644E+01, 3.1873349707E+00, 9.4973883528E-01],
	[3.4745000000E+04, 2.8491550870E+01, 5.2512635847E+00, 1.1342672051E+01, 3.1878491495E+00, 9.4976227851E-01],
	[3.4750000000E+04, 2.8498541890E+01, 5.2512823414E+00, 1.1347986181E+01, 3.1883632020E+00, 9.4978570980E-01],
	[3.4755000000E+04, 2.8505533619E+01, 5.2513010955E+00, 1.1353302035E+01, 3.1888771282E+00, 9.4980912915E-01],
	[3.4760000000E+04, 2.8512526056E+01, 5.2513198469E+00, 1.1358619613E+01, 3.1893909281E+00, 9.4983253657E-01],
	[3.4765000000E+04, 2.8519519203E+01, 5.2513385958E+00, 1.1363938915E+01, 3.1899046017E+00, 9.4985593207E-01],
	[3.4770000000E+04, 2.8526513059E+01, 5.2513573420E+00, 1.1369259941E+01, 3.1904181490E+00, 9.4987931565E-01],
	[3.4775000000E+04, 2.8533507624E+01, 5.2513760856E+00, 1.1374582692E+01, 3.1909315700E+00, 9.4990268732E-01],
	[3.4780000000E+04, 2.8540502899E+01, 5.2513948265E+00, 1.1379907168E+01, 3.1914448647E+00, 9.4992604709E-01],
	[3.4785000000E+04, 2.8547498882E+01, 5.2514135648E+00, 1.1385233370E+01, 3.1919580332E+00, 9.4994939495E-01],
	[3.4790000000E+04, 2.8554495574E+01, 5.2514323005E+00, 1.1390561297E+01, 3.1924710754E+00, 9.4997273093E-01],
	[3.4795000000E+04, 2.8561492975E+01, 5.2514510336E+00, 1.1395890950E+01, 3.1929839914E+00, 9.4999605501E-01],
	[3.4800000000E+04, 2.8568491085E+01, 5.2514697640E+00, 1.1401222330E+01, 3.1934967811E+00, 9.5001936722E-01],
	[3.4805000000E+04, 2.8575489904E+01, 5.2514884919E+00, 1.1406555436E+01, 3.1940094447E+00, 9.5004266755E-01],
	[3.4810000000E+04, 2.8582489432E+01, 5.2515072171E+00, 1.1411890269E+01, 3.1945219820E+00, 9.5006595602E-01],
	[3.4815000000E+04, 2.8589489669E+01, 5.2515259396E+00, 1.1417226830E+01, 3.1950343931E+00, 9.5008923263E-01],
	[3.4820000000E+04, 2.8596490614E+01, 5.2515446596E+00, 1.1422565118E+01, 3.1955466781E+00, 9.5011249738E-01],
	[3.4825000000E+04, 2.8603492268E+01, 5.2515633769E+00, 1.1427905134E+01, 3.1960588368E+00, 9.5013575028E-01],
	[3.4830000000E+04, 2.8610494631E+01, 5.2515820916E+00, 1.1433246878E+01, 3.1965708695E+00, 9.5015899134E-01],
	[3.4835000000E+04, 2.8617497703E+01, 5.2516008037E+00, 1.1438590351E+01, 3.1970827759E+00, 9.5018222056E-01],
	[3.4840000000E+04, 2.8624501483E+01, 5.2516195132E+00, 1.1443935552E+01, 3.1975945562E+00, 9.5020543795E-01],
	[3.4845000000E+04, 2.8631505972E+01, 5.2516382201E+00, 1.1449282483E+01, 3.1981062104E+00, 9.5022864352E-01],
	[3.4850000000E+04, 2.8638511170E+01, 5.2516569243E+00, 1.1454631143E+01, 3.1986177385E+00, 9.5025183728E-01],
	[3.4855000000E+04, 2.8645517076E+01, 5.2516756259E+00, 1.1459981532E+01, 3.1991291404E+00, 9.5027501922E-01],
	[3.4860000000E+04, 2.8652523691E+01, 5.2516943249E+00, 1.1465333652E+01, 3.1996404163E+00, 9.5029818935E-01],
	[3.4865000000E+04, 2.8659531015E+01, 5.2517130213E+00, 1.1470687503E+01, 3.2001515661E+00, 9.5032134769E-01],
	[3.4870000000E+04, 2.8666539047E+01, 5.2517317151E+00, 1.1476043083E+01, 3.2006625898E+00, 9.5034449424E-01],
	[3.4875000000E+04, 2.8673547787E+01, 5.2517504063E+00, 1.1481400395E+01, 3.2011734874E+00, 9.5036762900E-01],
	[3.4880000000E+04, 2.8680557236E+01, 5.2517690948E+00, 1.1486759439E+01, 3.2016842590E+00, 9.5039075198E-01],
	[3.4885000000E+04, 2.8687567393E+01, 5.2517877807E+00, 1.1492120213E+01, 3.2021949045E+00, 9.5041386318E-01],
	[3.4890000000E+04, 2.8694578259E+01, 5.2518064641E+00, 1.1497482720E+01, 3.2027054241E+00, 9.5043696262E-01],
	[3.4895000000E+04, 2.8701589833E+01, 5.2518251448E+00, 1.1502846959E+01, 3.2032158175E+00, 9.5046005030E-01],
	[3.4900000000E+04, 2.8708602115E+01, 5.2518438229E+00, 1.1508212931E+01, 3.2037260850E+00, 9.5048312622E-01],
	[3.4905000000E+04, 2.8715615105E+01, 5.2518624984E+00, 1.1513580635E+01, 3.2042362265E+00, 9.5050619040E-01],
	[3.4910000000E+04, 2.8722628804E+01, 5.2518811713E+00, 1.1518950072E+01, 3.2047462420E+00, 9.5052924283E-01],
	[3.4915000000E+04, 2.8729643211E+01, 5.2518998415E+00, 1.1524321243E+01, 3.2052561315E+00, 9.5055228353E-01],
	[3.4920000000E+04, 2.8736658327E+01, 5.2519185092E+00, 1.1529694148E+01, 3.2057658951E+00, 9.5057531249E-01],
	[3.4925000000E+04, 2.8743674150E+01, 5.2519371743E+00, 1.1535068787E+01, 3.2062755327E+00, 9.5059832974E-01],
	[3.4930000000E+04, 2.8750690682E+01, 5.2519558367E+00, 1.1540445160E+01, 3.2067850444E+00, 9.5062133526E-01],
	[3.4935000000E+04, 2.8757707922E+01, 5.2519744966E+00, 1.1545823268E+01, 3.2072944301E+00, 9.5064432908E-01],
	[3.4940000000E+04, 2.8764725869E+01, 5.2519931538E+00, 1.1551203111E+01, 3.2078036899E+00, 9.5066731119E-01],
	[3.4945000000E+04, 2.8771744525E+01, 5.2520118085E+00, 1.1556584690E+01, 3.2083128239E+00, 9.5069028160E-01],
	[3.4950000000E+04, 2.8778763889E+01, 5.2520304605E+00, 1.1561968004E+01, 3.2088218319E+00, 9.5071324032E-01],
	[3.4955000000E+04, 2.8785783961E+01, 5.2520491100E+00, 1.1567353054E+01, 3.2093307140E+00, 9.5073618735E-01],
	[3.4960000000E+04, 2.8792804741E+01, 5.2520677568E+00, 1.1572739840E+01, 3.2098394703E+00, 9.5075912270E-01],
	[3.4965000000E+04, 2.8799826229E+01, 5.2520864010E+00, 1.1578128363E+01, 3.2103481007E+00, 9.5078204638E-01],
	[3.4970000000E+04, 2.8806848425E+01, 5.2521050427E+00, 1.1583518623E+01, 3.2108566053E+00, 9.5080495839E-01],
	[3.4975000000E+04, 2.8813871328E+01, 5.2521236817E+00, 1.1588910620E+01, 3.2113649840E+00, 9.5082785874E-01],
	[3.4980000000E+04, 2.8820894940E+01, 5.2521423182E+00, 1.1594304354E+01, 3.2118732369E+00, 9.5085074743E-01],
	[3.4985000000E+04, 2.8827919259E+01, 5.2521609520E+00, 1.1599699827E+01, 3.2123813640E+00, 9.5087362448E-01],
	[3.4990000000E+04, 2.8834944286E+01, 5.2521795833E+00, 1.1605097037E+01, 3.2128893652E+00, 9.5089648988E-01],
	[3.4995000000E+04, 2.8841970021E+01, 5.2521982119E+00, 1.1610495986E+01, 3.2133972407E+00, 9.5091934365E-01],
	[3.5000000000E+04, 2.8848996464E+01, 5.2522168380E+00, 1.1615896674E+01, 3.2139049905E+00, 9.5094218579E-01],
	[3.5005000000E+04, 2.8856023614E+01, 5.2522354614E+00, 1.1621305759E+01, 3.2144131238E+00, 9.5096501630E-01],
	[3.5010000000E+04, 2.8863051472E+01, 5.2522540823E+00, 1.1626716590E+01, 3.2149211313E+00, 9.5098783519E-01],
	[3.5015000000E+04, 2.8870080037E+01, 5.2522727006E+00, 1.1632129165E+01, 3.2154290127E+00, 9.5101064248E-01],
	[3.5020000000E+04, 2.8877109311E+01, 5.2522913163E+00, 1.1637543486E+01, 3.2159367682E+00, 9.5103343816E-01],
	[3.5025000000E+04, 2.8884139291E+01, 5.2523099293E+00, 1.1642959552E+01, 3.2164443978E+00, 9.5105622223E-01],
	[3.5030000000E+04, 2.8891169980E+01, 5.2523285398E+00, 1.1648377364E+01, 3.2169519015E+00, 9.5107899472E-01],
	[3.5035000000E+04, 2.8898201376E+01, 5.2523471478E+00, 1.1653796923E+01, 3.2174592792E+00, 9.5110175562E-01],
	[3.5040000000E+04, 2.8905233479E+01, 5.2523657531E+00, 1.1659218228E+01, 3.2179665310E+00, 9.5112450494E-01],
	[3.5045000000E+04, 2.8912266290E+01, 5.2523843558E+00, 1.1664641281E+01, 3.2184736570E+00, 9.5114724268E-01],
	[3.5050000000E+04, 2.8919299808E+01, 5.2524029559E+00, 1.1670066080E+01, 3.2189806570E+00, 9.5116996886E-01],
	[3.5055000000E+04, 2.8926334034E+01, 5.2524215535E+00, 1.1675492627E+01, 3.2194875312E+00, 9.5119268348E-01],
	[3.5060000000E+04, 2.8933368967E+01, 5.2524401485E+00, 1.1680920922E+01, 3.2199942796E+00, 9.5121538653E-01],
	[3.5065000000E+04, 2.8940404607E+01, 5.2524587409E+00, 1.1686350965E+01, 3.2205009021E+00, 9.5123807804E-01],
	[3.5070000000E+04, 2.8947440955E+01, 5.2524773307E+00, 1.1691782756E+01, 3.2210073988E+00, 9.5126075801E-01],
	[3.5075000000E+04, 2.8954478010E+01, 5.2524959179E+00, 1.1697216297E+01, 3.2215137697E+00, 9.5128342644E-01],
	[3.5080000000E+04, 2.8961515772E+01, 5.2525145025E+00, 1.1702651586E+01, 3.2220200147E+00, 9.5130608334E-01],
	[3.5085000000E+04, 2.8968554241E+01, 5.2525330845E+00, 1.1708088625E+01, 3.2225261340E+00, 9.5132872871E-01],
	[3.5090000000E+04, 2.8975606860E+01, 5.2525534082E+00, 1.1713527414E+01, 3.2230329505E+00, 9.5135136257E-01],
	[3.5095000000E+04, 2.8982666730E+01, 5.2525745775E+00, 1.1718967952E+01, 3.2235400420E+00, 9.5137398491E-01],
	[3.5100000000E+04, 2.8989727315E+01, 5.2525957439E+00, 1.1724410241E+01, 3.2240470083E+00, 9.5139659575E-01],
	[3.5105000000E+04, 2.8996788614E+01, 5.2526169073E+00, 1.1729854281E+01, 3.2245538493E+00, 9.5141919508E-01],
	[3.5110000000E+04, 2.9003850626E+01, 5.2526380678E+00, 1.1735300072E+01, 3.2250605650E+00, 9.5144178293E-01],
	[3.5115000000E+04, 2.9010913353E+01, 5.2526592254E+00, 1.1740747614E+01, 3.2255671554E+00, 9.5146435928E-01],
	[3.5120000000E+04, 2.9017976793E+01, 5.2526803801E+00, 1.1746196907E+01, 3.2260736206E+00, 9.5148692416E-01],
	[3.5125000000E+04, 2.9025040948E+01, 5.2527015318E+00, 1.1751647953E+01, 3.2265799606E+00, 9.5150947756E-01],
	[3.5130000000E+04, 2.9032105816E+01, 5.2527226806E+00, 1.1757100750E+01, 3.2270861754E+00, 9.5153201949E-01],
	[3.5135000000E+04, 2.9039171398E+01, 5.2527438265E+00, 1.1762555301E+01, 3.2275922650E+00, 9.5155454995E-01],
	[3.5140000000E+04, 2.9046237694E+01, 5.2527649694E+00, 1.1768011604E+01, 3.2280982293E+00, 9.5157706897E-01],
	[3.5145000000E+04, 2.9053304703E+01, 5.2527861094E+00, 1.1773469660E+01, 3.2286040685E+00, 9.5159957653E-01],
	[3.5150000000E+04, 2.9060372426E+01, 5.2528072465E+00, 1.1778929470E+01, 3.2291097825E+00, 9.5162207264E-01],
	[3.5155000000E+04, 2.9067440863E+01, 5.2528283807E+00, 1.1784391034E+01, 3.2296153714E+00, 9.5164455732E-01],
	[3.5160000000E+04, 2.9074510014E+01, 5.2528495120E+00, 1.1789854352E+01, 3.2301208351E+00, 9.5166703057E-01],
	[3.5165000000E+04, 2.9081579878E+01, 5.2528706403E+00, 1.1795319424E+01, 3.2306261737E+00, 9.5168949239E-01],
	[3.5170000000E+04, 2.9088650455E+01, 5.2528917658E+00, 1.1800786251E+01, 3.2311313872E+00, 9.5171194279E-01],
	[3.5175000000E+04, 2.9095721747E+01, 5.2529128883E+00, 1.1806254833E+01, 3.2316364756E+00, 9.5173438177E-01],
	[3.5180000000E+04, 2.9102793752E+01, 5.2529340079E+00, 1.1811725171E+01, 3.2321414388E+00, 9.5175680935E-01],
	[3.5185000000E+04, 2.9109866470E+01, 5.2529551245E+00, 1.1817197264E+01, 3.2326462770E+00, 9.5177922553E-01],
	[3.5190000000E+04, 2.9116939902E+01, 5.2529762383E+00, 1.1822671113E+01, 3.2331509901E+00, 9.5180163032E-01],
	[3.5195000000E+04, 2.9124014047E+01, 5.2529973491E+00, 1.1828146718E+01, 3.2336555782E+00, 9.5182402371E-01],
	[3.5200000000E+04, 2.9131088906E+01, 5.2530184571E+00, 1.1833624080E+01, 3.2341600412E+00, 9.5184640572E-01],
	[3.5205000000E+04, 2.9138164478E+01, 5.2530395621E+00, 1.1839103199E+01, 3.2346643792E+00, 9.5186877636E-01],
	[3.5210000000E+04, 2.9145240763E+01, 5.2530606642E+00, 1.1844584076E+01, 3.2351685922E+00, 9.5189113563E-01],
	[3.5215000000E+04, 2.9152317762E+01, 5.2530817634E+00, 1.1850066710E+01, 3.2356726801E+00, 9.5191348353E-01],
	[3.5220000000E+04, 2.9159395474E+01, 5.2531028597E+00, 1.1855551101E+01, 3.2361766431E+00, 9.5193582007E-01],
	[3.5225000000E+04, 2.9166473900E+01, 5.2531239530E+00, 1.1861037251E+01, 3.2366804811E+00, 9.5195814526E-01],
	[3.5230000000E+04, 2.9173553038E+01, 5.2531450435E+00, 1.1866525160E+01, 3.2371841941E+00, 9.5198045911E-01],
	[3.5235000000E+04, 2.9180632890E+01, 5.2531661311E+00, 1.1872014827E+01, 3.2376877822E+00, 9.5200276162E-01],
	[3.5240000000E+04, 2.9187713455E+01, 5.2531872157E+00, 1.1877506254E+01, 3.2381912453E+00, 9.5202505279E-01],
	[3.5245000000E+04, 2.9194794733E+01, 5.2532082974E+00, 1.1882999439E+01, 3.2386945834E+00, 9.5204733263E-01],
	[3.5250000000E+04, 2.9201876724E+01, 5.2532293763E+00, 1.1888494385E+01, 3.2391977967E+00, 9.5206960116E-01],
	[3.5255000000E+04, 2.9208959429E+01, 5.2532504522E+00, 1.1893991091E+01, 3.2397008851E+00, 9.5209185837E-01],
	[3.5260000000E+04, 2.9216042846E+01, 5.2532715252E+00, 1.1899489557E+01, 3.2402038485E+00, 9.5211410427E-01],
	[3.5265000000E+04, 2.9223126977E+01, 5.2532925954E+00, 1.1904989784E+01, 3.2407066871E+00, 9.5213633887E-01],
	[3.5270000000E+04, 2.9230211820E+01, 5.2533136626E+00, 1.1910491772E+01, 3.2412094008E+00, 9.5215856217E-01],
	[3.5275000000E+04, 2.9237297377E+01, 5.2533347269E+00, 1.1915995521E+01, 3.2417119897E+00, 9.5218077418E-01],
	[3.5280000000E+04, 2.9244383646E+01, 5.2533557883E+00, 1.1921501032E+01, 3.2422144537E+00, 9.5220297491E-01],
	[3.5285000000E+04, 2.9251470629E+01, 5.2533768468E+00, 1.1927008304E+01, 3.2427167929E+00, 9.5222516436E-01],
	[3.5290000000E+04, 2.9258558324E+01, 5.2533979024E+00, 1.1932517340E+01, 3.2432190072E+00, 9.5224734253E-01],
	[3.5295000000E+04, 2.9265646732E+01, 5.2534189552E+00, 1.1938028137E+01, 3.2437210968E+00, 9.5226950944E-01],
	[3.5300000000E+04, 2.9272735853E+01, 5.2534400050E+00, 1.1943540698E+01, 3.2442230616E+00, 9.5229166509E-01],
	[3.5305000000E+04, 2.9279825687E+01, 5.2534610519E+00, 1.1949055022E+01, 3.2447249016E+00, 9.5231380949E-01],
	[3.5310000000E+04, 2.9286916233E+01, 5.2534820959E+00, 1.1954571109E+01, 3.2452266168E+00, 9.5233594264E-01],
	[3.5315000000E+04, 2.9294007492E+01, 5.2535031370E+00, 1.1960088960E+01, 3.2457282073E+00, 9.5235806454E-01],
	[3.5320000000E+04, 2.9301099464E+01, 5.2535241753E+00, 1.1965608575E+01, 3.2462296730E+00, 9.5238017521E-01],
	[3.5325000000E+04, 2.9308192149E+01, 5.2535452106E+00, 1.1971129955E+01, 3.2467310140E+00, 9.5240227464E-01],
	[3.5330000000E+04, 2.9315285546E+01, 5.2535662431E+00, 1.1976653100E+01, 3.2472322303E+00, 9.5242436284E-01],
	[3.5335000000E+04, 2.9322379656E+01, 5.2535872726E+00, 1.1982178009E+01, 3.2477333219E+00, 9.5244643983E-01],
	[3.5340000000E+04, 2.9329474479E+01, 5.2536082993E+00, 1.1987704684E+01, 3.2482342888E+00, 9.5246850559E-01],
	[3.5345000000E+04, 2.9336570014E+01, 5.2536293231E+00, 1.1993233125E+01, 3.2487351311E+00, 9.5249056015E-01],
	[3.5350000000E+04, 2.9343666262E+01, 5.2536503440E+00, 1.1998763332E+01, 3.2492358486E+00, 9.5251260350E-01],
	[3.5355000000E+04, 2.9350763222E+01, 5.2536713620E+00, 1.2004295305E+01, 3.2497364416E+00, 9.5253463565E-01],
	[3.5360000000E+04, 2.9357860895E+01, 5.2536923771E+00, 1.2009829045E+01, 3.2502369099E+00, 9.5255665661E-01],
	[3.5365000000E+04, 2.9364959280E+01, 5.2537133893E+00, 1.2015364552E+01, 3.2507372535E+00, 9.5257866638E-01],
	[3.5370000000E+04, 2.9372058377E+01, 5.2537343986E+00, 1.2020901826E+01, 3.2512374726E+00, 9.5260066496E-01],
	[3.5375000000E+04, 2.9379158187E+01, 5.2537554051E+00, 1.2026440868E+01, 3.2517375671E+00, 9.5262265237E-01],
	[3.5380000000E+04, 2.9386258710E+01, 5.2537764086E+00, 1.2031981677E+01, 3.2522375370E+00, 9.5264462860E-01],
	[3.5385000000E+04, 2.9393359944E+01, 5.2537974093E+00, 1.2037524255E+01, 3.2527373823E+00, 9.5266659367E-01],
	[3.5390000000E+04, 2.9400461891E+01, 5.2538184071E+00, 1.2043068602E+01, 3.2532371030E+00, 9.5268854758E-01],
	[3.5395000000E+04, 2.9407564550E+01, 5.2538394020E+00, 1.2048614717E+01, 3.2537366993E+00, 9.5271049033E-01],
	[3.5400000000E+04, 2.9414667922E+01, 5.2538603940E+00, 1.2054162602E+01, 3.2542361710E+00, 9.5273242193E-01],
	[3.5405000000E+04, 2.9421772006E+01, 5.2538813832E+00, 1.2059712256E+01, 3.2547355182E+00, 9.5275434239E-01],
	[3.5410000000E+04, 2.9428876801E+01, 5.2539023695E+00, 1.2065263679E+01, 3.2552347408E+00, 9.5277625170E-01],
	[3.5415000000E+04, 2.9435982309E+01, 5.2539233529E+00, 1.2070816873E+01, 3.2557338390E+00, 9.5279814989E-01],
	[3.5420000000E+04, 2.9443088530E+01, 5.2539443334E+00, 1.2076371838E+01, 3.2562328127E+00, 9.5282003694E-01],
	[3.5425000000E+04, 2.9450195462E+01, 5.2539653110E+00, 1.2081928573E+01, 3.2567316620E+00, 9.5284191288E-01],
	[3.5430000000E+04, 2.9457303106E+01, 5.2539862858E+00, 1.2087487079E+01, 3.2572303868E+00, 9.5286377769E-01],
	[3.5435000000E+04, 2.9464411463E+01, 5.2540072577E+00, 1.2093047356E+01, 3.2577289872E+00, 9.5288563140E-01],
	[3.5440000000E+04, 2.9471520531E+01, 5.2540282267E+00, 1.2098609406E+01, 3.2582274631E+00, 9.5290747399E-01],
	[3.5445000000E+04, 2.9478630312E+01, 5.2540491928E+00, 1.2104173227E+01, 3.2587258147E+00, 9.5292930549E-01],
	[3.5450000000E+04, 2.9485740804E+01, 5.2540701561E+00, 1.2109738820E+01, 3.2592240418E+00, 9.5295112590E-01],
	[3.5455000000E+04, 2.9492852008E+01, 5.2540911164E+00, 1.2115306187E+01, 3.2597221446E+00, 9.5297293521E-01],
	[3.5460000000E+04, 2.9499963924E+01, 5.2541120740E+00, 1.2120875326E+01, 3.2602201230E+00, 9.5299473344E-01],
	[3.5465000000E+04, 2.9507076552E+01, 5.2541330286E+00, 1.2126446238E+01, 3.2607179771E+00, 9.5301652059E-01],
	[3.5470000000E+04, 2.9514189892E+01, 5.2541539804E+00, 1.2132018924E+01, 3.2612157068E+00, 9.5303829667E-01],
	[3.5475000000E+04, 2.9521303944E+01, 5.2541749293E+00, 1.2137593384E+01, 3.2617133122E+00, 9.5306006168E-01],
	[3.5480000000E+04, 2.9528418707E+01, 5.2541958753E+00, 1.2143169618E+01, 3.2622107933E+00, 9.5308181562E-01],
	[3.5485000000E+04, 2.9535534183E+01, 5.2542168185E+00, 1.2148747626E+01, 3.2627081500E+00, 9.5310355852E-01],
	[3.5490000000E+04, 2.9542650370E+01, 5.2542377588E+00, 1.2154327410E+01, 3.2632053825E+00, 9.5312529036E-01],
	[3.5495000000E+04, 2.9549767268E+01, 5.2542586962E+00, 1.2159908968E+01, 3.2637024908E+00, 9.5314701115E-01],
	[3.5500000000E+04, 2.9556884879E+01, 5.2542796308E+00, 1.2165492302E+01, 3.2641994747E+00, 9.5316872091E-01],
	[3.5505000000E+04, 2.9564003201E+01, 5.2543005625E+00, 1.2171077412E+01, 3.2646963345E+00, 9.5319041963E-01],
	[3.5510000000E+04, 2.9571122234E+01, 5.2543214913E+00, 1.2176664298E+01, 3.2651930700E+00, 9.5321210732E-01],
	[3.5515000000E+04, 2.9578241979E+01, 5.2543424173E+00, 1.2182252960E+01, 3.2656896812E+00, 9.5323378399E-01],
	[3.5520000000E+04, 2.9585362436E+01, 5.2543633404E+00, 1.2187843399E+01, 3.2661861683E+00, 9.5325544964E-01],
	[3.5525000000E+04, 2.9592483604E+01, 5.2543842606E+00, 1.2193435615E+01, 3.2666825312E+00, 9.5327710428E-01],
	[3.5530000000E+04, 2.9599605484E+01, 5.2544051780E+00, 1.2199029608E+01, 3.2671787699E+00, 9.5329874791E-01],
	[3.5535000000E+04, 2.9606728075E+01, 5.2544260925E+00, 1.2204625379E+01, 3.2676748845E+00, 9.5332038054E-01],
	[3.5540000000E+04, 2.9613851378E+01, 5.2544470042E+00, 1.2210222928E+01, 3.2681708749E+00, 9.5334200218E-01],
	[3.5545000000E+04, 2.9620975392E+01, 5.2544679130E+00, 1.2215822255E+01, 3.2686667412E+00, 9.5336361282E-01],
	[3.5550000000E+04, 2.9628100117E+01, 5.2544888190E+00, 1.2221423361E+01, 3.2691624834E+00, 9.5338521248E-01],
	[3.5555000000E+04, 2.9635225554E+01, 5.2545097221E+00, 1.2227026246E+01, 3.2696581014E+00, 9.5340680116E-01],
	[3.5560000000E+04, 2.9642351702E+01, 5.2545306223E+00, 1.2232630910E+01, 3.2701535954E+00, 9.5342837886E-01],
	[3.5565000000E+04, 2.9649478561E+01, 5.2545515197E+00, 1.2238237354E+01, 3.2706489653E+00, 9.5344994560E-01],
	[3.5570000000E+04, 2.9656606132E+01, 5.2545724142E+00, 1.2243845577E+01, 3.2711442112E+00, 9.5347150138E-01],
	[3.5575000000E+04, 2.9663734414E+01, 5.2545933059E+00, 1.2249455580E+01, 3.2716393329E+00, 9.5349304619E-01],
	[3.5580000000E+04, 2.9670863407E+01, 5.2546141947E+00, 1.2255067364E+01, 3.2721343307E+00, 9.5351458006E-01],
	[3.5585000000E+04, 2.9677993111E+01, 5.2546350807E+00, 1.2260680929E+01, 3.2726292044E+00, 9.5353610298E-01],
	[3.5590000000E+04, 2.9685123526E+01, 5.2546559638E+00, 1.2266296275E+01, 3.2731239542E+00, 9.5355761496E-01],
	[3.5595000000E+04, 2.9692254653E+01, 5.2546768441E+00, 1.2271913403E+01, 3.2736185799E+00, 9.5357911600E-01],
	[3.5600000000E+04, 2.9699386490E+01, 5.2546977215E+00, 1.2277532312E+01, 3.2741130817E+00, 9.5360060611E-01],
	[3.5605000000E+04, 2.9706519039E+01, 5.2547185961E+00, 1.2283153003E+01, 3.2746074595E+00, 9.5362208530E-01],
	[3.5610000000E+04, 2.9713652298E+01, 5.2547394678E+00, 1.2288775476E+01, 3.2751017134E+00, 9.5364355357E-01],
	[3.5615000000E+04, 2.9720786269E+01, 5.2547603367E+00, 1.2294399733E+01, 3.2755958433E+00, 9.5366501093E-01],
	[3.5620000000E+04, 2.9727920951E+01, 5.2547812027E+00, 1.2300025772E+01, 3.2760898493E+00, 9.5368645738E-01],
	[3.5625000000E+04, 2.9735056343E+01, 5.2548020659E+00, 1.2305653594E+01, 3.2765837314E+00, 9.5370789293E-01],
	[3.5630000000E+04, 2.9742192447E+01, 5.2548229262E+00, 1.2311283200E+01, 3.2770774896E+00, 9.5372931758E-01],
	[3.5635000000E+04, 2.9749329261E+01, 5.2548437837E+00, 1.2316914591E+01, 3.2775711240E+00, 9.5375073134E-01],
	[3.5640000000E+04, 2.9756466786E+01, 5.2548646383E+00, 1.2322547765E+01, 3.2780646344E+00, 9.5377213421E-01],
	[3.5645000000E+04, 2.9763605022E+01, 5.2548854901E+00, 1.2328182724E+01, 3.2785580211E+00, 9.5379352620E-01],
	[3.5650000000E+04, 2.9770743969E+01, 5.2549063391E+00, 1.2333819468E+01, 3.2790512839E+00, 9.5381490732E-01],
	[3.5655000000E+04, 2.9777897535E+01, 5.2549289684E+00, 1.2339457997E+01, 3.2795452861E+00, 9.5383627757E-01],
	[3.5660000000E+04, 2.9785057686E+01, 5.2549523468E+00, 1.2345098311E+01, 3.2800395290E+00, 9.5385763696E-01],
	[3.5665000000E+04, 2.9792218553E+01, 5.2549757221E+00, 1.2350740411E+01, 3.2805336486E+00, 9.5387898548E-01],
	[3.5670000000E+04, 2.9799380138E+01, 5.2549990941E+00, 1.2356384298E+01, 3.2810276449E+00, 9.5390032316E-01],
	[3.5675000000E+04, 2.9806542441E+01, 5.2550224630E+00, 1.2362029971E+01, 3.2815215178E+00, 9.5392164999E-01],
	[3.5680000000E+04, 2.9813705460E+01, 5.2550458288E+00, 1.2367677431E+01, 3.2820152674E+00, 9.5394296597E-01],
	[3.5685000000E+04, 2.9820869197E+01, 5.2550691913E+00, 1.2373326677E+01, 3.2825088938E+00, 9.5396427112E-01],
	[3.5690000000E+04, 2.9828033652E+01, 5.2550925507E+00, 1.2378977712E+01, 3.2830023969E+00, 9.5398556544E-01],
	[3.5695000000E+04, 2.9835198823E+01, 5.2551159069E+00, 1.2384630534E+01, 3.2834957767E+00, 9.5400684893E-01],
	[3.5700000000E+04, 2.9842364712E+01, 5.2551392599E+00, 1.2390285143E+01, 3.2839890333E+00, 9.5402812161E-01],
	[3.5705000000E+04, 2.9849531318E+01, 5.2551626098E+00, 1.2395941542E+01, 3.2844821666E+00, 9.5404938347E-01],
	[3.5710000000E+04, 2.9856698641E+01, 5.2551859565E+00, 1.2401599729E+01, 3.2849751767E+00, 9.5407063452E-01],
	[3.5715000000E+04, 2.9863866682E+01, 5.2552093001E+00, 1.2407259705E+01, 3.2854680636E+00, 9.5409187476E-01],
	[3.5720000000E+04, 2.9871035439E+01, 5.2552326405E+00, 1.2412921470E+01, 3.2859608274E+00, 9.5411310421E-01],
	[3.5725000000E+04, 2.9878204914E+01, 5.2552559777E+00, 1.2418585025E+01, 3.2864534679E+00, 9.5413432287E-01],
	[3.5730000000E+04, 2.9885375105E+01, 5.2552793118E+00, 1.2424250369E+01, 3.2869459853E+00, 9.5415553074E-01],
	[3.5735000000E+04, 2.9892546014E+01, 5.2553026427E+00, 1.2429917504E+01, 3.2874383796E+00, 9.5417672783E-01],
	[3.5740000000E+04, 2.9899717640E+01, 5.2553259704E+00, 1.2435586430E+01, 3.2879306507E+00, 9.5419791414E-01],
	[3.5745000000E+04, 2.9906889982E+01, 5.2553492950E+00, 1.2441257146E+01, 3.2884227987E+00, 9.5421908969E-01],
	[3.5750000000E+04, 2.9914063042E+01, 5.2553726164E+00, 1.2446929654E+01, 3.2889148236E+00, 9.5424025447E-01],
	[3.5755000000E+04, 2.9921236818E+01, 5.2553959346E+00, 1.2452603953E+01, 3.2894067254E+00, 9.5426140849E-01],
	[3.5760000000E+04, 2.9928411312E+01, 5.2554192498E+00, 1.2458280044E+01, 3.2898985042E+00, 9.5428255175E-01],
	[3.5765000000E+04, 2.9935586522E+01, 5.2554425617E+00, 1.2463957927E+01, 3.2903901599E+00, 9.5430368427E-01],
	[3.5770000000E+04, 2.9942762449E+01, 5.2554658705E+00, 1.2469637602E+01, 3.2908816925E+00, 9.5432480604E-01],
	[3.5775000000E+04, 2.9949939093E+01, 5.2554891761E+00, 1.2475319070E+01, 3.2913731022E+00, 9.5434591708E-01],
	[3.5780000000E+04, 2.9957116453E+01, 5.2555124786E+00, 1.2481002332E+01, 3.2918643888E+00, 9.5436701738E-01],
	[3.5785000000E+04, 2.9964294531E+01, 5.2555357779E+00, 1.2486687386E+01, 3.2923555524E+00, 9.5438810696E-01],
	[3.5790000000E+04, 2.9971473325E+01, 5.2555590741E+00, 1.2492374234E+01, 3.2928465930E+00, 9.5440918582E-01],
	[3.5795000000E+04, 2.9978652836E+01, 5.2555823671E+00, 1.2498062877E+01, 3.2933375107E+00, 9.5443025396E-01],
	[3.5800000000E+04, 2.9985833063E+01, 5.2556056570E+00, 1.2503753313E+01, 3.2938283054E+00, 9.5445131140E-01],
	[3.5805000000E+04, 2.9993014007E+01, 5.2556289438E+00, 1.2509445545E+01, 3.2943189772E+00, 9.5447235812E-01],
	[3.5810000000E+04, 3.0000195668E+01, 5.2556522273E+00, 1.2515139571E+01, 3.2948095260E+00, 9.5449339415E-01],
	[3.5815000000E+04, 3.0007378045E+01, 5.2556755078E+00, 1.2520835392E+01, 3.2952999520E+00, 9.5451441949E-01],
	[3.5820000000E+04, 3.0014561139E+01, 5.2556987850E+00, 1.2526533009E+01, 3.2957902550E+00, 9.5453543414E-01],
	[3.5825000000E+04, 3.0021744949E+01, 5.2557220592E+00, 1.2532232422E+01, 3.2962804352E+00, 9.5455643810E-01],
	[3.5830000000E+04, 3.0028929476E+01, 5.2557453302E+00, 1.2537933632E+01, 3.2967704925E+00, 9.5457743139E-01],
	[3.5835000000E+04, 3.0036114719E+01, 5.2557685980E+00, 1.2543636637E+01, 3.2972604269E+00, 9.5459841401E-01],
	[3.5840000000E+04, 3.0043300679E+01, 5.2557918627E+00, 1.2549341440E+01, 3.2977502385E+00, 9.5461938596E-01],
	[3.5845000000E+04, 3.0050487355E+01, 5.2558151243E+00, 1.2555048039E+01, 3.2982399273E+00, 9.5464034725E-01],
	[3.5850000000E+04, 3.0057674747E+01, 5.2558383827E+00, 1.2560756437E+01, 3.2987294933E+00, 9.5466129789E-01],
	[3.5855000000E+04, 3.0064862856E+01, 5.2558616380E+00, 1.2566466632E+01, 3.2992189365E+00, 9.5468223787E-01],
	[3.5860000000E+04, 3.0072051681E+01, 5.2558848901E+00, 1.2572178625E+01, 3.2997082570E+00, 9.5470316721E-01],
	[3.5865000000E+04, 3.0079241223E+01, 5.2559081391E+00, 1.2577892416E+01, 3.3001974546E+00, 9.5472408592E-01],
	[3.5870000000E+04, 3.0086431480E+01, 5.2559313850E+00, 1.2583608006E+01, 3.3006865296E+00, 9.5474499399E-01],
	[3.5875000000E+04, 3.0093622454E+01, 5.2559546277E+00, 1.2589325396E+01, 3.3011754818E+00, 9.5476589143E-01],
	[3.5880000000E+04, 3.0100814144E+01, 5.2559778673E+00, 1.2595044584E+01, 3.3016643113E+00, 9.5478677825E-01],
	[3.5885000000E+04, 3.0108006551E+01, 5.2560011038E+00, 1.2600765573E+01, 3.3021530180E+00, 9.5480765445E-01],
	[3.5890000000E+04, 3.0115199673E+01, 5.2560243371E+00, 1.2606488361E+01, 3.3026416022E+00, 9.5482852005E-01],
	[3.5895000000E+04, 3.0122393512E+01, 5.2560475673E+00, 1.2612212949E+01, 3.3031300636E+00, 9.5484937503E-01],
	[3.5900000000E+04, 3.0129588066E+01, 5.2560707943E+00, 1.2617939339E+01, 3.3036184024E+00, 9.5487021942E-01],
	[3.5905000000E+04, 3.0136783337E+01, 5.2560940183E+00, 1.2623667529E+01, 3.3041066185E+00, 9.5489105321E-01],
	[3.5910000000E+04, 3.0143979324E+01, 5.2561172391E+00, 1.2629397520E+01, 3.3045947120E+00, 9.5491187641E-01],
	[3.5915000000E+04, 3.0151176027E+01, 5.2561404567E+00, 1.2635129313E+01, 3.3050826830E+00, 9.5493268903E-01],
	[3.5920000000E+04, 3.0158373445E+01, 5.2561636713E+00, 1.2640862908E+01, 3.3055705313E+00, 9.5495349107E-01],
	[3.5925000000E+04, 3.0165571580E+01, 5.2561868827E+00, 1.2646598305E+01, 3.3060582570E+00, 9.5497428254E-01],
	[3.5930000000E+04, 3.0172770430E+01, 5.2562100909E+00, 1.2652335505E+01, 3.3065458602E+00, 9.5499506344E-01],
	[3.5935000000E+04, 3.0179969997E+01, 5.2562332961E+00, 1.2658074507E+01, 3.3070333409E+00, 9.5501583378E-01],
	[3.5940000000E+04, 3.0187170279E+01, 5.2562564981E+00, 1.2663815312E+01, 3.3075206990E+00, 9.5503659356E-01],
	[3.5945000000E+04, 3.0194371277E+01, 5.2562796970E+00, 1.2669557921E+01, 3.3080079346E+00, 9.5505734279E-01],
	[3.5950000000E+04, 3.0201572991E+01, 5.2563028928E+00, 1.2675302334E+01, 3.3084950476E+00, 9.5507808148E-01],
	[3.5955000000E+04, 3.0208775421E+01, 5.2563260854E+00, 1.2681048551E+01, 3.3089820383E+00, 9.5509880962E-01],
	[3.5960000000E+04, 3.0215978567E+01, 5.2563492749E+00, 1.2686796572E+01, 3.3094689064E+00, 9.5511952723E-01],
	[3.5965000000E+04, 3.0223182428E+01, 5.2563724613E+00, 1.2692546398E+01, 3.3099556521E+00, 9.5514023431E-01],
	[3.5970000000E+04, 3.0230387005E+01, 5.2563956446E+00, 1.2698298029E+01, 3.3104422753E+00, 9.5516093087E-01],
	[3.5975000000E+04, 3.0237592297E+01, 5.2564188248E+00, 1.2704051465E+01, 3.3109287762E+00, 9.5518161691E-01],
	[3.5980000000E+04, 3.0244798305E+01, 5.2564420018E+00, 1.2709806707E+01, 3.3114151546E+00, 9.5520229244E-01],
	[3.5985000000E+04, 3.0252005029E+01, 5.2564651758E+00, 1.2715563755E+01, 3.3119014106E+00, 9.5522295746E-01],
	[3.5990000000E+04, 3.0259212469E+01, 5.2564883466E+00, 1.2721322610E+01, 3.3123875443E+00, 9.5524361197E-01],
	[3.5995000000E+04, 3.0266420623E+01, 5.2565115142E+00, 1.2727083270E+01, 3.3128735555E+00, 9.5526425599E-01],
	[3.6000000000E+04, 3.0273629494E+01, 5.2565346788E+00, 1.2732845738E+01, 3.3133594445E+00, 9.5528488952E-01],
	[3.6005000000E+04, 3.0280839080E+01, 5.2565578403E+00, 1.2738610013E+01, 3.3138452111E+00, 9.5530551257E-01],
	[3.6010000000E+04, 3.0288049381E+01, 5.2565809986E+00, 1.2744376096E+01, 3.3143308554E+00, 9.5532612513E-01],
	[3.6015000000E+04, 3.0295260398E+01, 5.2566041539E+00, 1.2750143986E+01, 3.3148163774E+00, 9.5534672722E-01],
	[3.6020000000E+04, 3.0302472130E+01, 5.2566273060E+00, 1.2755913685E+01, 3.3153017771E+00, 9.5536731885E-01],
	[3.6025000000E+04, 3.0309684578E+01, 5.2566504550E+00, 1.2761685192E+01, 3.3157870546E+00, 9.5538790000E-01],
	[3.6030000000E+04, 3.0316897741E+01, 5.2566736009E+00, 1.2767458508E+01, 3.3162722098E+00, 9.5540847070E-01],
	[3.6035000000E+04, 3.0324111619E+01, 5.2566967437E+00, 1.2773233633E+01, 3.3167572428E+00, 9.5542903095E-01],
	[3.6040000000E+04, 3.0331326213E+01, 5.2567198833E+00, 1.2779010568E+01, 3.3172421535E+00, 9.5544958075E-01],
	[3.6045000000E+04, 3.0338541522E+01, 5.2567430199E+00, 1.2784789312E+01, 3.3177269421E+00, 9.5547012011E-01],
	[3.6050000000E+04, 3.0345757546E+01, 5.2567661534E+00, 1.2790569866E+01, 3.3182116084E+00, 9.5549064903E-01],
	[3.6055000000E+04, 3.0352974285E+01, 5.2567892837E+00, 1.2796352231E+01, 3.3186961526E+00, 9.5551116752E-01],
	[3.6060000000E+04, 3.0360191739E+01, 5.2568124110E+00, 1.2802136406E+01, 3.3191805746E+00, 9.5553167559E-01],
	[3.6065000000E+04, 3.0367409909E+01, 5.2568355351E+00, 1.2807922393E+01, 3.3196648745E+00, 9.5555217323E-01],
	[3.6070000000E+04, 3.0374628794E+01, 5.2568586562E+00, 1.2813710191E+01, 3.3201490523E+00, 9.5557266046E-01],
	[3.6075000000E+04, 3.0381848394E+01, 5.2568817741E+00, 1.2819499800E+01, 3.3206331080E+00, 9.5559313728E-01],
	[3.6080000000E+04, 3.0389068709E+01, 5.2569048889E+00, 1.2825291222E+01, 3.3211170415E+00, 9.5561360370E-01],
	[3.6085000000E+04, 3.0396289738E+01, 5.2569280007E+00, 1.2831084455E+01, 3.3216008530E+00, 9.5563405972E-01],
	[3.6090000000E+04, 3.0403511483E+01, 5.2569511093E+00, 1.2836879502E+01, 3.3220845424E+00, 9.5565450535E-01],
	[3.6095000000E+04, 3.0410733943E+01, 5.2569742148E+00, 1.2842676361E+01, 3.3225681098E+00, 9.5567494059E-01],
	[3.6100000000E+04, 3.0417957118E+01, 5.2569973173E+00, 1.2848475033E+01, 3.3230515552E+00, 9.5569536545E-01],
	[3.6105000000E+04, 3.0425181008E+01, 5.2570204166E+00, 1.2854275519E+01, 3.3235348785E+00, 9.5571577993E-01],
	[3.6110000000E+04, 3.0432405613E+01, 5.2570435129E+00, 1.2860077819E+01, 3.3240180798E+00, 9.5573618404E-01],
	[3.6115000000E+04, 3.0439630932E+01, 5.2570666060E+00, 1.2865881933E+01, 3.3245011592E+00, 9.5575657778E-01],
	[3.6120000000E+04, 3.0446856967E+01, 5.2570896961E+00, 1.2871687862E+01, 3.3249841166E+00, 9.5577696117E-01],
	[3.6125000000E+04, 3.0454083716E+01, 5.2571127830E+00, 1.2877495605E+01, 3.3254669520E+00, 9.5579733420E-01],
	[3.6130000000E+04, 3.0461311180E+01, 5.2571358669E+00, 1.2883305163E+01, 3.3259496656E+00, 9.5581769688E-01],
	[3.6135000000E+04, 3.0468539359E+01, 5.2571589476E+00, 1.2889116537E+01, 3.3264322572E+00, 9.5583804922E-01],
	[3.6140000000E+04, 3.0475768252E+01, 5.2571820253E+00, 1.2894929727E+01, 3.3269147268E+00, 9.5585839121E-01],
	[3.6145000000E+04, 3.0482997861E+01, 5.2572050999E+00, 1.2900744733E+01, 3.3273970747E+00, 9.5587872288E-01],
	[3.6150000000E+04, 3.0490228183E+01, 5.2572281714E+00, 1.2906561555E+01, 3.3278793006E+00, 9.5589904422E-01],
	[3.6155000000E+04, 3.0497459221E+01, 5.2572512398E+00, 1.2912380194E+01, 3.3283614047E+00, 9.5591935524E-01],
	[3.6160000000E+04, 3.0504690973E+01, 5.2572743051E+00, 1.2918200649E+01, 3.3288433869E+00, 9.5593965594E-01],
	[3.6165000000E+04, 3.0511923440E+01, 5.2572973673E+00, 1.2924022922E+01, 3.3293252474E+00, 9.5595994632E-01],
	[3.6170000000E+04, 3.0519156621E+01, 5.2573204265E+00, 1.2929847013E+01, 3.3298069860E+00, 9.5598022641E-01],
	[3.6175000000E+04, 3.0526390517E+01, 5.2573434825E+00, 1.2935672922E+01, 3.3302886029E+00, 9.5600049619E-01],
	[3.6180000000E+04, 3.0533625127E+01, 5.2573665355E+00, 1.2941500649E+01, 3.3307700979E+00, 9.5602075568E-01],
	[3.6185000000E+04, 3.0540860452E+01, 5.2573895854E+00, 1.2947330195E+01, 3.3312514712E+00, 9.5604100488E-01],
	[3.6190000000E+04, 3.0548096491E+01, 5.2574126322E+00, 1.2953161559E+01, 3.3317327228E+00, 9.5606124379E-01],
	[3.6195000000E+04, 3.0555333245E+01, 5.2574356759E+00, 1.2958994743E+01, 3.3322138527E+00, 9.5608147242E-01],
	[3.6200000000E+04, 3.0562570713E+01, 5.2574587165E+00, 1.2964829746E+01, 3.3326948608E+00, 9.5610169079E-01],
	[3.6205000000E+04, 3.0569808895E+01, 5.2574817541E+00, 1.2970666569E+01, 3.3331757473E+00, 9.5612189888E-01],
	[3.6210000000E+04, 3.0577047792E+01, 5.2575047885E+00, 1.2976505213E+01, 3.3336565121E+00, 9.5614209671E-01],
	[3.6215000000E+04, 3.0584287403E+01, 5.2575278199E+00, 1.2982345676E+01, 3.3341371552E+00, 9.5616228429E-01],
	[3.6220000000E+04, 3.0591527729E+01, 5.2575508482E+00, 1.2988187961E+01, 3.3346176767E+00, 9.5618246161E-01],
	[3.6225000000E+04, 3.0598768768E+01, 5.2575738735E+00, 1.2994032067E+01, 3.3350980766E+00, 9.5620262869E-01],
	[3.6230000000E+04, 3.0606028435E+01, 5.2575991642E+00, 1.2999877994E+01, 3.3355794807E+00, 9.5622278553E-01],
	[3.6235000000E+04, 3.0613290481E+01, 5.2576246615E+00, 1.3005725743E+01, 3.3360608679E+00, 9.5624293213E-01],
	[3.6240000000E+04, 3.0620553248E+01, 5.2576501555E+00, 1.3011575314E+01, 3.3365421339E+00, 9.5626306850E-01],
	[3.6245000000E+04, 3.0627816736E+01, 5.2576756461E+00, 1.3017426707E+01, 3.3370232788E+00, 9.5628319465E-01],
	[3.6250000000E+04, 3.0635080944E+01, 5.2577011333E+00, 1.3023279923E+01, 3.3375043025E+00, 9.5630331058E-01],
	[3.6255000000E+04, 3.0642345873E+01, 5.2577266171E+00, 1.3029134962E+01, 3.3379852052E+00, 9.5632341629E-01],
	[3.6260000000E+04, 3.0649611523E+01, 5.2577520975E+00, 1.3034991825E+01, 3.3384659867E+00, 9.5634351180E-01],
	[3.6265000000E+04, 3.0656877893E+01, 5.2577775745E+00, 1.3040850511E+01, 3.3389466472E+00, 9.5636359710E-01],
	[3.6270000000E+04, 3.0664144984E+01, 5.2578030481E+00, 1.3046711021E+01, 3.3394271867E+00, 9.5638367221E-01],
	[3.6275000000E+04, 3.0671412795E+01, 5.2578285184E+00, 1.3052573355E+01, 3.3399076050E+00, 9.5640373712E-01],
	[3.6280000000E+04, 3.0678681327E+01, 5.2578539852E+00, 1.3058437514E+01, 3.3403879024E+00, 9.5642379185E-01],
	[3.6285000000E+04, 3.0685950579E+01, 5.2578794487E+00, 1.3064303498E+01, 3.3408680788E+00, 9.5644383640E-01],
	[3.6290000000E+04, 3.0693220552E+01, 5.2579049088E+00, 1.3070171307E+01, 3.3413481341E+00, 9.5646387077E-01],
	[3.6295000000E+04, 3.0700491245E+01, 5.2579303655E+00, 1.3076040941E+01, 3.3418280685E+00, 9.5648389497E-01],
	[3.6300000000E+04, 3.0707762659E+01, 5.2579558188E+00, 1.3081912401E+01, 3.3423078820E+00, 9.5650390900E-01],
	[3.6305000000E+04, 3.0715034793E+01, 5.2579812687E+00, 1.3087785688E+01, 3.3427875745E+00, 9.5652391288E-01],
	[3.6310000000E+04, 3.0722307647E+01, 5.2580067153E+00, 1.3093660801E+01, 3.3432671460E+00, 9.5654390660E-01],
	[3.6315000000E+04, 3.0729581222E+01, 5.2580321584E+00, 1.3099537741E+01, 3.3437465967E+00, 9.5656389018E-01],
	[3.6320000000E+04, 3.0736855517E+01, 5.2580575982E+00, 1.3105416508E+01, 3.3442259265E+00, 9.5658386361E-01],
	[3.6325000000E+04, 3.0744130532E+01, 5.2580830346E+00, 1.3111297102E+01, 3.3447051353E+00, 9.5660382690E-01],
	[3.6330000000E+04, 3.0751406267E+01, 5.2581084676E+00, 1.3117179524E+01, 3.3451842234E+00, 9.5662378006E-01],
	[3.6335000000E+04, 3.0758682723E+01, 5.2581338973E+00, 1.3123063775E+01, 3.3456631906E+00, 9.5664372309E-01],
	[3.6340000000E+04, 3.0765959899E+01, 5.2581593236E+00, 1.3128949853E+01, 3.3461420369E+00, 9.5666365600E-01],
	[3.6345000000E+04, 3.0773237795E+01, 5.2581847465E+00, 1.3134837761E+01, 3.3466207625E+00, 9.5668357879E-01],
	[3.6350000000E+04, 3.0780516411E+01, 5.2582101660E+00, 1.3140727497E+01, 3.3470993672E+00, 9.5670349148E-01],
	[3.6355000000E+04, 3.0787795747E+01, 5.2582355822E+00, 1.3146619063E+01, 3.3475778512E+00, 9.5672339405E-01],
	[3.6360000000E+04, 3.0795075803E+01, 5.2582609949E+00, 1.3152512458E+01, 3.3480562144E+00, 9.5674328653E-01],
	[3.6365000000E+04, 3.0802356580E+01, 5.2582864044E+00, 1.3158407683E+01, 3.3485344569E+00, 9.5676316891E-01],
	[3.6370000000E+04, 3.0809638076E+01, 5.2583118104E+00, 1.3164304739E+01, 3.3490125787E+00, 9.5678304121E-01],
	[3.6375000000E+04, 3.0816920292E+01, 5.2583372131E+00, 1.3170203625E+01, 3.3494905797E+00, 9.5680290342E-01],
	[3.6380000000E+04, 3.0824203228E+01, 5.2583626124E+00, 1.3176104342E+01, 3.3499684601E+00, 9.5682275555E-01],
	[3.6385000000E+04, 3.0831486885E+01, 5.2583880083E+00, 1.3182006890E+01, 3.3504462197E+00, 9.5684259760E-01],
	[3.6390000000E+04, 3.0838771261E+01, 5.2584134009E+00, 1.3187911270E+01, 3.3509238588E+00, 9.5686242959E-01],
	[3.6395000000E+04, 3.0846056357E+01, 5.2584387901E+00, 1.3193817481E+01, 3.3514013771E+00, 9.5688225152E-01],
	[3.6400000000E+04, 3.0853342173E+01, 5.2584641759E+00, 1.3199725525E+01, 3.3518787749E+00, 9.5690206339E-01],
	[3.6405000000E+04, 3.0860628708E+01, 5.2584895584E+00, 1.3205635402E+01, 3.3523560520E+00, 9.5692186520E-01],
	[3.6410000000E+04, 3.0867915964E+01, 5.2585149375E+00, 1.3211547111E+01, 3.3528332086E+00, 9.5694165698E-01],
	[3.6415000000E+04, 3.0875203939E+01, 5.2585403132E+00, 1.3217460653E+01, 3.3533102445E+00, 9.5696143871E-01],
	[3.6420000000E+04, 3.0882492634E+01, 5.2585656856E+00, 1.3223376029E+01, 3.3537871599E+00, 9.5698121040E-01],
	[3.6425000000E+04, 3.0889782049E+01, 5.2585910546E+00, 1.3229293238E+01, 3.3542639548E+00, 9.5700097206E-01],
	[3.6430000000E+04, 3.0897072183E+01, 5.2586164203E+00, 1.3235212282E+01, 3.3547406292E+00, 9.5702072370E-01],
	[3.6435000000E+04, 3.0904363037E+01, 5.2586417826E+00, 1.3241133160E+01, 3.3552171830E+00, 9.5704046532E-01],
	[3.6440000000E+04, 3.0911654610E+01, 5.2586671416E+00, 1.3247055872E+01, 3.3556936163E+00, 9.5706019693E-01],
	[3.6445000000E+04, 3.0918946904E+01, 5.2586924971E+00, 1.3252980420E+01, 3.3561699292E+00, 9.5707991853E-01],
	[3.6450000000E+04, 3.0926239916E+01, 5.2587178494E+00, 1.3258906803E+01, 3.3566461216E+00, 9.5709963012E-01],
	[3.6455000000E+04, 3.0933533649E+01, 5.2587431983E+00, 1.3264835021E+01, 3.3571221936E+00, 9.5711933172E-01],
	[3.6460000000E+04, 3.0940828101E+01, 5.2587685438E+00, 1.3270765076E+01, 3.3575981452E+00, 9.5713902332E-01],
	[3.6465000000E+04, 3.0948123272E+01, 5.2587938860E+00, 1.3276696967E+01, 3.3580739763E+00, 9.5715870493E-01],
	[3.6470000000E+04, 3.0955419163E+01, 5.2588192248E+00, 1.3282630694E+01, 3.3585496871E+00, 9.5717837657E-01],
	[3.6475000000E+04, 3.0962715773E+01, 5.2588445602E+00, 1.3288566259E+01, 3.3590252775E+00, 9.5719803822E-01],
	[3.6480000000E+04, 3.0970013103E+01, 5.2588698924E+00, 1.3294503660E+01, 3.3595007475E+00, 9.5721768991E-01],
	[3.6485000000E+04, 3.0977311152E+01, 5.2588952211E+00, 1.3300442899E+01, 3.3599760972E+00, 9.5723733163E-01],
	[3.6490000000E+04, 3.0984609920E+01, 5.2589205465E+00, 1.3306383977E+01, 3.3604513265E+00, 9.5725696339E-01],
	[3.6495000000E+04, 3.0991909408E+01, 5.2589458686E+00, 1.3312326892E+01, 3.3609264356E+00, 9.5727658519E-01],
	[3.6500000000E+04, 3.0999209615E+01, 5.2589711873E+00, 1.3318271645E+01, 3.3614014244E+00, 9.5729619704E-01],
	[3.6505000000E+04, 3.1006510541E+01, 5.2589965027E+00, 1.3324218238E+01, 3.3618762929E+00, 9.5731579895E-01],
	[3.6510000000E+04, 3.1013812186E+01, 5.2590218147E+00, 1.3330166670E+01, 3.3623510412E+00, 9.5733539092E-01],
	[3.6515000000E+04, 3.1021114551E+01, 5.2590471234E+00, 1.3336116941E+01, 3.3628256692E+00, 9.5735497296E-01],
	[3.6520000000E+04, 3.1028417635E+01, 5.2590724288E+00, 1.3342069052E+01, 3.3633001770E+00, 9.5737454507E-01],
	[3.6525000000E+04, 3.1035721438E+01, 5.2590977308E+00, 1.3348023003E+01, 3.3637745646E+00, 9.5739410725E-01],
	[3.6530000000E+04, 3.1043025960E+01, 5.2591230294E+00, 1.3353978794E+01, 3.3642488321E+00, 9.5741365952E-01],
	[3.6535000000E+04, 3.1050331201E+01, 5.2591483247E+00, 1.3359936426E+01, 3.3647229793E+00, 9.5743320187E-01],
	[3.6540000000E+04, 3.1057637161E+01, 5.2591736167E+00, 1.3365895899E+01, 3.3651970064E+00, 9.5745273432E-01],
	[3.6545000000E+04, 3.1064943841E+01, 5.2591989053E+00, 1.3371857214E+01, 3.3656709134E+00, 9.5747225687E-01],
	[3.6550000000E+04, 3.1072251239E+01, 5.2592241906E+00, 1.3377820370E+01, 3.3661447003E+00, 9.5749176952E-01],
	[3.6555000000E+04, 3.1079559356E+01, 5.2592494726E+00, 1.3383785368E+01, 3.3666183670E+00, 9.5751127228E-01],
	[3.6560000000E+04, 3.1086868193E+01, 5.2592747512E+00, 1.3389752208E+01, 3.3670919137E+00, 9.5753076515E-01],
	[3.6565000000E+04, 3.1094177748E+01, 5.2593000265E+00, 1.3395720891E+01, 3.3675653404E+00, 9.5755024814E-01],
	[3.6570000000E+04, 3.1101488022E+01, 5.2593252985E+00, 1.3401691417E+01, 3.3680386469E+00, 9.5756972126E-01],
	[3.6575000000E+04, 3.1108799015E+01, 5.2593505671E+00, 1.3407663786E+01, 3.3685118335E+00, 9.5758918451E-01],
	[3.6580000000E+04, 3.1116110727E+01, 5.2593758324E+00, 1.3413637999E+01, 3.3689849000E+00, 9.5760863789E-01],
	[3.6585000000E+04, 3.1123423158E+01, 5.2594010944E+00, 1.3419614056E+01, 3.3694578466E+00, 9.5762808141E-01],
	[3.6590000000E+04, 3.1130736307E+01, 5.2594263530E+00, 1.3425591956E+01, 3.3699306732E+00, 9.5764751508E-01],
	[3.6595000000E+04, 3.1138050176E+01, 5.2594516083E+00, 1.3431571702E+01, 3.3704033798E+00, 9.5766693891E-01],
	[3.6600000000E+04, 3.1145364763E+01, 5.2594768602E+00, 1.3437553292E+01, 3.3708759665E+00, 9.5768635289E-01],
	[3.6605000000E+04, 3.1152680068E+01, 5.2595021089E+00, 1.3443536727E+01, 3.3713484332E+00, 9.5770575703E-01],
	[3.6610000000E+04, 3.1159996093E+01, 5.2595273542E+00, 1.3449522008E+01, 3.3718207801E+00, 9.5772515134E-01],
	[3.6615000000E+04, 3.1167312836E+01, 5.2595525962E+00, 1.3455509134E+01, 3.3722930070E+00, 9.5774453582E-01],
	[3.6620000000E+04, 3.1174630298E+01, 5.2595778348E+00, 1.3461498107E+01, 3.3727651141E+00, 9.5776391048E-01],
	[3.6625000000E+04, 3.1181948478E+01, 5.2596030702E+00, 1.3467488926E+01, 3.3732371014E+00, 9.5778327532E-01],
	[3.6630000000E+04, 3.1189267377E+01, 5.2596283022E+00, 1.3473481592E+01, 3.3737089688E+00, 9.5780263035E-01],
	[3.6635000000E+04, 3.1196586994E+01, 5.2596535309E+00, 1.3479476104E+01, 3.3741807164E+00, 9.5782197558E-01],
	[3.6640000000E+04, 3.1203907330E+01, 5.2596787563E+00, 1.3485472465E+01, 3.3746523442E+00, 9.5784131101E-01],
	[3.6645000000E+04, 3.1211228385E+01, 5.2597039783E+00, 1.3491470672E+01, 3.3751238522E+00, 9.5786063664E-01],
	[3.6650000000E+04, 3.1218550157E+01, 5.2597291970E+00, 1.3497470728E+01, 3.3755952404E+00, 9.5787995248E-01],
	[3.6655000000E+04, 3.1225872649E+01, 5.2597544124E+00, 1.3503472632E+01, 3.3760665089E+00, 9.5789925854E-01],
	[3.6660000000E+04, 3.1233195859E+01, 5.2597796245E+00, 1.3509476385E+01, 3.3765376577E+00, 9.5791855481E-01],
	[3.6665000000E+04, 3.1240519787E+01, 5.2598048333E+00, 1.3515481987E+01, 3.3770086867E+00, 9.5793784132E-01],
	[3.6670000000E+04, 3.1247844433E+01, 5.2598300387E+00, 1.3521489438E+01, 3.3774795961E+00, 9.5795711805E-01],
	[3.6675000000E+04, 3.1255169798E+01, 5.2598552409E+00, 1.3527498738E+01, 3.3779503858E+00, 9.5797638502E-01],
	[3.6680000000E+04, 3.1262495881E+01, 5.2598804397E+00, 1.3533509889E+01, 3.3784210558E+00, 9.5799564223E-01],
	[3.6685000000E+04, 3.1269822682E+01, 5.2599056352E+00, 1.3539522889E+01, 3.3788916062E+00, 9.5801488970E-01],
	[3.6690000000E+04, 3.1277150202E+01, 5.2599308274E+00, 1.3545537740E+01, 3.3793620369E+00, 9.5803412741E-01],
	[3.6695000000E+04, 3.1284478440E+01, 5.2599560163E+00, 1.3551554442E+01, 3.3798323481E+00, 9.5805335538E-01],
	[3.6700000000E+04, 3.1291807396E+01, 5.2599812019E+00, 1.3557572996E+01, 3.3803025396E+00, 9.5807257361E-01],
	[3.6705000000E+04, 3.1299137070E+01, 5.2600063841E+00, 1.3563593400E+01, 3.3807726116E+00, 9.5809178212E-01],
	[3.6710000000E+04, 3.1306467463E+01, 5.2600315631E+00, 1.3569615657E+01, 3.3812425641E+00, 9.5811098089E-01],
	[3.6715000000E+04, 3.1313798573E+01, 5.2600567387E+00, 1.3575639765E+01, 3.3817123970E+00, 9.5813016995E-01],
	[3.6720000000E+04, 3.1321130402E+01, 5.2600819111E+00, 1.3581665726E+01, 3.3821821104E+00, 9.5814934929E-01],
	[3.6725000000E+04, 3.1328462948E+01, 5.2601070801E+00, 1.3587693540E+01, 3.3826517043E+00, 9.5816851892E-01],
	[3.6730000000E+04, 3.1335796213E+01, 5.2601322458E+00, 1.3593723207E+01, 3.3831211787E+00, 9.5818767884E-01],
	[3.6735000000E+04, 3.1343130195E+01, 5.2601574082E+00, 1.3599754727E+01, 3.3835905336E+00, 9.5820682906E-01],
	[3.6740000000E+04, 3.1350464896E+01, 5.2601825673E+00, 1.3605788101E+01, 3.3840597691E+00, 9.5822596959E-01],
	[3.6745000000E+04, 3.1357800314E+01, 5.2602077231E+00, 1.3611823328E+01, 3.3845288852E+00, 9.5824510043E-01],
	[3.6750000000E+04, 3.1365136451E+01, 5.2602328756E+00, 1.3617860411E+01, 3.3849978819E+00, 9.5826422159E-01],
	[3.6755000000E+04, 3.1372473305E+01, 5.2602580249E+00, 1.3623899347E+01, 3.3854667592E+00, 9.5828333307E-01],
	[3.6760000000E+04, 3.1379810877E+01, 5.2602831708E+00, 1.3629940139E+01, 3.3859355171E+00, 9.5830243487E-01],
	[3.6765000000E+04, 3.1387149167E+01, 5.2603083134E+00, 1.3635982786E+01, 3.3864041556E+00, 9.5832152701E-01],
	[3.6770000000E+04, 3.1394488175E+01, 5.2603334527E+00, 1.3642027289E+01, 3.3868726748E+00, 9.5834060948E-01],
	[3.6775000000E+04, 3.1401827901E+01, 5.2603585887E+00, 1.3648073647E+01, 3.3873410747E+00, 9.5835968230E-01],
	[3.6780000000E+04, 3.1409168344E+01, 5.2603837214E+00, 1.3654121862E+01, 3.3878093553E+00, 9.5837874546E-01],
	[3.6785000000E+04, 3.1416509505E+01, 5.2604088508E+00, 1.3660171934E+01, 3.3882775166E+00, 9.5839779898E-01],
	[3.6790000000E+04, 3.1423851384E+01, 5.2604339769E+00, 1.3666223862E+01, 3.3887455587E+00, 9.5841684286E-01],
	[3.6795000000E+04, 3.1431193980E+01, 5.2604590997E+00, 1.3672277647E+01, 3.3892134814E+00, 9.5843587709E-01],
	[3.6800000000E+04, 3.1438537294E+01, 5.2604842193E+00, 1.3678333290E+01, 3.3896812850E+00, 9.5845490170E-01],
	[3.6805000000E+04, 3.1445881326E+01, 5.2605093355E+00, 1.3684390791E+01, 3.3901489694E+00, 9.5847391668E-01],
	[3.6810000000E+04, 3.1453231481E+01, 5.2605351251E+00, 1.3690450149E+01, 3.3906168785E+00, 9.5849292204E-01],
	[3.6815000000E+04, 3.1460596311E+01, 5.2605626578E+00, 1.3696511367E+01, 3.3910855563E+00, 9.5851191779E-01],
	[3.6820000000E+04, 3.1467961865E+01, 5.2605901868E+00, 1.3702574443E+01, 3.3915541154E+00, 9.5853090392E-01],
	[3.6825000000E+04, 3.1475328143E+01, 5.2606177122E+00, 1.3708639378E+01, 3.3920225558E+00, 9.5854988045E-01],
	[3.6830000000E+04, 3.1482695145E+01, 5.2606452341E+00, 1.3714706172E+01, 3.3924908774E+00, 9.5856884738E-01],
	[3.6835000000E+04, 3.1490062871E+01, 5.2606727524E+00, 1.3720774827E+01, 3.3929590804E+00, 9.5858780472E-01],
	[3.6840000000E+04, 3.1497431320E+01, 5.2607002670E+00, 1.3726845341E+01, 3.3934271646E+00, 9.5860675247E-01],
	[3.6845000000E+04, 3.1504800493E+01, 5.2607277781E+00, 1.3732917715E+01, 3.3938951302E+00, 9.5862569063E-01],
	[3.6850000000E+04, 3.1512170390E+01, 5.2607552856E+00, 1.3738991951E+01, 3.3943629771E+00, 9.5864461922E-01],
	[3.6855000000E+04, 3.1519541011E+01, 5.2607827895E+00, 1.3745068047E+01, 3.3948307054E+00, 9.5866353823E-01],
	[3.6860000000E+04, 3.1526912356E+01, 5.2608102898E+00, 1.3751146005E+01, 3.3952983151E+00, 9.5868244767E-01],
	[3.6865000000E+04, 3.1534284424E+01, 5.2608377866E+00, 1.3757225824E+01, 3.3957658062E+00, 9.5870134755E-01],
	[3.6870000000E+04, 3.1541657216E+01, 5.2608652797E+00, 1.3763307505E+01, 3.3962331787E+00, 9.5872023787E-01],
	[3.6875000000E+04, 3.1549030732E+01, 5.2608927693E+00, 1.3769391048E+01, 3.3967004326E+00, 9.5873911864E-01],
	[3.6880000000E+04, 3.1556404971E+01, 5.2609202552E+00, 1.3775476454E+01, 3.3971675680E+00, 9.5875798986E-01],
	[3.6885000000E+04, 3.1563779934E+01, 5.2609477376E+00, 1.3781563723E+01, 3.3976345849E+00, 9.5877685154E-01],
	[3.6890000000E+04, 3.1571155621E+01, 5.2609752165E+00, 1.3787652855E+01, 3.3981014832E+00, 9.5879570368E-01],
	[3.6895000000E+04, 3.1578532031E+01, 5.2610026917E+00, 1.3793743851E+01, 3.3985682631E+00, 9.5881454628E-01],
	[3.6900000000E+04, 3.1585909164E+01, 5.2610301633E+00, 1.3799836710E+01, 3.3990349245E+00, 9.5883337936E-01],
	[3.6905000000E+04, 3.1593287021E+01, 5.2610576314E+00, 1.3805931433E+01, 3.3995014675E+00, 9.5885220291E-01],
	[3.6910000000E+04, 3.1600665602E+01, 5.2610850959E+00, 1.3812028022E+01, 3.3999678920E+00, 9.5887101694E-01],
	[3.6915000000E+04, 3.1608044906E+01, 5.2611125568E+00, 1.3818126474E+01, 3.4004341981E+00, 9.5888982145E-01],
	[3.6920000000E+04, 3.1615424933E+01, 5.2611400142E+00, 1.3824226792E+01, 3.4009003858E+00, 9.5890861645E-01],
	[3.6925000000E+04, 3.1622805684E+01, 5.2611674679E+00, 1.3830328976E+01, 3.4013664551E+00, 9.5892740195E-01],
	[3.6930000000E+04, 3.1630187158E+01, 5.2611949181E+00, 1.3836433025E+01, 3.4018324061E+00, 9.5894617795E-01],
	[3.6935000000E+04, 3.1637569355E+01, 5.2612223647E+00, 1.3842538940E+01, 3.4022982387E+00, 9.5896494445E-01],
	[3.6940000000E+04, 3.1644952276E+01, 5.2612498078E+00, 1.3848646721E+01, 3.4027639530E+00, 9.5898370146E-01],
	[3.6945000000E+04, 3.1652335920E+01, 5.2612772473E+00, 1.3854756369E+01, 3.4032295490E+00, 9.5900244899E-01],
	[3.6950000000E+04, 3.1659720287E+01, 5.2613046832E+00, 1.3860867885E+01, 3.4036950267E+00, 9.5902118703E-01],
	[3.6955000000E+04, 3.1667105378E+01, 5.2613321155E+00, 1.3866981267E+01, 3.4041603861E+00, 9.5903991559E-01],
	[3.6960000000E+04, 3.1674491191E+01, 5.2613595443E+00, 1.3873096517E+01, 3.4046256273E+00, 9.5905863469E-01],
	[3.6965000000E+04, 3.1681877728E+01, 5.2613869695E+00, 1.3879213636E+01, 3.4050907502E+00, 9.5907734431E-01],
	[3.6970000000E+04, 3.1689264988E+01, 5.2614143911E+00, 1.3885332622E+01, 3.4055557549E+00, 9.5909604447E-01],
	[3.6975000000E+04, 3.1696652971E+01, 5.2614418092E+00, 1.3891453477E+01, 3.4060206415E+00, 9.5911473518E-01],
	[3.6980000000E+04, 3.1704041678E+01, 5.2614692237E+00, 1.3897576201E+01, 3.4064854098E+00, 9.5913341643E-01],
	[3.6985000000E+04, 3.1711431107E+01, 5.2614966346E+00, 1.3903700794E+01, 3.4069500600E+00, 9.5915208823E-01],
	[3.6990000000E+04, 3.1718821259E+01, 5.2615240420E+00, 1.3909827257E+01, 3.4074145921E+00, 9.5917075059E-01],
	[3.6995000000E+04, 3.1726212135E+01, 5.2615514458E+00, 1.3915955589E+01, 3.4078790060E+00, 9.5918940351E-01],
	[3.7000000000E+04, 3.1733603733E+01, 5.2615788461E+00, 1.3922085792E+01, 3.4083433018E+00, 9.5920804700E-01],
	[3.7005000000E+04, 3.1740996054E+01, 5.2616062428E+00, 1.3928217865E+01, 3.4088074796E+00, 9.5922668105E-01],
	[3.7010000000E+04, 3.1748389098E+01, 5.2616336359E+00, 1.3934351809E+01, 3.4092715393E+00, 9.5924530568E-01],
	[3.7015000000E+04, 3.1755782865E+01, 5.2616610255E+00, 1.3940487625E+01, 3.4097354809E+00, 9.5926392089E-01],
	[3.7020000000E+04, 3.1763177355E+01, 5.2616884115E+00, 1.3946625311E+01, 3.4101993045E+00, 9.5928252669E-01],
	[3.7025000000E+04, 3.1770572568E+01, 5.2617157940E+00, 1.3952764870E+01, 3.4106630100E+00, 9.5930112308E-01],
	[3.7030000000E+04, 3.1777968504E+01, 5.2617431729E+00, 1.3958906300E+01, 3.4111265976E+00, 9.5931971006E-01],
	[3.7035000000E+04, 3.1785365162E+01, 5.2617705483E+00, 1.3965049603E+01, 3.4115900672E+00, 9.5933828764E-01],
	[3.7040000000E+04, 3.1792762543E+01, 5.2617979201E+00, 1.3971194779E+01, 3.4120534189E+00, 9.5935685582E-01],
	[3.7045000000E+04, 3.1800160647E+01, 5.2618252883E+00, 1.3977341828E+01, 3.4125166526E+00, 9.5937541461E-01],
	[3.7050000000E+04, 3.1807559474E+01, 5.2618526530E+00, 1.3983490750E+01, 3.4129797684E+00, 9.5939396402E-01],
	[3.7055000000E+04, 3.1814959023E+01, 5.2618800142E+00, 1.3989641545E+01, 3.4134427663E+00, 9.5941250404E-01],
	[3.7060000000E+04, 3.1822359295E+01, 5.2619073718E+00, 1.3995794215E+01, 3.4139056463E+00, 9.5943103469E-01],
	[3.7065000000E+04, 3.1829760290E+01, 5.2619347258E+00, 1.4001948759E+01, 3.4143684085E+00, 9.5944955596E-01],
	[3.7070000000E+04, 3.1837162007E+01, 5.2619620763E+00, 1.4008105178E+01, 3.4148310528E+00, 9.5946806787E-01],
	[3.7075000000E+04, 3.1844564447E+01, 5.2619894233E+00, 1.4014263471E+01, 3.4152935793E+00, 9.5948657041E-01],
	[3.7080000000E+04, 3.1851967609E+01, 5.2620167667E+00, 1.4020423640E+01, 3.4157559879E+00, 9.5950506360E-01],
	[3.7085000000E+04, 3.1859371494E+01, 5.2620441066E+00, 1.4026585685E+01, 3.4162182788E+00, 9.5952354743E-01],
	[3.7090000000E+04, 3.1866776101E+01, 5.2620714429E+00, 1.4032749605E+01, 3.4166804519E+00, 9.5954202191E-01],
	[3.7095000000E+04, 3.1874181431E+01, 5.2620987757E+00, 1.4038915402E+01, 3.4171425073E+00, 9.5956048705E-01],
	[3.7100000000E+04, 3.1881587483E+01, 5.2621261049E+00, 1.4045083075E+01, 3.4176044449E+00, 9.5957894286E-01],
	[3.7105000000E+04, 3.1888994258E+01, 5.2621534306E+00, 1.4051252625E+01, 3.4180662649E+00, 9.5959738932E-01],
	[3.7110000000E+04, 3.1896401755E+01, 5.2621807528E+00, 1.4057424052E+01, 3.4185279671E+00, 9.5961582646E-01],
	[3.7115000000E+04, 3.1903809975E+01, 5.2622080714E+00, 1.4063597357E+01, 3.4189895516E+00, 9.5963425427E-01],
	[3.7120000000E+04, 3.1911218916E+01, 5.2622353865E+00, 1.4069772539E+01, 3.4194510185E+00, 9.5965267276E-01],
	[3.7125000000E+04, 3.1918628580E+01, 5.2622626980E+00, 1.4075949599E+01, 3.4199123677E+00, 9.5967108194E-01],
	[3.7130000000E+04, 3.1926038967E+01, 5.2622900060E+00, 1.4082128538E+01, 3.4203735994E+00, 9.5968948181E-01],
	[3.7135000000E+04, 3.1933450075E+01, 5.2623173105E+00, 1.4088309356E+01, 3.4208347134E+00, 9.5970787237E-01],
	[3.7140000000E+04, 3.1940861906E+01, 5.2623446114E+00, 1.4094492053E+01, 3.4212957098E+00, 9.5972625363E-01],
	[3.7145000000E+04, 3.1948274459E+01, 5.2623719088E+00, 1.4100676629E+01, 3.4217565887E+00, 9.5974462559E-01],
	[3.7150000000E+04, 3.1955687734E+01, 5.2623992027E+00, 1.4106863085E+01, 3.4222173501E+00, 9.5976298826E-01],
	[3.7155000000E+04, 3.1963101732E+01, 5.2624264931E+00, 1.4113051421E+01, 3.4226779939E+00, 9.5978134165E-01],
	[3.7160000000E+04, 3.1970516451E+01, 5.2624537799E+00, 1.4119241637E+01, 3.4231385202E+00, 9.5979968575E-01],
	[3.7165000000E+04, 3.1977931893E+01, 5.2624810631E+00, 1.4125433734E+01, 3.4235989290E+00, 9.5981802057E-01],
	[3.7170000000E+04, 3.1985348056E+01, 5.2625083429E+00, 1.4131627712E+01, 3.4240592203E+00, 9.5983634613E-01],
	[3.7175000000E+04, 3.1992764942E+01, 5.2625356191E+00, 1.4137823571E+01, 3.4245193942E+00, 9.5985466241E-01],
	[3.7180000000E+04, 3.2000182550E+01, 5.2625628918E+00, 1.4144021312E+01, 3.4249794507E+00, 9.5987296943E-01],
	[3.7185000000E+04, 3.2007600879E+01, 5.2625901610E+00, 1.4150220935E+01, 3.4254393897E+00, 9.5989126720E-01],
	[3.7190000000E+04, 3.2015019931E+01, 5.2626174266E+00, 1.4156422440E+01, 3.4258992114E+00, 9.5990955571E-01],
	[3.7195000000E+04, 3.2022439705E+01, 5.2626446887E+00, 1.4162625828E+01, 3.4263589157E+00, 9.5992783497E-01],
	[3.7200000000E+04, 3.2029860200E+01, 5.2626719473E+00, 1.4168831098E+01, 3.4268185026E+00, 9.5994610498E-01],
	[3.7205000000E+04, 3.2037281417E+01, 5.2626992024E+00, 1.4175038252E+01, 3.4272779722E+00, 9.5996436576E-01],
	[3.7210000000E+04, 3.2044703357E+01, 5.2627264540E+00, 1.4181247289E+01, 3.4277373245E+00, 9.5998261730E-01],
	[3.7215000000E+04, 3.2052126018E+01, 5.2627537020E+00, 1.4187458210E+01, 3.4281965594E+00, 9.6000085962E-01],
	[3.7220000000E+04, 3.2059549401E+01, 5.2627809465E+00, 1.4193671015E+01, 3.4286556771E+00, 9.6001909270E-01],
	[3.7225000000E+04, 3.2066973505E+01, 5.2628081875E+00, 1.4199885705E+01, 3.4291146776E+00, 9.6003731657E-01],
	[3.7230000000E+04, 3.2074398331E+01, 5.2628354250E+00, 1.4206102280E+01, 3.4295735608E+00, 9.6005553122E-01],
	[3.7235000000E+04, 3.2081823880E+01, 5.2628626589E+00, 1.4212320739E+01, 3.4300323267E+00, 9.6007373666E-01],
	[3.7240000000E+04, 3.2089250149E+01, 5.2628898894E+00, 1.4218541084E+01, 3.4304909755E+00, 9.6009193290E-01],
	[3.7245000000E+04, 3.2096677141E+01, 5.2629171163E+00, 1.4224763315E+01, 3.4309495071E+00, 9.6011011993E-01],
	[3.7250000000E+04, 3.2104104854E+01, 5.2629443397E+00, 1.4230987432E+01, 3.4314079215E+00, 9.6012829777E-01],
	[3.7255000000E+04, 3.2111533288E+01, 5.2629715596E+00, 1.4237213435E+01, 3.4318662188E+00, 9.6014646641E-01],
	[3.7260000000E+04, 3.2118962445E+01, 5.2629987760E+00, 1.4243441325E+01, 3.4323243989E+00, 9.6016462587E-01],
	[3.7265000000E+04, 3.2126392322E+01, 5.2630259889E+00, 1.4249671102E+01, 3.4327824620E+00, 9.6018277614E-01],
	[3.7270000000E+04, 3.2133822922E+01, 5.2630531983E+00, 1.4255902766E+01, 3.4332404079E+00, 9.6020091724E-01],
	[3.7275000000E+04, 3.2141254243E+01, 5.2630804041E+00, 1.4262136318E+01, 3.4336982368E+00, 9.6021904916E-01],
	[3.7280000000E+04, 3.2148686285E+01, 5.2631076065E+00, 1.4268371758E+01, 3.4341559486E+00, 9.6023717192E-01],
	[3.7285000000E+04, 3.2156119049E+01, 5.2631348053E+00, 1.4274609086E+01, 3.4346135434E+00, 9.6025528551E-01],
	[3.7290000000E+04, 3.2163552534E+01, 5.2631620006E+00, 1.4280848303E+01, 3.4350710212E+00, 9.6027338994E-01],
	[3.7295000000E+04, 3.2170986740E+01, 5.2631891925E+00, 1.4287089409E+01, 3.4355283820E+00, 9.6029148522E-01],
	[3.7300000000E+04, 3.2178421668E+01, 5.2632163808E+00, 1.4293332404E+01, 3.4359856258E+00, 9.6030957135E-01],
	[3.7305000000E+04, 3.2185857318E+01, 5.2632435656E+00, 1.4299577289E+01, 3.4364427527E+00, 9.6032764834E-01],
	[3.7310000000E+04, 3.2193293688E+01, 5.2632707469E+00, 1.4305824063E+01, 3.4368997626E+00, 9.6034571618E-01],
	[3.7315000000E+04, 3.2200730780E+01, 5.2632979247E+00, 1.4312072728E+01, 3.4373566557E+00, 9.6036377489E-01],
	[3.7320000000E+04, 3.2208168593E+01, 5.2633250991E+00, 1.4318323283E+01, 3.4378134318E+00, 9.6038182447E-01],
	[3.7325000000E+04, 3.2215607128E+01, 5.2633522699E+00, 1.4324575729E+01, 3.4382700910E+00, 9.6039986492E-01],
	[3.7330000000E+04, 3.2223046383E+01, 5.2633794372E+00, 1.4330830066E+01, 3.4387266334E+00, 9.6041789626E-01],
	[3.7335000000E+04, 3.2230486360E+01, 5.2634066010E+00, 1.4337086295E+01, 3.4391830590E+00, 9.6043591847E-01],
	[3.7340000000E+04, 3.2237927058E+01, 5.2634337613E+00, 1.4343344415E+01, 3.4396393677E+00, 9.6045393158E-01],
	[3.7345000000E+04, 3.2245368477E+01, 5.2634609181E+00, 1.4349604428E+01, 3.4400955597E+00, 9.6047193557E-01],
	[3.7350000000E+04, 3.2252810617E+01, 5.2634880715E+00, 1.4355866333E+01, 3.4405516348E+00, 9.6048993047E-01],
	[3.7355000000E+04, 3.2260253479E+01, 5.2635152213E+00, 1.4362130130E+01, 3.4410075932E+00, 9.6050791627E-01],
	[3.7360000000E+04, 3.2267697061E+01, 5.2635423676E+00, 1.4368395821E+01, 3.4414634349E+00, 9.6052589297E-01],
	[3.7365000000E+04, 3.2275141364E+01, 5.2635695105E+00, 1.4374663405E+01, 3.4419191598E+00, 9.6054386059E-01],
	[3.7370000000E+04, 3.2282586389E+01, 5.2635966498E+00, 1.4380932883E+01, 3.4423747680E+00, 9.6056181913E-01],
	[3.7375000000E+04, 3.2290032134E+01, 5.2636237857E+00, 1.4387204255E+01, 3.4428302596E+00, 9.6057976858E-01],
	[3.7380000000E+04, 3.2297478600E+01, 5.2636509181E+00, 1.4393477521E+01, 3.4432856345E+00, 9.6059770896E-01],
	[3.7385000000E+04, 3.2304925787E+01, 5.2636780470E+00, 1.4399752682E+01, 3.4437408927E+00, 9.6061564028E-01],
	[3.7390000000E+04, 3.2312373695E+01, 5.2637051724E+00, 1.4406029738E+01, 3.4441960343E+00, 9.6063356252E-01],
	[3.7395000000E+04, 3.2319822324E+01, 5.2637322943E+00, 1.4412308689E+01, 3.4446510593E+00, 9.6065147571E-01],
	[3.7400000000E+04, 3.2327271674E+01, 5.2637594127E+00, 1.4418589536E+01, 3.4451059678E+00, 9.6066937985E-01],
	[3.7405000000E+04, 3.2334736400E+01, 5.2637883411E+00, 1.4424872279E+01, 3.4455617031E+00, 9.6068727493E-01],
	[3.7410000000E+04, 3.2342206341E+01, 5.2638178211E+00, 1.4431156917E+01, 3.4460176111E+00, 9.6070516097E-01],
	[3.7415000000E+04, 3.2349677008E+01, 5.2638472974E+00, 1.4437443453E+01, 3.4464734029E+00, 9.6072303797E-01],
	[3.7420000000E+04, 3.2357148403E+01, 5.2638767699E+00, 1.4443731885E+01, 3.4469290786E+00, 9.6074090593E-01],
	[3.7425000000E+04, 3.2364620524E+01, 5.2639062386E+00, 1.4450022215E+01, 3.4473846383E+00, 9.6075876486E-01],
	[3.7430000000E+04, 3.2372093373E+01, 5.2639357035E+00, 1.4456314442E+01, 3.4478400818E+00, 9.6077661476E-01],
	[3.7435000000E+04, 3.2379566948E+01, 5.2639651647E+00, 1.4462608567E+01, 3.4482954092E+00, 9.6079445564E-01],
	[3.7440000000E+04, 3.2387041251E+01, 5.2639946221E+00, 1.4468904590E+01, 3.4487506206E+00, 9.6081228751E-01],
	[3.7445000000E+04, 3.2394516280E+01, 5.2640240757E+00, 1.4475202512E+01, 3.4492057159E+00, 9.6083011036E-01],
	[3.7450000000E+04, 3.2401992036E+01, 5.2640535256E+00, 1.4481502332E+01, 3.4496606953E+00, 9.6084792420E-01],
	[3.7455000000E+04, 3.2409468519E+01, 5.2640829717E+00, 1.4487804051E+01, 3.4501155586E+00, 9.6086572904E-01],
	[3.7460000000E+04, 3.2416945729E+01, 5.2641124140E+00, 1.4494107670E+01, 3.4505703060E+00, 9.6088352488E-01],
	[3.7465000000E+04, 3.2424423665E+01, 5.2641418526E+00, 1.4500413189E+01, 3.4510249374E+00, 9.6090131173E-01],
	[3.7470000000E+04, 3.2431902328E+01, 5.2641712874E+00, 1.4506720608E+01, 3.4514794529E+00, 9.6091908959E-01],
	[3.7475000000E+04, 3.2439381718E+01, 5.2642007184E+00, 1.4513029927E+01, 3.4519338524E+00, 9.6093685847E-01],
	[3.7480000000E+04, 3.2446861835E+01, 5.2642301457E+00, 1.4519341146E+01, 3.4523881361E+00, 9.6095461836E-01],
	[3.7485000000E+04, 3.2454342678E+01, 5.2642595692E+00, 1.4525654267E+01, 3.4528423038E+00, 9.6097236928E-01],
	[3.7490000000E+04, 3.2461824248E+01, 5.2642889890E+00, 1.4531969289E+01, 3.4532963557E+00, 9.6099011123E-01],
	[3.7495000000E+04, 3.2469306544E+01, 5.2643184049E+00, 1.4538286213E+01, 3.4537502918E+00, 9.6100784422E-01],
	[3.7500000000E+04, 3.2476789567E+01, 5.2643478172E+00, 1.4544605039E+01, 3.4542041120E+00, 9.6102556824E-01],
	[3.7505000000E+04, 3.2484273317E+01, 5.2643772257E+00, 1.4550925767E+01, 3.4546578165E+00, 9.6104328331E-01],
	[3.7510000000E+04, 3.2491757793E+01, 5.2644066304E+00, 1.4557248398E+01, 3.4551114052E+00, 9.6106098943E-01],
	[3.7515000000E+04, 3.2499242996E+01, 5.2644360314E+00, 1.4563572931E+01, 3.4555648781E+00, 9.6107868660E-01],
	[3.7520000000E+04, 3.2506728925E+01, 5.2644654286E+00, 1.4569899368E+01, 3.4560182352E+00, 9.6109637482E-01],
	[3.7525000000E+04, 3.2514215581E+01, 5.2644948220E+00, 1.4576227709E+01, 3.4564714767E+00, 9.6111405412E-01],
	[3.7530000000E+04, 3.2521702963E+01, 5.2645242117E+00, 1.4582557953E+01, 3.4569246024E+00, 9.6113172447E-01],
	[3.7535000000E+04, 3.2529191071E+01, 5.2645535977E+00, 1.4588890102E+01, 3.4573776124E+00, 9.6114938590E-01],
	[3.7540000000E+04, 3.2536679906E+01, 5.2645829799E+00, 1.4595224155E+01, 3.4578305068E+00, 9.6116703841E-01],
	[3.7545000000E+04, 3.2544169467E+01, 5.2646123584E+00, 1.4601560113E+01, 3.4582832856E+00, 9.6118468200E-01],
	[3.7550000000E+04, 3.2551659755E+01, 5.2646417331E+00, 1.4607897976E+01, 3.4587359487E+00, 9.6120231667E-01],
	[3.7555000000E+04, 3.2559150768E+01, 5.2646711040E+00, 1.4614237744E+01, 3.4591884962E+00, 9.6121994244E-01],
	[3.7560000000E+04, 3.2566642508E+01, 5.2647004712E+00, 1.4620579419E+01, 3.4596409281E+00, 9.6123755930E-01],
	[3.7565000000E+04, 3.2574134975E+01, 5.2647298347E+00, 1.4626922999E+01, 3.4600932445E+00, 9.6125516726E-01],
	[3.7570000000E+04, 3.2581628167E+01, 5.2647591944E+00, 1.4633268486E+01, 3.4605454453E+00, 9.6127276633E-01],
	[3.7575000000E+04, 3.2589122086E+01, 5.2647885504E+00, 1.4639615880E+01, 3.4609975306E+00, 9.6129035650E-01],
	[3.7580000000E+04, 3.2596616731E+01, 5.2648179027E+00, 1.4645965180E+01, 3.4614495003E+00, 9.6130793779E-01],
	[3.7585000000E+04, 3.2604112102E+01, 5.2648472512E+00, 1.4652316389E+01, 3.4619013546E+00, 9.6132551020E-01],
	[3.7590000000E+04, 3.2611608199E+01, 5.2648765959E+00, 1.4658669504E+01, 3.4623530935E+00, 9.6134307374E-01],
	[3.7595000000E+04, 3.2619105022E+01, 5.2649059369E+00, 1.4665024528E+01, 3.4628047168E+00, 9.6136062840E-01],
	[3.7600000000E+04, 3.2626602571E+01, 5.2649352742E+00, 1.4671381460E+01, 3.4632562248E+00, 9.6137817419E-01],
	[3.7605000000E+04, 3.2634100846E+01, 5.2649646078E+00, 1.4677740301E+01, 3.4637076173E+00, 9.6139571112E-01],
	[3.7610000000E+04, 3.2641599847E+01, 5.2649939376E+00, 1.4684101051E+01, 3.4641588945E+00, 9.6141323920E-01],
	[3.7615000000E+04, 3.2649099575E+01, 5.2650232636E+00, 1.4690463710E+01, 3.4646100563E+00, 9.6143075842E-01],
	[3.7620000000E+04, 3.2656600028E+01, 5.2650525860E+00, 1.4696828279E+01, 3.4650611027E+00, 9.6144826879E-01],
	[3.7625000000E+04, 3.2664101207E+01, 5.2650819046E+00, 1.4703194758E+01, 3.4655120338E+00, 9.6146577032E-01],
	[3.7630000000E+04, 3.2671603112E+01, 5.2651112195E+00, 1.4709563147E+01, 3.4659628496E+00, 9.6148326301E-01],
	[3.7635000000E+04, 3.2679105743E+01, 5.2651405306E+00, 1.4715933447E+01, 3.4664135501E+00, 9.6150074687E-01],
	[3.7640000000E+04, 3.2686609100E+01, 5.2651698380E+00, 1.4722305657E+01, 3.4668641354E+00, 9.6151822190E-01],
	[3.7645000000E+04, 3.2694113182E+01, 5.2651991417E+00, 1.4728679779E+01, 3.4673146054E+00, 9.6153568810E-01],
	[3.7650000000E+04, 3.2701617990E+01, 5.2652284416E+00, 1.4735055812E+01, 3.4677649601E+00, 9.6155314548E-01],
	[3.7655000000E+04, 3.2709123525E+01, 5.2652577379E+00, 1.4741433757E+01, 3.4682151997E+00, 9.6157059405E-01],
	[3.7660000000E+04, 3.2716629784E+01, 5.2652870303E+00, 1.4747813614E+01, 3.4686653240E+00, 9.6158803380E-01],
	[3.7665000000E+04, 3.2724136770E+01, 5.2653163191E+00, 1.4754195384E+01, 3.4691153332E+00, 9.6160546475E-01],
	[3.7670000000E+04, 3.2731644481E+01, 5.2653456042E+00, 1.4760579067E+01, 3.4695652273E+00, 9.6162288690E-01],
	[3.7675000000E+04, 3.2739152918E+01, 5.2653748855E+00, 1.4766964662E+01, 3.4700150062E+00, 9.6164030025E-01],
	[3.7680000000E+04, 3.2746662081E+01, 5.2654041631E+00, 1.4773352171E+01, 3.4704646700E+00, 9.6165770481E-01],
	[3.7685000000E+04, 3.2754171969E+01, 5.2654334369E+00, 1.4779741594E+01, 3.4709142187E+00, 9.6167510058E-01],
	[3.7690000000E+04, 3.2761682583E+01, 5.2654627071E+00, 1.4786132931E+01, 3.4713636524E+00, 9.6169248757E-01],
	[3.7695000000E+04, 3.2769193922E+01, 5.2654919735E+00, 1.4792526183E+01, 3.4718129709E+00, 9.6170986578E-01],
	[3.7700000000E+04, 3.2776705987E+01, 5.2655212362E+00, 1.4798921349E+01, 3.4722621745E+00, 9.6172723521E-01],
	[3.7705000000E+04, 3.2784218777E+01, 5.2655504952E+00, 1.4805318430E+01, 3.4727112631E+00, 9.6174459588E-01],
	[3.7710000000E+04, 3.2791732293E+01, 5.2655797505E+00, 1.4811717427E+01, 3.4731602366E+00, 9.6176194778E-01],
	[3.7715000000E+04, 3.2799246534E+01, 5.2656090021E+00, 1.4818118339E+01, 3.4736090952E+00, 9.6177929093E-01],
	[3.7720000000E+04, 3.2806761501E+01, 5.2656382499E+00, 1.4824521167E+01, 3.4740578389E+00, 9.6179662532E-01],
	[3.7725000000E+04, 3.2814277193E+01, 5.2656674941E+00, 1.4830925912E+01, 3.4745064676E+00, 9.6181395096E-01],
	[3.7730000000E+04, 3.2821793611E+01, 5.2656967345E+00, 1.4837332573E+01, 3.4749549814E+00, 9.6183126785E-01],
	[3.7735000000E+04, 3.2829310753E+01, 5.2657259712E+00, 1.4843741151E+01, 3.4754033803E+00, 9.6184857600E-01],
	[3.7740000000E+04, 3.2836828622E+01, 5.2657552042E+00, 1.4850151646E+01, 3.4758516644E+00, 9.6186587542E-01],
	[3.7745000000E+04, 3.2844347215E+01, 5.2657844335E+00, 1.4856564059E+01, 3.4762998336E+00, 9.6188316610E-01],
	[3.7750000000E+04, 3.2851866534E+01, 5.2658136591E+00, 1.4862978390E+01, 3.4767478879E+00, 9.6190044806E-01],
	[3.7755000000E+04, 3.2859386578E+01, 5.2658428809E+00, 1.4869394639E+01, 3.4771958275E+00, 9.6191772129E-01],
	[3.7760000000E+04, 3.2866907347E+01, 5.2658720991E+00, 1.4875812807E+01, 3.4776436523E+00, 9.6193498581E-01],
	[3.7765000000E+04, 3.2874428841E+01, 5.2659013135E+00, 1.4882232894E+01, 3.4780913623E+00, 9.6195224162E-01],
	[3.7770000000E+04, 3.2881951061E+01, 5.2659305243E+00, 1.4888654899E+01, 3.4785389575E+00, 9.6196948871E-01],
	[3.7775000000E+04, 3.2889474006E+01, 5.2659597313E+00, 1.4895078825E+01, 3.4789864380E+00, 9.6198672710E-01],
	[3.7780000000E+04, 3.2896997676E+01, 5.2659889347E+00, 1.4901504670E+01, 3.4794338039E+00, 9.6200395680E-01],
	[3.7785000000E+04, 3.2904522070E+01, 5.2660181343E+00, 1.4907932435E+01, 3.4798810550E+00, 9.6202117780E-01],
	[3.7790000000E+04, 3.2912047190E+01, 5.2660473302E+00, 1.4914362121E+01, 3.4803281914E+00, 9.6203839010E-01],
	[3.7795000000E+04, 3.2919573035E+01, 5.2660765225E+00, 1.4920793727E+01, 3.4807752133E+00, 9.6205559373E-01],
	[3.7800000000E+04, 3.2927099605E+01, 5.2661057110E+00, 1.4927227255E+01, 3.4812221204E+00, 9.6207278867E-01],
	[3.7805000000E+04, 3.2934626900E+01, 5.2661348958E+00, 1.4933662704E+01, 3.4816689130E+00, 9.6208997494E-01],
	[3.7810000000E+04, 3.2942154920E+01, 5.2661640770E+00, 1.4940100074E+01, 3.4821155910E+00, 9.6210715253E-01],
	[3.7815000000E+04, 3.2949683665E+01, 5.2661932544E+00, 1.4946539367E+01, 3.4825621544E+00, 9.6212432146E-01],
	[3.7820000000E+04, 3.2957213135E+01, 5.2662224282E+00, 1.4952980582E+01, 3.4830086033E+00, 9.6214148173E-01],
	[3.7825000000E+04, 3.2964743330E+01, 5.2662515982E+00, 1.4959423720E+01, 3.4834549377E+00, 9.6215863334E-01],
	[3.7830000000E+04, 3.2972274249E+01, 5.2662807646E+00, 1.4965868781E+01, 3.4839011575E+00, 9.6217577630E-01],
	[3.7835000000E+04, 3.2979805894E+01, 5.2663099272E+00, 1.4972315766E+01, 3.4843472629E+00, 9.6219291061E-01],
	[3.7840000000E+04, 3.2987338263E+01, 5.2663390862E+00, 1.4978764673E+01, 3.4847932538E+00, 9.6221003627E-01],
	[3.7845000000E+04, 3.2994871357E+01, 5.2663682415E+00, 1.4985215505E+01, 3.4852391302E+00, 9.6222715330E-01],
	[3.7850000000E+04, 3.3002405175E+01, 5.2663973931E+00, 1.4991668262E+01, 3.4856848923E+00, 9.6224426170E-01],
	[3.7855000000E+04, 3.3009939719E+01, 5.2664265410E+00, 1.4998122942E+01, 3.4861305399E+00, 9.6226136146E-01],
	[3.7860000000E+04, 3.3017474987E+01, 5.2664556852E+00, 1.5004579548E+01, 3.4865760731E+00, 9.6227845260E-01],
	[3.7865000000E+04, 3.3025010980E+01, 5.2664848257E+00, 1.5011038079E+01, 3.4870214920E+00, 9.6229553512E-01],
	[3.7870000000E+04, 3.3032547697E+01, 5.2665139625E+00, 1.5017498536E+01, 3.4874667965E+00, 9.6231260902E-01],
	[3.7875000000E+04, 3.3040085139E+01, 5.2665430957E+00, 1.5023960918E+01, 3.4879119867E+00, 9.6232967431E-01],
	[3.7880000000E+04, 3.3047623306E+01, 5.2665722252E+00, 1.5030425227E+01, 3.4883570626E+00, 9.6234673100E-01],
	[3.7885000000E+04, 3.3055162197E+01, 5.2666013509E+00, 1.5036891462E+01, 3.4888020243E+00, 9.6236377908E-01],
	[3.7890000000E+04, 3.3062701813E+01, 5.2666304730E+00, 1.5043359624E+01, 3.4892468716E+00, 9.6238081857E-01],
	[3.7895000000E+04, 3.3070242153E+01, 5.2666595915E+00, 1.5049829713E+01, 3.4896916047E+00, 9.6239784946E-01],
	[3.7900000000E+04, 3.3077783218E+01, 5.2666887062E+00, 1.5056301730E+01, 3.4901362236E+00, 9.6241487176E-01],
	[3.7905000000E+04, 3.3085325007E+01, 5.2667178173E+00, 1.5062775674E+01, 3.4905807283E+00, 9.6243188549E-01],
	[3.7910000000E+04, 3.3092867521E+01, 5.2667469246E+00, 1.5069251547E+01, 3.4910251189E+00, 9.6244889063E-01],
	[3.7915000000E+04, 3.3100410759E+01, 5.2667760283E+00, 1.5075729348E+01, 3.4914693952E+00, 9.6246588720E-01],
	[3.7920000000E+04, 3.3107954721E+01, 5.2668051284E+00, 1.5082209078E+01, 3.4919135574E+00, 9.6248287520E-01],
	[3.7925000000E+04, 3.3115499408E+01, 5.2668342247E+00, 1.5088690737E+01, 3.4923576055E+00, 9.6249985464E-01],
	[3.7930000000E+04, 3.3123044819E+01, 5.2668633174E+00, 1.5095174325E+01, 3.4928015396E+00, 9.6251682551E-01],
	[3.7935000000E+04, 3.3130590955E+01, 5.2668924064E+00, 1.5101659843E+01, 3.4932453595E+00, 9.6253378783E-01],
	[3.7940000000E+04, 3.3138137814E+01, 5.2669214917E+00, 1.5108147291E+01, 3.4936890654E+00, 9.6255074160E-01],
	[3.7945000000E+04, 3.3145685398E+01, 5.2669505734E+00, 1.5114636670E+01, 3.4941326572E+00, 9.6256768682E-01],
	[3.7950000000E+04, 3.3153233707E+01, 5.2669796513E+00, 1.5121127979E+01, 3.4945761350E+00, 9.6258462350E-01],
	[3.7955000000E+04, 3.3160782739E+01, 5.2670087257E+00, 1.5127621219E+01, 3.4950194988E+00, 9.6260155164E-01],
	[3.7960000000E+04, 3.3168332496E+01, 5.2670377963E+00, 1.5134116391E+01, 3.4954627487E+00, 9.6261847126E-01],
	[3.7965000000E+04, 3.3175882977E+01, 5.2670668633E+00, 1.5140613494E+01, 3.4959058846E+00, 9.6263538234E-01],
	[3.7970000000E+04, 3.3183434181E+01, 5.2670959266E+00, 1.5147112529E+01, 3.4963489065E+00, 9.6265228490E-01],
	[3.7975000000E+04, 3.3190986110E+01, 5.2671249862E+00, 1.5153613496E+01, 3.4967918146E+00, 9.6266917894E-01],
	[3.7980000000E+04, 3.3198538763E+01, 5.2671540422E+00, 1.5160116396E+01, 3.4972346087E+00, 9.6268606446E-01],
	[3.7985000000E+04, 3.3206092141E+01, 5.2671830945E+00, 1.5166621229E+01, 3.4976772890E+00, 9.6270294148E-01],
	[3.7990000000E+04, 3.3213646242E+01, 5.2672121432E+00, 1.5173127995E+01, 3.4981198555E+00, 9.6271980999E-01],
	[3.7995000000E+04, 3.3221201067E+01, 5.2672411881E+00, 1.5179636695E+01, 3.4985623081E+00, 9.6273667000E-01],
	[3.8000000000E+04, 3.3228756616E+01, 5.2672702295E+00, 1.5186147328E+01, 3.4990046469E+00, 9.6275352152E-01],
	[3.8005000000E+04, 3.3236319397E+01, 5.2673000637E+00, 1.5192659896E+01, 3.4994472956E+00, 9.6277036454E-01],
	[3.8010000000E+04, 3.3243895317E+01, 5.2673314134E+00, 1.5199174399E+01, 3.4998906390E+00, 9.6278719908E-01],
	[3.8015000000E+04, 3.3251471967E+01, 5.2673627591E+00, 1.5205690836E+01, 3.5003338690E+00, 9.6280402513E-01],
	[3.8020000000E+04, 3.3259049347E+01, 5.2673941009E+00, 1.5212209208E+01, 3.5007769857E+00, 9.6282084271E-01],
	[3.8025000000E+04, 3.3266627458E+01, 5.2674254387E+00, 1.5218729516E+01, 3.5012199890E+00, 9.6283765182E-01],
	[3.8030000000E+04, 3.3274206298E+01, 5.2674567726E+00, 1.5225251759E+01, 3.5016628789E+00, 9.6285445245E-01],
	[3.8035000000E+04, 3.3281785868E+01, 5.2674881026E+00, 1.5231775939E+01, 3.5021056555E+00, 9.6287124463E-01],
	[3.8040000000E+04, 3.3289366168E+01, 5.2675194287E+00, 1.5238302055E+01, 3.5025483189E+00, 9.6288802834E-01],
	[3.8045000000E+04, 3.3296947198E+01, 5.2675507508E+00, 1.5244830108E+01, 3.5029908690E+00, 9.6290480360E-01],
	[3.8050000000E+04, 3.3304528957E+01, 5.2675820690E+00, 1.5251360098E+01, 3.5034333058E+00, 9.6292157041E-01],
	[3.8055000000E+04, 3.3312111447E+01, 5.2676133833E+00, 1.5257892025E+01, 3.5038756294E+00, 9.6293832877E-01],
	[3.8060000000E+04, 3.3319694666E+01, 5.2676446936E+00, 1.5264425890E+01, 3.5043178398E+00, 9.6295507870E-01],
	[3.8065000000E+04, 3.3327278615E+01, 5.2676760000E+00, 1.5270961693E+01, 3.5047599370E+00, 9.6297182018E-01],
	[3.8070000000E+04, 3.3334863294E+01, 5.2677073025E+00, 1.5277499434E+01, 3.5052019210E+00, 9.6298855324E-01],
	[3.8075000000E+04, 3.3342448703E+01, 5.2677386010E+00, 1.5284039114E+01, 3.5056437919E+00, 9.6300527787E-01],
	[3.8080000000E+04, 3.3350034841E+01, 5.2677698957E+00, 1.5290580733E+01, 3.5060855497E+00, 9.6302199407E-01],
	[3.8085000000E+04, 3.3357621709E+01, 5.2678011864E+00, 1.5297124292E+01, 3.5065271943E+00, 9.6303870186E-01],
	[3.8090000000E+04, 3.3365209306E+01, 5.2678324732E+00, 1.5303669790E+01, 3.5069687259E+00, 9.6305540123E-01],
	[3.8095000000E+04, 3.3372797633E+01, 5.2678637560E+00, 1.5310217228E+01, 3.5074101444E+00, 9.6307209220E-01],
	[3.8100000000E+04, 3.3380386690E+01, 5.2678950350E+00, 1.5316766606E+01, 3.5078514498E+00, 9.6308877476E-01],
	[3.8105000000E+04, 3.3387976476E+01, 5.2679263100E+00, 1.5323317925E+01, 3.5082926423E+00, 9.6310544892E-01],
	[3.8110000000E+04, 3.3395566992E+01, 5.2679575811E+00, 1.5329871184E+01, 3.5087337217E+00, 9.6312211469E-01],
	[3.8115000000E+04, 3.3403158237E+01, 5.2679888483E+00, 1.5336426385E+01, 3.5091746881E+00, 9.6313877207E-01],
	[3.8120000000E+04, 3.3410750212E+01, 5.2680201116E+00, 1.5342983528E+01, 3.5096155416E+00, 9.6315542106E-01],
	[3.8125000000E+04, 3.3418342916E+01, 5.2680513710E+00, 1.5349542612E+01, 3.5100562822E+00, 9.6317206167E-01],
	[3.8130000000E+04, 3.3425936349E+01, 5.2680826264E+00, 1.5356103639E+01, 3.5104969098E+00, 9.6318869390E-01],
	[3.8135000000E+04, 3.3433530512E+01, 5.2681138779E+00, 1.5362666608E+01, 3.5109374245E+00, 9.6320531776E-01],
	[3.8140000000E+04, 3.3441125405E+01, 5.2681451256E+00, 1.5369231520E+01, 3.5113778264E+00, 9.6322193325E-01],
	[3.8145000000E+04, 3.3448721027E+01, 5.2681763693E+00, 1.5375798375E+01, 3.5118181154E+00, 9.6323854038E-01],
	[3.8150000000E+04, 3.3456317378E+01, 5.2682076091E+00, 1.5382367173E+01, 3.5122582915E+00, 9.6325513915E-01],
	[3.8155000000E+04, 3.3463914458E+01, 5.2682388450E+00, 1.5388937915E+01, 3.5126983548E+00, 9.6327172957E-01],
	[3.8160000000E+04, 3.3471512268E+01, 5.2682700770E+00, 1.5395510602E+01, 3.5131383054E+00, 9.6328831163E-01],
	[3.8165000000E+04, 3.3479110806E+01, 5.2683013051E+00, 1.5402085233E+01, 3.5135781431E+00, 9.6330488536E-01],
	[3.8170000000E+04, 3.3486710075E+01, 5.2683325292E+00, 1.5408661808E+01, 3.5140178682E+00, 9.6332145074E-01],
	[3.8175000000E+04, 3.3494310072E+01, 5.2683637495E+00, 1.5415240329E+01, 3.5144574804E+00, 9.6333800778E-01],
	[3.8180000000E+04, 3.3501910798E+01, 5.2683949659E+00, 1.5421820795E+01, 3.5148969800E+00, 9.6335455650E-01],
	[3.8185000000E+04, 3.3509512254E+01, 5.2684261783E+00, 1.5428403207E+01, 3.5153363669E+00, 9.6337109688E-01],
	[3.8190000000E+04, 3.3517114439E+01, 5.2684573869E+00, 1.5434987564E+01, 3.5157756411E+00, 9.6338762895E-01],
	[3.8195000000E+04, 3.3524717353E+01, 5.2684885915E+00, 1.5441573868E+01, 3.5162148026E+00, 9.6340415270E-01],
	[3.8200000000E+04, 3.3532320996E+01, 5.2685197923E+00, 1.5448162119E+01, 3.5166538515E+00, 9.6342066813E-01],
	[3.8205000000E+04, 3.3539925368E+01, 5.2685509892E+00, 1.5454752317E+01, 3.5170927878E+00, 9.6343717526E-01],
	[3.8210000000E+04, 3.3547530469E+01, 5.2685821821E+00, 1.5461344462E+01, 3.5175316116E+00, 9.6345367408E-01],
	[3.8215000000E+04, 3.3555136299E+01, 5.2686133712E+00, 1.5467938555E+01, 3.5179703227E+00, 9.6347016460E-01],
	[3.8220000000E+04, 3.3562742857E+01, 5.2686445564E+00, 1.5474534595E+01, 3.5184089213E+00, 9.6348664683E-01],
	[3.8225000000E+04, 3.3570350145E+01, 5.2686757376E+00, 1.5481132584E+01, 3.5188474074E+00, 9.6350312077E-01],
	[3.8230000000E+04, 3.3577958162E+01, 5.2687069150E+00, 1.5487732522E+01, 3.5192857810E+00, 9.6351958642E-01],
	[3.8235000000E+04, 3.3585566908E+01, 5.2687380885E+00, 1.5494334408E+01, 3.5197240421E+00, 9.6353604379E-01],
	[3.8240000000E+04, 3.3593176382E+01, 5.2687692581E+00, 1.5500938244E+01, 3.5201621907E+00, 9.6355249288E-01],
	[3.8245000000E+04, 3.3600786586E+01, 5.2688004238E+00, 1.5507544029E+01, 3.5206002269E+00, 9.6356893370E-01],
	[3.8250000000E+04, 3.3608397518E+01, 5.2688315856E+00, 1.5514151764E+01, 3.5210381507E+00, 9.6358536626E-01],
	[3.8255000000E+04, 3.3616009179E+01, 5.2688627436E+00, 1.5520761449E+01, 3.5214759620E+00, 9.6360179055E-01],
	[3.8260000000E+04, 3.3623621569E+01, 5.2688938976E+00, 1.5527373085E+01, 3.5219136610E+00, 9.6361820658E-01],
	[3.8265000000E+04, 3.3631234687E+01, 5.2689250478E+00, 1.5533986672E+01, 3.5223512477E+00, 9.6363461435E-01],
	[3.8270000000E+04, 3.3638848535E+01, 5.2689561940E+00, 1.5540602209E+01, 3.5227887220E+00, 9.6365101388E-01],
	[3.8275000000E+04, 3.3646463111E+01, 5.2689873364E+00, 1.5547219698E+01, 3.5232260839E+00, 9.6366740516E-01],
	[3.8280000000E+04, 3.3654078415E+01, 5.2690184749E+00, 1.5553839139E+01, 3.5236633336E+00, 9.6368378820E-01],
	[3.8285000000E+04, 3.3661694448E+01, 5.2690496095E+00, 1.5560460532E+01, 3.5241004710E+00, 9.6370016301E-01],
	[3.8290000000E+04, 3.3669311210E+01, 5.2690807403E+00, 1.5567083878E+01, 3.5245374962E+00, 9.6371652958E-01],
	[3.8295000000E+04, 3.3676928701E+01, 5.2691118671E+00, 1.5573709176E+01, 3.5249744091E+00, 9.6373288793E-01],
	[3.8300000000E+04, 3.3684546920E+01, 5.2691429901E+00, 1.5580336428E+01, 3.5254112098E+00, 9.6374923805E-01],
	[3.8305000000E+04, 3.3692165867E+01, 5.2691741092E+00, 1.5586965632E+01, 3.5258478984E+00, 9.6376557996E-01],
	[3.8310000000E+04, 3.3699785543E+01, 5.2692052244E+00, 1.5593596791E+01, 3.5262844747E+00, 9.6378191365E-01],
	[3.8315000000E+04, 3.3707405948E+01, 5.2692363357E+00, 1.5600229903E+01, 3.5267209389E+00, 9.6379823913E-01],
	[3.8320000000E+04, 3.3715027081E+01, 5.2692674432E+00, 1.5606864970E+01, 3.5271572910E+00, 9.6381455641E-01],
	[3.8325000000E+04, 3.3722648942E+01, 5.2692985468E+00, 1.5613501991E+01, 3.5275935310E+00, 9.6383086549E-01],
	[3.8330000000E+04, 3.3730271532E+01, 5.2693296465E+00, 1.5620140968E+01, 3.5280296589E+00, 9.6384716637E-01],
	[3.8335000000E+04, 3.3737894850E+01, 5.2693607423E+00, 1.5626781900E+01, 3.5284656747E+00, 9.6386345906E-01],
	[3.8340000000E+04, 3.3745518897E+01, 5.2693918343E+00, 1.5633424787E+01, 3.5289015785E+00, 9.6387974357E-01],
	[3.8345000000E+04, 3.3753143672E+01, 5.2694229224E+00, 1.5640069630E+01, 3.5293373703E+00, 9.6389601989E-01],
	[3.8350000000E+04, 3.3760769175E+01, 5.2694540066E+00, 1.5646716430E+01, 3.5297730500E+00, 9.6391228804E-01],
	[3.8355000000E+04, 3.3768395406E+01, 5.2694850870E+00, 1.5653365186E+01, 3.5302086178E+00, 9.6392854801E-01],
	[3.8360000000E+04, 3.3776022366E+01, 5.2695161635E+00, 1.5660015899E+01, 3.5306440736E+00, 9.6394479982E-01],
	[3.8365000000E+04, 3.3783650054E+01, 5.2695472361E+00, 1.5666668570E+01, 3.5310794175E+00, 9.6396104346E-01],
	[3.8370000000E+04, 3.3791278470E+01, 5.2695783048E+00, 1.5673323197E+01, 3.5315146495E+00, 9.6397727894E-01],
	[3.8375000000E+04, 3.3798907614E+01, 5.2696093697E+00, 1.5679979783E+01, 3.5319497696E+00, 9.6399350626E-01],
	[3.8380000000E+04, 3.3806537487E+01, 5.2696404308E+00, 1.5686638327E+01, 3.5323847778E+00, 9.6400972544E-01],
	[3.8385000000E+04, 3.3814168088E+01, 5.2696714879E+00, 1.5693298830E+01, 3.5328196741E+00, 9.6402593646E-01],
	[3.8390000000E+04, 3.3821799416E+01, 5.2697025412E+00, 1.5699961291E+01, 3.5332544586E+00, 9.6404213935E-01],
	[3.8395000000E+04, 3.3829431473E+01, 5.2697335907E+00, 1.5706625711E+01, 3.5336891314E+00, 9.6405833409E-01],
	[3.8400000000E+04, 3.3837064258E+01, 5.2697646362E+00, 1.5713292091E+01, 3.5341236923E+00, 9.6407452071E-01],
	[3.8405000000E+04, 3.3844697771E+01, 5.2697956780E+00, 1.5719960431E+01, 3.5345581414E+00, 9.6409069919E-01],
	[3.8410000000E+04, 3.3852332012E+01, 5.2698267158E+00, 1.5726630731E+01, 3.5349924788E+00, 9.6410686954E-01],
	[3.8415000000E+04, 3.3859966981E+01, 5.2698577498E+00, 1.5733302991E+01, 3.5354267045E+00, 9.6412303177E-01],
	[3.8420000000E+04, 3.3867602678E+01, 5.2698887800E+00, 1.5739977212E+01, 3.5358608185E+00, 9.6413918588E-01],
	[3.8425000000E+04, 3.3875239102E+01, 5.2699198063E+00, 1.5746653394E+01, 3.5362948208E+00, 9.6415533188E-01],
	[3.8430000000E+04, 3.3882876255E+01, 5.2699508287E+00, 1.5753331538E+01, 3.5367287114E+00, 9.6417146977E-01],
	[3.8435000000E+04, 3.3890514135E+01, 5.2699818473E+00, 1.5760011643E+01, 3.5371624904E+00, 9.6418759956E-01],
	[3.8440000000E+04, 3.3898152744E+01, 5.2700128620E+00, 1.5766693710E+01, 3.5375961578E+00, 9.6420372124E-01],
	[3.8445000000E+04, 3.3905792080E+01, 5.2700438729E+00, 1.5773377740E+01, 3.5380297136E+00, 9.6421983482E-01],
	[3.8450000000E+04, 3.3913432144E+01, 5.2700748799E+00, 1.5780063732E+01, 3.5384631578E+00, 9.6423594031E-01],
	[3.8455000000E+04, 3.3921072936E+01, 5.2701058831E+00, 1.5786751687E+01, 3.5388964904E+00, 9.6425203771E-01],
	[3.8460000000E+04, 3.3928714455E+01, 5.2701368825E+00, 1.5793441606E+01, 3.5393297115E+00, 9.6426812703E-01],
	[3.8465000000E+04, 3.3936356703E+01, 5.2701678779E+00, 1.5800133488E+01, 3.5397628211E+00, 9.6428420826E-01],
	[3.8470000000E+04, 3.3943999678E+01, 5.2701988696E+00, 1.5806827335E+01, 3.5401958192E+00, 9.6430028142E-01],
	[3.8475000000E+04, 3.3951643380E+01, 5.2702298574E+00, 1.5813523145E+01, 3.5406287059E+00, 9.6431634650E-01],
	[3.8480000000E+04, 3.3959287810E+01, 5.2702608413E+00, 1.5820220920E+01, 3.5410614810E+00, 9.6433240352E-01],
	[3.8485000000E+04, 3.3966932968E+01, 5.2702918214E+00, 1.5826920660E+01, 3.5414941448E+00, 9.6434845247E-01],
	[3.8490000000E+04, 3.3974578854E+01, 5.2703227977E+00, 1.5833622365E+01, 3.5419266972E+00, 9.6436449336E-01],
	[3.8495000000E+04, 3.3982225467E+01, 5.2703537701E+00, 1.5840326036E+01, 3.5423591381E+00, 9.6438052619E-01],
	[3.8500000000E+04, 3.3989872808E+01, 5.2703847387E+00, 1.5847031673E+01, 3.5427914677E+00, 9.6439655097E-01],
	[3.8505000000E+04, 3.3997520876E+01, 5.2704157034E+00, 1.5853739276E+01, 3.5432236860E+00, 9.6441256770E-01],
	[3.8510000000E+04, 3.4005169671E+01, 5.2704466643E+00, 1.5860448845E+01, 3.5436557929E+00, 9.6442857639E-01],
	[3.8515000000E+04, 3.4012819194E+01, 5.2704776214E+00, 1.5867160381E+01, 3.5440877886E+00, 9.6444457704E-01],
	[3.8520000000E+04, 3.4020469445E+01, 5.2705085746E+00, 1.5873873885E+01, 3.5445196729E+00, 9.6446056965E-01],
	[3.8525000000E+04, 3.4028120423E+01, 5.2705395240E+00, 1.5880589356E+01, 3.5449514461E+00, 9.6447655423E-01],
	[3.8530000000E+04, 3.4035772128E+01, 5.2705704696E+00, 1.5887306795E+01, 3.5453831079E+00, 9.6449253078E-01],
	[3.8535000000E+04, 3.4043424561E+01, 5.2706014113E+00, 1.5894026201E+01, 3.5458146586E+00, 9.6450849931E-01],
	[3.8540000000E+04, 3.4051077721E+01, 5.2706323492E+00, 1.5900747577E+01, 3.5462460981E+00, 9.6452445982E-01],
	[3.8545000000E+04, 3.4058731608E+01, 5.2706632833E+00, 1.5907470921E+01, 3.5466774264E+00, 9.6454041231E-01],
	[3.8550000000E+04, 3.4066386223E+01, 5.2706942135E+00, 1.5914196234E+01, 3.5471086435E+00, 9.6455635679E-01],
	[3.8555000000E+04, 3.4074041565E+01, 5.2707251399E+00, 1.5920923517E+01, 3.5475397495E+00, 9.6457229326E-01],
	[3.8560000000E+04, 3.4081697634E+01, 5.2707560624E+00, 1.5927652769E+01, 3.5479707444E+00, 9.6458822173E-01],
	[3.8565000000E+04, 3.4089354431E+01, 5.2707869812E+00, 1.5934383991E+01, 3.5484016283E+00, 9.6460414220E-01],
	[3.8570000000E+04, 3.4097011954E+01, 5.2708178961E+00, 1.5941117184E+01, 3.5488324010E+00, 9.6462005468E-01],
	[3.8575000000E+04, 3.4104670205E+01, 5.2708488072E+00, 1.5947852347E+01, 3.5492630628E+00, 9.6463595917E-01],
	[3.8580000000E+04, 3.4112329183E+01, 5.2708797145E+00, 1.5954589482E+01, 3.5496936135E+00, 9.6465185567E-01],
	[3.8585000000E+04, 3.4119988888E+01, 5.2709106179E+00, 1.5961328588E+01, 3.5501240532E+00, 9.6466774418E-01],
	[3.8590000000E+04, 3.4127649320E+01, 5.2709415175E+00, 1.5968069665E+01, 3.5505543819E+00, 9.6468362472E-01],
	[3.8595000000E+04, 3.4135310479E+01, 5.2709724133E+00, 1.5974812714E+01, 3.5509845997E+00, 9.6469949728E-01],
	[3.8600000000E+04, 3.4142972366E+01, 5.2710033053E+00, 1.5981557736E+01, 3.5514147065E+00, 9.6471536187E-01],
	[3.8605000000E+04, 3.4150634979E+01, 5.2710341934E+00, 1.5988304730E+01, 3.5518447025E+00, 9.6473121850E-01],
	[3.8610000000E+04, 3.4158298319E+01, 5.2710650778E+00, 1.5995053698E+01, 3.5522745875E+00, 9.6474706716E-01],
	[3.8615000000E+04, 3.4165962386E+01, 5.2710959583E+00, 1.6001804638E+01, 3.5527043617E+00, 9.6476290787E-01],
	[3.8620000000E+04, 3.4173645568E+01, 5.2711290621E+00, 1.6008557552E+01, 3.5531352357E+00, 9.6477874062E-01],
	[3.8625000000E+04, 3.4181329787E+01, 5.2711621986E+00, 1.6015312440E+01, 3.5535660192E+00, 9.6479456542E-01],
	[3.8630000000E+04, 3.4189014738E+01, 5.2711953310E+00, 1.6022069303E+01, 3.5539966923E+00, 9.6481038227E-01],
	[3.8635000000E+04, 3.4196700422E+01, 5.2712284594E+00, 1.6028828139E+01, 3.5544272549E+00, 9.6482619119E-01],
	[3.8640000000E+04, 3.4204386839E+01, 5.2712615836E+00, 1.6035588951E+01, 3.5548577071E+00, 9.6484199216E-01],
	[3.8645000000E+04, 3.4212073988E+01, 5.2712947038E+00, 1.6042351738E+01, 3.5552880489E+00, 9.6485778521E-01],
	[3.8650000000E+04, 3.4219761871E+01, 5.2713278200E+00, 1.6049116500E+01, 3.5557182803E+00, 9.6487357032E-01],
	[3.8655000000E+04, 3.4227450486E+01, 5.2713609320E+00, 1.6055883238E+01, 3.5561484013E+00, 9.6488934751E-01],
	[3.8660000000E+04, 3.4235139834E+01, 5.2713940400E+00, 1.6062651953E+01, 3.5565784120E+00, 9.6490511677E-01],
	[3.8665000000E+04, 3.4242829914E+01, 5.2714271439E+00, 1.6069422643E+01, 3.5570083124E+00, 9.6492087812E-01],
	[3.8670000000E+04, 3.4250520727E+01, 5.2714602437E+00, 1.6076195311E+01, 3.5574381025E+00, 9.6493663156E-01],
	[3.8675000000E+04, 3.4258212273E+01, 5.2714933394E+00, 1.6082969956E+01, 3.5578677823E+00, 9.6495237708E-01],
	[3.8680000000E+04, 3.4265904552E+01, 5.2715264311E+00, 1.6089746578E+01, 3.5582973518E+00, 9.6496811470E-01],
	[3.8685000000E+04, 3.4273597563E+01, 5.2715595187E+00, 1.6096525177E+01, 3.5587268111E+00, 9.6498384442E-01],
	[3.8690000000E+04, 3.4281291306E+01, 5.2715926022E+00, 1.6103305755E+01, 3.5591561602E+00, 9.6499956625E-01],
	[3.8695000000E+04, 3.4288985783E+01, 5.2716256817E+00, 1.6110088312E+01, 3.5595853991E+00, 9.6501528018E-01],
	[3.8700000000E+04, 3.4296680991E+01, 5.2716587571E+00, 1.6116872847E+01, 3.5600145278E+00, 9.6503098622E-01],
	[3.8705000000E+04, 3.4304376932E+01, 5.2716918284E+00, 1.6123659361E+01, 3.5604435463E+00, 9.6504668438E-01],
	[3.8710000000E+04, 3.4312073606E+01, 5.2717248957E+00, 1.6130447854E+01, 3.5608724548E+00, 9.6506237465E-01],
	[3.8715000000E+04, 3.4319771012E+01, 5.2717579589E+00, 1.6137238327E+01, 3.5613012531E+00, 9.6507805706E-01],
	[3.8720000000E+04, 3.4327469151E+01, 5.2717910181E+00, 1.6144030780E+01, 3.5617299413E+00, 9.6509373158E-01],
	[3.8725000000E+04, 3.4335168022E+01, 5.2718240732E+00, 1.6150825214E+01, 3.5621585195E+00, 9.6510939824E-01],
	[3.8730000000E+04, 3.4342867625E+01, 5.2718571242E+00, 1.6157621628E+01, 3.5625869877E+00, 9.6512505704E-01],
	[3.8735000000E+04, 3.4350567960E+01, 5.2718901712E+00, 1.6164420023E+01, 3.5630153458E+00, 9.6514070798E-01],
	[3.8740000000E+04, 3.4358269028E+01, 5.2719232141E+00, 1.6171220399E+01, 3.5634435939E+00, 9.6515635105E-01],
	[3.8745000000E+04, 3.4365970829E+01, 5.2719562529E+00, 1.6178022757E+01, 3.5638717320E+00, 9.6517198628E-01],
	[3.8750000000E+04, 3.4373673361E+01, 5.2719892877E+00, 1.6184827097E+01, 3.5642997602E+00, 9.6518761366E-01],
	[3.8755000000E+04, 3.4381376626E+01, 5.2720223185E+00, 1.6191633419E+01, 3.5647276785E+00, 9.6520323320E-01],
	[3.8760000000E+04, 3.4389080623E+01, 5.2720553451E+00, 1.6198441724E+01, 3.5651554868E+00, 9.6521884490E-01],
	[3.8765000000E+04, 3.4396785352E+01, 5.2720883678E+00, 1.6205252011E+01, 3.5655831852E+00, 9.6523444876E-01],
	[3.8770000000E+04, 3.4404490813E+01, 5.2721213863E+00, 1.6212064282E+01, 3.5660107738E+00, 9.6525004479E-01],
	[3.8775000000E+04, 3.4412197007E+01, 5.2721544009E+00, 1.6218878536E+01, 3.5664382525E+00, 9.6526563299E-01],
	[3.8780000000E+04, 3.4419903932E+01, 5.2721874114E+00, 1.6225694775E+01, 3.5668656214E+00, 9.6528121337E-01],
	[3.8785000000E+04, 3.4427611590E+01, 5.2722204178E+00, 1.6232512997E+01, 3.5672928805E+00, 9.6529678592E-01],
	[3.8790000000E+04, 3.4435319980E+01, 5.2722534202E+00, 1.6239333204E+01, 3.5677200298E+00, 9.6531235067E-01],
	[3.8795000000E+04, 3.4443029101E+01, 5.2722864185E+00, 1.6246155395E+01, 3.5681470694E+00, 9.6532790760E-01],
	[3.8800000000E+04, 3.4450738955E+01, 5.2723194128E+00, 1.6252979572E+01, 3.5685739992E+00, 9.6534345673E-01],
	[3.8805000000E+04, 3.4458449541E+01, 5.2723524030E+00, 1.6259805734E+01, 3.5690008193E+00, 9.6535899805E-01],
	[3.8810000000E+04, 3.4466160859E+01, 5.2723853892E+00, 1.6266633882E+01, 3.5694275297E+00, 9.6537453157E-01],
	[3.8815000000E+04, 3.4473872909E+01, 5.2724183714E+00, 1.6273464016E+01, 3.5698541304E+00, 9.6539005730E-01],
	[3.8820000000E+04, 3.4481585690E+01, 5.2724513495E+00, 1.6280296137E+01, 3.5702806214E+00, 9.6540557524E-01],
	[3.8825000000E+04, 3.4489299204E+01, 5.2724843236E+00, 1.6287130244E+01, 3.5707070029E+00, 9.6542108539E-01],
	[3.8830000000E+04, 3.4497013449E+01, 5.2725172936E+00, 1.6293966338E+01, 3.5711332747E+00, 9.6543658776E-01],
	[3.8835000000E+04, 3.4504728426E+01, 5.2725502596E+00, 1.6300804420E+01, 3.5715594369E+00, 9.6545208235E-01],
	[3.8840000000E+04, 3.4512444135E+01, 5.2725832215E+00, 1.6307644490E+01, 3.5719854896E+00, 9.6546756916E-01],
	[3.8845000000E+04, 3.4520160576E+01, 5.2726161795E+00, 1.6314486547E+01, 3.5724114327E+00, 9.6548304821E-01],
	[3.8850000000E+04, 3.4527877749E+01, 5.2726491333E+00, 1.6321330593E+01, 3.5728372663E+00, 9.6549851948E-01],
	[3.8855000000E+04, 3.4535595653E+01, 5.2726820832E+00, 1.6328176627E+01, 3.5732629904E+00, 9.6551398300E-01],
	[3.8860000000E+04, 3.4543314289E+01, 5.2727150290E+00, 1.6335024651E+01, 3.5736886050E+00, 9.6552943876E-01],
	[3.8865000000E+04, 3.4551033657E+01, 5.2727479708E+00, 1.6341874664E+01, 3.5741141101E+00, 9.6554488676E-01],
	[3.8870000000E+04, 3.4558753757E+01, 5.2727809085E+00, 1.6348726666E+01, 3.5745395058E+00, 9.6556032701E-01],
	[3.8875000000E+04, 3.4566474588E+01, 5.2728138422E+00, 1.6355580658E+01, 3.5749647921E+00, 9.6557575952E-01],
	[3.8880000000E+04, 3.4574196150E+01, 5.2728467719E+00, 1.6362436641E+01, 3.5753899691E+00, 9.6559118428E-01],
	[3.8885000000E+04, 3.4581918445E+01, 5.2728796976E+00, 1.6369294614E+01, 3.5758150366E+00, 9.6560660131E-01],
	[3.8890000000E+04, 3.4589641471E+01, 5.2729126192E+00, 1.6376154579E+01, 3.5762399948E+00, 9.6562201060E-01],
	[3.8895000000E+04, 3.4597365228E+01, 5.2729455368E+00, 1.6383016534E+01, 3.5766648436E+00, 9.6563741216E-01],
	[3.8900000000E+04, 3.4605089717E+01, 5.2729784504E+00, 1.6389880481E+01, 3.5770895832E+00, 9.6565280600E-01],
	[3.8905000000E+04, 3.4612814938E+01, 5.2730113599E+00, 1.6396746420E+01, 3.5775142135E+00, 9.6566819212E-01],
	[3.8910000000E+04, 3.4620540890E+01, 5.2730442655E+00, 1.6403614351E+01, 3.5779387345E+00, 9.6568357051E-01],
	[3.8915000000E+04, 3.4628267573E+01, 5.2730771670E+00, 1.6410484274E+01, 3.5783631462E+00, 9.6569894120E-01],
	[3.8920000000E+04, 3.4635994988E+01, 5.2731100645E+00, 1.6417356191E+01, 3.5787874488E+00, 9.6571430417E-01],
	[3.8925000000E+04, 3.4643723134E+01, 5.2731429579E+00, 1.6424230101E+01, 3.5792116421E+00, 9.6572965944E-01],
	[3.8930000000E+04, 3.4651452012E+01, 5.2731758474E+00, 1.6431106004E+01, 3.5796357263E+00, 9.6574500700E-01],
	[3.8935000000E+04, 3.4659181620E+01, 5.2732087328E+00, 1.6437983901E+01, 3.5800597013E+00, 9.6576034687E-01],
	[3.8940000000E+04, 3.4666911961E+01, 5.2732416142E+00, 1.6444863792E+01, 3.5804835672E+00, 9.6577567905E-01],
	[3.8945000000E+04, 3.4674643032E+01, 5.2732744916E+00, 1.6451745677E+01, 3.5809073240E+00, 9.6579100353E-01],
	[3.8950000000E+04, 3.4682374835E+01, 5.2733073650E+00, 1.6458629557E+01, 3.5813309717E+00, 9.6580632033E-01],
	[3.8955000000E+04, 3.4690107369E+01, 5.2733402343E+00, 1.6465515433E+01, 3.5817545103E+00, 9.6582162945E-01],
	[3.8960000000E+04, 3.4697840635E+01, 5.2733730997E+00, 1.6472403304E+01, 3.5821779399E+00, 9.6583693089E-01],
	[3.8965000000E+04, 3.4705574631E+01, 5.2734059610E+00, 1.6479293170E+01, 3.5826012604E+00, 9.6585222466E-01],
	[3.8970000000E+04, 3.4713309359E+01, 5.2734388183E+00, 1.6486185033E+01, 3.5830244720E+00, 9.6586751076E-01],
	[3.8975000000E+04, 3.4721044818E+01, 5.2734716716E+00, 1.6493078892E+01, 3.5834475746E+00, 9.6588278920E-01],
	[3.8980000000E+04, 3.4728781008E+01, 5.2735045209E+00, 1.6499974748E+01, 3.5838705682E+00, 9.6589805997E-01],
	[3.8985000000E+04, 3.4736517929E+01, 5.2735373662E+00, 1.6506872600E+01, 3.5842934529E+00, 9.6591332309E-01],
	[3.8990000000E+04, 3.4744255581E+01, 5.2735702075E+00, 1.6513772451E+01, 3.5847162287E+00, 9.6592857855E-01],
	[3.8995000000E+04, 3.4751993964E+01, 5.2736030448E+00, 1.6520674298E+01, 3.5851388956E+00, 9.6594382636E-01],
	[3.9000000000E+04, 3.4759733078E+01, 5.2736358781E+00, 1.6527578144E+01, 3.5855614536E+00, 9.6595906653E-01],
	[3.9005000000E+04, 3.4767472924E+01, 5.2736687073E+00, 1.6534483988E+01, 3.5859839027E+00, 9.6597429906E-01],
	[3.9010000000E+04, 3.4775213500E+01, 5.2737015326E+00, 1.6541391831E+01, 3.5864062431E+00, 9.6598952395E-01],
	[3.9015000000E+04, 3.4782954807E+01, 5.2737343538E+00, 1.6548301673E+01, 3.5868284746E+00, 9.6600474121E-01],
	[3.9020000000E+04, 3.4790696845E+01, 5.2737671711E+00, 1.6555213514E+01, 3.5872505974E+00, 9.6601995084E-01],
	[3.9025000000E+04, 3.4798439614E+01, 5.2737999844E+00, 1.6562127354E+01, 3.5876726114E+00, 9.6603515285E-01],
	[3.9030000000E+04, 3.4806183114E+01, 5.2738327936E+00, 1.6569043195E+01, 3.5880945166E+00, 9.6605034723E-01],
	[3.9035000000E+04, 3.4813927345E+01, 5.2738655989E+00, 1.6575961035E+01, 3.5885163132E+00, 9.6606553400E-01],
	[3.9040000000E+04, 3.4821672306E+01, 5.2738984001E+00, 1.6582880877E+01, 3.5889380010E+00, 9.6608071315E-01],
	[3.9045000000E+04, 3.4829417999E+01, 5.2739311974E+00, 1.6589802719E+01, 3.5893595802E+00, 9.6609588470E-01],
	[3.9050000000E+04, 3.4837164422E+01, 5.2739639907E+00, 1.6596726562E+01, 3.5897810508E+00, 9.6611104864E-01],
	[3.9055000000E+04, 3.4844911576E+01, 5.2739967799E+00, 1.6603652407E+01, 3.5902024127E+00, 9.6612620498E-01],
	[3.9060000000E+04, 3.4852659461E+01, 5.2740295652E+00, 1.6610580254E+01, 3.5906236660E+00, 9.6614135372E-01],
	[3.9065000000E+04, 3.4860408076E+01, 5.2740623465E+00, 1.6617510103E+01, 3.5910448107E+00, 9.6615649488E-01],
	[3.9070000000E+04, 3.4868157422E+01, 5.2740951238E+00, 1.6624441954E+01, 3.5914658468E+00, 9.6617162844E-01],
	[3.9075000000E+04, 3.4875907499E+01, 5.2741278971E+00, 1.6631375809E+01, 3.5918867744E+00, 9.6618675442E-01],
	[3.9080000000E+04, 3.4883658306E+01, 5.2741606664E+00, 1.6638311666E+01, 3.5923075935E+00, 9.6620187282E-01],
	[3.9085000000E+04, 3.4891409844E+01, 5.2741934318E+00, 1.6645249527E+01, 3.5927283041E+00, 9.6621698364E-01],
	[3.9090000000E+04, 3.4899162113E+01, 5.2742261931E+00, 1.6652189392E+01, 3.5931489063E+00, 9.6623208689E-01],
	[3.9095000000E+04, 3.4906915112E+01, 5.2742589505E+00, 1.6659131261E+01, 3.5935694000E+00, 9.6624718257E-01],
	[3.9100000000E+04, 3.4914668842E+01, 5.2742917038E+00, 1.6666075134E+01, 3.5939897852E+00, 9.6626227068E-01],
	[3.9105000000E+04, 3.4922423302E+01, 5.2743244532E+00, 1.6673021012E+01, 3.5944100620E+00, 9.6627735124E-01],
	[3.9110000000E+04, 3.4930178492E+01, 5.2743571986E+00, 1.6679968895E+01, 3.5948302305E+00, 9.6629242424E-01],
	[3.9115000000E+04, 3.4937934413E+01, 5.2743899400E+00, 1.6686918783E+01, 3.5952502906E+00, 9.6630748969E-01],
	[3.9120000000E+04, 3.4945691065E+01, 5.2744226774E+00, 1.6693870677E+01, 3.5956702424E+00, 9.6632254759E-01],
	[3.9125000000E+04, 3.4953448447E+01, 5.2744554109E+00, 1.6700824578E+01, 3.5960900858E+00, 9.6633759794E-01],
	[3.9130000000E+04, 3.4961206559E+01, 5.2744881404E+00, 1.6707780484E+01, 3.5965098209E+00, 9.6635264075E-01],
	[3.9135000000E+04, 3.4968965402E+01, 5.2745208659E+00, 1.6714738397E+01, 3.5969294478E+00, 9.6636767603E-01],
	[3.9140000000E+04, 3.4976724975E+01, 5.2745535874E+00, 1.6721698318E+01, 3.5973489664E+00, 9.6638270378E-01],
	[3.9145000000E+04, 3.4984485278E+01, 5.2745863049E+00, 1.6728660245E+01, 3.5977683768E+00, 9.6639772400E-01],
	[3.9150000000E+04, 3.4992246312E+01, 5.2746190185E+00, 1.6735624180E+01, 3.5981876790E+00, 9.6641273669E-01],
	[3.9155000000E+04, 3.5000008076E+01, 5.2746517281E+00, 1.6742590124E+01, 3.5986068729E+00, 9.6642774186E-01],
	[3.9160000000E+04, 3.5007770570E+01, 5.2746844337E+00, 1.6749558075E+01, 3.5990259588E+00, 9.6644273952E-01],
	[3.9165000000E+04, 3.5015533795E+01, 5.2747171353E+00, 1.6756528035E+01, 3.5994449364E+00, 9.6645772966E-01],
	[3.9170000000E+04, 3.5023297749E+01, 5.2747498330E+00, 1.6763500004E+01, 3.5998638060E+00, 9.6647271230E-01],
	[3.9175000000E+04, 3.5031062434E+01, 5.2747825267E+00, 1.6770473982E+01, 3.6002825675E+00, 9.6648768743E-01],
	[3.9180000000E+04, 3.5038827849E+01, 5.2748152164E+00, 1.6777449970E+01, 3.6007012209E+00, 9.6650265506E-01],
	[3.9185000000E+04, 3.5046593994E+01, 5.2748479022E+00, 1.6784427968E+01, 3.6011197662E+00, 9.6651761520E-01],
	[3.9190000000E+04, 3.5054360869E+01, 5.2748805840E+00, 1.6791407976E+01, 3.6015382035E+00, 9.6653256784E-01],
	[3.9195000000E+04, 3.5062128474E+01, 5.2749132618E+00, 1.6798389995E+01, 3.6019565328E+00, 9.6654751300E-01],
	[3.9200000000E+04, 3.5069896809E+01, 5.2749459357E+00, 1.6805374024E+01, 3.6023747541E+00, 9.6656245067E-01],
	[3.9205000000E+04, 3.5077665875E+01, 5.2749786056E+00, 1.6812360065E+01, 3.6027928674E+00, 9.6657738086E-01],
	[3.9210000000E+04, 3.5085435670E+01, 5.2750112715E+00, 1.6819348117E+01, 3.6032108728E+00, 9.6659230358E-01],
	[3.9215000000E+04, 3.5093206195E+01, 5.2750439335E+00, 1.6826338181E+01, 3.6036287703E+00, 9.6660721882E-01],
	[3.9220000000E+04, 3.5100977450E+01, 5.2750765915E+00, 1.6833330257E+01, 3.6040465599E+00, 9.6662212659E-01],
	[3.9225000000E+04, 3.5108749435E+01, 5.2751092455E+00, 1.6840324345E+01, 3.6044642416E+00, 9.6663702690E-01],
	[3.9230000000E+04, 3.5116522150E+01, 5.2751418956E+00, 1.6847320447E+01, 3.6048818155E+00, 9.6665191975E-01],
	[3.9235000000E+04, 3.5124295595E+01, 5.2751745417E+00, 1.6854318561E+01, 3.6052992815E+00, 9.6666680515E-01],
	[3.9240000000E+04, 3.5132081833E+01, 5.2752086307E+00, 1.6861318689E+01, 3.6057174427E+00, 9.6668168309E-01],
	[3.9245000000E+04, 3.5139875196E+01, 5.2752434819E+00, 1.6868320831E+01, 3.6061359218E+00, 9.6669655358E-01],
	[3.9250000000E+04, 3.5147669295E+01, 5.2752783289E+00, 1.6875324987E+01, 3.6065542935E+00, 9.6671141663E-01],
	[3.9255000000E+04, 3.5155464129E+01, 5.2753131718E+00, 1.6882331157E+01, 3.6069725577E+00, 9.6672627224E-01],
	[3.9260000000E+04, 3.5163259699E+01, 5.2753480104E+00, 1.6889339342E+01, 3.6073907145E+00, 9.6674112041E-01],
	[3.9265000000E+04, 3.5171056005E+01, 5.2753828448E+00, 1.6896349542E+01, 3.6078087639E+00, 9.6675596115E-01],
	[3.9270000000E+04, 3.5178853046E+01, 5.2754176749E+00, 1.6903361757E+01, 3.6082267059E+00, 9.6677079446E-01],
	[3.9275000000E+04, 3.5186650822E+01, 5.2754525009E+00, 1.6910375988E+01, 3.6086445407E+00, 9.6678562035E-01],
	[3.9280000000E+04, 3.5194449334E+01, 5.2754873227E+00, 1.6917392235E+01, 3.6090622681E+00, 9.6680043882E-01],
	[3.9285000000E+04, 3.5202248582E+01, 5.2755221403E+00, 1.6924410499E+01, 3.6094798882E+00, 9.6681524987E-01],
	[3.9290000000E+04, 3.5210048565E+01, 5.2755569537E+00, 1.6931430779E+01, 3.6098974010E+00, 9.6683005351E-01],
	[3.9295000000E+04, 3.5217849283E+01, 5.2755917629E+00, 1.6938453076E+01, 3.6103148066E+00, 9.6684484974E-01],
	[3.9300000000E+04, 3.5225650737E+01, 5.2756265678E+00, 1.6945477391E+01, 3.6107321049E+00, 9.6685963856E-01],
	[3.9305000000E+04, 3.5233452926E+01, 5.2756613686E+00, 1.6952503723E+01, 3.6111492960E+00, 9.6687441999E-01],
	[3.9310000000E+04, 3.5241255850E+01, 5.2756961652E+00, 1.6959532073E+01, 3.6115663800E+00, 9.6688919401E-01],
	[3.9315000000E+04, 3.5249059510E+01, 5.2757309576E+00, 1.6966562441E+01, 3.6119833568E+00, 9.6690396065E-01],
	[3.9320000000E+04, 3.5256863905E+01, 5.2757657458E+00, 1.6973594828E+01, 3.6124002264E+00, 9.6691871990E-01],
	[3.9325000000E+04, 3.5264669035E+01, 5.2758005298E+00, 1.6980629234E+01, 3.6128169889E+00, 9.6693347176E-01],
	[3.9330000000E+04, 3.5272474900E+01, 5.2758353096E+00, 1.6987665659E+01, 3.6132336444E+00, 9.6694821624E-01],
	[3.9335000000E+04, 3.5280281501E+01, 5.2758700852E+00, 1.6994704103E+01, 3.6136501927E+00, 9.6696295335E-01],
	[3.9340000000E+04, 3.5288088837E+01, 5.2759048566E+00, 1.7001744568E+01, 3.6140666340E+00, 9.6697768308E-01],
	[3.9345000000E+04, 3.5295896908E+01, 5.2759396239E+00, 1.7008787052E+01, 3.6144829683E+00, 9.6699240545E-01],
	[3.9350000000E+04, 3.5303705714E+01, 5.2759743869E+00, 1.7015831558E+01, 3.6148991955E+00, 9.6700712045E-01],
	[3.9355000000E+04, 3.5311515255E+01, 5.2760091458E+00, 1.7022878084E+01, 3.6153153158E+00, 9.6702182808E-01],
	[3.9360000000E+04, 3.5319325532E+01, 5.2760439004E+00, 1.7029926631E+01, 3.6157313291E+00, 9.6703652837E-01],
	[3.9365000000E+04, 3.5327136543E+01, 5.2760786509E+00, 1.7036977200E+01, 3.6161472355E+00, 9.6705122130E-01],
	[3.9370000000E+04, 3.5334948290E+01, 5.2761133972E+00, 1.7044029790E+01, 3.6165630349E+00, 9.6706590688E-01],
	[3.9375000000E+04, 3.5342760771E+01, 5.2761481393E+00, 1.7051084403E+01, 3.6169787275E+00, 9.6708058511E-01],
	[3.9380000000E+04, 3.5350573988E+01, 5.2761828773E+00, 1.7058141038E+01, 3.6173943131E+00, 9.6709525601E-01],
	[3.9385000000E+04, 3.5358387939E+01, 5.2762176110E+00, 1.7065199696E+01, 3.6178097920E+00, 9.6710991957E-01],
	[3.9390000000E+04, 3.5366202626E+01, 5.2762523406E+00, 1.7072260378E+01, 3.6182251639E+00, 9.6712457579E-01],
	[3.9395000000E+04, 3.5374018047E+01, 5.2762870660E+00, 1.7079323082E+01, 3.6186404291E+00, 9.6713922469E-01],
	[3.9400000000E+04, 3.5381834203E+01, 5.2763217872E+00, 1.7086387810E+01, 3.6190555875E+00, 9.6715386626E-01],
	[3.9405000000E+04, 3.5389651094E+01, 5.2763565042E+00, 1.7093454563E+01, 3.6194706391E+00, 9.6716850051E-01],
	[3.9410000000E+04, 3.5397468720E+01, 5.2763912171E+00, 1.7100523340E+01, 3.6198855840E+00, 9.6718312744E-01],
	[3.9415000000E+04, 3.5405287081E+01, 5.2764259257E+00, 1.7107594141E+01, 3.6203004222E+00, 9.6719774706E-01],
	[3.9420000000E+04, 3.5413106177E+01, 5.2764606303E+00, 1.7114666968E+01, 3.6207151536E+00, 9.6721235937E-01],
	[3.9425000000E+04, 3.5420926007E+01, 5.2764953306E+00, 1.7121741820E+01, 3.6211297784E+00, 9.6722696437E-01],
	[3.9430000000E+04, 3.5428746572E+01, 5.2765300268E+00, 1.7128818697E+01, 3.6215442966E+00, 9.6724156208E-01],
	[3.9435000000E+04, 3.5436567872E+01, 5.2765647187E+00, 1.7135897601E+01, 3.6219587081E+00, 9.6725615248E-01],
	[3.9440000000E+04, 3.5444389907E+01, 5.2765994066E+00, 1.7142978531E+01, 3.6223730130E+00, 9.6727073560E-01],
	[3.9445000000E+04, 3.5452212676E+01, 5.2766340902E+00, 1.7150061488E+01, 3.6227872113E+00, 9.6728531142E-01],
	[3.9450000000E+04, 3.5460036180E+01, 5.2766687697E+00, 1.7157146471E+01, 3.6232013030E+00, 9.6729987996E-01],
	[3.9455000000E+04, 3.5467860418E+01, 5.2767034450E+00, 1.7164233482E+01, 3.6236152882E+00, 9.6731444121E-01],
	[3.9460000000E+04, 3.5475685391E+01, 5.2767381162E+00, 1.7171322521E+01, 3.6240291669E+00, 9.6732899519E-01],
	[3.9465000000E+04, 3.5483511099E+01, 5.2767727831E+00, 1.7178413587E+01, 3.6244429391E+00, 9.6734354189E-01],
	[3.9470000000E+04, 3.5491337541E+01, 5.2768074460E+00, 1.7185506682E+01, 3.6248566048E+00, 9.6735808133E-01],
	[3.9475000000E+04, 3.5499164718E+01, 5.2768421046E+00, 1.7192601805E+01, 3.6252701641E+00, 9.6737261350E-01],
	[3.9480000000E+04, 3.5506992630E+01, 5.2768767591E+00, 1.7199698958E+01, 3.6256836169E+00, 9.6738713840E-01],
	[3.9485000000E+04, 3.5514821275E+01, 5.2769114095E+00, 1.7206798139E+01, 3.6260969633E+00, 9.6740165605E-01],
	[3.9490000000E+04, 3.5522650656E+01, 5.2769460556E+00, 1.7213899350E+01, 3.6265102033E+00, 9.6741616645E-01],
	[3.9495000000E+04, 3.5530480771E+01, 5.2769806976E+00, 1.7221002591E+01, 3.6269233370E+00, 9.6743066959E-01],
	[3.9500000000E+04, 3.5538311620E+01, 5.2770153355E+00, 1.7228107863E+01, 3.6273363643E+00, 9.6744516549E-01],
	[3.9505000000E+04, 3.5546143203E+01, 5.2770499692E+00, 1.7235215164E+01, 3.6277492853E+00, 9.6745965415E-01],
	[3.9510000000E+04, 3.5553975521E+01, 5.2770845987E+00, 1.7242324497E+01, 3.6281621000E+00, 9.6747413557E-01],
	[3.9515000000E+04, 3.5561808573E+01, 5.2771192241E+00, 1.7249435861E+01, 3.6285748085E+00, 9.6748860975E-01],
	[3.9520000000E+04, 3.5569642360E+01, 5.2771538454E+00, 1.7256549256E+01, 3.6289874107E+00, 9.6750307670E-01],
	[3.9525000000E+04, 3.5577476881E+01, 5.2771884624E+00, 1.7263664683E+01, 3.6293999066E+00, 9.6751753643E-01],
	[3.9530000000E+04, 3.5585312136E+01, 5.2772230754E+00, 1.7270782142E+01, 3.6298122964E+00, 9.6753198893E-01],
	[3.9535000000E+04, 3.5593148125E+01, 5.2772576842E+00, 1.7277901634E+01, 3.6302245799E+00, 9.6754643422E-01],
	[3.9540000000E+04, 3.5600984849E+01, 5.2772922888E+00, 1.7285023159E+01, 3.6306367573E+00, 9.6756087229E-01],
	[3.9545000000E+04, 3.5608822307E+01, 5.2773268893E+00, 1.7292146716E+01, 3.6310488286E+00, 9.6757530315E-01],
	[3.9550000000E+04, 3.5616660499E+01, 5.2773614856E+00, 1.7299272307E+01, 3.6314607937E+00, 9.6758972680E-01],
	[3.9555000000E+04, 3.5624499425E+01, 5.2773960778E+00, 1.7306399932E+01, 3.6318726528E+00, 9.6760414325E-01],
	[3.9560000000E+04, 3.5632339085E+01, 5.2774306658E+00, 1.7313529591E+01, 3.6322844058E+00, 9.6761855250E-01],
	[3.9565000000E+04, 3.5640179480E+01, 5.2774652497E+00, 1.7320661284E+01, 3.6326960527E+00, 9.6763295456E-01],
	[3.9570000000E+04, 3.5648020608E+01, 5.2774998295E+00, 1.7327795012E+01, 3.6331075936E+00, 9.6764734942E-01],
	[3.9575000000E+04, 3.5655862471E+01, 5.2775344051E+00, 1.7334930775E+01, 3.6335190285E+00, 9.6766173710E-01],
	[3.9580000000E+04, 3.5663705067E+01, 5.2775689766E+00, 1.7342068574E+01, 3.6339303574E+00, 9.6767611759E-01],
	[3.9585000000E+04, 3.5671548398E+01, 5.2776035439E+00, 1.7349208408E+01, 3.6343415803E+00, 9.6769049091E-01],
	[3.9590000000E+04, 3.5679392462E+01, 5.2776381071E+00, 1.7356350278E+01, 3.6347526974E+00, 9.6770485705E-01],
	[3.9595000000E+04, 3.5687237261E+01, 5.2776726661E+00, 1.7363494185E+01, 3.6351637085E+00, 9.6771921601E-01],
	[3.9600000000E+04, 3.5695082793E+01, 5.2777072210E+00, 1.7370640128E+01, 3.6355746137E+00, 9.6773356781E-01],
	[3.9605000000E+04, 3.5702929060E+01, 5.2777417718E+00, 1.7377788108E+01, 3.6359854130E+00, 9.6774791245E-01],
	[3.9610000000E+04, 3.5710776060E+01, 5.2777763185E+00, 1.7384938126E+01, 3.6363961065E+00, 9.6776224992E-01],
	[3.9615000000E+04, 3.5718623794E+01, 5.2778108610E+00, 1.7392090181E+01, 3.6368066941E+00, 9.6777658024E-01],
	[3.9620000000E+04, 3.5726472262E+01, 5.2778453993E+00, 1.7399244274E+01, 3.6372171760E+00, 9.6779090341E-01],
	[3.9625000000E+04, 3.5734321464E+01, 5.2778799336E+00, 1.7406400405E+01, 3.6376275521E+00, 9.6780521943E-01],
	[3.9630000000E+04, 3.5742171399E+01, 5.2779144637E+00, 1.7413558575E+01, 3.6380378224E+00, 9.6781952831E-01],
	[3.9635000000E+04, 3.5750022068E+01, 5.2779489897E+00, 1.7420718784E+01, 3.6384479869E+00, 9.6783383004E-01],
	[3.9640000000E+04, 3.5757873471E+01, 5.2779835115E+00, 1.7427881032E+01, 3.6388580458E+00, 9.6784812464E-01],
	[3.9645000000E+04, 3.5765725608E+01, 5.2780180292E+00, 1.7435045320E+01, 3.6392679990E+00, 9.6786241210E-01],
	[3.9650000000E+04, 3.5773578479E+01, 5.2780525428E+00, 1.7442211647E+01, 3.6396778465E+00, 9.6787669244E-01],
	[3.9655000000E+04, 3.5781432083E+01, 5.2780870523E+00, 1.7449380015E+01, 3.6400875883E+00, 9.6789096565E-01],
	[3.9660000000E+04, 3.5789286421E+01, 5.2781215576E+00, 1.7456550423E+01, 3.6404972246E+00, 9.6790523174E-01],
	[3.9665000000E+04, 3.5797141492E+01, 5.2781560588E+00, 1.7463722873E+01, 3.6409067552E+00, 9.6791949072E-01],
	[3.9670000000E+04, 3.5804997297E+01, 5.2781905559E+00, 1.7470897363E+01, 3.6413161803E+00, 9.6793374258E-01],
	[3.9675000000E+04, 3.5812853836E+01, 5.2782250489E+00, 1.7478073895E+01, 3.6417254998E+00, 9.6794798733E-01],
	[3.9680000000E+04, 3.5820711108E+01, 5.2782595378E+00, 1.7485252469E+01, 3.6421347137E+00, 9.6796222498E-01],
	[3.9685000000E+04, 3.5828569113E+01, 5.2782940225E+00, 1.7492433085E+01, 3.6425438222E+00, 9.6797645552E-01],
	[3.9690000000E+04, 3.5836427853E+01, 5.2783285031E+00, 1.7499615743E+01, 3.6429528251E+00, 9.6799067897E-01],
	[3.9695000000E+04, 3.5844287325E+01, 5.2783629796E+00, 1.7506800444E+01, 3.6433617226E+00, 9.6800489532E-01],
	[3.9700000000E+04, 3.5852147531E+01, 5.2783974520E+00, 1.7513987188E+01, 3.6437705147E+00, 9.6801910458E-01],
	[3.9705000000E+04, 3.5860008471E+01, 5.2784319202E+00, 1.7521175976E+01, 3.6441792013E+00, 9.6803330676E-01],
	[3.9710000000E+04, 3.5867870144E+01, 5.2784663844E+00, 1.7528366808E+01, 3.6445877826E+00, 9.6804750186E-01],
	[3.9715000000E+04, 3.5875732550E+01, 5.2785008444E+00, 1.7535559683E+01, 3.6449962584E+00, 9.6806168988E-01],
	[3.9720000000E+04, 3.5883595690E+01, 5.2785353003E+00, 1.7542754603E+01, 3.6454046289E+00, 9.6807587082E-01],
	[3.9725000000E+04, 3.5891459563E+01, 5.2785697521E+00, 1.7549951568E+01, 3.6458128941E+00, 9.6809004469E-01],
	[3.9730000000E+04, 3.5899324169E+01, 5.2786041998E+00, 1.7557150578E+01, 3.6462210540E+00, 9.6810421150E-01],
	[3.9735000000E+04, 3.5907189509E+01, 5.2786386434E+00, 1.7564351633E+01, 3.6466291086E+00, 9.6811837124E-01],
	[3.9740000000E+04, 3.5915055582E+01, 5.2786730829E+00, 1.7571554734E+01, 3.6470370579E+00, 9.6813252393E-01],
	[3.9745000000E+04, 3.5922922388E+01, 5.2787075182E+00, 1.7578759881E+01, 3.6474449020E+00, 9.6814666956E-01],
	[3.9750000000E+04, 3.5930789927E+01, 5.2787419495E+00, 1.7585967074E+01, 3.6478526408E+00, 9.6816080814E-01],
	[3.9755000000E+04, 3.5938658200E+01, 5.2787763766E+00, 1.7593176314E+01, 3.6482602745E+00, 9.6817493967E-01],
	[3.9760000000E+04, 3.5946527205E+01, 5.2788107997E+00, 1.7600387601E+01, 3.6486678030E+00, 9.6818906416E-01],
	[3.9765000000E+04, 3.5954396944E+01, 5.2788452186E+00, 1.7607600936E+01, 3.6490752263E+00, 9.6820318160E-01],
	[3.9770000000E+04, 3.5962267416E+01, 5.2788796335E+00, 1.7614816318E+01, 3.6494825446E+00, 9.6821729202E-01],
	[3.9775000000E+04, 3.5970138621E+01, 5.2789140442E+00, 1.7622033747E+01, 3.6498897577E+00, 9.6823139540E-01],
	[3.9780000000E+04, 3.5978010559E+01, 5.2789484508E+00, 1.7629253226E+01, 3.6502968657E+00, 9.6824549175E-01],
	[3.9785000000E+04, 3.5985883231E+01, 5.2789828534E+00, 1.7636474753E+01, 3.6507038687E+00, 9.6825958108E-01],
	[3.9790000000E+04, 3.5993756635E+01, 5.2790172518E+00, 1.7643698328E+01, 3.6511107666E+00, 9.6827366339E-01],
	[3.9795000000E+04, 3.6001630772E+01, 5.2790516462E+00, 1.7650923953E+01, 3.6515175595E+00, 9.6828773869E-01],
	[3.9800000000E+04, 3.6009505642E+01, 5.2790860364E+00, 1.7658151628E+01, 3.6519242475E+00, 9.6830180697E-01],
	[3.9805000000E+04, 3.6017381245E+01, 5.2791204225E+00, 1.7665381353E+01, 3.6523308304E+00, 9.6831586824E-01],
	[3.9810000000E+04, 3.6025257581E+01, 5.2791548046E+00, 1.7672613127E+01, 3.6527373084E+00, 9.6832992251E-01],
	[3.9815000000E+04, 3.6033134650E+01, 5.2791891826E+00, 1.7679846953E+01, 3.6531436815E+00, 9.6834396978E-01],
	[3.9820000000E+04, 3.6041012452E+01, 5.2792235564E+00, 1.7687082829E+01, 3.6535499497E+00, 9.6835801005E-01],
	[3.9825000000E+04, 3.6048890987E+01, 5.2792579262E+00, 1.7694320756E+01, 3.6539561130E+00, 9.6837204333E-01],
	[3.9830000000E+04, 3.6056770254E+01, 5.2792922919E+00, 1.7701560735E+01, 3.6543621715E+00, 9.6838606963E-01],
	[3.9835000000E+04, 3.6064650255E+01, 5.2793266535E+00, 1.7708802766E+01, 3.6547681251E+00, 9.6840008897E-01],
	[3.9840000000E+04, 3.6072530988E+01, 5.2793610110E+00, 1.7716046849E+01, 3.6551739739E+00, 9.6841410134E-01],
	[3.9845000000E+04, 3.6080412454E+01, 5.2793953644E+00, 1.7723292985E+01, 3.6555797179E+00, 9.6842810676E-01],
	[3.9850000000E+04, 3.6088294653E+01, 5.2794297137E+00, 1.7730541173E+01, 3.6559853572E+00, 9.6844210521E-01],
	[3.9855000000E+04, 3.6096177584E+01, 5.2794640589E+00, 1.7737791414E+01, 3.6563908917E+00, 9.6845609672E-01],
	[3.9860000000E+04, 3.6104061248E+01, 5.2794984001E+00, 1.7745043709E+01, 3.6567963215E+00, 9.6847008127E-01],
	[3.9865000000E+04, 3.6111945645E+01, 5.2795327372E+00, 1.7752298058E+01, 3.6572016466E+00, 9.6848405888E-01],
	[3.9870000000E+04, 3.6119836644E+01, 5.2795677672E+00, 1.7759554461E+01, 3.6576072618E+00, 9.6849802955E-01],
	[3.9875000000E+04, 3.6127740733E+01, 5.2796042600E+00, 1.7766812918E+01, 3.6580136032E+00, 9.6851199327E-01],
	[3.9880000000E+04, 3.6135645560E+01, 5.2796407484E+00, 1.7774073430E+01, 3.6584198403E+00, 9.6852595006E-01],
	[3.9885000000E+04, 3.6143551126E+01, 5.2796772325E+00, 1.7781335997E+01, 3.6588259731E+00, 9.6853989992E-01],
	[3.9890000000E+04, 3.6151457430E+01, 5.2797137123E+00, 1.7788600620E+01, 3.6592320016E+00, 9.6855384284E-01],
	[3.9895000000E+04, 3.6159364472E+01, 5.2797501877E+00, 1.7795867298E+01, 3.6596379259E+00, 9.6856777884E-01],
	[3.9900000000E+04, 3.6167272252E+01, 5.2797866589E+00, 1.7803136032E+01, 3.6600437459E+00, 9.6858170792E-01],
	[3.9905000000E+04, 3.6175180770E+01, 5.2798231257E+00, 1.7810406823E+01, 3.6604494617E+00, 9.6859563008E-01],
	[3.9910000000E+04, 3.6183090026E+01, 5.2798595882E+00, 1.7817679670E+01, 3.6608550733E+00, 9.6860954532E-01],
	[3.9915000000E+04, 3.6191000021E+01, 5.2798960464E+00, 1.7824954575E+01, 3.6612605807E+00, 9.6862345365E-01],
	[3.9920000000E+04, 3.6198910754E+01, 5.2799325003E+00, 1.7832231536E+01, 3.6616659839E+00, 9.6863735507E-01],
	[3.9925000000E+04, 3.6206822224E+01, 5.2799689498E+00, 1.7839510556E+01, 3.6620712830E+00, 9.6865124958E-01],
	[3.9930000000E+04, 3.6214734433E+01, 5.2800053951E+00, 1.7846791633E+01, 3.6624764780E+00, 9.6866513719E-01],
	[3.9935000000E+04, 3.6222647380E+01, 5.2800418360E+00, 1.7854074769E+01, 3.6628815690E+00, 9.6867901790E-01],
	[3.9940000000E+04, 3.6230561065E+01, 5.2800782726E+00, 1.7861359963E+01, 3.6632865558E+00, 9.6869289172E-01],
	[3.9945000000E+04, 3.6238475487E+01, 5.2801147049E+00, 1.7868647217E+01, 3.6636914386E+00, 9.6870675864E-01],
	[3.9950000000E+04, 3.6246390648E+01, 5.2801511330E+00, 1.7875936529E+01, 3.6640962174E+00, 9.6872061867E-01],
	[3.9955000000E+04, 3.6254306547E+01, 5.2801875567E+00, 1.7883227902E+01, 3.6645008922E+00, 9.6873447182E-01],
	[3.9960000000E+04, 3.6262223183E+01, 5.2802239760E+00, 1.7890521334E+01, 3.6649054631E+00, 9.6874831809E-01],
	[3.9965000000E+04, 3.6270140557E+01, 5.2802603911E+00, 1.7897816826E+01, 3.6653099300E+00, 9.6876215747E-01],
	[3.9970000000E+04, 3.6278058670E+01, 5.2802968019E+00, 1.7905114379E+01, 3.6657142929E+00, 9.6877598998E-01],
	[3.9975000000E+04, 3.6285977520E+01, 5.2803332084E+00, 1.7912413993E+01, 3.6661185520E+00, 9.6878981562E-01],
	[3.9980000000E+04, 3.6293897107E+01, 5.2803696106E+00, 1.7919715668E+01, 3.6665227071E+00, 9.6880363439E-01],
	[3.9985000000E+04, 3.6301817433E+01, 5.2804060084E+00, 1.7927019405E+01, 3.6669267584E+00, 9.6881744629E-01],
	[3.9990000000E+04, 3.6309738497E+01, 5.2804424020E+00, 1.7934325204E+01, 3.6673307059E+00, 9.6883125134E-01],
	[3.9995000000E+04, 3.6317660298E+01, 5.2804787913E+00, 1.7941633065E+01, 3.6677345495E+00, 9.6884504952E-01],
	[4.0000000000E+04, 3.6325582836E+01, 5.2805151763E+00, 1.7948942988E+01, 3.6681382894E+00, 9.6885884084E-01],
	[4.0005000000E+04, 3.6333506113E+01, 5.2805515570E+00, 1.7956281156E+01, 3.6685430183E+00, 9.6887262532E-01],
	[4.0010000000E+04, 3.6341430127E+01, 5.2805879333E+00, 1.7963621406E+01, 3.6689476430E+00, 9.6888640294E-01],
	[4.0015000000E+04, 3.6349354879E+01, 5.2806243054E+00, 1.7970963737E+01, 3.6693521633E+00, 9.6890017373E-01],
	[4.0020000000E+04, 3.6357280368E+01, 5.2806606732E+00, 1.7978308151E+01, 3.6697565795E+00, 9.6891393766E-01],
	[4.0025000000E+04, 3.6365206595E+01, 5.2806970367E+00, 1.7985654646E+01, 3.6701608914E+00, 9.6892769476E-01],
	[4.0030000000E+04, 3.6373133560E+01, 5.2807333959E+00, 1.7993003225E+01, 3.6705650991E+00, 9.6894144503E-01],
	[4.0035000000E+04, 3.6381061262E+01, 5.2807697508E+00, 1.8000353886E+01, 3.6709692026E+00, 9.6895518846E-01],
	[4.0040000000E+04, 3.6388989702E+01, 5.2808061015E+00, 1.8007706631E+01, 3.6713732020E+00, 9.6896892506E-01],
	[4.0045000000E+04, 3.6396918879E+01, 5.2808424478E+00, 1.8015061460E+01, 3.6717770973E+00, 9.6898265484E-01],
	[4.0050000000E+04, 3.6404848794E+01, 5.2808787899E+00, 1.8022418372E+01, 3.6721808884E+00, 9.6899637780E-01],
	[4.0055000000E+04, 3.6412779446E+01, 5.2809151276E+00, 1.8029777369E+01, 3.6725845755E+00, 9.6901009394E-01],
	[4.0060000000E+04, 3.6420710835E+01, 5.2809514611E+00, 1.8037138451E+01, 3.6729881585E+00, 9.6902380326E-01],
	[4.0065000000E+04, 3.6428642962E+01, 5.2809877903E+00, 1.8044501617E+01, 3.6733916374E+00, 9.6903750577E-01],
	[4.0070000000E+04, 3.6436575827E+01, 5.2810241152E+00, 1.8051866869E+01, 3.6737950124E+00, 9.6905120147E-01],
	[4.0075000000E+04, 3.6444509428E+01, 5.2810604359E+00, 1.8059234207E+01, 3.6741982833E+00, 9.6906489037E-01],
	[4.0080000000E+04, 3.6452443767E+01, 5.2810967522E+00, 1.8066603630E+01, 3.6746014503E+00, 9.6907857247E-01],
	[4.0085000000E+04, 3.6460378844E+01, 5.2811330643E+00, 1.8073975140E+01, 3.6750045133E+00, 9.6909224776E-01],
	[4.0090000000E+04, 3.6468314657E+01, 5.2811693721E+00, 1.8081348737E+01, 3.6754074724E+00, 9.6910591627E-01],
	[4.0095000000E+04, 3.6476251208E+01, 5.2812056756E+00, 1.8088724420E+01, 3.6758103276E+00, 9.6911957798E-01],
	[4.0100000000E+04, 3.6484188496E+01, 5.2812419748E+00, 1.8096102191E+01, 3.6762130790E+00, 9.6913323290E-01],
	[4.0105000000E+04, 3.6492126522E+01, 5.2812782698E+00, 1.8103482050E+01, 3.6766157264E+00, 9.6914688104E-01],
	[4.0110000000E+04, 3.6500065284E+01, 5.2813145604E+00, 1.8110863996E+01, 3.6770182701E+00, 9.6916052240E-01],
	[4.0115000000E+04, 3.6508004784E+01, 5.2813508468E+00, 1.8118248031E+01, 3.6774207099E+00, 9.6917415698E-01],
	[4.0120000000E+04, 3.6515945021E+01, 5.2813871290E+00, 1.8125634154E+01, 3.6778230459E+00, 9.6918778478E-01],
	[4.0125000000E+04, 3.6523885995E+01, 5.2814234068E+00, 1.8133022367E+01, 3.6782252782E+00, 9.6920140581E-01],
	[4.0130000000E+04, 3.6531827706E+01, 5.2814596804E+00, 1.8140412668E+01, 3.6786274067E+00, 9.6921502008E-01],
	[4.0135000000E+04, 3.6539770154E+01, 5.2814959497E+00, 1.8147805060E+01, 3.6790294315E+00, 9.6922862758E-01],
	[4.0140000000E+04, 3.6547713339E+01, 5.2815322148E+00, 1.8155199541E+01, 3.6794313527E+00, 9.6924222831E-01],
	[4.0145000000E+04, 3.6555657261E+01, 5.2815684756E+00, 1.8162596112E+01, 3.6798331701E+00, 9.6925582229E-01],
	[4.0150000000E+04, 3.6563601921E+01, 5.2816047321E+00, 1.8169994774E+01, 3.6802348839E+00, 9.6926940952E-01],
	[4.0155000000E+04, 3.6571547317E+01, 5.2816409843E+00, 1.8177395527E+01, 3.6806364941E+00, 9.6928298999E-01],
	[4.0160000000E+04, 3.6579493450E+01, 5.2816772323E+00, 1.8184798372E+01, 3.6810380006E+00, 9.6929656372E-01],
	[4.0165000000E+04, 3.6587440320E+01, 5.2817134760E+00, 1.8192203308E+01, 3.6814394036E+00, 9.6931013070E-01],
	[4.0170000000E+04, 3.6595387927E+01, 5.2817497155E+00, 1.8199610335E+01, 3.6818407030E+00, 9.6932369094E-01],
	[4.0175000000E+04, 3.6603336271E+01, 5.2817859507E+00, 1.8207019456E+01, 3.6822418989E+00, 9.6933724445E-01],
	[4.0180000000E+04, 3.6611285352E+01, 5.2818221816E+00, 1.8214430668E+01, 3.6826429912E+00, 9.6935079122E-01],
	[4.0185000000E+04, 3.6619235170E+01, 5.2818584083E+00, 1.8221843974E+01, 3.6830439801E+00, 9.6936433125E-01],
	[4.0190000000E+04, 3.6627185724E+01, 5.2818946307E+00, 1.8229259373E+01, 3.6834448655E+00, 9.6937786456E-01],
	[4.0195000000E+04, 3.6635137015E+01, 5.2819308489E+00, 1.8236676865E+01, 3.6838456475E+00, 9.6939139115E-01],
	[4.0200000000E+04, 3.6643089043E+01, 5.2819670628E+00, 1.8244096452E+01, 3.6842463260E+00, 9.6940491102E-01],
	[4.0205000000E+04, 3.6651041808E+01, 5.2820032724E+00, 1.8251518132E+01, 3.6846469012E+00, 9.6941842416E-01],
	[4.0210000000E+04, 3.6658995310E+01, 5.2820394778E+00, 1.8258941907E+01, 3.6850473729E+00, 9.6943193060E-01],
	[4.0215000000E+04, 3.6666949548E+01, 5.2820756789E+00, 1.8266367778E+01, 3.6854477414E+00, 9.6944543032E-01],
	[4.0220000000E+04, 3.6674904523E+01, 5.2821118758E+00, 1.8273795743E+01, 3.6858480064E+00, 9.6945892333E-01],
	[4.0225000000E+04, 3.6682860234E+01, 5.2821480685E+00, 1.8281225804E+01, 3.6862481682E+00, 9.6947240964E-01],
	[4.0230000000E+04, 3.6690816682E+01, 5.2821842568E+00, 1.8288657961E+01, 3.6866482267E+00, 9.6948588925E-01],
	[4.0235000000E+04, 3.6698773867E+01, 5.2822204410E+00, 1.8296092214E+01, 3.6870481819E+00, 9.6949936216E-01],
	[4.0240000000E+04, 3.6706731789E+01, 5.2822566209E+00, 1.8303528563E+01, 3.6874480339E+00, 9.6951282838E-01],
	[4.0245000000E+04, 3.6714690447E+01, 5.2822927965E+00, 1.8310967010E+01, 3.6878477827E+00, 9.6952628791E-01],
	[4.0250000000E+04, 3.6722649841E+01, 5.2823289679E+00, 1.8318407553E+01, 3.6882474283E+00, 9.6953974075E-01],
	[4.0255000000E+04, 3.6730609972E+01, 5.2823651350E+00, 1.8325850194E+01, 3.6886469707E+00, 9.6955318690E-01],
	[4.0260000000E+04, 3.6738570839E+01, 5.2824012979E+00, 1.8333294933E+01, 3.6890464100E+00, 9.6956662638E-01],
	[4.0265000000E+04, 3.6746532443E+01, 5.2824374566E+00, 1.8340741771E+01, 3.6894457461E+00, 9.6958005918E-01],
	[4.0270000000E+04, 3.6754494784E+01, 5.2824736110E+00, 1.8348190707E+01, 3.6898449792E+00, 9.6959348530E-01],
	[4.0275000000E+04, 3.6762457861E+01, 5.2825097612E+00, 1.8355641741E+01, 3.6902441091E+00, 9.6960690475E-01],
	[4.0280000000E+04, 3.6770421674E+01, 5.2825459071E+00, 1.8363094875E+01, 3.6906431360E+00, 9.6962031754E-01],
	[4.0285000000E+04, 3.6778386223E+01, 5.2825820488E+00, 1.8370550108E+01, 3.6910420599E+00, 9.6963372366E-01],
	[4.0290000000E+04, 3.6786351509E+01, 5.2826181863E+00, 1.8378007442E+01, 3.6914408808E+00, 9.6964712312E-01],
	[4.0295000000E+04, 3.6794317532E+01, 5.2826543195E+00, 1.8385466875E+01, 3.6918395987E+00, 9.6966051592E-01],
	[4.0300000000E+04, 3.6802284290E+01, 5.2826904485E+00, 1.8392928409E+01, 3.6922382136E+00, 9.6967390207E-01],
	[4.0305000000E+04, 3.6810251785E+01, 5.2827265732E+00, 1.8400392044E+01, 3.6926367256E+00, 9.6968728157E-01],
	[4.0310000000E+04, 3.6818220016E+01, 5.2827626937E+00, 1.8407857780E+01, 3.6930351346E+00, 9.6970065443E-01],
	[4.0315000000E+04, 3.6826188984E+01, 5.2827988100E+00, 1.8415325617E+01, 3.6934334408E+00, 9.6971402063E-01],
	[4.0320000000E+04, 3.6834158687E+01, 5.2828349221E+00, 1.8422795557E+01, 3.6938316441E+00, 9.6972738020E-01],
	[4.0325000000E+04, 3.6842129127E+01, 5.2828710299E+00, 1.8430267598E+01, 3.6942297446E+00, 9.6974073313E-01],
	[4.0330000000E+04, 3.6850100303E+01, 5.2829071335E+00, 1.8437741742E+01, 3.6946277422E+00, 9.6975407943E-01],
	[4.0335000000E+04, 3.6858072215E+01, 5.2829432328E+00, 1.8445217989E+01, 3.6950256370E+00, 9.6976741910E-01],
	[4.0340000000E+04, 3.6866044863E+01, 5.2829793279E+00, 1.8452696339E+01, 3.6954234291E+00, 9.6978075214E-01],
	[4.0345000000E+04, 3.6874018247E+01, 5.2830154189E+00, 1.8460176792E+01, 3.6958211183E+00, 9.6979407855E-01],
	[4.0350000000E+04, 3.6881992368E+01, 5.2830515055E+00, 1.8467659350E+01, 3.6962187049E+00, 9.6980739835E-01],
	[4.0355000000E+04, 3.6889967224E+01, 5.2830875880E+00, 1.8475144011E+01, 3.6966161887E+00, 9.6982071153E-01],
	[4.0360000000E+04, 3.6897942817E+01, 5.2831236662E+00, 1.8482630777E+01, 3.6970135699E+00, 9.6983401809E-01],
	[4.0365000000E+04, 3.6905919145E+01, 5.2831597402E+00, 1.8490119648E+01, 3.6974108484E+00, 9.6984731805E-01],
	[4.0370000000E+04, 3.6913896210E+01, 5.2831958100E+00, 1.8497610624E+01, 3.6978080243E+00, 9.6986061140E-01],
	[4.0375000000E+04, 3.6921874010E+01, 5.2832318756E+00, 1.8505103705E+01, 3.6982050975E+00, 9.6987389814E-01],
	[4.0380000000E+04, 3.6929852546E+01, 5.2832679369E+00, 1.8512598892E+01, 3.6986020681E+00, 9.6988717828E-01],
	[4.0385000000E+04, 3.6937831818E+01, 5.2833039940E+00, 1.8520096185E+01, 3.6989989362E+00, 9.6990045183E-01],
	[4.0390000000E+04, 3.6945811827E+01, 5.2833400469E+00, 1.8527595585E+01, 3.6993957017E+00, 9.6991371878E-01],
	[4.0395000000E+04, 3.6953792571E+01, 5.2833760956E+00, 1.8535097092E+01, 3.6997923647E+00, 9.6992697915E-01],
	[4.0400000000E+04, 3.6961774050E+01, 5.2834121401E+00, 1.8542600705E+01, 3.7001889252E+00, 9.6994023292E-01],
	[4.0405000000E+04, 3.6969756266E+01, 5.2834481803E+00, 1.8550106426E+01, 3.7005853832E+00, 9.6995348012E-01],
	[4.0410000000E+04, 3.6977739217E+01, 5.2834842164E+00, 1.8557614255E+01, 3.7009817388E+00, 9.6996672073E-01],
	[4.0415000000E+04, 3.6985722905E+01, 5.2835202482E+00, 1.8565124192E+01, 3.7013779919E+00, 9.6997995476E-01],
	[4.0420000000E+04, 3.6993707328E+01, 5.2835562758E+00, 1.8572636238E+01, 3.7017741426E+00, 9.6999318223E-01],
	[4.0425000000E+04, 3.7001692486E+01, 5.2835922992E+00, 1.8580150392E+01, 3.7021701910E+00, 9.7000640312E-01],
	[4.0430000000E+04, 3.7009678381E+01, 5.2836283184E+00, 1.8587666655E+01, 3.7025661369E+00, 9.7001961744E-01],
	[4.0435000000E+04, 3.7017665011E+01, 5.2836643334E+00, 1.8595185028E+01, 3.7029619806E+00, 9.7003282520E-01],
	[4.0440000000E+04, 3.7025652376E+01, 5.2837003442E+00, 1.8602705511E+01, 3.7033577219E+00, 9.7004602641E-01],
	[4.0445000000E+04, 3.7033640478E+01, 5.2837363508E+00, 1.8610228103E+01, 3.7037533609E+00, 9.7005922105E-01],
	[4.0450000000E+04, 3.7041629315E+01, 5.2837723532E+00, 1.8617752807E+01, 3.7041488976E+00, 9.7007240914E-01],
	[4.0455000000E+04, 3.7049618887E+01, 5.2838083513E+00, 1.8625279620E+01, 3.7045443321E+00, 9.7008559068E-01],
	[4.0460000000E+04, 3.7057609195E+01, 5.2838443453E+00, 1.8632808545E+01, 3.7049396644E+00, 9.7009876568E-01],
	[4.0465000000E+04, 3.7065600239E+01, 5.2838803351E+00, 1.8640339582E+01, 3.7053348944E+00, 9.7011193413E-01],
	[4.0470000000E+04, 3.7073592018E+01, 5.2839163206E+00, 1.8647872730E+01, 3.7057300223E+00, 9.7012509604E-01],
	[4.0475000000E+04, 3.7081584533E+01, 5.2839523020E+00, 1.8655407990E+01, 3.7061250480E+00, 9.7013825141E-01],
	[4.0480000000E+04, 3.7089577783E+01, 5.2839882791E+00, 1.8662945363E+01, 3.7065199716E+00, 9.7015140025E-01],
	[4.0485000000E+04, 3.7097571768E+01, 5.2840242521E+00, 1.8670484848E+01, 3.7069147931E+00, 9.7016454256E-01],
	[4.0490000000E+04, 3.7105566489E+01, 5.2840602208E+00, 1.8678026446E+01, 3.7073095125E+00, 9.7017767835E-01],
	[4.0495000000E+04, 3.7113561946E+01, 5.2840961854E+00, 1.8685570158E+01, 3.7077041298E+00, 9.7019080761E-01],
	[4.0500000000E+04, 3.7121558137E+01, 5.2841321458E+00, 1.8693115984E+01, 3.7080986451E+00, 9.7020393035E-01],
	[4.0505000000E+04, 3.7129555065E+01, 5.2841681020E+00, 1.8700663923E+01, 3.7084930584E+00, 9.7021704657E-01],
	[4.0510000000E+04, 3.7137552727E+01, 5.2842040539E+00, 1.8708213978E+01, 3.7088873697E+00, 9.7023015628E-01],
	[4.0515000000E+04, 3.7145568438E+01, 5.2842420282E+00, 1.8715766146E+01, 3.7092827501E+00, 9.7024325948E-01],
	[4.0520000000E+04, 3.7153585671E+01, 5.2842800897E+00, 1.8723320430E+01, 3.7096780819E+00, 9.7025635617E-01],
	[4.0525000000E+04, 3.7161603646E+01, 5.2843181467E+00, 1.8730876829E+01, 3.7100733119E+00, 9.7026944636E-01],
	[4.0530000000E+04, 3.7169622361E+01, 5.2843561993E+00, 1.8738435344E+01, 3.7104684404E+00, 9.7028253005E-01],
	[4.0535000000E+04, 3.7177641817E+01, 5.2843942475E+00, 1.8745995975E+01, 3.7108634672E+00, 9.7029560725E-01],
	[4.0540000000E+04, 3.7185662014E+01, 5.2844322913E+00, 1.8753558723E+01, 3.7112583925E+00, 9.7030867795E-01],
	[4.0545000000E+04, 3.7193682951E+01, 5.2844703306E+00, 1.8761123587E+01, 3.7116532162E+00, 9.7032174216E-01],
	[4.0550000000E+04, 3.7201704629E+01, 5.2845083656E+00, 1.8768690568E+01, 3.7120479384E+00, 9.7033479988E-01],
	[4.0555000000E+04, 3.7209727048E+01, 5.2845463961E+00, 1.8776259666E+01, 3.7124425591E+00, 9.7034785112E-01],
	[4.0560000000E+04, 3.7217750208E+01, 5.2845844222E+00, 1.8783830883E+01, 3.7128370782E+00, 9.7036089588E-01],
	[4.0565000000E+04, 3.7225774108E+01, 5.2846224439E+00, 1.8791404217E+01, 3.7132314960E+00, 9.7037393416E-01],
	[4.0570000000E+04, 3.7233798749E+01, 5.2846604612E+00, 1.8798979670E+01, 3.7136258122E+00, 9.7038696597E-01],
	[4.0575000000E+04, 3.7241824131E+01, 5.2846984741E+00, 1.8806557241E+01, 3.7140200271E+00, 9.7039999131E-01],
	[4.0580000000E+04, 3.7249850253E+01, 5.2847364825E+00, 1.8814136931E+01, 3.7144141406E+00, 9.7041301018E-01],
	[4.0585000000E+04, 3.7257877115E+01, 5.2847744866E+00, 1.8821718741E+01, 3.7148081526E+00, 9.7042602259E-01],
	[4.0590000000E+04, 3.7265904718E+01, 5.2848124862E+00, 1.8829302670E+01, 3.7152020634E+00, 9.7043902853E-01],
	[4.0595000000E+04, 3.7273933062E+01, 5.2848504814E+00, 1.8836888720E+01, 3.7155958728E+00, 9.7045202803E-01],
	[4.0600000000E+04, 3.7281962146E+01, 5.2848884723E+00, 1.8844476890E+01, 3.7159895809E+00, 9.7046502106E-01],
	[4.0605000000E+04, 3.7289991971E+01, 5.2849264587E+00, 1.8852067180E+01, 3.7163831877E+00, 9.7047800765E-01],
	[4.0610000000E+04, 3.7298022536E+01, 5.2849644407E+00, 1.8859659592E+01, 3.7167766933E+00, 9.7049098779E-01],
	[4.0615000000E+04, 3.7306053841E+01, 5.2850024183E+00, 1.8867254124E+01, 3.7171700977E+00, 9.7050396149E-01],
	[4.0620000000E+04, 3.7314085887E+01, 5.2850403915E+00, 1.8874850779E+01, 3.7175634008E+00, 9.7051692875E-01],
	[4.0625000000E+04, 3.7322118673E+01, 5.2850783603E+00, 1.8882449556E+01, 3.7179566027E+00, 9.7052988957E-01],
	[4.0630000000E+04, 3.7330152200E+01, 5.2851163247E+00, 1.8890050454E+01, 3.7183497035E+00, 9.7054284396E-01],
	[4.0635000000E+04, 3.7338186467E+01, 5.2851542848E+00, 1.8897653476E+01, 3.7187427031E+00, 9.7055579191E-01],
	[4.0640000000E+04, 3.7346221474E+01, 5.2851922404E+00, 1.8905258621E+01, 3.7191356016E+00, 9.7056873344E-01],
	[4.0645000000E+04, 3.7354257221E+01, 5.2852301916E+00, 1.8912865888E+01, 3.7195283991E+00, 9.7058166855E-01],
	[4.0650000000E+04, 3.7362293709E+01, 5.2852681384E+00, 1.8920475280E+01, 3.7199210954E+00, 9.7059459723E-01],
	[4.0655000000E+04, 3.7370330937E+01, 5.2853060808E+00, 1.8928086795E+01, 3.7203136907E+00, 9.7060751950E-01],
	[4.0660000000E+04, 3.7378368905E+01, 5.2853440189E+00, 1.8935700435E+01, 3.7207061850E+00, 9.7062043536E-01],
	[4.0665000000E+04, 3.7386407614E+01, 5.2853819525E+00, 1.8943316200E+01, 3.7210985782E+00, 9.7063334480E-01],
	[4.0670000000E+04, 3.7394447062E+01, 5.2854198818E+00, 1.8950934089E+01, 3.7214908705E+00, 9.7064624784E-01],
	[4.0675000000E+04, 3.7402487251E+01, 5.2854578066E+00, 1.8958554104E+01, 3.7218830618E+00, 9.7065914448E-01],
	[4.0680000000E+04, 3.7410528180E+01, 5.2854957271E+00, 1.8966176245E+01, 3.7222751522E+00, 9.7067203471E-01],
	[4.0685000000E+04, 3.7418569849E+01, 5.2855336432E+00, 1.8973800511E+01, 3.7226671417E+00, 9.7068491855E-01],
	[4.0690000000E+04, 3.7426612258E+01, 5.2855715548E+00, 1.8981426904E+01, 3.7230590303E+00, 9.7069779599E-01],
	[4.0695000000E+04, 3.7434655407E+01, 5.2856094622E+00, 1.8989055423E+01, 3.7234508180E+00, 9.7071066704E-01],
	[4.0700000000E+04, 3.7442699296E+01, 5.2856473651E+00, 1.8996686070E+01, 3.7238425049E+00, 9.7072353171E-01],
	[4.0705000000E+04, 3.7450743925E+01, 5.2856852636E+00, 1.9004318843E+01, 3.7242340909E+00, 9.7073638999E-01],
	[4.0710000000E+04, 3.7458789294E+01, 5.2857231578E+00, 1.9011953745E+01, 3.7246255762E+00, 9.7074924189E-01],
	[4.0715000000E+04, 3.7466835403E+01, 5.2857610475E+00, 1.9019590774E+01, 3.7250169607E+00, 9.7076208742E-01],
	[4.0720000000E+04, 3.7474882252E+01, 5.2857989329E+00, 1.9027229932E+01, 3.7254082444E+00, 9.7077492657E-01],
	[4.0725000000E+04, 3.7482929840E+01, 5.2858368139E+00, 1.9034871218E+01, 3.7257994274E+00, 9.7078775935E-01],
	[4.0730000000E+04, 3.7490978169E+01, 5.2858746906E+00, 1.9042514633E+01, 3.7261905097E+00, 9.7080058576E-01],
	[4.0735000000E+04, 3.7499027238E+01, 5.2859125628E+00, 1.9050160178E+01, 3.7265814913E+00, 9.7081340581E-01],
	[4.0740000000E+04, 3.7507077046E+01, 5.2859504307E+00, 1.9057807852E+01, 3.7269723723E+00, 9.7082621950E-01],
	[4.0745000000E+04, 3.7515127595E+01, 5.2859882942E+00, 1.9065457656E+01, 3.7273631526E+00, 9.7083902683E-01],
	[4.0750000000E+04, 3.7523178883E+01, 5.2860261533E+00, 1.9073109590E+01, 3.7277538324E+00, 9.7085182780E-01],
	[4.0755000000E+04, 3.7531230910E+01, 5.2860640080E+00, 1.9080763655E+01, 3.7281444115E+00, 9.7086462243E-01],
	[4.0760000000E+04, 3.7539283678E+01, 5.2861018584E+00, 1.9088419851E+01, 3.7285348900E+00, 9.7087741071E-01],
	[4.0765000000E+04, 3.7547337185E+01, 5.2861397044E+00, 1.9096078178E+01, 3.7289252681E+00, 9.7089019264E-01],
	[4.0770000000E+04, 3.7555391432E+01, 5.2861775461E+00, 1.9103738637E+01, 3.7293155456E+00, 9.7090296824E-01],
	[4.0775000000E+04, 3.7563446419E+01, 5.2862153833E+00, 1.9111401228E+01, 3.7297057226E+00, 9.7091573749E-01],
	[4.0780000000E+04, 3.7571502146E+01, 5.2862532162E+00, 1.9119065951E+01, 3.7300957991E+00, 9.7092850041E-01],
	[4.0785000000E+04, 3.7579558612E+01, 5.2862910448E+00, 1.9126732807E+01, 3.7304857752E+00, 9.7094125700E-01],
	[4.0790000000E+04, 3.7587615817E+01, 5.2863288689E+00, 1.9134401795E+01, 3.7308756508E+00, 9.7095400727E-01],
	[4.0795000000E+04, 3.7595673762E+01, 5.2863666887E+00, 1.9142072917E+01, 3.7312654260E+00, 9.7096675121E-01],
	[4.0800000000E+04, 3.7603732447E+01, 5.2864045041E+00, 1.9149746173E+01, 3.7316551009E+00, 9.7097948883E-01],
	[4.0805000000E+04, 3.7611791872E+01, 5.2864423152E+00, 1.9157421562E+01, 3.7320446754E+00, 9.7099222013E-01],
	[4.0810000000E+04, 3.7619852036E+01, 5.2864801219E+00, 1.9165099086E+01, 3.7324341496E+00, 9.7100494511E-01],
	[4.0815000000E+04, 3.7627912939E+01, 5.2865179243E+00, 1.9172778744E+01, 3.7328235234E+00, 9.7101766379E-01],
	[4.0820000000E+04, 3.7635974582E+01, 5.2865557222E+00, 1.9180460537E+01, 3.7332127970E+00, 9.7103037615E-01],
	[4.0825000000E+04, 3.7644036964E+01, 5.2865935159E+00, 1.9188144466E+01, 3.7336019703E+00, 9.7104308222E-01],
	[4.0830000000E+04, 3.7652100086E+01, 5.2866313051E+00, 1.9195830530E+01, 3.7339910434E+00, 9.7105578198E-01],
	[4.0835000000E+04, 3.7660163947E+01, 5.2866690900E+00, 1.9203518730E+01, 3.7343800162E+00, 9.7106847544E-01],
	[4.0840000000E+04, 3.7668228548E+01, 5.2867068706E+00, 1.9211209066E+01, 3.7347688888E+00, 9.7108116261E-01],
	[4.0845000000E+04, 3.7676293888E+01, 5.2867446468E+00, 1.9218901539E+01, 3.7351576613E+00, 9.7109384349E-01],
	[4.0850000000E+04, 3.7684359967E+01, 5.2867824186E+00, 1.9226596148E+01, 3.7355463336E+00, 9.7110651808E-01],
	[4.0855000000E+04, 3.7692426786E+01, 5.2868201861E+00, 1.9234292895E+01, 3.7359349058E+00, 9.7111918638E-01],
	[4.0860000000E+04, 3.7700494343E+01, 5.2868579493E+00, 1.9241991780E+01, 3.7363233779E+00, 9.7113184841E-01],
	[4.0865000000E+04, 3.7708562641E+01, 5.2868957080E+00, 1.9249692802E+01, 3.7367117499E+00, 9.7114450415E-01],
	[4.0870000000E+04, 3.7716631677E+01, 5.2869334625E+00, 1.9257395963E+01, 3.7371000218E+00, 9.7115715362E-01],
	[4.0875000000E+04, 3.7724701453E+01, 5.2869712126E+00, 1.9265101262E+01, 3.7374881938E+00, 9.7116979682E-01],
	[4.0880000000E+04, 3.7732771968E+01, 5.2870089583E+00, 1.9272808700E+01, 3.7378762657E+00, 9.7118243375E-01],
	[4.0885000000E+04, 3.7740843222E+01, 5.2870466997E+00, 1.9280518278E+01, 3.7382642376E+00, 9.7119506442E-01],
	[4.0890000000E+04, 3.7748915215E+01, 5.2870844367E+00, 1.9288229995E+01, 3.7386521095E+00, 9.7120768882E-01],
	[4.0895000000E+04, 3.7756987947E+01, 5.2871221694E+00, 1.9295943852E+01, 3.7390398815E+00, 9.7122030697E-01],
	[4.0900000000E+04, 3.7765061419E+01, 5.2871598978E+00, 1.9303659849E+01, 3.7394275536E+00, 9.7123291886E-01],
	[4.0905000000E+04, 3.7773135629E+01, 5.2871976218E+00, 1.9311377986E+01, 3.7398151258E+00, 9.7124552450E-01],
	[4.0910000000E+04, 3.7781210579E+01, 5.2872353415E+00, 1.9319098265E+01, 3.7402025981E+00, 9.7125812389E-01],
	[4.0915000000E+04, 3.7789286268E+01, 5.2872730568E+00, 1.9326820685E+01, 3.7405899706E+00, 9.7127071703E-01],
	[4.0920000000E+04, 3.7797362695E+01, 5.2873107678E+00, 1.9334545246E+01, 3.7409772432E+00, 9.7128330393E-01],
	[4.0925000000E+04, 3.7805439862E+01, 5.2873484745E+00, 1.9342271949E+01, 3.7413644160E+00, 9.7129588460E-01],
	[4.0930000000E+04, 3.7813517768E+01, 5.2873861768E+00, 1.9350000795E+01, 3.7417514891E+00, 9.7130845903E-01],
	[4.0935000000E+04, 3.7821596412E+01, 5.2874238748E+00, 1.9357731783E+01, 3.7421384624E+00, 9.7132102722E-01],
	[4.0940000000E+04, 3.7829675796E+01, 5.2874615684E+00, 1.9365464914E+01, 3.7425253360E+00, 9.7133358919E-01],
	[4.0945000000E+04, 3.7837755919E+01, 5.2874992577E+00, 1.9373200188E+01, 3.7429121098E+00, 9.7134614493E-01],
	[4.0950000000E+04, 3.7845836780E+01, 5.2875369427E+00, 1.9380937605E+01, 3.7432987840E+00, 9.7135869445E-01],
	[4.0955000000E+04, 3.7853918380E+01, 5.2875746233E+00, 1.9388677167E+01, 3.7436853585E+00, 9.7137123775E-01],
	[4.0960000000E+04, 3.7862000719E+01, 5.2876122996E+00, 1.9396418873E+01, 3.7440718334E+00, 9.7138377484E-01],
	[4.0965000000E+04, 3.7870083797E+01, 5.2876499716E+00, 1.9404162723E+01, 3.7444582086E+00, 9.7139630571E-01],
	[4.0970000000E+04, 3.7878167614E+01, 5.2876876393E+00, 1.9411908718E+01, 3.7448444842E+00, 9.7140883037E-01],
	[4.0975000000E+04, 3.7886252170E+01, 5.2877253026E+00, 1.9419656859E+01, 3.7452306603E+00, 9.7142134883E-01],
	[4.0980000000E+04, 3.7894337464E+01, 5.2877629616E+00, 1.9427407144E+01, 3.7456167369E+00, 9.7143386108E-01],
	[4.0985000000E+04, 3.7902423497E+01, 5.2878006163E+00, 1.9435159576E+01, 3.7460027139E+00, 9.7144636714E-01],
	[4.0990000000E+04, 3.7910510269E+01, 5.2878382666E+00, 1.9442914154E+01, 3.7463885914E+00, 9.7145886700E-01],
	[4.0995000000E+04, 3.7918597779E+01, 5.2878759126E+00, 1.9450670879E+01, 3.7467743694E+00, 9.7147136066E-01],
	[4.1000000000E+04, 3.7926686028E+01, 5.2879135543E+00, 1.9458429750E+01, 3.7471600479E+00, 9.7148384814E-01],
	[4.1005000000E+04, 3.7934775016E+01, 5.2879511917E+00, 1.9466190769E+01, 3.7475456271E+00, 9.7149632943E-01],
	[4.1010000000E+04, 3.7942864742E+01, 5.2879888248E+00, 1.9473953935E+01, 3.7479311068E+00, 9.7150880454E-01],
	[4.1015000000E+04, 3.7950955207E+01, 5.2880264535E+00, 1.9481719249E+01, 3.7483164871E+00, 9.7152127346E-01],
	[4.1020000000E+04, 3.7959046411E+01, 5.2880640779E+00, 1.9489486711E+01, 3.7487017681E+00, 9.7153373622E-01],
	[4.1025000000E+04, 3.7967138353E+01, 5.2881016980E+00, 1.9497256322E+01, 3.7490869497E+00, 9.7154619279E-01],
	[4.1030000000E+04, 3.7975231033E+01, 5.2881393138E+00, 1.9505028081E+01, 3.7494720321E+00, 9.7155864320E-01],
	[4.1035000000E+04, 3.7983324452E+01, 5.2881769252E+00, 1.9512801990E+01, 3.7498570151E+00, 9.7157108744E-01],
	[4.1040000000E+04, 3.7991418610E+01, 5.2882145324E+00, 1.9520578048E+01, 3.7502418988E+00, 9.7158352552E-01],
	[4.1045000000E+04, 3.7999513506E+01, 5.2882521352E+00, 1.9528356256E+01, 3.7506266834E+00, 9.7159595744E-01],
	[4.1050000000E+04, 3.8007609140E+01, 5.2882897337E+00, 1.9536136614E+01, 3.7510113686E+00, 9.7160838320E-01],
	[4.1055000000E+04, 3.8015705513E+01, 5.2883273280E+00, 1.9543919123E+01, 3.7513959547E+00, 9.7162080280E-01],
	[4.1060000000E+04, 3.8023802624E+01, 5.2883649178E+00, 1.9551703783E+01, 3.7517804416E+00, 9.7163321626E-01],
	[4.1065000000E+04, 3.8031900474E+01, 5.2884025034E+00, 1.9559490594E+01, 3.7521648294E+00, 9.7164562357E-01],
	[4.1070000000E+04, 3.8039999062E+01, 5.2884400847E+00, 1.9567279556E+01, 3.7525491180E+00, 9.7165802473E-01],
	[4.1075000000E+04, 3.8048098388E+01, 5.2884776617E+00, 1.9575070670E+01, 3.7529333075E+00, 9.7167041976E-01],
	[4.1080000000E+04, 3.8056198453E+01, 5.2885152343E+00, 1.9582863937E+01, 3.7533173979E+00, 9.7168280864E-01],
	[4.1085000000E+04, 3.8064299256E+01, 5.2885528027E+00, 1.9590659355E+01, 3.7537013893E+00, 9.7169519140E-01],
	[4.1090000000E+04, 3.8072400797E+01, 5.2885903668E+00, 1.9598456927E+01, 3.7540852816E+00, 9.7170756802E-01],
	[4.1095000000E+04, 3.8080503076E+01, 5.2886279265E+00, 1.9606256652E+01, 3.7544690749E+00, 9.7171993851E-01],
	[4.1100000000E+04, 3.8088606094E+01, 5.2886654820E+00, 1.9614058530E+01, 3.7548527693E+00, 9.7173230288E-01],
	[4.1105000000E+04, 3.8096709850E+01, 5.2887030331E+00, 1.9621862563E+01, 3.7552363646E+00, 9.7174466113E-01],
	[4.1110000000E+04, 3.8104814344E+01, 5.2887405799E+00, 1.9629668749E+01, 3.7556198610E+00, 9.7175701326E-01],
	[4.1115000000E+04, 3.8112919576E+01, 5.2887781225E+00, 1.9637477090E+01, 3.7560032585E+00, 9.7176935928E-01],
	[4.1120000000E+04, 3.8121025546E+01, 5.2888156607E+00, 1.9645287586E+01, 3.7563865571E+00, 9.7178169919E-01],
	[4.1125000000E+04, 3.8129132254E+01, 5.2888531947E+00, 1.9653100236E+01, 3.7567697568E+00, 9.7179403298E-01],
	[4.1130000000E+04, 3.8137239701E+01, 5.2888907243E+00, 1.9660915043E+01, 3.7571528577E+00, 9.7180636068E-01],
	[4.1135000000E+04, 3.8145347885E+01, 5.2889282497E+00, 1.9668732005E+01, 3.7575358597E+00, 9.7181868227E-01],
	[4.1140000000E+04, 3.8153456808E+01, 5.2889657707E+00, 1.9676551123E+01, 3.7579187629E+00, 9.7183099776E-01],
	[4.1145000000E+04, 3.8161566468E+01, 5.2890032875E+00, 1.9684372398E+01, 3.7583015674E+00, 9.7184330716E-01],
	[4.1150000000E+04, 3.8169676867E+01, 5.2890408000E+00, 1.9692195830E+01, 3.7586842730E+00, 9.7185561046E-01],
	[4.1155000000E+04, 3.8177788003E+01, 5.2890783082E+00, 1.9700021419E+01, 3.7590668800E+00, 9.7186790768E-01],
	[4.1160000000E+04, 3.8185899878E+01, 5.2891158120E+00, 1.9707849165E+01, 3.7594493882E+00, 9.7188019881E-01],
	[4.1165000000E+04, 3.8194021943E+01, 5.2891544005E+00, 1.9715679069E+01, 3.7598324396E+00, 9.7189248386E-01],
	[4.1170000000E+04, 3.8202153306E+01, 5.2891939699E+00, 1.9723511131E+01, 3.7602159733E+00, 9.7190476283E-01],
	[4.1175000000E+04, 3.8210285412E+01, 5.2892335349E+00, 1.9731345352E+01, 3.7605994087E+00, 9.7191703572E-01],
	[4.1180000000E+04, 3.8218418262E+01, 5.2892730954E+00, 1.9739181732E+01, 3.7609827458E+00, 9.7192930255E-01],
	[4.1185000000E+04, 3.8226551855E+01, 5.2893126513E+00, 1.9747020271E+01, 3.7613659845E+00, 9.7194156330E-01],
	[4.1190000000E+04, 3.8234686191E+01, 5.2893522028E+00, 1.9754860969E+01, 3.7617491249E+00, 9.7195381799E-01],
	[4.1195000000E+04, 3.8242821271E+01, 5.2893917497E+00, 1.9762703827E+01, 3.7621321670E+00, 9.7196606661E-01],
	[4.1200000000E+04, 3.8250957094E+01, 5.2894312922E+00, 1.9770548845E+01, 3.7625151108E+00, 9.7197830918E-01],
	[4.1205000000E+04, 3.8259093660E+01, 5.2894708301E+00, 1.9778396024E+01, 3.7628979564E+00, 9.7199054569E-01],
	[4.1210000000E+04, 3.8267230969E+01, 5.2895103635E+00, 1.9786245363E+01, 3.7632807038E+00, 9.7200277614E-01],
	[4.1215000000E+04, 3.8275369021E+01, 5.2895498925E+00, 1.9794096864E+01, 3.7636633529E+00, 9.7201500055E-01],
	[4.1220000000E+04, 3.8283507817E+01, 5.2895894169E+00, 1.9801950526E+01, 3.7640459039E+00, 9.7202721891E-01],
	[4.1225000000E+04, 3.8291647356E+01, 5.2896289368E+00, 1.9809806350E+01, 3.7644283568E+00, 9.7203943122E-01],
	[4.1230000000E+04, 3.8299787637E+01, 5.2896684523E+00, 1.9817664336E+01, 3.7648107115E+00, 9.7205163750E-01],
	[4.1235000000E+04, 3.8307928662E+01, 5.2897079632E+00, 1.9825524484E+01, 3.7651929681E+00, 9.7206383774E-01],
	[4.1240000000E+04, 3.8316070430E+01, 5.2897474697E+00, 1.9833386796E+01, 3.7655751266E+00, 9.7207603194E-01],
	[4.1245000000E+04, 3.8324212941E+01, 5.2897869716E+00, 1.9841251270E+01, 3.7659571871E+00, 9.7208822012E-01],
	[4.1250000000E+04, 3.8332356195E+01, 5.2898264691E+00, 1.9849117908E+01, 3.7663391495E+00, 9.7210040227E-01],
	[4.1255000000E+04, 3.8340500192E+01, 5.2898659620E+00, 1.9856986710E+01, 3.7667210139E+00, 9.7211257839E-01],
	[4.1260000000E+04, 3.8348644932E+01, 5.2899054505E+00, 1.9864857676E+01, 3.7671027803E+00, 9.7212474850E-01],
	[4.1265000000E+04, 3.8356790415E+01, 5.2899449345E+00, 1.9872730806E+01, 3.7674844488E+00, 9.7213691258E-01],
	[4.1270000000E+04, 3.8364936641E+01, 5.2899844140E+00, 1.9880606101E+01, 3.7678660193E+00, 9.7214907066E-01],
	[4.1275000000E+04, 3.8373083609E+01, 5.2900238890E+00, 1.9888483561E+01, 3.7682474919E+00, 9.7216122272E-01],
	[4.1280000000E+04, 3.8381231321E+01, 5.2900633595E+00, 1.9896363187E+01, 3.7686288666E+00, 9.7217336877E-01],
	[4.1285000000E+04, 3.8389379775E+01, 5.2901028255E+00, 1.9904244979E+01, 3.7690101434E+00, 9.7218550882E-01],
	[4.1290000000E+04, 3.8397528972E+01, 5.2901422871E+00, 1.9912128936E+01, 3.7693913224E+00, 9.7219764287E-01],
	[4.1295000000E+04, 3.8405678912E+01, 5.2901817442E+00, 1.9920015060E+01, 3.7697724035E+00, 9.7220977091E-01],
	[4.1300000000E+04, 3.8413829595E+01, 5.2902211967E+00, 1.9927903351E+01, 3.7701533868E+00, 9.7222189297E-01],
	[4.1305000000E+04, 3.8421981021E+01, 5.2902606448E+00, 1.9935793809E+01, 3.7705342724E+00, 9.7223400903E-01],
	[4.1310000000E+04, 3.8430133189E+01, 5.2903000885E+00, 1.9943686435E+01, 3.7709150601E+00, 9.7224611910E-01],
	[4.1315000000E+04, 3.8438286100E+01, 5.2903395276E+00, 1.9951581228E+01, 3.7712957502E+00, 9.7225822319E-01],
	[4.1320000000E+04, 3.8446439754E+01, 5.2903789623E+00, 1.9959478189E+01, 3.7716763425E+00, 9.7227032130E-01],
	[4.1325000000E+04, 3.8454594151E+01, 5.2904183924E+00, 1.9967377319E+01, 3.7720568372E+00, 9.7228241343E-01],
	[4.1330000000E+04, 3.8462749290E+01, 5.2904578181E+00, 1.9975278618E+01, 3.7724372342E+00, 9.7229449958E-01],
	[4.1335000000E+04, 3.8470905171E+01, 5.2904972394E+00, 1.9983182086E+01, 3.7728175335E+00, 9.7230657976E-01],
	[4.1340000000E+04, 3.8479061796E+01, 5.2905366561E+00, 1.9991087723E+01, 3.7731977352E+00, 9.7231865397E-01],
	[4.1345000000E+04, 3.8487219163E+01, 5.2905760684E+00, 1.9998995530E+01, 3.7735778393E+00, 9.7233072222E-01],
	[4.1350000000E+04, 3.8495377272E+01, 5.2906154762E+00, 2.0006905507E+01, 3.7739578459E+00, 9.7234278450E-01],
	[4.1355000000E+04, 3.8503536124E+01, 5.2906548796E+00, 2.0014817655E+01, 3.7743377548E+00, 9.7235484082E-01],
	[4.1360000000E+04, 3.8511695719E+01, 5.2906942784E+00, 2.0022731973E+01, 3.7747175663E+00, 9.7236689119E-01],
	[4.1365000000E+04, 3.8519856056E+01, 5.2907336728E+00, 2.0030648462E+01, 3.7750972803E+00, 9.7237893560E-01],
	[4.1370000000E+04, 3.8528017136E+01, 5.2907730628E+00, 2.0038567123E+01, 3.7754768967E+00, 9.7239097406E-01],
	[4.1375000000E+04, 3.8536178958E+01, 5.2908124482E+00, 2.0046487956E+01, 3.7758564158E+00, 9.7240300658E-01],
	[4.1380000000E+04, 3.8544341522E+01, 5.2908518292E+00, 2.0054410961E+01, 3.7762358373E+00, 9.7241503315E-01],
	[4.1385000000E+04, 3.8552504829E+01, 5.2908912058E+00, 2.0062336138E+01, 3.7766151615E+00, 9.7242705378E-01],
	[4.1390000000E+04, 3.8560668878E+01, 5.2909305778E+00, 2.0070263488E+01, 3.7769943883E+00, 9.7243906848E-01],
	[4.1395000000E+04, 3.8568833670E+01, 5.2909699454E+00, 2.0078193011E+01, 3.7773735177E+00, 9.7245107724E-01],
	[4.1400000000E+04, 3.8576999204E+01, 5.2910093086E+00, 2.0086124708E+01, 3.7777525498E+00, 9.7246308007E-01],
	[4.1405000000E+04, 3.8585165480E+01, 5.2910486672E+00, 2.0094058578E+01, 3.7781314845E+00, 9.7247507697E-01],
	[4.1410000000E+04, 3.8593332499E+01, 5.2910880215E+00, 2.0101994623E+01, 3.7785103219E+00, 9.7248706795E-01],
	[4.1415000000E+04, 3.8601500259E+01, 5.2911273712E+00, 2.0109932842E+01, 3.7788890621E+00, 9.7249905300E-01],
	[4.1420000000E+04, 3.8609668762E+01, 5.2911667165E+00, 2.0117873235E+01, 3.7792677051E+00, 9.7251103214E-01],
	[4.1425000000E+04, 3.8617838008E+01, 5.2912060574E+00, 2.0125815804E+01, 3.7796462508E+00, 9.7252300537E-01],
	[4.1430000000E+04, 3.8626007995E+01, 5.2912453938E+00, 2.0133760549E+01, 3.7800246992E+00, 9.7253497268E-01],
	[4.1435000000E+04, 3.8634178725E+01, 5.2912847257E+00, 2.0141707469E+01, 3.7804030506E+00, 9.7254693409E-01],
	[4.1440000000E+04, 3.8642350197E+01, 5.2913240532E+00, 2.0149656565E+01, 3.7807813047E+00, 9.7255888958E-01],
	[4.1445000000E+04, 3.8650522411E+01, 5.2913633762E+00, 2.0157607837E+01, 3.7811594617E+00, 9.7257083918E-01],
	[4.1450000000E+04, 3.8658695367E+01, 5.2914026948E+00, 2.0165561287E+01, 3.7815375216E+00, 9.7258278288E-01],
	[4.1455000000E+04, 3.8666869066E+01, 5.2914420089E+00, 2.0173516913E+01, 3.7819154845E+00, 9.7259472068E-01],
	[4.1460000000E+04, 3.8675043506E+01, 5.2914813186E+00, 2.0181474717E+01, 3.7822933502E+00, 9.7260665259E-01],
	[4.1465000000E+04, 3.8683218688E+01, 5.2915206239E+00, 2.0189434699E+01, 3.7826711189E+00, 9.7261857861E-01],
	[4.1470000000E+04, 3.8691394613E+01, 5.2915599246E+00, 2.0197396858E+01, 3.7830487906E+00, 9.7263049875E-01],
	[4.1475000000E+04, 3.8699571279E+01, 5.2915992210E+00, 2.0205361197E+01, 3.7834263653E+00, 9.7264241300E-01],
	[4.1480000000E+04, 3.8707748688E+01, 5.2916385129E+00, 2.0213327713E+01, 3.7838038430E+00, 9.7265432137E-01],
	[4.1485000000E+04, 3.8715926838E+01, 5.2916778003E+00, 2.0221296410E+01, 3.7841812238E+00, 9.7266622387E-01],
	[4.1490000000E+04, 3.8724105731E+01, 5.2917170833E+00, 2.0229267285E+01, 3.7845585077E+00, 9.7267812049E-01],
	[4.1495000000E+04, 3.8732285365E+01, 5.2917563619E+00, 2.0237240340E+01, 3.7849356946E+00, 9.7269001124E-01],
	[4.1500000000E+04, 3.8740465741E+01, 5.2917956360E+00, 2.0245215576E+01, 3.7853127847E+00, 9.7270189613E-01],
	[4.1505000000E+04, 3.8748646859E+01, 5.2918349057E+00, 2.0253192991E+01, 3.7856897779E+00, 9.7271377515E-01],
	[4.1510000000E+04, 3.8756828719E+01, 5.2918741709E+00, 2.0261172588E+01, 3.7860666743E+00, 9.7272564831E-01],
	[4.1515000000E+04, 3.8765011321E+01, 5.2919134317E+00, 2.0269154366E+01, 3.7864434738E+00, 9.7273751562E-01],
	[4.1520000000E+04, 3.8773194664E+01, 5.2919526881E+00, 2.0277138325E+01, 3.7868201766E+00, 9.7274937706E-01],
	[4.1525000000E+04, 3.8781378750E+01, 5.2919919400E+00, 2.0285124466E+01, 3.7871967826E+00, 9.7276123266E-01],
	[4.1530000000E+04, 3.8789563577E+01, 5.2920311875E+00, 2.0293112789E+01, 3.7875732919E+00, 9.7277308241E-01],
	[4.1535000000E+04, 3.8797749146E+01, 5.2920704306E+00, 2.0301103294E+01, 3.7879497044E+00, 9.7278492632E-01],
	[4.1540000000E+04, 3.8805935457E+01, 5.2921096692E+00, 2.0309095982E+01, 3.7883260203E+00, 9.7279676438E-01],
	[4.1545000000E+04, 3.8814122509E+01, 5.2921489034E+00, 2.0317090853E+01, 3.7887022395E+00, 9.7280859661E-01],
	[4.1550000000E+04, 3.8822310303E+01, 5.2921881332E+00, 2.0325087908E+01, 3.7890783620E+00, 9.7282042300E-01],
	[4.1555000000E+04, 3.8830498839E+01, 5.2922273585E+00, 2.0333087146E+01, 3.7894543879E+00, 9.7283224356E-01],
	[4.1560000000E+04, 3.8838688116E+01, 5.2922665795E+00, 2.0341088569E+01, 3.7898303172E+00, 9.7284405829E-01],
	[4.1565000000E+04, 3.8846878135E+01, 5.2923057959E+00, 2.0349092176E+01, 3.7902061500E+00, 9.7285586719E-01],
	[4.1570000000E+04, 3.8855068895E+01, 5.2923450080E+00, 2.0357097968E+01, 3.7905818861E+00, 9.7286767027E-01],
	[4.1575000000E+04, 3.8863260397E+01, 5.2923842156E+00, 2.0365105944E+01, 3.7909575258E+00, 9.7287946753E-01],
	[4.1580000000E+04, 3.8871452641E+01, 5.2924234188E+00, 2.0373116107E+01, 3.7913330689E+00, 9.7289125898E-01],
	[4.1585000000E+04, 3.8879645626E+01, 5.2924626176E+00, 2.0381128455E+01, 3.7917085156E+00, 9.7290304461E-01],
	[4.1590000000E+04, 3.8887839353E+01, 5.2925018120E+00, 2.0389142989E+01, 3.7920838658E+00, 9.7291482443E-01],
	[4.1595000000E+04, 3.8896033821E+01, 5.2925410019E+00, 2.0397159709E+01, 3.7924591195E+00, 9.7292659845E-01],
	[4.1600000000E+04, 3.8904229031E+01, 5.2925801874E+00, 2.0405178617E+01, 3.7928342768E+00, 9.7293836666E-01],
	[4.1605000000E+04, 3.8912424982E+01, 5.2926193685E+00, 2.0413199711E+01, 3.7932093378E+00, 9.7295012907E-01],
	[4.1610000000E+04, 3.8920621674E+01, 5.2926585452E+00, 2.0421222993E+01, 3.7935843023E+00, 9.7296188568E-01],
	[4.1615000000E+04, 3.8928819108E+01, 5.2926977175E+00, 2.0429248462E+01, 3.7939591706E+00, 9.7297363650E-01],
	[4.1620000000E+04, 3.8937017283E+01, 5.2927368853E+00, 2.0437276120E+01, 3.7943339425E+00, 9.7298538153E-01],
	[4.1625000000E+04, 3.8945216200E+01, 5.2927760487E+00, 2.0445305966E+01, 3.7947086180E+00, 9.7299712077E-01],
	[4.1630000000E+04, 3.8953415858E+01, 5.2928152078E+00, 2.0453338001E+01, 3.7950831974E+00, 9.7300885423E-01],
	[4.1635000000E+04, 3.8961616257E+01, 5.2928543624E+00, 2.0461372225E+01, 3.7954576804E+00, 9.7302058190E-01],
	[4.1640000000E+04, 3.8969817397E+01, 5.2928935125E+00, 2.0469408638E+01, 3.7958320673E+00, 9.7303230380E-01],
	[4.1645000000E+04, 3.8978019279E+01, 5.2929326583E+00, 2.0477447241E+01, 3.7962063579E+00, 9.7304401992E-01],
	[4.1650000000E+04, 3.8986221902E+01, 5.2929717997E+00, 2.0485488035E+01, 3.7965805523E+00, 9.7305573027E-01],
	[4.1655000000E+04, 3.8994425266E+01, 5.2930109367E+00, 2.0493531018E+01, 3.7969546506E+00, 9.7306743485E-01],
	[4.1660000000E+04, 3.9002629372E+01, 5.2930500692E+00, 2.0501576193E+01, 3.7973286527E+00, 9.7307913367E-01],
	[4.1665000000E+04, 3.9010834218E+01, 5.2930891973E+00, 2.0509623558E+01, 3.7977025588E+00, 9.7309082672E-01],
	[4.1670000000E+04, 3.9019039806E+01, 5.2931283211E+00, 2.0517673115E+01, 3.7980763687E+00, 9.7310251401E-01],
	[4.1675000000E+04, 3.9027246135E+01, 5.2931674404E+00, 2.0525724864E+01, 3.7984500826E+00, 9.7311419555E-01],
	[4.1680000000E+04, 3.9035453205E+01, 5.2932065553E+00, 2.0533778804E+01, 3.7988237004E+00, 9.7312587133E-01],
	[4.1685000000E+04, 3.9043661016E+01, 5.2932456659E+00, 2.0541834937E+01, 3.7991972222E+00, 9.7313754136E-01],
	[4.1690000000E+04, 3.9051869568E+01, 5.2932847720E+00, 2.0549893263E+01, 3.7995706480E+00, 9.7314920565E-01],
	[4.1695000000E+04, 3.9060078861E+01, 5.2933238737E+00, 2.0557953782E+01, 3.7999439778E+00, 9.7316086419E-01],
	[4.1700000000E+04, 3.9068288895E+01, 5.2933629710E+00, 2.0566016495E+01, 3.8003172116E+00, 9.7317251699E-01],
	[4.1705000000E+04, 3.9076499671E+01, 5.2934020640E+00, 2.0574081401E+01, 3.8006903496E+00, 9.7318416405E-01],
	[4.1710000000E+04, 3.9084711187E+01, 5.2934411525E+00, 2.0582148501E+01, 3.8010633916E+00, 9.7319580538E-01],
	[4.1715000000E+04, 3.9092923444E+01, 5.2934802366E+00, 2.0590217796E+01, 3.8014363378E+00, 9.7320744098E-01],
	[4.1720000000E+04, 3.9101136442E+01, 5.2935193164E+00, 2.0598289285E+01, 3.8018091881E+00, 9.7321907085E-01],
	[4.1725000000E+04, 3.9109350181E+01, 5.2935583917E+00, 2.0606362970E+01, 3.8021819425E+00, 9.7323069499E-01],
	[4.1730000000E+04, 3.9117564661E+01, 5.2935974626E+00, 2.0614438850E+01, 3.8025546011E+00, 9.7324231342E-01],
	[4.1735000000E+04, 3.9125779881E+01, 5.2936365292E+00, 2.0622516926E+01, 3.8029271640E+00, 9.7325392612E-01],
	[4.1740000000E+04, 3.9133995843E+01, 5.2936755914E+00, 2.0630597198E+01, 3.8032996311E+00, 9.7326553311E-01],
	[4.1745000000E+04, 3.9142212545E+01, 5.2937146491E+00, 2.0638679666E+01, 3.8036720024E+00, 9.7327713439E-01],
	[4.1750000000E+04, 3.9150429989E+01, 5.2937537025E+00, 2.0646764331E+01, 3.8040442780E+00, 9.7328872995E-01],
	[4.1755000000E+04, 3.9158648173E+01, 5.2937927515E+00, 2.0654851193E+01, 3.8044164579E+00, 9.7330031981E-01],
	[4.1760000000E+04, 3.9166867097E+01, 5.2938317961E+00, 2.0662940252E+01, 3.8047885422E+00, 9.7331190397E-01],
	[4.1765000000E+04, 3.9175086763E+01, 5.2938708363E+00, 2.0671031510E+01, 3.8051605308E+00, 9.7332348243E-01],
	[4.1770000000E+04, 3.9183307169E+01, 5.2939098721E+00, 2.0679124965E+01, 3.8055324237E+00, 9.7333505519E-01],
	[4.1775000000E+04, 3.9191528316E+01, 5.2939489036E+00, 2.0687220619E+01, 3.8059042211E+00, 9.7334662226E-01],
	[4.1780000000E+04, 3.9199750203E+01, 5.2939879307E+00, 2.0695318471E+01, 3.8062759229E+00, 9.7335818363E-01],
	[4.1785000000E+04, 3.9207972832E+01, 5.2940269533E+00, 2.0703418523E+01, 3.8066475291E+00, 9.7336973932E-01],
	[4.1790000000E+04, 3.9216196200E+01, 5.2940659716E+00, 2.0711520774E+01, 3.8070190398E+00, 9.7338128933E-01],
	[4.1795000000E+04, 3.9224420310E+01, 5.2941049856E+00, 2.0719625225E+01, 3.8073904550E+00, 9.7339283365E-01],
	[4.1800000000E+04, 3.9232645160E+01, 5.2941439951E+00, 2.0727731876E+01, 3.8077617747E+00, 9.7340437229E-01],
	[4.1805000000E+04, 3.9240870750E+01, 5.2941830003E+00, 2.0735840727E+01, 3.8081329989E+00, 9.7341590526E-01],
	[4.1810000000E+04, 3.9249097081E+01, 5.2942220010E+00, 2.0743951779E+01, 3.8085041277E+00, 9.7342743256E-01],
	[4.1815000000E+04, 3.9257324153E+01, 5.2942609974E+00, 2.0752065033E+01, 3.8088751610E+00, 9.7343895419E-01],
	[4.1820000000E+04, 3.9265551965E+01, 5.2942999895E+00, 2.0760180487E+01, 3.8092460990E+00, 9.7345047016E-01],
	[4.1825000000E+04, 3.9273780518E+01, 5.2943389771E+00, 2.0768298144E+01, 3.8096169416E+00, 9.7346198046E-01],
	[4.1830000000E+04, 3.9282027611E+01, 5.2943799782E+00, 2.0776418002E+01, 3.8099889012E+00, 9.7347348510E-01],
	[4.1835000000E+04, 3.9290275571E+01, 5.2944209883E+00, 2.0784540063E+01, 3.8103607739E+00, 9.7348498408E-01],
	[4.1840000000E+04, 3.9298524277E+01, 5.2944619938E+00, 2.0792664327E+01, 3.8107325516E+00, 9.7349647742E-01],
	[4.1845000000E+04, 3.9306773729E+01, 5.2945029948E+00, 2.0800790793E+01, 3.8111042343E+00, 9.7350796510E-01],
	[4.1850000000E+04, 3.9315023927E+01, 5.2945439912E+00, 2.0808919463E+01, 3.8114758220E+00, 9.7351944713E-01],
	[4.1855000000E+04, 3.9323274870E+01, 5.2945849830E+00, 2.0817050337E+01, 3.8118473146E+00, 9.7353092352E-01],
	[4.1860000000E+04, 3.9331526559E+01, 5.2946259702E+00, 2.0825183415E+01, 3.8122187123E+00, 9.7354239427E-01],
	[4.1865000000E+04, 3.9339778994E+01, 5.2946669529E+00, 2.0833318698E+01, 3.8125900151E+00, 9.7355385938E-01],
	[4.1870000000E+04, 3.9348032174E+01, 5.2947079309E+00, 2.0841456185E+01, 3.8129612229E+00, 9.7356531886E-01],
	[4.1875000000E+04, 3.9356286100E+01, 5.2947489044E+00, 2.0849595877E+01, 3.8133323358E+00, 9.7357677271E-01],
	[4.1880000000E+04, 3.9364540771E+01, 5.2947898734E+00, 2.0857737775E+01, 3.8137033539E+00, 9.7358822092E-01],
	[4.1885000000E+04, 3.9372796188E+01, 5.2948308377E+00, 2.0865881879E+01, 3.8140742771E+00, 9.7359966352E-01],
	[4.1890000000E+04, 3.9381052351E+01, 5.2948717975E+00, 2.0874028188E+01, 3.8144451054E+00, 9.7361110049E-01],
	[4.1895000000E+04, 3.9389309259E+01, 5.2949127527E+00, 2.0882176704E+01, 3.8148158390E+00, 9.7362253184E-01],
	[4.1900000000E+04, 3.9397566913E+01, 5.2949537033E+00, 2.0890327427E+01, 3.8151864778E+00, 9.7363395757E-01],
	[4.1905000000E+04, 3.9405825312E+01, 5.2949946494E+00, 2.0898480357E+01, 3.8155570218E+00, 9.7364537769E-01],
	[4.1910000000E+04, 3.9414084457E+01, 5.2950355909E+00, 2.0906635494E+01, 3.8159274711E+00, 9.7365679220E-01],
	[4.1915000000E+04, 3.9422344347E+01, 5.2950765278E+00, 2.0914792840E+01, 3.8162978257E+00, 9.7366820111E-01],
	[4.1920000000E+04, 3.9430604982E+01, 5.2951174602E+00, 2.0922952393E+01, 3.8166680855E+00, 9.7367960441E-01],
	[4.1925000000E+04, 3.9438866363E+01, 5.2951583879E+00, 2.0931114154E+01, 3.8170382507E+00, 9.7369100211E-01],
	[4.1930000000E+04, 3.9447128490E+01, 5.2951993112E+00, 2.0939278125E+01, 3.8174083213E+00, 9.7370239421E-01],
	[4.1935000000E+04, 3.9455391362E+01, 5.2952402298E+00, 2.0947444304E+01, 3.8177782973E+00, 9.7371378072E-01],
	[4.1940000000E+04, 3.9463654979E+01, 5.2952811439E+00, 2.0955612693E+01, 3.8181481786E+00, 9.7372516164E-01],
	[4.1945000000E+04, 3.9471919341E+01, 5.2953220535E+00, 2.0963783292E+01, 3.8185179654E+00, 9.7373653697E-01],
	[4.1950000000E+04, 3.9480184449E+01, 5.2953629585E+00, 2.0971956101E+01, 3.8188876576E+00, 9.7374790671E-01],
	[4.1955000000E+04, 3.9488450302E+01, 5.2954038589E+00, 2.0980131120E+01, 3.8192572553E+00, 9.7375927087E-01],
	[4.1960000000E+04, 3.9496716900E+01, 5.2954447548E+00, 2.0988308350E+01, 3.8196267585E+00, 9.7377062945E-01],
	[4.1965000000E+04, 3.9504984244E+01, 5.2954856461E+00, 2.0996487791E+01, 3.8199961672E+00, 9.7378198246E-01],
	[4.1970000000E+04, 3.9513252332E+01, 5.2955265328E+00, 2.1004669444E+01, 3.8203654814E+00, 9.7379332989E-01],
	[4.1975000000E+04, 3.9521521166E+01, 5.2955674150E+00, 2.1012853308E+01, 3.8207347012E+00, 9.7380467176E-01],
	[4.1980000000E+04, 3.9529790746E+01, 5.2956082926E+00, 2.1021039384E+01, 3.8211038266E+00, 9.7381600805E-01],
	[4.1985000000E+04, 3.9538061070E+01, 5.2956491657E+00, 2.1029227673E+01, 3.8214728576E+00, 9.7382733879E-01],
	[4.1990000000E+04, 3.9546332139E+01, 5.2956900343E+00, 2.1037418175E+01, 3.8218417942E+00, 9.7383866396E-01],
	[4.1995000000E+04, 3.9554603954E+01, 5.2957308983E+00, 2.1045610890E+01, 3.8222106365E+00, 9.7384998358E-01],
	[4.2000000000E+04, 3.9562876513E+01, 5.2957717577E+00, 2.1053805818E+01, 3.8225793845E+00, 9.7386129764E-01],
	[4.2005000000E+04, 3.9571149818E+01, 5.2958126126E+00, 2.1062002960E+01, 3.8229480381E+00, 9.7387260614E-01],
	[4.2010000000E+04, 3.9579423868E+01, 5.2958534629E+00, 2.1070202316E+01, 3.8233165975E+00, 9.7388390911E-01],
	[4.2015000000E+04, 3.9587698662E+01, 5.2958943087E+00, 2.1078403886E+01, 3.8236850627E+00, 9.7389520652E-01],
	[4.2020000000E+04, 3.9595974202E+01, 5.2959351500E+00, 2.1086607671E+01, 3.8240534336E+00, 9.7390649839E-01],
	[4.2025000000E+04, 3.9604250487E+01, 5.2959759867E+00, 2.1094813672E+01, 3.8244217103E+00, 9.7391778473E-01],
	[4.2030000000E+04, 3.9612527517E+01, 5.2960168188E+00, 2.1103021888E+01, 3.8247898928E+00, 9.7392906553E-01],
	[4.2035000000E+04, 3.9620805291E+01, 5.2960576464E+00, 2.1111232319E+01, 3.8251579812E+00, 9.7394034079E-01],
	[4.2040000000E+04, 3.9629083811E+01, 5.2960984695E+00, 2.1119444967E+01, 3.8255259754E+00, 9.7395161053E-01],
	[4.2045000000E+04, 3.9637363075E+01, 5.2961392880E+00, 2.1127659831E+01, 3.8258938755E+00, 9.7396287473E-01],
	[4.2050000000E+04, 3.9645643084E+01, 5.2961801020E+00, 2.1135876912E+01, 3.8262616815E+00, 9.7397413342E-01],
	[4.2055000000E+04, 3.9653923839E+01, 5.2962209115E+00, 2.1144096210E+01, 3.8266293934E+00, 9.7398538658E-01],
	[4.2060000000E+04, 3.9662205338E+01, 5.2962617164E+00, 2.1152317726E+01, 3.8269970113E+00, 9.7399663423E-01],
	[4.2065000000E+04, 3.9670487581E+01, 5.2963025168E+00, 2.1160541459E+01, 3.8273645352E+00, 9.7400787636E-01],
	[4.2070000000E+04, 3.9678770570E+01, 5.2963433127E+00, 2.1168767410E+01, 3.8277319651E+00, 9.7401911298E-01],
	[4.2075000000E+04, 3.9687054303E+01, 5.2963841040E+00, 2.1176995580E+01, 3.8280993010E+00, 9.7403034409E-01],
	[4.2080000000E+04, 3.9695338781E+01, 5.2964248908E+00, 2.1185225969E+01, 3.8284665430E+00, 9.7404156970E-01],
	[4.2085000000E+04, 3.9703624004E+01, 5.2964656730E+00, 2.1193458577E+01, 3.8288336910E+00, 9.7405278980E-01],
	[4.2090000000E+04, 3.9711909972E+01, 5.2965064507E+00, 2.1201693404E+01, 3.8292007451E+00, 9.7406400440E-01],
	[4.2095000000E+04, 3.9720196684E+01, 5.2965472239E+00, 2.1209930451E+01, 3.8295677053E+00, 9.7407521351E-01],
	[4.2100000000E+04, 3.9728484141E+01, 5.2965879926E+00, 2.1218169718E+01, 3.8299345717E+00, 9.7408641712E-01],
	[4.2105000000E+04, 3.9736772342E+01, 5.2966287567E+00, 2.1226411206E+01, 3.8303013442E+00, 9.7409761525E-01],
	[4.2110000000E+04, 3.9745061288E+01, 5.2966695163E+00, 2.1234654914E+01, 3.8306680230E+00, 9.7410880788E-01],
	[4.2115000000E+04, 3.9753350979E+01, 5.2967102714E+00, 2.1242900844E+01, 3.8310346079E+00, 9.7411999504E-01],
	[4.2120000000E+04, 3.9761641414E+01, 5.2967510219E+00, 2.1251148995E+01, 3.8314010991E+00, 9.7413117671E-01],
	[4.2125000000E+04, 3.9769932594E+01, 5.2967917680E+00, 2.1259399367E+01, 3.8317674965E+00, 9.7414235290E-01],
	[4.2130000000E+04, 3.9778224518E+01, 5.2968325095E+00, 2.1267651962E+01, 3.8321338002E+00, 9.7415352362E-01],
	[4.2135000000E+04, 3.9786517187E+01, 5.2968732465E+00, 2.1275906779E+01, 3.8325000102E+00, 9.7416468886E-01],
	[4.2140000000E+04, 3.9794810600E+01, 5.2969139789E+00, 2.1284163820E+01, 3.8328661265E+00, 9.7417584864E-01],
	[4.2145000000E+04, 3.9803104758E+01, 5.2969547069E+00, 2.1292423083E+01, 3.8332321492E+00, 9.7418700295E-01],
	[4.2150000000E+04, 3.9811399660E+01, 5.2969954303E+00, 2.1300684570E+01, 3.8335980782E+00, 9.7419815180E-01],
	[4.2155000000E+04, 3.9819695307E+01, 5.2970361492E+00, 2.1308948280E+01, 3.8339639136E+00, 9.7420929519E-01],
	[4.2160000000E+04, 3.9827991698E+01, 5.2970768636E+00, 2.1317214215E+01, 3.8343296555E+00, 9.7422043312E-01],
	[4.2165000000E+04, 3.9836288834E+01, 5.2971175735E+00, 2.1325482374E+01, 3.8346953038E+00, 9.7423156559E-01],
	[4.2170000000E+04, 3.9844586713E+01, 5.2971582789E+00, 2.1333752758E+01, 3.8350608585E+00, 9.7424269262E-01],
	[4.2175000000E+04, 3.9852885338E+01, 5.2971989797E+00, 2.1342025367E+01, 3.8354263197E+00, 9.7425381420E-01],
	[4.2180000000E+04, 3.9861184706E+01, 5.2972396760E+00, 2.1350300201E+01, 3.8357916875E+00, 9.7426493033E-01],
	[4.2185000000E+04, 3.9869484819E+01, 5.2972803679E+00, 2.1358577262E+01, 3.8361569618E+00, 9.7427604102E-01],
	[4.2190000000E+04, 3.9877785676E+01, 5.2973210552E+00, 2.1366856548E+01, 3.8365221426E+00, 9.7428714628E-01],
	[4.2195000000E+04, 3.9886087277E+01, 5.2973617380E+00, 2.1375138061E+01, 3.8368872300E+00, 9.7429824610E-01],
	[4.2200000000E+04, 3.9894389622E+01, 5.2974024163E+00, 2.1383421801E+01, 3.8372522240E+00, 9.7430934048E-01],
	[4.2205000000E+04, 3.9902692712E+01, 5.2974430901E+00, 2.1391707768E+01, 3.8376171247E+00, 9.7432042944E-01],
	[4.2210000000E+04, 3.9910996546E+01, 5.2974837594E+00, 2.1399995962E+01, 3.8379819319E+00, 9.7433151297E-01],
	[4.2215000000E+04, 3.9919301124E+01, 5.2975244242E+00, 2.1408286384E+01, 3.8383466459E+00, 9.7434259107E-01],
	[4.2220000000E+04, 3.9927606446E+01, 5.2975650844E+00, 2.1416579035E+01, 3.8387112665E+00, 9.7435366375E-01],
	[4.2225000000E+04, 3.9935912512E+01, 5.2976057402E+00, 2.1424873913E+01, 3.8390757939E+00, 9.7436473102E-01],
	[4.2230000000E+04, 3.9944219323E+01, 5.2976463915E+00, 2.1433171021E+01, 3.8394402280E+00, 9.7437579287E-01],
	[4.2235000000E+04, 3.9952526877E+01, 5.2976870383E+00, 2.1441470358E+01, 3.8398045689E+00, 9.7438684932E-01],
	[4.2240000000E+04, 3.9960835176E+01, 5.2977276805E+00, 2.1449771924E+01, 3.8401688165E+00, 9.7439790035E-01],
	[4.2245000000E+04, 3.9969144218E+01, 5.2977683183E+00, 2.1458075720E+01, 3.8405329710E+00, 9.7440894597E-01],
	[4.2250000000E+04, 3.9977454005E+01, 5.2978089516E+00, 2.1466381746E+01, 3.8408970323E+00, 9.7441998620E-01],
	[4.2255000000E+04, 3.9985764535E+01, 5.2978495804E+00, 2.1474690003E+01, 3.8412610004E+00, 9.7443102102E-01],
	[4.2260000000E+04, 3.9994075810E+01, 5.2978902046E+00, 2.1483000490E+01, 3.8416248754E+00, 9.7444205045E-01],
	[4.2265000000E+04, 4.0002387828E+01, 5.2979308244E+00, 2.1491313209E+01, 3.8419886573E+00, 9.7445307449E-01],
	[4.2270000000E+04, 4.0010700591E+01, 5.2979714397E+00, 2.1499628159E+01, 3.8423523462E+00, 9.7446409313E-01],
	[4.2275000000E+04, 4.0019014097E+01, 5.2980120505E+00, 2.1507945341E+01, 3.8427159420E+00, 9.7447510639E-01],
	[4.2280000000E+04, 4.0027328347E+01, 5.2980526568E+00, 2.1516264755E+01, 3.8430794448E+00, 9.7448611426E-01],
	[4.2285000000E+04, 4.0035643341E+01, 5.2980932587E+00, 2.1524586402E+01, 3.8434428545E+00, 9.7449711675E-01],
	[4.2290000000E+04, 4.0043959079E+01, 5.2981338560E+00, 2.1532910281E+01, 3.8438061713E+00, 9.7450811386E-01],
	[4.2295000000E+04, 4.0052275561E+01, 5.2981744488E+00, 2.1541236394E+01, 3.8441693951E+00, 9.7451910560E-01],
	[4.2300000000E+04, 4.0060592787E+01, 5.2982150372E+00, 2.1549564740E+01, 3.8445325260E+00, 9.7453009197E-01],
	[4.2305000000E+04, 4.0068910756E+01, 5.2982556211E+00, 2.1557895320E+01, 3.8448955639E+00, 9.7454107296E-01],
	[4.2310000000E+04, 4.0077229469E+01, 5.2982962004E+00, 2.1566228134E+01, 3.8452585090E+00, 9.7455204859E-01],
	[4.2315000000E+04, 4.0085548926E+01, 5.2983367753E+00, 2.1574563182E+01, 3.8456213612E+00, 9.7456301885E-01],
	[4.2320000000E+04, 4.0093869126E+01, 5.2983773457E+00, 2.1582900466E+01, 3.8459841206E+00, 9.7457398376E-01],
	[4.2325000000E+04, 4.0102190070E+01, 5.2984179117E+00, 2.1591239985E+01, 3.8463467871E+00, 9.7458494330E-01],
	[4.2330000000E+04, 4.0110511758E+01, 5.2984584731E+00, 2.1599581739E+01, 3.8467093608E+00, 9.7459589750E-01],
	[4.2335000000E+04, 4.0118834190E+01, 5.2984990301E+00, 2.1607925729E+01, 3.8470718418E+00, 9.7460684634E-01],
	[4.2340000000E+04, 4.0127157365E+01, 5.2985395826E+00, 2.1616271955E+01, 3.8474342300E+00, 9.7461778983E-01],
	[4.2345000000E+04, 4.0135481284E+01, 5.2985801306E+00, 2.1624620417E+01, 3.8477965255E+00, 9.7462872798E-01],
	[4.2350000000E+04, 4.0143805946E+01, 5.2986206741E+00, 2.1632971117E+01, 3.8481587283E+00, 9.7463966078E-01],
	[4.2355000000E+04, 4.0152131352E+01, 5.2986612132E+00, 2.1641324053E+01, 3.8485208383E+00, 9.7465058825E-01],
	[4.2360000000E+04, 4.0160457501E+01, 5.2987017478E+00, 2.1649679227E+01, 3.8488828558E+00, 9.7466151037E-01],
	[4.2365000000E+04, 4.0168784394E+01, 5.2987422779E+00, 2.1658036639E+01, 3.8492447806E+00, 9.7467242717E-01],
	[4.2370000000E+04, 4.0177112031E+01, 5.2987828035E+00, 2.1666396290E+01, 3.8496066127E+00, 9.7468333863E-01],
	[4.2375000000E+04, 4.0185440411E+01, 5.2988233247E+00, 2.1674758178E+01, 3.8499683523E+00, 9.7469424477E-01],
	[4.2380000000E+04, 4.0193769534E+01, 5.2988638414E+00, 2.1683122306E+01, 3.8503299993E+00, 9.7470514558E-01],
	[4.2385000000E+04, 4.0202099401E+01, 5.2989043536E+00, 2.1691488672E+01, 3.8506915538E+00, 9.7471604107E-01],
	[4.2390000000E+04, 4.0210430011E+01, 5.2989448614E+00, 2.1699857279E+01, 3.8510530157E+00, 9.7472693124E-01],
	[4.2395000000E+04, 4.0218761365E+01, 5.2989853646E+00, 2.1708228125E+01, 3.8514143852E+00, 9.7473781609E-01],
	[4.2400000000E+04, 4.0227093462E+01, 5.2990258635E+00, 2.1716601211E+01, 3.8517756621E+00, 9.7474869564E-01],
	[4.2405000000E+04, 4.0235426302E+01, 5.2990663578E+00, 2.1724976538E+01, 3.8521368467E+00, 9.7475956987E-01],
	[4.2410000000E+04, 4.0243759886E+01, 5.2991068477E+00, 2.1733354105E+01, 3.8524979387E+00, 9.7477043879E-01],
	[4.2415000000E+04, 4.0252094213E+01, 5.2991473331E+00, 2.1741733914E+01, 3.8528589384E+00, 9.7478130242E-01],
	[4.2420000000E+04, 4.0260429283E+01, 5.2991878141E+00, 2.1750115965E+01, 3.8532198457E+00, 9.7479216074E-01],
	[4.2425000000E+04, 4.0268765096E+01, 5.2992282906E+00, 2.1758500257E+01, 3.8535806607E+00, 9.7480301376E-01],
	[4.2430000000E+04, 4.0277101653E+01, 5.2992687626E+00, 2.1766886791E+01, 3.8539413833E+00, 9.7481386149E-01],
	[4.2435000000E+04, 4.0285438953E+01, 5.2993092302E+00, 2.1775275568E+01, 3.8543020135E+00, 9.7482470392E-01],
	[4.2440000000E+04, 4.0293776996E+01, 5.2993496933E+00, 2.1783666588E+01, 3.8546625515E+00, 9.7483554107E-01],
	[4.2445000000E+04, 4.0302115783E+01, 5.2993901520E+00, 2.1792059851E+01, 3.8550229972E+00, 9.7484637293E-01],
	[4.2450000000E+04, 4.0310455312E+01, 5.2994306062E+00, 2.1800455358E+01, 3.8553833507E+00, 9.7485719951E-01],
	[4.2455000000E+04, 4.0318795585E+01, 5.2994710559E+00, 2.1808853108E+01, 3.8557436120E+00, 9.7486802080E-01],
	[4.2460000000E+04, 4.0327136601E+01, 5.2995115012E+00, 2.1817253103E+01, 3.8561037810E+00, 9.7487883682E-01],
	[4.2465000000E+04, 4.0335478360E+01, 5.2995519421E+00, 2.1825655342E+01, 3.8564638579E+00, 9.7488964757E-01],
	[4.2470000000E+04, 4.0343820862E+01, 5.2995923785E+00, 2.1834059826E+01, 3.8568238426E+00, 9.7490045304E-01],
	[4.2475000000E+04, 4.0352164107E+01, 5.2996328104E+00, 2.1842466555E+01, 3.8571837352E+00, 9.7491125325E-01],
	[4.2480000000E+04, 4.0360508095E+01, 5.2996732379E+00, 2.1850875530E+01, 3.8575435357E+00, 9.7492204819E-01],
	[4.2485000000E+04, 4.0368852826E+01, 5.2997136609E+00, 2.1859286751E+01, 3.8579032441E+00, 9.7493283787E-01],
	[4.2490000000E+04, 4.0377198300E+01, 5.2997540795E+00, 2.1867700218E+01, 3.8582628604E+00, 9.7494362229E-01],
	[4.2495000000E+04, 4.0385544517E+01, 5.2997944936E+00, 2.1876115931E+01, 3.8586223847E+00, 9.7495440145E-01],
	[4.2500000000E+04, 4.0393897325E+01, 5.2998355560E+00, 2.1884533892E+01, 3.8589822164E+00, 9.7496517536E-01],
	[4.2505000000E+04, 4.0402262858E+01, 5.2998779506E+00, 2.1892954099E+01, 3.8593427744E+00, 9.7497594401E-01],
	[4.2510000000E+04, 4.0410629140E+01, 5.2999203407E+00, 2.1901376554E+01, 3.8597032406E+00, 9.7498670742E-01],
	[4.2515000000E+04, 4.0418996171E+01, 5.2999627261E+00, 2.1909801257E+01, 3.8600636152E+00, 9.7499746559E-01],
	[4.2520000000E+04, 4.0427363949E+01, 5.3000051068E+00, 2.1918228209E+01, 3.8604238980E+00, 9.7500821851E-01],
	[4.2525000000E+04, 4.0435732475E+01, 5.3000474829E+00, 2.1926657408E+01, 3.8607840891E+00, 9.7501896620E-01],
	[4.2530000000E+04, 4.0444101750E+01, 5.3000898544E+00, 2.1935088857E+01, 3.8611441886E+00, 9.7502970864E-01],
	[4.2535000000E+04, 4.0452471772E+01, 5.3001322212E+00, 2.1943522555E+01, 3.8615041965E+00, 9.7504044586E-01],
	[4.2540000000E+04, 4.0460842543E+01, 5.3001745833E+00, 2.1951958503E+01, 3.8618641127E+00, 9.7505117785E-01],
	[4.2545000000E+04, 4.0469214062E+01, 5.3002169409E+00, 2.1960396700E+01, 3.8622239374E+00, 9.7506190460E-01],
	[4.2550000000E+04, 4.0477586328E+01, 5.3002592938E+00, 2.1968837148E+01, 3.8625836705E+00, 9.7507262614E-01],
	[4.2555000000E+04, 4.0485959343E+01, 5.3003016420E+00, 2.1977279846E+01, 3.8629433121E+00, 9.7508334245E-01],
	[4.2560000000E+04, 4.0494333106E+01, 5.3003439856E+00, 2.1985724795E+01, 3.8633028622E+00, 9.7509405354E-01],
	[4.2565000000E+04, 4.0502707616E+01, 5.3003863246E+00, 2.1994171995E+01, 3.8636623208E+00, 9.7510475942E-01],
	[4.2570000000E+04, 4.0511082875E+01, 5.3004286589E+00, 2.2002621447E+01, 3.8640216879E+00, 9.7511546009E-01],
	[4.2575000000E+04, 4.0519458881E+01, 5.3004709886E+00, 2.2011073151E+01, 3.8643809636E+00, 9.7512615554E-01],
	[4.2580000000E+04, 4.0527835635E+01, 5.3005133137E+00, 2.2019527107E+01, 3.8647401478E+00, 9.7513684579E-01],
	[4.2585000000E+04, 4.0536213138E+01, 5.3005556342E+00, 2.2027983316E+01, 3.8650992407E+00, 9.7514753083E-01],
	[4.2590000000E+04, 4.0544591388E+01, 5.3005979500E+00, 2.2036441778E+01, 3.8654582422E+00, 9.7515821067E-01],
	[4.2595000000E+04, 4.0552970385E+01, 5.3006402612E+00, 2.2044902492E+01, 3.8658171523E+00, 9.7516888531E-01],
	[4.2600000000E+04, 4.0561350131E+01, 5.3006825677E+00, 2.2053365461E+01, 3.8661759711E+00, 9.7517955475E-01],
	[4.2605000000E+04, 4.0569730625E+01, 5.3007248697E+00, 2.2061830683E+01, 3.8665346986E+00, 9.7519021899E-01],
	[4.2610000000E+04, 4.0578111866E+01, 5.3007671670E+00, 2.2070298160E+01, 3.8668933348E+00, 9.7520087804E-01],
	[4.2615000000E+04, 4.0586493855E+01, 5.3008094596E+00, 2.2078767891E+01, 3.8672518797E+00, 9.7521153190E-01],
	[4.2620000000E+04, 4.0594876591E+01, 5.3008517477E+00, 2.2087239877E+01, 3.8676103334E+00, 9.7522218057E-01],
	[4.2625000000E+04, 4.0603260076E+01, 5.3008940311E+00, 2.2095714119E+01, 3.8679686959E+00, 9.7523282405E-01],
	[4.2630000000E+04, 4.0611644308E+01, 5.3009363099E+00, 2.2104190616E+01, 3.8683269672E+00, 9.7524346236E-01],
	[4.2635000000E+04, 4.0620029287E+01, 5.3009785841E+00, 2.2112669368E+01, 3.8686851473E+00, 9.7525409548E-01],
	[4.2640000000E+04, 4.0628415015E+01, 5.3010208537E+00, 2.2121150378E+01, 3.8690432363E+00, 9.7526472342E-01],
	[4.2645000000E+04, 4.0636801489E+01, 5.3010631186E+00, 2.2129633643E+01, 3.8694012342E+00, 9.7527534619E-01],
	[4.2650000000E+04, 4.0645188712E+01, 5.3011053789E+00, 2.2138119166E+01, 3.8697591409E+00, 9.7528596378E-01],
	[4.2655000000E+04, 4.0653576682E+01, 5.3011476346E+00, 2.2146606946E+01, 3.8701169566E+00, 9.7529657620E-01],
	[4.2660000000E+04, 4.0661965400E+01, 5.3011898857E+00, 2.2155096984E+01, 3.8704746812E+00, 9.7530718346E-01],
	[4.2665000000E+04, 4.0670354865E+01, 5.3012321322E+00, 2.2163589279E+01, 3.8708323148E+00, 9.7531778555E-01],
	[4.2670000000E+04, 4.0678745077E+01, 5.3012743741E+00, 2.2172083833E+01, 3.8711898574E+00, 9.7532838248E-01],
	[4.2675000000E+04, 4.0687136038E+01, 5.3013166113E+00, 2.2180580646E+01, 3.8715473090E+00, 9.7533897424E-01],
	[4.2680000000E+04, 4.0695527745E+01, 5.3013588440E+00, 2.2189079717E+01, 3.8719046696E+00, 9.7534956085E-01],
	[4.2685000000E+04, 4.0703920200E+01, 5.3014010720E+00, 2.2197581048E+01, 3.8722619393E+00, 9.7536014231E-01],
	[4.2690000000E+04, 4.0712313403E+01, 5.3014432954E+00, 2.2206084638E+01, 3.8726191181E+00, 9.7537071861E-01],
	[4.2695000000E+04, 4.0720707353E+01, 5.3014855142E+00, 2.2214590489E+01, 3.8729762060E+00, 9.7538128976E-01],
	[4.2700000000E+04, 4.0729102050E+01, 5.3015277284E+00, 2.2223098599E+01, 3.8733332030E+00, 9.7539185576E-01],
	[4.2705000000E+04, 4.0737497494E+01, 5.3015699380E+00, 2.2231608970E+01, 3.8736901091E+00, 9.7540241662E-01],
	[4.2710000000E+04, 4.0745893686E+01, 5.3016121430E+00, 2.2240121603E+01, 3.8740469245E+00, 9.7541297234E-01],
	[4.2715000000E+04, 4.0754290626E+01, 5.3016543434E+00, 2.2248636496E+01, 3.8744036490E+00, 9.7542352291E-01],
	[4.2720000000E+04, 4.0762688312E+01, 5.3016965392E+00, 2.2257153651E+01, 3.8747602827E+00, 9.7543406835E-01],
	[4.2725000000E+04, 4.0771086746E+01, 5.3017387303E+00, 2.2265673068E+01, 3.8751168257E+00, 9.7544460866E-01],
	[4.2730000000E+04, 4.0779485927E+01, 5.3017809169E+00, 2.2274194748E+01, 3.8754732780E+00, 9.7545514383E-01],
	[4.2735000000E+04, 4.0787885855E+01, 5.3018230989E+00, 2.2282718690E+01, 3.8758296395E+00, 9.7546567387E-01],
	[4.2740000000E+04, 4.0796286531E+01, 5.3018652763E+00, 2.2291244895E+01, 3.8761859104E+00, 9.7547619878E-01],
	[4.2745000000E+04, 4.0804687954E+01, 5.3019074490E+00, 2.2299773363E+01, 3.8765420906E+00, 9.7548671857E-01],
	[4.2750000000E+04, 4.0813090124E+01, 5.3019496172E+00, 2.2308304095E+01, 3.8768981801E+00, 9.7549723324E-01],
	[4.2755000000E+04, 4.0821493041E+01, 5.3019917808E+00, 2.2316837091E+01, 3.8772541790E+00, 9.7550774279E-01],
	[4.2760000000E+04, 4.0829896705E+01, 5.3020339398E+00, 2.2325372351E+01, 3.8776100874E+00, 9.7551824722E-01],
	[4.2765000000E+04, 4.0838301116E+01, 5.3020760942E+00, 2.2333909876E+01, 3.8779659051E+00, 9.7552874654E-01],
	[4.2770000000E+04, 4.0846706275E+01, 5.3021182440E+00, 2.2342449666E+01, 3.8783216323E+00, 9.7553924074E-01],
	[4.2775000000E+04, 4.0855112180E+01, 5.3021603892E+00, 2.2350991721E+01, 3.8786772690E+00, 9.7554972984E-01],
	[4.2780000000E+04, 4.0863518833E+01, 5.3022025298E+00, 2.2359536042E+01, 3.8790328151E+00, 9.7556021383E-01],
	[4.2785000000E+04, 4.0871926232E+01, 5.3022446658E+00, 2.2368082629E+01, 3.8793882708E+00, 9.7557069271E-01],
	[4.2790000000E+04, 4.0880334379E+01, 5.3022867973E+00, 2.2376631482E+01, 3.8797436360E+00, 9.7558116649E-01],
	[4.2795000000E+04, 4.0888743272E+01, 5.3023289241E+00, 2.2385182602E+01, 3.8800989108E+00, 9.7559163517E-01],
	[4.2800000000E+04, 4.0897152913E+01, 5.3023710464E+00, 2.2393735989E+01, 3.8804540952E+00, 9.7560209876E-01],
	[4.2805000000E+04, 4.0905563300E+01, 5.3024131641E+00, 2.2402291643E+01, 3.8808091891E+00, 9.7561255725E-01],
	[4.2810000000E+04, 4.0913974434E+01, 5.3024552772E+00, 2.2410849565E+01, 3.8811641928E+00, 9.7562301065E-01],
	[4.2815000000E+04, 4.0922386316E+01, 5.3024973857E+00, 2.2419409755E+01, 3.8815191060E+00, 9.7563345896E-01],
	[4.2820000000E+04, 4.0930798944E+01, 5.3025394896E+00, 2.2427972214E+01, 3.8818739289E+00, 9.7564390219E-01],
	[4.2825000000E+04, 4.0939212319E+01, 5.3025815889E+00, 2.2436536941E+01, 3.8822286616E+00, 9.7565434033E-01],
	[4.2830000000E+04, 4.0947626441E+01, 5.3026236837E+00, 2.2445103936E+01, 3.8825833039E+00, 9.7566477338E-01],
	[4.2835000000E+04, 4.0956041309E+01, 5.3026657739E+00, 2.2453673202E+01, 3.8829378560E+00, 9.7567520136E-01],
	[4.2840000000E+04, 4.0964456925E+01, 5.3027078595E+00, 2.2462244737E+01, 3.8832923179E+00, 9.7568562427E-01],
	[4.2845000000E+04, 4.0972873287E+01, 5.3027499405E+00, 2.2470818542E+01, 3.8836466896E+00, 9.7569604210E-01],
	[4.2850000000E+04, 4.0981290396E+01, 5.3027920170E+00, 2.2479394617E+01, 3.8840009710E+00, 9.7570645485E-01],
	[4.2855000000E+04, 4.0989708251E+01, 5.3028340888E+00, 2.2487972963E+01, 3.8843551624E+00, 9.7571686254E-01],
	[4.2860000000E+04, 4.0998126854E+01, 5.3028761561E+00, 2.2496553580E+01, 3.8847092635E+00, 9.7572726517E-01],
	[4.2865000000E+04, 4.1006546203E+01, 5.3029182189E+00, 2.2505136469E+01, 3.8850632746E+00, 9.7573766272E-01],
	[4.2870000000E+04, 4.1014966299E+01, 5.3029602770E+00, 2.2513721629E+01, 3.8854171955E+00, 9.7574805522E-01],
	[4.2875000000E+04, 4.1023387141E+01, 5.3030023306E+00, 2.2522309061E+01, 3.8857710264E+00, 9.7575844266E-01],
	[4.2880000000E+04, 4.1031808730E+01, 5.3030443796E+00, 2.2530898766E+01, 3.8861247673E+00, 9.7576882504E-01],
	[4.2885000000E+04, 4.1040231066E+01, 5.3030864241E+00, 2.2539490743E+01, 3.8864784181E+00, 9.7577920237E-01],
	[4.2890000000E+04, 4.1048654148E+01, 5.3031284639E+00, 2.2548084994E+01, 3.8868319789E+00, 9.7578957465E-01],
	[4.2895000000E+04, 4.1057077977E+01, 5.3031704992E+00, 2.2556681517E+01, 3.8871854497E+00, 9.7579994188E-01],
	[4.2900000000E+04, 4.1065502552E+01, 5.3032125300E+00, 2.2565280315E+01, 3.8875388306E+00, 9.7581030406E-01],
	[4.2905000000E+04, 4.1073927874E+01, 5.3032545562E+00, 2.2573881386E+01, 3.8878921215E+00, 9.7582066120E-01],
	[4.2910000000E+04, 4.1082353942E+01, 5.3032965778E+00, 2.2582484732E+01, 3.8882453225E+00, 9.7583101330E-01],
	[4.2915000000E+04, 4.1090780757E+01, 5.3033385948E+00, 2.2591090353E+01, 3.8885984337E+00, 9.7584136036E-01],
	[4.2920000000E+04, 4.1099208318E+01, 5.3033806073E+00, 2.2599698249E+01, 3.8889514549E+00, 9.7585170238E-01],
	[4.2925000000E+04, 4.1107636626E+01, 5.3034226152E+00, 2.2608308420E+01, 3.8893043863E+00, 9.7586203937E-01],
	[4.2930000000E+04, 4.1116065680E+01, 5.3034646186E+00, 2.2616920867E+01, 3.8896572279E+00, 9.7587237133E-01],
	[4.2935000000E+04, 4.1124495481E+01, 5.3035066174E+00, 2.2625535589E+01, 3.8900099798E+00, 9.7588269826E-01],
	[4.2940000000E+04, 4.1132926028E+01, 5.3035486116E+00, 2.2634152589E+01, 3.8903626418E+00, 9.7589302017E-01],
	[4.2945000000E+04, 4.1141357321E+01, 5.3035906013E+00, 2.2642771865E+01, 3.8907152141E+00, 9.7590333705E-01],
	[4.2950000000E+04, 4.1149789361E+01, 5.3036325865E+00, 2.2651393418E+01, 3.8910676966E+00, 9.7591364891E-01],
	[4.2955000000E+04, 4.1158222147E+01, 5.3036745670E+00, 2.2660017248E+01, 3.8914200894E+00, 9.7592395576E-01],
	[4.2960000000E+04, 4.1166655679E+01, 5.3037165431E+00, 2.2668643357E+01, 3.8917723926E+00, 9.7593425758E-01],
	[4.2965000000E+04, 4.1175089957E+01, 5.3037585145E+00, 2.2677271743E+01, 3.8921246061E+00, 9.7594455440E-01],
	[4.2970000000E+04, 4.1183524982E+01, 5.3038004815E+00, 2.2685902408E+01, 3.8924767300E+00, 9.7595484620E-01],
	[4.2975000000E+04, 4.1191960753E+01, 5.3038424438E+00, 2.2694535351E+01, 3.8928287642E+00, 9.7596513300E-01],
	[4.2980000000E+04, 4.1200397270E+01, 5.3038844016E+00, 2.2703170574E+01, 3.8931807088E+00, 9.7597541479E-01],
	[4.2985000000E+04, 4.1208834534E+01, 5.3039263549E+00, 2.2711808076E+01, 3.8935325639E+00, 9.7598569157E-01],
	[4.2990000000E+04, 4.1217272543E+01, 5.3039683036E+00, 2.2720447858E+01, 3.8938843295E+00, 9.7599596336E-01],
	[4.2995000000E+04, 4.1225711299E+01, 5.3040102478E+00, 2.2729089920E+01, 3.8942360055E+00, 9.7600623015E-01],
	[4.3000000000E+04, 4.1234150801E+01, 5.3040521874E+00, 2.2737734262E+01, 3.8945875920E+00, 9.7601649194E-01],
	[4.3005000000E+04, 4.1242591049E+01, 5.3040941225E+00, 2.2746380885E+01, 3.8949390890E+00, 9.7602674874E-01],
	[4.3010000000E+04, 4.1251032043E+01, 5.3041360531E+00, 2.2755029789E+01, 3.8952904966E+00, 9.7603700055E-01],
	[4.3015000000E+04, 4.1259473783E+01, 5.3041779791E+00, 2.2763680975E+01, 3.8956418147E+00, 9.7604724737E-01],
	[4.3020000000E+04, 4.1267916269E+01, 5.3042199005E+00, 2.2772334442E+01, 3.8959930434E+00, 9.7605748920E-01],
	[4.3025000000E+04, 4.1276359501E+01, 5.3042618174E+00, 2.2780990192E+01, 3.8963441828E+00, 9.7606772605E-01],
	[4.3030000000E+04, 4.1284803479E+01, 5.3043037298E+00, 2.2789648224E+01, 3.8966952328E+00, 9.7607795793E-01],
	[4.3035000000E+04, 4.1293248204E+01, 5.3043456376E+00, 2.2798308539E+01, 3.8970461934E+00, 9.7608818482E-01],
	[4.3040000000E+04, 4.1301693674E+01, 5.3043875409E+00, 2.2806971137E+01, 3.8973970647E+00, 9.7609840674E-01],
	[4.3045000000E+04, 4.1310139890E+01, 5.3044294397E+00, 2.2815636018E+01, 3.8977478468E+00, 9.7610862368E-01],
	[4.3050000000E+04, 4.1318586852E+01, 5.3044713339E+00, 2.2824303183E+01, 3.8980985395E+00, 9.7611883566E-01],
	[4.3055000000E+04, 4.1327034560E+01, 5.3045132236E+00, 2.2832972633E+01, 3.8984491430E+00, 9.7612904267E-01],
	[4.3060000000E+04, 4.1335483013E+01, 5.3045551088E+00, 2.2841644366E+01, 3.8987996573E+00, 9.7613924471E-01],
	[4.3065000000E+04, 4.1343932213E+01, 5.3045969894E+00, 2.2850318385E+01, 3.8991500823E+00, 9.7614944179E-01],
	[4.3070000000E+04, 4.1352382158E+01, 5.3046388655E+00, 2.2858994689E+01, 3.8995004182E+00, 9.7615963391E-01],
	[4.3075000000E+04, 4.1360832850E+01, 5.3046807370E+00, 2.2867673278E+01, 3.8998506650E+00, 9.7616982107E-01],
	[4.3080000000E+04, 4.1369284287E+01, 5.3047226041E+00, 2.2876354153E+01, 3.9002008225E+00, 9.7618000328E-01],
	[4.3085000000E+04, 4.1377736470E+01, 5.3047644666E+00, 2.2885037314E+01, 3.9005508910E+00, 9.7619018053E-01],
	[4.3090000000E+04, 4.1386189398E+01, 5.3048063246E+00, 2.2893722762E+01, 3.9009008704E+00, 9.7620035283E-01],
	[4.3095000000E+04, 4.1394643073E+01, 5.3048481780E+00, 2.2902410496E+01, 3.9012507607E+00, 9.7621052019E-01],
	[4.3100000000E+04, 4.1403097493E+01, 5.3048900269E+00, 2.2911100518E+01, 3.9016005620E+00, 9.7622068260E-01],
	[4.3105000000E+04, 4.1411552658E+01, 5.3049318713E+00, 2.2919792827E+01, 3.9019502743E+00, 9.7623084007E-01],
	[4.3110000000E+04, 4.1420008570E+01, 5.3049737112E+00, 2.2928487424E+01, 3.9022998975E+00, 9.7624099260E-01],
	[4.3115000000E+04, 4.1428465227E+01, 5.3050155466E+00, 2.2937184309E+01, 3.9026494318E+00, 9.7625114019E-01],
	[4.3120000000E+04, 4.1436922629E+01, 5.3050573774E+00, 2.2945883482E+01, 3.9029988771E+00, 9.7626128284E-01],
	[4.3125000000E+04, 4.1445380778E+01, 5.3050992037E+00, 2.2954584945E+01, 3.9033482335E+00, 9.7627142056E-01],
	[4.3130000000E+04, 4.1453839672E+01, 5.3051410255E+00, 2.2963288697E+01, 3.9036975010E+00, 9.7628155336E-01],
	[4.3135000000E+04, 4.1462299311E+01, 5.3051828428E+00, 2.2971994738E+01, 3.9040466796E+00, 9.7629168122E-01],
	[4.3140000000E+04, 4.1470759696E+01, 5.3052246555E+00, 2.2980703069E+01, 3.9043957693E+00, 9.7630180416E-01],
	[4.3145000000E+04, 4.1479220826E+01, 5.3052664638E+00, 2.2989413690E+01, 3.9047447702E+00, 9.7631192218E-01],
	[4.3150000000E+04, 4.1487682702E+01, 5.3053082675E+00, 2.2998126602E+01, 3.9050936823E+00, 9.7632203528E-01],
	[4.3155000000E+04, 4.1496145324E+01, 5.3053500667E+00, 2.3006841804E+01, 3.9054425055E+00, 9.7633214345E-01],
	[4.3160000000E+04, 4.1504608691E+01, 5.3053918614E+00, 2.3015559298E+01, 3.9057912401E+00, 9.7634224672E-01],
	[4.3165000000E+04, 4.1513072803E+01, 5.3054336516E+00, 2.3024279083E+01, 3.9061398858E+00, 9.7635234507E-01],
	[4.3170000000E+04, 4.1521537661E+01, 5.3054754373E+00, 2.3033001160E+01, 3.9064884429E+00, 9.7636243851E-01],
	[4.3175000000E+04, 4.1530003264E+01, 5.3055172184E+00, 2.3041725530E+01, 3.9068369112E+00, 9.7637252705E-01],
	[4.3180000000E+04, 4.1538469613E+01, 5.3055589951E+00, 2.3050452192E+01, 3.9071852908E+00, 9.7638261068E-01],
	[4.3185000000E+04, 4.1546945482E+01, 5.3056017315E+00, 2.3059181146E+01, 3.9075341825E+00, 9.7639268940E-01],
	[4.3190000000E+04, 4.1555431057E+01, 5.3056454475E+00, 2.3067912394E+01, 3.9078835988E+00, 9.7640276323E-01],
	[4.3195000000E+04, 4.1563917383E+01, 5.3056891589E+00, 2.3076645936E+01, 3.9082329267E+00, 9.7641283216E-01],
	[4.3200000000E+04, 4.1572404459E+01, 5.3057328655E+00, 2.3085381771E+01, 3.9085821662E+00, 9.7642289619E-01],
	[4.3205000000E+04, 4.1580892285E+01, 5.3057765674E+00, 2.3094119901E+01, 3.9089313173E+00, 9.7643295534E-01],
	[4.3210000000E+04, 4.1589380862E+01, 5.3058202646E+00, 2.3102860325E+01, 3.9092803801E+00, 9.7644300959E-01],
	[4.3215000000E+04, 4.1597870190E+01, 5.3058639571E+00, 2.3111603044E+01, 3.9096293546E+00, 9.7645305895E-01],
	[4.3220000000E+04, 4.1606360267E+01, 5.3059076449E+00, 2.3120348058E+01, 3.9099782408E+00, 9.7646310343E-01],
	[4.3225000000E+04, 4.1614851095E+01, 5.3059513280E+00, 2.3129095368E+01, 3.9103270388E+00, 9.7647314303E-01],
	[4.3230000000E+04, 4.1623342674E+01, 5.3059950065E+00, 2.3137844974E+01, 3.9106757485E+00, 9.7648317775E-01],
	[4.3235000000E+04, 4.1631835003E+01, 5.3060386802E+00, 2.3146596876E+01, 3.9110243700E+00, 9.7649320759E-01],
	[4.3240000000E+04, 4.1640328082E+01, 5.3060823493E+00, 2.3155351075E+01, 3.9113729033E+00, 9.7650323255E-01],
	[4.3245000000E+04, 4.1648821911E+01, 5.3061260136E+00, 2.3164107570E+01, 3.9117213484E+00, 9.7651325264E-01],
	[4.3250000000E+04, 4.1657316491E+01, 5.3061696733E+00, 2.3172866363E+01, 3.9120697054E+00, 9.7652326787E-01],
	[4.3255000000E+04, 4.1665811821E+01, 5.3062133283E+00, 2.3181627453E+01, 3.9124179742E+00, 9.7653327822E-01],
	[4.3260000000E+04, 4.1674307901E+01, 5.3062569786E+00, 2.3190390841E+01, 3.9127661549E+00, 9.7654328371E-01],
	[4.3265000000E+04, 4.1682804731E+01, 5.3063006242E+00, 2.3199156528E+01, 3.9131142476E+00, 9.7655328434E-01],
	[4.3270000000E+04, 4.1691302312E+01, 5.3063442651E+00, 2.3207924513E+01, 3.9134622522E+00, 9.7656328010E-01],
	[4.3275000000E+04, 4.1699800643E+01, 5.3063879014E+00, 2.3216694797E+01, 3.9138101687E+00, 9.7657327101E-01],
	[4.3280000000E+04, 4.1708299724E+01, 5.3064315329E+00, 2.3225467380E+01, 3.9141579973E+00, 9.7658325707E-01],
	[4.3285000000E+04, 4.1716799555E+01, 5.3064751598E+00, 2.3234242263E+01, 3.9145057378E+00, 9.7659323827E-01],
	[4.3290000000E+04, 4.1725300136E+01, 5.3065187820E+00, 2.3243019446E+01, 3.9148533904E+00, 9.7660321462E-01],
	[4.3295000000E+04, 4.1733801467E+01, 5.3065623995E+00, 2.3251798929E+01, 3.9152009550E+00, 9.7661318613E-01],
	[4.3300000000E+04, 4.1742303548E+01, 5.3066060124E+00, 2.3260580713E+01, 3.9155484317E+00, 9.7662315279E-01],
	[4.3305000000E+04, 4.1750806380E+01, 5.3066496205E+00, 2.3269364798E+01, 3.9158958205E+00, 9.7663311461E-01],
	[4.3310000000E+04, 4.1759309961E+01, 5.3066932240E+00, 2.3278151184E+01, 3.9162431214E+00, 9.7664307158E-01],
	[4.3315000000E+04, 4.1767814293E+01, 5.3067368228E+00, 2.3286939871E+01, 3.9165903344E+00, 9.7665302372E-01],
	[4.3320000000E+04, 4.1776319374E+01, 5.3067804170E+00, 2.3295730861E+01, 3.9169374596E+00, 9.7666297103E-01],
	[4.3325000000E+04, 4.1784825205E+01, 5.3068240064E+00, 2.3304524153E+01, 3.9172844970E+00, 9.7667291350E-01],
	[4.3330000000E+04, 4.1793331787E+01, 5.3068675912E+00, 2.3313319747E+01, 3.9176314466E+00, 9.7668285114E-01],
	[4.3335000000E+04, 4.1801839118E+01, 5.3069111713E+00, 2.3322117645E+01, 3.9179783085E+00, 9.7669278396E-01],
	[4.3340000000E+04, 4.1810347199E+01, 5.3069547468E+00, 2.3330917845E+01, 3.9183250826E+00, 9.7670271195E-01],
	[4.3345000000E+04, 4.1818856030E+01, 5.3069983176E+00, 2.3339720350E+01, 3.9186717690E+00, 9.7671263511E-01],
	[4.3350000000E+04, 4.1827365611E+01, 5.3070418837E+00, 2.3348525158E+01, 3.9190183676E+00, 9.7672255346E-01],
	[4.3355000000E+04, 4.1835875942E+01, 5.3070854451E+00, 2.3357332271E+01, 3.9193648786E+00, 9.7673246699E-01],
	[4.3360000000E+04, 4.1844387022E+01, 5.3071290019E+00, 2.3366141688E+01, 3.9197113020E+00, 9.7674237570E-01],
	[4.3365000000E+04, 4.1852898853E+01, 5.3071725540E+00, 2.3374953411E+01, 3.9200576377E+00, 9.7675227961E-01],
	[4.3370000000E+04, 4.1861411433E+01, 5.3072161015E+00, 2.3383767438E+01, 3.9204038858E+00, 9.7676217870E-01],
	[4.3375000000E+04, 4.1869924763E+01, 5.3072596443E+00, 2.3392583772E+01, 3.9207500463E+00, 9.7677207298E-01],
	[4.3380000000E+04, 4.1878438842E+01, 5.3073031824E+00, 2.3401402411E+01, 3.9210961193E+00, 9.7678196246E-01],
	[4.3385000000E+04, 4.1886953672E+01, 5.3073467158E+00, 2.3410223357E+01, 3.9214421047E+00, 9.7679184714E-01],
	[4.3390000000E+04, 4.1895469251E+01, 5.3073902446E+00, 2.3419046609E+01, 3.9217880026E+00, 9.7680172701E-01],
	[4.3395000000E+04, 4.1903985580E+01, 5.3074337688E+00, 2.3427872169E+01, 3.9221338130E+00, 9.7681160209E-01],
	[4.3400000000E+04, 4.1912502658E+01, 5.3074772883E+00, 2.3436700035E+01, 3.9224795359E+00, 9.7682147237E-01],
	[4.3405000000E+04, 4.1921020486E+01, 5.3075208031E+00, 2.3445530210E+01, 3.9228251714E+00, 9.7683133786E-01],
	[4.3410000000E+04, 4.1929539064E+01, 5.3075643133E+00, 2.3454362692E+01, 3.9231707194E+00, 9.7684119856E-01],
	[4.3415000000E+04, 4.1938058391E+01, 5.3076078188E+00, 2.3463197483E+01, 3.9235161800E+00, 9.7685105447E-01],
	[4.3420000000E+04, 4.1946578468E+01, 5.3076513197E+00, 2.3472034583E+01, 3.9238615533E+00, 9.7686090560E-01],
	[4.3425000000E+04, 4.1955099295E+01, 5.3076948159E+00, 2.3480873991E+01, 3.9242068392E+00, 9.7687075194E-01],
	[4.3430000000E+04, 4.1963620871E+01, 5.3077383075E+00, 2.3489715709E+01, 3.9245520377E+00, 9.7688059351E-01],
	[4.3435000000E+04, 4.1972143196E+01, 5.3077817944E+00, 2.3498559737E+01, 3.9248971490E+00, 9.7689043029E-01],
	[4.3440000000E+04, 4.1980666271E+01, 5.3078252766E+00, 2.3507406074E+01, 3.9252421729E+00, 9.7690026230E-01],
	[4.3445000000E+04, 4.1989190096E+01, 5.3078687543E+00, 2.3516254722E+01, 3.9255871096E+00, 9.7691008954E-01],
	[4.3450000000E+04, 4.1997714670E+01, 5.3079122272E+00, 2.3525105681E+01, 3.9259319590E+00, 9.7691991201E-01],
	[4.3455000000E+04, 4.2006239993E+01, 5.3079556955E+00, 2.3533958951E+01, 3.9262767212E+00, 9.7692972971E-01],
	[4.3460000000E+04, 4.2014766066E+01, 5.3079991592E+00, 2.3542814532E+01, 3.9266213962E+00, 9.7693954264E-01],
	[4.3465000000E+04, 4.2023292888E+01, 5.3080426182E+00, 2.3551672425E+01, 3.9269659840E+00, 9.7694935081E-01],
	[4.3470000000E+04, 4.2031820460E+01, 5.3080860726E+00, 2.3560532630E+01, 3.9273104846E+00, 9.7695915422E-01],
	[4.3475000000E+04, 4.2040348781E+01, 5.3081295224E+00, 2.3569395148E+01, 3.9276548981E+00, 9.7696895287E-01],
	[4.3480000000E+04, 4.2048877851E+01, 5.3081729675E+00, 2.3578259978E+01, 3.9279992245E+00, 9.7697874677E-01],
	[4.3485000000E+04, 4.2057407670E+01, 5.3082164080E+00, 2.3587127121E+01, 3.9283434639E+00, 9.7698853591E-01],
	[4.3490000000E+04, 4.2065938239E+01, 5.3082598438E+00, 2.3595996578E+01, 3.9286876161E+00, 9.7699832030E-01],
	[4.3495000000E+04, 4.2074469558E+01, 5.3083032750E+00, 2.3604868348E+01, 3.9290316813E+00, 9.7700809995E-01],
	[4.3500000000E+04, 4.2083001625E+01, 5.3083467015E+00, 2.3613742432E+01, 3.9293756595E+00, 9.7701787485E-01],
	[4.3505000000E+04, 4.2091534442E+01, 5.3083901234E+00, 2.3622618831E+01, 3.9297195506E+00, 9.7702764500E-01],
	[4.3510000000E+04, 4.2100068008E+01, 5.3084335407E+00, 2.3631497545E+01, 3.9300633548E+00, 9.7703741041E-01],
	[4.3515000000E+04, 4.2108602323E+01, 5.3084769534E+00, 2.3640378574E+01, 3.9304070721E+00, 9.7704717109E-01],
	[4.3520000000E+04, 4.2117137387E+01, 5.3085203614E+00, 2.3649261918E+01, 3.9307507024E+00, 9.7705692703E-01],
	[4.3525000000E+04, 4.2125673200E+01, 5.3085637648E+00, 2.3658147578E+01, 3.9310942458E+00, 9.7706667824E-01],
	[4.3530000000E+04, 4.2134209763E+01, 5.3086071635E+00, 2.3667035554E+01, 3.9314377023E+00, 9.7707642471E-01],
	[4.3535000000E+04, 4.2142747074E+01, 5.3086505576E+00, 2.3675925847E+01, 3.9317810719E+00, 9.7708616646E-01],
	[4.3540000000E+04, 4.2151285135E+01, 5.3086939471E+00, 2.3684818456E+01, 3.9321243547E+00, 9.7709590348E-01],
	[4.3545000000E+04, 4.2159823945E+01, 5.3087373320E+00, 2.3693713382E+01, 3.9324675507E+00, 9.7710563578E-01],
	[4.3550000000E+04, 4.2168363504E+01, 5.3087807122E+00, 2.3702610626E+01, 3.9328106599E+00, 9.7711536336E-01],
	[4.3555000000E+04, 4.2176903812E+01, 5.3088240878E+00, 2.3711510188E+01, 3.9331536823E+00, 9.7712508622E-01],
	[4.3560000000E+04, 4.2185444869E+01, 5.3088674588E+00, 2.3720412068E+01, 3.9334966179E+00, 9.7713480436E-01],
	[4.3565000000E+04, 4.2193986675E+01, 5.3089108252E+00, 2.3729316266E+01, 3.9338394669E+00, 9.7714451779E-01],
	[4.3570000000E+04, 4.2202529229E+01, 5.3089541869E+00, 2.3738222783E+01, 3.9341822291E+00, 9.7715422651E-01],
	[4.3575000000E+04, 4.2211072533E+01, 5.3089975440E+00, 2.3747131619E+01, 3.9345249046E+00, 9.7716393052E-01],
	[4.3580000000E+04, 4.2219616586E+01, 5.3090408965E+00, 2.3756042775E+01, 3.9348674935E+00, 9.7717362982E-01],
	[4.3585000000E+04, 4.2228161388E+01, 5.3090842444E+00, 2.3764956251E+01, 3.9352099957E+00, 9.7718332442E-01],
	[4.3590000000E+04, 4.2236706938E+01, 5.3091275877E+00, 2.3773872046E+01, 3.9355524113E+00, 9.7719301432E-01],
	[4.3595000000E+04, 4.2245253238E+01, 5.3091709263E+00, 2.3782790163E+01, 3.9358947403E+00, 9.7720269951E-01],
	[4.3600000000E+04, 4.2253800286E+01, 5.3092142603E+00, 2.3791710600E+01, 3.9362369828E+00, 9.7721238002E-01],
	[4.3605000000E+04, 4.2262348083E+01, 5.3092575897E+00, 2.3800633358E+01, 3.9365791386E+00, 9.7722205582E-01],
	[4.3610000000E+04, 4.2270896629E+01, 5.3093009145E+00, 2.3809558437E+01, 3.9369212080E+00, 9.7723172694E-01],
	[4.3615000000E+04, 4.2279445924E+01, 5.3093442347E+00, 2.3818485839E+01, 3.9372631909E+00, 9.7724139337E-01],
	[4.3620000000E+04, 4.2287995967E+01, 5.3093875503E+00, 2.3827415563E+01, 3.9376050872E+00, 9.7725105511E-01],
	[4.3625000000E+04, 4.2296546759E+01, 5.3094308612E+00, 2.3836347609E+01, 3.9379468971E+00, 9.7726071217E-01],
	[4.3630000000E+04, 4.2305098300E+01, 5.3094741676E+00, 2.3845281978E+01, 3.9382886206E+00, 9.7727036454E-01],
	[4.3635000000E+04, 4.2313650590E+01, 5.3095174693E+00, 2.3854218670E+01, 3.9386302577E+00, 9.7728001224E-01],
	[4.3640000000E+04, 4.2322203628E+01, 5.3095607664E+00, 2.3863157686E+01, 3.9389718083E+00, 9.7728965526E-01],
	[4.3645000000E+04, 4.2330757415E+01, 5.3096040590E+00, 2.3872099026E+01, 3.9393132726E+00, 9.7729929360E-01],
	[4.3650000000E+04, 4.2339311951E+01, 5.3096473469E+00, 2.3881042690E+01, 3.9396546506E+00, 9.7730892728E-01],
	[4.3655000000E+04, 4.2347867235E+01, 5.3096906302E+00, 2.3889988678E+01, 3.9399959422E+00, 9.7731855628E-01],
	[4.3660000000E+04, 4.2356423268E+01, 5.3097339089E+00, 2.3898936991E+01, 3.9403371475E+00, 9.7732818062E-01],
	[4.3665000000E+04, 4.2364980049E+01, 5.3097771830E+00, 2.3907887630E+01, 3.9406782666E+00, 9.7733780029E-01],
	[4.3670000000E+04, 4.2373537580E+01, 5.3098204525E+00, 2.3916840594E+01, 3.9410192993E+00, 9.7734741530E-01],
	[4.3675000000E+04, 4.2382095858E+01, 5.3098637174E+00, 2.3925795884E+01, 3.9413602459E+00, 9.7735702565E-01],
	[4.3680000000E+04, 4.2390654885E+01, 5.3099069777E+00, 2.3934753500E+01, 3.9417011062E+00, 9.7736663134E-01],
	[4.3685000000E+04, 4.2399214661E+01, 5.3099502334E+00, 2.3943713443E+01, 3.9420418803E+00, 9.7737623238E-01],
	[4.3690000000E+04, 4.2407775185E+01, 5.3099934845E+00, 2.3952675713E+01, 3.9423825683E+00, 9.7738582877E-01],
	[4.3695000000E+04, 4.2416336457E+01, 5.3100367310E+00, 2.3961640309E+01, 3.9427231701E+00, 9.7739542050E-01],
	[4.3700000000E+04, 4.2424898478E+01, 5.3100799729E+00, 2.3970607234E+01, 3.9430636858E+00, 9.7740500759E-01],
	[4.3705000000E+04, 4.2433461248E+01, 5.3101232102E+00, 2.3979576486E+01, 3.9434041155E+00, 9.7741459004E-01],
	[4.3710000000E+04, 4.2442024766E+01, 5.3101664429E+00, 2.3988548067E+01, 3.9437444590E+00, 9.7742416784E-01],
	[4.3715000000E+04, 4.2450589032E+01, 5.3102096710E+00, 2.3997521976E+01, 3.9440847164E+00, 9.7743374100E-01],
	[4.3720000000E+04, 4.2459154047E+01, 5.3102528946E+00, 2.4006498214E+01, 3.9444248879E+00, 9.7744330952E-01],
	[4.3725000000E+04, 4.2467719809E+01, 5.3102961135E+00, 2.4015476782E+01, 3.9447649733E+00, 9.7745287341E-01],
	[4.3730000000E+04, 4.2476286321E+01, 5.3103393279E+00, 2.4024457679E+01, 3.9451049727E+00, 9.7746243267E-01],
	[4.3735000000E+04, 4.2484853580E+01, 5.3103825376E+00, 2.4033440906E+01, 3.9454448862E+00, 9.7747198729E-01],
	[4.3740000000E+04, 4.2493421588E+01, 5.3104257428E+00, 2.4042426463E+01, 3.9457847137E+00, 9.7748153729E-01],
	[4.3745000000E+04, 4.2501990344E+01, 5.3104689434E+00, 2.4051414351E+01, 3.9461244553E+00, 9.7749108266E-01],
	[4.3750000000E+04, 4.2510559849E+01, 5.3105121394E+00, 2.4060404570E+01, 3.9464641110E+00, 9.7750062341E-01],
	[4.3755000000E+04, 4.2519130101E+01, 5.3105553308E+00, 2.4069397120E+01, 3.9468036809E+00, 9.7751015954E-01],
	[4.3760000000E+04, 4.2527701102E+01, 5.3105985176E+00, 2.4078392002E+01, 3.9471431648E+00, 9.7751969105E-01],
	[4.3765000000E+04, 4.2536272851E+01, 5.3106416999E+00, 2.4087389215E+01, 3.9474825630E+00, 9.7752921795E-01],
	[4.3770000000E+04, 4.2544845348E+01, 5.3106848775E+00, 2.4096388761E+01, 3.9478218753E+00, 9.7753874023E-01],
	[4.3775000000E+04, 4.2553418593E+01, 5.3107280506E+00, 2.4105390640E+01, 3.9481611019E+00, 9.7754825790E-01],
	[4.3780000000E+04, 4.2561992587E+01, 5.3107712191E+00, 2.4114394852E+01, 3.9485002426E+00, 9.7755777096E-01],
	[4.3785000000E+04, 4.2570567328E+01, 5.3108143831E+00, 2.4123401396E+01, 3.9488392977E+00, 9.7756727942E-01],
	[4.3790000000E+04, 4.2579142818E+01, 5.3108575424E+00, 2.4132410275E+01, 3.9491782670E+00, 9.7757678327E-01],
	[4.3795000000E+04, 4.2587719055E+01, 5.3109006972E+00, 2.4141421488E+01, 3.9495171506E+00, 9.7758628252E-01],
	[4.3800000000E+04, 4.2596296041E+01, 5.3109438474E+00, 2.4150435035E+01, 3.9498559486E+00, 9.7759577717E-01],
	[4.3805000000E+04, 4.2604873775E+01, 5.3109869930E+00, 2.4159450916E+01, 3.9501946609E+00, 9.7760526723E-01],
	[4.3810000000E+04, 4.2613452256E+01, 5.3110301340E+00, 2.4168469133E+01, 3.9505332875E+00, 9.7761475269E-01],
	[4.3815000000E+04, 4.2622031486E+01, 5.3110732705E+00, 2.4177489685E+01, 3.9508718286E+00, 9.7762423357E-01],
	[4.3820000000E+04, 4.2630611463E+01, 5.3111164024E+00, 2.4186512572E+01, 3.9512102841E+00, 9.7763370985E-01],
	[4.3825000000E+04, 4.2639192189E+01, 5.3111595297E+00, 2.4195537796E+01, 3.9515486540E+00, 9.7764318155E-01],
	[4.3830000000E+04, 4.2647773663E+01, 5.3112026525E+00, 2.4204565356E+01, 3.9518869384E+00, 9.7765264866E-01],
	[4.3835000000E+04, 4.2656355884E+01, 5.3112457707E+00, 2.4213595252E+01, 3.9522251372E+00, 9.7766211119E-01],
	[4.3840000000E+04, 4.2664938853E+01, 5.3112888843E+00, 2.4222627486E+01, 3.9525632506E+00, 9.7767156914E-01],
	[4.3845000000E+04, 4.2673522570E+01, 5.3113319934E+00, 2.4231662057E+01, 3.9529012785E+00, 9.7768102251E-01],
	[4.3850000000E+04, 4.2682107035E+01, 5.3113750979E+00, 2.4240698966E+01, 3.9532392209E+00, 9.7769047131E-01],
	[4.3855000000E+04, 4.2690692248E+01, 5.3114181978E+00, 2.4249738213E+01, 3.9535770779E+00, 9.7769991554E-01],
	[4.3860000000E+04, 4.2699278209E+01, 5.3114612931E+00, 2.4258779798E+01, 3.9539148495E+00, 9.7770935520E-01],
	[4.3865000000E+04, 4.2707864917E+01, 5.3115043839E+00, 2.4267823722E+01, 3.9542525357E+00, 9.7771879029E-01],
	[4.3870000000E+04, 4.2716452373E+01, 5.3115474702E+00, 2.4276869985E+01, 3.9545901366E+00, 9.7772822082E-01],
	[4.3875000000E+04, 4.2725040577E+01, 5.3115905518E+00, 2.4285918587E+01, 3.9549276521E+00, 9.7773764678E-01],
	[4.3880000000E+04, 4.2733637620E+01, 5.3116345047E+00, 2.4294969529E+01, 3.9552656372E+00, 9.7774706819E-01],
	[4.3885000000E+04, 4.2742244955E+01, 5.3116794855E+00, 2.4304022811E+01, 3.9556041915E+00, 9.7775648504E-01],
	[4.3890000000E+04, 4.2750853042E+01, 5.3117244615E+00, 2.4313078434E+01, 3.9559426607E+00, 9.7776589733E-01],
	[4.3895000000E+04, 4.2759461882E+01, 5.3117694328E+00, 2.4322136397E+01, 3.9562810448E+00, 9.7777530507E-01],
	[4.3900000000E+04, 4.2768071475E+01, 5.3118143994E+00, 2.4331196702E+01, 3.9566193440E+00, 9.7778470826E-01],
	[4.3905000000E+04, 4.2776681821E+01, 5.3118593612E+00, 2.4340259348E+01, 3.9569575581E+00, 9.7779410690E-01],
	[4.3910000000E+04, 4.2785292919E+01, 5.3119043182E+00, 2.4349324335E+01, 3.9572956872E+00, 9.7780350099E-01],
	[4.3915000000E+04, 4.2793904770E+01, 5.3119492706E+00, 2.4358391665E+01, 3.9576337313E+00, 9.7781289055E-01],
	[4.3920000000E+04, 4.2802517374E+01, 5.3119942182E+00, 2.4367461337E+01, 3.9579716905E+00, 9.7782227556E-01],
	[4.3925000000E+04, 4.2811130730E+01, 5.3120391610E+00, 2.4376533352E+01, 3.9583095648E+00, 9.7783165603E-01],
	[4.3930000000E+04, 4.2819744839E+01, 5.3120840991E+00, 2.4385607710E+01, 3.9586473542E+00, 9.7784103197E-01],
	[4.3935000000E+04, 4.2828359701E+01, 5.3121290325E+00, 2.4394684411E+01, 3.9589850588E+00, 9.7785040338E-01],
	[4.3940000000E+04, 4.2836975315E+01, 5.3121739612E+00, 2.4403763456E+01, 3.9593226784E+00, 9.7785977025E-01],
	[4.3945000000E+04, 4.2845591681E+01, 5.3122188851E+00, 2.4412844846E+01, 3.9596602133E+00, 9.7786913260E-01],
	[4.3950000000E+04, 4.2854208800E+01, 5.3122638043E+00, 2.4421928580E+01, 3.9599976633E+00, 9.7787849042E-01],
	[4.3955000000E+04, 4.2862826672E+01, 5.3123087187E+00, 2.4431014658E+01, 3.9603350286E+00, 9.7788784372E-01],
	[4.3960000000E+04, 4.2871445296E+01, 5.3123536285E+00, 2.4440103082E+01, 3.9606723091E+00, 9.7789719249E-01],
	[4.3965000000E+04, 4.2880064673E+01, 5.3123985335E+00, 2.4449193851E+01, 3.9610095048E+00, 9.7790653675E-01],
	[4.3970000000E+04, 4.2888684802E+01, 5.3124434337E+00, 2.4458286966E+01, 3.9613466158E+00, 9.7791587649E-01],
	[4.3975000000E+04, 4.2897305683E+01, 5.3124883293E+00, 2.4467382427E+01, 3.9616836422E+00, 9.7792521171E-01],
	[4.3980000000E+04, 4.2905927317E+01, 5.3125332201E+00, 2.4476480235E+01, 3.9620205838E+00, 9.7793454243E-01],
	[4.3985000000E+04, 4.2914549703E+01, 5.3125781062E+00, 2.4485580390E+01, 3.9623574408E+00, 9.7794386863E-01],
	[4.3990000000E+04, 4.2923172842E+01, 5.3126229876E+00, 2.4494682891E+01, 3.9626942132E+00, 9.7795319033E-01],
	[4.3995000000E+04, 4.2931796733E+01, 5.3126678642E+00, 2.4503787740E+01, 3.9630309010E+00, 9.7796250752E-01],
	[4.4000000000E+04, 4.2940421376E+01, 5.3127127362E+00, 2.4512894938E+01, 3.9633675042E+00, 9.7797182021E-01],
	[4.4005000000E+04, 4.2949046772E+01, 5.3127576034E+00, 2.4522004483E+01, 3.9637040228E+00, 9.7798112841E-01],
	[4.4010000000E+04, 4.2957672919E+01, 5.3128024659E+00, 2.4531116376E+01, 3.9640404569E+00, 9.7799043210E-01],
	[4.4015000000E+04, 4.2966299820E+01, 5.3128473236E+00, 2.4540230619E+01, 3.9643768064E+00, 9.7799973130E-01],
	[4.4020000000E+04, 4.2974927472E+01, 5.3128921767E+00, 2.4549347211E+01, 3.9647130715E+00, 9.7800902601E-01],
	[4.4025000000E+04, 4.2983555877E+01, 5.3129370250E+00, 2.4558466152E+01, 3.9650492521E+00, 9.7801831622E-01],
	[4.4030000000E+04, 4.2992185033E+01, 5.3129818687E+00, 2.4567587443E+01, 3.9653853482E+00, 9.7802760195E-01],
	[4.4035000000E+04, 4.3000814942E+01, 5.3130267076E+00, 2.4576711085E+01, 3.9657213599E+00, 9.7803688320E-01],
	[4.4040000000E+04, 4.3009445604E+01, 5.3130715418E+00, 2.4585837077E+01, 3.9660572872E+00, 9.7804615996E-01],
	[4.4045000000E+04, 4.3018077017E+01, 5.3131163713E+00, 2.4594965419E+01, 3.9663931301E+00, 9.7805543224E-01],
	[4.4050000000E+04, 4.3026709182E+01, 5.3131611961E+00, 2.4604096114E+01, 3.9667288887E+00, 9.7806470004E-01],
	[4.4055000000E+04, 4.3035342100E+01, 5.3132060161E+00, 2.4613229159E+01, 3.9670645629E+00, 9.7807396337E-01],
	[4.4060000000E+04, 4.3043975769E+01, 5.3132508315E+00, 2.4622364557E+01, 3.9674001528E+00, 9.7808322222E-01],
	[4.4065000000E+04, 4.3052610191E+01, 5.3132956421E+00, 2.4631502306E+01, 3.9677356584E+00, 9.7809247661E-01],
	[4.4070000000E+04, 4.3061245365E+01, 5.3133404481E+00, 2.4640642409E+01, 3.9680710797E+00, 9.7810172652E-01],
	[4.4075000000E+04, 4.3069881291E+01, 5.3133852493E+00, 2.4649784864E+01, 3.9684064168E+00, 9.7811097197E-01],
	[4.4080000000E+04, 4.3078517969E+01, 5.3134300459E+00, 2.4658929672E+01, 3.9687416696E+00, 9.7812021295E-01],
	[4.4085000000E+04, 4.3087155398E+01, 5.3134748377E+00, 2.4668076835E+01, 3.9690768382E+00, 9.7812944948E-01],
	[4.4090000000E+04, 4.3095793580E+01, 5.3135196248E+00, 2.4677226351E+01, 3.9694119227E+00, 9.7813868154E-01],
	[4.4095000000E+04, 4.3104432514E+01, 5.3135644073E+00, 2.4686378221E+01, 3.9697469229E+00, 9.7814790915E-01],
	[4.4100000000E+04, 4.3113072199E+01, 5.3136091850E+00, 2.4695532446E+01, 3.9700818391E+00, 9.7815713230E-01],
	[4.4105000000E+04, 4.3121712637E+01, 5.3136539580E+00, 2.4704689026E+01, 3.9704166711E+00, 9.7816635101E-01],
	[4.4110000000E+04, 4.3130353826E+01, 5.3136987264E+00, 2.4713847961E+01, 3.9707514190E+00, 9.7817556526E-01],
	[4.4115000000E+04, 4.3138995768E+01, 5.3137434900E+00, 2.4723009251E+01, 3.9710860829E+00, 9.7818477506E-01],
	[4.4120000000E+04, 4.3147638461E+01, 5.3137882489E+00, 2.4732172898E+01, 3.9714206626E+00, 9.7819398042E-01],
	[4.4125000000E+04, 4.3156281906E+01, 5.3138330032E+00, 2.4741338901E+01, 3.9717551584E+00, 9.7820318134E-01],
	[4.4130000000E+04, 4.3164926103E+01, 5.3138777527E+00, 2.4750507261E+01, 3.9720895702E+00, 9.7821237782E-01],
	[4.4135000000E+04, 4.3173571051E+01, 5.3139224976E+00, 2.4759677977E+01, 3.9724238979E+00, 9.7822156986E-01],
	[4.4140000000E+04, 4.3182216752E+01, 5.3139672377E+00, 2.4768851051E+01, 3.9727581417E+00, 9.7823075747E-01],
	[4.4145000000E+04, 4.3190863204E+01, 5.3140119732E+00, 2.4778026483E+01, 3.9730923016E+00, 9.7823994064E-01],
	[4.4150000000E+04, 4.3199510408E+01, 5.3140567040E+00, 2.4787204272E+01, 3.9734263775E+00, 9.7824911938E-01],
	[4.4155000000E+04, 4.3208158363E+01, 5.3141014301E+00, 2.4796384420E+01, 3.9737603696E+00, 9.7825829370E-01],
	[4.4160000000E+04, 4.3216807070E+01, 5.3141461515E+00, 2.4805566927E+01, 3.9740942777E+00, 9.7826746359E-01],
	[4.4165000000E+04, 4.3225456529E+01, 5.3141908682E+00, 2.4814751792E+01, 3.9744281020E+00, 9.7827662905E-01],
	[4.4170000000E+04, 4.3234106740E+01, 5.3142355803E+00, 2.4823939017E+01, 3.9747618425E+00, 9.7828579010E-01],
	[4.4175000000E+04, 4.3242757702E+01, 5.3142802876E+00, 2.4833128602E+01, 3.9750954992E+00, 9.7829494672E-01],
	[4.4180000000E+04, 4.3251409416E+01, 5.3143249903E+00, 2.4842320546E+01, 3.9754290720E+00, 9.7830409893E-01],
	[4.4185000000E+04, 4.3260061881E+01, 5.3143696883E+00, 2.4851514851E+01, 3.9757625612E+00, 9.7831324673E-01],
	[4.4190000000E+04, 4.3268715098E+01, 5.3144143816E+00, 2.4860711517E+01, 3.9760959665E+00, 9.7832239011E-01],
	[4.4195000000E+04, 4.3277369067E+01, 5.3144590702E+00, 2.4869910544E+01, 3.9764292882E+00, 9.7833152909E-01],
	[4.4200000000E+04, 4.3286023787E+01, 5.3145037541E+00, 2.4879111932E+01, 3.9767625261E+00, 9.7834066366E-01],
	[4.4205000000E+04, 4.3294679258E+01, 5.3145484334E+00, 2.4888315681E+01, 3.9770956804E+00, 9.7834979382E-01],
	[4.4210000000E+04, 4.3303335482E+01, 5.3145931080E+00, 2.4897521793E+01, 3.9774287510E+00, 9.7835891959E-01],
	[4.4215000000E+04, 4.3311992456E+01, 5.3146377779E+00, 2.4906730267E+01, 3.9777617380E+00, 9.7836804095E-01],
	[4.4220000000E+04, 4.3320650182E+01, 5.3146824431E+00, 2.4915941104E+01, 3.9780946414E+00, 9.7837715792E-01],
	[4.4225000000E+04, 4.3329308660E+01, 5.3147271037E+00, 2.4925154304E+01, 3.9784274612E+00, 9.7838627049E-01],
	[4.4230000000E+04, 4.3337967888E+01, 5.3147717595E+00, 2.4934369868E+01, 3.9787601974E+00, 9.7839537867E-01],
	[4.4235000000E+04, 4.3346627869E+01, 5.3148164107E+00, 2.4943587795E+01, 3.9790928501E+00, 9.7840448246E-01],
	[4.4240000000E+04, 4.3355288600E+01, 5.3148610573E+00, 2.4952808086E+01, 3.9794254192E+00, 9.7841358186E-01],
	[4.4245000000E+04, 4.3363950083E+01, 5.3149056991E+00, 2.4962030742E+01, 3.9797579049E+00, 9.7842267687E-01],
	[4.4250000000E+04, 4.3372612318E+01, 5.3149503363E+00, 2.4971255762E+01, 3.9800903071E+00, 9.7843176751E-01],
	[4.4255000000E+04, 4.3381275303E+01, 5.3149949689E+00, 2.4980483148E+01, 3.9804226258E+00, 9.7844085376E-01],
	[4.4260000000E+04, 4.3389939040E+01, 5.3150395967E+00, 2.4989712899E+01, 3.9807548611E+00, 9.7844993563E-01],
	[4.4265000000E+04, 4.3398603528E+01, 5.3150842199E+00, 2.4998945015E+01, 3.9810870129E+00, 9.7845901313E-01],
	[4.4270000000E+04, 4.3407268768E+01, 5.3151288385E+00, 2.5008179498E+01, 3.9814190814E+00, 9.7846808625E-01],
	[4.4275000000E+04, 4.3415934759E+01, 5.3151734523E+00, 2.5017416347E+01, 3.9817510665E+00, 9.7847715501E-01],
	[4.4280000000E+04, 4.3424601501E+01, 5.3152180615E+00, 2.5026655563E+01, 3.9820829683E+00, 9.7848621939E-01],
	[4.4285000000E+04, 4.3433268994E+01, 5.3152626661E+00, 2.5035897147E+01, 3.9824147868E+00, 9.7849527941E-01],
	[4.4290000000E+04, 4.3441937238E+01, 5.3153072659E+00, 2.5045141097E+01, 3.9827465219E+00, 9.7850433506E-01],
	[4.4295000000E+04, 4.3450606233E+01, 5.3153518611E+00, 2.5054387416E+01, 3.9830781738E+00, 9.7851338635E-01],
	[4.4300000000E+04, 4.3459275980E+01, 5.3153964517E+00, 2.5063636102E+01, 3.9834097424E+00, 9.7852243329E-01],
	[4.4305000000E+04, 4.3467946478E+01, 5.3154410376E+00, 2.5072887157E+01, 3.9837412278E+00, 9.7853147586E-01],
	[4.4310000000E+04, 4.3476617727E+01, 5.3154856188E+00, 2.5082140581E+01, 3.9840726299E+00, 9.7854051408E-01],
	[4.4315000000E+04, 4.3485289726E+01, 5.3155301954E+00, 2.5091396374E+01, 3.9844039489E+00, 9.7854954795E-01],
	[4.4320000000E+04, 4.3493962477E+01, 5.3155747674E+00, 2.5100654537E+01, 3.9847351847E+00, 9.7855857747E-01],
	[4.4325000000E+04, 4.3502635979E+01, 5.3156193346E+00, 2.5109915069E+01, 3.9850663373E+00, 9.7856760264E-01],
	[4.4330000000E+04, 4.3511310232E+01, 5.3156638973E+00, 2.5119177972E+01, 3.9853974069E+00, 9.7857662346E-01],
	[4.4335000000E+04, 4.3519985237E+01, 5.3157084552E+00, 2.5128443245E+01, 3.9857283933E+00, 9.7858563994E-01],
	[4.4340000000E+04, 4.3528660992E+01, 5.3157530085E+00, 2.5137710889E+01, 3.9860592966E+00, 9.7859465209E-01],
	[4.4345000000E+04, 4.3537337498E+01, 5.3157975572E+00, 2.5146980904E+01, 3.9863901169E+00, 9.7860365989E-01],
	[4.4350000000E+04, 4.3546014754E+01, 5.3158421012E+00, 2.5156253291E+01, 3.9867208542E+00, 9.7861266335E-01],
	[4.4355000000E+04, 4.3554692762E+01, 5.3158866406E+00, 2.5165528049E+01, 3.9870515084E+00, 9.7862166249E-01],
	[4.4360000000E+04, 4.3563371521E+01, 5.3159311753E+00, 2.5174805180E+01, 3.9873820796E+00, 9.7863065729E-01],
	[4.4365000000E+04, 4.3572051031E+01, 5.3159757054E+00, 2.5184084683E+01, 3.9877125679E+00, 9.7863964776E-01],
	[4.4370000000E+04, 4.3580731291E+01, 5.3160202308E+00, 2.5193366559E+01, 3.9880429732E+00, 9.7864863391E-01],
	[4.4375000000E+04, 4.3589412302E+01, 5.3160647516E+00, 2.5202650809E+01, 3.9883732956E+00, 9.7865761573E-01],
	[4.4380000000E+04, 4.3598094065E+01, 5.3161092677E+00, 2.5211937432E+01, 3.9887035351E+00, 9.7866659323E-01],
	[4.4385000000E+04, 4.3606776578E+01, 5.3161537792E+00, 2.5221226429E+01, 3.9890336917E+00, 9.7867556641E-01],
	[4.4390000000E+04, 4.3615459841E+01, 5.3161982861E+00, 2.5230517800E+01, 3.9893637655E+00, 9.7868453527E-01],
	[4.4395000000E+04, 4.3624143856E+01, 5.3162427883E+00, 2.5239811545E+01, 3.9896937564E+00, 9.7869349982E-01],
	[4.4400000000E+04, 4.3632828621E+01, 5.3162872859E+00, 2.5249107666E+01, 3.9900236645E+00, 9.7870246006E-01],
	[4.4405000000E+04, 4.3641514137E+01, 5.3163317788E+00, 2.5258406162E+01, 3.9903534898E+00, 9.7871141598E-01],
	[4.4410000000E+04, 4.3650200404E+01, 5.3163762671E+00, 2.5267707033E+01, 3.9906832323E+00, 9.7872036760E-01],
	[4.4415000000E+04, 4.3658887421E+01, 5.3164207508E+00, 2.5277010281E+01, 3.9910128921E+00, 9.7872931491E-01],
	[4.4420000000E+04, 4.3667575189E+01, 5.3164652298E+00, 2.5286315904E+01, 3.9913424691E+00, 9.7873825792E-01],
	[4.4425000000E+04, 4.3676263708E+01, 5.3165097042E+00, 2.5295623905E+01, 3.9916719635E+00, 9.7874719663E-01],
	[4.4430000000E+04, 4.3684952977E+01, 5.3165541740E+00, 2.5304934282E+01, 3.9920013751E+00, 9.7875613104E-01],
	[4.4435000000E+04, 4.3693642997E+01, 5.3165986391E+00, 2.5314247036E+01, 3.9923307041E+00, 9.7876506115E-01],
	[4.4440000000E+04, 4.3702333768E+01, 5.3166430996E+00, 2.5323562169E+01, 3.9926599505E+00, 9.7877398697E-01],
	[4.4445000000E+04, 4.3711025289E+01, 5.3166875555E+00, 2.5332879679E+01, 3.9929891142E+00, 9.7878290850E-01],
	[4.4450000000E+04, 4.3719717560E+01, 5.3167320067E+00, 2.5342199567E+01, 3.9933181953E+00, 9.7879182573E-01],
	[4.4455000000E+04, 4.3728410583E+01, 5.3167764533E+00, 2.5351521834E+01, 3.9936471939E+00, 9.7880073868E-01],
	[4.4460000000E+04, 4.3737104355E+01, 5.3168208953E+00, 2.5360846480E+01, 3.9939761099E+00, 9.7880964735E-01],
	[4.4465000000E+04, 4.3745798878E+01, 5.3168653327E+00, 2.5370173506E+01, 3.9943049434E+00, 9.7881855173E-01],
	[4.4470000000E+04, 4.3754494152E+01, 5.3169097654E+00, 2.5379502911E+01, 3.9946336943E+00, 9.7882745184E-01],
	[4.4475000000E+04, 4.3763190176E+01, 5.3169541935E+00, 2.5388834696E+01, 3.9949623628E+00, 9.7883634766E-01],
	[4.4480000000E+04, 4.3771886951E+01, 5.3169986170E+00, 2.5398168861E+01, 3.9952909489E+00, 9.7884523922E-01],
	[4.4485000000E+04, 4.3780584476E+01, 5.3170430359E+00, 2.5407505407E+01, 3.9956194524E+00, 9.7885412649E-01],
	[4.4490000000E+04, 4.3789282751E+01, 5.3170874501E+00, 2.5416844334E+01, 3.9959478736E+00, 9.7886300950E-01],
	[4.4495000000E+04, 4.3797981777E+01, 5.3171318597E+00, 2.5426185643E+01, 3.9962762123E+00, 9.7887188824E-01],
	[4.4500000000E+04, 4.3806681553E+01, 5.3171762647E+00, 2.5435529333E+01, 3.9966044687E+00, 9.7888076271E-01],
	[4.4505000000E+04, 4.3815382079E+01, 5.3172206651E+00, 2.5444875405E+01, 3.9969326427E+00, 9.7888963292E-01],
	[4.4510000000E+04, 4.3824083356E+01, 5.3172650609E+00, 2.5454223860E+01, 3.9972607344E+00, 9.7889849887E-01],
	[4.4515000000E+04, 4.3832785383E+01, 5.3173094520E+00, 2.5463574697E+01, 3.9975887438E+00, 9.7890736056E-01],
	[4.4520000000E+04, 4.3841488160E+01, 5.3173538386E+00, 2.5472927918E+01, 3.9979166709E+00, 9.7891621799E-01],
	[4.4525000000E+04, 4.3850191687E+01, 5.3173982205E+00, 2.5482283521E+01, 3.9982445157E+00, 9.7892507116E-01],
	[4.4530000000E+04, 4.3858895965E+01, 5.3174425978E+00, 2.5491641509E+01, 3.9985722783E+00, 9.7893392009E-01],
	[4.4535000000E+04, 4.3867600993E+01, 5.3174869705E+00, 2.5501001880E+01, 3.9988999587E+00, 9.7894276476E-01],
	[4.4540000000E+04, 4.3876306771E+01, 5.3175313386E+00, 2.5510364636E+01, 3.9992275568E+00, 9.7895160519E-01],
	[4.4545000000E+04, 4.3885013300E+01, 5.3175757021E+00, 2.5519729777E+01, 3.9995550728E+00, 9.7896044137E-01],
	[4.4550000000E+04, 4.3893720578E+01, 5.3176200609E+00, 2.5529097303E+01, 3.9998825066E+00, 9.7896927331E-01],
	[4.4555000000E+04, 4.3902428607E+01, 5.3176644152E+00, 2.5538467214E+01, 4.0002098583E+00, 9.7897810101E-01],
	[4.4560000000E+04, 4.3911137386E+01, 5.3177087648E+00, 2.5547839511E+01, 4.0005371279E+00, 9.7898692447E-01],
	[4.4565000000E+04, 4.3919846914E+01, 5.3177531099E+00, 2.5557214194E+01, 4.0008643154E+00, 9.7899574370E-01],
	[4.4570000000E+04, 4.3928557193E+01, 5.3177974503E+00, 2.5566591264E+01, 4.0011914208E+00, 9.7900455869E-01],
	[4.4575000000E+04, 4.3937268222E+01, 5.3178417861E+00, 2.5575970720E+01, 4.0015184441E+00, 9.7901336944E-01],
	[4.4580000000E+04, 4.3945980001E+01, 5.3178861174E+00, 2.5585352563E+01, 4.0018453855E+00, 9.7902217597E-01],
	[4.4585000000E+04, 4.3954695767E+01, 5.3179307891E+00, 2.5594736794E+01, 4.0021724671E+00, 9.7903097828E-01],
	[4.4590000000E+04, 4.3963426577E+01, 5.3179769801E+00, 2.5604123413E+01, 4.0025004485E+00, 9.7903977636E-01],
	[4.4595000000E+04, 4.3972158143E+01, 5.3180231663E+00, 2.5613512420E+01, 4.0028283480E+00, 9.7904857021E-01],
	[4.4600000000E+04, 4.3980890463E+01, 5.3180693477E+00, 2.5622903815E+01, 4.0031561659E+00, 9.7905735985E-01],
	[4.4605000000E+04, 4.3989623538E+01, 5.3181155243E+00, 2.5632297600E+01, 4.0034839020E+00, 9.7906614527E-01],
	[4.4610000000E+04, 4.3998357368E+01, 5.3181616962E+00, 2.5641693773E+01, 4.0038115564E+00, 9.7907492647E-01],
	[4.4615000000E+04, 4.4007091953E+01, 5.3182078633E+00, 2.5651092336E+01, 4.0041391291E+00, 9.7908370346E-01],
	[4.4620000000E+04, 4.4015827292E+01, 5.3182540256E+00, 2.5660493288E+01, 4.0044666201E+00, 9.7909247624E-01],
	[4.4625000000E+04, 4.4024563387E+01, 5.3183001831E+00, 2.5669896631E+01, 4.0047940295E+00, 9.7910124481E-01],
	[4.4630000000E+04, 4.4033300236E+01, 5.3183463359E+00, 2.5679302365E+01, 4.0051213572E+00, 9.7911000918E-01],
	[4.4635000000E+04, 4.4042037841E+01, 5.3183924839E+00, 2.5688710489E+01, 4.0054486034E+00, 9.7911876934E-01],
	[4.4640000000E+04, 4.4050776200E+01, 5.3184386271E+00, 2.5698121004E+01, 4.0057757679E+00, 9.7912752530E-01],
	[4.4645000000E+04, 4.4059515314E+01, 5.3184847656E+00, 2.5707533911E+01, 4.0061028510E+00, 9.7913627706E-01],
	[4.4650000000E+04, 4.4068255182E+01, 5.3185308993E+00, 2.5716949210E+01, 4.0064298524E+00, 9.7914502462E-01],
	[4.4655000000E+04, 4.4076995805E+01, 5.3185770282E+00, 2.5726366901E+01, 4.0067567724E+00, 9.7915376799E-01],
	[4.4660000000E+04, 4.4085737183E+01, 5.3186231524E+00, 2.5735786985E+01, 4.0070836109E+00, 9.7916250717E-01],
	[4.4665000000E+04, 4.4094479316E+01, 5.3186692718E+00, 2.5745209461E+01, 4.0074103679E+00, 9.7917124215E-01],
	[4.4670000000E+04, 4.4103222204E+01, 5.3187153865E+00, 2.5754634331E+01, 4.0077370434E+00, 9.7917997295E-01],
	[4.4675000000E+04, 4.4111965846E+01, 5.3187614963E+00, 2.5764061594E+01, 4.0080636375E+00, 9.7918869956E-01],
	[4.4680000000E+04, 4.4120710243E+01, 5.3188076015E+00, 2.5773491251E+01, 4.0083901502E+00, 9.7919742199E-01],
	[4.4685000000E+04, 4.4129455394E+01, 5.3188537018E+00, 2.5782923303E+01, 4.0087165816E+00, 9.7920614024E-01],
	[4.4690000000E+04, 4.4138201300E+01, 5.3188997974E+00, 2.5792357749E+01, 4.0090429315E+00, 9.7921485431E-01],
	[4.4695000000E+04, 4.4146947960E+01, 5.3189458883E+00, 2.5801794590E+01, 4.0093692001E+00, 9.7922356421E-01],
	[4.4700000000E+04, 4.4155695376E+01, 5.3189919743E+00, 2.5811233826E+01, 4.0096953874E+00, 9.7923226993E-01],
	[4.4705000000E+04, 4.4164443545E+01, 5.3190380557E+00, 2.5820675458E+01, 4.0100214934E+00, 9.7924097147E-01],
	[4.4710000000E+04, 4.4173192469E+01, 5.3190841322E+00, 2.5830119486E+01, 4.0103475182E+00, 9.7924966885E-01],
	[4.4715000000E+04, 4.4181942148E+01, 5.3191302041E+00, 2.5839565910E+01, 4.0106734616E+00, 9.7925836206E-01],
	[4.4720000000E+04, 4.4190692581E+01, 5.3191762711E+00, 2.5849014731E+01, 4.0109993239E+00, 9.7926705111E-01],
	[4.4725000000E+04, 4.4199443769E+01, 5.3192223335E+00, 2.5858465948E+01, 4.0113251049E+00, 9.7927573599E-01],
	[4.4730000000E+04, 4.4208195711E+01, 5.3192683910E+00, 2.5867919563E+01, 4.0116508047E+00, 9.7928441671E-01],
	[4.4735000000E+04, 4.4216948408E+01, 5.3193144439E+00, 2.5877375576E+01, 4.0119764234E+00, 9.7929309328E-01],
	[4.4740000000E+04, 4.4225701858E+01, 5.3193604919E+00, 2.5886833987E+01, 4.0123019609E+00, 9.7930176569E-01],
	[4.4745000000E+04, 4.4234456064E+01, 5.3194065352E+00, 2.5896294796E+01, 4.0126274173E+00, 9.7931043394E-01],
	[4.4750000000E+04, 4.4243211024E+01, 5.3194525738E+00, 2.5905758003E+01, 4.0129527926E+00, 9.7931909805E-01],
	[4.4755000000E+04, 4.4251966738E+01, 5.3194986077E+00, 2.5915223610E+01, 4.0132780868E+00, 9.7932775800E-01],
	[4.4760000000E+04, 4.4260723206E+01, 5.3195446367E+00, 2.5924691616E+01, 4.0136033000E+00, 9.7933641381E-01],
	[4.4765000000E+04, 4.4269480429E+01, 5.3195906611E+00, 2.5934162021E+01, 4.0139284321E+00, 9.7934506547E-01],
	[4.4770000000E+04, 4.4278238406E+01, 5.3196366807E+00, 2.5943634827E+01, 4.0142534832E+00, 9.7935371299E-01],
	[4.4775000000E+04, 4.4286997137E+01, 5.3196826956E+00, 2.5953110033E+01, 4.0145784533E+00, 9.7936235637E-01],
	[4.4780000000E+04, 4.4295756623E+01, 5.3197287057E+00, 2.5962587640E+01, 4.0149033424E+00, 9.7937099562E-01],
	[4.4785000000E+04, 4.4304516862E+01, 5.3197747111E+00, 2.5972067648E+01, 4.0152281506E+00, 9.7937963073E-01],
	[4.4790000000E+04, 4.4313277856E+01, 5.3198207117E+00, 2.5981550057E+01, 4.0155528778E+00, 9.7938826170E-01],
	[4.4795000000E+04, 4.4322039605E+01, 5.3198667076E+00, 2.5991034868E+01, 4.0158775242E+00, 9.7939688854E-01],
	[4.4800000000E+04, 4.4330802107E+01, 5.3199126988E+00, 2.6000522081E+01, 4.0162020896E+00, 9.7940551126E-01],
	[4.4805000000E+04, 4.4339565363E+01, 5.3199586852E+00, 2.6010011696E+01, 4.0165265742E+00, 9.7941412985E-01],
	[4.4810000000E+04, 4.4348329374E+01, 5.3200046669E+00, 2.6019503714E+01, 4.0168509780E+00, 9.7942274431E-01],
	[4.4815000000E+04, 4.4357094139E+01, 5.3200506439E+00, 2.6028998135E+01, 4.0171753009E+00, 9.7943135466E-01],
	[4.4820000000E+04, 4.4365859658E+01, 5.3200966161E+00, 2.6038494960E+01, 4.0174995430E+00, 9.7943996088E-01],
	[4.4825000000E+04, 4.4374625931E+01, 5.3201425836E+00, 2.6047994188E+01, 4.0178237044E+00, 9.7944856298E-01],
	[4.4830000000E+04, 4.4383392958E+01, 5.3201885464E+00, 2.6057495820E+01, 4.0181477850E+00, 9.7945716097E-01],
	[4.4835000000E+04, 4.4392160739E+01, 5.3202345044E+00, 2.6066999857E+01, 4.0184717848E+00, 9.7946575485E-01],
	[4.4840000000E+04, 4.4400929274E+01, 5.3202804578E+00, 2.6076506299E+01, 4.0187957040E+00, 9.7947434462E-01],
	[4.4845000000E+04, 4.4409698563E+01, 5.3203264064E+00, 2.6086015146E+01, 4.0191195424E+00, 9.7948293028E-01],
	[4.4850000000E+04, 4.4418468606E+01, 5.3203723502E+00, 2.6095526398E+01, 4.0194433002E+00, 9.7949151183E-01],
	[4.4855000000E+04, 4.4427239403E+01, 5.3204182894E+00, 2.6105040056E+01, 4.0197669774E+00, 9.7950008928E-01],
	[4.4860000000E+04, 4.4436010954E+01, 5.3204642238E+00, 2.6114556120E+01, 4.0200905739E+00, 9.7950866263E-01],
	[4.4865000000E+04, 4.4444783259E+01, 5.3205101535E+00, 2.6124074591E+01, 4.0204140898E+00, 9.7951723187E-01],
	[4.4870000000E+04, 4.4453556318E+01, 5.3205560784E+00, 2.6133595468E+01, 4.0207375251E+00, 9.7952579703E-01],
	[4.4875000000E+04, 4.4462330131E+01, 5.3206019987E+00, 2.6143118753E+01, 4.0210608799E+00, 9.7953435808E-01],
	[4.4880000000E+04, 4.4471104698E+01, 5.3206479142E+00, 2.6152644445E+01, 4.0213841541E+00, 9.7954291504E-01],
	[4.4885000000E+04, 4.4479880018E+01, 5.3206938250E+00, 2.6162172545E+01, 4.0217073478E+00, 9.7955146792E-01],
	[4.4890000000E+04, 4.4488656092E+01, 5.3207397311E+00, 2.6171703053E+01, 4.0220304610E+00, 9.7956001670E-01],
	[4.4895000000E+04, 4.4497432921E+01, 5.3207856325E+00, 2.6181235969E+01, 4.0223534938E+00, 9.7956856140E-01],
	[4.4900000000E+04, 4.4506210502E+01, 5.3208315292E+00, 2.6190771295E+01, 4.0226764460E+00, 9.7957710202E-01],
	[4.4905000000E+04, 4.4514988838E+01, 5.3208774211E+00, 2.6200309030E+01, 4.0229993179E+00, 9.7958563855E-01],
	[4.4910000000E+04, 4.4523767928E+01, 5.3209233083E+00, 2.6209849174E+01, 4.0233221093E+00, 9.7959417101E-01],
	[4.4915000000E+04, 4.4532547771E+01, 5.3209691909E+00, 2.6219391728E+01, 4.0236448204E+00, 9.7960269938E-01],
	[4.4920000000E+04, 4.4541328368E+01, 5.3210150687E+00, 2.6228936692E+01, 4.0239674511E+00, 9.7961122369E-01],
	[4.4925000000E+04, 4.4550109718E+01, 5.3210609418E+00, 2.6238484067E+01, 4.0242900014E+00, 9.7961974392E-01],
	[4.4930000000E+04, 4.4558891823E+01, 5.3211068101E+00, 2.6248033853E+01, 4.0246124714E+00, 9.7962826008E-01],
	[4.4935000000E+04, 4.4567674681E+01, 5.3211526738E+00, 2.6257586050E+01, 4.0249348611E+00, 9.7963677217E-01],
	[4.4940000000E+04, 4.4576458292E+01, 5.3211985328E+00, 2.6267140658E+01, 4.0252571706E+00, 9.7964528020E-01],
	[4.4945000000E+04, 4.4585242657E+01, 5.3212443871E+00, 2.6276697679E+01, 4.0255793997E+00, 9.7965378416E-01],
	[4.4950000000E+04, 4.4594027776E+01, 5.3212902366E+00, 2.6286257112E+01, 4.0259015487E+00, 9.7966228407E-01],
	[4.4955000000E+04, 4.4602813649E+01, 5.3213360815E+00, 2.6295818957E+01, 4.0262236174E+00, 9.7967077991E-01],
	[4.4960000000E+04, 4.4611600275E+01, 5.3213819216E+00, 2.6305383215E+01, 4.0265456059E+00, 9.7967927170E-01],
	[4.4965000000E+04, 4.4620387654E+01, 5.3214277571E+00, 2.6314949887E+01, 4.0268675143E+00, 9.7968775943E-01],
	[4.4970000000E+04, 4.4629175787E+01, 5.3214735878E+00, 2.6324518972E+01, 4.0271893425E+00, 9.7969624311E-01],
	[4.4975000000E+04, 4.4637964674E+01, 5.3215194139E+00, 2.6334090471E+01, 4.0275110906E+00, 9.7970472274E-01],
	[4.4980000000E+04, 4.4646754314E+01, 5.3215652352E+00, 2.6343664384E+01, 4.0278327585E+00, 9.7971319832E-01],
	[4.4985000000E+04, 4.4655544707E+01, 5.3216110518E+00, 2.6353240712E+01, 4.0281543464E+00, 9.7972166986E-01],
	[4.4990000000E+04, 4.4664335854E+01, 5.3216568638E+00, 2.6362819455E+01, 4.0284758542E+00, 9.7973013735E-01],
	[4.4995000000E+04, 4.4673127754E+01, 5.3217026710E+00, 2.6372400614E+01, 4.0287972820E+00, 9.7973860081E-01],
	[4.5000000000E+04, 4.4681920408E+01, 5.3217484736E+00, 2.6381984188E+01, 4.0291186298E+00, 9.7974706022E-01],
	[4.5005000000E+04, 4.4690713815E+01, 5.3217942715E+00, 2.6391590117E+01, 4.0294403623E+00, 9.7975551560E-01],
	[4.5010000000E+04, 4.4699507976E+01, 5.3218400646E+00, 2.6401198475E+01, 4.0297620147E+00, 9.7976396694E-01],
	[4.5015000000E+04, 4.4708302890E+01, 5.3218858531E+00, 2.6410809261E+01, 4.0300835868E+00, 9.7977241425E-01],
	[4.5020000000E+04, 4.4717098557E+01, 5.3219316369E+00, 2.6420422478E+01, 4.0304050788E+00, 9.7978085753E-01],
	[4.5025000000E+04, 4.4725894978E+01, 5.3219774160E+00, 2.6430038124E+01, 4.0307264906E+00, 9.7978929678E-01],
	[4.5030000000E+04, 4.4734692152E+01, 5.3220231904E+00, 2.6439656200E+01, 4.0310478223E+00, 9.7979773201E-01],
	[4.5035000000E+04, 4.4743490079E+01, 5.3220689601E+00, 2.6449276706E+01, 4.0313690738E+00, 9.7980616321E-01],
	[4.5040000000E+04, 4.4752288759E+01, 5.3221147251E+00, 2.6458899643E+01, 4.0316902453E+00, 9.7981459039E-01],
	[4.5045000000E+04, 4.4761088193E+01, 5.3221604854E+00, 2.6468525011E+01, 4.0320113367E+00, 9.7982301355E-01],
	[4.5050000000E+04, 4.4769888380E+01, 5.3222062411E+00, 2.6478152811E+01, 4.0323323481E+00, 9.7983143270E-01],
	[4.5055000000E+04, 4.4778689320E+01, 5.3222519921E+00, 2.6487783042E+01, 4.0326532794E+00, 9.7983984783E-01],
	[4.5060000000E+04, 4.4787491013E+01, 5.3222977383E+00, 2.6497415706E+01, 4.0329741308E+00, 9.7984825895E-01],
	[4.5065000000E+04, 4.4796293459E+01, 5.3223434799E+00, 2.6507050802E+01, 4.0332949021E+00, 9.7985666606E-01],
	[4.5070000000E+04, 4.4805096659E+01, 5.3223892169E+00, 2.6516688330E+01, 4.0336155935E+00, 9.7986506916E-01],
	[4.5075000000E+04, 4.4813900611E+01, 5.3224349491E+00, 2.6526328292E+01, 4.0339362050E+00, 9.7987346826E-01],
	[4.5080000000E+04, 4.4822705317E+01, 5.3224806767E+00, 2.6535970688E+01, 4.0342567365E+00, 9.7988186335E-01],
	[4.5085000000E+04, 4.4831510776E+01, 5.3225263995E+00, 2.6545615517E+01, 4.0345771882E+00, 9.7989025444E-01],
	[4.5090000000E+04, 4.4840316988E+01, 5.3225721177E+00, 2.6555262780E+01, 4.0348975600E+00, 9.7989864154E-01],
	[4.5095000000E+04, 4.4849123953E+01, 5.3226178313E+00, 2.6564912478E+01, 4.0352178519E+00, 9.7990702463E-01],
	[4.5100000000E+04, 4.4857931671E+01, 5.3226635401E+00, 2.6574564611E+01, 4.0355380640E+00, 9.7991540373E-01],
	[4.5105000000E+04, 4.4866740142E+01, 5.3227092443E+00, 2.6584219179E+01, 4.0358581963E+00, 9.7992377884E-01],
	[4.5110000000E+04, 4.4875549366E+01, 5.3227549438E+00, 2.6593876183E+01, 4.0361782488E+00, 9.7993214996E-01],
	[4.5115000000E+04, 4.4884359343E+01, 5.3228006386E+00, 2.6603535622E+01, 4.0364982215E+00, 9.7994051709E-01],
	[4.5120000000E+04, 4.4893170073E+01, 5.3228463288E+00, 2.6613197498E+01, 4.0368181145E+00, 9.7994888023E-01],
	[4.5125000000E+04, 4.4901981556E+01, 5.3228920143E+00, 2.6622861810E+01, 4.0371379278E+00, 9.7995723939E-01],
	[4.5130000000E+04, 4.4910793791E+01, 5.3229376951E+00, 2.6632528559E+01, 4.0374576614E+00, 9.7996559457E-01],
	[4.5135000000E+04, 4.4919606780E+01, 5.3229833712E+00, 2.6642197746E+01, 4.0377773153E+00, 9.7997394578E-01],
	[4.5140000000E+04, 4.4928420522E+01, 5.3230290427E+00, 2.6651869370E+01, 4.0380968895E+00, 9.7998229300E-01],
	[4.5145000000E+04, 4.4937235016E+01, 5.3230747095E+00, 2.6661543432E+01, 4.0384163841E+00, 9.7999063625E-01],
	[4.5150000000E+04, 4.4946050263E+01, 5.3231203717E+00, 2.6671219932E+01, 4.0387357991E+00, 9.7999897552E-01],
	[4.5155000000E+04, 4.4954866263E+01, 5.3231660292E+00, 2.6680898871E+01, 4.0390551345E+00, 9.8000731083E-01],
	[4.5160000000E+04, 4.4963683016E+01, 5.3232116820E+00, 2.6690580249E+01, 4.0393743903E+00, 9.8001564217E-01],
	[4.5165000000E+04, 4.4972500522E+01, 5.3232573301E+00, 2.6700264066E+01, 4.0396935666E+00, 9.8002396954E-01],
	[4.5170000000E+04, 4.4981318780E+01, 5.3233029736E+00, 2.6709950323E+01, 4.0400126634E+00, 9.8003229294E-01],
	[4.5175000000E+04, 4.4990137791E+01, 5.3233486125E+00, 2.6719639020E+01, 4.0403316806E+00, 9.8004061238E-01],
	[4.5180000000E+04, 4.4998957555E+01, 5.3233942466E+00, 2.6729330158E+01, 4.0406506184E+00, 9.8004892786E-01],
	[4.5185000000E+04, 4.5007778072E+01, 5.3234398761E+00, 2.6739023736E+01, 4.0409694767E+00, 9.8005723938E-01],
	[4.5190000000E+04, 4.5016599341E+01, 5.3234855010E+00, 2.6748719755E+01, 4.0412882555E+00, 9.8006554694E-01],
	[4.5195000000E+04, 4.5025421363E+01, 5.3235311212E+00, 2.6758418216E+01, 4.0416069549E+00, 9.8007385055E-01],
	[4.5200000000E+04, 4.5034244137E+01, 5.3235767367E+00, 2.6768119118E+01, 4.0419255750E+00, 9.8008215020E-01],
	[4.5205000000E+04, 4.5043067664E+01, 5.3236223476E+00, 2.6777822463E+01, 4.0422441156E+00, 9.8009044590E-01],
	[4.5210000000E+04, 4.5051891944E+01, 5.3236679539E+00, 2.6787528249E+01, 4.0425625770E+00, 9.8009873765E-01],
	[4.5215000000E+04, 4.5060716977E+01, 5.3237135555E+00, 2.6797236479E+01, 4.0428809589E+00, 9.8010702546E-01],
	[4.5220000000E+04, 4.5069542762E+01, 5.3237591524E+00, 2.6806947152E+01, 4.0431992616E+00, 9.8011530931E-01],
	[4.5225000000E+04, 4.5078369299E+01, 5.3238047447E+00, 2.6816660268E+01, 4.0435174849E+00, 9.8012358923E-01],
	[4.5230000000E+04, 4.5087196589E+01, 5.3238503323E+00, 2.6826375828E+01, 4.0438356290E+00, 9.8013186520E-01],
	[4.5235000000E+04, 4.5096024632E+01, 5.3238959153E+00, 2.6836093832E+01, 4.0441536939E+00, 9.8014013723E-01],
	[4.5240000000E+04, 4.5104853427E+01, 5.3239414936E+00, 2.6845814281E+01, 4.0444716795E+00, 9.8014840532E-01],
	[4.5245000000E+04, 4.5113682974E+01, 5.3239870673E+00, 2.6855537174E+01, 4.0447895859E+00, 9.8015666948E-01],
	[4.5250000000E+04, 4.5122513274E+01, 5.3240326363E+00, 2.6865262513E+01, 4.0451074132E+00, 9.8016492970E-01],
	[4.5255000000E+04, 4.5131344327E+01, 5.3240782007E+00, 2.6874990297E+01, 4.0454251612E+00, 9.8017318599E-01],
	[4.5260000000E+04, 4.5140176131E+01, 5.3241237605E+00, 2.6884720527E+01, 4.0457428302E+00, 9.8018143835E-01],
	[4.5265000000E+04, 4.5149008689E+01, 5.3241693156E+00, 2.6894453204E+01, 4.0460604200E+00, 9.8018968678E-01],
	[4.5270000000E+04, 4.5157841998E+01, 5.3242148660E+00, 2.6904188327E+01, 4.0463779307E+00, 9.8019793129E-01],
	[4.5275000000E+04, 4.5166676060E+01, 5.3242604119E+00, 2.6913925896E+01, 4.0466953623E+00, 9.8020617187E-01],
	[4.5280000000E+04, 4.5175510875E+01, 5.3243059531E+00, 2.6923665913E+01, 4.0470127149E+00, 9.8021440853E-01],
	[4.5285000000E+04, 4.5184346441E+01, 5.3243514896E+00, 2.6933408378E+01, 4.0473299885E+00, 9.8022264126E-01],
	[4.5290000000E+04, 4.5193182760E+01, 5.3243970215E+00, 2.6943153291E+01, 4.0476471830E+00, 9.8023087008E-01],
	[4.5295000000E+04, 4.5202019831E+01, 5.3244425488E+00, 2.6952900652E+01, 4.0479642986E+00, 9.8023909498E-01],
	[4.5300000000E+04, 4.5210857655E+01, 5.3244880714E+00, 2.6962650461E+01, 4.0482813352E+00, 9.8024731597E-01],
	[4.5305000000E+04, 4.5219707340E+01, 5.3245347532E+00, 2.6972402719E+01, 4.0485990547E+00, 9.8025553304E-01],
	[4.5310000000E+04, 4.5228564139E+01, 5.3245820962E+00, 2.6982157427E+01, 4.0489171314E+00, 9.8026374620E-01],
	[4.5315000000E+04, 4.5237421695E+01, 5.3246294343E+00, 2.6991914585E+01, 4.0492351294E+00, 9.8027195545E-01],
	[4.5320000000E+04, 4.5246280007E+01, 5.3246767677E+00, 2.7001674192E+01, 4.0495530487E+00, 9.8028016080E-01],
	[4.5325000000E+04, 4.5255139077E+01, 5.3247240962E+00, 2.7011436250E+01, 4.0498708893E+00, 9.8028836224E-01],
	[4.5330000000E+04, 4.5263998904E+01, 5.3247714199E+00, 2.7021200758E+01, 4.0501886512E+00, 9.8029655978E-01],
	[4.5335000000E+04, 4.5272859488E+01, 5.3248187389E+00, 2.7030967718E+01, 4.0505063345E+00, 9.8030475341E-01],
	[4.5340000000E+04, 4.5281720829E+01, 5.3248660530E+00, 2.7040737129E+01, 4.0508239391E+00, 9.8031294315E-01],
	[4.5345000000E+04, 4.5290582927E+01, 5.3249133624E+00, 2.7050508992E+01, 4.0511414652E+00, 9.8032112899E-01],
	[4.5350000000E+04, 4.5299445782E+01, 5.3249606669E+00, 2.7060283306E+01, 4.0514589126E+00, 9.8032931093E-01],
	[4.5355000000E+04, 4.5308309394E+01, 5.3250079667E+00, 2.7070060073E+01, 4.0517762815E+00, 9.8033748898E-01],
	[4.5360000000E+04, 4.5317173763E+01, 5.3250552616E+00, 2.7079839293E+01, 4.0520935718E+00, 9.8034566314E-01],
	[4.5365000000E+04, 4.5326038889E+01, 5.3251025518E+00, 2.7089620966E+01, 4.0524107837E+00, 9.8035383341E-01],
	[4.5370000000E+04, 4.5334904772E+01, 5.3251498372E+00, 2.7099405093E+01, 4.0527279170E+00, 9.8036199979E-01],
	[4.5375000000E+04, 4.5343771411E+01, 5.3251971177E+00, 2.7109191673E+01, 4.0530449718E+00, 9.8037016228E-01],
	[4.5380000000E+04, 4.5352638808E+01, 5.3252443935E+00, 2.7118980707E+01, 4.0533619482E+00, 9.8037832089E-01],
	[4.5385000000E+04, 4.5361506961E+01, 5.3252916645E+00, 2.7128772196E+01, 4.0536788462E+00, 9.8038647562E-01],
	[4.5390000000E+04, 4.5370375871E+01, 5.3253389307E+00, 2.7138566140E+01, 4.0539956657E+00, 9.8039462647E-01],
	[4.5395000000E+04, 4.5379245538E+01, 5.3253861922E+00, 2.7148362539E+01, 4.0543124069E+00, 9.8040277344E-01],
	[4.5400000000E+04, 4.5388115962E+01, 5.3254334488E+00, 2.7158161393E+01, 4.0546290696E+00, 9.8041091653E-01],
	[4.5405000000E+04, 4.5396987143E+01, 5.3254807007E+00, 2.7167962703E+01, 4.0549456540E+00, 9.8041905575E-01],
	[4.5410000000E+04, 4.5405859080E+01, 5.3255279478E+00, 2.7177766470E+01, 4.0552621601E+00, 9.8042719110E-01],
	[4.5415000000E+04, 4.5414731774E+01, 5.3255751900E+00, 2.7187572693E+01, 4.0555785879E+00, 9.8043532257E-01],
	[4.5420000000E+04, 4.5423605225E+01, 5.3256224276E+00, 2.7197381373E+01, 4.0558949374E+00, 9.8044345018E-01],
	[4.5425000000E+04, 4.5432479432E+01, 5.3256696603E+00, 2.7207192510E+01, 4.0562112086E+00, 9.8045157392E-01],
	[4.5430000000E+04, 4.5441354397E+01, 5.3257168882E+00, 2.7217006105E+01, 4.0565274016E+00, 9.8045969380E-01],
	[4.5435000000E+04, 4.5450230117E+01, 5.3257641114E+00, 2.7226822157E+01, 4.0568435164E+00, 9.8046780981E-01],
	[4.5440000000E+04, 4.5459106595E+01, 5.3258113298E+00, 2.7236640668E+01, 4.0571595529E+00, 9.8047592196E-01],
	[4.5445000000E+04, 4.5467983829E+01, 5.3258585434E+00, 2.7246461638E+01, 4.0574755113E+00, 9.8048403026E-01],
	[4.5450000000E+04, 4.5476861820E+01, 5.3259057522E+00, 2.7256285066E+01, 4.0577913915E+00, 9.8049213470E-01],
	[4.5455000000E+04, 4.5485740567E+01, 5.3259529563E+00, 2.7266110954E+01, 4.0581071936E+00, 9.8050023528E-01],
	[4.5460000000E+04, 4.5494620071E+01, 5.3260001556E+00, 2.7275939302E+01, 4.0584229176E+00, 9.8050833201E-01],
	[4.5465000000E+04, 4.5503500332E+01, 5.3260473501E+00, 2.7285770109E+01, 4.0587385635E+00, 9.8051642488E-01],
	[4.5470000000E+04, 4.5512381348E+01, 5.3260945399E+00, 2.7295603377E+01, 4.0590541313E+00, 9.8052451391E-01],
	[4.5475000000E+04, 4.5521263122E+01, 5.3261417248E+00, 2.7305439105E+01, 4.0593696210E+00, 9.8053259909E-01],
	[4.5480000000E+04, 4.5530145652E+01, 5.3261889051E+00, 2.7315277295E+01, 4.0596850327E+00, 9.8054068043E-01],
	[4.5485000000E+04, 4.5539028938E+01, 5.3262360805E+00, 2.7325117946E+01, 4.0600003664E+00, 9.8054875792E-01],
	[4.5490000000E+04, 4.5547912981E+01, 5.3262832512E+00, 2.7334961058E+01, 4.0603156221E+00, 9.8055683157E-01],
	[4.5495000000E+04, 4.5556797781E+01, 5.3263304171E+00, 2.7344806633E+01, 4.0606307998E+00, 9.8056490138E-01],
	[4.5500000000E+04, 4.5565683337E+01, 5.3263775782E+00, 2.7354654670E+01, 4.0609458996E+00, 9.8057296735E-01],
	[4.5505000000E+04, 4.5574569649E+01, 5.3264247346E+00, 2.7364505170E+01, 4.0612609215E+00, 9.8058102949E-01],
	[4.5510000000E+04, 4.5583456717E+01, 5.3264718862E+00, 2.7374358133E+01, 4.0615758655E+00, 9.8058908779E-01],
	[4.5515000000E+04, 4.5592344542E+01, 5.3265190330E+00, 2.7384213559E+01, 4.0618907315E+00, 9.8059714226E-01],
	[4.5520000000E+04, 4.5601233124E+01, 5.3265661751E+00, 2.7394071449E+01, 4.0622055198E+00, 9.8060519290E-01],
	[4.5525000000E+04, 4.5610122461E+01, 5.3266133124E+00, 2.7403931804E+01, 4.0625202301E+00, 9.8061323972E-01],
	[4.5530000000E+04, 4.5619012555E+01, 5.3266604450E+00, 2.7413794622E+01, 4.0628348627E+00, 9.8062128270E-01],
	[4.5535000000E+04, 4.5627903405E+01, 5.3267075728E+00, 2.7423659906E+01, 4.0631494174E+00, 9.8062932187E-01],
	[4.5540000000E+04, 4.5636795012E+01, 5.3267546958E+00, 2.7433527655E+01, 4.0634638944E+00, 9.8063735721E-01],
	[4.5545000000E+04, 4.5645687375E+01, 5.3268018141E+00, 2.7443397869E+01, 4.0637782936E+00, 9.8064538872E-01],
	[4.5550000000E+04, 4.5654580494E+01, 5.3268489277E+00, 2.7453270549E+01, 4.0640926151E+00, 9.8065341643E-01],
	[4.5555000000E+04, 4.5663474369E+01, 5.3268960364E+00, 2.7463145695E+01, 4.0644068589E+00, 9.8066144031E-01],
	[4.5560000000E+04, 4.5672369000E+01, 5.3269431405E+00, 2.7473023308E+01, 4.0647210250E+00, 9.8066946038E-01],
	[4.5565000000E+04, 4.5681264388E+01, 5.3269902397E+00, 2.7482903388E+01, 4.0650351134E+00, 9.8067747664E-01],
	[4.5570000000E+04, 4.5690160531E+01, 5.3270373343E+00, 2.7492785935E+01, 4.0653491241E+00, 9.8068548908E-01],
	[4.5575000000E+04, 4.5699057431E+01, 5.3270844240E+00, 2.7502670950E+01, 4.0656630573E+00, 9.8069349772E-01],
	[4.5580000000E+04, 4.5707955087E+01, 5.3271315091E+00, 2.7512558432E+01, 4.0659769128E+00, 9.8070150255E-01],
	[4.5585000000E+04, 4.5716853499E+01, 5.3271785893E+00, 2.7522448383E+01, 4.0662906907E+00, 9.8070950357E-01],
	[4.5590000000E+04, 4.5725752668E+01, 5.3272256649E+00, 2.7532340802E+01, 4.0666043911E+00, 9.8071750079E-01],
	[4.5595000000E+04, 4.5734652592E+01, 5.3272727356E+00, 2.7542235691E+01, 4.0669180139E+00, 9.8072549421E-01],
	[4.5600000000E+04, 4.5743553272E+01, 5.3273198017E+00, 2.7552133048E+01, 4.0672315592E+00, 9.8073348383E-01],
	[4.5605000000E+04, 4.5752454709E+01, 5.3273668630E+00, 2.7562032876E+01, 4.0675450270E+00, 9.8074146966E-01],
	[4.5610000000E+04, 4.5761356901E+01, 5.3274139195E+00, 2.7571935173E+01, 4.0678584173E+00, 9.8074945169E-01],
	[4.5615000000E+04, 4.5770259849E+01, 5.3274609713E+00, 2.7581839940E+01, 4.0681717301E+00, 9.8075742992E-01],
	[4.5620000000E+04, 4.5779163553E+01, 5.3275080184E+00, 2.7591747179E+01, 4.0684849655E+00, 9.8076540436E-01],
	[4.5625000000E+04, 4.5788068014E+01, 5.3275550607E+00, 2.7601656888E+01, 4.0687981235E+00, 9.8077337501E-01],
	[4.5630000000E+04, 4.5796973230E+01, 5.3276020983E+00, 2.7611569069E+01, 4.0691112041E+00, 9.8078134188E-01],
	[4.5635000000E+04, 4.5805879202E+01, 5.3276491311E+00, 2.7621483721E+01, 4.0694242074E+00, 9.8078930496E-01],
	[4.5640000000E+04, 4.5814785930E+01, 5.3276961592E+00, 2.7631400846E+01, 4.0697371332E+00, 9.8079726425E-01],
	[4.5645000000E+04, 4.5823693414E+01, 5.3277431826E+00, 2.7641320443E+01, 4.0700499818E+00, 9.8080521976E-01],
	[4.5650000000E+04, 4.5832601654E+01, 5.3277902012E+00, 2.7651242512E+01, 4.0703627530E+00, 9.8081317150E-01],
	[4.5655000000E+04, 4.5841510649E+01, 5.3278372151E+00, 2.7661167055E+01, 4.0706754469E+00, 9.8082111945E-01],
	[4.5660000000E+04, 4.5850420401E+01, 5.3278842243E+00, 2.7671094071E+01, 4.0709880636E+00, 9.8082906363E-01],
	[4.5665000000E+04, 4.5859330908E+01, 5.3279312287E+00, 2.7681023561E+01, 4.0713006030E+00, 9.8083700403E-01],
	[4.5670000000E+04, 4.5868242171E+01, 5.3279782284E+00, 2.7690955525E+01, 4.0716130652E+00, 9.8084494066E-01],
	[4.5675000000E+04, 4.5877154190E+01, 5.3280252233E+00, 2.7700889964E+01, 4.0719254501E+00, 9.8085287352E-01],
	[4.5680000000E+04, 4.5886066964E+01, 5.3280722136E+00, 2.7710826877E+01, 4.0722377579E+00, 9.8086080261E-01],
	[4.5685000000E+04, 4.5894980494E+01, 5.3281191991E+00, 2.7720766266E+01, 4.0725499885E+00, 9.8086872793E-01],
	[4.5690000000E+04, 4.5903894780E+01, 5.3281661799E+00, 2.7730708130E+01, 4.0728621420E+00, 9.8087664949E-01],
	[4.5695000000E+04, 4.5912809822E+01, 5.3282131559E+00, 2.7740652470E+01, 4.0731742184E+00, 9.8088456729E-01],
	[4.5700000000E+04, 4.5921725619E+01, 5.3282601273E+00, 2.7750599286E+01, 4.0734862176E+00, 9.8089248132E-01],
	[4.5705000000E+04, 4.5930642172E+01, 5.3283070939E+00, 2.7760548579E+01, 4.0737981398E+00, 9.8090039160E-01],
	[4.5710000000E+04, 4.5939559481E+01, 5.3283540557E+00, 2.7770500349E+01, 4.0741099849E+00, 9.8090829811E-01],
	[4.5715000000E+04, 4.5948477545E+01, 5.3284010129E+00, 2.7780454596E+01, 4.0744217530E+00, 9.8091620088E-01],
	[4.5720000000E+04, 4.5957396365E+01, 5.3284479653E+00, 2.7790411320E+01, 4.0747334441E+00, 9.8092409988E-01],
	[4.5725000000E+04, 4.5966315940E+01, 5.3284949130E+00, 2.7800370522E+01, 4.0750450581E+00, 9.8093199514E-01],
	[4.5730000000E+04, 4.5975236271E+01, 5.3285418560E+00, 2.7810332203E+01, 4.0753565952E+00, 9.8093988665E-01],
	[4.5735000000E+04, 4.5984157358E+01, 5.3285887943E+00, 2.7820296362E+01, 4.0756680553E+00, 9.8094777441E-01],
	[4.5740000000E+04, 4.5993079200E+01, 5.3286357279E+00, 2.7830263001E+01, 4.0759794385E+00, 9.8095565842E-01],
	[4.5745000000E+04, 4.6002001798E+01, 5.3286826567E+00, 2.7840232118E+01, 4.0762907448E+00, 9.8096353869E-01],
	[4.5750000000E+04, 4.6010925151E+01, 5.3287295808E+00, 2.7850203715E+01, 4.0766019742E+00, 9.8097141522E-01],
	[4.5755000000E+04, 4.6019849259E+01, 5.3287765002E+00, 2.7860177793E+01, 4.0769131268E+00, 9.8097928800E-01],
	[4.5760000000E+04, 4.6028774123E+01, 5.3288234149E+00, 2.7870154350E+01, 4.0772242024E+00, 9.8098715705E-01],
	[4.5765000000E+04, 4.6037699742E+01, 5.3288703249E+00, 2.7880133388E+01, 4.0775352013E+00, 9.8099502236E-01],
	[4.5770000000E+04, 4.6046626117E+01, 5.3289172302E+00, 2.7890114908E+01, 4.0778461233E+00, 9.8100288394E-01],
	[4.5775000000E+04, 4.6055553247E+01, 5.3289641307E+00, 2.7900098908E+01, 4.0781569686E+00, 9.8101074179E-01],
	[4.5780000000E+04, 4.6064481133E+01, 5.3290110266E+00, 2.7910085391E+01, 4.0784677371E+00, 9.8101859590E-01],
	[4.5785000000E+04, 4.6073409774E+01, 5.3290579177E+00, 2.7920074355E+01, 4.0787784288E+00, 9.8102644629E-01],
	[4.5790000000E+04, 4.6082339170E+01, 5.3291048042E+00, 2.7930065802E+01, 4.0790890439E+00, 9.8103429294E-01],
	[4.5795000000E+04, 4.6091269322E+01, 5.3291516859E+00, 2.7940059732E+01, 4.0793995822E+00, 9.8104213588E-01],
	[4.5800000000E+04, 4.6100200229E+01, 5.3291985629E+00, 2.7950056144E+01, 4.0797100439E+00, 9.8104997509E-01],
	[4.5805000000E+04, 4.6109131891E+01, 5.3292454352E+00, 2.7960055041E+01, 4.0800204288E+00, 9.8105781058E-01],
	[4.5810000000E+04, 4.6118064308E+01, 5.3292923028E+00, 2.7970056421E+01, 4.0803307372E+00, 9.8106564235E-01],
	[4.5815000000E+04, 4.6126997481E+01, 5.3293391657E+00, 2.7980060285E+01, 4.0806409689E+00, 9.8107347040E-01],
	[4.5820000000E+04, 4.6135931409E+01, 5.3293860239E+00, 2.7990066633E+01, 4.0809511240E+00, 9.8108129473E-01],
	[4.5825000000E+04, 4.6144866092E+01, 5.3294328775E+00, 2.8000075467E+01, 4.0812612026E+00, 9.8108911536E-01],
	[4.5830000000E+04, 4.6153801530E+01, 5.3294797263E+00, 2.8010086786E+01, 4.0815712046E+00, 9.8109693227E-01],
	[4.5835000000E+04, 4.6162737724E+01, 5.3295265704E+00, 2.8020100590E+01, 4.0818811301E+00, 9.8110474547E-01],
	[4.5840000000E+04, 4.6171674673E+01, 5.3295734098E+00, 2.8030116880E+01, 4.0821909790E+00, 9.8111255496E-01],
	[4.5845000000E+04, 4.6180612376E+01, 5.3296202445E+00, 2.8040135656E+01, 4.0825007515E+00, 9.8112036075E-01],
	[4.5850000000E+04, 4.6189550835E+01, 5.3296670745E+00, 2.8050156919E+01, 4.0828104475E+00, 9.8112816283E-01],
	[4.5855000000E+04, 4.6198490049E+01, 5.3297138998E+00, 2.8060180669E+01, 4.0831200670E+00, 9.8113596121E-01],
	[4.5860000000E+04, 4.6207430018E+01, 5.3297607204E+00, 2.8070206906E+01, 4.0834296102E+00, 9.8114375589E-01],
	[4.5865000000E+04, 4.6216370742E+01, 5.3298075364E+00, 2.8080235630E+01, 4.0837390769E+00, 9.8115154687E-01],
	[4.5870000000E+04, 4.6225312222E+01, 5.3298543476E+00, 2.8090266843E+01, 4.0840484672E+00, 9.8115933416E-01],
	[4.5875000000E+04, 4.6234254456E+01, 5.3299011542E+00, 2.8100300544E+01, 4.0843577811E+00, 9.8116711775E-01],
	[4.5880000000E+04, 4.6243197445E+01, 5.3299479560E+00, 2.8110336733E+01, 4.0846670187E+00, 9.8117489764E-01],
	[4.5885000000E+04, 4.6252141189E+01, 5.3299947532E+00, 2.8120375412E+01, 4.0849761800E+00, 9.8118267385E-01],
	[4.5890000000E+04, 4.6261085688E+01, 5.3300415457E+00, 2.8130416579E+01, 4.0852852650E+00, 9.8119044637E-01],
	[4.5895000000E+04, 4.6270030943E+01, 5.3300883335E+00, 2.8140460237E+01, 4.0855942737E+00, 9.8119821520E-01],
	[4.5900000000E+04, 4.6278976952E+01, 5.3301351166E+00, 2.8150506384E+01, 4.0859032062E+00, 9.8120598034E-01],
	[4.5905000000E+04, 4.6287923716E+01, 5.3301818950E+00, 2.8160555022E+01, 4.0862120624E+00, 9.8121374180E-01],
	[4.5910000000E+04, 4.6296871234E+01, 5.3302286687E+00, 2.8170606151E+01, 4.0865208423E+00, 9.8122149958E-01],
	[4.5915000000E+04, 4.6305819508E+01, 5.3302754378E+00, 2.8180659770E+01, 4.0868295461E+00, 9.8122925368E-01],
	[4.5920000000E+04, 4.6314768537E+01, 5.3303222021E+00, 2.8190715881E+01, 4.0871381737E+00, 9.8123700410E-01],
	[4.5925000000E+04, 4.6323718320E+01, 5.3303689618E+00, 2.8200774484E+01, 4.0874467252E+00, 9.8124475085E-01],
	[4.5930000000E+04, 4.6332668858E+01, 5.3304157168E+00, 2.8210835579E+01, 4.0877552005E+00, 9.8125249392E-01],
	[4.5935000000E+04, 4.6341620151E+01, 5.3304624672E+00, 2.8220899166E+01, 4.0880635997E+00, 9.8126023332E-01],
	[4.5940000000E+04, 4.6350572199E+01, 5.3305092128E+00, 2.8230965246E+01, 4.0883719228E+00, 9.8126796905E-01],
	[4.5945000000E+04, 4.6359525002E+01, 5.3305559538E+00, 2.8241033819E+01, 4.0886801698E+00, 9.8127570111E-01],
	[4.5950000000E+04, 4.6368478559E+01, 5.3306026901E+00, 2.8251104886E+01, 4.0889883408E+00, 9.8128342951E-01],
	[4.5955000000E+04, 4.6377432871E+01, 5.3306494217E+00, 2.8261178446E+01, 4.0892964357E+00, 9.8129115424E-01],
	[4.5960000000E+04, 4.6386387938E+01, 5.3306961487E+00, 2.8271254501E+01, 4.0896044547E+00, 9.8129887530E-01],
	[4.5965000000E+04, 4.6395343759E+01, 5.3307428709E+00, 2.8281333050E+01, 4.0899123976E+00, 9.8130659271E-01],
	[4.5970000000E+04, 4.6404300335E+01, 5.3307895885E+00, 2.8291414094E+01, 4.0902202646E+00, 9.8131430646E-01],
	[4.5975000000E+04, 4.6413257666E+01, 5.3308363015E+00, 2.8301497633E+01, 4.0905280556E+00, 9.8132201655E-01],
	[4.5980000000E+04, 4.6422215752E+01, 5.3308830097E+00, 2.8311583668E+01, 4.0908357707E+00, 9.8132972298E-01],
	[4.5985000000E+04, 4.6431174592E+01, 5.3309297133E+00, 2.8321672199E+01, 4.0911434099E+00, 9.8133742577E-01],
	[4.5990000000E+04, 4.6440134186E+01, 5.3309764122E+00, 2.8331763226E+01, 4.0914509733E+00, 9.8134512490E-01],
	[4.5995000000E+04, 4.6449094536E+01, 5.3310231065E+00, 2.8341856749E+01, 4.0917584607E+00, 9.8135282038E-01],
	[4.6000000000E+04, 4.6458055639E+01, 5.3310697961E+00, 2.8351952770E+01, 4.0920658723E+00, 9.8136051221E-01],
	[4.6005000000E+04, 4.6467017498E+01, 5.3311164810E+00, 2.8362051287E+01, 4.0923732081E+00, 9.8136820040E-01],
	[4.6010000000E+04, 4.6475980110E+01, 5.3311631612E+00, 2.8372152302E+01, 4.0926804681E+00, 9.8137588494E-01],
	[4.6015000000E+04, 4.6484943478E+01, 5.3312098368E+00, 2.8382255816E+01, 4.0929876523E+00, 9.8138356584E-01],
	[4.6020000000E+04, 4.6493907600E+01, 5.3312565077E+00, 2.8392361827E+01, 4.0932947607E+00, 9.8139124311E-01],
	[4.6025000000E+04, 4.6502872476E+01, 5.3313031740E+00, 2.8402470337E+01, 4.0936017934E+00, 9.8139891673E-01],
	[4.6030000000E+04, 4.6511838107E+01, 5.3313498356E+00, 2.8412581347E+01, 4.0939087504E+00, 9.8140658672E-01],
	[4.6035000000E+04, 4.6520818048E+01, 5.3313978828E+00, 2.8422694855E+01, 4.0942165566E+00, 9.8141425307E-01],
	[4.6040000000E+04, 4.6529802648E+01, 5.3314463252E+00, 2.8432810864E+01, 4.0945245534E+00, 9.8142191579E-01],
	[4.6045000000E+04, 4.6538788008E+01, 5.3314947628E+00, 2.8442929372E+01, 4.0948324746E+00, 9.8142957488E-01],
	[4.6050000000E+04, 4.6547774127E+01, 5.3315431956E+00, 2.8453050381E+01, 4.0951403204E+00, 9.8143723034E-01],
	[4.6055000000E+04, 4.6556761005E+01, 5.3315916236E+00, 2.8463173890E+01, 4.0954480908E+00, 9.8144488217E-01],
	[4.6060000000E+04, 4.6565748642E+01, 5.3316400468E+00, 2.8473299900E+01, 4.0957557857E+00, 9.8145253038E-01],
	[4.6065000000E+04, 4.6574737038E+01, 5.3316884651E+00, 2.8483428412E+01, 4.0960634052E+00, 9.8146017496E-01],
	[4.6070000000E+04, 4.6583726194E+01, 5.3317368787E+00, 2.8493559426E+01, 4.0963709493E+00, 9.8146781592E-01],
	[4.6075000000E+04, 4.6592716109E+01, 5.3317852874E+00, 2.8503692942E+01, 4.0966784180E+00, 9.8147545327E-01],
	[4.6080000000E+04, 4.6601706782E+01, 5.3318336913E+00, 2.8513828960E+01, 4.0969858113E+00, 9.8148308699E-01],
	[4.6085000000E+04, 4.6610698215E+01, 5.3318820904E+00, 2.8523967481E+01, 4.0972931294E+00, 9.8149071710E-01],
	[4.6090000000E+04, 4.6619690407E+01, 5.3319304846E+00, 2.8534108506E+01, 4.0976003721E+00, 9.8149834360E-01],
	[4.6095000000E+04, 4.6628683358E+01, 5.3319788741E+00, 2.8544252033E+01, 4.0979075395E+00, 9.8150596648E-01],
	[4.6100000000E+04, 4.6637677068E+01, 5.3320272588E+00, 2.8554398065E+01, 4.0982146317E+00, 9.8151358575E-01],
	[4.6105000000E+04, 4.6646671537E+01, 5.3320756386E+00, 2.8564546601E+01, 4.0985216486E+00, 9.8152120142E-01],
	[4.6110000000E+04, 4.6655666765E+01, 5.3321240137E+00, 2.8574697641E+01, 4.0988285903E+00, 9.8152881348E-01],
	[4.6115000000E+04, 4.6664662753E+01, 5.3321723839E+00, 2.8584851186E+01, 4.0991354568E+00, 9.8153642193E-01],
	[4.6120000000E+04, 4.6673659499E+01, 5.3322207493E+00, 2.8595007237E+01, 4.0994422480E+00, 9.8154402678E-01],
	[4.6125000000E+04, 4.6682657003E+01, 5.3322691100E+00, 2.8605165793E+01, 4.0997489642E+00, 9.8155162803E-01],
	[4.6130000000E+04, 4.6691655267E+01, 5.3323174658E+00, 2.8615326855E+01, 4.1000556051E+00, 9.8155922568E-01],
	[4.6135000000E+04, 4.6700654290E+01, 5.3323658168E+00, 2.8625490423E+01, 4.1003621710E+00, 9.8156681974E-01],
	[4.6140000000E+04, 4.6709654072E+01, 5.3324141630E+00, 2.8635656498E+01, 4.1006686617E+00, 9.8157441019E-01],
	[4.6145000000E+04, 4.6718654612E+01, 5.3324625044E+00, 2.8645825079E+01, 4.1009750774E+00, 9.8158199706E-01],
	[4.6150000000E+04, 4.6727655912E+01, 5.3325108410E+00, 2.8655996168E+01, 4.1012814180E+00, 9.8158958033E-01],
	[4.6155000000E+04, 4.6736657970E+01, 5.3325591729E+00, 2.8666169765E+01, 4.1015876835E+00, 9.8159716002E-01],
	[4.6160000000E+04, 4.6745660787E+01, 5.3326074999E+00, 2.8676345870E+01, 4.1018938740E+00, 9.8160473611E-01],
	[4.6165000000E+04, 4.6754664363E+01, 5.3326558221E+00, 2.8686524483E+01, 4.1021999896E+00, 9.8161230862E-01],
	[4.6170000000E+04, 4.6763668697E+01, 5.3327041395E+00, 2.8696705605E+01, 4.1025060301E+00, 9.8161987755E-01],
	[4.6175000000E+04, 4.6772673791E+01, 5.3327524522E+00, 2.8706889235E+01, 4.1028119957E+00, 9.8162744289E-01],
	[4.6180000000E+04, 4.6781679643E+01, 5.3328007600E+00, 2.8717075376E+01, 4.1031178864E+00, 9.8163500465E-01],
	[4.6185000000E+04, 4.6790686254E+01, 5.3328490631E+00, 2.8727264026E+01, 4.1034237021E+00, 9.8164256284E-01],
	[4.6190000000E+04, 4.6799693623E+01, 5.3328973613E+00, 2.8737455186E+01, 4.1037294429E+00, 9.8165011744E-01],
	[4.6195000000E+04, 4.6808701751E+01, 5.3329456548E+00, 2.8747648856E+01, 4.1040351089E+00, 9.8165766848E-01],
	[4.6200000000E+04, 4.6817710638E+01, 5.3329939435E+00, 2.8757845037E+01, 4.1043406999E+00, 9.8166521594E-01],
	[4.6205000000E+04, 4.6826720284E+01, 5.3330422273E+00, 2.8768043729E+01, 4.1046462162E+00, 9.8167275983E-01],
	[4.6210000000E+04, 4.6835730688E+01, 5.3330905064E+00, 2.8778244933E+01, 4.1049516576E+00, 9.8168030014E-01],
	[4.6215000000E+04, 4.6844741851E+01, 5.3331387808E+00, 2.8788448649E+01, 4.1052570243E+00, 9.8168783690E-01],
	[4.6220000000E+04, 4.6853753772E+01, 5.3331870503E+00, 2.8798654876E+01, 4.1055623162E+00, 9.8169537008E-01],
	[4.6225000000E+04, 4.6862766452E+01, 5.3332353150E+00, 2.8808863617E+01, 4.1058675333E+00, 9.8170289970E-01],
	[4.6230000000E+04, 4.6871779890E+01, 5.3332835750E+00, 2.8819074870E+01, 4.1061726756E+00, 9.8171042576E-01],
	[4.6235000000E+04, 4.6880794088E+01, 5.3333318302E+00, 2.8829288636E+01, 4.1064777433E+00, 9.8171794826E-01],
	[4.6240000000E+04, 4.6889809043E+01, 5.3333800806E+00, 2.8839504916E+01, 4.1067827363E+00, 9.8172546721E-01],
	[4.6245000000E+04, 4.6898824757E+01, 5.3334283262E+00, 2.8849723709E+01, 4.1070876546E+00, 9.8173298259E-01],
	[4.6250000000E+04, 4.6907841230E+01, 5.3334765670E+00, 2.8859945017E+01, 4.1073924982E+00, 9.8174049442E-01],
	[4.6255000000E+04, 4.6916858461E+01, 5.3335248031E+00, 2.8870168839E+01, 4.1076972673E+00, 9.8174800270E-01],
	[4.6260000000E+04, 4.6925876450E+01, 5.3335730344E+00, 2.8880395177E+01, 4.1080019617E+00, 9.8175550743E-01],
	[4.6265000000E+04, 4.6934895198E+01, 5.3336212609E+00, 2.8890624029E+01, 4.1083065815E+00, 9.8176300861E-01],
	[4.6270000000E+04, 4.6943914704E+01, 5.3336694826E+00, 2.8900855398E+01, 4.1086111268E+00, 9.8177050624E-01],
	[4.6275000000E+04, 4.6952934969E+01, 5.3337176995E+00, 2.8911089282E+01, 4.1089155975E+00, 9.8177800033E-01],
	[4.6280000000E+04, 4.6961955992E+01, 5.3337659117E+00, 2.8921325682E+01, 4.1092199936E+00, 9.8178549087E-01],
	[4.6285000000E+04, 4.6970977774E+01, 5.3338141191E+00, 2.8931564600E+01, 4.1095243153E+00, 9.8179297787E-01],
	[4.6290000000E+04, 4.6980000314E+01, 5.3338623218E+00, 2.8941806034E+01, 4.1098285625E+00, 9.8180046133E-01],
	[4.6295000000E+04, 4.6989023612E+01, 5.3339105196E+00, 2.8952049985E+01, 4.1101327352E+00, 9.8180794126E-01],
	[4.6300000000E+04, 4.6998047668E+01, 5.3339587127E+00, 2.8962296454E+01, 4.1104368335E+00, 9.8181541765E-01],
	[4.6305000000E+04, 4.7007072483E+01, 5.3340069010E+00, 2.8972545442E+01, 4.1107408573E+00, 9.8182289050E-01],
	[4.6310000000E+04, 4.7016098056E+01, 5.3340550846E+00, 2.8982796947E+01, 4.1110448067E+00, 9.8183035982E-01],
	[4.6315000000E+04, 4.7025124387E+01, 5.3341032634E+00, 2.8993050972E+01, 4.1113486818E+00, 9.8183782561E-01],
	[4.6320000000E+04, 4.7034151476E+01, 5.3341514374E+00, 2.9003307515E+01, 4.1116524825E+00, 9.8184528788E-01],
	[4.6325000000E+04, 4.7043179324E+01, 5.3341996067E+00, 2.9013566578E+01, 4.1119562088E+00, 9.8185274661E-01],
	[4.6330000000E+04, 4.7052207930E+01, 5.3342477712E+00, 2.9023828161E+01, 4.1122598609E+00, 9.8186020182E-01],
	[4.6335000000E+04, 4.7061237294E+01, 5.3342959309E+00, 2.9034092263E+01, 4.1125634386E+00, 9.8186765351E-01],
	[4.6340000000E+04, 4.7070267416E+01, 5.3343440859E+00, 2.9044358886E+01, 4.1128669420E+00, 9.8187510168E-01],
	[4.6345000000E+04, 4.7079298297E+01, 5.3343922361E+00, 2.9054628030E+01, 4.1131703712E+00, 9.8188254632E-01],
	[4.6350000000E+04, 4.7088329935E+01, 5.3344403815E+00, 2.9064899696E+01, 4.1134737262E+00, 9.8188998745E-01],
	[4.6355000000E+04, 4.7097362332E+01, 5.3344885222E+00, 2.9075173882E+01, 4.1137770069E+00, 9.8189742506E-01],
	[4.6360000000E+04, 4.7106395486E+01, 5.3345366581E+00, 2.9085450591E+01, 4.1140802134E+00, 9.8190485916E-01],
	[4.6365000000E+04, 4.7115429399E+01, 5.3345847893E+00, 2.9095729821E+01, 4.1143833457E+00, 9.8191228975E-01],
	[4.6370000000E+04, 4.7124464070E+01, 5.3346329157E+00, 2.9106011575E+01, 4.1146864039E+00, 9.8191971683E-01],
	[4.6375000000E+04, 4.7133499499E+01, 5.3346810374E+00, 2.9116295851E+01, 4.1149893880E+00, 9.8192714040E-01],
	[4.6380000000E+04, 4.7142535685E+01, 5.3347291543E+00, 2.9126582650E+01, 4.1152922979E+00, 9.8193456046E-01],
	[4.6385000000E+04, 4.7151572630E+01, 5.3347772665E+00, 2.9136871973E+01, 4.1155951337E+00, 9.8194197702E-01],
	[4.6390000000E+04, 4.7160610333E+01, 5.3348253739E+00, 2.9147163820E+01, 4.1158978955E+00, 9.8194939007E-01],
	[4.6395000000E+04, 4.7169648794E+01, 5.3348734765E+00, 2.9157458191E+01, 4.1162005832E+00, 9.8195679962E-01],
	[4.6400000000E+04, 4.7178688012E+01, 5.3349215744E+00, 2.9167755087E+01, 4.1165031968E+00, 9.8196420568E-01],
	[4.6405000000E+04, 4.7187727989E+01, 5.3349696676E+00, 2.9178054508E+01, 4.1168057365E+00, 9.8197160823E-01],
	[4.6410000000E+04, 4.7196768724E+01, 5.3350177560E+00, 2.9188356454E+01, 4.1171082021E+00, 9.8197900730E-01],
	[4.6415000000E+04, 4.7205810216E+01, 5.3350658397E+00, 2.9198660925E+01, 4.1174105938E+00, 9.8198640286E-01],
	[4.6420000000E+04, 4.7214852466E+01, 5.3351139186E+00, 2.9208967923E+01, 4.1177129115E+00, 9.8199379494E-01],
	[4.6425000000E+04, 4.7223895474E+01, 5.3351619927E+00, 2.9219277447E+01, 4.1180151553E+00, 9.8200118352E-01],
	[4.6430000000E+04, 4.7232939240E+01, 5.3352100622E+00, 2.9229589498E+01, 4.1183173252E+00, 9.8200856862E-01],
	[4.6435000000E+04, 4.7241983764E+01, 5.3352581268E+00, 2.9239904076E+01, 4.1186194212E+00, 9.8201595023E-01],
	[4.6440000000E+04, 4.7251029046E+01, 5.3353061868E+00, 2.9250221181E+01, 4.1189214433E+00, 9.8202332836E-01],
	[4.6445000000E+04, 4.7260075085E+01, 5.3353542420E+00, 2.9260540814E+01, 4.1192233916E+00, 9.8203070300E-01],
	[4.6450000000E+04, 4.7269121882E+01, 5.3354022924E+00, 2.9270862975E+01, 4.1195252660E+00, 9.8203807416E-01],
	[4.6455000000E+04, 4.7278169437E+01, 5.3354503382E+00, 2.9281187664E+01, 4.1198270666E+00, 9.8204544184E-01],
	[4.6460000000E+04, 4.7287217750E+01, 5.3354983791E+00, 2.9291514882E+01, 4.1201287935E+00, 9.8205280605E-01],
	[4.6465000000E+04, 4.7296266820E+01, 5.3355464154E+00, 2.9301844630E+01, 4.1204304465E+00, 9.8206016678E-01],
	[4.6470000000E+04, 4.7305316648E+01, 5.3355944469E+00, 2.9312176907E+01, 4.1207320258E+00, 9.8206752404E-01],
	[4.6475000000E+04, 4.7314367234E+01, 5.3356424737E+00, 2.9322511713E+01, 4.1210335314E+00, 9.8207487782E-01],
	[4.6480000000E+04, 4.7323418577E+01, 5.3356904957E+00, 2.9332849050E+01, 4.1213349633E+00, 9.8208222814E-01],
	[4.6485000000E+04, 4.7332470678E+01, 5.3357385130E+00, 2.9343188917E+01, 4.1216363215E+00, 9.8208957498E-01],
	[4.6490000000E+04, 4.7341523536E+01, 5.3357865256E+00, 2.9353531316E+01, 4.1219376060E+00, 9.8209691836E-01],
	[4.6495000000E+04, 4.7350577152E+01, 5.3358345334E+00, 2.9363876245E+01, 4.1222388169E+00, 9.8210425828E-01],
	[4.6500000000E+04, 4.7359631526E+01, 5.3358825365E+00, 2.9374223706E+01, 4.1225399541E+00, 9.8211159473E-01],
	[4.6505000000E+04, 4.7368686657E+01, 5.3359305349E+00, 2.9384573699E+01, 4.1228410178E+00, 9.8211892772E-01],
	[4.6510000000E+04, 4.7377742546E+01, 5.3359785285E+00, 2.9394926224E+01, 4.1231420078E+00, 9.8212625726E-01],
	[4.6515000000E+04, 4.7386799193E+01, 5.3360265175E+00, 2.9405281281E+01, 4.1234429243E+00, 9.8213358333E-01],
	[4.6520000000E+04, 4.7395856596E+01, 5.3360745017E+00, 2.9415638872E+01, 4.1237437672E+00, 9.8214090595E-01],
	[4.6525000000E+04, 4.7404914758E+01, 5.3361224811E+00, 2.9425998996E+01, 4.1240445367E+00, 9.8214822512E-01],
	[4.6530000000E+04, 4.7413973677E+01, 5.3361704559E+00, 2.9436361654E+01, 4.1243452326E+00, 9.8215554083E-01],
	[4.6535000000E+04, 4.7423033353E+01, 5.3362184259E+00, 2.9446726845E+01, 4.1246458550E+00, 9.8216285310E-01],
	[4.6540000000E+04, 4.7432093787E+01, 5.3362663912E+00, 2.9457094571E+01, 4.1249464040E+00, 9.8217016192E-01],
	[4.6545000000E+04, 4.7441154978E+01, 5.3363143518E+00, 2.9467464831E+01, 4.1252468795E+00, 9.8217746729E-01],
	[4.6550000000E+04, 4.7450216926E+01, 5.3363623076E+00, 2.9477837627E+01, 4.1255472816E+00, 9.8218476921E-01],
	[4.6555000000E+04, 4.7459279632E+01, 5.3364102588E+00, 2.9488212958E+01, 4.1258476103E+00, 9.8219206769E-01],
	[4.6560000000E+04, 4.7468343095E+01, 5.3364582052E+00, 2.9498590824E+01, 4.1261478656E+00, 9.8219936274E-01],
	[4.6565000000E+04, 4.7477407316E+01, 5.3365061469E+00, 2.9508971227E+01, 4.1264480475E+00, 9.8220665434E-01],
	[4.6570000000E+04, 4.7486472294E+01, 5.3365540839E+00, 2.9519354166E+01, 4.1267481561E+00, 9.8221394251E-01],
	[4.6575000000E+04, 4.7495538029E+01, 5.3366020161E+00, 2.9529739642E+01, 4.1270481914E+00, 9.8222122724E-01],
	[4.6580000000E+04, 4.7504604522E+01, 5.3366499437E+00, 2.9540127655E+01, 4.1273481534E+00, 9.8222850853E-01],
	[4.6585000000E+04, 4.7513671772E+01, 5.3366978665E+00, 2.9550518205E+01, 4.1276480421E+00, 9.8223578640E-01],
	[4.6590000000E+04, 4.7522739779E+01, 5.3367457846E+00, 2.9560911293E+01, 4.1279478575E+00, 9.8224306083E-01],
	[4.6595000000E+04, 4.7531808543E+01, 5.3367936981E+00, 2.9571306920E+01, 4.1282475997E+00, 9.8225033184E-01],
	[4.6600000000E+04, 4.7540878064E+01, 5.3368416068E+00, 2.9581705085E+01, 4.1285472687E+00, 9.8225759942E-01],
	[4.6605000000E+04, 4.7549948343E+01, 5.3368895108E+00, 2.9592105788E+01, 4.1288468645E+00, 9.8226486357E-01],
	[4.6610000000E+04, 4.7559019379E+01, 5.3369374100E+00, 2.9602509031E+01, 4.1291463871E+00, 9.8227212430E-01],
	[4.6615000000E+04, 4.7568091172E+01, 5.3369853046E+00, 2.9612914813E+01, 4.1294458366E+00, 9.8227938162E-01],
	[4.6620000000E+04, 4.7577163722E+01, 5.3370331945E+00, 2.9623323136E+01, 4.1297452129E+00, 9.8228663551E-01],
	[4.6625000000E+04, 4.7586237030E+01, 5.3370810796E+00, 2.9633733998E+01, 4.1300445161E+00, 9.8229388598E-01],
	[4.6630000000E+04, 4.7595311094E+01, 5.3371289601E+00, 2.9644147401E+01, 4.1303437462E+00, 9.8230113304E-01],
	[4.6635000000E+04, 4.7604385916E+01, 5.3371768358E+00, 2.9654563345E+01, 4.1306429032E+00, 9.8230837669E-01],
	[4.6640000000E+04, 4.7613461494E+01, 5.3372247069E+00, 2.9664981830E+01, 4.1309419871E+00, 9.8231561692E-01],
	[4.6645000000E+04, 4.7622537830E+01, 5.3372725732E+00, 2.9675402857E+01, 4.1312409981E+00, 9.8232285374E-01],
	[4.6650000000E+04, 4.7631614923E+01, 5.3373204349E+00, 2.9685826426E+01, 4.1315399360E+00, 9.8233008716E-01],
	[4.6655000000E+04, 4.7640692772E+01, 5.3373682918E+00, 2.9696252537E+01, 4.1318388009E+00, 9.8233731717E-01],
	[4.6660000000E+04, 4.7649771379E+01, 5.3374161441E+00, 2.9706681191E+01, 4.1321375928E+00, 9.8234454377E-01],
	[4.6665000000E+04, 4.7658850743E+01, 5.3374639916E+00, 2.9717112387E+01, 4.1324363118E+00, 9.8235176697E-01],
	[4.6670000000E+04, 4.7667930863E+01, 5.3375118345E+00, 2.9727546128E+01, 4.1327349578E+00, 9.8235898677E-01],
	[4.6675000000E+04, 4.7677011741E+01, 5.3375596726E+00, 2.9737982411E+01, 4.1330335309E+00, 9.8236620317E-01],
	[4.6680000000E+04, 4.7686093375E+01, 5.3376075061E+00, 2.9748421239E+01, 4.1333320312E+00, 9.8237341617E-01],
	[4.6685000000E+04, 4.7695175767E+01, 5.3376553348E+00, 2.9758862611E+01, 4.1336304585E+00, 9.8238062578E-01],
	[4.6690000000E+04, 4.7704258915E+01, 5.3377031589E+00, 2.9769306528E+01, 4.1339288130E+00, 9.8238783199E-01],
	[4.6695000000E+04, 4.7713342821E+01, 5.3377509783E+00, 2.9779752990E+01, 4.1342270947E+00, 9.8239503481E-01],
	[4.6700000000E+04, 4.7722427483E+01, 5.3377987930E+00, 2.9790201998E+01, 4.1345253035E+00, 9.8240223424E-01],
	[4.6705000000E+04, 4.7731512902E+01, 5.3378466029E+00, 2.9800653551E+01, 4.1348234396E+00, 9.8240943028E-01],
	[4.6710000000E+04, 4.7740599077E+01, 5.3378944082E+00, 2.9811107650E+01, 4.1351215029E+00, 9.8241662294E-01],
	[4.6715000000E+04, 4.7749686010E+01, 5.3379422089E+00, 2.9821564296E+01, 4.1354194934E+00, 9.8242381221E-01],
	[4.6720000000E+04, 4.7758773699E+01, 5.3379900048E+00, 2.9832023489E+01, 4.1357174112E+00, 9.8243099809E-01],
	[4.6725000000E+04, 4.7767862145E+01, 5.3380377960E+00, 2.9842485229E+01, 4.1360152563E+00, 9.8243818060E-01],
	[4.6730000000E+04, 4.7776951348E+01, 5.3380855826E+00, 2.9852949516E+01, 4.1363130287E+00, 9.8244535972E-01],
	[4.6735000000E+04, 4.7786041308E+01, 5.3381333644E+00, 2.9863416351E+01, 4.1366107284E+00, 9.8245253547E-01],
	[4.6740000000E+04, 4.7795132024E+01, 5.3381811416E+00, 2.9873885735E+01, 4.1369083555E+00, 9.8245970784E-01],
	[4.6745000000E+04, 4.7804223497E+01, 5.3382289141E+00, 2.9884357666E+01, 4.1372059099E+00, 9.8246687684E-01],
	[4.6750000000E+04, 4.7813315727E+01, 5.3382766819E+00, 2.9894832147E+01, 4.1375033917E+00, 9.8247404246E-01],
	[4.6755000000E+04, 4.7822408713E+01, 5.3383244451E+00, 2.9905309177E+01, 4.1378008010E+00, 9.8248120471E-01],
	[4.6760000000E+04, 4.7831502456E+01, 5.3383722035E+00, 2.9915788757E+01, 4.1380981376E+00, 9.8248836360E-01],
	[4.6765000000E+04, 4.7840596956E+01, 5.3384199573E+00, 2.9926270887E+01, 4.1383954017E+00, 9.8249551912E-01],
	[4.6770000000E+04, 4.7849692212E+01, 5.3384677064E+00, 2.9936755567E+01, 4.1386925933E+00, 9.8250267127E-01],
	[4.6775000000E+04, 4.7858798150E+01, 5.3385164473E+00, 2.9947242797E+01, 4.1389903856E+00, 9.8250982006E-01],
	[4.6780000000E+04, 4.7867912370E+01, 5.3385659386E+00, 2.9957732579E+01, 4.1392886157E+00, 9.8251696548E-01],
	[4.6785000000E+04, 4.7877027352E+01, 5.3386154251E+00, 2.9968224912E+01, 4.1395867736E+00, 9.8252410755E-01],
	[4.6790000000E+04, 4.7886143095E+01, 5.3386649068E+00, 2.9978719796E+01, 4.1398848591E+00, 9.8253124626E-01],
	[4.6795000000E+04, 4.7895259599E+01, 5.3387143836E+00, 2.9989217233E+01, 4.1401828723E+00, 9.8253838161E-01],
	[4.6800000000E+04, 4.7904376864E+01, 5.3387638556E+00, 2.9999717222E+01, 4.1404808132E+00, 9.8254551361E-01],
	[4.6805000000E+04, 4.7913494891E+01, 5.3388133228E+00, 3.0010219763E+01, 4.1407786819E+00, 9.8255264226E-01],
	[4.6810000000E+04, 4.7922613679E+01, 5.3388627851E+00, 3.0020724858E+01, 4.1410764784E+00, 9.8255976755E-01],
	[4.6815000000E+04, 4.7931733228E+01, 5.3389122426E+00, 3.0031232506E+01, 4.1413742027E+00, 9.8256688949E-01],
	[4.6820000000E+04, 4.7940853539E+01, 5.3389616953E+00, 3.0041742708E+01, 4.1416718548E+00, 9.8257400809E-01],
	[4.6825000000E+04, 4.7949974610E+01, 5.3390111432E+00, 3.0052255464E+01, 4.1419694347E+00, 9.8258112334E-01],
	[4.6830000000E+04, 4.7959096443E+01, 5.3390605862E+00, 3.0062770775E+01, 4.1422669425E+00, 9.8258823525E-01],
	[4.6835000000E+04, 4.7968219037E+01, 5.3391100245E+00, 3.0073288640E+01, 4.1425643781E+00, 9.8259534381E-01],
	[4.6840000000E+04, 4.7977342392E+01, 5.3391594579E+00, 3.0083809061E+01, 4.1428617417E+00, 9.8260244904E-01],
	[4.6845000000E+04, 4.7986466508E+01, 5.3392088865E+00, 3.0094332037E+01, 4.1431590331E+00, 9.8260955093E-01],
	[4.6850000000E+04, 4.7995591385E+01, 5.3392583102E+00, 3.0104857568E+01, 4.1434562525E+00, 9.8261664947E-01],
	[4.6855000000E+04, 4.8004717024E+01, 5.3393077292E+00, 3.0115385656E+01, 4.1437533999E+00, 9.8262374469E-01],
	[4.6860000000E+04, 4.8013843423E+01, 5.3393571433E+00, 3.0125916301E+01, 4.1440504752E+00, 9.8263083657E-01],
	[4.6865000000E+04, 4.8022970583E+01, 5.3394065527E+00, 3.0136449502E+01, 4.1443474785E+00, 9.8263792512E-01],
	[4.6870000000E+04, 4.8032098505E+01, 5.3394559572E+00, 3.0146985261E+01, 4.1446444099E+00, 9.8264501034E-01],
	[4.6875000000E+04, 4.8041227187E+01, 5.3395053569E+00, 3.0157523577E+01, 4.1449412693E+00, 9.8265209223E-01],
	[4.6880000000E+04, 4.8050356631E+01, 5.3395547518E+00, 3.0168064451E+01, 4.1452380567E+00, 9.8265917080E-01],
	[4.6885000000E+04, 4.8059486835E+01, 5.3396041418E+00, 3.0178607884E+01, 4.1455347722E+00, 9.8266624604E-01],
	[4.6890000000E+04, 4.8068617800E+01, 5.3396535271E+00, 3.0189153875E+01, 4.1458314158E+00, 9.8267331796E-01],
	[4.6895000000E+04, 4.8077749527E+01, 5.3397029075E+00, 3.0199702425E+01, 4.1461279875E+00, 9.8268038655E-01],
	[4.6900000000E+04, 4.8086882014E+01, 5.3397522832E+00, 3.0210253534E+01, 4.1464244874E+00, 9.8268745183E-01],
	[4.6905000000E+04, 4.8096015262E+01, 5.3398016540E+00, 3.0220807204E+01, 4.1467209154E+00, 9.8269451379E-01],
	[4.6910000000E+04, 4.8105149271E+01, 5.3398510201E+00, 3.0231363433E+01, 4.1470172716E+00, 9.8270157244E-01],
	[4.6915000000E+04, 4.8114284041E+01, 5.3399003813E+00, 3.0241922222E+01, 4.1473135559E+00, 9.8270862777E-01],
	[4.6920000000E+04, 4.8123419572E+01, 5.3399497377E+00, 3.0252483572E+01, 4.1476097685E+00, 9.8271567979E-01],
	[4.6925000000E+04, 4.8132555863E+01, 5.3399990893E+00, 3.0263047483E+01, 4.1479059094E+00, 9.8272272850E-01],
	[4.6930000000E+04, 4.8141692915E+01, 5.3400484362E+00, 3.0273613956E+01, 4.1482019784E+00, 9.8272977390E-01],
	[4.6935000000E+04, 4.8150830729E+01, 5.3400977782E+00, 3.0284182990E+01, 4.1484979758E+00, 9.8273681599E-01],
	[4.6940000000E+04, 4.8159969303E+01, 5.3401471154E+00, 3.0294754587E+01, 4.1487939015E+00, 9.8274385478E-01],
	[4.6945000000E+04, 4.8169108637E+01, 5.3401964478E+00, 3.0305328746E+01, 4.1490897554E+00, 9.8275089027E-01],
	[4.6950000000E+04, 4.8178248733E+01, 5.3402457754E+00, 3.0315905468E+01, 4.1493855377E+00, 9.8275792245E-01],
	[4.6955000000E+04, 4.8187389589E+01, 5.3402950983E+00, 3.0326484753E+01, 4.1496812484E+00, 9.8276495134E-01],
	[4.6960000000E+04, 4.8196531206E+01, 5.3403444163E+00, 3.0337066601E+01, 4.1499768874E+00, 9.8277197692E-01],
	[4.6965000000E+04, 4.8205673583E+01, 5.3403937295E+00, 3.0347651013E+01, 4.1502724549E+00, 9.8277899921E-01],
	[4.6970000000E+04, 4.8214816721E+01, 5.3404430379E+00, 3.0358237990E+01, 4.1505679507E+00, 9.8278601821E-01],
	[4.6975000000E+04, 4.8223960620E+01, 5.3404923416E+00, 3.0368827531E+01, 4.1508633750E+00, 9.8279303391E-01],
	[4.6980000000E+04, 4.8233105280E+01, 5.3405416404E+00, 3.0379419636E+01, 4.1511587277E+00, 9.8280004632E-01],
	[4.6985000000E+04, 4.8242250700E+01, 5.3405909345E+00, 3.0390014307E+01, 4.1514540089E+00, 9.8280705545E-01],
	[4.6990000000E+04, 4.8251396880E+01, 5.3406402238E+00, 3.0400611544E+01, 4.1517492186E+00, 9.8281406128E-01],
	[4.6995000000E+04, 4.8260543822E+01, 5.3406895082E+00, 3.0411211347E+01, 4.1520443569E+00, 9.8282106383E-01],
	[4.7000000000E+04, 4.8269691524E+01, 5.3407387879E+00, 3.0421813716E+01, 4.1523394236E+00, 9.8282806310E-01],
	[4.7005000000E+04, 4.8278839986E+01, 5.3407880628E+00, 3.0432418651E+01, 4.1526344189E+00, 9.8283505908E-01],
	[4.7010000000E+04, 4.8287989209E+01, 5.3408373329E+00, 3.0443026153E+01, 4.1529293428E+00, 9.8284205179E-01],
	[4.7015000000E+04, 4.8297139192E+01, 5.3408865983E+00, 3.0453636223E+01, 4.1532241953E+00, 9.8284904121E-01],
	[4.7020000000E+04, 4.8306289936E+01, 5.3409358588E+00, 3.0464248861E+01, 4.1535189764E+00, 9.8285602736E-01],
	[4.7025000000E+04, 4.8315441441E+01, 5.3409851146E+00, 3.0474864066E+01, 4.1538136861E+00, 9.8286301024E-01],
	[4.7030000000E+04, 4.8324593706E+01, 5.3410343656E+00, 3.0485481840E+01, 4.1541083245E+00, 9.8286998984E-01],
	[4.7035000000E+04, 4.8333746731E+01, 5.3410836118E+00, 3.0496102182E+01, 4.1544028915E+00, 9.8287696616E-01],
	[4.7040000000E+04, 4.8342900517E+01, 5.3411328532E+00, 3.0506725094E+01, 4.1546973873E+00, 9.8288393922E-01],
	[4.7045000000E+04, 4.8352055063E+01, 5.3411820898E+00, 3.0517350575E+01, 4.1549918117E+00, 9.8289090901E-01],
	[4.7050000000E+04, 4.8361210369E+01, 5.3412313217E+00, 3.0527978626E+01, 4.1552861649E+00, 9.8289787554E-01],
	[4.7055000000E+04, 4.8370366436E+01, 5.3412805487E+00, 3.0538609247E+01, 4.1555804468E+00, 9.8290483880E-01],
	[4.7060000000E+04, 4.8379523263E+01, 5.3413297711E+00, 3.0549242438E+01, 4.1558746576E+00, 9.8291179879E-01],
	[4.7065000000E+04, 4.8388680851E+01, 5.3413789886E+00, 3.0559878200E+01, 4.1561687971E+00, 9.8291875553E-01],
	[4.7070000000E+04, 4.8397839199E+01, 5.3414282013E+00, 3.0570516533E+01, 4.1564628654E+00, 9.8292570900E-01],
	[4.7075000000E+04, 4.8406998307E+01, 5.3414774093E+00, 3.0581157438E+01, 4.1567568625E+00, 9.8293265922E-01],
	[4.7080000000E+04, 4.8416158175E+01, 5.3415266125E+00, 3.0591800915E+01, 4.1570507886E+00, 9.8293960618E-01],
	[4.7085000000E+04, 4.8425318804E+01, 5.3415758109E+00, 3.0602446963E+01, 4.1573446434E+00, 9.8294654989E-01],
	[4.7090000000E+04, 4.8434480193E+01, 5.3416250046E+00, 3.0613095585E+01, 4.1576384272E+00, 9.8295349035E-01],
	[4.7095000000E+04, 4.8443642342E+01, 5.3416741935E+00, 3.0623746779E+01, 4.1579321399E+00, 9.8296042755E-01],
	[4.7100000000E+04, 4.8452805252E+01, 5.3417233776E+00, 3.0634400546E+01, 4.1582257815E+00, 9.8296736151E-01],
	[4.7105000000E+04, 4.8461968921E+01, 5.3417725570E+00, 3.0645056887E+01, 4.1585193521E+00, 9.8297429222E-01],
	[4.7110000000E+04, 4.8471133351E+01, 5.3418217316E+00, 3.0655715802E+01, 4.1588128516E+00, 9.8298121968E-01],
	[4.7115000000E+04, 4.8480298541E+01, 5.3418709014E+00, 3.0666377291E+01, 4.1591062801E+00, 9.8298814390E-01],
	[4.7120000000E+04, 4.8489464491E+01, 5.3419200664E+00, 3.0677041355E+01, 4.1593996377E+00, 9.8299506488E-01],
	[4.7125000000E+04, 4.8498631201E+01, 5.3419692267E+00, 3.0687707994E+01, 4.1596929242E+00, 9.8300198262E-01],
	[4.7130000000E+04, 4.8507798672E+01, 5.3420183823E+00, 3.0698377208E+01, 4.1599861399E+00, 9.8300889712E-01],
	[4.7135000000E+04, 4.8516966902E+01, 5.3420675330E+00, 3.0709048998E+01, 4.1602792846E+00, 9.8301580838E-01],
	[4.7140000000E+04, 4.8526135893E+01, 5.3421166790E+00, 3.0719723364E+01, 4.1605723583E+00, 9.8302271641E-01],
	[4.7145000000E+04, 4.8535305643E+01, 5.3421658203E+00, 3.0730400306E+01, 4.1608653612E+00, 9.8302962120E-01],
	[4.7150000000E+04, 4.8544476154E+01, 5.3422149568E+00, 3.0741079825E+01, 4.1611582933E+00, 9.8303652277E-01],
	[4.7155000000E+04, 4.8553647424E+01, 5.3422640885E+00, 3.0751761921E+01, 4.1614511544E+00, 9.8304342110E-01],
	[4.7160000000E+04, 4.8562819455E+01, 5.3423132155E+00, 3.0762446594E+01, 4.1617439448E+00, 9.8305031620E-01],
	[4.7165000000E+04, 4.8571992245E+01, 5.3423623377E+00, 3.0773133845E+01, 4.1620366643E+00, 9.8305720808E-01],
	[4.7170000000E+04, 4.8581165796E+01, 5.3424114551E+00, 3.0783823674E+01, 4.1623293131E+00, 9.8306409674E-01],
	[4.7175000000E+04, 4.8590340106E+01, 5.3424605678E+00, 3.0794516082E+01, 4.1626218910E+00, 9.8307098217E-01],
	[4.7180000000E+04, 4.8599515177E+01, 5.3425096758E+00, 3.0805211068E+01, 4.1629143982E+00, 9.8307786438E-01],
	[4.7185000000E+04, 4.8608691007E+01, 5.3425587790E+00, 3.0815908634E+01, 4.1632068347E+00, 9.8308474337E-01],
	[4.7190000000E+04, 4.8617867597E+01, 5.3426078774E+00, 3.0826608779E+01, 4.1634992005E+00, 9.8309161914E-01],
	[4.7195000000E+04, 4.8627044947E+01, 5.3426569711E+00, 3.0837311504E+01, 4.1637914956E+00, 9.8309849170E-01],
	[4.7200000000E+04, 4.8636223057E+01, 5.3427060600E+00, 3.0848016809E+01, 4.1640837200E+00, 9.8310536104E-01],
	[4.7205000000E+04, 4.8645401927E+01, 5.3427551442E+00, 3.0858724695E+01, 4.1643758738E+00, 9.8311222717E-01],
	[4.7210000000E+04, 4.8654581556E+01, 5.3428042237E+00, 3.0869435161E+01, 4.1646679569E+00, 9.8311909009E-01],
	[4.7215000000E+04, 4.8663761946E+01, 5.3428532984E+00, 3.0880148209E+01, 4.1649599694E+00, 9.8312594980E-01],
	[4.7220000000E+04, 4.8672943095E+01, 5.3429023683E+00, 3.0890863838E+01, 4.1652519113E+00, 9.8313280631E-01],
	[4.7225000000E+04, 4.8682125004E+01, 5.3429514335E+00, 3.0901582050E+01, 4.1655437827E+00, 9.8313965960E-01],
	[4.7230000000E+04, 4.8691307673E+01, 5.3430004940E+00, 3.0912302843E+01, 4.1658355834E+00, 9.8314650970E-01],
	[4.7235000000E+04, 4.8700491101E+01, 5.3430495497E+00, 3.0923026220E+01, 4.1661273137E+00, 9.8315335659E-01],
	[4.7240000000E+04, 4.8709675289E+01, 5.3430986007E+00, 3.0933752179E+01, 4.1664189734E+00, 9.8316020028E-01],
	[4.7245000000E+04, 4.8718860237E+01, 5.3431476469E+00, 3.0944480721E+01, 4.1667105627E+00, 9.8316704077E-01],
	[4.7250000000E+04, 4.8728045945E+01, 5.3431966884E+00, 3.0955211848E+01, 4.1670020815E+00, 9.8317387807E-01],
	[4.7255000000E+04, 4.8737232412E+01, 5.3432457252E+00, 3.0965945558E+01, 4.1672935298E+00, 9.8318071217E-01],
	[4.7260000000E+04, 4.8746419639E+01, 5.3432947572E+00, 3.0976681853E+01, 4.1675849077E+00, 9.8318754307E-01],
	[4.7265000000E+04, 4.8755607625E+01, 5.3433437845E+00, 3.0987420732E+01, 4.1678762151E+00, 9.8319437079E-01],
	[4.7270000000E+04, 4.8764796371E+01, 5.3433928070E+00, 3.0998162196E+01, 4.1681674522E+00, 9.8320119531E-01],
	[4.7275000000E+04, 4.8773985877E+01, 5.3434418249E+00, 3.1008906246E+01, 4.1684586189E+00, 9.8320801665E-01],
	[4.7280000000E+04, 4.8783176142E+01, 5.3434908379E+00, 3.1019652882E+01, 4.1687497152E+00, 9.8321483480E-01],
	[4.7285000000E+04, 4.8792367167E+01, 5.3435398463E+00, 3.1030402103E+01, 4.1690407412E+00, 9.8322164976E-01],
	[4.7290000000E+04, 4.8801558952E+01, 5.3435888499E+00, 3.1041153912E+01, 4.1693316969E+00, 9.8322846155E-01],
	[4.7295000000E+04, 4.8810751496E+01, 5.3436378488E+00, 3.1051908306E+01, 4.1696225823E+00, 9.8323527015E-01],
	[4.7300000000E+04, 4.8819944799E+01, 5.3436868429E+00, 3.1062665289E+01, 4.1699133974E+00, 9.8324207557E-01],
	[4.7305000000E+04, 4.8829138862E+01, 5.3437358323E+00, 3.1073424858E+01, 4.1702041423E+00, 9.8324887781E-01],
	[4.7310000000E+04, 4.8838333684E+01, 5.3437848170E+00, 3.1084187016E+01, 4.1704948169E+00, 9.8325567687E-01],
	[4.7315000000E+04, 4.8847529266E+01, 5.3438337970E+00, 3.1094951761E+01, 4.1707854213E+00, 9.8326247277E-01],
	[4.7320000000E+04, 4.8856725607E+01, 5.3438827722E+00, 3.1105719096E+01, 4.1710759555E+00, 9.8326926548E-01],
	[4.7325000000E+04, 4.8865922708E+01, 5.3439317427E+00, 3.1116489019E+01, 4.1713664195E+00, 9.8327605503E-01],
	[4.7330000000E+04, 4.8875120568E+01, 5.3439807085E+00, 3.1127261531E+01, 4.1716568133E+00, 9.8328284141E-01],
	[4.7335000000E+04, 4.8884319188E+01, 5.3440296696E+00, 3.1138036633E+01, 4.1719471370E+00, 9.8328962462E-01],
	[4.7340000000E+04, 4.8893518566E+01, 5.3440786259E+00, 3.1148814325E+01, 4.1722373906E+00, 9.8329640466E-01],
	[4.7345000000E+04, 4.8902718705E+01, 5.3441275775E+00, 3.1159594607E+01, 4.1725275741E+00, 9.8330318154E-01],
	[4.7350000000E+04, 4.8911919602E+01, 5.3441765244E+00, 3.1170377480E+01, 4.1728176875E+00, 9.8330995525E-01],
	[4.7355000000E+04, 4.8921121259E+01, 5.3442254666E+00, 3.1181162944E+01, 4.1731077309E+00, 9.8331672581E-01],
	[4.7360000000E+04, 4.8930323675E+01, 5.3442744040E+00, 3.1191950999E+01, 4.1733977042E+00, 9.8332349321E-01],
	[4.7365000000E+04, 4.8939526850E+01, 5.3443233368E+00, 3.1202741646E+01, 4.1736876075E+00, 9.8333025744E-01],
	[4.7370000000E+04, 4.8948730785E+01, 5.3443722648E+00, 3.1213534885E+01, 4.1739774407E+00, 9.8333701853E-01],
	[4.7375000000E+04, 4.8957935479E+01, 5.3444211881E+00, 3.1224330716E+01, 4.1742672040E+00, 9.8334377645E-01],
	[4.7380000000E+04, 4.8967140932E+01, 5.3444701067E+00, 3.1235129140E+01, 4.1745568974E+00, 9.8335053123E-01],
	[4.7385000000E+04, 4.8976347144E+01, 5.3445190206E+00, 3.1245930157E+01, 4.1748465208E+00, 9.8335728285E-01],
	[4.7390000000E+04, 4.8985554116E+01, 5.3445679297E+00, 3.1256733768E+01, 4.1751360742E+00, 9.8336403133E-01],
	[4.7395000000E+04, 4.8994761847E+01, 5.3446168342E+00, 3.1267539972E+01, 4.1754255578E+00, 9.8337077666E-01],
	[4.7400000000E+04, 4.9003970337E+01, 5.3446657339E+00, 3.1278348771E+01, 4.1757149715E+00, 9.8337751884E-01],
	[4.7405000000E+04, 4.9013179586E+01, 5.3447146289E+00, 3.1289160164E+01, 4.1760043153E+00, 9.8338425788E-01],
	[4.7410000000E+04, 4.9022389594E+01, 5.3447635193E+00, 3.1299974151E+01, 4.1762935892E+00, 9.8339099378E-01],
	[4.7415000000E+04, 4.9031600361E+01, 5.3448124049E+00, 3.1310790734E+01, 4.1765827934E+00, 9.8339772653E-01],
	[4.7420000000E+04, 4.9040811887E+01, 5.3448612858E+00, 3.1321609913E+01, 4.1768719277E+00, 9.8340445615E-01],
	[4.7425000000E+04, 4.9050024173E+01, 5.3449101620E+00, 3.1332431687E+01, 4.1771609922E+00, 9.8341118263E-01],
	[4.7430000000E+04, 4.9059237217E+01, 5.3449590334E+00, 3.1343256058E+01, 4.1774499870E+00, 9.8341790597E-01],
	[4.7435000000E+04, 4.9068451021E+01, 5.3450079002E+00, 3.1354083025E+01, 4.1777389120E+00, 9.8342462618E-01],
	[4.7440000000E+04, 4.9077665583E+01, 5.3450567623E+00, 3.1364912589E+01, 4.1780277673E+00, 9.8343134326E-01],
	[4.7445000000E+04, 4.9086880905E+01, 5.3451056197E+00, 3.1375744750E+01, 4.1783165529E+00, 9.8343805721E-01],
	[4.7450000000E+04, 4.9096096985E+01, 5.3451544723E+00, 3.1386579509E+01, 4.1786052688E+00, 9.8344476803E-01],
	[4.7455000000E+04, 4.9105313824E+01, 5.3452033203E+00, 3.1397416866E+01, 4.1788939150E+00, 9.8345147572E-01],
	[4.7460000000E+04, 4.9114531423E+01, 5.3452521636E+00, 3.1408256821E+01, 4.1791824916E+00, 9.8345818029E-01],
	[4.7465000000E+04, 4.9123749780E+01, 5.3453010022E+00, 3.1419099375E+01, 4.1794709986E+00, 9.8346488173E-01],
	[4.7470000000E+04, 4.9132968896E+01, 5.3453498360E+00, 3.1429944528E+01, 4.1797594359E+00, 9.8347158005E-01],
	[4.7475000000E+04, 4.9142188772E+01, 5.3453986652E+00, 3.1440792280E+01, 4.1800478037E+00, 9.8347827525E-01],
	[4.7480000000E+04, 4.9151409406E+01, 5.3454474897E+00, 3.1451642632E+01, 4.1803361018E+00, 9.8348496733E-01],
	[4.7485000000E+04, 4.9160630798E+01, 5.3454963095E+00, 3.1462495584E+01, 4.1806243304E+00, 9.8349165630E-01],
	[4.7490000000E+04, 4.9169852950E+01, 5.3455451246E+00, 3.1473351136E+01, 4.1809124895E+00, 9.8349834215E-01],
	[4.7495000000E+04, 4.9179075861E+01, 5.3455939350E+00, 3.1484209289E+01, 4.1812005791E+00, 9.8350502488E-01],
	[4.7500000000E+04, 4.9188299530E+01, 5.3456427407E+00, 3.1495070043E+01, 4.1814885992E+00, 9.8351170451E-01],
	[4.7505000000E+04, 4.9197523958E+01, 5.3456915417E+00, 3.1505933399E+01, 4.1817765498E+00, 9.8351838102E-01],
	[4.7510000000E+04, 4.9206749145E+01, 5.3457403380E+00, 3.1516799356E+01, 4.1820644309E+00, 9.8352505443E-01],
	[4.7515000000E+04, 4.9215975091E+01, 5.3457891296E+00, 3.1527667916E+01, 4.1823522427E+00, 9.8353172473E-01],
	[4.7520000000E+04, 4.9225201795E+01, 5.3458379166E+00, 3.1538539078E+01, 4.1826399850E+00, 9.8353839192E-01],
	[4.7525000000E+04, 4.9234429258E+01, 5.3458866988E+00, 3.1549412843E+01, 4.1829276579E+00, 9.8354505601E-01],
	[4.7530000000E+04, 4.9243674486E+01, 5.3459371479E+00, 3.1560289211E+01, 4.1832164076E+00, 9.8355171700E-01],
	[4.7535000000E+04, 4.9252920908E+01, 5.3459876345E+00, 3.1571168183E+01, 4.1835051171E+00, 9.8355837489E-01],
	[4.7540000000E+04, 4.9262168094E+01, 5.3460381163E+00, 3.1582049758E+01, 4.1837937575E+00, 9.8356502968E-01],
	[4.7545000000E+04, 4.9271416043E+01, 5.3460885932E+00, 3.1592933938E+01, 4.1840823286E+00, 9.8357168137E-01],
	[4.7550000000E+04, 4.9280664756E+01, 5.3461390653E+00, 3.1603820722E+01, 4.1843708306E+00, 9.8357832997E-01],
	[4.7555000000E+04, 4.9289914231E+01, 5.3461895326E+00, 3.1614710112E+01, 4.1846592635E+00, 9.8358497548E-01],
	[4.7560000000E+04, 4.9299164470E+01, 5.3462399950E+00, 3.1625602106E+01, 4.1849476272E+00, 9.8359161789E-01],
	[4.7565000000E+04, 4.9308415473E+01, 5.3462904526E+00, 3.1636496706E+01, 4.1852359218E+00, 9.8359825721E-01],
	[4.7570000000E+04, 4.9317667238E+01, 5.3463409054E+00, 3.1647393913E+01, 4.1855241473E+00, 9.8360489345E-01],
	[4.7575000000E+04, 4.9326919767E+01, 5.3463913534E+00, 3.1658293725E+01, 4.1858123038E+00, 9.8361152660E-01],
	[4.7580000000E+04, 4.9336173059E+01, 5.3464417965E+00, 3.1669196144E+01, 4.1861003912E+00, 9.8361815666E-01],
	[4.7585000000E+04, 4.9345427115E+01, 5.3464922348E+00, 3.1680101171E+01, 4.1863884096E+00, 9.8362478364E-01],
	[4.7590000000E+04, 4.9354681933E+01, 5.3465426683E+00, 3.1691008804E+01, 4.1866763590E+00, 9.8363140754E-01],
	[4.7595000000E+04, 4.9363937515E+01, 5.3465930970E+00, 3.1701919045E+01, 4.1869642393E+00, 9.8363802836E-01],
	[4.7600000000E+04, 4.9373193860E+01, 5.3466435208E+00, 3.1712831895E+01, 4.1872520507E+00, 9.8364464610E-01],
	[4.7605000000E+04, 4.9382450968E+01, 5.3466939398E+00, 3.1723747353E+01, 4.1875397932E+00, 9.8365126076E-01],
	[4.7610000000E+04, 4.9391708839E+01, 5.3467443540E+00, 3.1734665419E+01, 4.1878274667E+00, 9.8365787235E-01],
	[4.7615000000E+04, 4.9400967473E+01, 5.3467947634E+00, 3.1745586095E+01, 4.1881150713E+00, 9.8366448086E-01],
	[4.7620000000E+04, 4.9410226871E+01, 5.3468451680E+00, 3.1756509380E+01, 4.1884026070E+00, 9.8367108630E-01],
	[4.7625000000E+04, 4.9419487031E+01, 5.3468955677E+00, 3.1767435275E+01, 4.1886900738E+00, 9.8367768867E-01],
	[4.7630000000E+04, 4.9428747955E+01, 5.3469459627E+00, 3.1778363781E+01, 4.1889774718E+00, 9.8368428797E-01],
	[4.7635000000E+04, 4.9438009641E+01, 5.3469963528E+00, 3.1789294896E+01, 4.1892648009E+00, 9.8369088420E-01],
	[4.7640000000E+04, 4.9447272091E+01, 5.3470467381E+00, 3.1800228623E+01, 4.1895520613E+00, 9.8369747736E-01],
	[4.7645000000E+04, 4.9456535304E+01, 5.3470971186E+00, 3.1811164961E+01, 4.1898392528E+00, 9.8370406746E-01],
	[4.7650000000E+04, 4.9465799279E+01, 5.3471474942E+00, 3.1822103910E+01, 4.1901263755E+00, 9.8371065449E-01],
	[4.7655000000E+04, 4.9475064018E+01, 5.3471978651E+00, 3.1833045471E+01, 4.1904134295E+00, 9.8371723846E-01],
	[4.7660000000E+04, 4.9484329519E+01, 5.3472482312E+00, 3.1843989645E+01, 4.1907004147E+00, 9.8372381937E-01],
	[4.7665000000E+04, 4.9493595784E+01, 5.3472985924E+00, 3.1854936431E+01, 4.1909873313E+00, 9.8373039722E-01],
	[4.7670000000E+04, 4.9502862811E+01, 5.3473489488E+00, 3.1865885830E+01, 4.1912741791E+00, 9.8373697202E-01],
	[4.7675000000E+04, 4.9512130602E+01, 5.3473993005E+00, 3.1876837843E+01, 4.1915609582E+00, 9.8374354375E-01],
	[4.7680000000E+04, 4.9521399155E+01, 5.3474496473E+00, 3.1887792469E+01, 4.1918476687E+00, 9.8375011244E-01],
	[4.7685000000E+04, 4.9530668471E+01, 5.3474999893E+00, 3.1898749709E+01, 4.1921343105E+00, 9.8375667807E-01],
	[4.7690000000E+04, 4.9539938550E+01, 5.3475503265E+00, 3.1909709563E+01, 4.1924208837E+00, 9.8376324064E-01],
	[4.7695000000E+04, 4.9549209392E+01, 5.3476006589E+00, 3.1920672032E+01, 4.1927073883E+00, 9.8376980017E-01],
	[4.7700000000E+04, 4.9558480996E+01, 5.3476509865E+00, 3.1931637117E+01, 4.1929938243E+00, 9.8377635665E-01],
	[4.7705000000E+04, 4.9567753364E+01, 5.3477013093E+00, 3.1942604816E+01, 4.1932801918E+00, 9.8378291008E-01],
	[4.7710000000E+04, 4.9577026494E+01, 5.3477516273E+00, 3.1953575132E+01, 4.1935664907E+00, 9.8378946046E-01],
	[4.7715000000E+04, 4.9586300387E+01, 5.3478019406E+00, 3.1964548063E+01, 4.1938527210E+00, 9.8379600780E-01],
	[4.7720000000E+04, 4.9595575043E+01, 5.3478522490E+00, 3.1975523611E+01, 4.1941388829E+00, 9.8380255210E-01],
	[4.7725000000E+04, 4.9604850461E+01, 5.3479025526E+00, 3.1986501776E+01, 4.1944249762E+00, 9.8380909335E-01],
	[4.7730000000E+04, 4.9614126642E+01, 5.3479528514E+00, 3.1997482558E+01, 4.1947110011E+00, 9.8381563157E-01],
	[4.7735000000E+04, 4.9623403586E+01, 5.3480031454E+00, 3.2008465957E+01, 4.1949969576E+00, 9.8382216674E-01],
	[4.7740000000E+04, 4.9632681293E+01, 5.3480534346E+00, 3.2019451975E+01, 4.1952828456E+00, 9.8382869888E-01],
	[4.7745000000E+04, 4.9641959762E+01, 5.3481037190E+00, 3.2030440610E+01, 4.1955686652E+00, 9.8383522799E-01],
	[4.7750000000E+04, 4.9651238994E+01, 5.3481539987E+00, 3.2041431864E+01, 4.1958544164E+00, 9.8384175406E-01],
	[4.7755000000E+04, 4.9660518989E+01, 5.3482042735E+00, 3.2052425737E+01, 4.1961400992E+00, 9.8384827710E-01],
	[4.7760000000E+04, 4.9669799746E+01, 5.3482545436E+00, 3.2063422229E+01, 4.1964257137E+00, 9.8385479710E-01],
	[4.7765000000E+04, 4.9679081266E+01, 5.3483048088E+00, 3.2074421341E+01, 4.1967112598E+00, 9.8386131408E-01],
	[4.7770000000E+04, 4.9688363548E+01, 5.3483550693E+00, 3.2085423072E+01, 4.1969967376E+00, 9.8386782803E-01],
	[4.7775000000E+04, 4.9697646593E+01, 5.3484053250E+00, 3.2096427424E+01, 4.1972821472E+00, 9.8387433895E-01],
	[4.7780000000E+04, 4.9706930400E+01, 5.3484555759E+00, 3.2107434397E+01, 4.1975674884E+00, 9.8388084685E-01],
	[4.7785000000E+04, 4.9716214970E+01, 5.3485058220E+00, 3.2118443991E+01, 4.1978527614E+00, 9.8388735172E-01],
	[4.7790000000E+04, 4.9725500303E+01, 5.3485560633E+00, 3.2129456206E+01, 4.1981379661E+00, 9.8389385358E-01],
	[4.7795000000E+04, 4.9734786398E+01, 5.3486062999E+00, 3.2140471042E+01, 4.1984231026E+00, 9.8390035241E-01],
	[4.7800000000E+04, 4.9744073255E+01, 5.3486565316E+00, 3.2151488501E+01, 4.1987081710E+00, 9.8390684822E-01],
	[4.7805000000E+04, 4.9753360875E+01, 5.3487067586E+00, 3.2162508582E+01, 4.1989931711E+00, 9.8391334101E-01],
	[4.7810000000E+04, 4.9762649258E+01, 5.3487569808E+00, 3.2173531286E+01, 4.1992781031E+00, 9.8391983079E-01],
	[4.7815000000E+04, 4.9771938403E+01, 5.3488071982E+00, 3.2184556613E+01, 4.1995629669E+00, 9.8392631756E-01],
	[4.7820000000E+04, 4.9781228310E+01, 5.3488574109E+00, 3.2195584563E+01, 4.1998477626E+00, 9.8393280131E-01],
	[4.7825000000E+04, 4.9790518980E+01, 5.3489076187E+00, 3.2206615137E+01, 4.2001324902E+00, 9.8393928205E-01],
	[4.7830000000E+04, 4.9799810412E+01, 5.3489578218E+00, 3.2217648336E+01, 4.2004171497E+00, 9.8394575977E-01],
	[4.7835000000E+04, 4.9809102606E+01, 5.3490080201E+00, 3.2228684158E+01, 4.2007017411E+00, 9.8395223449E-01],
	[4.7840000000E+04, 4.9818395563E+01, 5.3490582136E+00, 3.2239722606E+01, 4.2009862645E+00, 9.8395870621E-01],
	[4.7845000000E+04, 4.9827689282E+01, 5.3491084024E+00, 3.2250763679E+01, 4.2012707199E+00, 9.8396517491E-01],
	[4.7850000000E+04, 4.9836983763E+01, 5.3491585863E+00, 3.2261807377E+01, 4.2015551072E+00, 9.8397164062E-01],
	[4.7855000000E+04, 4.9846279007E+01, 5.3492087655E+00, 3.2272853701E+01, 4.2018394266E+00, 9.8397810332E-01],
	[4.7860000000E+04, 4.9855575013E+01, 5.3492589400E+00, 3.2283902652E+01, 4.2021236780E+00, 9.8398456301E-01],
	[4.7865000000E+04, 4.9864871781E+01, 5.3493091096E+00, 3.2294954229E+01, 4.2024078614E+00, 9.8399101971E-01],
	[4.7870000000E+04, 4.9874169311E+01, 5.3493592745E+00, 3.2306008433E+01, 4.2026919769E+00, 9.8399747341E-01],
	[4.7875000000E+04, 4.9883467604E+01, 5.3494094347E+00, 3.2317065264E+01, 4.2029760245E+00, 9.8400392412E-01],
	[4.7880000000E+04, 4.9892766659E+01, 5.3494595900E+00, 3.2328124723E+01, 4.2032600042E+00, 9.8401037183E-01],
	[4.7885000000E+04, 4.9902066476E+01, 5.3495097406E+00, 3.2339186810E+01, 4.2035439160E+00, 9.8401681654E-01],
	[4.7890000000E+04, 4.9911367055E+01, 5.3495598864E+00, 3.2350251525E+01, 4.2038277600E+00, 9.8402325826E-01],
	[4.7895000000E+04, 4.9920668396E+01, 5.3496100275E+00, 3.2361318869E+01, 4.2041115361E+00, 9.8402969699E-01],
	[4.7900000000E+04, 4.9929970500E+01, 5.3496601638E+00, 3.2372388842E+01, 4.2043952444E+00, 9.8403613273E-01],
	[4.7905000000E+04, 4.9939273365E+01, 5.3497102953E+00, 3.2383461444E+01, 4.2046788849E+00, 9.8404256549E-01],
	[4.7910000000E+04, 4.9948576993E+01, 5.3497604221E+00, 3.2394536676E+01, 4.2049624576E+00, 9.8404899526E-01],
	[4.7915000000E+04, 4.9957881383E+01, 5.3498105441E+00, 3.2405614538E+01, 4.2052459625E+00, 9.8405542204E-01],
	[4.7920000000E+04, 4.9967186535E+01, 5.3498606613E+00, 3.2416695030E+01, 4.2055293997E+00, 9.8406184584E-01],
	[4.7925000000E+04, 4.9976492449E+01, 5.3499107738E+00, 3.2427778154E+01, 4.2058127692E+00, 9.8406826665E-01],
	[4.7930000000E+04, 4.9985799125E+01, 5.3499608815E+00, 3.2438863908E+01, 4.2060960710E+00, 9.8407468449E-01],
	[4.7935000000E+04, 4.9995106563E+01, 5.3500109845E+00, 3.2449952294E+01, 4.2063793051E+00, 9.8408109935E-01],
	[4.7940000000E+04, 5.0004414763E+01, 5.3500610827E+00, 3.2461043312E+01, 4.2066624715E+00, 9.8408751123E-01],
	[4.7945000000E+04, 5.0013723725E+01, 5.3501111761E+00, 3.2472136962E+01, 4.2069455703E+00, 9.8409392013E-01],
	[4.7950000000E+04, 5.0023033448E+01, 5.3501612648E+00, 3.2483233244E+01, 4.2072286014E+00, 9.8410032606E-01],
	[4.7955000000E+04, 5.0032343934E+01, 5.3502113488E+00, 3.2494332159E+01, 4.2075115650E+00, 9.8410672901E-01],
	[4.7960000000E+04, 5.0041655182E+01, 5.3502614280E+00, 3.2505433708E+01, 4.2077944609E+00, 9.8411312900E-01],
	[4.7965000000E+04, 5.0050967192E+01, 5.3503115024E+00, 3.2516537890E+01, 4.2080772893E+00, 9.8411952601E-01],
	[4.7970000000E+04, 5.0060279963E+01, 5.3503615721E+00, 3.2527644706E+01, 4.2083600501E+00, 9.8412592006E-01],
	[4.7975000000E+04, 5.0069593497E+01, 5.3504116371E+00, 3.2538754156E+01, 4.2086427434E+00, 9.8413231113E-01],
	[4.7980000000E+04, 5.0078907792E+01, 5.3504616972E+00, 3.2549866241E+01, 4.2089253692E+00, 9.8413869924E-01],
	[4.7985000000E+04, 5.0088222850E+01, 5.3505117527E+00, 3.2560980961E+01, 4.2092079275E+00, 9.8414508439E-01],
	[4.7990000000E+04, 5.0097538669E+01, 5.3505618034E+00, 3.2572098316E+01, 4.2094904183E+00, 9.8415146658E-01],
	[4.7995000000E+04, 5.0106855249E+01, 5.3506118493E+00, 3.2583218307E+01, 4.2097728416E+00, 9.8415784580E-01],
	[4.8000000000E+04, 5.0116172592E+01, 5.3506618905E+00, 3.2594340934E+01, 4.2100551976E+00, 9.8416422206E-01],
	[4.8005000000E+04, 5.0125490696E+01, 5.3507119270E+00, 3.2605466197E+01, 4.2103374860E+00, 9.8417059537E-01],
	[4.8010000000E+04, 5.0134809563E+01, 5.3507619587E+00, 3.2616594097E+01, 4.2106197071E+00, 9.8417696572E-01],
	[4.8015000000E+04, 5.0144129191E+01, 5.3508119857E+00, 3.2627724634E+01, 4.2109018608E+00, 9.8418333311E-01],
	[4.8020000000E+04, 5.0153449580E+01, 5.3508620079E+00, 3.2638857809E+01, 4.2111839472E+00, 9.8418969755E-01],
	[4.8025000000E+04, 5.0162770732E+01, 5.3509120254E+00, 3.2649993621E+01, 4.2114659662E+00, 9.8419605903E-01],
	[4.8030000000E+04, 5.0172092645E+01, 5.3509620382E+00, 3.2661132071E+01, 4.2117479179E+00, 9.8420241757E-01],
	[4.8035000000E+04, 5.0181415319E+01, 5.3510120462E+00, 3.2672273160E+01, 4.2120298022E+00, 9.8420877315E-01],
	[4.8040000000E+04, 5.0190738756E+01, 5.3510620494E+00, 3.2683416888E+01, 4.2123116193E+00, 9.8421512579E-01],
	[4.8045000000E+04, 5.0200062954E+01, 5.3511120480E+00, 3.2694563255E+01, 4.2125933692E+00, 9.8422147548E-01],
	[4.8050000000E+04, 5.0209387913E+01, 5.3511620418E+00, 3.2705712261E+01, 4.2128750517E+00, 9.8422782223E-01],
	[4.8055000000E+04, 5.0218713635E+01, 5.3512120309E+00, 3.2716863907E+01, 4.2131566671E+00, 9.8423416603E-01],
	[4.8060000000E+04, 5.0228040118E+01, 5.3512620152E+00, 3.2728018194E+01, 4.2134382152E+00, 9.8424050689E-01],
	[4.8065000000E+04, 5.0237367362E+01, 5.3513119948E+00, 3.2739175121E+01, 4.2137196961E+00, 9.8424684481E-01],
	[4.8070000000E+04, 5.0246695368E+01, 5.3513619697E+00, 3.2750334689E+01, 4.2140011099E+00, 9.8425317979E-01],
	[4.8075000000E+04, 5.0256024136E+01, 5.3514119398E+00, 3.2761496898E+01, 4.2142824565E+00, 9.8425951183E-01],
	[4.8080000000E+04, 5.0265353665E+01, 5.3514619052E+00, 3.2772661749E+01, 4.2145637360E+00, 9.8426584093E-01],
	[4.8085000000E+04, 5.0274683955E+01, 5.3515118659E+00, 3.2783829241E+01, 4.2148449484E+00, 9.8427216711E-01],
	[4.8090000000E+04, 5.0284015007E+01, 5.3515618218E+00, 3.2794999377E+01, 4.2151260936E+00, 9.8427849034E-01],
	[4.8095000000E+04, 5.0293346821E+01, 5.3516117730E+00, 3.2806172154E+01, 4.2154071718E+00, 9.8428481065E-01],
	[4.8100000000E+04, 5.0302679396E+01, 5.3516617195E+00, 3.2817347575E+01, 4.2156881829E+00, 9.8429112802E-01],
	[4.8105000000E+04, 5.0312012732E+01, 5.3517116613E+00, 3.2828525639E+01, 4.2159691270E+00, 9.8429744247E-01],
	[4.8110000000E+04, 5.0321346830E+01, 5.3517615984E+00, 3.2839706347E+01, 4.2162500041E+00, 9.8430375399E-01],
	[4.8115000000E+04, 5.0330681689E+01, 5.3518115307E+00, 3.2850889699E+01, 4.2165308142E+00, 9.8431006258E-01],
	[4.8120000000E+04, 5.0340017310E+01, 5.3518614583E+00, 3.2862075695E+01, 4.2168115572E+00, 9.8431636825E-01],
	[4.8125000000E+04, 5.0349353692E+01, 5.3519113812E+00, 3.2873264337E+01, 4.2170922334E+00, 9.8432267099E-01],
	[4.8130000000E+04, 5.0358690835E+01, 5.3519612993E+00, 3.2884455623E+01, 4.2173728425E+00, 9.8432897081E-01],
	[4.8135000000E+04, 5.0368028740E+01, 5.3520112127E+00, 3.2895649555E+01, 4.2176533848E+00, 9.8433526771E-01],
	[4.8140000000E+04, 5.0377367406E+01, 5.3520611215E+00, 3.2906846132E+01, 4.2179338601E+00, 9.8434156170E-01],
	[4.8145000000E+04, 5.0386706833E+01, 5.3521110255E+00, 3.2918045356E+01, 4.2182142686E+00, 9.8434785276E-01],
	[4.8150000000E+04, 5.0396047022E+01, 5.3521609247E+00, 3.2929247226E+01, 4.2184946101E+00, 9.8435414092E-01],
	[4.8155000000E+04, 5.0405387971E+01, 5.3522108193E+00, 3.2940451743E+01, 4.2187748849E+00, 9.8436042615E-01],
	[4.8160000000E+04, 5.0414729682E+01, 5.3522607092E+00, 3.2951658907E+01, 4.2190550928E+00, 9.8436670847E-01],
	[4.8165000000E+04, 5.0424072155E+01, 5.3523105943E+00, 3.2962868719E+01, 4.2193352339E+00, 9.8437298789E-01],
	[4.8170000000E+04, 5.0433415388E+01, 5.3523604747E+00, 3.2974081179E+01, 4.2196153081E+00, 9.8437926439E-01],
	[4.8175000000E+04, 5.0442759383E+01, 5.3524103504E+00, 3.2985296287E+01, 4.2198953157E+00, 9.8438553798E-01],
	[4.8180000000E+04, 5.0452104139E+01, 5.3524602214E+00, 3.2996514044E+01, 4.2201752564E+00, 9.8439180867E-01],
	[4.8185000000E+04, 5.0461449656E+01, 5.3525100877E+00, 3.3007734450E+01, 4.2204551304E+00, 9.8439807645E-01],
	[4.8190000000E+04, 5.0470795934E+01, 5.3525599493E+00, 3.3018957505E+01, 4.2207349377E+00, 9.8440434132E-01],
	[4.8195000000E+04, 5.0480142974E+01, 5.3526098061E+00, 3.3030183209E+01, 4.2210146783E+00, 9.8441060330E-01],
	[4.8200000000E+04, 5.0489490774E+01, 5.3526596583E+00, 3.3041411564E+01, 4.2212943522E+00, 9.8441686237E-01],
	[4.8205000000E+04, 5.0498839336E+01, 5.3527095058E+00, 3.3052642569E+01, 4.2215739595E+00, 9.8442311854E-01],
	[4.8210000000E+04, 5.0508188658E+01, 5.3527593485E+00, 3.3063876225E+01, 4.2218535001E+00, 9.8442937182E-01],
	[4.8215000000E+04, 5.0517538742E+01, 5.3528091866E+00, 3.3075112531E+01, 4.2221329741E+00, 9.8443562220E-01],
	[4.8220000000E+04, 5.0526889587E+01, 5.3528590199E+00, 3.3086351490E+01, 4.2224123815E+00, 9.8444186968E-01],
	[4.8225000000E+04, 5.0536241193E+01, 5.3529088485E+00, 3.3097593100E+01, 4.2226917223E+00, 9.8444811427E-01],
	[4.8230000000E+04, 5.0545593559E+01, 5.3529586725E+00, 3.3108837362E+01, 4.2229709965E+00, 9.8445435596E-01],
	[4.8235000000E+04, 5.0554946687E+01, 5.3530084917E+00, 3.3120084276E+01, 4.2232502042E+00, 9.8446059477E-01],
	[4.8240000000E+04, 5.0564300576E+01, 5.3530583062E+00, 3.3131333844E+01, 4.2235293453E+00, 9.8446683068E-01],
	[4.8245000000E+04, 5.0573655226E+01, 5.3531081161E+00, 3.3142586064E+01, 4.2238084200E+00, 9.8447306371E-01],
	[4.8250000000E+04, 5.0583010636E+01, 5.3531579212E+00, 3.3153840939E+01, 4.2240874281E+00, 9.8447929385E-01],
	[4.8255000000E+04, 5.0592366808E+01, 5.3532077216E+00, 3.3165098467E+01, 4.2243663698E+00, 9.8448552111E-01],
	[4.8260000000E+04, 5.0601723741E+01, 5.3532575174E+00, 3.3176358649E+01, 4.2246452450E+00, 9.8449174548E-01],
	[4.8265000000E+04, 5.0611081434E+01, 5.3533073084E+00, 3.3187621486E+01, 4.2249240538E+00, 9.8449796697E-01],
	[4.8270000000E+04, 5.0620439888E+01, 5.3533570948E+00, 3.3198886977E+01, 4.2252027961E+00, 9.8450418558E-01],
	[4.8275000000E+04, 5.0629799103E+01, 5.3534068764E+00, 3.3210155124E+01, 4.2254814721E+00, 9.8451040130E-01],
	[4.8280000000E+04, 5.0639159079E+01, 5.3534566534E+00, 3.3221425927E+01, 4.2257600817E+00, 9.8451661416E-01],
	[4.8285000000E+04, 5.0648519816E+01, 5.3535064256E+00, 3.3232699385E+01, 4.2260386249E+00, 9.8452282413E-01],
	[4.8290000000E+04, 5.0657881314E+01, 5.3535561932E+00, 3.3243975500E+01, 4.2263171018E+00, 9.8452903123E-01],
	[4.8295000000E+04, 5.0667260253E+01, 5.3536075614E+00, 3.3255254272E+01, 4.2265966289E+00, 9.8453523546E-01],
	[4.8300000000E+04, 5.0676640701E+01, 5.3536589964E+00, 3.3266535700E+01, 4.2268761397E+00, 9.8454143681E-01],
	[4.8305000000E+04, 5.0686021914E+01, 5.3537104265E+00, 3.3277819786E+01, 4.2271555844E+00, 9.8454763529E-01],
	[4.8310000000E+04, 5.0695403893E+01, 5.3537618518E+00, 3.3289106530E+01, 4.2274349629E+00, 9.8455383091E-01],
	[4.8315000000E+04, 5.0704786637E+01, 5.3538132722E+00, 3.3300395932E+01, 4.2277142752E+00, 9.8456002365E-01],
	[4.8320000000E+04, 5.0714170146E+01, 5.3538646878E+00, 3.3311687992E+01, 4.2279935215E+00, 9.8456621354E-01],
	[4.8325000000E+04, 5.0723554421E+01, 5.3539160986E+00, 3.3322982711E+01, 4.2282727016E+00, 9.8457240055E-01],
	[4.8330000000E+04, 5.0732939461E+01, 5.3539675046E+00, 3.3334280089E+01, 4.2285518157E+00, 9.8457858470E-01],
	[4.8335000000E+04, 5.0742325266E+01, 5.3540189058E+00, 3.3345580126E+01, 4.2288308638E+00, 9.8458476599E-01],
	[4.8340000000E+04, 5.0751711837E+01, 5.3540703021E+00, 3.3356882824E+01, 4.2291098458E+00, 9.8459094442E-01],
	[4.8345000000E+04, 5.0761099173E+01, 5.3541216936E+00, 3.3368188181E+01, 4.2293887618E+00, 9.8459711999E-01],
	[4.8350000000E+04, 5.0770487274E+01, 5.3541730803E+00, 3.3379496199E+01, 4.2296676118E+00, 9.8460329270E-01],
	[4.8355000000E+04, 5.0779876140E+01, 5.3542244621E+00, 3.3390806878E+01, 4.2299463958E+00, 9.8460946256E-01],
	[4.8360000000E+04, 5.0789265772E+01, 5.3542758392E+00, 3.3402120219E+01, 4.2302251138E+00, 9.8461562956E-01],
	[4.8365000000E+04, 5.0798656169E+01, 5.3543272114E+00, 3.3413436220E+01, 4.2305037660E+00, 9.8462179371E-01],
	[4.8370000000E+04, 5.0808047331E+01, 5.3543785788E+00, 3.3424754884E+01, 4.2307823522E+00, 9.8462795501E-01],
	[4.8375000000E+04, 5.0817439258E+01, 5.3544299414E+00, 3.3436076210E+01, 4.2310608724E+00, 9.8463411345E-01],
	[4.8380000000E+04, 5.0826831950E+01, 5.3544812992E+00, 3.3447400199E+01, 4.2313393269E+00, 9.8464026905E-01],
	[4.8385000000E+04, 5.0836225407E+01, 5.3545326521E+00, 3.3458726850E+01, 4.2316177154E+00, 9.8464642180E-01],
	[4.8390000000E+04, 5.0845619630E+01, 5.3545840003E+00, 3.3470056165E+01, 4.2318960381E+00, 9.8465257171E-01],
	[4.8395000000E+04, 5.0855014618E+01, 5.3546353436E+00, 3.3481388144E+01, 4.2321742950E+00, 9.8465871876E-01],
	[4.8400000000E+04, 5.0864410370E+01, 5.3546866821E+00, 3.3492722786E+01, 4.2324524860E+00, 9.8466486298E-01],
	[4.8405000000E+04, 5.0873806888E+01, 5.3547380158E+00, 3.3504060093E+01, 4.2327306113E+00, 9.8467100435E-01],
	[4.8410000000E+04, 5.0883204171E+01, 5.3547893447E+00, 3.3515400065E+01, 4.2330086708E+00, 9.8467714289E-01],
	[4.8415000000E+04, 5.0892602219E+01, 5.3548406688E+00, 3.3526742702E+01, 4.2332866645E+00, 9.8468327858E-01],
	[4.8420000000E+04, 5.0902001032E+01, 5.3548919881E+00, 3.3538088004E+01, 4.2335645925E+00, 9.8468941144E-01],
	[4.8425000000E+04, 5.0911400610E+01, 5.3549433026E+00, 3.3549435972E+01, 4.2338424548E+00, 9.8469554146E-01],
	[4.8430000000E+04, 5.0920800952E+01, 5.3549946122E+00, 3.3560786606E+01, 4.2341202514E+00, 9.8470166865E-01],
	[4.8435000000E+04, 5.0930202060E+01, 5.3550459171E+00, 3.3572139907E+01, 4.2343979823E+00, 9.8470779300E-01],
	[4.8440000000E+04, 5.0939603933E+01, 5.3550972172E+00, 3.3583495875E+01, 4.2346756476E+00, 9.8471391453E-01],
	[4.8445000000E+04, 5.0949006571E+01, 5.3551485124E+00, 3.3594854509E+01, 4.2349532472E+00, 9.8472003322E-01],
	[4.8450000000E+04, 5.0958409973E+01, 5.3551998029E+00, 3.3606215811E+01, 4.2352307812E+00, 9.8472614908E-01],
	[4.8455000000E+04, 5.0967814141E+01, 5.3552510885E+00, 3.3617579782E+01, 4.2355082495E+00, 9.8473226212E-01],
	[4.8460000000E+04, 5.0977219073E+01, 5.3553023694E+00, 3.3628946420E+01, 4.2357856523E+00, 9.8473837233E-01],
	[4.8465000000E+04, 5.0986624770E+01, 5.3553536454E+00, 3.3640315727E+01, 4.2360629895E+00, 9.8474447972E-01],
	[4.8470000000E+04, 5.0996031232E+01, 5.3554049167E+00, 3.3651687703E+01, 4.2363402612E+00, 9.8475058428E-01],
	[4.8475000000E+04, 5.1005438459E+01, 5.3554561831E+00, 3.3663062348E+01, 4.2366174673E+00, 9.8475668602E-01],
	[4.8480000000E+04, 5.1014846451E+01, 5.3555074448E+00, 3.3674439663E+01, 4.2368946080E+00, 9.8476278494E-01],
	[4.8485000000E+04, 5.1024255208E+01, 5.3555587016E+00, 3.3685819647E+01, 4.2371716831E+00, 9.8476888104E-01],
	[4.8490000000E+04, 5.1033664729E+01, 5.3556099537E+00, 3.3697202303E+01, 4.2374486928E+00, 9.8477497433E-01],
	[4.8495000000E+04, 5.1043075015E+01, 5.3556612010E+00, 3.3708587628E+01, 4.2377256369E+00, 9.8478106480E-01],
	[4.8500000000E+04, 5.1052486066E+01, 5.3557124434E+00, 3.3719975625E+01, 4.2380025157E+00, 9.8478715245E-01],
	[4.8505000000E+04, 5.1061897881E+01, 5.3557636811E+00, 3.3731366294E+01, 4.2382793290E+00, 9.8479323729E-01],
	[4.8510000000E+04, 5.1071310462E+01, 5.3558149140E+00, 3.3742759634E+01, 4.2385560770E+00, 9.8479931933E-01],
	[4.8515000000E+04, 5.1080723807E+01, 5.3558661421E+00, 3.3754155646E+01, 4.2388327595E+00, 9.8480539855E-01],
	[4.8520000000E+04, 5.1090137916E+01, 5.3559173654E+00, 3.3765554330E+01, 4.2391093767E+00, 9.8481147496E-01],
	[4.8525000000E+04, 5.1099552791E+01, 5.3559685840E+00, 3.3776955688E+01, 4.2393859285E+00, 9.8481754856E-01],
	[4.8530000000E+04, 5.1108968430E+01, 5.3560197977E+00, 3.3788359718E+01, 4.2396624151E+00, 9.8482361936E-01],
	[4.8535000000E+04, 5.1118384833E+01, 5.3560710066E+00, 3.3799766422E+01, 4.2399388363E+00, 9.8482968735E-01],
	[4.8540000000E+04, 5.1127802001E+01, 5.3561222108E+00, 3.3811175800E+01, 4.2402151922E+00, 9.8483575255E-01],
	[4.8545000000E+04, 5.1137219934E+01, 5.3561734102E+00, 3.3822587852E+01, 4.2404914828E+00, 9.8484181494E-01],
	[4.8550000000E+04, 5.1146638631E+01, 5.3562246048E+00, 3.3834002578E+01, 4.2407677082E+00, 9.8484787453E-01],
	[4.8555000000E+04, 5.1156058093E+01, 5.3562757946E+00, 3.3845419980E+01, 4.2410438683E+00, 9.8485393132E-01],
	[4.8560000000E+04, 5.1165478320E+01, 5.3563269796E+00, 3.3856840057E+01, 4.2413199633E+00, 9.8485998531E-01],
	[4.8565000000E+04, 5.1174899311E+01, 5.3563781599E+00, 3.3868262809E+01, 4.2415959930E+00, 9.8486603651E-01],
	[4.8570000000E+04, 5.1184321066E+01, 5.3564293354E+00, 3.3879688237E+01, 4.2418719575E+00, 9.8487208491E-01],
	[4.8575000000E+04, 5.1193743586E+01, 5.3564805060E+00, 3.3891116342E+01, 4.2421478569E+00, 9.8487813052E-01],
	[4.8580000000E+04, 5.1203166871E+01, 5.3565316720E+00, 3.3902547123E+01, 4.2424236912E+00, 9.8488417334E-01],
	[4.8585000000E+04, 5.1212590920E+01, 5.3565828331E+00, 3.3913980582E+01, 4.2426994603E+00, 9.8489021337E-01],
	[4.8590000000E+04, 5.1222015733E+01, 5.3566339895E+00, 3.3925416717E+01, 4.2429751643E+00, 9.8489625061E-01],
	[4.8595000000E+04, 5.1231441311E+01, 5.3566851410E+00, 3.3936855531E+01, 4.2432508032E+00, 9.8490228507E-01],
	[4.8600000000E+04, 5.1240867653E+01, 5.3567362879E+00, 3.3948297022E+01, 4.2435263771E+00, 9.8490831673E-01],
	[4.8605000000E+04, 5.1250294760E+01, 5.3567874299E+00, 3.3959741192E+01, 4.2438018859E+00, 9.8491434562E-01],
	[4.8610000000E+04, 5.1259722631E+01, 5.3568385672E+00, 3.3971188040E+01, 4.2440773297E+00, 9.8492037172E-01],
	[4.8615000000E+04, 5.1269151266E+01, 5.3568896996E+00, 3.3982637568E+01, 4.2443527084E+00, 9.8492639504E-01],
	[4.8620000000E+04, 5.1278580666E+01, 5.3569408274E+00, 3.3994089775E+01, 4.2446280222E+00, 9.8493241558E-01],
	[4.8625000000E+04, 5.1288010830E+01, 5.3569919503E+00, 3.4005544662E+01, 4.2449032710E+00, 9.8493843334E-01],
	[4.8630000000E+04, 5.1297441758E+01, 5.3570430685E+00, 3.4017002229E+01, 4.2451784548E+00, 9.8494444832E-01],
	[4.8635000000E+04, 5.1306873451E+01, 5.3570941819E+00, 3.4028462477E+01, 4.2454535737E+00, 9.8495046053E-01],
	[4.8640000000E+04, 5.1316305908E+01, 5.3571452906E+00, 3.4039925405E+01, 4.2457286276E+00, 9.8495646996E-01],
	[4.8645000000E+04, 5.1325739129E+01, 5.3571963944E+00, 3.4051391015E+01, 4.2460036167E+00, 9.8496247662E-01],
	[4.8650000000E+04, 5.1335173115E+01, 5.3572474936E+00, 3.4062859306E+01, 4.2462785409E+00, 9.8496848051E-01],
	[4.8655000000E+04, 5.1344607864E+01, 5.3572985879E+00, 3.4074330280E+01, 4.2465534002E+00, 9.8497448162E-01],
	[4.8660000000E+04, 5.1354043378E+01, 5.3573496775E+00, 3.4085803935E+01, 4.2468281946E+00, 9.8498047997E-01],
	[4.8665000000E+04, 5.1363479656E+01, 5.3574007623E+00, 3.4097280273E+01, 4.2471029242E+00, 9.8498647555E-01],
	[4.8670000000E+04, 5.1372916699E+01, 5.3574518424E+00, 3.4108759294E+01, 4.2473775890E+00, 9.8499246837E-01],
	[4.8675000000E+04, 5.1382354505E+01, 5.3575029177E+00, 3.4120240999E+01, 4.2476521891E+00, 9.8499845842E-01],
	[4.8680000000E+04, 5.1391793076E+01, 5.3575539883E+00, 3.4131725387E+01, 4.2479267243E+00, 9.8500444571E-01],
	[4.8685000000E+04, 5.1401232410E+01, 5.3576050540E+00, 3.4143212459E+01, 4.2482011948E+00, 9.8501043024E-01],
	[4.8690000000E+04, 5.1410672509E+01, 5.3576561151E+00, 3.4154702215E+01, 4.2484756005E+00, 9.8501641200E-01],
	[4.8695000000E+04, 5.1420113372E+01, 5.3577071714E+00, 3.4166194657E+01, 4.2487499416E+00, 9.8502239101E-01],
	[4.8700000000E+04, 5.1429554999E+01, 5.3577582229E+00, 3.4177689783E+01, 4.2490242179E+00, 9.8502836726E-01],
	[4.8705000000E+04, 5.1438997390E+01, 5.3578092696E+00, 3.4189187595E+01, 4.2492984295E+00, 9.8503434076E-01],
	[4.8710000000E+04, 5.1448440545E+01, 5.3578603116E+00, 3.4200688092E+01, 4.2495725765E+00, 9.8504031150E-01],
	[4.8715000000E+04, 5.1457884465E+01, 5.3579113489E+00, 3.4212191276E+01, 4.2498466588E+00, 9.8504627948E-01],
	[4.8720000000E+04, 5.1467329148E+01, 5.3579623814E+00, 3.4223697146E+01, 4.2501206765E+00, 9.8505224472E-01],
	[4.8725000000E+04, 5.1476774595E+01, 5.3580134092E+00, 3.4235205703E+01, 4.2503946296E+00, 9.8505820720E-01],
	[4.8730000000E+04, 5.1486220806E+01, 5.3580644322E+00, 3.4246716947E+01, 4.2506685181E+00, 9.8506416694E-01],
	[4.8735000000E+04, 5.1495667781E+01, 5.3581154504E+00, 3.4258230879E+01, 4.2509423420E+00, 9.8507012393E-01],
	[4.8740000000E+04, 5.1505115520E+01, 5.3581664639E+00, 3.4269747498E+01, 4.2512161014E+00, 9.8507607817E-01],
	[4.8745000000E+04, 5.1514564023E+01, 5.3582174727E+00, 3.4281266806E+01, 4.2514897962E+00, 9.8508202967E-01],
	[4.8750000000E+04, 5.1524013290E+01, 5.3582684767E+00, 3.4292788802E+01, 4.2517634265E+00, 9.8508797842E-01],
	[4.8755000000E+04, 5.1533463321E+01, 5.3583194760E+00, 3.4304313488E+01, 4.2520369923E+00, 9.8509392443E-01],
	[4.8760000000E+04, 5.1542914116E+01, 5.3583704705E+00, 3.4315840862E+01, 4.2523104936E+00, 9.8509986770E-01],
	[4.8765000000E+04, 5.1552365674E+01, 5.3584214603E+00, 3.4327370927E+01, 4.2525839305E+00, 9.8510580824E-01],
	[4.8770000000E+04, 5.1561817996E+01, 5.3584724453E+00, 3.4338903681E+01, 4.2528573029E+00, 9.8511174603E-01],
	[4.8775000000E+04, 5.1571271083E+01, 5.3585234256E+00, 3.4350439126E+01, 4.2531306109E+00, 9.8511768109E-01],
	[4.8780000000E+04, 5.1580724933E+01, 5.3585744011E+00, 3.4361977261E+01, 4.2534038545E+00, 9.8512361342E-01],
	[4.8785000000E+04, 5.1590179546E+01, 5.3586253720E+00, 3.4373518087E+01, 4.2536770336E+00, 9.8512954301E-01],
	[4.8790000000E+04, 5.1599634924E+01, 5.3586763380E+00, 3.4385061605E+01, 4.2539501485E+00, 9.8513546987E-01],
	[4.8795000000E+04, 5.1609091065E+01, 5.3587272994E+00, 3.4396607815E+01, 4.2542231989E+00, 9.8514139400E-01],
	[4.8800000000E+04, 5.1618547971E+01, 5.3587782560E+00, 3.4408156716E+01, 4.2544961850E+00, 9.8514731540E-01],
	[4.8805000000E+04, 5.1628005639E+01, 5.3588292078E+00, 3.4419708310E+01, 4.2547691068E+00, 9.8515323407E-01],
	[4.8810000000E+04, 5.1637464072E+01, 5.3588801550E+00, 3.4431262597E+01, 4.2550419643E+00, 9.8515915001E-01],
	[4.8815000000E+04, 5.1646923268E+01, 5.3589310974E+00, 3.4442819577E+01, 4.2553147576E+00, 9.8516506323E-01],
	[4.8820000000E+04, 5.1656383228E+01, 5.3589820350E+00, 3.4454379251E+01, 4.2555874865E+00, 9.8517097373E-01],
	[4.8825000000E+04, 5.1665843952E+01, 5.3590329679E+00, 3.4465941618E+01, 4.2558601512E+00, 9.8517688151E-01],
	[4.8830000000E+04, 5.1675305439E+01, 5.3590838961E+00, 3.4477506680E+01, 4.2561327517E+00, 9.8518278656E-01],
	[4.8835000000E+04, 5.1684767690E+01, 5.3591348196E+00, 3.4489074436E+01, 4.2564052880E+00, 9.8518868890E-01],
	[4.8840000000E+04, 5.1694230704E+01, 5.3591857383E+00, 3.4500644887E+01, 4.2566777601E+00, 9.8519458851E-01],
	[4.8845000000E+04, 5.1703694483E+01, 5.3592366523E+00, 3.4512218033E+01, 4.2569501680E+00, 9.8520048541E-01],
	[4.8850000000E+04, 5.1713159024E+01, 5.3592875616E+00, 3.4523793875E+01, 4.2572225118E+00, 9.8520637960E-01],
	[4.8855000000E+04, 5.1722624330E+01, 5.3593384662E+00, 3.4535372413E+01, 4.2574947914E+00, 9.8521227107E-01],
	[4.8860000000E+04, 5.1732090398E+01, 5.3593893660E+00, 3.4546953648E+01, 4.2577670069E+00, 9.8521815983E-01],
	[4.8865000000E+04, 5.1741557231E+01, 5.3594402611E+00, 3.4558537579E+01, 4.2580391583E+00, 9.8522404588E-01],
	[4.8870000000E+04, 5.1751024827E+01, 5.3594911515E+00, 3.4570124206E+01, 4.2583112456E+00, 9.8522992922E-01],
	[4.8875000000E+04, 5.1760493186E+01, 5.3595420371E+00, 3.4581713532E+01, 4.2585832689E+00, 9.8523580985E-01],
	[4.8880000000E+04, 5.1769962309E+01, 5.3595929181E+00, 3.4593305555E+01, 4.2588552281E+00, 9.8524168777E-01],
	[4.8885000000E+04, 5.1779432195E+01, 5.3596437943E+00, 3.4604900276E+01, 4.2591271233E+00, 9.8524756299E-01],
	[4.8890000000E+04, 5.1788902845E+01, 5.3596946658E+00, 3.4616497696E+01, 4.2593989545E+00, 9.8525343551E-01],
	[4.8895000000E+04, 5.1798374258E+01, 5.3597455325E+00, 3.4628097814E+01, 4.2596707217E+00, 9.8525930532E-01],
	[4.8900000000E+04, 5.1807846435E+01, 5.3597963946E+00, 3.4639700631E+01, 4.2599424249E+00, 9.8526517243E-01],
	[4.8905000000E+04, 5.1817319375E+01, 5.3598472519E+00, 3.4651306148E+01, 4.2602140642E+00, 9.8527103684E-01],
	[4.8910000000E+04, 5.1826793078E+01, 5.3598981045E+00, 3.4662914365E+01, 4.2604856395E+00, 9.8527689856E-01],
	[4.8915000000E+04, 5.1836267545E+01, 5.3599489524E+00, 3.4674525282E+01, 4.2607571509E+00, 9.8528275757E-01],
	[4.8920000000E+04, 5.1845742775E+01, 5.3599997956E+00, 3.4686138900E+01, 4.2610285984E+00, 9.8528861389E-01],
	[4.8925000000E+04, 5.1855218768E+01, 5.3600506341E+00, 3.4697755218E+01, 4.2612999821E+00, 9.8529446752E-01],
	[4.8930000000E+04, 5.1864695525E+01, 5.3601014678E+00, 3.4709374238E+01, 4.2615713018E+00, 9.8530031845E-01],
	[4.8935000000E+04, 5.1874173045E+01, 5.3601522969E+00, 3.4720995959E+01, 4.2618425578E+00, 9.8530616670E-01],
	[4.8940000000E+04, 5.1883651328E+01, 5.3602031212E+00, 3.4732620382E+01, 4.2621137499E+00, 9.8531201225E-01],
	[4.8945000000E+04, 5.1893130375E+01, 5.3602539408E+00, 3.4744247508E+01, 4.2623848782E+00, 9.8531785511E-01],
	[4.8950000000E+04, 5.1902610185E+01, 5.3603047558E+00, 3.4755877336E+01, 4.2626559427E+00, 9.8532369529E-01],
	[4.8955000000E+04, 5.1912090758E+01, 5.3603555660E+00, 3.4767509867E+01, 4.2629269434E+00, 9.8532953278E-01],
	[4.8960000000E+04, 5.1921572094E+01, 5.3604063715E+00, 3.4779145101E+01, 4.2631978804E+00, 9.8533536759E-01],
	[4.8965000000E+04, 5.1931054194E+01, 5.3604571723E+00, 3.4790783039E+01, 4.2634687536E+00, 9.8534119971E-01],
	[4.8970000000E+04, 5.1940537057E+01, 5.3605079683E+00, 3.4802423682E+01, 4.2637395631E+00, 9.8534702916E-01],
	[4.8975000000E+04, 5.1950020682E+01, 5.3605587597E+00, 3.4814067028E+01, 4.2640103089E+00, 9.8535285592E-01],
	[4.8980000000E+04, 5.1959505071E+01, 5.3606095464E+00, 3.4825713080E+01, 4.2642809911E+00, 9.8535868000E-01],
	[4.8985000000E+04, 5.1968990224E+01, 5.3606603284E+00, 3.4837361836E+01, 4.2645516095E+00, 9.8536450141E-01],
	[4.8990000000E+04, 5.1978476139E+01, 5.3607111056E+00, 3.4849013298E+01, 4.2648221644E+00, 9.8537032014E-01],
	[4.8995000000E+04, 5.1987962817E+01, 5.3607618782E+00, 3.4860667466E+01, 4.2650926556E+00, 9.8537613619E-01],
	[4.9000000000E+04, 5.1997450259E+01, 5.3608126461E+00, 3.4872324340E+01, 4.2653630831E+00, 9.8538194958E-01],
	[4.9005000000E+04, 5.2006938463E+01, 5.3608634093E+00, 3.4883983920E+01, 4.2656334471E+00, 9.8538776029E-01],
	[4.9010000000E+04, 5.2016427431E+01, 5.3609141677E+00, 3.4895646207E+01, 4.2659037476E+00, 9.8539356833E-01],
	[4.9015000000E+04, 5.2025917162E+01, 5.3609649215E+00, 3.4907311202E+01, 4.2661739844E+00, 9.8539937370E-01],
	[4.9020000000E+04, 5.2035407655E+01, 5.3610156706E+00, 3.4918978904E+01, 4.2664441578E+00, 9.8540517640E-01],
	[4.9025000000E+04, 5.2044898912E+01, 5.3610664150E+00, 3.4930649314E+01, 4.2667142676E+00, 9.8541097644E-01],
	[4.9030000000E+04, 5.2054390932E+01, 5.3611171546E+00, 3.4942322432E+01, 4.2669843139E+00, 9.8541677381E-01],
	[4.9035000000E+04, 5.2063883714E+01, 5.3611678896E+00, 3.4953998259E+01, 4.2672542967E+00, 9.8542256852E-01],
	[4.9040000000E+04, 5.2073377260E+01, 5.3612186199E+00, 3.4965676795E+01, 4.2675242161E+00, 9.8542836056E-01],
	[4.9045000000E+04, 5.2082871568E+01, 5.3612693455E+00, 3.4977358040E+01, 4.2677940720E+00, 9.8543414995E-01],
	[4.9050000000E+04, 5.2092366640E+01, 5.3613200665E+00, 3.4989041995E+01, 4.2680638645E+00, 9.8543993667E-01],
	[4.9055000000E+04, 5.2101862474E+01, 5.3613707827E+00, 3.5000728660E+01, 4.2683335936E+00, 9.8544572074E-01],
	[4.9060000000E+04, 5.2111359071E+01, 5.3614214942E+00, 3.5012418035E+01, 4.2686032592E+00, 9.8545150215E-01],
	[4.9065000000E+04, 5.2120856431E+01, 5.3614722011E+00, 3.5024110121E+01, 4.2688728616E+00, 9.8545728091E-01],
	[4.9070000000E+04, 5.2130362840E+01, 5.3615236842E+00, 3.5035804919E+01, 4.2691429512E+00, 9.8546305701E-01],
	[4.9075000000E+04, 5.2139879137E+01, 5.3615760223E+00, 3.5047502427E+01, 4.2694135839E+00, 9.8546883046E-01],
	[4.9080000000E+04, 5.2149396202E+01, 5.3616283555E+00, 3.5059202647E+01, 4.2696841534E+00, 9.8547460126E-01],
	[4.9085000000E+04, 5.2158914033E+01, 5.3616806840E+00, 3.5070905580E+01, 4.2699546597E+00, 9.8548036941E-01],
	[4.9090000000E+04, 5.2168432633E+01, 5.3617330076E+00, 3.5082611225E+01, 4.2702251028E+00, 9.8548613491E-01],
	[4.9095000000E+04, 5.2177951999E+01, 5.3617853264E+00, 3.5094319583E+01, 4.2704954828E+00, 9.8549189776E-01],
	[4.9100000000E+04, 5.2187472133E+01, 5.3618376404E+00, 3.5106030654E+01, 4.2707657996E+00, 9.8549765797E-01],
	[4.9105000000E+04, 5.2196993034E+01, 5.3618899496E+00, 3.5117744438E+01, 4.2710360533E+00, 9.8550341553E-01],
	[4.9110000000E+04, 5.2206514703E+01, 5.3619422540E+00, 3.5129460937E+01, 4.2713062439E+00, 9.8550917045E-01],
	[4.9115000000E+04, 5.2216037139E+01, 5.3619945535E+00, 3.5141180150E+01, 4.2715763715E+00, 9.8551492273E-01],
	[4.9120000000E+04, 5.2225560342E+01, 5.3620468483E+00, 3.5152902077E+01, 4.2718464359E+00, 9.8552067237E-01],
	[4.9125000000E+04, 5.2235084312E+01, 5.3620991382E+00, 3.5164626719E+01, 4.2721164374E+00, 9.8552641937E-01],
	[4.9130000000E+04, 5.2244609050E+01, 5.3621514233E+00, 3.5176354077E+01, 4.2723863757E+00, 9.8553216374E-01],
	[4.9135000000E+04, 5.2254134554E+01, 5.3622037036E+00, 3.5188084150E+01, 4.2726562511E+00, 9.8553790546E-01],
	[4.9140000000E+04, 5.2263660826E+01, 5.3622559791E+00, 3.5199816939E+01, 4.2729260635E+00, 9.8554364456E-01],
	[4.9145000000E+04, 5.2273187866E+01, 5.3623082497E+00, 3.5211552445E+01, 4.2731958129E+00, 9.8554938101E-01],
	[4.9150000000E+04, 5.2282715672E+01, 5.3623605156E+00, 3.5223290667E+01, 4.2734654994E+00, 9.8555511484E-01],
	[4.9155000000E+04, 5.2292244245E+01, 5.3624127767E+00, 3.5235031607E+01, 4.2737351229E+00, 9.8556084604E-01],
	[4.9160000000E+04, 5.2301773586E+01, 5.3624650329E+00, 3.5246775264E+01, 4.2740046834E+00, 9.8556657461E-01],
	[4.9165000000E+04, 5.2311303694E+01, 5.3625172844E+00, 3.5258521638E+01, 4.2742741811E+00, 9.8557230055E-01],
	[4.9170000000E+04, 5.2320834569E+01, 5.3625695310E+00, 3.5270270731E+01, 4.2745436159E+00, 9.8557802386E-01],
	[4.9175000000E+04, 5.2330366211E+01, 5.3626217729E+00, 3.5282022542E+01, 4.2748129878E+00, 9.8558374455E-01],
	[4.9180000000E+04, 5.2339898620E+01, 5.3626740099E+00, 3.5293777072E+01, 4.2750822969E+00, 9.8558946261E-01],
	[4.9185000000E+04, 5.2349431796E+01, 5.3627262422E+00, 3.5305534322E+01, 4.2753515432E+00, 9.8559517806E-01],
	[4.9190000000E+04, 5.2358965739E+01, 5.3627784696E+00, 3.5317294290E+01, 4.2756207266E+00, 9.8560089088E-01],
	[4.9195000000E+04, 5.2368500449E+01, 5.3628306922E+00, 3.5329056979E+01, 4.2758898472E+00, 9.8560660108E-01],
	[4.9200000000E+04, 5.2378035926E+01, 5.3628829101E+00, 3.5340822388E+01, 4.2761589051E+00, 9.8561230867E-01],
	[4.9205000000E+04, 5.2387572170E+01, 5.3629351231E+00, 3.5352590517E+01, 4.2764279002E+00, 9.8561801363E-01],
	[4.9210000000E+04, 5.2397109181E+01, 5.3629873314E+00, 3.5364361368E+01, 4.2766968325E+00, 9.8562371599E-01],
	[4.9215000000E+04, 5.2406646960E+01, 5.3630395348E+00, 3.5376134940E+01, 4.2769657021E+00, 9.8562941572E-01],
	[4.9220000000E+04, 5.2416185505E+01, 5.3630917335E+00, 3.5387911233E+01, 4.2772345090E+00, 9.8563511285E-01],
	[4.9225000000E+04, 5.2425724817E+01, 5.3631439273E+00, 3.5399690248E+01, 4.2775032533E+00, 9.8564080736E-01],
	[4.9230000000E+04, 5.2435264895E+01, 5.3631961164E+00, 3.5411471986E+01, 4.2777719348E+00, 9.8564649927E-01],
	[4.9235000000E+04, 5.2444805741E+01, 5.3632483007E+00, 3.5423256446E+01, 4.2780405537E+00, 9.8565218856E-01],
	[4.9240000000E+04, 5.2454347354E+01, 5.3633004801E+00, 3.5435043630E+01, 4.2783091100E+00, 9.8565787525E-01],
	[4.9245000000E+04, 5.2463889733E+01, 5.3633526548E+00, 3.5446833537E+01, 4.2785776036E+00, 9.8566355933E-01],
	[4.9250000000E+04, 5.2473432880E+01, 5.3634048247E+00, 3.5458626167E+01, 4.2788460346E+00, 9.8566924081E-01],
	[4.9255000000E+04, 5.2482976793E+01, 5.3634569898E+00, 3.5470421522E+01, 4.2791144031E+00, 9.8567491968E-01],
	[4.9260000000E+04, 5.2492521473E+01, 5.3635091502E+00, 3.5482219601E+01, 4.2793827090E+00, 9.8568059596E-01],
	[4.9265000000E+04, 5.2502066920E+01, 5.3635613057E+00, 3.5494020405E+01, 4.2796509523E+00, 9.8568626963E-01],
	[4.9270000000E+04, 5.2511613133E+01, 5.3636134564E+00, 3.5505823935E+01, 4.2799191331E+00, 9.8569194070E-01],
	[4.9275000000E+04, 5.2521160113E+01, 5.3636656024E+00, 3.5517630189E+01, 4.2801872514E+00, 9.8569760918E-01],
	[4.9280000000E+04, 5.2530707861E+01, 5.3637177436E+00, 3.5529439170E+01, 4.2804553072E+00, 9.8570327506E-01],
	[4.9285000000E+04, 5.2540256374E+01, 5.3637698800E+00, 3.5541250877E+01, 4.2807233005E+00, 9.8570893834E-01],
	[4.9290000000E+04, 5.2549805655E+01, 5.3638220116E+00, 3.5553065310E+01, 4.2809912314E+00, 9.8571459903E-01],
	[4.9295000000E+04, 5.2559355702E+01, 5.3638741384E+00, 3.5564882470E+01, 4.2812590998E+00, 9.8572025713E-01],
	[4.9300000000E+04, 5.2568906516E+01, 5.3639262605E+00, 3.5576702358E+01, 4.2815269058E+00, 9.8572591264E-01],
	[4.9305000000E+04, 5.2578458097E+01, 5.3639783778E+00, 3.5588524973E+01, 4.2817946494E+00, 9.8573156556E-01],
	[4.9310000000E+04, 5.2588010444E+01, 5.3640304903E+00, 3.5600350316E+01, 4.2820623306E+00, 9.8573721589E-01],
	[4.9315000000E+04, 5.2597563558E+01, 5.3640825980E+00, 3.5612178388E+01, 4.2823299495E+00, 9.8574286363E-01],
	[4.9320000000E+04, 5.2607117438E+01, 5.3641347009E+00, 3.5624009188E+01, 4.2825975059E+00, 9.8574850879E-01],
	[4.9325000000E+04, 5.2616672085E+01, 5.3641867991E+00, 3.5635842717E+01, 4.2828650001E+00, 9.8575415136E-01],
	[4.9330000000E+04, 5.2626227499E+01, 5.3642388925E+00, 3.5647678976E+01, 4.2831324319E+00, 9.8575979135E-01],
	[4.9335000000E+04, 5.2635783679E+01, 5.3642909811E+00, 3.5659517965E+01, 4.2833998014E+00, 9.8576542876E-01],
	[4.9340000000E+04, 5.2645340626E+01, 5.3643430649E+00, 3.5671359683E+01, 4.2836671087E+00, 9.8577106359E-01],
	[4.9345000000E+04, 5.2654898339E+01, 5.3643951440E+00, 3.5683204132E+01, 4.2839343537E+00, 9.8577669584E-01],
	[4.9350000000E+04, 5.2664456819E+01, 5.3644472183E+00, 3.5695051312E+01, 4.2842015364E+00, 9.8578232551E-01],
	[4.9355000000E+04, 5.2674016066E+01, 5.3644992878E+00, 3.5706901223E+01, 4.2844686569E+00, 9.8578795261E-01],
	[4.9360000000E+04, 5.2683576078E+01, 5.3645513526E+00, 3.5718753865E+01, 4.2847357152E+00, 9.8579357713E-01],
	[4.9365000000E+04, 5.2693136858E+01, 5.3646034126E+00, 3.5730609240E+01, 4.2850027113E+00, 9.8579919908E-01],
	[4.9370000000E+04, 5.2702698403E+01, 5.3646554678E+00, 3.5742467346E+01, 4.2852696452E+00, 9.8580481846E-01],
	[4.9375000000E+04, 5.2712260716E+01, 5.3647075183E+00, 3.5754328185E+01, 4.2855365170E+00, 9.8581043526E-01],
	[4.9380000000E+04, 5.2721823794E+01, 5.3647595640E+00, 3.5766191757E+01, 4.2858033266E+00, 9.8581604950E-01],
	[4.9385000000E+04, 5.2731387639E+01, 5.3648116049E+00, 3.5778058062E+01, 4.2860700741E+00, 9.8582166117E-01],
	[4.9390000000E+04, 5.2740952251E+01, 5.3648636411E+00, 3.5789927101E+01, 4.2863367595E+00, 9.8582727027E-01],
	[4.9395000000E+04, 5.2750517629E+01, 5.3649156725E+00, 3.5801798874E+01, 4.2866033829E+00, 9.8583287681E-01],
	[4.9400000000E+04, 5.2760083773E+01, 5.3649676991E+00, 3.5813673381E+01, 4.2868699441E+00, 9.8583848078E-01],
	[4.9405000000E+04, 5.2769650683E+01, 5.3650197210E+00, 3.5825550623E+01, 4.2871364433E+00, 9.8584408219E-01],
	[4.9410000000E+04, 5.2779218360E+01, 5.3650717381E+00, 3.5837430600E+01, 4.2874028804E+00, 9.8584968104E-01],
	[4.9415000000E+04, 5.2788786803E+01, 5.3651237504E+00, 3.5849313312E+01, 4.2876692556E+00, 9.8585527733E-01],
	[4.9420000000E+04, 5.2798356013E+01, 5.3651757580E+00, 3.5861198760E+01, 4.2879355687E+00, 9.8586087106E-01],
	[4.9425000000E+04, 5.2807925988E+01, 5.3652277609E+00, 3.5873086945E+01, 4.2882018199E+00, 9.8586646224E-01],
	[4.9430000000E+04, 5.2817496730E+01, 5.3652797590E+00, 3.5884977865E+01, 4.2884680091E+00, 9.8587205086E-01],
	[4.9435000000E+04, 5.2827068239E+01, 5.3653317523E+00, 3.5896871522E+01, 4.2887341363E+00, 9.8587763692E-01],
	[4.9440000000E+04, 5.2836640513E+01, 5.3653837409E+00, 3.5908767917E+01, 4.2890002016E+00, 9.8588322043E-01],
	[4.9445000000E+04, 5.2846213554E+01, 5.3654357247E+00, 3.5920667049E+01, 4.2892662051E+00, 9.8588880139E-01],
	[4.9450000000E+04, 5.2855787361E+01, 5.3654877038E+00, 3.5932568919E+01, 4.2895321466E+00, 9.8589437980E-01],
	[4.9455000000E+04, 5.2865361934E+01, 5.3655396781E+00, 3.5944473527E+01, 4.2897980262E+00, 9.8589995566E-01],
	[4.9460000000E+04, 5.2874937273E+01, 5.3655916476E+00, 3.5956380873E+01, 4.2900638440E+00, 9.8590552897E-01],
	[4.9465000000E+04, 5.2884513378E+01, 5.3656436125E+00, 3.5968290959E+01, 4.2903295999E+00, 9.8591109974E-01],
	[4.9470000000E+04, 5.2894090250E+01, 5.3656955725E+00, 3.5980203784E+01, 4.2905952941E+00, 9.8591666796E-01],
	[4.9475000000E+04, 5.2903667888E+01, 5.3657475278E+00, 3.5992119348E+01, 4.2908609264E+00, 9.8592223363E-01],
	[4.9480000000E+04, 5.2913246291E+01, 5.3657994784E+00, 3.6004037653E+01, 4.2911264969E+00, 9.8592779677E-01],
	[4.9485000000E+04, 5.2922825461E+01, 5.3658514242E+00, 3.6015958697E+01, 4.2913920057E+00, 9.8593335736E-01],
	[4.9490000000E+04, 5.2932405397E+01, 5.3659033653E+00, 3.6027882483E+01, 4.2916574527E+00, 9.8593891541E-01],
	[4.9495000000E+04, 5.2941986099E+01, 5.3659553016E+00, 3.6039809009E+01, 4.2919228379E+00, 9.8594447093E-01],
	[4.9500000000E+04, 5.2951567567E+01, 5.3660072332E+00, 3.6051738277E+01, 4.2921881615E+00, 9.8595002390E-01],
	[4.9505000000E+04, 5.2961149801E+01, 5.3660591601E+00, 3.6063670286E+01, 4.2924534233E+00, 9.8595557435E-01],
	[4.9510000000E+04, 5.2970732801E+01, 5.3661110822E+00, 3.6075605038E+01, 4.2927186235E+00, 9.8596112225E-01],
	[4.9515000000E+04, 5.2980316567E+01, 5.3661629995E+00, 3.6087542532E+01, 4.2929837620E+00, 9.8596666763E-01],
	[4.9520000000E+04, 5.2989901099E+01, 5.3662149122E+00, 3.6099482769E+01, 4.2932488389E+00, 9.8597221047E-01],
	[4.9525000000E+04, 5.2999486397E+01, 5.3662668201E+00, 3.6111425749E+01, 4.2935138541E+00, 9.8597775078E-01],
	[4.9530000000E+04, 5.3009072460E+01, 5.3663187232E+00, 3.6123371472E+01, 4.2937788077E+00, 9.8598328857E-01],
	[4.9535000000E+04, 5.3018659290E+01, 5.3663706216E+00, 3.6135319939E+01, 4.2940436997E+00, 9.8598882382E-01],
	[4.9540000000E+04, 5.3028246886E+01, 5.3664225153E+00, 3.6147271151E+01, 4.2943085302E+00, 9.8599435655E-01],
	[4.9545000000E+04, 5.3037835247E+01, 5.3664744042E+00, 3.6159225107E+01, 4.2945732990E+00, 9.8599988675E-01],
	[4.9550000000E+04, 5.3047424375E+01, 5.3665262884E+00, 3.6171181808E+01, 4.2948380064E+00, 9.8600541443E-01],
	[4.9555000000E+04, 5.3057014268E+01, 5.3665781679E+00, 3.6183141254E+01, 4.2951026522E+00, 9.8601093959E-01],
	[4.9560000000E+04, 5.3066604927E+01, 5.3666300426E+00, 3.6195103446E+01, 4.2953672365E+00, 9.8601646223E-01],
	[4.9565000000E+04, 5.3076196352E+01, 5.3666819126E+00, 3.6207068384E+01, 4.2956317593E+00, 9.8602198235E-01],
	[4.9570000000E+04, 5.3085788543E+01, 5.3667337779E+00, 3.6219036068E+01, 4.2958962207E+00, 9.8602749994E-01],
	[4.9575000000E+04, 5.3095381500E+01, 5.3667856384E+00, 3.6231006499E+01, 4.2961606206E+00, 9.8603301503E-01],
	[4.9580000000E+04, 5.3104975222E+01, 5.3668374943E+00, 3.6242979676E+01, 4.2964249590E+00, 9.8603852759E-01],
	[4.9585000000E+04, 5.3114569710E+01, 5.3668893453E+00, 3.6254955602E+01, 4.2966892361E+00, 9.8604403764E-01],
	[4.9590000000E+04, 5.3124164964E+01, 5.3669411917E+00, 3.6266934274E+01, 4.2969534517E+00, 9.8604954518E-01],
	[4.9595000000E+04, 5.3133760984E+01, 5.3669930333E+00, 3.6278915695E+01, 4.2972176060E+00, 9.8605505021E-01],
	[4.9600000000E+04, 5.3143357769E+01, 5.3670448702E+00, 3.6290899865E+01, 4.2974816988E+00, 9.8606055272E-01],
	[4.9605000000E+04, 5.3152955320E+01, 5.3670967024E+00, 3.6302886783E+01, 4.2977457304E+00, 9.8606605273E-01],
	[4.9610000000E+04, 5.3162553637E+01, 5.3671485299E+00, 3.6314876450E+01, 4.2980097006E+00, 9.8607155023E-01],
	[4.9615000000E+04, 5.3172152719E+01, 5.3672003526E+00, 3.6326868867E+01, 4.2982736095E+00, 9.8607704522E-01],
	[4.9620000000E+04, 5.3181752567E+01, 5.3672521706E+00, 3.6338864034E+01, 4.2985374571E+00, 9.8608253771E-01],
	[4.9625000000E+04, 5.3191353181E+01, 5.3673039839E+00, 3.6350861951E+01, 4.2988012434E+00, 9.8608802769E-01],
	[4.9630000000E+04, 5.3200954560E+01, 5.3673557925E+00, 3.6362862618E+01, 4.2990649684E+00, 9.8609351517E-01],
	[4.9635000000E+04, 5.3210556705E+01, 5.3674075963E+00, 3.6374866036E+01, 4.2993286322E+00, 9.8609900015E-01],
	[4.9640000000E+04, 5.3220159615E+01, 5.3674593955E+00, 3.6386872206E+01, 4.2995922348E+00, 9.8610448263E-01],
	[4.9645000000E+04, 5.3229763291E+01, 5.3675111899E+00, 3.6398881127E+01, 4.2998557762E+00, 9.8610996261E-01],
	[4.9650000000E+04, 5.3239367733E+01, 5.3675629796E+00, 3.6410892800E+01, 4.3001192564E+00, 9.8611544010E-01],
	[4.9655000000E+04, 5.3248972940E+01, 5.3676147646E+00, 3.6422907226E+01, 4.3003826754E+00, 9.8612091509E-01],
	[4.9660000000E+04, 5.3258578912E+01, 5.3676665448E+00, 3.6434924404E+01, 4.3006460332E+00, 9.8612638758E-01],
	[4.9665000000E+04, 5.3268185651E+01, 5.3677183204E+00, 3.6446944335E+01, 4.3009093299E+00, 9.8613185758E-01],
	[4.9670000000E+04, 5.3277793154E+01, 5.3677700912E+00, 3.6458967020E+01, 4.3011725655E+00, 9.8613732509E-01],
	[4.9675000000E+04, 5.3287401423E+01, 5.3678218574E+00, 3.6470992458E+01, 4.3014357400E+00, 9.8614279011E-01],
	[4.9680000000E+04, 5.3297010458E+01, 5.3678736188E+00, 3.6483020650E+01, 4.3016988534E+00, 9.8614825263E-01],
	[4.9685000000E+04, 5.3306620258E+01, 5.3679253755E+00, 3.6495051597E+01, 4.3019619057E+00, 9.8615371267E-01],
	[4.9690000000E+04, 5.3316230823E+01, 5.3679771275E+00, 3.6507085299E+01, 4.3022248970E+00, 9.8615917023E-01],
	[4.9695000000E+04, 5.3325842154E+01, 5.3680288748E+00, 3.6519121755E+01, 4.3024878272E+00, 9.8616462530E-01],
	[4.9700000000E+04, 5.3335454250E+01, 5.3680806174E+00, 3.6531160967E+01, 4.3027506964E+00, 9.8617007788E-01],
	[4.9705000000E+04, 5.3345067112E+01, 5.3681323553E+00, 3.6543202935E+01, 4.3030135047E+00, 9.8617552798E-01],
	[4.9710000000E+04, 5.3354680739E+01, 5.3681840884E+00, 3.6555247660E+01, 4.3032762519E+00, 9.8618097560E-01],
	[4.9715000000E+04, 5.3364295131E+01, 5.3682358169E+00, 3.6567295140E+01, 4.3035389382E+00, 9.8618642074E-01],
	[4.9720000000E+04, 5.3373910289E+01, 5.3682875407E+00, 3.6579345378E+01, 4.3038015635E+00, 9.8619186340E-01],
	[4.9725000000E+04, 5.3383526212E+01, 5.3683392597E+00, 3.6591398373E+01, 4.3040641279E+00, 9.8619730359E-01],
	[4.9730000000E+04, 5.3393142900E+01, 5.3683909741E+00, 3.6603454126E+01, 4.3043266313E+00, 9.8620274129E-01],
	[4.9735000000E+04, 5.3402760353E+01, 5.3684426837E+00, 3.6615512636E+01, 4.3045890739E+00, 9.8620817652E-01],
	[4.9740000000E+04, 5.3412378572E+01, 5.3684943887E+00, 3.6627573905E+01, 4.3048514556E+00, 9.8621360928E-01],
	[4.9745000000E+04, 5.3421997556E+01, 5.3685460890E+00, 3.6639637932E+01, 4.3051137764E+00, 9.8621903957E-01],
	[4.9750000000E+04, 5.3431617305E+01, 5.3685977845E+00, 3.6651704719E+01, 4.3053760364E+00, 9.8622446738E-01],
	[4.9755000000E+04, 5.3441237820E+01, 5.3686494754E+00, 3.6663774265E+01, 4.3056382356E+00, 9.8622989273E-01],
	[4.9760000000E+04, 5.3450859099E+01, 5.3687011615E+00, 3.6675846571E+01, 4.3059003740E+00, 9.8623531561E-01],
	[4.9765000000E+04, 5.3460481144E+01, 5.3687528430E+00, 3.6687921636E+01, 4.3061624515E+00, 9.8624073602E-01],
	[4.9770000000E+04, 5.3470103954E+01, 5.3688045198E+00, 3.6699999462E+01, 4.3064244683E+00, 9.8624615396E-01],
	[4.9775000000E+04, 5.3479727529E+01, 5.3688561919E+00, 3.6712080049E+01, 4.3066864244E+00, 9.8625156944E-01],
	[4.9780000000E+04, 5.3489351870E+01, 5.3689078593E+00, 3.6724163397E+01, 4.3069483196E+00, 9.8625698246E-01],
	[4.9785000000E+04, 5.3498976975E+01, 5.3689595220E+00, 3.6736249507E+01, 4.3072101542E+00, 9.8626239301E-01],
	[4.9790000000E+04, 5.3508602846E+01, 5.3690111800E+00, 3.6748338378E+01, 4.3074719281E+00, 9.8626780111E-01],
	[4.9795000000E+04, 5.3518229481E+01, 5.3690628333E+00, 3.6760430012E+01, 4.3077336413E+00, 9.8627320674E-01],
	[4.9800000000E+04, 5.3527856882E+01, 5.3691144819E+00, 3.6772524408E+01, 4.3079952938E+00, 9.8627860992E-01],
	[4.9805000000E+04, 5.3537485048E+01, 5.3691661258E+00, 3.6784621567E+01, 4.3082568856E+00, 9.8628401064E-01],
	[4.9810000000E+04, 5.3547113979E+01, 5.3692177651E+00, 3.6796721490E+01, 4.3085184168E+00, 9.8628940891E-01],
	[4.9815000000E+04, 5.3556743674E+01, 5.3692693996E+00, 3.6808824176E+01, 4.3087798874E+00, 9.8629480472E-01],
	[4.9820000000E+04, 5.3566374135E+01, 5.3693210295E+00, 3.6820929625E+01, 4.3090412974E+00, 9.8630019808E-01],
	[4.9825000000E+04, 5.3576005361E+01, 5.3693726547E+00, 3.6833037840E+01, 4.3093026469E+00, 9.8630558899E-01],
	[4.9830000000E+04, 5.3585637352E+01, 5.3694242752E+00, 3.6845148819E+01, 4.3095639357E+00, 9.8631097744E-01],
	[4.9835000000E+04, 5.3595270107E+01, 5.3694758910E+00, 3.6857262563E+01, 4.3098251640E+00, 9.8631636345E-01],
	[4.9840000000E+04, 5.3604903628E+01, 5.3695275022E+00, 3.6869379072E+01, 4.3100863318E+00, 9.8632174701E-01],
	[4.9845000000E+04, 5.3614537914E+01, 5.3695791086E+00, 3.6881498347E+01, 4.3103474390E+00, 9.8632712813E-01],
	[4.9850000000E+04, 5.3624172964E+01, 5.3696307104E+00, 3.6893620388E+01, 4.3106084858E+00, 9.8633250680E-01],
	[4.9855000000E+04, 5.3633808780E+01, 5.3696823075E+00, 3.6905745196E+01, 4.3108694720E+00, 9.8633788302E-01],
	[4.9860000000E+04, 5.3643453914E+01, 5.3697346893E+00, 3.6917872770E+01, 4.3111309619E+00, 9.8634325681E-01],
	[4.9865000000E+04, 5.3653108664E+01, 5.3697878826E+00, 3.6930003112E+01, 4.3113929747E+00, 9.8634862815E-01],
	[4.9870000000E+04, 5.3662764183E+01, 5.3698410711E+00, 3.6942136221E+01, 4.3116549272E+00, 9.8635399705E-01],
	[4.9875000000E+04, 5.3672420471E+01, 5.3698942548E+00, 3.6954272098E+01, 4.3119168193E+00, 9.8635936352E-01],
	[4.9880000000E+04, 5.3682077529E+01, 5.3699474337E+00, 3.6966410743E+01, 4.3121786512E+00, 9.8636472754E-01],
	[4.9885000000E+04, 5.3691735356E+01, 5.3700006078E+00, 3.6978552156E+01, 4.3124404228E+00, 9.8637008914E-01],
	[4.9890000000E+04, 5.3701393952E+01, 5.3700537771E+00, 3.6990696339E+01, 4.3127021342E+00, 9.8637544829E-01],
	[4.9895000000E+04, 5.3711053317E+01, 5.3701069415E+00, 3.7002843291E+01, 4.3129637853E+00, 9.8638080502E-01],
	[4.9900000000E+04, 5.3720713452E+01, 5.3701601012E+00, 3.7014993012E+01, 4.3132253762E+00, 9.8638615931E-01],
	[4.9905000000E+04, 5.3730374356E+01, 5.3702132561E+00, 3.7027145504E+01, 4.3134869069E+00, 9.8639151117E-01],
	[4.9910000000E+04, 5.3740036029E+01, 5.3702664062E+00, 3.7039300765E+01, 4.3137483773E+00, 9.8639686060E-01],
	[4.9915000000E+04, 5.3749698472E+01, 5.3703195515E+00, 3.7051458798E+01, 4.3140097877E+00, 9.8640220760E-01],
	[4.9920000000E+04, 5.3759361684E+01, 5.3703726920E+00, 3.7063619601E+01, 4.3142711378E+00, 9.8640755218E-01],
	[4.9925000000E+04, 5.3769025664E+01, 5.3704258277E+00, 3.7075783176E+01, 4.3145324278E+00, 9.8641289433E-01],
	[4.9930000000E+04, 5.3778690414E+01, 5.3704789585E+00, 3.7087949523E+01, 4.3147936578E+00, 9.8641823406E-01],
	[4.9935000000E+04, 5.3788355934E+01, 5.3705320846E+00, 3.7100118641E+01, 4.3150548276E+00, 9.8642357136E-01],
	[4.9940000000E+04, 5.3798022222E+01, 5.3705852060E+00, 3.7112290532E+01, 4.3153159373E+00, 9.8642890624E-01],
	[4.9945000000E+04, 5.3807689279E+01, 5.3706383225E+00, 3.7124465196E+01, 4.3155769869E+00, 9.8643423870E-01],
	[4.9950000000E+04, 5.3817357106E+01, 5.3706914342E+00, 3.7136642634E+01, 4.3158379765E+00, 9.8643956874E-01],
	[4.9955000000E+04, 5.3827025702E+01, 5.3707445411E+00, 3.7148822844E+01, 4.3160989061E+00, 9.8644489636E-01],
	[4.9960000000E+04, 5.3836695066E+01, 5.3707976433E+00, 3.7161005829E+01, 4.3163597756E+00, 9.8645022156E-01],
	[4.9965000000E+04, 5.3846365200E+01, 5.3708507406E+00, 3.7173191587E+01, 4.3166205852E+00, 9.8645554435E-01],
	[4.9970000000E+04, 5.3856036103E+01, 5.3709038332E+00, 3.7185380121E+01, 4.3168813347E+00, 9.8646086472E-01],
	[4.9975000000E+04, 5.3865707775E+01, 5.3709569209E+00, 3.7197571429E+01, 4.3171420243E+00, 9.8646618268E-01],
	[4.9980000000E+04, 5.3875380216E+01, 5.3710100039E+00, 3.7209765512E+01, 4.3174026540E+00, 9.8647149822E-01],
	[4.9985000000E+04, 5.3885053426E+01, 5.3710630821E+00, 3.7221962371E+01, 4.3176632237E+00, 9.8647681135E-01],
	[4.9990000000E+04, 5.3894727404E+01, 5.3711161556E+00, 3.7234162006E+01, 4.3179237335E+00, 9.8648212207E-01],
	[4.9995000000E+04, 5.3904402152E+01, 5.3711692242E+00, 3.7246364418E+01, 4.3181841834E+00, 9.8648743038E-01],
	[5.0000000000E+04, 5.3914077669E+01, 5.3712222880E+00, 3.7258569606E+01, 4.3184445734E+00, 9.8649273629E-01],
	[5.0005000000E+04, 5.3923753955E+01, 5.3712753471E+00, 3.7270791429E+01, 4.3187050896E+00, 9.8649803978E-01],
	[5.0010000000E+04, 5.3933431009E+01, 5.3713284014E+00, 3.7283016038E+01, 4.3189655459E+00, 9.8650334087E-01],
	[5.0015000000E+04, 5.3943108833E+01, 5.3713814509E+00, 3.7295243432E+01, 4.3192259423E+00, 9.8650863956E-01],
	[5.0020000000E+04, 5.3952787425E+01, 5.3714344956E+00, 3.7307473612E+01, 4.3194862787E+00, 9.8651393584E-01],
	[5.0025000000E+04, 5.3962