import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[MEAN FREE PATHS (cm)]
#[Energy (eV) 	| Rayleigh 	| Compton 	| Photoelectric 	| TOTAL (+pair prod) (cm) | Rayleigh: max cumul prob F^2]

air_MFP = np.array([
	[5.00000E+03, 1.5943324433E+03, 8.4751677030E+03, 2.0955140803E+01, 2.0632935757E+01, 3.3354391772E-01],
	[5.00500E+03, 1.5961389796E+03, 8.4699304607E+03, 2.1018226845E+01, 2.0694366639E+01, 3.3379312979E-01],
	[5.01000E+03, 1.5979457560E+03, 8.4647016793E+03, 2.1081439184E+01, 2.0755916884E+01, 3.3404209784E-01],
	[5.01500E+03, 1.5997527723E+03, 8.4594813367E+03, 2.1144777945E+01, 2.0817586593E+01, 3.3429082247E-01],
	[5.02000E+03, 1.6015600283E+03, 8.4542694110E+03, 2.1208243252E+01, 2.0879375869E+01, 3.3453930430E-01],
	[5.02500E+03, 1.6033675238E+03, 8.4490658801E+03, 2.1271835231E+01, 2.0941284814E+01, 3.3478754393E-01],
	[5.03000E+03, 1.6051752585E+03, 8.4438707222E+03, 2.1335554008E+01, 2.1003313532E+01, 3.3503554195E-01],
	[5.03500E+03, 1.6069832322E+03, 8.4386839156E+03, 2.1399399708E+01, 2.1065462124E+01, 3.3528329896E-01],
	[5.04000E+03, 1.6087914448E+03, 8.4335054385E+03, 2.1463372456E+01, 2.1127730693E+01, 3.3553081555E-01],
	[5.04500E+03, 1.6105998961E+03, 8.4283352693E+03, 2.1527472376E+01, 2.1190119340E+01, 3.3577809237E-01],
	[5.05000E+03, 1.6124085858E+03, 8.4231733866E+03, 2.1591699595E+01, 2.1252628169E+01, 3.3602513015E-01],
	[5.05500E+03, 1.6142413571E+03, 8.4181716562E+03, 2.1656054238E+01, 2.1315262412E+01, 3.3627192956E-01],
	[5.06000E+03, 1.6160773428E+03, 8.4131965712E+03, 2.1720536430E+01, 2.1378017724E+01, 3.3651849127E-01],
	[5.06500E+03, 1.6179136002E+03, 8.4082293357E+03, 2.1785146296E+01, 2.1440893577E+01, 3.3676481594E-01],
	[5.07000E+03, 1.6197501292E+03, 8.4032699296E+03, 2.1849883962E+01, 2.1503890073E+01, 3.3701090422E-01],
	[5.07500E+03, 1.6215869295E+03, 8.3983183329E+03, 2.1914749552E+01, 2.1567007313E+01, 3.3725675678E-01],
	[5.08000E+03, 1.6234240009E+03, 8.3933745257E+03, 2.1979743192E+01, 2.1630245401E+01, 3.3750237425E-01],
	[5.08500E+03, 1.6252613432E+03, 8.3884384880E+03, 2.2044865007E+01, 2.1693604439E+01, 3.3774775730E-01],
	[5.09000E+03, 1.6270989561E+03, 8.3835101999E+03, 2.2110115122E+01, 2.1757084527E+01, 3.3799290657E-01],
	[5.09500E+03, 1.6289368394E+03, 8.3785896418E+03, 2.2175493663E+01, 2.1820685769E+01, 3.3823782271E-01],
	[5.10000E+03, 1.6307749929E+03, 8.3736767940E+03, 2.2241000755E+01, 2.1884408266E+01, 3.3848250635E-01],
	[5.10500E+03, 1.6326134164E+03, 8.3687716367E+03, 2.2306636523E+01, 2.1948252120E+01, 3.3872695814E-01],
	[5.11000E+03, 1.6344521096E+03, 8.3638741505E+03, 2.2372401092E+01, 2.2012217433E+01, 3.3897117871E-01],
	[5.11500E+03, 1.6362910723E+03, 8.3589843159E+03, 2.2438294587E+01, 2.2076304306E+01, 3.3921516871E-01],
	[5.12000E+03, 1.6381303044E+03, 8.3541021134E+03, 2.2504317134E+01, 2.2140512841E+01, 3.3945892877E-01],
	[5.12500E+03, 1.6399698054E+03, 8.3492275237E+03, 2.2570468857E+01, 2.2204843141E+01, 3.3970245951E-01],
	[5.13000E+03, 1.6418095754E+03, 8.3443605276E+03, 2.2636749883E+01, 2.2269295306E+01, 3.3994576157E-01],
	[5.13500E+03, 1.6436496139E+03, 8.3395011057E+03, 2.2703160336E+01, 2.2333869437E+01, 3.4018883558E-01],
	[5.14000E+03, 1.6454899209E+03, 8.3346492391E+03, 2.2769700341E+01, 2.2398565637E+01, 3.4043168215E-01],
	[5.14500E+03, 1.6473304960E+03, 8.3298049085E+03, 2.2836370024E+01, 2.2463384007E+01, 3.4067430191E-01],
	[5.15000E+03, 1.6491713391E+03, 8.3249680950E+03, 2.2903169509E+01, 2.2528324648E+01, 3.4091669548E-01],
	[5.15500E+03, 1.6510124499E+03, 8.3201387796E+03, 2.2970098923E+01, 2.2593387660E+01, 3.4115886347E-01],
	[5.16000E+03, 1.6528538283E+03, 8.3153169435E+03, 2.3037158389E+01, 2.2658573147E+01, 3.4140080651E-01],
	[5.16500E+03, 1.6546954739E+03, 8.3105025679E+03, 2.3104348034E+01, 2.2723881208E+01, 3.4164252520E-01],
	[5.17000E+03, 1.6565373866E+03, 8.3056956339E+03, 2.3171667982E+01, 2.2789311945E+01, 3.4188402016E-01],
	[5.17500E+03, 1.6583795661E+03, 8.3008961229E+03, 2.3239118359E+01, 2.2854865458E+01, 3.4212529200E-01],
	[5.18000E+03, 1.6602220123E+03, 8.2961040163E+03, 2.3306699289E+01, 2.2920541850E+01, 3.4236634131E-01],
	[5.18500E+03, 1.6620647249E+03, 8.2913192956E+03, 2.3374410899E+01, 2.2986341220E+01, 3.4260716872E-01],
	[5.19000E+03, 1.6639077037E+03, 8.2865419422E+03, 2.3442253312E+01, 2.3052263669E+01, 3.4284777481E-01],
	[5.19500E+03, 1.6657509485E+03, 8.2817719377E+03, 2.3510226655E+01, 2.3118309299E+01, 3.4308816019E-01],
	[5.20000E+03, 1.6675944590E+03, 8.2770092638E+03, 2.3578331052E+01, 2.3184478209E+01, 3.4332832546E-01],
	[5.20500E+03, 1.6694382351E+03, 8.2722539021E+03, 2.3646566628E+01, 2.3250770501E+01, 3.4356827121E-01],
	[5.21000E+03, 1.6712822765E+03, 8.2675058345E+03, 2.3714933509E+01, 2.3317186276E+01, 3.4380799804E-01],
	[5.21500E+03, 1.6731265831E+03, 8.2627650427E+03, 2.3783431820E+01, 2.3383725633E+01, 3.4404750654E-01],
	[5.22000E+03, 1.6749711545E+03, 8.2580315087E+03, 2.3852061686E+01, 2.3450388674E+01, 3.4428679730E-01],
	[5.22500E+03, 1.6768159906E+03, 8.2533052144E+03, 2.3920823232E+01, 2.3517175498E+01, 3.4452587090E-01],
	[5.23000E+03, 1.6786610911E+03, 8.2485861417E+03, 2.3989716583E+01, 2.3584086207E+01, 3.4476472793E-01],
	[5.23500E+03, 1.6805064559E+03, 8.2438742729E+03, 2.4058741864E+01, 2.3651120900E+01, 3.4500336898E-01],
	[5.24000E+03, 1.6823520848E+03, 8.2391695900E+03, 2.4127899201E+01, 2.3718279677E+01, 3.4524179463E-01],
	[5.24500E+03, 1.6841979774E+03, 8.2344720752E+03, 2.4197188718E+01, 2.3785562640E+01, 3.4548000546E-01],
	[5.25000E+03, 1.6860441337E+03, 8.2297817109E+03, 2.4266610541E+01, 2.3852969887E+01, 3.4571800204E-01],
	[5.25500E+03, 1.6879053902E+03, 8.2251920486E+03, 2.4336164794E+01, 2.3920505291E+01, 3.4595578494E-01],
	[5.26000E+03, 1.6897768389E+03, 8.2206717045E+03, 2.4405851604E+01, 2.3988167741E+01, 3.4619335475E-01],
	[5.26500E+03, 1.6916485815E+03, 8.2161581360E+03, 2.4475671094E+01, 2.4055954833E+01, 3.4643071204E-01],
	[5.27000E+03, 1.6935206177E+03, 8.2116513265E+03, 2.4545623391E+01, 2.4123866666E+01, 3.4666785737E-01],
	[5.27500E+03, 1.6953929473E+03, 8.2071512595E+03, 2.4615708618E+01, 2.4191903340E+01, 3.4690479132E-01],
	[5.28000E+03, 1.6972655702E+03, 8.2026579185E+03, 2.4685926902E+01, 2.4260064956E+01, 3.4714151444E-01],
	[5.28500E+03, 1.6991384860E+03, 8.1981712871E+03, 2.4756278367E+01, 2.4328351613E+01, 3.4737802730E-01],
	[5.29000E+03, 1.7010116946E+03, 8.1936913490E+03, 2.4826763138E+01, 2.4396763411E+01, 3.4761433047E-01],
	[5.29500E+03, 1.7028851956E+03, 8.1892180878E+03, 2.4897381341E+01, 2.4465300450E+01, 3.4785042450E-01],
	[5.30000E+03, 1.7047589889E+03, 8.1847514874E+03, 2.4968133101E+01, 2.4533962830E+01, 3.4808630995E-01],
	[5.30500E+03, 1.7066330743E+03, 8.1802915315E+03, 2.5039018542E+01, 2.4602750651E+01, 3.4832198738E-01],
	[5.31000E+03, 1.7085074515E+03, 8.1758382040E+03, 2.5110037790E+01, 2.4671664013E+01, 3.4855745734E-01],
	[5.31500E+03, 1.7103821202E+03, 8.1713914888E+03, 2.5181190969E+01, 2.4740703015E+01, 3.4879272039E-01],
	[5.32000E+03, 1.7122570803E+03, 8.1669513700E+03, 2.5252478206E+01, 2.4809867756E+01, 3.4902777707E-01],
	[5.32500E+03, 1.7141323316E+03, 8.1625178314E+03, 2.5323899624E+01, 2.4879158337E+01, 3.4926262794E-01],
	[5.33000E+03, 1.7160078737E+03, 8.1580908573E+03, 2.5395455349E+01, 2.4948574856E+01, 3.4949727354E-01],
	[5.33500E+03, 1.7178837065E+03, 8.1536704318E+03, 2.5467145507E+01, 2.5018117413E+01, 3.4973171441E-01],
	[5.34000E+03, 1.7197598298E+03, 8.1492565389E+03, 2.5538970221E+01, 2.5087786108E+01, 3.4996595111E-01],
	[5.34500E+03, 1.7216362432E+03, 8.1448491631E+03, 2.5610929617E+01, 2.5157581039E+01, 3.5019998416E-01],
	[5.35000E+03, 1.7235129467E+03, 8.1404482885E+03, 2.5683023821E+01, 2.5227502306E+01, 3.5043381413E-01],
	[5.35500E+03, 1.7253899399E+03, 8.1360538996E+03, 2.5755252957E+01, 2.5297550008E+01, 3.5066744166E-01],
	[5.36000E+03, 1.7272672226E+03, 8.1316659806E+03, 2.5827617150E+01, 2.5367724245E+01, 3.5090086733E-01],
	[5.36500E+03, 1.7291447947E+03, 8.1272845162E+03, 2.5900116525E+01, 2.5438025114E+01, 3.5113409172E-01],
	[5.37000E+03, 1.7310226558E+03, 8.1229094907E+03, 2.5972751207E+01, 2.5508452716E+01, 3.5136711542E-01],
	[5.37500E+03, 1.7329008058E+03, 8.1185408888E+03, 2.6045521322E+01, 2.5579007148E+01, 3.5159993899E-01],
	[5.38000E+03, 1.7347792445E+03, 8.1141786950E+03, 2.6118426994E+01, 2.5649688511E+01, 3.5183256302E-01],
	[5.38500E+03, 1.7366579715E+03, 8.1098228940E+03, 2.6191468349E+01, 2.5720496902E+01, 3.5206498806E-01],
	[5.39000E+03, 1.7385369868E+03, 8.1054734705E+03, 2.6264645510E+01, 2.5791432420E+01, 3.5229721470E-01],
	[5.39500E+03, 1.7404162900E+03, 8.1011304092E+03, 2.6337958605E+01, 2.5862495165E+01, 3.5252924350E-01],
	[5.40000E+03, 1.7422958809E+03, 8.0967936951E+03, 2.6411407756E+01, 2.5933685234E+01, 3.5276107502E-01],
	[5.40500E+03, 1.7441757594E+03, 8.0924633129E+03, 2.6484993090E+01, 2.6005002726E+01, 3.5299270982E-01],
	[5.41000E+03, 1.7460559252E+03, 8.0881392475E+03, 2.6558714731E+01, 2.6076447740E+01, 3.5322414847E-01],
	[5.41500E+03, 1.7479363780E+03, 8.0838214839E+03, 2.6632572805E+01, 2.6148020375E+01, 3.5345539153E-01],
	[5.42000E+03, 1.7498171177E+03, 8.0795100072E+03, 2.6706567436E+01, 2.6219720727E+01, 3.5368643956E-01],
	[5.42500E+03, 1.7516981440E+03, 8.0752048023E+03, 2.6780698750E+01, 2.6291548896E+01, 3.5391729310E-01],
	[5.43000E+03, 1.7535794568E+03, 8.0709058544E+03, 2.6854966871E+01, 2.6363504980E+01, 3.5414795272E-01],
	[5.43500E+03, 1.7554610557E+03, 8.0666131487E+03, 2.6929371924E+01, 2.6435589078E+01, 3.5437841896E-01],
	[5.44000E+03, 1.7573429406E+03, 8.0623266703E+03, 2.7003914034E+01, 2.6507801286E+01, 3.5460869238E-01],
	[5.44500E+03, 1.7592251113E+03, 8.0580464045E+03, 2.7078593327E+01, 2.6580141704E+01, 3.5483877353E-01],
	[5.45000E+03, 1.7611075675E+03, 8.0537723366E+03, 2.7153409927E+01, 2.6652610429E+01, 3.5506866294E-01],
	[5.45500E+03, 1.7629903090E+03, 8.0495044519E+03, 2.7228363960E+01, 2.6725207559E+01, 3.5529836116E-01],
	[5.46000E+03, 1.7648733356E+03, 8.0452427359E+03, 2.7303455549E+01, 2.6797933192E+01, 3.5552786874E-01],
	[5.46500E+03, 1.7667725894E+03, 8.0410873737E+03, 2.7378684821E+01, 2.6870792232E+01, 3.5575718622E-01],
	[5.47000E+03, 1.7686789123E+03, 8.0369804057E+03, 2.7454051900E+01, 2.6943782059E+01, 3.5598631413E-01],
	[5.47500E+03, 1.7705855476E+03, 8.0328792849E+03, 2.7529556911E+01, 2.7016900741E+01, 3.5621525302E-01],
	[5.48000E+03, 1.7724924950E+03, 8.0287839975E+03, 2.7605490034E+01, 2.7090427708E+01, 3.5644400341E-01],
	[5.48500E+03, 1.7743997542E+03, 8.0246945300E+03, 2.7681796678E+01, 2.7164310308E+01, 3.5667256584E-01],
	[5.49000E+03, 1.7763073251E+03, 8.0206108688E+03, 2.7758243988E+01, 2.7238324253E+01, 3.5690094084E-01],
	[5.49500E+03, 1.7782152075E+03, 8.0165330004E+03, 2.7834832092E+01, 2.7312469644E+01, 3.5712912895E-01],
	[5.50000E+03, 1.7801234009E+03, 8.0124609112E+03, 2.7911561121E+01, 2.7386746582E+01, 3.5735713068E-01],
	[5.50500E+03, 1.7820319054E+03, 8.0083945879E+03, 2.7988431202E+01, 2.7461155170E+01, 3.5758494657E-01],
	[5.51000E+03, 1.7839407205E+03, 8.0043340171E+03, 2.8065442467E+01, 2.7535695508E+01, 3.5781257714E-01],
	[5.51500E+03, 1.7858498462E+03, 8.0002791855E+03, 2.8142595044E+01, 2.7610367697E+01, 3.5804002291E-01],
	[5.52000E+03, 1.7877592821E+03, 7.9962300796E+03, 2.8219889064E+01, 2.7685171839E+01, 3.5826728441E-01],
	[5.52500E+03, 1.7896690280E+03, 7.9921866863E+03, 2.8297324655E+01, 2.7760108035E+01, 3.5849436215E-01],
	[5.53000E+03, 1.7915790837E+03, 7.9881489924E+03, 2.8374901947E+01, 2.7835176386E+01, 3.5872125665E-01],
	[5.53500E+03, 1.7934894490E+03, 7.9841169846E+03, 2.8452621069E+01, 2.7910376992E+01, 3.5894796842E-01],
	[5.54000E+03, 1.7954001236E+03, 7.9800906498E+03, 2.8530482151E+01, 2.7985709955E+01, 3.5917449799E-01],
	[5.54500E+03, 1.7973111073E+03, 7.9760699750E+03, 2.8608485323E+01, 2.8061175375E+01, 3.5940084586E-01],
	[5.55000E+03, 1.7992223999E+03, 7.9720549471E+03, 2.8686630714E+01, 2.8136773354E+01, 3.5962701255E-01],
	[5.55500E+03, 1.8011340012E+03, 7.9680455531E+03, 2.8764918453E+01, 2.8212503991E+01, 3.5985299855E-01],
	[5.56000E+03, 1.8030459108E+03, 7.9640417800E+03, 2.8843348670E+01, 2.8288367388E+01, 3.6007880439E-01],
	[5.56500E+03, 1.8049581287E+03, 7.9600436149E+03, 2.8921921494E+01, 2.8364363645E+01, 3.6030443056E-01],
	[5.57000E+03, 1.8068706545E+03, 7.9560510449E+03, 2.9000637055E+01, 2.8440492863E+01, 3.6052987758E-01],
	[5.57500E+03, 1.8087834880E+03, 7.9520640572E+03, 2.9079495483E+01, 2.8516755142E+01, 3.6075514594E-01],
	[5.58000E+03, 1.8106966291E+03, 7.9480826389E+03, 2.9158496906E+01, 2.8593150583E+01, 3.6098023614E-01],
	[5.58500E+03, 1.8126100774E+03, 7.9441067774E+03, 2.9237641455E+01, 2.8669679285E+01, 3.6120514869E-01],
	[5.59000E+03, 1.8145238328E+03, 7.9401364599E+03, 2.9316929258E+01, 2.8746341350E+01, 3.6142988407E-01],
	[5.59500E+03, 1.8164378951E+03, 7.9361716736E+03, 2.9396360445E+01, 2.8823136877E+01, 3.6165444280E-01],
	[5.60000E+03, 1.8183522639E+03, 7.9322124061E+03, 2.9475935147E+01, 2.8900065966E+01, 3.6187882536E-01],
	[5.60500E+03, 1.8202669391E+03, 7.9282586446E+03, 2.9555653491E+01, 2.8977128717E+01, 3.6210303224E-01],
	[5.61000E+03, 1.8221819205E+03, 7.9243103766E+03, 2.9635515608E+01, 2.9054325231E+01, 3.6232706394E-01],
	[5.61500E+03, 1.8240972078E+03, 7.9203675896E+03, 2.9715521626E+01, 2.9131655608E+01, 3.6255092095E-01],
	[5.62000E+03, 1.8260128009E+03, 7.9164302712E+03, 2.9795671677E+01, 2.9209119946E+01, 3.6277460376E-01],
	[5.62500E+03, 1.8279286994E+03, 7.9124984088E+03, 2.9875965888E+01, 2.9286718347E+01, 3.6299811284E-01],
	[5.63000E+03, 1.8298449032E+03, 7.9085719901E+03, 2.9956404390E+01, 2.9364450909E+01, 3.6322144870E-01],
	[5.63500E+03, 1.8317614120E+03, 7.9046510027E+03, 3.0036987311E+01, 2.9442317733E+01, 3.6344461180E-01],
	[5.64000E+03, 1.8336782257E+03, 7.9007354344E+03, 3.0117714782E+01, 2.9520318918E+01, 3.6366760263E-01],
	[5.64500E+03, 1.8355953439E+03, 7.8968252727E+03, 3.0198586932E+01, 2.9598454563E+01, 3.6389042165E-01],
	[5.65000E+03, 1.8375127665E+03, 7.8929205055E+03, 3.0279603890E+01, 2.9676724769E+01, 3.6411306936E-01],
	[5.65500E+03, 1.8394304933E+03, 7.8890211205E+03, 3.0360765785E+01, 2.9755129634E+01, 3.6433554627E-01],
	[5.66000E+03, 1.8413485240E+03, 7.8851271057E+03, 3.0442072748E+01, 2.9833669257E+01, 3.6455785289E-01],
	[5.66500E+03, 1.8432668585E+03, 7.8812384488E+03, 3.0523524907E+01, 2.9912343739E+01, 3.6477998971E-01],
	[5.67000E+03, 1.8451854964E+03, 7.8773551377E+03, 3.0605122392E+01, 2.9991153178E+01, 3.6500195724E-01],
	[5.67500E+03, 1.8471044376E+03, 7.8734771605E+03, 3.0686865332E+01, 3.0070097673E+01, 3.6522375598E-01],
	[5.68000E+03, 1.8490264387E+03, 7.8696219450E+03, 3.0768753858E+01, 3.0149178313E+01, 3.6544538642E-01],
	[5.68500E+03, 1.8509666400E+03, 7.8658850346E+03, 3.0850788097E+01, 3.0228400657E+01, 3.6566684906E-01],
	[5.69000E+03, 1.8529071688E+03, 7.8621531815E+03, 3.0932968181E+01, 3.0307758417E+01, 3.6588814440E-01],
	[5.69500E+03, 1.8548480250E+03, 7.8584263745E+03, 3.1015294237E+01, 3.0387251691E+01, 3.6610927292E-01],
	[5.70000E+03, 1.8567892081E+03, 7.8547046023E+03, 3.1097766397E+01, 3.0466880579E+01, 3.6633023512E-01],
	[5.70500E+03, 1.8587307181E+03, 7.8509878537E+03, 3.1180384788E+01, 3.0546645179E+01, 3.6655103150E-01],
	[5.71000E+03, 1.8606725547E+03, 7.8472761176E+03, 3.1263149540E+01, 3.0626545591E+01, 3.6677166253E-01],
	[5.71500E+03, 1.8626147176E+03, 7.8435693827E+03, 3.1346060784E+01, 3.0706581914E+01, 3.6699212870E-01],
	[5.72000E+03, 1.8645572067E+03, 7.8398676380E+03, 3.1429118648E+01, 3.0786754246E+01, 3.6721243051E-01],
	[5.72500E+03, 1.8665000217E+03, 7.8361708724E+03, 3.1512323261E+01, 3.0867062686E+01, 3.6743256842E-01],
	[5.73000E+03, 1.8684431623E+03, 7.8324790749E+03, 3.1595674754E+01, 3.0947507333E+01, 3.6765254294E-01],
	[5.73500E+03, 1.8703866283E+03, 7.8287922345E+03, 3.1679173255E+01, 3.1028088286E+01, 3.6787235452E-01],
	[5.74000E+03, 1.8723304196E+03, 7.8251103402E+03, 3.1762818894E+01, 3.1108805643E+01, 3.6809200367E-01],
	[5.74500E+03, 1.8742745358E+03, 7.8214333810E+03, 3.1846611801E+01, 3.1189659503E+01, 3.6831149084E-01],
	[5.75000E+03, 1.8762189768E+03, 7.8177613462E+03, 3.1930552105E+01, 3.1270649964E+01, 3.6853081652E-01],
	[5.75500E+03, 1.8781637423E+03, 7.8140942247E+03, 3.2014639934E+01, 3.1351777124E+01, 3.6874998118E-01],
	[5.76000E+03, 1.8801088322E+03, 7.8104320058E+03, 3.2098875419E+01, 3.1433041082E+01, 3.6896898530E-01],
	[5.76500E+03, 1.8820542460E+03, 7.8067746786E+03, 3.2183258690E+01, 3.1514441937E+01, 3.6918782935E-01],
	[5.77000E+03, 1.8839999837E+03, 7.8031222325E+03, 3.2267789875E+01, 3.1595979785E+01, 3.6940651379E-01],
	[5.77500E+03, 1.8859460450E+03, 7.7994746566E+03, 3.2352469103E+01, 3.1677654726E+01, 3.6962503910E-01],
	[5.78000E+03, 1.8878924298E+03, 7.7958319402E+03, 3.2437296505E+01, 3.1759466858E+01, 3.6984340574E-01],
	[5.78500E+03, 1.8898391376E+03, 7.7921940728E+03, 3.2522272210E+01, 3.1841416278E+01, 3.7006161418E-01],
	[5.79000E+03, 1.8917861684E+03, 7.7885610436E+03, 3.2607396346E+01, 3.1923503084E+01, 3.7027966489E-01],
	[5.79500E+03, 1.8937335219E+03, 7.7849328421E+03, 3.2692669044E+01, 3.2005727374E+01, 3.7049755832E-01],
	[5.80000E+03, 1.8956811979E+03, 7.7813094576E+03, 3.2778090433E+01, 3.2088089246E+01, 3.7071529493E-01],
	[5.80500E+03, 1.8976291961E+03, 7.7776908796E+03, 3.2863660642E+01, 3.2170588798E+01, 3.7093287520E-01],
	[5.81000E+03, 1.8995775164E+03, 7.7740770977E+03, 3.2949379801E+01, 3.2253226128E+01, 3.7115029957E-01],
	[5.81500E+03, 1.9015261585E+03, 7.7704681014E+03, 3.3035248039E+01, 3.2336001332E+01, 3.7136756850E-01],
	[5.82000E+03, 1.9034751222E+03, 7.7668638801E+03, 3.3121265485E+01, 3.2418914508E+01, 3.7158468246E-01],
	[5.82500E+03, 1.9054244072E+03, 7.7632644236E+03, 3.3207432270E+01, 3.2501965755E+01, 3.7180164188E-01],
	[5.83000E+03, 1.9073740134E+03, 7.7596697213E+03, 3.3293748521E+01, 3.2585155168E+01, 3.7201844724E-01],
	[5.83500E+03, 1.9093239405E+03, 7.7560797630E+03, 3.3380214369E+01, 3.2668482847E+01, 3.7223509897E-01],
	[5.84000E+03, 1.9112741883E+03, 7.7524945384E+03, 3.3466829942E+01, 3.2751948886E+01, 3.7245159754E-01],
	[5.84500E+03, 1.9132247566E+03, 7.7489140371E+03, 3.3553595372E+01, 3.2835553385E+01, 3.7266794338E-01],
	[5.85000E+03, 1.9151756451E+03, 7.7453382490E+03, 3.3640510786E+01, 3.2919296440E+01, 3.7288413695E-01],
	[5.85500E+03, 1.9171268536E+03, 7.7417671637E+03, 3.3727576314E+01, 3.3003178148E+01, 3.7310017869E-01],
	[5.86000E+03, 1.9190783820E+03, 7.7382007711E+03, 3.3814792085E+01, 3.3087198606E+01, 3.7331606905E-01],
	[5.86500E+03, 1.9210302299E+03, 7.7346390610E+03, 3.3902158229E+01, 3.3171357910E+01, 3.7353180847E-01],
	[5.87000E+03, 1.9229823972E+03, 7.7310820234E+03, 3.3989674876E+01, 3.3255656159E+01, 3.7374739740E-01],
	[5.87500E+03, 1.9249348837E+03, 7.7275296480E+03, 3.4077342154E+01, 3.3340093448E+01, 3.7396283627E-01],
	[5.88000E+03, 1.9268876891E+03, 7.7239819248E+03, 3.4165160193E+01, 3.3424669874E+01, 3.7417812553E-01],
	[5.88500E+03, 1.9288408132E+03, 7.7204388438E+03, 3.4253129123E+01, 3.3509385534E+01, 3.7439326561E-01],
	[5.89000E+03, 1.9307942558E+03, 7.7169003950E+03, 3.4341249072E+01, 3.3594240524E+01, 3.7460825695E-01],
	[5.89500E+03, 1.9327480167E+03, 7.7133665684E+03, 3.4429520170E+01, 3.3679234941E+01, 3.7482310000E-01],
	[5.90000E+03, 1.9347020956E+03, 7.7098373540E+03, 3.4517942547E+01, 3.3764368881E+01, 3.7503779517E-01],
	[5.90500E+03, 1.9366564923E+03, 7.7063127420E+03, 3.4606516331E+01, 3.3849642440E+01, 3.7525234291E-01],
	[5.91000E+03, 1.9386265828E+03, 7.7028914278E+03, 3.4695241653E+01, 3.3935062343E+01, 3.7546674365E-01],
	[5.91500E+03, 1.9406002252E+03, 7.6994951414E+03, 3.4784118641E+01, 3.4020623502E+01, 3.7568099782E-01],
	[5.92000E+03, 1.9425742067E+03, 7.6961032203E+03, 3.4873147425E+01, 3.4106324635E+01, 3.7589510585E-01],
	[5.92500E+03, 1.9445485270E+03, 7.6927156551E+03, 3.4962328134E+01, 3.4192165836E+01, 3.7610906816E-01],
	[5.93000E+03, 1.9465231860E+03, 7.6893324366E+03, 3.5051660897E+01, 3.4278147203E+01, 3.7632288519E-01],
	[5.93500E+03, 1.9484981835E+03, 7.6859535556E+03, 3.5141145845E+01, 3.4364268833E+01, 3.7653655737E-01],
	[5.94000E+03, 1.9504735192E+03, 7.6825790028E+03, 3.5230783106E+01, 3.4450530820E+01, 3.7675008511E-01],
	[5.94500E+03, 1.9524491928E+03, 7.6792087691E+03, 3.5320572809E+01, 3.4536933262E+01, 3.7696346884E-01],
	[5.95000E+03, 1.9544252042E+03, 7.6758428454E+03, 3.5410515084E+01, 3.4623476254E+01, 3.7717670898E-01],
	[5.95500E+03, 1.9564015531E+03, 7.6724812224E+03, 3.5500610061E+01, 3.4710159892E+01, 3.7738980596E-01],
	[5.96000E+03, 1.9583782393E+03, 7.6691238912E+03, 3.5590857868E+01, 3.4796984272E+01, 3.7760276020E-01],
	[5.96500E+03, 1.9603552625E+03, 7.6657708426E+03, 3.5681258636E+01, 3.4883949490E+01, 3.7781557210E-01],
	[5.97000E+03, 1.9623326226E+03, 7.6624220675E+03, 3.5771812492E+01, 3.4971055641E+01, 3.7802824210E-01],
	[5.97500E+03, 1.9643103194E+03, 7.6590775571E+03, 3.5862519567E+01, 3.5058302822E+01, 3.7824077061E-01],
	[5.98000E+03, 1.9662883525E+03, 7.6557373022E+03, 3.5953379990E+01, 3.5145691128E+01, 3.7845315804E-01],
	[5.98500E+03, 1.9682667218E+03, 7.6524012939E+03, 3.6044393891E+01, 3.5233220655E+01, 3.7866540481E-01],
	[5.99000E+03, 1.9702454270E+03, 7.6490695233E+03, 3.6135561398E+01, 3.5320891497E+01, 3.7887751133E-01],
	[5.99500E+03, 1.9722244680E+03, 7.6457419814E+03, 3.6226882641E+01, 3.5408703751E+01, 3.7908947802E-01],
	[6.00000E+03, 1.9742038445E+03, 7.6424186594E+03, 3.6318357749E+01, 3.5496657512E+01, 3.7930130528E-01],
	[6.00500E+03, 1.9761835562E+03, 7.6390995484E+03, 3.6410388889E+01, 3.5585136893E+01, 3.7951299352E-01],
	[6.01000E+03, 1.9781636030E+03, 7.6357846395E+03, 3.6502575891E+01, 3.5673759569E+01, 3.7972454316E-01],
	[6.01500E+03, 1.9801439847E+03, 7.6324739241E+03, 3.6594918890E+01, 3.5762525637E+01, 3.7993595460E-01],
	[6.02000E+03, 1.9821247009E+03, 7.6291673932E+03, 3.6687418016E+01, 3.5851435196E+01, 3.8014722825E-01],
	[6.02500E+03, 1.9841057516E+03, 7.6258650381E+03, 3.6780073403E+01, 3.5940488343E+01, 3.8035836451E-01],
	[6.03000E+03, 1.9860871364E+03, 7.6225668501E+03, 3.6872885184E+01, 3.6029685175E+01, 3.8056936379E-01],
	[6.03500E+03, 1.9880688552E+03, 7.6192728204E+03, 3.6965853491E+01, 3.6119025790E+01, 3.8078022648E-01],
	[6.04000E+03, 1.9900509077E+03, 7.6159829405E+03, 3.7058978457E+01, 3.6208510286E+01, 3.8099095301E-01],
	[6.04500E+03, 1.9920332937E+03, 7.6126972016E+03, 3.7152260215E+01, 3.6298138760E+01, 3.8120154375E-01],
	[6.05000E+03, 1.9940160129E+03, 7.6094155951E+03, 3.7245698897E+01, 3.6387911310E+01, 3.8141199912E-01],
	[6.05500E+03, 1.9959990653E+03, 7.6061381124E+03, 3.7339294637E+01, 3.6477828032E+01, 3.8162231951E-01],
	[6.06000E+03, 1.9979824505E+03, 7.6028647450E+03, 3.7433047566E+01, 3.6567889024E+01, 3.8183250533E-01],
	[6.06500E+03, 1.9999661684E+03, 7.5995954842E+03, 3.7526957819E+01, 3.6658094383E+01, 3.8204255696E-01],
	[6.07000E+03, 2.0019502186E+03, 7.5963303215E+03, 3.7621025526E+01, 3.6748444206E+01, 3.8225247480E-01],
	[6.07500E+03, 2.0039346011E+03, 7.5930692485E+03, 3.7715250821E+01, 3.6838938590E+01, 3.8246225925E-01],
	[6.08000E+03, 2.0059193155E+03, 7.5898122566E+03, 3.7809633837E+01, 3.6929577633E+01, 3.8267191071E-01],
	[6.08500E+03, 2.0079043617E+03, 7.5865593374E+03, 3.7904174707E+01, 3.7020361430E+01, 3.8288142956E-01],
	[6.09000E+03, 2.0098897394E+03, 7.5833104824E+03, 3.7998873563E+01, 3.7111290079E+01, 3.8309081620E-01],
	[6.09500E+03, 2.0118754484E+03, 7.5800656833E+03, 3.8093730537E+01, 3.7202363676E+01, 3.8330007101E-01],
	[6.10000E+03, 2.0138614886E+03, 7.5768249317E+03, 3.8188745764E+01, 3.7293582318E+01, 3.8350919439E-01],
	[6.10500E+03, 2.0158478597E+03, 7.5735882192E+03, 3.8283919374E+01, 3.7384946102E+01, 3.8371818673E-01],
	[6.11000E+03, 2.0178345614E+03, 7.5703555374E+03, 3.8379251502E+01, 3.7476455123E+01, 3.8392704841E-01],
	[6.11500E+03, 2.0198215936E+03, 7.5671268781E+03, 3.8474742279E+01, 3.7568109479E+01, 3.8413577981E-01],
	[6.12000E+03, 2.0218089560E+03, 7.5639022329E+03, 3.8570391839E+01, 3.7659909266E+01, 3.8434438134E-01],
	[6.12500E+03, 2.0237966485E+03, 7.5606815937E+03, 3.8666200313E+01, 3.7751854580E+01, 3.8455285336E-01],
	[6.13000E+03, 2.0257846708E+03, 7.5574649521E+03, 3.8762167836E+01, 3.7843945517E+01, 3.8476119627E-01],
	[6.13500E+03, 2.0277730226E+03, 7.5542522999E+03, 3.8858294539E+01, 3.7936182174E+01, 3.8496941045E-01],
	[6.14000E+03, 2.0297617039E+03, 7.5510436290E+03, 3.8954580556E+01, 3.8028564646E+01, 3.8517749627E-01],
	[6.14500E+03, 2.0317626950E+03, 7.5479168875E+03, 3.9051026018E+01, 3.8121099236E+01, 3.8538545412E-01],
	[6.15000E+03, 2.0337688430E+03, 7.5448252641E+03, 3.9147631059E+01, 3.8213782383E+01, 3.8559328439E-01],
	[6.15500E+03, 2.0357753391E+03, 7.5417374180E+03, 3.9244395812E+01, 3.8306611703E+01, 3.8580098744E-01],
	[6.16000E+03, 2.0377821831E+03, 7.5386533415E+03, 3.9341320409E+01, 3.8399587290E+01, 3.8600856365E-01],
	[6.16500E+03, 2.0397893747E+03, 7.5355730270E+03, 3.9438404982E+01, 3.8492709241E+01, 3.8621601341E-01],
	[6.17000E+03, 2.0417969138E+03, 7.5324964667E+03, 3.9535649666E+01, 3.8585977652E+01, 3.8642333709E-01],
	[6.17500E+03, 2.0438048000E+03, 7.5294236532E+03, 3.9633054591E+01, 3.8679392618E+01, 3.8663053506E-01],
	[6.18000E+03, 2.0458130332E+03, 7.5263545787E+03, 3.9730619891E+01, 3.8772954236E+01, 3.8683760782E-01],
	[6.18500E+03, 2.0478216132E+03, 7.5232892358E+03, 3.9828345699E+01, 3.8866662601E+01, 3.8704455584E-01],
	[6.19000E+03, 2.0498305398E+03, 7.5202276169E+03, 3.9926232148E+01, 3.8960517809E+01, 3.8725137947E-01],
	[6.19500E+03, 2.0518398126E+03, 7.5171697144E+03, 4.0024279369E+01, 3.9054519955E+01, 3.8745807908E-01],
	[6.20000E+03, 2.0538494316E+03, 7.5141155209E+03, 4.0122487497E+01, 3.9148669135E+01, 3.8766465505E-01],
	[6.20500E+03, 2.0558593964E+03, 7.5110650289E+03, 4.0220856663E+01, 3.9242965444E+01, 3.8787110772E-01],
	[6.21000E+03, 2.0578697069E+03, 7.5080182309E+03, 4.0319387000E+01, 3.9337408977E+01, 3.8807743748E-01],
	[6.21500E+03, 2.0598803628E+03, 7.5049751194E+03, 4.0418078641E+01, 3.9431999831E+01, 3.8828364467E-01],
	[6.22000E+03, 2.0618913640E+03, 7.5019356871E+03, 4.0516931719E+01, 3.9526738100E+01, 3.8848972966E-01],
	[6.22500E+03, 2.0639027101E+03, 7.4988999266E+03, 4.0615946366E+01, 3.9621623879E+01, 3.8869569281E-01],
	[6.23000E+03, 2.0659144011E+03, 7.4958678304E+03, 4.0715122715E+01, 3.9716657263E+01, 3.8890153447E-01],
	[6.23500E+03, 2.0679264366E+03, 7.4928393912E+03, 4.0814460899E+01, 3.9811838348E+01, 3.8910725502E-01],
	[6.24000E+03, 2.0699388165E+03, 7.4898146017E+03, 4.0913961051E+01, 3.9907167228E+01, 3.8931285480E-01],
	[6.24500E+03, 2.0719515405E+03, 7.4867934545E+03, 4.1013623303E+01, 4.0002643998E+01, 3.8951833417E-01],
	[6.25000E+03, 2.0739646084E+03, 7.4837759424E+03, 4.1113447787E+01, 4.0098268753E+01, 3.8972369349E-01],
	[6.25500E+03, 2.0759780200E+03, 7.4807620581E+03, 4.1213434638E+01, 4.0194041587E+01, 3.8992893311E-01],
	[6.26000E+03, 2.0779917751E+03, 7.4777517943E+03, 4.1313583987E+01, 4.0289962595E+01, 3.9013405339E-01],
	[6.26500E+03, 2.0800058735E+03, 7.4747451438E+03, 4.1413895967E+01, 4.0386031872E+01, 3.9033905467E-01],
	[6.27000E+03, 2.0820203149E+03, 7.4717420993E+03, 4.1514370710E+01, 4.0482249513E+01, 3.9054393732E-01],
	[6.27500E+03, 2.0840350992E+03, 7.4687426537E+03, 4.1615008351E+01, 4.0578615611E+01, 3.9074870168E-01],
	[6.28000E+03, 2.0860502260E+03, 7.4657467999E+03, 4.1715809020E+01, 4.0675130260E+01, 3.9095334810E-01],
	[6.28500E+03, 2.0880656953E+03, 7.4627545305E+03, 4.1816772851E+01, 4.0771793556E+01, 3.9115787693E-01],
	[6.29000E+03, 2.0900815068E+03, 7.4597658386E+03, 4.1917899977E+01, 4.0868605592E+01, 3.9136228852E-01],
	[6.29500E+03, 2.0920976603E+03, 7.4567807170E+03, 4.2019190531E+01, 4.0965566463E+01, 3.9156658322E-01],
	[6.30000E+03, 2.0941141555E+03, 7.4537991586E+03, 4.2120644644E+01, 4.1062676262E+01, 3.9177076138E-01],
	[6.30500E+03, 2.0961309923E+03, 7.4508211563E+03, 4.2222262450E+01, 4.1159935083E+01, 3.9197482334E-01],
	[6.31000E+03, 2.0981481705E+03, 7.4478467030E+03, 4.2324044082E+01, 4.1257343021E+01, 3.9217876944E-01],
	[6.31500E+03, 2.1001656897E+03, 7.4448757918E+03, 4.2425989672E+01, 4.1354900169E+01, 3.9238260004E-01],
	[6.32000E+03, 2.1021835499E+03, 7.4419084156E+03, 4.2528099352E+01, 4.1452606620E+01, 3.9258631547E-01],
	[6.32500E+03, 2.1042017508E+03, 7.4389445674E+03, 4.2630373257E+01, 4.1550462469E+01, 3.9278991607E-01],
	[6.33000E+03, 2.1062202922E+03, 7.4359842403E+03, 4.2732811518E+01, 4.1648467809E+01, 3.9299340220E-01],
	[6.33500E+03, 2.1082391738E+03, 7.4330274272E+03, 4.2835414267E+01, 4.1746622733E+01, 3.9319677418E-01],
	[6.34000E+03, 2.1102583955E+03, 7.4300741212E+03, 4.2938181639E+01, 4.1844927335E+01, 3.9340003236E-01],
	[6.34500E+03, 2.1122779571E+03, 7.4271243155E+03, 4.3041113765E+01, 4.1943381709E+01, 3.9360317709E-01],
	[6.35000E+03, 2.1142978583E+03, 7.4241780031E+03, 4.3144210778E+01, 4.2041985947E+01, 3.9380620869E-01],
	[6.35500E+03, 2.1163180990E+03, 7.4212351771E+03, 4.3247472811E+01, 4.2140740142E+01, 3.9400912750E-01],
	[6.36000E+03, 2.1183386789E+03, 7.4182958307E+03, 4.3350899997E+01, 4.2239644389E+01, 3.9421193387E-01],
	[6.36500E+03, 2.1203595978E+03, 7.4153599570E+03, 4.3454492468E+01, 4.2338698779E+01, 3.9441462812E-01],
	[6.37000E+03, 2.1223808555E+03, 7.4124275492E+03, 4.3558250357E+01, 4.2437903406E+01, 3.9461721060E-01],
	[6.37500E+03, 2.1244024518E+03, 7.4094986005E+03, 4.3662173796E+01, 4.2537258363E+01, 3.9481968164E-01],
	[6.38000E+03, 2.1264243865E+03, 7.4065731040E+03, 4.3766262920E+01, 4.2636763743E+01, 3.9502204157E-01],
	[6.38500E+03, 2.1284466594E+03, 7.4036510532E+03, 4.3870517859E+01, 4.2736419638E+01, 3.9522429072E-01],
	[6.39000E+03, 2.1304802202E+03, 7.4008045772E+03, 4.3974938747E+01, 4.2836232984E+01, 3.9542642943E-01],
	[6.39500E+03, 2.1325183787E+03, 7.3979893660E+03, 4.4079525717E+01, 4.2936199746E+01, 3.9562845803E-01],
	[6.40000E+03, 2.1345568918E+03, 7.3951774246E+03, 4.4184278901E+01, 4.3036317373E+01, 3.9583037684E-01],
	[6.40500E+03, 2.1365957593E+03, 7.3923687468E+03, 4.4289198432E+01, 4.3136585959E+01, 3.9603218621E-01],
	[6.41000E+03, 2.1386349810E+03, 7.3895633262E+03, 4.4394284443E+01, 4.3237005595E+01, 3.9623388645E-01],
	[6.41500E+03, 2.1406745566E+03, 7.3867611564E+03, 4.4499537066E+01, 4.3337576375E+01, 3.9643547790E-01],
	[6.42000E+03, 2.1427144860E+03, 7.3839622313E+03, 4.4604956434E+01, 4.3438298391E+01, 3.9663696088E-01],
	[6.42500E+03, 2.1447547690E+03, 7.3811665444E+03, 4.4710542680E+01, 4.3539171736E+01, 3.9683833572E-01],
	[6.43000E+03, 2.1467954053E+03, 7.3783740896E+03, 4.4816295937E+01, 4.3640196502E+01, 3.9703960275E-01],
	[6.43500E+03, 2.1488363947E+03, 7.3755848606E+03, 4.4922216337E+01, 4.3741372780E+01, 3.9724076229E-01],
	[6.44000E+03, 2.1508777370E+03, 7.3727988511E+03, 4.5028304013E+01, 4.3842700665E+01, 3.9744181467E-01],
	[6.44500E+03, 2.1529194320E+03, 7.3700160550E+03, 4.5134559098E+01, 4.3944180247E+01, 3.9764276020E-01],
	[6.45000E+03, 2.1549614795E+03, 7.3672364661E+03, 4.5240981724E+01, 4.4045811618E+01, 3.9784359922E-01],
	[6.45500E+03, 2.1570038792E+03, 7.3644600782E+03, 4.5347572024E+01, 4.4147594871E+01, 3.9804433205E-01],
	[6.46000E+03, 2.1590466310E+03, 7.3616868850E+03, 4.5454330130E+01, 4.4249530098E+01, 3.9824495900E-01],
	[6.46500E+03, 2.1610897346E+03, 7.3589168806E+03, 4.5561256177E+01, 4.4351617390E+01, 3.9844548040E-01],
	[6.47000E+03, 2.1631331899E+03, 7.3561500587E+03, 4.5668350295E+01, 4.4453856840E+01, 3.9864589657E-01],
	[6.47500E+03, 2.1651769966E+03, 7.3533864132E+03, 4.5775612619E+01, 4.4556248538E+01, 3.9884620783E-01],
	[6.48000E+03, 2.1672211545E+03, 7.3506259381E+03, 4.5883043280E+01, 4.4658792577E+01, 3.9904641449E-01],
	[6.48500E+03, 2.1692656634E+03, 7.3478686273E+03, 4.5990829229E+01, 4.4761666013E+01, 3.9924651688E-01],
	[6.49000E+03, 2.1713105230E+03, 7.3451144746E+03, 4.6098817124E+01, 4.4864723522E+01, 3.9944651531E-01],
	[6.49500E+03, 2.1733557333E+03, 7.3423634741E+03, 4.6206974719E+01, 4.4967934521E+01, 3.9964641010E-01],
	[6.50000E+03, 2.1754012939E+03, 7.3396156198E+03, 4.6315302149E+01, 4.5071299104E+01, 3.9984620157E-01],
	[6.50500E+03, 2.1774472046E+03, 7.3368709055E+03, 4.6423799549E+01, 4.5174817362E+01, 4.0004589003E-01],
	[6.51000E+03, 2.1794934654E+03, 7.3341293254E+03, 4.6532467053E+01, 4.5278489390E+01, 4.0024547579E-01],
	[6.51500E+03, 2.1815400758E+03, 7.3313908734E+03, 4.6641304797E+01, 4.5382315279E+01, 4.0044495917E-01],
	[6.52000E+03, 2.1835870358E+03, 7.3286555435E+03, 4.6750312914E+01, 4.5486295122E+01, 4.0064434048E-01],
	[6.52500E+03, 2.1856343451E+03, 7.3259233299E+03, 4.6859491540E+01, 4.5590429012E+01, 4.0084362004E-01],
	[6.53000E+03, 2.1876820035E+03, 7.3231942266E+03, 4.6968840809E+01, 4.5694717041E+01, 4.0104279815E-01],
	[6.53500E+03, 2.1897300108E+03, 7.3204682276E+03, 4.7078360857E+01, 4.5799159301E+01, 4.0124187513E-01],
	[6.54000E+03, 2.1917783668E+03, 7.3177453270E+03, 4.7188051817E+01, 4.5903755886E+01, 4.0144085129E-01],
	[6.54500E+03, 2.1938270713E+03, 7.3150255191E+03, 4.7297913825E+01, 4.6008506886E+01, 4.0163972695E-01],
	[6.55000E+03, 2.1958761241E+03, 7.3123087979E+03, 4.7407947015E+01, 4.6113412394E+01, 4.0183850239E-01],
	[6.55500E+03, 2.1979255250E+03, 7.3095951575E+03, 4.7518151521E+01, 4.6218472502E+01, 4.0203717795E-01],
	[6.56000E+03, 2.1999752737E+03, 7.3068845921E+03, 4.7628527480E+01, 4.6323687302E+01, 4.0223575392E-01],
	[6.56500E+03, 2.2020253701E+03, 7.3041770959E+03, 4.7739075025E+01, 4.6429056887E+01, 4.0243423061E-01],
	[6.57000E+03, 2.2040758140E+03, 7.3014726630E+03, 4.7849794291E+01, 4.6534581347E+01, 4.0263260834E-01],
	[6.57500E+03, 2.2061266051E+03, 7.2987712878E+03, 4.7960685414E+01, 4.6640260774E+01, 4.0283088739E-01],
	[6.58000E+03, 2.2081777432E+03, 7.2960729644E+03, 4.8071748526E+01, 4.6746095261E+01, 4.0302906809E-01],
	[6.58500E+03, 2.2102292282E+03, 7.2933776870E+03, 4.8182983765E+01, 4.6852084898E+01, 4.0322715073E-01],
	[6.59000E+03, 2.2122810599E+03, 7.2906854498E+03, 4.8294391263E+01, 4.6958229778E+01, 4.0342513563E-01],
	[6.59500E+03, 2.2143332379E+03, 7.2879962473E+03, 4.8405971156E+01, 4.7064529991E+01, 4.0362302308E-01],
	[6.60000E+03, 2.2163857622E+03, 7.2853100736E+03, 4.8517723579E+01, 4.7170985630E+01, 4.0382081338E-01],
	[6.60500E+03, 2.2184386325E+03, 7.2826269230E+03, 4.8629648667E+01, 4.7277596784E+01, 4.0401850684E-01],
	[6.61000E+03, 2.2204918487E+03, 7.2799467899E+03, 4.8741746553E+01, 4.7384363547E+01, 4.0421610376E-01],
	[6.61500E+03, 2.2225454104E+03, 7.2772696686E+03, 4.8854017373E+01, 4.7491286007E+01, 4.0441360445E-01],
	[6.62000E+03, 2.2245993176E+03, 7.2745955534E+03, 4.8966461262E+01, 4.7598364257E+01, 4.0461100920E-01],
	[6.62500E+03, 2.2266535700E+03, 7.2719244387E+03, 4.9079078355E+01, 4.7705598388E+01, 4.0480831831E-01],
	[6.63000E+03, 2.2287081674E+03, 7.2692563189E+03, 4.9191868785E+01, 4.7812988490E+01, 4.0500553208E-01],
	[6.63500E+03, 2.2307631096E+03, 7.2665911882E+03, 4.9304832689E+01, 4.7920534654E+01, 4.0520265081E-01],
	[6.64000E+03, 2.2328183964E+03, 7.2639290413E+03, 4.9417970200E+01, 4.8028236972E+01, 4.0539967480E-01],
	[6.64500E+03, 2.2348845340E+03, 7.2613408048E+03, 4.9531281453E+01, 4.8136103523E+01, 4.0559660435E-01],
	[6.65000E+03, 2.2369541041E+03, 7.2587761818E+03, 4.9644766584E+01, 4.8244128816E+01, 4.0579343975E-01],
	[6.65500E+03, 2.2390240331E+03, 7.2562143911E+03, 4.9758425726E+01, 4.8352310609E+01, 4.0599018130E-01],
	[6.66000E+03, 2.2410943206E+03, 7.2536554275E+03, 4.9872259015E+01, 4.8460648994E+01, 4.0618682930E-01],
	[6.66500E+03, 2.2431649666E+03, 7.2510992857E+03, 4.9986266586E+01, 4.8569144062E+01, 4.0638338403E-01],
	[6.67000E+03, 2.2452359709E+03, 7.2485459606E+03, 5.0100448573E+01, 4.8677795903E+01, 4.0657984580E-01],
	[6.67500E+03, 2.2473073331E+03, 7.2459954468E+03, 5.0214805110E+01, 4.8786604607E+01, 4.0677621494E-01],
	[6.68000E+03, 2.2493790531E+03, 7.2434477393E+03, 5.0329336334E+01, 4.8895570265E+01, 4.0697249174E-01],
	[6.68500E+03, 2.2514511307E+03, 7.2409028328E+03, 5.0444042378E+01, 4.9004692967E+01, 4.0716867646E-01],
	[6.69000E+03, 2.2535235658E+03, 7.2383607222E+03, 5.0558923377E+01, 4.9113972804E+01, 4.0736476937E-01],
	[6.69500E+03, 2.2555963580E+03, 7.2358214022E+03, 5.0673979467E+01, 4.9223409865E+01, 4.0756077073E-01],
	[6.70000E+03, 2.2576695072E+03, 7.2332848679E+03, 5.0789210781E+01, 4.9333004241E+01, 4.0775668082E-01],
	[6.70500E+03, 2.2597430132E+03, 7.2307511139E+03, 5.0904617454E+01, 4.9442756022E+01, 4.0795249989E-01],
	[6.71000E+03, 2.2618168757E+03, 7.2282201353E+03, 5.1020199622E+01, 4.9552665297E+01, 4.0814822821E-01],
	[6.71500E+03, 2.2638910946E+03, 7.2256919268E+03, 5.1135957420E+01, 4.9662732157E+01, 4.0834386604E-01],
	[6.72000E+03, 2.2659656697E+03, 7.2231664835E+03, 5.1251890981E+01, 4.9772956692E+01, 4.0853941364E-01],
	[6.72500E+03, 2.2680406007E+03, 7.2206438002E+03, 5.1368000441E+01, 4.9883338990E+01, 4.0873487128E-01],
	[6.73000E+03, 2.2701158875E+03, 7.2181238718E+03, 5.1484285934E+01, 4.9993879142E+01, 4.0893023922E-01],
	[6.73500E+03, 2.2721915299E+03, 7.2156066934E+03, 5.1600747595E+01, 5.0104577237E+01, 4.0912551771E-01],
	[6.74000E+03, 2.2742675276E+03, 7.2130922599E+03, 5.1717385560E+01, 5.0215433364E+01, 4.0932070703E-01],
	[6.74500E+03, 2.2763438805E+03, 7.2105805662E+03, 5.1834199962E+01, 5.0326447613E+01, 4.0951580742E-01],
	[6.75000E+03, 2.2784205883E+03, 7.2080716073E+03, 5.1951190937E+01, 5.0437620074E+01, 4.0971081915E-01],
	[6.75500E+03, 2.2804976508E+03, 7.2055653783E+03, 5.2068358619E+01, 5.0548950835E+01, 4.0990574249E-01],
	[6.76000E+03, 2.2825750679E+03, 7.2030618741E+03, 5.2185703144E+01, 5.0660439985E+01, 4.1010057767E-01],
	[6.76500E+03, 2.2846528393E+03, 7.2005610898E+03, 5.2303224645E+01, 5.0772087614E+01, 4.1029532498E-01],
	[6.77000E+03, 2.2867309649E+03, 7.1980630204E+03, 5.2420923258E+01, 5.0883893811E+01, 4.1048998465E-01],
	[6.77500E+03, 2.2888094444E+03, 7.1955676610E+03, 5.2538799118E+01, 5.0995858663E+01, 4.1068455696E-01],
	[6.78000E+03, 2.2908882776E+03, 7.1930750066E+03, 5.2656852359E+01, 5.1107982261E+01, 4.1087904215E-01],
	[6.78500E+03, 2.2929674643E+03, 7.1905850523E+03, 5.2775083116E+01, 5.1220264693E+01, 4.1107344048E-01],
	[6.79000E+03, 2.2950470044E+03, 7.1880977932E+03, 5.2893491524E+01, 5.1332706048E+01, 4.1126775221E-01],
	[6.79500E+03, 2.2971268977E+03, 7.1856132243E+03, 5.3012077718E+01, 5.1445306413E+01, 4.1146197760E-01],
	[6.80000E+03, 2.2992071438E+03, 7.1831313409E+03, 5.3130841832E+01, 5.1558065878E+01, 4.1165611689E-01],
	[6.80500E+03, 2.3012877427E+03, 7.1806521380E+03, 5.3249784002E+01, 5.1670984531E+01, 4.1185017034E-01],
	[6.81000E+03, 2.3033686942E+03, 7.1781756108E+03, 5.3368904361E+01, 5.1784062460E+01, 4.1204413821E-01],
	[6.81500E+03, 2.3054499980E+03, 7.1757017544E+03, 5.3488203046E+01, 5.1897299754E+01, 4.1223802075E-01],
	[6.82000E+03, 2.3075316539E+03, 7.1732305640E+03, 5.3607680190E+01, 5.2010696500E+01, 4.1243181822E-01],
	[6.82500E+03, 2.3096136617E+03, 7.1707620348E+03, 5.3727335928E+01, 5.2124252787E+01, 4.1262553085E-01],
	[6.83000E+03, 2.3116960213E+03, 7.1682961619E+03, 5.3847170396E+01, 5.2237968703E+01, 4.1281915892E-01],
	[6.83500E+03, 2.3137787324E+03, 7.1658329406E+03, 5.3967183728E+01, 5.2351844335E+01, 4.1301270266E-01],
	[6.84000E+03, 2.3158617949E+03, 7.1633723660E+03, 5.4087376059E+01, 5.2465879771E+01, 4.1320616233E-01],
	[6.84500E+03, 2.3179452085E+03, 7.1609144334E+03, 5.4207747524E+01, 5.2580075099E+01, 4.1339953818E-01],
	[6.85000E+03, 2.3200289731E+03, 7.1584591380E+03, 5.4328298257E+01, 5.2694430408E+01, 4.1359283046E-01],
	[6.85500E+03, 2.3221130884E+03, 7.1560064751E+03, 5.4449028394E+01, 5.2808945783E+01, 4.1378603942E-01],
	[6.86000E+03, 2.3241975543E+03, 7.1535564399E+03, 5.4569938068E+01, 5.2923621313E+01, 4.1397916530E-01],
	[6.86500E+03, 2.3262823705E+03, 7.1511090277E+03, 5.4691027416E+01, 5.3038457085E+01, 4.1417220837E-01],
	[6.87000E+03, 2.3283675369E+03, 7.1486642338E+03, 5.4812296571E+01, 5.3153453187E+01, 4.1436516886E-01],
	[6.87500E+03, 2.3304530533E+03, 7.1462220535E+03, 5.4933745669E+01, 5.3268609706E+01, 4.1455804702E-01],
	[6.88000E+03, 2.3325389194E+03, 7.1437824821E+03, 5.5055374845E+01, 5.3383926728E+01, 4.1475084311E-01],
	[6.88500E+03, 2.3346251351E+03, 7.1413455149E+03, 5.5177184232E+01, 5.3499404341E+01, 4.1494355736E-01],
	[6.89000E+03, 2.3367117002E+03, 7.1389111473E+03, 5.5299173967E+01, 5.3615042632E+01, 4.1513619003E-01],
	[6.89500E+03, 2.3387986144E+03, 7.1364793745E+03, 5.5421344183E+01, 5.3730841688E+01, 4.1532874136E-01],
	[6.90000E+03, 2.3408858777E+03, 7.1340501920E+03, 5.5543695016E+01, 5.3846801595E+01, 4.1552121159E-01],
	[6.90500E+03, 2.3429734897E+03, 7.1316235951E+03, 5.5666226601E+01, 5.3962922441E+01, 4.1571360098E-01],
	[6.91000E+03, 2.3450709613E+03, 7.1292662765E+03, 5.5788939072E+01, 5.4079213207E+01, 4.1590590977E-01],
	[6.91500E+03, 2.3471712539E+03, 7.1269286894E+03, 5.5911832564E+01, 5.4195667459E+01, 4.1609813819E-01],
	[6.92000E+03, 2.3492719075E+03, 7.1245935577E+03, 5.6034907212E+01, 5.4312282990E+01, 4.1629028650E-01],
	[6.92500E+03, 2.3513729218E+03, 7.1222608768E+03, 5.6158163151E+01, 5.4429059886E+01, 4.1648235494E-01],
	[6.93000E+03, 2.3534742966E+03, 7.1199306425E+03, 5.6281600515E+01, 5.4545998234E+01, 4.1667434376E-01],
	[6.93500E+03, 2.3555760317E+03, 7.1176028504E+03, 5.6405219440E+01, 5.4663098120E+01, 4.1686625319E-01],
	[6.94000E+03, 2.3576781270E+03, 7.1152774963E+03, 5.6529020060E+01, 5.4780359632E+01, 4.1705808347E-01],
	[6.94500E+03, 2.3597805822E+03, 7.1129545757E+03, 5.6653002510E+01, 5.4897782855E+01, 4.1724983486E-01],
	[6.95000E+03, 2.3618833971E+03, 7.1106340845E+03, 5.6777166926E+01, 5.5015367876E+01, 4.1744150759E-01],
	[6.95500E+03, 2.3639865716E+03, 7.1083160183E+03, 5.6901513440E+01, 5.5133114780E+01, 4.1763310190E-01],
	[6.96000E+03, 2.3660901054E+03, 7.1060003728E+03, 5.7026042190E+01, 5.5251023655E+01, 4.1782461803E-01],
	[6.96500E+03, 2.3681939983E+03, 7.1036871438E+03, 5.7150753309E+01, 5.5369094587E+01, 4.1801605623E-01],
	[6.97000E+03, 2.3702982502E+03, 7.1013763271E+03, 5.7275646932E+01, 5.5487327660E+01, 4.1820741673E-01],
	[6.97500E+03, 2.3724028609E+03, 7.0990679183E+03, 5.7400723195E+01, 5.5605722962E+01, 4.1839869977E-01],
	[6.98000E+03, 2.3745078301E+03, 7.0967619133E+03, 5.7525982231E+01, 5.5724280577E+01, 4.1858990560E-01],
	[6.98500E+03, 2.3766131576E+03, 7.0944583079E+03, 5.7651424176E+01, 5.5843000593E+01, 4.1878103445E-01],
	[6.99000E+03, 2.3787188433E+03, 7.0921570977E+03, 5.7777049165E+01, 5.5961883093E+01, 4.1897208656E-01],
	[6.99500E+03, 2.3808248870E+03, 7.0898582787E+03, 5.7902857332E+01, 5.6080928165E+01, 4.1916306217E-01],
	[7.00000E+03, 2.3829312885E+03, 7.0875618466E+03, 5.8028848812E+01, 5.6200135893E+01, 4.1935396151E-01],
	[7.00500E+03, 2.3850380475E+03, 7.0852677973E+03, 5.8156247283E+01, 5.6320653887E+01, 4.1954478483E-01],
	[7.01000E+03, 2.3871451640E+03, 7.0829761265E+03, 5.8283833757E+01, 5.6441338621E+01, 4.1973553236E-01],
	[7.01500E+03, 2.3892526376E+03, 7.0806868302E+03, 5.8411608376E+01, 5.6562190186E+01, 4.1992620433E-01],
	[7.02000E+03, 2.3913604682E+03, 7.0783999041E+03, 5.8539571283E+01, 5.6683208671E+01, 4.2011680099E-01],
	[7.02500E+03, 2.3934686556E+03, 7.0761153442E+03, 5.8667722619E+01, 5.6804394168E+01, 4.2030732257E-01],
	[7.03000E+03, 2.3955771996E+03, 7.0738331463E+03, 5.8796062526E+01, 5.6925746765E+01, 4.2049776930E-01],
	[7.03500E+03, 2.3976861000E+03, 7.0715533062E+03, 5.8924591145E+01, 5.7047266553E+01, 4.2068814142E-01],
	[7.04000E+03, 2.3997953567E+03, 7.0692758199E+03, 5.9053308620E+01, 5.7168953622E+01, 4.2087843917E-01],
	[7.04500E+03, 2.4019049694E+03, 7.0670006833E+03, 5.9182215092E+01, 5.7290808060E+01, 4.2106866277E-01],
	[7.05000E+03, 2.4040149379E+03, 7.0647278923E+03, 5.9311310702E+01, 5.7412829959E+01, 4.2125881247E-01],
	[7.05500E+03, 2.4061252620E+03, 7.0624574427E+03, 5.9440595592E+01, 5.7535019407E+01, 4.2144888850E-01],
	[7.06000E+03, 2.4082359417E+03, 7.0601893307E+03, 5.9570069906E+01, 5.7657376495E+01, 4.2163889108E-01],
	[7.06500E+03, 2.4103469765E+03, 7.0579235519E+03, 5.9699733783E+01, 5.7779901310E+01, 4.2182882046E-01],
	[7.07000E+03, 2.4124583665E+03, 7.0556601025E+03, 5.9829587368E+01, 5.7902593943E+01, 4.2201867687E-01],
	[7.07500E+03, 2.4145701113E+03, 7.0533989784E+03, 5.9959630800E+01, 5.8025454483E+01, 4.2220846053E-01],
	[7.08000E+03, 2.4166822108E+03, 7.0511401756E+03, 6.0089864223E+01, 5.8148483019E+01, 4.2239817168E-01],
	[7.08500E+03, 2.4187946647E+03, 7.0488836900E+03, 6.0220287777E+01, 5.8271679640E+01, 4.2258781055E-01],
	[7.09000E+03, 2.4209074730E+03, 7.0466295176E+03, 6.0350901606E+01, 5.8395044435E+01, 4.2277737738E-01],
	[7.09500E+03, 2.4230206354E+03, 7.0443776544E+03, 6.0481705851E+01, 5.8518577493E+01, 4.2296687239E-01],
	[7.10000E+03, 2.4251341518E+03, 7.0421280965E+03, 6.0612700654E+01, 5.8642278902E+01, 4.2315629581E-01],
	[7.10500E+03, 2.4272480218E+03, 7.0398808399E+03, 6.0743886157E+01, 5.8766148751E+01, 4.2334564788E-01],
	[7.11000E+03, 2.4293622454E+03, 7.0376358805E+03, 6.0875262502E+01, 5.8890187129E+01, 4.2353492883E-01],
	[7.11500E+03, 2.4314768224E+03, 7.0353932144E+03, 6.1006829831E+01, 5.9014394125E+01, 4.2372413887E-01],
	[7.12000E+03, 2.4335917525E+03, 7.0331528377E+03, 6.1138588286E+01, 5.9138769826E+01, 4.2391327825E-01],
	[7.12500E+03, 2.4357070356E+03, 7.0309147465E+03, 6.1270538008E+01, 5.9263314321E+01, 4.2410234720E-01],
	[7.13000E+03, 2.4378226714E+03, 7.0286789367E+03, 6.1402679140E+01, 5.9388027698E+01, 4.2429134593E-01],
	[7.13500E+03, 2.4399386599E+03, 7.0264454045E+03, 6.1535011824E+01, 5.9512910046E+01, 4.2448027468E-01],
	[7.14000E+03, 2.4420550008E+03, 7.0242141460E+03, 6.1667536202E+01, 5.9637961452E+01, 4.2466913364E-01],
	[7.14500E+03, 2.4441716939E+03, 7.0219851572E+03, 6.1800252416E+01, 5.9763182004E+01, 4.2485792301E-01],
	[7.15000E+03, 2.4462887390E+03, 7.0197584343E+03, 6.1933160607E+01, 5.9888571791E+01, 4.2504664297E-01],
	[7.15500E+03, 2.4484061360E+03, 7.0175339734E+03, 6.2066260918E+01, 6.0014130899E+01, 4.2523529374E-01],
	[7.16000E+03, 2.4505238846E+03, 7.0153117706E+03, 6.2199553491E+01, 6.0139859418E+01, 4.2542387549E-01],
	[7.16500E+03, 2.4526419847E+03, 7.0130918219E+03, 6.2333038467E+01, 6.0265757433E+01, 4.2561238843E-01],
	[7.17000E+03, 2.4547604361E+03, 7.0108741237E+03, 6.2466715990E+01, 6.0391825033E+01, 4.2580083273E-01],
	[7.17500E+03, 2.4568792386E+03, 7.0086586720E+03, 6.2600586200E+01, 6.0518062306E+01, 4.2598920861E-01],
	[7.18000E+03, 2.4589983920E+03, 7.0064454630E+03, 6.2734649239E+01, 6.0644469338E+01, 4.2617751624E-01],
	[7.18500E+03, 2.4611254117E+03, 7.0042883393E+03, 6.2868905251E+01, 6.0771054852E+01, 4.2636575583E-01],
	[7.19000E+03, 2.4632559808E+03, 7.0021562155E+03, 6.3003354376E+01, 6.0897814039E+01, 4.2655392755E-01],
	[7.19500E+03, 2.4653869112E+03, 7.0000262222E+03, 6.3137996757E+01, 6.1024743333E+01, 4.2674203161E-01],
	[7.20000E+03, 2.4675182029E+03, 6.9978983559E+03, 6.3272832536E+01, 6.1151842823E+01, 4.2693006820E-01],
	[7.20500E+03, 2.4696498555E+03, 6.9957726129E+03, 6.3407861855E+01, 6.1279112594E+01, 4.2711803750E-01],
	[7.21000E+03, 2.4717818690E+03, 6.9936489897E+03, 6.3543084856E+01, 6.1406552736E+01, 4.2730593971E-01],
	[7.21500E+03, 2.4739142431E+03, 6.9915274826E+03, 6.3678501680E+01, 6.1534163333E+01, 4.2749377501E-01],
	[7.22000E+03, 2.4760469776E+03, 6.9894080880E+03, 6.3814112471E+01, 6.1661944474E+01, 4.2768154361E-01],
	[7.22500E+03, 2.4781800723E+03, 6.9872908025E+03, 6.3949917369E+01, 6.1789896246E+01, 4.2786924567E-01],
	[7.23000E+03, 2.4803135271E+03, 6.9851756225E+03, 6.4085916518E+01, 6.1918018734E+01, 4.2805688141E-01],
	[7.23500E+03, 2.4824473418E+03, 6.9830625444E+03, 6.4222110059E+01, 6.2046312026E+01, 4.2824445100E-01],
	[7.24000E+03, 2.4845815162E+03, 6.9809515646E+03, 6.4358498134E+01, 6.2174776209E+01, 4.2843195464E-01],
	[7.24500E+03, 2.4867160501E+03, 6.9788426797E+03, 6.4495080885E+01, 6.2303411369E+01, 4.2861939250E-01],
	[7.25000E+03, 2.4888509432E+03, 6.9767358861E+03, 6.4631858455E+01, 6.2432217592E+01, 4.2880676480E-01],
	[7.25500E+03, 2.4909861955E+03, 6.9746311803E+03, 6.4768830984E+01, 6.2561194964E+01, 4.2899407170E-01],
	[7.26000E+03, 2.4931218067E+03, 6.9725285589E+03, 6.4905998617E+01, 6.2690343573E+01, 4.2918131340E-01],
	[7.26500E+03, 2.4952577767E+03, 6.9704280182E+03, 6.5043361494E+01, 6.2819663504E+01, 4.2936849008E-01],
	[7.27000E+03, 2.4973941052E+03, 6.9683295548E+03, 6.5180919757E+01, 6.2949154843E+01, 4.2955560195E-01],
	[7.27500E+03, 2.4995307921E+03, 6.9662331653E+03, 6.5318673549E+01, 6.3078817676E+01, 4.2974264917E-01],
	[7.28000E+03, 2.5016678372E+03, 6.9641388461E+03, 6.5456623012E+01, 6.3208652089E+01, 4.2992963194E-01],
	[7.28500E+03, 2.5038052403E+03, 6.9620465939E+03, 6.5594768288E+01, 6.3338658168E+01, 4.3011655044E-01],
	[7.29000E+03, 2.5059430012E+03, 6.9599564051E+03, 6.5733109518E+01, 6.3468835998E+01, 4.3030340487E-01],
	[7.29500E+03, 2.5080811197E+03, 6.9578682762E+03, 6.5871646846E+01, 6.3599185665E+01, 4.3049019541E-01],
	[7.30000E+03, 2.5102195956E+03, 6.9557822040E+03, 6.6010380413E+01, 6.3729707255E+01, 4.3067692224E-01],
	[7.30500E+03, 2.5123584288E+03, 6.9536981848E+03, 6.6149310361E+01, 6.3860400853E+01, 4.3086358555E-01],
	[7.31000E+03, 2.5144976191E+03, 6.9516162153E+03, 6.6288436832E+01, 6.3991266545E+01, 4.3105018553E-01],
	[7.31500E+03, 2.5166371663E+03, 6.9495362922E+03, 6.6427759969E+01, 6.4122304415E+01, 4.3123672236E-01],
	[7.32000E+03, 2.5187770702E+03, 6.9474584119E+03, 6.6567279914E+01, 6.4253514548E+01, 4.3142319622E-01],
	[7.32500E+03, 2.5209173306E+03, 6.9453825710E+03, 6.6706996808E+01, 6.4384897031E+01, 4.3160960731E-01],
	[7.33000E+03, 2.5230579473E+03, 6.9433087663E+03, 6.6846910794E+01, 6.4516451947E+01, 4.3179595580E-01],
	[7.33500E+03, 2.5251989202E+03, 6.9412369942E+03, 6.6987022014E+01, 6.4648179382E+01, 4.3198224188E-01],
	[7.34000E+03, 2.5273402491E+03, 6.9391672515E+03, 6.7127330610E+01, 6.4780079420E+01, 4.3216846574E-01],
	[7.34500E+03, 2.5294819337E+03, 6.9370995347E+03, 6.7267836724E+01, 6.4912152147E+01, 4.3235462756E-01],
	[7.35000E+03, 2.5316239739E+03, 6.9350338406E+03, 6.7408540499E+01, 6.5044397646E+01, 4.3254072752E-01],
	[7.35500E+03, 2.5337663696E+03, 6.9329701656E+03, 6.7549442076E+01, 6.5176816002E+01, 4.3272676581E-01],
	[7.36000E+03, 2.5359091205E+03, 6.9309085066E+03, 6.7690541598E+01, 6.5309407300E+01, 4.3291274261E-01],
	[7.36500E+03, 2.5380522264E+03, 6.9288488601E+03, 6.7831839206E+01, 6.5442171623E+01, 4.3309865810E-01],
	[7.37000E+03, 2.5401956872E+03, 6.9267912228E+03, 6.7973335043E+01, 6.5575109057E+01, 4.3328451247E-01],
	[7.37500E+03, 2.5423395027E+03, 6.9247355915E+03, 6.8115029252E+01, 6.5708219685E+01, 4.3347030590E-01],
	[7.38000E+03, 2.5444836727E+03, 6.9226819627E+03, 6.8256921974E+01, 6.5841503591E+01, 4.3365603857E-01],
	[7.38500E+03, 2.5466281971E+03, 6.9206303333E+03, 6.8399013351E+01, 6.5974960860E+01, 4.3384171066E-01],
	[7.39000E+03, 2.5487730755E+03, 6.9185806998E+03, 6.8541303525E+01, 6.6108591574E+01, 4.3402732236E-01],
	[7.39500E+03, 2.5509183080E+03, 6.9165330591E+03, 6.8683792640E+01, 6.6242395818E+01, 4.3421287384E-01],
	[7.40000E+03, 2.5530638942E+03, 6.9144874077E+03, 6.8826480836E+01, 6.6376373676E+01, 4.3439836530E-01],
	[7.40500E+03, 2.5552098340E+03, 6.9124437425E+03, 6.8969368257E+01, 6.6510525231E+01, 4.3458379690E-01],
	[7.41000E+03, 2.5573561273E+03, 6.9104020602E+03, 6.9112455043E+01, 6.6644850566E+01, 4.3476916884E-01],
	[7.41500E+03, 2.5595027737E+03, 6.9083623575E+03, 6.9255741338E+01, 6.6779349764E+01, 4.3495448129E-01],
	[7.42000E+03, 2.5616497733E+03, 6.9063246311E+03, 6.9399227284E+01, 6.6914022911E+01, 4.3513973444E-01],
	[7.42500E+03, 2.5637971257E+03, 6.9042888779E+03, 6.9542913023E+01, 6.7048870087E+01, 4.3532492846E-01],
	[7.43000E+03, 2.5659448308E+03, 6.9022550946E+03, 6.9686798696E+01, 6.7183891377E+01, 4.3551006354E-01],
	[7.43500E+03, 2.5680928885E+03, 6.9002232779E+03, 6.9830884447E+01, 6.7319086863E+01, 4.3569513985E-01],
	[7.44000E+03, 2.5702412984E+03, 6.8981934246E+03, 6.9975170418E+01, 6.7454456628E+01, 4.3588015757E-01],
	[7.44500E+03, 2.5723900606E+03, 6.8961655316E+03, 7.0119656749E+01, 6.7590000756E+01, 4.3606511690E-01],
	[7.45000E+03, 2.5745391747E+03, 6.8941395956E+03, 7.0264343585E+01, 6.7725719328E+01, 4.3625001799E-01],
	[7.45500E+03, 2.5766886406E+03, 6.8921156134E+03, 7.0409231067E+01, 6.7861612428E+01, 4.3643486104E-01],
	[7.46000E+03, 2.5788384582E+03, 6.8900935817E+03, 7.0554319337E+01, 6.7997680137E+01, 4.3661964623E-01],
	[7.46500E+03, 2.5809886272E+03, 6.8880734976E+03, 7.0699608537E+01, 6.8133922540E+01, 4.3680437373E-01],
	[7.47000E+03, 2.5831431313E+03, 6.8860841871E+03, 7.0845098811E+01, 6.8270345333E+01, 4.3698904371E-01],
	[7.47500E+03, 2.5853036733E+03, 6.8841378616E+03, 7.0990790299E+01, 6.8406951056E+01, 4.3717365637E-01],
	[7.48000E+03, 2.5874645759E+03, 6.8821933871E+03, 7.1136683144E+01, 6.8543731812E+01, 4.3735821188E-01],
	[7.48500E+03, 2.5896258390E+03, 6.8802507606E+03, 7.1282777489E+01, 6.8680687682E+01, 4.3754271041E-01],
	[7.49000E+03, 2.5917874622E+03, 6.8783099792E+03, 7.1429073475E+01, 6.8817818749E+01, 4.3772715215E-01],
	[7.49500E+03, 2.5939494454E+03, 6.8763710398E+03, 7.1575571245E+01, 6.8955125095E+01, 4.3791153727E-01],
	[7.50000E+03, 2.5961117885E+03, 6.8744339395E+03, 7.1722270941E+01, 6.9092606802E+01, 4.3809586595E-01],
	[7.50500E+03, 2.5982744913E+03, 6.8724986753E+03, 7.1869172706E+01, 6.9230263953E+01, 4.3828013837E-01],
	[7.51000E+03, 2.6004375535E+03, 6.8705652443E+03, 7.2016276681E+01, 6.9368096628E+01, 4.3846435471E-01],
	[7.51500E+03, 2.6026009751E+03, 6.8686336434E+03, 7.2163583009E+01, 6.9506104911E+01, 4.3864851513E-01],
	[7.52000E+03, 2.6047647558E+03, 6.8667038698E+03, 7.2311091832E+01, 6.9644288883E+01, 4.3883261983E-01],
	[7.52500E+03, 2.6069288954E+03, 6.8647759206E+03, 7.2458803293E+01, 6.9782648625E+01, 4.3901666897E-01],
	[7.53000E+03, 2.6090933938E+03, 6.8628497926E+03, 7.2606717533E+01, 6.9921184220E+01, 4.3920066274E-01],
	[7.53500E+03, 2.6112582508E+03, 6.8609254832E+03, 7.2754834695E+01, 7.0059895748E+01, 4.3938460130E-01],
	[7.54000E+03, 2.6134234662E+03, 6.8590029892E+03, 7.2903154921E+01, 7.0198783291E+01, 4.3956848484E-01],
	[7.54500E+03, 2.6155890399E+03, 6.8570823079E+03, 7.3051678354E+01, 7.0337846930E+01, 4.3975231353E-01],
	[7.55000E+03, 2.6177549716E+03, 6.8551634362E+03, 7.3200405136E+01, 7.0477086747E+01, 4.3993608755E-01],
	[7.55500E+03, 2.6199212612E+03, 6.8532463714E+03, 7.3349335408E+01, 7.0616502822E+01, 4.4011980708E-01],
	[7.56000E+03, 2.6220879085E+03, 6.8513311104E+03, 7.3498469314E+01, 7.0756095237E+01, 4.4030347228E-01],
	[7.56500E+03, 2.6242549133E+03, 6.8494176505E+03, 7.3647806995E+01, 7.0895864072E+01, 4.4048708333E-01],
	[7.57000E+03, 2.6264222754E+03, 6.8475059887E+03, 7.3797348595E+01, 7.1035809409E+01, 4.4067064037E-01],
	[7.57500E+03, 2.6285899948E+03, 6.8455961221E+03, 7.3947094254E+01, 7.1175931328E+01, 4.4085414354E-01],
	[7.58000E+03, 2.6307580711E+03, 6.8436880479E+03, 7.4097044116E+01, 7.1316229909E+01, 4.4103759298E-01],
	[7.58500E+03, 2.6329265042E+03, 6.8417817633E+03, 7.4247198323E+01, 7.1456705234E+01, 4.4122098884E-01],
	[7.59000E+03, 2.6350952940E+03, 6.8398772653E+03, 7.4397557016E+01, 7.1597357382E+01, 4.4140433125E-01],
	[7.59500E+03, 2.6372644402E+03, 6.8379745511E+03, 7.4548120339E+01, 7.1738186434E+01, 4.4158762036E-01],
	[7.60000E+03, 2.6394339427E+03, 6.8360736179E+03, 7.4698888434E+01, 7.1879192470E+01, 4.4177085630E-01],
	[7.60500E+03, 2.6416038014E+03, 6.8341744628E+03, 7.4849861443E+01, 7.2020375570E+01, 4.4195403922E-01],
	[7.61000E+03, 2.6437740159E+03, 6.8322770831E+03, 7.5001039508E+01, 7.2161735815E+01, 4.4213716926E-01],
	[7.61500E+03, 2.6459445862E+03, 6.8303814758E+03, 7.5152422772E+01, 7.2303273284E+01, 4.4232024655E-01],
	[7.62000E+03, 2.6481155122E+03, 6.8284876381E+03, 7.5304011377E+01, 7.2444988057E+01, 4.4250327124E-01],
	[7.62500E+03, 2.6502867935E+03, 6.8265955674E+03, 7.5455805465E+01, 7.2586880214E+01, 4.4268624348E-01],
	[7.63000E+03, 2.6524584300E+03, 6.8247052606E+03, 7.5607805179E+01, 7.2728949835E+01, 4.4286916339E-01],
	[7.63500E+03, 2.6546304216E+03, 6.8228167152E+03, 7.5760010661E+01, 7.2871196998E+01, 4.4305203112E-01],
	[7.64000E+03, 2.6568027681E+03, 6.8209299281E+03, 7.5912422053E+01, 7.3013621784E+01, 4.4323484681E-01],
	[7.64500E+03, 2.6589754693E+03, 6.8190448968E+03, 7.6065039498E+01, 7.3156224272E+01, 4.4341761060E-01],
	[7.65000E+03, 2.6611485251E+03, 6.8171616183E+03, 7.6217863137E+01, 7.3299004541E+01, 4.4360032263E-01],
	[7.65500E+03, 2.6633219351E+03, 6.8152800899E+03, 7.6370893115E+01, 7.3441962671E+01, 4.4378298304E-01],
	[7.66000E+03, 2.6654956994E+03, 6.8134003089E+03, 7.6524129571E+01, 7.3585098740E+01, 4.4396559196E-01],
	[7.66500E+03, 2.6676698177E+03, 6.8115222724E+03, 7.6677572650E+01, 7.3728412827E+01, 4.4414814954E-01],
	[7.67000E+03, 2.6698442899E+03, 6.8096459778E+03, 7.6831222494E+01, 7.3871905011E+01, 4.4433065592E-01],
	[7.67500E+03, 2.6720191157E+03, 6.8077714223E+03, 7.6985079244E+01, 7.4015575372E+01, 4.4451311123E-01],
	[7.68000E+03, 2.6741942950E+03, 6.8058986031E+03, 7.7139143043E+01, 7.4159423987E+01, 4.4469551562E-01],
	[7.68500E+03, 2.6763698276E+03, 6.8040275175E+03, 7.7293414034E+01, 7.4303450935E+01, 4.4487786922E-01],
	[7.69000E+03, 2.6785457134E+03, 6.8021581627E+03, 7.7447892359E+01, 7.4447656296E+01, 4.4506017217E-01],
	[7.69500E+03, 2.6807219522E+03, 6.8002905361E+03, 7.7602578160E+01, 7.4592040146E+01, 4.4524242461E-01],
	[7.70000E+03, 2.6828985437E+03, 6.7984246349E+03, 7.7757471580E+01, 7.4736602565E+01, 4.4542462668E-01],
	[7.70500E+03, 2.6850754879E+03, 6.7965604565E+03, 7.7912572761E+01, 7.4881343630E+01, 4.4560677852E-01],
	[7.71000E+03, 2.6872527846E+03, 6.7946979980E+03, 7.8067881845E+01, 7.5026263420E+01, 4.4578888027E-01],
	[7.71500E+03, 2.6894304335E+03, 6.7928372568E+03, 7.8223398975E+01, 7.5171362013E+01, 4.4597093205E-01],
	[7.72000E+03, 2.6916084346E+03, 6.7909782303E+03, 7.8379124293E+01, 7.5316639486E+01, 4.4615293402E-01],
	[7.72500E+03, 2.6937867876E+03, 6.7891209156E+03, 7.8535057942E+01, 7.5462095917E+01, 4.4633488631E-01],
	[7.73000E+03, 2.6959654924E+03, 6.7872653102E+03, 7.8691200064E+01, 7.5607731385E+01, 4.4651678906E-01],
	[7.73500E+03, 2.6981445488E+03, 6.7854114114E+03, 7.8847550801E+01, 7.5753545966E+01, 4.4669864240E-01],
	[7.74000E+03, 2.7003239566E+03, 6.7835592164E+03, 7.9004110296E+01, 7.5899539738E+01, 4.4688044647E-01],
	[7.74500E+03, 2.7025037157E+03, 6.7817087227E+03, 7.9160878692E+01, 7.6045712779E+01, 4.4706220142E-01],
	[7.75000E+03, 2.7046838259E+03, 6.7798599275E+03, 7.9317856130E+01, 7.6192065166E+01, 4.4724390737E-01],
	[7.75500E+03, 2.7068642870E+03, 6.7780128282E+03, 7.9475042753E+01, 7.6338596975E+01, 4.4742556446E-01],
	[7.76000E+03, 2.7090450989E+03, 6.7761674222E+03, 7.9632438703E+01, 7.6485308285E+01, 4.4760717284E-01],
	[7.76500E+03, 2.7112262614E+03, 6.7743237068E+03, 7.9790044124E+01, 7.6632199172E+01, 4.4778873264E-01],
	[7.77000E+03, 2.7134149859E+03, 6.7725350051E+03, 7.9947859157E+01, 7.6779282341E+01, 4.4797024399E-01],
	[7.77500E+03, 2.7156054699E+03, 6.7707582838E+03, 8.0105883944E+01, 7.6926547786E+01, 4.4815170704E-01],
	[7.78000E+03, 2.7177963123E+03, 6.7689831704E+03, 8.0264118629E+01, 7.7073993138E+01, 4.4833312192E-01],
	[7.78500E+03, 2.7199875130E+03, 6.7672096624E+03, 8.0422563353E+01, 7.7221618474E+01, 4.4851448876E-01],
	[7.79000E+03, 2.7221790717E+03, 6.7654377573E+03, 8.0581218260E+01, 7.7369423871E+01, 4.4869580770E-01],
	[7.79500E+03, 2.7243709883E+03, 6.7636674526E+03, 8.0740083491E+01, 7.7517409407E+01, 4.4887707889E-01],
	[7.80000E+03, 2.7265632627E+03, 6.7618987459E+03, 8.0899159189E+01, 7.7665575156E+01, 4.4905830245E-01],
	[7.80500E+03, 2.7287558946E+03, 6.7601316347E+03, 8.1058445496E+01, 7.7813921197E+01, 4.4923947852E-01],
	[7.81000E+03, 2.7309488838E+03, 6.7583661165E+03, 8.1217942556E+01, 7.7962447606E+01, 4.4942060724E-01],
	[7.81500E+03, 2.7331422303E+03, 6.7566021889E+03, 8.1377650509E+01, 7.8111154458E+01, 4.4960168874E-01],
	[7.82000E+03, 2.7353359338E+03, 6.7548398495E+03, 8.1537569500E+01, 7.8260041831E+01, 4.4978272316E-01],
	[7.82500E+03, 2.7375299942E+03, 6.7530790957E+03, 8.1697699669E+01, 7.8409109801E+01, 4.4996371064E-01],
	[7.83000E+03, 2.7397244113E+03, 6.7513199252E+03, 8.1858041161E+01, 7.8558358443E+01, 4.5014465131E-01],
	[7.83500E+03, 2.7419191850E+03, 6.7495623355E+03, 8.2018594116E+01, 7.8707787834E+01, 4.5032554531E-01],
	[7.84000E+03, 2.7441143150E+03, 6.7478063242E+03, 8.2179358678E+01, 7.8857398049E+01, 4.5050639277E-01],
	[7.84500E+03, 2.7463098011E+03, 6.7460518888E+03, 8.2340334990E+01, 7.9007189165E+01, 4.5068719383E-01],
	[7.85000E+03, 2.7485056433E+03, 6.7442990270E+03, 8.2501523192E+01, 7.9157161256E+01, 4.5086794862E-01],
	[7.85500E+03, 2.7507018414E+03, 6.7425477364E+03, 8.2662923429E+01, 7.9307314399E+01, 4.5104865727E-01],
	[7.86000E+03, 2.7528983951E+03, 6.7407980145E+03, 8.2824535843E+01, 7.9457648670E+01, 4.5122931994E-01],
	[7.86500E+03, 2.7550953044E+03, 6.7390498589E+03, 8.2986360576E+01, 7.9608164143E+01, 4.5140993674E-01],
	[7.87000E+03, 2.7572925690E+03, 6.7373032672E+03, 8.3148397770E+01, 7.9758860893E+01, 4.5159050781E-01],
	[7.87500E+03, 2.7594901887E+03, 6.7355582371E+03, 8.3310647568E+01, 7.9909738997E+01, 4.5177103330E-01],
	[7.88000E+03, 2.7616881635E+03, 6.7338147661E+03, 8.3473110113E+01, 8.0060798529E+01, 4.5195151332E-01],
	[7.88500E+03, 2.7638864931E+03, 6.7320728519E+03, 8.3635785547E+01, 8.0212039564E+01, 4.5213194803E-01],
	[7.89000E+03, 2.7660851774E+03, 6.7303324921E+03, 8.3798674012E+01, 8.0363462177E+01, 4.5231233754E-01],
	[7.89500E+03, 2.7682842163E+03, 6.7285936843E+03, 8.3961775652E+01, 8.0515066443E+01, 4.5249268201E-01],
	[7.90000E+03, 2.7704836094E+03, 6.7268564262E+03, 8.4125090608E+01, 8.0666852436E+01, 4.5267298155E-01],
	[7.90500E+03, 2.7726833567E+03, 6.7251207154E+03, 8.4288619023E+01, 8.0818820231E+01, 4.5285323632E-01],
	[7.91000E+03, 2.7748834580E+03, 6.7233865495E+03, 8.4452361040E+01, 8.0970969903E+01, 4.5303344643E-01],
	[7.91500E+03, 2.7770839132E+03, 6.7216539263E+03, 8.4616316801E+01, 8.1123301526E+01, 4.5321361202E-01],
	[7.92000E+03, 2.7792847220E+03, 6.7199228432E+03, 8.4780486448E+01, 8.1275815174E+01, 4.5339373324E-01],
	[7.92500E+03, 2.7814858844E+03, 6.7181932981E+03, 8.4944870125E+01, 8.1428510921E+01, 4.5357381020E-01],
	[7.93000E+03, 2.7836874001E+03, 6.7164652886E+03, 8.5109467973E+01, 8.1581388842E+01, 4.5375384306E-01],
	[7.93500E+03, 2.7858892689E+03, 6.7147388123E+03, 8.5274280136E+01, 8.1734449011E+01, 4.5393383193E-01],
	[7.94000E+03, 2.7880914908E+03, 6.7130138669E+03, 8.5439306756E+01, 8.1887691501E+01, 4.5411377696E-01],
	[7.94500E+03, 2.7902940654E+03, 6.7112904501E+03, 8.5604547974E+01, 8.2041116386E+01, 4.5429367827E-01],
	[7.95000E+03, 2.7924969928E+03, 6.7095685596E+03, 8.5770003935E+01, 8.2194723739E+01, 4.5447353601E-01],
	[7.95500E+03, 2.7947002727E+03, 6.7078481931E+03, 8.5935674780E+01, 8.2348513636E+01, 4.5465335030E-01],
	[7.96000E+03, 2.7969039049E+03, 6.7061293483E+03, 8.6101560652E+01, 8.2502486148E+01, 4.5483312127E-01],
	[7.96500E+03, 2.7991078893E+03, 6.7044120228E+03, 8.6267661694E+01, 8.2656641349E+01, 4.5501284907E-01],
	[7.97000E+03, 2.8013122258E+03, 6.7026962143E+03, 8.6433978047E+01, 8.2810979313E+01, 4.5519253383E-01],
	[7.97500E+03, 2.8035169140E+03, 6.7009819207E+03, 8.6600509856E+01, 8.2965500112E+01, 4.5537217566E-01],
	[7.98000E+03, 2.8057219540E+03, 6.6992691395E+03, 8.6767257261E+01, 8.3120203820E+01, 4.5555177466E-01],
	[7.98500E+03, 2.8079273455E+03, 6.6975578686E+03, 8.6934220406E+01, 8.3275090510E+01, 4.5573133093E-01],
	[7.99000E+03, 2.8101330883E+03, 6.6958481056E+03, 8.7101399434E+01, 8.3430160254E+01, 4.5591084458E-01],
	[7.99500E+03, 2.8123391823E+03, 6.6941398483E+03, 8.7268794486E+01, 8.3585413126E+01, 4.5609031571E-01],
	[8.00000E+03, 2.8145456274E+03, 6.6924330943E+03, 8.7436405706E+01, 8.3740849198E+01, 4.5626974441E-01],
	[8.00500E+03, 2.8167524233E+03, 6.6907278415E+03, 8.7605083420E+01, 8.3897248282E+01, 4.5644913080E-01],
	[8.01000E+03, 2.8189595699E+03, 6.6890240876E+03, 8.7773980409E+01, 8.4053833109E+01, 4.5662847497E-01],
	[8.01500E+03, 2.8211670671E+03, 6.6873218304E+03, 8.7943096820E+01, 8.4210603752E+01, 4.5680777703E-01],
	[8.02000E+03, 2.8233749146E+03, 6.6856210675E+03, 8.8112432799E+01, 8.4367560288E+01, 4.5698703708E-01],
	[8.02500E+03, 2.8255831124E+03, 6.6839217967E+03, 8.8281988493E+01, 8.4524702791E+01, 4.5716625522E-01],
	[8.03000E+03, 2.8277916602E+03, 6.6822240158E+03, 8.8451764050E+01, 8.4682031335E+01, 4.5734543155E-01],
	[8.03500E+03, 2.8300005579E+03, 6.6805277227E+03, 8.8621759617E+01, 8.4839545996E+01, 4.5752456618E-01],
	[8.04000E+03, 2.8322098053E+03, 6.6788329149E+03, 8.8791975339E+01, 8.4997246848E+01, 4.5770365920E-01],
	[8.04500E+03, 2.8344194023E+03, 6.6771395904E+03, 8.8962411364E+01, 8.5155133965E+01, 4.5788271072E-01],
	[8.05000E+03, 2.8366293486E+03, 6.6754477469E+03, 8.9133067840E+01, 8.5313207423E+01, 4.5806172085E-01],
	[8.05500E+03, 2.8388396443E+03, 6.6737573821E+03, 8.9303944912E+01, 8.5471467294E+01, 4.5824068967E-01],
	[8.06000E+03, 2.8410502890E+03, 6.6720684940E+03, 8.9475042728E+01, 8.5629913654E+01, 4.5841961730E-01],
	[8.06500E+03, 2.8432612826E+03, 6.6703810802E+03, 8.9646361434E+01, 8.5788546576E+01, 4.5859850384E-01],
	[8.07000E+03, 2.8454726250E+03, 6.6686951385E+03, 8.9817901179E+01, 8.5947366134E+01, 4.5877734938E-01],
	[8.07500E+03, 2.8476843159E+03, 6.6670106669E+03, 8.9989662108E+01, 8.6106372403E+01, 4.5895615404E-01],
	[8.08000E+03, 2.8499032298E+03, 6.6653790384E+03, 9.0161644368E+01, 8.6265580359E+01, 4.5913491790E-01],
	[8.08500E+03, 2.8521233831E+03, 6.6637554222E+03, 9.0333848107E+01, 8.6424977192E+01, 4.5931364108E-01],
	[8.09000E+03, 2.8543438916E+03, 6.6621332050E+03, 9.0506273471E+01, 8.6584561063E+01, 4.5949232368E-01],
	[8.09500E+03, 2.8565647555E+03, 6.6605123846E+03, 9.0678920608E+01, 8.6744332048E+01, 4.5967096579E-01],
	[8.10000E+03, 2.8587859743E+03, 6.6588929590E+03, 9.0851789664E+01, 8.6904290219E+01, 4.5984956751E-01],
	[8.10500E+03, 2.8610075480E+03, 6.6572749261E+03, 9.1024880786E+01, 8.7064435651E+01, 4.6002812896E-01],
	[8.11000E+03, 2.8632294765E+03, 6.6556582839E+03, 9.1198194122E+01, 8.7224768416E+01, 4.6020665023E-01],
	[8.11500E+03, 2.8654517595E+03, 6.6540430303E+03, 9.1371729818E+01, 8.7385288589E+01, 4.6038513142E-01],
	[8.12000E+03, 2.8676743969E+03, 6.6524291633E+03, 9.1545488021E+01, 8.7545996242E+01, 4.6056357263E-01],
	[8.12500E+03, 2.8698973886E+03, 6.6508166807E+03, 9.1719468878E+01, 8.7706891448E+01, 4.6074197396E-01],
	[8.13000E+03, 2.8721207343E+03, 6.6492055807E+03, 9.1893672537E+01, 8.7867974282E+01, 4.6092033552E-01],
	[8.13500E+03, 2.8743444340E+03, 6.6475958611E+03, 9.2068099143E+01, 8.8029244815E+01, 4.6109865741E-01],
	[8.14000E+03, 2.8765684874E+03, 6.6459875199E+03, 9.2242748845E+01, 8.8190703121E+01, 4.6127693973E-01],
	[8.14500E+03, 2.8787928944E+03, 6.6443805551E+03, 9.2417621789E+01, 8.8352349272E+01, 4.6145518257E-01],
	[8.15000E+03, 2.8810176548E+03, 6.6427749646E+03, 9.2592718123E+01, 8.8514183341E+01, 4.6163338605E-01],
	[8.15500E+03, 2.8832427685E+03, 6.6411707466E+03, 9.2768037992E+01, 8.8676205401E+01, 4.6181155026E-01],
	[8.16000E+03, 2.8854682353E+03, 6.6395678988E+03, 9.2943581545E+01, 8.8838415524E+01, 4.6198967530E-01],
	[8.16500E+03, 2.8876940551E+03, 6.6379664194E+03, 9.3119348929E+01, 8.9000813783E+01, 4.6216776127E-01],
	[8.17000E+03, 2.8899202276E+03, 6.6363663063E+03, 9.3295340289E+01, 8.9163400249E+01, 4.6234580827E-01],
	[8.17500E+03, 2.8921467528E+03, 6.6347675576E+03, 9.3471555774E+01, 8.9326174995E+01, 4.6252381641E-01],
	[8.18000E+03, 2.8943736304E+03, 6.6331701711E+03, 9.3647995531E+01, 8.9489138092E+01, 4.6270178579E-01],
	[8.18500E+03, 2.8966008604E+03, 6.6315741450E+03, 9.3824659705E+01, 8.9652289614E+01, 4.6287971650E-01],
	[8.19000E+03, 2.8988284425E+03, 6.6299794773E+03, 9.4001548446E+01, 8.9815629631E+01, 4.6305760865E-01],
	[8.19500E+03, 2.9010563766E+03, 6.6283861659E+03, 9.4178661899E+01, 8.9979158215E+01, 4.6323546234E-01],
	[8.20000E+03, 2.9032846625E+03, 6.6267942088E+03, 9.4356000211E+01, 9.0142875438E+01, 4.6341327767E-01],
	[8.20500E+03, 2.9055133001E+03, 6.6252036042E+03, 9.4533563531E+01, 9.0306781372E+01, 4.6359105474E-01],
	[8.21000E+03, 2.9077422892E+03, 6.6236143500E+03, 9.4711352004E+01, 9.0470876087E+01, 4.6376879364E-01],
	[8.21500E+03, 2.9099716297E+03, 6.6220264443E+03, 9.4889365777E+01, 9.0635159655E+01, 4.6394649449E-01],
	[8.22000E+03, 2.9122013214E+03, 6.6204398851E+03, 9.5067604999E+01, 9.0799632147E+01, 4.6412415738E-01],
	[8.22500E+03, 2.9144313641E+03, 6.6188546704E+03, 9.5246069816E+01, 9.0964293635E+01, 4.6430178241E-01],
	[8.23000E+03, 2.9166617577E+03, 6.6172707983E+03, 9.5424760375E+01, 9.1129144189E+01, 4.6447936968E-01],
	[8.23500E+03, 2.9188925020E+03, 6.6156882669E+03, 9.5603676823E+01, 9.1294183880E+01, 4.6465691930E-01],
	[8.24000E+03, 2.9211235968E+03, 6.6141070741E+03, 9.5782819308E+01, 9.1459412778E+01, 4.6483443136E-01],
	[8.24500E+03, 2.9233550421E+03, 6.6125272181E+03, 9.5962187976E+01, 9.1624830955E+01, 4.6501190596E-01],
	[8.25000E+03, 2.9255868377E+03, 6.6109486969E+03, 9.6141782974E+01, 9.1790438481E+01, 4.6518934321E-01],
	[8.25500E+03, 2.9278189833E+03, 6.6093715085E+03, 9.6321604450E+01, 9.1956235426E+01, 4.6536674320E-01],
	[8.26000E+03, 2.9300514788E+03, 6.6077956511E+03, 9.6501652551E+01, 9.2122221861E+01, 4.6554410603E-01],
	[8.26500E+03, 2.9322843242E+03, 6.6062211227E+03, 9.6681927424E+01, 9.2288397856E+01, 4.6572143181E-01],
	[8.27000E+03, 2.9345175191E+03, 6.6046479213E+03, 9.6862429216E+01, 9.2454763481E+01, 4.6589872064E-01],
	[8.27500E+03, 2.9367510635E+03, 6.6030760452E+03, 9.7043158074E+01, 9.2621318805E+01, 4.6607597261E-01],
	[8.28000E+03, 2.9389849572E+03, 6.6015054922E+03, 9.7224114145E+01, 9.2788063899E+01, 4.6625318782E-01],
	[8.28500E+03, 2.9412192001E+03, 6.5999362607E+03, 9.7405297577E+01, 9.2954998833E+01, 4.6643036639E-01],
	[8.29000E+03, 2.9434537920E+03, 6.5983683485E+03, 9.7586708517E+01, 9.3122123676E+01, 4.6660750839E-01],
	[8.29500E+03, 2.9456887327E+03, 6.5968017539E+03, 9.7768347111E+01, 9.3289438498E+01, 4.6678461395E-01],
	[8.30000E+03, 2.9479240221E+03, 6.5952364749E+03, 9.7950213507E+01, 9.3456943368E+01, 4.6696168314E-01],
	[8.30500E+03, 2.9501596600E+03, 6.5936725096E+03, 9.8132307852E+01, 9.3624638355E+01, 4.6713871609E-01],
	[8.31000E+03, 2.9523956463E+03, 6.5921098561E+03, 9.8314630294E+01, 9.3792523530E+01, 4.6731571288E-01],
	[8.31500E+03, 2.9546319808E+03, 6.5905485126E+03, 9.8497180979E+01, 9.3960598959E+01, 4.6749267362E-01],
	[8.32000E+03, 2.9568686634E+03, 6.5889884772E+03, 9.8679960055E+01, 9.4128864714E+01, 4.6766959840E-01],
	[8.32500E+03, 2.9591056939E+03, 6.5874297479E+03, 9.8862967668E+01, 9.4297320863E+01, 4.6784648733E-01],
	[8.33000E+03, 2.9613430721E+03, 6.5858723230E+03, 9.9046203966E+01, 9.4465967474E+01, 4.6802334050E-01],
	[8.33500E+03, 2.9635807979E+03, 6.5843162004E+03, 9.9229669097E+01, 9.4634804616E+01, 4.6820015802E-01],
	[8.34000E+03, 2.9658188712E+03, 6.5827613785E+03, 9.9413363207E+01, 9.4803832358E+01, 4.6837693998E-01],
	[8.34500E+03, 2.9680572917E+03, 6.5812078552E+03, 9.9597286444E+01, 9.4973050768E+01, 4.6855368649E-01],
	[8.35000E+03, 2.9702960594E+03, 6.5796556287E+03, 9.9781438954E+01, 9.5142459914E+01, 4.6873039765E-01],
	[8.35500E+03, 2.9725351741E+03, 6.5781046973E+03, 9.9965820886E+01, 9.5312059865E+01, 4.6890707355E-01],
	[8.36000E+03, 2.9747746356E+03, 6.5765550589E+03, 1.0015043239E+02, 9.5481850689E+01, 4.6908371429E-01],
	[8.36500E+03, 2.9770144437E+03, 6.5750067118E+03, 1.0033527360E+02, 9.5651832454E+01, 4.6926031996E-01],
	[8.37000E+03, 2.9792545984E+03, 6.5734596542E+03, 1.0052034468E+02, 9.5822005228E+01, 4.6943689063E-01],
	[8.37500E+03, 2.9814950994E+03, 6.5719138841E+03, 1.0070564577E+02, 9.5992369078E+01, 4.6961342635E-01],
	[8.38000E+03, 2.9837359467E+03, 6.5703693998E+03, 1.0089117701E+02, 9.6162924073E+01, 4.6978992722E-01],
	[8.38500E+03, 2.9859771400E+03, 6.5688261993E+03, 1.0107693856E+02, 9.6333670279E+01, 4.6996639330E-01],
	[8.39000E+03, 2.9882186792E+03, 6.5672842810E+03, 1.0126293056E+02, 9.6504607765E+01, 4.7014282466E-01],
	[8.39500E+03, 2.9904605642E+03, 6.5657436429E+03, 1.0144915316E+02, 9.6675736597E+01, 4.7031922138E-01],
	[8.40000E+03, 2.9927061917E+03, 6.5642287617E+03, 1.0163560651E+02, 9.6847065729E+01, 4.7049558353E-01],
	[8.40500E+03, 2.9949560977E+03, 6.5627434220E+03, 1.0182229075E+02, 9.7018596703E+01, 4.7067191119E-01],
	[8.41000E+03, 2.9972063555E+03, 6.5612593015E+03, 1.0200920603E+02, 9.7190319344E+01, 4.7084820442E-01],
	[8.41500E+03, 2.9994569652E+03, 6.5597763984E+03, 1.0219635250E+02, 9.7362233719E+01, 4.7102446330E-01],
	[8.42000E+03, 3.0017079264E+03, 6.5582947109E+03, 1.0238373030E+02, 9.7534339895E+01, 4.7120068790E-01],
	[8.42500E+03, 3.0039592392E+03, 6.5568142375E+03, 1.0257133959E+02, 9.7706637939E+01, 4.7137687830E-01],
	[8.43000E+03, 3.0062109032E+03, 6.5553349763E+03, 1.0275918051E+02, 9.7879127918E+01, 4.7155303456E-01],
	[8.43500E+03, 3.0084629184E+03, 6.5538569257E+03, 1.0294725320E+02, 9.8051809899E+01, 4.7172915677E-01],
	[8.44000E+03, 3.0107152846E+03, 6.5523800839E+03, 1.0313555782E+02, 9.8224683950E+01, 4.7190524500E-01],
	[8.44500E+03, 3.0129680016E+03, 6.5509044493E+03, 1.0332409451E+02, 9.8397750136E+01, 4.7208129931E-01],
	[8.45000E+03, 3.0152210694E+03, 6.5494300201E+03, 1.0351286342E+02, 9.8571008524E+01, 4.7225731978E-01],
	[8.45500E+03, 3.0174744877E+03, 6.5479567946E+03, 1.0370186469E+02, 9.8744459181E+01, 4.7243330649E-01],
	[8.46000E+03, 3.0197282563E+03, 6.5464847712E+03, 1.0389109848E+02, 9.8918102173E+01, 4.7260925950E-01],
	[8.46500E+03, 3.0219823752E+03, 6.5450139482E+03, 1.0408056493E+02, 9.9091937566E+01, 4.7278517889E-01],
	[8.47000E+03, 3.0242368443E+03, 6.5435443238E+03, 1.0427026419E+02, 9.9265965427E+01, 4.7296106474E-01],
	[8.47500E+03, 3.0264916632E+03, 6.5420758965E+03, 1.0446019640E+02, 9.9440185821E+01, 4.7313691711E-01],
	[8.48000E+03, 3.0287468319E+03, 6.5406086644E+03, 1.0465036172E+02, 9.9614598814E+01, 4.7331273608E-01],
	[8.48500E+03, 3.0310023503E+03, 6.5391426260E+03, 1.0484076029E+02, 9.9789204472E+01, 4.7348852172E-01],
	[8.49000E+03, 3.0332582181E+03, 6.5376777795E+03, 1.0503139225E+02, 9.9964002862E+01, 4.7366427411E-01],
	[8.49500E+03, 3.0355144353E+03, 6.5362141233E+03, 1.0522225776E+02, 1.0013899405E+02, 4.7383999332E-01],
	[8.50000E+03, 3.0377710016E+03, 6.5347516557E+03, 1.0541335697E+02, 1.0031417809E+02, 4.7401567942E-01],
	[8.50500E+03, 3.0400279170E+03, 6.5332903751E+03, 1.0560469001E+02, 1.0048955507E+02, 4.7419133248E-01],
	[8.51000E+03, 3.0422851812E+03, 6.5318302798E+03, 1.0579625704E+02, 1.0066512504E+02, 4.7436695258E-01],
	[8.51500E+03, 3.0445427941E+03, 6.5303713682E+03, 1.0598805820E+02, 1.0084088806E+02, 4.7454253979E-01],
	[8.52000E+03, 3.0468007557E+03, 6.5289136385E+03, 1.0618009365E+02, 1.0101684421E+02, 4.7471809419E-01],
	[8.52500E+03, 3.0490590656E+03, 6.5274570891E+03, 1.0637236352E+02, 1.0119299354E+02, 4.7489361584E-01],
	[8.53000E+03, 3.0513177238E+03, 6.5260017185E+03, 1.0656486797E+02, 1.0136933613E+02, 4.7506910482E-01],
	[8.53500E+03, 3.0535767302E+03, 6.5245475249E+03, 1.0675760715E+02, 1.0154587203E+02, 4.7524456120E-01],
	[8.54000E+03, 3.0558360845E+03, 6.5230945067E+03, 1.0695058120E+02, 1.0172260132E+02, 4.7541998506E-01],
	[8.54500E+03, 3.0580957866E+03, 6.5216426622E+03, 1.0714379026E+02, 1.0189952405E+02, 4.7559537647E-01],
	[8.55000E+03, 3.0603558364E+03, 6.5201919899E+03, 1.0733723450E+02, 1.0207664029E+02, 4.7577073550E-01],
	[8.55500E+03, 3.0626162337E+03, 6.5187424881E+03, 1.0753091404E+02, 1.0225395011E+02, 4.7594606222E-01],
	[8.56000E+03, 3.0648769783E+03, 6.5172941552E+03, 1.0772482905E+02, 1.0243145356E+02, 4.7612135671E-01],
	[8.56500E+03, 3.0671380702E+03, 6.5158469896E+03, 1.0791897967E+02, 1.0260915072E+02, 4.7629661905E-01],
	[8.57000E+03, 3.0693995092E+03, 6.5144009895E+03, 1.0811336604E+02, 1.0278704164E+02, 4.7647184930E-01],
	[8.57500E+03, 3.0716612951E+03, 6.5129561535E+03, 1.0830798831E+02, 1.0296512640E+02, 4.7664704753E-01],
	[8.58000E+03, 3.0739234277E+03, 6.5115124798E+03, 1.0850284664E+02, 1.0314340504E+02, 4.7682221382E-01],
	[8.58500E+03, 3.0761859070E+03, 6.5100699670E+03, 1.0869794116E+02, 1.0332187765E+02, 4.7699734825E-01],
	[8.59000E+03, 3.0784487328E+03, 6.5086286133E+03, 1.0889327203E+02, 1.0350054428E+02, 4.7717245089E-01],
	[8.59500E+03, 3.0807119048E+03, 6.5071884172E+03, 1.0908883939E+02, 1.0367940499E+02, 4.7734752180E-01],
	[8.60000E+03, 3.0829754231E+03, 6.5057493771E+03, 1.0928464340E+02, 1.0385845985E+02, 4.7752256106E-01],
	[8.60500E+03, 3.0852392874E+03, 6.5043114913E+03, 1.0948068419E+02, 1.0403770891E+02, 4.7769756876E-01],
	[8.61000E+03, 3.0875034975E+03, 6.5028747583E+03, 1.0967696191E+02, 1.0421715226E+02, 4.7787254495E-01],
	[8.61500E+03, 3.0897680534E+03, 6.5014391765E+03, 1.0987347672E+02, 1.0439678994E+02, 4.7804748971E-01],
	[8.62000E+03, 3.0920329549E+03, 6.5000047443E+03, 1.1007022876E+02, 1.0457662201E+02, 4.7822240311E-01],
	[8.62500E+03, 3.0942982018E+03, 6.4985714601E+03, 1.1026721818E+02, 1.0475664855E+02, 4.7839728524E-01],
	[8.63000E+03, 3.0965637940E+03, 6.4971393223E+03, 1.1046444512E+02, 1.0493686962E+02, 4.7857213615E-01],
	[8.63500E+03, 3.0988297313E+03, 6.4957083293E+03, 1.1066190974E+02, 1.0511728527E+02, 4.7874695593E-01],
	[8.64000E+03, 3.1010960137E+03, 6.4942784796E+03, 1.1085961217E+02, 1.0529789557E+02, 4.7892174464E-01],
	[8.64500E+03, 3.1033626408E+03, 6.4928497716E+03, 1.1105755258E+02, 1.0547870058E+02, 4.7909650237E-01],
	[8.65000E+03, 3.1056296127E+03, 6.4914222037E+03, 1.1125573110E+02, 1.0565970037E+02, 4.7927122918E-01],
	[8.65500E+03, 3.1078969291E+03, 6.4899957744E+03, 1.1145414788E+02, 1.0584089499E+02, 4.7944592514E-01],
	[8.66000E+03, 3.1101645900E+03, 6.4885704820E+03, 1.1165280307E+02, 1.0602228451E+02, 4.7962059034E-01],
	[8.66500E+03, 3.1124325951E+03, 6.4871463251E+03, 1.1185169682E+02, 1.0620386898E+02, 4.7979522484E-01],
	[8.67000E+03, 3.1147009443E+03, 6.4857233020E+03, 1.1205082928E+02, 1.0638564848E+02, 4.7996982871E-01],
	[8.67500E+03, 3.1169696375E+03, 6.4843014112E+03, 1.1225020058E+02, 1.0656762306E+02, 4.8014440203E-01],
	[8.68000E+03, 3.1192386744E+03, 6.4828806512E+03, 1.1244981089E+02, 1.0674979278E+02, 4.8031894487E-01],
	[8.68500E+03, 3.1215080551E+03, 6.4814610204E+03, 1.1264966035E+02, 1.0693215771E+02, 4.8049345731E-01],
	[8.69000E+03, 3.1237777793E+03, 6.4800425173E+03, 1.1284974910E+02, 1.0711471790E+02, 4.8066793942E-01],
	[8.69500E+03, 3.1260478469E+03, 6.4786251403E+03, 1.1305007730E+02, 1.0729747342E+02, 4.8084239126E-01],
	[8.70000E+03, 3.1283182577E+03, 6.4772088878E+03, 1.1325064508E+02, 1.0748042433E+02, 4.8101681293E-01],
	[8.70500E+03, 3.1305890116E+03, 6.4757937584E+03, 1.1345145260E+02, 1.0766357069E+02, 4.8119120448E-01],
	[8.71000E+03, 3.1328601085E+03, 6.4743797505E+03, 1.1365250001E+02, 1.0784691256E+02, 4.8136556599E-01],
	[8.71500E+03, 3.1351315481E+03, 6.4729668625E+03, 1.1385378746E+02, 1.0803044999E+02, 4.8153989753E-01],
	[8.72000E+03, 3.1374033305E+03, 6.4715550930E+03, 1.1405531508E+02, 1.0821418306E+02, 4.8171419918E-01],
	[8.72500E+03, 3.1396754553E+03, 6.4701444404E+03, 1.1425708303E+02, 1.0839811182E+02, 4.8188847101E-01],
	[8.73000E+03, 3.1419479225E+03, 6.4687349032E+03, 1.1445909146E+02, 1.0858223633E+02, 4.8206271310E-01],
	[8.73500E+03, 3.1442240055E+03, 6.4673491236E+03, 1.1466134051E+02, 1.0876656697E+02, 4.8223692550E-01],
	[8.74000E+03, 3.1465040996E+03, 6.4659897683E+03, 1.1486383033E+02, 1.0895110513E+02, 4.8241110827E-01],
	[8.74500E+03, 3.1487845417E+03, 6.4646314759E+03, 1.1506656107E+02, 1.0913583936E+02, 4.8258526146E-01],
	[8.75000E+03, 3.1510653316E+03, 6.4632742450E+03, 1.1526953288E+02, 1.0932076970E+02, 4.8275938511E-01],
	[8.75500E+03, 3.1533464693E+03, 6.4619180741E+03, 1.1547274590E+02, 1.0950589623E+02, 4.8293347927E-01],
	[8.76000E+03, 3.1556279545E+03, 6.4605629618E+03, 1.1567620028E+02, 1.0969121900E+02, 4.8310754400E-01],
	[8.76500E+03, 3.1579097872E+03, 6.4592089067E+03, 1.1587989617E+02, 1.0987673807E+02, 4.8328157935E-01],
	[8.77000E+03, 3.1601919671E+03, 6.4578559074E+03, 1.1608383372E+02, 1.1006245350E+02, 4.8345558536E-01],
	[8.77500E+03, 3.1624744942E+03, 6.4565039624E+03, 1.1628801307E+02, 1.1024836535E+02, 4.8362956209E-01],
	[8.78000E+03, 3.1647573683E+03, 6.4551530703E+03, 1.1649243437E+02, 1.1043447369E+02, 4.8380350958E-01],
	[8.78500E+03, 3.1670405892E+03, 6.4538032297E+03, 1.1669709778E+02, 1.1062077856E+02, 4.8397742790E-01],
	[8.79000E+03, 3.1693241568E+03, 6.4524544391E+03, 1.1690200343E+02, 1.1080728003E+02, 4.8415131708E-01],
	[8.79500E+03, 3.1716080709E+03, 6.4511066972E+03, 1.1710715147E+02, 1.1099397816E+02, 4.8432517719E-01],
	[8.80000E+03, 3.1738923315E+03, 6.4497600026E+03, 1.1731254206E+02, 1.1118087301E+02, 4.8449900826E-01],
	[8.80500E+03, 3.1761769383E+03, 6.4484143538E+03, 1.1751817533E+02, 1.1136796464E+02, 4.8467281036E-01],
	[8.81000E+03, 3.1784618913E+03, 6.4470697494E+03, 1.1772405145E+02, 1.1155525310E+02, 4.8484658353E-01],
	[8.81500E+03, 3.1807471902E+03, 6.4457261881E+03, 1.1793017055E+02, 1.1174273845E+02, 4.8502032783E-01],
	[8.82000E+03, 3.1830328350E+03, 6.4443836684E+03, 1.1813653278E+02, 1.1193042076E+02, 4.8519404329E-01],
	[8.82500E+03, 3.1853188254E+03, 6.4430421889E+03, 1.1834313830E+02, 1.1211830008E+02, 4.8536772999E-01],
	[8.83000E+03, 3.1876051614E+03, 6.4417017482E+03, 1.1854998724E+02, 1.1230637647E+02, 4.8554138796E-01],
	[8.83500E+03, 3.1898918428E+03, 6.4403623451E+03, 1.1875707976E+02, 1.1249464998E+02, 4.8571501725E-01],
	[8.84000E+03, 3.1921788695E+03, 6.4390239779E+03, 1.1896441600E+02, 1.1268312069E+02, 4.8588861793E-01],
	[8.84500E+03, 3.1944662413E+03, 6.4376866455E+03, 1.1917199611E+02, 1.1287178863E+02, 4.8606219003E-01],
	[8.85000E+03, 3.1967539580E+03, 6.4363503463E+03, 1.1937982024E+02, 1.1306065388E+02, 4.8623573362E-01],
	[8.85500E+03, 3.1990420196E+03, 6.4350150790E+03, 1.1958788854E+02, 1.1324971649E+02, 4.8640924873E-01],
	[8.86000E+03, 3.2013304258E+03, 6.4336808423E+03, 1.1979620115E+02, 1.1343897652E+02, 4.8658273543E-01],
	[8.86500E+03, 3.2036191767E+03, 6.4323476347E+03, 1.2000475823E+02, 1.1362843402E+02, 4.8675619376E-01],
	[8.87000E+03, 3.2059082719E+03, 6.4310154548E+03, 1.2021355991E+02, 1.1381808906E+02, 4.8692962378E-01],
	[8.87500E+03, 3.2081977113E+03, 6.4296843014E+03, 1.2042260636E+02, 1.1400794168E+02, 4.8710302553E-01],
	[8.88000E+03, 3.2104874949E+03, 6.4283541730E+03, 1.2063189770E+02, 1.1419799195E+02, 4.8727639906E-01],
	[8.88500E+03, 3.2127776225E+03, 6.4270250683E+03, 1.2084143410E+02, 1.1438823993E+02, 4.8744974444E-01],
	[8.89000E+03, 3.2150680939E+03, 6.4256969859E+03, 1.2105121570E+02, 1.1457868567E+02, 4.8762306170E-01],
	[8.89500E+03, 3.2173589090E+03, 6.4243699245E+03, 1.2126124265E+02, 1.1476932922E+02, 4.8779635091E-01],
	[8.90000E+03, 3.2196500676E+03, 6.4230438826E+03, 1.2147151510E+02, 1.1496017065E+02, 4.8796961210E-01],
	[8.90500E+03, 3.2219415696E+03, 6.4217188590E+03, 1.2168203319E+02, 1.1515121002E+02, 4.8814284534E-01],
	[8.91000E+03, 3.2242334150E+03, 6.4203948522E+03, 1.2189279707E+02, 1.1534244737E+02, 4.8831605067E-01],
	[8.91500E+03, 3.2265256034E+03, 6.4190718610E+03, 1.2210380689E+02, 1.1553388276E+02, 4.8848922815E-01],
	[8.92000E+03, 3.2288181348E+03, 6.4177498840E+03, 1.2231506279E+02, 1.1572551626E+02, 4.8866237783E-01],
	[8.92500E+03, 3.2311110091E+03, 6.4164289198E+03, 1.2252656493E+02, 1.1591734792E+02, 4.8883549975E-01],
	[8.93000E+03, 3.2334042261E+03, 6.4151089671E+03, 1.2273831346E+02, 1.1610937778E+02, 4.8900859397E-01],
	[8.93500E+03, 3.2356977856E+03, 6.4137900245E+03, 1.2295030851E+02, 1.1630160592E+02, 4.8918166054E-01],
	[8.94000E+03, 3.2379916875E+03, 6.4124720908E+03, 1.2316255024E+02, 1.1649403238E+02, 4.8935469952E-01],
	[8.94500E+03, 3.2402859318E+03, 6.4111551645E+03, 1.2337503880E+02, 1.1668665722E+02, 4.8952771095E-01],
	[8.95000E+03, 3.2425805181E+03, 6.4098392444E+03, 1.2358777433E+02, 1.1687948050E+02, 4.8970069488E-01],
	[8.95500E+03, 3.2448754465E+03, 6.4085243291E+03, 1.2380075699E+02, 1.1707250227E+02, 4.8987365137E-01],
	[8.96000E+03, 3.2471707167E+03, 6.4072104173E+03, 1.2401398691E+02, 1.1726572259E+02, 4.9004658047E-01],
	[8.96500E+03, 3.2494663287E+03, 6.4058975077E+03, 1.2422746425E+02, 1.1745914150E+02, 4.9021948223E-01],
	[8.97000E+03, 3.2517622822E+03, 6.4045855989E+03, 1.2444118915E+02, 1.1765275908E+02, 4.9039235670E-01],
	[8.97500E+03, 3.2540585772E+03, 6.4032746896E+03, 1.2465516176E+02, 1.1784657537E+02, 4.9056520393E-01],
	[8.98000E+03, 3.2563552135E+03, 6.4019647786E+03, 1.2486938224E+02, 1.1804059043E+02, 4.9073802397E-01],
	[8.98500E+03, 3.2586521909E+03, 6.4006558644E+03, 1.2508385072E+02, 1.1823480430E+02, 4.9091081689E-01],
	[8.99000E+03, 3.2609495094E+03, 6.3993479458E+03, 1.2529856736E+02, 1.1842921706E+02, 4.9108358272E-01],
	[8.99500E+03, 3.2632471687E+03, 6.3980410215E+03, 1.2551353231E+02, 1.1862382875E+02, 4.9125632152E-01],
	[9.00000E+03, 3.2655451688E+03, 6.3967350901E+03, 1.2572874570E+02, 1.1881863942E+02, 4.9142903334E-01],
	[9.00500E+03, 3.2678435095E+03, 6.3954301504E+03, 1.2594581578E+02, 1.1901508510E+02, 4.9160171823E-01],
	[9.01000E+03, 3.2701421907E+03, 6.3941262010E+03, 1.2616313926E+02, 1.1921173361E+02, 4.9177437624E-01],
	[9.01500E+03, 3.2724412122E+03, 6.3928232407E+03, 1.2638071630E+02, 1.1940858502E+02, 4.9194700744E-01],
	[9.02000E+03, 3.2747405739E+03, 6.3915212681E+03, 1.2659854705E+02, 1.1960563937E+02, 4.9211961186E-01],
	[9.02500E+03, 3.2770402756E+03, 6.3902202820E+03, 1.2681663167E+02, 1.1980289674E+02, 4.9229218956E-01],
	[9.03000E+03, 3.2793403173E+03, 6.3889202811E+03, 1.2703497031E+02, 1.2000035717E+02, 4.9246474059E-01],
	[9.03500E+03, 3.2816406987E+03, 6.3876212640E+03, 1.2725356313E+02, 1.2019802072E+02, 4.9263726501E-01],
	[9.04000E+03, 3.2839414198E+03, 6.3863232295E+03, 1.2747241028E+02, 1.2039588744E+02, 4.9280976286E-01],
	[9.04500E+03, 3.2862424804E+03, 6.3850261763E+03, 1.2769151192E+02, 1.2059395741E+02, 4.9298223420E-01],
	[9.05000E+03, 3.2885438803E+03, 6.3837301031E+03, 1.2791086819E+02, 1.2079223066E+02, 4.9315467908E-01],
	[9.05500E+03, 3.2908456194E+03, 6.3824350087E+03, 1.2813047925E+02, 1.2099070726E+02, 4.9332709755E-01],
	[9.06000E+03, 3.2931476977E+03, 6.3811408917E+03, 1.2835034526E+02, 1.2118938726E+02, 4.9349948966E-01],
	[9.06500E+03, 3.2954501149E+03, 6.3798477508E+03, 1.2857046637E+02, 1.2138827072E+02, 4.9367185546E-01],
	[9.07000E+03, 3.2977528709E+03, 6.3785555849E+03, 1.2879084273E+02, 1.2158735770E+02, 4.9384419502E-01],
	[9.07500E+03, 3.3000559656E+03, 6.3772643926E+03, 1.2901147450E+02, 1.2178664824E+02, 4.9401650837E-01],
	[9.08000E+03, 3.3023593988E+03, 6.3759741727E+03, 1.2923236183E+02, 1.2198614242E+02, 4.9418879557E-01],
	[9.08500E+03, 3.3046685778E+03, 6.3747201478E+03, 1.2945350488E+02, 1.2218586060E+02, 4.9436105668E-01],
	[9.09000E+03, 3.3069793866E+03, 6.3734754362E+03, 1.2967490379E+02, 1.2238578750E+02, 4.9453329174E-01],
	[9.09500E+03, 3.3092905393E+03, 6.3722316519E+03, 1.2989655874E+02, 1.2258591833E+02, 4.9470550079E-01],
	[9.10000E+03, 3.3116020356E+03, 6.3709887937E+03, 1.3011846985E+02, 1.2278625315E+02, 4.9487768386E-01],
	[9.10500E+03, 3.3139138754E+03, 6.3697468604E+03, 1.3034063730E+02, 1.2298679202E+02, 4.9504984097E-01],
	[9.11000E+03, 3.3162260586E+03, 6.3685058508E+03, 1.3056306124E+02, 1.2318753500E+02, 4.9522197217E-01],
	[9.11500E+03, 3.3185385851E+03, 6.3672657637E+03, 1.3078574182E+02, 1.2338848213E+02, 4.9539407748E-01],
	[9.12000E+03, 3.3208514546E+03, 6.3660265980E+03, 1.3100867919E+02, 1.2358963348E+02, 4.9556615694E-01],
	[9.12500E+03, 3.3231646672E+03, 6.3647883524E+03, 1.3123187351E+02, 1.2379098910E+02, 4.9573821058E-01],
	[9.13000E+03, 3.3254782225E+03, 6.3635510258E+03, 1.3145532493E+02, 1.2399254905E+02, 4.9591023843E-01],
	[9.13500E+03, 3.3277921205E+03, 6.3623146169E+03, 1.3167903361E+02, 1.2419431337E+02, 4.9608224054E-01],
	[9.14000E+03, 3.3301063611E+03, 6.3610791247E+03, 1.3190299969E+02, 1.2439628213E+02, 4.9625421693E-01],
	[9.14500E+03, 3.3324209442E+03, 6.3598445478E+03, 1.3212722335E+02, 1.2459845537E+02, 4.9642616763E-01],
	[9.15000E+03, 3.3347358694E+03, 6.3586108852E+03, 1.3235170472E+02, 1.2480083316E+02, 4.9659809268E-01],
	[9.15500E+03, 3.3370511369E+03, 6.3573781356E+03, 1.3257644396E+02, 1.2500341555E+02, 4.9676999211E-01],
	[9.16000E+03, 3.3393667463E+03, 6.3561462979E+03, 1.3280144123E+02, 1.2520620258E+02, 4.9694186596E-01],
	[9.16500E+03, 3.3416826977E+03, 6.3549153709E+03, 1.3302669669E+02, 1.2540919433E+02, 4.9711371426E-01],
	[9.17000E+03, 3.3439989907E+03, 6.3536853535E+03, 1.3325221047E+02, 1.2561239083E+02, 4.9728553704E-01],
	[9.17500E+03, 3.3463156254E+03, 6.3524562444E+03, 1.3347798275E+02, 1.2581579214E+02, 4.9745733434E-01],
	[9.18000E+03, 3.3486326015E+03, 6.3512280425E+03, 1.3370401367E+02, 1.2601939832E+02, 4.9762910619E-01],
	[9.18500E+03, 3.3509499189E+03, 6.3500007467E+03, 1.3393030338E+02, 1.2622320943E+02, 4.9780085262E-01],
	[9.19000E+03, 3.3532675776E+03, 6.3487743558E+03, 1.3415685205E+02, 1.2642722550E+02, 4.9797257367E-01],
	[9.19500E+03, 3.3555855773E+03, 6.3475488686E+03, 1.3438365983E+02, 1.2663144660E+02, 4.9814426937E-01],
	[9.20000E+03, 3.3579039179E+03, 6.3463242839E+03, 1.3461072686E+02, 1.2683587279E+02, 4.9831593976E-01],
	[9.20500E+03, 3.3602225993E+03, 6.3451006007E+03, 1.3483805331E+02, 1.2704050410E+02, 4.9848758486E-01],
	[9.21000E+03, 3.3625416214E+03, 6.3438778177E+03, 1.3506563933E+02, 1.2724534060E+02, 4.9865920472E-01],
	[9.21500E+03, 3.3648609840E+03, 6.3426559338E+03, 1.3529348507E+02, 1.2745038234E+02, 4.9883079936E-01],
	[9.22000E+03, 3.3671806869E+03, 6.3414349479E+03, 1.3552159069E+02, 1.2765562938E+02, 4.9900236883E-01],
	[9.22500E+03, 3.3695007302E+03, 6.3402148588E+03, 1.3574995633E+02, 1.2786108175E+02, 4.9917391315E-01],
	[9.23000E+03, 3.3718211135E+03, 6.3389956654E+03, 1.3597858217E+02, 1.2806673953E+02, 4.9934543236E-01],
	[9.23500E+03, 3.3741418368E+03, 6.3377773665E+03, 1.3620746834E+02, 1.2827260275E+02, 4.9951692649E-01],
	[9.24000E+03, 3.3764628999E+03, 6.3365599610E+03, 1.3643661501E+02, 1.2847867147E+02, 4.9968839558E-01],
	[9.24500E+03, 3.3787843028E+03, 6.3353434477E+03, 1.3666602232E+02, 1.2868494575E+02, 4.9985983965E-01],
	[9.25000E+03, 3.3811060452E+03, 6.3341278256E+03, 1.3689569044E+02, 1.2889142563E+02, 5.0003125876E-01],
	[9.25500E+03, 3.3834281271E+03, 6.3329130934E+03, 1.3712561951E+02, 1.2909811117E+02, 5.0020265292E-01],
	[9.26000E+03, 3.3857505483E+03, 6.3316992501E+03, 1.3735580969E+02, 1.2930500242E+02, 5.0037402218E-01],
	[9.26500E+03, 3.3880733087E+03, 6.3304862945E+03, 1.3758626114E+02, 1.2951209943E+02, 5.0054536656E-01],
	[9.27000E+03, 3.3903964081E+03, 6.3292742254E+03, 1.3781697401E+02, 1.2971940225E+02, 5.0071668611E-01],
	[9.27500E+03, 3.3927198464E+03, 6.3280630419E+03, 1.3804794845E+02, 1.2992691093E+02, 5.0088798085E-01],
	[9.28000E+03, 3.3950436235E+03, 6.3268527427E+03, 1.3827918461E+02, 1.3013462552E+02, 5.0105925082E-01],
	[9.28500E+03, 3.3973677392E+03, 6.3256433267E+03, 1.3851068266E+02, 1.3034254608E+02, 5.0123049606E-01],
	[9.29000E+03, 3.3996921935E+03, 6.3244347928E+03, 1.3874244275E+02, 1.3055067266E+02, 5.0140171659E-01],
	[9.29500E+03, 3.4020169861E+03, 6.3232271399E+03, 1.3897446503E+02, 1.3075900531E+02, 5.0157291246E-01],
	[9.30000E+03, 3.4043421169E+03, 6.3220203668E+03, 1.3920674965E+02, 1.3096754407E+02, 5.0174408370E-01],
	[9.30500E+03, 3.4066675859E+03, 6.3208144725E+03, 1.3943929677E+02, 1.3117628900E+02, 5.0191523034E-01],
	[9.31000E+03, 3.4089933928E+03, 6.3196094559E+03, 1.3967210654E+02, 1.3138524014E+02, 5.0208635242E-01],
	[9.31500E+03, 3.4113195376E+03, 6.3184053158E+03, 1.3990517913E+02, 1.3159439756E+02, 5.0225744997E-01],
	[9.32000E+03, 3.4136460201E+03, 6.3172020511E+03, 1.4013851467E+02, 1.3180376130E+02, 5.0242852303E-01],
	[9.32500E+03, 3.4159728402E+03, 6.3159996607E+03, 1.4037211333E+02, 1.3201333140E+02, 5.0259957163E-01],
	[9.33000E+03, 3.4182999978E+03, 6.3147981435E+03, 1.4060597526E+02, 1.3222310792E+02, 5.0277059580E-01],
	[9.33500E+03, 3.4206274926E+03, 6.3135974985E+03, 1.4084010062E+02, 1.3243309092E+02, 5.0294159558E-01],
	[9.34000E+03, 3.4229553247E+03, 6.3123977245E+03, 1.4107448955E+02, 1.3264328043E+02, 5.0311257101E-01],
	[9.34500E+03, 3.4252834938E+03, 6.3111988203E+03, 1.4130914222E+02, 1.3285367650E+02, 5.0328352212E-01],
	[9.35000E+03, 3.4276119998E+03, 6.3100007850E+03, 1.4154405878E+02, 1.3306427920E+02, 5.0345444895E-01],
	[9.35500E+03, 3.4299408426E+03, 6.3088036175E+03, 1.4177923938E+02, 1.3327508856E+02, 5.0362535152E-01],
	[9.36000E+03, 3.4322700220E+03, 6.3076073165E+03, 1.4201468418E+02, 1.3348610464E+02, 5.0379622988E-01],
	[9.36500E+03, 3.4345995380E+03, 6.3064118811E+03, 1.4225039333E+02, 1.3369732748E+02, 5.0396708406E-01],
	[9.37000E+03, 3.4369293904E+03, 6.3052173102E+03, 1.4248636698E+02, 1.3390875714E+02, 5.0413791409E-01],
	[9.37500E+03, 3.4392595791E+03, 6.3040236026E+03, 1.4272260530E+02, 1.3412039365E+02, 5.0430872001E-01],
	[9.38000E+03, 3.4415901038E+03, 6.3028307573E+03, 1.4295910843E+02, 1.3433223708E+02, 5.0447950186E-01],
	[9.38500E+03, 3.4439209646E+03, 6.3016387733E+03, 1.4319587652E+02, 1.3454428747E+02, 5.0465025967E-01],
	[9.39000E+03, 3.4462521613E+03, 6.3004476493E+03, 1.4343290975E+02, 1.3475654487E+02, 5.0482099347E-01],
	[9.39500E+03, 3.4485836937E+03, 6.2992573844E+03, 1.4367020824E+02, 1.3496900932E+02, 5.0499170330E-01],
	[9.40000E+03, 3.4509155617E+03, 6.2980679775E+03, 1.4390777218E+02, 1.3518168088E+02, 5.0516238919E-01],
	[9.40500E+03, 3.4532477652E+03, 6.2968794274E+03, 1.4414560169E+02, 1.3539455959E+02, 5.0533305119E-01],
	[9.41000E+03, 3.4555803041E+03, 6.2956917332E+03, 1.4438369695E+02, 1.3560764550E+02, 5.0550368932E-01],
	[9.41500E+03, 3.4579131782E+03, 6.2945048938E+03, 1.4462205811E+02, 1.3582093865E+02, 5.0567430362E-01],
	[9.42000E+03, 3.4602463873E+03, 6.2933189080E+03, 1.4486068531E+02, 1.3603443911E+02, 5.0584489412E-01],
	[9.42500E+03, 3.4625799315E+03, 6.2921337748E+03, 1.4509957872E+02, 1.3624814690E+02, 5.0601546087E-01],
	[9.43000E+03, 3.4649138104E+03, 6.2909494932E+03, 1.4533873849E+02, 1.3646206209E+02, 5.0618600389E-01],
	[9.43500E+03, 3.4672480241E+03, 6.2897660621E+03, 1.4557816477E+02, 1.3667618471E+02, 5.0635652327E-01],
	[9.44000E+03, 3.4695825723E+03, 6.2885834804E+03, 1.4581785772E+02, 1.3689051482E+02, 5.0652701917E-01],
	[9.44500E+03, 3.4719199205E+03, 6.2874162204E+03, 1.4605781749E+02, 1.3710506319E+02, 5.0669749161E-01],
	[9.45000E+03, 3.4742618947E+03, 6.2862749552E+03, 1.4629804424E+02, 1.3731983790E+02, 5.0686794062E-01],
	[9.45500E+03, 3.4766042087E+03, 6.2851345006E+03, 1.4653853812E+02, 1.3753482040E+02, 5.0703836620E-01],
	[9.46000E+03, 3.4789468622E+03, 6.2839948557E+03, 1.4677929928E+02, 1.3775001074E+02, 5.0720876837E-01],
	[9.46500E+03, 3.4812898551E+03, 6.2828560195E+03, 1.4702032789E+02, 1.3796540895E+02, 5.0737914714E-01],
	[9.47000E+03, 3.4836331874E+03, 6.2817179910E+03, 1.4726162409E+02, 1.3818101510E+02, 5.0754950253E-01],
	[9.47500E+03, 3.4859768589E+03, 6.2805807692E+03, 1.4750318804E+02, 1.3839682921E+02, 5.0771983454E-01],
	[9.48000E+03, 3.4883208694E+03, 6.2794443530E+03, 1.4774501990E+02, 1.3861285135E+02, 5.0789014318E-01],
	[9.48500E+03, 3.4906652188E+03, 6.2783087415E+03, 1.4798711981E+02, 1.3882908156E+02, 5.0806042848E-01],
	[9.49000E+03, 3.4930099071E+03, 6.2771739337E+03, 1.4822948793E+02, 1.3904551988E+02, 5.0823069045E-01],
	[9.49500E+03, 3.4953549340E+03, 6.2760399285E+03, 1.4847212443E+02, 1.3926216637E+02, 5.0840092909E-01],
	[9.50000E+03, 3.4977002994E+03, 6.2749067251E+03, 1.4871502944E+02, 1.3947902106E+02, 5.0857114442E-01],
	[9.50500E+03, 3.5000460033E+03, 6.2737743224E+03, 1.4895820313E+02, 1.3969608400E+02, 5.0874133646E-01],
	[9.51000E+03, 3.5023920454E+03, 6.2726427194E+03, 1.4920164566E+02, 1.3991335524E+02, 5.0891150521E-01],
	[9.51500E+03, 3.5047384257E+03, 6.2715119152E+03, 1.4944535717E+02, 1.4013083482E+02, 5.0908165070E-01],
	[9.52000E+03, 3.5070851440E+03, 6.2703819087E+03, 1.4968933782E+02, 1.4034852280E+02, 5.0925177293E-01],
	[9.52500E+03, 3.5094322002E+03, 6.2692526991E+03, 1.4993358776E+02, 1.4056641921E+02, 5.0942187192E-01],
	[9.53000E+03, 3.5117795941E+03, 6.2681242852E+03, 1.5017810715E+02, 1.4078452410E+02, 5.0959194768E-01],
	[9.53500E+03, 3.5141273257E+03, 6.2669966661E+03, 1.5042289615E+02, 1.4100283752E+02, 5.0976200022E-01],
	[9.54000E+03, 3.5164753948E+03, 6.2658698409E+03, 1.5066795491E+02, 1.4122135950E+02, 5.0993202956E-01],
	[9.54500E+03, 3.5188238013E+03, 6.2647438085E+03, 1.5091328358E+02, 1.4144009011E+02, 5.1010203572E-01],
	[9.55000E+03, 3.5211725450E+03, 6.2636185681E+03, 1.5115888232E+02, 1.4165902937E+02, 5.1027201869E-01],
	[9.55500E+03, 3.5235216258E+03, 6.2624941186E+03, 1.5140475128E+02, 1.4187817734E+02, 5.1044197851E-01],
	[9.56000E+03, 3.5258710437E+03, 6.2613704590E+03, 1.5165089062E+02, 1.4209753406E+02, 5.1061191518E-01],
	[9.56500E+03, 3.5282207984E+03, 6.2602475884E+03, 1.5189730049E+02, 1.4231709957E+02, 5.1078182872E-01],
	[9.57000E+03, 3.5305708898E+03, 6.2591255059E+03, 1.5214398105E+02, 1.4253687393E+02, 5.1095171913E-01],
	[9.57500E+03, 3.5329213179E+03, 6.2580042104E+03, 1.5239093244E+02, 1.4275685716E+02, 5.1112158644E-01],
	[9.58000E+03, 3.5352720824E+03, 6.2568837010E+03, 1.5263815484E+02, 1.4297704933E+02, 5.1129143066E-01],
	[9.58500E+03, 3.5376231833E+03, 6.2557639768E+03, 1.5288564838E+02, 1.4319745046E+02, 5.1146125180E-01],
	[9.59000E+03, 3.5399746204E+03, 6.2546450367E+03, 1.5313341323E+02, 1.4341806061E+02, 5.1163104988E-01],
	[9.59500E+03, 3.5423263936E+03, 6.2535268799E+03, 1.5338144954E+02, 1.4363887981E+02, 5.1180082491E-01],
	[9.60000E+03, 3.5446785028E+03, 6.2524095053E+03, 1.5362975747E+02, 1.4385990812E+02, 5.1197057690E-01],
	[9.60500E+03, 3.5470309478E+03, 6.2512929120E+03, 1.5387833716E+02, 1.4408114557E+02, 5.1214030587E-01],
	[9.61000E+03, 3.5493837285E+03, 6.2501770991E+03, 1.5412718878E+02, 1.4430259222E+02, 5.1231001183E-01],
	[9.61500E+03, 3.5517368449E+03, 6.2490620656E+03, 1.5437631247E+02, 1.4452424809E+02, 5.1247969480E-01],
	[9.62000E+03, 3.5540902967E+03, 6.2479478105E+03, 1.5462570840E+02, 1.4474611324E+02, 5.1264935479E-01],
	[9.62500E+03, 3.5564440838E+03, 6.2468343330E+03, 1.5487537672E+02, 1.4496818770E+02, 5.1281899181E-01],
	[9.63000E+03, 3.5587982062E+03, 6.2457216320E+03, 1.5512531758E+02, 1.4519047153E+02, 5.1298860588E-01],
	[9.63500E+03, 3.5611526636E+03, 6.2446097066E+03, 1.5537553114E+02, 1.4541296476E+02, 5.1315819702E-01],
	[9.64000E+03, 3.5635074560E+03, 6.2434985559E+03, 1.5562601755E+02, 1.4563566743E+02, 5.1332776524E-01],
	[9.64500E+03, 3.5658625833E+03, 6.2423881790E+03, 1.5587677697E+02, 1.4585857959E+02, 5.1349731055E-01],
	[9.65000E+03, 3.5682180452E+03, 6.2412785748E+03, 1.5612780955E+02, 1.4608170129E+02, 5.1366683296E-01],
	[9.65500E+03, 3.5705738417E+03, 6.2401697425E+03, 1.5637911544E+02, 1.4630503255E+02, 5.1383633250E-01],
	[9.66000E+03, 3.5729299727E+03, 6.2390616812E+03, 1.5663069481E+02, 1.4652857343E+02, 5.1400580917E-01],
	[9.66500E+03, 3.5752864380E+03, 6.2379543898E+03, 1.5688254780E+02, 1.4675232396E+02, 5.1417526300E-01],
	[9.67000E+03, 3.5776432375E+03, 6.2368478675E+03, 1.5713467457E+02, 1.4697628419E+02, 5.1434469399E-01],
	[9.67500E+03, 3.5800003711E+03, 6.2357421132E+03, 1.5738707528E+02, 1.4720045416E+02, 5.1451410216E-01],
	[9.68000E+03, 3.5823578387E+03, 6.2346371262E+03, 1.5763975008E+02, 1.4742483391E+02, 5.1468348753E-01],
	[9.68500E+03, 3.5847156401E+03, 6.2335329055E+03, 1.5789269913E+02, 1.4764942349E+02, 5.1485285011E-01],
	[9.69000E+03, 3.5870737751E+03, 6.2324294501E+03, 1.5814592257E+02, 1.4787422292E+02, 5.1502218991E-01],
	[9.69500E+03, 3.5894322438E+03, 6.2313267591E+03, 1.5839942057E+02, 1.4809923227E+02, 5.1519150696E-01],
	[9.70000E+03, 3.5917910459E+03, 6.2302248315E+03, 1.5865319328E+02, 1.4832445155E+02, 5.1536080126E-01],
	[9.70500E+03, 3.5941501814E+03, 6.2291236666E+03, 1.5890724085E+02, 1.4854988082E+02, 5.1553007283E-01],
	[9.71000E+03, 3.5965096500E+03, 6.2280232633E+03, 1.5916156344E+02, 1.4877552012E+02, 5.1569932168E-01],
	[9.71500E+03, 3.5988694517E+03, 6.2269236207E+03, 1.5941616121E+02, 1.4900136949E+02, 5.1586854783E-01],
	[9.72000E+03, 3.6012295864E+03, 6.2258247380E+03, 1.5967103430E+02, 1.4922742896E+02, 5.1603775130E-01],
	[9.72500E+03, 3.6035900539E+03, 6.2247266141E+03, 1.5992618288E+02, 1.4945369858E+02, 5.1620693210E-01],
	[9.73000E+03, 3.6059508541E+03, 6.2236292483E+03, 1.6018160710E+02, 1.4968017839E+02, 5.1637609025E-01],
	[9.73500E+03, 3.6083119869E+03, 6.2225326395E+03, 1.6043730711E+02, 1.4990686843E+02, 5.1654522576E-01],
	[9.74000E+03, 3.6106734522E+03, 6.2214367868E+03, 1.6069328307E+02, 1.5013376873E+02, 5.1671433864E-01],
	[9.74500E+03, 3.6130352498E+03, 6.2203416894E+03, 1.6094953513E+02, 1.5036087934E+02, 5.1688342892E-01],
	[9.75000E+03, 3.6153973796E+03, 6.2192473464E+03, 1.6120606345E+02, 1.5058820030E+02, 5.1705249660E-01],
	[9.75500E+03, 3.6177598415E+03, 6.2181537568E+03, 1.6146286818E+02, 1.5081573165E+02, 5.1722154170E-01],
	[9.76000E+03, 3.6201226353E+03, 6.2170609197E+03, 1.6171994948E+02, 1.5104347342E+02, 5.1739056425E-01],
	[9.76500E+03, 3.6224857610E+03, 6.2159688342E+03, 1.6197730750E+02, 1.5127142566E+02, 5.1755956424E-01],
	[9.77000E+03, 3.6248492185E+03, 6.2148774995E+03, 1.6223494240E+02, 1.5149958840E+02, 5.1772854171E-01],
	[9.77500E+03, 3.6272130075E+03, 6.2137869146E+03, 1.6249285433E+02, 1.5172796169E+02, 5.1789749666E-01],
	[9.78000E+03, 3.6295771279E+03, 6.2126970787E+03, 1.6275104345E+02, 1.5195654556E+02, 5.1806642911E-01],
	[9.78500E+03, 3.6319415798E+03, 6.2116079907E+03, 1.6300950991E+02, 1.5218534004E+02, 5.1823533908E-01],
	[9.79000E+03, 3.6343063628E+03, 6.2105196499E+03, 1.6326825387E+02, 1.5241434519E+02, 5.1840422658E-01],
	[9.79500E+03, 3.6366714770E+03, 6.2094320554E+03, 1.6352727548E+02, 1.5264356104E+02, 5.1857309162E-01],
	[9.80000E+03, 3.6390369221E+03, 6.2083452062E+03, 1.6378657490E+02, 1.5287298762E+02, 5.1874193423E-01],
	[9.80500E+03, 3.6414026981E+03, 6.2072591015E+03, 1.6404615228E+02, 1.5310262497E+02, 5.1891075442E-01],
	[9.81000E+03, 3.6437688048E+03, 6.2061737403E+03, 1.6430600777E+02, 1.5333247314E+02, 5.1907955221E-01],
	[9.81500E+03, 3.6461352421E+03, 6.2050891218E+03, 1.6456614154E+02, 1.5356253216E+02, 5.1924832760E-01],
	[9.82000E+03, 3.6485022358E+03, 6.2040064269E+03, 1.6482655373E+02, 1.5379280319E+02, 5.1941708062E-01],
	[9.82500E+03, 3.6508762207E+03, 6.2029592979E+03, 1.6508724451E+02, 1.5402331849E+02, 5.1958581129E-01],
	[9.83000E+03, 3.6532505414E+03, 6.2019128782E+03, 1.6534821402E+02, 1.5425404492E+02, 5.1975451961E-01],
	[9.83500E+03, 3.6556251975E+03, 6.2008671670E+03, 1.6560946243E+02, 1.5448498254E+02, 5.1992320561E-01],
	[9.84000E+03, 3.6580001892E+03, 6.1998221635E+03, 1.6587098988E+02, 1.5471613138E+02, 5.2009186930E-01],
	[9.84500E+03, 3.6603755161E+03, 6.1987778669E+03, 1.6613279653E+02, 1.5494749148E+02, 5.2026051070E-01],
	[9.85000E+03, 3.6627511782E+03, 6.1977342762E+03, 1.6639488254E+02, 1.5517906287E+02, 5.2042912983E-01],
	[9.85500E+03, 3.6651271754E+03, 6.1966913907E+03, 1.6665724806E+02, 1.5541084559E+02, 5.2059772669E-01],
	[9.86000E+03, 3.6675035076E+03, 6.1956492096E+03, 1.6691989324E+02, 1.5564283968E+02, 5.2076630131E-01],
	[9.86500E+03, 3.6698801745E+03, 6.1946077319E+03, 1.6718281825E+02, 1.5587504518E+02, 5.2093485370E-01],
	[9.87000E+03, 3.6722571762E+03, 6.1935669569E+03, 1.6744602324E+02, 1.5610746212E+02, 5.2110338388E-01],
	[9.87500E+03, 3.6746345124E+03, 6.1925268838E+03, 1.6770950835E+02, 1.5634009054E+02, 5.2127189187E-01],
	[9.88000E+03, 3.6770121831E+03, 6.1914875117E+03, 1.6797327376E+02, 1.5657293048E+02, 5.2144037767E-01],
	[9.88500E+03, 3.6793901882E+03, 6.1904488397E+03, 1.6823731960E+02, 1.5680598197E+02, 5.2160884132E-01],
	[9.89000E+03, 3.6817685274E+03, 6.1894108671E+03, 1.6850164604E+02, 1.5703924506E+02, 5.2177728282E-01],
	[9.89500E+03, 3.6841472007E+03, 6.1883735931E+03, 1.6876625323E+02, 1.5727271977E+02, 5.2194570220E-01],
	[9.90000E+03, 3.6865262080E+03, 6.1873370167E+03, 1.6903114133E+02, 1.5750640614E+02, 5.2211409946E-01],
	[9.90500E+03, 3.6889055492E+03, 6.1863011373E+03, 1.6929631050E+02, 1.5774030421E+02, 5.2228247462E-01],
	[9.91000E+03, 3.6912852240E+03, 6.1852659539E+03, 1.6956176087E+02, 1.5797441402E+02, 5.2245082771E-01],
	[9.91500E+03, 3.6936652325E+03, 6.1842314657E+03, 1.6982749262E+02, 1.5820873560E+02, 5.2261915874E-01],
	[9.92000E+03, 3.6960455744E+03, 6.1831976720E+03, 1.7009350590E+02, 1.5844326898E+02, 5.2278746772E-01],
	[9.92500E+03, 3.6984262498E+03, 6.1821645720E+03, 1.7035980086E+02, 1.5867801421E+02, 5.2295575467E-01],
	[9.93000E+03, 3.7008072583E+03, 6.1811321647E+03, 1.7062637766E+02, 1.5891297131E+02, 5.2312401962E-01],
	[9.93500E+03, 3.7031886000E+03, 6.1801004494E+03, 1.7089323644E+02, 1.5914814033E+02, 5.2329226256E-01],
	[9.94000E+03, 3.7055702746E+03, 6.1790694253E+03, 1.7116037738E+02, 1.5938352130E+02, 5.2346048353E-01],
	[9.94500E+03, 3.7079522821E+03, 6.1780390916E+03, 1.7142780062E+02, 1.5961911424E+02, 5.2362868254E-01],
	[9.95000E+03, 3.7103346224E+03, 6.1770094474E+03, 1.7169550631E+02, 1.5985491921E+02, 5.2379685961E-01],
	[9.95500E+03, 3.7127172953E+03, 6.1759804920E+03, 1.7196349462E+02, 1.6009093623E+02, 5.2396501475E-01],
	[9.96000E+03, 3.7151003008E+03, 6.1749522245E+03, 1.7223176570E+02, 1.6032716533E+02, 5.2413314798E-01],
	[9.96500E+03, 3.7174836386E+03, 6.1739246441E+03, 1.7250031970E+02, 1.6056360656E+02, 5.2430125932E-01],
	[9.97000E+03, 3.7198673087E+03, 6.1728977501E+03, 1.7276915678E+02, 1.6080025994E+02, 5.2446934879E-01],
	[9.97500E+03, 3.7222513109E+03, 6.1718715417E+03, 1.7303827709E+02, 1.6103712551E+02, 5.2463741639E-01],
	[9.98000E+03, 3.7246356452E+03, 6.1708460179E+03, 1.7330768078E+02, 1.6127420331E+02, 5.2480546216E-01],
	[9.98500E+03, 3.7270203114E+03, 6.1698211782E+03, 1.7357736803E+02, 1.6151149337E+02, 5.2497348610E-01],
	[9.99000E+03, 3.7294053093E+03, 6.1687970215E+03, 1.7384733897E+02, 1.6174899571E+02, 5.2514148824E-01],
	[9.99500E+03, 3.7317906390E+03, 6.1677735472E+03, 1.7411759376E+02, 1.6198671039E+02, 5.2530946859E-01],
	[1.00000E+04, 3.7341763002E+03, 6.1667507544E+03, 1.7438813257E+02, 1.6222463742E+02, 5.2547742716E-01],
	[1.00050E+04, 3.7365622928E+03, 6.1657286424E+03, 1.7466007820E+02, 1.6246374820E+02, 5.2564536399E-01],
	[1.00100E+04, 3.7389486167E+03, 6.1647072103E+03, 1.7493231119E+02, 1.6270307370E+02, 5.2581327907E-01],
	[1.00150E+04, 3.7413352718E+03, 6.1636864574E+03, 1.7520483170E+02, 1.6294261395E+02, 5.2598117244E-01],
	[1.00200E+04, 3.7437222580E+03, 6.1626663829E+03, 1.7547763988E+02, 1.6318236900E+02, 5.2614904411E-01],
	[1.00250E+04, 3.7461095752E+03, 6.1616469859E+03, 1.7575073590E+02, 1.6342233888E+02, 5.2631689410E-01],
	[1.00300E+04, 3.7484972232E+03, 6.1606282658E+03, 1.7602411991E+02, 1.6366252362E+02, 5.2648472241E-01],
	[1.00350E+04, 3.7508852019E+03, 6.1596102217E+03, 1.7629779207E+02, 1.6390292326E+02, 5.2665252908E-01],
	[1.00400E+04, 3.7532735112E+03, 6.1585928527E+03, 1.7657175254E+02, 1.6414353782E+02, 5.2682031412E-01],
	[1.00450E+04, 3.7556621509E+03, 6.1575761583E+03, 1.7684600148E+02, 1.6438436735E+02, 5.2698807755E-01],
	[1.00500E+04, 3.7580511211E+03, 6.1565601375E+03, 1.7712053906E+02, 1.6462541188E+02, 5.2715581938E-01],
	[1.00550E+04, 3.7604404214E+03, 6.1555447896E+03, 1.7739536542E+02, 1.6486667143E+02, 5.2732353964E-01],
	[1.00600E+04, 3.7628300519E+03, 6.1545301137E+03, 1.7767048072E+02, 1.6510814606E+02, 5.2749123833E-01],
	[1.00650E+04, 3.7652200124E+03, 6.1535161092E+03, 1.7794588514E+02, 1.6534983578E+02, 5.2765891548E-01],
	[1.00700E+04, 3.7676103028E+03, 6.1525027753E+03, 1.7822157882E+02, 1.6559174063E+02, 5.2782657111E-01],
	[1.00750E+04, 3.7700009229E+03, 6.1514901111E+03, 1.7849756192E+02, 1.6583386065E+02, 5.2799420524E-01],
	[1.00800E+04, 3.7723918727E+03, 6.1504781159E+03, 1.7877383461E+02, 1.6607619586E+02, 5.2816181788E-01],
	[1.00850E+04, 3.7747831520E+03, 6.1494667889E+03, 1.7905039704E+02, 1.6631874631E+02, 5.2832940904E-01],
	[1.00900E+04, 3.7771747608E+03, 6.1484561293E+03, 1.7932724938E+02, 1.6656151202E+02, 5.2849697867E-01],
	[1.00950E+04, 3.7795666988E+03, 6.1474461365E+03, 1.7960439177E+02, 1.6680449303E+02, 5.2866452676E-01],
	[1.01000E+04, 3.7819589660E+03, 6.1464368095E+03, 1.7988182438E+02, 1.6704768936E+02, 5.2883205329E-01],
	[1.01050E+04, 3.7843515622E+03, 6.1454281477E+03, 1.8015954738E+02, 1.6729110106E+02, 5.2899955827E-01],
	[1.01100E+04, 3.7867444874E+03, 6.1444201503E+03, 1.8043756091E+02, 1.6753472815E+02, 5.2916704169E-01],
	[1.01150E+04, 3.7891377414E+03, 6.1434128164E+03, 1.8071586514E+02, 1.6777857067E+02, 5.2933450355E-01],
	[1.01200E+04, 3.7915313242E+03, 6.1424061454E+03, 1.8099446023E+02, 1.6802262864E+02, 5.2950194384E-01],
	[1.01250E+04, 3.7939252355E+03, 6.1414001365E+03, 1.8127334633E+02, 1.6826690210E+02, 5.2966936256E-01],
	[1.01300E+04, 3.7963194753E+03, 6.1403947889E+03, 1.8155252361E+02, 1.6851139109E+02, 5.2983675970E-01],
	[1.01350E+04, 3.7987140434E+03, 6.1393901018E+03, 1.8183199222E+02, 1.6875609562E+02, 5.3000413526E-01],
	[1.01400E+04, 3.8011089398E+03, 6.1383860746E+03, 1.8211175232E+02, 1.6900101574E+02, 5.3017148924E-01],
	[1.01450E+04, 3.8035041642E+03, 6.1373827064E+03, 1.8239180408E+02, 1.6924615148E+02, 5.3033882163E-01],
	[1.01500E+04, 3.8058997167E+03, 6.1363799964E+03, 1.8267214765E+02, 1.6949150286E+02, 5.3050613244E-01],
	[1.01550E+04, 3.8082955971E+03, 6.1353779440E+03, 1.8295278319E+02, 1.6973706992E+02, 5.3067342164E-01],
	[1.01600E+04, 3.8106918053E+03, 6.1343765483E+03, 1.8323371086E+02, 1.6998285268E+02, 5.3084068925E-01],
	[1.01650E+04, 3.8130883411E+03, 6.1333758087E+03, 1.8351493082E+02, 1.7022885119E+02, 5.3100793526E-01],
	[1.01700E+04, 3.8154852044E+03, 6.1323757243E+03, 1.8379644323E+02, 1.7047506546E+02, 5.3117515966E-01],
	[1.01750E+04, 3.8178823952E+03, 6.1313762945E+03, 1.8407824825E+02, 1.7072149553E+02, 5.3134236245E-01],
	[1.01800E+04, 3.8202799132E+03, 6.1303775184E+03, 1.8436034603E+02, 1.7096814144E+02, 5.3150954363E-01],
	[1.01850E+04, 3.8226777585E+03, 6.1293793953E+03, 1.8464273674E+02, 1.7121500320E+02, 5.3167670320E-01],
	[1.01900E+04, 3.8250759308E+03, 6.1283819245E+03, 1.8492542054E+02, 1.7146208086E+02, 5.3184384114E-01],
	[1.01950E+04, 3.8274744301E+03, 6.1273851052E+03, 1.8520839758E+02, 1.7170937443E+02, 5.3201095747E-01],
	[1.02000E+04, 3.8298732562E+03, 6.1263889367E+03, 1.8549166803E+02, 1.7195688395E+02, 5.3217805216E-01],
	[1.02050E+04, 3.8322724091E+03, 6.1253934182E+03, 1.8577523204E+02, 1.7220460946E+02, 5.3234512523E-01],
	[1.02100E+04, 3.8346718885E+03, 6.1243985490E+03, 1.8605908977E+02, 1.7245255097E+02, 5.3251217666E-01],
	[1.02150E+04, 3.8370769966E+03, 6.1234273581E+03, 1.8634324138E+02, 1.7270073758E+02, 5.3267920646E-01],
	[1.02200E+04, 3.8394847545E+03, 6.1224668631E+03, 1.8662768704E+02, 1.7294915314E+02, 5.3284621463E-01],
	[1.02250E+04, 3.8418928446E+03, 6.1215069884E+03, 1.8691242689E+02, 1.7319778501E+02, 5.3301320115E-01],
	[1.02300E+04, 3.8443012666E+03, 6.1205477334E+03, 1.8719746111E+02, 1.7344663321E+02, 5.3318016602E-01],
	[1.02350E+04, 3.8467100204E+03, 6.1195890973E+03, 1.8748278984E+02, 1.7369569778E+02, 5.3334710925E-01],
	[1.02400E+04, 3.8491191060E+03, 6.1186310794E+03, 1.8776841326E+02, 1.7394497874E+02, 5.3351403083E-01],
	[1.02450E+04, 3.8515285232E+03, 6.1176736791E+03, 1.8805433151E+02, 1.7419447613E+02, 5.3368093075E-01],
	[1.02500E+04, 3.8539382719E+03, 6.1167168956E+03, 1.8834054476E+02, 1.7444418997E+02, 5.3384780902E-01],
	[1.02550E+04, 3.8563483519E+03, 6.1157607282E+03, 1.8862705316E+02, 1.7469412029E+02, 5.3401466563E-01],
	[1.02600E+04, 3.8587587633E+03, 6.1148051763E+03, 1.8891385689E+02, 1.7494426711E+02, 5.3418150058E-01],
	[1.02650E+04, 3.8611695057E+03, 6.1138502392E+03, 1.8920095608E+02, 1.7519463048E+02, 5.3434831386E-01],
	[1.02700E+04, 3.8635805792E+03, 6.1128959160E+03, 1.8948835092E+02, 1.7544521041E+02, 5.3451510548E-01],
	[1.02750E+04, 3.8659919837E+03, 6.1119422063E+03, 1.8977604154E+02, 1.7569600694E+02, 5.3468187542E-01],
	[1.02800E+04, 3.8684037189E+03, 6.1109891092E+03, 1.9006402812E+02, 1.7594702009E+02, 5.3484862370E-01],
	[1.02850E+04, 3.8708157848E+03, 6.1100366241E+03, 1.9035231082E+02, 1.7619824990E+02, 5.3501535030E-01],
	[1.02900E+04, 3.8732281813E+03, 6.1090847502E+03, 1.9064088978E+02, 1.7644969638E+02, 5.3518205523E-01],
	[1.02950E+04, 3.8756409082E+03, 6.1081334870E+03, 1.9092976518E+02, 1.7670135957E+02, 5.3534873847E-01],
	[1.03000E+04, 3.8780539655E+03, 6.1071828337E+03, 1.9121893717E+02, 1.7695323949E+02, 5.3551540004E-01],
	[1.03050E+04, 3.8804673530E+03, 6.1062327896E+03, 1.9150840591E+02, 1.7720533617E+02, 5.3568203992E-01],
	[1.03100E+04, 3.8828810707E+03, 6.1052833540E+03, 1.9179817155E+02, 1.7745764965E+02, 5.3584865811E-01],
	[1.03150E+04, 3.8852951183E+03, 6.1043345262E+03, 1.9208823427E+02, 1.7771017994E+02, 5.3601525462E-01],
	[1.03200E+04, 3.8877094958E+03, 6.1033863057E+03, 1.9237859422E+02, 1.7796292707E+02, 5.3618182944E-01],
	[1.03250E+04, 3.8901242030E+03, 6.1024386916E+03, 1.9266925156E+02, 1.7821589107E+02, 5.3634838256E-01],
	[1.03300E+04, 3.8925392399E+03, 6.1014916833E+03, 1.9296020644E+02, 1.7846907197E+02, 5.3651491399E-01],
	[1.03350E+04, 3.8949546064E+03, 6.1005452802E+03, 1.9325145903E+02, 1.7872246980E+02, 5.3668142373E-01],
	[1.03400E+04, 3.8973703022E+03, 6.0995994814E+03, 1.9354300949E+02, 1.7897608457E+02, 5.3684791176E-01],
	[1.03450E+04, 3.8997863274E+03, 6.0986542865E+03, 1.9383485797E+02, 1.7922991632E+02, 5.3701437810E-01],
	[1.03500E+04, 3.9022026818E+03, 6.0977096946E+03, 1.9412700464E+02, 1.7948396507E+02, 5.3718082273E-01],
	[1.03550E+04, 3.9046193652E+03, 6.0967657052E+03, 1.9441944966E+02, 1.7973823086E+02, 5.3734724566E-01],
	[1.03600E+04, 3.9070363776E+03, 6.0958223175E+03, 1.9471219318E+02, 1.7999271369E+02, 5.3751364688E-01],
	[1.03650E+04, 3.9094537189E+03, 6.0948795308E+03, 1.9500523536E+02, 1.8024741361E+02, 5.3768002640E-01],
	[1.03700E+04, 3.9118713888E+03, 6.0939373446E+03, 1.9529857637E+02, 1.8050233063E+02, 5.3784638420E-01],
	[1.03750E+04, 3.9142893875E+03, 6.0929957580E+03, 1.9559221636E+02, 1.8075746478E+02, 5.3801272030E-01],
	[1.03800E+04, 3.9167077146E+03, 6.0920547705E+03, 1.9588615550E+02, 1.8101281610E+02, 5.3817903468E-01],
	[1.03850E+04, 3.9191263701E+03, 6.0911143814E+03, 1.9618039393E+02, 1.8126838459E+02, 5.3834532735E-01],
	[1.03900E+04, 3.9215453539E+03, 6.0901745900E+03, 1.9647493183E+02, 1.8152417029E+02, 5.3851159831E-01],
	[1.03950E+04, 3.9239646659E+03, 6.0892353957E+03, 1.9676976935E+02, 1.8178017322E+02, 5.3867784754E-01],
	[1.04000E+04, 3.9263843059E+03, 6.0882967977E+03, 1.9706490665E+02, 1.8203639341E+02, 5.3884407506E-01],
	[1.04050E+04, 3.9288042739E+03, 6.0873587954E+03, 1.9736034389E+02, 1.8229283088E+02, 5.3901028086E-01],
	[1.04100E+04, 3.9312245696E+03, 6.0864213882E+03, 1.9765608124E+02, 1.8254948566E+02, 5.3917646494E-01],
	[1.04150E+04, 3.9336451932E+03, 6.0854845753E+03, 1.9795211884E+02, 1.8280635777E+02, 5.3934262730E-01],
	[1.04200E+04, 3.9360661443E+03, 6.0845483562E+03, 1.9824845686E+02, 1.8306344723E+02, 5.3950876793E-01],
	[1.04250E+04, 3.9384874229E+03, 6.0836127302E+03, 1.9854509546E+02, 1.8332075407E+02, 5.3967488684E-01],
	[1.04300E+04, 3.9409090288E+03, 6.0826776965E+03, 1.9884203480E+02, 1.8357827832E+02, 5.3984098402E-01],
	[1.04350E+04, 3.9433309621E+03, 6.0817432546E+03, 1.9913927504E+02, 1.8383601999E+02, 5.4000705947E-01],
	[1.04400E+04, 3.9457532225E+03, 6.0808094038E+03, 1.9943681633E+02, 1.8409397911E+02, 5.4017311320E-01],
	[1.04450E+04, 3.9481758099E+03, 6.0798761434E+03, 1.9973465884E+02, 1.8435215571E+02, 5.4033914519E-01],
	[1.04500E+04, 3.9505987243E+03, 6.0789434728E+03, 2.0003280273E+02, 1.8461054980E+02, 5.4050515546E-01],
	[1.04550E+04, 3.9530219654E+03, 6.0780113913E+03, 2.0033124816E+02, 1.8486916141E+02, 5.4067114400E-01],
	[1.04600E+04, 3.9554455333E+03, 6.0770798983E+03, 2.0062999528E+02, 1.8512799057E+02, 5.4083711080E-01],
	[1.04650E+04, 3.9578694278E+03, 6.0761489931E+03, 2.0092904426E+02, 1.8538703729E+02, 5.4100305587E-01],
	[1.04700E+04, 3.9602936487E+03, 6.0752186750E+03, 2.0122839525E+02, 1.8564630161E+02, 5.4116897921E-01],
	[1.04750E+04, 3.9627181960E+03, 6.0742889435E+03, 2.0152804842E+02, 1.8590578353E+02, 5.4133488081E-01],
	[1.04800E+04, 3.9651430696E+03, 6.0733597978E+03, 2.0182800393E+02, 1.8616548310E+02, 5.4150076068E-01],
	[1.04850E+04, 3.9675682693E+03, 6.0724312373E+03, 2.0212826193E+02, 1.8642540031E+02, 5.4166661881E-01],
	[1.04900E+04, 3.9699937950E+03, 6.0715032614E+03, 2.0242882258E+02, 1.8668553521E+02, 5.4183245521E-01],
	[1.04950E+04, 3.9724196466E+03, 6.0705758694E+03, 2.0272968605E+02, 1.8694588781E+02, 5.4199826987E-01],
	[1.05000E+04, 3.9748458241E+03, 6.0696490607E+03, 2.0303085249E+02, 1.8720645814E+02, 5.4216406279E-01],
	[1.05050E+04, 3.9772723272E+03, 6.0687228346E+03, 2.0333232207E+02, 1.8746724621E+02, 5.4232983398E-01],
	[1.05100E+04, 3.9796991560E+03, 6.0677971905E+03, 2.0363409494E+02, 1.8772825204E+02, 5.4249558342E-01],
	[1.05150E+04, 3.9821263102E+03, 6.0668721278E+03, 2.0393617126E+02, 1.8798947567E+02, 5.4266131113E-01],
	[1.05200E+04, 3.9845537898E+03, 6.0659476457E+03, 2.0423855119E+02, 1.8825091710E+02, 5.4282701709E-01],
	[1.05250E+04, 3.9869815946E+03, 6.0650237437E+03, 2.0454123490E+02, 1.8851257637E+02, 5.4299270132E-01],
	[1.05300E+04, 3.9894097245E+03, 6.0641004212E+03, 2.0484422254E+02, 1.8877445349E+02, 5.4315836381E-01],
	[1.05350E+04, 3.9918381795E+03, 6.0631776774E+03, 2.0514751427E+02, 1.8903654849E+02, 5.4332400456E-01],
	[1.05400E+04, 3.9942669594E+03, 6.0622555117E+03, 2.0545111026E+02, 1.8929886138E+02, 5.4348962356E-01],
	[1.05450E+04, 3.9966960642E+03, 6.0613339236E+03, 2.0575501065E+02, 1.8956139218E+02, 5.4365522083E-01],
	[1.05500E+04, 3.9991254936E+03, 6.0604129124E+03, 2.0605921562E+02, 1.8982414092E+02, 5.4382079635E-01],
	[1.05550E+04, 4.0015552476E+03, 6.0594924774E+03, 2.0636372531E+02, 1.9008710762E+02, 5.4398635014E-01],
	[1.05600E+04, 4.0039853260E+03, 6.0585726180E+03, 2.0666853990E+02, 1.9035029230E+02, 5.4415188218E-01],
	[1.05650E+04, 4.0064157289E+03, 6.0576533336E+03, 2.0697365954E+02, 1.9061369497E+02, 5.4431739249E-01],
	[1.05700E+04, 4.0088464560E+03, 6.0567346235E+03, 2.0727908439E+02, 1.9087731566E+02, 5.4448288105E-01],
	[1.05750E+04, 4.0112775072E+03, 6.0558164871E+03, 2.0758481461E+02, 1.9114115438E+02, 5.4464834787E-01],
	[1.05800E+04, 4.0137088825E+03, 6.0548989238E+03, 2.0789085036E+02, 1.9140521117E+02, 5.4481379295E-01],
	[1.05850E+04, 4.0161405817E+03, 6.0539819330E+03, 2.0819719180E+02, 1.9166948603E+02, 5.4497921629E-01],
	[1.05900E+04, 4.0185726047E+03, 6.0530655140E+03, 2.0850383909E+02, 1.9193397898E+02, 5.4514461789E-01],
	[1.05950E+04, 4.0210049514E+03, 6.0521496663E+03, 2.0881079238E+02, 1.9219869005E+02, 5.4530999775E-01],
	[1.06000E+04, 4.0234376218E+03, 6.0512343891E+03, 2.0911805185E+02, 1.9246361926E+02, 5.4547535588E-01],
	[1.06050E+04, 4.0258706156E+03, 6.0503196818E+03, 2.0942561765E+02, 1.9272876662E+02, 5.4564069226E-01],
	[1.06100E+04, 4.0283039327E+03, 6.0494055439E+03, 2.0973348994E+02, 1.9299413215E+02, 5.4580600690E-01],
	[1.06150E+04, 4.0307375732E+03, 6.0484919747E+03, 2.1004166887E+02, 1.9325971587E+02, 5.4597129980E-01],
	[1.06200E+04, 4.0331736257E+03, 6.0475861790E+03, 2.1035015462E+02, 1.9352552999E+02, 5.4613657097E-01],
	[1.06250E+04, 4.0356168410E+03, 6.0467045159E+03, 2.1065894733E+02, 1.9379160237E+02, 5.4630182040E-01],
	[1.06300E+04, 4.0380603858E+03, 6.0458233960E+03, 2.1096804717E+02, 1.9405789325E+02, 5.4646704809E-01],
	[1.06350E+04, 4.0405042601E+03, 6.0449428188E+03, 2.1127745430E+02, 1.9432440264E+02, 5.4663225404E-01],
	[1.06400E+04, 4.0429484637E+03, 6.0440627837E+03, 2.1158716888E+02, 1.9459113056E+02, 5.4679743826E-01],
	[1.06450E+04, 4.0453929965E+03, 6.0431832900E+03, 2.1189719107E+02, 1.9485807703E+02, 5.4696260074E-01],
	[1.06500E+04, 4.0478378583E+03, 6.0423043372E+03, 2.1220752103E+02, 1.9512524207E+02, 5.4712774149E-01],
	[1.06550E+04, 4.0502830492E+03, 6.0414259248E+03, 2.1251815891E+02, 1.9539262570E+02, 5.4729286051E-01],
	[1.06600E+04, 4.0527285689E+03, 6.0405480521E+03, 2.1282910488E+02, 1.9566022793E+02, 5.4745795779E-01],
	[1.06650E+04, 4.0551744173E+03, 6.0396707185E+03, 2.1314035910E+02, 1.9592804878E+02, 5.4762303334E-01],
	[1.06700E+04, 4.0576205944E+03, 6.0387939234E+03, 2.1345192173E+02, 1.9619608828E+02, 5.4778808716E-01],
	[1.06750E+04, 4.0600671001E+03, 6.0379176663E+03, 2.1376379293E+02, 1.9646434643E+02, 5.4795311924E-01],
	[1.06800E+04, 4.0625139341E+03, 6.0370419466E+03, 2.1407597285E+02, 1.9673282326E+02, 5.4811812960E-01],
	[1.06850E+04, 4.0649610965E+03, 6.0361667638E+03, 2.1438846167E+02, 1.9700151878E+02, 5.4828311823E-01],
	[1.06900E+04, 4.0674085871E+03, 6.0352921171E+03, 2.1470125953E+02, 1.9727043301E+02, 5.4844808513E-01],
	[1.06950E+04, 4.0698564058E+03, 6.0344180061E+03, 2.1501436660E+02, 1.9753956597E+02, 5.4861303031E-01],
	[1.07000E+04, 4.0723045525E+03, 6.0335444302E+03, 2.1532778303E+02, 1.9780891768E+02, 5.4877795372E-01],
	[1.07050E+04, 4.0747530270E+03, 6.0326713887E+03, 2.1564150900E+02, 1.9807848814E+02, 5.4894285535E-01],
	[1.07100E+04, 4.0772018293E+03, 6.0317988812E+03, 2.1595554465E+02, 1.9834827739E+02, 5.4910773517E-01],
	[1.07150E+04, 4.0796509593E+03, 6.0309269070E+03, 2.1626989015E+02, 1.9861828543E+02, 5.4927259316E-01],
	[1.07200E+04, 4.0821004169E+03, 6.0300554656E+03, 2.1658454566E+02, 1.9888851228E+02, 5.4943742932E-01],
	[1.07250E+04, 4.0845502018E+03, 6.0291845564E+03, 2.1689951133E+02, 1.9915895796E+02, 5.4960224363E-01],
	[1.07300E+04, 4.0870003142E+03, 6.0283141788E+03, 2.1721478733E+02, 1.9942962249E+02, 5.4976703608E-01],
	[1.07350E+04, 4.0894507537E+03, 6.0274443322E+03, 2.1753037383E+02, 1.9970050587E+02, 5.4993180665E-01],
	[1.07400E+04, 4.0919015203E+03, 6.0265750161E+03, 2.1784627097E+02, 1.9997160814E+02, 5.5009655532E-01],
	[1.07450E+04, 4.0943526140E+03, 6.0257062300E+03, 2.1816247891E+02, 2.0024292929E+02, 5.5026128209E-01],
	[1.07500E+04, 4.0968040346E+03, 6.0248379731E+03, 2.1847899783E+02, 2.0051446935E+02, 5.5042598693E-01],
	[1.07550E+04, 4.0992557819E+03, 6.0239702451E+03, 2.1879582787E+02, 2.0078622834E+02, 5.5059066984E-01],
	[1.07600E+04, 4.1017078559E+03, 6.0231030452E+03, 2.1911296921E+02, 2.0105820626E+02, 5.5075533080E-01],
	[1.07650E+04, 4.1041602565E+03, 6.0222363730E+03, 2.1943042199E+02, 2.0133040314E+02, 5.5091996980E-01],
	[1.07700E+04, 4.1066129836E+03, 6.0213702278E+03, 2.1974818638E+02, 2.0160281898E+02, 5.5108458682E-01],
	[1.07750E+04, 4.1090660370E+03, 6.0205046091E+03, 2.2006626254E+02, 2.0187545381E+02, 5.5124918185E-01],
	[1.07800E+04, 4.1115194167E+03, 6.0196395164E+03, 2.2038465062E+02, 2.0214830764E+02, 5.5141375487E-01],
	[1.07850E+04, 4.1139731225E+03, 6.0187749491E+03, 2.2070335080E+02, 2.0242138048E+02, 5.5157830587E-01],
	[1.07900E+04, 4.1164271544E+03, 6.0179109065E+03, 2.2102236322E+02, 2.0269467235E+02, 5.5174283484E-01],
	[1.07950E+04, 4.1188815121E+03, 6.0170473882E+03, 2.2134168805E+02, 2.0296818326E+02, 5.5190734177E-01],
	[1.08000E+04, 4.1213361957E+03, 6.0161843936E+03, 2.2166132546E+02, 2.0324191323E+02, 5.5207182663E-01],
	[1.08050E+04, 4.1237912050E+03, 6.0153219222E+03, 2.2198127559E+02, 2.0351586226E+02, 5.5223628942E-01],
	[1.08100E+04, 4.1262465399E+03, 6.0144599733E+03, 2.2230153861E+02, 2.0379003039E+02, 5.5240073013E-01],
	[1.08150E+04, 4.1287022003E+03, 6.0135985464E+03, 2.2262211468E+02, 2.0406441760E+02, 5.5256514873E-01],
	[1.08200E+04, 4.1311581861E+03, 6.0127376410E+03, 2.2294300396E+02, 2.0433902394E+02, 5.5272954522E-01],
	[1.08250E+04, 4.1336144972E+03, 6.0118772565E+03, 2.2326420661E+02, 2.0461384939E+02, 5.5289391958E-01],
	[1.08300E+04, 4.1360711334E+03, 6.0110173923E+03, 2.2358572279E+02, 2.0488889399E+02, 5.5305827179E-01],
	[1.08350E+04, 4.1385280947E+03, 6.0101580479E+03, 2.2390755266E+02, 2.0516415773E+02, 5.5322260186E-01],
	[1.08400E+04, 4.1409853810E+03, 6.0092992228E+03, 2.2422969638E+02, 2.0543964064E+02, 5.5338690976E-01],
	[1.08450E+04, 4.1434429921E+03, 6.0084409163E+03, 2.2455215411E+02, 2.0571534273E+02, 5.5355119547E-01],
	[1.08500E+04, 4.1459009280E+03, 6.0075831280E+03, 2.2487492601E+02, 2.0599126401E+02, 5.5371545899E-01],
	[1.08550E+04, 4.1483591885E+03, 6.0067258572E+03, 2.2519801225E+02, 2.0626740449E+02, 5.5387970031E-01],
	[1.08600E+04, 4.1508177735E+03, 6.0058691035E+03, 2.2552141297E+02, 2.0654376419E+02, 5.5404391940E-01],
	[1.08650E+04, 4.1532766829E+03, 6.0050128662E+03, 2.2584512835E+02, 2.0682034311E+02, 5.5420811626E-01],
	[1.08700E+04, 4.1557359167E+03, 6.0041571449E+03, 2.2616915853E+02, 2.0709714128E+02, 5.5437229088E-01],
	[1.08750E+04, 4.1581954747E+03, 6.0033019390E+03, 2.2649350369E+02, 2.0737415870E+02, 5.5453644323E-01],
	[1.08800E+04, 4.1606553568E+03, 6.0024472479E+03, 2.2681816398E+02, 2.0765139538E+02, 5.5470057332E-01],
	[1.08850E+04, 4.1631155629E+03, 6.0015930711E+03, 2.2714313957E+02, 2.0792885134E+02, 5.5486468111E-01],
	[1.08900E+04, 4.1655760929E+03, 6.0007394080E+03, 2.2746843060E+02, 2.0820652659E+02, 5.5502876661E-01],
	[1.08950E+04, 4.1680369466E+03, 5.9998862581E+03, 2.2779403725E+02, 2.0848442113E+02, 5.5519282980E-01],
	[1.09000E+04, 4.1704981241E+03, 5.9990336209E+03, 2.2811995967E+02, 2.0876253499E+02, 5.5535687067E-01],
	[1.09050E+04, 4.1729596251E+03, 5.9981814958E+03, 2.2844619803E+02, 2.0904086816E+02, 5.5552088920E-01],
	[1.09100E+04, 4.1754214496E+03, 5.9973298823E+03, 2.2877275248E+02, 2.0931942067E+02, 5.5568488538E-01],
	[1.09150E+04, 4.1778835975E+03, 5.9964787798E+03, 2.2909962318E+02, 2.0959819253E+02, 5.5584885920E-01],
	[1.09200E+04, 4.1803460686E+03, 5.9956281878E+03, 2.2942681030E+02, 2.0987718374E+02, 5.5601281065E-01],
	[1.09250E+04, 4.1828088629E+03, 5.9947781057E+03, 2.2975431399E+02, 2.1015639431E+02, 5.5617673971E-01],
	[1.09300E+04, 4.1852719802E+03, 5.9939285331E+03, 2.3008213441E+02, 2.1043582426E+02, 5.5634064637E-01],
	[1.09350E+04, 4.1877354205E+03, 5.9930794693E+03, 2.3041027173E+02, 2.1071547360E+02, 5.5650453062E-01],
	[1.09400E+04, 4.1901991836E+03, 5.9922309139E+03, 2.3073872611E+02, 2.1099534233E+02, 5.5666839245E-01],
	[1.09450E+04, 4.1926632694E+03, 5.9913828662E+03, 2.3106749770E+02, 2.1127543047E+02, 5.5683223185E-01],
	[1.09500E+04, 4.1951276779E+03, 5.9905353258E+03, 2.3139658667E+02, 2.1155573802E+02, 5.5699604879E-01],
	[1.09550E+04, 4.1975924088E+03, 5.9896882922E+03, 2.3172599318E+02, 2.1183626500E+02, 5.5715984327E-01],
	[1.09600E+04, 4.2000574622E+03, 5.9888417647E+03, 2.3205571738E+02, 2.1211701142E+02, 5.5732361529E-01],
	[1.09650E+04, 4.2025228379E+03, 5.9879957429E+03, 2.3238575944E+02, 2.1239797728E+02, 5.5748736482E-01],
	[1.09700E+04, 4.2049885358E+03, 5.9871502262E+03, 2.3271611952E+02, 2.1267916259E+02, 5.5765109185E-01],
	[1.09750E+04, 4.2074545558E+03, 5.9863052141E+03, 2.3304679777E+02, 2.1296056737E+02, 5.5781479637E-01],
	[1.09800E+04, 4.2099208978E+03, 5.9854607061E+03, 2.3337779436E+02, 2.1324219163E+02, 5.5797847837E-01],
	[1.09850E+04, 4.2123875617E+03, 5.9846167016E+03, 2.3370910946E+02, 2.1352403536E+02, 5.5814213785E-01],
	[1.09900E+04, 4.2148545474E+03, 5.9837732002E+03, 2.3404074321E+02, 2.1380609858E+02, 5.5830577477E-01],
	[1.09950E+04, 4.2173218548E+03, 5.9829302012E+03, 2.3437269578E+02, 2.1408838131E+02, 5.5846938914E-01],
	[1.10000E+04, 4.2197894837E+03, 5.9820877041E+03, 2.3470496733E+02, 2.1437088354E+02, 5.5863298095E-01],
	[1.10050E+04, 4.2222574341E+03, 5.9812457085E+03, 2.3503755802E+02, 2.1465360529E+02, 5.5879655017E-01],
	[1.10100E+04, 4.2247257059E+03, 5.9804042138E+03, 2.3537046801E+02, 2.1493654656E+02, 5.5896009680E-01],
	[1.10150E+04, 4.2271942990E+03, 5.9795632194E+03, 2.3570369746E+02, 2.1521970736E+02, 5.5912362083E-01],
	[1.10200E+04, 4.2296632132E+03, 5.9787227249E+03, 2.3603724653E+02, 2.1550308771E+02, 5.5928712225E-01],
	[1.10250E+04, 4.2321324485E+03, 5.9778827297E+03, 2.3637111539E+02, 2.1578668760E+02, 5.5945060103E-01],
	[1.10300E+04, 4.2346020047E+03, 5.9770432333E+03, 2.3670530418E+02, 2.1607050705E+02, 5.5961405719E-01],
	[1.10350E+04, 4.2370718818E+03, 5.9762042352E+03, 2.3703981308E+02, 2.1635454606E+02, 5.5977749069E-01],
	[1.10400E+04, 4.2395420796E+03, 5.9753657349E+03, 2.3737464225E+02, 2.1663880464E+02, 5.5994090153E-01],
	[1.10450E+04, 4.2420179761E+03, 5.9745427106E+03, 2.3770979184E+02, 2.1692331661E+02, 5.6010428970E-01],
	[1.10500E+04, 4.2444991020E+03, 5.9737338238E+03, 2.3804526201E+02, 2.1720807921E+02, 5.6026765518E-01],
	[1.10550E+04, 4.2469805557E+03, 5.9729254125E+03, 2.3838105292E+02, 2.1749306169E+02, 5.6043099798E-01],
	[1.10600E+04, 4.2494623371E+03, 5.9721174760E+03, 2.3871716474E+02, 2.1777826406E+02, 5.6059431806E-01],
	[1.10650E+04, 4.2519444460E+03, 5.9713100139E+03, 2.3905359763E+02, 2.1806368633E+02, 5.6075761543E-01],
	[1.10700E+04, 4.2544268824E+03, 5.9705030257E+03, 2.3939035174E+02, 2.1834932850E+02, 5.6092089007E-01],
	[1.10750E+04, 4.2569096462E+03, 5.9696965108E+03, 2.3972742724E+02, 2.1863519058E+02, 5.6108414197E-01],
	[1.10800E+04, 4.2593927372E+03, 5.9688904689E+03, 2.4006482429E+02, 2.1892127258E+02, 5.6124737112E-01],
	[1.10850E+04, 4.2618761554E+03, 5.9680848994E+03, 2.4040254305E+02, 2.1920757450E+02, 5.6141057751E-01],
	[1.10900E+04, 4.2643599006E+03, 5.9672798018E+03, 2.4074058367E+02, 2.1949409636E+02, 5.6157376113E-01],
	[1.10950E+04, 4.2668439728E+03, 5.9664751757E+03, 2.4107894632E+02, 2.1978083815E+02, 5.6173692196E-01],
	[1.11000E+04, 4.2693283718E+03, 5.9656710205E+03, 2.4141763116E+02, 2.2006779988E+02, 5.6190006000E-01],
	[1.11050E+04, 4.2718130975E+03, 5.9648673358E+03, 2.4175663835E+02, 2.2035498157E+02, 5.6206317523E-01],
	[1.11100E+04, 4.2742981499E+03, 5.9640641210E+03, 2.4209596805E+02, 2.2064238321E+02, 5.6222626765E-01],
	[1.11150E+04, 4.2767835288E+03, 5.9632613757E+03, 2.4243562042E+02, 2.2093000482E+02, 5.6238933724E-01],
	[1.11200E+04, 4.2792692341E+03, 5.9624590995E+03, 2.4277559563E+02, 2.2121784639E+02, 5.6255238399E-01],
	[1.11250E+04, 4.2817552658E+03, 5.9616572917E+03, 2.4311589382E+02, 2.2150590794E+02, 5.6271540790E-01],
	[1.11300E+04, 4.2842416236E+03, 5.9608559520E+03, 2.4345651517E+02, 2.2179418946E+02, 5.6287840894E-01],
	[1.11350E+04, 4.2867283076E+03, 5.9600550798E+03, 2.4379745983E+02, 2.2208269098E+02, 5.6304138712E-01],
	[1.11400E+04, 4.2892153176E+03, 5.9592546747E+03, 2.4413872797E+02, 2.2237141248E+02, 5.6320434241E-01],
	[1.11450E+04, 4.2917026534E+03, 5.9584547362E+03, 2.4448031974E+02, 2.2266035397E+02, 5.6336727482E-01],
	[1.11500E+04, 4.2941903151E+03, 5.9576552638E+03, 2.4482223530E+02, 2.2294951547E+02, 5.6353018432E-01],
	[1.11550E+04, 4.2966783025E+03, 5.9568562570E+03, 2.4516447482E+02, 2.2323889697E+02, 5.6369307091E-01],
	[1.11600E+04, 4.2991666154E+03, 5.9560577154E+03, 2.4550703846E+02, 2.2352849848E+02, 5.6385593458E-01],
	[1.11650E+04, 4.3016552539E+03, 5.9552596384E+03, 2.4584992637E+02, 2.2381832001E+02, 5.6401877532E-01],
	[1.11700E+04, 4.3041442177E+03, 5.9544620256E+03, 2.4619313872E+02, 2.2410836155E+02, 5.6418159312E-01],
	[1.11750E+04, 4.3066335069E+03, 5.9536648765E+03, 2.4653667567E+02, 2.2439862311E+02, 5.6434438796E-01],
	[1.11800E+04, 4.3091231212E+03, 5.9528681907E+03, 2.4688053737E+02, 2.2468910471E+02, 5.6450715984E-01],
	[1.11850E+04, 4.3116130605E+03, 5.9520719676E+03, 2.4722682057E+02, 2.2498154258E+02, 5.6466990874E-01],
	[1.11900E+04, 4.3141033249E+03, 5.9512762068E+03, 2.4757356764E+02, 2.2527431470E+02, 5.6483263466E-01],
	[1.11950E+04, 4.3165939141E+03, 5.9504809078E+03, 2.4792064509E+02, 2.2556731038E+02, 5.6499533759E-01],
	[1.12000E+04, 4.3190848281E+03, 5.9496860701E+03, 2.4826805309E+02, 2.2586052960E+02, 5.6515801752E-01],
	[1.12050E+04, 4.3215760668E+03, 5.9488916933E+03, 2.4861579179E+02, 2.2615397238E+02, 5.6532067443E-01],
	[1.12100E+04, 4.3240676300E+03, 5.9480977769E+03, 2.4896386137E+02, 2.2644763871E+02, 5.6548330831E-01],
	[1.12150E+04, 4.3265595177E+03, 5.9473043204E+03, 2.4931226200E+02, 2.2674152861E+02, 5.6564591917E-01],
	[1.12200E+04, 4.3290517297E+03, 5.9465113233E+03, 2.4966099382E+02, 2.2703564207E+02, 5.6580850698E-01],
	[1.12250E+04, 4.3315442660E+03, 5.9457187852E+03, 2.5001005703E+02, 2.2732997911E+02, 5.6597107173E-01],
	[1.12300E+04, 4.3340371265E+03, 5.9449267056E+03, 2.5035945177E+02, 2.2762453972E+02, 5.6613361342E-01],
	[1.12350E+04, 4.3365303110E+03, 5.9441350840E+03, 2.5070917822E+02, 2.2791932391E+02, 5.6629613204E-01],
	[1.12400E+04, 4.3390238194E+03, 5.9433439200E+03, 2.5105923654E+02, 2.2821433168E+02, 5.6645862758E-01],
	[1.12450E+04, 4.3415176518E+03, 5.9425532131E+03, 2.5140962690E+02, 2.2850956303E+02, 5.6662110002E-01],
	[1.12500E+04, 4.3440118078E+03, 5.9417629629E+03, 2.5176034946E+02, 2.2880501798E+02, 5.6678354937E-01],
	[1.12550E+04, 4.3465062875E+03, 5.9409731688E+03, 2.5211140439E+02, 2.2910069652E+02, 5.6694597560E-01],
	[1.12600E+04, 4.3490010907E+03, 5.9401838304E+03, 2.5246279186E+02, 2.2939659865E+02, 5.6710837870E-01],
	[1.12650E+04, 4.3514962174E+03, 5.9393949472E+03, 2.5281451202E+02, 2.2969272438E+02, 5.6727075868E-01],
	[1.12700E+04, 4.3539916674E+03, 5.9386065188E+03, 2.5316656506E+02, 2.2998907371E+02, 5.6743311552E-01],
	[1.12750E+04, 4.3564874407E+03, 5.9378185447E+03, 2.5351895113E+02, 2.3028564664E+02, 5.6759544921E-01],
	[1.12800E+04, 4.3589835371E+03, 5.9370310244E+03, 2.5387167040E+02, 2.3058244318E+02, 5.6775775970E-01],
	[1.12850E+04, 4.3614799565E+03, 5.9362439575E+03, 2.5422472303E+02, 2.3087946333E+02, 5.6792004698E-01],
	[1.12900E+04, 4.3639766988E+03, 5.9354573435E+03, 2.5457810920E+02, 2.3117670708E+02, 5.6808231102E-01],
	[1.12950E+04, 4.3664737640E+03, 5.9346711820E+03, 2.5493182907E+02, 2.3147417445E+02, 5.6824455181E-01],
	[1.13000E+04, 4.3689711519E+03, 5.9338854725E+03, 2.5528588280E+02, 2.3177186543E+02, 5.6840676932E-01],
	[1.13050E+04, 4.3714688625E+03, 5.9331002145E+03, 2.5564027055E+02, 2.3206978003E+02, 5.6856896353E-01],
	[1.13100E+04, 4.3739668955E+03, 5.9323154076E+03, 2.5599499251E+02, 2.3236791824E+02, 5.6873113442E-01],
	[1.13150E+04, 4.3764652510E+03, 5.9315310513E+03, 2.5635004883E+02, 2.3266628007E+02, 5.6889328198E-01],
	[1.13200E+04, 4.3789639289E+03, 5.9307471452E+03, 2.5670543968E+02, 2.3296486552E+02, 5.6905540617E-01],
	[1.13250E+04, 4.3814629289E+03, 5.9299636888E+03, 2.5706116522E+02, 2.3326367459E+02, 5.6921750699E-01],
	[1.13300E+04, 4.3839622511E+03, 5.9291806816E+03, 2.5741722562E+02, 2.3356270728E+02, 5.6937958441E-01],
	[1.13350E+04, 4.3864618953E+03, 5.9283981232E+03, 2.5777362105E+02, 2.3386196360E+02, 5.6954163841E-01],
	[1.13400E+04, 4.3889618614E+03, 5.9276160131E+03, 2.5813035167E+02, 2.3416144353E+02, 5.6970366897E-01],
	[1.13450E+04, 4.3914621494E+03, 5.9268343510E+03, 2.5848741766E+02, 2.3446114709E+02, 5.6986567607E-01],
	[1.13500E+04, 4.3939627590E+03, 5.9260531362E+03, 2.5884481916E+02, 2.3476107427E+02, 5.7002765970E-01],
	[1.13550E+04, 4.3964636903E+03, 5.9252723685E+03, 2.5920255636E+02, 2.3506122508E+02, 5.7018961982E-01],
	[1.13600E+04, 4.3989649431E+03, 5.9244920472E+03, 2.5956062942E+02, 2.3536159950E+02, 5.7035155643E-01],
	[1.13650E+04, 4.4014665174E+03, 5.9237121721E+03, 2.5991903850E+02, 2.3566219756E+02, 5.7051346950E-01],
	[1.13700E+04, 4.4039684129E+03, 5.9229327425E+03, 2.6027778377E+02, 2.3596301923E+02, 5.7067535901E-01],
	[1.13750E+04, 4.4064706297E+03, 5.9221537581E+03, 2.6063686540E+02, 2.3626406453E+02, 5.7083722494E-01],
	[1.13800E+04, 4.4089731676E+03, 5.9213752185E+03, 2.6099628355E+02, 2.3656533345E+02, 5.7099906727E-01],
	[1.13850E+04, 4.4114760265E+03, 5.9205971231E+03, 2.6135603839E+02, 2.3686682599E+02, 5.7116088599E-01],
	[1.13900E+04, 4.4139792063E+03, 5.9198194715E+03, 2.6171613009E+02, 2.3716854215E+02, 5.7132268107E-01],
	[1.13950E+04, 4.4164827070E+03, 5.9190422633E+03, 2.6207655880E+02, 2.3747048193E+02, 5.7148445250E-01],
	[1.14000E+04, 4.4189865284E+03, 5.9182654981E+03, 2.6243732471E+02, 2.3777264532E+02, 5.7164620025E-01],
	[1.14050E+04, 4.4214906704E+03, 5.9174891753E+03, 2.6279842797E+02, 2.3807503234E+02, 5.7180792430E-01],
	[1.14100E+04, 4.4239951329E+03, 5.9167132945E+03, 2.6315986874E+02, 2.3837764297E+02, 5.7196962464E-01],
	[1.14150E+04, 4.4264999159E+03, 5.9159378554E+03, 2.6352164721E+02, 2.3868047721E+02, 5.7213130125E-01],
	[1.14200E+04, 4.4290050192E+03, 5.9151628574E+03, 2.6388376353E+02, 2.3898353506E+02, 5.7229295411E-01],
	[1.14250E+04, 4.4315104427E+03, 5.9143883001E+03, 2.6424621786E+02, 2.3928681653E+02, 5.7245458319E-01],
	[1.14300E+04, 4.4340161863E+03, 5.9136141830E+03, 2.6460901039E+02, 2.3959032160E+02, 5.7261618848E-01],
	[1.14350E+04, 4.4365222500E+03, 5.9128405058E+03, 2.6497214126E+02, 2.3989405028E+02, 5.7277776996E-01],
	[1.14400E+04, 4.4390286335E+03, 5.9120672679E+03, 2.6533561065E+02, 2.4019800256E+02, 5.7293932762E-01],
	[1.14450E+04, 4.4415353369E+03, 5.9112944690E+03, 2.6569941873E+02, 2.4050217844E+02, 5.7310086142E-01],
	[1.14500E+04, 4.4440423601E+03, 5.9105221085E+03, 2.6606356566E+02, 2.4080657792E+02, 5.7326237136E-01],
	[1.14550E+04, 4.4465497029E+03, 5.9097501861E+03, 2.6642805160E+02, 2.4111120100E+02, 5.7342385741E-01],
	[1.14600E+04, 4.4490573652E+03, 5.9089787014E+03, 2.6679287673E+02, 2.4141604766E+02, 5.7358531956E-01],
	[1.14650E+04, 4.4515653469E+03, 5.9082076537E+03, 2.6715804121E+02, 2.4172111792E+02, 5.7374675778E-01],
	[1.14700E+04, 4.4540736480E+03, 5.9074370429E+03, 2.6752354520E+02, 2.4202641176E+02, 5.7390817206E-01],
	[1.14750E+04, 4.4565822683E+03, 5.9066668683E+03, 2.6788938888E+02, 2.4233192919E+02, 5.7406956238E-01],
	[1.14800E+04, 4.4590912077E+03, 5.9058971296E+03, 2.6825557240E+02, 2.4263767019E+02, 5.7423092872E-01],
	[1.14850E+04, 4.4616055214E+03, 5.9051393671E+03, 2.6862209594E+02, 2.4294366929E+02, 5.7439227106E-01],
	[1.14900E+04, 4.4641267732E+03, 5.9043971244E+03, 2.6898895966E+02, 2.4324993737E+02, 5.7455358938E-01],
	[1.14950E+04, 4.4666483519E+03, 5.9036552979E+03, 2.6935616373E+02, 2.4355642936E+02, 5.7471488367E-01],
	[1.15000E+04, 4.4691702575E+03, 5.9029138870E+03, 2.6972370832E+02, 2.4386314525E+02, 5.7487615390E-01],
	[1.15050E+04, 4.4716924897E+03, 5.9021728916E+03, 2.7009159358E+02, 2.4417008504E+02, 5.7503740006E-01],
	[1.15100E+04, 4.4742150486E+03, 5.9014323110E+03, 2.7045981969E+02, 2.4447724873E+02, 5.7519862213E-01],
	[1.15150E+04, 4.4767379340E+03, 5.9006921449E+03, 2.7082838682E+02, 2.4478463631E+02, 5.7535982009E-01],
	[1.15200E+04, 4.4792611457E+03, 5.8999523930E+03, 2.7119729513E+02, 2.4509224778E+02, 5.7552099392E-01],
	[1.15250E+04, 4.4817846839E+03, 5.8992130547E+03, 2.7156654478E+02, 2.4540008314E+02, 5.7568214360E-01],
	[1.15300E+04, 4.4843085482E+03, 5.8984741297E+03, 2.7193613594E+02, 2.4570814237E+02, 5.7584326912E-01],
	[1.15350E+04, 4.4868327387E+03, 5.8977356176E+03, 2.7230606879E+02, 2.4601642549E+02, 5.7600437046E-01],
	[1.15400E+04, 4.4893572551E+03, 5.8969975179E+03, 2.7267634348E+02, 2.4632493247E+02, 5.7616544760E-01],
	[1.15450E+04, 4.4918820975E+03, 5.8962598302E+03, 2.7304696018E+02, 2.4663366333E+02, 5.7632650051E-01],
	[1.15500E+04, 4.4944072657E+03, 5.8955225542E+03, 2.7341791907E+02, 2.4694261804E+02, 5.7648752920E-01],
	[1.15550E+04, 4.4969327597E+03, 5.8947856894E+03, 2.7378922030E+02, 2.4725179662E+02, 5.7664853362E-01],
	[1.15600E+04, 4.4994585793E+03, 5.8940492355E+03, 2.7416086404E+02, 2.4756119904E+02, 5.7680951378E-01],
	[1.15650E+04, 4.5019847244E+03, 5.8933131919E+03, 2.7453285046E+02, 2.4787082532E+02, 5.7697046964E-01],
	[1.15700E+04, 4.5045111949E+03, 5.8925775584E+03, 2.7490517972E+02, 2.4818067543E+02, 5.7713140119E-01],
	[1.15750E+04, 4.5070379907E+03, 5.8918423344E+03, 2.7527785199E+02, 2.4849074938E+02, 5.7729230842E-01],
	[1.15800E+04, 4.5095651118E+03, 5.8911075197E+03, 2.7565086745E+02, 2.4880104716E+02, 5.7745319130E-01],
	[1.15850E+04, 4.5120925580E+03, 5.8903731138E+03, 2.7602422625E+02, 2.4911156877E+02, 5.7761404982E-01],
	[1.15900E+04, 4.5146203293E+03, 5.8896391162E+03, 2.7639792856E+02, 2.4942231420E+02, 5.7777488396E-01],
	[1.15950E+04, 4.5171484254E+03, 5.8889055266E+03, 2.7677197454E+02, 2.4973328343E+02, 5.7793569371E-01],
	[1.16000E+04, 4.5196768465E+03, 5.8881723447E+03, 2.7714636437E+02, 2.5004447648E+02, 5.7809647904E-01],
	[1.16050E+04, 4.5222055922E+03, 5.8874395699E+03, 2.7752109822E+02, 2.5035589332E+02, 5.7825723994E-01],
	[1.16100E+04, 4.5247346626E+03, 5.8867072018E+03, 2.7789617624E+02, 2.5066753396E+02, 5.7841797638E-01],
	[1.16150E+04, 4.5272640575E+03, 5.8859752402E+03, 2.7827159860E+02, 2.5097939838E+02, 5.7857868836E-01],
	[1.16200E+04, 4.5297937769E+03, 5.8852436845E+03, 2.7864736548E+02, 2.5129148658E+02, 5.7873937586E-01],
	[1.16250E+04, 4.5323238206E+03, 5.8845125345E+03, 2.7902347703E+02, 2.5160379855E+02, 5.7890003885E-01],
	[1.16300E+04, 4.5348541886E+03, 5.8837817896E+03, 2.7939993342E+02, 2.5191633429E+02, 5.7906067732E-01],
	[1.16350E+04, 4.5373848807E+03, 5.8830514495E+03, 2.7977673483E+02, 2.5222909379E+02, 5.7922129126E-01],
	[1.16400E+04, 4.5399158969E+03, 5.8823215137E+03, 2.8015388141E+02, 2.5254207704E+02, 5.7938188064E-01],
	[1.16450E+04, 4.5424472370E+03, 5.8815919820E+03, 2.8053137334E+02, 2.5285528403E+02, 5.7954244545E-01],
	[1.16500E+04, 4.5449789010E+03, 5.8808628538E+03, 2.8090921078E+02, 2.5316871475E+02, 5.7970298567E-01],
	[1.16550E+04, 4.5475108887E+03, 5.8801341289E+03, 2.8128739389E+02, 2.5348236920E+02, 5.7986350129E-01],
	[1.16600E+04, 4.5500432001E+03, 5.8794058067E+03, 2.8166592285E+02, 2.5379624737E+02, 5.8002399228E-01],
	[1.16650E+04, 4.5525758351E+03, 5.8786778869E+03, 2.8204479782E+02, 2.5411034925E+02, 5.8018445863E-01],
	[1.16700E+04, 4.5551087935E+03, 5.8779503692E+03, 2.8242401897E+02, 2.5442467484E+02, 5.8034490033E-01],
	[1.16750E+04, 4.5576420753E+03, 5.8772232531E+03, 2.8280358646E+02, 2.5473922411E+02, 5.8050531735E-01],
	[1.16800E+04, 4.5601756803E+03, 5.8764965381E+03, 2.8318350046E+02, 2.5505399707E+02, 5.8066570969E-01],
	[1.16850E+04, 4.5627096086E+03, 5.8757702240E+03, 2.8356376113E+02, 2.5536899371E+02, 5.8082607731E-01],
	[1.16900E+04, 4.5652438599E+03, 5.8750443104E+03, 2.8394436866E+02, 2.5568421401E+02, 5.8098642021E-01],
	[1.16950E+04, 4.5677784342E+03, 5.8743187968E+03, 2.8432532319E+02, 2.5599965798E+02, 5.8114673837E-01],
	[1.17000E+04, 4.5703133314E+03, 5.8735936828E+03, 2.8470662490E+02, 2.5631532559E+02, 5.8130703178E-01],
	[1.17050E+04, 4.5728485513E+03, 5.8728689681E+03, 2.8508827395E+02, 2.5663121683E+02, 5.8146730041E-01],
	[1.17100E+04, 4.5753840940E+03, 5.8721446523E+03, 2.8547027051E+02, 2.5694733171E+02, 5.8162754424E-01],
	[1.17150E+04, 4.5779199592E+03, 5.8714207349E+03, 2.8585261475E+02, 2.5726367021E+02, 5.8178776327E-01],
	[1.17200E+04, 4.5804561470E+03, 5.8706972157E+03, 2.8623530684E+02, 2.5758023232E+02, 5.8194795748E-01],
	[1.17250E+04, 4.5829926571E+03, 5.8699740941E+03, 2.8661834694E+02, 2.5789701803E+02, 5.8210812684E-01],
	[1.17300E+04, 4.5855294896E+03, 5.8692513699E+03, 2.8700173521E+02, 2.5821402732E+02, 5.8226827135E-01],
	[1.17350E+04, 4.5880666442E+03, 5.8685290426E+03, 2.8738547183E+02, 2.5853126020E+02, 5.8242839099E-01],
	[1.17400E+04, 4.5906041210E+03, 5.8678071118E+03, 2.8776955696E+02, 2.5884871665E+02, 5.8258848573E-01],
	[1.17450E+04, 4.5931419198E+03, 5.8670855772E+03, 2.8815399077E+02, 2.5916639665E+02, 5.8274855557E-01],
	[1.17500E+04, 4.5956800405E+03, 5.8663644384E+03, 2.8853877342E+02, 2.5948430020E+02, 5.8290860049E-01],
	[1.17550E+04, 4.5982184830E+03, 5.8656436949E+03, 2.8892390509E+02, 2.5980242729E+02, 5.8306862046E-01],
	[1.17600E+04, 4.6007572472E+03, 5.8649233464E+03, 2.8930938593E+02, 2.6012077790E+02, 5.8322861549E-01],
	[1.17650E+04, 4.6032963331E+03, 5.8642033926E+03, 2.8969521612E+02, 2.6043935202E+02, 5.8338858554E-01],
	[1.17700E+04, 4.6058357405E+03, 5.8634838329E+03, 2.9008139582E+02, 2.6075814965E+02, 5.8354853060E-01],
	[1.17750E+04, 4.6083754693E+03, 5.8627646672E+03, 2.9046792520E+02, 2.6107717077E+02, 5.8370845066E-01],
	[1.17800E+04, 4.6109155195E+03, 5.8620458949E+03, 2.9085480443E+02, 2.6139641537E+02, 5.8386834570E-01],
	[1.17850E+04, 4.6134558910E+03, 5.8613275156E+03, 2.9124203367E+02, 2.6171588344E+02, 5.8402821571E-01],
	[1.17900E+04, 4.6159965835E+03, 5.8606095291E+03, 2.9162961309E+02, 2.6203557496E+02, 5.8418806066E-01],
	[1.17950E+04, 4.6185375972E+03, 5.8598919349E+03, 2.9201754285E+02, 2.6235548993E+02, 5.8434788055E-01],
	[1.18000E+04, 4.6210789318E+03, 5.8591747326E+03, 2.9240582313E+02, 2.6267562832E+02, 5.8450767535E-01],
	[1.18050E+04, 4.6236205872E+03, 5.8584579219E+03, 2.9279445409E+02, 2.6299599014E+02, 5.8466744506E-01],
	[1.18100E+04, 4.6261625634E+03, 5.8577415024E+03, 2.9318343590E+02, 2.6331657536E+02, 5.8482718965E-01],
	[1.18150E+04, 4.6287048603E+03, 5.8570254736E+03, 2.9357276872E+02, 2.6363738398E+02, 5.8498690911E-01],
	[1.18200E+04, 4.6312474778E+03, 5.8563098353E+03, 2.9396245272E+02, 2.6395841597E+02, 5.8514660342E-01],
	[1.18250E+04, 4.6337904158E+03, 5.8555945871E+03, 2.9435248807E+02, 2.6427967134E+02, 5.8530627257E-01],
	[1.18300E+04, 4.6363336741E+03, 5.8548797284E+03, 2.9474287493E+02, 2.6460115006E+02, 5.8546591652E-01],
	[1.18350E+04, 4.6388772528E+03, 5.8541652591E+03, 2.9513361348E+02, 2.6492285211E+02, 5.8562553525E-01],
	[1.18400E+04, 4.6414211516E+03, 5.8534511787E+03, 2.9552470387E+02, 2.6524477750E+02, 5.8578512874E-01],
	[1.18450E+04, 4.6439653705E+03, 5.8527374869E+03, 2.9591614628E+02, 2.6556692620E+02, 5.8594469695E-01],
	[1.18500E+04, 4.6465099095E+03, 5.8520241832E+03, 2.9630794087E+02, 2.6588929820E+02, 5.8610423986E-01],
	[1.18550E+04, 4.6490547683E+03, 5.8513112673E+03, 2.9670008781E+02, 2.6621189349E+02, 5.8626375746E-01],
	[1.18600E+04, 4.6515999470E+03, 5.8505987388E+03, 2.9709258727E+02, 2.6653471205E+02, 5.8642324972E-01],
	[1.18650E+04, 4.6541454454E+03, 5.8498865973E+03, 2.9748543941E+02, 2.6685775386E+02, 5.8658271660E-01],
	[1.18700E+04, 4.6566912634E+03, 5.8491748425E+03, 2.9787864441E+02, 2.6718101892E+02, 5.8674215811E-01],
	[1.18750E+04, 4.6592374010E+03, 5.8484634740E+03, 2.9827220241E+02, 2.6750450721E+02, 5.8690157419E-01],
	[1.18800E+04, 4.6617838580E+03, 5.8477524915E+03, 2.9866611361E+02, 2.6782821871E+02, 5.8706096485E-01],
	[1.18850E+04, 4.6643306343E+03, 5.8470418944E+03, 2.9906037815E+02, 2.6815215342E+02, 5.8722033004E-01],
	[1.18900E+04, 4.6668777299E+03, 5.8463316826E+03, 2.9945499622E+02, 2.6847631130E+02, 5.8737966976E-01],
	[1.18950E+04, 4.6694251447E+03, 5.8456218555E+03, 2.9984996797E+02, 2.6880069236E+02, 5.8753898396E-01],
	[1.19000E+04, 4.6719728785E+03, 5.8449124129E+03, 3.0024529357E+02, 2.6912529657E+02, 5.8769827264E-01],
	[1.19050E+04, 4.6745209313E+03, 5.8442033544E+03, 3.0064097319E+02, 2.6945012392E+02, 5.8785753577E-01],
	[1.19100E+04, 4.6770693029E+03, 5.8434946796E+03, 3.0103700700E+02, 2.6977517439E+02, 5.8801677333E-01],
	[1.19150E+04, 4.6796179933E+03, 5.8427863881E+03, 3.0143339516E+02, 2.7010044797E+02, 5.8817598529E-01],
	[1.19200E+04, 4.6821670025E+03, 5.8420784795E+03, 3.0183013784E+02, 2.7042594465E+02, 5.8833517163E-01],
	[1.19250E+04, 4.6847163302E+03, 5.8413709536E+03, 3.0222723521E+02, 2.7075166439E+02, 5.8849433232E-01],
	[1.19300E+04, 4.6872659764E+03, 5.8406638099E+03, 3.0262468743E+02, 2.7107760720E+02, 5.8865346735E-01],
	[1.19350E+04, 4.6898159410E+03, 5.8399570480E+03, 3.0302249468E+02, 2.7140377305E+02, 5.8881257670E-01],
	[1.19400E+04, 4.6923662239E+03, 5.8392506677E+03, 3.0342065711E+02, 2.7173016192E+02, 5.8897166033E-01],
	[1.19450E+04, 4.6949276875E+03, 5.8385652255E+03, 3.0381917490E+02, 2.7205685492E+02, 5.8913071823E-01],
	[1.19500E+04, 4.6974917063E+03, 5.8378843677E+03, 3.0421804822E+02, 2.7238378791E+02, 5.8928975037E-01],
	[1.19550E+04, 4.7000560519E+03, 5.8372038740E+03, 3.0461727722E+02, 2.7271094427E+02, 5.8944875673E-01],
	[1.19600E+04, 4.7026207242E+03, 5.8365237442E+03, 3.0501686209E+02, 2.7303832399E+02, 5.8960773730E-01],
	[1.19650E+04, 4.7051857232E+03, 5.8358439779E+03, 3.0541680297E+02, 2.7336592705E+02, 5.8976669204E-01],
	[1.19700E+04, 4.7077510486E+03, 5.8351645747E+03, 3.0581710005E+02, 2.7369375343E+02, 5.8992562093E-01],
	[1.19750E+04, 4.7103167005E+03, 5.8344855342E+03, 3.0621775349E+02, 2.7402180311E+02, 5.9008452395E-01],
	[1.19800E+04, 4.7128826787E+03, 5.8338068562E+03, 3.0661876345E+02, 2.7435007609E+02, 5.9024340109E-01],
	[1.19850E+04, 4.7154489832E+03, 5.8331285403E+03, 3.0702013011E+02, 2.7467857233E+02, 5.9040225231E-01],
	[1.19900E+04, 4.7180156138E+03, 5.8324505862E+03, 3.0742185362E+02, 2.7500729183E+02, 5.9056107760E-01],
	[1.19950E+04, 4.7205825705E+03, 5.8317729934E+03, 3.0782393417E+02, 2.7533623457E+02, 5.9071987692E-01],
	[1.20000E+04, 4.7231498531E+03, 5.8310957617E+03, 3.0822637190E+02, 2.7566540052E+02, 5.9087865027E-01],
	[1.20050E+04, 4.7257174616E+03, 5.8304188907E+03, 3.0862916700E+02, 2.7599478968E+02, 5.9103739762E-01],
	[1.20100E+04, 4.7282853959E+03, 5.8297423801E+03, 3.0903231963E+02, 2.7632440203E+02, 5.9119611895E-01],
	[1.20150E+04, 4.7308536558E+03, 5.8290662296E+03, 3.0943582996E+02, 2.7665423754E+02, 5.9135481423E-01],
	[1.20200E+04, 4.7334222413E+03, 5.8283904387E+03, 3.0983969815E+02, 2.7698429620E+02, 5.9151348344E-01],
	[1.20250E+04, 4.7359911523E+03, 5.8277150072E+03, 3.1024392436E+02, 2.7731457799E+02, 5.9167212656E-01],
	[1.20300E+04, 4.7385603887E+03, 5.8270399346E+03, 3.1064850878E+02, 2.7764508290E+02, 5.9183074357E-01],
	[1.20350E+04, 4.7411299504E+03, 5.8263652208E+03, 3.1105345156E+02, 2.7797581090E+02, 5.9198933445E-01],
	[1.20400E+04, 4.7436998372E+03, 5.8256908653E+03, 3.1145875288E+02, 2.7830676197E+02, 5.9214789917E-01],
	[1.20450E+04, 4.7462700492E+03, 5.8250168678E+03, 3.1186441289E+02, 2.7863793611E+02, 5.9230643772E-01],
	[1.20500E+04, 4.7488405862E+03, 5.8243432279E+03, 3.1227043177E+02, 2.7896933328E+02, 5.9246495007E-01],
	[1.20550E+04, 4.7514114482E+03, 5.8236699453E+03, 3.1267680969E+02, 2.7930095347E+02, 5.9262343620E-01],
	[1.20600E+04, 4.7539826349E+03, 5.8229970198E+03, 3.1308354680E+02, 2.7963279666E+02, 5.9278189609E-01],
	[1.20650E+04, 4.7565541464E+03, 5.8223244508E+03, 3.1349064329E+02, 2.7996486283E+02, 5.9294032971E-01],
	[1.20700E+04, 4.7591259826E+03, 5.8216522382E+03, 3.1389809931E+02, 2.8029715196E+02, 5.9309873705E-01],
	[1.20750E+04, 4.7616981432E+03, 5.8209803816E+03, 3.1430591503E+02, 2.8062966404E+02, 5.9325711809E-01],
	[1.20800E+04, 4.7642706284E+03, 5.8203088805E+03, 3.1471409063E+02, 2.8096239904E+02, 5.9341547280E-01],
	[1.20850E+04, 4.7668434379E+03, 5.8196377348E+03, 3.1512262626E+02, 2.8129535694E+02, 5.9357380116E-01],
	[1.20900E+04, 4.7694165716E+03, 5.8189669440E+03, 3.1553152209E+02, 2.8162853772E+02, 5.9373210315E-01],
	[1.20950E+04, 4.7719900296E+03, 5.8182965079E+03, 3.1594077830E+02, 2.8196194137E+02, 5.9389037875E-01],
	[1.21000E+04, 4.7745638116E+03, 5.8176264260E+03, 3.1635039505E+02, 2.8229556785E+02, 5.9404862794E-01],
	[1.21050E+04, 4.7771379176E+03, 5.8169566982E+03, 3.1676037251E+02, 2.8262941716E+02, 5.9420685069E-01],
	[1.21100E+04, 4.7797123475E+03, 5.8162873239E+03, 3.1717071084E+02, 2.8296348927E+02, 5.9436504699E-01],
	[1.21150E+04, 4.7822871012E+03, 5.8156183029E+03, 3.1758141021E+02, 2.8329778416E+02, 5.9452321681E-01],
	[1.21200E+04, 4.7848621786E+03, 5.8149496349E+03, 3.1799247079E+02, 2.8363230181E+02, 5.9468136014E-01],
	[1.21250E+04, 4.7874375796E+03, 5.8142813196E+03, 3.1840389275E+02, 2.8396704219E+02, 5.9483947695E-01],
	[1.21300E+04, 4.7900133042E+03, 5.8136133565E+03, 3.1881567625E+02, 2.8430200529E+02, 5.9499756722E-01],
	[1.21350E+04, 4.7925893522E+03, 5.8129457454E+03, 3.1922782146E+02, 2.8463719109E+02, 5.9515563094E-01],
	[1.21400E+04, 4.7951657235E+03, 5.8122784859E+03, 3.1964032856E+02, 2.8497259956E+02, 5.9531366807E-01],
	[1.21450E+04, 4.7977424180E+03, 5.8116115778E+03, 3.2005319769E+02, 2.8530823069E+02, 5.9547167860E-01],
	[1.21500E+04, 4.8003194357E+03, 5.8109450206E+03, 3.2046642904E+02, 2.8564408444E+02, 5.9562966251E-01],
	[1.21550E+04, 4.8028967765E+03, 5.8102788141E+03, 3.2088002278E+02, 2.8598016081E+02, 5.9578761978E-01],
	[1.21600E+04, 4.8054744402E+03, 5.8096129579E+03, 3.2129397906E+02, 2.8631645975E+02, 5.9594555038E-01],
	[1.21650E+04, 4.8080524269E+03, 5.8089474517E+03, 3.2170829805E+02, 2.8665298127E+02, 5.9610345431E-01],
	[1.21700E+04, 4.8106307363E+03, 5.8082822951E+03, 3.2212297993E+02, 2.8698972532E+02, 5.9626133152E-01],
	[1.21750E+04, 4.8132093683E+03, 5.8076174879E+03, 3.2253802486E+02, 2.8732669190E+02, 5.9641918202E-01],
	[1.21800E+04, 4.8157883230E+03, 5.8069530297E+03, 3.2295343301E+02, 2.8766388097E+02, 5.9657700576E-01],
	[1.21850E+04, 4.8183676002E+03, 5.8062889202E+03, 3.2336920454E+02, 2.8800129251E+02, 5.9673480275E-01],
	[1.21900E+04, 4.8209471998E+03, 5.8056251590E+03, 3.2378533962E+02, 2.8833892651E+02, 5.9689257294E-01],
	[1.21950E+04, 4.8235271217E+03, 5.8049617459E+03, 3.2420183843E+02, 2.8867678293E+02, 5.9705031633E-01],
	[1.22000E+04, 4.8261073659E+03, 5.8042986805E+03, 3.2461870112E+02, 2.8901486176E+02, 5.9720803290E-01],
	[1.22050E+04, 4.8286879322E+03, 5.8036359625E+03, 3.2503592787E+02, 2.8935316296E+02, 5.9736572261E-01],
	[1.22100E+04, 4.8312688205E+03, 5.8029735915E+03, 3.2545351884E+02, 2.8969168653E+02, 5.9752338546E-01],
	[1.22150E+04, 4.8338500308E+03, 5.8023115673E+03, 3.2587147421E+02, 2.9003043243E+02, 5.9768102142E-01],
	[1.22200E+04, 4.8364315630E+03, 5.8016498895E+03, 3.2628979412E+02, 2.9036940063E+02, 5.9783863048E-01],
	[1.22250E+04, 4.8390134169E+03, 5.8009885577E+03, 3.2670847877E+02, 2.9070859113E+02, 5.9799621261E-01],
	[1.22300E+04, 4.8415955925E+03, 5.8003275718E+03, 3.2712752831E+02, 2.9104800388E+02, 5.9815376779E-01],
	[1.22350E+04, 4.8441780897E+03, 5.7996669313E+03, 3.2754694291E+02, 2.9138763887E+02, 5.9831129600E-01],
	[1.22400E+04, 4.8467609084E+03, 5.7990066359E+03, 3.2796672273E+02, 2.9172749607E+02, 5.9846879723E-01],
	[1.22450E+04, 4.8493440485E+03, 5.7983466853E+03, 3.2838686795E+02, 2.9206757547E+02, 5.9862627144E-01],
	[1.22500E+04, 4.8519275100E+03, 5.7976870792E+03, 3.2880737874E+02, 2.9240787702E+02, 5.9878371864E-01],
	[1.22550E+04, 4.8545112926E+03, 5.7970278172E+03, 3.2922825525E+02, 2.9274840071E+02, 5.9894113878E-01],
	[1.22600E+04, 4.8570953964E+03, 5.7963688991E+03, 3.2964949767E+02, 2.9308914652E+02, 5.9909853186E-01],
	[1.22650E+04, 4.8596798212E+03, 5.7957103245E+03, 3.3007110614E+02, 2.9343011441E+02, 5.9925589785E-01],
	[1.22700E+04, 4.8622645670E+03, 5.7950520931E+03, 3.3049308086E+02, 2.9377130437E+02, 5.9941323673E-01],
	[1.22750E+04, 4.8648496336E+03, 5.7943942047E+03, 3.3091542197E+02, 2.9411271636E+02, 5.9957054849E-01],
	[1.22800E+04, 4.8674350210E+03, 5.7937366587E+03, 3.3133812965E+02, 2.9445435036E+02, 5.9972783311E-01],
	[1.22850E+04, 4.8700207291E+03, 5.7930794550E+03, 3.3176120407E+02, 2.9479620635E+02, 5.9988509056E-01],
	[1.22900E+04, 4.8726067577E+03, 5.7924225933E+03, 3.3218464539E+02, 2.9513828430E+02, 6.0004232082E-01],
	[1.22950E+04, 4.8751931069E+03, 5.7917660732E+03, 3.3260845378E+02, 2.9548058418E+02, 6.0019952388E-01],
	[1.23000E+04, 4.8777797764E+03, 5.7911098943E+03, 3.3303262941E+02, 2.9582310597E+02, 6.0035669972E-01],
	[1.23050E+04, 4.8803667663E+03, 5.7904540565E+03, 3.3345717245E+02, 2.9616584964E+02, 6.0051384832E-01],
	[1.23100E+04, 4.8829540764E+03, 5.7897985593E+03, 3.3388208306E+02, 2.9650881517E+02, 6.0067096965E-01],
	[1.23150E+04, 4.8855417066E+03, 5.7891434024E+03, 3.3430736141E+02, 2.9685200252E+02, 6.0082806370E-01],
	[1.23200E+04, 4.8881296569E+03, 5.7884885856E+03, 3.3473300768E+02, 2.9719541167E+02, 6.0098513045E-01],
	[1.23250E+04, 4.8907179271E+03, 5.7878341085E+03, 3.3515902202E+02, 2.9753904260E+02, 6.0114216989E-01],
	[1.23300E+04, 4.8933065172E+03, 5.7871799709E+03, 3.3558540460E+02, 2.9788289527E+02, 6.0129918198E-01],
	[1.23350E+04, 4.8958954271E+03, 5.7865261723E+03, 3.3601215560E+02, 2.9822696966E+02, 6.0145616671E-01],
	[1.23400E+04, 4.8984846566E+03, 5.7858727125E+03, 3.3643927517E+02, 2.9857126574E+02, 6.0161312407E-01],
	[1.23450E+04, 4.9010742058E+03, 5.7852195911E+03, 3.3686676350E+02, 2.9891578349E+02, 6.0177005404E-01],
	[1.23500E+04, 4.9036640744E+03, 5.7845668080E+03, 3.3729462074E+02, 2.9926052287E+02, 6.0192695658E-01],
	[1.23550E+04, 4.9062542625E+03, 5.7839143626E+03, 3.3772284706E+02, 2.9960548386E+02, 6.0208383176E-01],
	[1.23600E+04, 4.9088447699E+03, 5.7832622548E+03, 3.3815144264E+02, 2.9995066644E+02, 6.0224067959E-01],
	[1.23650E+04, 4.9114355965E+03, 5.7826104843E+03, 3.3858040763E+02, 3.0029607056E+02, 6.0239750002E-01],
	[1.23700E+04, 4.9140267422E+03, 5.7819590506E+03, 3.3900974221E+02, 3.0064169621E+02, 6.0255429305E-01],
	[1.23750E+04, 4.9166182070E+03, 5.7813079535E+03, 3.3943944654E+02, 3.0098754335E+02, 6.0271105863E-01],
	[1.23800E+04, 4.9192099908E+03, 5.7806571928E+03, 3.3986952080E+02, 3.0133361196E+02, 6.0286779675E-01],
	[1.23850E+04, 4.9218020935E+03, 5.7800067680E+03, 3.4029996514E+02, 3.0167990201E+02, 6.0302450737E-01],
	[1.23900E+04, 4.9243945149E+03, 5.7793566789E+03, 3.4073077974E+02, 3.0202641347E+02, 6.0318119046E-01],
	[1.23950E+04, 4.9269872550E+03, 5.7787069251E+03, 3.4116196477E+02, 3.0237314630E+02, 6.0333784601E-01],
	[1.24000E+04, 4.9295803137E+03, 5.7780575064E+03, 3.4159352039E+02, 3.0272010049E+02, 6.0349447399E-01],
	[1.24050E+04, 4.9321736910E+03, 5.7774084224E+03, 3.4202544677E+02, 3.0306727600E+02, 6.0365107436E-01],
	[1.24100E+04, 4.9347673867E+03, 5.7767596729E+03, 3.4245774408E+02, 3.0341467280E+02, 6.0380764710E-01],
	[1.24150E+04, 4.9373614007E+03, 5.7761112576E+03, 3.4289041248E+02, 3.0376229086E+02, 6.0396419219E-01],
	[1.24200E+04, 4.9399641148E+03, 5.7754764017E+03, 3.4332345215E+02, 3.0411019860E+02, 6.0412070959E-01],
	[1.24250E+04, 4.9425734155E+03, 5.7748517469E+03, 3.4375686325E+02, 3.0445837900E+02, 6.0427719928E-01],
	[1.24300E+04, 4.9451830437E+03, 5.7742274110E+03, 3.4419064595E+02, 3.0480678104E+02, 6.0443366123E-01],
	[1.24350E+04, 4.9477929995E+03, 5.7736033936E+03, 3.4462480042E+02, 3.0515540468E+02, 6.0459009542E-01],
	[1.24400E+04, 4.9504032827E+03, 5.7729796945E+03, 3.4505932682E+02, 3.0550424988E+02, 6.0474650182E-01],
	[1.24450E+04, 4.9530138932E+03, 5.7723563134E+03, 3.4549422533E+02, 3.0585331662E+02, 6.0490288041E-01],
	[1.24500E+04, 4.9556248309E+03, 5.7717332499E+03, 3.4592949610E+02, 3.0620260488E+02, 6.0505923115E-01],
	[1.24550E+04, 4.9582360958E+03, 5.7711105039E+03, 3.4636513932E+02, 3.0655211461E+02, 6.0521555402E-01],
	[1.24600E+04, 4.9608476878E+03, 5.7704880749E+03, 3.4680115514E+02, 3.0690184580E+02, 6.0537184899E-01],
	[1.24650E+04, 4.9634596067E+03, 5.7698659627E+03, 3.4723754374E+02, 3.0725179841E+02, 6.0552811604E-01],
	[1.24700E+04, 4.9660718524E+03, 5.7692441671E+03, 3.4767430527E+02, 3.0760197240E+02, 6.0568435515E-01],
	[1.24750E+04, 4.9686844250E+03, 5.7686226877E+03, 3.4811143992E+02, 3.0795236775E+02, 6.0584056628E-01],
	[1.24800E+04, 4.9712973243E+03, 5.7680015242E+03, 3.4854894785E+02, 3.0830298444E+02, 6.0599674941E-01],
	[1.24850E+04, 4.9739105501E+03, 5.7673806764E+03, 3.4898682922E+02, 3.0865382242E+02, 6.0615290451E-01],
	[1.24900E+04, 4.9765241025E+03, 5.7667601440E+03, 3.4942508421E+02, 3.0900488167E+02, 6.0630903155E-01],
	[1.24950E+04, 4.9791379813E+03, 5.7661399267E+03, 3.4986371298E+02, 3.0935616215E+02, 6.0646513052E-01],
	[1.25000E+04, 4.9817521864E+03, 5.7655200242E+03, 3.5030271569E+02, 3.0970766384E+02, 6.0662120138E-01],
	[1.25050E+04, 4.9843667178E+03, 5.7649004361E+03, 3.5074417517E+02, 3.1006101423E+02, 6.0677724411E-01],
	[1.25100E+04, 4.9869815753E+03, 5.7642811623E+03, 3.5118601352E+02, 3.1041458857E+02, 6.0693325869E-01],
	[1.25150E+04, 4.9895967589E+03, 5.7636622025E+03, 3.5162823091E+02, 3.1076838683E+02, 6.0708924508E-01],
	[1.25200E+04, 4.9922122685E+03, 5.7630435563E+03, 3.5207082752E+02, 3.1112240897E+02, 6.0724520326E-01],
	[1.25250E+04, 4.9948281040E+03, 5.7624252235E+03, 3.5251380351E+02, 3.1147665497E+02, 6.0740113321E-01],
	[1.25300E+04, 4.9974442652E+03, 5.7618072038E+03, 3.5295715906E+02, 3.1183112480E+02, 6.0755703489E-01],
	[1.25350E+04, 5.0000607522E+03, 5.7611894969E+03, 3.5340089434E+02, 3.1218581841E+02, 6.0771290829E-01],
	[1.25400E+04, 5.0026775648E+03, 5.7605721025E+03, 3.5384500953E+02, 3.1254073579E+02, 6.0786875338E-01],
	[1.25450E+04, 5.0052947029E+03, 5.7599550204E+03, 3.5428950480E+02, 3.1289587690E+02, 6.0802457014E-01],
	[1.25500E+04, 5.0079121664E+03, 5.7593382502E+03, 3.5473438031E+02, 3.1325124171E+02, 6.0818035853E-01],
	[1.25550E+04, 5.0105299553E+03, 5.7587217917E+03, 3.5517963625E+02, 3.1360683018E+02, 6.0833611853E-01],
	[1.25600E+04, 5.0131480695E+03, 5.7581056446E+03, 3.5562527279E+02, 3.1396264228E+02, 6.0849185012E-01],
	[1.25650E+04, 5.0157665088E+03, 5.7574898087E+03, 3.5607129010E+02, 3.1431867799E+02, 6.0864755326E-01],
	[1.25700E+04, 5.0183852732E+03, 5.7568742835E+03, 3.5651768834E+02, 3.1467493726E+02, 6.0880322795E-01],
	[1.25750E+04, 5.0210043626E+03, 5.7562590690E+03, 3.5696446770E+02, 3.1503142007E+02, 6.0895887415E-01],
	[1.25800E+04, 5.0236237769E+03, 5.7556441646E+03, 3.5741162835E+02, 3.1538812638E+02, 6.0911449183E-01],
	[1.25850E+04, 5.0262435160E+03, 5.7550295703E+03, 3.5785917046E+02, 3.1574505616E+02, 6.0927008097E-01],
	[1.25900E+04, 5.0288635798E+03, 5.7544152857E+03, 3.5830709420E+02, 3.1610220937E+02, 6.0942564155E-01],
	[1.25950E+04, 5.0314839683E+03, 5.7538013106E+03, 3.5875539974E+02, 3.1645958599E+02, 6.0958117353E-01],
	[1.26000E+04, 5.0341046814E+03, 5.7531876446E+03, 3.5920408727E+02, 3.1681718598E+02, 6.0973667690E-01],
	[1.26050E+04, 5.0367257189E+03, 5.7525742875E+03, 3.5965315694E+02, 3.1717500930E+02, 6.0989215164E-01],
	[1.26100E+04, 5.0393470807E+03, 5.7519612390E+03, 3.6010260894E+02, 3.1753305593E+02, 6.1004759770E-01],
	[1.26150E+04, 5.0419687669E+03, 5.7513484988E+03, 3.6055244344E+02, 3.1789132582E+02, 6.1020301508E-01],
	[1.26200E+04, 5.0445907772E+03, 5.7507360666E+03, 3.6100266060E+02, 3.1824981895E+02, 6.1035840375E-01],
	[1.26250E+04, 5.0472131117E+03, 5.7501239423E+03, 3.6145326061E+02, 3.1860853528E+02, 6.1051376367E-01],
	[1.26300E+04, 5.0498357701E+03, 5.7495121254E+03, 3.6190424363E+02, 3.1896747477E+02, 6.1066909483E-01],
	[1.26350E+04, 5.0524587525E+03, 5.7489006158E+03, 3.6235560985E+02, 3.1932663739E+02, 6.1082439720E-01],
	[1.26400E+04, 5.0550820588E+03, 5.7482894131E+03, 3.6280735942E+02, 3.1968602311E+02, 6.1097967076E-01],
	[1.26450E+04, 5.0577056888E+03, 5.7476785170E+03, 3.6325949252E+02, 3.2004563189E+02, 6.1113491548E-01],
	[1.26500E+04, 5.0603296424E+03, 5.7470679274E+03, 3.6371200934E+02, 3.2040546370E+02, 6.1129013134E-01],
	[1.26550E+04, 5.0629539196E+03, 5.7464576438E+03, 3.6416491003E+02, 3.2076551850E+02, 6.1144531832E-01],
	[1.26600E+04, 5.0655785204E+03, 5.7458476661E+03, 3.6461819477E+02, 3.2112579625E+02, 6.1160047638E-01],
	[1.26650E+04, 5.0682034445E+03, 5.7452379940E+03, 3.6507186375E+02, 3.2148629693E+02, 6.1175560550E-01],
	[1.26700E+04, 5.0708286919E+03, 5.7446286272E+03, 3.6552591711E+02, 3.2184702049E+02, 6.1191070567E-01],
	[1.26750E+04, 5.0734542626E+03, 5.7440195654E+03, 3.6598035505E+02, 3.2220796690E+02, 6.1206577685E-01],
	[1.26800E+04, 5.0760801564E+03, 5.7434108084E+03, 3.6643517774E+02, 3.2256913612E+02, 6.1222081902E-01],
	[1.26850E+04, 5.0787063733E+03, 5.7428023558E+03, 3.6689038534E+02, 3.2293052812E+02, 6.1237583217E-01],
	[1.26900E+04, 5.0813329131E+03, 5.7421942074E+03, 3.6734597804E+02, 3.2329214286E+02, 6.1253081625E-01],
	[1.26950E+04, 5.0839597758E+03, 5.7415863630E+03, 3.6780195599E+02, 3.2365398030E+02, 6.1268577126E-01],
	[1.27000E+04, 5.0865869613E+03, 5.7409788222E+03, 3.6825831938E+02, 3.2401604042E+02, 6.1284069715E-01],
	[1.27050E+04, 5.0892144694E+03, 5.7403715848E+03, 3.6871506838E+02, 3.2437832316E+02, 6.1299559393E-01],
	[1.27100E+04, 5.0918423002E+03, 5.7397646506E+03, 3.6917220317E+02, 3.2474082850E+02, 6.1315046154E-01],
	[1.27150E+04, 5.0944704536E+03, 5.7391580192E+03, 3.6962972391E+02, 3.2510355640E+02, 6.1330529999E-01],
	[1.27200E+04, 5.0970989293E+03, 5.7385516903E+03, 3.7008763078E+02, 3.2546650682E+02, 6.1346010923E-01],
	[1.27250E+04, 5.0997277274E+03, 5.7379456638E+03, 3.7054592394E+02, 3.2582967972E+02, 6.1361488924E-01],
	[1.27300E+04, 5.1023568478E+03, 5.7373399393E+03, 3.7100460359E+02, 3.2619307507E+02, 6.1376964001E-01],
	[1.27350E+04, 5.1049862904E+03, 5.7367345166E+03, 3.7146366988E+02, 3.2655669283E+02, 6.1392436151E-01],
	[1.27400E+04, 5.1076160550E+03, 5.7361293954E+03, 3.7192312299E+02, 3.2692053296E+02, 6.1407905371E-01],
	[1.27450E+04, 5.1102461417E+03, 5.7355245754E+03, 3.7238296309E+02, 3.2728459542E+02, 6.1423371660E-01],
	[1.27500E+04, 5.1128765502E+03, 5.7349200564E+03, 3.7284319036E+02, 3.2764888018E+02, 6.1438835014E-01],
	[1.27550E+04, 5.1155072806E+03, 5.7343158381E+03, 3.7330380497E+02, 3.2801338719E+02, 6.1454295432E-01],
	[1.27600E+04, 5.1181383327E+03, 5.7337119202E+03, 3.7376480710E+02, 3.2837811643E+02, 6.1469752910E-01],
	[1.27650E+04, 5.1207697065E+03, 5.7331083025E+03, 3.7422619691E+02, 3.2874306784E+02, 6.1485207448E-01],
	[1.27700E+04, 5.1234014019E+03, 5.7325049847E+03, 3.7468797457E+02, 3.2910824140E+02, 6.1500659041E-01],
	[1.27750E+04, 5.1260334187E+03, 5.7319019665E+03, 3.7515014027E+02, 3.2947363705E+02, 6.1516107689E-01],
	[1.27800E+04, 5.1286657570E+03, 5.7312992477E+03, 3.7561269418E+02, 3.2983925478E+02, 6.1531553389E-01],
	[1.27850E+04, 5.1312984165E+03, 5.7306968280E+03, 3.7607563646E+02, 3.3020509453E+02, 6.1546996138E-01],
	[1.27900E+04, 5.1339313973E+03, 5.7300947071E+03, 3.7653896730E+02, 3.3057115626E+02, 6.1562435934E-01],
	[1.27950E+04, 5.1365646992E+03, 5.7294928848E+03, 3.7700268686E+02, 3.3093743994E+02, 6.1577872774E-01],
	[1.28000E+04, 5.1391983222E+03, 5.7288913607E+03, 3.7746679532E+02, 3.3130394553E+02, 6.1593306658E-01],
	[1.28050E+04, 5.1418322661E+03, 5.7282901348E+03, 3.7793129284E+02, 3.3167067299E+02, 6.1608737581E-01],
	[1.28100E+04, 5.1444665309E+03, 5.7276892066E+03, 3.7839617962E+02, 3.3203762227E+02, 6.1624165542E-01],
	[1.28150E+04, 5.1471011165E+03, 5.7270885759E+03, 3.7886145581E+02, 3.3240479335E+02, 6.1639590539E-01],
	[1.28200E+04, 5.1497360228E+03, 5.7264882424E+03, 3.7932712159E+02, 3.3277218617E+02, 6.1655012570E-01],
	[1.28250E+04, 5.1523712497E+03, 5.7258882060E+03, 3.7979317713E+02, 3.3313980070E+02, 6.1670431631E-01],
	[1.28300E+04, 5.1550067971E+03, 5.7252884662E+03, 3.8025962261E+02, 3.3350763689E+02, 6.1685847721E-01],
	[1.28350E+04, 5.1576426650E+03, 5.7246890230E+03, 3.8072645820E+02, 3.3387569472E+02, 6.1701260837E-01],
	[1.28400E+04, 5.1602788533E+03, 5.7240898759E+03, 3.8119368408E+02, 3.3424397413E+02, 6.1716670978E-01],
	[1.28450E+04, 5.1629153618E+03, 5.7234910248E+03, 3.8166130041E+02, 3.3461247508E+02, 6.1732078140E-01],
	[1.28500E+04, 5.1655521905E+03, 5.7228924693E+03, 3.8212930737E+02, 3.3498119754E+02, 6.1747482322E-01],
	[1.28550E+04, 5.1681893393E+03, 5.7222942093E+03, 3.8259770513E+02, 3.3535014146E+02, 6.1762883522E-01],
	[1.28600E+04, 5.1708268082E+03, 5.7216962444E+03, 3.8306649387E+02, 3.3571930681E+02, 6.1778281736E-01],
	[1.28650E+04, 5.1734645970E+03, 5.7210985744E+03, 3.8353567376E+02, 3.3608869353E+02, 6.1793676964E-01],
	[1.28700E+04, 5.1761027056E+03, 5.7205011990E+03, 3.8400524497E+02, 3.3645830160E+02, 6.1809069202E-01],
	[1.28750E+04, 5.1787411340E+03, 5.7199041180E+03, 3.8447520768E+02, 3.3682813096E+02, 6.1824458449E-01],
	[1.28800E+04, 5.1813798820E+03, 5.7193073312E+03, 3.8494556206E+02, 3.3719818158E+02, 6.1839844701E-01],
	[1.28850E+04, 5.1840189497E+03, 5.7187108382E+03, 3.8541630828E+02, 3.3756845341E+02, 6.1855227958E-01],
	[1.28900E+04, 5.1866583368E+03, 5.7181146387E+03, 3.8588744652E+02, 3.3793894642E+02, 6.1870608217E-01],
	[1.28950E+04, 5.1892980434E+03, 5.7175187327E+03, 3.8635897695E+02, 3.3830966055E+02, 6.1885985474E-01],
	[1.29000E+04, 5.1919380693E+03, 5.7169231197E+03, 3.8683089974E+02, 3.3868059577E+02, 6.1901359730E-01],
	[1.29050E+04, 5.1945784145E+03, 5.7163277995E+03, 3.8730321506E+02, 3.3905175203E+02, 6.1916730980E-01],
	[1.29100E+04, 5.1972190788E+03, 5.7157327719E+03, 3.8777592310E+02, 3.3942312930E+02, 6.1932099223E-01],
	[1.29150E+04, 5.1998687680E+03, 5.7151493398E+03, 3.8824902401E+02, 3.3979480465E+02, 6.1947464457E-01],
	[1.29200E+04, 5.2025269641E+03, 5.7145768100E+03, 3.8872251799E+02, 3.4016677380E+02, 6.1962826680E-01],
	[1.29250E+04, 5.2051854897E+03, 5.7140045591E+03, 3.8919640519E+02, 3.4053896436E+02, 6.1978185888E-01],
	[1.29300E+04, 5.2078443448E+03, 5.7134325868E+03, 3.8967068580E+02, 3.4091137630E+02, 6.1993542081E-01],
	[1.29350E+04, 5.2105035294E+03, 5.7128608929E+03, 3.9014535998E+02, 3.4128400956E+02, 6.2008895256E-01],
	[1.29400E+04, 5.2131630432E+03, 5.7122894771E+03, 3.9062042791E+02, 3.4165686411E+02, 6.2024245410E-01],
	[1.29450E+04, 5.2158228863E+03, 5.7117183391E+03, 3.9109588976E+02, 3.4202993990E+02, 6.2039592542E-01],
	[1.29500E+04, 5.2184830585E+03, 5.7111474788E+03, 3.9157174572E+02, 3.4240323689E+02, 6.2054936650E-01],
	[1.29550E+04, 5.2211435598E+03, 5.7105768959E+03, 3.9204799594E+02, 3.4277675503E+02, 6.2070277730E-01],
	[1.29600E+04, 5.2238043900E+03, 5.7100065901E+03, 3.9252464060E+02, 3.4315049430E+02, 6.2085615782E-01],
	[1.29650E+04, 5.2264655492E+03, 5.7094365612E+03, 3.9300167988E+02, 3.4352445463E+02, 6.2100950803E-01],
	[1.29700E+04, 5.2291270371E+03, 5.7088668090E+03, 3.9347911395E+02, 3.4389863599E+02, 6.2116282790E-01],
	[1.29750E+04, 5.2317888538E+03, 5.7082973332E+03, 3.9395694299E+02, 3.4427303833E+02, 6.2131611742E-01],
	[1.29800E+04, 5.2344509991E+03, 5.7077281336E+03, 3.9443516716E+02, 3.4464766161E+02, 6.2146937657E-01],
	[1.29850E+04, 5.2371134729E+03, 5.7071592099E+03, 3.9491378665E+02, 3.4502250579E+02, 6.2162260532E-01],
	[1.29900E+04, 5.2397762752E+03, 5.7065905620E+03, 3.9539280161E+02, 3.4539757082E+02, 6.2177580365E-01],
	[1.29950E+04, 5.2424394058E+03, 5.7060221895E+03, 3.9587221224E+02, 3.4577285665E+02, 6.2192897154E-01],
	[1.30000E+04, 5.2451028648E+03, 5.7054540922E+03, 3.9635201869E+02, 3.4614836326E+02, 6.2208210897E-01],
	[1.30050E+04, 5.2477666519E+03, 5.7048862699E+03, 3.9683222115E+02, 3.4652409057E+02, 6.2223521592E-01],
	[1.30100E+04, 5.2504307672E+03, 5.7043187224E+03, 3.9731281979E+02, 3.4690003857E+02, 6.2238829237E-01],
	[1.30150E+04, 5.2530952104E+03, 5.7037514493E+03, 3.9779381478E+02, 3.4727620719E+02, 6.2254133830E-01],
	[1.30200E+04, 5.2557599816E+03, 5.7031844506E+03, 3.9827520630E+02, 3.4765259640E+02, 6.2269435368E-01],
	[1.30250E+04, 5.2584250807E+03, 5.7026177258E+03, 3.9875699451E+02, 3.4802920615E+02, 6.2284733849E-01],
	[1.30300E+04, 5.2610905076E+03, 5.7020512749E+03, 3.9923917960E+02, 3.4840603639E+02, 6.2300029271E-01],
	[1.30350E+04, 5.2637562621E+03, 5.7014850975E+03, 3.9972176173E+02, 3.4878308708E+02, 6.2315321633E-01],
	[1.30400E+04, 5.2664223442E+03, 5.7009191934E+03, 4.0020474109E+02, 3.4916035818E+02, 6.2330610932E-01],
	[1.30450E+04, 5.2690887539E+03, 5.7003535625E+03, 4.0068811783E+02, 3.4953784963E+02, 6.2345897166E-01],
	[1.30500E+04, 5.2717554909E+03, 5.6997882043E+03, 4.0117189214E+02, 3.4991556139E+02, 6.2361180333E-01],
	[1.30550E+04, 5.2744225553E+03, 5.6992231188E+03, 4.0165606419E+02, 3.5029349343E+02, 6.2376460431E-01],
	[1.30600E+04, 5.2770899470E+03, 5.6986583056E+03, 4.0214063416E+02, 3.5067164568E+02, 6.2391737458E-01],
	[1.30650E+04, 5.2797576659E+03, 5.6980937646E+03, 4.0262560221E+02, 3.5105001810E+02, 6.2407011412E-01],
	[1.30700E+04, 5.2824257118E+03, 5.6975294955E+03, 4.0311096853E+02, 3.5142861065E+02, 6.2422282290E-01],
	[1.30750E+04, 5.2850940847E+03, 5.6969654981E+03, 4.0359673328E+02, 3.5180742329E+02, 6.2437550091E-01],
	[1.30800E+04, 5.2877627846E+03, 5.6964017721E+03, 4.0408289663E+02, 3.5218645595E+02, 6.2452814813E-01],
	[1.30850E+04, 5.2904318113E+03, 5.6958383173E+03, 4.0456945877E+02, 3.5256570861E+02, 6.2468076453E-01],
	[1.30900E+04, 5.2931011647E+03, 5.6952751334E+03, 4.0505641987E+02, 3.5294518121E+02, 6.2483335009E-01],
	[1.30950E+04, 5.2957708448E+03, 5.6947122203E+03, 4.0554378009E+02, 3.5332487369E+02, 6.2498590480E-01],
	[1.31000E+04, 5.2984408515E+03, 5.6941495777E+03, 4.0603153962E+02, 3.5370478603E+02, 6.2513842864E-01],
	[1.31050E+04, 5.3011111846E+03, 5.6935872054E+03, 4.0651969862E+02, 3.5408491816E+02, 6.2529092158E-01],
	[1.31100E+04, 5.3037818442E+03, 5.6930251031E+03, 4.0700825727E+02, 3.5446527005E+02, 6.2544338360E-01],
	[1.31150E+04, 5.3064528301E+03, 5.6924632706E+03, 4.0749721575E+02, 3.5484584164E+02, 6.2559581469E-01],
	[1.31200E+04, 5.3091241423E+03, 5.6919017076E+03, 4.0798657422E+02, 3.5522663288E+02, 6.2574821482E-01],
	[1.31250E+04, 5.3117957806E+03, 5.6913404140E+03, 4.0847633287E+02, 3.5560764373E+02, 6.2590058398E-01],
	[1.31300E+04, 5.3144677449E+03, 5.6907793895E+03, 4.0896649186E+02, 3.5598887414E+02, 6.2605292213E-01],
	[1.31350E+04, 5.3171400353E+03, 5.6902186339E+03, 4.0945705137E+02, 3.5637032407E+02, 6.2620522927E-01],
	[1.31400E+04, 5.3198126515E+03, 5.6896581469E+03, 4.0994801158E+02, 3.5675199345E+02, 6.2635750538E-01],
	[1.31450E+04, 5.3224855936E+03, 5.6890979284E+03, 4.1043937265E+02, 3.5713388225E+02, 6.2650975043E-01],
	[1.31500E+04, 5.3251588614E+03, 5.6885379780E+03, 4.1093113475E+02, 3.5751599042E+02, 6.2666196440E-01],
	[1.31550E+04, 5.3278324549E+03, 5.6879782955E+03, 4.1142329808E+02, 3.5789831790E+02, 6.2681414727E-01],
	[1.31600E+04, 5.3305063739E+03, 5.6874188808E+03, 4.1191586279E+02, 3.5828086465E+02, 6.2696629903E-01],
	[1.31650E+04, 5.3331806184E+03, 5.6868597336E+03, 4.1240882906E+02, 3.5866363061E+02, 6.2711841965E-01],
	[1.31700E+04, 5.3358551883E+03, 5.6863008536E+03, 4.1290219707E+02, 3.5904661575E+02, 6.2727050912E-01],
	[1.31750E+04, 5.3385300835E+03, 5.6857422407E+03, 4.1339596698E+02, 3.5942982001E+02, 6.2742256741E-01],
	[1.31800E+04, 5.3412053040E+03, 5.6851838945E+03, 4.1389013898E+02, 3.5981324334E+02, 6.2757459451E-01],
	[1.31850E+04, 5.3438808496E+03, 5.6846258150E+03, 4.1438471324E+02, 3.6019688568E+02, 6.2772659039E-01],
	[1.31900E+04, 5.3465567202E+03, 5.6840680018E+03, 4.1487968993E+02, 3.6058074700E+02, 6.2787855504E-01],
	[1.31950E+04, 5.3492329159E+03, 5.6835104547E+03, 4.1537506922E+02, 3.6096482724E+02, 6.2803048843E-01],
	[1.32000E+04, 5.3519094364E+03, 5.6829531735E+03, 4.1587085128E+02, 3.6134912635E+02, 6.2818239055E-01],
	[1.32050E+04, 5.3545862817E+03, 5.6823961579E+03, 4.1636703630E+02, 3.6173364428E+02, 6.2833426138E-01],
	[1.32100E+04, 5.3572634518E+03, 5.6818394078E+03, 4.1686362445E+02, 3.6211838098E+02, 6.2848610090E-01],
	[1.32150E+04, 5.3599409465E+03, 5.6812829229E+03, 4.1736061590E+02, 3.6250333639E+02, 6.2863790908E-01],
	[1.32200E+04, 5.3626187658E+03, 5.6807267030E+03, 4.1785801082E+02, 3.6288851048E+02, 6.2878968592E-01],
	[1.32250E+04, 5.3652969095E+03, 5.6801707479E+03, 4.1835580938E+02, 3.6327390318E+02, 6.2894143138E-01],
	[1.32300E+04, 5.3679753776E+03, 5.6796150572E+03, 4.1885401177E+02, 3.6365951445E+02, 6.2909314546E-01],
	[1.32350E+04, 5.3706541701E+03, 5.6790596309E+03, 4.1935261815E+02, 3.6404534424E+02, 6.2924482813E-01],
	[1.32400E+04, 5.3733332868E+03, 5.6785044687E+03, 4.1985162871E+02, 3.6443139249E+02, 6.2939647937E-01],
	[1.32450E+04, 5.3760127276E+03, 5.6779495703E+03, 4.2035104360E+02, 3.6481765915E+02, 6.2954809916E-01],
	[1.32500E+04, 5.3786924925E+03, 5.6773949355E+03, 4.2085086301E+02, 3.6520414417E+02, 6.2969968749E-01],
	[1.32550E+04, 5.3813725813E+03, 5.6768405641E+03, 4.2135108712E+02, 3.6559084750E+02, 6.2985124434E-01],
	[1.32600E+04, 5.3840529941E+03, 5.6762864560E+03, 4.2185171608E+02, 3.6597776908E+02, 6.3000276968E-01],
	[1.32650E+04, 5.3867337306E+03, 5.6757326107E+03, 4.2235275009E+02, 3.6636490887E+02, 6.3015426350E-01],
	[1.32700E+04, 5.3894147909E+03, 5.6751790283E+03, 4.2285418931E+02, 3.6675226682E+02, 6.3030572578E-01],
	[1.32750E+04, 5.3920961748E+03, 5.6746257083E+03, 4.2335603392E+02, 3.6713984286E+02, 6.3045715650E-01],
	[1.32800E+04, 5.3947778823E+03, 5.6740726506E+03, 4.2385828408E+02, 3.6752763696E+02, 6.3060855564E-01],
	[1.32850E+04, 5.3974599133E+03, 5.6735198549E+03, 4.2436093998E+02, 3.6791564904E+02, 6.3075992318E-01],
	[1.32900E+04, 5.4001422677E+03, 5.6729673211E+03, 4.2486400179E+02, 3.6830387907E+02, 6.3091125911E-01],
	[1.32950E+04, 5.4028249454E+03, 5.6724150490E+03, 4.2536746969E+02, 3.6869232699E+02, 6.3106256340E-01],
	[1.33000E+04, 5.4055079463E+03, 5.6718630382E+03, 4.2587134384E+02, 3.6908099275E+02, 6.3121383604E-01],
	[1.33050E+04, 5.4081912703E+03, 5.6713112886E+03, 4.2637562441E+02, 3.6946987629E+02, 6.3136507700E-01],
	[1.33100E+04, 5.4108749175E+03, 5.6707597999E+03, 4.2688031160E+02, 3.6985897756E+02, 6.3151628628E-01],
	[1.33150E+04, 5.4135588876E+03, 5.6702085720E+03, 4.2738540556E+02, 3.7024829650E+02, 6.3166746385E-01],
	[1.33200E+04, 5.4162431806E+03, 5.6696576045E+03, 4.2789090648E+02, 3.7063783307E+02, 6.3181860969E-01],
	[1.33250E+04, 5.4189277964E+03, 5.6691068974E+03, 4.2839681452E+02, 3.7102758720E+02, 6.3196972378E-01],
	[1.33300E+04, 5.4216127350E+03, 5.6685564503E+03, 4.2890312986E+02, 3.7141755886E+02, 6.3212080611E-01],
	[1.33350E+04, 5.4242979962E+03, 5.6680062631E+03, 4.2940985268E+02, 3.7180774797E+02, 6.3227185666E-01],
	[1.33400E+04, 5.4269835800E+03, 5.6674563355E+03, 4.2991698315E+02, 3.7219815449E+02, 6.3242287541E-01],
	[1.33450E+04, 5.4296694863E+03, 5.6669066673E+03, 4.3042452144E+02, 3.7258877836E+02, 6.3257386230E-01],
	[1.33500E+04, 5.4323557150E+03, 5.6663572583E+03, 4.3093246773E+02, 3.7297961952E+02, 6.3272481729E-01],
	[1.33550E+04, 5.4350422660E+03, 5.6658081083E+03, 4.3144082218E+02, 3.7337067794E+02, 6.3287574037E-01],
	[1.33600E+04, 5.4377291393E+03, 5.6652592170E+03, 4.3194958499E+02, 3.7376195354E+02, 6.3302663150E-01],
	[1.33650E+04, 5.4404163347E+03, 5.6647105842E+03, 4.3245875631E+02, 3.7415344627E+02, 6.3317749066E-01],
	[1.33700E+04, 5.4431038522E+03, 5.6641622098E+03, 4.3296833633E+02, 3.7454515608E+02, 6.3332831783E-01],
	[1.33750E+04, 5.4457916917E+03, 5.6636140934E+03, 4.3347832521E+02, 3.7493708291E+02, 6.3347911297E-01],
	[1.33800E+04, 5.4484798532E+03, 5.6630662349E+03, 4.3398872314E+02, 3.7532922671E+02, 6.3362987607E-01],
	[1.33850E+04, 5.4511683364E+03, 5.6625186341E+03, 4.3449953028E+02, 3.7572158743E+02, 6.3378060710E-01],
	[1.33900E+04, 5.4538571414E+03, 5.6619712908E+03, 4.3501074681E+02, 3.7611416500E+02, 6.3393130603E-01],
	[1.33950E+04, 5.4565462681E+03, 5.6614242046E+03, 4.3552237291E+02, 3.7650695937E+02, 6.3408197284E-01],
	[1.34000E+04, 5.4592357164E+03, 5.6608773755E+03, 4.3603440874E+02, 3.7689997048E+02, 6.3423260750E-01],
	[1.34050E+04, 5.4619254861E+03, 5.6603308031E+03, 4.3654685449E+02, 3.7729319828E+02, 6.3438320999E-01],
	[1.34100E+04, 5.4646155774E+03, 5.6597844873E+03, 4.3705971033E+02, 3.7768664272E+02, 6.3453378029E-01],
	[1.34150E+04, 5.4673059899E+03, 5.6592384279E+03, 4.3757297642E+02, 3.7808030373E+02, 6.3468431836E-01],
	[1.34200E+04, 5.4699967237E+03, 5.6586926246E+03, 4.3808665295E+02, 3.7847418126E+02, 6.3483482419E-01],
	[1.34250E+04, 5.4726877787E+03, 5.6581470773E+03, 4.3860074009E+02, 3.7886827525E+02, 6.3498529775E-01],
	[1.34300E+04, 5.4753890329E+03, 5.6576124249E+03, 4.3911523802E+02, 3.7926268085E+02, 6.3513573902E-01],
	[1.34350E+04, 5.4781001982E+03, 5.6570883384E+03, 4.3963014690E+02, 3.7965739563E+02, 6.3528614796E-01],
	[1.34400E+04, 5.4808116964E+03, 5.6565644954E+03, 4.4014546691E+02, 3.8005232733E+02, 6.3543652456E-01],
	[1.34450E+04, 5.4835235274E+03, 5.6560408958E+03, 4.4066119823E+02, 3.8044747591E+02, 6.3558686879E-01],
	[1.34500E+04, 5.4862356911E+03, 5.6555175393E+03, 4.4117734103E+02, 3.8084284130E+02, 6.3573718062E-01],
	[1.34550E+04, 5.4889481874E+03, 5.6549944257E+03, 4.4169389549E+02, 3.8123842345E+02, 6.3588746004E-01],
	[1.34600E+04, 5.4916610163E+03, 5.6544715548E+03, 4.4221086177E+02, 3.8163422231E+02, 6.3603770702E-01],
	[1.34650E+04, 5.4943741777E+03, 5.6539489265E+03, 4.4272824006E+02, 3.8203023781E+02, 6.3618792153E-01],
	[1.34700E+04, 5.4970876715E+03, 5.6534265404E+03, 4.4324603053E+02, 3.8242646991E+02, 6.3633810355E-01],
	[1.34750E+04, 5.4998014976E+03, 5.6529043965E+03, 4.4376423335E+02, 3.8282291854E+02, 6.3648825305E-01],
	[1.34800E+04, 5.5025156559E+03, 5.6523824944E+03, 4.4428284869E+02, 3.8321958364E+02, 6.3663837001E-01],
	[1.34850E+04, 5.5052301464E+03, 5.6518608341E+03, 4.4480187674E+02, 3.8361646517E+02, 6.3678845441E-01],
	[1.34900E+04, 5.5079449689E+03, 5.6513394153E+03, 4.4532131766E+02, 3.8401356305E+02, 6.3693850623E-01],
	[1.34950E+04, 5.5106601234E+03, 5.6508182377E+03, 4.4584117162E+02, 3.8441087725E+02, 6.3708852543E-01],
	[1.35000E+04, 5.5133756098E+03, 5.6502973013E+03, 4.4636143882E+02, 3.8480840768E+02, 6.3723851199E-01],
	[1.35050E+04, 5.5160914281E+03, 5.6497766058E+03, 4.4688211941E+02, 3.8520615431E+02, 6.3738846590E-01],
	[1.35100E+04, 5.5188075780E+03, 5.6492561510E+03, 4.4740321357E+02, 3.8560411707E+02, 6.3753838712E-01],
	[1.35150E+04, 5.5215240596E+03, 5.6487359367E+03, 4.4792472148E+02, 3.8600229590E+02, 6.3768827563E-01],
	[1.35200E+04, 5.5242408728E+03, 5.6482159626E+03, 4.4844664331E+02, 3.8640069074E+02, 6.3783813142E-01],
	[1.35250E+04, 5.5269580175E+03, 5.6476962287E+03, 4.4896897924E+02, 3.8679930155E+02, 6.3798795444E-01],
	[1.35300E+04, 5.5296754936E+03, 5.6471767347E+03, 4.4949172943E+02, 3.8719812825E+02, 6.3813774469E-01],
	[1.35350E+04, 5.5323933010E+03, 5.6466574804E+03, 4.5001489407E+02, 3.8759717079E+02, 6.3828750214E-01],
	[1.35400E+04, 5.5351114396E+03, 5.6461384656E+03, 4.5053847333E+02, 3.8799642911E+02, 6.3843722676E-01],
	[1.35450E+04, 5.5378299094E+03, 5.6456196901E+03, 4.5106246738E+02, 3.8839590315E+02, 6.3858691853E-01],
	[1.35500E+04, 5.5405487103E+03, 5.6451011537E+03, 4.5158687640E+02, 3.8879559285E+02, 6.3873657743E-01],
	[1.35550E+04, 5.5432678422E+03, 5.6445828562E+03, 4.5211170056E+02, 3.8919549816E+02, 6.3888620344E-01],
	[1.35600E+04, 5.5459873050E+03, 5.6440647974E+03, 4.5263694004E+02, 3.8959561901E+02, 6.3903579652E-01],
	[1.35650E+04, 5.5487070986E+03, 5.6435469771E+03, 4.5316259501E+02, 3.8999595534E+02, 6.3918535666E-01],
	[1.35700E+04, 5.5514272230E+03, 5.6430293951E+03, 4.5368866564E+02, 3.9039650710E+02, 6.3933488383E-01],
	[1.35750E+04, 5.5541476780E+03, 5.6425120513E+03, 4.5421515212E+02, 3.9079727423E+02, 6.3948437802E-01],
	[1.35800E+04, 5.5568684636E+03, 5.6419949453E+03, 4.5474205460E+02, 3.9119825666E+02, 6.3963383919E-01],
	[1.35850E+04, 5.5595895798E+03, 5.6414780771E+03, 4.5526937328E+02, 3.9159945434E+02, 6.3978326732E-01],
	[1.35900E+04, 5.5623110263E+03, 5.6409614464E+03, 4.5579710832E+02, 3.9200086720E+02, 6.3993266240E-01],
	[1.35950E+04, 5.5650328032E+03, 5.6404450531E+03, 4.5632525989E+02, 3.9240249518E+02, 6.4008202439E-01],
	[1.36000E+04, 5.5677549104E+03, 5.6399288968E+03, 4.5685382818E+02, 3.9280433823E+02, 6.4023135328E-01],
	[1.36050E+04, 5.5704773477E+03, 5.6394129776E+03, 4.5738281336E+02, 3.9320639628E+02, 6.4038064904E-01],
	[1.36100E+04, 5.5732001152E+03, 5.6388972950E+03, 4.5791221559E+02, 3.9360866928E+02, 6.4052991165E-01],
	[1.36150E+04, 5.5759232126E+03, 5.6383818490E+03, 4.5844203506E+02, 3.9401115716E+02, 6.4067914109E-01],
	[1.36200E+04, 5.5786466400E+03, 5.6378666393E+03, 4.5897227194E+02, 3.9441385985E+02, 6.4082833733E-01],
	[1.36250E+04, 5.5813703973E+03, 5.6373516658E+03, 4.5950292641E+02, 3.9481677731E+02, 6.4097750035E-01],
	[1.36300E+04, 5.5840944843E+03, 5.6368369283E+03, 4.6003399864E+02, 3.9521990947E+02, 6.4112663013E-01],
	[1.36350E+04, 5.5868189010E+03, 5.6363224265E+03, 4.6056548880E+02, 3.9562325626E+02, 6.4127572664E-01],
	[1.36400E+04, 5.5895436473E+03, 5.6358081603E+03, 4.6109739706E+02, 3.9602681763E+02, 6.4142478986E-01],
	[1.36450E+04, 5.5922687232E+03, 5.6352941295E+03, 4.6162972361E+02, 3.9643059351E+02, 6.4157381978E-01],
	[1.36500E+04, 5.5949941285E+03, 5.6347803338E+03, 4.6216246862E+02, 3.9683458384E+02, 6.4172281636E-01],
	[1.36550E+04, 5.5977198632E+03, 5.6342667731E+03, 4.6269563226E+02, 3.9723878856E+02, 6.4187177959E-01],
	[1.36600E+04, 5.6004459271E+03, 5.6337534473E+03, 4.6322921471E+02, 3.9764320761E+02, 6.4202070944E-01],
	[1.36650E+04, 5.6031723203E+03, 5.6332403560E+03, 4.6376321614E+02, 3.9804784093E+02, 6.4216960589E-01],
	[1.36700E+04, 5.6058990426E+03, 5.6327274991E+03, 4.6429763672E+02, 3.9845268844E+02, 6.4231846892E-01],
	[1.36750E+04, 5.6086260940E+03, 5.6322148765E+03, 4.6483247663E+02, 3.9885775010E+02, 6.4246729851E-01],
	[1.36800E+04, 5.6113534743E+03, 5.6317024879E+03, 4.6536773605E+02, 3.9926302584E+02, 6.4261609463E-01],
	[1.36850E+04, 5.6140811835E+03, 5.6311903331E+03, 4.6590341515E+02, 3.9966851558E+02, 6.4276485726E-01],
	[1.36900E+04, 5.6168092215E+03, 5.6306784119E+03, 4.6643951411E+02, 4.0007421929E+02, 6.4291358638E-01],
	[1.36950E+04, 5.6195375882E+03, 5.6301667242E+03, 4.6697643819E+02, 4.0048043482E+02, 6.4306228196E-01],
	[1.37000E+04, 5.6222662835E+03, 5.6296552698E+03, 4.6751444485E+02, 4.0088735105E+02, 6.4321094399E-01],
	[1.37050E+04, 5.6249953075E+03, 5.6291440484E+03, 4.6805287394E+02, 4.0129448212E+02, 6.4335957245E-01],
	[1.37100E+04, 5.6277246599E+03, 5.6286330599E+03, 4.6859172562E+02, 4.0170182796E+02, 6.4350816731E-01],
	[1.37150E+04, 5.6304543407E+03, 5.6281223041E+03, 4.6913100008E+02, 4.0210938851E+02, 6.4365672854E-01],
	[1.37200E+04, 5.6331843498E+03, 5.6276117807E+03, 4.6967069749E+02, 4.0251716371E+02, 6.4380525613E-01],
	[1.37250E+04, 5.6359146872E+03, 5.6271014897E+03, 4.7021081803E+02, 4.0292515350E+02, 6.4395375006E-01],
	[1.37300E+04, 5.6386453527E+03, 5.6265914308E+03, 4.7075136188E+02, 4.0333335780E+02, 6.4410221030E-01],
	[1.37350E+04, 5.6413763464E+03, 5.6260816038E+03, 4.7129232920E+02, 4.0374177655E+02, 6.4425063684E-01],
	[1.37400E+04, 5.6441076680E+03, 5.6255720085E+03, 4.7183372019E+02, 4.0415040969E+02, 6.4439902965E-01],
	[1.37450E+04, 5.6468393175E+03, 5.6250626448E+03, 4.7237553501E+02, 4.0455925716E+02, 6.4454738870E-01],
	[1.37500E+04, 5.6495712949E+03, 5.6245535124E+03, 4.7291777384E+02, 4.0496831889E+02, 6.4469571398E-01],
	[1.37550E+04, 5.6523036000E+03, 5.6240446112E+03, 4.7346043685E+02, 4.0537759482E+02, 6.4484400547E-01],
	[1.37600E+04, 5.6550362329E+03, 5.6235359409E+03, 4.7400352424E+02, 4.0578708487E+02, 6.4499226314E-01],
	[1.37650E+04, 5.6577691933E+03, 5.6230275015E+03, 4.7454703616E+02, 4.0619678899E+02, 6.4514048698E-01],
	[1.37700E+04, 5.6605024813E+03, 5.6225192926E+03, 4.7509097280E+02, 4.0660670711E+02, 6.4528867696E-01],
	[1.37750E+04, 5.6632360967E+03, 5.6220113141E+03, 4.7563533433E+02, 4.0701683916E+02, 6.4543683306E-01],
	[1.37800E+04, 5.6659700394E+03, 5.6215035659E+03, 4.7618012093E+02, 4.0742718508E+02, 6.4558495525E-01],
	[1.37850E+04, 5.6687043095E+03, 5.6209960477E+03, 4.7672533279E+02, 4.0783774480E+02, 6.4573304353E-01],
	[1.37900E+04, 5.6714389067E+03, 5.6204887594E+03, 4.7727097006E+02, 4.0824851826E+02, 6.4588109786E-01],
	[1.37950E+04, 5.6741738311E+03, 5.6199817007E+03, 4.7781703293E+02, 4.0865950539E+02, 6.4602911823E-01],
	[1.38000E+04, 5.6769090825E+03, 5.6194748714E+03, 4.7836352158E+02, 4.0907070613E+02, 6.4617710461E-01],
	[1.38050E+04, 5.6796446609E+03, 5.6189682715E+03, 4.7891043619E+02, 4.0948212040E+02, 6.4632505699E-01],
	[1.38100E+04, 5.6823805661E+03, 5.6184619006E+03, 4.7945777692E+02, 4.0989374815E+02, 6.4647297534E-01],
	[1.38150E+04, 5.6851167982E+03, 5.6179557587E+03, 4.8000554396E+02, 4.1030558930E+02, 6.4662085964E-01],
	[1.38200E+04, 5.6878533570E+03, 5.6174498455E+03, 4.8055373749E+02, 4.1071764379E+02, 6.4676870987E-01],
	[1.38250E+04, 5.6905902425E+03, 5.6169441608E+03, 4.8110235767E+02, 4.1112991155E+02, 6.4691652602E-01],
	[1.38300E+04, 5.6933274545E+03, 5.6164387045E+03, 4.8165140469E+02, 4.1154239251E+02, 6.4706430805E-01],
	[1.38350E+04, 5.6960649930E+03, 5.6159334763E+03, 4.8220087872E+02, 4.1195508661E+02, 6.4721205595E-01],
	[1.38400E+04, 5.6988028579E+03, 5.6154284761E+03, 4.8275077995E+02, 4.1236799378E+02, 6.4735976970E-01],
	[1.38450E+04, 5.7015410491E+03, 5.6149237037E+03, 4.8330110854E+02, 4.1278111396E+02, 6.4750744927E-01],
	[1.38500E+04, 5.7042795667E+03, 5.6144191590E+03, 4.8385186467E+02, 4.1319444707E+02, 6.4765509466E-01],
	[1.38550E+04, 5.7070184103E+03, 5.6139148416E+03, 4.8440304852E+02, 4.1360799304E+02, 6.4780270582E-01],
	[1.38600E+04, 5.7097575801E+03, 5.6134107515E+03, 4.8495466027E+02, 4.1402175182E+02, 6.4795028276E-01],
	[1.38650E+04, 5.7124970759E+03, 5.6129068885E+03, 4.8550670009E+02, 4.1443572333E+02, 6.4809782544E-01],
	[1.38700E+04, 5.7152368976E+03, 5.6124032523E+03, 4.8605916816E+02, 4.1484990750E+02, 6.4824533384E-01],
	[1.38750E+04, 5.7179770452E+03, 5.6118998428E+03, 4.8661206466E+02, 4.1526430426E+02, 6.4839280795E-01],
	[1.38800E+04, 5.7207175186E+03, 5.6113966598E+03, 4.8716538977E+02, 4.1567891355E+02, 6.4854024774E-01],
	[1.38850E+04, 5.7234583176E+03, 5.6108937032E+03, 4.8771914365E+02, 4.1609373530E+02, 6.4868765320E-01],
	[1.38900E+04, 5.7261994423E+03, 5.6103909726E+03, 4.8827332649E+02, 4.1650876944E+02, 6.4883502430E-01],
	[1.38950E+04, 5.7289408926E+03, 5.6098884681E+03, 4.8882793846E+02, 4.1692401590E+02, 6.4898236102E-01],
	[1.39000E+04, 5.7316826683E+03, 5.6093861893E+03, 4.8938297975E+02, 4.1733947461E+02, 6.4912966335E-01],
	[1.39050E+04, 5.7344247694E+03, 5.6088841361E+03, 4.8993845052E+02, 4.1775514550E+02, 6.4927693126E-01],
	[1.39100E+04, 5.7371671958E+03, 5.6083823083E+03, 4.9049435095E+02, 4.1817102851E+02, 6.4942416473E-01],
	[1.39150E+04, 5.7399099474E+03, 5.6078807057E+03, 4.9105068123E+02, 4.1858712356E+02, 6.4957136375E-01],
	[1.39200E+04, 5.7426530242E+03, 5.6073793282E+03, 4.9160744152E+02, 4.1900343058E+02, 6.4971852829E-01],
	[1.39250E+04, 5.7453964260E+03, 5.6068781756E+03, 4.9216463201E+02, 4.1941994951E+02, 6.4986565833E-01],
	[1.39300E+04, 5.7481401529E+03, 5.6063772476E+03, 4.9272225287E+02, 4.1983668028E+02, 6.5001275386E-01],
	[1.39350E+04, 5.7508842046E+03, 5.6058765441E+03, 4.9328030428E+02, 4.2025362280E+02, 6.5015981485E-01],
	[1.39400E+04, 5.7536285813E+03, 5.6053760649E+03, 4.9383878641E+02, 4.2067077703E+02, 6.5030684129E-01],
	[1.39450E+04, 5.7563732826E+03, 5.6048758099E+03, 4.9439769944E+02, 4.2108814287E+02, 6.5045383314E-01],
	[1.39500E+04, 5.7591183087E+03, 5.6043757788E+03, 4.9495704356E+02, 4.2150572027E+02, 6.5060079041E-01],
	[1.39550E+04, 5.7618636593E+03, 5.6038759715E+03, 4.9551681892E+02, 4.2192350916E+02, 6.5074771306E-01],
	[1.39600E+04, 5.7646093345E+03, 5.6033763878E+03, 4.9607702573E+02, 4.2234150946E+02, 6.5089460107E-01],
	[1.39650E+04, 5.7673639765E+03, 5.6028848649E+03, 4.9663766414E+02, 4.2275981215E+02, 6.5104145443E-01],
	[1.39700E+04, 5.7701324130E+03, 5.6024057651E+03, 4.9719873433E+02, 4.2317846847E+02, 6.5118827312E-01],
	[1.39750E+04, 5.7729011870E+03, 5.6019268776E+03, 4.9776023649E+02, 4.2359733673E+02, 6.5133505711E-01],
	[1.39800E+04, 5.7756702985E+03, 5.6014482024E+03, 4.9832217079E+02, 4.2401641687E+02, 6.5148180639E-01],
	[1.39850E+04, 5.7784397473E+03, 5.6009697392E+03, 4.9888453741E+02, 4.2443570881E+02, 6.5162852094E-01],
	[1.39900E+04, 5.7812095334E+03, 5.6004914879E+03, 4.9944733652E+02, 4.2485521250E+02, 6.5177520074E-01],
	[1.39950E+04, 5.7839796567E+03, 5.6000134483E+03, 5.0001056830E+02, 4.2527492784E+02, 6.5192184577E-01],
	[1.40000E+04, 5.7867501171E+03, 5.5995356203E+03, 5.0057423292E+02, 4.2569485479E+02, 6.5206845601E-01],
	[1.40050E+04, 5.7895209145E+03, 5.5990580036E+03, 5.0113833058E+02, 4.2611499326E+02, 6.5221503144E-01],
	[1.40100E+04, 5.7922920489E+03, 5.5985805981E+03, 5.0170286143E+02, 4.2653534318E+02, 6.5236157204E-01],
	[1.40150E+04, 5.7950635202E+03, 5.5981034037E+03, 5.0226782566E+02, 4.2695590449E+02, 6.5250807780E-01],
	[1.40200E+04, 5.7978353283E+03, 5.5976264201E+03, 5.0283322345E+02, 4.2737667710E+02, 6.5265454869E-01],
	[1.40250E+04, 5.8006074731E+03, 5.5971496472E+03, 5.0339905497E+02, 4.2779766096E+02, 6.5280098469E-01],
	[1.40300E+04, 5.8033799545E+03, 5.5966730848E+03, 5.0396532040E+02, 4.2821885599E+02, 6.5294738579E-01],
	[1.40350E+04, 5.8061527725E+03, 5.5961967328E+03, 5.0453201992E+02, 4.2864026212E+02, 6.5309375197E-01],
	[1.40400E+04, 5.8089259269E+03, 5.5957205910E+03, 5.0509915370E+02, 4.2906187928E+02, 6.5324008321E-01],
	[1.40450E+04, 5.8116994178E+03, 5.5952446593E+03, 5.0566672192E+02, 4.2948370739E+02, 6.5338637949E-01],
	[1.40500E+04, 5.8144732450E+03, 5.5947689374E+03, 5.0623472476E+02, 4.2990574638E+02, 6.5353264079E-01],
	[1.40550E+04, 5.8172474084E+03, 5.5942934251E+03, 5.0680316239E+02, 4.3032799619E+02, 6.5367886709E-01],
	[1.40600E+04, 5.8200219080E+03, 5.5938181224E+03, 5.0737203499E+02, 4.3075045673E+02, 6.5382505838E-01],
	[1.40650E+04, 5.8227967437E+03, 5.5933430291E+03, 5.0794134275E+02, 4.3117312795E+02, 6.5397121463E-01],
	[1.40700E+04, 5.8255719153E+03, 5.5928681449E+03, 5.0851108582E+02, 4.3159600975E+02, 6.5411733582E-01],
	[1.40750E+04, 5.8283474230E+03, 5.5923934698E+03, 5.0908126440E+02, 4.3201910208E+02, 6.5426342195E-01],
	[1.40800E+04, 5.8311232664E+03, 5.5919190036E+03, 5.0965187867E+02, 4.3244240486E+02, 6.5440947298E-01],
	[1.40850E+04, 5.8338994457E+03, 5.5914447460E+03, 5.1022292878E+02, 4.3286591802E+02, 6.5455548891E-01],
	[1.40900E+04, 5.8366759606E+03, 5.5909706969E+03, 5.1079441493E+02, 4.3328964147E+02, 6.5470146971E-01],
	[1.40950E+04, 5.8394528111E+03, 5.5904968562E+03, 5.1136633730E+02, 4.3371357516E+02, 6.5484741536E-01],
	[1.41000E+04, 5.8422299972E+03, 5.5900232238E+03, 5.1193869605E+02, 4.3413771901E+02, 6.5499332585E-01],
	[1.41050E+04, 5.8450075187E+03, 5.5895497993E+03, 5.1251149136E+02, 4.3456207294E+02, 6.5513920116E-01],
	[1.41100E+04, 5.8477853756E+03, 5.5890765827E+03, 5.1308472342E+02, 4.3498663689E+02, 6.5528504126E-01],
	[1.41150E+04, 5.8505635678E+03, 5.5886035738E+03, 5.1365839240E+02, 4.3541141077E+02, 6.5543084615E-01],
	[1.41200E+04, 5.8533420953E+03, 5.5881307724E+03, 5.1423249847E+02, 4.3583639451E+02, 6.5557661580E-01],
	[1.41250E+04, 5.8561209578E+03, 5.5876581785E+03, 5.1480704182E+02, 4.3626158805E+02, 6.5572235020E-01],
	[1.41300E+04, 5.8589001555E+03, 5.5871857917E+03, 5.1538202262E+02, 4.3668699129E+02, 6.5586804932E-01],
	[1.41350E+04, 5.8616796881E+03, 5.5867136119E+03, 5.1595744105E+02, 4.3711260418E+02, 6.5601371316E-01],
	[1.41400E+04, 5.8644595556E+03, 5.5862416391E+03, 5.1653329728E+02, 4.3753842664E+02, 6.5615934168E-01],
	[1.41450E+04, 5.8672397580E+03, 5.5857698729E+03, 5.1710959149E+02, 4.3796445859E+02, 6.5630493488E-01],
	[1.41500E+04, 5.8700202951E+03, 5.5852983133E+03, 5.1768632387E+02, 4.3839069996E+02, 6.5645049274E-01],
	[1.41550E+04, 5.8728011669E+03, 5.5848269601E+03, 5.1826349458E+02, 4.3881715068E+02, 6.5659601523E-01],
	[1.41600E+04, 5.8755823733E+03, 5.5843558131E+03, 5.1884110380E+02, 4.3924381066E+02, 6.5674150234E-01],
	[1.41650E+04, 5.8783639142E+03, 5.5838848722E+03, 5.1941915172E+02, 4.3967067983E+02, 6.5688695406E-01],
	[1.41700E+04, 5.8811457896E+03, 5.5834141372E+03, 5.1999763850E+02, 4.4009775813E+02, 6.5703237036E-01],
	[1.41750E+04, 5.8839279993E+03, 5.5829436079E+03, 5.2057656433E+02, 4.4052504546E+02, 6.5717775122E-01],
	[1.41800E+04, 5.8867105433E+03, 5.5824732842E+03, 5.2115592939E+02, 4.4095254177E+02, 6.5732309664E-01],
	[1.41850E+04, 5.8894934215E+03, 5.5820031659E+03, 5.2173573384E+02, 4.4138024697E+02, 6.5746840659E-01],
	[1.41900E+04, 5.8922766338E+03, 5.5815332529E+03, 5.2231597787E+02, 4.4180816099E+02, 6.5761368105E-01],
	[1.41950E+04, 5.8950601802E+03, 5.5810635449E+03, 5.2289666166E+02, 4.4223628374E+02, 6.5775892001E-01],
	[1.42000E+04, 5.8978440605E+03, 5.5805940419E+03, 5.2347778537E+02, 4.4266461517E+02, 6.5790412345E-01],
	[1.42050E+04, 5.9006282748E+03, 5.5801247436E+03, 5.2405934920E+02, 4.4309315518E+02, 6.5804929135E-01],
	[1.42100E+04, 5.9034128229E+03, 5.5796556499E+03, 5.2464135331E+02, 4.4352190370E+02, 6.5819442370E-01],
	[1.42150E+04, 5.9061977047E+03, 5.5791867607E+03, 5.2522379789E+02, 4.4395086067E+02, 6.5833952048E-01],
	[1.42200E+04, 5.9089829202E+03, 5.5787180758E+03, 5.2580668311E+02, 4.4438002599E+02, 6.5848458166E-01],
	[1.42250E+04, 5.9117684693E+03, 5.5782495950E+03, 5.2639000915E+02, 4.4480939960E+02, 6.5862960724E-01],
	[1.42300E+04, 5.9145543518E+03, 5.5777813181E+03, 5.2697377618E+02, 4.4523898141E+02, 6.5877459720E-01],
	[1.42350E+04, 5.9173405678E+03, 5.5773132450E+03, 5.2755798438E+02, 4.4566877136E+02, 6.5891955151E-01],
	[1.42400E+04, 5.9201271172E+03, 5.5768453756E+03, 5.2814263394E+02, 4.4609876936E+02, 6.5906447017E-01],
	[1.42450E+04, 5.9229139999E+03, 5.5763777097E+03, 5.2872772502E+02, 4.4652897534E+02, 6.5920935315E-01],
	[1.42500E+04, 5.9257012157E+03, 5.5759102470E+03, 5.2931325781E+02, 4.4695938921E+02, 6.5935420044E-01],
	[1.42550E+04, 5.9284887647E+03, 5.5754429876E+03, 5.2989923248E+02, 4.4739001091E+02, 6.5949901202E-01],
	[1.42600E+04, 5.9312766467E+03, 5.5749759311E+03, 5.3048564921E+02, 4.4782084035E+02, 6.5964378787E-01],
	[1.42650E+04, 5.9340648617E+03, 5.5745090775E+03, 5.3107250818E+02, 4.4825187746E+02, 6.5978852797E-01],
	[1.42700E+04, 5.9368534096E+03, 5.5740424265E+03, 5.3165980956E+02, 4.4868312216E+02, 6.5993323228E-01],
	[1.42750E+04, 5.9396422903E+03, 5.5735759781E+03, 5.3224755354E+02, 4.4911457437E+02, 6.6007790079E-01],
	[1.42800E+04, 5.9424315037E+03, 5.5731097321E+03, 5.3283574028E+02, 4.4954623401E+02, 6.6022253346E-01],
	[1.42850E+04, 5.9452210498E+03, 5.5726436882E+03, 5.3342436997E+02, 4.4997810101E+02, 6.6036713028E-01],
	[1.42900E+04, 5.9480109285E+03, 5.5721778464E+03, 5.3401344278E+02, 4.5041017528E+02, 6.6051169123E-01],
	[1.42950E+04, 5.9508011397E+03, 5.5717122065E+03, 5.3460295890E+02, 4.5084245676E+02, 6.6065621629E-01],
	[1.43000E+04, 5.9535916833E+03, 5.5712467683E+03, 5.3519291849E+02, 4.5127494535E+02, 6.6080070543E-01],
	[1.43050E+04, 5.9563825593E+03, 5.5707815317E+03, 5.3578332175E+02, 4.5170764098E+02, 6.6094515863E-01],
	[1.43100E+04, 5.9591737676E+03, 5.5703164965E+03, 5.3637416883E+02, 4.5214054358E+02, 6.6108957587E-01],
	[1.43150E+04, 5.9619653080E+03, 5.5698516626E+03, 5.3696545993E+02, 4.5257365306E+02, 6.6123395714E-01],
	[1.43200E+04, 5.9647571806E+03, 5.5693870297E+03, 5.3755719521E+02, 4.5300696935E+02, 6.6137830240E-01],
	[1.43250E+04, 5.9675493853E+03, 5.5689225978E+03, 5.3814937486E+02, 4.5344049236E+02, 6.6152261164E-01],
	[1.43300E+04, 5.9703419219E+03, 5.5684583667E+03, 5.3874199906E+02, 4.5387422201E+02, 6.6166688484E-01],
	[1.43350E+04, 5.9731347904E+03, 5.5679943362E+03, 5.3933506798E+02, 4.5430815823E+02, 6.6181112198E-01],
	[1.43400E+04, 5.9759279907E+03, 5.5675305062E+03, 5.3992858179E+02, 4.5474230094E+02, 6.6195532303E-01],
	[1.43450E+04, 5.9787215228E+03, 5.5670668765E+03, 5.4052254068E+02, 4.5517665006E+02, 6.6209948798E-01],
	[1.43500E+04, 5.9815153865E+03, 5.5666034470E+03, 5.4111694483E+02, 4.5561120550E+02, 6.6224361679E-01],
	[1.43550E+04, 5.9843095819E+03, 5.5661402175E+03, 5.4171179441E+02, 4.5604596719E+02, 6.6238770947E-01],
	[1.43600E+04, 5.9871041087E+03, 5.5656771878E+03, 5.4230708959E+02, 4.5648093505E+02, 6.6253176597E-01],
	[1.43650E+04, 5.9898989670E+03, 5.5652143578E+03, 5.4290283057E+02, 4.5691610900E+02, 6.6267578628E-01],
	[1.43700E+04, 5.9926941566E+03, 5.5647517273E+03, 5.4349901750E+02, 4.5735148895E+02, 6.6281977039E-01],
	[1.43750E+04, 5.9954896776E+03, 5.5642892963E+03, 5.4409565058E+02, 4.5778707483E+02, 6.6296371826E-01],
	[1.43800E+04, 5.9982855297E+03, 5.5638270644E+03, 5.4469272998E+02, 4.5822286655E+02, 6.6310762989E-01],
	[1.43850E+04, 6.0010817130E+03, 5.5633650316E+03, 5.4529025587E+02, 4.5865886403E+02, 6.6325150524E-01],
	[1.43900E+04, 6.0038782273E+03, 5.5629031978E+03, 5.4588822844E+02, 4.5909506721E+02, 6.6339534431E-01],
	[1.43950E+04, 6.0066750727E+03, 5.5624415627E+03, 5.4648664786E+02, 4.5953147598E+02, 6.6353914706E-01],
	[1.44000E+04, 6.0094722489E+03, 5.5619801262E+03, 5.4708551430E+02, 4.5996809027E+02, 6.6368291347E-01],
	[1.44050E+04, 6.0122697560E+03, 5.5615188881E+03, 5.4768482796E+02, 4.6040491001E+02, 6.6382664354E-01],
	[1.44100E+04, 6.0150675938E+03, 5.5610578484E+03, 5.4828458900E+02, 4.6084193510E+02, 6.6397033723E-01],
	[1.44150E+04, 6.0178657623E+03, 5.5605970068E+03, 5.4888479760E+02, 4.6127916547E+02, 6.6411399453E-01],
	[1.44200E+04, 6.0206642614E+03, 5.5601363632E+03, 5.4948545395E+02, 4.6171660104E+02, 6.6425761542E-01],
	[1.44250E+04, 6.0234630910E+03, 5.5596759174E+03, 5.5008655820E+02, 4.6215424172E+02, 6.6440119987E-01],
	[1.44300E+04, 6.0262622511E+03, 5.5592156693E+03, 5.5068811056E+02, 4.6259208743E+02, 6.6454474787E-01],
	[1.44350E+04, 6.0290617416E+03, 5.5587556187E+03, 5.5129011119E+02, 4.6303013809E+02, 6.6468825940E-01],
	[1.44400E+04, 6.0318615624E+03, 5.5582957655E+03, 5.5189256027E+02, 4.6346839362E+02, 6.6483173443E-01],
	[1.44450E+04, 6.0346617134E+03, 5.5578361096E+03, 5.5249545797E+02, 4.6390685393E+02, 6.6497517295E-01],
	[1.44500E+04, 6.0374621945E+03, 5.5573766507E+03, 5.5309880448E+02, 4.6434551894E+02, 6.6511857494E-01],
	[1.44550E+04, 6.0402630057E+03, 5.5569173887E+03, 5.5370259998E+02, 4.6478438858E+02, 6.6526194038E-01],
	[1.44600E+04, 6.0430641470E+03, 5.5564583235E+03, 5.5430684463E+02, 4.6522346275E+02, 6.6540526924E-01],
	[1.44650E+04, 6.0458656181E+03, 5.5559994549E+03, 5.5491153863E+02, 4.6566274138E+02, 6.6554856151E-01],
	[1.44700E+04, 6.0486674191E+03, 5.5555407828E+03, 5.5551668214E+02, 4.6610222438E+02, 6.6569181717E-01],
	[1.44750E+04, 6.0514695499E+03, 5.5550823070E+03, 5.5612227535E+02, 4.6654191166E+02, 6.6583503619E-01],
	[1.44800E+04, 6.0542720104E+03, 5.5546240273E+03, 5.5672831843E+02, 4.6698180315E+02, 6.6597821857E-01],
	[1.44850E+04, 6.0570748005E+03, 5.5541659436E+03, 5.5733481155E+02, 4.6742189877E+02, 6.6612136427E-01],
	[1.44900E+04, 6.0598779202E+03, 5.5537080558E+03, 5.5794175491E+02, 4.6786219842E+02, 6.6626447328E-01],
	[1.44950E+04, 6.0626813693E+03, 5.5532503637E+03, 5.5854914867E+02, 4.6830270202E+02, 6.6640754559E-01],
	[1.45000E+04, 6.0654851478E+03, 5.5527928672E+03, 5.5915699301E+02, 4.6874340950E+02, 6.6655058116E-01],
	[1.45050E+04, 6.0682892557E+03, 5.5523355660E+03, 5.5976528812E+02, 4.6918432076E+02, 6.6669357999E-01],
	[1.45100E+04, 6.0710936928E+03, 5.5518784601E+03, 5.6037403416E+02, 4.6962543572E+02, 6.6683654205E-01],
	[1.45150E+04, 6.0738984591E+03, 5.5514215493E+03, 5.6098323132E+02, 4.7006675431E+02, 6.6697946732E-01],
	[1.45200E+04, 6.0767035987E+03, 5.5509648676E+03, 5.6159287977E+02, 4.7050827694E+02, 6.6712235579E-01],
	[1.45250E+04, 6.0795338513E+03, 5.5505275208E+03, 5.6220297970E+02, 4.7095028953E+02, 6.6726520743E-01],
	[1.45300E+04, 6.0823644473E+03, 5.5500903589E+03, 5.6281353127E+02, 4.7139250636E+02, 6.6740802223E-01],
	[1.45350E+04, 6.0851953866E+03, 5.5496533819E+03, 5.6342453467E+02, 4.7183492733E+02, 6.6755080017E-01],
	[1.45400E+04, 6.0880266693E+03, 5.5492165895E+03, 5.6403599008E+02, 4.7227755236E+02, 6.6769354122E-01],
	[1.45450E+04, 6.0908582951E+03, 5.5487799817E+03, 5.6464789767E+02, 4.7272038137E+02, 6.6783624537E-01],
	[1.45500E+04, 6.0936902640E+03, 5.5483435582E+03, 5.6526025762E+02, 4.7316341427E+02, 6.6797891260E-01],
	[1.45550E+04, 6.0965225760E+03, 5.5479073191E+03, 5.6587307011E+02, 4.7360665099E+02, 6.6812154290E-01],
	[1.45600E+04, 6.0993552309E+03, 5.5474712640E+03, 5.6648633532E+02, 4.7405009143E+02, 6.6826413623E-01],
	[1.45650E+04, 6.1021882287E+03, 5.5470353929E+03, 5.6710005342E+02, 4.7449373551E+02, 6.6840669259E-01],
	[1.45700E+04, 6.1050215694E+03, 5.5465997057E+03, 5.6771422460E+02, 4.7493758315E+02, 6.6854921195E-01],
	[1.45750E+04, 6.1078552527E+03, 5.5461642021E+03, 5.6832884902E+02, 4.7538163427E+02, 6.6869169430E-01],
	[1.45800E+04, 6.1106892787E+03, 5.5457288821E+03, 5.6894392687E+02, 4.7582588877E+02, 6.6883413962E-01],
	[1.45850E+04, 6.1135236473E+03, 5.5452937455E+03, 5.6955945833E+02, 4.7627034658E+02, 6.6897654789E-01],
	[1.45900E+04, 6.1163583584E+03, 5.5448587922E+03, 5.7017544357E+02, 4.7671500761E+02, 6.6911891909E-01],
	[1.45950E+04, 6.1191934120E+03, 5.5444240220E+03, 5.7079188278E+02, 4.7715987178E+02, 6.6926125320E-01],
	[1.46000E+04, 6.1220288079E+03, 5.5439894348E+03, 5.7140877612E+02, 4.7760493899E+02, 6.6940355020E-01],
	[1.46050E+04, 6.1248645460E+03, 5.5435550304E+03, 5.7202612378E+02, 4.7805020917E+02, 6.6954581008E-01],
	[1.46100E+04, 6.1277006264E+03, 5.5431208088E+03, 5.7264392594E+02, 4.7849568223E+02, 6.6968803282E-01],
	[1.46150E+04, 6.1305370489E+03, 5.5426867697E+03, 5.7326218277E+02, 4.7894135809E+02, 6.6983021840E-01],
	[1.46200E+04, 6.1333738134E+03, 5.5422529131E+03, 5.7388089446E+02, 4.7938723665E+02, 6.6997236680E-01],
	[1.46250E+04, 6.1362109199E+03, 5.5418192388E+03, 5.7450006117E+02, 4.7983331784E+02, 6.7011447800E-01],
	[1.46300E+04, 6.1390483683E+03, 5.5413857466E+03, 5.7511968309E+02, 4.8027960156E+02, 6.7025655198E-01],
	[1.46350E+04, 6.1418861586E+03, 5.5409524364E+03, 5.7573976039E+02, 4.8072608774E+02, 6.7039858873E-01],
	[1.46400E+04, 6.1447242906E+03, 5.5405193081E+03, 5.7636029326E+02, 4.8117277628E+02, 6.7054058823E-01],
	[1.46450E+04, 6.1475627642E+03, 5.5400863616E+03, 5.7698128187E+02, 4.8161966710E+02, 6.7068255046E-01],
	[1.46500E+04, 6.1504015795E+03, 5.5396535967E+03, 5.7760272640E+02, 4.8206676012E+02, 6.7082447540E-01],
	[1.46550E+04, 6.1532407362E+03, 5.5392210132E+03, 5.7822462703E+02, 4.8251405524E+02, 6.7096636304E-01],
	[1.46600E+04, 6.1560802345E+03, 5.5387886110E+03, 5.7884698393E+02, 4.8296155238E+02, 6.7110821335E-01],
	[1.46650E+04, 6.1589200741E+03, 5.5383563901E+03, 5.7946979728E+02, 4.8340925146E+02, 6.7125002633E-01],
	[1.46700E+04, 6.1617602549E+03, 5.5379243502E+03, 5.8009306727E+02, 4.8385715238E+02, 6.7139180194E-01],
	[1.46750E+04, 6.1646007770E+03, 5.5374924912E+03, 5.8071679407E+02, 4.8430525507E+02, 6.7153354018E-01],
	[1.46800E+04, 6.1674416403E+03, 5.5370608130E+03, 5.8134097785E+02, 4.8475355942E+02, 6.7167524102E-01],
	[1.46850E+04, 6.1702828446E+03, 5.5366293154E+03, 5.8196561880E+02, 4.8520206537E+02, 6.7181690446E-01],
	[1.46900E+04, 6.1731243899E+03, 5.5361979983E+03, 5.8259071710E+02, 4.8565077281E+02, 6.7195853046E-01],
	[1.46950E+04, 6.1759662761E+03, 5.5357668616E+03, 5.8321627291E+02, 4.8609968166E+02, 6.7210011902E-01],
	[1.47000E+04, 6.1788085032E+03, 5.5353359051E+03, 5.8384228643E+02, 4.8654879184E+02, 6.7224167011E-01],
	[1.47050E+04, 6.1816510710E+03, 5.5349051287E+03, 5.8446875782E+02, 4.8699810325E+02, 6.7238318372E-01],
	[1.47100E+04, 6.1844939796E+03, 5.5344745323E+03, 5.8509568727E+02, 4.8744761581E+02, 6.7252465983E-01],
	[1.47150E+04, 6.1873372287E+03, 5.5340441157E+03, 5.8572307495E+02, 4.8789732944E+02, 6.7266609843E-01],
	[1.47200E+04, 6.1901808184E+03, 5.5336138787E+03, 5.8635092104E+02, 4.8834724403E+02, 6.7280749949E-01],
	[1.47250E+04, 6.1930247485E+03, 5.5331838213E+03, 5.8697922573E+02, 4.8879735951E+02, 6.7294886301E-01],
	[1.47300E+04, 6.1958690191E+03, 5.5327539434E+03, 5.8760798918E+02, 4.8924767579E+02, 6.7309018895E-01],
	[1.47350E+04, 6.1987136300E+03, 5.5323242447E+03, 5.8823721158E+02, 4.8969819277E+02, 6.7323147731E-01],
	[1.47400E+04, 6.2015585811E+03, 5.5318947251E+03, 5.8886689311E+02, 4.9014891037E+02, 6.7337272807E-01],
	[1.47450E+04, 6.2044038724E+03, 5.5314653845E+03, 5.8949703394E+02, 4.9059982851E+02, 6.7351394121E-01],
	[1.47500E+04, 6.2072495037E+03, 5.5310362229E+03, 5.9012763425E+02, 4.9105094708E+02, 6.7365511671E-01],
	[1.47550E+04, 6.2100954751E+03, 5.5306072399E+03, 5.9075869421E+02, 4.9150226601E+02, 6.7379625456E-01],
	[1.47600E+04, 6.2129417865E+03, 5.5301784355E+03, 5.9139021402E+02, 4.9195378521E+02, 6.7393735474E-01],
	[1.47650E+04, 6.2157884377E+03, 5.5297498096E+03, 5.9202219384E+02, 4.9240550457E+02, 6.7407841724E-01],
	[1.47700E+04, 6.2186354287E+03, 5.5293213621E+03, 5.9265463386E+02, 4.9285742403E+02, 6.7421944203E-01],
	[1.47750E+04, 6.2214827594E+03, 5.5288930927E+03, 5.9328753424E+02, 4.9330954348E+02, 6.7436042910E-01],
	[1.47800E+04, 6.2243304298E+03, 5.5284650014E+03, 5.9392089518E+02, 4.9376186284E+02, 6.7450137843E-01],
	[1.47850E+04, 6.2271784397E+03, 5.5280370880E+03, 5.9455471684E+02, 4.9421438201E+02, 6.7464229002E-01],
	[1.47900E+04, 6.2300267892E+03, 5.5276093524E+03, 5.9518899941E+02, 4.9466710091E+02, 6.7478316383E-01],
	[1.47950E+04, 6.2328754780E+03, 5.5271817945E+03, 5.9582374307E+02, 4.9512001945E+02, 6.7492399985E-01],
	[1.48000E+04, 6.2357245063E+03, 5.5267544141E+03, 5.9645894799E+02, 4.9557313754E+02, 6.7506479807E-01],
	[1.48050E+04, 6.2385738738E+03, 5.5263272111E+03, 5.9709461435E+02, 4.9602645509E+02, 6.7520555847E-01],
	[1.48100E+04, 6.2414235804E+03, 5.5259001853E+03, 5.9773074233E+02, 4.9647997200E+02, 6.7534628104E-01],
	[1.48150E+04, 6.2442736263E+03, 5.5254733367E+03, 5.9836733211E+02, 4.9693368819E+02, 6.7548696575E-01],
	[1.48200E+04, 6.2471240111E+03, 5.5250466650E+03, 5.9900438386E+02, 4.9738760356E+02, 6.7562761259E-01],
	[1.48250E+04, 6.2499747350E+03, 5.5246201702E+03, 5.9964189777E+02, 4.9784171804E+02, 6.7576822155E-01],
	[1.48300E+04, 6.2528257978E+03, 5.5241938522E+03, 6.0027987401E+02, 4.9829603151E+02, 6.7590879261E-01],
	[1.48350E+04, 6.2556771993E+03, 5.5237677107E+03, 6.0091831276E+02, 4.9875054390E+02, 6.7604932575E-01],
	[1.48400E+04, 6.2585289397E+03, 5.5233417457E+03, 6.0155721420E+02, 4.9920525512E+02, 6.7618982096E-01],
	[1.48450E+04, 6.2613810187E+03, 5.5229159570E+03, 6.0219657851E+02, 4.9966016507E+02, 6.7633027822E-01],
	[1.48500E+04, 6.2642334363E+03, 5.5224903445E+03, 6.0283640587E+02, 5.0011527365E+02, 6.7647069751E-01],
	[1.48550E+04, 6.2670861925E+03, 5.5220649081E+03, 6.0347669644E+02, 5.0057058079E+02, 6.7661107882E-01],
	[1.48600E+04, 6.2699392871E+03, 5.5216396476E+03, 6.0411745043E+02, 5.0102608639E+02, 6.7675142213E-01],
	[1.48650E+04, 6.2727927202E+03, 5.5212145629E+03, 6.0475866799E+02, 5.0148179035E+02, 6.7689172743E-01],
	[1.48700E+04, 6.2756464915E+03, 5.5207896538E+03, 6.0540034931E+02, 5.0193769259E+02, 6.7703199470E-01],
	[1.48750E+04, 6.2785006011E+03, 5.5203649203E+03, 6.0604249457E+02, 5.0239379301E+02, 6.7717222392E-01],
	[1.48800E+04, 6.2813550488E+03, 5.5199403622E+03, 6.0668510394E+02, 5.0285009152E+02, 6.7731241508E-01],
	[1.48850E+04, 6.2842098347E+03, 5.5195159794E+03, 6.0732817761E+02, 5.0330658803E+02, 6.7745256817E-01],
	[1.48900E+04, 6.2870649585E+03, 5.5190917717E+03, 6.0797171575E+02, 5.0376328245E+02, 6.7759268316E-01],
	[1.48950E+04, 6.2899204203E+03, 5.5186677390E+03, 6.0861571854E+02, 5.0422017468E+02, 6.7773276005E-01],
	[1.49000E+04, 6.2927762200E+03, 5.5182438812E+03, 6.0926018616E+02, 5.0467726463E+02, 6.7787279881E-01],
	[1.49050E+04, 6.2956323574E+03, 5.5178201982E+03, 6.0990511879E+02, 5.0513455222E+02, 6.7801279943E-01],
	[1.49100E+04, 6.2984888326E+03, 5.5173966898E+03, 6.1055051660E+02, 5.0559203734E+02, 6.7815276190E-01],
	[1.49150E+04, 6.3013456455E+03, 5.5169733558E+03, 6.1119637978E+02, 5.0604971991E+02, 6.7829268620E-01],
	[1.49200E+04, 6.3042027959E+03, 5.5165501962E+03, 6.1184270851E+02, 5.0650759982E+02, 6.7843257231E-01],
	[1.49250E+04, 6.3070602838E+03, 5.5161272109E+03, 6.1248950295E+02, 5.0696567700E+02, 6.7857242022E-01],
	[1.49300E+04, 6.3099181092E+03, 5.5157043996E+03, 6.1313676329E+02, 5.0742395134E+02, 6.7871222992E-01],
	[1.49350E+04, 6.3127762719E+03, 5.5152817623E+03, 6.1378448972E+02, 5.0788242275E+02, 6.7885200138E-01],
	[1.49400E+04, 6.3156347719E+03, 5.5148592988E+03, 6.1443268239E+02, 5.0834109114E+02, 6.7899173460E-01],
	[1.49450E+04, 6.3184936092E+03, 5.5144370091E+03, 6.1508134151E+02, 5.0879995641E+02, 6.7913142955E-01],
	[1.49500E+04, 6.3213527835E+03, 5.5140148929E+03, 6.1573046724E+02, 5.0925901848E+02, 6.7927108623E-01],
	[1.49550E+04, 6.3242122950E+03, 5.5135929502E+03, 6.1638005976E+02, 5.0971827724E+02, 6.7941070461E-01],
	[1.49600E+04, 6.3270721434E+03, 5.5131711808E+03, 6.1703011925E+02, 5.1017773261E+02, 6.7955028469E-01],
	[1.49650E+04, 6.3299323287E+03, 5.5127495845E+03, 6.1768064589E+02, 5.1063738448E+02, 6.7968982645E-01],
	[1.49700E+04, 6.3327928509E+03, 5.5123281614E+03, 6.1833163985E+02, 5.1109723277E+02, 6.7982932987E-01],
	[1.49750E+04, 6.3356537099E+03, 5.5119069112E+03, 6.1898310133E+02, 5.1155727739E+02, 6.7996879493E-01],
	[1.49800E+04, 6.3385149056E+03, 5.5114858337E+03, 6.1963503049E+02, 5.1201751823E+02, 6.8010822163E-01],
	[1.49850E+04, 6.3413764379E+03, 5.5110649290E+03, 6.2028742751E+02, 5.1247795520E+02, 6.8024760995E-01],
	[1.49900E+04, 6.3442383067E+03, 5.5106441968E+03, 6.2094029257E+02, 5.1293858821E+02, 6.8038695987E-01],
	[1.49950E+04, 6.3471005121E+03, 5.5102236370E+03, 6.2159362586E+02, 5.1339941716E+02, 6.8052627138E-01],
	[1.50000E+04, 6.3499630538E+03, 5.5098032495E+03, 6.2224742754E+02, 5.1386044196E+02, 6.8066554446E-01],
	[1.50050E+04, 6.3528259319E+03, 5.5093830342E+03, 6.2290583068E+02, 5.1432448014E+02, 6.8080477910E-01],
	[1.50100E+04, 6.3556891463E+03, 5.5089629909E+03, 6.2356471003E+02, 5.1478871731E+02, 6.8094397529E-01],
	[1.50150E+04, 6.3585526968E+03, 5.5085431195E+03, 6.2422406577E+02, 5.1525315339E+02, 6.8108313300E-01],
	[1.50200E+04, 6.3614165835E+03, 5.5081234199E+03, 6.2488389809E+02, 5.1571778826E+02, 6.8122225224E-01],
	[1.50250E+04, 6.3642808063E+03, 5.5077038919E+03, 6.2554420716E+02, 5.1618262185E+02, 6.8136133297E-01],
	[1.50300E+04, 6.3671453650E+03, 5.5072845355E+03, 6.2620499318E+02, 5.1664765404E+02, 6.8150037519E-01],
	[1.50350E+04, 6.3700102596E+03, 5.5068653504E+03, 6.2686625633E+02, 5.1711288475E+02, 6.8163937888E-01],
	[1.50400E+04, 6.3728754900E+03, 5.5064463367E+03, 6.2752799680E+02, 5.1757831388E+02, 6.8177834403E-01],
	[1.50450E+04, 6.3757410562E+03, 5.5060274940E+03, 6.2819021476E+02, 5.1804394132E+02, 6.8191727063E-01],
	[1.50500E+04, 6.3786069581E+03, 5.5056088224E+03, 6.2885291041E+02, 5.1850976699E+02, 6.8205615865E-01],
	[1.50550E+04, 6.3814731956E+03, 5.5051903217E+03, 6.2951608393E+02, 5.1897579078E+02, 6.8219500809E-01],
	[1.50600E+04, 6.3843397686E+03, 5.5047719917E+03, 6.3017973550E+02, 5.1944201261E+02, 6.8233381893E-01],
	[1.50650E+04, 6.3872066771E+03, 5.5043538324E+03, 6.3084386531E+02, 5.1990843236E+02, 6.8247259115E-01],
	[1.50700E+04, 6.3900739211E+03, 5.5039358436E+03, 6.3150847354E+02, 5.2037504995E+02, 6.8261132475E-01],
	[1.50750E+04, 6.3929415003E+03, 5.5035180252E+03, 6.3217356039E+02, 5.2084186528E+02, 6.8275001971E-01],
	[1.50800E+04, 6.3958094148E+03, 5.5031003770E+03, 6.3283912602E+02, 5.2130887824E+02, 6.8288867601E-01],
	[1.50850E+04, 6.3986776645E+03, 5.5026828990E+03, 6.3350517064E+02, 5.2177608875E+02, 6.8302729365E-01],
	[1.50900E+04, 6.4015462492E+03, 5.5022655910E+03, 6.3417169442E+02, 5.2224349670E+02, 6.8316587260E-01],
	[1.50950E+04, 6.4044151691E+03, 5.5018484528E+03, 6.3483869755E+02, 5.2271110199E+02, 6.8330441285E-01],
	[1.51000E+04, 6.4072890944E+03, 5.5014346015E+03, 6.3550618021E+02, 5.2317896387E+02, 6.8344291440E-01],
	[1.51050E+04, 6.4101862370E+03, 5.5010361797E+03, 6.3617414259E+02, 5.2364731402E+02, 6.8358137721E-01],
	[1.51100E+04, 6.4130837301E+03, 5.5006379187E+03, 6.3684258487E+02, 5.2411586223E+02, 6.8371980129E-01],
	[1.51150E+04, 6.4159815735E+03, 5.5002398182E+03, 6.3751150724E+02, 5.2458460839E+02, 6.8385818662E-01],
	[1.51200E+04, 6.4188797673E+03, 5.4998418782E+03, 6.3818090989E+02, 5.2505355240E+02, 6.8399653319E-01],
	[1.51250E+04, 6.4217783114E+03, 5.4994440985E+03, 6.3885079299E+02, 5.2552269416E+02, 6.8413484097E-01],
	[1.51300E+04, 6.4246772057E+03, 5.4990464791E+03, 6.3952115674E+02, 5.2599203359E+02, 6.8427310995E-01],
	[1.51350E+04, 6.4275764501E+03, 5.4986490198E+03, 6.4019200132E+02, 5.2646157057E+02, 6.8441134012E-01],
	[1.51400E+04, 6.4304760445E+03, 5.4982517205E+03, 6.4086332690E+02, 5.2693130502E+02, 6.8454953144E-01],
	[1.51450E+04, 6.4333759889E+03, 5.4978545811E+03, 6.4153513369E+02, 5.2740123683E+02, 6.8468768391E-01],
	[1.51500E+04, 6.4362762833E+03, 5.4974576014E+03, 6.4220742186E+02, 5.2787136591E+02, 6.8482579751E-01],
	[1.51550E+04, 6.4391769274E+03, 5.4970607814E+03, 6.4288019160E+02, 5.2834169215E+02, 6.8496387222E-01],
	[1.51600E+04, 6.4420779213E+03, 5.4966641209E+03, 6.4355344309E+02, 5.2881221547E+02, 6.8510190802E-01],
	[1.51650E+04, 6.4449792649E+03, 5.4962676198E+03, 6.4422717653E+02, 5.2928293576E+02, 6.8523990490E-01],
	[1.51700E+04, 6.4478809581E+03, 5.4958712780E+03, 6.4490139208E+02, 5.2975385293E+02, 6.8537786284E-01],
	[1.51750E+04, 6.4507830008E+03, 5.4954750954E+03, 6.4557608995E+02, 5.3022496687E+02, 6.8551578183E-01],
	[1.51800E+04, 6.4536853930E+03, 5.4950790718E+03, 6.4625127031E+02, 5.3069627748E+02, 6.8565366184E-01],
	[1.51850E+04, 6.4565881346E+03, 5.4946832072E+03, 6.4692693334E+02, 5.3116778468E+02, 6.8579150286E-01],
	[1.51900E+04, 6.4594912255E+03, 5.4942875014E+03, 6.4760307925E+02, 5.3163948835E+02, 6.8592930488E-01],
	[1.51950E+04, 6.4623946657E+03, 5.4938919544E+03, 6.4827970820E+02, 5.3211138840E+02, 6.8606706787E-01],
	[1.52000E+04, 6.4652984550E+03, 5.4934965659E+03, 6.4895682038E+02, 5.3258348473E+02, 6.8620479183E-01],
	[1.52050E+04, 6.4682025934E+03, 5.4931013359E+03, 6.4963441599E+02, 5.3305577725E+02, 6.8634247673E-01],
	[1.52100E+04, 6.4711070808E+03, 5.4927062643E+03, 6.5031249520E+02, 5.3352826585E+02, 6.8648012256E-01],
	[1.52150E+04, 6.4740119172E+03, 5.4923113509E+03, 6.5099105820E+02, 5.3400095043E+02, 6.8661772930E-01],
	[1.52200E+04, 6.4769171025E+03, 5.4919165957E+03, 6.5167010518E+02, 5.3447383089E+02, 6.8675529693E-01],
	[1.52250E+04, 6.4798226366E+03, 5.4915219985E+03, 6.5234963631E+02, 5.3494690713E+02, 6.8689282545E-01],
	[1.52300E+04, 6.4827285194E+03, 5.4911275592E+03, 6.5302965179E+02, 5.3542017906E+02, 6.8703031483E-01],
	[1.52350E+04, 6.4856347508E+03, 5.4907332777E+03, 6.5371015181E+02, 5.3589364657E+02, 6.8716776506E-01],
	[1.52400E+04, 6.4885413309E+03, 5.4903391538E+03, 6.5439113654E+02, 5.3636730957E+02, 6.8730517612E-01],
	[1.52450E+04, 6.4914482595E+03, 5.4899451876E+03, 6.5507260617E+02, 5.3684116795E+02, 6.8744254799E-01],
	[1.52500E+04, 6.4943555365E+03, 5.4895513787E+03, 6.5575456088E+02, 5.3731522161E+02, 6.8757988066E-01],
	[1.52550E+04, 6.4972631619E+03, 5.4891577272E+03, 6.5643700087E+02, 5.3778947045E+02, 6.8771717412E-01],
	[1.52600E+04, 6.5001711356E+03, 5.4887642330E+03, 6.5711992632E+02, 5.3826391437E+02, 6.8785442834E-01],
	[1.52650E+04, 6.5030794575E+03, 5.4883708958E+03, 6.5780333740E+02, 5.3873855328E+02, 6.8799164332E-01],
	[1.52700E+04, 6.5059881276E+03, 5.4879777156E+03, 6.5848723432E+02, 5.3921338706E+02, 6.8812881903E-01],
	[1.52750E+04, 6.5088971457E+03, 5.4875846923E+03, 6.5917161725E+02, 5.3968841562E+02, 6.8826595546E-01],
	[1.52800E+04, 6.5118065119E+03, 5.4871918257E+03, 6.5985648637E+02, 5.4016363886E+02, 6.8840305260E-01],
	[1.52850E+04, 6.5147162260E+03, 5.4867991158E+03, 6.6054184188E+02, 5.4063905668E+02, 6.8854011042E-01],
	[1.52900E+04, 6.5176262879E+03, 5.4864065624E+03, 6.6122768396E+02, 5.4111466897E+02, 6.8867712892E-01],
	[1.52950E+04, 6.5205366977E+03, 5.4860141655E+03, 6.6191401279E+02, 5.4159047564E+02, 6.8881410807E-01],
	[1.53000E+04, 6.5234474552E+03, 5.4856219248E+03, 6.6260082857E+02, 5.4206647658E+02, 6.8895104787E-01],
	[1.53050E+04, 6.5263585603E+03, 5.4852298404E+03, 6.6328813146E+02, 5.4254267169E+02, 6.8908794830E-01],
	[1.53100E+04, 6.5292700130E+03, 5.4848379120E+03, 6.6397592167E+02, 5.4301906087E+02, 6.8922480933E-01],
	[1.53150E+04, 6.5321818132E+03, 5.4844461396E+03, 6.6466419937E+02, 5.4349564402E+02, 6.8936163097E-01],
	[1.53200E+04, 6.5350939608E+03, 5.4840545230E+03, 6.6535296475E+02, 5.4397242103E+02, 6.8949841318E-01],
	[1.53250E+04, 6.5380064558E+03, 5.4836630622E+03, 6.6604221800E+02, 5.4444939180E+02, 6.8963515596E-01],
	[1.53300E+04, 6.5409192981E+03, 5.4832717570E+03, 6.6673195930E+02, 5.4492655624E+02, 6.8977185929E-01],
	[1.53350E+04, 6.5438324876E+03, 5.4828806074E+03, 6.6742218884E+02, 5.4540391423E+02, 6.8990852315E-01],
	[1.53400E+04, 6.5467460243E+03, 5.4824896131E+03, 6.6811290680E+02, 5.4588146568E+02, 6.9004514754E-01],
	[1.53450E+04, 6.5496599080E+03, 5.4820987741E+03, 6.6880411337E+02, 5.4635921049E+02, 6.9018173242E-01],
	[1.53500E+04, 6.5525741387E+03, 5.4817080903E+03, 6.6949580873E+02, 5.4683714854E+02, 6.9031827780E-01],
	[1.53550E+04, 6.5554887163E+03, 5.4813175616E+03, 6.7018799307E+02, 5.4731527974E+02, 6.9045478366E-01],
	[1.53600E+04, 6.5584036408E+03, 5.4809271878E+03, 6.7088066657E+02, 5.4779360399E+02, 6.9059124997E-01],
	[1.53650E+04, 6.5613189121E+03, 5.4805369689E+03, 6.7157382943E+02, 5.4827212118E+02, 6.9072767673E-01],
	[1.53700E+04, 6.5642345301E+03, 5.4801469047E+03, 6.7226748181E+02, 5.4875083120E+02, 6.9086406392E-01],
	[1.53750E+04, 6.5671504948E+03, 5.4797569951E+03, 6.7296162392E+02, 5.4922973397E+02, 6.9100041153E-01],
	[1.53800E+04, 6.5700668060E+03, 5.4793672400E+03, 6.7365625594E+02, 5.4970882936E+02, 6.9113671954E-01],
	[1.53850E+04, 6.5729834637E+03, 5.4789776393E+03, 6.7435137804E+02, 5.5018811729E+02, 6.9127298793E-01],
	[1.53900E+04, 6.5759004679E+03, 5.4785881929E+03, 6.7504699043E+02, 5.5066759764E+02, 6.9140921669E-01],
	[1.53950E+04, 6.5788178184E+03, 5.4781989007E+03, 6.7574309327E+02, 5.5114727031E+02, 6.9154540582E-01],
	[1.54000E+04, 6.5817355152E+03, 5.4778097626E+03, 6.7643968676E+02, 5.5162713519E+02, 6.9168155528E-01],
	[1.54050E+04, 6.5846535582E+03, 5.4774207784E+03, 6.7713677109E+02, 5.5210719219E+02, 6.9181766507E-01],
	[1.54100E+04, 6.5875719473E+03, 5.4770319480E+03, 6.7783434644E+02, 5.5258744120E+02, 6.9195373518E-01],
	[1.54150E+04, 6.5904906825E+03, 5.4766432714E+03, 6.7853241299E+02, 5.5306788212E+02, 6.9208976558E-01],
	[1.54200E+04, 6.5934097638E+03, 5.4762547483E+03, 6.7923097093E+02, 5.5354851483E+02, 6.9222575627E-01],
	[1.54250E+04, 6.5963291909E+03, 5.4758663788E+03, 6.7993002044E+02, 5.5402933925E+02, 6.9236170723E-01],
	[1.54300E+04, 6.5992489639E+03, 5.4754781627E+03, 6.8062956172E+02, 5.5451035525E+02, 6.9249761845E-01],
	[1.54350E+04, 6.6021690827E+03, 5.4750900999E+03, 6.8132959495E+02, 5.5499156274E+02, 6.9263348991E-01],
	[1.54400E+04, 6.6050895472E+03, 5.4747021903E+03, 6.8203012030E+02, 5.5547296161E+02, 6.9276932160E-01],
	[1.54450E+04, 6.6080103574E+03, 5.4743144337E+03, 6.8273113798E+02, 5.5595455177E+02, 6.9290511350E-01],
	[1.54500E+04, 6.6109315131E+03, 5.4739268301E+03, 6.8343264816E+02, 5.5643633309E+02, 6.9304086560E-01],
	[1.54550E+04, 6.6138530143E+03, 5.4735393793E+03, 6.8413465102E+02, 5.5691830548E+02, 6.9317657788E-01],
	[1.54600E+04, 6.6167748610E+03, 5.4731520813E+03, 6.8483714676E+02, 5.5740046883E+02, 6.9331225034E-01],
	[1.54650E+04, 6.6196970530E+03, 5.4727649359E+03, 6.8554013557E+02, 5.5788282304E+02, 6.9344788295E-01],
	[1.54700E+04, 6.6226195903E+03, 5.4723779430E+03, 6.8624361762E+02, 5.5836536800E+02, 6.9358347571E-01],
	[1.54750E+04, 6.6255424728E+03, 5.4719911025E+03, 6.8694759310E+02, 5.5884810361E+02, 6.9371902860E-01],
	[1.54800E+04, 6.6284657005E+03, 5.4716044143E+03, 6.8765206220E+02, 5.5933102976E+02, 6.9385454161E-01],
	[1.54850E+04, 6.6313892733E+03, 5.4712178784E+03, 6.8835702510E+02, 5.5981414634E+02, 6.9399001472E-01],
	[1.54900E+04, 6.6343131910E+03, 5.4708314945E+03, 6.8906248199E+02, 5.6029745325E+02, 6.9412544791E-01],
	[1.54950E+04, 6.6372374537E+03, 5.4704452625E+03, 6.8976843305E+02, 5.6078095038E+02, 6.9426084119E-01],
	[1.55000E+04, 6.6401620613E+03, 5.4700591825E+03, 6.9047487848E+02, 5.6126463763E+02, 6.9439619452E-01],
	[1.55050E+04, 6.6430870137E+03, 5.4696732542E+03, 6.9118181845E+02, 5.6174851489E+02, 6.9453150790E-01],
	[1.55100E+04, 6.6460123108E+03, 5.4692874775E+03, 6.9188925315E+02, 5.6223258205E+02, 6.9466678132E-01],
	[1.55150E+04, 6.6489379525E+03, 5.4689018524E+03, 6.9259718277E+02, 5.6271683901E+02, 6.9480201476E-01],
	[1.55200E+04, 6.6518639388E+03, 5.4685163787E+03, 6.9330560749E+02, 5.6320128566E+02, 6.9493720820E-01],
	[1.55250E+04, 6.6547902697E+03, 5.4681310564E+03, 6.9401452751E+02, 5.6368592189E+02, 6.9507236164E-01],
	[1.55300E+04, 6.6577169449E+03, 5.4677458852E+03, 6.9472394299E+02, 5.6417074760E+02, 6.9520747506E-01],
	[1.55350E+04, 6.6606439646E+03, 5.4673608652E+03, 6.9543385414E+02, 5.6465576268E+02, 6.9534254845E-01],
	[1.55400E+04, 6.6635713285E+03, 5.4669759962E+03, 6.9614426113E+02, 5.6514096702E+02, 6.9547758179E-01],
	[1.55450E+04, 6.6664990367E+03, 5.4665912780E+03, 6.9685516416E+02, 5.6562636052E+02, 6.9561257507E-01],
	[1.55500E+04, 6.6694270891E+03, 5.4662067107E+03, 6.9756656340E+02, 5.6611194307E+02, 6.9574752829E-01],
	[1.55550E+04, 6.6723554855E+03, 5.4658222940E+03, 6.9827845905E+02, 5.6659771456E+02, 6.9588244141E-01],
	[1.55600E+04, 6.6752842260E+03, 5.4654380279E+03, 6.9899085128E+02, 5.6708367489E+02, 6.9601731444E-01],
	[1.55650E+04, 6.6782133104E+03, 5.4650539122E+03, 6.9970374029E+02, 5.6756982393E+02, 6.9615214736E-01],
	[1.55700E+04, 6.6811427387E+03, 5.4646699469E+03, 7.0041712626E+02, 5.6805616160E+02, 6.9628694015E-01],
	[1.55750E+04, 6.6840725108E+03, 5.4642861318E+03, 7.0113100938E+02, 5.6854268778E+02, 6.9642169281E-01],
	[1.55800E+04, 6.6870026266E+03, 5.4639024669E+03, 7.0184538983E+02, 5.6902940236E+02, 6.9655640531E-01],
	[1.55850E+04, 6.6899330861E+03, 5.4635189520E+03, 7.0256026780E+02, 5.6951630524E+02, 6.9669107766E-01],
	[1.55900E+04, 6.6928638892E+03, 5.4631355871E+03, 7.0327564348E+02, 5.7000339630E+02, 6.9682570982E-01],
	[1.55950E+04, 6.6957950359E+03, 5.4627523720E+03, 7.0399151704E+02, 5.7049067544E+02, 6.9696030180E-01],
	[1.56000E+04, 6.6987265260E+03, 5.4623693065E+03, 7.0470788868E+02, 5.7097814255E+02, 6.9709485358E-01],
	[1.56050E+04, 6.7016583595E+03, 5.4619863907E+03, 7.0542475859E+02, 5.7146579753E+02, 6.9722936515E-01],
	[1.56100E+04, 6.7045905363E+03, 5.4616036244E+03, 7.0614212694E+02, 5.7195364025E+02, 6.9736383649E-01],
	[1.56150E+04, 6.7075230563E+03, 5.4612210075E+03, 7.0685999392E+02, 5.7244167062E+02, 6.9749826759E-01],
	[1.56200E+04, 6.7104559196E+03, 5.4608385398E+03, 7.0757835973E+02, 5.7292988853E+02, 6.9763265844E-01],
	[1.56250E+04, 6.7133891259E+03, 5.4604562214E+03, 7.0829722454E+02, 5.7341829386E+02, 6.9776700902E-01],
	[1.56300E+04, 6.7163226753E+03, 5.4600740520E+03, 7.0901658854E+02, 5.7390688651E+02, 6.9790131933E-01],
	[1.56350E+04, 6.7192565677E+03, 5.4596920316E+03, 7.0973645192E+02, 5.7439566636E+02, 6.9803558935E-01],
	[1.56400E+04, 6.7221908030E+03, 5.4593101601E+03, 7.1045681486E+02, 5.7488463332E+02, 6.9816981907E-01],
	[1.56450E+04, 6.7251253811E+03, 5.4589284373E+03, 7.1117767755E+02, 5.7537378726E+02, 6.9830400848E-01],
	[1.56500E+04, 6.7280603020E+03, 5.4585468631E+03, 7.1189904018E+02, 5.7586312809E+02, 6.9843815756E-01],
	[1.56550E+04, 6.7309955656E+03, 5.4581654376E+03, 7.1262090293E+02, 5.7635265569E+02, 6.9857226631E-01],
	[1.56600E+04, 6.7339311717E+03, 5.4577841604E+03, 7.1334326599E+02, 5.7684236994E+02, 6.9870633470E-01],
	[1.56650E+04, 6.7368671205E+03, 5.4574030316E+03, 7.1406612954E+02, 5.7733227075E+02, 6.9884036273E-01],
	[1.56700E+04, 6.7398034117E+03, 5.4570220510E+03, 7.1478949377E+02, 5.7782235800E+02, 6.9897435039E-01],
	[1.56750E+04, 6.7427400454E+03, 5.4566412186E+03, 7.1551335886E+02, 5.7831263158E+02, 6.9910829767E-01],
	[1.56800E+04, 6.7456770214E+03, 5.4562605342E+03, 7.1623772501E+02, 5.7880309138E+02, 6.9924220454E-01],
	[1.56850E+04, 6.7486143397E+03, 5.4558799977E+03, 7.1696259239E+02, 5.7929373730E+02, 6.9937607101E-01],
	[1.56900E+04, 6.7515520001E+03, 5.4554996090E+03, 7.1768796120E+02, 5.7978456921E+02, 6.9950989705E-01],
	[1.56950E+04, 6.7544900028E+03, 5.4551193680E+03, 7.1841383162E+02, 5.8027558701E+02, 6.9964368266E-01],
	[1.57000E+04, 6.7574283475E+03, 5.4547392747E+03, 7.1914020383E+02, 5.8076679059E+02, 6.9977742782E-01],
	[1.57050E+04, 6.7603886609E+03, 5.4543720122E+03, 7.1986707803E+02, 5.8125848376E+02, 6.9991113253E-01],
	[1.57100E+04, 6.7633578607E+03, 5.4540098929E+03, 7.2059445439E+02, 5.8175048333E+02, 7.0004479677E-01],
	[1.57150E+04, 6.7663274192E+03, 5.4536479129E+03, 7.2132233311E+02, 5.8224266949E+02, 7.0017842053E-01],
	[1.57200E+04, 6.7692973362E+03, 5.4532860720E+03, 7.2205071437E+02, 5.8273504211E+02, 7.0031200379E-01],
	[1.57250E+04, 6.7722676118E+03, 5.4529243702E+03, 7.2277959835E+02, 5.8322760110E+02, 7.0044554656E-01],
	[1.57300E+04, 6.7752382457E+03, 5.4525628074E+03, 7.2350898525E+02, 5.8372034633E+02, 7.0057904880E-01],
	[1.57350E+04, 6.7782092379E+03, 5.4522013835E+03, 7.2423887524E+02, 5.8421327771E+02, 7.0071251053E-01],
	[1.57400E+04, 6.7811805884E+03, 5.4518400983E+03, 7.2496926852E+02, 5.8470639512E+02, 7.0084593171E-01],
	[1.57450E+04, 6.7841522971E+03, 5.4514789518E+03, 7.2570016527E+02, 5.8519969845E+02, 7.0097931234E-01],
	[1.57500E+04, 6.7871243639E+03, 5.4511179439E+03, 7.2643156568E+02, 5.8569318760E+02, 7.0111265241E-01],
	[1.57550E+04, 6.7900967887E+03, 5.4507570744E+03, 7.2716346993E+02, 5.8618686244E+02, 7.0124595191E-01],
	[1.57600E+04, 6.7930695716E+03, 5.4503963434E+03, 7.2789587821E+02, 5.8668072288E+02, 7.0137921083E-01],
	[1.57650E+04, 6.7960427123E+03, 5.4500357506E+03, 7.2862879070E+02, 5.8717476879E+02, 7.0151242915E-01],
	[1.57700E+04, 6.7990162109E+03, 5.4496752961E+03, 7.2936220760E+02, 5.8766900008E+02, 7.0164560687E-01],
	[1.57750E+04, 6.8019900672E+03, 5.4493149796E+03, 7.3009612908E+02, 5.8816341663E+02, 7.0177874397E-01],
	[1.57800E+04, 6.8049642813E+03, 5.4489548011E+03, 7.3083055534E+02, 5.8865801832E+02, 7.0191184044E-01],
	[1.57850E+04, 6.8079388529E+03, 5.4485947605E+03, 7.3156548656E+02, 5.8915280505E+02, 7.0204489627E-01],
	[1.57900E+04, 6.8109137821E+03, 5.4482348578E+03, 7.3230092293E+02, 5.8964777671E+02, 7.0217791145E-01],
	[1.57950E+04, 6.8138890688E+03, 5.4478750927E+03, 7.3303686462E+02, 5.9014293318E+02, 7.0231088597E-01],
	[1.58000E+04, 6.8168647130E+03, 5.4475154653E+03, 7.3377331184E+02, 5.9063827436E+02, 7.0244381982E-01],
	[1.58050E+04, 6.8198407144E+03, 5.4471559753E+03, 7.3451026476E+02, 5.9113380013E+02, 7.0257671299E-01],
	[1.58100E+04, 6.8228170731E+03, 5.4467966228E+03, 7.3524772358E+02, 5.9162951038E+02, 7.0270956546E-01],
	[1.58150E+04, 6.8257937891E+03, 5.4464374077E+03, 7.3598568847E+02, 5.9212540500E+02, 7.0284237723E-01],
	[1.58200E+04, 6.8287708622E+03, 5.4460783297E+03, 7.3672415963E+02, 5.9262148388E+02, 7.0297514828E-01],
	[1.58250E+04, 6.8317482923E+03, 5.4457193889E+03, 7.3746313723E+02, 5.9311774690E+02, 7.0310787861E-01],
	[1.58300E+04, 6.8347260794E+03, 5.4453605851E+03, 7.3820262148E+02, 5.9361419396E+02, 7.0324056820E-01],
	[1.58350E+04, 6.8377042235E+03, 5.4450019183E+03, 7.3894261254E+02, 5.9411082494E+02, 7.0337321704E-01],
	[1.58400E+04, 6.8406827244E+03, 5.4446433883E+03, 7.3968311062E+02, 5.9460763973E+02, 7.0350582512E-01],
	[1.58450E+04, 6.8436615821E+03, 5.4442849950E+03, 7.4042411589E+02, 5.9510463822E+02, 7.0363839244E-01],
	[1.58500E+04, 6.8466407965E+03, 5.4439267384E+03, 7.4116562854E+02, 5.9560182030E+02, 7.0377091898E-01],
	[1.58550E+04, 6.8496203676E+03, 5.4435686184E+03, 7.4190764876E+02, 5.9609918585E+02, 7.0390340472E-01],
	[1.58600E+04, 6.8526002952E+03, 5.4432106348E+03, 7.4265017674E+02, 5.9659673476E+02, 7.0403584967E-01],
	[1.58650E+04, 6.8555805793E+03, 5.4428527877E+03, 7.4339321265E+02, 5.9709446692E+02, 7.0416825381E-01],
	[1.58700E+04, 6.8585612199E+03, 5.4424950767E+03, 7.4413675670E+02, 5.9759238222E+02, 7.0430061713E-01],
	[1.58750E+04, 6.8615422169E+03, 5.4421375020E+03, 7.4488080906E+02, 5.9809048054E+02, 7.0443293961E-01],
	[1.58800E+04, 6.8645235701E+03, 5.4417800633E+03, 7.4562536992E+02, 5.9858876177E+02, 7.0456522126E-01],
	[1.58850E+04, 6.8675052795E+03, 5.4414227607E+03, 7.4637043946E+02, 5.9908722579E+02, 7.0469746206E-01],
	[1.58900E+04, 6.8704873452E+03, 5.4410655939E+03, 7.4711601788E+02, 5.9958587250E+02, 7.0482966199E-01],
	[1.58950E+04, 6.8734697669E+03, 5.4407085630E+03, 7.4786210536E+02, 6.0008470178E+02, 7.0496182105E-01],
	[1.59000E+04, 6.8764525446E+03, 5.4403516677E+03, 7.4860870208E+02, 6.0058371352E+02, 7.0509393923E-01],
	[1.59050E+04, 6.8794356783E+03, 5.4399949081E+03, 7.4935580824E+02, 6.0108290760E+02, 7.0522601652E-01],
	[1.59100E+04, 6.8824191678E+03, 5.4396382840E+03, 7.5010342401E+02, 6.0158228391E+02, 7.0535805291E-01],
	[1.59150E+04, 6.8854030132E+03, 5.4392817953E+03, 7.5085154959E+02, 6.0208184234E+02, 7.0549004839E-01],
	[1.59200E+04, 6.8883872143E+03, 5.4389254419E+03, 7.5160018516E+02, 6.0258158278E+02, 7.0562200294E-01],
	[1.59250E+04, 6.8913717710E+03, 5.4385692238E+03, 7.5234933091E+02, 6.0308150510E+02, 7.0575391657E-01],
	[1.59300E+04, 6.8943566834E+03, 5.4382131408E+03, 7.5309898703E+02, 6.0358160920E+02, 7.0588578925E-01],
	[1.59350E+04, 6.8973419513E+03, 5.4378571929E+03, 7.5384915369E+02, 6.0408189496E+02, 7.0601762098E-01],
	[1.59400E+04, 6.9003275747E+03, 5.4375013799E+03, 7.5459983109E+02, 6.0458236226E+02, 7.0614941176E-01],
	[1.59450E+04, 6.9033135534E+03, 5.4371457018E+03, 7.5535101942E+02, 6.0508301100E+02, 7.0628116156E-01],
	[1.59500E+04, 6.9062998875E+03, 5.4367901585E+03, 7.5610271886E+02, 6.0558384106E+02, 7.0641287037E-01],
	[1.59550E+04, 6.9092865769E+03, 5.4364347498E+03, 7.5685492959E+02, 6.0608485232E+02, 7.0654453819E-01],
	[1.59600E+04, 6.9122736214E+03, 5.4360794757E+03, 7.5760765181E+02, 6.0658604467E+02, 7.0667616499E-01],
	[1.59650E+04, 6.9152610210E+03, 5.4357243362E+03, 7.5836088570E+02, 6.0708741800E+02, 7.0680775077E-01],
	[1.59700E+04, 6.9182487757E+03, 5.4353693310E+03, 7.5911463145E+02, 6.0758897219E+02, 7.0693929552E-01],
	[1.59750E+04, 6.9212368854E+03, 5.4350144601E+03, 7.5986888924E+02, 6.0809070712E+02, 7.0707079921E-01],
	[1.59800E+04, 6.9242253500E+03, 5.4346597234E+03, 7.6062365925E+02, 6.0859262268E+02, 7.0720226185E-01],
	[1.59850E+04, 6.9272141694E+03, 5.4343051209E+03, 7.6137894169E+02, 6.0909471876E+02, 7.0733368341E-01],
	[1.59900E+04, 6.9302033436E+03, 5.4339506523E+03, 7.6213473673E+02, 6.0959699524E+02, 7.0746506388E-01],
	[1.59950E+04, 6.9331928725E+03, 5.4335963177E+03, 7.6289104456E+02, 6.1009945200E+02, 7.0759640326E-01],
	[1.60000E+04, 6.9361827560E+03, 5.4332421170E+03, 7.6364786536E+02, 6.1060208893E+02, 7.0772770153E-01],
	[1.60050E+04, 6.9391729941E+03, 5.4328880500E+03, 7.6440519933E+02, 6.1110490592E+02, 7.0785895868E-01],
	[1.60100E+04, 6.9421635867E+03, 5.4325341166E+03, 7.6516304665E+02, 6.1160790284E+02, 7.0799017469E-01],
	[1.60150E+04, 6.9451545338E+03, 5.4321803168E+03, 7.6592140750E+02, 6.1211107959E+02, 7.0812134956E-01],
	[1.60200E+04, 6.9481458352E+03, 5.4318266505E+03, 7.6668028208E+02, 6.1261443605E+02, 7.0825248327E-01],
	[1.60250E+04, 6.9511374908E+03, 5.4314731176E+03, 7.6743967056E+02, 6.1311797209E+02, 7.0838357582E-01],
	[1.60300E+04, 6.9541295007E+03, 5.4311197180E+03, 7.6819957315E+02, 6.1362168761E+02, 7.0851462718E-01],
	[1.60350E+04, 6.9571218648E+03, 5.4307664515E+03, 7.6895999001E+02, 6.1412558249E+02, 7.0864563735E-01],
	[1.60400E+04, 6.9601145829E+03, 5.4304133182E+03, 7.6972092134E+02, 6.1462965662E+02, 7.0877660631E-01],
	[1.60450E+04, 6.9631076551E+03, 5.4300603179E+03, 7.7048236734E+02, 6.1513390987E+02, 7.0890753406E-01],
	[1.60500E+04, 6.9661010812E+03, 5.4297074505E+03, 7.7124432817E+02, 6.1563834213E+02, 7.0903842059E-01],
	[1.60550E+04, 6.9690948612E+03, 5.4293547159E+03, 7.7200680403E+02, 6.1614295328E+02, 7.0916926587E-01],
	[1.60600E+04, 6.9720889950E+03, 5.4290021141E+03, 7.7276979511E+02, 6.1664774322E+02, 7.0930006990E-01],
	[1.60650E+04, 6.9750834826E+03, 5.4286496449E+03, 7.7353330159E+02, 6.1715271181E+02, 7.0943083267E-01],
	[1.60700E+04, 6.9780783238E+03, 5.4282973082E+03, 7.7429732367E+02, 6.1765785895E+02, 7.0956155417E-01],
	[1.60750E+04, 6.9810735186E+03, 5.4279451041E+03, 7.7506186151E+02, 6.1816318451E+02, 7.0969223439E-01],
	[1.60800E+04, 6.9840690670E+03, 5.4275930323E+03, 7.7582691533E+02, 6.1866868838E+02, 7.0982287330E-01],
	[1.60850E+04, 6.9870649688E+03, 5.4272410928E+03, 7.7659248529E+02, 6.1917437045E+02, 7.0995347092E-01],
	[1.60900E+04, 6.9900612240E+03, 5.4268892855E+03, 7.7735857159E+02, 6.1968023059E+02, 7.1008402721E-01],
	[1.60950E+04, 6.9930578326E+03, 5.4265376103E+03, 7.7812517441E+02, 6.2018626870E+02, 7.1021454217E-01],
	[1.61000E+04, 6.9960547945E+03, 5.4261860671E+03, 7.7889229394E+02, 6.2069248464E+02, 7.1034501579E-01],
	[1.61050E+04, 6.9990521095E+03, 5.4258346558E+03, 7.7965993037E+02, 6.2119887830E+02, 7.1047544807E-01],
	[1.61100E+04, 7.0020497777E+03, 5.4254833763E+03, 7.8042808389E+02, 6.2170544958E+02, 7.1060583897E-01],
	[1.61150E+04, 7.0050477989E+03, 5.4251322286E+03, 7.8119675467E+02, 6.2221219834E+02, 7.1073618851E-01],
	[1.61200E+04, 7.0080461731E+03, 5.4247812126E+03, 7.8196594291E+02, 6.2271912447E+02, 7.1086649666E-01],
	[1.61250E+04, 7.0110449003E+03, 5.4244303281E+03, 7.8273564880E+02, 6.2322622786E+02, 7.1099676341E-01],
	[1.61300E+04, 7.0140439803E+03, 5.4240795750E+03, 7.8350587252E+02, 6.2373350838E+02, 7.1112698876E-01],
	[1.61350E+04, 7.0170434131E+03, 5.4237289534E+03, 7.8427661426E+02, 6.2424096591E+02, 7.1125717269E-01],
	[1.61400E+04, 7.0200431986E+03, 5.4233784630E+03, 7.8504787420E+02, 6.2474860035E+02, 7.1138731520E-01],
	[1.61450E+04, 7.0230433368E+03, 5.4230281039E+03, 7.8581965253E+02, 6.2525641157E+02, 7.1151741626E-01],
	[1.61500E+04, 7.0260438275E+03, 5.4226778758E+03, 7.8659194944E+02, 6.2576439945E+02, 7.1164747588E-01],
	[1.61550E+04, 7.0290446708E+03, 5.4223277788E+03, 7.8736476512E+02, 6.2627256387E+02, 7.1177749403E-01],
	[1.61600E+04, 7.0320458665E+03, 5.4219778127E+03, 7.8813809975E+02, 6.2678090472E+02, 7.1190747072E-01],
	[1.61650E+04, 7.0350474147E+03, 5.4216279775E+03, 7.8891195352E+02, 6.2728942187E+02, 7.1203740592E-01],
	[1.61700E+04, 7.0380493151E+03, 5.4212782730E+03, 7.8968632661E+02, 6.2779811521E+02, 7.1216729964E-01],
	[1.61750E+04, 7.0410515678E+03, 5.4209286991E+03, 7.9046121922E+02, 6.2830698462E+02, 7.1229715185E-01],
	[1.61800E+04, 7.0440541726E+03, 5.4205792559E+03, 7.9123663153E+02, 6.2881602999E+02, 7.1242696255E-01],
	[1.61850E+04, 7.0470571296E+03, 5.4202299431E+03, 7.9201256373E+02, 6.2932525118E+02, 7.1255673172E-01],
	[1.61900E+04, 7.0500604386E+03, 5.4198807607E+03, 7.9278901600E+02, 6.2983464808E+02, 7.1268645937E-01],
	[1.61950E+04, 7.0530640996E+03, 5.4195317086E+03, 7.9356598853E+02, 6.3034422058E+02, 7.1281614547E-01],
	[1.62000E+04, 7.0560681125E+03, 5.4191827868E+03, 7.9434348151E+02, 6.3085396855E+02, 7.1294579002E-01],
	[1.62050E+04, 7.0590724773E+03, 5.4188339950E+03, 7.9512149512E+02, 6.3136389188E+02, 7.1307539300E-01],
	[1.62100E+04, 7.0620771938E+03, 5.4184853334E+03, 7.9590002955E+02, 6.3187399044E+02, 7.1320495441E-01],
	[1.62150E+04, 7.0650822621E+03, 5.4181368016E+03, 7.9667908500E+02, 6.3238426412E+02, 7.1333447424E-01],
	[1.62200E+04, 7.0680876819E+03, 5.4177883998E+03, 7.9745866164E+02, 6.3289471279E+02, 7.1346395247E-01],
	[1.62250E+04, 7.0710934534E+03, 5.4174401277E+03, 7.9823875966E+02, 6.3340533633E+02, 7.1359338910E-01],
	[1.62300E+04, 7.0740995763E+03, 5.4170919852E+03, 7.9901937926E+02, 6.3391613463E+02, 7.1372278411E-01],
	[1.62350E+04, 7.0771060507E+03, 5.4167439724E+03, 7.9980052061E+02, 6.3442710757E+02, 7.1385213750E-01],
	[1.62400E+04, 7.0801128765E+03, 5.4163960891E+03, 8.0058218390E+02, 6.3493825503E+02, 7.1398144926E-01],
	[1.62450E+04, 7.0831200536E+03, 5.4160483353E+03, 8.0136436933E+02, 6.3544957687E+02, 7.1411071938E-01],
	[1.62500E+04, 7.0861275819E+03, 5.4157007107E+03, 8.0214707707E+02, 6.3596107300E+02, 7.1423994784E-01],
	[1.62550E+04, 7.0891354614E+03, 5.4153532154E+03, 8.0293030732E+02, 6.3647274328E+02, 7.1436913464E-01],
	[1.62600E+04, 7.0921436920E+03, 5.4150058493E+03, 8.0371406026E+02, 6.3698458759E+02, 7.1449827976E-01],
	[1.62650E+04, 7.0951522736E+03, 5.4146586122E+03, 8.0449833608E+02, 6.3749660582E+02, 7.1462738321E-01],
	[1.62700E+04, 7.0981612062E+03, 5.4143115041E+03, 8.0528313496E+02, 6.3800879784E+02, 7.1475644496E-01],
	[1.62750E+04, 7.1011704897E+03, 5.4139645249E+03, 8.0606845710E+02, 6.3852116353E+02, 7.1488546501E-01],
	[1.62800E+04, 7.1041801241E+03, 5.4136176746E+03, 8.0685430268E+02, 6.3903370278E+02, 7.1501444336E-01],
	[1.62850E+04, 7.1071901092E+03, 5.4132709529E+03, 8.0764067189E+02, 6.3954641545E+02, 7.1514337998E-01],
	[1.62900E+04, 7.1102004450E+03, 5.4129243599E+03, 8.0842756491E+02, 6.4005930144E+02, 7.1527227487E-01],
	[1.62950E+04, 7.1132111314E+03, 5.4125778954E+03, 8.0921498194E+02, 6.4057236061E+02, 7.1540112802E-01],
	[1.63000E+04, 7.1162221685E+03, 5.4122315594E+03, 8.1000292315E+02, 6.4108559285E+02, 7.1552993943E-01],
	[1.63050E+04, 7.1192335560E+03, 5.4118853517E+03, 8.1079138874E+02, 6.4159899804E+02, 7.1565870907E-01],
	[1.63100E+04, 7.1222452939E+03, 5.4115392724E+03, 8.1158037890E+02, 6.4211257605E+02, 7.1578743695E-01],
	[1.63150E+04, 7.1252573823E+03, 5.4111933212E+03, 8.1236989380E+02, 6.4262632677E+02, 7.1591612306E-01],
	[1.63200E+04, 7.1282698209E+03, 5.4108474982E+03, 8.1315993364E+02, 6.4314025006E+02, 7.1604476738E-01],
	[1.63250E+04, 7.1312826098E+03, 5.4105018032E+03, 8.1395049861E+02, 6.4365434582E+02, 7.1617336990E-01],
	[1.63300E+04, 7.1343108530E+03, 5.4101640752E+03, 8.1474158889E+02, 6.4416884819E+02, 7.1630193062E-01],
	[1.63350E+04, 7.1373571757E+03, 5.4098356644E+03, 8.1553320466E+02, 6.4468379849E+02, 7.1643044953E-01],
	[1.63400E+04, 7.1404038663E+03, 5.4095073742E+03, 8.1632534613E+02, 6.4519892216E+02, 7.1655892662E-01],
	[1.63450E+04, 7.1434509247E+03, 5.4091792042E+03, 8.1711801346E+02, 6.4571421908E+02, 7.1668736188E-01],
	[1.63500E+04, 7.1464983508E+03, 5.4088511546E+03, 8.1791120686E+02, 6.4622968913E+02, 7.1681575530E-01],
	[1.63550E+04, 7.1495461446E+03, 5.4085232251E+03, 8.1870492651E+02, 6.4674533218E+02, 7.1694410687E-01],
	[1.63600E+04, 7.1525943059E+03, 5.4081954158E+03, 8.1949917259E+02, 6.4726114813E+02, 7.1707241658E-01],
	[1.63650E+04, 7.1556428348E+03, 5.4078677264E+03, 8.2029394530E+02, 6.4777713684E+02, 7.1720068443E-01],
	[1.63700E+04, 7.1586917311E+03, 5.4075401571E+03, 8.2108924481E+02, 6.4829329819E+02, 7.1732891040E-01],
	[1.63750E+04, 7.1617409949E+03, 5.4072127076E+03, 8.2188507133E+02, 6.4880963207E+02, 7.1745709449E-01],
	[1.63800E+04, 7.1647906259E+03, 5.4068853778E+03, 8.2268142502E+02, 6.4932613836E+02, 7.1758523669E-01],
	[1.63850E+04, 7.1678406242E+03, 5.4065581678E+03, 8.2347830609E+02, 6.4984281692E+02, 7.1771333699E-01],
	[1.63900E+04, 7.1708909896E+03, 5.4062310775E+03, 8.2427571472E+02, 6.5035966764E+02, 7.1784139539E-01],
	[1.63950E+04, 7.1739417222E+03, 5.4059041066E+03, 8.2507365109E+02, 6.5087669041E+02, 7.1796941186E-01],
	[1.64000E+04, 7.1769928218E+03, 5.4055772553E+03, 8.2587211540E+02, 6.5139388509E+02, 7.1809738641E-01],
	[1.64050E+04, 7.1800442884E+03, 5.4052505233E+03, 8.2667110783E+02, 6.5191125156E+02, 7.1822531902E-01],
	[1.64100E+04, 7.1830961219E+03, 5.4049239106E+03, 8.2747062857E+02, 6.5242878971E+02, 7.1835320969E-01],
	[1.64150E+04, 7.1861483222E+03, 5.4045974172E+03, 8.2827067780E+02, 6.5294649942E+02, 7.1848105842E-01],
	[1.64200E+04, 7.1892008893E+03, 5.4042710429E+03, 8.2907125571E+02, 6.5346438055E+02, 7.1860886518E-01],
	[1.64250E+04, 7.1922538232E+03, 5.4039447877E+03, 8.2987236250E+02, 6.5398243299E+02, 7.1873662997E-01],
	[1.64300E+04, 7.1953071236E+03, 5.4036186514E+03, 8.3067399834E+02, 6.5450065662E+02, 7.1886435279E-01],
	[1.64350E+04, 7.1983607907E+03, 5.4032926341E+03, 8.3147616343E+02, 6.5501905131E+02, 7.1899203363E-01],
	[1.64400E+04, 7.2014148242E+03, 5.4029667356E+03, 8.3227885795E+02, 6.5553761694E+02, 7.1911967247E-01],
	[1.64450E+04, 7.2044692242E+03, 5.4026409559E+03, 8.3308208210E+02, 6.5605635339E+02, 7.1924726932E-01],
	[1.64500E+04, 7.2075239905E+03, 5.4023152948E+03, 8.3388583605E+02, 6.5657526054E+02, 7.1937482415E-01],
	[1.64550E+04, 7.2105791232E+03, 5.4019897523E+03, 8.3469011999E+02, 6.5709433826E+02, 7.1950233698E-01],
	[1.64600E+04, 7.2136346220E+03, 5.4016643283E+03, 8.3549493411E+02, 6.5761358644E+02, 7.1962980777E-01],
	[1.64650E+04, 7.2166904871E+03, 5.4013390228E+03, 8.3630027861E+02, 6.5813300494E+02, 7.1975723654E-01],
	[1.64700E+04, 7.2197467182E+03, 5.4010138356E+03, 8.3710615366E+02, 6.5865259365E+02, 7.1988462326E-01],
	[1.64750E+04, 7.2228033154E+03, 5.4006887667E+03, 8.3791255946E+02, 6.5917235244E+02, 7.2001196794E-01],
	[1.64800E+04, 7.2258602785E+03, 5.4003638160E+03, 8.3871949619E+02, 6.5969228119E+02, 7.2013927057E-01],
	[1.64850E+04, 7.2289176076E+03, 5.4000389834E+03, 8.3952696404E+02, 6.6021237978E+02, 7.2026653113E-01],
	[1.64900E+04, 7.2319753024E+03, 5.3997142688E+03, 8.4033496319E+02, 6.6073264809E+02, 7.2039374962E-01],
	[1.64950E+04, 7.2350333631E+03, 5.3993896722E+03, 8.4114349384E+02, 6.6125308598E+02, 7.2052092603E-01],
	[1.65000E+04, 7.2380917894E+03, 5.3990651935E+03, 8.4195255617E+02, 6.6177369335E+02, 7.2064806035E-01],
	[1.65050E+04, 7.2411505814E+03, 5.3987408326E+03, 8.4276215037E+02, 6.6229447005E+02, 7.2077515259E-01],
	[1.65100E+04, 7.2442097389E+03, 5.3984165894E+03, 8.4357227663E+02, 6.6281541598E+02, 7.2090220272E-01],
	[1.65150E+04, 7.2472692619E+03, 5.3980924639E+03, 8.4438293513E+02, 6.6333653100E+02, 7.2102921074E-01],
	[1.65200E+04, 7.2503291503E+03, 5.3977684559E+03, 8.4519412606E+02, 6.6385781500E+02, 7.2115617665E-01],
	[1.65250E+04, 7.2533894041E+03, 5.3974445654E+03, 8.4600584961E+02, 6.6437926784E+02, 7.2128310043E-01],
	[1.65300E+04, 7.2564500232E+03, 5.3971207923E+03, 8.4681810597E+02, 6.6490088942E+02, 7.2140998208E-01],
	[1.65350E+04, 7.2595110075E+03, 5.3967971366E+03, 8.4763089533E+02, 6.6542267959E+02, 7.2153682160E-01],
	[1.65400E+04, 7.2625723570E+03, 5.3964735981E+03, 8.4844421786E+02, 6.6594463824E+02, 7.2166361897E-01],
	[1.65450E+04, 7.2656340716E+03, 5.3961501768E+03, 8.4925807377E+02, 6.6646676524E+02, 7.2179037419E-01],
	[1.65500E+04, 7.2686961512E+03, 5.3958268726E+03, 8.5007246323E+02, 6.6698906048E+02, 7.2191708725E-01],
	[1.65550E+04, 7.2717585958E+03, 5.3955036854E+03, 8.5088738644E+02, 6.6751152382E+02, 7.2204375814E-01],
	[1.65600E+04, 7.2748214052E+03, 5.3951806151E+03, 8.5170284358E+02, 6.6803415514E+02, 7.2217038685E-01],
	[1.65650E+04, 7.2778845795E+03, 5.3948576618E+03, 8.5251883484E+02, 6.6855695431E+02, 7.2229697339E-01],
	[1.65700E+04, 7.2809481185E+03, 5.3945348252E+03, 8.5333536041E+02, 6.6907992122E+02, 7.2242351774E-01],
	[1.65750E+04, 7.2840120223E+03, 5.3942121053E+03, 8.5415242047E+02, 6.6960305573E+02, 7.2255001989E-01],
	[1.65800E+04, 7.2870762906E+03, 5.3938895021E+03, 8.5497001522E+02, 6.7012635772E+02, 7.2267647984E-01],
	[1.65850E+04, 7.2901409235E+03, 5.3935670154E+03, 8.5578814483E+02, 6.7064982708E+02, 7.2280289759E-01],
	[1.65900E+04, 7.2932059210E+03, 5.3932446452E+03, 8.5660680951E+02, 6.7117346366E+02, 7.2292927311E-01],
	[1.65950E+04, 7.2962712828E+03, 5.3929223914E+03, 8.5742600943E+02, 6.7169726735E+02, 7.2305560642E-01],
	[1.66000E+04, 7.2993370090E+03, 5.3926002539E+03, 8.5824574478E+02, 6.7222123803E+02, 7.2318189749E-01],
	[1.66050E+04, 7.3024030995E+03, 5.3922782326E+03, 8.5906601575E+02, 6.7274537556E+02, 7.2330814633E-01],
	[1.66100E+04, 7.3054695542E+03, 5.3919563276E+03, 8.5988682254E+02, 6.7326967982E+02, 7.2343435293E-01],
	[1.66150E+04, 7.3085363731E+03, 5.3916345386E+03, 8.6070816532E+02, 6.7379415069E+02, 7.2356051727E-01],
	[1.66200E+04, 7.3116035561E+03, 5.3913128657E+03, 8.6153004428E+02, 6.7431878804E+02, 7.2368663937E-01],
	[1.66250E+04, 7.3146711031E+03, 5.3909913087E+03, 8.6235245961E+02, 6.7484359174E+02, 7.2381271919E-01],
	[1.66300E+04, 7.3177390140E+03, 5.3906698675E+03, 8.6317541151E+02, 6.7536856168E+02, 7.2393875675E-01],
	[1.66350E+04, 7.3208072889E+03, 5.3903485422E+03, 8.6399890015E+02, 6.7589369772E+02, 7.2406475203E-01],
	[1.66400E+04, 7.3238759276E+03, 5.3900273325E+03, 8.6482292573E+02, 6.7641899974E+02, 7.2419070504E-01],
	[1.66450E+04, 7.3269449300E+03, 5.3897062385E+03, 8.6564748843E+02, 6.7694446761E+02, 7.2431661575E-01],
	[1.66500E+04, 7.3300142962E+03, 5.3893852601E+03, 8.6647258844E+02, 6.7747010121E+02, 7.2444248417E-01],
	[1.66550E+04, 7.3330840259E+03, 5.3890643971E+03, 8.6729822595E+02, 6.7799590040E+02, 7.2456831028E-01],
	[1.66600E+04, 7.3361541193E+03, 5.3887436496E+03, 8.6812440114E+02, 6.7852186508E+02, 7.2469409409E-01],
	[1.66650E+04, 7.3392245761E+03, 5.3884230173E+03, 8.6895111421E+02, 6.7904799510E+02, 7.2481983559E-01],
	[1.66700E+04, 7.3422953964E+03, 5.3881025004E+03, 8.6977836534E+02, 6.7957429034E+02, 7.2494553476E-01],
	[1.66750E+04, 7.3453665800E+03, 5.3877820986E+03, 8.7060615472E+02, 6.8010075068E+02, 7.2507119161E-01],
	[1.66800E+04, 7.3484381270E+03, 5.3874618119E+03, 8.7143448254E+02, 6.8062737599E+02, 7.2519680612E-01],
	[1.66850E+04, 7.3515100372E+03, 5.3871416402E+03, 8.7226334898E+02, 6.8115416614E+02, 7.2532237830E-01],
	[1.66900E+04, 7.3545823105E+03, 5.3868215835E+03, 8.7309275424E+02, 6.8168112101E+02, 7.2544790814E-01],
	[1.66950E+04, 7.3576549470E+03, 5.3865016417E+03, 8.7392269849E+02, 6.8220824046E+02, 7.2557339562E-01],
	[1.67000E+04, 7.3607279464E+03, 5.3861818146E+03, 8.7475318193E+02, 6.8273552438E+02, 7.2569884074E-01],
	[1.67050E+04, 7.3638013089E+03, 5.3858621023E+03, 8.7558420475E+02, 6.8326297264E+02, 7.2582424351E-01],
	[1.67100E+04, 7.3668750343E+03, 5.3855425046E+03, 8.7641576714E+02, 6.8379058510E+02, 7.2594960390E-01],
	[1.67150E+04, 7.3699491225E+03, 5.3852230215E+03, 8.7724786927E+02, 6.8431836165E+02, 7.2607492192E-01],
	[1.67200E+04, 7.3730235734E+03, 5.3849036529E+03, 8.7808051135E+02, 6.8484630215E+02, 7.2620019757E-01],
	[1.67250E+04, 7.3760983871E+03, 5.3845843987E+03, 8.7891369355E+02, 6.8537440648E+02, 7.2632543082E-01],
	[1.67300E+04, 7.3791735635E+03, 5.3842652589E+03, 8.7974741607E+02, 6.8590267450E+02, 7.2645062168E-01],
	[1.67350E+04, 7.3822491024E+03, 5.3839462333E+03, 8.8058167910E+02, 6.8643110611E+02, 7.2657577013E-01],
	[1.67400E+04, 7.3853250038E+03, 5.3836273220E+03, 8.8141648281E+02, 6.8695970115E+02, 7.2670087617E-01],
	[1.67450E+04, 7.3884012676E+03, 5.3833085247E+03, 8.8225182740E+02, 6.8748845952E+02, 7.2682593979E-01],
	[1.67500E+04, 7.3914778939E+03, 5.3829898416E+03, 8.8308771306E+02, 6.8801738107E+02, 7.2695096098E-01],
	[1.67550E+04, 7.3945548824E+03, 5.3826712723E+03, 8.8392413998E+02, 6.8854646569E+02, 7.2707593973E-01],
	[1.67600E+04, 7.3976322332E+03, 5.3823528170E+03, 8.8476110834E+02, 6.8907571324E+02, 7.2720087603E-01],
	[1.67650E+04, 7.4007099462E+03, 5.3820344755E+03, 8.8559861833E+02, 6.8960512360E+02, 7.2732576989E-01],
	[1.67700E+04, 7.4037880213E+03, 5.3817162478E+03, 8.8643667014E+02, 6.9013469664E+02, 7.2745062128E-01],
	[1.67750E+04, 7.4068664585E+03, 5.3813981337E+03, 8.8727526395E+02, 6.9066443223E+02, 7.2757543021E-01],
	[1.67800E+04, 7.4099452576E+03, 5.3810801332E+03, 8.8811439997E+02, 6.9119433025E+02, 7.2770019666E-01],
	[1.67850E+04, 7.4130244187E+03, 5.3807622462E+03, 8.8895407836E+02, 6.9172439055E+02, 7.2782492062E-01],
	[1.67900E+04, 7.4161039416E+03, 5.3804444727E+03, 8.8979429933E+02, 6.9225461303E+02, 7.2794960209E-01],
	[1.67950E+04, 7.4191838264E+03, 5.3801268126E+03, 8.9063506305E+02, 6.9278499754E+02, 7.2807424107E-01],
	[1.68000E+04, 7.4222640728E+03, 5.3798092658E+03, 8.9147636972E+02, 6.9331554397E+02, 7.2819883754E-01],
	[1.68050E+04, 7.4253446809E+03, 5.3794918322E+03, 8.9231821953E+02, 6.9384625217E+02, 7.2832339149E-01],
	[1.68100E+04, 7.4284256506E+03, 5.3791745117E+03, 8.9316061265E+02, 6.9437712203E+02, 7.2844790292E-01],
	[1.68150E+04, 7.4315069818E+03, 5.3788573044E+03, 8.9400354929E+02, 6.9490815341E+02, 7.2857237182E-01],
	[1.68200E+04, 7.4345886745E+03, 5.3785402100E+03, 8.9484702963E+02, 6.9543934619E+02, 7.2869679819E-01],
	[1.68250E+04, 7.4376707286E+03, 5.3782232286E+03, 8.9569105386E+02, 6.9597070023E+02, 7.2882118201E-01],
	[1.68300E+04, 7.4407531441E+03, 5.3779063600E+03, 8.9653562216E+02, 6.9650221541E+02, 7.2894552328E-01],
	[1.68350E+04, 7.4438359208E+03, 5.3775896042E+03, 8.9738073472E+02, 6.9703389160E+02, 7.2906982200E-01],
	[1.68400E+04, 7.4469190587E+03, 5.3772729611E+03, 8.9822639174E+02, 6.9756572867E+02, 7.2919407814E-01],
	[1.68450E+04, 7.4500025578E+03, 5.3769564307E+03, 8.9907259340E+02, 6.9809772649E+02, 7.2931829172E-01],
	[1.68500E+04, 7.4530864179E+03, 5.3766400128E+03, 8.9991933988E+02, 6.9862988493E+02, 7.2944246271E-01],
	[1.68550E+04, 7.4561706390E+03, 5.3763237075E+03, 9.0076663138E+02, 6.9916220387E+02, 7.2956659112E-01],
	[1.68600E+04, 7.4592552211E+03, 5.3760075145E+03, 9.0161446808E+02, 6.9969468316E+02, 7.2969067693E-01],
	[1.68650E+04, 7.4623401641E+03, 5.3756914339E+03, 9.0246285017E+02, 7.0022732269E+02, 7.2981472015E-01],
	[1.68700E+04, 7.4654254679E+03, 5.3753754655E+03, 9.0331177784E+02, 7.0076012233E+02, 7.2993872075E-01],
	[1.68750E+04, 7.4685111324E+03, 5.3750596094E+03, 9.0416125129E+02, 7.0129308193E+02, 7.3006267874E-01],
	[1.68800E+04, 7.4715971576E+03, 5.3747438653E+03, 9.0501127068E+02, 7.0182620139E+02, 7.3018659411E-01],
	[1.68850E+04, 7.4746835435E+03, 5.3744282334E+03, 9.0586183622E+02, 7.0235948055E+02, 7.3031046685E-01],
	[1.68900E+04, 7.4777702899E+03, 5.3741127134E+03, 9.0671294810E+02, 7.0289291930E+02, 7.3043429695E-01],
	[1.68950E+04, 7.4808573968E+03, 5.3737973053E+03, 9.0756460649E+02, 7.0342651751E+02, 7.3055808442E-01],
	[1.69000E+04, 7.4839448641E+03, 5.3734820090E+03, 9.0841681160E+02, 7.0396027504E+02, 7.3068182923E-01],
	[1.69050E+04, 7.4870326918E+03, 5.3731668245E+03, 9.0926956360E+02, 7.0449419177E+02, 7.3080553139E-01],
	[1.69100E+04, 7.4901208798E+03, 5.3728517517E+03, 9.1012286268E+02, 7.0502826756E+02, 7.3092919088E-01],
	[1.69150E+04, 7.4932094280E+03, 5.3725367905E+03, 9.1097670904E+02, 7.0556250228E+02, 7.3105280771E-01],
	[1.69200E+04, 7.4962983364E+03, 5.3722219409E+03, 9.1183110287E+02, 7.0609689581E+02, 7.3117638186E-01],
	[1.69250E+04, 7.4993876049E+03, 5.3719072027E+03, 9.1268604434E+02, 7.0663144802E+02, 7.3129991333E-01],
	[1.69300E+04, 7.5024772335E+03, 5.3715925759E+03, 9.1354153364E+02, 7.0716615876E+02, 7.3142340212E-01],
	[1.69350E+04, 7.5055672220E+03, 5.3712780604E+03, 9.1439757098E+02, 7.0770102792E+02, 7.3154684820E-01],
	[1.69400E+04, 7.5086575704E+03, 5.3709636562E+03, 9.1525415653E+02, 7.0823605536E+02, 7.3167025159E-01],
	[1.69450E+04, 7.5117482787E+03, 5.3706493632E+03, 9.1611129048E+02, 7.0877124096E+02, 7.3179361227E-01],
	[1.69500E+04, 7.5148393468E+03, 5.3703351813E+03, 9.1696897303E+02, 7.0930658457E+02, 7.3191693024E-01],
	[1.69550E+04, 7.5179307746E+03, 5.3700211104E+03, 9.1782720435E+02, 7.0984208607E+02, 7.3204020549E-01],
	[1.69600E+04, 7.5210225620E+03, 5.3697071505E+03, 9.1868598464E+02, 7.1037774533E+02, 7.3216343801E-01],
	[1.69650E+04, 7.5241147091E+03, 5.3693933015E+03, 9.1954531409E+02, 7.1091356222E+02, 7.3228662780E-01],
	[1.69700E+04, 7.5272072156E+03, 5.3690795633E+03, 9.2040519288E+02, 7.1144953661E+02, 7.3240977485E-01],
	[1.69750E+04, 7.5303000816E+03, 5.3687659358E+03, 9.2126562120E+02, 7.1198566836E+02, 7.3253287916E-01],
	[1.69800E+04, 7.5334006760E+03, 5.3684558182E+03, 9.2212659924E+02, 7.1252208315E+02, 7.3265594071E-01],
	[1.69850E+04, 7.5365298488E+03, 5.3681588187E+03, 9.2298812720E+02, 7.1305913744E+02, 7.3277895951E-01],
	[1.69900E+04, 7.5396593997E+03, 5.3678619231E+03, 9.2385020525E+02, 7.1359635012E+02, 7.3290193555E-01],
	[1.69950E+04, 7.5427893287E+03, 5.3675651312E+03, 9.2471283358E+02, 7.1413372107E+02, 7.3302486882E-01],
	[1.70000E+04, 7.5459196357E+03, 5.3672684431E+03, 9.2557601239E+02, 7.1467125016E+02, 7.3314775932E-01],
	[1.70050E+04, 7.5490503208E+03, 5.3669718586E+03, 9.2643974186E+02, 7.1520893724E+02, 7.3327060704E-01],
	[1.70100E+04, 7.5521813837E+03, 5.3666753776E+03, 9.2730402219E+02, 7.1574678221E+02, 7.3339341197E-01],
	[1.70150E+04, 7.5553128246E+03, 5.3663790002E+03, 9.2816885355E+02, 7.1628478491E+02, 7.3351617411E-01],
	[1.70200E+04, 7.5584446432E+03, 5.3660827262E+03, 9.2903423614E+02, 7.1682294523E+02, 7.3363889346E-01],
	[1.70250E+04, 7.5615768395E+03, 5.3657865556E+03, 9.2990017015E+02, 7.1736126303E+02, 7.3376157000E-01],
	[1.70300E+04, 7.5647094134E+03, 5.3654904883E+03, 9.3076665576E+02, 7.1789973819E+02, 7.3388420373E-01],
	[1.70350E+04, 7.5678423650E+03, 5.3651945242E+03, 9.3163369316E+02, 7.1843837057E+02, 7.3400679465E-01],
	[1.70400E+04, 7.5709756941E+03, 5.3648986633E+03, 9.3250128255E+02, 7.1897716003E+02, 7.3412934276E-01],
	[1.70450E+04, 7.5741094006E+03, 5.3646029055E+03, 9.3336942410E+02, 7.1951610646E+02, 7.3425184803E-01],
	[1.70500E+04, 7.5772434846E+03, 5.3643072508E+03, 9.3423811801E+02, 7.2005520972E+02, 7.3437431048E-01],
	[1.70550E+04, 7.5803779458E+03, 5.3640116990E+03, 9.3510736447E+02, 7.2059446968E+02, 7.3449673009E-01],
	[1.70600E+04, 7.5835127843E+03, 5.3637162502E+03, 9.3597716366E+02, 7.2113388620E+02, 7.3461910686E-01],
	[1.70650E+04, 7.5866480001E+03, 5.3634209041E+03, 9.3684751578E+02, 7.2167345917E+02, 7.3474144079E-01],
	[1.70700E+04, 7.5897835929E+03, 5.3631256609E+03, 9.3771842101E+02, 7.2221318844E+02, 7.3486373186E-01],
	[1.70750E+04, 7.5929195628E+03, 5.3628305204E+03, 9.3858987954E+02, 7.2275307388E+02, 7.3498598007E-01],
	[1.70800E+04, 7.5960559098E+03, 5.3625354825E+03, 9.3946189156E+02, 7.2329311537E+02, 7.3510818543E-01],
	[1.70850E+04, 7.5991926336E+03, 5.3622405472E+03, 9.4033445725E+02, 7.2383331277E+02, 7.3523034792E-01],
	[1.70900E+04, 7.6023297344E+03, 5.3619457145E+03, 9.4120757681E+02, 7.2437366595E+02, 7.3535246753E-01],
	[1.70950E+04, 7.6054672119E+03, 5.3616509841E+03, 9.4208125043E+02, 7.2491417478E+02, 7.3547454427E-01],
	[1.71000E+04, 7.6086050662E+03, 5.3613563562E+03, 9.4295547828E+02, 7.2545483913E+02, 7.3559657813E-01],
	[1.71050E+04, 7.6117432971E+03, 5.3610618306E+03, 9.4383026057E+02, 7.2599565887E+02, 7.3571856910E-01],
	[1.71100E+04, 7.6148819047E+03, 5.3607674072E+03, 9.4470559748E+02, 7.2653663386E+02, 7.3584051717E-01],
	[1.71150E+04, 7.6180208888E+03, 5.3604730860E+03, 9.4558148920E+02, 7.2707776397E+02, 7.3596242235E-01],
	[1.71200E+04, 7.6211602494E+03, 5.3601788670E+03, 9.4645793591E+02, 7.2761904907E+02, 7.3608428463E-01],
	[1.71250E+04, 7.6242999865E+03, 5.3598847500E+03, 9.4733493781E+02, 7.2816048904E+02, 7.3620610400E-01],
	[1.71300E+04, 7.6274400998E+03, 5.3595907349E+03, 9.4821249509E+02, 7.2870208373E+02, 7.3632788046E-01],
	[1.71350E+04, 7.6305805895E+03, 5.3592968219E+03, 9.4909060792E+02, 7.2924383302E+02, 7.3644961400E-01],
	[1.71400E+04, 7.6337214554E+03, 5.3590030106E+03, 9.4996927651E+02, 7.2978573677E+02, 7.3657130463E-01],
	[1.71450E+04, 7.6368626974E+03, 5.3587093012E+03, 9.5084850104E+02, 7.3032779485E+02, 7.3669295232E-01],
	[1.71500E+04, 7.6400043155E+03, 5.3584156935E+03, 9.5172828169E+02, 7.3087000713E+02, 7.3681455709E-01],
	[1.71550E+04, 7.6431463097E+03, 5.3581221875E+03, 9.5260861867E+02, 7.3141237348E+02, 7.3693611892E-01],
	[1.71600E+04, 7.6462886798E+03, 5.3578287831E+03, 9.5348951215E+02, 7.3195489376E+02, 7.3705763781E-01],
	[1.71650E+04, 7.6494314259E+03, 5.3575354802E+03, 9.5437096232E+02, 7.3249756784E+02, 7.3717911376E-01],
	[1.71700E+04, 7.6525745477E+03, 5.3572422788E+03, 9.5525296937E+02, 7.3304039560E+02, 7.3730054676E-01],
	[1.71750E+04, 7.6557180454E+03, 5.3569491788E+03, 9.5613553350E+02, 7.3358337689E+02, 7.3742193681E-01],
	[1.71800E+04, 7.6588619187E+03, 5.3566561801E+03, 9.5701865489E+02, 7.3412651158E+02, 7.3754328390E-01],
	[1.71850E+04, 7.6620061677E+03, 5.3563632828E+03, 9.5790233372E+02, 7.3466979954E+02, 7.3766458803E-01],
	[1.71900E+04, 7.6651507923E+03, 5.3560704866E+03, 9.5878657020E+02, 7.3521324065E+02, 7.3778584919E-01],
	[1.71950E+04, 7.6682957924E+03, 5.3557777916E+03, 9.5967136449E+02, 7.3575683476E+02, 7.3790706738E-01],
	[1.72000E+04, 7.6714411679E+03, 5.3554851977E+03, 9.6055671681E+02, 7.3630058174E+02, 7.3802824260E-01],
	[1.72050E+04, 7.6745869188E+03, 5.3551927048E+03, 9.6144262733E+02, 7.3684448146E+02, 7.3814937484E-01],
	[1.72100E+04, 7.6777330450E+03, 5.3549003128E+03, 9.6232909624E+02, 7.3738853379E+02, 7.3827046409E-01],
	[1.72150E+04, 7.6808795465E+03, 5.3546080218E+03, 9.6321612373E+02, 7.3793273859E+02, 7.3839151036E-01],
	[1.72200E+04, 7.6840264232E+03, 5.3543158315E+03, 9.6410370999E+02, 7.3847709574E+02, 7.3851251364E-01],
	[1.72250E+04, 7.6871736750E+03, 5.3540237421E+03, 9.6499185520E+02, 7.3902160509E+02, 7.3863347393E-01],
	[1.72300E+04, 7.6903213019E+03, 5.3537317533E+03, 9.6588055957E+02, 7.3956626651E+02, 7.3875439121E-01],
	[1.72350E+04, 7.6934693037E+03, 5.3534398652E+03, 9.6676982327E+02, 7.4011107987E+02, 7.3887526549E-01],
	[1.72400E+04, 7.6966176806E+03, 5.3531480777E+03, 9.6765964650E+02, 7.4065604505E+02, 7.3899609677E-01],
	[1.72450E+04, 7.6997664322E+03, 5.3528563906E+03, 9.6855002944E+02, 7.4120116189E+02, 7.3911688503E-01],
	[1.72500E+04, 7.7029155587E+03, 5.3525648040E+03, 9.6944097228E+02, 7.4174643027E+02, 7.3923763029E-01],
	[1.72550E+04, 7.7060650599E+03, 5.3522733178E+03, 9.7033247521E+02, 7.4229185006E+02, 7.3935833252E-01],
	[1.72600E+04, 7.7092149358E+03, 5.3519819319E+03, 9.7122453842E+02, 7.4283742112E+02, 7.3947899173E-01],
	[1.72650E+04, 7.7123651864E+03, 5.3516906463E+03, 9.7211716210E+02, 7.4338314332E+02, 7.3959960791E-01],
	[1.72700E+04, 7.7155158114E+03, 5.3513994609E+03, 9.7301034644E+02, 7.4392901653E+02, 7.3972018107E-01],
	[1.72750E+04, 7.7186668110E+03, 5.3511083756E+03, 9.7390409162E+02, 7.4447504060E+02, 7.3984071119E-01],
	[1.72800E+04, 7.7218181850E+03, 5.3508173903E+03, 9.7479839784E+02, 7.4502121541E+02, 7.3996119827E-01],
	[1.72850E+04, 7.7249699333E+03, 5.3505265051E+03, 9.7569326528E+02, 7.4556754082E+02, 7.4008164232E-01],
	[1.72900E+04, 7.7281220560E+03, 5.3502357198E+03, 9.7658869414E+02, 7.4611401671E+02, 7.4020204332E-01],
	[1.72950E+04, 7.7312745528E+03, 5.3499450343E+03, 9.7748468459E+02, 7.4666064292E+02, 7.4032240127E-01],
	[1.73000E+04, 7.7344274239E+03, 5.3496544487E+03, 9.7838123684E+02, 7.4720741933E+02, 7.4044271617E-01],
	[1.73050E+04, 7.7375806690E+03, 5.3493639628E+03, 9.7927835106E+02, 7.4775434581E+02, 7.4056298802E-01],
	[1.73100E+04, 7.7407342882E+03, 5.3490735766E+03, 9.8017602746E+02, 7.4830142222E+02, 7.4068321681E-01],
	[1.73150E+04, 7.7438882813E+03, 5.3487832901E+03, 9.8107426621E+02, 7.4884864843E+02, 7.4080340254E-01],
	[1.73200E+04, 7.7470426484E+03, 5.3484931031E+03, 9.8197306750E+02, 7.4939602430E+02, 7.4092354521E-01],
	[1.73250E+04, 7.7501973893E+03, 5.3482030156E+03, 9.8287243153E+02, 7.4994354969E+02, 7.4104364481E-01],
	[1.73300E+04, 7.7533525040E+03, 5.3479130275E+03, 9.8377235848E+02, 7.5049122448E+02, 7.4116370133E-01],
	[1.73350E+04, 7.7565079925E+03, 5.3476231388E+03, 9.8467284855E+02, 7.5103904852E+02, 7.4128371479E-01],
	[1.73400E+04, 7.7596638545E+03, 5.3473333494E+03, 9.8557390192E+02, 7.5158702169E+02, 7.4140368517E-01],
	[1.73450E+04, 7.7628200902E+03, 5.3470436592E+03, 9.8647551877E+02, 7.5213514385E+02, 7.4152361246E-01],
	[1.73500E+04, 7.7659766994E+03, 5.3467540683E+03, 9.8737769931E+02, 7.5268341485E+02, 7.4164349668E-01],
	[1.73550E+04, 7.7691336821E+03, 5.3464645764E+03, 9.8828044371E+02, 7.5323183458E+02, 7.4176333780E-01],
	[1.73600E+04, 7.7722910382E+03, 5.3461751836E+03, 9.8918375217E+02, 7.5378040289E+02, 7.4188313584E-01],
	[1.73650E+04, 7.7754487676E+03, 5.3458858898E+03, 9.9008762488E+02, 7.5432911964E+02, 7.4200289079E-01],
	[1.73700E+04, 7.7786068703E+03, 5.3455966950E+03, 9.9099206202E+02, 7.5487798471E+02, 7.4212260264E-01],
	[1.73750E+04, 7.7817653463E+03, 5.3453075990E+03, 9.9189706379E+02, 7.5542699795E+02, 7.4224227139E-01],
	[1.73800E+04, 7.7849241953E+03, 5.3450186018E+03, 9.9280263036E+02, 7.5597615924E+02, 7.4236189705E-01],
	[1.73850E+04, 7.7880834175E+03, 5.3447297034E+03, 9.9370876194E+02, 7.5652546843E+02, 7.4248147959E-01],
	[1.73900E+04, 7.7912430127E+03, 5.3444409036E+03, 9.9461545872E+02, 7.5707492539E+02, 7.4260101904E-01],
	[1.73950E+04, 7.7944029808E+03, 5.3441522025E+03, 9.9552272087E+02, 7.5762452999E+02, 7.4272051537E-01],
	[1.74000E+04, 7.7975633219E+03, 5.3438636000E+03, 9.9643054859E+02, 7.5817428208E+02, 7.4283996859E-01],
	[1.74050E+04, 7.8007240357E+03, 5.3435750959E+03, 9.9733894206E+02, 7.5872418154E+02, 7.4295937870E-01],
	[1.74100E+04, 7.8038851224E+03, 5.3432866903E+03, 9.9824790149E+02, 7.5927422823E+02, 7.4307874569E-01],
	[1.74150E+04, 7.8070465817E+03, 5.3429983830E+03, 9.9915742705E+02, 7.5982442201E+02, 7.4319806956E-01],
	[1.74200E+04, 7.8102084138E+03, 5.3427101741E+03, 1.0000675189E+03, 7.6037476275E+02, 7.4331735031E-01],
	[1.74250E+04, 7.8133706183E+03, 5.3424220634E+03, 1.0009781773E+03, 7.6092525030E+02, 7.4343658793E-01],
	[1.74300E+04, 7.8165331955E+03, 5.3421340509E+03, 1.0018894024E+03, 7.6147588454E+02, 7.4355578243E-01],
	[1.74350E+04, 7.8196961450E+03, 5.3418461365E+03, 1.0028011944E+03, 7.6202666533E+02, 7.4367493380E-01],
	[1.74400E+04, 7.8228594670E+03, 5.3415583202E+03, 1.0037135535E+03, 7.6257759253E+02, 7.4379404203E-01],
	[1.74450E+04, 7.8260231613E+03, 5.3412706019E+03, 1.0046264799E+03, 7.6312866601E+02, 7.4391310713E-01],
	[1.74500E+04, 7.8291872278E+03, 5.3409829816E+03, 1.0055399737E+03, 7.6367988562E+02, 7.4403212910E-01],
	[1.74550E+04, 7.8323516666E+03, 5.3406954591E+03, 1.0064540351E+03, 7.6423125124E+02, 7.4415110792E-01],
	[1.74600E+04, 7.8355164775E+03, 5.3404080344E+03, 1.0073686644E+03, 7.6478276272E+02, 7.4427004361E-01],
	[1.74650E+04, 7.8386816605E+03, 5.3401207076E+03, 1.0082838617E+03, 7.6533441994E+02, 7.4438893615E-01],
	[1.74700E+04, 7.8418472155E+03, 5.3398334784E+03, 1.0091996273E+03, 7.6588622275E+02, 7.4450778559E-01],
	[1.74750E+04, 7.8450131424E+03, 5.3395463468E+03, 1.0101159612E+03, 7.6643817102E+02, 7.4462659195E-01],
	[1.74800E+04, 7.8481794413E+03, 5.3392593128E+03, 1.0110328637E+03, 7.6699026460E+02, 7.4474535522E-01],
	[1.74850E+04, 7.8513461120E+03, 5.3389723764E+03, 1.0119503350E+03, 7.6754250337E+02, 7.4486407540E-01],
	[1.74900E+04, 7.8545131544E+03, 5.3386855374E+03, 1.0128683753E+03, 7.6809488719E+02, 7.4498275249E-01],
	[1.74950E+04, 7.8576805685E+03, 5.3383987957E+03, 1.0137869848E+03, 7.6864741592E+02, 7.4510138647E-01],
	[1.75000E+04, 7.8608483543E+03, 5.3381121514E+03, 1.0147061636E+03, 7.6920008942E+02, 7.4521997735E-01],
	[1.75050E+04, 7.8640165117E+03, 5.3378256044E+03, 1.0156319807E+03, 7.6975639365E+02, 7.4533852512E-01],
	[1.75100E+04, 7.8671850406E+03, 5.3375391546E+03, 1.0165583770E+03, 7.7031284511E+02, 7.4545702977E-01],
	[1.75150E+04, 7.8703539409E+03, 5.3372528020E+03, 1.0174853525E+03, 7.7086944368E+02, 7.4557549129E-01],
	[1.75200E+04, 7.8735232126E+03, 5.3369665464E+03, 1.0184129075E+03, 7.7142618920E+02, 7.4569390969E-01],
	[1.75250E+04, 7.8766928557E+03, 5.3366803879E+03, 1.0193410421E+03, 7.7198308155E+02, 7.4581228496E-01],
	[1.75300E+04, 7.8798628700E+03, 5.3363943263E+03, 1.0202697566E+03, 7.7254012058E+02, 7.4593061709E-01],
	[1.75350E+04, 7.8830332555E+03, 5.3361083616E+03, 1.0211990511E+03, 7.7309730615E+02, 7.4604890608E-01],
	[1.75400E+04, 7.8862040121E+03, 5.3358224938E+03, 1.0221289259E+03, 7.7365463812E+02, 7.4616715192E-01],
	[1.75450E+04, 7.8893751399E+03, 5.3355367228E+03, 1.0230593811E+03, 7.7421211636E+02, 7.4628535460E-01],
	[1.75500E+04, 7.8925466386E+03, 5.3352510485E+03, 1.0239904170E+03, 7.7476974072E+02, 7.4640351413E-01],
	[1.75550E+04, 7.8957185083E+03, 5.3349654709E+03, 1.0249220337E+03, 7.7532751106E+02, 7.4652163050E-01],
	[1.75600E+04, 7.8988907489E+03, 5.3346799898E+03, 1.0258542315E+03, 7.7588542725E+02, 7.4663970371E-01],
	[1.75650E+04, 7.9020633603E+03, 5.3343946054E+03, 1.0267870104E+03, 7.7644348913E+02, 7.4675773374E-01],
	[1.75700E+04, 7.9052363425E+03, 5.3341093174E+03, 1.0277203708E+03, 7.7700169659E+02, 7.4687572060E-01],
	[1.75750E+04, 7.9084096954E+03, 5.3338241258E+03, 1.0286543129E+03, 7.7756004946E+02, 7.4699366428E-01],
	[1.75800E+04, 7.9115834190E+03, 5.3335390306E+03, 1.0295888367E+03, 7.7811854762E+02, 7.4711156477E-01],
	[1.75850E+04, 7.9147575131E+03, 5.3332540317E+03, 1.0305239426E+03, 7.7867719092E+02, 7.4722942207E-01],
	[1.75900E+04, 7.9179319777E+03, 5.3329691290E+03, 1.0314596306E+03, 7.7923597922E+02, 7.4734723618E-01],
	[1.75950E+04, 7.9211068128E+03, 5.3326843226E+03, 1.0323959011E+03, 7.7979491239E+02, 7.4746500709E-01],
	[1.76000E+04, 7.9242820183E+03, 5.3323996122E+03, 1.0333327541E+03, 7.8035399028E+02, 7.4758273480E-01],
	[1.76050E+04, 7.9274575941E+03, 5.3321149979E+03, 1.0342701900E+03, 7.8091321275E+02, 7.4770041930E-01],
	[1.76100E+04, 7.9306335402E+03, 5.3318304797E+03, 1.0352082089E+03, 7.8147257966E+02, 7.4781806060E-01],
	[1.76150E+04, 7.9338098565E+03, 5.3315460574E+03, 1.0361468109E+03, 7.8203209087E+02, 7.4793565867E-01],
	[1.76200E+04, 7.9369865429E+03, 5.3312617309E+03, 1.0370859963E+03, 7.8259174624E+02, 7.4805321353E-01],
	[1.76250E+04, 7.9401635995E+03, 5.3309775003E+03, 1.0380257654E+03, 7.8315154563E+02, 7.4817072516E-01],
	[1.76300E+04, 7.9433410260E+03, 5.3306933655E+03, 1.0389661181E+03, 7.8371148890E+02, 7.4828819357E-01],
	[1.76350E+04, 7.9465188225E+03, 5.3304093263E+03, 1.0399070549E+03, 7.8427157591E+02, 7.4840561874E-01],
	[1.76400E+04, 7.9496969889E+03, 5.3301253829E+03, 1.0408485758E+03, 7.8483180651E+02, 7.4852300068E-01],
	[1.76450E+04, 7.9528755252E+03, 5.3298415350E+03, 1.0417906811E+03, 7.8539218057E+02, 7.4864033938E-01],
	[1.76500E+04, 7.9560544312E+03, 5.3295577826E+03, 1.0427333710E+03, 7.8595269795E+02, 7.4875763483E-01],
	[1.76550E+04, 7.9592337069E+03, 5.3292741257E+03, 1.0436766456E+03, 7.8651335850E+02, 7.4887488704E-01],
	[1.76600E+04, 7.9624423521E+03, 5.3290025663E+03, 1.0446205052E+03, 7.8707470725E+02, 7.4899209599E-01],
	[1.76650E+04, 7.9656606112E+03, 5.3287349155E+03, 1.0455649499E+03, 7.8763637375E+02, 7.4910926169E-01],
	[1.76700E+04, 7.9688792596E+03, 5.3284673538E+03, 1.0465099799E+03, 7.8819818457E+02, 7.4922638413E-01],
	[1.76750E+04, 7.9720982974E+03, 5.3281998813E+03, 1.0474555955E+03, 7.8876013960E+02, 7.4934346331E-01],
	[1.76800E+04, 7.9753177245E+03, 5.3279324979E+03, 1.0484017969E+03, 7.8932223867E+02, 7.4946049922E-01],
	[1.76850E+04, 7.9785375408E+03, 5.3276652034E+03, 1.0493485842E+03, 7.8988448167E+02, 7.4957749186E-01],
	[1.76900E+04, 7.9817577463E+03, 5.3273979980E+03, 1.0502959576E+03, 7.9044686843E+02, 7.4969444122E-01],
	[1.76950E+04, 7.9849783409E+03, 5.3271308814E+03, 1.0512439173E+03, 7.9100939883E+02, 7.4981134731E-01],
	[1.77000E+04, 7.9881993246E+03, 5.3268638537E+03, 1.0521924636E+03, 7.9157207273E+02, 7.4992821012E-01],
	[1.77050E+04, 7.9914206972E+03, 5.3265969148E+03, 1.0531415966E+03, 7.9213488998E+02, 7.5004502964E-01],
	[1.77100E+04, 7.9946424587E+03, 5.3263300647E+03, 1.0540913165E+03, 7.9269785044E+02, 7.5016180587E-01],
	[1.77150E+04, 7.9978646091E+03, 5.3260633032E+03, 1.0550416235E+03, 7.9326095398E+02, 7.5027853882E-01],
	[1.77200E+04, 8.0010871483E+03, 5.3257966304E+03, 1.0559925178E+03, 7.9382420045E+02, 7.5039522846E-01],
	[1.77250E+04, 8.0043100762E+03, 5.3255300462E+03, 1.0569439996E+03, 7.9438758972E+02, 7.5051187481E-01],
	[1.77300E+04, 8.0075333927E+03, 5.3252635504E+03, 1.0578960691E+03, 7.9495112164E+02, 7.5062847786E-01],
	[1.77350E+04, 8.0107570979E+03, 5.3249971432E+03, 1.0588487265E+03, 7.9551479607E+02, 7.5074503761E-01],
	[1.77400E+04, 8.0139811916E+03, 5.3247308244E+03, 1.0598019720E+03, 7.9607861287E+02, 7.5086155404E-01],
	[1.77450E+04, 8.0172056738E+03, 5.3244645939E+03, 1.0607558058E+03, 7.9664257190E+02, 7.5097802717E-01],
	[1.77500E+04, 8.0204305443E+03, 5.3241984518E+03, 1.0617102281E+03, 7.9720667302E+02, 7.5109445698E-01],
	[1.77550E+04, 8.0236558033E+03, 5.3239323979E+03, 1.0626652391E+03, 7.9777091610E+02, 7.5121084347E-01],
	[1.77600E+04, 8.0268814505E+03, 5.3236664322E+03, 1.0636208389E+03, 7.9833530098E+02, 7.5132718664E-01],
	[1.77650E+04, 8.0301074859E+03, 5.3234005547E+03, 1.0645770279E+03, 7.9889982753E+02, 7.5144348649E-01],
	[1.77700E+04, 8.0333339095E+03, 5.3231347652E+03, 1.0655338061E+03, 7.9946449561E+02, 7.5155974301E-01],
	[1.77750E+04, 8.0365607213E+03, 5.3228690638E+03, 1.0664911737E+03, 8.0002930507E+02, 7.5167595620E-01],
	[1.77800E+04, 8.0397879210E+03, 5.3226034504E+03, 1.0674491310E+03, 8.0059425578E+02, 7.5179212606E-01],
	[1.77850E+04, 8.0430155087E+03, 5.3223379249E+03, 1.0684076782E+03, 8.0115934759E+02, 7.5190825259E-01],
	[1.77900E+04, 8.0462434843E+03, 5.3220724873E+03, 1.0693668155E+03, 8.0172458037E+02, 7.5202433578E-01],
	[1.77950E+04, 8.0494718478E+03, 5.3218071376E+03, 1.0703265429E+03, 8.0228995396E+02, 7.5214037562E-01],
	[1.78000E+04, 8.0527005991E+03, 5.3215418756E+03, 1.0712868609E+03, 8.0285546824E+02, 7.5225637213E-01],
	[1.78050E+04, 8.0559297381E+03, 5.3212767013E+03, 1.0722477695E+03, 8.0342112306E+02, 7.5237232529E-01],
	[1.78100E+04, 8.0591592647E+03, 5.3210116146E+03, 1.0732092689E+03, 8.0398691827E+02, 7.5248823509E-01],
	[1.78150E+04, 8.0623891790E+03, 5.3207466156E+03, 1.0741713594E+03, 8.0455285374E+02, 7.5260410155E-01],
	[1.78200E+04, 8.0656194808E+03, 5.3204817042E+03, 1.0751340411E+03, 8.0511892933E+02, 7.5271992465E-01],
	[1.78250E+04, 8.0688501700E+03, 5.3202168802E+03, 1.0760973142E+03, 8.0568514489E+02, 7.5283570440E-01],
	[1.78300E+04, 8.0720812467E+03, 5.3199521437E+03, 1.0770611790E+03, 8.0625150028E+02, 7.5295144079E-01],
	[1.78350E+04, 8.0753127107E+03, 5.3196874946E+03, 1.0780256356E+03, 8.0681799536E+02, 7.5306713382E-01],
	[1.78400E+04, 8.0785445621E+03, 5.3194229328E+03, 1.0789906842E+03, 8.0738462999E+02, 7.5318278348E-01],
	[1.78450E+04, 8.0817768006E+03, 5.3191584584E+03, 1.0799563250E+03, 8.0795140403E+02, 7.5329838977E-01],
	[1.78500E+04, 8.0850094263E+03, 5.3188940711E+03, 1.0809225582E+03, 8.0851831733E+02, 7.5341395270E-01],
	[1.78550E+04, 8.0882424391E+03, 5.3186297711E+03, 1.0818893841E+03, 8.0908536976E+02, 7.5352947226E-01],
	[1.78600E+04, 8.0914758390E+03, 5.3183655581E+03, 1.0828568027E+03, 8.0965256117E+02, 7.5364494844E-01],
	[1.78650E+04, 8.0947096258E+03, 5.3181014323E+03, 1.0838248144E+03, 8.1021989141E+02, 7.5376038125E-01],
	[1.78700E+04, 8.0979437996E+03, 5.3178373935E+03, 1.0847934193E+03, 8.1078736035E+02, 7.5387577068E-01],
	[1.78750E+04, 8.1011783602E+03, 5.3175734416E+03, 1.0857626175E+03, 8.1135496785E+02, 7.5399111673E-01],
	[1.78800E+04, 8.1044133076E+03, 5.3173095767E+03, 1.0867324094E+03, 8.1192271376E+02, 7.5410641940E-01],
	[1.78850E+04, 8.1076486417E+03, 5.3170457986E+03, 1.0877027950E+03, 8.1249059794E+02, 7.5422167869E-01],
	[1.78900E+04, 8.1108843625E+03, 5.3167821074E+03, 1.0886737746E+03, 8.1305862025E+02, 7.5433689459E-01],
	[1.78950E+04, 8.1141204699E+03, 5.3165185029E+03, 1.0896453484E+03, 8.1362678055E+02, 7.5445206710E-01],
	[1.79000E+04, 8.1173569638E+03, 5.3162549851E+03, 1.0906175166E+03, 8.1419507869E+02, 7.5456719622E-01],
	[1.79050E+04, 8.1205938442E+03, 5.3159915539E+03, 1.0915902794E+03, 8.1476351453E+02, 7.5468228195E-01],
	[1.79100E+04, 8.1238311111E+03, 5.3157282094E+03, 1.0925636369E+03, 8.1533208793E+02, 7.5479732429E-01],
	[1.79150E+04, 8.1270687643E+03, 5.3154649514E+03, 1.0935375894E+03, 8.1590079875E+02, 7.5491232323E-01],
	[1.79200E+04, 8.1303068038E+03, 5.3152017799E+03, 1.0945121371E+03, 8.1646964684E+02, 7.5502727878E-01],
	[1.79250E+04, 8.1335452295E+03, 5.3149386949E+03, 1.0954872801E+03, 8.1703863206E+02, 7.5514219092E-01],
	[1.79300E+04, 8.1367840415E+03, 5.3146756962E+03, 1.0964630187E+03, 8.1760775427E+02, 7.5525705967E-01],
	[1.79350E+04, 8.1400232395E+03, 5.3144127839E+03, 1.0974393531E+03, 8.1817701333E+02, 7.5537188501E-01],
	[1.79400E+04, 8.1432628236E+03, 5.3141499579E+03, 1.0984162834E+03, 8.1874640909E+02, 7.5548666695E-01],
	[1.79450E+04, 8.1465027936E+03, 5.3138872181E+03, 1.0993938098E+03, 8.1931594141E+02, 7.5560140548E-01],
	[1.79500E+04, 8.1497431496E+03, 5.3136245645E+03, 1.1003719326E+03, 8.1988561014E+02, 7.5571610061E-01],
	[1.79550E+04, 8.1529838915E+03, 5.3133619970E+03, 1.1013506520E+03, 8.2045541515E+02, 7.5583075233E-01],
	[1.79600E+04, 8.1562250192E+03, 5.3130995156E+03, 1.1023299680E+03, 8.2102535630E+02, 7.5594536063E-01],
	[1.79650E+04, 8.1594665326E+03, 5.3128371202E+03, 1.1033098810E+03, 8.2159543343E+02, 7.5605992553E-01],
	[1.79700E+04, 8.1627084317E+03, 5.3125748108E+03, 1.1042903912E+03, 8.2216564640E+02, 7.5617444701E-01],
	[1.79750E+04, 8.1659507164E+03, 5.3123125873E+03, 1.1052714987E+03, 8.2273599508E+02, 7.5628892508E-01],
	[1.79800E+04, 8.1691933867E+03, 5.3120504497E+03, 1.1062532037E+03, 8.2330647932E+02, 7.5640335973E-01],
	[1.79850E+04, 8.1724364424E+03, 5.3117883978E+03, 1.1072355064E+03, 8.2387709897E+02, 7.5651775097E-01],
	[1.79900E+04, 8.1756798836E+03, 5.3115264318E+03, 1.1082184070E+03, 8.2444785390E+02, 7.5663209879E-01],
	[1.79950E+04, 8.1789237102E+03, 5.3112645515E+03, 1.1092019058E+03, 8.2501874395E+02, 7.5674640319E-01],
	[1.80000E+04, 8.1821679221E+03, 5.3110027568E+03, 1.1101860029E+03, 8.2558976899E+02, 7.5686066416E-01],
	[1.80050E+04, 8.1854125193E+03, 5.3107410478E+03, 1.1111706984E+03, 8.2616092887E+02, 7.5697488172E-01],
	[1.80100E+04, 8.1886575016E+03, 5.3104794243E+03, 1.1121559927E+03, 8.2673222345E+02, 7.5708905585E-01],
	[1.80150E+04, 8.1919028691E+03, 5.3102178863E+03, 1.1131418859E+03, 8.2730365259E+02, 7.5720318656E-01],
	[1.80200E+04, 8.1951486216E+03, 5.3099564337E+03, 1.1141283782E+03, 8.2787521614E+02, 7.5731727385E-01],
	[1.80250E+04, 8.1983947592E+03, 5.3096950666E+03, 1.1151154698E+03, 8.2844691395E+02, 7.5743131770E-01],
	[1.80300E+04, 8.2016412816E+03, 5.3094337848E+03, 1.1161031609E+03, 8.2901874589E+02, 7.5754531814E-01],
	[1.80350E+04, 8.2048881890E+03, 5.3091725883E+03, 1.1170914517E+03, 8.2959071181E+02, 7.5765927514E-01],
	[1.80400E+04, 8.2081354812E+03, 5.3089114771E+03, 1.1180803423E+03, 8.3016281156E+02, 7.5777318871E-01],
	[1.80450E+04, 8.2113831582E+03, 5.3086504510E+03, 1.1190698331E+03, 8.3073504501E+02, 7.5788705886E-01],
	[1.80500E+04, 8.2146312198E+03, 5.3083895101E+03, 1.1200599241E+03, 8.3130741201E+02, 7.5800088557E-01],
	[1.80550E+04, 8.2178796662E+03, 5.3081286543E+03, 1.1210506156E+03, 8.3187991241E+02, 7.5811466886E-01],
	[1.80600E+04, 8.2211284970E+03, 5.3078678836E+03, 1.1220419078E+03, 8.3245254607E+02, 7.5822840871E-01],
	[1.80650E+04, 8.2243777124E+03, 5.3076071978E+03, 1.1230338009E+03, 8.3302531285E+02, 7.5834210513E-01],
	[1.80700E+04, 8.2276273123E+03, 5.3073465970E+03, 1.1240262950E+03, 8.3359821260E+02, 7.5845575812E-01],
	[1.80750E+04, 8.2308772966E+03, 5.3070860810E+03, 1.1250193904E+03, 8.3417124518E+02, 7.5856936767E-01],
	[1.80800E+04, 8.2341276652E+03, 5.3068256499E+03, 1.1260130872E+03, 8.3474441045E+02, 7.5868293379E-01],
	[1.80850E+04, 8.2373784180E+03, 5.3065653036E+03, 1.1270073858E+03, 8.3531770825E+02, 7.5879645647E-01],
	[1.80900E+04, 8.2406295551E+03, 5.3063050420E+03, 1.1280022861E+03, 8.3589113845E+02, 7.5890993572E-01],
	[1.80950E+04, 8.2438810764E+03, 5.3060448651E+03, 1.1289977885E+03, 8.3646470090E+02, 7.5902337153E-01],
	[1.81000E+04, 8.2471329817E+03, 5.3057847729E+03, 1.1299938932E+03, 8.3703839546E+02, 7.5913676390E-01],
	[1.81050E+04, 8.2503852711E+03, 5.3055247652E+03, 1.1309906003E+03, 8.3761222198E+02, 7.5925011284E-01],
	[1.81100E+04, 8.2536379444E+03, 5.3052648420E+03, 1.1319879101E+03, 8.3818618032E+02, 7.5936341834E-01],
	[1.81150E+04, 8.2568910016E+03, 5.3050050034E+03, 1.1329858227E+03, 8.3876027033E+02, 7.5947668041E-01],
	[1.81200E+04, 8.2601444427E+03, 5.3047452491E+03, 1.1339843384E+03, 8.3933449187E+02, 7.5958989903E-01],
	[1.81250E+04, 8.2633982676E+03, 5.3044855793E+03, 1.1349834573E+03, 8.3990884480E+02, 7.5970307422E-01],
	[1.81300E+04, 8.2666524762E+03, 5.3042259938E+03, 1.1359831796E+03, 8.4048332896E+02, 7.5981620597E-01],
	[1.81350E+04, 8.2699070685E+03, 5.3039664925E+03, 1.1369835055E+03, 8.4105794422E+02, 7.5992929428E-01],
	[1.81400E+04, 8.2731620444E+03, 5.3037070755E+03, 1.1379844353E+03, 8.4163269043E+02, 7.6004233916E-01],
	[1.81450E+04, 8.2764174039E+03, 5.3034477426E+03, 1.1389859691E+03, 8.4220756744E+02, 7.6015534059E-01],
	[1.81500E+04, 8.2796731468E+03, 5.3031884939E+03, 1.1399881071E+03, 8.4278257511E+02, 7.6026829859E-01],
	[1.81550E+04, 8.2829292731E+03, 5.3029293293E+03, 1.1409908496E+03, 8.4335771330E+02, 7.6038121314E-01],
	[1.81600E+04, 8.2861857829E+03, 5.3026702487E+03, 1.1419941966E+03, 8.4393298186E+02, 7.6049408426E-01],
	[1.81650E+04, 8.2894426759E+03, 5.3024112520E+03, 1.1429981485E+03, 8.4450838065E+02, 7.6060691194E-01],
	[1.81700E+04, 8.2926999521E+03, 5.3021523393E+03, 1.1440027053E+03, 8.4508390951E+02, 7.6071969618E-01],
	[1.81750E+04, 8.2959576116E+03, 5.3018935105E+03, 1.1450078674E+03, 8.4565956831E+02, 7.6083243698E-01],
	[1.81800E+04, 8.2992156542E+03, 5.3016347654E+03, 1.1460136349E+03, 8.4623535690E+02, 7.6094513435E-01],
	[1.81850E+04, 8.3024740798E+03, 5.3013761042E+03, 1.1470200080E+03, 8.4681127514E+02, 7.6105778827E-01],
	[1.81900E+04, 8.3057328885E+03, 5.3011175267E+03, 1.1480269869E+03, 8.4738732287E+02, 7.6117039876E-01],
	[1.81950E+04, 8.3089920800E+03, 5.3008590328E+03, 1.1490345718E+03, 8.4796349996E+02, 7.6128296581E-01],
	[1.82000E+04, 8.3122516545E+03, 5.3006006226E+03, 1.1500427628E+03, 8.4853980626E+02, 7.6139548942E-01],
	[1.82050E+04, 8.3155116118E+03, 5.3003422960E+03, 1.1510515603E+03, 8.4911624162E+02, 7.6150796959E-01],
	[1.82100E+04, 8.3187719519E+03, 5.3000840528E+03, 1.1520609643E+03, 8.4969280590E+02, 7.6162040633E-01],
	[1.82150E+04, 8.3220326746E+03, 5.2998258932E+03, 1.1530709752E+03, 8.5026949895E+02, 7.6173279963E-01],
	[1.82200E+04, 8.3252937800E+03, 5.2995678170E+03, 1.1540815930E+03, 8.5084632063E+02, 7.6184514950E-01],
	[1.82250E+04, 8.3285552680E+03, 5.2993098241E+03, 1.1550928180E+03, 8.5142327079E+02, 7.6195745593E-01],
	[1.82300E+04, 8.3318171385E+03, 5.2990519146E+03, 1.1561046503E+03, 8.5200034929E+02, 7.6206971892E-01],
	[1.82350E+04, 8.3350793915E+03, 5.2987940883E+03, 1.1571170903E+03, 8.5257755597E+02, 7.6218193848E-01],
	[1.82400E+04, 8.3383420268E+03, 5.2985363453E+03, 1.1581301380E+03, 8.5315489070E+02, 7.6229411461E-01],
	[1.82450E+04, 8.3416050446E+03, 5.2982786855E+03, 1.1591437937E+03, 8.5373235333E+02, 7.6240624730E-01],
	[1.82500E+04, 8.3448684446E+03, 5.2980211087E+03, 1.1601580575E+03, 8.5430994372E+02, 7.6251833656E-01],
	[1.82550E+04, 8.3481322268E+03, 5.2977636151E+03, 1.1611729297E+03, 8.5488766171E+02, 7.6263038239E-01],
	[1.82600E+04, 8.3513963911E+03, 5.2975062045E+03, 1.1621884105E+03, 8.5546550716E+02, 7.6274238478E-01],
	[1.82650E+04, 8.3546609376E+03, 5.2972488768E+03, 1.1632045000E+03, 8.5604347992E+02, 7.6285434375E-01],
	[1.82700E+04, 8.3579258661E+03, 5.2969916321E+03, 1.1642211984E+03, 8.5662157986E+02, 7.6296625928E-01],
	[1.82750E+04, 8.3611911766E+03, 5.2967344703E+03, 1.1652385061E+03, 8.5719980682E+02, 7.6307813139E-01],
	[1.82800E+04, 8.3644568691E+03, 5.2964773913E+03, 1.1662564230E+03, 8.5777816066E+02, 7.6318996007E-01],
	[1.82850E+04, 8.3677229434E+03, 5.2962203950E+03, 1.1672749495E+03, 8.5835664122E+02, 7.6330174532E-01],
	[1.82900E+04, 8.3709893994E+03, 5.2959634816E+03, 1.1682940858E+03, 8.5893524838E+02, 7.6341348714E-01],
	[1.82950E+04, 8.3742562373E+03, 5.2957066507E+03, 1.1693138320E+03, 8.5951398197E+02, 7.6352518554E-01],
	[1.83000E+04, 8.3775234568E+03, 5.2954499025E+03, 1.1703341883E+03, 8.6009284186E+02, 7.6363684052E-01],
	[1.83050E+04, 8.3807910579E+03, 5.2951932369E+03, 1.1713551550E+03, 8.6067182789E+02, 7.6374845207E-01],
	[1.83100E+04, 8.3840590406E+03, 5.2949366539E+03, 1.1723767322E+03, 8.6125093992E+02, 7.6386002020E-01],
	[1.83150E+04, 8.3873274049E+03, 5.2946801533E+03, 1.1733989201E+03, 8.6183017780E+02, 7.6397154490E-01],
	[1.83200E+04, 8.3905961505E+03, 5.2944237351E+03, 1.1744217190E+03, 8.6240954140E+02, 7.6408302619E-01],
	[1.83250E+04, 8.3938652775E+03, 5.2941673994E+03, 1.1754451290E+03, 8.6298903055E+02, 7.6419446406E-01],
	[1.83300E+04, 8.3971347859E+03, 5.2939111460E+03, 1.1764691503E+03, 8.6356864512E+02, 7.6430585851E-01],
	[1.83350E+04, 8.4004046755E+03, 5.2936549748E+03, 1.1774937831E+03, 8.6414838496E+02, 7.6441720954E-01],
	[1.83400E+04, 8.4036749464E+03, 5.2933988859E+03, 1.1785190276E+03, 8.6472824991E+02, 7.6452851716E-01],
	[1.83450E+04, 8.4069455984E+03, 5.2931428792E+03, 1.1795448841E+03, 8.6530823985E+02, 7.6463978136E-01],
	[1.83500E+04, 8.4102166314E+03, 5.2928869547E+03, 1.1805713526E+03, 8.6588835461E+02, 7.6475100215E-01],
	[1.83550E+04, 8.4134880455E+03, 5.2926311122E+03, 1.1815984335E+03, 8.6646859405E+02, 7.6486217953E-01],
	[1.83600E+04, 8.4167598406E+03, 5.2923753518E+03, 1.1826261269E+03, 8.6704895803E+02, 7.6497331350E-01],
	[1.83650E+04, 8.4200687901E+03, 5.2921335335E+03, 1.1836544330E+03, 8.6763020940E+02, 7.6508440406E-01],
	[1.83700E+04, 8.4233818894E+03, 5.2918932051E+03, 1.1846833520E+03, 8.6821166445E+02, 7.6519545122E-01],
	[1.83750E+04, 8.4266953902E+03, 5.2916529529E+03, 1.1857128840E+03, 8.6879324532E+02, 7.6530645496E-01],
	[1.83800E+04, 8.4300092924E+03, 5.2914127770E+03, 1.1867430294E+03, 8.6937495186E+02, 7.6541741531E-01],
	[1.83850E+04, 8.4333235959E+03, 5.2911726774E+03, 1.1877737883E+03, 8.6995678394E+02, 7.6552833225E-01],
	[1.83900E+04, 8.4366383007E+03, 5.2909326539E+03, 1.1888051609E+03, 8.7053874140E+02, 7.6563920579E-01],
	[1.83950E+04, 8.4399534067E+03, 5.2906927066E+03, 1.1898371473E+03, 8.7112082410E+02, 7.6575003593E-01],
	[1.84000E+04, 8.4432689139E+03, 5.2904528353E+03, 1.1908697478E+03, 8.7170303189E+02, 7.6586082267E-01],
	[1.84050E+04, 8.4465848221E+03, 5.2902130401E+03, 1.1919029627E+03, 8.7228536464E+02, 7.6597156602E-01],
	[1.84100E+04, 8.4499011313E+03, 5.2899733209E+03, 1.1929367920E+03, 8.7286782218E+02, 7.6608226597E-01],
	[1.84150E+04, 8.4532178415E+03, 5.2897336776E+03, 1.1939712360E+03, 8.7345040438E+02, 7.6619292253E-01],
	[1.84200E+04, 8.4565349526E+03, 5.2894941103E+03, 1.1950062948E+03, 8.7403311109E+02, 7.6630353569E-01],
	[1.84250E+04, 8.4598524646E+03, 5.2892546188E+03, 1.1960419688E+03, 8.7461594217E+02, 7.6641410547E-01],
	[1.84300E+04, 8.4631703773E+03, 5.2890152031E+03, 1.1970782580E+03, 8.7519889747E+02, 7.6652463187E-01],
	[1.84350E+04, 8.4664886908E+03, 5.2887758632E+03, 1.1981151626E+03, 8.7578197684E+02, 7.6663511487E-01],
	[1.84400E+04, 8.4698074049E+03, 5.2885365991E+03, 1.1991526830E+03, 8.7636518013E+02, 7.6674555450E-01],
	[1.84450E+04, 8.4731265197E+03, 5.2882974106E+03, 1.2001908192E+03, 8.7694850721E+02, 7.6685595074E-01],
	[1.84500E+04, 8.4764460349E+03, 5.2880582978E+03, 1.2012295715E+03, 8.7753195793E+02, 7.6696630360E-01],
	[1.84550E+04, 8.4797659507E+03, 5.2878192606E+03, 1.2022689400E+03, 8.7811553213E+02, 7.6707661309E-01],
	[1.84600E+04, 8.4830862668E+03, 5.2875802989E+03, 1.2033089250E+03, 8.7869922968E+02, 7.6718687920E-01],
	[1.84650E+04, 8.4864069834E+03, 5.2873414128E+03, 1.2043495266E+03, 8.7928305042E+02, 7.6729710193E-01],
	[1.84700E+04, 8.4897281002E+03, 5.2871026021E+03, 1.2053907451E+03, 8.7986699422E+02, 7.6740728130E-01],
	[1.84750E+04, 8.4930496173E+03, 5.2868638668E+03, 1.2064325806E+03, 8.8045106092E+02, 7.6751741730E-01],
	[1.84800E+04, 8.4963715345E+03, 5.2866252069E+03, 1.2074750334E+03, 8.8103525037E+02, 7.6762750993E-01],
	[1.84850E+04, 8.4996938519E+03, 5.2863866223E+03, 1.2085181037E+03, 8.8161956245E+02, 7.6773755919E-01],
	[1.84900E+04, 8.5030165694E+03, 5.2861481131E+03, 1.2095617916E+03, 8.8220399698E+02, 7.6784756510E-01],
	[1.84950E+04, 8.5063396868E+03, 5.2859096790E+03, 1.2106060973E+03, 8.8278855384E+02, 7.6795752764E-01],
	[1.85000E+04, 8.5096632042E+03, 5.2856713202E+03, 1.2116510210E+03, 8.8337323287E+02, 7.6806744682E-01],
	[1.85050E+04, 8.5129871214E+03, 5.2854330365E+03, 1.2126965630E+03, 8.8395803393E+02, 7.6817732265E-01],
	[1.85100E+04, 8.5163114385E+03, 5.2851948280E+03, 1.2137427235E+03, 8.8454295686E+02, 7.6828715513E-01],
	[1.85150E+04, 8.5196361554E+03, 5.2849566945E+03, 1.2147895025E+03, 8.8512800153E+02, 7.6839694426E-01],
	[1.85200E+04, 8.5229612719E+03, 5.2847186360E+03, 1.2158369004E+03, 8.8571316779E+02, 7.6850669004E-01],
	[1.85250E+04, 8.5262867881E+03, 5.2844806525E+03, 1.2168849174E+03, 8.8629845549E+02, 7.6861639247E-01],
	[1.85300E+04, 8.5296127038E+03, 5.2842427440E+03, 1.2179335535E+03, 8.8688386448E+02, 7.6872605156E-01],
	[1.85350E+04, 8.5329390191E+03, 5.2840049103E+03, 1.2189828091E+03, 8.8746939462E+02, 7.6883566730E-01],
	[1.85400E+04, 8.5362657339E+03, 5.2837671515E+03, 1.2200326843E+03, 8.8805504577E+02, 7.6894523971E-01],
	[1.85450E+04, 8.5395928480E+03, 5.2835294675E+03, 1.2210831793E+03, 8.8864081776E+02, 7.6905476879E-01],
	[1.85500E+04, 8.5429203615E+03, 5.2832918583E+03, 1.2221342943E+03, 8.8922671046E+02, 7.6916425453E-01],
	[1.85550E+04, 8.5462482743E+03, 5.2830543238E+03, 1.2231860296E+03, 8.8981272373E+02, 7.6927369694E-01],
	[1.85600E+04, 8.5495765863E+03, 5.2828168639E+03, 1.2242383852E+03, 8.9039885741E+02, 7.6938309603E-01],
	[1.85650E+04, 8.5529052974E+03, 5.2825794787E+03, 1.2252913615E+03, 8.9098511135E+02, 7.6949245179E-01],
	[1.85700E+04, 8.5562344077E+03, 5.2823421681E+03, 1.2263449585E+03, 8.9157148541E+02, 7.6960176422E-01],
	[1.85750E+04, 8.5595639170E+03, 5.2821049320E+03, 1.2273991766E+03, 8.9215797945E+02, 7.6971103334E-01],
	[1.85800E+04, 8.5628938253E+03, 5.2818677704E+03, 1.2284540159E+03, 8.9274459331E+02, 7.6982025914E-01],
	[1.85850E+04, 8.5662241325E+03, 5.2816306833E+03, 1.2295094766E+03, 8.9333132686E+02, 7.6992944163E-01],
	[1.85900E+04, 8.5695548386E+03, 5.2813936706E+03, 1.2305655589E+03, 8.9391817993E+02, 7.7003858081E-01],
	[1.85950E+04, 8.5728859435E+03, 5.2811567323E+03, 1.2316222630E+03, 8.9450515239E+02, 7.7014767668E-01],
	[1.86000E+04, 8.5762174471E+03, 5.2809198682E+03, 1.2326795890E+03, 8.9509224409E+02, 7.7025672924E-01],
	[1.86050E+04, 8.5795493494E+03, 5.2806830785E+03, 1.2337375373E+03, 8.9567945487E+02, 7.7036573850E-01],
	[1.86100E+04, 8.5828816503E+03, 5.2804463630E+03, 1.2347961080E+03, 8.9626678460E+02, 7.7047470447E-01],
	[1.86150E+04, 8.5862143499E+03, 5.2802097217E+03, 1.2358553012E+03, 8.9685423313E+02, 7.7058362714E-01],
	[1.86200E+04, 8.5895474479E+03, 5.2799731546E+03, 1.2369151173E+03, 8.9744180031E+02, 7.7069250651E-01],
	[1.86250E+04, 8.5928809443E+03, 5.2797366616E+03, 1.2379755563E+03, 8.9802948599E+02, 7.7080134260E-01],
	[1.86300E+04, 8.5962148392E+03, 5.2795002426E+03, 1.2390366185E+03, 8.9861729002E+02, 7.7091013539E-01],
	[1.86350E+04, 8.5995491324E+03, 5.2792638977E+03, 1.2400983041E+03, 8.9920521226E+02, 7.7101888491E-01],
	[1.86400E+04, 8.6028838238E+03, 5.2790276267E+03, 1.2411606132E+03, 8.9979325256E+02, 7.7112759115E-01],
	[1.86450E+04, 8.6062189135E+03, 5.2787914297E+03, 1.2422235462E+03, 9.0038141077E+02, 7.7123625410E-01],
	[1.86500E+04, 8.6095544013E+03, 5.2785553066E+03, 1.2432871031E+03, 9.0096968675E+02, 7.7134487379E-01],
	[1.86550E+04, 8.6128902872E+03, 5.2783192574E+03, 1.2443512842E+03, 9.0155808034E+02, 7.7145345020E-01],
	[1.86600E+04, 8.6162265712E+03, 5.2780832819E+03, 1.2454160896E+03, 9.0214659140E+02, 7.7156198335E-01],
	[1.86650E+04, 8.6195632531E+03, 5.2778473802E+03, 1.2464815197E+03, 9.0273521979E+02, 7.7167047323E-01],
	[1.86700E+04, 8.6229003329E+03, 5.2776115523E+03, 1.2475475745E+03, 9.0332396535E+02, 7.7177891985E-01],
	[1.86750E+04, 8.6262378106E+03, 5.2773757980E+03, 1.2486142542E+03, 9.0391282794E+02, 7.7188732322E-01],
	[1.86800E+04, 8.6295756861E+03, 5.2771401173E+03, 1.2496815592E+03, 9.0450180740E+02, 7.7199568333E-01],
	[1.86850E+04, 8.6329139594E+03, 5.2769045103E+03, 1.2507494894E+03, 9.0509090360E+02, 7.7210400019E-01],
	[1.86900E+04, 8.6362526303E+03, 5.2766689768E+03, 1.2518180453E+03, 9.0568011638E+02, 7.7221227381E-01],
	[1.86950E+04, 8.6395916988E+03, 5.2764335168E+03, 1.2528872269E+03, 9.0626944560E+02, 7.7232050418E-01],
	[1.87000E+04, 8.6429311649E+03, 5.2761981303E+03, 1.2539570344E+03, 9.0685889111E+02, 7.7242869131E-01],
	[1.87050E+04, 8.6462710285E+03, 5.2759628172E+03, 1.2550274682E+03, 9.0744845275E+02, 7.7253683521E-01],
	[1.87100E+04, 8.6496112895E+03, 5.2757275775E+03, 1.2560985282E+03, 9.0803813040E+02, 7.7264493587E-01],
	[1.87150E+04, 8.6529519479E+03, 5.2754924112E+03, 1.2571702148E+03, 9.0862792388E+02, 7.7275299331E-01],
	[1.87200E+04, 8.6562930037E+03, 5.2752573181E+03, 1.2582425282E+03, 9.0921783306E+02, 7.7286100752E-01],
	[1.87250E+04, 8.6596344567E+03, 5.2750222983E+03, 1.2593154685E+03, 9.0980785779E+02, 7.7296897851E-01],
	[1.87300E+04, 8.6629763069E+03, 5.2747873517E+03, 1.2603890359E+03, 9.1039799793E+02, 7.7307690628E-01],
	[1.87350E+04, 8.6663185542E+03, 5.2745524783E+03, 1.2614632307E+03, 9.1098825331E+02, 7.7318479084E-01],
	[1.87400E+04, 8.6696611987E+03, 5.2743176780E+03, 1.2625380531E+03, 9.1157862380E+02, 7.7329263218E-01],
	[1.87450E+04, 8.6730042402E+03, 5.2740829508E+03, 1.2636135031E+03, 9.1216910925E+02, 7.7340043032E-01],
	[1.87500E+04, 8.6763476786E+03, 5.2738482966E+03, 1.2646895811E+03, 9.1275970951E+02, 7.7350818526E-01],
	[1.87550E+04, 8.6796915140E+03, 5.2736137155E+03, 1.2657662873E+03, 9.1335042442E+02, 7.7361589700E-01],
	[1.87600E+04, 8.6830357462E+03, 5.2733792073E+03, 1.2668436218E+03, 9.1394125385E+02, 7.7372356555E-01],
	[1.87650E+04, 8.6863803753E+03, 5.2731447720E+03, 1.2679215848E+03, 9.1453219765E+02, 7.7383119090E-01],
	[1.87700E+04, 8.6897254010E+03, 5.2729104096E+03, 1.2690001765E+03, 9.1512325566E+02, 7.7393877307E-01],
	[1.87750E+04, 8.6930708235E+03, 5.2726761200E+03, 1.2700793972E+03, 9.1571442773E+02, 7.7404631206E-01],
	[1.87800E+04, 8.6964166425E+03, 5.2724419032E+03, 1.2711592470E+03, 9.1630571373E+02, 7.7415380786E-01],
	[1.87850E+04, 8.6997628581E+03, 5.2722077592E+03, 1.2722397261E+03, 9.1689711350E+02, 7.7426126050E-01],
	[1.87900E+04, 8.7031094703E+03, 5.2719736879E+03, 1.2733208347E+03, 9.1748862689E+02, 7.7436866996E-01],
	[1.87950E+04, 8.7064564788E+03, 5.2717396892E+03, 1.2744025731E+03, 9.1808025376E+02, 7.7447603625E-01],
	[1.88000E+04, 8.7098038838E+03, 5.2715057632E+03, 1.2754849414E+03, 9.1867199395E+02, 7.7458335939E-01],
	[1.88050E+04, 8.7131516851E+03, 5.2712719097E+03, 1.2765679397E+03, 9.1926384733E+02, 7.7469063936E-01],
	[1.88100E+04, 8.7164998826E+03, 5.2710381288E+03, 1.2776515685E+03, 9.1985581373E+02, 7.7479787618E-01],
	[1.88150E+04, 8.7198484764E+03, 5.2708044204E+03, 1.2787358277E+03, 9.2044789301E+02, 7.7490506985E-01],
	[1.88200E+04, 8.7231974663E+03, 5.2705707844E+03, 1.2798207176E+03, 9.2104008502E+02, 7.7501222038E-01],
	[1.88250E+04, 8.7265468523E+03, 5.2703372209E+03, 1.2809062385E+03, 9.2163238962E+02, 7.7511932776E-01],
	[1.88300E+04, 8.7298966343E+03, 5.2701037297E+03, 1.2819923904E+03, 9.2222480665E+02, 7.7522639201E-01],
	[1.88350E+04, 8.7332468124E+03, 5.2698703109E+03, 1.2830791737E+03, 9.2281733597E+02, 7.7533341313E-01],
	[1.88400E+04, 8.7365973863E+03, 5.2696369643E+03, 1.2841665884E+03, 9.2340997743E+02, 7.7544039112E-01],
	[1.88450E+04, 8.7399483561E+03, 5.2694036900E+03, 1.2852546349E+03, 9.2400273088E+02, 7.7554732598E-01],
	[1.88500E+04, 8.7432997217E+03, 5.2691704879E+03, 1.2863433133E+03, 9.2459559616E+02, 7.7565421772E-01],
	[1.88550E+04, 8.7466514830E+03, 5.2689373580E+03, 1.2874326238E+03, 9.2518857314E+02, 7.7576106635E-01],
	[1.88600E+04, 8.7500036401E+03, 5.2687043002E+03, 1.2885225665E+03, 9.2578166167E+02, 7.7586787187E-01],
	[1.88650E+04, 8.7533561927E+03, 5.2684713145E+03, 1.2896131418E+03, 9.2637486159E+02, 7.7597463429E-01],
	[1.88700E+04, 8.7567091409E+03, 5.2682384008E+03, 1.2907043498E+03, 9.2696817275E+02, 7.7608135359E-01],
	[1.88750E+04, 8.7600624847E+03, 5.2680055591E+03, 1.2917961906E+03, 9.2756159501E+02, 7.7618802979E-01],
	[1.88800E+04, 8.7634162239E+03, 5.2677727894E+03, 1.2928886646E+03, 9.2815512822E+02, 7.7629466288E-01],
	[1.88850E+04, 8.7667703585E+03, 5.2675400916E+03, 1.2939817718E+03, 9.2874877223E+02, 7.7640125286E-01],
	[1.88900E+04, 8.7701248884E+03, 5.2673074657E+03, 1.2950755126E+03, 9.2934252688E+02, 7.7650779974E-01],
	[1.88950E+04, 8.7734798136E+03, 5.2670749116E+03, 1.2961698870E+03, 9.2993639204E+02, 7.7661430352E-01],
	[1.89000E+04, 8.7768351340E+03, 5.2668424293E+03, 1.2972648953E+03, 9.3053036756E+02, 7.7672076419E-01],
	[1.89050E+04, 8.7801908496E+03, 5.2666100188E+03, 1.2983605377E+03, 9.3112445327E+02, 7.7682718176E-01],
	[1.89100E+04, 8.7835469603E+03, 5.2663776799E+03, 1.2994568144E+03, 9.3171864904E+02, 7.7693355623E-01],
	[1.89150E+04, 8.7869034660E+03, 5.2661454128E+03, 1.3005537255E+03, 9.3231295472E+02, 7.7703988760E-01],
	[1.89200E+04, 8.7902603667E+03, 5.2659132172E+03, 1.3016512714E+03, 9.3290737015E+02, 7.7714617587E-01],
	[1.89250E+04, 8.7936176624E+03, 5.2656810933E+03, 1.3027494521E+03, 9.3350189519E+02, 7.7725242105E-01],
	[1.89300E+04, 8.7969753529E+03, 5.2654490409E+03, 1.3038482679E+03, 9.3409652969E+02, 7.7735862313E-01],
	[1.89350E+04, 8.8003334382E+03, 5.2652170600E+03, 1.3049477190E+03, 9.3469127349E+02, 7.7746478212E-01],
	[1.89400E+04, 8.8036919183E+03, 5.2649851506E+03, 1.3060478055E+03, 9.3528612646E+02, 7.7757089801E-01],
	[1.89450E+04, 8.8070507931E+03, 5.2647533126E+03, 1.3071485277E+03, 9.3588108843E+02, 7.7767697081E-01],
	[1.89500E+04, 8.8104100626E+03, 5.2645215460E+03, 1.3082498858E+03, 9.3647615927E+02, 7.7778300053E-01],
	[1.89550E+04, 8.8137697266E+03, 5.2642898507E+03, 1.3093518800E+03, 9.3707133882E+02, 7.7788898716E-01],
	[1.89600E+04, 8.8171297851E+03, 5.2640582267E+03, 1.3104545104E+03, 9.3766662694E+02, 7.7799493070E-01],
	[1.89650E+04, 8.8204902382E+03, 5.2638266740E+03, 1.3115577773E+03, 9.3826202346E+02, 7.7810083115E-01],
	[1.89700E+04, 8.8238510856E+03, 5.2635951925E+03, 1.3126616809E+03, 9.3885752826E+02, 7.7820668853E-01],
	[1.89750E+04, 8.8272123274E+03, 5.2633637822E+03, 1.3137662213E+03, 9.3945314116E+02, 7.7831250282E-01],
	[1.89800E+04, 8.8305739634E+03, 5.2631324430E+03, 1.3148713988E+03, 9.4004886203E+02, 7.7841827403E-01],
	[1.89850E+04, 8.8339359938E+03, 5.2629011750E+03, 1.3159772135E+03, 9.4064469072E+02, 7.7852400217E-01],
	[1.89900E+04, 8.8372984182E+03, 5.2626699780E+03, 1.3170836657E+03, 9.4124062708E+02, 7.7862968723E-01],
	[1.89950E+04, 8.8406612369E+03, 5.2624388520E+03, 1.3181907556E+03, 9.4183667095E+02, 7.7873532921E-01],
	[1.90000E+04, 8.8440244495E+03, 5.2622077969E+03, 1.3192984833E+03, 9.4243282219E+02, 7.7884092813E-01],
	[1.90050E+04, 8.8473880562E+03, 5.2619768129E+03, 1.3204068491E+03, 9.4302908065E+02, 7.7894648397E-01],
	[1.90100E+04, 8.8507520569E+03, 5.2617458997E+03, 1.3215158532E+03, 9.4362544618E+02, 7.7905199674E-01],
	[1.90150E+04, 8.8541164514E+03, 5.2615150573E+03, 1.3226254956E+03, 9.4422191863E+02, 7.7915746645E-01],
	[1.90200E+04, 8.8574812398E+03, 5.2612842858E+03, 1.3237357768E+03, 9.4481849785E+02, 7.7926289310E-01],
	[1.90250E+04, 8.8608464219E+03, 5.2610535851E+03, 1.3248466968E+03, 9.4541518369E+02, 7.7936827668E-01],
	[1.90300E+04, 8.8642119978E+03, 5.2608229551E+03, 1.3259582558E+03, 9.4601197600E+02, 7.7947361720E-01],
	[1.90350E+04, 8.8675779673E+03, 5.2605923958E+03, 1.3270704541E+03, 9.4660887463E+02, 7.7957891466E-01],
	[1.90400E+04, 8.8709443304E+03, 5.2603619071E+03, 1.3281832919E+03, 9.4720587943E+02, 7.7968416907E-01],
	[1.90450E+04, 8.8743110871E+03, 5.2601314891E+03, 1.3292967692E+03, 9.4780299025E+02, 7.7978938043E-01],
	[1.90500E+04, 8.8776782373E+03, 5.2599011416E+03, 1.3304108865E+03, 9.4840020695E+02, 7.7989454873E-01],
	[1.90550E+04, 8.8810457809E+03, 5.2596708647E+03, 1.3315256437E+03, 9.4899752937E+02, 7.7999967398E-01],
	[1.90600E+04, 8.8844137178E+03, 5.2594406583E+03, 1.3326410413E+03, 9.4959495736E+02, 7.8010475619E-01],
	[1.90650E+04, 8.8877820481E+03, 5.2592105223E+03, 1.3337570792E+03, 9.5019249078E+02, 7.8020979535E-01],
	[1.90700E+04, 8.8911507717E+03, 5.2589804567E+03, 1.3348737578E+03, 9.5079012946E+02, 7.8031479147E-01],
	[1.90750E+04, 8.8945198884E+03, 5.2587504615E+03, 1.3359910772E+03, 9.5138787328E+02, 7.8041974455E-01],
	[1.90800E+04, 8.8978893983E+03, 5.2585205366E+03, 1.3371090377E+03, 9.5198572206E+02, 7.8052465460E-01],
	[1.90850E+04, 8.9012593013E+03, 5.2582906821E+03, 1.3382276394E+03, 9.5258367567E+02, 7.8062952161E-01],
	[1.90900E+04, 8.9046295974E+03, 5.2580608978E+03, 1.3393468825E+03, 9.5318173395E+02, 7.8073434558E-01],
	[1.90950E+04, 8.9080190627E+03, 5.2578376479E+03, 1.3404667673E+03, 9.5378032473E+02, 7.8083912653E-01],
	[1.91000E+04, 8.9114330115E+03, 5.2576227531E+03, 1.3415872939E+03, 9.5437956996E+02, 7.8094386445E-01],
	[1.91050E+04, 8.9148473747E+03, 5.2574079233E+03, 1.3427084625E+03, 9.5497892129E+02, 7.8104855934E-01],
	[1.91100E+04, 8.9182621521E+03, 5.2571931585E+03, 1.3438302734E+03, 9.5557837855E+02, 7.8115321121E-01],
	[1.91150E+04, 8.9216773436E+03, 5.2569784587E+03, 1.3449527267E+03, 9.5617794161E+02, 7.8125782007E-01],
	[1.91200E+04, 8.9250929492E+03, 5.2567638237E+03, 1.3460758226E+03, 9.5677761031E+02, 7.8136238590E-01],
	[1.91250E+04, 8.9285089689E+03, 5.2565492537E+03, 1.3471995614E+03, 9.5737738450E+02, 7.8146690872E-01],
	[1.91300E+04, 8.9319254026E+03, 5.2563347485E+03, 1.3483239431E+03, 9.5797726404E+02, 7.8157138854E-01],
	[1.91350E+04, 8.9353422502E+03, 5.2561203081E+03, 1.3494489681E+03, 9.5857724878E+02, 7.8167582534E-01],
	[1.91400E+04, 8.9387595116E+03, 5.2559059325E+03, 1.3505746365E+03, 9.5917733857E+02, 7.8178021914E-01],
	[1.91450E+04, 8.9421771869E+03, 5.2556916216E+03, 1.3517009486E+03, 9.5977753326E+02, 7.8188456993E-01],
	[1.91500E+04, 8.9455952760E+03, 5.2554773754E+03, 1.3528279044E+03, 9.6037783270E+02, 7.8198887772E-01],
	[1.91550E+04, 8.9490137787E+03, 5.2552631939E+03, 1.3539555043E+03, 9.6097823674E+02, 7.8209314252E-01],
	[1.91600E+04, 8.9524326950E+03, 5.2550490770E+03, 1.3550837484E+03, 9.6157874523E+02, 7.8219736433E-01],
	[1.91650E+04, 8.9558520250E+03, 5.2548350247E+03, 1.3562126369E+03, 9.6217935803E+02, 7.8230154314E-01],
	[1.91700E+04, 8.9592717684E+03, 5.2546210369E+03, 1.3573421700E+03, 9.6278007499E+02, 7.8240567897E-01],
	[1.91750E+04, 8.9626919254E+03, 5.2544071137E+03, 1.3584723480E+03, 9.6338089595E+02, 7.8250977181E-01],
	[1.91800E+04, 8.9661124957E+03, 5.2541932550E+03, 1.3596031710E+03, 9.6398182077E+02, 7.8261382167E-01],
	[1.91850E+04, 8.9695334794E+03, 5.2539794606E+03, 1.3607346391E+03, 9.6458284930E+02, 7.8271782855E-01],
	[1.91900E+04, 8.9729548764E+03, 5.2537657307E+03, 1.3618667527E+03, 9.6518398139E+02, 7.8282179245E-01],
	[1.91950E+04, 8.9763766866E+03, 5.2535520652E+03, 1.3629995119E+03, 9.6578521689E+02, 7.8292571339E-01],
	[1.92000E+04, 8.9797989099E+03, 5.2533384640E+03, 1.3641329169E+03, 9.6638655566E+02, 7.8302959135E-01],
	[1.92050E+04, 8.9832215464E+03, 5.2531249271E+03, 1.3652669679E+03, 9.6698799754E+02, 7.8313342635E-01],
	[1.92100E+04, 8.9866445960E+03, 5.2529114545E+03, 1.3664016652E+03, 9.6758954238E+02, 7.8323721839E-01],
	[1.92150E+04, 8.9900680586E+03, 5.2526980461E+03, 1.3675370088E+03, 9.6819119004E+02, 7.8334096746E-01],
	[1.92200E+04, 8.9934919341E+03, 5.2524847018E+03, 1.3686729990E+03, 9.6879294036E+02, 7.8344467359E-01],
	[1.92250E+04, 8.9969162225E+03, 5.2522714218E+03, 1.3698096361E+03, 9.6939479320E+02, 7.8354833676E-01],
	[1.92300E+04, 9.0003409237E+03, 5.2520582058E+03, 1.3709469201E+03, 9.6999674841E+02, 7.8365195698E-01],
	[1.92350E+04, 9.0037660377E+03, 5.2518450540E+03, 1.3720848514E+03, 9.7059880584E+02, 7.8375553425E-01],
	[1.92400E+04, 9.0071915644E+03, 5.2516319662E+03, 1.3732234300E+03, 9.7120096534E+02, 7.8385906859E-01],
	[1.92450E+04, 9.0106175037E+03, 5.2514189424E+03, 1.3743626563E+03, 9.7180322677E+02, 7.8396255999E-01],
	[1.92500E+04, 9.0140438557E+03, 5.2512059825E+03, 1.3755025303E+03, 9.7240558996E+02, 7.8406600845E-01],
	[1.92550E+04, 9.0174706202E+03, 5.2509930866E+03, 1.3766430524E+03, 9.7300805477E+02, 7.8416941398E-01],
	[1.92600E+04, 9.0208977972E+03, 5.2507802547E+03, 1.3777842226E+03, 9.7361062106E+02, 7.8427277658E-01],
	[1.92650E+04, 9.0243253866E+03, 5.2505674865E+03, 1.3789260413E+03, 9.7421328868E+02, 7.8437609626E-01],
	[1.92700E+04, 9.0277533884E+03, 5.2503547823E+03, 1.3800685085E+03, 9.7481605746E+02, 7.8447937302E-01],
	[1.92750E+04, 9.0311818025E+03, 5.2501421418E+03, 1.3812116246E+03, 9.7541892728E+02, 7.8458260686E-01],
	[1.92800E+04, 9.0346106288E+03, 5.2499295651E+03, 1.3823553896E+03, 9.7602189797E+02, 7.8468579779E-01],
	[1.92850E+04, 9.0380398674E+03, 5.2497170521E+03, 1.3834998039E+03, 9.7662496939E+02, 7.8478894581E-01],
	[1.92900E+04, 9.0414695181E+03, 5.2495046028E+03, 1.3846448675E+03, 9.7722814138E+02, 7.8489205093E-01],
	[1.92950E+04, 9.0448995808E+03, 5.2492922171E+03, 1.3857905807E+03, 9.7783141381E+02, 7.8499511315E-01],
	[1.93000E+04, 9.0483300556E+03, 5.2490798951E+03, 1.3869369437E+03, 9.7843478651E+02, 7.8509813247E-01],
	[1.93050E+04, 9.0517609424E+03, 5.2488676366E+03, 1.3880839567E+03, 9.7903825935E+02, 7.8520110889E-01],
	[1.93100E+04, 9.0551922410E+03, 5.2486554417E+03, 1.3892316199E+03, 9.7964183216E+02, 7.8530404243E-01],
	[1.93150E+04, 9.0586239516E+03, 5.2484433103E+03, 1.3903799335E+03, 9.8024550481E+02, 7.8540693308E-01],
	[1.93200E+04, 9.0620560739E+03, 5.2482312424E+03, 1.3915288977E+03, 9.8084927714E+02, 7.8550978084E-01],
	[1.93250E+04, 9.0654886079E+03, 5.2480192379E+03, 1.3926785127E+03, 9.8145314900E+02, 7.8561258574E-01],
	[1.93300E+04, 9.0689215537E+03, 5.2478072969E+03, 1.3938287786E+03, 9.8205712025E+02, 7.8571534775E-01],
	[1.93350E+04, 9.0723549110E+03, 5.2475954192E+03, 1.3949796957E+03, 9.8266119073E+02, 7.8581806690E-01],
	[1.93400E+04, 9.0757886800E+03, 5.2473836048E+03, 1.3961312643E+03, 9.8326536029E+02, 7.8592074319E-01],
	[1.93450E+04, 9.0792228604E+03, 5.2471718537E+03, 1.3972834844E+03, 9.8386962879E+02, 7.8602337661E-01],
	[1.93500E+04, 9.0826574523E+03, 5.2469601659E+03, 1.3984363563E+03, 9.8447399607E+02, 7.8612596718E-01],
	[1.93550E+04, 9.0860924556E+03, 5.2467485414E+03, 1.3995898801E+03, 9.8507846199E+02, 7.8622851489E-01],
	[1.93600E+04, 9.0895278702E+03, 5.2465369800E+03, 1.4007440562E+03, 9.8568302640E+02, 7.8633101976E-01],
	[1.93650E+04, 9.0929636961E+03, 5.2463254818E+03, 1.4018988846E+03, 9.8628768914E+02, 7.8643348178E-01],
	[1.93700E+04, 9.0963999333E+03, 5.2461140467E+03, 1.4030543657E+03, 9.8689245007E+02, 7.8653590096E-01],
	[1.93750E+04, 9.0998365816E+03, 5.2459026747E+03, 1.4042104995E+03, 9.8749730904E+02, 7.8663827731E-01],
	[1.93800E+04, 9.1032736410E+03, 5.2456913658E+03, 1.4053672862E+03, 9.8810226589E+02, 7.8674061083E-01],
	[1.93850E+04, 9.1067111115E+03, 5.2454801198E+03, 1.4065247262E+03, 9.8870732049E+02, 7.8684290152E-01],
	[1.93900E+04, 9.1101489929E+03, 5.2452689369E+03, 1.4076828195E+03, 9.8931247267E+02, 7.8694514938E-01],
	[1.93950E+04, 9.1135872854E+03, 5.2450578169E+03, 1.4088415664E+03, 9.8991772229E+02, 7.8704735443E-01],
	[1.94000E+04, 9.1170259886E+03, 5.2448467598E+03, 1.4100009671E+03, 9.9052306921E+02, 7.8714951667E-01],
	[1.94050E+04, 9.1204651028E+03, 5.2446357656E+03, 1.4111610218E+03, 9.9112851326E+02, 7.8725163610E-01],
	[1.94100E+04, 9.1239046277E+03, 5.2444248342E+03, 1.4123217307E+03, 9.9173405430E+02, 7.8735371273E-01],
	[1.94150E+04, 9.1273445633E+03, 5.2442139657E+03, 1.4134830939E+03, 9.9233969219E+02, 7.8745574655E-01],
	[1.94200E+04, 9.1307849095E+03, 5.2440031599E+03, 1.4146451117E+03, 9.9294542676E+02, 7.8755773758E-01],
	[1.94250E+04, 9.1342256664E+03, 5.2437924169E+03, 1.4158077843E+03, 9.9355125788E+02, 7.8765968582E-01],
	[1.94300E+04, 9.1376668338E+03, 5.2435817365E+03, 1.4169711118E+03, 9.9415718539E+02, 7.8776159128E-01],
	[1.94350E+04, 9.1411084117E+03, 5.2433711189E+03, 1.4181350945E+03, 9.9476320914E+02, 7.8786345396E-01],
	[1.94400E+04, 9.1445504000E+03, 5.2431605638E+03, 1.4192997326E+03, 9.9536932899E+02, 7.8796527386E-01],
	[1.94450E+04, 9.1479927987E+03, 5.2429500714E+03, 1.4204650263E+03, 9.9597554477E+02, 7.8806705098E-01],
	[1.94500E+04, 9.1514356077E+03, 5.2427396415E+03, 1.4216309757E+03, 9.9658185635E+02, 7.8816878535E-01],
	[1.94550E+04, 9.1548788270E+03, 5.2425292742E+03, 1.4227975811E+03, 9.9718826358E+02, 7.8827047695E-01],
	[1.94600E+04, 9.1583224565E+03, 5.2423189694E+03, 1.4239648427E+03, 9.9779476629E+02, 7.8837212579E-01],
	[1.94650E+04, 9.1617664961E+03, 5.2421087270E+03, 1.4251327606E+03, 9.9840136435E+02, 7.8847373189E-01],
	[1.94700E+04, 9.1652109458E+03, 5.2418985470E+03, 1.4263013351E+03, 9.9900805760E+02, 7.8857529523E-01],
	[1.94750E+04, 9.1686558055E+03, 5.2416884295E+03, 1.4274705664E+03, 9.9961484590E+02, 7.8867681584E-01],
	[1.94800E+04, 9.1721010753E+03, 5.2414783743E+03, 1.4286404547E+03, 1.0002217291E+03, 7.8877829370E-01],
	[1.94850E+04, 9.1755467549E+03, 5.2412683814E+03, 1.4298110001E+03, 1.0008287070E+03, 7.8887972884E-01],
	[1.94900E+04, 9.1789928444E+03, 5.2410584508E+03, 1.4309822029E+03, 1.0014357796E+03, 7.8898112125E-01],
	[1.94950E+04, 9.1824393437E+03, 5.2408485825E+03, 1.4321540632E+03, 1.0020429465E+03, 7.8908247094E-01],
	[1.95000E+04, 9.1858862528E+03, 5.2406387764E+03, 1.4333265814E+03, 1.0026502078E+03, 7.8918377791E-01],
	[1.95050E+04, 9.1893335716E+03, 5.2404290324E+03, 1.4344997574E+03, 1.0032575632E+03, 7.8928504217E-01],
	[1.95100E+04, 9.1927813000E+03, 5.2402193507E+03, 1.4356735917E+03, 1.0038650126E+03, 7.8938626372E-01],
	[1.95150E+04, 9.1962294380E+03, 5.2400097310E+03, 1.4368480843E+03, 1.0044725559E+03, 7.8948744257E-01],
	[1.95200E+04, 9.1996779855E+03, 5.2398001734E+03, 1.4380232355E+03, 1.0050801928E+03, 7.8958857873E-01],
	[1.95250E+04, 9.2031269425E+03, 5.2395906779E+03, 1.4391990454E+03, 1.0056879233E+03, 7.8968967220E-01],
	[1.95300E+04, 9.2065763089E+03, 5.2393812444E+03, 1.4403755143E+03, 1.0062957472E+03, 7.8979072298E-01],
	[1.95350E+04, 9.2100260846E+03, 5.2391718728E+03, 1.4415526424E+03, 1.0069036644E+03, 7.8989173108E-01],
	[1.95400E+04, 9.2134762697E+03, 5.2389625632E+03, 1.4427304298E+03, 1.0075116746E+03, 7.8999269651E-01],
	[1.95450E+04, 9.2169268640E+03, 5.2387533156E+03, 1.4439088768E+03, 1.0081197778E+03, 7.9009361926E-01],
	[1.95500E+04, 9.2203778675E+03, 5.2385441298E+03, 1.4450879836E+03, 1.0087279737E+03, 7.9019449936E-01],
	[1.95550E+04, 9.2238292801E+03, 5.2383350058E+03, 1.4462677503E+03, 1.0093362623E+03, 7.9029533679E-01],
	[1.95600E+04, 9.2272811018E+03, 5.2381259436E+03, 1.4474481772E+03, 1.0099446435E+03, 7.9039613158E-01],
	[1.95650E+04, 9.2307333325E+03, 5.2379169433E+03, 1.4486292644E+03, 1.0105531169E+03, 7.9049688371E-01],
	[1.95700E+04, 9.2341859722E+03, 5.2377080046E+03, 1.4498110122E+03, 1.0111616826E+03, 7.9059759320E-01],
	[1.95750E+04, 9.2376390208E+03, 5.2374991277E+03, 1.4509934208E+03, 1.0117703403E+03, 7.9069826006E-01],
	[1.95800E+04, 9.2410924782E+03, 5.2372903125E+03, 1.4521764903E+03, 1.0123790899E+03, 7.9079888429E-01],
	[1.95850E+04, 9.2445463445E+03, 5.2370815588E+03, 1.4533602210E+03, 1.0129879312E+03, 7.9089946589E-01],
	[1.95900E+04, 9.2480006195E+03, 5.2368728668E+03, 1.4545446131E+03, 1.0135968641E+03, 7.9100000487E-01],
	[1.95950E+04, 9.2514553031E+03, 5.2366642364E+03, 1.4557296667E+03, 1.0142058885E+03, 7.9110050124E-01],
	[1.96000E+04, 9.2549103954E+03, 5.2364556675E+03, 1.4569153820E+03, 1.0148150042E+03, 7.9120095499E-01],
	[1.96050E+04, 9.2583658963E+03, 5.2362471601E+03, 1.4581017593E+03, 1.0154242110E+03, 7.9130136615E-01],
	[1.96100E+04, 9.2618218057E+03, 5.2360387141E+03, 1.4592887988E+03, 1.0160335088E+03, 7.9140173471E-01],
	[1.96150E+04, 9.2652781235E+03, 5.2358303297E+03, 1.4604765006E+03, 1.0166428975E+03, 7.9150206068E-01],
	[1.96200E+04, 9.2687348498E+03, 5.2356220066E+03, 1.4616648650E+03, 1.0172523768E+03, 7.9160234406E-01],
	[1.96250E+04, 9.2721919844E+03, 5.2354137448E+03, 1.4628538922E+03, 1.0178619467E+03, 7.9170258487E-01],
	[1.96300E+04, 9.2756495273E+03, 5.2352055444E+03, 1.4640435823E+03, 1.0184716070E+03, 7.9180278310E-01],
	[1.96350E+04, 9.2791074784E+03, 5.2349974054E+03, 1.4652339356E+03, 1.0190813576E+03, 7.9190293876E-01],
	[1.96400E+04, 9.2825658378E+03, 5.2347893275E+03, 1.4664249522E+03, 1.0196911982E+03, 7.9200305186E-01],
	[1.96450E+04, 9.2860246052E+03, 5.2345813110E+03, 1.4676166323E+03, 1.0203011288E+03, 7.9210312241E-01],
	[1.96500E+04, 9.2894837807E+03, 5.2343733556E+03, 1.4688089763E+03, 1.0209111492E+03, 7.9220315040E-01],
	[1.96550E+04, 9.2929433642E+03, 5.2341654613E+03, 1.4700019842E+03, 1.0215212592E+03, 7.9230313585E-01],
	[1.96600E+04, 9.2964033557E+03, 5.2339576283E+03, 1.4711956562E+03, 1.0221314587E+03, 7.9240307877E-01],
	[1.96650E+04, 9.2998637551E+03, 5.2337498563E+03, 1.4723899926E+03, 1.0227417475E+03, 7.9250297915E-01],
	[1.96700E+04, 9.3033245623E+03, 5.2335421453E+03, 1.4735849936E+03, 1.0233521256E+03, 7.9260283701E-01],
	[1.96750E+04, 9.3067857774E+03, 5.2333344955E+03, 1.4747806593E+03, 1.0239625927E+03, 7.9270265234E-01],
	[1.96800E+04, 9.3102474001E+03, 5.2331269066E+03, 1.4759769899E+03, 1.0245731487E+03, 7.9280242517E-01],
	[1.96850E+04, 9.3137094306E+03, 5.2329193786E+03, 1.4771739858E+03, 1.0251837934E+03, 7.9290215548E-01],
	[1.96900E+04, 9.3171718687E+03, 5.2327119116E+03, 1.4783716469E+03, 1.0257945267E+03, 7.9300184330E-01],
	[1.96950E+04, 9.3206347143E+03, 5.2325045055E+03, 1.4795699737E+03, 1.0264053485E+03, 7.9310148862E-01],
	[1.97000E+04, 9.3240979675E+03, 5.2322971603E+03, 1.4807689662E+03, 1.0270162585E+03, 7.9320109145E-01],
	[1.97050E+04, 9.3275616281E+03, 5.2320898759E+03, 1.4819686246E+03, 1.0276272567E+03, 7.9330065180E-01],
	[1.97100E+04, 9.3310256961E+03, 5.2318826523E+03, 1.4831689492E+03, 1.0282383429E+03, 7.9340016967E-01],
	[1.97150E+04, 9.3344901715E+03, 5.2316754895E+03, 1.4843699401E+03, 1.0288495169E+03, 7.9349964507E-01],
	[1.97200E+04, 9.3379550541E+03, 5.2314683874E+03, 1.4855715976E+03, 1.0294607786E+03, 7.9359907801E-01],
	[1.97250E+04, 9.3414203440E+03, 5.2312613460E+03, 1.4867739219E+03, 1.0300721279E+03, 7.9369846849E-01],
	[1.97300E+04, 9.3448860411E+03, 5.2310543653E+03, 1.4879769131E+03, 1.0306835646E+03, 7.9379781653E-01],
	[1.97350E+04, 9.3483521453E+03, 5.2308474451E+03, 1.4891805715E+03, 1.0312950884E+03, 7.9389712211E-01],
	[1.97400E+04, 9.3518186566E+03, 5.2306405856E+03, 1.4903848972E+03, 1.0319066994E+03, 7.9399638526E-01],
	[1.97450E+04, 9.3552855749E+03, 5.2304337867E+03, 1.4915898905E+03, 1.0325183973E+03, 7.9409560598E-01],
	[1.97500E+04, 9.3587529001E+03, 5.2302270483E+03, 1.4927955515E+03, 1.0331301821E+03, 7.9419478427E-01],
	[1.97550E+04, 9.3622206323E+03, 5.2300203704E+03, 1.4940018805E+03, 1.0337420534E+03, 7.9429392015E-01],
	[1.97600E+04, 9.3656887713E+03, 5.2298137530E+03, 1.4952088776E+03, 1.0343540113E+03, 7.9439301361E-01],
	[1.97650E+04, 9.3691573171E+03, 5.2296071960E+03, 1.4964165431E+03, 1.0349660554E+03, 7.9449206467E-01],
	[1.97700E+04, 9.3726262696E+03, 5.2294006994E+03, 1.4976248771E+03, 1.0355781858E+03, 7.9459107333E-01],
	[1.97750E+04, 9.3760956288E+03, 5.2291942632E+03, 1.4988338799E+03, 1.0361904022E+03, 7.9469003960E-01],
	[1.97800E+04, 9.3795653947E+03, 5.2289878873E+03, 1.5000435517E+03, 1.0368027045E+03, 7.9478896348E-01],
	[1.97850E+04, 9.3830355671E+03, 5.2287815717E+03, 1.5012538926E+03, 1.0374150925E+03, 7.9488784499E-01],
	[1.97900E+04, 9.3865061461E+03, 5.2285753164E+03, 1.5024649029E+03, 1.0380275662E+03, 7.9498668412E-01],
	[1.97950E+04, 9.3899771315E+03, 5.2283691213E+03, 1.5036765827E+03, 1.0386401252E+03, 7.9508548089E-01],
	[1.98000E+04, 9.3934485233E+03, 5.2281629864E+03, 1.5048889322E+03, 1.0392527696E+03, 7.9518423530E-01],
	[1.98050E+04, 9.3969203215E+03, 5.2279569117E+03, 1.5061019518E+03, 1.0398654990E+03, 7.9528294736E-01],
	[1.98100E+04, 9.4003925259E+03, 5.2277508971E+03, 1.5073156414E+03, 1.0404783135E+03, 7.9538161707E-01],
	[1.98150E+04, 9.4038651366E+03, 5.2275449427E+03, 1.5085300015E+03, 1.0410912128E+03, 7.9548024445E-01],
	[1.98200E+04, 9.4073381535E+03, 5.2273390483E+03, 1.5097450320E+03, 1.0417041968E+03, 7.9557882949E-01],
	[1.98250E+04, 9.4108115766E+03, 5.2271332139E+03, 1.5109607334E+03, 1.0423172653E+03, 7.9567737221E-01],
	[1.98300E+04, 9.4142854057E+03, 5.2269274396E+03, 1.5121771057E+03, 1.0429304182E+03, 7.9577587262E-01],
	[1.98350E+04, 9.4177596408E+03, 5.2267217252E+03, 1.5133941491E+03, 1.0435436554E+03, 7.9587433071E-01],
	[1.98400E+04, 9.4212342819E+03, 5.2265160708E+03, 1.5146118639E+03, 1.0441569766E+03, 7.9597274650E-01],
	[1.98450E+04, 9.4247093289E+03, 5.2263104763E+03, 1.5158302503E+03, 1.0447703818E+03, 7.9607112000E-01],
	[1.98500E+04, 9.4281847818E+03, 5.2261049417E+03, 1.5170493084E+03, 1.0453838707E+03, 7.9616945120E-01],
	[1.98550E+04, 9.4316663458E+03, 5.2259012706E+03, 1.5182690385E+03, 1.0459975857E+03, 7.9626774013E-01],
	[1.98600E+04, 9.4351876808E+03, 5.2257100979E+03, 1.5194894407E+03, 1.0466123678E+03, 7.9636598678E-01],
	[1.98650E+04, 9.4387094435E+03, 5.2255189803E+03, 1.5207105153E+03, 1.0472272352E+03, 7.9646419116E-01],
	[1.98700E+04, 9.4422316339E+03, 5.2253279179E+03, 1.5219322624E+03, 1.0478421877E+03, 7.9656235328E-01],
	[1.98750E+04, 9.4457542520E+03, 5.2251369104E+03, 1.5231546823E+03, 1.0484572253E+03, 7.9666047315E-01],
	[1.98800E+04, 9.4492772977E+03, 5.2249459580E+03, 1.5243777751E+03, 1.0490723478E+03, 7.9675855077E-01],
	[1.98850E+04, 9.4528007709E+03, 5.2247550606E+03, 1.5256015411E+03, 1.0496875550E+03, 7.9685658615E-01],
	[1.98900E+04, 9.4563246717E+03, 5.2245642182E+03, 1.5268259805E+03, 1.0503028467E+03, 7.9695457930E-01],
	[1.98950E+04, 9.4598489999E+03, 5.2243734307E+03, 1.5280510934E+03, 1.0509182229E+03, 7.9705253022E-01],
	[1.99000E+04, 9.4633737554E+03, 5.2241826981E+03, 1.5292768801E+03, 1.0515336834E+03, 7.9715043893E-01],
	[1.99050E+04, 9.4668989383E+03, 5.2239920203E+03, 1.5305033407E+03, 1.0521492280E+03, 7.9724830543E-01],
	[1.99100E+04, 9.4704245485E+03, 5.2238013975E+03, 1.5317304755E+03, 1.0527648566E+03, 7.9734612972E-01],
	[1.99150E+04, 9.4739505859E+03, 5.2236108294E+03, 1.5329582847E+03, 1.0533805691E+03, 7.9744391182E-01],
	[1.99200E+04, 9.4774770505E+03, 5.2234203161E+03, 1.5341867684E+03, 1.0539963652E+03, 7.9754165173E-01],
	[1.99250E+04, 9.4810039421E+03, 5.2232298576E+03, 1.5354159268E+03, 1.0546122448E+03, 7.9763934946E-01],
	[1.99300E+04, 9.4845312608E+03, 5.2230394539E+03, 1.5366457603E+03, 1.0552282079E+03, 7.9773700502E-01],
	[1.99350E+04, 9.4880590065E+03, 5.2228491048E+03, 1.5378762688E+03, 1.0558442541E+03, 7.9783461841E-01],
	[1.99400E+04, 9.4915871792E+03, 5.2226588104E+03, 1.5391074528E+03, 1.0564603835E+03, 7.9793218965E-01],
	[1.99450E+04, 9.4951157787E+03, 5.2224685706E+03, 1.5403393123E+03, 1.0570765958E+03, 7.9802971873E-01],
	[1.99500E+04, 9.4986448051E+03, 5.2222783855E+03, 1.5415718475E+03, 1.0576928909E+03, 7.9812720567E-01],
	[1.99550E+04, 9.5021742582E+03, 5.2220882549E+03, 1.5428050588E+03, 1.0583092686E+03, 7.9822465048E-01],
	[1.99600E+04, 9.5057041381E+03, 5.2218981789E+03, 1.5440389461E+03, 1.0589257288E+03, 7.9832205315E-01],
	[1.99650E+04, 9.5092344446E+03, 5.2217081574E+03, 1.5452735099E+03, 1.0595422714E+03, 7.9841941371E-01],
	[1.99700E+04, 9.5127651778E+03, 5.2215181904E+03, 1.5465087502E+03, 1.0601588962E+03, 7.9851673215E-01],
	[1.99750E+04, 9.5162963374E+03, 5.2213282778E+03, 1.5477446672E+03, 1.0607756030E+03, 7.9861400849E-01],
	[1.99800E+04, 9.5198279236E+03, 5.2211384198E+03, 1.5489812613E+03, 1.0613923917E+03, 7.9871124273E-01],
	[1.99850E+04, 9.5233599362E+03, 5.2209486161E+03, 1.5502185325E+03, 1.0620092621E+03, 7.9880843489E-01],
	[1.99900E+04, 9.5268923753E+03, 5.2207588668E+03, 1.5514564810E+03, 1.0626262141E+03, 7.9890558496E-01],
	[1.99950E+04, 9.5304252406E+03, 5.2205691718E+03, 1.5526951071E+03, 1.0632432476E+03, 7.9900269295E-01],
	[2.00000E+04, 9.5339585322E+03, 5.2203795311E+03, 1.5539344110E+03, 1.0638603624E+03, 7.9909975888E-01],
	[2.00050E+04, 9.5374922501E+03, 5.2201899448E+03, 1.5551783300E+03, 1.0644794029E+03, 7.9919678275E-01],
	[2.00100E+04, 9.5410263941E+03, 5.2200004127E+03, 1.5564229326E+03, 1.0650985254E+03, 7.9929376457E-01],
	[2.00150E+04, 9.5445609642E+03, 5.2198109348E+03, 1.5576682188E+03, 1.0657177295E+03, 7.9939070435E-01],
	[2.00200E+04, 9.5480959604E+03, 5.2196215112E+03, 1.5589141890E+03, 1.0663370153E+03, 7.9948760209E-01],
	[2.00250E+04, 9.5516313826E+03, 5.2194321417E+03, 1.5601608432E+03, 1.0669563824E+03, 7.9958445780E-01],
	[2.00300E+04, 9.5551672307E+03, 5.2192428264E+03, 1.5614081818E+03, 1.0675758309E+03, 7.9968127150E-01],
	[2.00350E+04, 9.5587035047E+03, 5.2190535652E+03, 1.5626562049E+03, 1.0681953605E+03, 7.9977804318E-01],
	[2.00400E+04, 9.5622402046E+03, 5.2188643580E+03, 1.5639049126E+03, 1.0688149711E+03, 7.9987477286E-01],
	[2.00450E+04, 9.5657773302E+03, 5.2186752050E+03, 1.5651543054E+03, 1.0694346625E+03, 7.9997146055E-01],
	[2.00500E+04, 9.5693148816E+03, 5.2184861059E+03, 1.5664043832E+03, 1.0700544346E+03, 8.0006810624E-01],
	[2.00550E+04, 9.5728528586E+03, 5.2182970609E+03, 1.5676551464E+03, 1.0706742872E+03, 8.0016470996E-01],
	[2.00600E+04, 9.5763912613E+03, 5.2181080698E+03, 1.5689065951E+03, 1.0712942203E+03, 8.0026127171E-01],
	[2.00650E+04, 9.5799300895E+03, 5.2179191327E+03, 1.5701587295E+03, 1.0719142335E+03, 8.0035779149E-01],
	[2.00700E+04, 9.5834693432E+03, 5.2177302494E+03, 1.5714115499E+03, 1.0725343268E+03, 8.0045426932E-01],
	[2.00750E+04, 9.5870090224E+03, 5.2175414201E+03, 1.5726650564E+03, 1.0731545001E+03, 8.0055070520E-01],
	[2.00800E+04, 9.5905491270E+03, 5.2173526446E+03, 1.5739192493E+03, 1.0737747532E+03, 8.0064709915E-01],
	[2.00850E+04, 9.5940896569E+03, 5.2171639230E+03, 1.5751741287E+03, 1.0743950858E+03, 8.0074345116E-01],
	[2.00900E+04, 9.5976306121E+03, 5.2169752551E+03, 1.5764296949E+03, 1.0750154980E+03, 8.0083976125E-01],
	[2.00950E+04, 9.6011719925E+03, 5.2167866411E+03, 1.5776859480E+03, 1.0756359895E+03, 8.0093602942E-01],
	[2.01000E+04, 9.6047137981E+03, 5.2165980807E+03, 1.5789428884E+03, 1.0762565601E+03, 8.0103225569E-01],
	[2.01050E+04, 9.6082560289E+03, 5.2164095741E+03, 1.5802005160E+03, 1.0768772098E+03, 8.0112844007E-01],
	[2.01100E+04, 9.6117986847E+03, 5.2162211212E+03, 1.5814588313E+03, 1.0774979384E+03, 8.0122458255E-01],
	[2.01150E+04, 9.6153417655E+03, 5.2160327219E+03, 1.5827178343E+03, 1.0781187457E+03, 8.0132068315E-01],
	[2.01200E+04, 9.6188852713E+03, 5.2158443762E+03, 1.5839775253E+03, 1.0787396316E+03, 8.0141674188E-01],
	[2.01250E+04, 9.6224292020E+03, 5.2156560842E+03, 1.5852379045E+03, 1.0793605959E+03, 8.0151275874E-01],
	[2.01300E+04, 9.6259735575E+03, 5.2154678457E+03, 1.5864989721E+03, 1.0799816385E+03, 8.0160873375E-01],
	[2.01350E+04, 9.6295183378E+03, 5.2152796607E+03, 1.5877607283E+03, 1.0806027592E+03, 8.0170466691E-01],
	[2.01400E+04, 9.6330635429E+03, 5.2150915293E+03, 1.5890231732E+03, 1.0812239579E+03, 8.0180055824E-01],
	[2.01450E+04, 9.6366091727E+03, 5.2149034513E+03, 1.5902863072E+03, 1.0818452344E+03, 8.0189640773E-01],
	[2.01500E+04, 9.6401552270E+03, 5.2147154268E+03, 1.5915501304E+03, 1.0824665886E+03, 8.0199221540E-01],
	[2.01550E+04, 9.6437017060E+03, 5.2145274558E+03, 1.5928146429E+03, 1.0830880203E+03, 8.0208798125E-01],
	[2.01600E+04, 9.6472486095E+03, 5.2143395381E+03, 1.5940798451E+03, 1.0837095293E+03, 8.0218370530E-01],
	[2.01650E+04, 9.6507959374E+03, 5.2141516738E+03, 1.5953457371E+03, 1.0843311157E+03, 8.0227938755E-01],
	[2.01700E+04, 9.6543436898E+03, 5.2139638628E+03, 1.5966123192E+03, 1.0849527790E+03, 8.0237502802E-01],
	[2.01750E+04, 9.6578918665E+03, 5.2137761052E+03, 1.5978795914E+03, 1.0855745193E+03, 8.0247062670E-01],
	[2.01800E+04, 9.6614404676E+03, 5.2135884008E+03, 1.5991475541E+03, 1.0861963364E+03, 8.0256618359E-01],
	[2.01850E+04, 9.6649894929E+03, 5.2134007497E+03, 1.6004162074E+03, 1.0868182301E+03, 8.0266169872E-01],
	[2.01900E+04, 9.6685389423E+03, 5.2132131518E+03, 1.6016855516E+03, 1.0874402003E+03, 8.0275717207E-01],
	[2.01950E+04, 9.6720888160E+03, 5.2130256072E+03, 1.6029555868E+03, 1.0880622468E+03, 8.0285260366E-01],
	[2.02000E+04, 9.6756391137E+03, 5.2128381157E+03, 1.6042263132E+03, 1.0886843695E+03, 8.0294799349E-01],
	[2.02050E+04, 9.6791898354E+03, 5.2126506773E+03, 1.6054977311E+03, 1.0893065681E+03, 8.0304334157E-01],
	[2.02100E+04, 9.6827409811E+03, 5.2124632921E+03, 1.6067698407E+03, 1.0899288427E+03, 8.0313864791E-01],
	[2.02150E+04, 9.6862925508E+03, 5.2122759599E+03, 1.6080426421E+03, 1.0905511930E+03, 8.0323391250E-01],
	[2.02200E+04, 9.6898445443E+03, 5.2120886808E+03, 1.6093161355E+03, 1.0911736188E+03, 8.0332913536E-01],
	[2.02250E+04, 9.6933969616E+03, 5.2119014548E+03, 1.6105903212E+03, 1.0917961201E+03, 8.0342431648E-01],
	[2.02300E+04, 9.6969498027E+03, 5.2117142817E+03, 1.6118651994E+03, 1.0924186966E+03, 8.0351945589E-01],
	[2.02350E+04, 9.7005030675E+03, 5.2115271616E+03, 1.6131407703E+03, 1.0930413483E+03, 8.0361455357E-01],
	[2.02400E+04, 9.7040567560E+03, 5.2113400945E+03, 1.6144170341E+03, 1.0936640749E+03, 8.0370960955E-01],
	[2.02450E+04, 9.7076108680E+03, 5.2111530802E+03, 1.6156939909E+03, 1.0942868764E+03, 8.0380462382E-01],
	[2.02500E+04, 9.7111654036E+03, 5.2109661189E+03, 1.6169716410E+03, 1.0949097525E+03, 8.0389959639E-01],
	[2.02550E+04, 9.7147203627E+03, 5.2107792105E+03, 1.6182499846E+03, 1.0955327031E+03, 8.0399452726E-01],
	[2.02600E+04, 9.7182757452E+03, 5.2105923548E+03, 1.6195290219E+03, 1.0961557281E+03, 8.0408941645E-01],
	[2.02650E+04, 9.7218315511E+03, 5.2104055520E+03, 1.6208087531E+03, 1.0967788273E+03, 8.0418426395E-01],
	[2.02700E+04, 9.7253877804E+03, 5.2102188019E+03, 1.6220891785E+03, 1.0974020006E+03, 8.0427906978E-01],
	[2.02750E+04, 9.7289444329E+03, 5.2100321046E+03, 1.6233702981E+03, 1.0980252478E+03, 8.0437383394E-01],
	[2.02800E+04, 9.7325015086E+03, 5.2098454601E+03, 1.6246521122E+03, 1.0986485687E+03, 8.0446855644E-01],
	[2.02850E+04, 9.7360590075E+03, 5.2096588682E+03, 1.6259346210E+03, 1.0992719633E+03, 8.0456323728E-01],
	[2.02900E+04, 9.7396169295E+03, 5.2094723290E+03, 1.6272178248E+03, 1.0998954314E+03, 8.0465787646E-01],
	[2.02950E+04, 9.7431752746E+03, 5.2092858424E+03, 1.6285017237E+03, 1.1005189727E+03, 8.0475247400E-01],
	[2.03000E+04, 9.7467340427E+03, 5.2090994085E+03, 1.6297863179E+03, 1.1011425873E+03, 8.0484702991E-01],
	[2.03050E+04, 9.7502932337E+03, 5.2089130271E+03, 1.6310716077E+03, 1.1017662748E+03, 8.0494154417E-01],
	[2.03100E+04, 9.7538528476E+03, 5.2087266983E+03, 1.6323575932E+03, 1.1023900352E+03, 8.0503601682E-01],
	[2.03150E+04, 9.7574128844E+03, 5.2085404220E+03, 1.6336442746E+03, 1.1030138683E+03, 8.0513044784E-01],
	[2.03200E+04, 9.7609733439E+03, 5.2083541982E+03, 1.6349316522E+03, 1.1036377740E+03, 8.0522483725E-01],
	[2.03250E+04, 9.7645342262E+03, 5.2081680269E+03, 1.6362197261E+03, 1.1042617521E+03, 8.0531918505E-01],
	[2.03300E+04, 9.7680955312E+03, 5.2079819080E+03, 1.6375084966E+03, 1.1048858025E+03, 8.0541349125E-01],
	[2.03350E+04, 9.7716572588E+03, 5.2077958415E+03, 1.6387979639E+03, 1.1055099250E+03, 8.0550775585E-01],
	[2.03400E+04, 9.7752194090E+03, 5.2076098275E+03, 1.6400881281E+03, 1.1061341194E+03, 8.0560197887E-01],
	[2.03450E+04, 9.7787819817E+03, 5.2074238658E+03, 1.6413789895E+03, 1.1067583857E+03, 8.0569616030E-01],
	[2.03500E+04, 9.7823449768E+03, 5.2072379564E+03, 1.6426705482E+03, 1.1073827236E+03, 8.0579030016E-01],
	[2.03550E+04, 9.7859083944E+03, 5.2070520993E+03, 1.6439628046E+03, 1.1080071330E+03, 8.0588439845E-01],
	[2.03600E+04, 9.7894722343E+03, 5.2068662945E+03, 1.6452557587E+03, 1.1086316138E+03, 8.0597845518E-01],
	[2.03650E+04, 9.7930364965E+03, 5.2066805420E+03, 1.6465494108E+03, 1.1092561658E+03, 8.0607247036E-01],
	[2.03700E+04, 9.7966011810E+03, 5.2064948417E+03, 1.6478437611E+03, 1.1098807889E+03, 8.0616644398E-01],
	[2.03750E+04, 9.8001662877E+03, 5.2063091936E+03, 1.6491388098E+03, 1.1105054829E+03, 8.0626037606E-01],
	[2.03800E+04, 9.8037318165E+03, 5.2061235977E+03, 1.6504345570E+03, 1.1111302477E+03, 8.0635426661E-01],
	[2.03850E+04, 9.8072977675E+03, 5.2059380539E+03, 1.6517310031E+03, 1.1117550830E+03, 8.0644811562E-01],
	[2.03900E+04, 9.8108641404E+03, 5.2057525622E+03, 1.6530281482E+03, 1.1123799888E+03, 8.0654192312E-01],
	[2.03950E+04, 9.8144309354E+03, 5.2055671226E+03, 1.6543259925E+03, 1.1130049650E+03, 8.0663568910E-01],
	[2.04000E+04, 9.8179981522E+03, 5.2053817351E+03, 1.6556245363E+03, 1.1136300113E+03, 8.0672941357E-01],
	[2.04050E+04, 9.8215657910E+03, 5.2051963995E+03, 1.6569237796E+03, 1.1142551276E+03, 8.0682309654E-01],
	[2.04100E+04, 9.8251338515E+03, 5.2050111160E+03, 1.6582237228E+03, 1.1148803138E+03, 8.0691673801E-01],
	[2.04150E+04, 9.8287023339E+03, 5.2048258845E+03, 1.6595243660E+03, 1.1155055697E+03, 8.0701033799E-01],
	[2.04200E+04, 9.8322712379E+03, 5.2046407050E+03, 1.6608257095E+03, 1.1161308951E+03, 8.0710389650E-01],
	[2.04250E+04, 9.8358405636E+03, 5.2044555773E+03, 1.6621277533E+03, 1.1167562900E+03, 8.0719741353E-01],
	[2.04300E+04, 9.8394103110E+03, 5.2042705016E+03, 1.6634304979E+03, 1.1173817541E+03, 8.0729088909E-01],
	[2.04350E+04, 9.8429804799E+03, 5.2040854777E+03, 1.6647339433E+03, 1.1180072874E+03, 8.0738432319E-01],
	[2.04400E+04, 9.8465510702E+03, 5.2039005056E+03, 1.6660380897E+03, 1.1186328896E+03, 8.0747771584E-01],
	[2.04450E+04, 9.8501220821E+03, 5.2037155854E+03, 1.6673429374E+03, 1.1192585606E+03, 8.0757106704E-01],
	[2.04500E+04, 9.8536935153E+03, 5.2035307170E+03, 1.6686484865E+03, 1.1198843002E+03, 8.0766437680E-01],
	[2.04550E+04, 9.8572653699E+03, 5.2033459003E+03, 1.6699547373E+03, 1.1205101084E+03, 8.0775764513E-01],
	[2.04600E+04, 9.8608376457E+03, 5.2031611353E+03, 1.6712616900E+03, 1.1211359850E+03, 8.0785087203E-01],
	[2.04650E+04, 9.8644103428E+03, 5.2029764221E+03, 1.6725693448E+03, 1.1217619298E+03, 8.0794405752E-01],
	[2.04700E+04, 9.8679834611E+03, 5.2027917605E+03, 1.6738777019E+03, 1.1223879426E+03, 8.0803720159E-01],
	[2.04750E+04, 9.8715570005E+03, 5.2026071506E+03, 1.6751867614E+03, 1.1230140233E+03, 8.0813030426E-01],
	[2.04800E+04, 9.8751309610E+03, 5.2024225923E+03, 1.6764965236E+03, 1.1236401718E+03, 8.0822336554E-01],
	[2.04850E+04, 9.8787053425E+03, 5.2022380856E+03, 1.6778069887E+03, 1.1242663879E+03, 8.0831638542E-01],
	[2.04900E+04, 9.8822801450E+03, 5.2020536305E+03, 1.6791181570E+03, 1.1248926715E+03, 8.0840936393E-01],
	[2.04950E+04, 9.8858553684E+03, 5.2018692269E+03, 1.6804300285E+03, 1.1255190224E+03, 8.0850230106E-01],
	[2.05000E+04, 9.8894310126E+03, 5.2016848749E+03, 1.6817426035E+03, 1.1261454405E+03, 8.0859519682E-01],
	[2.05050E+04, 9.8930070777E+03, 5.2015005743E+03, 1.6830558823E+03, 1.1267719256E+03, 8.0868805122E-01],
	[2.05100E+04, 9.8965835635E+03, 5.2013163252E+03, 1.6843698649E+03, 1.1273984775E+03, 8.0878086427E-01],
	[2.05150E+04, 9.9001604700E+03, 5.2011321275E+03, 1.6856845517E+03, 1.1280250961E+03, 8.0887363597E-01],
	[2.05200E+04, 9.9037377972E+03, 5.2009479813E+03, 1.6869999429E+03, 1.1286517814E+03, 8.0896636634E-01],
	[2.05250E+04, 9.9073155450E+03, 5.2007638864E+03, 1.6883160385E+03, 1.1292785330E+03, 8.0905905537E-01],
	[2.05300E+04, 9.9108937133E+03, 5.2005798429E+03, 1.6896328389E+03, 1.1299053509E+03, 8.0915170308E-01],
	[2.05350E+04, 9.9144723021E+03, 5.2003958507E+03, 1.6909503442E+03, 1.1305322349E+03, 8.0924430948E-01],
	[2.05400E+04, 9.9180513114E+03, 5.2002119098E+03, 1.6922685547E+03, 1.1311591849E+03, 8.0933687457E-01],
	[2.05450E+04, 9.9216307410E+03, 5.2000280201E+03, 1.6935874705E+03, 1.1317862007E+03, 8.0942939836E-01],
	[2.05500E+04, 9.9252105910E+03, 5.1998441818E+03, 1.6949070919E+03, 1.1324132821E+03, 8.0952188085E-01],
	[2.05550E+04, 9.9287908612E+03, 5.1996603946E+03, 1.6962274191E+03, 1.1330404291E+03, 8.0961432206E-01],
	[2.05600E+04, 9.9323715517E+03, 5.1994766586E+03, 1.6975484522E+03, 1.1336676414E+03, 8.0970672199E-01],
	[2.05650E+04, 9.9359526624E+03, 5.1992929739E+03, 1.6988701915E+03, 1.1342949190E+03, 8.0979908066E-01],
	[2.05700E+04, 9.9395341931E+03, 5.1991093402E+03, 1.7001926371E+03, 1.1349222616E+03, 8.0989139806E-01],
	[2.05750E+04, 9.9431161440E+03, 5.1989257577E+03, 1.7015157894E+03, 1.1355496692E+03, 8.0998367420E-01],
	[2.05800E+04, 9.9466985148E+03, 5.1987422262E+03, 1.7028396484E+03, 1.1361771415E+03, 8.1007590910E-01],
	[2.05850E+04, 9.9502813057E+03, 5.1985587458E+03, 1.7041642144E+03, 1.1368046784E+03, 8.1016810276E-01],
	[2.05900E+04, 9.9538645164E+03, 5.1983753165E+03, 1.7054894876E+03, 1.1374322798E+03, 8.1026025519E-01],
	[2.05950E+04, 9.9574481470E+03, 5.1981919381E+03, 1.7068154682E+03, 1.1380599455E+03, 8.1035236640E-01],
	[2.06000E+04, 9.9610321974E+03, 5.1980086108E+03, 1.7081421564E+03, 1.1386876754E+03, 8.1044443639E-01],
	[2.06050E+04, 9.9646166675E+03, 5.1978253343E+03, 1.7094695524E+03, 1.1393154693E+03, 8.1053646517E-01],
	[2.06100E+04, 9.9682015574E+03, 5.1976421089E+03, 1.7107976565E+03, 1.1399433271E+03, 8.1062845275E-01],
	[2.06150E+04, 9.9717868669E+03, 5.1974589343E+03, 1.7121264687E+03, 1.1405712486E+03, 8.1072039914E-01],
	[2.06200E+04, 9.9753725959E+03, 5.1972758106E+03, 1.7134559894E+03, 1.1411992337E+03, 8.1081230435E-01],
	[2.06250E+04, 9.9789587446E+03, 5.1970927377E+03, 1.7147862187E+03, 1.1418272821E+03, 8.1090416838E-01],
	[2.06300E+04, 9.9825453127E+03, 5.1969097157E+03, 1.7161171569E+03, 1.1424553939E+03, 8.1099599124E-01],
	[2.06350E+04, 9.9861323002E+03, 5.1967267444E+03, 1.7174488040E+03, 1.1430835688E+03, 8.1108777295E-01],
	[2.06400E+04, 9.9897197072E+03, 5.1965438240E+03, 1.7187811605E+03, 1.1437118067E+03, 8.1117951350E-01],
	[2.06450E+04, 9.9933075334E+03, 5.1963609542E+03, 1.7201142263E+03, 1.1443401073E+03, 8.1127121290E-01],
	[2.06500E+04, 9.9969296226E+03, 5.1961882681E+03, 1.7214480019E+03, 1.1449694066E+03, 8.1136287117E-01],
	[2.06550E+04, 1.0000564054E+04, 5.1960191929E+03, 1.7227824872E+03, 1.1455990995E+03, 8.1145448832E-01],
	[2.06600E+04, 1.0004198926E+04, 5.1958501641E+03, 1.7241176827E+03, 1.1462288567E+03, 8.1154606434E-01],
	[2.06650E+04, 1.0007834239E+04, 5.1956811817E+03, 1.7254535884E+03, 1.1468586783E+03, 8.1163759925E-01],
	[2.06700E+04, 1.0011469993E+04, 5.1955122456E+03, 1.7267902046E+03, 1.1474885641E+03, 8.1172909306E-01],
	[2.06750E+04, 1.0015106188E+04, 5.1953433559E+03, 1.7281275315E+03, 1.1481185139E+03, 8.1182054578E-01],
	[2.06800E+04, 1.0018742824E+04, 5.1951745126E+03, 1.7294655692E+03, 1.1487485275E+03, 8.1191195740E-01],
	[2.06850E+04, 1.0022379901E+04, 5.1950057155E+03, 1.7308043181E+03, 1.1493786049E+03, 8.1200332795E-01],
	[2.06900E+04, 1.0026017419E+04, 5.1948369648E+03, 1.7321437782E+03, 1.1500087458E+03, 8.1209465743E-01],
	[2.06950E+04, 1.0029655378E+04, 5.1946682602E+03, 1.7334839498E+03, 1.1506389502E+03, 8.1218594585E-01],
	[2.07000E+04, 1.0033293777E+04, 5.1944996020E+03, 1.7348248332E+03, 1.1512692178E+03, 8.1227719321E-01],
	[2.07050E+04, 1.0036932617E+04, 5.1943309899E+03, 1.7361664284E+03, 1.1518995486E+03, 8.1236839953E-01],
	[2.07100E+04, 1.0040571898E+04, 5.1941624240E+03, 1.7375087358E+03, 1.1525299424E+03, 8.1245956481E-01],
	[2.07150E+04, 1.0044211619E+04, 5.1939939043E+03, 1.7388517554E+03, 1.1531603990E+03, 8.1255068906E-01],
	[2.07200E+04, 1.0047851781E+04, 5.1938254307E+03, 1.7401954876E+03, 1.1537909182E+03, 8.1264177229E-01],
	[2.07250E+04, 1.0051492383E+04, 5.1936570032E+03, 1.7415399325E+03, 1.1544215000E+03, 8.1273281451E-01],
	[2.07300E+04, 1.0055133425E+04, 5.1934886218E+03, 1.7428850904E+03, 1.1550521442E+03, 8.1282381573E-01],
	[2.07350E+04, 1.0058774908E+04, 5.1933202864E+03, 1.7442309614E+03, 1.1556828507E+03, 8.1291477595E-01],
	[2.07400E+04, 1.0062416832E+04, 5.1931519972E+03, 1.7455775457E+03, 1.1563136192E+03, 8.1300569519E-01],
	[2.07450E+04, 1.0066059195E+04, 5.1929837539E+03, 1.7469248436E+03, 1.1569444497E+03, 8.1309657345E-01],
	[2.07500E+04, 1.0069701999E+04, 5.1928155566E+03, 1.7482728553E+03, 1.1575753419E+03, 8.1318741074E-01],
	[2.07550E+04, 1.0073345242E+04, 5.1926474053E+03, 1.7496215809E+03, 1.1582062959E+03, 8.1327820707E-01],
	[2.07600E+04, 1.0076988926E+04, 5.1924792999E+03, 1.7509710207E+03, 1.1588373113E+03, 8.1336896244E-01],
	[2.07650E+04, 1.0080633050E+04, 5.1923112405E+03, 1.7523211748E+03, 1.1594683880E+03, 8.1345967688E-01],
	[2.07700E+04, 1.0084277614E+04, 5.1921432270E+03, 1.7536720435E+03, 1.1600995260E+03, 8.1355035038E-01],
	[2.07750E+04, 1.0087922618E+04, 5.1919752593E+03, 1.7550236270E+03, 1.1607307250E+03, 8.1364098295E-01],
	[2.07800E+04, 1.0091568062E+04, 5.1918073375E+03, 1.7563759255E+03, 1.1613619850E+03, 8.1373157461E-01],
	[2.07850E+04, 1.0095213945E+04, 5.1916394615E+03, 1.7577289392E+03, 1.1619933057E+03, 8.1382212536E-01],
	[2.07900E+04, 1.0098860268E+04, 5.1914716313E+03, 1.7590826682E+03, 1.1626246870E+03, 8.1391263521E-01],
	[2.07950E+04, 1.0102507031E+04, 5.1913038469E+03, 1.7604371129E+03, 1.1632561288E+03, 8.1400310417E-01],
	[2.08000E+04, 1.0106154234E+04, 5.1911361083E+03, 1.7617922734E+03, 1.1638876308E+03, 8.1409353224E-01],
	[2.08050E+04, 1.0109801876E+04, 5.1909684154E+03, 1.7631481498E+03, 1.1645191931E+03, 8.1418391945E-01],
	[2.08100E+04, 1.0113449958E+04, 5.1908007682E+03, 1.7645047425E+03, 1.1651508154E+03, 8.1427426579E-01],
	[2.08150E+04, 1.0117098479E+04, 5.1906331667E+03, 1.7658620517E+03, 1.1657824975E+03, 8.1436457127E-01],
	[2.08200E+04, 1.0120747440E+04, 5.1904656109E+03, 1.7672200774E+03, 1.1664142394E+03, 8.1445483591E-01],
	[2.08250E+04, 1.0124396840E+04, 5.1902981007E+03, 1.7685788200E+03, 1.1670460409E+03, 8.1454505970E-01],
	[2.08300E+04, 1.0128046680E+04, 5.1901306361E+03, 1.7699382796E+03, 1.1676779018E+03, 8.1463524267E-01],
	[2.08350E+04, 1.0131696959E+04, 5.1899632171E+03, 1.7712984565E+03, 1.1683098219E+03, 8.1472538483E-01],
	[2.08400E+04, 1.0135347677E+04, 5.1897958437E+03, 1.7726593508E+03, 1.1689418012E+03, 8.1481548616E-01],
	[2.08450E+04, 1.0138998834E+04, 5.1896285158E+03, 1.7740209627E+03, 1.1695738395E+03, 8.1490554670E-01],
	[2.08500E+04, 1.0142650430E+04, 5.1894612335E+03, 1.7753832926E+03, 1.1702059367E+03, 8.1499556645E-01],
	[2.08550E+04, 1.0146302466E+04, 5.1892939967E+03, 1.7767463404E+03, 1.1708380925E+03, 8.1508554541E-01],
	[2.08600E+04, 1.0149954940E+04, 5.1891268053E+03, 1.7781101066E+03, 1.1714703069E+03, 8.1517548360E-01],
	[2.08650E+04, 1.0153607854E+04, 5.1889596594E+03, 1.7794745912E+03, 1.1721025796E+03, 8.1526538102E-01],
	[2.08700E+04, 1.0157261206E+04, 5.1887925589E+03, 1.7808397945E+03, 1.1727349106E+03, 8.1535523768E-01],
	[2.08750E+04, 1.0160914998E+04, 5.1886255039E+03, 1.7822057167E+03, 1.1733672998E+03, 8.1544505360E-01],
	[2.08800E+04, 1.0164569228E+04, 5.1884584942E+03, 1.7835723580E+03, 1.1739997468E+03, 8.1553482878E-01],
	[2.08850E+04, 1.0168223897E+04, 5.1882915299E+03, 1.7849397186E+03, 1.1746322517E+03, 8.1562456323E-01],
	[2.08900E+04, 1.0171879004E+04, 5.1881246109E+03, 1.7863077987E+03, 1.1752648142E+03, 8.1571425696E-01],
	[2.08950E+04, 1.0175534550E+04, 5.1879577372E+03, 1.7876765984E+03, 1.1758974343E+03, 8.1580390998E-01],
	[2.09000E+04, 1.0179190535E+04, 5.1877909088E+03, 1.7890461181E+03, 1.1765301117E+03, 8.1589352230E-01],
	[2.09050E+04, 1.0182846959E+04, 5.1876241257E+03, 1.7904163580E+03, 1.1771628463E+03, 8.1598309393E-01],
	[2.09100E+04, 1.0186503821E+04, 5.1874573879E+03, 1.7917873181E+03, 1.1777956380E+03, 8.1607262487E-01],
	[2.09150E+04, 1.0190161121E+04, 5.1872906952E+03, 1.7931589988E+03, 1.1784284866E+03, 8.1616211514E-01],
	[2.09200E+04, 1.0193818860E+04, 5.1871240478E+03, 1.7945314002E+03, 1.1790613920E+03, 8.1625156475E-01],
	[2.09250E+04, 1.0197477037E+04, 5.1869574455E+03, 1.7959045225E+03, 1.1796943540E+03, 8.1634097370E-01],
	[2.09300E+04, 1.0201135653E+04, 5.1867908884E+03, 1.7972783660E+03, 1.1803273725E+03, 8.1643034201E-01],
	[2.09350E+04, 1.0204794706E+04, 5.1866243764E+03, 1.7986529308E+03, 1.1809604474E+03, 8.1651966968E-01],
	[2.09400E+04, 1.0208454198E+04, 5.1864579096E+03, 1.8000282172E+03, 1.1815935784E+03, 8.1660895672E-01],
	[2.09450E+04, 1.0212114128E+04, 5.1862914878E+03, 1.8014042254E+03, 1.1822267654E+03, 8.1669820315E-01],
	[2.09500E+04, 1.0215774496E+04, 5.1861251111E+03, 1.8027809555E+03, 1.1828600084E+03, 8.1678740897E-01],
	[2.09550E+04, 1.0219435303E+04, 5.1859587794E+03, 1.8041584078E+03, 1.1834933071E+03, 8.1687657419E-01],
	[2.09600E+04, 1.0223096547E+04, 5.1857924927E+03, 1.8055365824E+03, 1.1841266614E+03, 8.1696569883E-01],
	[2.09650E+04, 1.0226758229E+04, 5.1856262511E+03, 1.8069154797E+03, 1.1847600711E+03, 8.1705478288E-01],
	[2.09700E+04, 1.0230420349E+04, 5.1854600543E+03, 1.8082950997E+03, 1.1853935361E+03, 8.1714382637E-01],
	[2.09750E+04, 1.0234082907E+04, 5.1852939026E+03, 1.8096754428E+03, 1.1860270563E+03, 8.1723282929E-01],
	[2.09800E+04, 1.0237745902E+04, 5.1851277958E+03, 1.8110565090E+03, 1.1866606315E+03, 8.1732179167E-01],
	[2.09850E+04, 1.0241409335E+04, 5.1849617338E+03, 1.8124382986E+03, 1.1872942616E+03, 8.1741071350E-01],
	[2.09900E+04, 1.0245073206E+04, 5.1847957168E+03, 1.8138208119E+03, 1.1879279463E+03, 8.1749959480E-01],
	[2.09950E+04, 1.0248737515E+04, 5.1846297446E+03, 1.8152040490E+03, 1.1885616857E+03, 8.1758843558E-01],
	[2.10000E+04, 1.0252402261E+04, 5.1844638172E+03, 1.8165880100E+03, 1.1891954794E+03, 8.1767723585E-01],
	[2.10050E+04, 1.0256067445E+04, 5.1842979347E+03, 1.8179726954E+03, 1.1898293275E+03, 8.1776599562E-01],
	[2.10100E+04, 1.0259733066E+04, 5.1841320969E+03, 1.8193581051E+03, 1.1904632296E+03, 8.1785471490E-01],
	[2.10150E+04, 1.0263399125E+04, 5.1839663039E+03, 1.8207442395E+03, 1.1910971857E+03, 8.1794339369E-01],
	[2.10200E+04, 1.0267065621E+04, 5.1838005556E+03, 1.8221310987E+03, 1.1917311957E+03, 8.1803203201E-01],
	[2.10250E+04, 1.0270732554E+04, 5.1836348521E+03, 1.8235186830E+03, 1.1923652594E+03, 8.1812062987E-01],
	[2.10300E+04, 1.0274399924E+04, 5.1834691933E+03, 1.8249069925E+03, 1.1929993765E+03, 8.1820918728E-01],
	[2.10350E+04, 1.0278067732E+04, 5.1833035791E+03, 1.8262960275E+03, 1.1936335471E+03, 8.1829770424E-01],
	[2.10400E+04, 1.0281735977E+04, 5.1831380096E+03, 1.8276857882E+03, 1.1942677709E+03, 8.1838618076E-01],
	[2.10450E+04, 1.0285404659E+04, 5.1829724847E+03, 1.8290762747E+03, 1.1949020478E+03, 8.1847461687E-01],
	[2.10500E+04, 1.0289073778E+04, 5.1828070044E+03, 1.8304674873E+03, 1.1955363777E+03, 8.1856301256E-01],
	[2.10550E+04, 1.0292743334E+04, 5.1826415687E+03, 1.8318594262E+03, 1.1961707604E+03, 8.1865136785E-01],
	[2.10600E+04, 1.0296413327E+04, 5.1824761775E+03, 1.8332520916E+03, 1.1968051957E+03, 8.1873968274E-01],
	[2.10650E+04, 1.0300083757E+04, 5.1823108309E+03, 1.8346454837E+03, 1.1974396835E+03, 8.1882795725E-01],
	[2.10700E+04, 1.0303754624E+04, 5.1821455289E+03, 1.8360396027E+03, 1.1980742237E+03, 8.1891619138E-01],
	[2.10750E+04, 1.0307425927E+04, 5.1819802713E+03, 1.8374344488E+03, 1.1987088162E+03, 8.1900438515E-01],
	[2.10800E+04, 1.0311097667E+04, 5.1818150581E+03, 1.8388300222E+03, 1.1993434606E+03, 8.1909253857E-01],
	[2.10850E+04, 1.0314769844E+04, 5.1816498895E+03, 1.8402263231E+03, 1.1999781571E+03, 8.1918065164E-01],
	[2.10900E+04, 1.0318442458E+04, 5.1814847652E+03, 1.8416233517E+03, 1.2006129052E+03, 8.1926872438E-01],
	[2.10950E+04, 1.0322115508E+04, 5.1813196854E+03, 1.8430211083E+03, 1.2012477051E+03, 8.1935675680E-01],
	[2.11000E+04, 1.0325788995E+04, 5.1811546499E+03, 1.8444195930E+03, 1.2018825564E+03, 8.1944474890E-01],
	[2.11050E+04, 1.0329462918E+04, 5.1809896588E+03, 1.8458188061E+03, 1.2025174590E+03, 8.1953270069E-01],
	[2.11100E+04, 1.0333137277E+04, 5.1808247120E+03, 1.8472187477E+03, 1.2031524128E+03, 8.1962061220E-01],
	[2.11150E+04, 1.0336812073E+04, 5.1806598096E+03, 1.8486194180E+03, 1.2037874177E+03, 8.1970848342E-01],
	[2.11200E+04, 1.0340487306E+04, 5.1804949514E+03, 1.8500208173E+03, 1.2044224734E+03, 8.1979631437E-01],
	[2.11250E+04, 1.0344162974E+04, 5.1803301375E+03, 1.8514229458E+03, 1.2050575800E+03, 8.1988410505E-01],
	[2.11300E+04, 1.0347839079E+04, 5.1801653679E+03, 1.8528258036E+03, 1.2056927371E+03, 8.1997185548E-01],
	[2.11350E+04, 1.0351515620E+04, 5.1800006424E+03, 1.8542293910E+03, 1.2063279447E+03, 8.2005956567E-01],
	[2.11400E+04, 1.0355192597E+04, 5.1798359612E+03, 1.8556337082E+03, 1.2069632026E+03, 8.2014723563E-01],
	[2.11450E+04, 1.0358870010E+04, 5.1796713241E+03, 1.8570387554E+03, 1.2075985106E+03, 8.2023486536E-01],
	[2.11500E+04, 1.0362547860E+04, 5.1795067313E+03, 1.8584445328E+03, 1.2082338687E+03, 8.2032245489E-01],
	[2.11550E+04, 1.0366226145E+04, 5.1793421825E+03, 1.8598510406E+03, 1.2088692766E+03, 8.2041000421E-01],
	[2.11600E+04, 1.0369904866E+04, 5.1791776779E+03, 1.8612582789E+03, 1.2095047343E+03, 8.2049751334E-01],
	[2.11650E+04, 1.0373584023E+04, 5.1790132173E+03, 1.8626662481E+03, 1.2101402416E+03, 8.2058498229E-01],
	[2.11700E+04, 1.0377263616E+04, 5.1788488008E+03, 1.8640749483E+03, 1.2107757983E+03, 8.2067241107E-01],
	[2.11750E+04, 1.0380943644E+04, 5.1786844284E+03, 1.8654843798E+03, 1.2114114042E+03, 8.2075979968E-01],
	[2.11800E+04, 1.0384624108E+04, 5.1785201000E+03, 1.8668945426E+03, 1.2120470594E+03, 8.2084714815E-01],
	[2.11850E+04, 1.0388305008E+04, 5.1783558155E+03, 1.8683054371E+03, 1.2126827635E+03, 8.2093445648E-01],
	[2.11900E+04, 1.0391986344E+04, 5.1781915751E+03, 1.8697170634E+03, 1.2133185164E+03, 8.2102172468E-01],
	[2.11950E+04, 1.0395668115E+04, 5.1780273786E+03, 1.8711294218E+03, 1.2139543181E+03, 8.2110895277E-01],
	[2.12000E+04, 1.0399350321E+04, 5.1778632261E+03, 1.8725425125E+03, 1.2145901683E+03, 8.2119614074E-01],
	[2.12050E+04, 1.0403032963E+04, 5.1776991175E+03, 1.8739563355E+03, 1.2152260670E+03, 8.2128328862E-01],
	[2.12100E+04, 1.0406716041E+04, 5.1775350527E+03, 1.8753708913E+03, 1.2158620139E+03, 8.2137039641E-01],
	[2.12150E+04, 1.0410399554E+04, 5.1773710318E+03, 1.8767861799E+03, 1.2164980089E+03, 8.2145746413E-01],
	[2.12200E+04, 1.0414083502E+04, 5.1772070548E+03, 1.8782022016E+03, 1.2171340519E+03, 8.2154449177E-01],
	[2.12250E+04, 1.0417767885E+04, 5.1770431216E+03, 1.8796189566E+03, 1.2177701427E+03, 8.2163147937E-01],
	[2.12300E+04, 1.0421452704E+04, 5.1768792322E+03, 1.8810364451E+03, 1.2184062812E+03, 8.2171842692E-01],
	[2.12350E+04, 1.0425137957E+04, 5.1767153866E+03, 1.8824546672E+03, 1.2190424673E+03, 8.2180533443E-01],
	[2.12400E+04, 1.0428823646E+04, 5.1765515847E+03, 1.8838736233E+03, 1.2196787007E+03, 8.2189220192E-01],
	[2.12450E+04, 1.0432509770E+04, 5.1763878266E+03, 1.8852933134E+03, 1.2203149814E+03, 8.2197902940E-01],
	[2.12500E+04, 1.0436196329E+04, 5.1762241122E+03, 1.8867137379E+03, 1.2209513091E+03, 8.2206581688E-01],
	[2.12550E+04, 1.0439883323E+04, 5.1760604415E+03, 1.8881348969E+03, 1.2215876839E+03, 8.2215256436E-01],
	[2.12600E+04, 1.0443570751E+04, 5.1758968144E+03, 1.8895567906E+03, 1.2222241054E+03, 8.2223927187E-01],
	[2.12650E+04, 1.0447258615E+04, 5.1757332310E+03, 1.8909794193E+03, 1.2228605736E+03, 8.2232593940E-01],
	[2.12700E+04, 1.0450946913E+04, 5.1755696913E+03, 1.8924027831E+03, 1.2234970883E+03, 8.2241256697E-01],
	[2.12750E+04, 1.0454635646E+04, 5.1754061951E+03, 1.8938268822E+03, 1.2241336494E+03, 8.2249915460E-01],
	[2.12800E+04, 1.0458324814E+04, 5.1752427425E+03, 1.8952517169E+03, 1.2247702567E+03, 8.2258570229E-01],
	[2.12850E+04, 1.0462014416E+04, 5.1750793335E+03, 1.8966772873E+03, 1.2254069101E+03, 8.2267221005E-01],
	[2.12900E+04, 1.0465704453E+04, 5.1749159680E+03, 1.8981035937E+03, 1.2260436094E+03, 8.2275867790E-01],
	[2.12950E+04, 1.0469394925E+04, 5.1747526460E+03, 1.8995306363E+03, 1.2266803545E+03, 8.2284510584E-01],
	[2.13000E+04, 1.0473085831E+04, 5.1745893676E+03, 1.9009584152E+03, 1.2273171452E+03, 8.2293149388E-01],
	[2.13050E+04, 1.0476777171E+04, 5.1744261326E+03, 1.9023869307E+03, 1.2279539815E+03, 8.2301784205E-01],
	[2.13100E+04, 1.0480468946E+04, 5.1742629410E+03, 1.9038161830E+03, 1.2285908631E+03, 8.2310415034E-01],
	[2.13150E+04, 1.0484161155E+04, 5.1740997929E+03, 1.9052461723E+03, 1.2292277899E+03, 8.2319041876E-01],
	[2.13200E+04, 1.0487853798E+04, 5.1739366882E+03, 1.9066768987E+03, 1.2298647617E+03, 8.2327664734E-01],
	[2.13250E+04, 1.0491546876E+04, 5.1737736269E+03, 1.9081083626E+03, 1.2305017785E+03, 8.2336283608E-01],
	[2.13300E+04, 1.0495240388E+04, 5.1736106089E+03, 1.9095405641E+03, 1.2311388400E+03, 8.2344898499E-01],
	[2.13350E+04, 1.0498934334E+04, 5.1734476343E+03, 1.9109735034E+03, 1.2317759462E+03, 8.2353509408E-01],
	[2.13400E+04, 1.0502628714E+04, 5.1732847030E+03, 1.9124071808E+03, 1.2324130968E+03, 8.2362116336E-01],
	[2.13450E+04, 1.0506323528E+04, 5.1731218151E+03, 1.9138415963E+03, 1.2330502918E+03, 8.2370719284E-01],
	[2.13500E+04, 1.0510018776E+04, 5.1729589703E+03, 1.9152767503E+03, 1.2336875310E+03, 8.2379318255E-01],
	[2.13550E+04, 1.0513714458E+04, 5.1727961689E+03, 1.9167126429E+03, 1.2343248142E+03, 8.2387913247E-01],
	[2.13600E+04, 1.0517410574E+04, 5.1726334107E+03, 1.9181492744E+03, 1.2349621413E+03, 8.2396504264E-01],
	[2.13650E+04, 1.0521107123E+04, 5.1724706957E+03, 1.9195866449E+03, 1.2355995122E+03, 8.2405091305E-01],
	[2.13700E+04, 1.0524804107E+04, 5.1723080239E+03, 1.9210247547E+03, 1.2362369266E+03, 8.2413674372E-01],
	[2.13750E+04, 1.0528501524E+04, 5.1721453952E+03, 1.9224636040E+03, 1.2368743846E+03, 8.2422253467E-01],
	[2.13800E+04, 1.0532199375E+04, 5.1719828097E+03, 1.9239031929E+03, 1.2375118858E+03, 8.2430828589E-01],
	[2.13850E+04, 1.0535897659E+04, 5.1718202674E+03, 1.9253435217E+03, 1.2381494302E+03, 8.2439399741E-01],
	[2.13900E+04, 1.0539596377E+04, 5.1716577681E+03, 1.9267845906E+03, 1.2387870177E+03, 8.2447966923E-01],
	[2.13950E+04, 1.0543295529E+04, 5.1714953119E+03, 1.9282263998E+03, 1.2394246480E+03, 8.2456530133E-01],
	[2.14000E+04, 1.0546995114E+04, 5.1713328988E+03, 1.9296689494E+03, 1.2400623211E+03, 8.2465089373E-01],
	[2.14050E+04, 1.0550695132E+04, 5.1711705288E+03, 1.9311122398E+03, 1.2407000368E+03, 8.2473644641E-01],
	[2.14100E+04, 1.0554395584E+04, 5.1710082017E+03, 1.9325562711E+03, 1.2413377949E+03, 8.2482195939E-01],
	[2.14150E+04, 1.0558096469E+04, 5.1708459176E+03, 1.9340010435E+03, 1.2419755953E+03, 8.2490743268E-01],
	[2.14200E+04, 1.0561797788E+04, 5.1706836766E+03, 1.9354465572E+03, 1.2426134379E+03, 8.2499286630E-01],
	[2.14250E+04, 1.0565499539E+04, 5.1705214785E+03, 1.9368928125E+03, 1.2432513225E+03, 8.2507826024E-01],
	[2.14300E+04, 1.0569201724E+04, 5.1703593233E+03, 1.9383398094E+03, 1.2438892489E+03, 8.2516361452E-01],
	[2.14350E+04, 1.0572904342E+04, 5.1701972110E+03, 1.9397875484E+03, 1.2445272171E+03, 8.2524892914E-01],
	[2.14400E+04, 1.0576607393E+04, 5.1700351416E+03, 1.9412360294E+03, 1.2451652269E+03, 8.2533420413E-01],
	[2.14450E+04, 1.0580310877E+04, 5.1698731151E+03, 1.9426852529E+03, 1.2458032781E+03, 8.2541943948E-01],
	[2.14500E+04, 1.0584014794E+04, 5.1697111315E+03, 1.9441352188E+03, 1.2464413706E+03, 8.2550463520E-01],
	[2.14550E+04, 1.0587719144E+04, 5.1695491906E+03, 1.9455859276E+03, 1.2470795042E+03, 8.2558979132E-01],
	[2.14600E+04, 1.0591423927E+04, 5.1693872926E+03, 1.9470373793E+03, 1.2477176789E+03, 8.2567490782E-01],
	[2.14650E+04, 1.0595129142E+04, 5.1692254373E+03, 1.9484895742E+03, 1.2483558944E+03, 8.2575998473E-01],
	[2.14700E+04, 1.0598836409E+04, 5.1690640902E+03, 1.9499425125E+03, 1.2489942002E+03, 8.2584502206E-01],
	[2.14750E+04, 1.0602588249E+04, 5.1689154712E+03, 1.9513961944E+03, 1.2496339013E+03, 8.2593001981E-01],
	[2.14800E+04, 1.0606340543E+04, 5.1687668911E+03, 1.9528506201E+03, 1.2502736450E+03, 8.2601497799E-01],
	[2.14850E+04, 1.0610093292E+04, 5.1686183499E+03, 1.9543057897E+03, 1.2509134311E+03, 8.2609989661E-01],
	[2.14900E+04, 1.0613846494E+04, 5.1684698475E+03, 1.9557617036E+03, 1.2515532595E+03, 8.2618477569E-01],
	[2.14950E+04, 1.0617600151E+04, 5.1683213839E+03, 1.9572183619E+03, 1.2521931300E+03, 8.2626961523E-01],
	[2.15000E+04, 1.0621354262E+04, 5.1681729591E+03, 1.9586757649E+03, 1.2528330425E+03, 8.2635441524E-01],
	[2.15050E+04, 1.0625108826E+04, 5.1680245730E+03, 1.9601339126E+03, 1.2534729969E+03, 8.2643917573E-01],
	[2.15100E+04, 1.0628863845E+04, 5.1678762258E+03, 1.9615928054E+03, 1.2541129929E+03, 8.2652389672E-01],
	[2.15150E+04, 1.0632619317E+04, 5.1677279172E+03, 1.9630524435E+03, 1.2547530306E+03, 8.2660857820E-01],
	[2.15200E+04, 1.0636375243E+04, 5.1675796474E+03, 1.9645128270E+03, 1.2553931096E+03, 8.2669322020E-01],
	[2.15250E+04, 1.0640131623E+04, 5.1674314163E+03, 1.9659739561E+03, 1.2560332300E+03, 8.2677782272E-01],
	[2.15300E+04, 1.0643888456E+04, 5.1672832238E+03, 1.9674358311E+03, 1.2566733914E+03, 8.2686238576E-01],
	[2.15350E+04, 1.0647645743E+04, 5.1671350700E+03, 1.9688984522E+03, 1.2573135939E+03, 8.2694690935E-01],
	[2.15400E+04, 1.0651403484E+04, 5.1669869549E+03, 1.9703618195E+03, 1.2579538372E+03, 8.2703139349E-01],
	[2.15450E+04, 1.0655161678E+04, 5.1668388784E+03, 1.9718259334E+03, 1.2585941212E+03, 8.2711583818E-01],
	[2.15500E+04, 1.0658920326E+04, 5.1666908404E+03, 1.9732907939E+03, 1.2592344458E+03, 8.2720024345E-01],
	[2.15550E+04, 1.0662679427E+04, 5.1665428411E+03, 1.9747564013E+03, 1.2598748108E+03, 8.2728460929E-01],
	[2.15600E+04, 1.0666438982E+04, 5.1663948803E+03, 1.9762227559E+03, 1.2605152161E+03, 8.2736893573E-01],
	[2.15650E+04, 1.0670198990E+04, 5.1662469581E+03, 1.9776898577E+03, 1.2611556615E+03, 8.2745322277E-01],
	[2.15700E+04, 1.0673959451E+04, 5.1660990744E+03, 1.9791577070E+03, 1.2617961469E+03, 8.2753747041E-01],
	[2.15750E+04, 1.0677720366E+04, 5.1659512292E+03, 1.9806263041E+03, 1.2624366722E+03, 8.2762167868E-01],
	[2.15800E+04, 1.0681481733E+04, 5.1658034225E+03, 1.9820956491E+03, 1.2630772371E+03, 8.2770584757E-01],
	[2.15850E+04, 1.0685243554E+04, 5.1656556543E+03, 1.9835657422E+03, 1.2637178416E+03, 8.2778997710E-01],
	[2.15900E+04, 1.0689005828E+04, 5.1655079245E+03, 1.9850365837E+03, 1.2643584856E+03, 8.2787406729E-01],
	[2.15950E+04, 1.0692768555E+04, 5.1653602331E+03, 1.9865081737E+03, 1.2649991688E+03, 8.2795811813E-01],
	[2.16000E+04, 1.0696531735E+04, 5.1652125802E+03, 1.9879805125E+03, 1.2656398912E+03, 8.2804212965E-01],
	[2.16050E+04, 1.0700295368E+04, 5.1650649656E+03, 1.9894536002E+03, 1.2662806525E+03, 8.2812610184E-01],
	[2.16100E+04, 1.0704059453E+04, 5.1649173895E+03, 1.9909274371E+03, 1.2669214527E+03, 8.2821003472E-01],
	[2.16150E+04, 1.0707823992E+04, 5.1647698517E+03, 1.9924020234E+03, 1.2675622916E+03, 8.2829392831E-01],
	[2.16200E+04, 1.0711588983E+04, 5.1646223522E+03, 1.9938773593E+03, 1.2682031691E+03, 8.2837778260E-01],
	[2.16250E+04, 1.0715354428E+04, 5.1644748910E+03, 1.9953534449E+03, 1.2688440850E+03, 8.2846159762E-01],
	[2.16300E+04, 1.0719120324E+04, 5.1643274682E+03, 1.9968302806E+03, 1.2694850391E+03, 8.2854537336E-01],
	[2.16350E+04, 1.0722886674E+04, 5.1641800836E+03, 1.9983078664E+03, 1.2701260314E+03, 8.2862910985E-01],
	[2.16400E+04, 1.0726653476E+04, 5.1640327373E+03, 1.9997862027E+03, 1.2707670617E+03, 8.2871280709E-01],
	[2.16450E+04, 1.0730420730E+04, 5.1638854292E+03, 2.0012652895E+03, 1.2714081299E+03, 8.2879646509E-01],
	[2.16500E+04, 1.0734188437E+04, 5.1637381594E+03, 2.0027451272E+03, 1.2720492357E+03, 8.2888008386E-01],
	[2.16550E+04, 1.0737956597E+04, 5.1635909277E+03, 2.0042257160E+03, 1.2726903792E+03, 8.2896366342E-01],
	[2.16600E+04, 1.0741725209E+04, 5.1634437343E+03, 2.0057070559E+03, 1.2733315600E+03, 8.2904720376E-01],
	[2.16650E+04, 1.0745494273E+04, 5.1632965790E+03, 2.0071891473E+03, 1.2739727781E+03, 8.2913070491E-01],
	[2.16700E+04, 1.0749263789E+04, 5.1631494619E+03, 2.0086719903E+03, 1.2746140334E+03, 8.2921416688E-01],
	[2.16750E+04, 1.0753033758E+04, 5.1630023829E+03, 2.0101555852E+03, 1.2752553257E+03, 8.2929758966E-01],
	[2.16800E+04, 1.0756804179E+04, 5.1628553420E+03, 2.0116399322E+03, 1.2758966548E+03, 8.2938097329E-01],
	[2.16850E+04, 1.0760575052E+04, 5.1627083392E+03, 2.0131250314E+03, 1.2765380207E+03, 8.2946431775E-01],
	[2.16900E+04, 1.0764346377E+04, 5.1625613745E+03, 2.0146108831E+03, 1.2771794231E+03, 8.2954762307E-01],
	[2.16950E+04, 1.0768118154E+04, 5.1624144478E+03, 2.0160974875E+03, 1.2778208619E+03, 8.2963088926E-01],
	[2.17000E+04, 1.0771890383E+04, 5.1622675592E+03, 2.0175848448E+03, 1.2784623370E+03, 8.2971411632E-01],
	[2.17050E+04, 1.0775663064E+04, 5.1621207086E+03, 2.0190729552E+03, 1.2791038483E+03, 8.2979730427E-01],
	[2.17100E+04, 1.0779436197E+04, 5.1619738960E+03, 2.0205618189E+03, 1.2797453956E+03, 8.2988045312E-01],
	[2.17150E+04, 1.0783209782E+04, 5.1618271213E+03, 2.0220514360E+03, 1.2803869787E+03, 8.2996356287E-01],
	[2.17200E+04, 1.0786983818E+04, 5.1616803847E+03, 2.0235418069E+03, 1.2810285976E+03, 8.3004663355E-01],
	[2.17250E+04, 1.0790758306E+04, 5.1615336860E+03, 2.0250329318E+03, 1.2816702520E+03, 8.3012966515E-01],
	[2.17300E+04, 1.0794533246E+04, 5.1613870252E+03, 2.0265248107E+03, 1.2823119419E+03, 8.3021265769E-01],
	[2.17350E+04, 1.0798308638E+04, 5.1612404023E+03, 2.0280174440E+03, 1.2829536671E+03, 8.3029561118E-01],
	[2.17400E+04, 1.0802084481E+04, 5.1610938173E+03, 2.0295108318E+03, 1.2835954274E+03, 8.3037852563E-01],
	[2.17450E+04, 1.0805860776E+04, 5.1609472702E+03, 2.0310049744E+03, 1.2842372227E+03, 8.3046140105E-01],
	[2.17500E+04, 1.0809637522E+04, 5.1608007609E+03, 2.0324998720E+03, 1.2848790529E+03, 8.3054423746E-01],
	[2.17550E+04, 1.0813414720E+04, 5.1606542895E+03, 2.0339955247E+03, 1.2855209178E+03, 8.3062703486E-01],
	[2.17600E+04, 1.0817192369E+04, 5.1605078559E+03, 2.0354919328E+03, 1.2861628174E+03, 8.3070979326E-01],
	[2.17650E+04, 1.0820970469E+04, 5.1603614601E+03, 2.0369890964E+03, 1.2868047513E+03, 8.3079251267E-01],
	[2.17700E+04, 1.0824749021E+04, 5.1602151020E+03, 2.0384870159E+03, 1.2874467196E+03, 8.3087519311E-01],
	[2.17750E+04, 1.0828528023E+04, 5.1600687818E+03, 2.0399856913E+03, 1.2880887220E+03, 8.3095783459E-01],
	[2.17800E+04, 1.0832307478E+04, 5.1599224992E+03, 2.0414851229E+03, 1.2887307584E+03, 8.3104043711E-01],
	[2.17850E+04, 1.0836087383E+04, 5.1597762544E+03, 2.0429853110E+03, 1.2893728288E+03, 8.3112300069E-01],
	[2.17900E+04, 1.0839867739E+04, 5.1596300473E+03, 2.0444862556E+03, 1.2900149328E+03, 8.3120552534E-01],
	[2.17950E+04, 1.0843648546E+04, 5.1594838779E+03, 2.0459879571E+03, 1.2906570705E+03, 8.3128801106E-01],
	[2.18000E+04, 1.0847429805E+04, 5.1593377461E+03, 2.0474904156E+03, 1.2912992416E+03, 8.3137045788E-01],
	[2.18050E+04, 1.0851211514E+04, 5.1591916520E+03, 2.0489936313E+03, 1.2919414460E+03, 8.3145286580E-01],
	[2.18100E+04, 1.0854993674E+04, 5.1590455955E+03, 2.0504976045E+03, 1.2925836836E+03, 8.3153523483E-01],
	[2.18150E+04, 1.0858776285E+04, 5.1588995767E+03, 2.0520023353E+03, 1.2932259542E+03, 8.3161756498E-01],
	[2.18200E+04, 1.0862559347E+04, 5.1587535954E+03, 2.0535078240E+03, 1.2938682577E+03, 8.3169985626E-01],
	[2.18250E+04, 1.0866342859E+04, 5.1586076517E+03, 2.0550140708E+03, 1.2945105940E+03, 8.3178210869E-01],
	[2.18300E+04, 1.0870126822E+04, 5.1584617456E+03, 2.0565210758E+03, 1.2951529628E+03, 8.3186432228E-01],
	[2.18350E+04, 1.0873911236E+04, 5.1583158770E+03, 2.0580288393E+03, 1.2957953642E+03, 8.3194649703E-01],
	[2.18400E+04, 1.0877696100E+04, 5.1581700460E+03, 2.0595373614E+03, 1.2964377978E+03, 8.3202863296E-01],
	[2.18450E+04, 1.0881481415E+04, 5.1580242524E+03, 2.0610466425E+03, 1.2970802637E+03, 8.3211073007E-01],
	[2.18500E+04, 1.0885267181E+04, 5.1578784963E+03, 2.0625566827E+03, 1.2977227616E+03, 8.3219278839E-01],
	[2.18550E+04, 1.0889053397E+04, 5.1577327777E+03, 2.0640674821E+03, 1.2983652914E+03, 8.3227480792E-01],
	[2.18600E+04, 1.0892840063E+04, 5.1575870966E+03, 2.0655790411E+03, 1.2990078529E+03, 8.3235678866E-01],
	[2.18650E+04, 1.0896627179E+04, 5.1574414528E+03, 2.0670913598E+03, 1.2996504461E+03, 8.3243873065E-01],
	[2.18700E+04, 1.0900414746E+04, 5.1572958465E+03, 2.0686044384E+03, 1.3002930707E+03, 8.3252063387E-01],
	[2.18750E+04, 1.0904202763E+04, 5.1571502776E+03, 2.0701182772E+03, 1.3009357267E+03, 8.3260249835E-01],
	[2.18800E+04, 1.0907991231E+04, 5.1570047460E+03, 2.0716328762E+03, 1.3015784139E+03, 8.3268432410E-01],
	[2.18850E+04, 1.0911780148E+04, 5.1568592519E+03, 2.0731482359E+03, 1.3022211322E+03, 8.3276611112E-01],
	[2.18900E+04, 1.0915569516E+04, 5.1567137950E+03, 2.0746643563E+03, 1.3028638813E+03, 8.3284785943E-01],
	[2.18950E+04, 1.0919359333E+04, 5.1565683755E+03, 2.0761812376E+03, 1.3035066613E+03, 8.3292956904E-01],
	[2.19000E+04, 1.0923149601E+04, 5.1564229933E+03, 2.0776988802E+03, 1.3041494719E+03, 8.3301123997E-01],
	[2.19050E+04, 1.0926940319E+04, 5.1562776483E+03, 2.0792172840E+03, 1.3047923129E+03, 8.3309287221E-01],
	[2.19100E+04, 1.0930731486E+04, 5.1561323407E+03, 2.0807364495E+03, 1.3054351844E+03, 8.3317446579E-01],
	[2.19150E+04, 1.0934523103E+04, 5.1559870703E+03, 2.0822563768E+03, 1.3060780860E+03, 8.3325602071E-01],
	[2.19200E+04, 1.0938315170E+04, 5.1558418371E+03, 2.0837770661E+03, 1.3067210177E+03, 8.3333753699E-01],
	[2.19250E+04, 1.0942107687E+04, 5.1556966411E+03, 2.0852985175E+03, 1.3073639794E+03, 8.3341901464E-01],
	[2.19300E+04, 1.0945900654E+04, 5.1555514823E+03, 2.0868207314E+03, 1.3080069708E+03, 8.3350045366E-01],
	[2.19350E+04, 1.0949694070E+04, 5.1554063607E+03, 2.0883437079E+03, 1.3086499919E+03, 8.3358185408E-01],
	[2.19400E+04, 1.0953487936E+04, 5.1552612763E+03, 2.0898674472E+03, 1.3092930426E+03, 8.3366321589E-01],
	[2.19450E+04, 1.0957282251E+04, 5.1551162290E+03, 2.0913919496E+03, 1.3099361225E+03, 8.3374453912E-01],
	[2.19500E+04, 1.0961077016E+04, 5.1549712188E+03, 2.0929172152E+03, 1.3105792318E+03, 8.3382582377E-01],
	[2.19550E+04, 1.0964872230E+04, 5.1548262458E+03, 2.0944432443E+03, 1.3112223701E+03, 8.3390706986E-01],
	[2.19600E+04, 1.0968667894E+04, 5.1546813098E+03, 2.0959700370E+03, 1.3118655373E+03, 8.3398827739E-01],
	[2.19650E+04, 1.0972464007E+04, 5.1545364109E+03, 2.0974975935E+03, 1.3125087334E+03, 8.3406944638E-01],
	[2.19700E+04, 1.0976260570E+04, 5.1543915490E+03, 2.0990259142E+03, 1.3131519582E+03, 8.3415057685E-01],
	[2.19750E+04, 1.0980057581E+04, 5.1542467242E+03, 2.1005549991E+03, 1.3137952115E+03, 8.3423166879E-01],
	[2.19800E+04, 1.0983855042E+04, 5.1541019364E+03, 2.1020848485E+03, 1.3144384931E+03, 8.3431272205E-01],
	[2.19850E+04, 1.0987652952E+04, 5.1539571856E+03, 2.1036154625E+03, 1.3150818031E+03, 8.3439373639E-01],
	[2.19900E+04, 1.0991451311E+04, 5.1538124717E+03, 2.1051468415E+03, 1.3157251411E+03, 8.3447471185E-01],
	[2.19950E+04, 1.0995250119E+04, 5.1536677949E+03, 2.1066789856E+03, 1.3163685071E+03, 8.3455564846E-01],
	[2.20000E+04, 1.0999049377E+04, 5.1535231550E+03, 2.1082118950E+03, 1.3170119010E+03, 8.3463654627E-01],
	[2.20050E+04, 1.1002849083E+04, 5.1533785520E+03, 2.1097455700E+03, 1.3176553225E+03, 8.3471740530E-01],
	[2.20100E+04, 1.1006649238E+04, 5.1532339859E+03, 2.1112800106E+03, 1.3182987716E+03, 8.3479822559E-01],
	[2.20150E+04, 1.1010449842E+04, 5.1530894567E+03, 2.1128152172E+03, 1.3189422481E+03, 8.3487900718E-01],
	[2.20200E+04, 1.1014250895E+04, 5.1529449644E+03, 2.1143511899E+03, 1.3195857519E+03, 8.3495975011E-01],
	[2.20250E+04, 1.1018052396E+04, 5.1528005089E+03, 2.1158879290E+03, 1.3202292828E+03, 8.3504045441E-01],
	[2.20300E+04, 1.1021854346E+04, 5.1526560903E+03, 2.1174254346E+03, 1.3208728408E+03, 8.3512112011E-01],
	[2.20350E+04, 1.1025656745E+04, 5.1525117085E+03, 2.1189637070E+03, 1.3215164255E+03, 8.3520174726E-01],
	[2.20400E+04, 1.1029459593E+04, 5.1523673635E+03, 2.1205027464E+03, 1.3221600370E+03, 8.3528233589E-01],
	[2.20450E+04, 1.1033262889E+04, 5.1522230553E+03, 2.1220425530E+03, 1.3228036751E+03, 8.3536288603E-01],
	[2.20500E+04, 1.1037066634E+04, 5.1520787838E+03, 2.1235831269E+03, 1.3234473396E+03, 8.3544339772E-01],
	[2.20550E+04, 1.1040870827E+04, 5.1519345491E+03, 2.1251244684E+03, 1.3240910304E+03, 8.3552387100E-01],
	[2.20600E+04, 1.1044675468E+04, 5.1517903511E+03, 2.1266665778E+03, 1.3247347474E+03, 8.3560430589E-01],
	[2.20650E+04, 1.1048480558E+04, 5.1516461899E+03, 2.1282094551E+03, 1.3253784904E+03, 8.3568470245E-01],
	[2.20700E+04, 1.1052286096E+04, 5.1515020653E+03, 2.1297531007E+03, 1.3260222592E+03, 8.3576506070E-01],
	[2.20750E+04, 1.1056092083E+04, 5.1513579775E+03, 2.1312975147E+03, 1.3266660539E+03, 8.3584538067E-01],
	[2.20800E+04, 1.1059898518E+04, 5.1512139262E+03, 2.1328426973E+03, 1.3273098741E+03, 8.3592566241E-01],
	[2.20850E+04, 1.1063705401E+04, 5.1510699117E+03, 2.1343886488E+03, 1.3279537198E+03, 8.3600590595E-01],
	[2.20900E+04, 1.1067512732E+04, 5.1509259337E+03, 2.1359353693E+03, 1.3285975908E+03, 8.3608611133E-01],
	[2.20950E+04, 1.1071320511E+04, 5.1507819924E+03, 2.1374828590E+03, 1.3292414869E+03, 8.3616627857E-01],
	[2.21000E+04, 1.1075128738E+04, 5.1506380876E+03, 2.1390311182E+03, 1.3298854082E+03, 8.3624640771E-01],
	[2.21050E+04, 1.1078937413E+04, 5.1504942194E+03, 2.1405801471E+03, 1.3305293543E+03, 8.3632649880E-01],
	[2.21100E+04, 1.1082746536E+04, 5.1503503878E+03, 2.1421299459E+03, 1.3311733252E+03, 8.3640655186E-01],
	[2.21150E+04, 1.1086556107E+04, 5.1502065927E+03, 2.1436805147E+03, 1.3318173208E+03, 8.3648656693E-01],
	[2.21200E+04, 1.1090366126E+04, 5.1500628342E+03, 2.1452318539E+03, 1.3324613408E+03, 8.3656654405E-01],
	[2.21250E+04, 1.1094176593E+04, 5.1499191121E+03, 2.1467839635E+03, 1.3331053852E+03, 8.3664648325E-01],
	[2.21300E+04, 1.1097987507E+04, 5.1497754265E+03, 2.1483368439E+03, 1.3337494538E+03, 8.3672638456E-01],
	[2.21350E+04, 1.1101798869E+04, 5.1496317774E+03, 2.1498904951E+03, 1.3343935465E+03, 8.3680624802E-01],
	[2.21400E+04, 1.1105610679E+04, 5.1494881648E+03, 2.1514449175E+03, 1.3350376631E+03, 8.3688607367E-01],
	[2.21450E+04, 1.1109422936E+04, 5.1493445885E+03, 2.1530001112E+03, 1.3356818035E+03, 8.3696586153E-01],
	[2.21500E+04, 1.1113235641E+04, 5.1492010487E+03, 2.1545560764E+03, 1.3363259676E+03, 8.3704561165E-01],
	[2.21550E+04, 1.1117048794E+04, 5.1490575453E+03, 2.1561128134E+03, 1.3369701552E+03, 8.3712532406E-01],
	[2.21600E+04, 1.1120862393E+04, 5.1489140783E+03, 2.1576703224E+03, 1.3376143662E+03, 8.3720499879E-01],
	[2.21650E+04, 1.1124676441E+04, 5.1487706476E+03, 2.1592286035E+03, 1.3382586004E+03, 8.3728463587E-01],
	[2.21700E+04, 1.1128490935E+04, 5.1486272533E+03, 2.1607876570E+03, 1.3389028578E+03, 8.3736423535E-01],
	[2.21750E+04, 1.1132305877E+04, 5.1484838953E+03, 2.1623474830E+03, 1.3395471381E+03, 8.3744379726E-01],
	[2.21800E+04, 1.1136121266E+04, 5.1483405736E+03, 2.1639080818E+03, 1.3401914412E+03, 8.3752332163E-01],
	[2.21850E+04, 1.1139937103E+04, 5.1481972882E+03, 2.1654694536E+03, 1.3408357670E+03, 8.3760280849E-01],
	[2.21900E+04, 1.1143753386E+04, 5.1480540391E+03, 2.1670315987E+03, 1.3414801154E+03, 8.3768225789E-01],
	[2.21950E+04, 1.1147570117E+04, 5.1479108263E+03, 2.1685945171E+03, 1.3421244862E+03, 8.3776166984E-01],
	[2.22000E+04, 1.1151387295E+04, 5.1477676497E+03, 2.1701582091E+03, 1.3427688793E+03, 8.3784104440E-01],
	[2.22050E+04, 1.1155204919E+04, 5.1476245093E+03, 2.1717226750E+03, 1.3434132945E+03, 8.3792038159E-01],
	[2.22100E+04, 1.1159022991E+04, 5.1474814051E+03, 2.1732879148E+03, 1.3440577317E+03, 8.3799968144E-01],
	[2.22150E+04, 1.1162841510E+04, 5.1473383371E+03, 2.1748539290E+03, 1.3447021908E+03, 8.3807894399E-01],
	[2.22200E+04, 1.1166660475E+04, 5.1471953053E+03, 2.1764207175E+03, 1.3453466716E+03, 8.3815816928E-01],
	[2.22250E+04, 1.1170479888E+04, 5.1470523096E+03, 2.1779882807E+03, 1.3459911740E+03, 8.3823735734E-01],
	[2.22300E+04, 1.1174299747E+04, 5.1469093501E+03, 2.1795566188E+03, 1.3466356978E+03, 8.3831650820E-01],
	[2.22350E+04, 1.1178120053E+04, 5.1467664267E+03, 2.1811257319E+03, 1.3472802430E+03, 8.3839562189E-01],
	[2.22400E+04, 1.1181940805E+04, 5.1466235394E+03, 2.1826956204E+03, 1.3479248093E+03, 8.3847469846E-01],
	[2.22450E+04, 1.1185762004E+04, 5.1464806882E+03, 2.1842662843E+03, 1.3485693967E+03, 8.3855373793E-01],
	[2.22500E+04, 1.1189583650E+04, 5.1463378730E+03, 2.1858377238E+03, 1.3492140050E+03, 8.3863274034E-01],
	[2.22550E+04, 1.1193405742E+04, 5.1461950939E+03, 2.1874099393E+03, 1.3498586340E+03, 8.3871170571E-01],
	[2.22600E+04, 1.1197228281E+04, 5.1460523508E+03, 2.1889829309E+03, 1.3505032837E+03, 8.3879063410E-01],
	[2.22650E+04, 1.1201051266E+04, 5.1459096438E+03, 2.1905566988E+03, 1.3511479538E+03, 8.3886952552E-01],
	[2.22700E+04, 1.1204874698E+04, 5.1457669728E+03, 2.1921312433E+03, 1.3517926443E+03, 8.3894838001E-01],
	[2.22750E+04, 1.1208698576E+04, 5.1456243377E+03, 2.1937065644E+03, 1.3524373550E+03, 8.3902719761E-01],
	[2.22800E+04, 1.1212522900E+04, 5.1454817386E+03, 2.1952826625E+03, 1.3530820858E+03, 8.3910597834E-01],
	[2.22850E+04, 1.1216347670E+04, 5.1453391754E+03, 2.1968595377E+03, 1.3537268365E+03, 8.3918472225E-01],
	[2.22900E+04, 1.1220172887E+04, 5.1451966482E+03, 2.1984371903E+03, 1.3543716070E+03, 8.3926342936E-01],
	[2.22950E+04, 1.1223998550E+04, 5.1450541569E+03, 2.2000156205E+03, 1.3550163972E+03, 8.3934209972E-01],
	[2.23000E+04, 1.1227824659E+04, 5.1449117015E+03, 2.2015948284E+03, 1.3556612069E+03, 8.3942073334E-01],
	[2.23050E+04, 1.1231651214E+04, 5.1447692820E+03, 2.2031748143E+03, 1.3563060360E+03, 8.3949933027E-01],
	[2.23100E+04, 1.1235478215E+04, 5.1446268983E+03, 2.2047555784E+03, 1.3569508843E+03, 8.3957789053E-01],
	[2.23150E+04, 1.1239305662E+04, 5.1444845505E+03, 2.2063371208E+03, 1.3575957518E+03, 8.3965641417E-01],
	[2.23200E+04, 1.1243133554E+04, 5.1443422385E+03, 2.2079194419E+03, 1.3582406382E+03, 8.3973490121E-01],
	[2.23250E+04, 1.1246961893E+04, 5.1441999623E+03, 2.2095025418E+03, 1.3588855435E+03, 8.3981335169E-01],
	[2.23300E+04, 1.1250825530E+04, 5.1440673402E+03, 2.2110864206E+03, 1.3595316483E+03, 8.3989176564E-01],
	[2.23350E+04, 1.1254700556E+04, 5.1439377653E+03, 2.2126710788E+03, 1.3601781436E+03, 8.3997014309E-01],
	[2.23400E+04, 1.1258576049E+04, 5.1438082227E+03, 2.2142565163E+03, 1.3608246595E+03, 8.4004848408E-01],
	[2.23450E+04, 1.1262452008E+04, 5.1436787124E+03, 2.2158427335E+03, 1.3614711959E+03, 8.4012678864E-01],
	[2.23500E+04, 1.1266328434E+04, 5.1435492343E+03, 2.2174297305E+03, 1.3621177527E+03, 8.4020505680E-01],
	[2.23550E+04, 1.1270205326E+04, 5.1434197885E+03, 2.2190175076E+03, 1.3627643296E+03, 8.4028328859E-01],
	[2.23600E+04, 1.1274082686E+04, 5.1432903748E+03, 2.2206060649E+03, 1.3634109267E+03, 8.4036148405E-01],
	[2.23650E+04, 1.1277960511E+04, 5.1431609933E+03, 2.2222013000E+03, 1.3640597657E+03, 8.4043964321E-01],
	[2.23700E+04, 1.1281838804E+04, 5.1430316440E+03, 2.2237982838E+03, 1.3647089869E+03, 8.4051776610E-01],
	[2.23750E+04, 1.1285717563E+04, 5.1429023269E+03, 2.2253960569E+03, 1.3653582285E+03, 8.4059585275E-01],
	[2.23800E+04, 1.1289596788E+04, 5.1427730419E+03, 2.2269946197E+03, 1.3660074904E+03, 8.4067390320E-01],
	[2.23850E+04, 1.1293476479E+04, 5.1426437890E+03, 2.2285939724E+03, 1.3666567724E+03, 8.4075191748E-01],
	[2.23900E+04, 1.1297356637E+04, 5.1425145683E+03, 2.2301941152E+03, 1.3673060743E+03, 8.4082989563E-01],
	[2.23950E+04, 1.1301237262E+04, 5.1423853796E+03, 2.2317950483E+03, 1.3679553961E+03, 8.4090783766E-01],
	[2.24000E+04, 1.1305118352E+04, 5.1422562230E+03, 2.2333967718E+03, 1.3686047376E+03, 8.4098574363E-01],
	[2.24050E+04, 1.1308999909E+04, 5.1421270985E+03, 2.2349992861E+03, 1.3692540986E+03, 8.4106361355E-01],
	[2.24100E+04, 1.1312881931E+04, 5.1419980061E+03, 2.2366025913E+03, 1.3699034791E+03, 8.4114144746E-01],
	[2.24150E+04, 1.1316764420E+04, 5.1418689457E+03, 2.2382066877E+03, 1.3705528788E+03, 8.4121924539E-01],
	[2.24200E+04, 1.1320647375E+04, 5.1417399173E+03, 2.2398115754E+03, 1.3712022977E+03, 8.4129700738E-01],
	[2.24250E+04, 1.1324530796E+04, 5.1416109209E+03, 2.2414172547E+03, 1.3718517356E+03, 8.4137473346E-01],
	[2.24300E+04, 1.1328414683E+04, 5.1414819566E+03, 2.2430237258E+03, 1.3725011924E+03, 8.4145242366E-01],
	[2.24350E+04, 1.1332299036E+04, 5.1413530242E+03, 2.2446309888E+03, 1.3731506680E+03, 8.4153007800E-01],
	[2.24400E+04, 1.1336183854E+04, 5.1412241237E+03, 2.2462390441E+03, 1.3738001621E+03, 8.4160769653E-01],
	[2.24450E+04, 1.1340069139E+04, 5.1410952552E+03, 2.2478478918E+03, 1.3744496747E+03, 8.4168527928E-01],
	[2.24500E+04, 1.1343954889E+04, 5.1409664187E+03, 2.2494575322E+03, 1.3750992056E+03, 8.4176282627E-01],
	[2.24550E+04, 1.1347841105E+04, 5.1408376140E+03, 2.2510679653E+03, 1.3757487548E+03, 8.4184033754E-01],
	[2.24600E+04, 1.1351727786E+04, 5.1407088413E+03, 2.2526791916E+03, 1.3763983219E+03, 8.4191781312E-01],
	[2.24650E+04, 1.1355614933E+04, 5.1405801005E+03, 2.2542912111E+03, 1.3770479070E+03, 8.4199525304E-01],
	[2.24700E+04, 1.1359502546E+04, 5.1404513915E+03, 2.2559040241E+03, 1.3776975099E+03, 8.4207265734E-01],
	[2.24750E+04, 1.1363390624E+04, 5.1403227144E+03, 2.2575176308E+03, 1.3783471305E+03, 8.4215002604E-01],
	[2.24800E+04, 1.1367279168E+04, 5.1401940691E+03, 2.2591320315E+03, 1.3789967685E+03, 8.4222735917E-01],
	[2.24850E+04, 1.1371168177E+04, 5.1400654557E+03, 2.2607472262E+03, 1.3796464239E+03, 8.4230465678E-01],
	[2.24900E+04, 1.1375057651E+04, 5.1399368741E+03, 2.2623632153E+03, 1.3802960966E+03, 8.4238191888E-01],
	[2.24950E+04, 1.1378947591E+04, 5.1398083242E+03, 2.2639799990E+03, 1.3809457863E+03, 8.4245914552E-01],
	[2.25000E+04, 1.1382837996E+04, 5.1396798062E+03, 2.2655975774E+03, 1.3815954930E+03, 8.4253633672E-01],
	[2.25050E+04, 1.1386728867E+04, 5.1395513199E+03, 2.2672159508E+03, 1.3822452165E+03, 8.4261349251E-01],
	[2.25100E+04, 1.1390620202E+04, 5.1394228654E+03, 2.2688351194E+03, 1.3828949568E+03, 8.4269061293E-01],
	[2.25150E+04, 1.1394512003E+04, 5.1392944426E+03, 2.2704550834E+03, 1.3835447136E+03, 8.4276769800E-01],
	[2.25200E+04, 1.1398404268E+04, 5.1391660515E+03, 2.2720758430E+03, 1.3841944868E+03, 8.4284474776E-01],
	[2.25250E+04, 1.1402296999E+04, 5.1390376922E+03, 2.2736973985E+03, 1.3848442763E+03, 8.4292176224E-01],
	[2.25300E+04, 1.1406190195E+04, 5.1389093645E+03, 2.2753197500E+03, 1.3854940819E+03, 8.4299874147E-01],
	[2.25350E+04, 1.1410083856E+04, 5.1387810686E+03, 2.2769428978E+03, 1.3861439035E+03, 8.4307568548E-01],
	[2.25400E+04, 1.1413977981E+04, 5.1386528043E+03, 2.2785668420E+03, 1.3867937411E+03, 8.4315259430E-01],
	[2.25450E+04, 1.1417872572E+04, 5.1385245716E+03, 2.2801915830E+03, 1.3874435943E+03, 8.4322946797E-01],
	[2.25500E+04, 1.1421767627E+04, 5.1383963706E+03, 2.2818171208E+03, 1.3880934632E+03, 8.4330630640E-01],
	[2.25550E+04, 1.1425663147E+04, 5.1382682012E+03, 2.2834434557E+03, 1.3887433475E+03, 8.4338310933E-01],
	[2.25600E+04, 1.1429559131E+04, 5.1381400634E+03, 2.2850705880E+03, 1.3893932472E+03, 8.4345987675E-01],
	[2.25650E+04, 1.1433455581E+04, 5.1380119572E+03, 2.2866985178E+03, 1.3900431620E+03, 8.4353660867E-01],
	[2.25700E+04, 1.1437352495E+04, 5.1378838825E+03, 2.2883272454E+03, 1.3906930920E+03, 8.4361330510E-01],
	[2.25750E+04, 1.1441249873E+04, 5.1377558395E+03, 2.2899567709E+03, 1.3913430368E+03, 8.4368996605E-01],
	[2.25800E+04, 1.1445147716E+04, 5.1376278279E+03, 2.2915870946E+03, 1.3919929965E+03, 8.4376659153E-01],
	[2.25850E+04, 1.1449046024E+04, 5.1374998479E+03, 2.2932182168E+03, 1.3926429707E+03, 8.4384318154E-01],
	[2.25900E+04, 1.1452944795E+04, 5.1373718995E+03, 2.2948501375E+03, 1.3932929595E+03, 8.4391973610E-01],
	[2.25950E+04, 1.1456844032E+04, 5.1372439825E+03, 2.2964828570E+03, 1.3939429627E+03, 8.4399625522E-01],
	[2.26000E+04, 1.1460743732E+04, 5.1371160970E+03, 2.2981163756E+03, 1.3945929802E+03, 8.4407273890E-01],
	[2.26050E+04, 1.1464643897E+04, 5.1369882430E+03, 2.2997506934E+03, 1.3952430117E+03, 8.4414918716E-01],
	[2.26100E+04, 1.1468544526E+04, 5.1368604204E+03, 2.3013858107E+03, 1.3958930573E+03, 8.4422560000E-01],
	[2.26150E+04, 1.1472445619E+04, 5.1367326293E+03, 2.3030217277E+03, 1.3965431166E+03, 8.4430197743E-01],
	[2.26200E+04, 1.1476347177E+04, 5.1366048696E+03, 2.3046584445E+03, 1.3971931897E+03, 8.4437831947E-01],
	[2.26250E+04, 1.1480249198E+04, 5.1364771414E+03, 2.3062959615E+03, 1.3978432764E+03, 8.4445462612E-01],
	[2.26300E+04, 1.1484151684E+04, 5.1363494445E+03, 2.3079342787E+03, 1.3984933764E+03, 8.4453089739E-01],
	[2.26350E+04, 1.1488054633E+04, 5.1362217790E+03, 2.3095733965E+03, 1.3991434898E+03, 8.4460713329E-01],
	[2.26400E+04, 1.1491958047E+04, 5.1360941449E+03, 2.3112133150E+03, 1.3997936164E+03, 8.4468333383E-01],
	[2.26450E+04, 1.1495861924E+04, 5.1359665421E+03, 2.3128540345E+03, 1.4004437560E+03, 8.4475949902E-01],
	[2.26500E+04, 1.1499766265E+04, 5.1358389707E+03, 2.3144955552E+03, 1.4010939085E+03, 8.4483562886E-01],
	[2.26550E+04, 1.1503671070E+04, 5.1357114306E+03, 2.3161378772E+03, 1.4017440737E+03, 8.4491172338E-01],
	[2.26600E+04, 1.1507576339E+04, 5.1355839218E+03, 2.3177810009E+03, 1.4023942516E+03, 8.4498778258E-01],
	[2.26650E+04, 1.1511482072E+04, 5.1354564443E+03, 2.3194249263E+03, 1.4030444420E+03, 8.4506380646E-01],
	[2.26700E+04, 1.1515388268E+04, 5.1353289981E+03, 2.3210696538E+03, 1.4036946447E+03, 8.4513979504E-01],
	[2.26750E+04, 1.1519294928E+04, 5.1352015832E+03, 2.3227151835E+03, 1.4043448596E+03, 8.4521574832E-01],
	[2.26800E+04, 1.1523202051E+04, 5.1350741995E+03, 2.3243615157E+03, 1.4049950867E+03, 8.4529166632E-01],
	[2.26850E+04, 1.1527109638E+04, 5.1349468471E+03, 2.3260086505E+03, 1.4056453257E+03, 8.4536754905E-01],
	[2.26900E+04, 1.1531017688E+04, 5.1348195258E+03, 2.3276565882E+03, 1.4062955765E+03, 8.4544339651E-01],
	[2.26950E+04, 1.1534926202E+04, 5.1346922358E+03, 2.3293053290E+03, 1.4069458390E+03, 8.4551920872E-01],
	[2.27000E+04, 1.1538835179E+04, 5.1345649770E+03, 2.3309548731E+03, 1.4075961130E+03, 8.4559498568E-01],
	[2.27050E+04, 1.1542744619E+04, 5.1344377494E+03, 2.3326052207E+03, 1.4082463985E+03, 8.4567072741E-01],
	[2.27100E+04, 1.1546654523E+04, 5.1343105529E+03, 2.3342563720E+03, 1.4088966952E+03, 8.4574643391E-01],
	[2.27150E+04, 1.1550564890E+04, 5.1341833876E+03, 2.3359083273E+03, 1.4095470031E+03, 8.4582210519E-01],
	[2.27200E+04, 1.1554475720E+04, 5.1340562534E+03, 2.3375610868E+03, 1.4101973220E+03, 8.4589774127E-01],
	[2.27250E+04, 1.1558387013E+04, 5.1339291503E+03, 2.3392146506E+03, 1.4108476518E+03, 8.4597334214E-01],
	[2.27300E+04, 1.1562298770E+04, 5.1338020784E+03, 2.3408690190E+03, 1.4114979924E+03, 8.4604890783E-01],
	[2.27350E+04, 1.1566210989E+04, 5.1336750375E+03, 2.3425241922E+03, 1.4121483435E+03, 8.4612443835E-01],
	[2.27400E+04, 1.1570123672E+04, 5.1335480277E+03, 2.3441801705E+03, 1.4127987052E+03, 8.4619993369E-01],
	[2.27450E+04, 1.1574036817E+04, 5.1334210490E+03, 2.3458369539E+03, 1.4134490771E+03, 8.4627539388E-01],
	[2.27500E+04, 1.1577950425E+04, 5.1332941014E+03, 2.3474945428E+03, 1.4140994593E+03, 8.4635081892E-01],
	[2.27550E+04, 1.1581864496E+04, 5.1331671847E+03, 2.3491529374E+03, 1.4147498516E+03, 8.4642620882E-01],
	[2.27600E+04, 1.1585779030E+04, 5.1330402991E+03, 2.3508121378E+03, 1.4154002538E+03, 8.4650156359E-01],
	[2.27650E+04, 1.1589694027E+04, 5.1329134445E+03, 2.3524721443E+03, 1.4160506658E+03, 8.4657688324E-01],
	[2.27700E+04, 1.1593609487E+04, 5.1327866209E+03, 2.3541329571E+03, 1.4167010875E+03, 8.4665216778E-01],
	[2.27750E+04, 1.1597525409E+04, 5.1326598283E+03, 2.3557945764E+03, 1.4173515187E+03, 8.4672741723E-01],
	[2.27800E+04, 1.1601441793E+04, 5.1325330666E+03, 2.3574570024E+03, 1.4180019594E+03, 8.4680263158E-01],
	[2.27850E+04, 1.1605358641E+04, 5.1324063359E+03, 2.3591202354E+03, 1.4186524093E+03, 8.4687781085E-01],
	[2.27900E+04, 1.1609275951E+04, 5.1322796361E+03, 2.3607842755E+03, 1.4193028683E+03, 8.4695295506E-01],
	[2.27950E+04, 1.1613193723E+04, 5.1321529673E+03, 2.3624491230E+03, 1.4199533364E+03, 8.4702806420E-01],
	[2.28000E+04, 1.1617111958E+04, 5.1320263293E+03, 2.3641147780E+03, 1.4206038133E+03, 8.4710313830E-01],
	[2.28050E+04, 1.1621030655E+04, 5.1318997222E+03, 2.3657812409E+03, 1.4212542990E+03, 8.4717817735E-01],
	[2.28100E+04, 1.1624949814E+04, 5.1317731461E+03, 2.3674485118E+03, 1.4219047933E+03, 8.4725318138E-01],
	[2.28150E+04, 1.1628869436E+04, 5.1316466007E+03, 2.3691165908E+03, 1.4225552961E+03, 8.4732815038E-01],
	[2.28200E+04, 1.1632789520E+04, 5.1315200863E+03, 2.3707854784E+03, 1.4232058072E+03, 8.4740308438E-01],
	[2.28250E+04, 1.1636710067E+04, 5.1313936026E+03, 2.3724551745E+03, 1.4238563265E+03, 8.4747798337E-01],
	[2.28300E+04, 1.1640631075E+04, 5.1312671498E+03, 2.3741256796E+03, 1.4245068539E+03, 8.4755284738E-01],
	[2.28350E+04, 1.1644552546E+04, 5.1311407278E+03, 2.3757969937E+03, 1.4251573892E+03, 8.4762767640E-01],
	[2.28400E+04, 1.1648474478E+04, 5.1310143366E+03, 2.3774691171E+03, 1.4258079324E+03, 8.4770247046E-01],
	[2.28450E+04, 1.1652396873E+04, 5.1308879762E+03, 2.3791420499E+03, 1.4264584832E+03, 8.4777722955E-01],
	[2.28500E+04, 1.1656319729E+04, 5.1307616465E+03, 2.3808157926E+03, 1.4271090416E+03, 8.4785195370E-01],
	[2.28550E+04, 1.1660243048E+04, 5.1306353476E+03, 2.3824903451E+03, 1.4277596074E+03, 8.4792664290E-01],
	[2.28600E+04, 1.1664166828E+04, 5.1305090794E+03, 2.3841657078E+03, 1.4284101804E+03, 8.4800129718E-01],
	[2.28650E+04, 1.1668091070E+04, 5.1303828419E+03, 2.3858418808E+03, 1.4290607606E+03, 8.4807591654E-01],
	[2.28700E+04, 1.1672015774E+04, 5.1302566352E+03, 2.3875188645E+03, 1.4297113478E+03, 8.4815050099E-01],
	[2.28750E+04, 1.1675940940E+04, 5.1301304591E+03, 2.3891966589E+03, 1.4303619419E+03, 8.4822505053E-01],
	[2.28800E+04, 1.1679866568E+04, 5.1300043137E+03, 2.3908752643E+03, 1.4310125428E+03, 8.4829956520E-01],
	[2.28850E+04, 1.1683792657E+04, 5.1298781990E+03, 2.3925546809E+03, 1.4316631503E+03, 8.4837404498E-01],
	[2.28900E+04, 1.1687719207E+04, 5.1297521149E+03, 2.3942349090E+03, 1.4323137642E+03, 8.4844848989E-01],
	[2.28950E+04, 1.1691646219E+04, 5.1296260615E+03, 2.3959159486E+03, 1.4329643845E+03, 8.4852289995E-01],
	[2.29000E+04, 1.1695573693E+04, 5.1295000387E+03, 2.3975978002E+03, 1.4336150110E+03, 8.4859727515E-01],
	[2.29050E+04, 1.1699501628E+04, 5.1293740464E+03, 2.3992804638E+03, 1.4342656437E+03, 8.4867161552E-01],
	[2.29100E+04, 1.1703430025E+04, 5.1292480848E+03, 2.4009639397E+03, 1.4349162822E+03, 8.4874592106E-01],
	[2.29150E+04, 1.1707358883E+04, 5.1291221538E+03, 2.4026482281E+03, 1.4355669266E+03, 8.4882019179E-01],
	[2.29200E+04, 1.1711288202E+04, 5.1289962533E+03, 2.4043333292E+03, 1.4362175767E+03, 8.4889442771E-01],
	[2.29250E+04, 1.1715217983E+04, 5.1288703834E+03, 2.4060192433E+03, 1.4368682323E+03, 8.4896862883E-01],
	[2.29300E+04, 1.1719148224E+04, 5.1287445440E+03, 2.4077059705E+03, 1.4375188934E+03, 8.4904279516E-01],
	[2.29350E+04, 1.1723078927E+04, 5.1286187352E+03, 2.4093935110E+03, 1.4381695598E+03, 8.4911692672E-01],
	[2.29400E+04, 1.1727010091E+04, 5.1284929568E+03, 2.4110818651E+03, 1.4388202313E+03, 8.4919102351E-01],
	[2.29450E+04, 1.1730941717E+04, 5.1283672090E+03, 2.4127710330E+03, 1.4394709078E+03, 8.4926508555E-01],
	[2.29500E+04, 1.1734873803E+04, 5.1282414916E+03, 2.4144610149E+03, 1.4401215893E+03, 8.4933911284E-01],
	[2.29550E+04, 1.1738806350E+04, 5.1281158047E+03, 2.4161518110E+03, 1.4407722755E+03, 8.4941310540E-01],
	[2.29600E+04, 1.1742739358E+04, 5.1279901483E+03, 2.4178434215E+03, 1.4414229664E+03, 8.4948706324E-01],
	[2.29650E+04, 1.1746672827E+04, 5.1278645223E+03, 2.4195358467E+03, 1.4420736618E+03, 8.4956098636E-01],
	[2.29700E+04, 1.1750606757E+04, 5.1277389267E+03, 2.4212290867E+03, 1.4427243615E+03, 8.4963487478E-01],
	[2.29750E+04, 1.1754541148E+04, 5.1276133615E+03, 2.4229231418E+03, 1.4433750655E+03, 8.4970872850E-01],
	[2.29800E+04, 1.1758475999E+04, 5.1274878267E+03, 2.4246180122E+03, 1.4440257736E+03, 8.4978254754E-01],
	[2.29850E+04, 1.1762411311E+04, 5.1273623223E+03, 2.4263136980E+03, 1.4446764856E+03, 8.4985633191E-01],
	[2.29900E+04, 1.1766347084E+04, 5.1272368483E+03, 2.4280101996E+03, 1.4453272016E+03, 8.4993008162E-01],
	[2.29950E+04, 1.1770283317E+04, 5.1271114046E+03, 2.4297075171E+03, 1.4459779212E+03, 8.5000379668E-01],
	[2.30000E+04, 1.1774220011E+04, 5.1269859913E+03, 2.4314056507E+03, 1.4466286444E+03, 8.5007747710E-01],
	[2.30050E+04, 1.1778157166E+04, 5.1268606083E+03, 2.4331046007E+03, 1.4472793711E+03, 8.5015112289E-01],
	[2.30100E+04, 1.1782094781E+04, 5.1267352556E+03, 2.4348043673E+03, 1.4479301011E+03, 8.5022473406E-01],
	[2.30150E+04, 1.1786032857E+04, 5.1266099332E+03, 2.4365049506E+03, 1.4485808343E+03, 8.5029831062E-01],
	[2.30200E+04, 1.1789971392E+04, 5.1264846411E+03, 2.4382063509E+03, 1.4492315705E+03, 8.5037185258E-01],
	[2.30250E+04, 1.1793910389E+04, 5.1263593793E+03, 2.4399085685E+03, 1.4498823097E+03, 8.5044535995E-01],
	[2.30300E+04, 1.1797849845E+04, 5.1262341477E+03, 2.4416116034E+03, 1.4505330517E+03, 8.5051883275E-01],
	[2.30350E+04, 1.1801789762E+04, 5.1261089464E+03, 2.4433154560E+03, 1.4511837964E+03, 8.5059227098E-01],
	[2.30400E+04, 1.1805730139E+04, 5.1259837753E+03, 2.4450201265E+03, 1.4518345435E+03, 8.5066567466E-01],
	[2.30450E+04, 1.1809670976E+04, 5.1258586344E+03, 2.4467256150E+03, 1.4524852931E+03, 8.5073904379E-01],
	[2.30500E+04, 1.1813612273E+04, 5.1257335238E+03, 2.4484319218E+03, 1.4531360450E+03, 8.5081237839E-01],
	[2.30550E+04, 1.1817554030E+04, 5.1256084433E+03, 2.4501390471E+03, 1.4537867990E+03, 8.5088567846E-01],
	[2.30600E+04, 1.1821496248E+04, 5.1254833930E+03, 2.4518469911E+03, 1.4544375551E+03, 8.5095894402E-01],
	[2.30650E+04, 1.1825438925E+04, 5.1253583728E+03, 2.4535557540E+03, 1.4550883130E+03, 8.5103217507E-01],
	[2.30700E+04, 1.1829382062E+04, 5.1252333828E+03, 2.4552653360E+03, 1.4557390727E+03, 8.5110537164E-01],
	[2.30750E+04, 1.1833325659E+04, 5.1251084229E+03, 2.4569757375E+03, 1.4563898340E+03, 8.5117853372E-01],
	[2.30800E+04, 1.1837269716E+04, 5.1249834932E+03, 2.4586869584E+03, 1.4570405968E+03, 8.5125166134E-01],
	[2.30850E+04, 1.1841214233E+04, 5.1248585935E+03, 2.4603989992E+03, 1.4576913609E+03, 8.5132475449E-01],
	[2.30900E+04, 1.1845159210E+04, 5.1247337240E+03, 2.4621118599E+03, 1.4583421263E+03, 8.5139781320E-01],
	[2.30950E+04, 1.1849104646E+04, 5.1246088845E+03, 2.4638255409E+03, 1.4589928928E+03, 8.5147083746E-01],
	[2.31000E+04, 1.1853050542E+04, 5.1244840751E+03, 2.4655400423E+03, 1.4596436603E+03, 8.5154382730E-01],
	[2.31050E+04, 1.1856996897E+04, 5.1243592957E+03, 2.4672553643E+03, 1.4602944286E+03, 8.5161678273E-01],
	[2.31100E+04, 1.1860943712E+04, 5.1242345464E+03, 2.4689715072E+03, 1.4609451976E+03, 8.5168970375E-01],
	[2.31150E+04, 1.1864890987E+04, 5.1241098271E+03, 2.4706884711E+03, 1.4615959672E+03, 8.5176259037E-01],
	[2.31200E+04, 1.1868838721E+04, 5.1239851378E+03, 2.4724062563E+03, 1.4622467373E+03, 8.5183544261E-01],
	[2.31250E+04, 1.1872786914E+04, 5.1238604785E+03, 2.4741248631E+03, 1.4628975077E+03, 8.5190826047E-01],
	[2.31300E+04, 1.1876735567E+04, 5.1237358492E+03, 2.4758442915E+03, 1.4635482782E+03, 8.5198104398E-01],
	[2.31350E+04, 1.1880684679E+04, 5.1236112499E+03, 2.4775645418E+03, 1.4641990489E+03, 8.5205379313E-01],
	[2.31400E+04, 1.1884634250E+04, 5.1234866805E+03, 2.4792856143E+03, 1.4648498195E+03, 8.5212650794E-01],
	[2.31450E+04, 1.1888584281E+04, 5.1233621410E+03, 2.4810075092E+03, 1.4655005899E+03, 8.5219918843E-01],
	[2.31500E+04, 1.1892534771E+04, 5.1232376315E+03, 2.4827302266E+03, 1.4661513599E+03, 8.5227183459E-01],
	[2.31550E+04, 1.1896485720E+04, 5.1231131519E+03, 2.4844537668E+03, 1.4668021295E+03, 8.5234444645E-01],
	[2.31600E+04, 1.1900437128E+04, 5.1229887022E+03, 2.4861781300E+03, 1.4674528985E+03, 8.5241702401E-01],
	[2.31650E+04, 1.1904388995E+04, 5.1228642824E+03, 2.4879033164E+03, 1.4681036669E+03, 8.5248956728E-01],
	[2.31700E+04, 1.1908341321E+04, 5.1227398924E+03, 2.4896293262E+03, 1.4687544343E+03, 8.5256207628E-01],
	[2.31750E+04, 1.1912294106E+04, 5.1226155324E+03, 2.4913561596E+03, 1.4694052008E+03, 8.5263455101E-01],
	[2.31800E+04, 1.1916247350E+04, 5.1224912021E+03, 2.4930838170E+03, 1.4700559662E+03, 8.5270699149E-01],
	[2.31850E+04, 1.1920201053E+04, 5.1223669017E+03, 2.4948122983E+03, 1.4707067304E+03, 8.5277939773E-01],
	[2.31900E+04, 1.1924155215E+04, 5.1222426311E+03, 2.4965416040E+03, 1.4713574932E+03, 8.5285176974E-01],
	[2.31950E+04, 1.1928109836E+04, 5.1221183903E+03, 2.4982717342E+03, 1.4720082545E+03, 8.5292410753E-01],
	[2.32000E+04, 1.1932064915E+04, 5.1219941793E+03, 2.5000026891E+03, 1.4726590142E+03, 8.5299641111E-01],
	[2.32050E+04, 1.1936020453E+04, 5.1218699981E+03, 2.5017344689E+03, 1.4733097722E+03, 8.5306868049E-01],
	[2.32100E+04, 1.1939976449E+04, 5.1217458467E+03, 2.5034670738E+03, 1.4739605283E+03, 8.5314091568E-01],
	[2.32150E+04, 1.1943932905E+04, 5.1216217250E+03, 2.5052005041E+03, 1.4746112824E+03, 8.5321311670E-01],
	[2.32200E+04, 1.1947919858E+04, 5.1215055935E+03, 2.5069347600E+03, 1.4752631528E+03, 8.5328528356E-01],
	[2.32250E+04, 1.1951923058E+04, 5.1213936685E+03, 2.5086698416E+03, 1.4759156101E+03, 8.5335741626E-01],
	[2.32300E+04, 1.1955926737E+04, 5.1212817702E+03, 2.5104057493E+03, 1.4765680672E+03, 8.5342951482E-01],
	[2.32350E+04, 1.1959930896E+04, 5.1211698983E+03, 2.5121424832E+03, 1.4772205240E+03, 8.5350157924E-01],
	[2.32400E+04, 1.1963935533E+04, 5.1210580530E+03, 2.5138800435E+03, 1.4778729804E+03, 8.5357360955E-01],
	[2.32450E+04, 1.1967940650E+04, 5.1209462342E+03, 2.5156184304E+03, 1.4785254363E+03, 8.5364560575E-01],
	[2.32500E+04, 1.1971946245E+04, 5.1208344418E+03, 2.5173576442E+03, 1.4791778915E+03, 8.5371756784E-01],
	[2.32550E+04, 1.1975952319E+04, 5.1207226760E+03, 2.5190976851E+03, 1.4798303459E+03, 8.5378949586E-01],
	[2.32600E+04, 1.1979958872E+04, 5.1206109366E+03, 2.5208385533E+03, 1.4804827993E+03, 8.5386138979E-01],
	[2.32650E+04, 1.1983965904E+04, 5.1204992236E+03, 2.5225802489E+03, 1.4811352518E+03, 8.5393324967E-01],
	[2.32700E+04, 1.1987973415E+04, 5.1203875371E+03, 2.5243227723E+03, 1.4817877030E+03, 8.5400507549E-01],
	[2.32750E+04, 1.1991981404E+04, 5.1202758771E+03, 2.5260661236E+03, 1.4824401529E+03, 8.5407686726E-01],
	[2.32800E+04, 1.1995989872E+04, 5.1201642434E+03, 2.5278103031E+03, 1.4830926014E+03, 8.5414862501E-01],
	[2.32850E+04, 1.1999998819E+04, 5.1200526362E+03, 2.5295553109E+03, 1.4837450483E+03, 8.5422034873E-01],
	[2.32900E+04, 1.2004008244E+04, 5.1199410553E+03, 2.5313011473E+03, 1.4843974935E+03, 8.5429203845E-01],
	[2.32950E+04, 1.2008018148E+04, 5.1198295009E+03, 2.5330478125E+03, 1.4850499369E+03, 8.5436369417E-01],
	[2.33000E+04, 1.2012028530E+04, 5.1197179728E+03, 2.5347953067E+03, 1.4857023784E+03, 8.5443531591E-01],
	[2.33050E+04, 1.2016039391E+04, 5.1196064710E+03, 2.5365436301E+03, 1.4863548177E+03, 8.5450690367E-01],
	[2.33100E+04, 1.2020050730E+04, 5.1194949956E+03, 2.5382927829E+03, 1.4870072549E+03, 8.5457845747E-01],
	[2.33150E+04, 1.2024062547E+04, 5.1193835466E+03, 2.5400427654E+03, 1.4876596898E+03, 8.5464997731E-01],
	[2.33200E+04, 1.2028074843E+04, 5.1192721239E+03, 2.5417935778E+03, 1.4883121222E+03, 8.5472146322E-01],
	[2.33250E+04, 1.2032087617E+04, 5.1191607274E+03, 2.5435452202E+03, 1.4889645520E+03, 8.5479291519E-01],
	[2.33300E+04, 1.2036100869E+04, 5.1190493573E+03, 2.5452976929E+03, 1.4896169791E+03, 8.5486433325E-01],
	[2.33350E+04, 1.2040114599E+04, 5.1189380135E+03, 2.5470509962E+03, 1.4902694034E+03, 8.5493571740E-01],
	[2.33400E+04, 1.2044128808E+04, 5.1188266960E+03, 2.5488051301E+03, 1.4909218247E+03, 8.5500706766E-01],
	[2.33450E+04, 1.2048143494E+04, 5.1187154047E+03, 2.5505600950E+03, 1.4915742429E+03, 8.5507838403E-01],
	[2.33500E+04, 1.2052158659E+04, 5.1186041396E+03, 2.5523158911E+03, 1.4922266579E+03, 8.5514966653E-01],
	[2.33550E+04, 1.2056174301E+04, 5.1184929008E+03, 2.5540725185E+03, 1.4928790695E+03, 8.5522091516E-01],
	[2.33600E+04, 1.2060190421E+04, 5.1183816883E+03, 2.5558299775E+03, 1.4935314777E+03, 8.5529212995E-01],
	[2.33650E+04, 1.2064207020E+04, 5.1182705019E+03, 2.5575882683E+03, 1.4941838823E+03, 8.5536331090E-01],
	[2.33700E+04, 1.2068224096E+04, 5.1181593418E+03, 2.5593473911E+03, 1.4948362832E+03, 8.5543445802E-01],
	[2.33750E+04, 1.2072241650E+04, 5.1180482078E+03, 2.5611073461E+03, 1.4954886802E+03, 8.5550557133E-01],
	[2.33800E+04, 1.2076259682E+04, 5.1179371001E+03, 2.5628681336E+03, 1.4961410732E+03, 8.5557665083E-01],
	[2.33850E+04, 1.2080278191E+04, 5.1178260185E+03, 2.5646297537E+03, 1.4967934622E+03, 8.5564769654E-01],
	[2.33900E+04, 1.2084297178E+04, 5.1177149630E+03, 2.5663922067E+03, 1.4974458469E+03, 8.5571870847E-01],
	[2.33950E+04, 1.2088316643E+04, 5.1176039337E+03, 2.5681554928E+03, 1.4980982273E+03, 8.5578968663E-01],
	[2.34000E+04, 1.2092336585E+04, 5.1174929306E+03, 2.5699196122E+03, 1.4987506031E+03, 8.5586063103E-01],
	[2.34050E+04, 1.2096357005E+04, 5.1173819535E+03, 2.5716845651E+03, 1.4994029744E+03, 8.5593154169E-01],
	[2.34100E+04, 1.2100377902E+04, 5.1172710026E+03, 2.5734503518E+03, 1.5000553410E+03, 8.5600241861E-01],
	[2.34150E+04, 1.2104399277E+04, 5.1171600778E+03, 2.5752169724E+03, 1.5007077026E+03, 8.5607326180E-01],
	[2.34200E+04, 1.2108421129E+04, 5.1170491791E+03, 2.5769844271E+03, 1.5013600593E+03, 8.5614407129E-01],
	[2.34250E+04, 1.2112443458E+04, 5.1169383064E+03, 2.5787527162E+03, 1.5020124109E+03, 8.5621484707E-01],
	[2.34300E+04, 1.2116466265E+04, 5.1168274598E+03, 2.5805218399E+03, 1.5026647573E+03, 8.5628558916E-01],
	[2.34350E+04, 1.2120489549E+04, 5.1167166393E+03, 2.5822917984E+03, 1.5033170983E+03, 8.5635629758E-01],
	[2.34400E+04, 1.2124513310E+04, 5.1166058448E+03, 2.5840625920E+03, 1.5039694338E+03, 8.5642697233E-01],
	[2.34450E+04, 1.2128537548E+04, 5.1164950763E+03, 2.5858342208E+03, 1.5046217637E+03, 8.5649761343E-01],
	[2.34500E+04, 1.2132562264E+04, 5.1163843338E+03, 2.5876066850E+03, 1.5052740879E+03, 8.5656822088E-01],
	[2.34550E+04, 1.2136587456E+04, 5.1162736174E+03, 2.5893799849E+03, 1.5059264062E+03, 8.5663879470E-01],
	[2.34600E+04, 1.2140613126E+04, 5.1161629269E+03, 2.5911541206E+03, 1.5065787185E+03, 8.5670933490E-01],
	[2.34650E+04, 1.2144639272E+04, 5.1160522625E+03, 2.5929290925E+03, 1.5072310247E+03, 8.5677984150E-01],
	[2.34700E+04, 1.2148665896E+04, 5.1159416240E+03, 2.5947049007E+03, 1.5078833247E+03, 8.5685031450E-01],
	[2.34750E+04, 1.2152692996E+04, 5.1158310114E+03, 2.5964815454E+03, 1.5085356183E+03, 8.5692075391E-01],
	[2.34800E+04, 1.2156720573E+04, 5.1157204248E+03, 2.5982590268E+03, 1.5091879054E+03, 8.5699115975E-01],
	[2.34850E+04, 1.2160748627E+04, 5.1156098642E+03, 2.6000373452E+03, 1.5098401859E+03, 8.5706153203E-01],
	[2.34900E+04, 1.2164777158E+04, 5.1154993294E+03, 2.6018165008E+03, 1.5104924596E+03, 8.5713187076E-01],
	[2.34950E+04, 1.2168806165E+04, 5.1153888206E+03, 2.6035964937E+03, 1.5111447265E+03, 8.5720217595E-01],
	[2.35000E+04, 1.2172835650E+04, 5.1152783377E+03, 2.6053773243E+03, 1.5117969864E+03, 8.5727244761E-01],
	[2.35050E+04, 1.2176865610E+04, 5.1151678807E+03, 2.6071589927E+03, 1.5124492392E+03, 8.5734268576E-01],
	[2.35100E+04, 1.2180896048E+04, 5.1150574495E+03, 2.6089414991E+03, 1.5131014848E+03, 8.5741289041E-01],
	[2.35150E+04, 1.2184926961E+04, 5.1149470443E+03, 2.6107248437E+03, 1.5137537229E+03, 8.5748306157E-01],
	[2.35200E+04, 1.2188958352E+04, 5.1148366648E+03, 2.6125090268E+03, 1.5144059537E+03, 8.5755319924E-01],
	[2.35250E+04, 1.2192990219E+04, 5.1147263113E+03, 2.6142940486E+03, 1.5150581767E+03, 8.5762330345E-01],
	[2.35300E+04, 1.2197022562E+04, 5.1146159835E+03, 2.6160799093E+03, 1.5157103921E+03, 8.5769337421E-01],
	[2.35350E+04, 1.2201055381E+04, 5.1145056816E+03, 2.6178666091E+03, 1.5163625996E+03, 8.5776341152E-01],
	[2.35400E+04, 1.2205088677E+04, 5.1143954055E+03, 2.6196541482E+03, 1.5170147991E+03, 8.5783341539E-01],
	[2.35450E+04, 1.2209122449E+04, 5.1142851551E+03, 2.6214425268E+03, 1.5176669905E+03, 8.5790338585E-01],
	[2.35500E+04, 1.2213156697E+04, 5.1141749306E+03, 2.6232317452E+03, 1.5183191736E+03, 8.5797332289E-01],
	[2.35550E+04, 1.2217191422E+04, 5.1140647318E+03, 2.6250218036E+03, 1.5189713484E+03, 8.5804322654E-01],
	[2.35600E+04, 1.2221226623E+04, 5.1139545588E+03, 2.6268127022E+03, 1.5196235148E+03, 8.5811309681E-01],
	[2.35650E+04, 1.2225262299E+04, 5.1138444116E+03, 2.6286044411E+03, 1.5202756725E+03, 8.5818293370E-01],
	[2.35700E+04, 1.2229298452E+04, 5.1137342901E+03, 2.6303970207E+03, 1.5209278214E+03, 8.5825273723E-01],
	[2.35750E+04, 1.2233335081E+04, 5.1136241943E+03, 2.6321904410E+03, 1.5215799616E+03, 8.5832250741E-01],
	[2.35800E+04, 1.2237372185E+04, 5.1135141242E+03, 2.6339847025E+03, 1.5222320927E+03, 8.5839224425E-01],
	[2.35850E+04, 1.2241409766E+04, 5.1134040799E+03, 2.6357798052E+03, 1.5228842148E+03, 8.5846194777E-01],
	[2.35900E+04, 1.2245447822E+04, 5.1132940612E+03, 2.6375757493E+03, 1.5235363276E+03, 8.5853161797E-01],
	[2.35950E+04, 1.2249486354E+04, 5.1131840682E+03, 2.6393725352E+03, 1.5241884310E+03, 8.5860125487E-01],
	[2.36000E+04, 1.2253525362E+04, 5.1130741009E+03, 2.6411701629E+03, 1.5248405250E+03, 8.5867085847E-01],
	[2.36050E+04, 1.2257564846E+04, 5.1129641593E+03, 2.6429686328E+03, 1.5254926094E+03, 8.5874042880E-01],
	[2.36100E+04, 1.2261604806E+04, 5.1128542433E+03, 2.6447679450E+03, 1.5261446841E+03, 8.5880996587E-01],
	[2.36150E+04, 1.2265645241E+04, 5.1127443529E+03, 2.6465680998E+03, 1.5267967489E+03, 8.5887946967E-01],
	[2.36200E+04, 1.2269686151E+04, 5.1126344882E+03, 2.6483690973E+03, 1.5274488038E+03, 8.5894894024E-01],
	[2.36250E+04, 1.2273727537E+04, 5.1125246491E+03, 2.6501709378E+03, 1.5281008485E+03, 8.5901837757E-01],
	[2.36300E+04, 1.2277769399E+04, 5.1124148356E+03, 2.6519736215E+03, 1.5287528831E+03, 8.5908778169E-01],
	[2.36350E+04, 1.2281811736E+04, 5.1123050476E+03, 2.6537771487E+03, 1.5294049073E+03, 8.5915715260E-01],
	[2.36400E+04, 1.2285854549E+04, 5.1121952853E+03, 2.6555815194E+03, 1.5300569211E+03, 8.5922649031E-01],
	[2.36450E+04, 1.2289897837E+04, 5.1120855485E+03, 2.6573867340E+03, 1.5307089242E+03, 8.5929579484E-01],
	[2.36500E+04, 1.2293941600E+04, 5.1119758373E+03, 2.6591927926E+03, 1.5313609167E+03, 8.5936506620E-01],
	[2.36550E+04, 1.2297985838E+04, 5.1118661516E+03, 2.6609996955E+03, 1.5320128983E+03, 8.5943430440E-01],
	[2.36600E+04, 1.2302030552E+04, 5.1117564915E+03, 2.6628074430E+03, 1.5326648690E+03, 8.5950350944E-01],
	[2.36650E+04, 1.2306075741E+04, 5.1116468569E+03, 2.6646160351E+03, 1.5333168286E+03, 8.5957268134E-01],
	[2.36700E+04, 1.2310121405E+04, 5.1115372477E+03, 2.6664254721E+03, 1.5339687770E+03, 8.5964182012E-01],
	[2.36750E+04, 1.2314167544E+04, 5.1114276641E+03, 2.6682357543E+03, 1.5346207141E+03, 8.5971092577E-01],
	[2.36800E+04, 1.2318214158E+04, 5.1113181060E+03, 2.6700468818E+03, 1.5352726397E+03, 8.5977999831E-01],
	[2.36850E+04, 1.2322261247E+04, 5.1112085734E+03, 2.6718588548E+03, 1.5359245537E+03, 8.5984903776E-01],
	[2.36900E+04, 1.2326308812E+04, 5.1110990662E+03, 2.6736716737E+03, 1.5365764561E+03, 8.5991804411E-01],
	[2.36950E+04, 1.2330356851E+04, 5.1109895845E+03, 2.6754853386E+03, 1.5372283467E+03, 8.5998701739E-01],
	[2.37000E+04, 1.2334405365E+04, 5.1108801282E+03, 2.6772998496E+03, 1.5378802253E+03, 8.6005595759E-01],
	[2.37050E+04, 1.2338454353E+04, 5.1107706974E+03, 2.6791152071E+03, 1.5385320919E+03, 8.6012486474E-01],
	[2.37100E+04, 1.2342503817E+04, 5.1106612920E+03, 2.6809314113E+03, 1.5391839463E+03, 8.6019373885E-01],
	[2.37150E+04, 1.2346553755E+04, 5.1105519120E+03, 2.6827484623E+03, 1.5398357883E+03, 8.6026257991E-01],
	[2.37200E+04, 1.2350604168E+04, 5.1104425574E+03, 2.6845663603E+03, 1.5404876180E+03, 8.6033138795E-01],
	[2.37250E+04, 1.2354655056E+04, 5.1103332282E+03, 2.6863851057E+03, 1.5411394351E+03, 8.6040016297E-01],
	[2.37300E+04, 1.2358706418E+04, 5.1102239243E+03, 2.6882046986E+03, 1.5417912396E+03, 8.6046890499E-01],
	[2.37350E+04, 1.2362758255E+04, 5.1101146459E+03, 2.6900251391E+03, 1.5424430312E+03, 8.6053761402E-01],
	[2.37400E+04, 1.2366810566E+04, 5.1100053927E+03, 2.6918464277E+03, 1.5430948099E+03, 8.6060629005E-01],
	[2.37450E+04, 1.2370863352E+04, 5.1098961650E+03, 2.6936685643E+03, 1.5437465756E+03, 8.6067493312E-01],
	[2.37500E+04, 1.2374916613E+04, 5.1097869625E+03, 2.6954915494E+03, 1.5443983282E+03, 8.6074354322E-01],
	[2.37550E+04, 1.2378970347E+04, 5.1096777854E+03, 2.6973153830E+03, 1.5450500675E+03, 8.6081212037E-01],
	[2.37600E+04, 1.2383024556E+04, 5.1095686336E+03, 2.6991400654E+03, 1.5457017933E+03, 8.6088066458E-01],
	[2.37650E+04, 1.2387079239E+04, 5.1094595070E+03, 2.7009655968E+03, 1.5463535057E+03, 8.6094917586E-01],
	[2.37700E+04, 1.2391134397E+04, 5.1093504058E+03, 2.7027919775E+03, 1.5470052044E+03, 8.6101765422E-01],
	[2.37750E+04, 1.2395190029E+04, 5.1092413299E+03, 2.7046192076E+03, 1.5476568893E+03, 8.6108609966E-01],
	[2.37800E+04, 1.2399246135E+04, 5.1091322792E+03, 2.7064472874E+03, 1.5483085604E+03, 8.6115451221E-01],
	[2.37850E+04, 1.2403302715E+04, 5.1090232537E+03, 2.7082762170E+03, 1.5489602174E+03, 8.6122289187E-01],
	[2.37900E+04, 1.2407359769E+04, 5.1089142535E+03, 2.7101059967E+03, 1.5496118603E+03, 8.6129123865E-01],
	[2.37950E+04, 1.2411417297E+04, 5.1088052786E+03, 2.7119366268E+03, 1.5502634890E+03, 8.6135955257E-01],
	[2.38000E+04, 1.2415475299E+04, 5.1086963288E+03, 2.7137681073E+03, 1.5509151033E+03, 8.6142783362E-01],
	[2.38050E+04, 1.2419533775E+04, 5.1085874043E+03, 2.7156004386E+03, 1.5515667031E+03, 8.6149608184E-01],
	[2.38100E+04, 1.2423592725E+04, 5.1084785050E+03, 2.7174336209E+03, 1.5522182883E+03, 8.6156429721E-01],
	[2.38150E+04, 1.2427652149E+04, 5.1083696308E+03, 2.7192676543E+03, 1.5528698587E+03, 8.6163247977E-01],
	[2.38200E+04, 1.2431712046E+04, 5.1082607818E+03, 2.7211025391E+03, 1.5535214143E+03, 8.6170062951E-01],
	[2.38250E+04, 1.2435772418E+04, 5.1081519580E+03, 2.7229382755E+03, 1.5541729549E+03, 8.6176874644E-01],
	[2.38300E+04, 1.2439833263E+04, 5.1080431594E+03, 2.7247748637E+03, 1.5548244805E+03, 8.6183683059E-01],
	[2.38350E+04, 1.2443894582E+04, 5.1079343859E+03, 2.7266123040E+03, 1.5554759908E+03, 8.6190488195E-01],
	[2.38400E+04, 1.2447956374E+04, 5.1078256375E+03, 2.7284505965E+03, 1.5561274857E+03, 8.6197290054E-01],
	[2.38450E+04, 1.2452018640E+04, 5.1077169142E+03, 2.7302897415E+03, 1.5567789652E+03, 8.6204088638E-01],
	[2.38500E+04, 1.2456081380E+04, 5.1076082161E+03, 2.7321297391E+03, 1.5574304292E+03, 8.6210883946E-01],
	[2.38550E+04, 1.2460144593E+04, 5.1074995430E+03, 2.7339705896E+03, 1.5580818774E+03, 8.6217675981E-01],
	[2.38600E+04, 1.2464208279E+04, 5.1073908950E+03, 2.7358122933E+03, 1.5587333098E+03, 8.6224464743E-01],
	[2.38650E+04, 1.2468272439E+04, 5.1072822721E+03, 2.7376548503E+03, 1.5593847262E+03, 8.6231250233E-01],
	[2.38700E+04, 1.2472337073E+04, 5.1071736743E+03, 2.7394982608E+03, 1.5600361266E+03, 8.6238032453E-01],
	[2.38750E+04, 1.2476402179E+04, 5.1070651015E+03, 2.7413425251E+03, 1.5606875108E+03, 8.6244811403E-01],
	[2.38800E+04, 1.2480467759E+04, 5.1069565538E+03, 2.7431876433E+03, 1.5613388787E+03, 8.6251587085E-01],
	[2.38850E+04, 1.2484533812E+04, 5.1068480311E+03, 2.7450336158E+03, 1.5619902302E+03, 8.6258359500E-01],
	[2.38900E+04, 1.2488600339E+04, 5.1067395334E+03, 2.7468804426E+03, 1.5626415652E+03, 8.6265128649E-01],
	[2.38950E+04, 1.2492667338E+04, 5.1066310608E+03, 2.7487281241E+03, 1.5632928835E+03, 8.6271894532E-01],
	[2.39000E+04, 1.2496734811E+04, 5.1065226131E+03, 2.7505766604E+03, 1.5639441849E+03, 8.6278657152E-01],
	[2.39050E+04, 1.2500802756E+04, 5.1064141904E+03, 2.7524260517E+03, 1.5645954695E+03, 8.6285416508E-01],
	[2.39100E+04, 1.2504871175E+04, 5.1063057927E+03, 2.7542762984E+03, 1.5652467371E+03, 8.6292172603E-01],
	[2.39150E+04, 1.2508940067E+04, 5.1061974200E+03, 2.7561274005E+03, 1.5658979875E+03, 8.6298925437E-01],
	[2.39200E+04, 1.2513009431E+04, 5.1060890722E+03, 2.7579793583E+03, 1.5665492207E+03, 8.6305675012E-01],
	[2.39250E+04, 1.2517079269E+04, 5.1059807493E+03, 2.7598321720E+03, 1.5672004365E+03, 8.6312421328E-01],
	[2.39300E+04, 1.2521149579E+04, 5.1058724514E+03, 2.7616858419E+03, 1.5678516348E+03, 8.6319164387E-01],
	[2.39350E+04, 1.2525220362E+04, 5.1057641784E+03, 2.7635403681E+03, 1.5685028154E+03, 8.6325904189E-01],
	[2.39400E+04, 1.2529291618E+04, 5.1056559304E+03, 2.7653957509E+03, 1.5691539783E+03, 8.6332640736E-01],
	[2.39450E+04, 1.2533363347E+04, 5.1055477072E+03, 2.7672519904E+03, 1.5698051234E+03, 8.6339374029E-01],
	[2.39500E+04, 1.2537435548E+04, 5.1054395089E+03, 2.7691090870E+03, 1.5704562505E+03, 8.6346104069E-01],
	[2.39550E+04, 1.2541508222E+04, 5.1053313355E+03, 2.7709670407E+03, 1.5711073595E+03, 8.6352830858E-01],
	[2.39600E+04, 1.2545581368E+04, 5.1052231869E+03, 2.7728258519E+03, 1.5717584502E+03, 8.6359554395E-01],
	[2.39650E+04, 1.2549654987E+04, 5.1051150633E+03, 2.7746855207E+03, 1.5724095227E+03, 8.6366274683E-01],
	[2.39700E+04, 1.2553729079E+04, 5.1050069644E+03, 2.7765460474E+03, 1.5730605766E+03, 8.6372991723E-01],
	[2.39750E+04, 1.2557803642E+04, 5.1048988904E+03, 2.7784074322E+03, 1.5737116120E+03, 8.6379705514E-01],
	[2.39800E+04, 1.2561878679E+04, 5.1047908412E+03, 2.7802696752E+03, 1.5743626287E+03, 8.6386416060E-01],
	[2.39850E+04, 1.2565954187E+04, 5.1046828169E+03, 2.7821327768E+03, 1.5750136266E+03, 8.6393123360E-01],
	[2.39900E+04, 1.2570030168E+04, 5.1045748173E+03, 2.7839967371E+03, 1.5756646056E+03, 8.6399827417E-01],
	[2.39950E+04, 1.2574106622E+04, 5.1044668425E+03, 2.7858615563E+03, 1.5763155655E+03, 8.6406528230E-01],
	[2.40000E+04, 1.2578183547E+04, 5.1043588925E+03, 2.7877272347E+03, 1.5769665062E+03, 8.6413225802E-01],
	[2.40050E+04, 1.2582260945E+04, 5.1042509673E+03, 2.7895937724E+03, 1.5776174277E+03, 8.6419920132E-01],
	[2.40100E+04, 1.2586338815E+04, 5.1041430669E+03, 2.7914611698E+03, 1.5782683297E+03, 8.6426611224E-01],
	[2.40150E+04, 1.2590417157E+04, 5.1040351911E+03, 2.7933294269E+03, 1.5789192122E+03, 8.6433299076E-01],
	[2.40200E+04, 1.2594495970E+04, 5.1039273402E+03, 2.7951985440E+03, 1.5795700751E+03, 8.6439983691E-01],
	[2.40250E+04, 1.2598575256E+04, 5.1038195139E+03, 2.7970685214E+03, 1.5802209182E+03, 8.6446665070E-01],
	[2.40300E+04, 1.2602655014E+04, 5.1037117124E+03, 2.7989393593E+03, 1.5808717415E+03, 8.6453343214E-01],
	[2.40350E+04, 1.2606735244E+04, 5.1036039355E+03, 2.8008110578E+03, 1.5815225447E+03, 8.6460018124E-01],
	[2.40400E+04, 1.2610815946E+04, 5.1034961834E+03, 2.8026836172E+03, 1.5821733278E+03, 8.6466689801E-01],
	[2.40450E+04, 1.2614897120E+04, 5.1033884559E+03, 2.8045570377E+03, 1.5828240907E+03, 8.6473358246E-01],
	[2.40500E+04, 1.2618978765E+04, 5.1032807531E+03, 2.8064313195E+03, 1.5834748333E+03, 8.6480023461E-01],
	[2.40550E+04, 1.2623060882E+04, 5.1031730750E+03, 2.8083064628E+03, 1.5841255553E+03, 8.6486685446E-01],
	[2.40600E+04, 1.2627143471E+04, 5.1030654215E+03, 2.8101824679E+03, 1.5847762568E+03, 8.6493344203E-01],
	[2.40650E+04, 1.2631226531E+04, 5.1029577927E+03, 2.8120593350E+03, 1.5854269376E+03, 8.6499999732E-01],
	[2.40700E+04, 1.2635310064E+04, 5.1028501885E+03, 2.8139370642E+03, 1.5860775975E+03, 8.6506652036E-01],
	[2.40750E+04, 1.2639394067E+04, 5.1027426089E+03, 2.8158156558E+03, 1.5867282365E+03, 8.6513301114E-01],
	[2.40800E+04, 1.2643478542E+04, 5.1026350539E+03, 2.8176951100E+03, 1.5873788545E+03, 8.6519946969E-01],
	[2.40850E+04, 1.2647563489E+04, 5.1025275235E+03, 2.8195754271E+03, 1.5880294512E+03, 8.6526589600E-01],
	[2.40900E+04, 1.2651648907E+04, 5.1024200178E+03, 2.8214566072E+03, 1.5886800267E+03, 8.6533229011E-01],
	[2.40950E+04, 1.2655734797E+04, 5.1023125365E+03, 2.8233386506E+03, 1.5893305808E+03, 8.6539865201E-01],
	[2.41000E+04, 1.2659821158E+04, 5.1022050799E+03, 2.8252215574E+03, 1.5899811133E+03, 8.6546498171E-01],
	[2.41050E+04, 1.2663907990E+04, 5.1020976478E+03, 2.8271053280E+03, 1.5906316242E+03, 8.6553127923E-01],
	[2.41100E+04, 1.2667995293E+04, 5.1019902402E+03, 2.8289899624E+03, 1.5912821133E+03, 8.6559754459E-01],
	[2.41150E+04, 1.2672083068E+04, 5.1018828572E+03, 2.8308754610E+03, 1.5919325806E+03, 8.6566377778E-01],
	[2.41200E+04, 1.2676171314E+04, 5.1017754987E+03, 2.8327618239E+03, 1.5925830258E+03, 8.6572997883E-01],
	[2.41250E+04, 1.2680260031E+04, 5.1016681647E+03, 2.8346490514E+03, 1.5932334489E+03, 8.6579614774E-01],
	[2.41300E+04, 1.2684349219E+04, 5.1015608552E+03, 2.8365371436E+03, 1.5938838498E+03, 8.6586228453E-01],
	[2.41350E+04, 1.2688438878E+04, 5.1014535702E+03, 2.8384261009E+03, 1.5945342284E+03, 8.6592838920E-01],
	[2.41400E+04, 1.2692529009E+04, 5.1013463097E+03, 2.8403159233E+03, 1.5951845845E+03, 8.6599446178E-01],
	[2.41450E+04, 1.2696640060E+04, 5.1012442785E+03, 2.8422066112E+03, 1.5958357504E+03, 8.6606050226E-01],
	[2.41500E+04, 1.2700777003E+04, 5.1011487360E+03, 2.8440981647E+03, 1.5964879294E+03, 8.6612651066E-01],
	[2.41550E+04, 1.2704914437E+04, 5.1010532152E+03, 2.8459905840E+03, 1.5971400879E+03, 8.6619248700E-01],
	[2.41600E+04, 1.2709052363E+04, 5.1009577159E+03, 2.8478838694E+03, 1.5977922257E+03, 8.6625843128E-01],
	[2.41650E+04, 1.2713190779E+04, 5.1008622382E+03, 2.8497780212E+03, 1.5984443427E+03, 8.6632434351E-01],
	[2.41700E+04, 1.2717329687E+04, 5.1007667820E+03, 2.8516730394E+03, 1.5990964387E+03, 8.6639022372E-01],
	[2.41750E+04, 1.2721469085E+04, 5.1006713473E+03, 2.8535689243E+03, 1.5997485137E+03, 8.6645607190E-01],
	[2.41800E+04, 1.2725608974E+04, 5.1005759342E+03, 2.8554656762E+03, 1.6004005676E+03, 8.6652188807E-01],
	[2.41850E+04, 1.2729749354E+04, 5.1004805425E+03, 2.8573632952E+03, 1.6010526001E+03, 8.6658767225E-01],
	[2.41900E+04, 1.2733890225E+04, 5.1003851724E+03, 2.8592617816E+03, 1.6017046113E+03, 8.6665342444E-01],
	[2.41950E+04, 1.2738031587E+04, 5.1002898238E+03, 2.8611611356E+03, 1.6023566010E+03, 8.6671914465E-01],
	[2.42000E+04, 1.2742173439E+04, 5.1001944966E+03, 2.8630613574E+03, 1.6030085690E+03, 8.6678483290E-01],
	[2.42050E+04, 1.2746315782E+04, 5.1000991909E+03, 2.8649624472E+03, 1.6036605153E+03, 8.6685048920E-01],
	[2.42100E+04, 1.2750458616E+04, 5.1000039067E+03, 2.8668644052E+03, 1.6043124398E+03, 8.6691611355E-01],
	[2.42150E+04, 1.2754601940E+04, 5.0999086440E+03, 2.8687672317E+03, 1.6049643422E+03, 8.6698170598E-01],
	[2.42200E+04, 1.2758745755E+04, 5.0998134026E+03, 2.8706709268E+03, 1.6056162226E+03, 8.6704726650E-01],
	[2.42250E+04, 1.2762890060E+04, 5.0997181828E+03, 2.8725754909E+03, 1.6062680808E+03, 8.6711279510E-01],
	[2.42300E+04, 1.2767034856E+04, 5.0996229843E+03, 2.8744809240E+03, 1.6069199167E+03, 8.6717829181E-01],
	[2.42350E+04, 1.2771180142E+04, 5.0995278073E+03, 2.8763872265E+03, 1.6075717302E+03, 8.6724375665E-01],
	[2.42400E+04, 1.2775325918E+04, 5.0994326517E+03, 2.8782943984E+03, 1.6082235211E+03, 8.6730918961E-01],
	[2.42450E+04, 1.2779472185E+04, 5.0993375175E+03, 2.8802024402E+03, 1.6088752893E+03, 8.6737459071E-01],
	[2.42500E+04, 1.2783618942E+04, 5.0992424047E+03, 2.8821113519E+03, 1.6095270348E+03, 8.6743995996E-01],
	[2.42550E+04, 1.2787766190E+04, 5.0991473132E+03, 2.8840211338E+03, 1.6101787574E+03, 8.6750529738E-01],
	[2.42600E+04, 1.2791913927E+04, 5.0990522432E+03, 2.8859317860E+03, 1.6108304569E+03, 8.6757060297E-01],
	[2.42650E+04, 1.2796062155E+04, 5.0989571944E+03, 2.8878433089E+03, 1.6114821334E+03, 8.6763587676E-01],
	[2.42700E+04, 1.2800210873E+04, 5.0988621671E+03, 2.8897557027E+03, 1.6121337866E+03, 8.6770111874E-01],
	[2.42750E+04, 1.2804360080E+04, 5.0987671611E+03, 2.8916689674E+03, 1.6127854165E+03, 8.6776632893E-01],
	[2.42800E+04, 1.2808509778E+04, 5.0986721764E+03, 2.8935831035E+03, 1.6134370229E+03, 8.6783150735E-01],
	[2.42850E+04, 1.2812659966E+04, 5.0985772131E+03, 2.8954981110E+03, 1.6140886057E+03, 8.6789665400E-01],
	[2.42900E+04, 1.2816810644E+04, 5.0984822711E+03, 2.8974139902E+03, 1.6147401648E+03, 8.6796176890E-01],
	[2.42950E+04, 1.2820961811E+04, 5.0983873504E+03, 2.8993307413E+03, 1.6153917001E+03, 8.6802685205E-01],
	[2.43000E+04, 1.2825113469E+04, 5.0982924510E+03, 2.9012483646E+03, 1.6160432115E+03, 8.6809190348E-01],
	[2.43050E+04, 1.2829265616E+04, 5.0981975728E+03, 2.9031668602E+03, 1.6166946989E+03, 8.6815692318E-01],
	[2.43100E+04, 1.2833418253E+04, 5.0981027160E+03, 2.9050862284E+03, 1.6173461621E+03, 8.6822191118E-01],
	[2.43150E+04, 1.2837571380E+04, 5.0980078804E+03, 2.9070064693E+03, 1.6179976010E+03, 8.6828686749E-01],
	[2.43200E+04, 1.2841724996E+04, 5.0979130661E+03, 2.9089275833E+03, 1.6186490156E+03, 8.6835179211E-01],
	[2.43250E+04, 1.2845879102E+04, 5.0978182731E+03, 2.9108495704E+03, 1.6193004056E+03, 8.6841668506E-01],
	[2.43300E+04, 1.2850033698E+04, 5.0977235013E+03, 2.9127724310E+03, 1.6199517711E+03, 8.6848154635E-01],
	[2.43350E+04, 1.2854188783E+04, 5.0976287507E+03, 2.9146961652E+03, 1.6206031118E+03, 8.6854637600E-01],
	[2.43400E+04, 1.2858344358E+04, 5.0975340213E+03, 2.9166207733E+03, 1.6212544277E+03, 8.6861117401E-01],
	[2.43450E+04, 1.2862500422E+04, 5.0974393132E+03, 2.9185462555E+03, 1.6219057187E+03, 8.6867594039E-01],
	[2.43500E+04, 1.2866656976E+04, 5.0973446263E+03, 2.9204726120E+03, 1.6225569846E+03, 8.6874067516E-01],
	[2.43550E+04, 1.2870814019E+04, 5.0972499606E+03, 2.9223998430E+03, 1.6232082253E+03, 8.6880537833E-01],
	[2.43600E+04, 1.2874971551E+04, 5.0971553160E+03, 2.9243279487E+03, 1.6238594407E+03, 8.6887004992E-01],
	[2.43650E+04, 1.2879129572E+04, 5.0970606927E+03, 2.9262569294E+03, 1.6245106307E+03, 8.6893468992E-01],
	[2.43700E+04, 1.2883288083E+04, 5.0969660905E+03, 2.9281867852E+03, 1.6251617952E+03, 8.6899929837E-01],
	[2.43750E+04, 1.2887447083E+04, 5.0968715095E+03, 2.9301175164E+03, 1.6258129341E+03, 8.6906387526E-01],
	[2.43800E+04, 1.2891606572E+04, 5.0967769497E+03, 2.9320491232E+03, 1.6264640472E+03, 8.6912842060E-01],
	[2.43850E+04, 1.2895766551E+04, 5.0966824109E+03, 2.9339816058E+03, 1.6271151344E+03, 8.6919293442E-01],
	[2.43900E+04, 1.2899927018E+04, 5.0965878934E+03, 2.9359149644E+03, 1.6277661957E+03, 8.6925741672E-01],
	[2.43950E+04, 1.2904087974E+04, 5.0964933969E+03, 2.9378491993E+03, 1.6284172309E+03, 8.6932186752E-01],
	[2.44000E+04, 1.2908249420E+04, 5.0963989216E+03, 2.9397843107E+03, 1.6290682400E+03, 8.6938628682E-01],
	[2.44050E+04, 1.2912411354E+04, 5.0963044673E+03, 2.9417202987E+03, 1.6297192227E+03, 8.6945067465E-01],
	[2.44100E+04, 1.2916573777E+04, 5.0962100342E+03, 2.9436571636E+03, 1.6303701789E+03, 8.6951503100E-01],
	[2.44150E+04, 1.2920736690E+04, 5.0961156222E+03, 2.9455949056E+03, 1.6310211087E+03, 8.6957935589E-01],
	[2.44200E+04, 1.2924900090E+04, 5.0960212312E+03, 2.9475335250E+03, 1.6316720118E+03, 8.6964364934E-01],
	[2.44250E+04, 1.2929063980E+04, 5.0959268613E+03, 2.9494730219E+03, 1.6323228881E+03, 8.6970791136E-01],
	[2.44300E+04, 1.2933228359E+04, 5.0958325125E+03, 2.9514133966E+03, 1.6329737376E+03, 8.6977214195E-01],
	[2.44350E+04, 1.2937393226E+04, 5.0957381848E+03, 2.9533546492E+03, 1.6336245600E+03, 8.6983634114E-01],
	[2.44400E+04, 1.2941558581E+04, 5.0956438780E+03, 2.9552967801E+03, 1.6342753554E+03, 8.6990050892E-01],
	[2.44450E+04, 1.2945724426E+04, 5.0955495924E+03, 2.9572397893E+03, 1.6349261236E+03, 8.6996464532E-01],
	[2.44500E+04, 1.2949890759E+04, 5.0954553277E+03, 2.9591836772E+03, 1.6355768644E+03, 8.7002875035E-01],
	[2.44550E+04, 1.2954057580E+04, 5.0953610841E+03, 2.9611284440E+03, 1.6362275778E+03, 8.7009282401E-01],
	[2.44600E+04, 1.2958224890E+04, 5.0952668614E+03, 2.9630740898E+03, 1.6368782637E+03, 8.7015686633E-01],
	[2.44650E+04, 1.2962392688E+04, 5.0951726598E+03, 2.9650206149E+03, 1.6375289219E+03, 8.7022087731E-01],
	[2.44700E+04, 1.2966560975E+04, 5.0950784792E+03, 2.9669680194E+03, 1.6381795523E+03, 8.7028485696E-01],
	[2.44750E+04, 1.2970729750E+04, 5.0949843195E+03, 2.9689163037E+03, 1.6388301548E+03, 8.7034880530E-01],
	[2.44800E+04, 1.2974899014E+04, 5.0948901808E+03, 2.9708654680E+03, 1.6394807294E+03, 8.7041272233E-01],
	[2.44850E+04, 1.2979068765E+04, 5.0947960631E+03, 2.9728155123E+03, 1.6401312758E+03, 8.7047660808E-01],
	[2.44900E+04, 1.2983239005E+04, 5.0947019664E+03, 2.9747664371E+03, 1.6407817940E+03, 8.7054046255E-01],
	[2.44950E+04, 1.2987409733E+04, 5.0946078905E+03, 2.9767182424E+03, 1.6414322839E+03, 8.7060428575E-01],
	[2.45000E+04, 1.2991580950E+04, 5.0945138357E+03, 2.9786709285E+03, 1.6420827453E+03, 8.7066807770E-01],
	[2.45050E+04, 1.2995752654E+04, 5.0944198017E+03, 2.9806244956E+03, 1.6427331782E+03, 8.7073183841E-01],
	[2.45100E+04, 1.2999924846E+04, 5.0943257887E+03, 2.9825789440E+03, 1.6433835824E+03, 8.7079556789E-01],
	[2.45150E+04, 1.3004097527E+04, 5.0942317966E+03, 2.9845342738E+03, 1.6440339578E+03, 8.7085926615E-01],
	[2.45200E+04, 1.3008270695E+04, 5.0941378254E+03, 2.9864904853E+03, 1.6446843043E+03, 8.7092293321E-01],
	[2.45250E+04, 1.3012444351E+04, 5.0940438750E+03, 2.9884475786E+03, 1.6453346219E+03, 8.7098656907E-01],
	[2.45300E+04, 1.3016618495E+04, 5.0939499456E+03, 2.9904055541E+03, 1.6459849103E+03, 8.7105017376E-01],
	[2.45350E+04, 1.3020793127E+04, 5.0938560370E+03, 2.9923644119E+03, 1.6466351695E+03, 8.7111374727E-01],
	[2.45400E+04, 1.3024968247E+04, 5.0937621493E+03, 2.9943241522E+03, 1.6472853994E+03, 8.7117728963E-01],
	[2.45450E+04, 1.3029143855E+04, 5.0936682825E+03, 2.9962847753E+03, 1.6479355998E+03, 8.7124080084E-01],
	[2.45500E+04, 1.3033319950E+04, 5.0935744365E+03, 2.9982462813E+03, 1.6485857706E+03, 8.7130428092E-01],
	[2.45550E+04, 1.3037496533E+04, 5.0934806114E+03, 3.0002086705E+03, 1.6492359118E+03, 8.7136772989E-01],
	[2.45600E+04, 1.3041673603E+04, 5.0933868071E+03, 3.0021719431E+03, 1.6498860232E+03, 8.7143114774E-01],
	[2.45650E+04, 1.3045851161E+04, 5.0932930236E+03, 3.0041360993E+03, 1.6505361047E+03, 8.7149453450E-01],
	[2.45700E+04, 1.3050029207E+04, 5.0931992609E+03, 3.0061011394E+03, 1.6511861563E+03, 8.7155789017E-01],
	[2.45750E+04, 1.3054207740E+04, 5.0931055190E+03, 3.0080670635E+03, 1.6518361777E+03, 8.7162121477E-01],
	[2.45800E+04, 1.3058386761E+04, 5.0930117979E+03, 3.0100338719E+03, 1.6524861688E+03, 8.7168450831E-01],
	[2.45850E+04, 1.3062566269E+04, 5.0929180976E+03, 3.0120015648E+03, 1.6531361297E+03, 8.7174777081E-01],
	[2.45900E+04, 1.3066746264E+04, 5.0928244181E+03, 3.0139701424E+03, 1.6537860601E+03, 8.7181100227E-01],
	[2.45950E+04, 1.3070926747E+04, 5.0927307593E+03, 3.0159396049E+03, 1.6544359599E+03, 8.7187420271E-01],
	[2.46000E+04, 1.3075107717E+04, 5.0926371214E+03, 3.0179099525E+03, 1.6550858291E+03, 8.7193737213E-01],
	[2.46050E+04, 1.3079289174E+04, 5.0925435041E+03, 3.0198811855E+03, 1.6557356675E+03, 8.7200051056E-01],
	[2.46100E+04, 1.3083471119E+04, 5.0924499076E+03, 3.0218533041E+03, 1.6563854750E+03, 8.7206361800E-01],
	[2.46150E+04, 1.3087653550E+04, 5.0923563319E+03, 3.0238263084E+03, 1.6570352516E+03, 8.7212669447E-01],
	[2.46200E+04, 1.3091836469E+04, 5.0922627768E+03, 3.0258001988E+03, 1.6576849970E+03, 8.7218973998E-01],
	[2.46250E+04, 1.3096019875E+04, 5.0921692425E+03, 3.0277749754E+03, 1.6583347112E+03, 8.7225275454E-01],
	[2.46300E+04, 1.3100203768E+04, 5.0920757289E+03, 3.0297506384E+03, 1.6589843941E+03, 8.7231573816E-01],
	[2.46350E+04, 1.3104388148E+04, 5.0919822360E+03, 3.0317271880E+03, 1.6596340455E+03, 8.7237869085E-01],
	[2.46400E+04, 1.3108573014E+04, 5.0918887637E+03, 3.0337046246E+03, 1.6602836654E+03, 8.7244161264E-01],
	[2.46450E+04, 1.3112758368E+04, 5.0917953122E+03, 3.0356829482E+03, 1.6609332536E+03, 8.7250450352E-01],
	[2.46500E+04, 1.3116944209E+04, 5.0917018813E+03, 3.0376621592E+03, 1.6615828101E+03, 8.7256736351E-01],
	[2.46550E+04, 1.3121130536E+04, 5.0916084711E+03, 3.0396422577E+03, 1.6622323347E+03, 8.7263019263E-01],
	[2.46600E+04, 1.3125317350E+04, 5.0915150816E+03, 3.0416232439E+03, 1.6628818273E+03, 8.7269299089E-01],
	[2.46650E+04, 1.3129504651E+04, 5.0914217127E+03, 3.0436051181E+03, 1.6635312879E+03, 8.7275575829E-01],
	[2.46700E+04, 1.3133692439E+04, 5.0913283644E+03, 3.0455878804E+03, 1.6641807162E+03, 8.7281849485E-01],
	[2.46750E+04, 1.3137880713E+04, 5.0912350367E+03, 3.0475715312E+03, 1.6648301122E+03, 8.7288120059E-01],
	[2.46800E+04, 1.3142069474E+04, 5.0911417297E+03, 3.0495560705E+03, 1.6654794758E+03, 8.7294387552E-01],
	[2.46850E+04, 1.3146258722E+04, 5.0910484433E+03, 3.0515414987E+03, 1.6661288068E+03, 8.7300651964E-01],
	[2.46900E+04, 1.3150448456E+04, 5.0909551775E+03, 3.0535278160E+03, 1.6667781052E+03, 8.7306913297E-01],
	[2.46950E+04, 1.3154638676E+04, 5.0908619323E+03, 3.0555150225E+03, 1.6674273709E+03, 8.7313171552E-01],
	[2.47000E+04, 1.3158829383E+04, 5.0907687077E+03, 3.0575031184E+03, 1.6680766037E+03, 8.7319426731E-01],
	[2.47050E+04, 1.3163020576E+04, 5.0906755036E+03, 3.0594921041E+03, 1.6687258035E+03, 8.7325678835E-01],
	[2.47100E+04, 1.3167212256E+04, 5.0905823201E+03, 3.0614819797E+03, 1.6693749703E+03, 8.7331927864E-01],
	[2.47150E+04, 1.3171404422E+04, 5.0904891572E+03, 3.0634727454E+03, 1.6700241039E+03, 8.7338173820E-01],
	[2.47200E+04, 1.3175597074E+04, 5.0903960148E+03, 3.0654644015E+03, 1.6706732042E+03, 8.7344416704E-01],
	[2.47250E+04, 1.3179790213E+04, 5.0903028930E+03, 3.0674569481E+03, 1.6713222711E+03, 8.7350656516E-01],
	[2.47300E+04, 1.3183983838E+04, 5.0902097917E+03, 3.0694503856E+03, 1.6719713044E+03, 8.7356893259E-01],
	[2.47350E+04, 1.3188177948E+04, 5.0901167109E+03, 3.0714447140E+03, 1.6726203042E+03, 8.7363126933E-01],
	[2.47400E+04, 1.3192372545E+04, 5.0900236506E+03, 3.0734399336E+03, 1.6732692702E+03, 8.7369357539E-01],
	[2.47450E+04, 1.3196567628E+04, 5.0899306109E+03, 3.0754360447E+03, 1.6739182024E+03, 8.7375585079E-01],
	[2.47500E+04, 1.3200763197E+04, 5.0898375916E+03, 3.0774330474E+03, 1.6745671006E+03, 8.7381809553E-01],
	[2.47550E+04, 1.3204959253E+04, 5.0897445928E+03, 3.0794309420E+03, 1.6752159648E+03, 8.7388030962E-01],
	[2.47600E+04, 1.3209155794E+04, 5.0896516145E+03, 3.0814297287E+03, 1.6758647948E+03, 8.7394249308E-01],
	[2.47650E+04, 1.3213352820E+04, 5.0895586567E+03, 3.0834294077E+03, 1.6765135906E+03, 8.7400464592E-01],
	[2.47700E+04, 1.3217550333E+04, 5.0894657193E+03, 3.0854299792E+03, 1.6771623520E+03, 8.7406676815E-01],
	[2.47750E+04, 1.3221748332E+04, 5.0893728024E+03, 3.0874314435E+03, 1.6778110789E+03, 8.7412885977E-01],
	[2.47800E+04, 1.3225946816E+04, 5.0892799060E+03, 3.0894338007E+03, 1.6784597712E+03, 8.7419092081E-01],
	[2.47850E+04, 1.3230145786E+04, 5.0891870300E+03, 3.0914370511E+03, 1.6791084288E+03, 8.7425295127E-01],
	[2.47900E+04, 1.3234345242E+04, 5.0890941744E+03, 3.0934411949E+03, 1.6797570516E+03, 8.7431495116E-01],
	[2.47950E+04, 1.3238545183E+04, 5.0890013392E+03, 3.0954462322E+03, 1.6804056394E+03, 8.7437692049E-01],
	[2.48000E+04, 1.3242745610E+04, 5.0889085245E+03, 3.0974521635E+03, 1.6810541923E+03, 8.7443885928E-01],
	[2.48050E+04, 1.3246946523E+04, 5.0888157301E+03, 3.0994589887E+03, 1.6817027100E+03, 8.7450076754E-01],
	[2.48100E+04, 1.3251147921E+04, 5.0887229561E+03, 3.1014667082E+03, 1.6823511925E+03, 8.7456264527E-01],
	[2.48150E+04, 1.3255349805E+04, 5.0886302026E+03, 3.1034753222E+03, 1.6829996396E+03, 8.7462449250E-01],
	[2.48200E+04, 1.3259552174E+04, 5.0885374694E+03, 3.1054848309E+03, 1.6836480513E+03, 8.7468630922E-01],
	[2.48250E+04, 1.3263755028E+04, 5.0884447565E+03, 3.1074952345E+03, 1.6842964274E+03, 8.7474809545E-01],
	[2.48300E+04, 1.3267958368E+04, 5.0883520641E+03, 3.1095065333E+03, 1.6849447679E+03, 8.7480985121E-01],
	[2.48350E+04, 1.3272162193E+04, 5.0882593920E+03, 3.1115187274E+03, 1.6855930725E+03, 8.7487157649E-01],
	[2.48400E+04, 1.3276366504E+04, 5.0881667402E+03, 3.1135318170E+03, 1.6862413413E+03, 8.7493327133E-01],
	[2.48450E+04, 1.3280571299E+04, 5.0880741088E+03, 3.1155458024E+03, 1.6868895741E+03, 8.7499493571E-01],
	[2.48500E+04, 1.3284776580E+04, 5.0879814976E+03, 3.1175606839E+03, 1.6875377708E+03, 8.7505656967E-01],
	[2.48550E+04, 1.3288982346E+04, 5.0878889068E+03, 3.1195764615E+03, 1.6881859313E+03, 8.7511817320E-01],
	[2.48600E+04, 1.3293188597E+04, 5.0877963364E+03, 3.1215931356E+03, 1.6888340555E+03, 8.7517974632E-01],
	[2.48650E+04, 1.3297395333E+04, 5.0877037862E+03, 3.1236107064E+03, 1.6894821433E+03, 8.7524128904E-01],
	[2.48700E+04, 1.3301602554E+04, 5.0876112563E+03, 3.1256291740E+03, 1.6901301945E+03, 8.7530280137E-01],
	[2.48750E+04, 1.3305810260E+04, 5.0875187467E+03, 3.1276485387E+03, 1.6907782091E+03, 8.7536428333E-01],
	[2.48800E+04, 1.3310018452E+04, 5.0874262573E+03, 3.1296688007E+03, 1.6914261870E+03, 8.7542573492E-01],
	[2.48850E+04, 1.3314227128E+04, 5.0873337883E+03, 3.1316899602E+03, 1.6920741280E+03, 8.7548715616E-01],
	[2.48900E+04, 1.3318436288E+04, 5.0872413394E+03, 3.1337120175E+03, 1.6927220321E+03, 8.7554854705E-01],
	[2.48950E+04, 1.3322645934E+04, 5.0871489109E+03, 3.1357349727E+03, 1.6933698991E+03, 8.7560990761E-01],
	[2.49000E+04, 1.3326856064E+04, 5.0870565026E+03, 3.1377588261E+03, 1.6940177290E+03, 8.7567123785E-01],
	[2.49050E+04, 1.3331066680E+04, 5.0869641145E+03, 3.1397835779E+03, 1.6946655216E+03, 8.7573253778E-01],
	[2.49100E+04, 1.3335277779E+04, 5.0868717466E+03, 3.1418092284E+03, 1.6953132768E+03, 8.7579380741E-01],
	[2.49150E+04, 1.3339489364E+04, 5.0867793989E+03, 3.1438357776E+03, 1.6959609946E+03, 8.7585504675E-01],
	[2.49200E+04, 1.3343701433E+04, 5.0866870715E+03, 3.1458632259E+03, 1.6966086747E+03, 8.7591625582E-01],
	[2.49250E+04, 1.3347913987E+04, 5.0865947642E+03, 3.1478915734E+03, 1.6972563172E+03, 8.7597743462E-01],
	[2.49300E+04, 1.3352127025E+04, 5.0865024772E+03, 3.1499208205E+03, 1.6979039218E+03, 8.7603858318E-01],
	[2.49350E+04, 1.3356340548E+04, 5.0864102103E+03, 3.1519509672E+03, 1.6985514886E+03, 8.7609970149E-01],
	[2.49400E+04, 1.3360554555E+04, 5.0863179636E+03, 3.1539820139E+03, 1.6991990173E+03, 8.7616078957E-01],
	[2.49450E+04, 1.3364769046E+04, 5.0862257371E+03, 3.1560139607E+03, 1.6998465079E+03, 8.7622184743E-01],
	[2.49500E+04, 1.3368984022E+04, 5.0861335307E+03, 3.1580468078E+03, 1.7004939603E+03, 8.7628287508E-01],
	[2.49550E+04, 1.3373199482E+04, 5.0860413445E+03, 3.1600805555E+03, 1.7011413744E+03, 8.7634387254E-01],
	[2.49600E+04, 1.3377415427E+04, 5.0859491784E+03, 3.1621152040E+03, 1.7017887501E+03, 8.7640483982E-01],
	[2.49650E+04, 1.3381631856E+04, 5.0858570324E+03, 3.1641507535E+03, 1.7024360872E+03, 8.7646577692E-01],
	[2.49700E+04, 1.3385848768E+04, 5.0857649065E+03, 3.1661872042E+03, 1.7030833856E+03, 8.7652668385E-01],
	[2.49750E+04, 1.3390066166E+04, 5.0856728008E+03, 3.1682245564E+03, 1.7037306454E+03, 8.7658756064E-01],
	[2.49800E+04, 1.3394284047E+04, 5.0855807152E+03, 3.1702628102E+03, 1.7043778662E+03, 8.7664840729E-01],
	[2.49850E+04, 1.3398502412E+04, 5.0854886497E+03, 3.1723019659E+03, 1.7050250481E+03, 8.7670922381E-01],
	[2.49900E+04, 1.3402721261E+04, 5.0853966042E+03, 3.1743420237E+03, 1.7056721910E+03, 8.7677001022E-01],
	[2.49950E+04, 1.3406940594E+04, 5.0853045789E+03, 3.1763829838E+03, 1.7063192946E+03, 8.7683076652E-01],
	[2.50000E+04, 1.3411160412E+04, 5.0852125736E+03, 3.1784248464E+03, 1.7069663590E+03, 8.7689149273E-01],
	[2.50050E+04, 1.3415380713E+04, 5.0851205883E+03, 3.1804760448E+03, 1.7076158150E+03, 8.7695218886E-01],
	[2.50100E+04, 1.3419601498E+04, 5.0850286232E+03, 3.1825281551E+03, 1.7082652315E+03, 8.7701285491E-01],
	[2.50150E+04, 1.3423822767E+04, 5.0849366781E+03, 3.1845811776E+03, 1.7089146085E+03, 8.7707349091E-01],
	[2.50200E+04, 1.3428044519E+04, 5.0848447530E+03, 3.1866351125E+03, 1.7095639458E+03, 8.7713409686E-01],
	[2.50250E+04, 1.3432266755E+04, 5.0847528479E+03, 3.1886899601E+03, 1.7102132433E+03, 8.7719467278E-01],
	[2.50300E+04, 1.3436489475E+04, 5.0846609629E+03, 3.1907457205E+03, 1.7108625009E+03, 8.7725521867E-01],
	[2.50350E+04, 1.3440712679E+04, 5.0845690979E+03, 3.1928023941E+03, 1.7115117186E+03, 8.7731573455E-01],
	[2.50400E+04, 1.3444936366E+04, 5.0844772528E+03, 3.1948599809E+03, 1.7121608962E+03, 8.7737622042E-01],
	[2.50450E+04, 1.3449160537E+04, 5.0843854278E+03, 3.1969184813E+03, 1.7128100335E+03, 8.7743667631E-01],
	[2.50500E+04, 1.3453385192E+04, 5.0842936228E+03, 3.1989778954E+03, 1.7134591306E+03, 8.7749710222E-01],
	[2.50550E+04, 1.3457610330E+04, 5.0842018377E+03, 3.2010382235E+03, 1.7141081873E+03, 8.7755749816E-01],
	[2.50600E+04, 1.3461835951E+04, 5.0841100727E+03, 3.2030994658E+03, 1.7147572034E+03, 8.7761786415E-01],
	[2.50650E+04, 1.3466062056E+04, 5.0840183275E+03, 3.2051616225E+03, 1.7154061790E+03, 8.7767820020E-01],
	[2.50700E+04, 1.3470288644E+04, 5.0839266024E+03, 3.2072246938E+03, 1.7160551138E+03, 8.7773850631E-01],
	[2.50750E+04, 1.3474515715E+04, 5.0838348972E+03, 3.2092886801E+03, 1.7167040078E+03, 8.7779878250E-01],
	[2.50800E+04, 1.3478743270E+04, 5.0837432119E+03, 3.2113535814E+03, 1.7173528608E+03, 8.7785902879E-01],
	[2.50850E+04, 1.3482971308E+04, 5.0836515465E+03, 3.2134193980E+03, 1.7180016728E+03, 8.7791924517E-01],
	[2.50900E+04, 1.3487199829E+04, 5.0835599011E+03, 3.2154861301E+03, 1.7186504437E+03, 8.7797943168E-01],
	[2.50950E+04, 1.3491428833E+04, 5.0834682756E+03, 3.2175537781E+03, 1.7192991733E+03, 8.7803958830E-01],
	[2.51000E+04, 1.3495658321E+04, 5.0833766700E+03, 3.2196223419E+03, 1.7199478616E+03, 8.7809971507E-01],
	[2.51050E+04, 1.3499888291E+04, 5.0832850843E+03, 3.2216918220E+03, 1.7205965084E+03, 8.7815981198E-01],
	[2.51100E+04, 1.3504157634E+04, 5.0832030186E+03, 3.2237622185E+03, 1.7212468348E+03, 8.7821987906E-01],
	[2.51150E+04, 1.3508434410E+04, 5.0831226640E+03, 3.2258335317E+03, 1.7218974283E+03, 8.7827991631E-01],
	[2.51200E+04, 1.3512711689E+04, 5.0830423268E+03, 3.2279057617E+03, 1.7225479824E+03, 8.7833992374E-01],
	[2.51250E+04, 1.3516989471E+04, 5.0829620067E+03, 3.2299789088E+03, 1.7231984967E+03, 8.7839990137E-01],
	[2.51300E+04, 1.3521267756E+04, 5.0828817040E+03, 3.2320529732E+03, 1.7238489714E+03, 8.7845984921E-01],
	[2.51350E+04, 1.3525546543E+04, 5.0828014185E+03, 3.2341279552E+03, 1.7244994062E+03, 8.7851976727E-01],
	[2.51400E+04, 1.3529825832E+04, 5.0827211502E+03, 3.2362038549E+03, 1.7251498010E+03, 8.7857965556E-01],
	[2.51450E+04, 1.3534105625E+04, 5.0826408991E+03, 3.2382806726E+03, 1.7258001558E+03, 8.7863951409E-01],
	[2.51500E+04, 1.3538385919E+04, 5.0825606653E+03, 3.2403584085E+03, 1.7264504704E+03, 8.7869934287E-01],
	[2.51550E+04, 1.3542666716E+04, 5.0824804487E+03, 3.2424370628E+03, 1.7271007448E+03, 8.7875914192E-01],
	[2.51600E+04, 1.3546948015E+04, 5.0824002493E+03, 3.2445166358E+03, 1.7277509787E+03, 8.7881891125E-01],
	[2.51650E+04, 1.3551229817E+04, 5.0823200671E+03, 3.2465971276E+03, 1.7284011722E+03, 8.7887865087E-01],
	[2.51700E+04, 1.3555512121E+04, 5.0822399021E+03, 3.2486785385E+03, 1.7290513252E+03, 8.7893836079E-01],
	[2.51750E+04, 1.3559794927E+04, 5.0821597543E+03, 3.2507608687E+03, 1.7297014374E+03, 8.7899804102E-01],
	[2.51800E+04, 1.3564078236E+04, 5.0820796236E+03, 3.2528441185E+03, 1.7303515089E+03, 8.7905769158E-01],
	[2.51850E+04, 1.3568362046E+04, 5.0819995102E+03, 3.2549282880E+03, 1.7310015394E+03, 8.7911731247E-01],
	[2.51900E+04, 1.3572646359E+04, 5.0819194139E+03, 3.2570133775E+03, 1.7316515290E+03, 8.7917690371E-01],
	[2.51950E+04, 1.3576931174E+04, 5.0818393347E+03, 3.2590993872E+03, 1.7323014775E+03, 8.7923646532E-01],
	[2.52000E+04, 1.3581216491E+04, 5.0817592728E+03, 3.2611863174E+03, 1.7329513848E+03, 8.7929599729E-01],
	[2.52050E+04, 1.3585502309E+04, 5.0816792279E+03, 3.2632741682E+03, 1.7336012508E+03, 8.7935549965E-01],
	[2.52100E+04, 1.3589788630E+04, 5.0815992002E+03, 3.2653629398E+03, 1.7342510754E+03, 8.7941497240E-01],
	[2.52150E+04, 1.3594075453E+04, 5.0815191896E+03, 3.2674526326E+03, 1.7349008584E+03, 8.7947441556E-01],
	[2.52200E+04, 1.3598362778E+04, 5.0814391962E+03, 3.2695432466E+03, 1.7355505999E+03, 8.7953382914E-01],
	[2.52250E+04, 1.3602650604E+04, 5.0813592198E+03, 3.2716347822E+03, 1.7362002997E+03, 8.7959321315E-01],
	[2.52300E+04, 1.3606938932E+04, 5.0812792606E+03, 3.2737272396E+03, 1.7368499576E+03, 8.7965256760E-01],
	[2.52350E+04, 1.3611227762E+04, 5.0811993185E+03, 3.2758206190E+03, 1.7374995736E+03, 8.7971189251E-01],
	[2.52400E+04, 1.3615517094E+04, 5.0811193935E+03, 3.2779149205E+03, 1.7381491476E+03, 8.7977118788E-01],
	[2.52450E+04, 1.3619806928E+04, 5.0810394855E+03, 3.2800101445E+03, 1.7387986795E+03, 8.7983045373E-01],
	[2.52500E+04, 1.3624097263E+04, 5.0809595947E+03, 3.2821062911E+03, 1.7394481692E+03, 8.7988969007E-01],
	[2.52550E+04, 1.3628388099E+04, 5.0808797209E+03, 3.2842033607E+03, 1.7400976165E+03, 8.7994889691E-01],
	[2.52600E+04, 1.3632679437E+04, 5.0807998642E+03, 3.2863013533E+03, 1.7407470214E+03, 8.8000807426E-01],
	[2.52650E+04, 1.3636971277E+04, 5.0807200245E+03, 3.2884002692E+03, 1.7413963837E+03, 8.8006722214E-01],
	[2.52700E+04, 1.3641263618E+04, 5.0806402019E+03, 3.2905001087E+03, 1.7420457035E+03, 8.8012634056E-01],
	[2.52750E+04, 1.3645556461E+04, 5.0805603963E+03, 3.2926008719E+03, 1.7426949805E+03, 8.8018542953E-01],
	[2.52800E+04, 1.3649849805E+04, 5.0804806078E+03, 3.2947025591E+03, 1.7433442146E+03, 8.8024448905E-01],
	[2.52850E+04, 1.3654143650E+04, 5.0804008363E+03, 3.2968051706E+03, 1.7439934058E+03, 8.8030351915E-01],
	[2.52900E+04, 1.3658437997E+04, 5.0803210819E+03, 3.2989087064E+03, 1.7446425540E+03, 8.8036251984E-01],
	[2.52950E+04, 1.3662732845E+04, 5.0802413444E+03, 3.3010131670E+03, 1.7452916590E+03, 8.8042149112E-01],
	[2.53000E+04, 1.3667028194E+04, 5.0801616240E+03, 3.3031185524E+03, 1.7459407208E+03, 8.8048043301E-01],
	[2.53050E+04, 1.3671324045E+04, 5.0800819206E+03, 3.3052248629E+03, 1.7465897392E+03, 8.8053934552E-01],
	[2.53100E+04, 1.3675620396E+04, 5.0800022341E+03, 3.3073320987E+03, 1.7472387142E+03, 8.8059822866E-01],
	[2.53150E+04, 1.3679917249E+04, 5.0799225647E+03, 3.3094402601E+03, 1.7478876456E+03, 8.8065708244E-01],
	[2.53200E+04, 1.3684214603E+04, 5.0798429122E+03, 3.3115493472E+03, 1.7485365334E+03, 8.8071590689E-01],
	[2.53250E+04, 1.3688512457E+04, 5.0797632768E+03, 3.3136593603E+03, 1.7491853774E+03, 8.8077470200E-01],
	[2.53300E+04, 1.3692810813E+04, 5.0796836582E+03, 3.3157702997E+03, 1.7498341776E+03, 8.8083346779E-01],
	[2.53350E+04, 1.3697109670E+04, 5.0796040567E+03, 3.3178821655E+03, 1.7504829338E+03, 8.8089220427E-01],
	[2.53400E+04, 1.3701409027E+04, 5.0795244721E+03, 3.3199949579E+03, 1.7511316459E+03, 8.8095091145E-01],
	[2.53450E+04, 1.3705708886E+04, 5.0794449044E+03, 3.3221086773E+03, 1.7517803139E+03, 8.8100958935E-01],
	[2.53500E+04, 1.3710009245E+04, 5.0793653537E+03, 3.3242233237E+03, 1.7524289377E+03, 8.8106823798E-01],
	[2.53550E+04, 1.3714310105E+04, 5.0792858200E+03, 3.3263388975E+03, 1.7530775170E+03, 8.8112685735E-01],
	[2.53600E+04, 1.3718611466E+04, 5.0792063031E+03, 3.3284553988E+03, 1.7537260519E+03, 8.8118544747E-01],
	[2.53650E+04, 1.3722913328E+04, 5.0791268032E+03, 3.3305728279E+03, 1.7543745423E+03, 8.8124400835E-01],
	[2.53700E+04, 1.3727215690E+04, 5.0790473202E+03, 3.3326911850E+03, 1.7550229880E+03, 8.8130254001E-01],
	[2.53750E+04, 1.3731518553E+04, 5.0789678541E+03, 3.3348104703E+03, 1.7556713889E+03, 8.8136104246E-01],
	[2.53800E+04, 1.3735821916E+04, 5.0788884049E+03, 3.3369306840E+03, 1.7563197449E+03, 8.8141951571E-01],
	[2.53850E+04, 1.3740125780E+04, 5.0788089726E+03, 3.3390518264E+03, 1.7569680560E+03, 8.8147795976E-01],
	[2.53900E+04, 1.3744430144E+04, 5.0787295571E+03, 3.3411738978E+03, 1.7576163220E+03, 8.8153637464E-01],
	[2.53950E+04, 1.3748735009E+04, 5.0786501586E+03, 3.3432968982E+03, 1.7582645429E+03, 8.8159476036E-01],
	[2.54000E+04, 1.3753040375E+04, 5.0785707769E+03, 3.3454208279E+03, 1.7589127185E+03, 8.8165311692E-01],
	[2.54050E+04, 1.3757346240E+04, 5.0784914121E+03, 3.3475456872E+03, 1.7595608487E+03, 8.8171144435E-01],
	[2.54100E+04, 1.3761652606E+04, 5.0784120642E+03, 3.3496714763E+03, 1.7602089334E+03, 8.8176974264E-01],
	[2.54150E+04, 1.3765959473E+04, 5.0783327331E+03, 3.3517981954E+03, 1.7608569726E+03, 8.8182801182E-01],
	[2.54200E+04, 1.3770266839E+04, 5.0782534188E+03, 3.3539258448E+03, 1.7615049661E+03, 8.8188625190E-01],
	[2.54250E+04, 1.3774574706E+04, 5.0781741214E+03, 3.3560544245E+03, 1.7621529139E+03, 8.8194446288E-01],
	[2.54300E+04, 1.3778883073E+04, 5.0780948408E+03, 3.3581839350E+03, 1.7628008157E+03, 8.8200264478E-01],
	[2.54350E+04, 1.3783191940E+04, 5.0780155771E+03, 3.3603143763E+03, 1.7634486716E+03, 8.8206079761E-01],
	[2.54400E+04, 1.3787501308E+04, 5.0779363301E+03, 3.3624457488E+03, 1.7640964815E+03, 8.8211892139E-01],
	[2.54450E+04, 1.3791811175E+04, 5.0778571000E+03, 3.3645780526E+03, 1.7647442452E+03, 8.8217701613E-01],
	[2.54500E+04, 1.3796121542E+04, 5.0777778866E+03, 3.3667112879E+03, 1.7653919626E+03, 8.8223508183E-01],
	[2.54550E+04, 1.3800432410E+04, 5.0776986901E+03, 3.3688454551E+03, 1.7660396336E+03, 8.8229311851E-01],
	[2.54600E+04, 1.3804743777E+04, 5.0776195104E+03, 3.3709805542E+03, 1.7666872582E+03, 8.8235112618E-01],
	[2.54650E+04, 1.3809055644E+04, 5.0775403474E+03, 3.3731165856E+03, 1.7673348362E+03, 8.8240910486E-01],
	[2.54700E+04, 1.3813368011E+04, 5.0774612012E+03, 3.3752535495E+03, 1.7679823676E+03, 8.8246705455E-01],
	[2.54750E+04, 1.3817680878E+04, 5.0773820718E+03, 3.3773914460E+03, 1.7686298522E+03, 8.8252497528E-01],
	[2.54800E+04, 1.3821994244E+04, 5.0773029591E+03, 3.3795302754E+03, 1.7692772899E+03, 8.8258286704E-01],
	[2.54850E+04, 1.3826308111E+04, 5.0772238632E+03, 3.3816700380E+03, 1.7699246806E+03, 8.8264072985E-01],
	[2.54900E+04, 1.3830622477E+04, 5.0771447841E+03, 3.3838107339E+03, 1.7705720243E+03, 8.8269856373E-01],
	[2.54950E+04, 1.3834937342E+04, 5.0770657217E+03, 3.3859523634E+03, 1.7712193209E+03, 8.8275636869E-01],
	[2.55000E+04, 1.3839252708E+04, 5.0769866760E+03, 3.3880949266E+03, 1.7718665702E+03, 8.8281414474E-01],
	[2.55050E+04, 1.3843568573E+04, 5.0769076470E+03, 3.3902384239E+03, 1.7725137721E+03, 8.8287189188E-01],
	[2.55100E+04, 1.3847884937E+04, 5.0768286348E+03, 3.3923828555E+03, 1.7731609265E+03, 8.8292961014E-01],
	[2.55150E+04, 1.3852201801E+04, 5.0767496393E+03, 3.3945282214E+03, 1.7738080335E+03, 8.8298729953E-01],
	[2.55200E+04, 1.3856519164E+04, 5.0766706605E+03, 3.3966745221E+03, 1.7744550927E+03, 8.8304496005E-01],
	[2.55250E+04, 1.3860837027E+04, 5.0765916984E+03, 3.3988217577E+03, 1.7751021042E+03, 8.8310259172E-01],
	[2.55300E+04, 1.3865155389E+04, 5.0765127530E+03, 3.4009699284E+03, 1.7757490679E+03, 8.8316019456E-01],
	[2.55350E+04, 1.3869474251E+04, 5.0764338243E+03, 3.4031190345E+03, 1.7763959836E+03, 8.8321776857E-01],
	[2.55400E+04, 1.3873793612E+04, 5.0763549122E+03, 3.4052690762E+03, 1.7770428512E+03, 8.8327531376E-01],
	[2.55450E+04, 1.3878113472E+04, 5.0762760168E+03, 3.4074200536E+03, 1.7776896708E+03, 8.8333283015E-01],
	[2.55500E+04, 1.3882433831E+04, 5.0761971381E+03, 3.4095719671E+03, 1.7783364420E+03, 8.8339031776E-01],
	[2.55550E+04, 1.3886754689E+04, 5.0761182761E+03, 3.4117248168E+03, 1.7789831649E+03, 8.8344777658E-01],
	[2.55600E+04, 1.3891076047E+04, 5.0760394307E+03, 3.4138786031E+03, 1.7796298394E+03, 8.8350520664E-01],
	[2.55650E+04, 1.3895397904E+04, 5.0759606020E+03, 3.4160333260E+03, 1.7802764654E+03, 8.8356260795E-01],
	[2.55700E+04, 1.3899720259E+04, 5.0758817899E+03, 3.4181889858E+03, 1.7809230427E+03, 8.8361998052E-01],
	[2.55750E+04, 1.3904043114E+04, 5.0758029944E+03, 3.4203455827E+03, 1.7815695713E+03, 8.8367732435E-01],
	[2.55800E+04, 1.3908366468E+04, 5.0757242155E+03, 3.4225031171E+03, 1.7822160510E+03, 8.8373463947E-01],
	[2.55850E+04, 1.3912690320E+04, 5.0756454533E+03, 3.4246615890E+03, 1.7828624818E+03, 8.8379192589E-01],
	[2.55900E+04, 1.3917014672E+04, 5.0755667077E+03, 3.4268209987E+03, 1.7835088636E+03, 8.8384918362E-01],
	[2.55950E+04, 1.3921339522E+04, 5.0754879787E+03, 3.4289813465E+03, 1.7841551963E+03, 8.8390641266E-01],
	[2.56000E+04, 1.3925664872E+04, 5.0754092663E+03, 3.4311426325E+03, 1.7848014797E+03, 8.8396361304E-01],
	[2.56050E+04, 1.3929990720E+04, 5.0753305705E+03, 3.4333048570E+03, 1.7854477138E+03, 8.8402078476E-01],
	[2.56100E+04, 1.3934317066E+04, 5.0752518912E+03, 3.4354680202E+03, 1.7860938985E+03, 8.8407792784E-01],
	[2.56150E+04, 1.3938643912E+04, 5.0751732286E+03, 3.4376321223E+03, 1.7867400337E+03, 8.8413504229E-01],
	[2.56200E+04, 1.3942971256E+04, 5.0750945825E+03, 3.4397971636E+03, 1.7873861193E+03, 8.8419212812E-01],
	[2.56250E+04, 1.3947299099E+04, 5.0750159530E+03, 3.4419631443E+03, 1.7880321552E+03, 8.8424918534E-01],
	[2.56300E+04, 1.3951627440E+04, 5.0749373400E+03, 3.4441300645E+03, 1.7886781413E+03, 8.8430621397E-01],
	[2.56350E+04, 1.3955956280E+04, 5.0748587436E+03, 3.4462979246E+03, 1.7893240774E+03, 8.8436321401E-01],
	[2.56400E+04, 1.3960285618E+04, 5.0747801638E+03, 3.4484667247E+03, 1.7899699636E+03, 8.8442018549E-01],
	[2.56450E+04, 1.3964615455E+04, 5.0747016005E+03, 3.4506364651E+03, 1.7906157997E+03, 8.8447712841E-01],
	[2.56500E+04, 1.3968945790E+04, 5.0746230537E+03, 3.4528071460E+03, 1.7912615855E+03, 8.8453404278E-01],
	[2.56550E+04, 1.3973276624E+04, 5.0745445234E+03, 3.4549787676E+03, 1.7919073211E+03, 8.8459092862E-01],
	[2.56600E+04, 1.3977607956E+04, 5.0744660097E+03, 3.4571513301E+03, 1.7925530063E+03, 8.8464778594E-01],
	[2.56650E+04, 1.3981939786E+04, 5.0743875124E+03, 3.4593248338E+03, 1.7931986410E+03, 8.8470461475E-01],
	[2.56700E+04, 1.3986272114E+04, 5.0743090317E+03, 3.4614992789E+03, 1.7938442252E+03, 8.8476141507E-01],
	[2.56750E+04, 1.3990604941E+04, 5.0742305675E+03, 3.4636746656E+03, 1.7944897586E+03, 8.8481818690E-01],
	[2.56800E+04, 1.3994938266E+04, 5.0741521197E+03, 3.4658509941E+03, 1.7951352413E+03, 8.8487493026E-01],
	[2.56850E+04, 1.3999272089E+04, 5.0740736885E+03, 3.4680282647E+03, 1.7957806732E+03, 8.8493164516E-01],
	[2.56900E+04, 1.4003606410E+04, 5.0739952737E+03, 3.4702064775E+03, 1.7964260540E+03, 8.8498833162E-01],
	[2.56950E+04, 1.4007941229E+04, 5.0739168754E+03, 3.4723856329E+03, 1.7970713838E+03, 8.8504498963E-01],
	[2.57000E+04, 1.4012276546E+04, 5.0738384936E+03, 3.4745657310E+03, 1.7977166625E+03, 8.8510161923E-01],
	[2.57050E+04, 1.4016612362E+04, 5.0737601282E+03, 3.4767467720E+03, 1.7983618898E+03, 8.8515822042E-01],
	[2.57100E+04, 1.4020948675E+04, 5.0736817793E+03, 3.4789287562E+03, 1.7990070659E+03, 8.8521479321E-01],
	[2.57150E+04, 1.4025285486E+04, 5.0736034468E+03, 3.4811116838E+03, 1.7996521905E+03, 8.8527133761E-01],
	[2.57200E+04, 1.4029622795E+04, 5.0735251307E+03, 3.4832955550E+03, 1.8002972635E+03, 8.8532785363E-01],
	[2.57250E+04, 1.4033960601E+04, 5.0734468311E+03, 3.4854803701E+03, 1.8009422850E+03, 8.8538434129E-01],
	[2.57300E+04, 1.4038298906E+04, 5.0733685479E+03, 3.4876661292E+03, 1.8015872546E+03, 8.8544080060E-01],
	[2.57350E+04, 1.4042637708E+04, 5.0732902812E+03, 3.4898528326E+03, 1.8022321725E+03, 8.8549723156E-01],
	[2.57400E+04, 1.4046977008E+04, 5.0732120308E+03, 3.4920404805E+03, 1.8028770385E+03, 8.8555363419E-01],
	[2.57450E+04, 1.4051316806E+04, 5.0731337969E+03, 3.4942290732E+03, 1.8035218524E+03, 8.8561000850E-01],
	[2.57500E+04, 1.4055657101E+04, 5.0730555793E+03, 3.4964186108E+03, 1.8041666142E+03, 8.8566635451E-01],
	[2.57550E+04, 1.4059997894E+04, 5.0729773782E+03, 3.4986090936E+03, 1.8048113238E+03, 8.8572267221E-01],
	[2.57600E+04, 1.4064339184E+04, 5.0728991934E+03, 3.5008005218E+03, 1.8054559811E+03, 8.8577896162E-01],
	[2.57650E+04, 1.4068680972E+04, 5.0728210250E+03, 3.5029928957E+03, 1.8061005860E+03, 8.8583522277E-01],
	[2.57700E+04, 1.4073023257E+04, 5.0727428730E+03, 3.5051862154E+03, 1.8067451384E+03, 8.8589145564E-01],
	[2.57750E+04, 1.4077366040E+04, 5.0726647373E+03, 3.5073804811E+03, 1.8073896382E+03, 8.8594766026E-01],
	[2.57800E+04, 1.4081709320E+04, 5.0725866180E+03, 3.5095756932E+03, 1.8080340854E+03, 8.8600383664E-01],
	[2.57850E+04, 1.4086053098E+04, 5.0725085151E+03, 3.5117718518E+03, 1.8086784797E+03, 8.8605998479E-01],
	[2.57900E+04, 1.4090397372E+04, 5.0724304285E+03, 3.5139689572E+03, 1.8093228212E+03, 8.8611610472E-01],
	[2.57950E+04, 1.4094742144E+04, 5.0723523582E+03, 3.5161670095E+03, 1.8099671097E+03, 8.8617219644E-01],
	[2.58000E+04, 1.4099087414E+04, 5.0722743043E+03, 3.5183660090E+03, 1.8106113452E+03, 8.8622825996E-01],
	[2.58050E+04, 1.4103433180E+04, 5.0721962667E+03, 3.5205659559E+03, 1.8112555275E+03, 8.8628429530E-01],
	[2.58100E+04, 1.4107779444E+04, 5.0721182454E+03, 3.5227668505E+03, 1.8118996565E+03, 8.8634030246E-01],
	[2.58150E+04, 1.4112126205E+04, 5.0720402404E+03, 3.5249686930E+03, 1.8125437322E+03, 8.8639628146E-01],
	[2.58200E+04, 1.4116473462E+04, 5.0719622518E+03, 3.5271714835E+03, 1.8131877545E+03, 8.8645223230E-01],
	[2.58250E+04, 1.4120821217E+04, 5.0718842794E+03, 3.5293752224E+03, 1.8138317232E+03, 8.8650815500E-01],
	[2.58300E+04, 1.4125169469E+04, 5.0718063233E+03, 3.5315799098E+03, 1.8144756383E+03, 8.8656404958E-01],
	[2.58350E+04, 1.4129518218E+04, 5.0717283835E+03, 3.5337855459E+03, 1.8151194997E+03, 8.8661991603E-01],
	[2.58400E+04, 1.4133867463E+04, 5.0716504600E+03, 3.5359921310E+03, 1.8157633073E+03, 8.8667575438E-01],
	[2.58450E+04, 1.4138217206E+04, 5.0715725528E+03, 3.5381996654E+03, 1.8164070610E+03, 8.8673156463E-01],
	[2.58500E+04, 1.4142567445E+04, 5.0714946618E+03, 3.5404081492E+03, 1.8170507606E+03, 8.8678734679E-01],
	[2.58550E+04, 1.4146918182E+04, 5.0714167871E+03, 3.5426175826E+03, 1.8176944062E+03, 8.8684310088E-01],
	[2.58600E+04, 1.4151269415E+04, 5.0713389287E+03, 3.5448279659E+03, 1.8183379975E+03, 8.8689882691E-01],
	[2.58650E+04, 1.4155621144E+04, 5.0712610865E+03, 3.5470392993E+03, 1.8189815346E+03, 8.8695452489E-01],
	[2.58700E+04, 1.4159973371E+04, 5.0711832605E+03, 3.5492515831E+03, 1.8196250173E+03, 8.8701019483E-01],
	[2.58750E+04, 1.4164326094E+04, 5.0711054508E+03, 3.5514648174E+03, 1.8202684455E+03, 8.8706583674E-01],
	[2.58800E+04, 1.4168679313E+04, 5.0710276573E+03, 3.5536790025E+03, 1.8209118192E+03, 8.8712145063E-01],
	[2.58850E+04, 1.4173033029E+04, 5.0709498800E+03, 3.5558941385E+03, 1.8215551382E+03, 8.8717703652E-01],
	[2.58900E+04, 1.4177387242E+04, 5.0708721189E+03, 3.5581102258E+03, 1.8221984025E+03, 8.8723259441E-01],
	[2.58950E+04, 1.4181741951E+04, 5.0707943741E+03, 3.5603272646E+03, 1.8228416119E+03, 8.8728812432E-01],
	[2.59000E+04, 1.4186097157E+04, 5.0707166454E+03, 3.5625452550E+03, 1.8234847663E+03, 8.8734362626E-01],
	[2.59050E+04, 1.4190452859E+04, 5.0706389330E+03, 3.5647641973E+03, 1.8241278658E+03, 8.8739910024E-01],
	[2.59100E+04, 1.4194809057E+04, 5.0705612367E+03, 3.5669840917E+03, 1.8247709101E+03, 8.8745454627E-01],
	[2.59150E+04, 1.4199165752E+04, 5.0704835566E+03, 3.5692049385E+03, 1.8254138992E+03, 8.8750996436E-01],
	[2.59200E+04, 1.4203522943E+04, 5.0704058927E+03, 3.5714267378E+03, 1.8260568330E+03, 8.8756535452E-01],
	[2.59250E+04, 1.4207880630E+04, 5.0703282450E+03, 3.5736494899E+03, 1.8266997114E+03, 8.8762071677E-01],
	[2.59300E+04, 1.4212238813E+04, 5.0702506134E+03, 3.5758731951E+03, 1.8273425343E+03, 8.8767605112E-01],
	[2.59350E+04, 1.4216597493E+04, 5.0701729980E+03, 3.5780978534E+03, 1.8279853016E+03, 8.8773135757E-01],
	[2.59400E+04, 1.4220956669E+04, 5.0700953987E+03, 3.5803234653E+03, 1.8286280132E+03, 8.8778663614E-01],
	[2.59450E+04, 1.4225316340E+04, 5.0700178156E+03, 3.5825500308E+03, 1.8292706690E+03, 8.8784188685E-01],
	[2.59500E+04, 1.4229676508E+04, 5.0699402486E+03, 3.5847775502E+03, 1.8299132690E+03, 8.8789710969E-01],
	[2.59550E+04, 1.4234037172E+04, 5.0698626977E+03, 3.5870060238E+03, 1.8305558130E+03, 8.8795230469E-01],
	[2.59600E+04, 1.4238398332E+04, 5.0697851630E+03, 3.5892354517E+03, 1.8311983010E+03, 8.8800747186E-01],
	[2.59650E+04, 1.4242759988E+04, 5.0697076443E+03, 3.5914658342E+03, 1.8318407328E+03, 8.8806261120E-01],
	[2.59700E+04, 1.4247122139E+04, 5.0696301418E+03, 3.5936971715E+03, 1.8324831084E+03, 8.8811772273E-01],
	[2.59750E+04, 1.4251484787E+04, 5.0695526554E+03, 3.5959294638E+03, 1.8331254277E+03, 8.8817280645E-01],
	[2.59800E+04, 1.4255847930E+04, 5.0694751851E+03, 3.5981627114E+03, 1.8337676906E+03, 8.8822786239E-01],
	[2.59850E+04, 1.4260211569E+04, 5.0693977309E+03, 3.6003969145E+03, 1.8344098969E+03, 8.8828289055E-01],
	[2.59900E+04, 1.4264575704E+04, 5.0693202928E+03, 3.6026320732E+03, 1.8350520467E+03, 8.8833789095E-01],
	[2.59950E+04, 1.4268940335E+04, 5.0692428707E+03, 3.6048681879E+03, 1.8356941397E+03, 8.8839286359E-01],
	[2.60000E+04, 1.4273305461E+04, 5.0691654647E+03, 3.6071052587E+03, 1.8363361760E+03, 8.8844780848E-01],
	[2.60050E+04, 1.4277671082E+04, 5.0690880748E+03, 3.6093432859E+03, 1.8369781554E+03, 8.8850272565E-01],
	[2.60100E+04, 1.4282037200E+04, 5.0690107010E+03, 3.6115822697E+03, 1.8376200778E+03, 8.8855761509E-01],
	[2.60150E+04, 1.4286403813E+04, 5.0689333432E+03, 3.6138222104E+03, 1.8382619431E+03, 8.8861247683E-01],
	[2.60200E+04, 1.4290770921E+04, 5.0688560014E+03, 3.6160631080E+03, 1.8389037513E+03, 8.8866731086E-01],
	[2.60250E+04, 1.4295138525E+04, 5.0687786757E+03, 3.6183049630E+03, 1.8395455023E+03, 8.8872211722E-01],
	[2.60300E+04, 1.4299506624E+04, 5.0687013660E+03, 3.6205477754E+03, 1.8401871959E+03, 8.8877689589E-01],
	[2.60350E+04, 1.4303875219E+04, 5.0686240724E+03, 3.6227915455E+03, 1.8408288321E+03, 8.8883164691E-01],
	[2.60400E+04, 1.4308244309E+04, 5.0685467947E+03, 3.6250362736E+03, 1.8414704108E+03, 8.8888637027E-01],
	[2.60450E+04, 1.4312613894E+04, 5.0684695331E+03, 3.6272819599E+03, 1.8421119319E+03, 8.8894106599E-01],
	[2.60500E+04, 1.4316983975E+04, 5.0683922875E+03, 3.6295286045E+03, 1.8427533953E+03, 8.8899573409E-01],
	[2.60550E+04, 1.4321354551E+04, 5.0683150579E+03, 3.6317762077E+03, 1.8433948009E+03, 8.8905037456E-01],
	[2.60600E+04, 1.4325725622E+04, 5.0682378443E+03, 3.6340247698E+03, 1.8440361486E+03, 8.8910498744E-01],
	[2.60650E+04, 1.4330097188E+04, 5.0681606467E+03, 3.6362742910E+03, 1.8446774383E+03, 8.8915957271E-01],
	[2.60700E+04, 1.4334469249E+04, 5.0680834650E+03, 3.6385247714E+03, 1.8453186700E+03, 8.8921413041E-01],
	[2.60750E+04, 1.4338841806E+04, 5.0680062994E+03, 3.6407762114E+03, 1.8459598435E+03, 8.8926866054E-01],
	[2.60800E+04, 1.4343214857E+04, 5.0679291497E+03, 3.6430286110E+03, 1.8466009588E+03, 8.8932316310E-01],
	[2.60850E+04, 1.4347588404E+04, 5.0678520159E+03, 3.6452819707E+03, 1.8472420158E+03, 8.8937763812E-01],
	[2.60900E+04, 1.4351962445E+04, 5.0677748982E+03, 3.6475362905E+03, 1.8478830143E+03, 8.8943208560E-01],
	[2.60950E+04, 1.4356336981E+04, 5.0676977963E+03, 3.6497915707E+03, 1.8485239543E+03, 8.8948650556E-01],
	[2.61000E+04, 1.4360712012E+04, 5.0676207105E+03, 3.6520478115E+03, 1.8491648358E+03, 8.8954089801E-01],
	[2.61050E+04, 1.4365087538E+04, 5.0675436405E+03, 3.6543050132E+03, 1.8498056585E+03, 8.8959526295E-01],
	[2.61100E+04, 1.4369489458E+04, 5.0674726527E+03, 3.6565631760E+03, 1.8504476608E+03, 8.8964960041E-01],
	[2.61150E+04, 1.4373911482E+04, 5.0674062687E+03, 3.6588223001E+03, 1.8510905429E+03, 8.8970391038E-01],
	[2.61200E+04, 1.4378334020E+04, 5.0673398982E+03, 3.6610823857E+03, 1.8517333682E+03, 8.8975819290E-01],
	[2.61250E+04, 1.4382757073E+04, 5.0672735414E+03, 3.6633434331E+03, 1.8523761367E+03, 8.8981244795E-01],
	[2.61300E+04, 1.4387180638E+04, 5.0672071981E+03, 3.6656054424E+03, 1.8530188482E+03, 8.8986667556E-01],
	[2.61350E+04, 1.4391604718E+04, 5.0671408684E+03, 3.6678684140E+03, 1.8536615026E+03, 8.8992087575E-01],
	[2.61400E+04, 1.4396029311E+04, 5.0670745522E+03, 3.6701323479E+03, 1.8543040999E+03, 8.8997504851E-01],
	[2.61450E+04, 1.4400454418E+04, 5.0670082496E+03, 3.6723972445E+03, 1.8549466399E+03, 8.9002919386E-01],
	[2.61500E+04, 1.4404880039E+04, 5.0669419605E+03, 3.6746631040E+03, 1.8555891227E+03, 8.9008331182E-01],
	[2.61550E+04, 1.4409306173E+04, 5.0668756849E+03, 3.6769299266E+03, 1.8562315480E+03, 8.9013740239E-01],
	[2.61600E+04, 1.4413732821E+04, 5.0668094229E+03, 3.6791977125E+03, 1.8568739158E+03, 8.9019146559E-01],
	[2.61650E+04, 1.4418159982E+04, 5.0667431745E+03, 3.6814664619E+03, 1.8575162261E+03, 8.9024550142E-01],
	[2.61700E+04, 1.4422587657E+04, 5.0666769395E+03, 3.6837361751E+03, 1.8581584786E+03, 8.9029950991E-01],
	[2.61750E+04, 1.4427015845E+04, 5.0666107181E+03, 3.6860068524E+03, 1.8588006734E+03, 8.9035349106E-01],
	[2.61800E+04, 1.4431444547E+04, 5.0665445102E+03, 3.6882784938E+03, 1.8594428104E+03, 8.9040744488E-01],
	[2.61850E+04, 1.4435873762E+04, 5.0664783158E+03, 3.6905510996E+03, 1.8600848893E+03, 8.9046137138E-01],
	[2.61900E+04, 1.4440303490E+04, 5.0664121349E+03, 3.6928246702E+03, 1.8607269103E+03, 8.9051527058E-01],
	[2.61950E+04, 1.4444733732E+04, 5.0663459674E+03, 3.6950992056E+03, 1.8613688731E+03, 8.9056914250E-01],
	[2.62000E+04, 1.4449164487E+04, 5.0662798135E+03, 3.6973747061E+03, 1.8620107777E+03, 8.9062298713E-01],
	[2.62050E+04, 1.4453595755E+04, 5.0662136731E+03, 3.6996511720E+03, 1.8626526241E+03, 8.9067680449E-01],
	[2.62100E+04, 1.4458027536E+04, 5.0661475462E+03, 3.7019286035E+03, 1.8632944120E+03, 8.9073059459E-01],
	[2.62150E+04, 1.4462459830E+04, 5.0660814327E+03, 3.7042070007E+03, 1.8639361414E+03, 8.9078435745E-01],
	[2.62200E+04, 1.4466892638E+04, 5.0660153327E+03, 3.7064863639E+03, 1.8645778123E+03, 8.9083809308E-01],
	[2.62250E+04, 1.4471325958E+04, 5.0659492462E+03, 3.7087666934E+03, 1.8652194246E+03, 8.9089180149E-01],
	[2.62300E+04, 1.4475759792E+04, 5.0658831731E+03, 3.7110479893E+03, 1.8658609780E+03, 8.9094548268E-01],
	[2.62350E+04, 1.4480194138E+04, 5.0658171135E+03, 3.7133302520E+03, 1.8665024727E+03, 8.9099913668E-01],
	[2.62400E+04, 1.4484628998E+04, 5.0657510673E+03, 3.7156134815E+03, 1.8671439084E+03, 8.9105276349E-01],
	[2.62450E+04, 1.4489064370E+04, 5.0656850346E+03, 3.7178976782E+03, 1.8677852852E+03, 8.9110636313E-01],
	[2.62500E+04, 1.4493500255E+04, 5.0656190153E+03, 3.7201828422E+03, 1.8684266028E+03, 8.9115993560E-01],
	[2.62550E+04, 1.4497936653E+04, 5.0655530095E+03, 3.7224689738E+03, 1.8690678612E+03, 8.9121348093E-01],
	[2.62600E+04, 1.4502373564E+04, 5.0654870170E+03, 3.7247560733E+03, 1.8697090604E+03, 8.9126699911E-01],
	[2.62650E+04, 1.4506810988E+04, 5.0654210381E+03, 3.7270441407E+03, 1.8703502002E+03, 8.9132049017E-01],
	[2.62700E+04, 1.4511248924E+04, 5.0653550725E+03, 3.7293331764E+03, 1.8709912806E+03, 8.9137395410E-01],
	[2.62750E+04, 1.4515687373E+04, 5.0652891203E+03, 3.7316231806E+03, 1.8716323015E+03, 8.9142739094E-01],
	[2.62800E+04, 1.4520126335E+04, 5.0652231816E+03, 3.7339141535E+03, 1.8722732627E+03, 8.9148080068E-01],
	[2.62850E+04, 1.4524565809E+04, 5.0651572562E+03, 3.7362060953E+03, 1.8729141642E+03, 8.9153418334E-01],
	[2.62900E+04, 1.4529005796E+04, 5.0650913442E+03, 3.7384990063E+03, 1.8735550059E+03, 8.9158753894E-01],
	[2.62950E+04, 1.4533446295E+04, 5.0650254457E+03, 3.7407928867E+03, 1.8741957877E+03, 8.9164086747E-01],
	[2.63000E+04, 1.4537887307E+04, 5.0649595605E+03, 3.7430877367E+03, 1.8748365096E+03, 8.9169416896E-01],
	[2.63050E+04, 1.4542328831E+04, 5.0648936887E+03, 3.7453835565E+03, 1.8754771714E+03, 8.9174744342E-01],
	[2.63100E+04, 1.4546770868E+04, 5.0648278303E+03, 3.7476803463E+03, 1.8761177730E+03, 8.9180069085E-01],
	[2.63150E+04, 1.4551213417E+04, 5.0647619852E+03, 3.7499781064E+03, 1.8767583145E+03, 8.9185391128E-01],
	[2.63200E+04, 1.4555656478E+04, 5.0646961535E+03, 3.7522768371E+03, 1.8773987955E+03, 8.9190710471E-01],
	[2.63250E+04, 1.4560100051E+04, 5.0646303352E+03, 3.7545765384E+03, 1.8780392162E+03, 8.9196027115E-01],
	[2.63300E+04, 1.4564544137E+04, 5.0645645302E+03, 3.7568772107E+03, 1.8786795764E+03, 8.9201341061E-01],
	[2.63350E+04, 1.4568988735E+04, 5.0644987386E+03, 3.7591788542E+03, 1.8793198761E+03, 8.9206652311E-01],
	[2.63400E+04, 1.4573433846E+04, 5.0644329604E+03, 3.7614814691E+03, 1.8799601150E+03, 8.9211960866E-01],
	[2.63450E+04, 1.4577879468E+04, 5.0643671954E+03, 3.7637850556E+03, 1.8806002932E+03, 8.9217266727E-01],
	[2.63500E+04, 1.4582325602E+04, 5.0643014438E+03, 3.7660896140E+03, 1.8812404106E+03, 8.9222569896E-01],
	[2.63550E+04, 1.4586772249E+04, 5.0642357055E+03, 3.7683951444E+03, 1.8818804670E+03, 8.9227870373E-01],
	[2.63600E+04, 1.4591219407E+04, 5.0641699806E+03, 3.7707016471E+03, 1.8825204624E+03, 8.9233168159E-01],
	[2.63650E+04, 1.4595667078E+04, 5.0641042690E+03, 3.7730091224E+03, 1.8831603967E+03, 8.9238463256E-01],
	[2.63700E+04, 1.4600115260E+04, 5.0640385706E+03, 3.7753175704E+03, 1.8838002699E+03, 8.9243755666E-01],
	[2.63750E+04, 1.4604563955E+04, 5.0639728856E+03, 3.7776269914E+03, 1.8844400817E+03, 8.9249045388E-01],
	[2.63800E+04, 1.4609013161E+04, 5.0639072139E+03, 3.7799373856E+03, 1.8850798322E+03, 8.9254332425E-01],
	[2.63850E+04, 1.4613462879E+04, 5.0638415555E+03, 3.7822487531E+03, 1.8857195213E+03, 8.9259616777E-01],
	[2.63900E+04, 1.4617913109E+04, 5.0637759104E+03, 3.7845610944E+03, 1.8863591488E+03, 8.9264898446E-01],
	[2.63950E+04, 1.4622363851E+04, 5.0637102786E+03, 3.7868744095E+03, 1.8869987147E+03, 8.9270177433E-01],
	[2.64000E+04, 1.4626815104E+04, 5.0636446600E+03, 3.7891886987E+03, 1.8876382189E+03, 8.9275453739E-01],
	[2.64050E+04, 1.4631266869E+04, 5.0635790547E+03, 3.7915039623E+03, 1.8882776613E+03, 8.9280727365E-01],
	[2.64100E+04, 1.4635719146E+04, 5.0635134627E+03, 3.7938202003E+03, 1.8889170419E+03, 8.9285998313E-01],
	[2.64150E+04, 1.4640171934E+04, 5.0634478840E+03, 3.7961374132E+03, 1.8895563605E+03, 8.9291266583E-01],
	[2.64200E+04, 1.4644625234E+04, 5.0633823185E+03, 3.7984556010E+03, 1.8901956170E+03, 8.9296532177E-01],
	[2.64250E+04, 1.4649079045E+04, 5.0633167663E+03, 3.8007747641E+03, 1.8908348114E+03, 8.9301795096E-01],
	[2.64300E+04, 1.4653533368E+04, 5.0632512273E+03, 3.8030949026E+03, 1.8914739436E+03, 8.9307055342E-01],
	[2.64350E+04, 1.4657988202E+04, 5.0631857016E+03, 3.8054160168E+03, 1.8921130135E+03, 8.9312312914E-01],
	[2.64400E+04, 1.4662443548E+04, 5.0631201891E+03, 3.8077381069E+03, 1.8927520210E+03, 8.9317567816E-01],
	[2.64450E+04, 1.4666899405E+04, 5.0630546899E+03, 3.8100611730E+03, 1.8933909661E+03, 8.9322820047E-01],
	[2.64500E+04, 1.4671355774E+04, 5.0629892039E+03, 3.8123852156E+03, 1.8940298485E+03, 8.9328069609E-01],
	[2.64550E+04, 1.4675812653E+04, 5.0629237311E+03, 3.8147102347E+03, 1.8946686684E+03, 8.9333316503E-01],
	[2.64600E+04, 1.4680270044E+04, 5.0628582715E+03, 3.8170362306E+03, 1.8953074255E+03, 8.9338560731E-01],
	[2.64650E+04, 1.4684727947E+04, 5.0627928252E+03, 3.8193632035E+03, 1.8959461198E+03, 8.9343802293E-01],
	[2.64700E+04, 1.4689186360E+04, 5.0627273920E+03, 3.8216911537E+03, 1.8965847512E+03, 8.9349041190E-01],
	[2.64750E+04, 1.4693645284E+04, 5.0626619721E+03, 3.8240200813E+03, 1.8972233196E+03, 8.9354277425E-01],
	[2.64800E+04, 1.4698104720E+04, 5.0625965653E+03, 3.8263499866E+03, 1.8978618250E+03, 8.9359510998E-01],
	[2.64850E+04, 1.4702564667E+04, 5.0625311718E+03, 3.8286808698E+03, 1.8985002672E+03, 8.9364741910E-01],
	[2.64900E+04, 1.4707025125E+04, 5.0624657914E+03, 3.8310127312E+03, 1.8991386462E+03, 8.9369970162E-01],
	[2.64950E+04, 1.4711486093E+04, 5.0624004242E+03, 3.8333455710E+03, 1.8997769618E+03, 8.9375195756E-01],
	[2.65000E+04, 1.4715947573E+04, 5.0623350702E+03, 3.8356793893E+03, 1.9004152141E+03, 8.9380418693E-01],
	[2.65050E+04, 1.4720409564E+04, 5.0622697294E+03, 3.8380141865E+03, 1.9010534029E+03, 8.9385638974E-01],
	[2.65100E+04, 1.4724872065E+04, 5.0622044018E+03, 3.8403499627E+03, 1.9016915280E+03, 8.9390856600E-01],
	[2.65150E+04, 1.4729335077E+04, 5.0621390873E+03, 3.8426867181E+03, 1.9023295896E+03, 8.9396071573E-01],
	[2.65200E+04, 1.4733798601E+04, 5.0620737859E+03, 3.8450244531E+03, 1.9029675874E+03, 8.9401283893E-01],
	[2.65250E+04, 1.4738262634E+04, 5.0620084977E+03, 3.8473631678E+03, 1.9036055213E+03, 8.9406493562E-01],
	[2.65300E+04, 1.4742727179E+04, 5.0619432227E+03, 3.8497028624E+03, 1.9042433914E+03, 8.9411700582E-01],
	[2.65350E+04, 1.4747192234E+04, 5.0618779608E+03, 3.8520435372E+03, 1.9048811975E+03, 8.9416904952E-01],
	[2.65400E+04, 1.4751657800E+04, 5.0618127120E+03, 3.8543851923E+03, 1.9055189395E+03, 8.9422106675E-01],
	[2.65450E+04, 1.4756123877E+04, 5.0617474764E+03, 3.8567278281E+03, 1.9061566173E+03, 8.9427305751E-01],
	[2.65500E+04, 1.4760590464E+04, 5.0616822539E+03, 3.8590714448E+03, 1.9067942309E+03, 8.9432502182E-01],
	[2.65550E+04, 1.4765057562E+04, 5.0616170445E+03, 3.8614160425E+03, 1.9074317802E+03, 8.9437695969E-01],
	[2.65600E+04, 1.4769525170E+04, 5.0615518483E+03, 3.8637616215E+03, 1.9080692650E+03, 8.9442887113E-01],
	[2.65650E+04, 1.4773993289E+04, 5.0614866651E+03, 3.8661081820E+03, 1.9087066854E+03, 8.9448075616E-01],
	[2.65700E+04, 1.4778461918E+04, 5.0614214951E+03, 3.8684557242E+03, 1.9093440411E+03, 8.9453261478E-01],
	[2.65750E+04, 1.4782931057E+04, 5.0613563382E+03, 3.8708042484E+03, 1.9099813323E+03, 8.9458444701E-01],
	[2.65800E+04, 1.4787400707E+04, 5.0612911943E+03, 3.8731537548E+03, 1.9106185586E+03, 8.9463625286E-01],
	[2.65850E+04, 1.4791870868E+04, 5.0612260636E+03, 3.8755042437E+03, 1.9112557202E+03, 8.9468803234E-01],
	[2.65900E+04, 1.4796341538E+04, 5.0611609459E+03, 3.8778557151E+03, 1.9118928168E+03, 8.9473978547E-01],
	[2.65950E+04, 1.4800812719E+04, 5.0610958413E+03, 3.8802081695E+03, 1.9125298485E+03, 8.9479151225E-01],
	[2.66000E+04, 1.4805284410E+04, 5.0610307498E+03, 3.8825616069E+03, 1.9131668150E+03, 8.9484321270E-01],
	[2.66050E+04, 1.4809756611E+04, 5.0609656714E+03, 3.8849160276E+03, 1.9138037164E+03, 8.9489488682E-01],
	[2.66100E+04, 1.4814229322E+04, 5.0609006060E+03, 3.8872714319E+03, 1.9144405526E+03, 8.9494653464E-01],
	[2.66150E+04, 1.4818702543E+04, 5.0608355537E+03, 3.8896278200E+03, 1.9150773234E+03, 8.9499815616E-01],
	[2.66200E+04, 1.4823176274E+04, 5.0607705144E+03, 3.8919851920E+03, 1.9157140289E+03, 8.9504975140E-01],
	[2.66250E+04, 1.4827650516E+04, 5.0607054882E+03, 3.8943435483E+03, 1.9163506688E+03, 8.9510132036E-01],
	[2.66300E+04, 1.4832125267E+04, 5.0606404751E+03, 3.8967028890E+03, 1.9169872432E+03, 8.9515286307E-01],
	[2.66350E+04, 1.4836600528E+04, 5.0605754749E+03, 3.8990632143E+03, 1.9176237519E+03, 8.9520437952E-01],
	[2.66400E+04, 1.4841076299E+04, 5.0605104879E+03, 3.9014245246E+03, 1.9182601949E+03, 8.9525586974E-01],
	[2.66450E+04, 1.4845552580E+04, 5.0604455138E+03, 3.9037868200E+03, 1.9188965720E+03, 8.9530733374E-01],
	[2.66500E+04, 1.4850029371E+04, 5.0603805528E+03, 3.9061501007E+03, 1.9195328833E+03, 8.9535877152E-01],
	[2.66550E+04, 1.4854506672E+04, 5.0603156048E+03, 3.9085143670E+03, 1.9201691286E+03, 8.9541018310E-01],
	[2.66600E+04, 1.4858984482E+04, 5.0602506698E+03, 3.9108796190E+03, 1.9208053078E+03, 8.9546156849E-01],
	[2.66650E+04, 1.4863462802E+04, 5.0601857478E+03, 3.9132458571E+03, 1.9214414208E+03, 8.9551292771E-01],
	[2.66700E+04, 1.4867941632E+04, 5.0601208388E+03, 3.9156130815E+03, 1.9220774677E+03, 8.9556426076E-01],
	[2.66750E+04, 1.4872420971E+04, 5.0600559429E+03, 3.9179812923E+03, 1.9227134482E+03, 8.9561556766E-01],
	[2.66800E+04, 1.4876900820E+04, 5.0599910599E+03, 3.9203504898E+03, 1.9233493623E+03, 8.9566684842E-01],
	[2.66850E+04, 1.4881381179E+04, 5.0599261899E+03, 3.9227206742E+03, 1.9239852099E+03, 8.9571810305E-01],
	[2.66900E+04, 1.4885862047E+04, 5.0598613329E+03, 3.9250918458E+03, 1.9246209910E+03, 8.9576933156E-01],
	[2.66950E+04, 1.4890343424E+04, 5.0597964888E+03, 3.9274640047E+03, 1.9252567055E+03, 8.9582053396E-01],
	[2.67000E+04, 1.4894825311E+04, 5.0597316578E+03, 3.9298371513E+03, 1.9258923532E+03, 8.9587171026E-01],
	[2.67050E+04, 1.4899307708E+04, 5.0596668397E+03, 3.9322112856E+03, 1.9265279342E+03, 8.9592286048E-01],
	[2.67100E+04, 1.4903790614E+04, 5.0596020346E+03, 3.9345864080E+03, 1.9271634482E+03, 8.9597398463E-01],
	[2.67150E+04, 1.4908274029E+04, 5.0595372424E+03, 3.9369625187E+03, 1.9277988953E+03, 8.9602508271E-01],
	[2.67200E+04, 1.4912757953E+04, 5.0594724632E+03, 3.9393396179E+03, 1.9284342753E+03, 8.9607615473E-01],
	[2.67250E+04, 1.4917242387E+04, 5.0594076970E+03, 3.9417177057E+03, 1.9290695882E+03, 8.9612720072E-01],
	[2.67300E+04, 1.4921727330E+04, 5.0593429437E+03, 3.9440967826E+03, 1.9297048339E+03, 8.9617822067E-01],
	[2.67350E+04, 1.4926212782E+04, 5.0592782033E+03, 3.9464768486E+03, 1.9303400123E+03, 8.9622921460E-01],
	[2.67400E+04, 1.4930698743E+04, 5.0592134759E+03, 3.9488579040E+03, 1.9309751234E+03, 8.9628018253E-01],
	[2.67450E+04, 1.4935185213E+04, 5.0591487614E+03, 3.9512399490E+03, 1.9316101670E+03, 8.9633112446E-01],
	[2.67500E+04, 1.4939672193E+04, 5.0590840598E+03, 3.9536229839E+03, 1.9322451430E+03, 8.9638204040E-01],
	[2.67550E+04, 1.4944159681E+04, 5.0590193712E+03, 3.9560070088E+03, 1.9328800515E+03, 8.9643293036E-01],
	[2.67600E+04, 1.4948647679E+04, 5.0589546954E+03, 3.9583920241E+03, 1.9335148922E+03, 8.9648379436E-01],
	[2.67650E+04, 1.4953136185E+04, 5.0588900326E+03, 3.9607780298E+03, 1.9341496652E+03, 8.9653463241E-01],
	[2.67700E+04, 1.4957625200E+04, 5.0588253827E+03, 3.9631650263E+03, 1.9347843704E+03, 8.9658544451E-01],
	[2.67750E+04, 1.4962114725E+04, 5.0587607456E+03, 3.9655530138E+03, 1.9354190076E+03, 8.9663623068E-01],
	[2.67800E+04, 1.4966604758E+04, 5.0586961215E+03, 3.9679419925E+03, 1.9360535767E+03, 8.9668699093E-01],
	[2.67850E+04, 1.4971095300E+04, 5.0586315103E+03, 3.9703319626E+03, 1.9366880778E+03, 8.9673772527E-01],
	[2.67900E+04, 1.4975586350E+04, 5.0585669119E+03, 3.9727229244E+03, 1.9373225107E+03, 8.9678843372E-01],
	[2.67950E+04, 1.4980077910E+04, 5.0585023264E+03, 3.9751148780E+03, 1.9379568754E+03, 8.9683911627E-01],
	[2.68000E+04, 1.4984569978E+04, 5.0584377538E+03, 3.9775078238E+03, 1.9385911717E+03, 8.9688977295E-01],
	[2.68050E+04, 1.4989062555E+04, 5.0583731941E+03, 3.9799017618E+03, 1.9392253996E+03, 8.9694040377E-01],
	[2.68100E+04, 1.4993555640E+04, 5.0583086472E+03, 3.9822966924E+03, 1.9398595590E+03, 8.9699100873E-01],
	[2.68150E+04, 1.4998049234E+04, 5.0582441132E+03, 3.9846926158E+03, 1.9404936499E+03, 8.9704158785E-01],
	[2.68200E+04, 1.5002543336E+04, 5.0581795921E+03, 3.9870895322E+03, 1.9411276721E+03, 8.9709214113E-01],
	[2.68250E+04, 1.5007037947E+04, 5.0581150838E+03, 3.9894874419E+03, 1.9417616255E+03, 8.9714266860E-01],
	[2.68300E+04, 1.5011533067E+04, 5.0580505883E+03, 3.9918863449E+03, 1.9423955101E+03, 8.9719317026E-01],
	[2.68350E+04, 1.5016028695E+04, 5.0579861057E+03, 3.9942862417E+03, 1.9430293259E+03, 8.9724364611E-01],
	[2.68400E+04, 1.5020524831E+04, 5.0579216359E+03, 3.9966871324E+03, 1.9436630726E+03, 8.9729409618E-01],
	[2.68450E+04, 1.5025021476E+04, 5.0578571790E+03, 3.9990890172E+03, 1.9442967504E+03, 8.9734452048E-01],
	[2.68500E+04, 1.5029518629E+04, 5.0577927348E+03, 4.0014918963E+03, 1.9449303589E+03, 8.9739491901E-01],
	[2.68550E+04, 1.5034016290E+04, 5.0577283035E+03, 4.0038957700E+03, 1.9455638983E+03, 8.9744529178E-01],
	[2.68600E+04, 1.5038514460E+04, 5.0576638850E+03, 4.0063006386E+03, 1.9461973684E+03, 8.9749563882E-01],
	[2.68650E+04, 1.5043013138E+04, 5.0575994794E+03, 4.0087065022E+03, 1.9468307691E+03, 8.9754596012E-01],
	[2.68700E+04, 1.5047512324E+04, 5.0575350865E+03, 4.0111133610E+03, 1.9474641004E+03, 8.9759625570E-01],
	[2.68750E+04, 1.5052012018E+04, 5.0574707064E+03, 4.0135212153E+03, 1.9480973621E+03, 8.9764652557E-01],
	[2.68800E+04, 1.5056512220E+04, 5.0574063391E+03, 4.0159300653E+03, 1.9487305542E+03, 8.9769676974E-01],
	[2.68850E+04, 1.5061012930E+04, 5.0573419847E+03, 4.0183399113E+03, 1.9493636767E+03, 8.9774698823E-01],
	[2.68900E+04, 1.5065514149E+04, 5.0572776430E+03, 4.0207507534E+03, 1.9499967294E+03, 8.9779718104E-01],
	[2.68950E+04, 1.5070015875E+04, 5.0572133140E+03, 4.0231625919E+03, 1.9506297122E+03, 8.9784734818E-01],
	[2.69000E+04, 1.5074518109E+04, 5.0571489979E+03, 4.0255754270E+03, 1.9512626251E+03, 8.9789748968E-01],
	[2.69050E+04, 1.5079020852E+04, 5.0570846945E+03, 4.0279892590E+03, 1.9518954680E+03, 8.9794760553E-01],
	[2.69100E+04, 1.5083524102E+04, 5.0570204039E+03, 4.0304040880E+03, 1.9525282409E+03, 8.9799769574E-01],
	[2.69150E+04, 1.5088027860E+04, 5.0569561261E+03, 4.0328199143E+03, 1.9531609436E+03, 8.9804776034E-01],
	[2.69200E+04, 1.5092532125E+04, 5.0568918610E+03, 4.0352367381E+03, 1.9537935760E+03, 8.9809779933E-01],
	[2.69250E+04, 1.5097036899E+04, 5.0568276087E+03, 4.0376545596E+03, 1.9544261382E+03, 8.9814781273E-01],
	[2.69300E+04, 1.5101542180E+04, 5.0567633691E+03, 4.0400733792E+03, 1.9550586299E+03, 8.9819780053E-01],
	[2.69350E+04, 1.5106047969E+04, 5.0566991422E+03, 4.0424931969E+03, 1.9556910512E+03, 8.9824776276E-01],
	[2.69400E+04, 1.5110554266E+04, 5.0566349281E+03, 4.0449140130E+03, 1.9563234019E+03, 8.9829769943E-01],
	[2.69450E+04, 1.5115061070E+04, 5.0565707268E+03, 4.0473358278E+03, 1.9569556820E+03, 8.9834761055E-01],
	[2.69500E+04, 1.5119568382E+04, 5.0565065381E+03, 4.0497586414E+03, 1.9575878914E+03, 8.9839749612E-01],
	[2.69550E+04, 1.5124076201E+04, 5.0564423622E+03, 4.0521824541E+03, 1.9582200300E+03, 8.9844735616E-01],
	[2.69600E+04, 1.5128584528E+04, 5.0563781990E+03, 4.0546072662E+03, 1.9588520978E+03, 8.9849719069E-01],
	[2.69650E+04, 1.5133093362E+04, 5.0563140485E+03, 4.0570330778E+03, 1.9594840946E+03, 8.9854699970E-01],
	[2.69700E+04, 1.5137602704E+04, 5.0562499107E+03, 4.0594598891E+03, 1.9601160204E+03, 8.9859678322E-01],
	[2.69750E+04, 1.5142112553E+04, 5.0561857856E+03, 4.0618877005E+03, 1.9607478751E+03, 8.9864654126E-01],
	[2.69800E+04, 1.5146622910E+04, 5.0561216732E+03, 4.0643165120E+03, 1.9613796587E+03, 8.9869627382E-01],
	[2.69850E+04, 1.5151133774E+04, 5.0560575735E+03, 4.0667463241E+03, 1.9620113710E+03, 8.9874598092E-01],
	[2.69900E+04, 1.5155645145E+04, 5.0559934865E+03, 4.0691771368E+03, 1.9626430120E+03, 8.9879566256E-01],
	[2.69950E+04, 1.5160157023E+04, 5.0559294122E+03, 4.0716089504E+03, 1.9632745815E+03, 8.9884531877E-01],
	[2.70000E+04, 1.5164669409E+04, 5.0558653505E+03, 4.0740417651E+03, 1.9639060796E+03, 8.9889494955E-01],
	[2.70050E+04, 1.5169182301E+04, 5.0558013016E+03, 4.0764755812E+03, 1.9645375062E+03, 8.9894455491E-01],
	[2.70100E+04, 1.5173695701E+04, 5.0557372653E+03, 4.0789103988E+03, 1.9651688611E+03, 8.9899413486E-01],
	[2.70150E+04, 1.5178209608E+04, 5.0556732416E+03, 4.0813462183E+03, 1.9658001443E+03, 8.9904368942E-01],
	[2.70200E+04, 1.5182724023E+04, 5.0556092306E+03, 4.0837830398E+03, 1.9664313557E+03, 8.9909321859E-01],
	[2.70250E+04, 1.5187238944E+04, 5.0555452323E+03, 4.0862208635E+03, 1.9670624952E+03, 8.9914272239E-01],
	[2.70300E+04, 1.5191754372E+04, 5.0554812466E+03, 4.0886596897E+03, 1.9676935629E+03, 8.9919220083E-01],
	[2.70350E+04, 1.5196270307E+04, 5.0554172736E+03, 4.0910995186E+03, 1.9683245584E+03, 8.9924165392E-01],
	[2.70400E+04, 1.5200786749E+04, 5.0553533132E+03, 4.0935403505E+03, 1.9689554819E+03, 8.9929108167E-01],
	[2.70450E+04, 1.5205303698E+04, 5.0552893655E+03, 4.0959821855E+03, 1.9695863333E+03, 8.9934048410E-01],
	[2.70500E+04, 1.5209821154E+04, 5.0552254303E+03, 4.0984250239E+03, 1.9702171124E+03, 8.9938986120E-01],
	[2.70550E+04, 1.5214339116E+04, 5.0551615078E+03, 4.1008688659E+03, 1.9708478191E+03, 8.9943921301E-01],
	[2.70600E+04, 1.5218857585E+04, 5.0550975980E+03, 4.1033137117E+03, 1.9714784535E+03, 8.9948853952E-01],
	[2.70650E+04, 1.5223376562E+04, 5.0550337007E+03, 4.1057595616E+03, 1.9721090154E+03, 8.9953784074E-01],
	[2.70700E+04, 1.5227896044E+04, 5.0549698160E+03, 4.1082064158E+03, 1.9727395047E+03, 8.9958711670E-01],
	[2.70750E+04, 1.5232416034E+04, 5.0549059440E+03, 4.1106542745E+03, 1.9733699214E+03, 8.9963636739E-01],
	[2.70800E+04, 1.5236936530E+04, 5.0548420845E+03, 4.1131031379E+03, 1.9740002654E+03, 8.9968559284E-01],
	[2.70850E+04, 1.5241457532E+04, 5.0547782377E+03, 4.1155530063E+03, 1.9746305367E+03, 8.9973479305E-01],
	[2.70900E+04, 1.5245979042E+04, 5.0547144034E+03, 4.1180038799E+03, 1.9752607350E+03, 8.9978396804E-01],
	[2.70950E+04, 1.5250501057E+04, 5.0546505818E+03, 4.1204557589E+03, 1.9758908605E+03, 8.9983311781E-01],
	[2.71000E+04, 1.5255023580E+04, 5.0545867727E+03, 4.1229086435E+03, 1.9765209129E+03, 8.9988224237E-01],
	[2.71050E+04, 1.5259546608E+04, 5.0545229762E+03, 4.1253625340E+03, 1.9771508923E+03, 8.9993134175E-01],
	[2.71100E+04, 1.5264070143E+04, 5.0544591922E+03, 4.1278174306E+03, 1.9777807985E+03, 8.9998041595E-01],
	[2.71150E+04, 1.5268594185E+04, 5.0543954208E+03, 4.1302733335E+03, 1.9784106314E+03, 9.0002946497E-01],
	[2.71200E+04, 1.5273118732E+04, 5.0543316620E+03, 4.1327302430E+03, 1.9790403911E+03, 9.0007848884E-01],
	[2.71250E+04, 1.5277643786E+04, 5.0542679158E+03, 4.1351881592E+03, 1.9796700773E+03, 9.0012748756E-01],
	[2.71300E+04, 1.5282169347E+04, 5.0542041821E+03, 4.1376470825E+03, 1.9802996902E+03, 9.0017646115E-01],
	[2.71350E+04, 1.5286695413E+04, 5.0541404609E+03, 4.1401070129E+03, 1.9809292294E+03, 9.0022540961E-01],
	[2.71400E+04, 1.5291221986E+04, 5.0540767523E+03, 4.1425679508E+03, 1.9815586951E+03, 9.0027433296E-01],
	[2.71450E+04, 1.5295749065E+04, 5.0540130562E+03, 4.1450298964E+03, 1.9821880871E+03, 9.0032323121E-01],
	[2.71500E+04, 1.5300290238E+04, 5.0539524256E+03, 4.1474928499E+03, 1.9828181034E+03, 9.0037210438E-01],
	[2.71550E+04, 1.5304863442E+04, 5.0538988861E+03, 4.1499568115E+03, 1.9834496663E+03, 9.0042095246E-01],
	[2.71600E+04, 1.5309437171E+04, 5.0538453570E+03, 4.1524217815E+03, 1.9840811574E+03, 9.0046977547E-01],
	[2.71650E+04, 1.5314011425E+04, 5.0537918383E+03, 4.1548877600E+03, 1.9847125766E+03, 9.0051857343E-01],
	[2.71700E+04, 1.5318586203E+04, 5.0537383300E+03, 4.1573547474E+03, 1.9853439238E+03, 9.0056734635E-01],
	[2.71750E+04, 1.5323161505E+04, 5.0536848321E+03, 4.1598227438E+03, 1.9859751990E+03, 9.0061609423E-01],
	[2.71800E+04, 1.5327737332E+04, 5.0536313447E+03, 4.1622917494E+03, 1.9866064022E+03, 9.0066481710E-01],
	[2.71850E+04, 1.5332313684E+04, 5.0535778676E+03, 4.1647617645E+03, 1.9872375331E+03, 9.0071351495E-01],
	[2.71900E+04, 1.5336890559E+04, 5.0535244010E+03, 4.1672327894E+03, 1.9878685918E+03, 9.0076218780E-01],
	[2.71950E+04, 1.5341467959E+04, 5.0534709447E+03, 4.1697048242E+03, 1.9884995781E+03, 9.0081083567E-01],
	[2.72000E+04, 1.5346045883E+04, 5.0534174989E+03, 4.1721778691E+03, 1.9891304921E+03, 9.0085945856E-01],
	[2.72050E+04, 1.5350624331E+04, 5.0533640634E+03, 4.1746519244E+03, 1.9897613336E+03, 9.0090805649E-01],
	[2.72100E+04, 1.5355203304E+04, 5.0533106383E+03, 4.1771269903E+03, 1.9903921025E+03, 9.0095662946E-01],
	[2.72150E+04, 1.5359782801E+04, 5.0532572236E+03, 4.1796030671E+03, 1.9910227988E+03, 9.0100517749E-01],
	[2.72200E+04, 1.5364362822E+04, 5.0532038193E+03, 4.1820801550E+03, 1.9916534224E+03, 9.0105370059E-01],
	[2.72250E+04, 1.5368943367E+04, 5.0531504254E+03, 4.1845582541E+03, 1.9922839733E+03, 9.0110219878E-01],
	[2.72300E+04, 1.5373524436E+04, 5.0530970418E+03, 4.1870373648E+03, 1.9929144512E+03, 9.0115067205E-01],
	[2.72350E+04, 1.5378106029E+04, 5.0530436686E+03, 4.1895174872E+03, 1.9935448563E+03, 9.0119912043E-01],
	[2.72400E+04, 1.5382688146E+04, 5.0529903057E+03, 4.1919986215E+03, 1.9941751884E+03, 9.0124754393E-01],
	[2.72450E+04, 1.5387270787E+04, 5.0529369532E+03, 4.1944807681E+03, 1.9948054474E+03, 9.0129594255E-01],
	[2.72500E+04, 1.5391853951E+04, 5.0528836111E+03, 4.1969639271E+03, 1.9954356333E+03, 9.0134431631E-01],
	[2.72550E+04, 1.5396437640E+04, 5.0528302793E+03, 4.1994480987E+03, 1.9960657459E+03, 9.0139266522E-01],
	[2.72600E+04, 1.5401021853E+04, 5.0527769578E+03, 4.2019332833E+03, 1.9966957853E+03, 9.0144098929E-01],
	[2.72650E+04, 1.5405606589E+04, 5.0527236467E+03, 4.2044194809E+03, 1.9973257513E+03, 9.0148928853E-01],
	[2.72700E+04, 1.5410191849E+04, 5.0526703459E+03, 4.2069066918E+03, 1.9979556438E+03, 9.0153756296E-01],
	[2.72750E+04, 1.5414777633E+04, 5.0526170555E+03, 4.2093949164E+03, 1.9985854629E+03, 9.0158581258E-01],
	[2.72800E+04, 1.5419363940E+04, 5.0525637754E+03, 4.2118841546E+03, 1.9992152083E+03, 9.0163403741E-01],
	[2.72850E+04, 1.5423950772E+04, 5.0525105056E+03, 4.2143744069E+03, 1.9998448801E+03, 9.0168223746E-01],
	[2.72900E+04, 1.5428538126E+04, 5.0524572461E+03, 4.2168656735E+03, 2.0004744782E+03, 9.0173041274E-01],
	[2.72950E+04, 1.5433126005E+04, 5.0524039970E+03, 4.2193579544E+03, 2.0011040025E+03, 9.0177856326E-01],
	[2.73000E+04, 1.5437714407E+04, 5.0523507582E+03, 4.2218512501E+03, 2.0017334529E+03, 9.0182668903E-01],
	[2.73050E+04, 1.5442303332E+04, 5.0522975297E+03, 4.2243455607E+03, 2.0023628294E+03, 9.0187479007E-01],
	[2.73100E+04, 1.5446892781E+04, 5.0522443115E+03, 4.2268408864E+03, 2.0029921318E+03, 9.0192286638E-01],
	[2.73150E+04, 1.5451482753E+04, 5.0521911036E+03, 4.2293372275E+03, 2.0036213601E+03, 9.0197091798E-01],
	[2.73200E+04, 1.5456073249E+04, 5.0521379060E+03, 4.2318345842E+03, 2.0042505143E+03, 9.0201894487E-01],
	[2.73250E+04, 1.5460664268E+04, 5.0520847186E+03, 4.2343329567E+03, 2.0048795943E+03, 9.0206694708E-01],
	[2.73300E+04, 1.5465255810E+04, 5.0520315416E+03, 4.2368323453E+03, 2.0055085999E+03, 9.0211492461E-01],
	[2.73350E+04, 1.5469847876E+04, 5.0519783749E+03, 4.2393327501E+03, 2.0061375311E+03, 9.0216287747E-01],
	[2.73400E+04, 1.5474440465E+04, 5.0519252184E+03, 4.2418341714E+03, 2.0067663879E+03, 9.0221080567E-01],
	[2.73450E+04, 1.5479033577E+04, 5.0518720723E+03, 4.2443366094E+03, 2.0073951701E+03, 9.0225870923E-01],
	[2.73500E+04, 1.5483627213E+04, 5.0518189364E+03, 4.2468400644E+03, 2.0080238778E+03, 9.0230658816E-01],
	[2.73550E+04, 1.5488221371E+04, 5.0517658108E+03, 4.2493445366E+03, 2.0086525108E+03, 9.0235444247E-01],
	[2.73600E+04, 1.5492816053E+04, 5.0517126954E+03, 4.2518500261E+03, 2.0092810690E+03, 9.0240227217E-01],
	[2.73650E+04, 1.5497411257E+04, 5.0516595903E+03, 4.2543565333E+03, 2.0099095524E+03, 9.0245007726E-01],
	[2.73700E+04, 1.5502006985E+04, 5.0516064955E+03, 4.2568640583E+03, 2.0105379609E+03, 9.0249785778E-01],
	[2.73750E+04, 1.5506603236E+04, 5.0515534109E+03, 4.2593726015E+03, 2.0111662945E+03, 9.0254561371E-01],
	[2.73800E+04, 1.5511200009E+04, 5.0515003366E+03, 4.2618821629E+03, 2.0117945530E+03, 9.0259334508E-01],
	[2.73850E+04, 1.5515797306E+04, 5.0514472725E+03, 4.2643927429E+03, 2.0124227365E+03, 9.0264105190E-01],
	[2.73900E+04, 1.5520395126E+04, 5.0513942187E+03, 4.2669077751E+03, 2.0130516089E+03, 9.0268873418E-01],
	[2.73950E+04, 1.5524993468E+04, 5.0513411751E+03, 4.2694247989E+03, 2.0136806216E+03, 9.0273639193E-01],
	[2.74000E+04, 1.5529592333E+04, 5.0512881418E+03, 4.2719428466E+03, 2.0143095590E+03, 9.0278402516E-01],
	[2.74050E+04, 1.5534191721E+04, 5.0512351187E+03, 4.2744619184E+03, 2.0149384209E+03, 9.0283163389E-01],
	[2.74100E+04, 1.5538791632E+04, 5.0511821058E+03, 4.2769820145E+03, 2.0155672073E+03, 9.0287921812E-01],
	[2.74150E+04, 1.5543392065E+04, 5.0511291031E+03, 4.2795031352E+03, 2.0161959182E+03, 9.0292677786E-01],
	[2.74200E+04, 1.5547993021E+04, 5.0510761107E+03, 4.2820252808E+03, 2.0168245533E+03, 9.0297431314E-01],
	[2.74250E+04, 1.5552594500E+04, 5.0510231285E+03, 4.2845484513E+03, 2.0174531128E+03, 9.0302182395E-01],
	[2.74300E+04, 1.5557196501E+04, 5.0509701565E+03, 4.2870726472E+03, 2.0180815964E+03, 9.0306931032E-01],
	[2.74350E+04, 1.5561799025E+04, 5.0509171947E+03, 4.2895978685E+03, 2.0187100042E+03, 9.0311677224E-01],
	[2.74400E+04, 1.5566402072E+04, 5.0508642431E+03, 4.2921241156E+03, 2.0193383361E+03, 9.0316420974E-01],
	[2.74450E+04, 1.5571005641E+04, 5.0508113017E+03, 4.2946513886E+03, 2.0199665919E+03, 9.0321162283E-01],
	[2.74500E+04, 1.5575609732E+04, 5.0507583705E+03, 4.2971796878E+03, 2.0205947716E+03, 9.0325901151E-01],
	[2.74550E+04, 1.5580214346E+04, 5.0507054495E+03, 4.2997090134E+03, 2.0212228752E+03, 9.0330637581E-01],
	[2.74600E+04, 1.5584819482E+04, 5.0506525387E+03, 4.3022393656E+03, 2.0218509026E+03, 9.0335371572E-01],
	[2.74650E+04, 1.5589425141E+04, 5.0505996381E+03, 4.3047707447E+03, 2.0224788537E+03, 9.0340103126E-01],
	[2.74700E+04, 1.5594031322E+04, 5.0505467477E+03, 4.3073031509E+03, 2.0231067284E+03, 9.0344832245E-01],
	[2.74750E+04, 1.5598638025E+04, 5.0504938674E+03, 4.3098365845E+03, 2.0237345267E+03, 9.0349558929E-01],
	[2.74800E+04, 1.5603245250E+04, 5.0504409973E+03, 4.3123710456E+03, 2.0243622484E+03, 9.0354283180E-01],
	[2.74850E+04, 1.5607852998E+04, 5.0503881374E+03, 4.3149065345E+03, 2.0249898936E+03, 9.0359004998E-01],
	[2.74900E+04, 1.5612461268E+04, 5.0503352877E+03, 4.3174430513E+03, 2.0256174621E+03, 9.0363724386E-01],
	[2.74950E+04, 1.5617070060E+04, 5.0502824481E+03, 4.3199805965E+03, 2.0262449539E+03, 9.0368441343E-01],
	[2.75000E+04, 1.5621679374E+04, 5.0502296187E+03, 4.3225191701E+03, 2.0268723689E+03, 9.0373155872E-01],
	[2.75050E+04, 1.5626289210E+04, 5.0501767995E+03, 4.3250587724E+03, 2.0274997071E+03, 9.0377867973E-01],
	[2.75100E+04, 1.5630899568E+04, 5.0501239904E+03, 4.3275994036E+03, 2.0281269683E+03, 9.0382577647E-01],
	[2.75150E+04, 1.5635510448E+04, 5.0500711914E+03, 4.3301410640E+03, 2.0287541525E+03, 9.0387284896E-01],
	[2.75200E+04, 1.5640121851E+04, 5.0500184026E+03, 4.3326837538E+03, 2.0293812596E+03, 9.0391989721E-01],
	[2.75250E+04, 1.5644733775E+04, 5.0499656240E+03, 4.3352274732E+03, 2.0300082896E+03, 9.0396692123E-01],
	[2.75300E+04, 1.5649346221E+04, 5.0499128555E+03, 4.3377722224E+03, 2.0306352424E+03, 9.0401392104E-01],
	[2.75350E+04, 1.5653959188E+04, 5.0498600971E+03, 4.3403180018E+03, 2.0312621179E+03, 9.0406089663E-01],
	[2.75400E+04, 1.5658572678E+04, 5.0498073488E+03, 4.3428648114E+03, 2.0318889160E+03, 9.0410784803E-01],
	[2.75450E+04, 1.5663186689E+04, 5.0497546107E+03, 4.3454126515E+03, 2.0325156367E+03, 9.0415477524E-01],
	[2.75500E+04, 1.5667801223E+04, 5.0497018827E+03, 4.3479615225E+03, 2.0331422800E+03, 9.0420167828E-01],
	[2.75550E+04, 1.5672416277E+04, 5.0496491648E+03, 4.3505114244E+03, 2.0337688456E+03, 9.0424855717E-01],
	[2.75600E+04, 1.5677031854E+04, 5.0495964570E+03, 4.3530623575E+03, 2.0343953336E+03, 9.0429541190E-01],
	[2.75650E+04, 1.5681647952E+04, 5.0495437593E+03, 4.3556143221E+03, 2.0350217439E+03, 9.0434224249E-01],
	[2.75700E+04, 1.5686264572E+04, 5.0494910718E+03, 4.3581673183E+03, 2.0356480765E+03, 9.0438904896E-01],
	[2.75750E+04, 1.5690881713E+04, 5.0494383943E+03, 4.3607213465E+03, 2.0362743312E+03, 9.0443583131E-01],
	[2.75800E+04, 1.5695499376E+04, 5.0493857270E+03, 4.3632764068E+03, 2.0369005079E+03, 9.0448258956E-01],
	[2.75850E+04, 1.5700117561E+04, 5.0493330697E+03, 4.3658324995E+03, 2.0375266067E+03, 9.0452932372E-01],
	[2.75900E+04, 1.5704736266E+04, 5.0492804226E+03, 4.3683896248E+03, 2.0381526275E+03, 9.0457603379E-01],
	[2.75950E+04, 1.5709355494E+04, 5.0492277855E+03, 4.3709477829E+03, 2.0387785701E+03, 9.0462271980E-01],
	[2.76000E+04, 1.5713975242E+04, 5.0491751585E+03, 4.3735069740E+03, 2.0394044345E+03, 9.0466938175E-01],
	[2.76050E+04, 1.5718595512E+04, 5.0491225416E+03, 4.3760671984E+03, 2.0400302207E+03, 9.0471601966E-01],
	[2.76100E+04, 1.5723216304E+04, 5.0490699348E+03, 4.3786284564E+03, 2.0406559286E+03, 9.0476263353E-01],
	[2.76150E+04, 1.5727837616E+04, 5.0490173380E+03, 4.3811907481E+03, 2.0412815580E+03, 9.0480922338E-01],
	[2.76200E+04, 1.5732459450E+04, 5.0489647513E+03, 4.3837540737E+03, 2.0419071090E+03, 9.0485578922E-01],
	[2.76250E+04, 1.5737081805E+04, 5.0489121747E+03, 4.3863184336E+03, 2.0425325814E+03, 9.0490233105E-01],
	[2.76300E+04, 1.5741704681E+04, 5.0488596082E+03, 4.3888838279E+03, 2.0431579753E+03, 9.0494884890E-01],
	[2.76350E+04, 1.5746328079E+04, 5.0488070517E+03, 4.3914502568E+03, 2.0437832904E+03, 9.0499534277E-01],
	[2.76400E+04, 1.5750951997E+04, 5.0487545052E+03, 4.3940177207E+03, 2.0444085269E+03, 9.0504181266E-01],
	[2.76450E+04, 1.5755576437E+04, 5.0487019688E+03, 4.3965862196E+03, 2.0450336845E+03, 9.0508825860E-01],
	[2.76500E+04, 1.5760201397E+04, 5.0486494425E+03, 4.3991557539E+03, 2.0456587632E+03, 9.0513468059E-01],
	[2.76550E+04, 1.5764826879E+04, 5.0485969262E+03, 4.4017263238E+03, 2.0462837630E+03, 9.0518107864E-01],
	[2.76600E+04, 1.5769452882E+04, 5.0485444199E+03, 4.4042979295E+03, 2.0469086838E+03, 9.0522745277E-01],
	[2.76650E+04, 1.5774079405E+04, 5.0484919237E+03, 4.4068705712E+03, 2.0475335254E+03, 9.0527380298E-01],
	[2.76700E+04, 1.5778706449E+04, 5.0484394375E+03, 4.4094442492E+03, 2.0481582880E+03, 9.0532012929E-01],
	[2.76750E+04, 1.5783334015E+04, 5.0483869614E+03, 4.4120189636E+03, 2.0487829713E+03, 9.0536643170E-01],
	[2.76800E+04, 1.5787962101E+04, 5.0483344952E+03, 4.4145947148E+03, 2.0494075753E+03, 9.0541271023E-01],
	[2.76850E+04, 1.5792590708E+04, 5.0482820391E+03, 4.4171715030E+03, 2.0500321000E+03, 9.0545896488E-01],
	[2.76900E+04, 1.5797219835E+04, 5.0482295930E+03, 4.4197493283E+03, 2.0506565452E+03, 9.0550519567E-01],
	[2.76950E+04, 1.5801849483E+04, 5.0481771569E+03, 4.4223281911E+03, 2.0512809110E+03, 9.0555140262E-01],
	[2.77000E+04, 1.5806479652E+04, 5.0481247309E+03, 4.4249080914E+03, 2.0519051972E+03, 9.0559758571E-01],
	[2.77050E+04, 1.5811110342E+04, 5.0480723148E+03, 4.4274890297E+03, 2.0525294037E+03, 9.0564374498E-01],
	[2.77100E+04, 1.5815741552E+04, 5.0480199087E+03, 4.4300710060E+03, 2.0531535306E+03, 9.0568988044E-01],
	[2.77150E+04, 1.5820373283E+04, 5.0479675127E+03, 4.4326540207E+03, 2.0537775777E+03, 9.0573599208E-01],
	[2.77200E+04, 1.5825005534E+04, 5.0479151266E+03, 4.4352380740E+03, 2.0544015449E+03, 9.0578207992E-01],
	[2.77250E+04, 1.5829638306E+04, 5.0478627505E+03, 4.4378231660E+03, 2.0550254323E+03, 9.0582814398E-01],
	[2.77300E+04, 1.5834271599E+04, 5.0478103844E+03, 4.4404092970E+03, 2.0556492397E+03, 9.0587418426E-01],
	[2.77350E+04, 1.5838905411E+04, 5.0477580283E+03, 4.4429964673E+03, 2.0562729671E+03, 9.0592020077E-01],
	[2.77400E+04, 1.5843539744E+04, 5.0477056822E+03, 4.4455846771E+03, 2.0568966144E+03, 9.0596619353E-01],
	[2.77450E+04, 1.5848174598E+04, 5.0476533461E+03, 4.4481739266E+03, 2.0575201815E+03, 9.0601216254E-01],
	[2.77500E+04, 1.5852809972E+04, 5.0476010199E+03, 4.4507642160E+03, 2.0581436683E+03, 9.0605810782E-01],
	[2.77550E+04, 1.5857445866E+04, 5.0475487037E+03, 4.4533555455E+03, 2.0587670749E+03, 9.0610402938E-01],
	[2.77600E+04, 1.5862082280E+04, 5.0474963975E+03, 4.4559479155E+03, 2.0593904011E+03, 9.0614992723E-01],
	[2.77650E+04, 1.5866719215E+04, 5.0474441012E+03, 4.4585413261E+03, 2.0600136468E+03, 9.0619580137E-01],
	[2.77700E+04, 1.5871356670E+04, 5.0473918149E+03, 4.4611357775E+03, 2.0606368121E+03, 9.0624165183E-01],
	[2.77750E+04, 1.5875994644E+04, 5.0473395385E+03, 4.4637312700E+03, 2.0612598968E+03, 9.0628747860E-01],
	[2.77800E+04, 1.5880633139E+04, 5.0472872721E+03, 4.4663278039E+03, 2.0618829008E+03, 9.0633328170E-01],
	[2.77850E+04, 1.5885272155E+04, 5.0472350156E+03, 4.4689253793E+03, 2.0625058242E+03, 9.0637906115E-01],
	[2.77900E+04, 1.5889911690E+04, 5.0471827691E+03, 4.4715239964E+03, 2.0631286667E+03, 9.0642481695E-01],
	[2.77950E+04, 1.5894551745E+04, 5.0471305325E+03, 4.4741236555E+03, 2.0637514285E+03, 9.0647054911E-01],
	[2.78000E+04, 1.5899192320E+04, 5.0470783059E+03, 4.4767243569E+03, 2.0643741093E+03, 9.0651625765E-01],
	[2.78050E+04, 1.5903833415E+04, 5.0470260892E+03, 4.4793261008E+03, 2.0649967092E+03, 9.0656194257E-01],
	[2.78100E+04, 1.5908475030E+04, 5.0469738824E+03, 4.4819288873E+03, 2.0656192280E+03, 9.0660760389E-01],
	[2.78150E+04, 1.5913117165E+04, 5.0469216856E+03, 4.4845327167E+03, 2.0662416657E+03, 9.0665324161E-01],
	[2.78200E+04, 1.5917759820E+04, 5.0468694986E+03, 4.4871375893E+03, 2.0668640223E+03, 9.0669885575E-01],
	[2.78250E+04, 1.5922402994E+04, 5.0468173216E+03, 4.4897435053E+03, 2.0674862976E+03, 9.0674444632E-01],
	[2.78300E+04, 1.5927046688E+04, 5.0467651545E+03, 4.4923504649E+03, 2.0681084916E+03, 9.0679001332E-01],
	[2.78350E+04, 1.5931690902E+04, 5.0467129973E+03, 4.4949584683E+03, 2.0687306043E+03, 9.0683555678E-01],
	[2.78400E+04, 1.5936335636E+04, 5.0466608500E+03, 4.4975675158E+03, 2.0693526355E+03, 9.0688107670E-01],
	[2.78450E+04, 1.5940980889E+04, 5.0466087127E+03, 4.5001776076E+03, 2.0699745853E+03, 9.0692657308E-01],
	[2.78500E+04, 1.5945626662E+04, 5.0465565852E+03, 4.5027887439E+03, 2.0705964534E+03, 9.0697204595E-01],
	[2.78550E+04, 1.5950272954E+04, 5.0465044676E+03, 4.5054009249E+03, 2.0712182400E+03, 9.0701749532E-01],
	[2.78600E+04, 1.5954919766E+04, 5.0464523599E+03, 4.5080141510E+03, 2.0718399448E+03, 9.0706292118E-01],
	[2.78650E+04, 1.5959567098E+04, 5.0464002621E+03, 4.5106284223E+03, 2.0724615679E+03, 9.0710832356E-01],
	[2.78700E+04, 1.5964214949E+04, 5.0463481742E+03, 4.5132437390E+03, 2.0730831092E+03, 9.0715370247E-01],
	[2.78750E+04, 1.5968863320E+04, 5.0462960961E+03, 4.5158601014E+03, 2.0737045685E+03, 9.0719905791E-01],
	[2.78800E+04, 1.5973512209E+04, 5.0462440280E+03, 4.5184775097E+03, 2.0743259459E+03, 9.0724438990E-01],
	[2.78850E+04, 1.5978161619E+04, 5.0461919697E+03, 4.5210959641E+03, 2.0749472413E+03, 9.0728969844E-01],
	[2.78900E+04, 1.5982811547E+04, 5.0461399213E+03, 4.5237154649E+03, 2.0755684546E+03, 9.0733498356E-01],
	[2.78950E+04, 1.5987461995E+04, 5.0460878827E+03, 4.5263360123E+03, 2.0761895858E+03, 9.0738024525E-01],
	[2.79000E+04, 1.5992112962E+04, 5.0460358541E+03, 4.5289576065E+03, 2.0768106347E+03, 9.0742548353E-01],
	[2.79050E+04, 1.5996764449E+04, 5.0459838352E+03, 4.5315802477E+03, 2.0774316014E+03, 9.0747069842E-01],
	[2.79100E+04, 1.6001416454E+04, 5.0459318263E+03, 4.5342039363E+03, 2.0780524857E+03, 9.0751588991E-01],
	[2.79150E+04, 1.6006068979E+04, 5.0458798272E+03, 4.5368286723E+03, 2.0786732876E+03, 9.0756105803E-01],
	[2.79200E+04, 1.6010722023E+04, 5.0458278379E+03, 4.5394544561E+03, 2.0792940070E+03, 9.0760620278E-01],
	[2.79250E+04, 1.6015375586E+04, 5.0457758585E+03, 4.5420812879E+03, 2.0799146439E+03, 9.0765132418E-01],
	[2.79300E+04, 1.6020029668E+04, 5.0457238889E+03, 4.5447091679E+03, 2.0805351982E+03, 9.0769642223E-01],
	[2.79350E+04, 1.6024684269E+04, 5.0456719291E+03, 4.5473380963E+03, 2.0811556698E+03, 9.0774149695E-01],
	[2.79400E+04, 1.6029339389E+04, 5.0456199792E+03, 4.5499680733E+03, 2.0817760586E+03, 9.0778654834E-01],
	[2.79450E+04, 1.6033995028E+04, 5.0455680392E+03, 4.5525990993E+03, 2.0823963647E+03, 9.0783157642E-01],
	[2.79500E+04, 1.6038651186E+04, 5.0455161089E+03, 4.5552311744E+03, 2.0830165879E+03, 9.0787658120E-01],
	[2.79550E+04, 1.6043307863E+04, 5.0454641885E+03, 4.5578642988E+03, 2.0836367282E+03, 9.0792156269E-01],
	[2.79600E+04, 1.6047965059E+04, 5.0454122779E+03, 4.5604984728E+03, 2.0842567854E+03, 9.0796652090E-01],
	[2.79650E+04, 1.6052622773E+04, 5.0453603771E+03, 4.5631336967E+03, 2.0848767597E+03, 9.0801145584E-01],
	[2.79700E+04, 1.6057281006E+04, 5.0453084861E+03, 4.5657699705E+03, 2.0854966508E+03, 9.0805636753E-01],
	[2.79750E+04, 1.6061939758E+04, 5.0452566049E+03, 4.5684072947E+03, 2.0861164587E+03, 9.0810125596E-01],
	[2.79800E+04, 1.6066599029E+04, 5.0452047336E+03, 4.5710456693E+03, 2.0867361834E+03, 9.0814612116E-01],
	[2.79850E+04, 1.6071258818E+04, 5.0451528720E+03, 4.5736850947E+03, 2.0873558247E+03, 9.0819096313E-01],
	[2.79900E+04, 1.6075919126E+04, 5.0451010202E+03, 4.5763255710E+03, 2.0879753827E+03, 9.0823578189E-01],
	[2.79950E+04, 1.6080579953E+04, 5.0450491783E+03, 4.5789670985E+03, 2.0885948573E+03, 9.0828057745E-01],
	[2.80000E+04, 1.6085241298E+04, 5.0449973461E+03, 4.5816096775E+03, 2.0892142483E+03, 9.0832534981E-01],
	[2.80050E+04, 1.6089903162E+04, 5.0449455237E+03, 4.5842533081E+03, 2.0898335558E+03, 9.0837009899E-01],
	[2.80100E+04, 1.6094565544E+04, 5.0448937111E+03, 4.5868979905E+03, 2.0904527796E+03, 9.0841482500E-01],
	[2.80150E+04, 1.6099228445E+04, 5.0448419083E+03, 4.5895437251E+03, 2.0910719198E+03, 9.0845952785E-01],
	[2.80200E+04, 1.6103891864E+04, 5.0447901152E+03, 4.5921905121E+03, 2.0916909762E+03, 9.0850420755E-01],
	[2.80250E+04, 1.6108555801E+04, 5.0447383319E+03, 4.5948383516E+03, 2.0923099488E+03, 9.0854886411E-01],
	[2.80300E+04, 1.6113220257E+04, 5.0446865584E+03, 4.5974872438E+03, 2.0929288375E+03, 9.0859349755E-01],
	[2.80350E+04, 1.6117885231E+04, 5.0446347947E+03, 4.6001371892E+03, 2.0935476422E+03, 9.0863810786E-01],
	[2.80400E+04, 1.6122550724E+04, 5.0445830407E+03, 4.6027881878E+03, 2.0941663629E+03, 9.0868269508E-01],
	[2.80450E+04, 1.6127216734E+04, 5.0445312965E+03, 4.6054402398E+03, 2.0947849996E+03, 9.0872725919E-01],
	[2.80500E+04, 1.6131883263E+04, 5.0444795620E+03, 4.6080933456E+03, 2.0954035521E+03, 9.0877180023E-01],
	[2.80550E+04, 1.6136550311E+04, 5.0444278373E+03, 4.6107475054E+03, 2.0960220204E+03, 9.0881631819E-01],
	[2.80600E+04, 1.6141217876E+04, 5.0443761223E+03, 4.6134027193E+03, 2.0966404045E+03, 9.0886081308E-01],
	[2.80650E+04, 1.6145885959E+04, 5.0443244171E+03, 4.6160589876E+03, 2.0972587042E+03, 9.0890528493E-01],
	[2.80700E+04, 1.6150554561E+04, 5.0442727216E+03, 4.6187163106E+03, 2.0978769196E+03, 9.0894973374E-01],
	[2.80750E+04, 1.6155223680E+04, 5.0442210359E+03, 4.6213746885E+03, 2.0984950505E+03, 9.0899415951E-01],
	[2.80800E+04, 1.6159893318E+04, 5.0441693598E+03, 4.6240341214E+03, 2.0991130969E+03, 9.0903856227E-01],
	[2.80850E+04, 1.6164563473E+04, 5.0441176936E+03, 4.6266946097E+03, 2.0997310587E+03, 9.0908294202E-01],
	[2.80900E+04, 1.6169234147E+04, 5.0440660370E+03, 4.6293561536E+03, 2.1003489359E+03, 9.0912729877E-01],
	[2.80950E+04, 1.6173905338E+04, 5.0440143902E+03, 4.6320187532E+03, 2.1009667284E+03, 9.0917163254E-01],
	[2.81000E+04, 1.6178577047E+04, 5.0439627531E+03, 4.6346824088E+03, 2.1015844361E+03, 9.0921594333E-01],
	[2.81050E+04, 1.6183249274E+04, 5.0439111257E+03, 4.6373471207E+03, 2.1022020590E+03, 9.0926023116E-01],
	[2.81100E+04, 1.6187922019E+04, 5.0438595080E+03, 4.6400128891E+03, 2.1028195970E+03, 9.0930449604E-01],
	[2.81150E+04, 1.6192595282E+04, 5.0438079000E+03, 4.6426797142E+03, 2.1034370500E+03, 9.0934873797E-01],
	[2.81200E+04, 1.6197269062E+04, 5.0437563017E+03, 4.6453475963E+03, 2.1040544181E+03, 9.0939295698E-01],
	[2.81250E+04, 1.6201943360E+04, 5.0437047131E+03, 4.6480165355E+03, 2.1046717010E+03, 9.0943715306E-01],
	[2.81300E+04, 1.6206618176E+04, 5.0436531343E+03, 4.6506865321E+03, 2.1052888989E+03, 9.0948132623E-01],
	[2.81350E+04, 1.6211293509E+04, 5.0436015651E+03, 4.6533575863E+03, 2.1059060115E+03, 9.0952547650E-01],
	[2.81400E+04, 1.6215969360E+04, 5.0435500056E+03, 4.6560296985E+03, 2.1065230389E+03, 9.0956960389E-01],
	[2.81450E+04, 1.6220645729E+04, 5.0434984558E+03, 4.6587028687E+03, 2.1071399810E+03, 9.0961370840E-01],
	[2.81500E+04, 1.6225322615E+04, 5.0434469157E+03, 4.6613770972E+03, 2.1077568377E+03, 9.0965779005E-01],
	[2.81550E+04, 1.6230000018E+04, 5.0433953853E+03, 4.6640523843E+03, 2.1083736089E+03, 9.0970184884E-01],
	[2.81600E+04, 1.6234677939E+04, 5.0433438645E+03, 4.6667287301E+03, 2.1089902946E+03, 9.0974588478E-01],
	[2.81650E+04, 1.6239356377E+04, 5.0432923534E+03, 4.6694061350E+03, 2.1096068948E+03, 9.0978989789E-01],
	[2.81700E+04, 1.6244035333E+04, 5.0432408520E+03, 4.6720845991E+03, 2.1102234094E+03, 9.0983388819E-01],
	[2.81750E+04, 1.6248714806E+04, 5.0431893602E+03, 4.6747641227E+03, 2.1108398382E+03, 9.0987785567E-01],
	[2.81800E+04, 1.6253394797E+04, 5.0431378782E+03, 4.6774447060E+03, 2.1114561813E+03, 9.0992180035E-01],
	[2.81850E+04, 1.6258075304E+04, 5.0430864057E+03, 4.6801263492E+03, 2.1120724386E+03, 9.0996572224E-01],
	[2.81900E+04, 1.6262756329E+04, 5.0430349430E+03, 4.6828090526E+03, 2.1126886101E+03, 9.1000962135E-01],
	[2.81950E+04, 1.6267437872E+04, 5.0429834898E+03, 4.6854928164E+03, 2.1133046956E+03, 9.1005349769E-01],
	[2.82000E+04, 1.6272119931E+04, 5.0429320464E+03, 4.6881776408E+03, 2.1139206951E+03, 9.1009735128E-01],
	[2.82050E+04, 1.6276802507E+04, 5.0428806125E+03, 4.6908635261E+03, 2.1145366085E+03, 9.1014118213E-01],
	[2.82100E+04, 1.6281485601E+04, 5.0428291883E+03, 4.6935504725E+03, 2.1151524358E+03, 9.1018499024E-01],
	[2.82150E+04, 1.6286169212E+04, 5.0427777738E+03, 4.6962384801E+03, 2.1157681770E+03, 9.1022877562E-01],
	[2.82200E+04, 1.6290853339E+04, 5.0427263689E+03, 4.6989275493E+03, 2.1163838319E+03, 9.1027253830E-01],
	[2.82250E+04, 1.6295537984E+04, 5.0426749736E+03, 4.7016176803E+03, 2.1169994005E+03, 9.1031627827E-01],
	[2.82300E+04, 1.6300223146E+04, 5.0426235879E+03, 4.7043088733E+03, 2.1176148828E+03, 9.1035999555E-01],
	[2.82350E+04, 1.6304941279E+04, 5.0425792100E+03, 4.7070011286E+03, 2.1182320613E+03, 9.1040369015E-01],
	[2.82400E+04, 1.6309672188E+04, 5.0425374801E+03, 4.7096944463E+03, 2.1188498275E+03, 9.1044736208E-01],
	[2.82450E+04, 1.6314403632E+04, 5.0424957579E+03, 4.7123888267E+03, 2.1194675092E+03, 9.1049101136E-01],
	[2.82500E+04, 1.6319135611E+04, 5.0424540435E+03, 4.7150842700E+03, 2.1200851064E+03, 9.1053463799E-01],
	[2.82550E+04, 1.6323868124E+04, 5.0424123368E+03, 4.7177807765E+03, 2.1207026189E+03, 9.1057824198E-01],
	[2.82600E+04, 1.6328601172E+04, 5.0423706379E+03, 4.7204783464E+03, 2.1213200467E+03, 9.1062182335E-01],
	[2.82650E+04, 1.6333334755E+04, 5.0423289466E+03, 4.7231769799E+03, 2.1219373897E+03, 9.1066538210E-01],
	[2.82700E+04, 1.6338068872E+04, 5.0422872631E+03, 4.7258766773E+03, 2.1225546479E+03, 9.1070891825E-01],
	[2.82750E+04, 1.6342803524E+04, 5.0422455873E+03, 4.7285774387E+03, 2.1231718213E+03, 9.1075243181E-01],
	[2.82800E+04, 1.6347538711E+04, 5.0422039192E+03, 4.7312792645E+03, 2.1237889097E+03, 9.1079592279E-01],
	[2.82850E+04, 1.6352274432E+04, 5.0421622588E+03, 4.7339821547E+03, 2.1244059131E+03, 9.1083939120E-01],
	[2.82900E+04, 1.6357010687E+04, 5.0421206061E+03, 4.7366861098E+03, 2.1250228314E+03, 9.1088283704E-01],
	[2.82950E+04, 1.6361747477E+04, 5.0420789611E+03, 4.7393911299E+03, 2.1256396646E+03, 9.1092626034E-01],
	[2.83000E+04, 1.6366484801E+04, 5.0420373239E+03, 4.7420972152E+03, 2.1262564127E+03, 9.1096966111E-01],
	[2.83050E+04, 1.6371222659E+04, 5.0419956943E+03, 4.7448043659E+03, 2.1268730755E+03, 9.1101303934E-01],
	[2.83100E+04, 1.6375961052E+04, 5.0419540724E+03, 4.7475125824E+03, 2.1274896529E+03, 9.1105639507E-01],
	[2.83150E+04, 1.6380699979E+04, 5.0419124582E+03, 4.7502218647E+03, 2.1281061451E+03, 9.1109972828E-01],
	[2.83200E+04, 1.6385439441E+04, 5.0418708517E+03, 4.7529322133E+03, 2.1287225518E+03, 9.1114303901E-01],
	[2.83250E+04, 1.6390179436E+04, 5.0418292529E+03, 4.7556436282E+03, 2.1293388730E+03, 9.1118632725E-01],
	[2.83300E+04, 1.6394919966E+04, 5.0417876618E+03, 4.7583561097E+03, 2.1299551087E+03, 9.1122959302E-01],
	[2.83350E+04, 1.6399661030E+04, 5.0417460784E+03, 4.7610696581E+03, 2.1305712588E+03, 9.1127283633E-01],
	[2.83400E+04, 1.6404402628E+04, 5.0417045026E+03, 4.7637842736E+03, 2.1311873233E+03, 9.1131605719E-01],
	[2.83450E+04, 1.6409144760E+04, 5.0416629346E+03, 4.7664999563E+03, 2.1318033020E+03, 9.1135925561E-01],
	[2.83500E+04, 1.6413887426E+04, 5.0416213742E+03, 4.7692167066E+03, 2.1324191950E+03, 9.1140243161E-01],
	[2.83550E+04, 1.6418630627E+04, 5.0415798214E+03, 4.7719345247E+03, 2.1330350021E+03, 9.1144558519E-01],
	[2.83600E+04, 1.6423374361E+04, 5.0415382764E+03, 4.7746534108E+03, 2.1336507233E+03, 9.1148871636E-01],
	[2.83650E+04, 1.6428118629E+04, 5.0414967390E+03, 4.7773733651E+03, 2.1342663586E+03, 9.1153182514E-01],
	[2.83700E+04, 1.6432863431E+04, 5.0414552092E+03, 4.7800943878E+03, 2.1348819078E+03, 9.1157491153E-01],
	[2.83750E+04, 1.6437608767E+04, 5.0414136872E+03, 4.7828164793E+03, 2.1354973710E+03, 9.1161797556E-01],
	[2.83800E+04, 1.6442354637E+04, 5.0413721728E+03, 4.7855396396E+03, 2.1361127481E+03, 9.1166101722E-01],
	[2.83850E+04, 1.6447101040E+04, 5.0413306660E+03, 4.7882638692E+03, 2.1367280390E+03, 9.1170403653E-01],
	[2.83900E+04, 1.6451847978E+04, 5.0412891669E+03, 4.7909891681E+03, 2.1373432436E+03, 9.1174703350E-01],
	[2.83950E+04, 1.6456595449E+04, 5.0412476754E+03, 4.7937155366E+03, 2.1379583619E+03, 9.1179000814E-01],
	[2.84000E+04, 1.6461343454E+04, 5.0412061916E+03, 4.7964429750E+03, 2.1385733939E+03, 9.1183296046E-01],
	[2.84050E+04, 1.6466091992E+04, 5.0411647155E+03, 4.7991714834E+03, 2.1391883394E+03, 9.1187589048E-01],
	[2.84100E+04, 1.6470841064E+04, 5.0411232469E+03, 4.8019010621E+03, 2.1398031985E+03, 9.1191879820E-01],
	[2.84150E+04, 1.6475590670E+04, 5.0410817861E+03, 4.8046317114E+03, 2.1404179710E+03, 9.1196168364E-01],
	[2.84200E+04, 1.6480340809E+04, 5.0410403328E+03, 4.8073634315E+03, 2.1410326569E+03, 9.1200454680E-01],
	[2.84250E+04, 1.6485091482E+04, 5.0409988872E+03, 4.8100962225E+03, 2.1416472562E+03, 9.1204738770E-01],
	[2.84300E+04, 1.6489842688E+04, 5.0409574492E+03, 4.8128300848E+03, 2.1422617688E+03, 9.1209020635E-01],
	[2.84350E+04, 1.6494594428E+04, 5.0409160188E+03, 4.8155650185E+03, 2.1428761946E+03, 9.1213300276E-01],
	[2.84400E+04, 1.6499346702E+04, 5.0408745961E+03, 4.8183010239E+03, 2.1434905335E+03, 9.1217577694E-01],
	[2.84450E+04, 1.6504099508E+04, 5.0408331810E+03, 4.8210381013E+03, 2.1441047856E+03, 9.1221852890E-01],
	[2.84500E+04, 1.6508852848E+04, 5.0407917735E+03, 4.8237762508E+03, 2.1447189507E+03, 9.1226125865E-01],
	[2.84550E+04, 1.6513606722E+04, 5.0407503736E+03, 4.8265154727E+03, 2.1453330289E+03, 9.1230396620E-01],
	[2.84600E+04, 1.6518361128E+04, 5.0407089814E+03, 4.8292557671E+03, 2.1459470199E+03, 9.1234665157E-01],
	[2.84650E+04, 1.6523116068E+04, 5.0406675967E+03, 4.8319971345E+03, 2.1465609239E+03, 9.1238931477E-01],
	[2.84700E+04, 1.6527871541E+04, 5.0406262197E+03, 4.8347395749E+03, 2.1471747407E+03, 9.1243195580E-01],
	[2.84750E+04, 1.6532627548E+04, 5.0405848502E+03, 4.8374830886E+03, 2.1477884702E+03, 9.1247457467E-01],
	[2.84800E+04, 1.6537384087E+04, 5.0405434884E+03, 4.8402276758E+03, 2.1484021125E+03, 9.1251717141E-01],
	[2.84850E+04, 1.6542141160E+04, 5.0405021342E+03, 4.8429733369E+03, 2.1490156674E+03, 9.1255974601E-01],
	[2.84900E+04, 1.6546898766E+04, 5.0404607875E+03, 4.8457200719E+03, 2.1496291349E+03, 9.1260229850E-01],
	[2.84950E+04, 1.6551656905E+04, 5.0404194485E+03, 4.8484678811E+03, 2.1502425149E+03, 9.1264482887E-01],
	[2.85000E+04, 1.6556415576E+04, 5.0403781171E+03, 4.8512167648E+03, 2.1508558075E+03, 9.1268733715E-01],
	[2.85050E+04, 1.6561174781E+04, 5.0403367932E+03, 4.8539667232E+03, 2.1514690124E+03, 9.1272982334E-01],
	[2.85100E+04, 1.6565934519E+04, 5.0402954769E+03, 4.8567177565E+03, 2.1520821297E+03, 9.1277228746E-01],
	[2.85150E+04, 1.6570694790E+04, 5.0402541682E+03, 4.8594698649E+03, 2.1526951594E+03, 9.1281472951E-01],
	[2.85200E+04, 1.6575455594E+04, 5.0402128671E+03, 4.8622230488E+03, 2.1533081013E+03, 9.1285714950E-01],
	[2.85250E+04, 1.6580216930E+04, 5.0401715736E+03, 4.8649773082E+03, 2.1539209553E+03, 9.1289954748E-01],
	[2.85300E+04, 1.6584978799E+04, 5.0401302876E+03, 4.8677326435E+03, 2.1545337216E+03, 9.1294192345E-01],
	[2.85350E+04, 1.6589741202E+04, 5.0400890093E+03, 4.8704890549E+03, 2.1551463999E+03, 9.1298427743E-01],
	[2.85400E+04, 1.6594504136E+04, 5.0400477385E+03, 4.8732465426E+03, 2.1557589902E+03, 9.1302660943E-01],
	[2.85450E+04, 1.6599267604E+04, 5.0400064752E+03, 4.8760051068E+03, 2.1563714925E+03, 9.1306891946E-01],
	[2.85500E+04, 1.6604031604E+04, 5.0399652195E+03, 4.8787647478E+03, 2.1569839067E+03, 9.1311120753E-01],
	[2.85550E+04, 1.6608796137E+04, 5.0399239714E+03, 4.8815254658E+03, 2.1575962328E+03, 9.1315347364E-01],
	[2.85600E+04, 1.6613561203E+04, 5.0398827309E+03, 4.8842872610E+03, 2.1582084707E+03, 9.1319571782E-01],
	[2.85650E+04, 1.6618326801E+04, 5.0398414979E+03, 4.8870501336E+03, 2.1588206203E+03, 9.1323794006E-01],
	[2.85700E+04, 1.6623092932E+04, 5.0398002724E+03, 4.8898140840E+03, 2.1594326816E+03, 9.1328014038E-01],
	[2.85750E+04, 1.6627859595E+04, 5.0397590545E+03, 4.8925791123E+03, 2.1600446545E+03, 9.1332231878E-01],
	[2.85800E+04, 1.6632626791E+04, 5.0397178442E+03, 4.8953452187E+03, 2.1606565391E+03, 9.1336447528E-01],
	[2.85850E+04, 1.6637394519E+04, 5.0396766414E+03, 4.8981124035E+03, 2.1612683351E+03, 9.1340660989E-01],
	[2.85900E+04, 1.6642162780E+04, 5.0396354461E+03, 4.9008806670E+03, 2.1618800426E+03, 9.1344872261E-01],
	[2.85950E+04, 1.6646931573E+04, 5.0395942584E+03, 4.9036500093E+03, 2.1624916615E+03, 9.1349081347E-01],
	[2.86000E+04, 1.6651700898E+04, 5.0395530782E+03, 4.9064204306E+03, 2.1631031918E+03, 9.1353288245E-01],
	[2.86050E+04, 1.6656470756E+04, 5.0395119056E+03, 4.9091919313E+03, 2.1637146334E+03, 9.1357492959E-01],
	[2.86100E+04, 1.6661241146E+04, 5.0394707405E+03, 4.9119645115E+03, 2.1643259862E+03, 9.1361695487E-01],
	[2.86150E+04, 1.6666012068E+04, 5.0394295829E+03, 4.9147381715E+03, 2.1649372501E+03, 9.1365895833E-01],
	[2.86200E+04, 1.6670783523E+04, 5.0393884328E+03, 4.9175129114E+03, 2.1655484253E+03, 9.1370093996E-01],
	[2.86250E+04, 1.6675555509E+04, 5.0393472903E+03, 4.9202887316E+03, 2.1661595115E+03, 9.1374289977E-01],
	[2.86300E+04, 1.6680328028E+04, 5.0393061553E+03, 4.9230656323E+03, 2.1667705087E+03, 9.1378483778E-01],
	[2.86350E+04, 1.6685101079E+04, 5.0392650278E+03, 4.9258436137E+03, 2.1673814169E+03, 9.1382675400E-01],
	[2.86400E+04, 1.6689874662E+04, 5.0392239078E+03, 4.9286226760E+03, 2.1679922359E+03, 9.1386864843E-01],
	[2.86450E+04, 1.6694648777E+04, 5.0391827954E+03, 4.9314028194E+03, 2.1686029659E+03, 9.1391052108E-01],
	[2.86500E+04, 1.6699423424E+04, 5.0391416904E+03, 4.9341840443E+03, 2.1692136066E+03, 9.1395237197E-01],
	[2.86550E+04, 1.6704198603E+04, 5.0391005930E+03, 4.9369663507E+03, 2.1698241581E+03, 9.1399420110E-01],
	[2.86600E+04, 1.6708974314E+04, 5.0390595031E+03, 4.9397497390E+03, 2.1704346203E+03, 9.1403600849E-01],
	[2.86650E+04, 1.6713750557E+04, 5.0390184206E+03, 4.9425342094E+03, 2.1710449931E+03, 9.1407779414E-01],
	[2.86700E+04, 1.6718527332E+04, 5.0389773457E+03, 4.9453197621E+03, 2.1716552765E+03, 9.1411955806E-01],
	[2.86750E+04, 1.6723304639E+04, 5.0389362783E+03, 4.9481063973E+03, 2.1722654704E+03, 9.1416130027E-01],
	[2.86800E+04, 1.6728082477E+04, 5.0388952183E+03, 4.9508941154E+03, 2.1728755747E+03, 9.1420302077E-01],
	[2.86850E+04, 1.6732860848E+04, 5.0388541659E+03, 4.9536829164E+03, 2.1734855895E+03, 9.1424471958E-01],
	[2.86900E+04, 1.6737639750E+04, 5.0388131209E+03, 4.9564728006E+03, 2.1740955147E+03, 9.1428639670E-01],
	[2.86950E+04, 1.6742419183E+04, 5.0387720835E+03, 4.9592637684E+03, 2.1747053501E+03, 9.1432805214E-01],
	[2.87000E+04, 1.6747199149E+04, 5.0387310535E+03, 4.9620558198E+03, 2.1753150958E+03, 9.1436968591E-01],
	[2.87050E+04, 1.6751979646E+04, 5.0386900310E+03, 4.9648489551E+03, 2.1759247517E+03, 9.1441129803E-01],
	[2.87100E+04, 1.6756760675E+04, 5.0386490159E+03, 4.9676431746E+03, 2.1765343178E+03, 9.1445288850E-01],
	[2.87150E+04, 1.6761542235E+04, 5.0386080084E+03, 4.9704384786E+03, 2.1771437939E+03, 9.1449445733E-01],
	[2.87200E+04, 1.6766324327E+04, 5.0385670083E+03, 4.9732348671E+03, 2.1777531801E+03, 9.1453600454E-01],
	[2.87250E+04, 1.6771106950E+04, 5.0385260157E+03, 4.9760323405E+03, 2.1783624762E+03, 9.1457753012E-01],
	[2.87300E+04, 1.6775890105E+04, 5.0384850306E+03, 4.9788308989E+03, 2.1789716823E+03, 9.1461903410E-01],
	[2.87350E+04, 1.6780673791E+04, 5.0384440529E+03, 4.9816305427E+03, 2.1795807982E+03, 9.1466051649E-01],
	[2.87400E+04, 1.6785458009E+04, 5.0384030827E+03, 4.9844312721E+03, 2.1801898240E+03, 9.1470197728E-01],
	[2.87450E+04, 1.6790242758E+04, 5.0383621199E+03, 4.9872330872E+03, 2.1807987595E+03, 9.1474341650E-01],
	[2.87500E+04, 1.6795028039E+04, 5.0383211647E+03, 4.9900359883E+03, 2.1814076047E+03, 9.1478483415E-01],
	[2.87550E+04, 1.6799813850E+04, 5.0382802168E+03, 4.9928399757E+03, 2.1820163596E+03, 9.1482623024E-01],
	[2.87600E+04, 1.6804600193E+04, 5.0382392764E+03, 4.9956450495E+03, 2.1826250241E+03, 9.1486760478E-01],
	[2.87650E+04, 1.6809387068E+04, 5.0381983435E+03, 4.9984512101E+03, 2.1832335981E+03, 9.1490895778E-01],
	[2.87700E+04, 1.6814174473E+04, 5.0381574180E+03, 5.0012584576E+03, 2.1838420816E+03, 9.1495028926E-01],
	[2.87750E+04, 1.6818962410E+04, 5.0381165000E+03, 5.0040667922E+03, 2.1844504746E+03, 9.1499159921E-01],
	[2.87800E+04, 1.6823750878E+04, 5.0380755894E+03, 5.0068762143E+03, 2.1850587769E+03, 9.1503288766E-01],
	[2.87850E+04, 1.6828539877E+04, 5.0380346862E+03, 5.0096867239E+03, 2.1856669886E+03, 9.1507415461E-01],
	[2.87900E+04, 1.6833329407E+04, 5.0379937905E+03, 5.0124983215E+03, 2.1862751096E+03, 9.1511540007E-01],
	[2.87950E+04, 1.6838119468E+04, 5.0379529022E+03, 5.0153110071E+03, 2.1868831398E+03, 9.1515662406E-01],
	[2.88000E+04, 1.6842910060E+04, 5.0379120213E+03, 5.0181247811E+03, 2.1874910792E+03, 9.1519782657E-01],
	[2.88050E+04, 1.6847701183E+04, 5.0378711479E+03, 5.0209396436E+03, 2.1880989276E+03, 9.1523900763E-01],
	[2.88100E+04, 1.6852492837E+04, 5.0378302819E+03, 5.0237555949E+03, 2.1887066852E+03, 9.1528016723E-01],
	[2.88150E+04, 1.6857285022E+04, 5.0377894233E+03, 5.0265726352E+03, 2.1893143518E+03, 9.1532130540E-01],
	[2.88200E+04, 1.6862077738E+04, 5.0377485721E+03, 5.0293907648E+03, 2.1899219273E+03, 9.1536242214E-01],
	[2.88250E+04, 1.6866870985E+04, 5.0377077284E+03, 5.0322099838E+03, 2.1905294117E+03, 9.1540351745E-01],
	[2.88300E+04, 1.6871664762E+04, 5.0376668921E+03, 5.0350302926E+03, 2.1911368050E+03, 9.1544459136E-01],
	[2.88350E+04, 1.6876459070E+04, 5.0376260631E+03, 5.0378516913E+03, 2.1917441071E+03, 9.1548564387E-01],
	[2.88400E+04, 1.6881253909E+04, 5.0375852416E+03, 5.0406741802E+03, 2.1923513180E+03, 9.1552667499E-01],
	[2.88450E+04, 1.6886049279E+04, 5.0375444275E+03, 5.0434977595E+03, 2.1929584376E+03, 9.1556768474E-01],
	[2.88500E+04, 1.6890845180E+04, 5.0375036208E+03, 5.0463224294E+03, 2.1935654658E+03, 9.1560867311E-01],
	[2.88550E+04, 1.6895641611E+04, 5.0374628215E+03, 5.0491481902E+03, 2.1941724025E+03, 9.1564964012E-01],
	[2.88600E+04, 1.6900438572E+04, 5.0374220296E+03, 5.0519750421E+03, 2.1947792479E+03, 9.1569058578E-01],
	[2.88650E+04, 1.6905236065E+04, 5.0373812451E+03, 5.0548029853E+03, 2.1953860017E+03, 9.1573151011E-01],
	[2.88700E+04, 1.6910034088E+04, 5.0373404680E+03, 5.0576320201E+03, 2.1959926640E+03, 9.1577241310E-01],
	[2.88750E+04, 1.6914832641E+04, 5.0372996983E+03, 5.0604621467E+03, 2.1965992346E+03, 9.1581329478E-01],
	[2.88800E+04, 1.6919631725E+04, 5.0372589360E+03, 5.0632933653E+03, 2.1972057136E+03, 9.1585415514E-01],
	[2.88850E+04, 1.6924431339E+04, 5.0372181811E+03, 5.0661256762E+03, 2.1978121008E+03, 9.1589499421E-01],
	[2.88900E+04, 1.6929231484E+04, 5.0371774335E+03, 5.0689590795E+03, 2.1984183963E+03, 9.1593581199E-01],
	[2.88950E+04, 1.6934032159E+04, 5.0371366933E+03, 5.0717935756E+03, 2.1990246000E+03, 9.1597660848E-01],
	[2.89000E+04, 1.6938833364E+04, 5.0370959606E+03, 5.0746291647E+03, 2.1996307117E+03, 9.1601738371E-01],
	[2.89050E+04, 1.6943635100E+04, 5.0370552351E+03, 5.0774658469E+03, 2.2002367316E+03, 9.1605813768E-01],
	[2.89100E+04, 1.6948437366E+04, 5.0370145171E+03, 5.0803036225E+03, 2.2008426595E+03, 9.1609887040E-01],
	[2.89150E+04, 1.6953240162E+04, 5.0369738064E+03, 5.0831424918E+03, 2.2014484953E+03, 9.1613958188E-01],
	[2.89200E+04, 1.6958043489E+04, 5.0369331031E+03, 5.0859824550E+03, 2.2020542391E+03, 9.1618027212E-01],
	[2.89250E+04, 1.6962847346E+04, 5.0368924072E+03, 5.0888235122E+03, 2.2026598907E+03, 9.1622094115E-01],
	[2.89300E+04, 1.6967651732E+04, 5.0368517186E+03, 5.0916656639E+03, 2.2032654501E+03, 9.1626158897E-01],
	[2.89350E+04, 1.6972456649E+04, 5.0368110374E+03, 5.0945089101E+03, 2.2038709173E+03, 9.1630221559E-01],
	[2.89400E+04, 1.6977262096E+04, 5.0367703635E+03, 5.0973532511E+03, 2.2044762923E+03, 9.1634282102E-01],
	[2.89450E+04, 1.6982068074E+04, 5.0367296970E+03, 5.1001986871E+03, 2.2050815748E+03, 9.1638340527E-01],
	[2.89500E+04, 1.6986874581E+04, 5.0366890379E+03, 5.1030452184E+03, 2.2056867650E+03, 9.1642396835E-01],
	[2.89550E+04, 1.6991681618E+04, 5.0366483861E+03, 5.1058928452E+03, 2.2062918627E+03, 9.1646451027E-01],
	[2.89600E+04, 1.6996489185E+04, 5.0366077416E+03, 5.1087415677E+03, 2.2068968680E+03, 9.1650503105E-01],
	[2.89650E+04, 1.7001297282E+04, 5.0365671045E+03, 5.1115913862E+03, 2.2075017807E+03, 9.1654553068E-01],
	[2.89700E+04, 1.7006105909E+04, 5.0365264747E+03, 5.1144423009E+03, 2.2081066008E+03, 9.1658600918E-01],
	[2.89750E+04, 1.7010915065E+04, 5.0364858523E+03, 5.1172943120E+03, 2.2087113282E+03, 9.1662646656E-01],
	[2.89800E+04, 1.7015724752E+04, 5.0364452372E+03, 5.1201474198E+03, 2.2093159630E+03, 9.1666690283E-01],
	[2.89850E+04, 1.7020534968E+04, 5.0364046294E+03, 5.1230016245E+03, 2.2099205050E+03, 9.1670731801E-01],
	[2.89900E+04, 1.7025345714E+04, 5.0363640290E+03, 5.1258569263E+03, 2.2105249542E+03, 9.1674771209E-01],
	[2.89950E+04, 1.7030156990E+04, 5.0363234359E+03, 5.1287133254E+03, 2.2111293106E+03, 9.1678808510E-01],
	[2.90000E+04, 1.7034968796E+04, 5.0362828502E+03, 5.1315708221E+03, 2.2117335741E+03, 9.1682843703E-01],
	[2.90050E+04, 1.7039781131E+04, 5.0362422717E+03, 5.1344294167E+03, 2.2123377446E+03, 9.1686876791E-01],
	[2.90100E+04, 1.7044593996E+04, 5.0362017006E+03, 5.1372891093E+03, 2.2129418221E+03, 9.1690907773E-01],
	[2.90150E+04, 1.7049407390E+04, 5.0361611368E+03, 5.1401499001E+03, 2.2135458065E+03, 9.1694936652E-01],
	[2.90200E+04, 1.7054221314E+04, 5.0361205803E+03, 5.1430117895E+03, 2.2141496979E+03, 9.1698963428E-01],
	[2.90250E+04, 1.7059035767E+04, 5.0360800311E+03, 5.1458747776E+03, 2.2147534961E+03, 9.1702988101E-01],
	[2.90300E+04, 1.7063850750E+04, 5.0360394892E+03, 5.1487388647E+03, 2.2153572011E+03, 9.1707010674E-01],
	[2.90350E+04, 1.7068666263E+04, 5.0359989547E+03, 5.1516040510E+03, 2.2159608128E+03, 9.1711031147E-01],
	[2.90400E+04, 1.7073482304E+04, 5.0359584274E+03, 5.1544703368E+03, 2.2165643313E+03, 9.1715049521E-01],
	[2.90450E+04, 1.7078298876E+04, 5.0359179075E+03, 5.1573377222E+03, 2.2171677564E+03, 9.1719065797E-01],
	[2.90500E+04, 1.7083115976E+04, 5.0358773948E+03, 5.1602062075E+03, 2.2177710881E+03, 9.1723079976E-01],
	[2.90550E+04, 1.7087933606E+04, 5.0358368895E+03, 5.1630757930E+03, 2.2183743263E+03, 9.1727092059E-01],
	[2.90600E+04, 1.7092751765E+04, 5.0357963914E+03, 5.1659464788E+03, 2.2189774710E+03, 9.1731102048E-01],
	[2.90650E+04, 1.7097570454E+04, 5.0357559007E+03, 5.1688182652E+03, 2.2195805222E+03, 9.1735109942E-01],
	[2.90700E+04, 1.7102389671E+04, 5.0357154172E+03, 5.1716911525E+03, 2.2201834798E+03, 9.1739115744E-01],
	[2.90750E+04, 1.7107209418E+04, 5.0356749410E+03, 5.1745651408E+03, 2.2207863437E+03, 9.1743119453E-01],
	[2.90800E+04, 1.7112029694E+04, 5.0356344721E+03, 5.1774402304E+03, 2.2213891140E+03, 9.1747121072E-01],
	[2.90850E+04, 1.7116850499E+04, 5.0355940105E+03, 5.1803164215E+03, 2.2219917904E+03, 9.1751120601E-01],
	[2.90900E+04, 1.7121671834E+04, 5.0355535562E+03, 5.1831937144E+03, 2.2225943731E+03, 9.1755118041E-01],
	[2.90950E+04, 1.7126493697E+04, 5.0355131091E+03, 5.1860721093E+03, 2.2231968619E+03, 9.1759113393E-01],
	[2.91000E+04, 1.7131316089E+04, 5.0354726693E+03, 5.1889516064E+03, 2.2237992569E+03, 9.1763106658E-01],
	[2.91050E+04, 1.7136139011E+04, 5.0354322368E+03, 5.1918322059E+03, 2.2244015578E+03, 9.1767097837E-01],
	[2.91100E+04, 1.7140962461E+04, 5.0353918116E+03, 5.1947139082E+03, 2.2250037648E+03, 9.1771086932E-01],
	[2.91150E+04, 1.7145786440E+04, 5.0353513936E+03, 5.1975967133E+03, 2.2256058778E+03, 9.1775073943E-01],
	[2.91200E+04, 1.7150610948E+04, 5.0353109829E+03, 5.2004806216E+03, 2.2262078966E+03, 9.1779058870E-01],
	[2.91250E+04, 1.7155435985E+04, 5.0352705795E+03, 5.2033656333E+03, 2.2268098213E+03, 9.1783041716E-01],
	[2.91300E+04, 1.7160261551E+04, 5.0352301833E+03, 5.2062517486E+03, 2.2274116518E+03, 9.1787022481E-01],
	[2.91350E+04, 1.7165087646E+04, 5.0351897944E+03, 5.2091389677E+03, 2.2280133880E+03, 9.1791001167E-01],
	[2.91400E+04, 1.7169914269E+04, 5.0351494127E+03, 5.2120272909E+03, 2.2286150300E+03, 9.1794977773E-01],
	[2.91450E+04, 1.7174741421E+04, 5.0351090383E+03, 5.2149167184E+03, 2.2292165776E+03, 9.1798952302E-01],
	[2.91500E+04, 1.7179569102E+04, 5.0350686711E+03, 5.2178072505E+03, 2.2298180309E+03, 9.1802924754E-01],
	[2.91550E+04, 1.7184397312E+04, 5.0350283112E+03, 5.2206988873E+03, 2.2304193897E+03, 9.1806895130E-01],
	[2.91600E+04, 1.7189226050E+04, 5.0349879585E+03, 5.2235916292E+03, 2.2310206540E+03, 9.1810863431E-01],
	[2.91650E+04, 1.7194055316E+04, 5.0349476131E+03, 5.2264854762E+03, 2.2316218238E+03, 9.1814829659E-01],
	[2.91700E+04, 1.7198885112E+04, 5.0349072749E+03, 5.2293804288E+03, 2.2322228990E+03, 9.1818793813E-01],
	[2.91750E+04, 1.7203715436E+04, 5.0348669439E+03, 5.2322764870E+03, 2.2328238795E+03, 9.1822755896E-01],
	[2.91800E+04, 1.7208546288E+04, 5.0348266202E+03, 5.2351736512E+03, 2.2334247654E+03, 9.1826715909E-01],
	[2.91850E+04, 1.7213377669E+04, 5.0347863037E+03, 5.2380719215E+03, 2.2340255566E+03, 9.1830673851E-01],
	[2.91900E+04, 1.7218209578E+04, 5.0347459944E+03, 5.2409712982E+03, 2.2346262530E+03, 9.1834629725E-01],
	[2.91950E+04, 1.7223042016E+04, 5.0347056924E+03, 5.2438717816E+03, 2.2352268545E+03, 9.1838583531E-01],
	[2.92000E+04, 1.7227874982E+04, 5.0346653976E+03, 5.2467733718E+03, 2.2358273612E+03, 9.1842535270E-01],
	[2.92050E+04, 1.7232708476E+04, 5.0346251100E+03, 5.2496760691E+03, 2.2364277730E+03, 9.1846484944E-01],
	[2.92100E+04, 1.7237542499E+04, 5.0345848296E+03, 5.2525798738E+03, 2.2370280898E+03, 9.1850432552E-01],
	[2.92150E+04, 1.7242377050E+04, 5.0345445564E+03, 5.2554847859E+03, 2.2376283115E+03, 9.1854378097E-01],
	[2.92200E+04, 1.7247212129E+04, 5.0345042905E+03, 5.2583908059E+03, 2.2382284383E+03, 9.1858321580E-01],
	[2.92250E+04, 1.7252047736E+04, 5.0344640318E+03, 5.2612979339E+03, 2.2388284699E+03, 9.1862263001E-01],
	[2.92300E+04, 1.7256883872E+04, 5.0344237802E+03, 5.2642061702E+03, 2.2394284063E+03, 9.1866202361E-01],
	[2.92350E+04, 1.7261720536E+04, 5.0343835359E+03, 5.2671155149E+03, 2.2400282476E+03, 9.1870139661E-01],
	[2.92400E+04, 1.7266557727E+04, 5.0343432988E+03, 5.2700259684E+03, 2.2406279935E+03, 9.1874074903E-01],
	[2.92450E+04, 1.7271395447E+04, 5.0343030689E+03, 5.2729375308E+03, 2.2412276442E+03, 9.1878008087E-01],
	[2.92500E+04, 1.7276233695E+04, 5.0342628462E+03, 5.2758502023E+03, 2.2418271996E+03, 9.1881939214E-01],
	[2.92550E+04, 1.7281072471E+04, 5.0342226307E+03, 5.2787639833E+03, 2.2424266595E+03, 9.1885868286E-01],
	[2.92600E+04, 1.7285911775E+04, 5.0341824223E+03, 5.2816788740E+03, 2.2430260240E+03, 9.1889795303E-01],
	[2.92650E+04, 1.7290751607E+04, 5.0341422212E+03, 5.2845948745E+03, 2.2436252930E+03, 9.1893720267E-01],
	[2.92700E+04, 1.7295591967E+04, 5.0341020273E+03, 5.2875119851E+03, 2.2442244665E+03, 9.1897643178E-01],
	[2.92750E+04, 1.7300432855E+04, 5.0340618405E+03, 5.2904302061E+03, 2.2448235443E+03, 9.1901564037E-01],
	[2.92800E+04, 1.7305274270E+04, 5.0340216609E+03, 5.2933495376E+03, 2.2454225266E+03, 9.1905482846E-01],
	[2.92850E+04, 1.7310116214E+04, 5.0339814885E+03, 5.2962699799E+03, 2.2460214131E+03, 9.1909399605E-01],
	[2.92900E+04, 1.7314958685E+04, 5.0339413233E+03, 5.2991915333E+03, 2.2466202040E+03, 9.1913314316E-01],
	[2.92950E+04, 1.7319801684E+04, 5.0339011653E+03, 5.3021141980E+03, 2.2472188991E+03, 9.1917226979E-01],
	[2.93000E+04, 1.7324645210E+04, 5.0338610144E+03, 5.3050379741E+03, 2.2478174983E+03, 9.1921137596E-01],
	[2.93050E+04, 1.7329489265E+04, 5.0338208707E+03, 5.3079628620E+03, 2.2484160017E+03, 9.1925046167E-01],
	[2.93100E+04, 1.7334333847E+04, 5.0337807342E+03, 5.3108888619E+03, 2.2490144092E+03, 9.1928952693E-01],
	[2.93150E+04, 1.7339178956E+04, 5.0337406049E+03, 5.3138159739E+03, 2.2496127207E+03, 9.1932857176E-01],
	[2.93200E+04, 1.7344024594E+04, 5.0337004827E+03, 5.3167441984E+03, 2.2502109362E+03, 9.1936759617E-01],
	[2.93250E+04, 1.7348870758E+04, 5.0336603676E+03, 5.3196735356E+03, 2.2508090556E+03, 9.1940660016E-01],
	[2.93300E+04, 1.7353717451E+04, 5.0336202598E+03, 5.3226039856E+03, 2.2514070790E+03, 9.1944558375E-01],
	[2.93350E+04, 1.7358564670E+04, 5.0335801590E+03, 5.3255355488E+03, 2.2520050062E+03, 9.1948454694E-01],
	[2.93400E+04, 1.7363412418E+04, 5.0335400655E+03, 5.3284682253E+03, 2.2526028372E+03, 9.1952348974E-01],
	[2.93450E+04, 1.7368260692E+04, 5.0334999791E+03, 5.3314020155E+03, 2.2532005719E+03, 9.1956241217E-01],
	[2.93500E+04, 1.7373109494E+04, 5.0334598998E+03, 5.3343369194E+03, 2.2537982104E+03, 9.1960131424E-01],
	[2.93550E+04, 1.7377958824E+04, 5.0334198277E+03, 5.3372729374E+03, 2.2543957526E+03, 9.1964019595E-01],
	[2.93600E+04, 1.7382831353E+04, 5.0333844606E+03, 5.3402100697E+03, 2.2549945228E+03, 9.1967905732E-01],
	[2.93650E+04, 1.7387726007E+04, 5.0333535717E+03, 5.3431483166E+03, 2.2555944590E+03, 9.1971789836E-01],
	[2.93700E+04, 1.7392621205E+04, 5.0333226882E+03, 5.3460876781E+03, 2.2561943005E+03, 9.1975671907E-01],
	[2.93750E+04, 1.7397516948E+04, 5.0332918102E+03, 5.3490281547E+03, 2.2567940475E+03, 9.1979551947E-01],
	[2.93800E+04, 1.7402413235E+04, 5.0332609376E+03, 5.3519697465E+03, 2.2573936999E+03, 9.1983429956E-01],
	[2.93850E+04, 1.7407310067E+04, 5.0332300705E+03, 5.3549124537E+03, 2.2579932575E+03, 9.1987305936E-01],
	[2.93900E+04, 1.7412207443E+04, 5.0331992087E+03, 5.3578562766E+03, 2.2585927204E+03, 9.1991179888E-01],
	[2.93950E+04, 1.7417105363E+04, 5.0331683525E+03, 5.3608012155E+03, 2.2591920885E+03, 9.1995051812E-01],
	[2.94000E+04, 1.7422003828E+04, 5.0331375017E+03, 5.3637472705E+03, 2.2597913618E+03, 9.1998921710E-01],
	[2.94050E+04, 1.7426902837E+04, 5.0331066563E+03, 5.3666944418E+03, 2.2603905402E+03, 9.2002789582E-01],
	[2.94100E+04, 1.7431802390E+04, 5.0330758163E+03, 5.3696427298E+03, 2.2609896237E+03, 9.2006655431E-01],
	[2.94150E+04, 1.7436702488E+04, 5.0330449818E+03, 5.3725921346E+03, 2.2615886122E+03, 9.2010519256E-01],
	[2.94200E+04, 1.7441603129E+04, 5.0330141527E+03, 5.3755426565E+03, 2.2621875057E+03, 9.2014381059E-01],
	[2.94250E+04, 1.7446504315E+04, 5.0329833290E+03, 5.3784942957E+03, 2.2627863041E+03, 9.2018240840E-01],
	[2.94300E+04, 1.7451406045E+04, 5.0329525107E+03, 5.3814470525E+03, 2.2633850074E+03, 9.2022098601E-01],
	[2.94350E+04, 1.7456308320E+04, 5.0329216979E+03, 5.3844009270E+03, 2.2639836156E+03, 9.2025954343E-01],
	[2.94400E+04, 1.7461211138E+04, 5.0328908905E+03, 5.3873559196E+03, 2.2645821286E+03, 9.2029808067E-01],
	[2.94450E+04, 1.7466114500E+04, 5.0328600885E+03, 5.3903120303E+03, 2.2651805463E+03, 9.2033659774E-01],
	[2.94500E+04, 1.7471018407E+04, 5.0328292920E+03, 5.3932692596E+03, 2.2657788688E+03, 9.2037509464E-01],
	[2.94550E+04, 1.7475922857E+04, 5.0327985008E+03, 5.3962276075E+03, 2.2663770959E+03, 9.2041357139E-01],
	[2.94600E+04, 1.7480827852E+04, 5.0327677151E+03, 5.3991870744E+03, 2.2669752276E+03, 9.2045202800E-01],
	[2.94650E+04, 1.7485733390E+04, 5.0327369348E+03, 5.4021476605E+03, 2.2675732640E+03, 9.2049046448E-01],
	[2.94700E+04, 1.7490639472E+04, 5.0327061599E+03, 5.4051093660E+03, 2.2681712048E+03, 9.2052888083E-01],
	[2.94750E+04, 1.7495546098E+04, 5.0326753904E+03, 5.4080721911E+03, 2.2687690501E+03, 9.2056727708E-01],
	[2.94800E+04, 1.7500453268E+04, 5.0326446263E+03, 5.4110361360E+03, 2.2693667999E+03, 9.2060565322E-01],
	[2.94850E+04, 1.7505360982E+04, 5.0326138676E+03, 5.4140012011E+03, 2.2699644541E+03, 9.2064400927E-01],
	[2.94900E+04, 1.7510269239E+04, 5.0325831143E+03, 5.4169673865E+03, 2.2705620126E+03, 9.2068234524E-01],
	[2.94950E+04, 1.7515178040E+04, 5.0325523664E+03, 5.4199346925E+03, 2.2711594755E+03, 9.2072066114E-01],
	[2.95000E+04, 1.7520087385E+04, 5.0325216240E+03, 5.4229031193E+03, 2.2717568426E+03, 9.2075895698E-01],
	[2.95050E+04, 1.7524997274E+04, 5.0324908869E+03, 5.4258726671E+03, 2.2723541139E+03, 9.2079723277E-01],
	[2.95100E+04, 1.7529907706E+04, 5.0324601552E+03, 5.4288433361E+03, 2.2729512894E+03, 9.2083548851E-01],
	[2.95150E+04, 1.7534818682E+04, 5.0324294289E+03, 5.4318151267E+03, 2.2735483690E+03, 9.2087372423E-01],
	[2.95200E+04, 1.7539730201E+04, 5.0323987080E+03, 5.4347880390E+03, 2.2741453527E+03, 9.2091193992E-01],
	[2.95250E+04, 1.7544642264E+04, 5.0323679925E+03, 5.4377620732E+03, 2.2747422404E+03, 9.2095013561E-01],
	[2.95300E+04, 1.7549554871E+04, 5.0323372824E+03, 5.4407372296E+03, 2.2753390322E+03, 9.2098831129E-01],
	[2.95350E+04, 1.7554468021E+04, 5.0323065776E+03, 5.4437135085E+03, 2.2759357278E+03, 9.2102646699E-01],
	[2.95400E+04, 1.7559381714E+04, 5.0322758783E+03, 5.4466909100E+03, 2.2765323274E+03, 9.2106460270E-01],
	[2.95450E+04, 1.7564295951E+04, 5.0322451843E+03, 5.4496694345E+03, 2.2771288309E+03, 9.2110271845E-01],
	[2.95500E+04, 1.7569210731E+04, 5.0322144957E+03, 5.4526490820E+03, 2.2777252382E+03, 9.2114081423E-01],
	[2.95550E+04, 1.7574126055E+04, 5.0321838125E+03, 5.4556298529E+03, 2.2783215492E+03, 9.2117889007E-01],
	[2.95600E+04, 1.7579041921E+04, 5.0321531347E+03, 5.4586117474E+03, 2.2789177640E+03, 9.2121694597E-01],
	[2.95650E+04, 1.7583958332E+04, 5.0321224622E+03, 5.4615947657E+03, 2.2795138825E+03, 9.2125498193E-01],
	[2.95700E+04, 1.7588875285E+04, 5.0320917952E+03, 5.4645789080E+03, 2.2801099046E+03, 9.2129299798E-01],
	[2.95750E+04, 1.7593792782E+04, 5.0320611335E+03, 5.4675641747E+03, 2.2807058303E+03, 9.2133099412E-01],
	[2.95800E+04, 1.7598710822E+04, 5.0320304771E+03, 5.4705505659E+03, 2.2813016596E+03, 9.2136897036E-01],
	[2.95850E+04, 1.7603629405E+04, 5.0319998262E+03, 5.4735380818E+03, 2.2818973924E+03, 9.2140692671E-01],
	[2.95900E+04, 1.7608548531E+04, 5.0319691806E+03, 5.4765267227E+03, 2.2824930286E+03, 9.2144486318E-01],
	[2.95950E+04, 1.7613468200E+04, 5.0319385403E+03, 5.4795164888E+03, 2.2830885683E+03, 9.2148277978E-01],
	[2.96000E+04, 1.7618388412E+04, 5.0319079054E+03, 5.4825073804E+03, 2.2836840114E+03, 9.2152067652E-01],
	[2.96050E+04, 1.7623309168E+04, 5.0318772759E+03, 5.4854993977E+03, 2.2842793578E+03, 9.2155855342E-01],
	[2.96100E+04, 1.7628230466E+04, 5.0318466518E+03, 5.4884925408E+03, 2.2848746075E+03, 9.2159641048E-01],
	[2.96150E+04, 1.7633152307E+04, 5.0318160330E+03, 5.4914868102E+03, 2.2854697604E+03, 9.2163424770E-01],
	[2.96200E+04, 1.7638074691E+04, 5.0317854195E+03, 5.4944822059E+03, 2.2860648166E+03, 9.2167206512E-01],
	[2.96250E+04, 1.7642997619E+04, 5.0317548114E+03, 5.4974787282E+03, 2.2866597759E+03, 9.2170986272E-01],
	[2.96300E+04, 1.7647921089E+04, 5.0317242087E+03, 5.5004763774E+03, 2.2872546383E+03, 9.2174764052E-01],
	[2.96350E+04, 1.7652845102E+04, 5.0316936113E+03, 5.5034751536E+03, 2.2878494039E+03, 9.2178539854E-01],
	[2.96400E+04, 1.7657769657E+04, 5.0316630193E+03, 5.5064750572E+03, 2.2884440724E+03, 9.2182313678E-01],
	[2.96450E+04, 1.7662694756E+04, 5.0316324326E+03, 5.5094760883E+03, 2.2890386440E+03, 9.2186085525E-01],
	[2.96500E+04, 1.7667620397E+04, 5.0316018512E+03, 5.5124782472E+03, 2.2896331185E+03, 9.2189855397E-01],
	[2.96550E+04, 1.7672546581E+04, 5.0315712752E+03, 5.5154815341E+03, 2.2902274959E+03, 9.2193623293E-01],
	[2.96600E+04, 1.7677473307E+04, 5.0315407046E+03, 5.5184859492E+03, 2.2908217761E+03, 9.2197389216E-01],
	[2.96650E+04, 1.7682400577E+04, 5.0315101392E+03, 5.5214914928E+03, 2.2914159592E+03, 9.2201153166E-01],
	[2.96700E+04, 1.7687328389E+04, 5.0314795792E+03, 5.5244981652E+03, 2.2920100451E+03, 9.2204915145E-01],
	[2.96750E+04, 1.7692256743E+04, 5.0314490246E+03, 5.5275059664E+03, 2.2926040337E+03, 9.2208675153E-01],
	[2.96800E+04, 1.7697185640E+04, 5.0314184753E+03, 5.5305148969E+03, 2.2931979250E+03, 9.2212433191E-01],
	[2.96850E+04, 1.7702115080E+04, 5.0313879313E+03, 5.5335249567E+03, 2.2937917190E+03, 9.2216189261E-01],
	[2.96900E+04, 1.7707045062E+04, 5.0313573926E+03, 5.5365361462E+03, 2.2943854156E+03, 9.2219943363E-01],
	[2.96950E+04, 1.7711975586E+04, 5.0313268593E+03, 5.5395484656E+03, 2.2949790147E+03, 9.2223695498E-01],
	[2.97000E+04, 1.7716906653E+04, 5.0312963313E+03, 5.5425619151E+03, 2.2955725163E+03, 9.2227445667E-01],
	[2.97050E+04, 1.7721838263E+04, 5.0312658086E+03, 5.5455764949E+03, 2.2961659205E+03, 9.2231193872E-01],
	[2.97100E+04, 1.7726770415E+04, 5.0312352912E+03, 5.5485922053E+03, 2.2967592271E+03, 9.2234940114E-01],
	[2.97150E+04, 1.7731703109E+04, 5.0312047792E+03, 5.5516090465E+03, 2.2973524360E+03, 9.2238684393E-01],
	[2.97200E+04, 1.7736636345E+04, 5.0311742725E+03, 5.5546270187E+03, 2.2979455474E+03, 9.2242426710E-01],
	[2.97250E+04, 1.7741570124E+04, 5.0311437711E+03, 5.5576461222E+03, 2.2985385610E+03, 9.2246167066E-01],
	[2.97300E+04, 1.7746504445E+04, 5.0311132750E+03, 5.5606663573E+03, 2.2991314769E+03, 9.2249905463E-01],
	[2.97350E+04, 1.7751439308E+04, 5.0310827842E+03, 5.5636877240E+03, 2.2997242951E+03, 9.2253641902E-01],
	[2.97400E+04, 1.7756374713E+04, 5.0310522987E+03, 5.5667102227E+03, 2.3003170154E+03, 9.2257376383E-01],
	[2.97450E+04, 1.7761310660E+04, 5.0310218186E+03, 5.5697338537E+03, 2.3009096379E+03, 9.2261108907E-01],
	[2.97500E+04, 1.7766247150E+04, 5.0309913437E+03, 5.5727586170E+03, 2.3015021625E+03, 9.2264839476E-01],
	[2.97550E+04, 1.7771184182E+04, 5.0309608742E+03, 5.5757845131E+03, 2.3020945892E+03, 9.2268568090E-01],
	[2.97600E+04, 1.7776121755E+04, 5.0309304099E+03, 5.5788115420E+03, 2.3026869179E+03, 9.2272294751E-01],
	[2.97650E+04, 1.7781059871E+04, 5.0308999510E+03, 5.5818397041E+03, 2.3032791485E+03, 9.2276019460E-01],
	[2.97700E+04, 1.7785998529E+04, 5.0308694974E+03, 5.5848689995E+03, 2.3038712811E+03, 9.2279742217E-01],
	[2.97750E+04, 1.7790937729E+04, 5.0308390490E+03, 5.5878994285E+03, 2.3044633156E+03, 9.2283463023E-01],
	[2.97800E+04, 1.7795877470E+04, 5.0308086060E+03, 5.5909309914E+03, 2.3050552520E+03, 9.2287181880E-01],
	[2.97850E+04, 1.7800817754E+04, 5.0307781683E+03, 5.5939636884E+03, 2.3056470901E+03, 9.2290898789E-01],
	[2.97900E+04, 1.7805758579E+04, 5.0307477358E+03, 5.5969975196E+03, 2.3062388301E+03, 9.2294613750E-01],
	[2.97950E+04, 1.7810699946E+04, 5.0307173086E+03, 5.6000324854E+03, 2.3068304718E+03, 9.2298326764E-01],
	[2.98000E+04, 1.7815641855E+04, 5.0306868868E+03, 5.6030685859E+03, 2.3074220151E+03, 9.2302037833E-01],
	[2.98050E+04, 1.7820584306E+04, 5.0306564702E+03, 5.6061058215E+03, 2.3080134601E+03, 9.2305746958E-01],
	[2.98100E+04, 1.7825527298E+04, 5.0306260589E+03, 5.6091441922E+03, 2.3086048068E+03, 9.2309454140E-01],
	[2.98150E+04, 1.7830470833E+04, 5.0305956529E+03, 5.6121836985E+03, 2.3091960550E+03, 9.2313159379E-01],
	[2.98200E+04, 1.7835414909E+04, 5.0305652522E+03, 5.6152243404E+03, 2.3097872047E+03, 9.2316862676E-01],
	[2.98250E+04, 1.7840359526E+04, 5.0305348567E+03, 5.6182661183E+03, 2.3103782559E+03, 9.2320564034E-01],
	[2.98300E+04, 1.7845304685E+04, 5.0305044665E+03, 5.6213090323E+03, 2.3109692086E+03, 9.2324263451E-01],
	[2.98350E+04, 1.7850250386E+04, 5.0304740816E+03, 5.6243530828E+03, 2.3115600626E+03, 9.2327960931E-01],
	[2.98400E+04, 1.7855196628E+04, 5.0304437020E+03, 5.6273982699E+03, 2.3121508181E+03, 9.2331656473E-01],
	[2.98450E+04, 1.7860143412E+04, 5.0304133277E+03, 5.6304445938E+03, 2.3127414748E+03, 9.2335350079E-01],
	[2.98500E+04, 1.7865090737E+04, 5.0303829586E+03, 5.6334920548E+03, 2.3133320329E+03, 9.2339041750E-01],
	[2.98550E+04, 1.7870038604E+04, 5.0303525948E+03, 5.6365406532E+03, 2.3139224922E+03, 9.2342731486E-01],
	[2.98600E+04, 1.7874987012E+04, 5.0303222363E+03, 5.6395903891E+03, 2.3145128526E+03, 9.2346419289E-01],
	[2.98650E+04, 1.7879935962E+04, 5.0302918830E+03, 5.6426412628E+03, 2.3151031143E+03, 9.2350105159E-01],
	[2.98700E+04, 1.7884885453E+04, 5.0302615350E+03, 5.6456932746E+03, 2.3156932771E+03, 9.2353789099E-01],
	[2.98750E+04, 1.7889835485E+04, 5.0302311923E+03, 5.6487464246E+03, 2.3162833409E+03, 9.2357471108E-01],
	[2.98800E+04, 1.7894786058E+04, 5.0302008548E+03, 5.6518007131E+03, 2.3168733058E+03, 9.2361151187E-01],
	[2.98850E+04, 1.7899737173E+04, 5.0301705225E+03, 5.6548561404E+03, 2.3174631717E+03, 9.2364829339E-01],
	[2.98900E+04, 1.7904688829E+04, 5.0301401956E+03, 5.6579127066E+03, 2.3180529386E+03, 9.2368505563E-01],
	[2.98950E+04, 1.7909641026E+04, 5.0301098739E+03, 5.6609704120E+03, 2.3186426064E+03, 9.2372179861E-01],
	[2.99000E+04, 1.7914593765E+04, 5.0300795574E+03, 5.6640292568E+03, 2.3192321751E+03, 9.2375852234E-01],
	[2.99050E+04, 1.7919547044E+04, 5.0300492462E+03, 5.6670892413E+03, 2.3198216446E+03, 9.2379522682E-01],
	[2.99100E+04, 1.7924500865E+04, 5.0300189403E+03, 5.6701503657E+03, 2.3204110149E+03, 9.2383191207E-01],
	[2.99150E+04, 1.7929455227E+04, 5.0299886396E+03, 5.6732126303E+03, 2.3210002860E+03, 9.2386857810E-01],
	[2.99200E+04, 1.7934410130E+04, 5.0299583441E+03, 5.6762760352E+03, 2.3215894578E+03, 9.2390522492E-01],
	[2.99250E+04, 1.7939365573E+04, 5.0299280539E+03, 5.6793405807E+03, 2.3221785302E+03, 9.2394185254E-01],
	[2.99300E+04, 1.7944321558E+04, 5.0298977689E+03, 5.6824062670E+03, 2.3227675034E+03, 9.2397846096E-01],
	[2.99350E+04, 1.7949278084E+04, 5.0298674892E+03, 5.6854730943E+03, 2.3233563771E+03, 9.2401505021E-01],
	[2.99400E+04, 1.7954235150E+04, 5.0298372147E+03, 5.6885410630E+03, 2.3239451514E+03, 9.2405162028E-01],
	[2.99450E+04, 1.7959192758E+04, 5.0298069454E+03, 5.6916101732E+03, 2.3245338262E+03, 9.2408817118E-01],
	[2.99500E+04, 1.7964150906E+04, 5.0297766814E+03, 5.6946804252E+03, 2.3251224016E+03, 9.2412470294E-01],
	[2.99550E+04, 1.7969109596E+04, 5.0297464226E+03, 5.6977518192E+03, 2.3257108773E+03, 9.2416121556E-01],
	[2.99600E+04, 1.7974068826E+04, 5.0297161691E+03, 5.7008243554E+03, 2.3262992535E+03, 9.2419770904E-01],
	[2.99650E+04, 1.7979028596E+04, 5.0296859208E+03, 5.7038980340E+03, 2.3268875300E+03, 9.2423418340E-01],
	[2.99700E+04, 1.7983988908E+04, 5.0296556777E+03, 5.7069728554E+03, 2.3274757069E+03, 9.2427063866E-01],
	[2.99750E+04, 1.7988949760E+04, 5.0296254398E+03, 5.7100488196E+03, 2.3280637841E+03, 9.2430707480E-01],
	[2.99800E+04, 1.7993911153E+04, 5.0295952072E+03, 5.7131259271E+03, 2.3286517615E+03, 9.2434349186E-01],
	[2.99850E+04, 1.7998873087E+04, 5.0295649798E+03, 5.7162041779E+03, 2.3292396391E+03, 9.2437988984E-01],
	[2.99900E+04, 1.8003835561E+04, 5.0295347576E+03, 5.7192835724E+03, 2.3298274169E+03, 9.2441626875E-01],
	[2.99950E+04, 1.8008798575E+04, 5.0295045406E+03, 5.7223641107E+03, 2.3304150948E+03, 9.2445262859E-01],
	[3.00000E+04, 1.8013762131E+04, 5.0294743288E+03, 5.7254457932E+03, 2.3310026729E+03, 9.2448896939E-01],
	[3.00050E+04, 1.8018726227E+04, 5.0294441223E+03, 5.7285388920E+03, 2.3315918526E+03, 9.2452529114E-01],
	[3.00100E+04, 1.8023690863E+04, 5.0294139210E+03, 5.7316331447E+03, 2.3321809320E+03, 9.2456159386E-01],
	[3.00150E+04, 1.8028656040E+04, 5.0293837249E+03, 5.7347285516E+03, 2.3327699110E+03, 9.2459787756E-01],
	[3.00200E+04, 1.8033621757E+04, 5.0293535340E+03, 5.7378251128E+03, 2.3333587895E+03, 9.2463414225E-01],
	[3.00250E+04, 1.8038588014E+04, 5.0293233483E+03, 5.7409228287E+03, 2.3339475674E+03, 9.2467038794E-01],
	[3.00300E+04, 1.8043554812E+04, 5.0292931678E+03, 5.7440216994E+03, 2.3345362449E+03, 9.2470661464E-01],
	[3.00350E+04, 1.8048522150E+04, 5.0292629925E+03, 5.7471217252E+03, 2.3351248218E+03, 9.2474282236E-01],
	[3.00400E+04, 1.8053490029E+04, 5.0292328224E+03, 5.7502229063E+03, 2.3357132980E+03, 9.2477901111E-01],
	[3.00450E+04, 1.8058458448E+04, 5.0292026575E+03, 5.7533252430E+03, 2.3363016736E+03, 9.2481518090E-01],
	[3.00500E+04, 1.8063427407E+04, 5.0291724979E+03, 5.7564287355E+03, 2.3368899485E+03, 9.2485133173E-01],
	[3.00550E+04, 1.8068396906E+04, 5.0291423434E+03, 5.7595333840E+03, 2.3374781226E+03, 9.2488746363E-01],
	[3.00600E+04, 1.8073366945E+04, 5.0291121941E+03, 5.7626391888E+03, 2.3380661960E+03, 9.2492357659E-01],
	[3.00650E+04, 1.8078337525E+04, 5.0290820500E+03, 5.7657461502E+03, 2.3386541686E+03, 9.2495967064E-01],
	[3.00700E+04, 1.8083308644E+04, 5.0290519112E+03, 5.7688542682E+03, 2.3392420403E+03, 9.2499574577E-01],
	[3.00750E+04, 1.8088280304E+04, 5.0290217775E+03, 5.7719635433E+03, 2.3398298111E+03, 9.2503180201E-01],
	[3.00800E+04, 1.8093252504E+04, 5.0289916489E+03, 5.7750739756E+03, 2.3404174810E+03, 9.2506783935E-01],
	[3.00850E+04, 1.8098225244E+04, 5.0289615256E+03, 5.7781855654E+03, 2.3410050500E+03, 9.2510385782E-01],
	[3.00900E+04, 1.8103198523E+04, 5.0289314075E+03, 5.7812983128E+03, 2.3415925179E+03, 9.2513985741E-01],
	[3.00950E+04, 1.8108172343E+04, 5.0289012945E+03, 5.7844122183E+03, 2.3421798848E+03, 9.2517583815E-01],
	[3.01000E+04, 1.8113146703E+04, 5.0288711868E+03, 5.7875272818E+03, 2.3427671506E+03, 9.2521180003E-01],
	[3.01050E+04, 1.8118121602E+04, 5.0288410842E+03, 5.7906435038E+03, 2.3433543153E+03, 9.2524774307E-01],
	[3.01100E+04, 1.8123097042E+04, 5.0288109868E+03, 5.7937608845E+03, 2.3439413788E+03, 9.2528366729E-01],
	[3.01150E+04, 1.8128073021E+04, 5.0287808946E+03, 5.7968794240E+03, 2.3445283412E+03, 9.2531957268E-01],
	[3.01200E+04, 1.8133049540E+04, 5.0287508075E+03, 5.7999991227E+03, 2.3451152023E+03, 9.2535545926E-01],
	[3.01250E+04, 1.8138026599E+04, 5.0287207256E+03, 5.8031199807E+03, 2.3457019621E+03, 9.2539132705E-01],
	[3.01300E+04, 1.8143004197E+04, 5.0286906489E+03, 5.8062419984E+03, 2.3462886207E+03, 9.2542717604E-01],
	[3.01350E+04, 1.8147982335E+04, 5.0286605774E+03, 5.8093651759E+03, 2.3468751779E+03, 9.2546300625E-01],
	[3.01400E+04, 1.8152961013E+04, 5.0286305110E+03, 5.8124895134E+03, 2.3474616337E+03, 9.2549881770E-01],
	[3.01450E+04, 1.8157940231E+04, 5.0286004498E+03, 5.8156150113E+03, 2.3480479881E+03, 9.2553461038E-01],
	[3.01500E+04, 1.8162919988E+04, 5.0285703938E+03, 5.8187416697E+03, 2.3486342410E+03, 9.2557038432E-01],
	[3.01550E+04, 1.8167900285E+04, 5.0285403429E+03, 5.8218694890E+03, 2.3492203924E+03, 9.2560613951E-01],
	[3.01600E+04, 1.8172881121E+04, 5.0285102972E+03, 5.8249984692E+03, 2.3498064423E+03, 9.2564187597E-01],
	[3.01650E+04, 1.8177862497E+04, 5.0284802567E+03, 5.8281286107E+03, 2.3503923907E+03, 9.2567759372E-01],
	[3.01700E+04, 1.8182844412E+04, 5.0284502213E+03, 5.8312599138E+03, 2.3509782374E+03, 9.2571329275E-01],
	[3.01750E+04, 1.8187826867E+04, 5.0284201910E+03, 5.8343923785E+03, 2.3515639825E+03, 9.2574897309E-01],
	[3.01800E+04, 1.8192809861E+04, 5.0283901660E+03, 5.8375260053E+03, 2.3521496259E+03, 9.2578463473E-01],
	[3.01850E+04, 1.8197793394E+04, 5.0283601460E+03, 5.8406607942E+03, 2.3527351676E+03, 9.2582027770E-01],
	[3.01900E+04, 1.8202777467E+04, 5.0283301313E+03, 5.8437967456E+03, 2.3533206075E+03, 9.2585590199E-01],
	[3.01950E+04, 1.8207762080E+04, 5.0283001217E+03, 5.8469338597E+03, 2.3539059457E+03, 9.2589150763E-01],
	[3.02000E+04, 1.8212747231E+04, 5.0282701172E+03, 5.8500721368E+03, 2.3544911820E+03, 9.2592709461E-01],
	[3.02050E+04, 1.8217732922E+04, 5.0282401178E+03, 5.8532115770E+03, 2.3550763164E+03, 9.2596266296E-01],
	[3.02100E+04, 1.8222719152E+04, 5.0282101237E+03, 5.8563521806E+03, 2.3556613490E+03, 9.2599821267E-01],
	[3.02150E+04, 1.8227705921E+04, 5.0281801346E+03, 5.8594939479E+03, 2.3562462796E+03, 9.2603374377E-01],
	[3.02200E+04, 1.8232693230E+04, 5.0281501507E+03, 5.8626368790E+03, 2.3568311082E+03, 9.2606925625E-01],
	[3.02250E+04, 1.8237681077E+04, 5.0281201720E+03, 5.8657809743E+03, 2.3574158348E+03, 9.2610475014E-01],
	[3.02300E+04, 1.8242669464E+04, 5.0280901983E+03, 5.8689262339E+03, 2.3580004594E+03, 9.2614022544E-01],
	[3.02350E+04, 1.8247658390E+04, 5.0280602298E+03, 5.8720726581E+03, 2.3585849819E+03, 9.2617568215E-01],
	[3.02400E+04, 1.8252647855E+04, 5.0280302665E+03, 5.8752202471E+03, 2.3591694023E+03, 9.2621112030E-01],
	[3.02450E+04, 1.8257637859E+04, 5.0280003083E+03, 5.8783690012E+03, 2.3597537205E+03, 9.2624653989E-01],
	[3.02500E+04, 1.8262628402E+04, 5.0279703552E+03, 5.8815189207E+03, 2.3603379365E+03, 9.2628194092E-01],
	[3.02550E+04, 1.8267619483E+04, 5.0279404072E+03, 5.8846700056E+03, 2.3609220503E+03, 9.2631732342E-01],
	[3.02600E+04, 1.8272611104E+04, 5.0279104644E+03, 5.8878222564E+03, 2.3615060618E+03, 9.2635268738E-01],
	[3.02650E+04, 1.8277603264E+04, 5.0278805267E+03, 5.8909756731E+03, 2.3620899710E+03, 9.2638803281E-01],
	[3.02700E+04, 1.8282595962E+04, 5.0278505941E+03, 5.8941302562E+03, 2.3626737779E+03, 9.2642335973E-01],
	[3.02750E+04, 1.8287589200E+04, 5.0278206666E+03, 5.8972860057E+03, 2.3632574823E+03, 9.2645866814E-01],
	[3.02800E+04, 1.8292582976E+04, 5.0277907443E+03, 5.9004429220E+03, 2.3638410844E+03, 9.2649395805E-01],
	[3.02850E+04, 1.8297577291E+04, 5.0277608270E+03, 5.9036010052E+03, 2.3644245841E+03, 9.2652922947E-01],
	[3.02900E+04, 1.8302572145E+04, 5.0277309149E+03, 5.9067602556E+03, 2.3650079812E+03, 9.2656448241E-01],
	[3.02950E+04, 1.8307567537E+04, 5.0277010079E+03, 5.9099206735E+03, 2.3655912759E+03, 9.2659971688E-01],
	[3.03000E+04, 1.8312563468E+04, 5.0276711061E+03, 5.9130822591E+03, 2.3661744679E+03, 9.2663493288E-01],
	[3.03050E+04, 1.8317559938E+04, 5.0276412093E+03, 5.9162450126E+03, 2.3667575574E+03, 9.2667013043E-01],
	[3.03100E+04, 1.8322556946E+04, 5.0276113176E+03, 5.9194089343E+03, 2.3673405443E+03, 9.2670530953E-01],
	[3.03150E+04, 1.8327554493E+04, 5.0275814311E+03, 5.9225740244E+03, 2.3679234285E+03, 9.2674047019E-01],
	[3.03200E+04, 1.8332552579E+04, 5.0275515496E+03, 5.9257402831E+03, 2.3685062100E+03, 9.2677561243E-01],
	[3.03250E+04, 1.8337551203E+04, 5.0275216733E+03, 5.9289077107E+03, 2.3690888888E+03, 9.2681073625E-01],
	[3.03300E+04, 1.8342550366E+04, 5.0274918021E+03, 5.9320763074E+03, 2.3696714648E+03, 9.2684584165E-01],
	[3.03350E+04, 1.8347550067E+04, 5.0274619359E+03, 5.9352460734E+03, 2.3702539380E+03, 9.2688092866E-01],
	[3.03400E+04, 1.8352550306E+04, 5.0274320749E+03, 5.9384170090E+03, 2.3708363084E+03, 9.2691599727E-01],
	[3.03450E+04, 1.8357551084E+04, 5.0274022190E+03, 5.9415891145E+03, 2.3714185759E+03, 9.2695104749E-01],
	[3.03500E+04, 1.8362552400E+04, 5.0273723681E+03, 5.9447623900E+03, 2.3720007405E+03, 9.2698607935E-01],
	[3.03550E+04, 1.8367554255E+04, 5.0273425224E+03, 5.9479368359E+03, 2.3725828021E+03, 9.2702109283E-01],
	[3.03600E+04, 1.8372556648E+04, 5.0273126817E+03, 5.9511124523E+03, 2.3731647608E+03, 9.2705608796E-01],
	[3.03650E+04, 1.8377559579E+04, 5.0272828462E+03, 5.9542892394E+03, 2.3737466164E+03, 9.2709106474E-01],
	[3.03700E+04, 1.8382563048E+04, 5.0272530157E+03, 5.9574671976E+03, 2.3743283690E+03, 9.2712602318E-01],
	[3.03750E+04, 1.8387567056E+04, 5.0272231903E+03, 5.9606463270E+03, 2.3749100185E+03, 9.2716096329E-01],
	[3.03800E+04, 1.8392571602E+04, 5.0271933700E+03, 5.9638266280E+03, 2.3754915649E+03, 9.2719588507E-01],
	[3.03850E+04, 1.8397576686E+04, 5.0271635548E+03, 5.9670081006E+03, 2.3760730082E+03, 9.2723078855E-01],
	[3.03900E+04, 1.8402582308E+04, 5.0271337447E+03, 5.9701907453E+03, 2.3766543482E+03, 9.2726567372E-01],
	[3.03950E+04, 1.8407588468E+04, 5.0271039396E+03, 5.9733745621E+03, 2.3772355850E+03, 9.2730054059E-01],
	[3.04000E+04, 1.8412595167E+04, 5.0270741396E+03, 5.9765595514E+03, 2.3778167186E+03, 9.2733538918E-01],
	[3.04050E+04, 1.8417602403E+04, 5.0270443447E+03, 5.9797457134E+03, 2.3783977489E+03, 9.2737021948E-01],
	[3.04100E+04, 1.8422610178E+04, 5.0270145549E+03, 5.9829330482E+03, 2.3789786759E+03, 9.2740503152E-01],
	[3.04150E+04, 1.8427618490E+04, 5.0269847702E+03, 5.9861215563E+03, 2.3795594995E+03, 9.2743982530E-01],
	[3.04200E+04, 1.8432627340E+04, 5.0269549905E+03, 5.9893112378E+03, 2.3801402197E+03, 9.2747460083E-01],
	[3.04250E+04, 1.8437636728E+04, 5.0269252159E+03, 5.9925020928E+03, 2.3807208364E+03, 9.2750935812E-01],
	[3.04300E+04, 1.8442646655E+04, 5.0268954464E+03, 5.9956941218E+03, 2.3813013497E+03, 9.2754409717E-01],
	[3.04350E+04, 1.8447657119E+04, 5.0268656819E+03, 5.9988873249E+03, 2.3818817595E+03, 9.2757881800E-01],
	[3.04400E+04, 1.8452668120E+04, 5.0268359225E+03, 6.0020817023E+03, 2.3824620658E+03, 9.2761352061E-01],
	[3.04450E+04, 1.8457679660E+04, 5.0268061682E+03, 6.0052772543E+03, 2.3830422685E+03, 9.2764820502E-01],
	[3.04500E+04, 1.8462691737E+04, 5.0267764189E+03, 6.0084739812E+03, 2.3836223676E+03, 9.2768287123E-01],
	[3.04550E+04, 1.8467704352E+04, 5.0267466747E+03, 6.0116718831E+03, 2.3842023631E+03, 9.2771751925E-01],
	[3.04600E+04, 1.8472717505E+04, 5.0267169355E+03, 6.0148709603E+03, 2.3847822549E+03, 9.2775214909E-01],
	[3.04650E+04, 1.8477731196E+04, 5.0266872015E+03, 6.0180712131E+03, 2.3853620430E+03, 9.2778676076E-01],
	[3.04700E+04, 1.8482745424E+04, 5.0266574724E+03, 6.0212726416E+03, 2.3859417274E+03, 9.2782135426E-01],
	[3.04750E+04, 1.8487760189E+04, 5.0266277484E+03, 6.0244752461E+03, 2.3865213080E+03, 9.2785592961E-01],
	[3.04800E+04, 1.8492775493E+04, 5.0265980295E+03, 6.0276790270E+03, 2.3871007848E+03, 9.2789048682E-01],
	[3.04850E+04, 1.8497791333E+04, 5.0265683156E+03, 6.0308839843E+03, 2.3876801578E+03, 9.2792502589E-01],
	[3.04900E+04, 1.8502807712E+04, 5.0265386068E+03, 6.0340901183E+03, 2.3882594269E+03, 9.2795954684E-01],
	[3.04950E+04, 1.8507824628E+04, 5.0265089030E+03, 6.0372974293E+03, 2.3888385920E+03, 9.2799404966E-01],
	[3.05000E+04, 1.8512842081E+04, 5.0264792042E+03, 6.0405059175E+03, 2.3894176533E+03, 9.2802853438E-01],
	[3.05050E+04, 1.8517860072E+04, 5.0264495105E+03, 6.0437155832E+03, 2.3899966106E+03, 9.2806300100E-01],
	[3.05100E+04, 1.8522878600E+04, 5.0264198219E+03, 6.0469264266E+03, 2.3905754638E+03, 9.2809744953E-01],
	[3.05150E+04, 1.8527897665E+04, 5.0263901383E+03, 6.0501384478E+03, 2.3911542131E+03, 9.2813187997E-01],
	[3.05200E+04, 1.8532917268E+04, 5.0263604597E+03, 6.0533516473E+03, 2.3917328582E+03, 9.2816629234E-01],
	[3.05250E+04, 1.8537937408E+04, 5.0263307861E+03, 6.0565660251E+03, 2.3923113993E+03, 9.2820068665E-01],
	[3.05300E+04, 1.8542971778E+04, 5.0263038594E+03, 6.0597815816E+03, 2.3928906857E+03, 9.2823506290E-01],
	[3.05350E+04, 1.8548036419E+04, 5.0262828882E+03, 6.0629983170E+03, 2.3934717129E+03, 9.2826942110E-01],
	[3.05400E+04, 1.8553101614E+04, 5.0262619205E+03, 6.0662162314E+03, 2.3940526377E+03, 9.2830376127E-01],
	[3.05450E+04, 1.8558167362E+04, 5.0262409563E+03, 6.0694353253E+03, 2.3946334600E+03, 9.2833808341E-01],
	[3.05500E+04, 1.8563233664E+04, 5.0262199957E+03, 6.0726555987E+03, 2.3952141799E+03, 9.2837238752E-01],
	[3.05550E+04, 1.8568300519E+04, 5.0261990386E+03, 6.0758770520E+03, 2.3957947973E+03, 9.2840667363E-01],
	[3.05600E+04, 1.8573367929E+04, 5.0261780849E+03, 6.0790996853E+03, 2.3963753121E+03, 9.2844094173E-01],
	[3.05650E+04, 1.8578435891E+04, 5.0261571348E+03, 6.0823234989E+03, 2.3969557244E+03, 9.2847519184E-01],
	[3.05700E+04, 1.8583504407E+04, 5.0261361882E+03, 6.0855484931E+03, 2.3975360340E+03, 9.2850942397E-01],
	[3.05750E+04, 1.8588573477E+04, 5.0261152451E+03, 6.0887746680E+03, 2.3981162410E+03, 9.2854363812E-01],
	[3.05800E+04, 1.8593643100E+04, 5.0260943056E+03, 6.0920020240E+03, 2.3986963454E+03, 9.2857783430E-01],
	[3.05850E+04, 1.8598713277E+04, 5.0260733695E+03, 6.0952305613E+03, 2.3992763470E+03, 9.2861201253E-01],
	[3.05900E+04, 1.8603784007E+04, 5.0260524370E+03, 6.0984602800E+03, 2.3998562459E+03, 9.2864617281E-01],
	[3.05950E+04, 1.8608855290E+04, 5.0260315079E+03, 6.1016911805E+03, 2.4004360420E+03, 9.2868031514E-01],
	[3.06000E+04, 1.8613927127E+04, 5.0260105824E+03, 6.1049232630E+03, 2.4010157353E+03, 9.2871443955E-01],
	[3.06050E+04, 1.8618999517E+04, 5.0259896604E+03, 6.1081565276E+03, 2.4015953258E+03, 9.2874854603E-01],
	[3.06100E+04, 1.8624072461E+04, 5.0259687419E+03, 6.1113909748E+03, 2.4021748134E+03, 9.2878263460E-01],
	[3.06150E+04, 1.8629145957E+04, 5.0259478268E+03, 6.1146266046E+03, 2.4027541981E+03, 9.2881670527E-01],
	[3.06200E+04, 1.8634220007E+04, 5.0259269153E+03, 6.1178634173E+03, 2.4033334799E+03, 9.2885075804E-01],
	[3.06250E+04, 1.8639294611E+04, 5.0259060073E+03, 6.1211014133E+03, 2.4039126586E+03, 9.2888479292E-01],
	[3.06300E+04, 1.8644369767E+04, 5.0258851028E+03, 6.1243405926E+03, 2.4044917344E+03, 9.2891880993E-01],
	[3.06350E+04, 1.8649445476E+04, 5.0258642018E+03, 6.1275809556E+03, 2.4050707072E+03, 9.2895280907E-01],
	[3.06400E+04, 1.8654521739E+04, 5.0258433043E+03, 6.1308225024E+03, 2.4056495769E+03, 9.2898679035E-01],
	[3.06450E+04, 1.8659598554E+04, 5.0258224102E+03, 6.1340652334E+03, 2.4062283435E+03, 9.2902075377E-01],
	[3.06500E+04, 1.8664675923E+04, 5.0258015197E+03, 6.1373091487E+03, 2.4068070069E+03, 9.2905469936E-01],
	[3.06550E+04, 1.8669753845E+04, 5.0257806327E+03, 6.1405542487E+03, 2.4073855672E+03, 9.2908862711E-01],
	[3.06600E+04, 1.8674832320E+04, 5.0257597492E+03, 6.1438005335E+03, 2.4079640243E+03, 9.2912253704E-01],
	[3.06650E+04, 1.8679911347E+04, 5.0257388691E+03, 6.1470480033E+03, 2.4085423782E+03, 9.2915642915E-01],
	[3.06700E+04, 1.8684990928E+04, 5.0257179926E+03, 6.1502966585E+03, 2.4091206288E+03, 9.2919030346E-01],
	[3.06750E+04, 1.8690071061E+04, 5.0256971195E+03, 6.1535464992E+03, 2.4096987761E+03, 9.2922415997E-01],
	[3.06800E+04, 1.8695151748E+04, 5.0256762499E+03, 6.1567975257E+03, 2.4102768201E+03, 9.2925799869E-01],
	[3.06850E+04, 1.8700232987E+04, 5.0256553838E+03, 6.1600497383E+03, 2.4108547608E+03, 9.2929181963E-01],
	[3.06900E+04, 1.8705314779E+04, 5.0256345212E+03, 6.1633031371E+03, 2.4114325980E+03, 9.2932562280E-01],
	[3.06950E+04, 1.8710397124E+04, 5.0256136621E+03, 6.1665577224E+03, 2.4120103318E+03, 9.2935940821E-01],
	[3.07000E+04, 1.8715480021E+04, 5.0255928065E+03, 6.1698134945E+03, 2.4125879622E+03, 9.2939317587E-01],
	[3.07050E+04, 1.8720563472E+04, 5.0255719543E+03, 6.1730704536E+03, 2.4131654891E+03, 9.2942692578E-01],
	[3.07100E+04, 1.8725647475E+04, 5.0255511057E+03, 6.1763285998E+03, 2.4137429125E+03, 9.2946065796E-01],
	[3.07150E+04, 1.8730732030E+04, 5.0255302605E+03, 6.1795879336E+03, 2.4143202324E+03, 9.2949437241E-01],
	[3.07200E+04, 1.8735817139E+04, 5.0255094188E+03, 6.1828484550E+03, 2.4148974486E+03, 9.2952806914E-01],
	[3.07250E+04, 1.8740902800E+04, 5.0254885806E+03, 6.1861101644E+03, 2.4154745613E+03, 9.2956174817E-01],
	[3.07300E+04, 1.8745989013E+04, 5.0254677458E+03, 6.1893730620E+03, 2.4160515703E+03, 9.2959540950E-01],
	[3.07350E+04, 1.8751075779E+04, 5.0254469145E+03, 6.1926371480E+03, 2.4166284756E+03, 9.2962905313E-01],
	[3.07400E+04, 1.8756163098E+04, 5.0254260867E+03, 6.1959024226E+03, 2.4172052773E+03, 9.2966267909E-01],
	[3.07450E+04, 1.8761250969E+04, 5.0254052624E+03, 6.1991688861E+03, 2.4177819752E+03, 9.2969628737E-01],
	[3.07500E+04, 1.8766339392E+04, 5.0253844416E+03, 6.2024365388E+03, 2.4183585693E+03, 9.2972987799E-01],
	[3.07550E+04, 1.8771428368E+04, 5.0253636242E+03, 6.2057053808E+03, 2.4189350597E+03, 9.2976345095E-01],
	[3.07600E+04, 1.8776517896E+04, 5.0253428103E+03, 6.2089754125E+03, 2.4195114462E+03, 9.2979700627E-01],
	[3.07650E+04, 1.8781607977E+04, 5.0253219998E+03, 6.2122466340E+03, 2.4200877289E+03, 9.2983054395E-01],
	[3.07700E+04, 1.8786698610E+04, 5.0253011928E+03, 6.2155190456E+03, 2.4206639076E+03, 9.2986406401E-01],
	[3.07750E+04, 1.8791789796E+04, 5.0252803893E+03, 6.2187926475E+03, 2.4212399825E+03, 9.2989756644E-01],
	[3.07800E+04, 1.8796881533E+04, 5.0252595893E+03, 6.2220674400E+03, 2.4218159534E+03, 9.2993105127E-01],
	[3.07850E+04, 1.8801973823E+04, 5.0252387927E+03, 6.2253434233E+03, 2.4223918203E+03, 9.2996451849E-01],
	[3.07900E+04, 1.8807066665E+04, 5.0252179996E+03, 6.2286205976E+03, 2.4229675832E+03, 9.2999796812E-01],
	[3.07950E+04, 1.8812160059E+04, 5.0251972099E+03, 6.2318989632E+03, 2.4235432421E+03, 9.3003140017E-01],
	[3.08000E+04, 1.8817254006E+04, 5.0251764238E+03, 6.2351785203E+03, 2.4241187969E+03, 9.3006481464E-01],
	[3.08050E+04, 1.8822348504E+04, 5.0251556410E+03, 6.2384592692E+03, 2.4246942475E+03, 9.3009821155E-01],
	[3.08100E+04, 1.8827443555E+04, 5.0251348618E+03, 6.2417412101E+03, 2.4252695941E+03, 9.3013159090E-01],
	[3.08150E+04, 1.8832539158E+04, 5.0251140859E+03, 6.2450243432E+03, 2.4258448365E+03, 9.3016495271E-01],
	[3.08200E+04, 1.8837635312E+04, 5.0250933136E+03, 6.2483086688E+03, 2.4264199747E+03, 9.3019829697E-01],
	[3.08250E+04, 1.8842732019E+04, 5.0250725447E+03, 6.2515941872E+03, 2.4269950086E+03, 9.3023162371E-01],
	[3.08300E+04, 1.8847829278E+04, 5.0250517792E+03, 6.2548808984E+03, 2.4275699383E+03, 9.3026493292E-01],
	[3.08350E+04, 1.8852927089E+04, 5.0250310172E+03, 6.2581688029E+03, 2.4281447637E+03, 9.3029822462E-01],
	[3.08400E+04, 1.8858025451E+04, 5.0250102587E+03, 6.2614579008E+03, 2.4287194848E+03, 9.3033149882E-01],
	[3.08450E+04, 1.8863124366E+04, 5.0249895036E+03, 6.2647481924E+03, 2.4292941016E+03, 9.3036475553E-01],
	[3.08500E+04, 1.8868223832E+04, 5.0249687520E+03, 6.2680396778E+03, 2.4298686140E+03, 9.3039799475E-01],
	[3.08550E+04, 1.8873323850E+04, 5.0249480038E+03, 6.2713323574E+03, 2.4304430219E+03, 9.3043121649E-01],
	[3.08600E+04, 1.8878424420E+04, 5.0249272590E+03, 6.2746262315E+03, 2.4310173255E+03, 9.3046442077E-01],
	[3.08650E+04, 1.8883525542E+04, 5.0249065177E+03, 6.2779213001E+03, 2.4315915245E+03, 9.3049760758E-01],
	[3.08700E+04, 1.8888627215E+04, 5.0248857799E+03, 6.2812175636E+03, 2.4321656191E+03, 9.3053077695E-01],
	[3.08750E+04, 1.8893729441E+04, 5.0248650455E+03, 6.2845150222E+03, 2.4327396091E+03, 9.3056392888E-01],
	[3.08800E+04, 1.8898832217E+04, 5.0248443145E+03, 6.2878136761E+03, 2.4333134946E+03, 9.3059706338E-01],
	[3.08850E+04, 1.8903935546E+04, 5.0248235870E+03, 6.2911135257E+03, 2.4338872755E+03, 9.3063018045E-01],
	[3.08900E+04, 1.8909039426E+04, 5.0248028629E+03, 6.2944145710E+03, 2.4344609518E+03, 9.3066328011E-01],
	[3.08950E+04, 1.8914143858E+04, 5.0247821423E+03, 6.2977168124E+03, 2.4350345234E+03, 9.3069636237E-01],
	[3.09000E+04, 1.8919248841E+04, 5.0247614251E+03, 6.3010202501E+03, 2.4356079903E+03, 9.3072942722E-01],
	[3.09050E+04, 1.8924354376E+04, 5.0247407113E+03, 6.3043248844E+03, 2.4361813526E+03, 9.3076247470E-01],
	[3.09100E+04, 1.8929460462E+04, 5.0247200010E+03, 6.3076307154E+03, 2.4367546101E+03, 9.3079550479E-01],
	[3.09150E+04, 1.8934567100E+04, 5.0246992941E+03, 6.3109377434E+03, 2.4373277628E+03, 9.3082851751E-01],
	[3.09200E+04, 1.8939674290E+04, 5.0246785906E+03, 6.3142459687E+03, 2.4379008108E+03, 9.3086151288E-01],
	[3.09250E+04, 1.8944782030E+04, 5.0246578906E+03, 6.3175553915E+03, 2.4384737539E+03, 9.3089449089E-01],
	[3.09300E+04, 1.8949890322E+04, 5.0246371940E+03, 6.3208660120E+03, 2.4390465922E+03, 9.3092745156E-01],
	[3.09350E+04, 1.8954999166E+04, 5.0246165008E+03, 6.3241778305E+03, 2.4396193256E+03, 9.3096039490E-01],
	[3.09400E+04, 1.8960108560E+04, 5.0245958111E+03, 6.3274908472E+03, 2.4401919541E+03, 9.3099332091E-01],
	[3.09450E+04, 1.8965218507E+04, 5.0245751248E+03, 6.3308050623E+03, 2.4407644776E+03, 9.3102622960E-01],
	[3.09500E+04, 1.8970329004E+04, 5.0245544419E+03, 6.3341204761E+03, 2.4413368962E+03, 9.3105912099E-01],
	[3.09550E+04, 1.8975440052E+04, 5.0245337624E+03, 6.3374370889E+03, 2.4419092098E+03, 9.3109199509E-01],
	[3.09600E+04, 1.8980551652E+04, 5.0245130864E+03, 6.3407549008E+03, 2.4424814183E+03, 9.3112485189E-01],
	[3.09650E+04, 1.8985663803E+04, 5.0244924138E+03, 6.3440739122E+03, 2.4430535218E+03, 9.3115769141E-01],
	[3.09700E+04, 1.8990776505E+04, 5.0244717446E+03, 6.3473941231E+03, 2.4436255203E+03, 9.3119051366E-01],
	[3.09750E+04, 1.8995889758E+04, 5.0244510789E+03, 6.3507155340E+03, 2.4441974136E+03, 9.3122331865E-01],
	[3.09800E+04, 1.9001003563E+04, 5.0244304165E+03, 6.3540381450E+03, 2.4447692017E+03, 9.3125610639E-01],
	[3.09850E+04, 1.9006117918E+04, 5.0244097576E+03, 6.3573619563E+03, 2.4453408847E+03, 9.3128887688E-01],
	[3.09900E+04, 1.9011232824E+04, 5.0243891021E+03, 6.3606869683E+03, 2.4459124625E+03, 9.3132163014E-01],
	[3.09950E+04, 1.9016348282E+04, 5.0243684500E+03, 6.3640131810E+03, 2.4464839350E+03, 9.3135436616E-01],
	[3.10000E+04, 1.9021464290E+04, 5.0243478013E+03, 6.3673405949E+03, 2.4470553023E+03, 9.3138708498E-01],
	[3.10050E+04, 1.9026580850E+04, 5.0243271561E+03, 6.3706692101E+03, 2.4476265644E+03, 9.3141978658E-01],
	[3.10100E+04, 1.9031697960E+04, 5.0243065142E+03, 6.3739990268E+03, 2.4481977211E+03, 9.3145247098E-01],
	[3.10150E+04, 1.9036815621E+04, 5.0242858758E+03, 6.3773300454E+03, 2.4487687724E+03, 9.3148513820E-01],
	[3.10200E+04, 1.9041933833E+04, 5.0242652408E+03, 6.3806622659E+03, 2.4493397184E+03, 9.3151778823E-01],
	[3.10250E+04, 1.9047052596E+04, 5.0242446092E+03, 6.3839956888E+03, 2.4499105590E+03, 9.3155042108E-01],
	[3.10300E+04, 1.9052171909E+04, 5.0242239810E+03, 6.3873303141E+03, 2.4504812942E+03, 9.3158303678E-01],
	[3.10350E+04, 1.9057291773E+04, 5.0242033562E+03, 6.3906661423E+03, 2.4510519239E+03, 9.3161563531E-01],
	[3.10400E+04, 1.9062412188E+04, 5.0241827348E+03, 6.3940031734E+03, 2.4516224481E+03, 9.3164821671E-01],
	[3.10450E+04, 1.9067533154E+04, 5.0241621169E+03, 6.3973414077E+03, 2.4521928668E+03, 9.3168078096E-01],
	[3.10500E+04, 1.9072654671E+04, 5.0241415023E+03, 6.4006808455E+03, 2.4527631800E+03, 9.3171332809E-01],
	[3.10550E+04, 1.9077776738E+04, 5.0241208911E+03, 6.4040214870E+03, 2.4533333876E+03, 9.3174585809E-01],
	[3.10600E+04, 1.9082899356E+04, 5.0241002834E+03, 6.4073633325E+03, 2.4539034897E+03, 9.3177837099E-01],
	[3.10650E+04, 1.9088022524E+04, 5.0240796790E+03, 6.4107063822E+03, 2.4544734860E+03, 9.3181086678E-01],
	[3.10700E+04, 1.9093146243E+04, 5.0240590780E+03, 6.4140506362E+03, 2.4550433768E+03, 9.3184334548E-01],
	[3.10750E+04, 1.9098270512E+04, 5.0240384805E+03, 6.4173960950E+03, 2.4556131619E+03, 9.3187580710E-01],
	[3.10800E+04, 1.9103395332E+04, 5.0240178863E+03, 6.4207427587E+03, 2.4561828412E+03, 9.3190825164E-01],
	[3.10850E+04, 1.9108520702E+04, 5.0239972955E+03, 6.4240906275E+03, 2.4567524148E+03, 9.3194067912E-01],
	[3.10900E+04, 1.9113646623E+04, 5.0239767082E+03, 6.4274397016E+03, 2.4573218827E+03, 9.3197308953E-01],
	[3.10950E+04, 1.9118773094E+04, 5.0239561242E+03, 6.4307899815E+03, 2.4578912448E+03, 9.3200548290E-01],
	[3.11000E+04, 1.9123900116E+04, 5.0239355436E+03, 6.4341414671E+03, 2.4584605011E+03, 9.3203785923E-01],
	[3.11050E+04, 1.9129027688E+04, 5.0239149664E+03, 6.4374941589E+03, 2.4590296515E+03, 9.3207021853E-01],
	[3.11100E+04, 1.9134155810E+04, 5.0238943926E+03, 6.4408480570E+03, 2.4595986960E+03, 9.3210256081E-01],
	[3.11150E+04, 1.9139284483E+04, 5.0238738222E+03, 6.4442031617E+03, 2.4601676347E+03, 9.3213488608E-01],
	[3.11200E+04, 1.9144413705E+04, 5.0238532552E+03, 6.4475594733E+03, 2.4607364674E+03, 9.3216719434E-01],
	[3.11250E+04, 1.9149543478E+04, 5.0238326916E+03, 6.4509169919E+03, 2.4613051942E+03, 9.3219948560E-01],
	[3.11300E+04, 1.9154673802E+04, 5.0238121313E+03, 6.4542757177E+03, 2.4618738149E+03, 9.3223175988E-01],
	[3.11350E+04, 1.9159804675E+04, 5.0237915745E+03, 6.4576356512E+03, 2.4624423297E+03, 9.3226401719E-01],
	[3.11400E+04, 1.9164936099E+04, 5.0237710210E+03, 6.4609967924E+03, 2.4630107385E+03, 9.3229625752E-01],
	[3.11450E+04, 1.9170068072E+04, 5.0237504709E+03, 6.4643591416E+03, 2.4635790412E+03, 9.3232848090E-01],
	[3.11500E+04, 1.9175200596E+04, 5.0237299242E+03, 6.4677226991E+03, 2.4641472378E+03, 9.3236068732E-01],
	[3.11550E+04, 1.9180333670E+04, 5.0237093809E+03, 6.4710874650E+03, 2.4647153282E+03, 9.3239287681E-01],
	[3.11600E+04, 1.9185467294E+04, 5.0236888410E+03, 6.4744534398E+03, 2.4652833126E+03, 9.3242504936E-01],
	[3.11650E+04, 1.9190601468E+04, 5.0236683044E+03, 6.4778206234E+03, 2.4658511907E+03, 9.3245720499E-01],
	[3.11700E+04, 1.9195736192E+04, 5.0236477712E+03, 6.4811890163E+03, 2.4664189627E+03, 9.3248934370E-01],
	[3.11750E+04, 1.9200871465E+04, 5.0236272414E+03, 6.4845586187E+03, 2.4669866285E+03, 9.3252146550E-01],
	[3.11800E+04, 1.9206007289E+04, 5.0236067150E+03, 6.4879294307E+03, 2.4675541880E+03, 9.3255357041E-01],
	[3.11850E+04, 1.9211143663E+04, 5.0235861919E+03, 6.4913014527E+03, 2.4681216412E+03, 9.3258565843E-01],
	[3.11900E+04, 1.9216280586E+04, 5.0235656723E+03, 6.4946746849E+03, 2.4686889881E+03, 9.3261772957E-01],
	[3.11950E+04, 1.9221418059E+04, 5.0235451560E+03, 6.4980491274E+03, 2.4692562287E+03, 9.3264978385E-01],
	[3.12000E+04, 1.9226556082E+04, 5.0235246430E+03, 6.5014247807E+03, 2.4698233630E+03, 9.3268182125E-01],
	[3.12050E+04, 1.9231694655E+04, 5.0235041335E+03, 6.5048016448E+03, 2.4703903908E+03, 9.3271384181E-01],
	[3.12100E+04, 1.9236833778E+04, 5.0234836273E+03, 6.5081797200E+03, 2.4709573123E+03, 9.3274584552E-01],
	[3.12150E+04, 1.9241973450E+04, 5.0234631244E+03, 6.5115590066E+03, 2.4715241273E+03, 9.3277783240E-01],
	[3.12200E+04, 1.9247113672E+04, 5.0234426250E+03, 6.5149395048E+03, 2.4720908359E+03, 9.3280980245E-01],
	[3.12250E+04, 1.9252254444E+04, 5.0234221289E+03, 6.5183212149E+03, 2.4726574379E+03, 9.3284175569E-01],
	[3.12300E+04, 1.9257395765E+04, 5.0234016362E+03, 6.5217041371E+03, 2.4732239335E+03, 9.3287369212E-01],
	[3.12350E+04, 1.9262537636E+04, 5.0233811468E+03, 6.5250882716E+03, 2.4737903225E+03, 9.3290561174E-01],
	[3.12400E+04, 1.9267680056E+04, 5.0233606608E+03, 6.5284736186E+03, 2.4743566050E+03, 9.3293751458E-01],
	[3.12450E+04, 1.9272823026E+04, 5.0233401782E+03, 6.5318601785E+03, 2.4749227808E+03, 9.3296940063E-01],
	[3.12500E+04, 1.9277966545E+04, 5.0233196989E+03, 6.5352479514E+03, 2.4754888501E+03, 9.3300126992E-01],
	[3.12550E+04, 1.9283110614E+04, 5.0232992230E+03, 6.5386369376E+03, 2.4760548127E+03, 9.3303312243E-01],
	[3.12600E+04, 1.9288255232E+04, 5.0232787504E+03, 6.5420271373E+03, 2.4766206686E+03, 9.3306495820E-01],
	[3.12650E+04, 1.9293400400E+04, 5.0232582812E+03, 6.5454185508E+03, 2.4771864178E+03, 9.3309677722E-01],
	[3.12700E+04, 1.9298546117E+04, 5.0232378154E+03, 6.5488111783E+03, 2.4777520604E+03, 9.3312857950E-01],
	[3.12750E+04, 1.9303692384E+04, 5.0232173529E+03, 6.5522050200E+03, 2.4783175961E+03, 9.3316036505E-01],
	[3.12800E+04, 1.9308839199E+04, 5.0231968938E+03, 6.5556000762E+03, 2.4788830251E+03, 9.3319213388E-01],
	[3.12850E+04, 1.9313986564E+04, 5.0231764380E+03, 6.5589963472E+03, 2.4794483473E+03, 9.3322388600E-01],
	[3.12900E+04, 1.9319134479E+04, 5.0231559856E+03, 6.5623938331E+03, 2.4800135627E+03, 9.3325562142E-01],
	[3.12950E+04, 1.9324282942E+04, 5.0231355365E+03, 6.5657925342E+03, 2.4805786713E+03, 9.3328734015E-01],
	[3.13000E+04, 1.9329431955E+04, 5.0231150908E+03, 6.5691924507E+03, 2.4811436729E+03, 9.3331904219E-01],
	[3.13050E+04, 1.9334581517E+04, 5.0230946484E+03, 6.5725935830E+03, 2.4817085677E+03, 9.3335072756E-01],
	[3.13100E+04, 1.9339731628E+04, 5.0230742094E+03, 6.5759959311E+03, 2.4822733555E+03, 9.3338239626E-01],
	[3.13150E+04, 1.9344882288E+04, 5.0230537737E+03, 6.5793994954E+03, 2.4828380364E+03, 9.3341404830E-01],
	[3.13200E+04, 1.9350033498E+04, 5.0230333414E+03, 6.5828042762E+03, 2.4834026103E+03, 9.3344568370E-01],
	[3.13250E+04, 1.9355185256E+04, 5.0230129124E+03, 6.5862102735E+03, 2.4839670772E+03, 9.3347730245E-01],
	[3.13300E+04, 1.9360337564E+04, 5.0229924867E+03, 6.5896174878E+03, 2.4845314371E+03, 9.3350890458E-01],
	[3.13350E+04, 1.9365490420E+04, 5.0229720644E+03, 6.5930259191E+03, 2.4850956899E+03, 9.3354049008E-01],
	[3.13400E+04, 1.9370643826E+04, 5.0229516454E+03, 6.5964355679E+03, 2.4856598357E+03, 9.3357205897E-01],
	[3.13450E+04, 1.9375797780E+04, 5.0229312298E+03, 6.5998464342E+03, 2.4862238744E+03, 9.3360361126E-01],
	[3.13500E+04, 1.9380952283E+04, 5.0229108175E+03, 6.6032585184E+03, 2.4867878059E+03, 9.3363514695E-01],
	[3.13550E+04, 1.9386107335E+04, 5.0228904086E+03, 6.6066718206E+03, 2.4873516303E+03, 9.3366666605E-01],
	[3.13600E+04, 1.9391262936E+04, 5.0228700030E+03, 6.6100863412E+03, 2.4879153475E+03, 9.3369816857E-01],
	[3.13650E+04, 1.9396419086E+04, 5.0228496007E+03, 6.6135020803E+03, 2.4884789575E+03, 9.3372965453E-01],
	[3.13700E+04, 1.9401575785E+04, 5.0228292018E+03, 6.6169190382E+03, 2.4890424603E+03, 9.3376112393E-01],
	[3.13750E+04, 1.9406733032E+04, 5.0228088062E+03, 6.6203372152E+03, 2.4896058558E+03, 9.3379257677E-01],
	[3.13800E+04, 1.9411890829E+04, 5.0227884139E+03, 6.6237566114E+03, 2.4901691441E+03, 9.3382401308E-01],
	[3.13850E+04, 1.9417049174E+04, 5.0227680250E+03, 6.6271772272E+03, 2.4907323250E+03, 9.3385543285E-01],
	[3.13900E+04, 1.9422208067E+04, 5.0227476394E+03, 6.6305990627E+03, 2.4912953986E+03, 9.3388683609E-01],
	[3.13950E+04, 1.9427367509E+04, 5.0227272571E+03, 6.6340221182E+03, 2.4918583649E+03, 9.3391822282E-01],
	[3.14000E+04, 1.9432527500E+04, 5.0227068781E+03, 6.6374463940E+03, 2.4924212239E+03, 9.3394959304E-01],
	[3.14050E+04, 1.9437688040E+04, 5.0226865025E+03, 6.6408718902E+03, 2.4929839754E+03, 9.3398094677E-01],
	[3.14100E+04, 1.9442849128E+04, 5.0226661302E+03, 6.6442986072E+03, 2.4935466195E+03, 9.3401228400E-01],
	[3.14150E+04, 1.9448010764E+04, 5.0226457612E+03, 6.6477265451E+03, 2.4941091561E+03, 9.3404360476E-01],
	[3.14200E+04, 1.9453172949E+04, 5.0226253956E+03, 6.6511557042E+03, 2.4946715853E+03, 9.3407490904E-01],
	[3.14250E+04, 1.9458335683E+04, 5.0226050333E+03, 6.6545860847E+03, 2.4952339070E+03, 9.3410619686E-01],
	[3.14300E+04, 1.9463498965E+04, 5.0225846743E+03, 6.6580176869E+03, 2.4957961212E+03, 9.3413746823E-01],
	[3.14350E+04, 1.9468662796E+04, 5.0225643186E+03, 6.6614505111E+03, 2.4963582278E+03, 9.3416872315E-01],
	[3.14400E+04, 1.9473827174E+04, 5.0225439662E+03, 6.6648845574E+03, 2.4969202269E+03, 9.3419996163E-01],
	[3.14450E+04, 1.9478992102E+04, 5.0225236172E+03, 6.6683198260E+03, 2.4974821183E+03, 9.3423118369E-01],
	[3.14500E+04, 1.9484157577E+04, 5.0225032715E+03, 6.6717563174E+03, 2.4980439022E+03, 9.3426238933E-01],
	[3.14550E+04, 1.9489323601E+04, 5.0224829291E+03, 6.6751940316E+03, 2.4986055784E+03, 9.3429357856E-01],
	[3.14600E+04, 1.9494490173E+04, 5.0224625900E+03, 6.6786329689E+03, 2.4991671470E+03, 9.3432475139E-01],
	[3.14650E+04, 1.9499657294E+04, 5.0224422542E+03, 6.6820731296E+03, 2.4997286079E+03, 9.3435590782E-01],
	[3.14700E+04, 1.9504824962E+04, 5.0224219217E+03, 6.6855145138E+03, 2.5002899610E+03, 9.3438704788E-01],
	[3.14750E+04, 1.9509993179E+04, 5.0224015926E+03, 6.6889571219E+03, 2.5008512065E+03, 9.3441817155E-01],
	[3.14800E+04, 1.9515161944E+04, 5.0223812667E+03, 6.6924009541E+03, 2.5014123442E+03, 9.3444927887E-01],
	[3.14850E+04, 1.9520331257E+04, 5.0223609442E+03, 6.6958460106E+03, 2.5019733741E+03, 9.3448036982E-01],
	[3.14900E+04, 1.9525501118E+04, 5.0223406250E+03, 6.6992922917E+03, 2.5025342961E+03, 9.3451144443E-01],
	[3.14950E+04, 1.9530671528E+04, 5.0223203091E+03, 6.7027397975E+03, 2.5030951104E+03, 9.3454250270E-01],
	[3.15000E+04, 1.9535842485E+04, 5.0222999965E+03, 6.7061885284E+03, 2.5036558168E+03, 9.3457354464E-01],
	[3.15050E+04, 1.9541013990E+04, 5.0222796872E+03, 6.7096384846E+03, 2.5042164154E+03, 9.3460457025E-01],
	[3.15100E+04, 1.9546186044E+04, 5.0222593812E+03, 6.7130896663E+03, 2.5047769060E+03, 9.3463557956E-01],
	[3.15150E+04, 1.9551358645E+04, 5.0222390785E+03, 6.7165420737E+03, 2.5053372887E+03, 9.3466657256E-01],
	[3.15200E+04, 1.9556531794E+04, 5.0222187791E+03, 6.7199957072E+03, 2.5058975635E+03, 9.3469754926E-01],
	[3.15250E+04, 1.9561705491E+04, 5.0221984830E+03, 6.7234505668E+03, 2.5064577303E+03, 9.3472850968E-01],
	[3.15300E+04, 1.9566879736E+04, 5.0221781903E+03, 6.7269066530E+03, 2.5070177892E+03, 9.3475945382E-01],
	[3.15350E+04, 1.9572054529E+04, 5.0221579008E+03, 6.7303639658E+03, 2.5075777400E+03, 9.3479038169E-01],
	[3.15400E+04, 1.9577229870E+04, 5.0221376146E+03, 6.7338225057E+03, 2.5081375827E+03, 9.3482129331E-01],
	[3.15450E+04, 1.9582405758E+04, 5.0221173317E+03, 6.7372822727E+03, 2.5086973175E+03, 9.3485218867E-01],
	[3.15500E+04, 1.9587582195E+04, 5.0220970521E+03, 6.7407432671E+03, 2.5092569441E+03, 9.3488306778E-01],
	[3.15550E+04, 1.9592759179E+04, 5.0220767758E+03, 6.7442054893E+03, 2.5098164626E+03, 9.3491393067E-01],
	[3.15600E+04, 1.9597936710E+04, 5.0220565028E+03, 6.7476689393E+03, 2.5103758730E+03, 9.3494477733E-01],
	[3.15650E+04, 1.9603114790E+04, 5.0220362331E+03, 6.7511336175E+03, 2.5109351753E+03, 9.3497560777E-01],
	[3.15700E+04, 1.9608293417E+04, 5.0220159667E+03, 6.7545995241E+03, 2.5114943693E+03, 9.3500642201E-01],
	[3.15750E+04, 1.9613472591E+04, 5.0219957036E+03, 6.7580666594E+03, 2.5120534552E+03, 9.3503722005E-01],
	[3.15800E+04, 1.9618652313E+04, 5.0219754437E+03, 6.7615350235E+03, 2.5126124329E+03, 9.3506800190E-01],
	[3.15850E+04, 1.9623832583E+04, 5.0219551872E+03, 6.7650046167E+03, 2.5131713023E+03, 9.3509876757E-01],
	[3.15900E+04, 1.9629013400E+04, 5.0219349339E+03, 6.7684754393E+03, 2.5137300634E+03, 9.3512951707E-01],
	[3.15950E+04, 1.9634194765E+04, 5.0219146840E+03, 6.7719474915E+03, 2.5142887163E+03, 9.3516025040E-01],
	[3.16000E+04, 1.9639376678E+04, 5.0218944373E+03, 6.7754207735E+03, 2.5148472609E+03, 9.3519096758E-01],
	[3.16050E+04, 1.9644559137E+04, 5.0218741939E+03, 6.7788952856E+03, 2.5154056971E+03, 9.3522166861E-01],
	[3.16100E+04, 1.9649742144E+04, 5.0218539538E+03, 6.7823710280E+03, 2.5159640250E+03, 9.3525235351E-01],
	[3.16150E+04, 1.9654925699E+04, 5.0218337169E+03, 6.7858480010E+03, 2.5165222444E+03, 9.3528302228E-01],
	[3.16200E+04, 1.9660109801E+04, 5.0218134834E+03, 6.7893262048E+03, 2.5170803555E+03, 9.3531367492E-01],
	[3.16250E+04, 1.9665294450E+04, 5.0217932531E+03, 6.7928056396E+03, 2.5176383582E+03, 9.3534431146E-01],
	[3.16300E+04, 1.9670479646E+04, 5.0217730261E+03, 6.7962863057E+03, 2.5181962524E+03, 9.3537493190E-01],
	[3.16350E+04, 1.9675665390E+04, 5.0217528024E+03, 6.7997682033E+03, 2.5187540382E+03, 9.3540553624E-01],
	[3.16400E+04, 1.9680851681E+04, 5.0217325820E+03, 6.8032513327E+03, 2.5193117155E+03, 9.3543612450E-01],
	[3.16450E+04, 1.9686038519E+04, 5.0217123648E+03, 6.8067356941E+03, 2.5198692843E+03, 9.3546669669E-01],
	[3.16500E+04, 1.9691225905E+04, 5.0216921509E+03, 6.8102212877E+03, 2.5204267445E+03, 9.3549725280E-01],
	[3.16550E+04, 1.9696413837E+04, 5.0216719403E+03, 6.8137081138E+03, 2.5209840962E+03, 9.3552779286E-01],
	[3.16600E+04, 1.9701602317E+04, 5.0216517330E+03, 6.8171961727E+03, 2.5215413393E+03, 9.3555831687E-01],
	[3.16650E+04, 1.9706791344E+04, 5.0216315289E+03, 6.8206854644E+03, 2.5220984738E+03, 9.3558882484E-01],
	[3.16700E+04, 1.9711980917E+04, 5.0216113282E+03, 6.8241759894E+03, 2.5226554997E+03, 9.3561931678E-01],
	[3.16750E+04, 1.9717171038E+04, 5.0215911306E+03, 6.8276677478E+03, 2.5232124169E+03, 9.3564979269E-01],
	[3.16800E+04, 1.9722361706E+04, 5.0215709364E+03, 6.8311607400E+03, 2.5237692255E+03, 9.3568025260E-01],
	[3.16850E+04, 1.9727552921E+04, 5.0215507454E+03, 6.8346549660E+03, 2.5243259254E+03, 9.3571069649E-01],
	[3.16900E+04, 1.9732744683E+04, 5.0215305577E+03, 6.8381504262E+03, 2.5248825166E+03, 9.3574112439E-01],
	[3.16950E+04, 1.9737936991E+04, 5.0215103732E+03, 6.8416471208E+03, 2.5254389991E+03, 9.3577153630E-01],
	[3.17000E+04, 1.9743129847E+04, 5.0214901921E+03, 6.8451450500E+03, 2.5259953728E+03, 9.3580193223E-01],
	[3.17050E+04, 1.9748323250E+04, 5.0214700141E+03, 6.8486442141E+03, 2.5265516378E+03, 9.3583231219E-01],
	[3.17100E+04, 1.9753517199E+04, 5.0214498395E+03, 6.8521446134E+03, 2.5271077939E+03, 9.3586267619E-01],
	[3.17150E+04, 1.9758711695E+04, 5.0214296681E+03, 6.8556462480E+03, 2.5276638413E+03, 9.3589302424E-01],
	[3.17200E+04, 1.9763906738E+04, 5.0214095000E+03, 6.8591491182E+03, 2.5282197798E+03, 9.3592335634E-01],
	[3.17250E+04, 1.9769102328E+04, 5.0213893351E+03, 6.8626532243E+03, 2.5287756095E+03, 9.3595367251E-01],
	[3.17300E+04, 1.9774298464E+04, 5.0213691735E+03, 6.8661585664E+03, 2.5293313303E+03, 9.3598397275E-01],
	[3.17350E+04, 1.9779495147E+04, 5.0213490151E+03, 6.8696651449E+03, 2.5298869421E+03, 9.3601425707E-01],
	[3.17400E+04, 1.9784692377E+04, 5.0213288600E+03, 6.8731729599E+03, 2.5304424451E+03, 9.3604452548E-01],
	[3.17450E+04, 1.9789890153E+04, 5.0213087082E+03, 6.8766820118E+03, 2.5309978391E+03, 9.3607477799E-01],
	[3.17500E+04, 1.9795121180E+04, 5.0212949347E+03, 6.8801923007E+03, 2.5315552795E+03, 9.3610501461E-01],
	[3.17550E+04, 1.9800362152E+04, 5.0212829926E+03, 6.8837038268E+03, 2.5321132309E+03, 9.3613523535E-01],
	[3.17600E+04, 1.9805603685E+04, 5.0212710525E+03, 6.8872165906E+03, 2.5326710748E+03, 9.3616544021E-01],
	[3.17650E+04, 1.9810845781E+04, 5.0212591142E+03, 6.8907305920E+03, 2.5332288114E+03, 9.3619562921E-01],
	[3.17700E+04, 1.9816088439E+04, 5.0212471778E+03, 6.8942458315E+03, 2.5337864407E+03, 9.3622580235E-01],
	[3.17750E+04, 1.9821331659E+04, 5.0212352434E+03, 6.8977623093E+03, 2.5343439625E+03, 9.3625595964E-01],
	[3.17800E+04, 1.9826575441E+04, 5.0212233108E+03, 6.9012800255E+03, 2.5349013768E+03, 9.3628610110E-01],
	[3.17850E+04, 1.9831819784E+04, 5.0212113802E+03, 6.9047989804E+03, 2.5354586837E+03, 9.3631622672E-01],
	[3.17900E+04, 1.9837064690E+04, 5.0211994515E+03, 6.9083191744E+03, 2.5360158832E+03, 9.3634633652E-01],
	[3.17950E+04, 1.9842310158E+04, 5.0211875246E+03, 6.9118406075E+03, 2.5365729751E+03, 9.3637643050E-01],
	[3.18000E+04, 1.9847556187E+04, 5.0211755997E+03, 6.9153632801E+03, 2.5371299595E+03, 9.3640650869E-01],
	[3.18050E+04, 1.9852802779E+04, 5.0211636767E+03, 6.9188871924E+03, 2.5376868364E+03, 9.3643657107E-01],
	[3.18100E+04, 1.9858049932E+04, 5.0211517556E+03, 6.9224123446E+03, 2.5382436057E+03, 9.3646661767E-01],
	[3.18150E+04, 1.9863297647E+04, 5.0211398363E+03, 6.9259387370E+03, 2.5388002674E+03, 9.3649664849E-01],
	[3.18200E+04, 1.9868545924E+04, 5.0211279190E+03, 6.9294663698E+03, 2.5393568215E+03, 9.3652666354E-01],
	[3.18250E+04, 1.9873794763E+04, 5.0211160036E+03, 6.9329952433E+03, 2.5399132680E+03, 9.3655666283E-01],
	[3.18300E+04, 1.9879044163E+04, 5.0211040901E+03, 6.9365253576E+03, 2.5404696069E+03, 9.3658664637E-01],
	[3.18350E+04, 1.9884294125E+04, 5.0210921785E+03, 6.9400567131E+03, 2.5410258381E+03, 9.3661661416E-01],
	[3.18400E+04, 1.9889544649E+04, 5.0210802687E+03, 6.9435893100E+03, 2.5415819615E+03, 9.3664656622E-01],
	[3.18450E+04, 1.9894795734E+04, 5.0210683609E+03, 6.9471231485E+03, 2.5421379773E+03, 9.3667650255E-01],
	[3.18500E+04, 1.9900047381E+04, 5.0210564550E+03, 6.9506582288E+03, 2.5426938854E+03, 9.3670642316E-01],
	[3.18550E+04, 1.9905299590E+04, 5.0210445510E+03, 6.9541945512E+03, 2.5432496857E+03, 9.3673632806E-01],
	[3.18600E+04, 1.9910552360E+04, 5.0210326488E+03, 6.9577321160E+03, 2.5438053782E+03, 9.3676621727E-01],
	[3.18650E+04, 1.9915805691E+04, 5.0210207486E+03, 6.9612709234E+03, 2.5443609630E+03, 9.3679609078E-01],
	[3.18700E+04, 1.9921059584E+04, 5.0210088503E+03, 6.9648109736E+03, 2.5449164399E+03, 9.3682594861E-01],
	[3.18750E+04, 1.9926314039E+04, 5.0209969538E+03, 6.9683522668E+03, 2.5454718090E+03, 9.3685579077E-01],
	[3.18800E+04, 1.9931569055E+04, 5.0209850593E+03, 6.9718948034E+03, 2.5460270703E+03, 9.3688561726E-01],
	[3.18850E+04, 1.9936824633E+04, 5.0209731666E+03, 6.9754385834E+03, 2.5465822237E+03, 9.3691542809E-01],
	[3.18900E+04, 1.9942080771E+04, 5.0209612759E+03, 6.9789836073E+03, 2.5471372692E+03, 9.3694522327E-01],
	[3.18950E+04, 1.9947337472E+04, 5.0209493870E+03, 6.9825298752E+03, 2.5476922068E+03, 9.3697500281E-01],
	[3.19000E+04, 1.9952594733E+04, 5.0209375000E+03, 6.9860773873E+03, 2.5482470364E+03, 9.3700476672E-01],
	[3.19050E+04, 1.9957852556E+04, 5.0209256149E+03, 6.9896261440E+03, 2.5488017581E+03, 9.3703451500E-01],
	[3.19100E+04, 1.9963110940E+04, 5.0209137317E+03, 6.9931761454E+03, 2.5493563719E+03, 9.3706424766E-01],
	[3.19150E+04, 1.9968369886E+04, 5.0209018504E+03, 6.9967273918E+03, 2.5499108776E+03, 9.3709396470E-01],
	[3.19200E+04, 1.9973629392E+04, 5.0208899710E+03, 7.0002798834E+03, 2.5504652753E+03, 9.3712366615E-01],
	[3.19250E+04, 1.9978889460E+04, 5.0208780935E+03, 7.0038336205E+03, 2.5510195650E+03, 9.3715335200E-01],
	[3.19300E+04, 1.9984150089E+04, 5.0208662178E+03, 7.0073886033E+03, 2.5515737467E+03, 9.3718302226E-01],
	[3.19350E+04, 1.9989411279E+04, 5.0208543441E+03, 7.0109448321E+03, 2.5521278202E+03, 9.3721267694E-01],
	[3.19400E+04, 1.9994673030E+04, 5.0208424722E+03, 7.0145023070E+03, 2.5526817857E+03, 9.3724231605E-01],
	[3.19450E+04, 1.9999935343E+04, 5.0208306022E+03, 7.0180610284E+03, 2.5532356431E+03, 9.3727193959E-01],
	[3.19500E+04, 2.0005198216E+04, 5.0208187341E+03, 7.0216209964E+03, 2.5537893923E+03, 9.3730154758E-01],
	[3.19550E+04, 2.0010461650E+04, 5.0208068679E+03, 7.0251822113E+03, 2.5543430334E+03, 9.3733114002E-01],
	[3.19600E+04, 2.0015725646E+04, 5.0207950036E+03, 7.0287446734E+03, 2.5548965663E+03, 9.3736071692E-01],
	[3.19650E+04, 2.0020990202E+04, 5.0207831412E+03, 7.0323083829E+03, 2.5554499911E+03, 9.3739027828E-01],
	[3.19700E+04, 2.0026255319E+04, 5.0207712806E+03, 7.0358733401E+03, 2.5560033076E+03, 9.3741982412E-01],
	[3.19750E+04, 2.0031520998E+04, 5.0207594219E+03, 7.0394395451E+03, 2.5565565159E+03, 9.3744935444E-01],
	[3.19800E+04, 2.0036787237E+04, 5.0207475651E+03, 7.0430069982E+03, 2.5571096159E+03, 9.3747886926E-01],
	[3.19850E+04, 2.0042054037E+04, 5.0207357102E+03, 7.0465756997E+03, 2.5576626077E+03, 9.3750836856E-01],
	[3.19900E+04, 2.0047321397E+04, 5.0207238572E+03, 7.0501456498E+03, 2.5582154912E+03, 9.3753785238E-01],
	[3.19950E+04, 2.0052589319E+04, 5.0207120060E+03, 7.0537168487E+03, 2.5587682664E+03, 9.3756732071E-01],
	[3.20000E+04, 2.0057857801E+04, 5.0207001568E+03, 7.0572892967E+03, 2.5593209332E+03, 9.3759677356E-01],
	[3.20050E+04, 2.0063126844E+04, 5.0206883094E+03, 7.0608629940E+03, 2.5598734918E+03, 9.3762621094E-01],
	[3.20100E+04, 2.0068396448E+04, 5.0206764639E+03, 7.0644379409E+03, 2.5604259419E+03, 9.3765563285E-01],
	[3.20150E+04, 2.0073666613E+04, 5.0206646202E+03, 7.0680141375E+03, 2.5609782837E+03, 9.3768503932E-01],
	[3.20200E+04, 2.0078937338E+04, 5.0206527785E+03, 7.0715915843E+03, 2.5615305171E+03, 9.3771443033E-01],
	[3.20250E+04, 2.0084208624E+04, 5.0206409386E+03, 7.0751702813E+03, 2.5620826420E+03, 9.3774380590E-01],
	[3.20300E+04, 2.0089480470E+04, 5.0206291006E+03, 7.0787502288E+03, 2.5626346585E+03, 9.3777316605E-01],
	[3.20350E+04, 2.0094752877E+04, 5.0206172645E+03, 7.0823314271E+03, 2.5631865666E+03, 9.3780251077E-01],
	[3.20400E+04, 2.0100025844E+04, 5.0206054302E+03, 7.0859138764E+03, 2.5637383662E+03, 9.3783184007E-01],
	[3.20450E+04, 2.0105299373E+04, 5.0205935979E+03, 7.0894975770E+03, 2.5642900573E+03, 9.3786115396E-01],
	[3.20500E+04, 2.0110573461E+04, 5.0205817673E+03, 7.0930825290E+03, 2.5648416398E+03, 9.3789045246E-01],
	[3.20550E+04, 2.0115848110E+04, 5.0205699387E+03, 7.0966687328E+03, 2.5653931139E+03, 9.3791973556E-01],
	[3.20600E+04, 2.0121123319E+04, 5.0205581120E+03, 7.1002561885E+03, 2.5659444794E+03, 9.3794900328E-01],
	[3.20650E+04, 2.0126399089E+04, 5.0205462871E+03, 7.1038448965E+03, 2.5664957363E+03, 9.3797825561E-01],
	[3.20700E+04, 2.0131675420E+04, 5.0205344641E+03, 7.1074348569E+03, 2.5670468846E+03, 9.3800749259E-01],
	[3.20750E+04, 2.0136952310E+04, 5.0205226429E+03, 7.1110260700E+03, 2.5675979243E+03, 9.3803671419E-01],
	[3.20800E+04, 2.0142229761E+04, 5.0205108236E+03, 7.1146185360E+03, 2.5681488554E+03, 9.3806592045E-01],
	[3.20850E+04, 2.0147507772E+04, 5.0204990062E+03, 7.1182122552E+03, 2.5686996779E+03, 9.3809511136E-01],
	[3.20900E+04, 2.0152786344E+04, 5.0204871907E+03, 7.1218072279E+03, 2.5692503917E+03, 9.3812428693E-01],
	[3.20950E+04, 2.0158065475E+04, 5.0204753771E+03, 7.1254034542E+03, 2.5698009968E+03, 9.3815344717E-01],
	[3.21000E+04, 2.0163345167E+04, 5.0204635653E+03, 7.1290009343E+03, 2.5703514932E+03, 9.3818259209E-01],
	[3.21050E+04, 2.0168625420E+04, 5.0204517553E+03, 7.1325996687E+03, 2.5709018809E+03, 9.3821172170E-01],
	[3.21100E+04, 2.0173906232E+04, 5.0204399473E+03, 7.1361996574E+03, 2.5714521599E+03, 9.3824083599E-01],
	[3.21150E+04, 2.0179187604E+04, 5.0204281411E+03, 7.1398009007E+03, 2.5720023301E+03, 9.3826993499E-01],
	[3.21200E+04, 2.0184469537E+04, 5.0204163367E+03, 7.1434033989E+03, 2.5725523915E+03, 9.3829901870E-01],
	[3.21250E+04, 2.0189752029E+04, 5.0204045343E+03, 7.1470071522E+03, 2.5731023441E+03, 9.3832808712E-01],
	[3.21300E+04, 2.0195035082E+04, 5.0203927337E+03, 7.1506121608E+03, 2.5736521880E+03, 9.3835714027E-01],
	[3.21350E+04, 2.0200318695E+04, 5.0203809349E+03, 7.1542184251E+03, 2.5742019230E+03, 9.3838617815E-01],
	[3.21400E+04, 2.0205602867E+04, 5.0203691381E+03, 7.1578259451E+03, 2.5747515491E+03, 9.3841520078E-01],
	[3.21450E+04, 2.0210887600E+04, 5.0203573431E+03, 7.1614347212E+03, 2.5753010665E+03, 9.3844420815E-01],
	[3.21500E+04, 2.0216172893E+04, 5.0203455499E+03, 7.1650447537E+03, 2.5758504749E+03, 9.3847320027E-01],
	[3.21550E+04, 2.0221458745E+04, 5.0203337586E+03, 7.1686560426E+03, 2.5763997744E+03, 9.3850217716E-01],
	[3.21600E+04, 2.0226745157E+04, 5.0203219692E+03, 7.1722685884E+03, 2.5769489650E+03, 9.3853113882E-01],
	[3.21650E+04, 2.0232032130E+04, 5.0203101816E+03, 7.1758823912E+03, 2.5774980467E+03, 9.3856008526E-01],
	[3.21700E+04, 2.0237319662E+04, 5.0202983959E+03, 7.1794974513E+03, 2.5780470194E+03, 9.3858901649E-01],
	[3.21750E+04, 2.0242607753E+04, 5.0202866121E+03, 7.1831137689E+03, 2.5785958832E+03, 9.3861793251E-01],
	[3.21800E+04, 2.0247896405E+04, 5.0202748301E+03, 7.1867313442E+03, 2.5791446380E+03, 9.3864683333E-01],
	[3.21850E+04, 2.0253185616E+04, 5.0202630500E+03, 7.1903501776E+03, 2.5796932837E+03, 9.3867571897E-01],
	[3.21900E+04, 2.0258475388E+04, 5.0202512717E+03, 7.1939702692E+03, 2.5802418205E+03, 9.3870458942E-01],
	[3.21950E+04, 2.0263765718E+04, 5.0202394953E+03, 7.1975916193E+03, 2.5807902482E+03, 9.3873344470E-01],
	[3.22000E+04, 2.0269056609E+04, 5.0202277207E+03, 7.2012142280E+03, 2.5813385669E+03, 9.3876228481E-01],
	[3.22050E+04, 2.0274348059E+04, 5.0202159480E+03, 7.2048380958E+03, 2.5818867764E+03, 9.3879110977E-01],
	[3.22100E+04, 2.0279640068E+04, 5.0202041772E+03, 7.2084632227E+03, 2.5824348769E+03, 9.3881991957E-01],
	[3.22150E+04, 2.0284932638E+04, 5.0201924082E+03, 7.2120896091E+03, 2.5829828683E+03, 9.3884871423E-01],
	[3.22200E+04, 2.0290225766E+04, 5.0201806411E+03, 7.2157172552E+03, 2.5835307506E+03, 9.3887749376E-01],
	[3.22250E+04, 2.0295519455E+04, 5.0201688758E+03, 7.2193461612E+03, 2.5840785237E+03, 9.3890625816E-01],
	[3.22300E+04, 2.0300813702E+04, 5.0201571123E+03, 7.2229763274E+03, 2.5846261877E+03, 9.3893500744E-01],
	[3.22350E+04, 2.0306108510E+04, 5.0201453508E+03, 7.2266077540E+03, 2.5851737424E+03, 9.3896374161E-01],
	[3.22400E+04, 2.0311403876E+04, 5.0201335910E+03, 7.2302404413E+03, 2.5857211880E+03, 9.3899246067E-01],
	[3.22450E+04, 2.0316699803E+04, 5.0201218332E+03, 7.2338743894E+03, 2.5862685244E+03, 9.3902116464E-01],
	[3.22500E+04, 2.0321996288E+04, 5.0201100771E+03, 7.2375095987E+03, 2.5868157516E+03, 9.3904985352E-01],
	[3.22550E+04, 2.0327293333E+04, 5.0200983230E+03, 7.2411460693E+03, 2.5873628695E+03, 9.3907852732E-01],
	[3.22600E+04, 2.0332590937E+04, 5.0200865706E+03, 7.2447838016E+03, 2.5879098781E+03, 9.3910718605E-01],
	[3.22650E+04, 2.0337889100E+04, 5.0200748202E+03, 7.2484227957E+03, 2.5884567775E+03, 9.3913582972E-01],
	[3.22700E+04, 2.0343187823E+04, 5.0200630715E+03, 7.2520630519E+03, 2.5890035676E+03, 9.3916445832E-01],
	[3.22750E+04, 2.0348487105E+04, 5.0200513247E+03, 7.2557045705E+03, 2.5895502484E+03, 9.3919307188E-01],
	[3.22800E+04, 2.0353786946E+04, 5.0200395798E+03, 7.2593473516E+03, 2.5900968198E+03, 9.3922167040E-01],
	[3.22850E+04, 2.0359087347E+04, 5.0200278367E+03, 7.2629913955E+03, 2.5906432819E+03, 9.3925025388E-01],
	[3.22900E+04, 2.0364388306E+04, 5.0200160955E+03, 7.2666367026E+03, 2.5911896346E+03, 9.3927882234E-01],
	[3.22950E+04, 2.0369689825E+04, 5.0200043561E+03, 7.2702832729E+03, 2.5917358780E+03, 9.3930737578E-01],
	[3.23000E+04, 2.0374991903E+04, 5.0199926185E+03, 7.2739311068E+03, 2.5922820119E+03, 9.3933591421E-01],
	[3.23050E+04, 2.0380294540E+04, 5.0199808828E+03, 7.2775802044E+03, 2.5928280365E+03, 9.3936443764E-01],
	[3.23100E+04, 2.0385597736E+04, 5.0199691490E+03, 7.2812305661E+03, 2.5933739516E+03, 9.3939294608E-01],
	[3.23150E+04, 2.0390901491E+04, 5.0199574169E+03, 7.2848821921E+03, 2.5939197573E+03, 9.3942143953E-01],
	[3.23200E+04, 2.0396205805E+04, 5.0199456868E+03, 7.2885350826E+03, 2.5944654535E+03, 9.3944991799E-01],
	[3.23250E+04, 2.0401510678E+04, 5.0199339584E+03, 7.2921892378E+03, 2.5950110402E+03, 9.3947838149E-01],
	[3.23300E+04, 2.0406816109E+04, 5.0199222319E+03, 7.2958446580E+03, 2.5955565175E+03, 9.3950683003E-01],
	[3.23350E+04, 2.0412122100E+04, 5.0199105073E+03, 7.2995013435E+03, 2.5961018852E+03, 9.3953526361E-01],
	[3.23400E+04, 2.0417428650E+04, 5.0198987845E+03, 7.3031592944E+03, 2.5966471434E+03, 9.3956368224E-01],
	[3.23450E+04, 2.0422735758E+04, 5.0198870635E+03, 7.3068185111E+03, 2.5971922921E+03, 9.3959208593E-01],
	[3.23500E+04, 2.0428043426E+04, 5.0198753444E+03, 7.3104789937E+03, 2.5977373312E+03, 9.3962047469E-01],
	[3.23550E+04, 2.0433351652E+04, 5.0198636271E+03, 7.3141407425E+03, 2.5982822608E+03, 9.3964884853E-01],
	[3.23600E+04, 2.0438660437E+04, 5.0198519116E+03, 7.3178037578E+03, 2.5988270807E+03, 9.3967720745E-01],
	[3.23650E+04, 2.0443969780E+04, 5.0198401980E+03, 7.3214680398E+03, 2.5993717911E+03, 9.3970555146E-01],
	[3.23700E+04, 2.0449279683E+04, 5.0198284862E+03, 7.3251335886E+03, 2.5999163918E+03, 9.3973388057E-01],
	[3.23750E+04, 2.0454590144E+04, 5.0198167763E+03, 7.3288004047E+03, 2.6004608829E+03, 9.3976219479E-01],
	[3.23800E+04, 2.0459901164E+04, 5.0198050682E+03, 7.3324684882E+03, 2.6010052644E+03, 9.3979049412E-01],
	[3.23850E+04, 2.0465212742E+04, 5.0197933619E+03, 7.3361378393E+03, 2.6015495361E+03, 9.3981877858E-01],
	[3.23900E+04, 2.0470524879E+04, 5.0197816574E+03, 7.3398084583E+03, 2.6020936982E+03, 9.3984704816E-01],
	[3.23950E+04, 2.0475837575E+04, 5.0197699548E+03, 7.3434803454E+03, 2.6026377506E+03, 9.3987530289E-01],
	[3.24000E+04, 2.0481150829E+04, 5.0197582540E+03, 7.3471535009E+03, 2.6031816933E+03, 9.3990354276E-01],
	[3.24050E+04, 2.0486464642E+04, 5.0197465551E+03, 7.3508279251E+03, 2.6037255262E+03, 9.3993176778E-01],
	[3.24100E+04, 2.0491779013E+04, 5.0197348580E+03, 7.3545036180E+03, 2.6042692494E+03, 9.3995997796E-01],
	[3.24150E+04, 2.0497093942E+04, 5.0197231627E+03, 7.3581805801E+03, 2.6048128628E+03, 9.3998817332E-01],
	[3.24200E+04, 2.0502409430E+04, 5.0197114693E+03, 7.3618588116E+03, 2.6053563665E+03, 9.4001635385E-01],
	[3.24250E+04, 2.0507725477E+04, 5.0196997777E+03, 7.3655383126E+03, 2.6058997603E+03, 9.4004451957E-01],
	[3.24300E+04, 2.0513042082E+04, 5.0196880879E+03, 7.3692190834E+03, 2.6064430444E+03, 9.4007267048E-01],
	[3.24350E+04, 2.0518359245E+04, 5.0196763999E+03, 7.3729011243E+03, 2.6069862186E+03, 9.4010080659E-01],
	[3.24400E+04, 2.0523676967E+04, 5.0196647138E+03, 7.3765844356E+03, 2.6075292830E+03, 9.4012892791E-01],
	[3.24450E+04, 2.0528995247E+04, 5.0196530295E+03, 7.3802690173E+03, 2.6080722375E+03, 9.4015703444E-01],
	[3.24500E+04, 2.0534314085E+04, 5.0196413470E+03, 7.3839548699E+03, 2.6086150822E+03, 9.4018512620E-01],
	[3.24550E+04, 2.0539633481E+04, 5.0196296664E+03, 7.3876419935E+03, 2.6091578170E+03, 9.4021320319E-01],
	[3.24600E+04, 2.0544953436E+04, 5.0196179875E+03, 7.3913303883E+03, 2.6097004419E+03, 9.4024126542E-01],
	[3.24650E+04, 2.0550273949E+04, 5.0196063106E+03, 7.3950200547E+03, 2.6102429568E+03, 9.4026931289E-01],
	[3.24700E+04, 2.0555595020E+04, 5.0195946354E+03, 7.3987109929E+03, 2.6107853619E+03, 9.4029734563E-01],
	[3.24750E+04, 2.0560916649E+04, 5.0195829620E+03, 7.4024032030E+03, 2.6113276570E+03, 9.4032536362E-01],
	[3.24800E+04, 2.0566238836E+04, 5.0195712905E+03, 7.4060966854E+03, 2.6118698421E+03, 9.4035336689E-01],
	[3.24850E+04, 2.0571561582E+04, 5.0195596208E+03, 7.4097914403E+03, 2.6124119172E+03, 9.4038135543E-01],
	[3.24900E+04, 2.0576884885E+04, 5.0195479530E+03, 7.4134874679E+03, 2.6129538824E+03, 9.4040932926E-01],
	[3.24950E+04, 2.0582208747E+04, 5.0195362869E+03, 7.4171847684E+03, 2.6134957376E+03, 9.4043728838E-01],
	[3.25000E+04, 2.0587533166E+04, 5.0195246227E+03, 7.4208833422E+03, 2.6140374827E+03, 9.4046523281E-01],
	[3.25050E+04, 2.0592858144E+04, 5.0195129603E+03, 7.4245831894E+03, 2.6145791178E+03, 9.4049316254E-01],
	[3.25100E+04, 2.0598183679E+04, 5.0195012997E+03, 7.4282843103E+03, 2.6151206429E+03, 9.4052107760E-01],
	[3.25150E+04, 2.0603509772E+04, 5.0194896409E+03, 7.4319867052E+03, 2.6156620579E+03, 9.4054897797E-01],
	[3.25200E+04, 2.0608836424E+04, 5.0194779840E+03, 7.4356903742E+03, 2.6162033628E+03, 9.4057686368E-01],
	[3.25250E+04, 2.0614163633E+04, 5.0194663289E+03, 7.4393953176E+03, 2.6167445576E+03, 9.4060473473E-01],
	[3.25300E+04, 2.0619491400E+04, 5.0194546756E+03, 7.4431015357E+03, 2.6172856423E+03, 9.4063259113E-01],
	[3.25350E+04, 2.0624819725E+04, 5.0194430241E+03, 7.4468090287E+03, 2.6178266169E+03, 9.4066043289E-01],
	[3.25400E+04, 2.0630148607E+04, 5.0194313744E+03, 7.4505177969E+03, 2.6183674814E+03, 9.4068826001E-01],
	[3.25450E+04, 2.0635478048E+04, 5.0194197265E+03, 7.4542278404E+03, 2.6189082357E+03, 9.4071607250E-01],
	[3.25500E+04, 2.0640808046E+04, 5.0194080805E+03, 7.4579391596E+03, 2.6194488798E+03, 9.4074387037E-01],
	[3.25550E+04, 2.0646138601E+04, 5.0193964363E+03, 7.4616517546E+03, 2.6199894138E+03, 9.4077165363E-01],
	[3.25600E+04, 2.0651469715E+04, 5.0193847939E+03, 7.4653656257E+03, 2.6205298375E+03, 9.4079942228E-01],
	[3.25650E+04, 2.0656801386E+04, 5.0193731533E+03, 7.4690807732E+03, 2.6210701511E+03, 9.4082717633E-01],
	[3.25700E+04, 2.0662133615E+04, 5.0193615145E+03, 7.4727971973E+03, 2.6216103544E+03, 9.4085491580E-01],
	[3.25750E+04, 2.0667466401E+04, 5.0193498775E+03, 7.4765148982E+03, 2.6221504475E+03, 9.4088264068E-01],
	[3.25800E+04, 2.0672799745E+04, 5.0193382424E+03, 7.4802338762E+03, 2.6226904304E+03, 9.4091035099E-01],
	[3.25850E+04, 2.0678133646E+04, 5.0193266091E+03, 7.4839541315E+03, 2.6232303030E+03, 9.4093804674E-01],
	[3.25900E+04, 2.0683468105E+04, 5.0193149775E+03, 7.4876756643E+03, 2.6237700653E+03, 9.4096572792E-01],
	[3.25950E+04, 2.0688803122E+04, 5.0193033478E+03, 7.4913984750E+03, 2.6243097173E+03, 9.4099339456E-01],
	[3.26000E+04, 2.0694138696E+04, 5.0192917199E+03, 7.4951225637E+03, 2.6248492590E+03, 9.4102104665E-01],
	[3.26050E+04, 2.0699474827E+04, 5.0192800938E+03, 7.4988479307E+03, 2.6253886904E+03, 9.4104868420E-01],
	[3.26100E+04, 2.0704811516E+04, 5.0192684695E+03, 7.5025745762E+03, 2.6259280114E+03, 9.4107630723E-01],
	[3.26150E+04, 2.0710148762E+04, 5.0192568471E+03, 7.5063025005E+03, 2.6264672221E+03, 9.4110391574E-01],
	[3.26200E+04, 2.0715486565E+04, 5.0192452264E+03, 7.5100317038E+03, 2.6270063225E+03, 9.4113150974E-01],
	[3.26250E+04, 2.0720824926E+04, 5.0192336075E+03, 7.5137621864E+03, 2.6275453124E+03, 9.4115908923E-01],
	[3.26300E+04, 2.0726163844E+04, 5.0192219905E+03, 7.5174939485E+03, 2.6280841920E+03, 9.4118665423E-01],
	[3.26350E+04, 2.0731503320E+04, 5.0192103752E+03, 7.5212269903E+03, 2.6286229612E+03, 9.4121420474E-01],
	[3.26400E+04, 2.0736843352E+04, 5.0191987618E+03, 7.5249613120E+03, 2.6291616199E+03, 9.4124174077E-01],
	[3.26450E+04, 2.0742183942E+04, 5.0191871502E+03, 7.5286969140E+03, 2.6297001683E+03, 9.4126926232E-01],
	[3.26500E+04, 2.0747525089E+04, 5.0191755403E+03, 7.5324337965E+03, 2.6302386061E+03, 9.4129676941E-01],
	[3.26550E+04, 2.0752866793E+04, 5.0191639323E+03, 7.5361719597E+03, 2.6307769336E+03, 9.4132426204E-01],
	[3.26600E+04, 2.0758209054E+04, 5.0191523261E+03, 7.5399114038E+03, 2.6313151505E+03, 9.4135174022E-01],
	[3.26650E+04, 2.0763551873E+04, 5.0191407217E+03, 7.5436521291E+03, 2.6318532570E+03, 9.4137920396E-01],
	[3.26700E+04, 2.0768895248E+04, 5.0191291191E+03, 7.5473941358E+03, 2.6323912530E+03, 9.4140665326E-01],
	[3.26750E+04, 2.0774239181E+04, 5.0191175183E+03, 7.5511374242E+03, 2.6329291384E+03, 9.4143408814E-01],
	[3.26800E+04, 2.0779583670E+04, 5.0191059192E+03, 7.5548819946E+03, 2.6334669134E+03, 9.4146150860E-01],
	[3.26850E+04, 2.0784928717E+04, 5.0190943220E+03, 7.5586278471E+03, 2.6340045778E+03, 9.4148891465E-01],
	[3.26900E+04, 2.0790274321E+04, 5.0190827266E+03, 7.5623749819E+03, 2.6345421316E+03, 9.4151630629E-01],
	[3.26950E+04, 2.0795620481E+04, 5.0190711330E+03, 7.5661233995E+03, 2.6350795749E+03, 9.4154368354E-01],
	[3.27000E+04, 2.0800967198E+04, 5.0190595412E+03, 7.5698730999E+03, 2.6356169076E+03, 9.4157104640E-01],
	[3.27050E+04, 2.0806314473E+04, 5.0190479512E+03, 7.5736240834E+03, 2.6361541297E+03, 9.4159839488E-01],
	[3.27100E+04, 2.0811662304E+04, 5.0190363630E+03, 7.5773763503E+03, 2.6366912413E+03, 9.4162572899E-01],
	[3.27150E+04, 2.0817010692E+04, 5.0190247766E+03, 7.5811299008E+03, 2.6372282422E+03, 9.4165304873E-01],
	[3.27200E+04, 2.0822359637E+04, 5.0190131920E+03, 7.5848847352E+03, 2.6377651324E+03, 9.4168035412E-01],
	[3.27250E+04, 2.0827709138E+04, 5.0190016092E+03, 7.5886408536E+03, 2.6383019121E+03, 9.4170764515E-01],
	[3.27300E+04, 2.0833059197E+04, 5.0189900281E+03, 7.5923982564E+03, 2.6388385810E+03, 9.4173492185E-01],
	[3.27350E+04, 2.0838409812E+04, 5.0189784489E+03, 7.5961569438E+03, 2.6393751394E+03, 9.4176218421E-01],
	[3.27400E+04, 2.0843760983E+04, 5.0189668715E+03, 7.5999169160E+03, 2.6399115870E+03, 9.4178943224E-01],
	[3.27450E+04, 2.0849112712E+04, 5.0189552959E+03, 7.6036781733E+03, 2.6404479239E+03, 9.4181666596E-01],
	[3.27500E+04, 2.0854464997E+04, 5.0189437220E+03, 7.6074407158E+03, 2.6409841502E+03, 9.4184388536E-01],
	[3.27550E+04, 2.0859817839E+04, 5.0189321500E+03, 7.6112045439E+03, 2.6415202657E+03, 9.4187109047E-01],
	[3.27600E+04, 2.0865171237E+04, 5.0189205797E+03, 7.6149696578E+03, 2.6420562704E+03, 9.4189828127E-01],
	[3.27650E+04, 2.0870525192E+04, 5.0189090113E+03, 7.6187360577E+03, 2.6425921645E+03, 9.4192545779E-01],
	[3.27700E+04, 2.0875879703E+04, 5.0188974446E+03, 7.6225037439E+03, 2.6431279478E+03, 9.4195262003E-01],
	[3.27750E+04, 2.0881234771E+04, 5.0188858797E+03, 7.6262727167E+03, 2.6436636203E+03, 9.4197976800E-01],
	[3.27800E+04, 2.0886590395E+04, 5.0188743166E+03, 7.6300429761E+03, 2.6441991820E+03, 9.4200690170E-01],
	[3.27850E+04, 2.0891946576E+04, 5.0188627553E+03, 7.6338145226E+03, 2.6447346329E+03, 9.4203402115E-01],
	[3.27900E+04, 2.0897303313E+04, 5.0188511958E+03, 7.6375873563E+03, 2.6452699731E+03, 9.4206112635E-01],
	[3.27950E+04, 2.0902660607E+04, 5.0188396381E+03, 7.6413614775E+03, 2.6458052024E+03, 9.4208821730E-01],
	[3.28000E+04, 2.0908018457E+04, 5.0188280822E+03, 7.6451368864E+03, 2.6463403209E+03, 9.4211529403E-01],
	[3.28050E+04, 2.0913376864E+04, 5.0188165280E+03, 7.6489135833E+03, 2.6468753285E+03, 9.4214235652E-01],
	[3.28100E+04, 2.0918735826E+04, 5.0188049757E+03, 7.6526915684E+03, 2.6474102253E+03, 9.4216940480E-01],
	[3.28150E+04, 2.0924095345E+04, 5.0187934251E+03, 7.6564708420E+03, 2.6479450112E+03, 9.4219643887E-01],
	[3.28200E+04, 2.0929455420E+04, 5.0187818763E+03, 7.6602514043E+03, 2.6484796863E+03, 9.4222345873E-01],
	[3.28250E+04, 2.0934816052E+04, 5.0187703293E+03, 7.6640332554E+03, 2.6490142504E+03, 9.4225046440E-01],
	[3.28300E+04, 2.0940177240E+04, 5.0187587841E+03, 7.6678163958E+03, 2.6495487036E+03, 9.4227745589E-01],
	[3.28350E+04, 2.0945538984E+04, 5.0187472407E+03, 7.6716008256E+03, 2.6500830460E+03, 9.4230443319E-01],
	[3.28400E+04, 2.0950901284E+04, 5.0187356991E+03, 7.6753865451E+03, 2.6506172774E+03, 9.4233139632E-01],
	[3.28450E+04, 2.0956264140E+04, 5.0187241592E+03, 7.6791735544E+03, 2.6511513978E+03, 9.4235834529E-01],
	[3.28500E+04, 2.0961627552E+04, 5.0187126211E+03, 7.6829618539E+03, 2.6516854074E+03, 9.4238528010E-01],
	[3.28550E+04, 2.0966991521E+04, 5.0187010848E+03, 7.6867514438E+03, 2.6522193059E+03, 9.4241220076E-01],
	[3.28600E+04, 2.0972356045E+04, 5.0186895503E+03, 7.6905423244E+03, 2.6527530935E+03, 9.4243910728E-01],
	[3.28650E+04, 2.0977721125E+04, 5.0186780176E+03, 7.6943344958E+03, 2.6532867701E+03, 9.4246599967E-01],
	[3.28700E+04, 2.0983086762E+04, 5.0186664866E+03, 7.6981279583E+03, 2.6538203356E+03, 9.4249287793E-01],
	[3.28750E+04, 2.0988452954E+04, 5.0186549575E+03, 7.7019227122E+03, 2.6543537902E+03, 9.4251974207E-01],
	[3.28800E+04, 2.0993819703E+04, 5.0186434301E+03, 7.7057187577E+03, 2.6548871338E+03, 9.4254659211E-01],
	[3.28850E+04, 2.0999187007E+04, 5.0186319045E+03, 7.7095160950E+03, 2.6554203663E+03, 9.4257342804E-01],
	[3.28900E+04, 2.1004554867E+04, 5.0186203807E+03, 7.7133147245E+03, 2.6559534878E+03, 9.4260024987E-01],
	[3.28950E+04, 2.1009923283E+04, 5.0186088586E+03, 7.7171146462E+03, 2.6564864982E+03, 9.4262705762E-01],
	[3.29000E+04, 2.1015292255E+04, 5.0185973383E+03, 7.7209158606E+03, 2.6570193976E+03, 9.4265385129E-01],
	[3.29050E+04, 2.1020661783E+04, 5.0185858198E+03, 7.7247183677E+03, 2.6575521858E+03, 9.4268063088E-01],
	[3.29100E+04, 2.1026031866E+04, 5.0185743031E+03, 7.7285221679E+03, 2.6580848630E+03, 9.4270739641E-01],
	[3.29150E+04, 2.1031402505E+04, 5.0185627882E+03, 7.7323272614E+03, 2.6586174291E+03, 9.4273414789E-01],
	[3.29200E+04, 2.1036773700E+04, 5.0185512750E+03, 7.7361336484E+03, 2.6591498841E+03, 9.4276088532E-01],
	[3.29250E+04, 2.1042145451E+04, 5.0185397636E+03, 7.7399413293E+03, 2.6596822279E+03, 9.4278760870E-01],
	[3.29300E+04, 2.1047517757E+04, 5.0185282540E+03, 7.7437503041E+03, 2.6602144606E+03, 9.4281431805E-01],
	[3.29350E+04, 2.1052890619E+04, 5.0185167462E+03, 7.7475605732E+03, 2.6607465822E+03, 9.4284101338E-01],
	[3.29400E+04, 2.1058264037E+04, 5.0185052401E+03, 7.7513721369E+03, 2.6612785926E+03, 9.4286769468E-01],
	[3.29450E+04, 2.1063638010E+04, 5.0184937358E+03, 7.7551849953E+03, 2.6618104918E+03, 9.4289436198E-01],
	[3.29500E+04, 2.1069012538E+04, 5.0184822333E+03, 7.7589991487E+03, 2.6623422798E+03, 9.4292101527E-01],
	[3.29550E+04, 2.1074387623E+04, 5.0184707325E+03, 7.7628145973E+03, 2.6628739567E+03, 9.4294765457E-01],
	[3.29600E+04, 2.1079763262E+04, 5.0184592335E+03, 7.7666313414E+03, 2.6634055224E+03, 9.4297427988E-01],
	[3.29650E+04, 2.1085139458E+04, 5.0184477363E+03, 7.7704493812E+03, 2.6639369768E+03, 9.4300089121E-01],
	[3.29700E+04, 2.1090516208E+04, 5.0184362409E+03, 7.7742687170E+03, 2.6644683200E+03, 9.4302748857E-01],
	[3.29750E+04, 2.1095893515E+04, 5.0184247472E+03, 7.7780893490E+03, 2.6649995520E+03, 9.4305407196E-01],
	[3.29800E+04, 2.1101271376E+04, 5.0184132553E+03, 7.7819112775E+03, 2.6655306727E+03, 9.4308064140E-01],
	[3.29850E+04, 2.1106649793E+04, 5.0184017652E+03, 7.7857345026E+03, 2.6660616822E+03, 9.4310719688E-01],
	[3.29900E+04, 2.1112028765E+04, 5.0183902768E+03, 7.7895590247E+03, 2.6665925804E+03, 9.4313373843E-01],
	[3.29950E+04, 2.1117408293E+04, 5.0183787902E+03, 7.7933848440E+03, 2.6671233673E+03, 9.4316026604E-01],
	[3.30000E+04, 2.1122788376E+04, 5.0183673053E+03, 7.7972119607E+03, 2.6676540430E+03, 9.4318677973E-01],
	[3.30050E+04, 2.1128169014E+04, 5.0183558223E+03, 7.8010403750E+03, 2.6681846073E+03, 9.4321327949E-01],
	[3.30100E+04, 2.1133550207E+04, 5.0183443410E+03, 7.8048700873E+03, 2.6687150604E+03, 9.4323976535E-01],
	[3.30150E+04, 2.1138953282E+04, 5.0183369232E+03, 7.8087010977E+03, 2.6692468913E+03, 9.4326623730E-01],
	[3.30200E+04, 2.1144376248E+04, 5.0183331868E+03, 7.8125334065E+03, 2.6697799613E+03, 9.4329269535E-01],
	[3.30250E+04, 2.1149799783E+04, 5.0183294509E+03, 7.8163670139E+03, 2.6703129216E+03, 9.4331913952E-01],
	[3.30300E+04, 2.1155223889E+04, 5.0183257155E+03, 7.8202019202E+03, 2.6708457720E+03, 9.4334556981E-01],
	[3.30350E+04, 2.1160648564E+04, 5.0183219808E+03, 7.8240381256E+03, 2.6713785125E+03, 9.4337198622E-01],
	[3.30400E+04, 2.1166073808E+04, 5.0183182466E+03, 7.8278756304E+03, 2.6719111432E+03, 9.4339838877E-01],
	[3.30450E+04, 2.1171499622E+04, 5.0183145130E+03, 7.8317144348E+03, 2.6724436640E+03, 9.4342477746E-01],
	[3.30500E+04, 2.1176926006E+04, 5.0183107799E+03, 7.8355545391E+03, 2.6729760749E+03, 9.4345115230E-01],
	[3.30550E+04, 2.1182352960E+04, 5.0183070475E+03, 7.8393959434E+03, 2.6735083759E+03, 9.4347751330E-01],
	[3.30600E+04, 2.1187780483E+04, 5.0183033155E+03, 7.8432386481E+03, 2.6740405670E+03, 9.4350386046E-01],
	[3.30650E+04, 2.1193208576E+04, 5.0182995842E+03, 7.8470826533E+03, 2.6745726482E+03, 9.4353019380E-01],
	[3.30700E+04, 2.1198637238E+04, 5.0182958534E+03, 7.8509279594E+03, 2.6751046194E+03, 9.4355651331E-01],
	[3.30750E+04, 2.1204066470E+04, 5.0182921232E+03, 7.8547745665E+03, 2.6756364807E+03, 9.4358281902E-01],
	[3.30800E+04, 2.1209496271E+04, 5.0182883936E+03, 7.8586224749E+03, 2.6761682320E+03, 9.4360911092E-01],
	[3.30850E+04, 2.1214926642E+04, 5.0182846645E+03, 7.8624716849E+03, 2.6766998734E+03, 9.4363538902E-01],
	[3.30900E+04, 2.1220357582E+04, 5.0182809360E+03, 7.8663221967E+03, 2.6772314048E+03, 9.4366165334E-01],
	[3.30950E+04, 2.1225789092E+04, 5.0182772080E+03, 7.8701740105E+03, 2.6777628262E+03, 9.4368790387E-01],
	[3.31000E+04, 2.1231221171E+04, 5.0182734806E+03, 7.8740271265E+03, 2.6782941376E+03, 9.4371414063E-01],
	[3.31050E+04, 2.1236653819E+04, 5.0182697538E+03, 7.8778815451E+03, 2.6788253390E+03, 9.4374036362E-01],
	[3.31100E+04, 2.1242087037E+04, 5.0182660276E+03, 7.8817372664E+03, 2.6793564304E+03, 9.4376657286E-01],
	[3.31150E+04, 2.1247520824E+04, 5.0182623019E+03, 7.8855942908E+03, 2.6798874118E+03, 9.4379276834E-01],
	[3.31200E+04, 2.1252955181E+04, 5.0182585768E+03, 7.8894526184E+03, 2.6804182831E+03, 9.4381895008E-01],
	[3.31250E+04, 2.1258390106E+04, 5.0182548522E+03, 7.8933122495E+03, 2.6809490444E+03, 9.4384511808E-01],
	[3.31300E+04, 2.1263825601E+04, 5.0182511282E+03, 7.8971731843E+03, 2.6814796956E+03, 9.4387127236E-01],
	[3.31350E+04, 2.1269261665E+04, 5.0182474048E+03, 7.9010354231E+03, 2.6820102368E+03, 9.4389741292E-01],
	[3.31400E+04, 2.1274698298E+04, 5.0182436819E+03, 7.9048989660E+03, 2.6825406678E+03, 9.4392353976E-01],
	[3.31450E+04, 2.1280135500E+04, 5.0182399596E+03, 7.9087638135E+03, 2.6830709888E+03, 9.4394965290E-01],
	[3.31500E+04, 2.1285573272E+04, 5.0182362379E+03, 7.9126299657E+03, 2.6836011997E+03, 9.4397575233E-01],
	[3.31550E+04, 2.1291011613E+04, 5.0182325167E+03, 7.9164974228E+03, 2.6841313005E+03, 9.4400183808E-01],
	[3.31600E+04, 2.1296450522E+04, 5.0182287961E+03, 7.9203661851E+03, 2.6846612911E+03, 9.4402791015E-01],
	[3.31650E+04, 2.1301890001E+04, 5.0182250761E+03, 7.9242362528E+03, 2.6851911716E+03, 9.4405396854E-01],
	[3.31700E+04, 2.1307330049E+04, 5.0182213566E+03, 7.9281076262E+03, 2.6857209420E+03, 9.4408001326E-01],
	[3.31750E+04, 2.1312770665E+04, 5.0182176377E+03, 7.9319803055E+03, 2.6862506023E+03, 9.4410604433E-01],
	[3.31800E+04, 2.1318211851E+04, 5.0182139193E+03, 7.9358542910E+03, 2.6867801524E+03, 9.4413206174E-01],
	[3.31850E+04, 2.1323653606E+04, 5.0182102016E+03, 7.9397295828E+03, 2.6873095923E+03, 9.4415806551E-01],
	[3.31900E+04, 2.1329095929E+04, 5.0182064843E+03, 7.9436061813E+03, 2.6878389220E+03, 9.4418405564E-01],
	[3.31950E+04, 2.1334538821E+04, 5.0182027677E+03, 7.9474840867E+03, 2.6883681415E+03, 9.4421003214E-01],
	[3.32000E+04, 2.1339982283E+04, 5.0181990516E+03, 7.9513632993E+03, 2.6888972509E+03, 9.4423599502E-01],
	[3.32050E+04, 2.1345426313E+04, 5.0181953360E+03, 7.9552438192E+03, 2.6894262500E+03, 9.4426194428E-01],
	[3.32100E+04, 2.1350870912E+04, 5.0181916211E+03, 7.9591256467E+03, 2.6899551390E+03, 9.4428787994E-01],
	[3.32150E+04, 2.1356316080E+04, 5.0181879066E+03, 7.9630087821E+03, 2.6904839177E+03, 9.4431380199E-01],
	[3.32200E+04, 2.1361761816E+04, 5.0181841928E+03, 7.9668932256E+03, 2.6910125861E+03, 9.4433971046E-01],
	[3.32250E+04, 2.1367208121E+04, 5.0181804795E+03, 7.9707789774E+03, 2.6915411444E+03, 9.4436560534E-01],
	[3.32300E+04, 2.1372654995E+04, 5.0181767668E+03, 7.9746660378E+03, 2.6920695923E+03, 9.4439148665E-01],
	[3.32350E+04, 2.1378102438E+04, 5.0181730546E+03, 7.9785544070E+03, 2.6925979300E+03, 9.4441735438E-01],
	[3.32400E+04, 2.1383550449E+04, 5.0181693430E+03, 7.9824440854E+03, 2.6931261574E+03, 9.4444320856E-01],
	[3.32450E+04, 2.1388999029E+04, 5.0181656320E+03, 7.9863350730E+03, 2.6936542746E+03, 9.4446904918E-01],
	[3.32500E+04, 2.1394448177E+04, 5.0181619215E+03, 7.9902273702E+03, 2.6941822814E+03, 9.4449487625E-01],
	[3.32550E+04, 2.1399897894E+04, 5.0181582116E+03, 7.9941209772E+03, 2.6947101780E+03, 9.4452068979E-01],
	[3.32600E+04, 2.1405348180E+04, 5.0181545022E+03, 7.9980158942E+03, 2.6952379642E+03, 9.4454648979E-01],
	[3.32650E+04, 2.1410799034E+04, 5.0181507934E+03, 8.0019121216E+03, 2.6957656402E+03, 9.4457227627E-01],
	[3.32700E+04, 2.1416250457E+04, 5.0181470851E+03, 8.0058096594E+03, 2.6962932057E+03, 9.4459804924E-01],
	[3.32750E+04, 2.1421702448E+04, 5.0181433775E+03, 8.0097085081E+03, 2.6968206610E+03, 9.4462380869E-01],
	[3.32800E+04, 2.1427155007E+04, 5.0181396703E+03, 8.0136086677E+03, 2.6973480059E+03, 9.4464955465E-01],
	[3.32850E+04, 2.1432608135E+04, 5.0181359638E+03, 8.0175101386E+03, 2.6978752405E+03, 9.4467528711E-01],
	[3.32900E+04, 2.1438061832E+04, 5.0181322578E+03, 8.0214129210E+03, 2.6984023646E+03, 9.4470100608E-01],
	[3.32950E+04, 2.1443516096E+04, 5.0181285523E+03, 8.0253170152E+03, 2.6989293785E+03, 9.4472671158E-01],
	[3.33000E+04, 2.1448970929E+04, 5.0181248475E+03, 8.0292224213E+03, 2.6994562819E+03, 9.4475240361E-01],
	[3.33050E+04, 2.1454426331E+04, 5.0181211431E+03, 8.0331291397E+03, 2.6999830749E+03, 9.4477808217E-01],
	[3.33100E+04, 2.1459882300E+04, 5.0181174394E+03, 8.0370371706E+03, 2.7005097576E+03, 9.4480374727E-01],
	[3.33150E+04, 2.1465338838E+04, 5.0181137362E+03, 8.0409465142E+03, 2.7010363298E+03, 9.4482939893E-01],
	[3.33200E+04, 2.1470795944E+04, 5.0181100335E+03, 8.0448571707E+03, 2.7015627916E+03, 9.4485503715E-01],
	[3.33250E+04, 2.1476253619E+04, 5.0181063314E+03, 8.0487691405E+03, 2.7020891430E+03, 9.4488066193E-01],
	[3.33300E+04, 2.1481711861E+04, 5.0181026299E+03, 8.0526824236E+03, 2.7026153839E+03, 9.4490627329E-01],
	[3.33350E+04, 2.1487170672E+04, 5.0180989289E+03, 8.0565970205E+03, 2.7031415144E+03, 9.4493187123E-01],
	[3.33400E+04, 2.1492630051E+04, 5.0180952285E+03, 8.0605129313E+03, 2.7036675345E+03, 9.4495745576E-01],
	[3.33450E+04, 2.1498089998E+04, 5.0180915286E+03, 8.0644301563E+03, 2.7041934440E+03, 9.4498302689E-01],
	[3.33500E+04, 2.1503550513E+04, 5.0180878293E+03, 8.0683486958E+03, 2.7047192432E+03, 9.4500858462E-01],
	[3.33550E+04, 2.1509011596E+04, 5.0180841306E+03, 8.0722685498E+03, 2.7052449318E+03, 9.4503412896E-01],
	[3.33600E+04, 2.1514473247E+04, 5.0180804324E+03, 8.0761897188E+03, 2.7057705099E+03, 9.4505965992E-01],
	[3.33650E+04, 2.1519935466E+04, 5.0180767348E+03, 8.0801122030E+03, 2.7062959776E+03, 9.4508517751E-01],
	[3.33700E+04, 2.1525398253E+04, 5.0180730377E+03, 8.0840360025E+03, 2.7068213348E+03, 9.4511068173E-01],
	[3.33750E+04, 2.1530861608E+04, 5.0180693412E+03, 8.0879611176E+03, 2.7073465814E+03, 9.4513617260E-01],
	[3.33800E+04, 2.1536325531E+04, 5.0180656452E+03, 8.0918875487E+03, 2.7078717175E+03, 9.4516165011E-01],
	[3.33850E+04, 2.1541790022E+04, 5.0180619498E+03, 8.0958152959E+03, 2.7083967431E+03, 9.4518711428E-01],
	[3.33900E+04, 2.1547255080E+04, 5.0180582550E+03, 8.0997443594E+03, 2.7089216581E+03, 9.4521256511E-01],
	[3.33950E+04, 2.1552720707E+04, 5.0180545607E+03, 8.1036747395E+03, 2.7094464626E+03, 9.4523800262E-01],
	[3.34000E+04, 2.1558186901E+04, 5.0180508669E+03, 8.1076064365E+03, 2.7099711566E+03, 9.4526342681E-01],
	[3.34050E+04, 2.1563653663E+04, 5.0180471737E+03, 8.1115394506E+03, 2.7104957400E+03, 9.4528883768E-01],
	[3.34100E+04, 2.1569120993E+04, 5.0180434811E+03, 8.1154737820E+03, 2.7110202128E+03, 9.4531423525E-01],
	[3.34150E+04, 2.1574588891E+04, 5.0180397891E+03, 8.1194094310E+03, 2.7115445750E+03, 9.4533961951E-01],
	[3.34200E+04, 2.1580057356E+04, 5.0180360975E+03, 8.1233463979E+03, 2.7120688267E+03, 9.4536499049E-01],
	[3.34250E+04, 2.1585526389E+04, 5.0180324066E+03, 8.1272846828E+03, 2.7125929678E+03, 9.4539034819E-01],
	[3.34300E+04, 2.1590995990E+04, 5.0180287162E+03, 8.1312242860E+03, 2.7131169982E+03, 9.4541569261E-01],
	[3.34350E+04, 2.1596466159E+04, 5.0180250263E+03, 8.1351652077E+03, 2.7136409181E+03, 9.4544102376E-01],
	[3.34400E+04, 2.1601936895E+04, 5.0180213370E+03, 8.1391074483E+03, 2.7141647273E+03, 9.4546634165E-01],
	[3.34450E+04, 2.1607408198E+04, 5.0180176483E+03, 8.1430510079E+03, 2.7146884259E+03, 9.4549164628E-01],
	[3.34500E+04, 2.1612880069E+04, 5.0180139601E+03, 8.1469958868E+03, 2.7152120139E+03, 9.4551693767E-01],
	[3.34550E+04, 2.1618352508E+04, 5.0180102725E+03, 8.1509420852E+03, 2.7157354912E+03, 9.4554221582E-01],
	[3.34600E+04, 2.1623825514E+04, 5.0180065854E+03, 8.1548896034E+03, 2.7162588579E+03, 9.4556748073E-01],
	[3.34650E+04, 2.1629299088E+04, 5.0180028989E+03, 8.1588384416E+03, 2.7167821139E+03, 9.4559273241E-01],
	[3.34700E+04, 2.1634773229E+04, 5.0179992129E+03, 8.1627886001E+03, 2.7173052592E+03, 9.4561797088E-01],
	[3.34750E+04, 2.1640247937E+04, 5.0179955275E+03, 8.1667400790E+03, 2.7178282939E+03, 9.4564319613E-01],
	[3.34800E+04, 2.1645723213E+04, 5.0179918426E+03, 8.1706928787E+03, 2.7183512179E+03, 9.4566840817E-01],
	[3.34850E+04, 2.1651199056E+04, 5.0179881583E+03, 8.1746469994E+03, 2.7188740313E+03, 9.4569360702E-01],
	[3.34900E+04, 2.1656675467E+04, 5.0179844745E+03, 8.1786024414E+03, 2.7193967339E+03, 9.4571879267E-01],
	[3.34950E+04, 2.1662152445E+04, 5.0179807913E+03, 8.1825592048E+03, 2.7199193258E+03, 9.4574396513E-01],
	[3.35000E+04, 2.1667629990E+04, 5.0179771087E+03, 8.1865172899E+03, 2.7204418070E+03, 9.4576912442E-01],
	[3.35050E+04, 2.1673108103E+04, 5.0179734266E+03, 8.1904766969E+03, 2.7209641775E+03, 9.4579427053E-01],
	[3.35100E+04, 2.1678586782E+04, 5.0179697450E+03, 8.1944374262E+03, 2.7214864373E+03, 9.4581940347E-01],
	[3.35150E+04, 2.1684066029E+04, 5.0179660640E+03, 8.1983994780E+03, 2.7220085863E+03, 9.4584452326E-01],
	[3.35200E+04, 2.1689545844E+04, 5.0179623836E+03, 8.2023628524E+03, 2.7225306246E+03, 9.4586962989E-01],
	[3.35250E+04, 2.1695026225E+04, 5.0179587037E+03, 8.2063275497E+03, 2.7230525521E+03, 9.4589472338E-01],
	[3.35300E+04, 2.1700507174E+04, 5.0179550243E+03, 8.2102935703E+03, 2.7235743689E+03, 9.4591980373E-01],
	[3.35350E+04, 2.1705988689E+04, 5.0179513455E+03, 8.2142609142E+03, 2.7240960750E+03, 9.4594487095E-01],
	[3.35400E+04, 2.1711470772E+04, 5.0179476673E+03, 8.2182295819E+03, 2.7246176702E+03, 9.4596992504E-01],
	[3.35450E+04, 2.1716953422E+04, 5.0179439896E+03, 8.2221995734E+03, 2.7251391547E+03, 9.4599496601E-01],
	[3.35500E+04, 2.1722436638E+04, 5.0179403125E+03, 8.2261708891E+03, 2.7256605284E+03, 9.4601999387E-01],
	[3.35550E+04, 2.1727920422E+04, 5.0179366359E+03, 8.2301435291E+03, 2.7261817914E+03, 9.4604500863E-01],
	[3.35600E+04, 2.1733404773E+04, 5.0179329598E+03, 8.2341174939E+03, 2.7267029435E+03, 9.4607001029E-01],
	[3.35650E+04, 2.1738889691E+04, 5.0179292843E+03, 8.2380927835E+03, 2.7272239848E+03, 9.4609499886E-01],
	[3.35700E+04, 2.1744375176E+04, 5.0179256094E+03, 8.2420693982E+03, 2.7277449153E+03, 9.4611997434E-01],
	[3.35750E+04, 2.1749861227E+04, 5.0179219350E+03, 8.2460473383E+03, 2.7282657350E+03, 9.4614493675E-01],
	[3.35800E+04, 2.1755347846E+04, 5.0179182612E+03, 8.2500266040E+03, 2.7287864439E+03, 9.4616988608E-01],
	[3.35850E+04, 2.1760835031E+04, 5.0179145879E+03, 8.2540071955E+03, 2.7293070419E+03, 9.4619482235E-01],
	[3.35900E+04, 2.1766322783E+04, 5.0179109151E+03, 8.2579891132E+03, 2.7298275291E+03, 9.4621974557E-01],
	[3.35950E+04, 2.1771811102E+04, 5.0179072430E+03, 8.2619723572E+03, 2.7303479055E+03, 9.4624465573E-01],
	[3.36000E+04, 2.1777299988E+04, 5.0179035713E+03, 8.2659569278E+03, 2.7308681710E+03, 9.4626955285E-01],
	[3.36050E+04, 2.1782789441E+04, 5.0178999002E+03, 8.2699428252E+03, 2.7313883256E+03, 9.4629443694E-01],
	[3.36100E+04, 2.1788279460E+04, 5.0178962297E+03, 8.2739300497E+03, 2.7319083694E+03, 9.4631930799E-01],
	[3.36150E+04, 2.1793770046E+04, 5.0178925597E+03, 8.2779186015E+03, 2.7324283023E+03, 9.4634416602E-01],
	[3.36200E+04, 2.1799261198E+04, 5.0178888902E+03, 8.2819084809E+03, 2.7329481243E+03, 9.4636901103E-01],
	[3.36250E+04, 2.1804752918E+04, 5.0178852213E+03, 8.2858996881E+03, 2.7334678355E+03, 9.4639384304E-01],
	[3.36300E+04, 2.1810245204E+04, 5.0178815530E+03, 8.2898922233E+03, 2.7339874357E+03, 9.4641866204E-01],
	[3.36350E+04, 2.1815738056E+04, 5.0178778852E+03, 8.2938860869E+03, 2.7345069251E+03, 9.4644346805E-01],
	[3.36400E+04, 2.1821231475E+04, 5.0178742179E+03, 8.2978812789E+03, 2.7350263035E+03, 9.4646826107E-01],
	[3.36450E+04, 2.1826725461E+04, 5.0178705512E+03, 8.3018777998E+03, 2.7355455711E+03, 9.4649304110E-01],
	[3.36500E+04, 2.1832220013E+04, 5.0178668851E+03, 8.3058756496E+03, 2.7360647277E+03, 9.4651780816E-01],
	[3.36550E+04, 2.1837715132E+04, 5.0178632195E+03, 8.3098748287E+03, 2.7365837734E+03, 9.4654256225E-01],
	[3.36600E+04, 2.1843210817E+04, 5.0178595544E+03, 8.3138753374E+03, 2.7371027082E+03, 9.4656730338E-01],
	[3.36650E+04, 2.1848707069E+04, 5.0178558899E+03, 8.3178771758E+03, 2.7376215320E+03, 9.4659203155E-01],
	[3.36700E+04, 2.1854203887E+04, 5.0178522259E+03, 8.3218803442E+03, 2.7381402449E+03, 9.4661674678E-01],
	[3.36750E+04, 2.1859701271E+04, 5.0178485625E+03, 8.3258848428E+03, 2.7386588468E+03, 9.4664144906E-01],
	[3.36800E+04, 2.1865199222E+04, 5.0178448996E+03, 8.3298906719E+03, 2.7391773378E+03, 9.4666613841E-01],
	[3.36850E+04, 2.1870697739E+04, 5.0178412373E+03, 8.3338978317E+03, 2.7396957178E+03, 9.4669081483E-01],
	[3.36900E+04, 2.1876196822E+04, 5.0178375755E+03, 8.3379063225E+03, 2.7402139869E+03, 9.4671547833E-01],
	[3.36950E+04, 2.1881696472E+04, 5.0178339143E+03, 8.3419161446E+03, 2.7407321450E+03, 9.4674012892E-01],
	[3.37000E+04, 2.1887196688E+04, 5.0178302536E+03, 8.3459272981E+03, 2.7412501921E+03, 9.4676476660E-01],
	[3.37050E+04, 2.1892697470E+04, 5.0178265934E+03, 8.3499397833E+03, 2.7417681282E+03, 9.4678939138E-01],
	[3.37100E+04, 2.1898198819E+04, 5.0178229338E+03, 8.3539536004E+03, 2.7422859533E+03, 9.4681400326E-01],
	[3.37150E+04, 2.1903700733E+04, 5.0178192748E+03, 8.3579687497E+03, 2.7428036675E+03, 9.4683860226E-01],
	[3.37200E+04, 2.1909203214E+04, 5.0178156163E+03, 8.3619852315E+03, 2.7433212706E+03, 9.4686318837E-01],
	[3.37250E+04, 2.1914706261E+04, 5.0178119583E+03, 8.3660030459E+03, 2.7438387627E+03, 9.4688776162E-01],
	[3.37300E+04, 2.1920209874E+04, 5.0178083009E+03, 8.3700221933E+03, 2.7443561438E+03, 9.4691232199E-01],
	[3.37350E+04, 2.1925714053E+04, 5.0178046440E+03, 8.3740426738E+03, 2.7448734139E+03, 9.4693686951E-01],
	[3.37400E+04, 2.1931218798E+04, 5.0178009877E+03, 8.3780644877E+03, 2.7453905730E+03, 9.4696140417E-01],
	[3.37450E+04, 2.1936724110E+04, 5.0177973319E+03, 8.3820876353E+03, 2.7459076210E+03, 9.4698592599E-01],
	[3.37500E+04, 2.1942229987E+04, 5.0177936767E+03, 8.3861121168E+03, 2.7464245580E+03, 9.4701043496E-01],
	[3.37550E+04, 2.1947736430E+04, 5.0177900220E+03, 8.3901379324E+03, 2.7469413840E+03, 9.4703493111E-01],
	[3.37600E+04, 2.1953243439E+04, 5.0177863678E+03, 8.3941650825E+03, 2.7474580989E+03, 9.4705941443E-01],
	[3.37650E+04, 2.1958751014E+04, 5.0177827142E+03, 8.3981935671E+03, 2.7479747027E+03, 9.4708388492E-01],
	[3.37700E+04, 2.1964259155E+04, 5.0177790611E+03, 8.4022233866E+03, 2.7484911955E+03, 9.4710834261E-01],
	[3.37750E+04, 2.1969767862E+04, 5.0177754086E+03, 8.4062545412E+03, 2.7490075772E+03, 9.4713278749E-01],
	[3.37800E+04, 2.1975277135E+04, 5.0177717566E+03, 8.4102870312E+03, 2.7495238479E+03, 9.4715721957E-01],
	[3.37850E+04, 2.1980786973E+04, 5.0177681052E+03, 8.4143208568E+03, 2.7500400075E+03, 9.4718163886E-01],
	[3.37900E+04, 2.1986297378E+04, 5.0177644543E+03, 8.4183560183E+03, 2.7505560560E+03, 9.4720604537E-01],
	[3.37950E+04, 2.1991808348E+04, 5.0177608040E+03, 8.4223925158E+03, 2.7510719934E+03, 9.4723043909E-01],
	[3.38000E+04, 2.1997319884E+04, 5.0177571542E+03, 8.4264303496E+03, 2.7515878197E+03, 9.4725482004E-01],
	[3.38050E+04, 2.2002831985E+04, 5.0177535049E+03, 8.4304695201E+03, 2.7521035349E+03, 9.4727918823E-01],
	[3.38100E+04, 2.2008344653E+04, 5.0177498562E+03, 8.4345100274E+03, 2.7526191390E+03, 9.4730354366E-01],
	[3.38150E+04, 2.2013857886E+04, 5.0177462080E+03, 8.4385518717E+03, 2.7531346320E+03, 9.4732788634E-01],
	[3.38200E+04, 2.2019371684E+04, 5.0177425604E+03, 8.4425950533E+03, 2.7536500139E+03, 9.4735221627E-01],
	[3.38250E+04, 2.2024886049E+04, 5.0177389133E+03, 8.4466395725E+03, 2.7541652847E+03, 9.4737653347E-01],
	[3.38300E+04, 2.2030400979E+04, 5.0177352667E+03, 8.4506854295E+03, 2.7546804443E+03, 9.4740083794E-01],
	[3.38350E+04, 2.2035916474E+04, 5.0177316207E+03, 8.4547326246E+03, 2.7551954928E+03, 9.4742512968E-01],
	[3.38400E+04, 2.2041432535E+04, 5.0177279752E+03, 8.4587811579E+03, 2.7557104302E+03, 9.4744940870E-01],
	[3.38450E+04, 2.2046949162E+04, 5.0177243303E+03, 8.4628310297E+03, 2.7562252565E+03, 9.4747367501E-01],
	[3.38500E+04, 2.2052466354E+04, 5.0177206859E+03, 8.4668822404E+03, 2.7567399716E+03, 9.4749792862E-01],
	[3.38550E+04, 2.2057984111E+04, 5.0177170421E+03, 8.4709347900E+03, 2.7572545755E+03, 9.4752216953E-01],
	[3.38600E+04, 2.2063502434E+04, 5.0177133987E+03, 8.4749886789E+03, 2.7577690683E+03, 9.4754639775E-01],
	[3.38650E+04, 2.2069021322E+04, 5.0177097560E+03, 8.4790439073E+03, 2.7582834500E+03, 9.4757061328E-01],
	[3.38700E+04, 2.2074540776E+04, 5.0177061138E+03, 8.4831004755E+03, 2.7587977204E+03, 9.4759481614E-01],
	[3.38750E+04, 2.2080060795E+04, 5.0177024721E+03, 8.4871583837E+03, 2.7593118798E+03, 9.4761900633E-01],
	[3.38800E+04, 2.2085581380E+04, 5.0176988309E+03, 8.4912176321E+03, 2.7598259279E+03, 9.4764318386E-01],
	[3.38850E+04, 2.2091102529E+04, 5.0176951903E+03, 8.4952782210E+03, 2.7603398648E+03, 9.4766734873E-01],
	[3.38900E+04, 2.2096624244E+04, 5.0176915502E+03, 8.4993401506E+03, 2.7608536906E+03, 9.4769150094E-01],
	[3.38950E+04, 2.2102146525E+04, 5.0176879107E+03, 8.5034034211E+03, 2.7613674052E+03, 9.4771564052E-01],
	[3.39000E+04, 2.2107669370E+04, 5.0176842717E+03, 8.5074680329E+03, 2.7618810086E+03, 9.4773976746E-01],
	[3.39050E+04, 2.2113192781E+04, 5.0176806333E+03, 8.5115339862E+03, 2.7623945008E+03, 9.4776388177E-01],
	[3.39100E+04, 2.2118716757E+04, 5.0176769954E+03, 8.5156012811E+03, 2.7629078818E+03, 9.4778798345E-01],
	[3.39150E+04, 2.2124241298E+04, 5.0176733580E+03, 8.5196699180E+03, 2.7634211516E+03, 9.4781207252E-01],
	[3.39200E+04, 2.2129766404E+04, 5.0176697212E+03, 8.5237398971E+03, 2.7639343102E+03, 9.4783614898E-01],
	[3.39250E+04, 2.2135292076E+04, 5.0176660849E+03, 8.5278112186E+03, 2.7644473575E+03, 9.4786021284E-01],
	[3.39300E+04, 2.2140818312E+04, 5.0176624491E+03, 8.5318838828E+03, 2.7649602937E+03, 9.4788426410E-01],
	[3.39350E+04, 2.2146345114E+04, 5.0176588139E+03, 8.5359578899E+03, 2.7654731186E+03, 9.4790830278E-01],
	[3.39400E+04, 2.2151872480E+04, 5.0176551792E+03, 8.5400332402E+03, 2.7659858323E+03, 9.4793232887E-01],
	[3.39450E+04, 2.2157400412E+04, 5.0176515451E+03, 8.5441099339E+03, 2.7664984348E+03, 9.4795634238E-01],
	[3.39500E+04, 2.2162928908E+04, 5.0176479115E+03, 8.5481879713E+03, 2.7670109260E+03, 9.4798034333E-01],
	[3.39550E+04, 2.2168457970E+04, 5.0176442784E+03, 8.5522673525E+03, 2.7675233060E+03, 9.4800433171E-01],
	[3.39600E+04, 2.2173987596E+04, 5.0176406459E+03, 8.5563480779E+03, 2.7680355747E+03, 9.4802830754E-01],
	[3.39650E+04, 2.2179517788E+04, 5.0176370139E+03, 8.5604301477E+03, 2.7685477322E+03, 9.4805227082E-01],
	[3.39700E+04, 2.2185048544E+04, 5.0176333825E+03, 8.5645135621E+03, 2.7690597784E+03, 9.4807622156E-01],
	[3.39750E+04, 2.2190579865E+04, 5.0176297516E+03, 8.5685983214E+03, 2.7695717134E+03, 9.4810015976E-01],
	[3.39800E+04, 2.2196111751E+04, 5.0176261212E+03, 8.5726844258E+03, 2.7700835371E+03, 9.4812408543E-01],
	[3.39850E+04, 2.2201644202E+04, 5.0176224913E+03, 8.5767718756E+03, 2.7705952495E+03, 9.4814799858E-01],
	[3.39900E+04, 2.2207177217E+04, 5.0176188620E+03, 8.5808606710E+03, 2.7711068507E+03, 9.4817189922E-01],
	[3.39950E+04, 2.2212710798E+04, 5.0176152333E+03, 8.5849508122E+03, 2.7716183406E+03, 9.4819578735E-01],
	[3.40000E+04, 2.2218244943E+04, 5.0176116050E+03, 8.5890422995E+03, 2.7721297192E+03, 9.4821966298E-01],
	[3.40050E+04, 2.2223779652E+04, 5.0176079774E+03, 8.5931351332E+03, 2.7726409866E+03, 9.4824352611E-01],
	[3.40100E+04, 2.2229314927E+04, 5.0176043502E+03, 8.5972293134E+03, 2.7731521426E+03, 9.4826737675E-01],
	[3.40150E+04, 2.2234850766E+04, 5.0176007236E+03, 8.6013248405E+03, 2.7736631874E+03, 9.4829121492E-01],
	[3.40200E+04, 2.2240387169E+04, 5.0175970975E+03, 8.6054217147E+03, 2.7741741209E+03, 9.4831504060E-01],
	[3.40250E+04, 2.2245924138E+04, 5.0175934719E+03, 8.6095199361E+03, 2.7746849430E+03, 9.4833885382E-01],
	[3.40300E+04, 2.2251461671E+04, 5.0175898469E+03, 8.6136195052E+03, 2.7751956539E+03, 9.4836265458E-01],
	[3.40350E+04, 2.2256999768E+04, 5.0175862224E+03, 8.6177204220E+03, 2.7757062535E+03, 9.4838644289E-01],
	[3.40400E+04, 2.2262538430E+04, 5.0175825985E+03, 8.6218226869E+03, 2.7762167417E+03, 9.4841021875E-01],
	[3.40450E+04, 2.2268077656E+04, 5.0175789751E+03, 8.6259263001E+03, 2.7767271187E+03, 9.4843398216E-01],
	[3.40500E+04, 2.2273617447E+04, 5.0175753522E+03, 8.6300312618E+03, 2.7772373843E+03, 9.4845773314E-01],
	[3.40550E+04, 2.2279157803E+04, 5.0175717299E+03, 8.6341375723E+03, 2.7777475386E+03, 9.4848147170E-01],
	[3.40600E+04, 2.2284698722E+04, 5.0175681081E+03, 8.6382452318E+03, 2.7782575816E+03, 9.4850519783E-01],
	[3.40650E+04, 2.2290240207E+04, 5.0175644868E+03, 8.6423542406E+03, 2.7787675132E+03, 9.4852891155E-01],
	[3.40700E+04, 2.2295782255E+04, 5.0175608660E+03, 8.6464645990E+03, 2.7792773335E+03, 9.4855261287E-01],
	[3.40750E+04, 2.2301324868E+04, 5.0175572458E+03, 8.6505763070E+03, 2.7797870425E+03, 9.4857630178E-01],
	[3.40800E+04, 2.2306868045E+04, 5.0175536262E+03, 8.6546893651E+03, 2.7802966402E+03, 9.4859997830E-01],
	[3.40850E+04, 2.2312411787E+04, 5.0175500070E+03, 8.6588037735E+03, 2.7808061265E+03, 9.4862364243E-01],
	[3.40900E+04, 2.2317956093E+04, 5.0175463884E+03, 8.6629195323E+03, 2.7813155015E+03, 9.4864729418E-01],
	[3.40950E+04, 2.2323500963E+04, 5.0175427704E+03, 8.6670366418E+03, 2.7818247651E+03, 9.4867093355E-01],
	[3.41000E+04, 2.2329046397E+04, 5.0175391528E+03, 8.6711551024E+03, 2.7823339173E+03, 9.4869456056E-01],
	[3.41050E+04, 2.2334592396E+04, 5.0175355358E+03, 8.6752749142E+03, 2.7828429582E+03, 9.4871817521E-01],
	[3.41100E+04, 2.2340138958E+04, 5.0175319193E+03, 8.6793960774E+03, 2.7833518878E+03, 9.4874177751E-01],
	[3.41150E+04, 2.2345686085E+04, 5.0175283034E+03, 8.6835185923E+03, 2.7838607060E+03, 9.4876536746E-01],
	[3.41200E+04, 2.2351233776E+04, 5.0175246880E+03, 8.6876424593E+03, 2.7843694128E+03, 9.4878894506E-01],
	[3.41250E+04, 2.2356782031E+04, 5.0175210731E+03, 8.6917676784E+03, 2.7848780083E+03, 9.4881251034E-01],
	[3.41300E+04, 2.2362330850E+04, 5.0175174588E+03, 8.6958942499E+03, 2.7853864924E+03, 9.4883606329E-01],
	[3.41350E+04, 2.2367880233E+04, 5.0175138450E+03, 8.7000221742E+03, 2.7858948651E+03, 9.4885960392E-01],
	[3.41400E+04, 2.2373430180E+04, 5.0175102317E+03, 8.7041514514E+03, 2.7864031264E+03, 9.4888313223E-01],
	[3.41450E+04, 2.2378980692E+04, 5.0175066189E+03, 8.7082820818E+03, 2.7869112764E+03, 9.4890664824E-01],
	[3.41500E+04, 2.2384531767E+04, 5.0175030067E+03, 8.7124140656E+03, 2.7874193149E+03, 9.4893015195E-01],
	[3.41550E+04, 2.2390083406E+04, 5.0174993951E+03, 8.7165474030E+03, 2.7879272421E+03, 9.4895364336E-01],
	[3.41600E+04, 2.2395635609E+04, 5.0174957839E+03, 8.7206820944E+03, 2.7884350579E+03, 9.4897712249E-01],
	[3.41650E+04, 2.2401188376E+04, 5.0174921733E+03, 8.7248181400E+03, 2.7889427623E+03, 9.4900058934E-01],
	[3.41700E+04, 2.2406741706E+04, 5.0174885632E+03, 8.7289555399E+03, 2.7894503553E+03, 9.4902404391E-01],
	[3.41750E+04, 2.2412295601E+04, 5.0174849536E+03, 8.7330942945E+03, 2.7899578370E+03, 9.4904748622E-01],
	[3.41800E+04, 2.2417850059E+04, 5.0174813446E+03, 8.7372344040E+03, 2.7904652072E+03, 9.4907091627E-01],
	[3.41850E+04, 2.2423405082E+04, 5.0174777361E+03, 8.7413758686E+03, 2.7909724660E+03, 9.4909433407E-01],
	[3.41900E+04, 2.2428960668E+04, 5.0174741281E+03, 8.7455186886E+03, 2.7914796134E+03, 9.4911773961E-01],
	[3.41950E+04, 2.2434516817E+04, 5.0174705207E+03, 8.7496628643E+03, 2.7919866494E+03, 9.4914113292E-01],
	[3.42000E+04, 2.2440073531E+04, 5.0174669138E+03, 8.7538083958E+03, 2.7924935740E+03, 9.4916451400E-01],
	[3.42050E+04, 2.2445630808E+04, 5.0174633074E+03, 8.7579552834E+03, 2.7930003871E+03, 9.4918788285E-01],
	[3.42100E+04, 2.2451188649E+04, 5.0174597016E+03, 8.7621035274E+03, 2.7935070889E+03, 9.4921123948E-01],
	[3.42150E+04, 2.2456747053E+04, 5.0174560963E+03, 8.7662531279E+03, 2.7940136792E+03, 9.4923458390E-01],
	[3.42200E+04, 2.2462306021E+04, 5.0174524915E+03, 8.7704040854E+03, 2.7945201581E+03, 9.4925791611E-01],
	[3.42250E+04, 2.2467865553E+04, 5.0174488872E+03, 8.7745563999E+03, 2.7950265256E+03, 9.4928123612E-01],
	[3.42300E+04, 2.2473425648E+04, 5.0174452835E+03, 8.7787100718E+03, 2.7955327817E+03, 9.4930454394E-01],
	[3.42350E+04, 2.2478986307E+04, 5.0174416803E+03, 8.7828651012E+03, 2.7960389263E+03, 9.4932783957E-01],
	[3.42400E+04, 2.2484547529E+04, 5.0174380776E+03, 8.7870214885E+03, 2.7965449595E+03, 9.4935112302E-01],
	[3.42450E+04, 2.2490109315E+04, 5.0174344755E+03, 8.7911792338E+03, 2.7970508813E+03, 9.4937439430E-01],
	[3.42500E+04, 2.2495671664E+04, 5.0174308738E+03, 8.7953383375E+03, 2.7975566916E+03, 9.4939765341E-01],
	[3.42550E+04, 2.2501234577E+04, 5.0174272728E+03, 8.7994987997E+03, 2.7980623905E+03, 9.4942090036E-01],
	[3.42600E+04, 2.2506798053E+04, 5.0174236722E+03, 8.8036606207E+03, 2.7985679780E+03, 9.4944413516E-01],
	[3.42650E+04, 2.2512362092E+04, 5.0174200722E+03, 8.8078238008E+03, 2.7990734540E+03, 9.4946735782E-01],
	[3.42700E+04, 2.2517926695E+04, 5.0174164727E+03, 8.8119883401E+03, 2.7995788185E+03, 9.4949056833E-01],
	[3.42750E+04, 2.2523491861E+04, 5.0174128737E+03, 8.8161542390E+03, 2.8000840716E+03, 9.4951376671E-01],
	[3.42800E+04, 2.2529057591E+04, 5.0174092752E+03, 8.8203214977E+03, 2.8005892133E+03, 9.4953695297E-01],
	[3.42850E+04, 2.2534623884E+04, 5.0174056773E+03, 8.8244901164E+03, 2.8010942435E+03, 9.4956012710E-01],
	[3.42900E+04, 2.2540190740E+04, 5.0174020799E+03, 8.8286600954E+03, 2.8015991623E+03, 9.4958328913E-01],
	[3.42950E+04, 2.2545758159E+04, 5.0173984831E+03, 8.8328314349E+03, 2.8021039696E+03, 9.4960643904E-01],
	[3.43000E+04, 2.2551326141E+04, 5.0173948867E+03, 8.8370041352E+03, 2.8026086654E+03, 9.4962957686E-01],
	[3.43050E+04, 2.2556894687E+04, 5.0173912909E+03, 8.8411781965E+03, 2.8031132498E+03, 9.4965270258E-01],
	[3.43100E+04, 2.2562463796E+04, 5.0173876956E+03, 8.8453536190E+03, 2.8036177227E+03, 9.4967581622E-01],
	[3.43150E+04, 2.2568033468E+04, 5.0173841009E+03, 8.8495304030E+03, 2.8041220841E+03, 9.4969891777E-01],
	[3.43200E+04, 2.2573603703E+04, 5.0173805066E+03, 8.8537085488E+03, 2.8046263341E+03, 9.4972200726E-01],
	[3.43250E+04, 2.2579174501E+04, 5.0173769129E+03, 8.8578880566E+03, 2.8051304726E+03, 9.4974508467E-01],
	[3.43300E+04, 2.2584752544E+04, 5.0173745669E+03, 8.8620689265E+03, 2.8056349928E+03, 9.4976815003E-01],
	[3.43350E+04, 2.2590363619E+04, 5.0173782795E+03, 8.8662511590E+03, 2.8061417977E+03, 9.4979120334E-01],
	[3.43400E+04, 2.2595975270E+04, 5.0173819916E+03, 8.8704347542E+03, 2.8066484924E+03, 9.4981424459E-01],
	[3.43450E+04, 2.2601587498E+04, 5.0173857031E+03, 8.8746197123E+03, 2.8071550771E+03, 9.4983727381E-01],
	[3.43500E+04, 2.2607200302E+04, 5.0173894141E+03, 8.8788060337E+03, 2.8076615516E+03, 9.4986029100E-01],
	[3.43550E+04, 2.2612813684E+04, 5.0173931246E+03, 8.8829937185E+03, 2.8081679160E+03, 9.4988329615E-01],
	[3.43600E+04, 2.2618427641E+04, 5.0173968345E+03, 8.8871827670E+03, 2.8086741703E+03, 9.4990628929E-01],
	[3.43650E+04, 2.2624042176E+04, 5.0174005439E+03, 8.8913731794E+03, 2.8091803145E+03, 9.4992927042E-01],
	[3.43700E+04, 2.2629657287E+04, 5.0174042528E+03, 8.8955649561E+03, 2.8096863486E+03, 9.4995223954E-01],
	[3.43750E+04, 2.2635272974E+04, 5.0174079611E+03, 8.8997580971E+03, 2.8101922725E+03, 9.4997519665E-01],
	[3.43800E+04, 2.2640889238E+04, 5.0174116689E+03, 8.9039526029E+03, 2.8106980863E+03, 9.4999814178E-01],
	[3.43850E+04, 2.2646506078E+04, 5.0174153762E+03, 8.9081484735E+03, 2.8112037899E+03, 9.5002107492E-01],
	[3.43900E+04, 2.2652123495E+04, 5.0174190829E+03, 8.9123457094E+03, 2.8117093835E+03, 9.5004399607E-01],
	[3.43950E+04, 2.2657741489E+04, 5.0174227891E+03, 8.9165443106E+03, 2.8122148669E+03, 9.5006690526E-01],
	[3.44000E+04, 2.2663360058E+04, 5.0174264947E+03, 8.9207442775E+03, 2.8127202401E+03, 9.5008980247E-01],
	[3.44050E+04, 2.2668979204E+04, 5.0174301998E+03, 8.9249456104E+03, 2.8132255032E+03, 9.5011268773E-01],
	[3.44100E+04, 2.2674598927E+04, 5.0174339044E+03, 8.9291483093E+03, 2.8137306562E+03, 9.5013556103E-01],
	[3.44150E+04, 2.2680219225E+04, 5.0174376084E+03, 8.9333523747E+03, 2.8142356990E+03, 9.5015842239E-01],
	[3.44200E+04, 2.2685840100E+04, 5.0174413119E+03, 8.9375578067E+03, 2.8147406317E+03, 9.5018127180E-01],
	[3.44250E+04, 2.2691461552E+04, 5.0174450149E+03, 8.9417646055E+03, 2.8152454542E+03, 9.5020410929E-01],
	[3.44300E+04, 2.2697083579E+04, 5.0174487173E+03, 8.9459727715E+03, 2.8157501666E+03, 9.5022693484E-01],
	[3.44350E+04, 2.2702706183E+04, 5.0174524192E+03, 8.9501823049E+03, 2.8162547688E+03, 9.5024974847E-01],
	[3.44400E+04, 2.2708329363E+04, 5.0174561206E+03, 8.9543932059E+03, 2.8167592609E+03, 9.5027255019E-01],
	[3.44450E+04, 2.2713953119E+04, 5.0174598214E+03, 8.9586054747E+03, 2.8172636428E+03, 9.5029534001E-01],
	[3.44500E+04, 2.2719577451E+04, 5.0174635217E+03, 8.9628191117E+03, 2.8177679146E+03, 9.5031811792E-01],
	[3.44550E+04, 2.2725202360E+04, 5.0174672215E+03, 8.9670341170E+03, 2.8182720762E+03, 9.5034088393E-01],
	[3.44600E+04, 2.2730827844E+04, 5.0174709207E+03, 8.9712504909E+03, 2.8187761276E+03, 9.5036363806E-01],
	[3.44650E+04, 2.2736453905E+04, 5.0174746194E+03, 8.9754682336E+03, 2.8192800689E+03, 9.5038638031E-01],
	[3.44700E+04, 2.2742080541E+04, 5.0174783175E+03, 8.9796873454E+03, 2.8197839000E+03, 9.5040911069E-01],
	[3.44750E+04, 2.2747707754E+04, 5.0174820151E+03, 8.9839078266E+03, 2.8202876210E+03, 9.5043182919E-01],
	[3.44800E+04, 2.2753335543E+04, 5.0174857122E+03, 8.9881296773E+03, 2.8207912317E+03, 9.5045453584E-01],
	[3.44850E+04, 2.2758963907E+04, 5.0174894088E+03, 8.9923528979E+03, 2.8212947324E+03, 9.5047723063E-01],
	[3.44900E+04, 2.2764592848E+04, 5.0174931048E+03, 8.9965774885E+03, 2.8217981228E+03, 9.5049991357E-01],
	[3.44950E+04, 2.2770222364E+04, 5.0174968003E+03, 9.0008034494E+03, 2.8223014031E+03, 9.5052258467E-01],
	[3.45000E+04, 2.2775852457E+04, 5.0175004953E+03, 9.0050307809E+03, 2.8228045732E+03, 9.5054524394E-01],
	[3.45050E+04, 2.2781483125E+04, 5.0175041897E+03, 9.0092594832E+03, 2.8233076331E+03, 9.5056789137E-01],
	[3.45100E+04, 2.2787114369E+04, 5.0175078836E+03, 9.0134895565E+03, 2.8238105829E+03, 9.5059052699E-01],
	[3.45150E+04, 2.2792746189E+04, 5.0175115769E+03, 9.0177210011E+03, 2.8243134225E+03, 9.5061315079E-01],
	[3.45200E+04, 2.2798378585E+04, 5.0175152698E+03, 9.0219538173E+03, 2.8248161519E+03, 9.5063576278E-01],
	[3.45250E+04, 2.2804011557E+04, 5.0175189621E+03, 9.0261880052E+03, 2.8253187711E+03, 9.5065836297E-01],
	[3.45300E+04, 2.2809645104E+04, 5.0175226538E+03, 9.0304235652E+03, 2.8258212802E+03, 9.5068095137E-01],
	[3.45350E+04, 2.2815279227E+04, 5.0175263451E+03, 9.0346604974E+03, 2.8263236791E+03, 9.5070352798E-01],
	[3.45400E+04, 2.2820913926E+04, 5.0175300358E+03, 9.0388988022E+03, 2.8268259678E+03, 9.5072609280E-01],
	[3.45450E+04, 2.2826549200E+04, 5.0175337259E+03, 9.0431384797E+03, 2.8273281463E+03, 9.5074864585E-01],
	[3.45500E+04, 2.2832185050E+04, 5.0175374156E+03, 9.0473795302E+03, 2.8278302146E+03, 9.5077118713E-01],
	[3.45550E+04, 2.2837821476E+04, 5.0175411047E+03, 9.0516219540E+03, 2.8283321727E+03, 9.5079371664E-01],
	[3.45600E+04, 2.2843458477E+04, 5.0175447932E+03, 9.0558657513E+03, 2.8288340207E+03, 9.5081623441E-01],
	[3.45650E+04, 2.2849096054E+04, 5.0175484813E+03, 9.0601109223E+03, 2.8293357585E+03, 9.5083874042E-01],
	[3.45700E+04, 2.2854734207E+04, 5.0175521688E+03, 9.0643574673E+03, 2.8298373860E+03, 9.5086123469E-01],
	[3.45750E+04, 2.2860372935E+04, 5.0175558558E+03, 9.0686053865E+03, 2.8303389034E+03, 9.5088371722E-01],
	[3.45800E+04, 2.2866012239E+04, 5.0175595422E+03, 9.0728546802E+03, 2.8308403106E+03, 9.5090618802E-01],
	[3.45850E+04, 2.2871652118E+04, 5.0175632281E+03, 9.0771053486E+03, 2.8313416076E+03, 9.5092864710E-01],
	[3.45900E+04, 2.2877292572E+04, 5.0175669135E+03, 9.0813573920E+03, 2.8318427945E+03, 9.5095109446E-01],
	[3.45950E+04, 2.2882933602E+04, 5.0175705984E+03, 9.0856108106E+03, 2.8323438711E+03, 9.5097353012E-01],
	[3.46000E+04, 2.2888575207E+04, 5.0175742827E+03, 9.0898656047E+03, 2.8328448375E+03, 9.5099595407E-01],
	[3.46050E+04, 2.2894217388E+04, 5.0175779665E+03, 9.0941217744E+03, 2.8333456938E+03, 9.5101836632E-01],
	[3.46100E+04, 2.2899860144E+04, 5.0175816498E+03, 9.0983793202E+03, 2.8338464398E+03, 9.5104076688E-01],
	[3.46150E+04, 2.2905503476E+04, 5.0175853325E+03, 9.1026382421E+03, 2.8343470757E+03, 9.5106315576E-01],
	[3.46200E+04, 2.2911147382E+04, 5.0175890148E+03, 9.1068985404E+03, 2.8348476014E+03, 9.5108553296E-01],
	[3.46250E+04, 2.2916791865E+04, 5.0175926964E+03, 9.1111602154E+03, 2.8353480168E+03, 9.5110789849E-01],
	[3.46300E+04, 2.2922436922E+04, 5.0175963776E+03, 9.1154232674E+03, 2.8358483221E+03, 9.5113025235E-01],
	[3.46350E+04, 2.2928082554E+04, 5.0176000582E+03, 9.1196876965E+03, 2.8363485172E+03, 9.5115259456E-01],
	[3.46400E+04, 2.2933728762E+04, 5.0176037383E+03, 9.1239535031E+03, 2.8368486020E+03, 9.5117492512E-01],
	[3.46450E+04, 2.2939375545E+04, 5.0176074179E+03, 9.1282206873E+03, 2.8373485767E+03, 9.5119724403E-01],
	[3.46500E+04, 2.2945022903E+04, 5.0176110969E+03, 9.1324892494E+03, 2.8378484412E+03, 9.5121955131E-01],
	[3.46550E+04, 2.2950670837E+04, 5.0176147754E+03, 9.1367591897E+03, 2.8383481955E+03, 9.5124184695E-01],
	[3.46600E+04, 2.2956319345E+04, 5.0176184534E+03, 9.1410305083E+03, 2.8388478395E+03, 9.5126413097E-01],
	[3.46650E+04, 2.2961968429E+04, 5.0176221309E+03, 9.1453032057E+03, 2.8393473734E+03, 9.5128640337E-01],
	[3.46700E+04, 2.2967618087E+04, 5.0176258078E+03, 9.1495772819E+03, 2.8398467971E+03, 9.5130866415E-01],
	[3.46750E+04, 2.2973268321E+04, 5.0176294842E+03, 9.1538527372E+03, 2.8403461106E+03, 9.5133091334E-01],
	[3.46800E+04, 2.2978919129E+04, 5.0176331601E+03, 9.1581295719E+03, 2.8408453139E+03, 9.5135315092E-01],
	[3.46850E+04, 2.2984570513E+04, 5.0176368354E+03, 9.1624077863E+03, 2.8413444069E+03, 9.5137537691E-01],
	[3.46900E+04, 2.2990222472E+04, 5.0176405103E+03, 9.1666873805E+03, 2.8418433898E+03, 9.5139759131E-01],
	[3.46950E+04, 2.2995875005E+04, 5.0176441846E+03, 9.1709683549E+03, 2.8423422625E+03, 9.5141979414E-01],
	[3.47000E+04, 2.3001528114E+04, 5.0176478583E+03, 9.1752507096E+03, 2.8428410250E+03, 9.5144198539E-01],
	[3.47050E+04, 2.3007181797E+04, 5.0176515316E+03, 9.1795344449E+03, 2.8433396772E+03, 9.5146416508E-01],
	[3.47100E+04, 2.3012836056E+04, 5.0176552043E+03, 9.1838195610E+03, 2.8438382193E+03, 9.5148633320E-01],
	[3.47150E+04, 2.3018490889E+04, 5.0176588765E+03, 9.1881060583E+03, 2.8443366512E+03, 9.5150848977E-01],
	[3.47200E+04, 2.3024146297E+04, 5.0176625481E+03, 9.1923939369E+03, 2.8448349728E+03, 9.5153063480E-01],
	[3.47250E+04, 2.3029802279E+04, 5.0176662193E+03, 9.1966831971E+03, 2.8453331843E+03, 9.5155276829E-01],
	[3.47300E+04, 2.3035458837E+04, 5.0176698899E+03, 9.2009738391E+03, 2.8458312855E+03, 9.5157489024E-01],
	[3.47350E+04, 2.3041115969E+04, 5.0176735599E+03, 9.2052658632E+03, 2.8463292766E+03, 9.5159700066E-01],
	[3.47400E+04, 2.3046773676E+04, 5.0176772295E+03, 9.2095592697E+03, 2.8468271575E+03, 9.5161909957E-01],
	[3.47450E+04, 2.3052431958E+04, 5.0176808985E+03, 9.2138540587E+03, 2.8473249281E+03, 9.5164118695E-01],
	[3.47500E+04, 2.3058090814E+04, 5.0176845670E+03, 9.2181502305E+03, 2.8478225886E+03, 9.5166326284E-01],
	[3.47550E+04, 2.3063750245E+04, 5.0176882350E+03, 9.2224477854E+03, 2.8483201388E+03, 9.5168532722E-01],
	[3.47600E+04, 2.3069410251E+04, 5.0176919025E+03, 9.2267467236E+03, 2.8488175789E+03, 9.5170738010E-01],
	[3.47650E+04, 2.3075070831E+04, 5.0176955694E+03, 9.2310470453E+03, 2.8493149087E+03, 9.5172942150E-01],
	[3.47700E+04, 2.3080731986E+04, 5.0176992358E+03, 9.2353487508E+03, 2.8498121284E+03, 9.5175145141E-01],
	[3.47750E+04, 2.3086393716E+04, 5.0177029017E+03, 9.2396518404E+03, 2.8503092378E+03, 9.5177346985E-01],
	[3.47800E+04, 2.3092056020E+04, 5.0177065671E+03, 9.2439563143E+03, 2.8508062371E+03, 9.5179547682E-01],
	[3.47850E+04, 2.3097718898E+04, 5.0177102319E+03, 9.2482621727E+03, 2.8513031261E+03, 9.5181747233E-01],
	[3.47900E+04, 2.3103382351E+04, 5.0177138962E+03, 9.2525694159E+03, 2.8517999049E+03, 9.5183945638E-01],
	[3.47950E+04, 2.3109046379E+04, 5.0177175600E+03, 9.2568780441E+03, 2.8522965736E+03, 9.5186142898E-01],
	[3.48000E+04, 2.3114710981E+04, 5.0177212233E+03, 9.2611880576E+03, 2.8527931320E+03, 9.5188339014E-01],
	[3.48050E+04, 2.3120376157E+04, 5.0177248860E+03, 9.2654994565E+03, 2.8532895803E+03, 9.5190533986E-01],
	[3.48100E+04, 2.3126041908E+04, 5.0177285482E+03, 9.2698122413E+03, 2.8537859183E+03, 9.5192727816E-01],
	[3.48150E+04, 2.3131708233E+04, 5.0177322099E+03, 9.2741264121E+03, 2.8542821462E+03, 9.5194920502E-01],
	[3.48200E+04, 2.3137375132E+04, 5.0177358711E+03, 9.2784419691E+03, 2.8547782638E+03, 9.5197112048E-01],
	[3.48250E+04, 2.3143042606E+04, 5.0177395317E+03, 9.2827589126E+03, 2.8552742713E+03, 9.5199302452E-01],
	[3.48300E+04, 2.3148710654E+04, 5.0177431918E+03, 9.2870772428E+03, 2.8557701686E+03, 9.5201491715E-01],
	[3.48350E+04, 2.3154379276E+04, 5.0177468514E+03, 9.2913969601E+03, 2.8562659556E+03, 9.5203679839E-01],
	[3.48400E+04, 2.3160048473E+04, 5.0177505105E+03, 9.2957180645E+03, 2.8567616325E+03, 9.5205866824E-01],
	[3.48450E+04, 2.3165718244E+04, 5.0177541691E+03, 9.3000405565E+03, 2.8572571992E+03, 9.5208052670E-01],
	[3.48500E+04, 2.3171388589E+04, 5.0177578271E+03, 9.3043644362E+03, 2.8577526557E+03, 9.5210237379E-01],
	[3.48550E+04, 2.3177059508E+04, 5.0177614846E+03, 9.3086897038E+03, 2.8582480020E+03, 9.5212420950E-01],
	[3.48600E+04, 2.3182731001E+04, 5.0177651416E+03, 9.3130163597E+03, 2.8587432381E+03, 9.5214603384E-01],
	[3.48650E+04, 2.3188403068E+04, 5.0177687981E+03, 9.3173444040E+03, 2.8592383640E+03, 9.5216784683E-01],
	[3.48700E+04, 2.3194075710E+04, 5.0177724540E+03, 9.3216738371E+03, 2.8597333797E+03, 9.5218964847E-01],
	[3.48750E+04, 2.3199748925E+04, 5.0177761094E+03, 9.3260046590E+03, 2.8602282852E+03, 9.5221143875E-01],
	[3.48800E+04, 2.3205422715E+04, 5.0177797643E+03, 9.3303368702E+03, 2.8607230805E+03, 9.5223321770E-01],
	[3.48850E+04, 2.3211097079E+04, 5.0177834187E+03, 9.3346704709E+03, 2.8612177657E+03, 9.5225498532E-01],
	[3.48900E+04, 2.3216772016E+04, 5.0177870726E+03, 9.3390054612E+03, 2.8617123407E+03, 9.5227674161E-01],
	[3.48950E+04, 2.3222447528E+04, 5.0177907259E+03, 9.3433418414E+03, 2.8622068054E+03, 9.5229848657E-01],
	[3.49000E+04, 2.3228123613E+04, 5.0177943787E+03, 9.3476796119E+03, 2.8627011600E+03, 9.5232022023E-01],
	[3.49050E+04, 2.3233800273E+04, 5.0177980310E+03, 9.3520187727E+03, 2.8631954044E+03, 9.5234194257E-01],
	[3.49100E+04, 2.3239477506E+04, 5.0178016828E+03, 9.3563593243E+03, 2.8636895387E+03, 9.5236365362E-01],
	[3.49150E+04, 2.3245155314E+04, 5.0178053341E+03, 9.3607012667E+03, 2.8641835627E+03, 9.5238535337E-01],
	[3.49200E+04, 2.3250833695E+04, 5.0178089848E+03, 9.3650446004E+03, 2.8646774766E+03, 9.5240704183E-01],
	[3.49250E+04, 2.3256512650E+04, 5.0178126350E+03, 9.3693893254E+03, 2.8651712802E+03, 9.5242871901E-01],
	[3.49300E+04, 2.3262192179E+04, 5.0178162847E+03, 9.3737354421E+03, 2.8656649737E+03, 9.5245038491E-01],
	[3.49350E+04, 2.3267872281E+04, 5.0178199339E+03, 9.3780829507E+03, 2.8661585571E+03, 9.5247203955E-01],
	[3.49400E+04, 2.3273552958E+04, 5.0178235826E+03, 9.3824318514E+03, 2.8666520302E+03, 9.5249368292E-01],
	[3.49450E+04, 2.3279234208E+04, 5.0178272307E+03, 9.3867821445E+03, 2.8671453932E+03, 9.5251531503E-01],
	[3.49500E+04, 2.3284916031E+04, 5.0178308783E+03, 9.3911338303E+03, 2.8676386460E+03, 9.5253693589E-01],
	[3.49550E+04, 2.3290598429E+04, 5.0178345254E+03, 9.3954869089E+03, 2.8681317886E+03, 9.5255854550E-01],
	[3.49600E+04, 2.3296281400E+04, 5.0178381720E+03, 9.3998413807E+03, 2.8686248211E+03, 9.5258014387E-01],
	[3.49650E+04, 2.3301964945E+04, 5.0178418181E+03, 9.4041972459E+03, 2.8691177433E+03, 9.5260173100E-01],
	[3.49700E+04, 2.3307649063E+04, 5.0178454636E+03, 9.4085545046E+03, 2.8696105555E+03, 9.5262330691E-01],
	[3.49750E+04, 2.3313333755E+04, 5.0178491086E+03, 9.4129131573E+03, 2.8701032574E+03, 9.5264487160E-01],
	[3.49800E+04, 2.3319019021E+04, 5.0178527531E+03, 9.4172732040E+03, 2.8705958492E+03, 9.5266642506E-01],
	[3.49850E+04, 2.3324704860E+04, 5.0178563971E+03, 9.4216346451E+03, 2.8710883308E+03, 9.5268796732E-01],
	[3.49900E+04, 2.3330391272E+04, 5.0178600406E+03, 9.4259974809E+03, 2.8715807023E+03, 9.5270949837E-01],
	[3.49950E+04, 2.3336078259E+04, 5.0178636835E+03, 9.4303617114E+03, 2.8720729636E+03, 9.5273101822E-01],
	[3.50000E+04, 2.3341765818E+04, 5.0178673260E+03, 9.4347273371E+03, 2.8725651147E+03, 9.5275252688E-01],
	[3.50050E+04, 2.3347453951E+04, 5.0178709679E+03, 9.4391143818E+03, 2.8730590108E+03, 9.5277402435E-01],
	[3.50100E+04, 2.3353142658E+04, 5.0178746093E+03, 9.4435028380E+03, 2.8735527960E+03, 9.5279551064E-01],
	[3.50150E+04, 2.3358831937E+04, 5.0178782502E+03, 9.4478927061E+03, 2.8740464704E+03, 9.5281698575E-01],
	[3.50200E+04, 2.3364521791E+04, 5.0178818905E+03, 9.4522839862E+03, 2.8745400340E+03, 9.5283844970E-01],
	[3.50250E+04, 2.3370212217E+04, 5.0178855304E+03, 9.4566766786E+03, 2.8750334867E+03, 9.5285990248E-01],
	[3.50300E+04, 2.3375903217E+04, 5.0178891697E+03, 9.4610707836E+03, 2.8755268286E+03, 9.5288134410E-01],
	[3.50350E+04, 2.3381594790E+04, 5.0178928085E+03, 9.4654663014E+03, 2.8760200596E+03, 9.5290277457E-01],
	[3.50400E+04, 2.3387286937E+04, 5.0178964468E+03, 9.4698632323E+03, 2.8765131798E+03, 9.5292419389E-01],
	[3.50450E+04, 2.3392979657E+04, 5.0179000846E+03, 9.4742615765E+03, 2.8770061892E+03, 9.5294560207E-01],
	[3.50500E+04, 2.3398672949E+04, 5.0179037219E+03, 9.4786613342E+03, 2.8774990877E+03, 9.5296699912E-01],
	[3.50550E+04, 2.3404366816E+04, 5.0179073586E+03, 9.4830625058E+03, 2.8779918754E+03, 9.5298838504E-01],
	[3.50600E+04, 2.3410061255E+04, 5.0179109949E+03, 9.4874650915E+03, 2.8784845523E+03, 9.5300975984E-01],
	[3.50650E+04, 2.3415756268E+04, 5.0179146306E+03, 9.4918690915E+03, 2.8789771183E+03, 9.5303112352E-01],
	[3.50700E+04, 2.3421451853E+04, 5.0179182658E+03, 9.4962745060E+03, 2.8794695735E+03, 9.5305247609E-01],
	[3.50750E+04, 2.3427148012E+04, 5.0179219005E+03, 9.5006813354E+03, 2.8799619179E+03, 9.5307381755E-01],
	[3.50800E+04, 2.3432844744E+04, 5.0179255346E+03, 9.5050895799E+03, 2.8804541514E+03, 9.5309514792E-01],
	[3.50850E+04, 2.3438542049E+04, 5.0179291683E+03, 9.5094992397E+03, 2.8809462742E+03, 9.5311646719E-01],
	[3.50900E+04, 2.3444239927E+04, 5.0179328014E+03, 9.5139103151E+03, 2.8814382861E+03, 9.5313777538E-01],
	[3.50950E+04, 2.3449938378E+04, 5.0179364340E+03, 9.5183228063E+03, 2.8819301872E+03, 9.5315907248E-01],
	[3.51000E+04, 2.3455637401E+04, 5.0179400661E+03, 9.5227367136E+03, 2.8824219775E+03, 9.5318035851E-01],
	[3.51050E+04, 2.3461336998E+04, 5.0179436977E+03, 9.5271520373E+03, 2.8829136570E+03, 9.5320163347E-01],
	[3.51100E+04, 2.3467037168E+04, 5.0179473288E+03, 9.5315687775E+03, 2.8834052256E+03, 9.5322289737E-01],
	[3.51150E+04, 2.3472737911E+04, 5.0179509594E+03, 9.5359869346E+03, 2.8838966835E+03, 9.5324415020E-01],
	[3.51200E+04, 2.3478439227E+04, 5.0179545894E+03, 9.5404065088E+03, 2.8843880305E+03, 9.5326539199E-01],
	[3.51250E+04, 2.3484141115E+04, 5.0179582190E+03, 9.5448275004E+03, 2.8848792668E+03, 9.5328662273E-01],
	[3.51300E+04, 2.3489843576E+04, 5.0179618480E+03, 9.5492499095E+03, 2.8853703922E+03, 9.5330784243E-01],
	[3.51350E+04, 2.3495546611E+04, 5.0179654765E+03, 9.5536737365E+03, 2.8858614068E+03, 9.5332905110E-01],
	[3.51400E+04, 2.3501250218E+04, 5.0179691045E+03, 9.5580989817E+03, 2.8863523107E+03, 9.5335024873E-01],
	[3.51450E+04, 2.3506954397E+04, 5.0179727320E+03, 9.5625256451E+03, 2.8868431037E+03, 9.5337143535E-01],
	[3.51500E+04, 2.3512659150E+04, 5.0179763589E+03, 9.5669537272E+03, 2.8873337859E+03, 9.5339261095E-01],
	[3.51550E+04, 2.3518364475E+04, 5.0179799854E+03, 9.5713832281E+03, 2.8878243574E+03, 9.5341377554E-01],
	[3.51600E+04, 2.3524070373E+04, 5.0179836113E+03, 9.5758141482E+03, 2.8883148180E+03, 9.5343492912E-01],
	[3.51650E+04, 2.3529776844E+04, 5.0179872368E+03, 9.5802464876E+03, 2.8888051679E+03, 9.5345607170E-01],
	[3.51700E+04, 2.3535483887E+04, 5.0179908617E+03, 9.5846802467E+03, 2.8892954070E+03, 9.5347720329E-01],
	[3.51750E+04, 2.3541191503E+04, 5.0179944861E+03, 9.5891154256E+03, 2.8897855353E+03, 9.5349832390E-01],
	[3.51800E+04, 2.3546899691E+04, 5.0179981100E+03, 9.5935520246E+03, 2.8902755528E+03, 9.5351943352E-01],
	[3.51850E+04, 2.3552608452E+04, 5.0180017334E+03, 9.5979900440E+03, 2.8907654595E+03, 9.5354053217E-01],
	[3.51900E+04, 2.3558317786E+04, 5.0180053562E+03, 9.6024294840E+03, 2.8912552555E+03, 9.5356161985E-01],
	[3.51950E+04, 2.3564027692E+04, 5.0180089786E+03, 9.6068703450E+03, 2.8917449407E+03, 9.5358269656E-01],
	[3.52000E+04, 2.3569738171E+04, 5.0180126004E+03, 9.6113126270E+03, 2.8922345151E+03, 9.5360376232E-01],
	[3.52050E+04, 2.3575449222E+04, 5.0180162218E+03, 9.6157563304E+03, 2.8927239787E+03, 9.5362481712E-01],
	[3.52100E+04, 2.3581160846E+04, 5.0180198426E+03, 9.6202014555E+03, 2.8932133316E+03, 9.5364586098E-01],
	[3.52150E+04, 2.3586873042E+04, 5.0180234629E+03, 9.6246480024E+03, 2.8937025737E+03, 9.5366689390E-01],
	[3.52200E+04, 2.3592585810E+04, 5.0180270827E+03, 9.6290959715E+03, 2.8941917050E+03, 9.5368791588E-01],
	[3.52250E+04, 2.3598299151E+04, 5.0180307020E+03, 9.6335453630E+03, 2.8946807256E+03, 9.5370892694E-01],
	[3.52300E+04, 2.3604013064E+04, 5.0180343207E+03, 9.6379961771E+03, 2.8951696355E+03, 9.5372992707E-01],
	[3.52350E+04, 2.3609727550E+04, 5.0180379390E+03, 9.6424484142E+03, 2.8956584346E+03, 9.5375091629E-01],
	[3.52400E+04, 2.3615442608E+04, 5.0180415567E+03, 9.6469020743E+03, 2.8961471229E+03, 9.5377189459E-01],
	[3.52450E+04, 2.3621158238E+04, 5.0180451740E+03, 9.6513571579E+03, 2.8966357005E+03, 9.5379286199E-01],
	[3.52500E+04, 2.3626874441E+04, 5.0180487907E+03, 9.6558136651E+03, 2.8971241673E+03, 9.5381381849E-01],
	[3.52550E+04, 2.3632591215E+04, 5.0180524069E+03, 9.6602715963E+03, 2.8976125234E+03, 9.5383476410E-01],
	[3.52600E+04, 2.3638308562E+04, 5.0180560226E+03, 9.6647309516E+03, 2.8981007687E+03, 9.5385569882E-01],
	[3.52650E+04, 2.3644026481E+04, 5.0180596378E+03, 9.6691917313E+03, 2.8985889034E+03, 9.5387662266E-01],
	[3.52700E+04, 2.3649744973E+04, 5.0180632525E+03, 9.6736539356E+03, 2.8990769272E+03, 9.5389753562E-01],
	[3.52750E+04, 2.3655464036E+04, 5.0180668667E+03, 9.6781175649E+03, 2.8995648404E+03, 9.5391843772E-01],
	[3.52800E+04, 2.3661183672E+04, 5.0180704804E+03, 9.6825826194E+03, 2.9000526428E+03, 9.5393932895E-01],
	[3.52850E+04, 2.3666903879E+04, 5.0180740935E+03, 9.6870490992E+03, 2.9005403345E+03, 9.5396020932E-01],
	[3.52900E+04, 2.3672624659E+04, 5.0180777062E+03, 9.6915170048E+03, 2.9010279155E+03, 9.5398107884E-01],
	[3.52950E+04, 2.3678346011E+04, 5.0180813183E+03, 9.6959863362E+03, 2.9015153857E+03, 9.5400193751E-01],
	[3.53000E+04, 2.3684067935E+04, 5.0180849300E+03, 9.7004570939E+03, 2.9020027452E+03, 9.5402278535E-01],
	[3.53050E+04, 2.3689790431E+04, 5.0180885411E+03, 9.7049292779E+03, 2.9024899941E+03, 9.5404362234E-01],
	[3.53100E+04, 2.3695513499E+04, 5.0180921517E+03, 9.7094028887E+03, 2.9029771322E+03, 9.5406444851E-01],
	[3.53150E+04, 2.3701237138E+04, 5.0180957618E+03, 9.7138779264E+03, 2.9034641596E+03, 9.5408526386E-01],
	[3.53200E+04, 2.3706961350E+04, 5.0180993714E+03, 9.7183543912E+03, 2.9039510763E+03, 9.5410606839E-01],
	[3.53250E+04, 2.3712686134E+04, 5.0181029805E+03, 9.7228322835E+03, 2.9044378823E+03, 9.5412686211E-01],
	[3.53300E+04, 2.3718411489E+04, 5.0181065891E+03, 9.7273116035E+03, 2.9049245776E+03, 9.5414764502E-01],
	[3.53350E+04, 2.3724137417E+04, 5.0181101972E+03, 9.7317923515E+03, 2.9054111622E+03, 9.5416841713E-01],
	[3.53400E+04, 2.3729863916E+04, 5.0181138047E+03, 9.7362745276E+03, 2.9058976361E+03, 9.5418917845E-01],
	[3.53450E+04, 2.3735590987E+04, 5.0181174118E+03, 9.7407581322E+03, 2.9063839993E+03, 9.5420992898E-01],
	[3.53500E+04, 2.3741318630E+04, 5.0181210183E+03, 9.7452431654E+03, 2.9068702518E+03, 9.5423066873E-01],
	[3.53550E+04, 2.3747046845E+04, 5.0181246244E+03, 9.7497296277E+03, 2.9073563937E+03, 9.5425139770E-01],
	[3.53600E+04, 2.3752775631E+04, 5.0181282299E+03, 9.7542175191E+03, 2.9078424248E+03, 9.5427211591E-01],
	[3.53650E+04, 2.3758504989E+04, 5.0181318349E+03, 9.7587068400E+03, 2.9083283453E+03, 9.5429282334E-01],
	[3.53700E+04, 2.3764234919E+04, 5.0181354395E+03, 9.7631975906E+03, 2.9088141552E+03, 9.5431352002E-01],
	[3.53750E+04, 2.3769965421E+04, 5.0181390435E+03, 9.7676897712E+03, 2.9092998543E+03, 9.5433420595E-01],
	[3.53800E+04, 2.3775696494E+04, 5.0181426470E+03, 9.7721833820E+03, 2.9097854428E+03, 9.5435488113E-01],
	[3.53850E+04, 2.3781428138E+04, 5.0181462500E+03, 9.7766784232E+03, 2.9102709206E+03, 9.5437554557E-01],
	[3.53900E+04, 2.3787160355E+04, 5.0181498525E+03, 9.7811748952E+03, 2.9107562878E+03, 9.5439619927E-01],
	[3.53950E+04, 2.3792893143E+04, 5.0181534545E+03, 9.7856727981E+03, 2.9112415443E+03, 9.5441684224E-01],
	[3.54000E+04, 2.3798626502E+04, 5.0181570559E+03, 9.7901721323E+03, 2.9117266902E+03, 9.5443747449E-01],
	[3.54050E+04, 2.3804360433E+04, 5.0181606569E+03, 9.7946728979E+03, 2.9122117254E+03, 9.5445809602E-01],
	[3.54100E+04, 2.3810094936E+04, 5.0181642574E+03, 9.7991750953E+03, 2.9126966500E+03, 9.5447870684E-01],
	[3.54150E+04, 2.3815830010E+04, 5.0181678574E+03, 9.8036787247E+03, 2.9131814639E+03, 9.5449930695E-01],
	[3.54200E+04, 2.3821565655E+04, 5.0181714568E+03, 9.8081837863E+03, 2.9136661672E+03, 9.5451989637E-01],
	[3.54250E+04, 2.3827301872E+04, 5.0181750558E+03, 9.8126902803E+03, 2.9141507598E+03, 9.5454047509E-01],
	[3.54300E+04, 2.3833038661E+04, 5.0181786542E+03, 9.8171982072E+03, 2.9146352419E+03, 9.5456104311E-01],
	[3.54350E+04, 2.3838776020E+04, 5.0181822522E+03, 9.8217075670E+03, 2.9151196133E+03, 9.5458160046E-01],
	[3.54400E+04, 2.3844513951E+04, 5.0181858496E+03, 9.8262183600E+03, 2.9156038741E+03, 9.5460214713E-01],
	[3.54450E+04, 2.3850252454E+04, 5.0181894465E+03, 9.8307305866E+03, 2.9160880242E+03, 9.5462268313E-01],
	[3.54500E+04, 2.3855991528E+04, 5.0181930430E+03, 9.8352442469E+03, 2.9165720638E+03, 9.5464320846E-01],
	[3.54550E+04, 2.3861731173E+04, 5.0181966389E+03, 9.8397593412E+03, 2.9170559927E+03, 9.5466372313E-01],
	[3.54600E+04, 2.3867471389E+04, 5.0182002343E+03, 9.8442758698E+03, 2.9175398110E+03, 9.5468422715E-01],
	[3.54650E+04, 2.3873212177E+04, 5.0182038292E+03, 9.8487938328E+03, 2.9180235187E+03, 9.5470472052E-01],
	[3.54700E+04, 2.3878953535E+04, 5.0182074236E+03, 9.8533132307E+03, 2.9185071159E+03, 9.5472520325E-01],
	[3.54750E+04, 2.3884695465E+04, 5.0182110175E+03, 9.8578340635E+03, 2.9189906024E+03, 9.5474567534E-01],
	[3.54800E+04, 2.3890437966E+04, 5.0182146109E+03, 9.8623563316E+03, 2.9194739783E+03, 9.5476613680E-01],
	[3.54850E+04, 2.3896181039E+04, 5.0182182038E+03, 9.8668800352E+03, 2.9199572437E+03, 9.5478658764E-01],
	[3.54900E+04, 2.3901924682E+04, 5.0182217962E+03, 9.8714051746E+03, 2.9204403984E+03, 9.5480702786E-01],
	[3.54950E+04, 2.3907668897E+04, 5.0182253881E+03, 9.8759317501E+03, 2.9209234426E+03, 9.5482745746E-01],
	[3.55000E+04, 2.3913413682E+04, 5.0182289795E+03, 9.8804597618E+03, 2.9214063762E+03, 9.5484787646E-01],
	[3.55050E+04, 2.3919159039E+04, 5.0182325704E+03, 9.8849892100E+03, 2.9218891993E+03, 9.5486828485E-01],
	[3.55100E+04, 2.3924904967E+04, 5.0182361608E+03, 9.8895200950E+03, 2.9223719117E+03, 9.5488868265E-01],
	[3.55150E+04, 2.3930651466E+04, 5.0182397506E+03, 9.8940524171E+03, 2.9228545136E+03, 9.5490906986E-01],
	[3.55200E+04, 2.3936398535E+04, 5.0182433400E+03, 9.8985861764E+03, 2.9233370050E+03, 9.5492944649E-01],
	[3.55250E+04, 2.3942146176E+04, 5.0182469289E+03, 9.9031213733E+03, 2.9238193858E+03, 9.5494981253E-01],
	[3.55300E+04, 2.3947894388E+04, 5.0182505173E+03, 9.9076580080E+03, 2.9243016560E+03, 9.5497016801E-01],
	[3.55350E+04, 2.3953643170E+04, 5.0182541051E+03, 9.9121960807E+03, 2.9247838157E+03, 9.5499051291E-01],
	[3.55400E+04, 2.3959392524E+04, 5.0182576925E+03, 9.9167355917E+03, 2.9252658649E+03, 9.5501084726E-01],
	[3.55450E+04, 2.3965142448E+04, 5.0182612794E+03, 9.9212765412E+03, 2.9257478035E+03, 9.5503117105E-01],
	[3.55500E+04, 2.3970892943E+04, 5.0182648657E+03, 9.9258189296E+03, 2.9262296315E+03, 9.5505148429E-01],
	[3.55550E+04, 2.3976644009E+04, 5.0182684516E+03, 9.9303627570E+03, 2.9267113491E+03, 9.5507178699E-01],
	[3.55600E+04, 2.3982395646E+04, 5.0182720369E+03, 9.9349080238E+03, 2.9271929561E+03, 9.5509207915E-01],
	[3.55650E+04, 2.3988147853E+04, 5.0182756218E+03, 9.9394547301E+03, 2.9276744526E+03, 9.5511236077E-01],
	[3.55700E+04, 2.3993900632E+04, 5.0182792061E+03, 9.9440028762E+03, 2.9281558386E+03, 9.5513263187E-01],
	[3.55750E+04, 2.3999653981E+04, 5.0182827900E+03, 9.9485524624E+03, 2.9286371141E+03, 9.5515289246E-01],
	[3.55800E+04, 2.4005407900E+04, 5.0182863734E+03, 9.9531034889E+03, 2.9291182790E+03, 9.5517314252E-01],
	[3.55850E+04, 2.4011162391E+04, 5.0182899562E+03, 9.9576559559E+03, 2.9295993335E+03, 9.5519338208E-01],
	[3.55900E+04, 2.4016917452E+04, 5.0182935386E+03, 9.9622098639E+03, 2.9300802774E+03, 9.5521361113E-01],
	[3.55950E+04, 2.4022673084E+04, 5.0182971204E+03, 9.9667652128E+03, 2.9305611109E+03, 9.5523382969E-01],
	[3.56000E+04, 2.4028429286E+04, 5.0183007018E+03, 9.9713220031E+03, 2.9310418339E+03, 9.5525403775E-01],
	[3.56050E+04, 2.4034186059E+04, 5.0183042826E+03, 9.9758802350E+03, 2.9315224464E+03, 9.5527423533E-01],
	[3.56100E+04, 2.4039943402E+04, 5.0183078630E+03, 9.9804399088E+03, 2.9320029484E+03, 9.5529442243E-01],
	[3.56150E+04, 2.4045701316E+04, 5.0183114428E+03, 9.9850010246E+03, 2.9324833399E+03, 9.5531459905E-01],
	[3.56200E+04, 2.4051459801E+04, 5.0183150222E+03, 9.9895635828E+03, 2.9329636210E+03, 9.5533476521E-01],
	[3.56250E+04, 2.4057218856E+04, 5.0183186010E+03, 9.9941275835E+03, 2.9334437916E+03, 9.5535492090E-01],
	[3.56300E+04, 2.4062978481E+04, 5.0183221794E+03, 9.9986930272E+03, 2.9339238517E+03, 9.5537506613E-01],
	[3.56350E+04, 2.4068738677E+04, 5.0183257572E+03, 1.0003259914E+04, 2.9344038014E+03, 9.5539520092E-01],
	[3.56400E+04, 2.4074499444E+04, 5.0183293346E+03, 1.0007828244E+04, 2.9348836406E+03, 9.5541532526E-01],
	[3.56450E+04, 2.4080260780E+04, 5.0183329114E+03, 1.0012398018E+04, 2.9353633694E+03, 9.5543543915E-01],
	[3.56500E+04, 2.4086022687E+04, 5.0183364878E+03, 1.0016969235E+04, 2.9358429877E+03, 9.5545554262E-01],
	[3.56550E+04, 2.4091785165E+04, 5.0183400636E+03, 1.0021541897E+04, 2.9363224956E+03, 9.5547563565E-01],
	[3.56600E+04, 2.4097548213E+04, 5.0183436390E+03, 1.0026116003E+04, 2.9368018930E+03, 9.5549571827E-01],
	[3.56650E+04, 2.4103311831E+04, 5.0183472138E+03, 1.0030691554E+04, 2.9372811801E+03, 9.5551579046E-01],
	[3.56700E+04, 2.4109076019E+04, 5.0183507882E+03, 1.0035268549E+04, 2.9377603567E+03, 9.5553585225E-01],
	[3.56750E+04, 2.4114840778E+04, 5.0183543620E+03, 1.0039846990E+04, 2.9382394229E+03, 9.5555590363E-01],
	[3.56800E+04, 2.4120606106E+04, 5.0183579354E+03, 1.0044426876E+04, 2.9387183786E+03, 9.5557594461E-01],
	[3.56850E+04, 2.4126372006E+04, 5.0183615083E+03, 1.0049008207E+04, 2.9391972240E+03, 9.5559597520E-01],
	[3.56900E+04, 2.4132138475E+04, 5.0183650806E+03, 1.0053590985E+04, 2.9396759590E+03, 9.5561599540E-01],
	[3.56950E+04, 2.4137905514E+04, 5.0183686525E+03, 1.0058175209E+04, 2.9401545835E+03, 9.5563600522E-01],
	[3.57000E+04, 2.4143684980E+04, 5.0183743731E+03, 1.0062760879E+04, 2.9406340115E+03, 9.5565600466E-01],
	[3.57050E+04, 2.4149491129E+04, 5.0183848247E+03, 1.0067347995E+04, 2.9411153421E+03, 9.5567599373E-01],
	[3.57100E+04, 2.4155297861E+04, 5.0183952748E+03, 1.0071936559E+04, 2.9415965634E+03, 9.5569597243E-01],
	[3.57150E+04, 2.4161105176E+04, 5.0184057234E+03, 1.0076526570E+04, 2.9420776756E+03, 9.5571594078E-01],
	[3.57200E+04, 2.4166913074E+04, 5.0184161707E+03, 1.0081118028E+04, 2.9425586786E+03, 9.5573589877E-01],
	[3.57250E+04, 2.4172721555E+04, 5.0184266164E+03, 1.0085710934E+04, 2.9430395725E+03, 9.5575584641E-01],
	[3.57300E+04, 2.4178530619E+04, 5.0184370608E+03, 1.0090305287E+04, 2.9435203573E+03, 9.5577578371E-01],
	[3.57350E+04, 2.4184340265E+04, 5.0184475037E+03, 1.0094901089E+04, 2.9440010329E+03, 9.5579571068E-01],
	[3.57400E+04, 2.4190150495E+04, 5.0184579451E+03, 1.0099498340E+04, 2.9444815993E+03, 9.5581562732E-01],
	[3.57450E+04, 2.4195961307E+04, 5.0184683852E+03, 1.0104097039E+04, 2.9449620567E+03, 9.5583553363E-01],
	[3.57500E+04, 2.4201772702E+04, 5.0184788238E+03, 1.0108697187E+04, 2.9454424049E+03, 9.5585542962E-01],
	[3.57550E+04, 2.4207584679E+04, 5.0184892609E+03, 1.0113298784E+04, 2.9459226440E+03, 9.5587531529E-01],
	[3.57600E+04, 2.4213397240E+04, 5.0184996966E+03, 1.0117901830E+04, 2.9464027740E+03, 9.5589519066E-01],
	[3.57650E+04, 2.4219210383E+04, 5.0185101309E+03, 1.0122506326E+04, 2.9468827949E+03, 9.5591505573E-01],
	[3.57700E+04, 2.4225024109E+04, 5.0185205637E+03, 1.0127112272E+04, 2.9473627067E+03, 9.5593491050E-01],
	[3.57750E+04, 2.4230838417E+04, 5.0185309951E+03, 1.0131719669E+04, 2.9478425093E+03, 9.5595475498E-01],
	[3.57800E+04, 2.4236653309E+04, 5.0185414251E+03, 1.0136328515E+04, 2.9483222029E+03, 9.5597458918E-01],
	[3.57850E+04, 2.4242468782E+04, 5.0185518536E+03, 1.0140938813E+04, 2.9488017874E+03, 9.5599441310E-01],
	[3.57900E+04, 2.4248284839E+04, 5.0185622807E+03, 1.0145550561E+04, 2.9492812628E+03, 9.5601422674E-01],
	[3.57950E+04, 2.4254101478E+04, 5.0185727064E+03, 1.0150163761E+04, 2.9497606292E+03, 9.5603403012E-01],
	[3.58000E+04, 2.4259918699E+04, 5.0185831306E+03, 1.0154778412E+04, 2.9502398864E+03, 9.5605382323E-01],
	[3.58050E+04, 2.4265736504E+04, 5.0185935534E+03, 1.0159394515E+04, 2.9507190346E+03, 9.5607360609E-01],
	[3.58100E+04, 2.4271554890E+04, 5.0186039747E+03, 1.0164012069E+04, 2.9511980737E+03, 9.5609337870E-01],
	[3.58150E+04, 2.4277373859E+04, 5.0186143946E+03, 1.0168631076E+04, 2.9516770038E+03, 9.5611314106E-01],
	[3.58200E+04, 2.4283193411E+04, 5.0186248131E+03, 1.0173251536E+04, 2.9521558248E+03, 9.5613289318E-01],
	[3.58250E+04, 2.4289013545E+04, 5.0186352302E+03, 1.0177873448E+04, 2.9526345367E+03, 9.5615263507E-01],
	[3.58300E+04, 2.4294834261E+04, 5.0186456458E+03, 1.0182496813E+04, 2.9531131396E+03, 9.5617236673E-01],
	[3.58350E+04, 2.4300655560E+04, 5.0186560600E+03, 1.0187121631E+04, 2.9535916335E+03, 9.5619208817E-01],
	[3.58400E+04, 2.4306477441E+04, 5.0186664727E+03, 1.0191747903E+04, 2.9540700183E+03, 9.5621179940E-01],
	[3.58450E+04, 2.4312299905E+04, 5.0186768841E+03, 1.0196375628E+04, 2.9545482941E+03, 9.5623150041E-01],
	[3.58500E+04, 2.4318122951E+04, 5.0186872940E+03, 1.0201004808E+04, 2.9550264609E+03, 9.5625119122E-01],
	[3.58550E+04, 2.4323946579E+04, 5.0186977024E+03, 1.0205635442E+04, 2.9555045186E+03, 9.5627087182E-01],
	[3.58600E+04, 2.4329770789E+04, 5.0187081095E+03, 1.0210267530E+04, 2.9559824674E+03, 9.5629054224E-01],
	[3.58650E+04, 2.4335595582E+04, 5.0187185151E+03, 1.0214901073E+04, 2.9564603071E+03, 9.5631020247E-01],
	[3.58700E+04, 2.4341420957E+04, 5.0187289193E+03, 1.0219536071E+04, 2.9569380379E+03, 9.5632985251E-01],
	[3.58750E+04, 2.4347246914E+04, 5.0187393220E+03, 1.0224172524E+04, 2.9574156596E+03, 9.5634949238E-01],
	[3.58800E+04, 2.4353073453E+04, 5.0187497233E+03, 1.0228810433E+04, 2.9578931723E+03, 9.5636912208E-01],
	[3.58850E+04, 2.4358900575E+04, 5.0187601232E+03, 1.0233449797E+04, 2.9583705761E+03, 9.5638874161E-01],
	[3.58900E+04, 2.4364728279E+04, 5.0187705217E+03, 1.0238090618E+04, 2.9588478709E+03, 9.5640835098E-01],
	[3.58950E+04, 2.4370556564E+04, 5.0187809187E+03, 1.0242732895E+04, 2.9593250567E+03, 9.5642795020E-01],
	[3.59000E+04, 2.4376385432E+04, 5.0187913144E+03, 1.0247376628E+04, 2.9598021335E+03, 9.5644753927E-01],
	[3.59050E+04, 2.4382214882E+04, 5.0188017085E+03, 1.0252021818E+04, 2.9602791013E+03, 9.5646711820E-01],
	[3.59100E+04, 2.4388044914E+04, 5.0188121013E+03, 1.0256668465E+04, 2.9607559602E+03, 9.5648668700E-01],
	[3.59150E+04, 2.4393875528E+04, 5.0188224926E+03, 1.0261316569E+04, 2.9612327102E+03, 9.5650624566E-01],
	[3.59200E+04, 2.4399706724E+04, 5.0188328826E+03, 1.0265966131E+04, 2.9617093512E+03, 9.5652579419E-01],
	[3.59250E+04, 2.4405538502E+04, 5.0188432710E+03, 1.0270617151E+04, 2.9621858832E+03, 9.5654533261E-01],
	[3.59300E+04, 2.4411370862E+04, 5.0188536581E+03, 1.0275269629E+04, 2.9626623064E+03, 9.5656486091E-01],
	[3.59350E+04, 2.4417203804E+04, 5.0188640437E+03, 1.0279923565E+04, 2.9631386205E+03, 9.5658437910E-01],
	[3.59400E+04, 2.4423037328E+04, 5.0188744280E+03, 1.0284578959E+04, 2.9636148258E+03, 9.5660388719E-01],
	[3.59450E+04, 2.4428871434E+04, 5.0188848107E+03, 1.0289235813E+04, 2.9640909221E+03, 9.5662338519E-01],
	[3.59500E+04, 2.4434706121E+04, 5.0188951921E+03, 1.0293894125E+04, 2.9645669096E+03, 9.5664287309E-01],
	[3.59550E+04, 2.4440541391E+04, 5.0189055721E+03, 1.0298553897E+04, 2.9650427881E+03, 9.5666235091E-01],
	[3.59600E+04, 2.4446377242E+04, 5.0189159506E+03, 1.0303215128E+04, 2.9655185577E+03, 9.5668181864E-01],
	[3.59650E+04, 2.4452213675E+04, 5.0189263277E+03, 1.0307877819E+04, 2.9659942184E+03, 9.5670127631E-01],
	[3.59700E+04, 2.4458050690E+04, 5.0189367034E+03, 1.0312541970E+04, 2.9664697702E+03, 9.5672072390E-01],
	[3.59750E+04, 2.4463888287E+04, 5.0189470776E+03, 1.0317207582E+04, 2.9669452131E+03, 9.5674016143E-01],
	[3.59800E+04, 2.4469726465E+04, 5.0189574505E+03, 1.0321874654E+04, 2.9674205472E+03, 9.5675958890E-01],
	[3.59850E+04, 2.4475565225E+04, 5.0189678219E+03, 1.0326543187E+04, 2.9678957724E+03, 9.5677900632E-01],
	[3.59900E+04, 2.4481404567E+04, 5.0189781919E+03, 1.0331213181E+04, 2.9683708887E+03, 9.5679841370E-01],
	[3.59950E+04, 2.4487244490E+04, 5.0189885605E+03, 1.0335884636E+04, 2.9688458961E+03, 9.5681781103E-01],
	[3.60000E+04, 2.4493084995E+04, 5.0189989276E+03, 1.0340557553E+04, 2.9693207947E+03, 9.5683719833E-01],
	[3.60050E+04, 2.4498926082E+04, 5.0190092934E+03, 1.0345231932E+04, 2.9697955844E+03, 9.5685657560E-01],
	[3.60100E+04, 2.4504767750E+04, 5.0190196577E+03, 1.0349907773E+04, 2.9702702653E+03, 9.5687594285E-01],
	[3.60150E+04, 2.4510610000E+04, 5.0190300206E+03, 1.0354585076E+04, 2.9707448374E+03, 9.5689530008E-01],
	[3.60200E+04, 2.4516452831E+04, 5.0190403821E+03, 1.0359263842E+04, 2.9712193006E+03, 9.5691464729E-01],
	[3.60250E+04, 2.4522296244E+04, 5.0190507422E+03, 1.0363944070E+04, 2.9716936550E+03, 9.5693398450E-01],
	[3.60300E+04, 2.4528140238E+04, 5.0190611009E+03, 1.0368625762E+04, 2.9721679005E+03, 9.5695331171E-01],
	[3.60350E+04, 2.4533984814E+04, 5.0190714581E+03, 1.0373308917E+04, 2.9726420373E+03, 9.5697262892E-01],
	[3.60400E+04, 2.4539829971E+04, 5.0190818139E+03, 1.0377993536E+04, 2.9731160652E+03, 9.5699193615E-01],
	[3.60450E+04, 2.4545675710E+04, 5.0190921683E+03, 1.0382679618E+04, 2.9735899844E+03, 9.5701123339E-01],
	[3.60500E+04, 2.4551522030E+04, 5.0191025213E+03, 1.0387367165E+04, 2.9740637947E+03, 9.5703052065E-01],
	[3.60550E+04, 2.4557368932E+04, 5.0191128729E+03, 1.0392056176E+04, 2.9745374963E+03, 9.5704979793E-01],
	[3.60600E+04, 2.4563216415E+04, 5.0191232231E+03, 1.0396746652E+04, 2.9750110890E+03, 9.5706906525E-01],
	[3.60650E+04, 2.4569064479E+04, 5.0191335718E+03, 1.0401438593E+04, 2.9754845730E+03, 9.5708832261E-01],
	[3.60700E+04, 2.4574913124E+04, 5.0191439192E+03, 1.0406131998E+04, 2.9759579482E+03, 9.5710757001E-01],
	[3.60750E+04, 2.4580762351E+04, 5.0191542651E+03, 1.0410826869E+04, 2.9764312147E+03, 9.5712680747E-01],
	[3.60800E+04, 2.4586612159E+04, 5.0191646096E+03, 1.0415523206E+04, 2.9769043724E+03, 9.5714603497E-01],
	[3.60850E+04, 2.4592462549E+04, 5.0191749527E+03, 1.0420221009E+04, 2.9773774213E+03, 9.5716525254E-01],
	[3.60900E+04, 2.4598313519E+04, 5.0191852944E+03, 1.0424920278E+04, 2.9778503615E+03, 9.5718446017E-01],
	[3.60950E+04, 2.4604165071E+04, 5.0191956347E+03, 1.0429621013E+04, 2.9783231929E+03, 9.5720365788E-01],
	[3.61000E+04, 2.4610017204E+04, 5.0192059736E+03, 1.0434323215E+04, 2.9787959157E+03, 9.5722284566E-01],
	[3.61050E+04, 2.4615869918E+04, 5.0192163110E+03, 1.0439026884E+04, 2.9792685296E+03, 9.5724202353E-01],
	[3.61100E+04, 2.4621723214E+04, 5.0192266471E+03, 1.0443732020E+04, 2.9797410349E+03, 9.5726119149E-01],
	[3.61150E+04, 2.4627577090E+04, 5.0192369817E+03, 1.0448438623E+04, 2.9802134315E+03, 9.5728034954E-01],
	[3.61200E+04, 2.4633431547E+04, 5.0192473150E+03, 1.0453146694E+04, 2.9806857193E+03, 9.5729949769E-01],
	[3.61250E+04, 2.4639286586E+04, 5.0192576468E+03, 1.0457856233E+04, 2.9811578984E+03, 9.5731863594E-01],
	[3.61300E+04, 2.4645142206E+04, 5.0192679772E+03, 1.0462567240E+04, 2.9816299689E+03, 9.5733776431E-01],
	[3.61350E+04, 2.4650998406E+04, 5.0192783062E+03, 1.0467279716E+04, 2.9821019306E+03, 9.5735688279E-01],
	[3.61400E+04, 2.4656855188E+04, 5.0192886338E+03, 1.0471993660E+04, 2.9825737837E+03, 9.5737599140E-01],
	[3.61450E+04, 2.4662712550E+04, 5.0192989600E+03, 1.0476709074E+04, 2.9830455281E+03, 9.5739509013E-01],
	[3.61500E+04, 2.4668570494E+04, 5.0193092848E+03, 1.0481425956E+04, 2.9835171638E+03, 9.5741417900E-01],
	[3.61550E+04, 2.4674429019E+04, 5.0193196081E+03, 1.0486144308E+04, 2.9839886909E+03, 9.5743325801E-01],
	[3.61600E+04, 2.4680288124E+04, 5.0193299301E+03, 1.0490864130E+04, 2.9844601093E+03, 9.5745232716E-01],
	[3.61650E+04, 2.4686147810E+04, 5.0193402507E+03, 1.0495585421E+04, 2.9849314190E+03, 9.5747138646E-01],
	[3.61700E+04, 2.4692008077E+04, 5.0193505698E+03, 1.0500308183E+04, 2.9854026201E+03, 9.5749043592E-01],
	[3.61750E+04, 2.4697868925E+04, 5.0193608876E+03, 1.0505032416E+04, 2.9858737126E+03, 9.5750947554E-01],
	[3.61800E+04, 2.4703730354E+04, 5.0193712039E+03, 1.0509758119E+04, 2.9863446964E+03, 9.5752850533E-01],
	[3.61850E+04, 2.4709592364E+04, 5.0193815189E+03, 1.0514485292E+04, 2.9868155717E+03, 9.5754752528E-01],
	[3.61900E+04, 2.4715454954E+04, 5.0193918324E+03, 1.0519213938E+04, 2.9872863383E+03, 9.5756653542E-01],
	[3.61950E+04, 2.4721318125E+04, 5.0194021446E+03, 1.0523944054E+04, 2.9877569962E+03, 9.5758553574E-01],
	[3.62000E+04, 2.4727181877E+04, 5.0194124553E+03, 1.0528675643E+04, 2.9882275456E+03, 9.5760452625E-01],
	[3.62050E+04, 2.4733046210E+04, 5.0194227646E+03, 1.0533408703E+04, 2.9886979864E+03, 9.5762350696E-01],
	[3.62100E+04, 2.4738911123E+04, 5.0194330725E+03, 1.0538143236E+04, 2.9891683186E+03, 9.5764247786E-01],
	[3.62150E+04, 2.4744776617E+04, 5.0194433791E+03, 1.0542879241E+04, 2.9896385422E+03, 9.5766143897E-01],
	[3.62200E+04, 2.4750642691E+04, 5.0194536842E+03, 1.0547616719E+04, 2.9901086573E+03, 9.5768039030E-01],
	[3.62250E+04, 2.4756509347E+04, 5.0194639879E+03, 1.0552355670E+04, 2.9905786638E+03, 9.5769933184E-01],
	[3.62300E+04, 2.4762376582E+04, 5.0194742902E+03, 1.0557096094E+04, 2.9910485617E+03, 9.5771826360E-01],
	[3.62350E+04, 2.4768244399E+04, 5.0194845912E+03, 1.0561837992E+04, 2.9915183510E+03, 9.5773718559E-01],
	[3.62400E+04, 2.4774112796E+04, 5.0194948907E+03, 1.0566581363E+04, 2.9919880318E+03, 9.5775609782E-01],
	[3.62450E+04, 2.4779981773E+04, 5.0195051888E+03, 1.0571326209E+04, 2.9924576041E+03, 9.5777500028E-01],
	[3.62500E+04, 2.4785851331E+04, 5.0195154855E+03, 1.0576072528E+04, 2.9929270679E+03, 9.5779389299E-01],
	[3.62550E+04, 2.4791721469E+04, 5.0195257808E+03, 1.0580820323E+04, 2.9933964231E+03, 9.5781277595E-01],
	[3.62600E+04, 2.4797592188E+04, 5.0195360748E+03, 1.0585569592E+04, 2.9938656698E+03, 9.5783164916E-01],
	[3.62650E+04, 2.4803463487E+04, 5.0195463673E+03, 1.0590320336E+04, 2.9943348079E+03, 9.5785051264E-01],
	[3.62700E+04, 2.4809335367E+04, 5.0195566584E+03, 1.0595072555E+04, 2.9948038376E+03, 9.5786936638E-01],
	[3.62750E+04, 2.4815207827E+04, 5.0195669481E+03, 1.0599826250E+04, 2.9952727588E+03, 9.5788821040E-01],
	[3.62800E+04, 2.4821080867E+04, 5.0195772365E+03, 1.0604581421E+04, 2.9957415715E+03, 9.5790704470E-01],
	[3.62850E+04, 2.4826954488E+04, 5.0195875234E+03, 1.0609338068E+04, 2.9962102757E+03, 9.5792586927E-01],
	[3.62900E+04, 2.4832828689E+04, 5.0195978090E+03, 1.0614096191E+04, 2.9966788714E+03, 9.5794468414E-01],
	[3.62950E+04, 2.4838703471E+04, 5.0196080931E+03, 1.0618855791E+04, 2.9971473586E+03, 9.5796348931E-01],
	[3.63000E+04, 2.4844578832E+04, 5.0196183758E+03, 1.0623616867E+04, 2.9976157374E+03, 9.5798228477E-01],
	[3.63050E+04, 2.4850454774E+04, 5.0196286572E+03, 1.0628379421E+04, 2.9980840077E+03, 9.5800107054E-01],
	[3.63100E+04, 2.4856331296E+04, 5.0196389372E+03, 1.0633143452E+04, 2.9985521696E+03, 9.5801984662E-01],
	[3.63150E+04, 2.4862208399E+04, 5.0196492157E+03, 1.0637908960E+04, 2.9990202231E+03, 9.5803861301E-01],
	[3.63200E+04, 2.4868086081E+04, 5.0196594929E+03, 1.0642675946E+04, 2.9994881681E+03, 9.5805736973E-01],
	[3.63250E+04, 2.4873964344E+04, 5.0196697687E+03, 1.0647444411E+04, 2.9999560047E+03, 9.5807611678E-01],
	[3.63300E+04, 2.4879843187E+04, 5.0196800430E+03, 1.0652214353E+04, 3.0004237328E+03, 9.5809485416E-01],
	[3.63350E+04, 2.4885722610E+04, 5.0196903160E+03, 1.0656985775E+04, 3.0008913526E+03, 9.5811358188E-01],
	[3.63400E+04, 2.4891602613E+04, 5.0197005876E+03, 1.0661758675E+04, 3.0013588639E+03, 9.5813229994E-01],
	[3.63450E+04, 2.4897483196E+04, 5.0197108578E+03, 1.0666533054E+04, 3.0018262669E+03, 9.5815100836E-01],
	[3.63500E+04, 2.4903364359E+04, 5.0197211267E+03, 1.0671308913E+04, 3.0022935614E+03, 9.5816970713E-01],
	[3.63550E+04, 2.4909246102E+04, 5.0197313941E+03, 1.0676086251E+04, 3.0027607476E+03, 9.5818839626E-01],
	[3.63600E+04, 2.4915128425E+04, 5.0197416601E+03, 1.0680865069E+04, 3.0032278254E+03, 9.5820707575E-01],
	[3.63650E+04, 2.4921011328E+04, 5.0197519247E+03, 1.0685645367E+04, 3.0036947949E+03, 9.5822574562E-01],
	[3.63700E+04, 2.4926894812E+04, 5.0197621880E+03, 1.0690427146E+04, 3.0041616559E+03, 9.5824440586E-01],
	[3.63750E+04, 2.4932778875E+04, 5.0197724499E+03, 1.0695210405E+04, 3.0046284087E+03, 9.5826305649E-01],
	[3.63800E+04, 2.4938663518E+04, 5.0197827103E+03, 1.0699995145E+04, 3.0050950530E+03, 9.5828169750E-01],
	[3.63850E+04, 2.4944548740E+04, 5.0197929694E+03, 1.0704781367E+04, 3.0055615891E+03, 9.5830032890E-01],
	[3.63900E+04, 2.4950434543E+04, 5.0198032271E+03, 1.0709569069E+04, 3.0060280168E+03, 9.5831895070E-01],
	[3.63950E+04, 2.4956320926E+04, 5.0198134834E+03, 1.0714358253E+04, 3.0064943362E+03, 9.5833756290E-01],
	[3.64000E+04, 2.4962207888E+04, 5.0198237383E+03, 1.0719148920E+04, 3.0069605473E+03, 9.5835616550E-01],
	[3.64050E+04, 2.4968095430E+04, 5.0198339918E+03, 1.0723941068E+04, 3.0074266501E+03, 9.5837475852E-01],
	[3.64100E+04, 2.4973983552E+04, 5.0198442440E+03, 1.0728734699E+04, 3.0078926445E+03, 9.5839334196E-01],
	[3.64150E+04, 2.4979872254E+04, 5.0198544947E+03, 1.0733529812E+04, 3.0083585307E+03, 9.5841191581E-01],
	[3.64200E+04, 2.4985761536E+04, 5.0198647441E+03, 1.0738326408E+04, 3.0088243086E+03, 9.5843048010E-01],
	[3.64250E+04, 2.4991651397E+04, 5.0198749921E+03, 1.0743124488E+04, 3.0092899782E+03, 9.5844903481E-01],
	[3.64300E+04, 2.4997541838E+04, 5.0198852387E+03, 1.0747924051E+04, 3.0097555396E+03, 9.5846757997E-01],
	[3.64350E+04, 2.5003432858E+04, 5.0198954839E+03, 1.0752725097E+04, 3.0102209927E+03, 9.5848611556E-01],
	[3.64400E+04, 2.5009324458E+04, 5.0199057277E+03, 1.0757527628E+04, 3.0106863376E+03, 9.5850464161E-01],
	[3.64450E+04, 2.5015216638E+04, 5.0199159702E+03, 1.0762331643E+04, 3.0111515742E+03, 9.5852315810E-01],
	[3.64500E+04, 2.5021109397E+04, 5.0199262112E+03, 1.0767137142E+04, 3.0116167025E+03, 9.5854166506E-01],
	[3.64550E+04, 2.5027002736E+04, 5.0199364509E+03, 1.0771944126E+04, 3.0120817227E+03, 9.5856016247E-01],
	[3.64600E+04, 2.5032896655E+04, 5.0199466892E+03, 1.0776752594E+04, 3.0125466346E+03, 9.5857865036E-01],
	[3.64650E+04, 2.5038791153E+04, 5.0199569261E+03, 1.0781562548E+04, 3.0130114383E+03, 9.5859712872E-01],
	[3.64700E+04, 2.5044686230E+04, 5.0199671616E+03, 1.0786373988E+04, 3.0134761338E+03, 9.5861559755E-01],
	[3.64750E+04, 2.5050581887E+04, 5.0199773958E+03, 1.0791186913E+04, 3.0139407211E+03, 9.5863405687E-01],
	[3.64800E+04, 2.5056478124E+04, 5.0199876285E+03, 1.0796001324E+04, 3.0144052002E+03, 9.5865250668E-01],
	[3.64850E+04, 2.5062374940E+04, 5.0199978599E+03, 1.0800817222E+04, 3.0148695711E+03, 9.5867094698E-01],
	[3.64900E+04, 2.5068272335E+04, 5.0200080899E+03, 1.0805634605E+04, 3.0153338339E+03, 9.5868937778E-01],
	[3.64950E+04, 2.5074170310E+04, 5.0200183185E+03, 1.0810453476E+04, 3.0157979885E+03, 9.5870779909E-01],
	[3.65000E+04, 2.5080068864E+04, 5.0200285458E+03, 1.0815273834E+04, 3.0162620349E+03, 9.5872621090E-01],
	[3.65050E+04, 2.5085967998E+04, 5.0200387716E+03, 1.0820095678E+04, 3.0167259732E+03, 9.5874461323E-01],
	[3.65100E+04, 2.5091867710E+04, 5.0200489961E+03, 1.0824919011E+04, 3.0171898034E+03, 9.5876300607E-01],
	[3.65150E+04, 2.5097768002E+04, 5.0200592192E+03, 1.0829743831E+04, 3.0176535254E+03, 9.5878138944E-01],
	[3.65200E+04, 2.5103668874E+04, 5.0200694409E+03, 1.0834570139E+04, 3.0181171393E+03, 9.5879976334E-01],
	[3.65250E+04, 2.5109570324E+04, 5.0200796612E+03, 1.0839397935E+04, 3.0185806451E+03, 9.5881812777E-01],
	[3.65300E+04, 2.5115472354E+04, 5.0200898802E+03, 1.0844227220E+04, 3.0190440427E+03, 9.5883648275E-01],
	[3.65350E+04, 2.5121374963E+04, 5.0201000978E+03, 1.0849057994E+04, 3.0195073323E+03, 9.5885482826E-01],
	[3.65400E+04, 2.5127278152E+04, 5.0201103140E+03, 1.0853890256E+04, 3.0199705138E+03, 9.5887316433E-01],
	[3.65450E+04, 2.5133181919E+04, 5.0201205288E+03, 1.0858724008E+04, 3.0204335872E+03, 9.5889149095E-01],
	[3.65500E+04, 2.5139086266E+04, 5.0201307423E+03, 1.0863559249E+04, 3.0208965525E+03, 9.5890980813E-01],
	[3.65550E+04, 2.5144991192E+04, 5.0201409543E+03, 1.0868395981E+04, 3.0213594098E+03, 9.5892811588E-01],
	[3.65600E+04, 2.5150896696E+04, 5.0201511650E+03, 1.0873234202E+04, 3.0218221590E+03, 9.5894641419E-01],
	[3.65650E+04, 2.5156802780E+04, 5.0201613744E+03, 1.0878073913E+04, 3.0222848001E+03, 9.5896470308E-01],
	[3.65700E+04, 2.5162709443E+04, 5.0201715823E+03, 1.0882915115E+04, 3.0227473332E+03, 9.5898298255E-01],
	[3.65750E+04, 2.5168616685E+04, 5.0201817889E+03, 1.0887757808E+04, 3.0232097583E+03, 9.5900125261E-01],
	[3.65800E+04, 2.5174524506E+04, 5.0201919941E+03, 1.0892601992E+04, 3.0236720753E+03, 9.5901951326E-01],
	[3.65850E+04, 2.5180432906E+04, 5.0202021979E+03, 1.0897447667E+04, 3.0241342843E+03, 9.5903776450E-01],
	[3.65900E+04, 2.5186341885E+04, 5.0202124004E+03, 1.0902294834E+04, 3.0245963854E+03, 9.5905600634E-01],
	[3.65950E+04, 2.5192251443E+04, 5.0202226015E+03, 1.0907143493E+04, 3.0250583784E+03, 9.5907423879E-01],
	[3.66000E+04, 2.5198161580E+04, 5.0202328012E+03, 1.0911993644E+04, 3.0255202634E+03, 9.5909246184E-01],
	[3.66050E+04, 2.5204072296E+04, 5.0202429995E+03, 1.0916845287E+04, 3.0259820405E+03, 9.5911067552E-01],
	[3.66100E+04, 2.5209983590E+04, 5.0202531965E+03, 1.0921698422E+04, 3.0264437095E+03, 9.5912887981E-01],
	[3.66150E+04, 2.5215895464E+04, 5.0202633920E+03, 1.0926553051E+04, 3.0269052706E+03, 9.5914707473E-01],
	[3.66200E+04, 2.5221807916E+04, 5.0202735863E+03, 1.0931409172E+04, 3.0273667238E+03, 9.5916526028E-01],
	[3.66250E+04, 2.5227720947E+04, 5.0202837791E+03, 1.0936266787E+04, 3.0278280690E+03, 9.5918343647E-01],
	[3.66300E+04, 2.5233634557E+04, 5.0202939706E+03, 1.0941125896E+04, 3.0282893062E+03, 9.5920160329E-01],
	[3.66350E+04, 2.5239548746E+04, 5.0203041607E+03, 1.0945986498E+04, 3.0287504356E+03, 9.5921976077E-01],
	[3.66400E+04, 2.5245463513E+04, 5.0203143494E+03, 1.0950848594E+04, 3.0292114570E+03, 9.5923790889E-01],
	[3.66450E+04, 2.5251378860E+04, 5.0203245368E+03, 1.0955712185E+04, 3.0296723705E+03, 9.5925604767E-01],
	[3.66500E+04, 2.5257294784E+04, 5.0203347228E+03, 1.0960577271E+04, 3.0301331760E+03, 9.5927417712E-01],
	[3.66550E+04, 2.5263211288E+04, 5.0203449074E+03, 1.0965443851E+04, 3.0305938737E+03, 9.5929229722E-01],
	[3.66600E+04, 2.5269128370E+04, 5.0203550907E+03, 1.0970311927E+04, 3.0310544635E+03, 9.5931040800E-01],
	[3.66650E+04, 2.5275046031E+04, 5.0203652726E+03, 1.0975181497E+04, 3.0315149454E+03, 9.5932850946E-01],
	[3.66700E+04, 2.5280964270E+04, 5.0203754531E+03, 1.0980052564E+04, 3.0319753195E+03, 9.5934660160E-01],
	[3.66750E+04, 2.5286883088E+04, 5.0203856322E+03, 1.0984925126E+04, 3.0324355857E+03, 9.5936468442E-01],
	[3.66800E+04, 2.5292802485E+04, 5.0203958100E+03, 1.0989799185E+04, 3.0328957440E+03, 9.5938275794E-01],
	[3.66850E+04, 2.5298722460E+04, 5.0204059865E+03, 1.0994674740E+04, 3.0333557945E+03, 9.5940082215E-01],
	[3.66900E+04, 2.5304643014E+04, 5.0204161615E+03, 1.0999551791E+04, 3.0338157371E+03, 9.5941887706E-01],
	[3.66950E+04, 2.5310564146E+04, 5.0204263352E+03, 1.1004430340E+04, 3.0342755720E+03, 9.5943692268E-01],
	[3.67000E+04, 2.5316485857E+04, 5.0204365075E+03, 1.1009310385E+04, 3.0347352990E+03, 9.5945495902E-01],
	[3.67050E+04, 2.5322408146E+04, 5.0204466785E+03, 1.1014191929E+04, 3.0351949182E+03, 9.5947298607E-01],
	[3.67100E+04, 2.5328331013E+04, 5.0204568481E+03, 1.1019074969E+04, 3.0356544296E+03, 9.5949100384E-01],
	[3.67150E+04, 2.5334254459E+04, 5.0204670163E+03, 1.1023959508E+04, 3.0361138332E+03, 9.5950901234E-01],
	[3.67200E+04, 2.5340178484E+04, 5.0204771832E+03, 1.1028845545E+04, 3.0365731290E+03, 9.5952701157E-01],
	[3.67250E+04, 2.5346103086E+04, 5.0204873487E+03, 1.1033733080E+04, 3.0370323170E+03, 9.5954500154E-01],
	[3.67300E+04, 2.5352028267E+04, 5.0204975128E+03, 1.1038622114E+04, 3.0374913973E+03, 9.5956298224E-01],
	[3.67350E+04, 2.5357954027E+04, 5.0205076756E+03, 1.1043512647E+04, 3.0379503699E+03, 9.5958095370E-01],
	[3.67400E+04, 2.5363880364E+04, 5.0205178370E+03, 1.1048404679E+04, 3.0384092346E+03, 9.5959891591E-01],
	[3.67450E+04, 2.5369807280E+04, 5.0205279971E+03, 1.1053298211E+04, 3.0388679917E+03, 9.5961686888E-01],
	[3.67500E+04, 2.5375734774E+04, 5.0205381557E+03, 1.1058193242E+04, 3.0393266410E+03, 9.5963481261E-01],
	[3.67550E+04, 2.5381662847E+04, 5.0205483131E+03, 1.1063089774E+04, 3.0397851826E+03, 9.5965274710E-01],
	[3.67600E+04, 2.5387591497E+04, 5.0205584690E+03, 1.1067987805E+04, 3.0402436165E+03, 9.5967067237E-01],
	[3.67650E+04, 2.5393520726E+04, 5.0205686236E+03, 1.1072887337E+04, 3.0407019427E+03, 9.5968858842E-01],
	[3.67700E+04, 2.5399450533E+04, 5.0205787769E+03, 1.1077788370E+04, 3.0411601612E+03, 9.5970649524E-01],
	[3.67750E+04, 2.5405380918E+04, 5.0205889288E+03, 1.1082690904E+04, 3.0416182720E+03, 9.5972439286E-01],
	[3.67800E+04, 2.5411311882E+04, 5.0205990793E+03, 1.1087594939E+04, 3.0420762751E+03, 9.5974228127E-01],
	[3.67850E+04, 2.5417243423E+04, 5.0206092285E+03, 1.1092500475E+04, 3.0425341706E+03, 9.5976016047E-01],
	[3.67900E+04, 2.5423175542E+04, 5.0206193763E+03, 1.1097407514E+04, 3.0429919584E+03, 9.5977803048E-01],
	[3.67950E+04, 2.5429108240E+04, 5.0206295227E+03, 1.1102316054E+04, 3.0434496386E+03, 9.5979589130E-01],
	[3.68000E+04, 2.5435041515E+04, 5.0206396678E+03, 1.1107226096E+04, 3.0439072111E+03, 9.5981374292E-01],
	[3.68050E+04, 2.5440975369E+04, 5.0206498116E+03, 1.1112137641E+04, 3.0443646760E+03, 9.5983158537E-01],
	[3.68100E+04, 2.5446909800E+04, 5.0206599539E+03, 1.1117050689E+04, 3.0448220333E+03, 9.5984941864E-01],
	[3.68150E+04, 2.5452844810E+04, 5.0206700949E+03, 1.1121965240E+04, 3.0452792830E+03, 9.5986724274E-01],
	[3.68200E+04, 2.5458780397E+04, 5.0206802346E+03, 1.1126881294E+04, 3.0457364250E+03, 9.5988505766E-01],
	[3.68250E+04, 2.5464716562E+04, 5.0206903729E+03, 1.1131798852E+04, 3.0461934595E+03, 9.5990286343E-01],
	[3.68300E+04, 2.5470653306E+04, 5.0207005099E+03, 1.1136717913E+04, 3.0466503864E+03, 9.5992066004E-01],
	[3.68350E+04, 2.5476590627E+04, 5.0207106455E+03, 1.1141638479E+04, 3.0471072058E+03, 9.5993844750E-01],
	[3.68400E+04, 2.5482528526E+04, 5.0207207797E+03, 1.1146560549E+04, 3.0475639175E+03, 9.5995622581E-01],
	[3.68450E+04, 2.5488467002E+04, 5.0207309126E+03, 1.1151484123E+04, 3.0480205217E+03, 9.5997399498E-01],
	[3.68500E+04, 2.5494406057E+04, 5.0207410441E+03, 1.1156409202E+04, 3.0484770184E+03, 9.5999175501E-01],
	[3.68550E+04, 2.5500345689E+04, 5.0207511743E+03, 1.1161335787E+04, 3.0489334076E+03, 9.6000950591E-01],
	[3.68600E+04, 2.5506285900E+04, 5.0207613031E+03, 1.1166263876E+04, 3.0493896892E+03, 9.6002724768E-01],
	[3.68650E+04, 2.5512226687E+04, 5.0207714306E+03, 1.1171193471E+04, 3.0498458633E+03, 9.6004498033E-01],
	[3.68700E+04, 2.5518168053E+04, 5.0207815567E+03, 1.1176124572E+04, 3.0503019299E+03, 9.6006270386E-01],
	[3.68750E+04, 2.5524109996E+04, 5.0207916815E+03, 1.1181057179E+04, 3.0507578890E+03, 9.6008041828E-01],
	[3.68800E+04, 2.5530052517E+04, 5.0208018049E+03, 1.1185991293E+04, 3.0512137406E+03, 9.6009812359E-01],
	[3.68850E+04, 2.5535995616E+04, 5.0208119269E+03, 1.1190926913E+04, 3.0516694847E+03, 9.6011581980E-01],
	[3.68900E+04, 2.5541939292E+04, 5.0208220476E+03, 1.1195864040E+04, 3.0521251214E+03, 9.6013350692E-01],
	[3.68950E+04, 2.5547883546E+04, 5.0208321670E+03, 1.1200802674E+04, 3.0525806506E+03, 9.6015118494E-01],
	[3.69000E+04, 2.5553828378E+04, 5.0208422850E+03, 1.1205742815E+04, 3.0530360723E+03, 9.6016885387E-01],
	[3.69050E+04, 2.5559773787E+04, 5.0208524016E+03, 1.1210684464E+04, 3.0534913867E+03, 9.6018651372E-01],
	[3.69100E+04, 2.5565719773E+04, 5.0208625169E+03, 1.1215627621E+04, 3.0539465936E+03, 9.6020416450E-01],
	[3.69150E+04, 2.5571666337E+04, 5.0208726309E+03, 1.1220572286E+04, 3.0544016930E+03, 9.6022180620E-01],
	[3.69200E+04, 2.5577613479E+04, 5.0208827435E+03, 1.1225518459E+04, 3.0548566851E+03, 9.6023943884E-01],
	[3.69250E+04, 2.5583561198E+04, 5.0208928548E+03, 1.1230466141E+04, 3.0553115698E+03, 9.6025706241E-01],
	[3.69300E+04, 2.5589509494E+04, 5.0209029647E+03, 1.1235415332E+04, 3.0557663470E+03, 9.6027467693E-01],
	[3.69350E+04, 2.5595458368E+04, 5.0209130732E+03, 1.1240366032E+04, 3.0562210169E+03, 9.6029228239E-01],
	[3.69400E+04, 2.5601407820E+04, 5.0209231804E+03, 1.1245318242E+04, 3.0566755794E+03, 9.6030987881E-01],
	[3.69450E+04, 2.5607357848E+04, 5.0209332863E+03, 1.1250271961E+04, 3.0571300346E+03, 9.6032746619E-01],
	[3.69500E+04, 2.5613308455E+04, 5.0209433908E+03, 1.1255227190E+04, 3.0575843824E+03, 9.6034504453E-01],
	[3.69550E+04, 2.5619259638E+04, 5.0209534940E+03, 1.1260183929E+04, 3.0580386229E+03, 9.6036261383E-01],
	[3.69600E+04, 2.5625211399E+04, 5.0209635958E+03, 1.1265142179E+04, 3.0584927560E+03, 9.6038017411E-01],
	[3.69650E+04, 2.5631163737E+04, 5.0209736963E+03, 1.1270101939E+04, 3.0589467818E+03, 9.6039772537E-01],
	[3.69700E+04, 2.5637116652E+04, 5.0209837954E+03, 1.1275063210E+04, 3.0594007003E+03, 9.6041526761E-01],
	[3.69750E+04, 2.5643070145E+04, 5.0209938932E+03, 1.1280025993E+04, 3.0598545115E+03, 9.6043280083E-01],
	[3.69800E+04, 2.5649024215E+04, 5.0210039896E+03, 1.1284990286E+04, 3.0603082154E+03, 9.6045032505E-01],
	[3.69850E+04, 2.5654978862E+04, 5.0210140847E+03, 1.1289956092E+04, 3.0607618121E+03, 9.6046784027E-01],
	[3.69900E+04, 2.5660934086E+04, 5.0210241785E+03, 1.1294923410E+04, 3.0612153014E+03, 9.6048534649E-01],
	[3.69950E+04, 2.5666889888E+04, 5.0210342709E+03, 1.1299892239E+04, 3.0616686835E+03, 9.6050284372E-01],
	[3.70000E+04, 2.5672846266E+04, 5.0210443619E+03, 1.1304862581E+04, 3.0621219584E+03, 9.6052033196E-01],
	[3.70050E+04, 2.5678803222E+04, 5.0210544517E+03, 1.1309834436E+04, 3.0625751260E+03, 9.6053781122E-01],
	[3.70100E+04, 2.5684760755E+04, 5.0210645400E+03, 1.1314807804E+04, 3.0630281863E+03, 9.6055528150E-01],
	[3.70150E+04, 2.5690718864E+04, 5.0210746271E+03, 1.1319782685E+04, 3.0634811395E+03, 9.6057274281E-01],
	[3.70200E+04, 2.5696677551E+04, 5.0210847128E+03, 1.1324759080E+04, 3.0639339854E+03, 9.6059019515E-01],
	[3.70250E+04, 2.5702636815E+04, 5.0210947971E+03, 1.1329736988E+04, 3.0643867241E+03, 9.6060763853E-01],
	[3.70300E+04, 2.5708596656E+04, 5.0211048801E+03, 1.1334716411E+04, 3.0648393557E+03, 9.6062507295E-01],
	[3.70350E+04, 2.5714557074E+04, 5.0211149618E+03, 1.1339697347E+04, 3.0652918800E+03, 9.6064249842E-01],
	[3.70400E+04, 2.5720518069E+04, 5.0211250421E+03, 1.1344679799E+04, 3.0657442972E+03, 9.6065991494E-01],
	[3.70450E+04, 2.5726479641E+04, 5.0211351211E+03, 1.1349663764E+04, 3.0661966072E+03, 9.6067732252E-01],
	[3.70500E+04, 2.5732441790E+04, 5.0211451987E+03, 1.1354649245E+04, 3.0666488101E+03, 9.6069472116E-01],
	[3.70550E+04, 2.5738404516E+04, 5.0211552751E+03, 1.1359636242E+04, 3.0671009058E+03, 9.6071211086E-01],
	[3.70600E+04, 2.5744367818E+04, 5.0211653500E+03, 1.1364624753E+04, 3.0675528944E+03, 9.6072949164E-01],
	[3.70650E+04, 2.5750331698E+04, 5.0211754236E+03, 1.1369614781E+04, 3.0680047759E+03, 9.6074686350E-01],
	[3.70700E+04, 2.5756296154E+04, 5.0211854959E+03, 1.1374606324E+04, 3.0684565503E+03, 9.6076422644E-01],
	[3.70750E+04, 2.5762261187E+04, 5.0211955669E+03, 1.1379599384E+04, 3.0689082175E+03, 9.6078158047E-01],
	[3.70800E+04, 2.5768226797E+04, 5.0212056365E+03, 1.1384593961E+04, 3.0693597777E+03, 9.6079892558E-01],
	[3.70850E+04, 2.5774192984E+04, 5.0212157048E+03, 1.1389590054E+04, 3.0698112308E+03, 9.6081626180E-01],
	[3.70900E+04, 2.5780159747E+04, 5.0212257717E+03, 1.1394587664E+04, 3.0702625768E+03, 9.6083358911E-01],
	[3.70950E+04, 2.5786127087E+04, 5.0212358373E+03, 1.1399586792E+04, 3.0707138158E+03, 9.6085090754E-01],
	[3.71000E+04, 2.5792095004E+04, 5.0212459016E+03, 1.1404587437E+04, 3.0711649477E+03, 9.6086821707E-01],
	[3.71050E+04, 2.5798063498E+04, 5.0212559645E+03, 1.1409589600E+04, 3.0716159726E+03, 9.6088551773E-01],
	[3.71100E+04, 2.5804032568E+04, 5.0212660261E+03, 1.1414593281E+04, 3.0720668904E+03, 9.6090280950E-01],
	[3.71150E+04, 2.5810002215E+04, 5.0212760864E+03, 1.1419598480E+04, 3.0725177013E+03, 9.6092009240E-01],
	[3.71200E+04, 2.5815972438E+04, 5.0212861453E+03, 1.1424605198E+04, 3.0729684051E+03, 9.6093736643E-01],
	[3.71250E+04, 2.5821962934E+04, 5.0212996348E+03, 1.1429613435E+04, 3.0734205667E+03, 9.6095463160E-01],
	[3.71300E+04, 2.5827971445E+04, 5.0213161591E+03, 1.1434623191E+04, 3.0738740067E+03, 9.6097188791E-01],
	[3.71350E+04, 2.5833980545E+04, 5.0213326813E+03, 1.1439634466E+04, 3.0743273409E+03, 9.6098913537E-01],
	[3.71400E+04, 2.5839990234E+04, 5.0213492013E+03, 1.1444647261E+04, 3.0747805691E+03, 9.6100637397E-01],
	[3.71450E+04, 2.5846000511E+04, 5.0213657191E+03, 1.1449661576E+04, 3.0752336915E+03, 9.6102360374E-01],
	[3.71500E+04, 2.5852011377E+04, 5.0213822348E+03, 1.1454677411E+04, 3.0756867080E+03, 9.6104082466E-01],
	[3.71550E+04, 2.5858022831E+04, 5.0213987483E+03, 1.1459694766E+04, 3.0761396187E+03, 9.6105803675E-01],
	[3.71600E+04, 2.5864034875E+04, 5.0214152596E+03, 1.1464713642E+04, 3.0765924235E+03, 9.6107524002E-01],
	[3.71650E+04, 2.5870047507E+04, 5.0214317687E+03, 1.1469734039E+04, 3.0770451225E+03, 9.6109243445E-01],
	[3.71700E+04, 2.5876060727E+04, 5.0214482757E+03, 1.1474755957E+04, 3.0774977156E+03, 9.6110962007E-01],
	[3.71750E+04, 2.5882074536E+04, 5.0214647805E+03, 1.1479779397E+04, 3.0779502029E+03, 9.6112679688E-01],
	[3.71800E+04, 2.5888088934E+04, 5.0214812832E+03, 1.1484804358E+04, 3.0784025845E+03, 9.6114396487E-01],
	[3.71850E+04, 2.5894103920E+04, 5.0214977837E+03, 1.1489830841E+04, 3.0788548602E+03, 9.6116112406E-01],
	[3.71900E+04, 2.5900119495E+04, 5.0215142820E+03, 1.1494858846E+04, 3.0793070302E+03, 9.6117827445E-01],
	[3.71950E+04, 2.5906135659E+04, 5.0215307782E+03, 1.1499888373E+04, 3.0797590943E+03, 9.6119541605E-01],
	[3.72000E+04, 2.5912152411E+04, 5.0215472722E+03, 1.1504919424E+04, 3.0802110527E+03, 9.6121254886E-01],
	[3.72050E+04, 2.5918169751E+04, 5.0215637640E+03, 1.1509951997E+04, 3.0806629054E+03, 9.6122967288E-01],
	[3.72100E+04, 2.5924187680E+04, 5.0215802537E+03, 1.1514986093E+04, 3.0811146523E+03, 9.6124678812E-01],
	[3.72150E+04, 2.5930206197E+04, 5.0215967412E+03, 1.1520021713E+04, 3.0815662935E+03, 9.6126389459E-01],
	[3.72200E+04, 2.5936225302E+04, 5.0216132265E+03, 1.1525058857E+04, 3.0820178290E+03, 9.6128099229E-01],
	[3.72250E+04, 2.5942244996E+04, 5.0216297097E+03, 1.1530097524E+04, 3.0824692587E+03, 9.6129808122E-01],
	[3.72300E+04, 2.5948265279E+04, 5.0216461907E+03, 1.1535137716E+04, 3.0829205827E+03, 9.6131516139E-01],
	[3.72350E+04, 2.5954286149E+04, 5.0216626696E+03, 1.1540179432E+04, 3.0833718011E+03, 9.6133223281E-01],
	[3.72400E+04, 2.5960307608E+04, 5.0216791463E+03, 1.1545222673E+04, 3.0838229137E+03, 9.6134929548E-01],
	[3.72450E+04, 2.5966329656E+04, 5.0216956209E+03, 1.1550267439E+04, 3.0842739207E+03, 9.6136634940E-01],
	[3.72500E+04, 2.5972352291E+04, 5.0217120933E+03, 1.1555313730E+04, 3.0847248221E+03, 9.6138339458E-01],
	[3.72550E+04, 2.5978375515E+04, 5.0217285635E+03, 1.1560361547E+04, 3.0851756177E+03, 9.6140043102E-01],
	[3.72600E+04, 2.5984399327E+04, 5.0217450316E+03, 1.1565410889E+04, 3.0856263078E+03, 9.6141745873E-01],
	[3.72650E+04, 2.5990423728E+04, 5.0217614975E+03, 1.1570461758E+04, 3.0860768922E+03, 9.6143447772E-01],
	[3.72700E+04, 2.5996448716E+04, 5.0217779613E+03, 1.1575514152E+04, 3.0865273710E+03, 9.6145148799E-01],
	[3.72750E+04, 2.6002474293E+04, 5.0217944229E+03, 1.1580568073E+04, 3.0869777441E+03, 9.6146848954E-01],
	[3.72800E+04, 2.6008500458E+04, 5.0218108824E+03, 1.1585623521E+04, 3.0874280117E+03, 9.6148548238E-01],
	[3.72850E+04, 2.6014527211E+04, 5.0218273397E+03, 1.1590680496E+04, 3.0878781737E+03, 9.6150246651E-01],
	[3.72900E+04, 2.6020554552E+04, 5.0218437949E+03, 1.1595738999E+04, 3.0883282301E+03, 9.6151944194E-01],
	[3.72950E+04, 2.6026582481E+04, 5.0218602479E+03, 1.1600799028E+04, 3.0887781810E+03, 9.6153640868E-01],
	[3.73000E+04, 2.6032610998E+04, 5.0218766987E+03, 1.1605860586E+04, 3.0892280262E+03, 9.6155336672E-01],
	[3.73050E+04, 2.6038640103E+04, 5.0218931474E+03, 1.1610923672E+04, 3.0896777660E+03, 9.6157031608E-01],
	[3.73100E+04, 2.6044669796E+04, 5.0219095940E+03, 1.1615988286E+04, 3.0901274002E+03, 9.6158725675E-01],
	[3.73150E+04, 2.6050700078E+04, 5.0219260384E+03, 1.1621054428E+04, 3.0905769289E+03, 9.6160418875E-01],
	[3.73200E+04, 2.6056730947E+04, 5.0219424806E+03, 1.1626122100E+04, 3.0910263520E+03, 9.6162111207E-01],
	[3.73250E+04, 2.6062762404E+04, 5.0219589207E+03, 1.1631191300E+04, 3.0914756697E+03, 9.6163802673E-01],
	[3.73300E+04, 2.6068794449E+04, 5.0219753587E+03, 1.1636262030E+04, 3.0919248818E+03, 9.6165493273E-01],
	[3.73350E+04, 2.6074827082E+04, 5.0219917945E+03, 1.1641334289E+04, 3.0923739885E+03, 9.6167183006E-01],
	[3.73400E+04, 2.6080860303E+04, 5.0220082281E+03, 1.1646408078E+04, 3.0928229897E+03, 9.6168871875E-01],
	[3.73450E+04, 2.6086894112E+04, 5.0220246597E+03, 1.1651483398E+04, 3.0932718855E+03, 9.6170559878E-01],
	[3.73500E+04, 2.6092928509E+04, 5.0220410890E+03, 1.1656560247E+04, 3.0937206757E+03, 9.6172247018E-01],
	[3.73550E+04, 2.6098963493E+04, 5.0220575163E+03, 1.1661638627E+04, 3.0941693606E+03, 9.6173933293E-01],
	[3.73600E+04, 2.6104999066E+04, 5.0220739413E+03, 1.1666718539E+04, 3.0946179400E+03, 9.6175618705E-01],
	[3.73650E+04, 2.6111035226E+04, 5.0220903643E+03, 1.1671799981E+04, 3.0950664140E+03, 9.6177303255E-01],
	[3.73700E+04, 2.6117071973E+04, 5.0221067850E+03, 1.1676882954E+04, 3.0955147826E+03, 9.6178986942E-01],
	[3.73750E+04, 2.6123109309E+04, 5.0221232037E+03, 1.1681967460E+04, 3.0959630458E+03, 9.6180669767E-01],
	[3.73800E+04, 2.6129147232E+04, 5.0221396202E+03, 1.1687053497E+04, 3.0964112036E+03, 9.6182351731E-01],
	[3.73850E+04, 2.6135185743E+04, 5.0221560346E+03, 1.1692141066E+04, 3.0968592561E+03, 9.6184032834E-01],
	[3.73900E+04, 2.6141224842E+04, 5.0221724468E+03, 1.1697230168E+04, 3.0973072031E+03, 9.6185713076E-01],
	[3.73950E+04, 2.6147264528E+04, 5.0221888569E+03, 1.1702320802E+04, 3.0977550448E+03, 9.6187392458E-01],
	[3.74000E+04, 2.6153304802E+04, 5.0222052648E+03, 1.1707412969E+04, 3.0982027812E+03, 9.6189070981E-01],
	[3.74050E+04, 2.6159345664E+04, 5.0222216706E+03, 1.1712506670E+04, 3.0986504123E+03, 9.6190748646E-01],
	[3.74100E+04, 2.6165387113E+04, 5.0222380743E+03, 1.1717601903E+04, 3.0990979380E+03, 9.6192425451E-01],
	[3.74150E+04, 2.6171429150E+04, 5.0222544758E+03, 1.1722698671E+04, 3.0995453584E+03, 9.6194101399E-01],
	[3.74200E+04, 2.6177471774E+04, 5.0222708752E+03, 1.1727796972E+04, 3.0999926735E+03, 9.6195776489E-01],
	[3.74250E+04, 2.6183514986E+04, 5.0222872724E+03, 1.1732896808E+04, 3.1004398833E+03, 9.6197450722E-01],
	[3.74300E+04, 2.6189558785E+04, 5.0223036675E+03, 1.1737998178E+04, 3.1008869878E+03, 9.6199124098E-01],
	[3.74350E+04, 2.6195603172E+04, 5.0223200605E+03, 1.1743101083E+04, 3.1013339871E+03, 9.6200796619E-01],
	[3.74400E+04, 2.6201648146E+04, 5.0223364513E+03, 1.1748205523E+04, 3.1017808811E+03, 9.6202468284E-01],
	[3.74450E+04, 2.6207693708E+04, 5.0223528400E+03, 1.1753311498E+04, 3.1022276699E+03, 9.6204139094E-01],
	[3.74500E+04, 2.6213739857E+04, 5.0223692266E+03, 1.1758419008E+04, 3.1026743534E+03, 9.6205809049E-01],
	[3.74550E+04, 2.6219786594E+04, 5.0223856110E+03, 1.1763528054E+04, 3.1031209318E+03, 9.6207478150E-01],
	[3.74600E+04, 2.6225833918E+04, 5.0224019933E+03, 1.1768638636E+04, 3.1035674049E+03, 9.6209146397E-01],
	[3.74650E+04, 2.6231881829E+04, 5.0224183735E+03, 1.1773750755E+04, 3.1040137728E+03, 9.6210813791E-01],
	[3.74700E+04, 2.6237930327E+04, 5.0224347515E+03, 1.1778864410E+04, 3.1044600355E+03, 9.6212480333E-01],
	[3.74750E+04, 2.6243979413E+04, 5.0224511274E+03, 1.1783979601E+04, 3.1049061930E+03, 9.6214146022E-01],
	[3.74800E+04, 2.6250029087E+04, 5.0224675012E+03, 1.1789096330E+04, 3.1053522454E+03, 9.6215810860E-01],
	[3.74850E+04, 2.6256079347E+04, 5.0224838728E+03, 1.1794214596E+04, 3.1057981926E+03, 9.6217474846E-01],
	[3.74900E+04, 2.6262130195E+04, 5.0225002423E+03, 1.1799334399E+04, 3.1062440346E+03, 9.6219137982E-01],
	[3.74950E+04, 2.6268181630E+04, 5.0225166097E+03, 1.1804455741E+04, 3.1066897716E+03, 9.6220800267E-01],
	[3.75000E+04, 2.6274233652E+04, 5.0225329749E+03, 1.1809578620E+04, 3.1071354034E+03, 9.6222461703E-01],
	[3.75050E+04, 2.6280286261E+04, 5.0225493381E+03, 1.1814703037E+04, 3.1075809301E+03, 9.6224122289E-01],
	[3.75100E+04, 2.6286339458E+04, 5.0225656991E+03, 1.1819828993E+04, 3.1080263517E+03, 9.6225782027E-01],
	[3.75150E+04, 2.6292393242E+04, 5.0225820579E+03, 1.1824956488E+04, 3.1084716682E+03, 9.6227440916E-01],
	[3.75200E+04, 2.6298447612E+04, 5.0225984147E+03, 1.1830085522E+04, 3.1089168796E+03, 9.6229098957E-01],
	[3.75250E+04, 2.6304502570E+04, 5.0226147693E+03, 1.1835216096E+04, 3.1093619860E+03, 9.6230756151E-01],
	[3.75300E+04, 2.6310558115E+04, 5.0226311217E+03, 1.1840348208E+04, 3.1098069873E+03, 9.6232412498E-01],
	[3.75350E+04, 2.6316614247E+04, 5.0226474721E+03, 1.1845481861E+04, 3.1102518835E+03, 9.6234067998E-01],
	[3.75400E+04, 2.6322670966E+04, 5.0226638203E+03, 1.1850617054E+04, 3.1106966748E+03, 9.6235722653E-01],
	[3.75450E+04, 2.6328728272E+04, 5.0226801665E+03, 1.1855753787E+04, 3.1111413610E+03, 9.6237376462E-01],
	[3.75500E+04, 2.6334786165E+04, 5.0226965104E+03, 1.1860892060E+04, 3.1115859422E+03, 9.6239029426E-01],
	[3.75550E+04, 2.6340844645E+04, 5.0227128523E+03, 1.1866031875E+04, 3.1120304184E+03, 9.6240681546E-01],
	[3.75600E+04, 2.6346903712E+04, 5.0227291921E+03, 1.1871173230E+04, 3.1124747896E+03, 9.6242332821E-01],
	[3.75650E+04, 2.6352963366E+04, 5.0227455297E+03, 1.1876316127E+04, 3.1129190558E+03, 9.6243983253E-01],
	[3.75700E+04, 2.6359023607E+04, 5.0227618652E+03, 1.1881460566E+04, 3.1133632171E+03, 9.6245632842E-01],
	[3.75750E+04, 2.6365084435E+04, 5.0227781985E+03, 1.1886606546E+04, 3.1138072734E+03, 9.6247281589E-01],
	[3.75800E+04, 2.6371145850E+04, 5.0227945298E+03, 1.1891754069E+04, 3.1142512248E+03, 9.6248929493E-01],
	[3.75850E+04, 2.6377207851E+04, 5.0228108589E+03, 1.1896903134E+04, 3.1146950712E+03, 9.6250576556E-01],
	[3.75900E+04, 2.6383270439E+04, 5.0228271860E+03, 1.1902053742E+04, 3.1151388127E+03, 9.6252222777E-01],
	[3.75950E+04, 2.6389333614E+04, 5.0228435109E+03, 1.1907205892E+04, 3.1155824493E+03, 9.6253868158E-01],
	[3.76000E+04, 2.6395397376E+04, 5.0228598337E+03, 1.1912359586E+04, 3.1160259811E+03, 9.6255512698E-01],
	[3.76050E+04, 2.6401461725E+04, 5.0228761543E+03, 1.1917514823E+04, 3.1164694079E+03, 9.6257156399E-01],
	[3.76100E+04, 2.6407526660E+04, 5.0228924729E+03, 1.1922671604E+04, 3.1169127299E+03, 9.6258799261E-01],
	[3.76150E+04, 2.6413592182E+04, 5.0229087893E+03, 1.1927829928E+04, 3.1173559470E+03, 9.6260441284E-01],
	[3.76200E+04, 2.6419658291E+04, 5.0229251036E+03, 1.1932989797E+04, 3.1177990592E+03, 9.6262082468E-01],
	[3.76250E+04, 2.6425724986E+04, 5.0229414158E+03, 1.1938151210E+04, 3.1182420666E+03, 9.6263722815E-01],
	[3.76300E+04, 2.6431792268E+04, 5.0229577259E+03, 1.1943314168E+04, 3.1186849692E+03, 9.6265362324E-01],
	[3.76350E+04, 2.6437860137E+04, 5.0229740339E+03, 1.1948478671E+04, 3.1191277670E+03, 9.6267000997E-01],
	[3.76400E+04, 2.6443928593E+04, 5.0229903397E+03, 1.1953644720E+04, 3.1195704600E+03, 9.6268638833E-01],
	[3.76450E+04, 2.6449997634E+04, 5.0230066435E+03, 1.1958812313E+04, 3.1200130481E+03, 9.6270275833E-01],
	[3.76500E+04, 2.6456067263E+04, 5.0230229451E+03, 1.1963981452E+04, 3.1204555315E+03, 9.6271911998E-01],
	[3.76550E+04, 2.6462137478E+04, 5.0230392446E+03, 1.1969152138E+04, 3.1208979102E+03, 9.6273547328E-01],
	[3.76600E+04, 2.6468208280E+04, 5.0230555421E+03, 1.1974324369E+04, 3.1213401840E+03, 9.6275181823E-01],
	[3.76650E+04, 2.6474279668E+04, 5.0230718374E+03, 1.1979498147E+04, 3.1217823532E+03, 9.6276815484E-01],
	[3.76700E+04, 2.6480351642E+04, 5.0230881305E+03, 1.1984673472E+04, 3.1222244176E+03, 9.6278448312E-01],
	[3.76750E+04, 2.6486424203E+04, 5.0231044216E+03, 1.1989850344E+04, 3.1226663772E+03, 9.6280080307E-01],
	[3.76800E+04, 2.6492497351E+04, 5.0231207106E+03, 1.1995028763E+04, 3.1231082322E+03, 9.6281711469E-01],
	[3.76850E+04, 2.6498571085E+04, 5.0231369975E+03, 1.2000208729E+04, 3.1235499825E+03, 9.6283341799E-01],
	[3.76900E+04, 2.6504645405E+04, 5.0231532822E+03, 1.2005390244E+04, 3.1239916280E+03, 9.6284971298E-01],
	[3.76950E+04, 2.6510720311E+04, 5.0231695649E+03, 1.2010573306E+04, 3.1244331689E+03, 9.6286599965E-01],
	[3.77000E+04, 2.6516795805E+04, 5.0231858454E+03, 1.2015757916E+04, 3.1248746052E+03, 9.6288227801E-01],
	[3.77050E+04, 2.6522871884E+04, 5.0232021238E+03, 1.2020944076E+04, 3.1253159368E+03, 9.6289854808E-01],
	[3.77100E+04, 2.6528948550E+04, 5.0232184002E+03, 1.2026131784E+04, 3.1257571637E+03, 9.6291480984E-01],
	[3.77150E+04, 2.6535025801E+04, 5.0232346744E+03, 1.2031321041E+04, 3.1261982860E+03, 9.6293106332E-01],
	[3.77200E+04, 2.6541103640E+04, 5.0232509465E+03, 1.2036511847E+04, 3.1266393038E+03, 9.6294730850E-01],
	[3.77250E+04, 2.6547182064E+04, 5.0232672165E+03, 1.2041704203E+04, 3.1270802169E+03, 9.6296354541E-01],
	[3.77300E+04, 2.6553261075E+04, 5.0232834844E+03, 1.2046898108E+04, 3.1275210254E+03, 9.6297977403E-01],
	[3.77350E+04, 2.6559340672E+04, 5.0232997502E+03, 1.2052093564E+04, 3.1279617293E+03, 9.6299599440E-01],
	[3.77400E+04, 2.6565420855E+04, 5.0233160139E+03, 1.2057290570E+04, 3.1284023287E+03, 9.6301220652E-01],
	[3.77450E+04, 2.6571501624E+04, 5.0233322755E+03, 1.2062489127E+04, 3.1288428235E+03, 9.6302841039E-01],
	[3.77500E+04, 2.6577582980E+04, 5.0233485350E+03, 1.2067689234E+04, 3.1292832137E+03, 9.6304460601E-01],
	[3.77550E+04, 2.6583664921E+04, 5.0233647924E+03, 1.2072890893E+04, 3.1297234995E+03, 9.6306079340E-01],
	[3.77600E+04, 2.6589747449E+04, 5.0233810477E+03, 1.2078094103E+04, 3.1301636807E+03, 9.6307697255E-01],
	[3.77650E+04, 2.6595830563E+04, 5.0233973009E+03, 1.2083298864E+04, 3.1306037574E+03, 9.6309314347E-01],
	[3.77700E+04, 2.6601914262E+04, 5.0234135521E+03, 1.2088505178E+04, 3.1310437296E+03, 9.6310930616E-01],
	[3.77750E+04, 2.6607998548E+04, 5.0234298011E+03, 1.2093713043E+04, 3.1314835973E+03, 9.6312546063E-01],
	[3.77800E+04, 2.6614083420E+04, 5.0234460480E+03, 1.2098922461E+04, 3.1319233606E+03, 9.6314160689E-01],
	[3.77850E+04, 2.6620168878E+04, 5.0234622928E+03, 1.2104133432E+04, 3.1323630194E+03, 9.6315774493E-01],
	[3.77900E+04, 2.6626254922E+04, 5.0234785355E+03, 1.2109345956E+04, 3.1328025737E+03, 9.6317387476E-01],
	[3.77950E+04, 2.6632341552E+04, 5.0234947761E+03, 1.2114560032E+04, 3.1332420236E+03, 9.6318999638E-01],
	[3.78000E+04, 2.6638428767E+04, 5.0235110146E+03, 1.2119775662E+04, 3.1336813691E+03, 9.6320610981E-01],
	[3.78050E+04, 2.6644516569E+04, 5.0235272510E+03, 1.2124992846E+04, 3.1341206102E+03, 9.6322221503E-01],
	[3.78100E+04, 2.6650604956E+04, 5.0235434854E+03, 1.2130211584E+04, 3.1345597469E+03, 9.6323831207E-01],
	[3.78150E+04, 2.6656693930E+04, 5.0235597176E+03, 1.2135431876E+04, 3.1349987792E+03, 9.6325440092E-01],
	[3.78200E+04, 2.6662783489E+04, 5.0235759477E+03, 1.2140653722E+04, 3.1354377071E+03, 9.6327048158E-01],
	[3.78250E+04, 2.6668873634E+04, 5.0235921758E+03, 1.2145877123E+04, 3.1358765306E+03, 9.6328655406E-01],
	[3.78300E+04, 2.6674964365E+04, 5.0236084017E+03, 1.2151102079E+04, 3.1363152498E+03, 9.6330261837E-01],
	[3.78350E+04, 2.6681055682E+04, 5.0236246256E+03, 1.2156328590E+04, 3.1367538647E+03, 9.6331867451E-01],
	[3.78400E+04, 2.6687147584E+04, 5.0236408474E+03, 1.2161556657E+04, 3.1371923753E+03, 9.6333472247E-01],
	[3.78450E+04, 2.6693240072E+04, 5.0236570671E+03, 1.2166786279E+04, 3.1376307815E+03, 9.6335076228E-01],
	[3.78500E+04, 2.6699333146E+04, 5.0236732846E+03, 1.2172017457E+04, 3.1380690834E+03, 9.6336679393E-01],
	[3.78550E+04, 2.6705426806E+04, 5.0236895001E+03, 1.2177250192E+04, 3.1385072810E+03, 9.6338281742E-01],
	[3.78600E+04, 2.6711521051E+04, 5.0237057136E+03, 1.2182484483E+04, 3.1389453744E+03, 9.6339883276E-01],
	[3.78650E+04, 2.6717615882E+04, 5.0237219249E+03, 1.2187720330E+04, 3.1393833635E+03, 9.6341483996E-01],
	[3.78700E+04, 2.6723711299E+04, 5.0237381341E+03, 1.2192957735E+04, 3.1398212483E+03, 9.6343083902E-01],
	[3.78750E+04, 2.6729807301E+04, 5.0237543413E+03, 1.2198196697E+04, 3.1402590289E+03, 9.6344682994E-01],
	[3.78800E+04, 2.6735903889E+04, 5.0237705463E+03, 1.2203437217E+04, 3.1406967053E+03, 9.6346281272E-01],
	[3.78850E+04, 2.6742001062E+04, 5.0237867493E+03, 1.2208679294E+04, 3.1411342775E+03, 9.6347878738E-01],
	[3.78900E+04, 2.6748098821E+04, 5.0238029502E+03, 1.2213922929E+04, 3.1415717454E+03, 9.6349475391E-01],
	[3.78950E+04, 2.6754197165E+04, 5.0238191490E+03, 1.2219168123E+04, 3.1420091092E+03, 9.6351071232E-01],
	[3.79000E+04, 2.6760296095E+04, 5.0238353457E+03, 1.2224414875E+04, 3.1424463688E+03, 9.6352666261E-01],
	[3.79050E+04, 2.6766395611E+04, 5.0238515403E+03, 1.2229663186E+04, 3.1428835242E+03, 9.6354260480E-01],
	[3.79100E+04, 2.6772495712E+04, 5.0238677329E+03, 1.2234913056E+04, 3.1433205755E+03, 9.6355853887E-01],
	[3.79150E+04, 2.6778596398E+04, 5.0238839233E+03, 1.2240164486E+04, 3.1437575226E+03, 9.6357446484E-01],
	[3.79200E+04, 2.6784697670E+04, 5.0239001117E+03, 1.2245417475E+04, 3.1441943656E+03, 9.6359038272E-01],
	[3.79250E+04, 2.6790799527E+04, 5.0239162980E+03, 1.2250672023E+04, 3.1446311045E+03, 9.6360629249E-01],
	[3.79300E+04, 2.6796901970E+04, 5.0239324822E+03, 1.2255928132E+04, 3.1450677392E+03, 9.6362219418E-01],
	[3.79350E+04, 2.6803004998E+04, 5.0239486644E+03, 1.2261185801E+04, 3.1455042699E+03, 9.6363808778E-01],
	[3.79400E+04, 2.6809108611E+04, 5.0239648444E+03, 1.2266445031E+04, 3.1459406965E+03, 9.6365397330E-01],
	[3.79450E+04, 2.6815212810E+04, 5.0239810224E+03, 1.2271705822E+04, 3.1463770191E+03, 9.6366985074E-01],
	[3.79500E+04, 2.6821317594E+04, 5.0239971983E+03, 1.2276968174E+04, 3.1468132376E+03, 9.6368572010E-01],
	[3.79550E+04, 2.6827422963E+04, 5.0240133721E+03, 1.2282232087E+04, 3.1472493520E+03, 9.6370158140E-01],
	[3.79600E+04, 2.6833528918E+04, 5.0240295439E+03, 1.2287497561E+04, 3.1476853625E+03, 9.6371743463E-01],
	[3.79650E+04, 2.6839635457E+04, 5.0240457135E+03, 1.2292764598E+04, 3.1481212689E+03, 9.6373327980E-01],
	[3.79700E+04, 2.6845742582E+04, 5.0240618811E+03, 1.2298033197E+04, 3.1485570713E+03, 9.6374911691E-01],
	[3.79750E+04, 2.6851850292E+04, 5.0240780466E+03, 1.2303303358E+04, 3.1489927697E+03, 9.6376494597E-01],
	[3.79800E+04, 2.6857958588E+04, 5.0240942100E+03, 1.2308575082E+04, 3.1494283641E+03, 9.6378076698E-01],
	[3.79850E+04, 2.6864067468E+04, 5.0241103714E+03, 1.2313848368E+04, 3.1498638546E+03, 9.6379657994E-01],
	[3.79900E+04, 2.6870176934E+04, 5.0241265307E+03, 1.2319123218E+04, 3.1502992411E+03, 9.6381238487E-01],
	[3.79950E+04, 2.6876286985E+04, 5.0241426879E+03, 1.2324399632E+04, 3.1507345237E+03, 9.6382818176E-01],
	[3.80000E+04, 2.6882397620E+04, 5.0241588430E+03, 1.2329677609E+04, 3.1511697023E+03, 9.6384397062E-01],
	[3.80050E+04, 2.6888508841E+04, 5.0241749961E+03, 1.2334957150E+04, 3.1516047771E+03, 9.6385975145E-01],
	[3.80100E+04, 2.6894620647E+04, 5.0241911470E+03, 1.2340238255E+04, 3.1520397479E+03, 9.6387552426E-01],
	[3.80150E+04, 2.6900733038E+04, 5.0242072960E+03, 1.2345520924E+04, 3.1524746149E+03, 9.6389128905E-01],
	[3.80200E+04, 2.6906846014E+04, 5.0242234428E+03, 1.2350805159E+04, 3.1529093779E+03, 9.6390704582E-01],
	[3.80250E+04, 2.6912959575E+04, 5.0242395876E+03, 1.2356090958E+04, 3.1533440371E+03, 9.6392279458E-01],
	[3.80300E+04, 2.6919073721E+04, 5.0242557303E+03, 1.2361378322E+04, 3.1537785925E+03, 9.6393853534E-01],
	[3.80350E+04, 2.6925188452E+04, 5.0242718709E+03, 1.2366667252E+04, 3.1542130440E+03, 9.6395426810E-01],
	[3.80400E+04, 2.6931303768E+04, 5.0242880094E+03, 1.2371957748E+04, 3.1546473917E+03, 9.6396999285E-01],
	[3.80450E+04, 2.6937419668E+04, 5.0243041459E+03, 1.2377249810E+04, 3.1550816356E+03, 9.6398570962E-01],
	[3.80500E+04, 2.6943536154E+04, 5.0243202803E+03, 1.2382543437E+04, 3.1555157757E+03, 9.6400141839E-01],
	[3.80550E+04, 2.6949653224E+04, 5.0243364127E+03, 1.2387838632E+04, 3.1559498120E+03, 9.6401711918E-01],
	[3.80600E+04, 2.6955770880E+04, 5.0243525430E+03, 1.2393135393E+04, 3.1563837445E+03, 9.6403281198E-01],
	[3.80650E+04, 2.6961889120E+04, 5.0243686712E+03, 1.2398433721E+04, 3.1568175733E+03, 9.6404849682E-01],
	[3.80700E+04, 2.6968007945E+04, 5.0243847973E+03, 1.2403733617E+04, 3.1572512983E+03, 9.6406417367E-01],
	[3.80750E+04, 2.6974127355E+04, 5.0244009214E+03, 1.2409035080E+04, 3.1576849196E+03, 9.6407984256E-01],
	[3.80800E+04, 2.6980247349E+04, 5.0244170434E+03, 1.2414338111E+04, 3.1581184371E+03, 9.6409550349E-01],
	[3.80850E+04, 2.6986367928E+04, 5.0244331634E+03, 1.2419642709E+04, 3.1585518510E+03, 9.6411115645E-01],
	[3.80900E+04, 2.6992489092E+04, 5.0244492813E+03, 1.2424948877E+04, 3.1589851611E+03, 9.6412680146E-01],
	[3.80950E+04, 2.6998610841E+04, 5.0244653971E+03, 1.2430256612E+04, 3.1594183676E+03, 9.6414243852E-01],
	[3.81000E+04, 2.7004733174E+04, 5.0244815109E+03, 1.2435565917E+04, 3.1598514704E+03, 9.6415806763E-01],
	[3.81050E+04, 2.7010856092E+04, 5.0244976226E+03, 1.2440876791E+04, 3.1602844695E+03, 9.6417368879E-01],
	[3.81100E+04, 2.7016979594E+04, 5.0245137322E+03, 1.2446189233E+04, 3.1607173650E+03, 9.6418930202E-01],
	[3.81150E+04, 2.7023103682E+04, 5.0245298398E+03, 1.2451503246E+04, 3.1611501569E+03, 9.6420490732E-01],
	[3.81200E+04, 2.7029228353E+04, 5.0245459453E+03, 1.2456818828E+04, 3.1615828452E+03, 9.6422050468E-01],
	[3.81250E+04, 2.7035353610E+04, 5.0245620487E+03, 1.2462135981E+04, 3.1620154298E+03, 9.6423609411E-01],
	[3.81300E+04, 2.7041479451E+04, 5.0245781501E+03, 1.2467454704E+04, 3.1624479108E+03, 9.6425167563E-01],
	[3.81350E+04, 2.7047605876E+04, 5.0245942495E+03, 1.2472774997E+04, 3.1628802883E+03, 9.6426724922E-01],
	[3.81400E+04, 2.7053732886E+04, 5.0246103467E+03, 1.2478096862E+04, 3.1633125622E+03, 9.6428281490E-01],
	[3.81450E+04, 2.7059860480E+04, 5.0246264419E+03, 1.2483420297E+04, 3.1637447326E+03, 9.6429837268E-01],
	[3.81500E+04, 2.7065988659E+04, 5.0246425351E+03, 1.2488745304E+04, 3.1641767994E+03, 9.6431392254E-01],
	[3.81550E+04, 2.7072117422E+04, 5.0246586262E+03, 1.2494071883E+04, 3.1646087627E+03, 9.6432946451E-01],
	[3.81600E+04, 2.7078246770E+04, 5.0246747152E+03, 1.2499400033E+04, 3.1650406225E+03, 9.6434499858E-01],
	[3.81650E+04, 2.7084376702E+04, 5.0246908022E+03, 1.2504729756E+04, 3.1654723787E+03, 9.6436052475E-01],
	[3.81700E+04, 2.7090507219E+04, 5.0247068872E+03, 1.2510061051E+04, 3.1659040315E+03, 9.6437604304E-01],
	[3.81750E+04, 2.7096638320E+04, 5.0247229700E+03, 1.2515393918E+04, 3.1663355808E+03, 9.6439155344E-01],
	[3.81800E+04, 2.7102770005E+04, 5.0247390509E+03, 1.2520728359E+04, 3.1667670267E+03, 9.6440705596E-01],
	[3.81850E+04, 2.7108902274E+04, 5.0247551296E+03, 1.2526064373E+04, 3.1671983691E+03, 9.6442255061E-01],
	[3.81900E+04, 2.7115035128E+04, 5.0247712063E+03, 1.2531401960E+04, 3.1676296081E+03, 9.6443803738E-01],
	[3.81950E+04, 2.7121168566E+04, 5.0247872810E+03, 1.2536741121E+04, 3.1680607436E+03, 9.6445351629E-01],
	[3.82000E+04, 2.7127302589E+04, 5.0248033536E+03, 1.2542081856E+04, 3.1684917758E+03, 9.6446898733E-01],
	[3.82050E+04, 2.7133437195E+04, 5.0248194241E+03, 1.2547424165E+04, 3.1689227045E+03, 9.6448445052E-01],
	[3.82100E+04, 2.7139572386E+04, 5.0248354926E+03, 1.2552768049E+04, 3.1693535299E+03, 9.6449990584E-01],
	[3.82150E+04, 2.7145708161E+04, 5.0248515591E+03, 1.2558113507E+04, 3.1697842519E+03, 9.6451535332E-01],
	[3.82200E+04, 2.7151844520E+04, 5.0248676235E+03, 1.2563460540E+04, 3.1702148705E+03, 9.6453079295E-01],
	[3.82250E+04, 2.7157981464E+04, 5.0248836858E+03, 1.2568809149E+04, 3.1706453858E+03, 9.6454622474E-01],
	[3.82300E+04, 2.7164118991E+04, 5.0248997461E+03, 1.2574159333E+04, 3.1710757978E+03, 9.6456164869E-01],
	[3.82350E+04, 2.7170257103E+04, 5.0249158044E+03, 1.2579511093E+04, 3.1715061064E+03, 9.6457706480E-01],
	[3.82400E+04, 2.7176395798E+04, 5.0249318606E+03, 1.2584864429E+04, 3.1719363118E+03, 9.6459247309E-01],
	[3.82450E+04, 2.7182535078E+04, 5.0249479147E+03, 1.2590219341E+04, 3.1723664139E+03, 9.6460787355E-01],
	[3.82500E+04, 2.7188674942E+04, 5.0249639669E+03, 1.2595575830E+04, 3.1727964127E+03, 9.6462326619E-01],
	[3.82550E+04, 2.7194815390E+04, 5.0249800169E+03, 1.2600933895E+04, 3.1732263082E+03, 9.6463865101E-01],
	[3.82600E+04, 2.7200956422E+04, 5.0249960649E+03, 1.2606293538E+04, 3.1736561005E+03, 9.6465402801E-01],
	[3.82650E+04, 2.7207098037E+04, 5.0250121109E+03, 1.2611654758E+04, 3.1740857895E+03, 9.6466939721E-01],
	[3.82700E+04, 2.7213240237E+04, 5.0250281548E+03, 1.2617017555E+04, 3.1745153754E+03, 9.6468475861E-01],
	[3.82750E+04, 2.7219383021E+04, 5.0250441967E+03, 1.2622381930E+04, 3.1749448580E+03, 9.6470011220E-01],
	[3.82800E+04, 2.7225526389E+04, 5.0250602365E+03, 1.2627747884E+04, 3.1753742374E+03, 9.6471545799E-01],
	[3.82850E+04, 2.7231670340E+04, 5.0250762743E+03, 1.2633115415E+04, 3.1758035137E+03, 9.6473079600E-01],
	[3.82900E+04, 2.7237814876E+04, 5.0250923101E+03, 1.2638484525E+04, 3.1762326867E+03, 9.6474612621E-01],
	[3.82950E+04, 2.7243959995E+04, 5.0251083438E+03, 1.2643855215E+04, 3.1766617567E+03, 9.6476144864E-01],
	[3.83000E+04, 2.7250105698E+04, 5.0251243754E+03, 1.2649227483E+04, 3.1770907235E+03, 9.6477676329E-01],
	[3.83050E+04, 2.7256251985E+04, 5.0251404050E+03, 1.2654601330E+04, 3.1775195871E+03, 9.6479207017E-01],
	[3.83100E+04, 2.7262398856E+04, 5.0251564326E+03, 1.2659976758E+04, 3.1779483477E+03, 9.6480736927E-01],
	[3.83150E+04, 2.7268546310E+04, 5.0251724582E+03, 1.2665353765E+04, 3.1783770051E+03, 9.6482266061E-01],
	[3.83200E+04, 2.7274694348E+04, 5.0251884817E+03, 1.2670732352E+04, 3.1788055595E+03, 9.6483794418E-01],
	[3.83250E+04, 2.7280842970E+04, 5.0252045031E+03, 1.2676112519E+04, 3.1792340108E+03, 9.6485321999E-01],
	[3.83300E+04, 2.7286992176E+04, 5.0252205225E+03, 1.2681494268E+04, 3.1796623590E+03, 9.6486848805E-01],
	[3.83350E+04, 2.7293141966E+04, 5.0252365399E+03, 1.2686877597E+04, 3.1800906042E+03, 9.6488374836E-01],
	[3.83400E+04, 2.7299292339E+04, 5.0252525553E+03, 1.2692262507E+04, 3.1805187463E+03, 9.6489900092E-01],
	[3.83450E+04, 2.7305443295E+04, 5.0252685686E+03, 1.2697648999E+04, 3.1809467855E+03, 9.6491424574E-01],
	[3.83500E+04, 2.7311594836E+04, 5.0252845798E+03, 1.2703037072E+04, 3.1813747216E+03, 9.6492948282E-01],
	[3.83550E+04, 2.7317746960E+04, 5.0253005891E+03, 1.2708426728E+04, 3.1818025547E+03, 9.6494471217E-01],
	[3.83600E+04, 2.7323899668E+04, 5.0253165963E+03, 1.2713817965E+04, 3.1822302849E+03, 9.6495993378E-01],
	[3.83650E+04, 2.7330052959E+04, 5.0253326014E+03, 1.2719210785E+04, 3.1826579121E+03, 9.6497514767E-01],
	[3.83700E+04, 2.7336206833E+04, 5.0253486045E+03, 1.2724605188E+04, 3.1830854363E+03, 9.6499035384E-01],
	[3.83750E+04, 2.7342361292E+04, 5.0253646056E+03, 1.2730001174E+04, 3.1835128577E+03, 9.6500555229E-01],
	[3.83800E+04, 2.7348516333E+04, 5.0253806047E+03, 1.2735398743E+04, 3.1839401760E+03, 9.6502074303E-01],
	[3.83850E+04, 2.7354671959E+04, 5.0253966017E+03, 1.2740797895E+04, 3.1843673915E+03, 9.6503592606E-01],
	[3.83900E+04, 2.7360828167E+04, 5.0254125967E+03, 1.2746198631E+04, 3.1847945041E+03, 9.6505110138E-01],
	[3.83950E+04, 2.7366984960E+04, 5.0254285897E+03, 1.2751600952E+04, 3.1852215138E+03, 9.6506626900E-01],
	[3.84000E+04, 2.7373142335E+04, 5.0254445806E+03, 1.2757004856E+04, 3.1856484207E+03, 9.6508142893E-01],
	[3.84050E+04, 2.7379300294E+04, 5.0254605695E+03, 1.2762410345E+04, 3.1860752246E+03, 9.6509658116E-01],
	[3.84100E+04, 2.7385458836E+04, 5.0254765564E+03, 1.2767817419E+04, 3.1865019258E+03, 9.6511172571E-01],
	[3.84150E+04, 2.7391617962E+04, 5.0254925412E+03, 1.2773226077E+04, 3.1869285241E+03, 9.6512686257E-01],
	[3.84200E+04, 2.7397777671E+04, 5.0255085240E+03, 1.2778636321E+04, 3.1873550196E+03, 9.6514199175E-01],
	[3.84250E+04, 2.7403937964E+04, 5.0255245048E+03, 1.2784048151E+04, 3.1877814123E+03, 9.6515711326E-01],
	[3.84300E+04, 2.7410098839E+04, 5.0255404835E+03, 1.2789461566E+04, 3.1882077023E+03, 9.6517222709E-01],
	[3.84350E+04, 2.7416260298E+04, 5.0255564603E+03, 1.2794876568E+04, 3.1886338894E+03, 9.6518733325E-01],
	[3.84400E+04, 2.7422422341E+04, 5.0255724350E+03, 1.2800293156E+04, 3.1890599738E+03, 9.6520243175E-01],
	[3.84450E+04, 2.7428584966E+04, 5.0255884076E+03, 1.2805711330E+04, 3.1894859555E+03, 9.6521752260E-01],
	[3.84500E+04, 2.7434748175E+04, 5.0256043783E+03, 1.2811131091E+04, 3.1899118344E+03, 9.6523260578E-01],
	[3.84550E+04, 2.7440911967E+04, 5.0256203469E+03, 1.2816552439E+04, 3.1903376106E+03, 9.6524768132E-01],
	[3.84600E+04, 2.7447076342E+04, 5.0256363135E+03, 1.2821975375E+04, 3.1907632841E+03, 9.6526274921E-01],
	[3.84650E+04, 2.7453241300E+04, 5.0256522780E+03, 1.2827399898E+04, 3.1911888549E+03, 9.6527780945E-01],
	[3.84700E+04, 2.7459406841E+04, 5.0256682406E+03, 1.2832826009E+04, 3.1916143231E+03, 9.6529286206E-01],
	[3.84750E+04, 2.7465572966E+04, 5.0256842011E+03, 1.2838253708E+04, 3.1920396886E+03, 9.6530790703E-01],
	[3.84800E+04, 2.7471739674E+04, 5.0257001596E+03, 1.2843682996E+04, 3.1924649514E+03, 9.6532294437E-01],
	[3.84850E+04, 2.7477906964E+04, 5.0257161160E+03, 1.2849113872E+04, 3.1928901116E+03, 9.6533797409E-01],
	[3.84900E+04, 2.7484074838E+04, 5.0257320705E+03, 1.2854546337E+04, 3.1933151692E+03, 9.6535299618E-01],
	[3.84950E+04, 2.7490243295E+04, 5.0257480229E+03, 1.2859980392E+04, 3.1937401242E+03, 9.6536801066E-01],
	[3.85000E+04, 2.7496412335E+04, 5.0257639733E+03, 1.2865416035E+04, 3.1941649766E+03, 9.6538301752E-01],
	[3.85050E+04, 2.7502581957E+04, 5.0257799217E+03, 1.2870853269E+04, 3.1945897265E+03, 9.6539801677E-01],
	[3.85100E+04, 2.7508752163E+04, 5.0257958681E+03, 1.2876292092E+04, 3.1950143737E+03, 9.6541300841E-01],
	[3.85150E+04, 2.7514922952E+04, 5.0258118124E+03, 1.2881732505E+04, 3.1954389184E+03, 9.6542799246E-01],
	[3.85200E+04, 2.7521094323E+04, 5.0258277547E+03, 1.2887174509E+04, 3.1958633606E+03, 9.6544296890E-01],
	[3.85250E+04, 2.7527266278E+04, 5.0258436950E+03, 1.2892618104E+04, 3.1962877003E+03, 9.6545793776E-01],
	[3.85300E+04, 2.7533438815E+04, 5.0258596333E+03, 1.2898063289E+04, 3.1967119375E+03, 9.6547289902E-01],
	[3.85350E+04, 2.7539611936E+04, 5.0258755696E+03, 1.2903510066E+04, 3.1971360721E+03, 9.6548785270E-01],
	[3.85400E+04, 2.7545785639E+04, 5.0258915039E+03, 1.2908958434E+04, 3.1975601043E+03, 9.6550279880E-01],
	[3.85450E+04, 2.7551959925E+04, 5.0259074361E+03, 1.2914408394E+04, 3.1979840341E+03, 9.6551773732E-01],
	[3.85500E+04, 2.7558134793E+04, 5.0259233663E+03, 1.2919859946E+04, 3.1984078613E+03, 9.6553266827E-01],
	[3.85550E+04, 2.7564310245E+04, 5.0259392945E+03, 1.2925313091E+04, 3.1988315862E+03, 9.6554759165E-01],
	[3.85600E+04, 2.7570486279E+04, 5.0259552207E+03, 1.2930767827E+04, 3.1992552086E+03, 9.6556250746E-01],
	[3.85650E+04, 2.7576662896E+04, 5.0259711449E+03, 1.2936224157E+04, 3.1996787287E+03, 9.6557741572E-01],
	[3.85700E+04, 2.7582840096E+04, 5.0259870670E+03, 1.2941682079E+04, 3.2001021463E+03, 9.6559231642E-01],
	[3.85750E+04, 2.7589017879E+04, 5.0260029872E+03, 1.2947141595E+04, 3.2005254615E+03, 9.6560720956E-01],
	[3.85800E+04, 2.7595196244E+04, 5.0260189053E+03, 1.2952602704E+04, 3.2009486744E+03, 9.6562209516E-01],
	[3.85850E+04, 2.7601375192E+04, 5.0260348214E+03, 1.2958065407E+04, 3.2013717850E+03, 9.6563697321E-01],
	[3.85900E+04, 2.7607554722E+04, 5.0260507356E+03, 1.2963529704E+04, 3.2017947932E+03, 9.6565184373E-01],
	[3.85950E+04, 2.7613734835E+04, 5.0260666477E+03, 1.2968995596E+04, 3.2022176991E+03, 9.6566670671E-01],
	[3.86000E+04, 2.7619915531E+04, 5.0260825577E+03, 1.2974463082E+04, 3.2026405026E+03, 9.6568156216E-01],
	[3.86050E+04, 2.7626110930E+04, 5.0261008345E+03, 1.2979932163E+04, 3.2030643557E+03, 9.6569641007E-01],
	[3.86100E+04, 2.7632329041E+04, 5.0261228194E+03, 1.2985402839E+04, 3.2034899117E+03, 9.6571125047E-01],
	[3.86150E+04, 2.7638547746E+04, 5.0261448017E+03, 1.2990875110E+04, 3.2039153663E+03, 9.6572608335E-01],
	[3.86200E+04, 2.7644767046E+04, 5.0261667811E+03, 1.2996348977E+04, 3.2043407196E+03, 9.6574090871E-01],
	[3.86250E+04, 2.7650986939E+04, 5.0261887579E+03, 1.3001824439E+04, 3.2047659716E+03, 9.6575572656E-01],
	[3.86300E+04, 2.7657207427E+04, 5.0262107319E+03, 1.3007301498E+04, 3.2051911223E+03, 9.6577053690E-01],
	[3.86350E+04, 2.7663428508E+04, 5.0262327031E+03, 1.3012780153E+04, 3.2056161718E+03, 9.6578533975E-01],
	[3.86400E+04, 2.7669650184E+04, 5.0262546716E+03, 1.3018260405E+04, 3.2060411200E+03, 9.6580013509E-01],
	[3.86450E+04, 2.7675872454E+04, 5.0262766373E+03, 1.3023742254E+04, 3.2064659670E+03, 9.6581492294E-01],
	[3.86500E+04, 2.7682095317E+04, 5.0262986003E+03, 1.3029225700E+04, 3.2068907128E+03, 9.6582970329E-01],
	[3.86550E+04, 2.7688318775E+04, 5.0263205606E+03, 1.3034710743E+04, 3.2073153574E+03, 9.6584447616E-01],
	[3.86600E+04, 2.7694542826E+04, 5.0263425181E+03, 1.3040197384E+04, 3.2077399007E+03, 9.6585924155E-01],
	[3.86650E+04, 2.7700767472E+04, 5.0263644728E+03, 1.3045685623E+04, 3.2081643429E+03, 9.6587399946E-01],
	[3.86700E+04, 2.7706992711E+04, 5.0263864249E+03, 1.3051175460E+04, 3.2085886839E+03, 9.6588874989E-01],
	[3.86750E+04, 2.7713218544E+04, 5.0264083741E+03, 1.3056666895E+04, 3.2090129238E+03, 9.6590349286E-01],
	[3.86800E+04, 2.7719444971E+04, 5.0264303207E+03, 1.3062159929E+04, 3.2094370625E+03, 9.6591822836E-01],
	[3.86850E+04, 2.7725671992E+04, 5.0264522645E+03, 1.3067654562E+04, 3.2098611001E+03, 9.6593295640E-01],
	[3.86900E+04, 2.7731899606E+04, 5.0264742055E+03, 1.3073150795E+04, 3.2102850366E+03, 9.6594767698E-01],
	[3.86950E+04, 2.7738127815E+04, 5.0264961438E+03, 1.3078648627E+04, 3.2107088721E+03, 9.6596239010E-01],
	[3.87000E+04, 2.7744356617E+04, 5.0265180794E+03, 1.3084148058E+04, 3.2111326064E+03, 9.6597709578E-01],
	[3.87050E+04, 2.7750586013E+04, 5.0265400122E+03, 1.3089649089E+04, 3.2115562396E+03, 9.6599179401E-01],
	[3.87100E+04, 2.7756816003E+04, 5.0265619423E+03, 1.3095151721E+04, 3.2119797718E+03, 9.6600648480E-01],
	[3.87150E+04, 2.7763046586E+04, 5.0265838697E+03, 1.3100655953E+04, 3.2124032030E+03, 9.6602116815E-01],
	[3.87200E+04, 2.7769277763E+04, 5.0266057943E+03, 1.3106161786E+04, 3.2128265331E+03, 9.6603584406E-01],
	[3.87250E+04, 2.7775509534E+04, 5.0266277162E+03, 1.3111669220E+04, 3.2132497622E+03, 9.6605051255E-01],
	[3.87300E+04, 2.7781741898E+04, 5.0266496354E+03, 1.3117178256E+04, 3.2136728904E+03, 9.6606517362E-01],
	[3.87350E+04, 2.7787974856E+04, 5.0266715518E+03, 1.3122688892E+04, 3.2140959175E+03, 9.6607982726E-01],
	[3.87400E+04, 2.7794208408E+04, 5.0266934655E+03, 1.3128201131E+04, 3.2145188437E+03, 9.6609447348E-01],
	[3.87450E+04, 2.7800442553E+04, 5.0267153764E+03, 1.3133714972E+04, 3.2149416689E+03, 9.6610911229E-01],
	[3.87500E+04, 2.7806677292E+04, 5.0267372847E+03, 1.3139230414E+04, 3.2153643932E+03, 9.6612374370E-01],
	[3.87550E+04, 2.7812912624E+04, 5.0267591902E+03, 1.3144747460E+04, 3.2157870165E+03, 9.6613836769E-01],
	[3.87600E+04, 2.7819148550E+04, 5.0267810929E+03, 1.3150266108E+04, 3.2162095390E+03, 9.6615298429E-01],
	[3.87650E+04, 2.7825385069E+04, 5.0268029929E+03, 1.3155786360E+04, 3.2166319605E+03, 9.6616759349E-01],
	[3.87700E+04, 2.7831622182E+04, 5.0268248903E+03, 1.3161308214E+04, 3.2170542812E+03, 9.6618219530E-01],
	[3.87750E+04, 2.7837859888E+04, 5.0268467848E+03, 1.3166831673E+04, 3.2174765010E+03, 9.6619678972E-01],
	[3.87800E+04, 2.7844098188E+04, 5.0268686767E+03, 1.3172356735E+04, 3.2178986199E+03, 9.6621137675E-01],
	[3.87850E+04, 2.7850337081E+04, 5.0268905658E+03, 1.3177883401E+04, 3.2183206380E+03, 9.6622595641E-01],
	[3.87900E+04, 2.7856576568E+04, 5.0269124522E+03, 1.3183411672E+04, 3.2187425552E+03, 9.6624052869E-01],
	[3.87950E+04, 2.7862816648E+04, 5.0269343359E+03, 1.3188941547E+04, 3.2191643717E+03, 9.6625509359E-01],
	[3.88000E+04, 2.7869057321E+04, 5.0269562168E+03, 1.3194473027E+04, 3.2195860873E+03, 9.6626965113E-01],
	[3.88050E+04, 2.7875298588E+04, 5.0269780950E+03, 1.3200006113E+04, 3.2200077022E+03, 9.6628420130E-01],
	[3.88100E+04, 2.7881540448E+04, 5.0269999705E+03, 1.3205540803E+04, 3.2204292163E+03, 9.6629874411E-01],
	[3.88150E+04, 2.7887782901E+04, 5.0270218433E+03, 1.3211077100E+04, 3.2208506296E+03, 9.6631327957E-01],
	[3.88200E+04, 2.7894025948E+04, 5.0270437133E+03, 1.3216615002E+04, 3.2212719422E+03, 9.6632780767E-01],
	[3.88250E+04, 2.7900269588E+04, 5.0270655807E+03, 1.3222154510E+04, 3.2216931541E+03, 9.6634232843E-01],
	[3.88300E+04, 2.7906513821E+04, 5.0270874453E+03, 1.3227695625E+04, 3.2221142653E+03, 9.6635684184E-01],
	[3.88350E+04, 2.7912758647E+04, 5.0271093072E+03, 1.3233238347E+04, 3.2225352757E+03, 9.6637134791E-01],
	[3.88400E+04, 2.7919004067E+04, 5.0271311663E+03, 1.3238782676E+04, 3.2229561855E+03, 9.6638584665E-01],
	[3.88450E+04, 2.7925250080E+04, 5.0271530228E+03, 1.3244328611E+04, 3.2233769946E+03, 9.6640033806E-01],
	[3.88500E+04, 2.7931496686E+04, 5.0271748765E+03, 1.3249876155E+04, 3.2237977030E+03, 9.6641482213E-01],
	[3.88550E+04, 2.7937743885E+04, 5.0271967275E+03, 1.3255425306E+04, 3.2242183108E+03, 9.6642929889E-01],
	[3.88600E+04, 2.7943991677E+04, 5.0272185758E+03, 1.3260976065E+04, 3.2246388180E+03, 9.6644376832E-01],
	[3.88650E+04, 2.7950240062E+04, 5.0272404214E+03, 1.3266528432E+04, 3.2250592246E+03, 9.6645823044E-01],
	[3.88700E+04, 2.7956489041E+04, 5.0272622643E+03, 1.3272082407E+04, 3.2254795305E+03, 9.6647268524E-01],
	[3.88750E+04, 2.7962738612E+04, 5.0272841044E+03, 1.3277637992E+04, 3.2258997359E+03, 9.6648713274E-01],
	[3.88800E+04, 2.7968988777E+04, 5.0273059419E+03, 1.3283195185E+04, 3.2263198407E+03, 9.6650157294E-01],
	[3.88850E+04, 2.7975239534E+04, 5.0273277766E+03, 1.3288753988E+04, 3.2267398450E+03, 9.6651600583E-01],
	[3.88900E+04, 2.7981490885E+04, 5.0273496086E+03, 1.3294314400E+04, 3.2271597487E+03, 9.6653043143E-01],
	[3.88950E+04, 2.7987742828E+04, 5.0273714379E+03, 1.3299876423E+04, 3.2275795519E+03, 9.6654484974E-01],
	[3.89000E+04, 2.7993995365E+04, 5.0273932645E+03, 1.3305440055E+04, 3.2279992546E+03, 9.6655926076E-01],
	[3.89050E+04, 2.8000248494E+04, 5.0274150884E+03, 1.3311005297E+04, 3.2284188568E+03, 9.6657366450E-01],
	[3.89100E+04, 2.8006502217E+04, 5.0274369095E+03, 1.3316572150E+04, 3.2288383585E+03, 9.6658806096E-01],
	[3.89150E+04, 2.8012756532E+04, 5.0274587280E+03, 1.3322140614E+04, 3.2292577597E+03, 9.6660245014E-01],
	[3.89200E+04, 2.8019011440E+04, 5.0274805437E+03, 1.3327710689E+04, 3.2296770605E+03, 9.6661683205E-01],
	[3.89250E+04, 2.8025266941E+04, 5.0275023568E+03, 1.3333282375E+04, 3.2300962608E+03, 9.6663120670E-01],
	[3.89300E+04, 2.8031523035E+04, 5.0275241671E+03, 1.3338855673E+04, 3.2305153607E+03, 9.6664557408E-01],
	[3.89350E+04, 2.8037779722E+04, 5.0275459747E+03, 1.3344430583E+04, 3.2309343603E+03, 9.6665993420E-01],
	[3.89400E+04, 2.8044037001E+04, 5.0275677797E+03, 1.3350007105E+04, 3.2313532594E+03, 9.6667428707E-01],
	[3.89450E+04, 2.8050294874E+04, 5.0275895819E+03, 1.3355585239E+04, 3.2317720581E+03, 9.6668863269E-01],
	[3.89500E+04, 2.8056553339E+04, 5.0276113814E+03, 1.3361164986E+04, 3.2321907565E+03, 9.6670297105E-01],
	[3.89550E+04, 2.8062812397E+04, 5.0276331782E+03, 1.3366746346E+04, 3.2326093545E+03, 9.6671730218E-01],
	[3.89600E+04, 2.8069072047E+04, 5.0276549723E+03, 1.3372329319E+04, 3.2330278521E+03, 9.6673162607E-01],
	[3.89650E+04, 2.8075332291E+04, 5.0276767637E+03, 1.3377913905E+04, 3.2334462495E+03, 9.6674594272E-01],
	[3.89700E+04, 2.8081593126E+04, 5.0276985524E+03, 1.3383500105E+04, 3.2338645465E+03, 9.6676025214E-01],
	[3.89750E+04, 2.8087854555E+04, 5.0277203384E+03, 1.3389087919E+04, 3.2342827433E+03, 9.6677455433E-01],
	[3.89800E+04, 2.8094116576E+04, 5.0277421217E+03, 1.3394677347E+04, 3.2347008398E+03, 9.6678884930E-01],
	[3.89850E+04, 2.8100379190E+04, 5.0277639023E+03, 1.3400268390E+04, 3.2351188360E+03, 9.6680313705E-01],
	[3.89900E+04, 2.8106642397E+04, 5.0277856802E+03, 1.3405861047E+04, 3.2355367319E+03, 9.6681741759E-01],
	[3.89950E+04, 2.8112906196E+04, 5.0278074554E+03, 1.3411455319E+04, 3.2359545277E+03, 9.6683169091E-01],
	[3.90000E+04, 2.8119170588E+04, 5.0278292279E+03, 1.3417051207E+04, 3.2363722232E+03, 9.6684595703E-01],
	[3.90050E+04, 2.8125435572E+04, 5.0278509977E+03, 1.3422648709E+04, 3.2367898185E+03, 9.6686021595E-01],
	[3.90100E+04, 2.8131701149E+04, 5.0278727649E+03, 1.3428247828E+04, 3.2372073136E+03, 9.6687446766E-01],
	[3.90150E+04, 2.8137967318E+04, 5.0278945293E+03, 1.3433848563E+04, 3.2376247085E+03, 9.6688871218E-01],
	[3.90200E+04, 2.8144234080E+04, 5.0279162910E+03, 1.3439450914E+04, 3.2380420033E+03, 9.6690294951E-01],
	[3.90250E+04, 2.8150501434E+04, 5.0279380500E+03, 1.3445054881E+04, 3.2384591979E+03, 9.6691717966E-01],
	[3.90300E+04, 2.8156769380E+04, 5.0279598064E+03, 1.3450660465E+04, 3.2388762924E+03, 9.6693140262E-01],
	[3.90350E+04, 2.8163037920E+04, 5.0279815600E+03, 1.3456267667E+04, 3.2392932868E+03, 9.6694561840E-01],
	[3.90400E+04, 2.8169307051E+04, 5.0280033110E+03, 1.3461876485E+04, 3.2397101811E+03, 9.6695982700E-01],
	[3.90450E+04, 2.8175576775E+04, 5.0280250592E+03, 1.3467486921E+04, 3.2401269753E+03, 9.6697402844E-01],
	[3.90500E+04, 2.8181847091E+04, 5.0280468048E+03, 1.3473098975E+04, 3.2405436694E+03, 9.6698822271E-01],
	[3.90550E+04, 2.8188118000E+04, 5.0280685477E+03, 1.3478712647E+04, 3.2409602634E+03, 9.6700240981E-01],
	[3.90600E+04, 2.8194389501E+04, 5.0280902878E+03, 1.3484327937E+04, 3.2413767575E+03, 9.6701658976E-01],
	[3.90650E+04, 2.8200661594E+04, 5.0281120253E+03, 1.3489944846E+04, 3.2417931514E+03, 9.6703076255E-01],
	[3.90700E+04, 2.8206934280E+04, 5.0281337602E+03, 1.3495563374E+04, 3.2422094454E+03, 9.6704492819E-01],
	[3.90750E+04, 2.8213207557E+04, 5.0281554923E+03, 1.3501183521E+04, 3.2426256394E+03, 9.6705908668E-01],
	[3.90800E+04, 2.8219481428E+04, 5.0281772217E+03, 1.3506805287E+04, 3.2430417334E+03, 9.6707323803E-01],
	[3.90850E+04, 2.8225755890E+04, 5.0281989485E+03, 1.3512428673E+04, 3.2434577274E+03, 9.6708738224E-01],
	[3.90900E+04, 2.8232030944E+04, 5.0282206725E+03, 1.3518053678E+04, 3.2438736215E+03, 9.6710151932E-01],
	[3.90950E+04, 2.8238306591E+04, 5.0282423939E+03, 1.3523680304E+04, 3.2442894156E+03, 9.6711564926E-01],
	[3.91000E+04, 2.8244582830E+04, 5.0282641126E+03, 1.3529308550E+04, 3.2447051099E+03, 9.6712977208E-01],
	[3.91050E+04, 2.8250859661E+04, 5.0282858286E+03, 1.3534938417E+04, 3.2451207042E+03, 9.6714388777E-01],
	[3.91100E+04, 2.8257137084E+04, 5.0283075420E+03, 1.3540569905E+04, 3.2455361986E+03, 9.6715799635E-01],
	[3.91150E+04, 2.8263415099E+04, 5.0283292526E+03, 1.3546203014E+04, 3.2459515931E+03, 9.6717209781E-01],
	[3.91200E+04, 2.8269693707E+04, 5.0283509606E+03, 1.3551837744E+04, 3.2463668878E+03, 9.6718619215E-01],
	[3.91250E+04, 2.8275972906E+04, 5.0283726659E+03, 1.3557474096E+04, 3.2467820826E+03, 9.6720027940E-01],
	[3.91300E+04, 2.8282252698E+04, 5.0283943685E+03, 1.3563112070E+04, 3.2471971776E+03, 9.6721435953E-01],
	[3.91350E+04, 2.8288533081E+04, 5.0284160684E+03, 1.3568751666E+04, 3.2476121727E+03, 9.6722843257E-01],
	[3.91400E+04, 2.8294814057E+04, 5.0284377657E+03, 1.3574392885E+04, 3.2480270681E+03, 9.6724249851E-01],
	[3.91450E+04, 2.8301095624E+04, 5.0284594602E+03, 1.3580035726E+04, 3.2484418637E+03, 9.6725655736E-01],
	[3.91500E+04, 2.8307377784E+04, 5.0284811521E+03, 1.3585680190E+04, 3.2488565595E+03, 9.6727060913E-01],
	[3.91550E+04, 2.8313660535E+04, 5.0285028413E+03, 1.3591326278E+04, 3.2492711555E+03, 9.6728465381E-01],
	[3.91600E+04, 2.8319943878E+04, 5.0285245279E+03, 1.3596973989E+04, 3.2496856518E+03, 9.6729869141E-01],
	[3.91650E+04, 2.8326227814E+04, 5.0285462117E+03, 1.3602623324E+04, 3.2501000484E+03, 9.6731272193E-01],
	[3.91700E+04, 2.8332512341E+04, 5.0285678929E+03, 1.3608274283E+04, 3.2505143452E+03, 9.6732674539E-01],
	[3.91750E+04, 2.8338797460E+04, 5.0285895715E+03, 1.3613926866E+04, 3.2509285424E+03, 9.6734076177E-01],
	[3.91800E+04, 2.8345083171E+04, 5.0286112473E+03, 1.3619581074E+04, 3.2513426398E+03, 9.6735477110E-01],
	[3.91850E+04, 2.8351369474E+04, 5.0286329205E+03, 1.3625236906E+04, 3.2517566376E+03, 9.6736877336E-01],
	[3.91900E+04, 2.8357656368E+04, 5.0286545910E+03, 1.3630894363E+04, 3.2521705358E+03, 9.6738276856E-01],
	[3.91950E+04, 2.8363943854E+04, 5.0286762588E+03, 1.3636553446E+04, 3.2525843343E+03, 9.6739675672E-01],
	[3.92000E+04, 2.8370231933E+04, 5.0286979240E+03, 1.3642214155E+04, 3.2529980332E+03, 9.6741073783E-01],
	[3.92050E+04, 2.8376520602E+04, 5.0287195865E+03, 1.3647876489E+04, 3.2534116325E+03, 9.6742471189E-01],
	[3.92100E+04, 2.8382809864E+04, 5.0287412463E+03, 1.3653540449E+04, 3.2538251321E+03, 9.6743867891E-01],
	[3.92150E+04, 2.8389099717E+04, 5.0287629034E+03, 1.3659206036E+04, 3.2542385322E+03, 9.6745263890E-01],
	[3.92200E+04, 2.8395390162E+04, 5.0287845579E+03, 1.3664873249E+04, 3.2546518328E+03, 9.6746659185E-01],
	[3.92250E+04, 2.8401681199E+04, 5.0288062097E+03, 1.3670542089E+04, 3.2550650338E+03, 9.6748053778E-01],
	[3.92300E+04, 2.8407972827E+04, 5.0288278589E+03, 1.3676212556E+04, 3.2554781352E+03, 9.6749447668E-01],
	[3.92350E+04, 2.8414265047E+04, 5.0288495054E+03, 1.3681884651E+04, 3.2558911372E+03, 9.6750840856E-01],
	[3.92400E+04, 2.8420557859E+04, 5.0288711492E+03, 1.3687558373E+04, 3.2563040396E+03, 9.6752233343E-01],
	[3.92450E+04, 2.8426851262E+04, 5.0288927903E+03, 1.3693233723E+04, 3.2567168426E+03, 9.6753625128E-01],
	[3.92500E+04, 2.8433145257E+04, 5.0289144288E+03, 1.3698910701E+04, 3.2571295461E+03, 9.6755016213E-01],
	[3.92550E+04, 2.8439439843E+04, 5.0289360646E+03, 1.3704589308E+04, 3.2575421501E+03, 9.6756406597E-01],
	[3.92600E+04, 2.8445735021E+04, 5.0289576978E+03, 1.3710269544E+04, 3.2579546547E+03, 9.6757796281E-01],
	[3.92650E+04, 2.8452030791E+04, 5.0289793283E+03, 1.3715951408E+04, 3.2583670598E+03, 9.6759185265E-01],
	[3.92700E+04, 2.8458327151E+04, 5.0290009561E+03, 1.3721634901E+04, 3.2587793656E+03, 9.6760573550E-01],
	[3.92750E+04, 2.8464624104E+04, 5.0290225813E+03, 1.3727320024E+04, 3.2591915719E+03, 9.6761961136E-01],
	[3.92800E+04, 2.8470921648E+04, 5.0290442038E+03, 1.3733006777E+04, 3.2596036789E+03, 9.6763348024E-01],
	[3.92850E+04, 2.8477219783E+04, 5.0290658237E+03, 1.3738695160E+04, 3.2600156865E+03, 9.6764734213E-01],
	[3.92900E+04, 2.8483518510E+04, 5.0290874409E+03, 1.3744385172E+04, 3.2604275948E+03, 9.6766119705E-01],
	[3.92950E+04, 2.8489817828E+04, 5.0291090554E+03, 1.3750076816E+04, 3.2608394037E+03, 9.6767504500E-01],
	[3.93000E+04, 2.8496117737E+04, 5.0291306673E+03, 1.3755770090E+04, 3.2612511133E+03, 9.6768888597E-01],
	[3.93050E+04, 2.8502418238E+04, 5.0291522766E+03, 1.3761464995E+04, 3.2616627236E+03, 9.6770271998E-01],
	[3.93100E+04, 2.8508719330E+04, 5.0291738831E+03, 1.3767161531E+04, 3.2620742346E+03, 9.6771654703E-01],
	[3.93150E+04, 2.8515021014E+04, 5.0291954871E+03, 1.3772859699E+04, 3.2624856464E+03, 9.6773036713E-01],
	[3.93200E+04, 2.8521323288E+04, 5.0292170883E+03, 1.3778559499E+04, 3.2628969589E+03, 9.6774418026E-01],
	[3.93250E+04, 2.8527626154E+04, 5.0292386869E+03, 1.3784260931E+04, 3.2633081721E+03, 9.6775798645E-01],
	[3.93300E+04, 2.8533929612E+04, 5.0292602829E+03, 1.3789963995E+04, 3.2637192861E+03, 9.6777178570E-01],
	[3.93350E+04, 2.8540233660E+04, 5.0292818762E+03, 1.3795668691E+04, 3.2641303009E+03, 9.6778557800E-01],
	[3.93400E+04, 2.8546538300E+04, 5.0293034669E+03, 1.3801375020E+04, 3.2645412165E+03, 9.6779936336E-01],
	[3.93450E+04, 2.8552843531E+04, 5.0293250549E+03, 1.3807082983E+04, 3.2649520329E+03, 9.6781314179E-01],
	[3.93500E+04, 2.8559149353E+04, 5.0293466402E+03, 1.3812792579E+04, 3.2653627502E+03, 9.6782691329E-01],
	[3.93550E+04, 2.8565455766E+04, 5.0293682229E+03, 1.3818503808E+04, 3.2657733683E+03, 9.6784067786E-01],
	[3.93600E+04, 2.8571762771E+04, 5.0293898030E+03, 1.3824216671E+04, 3.2661838873E+03, 9.6785443551E-01],
	[3.93650E+04, 2.8578070366E+04, 5.0294113804E+03, 1.3829931169E+04, 3.2665943071E+03, 9.6786818625E-01],
	[3.93700E+04, 2.8584378553E+04, 5.0294329551E+03, 1.3835647300E+04, 3.2670046279E+03, 9.6788193006E-01],
	[3.93750E+04, 2.8590687331E+04, 5.0294545272E+03, 1.3841365067E+04, 3.2674148495E+03, 9.6789566697E-01],
	[3.93800E+04, 2.8596996700E+04, 5.0294760967E+03, 1.3847084468E+04, 3.2678249721E+03, 9.6790939697E-01],
	[3.93850E+04, 2.8603306660E+04, 5.0294976635E+03, 1.3852805504E+04, 3.2682349957E+03, 9.6792312007E-01],
	[3.93900E+04, 2.8609617211E+04, 5.0295192277E+03, 1.3858528176E+04, 3.2686449202E+03, 9.6793683627E-01],
	[3.93950E+04, 2.8615928352E+04, 5.0295407892E+03, 1.3864252484E+04, 3.2690547456E+03, 9.6795054557E-01],
	[3.94000E+04, 2.8622240085E+04, 5.0295623481E+03, 1.3869978427E+04, 3.2694644721E+03, 9.6796424799E-01],
	[3.94050E+04, 2.8628552409E+04, 5.0295839043E+03, 1.3875706007E+04, 3.2698740995E+03, 9.6797794351E-01],
	[3.94100E+04, 2.8634865324E+04, 5.0296054579E+03, 1.3881435223E+04, 3.2702836280E+03, 9.6799163216E-01],
	[3.94150E+04, 2.8641178830E+04, 5.0296270089E+03, 1.3887166076E+04, 3.2706930575E+03, 9.6800531392E-01],
	[3.94200E+04, 2.8647492926E+04, 5.0296485572E+03, 1.3892898565E+04, 3.2711023881E+03, 9.6801898881E-01],
	[3.94250E+04, 2.8653807614E+04, 5.0296701028E+03, 1.3898632692E+04, 3.2715116197E+03, 9.6803265682E-01],
	[3.94300E+04, 2.8660122892E+04, 5.0296916459E+03, 1.3904368457E+04, 3.2719207524E+03, 9.6804631797E-01],
	[3.94350E+04, 2.8666438761E+04, 5.0297131863E+03, 1.3910105859E+04, 3.2723297863E+03, 9.6805997226E-01],
	[3.94400E+04, 2.8672755222E+04, 5.0297347240E+03, 1.3915844899E+04, 3.2727387212E+03, 9.6807361968E-01],
	[3.94450E+04, 2.8679072272E+04, 5.0297562591E+03, 1.3921585577E+04, 3.2731475572E+03, 9.6808726025E-01],
	[3.94500E+04, 2.8685389914E+04, 5.0297777916E+03, 1.3927327894E+04, 3.2735562944E+03, 9.6810089397E-01],
	[3.94550E+04, 2.8691708146E+04, 5.0297993215E+03, 1.3933071850E+04, 3.2739649328E+03, 9.6811452083E-01],
	[3.94600E+04, 2.8698026970E+04, 5.0298208487E+03, 1.3938817445E+04, 3.2743734723E+03, 9.6812814086E-01],
	[3.94650E+04, 2.8704346384E+04, 5.0298423732E+03, 1.3944564679E+04, 3.2747819131E+03, 9.6814175404E-01],
	[3.94700E+04, 2.8710666388E+04, 5.0298638952E+03, 1.3950313552E+04, 3.2751902550E+03, 9.6815536038E-01],
	[3.94750E+04, 2.8716986983E+04, 5.0298854145E+03, 1.3956064066E+04, 3.2755984981E+03, 9.6816895990E-01],
	[3.94800E+04, 2.8723308169E+04, 5.0299069311E+03, 1.3961816219E+04, 3.2760066425E+03, 9.6818255258E-01],
	[3.94850E+04, 2.8729629946E+04, 5.0299284452E+03, 1.3967570013E+04, 3.2764146882E+03, 9.6819613844E-01],
	[3.94900E+04, 2.8735952313E+04, 5.0299499566E+03, 1.3973325448E+04, 3.2768226351E+03, 9.6820971748E-01],
	[3.94950E+04, 2.8742275271E+04, 5.0299714653E+03, 1.3979082523E+04, 3.2772304833E+03, 9.6822328970E-01],
	[3.95000E+04, 2.8748598820E+04, 5.0299929715E+03, 1.3984841239E+04, 3.2776382328E+03, 9.6823685510E-01],
	[3.95050E+04, 2.8754922959E+04, 5.0300144750E+03, 1.3990601597E+04, 3.2780458836E+03, 9.6825041370E-01],
	[3.95100E+04, 2.8761247688E+04, 5.0300359759E+03, 1.3996363596E+04, 3.2784534358E+03, 9.6826396549E-01],
	[3.95150E+04, 2.8767573008E+04, 5.0300574741E+03, 1.4002127238E+04, 3.2788608893E+03, 9.6827751048E-01],
	[3.95200E+04, 2.8773898919E+04, 5.0300789697E+03, 1.4007892521E+04, 3.2792682442E+03, 9.6829104867E-01],
	[3.95250E+04, 2.8780225420E+04, 5.0301004627E+03, 1.4013659447E+04, 3.2796755004E+03, 9.6830458007E-01],
	[3.95300E+04, 2.8786552512E+04, 5.0301219531E+03, 1.4019428016E+04, 3.2800826581E+03, 9.6831810467E-01],
	[3.95350E+04, 2.8792880194E+04, 5.0301434409E+03, 1.4025198227E+04, 3.2804897171E+03, 9.6833162249E-01],
	[3.95400E+04, 2.8799208466E+04, 5.0301649260E+03, 1.4030970082E+04, 3.2808966776E+03, 9.6834513353E-01],
	[3.95450E+04, 2.8805537329E+04, 5.0301864085E+03, 1.4036743580E+04, 3.2813035395E+03, 9.6835863778E-01],
	[3.95500E+04, 2.8811866783E+04, 5.0302078883E+03, 1.4042518721E+04, 3.2817103029E+03, 9.6837213527E-01],
	[3.95550E+04, 2.8818196826E+04, 5.0302293656E+03, 1.4048295507E+04, 3.2821169678E+03, 9.6838562598E-01],
	[3.95600E+04, 2.8824527460E+04, 5.0302508402E+03, 1.4054073937E+04, 3.2825235341E+03, 9.6839910992E-01],
	[3.95650E+04, 2.8830858685E+04, 5.0302723122E+03, 1.4059854012E+04, 3.2829300020E+03, 9.6841258710E-01],
	[3.95700E+04, 2.8837190499E+04, 5.0302937816E+03, 1.4065635731E+04, 3.2833363713E+03, 9.6842605752E-01],
	[3.95750E+04, 2.8843522904E+04, 5.0303152483E+03, 1.4071419095E+04, 3.2837426422E+03, 9.6843952119E-01],
	[3.95800E+04, 2.8849855900E+04, 5.0303367125E+03, 1.4077204104E+04, 3.2841488147E+03, 9.6845297810E-01],
	[3.95850E+04, 2.8856189485E+04, 5.0303581740E+03, 1.4082990759E+04, 3.2845548887E+03, 9.6846642826E-01],
	[3.95900E+04, 2.8862523661E+04, 5.0303796329E+03, 1.4088779060E+04, 3.2849608644E+03, 9.6847987168E-01],
	[3.95950E+04, 2.8868858427E+04, 5.0304010891E+03, 1.4094569007E+04, 3.2853667416E+03, 9.6849330836E-01],
	[3.96000E+04, 2.8875193783E+04, 5.0304225428E+03, 1.4100360600E+04, 3.2857725204E+03, 9.6850673830E-01],
	[3.96050E+04, 2.8881529729E+04, 5.0304439939E+03, 1.4106153840E+04, 3.2861782009E+03, 9.6852016151E-01],
	[3.96100E+04, 2.8887866266E+04, 5.0304654423E+03, 1.4111948726E+04, 3.2865837830E+03, 9.6853357800E-01],
	[3.96150E+04, 2.8894203393E+04, 5.0304868881E+03, 1.4117745260E+04, 3.2869892668E+03, 9.6854698775E-01],
	[3.96200E+04, 2.8900541109E+04, 5.0305083313E+03, 1.4123543441E+04, 3.2873946523E+03, 9.6856039079E-01],
	[3.96250E+04, 2.8906879416E+04, 5.0305297719E+03, 1.4129343269E+04, 3.2877999394E+03, 9.6857378710E-01],
	[3.96300E+04, 2.8913218313E+04, 5.0305512098E+03, 1.4135144746E+04, 3.2882051283E+03, 9.6858717670E-01],
	[3.96350E+04, 2.8919557800E+04, 5.0305726452E+03, 1.4140947870E+04, 3.2886102189E+03, 9.6860055960E-01],
	[3.96400E+04, 2.8925897877E+04, 5.0305940779E+03, 1.4146752643E+04, 3.2890152112E+03, 9.6861393578E-01],
	[3.96450E+04, 2.8932238545E+04, 5.0306155081E+03, 1.4152559064E+04, 3.2894201053E+03, 9.6862730527E-01],
	[3.96500E+04, 2.8938579802E+04, 5.0306369356E+03, 1.4158367135E+04, 3.2898249012E+03, 9.6864066806E-01],
	[3.96550E+04, 2.8944921649E+04, 5.0306583605E+03, 1.4164176854E+04, 3.2902295989E+03, 9.6865402415E-01],
	[3.96600E+04, 2.8951264086E+04, 5.0306797828E+03, 1.4169988223E+04, 3.2906341984E+03, 9.6866737355E-01],
	[3.96650E+04, 2.8957607113E+04, 5.0307012025E+03, 1.4175801242E+04, 3.2910386997E+03, 9.6868071626E-01],
	[3.96700E+04, 2.8963950730E+04, 5.0307226195E+03, 1.4181615910E+04, 3.2914431028E+03, 9.6869405229E-01],
	[3.96750E+04, 2.8970294937E+04, 5.0307440340E+03, 1.4187432229E+04, 3.2918474078E+03, 9.6870738164E-01],
	[3.96800E+04, 2.8976639734E+04, 5.0307654459E+03, 1.4193250198E+04, 3.2922516147E+03, 9.6872070432E-01],
	[3.96850E+04, 2.8982985120E+04, 5.0307868551E+03, 1.4199069818E+04, 3.2926557235E+03, 9.6873402032E-01],
	[3.96900E+04, 2.8989331097E+04, 5.0308082618E+03, 1.4204891089E+04, 3.2930597341E+03, 9.6874732965E-01],
	[3.96950E+04, 2.8995677663E+04, 5.0308296658E+03, 1.4210714011E+04, 3.2934636467E+03, 9.6876063232E-01],
	[3.97000E+04, 2.9002024819E+04, 5.0308510673E+03, 1.4216538585E+04, 3.2938674612E+03, 9.6877392834E-01],
	[3.97050E+04, 2.9008372565E+04, 5.0308724661E+03, 1.4222364810E+04, 3.2942711777E+03, 9.6878721769E-01],
	[3.97100E+04, 2.9014720901E+04, 5.0308938623E+03, 1.4228192688E+04, 3.2946747962E+03, 9.6880050039E-01],
	[3.97150E+04, 2.9021069826E+04, 5.0309152560E+03, 1.4234022217E+04, 3.2950783166E+03, 9.6881377644E-01],
	[3.97200E+04, 2.9027419341E+04, 5.0309366470E+03, 1.4239853399E+04, 3.2954817390E+03, 9.6882704585E-01],
	[3.97250E+04, 2.9033769446E+04, 5.0309580354E+03, 1.4245686234E+04, 3.2958850635E+03, 9.6884030861E-01],
	[3.97300E+04, 2.9040120141E+04, 5.0309794213E+03, 1.4251520722E+04, 3.2962882899E+03, 9.6885356474E-01],
	[3.97350E+04, 2.9046471425E+04, 5.0310008045E+03, 1.4257356864E+04, 3.2966914185E+03, 9.6886681423E-01],
	[3.97400E+04, 2.9052823299E+04, 5.0310221851E+03, 1.4263194658E+04, 3.2970944491E+03, 9.6888005710E-01],
	[3.97450E+04, 2.9059175762E+04, 5.0310435631E+03, 1.4269034107E+04, 3.2974973817E+03, 9.6889329333E-01],
	[3.97500E+04, 2.9065528815E+04, 5.0310649386E+03, 1.4274875210E+04, 3.2979002165E+03, 9.6890652295E-01],
	[3.97550E+04, 2.9071882458E+04, 5.0310863114E+03, 1.4280717967E+04, 3.2983029534E+03, 9.6891974594E-01],
	[3.97600E+04, 2.9078236690E+04, 5.0311076816E+03, 1.4286562379E+04, 3.2987055924E+03, 9.6893296232E-01],
	[3.97650E+04, 2.9084591512E+04, 5.0311290493E+03, 1.4292408445E+04, 3.2991081335E+03, 9.6894617209E-01],
	[3.97700E+04, 2.9090946924E+04, 5.0311504143E+03, 1.4298256167E+04, 3.2995105769E+03, 9.6895937526E-01],
	[3.97750E+04, 2.9097302925E+04, 5.0311717767E+03, 1.4304105544E+04, 3.2999129224E+03, 9.6897257181E-01],
	[3.97800E+04, 2.9103659515E+04, 5.0311931366E+03, 1.4309956577E+04, 3.3003151700E+03, 9.6898576177E-01],
	[3.97850E+04, 2.9110016695E+04, 5.0312144938E+03, 1.4315809266E+04, 3.3007173200E+03, 9.6899894513E-01],
	[3.97900E+04, 2.9116374464E+04, 5.0312358485E+03, 1.4321663611E+04, 3.3011193721E+03, 9.6901212190E-01],
	[3.97950E+04, 2.9122732823E+04, 5.0312572006E+03, 1.4327519612E+04, 3.3015213264E+03, 9.6902529208E-01],
	[3.98000E+04, 2.9129091771E+04, 5.0312785501E+03, 1.4333377270E+04, 3.3019231831E+03, 9.6903845568E-01],
	[3.98050E+04, 2.9135451309E+04, 5.0312998969E+03, 1.4339236585E+04, 3.3023249420E+03, 9.6905161270E-01],
	[3.98100E+04, 2.9141811436E+04, 5.0313212412E+03, 1.4345097557E+04, 3.3027266032E+03, 9.6906476313E-01],
	[3.98150E+04, 2.9148172152E+04, 5.0313425829E+03, 1.4350960186E+04, 3.3031281667E+03, 9.6907790700E-01],
	[3.98200E+04, 2.9154533458E+04, 5.0313639221E+03, 1.4356824474E+04, 3.3035296325E+03, 9.6909104429E-01],
	[3.98250E+04, 2.9160895353E+04, 5.0313852586E+03, 1.4362690419E+04, 3.3039310007E+03, 9.6910417502E-01],
	[3.98300E+04, 2.9167257837E+04, 5.0314065925E+03, 1.4368558023E+04, 3.3043322712E+03, 9.6911729919E-01],
	[3.98350E+04, 2.9173620911E+04, 5.0314279239E+03, 1.4374427285E+04, 3.3047334441E+03, 9.6913041679E-01],
	[3.98400E+04, 2.9179984574E+04, 5.0314492526E+03, 1.4380298205E+04, 3.3051345194E+03, 9.6914352785E-01],
	[3.98450E+04, 2.9186348826E+04, 5.0314705788E+03, 1.4386170785E+04, 3.3055354971E+03, 9.6915663235E-01],
	[3.98500E+04, 2.9192713667E+04, 5.0314919024E+03, 1.4392045024E+04, 3.3059363772E+03, 9.6916973030E-01],
	[3.98550E+04, 2.9199079098E+04, 5.0315132234E+03, 1.4397920923E+04, 3.3063371597E+03, 9.6918282171E-01],
	[3.98600E+04, 2.9205445118E+04, 5.0315345419E+03, 1.4403798481E+04, 3.3067378447E+03, 9.6919590659E-01],
	[3.98650E+04, 2.9211811727E+04, 5.0315558577E+03, 1.4409677700E+04, 3.3071384322E+03, 9.6920898492E-01],
	[3.98700E+04, 2.9218178925E+04, 5.0315771710E+03, 1.4415558579E+04, 3.3075389222E+03, 9.6922205672E-01],
	[3.98750E+04, 2.9224546712E+04, 5.0315984816E+03, 1.4421441118E+04, 3.3079393146E+03, 9.6923512200E-01],
	[3.98800E+04, 2.9230915088E+04, 5.0316197897E+03, 1.4427325318E+04, 3.3083396096E+03, 9.6924818075E-01],
	[3.98850E+04, 2.9237284054E+04, 5.0316410952E+03, 1.4433211180E+04, 3.3087398071E+03, 9.6926123298E-01],
	[3.98900E+04, 2.9243653608E+04, 5.0316623982E+03, 1.4439098702E+04, 3.3091399072E+03, 9.6927427869E-01],
	[3.98950E+04, 2.9250023752E+04, 5.0316836985E+03, 1.4444987887E+04, 3.3095399098E+03, 9.6928731788E-01],
	[3.99000E+04, 2.9256394484E+04, 5.0317049963E+03, 1.4450878733E+04, 3.3099398151E+03, 9.6930035057E-01],
	[3.99050E+04, 2.9262765806E+04, 5.0317262915E+03, 1.4456771241E+04, 3.3103396229E+03, 9.6931337675E-01],
	[3.99100E+04, 2.9269137717E+04, 5.0317475841E+03, 1.4462665412E+04, 3.3107393333E+03, 9.6932639643E-01],
	[3.99150E+04, 2.9275510216E+04, 5.0317688741E+03, 1.4468561246E+04, 3.3111389464E+03, 9.6933940961E-01],
	[3.99200E+04, 2.9281883305E+04, 5.0317901616E+03, 1.4474458742E+04, 3.3115384622E+03, 9.6935241630E-01],
	[3.99250E+04, 2.9288256982E+04, 5.0318114465E+03, 1.4480357901E+04, 3.3119378806E+03, 9.6936541649E-01],
	[3.99300E+04, 2.9294631248E+04, 5.0318327288E+03, 1.4486258724E+04, 3.3123372016E+03, 9.6937841020E-01],
	[3.99350E+04, 2.9301006104E+04, 5.0318540085E+03, 1.4492161211E+04, 3.3127364254E+03, 9.6939139742E-01],
	[3.99400E+04, 2.9307381548E+04, 5.0318752857E+03, 1.4498065362E+04, 3.3131355519E+03, 9.6940437816E-01],
	[3.99450E+04, 2.9313757581E+04, 5.0318965603E+03, 1.4503971177E+04, 3.3135345811E+03, 9.6941735243E-01],
	[3.99500E+04, 2.9320134203E+04, 5.0319178323E+03, 1.4509878656E+04, 3.3139335131E+03, 9.6943032022E-01],
	[3.99550E+04, 2.9326511413E+04, 5.0319391017E+03, 1.4515787800E+04, 3.3143323479E+03, 9.6944328155E-01],
	[3.99600E+04, 2.9332889213E+04, 5.0319603686E+03, 1.4521698609E+04, 3.3147310854E+03, 9.6945623641E-01],
	[3.99650E+04, 2.9339267601E+04, 5.0319816329E+03, 1.4527611083E+04, 3.3151297257E+03, 9.6946918481E-01],
	[3.99700E+04, 2.9345646578E+04, 5.0320028947E+03, 1.4533525223E+04, 3.3155282688E+03, 9.6948212675E-01],
	[3.99750E+04, 2.9352026144E+04, 5.0320241538E+03, 1.4539441029E+04, 3.3159267148E+03, 9.6949506223E-01],
	[3.99800E+04, 2.9358406298E+04, 5.0320454104E+03, 1.4545358501E+04, 3.3163250636E+03, 9.6950799127E-01],
	[3.99850E+04, 2.9364787042E+04, 5.0320666644E+03, 1.4551277639E+04, 3.3167233153E+03, 9.6952091386E-01],
	[3.99900E+04, 2.9371168374E+04, 5.0320879159E+03, 1.4557198443E+04, 3.3171214699E+03, 9.6953383000E-01],
	[3.99950E+04, 2.9377550294E+04, 5.0321091648E+03, 1.4563120915E+04, 3.3175195274E+03, 9.6954673971E-01],
	[4.00000E+04, 2.9383932803E+04, 5.0321304111E+03, 1.4569045053E+04, 3.3179174877E+03, 9.6955964298E-01],
	[4.00050E+04, 2.9390315901E+04, 5.0321516548E+03, 1.4574978276E+04, 3.3183157355E+03, 9.6957253982E-01],
	[4.00100E+04, 2.9396699587E+04, 5.0321728960E+03, 1.4580913171E+04, 3.3187138860E+03, 9.6958543023E-01],
	[4.00150E+04, 2.9403083863E+04, 5.0321941347E+03, 1.4586849740E+04, 3.3191119394E+03, 9.6959831422E-01],
	[4.00200E+04, 2.9409468726E+04, 5.0322153707E+03, 1.4592787981E+04, 3.3195098955E+03, 9.6961119178E-01],
	[4.00250E+04, 2.9415854178E+04, 5.0322366042E+03, 1.4598727897E+04, 3.3199077544E+03, 9.6962406293E-01],
	[4.00300E+04, 2.9422240219E+04, 5.0322578352E+03, 1.4604669485E+04, 3.3203055162E+03, 9.6963692767E-01],
	[4.00350E+04, 2.9428626848E+04, 5.0322790635E+03, 1.4610612748E+04, 3.3207031808E+03, 9.6964978599E-01],
	[4.00400E+04, 2.9435014066E+04, 5.0323002893E+03, 1.4616557685E+04, 3.3211007483E+03, 9.6966263791E-01],
	[4.00450E+04, 2.9441401872E+04, 5.0323215126E+03, 1.4622504297E+04, 3.3214982187E+03, 9.6967548343E-01],
	[4.00500E+04, 2.9447790266E+04, 5.0323427333E+03, 1.4628452584E+04, 3.3218955920E+03, 9.6968832255E-01],
	[4.00550E+04, 2.9454179250E+04, 5.0323639514E+03, 1.4634402545E+04, 3.3222928682E+03, 9.6970115527E-01],
	[4.00600E+04, 2.9460568821E+04, 5.0323851670E+03, 1.4640354182E+04, 3.3226900474E+03, 9.6971398160E-01],
	[4.00650E+04, 2.9466958981E+04, 5.0324063800E+03, 1.4646307494E+04, 3.3230871295E+03, 9.6972680155E-01],
	[4.00700E+04, 2.9473349729E+04, 5.0324275905E+03, 1.4652262483E+04, 3.3234841146E+03, 9.6973961511E-01],
	[4.00750E+04, 2.9479741066E+04, 5.0324487984E+03, 1.4658219147E+04, 3.3238810026E+03, 9.6975242229E-01],
	[4.00800E+04, 2.9486132991E+04, 5.0324700037E+03, 1.4664177488E+04, 3.3242777937E+03, 9.6976522309E-01],
	[4.00850E+04, 2.9492525504E+04, 5.0324912065E+03, 1.4670137505E+04, 3.3246744878E+03, 9.6977801752E-01],
	[4.00900E+04, 2.9498918605E+04, 5.0325124067E+03, 1.4676099199E+04, 3.3250710849E+03, 9.6979080558E-01],
	[4.00950E+04, 2.9505312295E+04, 5.0325336044E+03, 1.4682062571E+04, 3.3254675851E+03, 9.6980358728E-01],
	[4.01000E+04, 2.9511706573E+04, 5.0325547995E+03, 1.4688027620E+04, 3.3258639883E+03, 9.6981636261E-01],
	[4.01050E+04, 2.9518101440E+04, 5.0325759921E+03, 1.4693994346E+04, 3.3262602946E+03, 9.6982913158E-01],
	[4.01100E+04, 2.9524496894E+04, 5.0325971821E+03, 1.4699962751E+04, 3.3266565041E+03, 9.6984189421E-01],
	[4.01150E+04, 2.9530892937E+04, 5.0326183696E+03, 1.4705932833E+04, 3.3270526166E+03, 9.6985465047E-01],
	[4.01200E+04, 2.9537289568E+04, 5.0326395545E+03, 1.4711904594E+04, 3.3274486323E+03, 9.6986740040E-01],
	[4.01250E+04, 2.9543686787E+04, 5.0326607368E+03, 1.4717878034E+04, 3.3278445512E+03, 9.6988014398E-01],
	[4.01300E+04, 2.9550084594E+04, 5.0326819166E+03, 1.4723853153E+04, 3.3282403732E+03, 9.6989288121E-01],
	[4.01350E+04, 2.9556482989E+04, 5.0327030939E+03, 1.4729829951E+04, 3.3286360984E+03, 9.6990561212E-01],
	[4.01400E+04, 2.9562881973E+04, 5.0327242686E+03, 1.4735808428E+04, 3.3290317268E+03, 9.6991833669E-01],
	[4.01450E+04, 2.9569297018E+04, 5.0327479349E+03, 1.4741788586E+04, 3.3294285461E+03, 9.6993105493E-01],
	[4.01500E+04, 2.9575732635E+04, 5.0327748183E+03, 1.4747770423E+04, 3.3298269319E+03, 9.6994376684E-01],
	[4.01550E+04, 2.9582168852E+04, 5.0328016985E+03, 1.4753753941E+04, 3.3302252217E+03, 9.6995647244E-01],
	[4.01600E+04, 2.9588605668E+04, 5.0328285755E+03, 1.4759739139E+04, 3.3306234157E+03, 9.6996917171E-01],
	[4.01650E+04, 2.9595043083E+04, 5.0328554493E+03, 1.4765726018E+04, 3.3310215137E+03, 9.6998186467E-01],
	[4.01700E+04, 2.9601481097E+04, 5.0328823199E+03, 1.4771714578E+04, 3.3314195159E+03, 9.6999455132E-01],
	[4.01750E+04, 2.9607919710E+04, 5.0329091873E+03, 1.4777704819E+04, 3.3318174222E+03, 9.7000723166E-01],
	[4.01800E+04, 2.9614358922E+04, 5.0329360516E+03, 1.4783696742E+04, 3.3322152326E+03, 9.7001990570E-01],
	[4.01850E+04, 2.9620798732E+04, 5.0329629126E+03, 1.4789690347E+04, 3.3326129473E+03, 9.7003257344E-01],
	[4.01900E+04, 2.9627239142E+04, 5.0329897704E+03, 1.4795685634E+04, 3.3330105661E+03, 9.7004523489E-01],
	[4.01950E+04, 2.9633680150E+04, 5.0330166250E+03, 1.4801682604E+04, 3.3334080891E+03, 9.7005789004E-01],
	[4.02000E+04, 2.9640121758E+04, 5.0330434764E+03, 1.4807681256E+04, 3.3338055164E+03, 9.7007053890E-01],
	[4.02050E+04, 2.9646563964E+04, 5.0330703246E+03, 1.4813681591E+04, 3.3342028479E+03, 9.7008318147E-01],
	[4.02100E+04, 2.9653006769E+04, 5.0330971696E+03, 1.4819683609E+04, 3.3346000836E+03, 9.7009581777E-01],
	[4.02150E+04, 2.9659450172E+04, 5.0331240114E+03, 1.4825687310E+04, 3.3349972236E+03, 9.7010844778E-01],
	[4.02200E+04, 2.9665894175E+04, 5.0331508501E+03, 1.4831692696E+04, 3.3353942679E+03, 9.7012107153E-01],
	[4.02250E+04, 2.9672338776E+04, 5.0331776855E+03, 1.4837699765E+04, 3.3357912165E+03, 9.7013368900E-01],
	[4.02300E+04, 2.9678783976E+04, 5.0332045177E+03, 1.4843708518E+04, 3.3361880695E+03, 9.7014630020E-01],
	[4.02350E+04, 2.9685229775E+04, 5.0332313468E+03, 1.4849718956E+04, 3.3365848267E+03, 9.7015890514E-01],
	[4.02400E+04, 2.9691676172E+04, 5.0332581727E+03, 1.4855731079E+04, 3.3369814883E+03, 9.7017150382E-01],
	[4.02450E+04, 2.9698123169E+04, 5.0332849953E+03, 1.4861744887E+04, 3.3373780543E+03, 9.7018409624E-01],
	[4.02500E+04, 2.9704570763E+04, 5.0333118148E+03, 1.4867760380E+04, 3.3377745247E+03, 9.7019668241E-01],
	[4.02550E+04, 2.9711018957E+04, 5.0333386311E+03, 1.4873777558E+04, 3.3381708995E+03, 9.7020926234E-01],
	[4.02600E+04, 2.9717467749E+04, 5.0333654442E+03, 1.4879796422E+04, 3.3385671787E+03, 9.7022183601E-01],
	[4.02650E+04, 2.9723917140E+04, 5.0333922541E+03, 1.4885816973E+04, 3.3389633623E+03, 9.7023440345E-01],
	[4.02700E+04, 2.9730367129E+04, 5.0334190609E+03, 1.4891839209E+04, 3.3393594504E+03, 9.7024696464E-01],
	[4.02750E+04, 2.9736817717E+04, 5.0334458644E+03, 1.4897863133E+04, 3.3397554430E+03, 9.7025951960E-01],
	[4.02800E+04, 2.9743268903E+04, 5.0334726648E+03, 1.4903888743E+04, 3.3401513400E+03, 9.7027206833E-01],
	[4.02850E+04, 2.9749720688E+04, 5.0334994620E+03, 1.4909916040E+04, 3.3405471416E+03, 9.7028461083E-01],
	[4.02900E+04, 2.9756173071E+04, 5.0335262560E+03, 1.4915945025E+04, 3.3409428476E+03, 9.7029714711E-01],
	[4.02950E+04, 2.9762626053E+04, 5.0335530468E+03, 1.4921975697E+04, 3.3413384582E+03, 9.7030967717E-01],
	[4.03000E+04, 2.9769079634E+04, 5.0335798344E+03, 1.4928008057E+04, 3.3417339734E+03, 9.7032220101E-01],
	[4.03050E+04, 2.9775533813E+04, 5.0336066189E+03, 1.4934042105E+04, 3.3421293931E+03, 9.7033471864E-01],
	[4.03100E+04, 2.9781988590E+04, 5.0336334001E+03, 1.4940077842E+04, 3.3425247174E+03, 9.7034723006E-01],
	[4.03150E+04, 2.9788443966E+04, 5.0336601782E+03, 1.4946115267E+04, 3.3429199463E+03, 9.7035973527E-01],
	[4.03200E+04, 2.9794899940E+04, 5.0336869531E+03, 1.4952154382E+04, 3.3433150799E+03, 9.7037223428E-01],
	[4.03250E+04, 2.9801356512E+04, 5.0337137249E+03, 1.4958195185E+04, 3.3437101180E+03, 9.7038472709E-01],
	[4.03300E+04, 2.9807813683E+04, 5.0337404934E+03, 1.4964237678E+04, 3.3441050609E+03, 9.7039721371E-01],
	[4.03350E+04, 2.9814271453E+04, 5.0337672588E+03, 1.4970281861E+04, 3.3444999083E+03, 9.7040969413E-01],
	[4.03400E+04, 2.9820729820E+04, 5.0337940210E+03, 1.4976327734E+04, 3.3448946605E+03, 9.7042216837E-01],
	[4.03450E+04, 2.9827188786E+04, 5.0338207801E+03, 1.4982375297E+04, 3.3452893174E+03, 9.7043463641E-01],
	[4.03500E+04, 2.9833648350E+04, 5.0338475359E+03, 1.4988424550E+04, 3.3456838790E+03, 9.7044709828E-01],
	[4.03550E+04, 2.9840108513E+04, 5.0338742886E+03, 1.4994475494E+04, 3.3460783453E+03, 9.7045955396E-01],
	[4.03600E+04, 2.9846569273E+04, 5.0339010381E+03, 1.5000528130E+04, 3.3464727164E+03, 9.7047200346E-01],
	[4.03650E+04, 2.9853030632E+04, 5.0339277845E+03, 1.5006582456E+04, 3.3468669922E+03, 9.7048444679E-01],
	[4.03700E+04, 2.9859492589E+04, 5.0339545276E+03, 1.5012638474E+04, 3.3472611729E+03, 9.7049688395E-01],
	[4.03750E+04, 2.9865955145E+04, 5.0339812676E+03, 1.5018696184E+04, 3.3476552583E+03, 9.7050931494E-01],
	[4.03800E+04, 2.9872418298E+04, 5.0340080045E+03, 1.5024755587E+04, 3.3480492485E+03, 9.7052173976E-01],
	[4.03850E+04, 2.9878882050E+04, 5.0340347381E+03, 1.5030816681E+04, 3.3484431436E+03, 9.7053415843E-01],
	[4.03900E+04, 2.9885346400E+04, 5.0340614686E+03, 1.5036879468E+04, 3.3488369436E+03, 9.7054657093E-01],
	[4.03950E+04, 2.9891811348E+04, 5.0340881959E+03, 1.5042943948E+04, 3.3492306484E+03, 9.7055897728E-01],
	[4.04000E+04, 2.9898276894E+04, 5.0341149201E+03, 1.5049010121E+04, 3.3496242581E+03, 9.7057137748E-01],
	[4.04050E+04, 2.9904743038E+04, 5.0341416411E+03, 1.5055077988E+04, 3.3500177727E+03, 9.7058377153E-01],
	[4.04100E+04, 2.9911209780E+04, 5.0341683589E+03, 1.5061147548E+04, 3.3504111922E+03, 9.7059615944E-01],
	[4.04150E+04, 2.9917677120E+04, 5.0341950736E+03, 1.5067218802E+04, 3.3508045166E+03, 9.7060854120E-01],
	[4.04200E+04, 2.9924145059E+04, 5.0342217851E+03, 1.5073291750E+04, 3.3511977460E+03, 9.7062091682E-01],
	[4.04250E+04, 2.9930613595E+04, 5.0342484935E+03, 1.5079366393E+04, 3.3515908804E+03, 9.7063328631E-01],
	[4.04300E+04, 2.9937082729E+04, 5.0342751986E+03, 1.5085442730E+04, 3.3519839198E+03, 9.7064564966E-01],
	[4.04350E+04, 2.9943552461E+04, 5.0343019007E+03, 1.5091520763E+04, 3.3523768641E+03, 9.7065800688E-01],
	[4.04400E+04, 2.9950022792E+04, 5.0343285995E+03, 1.5097600490E+04, 3.3527697135E+03, 9.7067035798E-01],
	[4.04450E+04, 2.9956493720E+04, 5.0343552952E+03, 1.5103681913E+04, 3.3531624679E+03, 9.7068270296E-01],
	[4.04500E+04, 2.9962965246E+04, 5.0343819878E+03, 1.5109765032E+04, 3.3535551274E+03, 9.7069504181E-01],
	[4.04550E+04, 2.9969437370E+04, 5.0344086772E+03, 1.5115849847E+04, 3.3539476919E+03, 9.7070737455E-01],
	[4.04600E+04, 2.9975910092E+04, 5.0344353634E+03, 1.5121936358E+04, 3.3543401616E+03, 9.7071970118E-01],
	[4.04650E+04, 2.9982383411E+04, 5.0344620465E+03, 1.5128024566E+04, 3.3547325363E+03, 9.7073202169E-01],
	[4.04700E+04, 2.9988857329E+04, 5.0344887264E+03, 1.5134114471E+04, 3.3551248161E+03, 9.7074433610E-01],
	[4.04750E+04, 2.9995331844E+04, 5.0345154031E+03, 1.5140206072E+04, 3.3555170011E+03, 9.7075664440E-01],
	[4.04800E+04, 3.0001806957E+04, 5.0345420767E+03, 1.5146299371E+04, 3.3559090912E+03, 9.7076894661E-01],
	[4.04850E+04, 3.0008282668E+04, 5.0345687472E+03, 1.5152394368E+04, 3.3563010866E+03, 9.7078124271E-01],
	[4.04900E+04, 3.0014758977E+04, 5.0345954145E+03, 1.5158491063E+04, 3.3566929871E+03, 9.7079353272E-01],
	[4.04950E+04, 3.0021235883E+04, 5.0346220787E+03, 1.5164589455E+04, 3.3570847928E+03, 9.7080581664E-01],
	[4.05000E+04, 3.0027713388E+04, 5.0346487397E+03, 1.5170689546E+04, 3.3574765037E+03, 9.7081809448E-01],
	[4.05050E+04, 3.0034191489E+04, 5.0346753975E+03, 1.5176791336E+04, 3.3578681198E+03, 9.7083036622E-01],
	[4.05100E+04, 3.0040670189E+04, 5.0347020522E+03, 1.5182894824E+04, 3.3582596412E+03, 9.7084263189E-01],
	[4.05150E+04, 3.0047149486E+04, 5.0347287038E+03, 1.5189000012E+04, 3.3586510679E+03, 9.7085489148E-01],
	[4.05200E+04, 3.0053629381E+04, 5.0347553522E+03, 1.5195106899E+04, 3.3590423999E+03, 9.7086714499E-01],
	[4.05250E+04, 3.0060109874E+04, 5.0347819974E+03, 1.5201215486E+04, 3.3594336372E+03, 9.7087939243E-01],
	[4.05300E+04, 3.0066590964E+04, 5.0348086395E+03, 1.5207325773E+04, 3.3598247798E+03, 9.7089163381E-01],
	[4.05350E+04, 3.0073072652E+04, 5.0348352785E+03, 1.5213437760E+04, 3.3602158277E+03, 9.7090386911E-01],
	[4.05400E+04, 3.0079554937E+04, 5.0348619143E+03, 1.5219551448E+04, 3.3606067810E+03, 9.7091609836E-01],
	[4.05450E+04, 3.0086037820E+04, 5.0348885470E+03, 1.5225666836E+04, 3.3609976397E+03, 9.7092832155E-01],
	[4.05500E+04, 3.0092521301E+04, 5.0349151765E+03, 1.5231783925E+04, 3.3613884037E+03, 9.7094053868E-01],
	[4.05550E+04, 3.0099005379E+04, 5.0349418029E+03, 1.5237902716E+04, 3.3617790732E+03, 9.7095274975E-01],
	[4.05600E+04, 3.0105490054E+04, 5.0349684262E+03, 1.5244023208E+04, 3.3621696481E+03, 9.7096495478E-01],
	[4.05650E+04, 3.0111975327E+04, 5.0349950463E+03, 1.5250145402E+04, 3.3625601284E+03, 9.7097715376E-01],
	[4.05700E+04, 3.0118461197E+04, 5.0350216632E+03, 1.5256269298E+04, 3.3629505142E+03, 9.7098934670E-01],
	[4.05750E+04, 3.0124947665E+04, 5.0350482771E+03, 1.5262394896E+04, 3.3633408055E+03, 9.7100153360E-01],
	[4.05800E+04, 3.0131434731E+04, 5.0350748878E+03, 1.5268522197E+04, 3.3637310022E+03, 9.7101371446E-01],
	[4.05850E+04, 3.0137922393E+04, 5.0351014953E+03, 1.5274651201E+04, 3.3641211045E+03, 9.7102588929E-01],
	[4.05900E+04, 3.0144410654E+04, 5.0351280997E+03, 1.5280781908E+04, 3.3645111123E+03, 9.7103805809E-01],
	[4.05950E+04, 3.0150899511E+04, 5.0351547010E+03, 1.5286914318E+04, 3.3649010256E+03, 9.7105022086E-01],
	[4.06000E+04, 3.0157388966E+04, 5.0351812991E+03, 1.5293048432E+04, 3.3652908445E+03, 9.7106237760E-01],
	[4.06050E+04, 3.0163879018E+04, 5.0352078942E+03, 1.5299184250E+04, 3.3656805690E+03, 9.7107452833E-01],
	[4.06100E+04, 3.0170369668E+04, 5.0352344860E+03, 1.5305321772E+04, 3.3660701990E+03, 9.7108667304E-01],
	[4.06150E+04, 3.0176860915E+04, 5.0352610748E+03, 1.5311460998E+04, 3.3664597347E+03, 9.7109881173E-01],
	[4.06200E+04, 3.0183352759E+04, 5.0352876604E+03, 1.5317601929E+04, 3.3668491760E+03, 9.7111094441E-01],
	[4.06250E+04, 3.0189845200E+04, 5.0353142429E+03, 1.5323744565E+04, 3.3672385229E+03, 9.7112307109E-01],
	[4.06300E+04, 3.0196338239E+04, 5.0353408222E+03, 1.5329888907E+04, 3.3676277755E+03, 9.7113519176E-01],
	[4.06350E+04, 3.0202831875E+04, 5.0353673984E+03, 1.5336034953E+04, 3.3680169338E+03, 9.7114730642E-01],
	[4.06400E+04, 3.0209326108E+04, 5.0353939715E+03, 1.5342182706E+04, 3.3684059978E+03, 9.7115941509E-01],
	[4.06450E+04, 3.0215820938E+04, 5.0354205414E+03, 1.5348332164E+04, 3.3687949675E+03, 9.7117151777E-01],
	[4.06500E+04, 3.0222316365E+04, 5.0354471083E+03, 1.5354483329E+04, 3.3691838429E+03, 9.7118361445E-01],
	[4.06550E+04, 3.0228812390E+04, 5.0354736720E+03, 1.5360636201E+04, 3.3695726241E+03, 9.7119570514E-01],
	[4.06600E+04, 3.0235309012E+04, 5.0355002325E+03, 1.5366790779E+04, 3.3699613110E+03, 9.7120778985E-01],
	[4.06650E+04, 3.0241806231E+04, 5.0355267900E+03, 1.5372947064E+04, 3.3703499037E+03, 9.7121986857E-01],
	[4.06700E+04, 3.0248304047E+04, 5.0355533443E+03, 1.5379105056E+04, 3.3707384022E+03, 9.7123194131E-01],
	[4.06750E+04, 3.0254802460E+04, 5.0355798955E+03, 1.5385264756E+04, 3.3711268066E+03, 9.7124400808E-01],
	[4.06800E+04, 3.0261301470E+04, 5.0356064436E+03, 1.5391426164E+04, 3.3715151167E+03, 9.7125606888E-01],
	[4.06850E+04, 3.0267801077E+04, 5.0356329885E+03, 1.5397589280E+04, 3.3719033327E+03, 9.7126812370E-01],
	[4.06900E+04, 3.0274301281E+04, 5.0356595304E+03, 1.5403754105E+04, 3.3722914546E+03, 9.7128017256E-01],
	[4.06950E+04, 3.0280802082E+04, 5.0356860691E+03, 1.5409920638E+04, 3.3726794823E+03, 9.7129221545E-01],
	[4.07000E+04, 3.0287303480E+04, 5.0357126047E+03, 1.5416088880E+04, 3.3730674160E+03, 9.7130425238E-01],
	[4.07050E+04, 3.0293805475E+04, 5.0357391371E+03, 1.5422258831E+04, 3.3734552556E+03, 9.7131628336E-01],
	[4.07100E+04, 3.0300308067E+04, 5.0357656665E+03, 1.5428430491E+04, 3.3738430011E+03, 9.7132830838E-01],
	[4.07150E+04, 3.0306811256E+04, 5.0357921927E+03, 1.5434603861E+04, 3.3742306525E+03, 9.7134032745E-01],
	[4.07200E+04, 3.0313315042E+04, 5.0358187158E+03, 1.5440778942E+04, 3.3746182099E+03, 9.7135234058E-01],
	[4.07250E+04, 3.0319819425E+04, 5.0358452358E+03, 1.5446955732E+04, 3.3750056734E+03, 9.7136434775E-01],
	[4.07300E+04, 3.0326324405E+04, 5.0358717527E+03, 1.5453134233E+04, 3.3753930428E+03, 9.7137634899E-01],
	[4.07350E+04, 3.0332829981E+04, 5.0358982664E+03, 1.5459314444E+04, 3.3757803182E+03, 9.7138834429E-01],
	[4.07400E+04, 3.0339336155E+04, 5.0359247771E+03, 1.5465496367E+04, 3.3761674997E+03, 9.7140033365E-01],
	[4.07450E+04, 3.0345842925E+04, 5.0359512846E+03, 1.5471680001E+04, 3.3765545872E+03, 9.7141231708E-01],
	[4.07500E+04, 3.0352350292E+04, 5.0359777890E+03, 1.5477865346E+04, 3.3769415808E+03, 9.7142429459E-01],
	[4.07550E+04, 3.0358858255E+04, 5.0360042904E+03, 1.5484052403E+04, 3.3773284805E+03, 9.7143626616E-01],
	[4.07600E+04, 3.0365366816E+04, 5.0360307886E+03, 1.5490241172E+04, 3.3777152863E+03, 9.7144823182E-01],
	[4.07650E+04, 3.0371875973E+04, 5.0360572836E+03, 1.5496431654E+04, 3.3781019982E+03, 9.7146019155E-01],
	[4.07700E+04, 3.0378385727E+04, 5.0360837756E+03, 1.5502623848E+04, 3.3784886163E+03, 9.7147214537E-01],
	[4.07750E+04, 3.0384896078E+04, 5.0361102645E+03, 1.5508817755E+04, 3.3788751405E+03, 9.7148409327E-01],
	[4.07800E+04, 3.0391407025E+04, 5.0361367502E+03, 1.5515013375E+04, 3.3792615709E+03, 9.7149603527E-01],
	[4.07850E+04, 3.0397918569E+04, 5.0361632329E+03, 1.5521210708E+04, 3.3796479075E+03, 9.7150797136E-01],
	[4.07900E+04, 3.0404430710E+04, 5.0361897124E+03, 1.5527409755E+04, 3.3800341502E+03, 9.7151990154E-01],
	[4.07950E+04, 3.0410943448E+04, 5.0362161889E+03, 1.5533610516E+04, 3.3804202993E+03, 9.7153182583E-01],
	[4.08000E+04, 3.0417456782E+04, 5.0362426622E+03, 1.5539812991E+04, 3.3808063545E+03, 9.7154374421E-01],
	[4.08050E+04, 3.0423970712E+04, 5.0362691324E+03, 1.5546017181E+04, 3.3811923160E+03, 9.7155565671E-01],
	[4.08100E+04, 3.0430485239E+04, 5.0362955995E+03, 1.5552223085E+04, 3.3815781838E+03, 9.7156756331E-01],
	[4.08150E+04, 3.0437000363E+04, 5.0363220636E+03, 1.5558430704E+04, 3.3819639579E+03, 9.7157946402E-01],
	[4.08200E+04, 3.0443516083E+04, 5.0363485245E+03, 1.5564640039E+04, 3.3823496384E+03, 9.7159135885E-01],
	[4.08250E+04, 3.0450032400E+04, 5.0363749823E+03, 1.5570851088E+04, 3.3827352251E+03, 9.7160324780E-01],
	[4.08300E+04, 3.0456549313E+04, 5.0364014370E+03, 1.5577063854E+04, 3.3831207182E+03, 9.7161513087E-01],
	[4.08350E+04, 3.0463066823E+04, 5.0364278886E+03, 1.5583278335E+04, 3.3835061176E+03, 9.7162700806E-01],
	[4.08400E+04, 3.0469584929E+04, 5.0364543371E+03, 1.5589494533E+04, 3.3838914235E+03, 9.7163887938E-01],
	[4.08450E+04, 3.0476103632E+04, 5.0364807825E+03, 1.5595712448E+04, 3.3842766357E+03, 9.7165074483E-01],
	[4.08500E+04, 3.0482622931E+04, 5.0365072249E+03, 1.5601932079E+04, 3.3846617543E+03, 9.7166260442E-01],
	[4.08550E+04, 3.0489142827E+04, 5.0365336641E+03, 1.5608153427E+04, 3.3850467794E+03, 9.7167445814E-01],
	[4.08600E+04, 3.0495663319E+04, 5.0365601002E+03, 1.5614376492E+04, 3.3854317110E+03, 9.7168630601E-01],
	[4.08650E+04, 3.0502184407E+04, 5.0365865332E+03, 1.5620601275E+04, 3.3858165490E+03, 9.7169814801E-01],
	[4.08700E+04, 3.0508706092E+04, 5.0366129631E+03, 1.5626827776E+04, 3.3862012934E+03, 9.7170998417E-01],
	[4.08750E+04, 3.0515228373E+04, 5.0366393900E+03, 1.5633055995E+04, 3.3865859444E+03, 9.7172181447E-01],
	[4.08800E+04, 3.0521751250E+04, 5.0366658137E+03, 1.5639285933E+04, 3.3869705019E+03, 9.7173363893E-01],
	[4.08850E+04, 3.0528274724E+04, 5.0366922344E+03, 1.5645517589E+04, 3.3873549660E+03, 9.7174545754E-01],
	[4.08900E+04, 3.0534798794E+04, 5.0367186519E+03, 1.5651750963E+04, 3.3877393366E+03, 9.7175727031E-01],
	[4.08950E+04, 3.0541323460E+04, 5.0367450664E+03, 1.5657986057E+04, 3.3881236138E+03, 9.7176907725E-01],
	[4.09000E+04, 3.0547848722E+04, 5.0367714778E+03, 1.5664222871E+04, 3.3885077975E+03, 9.7178087835E-01],
	[4.09050E+04, 3.0554374581E+04, 5.0367978860E+03, 1.5670461404E+04, 3.3888918879E+03, 9.7179267362E-01],
	[4.09100E+04, 3.0560901036E+04, 5.0368242912E+03, 1.5676701657E+04, 3.3892758849E+03, 9.7180446306E-01],
	[4.09150E+04, 3.0567428087E+04, 5.0368506933E+03, 1.5682943630E+04, 3.3896597885E+03, 9.7181624667E-01],
	[4.09200E+04, 3.0573955734E+04, 5.0368770924E+03, 1.5689187324E+04, 3.3900435988E+03, 9.7182802446E-01],
	[4.09250E+04, 3.0580483977E+04, 5.0369034883E+03, 1.5695432739E+04, 3.3904273158E+03, 9.7183979644E-01],
	[4.09300E+04, 3.0587012817E+04, 5.0369298811E+03, 1.5701679874E+04, 3.3908109394E+03, 9.7185156260E-01],
	[4.09350E+04, 3.0593542253E+04, 5.0369562709E+03, 1.5707928731E+04, 3.3911944698E+03, 9.7186332294E-01],
	[4.09400E+04, 3.0600072284E+04, 5.0369826576E+03, 1.5714179309E+04, 3.3915779069E+03, 9.7187507748E-01],
	[4.09450E+04, 3.0606602912E+04, 5.0370090412E+03, 1.5720431609E+04, 3.3919612508E+03, 9.7188682621E-01],
	[4.09500E+04, 3.0613134136E+04, 5.0370354217E+03, 1.5726685631E+04, 3.3923445014E+03, 9.7189856913E-01],
	[4.09550E+04, 3.0619665956E+04, 5.0370617991E+03, 1.5732941376E+04, 3.3927276588E+03, 9.7191030626E-01],
	[4.09600E+04, 3.0626198372E+04, 5.0370881734E+03, 1.5739198843E+04, 3.3931107230E+03, 9.7192203759E-01],
	[4.09650E+04, 3.0632731384E+04, 5.0371145447E+03, 1.5745458032E+04, 3.3934936940E+03, 9.7193376312E-01],
	[4.09700E+04, 3.0639264992E+04, 5.0371409129E+03, 1.5751718945E+04, 3.3938765718E+03, 9.7194548287E-01],
	[4.09750E+04, 3.0645799196E+04, 5.0371672780E+03, 1.5757981582E+04, 3.3942593565E+03, 9.7195719683E-01],
	[4.09800E+04, 3.0652333996E+04, 5.0371936400E+03, 1.5764245941E+04, 3.3946420481E+03, 9.7196890500E-01],
	[4.09850E+04, 3.0658869392E+04, 5.0372199989E+03, 1.5770512025E+04, 3.3950246465E+03, 9.7198060739E-01],
	[4.09900E+04, 3.0665405384E+04, 5.0372463548E+03, 1.5776779833E+04, 3.3954071518E+03, 9.7199230400E-01],
	[4.09950E+04, 3.0671941971E+04, 5.0372727076E+03, 1.5783049366E+04, 3.3957895641E+03, 9.7200399484E-01],
	[4.10000E+04, 3.0678479155E+04, 5.0372990573E+03, 1.5789320623E+04, 3.3961718833E+03, 9.7201567990E-01],
	[4.10050E+04, 3.0685016934E+04, 5.0373254039E+03, 1.5795593605E+04, 3.3965541095E+03, 9.7202735920E-01],
	[4.10100E+04, 3.0691555309E+04, 5.0373517475E+03, 1.5801868312E+04, 3.3969362426E+03, 9.7203903273E-01],
	[4.10150E+04, 3.0698094280E+04, 5.0373780880E+03, 1.5808144745E+04, 3.3973182827E+03, 9.7205070050E-01],
	[4.10200E+04, 3.0704633847E+04, 5.0374044254E+03, 1.5814422903E+04, 3.3977002298E+03, 9.7206236251E-01],
	[4.10250E+04, 3.0711174010E+04, 5.0374307597E+03, 1.5820702788E+04, 3.3980820840E+03, 9.7207401876E-01],
	[4.10300E+04, 3.0717714768E+04, 5.0374570910E+03, 1.5826984398E+04, 3.3984638452E+03, 9.7208566926E-01],
	[4.10350E+04, 3.0724256122E+04, 5.0374834192E+03, 1.5833267735E+04, 3.3988455134E+03, 9.7209731400E-01],
	[4.10400E+04, 3.0730798072E+04, 5.0375097443E+03, 1.5839552799E+04, 3.3992270888E+03, 9.7210895300E-01],
	[4.10450E+04, 3.0737340618E+04, 5.0375360664E+03, 1.5845839591E+04, 3.3996085712E+03, 9.7212058626E-01],
	[4.10500E+04, 3.0743883759E+04, 5.0375623854E+03, 1.5852128109E+04, 3.3999899607E+03, 9.7213221377E-01],
	[4.10550E+04, 3.0750427496E+04, 5.0375887013E+03, 1.5858418355E+04, 3.4003712574E+03, 9.7214383555E-01],
	[4.10600E+04, 3.0756971829E+04, 5.0376150141E+03, 1.5864710329E+04, 3.4007524612E+03, 9.7215545159E-01],
	[4.10650E+04, 3.0763516757E+04, 5.0376413239E+03, 1.5871004031E+04, 3.4011335722E+03, 9.7216706190E-01],
	[4.10700E+04, 3.0770062281E+04, 5.0376676307E+03, 1.5877299461E+04, 3.4015145904E+03, 9.7217866649E-01],
	[4.10750E+04, 3.0776608401E+04, 5.0376939343E+03, 1.5883596620E+04, 3.4018955157E+03, 9.7219026534E-01],
	[4.10800E+04, 3.0783155116E+04, 5.0377202349E+03, 1.5889895508E+04, 3.4022763483E+03, 9.7220185848E-01],
	[4.10850E+04, 3.0789702427E+04, 5.0377465324E+03, 1.5896196125E+04, 3.4026570881E+03, 9.7221344589E-01],
	[4.10900E+04, 3.0796250333E+04, 5.0377728269E+03, 1.5902498471E+04, 3.4030377352E+03, 9.7222502759E-01],
	[4.10950E+04, 3.0802798835E+04, 5.0377991183E+03, 1.5908802547E+04, 3.4034182895E+03, 9.7223660358E-01],
	[4.11000E+04, 3.0809347932E+04, 5.0378254066E+03, 1.5915108353E+04, 3.4037987511E+03, 9.7224817385E-01],
	[4.11050E+04, 3.0815897625E+04, 5.0378516919E+03, 1.5921415889E+04, 3.4041791201E+03, 9.7225973842E-01],
	[4.11100E+04, 3.0822447913E+04, 5.0378779741E+03, 1.5927725156E+04, 3.4045593963E+03, 9.7227129729E-01],
	[4.11150E+04, 3.0828998797E+04, 5.0379042533E+03, 1.5934036154E+04, 3.4049395799E+03, 9.7228285045E-01],
	[4.11200E+04, 3.0835550276E+04, 5.0379305294E+03, 1.5940348882E+04, 3.4053196709E+03, 9.7229439792E-01],
	[4.11250E+04, 3.0842102350E+04, 5.0379568025E+03, 1.5946663342E+04, 3.4056996692E+03, 9.7230593969E-01],
	[4.11300E+04, 3.0848655020E+04, 5.0379830724E+03, 1.5952979533E+04, 3.4060795749E+03, 9.7231747577E-01],
	[4.11350E+04, 3.0855208286E+04, 5.0380093394E+03, 1.5959297456E+04, 3.4064593881E+03, 9.7232900616E-01],
	[4.11400E+04, 3.0861762146E+04, 5.0380356033E+03, 1.5965617111E+04, 3.4068391086E+03, 9.7234053087E-01],
	[4.11450E+04, 3.0868316602E+04, 5.0380618641E+03, 1.5971938499E+04, 3.4072187366E+03, 9.7235204989E-01],
	[4.11500E+04, 3.0874871654E+04, 5.0380881218E+03, 1.5978261619E+04, 3.4075982721E+03, 9.7236356323E-01],
	[4.11550E+04, 3.0881427301E+04, 5.0381143766E+03, 1.5984586472E+04, 3.4079777150E+03, 9.7237507090E-01],
	[4.11600E+04, 3.0887983543E+04, 5.0381406282E+03, 1.5990913058E+04, 3.4083570655E+03, 9.7238657290E-01],
	[4.11650E+04, 3.0894540380E+04, 5.0381668768E+03, 1.5997241377E+04, 3.4087363235E+03, 9.7239806922E-01],
	[4.11700E+04, 3.0901097812E+04, 5.0381931224E+03, 1.6003571430E+04, 3.4091154890E+03, 9.7240955988E-01],
	[4.11750E+04, 3.0907655840E+04, 5.0382193649E+03, 1.6009903217E+04, 3.4094945620E+03, 9.7242104488E-01],
	[4.11800E+04, 3.0914214463E+04, 5.0382456044E+03, 1.6016236738E+04, 3.4098735426E+03, 9.7243252421E-01],
	[4.11850E+04, 3.0920773681E+04, 5.0382718408E+03, 1.6022571994E+04, 3.4102524308E+03, 9.7244399789E-01],
	[4.11900E+04, 3.0927333495E+04, 5.0382980741E+03, 1.6028908984E+04, 3.4106312266E+03, 9.7245546591E-01],
	[4.11950E+04, 3.0933893903E+04, 5.0383243044E+03, 1.6035247709E+04, 3.4110099301E+03, 9.7246692828E-01],
	[4.12000E+04, 3.0940454907E+04, 5.0383505317E+03, 1.6041588169E+04, 3.4113885412E+03, 9.7247838501E-01],
	[4.12050E+04, 3.0947016506E+04, 5.0383767559E+03, 1.6047930365E+04, 3.4117670599E+03, 9.7248983608E-01],
	[4.12100E+04, 3.0953578700E+04, 5.0384029771E+03, 1.6054274297E+04, 3.4121454863E+03, 9.7250128152E-01],
	[4.12150E+04, 3.0960141489E+04, 5.0384291952E+03, 1.6060619965E+04, 3.4125238204E+03, 9.7251272131E-01],
	[4.12200E+04, 3.0966704873E+04, 5.0384554103E+03, 1.6066967369E+04, 3.4129020622E+03, 9.7252415547E-01],
	[4.12250E+04, 3.0973268852E+04, 5.0384816224E+03, 1.6073316509E+04, 3.4132802117E+03, 9.7253558400E-01],
	[4.12300E+04, 3.0979833426E+04, 5.0385078314E+03, 1.6079667386E+04, 3.4136582690E+03, 9.7254700690E-01],
	[4.12350E+04, 3.0986398596E+04, 5.0385340373E+03, 1.6086020001E+04, 3.4140362341E+03, 9.7255842417E-01],
	[4.12400E+04, 3.0992964360E+04, 5.0385602402E+03, 1.6092374352E+04, 3.4144141069E+03, 9.7256983581E-01],
	[4.12450E+04, 3.0999530719E+04, 5.0385864401E+03, 1.6098730442E+04, 3.4147918875E+03, 9.7258124184E-01],
	[4.12500E+04, 3.1006097673E+04, 5.0386126369E+03, 1.6105088269E+04, 3.4151695760E+03, 9.7259264225E-01],
	[4.12550E+04, 3.1012665222E+04, 5.0386388307E+03, 1.6111447834E+04, 3.4155471723E+03, 9.7260403704E-01],
	[4.12600E+04, 3.1019233366E+04, 5.0386650215E+03, 1.6117809138E+04, 3.4159246764E+03, 9.7261542622E-01],
	[4.12650E+04, 3.1025802105E+04, 5.0386912092E+03, 1.6124172180E+04, 3.4163020884E+03, 9.7262680979E-01],
	[4.12700E+04, 3.1032371439E+04, 5.0387173939E+03, 1.6130536961E+04, 3.4166794083E+03, 9.7263818776E-01],
	[4.12750E+04, 3.1038941368E+04, 5.0387435755E+03, 1.6136903481E+04, 3.4170566361E+03, 9.7264956013E-01],
	[4.12800E+04, 3.1045511892E+04, 5.0387697542E+03, 1.6143271741E+04, 3.4174337718E+03, 9.7266092689E-01],
	[4.12850E+04, 3.1052083010E+04, 5.0387959297E+03, 1.6149641741E+04, 3.4178108155E+03, 9.7267228806E-01],
	[4.12900E+04, 3.1058654723E+04, 5.0388221023E+03, 1.6156013480E+04, 3.4181877671E+03, 9.7268364364E-01],
	[4.12950E+04, 3.1065227031E+04, 5.0388482718E+03, 1.6162386960E+04, 3.4185646267E+03, 9.7269499362E-01],
	[4.13000E+04, 3.1071799934E+04, 5.0388744383E+03, 1.6168762180E+04, 3.4189413943E+03, 9.7270633802E-01],
	[4.13050E+04, 3.1078373432E+04, 5.0389006017E+03, 1.6175139141E+04, 3.4193180699E+03, 9.7271767684E-01],
	[4.13100E+04, 3.1084947524E+04, 5.0389267621E+03, 1.6181517843E+04, 3.4196946535E+03, 9.7272901007E-01],
	[4.13150E+04, 3.1091522211E+04, 5.0389529195E+03, 1.6187898286E+04, 3.4200711452E+03, 9.7274033772E-01],
	[4.13200E+04, 3.1098097493E+04, 5.0389790739E+03, 1.6194280471E+04, 3.4204475449E+03, 9.7275165980E-01],
	[4.13250E+04, 3.1104673369E+04, 5.0390052252E+03, 1.6200664398E+04, 3.4208238528E+03, 9.7276297631E-01],
	[4.13300E+04, 3.1111249841E+04, 5.0390313735E+03, 1.6207050067E+04, 3.4212000687E+03, 9.7277428725E-01],
	[4.13350E+04, 3.1117826906E+04, 5.0390575188E+03, 1.6213437478E+04, 3.4215761927E+03, 9.7278559263E-01],
	[4.13400E+04, 3.1124404567E+04, 5.0390836610E+03, 1.6219826632E+04, 3.4219522249E+03, 9.7279689244E-01],
	[4.13450E+04, 3.1130982822E+04, 5.0391098002E+03, 1.6226217528E+04, 3.4223281653E+03, 9.7280818669E-01],
	[4.13500E+04, 3.1137561672E+04, 5.0391359364E+03, 1.6232610168E+04, 3.4227040138E+03, 9.7281947538E-01],
	[4.13550E+04, 3.1144141116E+04, 5.0391620696E+03, 1.6239004551E+04, 3.4230797705E+03, 9.7283075853E-01],
	[4.13600E+04, 3.1150721155E+04, 5.0391881997E+03, 1.6245400678E+04, 3.4234554354E+03, 9.7284203612E-01],
	[4.13650E+04, 3.1157301788E+04, 5.0392143269E+03, 1.6251798548E+04, 3.4238310085E+03, 9.7285330816E-01],
	[4.13700E+04, 3.1163883016E+04, 5.0392404510E+03, 1.6258198163E+04, 3.4242064899E+03, 9.7286457466E-01],
	[4.13750E+04, 3.1170464838E+04, 5.0392665720E+03, 1.6264599523E+04, 3.4245818795E+03, 9.7287583561E-01],
	[4.13800E+04, 3.1177047255E+04, 5.0392926901E+03, 1.6271002627E+04, 3.4249571774E+03, 9.7288709103E-01],
	[4.13850E+04, 3.1183630267E+04, 5.0393188051E+03, 1.6277407476E+04, 3.4253323837E+03, 9.7289834092E-01],
	[4.13900E+04, 3.1190213872E+04, 5.0393449171E+03, 1.6283814070E+04, 3.4257074982E+03, 9.7290958527E-01],
	[4.13950E+04, 3.1196798073E+04, 5.0393710261E+03, 1.6290222410E+04, 3.4260825211E+03, 9.7292082409E-01],
	[4.14000E+04, 3.1203382867E+04, 5.0393971321E+03, 1.6296632495E+04, 3.4264574523E+03, 9.7293205738E-01],
	[4.14050E+04, 3.1209968256E+04, 5.0394232351E+03, 1.6303044327E+04, 3.4268322918E+03, 9.7294328516E-01],
	[4.14100E+04, 3.1216554240E+04, 5.0394493350E+03, 1.6309457905E+04, 3.4272070398E+03, 9.7295450741E-01],
	[4.14150E+04, 3.1223140818E+04, 5.0394754319E+03, 1.6315873229E+04, 3.4275816962E+03, 9.7296572414E-01],
	[4.14200E+04, 3.1229727990E+04, 5.0395015259E+03, 1.6322290301E+04, 3.4279562610E+03, 9.7297693536E-01],
	[4.14250E+04, 3.1236315756E+04, 5.0395276168E+03, 1.6328709119E+04, 3.4283307342E+03, 9.7298814107E-01],
	[4.14300E+04, 3.1242904117E+04, 5.0395537046E+03, 1.6335129685E+04, 3.4287051159E+03, 9.7299934127E-01],
	[4.14350E+04, 3.1249493072E+04, 5.0395797895E+03, 1.6341551998E+04, 3.4290794061E+03, 9.7301053597E-01],
	[4.14400E+04, 3.1256082622E+04, 5.0396058714E+03, 1.6347976059E+04, 3.4294536047E+03, 9.7302172516E-01],
	[4.14450E+04, 3.1262672765E+04, 5.0396319502E+03, 1.6354401869E+04, 3.4298277119E+03, 9.7303290885E-01],
	[4.14500E+04, 3.1269263503E+04, 5.0396580260E+03, 1.6360829427E+04, 3.4302017276E+03, 9.7304408705E-01],
	[4.14550E+04, 3.1275854835E+04, 5.0396840989E+03, 1.6367258733E+04, 3.4305756518E+03, 9.7305525976E-01],
	[4.14600E+04, 3.1282446762E+04, 5.0397101687E+03, 1.6373689789E+04, 3.4309494847E+03, 9.7306642697E-01],
	[4.14650E+04, 3.1289039282E+04, 5.0397362355E+03, 1.6380122593E+04, 3.4313232260E+03, 9.7307758870E-01],
	[4.14700E+04, 3.1295632397E+04, 5.0397622993E+03, 1.6386557147E+04, 3.4316968760E+03, 9.7308874494E-01],
	[4.14750E+04, 3.1302226106E+04, 5.0397883601E+03, 1.6392993451E+04, 3.4320704347E+03, 9.7309989571E-01],
	[4.14800E+04, 3.1308820409E+04, 5.0398144179E+03, 1.6399431505E+04, 3.4324439019E+03, 9.7311104099E-01],
	[4.14850E+04, 3.1315415306E+04, 5.0398404726E+03, 1.6405871309E+04, 3.4328172778E+03, 9.7312218080E-01],
	[4.14900E+04, 3.1322010797E+04, 5.0398665244E+03, 1.6412312864E+04, 3.4331905624E+03, 9.7313331514E-01],
	[4.14950E+04, 3.1328606882E+04, 5.0398925732E+03, 1.6418756169E+04, 3.4335637557E+03, 9.7314444401E-01],
	[4.15000E+04, 3.1335203561E+04, 5.0399186190E+03, 1.6425201226E+04, 3.4339368576E+03, 9.7315556741E-01],
	[4.15050E+04, 3.1341800835E+04, 5.0399446617E+03, 1.6431648034E+04, 3.4343098683E+03, 9.7316668535E-01],
	[4.15100E+04, 3.1348398702E+04, 5.0399707015E+03, 1.6438096593E+04, 3.4346827878E+03, 9.7317779783E-01],
	[4.15150E+04, 3.1354997164E+04, 5.0399967382E+03, 1.6444546904E+04, 3.4350556160E+03, 9.7318890486E-01],
	[4.15200E+04, 3.1361596219E+04, 5.0400227720E+03, 1.6450998968E+04, 3.4354283530E+03, 9.7320000643E-01],
	[4.15250E+04, 3.1368195868E+04, 5.0400488027E+03, 1.6457452784E+04, 3.4358009988E+03, 9.7321110254E-01],
	[4.15300E+04, 3.1374796111E+04, 5.0400748305E+03, 1.6463908352E+04, 3.4361735534E+03, 9.7322219321E-01],
	[4.15350E+04, 3.1381396949E+04, 5.0401008552E+03, 1.6470365673E+04, 3.4365460168E+03, 9.7323327844E-01],
	[4.15400E+04, 3.1387998380E+04, 5.0401268770E+03, 1.6476824748E+04, 3.4369183891E+03, 9.7324435822E-01],
	[4.15450E+04, 3.1394600405E+04, 5.0401528958E+03, 1.6483285576E+04, 3.4372906703E+03, 9.7325543257E-01],
	[4.15500E+04, 3.1401203024E+04, 5.0401789115E+03, 1.6489748157E+04, 3.4376628603E+03, 9.7326650148E-01],
	[4.15550E+04, 3.1407806236E+04, 5.0402049243E+03, 1.6496212493E+04, 3.4380349593E+03, 9.7327756495E-01],
	[4.15600E+04, 3.1414410043E+04, 5.0402309341E+03, 1.6502678582E+04, 3.4384069672E+03, 9.7328862300E-01],
	[4.15650E+04, 3.1421014443E+04, 5.0402569408E+03, 1.6509146427E+04, 3.4387788840E+03, 9.7329967562E-01],
	[4.15700E+04, 3.1427619437E+04, 5.0402829446E+03, 1.6515616026E+04, 3.4391507098E+03, 9.7331072281E-01],
	[4.15750E+04, 3.1434225025E+04, 5.0403089454E+03, 1.6522087380E+04, 3.4395224445E+03, 9.7332176459E-01],
	[4.15800E+04, 3.1440831207E+04, 5.0403349432E+03, 1.6528560489E+04, 3.4398940883E+03, 9.7333280094E-01],
	[4.15850E+04, 3.1447437983E+04, 5.0403609380E+03, 1.6535035354E+04, 3.4402656411E+03, 9.7334383189E-01],
	[4.15900E+04, 3.1454045352E+04, 5.0403869298E+03, 1.6541511975E+04, 3.4406371029E+03, 9.7335485741E-01],
	[4.15950E+04, 3.1460653315E+04, 5.0404129186E+03, 1.6547990351E+04, 3.4410084737E+03, 9.7336587753E-01],
	[4.16000E+04, 3.1467261872E+04, 5.0404389045E+03, 1.6554470484E+04, 3.4413797536E+03, 9.7337689225E-01],
	[4.16050E+04, 3.1473871022E+04, 5.0404648873E+03, 1.6560952374E+04, 3.4417509427E+03, 9.7338790156E-01],
	[4.16100E+04, 3.1480480766E+04, 5.0404908672E+03, 1.6567436021E+04, 3.4421220408E+03, 9.7339890547E-01],
	[4.16150E+04, 3.1487091104E+04, 5.0405168440E+03, 1.6573921424E+04, 3.4424930480E+03, 9.7340990399E-01],
	[4.16200E+04, 3.1493702035E+04, 5.0405428179E+03, 1.6580408585E+04, 3.4428639644E+03, 9.7342089711E-01],
	[4.16250E+04, 3.1500313560E+04, 5.0405687888E+03, 1.6586897504E+04, 3.4432347899E+03, 9.7343188483E-01],
	[4.16300E+04, 3.1506925678E+04, 5.0405947567E+03, 1.6593388181E+04, 3.4436055246E+03, 9.7344286717E-01],
	[4.16350E+04, 3.1513538390E+04, 5.0406207216E+03, 1.6599880616E+04, 3.4439761685E+03, 9.7345384413E-01],
	[4.16400E+04, 3.1520151696E+04, 5.0406466836E+03, 1.6606374809E+04, 3.4443467216E+03, 9.7346481570E-01],
	[4.16450E+04, 3.1526765595E+04, 5.0406726425E+03, 1.6612870761E+04, 3.4447171840E+03, 9.7347578190E-01],
	[4.16500E+04, 3.1533380087E+04, 5.0406985985E+03, 1.6619368472E+04, 3.4450875556E+03, 9.7348674272E-01],
	[4.16550E+04, 3.1539995174E+04, 5.0407245515E+03, 1.6625867942E+04, 3.4454578365E+03, 9.7349769816E-01],
	[4.16600E+04, 3.1546610853E+04, 5.0407505015E+03, 1.6632369172E+04, 3.4458280266E+03, 9.7350864824E-01],
	[4.16650E+04, 3.1553227126E+04, 5.0407764485E+03, 1.6638872162E+04, 3.4461981261E+03, 9.7351959294E-01],
	[4.16700E+04, 3.1559843993E+04, 5.0408023926E+03, 1.6645376911E+04, 3.4465681348E+03, 9.7353053229E-01],
	[4.16750E+04, 3.1566461453E+04, 5.0408283337E+03, 1.6651883421E+04, 3.4469380529E+03, 9.7354146627E-01],
	[4.16800E+04, 3.1573079506E+04, 5.0408542717E+03, 1.6658391691E+04, 3.4473078804E+03, 9.7355239489E-01],
	[4.16850E+04, 3.1579698153E+04, 5.0408802069E+03, 1.6664901723E+04, 3.4476776173E+03, 9.7356331816E-01],
	[4.16900E+04, 3.1586317393E+04, 5.0409061390E+03, 1.6671413515E+04, 3.4480472635E+03, 9.7357423607E-01],
	[4.16950E+04, 3.1592937226E+04, 5.0409320682E+03, 1.6677927069E+04, 3.4484168192E+03, 9.7358514864E-01],
	[4.17000E+04, 3.1599557653E+04, 5.0409579943E+03, 1.6684442384E+04, 3.4487862842E+03, 9.7359605586E-01],
	[4.17050E+04, 3.1606178673E+04, 5.0409839175E+03, 1.6690959461E+04, 3.4491556588E+03, 9.7360695773E-01],
	[4.17100E+04, 3.1612800287E+04, 5.0410098378E+03, 1.6697478301E+04, 3.4495249428E+03, 9.7361785427E-01],
	[4.17150E+04, 3.1619422494E+04, 5.0410357550E+03, 1.6703998903E+04, 3.4498941362E+03, 9.7362874546E-01],
	[4.17200E+04, 3.1626045294E+04, 5.0410616693E+03, 1.6710521267E+04, 3.4502632392E+03, 9.7363963133E-01],
	[4.17250E+04, 3.1632668687E+04, 5.0410875806E+03, 1.6717045395E+04, 3.4506322517E+03, 9.7365051186E-01],
	[4.17300E+04, 3.1639292673E+04, 5.0411134890E+03, 1.6723571285E+04, 3.4510011738E+03, 9.7366138706E-01],
	[4.17350E+04, 3.1645917253E+04, 5.0411393943E+03, 1.6730098940E+04, 3.4513700053E+03, 9.7367225694E-01],
	[4.17400E+04, 3.1652542426E+04, 5.0411652967E+03, 1.6736628357E+04, 3.4517387465E+03, 9.7368312149E-01],
	[4.17450E+04, 3.1659175207E+04, 5.0411922711E+03, 1.6743159539E+04, 3.4521079847E+03, 9.7369398072E-01],
	[4.17500E+04, 3.1665836660E+04, 5.0412235430E+03, 1.6749692486E+04, 3.4524794836E+03, 9.7370483464E-01],
	[4.17550E+04, 3.1672498716E+04, 5.0412548114E+03, 1.6756227196E+04, 3.4528508927E+03, 9.7371568324E-01],
	[4.17600E+04, 3.1679161375E+04, 5.0412860763E+03, 1.6762763672E+04, 3.4532222122E+03, 9.7372652653E-01],
	[4.17650E+04, 3.1685824639E+04, 5.0413173375E+03, 1.6769301912E+04, 3.4535934421E+03, 9.7373736452E-01],
	[4.17700E+04, 3.1692488506E+04, 5.0413485953E+03, 1.6775841918E+04, 3.4539645824E+03, 9.7374819719E-01],
	[4.17750E+04, 3.1699152976E+04, 5.0413798495E+03, 1.6782383690E+04, 3.4543356330E+03, 9.7375902457E-01],
	[4.17800E+04, 3.1705818050E+04, 5.0414111001E+03, 1.6788927227E+04, 3.4547065941E+03, 9.7376984665E-01],
	[4.17850E+04, 3.1712483728E+04, 5.0414423472E+03, 1.6795472531E+04, 3.4550774656E+03, 9.7378066343E-01],
	[4.17900E+04, 3.1719150009E+04, 5.0414735908E+03, 1.6802019600E+04, 3.4554482476E+03, 9.7379147491E-01],
	[4.17950E+04, 3.1725816893E+04, 5.0415048308E+03, 1.6808568437E+04, 3.4558189401E+03, 9.7380228111E-01],
	[4.18000E+04, 3.1732484382E+04, 5.0415360673E+03, 1.6815119040E+04, 3.4561895430E+03, 9.7381308202E-01],
	[4.18050E+04, 3.1739152473E+04, 5.0415673002E+03, 1.6821671411E+04, 3.4565600565E+03, 9.7382387764E-01],
	[4.18100E+04, 3.1745821168E+04, 5.0415985296E+03, 1.6828225549E+04, 3.4569304805E+03, 9.7383466798E-01],
	[4.18150E+04, 3.1752490467E+04, 5.0416297554E+03, 1.6834781455E+04, 3.4573008150E+03, 9.7384545305E-01],
	[4.18200E+04, 3.1759160369E+04, 5.0416609777E+03, 1.6841339129E+04, 3.4576710601E+03, 9.7385623283E-01],
	[4.18250E+04, 3.1765830874E+04, 5.0416921965E+03, 1.6847898571E+04, 3.4580412158E+03, 9.7386700735E-01],
	[4.18300E+04, 3.1772501983E+04, 5.0417234117E+03, 1.6854459781E+04, 3.4584112821E+03, 9.7387777659E-01],
	[4.18350E+04, 3.1779173695E+04, 5.0417546234E+03, 1.6861022760E+04, 3.4587812590E+03, 9.7388854057E-01],
	[4.18400E+04, 3.1785846011E+04, 5.0417858315E+03, 1.6867587509E+04, 3.4591511465E+03, 9.7389929928E-01],
	[4.18450E+04, 3.1792518930E+04, 5.0418170361E+03, 1.6874154026E+04, 3.4595209447E+03, 9.7391005274E-01],
	[4.18500E+04, 3.1799192452E+04, 5.0418482372E+03, 1.6880722313E+04, 3.4598906536E+03, 9.7392080093E-01],
	[4.18550E+04, 3.1805866578E+04, 5.0418794348E+03, 1.6887292370E+04, 3.4602602731E+03, 9.7393154387E-01],
	[4.18600E+04, 3.1812541307E+04, 5.0419106288E+03, 1.6893864197E+04, 3.4606298034E+03, 9.7394228156E-01],
	[4.18650E+04, 3.1819216639E+04, 5.0419418192E+03, 1.6900437795E+04, 3.4609992443E+03, 9.7395301400E-01],
	[4.18700E+04, 3.1825892574E+04, 5.0419730062E+03, 1.6907013163E+04, 3.4613685961E+03, 9.7396374119E-01],
	[4.18750E+04, 3.1832569113E+04, 5.0420041896E+03, 1.6913590302E+04, 3.4617378585E+03, 9.7397446313E-01],
	[4.18800E+04, 3.1839246255E+04, 5.0420353695E+03, 1.6920169212E+04, 3.4621070318E+03, 9.7398517984E-01],
	[4.18850E+04, 3.1845924000E+04, 5.0420665458E+03, 1.6926749893E+04, 3.4624761159E+03, 9.7399589131E-01],
	[4.18900E+04, 3.1852602348E+04, 5.0420977187E+03, 1.6933332347E+04, 3.4628451107E+03, 9.7400659754E-01],
	[4.18950E+04, 3.1859281299E+04, 5.0421288880E+03, 1.6939916572E+04, 3.4632140164E+03, 9.7401729854E-01],
	[4.19000E+04, 3.1865960854E+04, 5.0421600537E+03, 1.6946502569E+04, 3.4635828330E+03, 9.7402799432E-01],
	[4.19050E+04, 3.1872641012E+04, 5.0421912160E+03, 1.6953090339E+04, 3.4639515604E+03, 9.7403868486E-01],
	[4.19100E+04, 3.1879321772E+04, 5.0422223747E+03, 1.6959679881E+04, 3.4643201987E+03, 9.7404937019E-01],
	[4.19150E+04, 3.1886003136E+04, 5.0422535299E+03, 1.6966271197E+04, 3.4646887479E+03, 9.7406005029E-01],
	[4.19200E+04, 3.1892685103E+04, 5.0422846815E+03, 1.6972864286E+04, 3.4650572080E+03, 9.7407072518E-01],
	[4.19250E+04, 3.1899367674E+04, 5.0423158297E+03, 1.6979459148E+04, 3.4654255791E+03, 9.7408139485E-01],
	[4.19300E+04, 3.1906050847E+04, 5.0423469743E+03, 1.6986055784E+04, 3.4657938611E+03, 9.7409205931E-01],
	[4.19350E+04, 3.1912734623E+04, 5.0423781154E+03, 1.6992654194E+04, 3.4661620541E+03, 9.7410271856E-01],
	[4.19400E+04, 3.1919419002E+04, 5.0424092530E+03, 1.6999254379E+04, 3.4665301581E+03, 9.7411337261E-01],
	[4.19450E+04, 3.1926103984E+04, 5.0424403871E+03, 1.7005856338E+04, 3.4668981731E+03, 9.7412402145E-01],
	[4.19500E+04, 3.1932789569E+04, 5.0424715176E+03, 1.7012460072E+04, 3.4672660991E+03, 9.7413466509E-01],
	[4.19550E+04, 3.1939475757E+04, 5.0425026446E+03, 1.7019065581E+04, 3.4676339362E+03, 9.7414530354E-01],
	[4.19600E+04, 3.1946162548E+04, 5.0425337681E+03, 1.7025672866E+04, 3.4680016844E+03, 9.7415593679E-01],
	[4.19650E+04, 3.1952849942E+04, 5.0425648881E+03, 1.7032281926E+04, 3.4683693436E+03, 9.7416656485E-01],
	[4.19700E+04, 3.1959537939E+04, 5.0425960046E+03, 1.7038892762E+04, 3.4687369139E+03, 9.7417718772E-01],
	[4.19750E+04, 3.1966226539E+04, 5.0426271176E+03, 1.7045505374E+04, 3.4691043953E+03, 9.7418780541E-01],
	[4.19800E+04, 3.1972915742E+04, 5.0426582270E+03, 1.7052119763E+04, 3.4694717879E+03, 9.7419841791E-01],
	[4.19850E+04, 3.1979605547E+04, 5.0426893330E+03, 1.7058735928E+04, 3.4698390917E+03, 9.7420902524E-01],
	[4.19900E+04, 3.1986295956E+04, 5.0427204354E+03, 1.7065353871E+04, 3.4702063066E+03, 9.7421962739E-01],
	[4.19950E+04, 3.1992986967E+04, 5.0427515343E+03, 1.7071973590E+04, 3.4705734326E+03, 9.7423022436E-01],
	[4.20000E+04, 3.1999678581E+04, 5.0427826297E+03, 1.7078595087E+04, 3.4709404699E+03, 9.7424081616E-01],
	[4.20050E+04, 3.2006370798E+04, 5.0428137216E+03, 1.7085218362E+04, 3.4713074185E+03, 9.7425140280E-01],
	[4.20100E+04, 3.2013063617E+04, 5.0428448100E+03, 1.7091843415E+04, 3.4716742782E+03, 9.7426198427E-01],
	[4.20150E+04, 3.2019757039E+04, 5.0428758948E+03, 1.7098470247E+04, 3.4720410493E+03, 9.7427256057E-01],
	[4.20200E+04, 3.2026451064E+04, 5.0429069762E+03, 1.7105098856E+04, 3.4724077316E+03, 9.7428313172E-01],
	[4.20250E+04, 3.2033145692E+04, 5.0429380541E+03, 1.7111729245E+04, 3.4727743252E+03, 9.7429369771E-01],
	[4.20300E+04, 3.2039840923E+04, 5.0429691284E+03, 1.7118361413E+04, 3.4731408301E+03, 9.7430425855E-01],
	[4.20350E+04, 3.2046536756E+04, 5.0430001993E+03, 1.7124995360E+04, 3.4735072464E+03, 9.7431481424E-01],
	[4.20400E+04, 3.2053233192E+04, 5.0430312666E+03, 1.7131631086E+04, 3.4738735740E+03, 9.7432536478E-01],
	[4.20450E+04, 3.2059930230E+04, 5.0430623304E+03, 1.7138268593E+04, 3.4742398129E+03, 9.7433591017E-01],
	[4.20500E+04, 3.2066627871E+04, 5.0430933908E+03, 1.7144907880E+04, 3.4746059633E+03, 9.7434645042E-01],
	[4.20550E+04, 3.2073326115E+04, 5.0431244476E+03, 1.7151548947E+04, 3.4749720251E+03, 9.7435698554E-01],
	[4.20600E+04, 3.2080024961E+04, 5.0431555010E+03, 1.7158191795E+04, 3.4753379983E+03, 9.7436751551E-01],
	[4.20650E+04, 3.2086724410E+04, 5.0431865508E+03, 1.7164836424E+04, 3.4757038829E+03, 9.7437804036E-01],
	[4.20700E+04, 3.2093424461E+04, 5.0432175971E+03, 1.7171482834E+04, 3.4760696790E+03, 9.7438856007E-01],
	[4.20750E+04, 3.2100125115E+04, 5.0432486400E+03, 1.7178131025E+04, 3.4764353865E+03, 9.7439907465E-01],
	[4.20800E+04, 3.2106826372E+04, 5.0432796793E+03, 1.7184780999E+04, 3.4768010056E+03, 9.7440958411E-01],
	[4.20850E+04, 3.2113528231E+04, 5.0433107151E+03, 1.7191432754E+04, 3.4771665362E+03, 9.7442008845E-01],
	[4.20900E+04, 3.2120230692E+04, 5.0433417475E+03, 1.7198086291E+04, 3.4775319783E+03, 9.7443058767E-01],
	[4.20950E+04, 3.2126933756E+04, 5.0433727763E+03, 1.7204741611E+04, 3.4778973319E+03, 9.7444108177E-01],
	[4.21000E+04, 3.2133637422E+04, 5.0434038017E+03, 1.7211398714E+04, 3.4782625972E+03, 9.7445157076E-01],
	[4.21050E+04, 3.2140341691E+04, 5.0434348236E+03, 1.7218057600E+04, 3.4786277740E+03, 9.7446205464E-01],
	[4.21100E+04, 3.2147046562E+04, 5.0434658419E+03, 1.7224718270E+04, 3.4789928624E+03, 9.7447253341E-01],
	[4.21150E+04, 3.2153752036E+04, 5.0434968568E+03, 1.7231380722E+04, 3.4793578624E+03, 9.7448300707E-01],
	[4.21200E+04, 3.2160458112E+04, 5.0435278682E+03, 1.7238044959E+04, 3.4797227741E+03, 9.7449347564E-01],
	[4.21250E+04, 3.2167164791E+04, 5.0435588761E+03, 1.7244710980E+04, 3.4800875974E+03, 9.7450393910E-01],
	[4.21300E+04, 3.2173872071E+04, 5.0435898805E+03, 1.7251378785E+04, 3.4804523324E+03, 9.7451439747E-01],
	[4.21350E+04, 3.2180579954E+04, 5.0436208814E+03, 1.7258048375E+04, 3.4808169791E+03, 9.7452485075E-01],
	[4.21400E+04, 3.2187288440E+04, 5.0436518788E+03, 1.7264719750E+04, 3.4811815375E+03, 9.7453529893E-01],
	[4.21450E+04, 3.2193997528E+04, 5.0436828728E+03, 1.7271392910E+04, 3.4815460076E+03, 9.7454574203E-01],
	[4.21500E+04, 3.2200707218E+04, 5.0437138632E+03, 1.7278067856E+04, 3.4819103895E+03, 9.7455618004E-01],
	[4.21550E+04, 3.2207417510E+04, 5.0437448502E+03, 1.7284744587E+04, 3.4822746832E+03, 9.7456661297E-01],
	[4.21600E+04, 3.2214128404E+04, 5.0437758337E+03, 1.7291423104E+04, 3.4826388886E+03, 9.7457704082E-01],
	[4.21650E+04, 3.2220839901E+04, 5.0438068137E+03, 1.7298103408E+04, 3.4830030058E+03, 9.7458746359E-01],
	[4.21700E+04, 3.2227552000E+04, 5.0438377902E+03, 1.7304785498E+04, 3.4833670349E+03, 9.7459788129E-01],
	[4.21750E+04, 3.2234264701E+04, 5.0438687633E+03, 1.7311469374E+04, 3.4837309758E+03, 9.7460829393E-01],
	[4.21800E+04, 3.2240978004E+04, 5.0438997328E+03, 1.7318155038E+04, 3.4840948285E+03, 9.7461870149E-01],
	[4.21850E+04, 3.2247691910E+04, 5.0439306989E+03, 1.7324842489E+04, 3.4844585931E+03, 9.7462910399E-01],
	[4.21900E+04, 3.2254406417E+04, 5.0439616615E+03, 1.7331531728E+04, 3.4848222696E+03, 9.7463950142E-01],
	[4.21950E+04, 3.2261121527E+04, 5.0439926206E+03, 1.7338222755E+04, 3.4851858580E+03, 9.7464989380E-01],
	[4.22000E+04, 3.2267837239E+04, 5.0440235762E+03, 1.7344915569E+04, 3.4855493584E+03, 9.7466028112E-01],
	[4.22050E+04, 3.2274553553E+04, 5.0440545284E+03, 1.7351610172E+04, 3.4859127707E+03, 9.7467066339E-01],
	[4.22100E+04, 3.2281270469E+04, 5.0440854771E+03, 1.7358306564E+04, 3.4862760949E+03, 9.7468104060E-01],
	[4.22150E+04, 3.2287987987E+04, 5.0441164223E+03, 1.7365004745E+04, 3.4866393312E+03, 9.7469141277E-01],
	[4.22200E+04, 3.2294706107E+04, 5.0441473640E+03, 1.7371704714E+04, 3.4870024794E+03, 9.7470177989E-01],
	[4.22250E+04, 3.2301424829E+04, 5.0441783023E+03, 1.7378406473E+04, 3.4873655397E+03, 9.7471214197E-01],
	[4.22300E+04, 3.2308144153E+04, 5.0442092370E+03, 1.7385110022E+04, 3.4877285120E+03, 9.7472249902E-01],
	[4.22350E+04, 3.2314864080E+04, 5.0442401684E+03, 1.7391815361E+04, 3.4880913963E+03, 9.7473285102E-01],
	[4.22400E+04, 3.2321584608E+04, 5.0442710962E+03, 1.7398522490E+04, 3.4884541927E+03, 9.7474319799E-01],
	[4.22450E+04, 3.2328305738E+04, 5.0443020206E+03, 1.7405231410E+04, 3.4888169012E+03, 9.7475353993E-01],
	[4.22500E+04, 3.2335027470E+04, 5.0443329415E+03, 1.7411942120E+04, 3.4891795218E+03, 9.7476387685E-01],
	[4.22550E+04, 3.2341749804E+04, 5.0443638589E+03, 1.7418654622E+04, 3.4895420546E+03, 9.7477420873E-01],
	[4.22600E+04, 3.2348472739E+04, 5.0443947728E+03, 1.7425368914E+04, 3.4899044995E+03, 9.7478453560E-01],
	[4.22650E+04, 3.2355196277E+04, 5.0444256833E+03, 1.7432084998E+04, 3.4902668565E+03, 9.7479485744E-01],
	[4.22700E+04, 3.2361920416E+04, 5.0444565904E+03, 1.7438802874E+04, 3.4906291258E+03, 9.7480517427E-01],
	[4.22750E+04, 3.2368645158E+04, 5.0444874939E+03, 1.7445522542E+04, 3.4909913072E+03, 9.7481548609E-01],
	[4.22800E+04, 3.2375370501E+04, 5.0445183940E+03, 1.7452244003E+04, 3.4913534008E+03, 9.7482579289E-01],
	[4.22850E+04, 3.2382096446E+04, 5.0445492906E+03, 1.7458967256E+04, 3.4917154067E+03, 9.7483609469E-01],
	[4.22900E+04, 3.2388822993E+04, 5.0445801838E+03, 1.7465692302E+04, 3.4920773248E+03, 9.7484639148E-01],
	[4.22950E+04, 3.2395550141E+04, 5.0446110735E+03, 1.7472419141E+04, 3.4924391553E+03, 9.7485668326E-01],
	[4.23000E+04, 3.2402277892E+04, 5.0446419597E+03, 1.7479147774E+04, 3.4928008980E+03, 9.7486697005E-01],
	[4.23050E+04, 3.2409006244E+04, 5.0446728425E+03, 1.7485878200E+04, 3.4931625530E+03, 9.7487725184E-01],
	[4.23100E+04, 3.2415735198E+04, 5.0447037218E+03, 1.7492610420E+04, 3.4935241203E+03, 9.7488752864E-01],
	[4.23150E+04, 3.2422464753E+04, 5.0447345977E+03, 1.7499344434E+04, 3.4938856000E+03, 9.7489780044E-01],
	[4.23200E+04, 3.2429194911E+04, 5.0447654701E+03, 1.7506080243E+04, 3.4942469920E+03, 9.7490806726E-01],
	[4.23250E+04, 3.2435925669E+04, 5.0447963390E+03, 1.7512817847E+04, 3.4946082964E+03, 9.7491832909E-01],
	[4.23300E+04, 3.2442657030E+04, 5.0448272045E+03, 1.7519557245E+04, 3.4949695132E+03, 9.7492858594E-01],
	[4.23350E+04, 3.2449388992E+04, 5.0448580665E+03, 1.7526298439E+04, 3.4953306425E+03, 9.7493883781E-01],
	[4.23400E+04, 3.2456121556E+04, 5.0448889251E+03, 1.7533041428E+04, 3.4956916841E+03, 9.7494908470E-01],
	[4.23450E+04, 3.2462854721E+04, 5.0449197802E+03, 1.7539786214E+04, 3.4960526383E+03, 9.7495932661E-01],
	[4.23500E+04, 3.2469588488E+04, 5.0449506318E+03, 1.7546532795E+04, 3.4964135048E+03, 9.7496956356E-01],
	[4.23550E+04, 3.2476322857E+04, 5.0449814800E+03, 1.7553281172E+04, 3.4967742839E+03, 9.7497979553E-01],
	[4.23600E+04, 3.2483057827E+04, 5.0450123248E+03, 1.7560031347E+04, 3.4971349755E+03, 9.7499002254E-01],
	[4.23650E+04, 3.2489793399E+04, 5.0450431661E+03, 1.7566783318E+04, 3.4974955796E+03, 9.7500024459E-01],
	[4.23700E+04, 3.2496529572E+04, 5.0450740039E+03, 1.7573537086E+04, 3.4978560963E+03, 9.7501046167E-01],
	[4.23750E+04, 3.2503266347E+04, 5.0451048383E+03, 1.7580292651E+04, 3.4982165255E+03, 9.7502067380E-01],
	[4.23800E+04, 3.2510003723E+04, 5.0451356693E+03, 1.7587050015E+04, 3.4985768673E+03, 9.7503088097E-01],
	[4.23850E+04, 3.2516741700E+04, 5.0451664968E+03, 1.7593809176E+04, 3.4989371217E+03, 9.7504108319E-01],
	[4.23900E+04, 3.2523480280E+04, 5.0451973208E+03, 1.7600570135E+04, 3.4992972887E+03, 9.7505128046E-01],
	[4.23950E+04, 3.2530219460E+04, 5.0452281414E+03, 1.7607332893E+04, 3.4996573684E+03, 9.7506147279E-01],
	[4.24000E+04, 3.2536959242E+04, 5.0452589586E+03, 1.7614097449E+04, 3.5000173607E+03, 9.7507166017E-01],
	[4.24050E+04, 3.2543699625E+04, 5.0452897723E+03, 1.7620863805E+04, 3.5003772656E+03, 9.7508184261E-01],
	[4.24100E+04, 3.2550440610E+04, 5.0453205826E+03, 1.7627631960E+04, 3.5007370833E+03, 9.7509202011E-01],
	[4.24150E+04, 3.2557182196E+04, 5.0453513894E+03, 1.7634401914E+04, 3.5010968137E+03, 9.7510219268E-01],
	[4.24200E+04, 3.2563924384E+04, 5.0453821928E+03, 1.7641173668E+04, 3.5014564568E+03, 9.7511236031E-01],
	[4.24250E+04, 3.2570667172E+04, 5.0454129927E+03, 1.7647947222E+04, 3.5018160126E+03, 9.7512252301E-01],
	[4.24300E+04, 3.2577410562E+04, 5.0454437892E+03, 1.7654722577E+04, 3.5021754812E+03, 9.7513268079E-01],
	[4.24350E+04, 3.2584154554E+04, 5.0454745823E+03, 1.7661499732E+04, 3.5025348626E+03, 9.7514283364E-01],
	[4.24400E+04, 3.2590899146E+04, 5.0455053719E+03, 1.7668278688E+04, 3.5028941567E+03, 9.7515298157E-01],
	[4.24450E+04, 3.2597644340E+04, 5.0455361580E+03, 1.7675059445E+04, 3.5032533637E+03, 9.7516312459E-01],
	[4.24500E+04, 3.2604390135E+04, 5.0455669408E+03, 1.7681842003E+04, 3.5036124836E+03, 9.7517326268E-01],
	[4.24550E+04, 3.2611136532E+04, 5.0455977201E+03, 1.7688626363E+04, 3.5039715163E+03, 9.7518339587E-01],
	[4.24600E+04, 3.2617883529E+04, 5.0456284959E+03, 1.7695412525E+04, 3.5043304618E+03, 9.7519352414E-01],
	[4.24650E+04, 3.2624631128E+04, 5.0456592684E+03, 1.7702200489E+04, 3.5046893203E+03, 9.7520364750E-01],
	[4.24700E+04, 3.2631379328E+04, 5.0456900374E+03, 1.7708990255E+04, 3.5050480916E+03, 9.7521376596E-01],
	[4.24750E+04, 3.2638128129E+04, 5.0457208029E+03, 1.7715781825E+04, 3.5054067759E+03, 9.7522387952E-01],
	[4.24800E+04, 3.2644877531E+04, 5.0457515650E+03, 1.7722575197E+04, 3.5057653731E+03, 9.7523398818E-01],
	[4.24850E+04, 3.2651627535E+04, 5.0457823237E+03, 1.7729370372E+04, 3.5061238833E+03, 9.7524409194E-01],
	[4.24900E+04, 3.2658378139E+04, 5.0458130790E+03, 1.7736167351E+04, 3.5064823064E+03, 9.7525419081E-01],
	[4.24950E+04, 3.2665129345E+04, 5.0458438308E+03, 1.7742966134E+04, 3.5068406426E+03, 9.7526428479E-01],
	[4.25000E+04, 3.2671881151E+04, 5.0458745792E+03, 1.7749766721E+04, 3.5071988918E+03, 9.7527437388E-01],
	[4.25050E+04, 3.2678633559E+04, 5.0459053242E+03, 1.7756569112E+04, 3.5075570540E+03, 9.7528445808E-01],
	[4.25100E+04, 3.2685386568E+04, 5.0459360657E+03, 1.7763373307E+04, 3.5079151293E+03, 9.7529453740E-01],
	[4.25150E+04, 3.2692140177E+04, 5.0459668038E+03, 1.7770179308E+04, 3.5082731176E+03, 9.7530461184E-01],
	[4.25200E+04, 3.2698894388E+04, 5.0459975385E+03, 1.7776987113E+04, 3.5086310190E+03, 9.7531468141E-01],
	[4.25250E+04, 3.2705649200E+04, 5.0460282697E+03, 1.7783796724E+04, 3.5089888336E+03, 9.7532474610E-01],
	[4.25300E+04, 3.2712404613E+04, 5.0460589975E+03, 1.7790608141E+04, 3.5093465612E+03, 9.7533480592E-01],
	[4.25350E+04, 3.2719160626E+04, 5.0460897219E+03, 1.7797421363E+04, 3.5097042020E+03, 9.7534486087E-01],
	[4.25400E+04, 3.2725917241E+04, 5.0461204429E+03, 1.7804236391E+04, 3.5100617560E+03, 9.7535491095E-01],
	[4.25450E+04, 3.2732674456E+04, 5.0461511605E+03, 1.7811053226E+04, 3.5104192232E+03, 9.7536495617E-01],
	[4.25500E+04, 3.2739432273E+04, 5.0461818746E+03, 1.7817871868E+04, 3.5107766035E+03, 9.7537499653E-01],
	[4.25550E+04, 3.2746190690E+04, 5.0462125853E+03, 1.7824692317E+04, 3.5111338971E+03, 9.7538503203E-01],
	[4.25600E+04, 3.2752949708E+04, 5.0462432926E+03, 1.7831514573E+04, 3.5114911039E+03, 9.7539506267E-01],
	[4.25650E+04, 3.2759709327E+04, 5.0462739965E+03, 1.7838338636E+04, 3.5118482240E+03, 9.7540508847E-01],
	[4.25700E+04, 3.2766469547E+04, 5.0463046969E+03, 1.7845164507E+04, 3.5122052573E+03, 9.7541510941E-01],
	[4.25750E+04, 3.2773230367E+04, 5.0463353939E+03, 1.7851992186E+04, 3.5125622039E+03, 9.7542512551E-01],
	[4.25800E+04, 3.2779991789E+04, 5.0463660875E+03, 1.7858821674E+04, 3.5129190639E+03, 9.7543513676E-01],
	[4.25850E+04, 3.2786753811E+04, 5.0463967777E+03, 1.7865652970E+04, 3.5132758371E+03, 9.7544514317E-01],
	[4.25900E+04, 3.2793516434E+04, 5.0464274645E+03, 1.7872486074E+04, 3.5136325237E+03, 9.7545514474E-01],
	[4.25950E+04, 3.2800279657E+04, 5.0464581479E+03, 1.7879320988E+04, 3.5139891237E+03, 9.7546514148E-01],
	[4.26000E+04, 3.2807043482E+04, 5.0464888278E+03, 1.7886157711E+04, 3.5143456370E+03, 9.7547513338E-01],
	[4.26050E+04, 3.2813807907E+04, 5.0465195043E+03, 1.7892996244E+04, 3.5147020638E+03, 9.7548512045E-01],
	[4.26100E+04, 3.2820572933E+04, 5.0465501775E+03, 1.7899836587E+04, 3.5150584040E+03, 9.7549510270E-01],
	[4.26150E+04, 3.2827338559E+04, 5.0465808472E+03, 1.7906678740E+04, 3.5154146576E+03, 9.7550508012E-01],
	[4.26200E+04, 3.2834104786E+04, 5.0466115135E+03, 1.7913522703E+04, 3.5157708246E+03, 9.7551505272E-01],
	[4.26250E+04, 3.2840871614E+04, 5.0466421763E+03, 1.7920368477E+04, 3.5161269052E+03, 9.7552502049E-01],
	[4.26300E+04, 3.2847639043E+04, 5.0466728358E+03, 1.7927216062E+04, 3.5164828992E+03, 9.7553498345E-01],
	[4.26350E+04, 3.2854407072E+04, 5.0467034919E+03, 1.7934065458E+04, 3.5168388068E+03, 9.7554494160E-01],
	[4.26400E+04, 3.2861175701E+04, 5.0467341445E+03, 1.7940916666E+04, 3.5171946278E+03, 9.7555489494E-01],
	[4.26450E+04, 3.2867944931E+04, 5.0467647938E+03, 1.7947769685E+04, 3.5175503624E+03, 9.7556484346E-01],
	[4.26500E+04, 3.2874714762E+04, 5.0467954396E+03, 1.7954624516E+04, 3.5179060106E+03, 9.7557478719E-01],
	[4.26550E+04, 3.2881485193E+04, 5.0468260820E+03, 1.7961481160E+04, 3.5182615724E+03, 9.7558472610E-01],
	[4.26600E+04, 3.2888256225E+04, 5.0468567211E+03, 1.7968339616E+04, 3.5186170478E+03, 9.7559466022E-01],
	[4.26650E+04, 3.2895027858E+04, 5.0468873567E+03, 1.7975199885E+04, 3.5189724367E+03, 9.7560458954E-01],
	[4.26700E+04, 3.2901800090E+04, 5.0469179889E+03, 1.7982061967E+04, 3.5193277394E+03, 9.7561451406E-01],
	[4.26750E+04, 3.2908572924E+04, 5.0469486177E+03, 1.7988925862E+04, 3.5196829557E+03, 9.7562443380E-01],
	[4.26800E+04, 3.2915346357E+04, 5.0469792431E+03, 1.7995791571E+04, 3.5200380856E+03, 9.7563434874E-01],
	[4.26850E+04, 3.2922120391E+04, 5.0470098651E+03, 1.8002659094E+04, 3.5203931293E+03, 9.7564425890E-01],
	[4.26900E+04, 3.2928895026E+04, 5.0470404837E+03, 1.8009528431E+04, 3.5207480866E+03, 9.7565416427E-01],
	[4.26950E+04, 3.2935670261E+04, 5.0470710989E+03, 1.8016399582E+04, 3.5211029577E+03, 9.7566406486E-01],
	[4.27000E+04, 3.2942446096E+04, 5.0471017107E+03, 1.8023272548E+04, 3.5214577426E+03, 9.7567396067E-01],
	[4.27050E+04, 3.2949222532E+04, 5.0471323192E+03, 1.8030147329E+04, 3.5218124412E+03, 9.7568385171E-01],
	[4.27100E+04, 3.2955999568E+04, 5.0471629242E+03, 1.8037023925E+04, 3.5221670536E+03, 9.7569373797E-01],
	[4.27150E+04, 3.2962777204E+04, 5.0471935258E+03, 1.8043902337E+04, 3.5225215798E+03, 9.7570361946E-01],
	[4.27200E+04, 3.2969555441E+04, 5.0472241240E+03, 1.8050782564E+04, 3.5228760198E+03, 9.7571349618E-01],
	[4.27250E+04, 3.2976334278E+04, 5.0472547188E+03, 1.8057664608E+04, 3.5232303736E+03, 9.7572336814E-01],
	[4.27300E+04, 3.2983113715E+04, 5.0472853102E+03, 1.8064548467E+04, 3.5235846414E+03, 9.7573323534E-01],
	[4.27350E+04, 3.2989893753E+04, 5.0473158983E+03, 1.8071434143E+04, 3.5239388230E+03, 9.7574309777E-01],
	[4.27400E+04, 3.2996674391E+04, 5.0473464829E+03, 1.8078321636E+04, 3.5242929185E+03, 9.7575295545E-01],
	[4.27450E+04, 3.3003455629E+04, 5.0473770642E+03, 1.8085210946E+04, 3.5246469279E+03, 9.7576280838E-01],
	[4.27500E+04, 3.3010237467E+04, 5.0474076420E+03, 1.8092102074E+04, 3.5250008512E+03, 9.7577265655E-01],
	[4.27550E+04, 3.3017019905E+04, 5.0474382165E+03, 1.8098995018E+04, 3.5253546885E+03, 9.7578249997E-01],
	[4.27600E+04, 3.3023802944E+04, 5.0474687876E+03, 1.8105889781E+04, 3.5257084397E+03, 9.7579233865E-01],
	[4.27650E+04, 3.3030586583E+04, 5.0474993552E+03, 1.8112786362E+04, 3.5260621050E+03, 9.7580217259E-01],
	[4.27700E+04, 3.3037370822E+04, 5.0475299195E+03, 1.8119684761E+04, 3.5264156842E+03, 9.7581200178E-01],
	[4.27750E+04, 3.3044155661E+04, 5.0475604805E+03, 1.8126584979E+04, 3.5267691775E+03, 9.7582182624E-01],
	[4.27800E+04, 3.3050941100E+04, 5.0475910380E+03, 1.8133487016E+04, 3.5271225848E+03, 9.7583164595E-01],
	[4.27850E+04, 3.3057727139E+04, 5.0476215921E+03, 1.8140390872E+04, 3.5274759062E+03, 9.7584146094E-01],
	[4.27900E+04, 3.3064513779E+04, 5.0476521429E+03, 1.8147296548E+04, 3.5278291416E+03, 9.7585127119E-01],
	[4.27950E+04, 3.3071301018E+04, 5.0476826902E+03, 1.8154204043E+04, 3.5281822912E+03, 9.7586107672E-01],
	[4.28000E+04, 3.3078088857E+04, 5.0477132342E+03, 1.8161113358E+04, 3.5285353549E+03, 9.7587087752E-01],
	[4.28050E+04, 3.3084877297E+04, 5.0477437748E+03, 1.8168024494E+04, 3.5288883327E+03, 9.7588067359E-01],
	[4.28100E+04, 3.3091666336E+04, 5.0477743120E+03, 1.8174937450E+04, 3.5292412246E+03, 9.7589046494E-01],
	[4.28150E+04, 3.3098455976E+04, 5.0478048459E+03, 1.8181852226E+04, 3.5295940307E+03, 9.7590025157E-01],
	[4.28200E+04, 3.3105246215E+04, 5.0478353763E+03, 1.8188768824E+04, 3.5299467511E+03, 9.7591003349E-01],
	[4.28250E+04, 3.3112037054E+04, 5.0478659034E+03, 1.8195687243E+04, 3.5302993856E+03, 9.7591981069E-01],
	[4.28300E+04, 3.3118828494E+04, 5.0478964271E+03, 1.8202607484E+04, 3.5306519343E+03, 9.7592958318E-01],
	[4.28350E+04, 3.3125620533E+04, 5.0479269474E+03, 1.8209529547E+04, 3.5310043973E+03, 9.7593935096E-01],
	[4.28400E+04, 3.3132413172E+04, 5.0479574643E+03, 1.8216453431E+04, 3.5313567746E+03, 9.7594911403E-01],
	[4.28450E+04, 3.3139206411E+04, 5.0479879779E+03, 1.8223379138E+04, 3.5317090661E+03, 9.7595887240E-01],
	[4.28500E+04, 3.3146000250E+04, 5.0480184881E+03, 1.8230306668E+04, 3.5320612719E+03, 9.7596862606E-01],
	[4.28550E+04, 3.3152794689E+04, 5.0480489949E+03, 1.8237236021E+04, 3.5324133921E+03, 9.7597837503E-01],
	[4.28600E+04, 3.3159589728E+04, 5.0480794983E+03, 1.8244167197E+04, 3.5327654266E+03, 9.7598811929E-01],
	[4.28650E+04, 3.3166385366E+04, 5.0481099984E+03, 1.8251100196E+04, 3.5331173754E+03, 9.7599785887E-01],
	[4.28700E+04, 3.3173181604E+04, 5.0481404950E+03, 1.8258035019E+04, 3.5334692386E+03, 9.7600759375E-01],
	[4.28750E+04, 3.3179978442E+04, 5.0481709884E+03, 1.8264971666E+04, 3.5338210163E+03, 9.7601732394E-01],
	[4.28800E+04, 3.3186775880E+04, 5.0482014783E+03, 1.8271910137E+04, 3.5341727083E+03, 9.7602704944E-01],
	[4.28850E+04, 3.3193573918E+04, 5.0482319649E+03, 1.8278850433E+04, 3.5345243147E+03, 9.7603677026E-01],
	[4.28900E+04, 3.3200372555E+04, 5.0482624481E+03, 1.8285792553E+04, 3.5348758356E+03, 9.7604648639E-01],
	[4.28950E+04, 3.3207171792E+04, 5.0482929279E+03, 1.8292736499E+04, 3.5352272710E+03, 9.7605619785E-01],
	[4.29000E+04, 3.3213971628E+04, 5.0483234044E+03, 1.8299682270E+04, 3.5355786208E+03, 9.7606590462E-01],
	[4.29050E+04, 3.3220772065E+04, 5.0483538775E+03, 1.8306629866E+04, 3.5359298852E+03, 9.7607560672E-01],
	[4.29100E+04, 3.3227573101E+04, 5.0483843472E+03, 1.8313579288E+04, 3.5362810640E+03, 9.7608530415E-01],
	[4.29150E+04, 3.3234374737E+04, 5.0484148136E+03, 1.8320530537E+04, 3.5366321574E+03, 9.7609499691E-01],
	[4.29200E+04, 3.3241176972E+04, 5.0484452765E+03, 1.8327483611E+04, 3.5369831654E+03, 9.7610468500E-01],
	[4.29250E+04, 3.3247979807E+04, 5.0484757362E+03, 1.8334438513E+04, 3.5373340879E+03, 9.7611436842E-01],
	[4.29300E+04, 3.3254783241E+04, 5.0485061924E+03, 1.8341395241E+04, 3.5376849251E+03, 9.7612404719E-01],
	[4.29350E+04, 3.3261587276E+04, 5.0485366453E+03, 1.8348353797E+04, 3.5380356768E+03, 9.7613372129E-01],
	[4.29400E+04, 3.3268391909E+04, 5.0485670949E+03, 1.8355314180E+04, 3.5383863432E+03, 9.7614339073E-01],
	[4.29450E+04, 3.3275197142E+04, 5.0485975411E+03, 1.8362276390E+04, 3.5387369242E+03, 9.7615305551E-01],
	[4.29500E+04, 3.3282002975E+04, 5.0486279839E+03, 1.8369240429E+04, 3.5390874199E+03, 9.7616271565E-01],
	[4.29550E+04, 3.3288809408E+04, 5.0486584233E+03, 1.8376206296E+04, 3.5394378303E+03, 9.7617237113E-01],
	[4.29600E+04, 3.3295616439E+04, 5.0486888594E+03, 1.8383173991E+04, 3.5397881554E+03, 9.7618202196E-01],
	[4.29650E+04, 3.3302424071E+04, 5.0487192922E+03, 1.8390143515E+04, 3.5401383952E+03, 9.7619166815E-01],
	[4.29700E+04, 3.3309232301E+04, 5.0487497216E+03, 1.8397114868E+04, 3.5404885497E+03, 9.7620130969E-01],
	[4.29750E+04, 3.3316041131E+04, 5.0487801476E+03, 1.8404088051E+04, 3.5408386191E+03, 9.7621094659E-01],
	[4.29800E+04, 3.3322850561E+04, 5.0488105703E+03, 1.8411063063E+04, 3.5411886031E+03, 9.7622057885E-01],
	[4.29850E+04, 3.3329660590E+04, 5.0488409896E+03, 1.8418039905E+04, 3.5415385020E+03, 9.7623020648E-01],
	[4.29900E+04, 3.3336471218E+04, 5.0488714055E+03, 1.8425018577E+04, 3.5418883157E+03, 9.7623982947E-01],
	[4.29950E+04, 3.3343282446E+04, 5.0489018181E+03, 1.8431999079E+04, 3.5422380443E+03, 9.7624944783E-01],
	[4.30000E+04, 3.3350094273E+04, 5.0489322274E+03, 1.8438981412E+04, 3.5425876877E+03, 9.7625906157E-01],
	[4.30050E+04, 3.3356906700E+04, 5.0489626333E+03, 1.8445965576E+04, 3.5429372459E+03, 9.7626867067E-01],
	[4.30100E+04, 3.3363719726E+04, 5.0489930358E+03, 1.8452951571E+04, 3.5432867191E+03, 9.7627827515E-01],
	[4.30150E+04, 3.3370533351E+04, 5.0490234350E+03, 1.8459939398E+04, 3.5436361071E+03, 9.7628787501E-01],
	[4.30200E+04, 3.3377347575E+04, 5.0490538309E+03, 1.8466929056E+04, 3.5439854101E+03, 9.7629747025E-01],
	[4.30250E+04, 3.3384162399E+04, 5.0490842234E+03, 1.8473920546E+04, 3.5443346280E+03, 9.7630706087E-01],
	[4.30300E+04, 3.3390977822E+04, 5.0491146125E+03, 1.8480913869E+04, 3.5446837609E+03, 9.7631664688E-01],
	[4.30350E+04, 3.3397793844E+04, 5.0491449983E+03, 1.8487909024E+04, 3.5450328088E+03, 9.7632622828E-01],
	[4.30400E+04, 3.3404610466E+04, 5.0491753807E+03, 1.8494906011E+04, 3.5453817717E+03, 9.7633580506E-01],
	[4.30450E+04, 3.3411427686E+04, 5.0492057599E+03, 1.8501904832E+04, 3.5457306496E+03, 9.7634537724E-01],
	[4.30500E+04, 3.3418245506E+04, 5.0492361356E+03, 1.8508905486E+04, 3.5460794425E+03, 9.7635494482E-01],
	[4.30550E+04, 3.3425063925E+04, 5.0492665080E+03, 1.8515907974E+04, 3.5464281505E+03, 9.7636450779E-01],
	[4.30600E+04, 3.3431882943E+04, 5.0492968771E+03, 1.8522912295E+04, 3.5467767735E+03, 9.7637406616E-01],
	[4.30650E+04, 3.3438702561E+04, 5.0493272428E+03, 1.8529918451E+04, 3.5471253117E+03, 9.7638361993E-01],
	[4.30700E+04, 3.3445522777E+04, 5.0493576052E+03, 1.8536926441E+04, 3.5474737649E+03, 9.7639316911E-01],
	[4.30750E+04, 3.3452343593E+04, 5.0493879642E+03, 1.8543936265E+04, 3.5478221333E+03, 9.7640271370E-01],
	[4.30800E+04, 3.3459165007E+04, 5.0494183199E+03, 1.8550947925E+04, 3.5481704169E+03, 9.7641225369E-01],
	[4.30850E+04, 3.3465987021E+04, 5.0494486723E+03, 1.8557961419E+04, 3.5485186156E+03, 9.7642178910E-01],
	[4.30900E+04, 3.3472809634E+04, 5.0494790213E+03, 1.8564976749E+04, 3.5488667295E+03, 9.7643131992E-01],
	[4.30950E+04, 3.3479632845E+04, 5.0495093670E+03, 1.8571993915E+04, 3.5492147586E+03, 9.7644084616E-01],
	[4.31000E+04, 3.3486456656E+04, 5.0495397093E+03, 1.8579012917E+04, 3.5495627029E+03, 9.7645036782E-01],
	[4.31050E+04, 3.3493281066E+04, 5.0495700483E+03, 1.8586033755E+04, 3.5499105624E+03, 9.7645988490E-01],
	[4.31100E+04, 3.3500106075E+04, 5.0496003840E+03, 1.8593056429E+04, 3.5502583373E+03, 9.7646939740E-01],
	[4.31150E+04, 3.3506931683E+04, 5.0496307163E+03, 1.8600080941E+04, 3.5506060273E+03, 9.7647890533E-01],
	[4.31200E+04, 3.3513757889E+04, 5.0496610453E+03, 1.8607107289E+04, 3.5509536327E+03, 9.7648840869E-01],
	[4.31250E+04, 3.3520584695E+04, 5.0496913710E+03, 1.8614135475E+04, 3.5513011534E+03, 9.7649790748E-01],
	[4.31300E+04, 3.3527412100E+04, 5.0497216933E+03, 1.8621165498E+04, 3.5516485895E+03, 9.7650740171E-01],
	[4.31350E+04, 3.3534240103E+04, 5.0497520123E+03, 1.8628197359E+04, 3.5519959409E+03, 9.7651689137E-01],
	[4.31400E+04, 3.3541068706E+04, 5.0497823280E+03, 1.8635231058E+04, 3.5523432076E+03, 9.7652637646E-01],
	[4.31450E+04, 3.3547897907E+04, 5.0498126403E+03, 1.8642266595E+04, 3.5526903898E+03, 9.7653585700E-01],
	[4.31500E+04, 3.3554727707E+04, 5.0498429493E+03, 1.8649303971E+04, 3.5530374873E+03, 9.7654533299E-01],
	[4.31550E+04, 3.3561558106E+04, 5.0498732550E+03, 1.8656343186E+04, 3.5533845003E+03, 9.7655480442E-01],
	[4.31600E+04, 3.3568389104E+04, 5.0499035573E+03, 1.8663384241E+04, 3.5537314287E+03, 9.7656427129E-01],
	[4.31650E+04, 3.3575220700E+04, 5.0499338563E+03, 1.8670427134E+04, 3.5540782726E+03, 9.7657373362E-01],
	[4.31700E+04, 3.3582052896E+04, 5.0499641520E+03, 1.8677471867E+04, 3.5544250320E+03, 9.7658319140E-01],
	[4.31750E+04, 3.3588885690E+04, 5.0499944444E+03, 1.8684518441E+04, 3.5547717068E+03, 9.7659264464E-01],
	[4.31800E+04, 3.3595719083E+04, 5.0500247334E+03, 1.8691566854E+04, 3.5551182972E+03, 9.7660209333E-01],
	[4.31850E+04, 3.3602553074E+04, 5.0500550191E+03, 1.8698617108E+04, 3.5554648031E+03, 9.7661153749E-01],
	[4.31900E+04, 3.3609387665E+04, 5.0500853015E+03, 1.8705669203E+04, 3.5558112246E+03, 9.7662097710E-01],
	[4.31950E+04, 3.3616222854E+04, 5.0501155806E+03, 1.8712723139E+04, 3.5561575617E+03, 9.7663041219E-01],
	[4.32000E+04, 3.3623058642E+04, 5.0501458563E+03, 1.8719778916E+04, 3.5565038143E+03, 9.7663984274E-01],
	[4.32050E+04, 3.3629895028E+04, 5.0501761287E+03, 1.8726836535E+04, 3.5568499826E+03, 9.7664926876E-01],
	[4.32100E+04, 3.3636732013E+04, 5.0502063978E+03, 1.8733895995E+04, 3.5571960664E+03, 9.7665869025E-01],
	[4.32150E+04, 3.3643569597E+04, 5.0502366636E+03, 1.8740957298E+04, 3.5575420660E+03, 9.7666810721E-01],
	[4.32200E+04, 3.3650407779E+04, 5.0502669260E+03, 1.8748020443E+04, 3.5578879812E+03, 9.7667751965E-01],
	[4.32250E+04, 3.3657246560E+04, 5.0502971851E+03, 1.8755085430E+04, 3.5582338120E+03, 9.7668692758E-01],
	[4.32300E+04, 3.3664085939E+04, 5.0503274409E+03, 1.8762152261E+04, 3.5585795586E+03, 9.7669633098E-01],
	[4.32350E+04, 3.3670925918E+04, 5.0503576934E+03, 1.8769220935E+04, 3.5589252209E+03, 9.7670572987E-01],
	[4.32400E+04, 3.3677766494E+04, 5.0503879426E+03, 1.8776291452E+04, 3.5592707990E+03, 9.7671512424E-01],
	[4.32450E+04, 3.3684607669E+04, 5.0504181885E+03, 1.8783363812E+04, 3.5596162928E+03, 9.7672451411E-01],
	[4.32500E+04, 3.3691449443E+04, 5.0504484310E+03, 1.8790438017E+04, 3.5599617024E+03, 9.7673389946E-01],
	[4.32550E+04, 3.3698291815E+04, 5.0504786702E+03, 1.8797514066E+04, 3.5603070277E+03, 9.7674328031E-01],
	[4.32600E+04, 3.3705134786E+04, 5.0505089062E+03, 1.8804591960E+04, 3.5606522689E+03, 9.7675265666E-01],
	[4.32650E+04, 3.3711978355E+04, 5.0505391388E+03, 1.8811671698E+04, 3.5609974260E+03, 9.7676202850E-01],
	[4.32700E+04, 3.3718822522E+04, 5.0505693681E+03, 1.8818753281E+04, 3.5613424988E+03, 9.7677139584E-01],
	[4.32750E+04, 3.3725667288E+04, 5.0505995940E+03, 1.8825836710E+04, 3.5616874876E+03, 9.7678075869E-01],
	[4.32800E+04, 3.3732512653E+04, 5.0506298167E+03, 1.8832921984E+04, 3.5620323922E+03, 9.7679011704E-01],
	[4.32850E+04, 3.3739358616E+04, 5.0506600360E+03, 1.8840009104E+04, 3.5623772128E+03, 9.7679947090E-01],
	[4.32900E+04, 3.3746205177E+04, 5.0506902521E+03, 1.8847098071E+04, 3.5627219492E+03, 9.7680882028E-01],
	[4.32950E+04, 3.3753052336E+04, 5.0507204648E+03, 1.8854188883E+04, 3.5630666016E+03, 9.7681816516E-01],
	[4.33000E+04, 3.3759900094E+04, 5.0507506743E+03, 1.8861281542E+04, 3.5634111700E+03, 9.7682750556E-01],
	[4.33050E+04, 3.3766748450E+04, 5.0507808804E+03, 1.8868376048E+04, 3.5637556544E+03, 9.7683684148E-01],
	[4.33100E+04, 3.3773597405E+04, 5.0508110832E+03, 1.8875472402E+04, 3.5641000547E+03, 9.7684617291E-01],
	[4.33150E+04, 3.3780446958E+04, 5.0508412827E+03, 1.8882570602E+04, 3.5644443711E+03, 9.7685549987E-01],
	[4.33200E+04, 3.3787297109E+04, 5.0508714789E+03, 1.8889670651E+04, 3.5647886035E+03, 9.7686482236E-01],
	[4.33250E+04, 3.3794147858E+04, 5.0509016718E+03, 1.8896772547E+04, 3.5651327520E+03, 9.7687414037E-01],
	[4.33300E+04, 3.3800999206E+04, 5.0509318614E+03, 1.8903876292E+04, 3.5654768165E+03, 9.7688345391E-01],
	[4.33350E+04, 3.3807851152E+04, 5.0509620477E+03, 1.8910981885E+04, 3.5658207972E+03, 9.7689276298E-01],
	[4.33400E+04, 3.3814703696E+04, 5.0509922307E+03, 1.8918089327E+04, 3.5661646939E+03, 9.7690206759E-01],
	[4.33450E+04, 3.3821556838E+04, 5.0510224104E+03, 1.8925198618E+04, 3.5665085068E+03, 9.7691136773E-01],
	[4.33500E+04, 3.3828410579E+04, 5.0510525867E+03, 1.8932309758E+04, 3.5668522358E+03, 9.7692066342E-01],
	[4.33550E+04, 3.3835264917E+04, 5.0510827598E+03, 1.8939422748E+04, 3.5671958810E+03, 9.7692995464E-01],
	[4.33600E+04, 3.3842119854E+04, 5.0511129296E+03, 1.8946537587E+04, 3.5675394424E+03, 9.7693924141E-01],
	[4.33650E+04, 3.3848975389E+04, 5.0511430961E+03, 1.8953654277E+04, 3.5678829200E+03, 9.7694852372E-01],
	[4.33700E+04, 3.3855831522E+04, 5.0511732593E+03, 1.8960772817E+04, 3.5682263138E+03, 9.7695780158E-01],
	[4.33750E+04, 3.3862688253E+04, 5.0512034192E+03, 1.8967893208E+04, 3.5685696238E+03, 9.7696707500E-01],
	[4.33800E+04, 3.3869545582E+04, 5.0512335758E+03, 1.8975015449E+04, 3.5689128501E+03, 9.7697634396E-01],
	[4.33850E+04, 3.3876403510E+04, 5.0512637291E+03, 1.8982139542E+04, 3.5692559927E+03, 9.7698560848E-01],
	[4.33900E+04, 3.3883262035E+04, 5.0512938791E+03, 1.8989265487E+04, 3.5695990516E+03, 9.7699486856E-01],
	[4.33950E+04, 3.3890121158E+04, 5.0513240258E+03, 1.8996393283E+04, 3.5699420268E+03, 9.7700412420E-01],
	[4.34000E+04, 3.3896980880E+04, 5.0513541692E+03, 1.9003522931E+04, 3.5702849183E+03, 9.7701337541E-01],
	[4.34050E+04, 3.3903841199E+04, 5.0513843093E+03, 1.9010654431E+04, 3.5706277262E+03, 9.7702262217E-01],
	[4.34100E+04, 3.3910708728E+04, 5.0514154076E+03, 1.9017787784E+04, 3.5709710042E+03, 9.7703186451E-01],
	[4.34150E+04, 3.3917605031E+04, 5.0514505982E+03, 1.9024922989E+04, 3.5713165583E+03, 9.7704110241E-01],
	[4.34200E+04, 3.3924501941E+04, 5.0514857849E+03, 1.9032060048E+04, 3.5716620294E+03, 9.7705033589E-01],
	[4.34250E+04, 3.3931399460E+04, 5.0515209679E+03, 1.9039198960E+04, 3.5720074174E+03, 9.7705956494E-01],
	[4.34300E+04, 3.3938297586E+04, 5.0515561470E+03, 1.9046339725E+04, 3.5723527226E+03, 9.7706878957E-01],
	[4.34350E+04, 3.3945196321E+04, 5.0515913224E+03, 1.9053482344E+04, 3.5726979448E+03, 9.7707800978E-01],
	[4.34400E+04, 3.3952095664E+04, 5.0516264939E+03, 1.9060626818E+04, 3.5730430840E+03, 9.7708722557E-01],
	[4.34450E+04, 3.3958995614E+04, 5.0516616616E+03, 1.9067773145E+04, 3.5733881404E+03, 9.7709643694E-01],
	[4.34500E+04, 3.3965896173E+04, 5.0516968255E+03, 1.9074921328E+04, 3.5737331139E+03, 9.7710564390E-01],
	[4.34550E+04, 3.3972797339E+04, 5.0517319857E+03, 1.9082071365E+04, 3.5740780045E+03, 9.7711484645E-01],
	[4.34600E+04, 3.3979699113E+04, 5.0517671420E+03, 1.9089223258E+04, 3.5744228123E+03, 9.7712404459E-01],
	[4.34650E+04, 3.3986601495E+04, 5.0518022945E+03, 1.9096377006E+04, 3.5747675372E+03, 9.7713323832E-01],
	[4.34700E+04, 3.3993504485E+04, 5.0518374432E+03, 1.9103532609E+04, 3.5751121793E+03, 9.7714242765E-01],
	[4.34750E+04, 3.4000408083E+04, 5.0518725882E+03, 1.9110690069E+04, 3.5754567387E+03, 9.7715161258E-01],
	[4.34800E+04, 3.4007312289E+04, 5.0519077293E+03, 1.9117849385E+04, 3.5758012152E+03, 9.7716079310E-01],
	[4.34850E+04, 3.4014217103E+04, 5.0519428666E+03, 1.9125010558E+04, 3.5761456090E+03, 9.7716996923E-01],
	[4.34900E+04, 3.4021122524E+04, 5.0519780002E+03, 1.9132173587E+04, 3.5764899201E+03, 9.7717914097E-01],
	[4.34950E+04, 3.4028028554E+04, 5.0520131299E+03, 1.9139338473E+04, 3.5768341485E+03, 9.7718830831E-01],
	[4.35000E+04, 3.4034935191E+04, 5.0520482559E+03, 1.9146505217E+04, 3.5771782941E+03, 9.7719747126E-01],
	[4.35050E+04, 3.4041842436E+04, 5.0520833780E+03, 1.9153673818E+04, 3.5775223571E+03, 9.7720662983E-01],
	[4.35100E+04, 3.4048750288E+04, 5.0521184964E+03, 1.9160844277E+04, 3.5778663374E+03, 9.7721578400E-01],
	[4.35150E+04, 3.4055658748E+04, 5.0521536110E+03, 1.9168016594E+04, 3.5782102350E+03, 9.7722493380E-01],
	[4.35200E+04, 3.4062567816E+04, 5.0521887217E+03, 1.9175190770E+04, 3.5785540500E+03, 9.7723407922E-01],
	[4.35250E+04, 3.4069477492E+04, 5.0522238287E+03, 1.9182366804E+04, 3.5788977824E+03, 9.7724322025E-01],
	[4.35300E+04, 3.4076387776E+04, 5.0522589319E+03, 1.9189544697E+04, 3.5792414322E+03, 9.7725235691E-01],
	[4.35350E+04, 3.4083298667E+04, 5.0522940314E+03, 1.9196724449E+04, 3.5795849995E+03, 9.7726148920E-01],
	[4.35400E+04, 3.4090210166E+04, 5.0523291270E+03, 1.9203906061E+04, 3.5799284842E+03, 9.7727061711E-01],
	[4.35450E+04, 3.4097122272E+04, 5.0523642188E+03, 1.9211089533E+04, 3.5802718863E+03, 9.7727974066E-01],
	[4.35500E+04, 3.4104034986E+04, 5.0523993069E+03, 1.9218274864E+04, 3.5806152059E+03, 9.7728885984E-01],
	[4.35550E+04, 3.4110948308E+04, 5.0524343912E+03, 1.9225462056E+04, 3.5809584431E+03, 9.7729797466E-01],
	[4.35600E+04, 3.4117862237E+04, 5.0524694717E+03, 1.9232651108E+04, 3.5813015977E+03, 9.7730708511E-01],
	[4.35650E+04, 3.4124776774E+04, 5.0525045484E+03, 1.9239842021E+04, 3.5816446699E+03, 9.7731619120E-01],
	[4.35700E+04, 3.4131691918E+04, 5.0525396213E+03, 1.9247034795E+04, 3.5819876596E+03, 9.7732529294E-01],
	[4.35750E+04, 3.4138607670E+04, 5.0525746904E+03, 1.9254229431E+04, 3.5823305669E+03, 9.7733439032E-01],
	[4.35800E+04, 3.4145524029E+04, 5.0526097558E+03, 1.9261425928E+04, 3.5826733918E+03, 9.7734348335E-01],
	[4.35850E+04, 3.4152440996E+04, 5.0526448174E+03, 1.9268624287E+04, 3.5830161343E+03, 9.7735257203E-01],
	[4.35900E+04, 3.4159358571E+04, 5.0526798752E+03, 1.9275824508E+04, 3.5833587945E+03, 9.7736165636E-01],
	[4.35950E+04, 3.4166276753E+04, 5.0527149292E+03, 1.9283026591E+04, 3.5837013722E+03, 9.7737073634E-01],
	[4.36000E+04, 3.4173195542E+04, 5.0527499794E+03, 1.9290230537E+04, 3.5840438677E+03, 9.7737981198E-01],
	[4.36050E+04, 3.4180114939E+04, 5.0527850259E+03, 1.9297436346E+04, 3.5843862808E+03, 9.7738888328E-01],
	[4.36100E+04, 3.4187034943E+04, 5.0528200686E+03, 1.9304644019E+04, 3.5847286116E+03, 9.7739795025E-01],
	[4.36150E+04, 3.4193955555E+04, 5.0528551075E+03, 1.9311853554E+04, 3.5850708601E+03, 9.7740701287E-01],
	[4.36200E+04, 3.4200876774E+04, 5.0528901427E+03, 1.9319064954E+04, 3.5854130264E+03, 9.7741607116E-01],
	[4.36250E+04, 3.4207798600E+04, 5.0529251741E+03, 1.9326278217E+04, 3.5857551104E+03, 9.7742512512E-01],
	[4.36300E+04, 3.4214721034E+04, 5.0529602017E+03, 1.9333493345E+04, 3.5860971122E+03, 9.7743417475E-01],
	[4.36350E+04, 3.4221644075E+04, 5.0529952255E+03, 1.9340710337E+04, 3.5864390318E+03, 9.7744322006E-01],
	[4.36400E+04, 3.4228567724E+04, 5.0530302456E+03, 1.9347929194E+04, 3.5867808692E+03, 9.7745226103E-01],
	[4.36450E+04, 3.4235491979E+04, 5.0530652619E+03, 1.9355149916E+04, 3.5871226245E+03, 9.7746129769E-01],
	[4.36500E+04, 3.4242416843E+04, 5.0531002744E+03, 1.9362372504E+04, 3.5874642975E+03, 9.7747033003E-01],
	[4.36550E+04, 3.4249342313E+04, 5.0531352831E+03, 1.9369596957E+04, 3.5878058885E+03, 9.7747935805E-01],
	[4.36600E+04, 3.4256268391E+04, 5.0531702881E+03, 1.9376823276E+04, 3.5881473973E+03, 9.7748838175E-01],
	[4.36650E+04, 3.4263195075E+04, 5.0532052894E+03, 1.9384051461E+04, 3.5884888240E+03, 9.7749740114E-01],
	[4.36700E+04, 3.4270122368E+04, 5.0532402868E+03, 1.9391281512E+04, 3.5888301687E+03, 9.7750641622E-01],
	[4.36750E+04, 3.4277050267E+04, 5.0532752805E+03, 1.9398513431E+04, 3.5891714312E+03, 9.7751542699E-01],
	[4.36800E+04, 3.4283978773E+04, 5.0533102704E+03, 1.9405747216E+04, 3.5895126118E+03, 9.7752443345E-01],
	[4.36850E+04, 3.4290907887E+04, 5.0533452566E+03, 1.9412982868E+04, 3.5898537103E+03, 9.7753343561E-01],
	[4.36900E+04, 3.4297837608E+04, 5.0533802390E+03, 1.9420220388E+04, 3.5901947268E+03, 9.7754243347E-01],
	[4.36950E+04, 3.4304767936E+04, 5.0534152177E+03, 1.9427459775E+04, 3.5905356613E+03, 9.7755142703E-01],
	[4.37000E+04, 3.4311698871E+04, 5.0534501925E+03, 1.9434701031E+04, 3.5908765138E+03, 9.7756041630E-01],
	[4.37050E+04, 3.4318630413E+04, 5.0534851637E+03, 1.9441944155E+04, 3.5912172844E+03, 9.7756940127E-01],
	[4.37100E+04, 3.4325562563E+04, 5.0535201310E+03, 1.9449189147E+04, 3.5915579730E+03, 9.7757838194E-01],
	[4.37150E+04, 3.4332495319E+04, 5.0535550946E+03, 1.9456436008E+04, 3.5918985798E+03, 9.7758735833E-01],
	[4.37200E+04, 3.4339428683E+04, 5.0535900545E+03, 1.9463684739E+04, 3.5922391046E+03, 9.7759633043E-01],
	[4.37250E+04, 3.4346362653E+04, 5.0536250106E+03, 1.9470935338E+04, 3.5925795476E+03, 9.7760529824E-01],
	[4.37300E+04, 3.4353297231E+04, 5.0536599629E+03, 1.9478187807E+04, 3.5929199087E+03, 9.7761426177E-01],
	[4.37350E+04, 3.4360232416E+04, 5.0536949115E+03, 1.9485442147E+04, 3.5932601879E+03, 9.7762322102E-01],
	[4.37400E+04, 3.4367168207E+04, 5.0537298563E+03, 1.9492698356E+04, 3.5936003853E+03, 9.7763217600E-01],
	[4.37450E+04, 3.4374104606E+04, 5.0537647974E+03, 1.9499956436E+04, 3.5939405010E+03, 9.7764112669E-01],
	[4.37500E+04, 3.4381041612E+04, 5.0537997348E+03, 1.9507216386E+04, 3.5942805348E+03, 9.7765007311E-01],
	[4.37550E+04, 3.4387979224E+04, 5.0538346683E+03, 1.9514478207E+04, 3.5946204869E+03, 9.7765901527E-01],
	[4.37600E+04, 3.4394917444E+04, 5.0538695982E+03, 1.9521741900E+04, 3.5949603572E+03, 9.7766795315E-01],
	[4.37650E+04, 3.4401856270E+04, 5.0539045242E+03, 1.9529007464E+04, 3.5953001457E+03, 9.7767688676E-01],
	[4.37700E+04, 3.4408795703E+04, 5.0539394466E+03, 1.9536274900E+04, 3.5956398526E+03, 9.7768581611E-01],
	[4.37750E+04, 3.4415735744E+04, 5.0539743651E+03, 1.9543544208E+04, 3.5959794778E+03, 9.7769474120E-01],
	[4.37800E+04, 3.4422676391E+04, 5.0540092800E+03, 1.9550815388E+04, 3.5963190212E+03, 9.7770366203E-01],
	[4.37850E+04, 3.4429617645E+04, 5.0540441911E+03, 1.9558088440E+04, 3.5966584831E+03, 9.7771257860E-01],
	[4.37900E+04, 3.4436559505E+04, 5.0540790984E+03, 1.9565363366E+04, 3.5969978632E+03, 9.7772149091E-01],
	[4.37950E+04, 3.4443501973E+04, 5.0541140020E+03, 1.9572640165E+04, 3.5973371618E+03, 9.7773039898E-01],
	[4.38000E+04, 3.4450445047E+04, 5.0541489019E+03, 1.9579918837E+04, 3.5976763788E+03, 9.7773930279E-01],
	[4.38050E+04, 3.4457388729E+04, 5.0541837980E+03, 1.9587199382E+04, 3.5980155141E+03, 9.7774820235E-01],
	[4.38100E+04, 3.4464333017E+04, 5.0542186903E+03, 1.9594481802E+04, 3.5983545679E+03, 9.7775709767E-01],
	[4.38150E+04, 3.4471277911E+04, 5.0542535790E+03, 1.9601766095E+04, 3.5986935402E+03, 9.7776598874E-01],
	[4.38200E+04, 3.4478223413E+04, 5.0542884638E+03, 1.9609052264E+04, 3.5990324309E+03, 9.7777487557E-01],
	[4.38250E+04, 3.4485169521E+04, 5.0543233450E+03, 1.9616340306E+04, 3.5993712401E+03, 9.7778375817E-01],
	[4.38300E+04, 3.4492116236E+04, 5.0543582224E+03, 1.9623630224E+04, 3.5997099678E+03, 9.7779263652E-01],
	[4.38350E+04, 3.4499063558E+04, 5.0543930961E+03, 1.9630922017E+04, 3.6000486140E+03, 9.7780151064E-01],
	[4.38400E+04, 3.4506011486E+04, 5.0544279660E+03, 1.9638215686E+04, 3.6003871788E+03, 9.7781038053E-01],
	[4.38450E+04, 3.4512960021E+04, 5.0544628322E+03, 1.9645511230E+04, 3.6007256621E+03, 9.7781924619E-01],
	[4.38500E+04, 3.4519909163E+04, 5.0544976947E+03, 1.9652808650E+04, 3.6010640640E+03, 9.7782810762E-01],
	[4.38550E+04, 3.4526858911E+04, 5.0545325534E+03, 1.9660107947E+04, 3.6014023845E+03, 9.7783696483E-01],
	[4.38600E+04, 3.4533809266E+04, 5.0545674084E+03, 1.9667409120E+04, 3.6017406236E+03, 9.7784581781E-01],
	[4.38650E+04, 3.4540760227E+04, 5.0546022597E+03, 1.9674712170E+04, 3.6020787814E+03, 9.7785466657E-01],
	[4.38700E+04, 3.4547711795E+04, 5.0546371072E+03, 1.9682017097E+04, 3.6024168578E+03, 9.7786351111E-01],
	[4.38750E+04, 3.4554663970E+04, 5.0546719510E+03, 1.9689323902E+04, 3.6027548528E+03, 9.7787235144E-01],
	[4.38800E+04, 3.4561616751E+04, 5.0547067910E+03, 1.9696632584E+04, 3.6030927666E+03, 9.7788118755E-01],
	[4.38850E+04, 3.4568570139E+04, 5.0547416274E+03, 1.9703943144E+04, 3.6034305990E+03, 9.7789001945E-01],
	[4.38900E+04, 3.4575524133E+04, 5.0547764600E+03, 1.9711255583E+04, 3.6037683502E+03, 9.7789884714E-01],
	[4.38950E+04, 3.4582478734E+04, 5.0548112889E+03, 1.9718569899E+04, 3.6041060201E+03, 9.7790767062E-01],
	[4.39000E+04, 3.4589433941E+04, 5.0548461140E+03, 1.9725886095E+04, 3.6044436088E+03, 9.7791648990E-01],
	[4.39050E+04, 3.4596389755E+04, 5.0548809355E+03, 1.9733204169E+04, 3.6047811163E+03, 9.7792530498E-01],
	[4.39100E+04, 3.4603346175E+04, 5.0549157532E+03, 1.9740524123E+04, 3.6051185426E+03, 9.7793411585E-01],
	[4.39150E+04, 3.4610303201E+04, 5.0549505671E+03, 1.9747845956E+04, 3.6054558876E+03, 9.7794292253E-01],
	[4.39200E+04, 3.4617260834E+04, 5.0549853774E+03, 1.9755169669E+04, 3.6057931516E+03, 9.7795172501E-01],
	[4.39250E+04, 3.4624219074E+04, 5.0550201839E+03, 1.9762495262E+04, 3.6061303343E+03, 9.7796052330E-01],
	[4.39300E+04, 3.4631177919E+04, 5.0550549867E+03, 1.9769822736E+04, 3.6064674360E+03, 9.7796931740E-01],
	[4.39350E+04, 3.4638137371E+04, 5.0550897858E+03, 1.9777152090E+04, 3.6068044565E+03, 9.7797810731E-01],
	[4.39400E+04, 3.4645097430E+04, 5.0551245812E+03, 1.9784483325E+04, 3.6071413959E+03, 9.7798689303E-01],
	[4.39450E+04, 3.4652058095E+04, 5.0551593728E+03, 1.9791816441E+04, 3.6074782543E+03, 9.7799567456E-01],
	[4.39500E+04, 3.4659019366E+04, 5.0551941608E+03, 1.9799151438E+04, 3.6078150316E+03, 9.7800445192E-01],
	[4.39550E+04, 3.4665981243E+04, 5.0552289450E+03, 1.9806488317E+04, 3.6081517278E+03, 9.7801322509E-01],
	[4.39600E+04, 3.4672943727E+04, 5.0552637255E+03, 1.9813827078E+04, 3.6084883431E+03, 9.7802199409E-01],
	[4.39650E+04, 3.4679906817E+04, 5.0552985022E+03, 1.9821167721E+04, 3.6088248773E+03, 9.7803075891E-01],
	[4.39700E+04, 3.4686870513E+04, 5.0553332753E+03, 1.9828510247E+04, 3.6091613306E+03, 9.7803951956E-01],
	[4.39750E+04, 3.4693834816E+04, 5.0553680446E+03, 1.9835854655E+04, 3.6094977029E+03, 9.7804827604E-01],
	[4.39800E+04, 3.4700799725E+04, 5.0554028103E+03, 1.9843200947E+04, 3.6098339942E+03, 9.7805702835E-01],
	[4.39850E+04, 3.4707765240E+04, 5.0554375722E+03, 1.9850549121E+04, 3.6101702046E+03, 9.7806577649E-01],
	[4.39900E+04, 3.4714731361E+04, 5.0554723304E+03, 1.9857899180E+04, 3.6105063342E+03, 9.7807452047E-01],
	[4.39950E+04, 3.4721698088E+04, 5.0555070849E+03, 1.9865251122E+04, 3.6108423828E+03, 9.7808326029E-01],
	[4.40000E+04, 3.4728665422E+04, 5.0555418357E+03, 1.9872604948E+04, 3.6111783505E+03, 9.7809199594E-01],
	[4.40050E+04, 3.4735633361E+04, 5.0555765828E+03, 1.9879960658E+04, 3.6115142374E+03, 9.7810072744E-01],
	[4.40100E+04, 3.4742601907E+04, 5.0556113261E+03, 1.9887318253E+04, 3.6118500435E+03, 9.7810945479E-01],
	[4.40150E+04, 3.4749571059E+04, 5.0556460658E+03, 1.9894677733E+04, 3.6121857687E+03, 9.7811817798E-01],
	[4.40200E+04, 3.4756540817E+04, 5.0556808017E+03, 1.9902039098E+04, 3.6125214132E+03, 9.7812689702E-01],
	[4.40250E+04, 3.4763511181E+04, 5.0557155340E+03, 1.9909402348E+04, 3.6128569768E+03, 9.7813561192E-01],
	[4.40300E+04, 3.4770482151E+04, 5.0557502625E+03, 1.9916767485E+04, 3.6131924597E+03, 9.7814432266E-01],
	[4.40350E+04, 3.4777453727E+04, 5.0557849873E+03, 1.9924134507E+04, 3.6135278619E+03, 9.7815302927E-01],
	[4.40400E+04, 3.4784425909E+04, 5.0558197085E+03, 1.9931503415E+04, 3.6138631833E+03, 9.7816173173E-01],
	[4.40450E+04, 3.4791398698E+04, 5.0558544259E+03, 1.9938874210E+04, 3.6141984240E+03, 9.7817043005E-01],
	[4.40500E+04, 3.4798372092E+04, 5.0558891396E+03, 1.9946246891E+04, 3.6145335840E+03, 9.7817912424E-01],
	[4.40550E+04, 3.4805346092E+04, 5.0559238496E+03, 1.9953621460E+04, 3.6148686634E+03, 9.7818781429E-01],
	[4.40600E+04, 3.4812320698E+04, 5.0559585560E+03, 1.9960997916E+04, 3.6152036621E+03, 9.7819650021E-01],
	[4.40650E+04, 3.4819295910E+04, 5.0559932586E+03, 1.9968376259E+04, 3.6155385802E+03, 9.7820518200E-01],
	[4.40700E+04, 3.4826271728E+04, 5.0560279575E+03, 1.9975756491E+04, 3.6158734176E+03, 9.7821385966E-01],
	[4.40750E+04, 3.4833248152E+04, 5.0560626527E+03, 1.9983138610E+04, 3.6162081745E+03, 9.7822253320E-01],
	[4.40800E+04, 3.4840225182E+04, 5.0560973442E+03, 1.9990522618E+04, 3.6165428507E+03, 9.7823120261E-01],
	[4.40850E+04, 3.4847202818E+04, 5.0561320321E+03, 1.9997908514E+04, 3.6168774464E+03, 9.7823986790E-01],
	[4.40900E+04, 3.4854181060E+04, 5.0561667162E+03, 2.0005296299E+04, 3.6172119616E+03, 9.7824852907E-01],
	[4.40950E+04, 3.4861159907E+04, 5.0562013966E+03, 2.0012685974E+04, 3.6175463963E+03, 9.7825718613E-01],
	[4.41000E+04, 3.4868139360E+04, 5.0562360734E+03, 2.0020077538E+04, 3.6178807504E+03, 9.7826583907E-01],
	[4.41050E+04, 3.4875119420E+04, 5.0562707464E+03, 2.0027470991E+04, 3.6182150241E+03, 9.7827448790E-01],
	[4.41100E+04, 3.4882100085E+04, 5.0563054158E+03, 2.0034866335E+04, 3.6185492172E+03, 9.7828313262E-01],
	[4.41150E+04, 3.4889081355E+04, 5.0563400814E+03, 2.0042263568E+04, 3.6188833300E+03, 9.7829177323E-01],
	[4.41200E+04, 3.4896063232E+04, 5.0563747434E+03, 2.0049662693E+04, 3.6192173623E+03, 9.7830040973E-01],
	[4.41250E+04, 3.4903045714E+04, 5.0564094017E+03, 2.0057063708E+04, 3.6195513142E+03, 9.7830904213E-01],
	[4.41300E+04, 3.4910028802E+04, 5.0564440563E+03, 2.0064466614E+04, 3.6198851856E+03, 9.7831767043E-01],
	[4.41350E+04, 3.4917012496E+04, 5.0564787072E+03, 2.0071871411E+04, 3.6202189767E+03, 9.7832629464E-01],
	[4.41400E+04, 3.4923996795E+04, 5.0565133544E+03, 2.0079278100E+04, 3.6205526875E+03, 9.7833491474E-01],
	[4.41450E+04, 3.4930981700E+04, 5.0565479979E+03, 2.0086686681E+04, 3.6208863179E+03, 9.7834353075E-01],
	[4.41500E+04, 3.4937967211E+04, 5.0565826378E+03, 2.0094097154E+04, 3.6212198680E+03, 9.7835214267E-01],
	[4.41550E+04, 3.4944953328E+04, 5.0566172739E+03, 2.0101509519E+04, 3.6215533378E+03, 9.7836075050E-01],
	[4.41600E+04, 3.4951940050E+04, 5.0566519064E+03, 2.0108923777E+04, 3.6218867273E+03, 9.7836935424E-01],
	[4.41650E+04, 3.4958927378E+04, 5.0566865352E+03, 2.0116339928E+04, 3.6222200365E+03, 9.7837795390E-01],
	[4.41700E+04, 3.4965915311E+04, 5.0567211603E+03, 2.0123757973E+04, 3.6225532655E+03, 9.7838654947E-01],
	[4.41750E+04, 3.4972903850E+04, 5.0567557817E+03, 2.0131177910E+04, 3.6228864142E+03, 9.7839514096E-01],
	[4.41800E+04, 3.4979892995E+04, 5.0567903995E+03, 2.0138599741E+04, 3.6232194828E+03, 9.7840372838E-01],
	[4.41850E+04, 3.4986882745E+04, 5.0568250135E+03, 2.0146023467E+04, 3.6235524711E+03, 9.7841231171E-01],
	[4.41900E+04, 3.4993873100E+04, 5.0568596239E+03, 2.0153449086E+04, 3.6238853793E+03, 9.7842089098E-01],
	[4.41950E+04, 3.5000864062E+04, 5.0568942306E+03, 2.0160876600E+04, 3.6242182073E+03, 9.7842946617E-01],
	[4.42000E+04, 3.5007855628E+04, 5.0569288336E+03, 2.0168306009E+04, 3.6245509551E+03, 9.7843803729E-01],
	[4.42050E+04, 3.5014847800E+04, 5.0569634330E+03, 2.0175737313E+04, 3.6248836229E+03, 9.7844660434E-01],
	[4.42100E+04, 3.5021840578E+04, 5.0569980286E+03, 2.0183170512E+04, 3.6252162105E+03, 9.7845516733E-01],
	[4.42150E+04, 3.5028833961E+04, 5.0570326206E+03, 2.0190605607E+04, 3.6255487181E+03, 9.7846372626E-01],
	[4.42200E+04, 3.5035827950E+04, 5.0570672089E+03, 2.0198042598E+04, 3.6258811456E+03, 9.7847228112E-01],
	[4.42250E+04, 3.5042822544E+04, 5.0571017936E+03, 2.0205481485E+04, 3.6262134930E+03, 9.7848083192E-01],
	[4.42300E+04, 3.5049817744E+04, 5.0571363746E+03, 2.0212922268E+04, 3.6265457604E+03, 9.7848937867E-01],
	[4.42350E+04, 3.5056813548E+04, 5.0571709519E+03, 2.0220364948E+04, 3.6268779478E+03, 9.7849792137E-01],
	[4.42400E+04, 3.5063809959E+04, 5.0572055255E+03, 2.0227809525E+04, 3.6272100552E+03, 9.7850646001E-01],
	[4.42450E+04, 3.5070806974E+04, 5.0572400954E+03, 2.0235255999E+04, 3.6275420827E+03, 9.7851499460E-01],
	[4.42500E+04, 3.5077804595E+04, 5.0572746617E+03, 2.0242704371E+04, 3.6278740302E+03, 9.7852352515E-01],
	[4.42550E+04, 3.5084802822E+04, 5.0573092243E+03, 2.0250154640E+04, 3.6282058977E+03, 9.7853205165E-01],
	[4.42600E+04, 3.5091801653E+04, 5.0573437833E+03, 2.0257606808E+04, 3.6285376853E+03, 9.7854057410E-01],
	[4.42650E+04, 3.5098801090E+04, 5.0573783386E+03, 2.0265060873E+04, 3.6288693931E+03, 9.7854909252E-01],
	[4.42700E+04, 3.5105801133E+04, 5.0574128902E+03, 2.0272516837E+04, 3.6292010209E+03, 9.7855760690E-01],
	[4.42750E+04, 3.5112801780E+04, 5.0574474381E+03, 2.0279974700E+04, 3.6295325689E+03, 9.7856611724E-01],
	[4.42800E+04, 3.5119803033E+04, 5.0574819824E+03, 2.0287434463E+04, 3.6298640370E+03, 9.7857462354E-01],
	[4.42850E+04, 3.5126804891E+04, 5.0575165230E+03, 2.0294896124E+04, 3.6301954253E+03, 9.7858312582E-01],
	[4.42900E+04, 3.5133807354E+04, 5.0575510600E+03, 2.0302359685E+04, 3.6305267338E+03, 9.7859162406E-01],
	[4.42950E+04, 3.5140810423E+04, 5.0575855933E+03, 2.0309825146E+04, 3.6308579625E+03, 9.7860011828E-01],
	[4.43000E+04, 3.5147814096E+04, 5.0576201229E+03, 2.0317292507E+04, 3.6311891114E+03, 9.7860860847E-01],
	[4.43050E+04, 3.5154818375E+04, 5.0576546489E+03, 2.0324761769E+04, 3.6315201806E+03, 9.7861709463E-01],
	[4.43100E+04, 3.5161823259E+04, 5.0576891712E+03, 2.0332232931E+04, 3.6318511700E+03, 9.7862557678E-01],
	[4.43150E+04, 3.5168828748E+04, 5.0577236898E+03, 2.0339705995E+04, 3.6321820798E+03, 9.7863405491E-01],
	[4.43200E+04, 3.5175834843E+04, 5.0577582048E+03, 2.0347180959E+04, 3.6325129098E+03, 9.7864252902E-01],
	[4.43250E+04, 3.5182841542E+04, 5.0577927161E+03, 2.0354657825E+04, 3.6328436601E+03, 9.7865099911E-01],
	[4.43300E+04, 3.5189848847E+04, 5.0578272238E+03, 2.0362136593E+04, 3.6331743308E+03, 9.7865946520E-01],
	[4.43350E+04, 3.5196856756E+04, 5.0578617278E+03, 2.0369617263E+04, 3.6335049218E+03, 9.7866792727E-01],
	[4.43400E+04, 3.5203865271E+04, 5.0578962282E+03, 2.0377099835E+04, 3.6338354333E+03, 9.7867638534E-01],
	[4.43450E+04, 3.5210874391E+04, 5.0579307249E+03, 2.0384584310E+04, 3.6341658651E+03, 9.7868483940E-01],
	[4.43500E+04, 3.5217884116E+04, 5.0579652179E+03, 2.0392070687E+04, 3.6344962173E+03, 9.7869328946E-01],
	[4.43550E+04, 3.5224894445E+04, 5.0579997073E+03, 2.0399558968E+04, 3.6348264899E+03, 9.7870173551E-01],
	[4.43600E+04, 3.5231905380E+04, 5.0580341931E+03, 2.0407049152E+04, 3.6351566830E+03, 9.7871017757E-01],
	[4.43650E+04, 3.5238916920E+04, 5.0580686752E+03, 2.0414541240E+04, 3.6354867966E+03, 9.7871861563E-01],
	[4.43700E+04, 3.5245929065E+04, 5.0581031536E+03, 2.0422035232E+04, 3.6358168306E+03, 9.7872704969E-01],
	[4.43750E+04, 3.5252941814E+04, 5.0581376284E+03, 2.0429531127E+04, 3.6361467852E+03, 9.7873547976E-01],
	[4.43800E+04, 3.5259955169E+04, 5.0581720995E+03, 2.0437028928E+04, 3.6364766602E+03, 9.7874390584E-01],
	[4.43850E+04, 3.5266969129E+04, 5.0582065670E+03, 2.0444528633E+04, 3.6368064558E+03, 9.7875232794E-01],
	[4.43900E+04, 3.5273983693E+04, 5.0582410309E+03, 2.0452030243E+04, 3.6371361720E+03, 9.7876074605E-01],
	[4.43950E+04, 3.5280998862E+04, 5.0582754911E+03, 2.0459533758E+04, 3.6374658087E+03, 9.7876916017E-01],
	[4.44000E+04, 3.5288014637E+04, 5.0583099476E+03, 2.0467039179E+04, 3.6377953661E+03, 9.7877757031E-01],
	[4.44050E+04, 3.5295031016E+04, 5.0583444005E+03, 2.0474546506E+04, 3.6381248440E+03, 9.7878597647E-01],
	[4.44100E+04, 3.5302048000E+04, 5.0583788498E+03, 2.0482055738E+04, 3.6384542426E+03, 9.7879437866E-01],
	[4.44150E+04, 3.5309065588E+04, 5.0584132954E+03, 2.0489566877E+04, 3.6387835618E+03, 9.7880277687E-01],
	[4.44200E+04, 3.5316083782E+04, 5.0584477374E+03, 2.0497079923E+04, 3.6391128017E+03, 9.7881117111E-01],
	[4.44250E+04, 3.5323102580E+04, 5.0584821757E+03, 2.0504594876E+04, 3.6394419623E+03, 9.7881956138E-01],
	[4.44300E+04, 3.5330121984E+04, 5.0585166104E+03, 2.0512111735E+04, 3.6397710436E+03, 9.7882794767E-01],
	[4.44350E+04, 3.5337141992E+04, 5.0585510415E+03, 2.0519630502E+04, 3.6401000456E+03, 9.7883633001E-01],
	[4.44400E+04, 3.5344162604E+04, 5.0585854689E+03, 2.0527151177E+04, 3.6404289683E+03, 9.7884470837E-01],
	[4.44450E+04, 3.5351183822E+04, 5.0586198927E+03, 2.0534673760E+04, 3.6407578118E+03, 9.7885308278E-01],
	[4.44500E+04, 3.5358205644E+04, 5.0586543128E+03, 2.0542198251E+04, 3.6410865761E+03, 9.7886145323E-01],
	[4.44550E+04, 3.5365228071E+04, 5.0586887293E+03, 2.0549724650E+04, 3.6414152612E+03, 9.7886981972E-01],
	[4.44600E+04, 3.5372251102E+04, 5.0587231422E+03, 2.0557252959E+04, 3.6417438671E+03, 9.7887818225E-01],
	[4.44650E+04, 3.5379274738E+04, 5.0587575514E+03, 2.0564783176E+04, 3.6420723938E+03, 9.7888654083E-01],
	[4.44700E+04, 3.5386298979E+04, 5.0587919570E+03, 2.0572315302E+04, 3.6424008414E+03, 9.7889489546E-01],
	[4.44750E+04, 3.5393323825E+04, 5.0588263589E+03, 2.0579849338E+04, 3.6427292099E+03, 9.7890324614E-01],
	[4.44800E+04, 3.5400349275E+04, 5.0588607573E+03, 2.0587385284E+04, 3.6430574992E+03, 9.7891159287E-01],
	[4.44850E+04, 3.5407375329E+04, 5.0588951520E+03, 2.0594923140E+04, 3.6433857095E+03, 9.7891993566E-01],
	[4.44900E+04, 3.5414401989E+04, 5.0589295430E+03, 2.0602462907E+04, 3.6437138406E+03, 9.7892827451E-01],
	[4.44950E+04, 3.5421429253E+04, 5.0589639304E+03, 2.0610004584E+04, 3.6440418927E+03, 9.7893660941E-01],
	[4.45000E+04, 3.5428457121E+04, 5.0589983142E+03, 2.0617548172E+04, 3.6443698658E+03, 9.7894494038E-01],
	[4.45050E+04, 3.5435485594E+04, 5.0590326944E+03, 2.0625093671E+04, 3.6446977599E+03, 9.7895326741E-01],
	[4.45100E+04, 3.5442514671E+04, 5.0590670709E+03, 2.0632641081E+04, 3.6450255749E+03, 9.7896159051E-01],
	[4.45150E+04, 3.5449544353E+04, 5.0591014439E+03, 2.0640190403E+04, 3.6453533110E+03, 9.7896990968E-01],
	[4.45200E+04, 3.5456574640E+04, 5.0591358131E+03, 2.0647741638E+04, 3.6456809681E+03, 9.7897822492E-01],
	[4.45250E+04, 3.5463605531E+04, 5.0591701788E+03, 2.0655294784E+04, 3.6460085463E+03, 9.7898653623E-01],
	[4.45300E+04, 3.5470637026E+04, 5.0592045408E+03, 2.0662849843E+04, 3.6463360455E+03, 9.7899484361E-01],
	[4.45350E+04, 3.5477669126E+04, 5.0592388992E+03, 2.0670406815E+04, 3.6466634658E+03, 9.7900314707E-01],
	[4.45400E+04, 3.5484701830E+04, 5.0592732540E+03, 2.0677965700E+04, 3.6469908072E+03, 9.7901144661E-01],
	[4.45450E+04, 3.5491735139E+04, 5.0593076052E+03, 2.0685526498E+04, 3.6473180698E+03, 9.7901974224E-01],
	[4.45500E+04, 3.5498769052E+04, 5.0593419527E+03, 2.0693089210E+04, 3.6476452535E+03, 9.7902803394E-01],
	[4.45550E+04, 3.5505803570E+04, 5.0593762966E+03, 2.0700653835E+04, 3.6479723584E+03, 9.7903632174E-01],
	[4.45600E+04, 3.5512838692E+04, 5.0594106369E+03, 2.0708220375E+04, 3.6482993844E+03, 9.7904460562E-01],
	[4.45650E+04, 3.5519874418E+04, 5.0594449736E+03, 2.0715788829E+04, 3.6486263317E+03, 9.7905288559E-01],
	[4.45700E+04, 3.5526910748E+04, 5.0594793067E+03, 2.0723359198E+04, 3.6489532001E+03, 9.7906116165E-01],
	[4.45750E+04, 3.5533947683E+04, 5.0595136361E+03, 2.0730931482E+04, 3.6492799898E+03, 9.7906943380E-01],
	[4.45800E+04, 3.5540985222E+04, 5.0595479619E+03, 2.0738505681E+04, 3.6496067008E+03, 9.7907770206E-01],
	[4.45850E+04, 3.5548023366E+04, 5.0595822841E+03, 2.0746081795E+04, 3.6499333330E+03, 9.7908596641E-01],
	[4.45900E+04, 3.5555062114E+04, 5.0596166027E+03, 2.0753659825E+04, 3.6502598865E+03, 9.7909422686E-01],
	[4.45950E+04, 3.5562101466E+04, 5.0596509177E+03, 2.0761239772E+04, 3.6505863614E+03, 9.7910248342E-01],
	[4.46000E+04, 3.5569141422E+04, 5.0596852290E+03, 2.0768821634E+04, 3.6509127575E+03, 9.7911073608E-01],
	[4.46050E+04, 3.5576181982E+04, 5.0597195368E+03, 2.0776405413E+04, 3.6512390750E+03, 9.7911898484E-01],
	[4.46100E+04, 3.5583223147E+04, 5.0597538409E+03, 2.0783991109E+04, 3.6515653139E+03, 9.7912722972E-01],
	[4.46150E+04, 3.5590264916E+04, 5.0597881414E+03, 2.0791578722E+04, 3.6518914741E+03, 9.7913547071E-01],
	[4.46200E+04, 3.5597307289E+04, 5.0598224383E+03, 2.0799168252E+04, 3.6522175558E+03, 9.7914370781E-01],
	[4.46250E+04, 3.5604350266E+04, 5.0598567316E+03, 2.0806759700E+04, 3.6525435589E+03, 9.7915194103E-01],
	[4.46300E+04, 3.5611393847E+04, 5.0598910213E+03, 2.0814353066E+04, 3.6528694834E+03, 9.7916017037E-01],
	[4.46350E+04, 3.5618438033E+04, 5.0599253074E+03, 2.0821948350E+04, 3.6531953294E+03, 9.7916839582E-01],
	[4.46400E+04, 3.5625482822E+04, 5.0599595899E+03, 2.0829545552E+04, 3.6535210968E+03, 9.7917661740E-01],
	[4.46450E+04, 3.5632528216E+04, 5.0599938687E+03, 2.0837144673E+04, 3.6538467857E+03, 9.7918483510E-01],
	[4.46500E+04, 3.5639574214E+04, 5.0600281440E+03, 2.0844745713E+04, 3.6541723962E+03, 9.7919304893E-01],
	[4.46550E+04, 3.5646620815E+04, 5.0600624157E+03, 2.0852348673E+04, 3.6544979282E+03, 9.7920125889E-01],
	[4.46600E+04, 3.5653668021E+04, 5.0600966837E+03, 2.0859953551E+04, 3.6548233817E+03, 9.7920946498E-01],
	[4.46650E+04, 3.5660715831E+04, 5.0601309481E+03, 2.0867560350E+04, 3.6551487568E+03, 9.7921766720E-01],
	[4.46700E+04, 3.5667764245E+04, 5.0601652090E+03, 2.0875169069E+04, 3.6554740535E+03, 9.7922586555E-01],
	[4.46750E+04, 3.5674813263E+04, 5.0601994662E+03, 2.0882779708E+04, 3.6557992718E+03, 9.7923406005E-01],
	[4.46800E+04, 3.5681862885E+04, 5.0602337198E+03, 2.0890392267E+04, 3.6561244117E+03, 9.7924225068E-01],
	[4.46850E+04, 3.5688913111E+04, 5.0602679699E+03, 2.0898006747E+04, 3.6564494732E+03, 9.7925043745E-01],
	[4.46900E+04, 3.5695963941E+04, 5.0603022163E+03, 2.0905623149E+04, 3.6567744565E+03, 9.7925862037E-01],
	[4.46950E+04, 3.5703015374E+04, 5.0603364591E+03, 2.0913241472E+04, 3.6570993613E+03, 9.7926679944E-01],
	[4.47000E+04, 3.5710067412E+04, 5.0603706984E+03, 2.0920861716E+04, 3.6574241879E+03, 9.7927497465E-01],
	[4.47050E+04, 3.5717120054E+04, 5.0604049340E+03, 2.0928483883E+04, 3.6577489362E+03, 9.7928314601E-01],
	[4.47100E+04, 3.5724173299E+04, 5.0604391660E+03, 2.0936107972E+04, 3.6580736062E+03, 9.7929131352E-01],
	[4.47150E+04, 3.5731227148E+04, 5.0604733945E+03, 2.0943733983E+04, 3.6583981980E+03, 9.7929947719E-01],
	[4.47200E+04, 3.5738281602E+04, 5.0605076193E+03, 2.0951361917E+04, 3.6587227116E+03, 9.7930763701E-01],
	[4.47250E+04, 3.5745336659E+04, 5.0605418406E+03, 2.0958991773E+04, 3.6590471469E+03, 9.7931579299E-01],
	[4.47300E+04, 3.5752392319E+04, 5.0605760582E+03, 2.0966623554E+04, 3.6593715040E+03, 9.7932394514E-01],
	[4.47350E+04, 3.5759448584E+04, 5.0606102723E+03, 2.0974257257E+04, 3.6596957830E+03, 9.7933209344E-01],
	[4.47400E+04, 3.5766505453E+04, 5.0606444828E+03, 2.0981892885E+04, 3.6600199838E+03, 9.7934023791E-01],
	[4.47450E+04, 3.5773562925E+04, 5.0606786896E+03, 2.0989530436E+04, 3.6603441065E+03, 9.7934837855E-01],
	[4.47500E+04, 3.5780621001E+04, 5.0607128929E+03, 2.0997169912E+04, 3.6606681510E+03, 9.7935651536E-01],
	[4.47550E+04, 3.5787679681E+04, 5.0607470926E+03, 2.1004811313E+04, 3.6609921175E+03, 9.7936464833E-01],
	[4.47600E+04, 3.5794738964E+04, 5.0607812887E+03, 2.1012454638E+04, 3.6613160058E+03, 9.7937277748E-01],
	[4.47650E+04, 3.5801798851E+04, 5.0608154813E+03, 2.1020099889E+04, 3.6616398161E+03, 9.7938090281E-01],
	[4.47700E+04, 3.5808859342E+04, 5.0608496702E+03, 2.1027747065E+04, 3.6619635483E+03, 9.7938902431E-01],
	[4.47750E+04, 3.5815920437E+04, 5.0608838555E+03, 2.1035396167E+04, 3.6622872026E+03, 9.7939714200E-01],
	[4.47800E+04, 3.5822982135E+04, 5.0609180373E+03, 2.1043047194E+04, 3.6626107788E+03, 9.7940525586E-01],
	[4.47850E+04, 3.5830044437E+04, 5.0609522155E+03, 2.1050700148E+04, 3.6629342770E+03, 9.7941336591E-01],
	[4.47900E+04, 3.5837107343E+04, 5.0609863900E+03, 2.1058355029E+04, 3.6632576972E+03, 9.7942147214E-01],
	[4.47950E+04, 3.5844170852E+04, 5.0610205610E+03, 2.1066011836E+04, 3.6635810395E+03, 9.7942957457E-01],
	[4.48000E+04, 3.5851234965E+04, 5.0610547285E+03, 2.1073670570E+04, 3.6639043038E+03, 9.7943767318E-01],
	[4.48050E+04, 3.5858299681E+04, 5.0610888923E+03, 2.1081331231E+04, 3.6642274902E+03, 9.7944576798E-01],
	[4.48100E+04, 3.5865365001E+04, 5.0611230526E+03, 2.1088993821E+04, 3.6645505988E+03, 9.7945385898E-01],
	[4.48150E+04, 3.5872430924E+04, 5.0611572092E+03, 2.1096658337E+04, 3.6648736294E+03, 9.7946194618E-01],
	[4.48200E+04, 3.5879497452E+04, 5.0611913623E+03, 2.1104324783E+04, 3.6651965822E+03, 9.7947002957E-01],
	[4.48250E+04, 3.5886564582E+04, 5.0612255118E+03, 2.1111993156E+04, 3.6655194571E+03, 9.7947810917E-01],
	[4.48300E+04, 3.5893632316E+04, 5.0612596578E+03, 2.1119663458E+04, 3.6658422542E+03, 9.7948618497E-01],
	[4.48350E+04, 3.5900700654E+04, 5.0612938001E+03, 2.1127335689E+04, 3.6661649735E+03, 9.7949425697E-01],
	[4.48400E+04, 3.5907769595E+04, 5.0613279389E+03, 2.1135009849E+04, 3.6664876150E+03, 9.7950232518E-01],
	[4.48450E+04, 3.5914839139E+04, 5.0613620741E+03, 2.1142685939E+04, 3.6668101787E+03, 9.7951038960E-01],
	[4.48500E+04, 3.5921909287E+04, 5.0613962058E+03, 2.1150363958E+04, 3.6671326647E+03, 9.7951845023E-01],
	[4.48550E+04, 3.5928980039E+04, 5.0614303338E+03, 2.1158043908E+04, 3.6674550729E+03, 9.7952650707E-01],
	[4.48600E+04, 3.5936051394E+04, 5.0614644583E+03, 2.1165725788E+04, 3.6677774034E+03, 9.7953456013E-01],
	[4.48650E+04, 3.5943123352E+04, 5.0614985792E+03, 2.1173409598E+04, 3.6680996563E+03, 9.7954260941E-01],
	[4.48700E+04, 3.5950195913E+04, 5.0615326965E+03, 2.1181095339E+04, 3.6684218314E+03, 9.7955065490E-01],
	[4.48750E+04, 3.5957269078E+04, 5.0615668103E+03, 2.1188783011E+04, 3.6687439289E+03, 9.7955869662E-01],
	[4.48800E+04, 3.5964342847E+04, 5.0616009205E+03, 2.1196472614E+04, 3.6690659487E+03, 9.7956673456E-01],
	[4.48850E+04, 3.5971417218E+04, 5.0616350271E+03, 2.1204164149E+04, 3.6693878909E+03, 9.7957476873E-01],
	[4.48900E+04, 3.5978492193E+04, 5.0616691302E+03, 2.1211857616E+04, 3.6697097555E+03, 9.7958279912E-01],
	[4.48950E+04, 3.5985567772E+04, 5.0617032296E+03, 2.1219553016E+04, 3.6700315425E+03, 9.7959082575E-01],
	[4.49000E+04, 3.5992643953E+04, 5.0617373256E+03, 2.1227250347E+04, 3.6703532519E+03, 9.7959884861E-01],
	[4.49050E+04, 3.5999720738E+04, 5.0617714179E+03, 2.1234949611E+04, 3.6706748838E+03, 9.7960686770E-01],
	[4.49100E+04, 3.6006798126E+04, 5.0618055067E+03, 2.1242650808E+04, 3.6709964382E+03, 9.7961488303E-01],
	[4.49150E+04, 3.6013876117E+04, 5.0618395919E+03, 2.1250353939E+04, 3.6713179150E+03, 9.7962289459E-01],
	[4.49200E+04, 3.6020954712E+04, 5.0618736736E+03, 2.1258059003E+04, 3.6716393143E+03, 9.7963090240E-01],
	[4.49250E+04, 3.6028033910E+04, 5.0619077517E+03, 2.1265766000E+04, 3.6719606362E+03, 9.7963890645E-01],
	[4.49300E+04, 3.6035113711E+04, 5.0619418262E+03, 2.1273474932E+04, 3.6722818806E+03, 9.7964690674E-01],
	[4.49350E+04, 3.6042194115E+04, 5.0619758971E+03, 2.1281185798E+04, 3.6726030475E+03, 9.7965490328E-01],
	[4.49400E+04, 3.6049275122E+04, 5.0620099646E+03, 2.1288898599E+04, 3.6729241371E+03, 9.7966289607E-01],
	[4.49450E+04, 3.6056356733E+04, 5.0620440284E+03, 2.1296613334E+04, 3.6732451492E+03, 9.7967088511E-01],
	[4.49500E+04, 3.6063438946E+04, 5.0620780887E+03, 2.1304330005E+04, 3.6735660839E+03, 9.7967887040E-01],
	[4.49550E+04, 3.6070521763E+04, 5.0621121454E+03, 2.1312048611E+04, 3.6738869413E+03, 9.7968685195E-01],
	[4.49600E+04, 3.6077605183E+04, 5.0621461986E+03, 2.1319769153E+04, 3.6742077213E+03, 9.7969482976E-01],
	[4.49650E+04, 3.6084689206E+04, 5.0621802482E+03, 2.1327491630E+04, 3.6745284240E+03, 9.7970280382E-01],
	[4.49700E+04, 3.6091773832E+04, 5.0622142942E+03, 2.1335216044E+04, 3.6748490493E+03, 9.7971077415E-01],
	[4.49750E+04, 3.6098859061E+04, 5.0622483367E+03, 2.1342942394E+04, 3.6751695974E+03, 9.7971874074E-01],
	[4.49800E+04, 3.6105944893E+04, 5.0622823756E+03, 2.1350670681E+04, 3.6754900682E+03, 9.7972670359E-01],
	[4.49850E+04, 3.6113031328E+04, 5.0623164110E+03, 2.1358400905E+04, 3.6758104617E+03, 9.7973466271E-01],
	[4.49900E+04, 3.6120118366E+04, 5.0623504429E+03, 2.1366133066E+04, 3.6761307780E+03, 9.7974261810E-01],
	[4.49950E+04, 3.6127206007E+04, 5.0623844711E+03, 2.1373867165E+04, 3.6764510171E+03, 9.7975056977E-01],
	[4.50000E+04, 3.6134294251E+04, 5.0624184958E+03, 2.1381603201E+04, 3.6767711789E+03, 9.7975851770E-01],
	[4.50050E+04, 3.6141383098E+04, 5.0624525170E+03, 2.1389360761E+04, 3.6770918424E+03, 9.7976646192E-01],
	[4.50100E+04, 3.6148472548E+04, 5.0624865346E+03, 2.1397120270E+04, 3.6774124284E+03, 9.7977440241E-01],
	[4.50150E+04, 3.6155562601E+04, 5.0625205487E+03, 2.1404881732E+04, 3.6777329371E+03, 9.7978233918E-01],
	[4.50200E+04, 3.6162653257E+04, 5.0625545592E+03, 2.1412645144E+04, 3.6780533683E+03, 9.7979027223E-01],
	[4.50250E+04, 3.6169744516E+04, 5.0625885662E+03, 2.1420410508E+04, 3.6783737221E+03, 9.7979820156E-01],
	[4.50300E+04, 3.6176836378E+04, 5.0626225696E+03, 2.1428177824E+04, 3.6786939986E+03, 9.7980612719E-01],
	[4.50350E+04, 3.6183928842E+04, 5.0626565695E+03, 2.1435947092E+04, 3.6790141977E+03, 9.7981404910E-01],
	[4.50400E+04, 3.6191021909E+04, 5.0626905658E+03, 2.1443718313E+04, 3.6793343195E+03, 9.7982196730E-01],
	[4.50450E+04, 3.6198115579E+04, 5.0627245586E+03, 2.1451491486E+04, 3.6796543640E+03, 9.7982988179E-01],
	[4.50500E+04, 3.6205209852E+04, 5.0627585479E+03, 2.1459266613E+04, 3.6799743312E+03, 9.7983779258E-01],
	[4.50550E+04, 3.6212304728E+04, 5.0627925336E+03, 2.1467043692E+04, 3.6802942212E+03, 9.7984569966E-01],
	[4.50600E+04, 3.6219400207E+04, 5.0628265157E+03, 2.1474822726E+04, 3.6806140338E+03, 9.7985360304E-01],
	[4.50650E+04, 3.6226496288E+04, 5.0628604943E+03, 2.1482603713E+04, 3.6809337693E+03, 9.7986150272E-01],
	[4.50700E+04, 3.6233592972E+04, 5.0628944694E+03, 2.1490386654E+04, 3.6812534275E+03, 9.7986939871E-01],
	[4.50750E+04, 3.6240690259E+04, 5.0629284409E+03, 2.1498171550E+04, 3.6815730086E+03, 9.7987729100E-01],
	[4.50800E+04, 3.6247788149E+04, 5.0629624089E+03, 2.1505958400E+04, 3.6818925124E+03, 9.7988517959E-01],
	[4.50850E+04, 3.6254886641E+04, 5.0629963733E+03, 2.1513747205E+04, 3.6822119391E+03, 9.7989306450E-01],
	[4.50900E+04, 3.6261985736E+04, 5.0630303343E+03, 2.1521537965E+04, 3.6825312887E+03, 9.7990094571E-01],
	[4.50950E+04, 3.6269085433E+04, 5.0630642916E+03, 2.1529330681E+04, 3.6828505611E+03, 9.7990882324E-01],
	[4.51000E+04, 3.6276185734E+04, 5.0630982455E+03, 2.1537125353E+04, 3.6831697564E+03, 9.7991669708E-01],
	[4.51050E+04, 3.6283286637E+04, 5.0631321958E+03, 2.1544921980E+04, 3.6834888747E+03, 9.7992456724E-01],
	[4.51100E+04, 3.6290388142E+04, 5.0631661425E+03, 2.1552720564E+04, 3.6838079158E+03, 9.7993243371E-01],
	[4.51150E+04, 3.6297490250E+04, 5.0632000858E+03, 2.1560521105E+04, 3.6841268800E+03, 9.7994029651E-01],
	[4.51200E+04, 3.6304592961E+04, 5.0632340254E+03, 2.1568323602E+04, 3.6844457670E+03, 9.7994815563E-01],
	[4.51250E+04, 3.6311696274E+04, 5.0632679616E+03, 2.1576128056E+04, 3.6847645771E+03, 9.7995601107E-01],
	[4.51300E+04, 3.6318800190E+04, 5.0633018942E+03, 2.1583934468E+04, 3.6850833102E+03, 9.7996386283E-01],
	[4.51350E+04, 3.6325904709E+04, 5.0633358233E+03, 2.1591742838E+04, 3.6854019663E+03, 9.7997171093E-01],
	[4.51400E+04, 3.6333009830E+04, 5.0633697489E+03, 2.1599553165E+04, 3.6857205454E+03, 9.7997955535E-01],
	[4.51450E+04, 3.6340146577E+04, 5.0634079440E+03, 2.1607365451E+04, 3.6860416313E+03, 9.7998739610E-01],
	[4.51500E+04, 3.6347287480E+04, 5.0634466233E+03, 2.1615179695E+04, 3.6863629360E+03, 9.7999523319E-01],
	[4.51550E+04, 3.6354428996E+04, 5.0634852987E+03, 2.1622995897E+04, 3.6866841643E+03, 9.8000306661E-01],
	[4.51600E+04, 3.6361571124E+04, 5.0635239701E+03, 2.1630814059E+04, 3.6870053161E+03, 9.8001089637E-01],
	[4.51650E+04, 3.6368713864E+04, 5.0635626375E+03, 2.1638634181E+04, 3.6873263917E+03, 9.8001872246E-01],
	[4.51700E+04, 3.6375857216E+04, 5.0636013009E+03, 2.1646456261E+04, 3.6876473908E+03, 9.8002654490E-01],
	[4.51750E+04, 3.6383001180E+04, 5.0636399604E+03, 2.1654280302E+04, 3.6879683137E+03, 9.8003436368E-01],
	[4.51800E+04, 3.6390145757E+04, 5.0636786158E+03, 2.1662106303E+04, 3.6882891602E+03, 9.8004217880E-01],
	[4.51850E+04, 3.6397290945E+04, 5.0637172673E+03, 2.1669934264E+04, 3.6886099305E+03, 9.8004999027E-01],
	[4.51900E+04, 3.6404436746E+04, 5.0637559148E+03, 2.1677764185E+04, 3.6889306244E+03, 9.8005779809E-01],
	[4.51950E+04, 3.6411583159E+04, 5.0637945583E+03, 2.1685596068E+04, 3.6892512421E+03, 9.8006560226E-01],
	[4.52000E+04, 3.6418730183E+04, 5.0638331978E+03, 2.1693429912E+04, 3.6895717836E+03, 9.8007340278E-01],
	[4.52050E+04, 3.6425877820E+04, 5.0638718333E+03, 2.1701265717E+04, 3.6898922489E+03, 9.8008119965E-01],
	[4.52100E+04, 3.6433026069E+04, 5.0639104649E+03, 2.1709103485E+04, 3.6902126380E+03, 9.8008899288E-01],
	[4.52150E+04, 3.6440174930E+04, 5.0639490925E+03, 2.1716943214E+04, 3.6905329508E+03, 9.8009678246E-01],
	[4.52200E+04, 3.6447324403E+04, 5.0639877161E+03, 2.1724784905E+04, 3.6908531876E+03, 9.8010456841E-01],
	[4.52250E+04, 3.6454474488E+04, 5.0640263357E+03, 2.1732628559E+04, 3.6911733481E+03, 9.8011235072E-01],
	[4.52300E+04, 3.6461625185E+04, 5.0640649514E+03, 2.1740474176E+04, 3.6914934326E+03, 9.8012012939E-01],
	[4.52350E+04, 3.6468776494E+04, 5.0641035631E+03, 2.1748321756E+04, 3.6918134409E+03, 9.8012790442E-01],
	[4.52400E+04, 3.6475928415E+04, 5.0641421708E+03, 2.1756171300E+04, 3.6921333732E+03, 9.8013567582E-01],
	[4.52450E+04, 3.6483080948E+04, 5.0641807746E+03, 2.1764022807E+04, 3.6924532293E+03, 9.8014344359E-01],
	[4.52500E+04, 3.6490234093E+04, 5.0642193743E+03, 2.1771876278E+04, 3.6927730094E+03, 9.8015120773E-01],
	[4.52550E+04, 3.6497387849E+04, 5.0642579701E+03, 2.1779731714E+04, 3.6930927135E+03, 9.8015896824E-01],
	[4.52600E+04, 3.6504542218E+04, 5.0642965620E+03, 2.1787589113E+04, 3.6934123416E+03, 9.8016672513E-01],
	[4.52650E+04, 3.6511697198E+04, 5.0643351498E+03, 2.1795448478E+04, 3.6937318936E+03, 9.8017447839E-01],
	[4.52700E+04, 3.6518852791E+04, 5.0643737337E+03, 2.1803309808E+04, 3.6940513697E+03, 9.8018222804E-01],
	[4.52750E+04, 3.6526008995E+04, 5.0644123136E+03, 2.1811173103E+04, 3.6943707698E+03, 9.8018997406E-01],
	[4.52800E+04, 3.6533165811E+04, 5.0644508896E+03, 2.1819038363E+04, 3.6946900940E+03, 9.8019771646E-01],
	[4.52850E+04, 3.6540323239E+04, 5.0644894616E+03, 2.1826905590E+04, 3.6950093422E+03, 9.8020545525E-01],
	[4.52900E+04, 3.6547481278E+04, 5.0645280296E+03, 2.1834774782E+04, 3.6953285145E+03, 9.8021319042E-01],
	[4.52950E+04, 3.6554639930E+04, 5.0645665937E+03, 2.1842645941E+04, 3.6956476109E+03, 9.8022092198E-01],
	[4.53000E+04, 3.6561799193E+04, 5.0646051538E+03, 2.1850519067E+04, 3.6959666315E+03, 9.8022864993E-01],
	[4.53050E+04, 3.6568959068E+04, 5.0646437099E+03, 2.1858394160E+04, 3.6962855762E+03, 9.8023637427E-01],
	[4.53100E+04, 3.6576119554E+04, 5.0646822621E+03, 2.1866271220E+04, 3.6966044450E+03, 9.8024409500E-01],
	[4.53150E+04, 3.6583280653E+04, 5.0647208103E+03, 2.1874150247E+04, 3.6969232380E+03, 9.8025181213E-01],
	[4.53200E+04, 3.6590442363E+04, 5.0647593546E+03, 2.1882031242E+04, 3.6972419553E+03, 9.8025952566E-01],
	[4.53250E+04, 3.6597604684E+04, 5.0647978949E+03, 2.1889914205E+04, 3.6975605967E+03, 9.8026723558E-01],
	[4.53300E+04, 3.6604767618E+04, 5.0648364312E+03, 2.1897799137E+04, 3.6978791624E+03, 9.8027494190E-01],
	[4.53350E+04, 3.6611931163E+04, 5.0648749636E+03, 2.1905686037E+04, 3.6981976523E+03, 9.8028264463E-01],
	[4.53400E+04, 3.6619095320E+04, 5.0649134920E+03, 2.1913574906E+04, 3.6985160665E+03, 9.8029034376E-01],
	[4.53450E+04, 3.6626260088E+04, 5.0649520165E+03, 2.1921465744E+04, 3.6988344050E+03, 9.8029803930E-01],
	[4.53500E+04, 3.6633425468E+04, 5.0649905370E+03, 2.1929358552E+04, 3.6991526677E+03, 9.8030573124E-01],
	[4.53550E+04, 3.6640591460E+04, 5.0650290536E+03, 2.1937253329E+04, 3.6994708549E+03, 9.8031341960E-01],
	[4.53600E+04, 3.6647758063E+04, 5.0650675662E+03, 2.1945150077E+04, 3.6997889663E+03, 9.8032110436E-01],
	[4.53650E+04, 3.6654925278E+04, 5.0651060748E+03, 2.1953048794E+04, 3.7001070021E+03, 9.8032878554E-01],
	[4.53700E+04, 3.6662093104E+04, 5.0651445795E+03, 2.1960949482E+04, 3.7004249623E+03, 9.8033646314E-01],
	[4.53750E+04, 3.6669261542E+04, 5.0651830803E+03, 2.1968852141E+04, 3.7007428469E+03, 9.8034413715E-01],
	[4.53800E+04, 3.6676430591E+04, 5.0652215771E+03, 2.1976756771E+04, 3.7010606559E+03, 9.8035180758E-01],
	[4.53850E+04, 3.6683600252E+04, 5.0652600699E+03, 2.1984663372E+04, 3.7013783893E+03, 9.8035947444E-01],
	[4.53900E+04, 3.6690770525E+04, 5.0652985588E+03, 2.1992571945E+04, 3.7016960472E+03, 9.8036713771E-01],
	[4.53950E+04, 3.6697941408E+04, 5.0653370438E+03, 2.2000482490E+04, 3.7020136295E+03, 9.8037479741E-01],
	[4.54000E+04, 3.6705112904E+04, 5.0653755248E+03, 2.2008395007E+04, 3.7023311363E+03, 9.8038245354E-01],
	[4.54050E+04, 3.6712285011E+04, 5.0654140019E+03, 2.2016309496E+04, 3.7026485676E+03, 9.8039010610E-01],
	[4.54100E+04, 3.6719457729E+04, 5.0654524750E+03, 2.2024225958E+04, 3.7029659235E+03, 9.8039775508E-01],
	[4.54150E+04, 3.6726631058E+04, 5.0654909442E+03, 2.2032144393E+04, 3.7032832039E+03, 9.8040540050E-01],
	[4.54200E+04, 3.6733805000E+04, 5.0655294094E+03, 2.2040064802E+04, 3.7036004088E+03, 9.8041304235E-01],
	[4.54250E+04, 3.6740979552E+04, 5.0655678707E+03, 2.2047987183E+04, 3.7039175383E+03, 9.8042068064E-01],
	[4.54300E+04, 3.6748154716E+04, 5.0656063281E+03, 2.2055911539E+04, 3.7042345925E+03, 9.8042831536E-01],
	[4.54350E+04, 3.6755330491E+04, 5.0656447815E+03, 2.2063837869E+04, 3.7045515712E+03, 9.8043594653E-01],
	[4.54400E+04, 3.6762506878E+04, 5.0656832310E+03, 2.2071766173E+04, 3.7048684745E+03, 9.8044357413E-01],
	[4.54450E+04, 3.6769683875E+04, 5.0657216765E+03, 2.2079696452E+04, 3.7051853025E+03, 9.8045119818E-01],
	[4.54500E+04, 3.6776861485E+04, 5.0657601181E+03, 2.2087628705E+04, 3.7055020552E+03, 9.8045881868E-01],
	[4.54550E+04, 3.6784039705E+04, 5.0657985558E+03, 2.2095562934E+04, 3.7058187325E+03, 9.8046643562E-01],
	[4.54600E+04, 3.6791218537E+04, 5.0658369895E+03, 2.2103499138E+04, 3.7061353346E+03, 9.8047404901E-01],
	[4.54650E+04, 3.6798397980E+04, 5.0658754193E+03, 2.2111437318E+04, 3.7064518614E+03, 9.8048165885E-01],
	[4.54700E+04, 3.6805578034E+04, 5.0659138451E+03, 2.2119377474E+04, 3.7067683129E+03, 9.8048926514E-01],
	[4.54750E+04, 3.6812758700E+04, 5.0659522670E+03, 2.2127319607E+04, 3.7070846891E+03, 9.8049686789E-01],
	[4.54800E+04, 3.6819939976E+04, 5.0659906850E+03, 2.2135263715E+04, 3.7074009902E+03, 9.8050446710E-01],
	[4.54850E+04, 3.6827121864E+04, 5.0660290991E+03, 2.2143209801E+04, 3.7077172160E+03, 9.8051206276E-01],
	[4.54900E+04, 3.6834304363E+04, 5.0660675092E+03, 2.2151157864E+04, 3.7080333666E+03, 9.8051965488E-01],
	[4.54950E+04, 3.6841487474E+04, 5.0661059154E+03, 2.2159107904E+04, 3.7083494421E+03, 9.8052724346E-01],
	[4.55000E+04, 3.6848671195E+04, 5.0661443177E+03, 2.2167059921E+04, 3.7086654424E+03, 9.8053482851E-01],
	[4.55050E+04, 3.6855855528E+04, 5.0661827160E+03, 2.2175013917E+04, 3.7089813676E+03, 9.8054241002E-01],
	[4.55100E+04, 3.6863040471E+04, 5.0662211104E+03, 2.2182969891E+04, 3.7092972176E+03, 9.8054998800E-01],
	[4.55150E+04, 3.6870226026E+04, 5.0662595009E+03, 2.2190927843E+04, 3.7096129926E+03, 9.8055756245E-01],
	[4.55200E+04, 3.6877412192E+04, 5.0662978874E+03, 2.2198887774E+04, 3.7099286925E+03, 9.8056513337E-01],
	[4.55250E+04, 3.6884598969E+04, 5.0663362701E+03, 2.2206849684E+04, 3.7102443173E+03, 9.8057270077E-01],
	[4.55300E+04, 3.6891786357E+04, 5.0663746488E+03, 2.2214813574E+04, 3.7105598670E+03, 9.8058026463E-01],
	[4.55350E+04, 3.6898974357E+04, 5.0664130236E+03, 2.2222779442E+04, 3.7108753417E+03, 9.8058782498E-01],
	[4.55400E+04, 3.6906162967E+04, 5.0664513944E+03, 2.2230747291E+04, 3.7111907415E+03, 9.8059538180E-01],
	[4.55450E+04, 3.6913352188E+04, 5.0664897614E+03, 2.2238717120E+04, 3.7115060662E+03, 9.8060293510E-01],
	[4.55500E+04, 3.6920542020E+04, 5.0665281244E+03, 2.2246688929E+04, 3.7118213159E+03, 9.8061048489E-01],
	[4.55550E+04, 3.6927732463E+04, 5.0665664835E+03, 2.2254662719E+04, 3.7121364907E+03, 9.8061803115E-01],
	[4.55600E+04, 3.6934923518E+04, 5.0666048386E+03, 2.2262638490E+04, 3.7124515906E+03, 9.8062557391E-01],
	[4.55650E+04, 3.6942115183E+04, 5.0666431899E+03, 2.2270616242E+04, 3.7127666155E+03, 9.8063311315E-01],
	[4.55700E+04, 3.6949307459E+04, 5.0666815372E+03, 2.2278595975E+04, 3.7130815656E+03, 9.8064064888E-01],
	[4.55750E+04, 3.6956500346E+04, 5.0667198806E+03, 2.2286577691E+04, 3.7133964407E+03, 9.8064818110E-01],
	[4.55800E+04, 3.6963693844E+04, 5.0667582202E+03, 2.2294561388E+04, 3.7137112410E+03, 9.8065570982E-01],
	[4.55850E+04, 3.6970887953E+04, 5.0667965557E+03, 2.2302547067E+04, 3.7140259664E+03, 9.8066323503E-01],
	[4.55900E+04, 3.6978082673E+04, 5.0668348874E+03, 2.2310534730E+04, 3.7143406170E+03, 9.8067075673E-01],
	[4.55950E+04, 3.6985278003E+04, 5.0668732152E+03, 2.2318524375E+04, 3.7146551928E+03, 9.8067827494E-01],
	[4.56000E+04, 3.6992473945E+04, 5.0669115390E+03, 2.2326516003E+04, 3.7149696938E+03, 9.8068578964E-01],
	[4.56050E+04, 3.6999670497E+04, 5.0669498590E+03, 2.2334509614E+04, 3.7152841200E+03, 9.8069330085E-01],
	[4.56100E+04, 3.7006867660E+04, 5.0669881750E+03, 2.2342505209E+04, 3.7155984715E+03, 9.8070080856E-01],
	[4.56150E+04, 3.7014065434E+04, 5.0670264871E+03, 2.2350502788E+04, 3.7159127482E+03, 9.8070831278E-01],
	[4.56200E+04, 3.7021263819E+04, 5.0670647953E+03, 2.2358502352E+04, 3.7162269502E+03, 9.8071581351E-01],
	[4.56250E+04, 3.7028462815E+04, 5.0671030996E+03, 2.2366503900E+04, 3.7165410775E+03, 9.8072331074E-01],
	[4.56300E+04, 3.7035662421E+04, 5.0671414000E+03, 2.2374507432E+04, 3.7168551301E+03, 9.8073080449E-01],
	[4.56350E+04, 3.7042862638E+04, 5.0671796965E+03, 2.2382512950E+04, 3.7171691080E+03, 9.8073829475E-01],
	[4.56400E+04, 3.7050063466E+04, 5.0672179890E+03, 2.2390520453E+04, 3.7174830113E+03, 9.8074578152E-01],
	[4.56450E+04, 3.7057264905E+04, 5.0672562777E+03, 2.2398529941E+04, 3.7177968399E+03, 9.8075326481E-01],
	[4.56500E+04, 3.7064466954E+04, 5.0672945625E+03, 2.2406541416E+04, 3.7181105940E+03, 9.8076074462E-01],
	[4.56550E+04, 3.7071669614E+04, 5.0673328433E+03, 2.2414554876E+04, 3.7184242734E+03, 9.8076822095E-01],
	[4.56600E+04, 3.7078872884E+04, 5.0673711203E+03, 2.2422570323E+04, 3.7187378783E+03, 9.8077569380E-01],
	[4.56650E+04, 3.7086076766E+04, 5.0674093933E+03, 2.2430587757E+04, 3.7190514086E+03, 9.8078316318E-01],
	[4.56700E+04, 3.7093281258E+04, 5.0674476625E+03, 2.2438607178E+04, 3.7193648643E+03, 9.8079062908E-01],
	[4.56750E+04, 3.7100486360E+04, 5.0674859277E+03, 2.2446628585E+04, 3.7196782455E+03, 9.8079809151E-01],
	[4.56800E+04, 3.7107692073E+04, 5.0675241891E+03, 2.2454651981E+04, 3.7199915523E+03, 9.8080555047E-01],
	[4.56850E+04, 3.7114898397E+04, 5.0675624465E+03, 2.2462677364E+04, 3.7203047845E+03, 9.8081300596E-01],
	[4.56900E+04, 3.7122105332E+04, 5.0676007001E+03, 2.2470704735E+04, 3.7206179423E+03, 9.8082045798E-01],
	[4.56950E+04, 3.7129312876E+04, 5.0676389498E+03, 2.2478734095E+04, 3.7209310256E+03, 9.8082790654E-01],
	[4.57000E+04, 3.7136521032E+04, 5.0676771955E+03, 2.2486765443E+04, 3.7212440344E+03, 9.8083535164E-01],
	[4.57050E+04, 3.7143729798E+04, 5.0677154374E+03, 2.2494798780E+04, 3.7215569689E+03, 9.8084279327E-01],
	[4.57100E+04, 3.7150939175E+04, 5.0677536754E+03, 2.2502834106E+04, 3.7218698289E+03, 9.8085023145E-01],
	[4.57150E+04, 3.7158149162E+04, 5.0677919094E+03, 2.2510871422E+04, 3.7221826146E+03, 9.8085766617E-01],
	[4.57200E+04, 3.7165359759E+04, 5.0678301396E+03, 2.2518910727E+04, 3.7224953259E+03, 9.8086509743E-01],
	[4.57250E+04, 3.7172570967E+04, 5.0678683659E+03, 2.2526952022E+04, 3.7228079629E+03, 9.8087252523E-01],
	[4.57300E+04, 3.7179782786E+04, 5.0679065883E+03, 2.2534995308E+04, 3.7231205255E+03, 9.8087994959E-01],
	[4.57350E+04, 3.7186995215E+04, 5.0679448068E+03, 2.2543040584E+04, 3.7234330139E+03, 9.8088737049E-01],
	[4.57400E+04, 3.7194208254E+04, 5.0679830214E+03, 2.2551087851E+04, 3.7237454279E+03, 9.8089478795E-01],
	[4.57450E+04, 3.7201421904E+04, 5.0680212322E+03, 2.2559137109E+04, 3.7240577677E+03, 9.8090220196E-01],
	[4.57500E+04, 3.7208636164E+04, 5.0680594390E+03, 2.2567188358E+04, 3.7243700332E+03, 9.8090961252E-01],
	[4.57550E+04, 3.7215851035E+04, 5.0680976420E+03, 2.2575241599E+04, 3.7246822244E+03, 9.8091701964E-01],
	[4.57600E+04, 3.7223066516E+04, 5.0681358410E+03, 2.2583296832E+04, 3.7249943415E+03, 9.8092442332E-01],
	[4.57650E+04, 3.7230282607E+04, 5.0681740362E+03, 2.2591354057E+04, 3.7253063843E+03, 9.8093182356E-01],
	[4.57700E+04, 3.7237499309E+04, 5.0682122275E+03, 2.2599413274E+04, 3.7256183530E+03, 9.8093922037E-01],
	[4.57750E+04, 3.7244716621E+04, 5.0682504149E+03, 2.2607474485E+04, 3.7259302475E+03, 9.8094661373E-01],
	[4.57800E+04, 3.7251934543E+04, 5.0682885985E+03, 2.2615537688E+04, 3.7262420678E+03, 9.8095400366E-01],
	[4.57850E+04, 3.7259153076E+04, 5.0683267781E+03, 2.2623602884E+04, 3.7265538140E+03, 9.8096139016E-01],
	[4.57900E+04, 3.7266372219E+04, 5.0683649539E+03, 2.2631670074E+04, 3.7268654862E+03, 9.8096877323E-01],
	[4.57950E+04, 3.7273591972E+04, 5.0684031258E+03, 2.2639739258E+04, 3.7271770842E+03, 9.8097615287E-01],
	[4.58000E+04, 3.7280812336E+04, 5.0684412938E+03, 2.2647810436E+04, 3.7274886081E+03, 9.8098352909E-01],
	[4.58050E+04, 3.7288033309E+04, 5.0684794579E+03, 2.2655883608E+04, 3.7278000580E+03, 9.8099090188E-01],
	[4.58100E+04, 3.7295254893E+04, 5.0685176181E+03, 2.2663958775E+04, 3.7281114338E+03, 9.8099827124E-01],
	[4.58150E+04, 3.7302477087E+04, 5.0685557745E+03, 2.2672035937E+04, 3.7284227356E+03, 9.8100563718E-01],
	[4.58200E+04, 3.7309699892E+04, 5.0685939270E+03, 2.2680115094E+04, 3.7287339634E+03, 9.8101299971E-01],
	[4.58250E+04, 3.7316923306E+04, 5.0686320756E+03, 2.2688196247E+04, 3.7290451173E+03, 9.8102035881E-01],
	[4.58300E+04, 3.7324147331E+04, 5.0686702204E+03, 2.2696279395E+04, 3.7293561971E+03, 9.8102771450E-01],
	[4.58350E+04, 3.7331371966E+04, 5.0687083612E+03, 2.2704364539E+04, 3.7296672030E+03, 9.8103506678E-01],
	[4.58400E+04, 3.7338597211E+04, 5.0687464982E+03, 2.2712451680E+04, 3.7299781350E+03, 9.8104241564E-01],
	[4.58450E+04, 3.7345823066E+04, 5.0687846313E+03, 2.2720540817E+04, 3.7302889930E+03, 9.8104976110E-01],
	[4.58500E+04, 3.7353049531E+04, 5.0688227606E+03, 2.2728631951E+04, 3.7305997772E+03, 9.8105710314E-01],
	[4.58550E+04, 3.7360276606E+04, 5.0688608860E+03, 2.2736725082E+04, 3.7309104875E+03, 9.8106444177E-01],
	[4.58600E+04, 3.7367504292E+04, 5.0688990075E+03, 2.2744820211E+04, 3.7312211239E+03, 9.8107177701E-01],
	[4.58650E+04, 3.7374732587E+04, 5.0689371251E+03, 2.2752917337E+04, 3.7315316865E+03, 9.8107910883E-01],
	[4.58700E+04, 3.7381961493E+04, 5.0689752389E+03, 2.2761016461E+04, 3.7318421752E+03, 9.8108643726E-01],
	[4.58750E+04, 3.7389191008E+04, 5.0690133488E+03, 2.2769117583E+04, 3.7321525901E+03, 9.8109376228E-01],
	[4.58800E+04, 3.7396421134E+04, 5.0690514548E+03, 2.2777220704E+04, 3.7324629313E+03, 9.8110108391E-01],
	[4.58850E+04, 3.7403651869E+04, 5.0690895570E+03, 2.2785325824E+04, 3.7327731987E+03, 9.8110840214E-01],
	[4.58900E+04, 3.7410883215E+04, 5.0691276553E+03, 2.2793432942E+04, 3.7330833923E+03, 9.8111571698E-01],
	[4.58950E+04, 3.7418115170E+04, 5.0691657497E+03, 2.2801542060E+04, 3.7333935122E+03, 9.8112302842E-01],
	[4.59000E+04, 3.7425347735E+04, 5.0692038403E+03, 2.2809653178E+04, 3.7337035584E+03, 9.8113033648E-01],
	[4.59050E+04, 3.7432580911E+04, 5.0692419270E+03, 2.2817766295E+04, 3.7340135308E+03, 9.8113764114E-01],
	[4.59100E+04, 3.7439814696E+04, 5.0692800099E+03, 2.2825881412E+04, 3.7343234296E+03, 9.8114494242E-01],
	[4.59150E+04, 3.7447049091E+04, 5.0693180889E+03, 2.2833998530E+04, 3.7346332548E+03, 9.8115224031E-01],
	[4.59200E+04, 3.7454284096E+04, 5.0693561640E+03, 2.2842117649E+04, 3.7349430062E+03, 9.8115953481E-01],
	[4.59250E+04, 3.7461519711E+04, 5.0693942353E+03, 2.2850238768E+04, 3.7352526841E+03, 9.8116682594E-01],
	[4.59300E+04, 3.7468755936E+04, 5.0694323027E+03, 2.2858361889E+04, 3.7355622883E+03, 9.8117411368E-01],
	[4.59350E+04, 3.7475992771E+04, 5.0694703662E+03, 2.2866487012E+04, 3.7358718190E+03, 9.8118139805E-01],
	[4.59400E+04, 3.7483230215E+04, 5.0695084259E+03, 2.2874614136E+04, 3.7361812761E+03, 9.8118867904E-01],
	[4.59450E+04, 3.7490468270E+04, 5.0695464818E+03, 2.2882743262E+04, 3.7364906596E+03, 9.8119595665E-01],
	[4.59500E+04, 3.7497706934E+04, 5.0695845338E+03, 2.2890874390E+04, 3.7367999696E+03, 9.8120323090E-01],
	[4.59550E+04, 3.7504946208E+04, 5.0696225819E+03, 2.2899007521E+04, 3.7371092060E+03, 9.8121050177E-01],
	[4.59600E+04, 3.7512186091E+04, 5.0696606262E+03, 2.2907142655E+04, 3.7374183690E+03, 9.8121776927E-01],
	[4.59650E+04, 3.7519426585E+04, 5.0696986666E+03, 2.2915279792E+04, 3.7377274585E+03, 9.8122503340E-01],
	[4.59700E+04, 3.7526667688E+04, 5.0697367032E+03, 2.2923418933E+04, 3.7380364745E+03, 9.8123229417E-01],
	[4.59750E+04, 3.7533909401E+04, 5.0697747359E+03, 2.2931560077E+04, 3.7383454170E+03, 9.8123955157E-01],
	[4.59800E+04, 3.7541151723E+04, 5.0698127647E+03, 2.2939703225E+04, 3.7386542861E+03, 9.8124680561E-01],
	[4.59850E+04, 3.7548394656E+04, 5.0698507898E+03, 2.2947848378E+04, 3.7389630819E+03, 9.8125405629E-01],
	[4.59900E+04, 3.7555638198E+04, 5.0698888109E+03, 2.2955995535E+04, 3.7392718042E+03, 9.8126130361E-01],
	[4.59950E+04, 3.7562882349E+04, 5.0699268283E+03, 2.2964144697E+04, 3.7395804531E+03, 9.8126854757E-01],
	[4.60000E+04, 3.7570127111E+04, 5.0699648417E+03, 2.2972295864E+04, 3.7398890287E+03, 9.8127578818E-01],
	[4.60050E+04, 3.7577372482E+04, 5.0700028513E+03, 2.2980449036E+04, 3.7401975309E+03, 9.8128302544E-01],
	[4.60100E+04, 3.7584618462E+04, 5.0700408571E+03, 2.2988604214E+04, 3.7405059598E+03, 9.8129025934E-01],
	[4.60150E+04, 3.7591865053E+04, 5.0700788591E+03, 2.2996761398E+04, 3.7408143154E+03, 9.8129748989E-01],
	[4.60200E+04, 3.7599112252E+04, 5.0701168572E+03, 2.3004920588E+04, 3.7411225978E+03, 9.8130471710E-01],
	[4.60250E+04, 3.7606360062E+04, 5.0701548514E+03, 2.3013081784E+04, 3.7414308068E+03, 9.8131194096E-01],
	[4.60300E+04, 3.7613608481E+04, 5.0701928418E+03, 2.3021244987E+04, 3.7417389426E+03, 9.8131916147E-01],
	[4.60350E+04, 3.7620857509E+04, 5.0702308284E+03, 2.3029410197E+04, 3.7420470052E+03, 9.8132637864E-01],
	[4.60400E+04, 3.7628107147E+04, 5.0702688111E+03, 2.3037577415E+04, 3.7423549945E+03, 9.8133359247E-01],
	[4.60450E+04, 3.7635357395E+04, 5.0703067900E+03, 2.3045746640E+04, 3.7426629107E+03, 9.8134080296E-01],
	[4.60500E+04, 3.7642608252E+04, 5.0703447650E+03, 2.3053917873E+04, 3.7429707536E+03, 9.8134801011E-01],
	[4.60550E+04, 3.7649859719E+04, 5.0703827362E+03, 2.3062091114E+04, 3.7432785234E+03, 9.8135521393E-01],
	[4.60600E+04, 3.7657111795E+04, 5.0704207036E+03, 2.3070266363E+04, 3.7435862201E+03, 9.8136241442E-01],
	[4.60650E+04, 3.7664364480E+04, 5.0704586671E+03, 2.3078443621E+04, 3.7438938436E+03, 9.8136961157E-01],
	[4.60700E+04, 3.7671617775E+04, 5.0704966268E+03, 2.3086622888E+04, 3.7442013940E+03, 9.8137680539E-01],
	[4.60750E+04, 3.7678871679E+04, 5.0705345827E+03, 2.3094804164E+04, 3.7445088714E+03, 9.8138399588E-01],
	[4.60800E+04, 3.7686126193E+04, 5.0705725347E+03, 2.3102987449E+04, 3.7448162756E+03, 9.8139118304E-01],
	[4.60850E+04, 3.7693381316E+04, 5.0706104829E+03, 2.3111172745E+04, 3.7451236068E+03, 9.8139836688E-01],
	[4.60900E+04, 3.7700637049E+04, 5.0706484272E+03, 2.3119360050E+04, 3.7454308650E+03, 9.8140554740E-01],
	[4.60950E+04, 3.7707893391E+04, 5.0706863677E+03, 2.3127549366E+04, 3.7457380501E+03, 9.8141272459E-01],
	[4.61000E+04, 3.7715150342E+04, 5.0707243044E+03, 2.3135740692E+04, 3.7460451623E+03, 9.8141989847E-01],
	[4.61050E+04, 3.7722407903E+04, 5.0707622373E+03, 2.3143934029E+04, 3.7463522014E+03, 9.8142706902E-01],
	[4.61100E+04, 3.7729666073E+04, 5.0708001663E+03, 2.3152129377E+04, 3.7466591676E+03, 9.8143423626E-01],
	[4.61150E+04, 3.7736924852E+04, 5.0708380915E+03, 2.3160326737E+04, 3.7469660608E+03, 9.8144140019E-01],
	[4.61200E+04, 3.7744184241E+04, 5.0708760129E+03, 2.3168526108E+04, 3.7472728811E+03, 9.8144856080E-01],
	[4.61250E+04, 3.7751444238E+04, 5.0709139304E+03, 2.3176727491E+04, 3.7475796285E+03, 9.8145571810E-01],
	[4.61300E+04, 3.7758704846E+04, 5.0709518442E+03, 2.3184930887E+04, 3.7478863030E+03, 9.8146287210E-01],
	[4.61350E+04, 3.7765966062E+04, 5.0709897541E+03, 2.3193136295E+04, 3.7481929047E+03, 9.8147002278E-01],
	[4.61400E+04, 3.7773227888E+04, 5.0710276601E+03, 2.3201343715E+04, 3.7484994334E+03, 9.8147717016E-01],
	[4.61450E+04, 3.7780490322E+04, 5.0710655624E+03, 2.3209553149E+04, 3.7488058894E+03, 9.8148431423E-01],
	[4.61500E+04, 3.7787753366E+04, 5.0711034608E+03, 2.3217764596E+04, 3.7491122725E+03, 9.8149145500E-01],
	[4.61550E+04, 3.7795017020E+04, 5.0711413554E+03, 2.3225978057E+04, 3.7494185827E+03, 9.8149859248E-01],
	[4.61600E+04, 3.7802281282E+04, 5.0711792462E+03, 2.3234193532E+04, 3.7497248203E+03, 9.8150572665E-01],
	[4.61650E+04, 3.7809546154E+04, 5.0712171331E+03, 2.3242411021E+04, 3.7500309850E+03, 9.8151285753E-01],
	[4.61700E+04, 3.7816811634E+04, 5.0712550163E+03, 2.3250630524E+04, 3.7503370770E+03, 9.8151998511E-01],
	[4.61750E+04, 3.7824077724E+04, 5.0712928956E+03, 2.3258852042E+04, 3.7506430962E+03, 9.8152710939E-01],
	[4.61800E+04, 3.7831344423E+04, 5.0713307711E+03, 2.3267075574E+04, 3.7509490428E+03, 9.8153423039E-01],
	[4.61850E+04, 3.7838611731E+04, 5.0713686428E+03, 2.3275301123E+04, 3.7512549166E+03, 9.8154134809E-01],
	[4.61900E+04, 3.7845879648E+04, 5.0714065106E+03, 2.3283528686E+04, 3.7515607177E+03, 9.8154846251E-01],
	[4.61950E+04, 3.7853148175E+04, 5.0714443747E+03, 2.3291758266E+04, 3.7518664462E+03, 9.8155557364E-01],
	[4.62000E+04, 3.7860417310E+04, 5.0714822349E+03, 2.3299989861E+04, 3.7521721021E+03, 9.8156268149E-01],
	[4.62050E+04, 3.7867687054E+04, 5.0715200913E+03, 2.3308223473E+04, 3.7524776853E+03, 9.8156978605E-01],
	[4.62100E+04, 3.7874957407E+04, 5.0715579439E+03, 2.3316459102E+04, 3.7527831959E+03, 9.8157688733E-01],
	[4.62150E+04, 3.7882228370E+04, 5.0715957927E+03, 2.3324696747E+04, 3.7530886339E+03, 9.8158398533E-01],
	[4.62200E+04, 3.7889499941E+04, 5.0716336377E+03, 2.3332936410E+04, 3.7533939994E+03, 9.8159108005E-01],
	[4.62250E+04, 3.7896772122E+04, 5.0716714789E+03, 2.3341178090E+04, 3.7536992923E+03, 9.8159817150E-01],
	[4.62300E+04, 3.7904044911E+04, 5.0717093162E+03, 2.3349421787E+04, 3.7540045126E+03, 9.8160525968E-01],
	[4.62350E+04, 3.7911318309E+04, 5.0717471498E+03, 2.3357667503E+04, 3.7543096604E+03, 9.8161234458E-01],
	[4.62400E+04, 3.7918592316E+04, 5.0717849795E+03, 2.3365915237E+04, 3.7546147358E+03, 9.8161942621E-01],
	[4.62450E+04, 3.7925866932E+04, 5.0718228054E+03, 2.3374164990E+04, 3.7549197386E+03, 9.8162650457E-01],
	[4.62500E+04, 3.7933142157E+04, 5.0718606275E+03, 2.3382416761E+04, 3.7552246690E+03, 9.8163357966E-01],
	[4.62550E+04, 3.7940417991E+04, 5.0718984459E+03, 2.3390670552E+04, 3.7555295269E+03, 9.8164065149E-01],
	[4.62600E+04, 3.7947694434E+04, 5.0719362604E+03, 2.3398926362E+04, 3.7558343124E+03, 9.8164772005E-01],
	[4.62650E+04, 3.7954971486E+04, 5.0719740711E+03, 2.3407184191E+04, 3.7561390255E+03, 9.8165478535E-01],
	[4.62700E+04, 3.7962249146E+04, 5.0720118780E+03, 2.3415444041E+04, 3.7564436662E+03, 9.8166184740E-01],
	[4.62750E+04, 3.7969527416E+04, 5.0720496811E+03, 2.3423705910E+04, 3.7567482345E+03, 9.8166890618E-01],
	[4.62800E+04, 3.7976806294E+04, 5.0720874804E+03, 2.3431969801E+04, 3.7570527304E+03, 9.8167596170E-01],
	[4.62850E+04, 3.7984085781E+04, 5.0721252759E+03, 2.3440235711E+04, 3.7573571540E+03, 9.8168301398E-01],
	[4.62900E+04, 3.7991365877E+04, 5.0721630675E+03, 2.3448503643E+04, 3.7576615053E+03, 9.8169006299E-01],
	[4.62950E+04, 3.7998646581E+04, 5.0722008554E+03, 2.3456773597E+04, 3.7579657843E+03, 9.8169710876E-01],
	[4.63000E+04, 3.8005927895E+04, 5.0722386395E+03, 2.3465045572E+04, 3.7582699910E+03, 9.8170415127E-01],
	[4.63050E+04, 3.8013209817E+04, 5.0722764198E+03, 2.3473319568E+04, 3.7585741254E+03, 9.8171119054E-01],
	[4.63100E+04, 3.8020492347E+04, 5.0723141963E+03, 2.3481595587E+04, 3.7588781875E+03, 9.8171822656E-01],
	[4.63150E+04, 3.8027775487E+04, 5.0723519690E+03, 2.3489873628E+04, 3.7591821775E+03, 9.8172525934E-01],
	[4.63200E+04, 3.8035059235E+04, 5.0723897379E+03, 2.3498153692E+04, 3.7594860952E+03, 9.8173228887E-01],
	[4.63250E+04, 3.8042343592E+04, 5.0724275030E+03, 2.3506435779E+04, 3.7597899407E+03, 9.8173931516E-01],
	[4.63300E+04, 3.8049628557E+04, 5.0724652643E+03, 2.3514719889E+04, 3.7600937140E+03, 9.8174633822E-01],
	[4.63350E+04, 3.8056914132E+04, 5.0725030218E+03, 2.3523006023E+04, 3.7603974152E+03, 9.8175335803E-01],
	[4.63400E+04, 3.8064200315E+04, 5.0725407756E+03, 2.3531294180E+04, 3.7607010442E+03, 9.8176037461E-01],
	[4.63450E+04, 3.8071487106E+04, 5.0725785255E+03, 2.3539584362E+04, 3.7610046011E+03, 9.8176738795E-01],
	[4.63500E+04, 3.8078774506E+04, 5.0726162716E+03, 2.3547876567E+04, 3.7613080858E+03, 9.8177439806E-01],
	[4.63550E+04, 3.8086062515E+04, 5.0726540140E+03, 2.3556170798E+04, 3.7616114985E+03, 9.8178140494E-01],
	[4.63600E+04, 3.8093351132E+04, 5.0726917525E+03, 2.3564467053E+04, 3.7619148391E+03, 9.8178840859E-01],
	[4.63650E+04, 3.8100640358E+04, 5.0727294873E+03, 2.3572765334E+04, 3.7622181077E+03, 9.8179540902E-01],
	[4.63700E+04, 3.8107930192E+04, 5.0727672183E+03, 2.3581065639E+04, 3.7625213042E+03, 9.8180240621E-01],
	[4.63750E+04, 3.8115220635E+04, 5.0728049455E+03, 2.3589367971E+04, 3.7628244287E+03, 9.8180940019E-01],
	[4.63800E+04, 3.8122511687E+04, 5.0728426689E+03, 2.3597672329E+04, 3.7631274812E+03, 9.8181639094E-01],
	[4.63850E+04, 3.8129803347E+04, 5.0728803885E+03, 2.3605978712E+04, 3.7634304617E+03, 9.8182337847E-01],
	[4.63900E+04, 3.8137095615E+04, 5.0729181043E+03, 2.3614287123E+04, 3.7637333702E+03, 9.8183036278E-01],
	[4.63950E+04, 3.8144388492E+04, 5.0729558164E+03, 2.3622597560E+04, 3.7640362068E+03, 9.8183734387E-01],
	[4.64000E+04, 3.8151681977E+04, 5.0729935247E+03, 2.3630910024E+04, 3.7643389714E+03, 9.8184432175E-01],
	[4.64050E+04, 3.8158976071E+04, 5.0730312291E+03, 2.3639224516E+04, 3.7646416642E+03, 9.8185129642E-01],
	[4.64100E+04, 3.8166270773E+04, 5.0730689298E+03, 2.3647541035E+04, 3.7649442850E+03, 9.8185826787E-01],
	[4.64150E+04, 3.8173566084E+04, 5.0731066268E+03, 2.3655859582E+04, 3.7652468340E+03, 9.8186523612E-01],
	[4.64200E+04, 3.8180862003E+04, 5.0731443199E+03, 2.3664180158E+04, 3.7655493110E+03, 9.8187220115E-01],
	[4.64250E+04, 3.8188158531E+04, 5.0731820093E+03, 2.3672502762E+04, 3.7658517163E+03, 9.8187916298E-01],
	[4.64300E+04, 3.8195455667E+04, 5.0732196948E+03, 2.3680827394E+04, 3.7661540497E+03, 9.8188612160E-01],
	[4.64350E+04, 3.8202753411E+04, 5.0732573766E+03, 2.3689154056E+04, 3.7664563113E+03, 9.8189307702E-01],
	[4.64400E+04, 3.8210051763E+04, 5.0732950547E+03, 2.3697482747E+04, 3.7667585012E+03, 9.8190002924E-01],
	[4.64450E+04, 3.8217350724E+04, 5.0733327289E+03, 2.3705813467E+04, 3.7670606192E+03, 9.8190697825E-01],
	[4.64500E+04, 3.8224650293E+04, 5.0733703994E+03, 2.3714146217E+04, 3.7673626655E+03, 9.8191392407E-01],
	[4.64550E+04, 3.8231950471E+04, 5.0734080661E+03, 2.3722480998E+04, 3.7676646401E+03, 9.8192086669E-01],
	[4.64600E+04, 3.8239251257E+04, 5.0734457290E+03, 2.3730817808E+04, 3.7679665429E+03, 9.8192780612E-01],
	[4.64650E+04, 3.8246552651E+04, 5.0734833882E+03, 2.3739156650E+04, 3.7682683740E+03, 9.8193474236E-01],
	[4.64700E+04, 3.8253854653E+04, 5.0735210435E+03, 2.3747497522E+04, 3.7685701335E+03, 9.8194167540E-01],
	[4.64750E+04, 3.8261157264E+04, 5.0735586951E+03, 2.3755840426E+04, 3.7688718213E+03, 9.8194860525E-01],
	[4.64800E+04, 3.8268460482E+04, 5.0735963430E+03, 2.3764185361E+04, 3.7691734374E+03, 9.8195553192E-01],
	[4.64850E+04, 3.8275764309E+04, 5.0736339870E+03, 2.3772532328E+04, 3.7694749819E+03, 9.8196245539E-01],
	[4.64900E+04, 3.8283068745E+04, 5.0736716273E+03, 2.3780881327E+04, 3.7697764548E+03, 9.8196937569E-01],
	[4.64950E+04, 3.8290373788E+04, 5.0737092639E+03, 2.3789232358E+04, 3.7700778561E+03, 9.8197629280E-01],
	[4.65000E+04, 3.8297679440E+04, 5.0737468966E+03, 2.3797585422E+04, 3.7703791858E+03, 9.8198320673E-01],
	[4.65050E+04, 3.8304985699E+04, 5.0737845256E+03, 2.3805940519E+04, 3.7706804440E+03, 9.8199011748E-01],
	[4.65100E+04, 3.8312292567E+04, 5.0738221508E+03, 2.3814297648E+04, 3.7709816306E+03, 9.8199702505E-01],
	[4.65150E+04, 3.8319600043E+04, 5.0738597723E+03, 2.3822656812E+04, 3.7712827457E+03, 9.8200392945E-01],
	[4.65200E+04, 3.8326908127E+04, 5.0738973900E+03, 2.3831018009E+04, 3.7715837893E+03, 9.8201083067E-01],
	[4.65250E+04, 3.8334216819E+04, 5.0739350039E+03, 2.3839381240E+04, 3.7718847614E+03, 9.8201772872E-01],
	[4.65300E+04, 3.8341526120E+04, 5.0739726141E+03, 2.3847746505E+04, 3.7721856620E+03, 9.8202462360E-01],
	[4.65350E+04, 3.8348836028E+04, 5.0740102205E+03, 2.3856113805E+04, 3.7724864912E+03, 9.8203151531E-01],
	[4.65400E+04, 3.8356146544E+04, 5.0740478231E+03, 2.3864483139E+04, 3.7727872489E+03, 9.8203840385E-01],
	[4.65450E+04, 3.8363457669E+04, 5.0740854220E+03, 2.3872854509E+04, 3.7730879352E+03, 9.8204528922E-01],
	[4.65500E+04, 3.8370769401E+04, 5.0741230171E+03, 2.3881227914E+04, 3.7733885501E+03, 9.8205217143E-01],
	[4.65550E+04, 3.8378081741E+04, 5.0741606085E+03, 2.3889603354E+04, 3.7736890937E+03, 9.8205905048E-01],
	[4.65600E+04, 3.8385394690E+04, 5.0741981961E+03, 2.3897980831E+04, 3.7739895658E+03, 9.8206592637E-01],
	[4.65650E+04, 3.8392708246E+04, 5.0742357799E+03, 2.3906360343E+04, 3.7742899666E+03, 9.8207279910E-01],
	[4.65700E+04, 3.8400022411E+04, 5.0742733600E+03, 2.3914741892E+04, 3.7745902961E+03, 9.8207966867E-01],
	[4.65750E+04, 3.8407337183E+04, 5.0743109363E+03, 2.3923125478E+04, 3.7748905543E+03, 9.8208653509E-01],
	[4.65800E+04, 3.8414652563E+04, 5.0743485089E+03, 2.3931511101E+04, 3.7751907412E+03, 9.8209339835E-01],
	[4.65850E+04, 3.8421968551E+04, 5.0743860777E+03, 2.3939898761E+04, 3.7754908568E+03, 9.8210025846E-01],
	[4.65900E+04, 3.8429285147E+04, 5.0744236428E+03, 2.3948288459E+04, 3.7757909012E+03, 9.8210711541E-01],
	[4.65950E+04, 3.8436602351E+04, 5.0744612041E+03, 2.3956680194E+04, 3.7760908743E+03, 9.8211396922E-01],
	[4.66000E+04, 3.8443920163E+04, 5.0744987617E+03, 2.3965073968E+04, 3.7763907761E+03, 9.8212081989E-01],
	[4.66050E+04, 3.8451238583E+04, 5.0745363155E+03, 2.3973469780E+04, 3.7766906068E+03, 9.8212766740E-01],
	[4.66100E+04, 3.8458557610E+04, 5.0745738655E+03, 2.3981867631E+04, 3.7769903663E+03, 9.8213451177E-01],
	[4.66150E+04, 3.8465877246E+04, 5.0746114118E+03, 2.3990267520E+04, 3.7772900546E+03, 9.8214135301E-01],
	[4.66200E+04, 3.8473197489E+04, 5.0746489544E+03, 2.3998669449E+04, 3.7775896718E+03, 9.8214819110E-01],
	[4.66250E+04, 3.8480518340E+04, 5.0746864932E+03, 2.4007073417E+04, 3.7778892178E+03, 9.8215502605E-01],
	[4.66300E+04, 3.8487839798E+04, 5.0747240283E+03, 2.4015479425E+04, 3.7781886928E+03, 9.8216185786E-01],
	[4.66350E+04, 3.8495161865E+04, 5.0747615596E+03, 2.4023887473E+04, 3.7784880966E+03, 9.8216868654E-01],
	[4.66400E+04, 3.8502484539E+04, 5.0747990872E+03, 2.4032297562E+04, 3.7787874293E+03, 9.8217551208E-01],
	[4.66450E+04, 3.8509807821E+04, 5.0748366110E+03, 2.4040709691E+04, 3.7790866910E+03, 9.8218233449E-01],
	[4.66500E+04, 3.8517131711E+04, 5.0748741311E+03, 2.4049123861E+04, 3.7793858816E+03, 9.8218915378E-01],
	[4.66550E+04, 3.8524456208E+04, 5.0749116474E+03, 2.4057540072E+04, 3.7796850012E+03, 9.8219596993E-01],
	[4.66600E+04, 3.8531781313E+04, 5.0749491600E+03, 2.4065958324E+04, 3.7799840498E+03, 9.8220278296E-01],
	[4.66650E+04, 3.8539107026E+04, 5.0749866688E+03, 2.4074378618E+04, 3.7802830274E+03, 9.8220959286E-01],
	[4.66700E+04, 3.8546433347E+04, 5.0750241739E+03, 2.4082800954E+04, 3.7805819340E+03, 9.8221639963E-01],
	[4.66750E+04, 3.8553760275E+04, 5.0750616753E+03, 2.4091225333E+04, 3.7808807697E+03, 9.8222320329E-01],
	[4.66800E+04, 3.8561087811E+04, 5.0750991729E+03, 2.4099651754E+04, 3.7811795344E+03, 9.8223000382E-01],
	[4.66850E+04, 3.8568415954E+04, 5.0751366668E+03, 2.4108080217E+04, 3.7814782282E+03, 9.8223680124E-01],
	[4.66900E+04, 3.8575744705E+04, 5.0751741570E+03, 2.4116510724E+04, 3.7817768511E+03, 9.8224359554E-01],
	[4.66950E+04, 3.8583074063E+04, 5.0752116434E+03, 2.4124943274E+04, 3.7820754031E+03, 9.8225038672E-01],
	[4.67000E+04, 3.8590404030E+04, 5.0752491261E+03, 2.4133377868E+04, 3.7823738842E+03, 9.8225717479E-01],
	[4.67050E+04, 3.8597734603E+04, 5.0752866050E+03, 2.4141814505E+04, 3.7826722945E+03, 9.8226395975E-01],
	[4.67100E+04, 3.8605065785E+04, 5.0753240802E+03, 2.4150253187E+04, 3.7829706339E+03, 9.8227074160E-01],
	[4.67150E+04, 3.8612397573E+04, 5.0753615517E+03, 2.4158693913E+04, 3.7832689026E+03, 9.8227752034E-01],
	[4.67200E+04, 3.8619729970E+04, 5.0753990194E+03, 2.4167136684E+04, 3.7835671004E+03, 9.8228429597E-01],
	[4.67250E+04, 3.8627062974E+04, 5.0754364834E+03, 2.4175581500E+04, 3.7838652275E+03, 9.8229106849E-01],
	[4.67300E+04, 3.8634396585E+04, 5.0754739437E+03, 2.4184028361E+04, 3.7841632838E+03, 9.8229783792E-01],
	[4.67350E+04, 3.8641730804E+04, 5.0755114002E+03, 2.4192477268E+04, 3.7844612693E+03, 9.8230460424E-01],
	[4.67400E+04, 3.8649065630E+04, 5.0755488530E+03, 2.4200928221E+04, 3.7847591841E+03, 9.8231136746E-01],
	[4.67450E+04, 3.8656401064E+04, 5.0755863021E+03, 2.4209381219E+04, 3.7850570282E+03, 9.8231812758E-01],
	[4.67500E+04, 3.8663737105E+04, 5.0756237475E+03, 2.4217836264E+04, 3.7853548016E+03, 9.8232488461E-01],
	[4.67550E+04, 3.8671073753E+04, 5.0756611891E+03, 2.4226293356E+04, 3.7856525044E+03, 9.8233163854E-01],
	[4.67600E+04, 3.8678411009E+04, 5.0756986270E+03, 2.4234752495E+04, 3.7859501364E+03, 9.8233838937E-01],
	[4.67650E+04, 3.8685748873E+04, 5.0757360611E+03, 2.4243213681E+04, 3.7862476979E+03, 9.8234513712E-01],
	[4.67700E+04, 3.8693087343E+04, 5.0757734916E+03, 2.4251676914E+04, 3.7865451887E+03, 9.8235188177E-01],
	[4.67750E+04, 3.8700426421E+04, 5.0758109183E+03, 2.4260142195E+04, 3.7868426089E+03, 9.8235862334E-01],
	[4.67800E+04, 3.8707766107E+04, 5.0758483413E+03, 2.4268609524E+04, 3.7871399585E+03, 9.8236536182E-01],
	[4.67850E+04, 3.8715106400E+04, 5.0758857606E+03, 2.4277078902E+04, 3.7874372376E+03, 9.8237209721E-01],
	[4.67900E+04, 3.8722447300E+04, 5.0759231761E+03, 2.4285550328E+04, 3.7877344461E+03, 9.8237882952E-01],
	[4.67950E+04, 3.8729788807E+04, 5.0759605879E+03, 2.4294023803E+04, 3.7880315841E+03, 9.8238555875E-01],
	[4.68000E+04, 3.8737130922E+04, 5.0759979960E+03, 2.4302499327E+04, 3.7883286515E+03, 9.8239228489E-01],
	[4.68050E+04, 3.8744473644E+04, 5.0760354004E+03, 2.4310976900E+04, 3.7886256485E+03, 9.8239900796E-01],
	[4.68100E+04, 3.8751816973E+04, 5.0760728011E+03, 2.4319456523E+04, 3.7889225749E+03, 9.8240572795E-01],
	[4.68150E+04, 3.8759160909E+04, 5.0761101980E+03, 2.4327938197E+04, 3.7892194309E+03, 9.8241244487E-01],
	[4.68200E+04, 3.8766505453E+04, 5.0761475912E+03, 2.4336421920E+04, 3.7895162165E+03, 9.8241915871E-01],
	[4.68250E+04, 3.8773850604E+04, 5.0761849807E+03, 2.4344907694E+04, 3.7898129316E+03, 9.8242586948E-01],
	[4.68300E+04, 3.8781196362E+04, 5.0762223665E+03, 2.4353395519E+04, 3.7901095764E+03, 9.8243257718E-01],
	[4.68350E+04, 3.8788542727E+04, 5.0762597486E+03, 2.4361885394E+04, 3.7904061507E+03, 9.8243928181E-01],
	[4.68400E+04, 3.8795889699E+04, 5.0762971269E+03, 2.4370377322E+04, 3.7907026547E+03, 9.8244598338E-01],
	[4.68450E+04, 3.8803237279E+04, 5.0763345016E+03, 2.4378871300E+04, 3.7909990883E+03, 9.8245268188E-01],
	[4.68500E+04, 3.8810585466E+04, 5.0763718725E+03, 2.4387367331E+04, 3.7912954515E+03, 9.8245937731E-01],
	[4.68550E+04, 3.8817934259E+04, 5.0764092397E+03, 2.4395865414E+04, 3.7915917444E+03, 9.8246606968E-01],
	[4.68600E+04, 3.8825283660E+04, 5.0764466032E+03, 2.4404365549E+04, 3.7918879671E+03, 9.8247275900E-01],
	[4.68650E+04, 3.8832633668E+04, 5.0764839630E+03, 2.4412867737E+04, 3.7921841194E+03, 9.8247944525E-01],
	[4.68700E+04, 3.8839984283E+04, 5.0765213191E+03, 2.4421371978E+04, 3.7924802015E+03, 9.8248612845E-01],
	[4.68750E+04, 3.8847335506E+04, 5.0765586714E+03, 2.4429878272E+04, 3.7927762133E+03, 9.8249280859E-01],
	[4.68800E+04, 3.8854687335E+04, 5.0765960201E+03, 2.4438386620E+04, 3.7930721549E+03, 9.8249948567E-01],
	[4.68850E+04, 3.8862039771E+04, 5.0766333651E+03, 2.4446897022E+04, 3.7933680263E+03, 9.8250615971E-01],
	[4.68900E+04, 3.8869392814E+04, 5.0766707063E+03, 2.4455409478E+04, 3.7936638274E+03, 9.8251283069E-01],
	[4.68950E+04, 3.8876746465E+04, 5.0767080438E+03, 2.4463923988E+04, 3.7939595584E+03, 9.8251949863E-01],
	[4.69000E+04, 3.8884100722E+04, 5.0767453777E+03, 2.4472440553E+04, 3.7942552193E+03, 9.8252616351E-01],
	[4.69050E+04, 3.8891455586E+04, 5.0767827078E+03, 2.4480959173E+04, 3.7945508099E+03, 9.8253282536E-01],
	[4.69100E+04, 3.8898811057E+04, 5.0768200342E+03, 2.4489479848E+04, 3.7948463305E+03, 9.8253948416E-01],
	[4.69150E+04, 3.8906167135E+04, 5.0768573569E+03, 2.4498002578E+04, 3.7951417809E+03, 9.8254613991E-01],
	[4.69200E+04, 3.8913523821E+04, 5.0768946759E+03, 2.4506527365E+04, 3.7954371613E+03, 9.8255279263E-01],
	[4.69250E+04, 3.8920881113E+04, 5.0769319912E+03, 2.4515054207E+04, 3.7957324715E+03, 9.8255944230E-01],
	[4.69300E+04, 3.8928239011E+04, 5.0769693029E+03, 2.4523583105E+04, 3.7960277117E+03, 9.8256608894E-01],
	[4.69350E+04, 3.8935597517E+04, 5.0770066108E+03, 2.4532114061E+04, 3.7963228819E+03, 9.8257273254E-01],
	[4.69400E+04, 3.8942956630E+04, 5.0770439150E+03, 2.4540647073E+04, 3.7966179821E+03, 9.8257937311E-01],
	[4.69450E+04, 3.8950343862E+04, 5.0770847777E+03, 2.4549182142E+04, 3.7969152659E+03, 9.8258601065E-01],
	[4.69500E+04, 3.8957738928E+04, 5.0771265709E+03, 2.4557719269E+04, 3.7972130715E+03, 9.8259264515E-01],
	[4.69550E+04, 3.8965134610E+04, 5.0771683600E+03, 2.4566258453E+04, 3.7975108075E+03, 9.8259927663E-01],
	[4.69600E+04, 3.8972530908E+04, 5.0772101451E+03, 2.4574799695E+04, 3.7978084739E+03, 9.8260590508E-01],
	[4.69650E+04, 3.8979927823E+04, 5.0772519260E+03, 2.4583342996E+04, 3.7981060709E+03, 9.8261253050E-01],
	[4.69700E+04, 3.8987325353E+04, 5.0772937027E+03, 2.4591888355E+04, 3.7984035983E+03, 9.8261915290E-01],
	[4.69750E+04, 3.8994723500E+04, 5.0773354754E+03, 2.4600435773E+04, 3.7987010563E+03, 9.8262577227E-01],
	[4.69800E+04, 3.9002122263E+04, 5.0773772440E+03, 2.4608985250E+04, 3.7989984448E+03, 9.8263238863E-01],
	[4.69850E+04, 3.9009521643E+04, 5.0774190085E+03, 2.4617536787E+04, 3.7992957638E+03, 9.8263900196E-01],
	[4.69900E+04, 3.9016921638E+04, 5.0774607689E+03, 2.4626090383E+04, 3.7995930134E+03, 9.8264561228E-01],
	[4.69950E+04, 3.9024322250E+04, 5.0775025252E+03, 2.4634646038E+04, 3.7998901936E+03, 9.8265221958E-01],
	[4.70000E+04, 3.9031723478E+04, 5.0775442774E+03, 2.4643203755E+04, 3.8001873044E+03, 9.8265882386E-01],
	[4.70050E+04, 3.9039125322E+04, 5.0775860255E+03, 2.4651763531E+04, 3.8004843459E+03, 9.8266542514E-01],
	[4.70100E+04, 3.9046527782E+04, 5.0776277695E+03, 2.4660325368E+04, 3.8007813180E+03, 9.8267202340E-01],
	[4.70150E+04, 3.9053930858E+04, 5.0776695094E+03, 2.4668889267E+04, 3.8010782207E+03, 9.8267861865E-01],
	[4.70200E+04, 3.9061334551E+04, 5.0777112452E+03, 2.4677455226E+04, 3.8013750541E+03, 9.8268521089E-01],
	[4.70250E+04, 3.9068738859E+04, 5.0777529769E+03, 2.4686023248E+04, 3.8016718182E+03, 9.8269180013E-01],
	[4.70300E+04, 3.9076143784E+04, 5.0777947045E+03, 2.4694593331E+04, 3.8019685130E+03, 9.8269838636E-01],
	[4.70350E+04, 3.9083549324E+04, 5.0778364280E+03, 2.4703165476E+04, 3.8022651386E+03, 9.8270496959E-01],
	[4.70400E+04, 3.9090955481E+04, 5.0778781474E+03, 2.4711739683E+04, 3.8025616949E+03, 9.8271154982E-01],
	[4.70450E+04, 3.9098362254E+04, 5.0779198628E+03, 2.4720315954E+04, 3.8028581819E+03, 9.8271812705E-01],
	[4.70500E+04, 3.9105769642E+04, 5.0779615740E+03, 2.4728894287E+04, 3.8031545997E+03, 9.8272470128E-01],
	[4.70550E+04, 3.9113177647E+04, 5.0780032812E+03, 2.4737474683E+04, 3.8034509483E+03, 9.8273127251E-01],
	[4.70600E+04, 3.9120586268E+04, 5.0780449842E+03, 2.4746057143E+04, 3.8037472278E+03, 9.8273784075E-01],
	[4.70650E+04, 3.9127995504E+04, 5.0780866832E+03, 2.4754641667E+04, 3.8040434380E+03, 9.8274440599E-01],
	[4.70700E+04, 3.9135405357E+04, 5.0781283781E+03, 2.4763228254E+04, 3.8043395792E+03, 9.8275096824E-01],
	[4.70750E+04, 3.9142815826E+04, 5.0781700689E+03, 2.4771816906E+04, 3.8046356511E+03, 9.8275752751E-01],
	[4.70800E+04, 3.9150226910E+04, 5.0782117556E+03, 2.4780407623E+04, 3.8049316540E+03, 9.8276408378E-01],
	[4.70850E+04, 3.9157638611E+04, 5.0782534383E+03, 2.4789000405E+04, 3.8052275877E+03, 9.8277063707E-01],
	[4.70900E+04, 3.9165050927E+04, 5.0782951168E+03, 2.4797595251E+04, 3.8055234524E+03, 9.8277718737E-01],
	[4.70950E+04, 3.9172463859E+04, 5.0783367913E+03, 2.4806192164E+04, 3.8058192480E+03, 9.8278373468E-01],
	[4.71000E+04, 3.9179877407E+04, 5.0783784617E+03, 2.4814791141E+04, 3.8061149746E+03, 9.8279027902E-01],
	[4.71050E+04, 3.9187291571E+04, 5.0784201280E+03, 2.4823392185E+04, 3.8064106321E+03, 9.8279682037E-01],
	[4.71100E+04, 3.9194706351E+04, 5.0784617902E+03, 2.4831995295E+04, 3.8067062206E+03, 9.8280335875E-01],
	[4.71150E+04, 3.9202121747E+04, 5.0785034483E+03, 2.4840600472E+04, 3.8070017401E+03, 9.8280989415E-01],
	[4.71200E+04, 3.9209537758E+04, 5.0785451024E+03, 2.4849207716E+04, 3.8072971907E+03, 9.8281642657E-01],
	[4.71250E+04, 3.9216954385E+04, 5.0785867524E+03, 2.4857817026E+04, 3.8075925722E+03, 9.8282295602E-01],
	[4.71300E+04, 3.9224371628E+04, 5.0786283983E+03, 2.4866428404E+04, 3.8078878849E+03, 9.8282948249E-01],
	[4.71350E+04, 3.9231789487E+04, 5.0786700401E+03, 2.4875041850E+04, 3.8081831286E+03, 9.8283600600E-01],
	[4.71400E+04, 3.9239207962E+04, 5.0787116779E+03, 2.4883657363E+04, 3.8084783034E+03, 9.8284252653E-01],
	[4.71450E+04, 3.9246627052E+04, 5.0787533116E+03, 2.4892274945E+04, 3.8087734093E+03, 9.8284904410E-01],
	[4.71500E+04, 3.9254046758E+04, 5.0787949412E+03, 2.4900894595E+04, 3.8090684463E+03, 9.8285555870E-01],
	[4.71550E+04, 3.9261467080E+04, 5.0788365667E+03, 2.4909516314E+04, 3.8093634144E+03, 9.8286207034E-01],
	[4.71600E+04, 3.9268888018E+04, 5.0788781882E+03, 2.4918140102E+04, 3.8096583137E+03, 9.8286857902E-01],
	[4.71650E+04, 3.9276309571E+04, 5.0789198055E+03, 2.4926765959E+04, 3.8099531442E+03, 9.8287508473E-01],
	[4.71700E+04, 3.9283731740E+04, 5.0789614189E+03, 2.4935393886E+04, 3.8102479059E+03, 9.8288158748E-01],
	[4.71750E+04, 3.9291154524E+04, 5.0790030281E+03, 2.4944023883E+04, 3.8105425988E+03, 9.8288808728E-01],
	[4.71800E+04, 3.9298577924E+04, 5.0790446333E+03, 2.4952655950E+04, 3.8108372229E+03, 9.8289458412E-01],
	[4.71850E+04, 3.9306001940E+04, 5.0790862344E+03, 2.4961290087E+04, 3.8111317783E+03, 9.8290107800E-01],
	[4.71900E+04, 3.9313426572E+04, 5.0791278314E+03, 2.4969926295E+04, 3.8114262649E+03, 9.8290756893E-01],
	[4.71950E+04, 3.9320851819E+04, 5.0791694244E+03, 2.4978564574E+04, 3.8117206828E+03, 9.8291405691E-01],
	[4.72000E+04, 3.9328277681E+04, 5.0792110133E+03, 2.4987204924E+04, 3.8120150320E+03, 9.8292054194E-01],
	[4.72050E+04, 3.9335704159E+04, 5.0792525982E+03, 2.4995847346E+04, 3.8123093125E+03, 9.8292702402E-01],
	[4.72100E+04, 3.9343131253E+04, 5.0792941790E+03, 2.5004491840E+04, 3.8126035244E+03, 9.8293350316E-01],
	[4.72150E+04, 3.9350558963E+04, 5.0793357557E+03, 2.5013138405E+04, 3.8128976676E+03, 9.8293997935E-01],
	[4.72200E+04, 3.9357987287E+04, 5.0793773283E+03, 2.5021787043E+04, 3.8131917421E+03, 9.8294645259E-01],
	[4.72250E+04, 3.9365416228E+04, 5.0794188969E+03, 2.5030437754E+04, 3.8134857481E+03, 9.8295292289E-01],
	[4.72300E+04, 3.9372845784E+04, 5.0794604615E+03, 2.5039090537E+04, 3.8137796854E+03, 9.8295939026E-01],
	[4.72350E+04, 3.9380275955E+04, 5.0795020219E+03, 2.5047745394E+04, 3.8140735541E+03, 9.8296585468E-01],
	[4.72400E+04, 3.9387706742E+04, 5.0795435784E+03, 2.5056402324E+04, 3.8143673543E+03, 9.8297231617E-01],
	[4.72450E+04, 3.9395138144E+04, 5.0795851307E+03, 2.5065061328E+04, 3.8146610859E+03, 9.8297877472E-01],
	[4.72500E+04, 3.9402570162E+04, 5.0796266790E+03, 2.5073722406E+04, 3.8149547491E+03, 9.8298523033E-01],
	[4.72550E+04, 3.9410002795E+04, 5.0796682233E+03, 2.5082385558E+04, 3.8152483436E+03, 9.8299168302E-01],
	[4.72600E+04, 3.9417436044E+04, 5.0797097635E+03, 2.5091050785E+04, 3.8155418697E+03, 9.8299813277E-01],
	[4.72650E+04, 3.9424869908E+04, 5.0797512996E+03, 2.5099718086E+04, 3.8158353273E+03, 9.8300457959E-01],
	[4.72700E+04, 3.9432304387E+04, 5.0797928317E+03, 2.5108387463E+04, 3.8161287165E+03, 9.8301102349E-01],
	[4.72750E+04, 3.9439739482E+04, 5.0798343597E+03, 2.5117058915E+04, 3.8164220372E+03, 9.8301746446E-01],
	[4.72800E+04, 3.9447175192E+04, 5.0798758837E+03, 2.5125732443E+04, 3.8167152894E+03, 9.8302390250E-01],
	[4.72850E+04, 3.9454611518E+04, 5.0799174036E+03, 2.5134408046E+04, 3.8170084733E+03, 9.8303033763E-01],
	[4.72900E+04, 3.9462048459E+04, 5.0799589195E+03, 2.5143085726E+04, 3.8173015888E+03, 9.8303676983E-01],
	[4.72950E+04, 3.9469486015E+04, 5.0800004313E+03, 2.5151765483E+04, 3.8175946358E+03, 9.8304319911E-01],
	[4.73000E+04, 3.9476924186E+04, 5.0800419390E+03, 2.5160447316E+04, 3.8178876146E+03, 9.8304962547E-01],
	[4.73050E+04, 3.9484362973E+04, 5.0800834428E+03, 2.5169131226E+04, 3.8181805249E+03, 9.8305604892E-01],
	[4.73100E+04, 3.9491802375E+04, 5.0801249424E+03, 2.5177817214E+04, 3.8184733670E+03, 9.8306246944E-01],
	[4.73150E+04, 3.9499242392E+04, 5.0801664381E+03, 2.5186505279E+04, 3.8187661407E+03, 9.8306888706E-01],
	[4.73200E+04, 3.9506683025E+04, 5.0802079297E+03, 2.5195195422E+04, 3.8190588462E+03, 9.8307530176E-01],
	[4.73250E+04, 3.9514124273E+04, 5.0802494172E+03, 2.5203887643E+04, 3.8193514833E+03, 9.8308171355E-01],
	[4.73300E+04, 3.9521566136E+04, 5.0802909007E+03, 2.5212581943E+04, 3.8196440523E+03, 9.8308812243E-01],
	[4.73350E+04, 3.9529008614E+04, 5.0803323801E+03, 2.5221278321E+04, 3.8199365529E+03, 9.8309452841E-01],
	[4.73400E+04, 3.9536451708E+04, 5.0803738555E+03, 2.5229976778E+04, 3.8202289854E+03, 9.8310093147E-01],
	[4.73450E+04, 3.9543895416E+04, 5.0804153269E+03, 2.5238677315E+04, 3.8205213496E+03, 9.8310733163E-01],
	[4.73500E+04, 3.9551339740E+04, 5.0804567942E+03, 2.5247379931E+04, 3.8208136457E+03, 9.8311372889E-01],
	[4.73550E+04, 3.9558784679E+04, 5.0804982575E+03, 2.5256084627E+04, 3.8211058736E+03, 9.8312012324E-01],
	[4.73600E+04, 3.9566230233E+04, 5.0805397168E+03, 2.5264791403E+04, 3.8213980333E+03, 9.8312651469E-01],
	[4.73650E+04, 3.9573676402E+04, 5.0805811720E+03, 2.5273500260E+04, 3.8216901249E+03, 9.8313290325E-01],
	[4.73700E+04, 3.9581123187E+04, 5.0806226231E+03, 2.5282211197E+04, 3.8219821484E+03, 9.8313928890E-01],
	[4.73750E+04, 3.9588570586E+04, 5.0806640703E+03, 2.5290924215E+04, 3.8222741038E+03, 9.8314567166E-01],
	[4.73800E+04, 3.9596018601E+04, 5.0807055134E+03, 2.5299639314E+04, 3.8225659910E+03, 9.8315205152E-01],
	[4.73850E+04, 3.9603467230E+04, 5.0807469524E+03, 2.5308356495E+04, 3.8228578103E+03, 9.8315842849E-01],
	[4.73900E+04, 3.9610916475E+04, 5.0807883875E+03, 2.5317075758E+04, 3.8231495614E+03, 9.8316480257E-01],
	[4.73950E+04, 3.9618366334E+04, 5.0808298184E+03, 2.5325797102E+04, 3.8234412445E+03, 9.8317117376E-01],
	[4.74000E+04, 3.9625816809E+04, 5.0808712454E+03, 2.5334520529E+04, 3.8237328596E+03, 9.8317754205E-01],
	[4.74050E+04, 3.9633267899E+04, 5.0809126683E+03, 2.5343246038E+04, 3.8240244068E+03, 9.8318390746E-01],
	[4.74100E+04, 3.9640719604E+04, 5.0809540872E+03, 2.5351973631E+04, 3.8243158859E+03, 9.8319026999E-01],
	[4.74150E+04, 3.9648171923E+04, 5.0809955021E+03, 2.5360703306E+04, 3.8246072970E+03, 9.8319662962E-01],
	[4.74200E+04, 3.9655624858E+04, 5.0810369129E+03, 2.5369435065E+04, 3.8248986402E+03, 9.8320298638E-01],
	[4.74250E+04, 3.9663078408E+04, 5.0810783197E+03, 2.5378168908E+04, 3.8251899155E+03, 9.8320934025E-01],
	[4.74300E+04, 3.9670532572E+04, 5.0811197225E+03, 2.5386904834E+04, 3.8254811229E+03, 9.8321569124E-01],
	[4.74350E+04, 3.9677987352E+04, 5.0811611213E+03, 2.5395642845E+04, 3.8257722624E+03, 9.8322203936E-01],
	[4.74400E+04, 3.9685442746E+04, 5.0812025160E+03, 2.5404382940E+04, 3.8260633339E+03, 9.8322838459E-01],
	[4.74450E+04, 3.9692898755E+04, 5.0812439067E+03, 2.5413125120E+04, 3.8263543377E+03, 9.8323472695E-01],
	[4.74500E+04, 3.9700355379E+04, 5.0812852934E+03, 2.5421869386E+04, 3.8266452735E+03, 9.8324106644E-01],
	[4.74550E+04, 3.9707812618E+04, 5.0813266760E+03, 2.5430615736E+04, 3.8269361416E+03, 9.8324740305E-01],
	[4.74600E+04, 3.9715270472E+04, 5.0813680547E+03, 2.5439364172E+04, 3.8272269418E+03, 9.8325373679E-01],
	[4.74650E+04, 3.9722728941E+04, 5.0814094293E+03, 2.5448114694E+04, 3.8275176742E+03, 9.8326006766E-01],
	[4.74700E+04, 3.9730188025E+04, 5.0814507999E+03, 2.5456867303E+04, 3.8278083389E+03, 9.8326639566E-01],
	[4.74750E+04, 3.9737647723E+04, 5.0814921664E+03, 2.5465621998E+04, 3.8280989358E+03, 9.8327272079E-01],
	[4.74800E+04, 3.9745108036E+04, 5.0815335290E+03, 2.5474378779E+04, 3.8283894649E+03, 9.8327904306E-01],
	[4.74850E+04, 3.9752568964E+04, 5.0815748875E+03, 2.5483137648E+04, 3.8286799264E+03, 9.8328536246E-01],
	[4.74900E+04, 3.9760030507E+04, 5.0816162420E+03, 2.5491898604E+04, 3.8289703201E+03, 9.8329167900E-01],
	[4.74950E+04, 3.9767492665E+04, 5.0816575925E+03, 2.5500661647E+04, 3.8292606461E+03, 9.8329799268E-01],
	[4.75000E+04, 3.9774955437E+04, 5.0816989390E+03, 2.5509426778E+04, 3.8295509044E+03, 9.8330430350E-01],
	[4.75050E+04, 3.9782418824E+04, 5.0817402814E+03, 2.5518193998E+04, 3.8298410951E+03, 9.8331061146E-01],
	[4.75100E+04, 3.9789882825E+04, 5.0817816199E+03, 2.5526963305E+04, 3.8301312182E+03, 9.8331691656E-01],
	[4.75150E+04, 3.9797347442E+04, 5.0818229543E+03, 2.5535734702E+04, 3.8304212736E+03, 9.8332321881E-01],
	[4.75200E+04, 3.9804812673E+04, 5.0818642847E+03, 2.5544508187E+04, 3.8307112614E+03, 9.8332951820E-01],
	[4.75250E+04, 3.9812278519E+04, 5.0819056111E+03, 2.5553283762E+04, 3.8310011816E+03, 9.8333581474E-01],
	[4.75300E+04, 3.9819744979E+04, 5.0819469335E+03, 2.5562061426E+04, 3.8312910343E+03, 9.8334210843E-01],
	[4.75350E+04, 3.9827212054E+04, 5.0819882519E+03, 2.5570841180E+04, 3.8315808194E+03, 9.8334839927E-01],
	[4.75400E+04, 3.9834679744E+04, 5.0820295663E+03, 2.5579623024E+04, 3.8318705369E+03, 9.8335468726E-01],
	[4.75450E+04, 3.9842148048E+04, 5.0820708766E+03, 2.5588406959E+04, 3.8321601870E+03, 9.8336097241E-01],
	[4.75500E+04, 3.9849616967E+04, 5.0821121830E+03, 2.5597192984E+04, 3.8324497695E+03, 9.8336725470E-01],
	[4.75550E+04, 3.9857086501E+04, 5.0821534853E+03, 2.5605981100E+04, 3.8327392845E+03, 9.8337353416E-01],
	[4.75600E+04, 3.9864556649E+04, 5.0821947837E+03, 2.5614771307E+04, 3.8330287321E+03, 9.8337981077E-01],
	[4.75650E+04, 3.9872027411E+04, 5.0822360780E+03, 2.5623563605E+04, 3.8333181122E+03, 9.8338608454E-01],
	[4.75700E+04, 3.9879498789E+04, 5.0822773683E+03, 2.5632357996E+04, 3.8336074249E+03, 9.8339235547E-01],
	[4.75750E+04, 3.9886970780E+04, 5.0823186547E+03, 2.5641154478E+04, 3.8338966701E+03, 9.8339862356E-01],
	[4.75800E+04, 3.9894443386E+04, 5.0823599370E+03, 2.5649953053E+04, 3.8341858480E+03, 9.8340488882E-01],
	[4.75850E+04, 3.9901916607E+04, 5.0824012153E+03, 2.5658753720E+04, 3.8344749585E+03, 9.8341115124E-01],
	[4.75900E+04, 3.9909390442E+04, 5.0824424896E+03, 2.5667556480E+04, 3.8347640016E+03, 9.8341741082E-01],
	[4.75950E+04, 3.9916864892E+04, 5.0824837599E+03, 2.5676361333E+04, 3.8350529773E+03, 9.8342366758E-01],
	[4.76000E+04, 3.9924339956E+04, 5.0825250263E+03, 2.5685168280E+04, 3.8353418857E+03, 9.8342992150E-01],
	[4.76050E+04, 3.9931815635E+04, 5.0825662886E+03, 2.5693977320E+04, 3.8356307268E+03, 9.8343617259E-01],
	[4.76100E+04, 3.9939291928E+04, 5.0826075469E+03, 2.5702788454E+04, 3.8359195006E+03, 9.8344242086E-01],
	[4.76150E+04, 3.9946768836E+04, 5.0826488012E+03, 2.5711601682E+04, 3.8362082071E+03, 9.8344866629E-01],
	[4.76200E+04, 3.9954246357E+04, 5.0826900515E+03, 2.5720417005E+04, 3.8364968464E+03, 9.8345490891E-01],
	[4.76250E+04, 3.9961724494E+04, 5.0827312979E+03, 2.5729234423E+04, 3.8367854184E+03, 9.8346114870E-01],
	[4.76300E+04, 3.9969203244E+04, 5.0827725402E+03, 2.5738053935E+04, 3.8370739231E+03, 9.8346738566E-01],
	[4.76350E+04, 3.9976682609E+04, 5.0828137785E+03, 2.5746875543E+04, 3.8373623607E+03, 9.8347361981E-01],
	[4.76400E+04, 3.9984162589E+04, 5.0828550129E+03, 2.5755699247E+04, 3.8376507310E+03, 9.8347985113E-01],
	[4.76450E+04, 3.9991643182E+04, 5.0828962432E+03, 2.5764525047E+04, 3.8379390342E+03, 9.8348607964E-01],
	[4.76500E+04, 3.9999124390E+04, 5.0829374696E+03, 2.5773352942E+04, 3.8382272702E+03, 9.8349230533E-01],
	[4.76550E+04, 4.0006606213E+04, 5.0829786919E+03, 2.5782182935E+04, 3.8385154391E+03, 9.8349852821E-01],
	[4.76600E+04, 4.0014088649E+04, 5.0830199103E+03, 2.5791015023E+04, 3.8388035408E+03, 9.8350474827E-01],
	[4.76650E+04, 4.0021571700E+04, 5.0830611247E+03, 2.5799849209E+04, 3.8390915754E+03, 9.8351096552E-01],
	[4.76700E+04, 4.0029055366E+04, 5.0831023351E+03, 2.5808685492E+04, 3.8393795429E+03, 9.8351717996E-01],
	[4.76750E+04, 4.0036539645E+04, 5.0831435415E+03, 2.5817523873E+04, 3.8396674434E+03, 9.8352339159E-01],
	[4.76800E+04, 4.0044024539E+04, 5.0831847439E+03, 2.5826364352E+04, 3.8399552768E+03, 9.8352960041E-01],
	[4.76850E+04, 4.0051510047E+04, 5.0832259424E+03, 2.5835206928E+04, 3.8402430431E+03, 9.8353580643E-01],
	[4.76900E+04, 4.0058996169E+04, 5.0832671368E+03, 2.5844051603E+04, 3.8405307424E+03, 9.8354200964E-01],
	[4.76950E+04, 4.0066482905E+04, 5.0833083273E+03, 2.5852898377E+04, 3.8408183747E+03, 9.8354821005E-01],
	[4.77000E+04, 4.0073970256E+04, 5.0833495138E+03, 2.5861747250E+04, 3.8411059400E+03, 9.8355440765E-01],
	[4.77050E+04, 4.0081458220E+04, 5.0833906963E+03, 2.5870598222E+04, 3.8413934383E+03, 9.8356060246E-01],
	[4.77100E+04, 4.0088946799E+04, 5.0834318748E+03, 2.5879451293E+04, 3.8416808697E+03, 9.8356679446E-01],
	[4.77150E+04, 4.0096435992E+04, 5.0834730493E+03, 2.5888306464E+04, 3.8419682341E+03, 9.8357298367E-01],
	[4.77200E+04, 4.0103925799E+04, 5.0835142199E+03, 2.5897163735E+04, 3.8422555316E+03, 9.8357917008E-01],
	[4.77250E+04, 4.0111416220E+04, 5.0835553864E+03, 2.5906023107E+04, 3.8425427621E+03, 9.8358535369E-01],
	[4.77300E+04, 4.0118907255E+04, 5.0835965490E+03, 2.5914884579E+04, 3.8428299258E+03, 9.8359153451E-01],
	[4.77350E+04, 4.0126398905E+04, 5.0836377076E+03, 2.5923748152E+04, 3.8431170226E+03, 9.8359771254E-01],
	[4.77400E+04, 4.0133891168E+04, 5.0836788623E+03, 2.5932613826E+04, 3.8434040526E+03, 9.8360388778E-01],
	[4.77450E+04, 4.0141384046E+04, 5.0837200129E+03, 2.5941481601E+04, 3.8436910157E+03, 9.8361006023E-01],
	[4.77500E+04, 4.0148877537E+04, 5.0837611596E+03, 2.5950351479E+04, 3.8439779120E+03, 9.8361622989E-01],
	[4.77550E+04, 4.0156371643E+04, 5.0838023023E+03, 2.5959223458E+04, 3.8442647415E+03, 9.8362239676E-01],
	[4.77600E+04, 4.0163866363E+04, 5.0838434410E+03, 2.5968097540E+04, 3.8445515042E+03, 9.8362856085E-01],
	[4.77650E+04, 4.0171361696E+04, 5.0838845758E+03, 2.5976973724E+04, 3.8448382001E+03, 9.8363472216E-01],
	[4.77700E+04, 4.0178857644E+04, 5.0839257066E+03, 2.5985852011E+04, 3.8451248292E+03, 9.8364088068E-01],
	[4.77750E+04, 4.0186354205E+04, 5.0839668334E+03, 2.5994732401E+04, 3.8454113917E+03, 9.8364703643E-01],
	[4.77800E+04, 4.0193851381E+04, 5.0840079562E+03, 2.6003614894E+04, 3.8456978874E+03, 9.8365318939E-01],
	[4.77850E+04, 4.0201349170E+04, 5.0840490751E+03, 2.6012499491E+04, 3.8459843164E+03, 9.8365933958E-01],
	[4.77900E+04, 4.0208847574E+04, 5.0840901900E+03, 2.6021386192E+04, 3.8462706787E+03, 9.8366548699E-01],
	[4.77950E+04, 4.0216346591E+04, 5.0841313009E+03, 2.6030274997E+04, 3.8465569743E+03, 9.8367163162E-01],
	[4.78000E+04, 4.0223846222E+04, 5.0841724079E+03, 2.6039165907E+04, 3.8468432033E+03, 9.8367777348E-01],
	[4.78050E+04, 4.0231346467E+04, 5.0842135109E+03, 2.6048058921E+04, 3.8471293656E+03, 9.8368391257E-01],
	[4.78100E+04, 4.0238847326E+04, 5.0842546099E+03, 2.6056954041E+04, 3.8474154613E+03, 9.8369004889E-01],
	[4.78150E+04, 4.0246348799E+04, 5.0842957050E+03, 2.6065851266E+04, 3.8477014904E+03, 9.8369618244E-01],
	[4.78200E+04, 4.0253850886E+04, 5.0843367961E+03, 2.6074750596E+04, 3.8479874530E+03, 9.8370231322E-01],
	[4.78250E+04, 4.0261353586E+04, 5.0843778832E+03, 2.6083652032E+04, 3.8482733489E+03, 9.8370844123E-01],
	[4.78300E+04, 4.0268856900E+04, 5.0844189664E+03, 2.6092555575E+04, 3.8485591783E+03, 9.8371456648E-01],
	[4.78350E+04, 4.0276360829E+04, 5.0844600456E+03, 2.6101461224E+04, 3.8488449412E+03, 9.8372068896E-01],
	[4.78400E+04, 4.0283865370E+04, 5.0845011209E+03, 2.6110368979E+04, 3.8491306375E+03, 9.8372680869E-01],
	[4.78450E+04, 4.0291370526E+04, 5.0845421922E+03, 2.6119278842E+04, 3.8494162674E+03, 9.8373292565E-01],
	[4.78500E+04, 4.0298876296E+04, 5.0845832595E+03, 2.6128190812E+04, 3.8497018307E+03, 9.8373903985E-01],
	[4.78550E+04, 4.0306382679E+04, 5.0846243228E+03, 2.6137104889E+04, 3.8499873276E+03, 9.8374515130E-01],
	[4.78600E+04, 4.0313889676E+04, 5.0846653823E+03, 2.6146021074E+04, 3.8502727581E+03, 9.8375125998E-01],
	[4.78650E+04, 4.0321397286E+04, 5.0847064377E+03, 2.6154939368E+04, 3.8505581221E+03, 9.8375736592E-01],
	[4.78700E+04, 4.0328905511E+04, 5.0847474892E+03, 2.6163859769E+04, 3.8508434197E+03, 9.8376346910E-01],
	[4.78750E+04, 4.0336414349E+04, 5.0847885367E+03, 2.6172782280E+04, 3.8511286509E+03, 9.8376956952E-01],
	[4.78800E+04, 4.0343923801E+04, 5.0848295803E+03, 2.6181706899E+04, 3.8514138157E+03, 9.8377566720E-01],
	[4.78850E+04, 4.0351433866E+04, 5.0848706200E+03, 2.6190633627E+04, 3.8516989141E+03, 9.8378176213E-01],
	[4.78900E+04, 4.0358944545E+04, 5.0849116556E+03, 2.6199562465E+04, 3.8519839462E+03, 9.8378785431E-01],
	[4.78950E+04, 4.0366455838E+04, 5.0849526873E+03, 2.6208493413E+04, 3.8522689119E+03, 9.8379394374E-01],
	[4.79000E+04, 4.0373967744E+04, 5.0849937151E+03, 2.6217426471E+04, 3.8525538114E+03, 9.8380003042E-01],
	[4.79050E+04, 4.0381480264E+04, 5.0850347389E+03, 2.6226361639E+04, 3.8528386445E+03, 9.8380611437E-01],
	[4.79100E+04, 4.0388993398E+04, 5.0850757588E+03, 2.6235298917E+04, 3.8531234113E+03, 9.8381219557E-01],
	[4.79150E+04, 4.0396507145E+04, 5.0851167747E+03, 2.6244238307E+04, 3.8534081119E+03, 9.8381827403E-01],
	[4.79200E+04, 4.0404021505E+04, 5.0851577867E+03, 2.6253179807E+04, 3.8536927463E+03, 9.8382434975E-01],
	[4.79250E+04, 4.0411536480E+04, 5.0851987947E+03, 2.6262123420E+04, 3.8539773144E+03, 9.8383042273E-01],
	[4.79300E+04, 4.0419052067E+04, 5.0852397988E+03, 2.6271069143E+04, 3.8542618163E+03, 9.8383649297E-01],
	[4.79350E+04, 4.0426568269E+04, 5.0852807989E+03, 2.6280016979E+04, 3.8545462520E+03, 9.8384256048E-01],
	[4.79400E+04, 4.0434085084E+04, 5.0853217951E+03, 2.6288966927E+04, 3.8548306215E+03, 9.8384862526E-01],
	[4.79450E+04, 4.0441602512E+04, 5.0853627873E+03, 2.6297918988E+04, 3.8551149248E+03, 9.8385468730E-01],
	[4.79500E+04, 4.0449120554E+04, 5.0854037756E+03, 2.6306873161E+04, 3.8553991620E+03, 9.8386074661E-01],
	[4.79550E+04, 4.0456639209E+04, 5.0854447600E+03, 2.6315829448E+04, 3.8556833331E+03, 9.8386680320E-01],
	[4.79600E+04, 4.0464158478E+04, 5.0854857404E+03, 2.6324787847E+04, 3.8559674380E+03, 9.8387285705E-01],
	[4.79650E+04, 4.0471678360E+04, 5.0855267168E+03, 2.6333748361E+04, 3.8562514769E+03, 9.8387890818E-01],
	[4.79700E+04, 4.0479198855E+04, 5.0855676893E+03, 2.6342710988E+04, 3.8565354497E+03, 9.8388495658E-01],
	[4.79750E+04, 4.0486719964E+04, 5.0856086579E+03, 2.6351675730E+04, 3.8568193564E+03, 9.8389100226E-01],
	[4.79800E+04, 4.0494241687E+04, 5.0856496226E+03, 2.6360642586E+04, 3.8571031970E+03, 9.8389704521E-01],
	[4.79850E+04, 4.0501764023E+04, 5.0856905833E+03, 2.6369611557E+04, 3.8573869717E+03, 9.8390308544E-01],
	[4.79900E+04, 4.0509286972E+04, 5.0857315400E+03, 2.6378582643E+04, 3.8576706803E+03, 9.8390912296E-01],
	[4.79950E+04, 4.0516810534E+04, 5.0857724929E+03, 2.6387555844E+04, 3.8579543229E+03, 9.8391515775E-01],
	[4.80000E+04, 4.0524334710E+04, 5.0858134417E+03, 2.6396531161E+04, 3.8582378996E+03, 9.8392118983E-01],
	[4.80050E+04, 4.0531859499E+04, 5.0858543867E+03, 2.6405508594E+04, 3.8585214103E+03, 9.8392721919E-01],
	[4.80100E+04, 4.0539384902E+04, 5.0858953277E+03, 2.6414488143E+04, 3.8588048550E+03, 9.8393324584E-01],
	[4.80150E+04, 4.0546910918E+04, 5.0859362648E+03, 2.6423469808E+04, 3.8590882338E+03, 9.8393926978E-01],
	[4.80200E+04, 4.0554437547E+04, 5.0859771980E+03, 2.6432453590E+04, 3.8593715467E+03, 9.8394529100E-01],
	[4.80250E+04, 4.0561964789E+04, 5.0860181272E+03, 2.6441439489E+04, 3.8596547938E+03, 9.8395130952E-01],
	[4.80300E+04, 4.0569492645E+04, 5.0860590525E+03, 2.6450427505E+04, 3.8599379749E+03, 9.8395732532E-01],
	[4.80350E+04, 4.0577021114E+04, 5.0860999738E+03, 2.6459417639E+04, 3.8602210902E+03, 9.8396333842E-01],
	[4.80400E+04, 4.0584550196E+04, 5.0861408912E+03, 2.6468409890E+04, 3.8605041396E+03, 9.8396934881E-01],
	[4.80450E+04, 4.0592079891E+04, 5.0861818047E+03, 2.6477404260E+04, 3.8607871232E+03, 9.8397535650E-01],
	[4.80500E+04, 4.0599610200E+04, 5.0862227143E+03, 2.6486400748E+04, 3.8610700410E+03, 9.8398136148E-01],
	[4.80550E+04, 4.0607141122E+04, 5.0862636200E+03, 2.6495399355E+04, 3.8613528930E+03, 9.8398736377E-01],
	[4.80600E+04, 4.0614672657E+04, 5.0863045217E+03, 2.6504400080E+04, 3.8616356792E+03, 9.8399336335E-01],
	[4.80650E+04, 4.0622204805E+04, 5.0863454195E+03, 2.6513402925E+04, 3.8619183996E+03, 9.8399936023E-01],
	[4.80700E+04, 4.0629737566E+04, 5.0863863133E+03, 2.6522407890E+04, 3.8622010544E+03, 9.8400535442E-01],
	[4.80750E+04, 4.0637270940E+04, 5.0864272033E+03, 2.6531414974E+04, 3.8624836433E+03, 9.8401134591E-01],
	[4.80800E+04, 4.0644804928E+04, 5.0864680893E+03, 2.6540424178E+04, 3.8627661666E+03, 9.8401733470E-01],
	[4.80850E+04, 4.0652339529E+04, 5.0865089714E+03, 2.6549435502E+04, 3.8630486242E+03, 9.8402332081E-01],
	[4.80900E+04, 4.0659874742E+04, 5.0865498495E+03, 2.6558448947E+04, 3.8633310161E+03, 9.8402930422E-01],
	[4.80950E+04, 4.0667410569E+04, 5.0865907238E+03, 2.6567464513E+04, 3.8636133424E+03, 9.8403528494E-01],
	[4.81000E+04, 4.0674947009E+04, 5.0866315941E+03, 2.6576482200E+04, 3.8638956030E+03, 9.8404126297E-01],
	[4.81050E+04, 4.0682484062E+04, 5.0866724605E+03, 2.6585502009E+04, 3.8641777980E+03, 9.8404723831E-01],
	[4.81100E+04, 4.0690021728E+04, 5.0867133230E+03, 2.6594523939E+04, 3.8644599273E+03, 9.8405321097E-01],
	[4.81150E+04, 4.0697560007E+04, 5.0867541816E+03, 2.6603547991E+04, 3.8647419911E+03, 9.8405918094E-01],
	[4.81200E+04, 4.0705098899E+04, 5.0867950362E+03, 2.6612574165E+04, 3.8650239893E+03, 9.8406514823E-01],
	[4.81250E+04, 4.0712638404E+04, 5.0868358870E+03, 2.6621602462E+04, 3.8653059220E+03, 9.8407111283E-01],
	[4.81300E+04, 4.0720178522E+04, 5.0868767338E+03, 2.6630632882E+04, 3.8655877891E+03, 9.8407707476E-01],
	[4.81350E+04, 4.0727719253E+04, 5.0869175767E+03, 2.6639665425E+04, 3.8658695907E+03, 9.8408303401E-01],
	[4.81400E+04, 4.0735260597E+04, 5.0869584157E+03, 2.6648700091E+04, 3.8661513267E+03, 9.8408899057E-01],
	[4.81450E+04, 4.0742802553E+04, 5.0869992508E+03, 2.6657736881E+04, 3.8664329973E+03, 9.8409494446E-01],
	[4.81500E+04, 4.0750345123E+04, 5.0870400819E+03, 2.6666775795E+04, 3.8667146024E+03, 9.8410089568E-01],
	[4.81550E+04, 4.0757888306E+04, 5.0870809092E+03, 2.6675816833E+04, 3.8669961421E+03, 9.8410684422E-01],
	[4.81600E+04, 4.0765432102E+04, 5.0871217325E+03, 2.6684859995E+04, 3.8672776163E+03, 9.8411279009E-01],
	[4.81650E+04, 4.0772976510E+04, 5.0871625519E+03, 2.6693905283E+04, 3.8675590251E+03, 9.8411873329E-01],
	[4.81700E+04, 4.0780521531E+04, 5.0872033675E+03, 2.6702952695E+04, 3.8678403685E+03, 9.8412467382E-01],
	[4.81750E+04, 4.0788067166E+04, 5.0872441791E+03, 2.6712002233E+04, 3.8681216465E+03, 9.8413061168E-01],
	[4.81800E+04, 4.0795613413E+04, 5.0872849868E+03, 2.6721053896E+04, 3.8684028591E+03, 9.8413654688E-01],
	[4.81850E+04, 4.0803160273E+04, 5.0873257906E+03, 2.6730107685E+04, 3.8686840063E+03, 9.8414247940E-01],
	[4.81900E+04, 4.0810707745E+04, 5.0873665904E+03, 2.6739163600E+04, 3.8689650882E+03, 9.8414840927E-01],
	[4.81950E+04, 4.0818255831E+04, 5.0874073864E+03, 2.6748221642E+04, 3.8692461048E+03, 9.8415433647E-01],
	[4.82000E+04, 4.0825804529E+04, 5.0874481785E+03, 2.6757281811E+04, 3.8695270561E+03, 9.8416026101E-01],
	[4.82050E+04, 4.0833353840E+04, 5.0874889667E+03, 2.6766344106E+04, 3.8698079421E+03, 9.8416618289E-01],
	[4.82100E+04, 4.0840903764E+04, 5.0875297510E+03, 2.6775408529E+04, 3.8700887628E+03, 9.8417210211E-01],
	[4.82150E+04, 4.0848454301E+04, 5.0875705313E+03, 2.6784475079E+04, 3.8703695183E+03, 9.8417801868E-01],
	[4.82200E+04, 4.0856005450E+04, 5.0876113078E+03, 2.6793543757E+04, 3.8706502085E+03, 9.8418393258E-01],
	[4.82250E+04, 4.0863557212E+04, 5.0876520803E+03, 2.6802614563E+04, 3.8709308335E+03, 9.8418984384E-01],
	[4.82300E+04, 4.0871109587E+04, 5.0876928490E+03, 2.6811687498E+04, 3.8712113933E+03, 9.8419575244E-01],
	[4.82350E+04, 4.0878662574E+04, 5.0877336138E+03, 2.6820762561E+04, 3.8714918880E+03, 9.8420165839E-01],
	[4.82400E+04, 4.0886216175E+04, 5.0877743746E+03, 2.6829839753E+04, 3.8717723174E+03, 9.8420756169E-01],
	[4.82450E+04, 4.0893770387E+04, 5.0878151316E+03, 2.6838919074E+04, 3.8720526817E+03, 9.8421346234E-01],
	[4.82500E+04, 4.0901325213E+04, 5.0878558847E+03, 2.6848000525E+04, 3.8723329808E+03, 9.8421936034E-01],
	[4.82550E+04, 4.0908880651E+04, 5.0878966338E+03, 2.6857084106E+04, 3.8726132148E+03, 9.8422525569E-01],
	[4.82600E+04, 4.0916436702E+04, 5.0879373791E+03, 2.6866169816E+04, 3.8728933837E+03, 9.8423114841E-01],
	[4.82650E+04, 4.0923993365E+04, 5.0879781205E+03, 2.6875257657E+04, 3.8731734876E+03, 9.8423703847E-01],
	[4.82700E+04, 4.0931550641E+04, 5.0880188580E+03, 2.6884347629E+04, 3.8734535263E+03, 9.8424292590E-01],
	[4.82750E+04, 4.0939108530E+04, 5.0880595916E+03, 2.6893439731E+04, 3.8737335000E+03, 9.8424881068E-01],
	[4.82800E+04, 4.0946667031E+04, 5.0881003213E+03, 2.6902533965E+04, 3.8740134087E+03, 9.8425469283E-01],
	[4.82850E+04, 4.0954226144E+04, 5.0881410471E+03, 2.6911630330E+04, 3.8742932523E+03, 9.8426057234E-01],
	[4.82900E+04, 4.0961785870E+04, 5.0881817690E+03, 2.6920728827E+04, 3.8745730309E+03, 9.8426644921E-01],
	[4.82950E+04, 4.0969346209E+04, 5.0882224870E+03, 2.6929829455E+04, 3.8748527446E+03, 9.8427232344E-01],
	[4.83000E+04, 4.0976907160E+04, 5.0882632012E+03, 2.6938932217E+04, 3.8751323932E+03, 9.8427819504E-01],
	[4.83050E+04, 4.0984468724E+04, 5.0883039114E+03, 2.6948037110E+04, 3.8754119770E+03, 9.8428406401E-01],
	[4.83100E+04, 4.0992030900E+04, 5.0883446178E+03, 2.6957144137E+04, 3.8756914957E+03, 9.8428993035E-01],
	[4.83150E+04, 4.0999593689E+04, 5.0883853203E+03, 2.6966253296E+04, 3.8759709496E+03, 9.8429579406E-01],
	[4.83200E+04, 4.1007157090E+04, 5.0884260189E+03, 2.6975364589E+04, 3.8762503385E+03, 9.8430165514E-01],
	[4.83250E+04, 4.1014721104E+04, 5.0884667136E+03, 2.6984478016E+04, 3.8765296626E+03, 9.8430751359E-01],
	[4.83300E+04, 4.1022285730E+04, 5.0885074044E+03, 2.6993593576E+04, 3.8768089218E+03, 9.8431336942E-01],
	[4.83350E+04, 4.1029850968E+04, 5.0885480913E+03, 2.7002711271E+04, 3.8770881161E+03, 9.8431922262E-01],
	[4.83400E+04, 4.1037416819E+04, 5.0885887744E+03, 2.7011831100E+04, 3.8773672456E+03, 9.8432507320E-01],
	[4.83450E+04, 4.1044983282E+04, 5.0886294535E+03, 2.7020953064E+04, 3.8776463103E+03, 9.8433092116E-01],
	[4.83500E+04, 4.1052550358E+04, 5.0886701288E+03, 2.7030077163E+04, 3.8779253101E+03, 9.8433676650E-01],
	[4.83550E+04, 4.1060118046E+04, 5.0887108002E+03, 2.7039203398E+04, 3.8782042452E+03, 9.8434260922E-01],
	[4.83600E+04, 4.1067686346E+04, 5.0887514678E+03, 2.7048331768E+04, 3.8784831155E+03, 9.8434844932E-01],
	[4.83650E+04, 4.1075255259E+04, 5.0887921314E+03, 2.7057462273E+04, 3.8787619210E+03, 9.8435428680E-01],
	[4.83700E+04, 4.1082824784E+04, 5.0888327912E+03, 2.7066594916E+04, 3.8790406619E+03, 9.8436012167E-01],
	[4.83750E+04, 4.1090394921E+04, 5.0888734471E+03, 2.7075729694E+04, 3.8793193379E+03, 9.8436595393E-01],
	[4.83800E+04, 4.1097965671E+04, 5.0889140991E+03, 2.7084866609E+04, 3.8795979493E+03, 9.8437178358E-01],
	[4.83850E+04, 4.1105537033E+04, 5.0889547472E+03, 2.7094005662E+04, 3.8798764960E+03, 9.8437761061E-01],
	[4.83900E+04, 4.1113109007E+04, 5.0889953915E+03, 2.7103146851E+04, 3.8801549780E+03, 9.8438343504E-01],
	[4.83950E+04, 4.1120681593E+04, 5.0890360318E+03, 2.7112290178E+04, 3.8804333954E+03, 9.8438925686E-01],
	[4.84000E+04, 4.1128254792E+04, 5.0890766684E+03, 2.7121435643E+04, 3.8807117481E+03, 9.8439507607E-01],
	[4.84050E+04, 4.1135828603E+04, 5.0891173010E+03, 2.7130583246E+04, 3.8809900363E+03, 9.8440089267E-01],
	[4.84100E+04, 4.1143403026E+04, 5.0891579298E+03, 2.7139732988E+04, 3.8812682598E+03, 9.8440670667E-01],
	[4.84150E+04, 4.1150978061E+04, 5.0891985547E+03, 2.7148884868E+04, 3.8815464187E+03, 9.8441251807E-01],
	[4.84200E+04, 4.1158553709E+04, 5.0892391757E+03, 2.7158038887E+04, 3.8818245130E+03, 9.8441832687E-01],
	[4.84250E+04, 4.1166129968E+04, 5.0892797928E+03, 2.7167195045E+04, 3.8821025428E+03, 9.8442413307E-01],
	[4.84300E+04, 4.1173706840E+04, 5.0893204061E+03, 2.7176353343E+04, 3.8823805080E+03, 9.8442993667E-01],
	[4.84350E+04, 4.1181284324E+04, 5.0893610155E+03, 2.7185513781E+04, 3.8826584088E+03, 9.8443573767E-01],
	[4.84400E+04, 4.1188862420E+04, 5.0894016211E+03, 2.7194676358E+04, 3.8829362450E+03, 9.8444153608E-01],
	[4.84450E+04, 4.1196441128E+04, 5.0894422227E+03, 2.7203841076E+04, 3.8832140167E+03, 9.8444733189E-01],
	[4.84500E+04, 4.1204020449E+04, 5.0894828206E+03, 2.7213007935E+04, 3.8834917240E+03, 9.8445312511E-01],
	[4.84550E+04, 4.1211600381E+04, 5.0895234145E+03, 2.7222176935E+04, 3.8837693668E+03, 9.8445891574E-01],
	[4.84600E+04, 4.1219180925E+04, 5.0895640046E+03, 2.7231348075E+04, 3.8840469451E+03, 9.8446470377E-01],
	[4.84650E+04, 4.1226762082E+04, 5.0896045908E+03, 2.7240521357E+04, 3.8843244591E+03, 9.8447048922E-01],
	[4.84700E+04, 4.1234343850E+04, 5.0896451732E+03, 2.7249696781E+04, 3.8846019086E+03, 9.8447627208E-01],
	[4.84750E+04, 4.1241926231E+04, 5.0896857516E+03, 2.7258874347E+04, 3.8848792938E+03, 9.8448205236E-01],
	[4.84800E+04, 4.1249509224E+04, 5.0897263263E+03, 2.7268054056E+04, 3.8851566145E+03, 9.8448783005E-01],
	[4.84850E+04, 4.1257092828E+04, 5.0897668970E+03, 2.7277235906E+04, 3.8854338710E+03, 9.8449360515E-01],
	[4.84900E+04, 4.1264677045E+04, 5.0898074640E+03, 2.7286419900E+04, 3.8857110630E+03, 9.8449937768E-01],
	[4.84950E+04, 4.1272261873E+04, 5.0898480270E+03, 2.7295606037E+04, 3.8859881908E+03, 9.8450514762E-01],
	[4.85000E+04, 4.1279847314E+04, 5.0898885862E+03, 2.7304794317E+04, 3.8862652543E+03, 9.8451091498E-01],
	[4.85050E+04, 4.1287433366E+04, 5.0899291415E+03, 2.7313984741E+04, 3.8865422534E+03, 9.8451667977E-01],
	[4.85100E+04, 4.1295020031E+04, 5.0899696930E+03, 2.7323177309E+04, 3.8868191883E+03, 9.8452244197E-01],
	[4.85150E+04, 4.1302607307E+04, 5.0900102406E+03, 2.7332372021E+04, 3.8870960589E+03, 9.8452820161E-01],
	[4.85200E+04, 4.1310195195E+04, 5.0900507844E+03, 2.7341568877E+04, 3.8873728653E+03, 9.8453395866E-01],
	[4.85250E+04, 4.1317783696E+04, 5.0900913243E+03, 2.7350767879E+04, 3.8876496075E+03, 9.8453971315E-01],
	[4.85300E+04, 4.1325372808E+04, 5.0901318603E+03, 2.7359969025E+04, 3.8879262855E+03, 9.8454546506E-01],
	[4.85350E+04, 4.1332962532E+04, 5.0901723925E+03, 2.7369172317E+04, 3.8882028992E+03, 9.8455121441E-01],
	[4.85400E+04, 4.1340552867E+04, 5.0902129209E+03, 2.7378377755E+04, 3.8884794488E+03, 9.8455696118E-01],
	[4.85450E+04, 4.1348143815E+04, 5.0902534454E+03, 2.7387585338E+04, 3.8887559343E+03, 9.8456270539E-01],
	[4.85500E+04, 4.1355735374E+04, 5.0902939660E+03, 2.7396795068E+04, 3.8890323556E+03, 9.8456844703E-01],
	[4.85550E+04, 4.1363327546E+04, 5.0903344828E+03, 2.7406006944E+04, 3.8893087128E+03, 9.8457418611E-01],
	[4.85600E+04, 4.1370920329E+04, 5.0903749958E+03, 2.7415220967E+04, 3.8895850058E+03, 9.8457992262E-01],
	[4.85650E+04, 4.1378513723E+04, 5.0904155049E+03, 2.7424437136E+04, 3.8898612348E+03, 9.8458565657E-01],
	[4.85700E+04, 4.1386107730E+04, 5.0904560101E+03, 2.7433655454E+04, 3.8901373997E+03, 9.8459138796E-01],
	[4.85750E+04, 4.1393702348E+04, 5.0904965115E+03, 2.7442875918E+04, 3.8904135006E+03, 9.8459711679E-01],
	[4.85800E+04, 4.1401297579E+04, 5.0905370091E+03, 2.7452098531E+04, 3.8906895374E+03, 9.8460284307E-01],
	[4.85850E+04, 4.1408893420E+04, 5.0905775028E+03, 2.7461323292E+04, 3.8909655102E+03, 9.8460856678E-01],
	[4.85900E+04, 4.1416489874E+04, 5.0906179926E+03, 2.7470550201E+04, 3.8912414190E+03, 9.8461428794E-01],
	[4.85950E+04, 4.1424086939E+04, 5.0906584786E+03, 2.7479779259E+04, 3.8915172638E+03, 9.8462000655E-01],
	[4.86000E+04, 4.1431684616E+04, 5.0906989608E+03, 2.7489010466E+04, 3.8917930446E+03, 9.8462572260E-01],
	[4.86050E+04, 4.1439282905E+04, 5.0907394392E+03, 2.7498243822E+04, 3.8920687614E+03, 9.8463143611E-01],
	[4.86100E+04, 4.1446881805E+04, 5.0907799136E+03, 2.7507479327E+04, 3.8923444144E+03, 9.8463714706E-01],
	[4.86150E+04, 4.1454481317E+04, 5.0908203843E+03, 2.7516716983E+04, 3.8926200033E+03, 9.8464285546E-01],
	[4.86200E+04, 4.1462081441E+04, 5.0908608511E+03, 2.7525956788E+04, 3.8928955284E+03, 9.8464856132E-01],
	[4.86250E+04, 4.1469682176E+04, 5.0909013141E+03, 2.7535198744E+04, 3.8931709896E+03, 9.8465426463E-01],
	[4.86300E+04, 4.1477283523E+04, 5.0909417732E+03, 2.7544442851E+04, 3.8934463869E+03, 9.8465996539E-01],
	[4.86350E+04, 4.1484885481E+04, 5.0909822285E+03, 2.7553689108E+04, 3.8937217204E+03, 9.8466566362E-01],
	[4.86400E+04, 4.1492488051E+04, 5.0910226799E+03, 2.7562937517E+04, 3.8939969900E+03, 9.8467135929E-01],
	[4.86450E+04, 4.1500091232E+04, 5.0910631276E+03, 2.7572188077E+04, 3.8942721958E+03, 9.8467705243E-01],
	[4.86500E+04, 4.1507695026E+04, 5.0911035713E+03, 2.7581440789E+04, 3.8945473378E+03, 9.8468274303E-01],
	[4.86550E+04, 4.1515299430E+04, 5.0911440113E+03, 2.7590695653E+04, 3.8948224160E+03, 9.8468843110E-01],
	[4.86600E+04, 4.1522904446E+04, 5.0911844474E+03, 2.7599952670E+04, 3.8950974304E+03, 9.8469411662E-01],
	[4.86650E+04, 4.1530510074E+04, 5.0912248797E+03, 2.7609211839E+04, 3.8953723810E+03, 9.8469979961E-01],
	[4.86700E+04, 4.1538116313E+04, 5.0912653081E+03, 2.7618473160E+04, 3.8956472679E+03, 9.8470548006E-01],
	[4.86750E+04, 4.1545723164E+04, 5.0913057327E+03, 2.7627736635E+04, 3.8959220911E+03, 9.8471115799E-01],
	[4.86800E+04, 4.1553330626E+04, 5.0913461535E+03, 2.7637002264E+04, 3.8961968506E+03, 9.8471683338E-01],
	[4.86850E+04, 4.1560938700E+04, 5.0913865705E+03, 2.7646270046E+04, 3.8964715464E+03, 9.8472250624E-01],
	[4.86900E+04, 4.1568547385E+04, 5.0914269836E+03, 2.7655539982E+04, 3.8967461785E+03, 9.8472817657E-01],
	[4.86950E+04, 4.1576156681E+04, 5.0914673929E+03, 2.7664812073E+04, 3.8970207469E+03, 9.8473384438E-01],
	[4.87000E+04, 4.1583766589E+04, 5.0915077984E+03, 2.7674086318E+04, 3.8972952517E+03, 9.8473950965E-01],
	[4.87050E+04, 4.1591377108E+04, 5.0915482000E+03, 2.7683362717E+04, 3.8975696929E+03, 9.8474517241E-01],
	[4.87100E+04, 4.1598988239E+04, 5.0915885978E+03, 2.7692641272E+04, 3.8978440704E+03, 9.8475083264E-01],
	[4.87150E+04, 4.1606599981E+04, 5.0916289918E+03, 2.7701921983E+04, 3.8981183844E+03, 9.8475649034E-01],
	[4.87200E+04, 4.1614212334E+04, 5.0916693819E+03, 2.7711204849E+04, 3.8983926348E+03, 9.8476214553E-01],
	[4.87250E+04, 4.1621825299E+04, 5.0917097683E+03, 2.7720489871E+04, 3.8986668216E+03, 9.8476779820E-01],
	[4.87300E+04, 4.1629438875E+04, 5.0917501508E+03, 2.7729777049E+04, 3.8989409449E+03, 9.8477344835E-01],
	[4.87350E+04, 4.1637053063E+04, 5.0917905295E+03, 2.7739066383E+04, 3.8992150046E+03, 9.8477909598E-01],
	[4.87400E+04, 4.1644667861E+04, 5.0918309043E+03, 2.7748357875E+04, 3.8994890009E+03, 9.8478474110E-01],
	[4.87450E+04, 4.1652283271E+04, 5.0918712754E+03, 2.7757651523E+04, 3.8997629336E+03, 9.8479038370E-01],
	[4.87500E+04, 4.1659899293E+04, 5.0919116426E+03, 2.7766947329E+04, 3.9000368029E+03, 9.8479602379E-01],
	[4.87550E+04, 4.1667515925E+04, 5.0919520060E+03, 2.7776245293E+04, 3.9003106087E+03, 9.8480166137E-01],
	[4.87600E+04, 4.1675133169E+04, 5.0919923656E+03, 2.7785545414E+04, 3.9005843510E+03, 9.8480729643E-01],
	[4.87650E+04, 4.1682751024E+04, 5.0920327214E+03, 2.7794847694E+04, 3.9008580300E+03, 9.8481292899E-01],
	[4.87700E+04, 4.1690369491E+04, 5.0920730733E+03, 2.7804152132E+04, 3.9011316455E+03, 9.8481855904E-01],
	[4.87750E+04, 4.1697988568E+04, 5.0921134214E+03, 2.7813458728E+04, 3.9014051976E+03, 9.8482418659E-01],
	[4.87800E+04, 4.1705608257E+04, 5.0921537657E+03, 2.7822767484E+04, 3.9016786863E+03, 9.8482981163E-01],
	[4.87850E+04, 4.1713228557E+04, 5.0921941062E+03, 2.7832078399E+04, 3.9019521117E+03, 9.8483543416E-01],
	[4.87900E+04, 4.1720849468E+04, 5.0922344429E+03, 2.7841391474E+04, 3.9022254737E+03, 9.8484105420E-01],
	[4.87950E+04, 4.1728470990E+04, 5.0922747758E+03, 2.7850706708E+04, 3.9024987724E+03, 9.8484667173E-01],
	[4.88000E+04, 4.1736093123E+04, 5.0923151048E+03, 2.7860024103E+04, 3.9027720078E+03, 9.8485228676E-01],
	[4.88050E+04, 4.1743715868E+04, 5.0923554301E+03, 2.7869343658E+04, 3.9030451799E+03, 9.8485789929E-01],
	[4.88100E+04, 4.1751339223E+04, 5.0923957515E+03, 2.7878665374E+04, 3.9033182887E+03, 9.8486350933E-01],
	[4.88150E+04, 4.1758974496E+04, 5.0924374431E+03, 2.7887989251E+04, 3.9035922403E+03, 9.8486911687E-01],
	[4.88200E+04, 4.1766634047E+04, 5.0924820063E+03, 2.7897315288E+04, 3.9038680254E+03, 9.8487472192E-01],
	[4.88250E+04, 4.1774294219E+04, 5.0925265652E+03, 2.7906643488E+04, 3.9041437476E+03, 9.8488032447E-01],
	[4.88300E+04, 4.1781955011E+04, 5.0925711200E+03, 2.7915973849E+04, 3.9044194070E+03, 9.8488592453E-01],
	[4.88350E+04, 4.1789616424E+04, 5.0926156706E+03, 2.7925306373E+04, 3.9046950035E+03, 9.8489152210E-01],
	[4.88400E+04, 4.1797278456E+04, 5.0926602171E+03, 2.7934641058E+04, 3.9049705371E+03, 9.8489711718E-01],
	[4.88450E+04, 4.1804941109E+04, 5.0927047593E+03, 2.7943977907E+04, 3.9052460079E+03, 9.8490270977E-01],
	[4.88500E+04, 4.1812604382E+04, 5.0927492974E+03, 2.7953316918E+04, 3.9055214160E+03, 9.8490829988E-01],
	[4.88550E+04, 4.1820268275E+04, 5.0927938314E+03, 2.7962658092E+04, 3.9057967612E+03, 9.8491388750E-01],
	[4.88600E+04, 4.1827932789E+04, 5.0928383611E+03, 2.7972001430E+04, 3.9060720437E+03, 9.8491947263E-01],
	[4.88650E+04, 4.1835597923E+04, 5.0928828867E+03, 2.7981346932E+04, 3.9063472634E+03, 9.8492505529E-01],
	[4.88700E+04, 4.1843263676E+04, 5.0929274082E+03, 2.7990694598E+04, 3.9066224204E+03, 9.8493063546E-01],
	[4.88750E+04, 4.1850930050E+04, 5.0929719254E+03, 2.8000044428E+04, 3.9068975146E+03, 9.8493621315E-01],
	[4.88800E+04, 4.1858597045E+04, 5.0930164385E+03, 2.8009396423E+04, 3.9071725461E+03, 9.8494178837E-01],
	[4.88850E+04, 4.1866264659E+04, 5.0930609475E+03, 2.8018750582E+04, 3.9074475150E+03, 9.8494736110E-01],
	[4.88900E+04, 4.1873932893E+04, 5.0931054523E+03, 2.8028106907E+04, 3.9077224212E+03, 9.8495293136E-01],
	[4.88950E+04, 4.1881601748E+04, 5.0931499529E+03, 2.8037465397E+04, 3.9079972647E+03, 9.8495849914E-01],
	[4.89000E+04, 4.1889271222E+04, 5.0931944493E+03, 2.8046826053E+04, 3.9082720455E+03, 9.8496406445E-01],
	[4.89050E+04, 4.1896941317E+04, 5.0932389416E+03, 2.8056188875E+04, 3.9085467638E+03, 9.8496962729E-01],
	[4.89100E+04, 4.1904612032E+04, 5.0932834297E+03, 2.8065553863E+04, 3.9088214194E+03, 9.8497518766E-01],
	[4.89150E+04, 4.1912283367E+04, 5.0933279137E+03, 2.8074921018E+04, 3.9090960125E+03, 9.8498074556E-01],
	[4.89200E+04, 4.1919955322E+04, 5.0933723935E+03, 2.8084290339E+04, 3.9093705429E+03, 9.8498630098E-01],
	[4.89250E+04, 4.1927627896E+04, 5.0934168692E+03, 2.8093661828E+04, 3.9096450108E+03, 9.8499185394E-01],
	[4.89300E+04, 4.1935301091E+04, 5.0934613407E+03, 2.8103035484E+04, 3.9099194162E+03, 9.8499740444E-01],
	[4.89350E+04, 4.1942974906E+04, 5.0935058080E+03, 2.8112411307E+04, 3.9101937590E+03, 9.8500295247E-01],
	[4.89400E+04, 4.1950649341E+04, 5.0935502712E+03, 2.8121789299E+04, 3.9104680393E+03, 9.8500849804E-01],
	[4.89450E+04, 4.1958324396E+04, 5.0935947302E+03, 2.8131169459E+04, 3.9107422572E+03, 9.8501404114E-01],
	[4.89500E+04, 4.1966000071E+04, 5.0936391851E+03, 2.8140551787E+04, 3.9110164125E+03, 9.8501958179E-01],
	[4.89550E+04, 4.1973676365E+04, 5.0936836358E+03, 2.8149936284E+04, 3.9112905054E+03, 9.8502511997E-01],
	[4.89600E+04, 4.1981353280E+04, 5.0937280824E+03, 2.8159322951E+04, 3.9115645358E+03, 9.8503065570E-01],
	[4.89650E+04, 4.1989030815E+04, 5.0937725248E+03, 2.8168711786E+04, 3.9118385038E+03, 9.8503618897E-01],
	[4.89700E+04, 4.1996708969E+04, 5.0938169631E+03, 2.8178102791E+04, 3.9121124093E+03, 9.8504171978E-01],
	[4.89750E+04, 4.2004387744E+04, 5.0938613972E+03, 2.8187495966E+04, 3.9123862525E+03, 9.8504724814E-01],
	[4.89800E+04, 4.2012067138E+04, 5.0939058272E+03, 2.8196891312E+04, 3.9126600333E+03, 9.8505277405E-01],
	[4.89850E+04, 4.2019747152E+04, 5.0939502530E+03, 2.8206288827E+04, 3.9129337517E+03, 9.8505829751E-01],
	[4.89900E+04, 4.2027427786E+04, 5.0939946747E+03, 2.8215688514E+04, 3.9132074078E+03, 9.8506381851E-01],
	[4.89950E+04, 4.2035109040E+04, 5.0940390923E+03, 2.8225090371E+04, 3.9134810015E+03, 9.8506933707E-01],
	[4.90000E+04, 4.2042790914E+04, 5.0940835056E+03, 2.8234494400E+04, 3.9137545329E+03, 9.8507485318E-01],
	[4.90050E+04, 4.2050473407E+04, 5.0941279149E+03, 2.8243900600E+04, 3.9140280020E+03, 9.8508036684E-01],
	[4.90100E+04, 4.2058156521E+04, 5.0941723200E+03, 2.8253308972E+04, 3.9143014088E+03, 9.8508587806E-01],
	[4.90150E+04, 4.2065840254E+04, 5.0942167209E+03, 2.8262719517E+04, 3.9145747534E+03, 9.8509138683E-01],
	[4.90200E+04, 4.2073524607E+04, 5.0942611178E+03, 2.8272132233E+04, 3.9148480357E+03, 9.8509689316E-01],
	[4.90250E+04, 4.2081209579E+04, 5.0943055104E+03, 2.8281547123E+04, 3.9151212557E+03, 9.8510239705E-01],
	[4.90300E+04, 4.2088895172E+04, 5.0943498990E+03, 2.8290964185E+04, 3.9153944136E+03, 9.8510789849E-01],
	[4.90350E+04, 4.2096581384E+04, 5.0943942834E+03, 2.8300383421E+04, 3.9156675092E+03, 9.8511339750E-01],
	[4.90400E+04, 4.2104268215E+04, 5.0944386636E+03, 2.8309804830E+04, 3.9159405426E+03, 9.8511889408E-01],
	[4.90450E+04, 4.2111955667E+04, 5.0944830397E+03, 2.8319228413E+04, 3.9162135139E+03, 9.8512438821E-01],
	[4.90500E+04, 4.2119643738E+04, 5.0945274117E+03, 2.8328654170E+04, 3.9164864230E+03, 9.8512987991E-01],
	[4.90550E+04, 4.2127332429E+04, 5.0945717795E+03, 2.8338082101E+04, 3.9167592699E+03, 9.8513536918E-01],
	[4.90600E+04, 4.2135021740E+04, 5.0946161433E+03, 2.8347512207E+04, 3.9170320547E+03, 9.8514085601E-01],
	[4.90650E+04, 4.2142711670E+04, 5.0946605028E+03, 2.8356944488E+04, 3.9173047775E+03, 9.8514634042E-01],
	[4.90700E+04, 4.2150402220E+04, 5.0947048583E+03, 2.8366378945E+04, 3.9175774381E+03, 9.8515182239E-01],
	[4.90750E+04, 4.2158093389E+04, 5.0947492096E+03, 2.8375815576E+04, 3.9178500366E+03, 9.8515730193E-01],
	[4.90800E+04, 4.2165785179E+04, 5.0947935567E+03, 2.8385254384E+04, 3.9181225731E+03, 9.8516277905E-01],
	[4.90850E+04, 4.2173477587E+04, 5.0948378998E+03, 2.8394695367E+04, 3.9183950475E+03, 9.8516825374E-01],
	[4.90900E+04, 4.2181170616E+04, 5.0948822387E+03, 2.8404138527E+04, 3.9186674599E+03, 9.8517372601E-01],
	[4.90950E+04, 4.2188864264E+04, 5.0949265735E+03, 2.8413583864E+04, 3.9189398103E+03, 9.8517919585E-01],
	[4.91000E+04, 4.2196558531E+04, 5.0949709041E+03, 2.8423031377E+04, 3.9192120987E+03, 9.8518466327E-01],
	[4.91050E+04, 4.2204253418E+04, 5.0950152306E+03, 2.8432481067E+04, 3.9194843251E+03, 9.8519012827E-01],
	[4.91100E+04, 4.2211948925E+04, 5.0950595530E+03, 2.8441932935E+04, 3.9197564895E+03, 9.8519559086E-01],
	[4.91150E+04, 4.2219645051E+04, 5.0951038713E+03, 2.8451386981E+04, 3.9200285920E+03, 9.8520105102E-01],
	[4.91200E+04, 4.2227341796E+04, 5.0951481855E+03, 2.8460843205E+04, 3.9203006326E+03, 9.8520650876E-01],
	[4.91250E+04, 4.2235039161E+04, 5.0951924955E+03, 2.8470301606E+04, 3.9205726112E+03, 9.8521196409E-01],
	[4.91300E+04, 4.2242737146E+04, 5.0952368014E+03, 2.8479762187E+04, 3.9208445280E+03, 9.8521741701E-01],
	[4.91350E+04, 4.2250435750E+04, 5.0952811031E+03, 2.8489224946E+04, 3.9211163828E+03, 9.8522286751E-01],
	[4.91400E+04, 4.2258134974E+04, 5.0953254008E+03, 2.8498689885E+04, 3.9213881758E+03, 9.8522831560E-01],
	[4.91450E+04, 4.2265834817E+04, 5.0953696943E+03, 2.8508157002E+04, 3.9216599069E+03, 9.8523376128E-01],
	[4.91500E+04, 4.2273535279E+04, 5.0954139837E+03, 2.8517626300E+04, 3.9219315762E+03, 9.8523920455E-01],
	[4.91550E+04, 4.2281236361E+04, 5.0954582690E+03, 2.8527097777E+04, 3.9222031837E+03, 9.8524464541E-01],
	[4.91600E+04, 4.2288938062E+04, 5.0955025501E+03, 2.8536571435E+04, 3.9224747293E+03, 9.8525008386E-01],
	[4.91650E+04, 4.2296640383E+04, 5.0955468272E+03, 2.8546047273E+04, 3.9227462132E+03, 9.8525551991E-01],
	[4.91700E+04, 4.2304343323E+04, 5.0955911001E+03, 2.8555525292E+04, 3.9230176353E+03, 9.8526095355E-01],
	[4.91750E+04, 4.2312046882E+04, 5.0956353689E+03, 2.8565005492E+04, 3.9232889956E+03, 9.8526638479E-01],
	[4.91800E+04, 4.2319751061E+04, 5.0956796336E+03, 2.8574487874E+04, 3.9235602942E+03, 9.8527181363E-01],
	[4.91850E+04, 4.2327455859E+04, 5.0957238942E+03, 2.8583972437E+04, 3.9238315311E+03, 9.8527724007E-01],
	[4.91900E+04, 4.2335161276E+04, 5.0957681507E+03, 2.8593459182E+04, 3.9241027062E+03, 9.8528266411E-01],
	[4.91950E+04, 4.2342867313E+04, 5.0958124030E+03, 2.8602948109E+04, 3.9243738197E+03, 9.8528808575E-01],
	[4.92000E+04, 4.2350573969E+04, 5.0958566512E+03, 2.8612439219E+04, 3.9246448715E+03, 9.8529350500E-01],
	[4.92050E+04, 4.2358281244E+04, 5.0959008954E+03, 2.8621932511E+04, 3.9249158616E+03, 9.8529892184E-01],
	[4.92100E+04, 4.2365989139E+04, 5.0959451354E+03, 2.8631427987E+04, 3.9251867900E+03, 9.8530433630E-01],
	[4.92150E+04, 4.2373697652E+04, 5.0959893713E+03, 2.8640925645E+04, 3.9254576569E+03, 9.8530974836E-01],
	[4.92200E+04, 4.2381406785E+04, 5.0960336031E+03, 2.8650425488E+04, 3.9257284621E+03, 9.8531515803E-01],
	[4.92250E+04, 4.2389116538E+04, 5.0960778307E+03, 2.8659927514E+04, 3.9259992057E+03, 9.8532056531E-01],
	[4.92300E+04, 4.2396826909E+04, 5.0961220543E+03, 2.8669431724E+04, 3.9262698878E+03, 9.8532597020E-01],
	[4.92350E+04, 4.2404537900E+04, 5.0961662738E+03, 2.8678938119E+04, 3.9265405083E+03, 9.8533137270E-01],
	[4.92400E+04, 4.2412249510E+04, 5.0962104891E+03, 2.8688446698E+04, 3.9268110672E+03, 9.8533677282E-01],
	[4.92450E+04, 4.2419961739E+04, 5.0962547004E+03, 2.8697957463E+04, 3.9270815646E+03, 9.8534217055E-01],
	[4.92500E+04, 4.2427674587E+04, 5.0962989075E+03, 2.8707470413E+04, 3.9273520005E+03, 9.8534756589E-01],
	[4.92550E+04, 4.2435388055E+04, 5.0963431106E+03, 2.8716985548E+04, 3.9276223749E+03, 9.8535295886E-01],
	[4.92600E+04, 4.2443102141E+04, 5.0963873095E+03, 2.8726502869E+04, 3.9278926878E+03, 9.8535834944E-01],
	[4.92650E+04, 4.2450816847E+04, 5.0964315043E+03, 2.8736022376E+04, 3.9281629392E+03, 9.8536373764E-01],
	[4.92700E+04, 4.2458532172E+04, 5.0964756951E+03, 2.8745544070E+04, 3.9284331291E+03, 9.8536912346E-01],
	[4.92750E+04, 4.2466248116E+04, 5.0965198817E+03, 2.8755067950E+04, 3.9287032577E+03, 9.8537450690E-01],
	[4.92800E+04, 4.2473964679E+04, 5.0965640642E+03, 2.8764594017E+04, 3.9289733248E+03, 9.8537988797E-01],
	[4.92850E+04, 4.2481681861E+04, 5.0966082427E+03, 2.8774122272E+04, 3.9292433305E+03, 9.8538526666E-01],
	[4.92900E+04, 4.2489399662E+04, 5.0966524170E+03, 2.8783652714E+04, 3.9295132748E+03, 9.8539064298E-01],
	[4.92950E+04, 4.2497118082E+04, 5.0966965872E+03, 2.8793185343E+04, 3.9297831577E+03, 9.8539601692E-01],
	[4.93000E+04, 4.2504837121E+04, 5.0967407534E+03, 2.8802720161E+04, 3.9300529793E+03, 9.8540138850E-01],
	[4.93050E+04, 4.2512556779E+04, 5.0967849154E+03, 2.8812257167E+04, 3.9303227395E+03, 9.8540675770E-01],
	[4.93100E+04, 4.2520277057E+04, 5.0968290734E+03, 2.8821796362E+04, 3.9305924384E+03, 9.8541212453E-01],
	[4.93150E+04, 4.2527997953E+04, 5.0968732272E+03, 2.8831337746E+04, 3.9308620760E+03, 9.8541748900E-01],
	[4.93200E+04, 4.2535719468E+04, 5.0969173770E+03, 2.8840881319E+04, 3.9311316523E+03, 9.8542285110E-01],
	[4.93250E+04, 4.2543441602E+04, 5.0969615226E+03, 2.8850427081E+04, 3.9314011673E+03, 9.8542821083E-01],
	[4.93300E+04, 4.2551164356E+04, 5.0970056642E+03, 2.8859975033E+04, 3.9316706211E+03, 9.8543356820E-01],
	[4.93350E+04, 4.2558887728E+04, 5.0970498017E+03, 2.8869525175E+04, 3.9319400136E+03, 9.8543892321E-01],
	[4.93400E+04, 4.2566611719E+04, 5.0970939351E+03, 2.8879077507E+04, 3.9322093449E+03, 9.8544427585E-01],
	[4.93450E+04, 4.2574336329E+04, 5.0971380644E+03, 2.8888632030E+04, 3.9324786149E+03, 9.8544962614E-01],
	[4.93500E+04, 4.2582061558E+04, 5.0971821896E+03, 2.8898188744E+04, 3.9327478238E+03, 9.8545497406E-01],
	[4.93550E+04, 4.2589787405E+04, 5.0972263107E+03, 2.8907747649E+04, 3.9330169715E+03, 9.8546031963E-01],
	[4.93600E+04, 4.2597513872E+04, 5.0972704278E+03, 2.8917308746E+04, 3.9332860580E+03, 9.8546566284E-01],
	[4.93650E+04, 4.2605240957E+04, 5.0973145407E+03, 2.8926872034E+04, 3.9335550833E+03, 9.8547100370E-01],
	[4.93700E+04, 4.2612968662E+04, 5.0973586496E+03, 2.8936437514E+04, 3.9338240475E+03, 9.8547634220E-01],
	[4.93750E+04, 4.2620696985E+04, 5.0974027543E+03, 2.8946005186E+04, 3.9340929506E+03, 9.8548167834E-01],
	[4.93800E+04, 4.2628425927E+04, 5.0974468550E+03, 2.8955575051E+04, 3.9343617926E+03, 9.8548701214E-01],
	[4.93850E+04, 4.2636155488E+04, 5.0974909516E+03, 2.8965147109E+04, 3.9346305735E+03, 9.8549234359E-01],
	[4.93900E+04, 4.2643885668E+04, 5.0975350442E+03, 2.8974721359E+04, 3.9348992934E+03, 9.8549767268E-01],
	[4.93950E+04, 4.2651616466E+04, 5.0975791326E+03, 2.8984297804E+04, 3.9351679522E+03, 9.8550299943E-01],
	[4.94000E+04, 4.2659347883E+04, 5.0976232170E+03, 2.8993876441E+04, 3.9354365499E+03, 9.8550832384E-01],
	[4.94050E+04, 4.2667079919E+04, 5.0976672972E+03, 2.9003457273E+04, 3.9357050866E+03, 9.8551364590E-01],
	[4.94100E+04, 4.2674812574E+04, 5.0977113734E+03, 2.9013040299E+04, 3.9359735623E+03, 9.8551896563E-01],
	[4.94150E+04, 4.2682545847E+04, 5.0977554456E+03, 2.9022625520E+04, 3.9362419770E+03, 9.8552428302E-01],
	[4.94200E+04, 4.2690279739E+04, 5.0977995136E+03, 2.9032212935E+04, 3.9365103308E+03, 9.8552959808E-01],
	[4.94250E+04, 4.2698014250E+04, 5.0978435776E+03, 2.9041802545E+04, 3.9367786235E+03, 9.8553491080E-01],
	[4.94300E+04, 4.2705749380E+04, 5.0978876375E+03, 2.9051394351E+04, 3.9370468554E+03, 9.8554022119E-01],
	[4.94350E+04, 4.2713485128E+04, 5.0979316933E+03, 2.9060988352E+04, 3.9373150263E+03, 9.8554552924E-01],
	[4.94400E+04, 4.2721221495E+04, 5.0979757450E+03, 2.9070584549E+04, 3.9375831362E+03, 9.8555083497E-01],
	[4.94450E+04, 4.2728958481E+04, 5.0980197927E+03, 2.9080182943E+04, 3.9378511853E+03, 9.8555613836E-01],
	[4.94500E+04, 4.2736696085E+04, 5.0980638363E+03, 2.9089783532E+04, 3.9381191735E+03, 9.8556143943E-01],
	[4.94550E+04, 4.2744434308E+04, 5.0981078758E+03, 2.9099386319E+04, 3.9383871009E+03, 9.8556673817E-01],
	[4.94600E+04, 4.2752173149E+04, 5.0981519112E+03, 2.9108991302E+04, 3.9386549674E+03, 9.8557203458E-01],
	[4.94650E+04, 4.2759912609E+04, 5.0981959426E+03, 2.9118598483E+04, 3.9389227730E+03, 9.8557732867E-01],
	[4.94700E+04, 4.2767652688E+04, 5.0982399699E+03, 2.9128207862E+04, 3.9391905178E+03, 9.8558262043E-01],
	[4.94750E+04, 4.2775393385E+04, 5.0982839932E+03, 2.9137819438E+04, 3.9394582019E+03, 9.8558790987E-01],
	[4.94800E+04, 4.2783134701E+04, 5.0983280123E+03, 2.9147433212E+04, 3.9397258251E+03, 9.8559319699E-01],
	[4.94850E+04, 4.2790876635E+04, 5.0983720274E+03, 2.9157049185E+04, 3.9399933876E+03, 9.8559848178E-01],
	[4.94900E+04, 4.2798619188E+04, 5.0984160384E+03, 2.9166667357E+04, 3.9402608893E+03, 9.8560376426E-01],
	[4.94950E+04, 4.2806362360E+04, 5.0984600454E+03, 2.9176287727E+04, 3.9405283303E+03, 9.8560904442E-01],
	[4.95000E+04, 4.2814106150E+04, 5.0985040483E+03, 2.9185910297E+04, 3.9407957105E+03, 9.8561432226E-01],
	[4.95050E+04, 4.2821850558E+04, 5.0985480471E+03, 2.9195535066E+04, 3.9410630301E+03, 9.8561959779E-01],
	[4.95100E+04, 4.2829595585E+04, 5.0985920419E+03, 2.9205162035E+04, 3.9413302889E+03, 9.8562487099E-01],
	[4.95150E+04, 4.2837341230E+04, 5.0986360326E+03, 2.9214791205E+04, 3.9415974871E+03, 9.8563014189E-01],
	[4.95200E+04, 4.2845087494E+04, 5.0986800193E+03, 2.9224422574E+04, 3.9418646246E+03, 9.8563541047E-01],
	[4.95250E+04, 4.2852834377E+04, 5.0987240019E+03, 2.9234056145E+04, 3.9421317015E+03, 9.8564067674E-01],
	[4.95300E+04, 4.2860581877E+04, 5.0987679804E+03, 2.9243691916E+04, 3.9423987177E+03, 9.8564594070E-01],
	[4.95350E+04, 4.2868329996E+04, 5.0988119548E+03, 2.9253329888E+04, 3.9426656734E+03, 9.8565120235E-01],
	[4.95400E+04, 4.2876078734E+04, 5.0988559252E+03, 2.9262970062E+04, 3.9429325684E+03, 9.8565646169E-01],
	[4.95450E+04, 4.2883828090E+04, 5.0988998916E+03, 2.9272612438E+04, 3.9431994029E+03, 9.8566171872E-01],
	[4.95500E+04, 4.2891578064E+04, 5.0989438539E+03, 2.9282257015E+04, 3.9434661768E+03, 9.8566697345E-01],
	[4.95550E+04, 4.2899328657E+04, 5.0989878121E+03, 2.9291903796E+04, 3.9437328901E+03, 9.8567222587E-01],
	[4.95600E+04, 4.2907079868E+04, 5.0990317663E+03, 2.9301552778E+04, 3.9439995429E+03, 9.8567747598E-01],
	[4.95650E+04, 4.2914831697E+04, 5.0990757164E+03, 2.9311203964E+04, 3.9442661352E+03, 9.8568272380E-01],
	[4.95700E+04, 4.2922584145E+04, 5.0991196625E+03, 2.9320857353E+04, 3.9445326670E+03, 9.8568796931E-01],
	[4.95750E+04, 4.2930337211E+04, 5.0991636045E+03, 2.9330512945E+04, 3.9447991383E+03, 9.8569321252E-01],
	[4.95800E+04, 4.2938090896E+04, 5.0992075424E+03, 2.9340170741E+04, 3.9450655491E+03, 9.8569845343E-01],
	[4.95850E+04, 4.2945845198E+04, 5.0992514763E+03, 2.9349830741E+04, 3.9453318995E+03, 9.8570369204E-01],
	[4.95900E+04, 4.2953600119E+04, 5.0992954062E+03, 2.9359492945E+04, 3.9455981894E+03, 9.8570892835E-01],
	[4.95950E+04, 4.2961355658E+04, 5.0993393320E+03, 2.9369157354E+04, 3.9458644189E+03, 9.8571416237E-01],
	[4.96000E+04, 4.2969111816E+04, 5.0993832537E+03, 2.9378823968E+04, 3.9461305880E+03, 9.8571939409E-01],
	[4.96050E+04, 4.2976868592E+04, 5.0994271714E+03, 2.9388492786E+04, 3.9463966967E+03, 9.8572462352E-01],
	[4.96100E+04, 4.2984625985E+04, 5.0994710851E+03, 2.9398163811E+04, 3.9466627450E+03, 9.8572985065E-01],
	[4.96150E+04, 4.2992383998E+04, 5.0995149947E+03, 2.9407837041E+04, 3.9469287330E+03, 9.8573507549E-01],
	[4.96200E+04, 4.3000142628E+04, 5.0995589003E+03, 2.9417512477E+04, 3.9471946606E+03, 9.8574029804E-01],
	[4.96250E+04, 4.3007901876E+04, 5.0996028018E+03, 2.9427190119E+04, 3.9474605279E+03, 9.8574551831E-01],
	[4.96300E+04, 4.3015661743E+04, 5.0996466992E+03, 2.9436869968E+04, 3.9477263349E+03, 9.8575073628E-01],
	[4.96350E+04, 4.3023422228E+04, 5.0996905927E+03, 2.9446552023E+04, 3.9479920816E+03, 9.8575595196E-01],
	[4.96400E+04, 4.3031183331E+04, 5.0997344821E+03, 2.9456236286E+04, 3.9482577680E+03, 9.8576116536E-01],
	[4.96450E+04, 4.3038945052E+04, 5.0997783674E+03, 2.9465922756E+04, 3.9485233941E+03, 9.8576637647E-01],
	[4.96500E+04, 4.3046707391E+04, 5.0998222487E+03, 2.9475611434E+04, 3.9487889600E+03, 9.8577158530E-01],
	[4.96550E+04, 4.3054470349E+04, 5.0998661259E+03, 2.9485302319E+04, 3.9490544657E+03, 9.8577679184E-01],
	[4.96600E+04, 4.3062233924E+04, 5.0999099992E+03, 2.9494995413E+04, 3.9493199111E+03, 9.8578199610E-01],
	[4.96650E+04, 4.3069998118E+04, 5.0999538683E+03, 2.9504690715E+04, 3.9495852963E+03, 9.8578719809E-01],
	[4.96700E+04, 4.3077762929E+04, 5.0999977335E+03, 2.9514388227E+04, 3.9498506214E+03, 9.8579239779E-01],
	[4.96750E+04, 4.3085528359E+04, 5.1000415946E+03, 2.9524087947E+04, 3.9501158863E+03, 9.8579759521E-01],
	[4.96800E+04, 4.3093294406E+04, 5.1000854516E+03, 2.9533789876E+04, 3.9503810910E+03, 9.8580279035E-01],
	[4.96850E+04, 4.3101061072E+04, 5.1001293047E+03, 2.9543494016E+04, 3.9506462356E+03, 9.8580798322E-01],
	[4.96900E+04, 4.3108828356E+04, 5.1001731536E+03, 2.9553200365E+04, 3.9509113200E+03, 9.8581317381E-01],
	[4.96950E+04, 4.3116596258E+04, 5.1002169986E+03, 2.9562908924E+04, 3.9511763444E+03, 9.8581836213E-01],
	[4.97000E+04, 4.3124364777E+04, 5.1002608395E+03, 2.9572619694E+04, 3.9514413086E+03, 9.8582354817E-01],
	[4.97050E+04, 4.3132133915E+04, 5.1003046764E+03, 2.9582332674E+04, 3.9517062128E+03, 9.8582873194E-01],
	[4.97100E+04, 4.3139903671E+04, 5.1003485092E+03, 2.9592047865E+04, 3.9519710569E+03, 9.8583391344E-01],
	[4.97150E+04, 4.3147674044E+04, 5.1003923381E+03, 2.9601765268E+04, 3.9522358410E+03, 9.8583909267E-01],
	[4.97200E+04, 4.3155445036E+04, 5.1004361629E+03, 2.9611484883E+04, 3.9525005650E+03, 9.8584426963E-01],
	[4.97250E+04, 4.3163216645E+04, 5.1004799836E+03, 2.9621206709E+04, 3.9527652290E+03, 9.8584944432E-01],
	[4.97300E+04, 4.3170988873E+04, 5.1005238003E+03, 2.9630930747E+04, 3.9530298330E+03, 9.8585461675E-01],
	[4.97350E+04, 4.3178761718E+04, 5.1005676130E+03, 2.9640656998E+04, 3.9532943771E+03, 9.8585978691E-01],
	[4.97400E+04, 4.3186535181E+04, 5.1006114217E+03, 2.9650385461E+04, 3.9535588612E+03, 9.8586495480E-01],
	[4.97450E+04, 4.3194309262E+04, 5.1006552264E+03, 2.9660116138E+04, 3.9538232853E+03, 9.8587012044E-01],
	[4.97500E+04, 4.3202083961E+04, 5.1006990270E+03, 2.9669849028E+04, 3.9540876495E+03, 9.8587528381E-01],
	[4.97550E+04, 4.3209859278E+04, 5.1007428236E+03, 2.9679584131E+04, 3.9543519537E+03, 9.8588044491E-01],
	[4.97600E+04, 4.3217635213E+04, 5.1007866161E+03, 2.9689321448E+04, 3.9546161981E+03, 9.8588560376E-01],
	[4.97650E+04, 4.3225411765E+04, 5.1008304047E+03, 2.9699060979E+04, 3.9548803826E+03, 9.8589076035E-01],
	[4.97700E+04, 4.3233188935E+04, 5.1008741892E+03, 2.9708802725E+04, 3.9551445072E+03, 9.8589591468E-01],
	[4.97750E+04, 4.3240966723E+04, 5.1009179697E+03, 2.9718546685E+04, 3.9554085719E+03, 9.8590106675E-01],
	[4.97800E+04, 4.3248745129E+04, 5.1009617462E+03, 2.9728292860E+04, 3.9556725768E+03, 9.8590621657E-01],
	[4.97850E+04, 4.3256524153E+04, 5.1010055186E+03, 2.9738041251E+04, 3.9559365219E+03, 9.8591136413E-01],
	[4.97900E+04, 4.3264303794E+04, 5.1010492871E+03, 2.9747791857E+04, 3.9562004071E+03, 9.8591650944E-01],
	[4.97950E+04, 4.3272084053E+04, 5.1010930515E+03, 2.9757544678E+04, 3.9564642326E+03, 9.8592165249E-01],
	[4.98000E+04, 4.3279864930E+04, 5.1011368119E+03, 2.9767299716E+04, 3.9567279983E+03, 9.8592679330E-01],
	[4.98050E+04, 4.3287646424E+04, 5.1011805682E+03, 2.9777056970E+04, 3.9569917042E+03, 9.8593193185E-01],
	[4.98100E+04, 4.3295428537E+04, 5.1012243206E+03, 2.9786816441E+04, 3.9572553504E+03, 9.8593706815E-01],
	[4.98150E+04, 4.3303211267E+04, 5.1012680689E+03, 2.9796578129E+04, 3.9575189368E+03, 9.8594220221E-01],
	[4.98200E+04, 4.3310994614E+04, 5.1013118133E+03, 2.9806342034E+04, 3.9577824635E+03, 9.8594733402E-01],
	[4.98250E+04, 4.3318778579E+04, 5.1013555536E+03, 2.9816108156E+04, 3.9580459306E+03, 9.8595246358E-01],
	[4.98300E+04, 4.3326563162E+04, 5.1013992899E+03, 2.9825876496E+04, 3.9583093379E+03, 9.8595759090E-01],
	[4.98350E+04, 4.3334348363E+04, 5.1014430222E+03, 2.9835647054E+04, 3.9585726856E+03, 9.8596271597E-01],
	[4.98400E+04, 4.3342134181E+04, 5.1014867504E+03, 2.9845419831E+04, 3.9588359736E+03, 9.8596783880E-01],
	[4.98450E+04, 4.3349920617E+04, 5.1015304747E+03, 2.9855194826E+04, 3.9590992020E+03, 9.8597295939E-01],
	[4.98500E+04, 4.3357707670E+04, 5.1015741950E+03, 2.9864972040E+04, 3.9593623707E+03, 9.8597807774E-01],
	[4.98550E+04, 4.3365495341E+04, 5.1016179112E+03, 2.9874751473E+04, 3.9596254799E+03, 9.8598319385E-01],
	[4.98600E+04, 4.3373283630E+04, 5.1016616234E+03, 2.9884533125E+04, 3.9598885294E+03, 9.8598830772E-01],
	[4.98650E+04, 4.3381072536E+04, 5.1017053316E+03, 2.9894316998E+04, 3.9601515194E+03, 9.8599341935E-01],
	[4.98700E+04, 4.3388862060E+04, 5.1017490359E+03, 2.9904103090E+04, 3.9604144498E+03, 9.8599852874E-01],
	[4.98750E+04, 4.3396652201E+04, 5.1017927361E+03, 2.9913891402E+04, 3.9606773207E+03, 9.8600363590E-01],
	[4.98800E+04, 4.3404442960E+04, 5.1018364323E+03, 2.9923681935E+04, 3.9609401320E+03, 9.8600874083E-01],
	[4.98850E+04, 4.3412234336E+04, 5.1018801245E+03, 2.9933474689E+04, 3.9612028839E+03, 9.8601384352E-01],
	[4.98900E+04, 4.3420026330E+04, 5.1019238126E+03, 2.9943269664E+04, 3.9614655762E+03, 9.8601894398E-01],
	[4.98950E+04, 4.3427818941E+04, 5.1019674968E+03, 2.9953066861E+04, 3.9617282090E+03, 9.8602404221E-01],
	[4.99000E+04, 4.3435612170E+04, 5.1020111770E+03, 2.9962866279E+04, 3.9619907824E+03, 9.8602913822E-01],
	[4.99050E+04, 4.3443406016E+04, 5.1020548532E+03, 2.9972667919E+04, 3.9622532964E+03, 9.8603423199E-01],
	[4.99100E+04, 4.3451200479E+04, 5.1020985254E+03, 2.9982471781E+04, 3.9625157508E+03, 9.8603932353E-01],
	[4.99150E+04, 4.3458995560E+04, 5.1021421935E+03, 2.9992277866E+04, 3.9627781459E+03, 9.8604441285E-01],
	[4.99200E+04, 4.3466791259E+04, 5.1021858577E+03, 3.0002086173E+04, 3.9630404816E+03, 9.8604949994E-01],
	[4.99250E+04, 4.3474587575E+04, 5.1022295179E+03, 3.0011896704E+04, 3.9633027579E+03, 9.8605458481E-01],
	[4.99300E+04, 4.3482384508E+04, 5.1022731741E+03, 3.0021709458E+04, 3.9635649748E+03, 9.8605966745E-01],
	[4.99350E+04, 4.3490182059E+04, 5.1023168262E+03, 3.0031524436E+04, 3.9638271323E+03, 9.8606474787E-01],
	[4.99400E+04, 4.3497980227E+04, 5.1023604744E+03, 3.0041341637E+04, 3.9640892305E+03, 9.8606982607E-01],
	[4.99450E+04, 4.3505779012E+04, 5.1024041186E+03, 3.0051161063E+04, 3.9643512694E+03, 9.8607490205E-01],
	[4.99500E+04, 4.3513578415E+04, 5.1024477588E+03, 3.0060982713E+04, 3.9646132490E+03, 9.8607997581E-01],
	[4.99550E+04, 4.3521378435E+04, 5.1024913950E+03, 3.0070806588E+04, 3.9648751693E+03, 9.8608504736E-01],
	[4.99600E+04, 4.3529179072E+04, 5.1025350272E+03, 3.0080632688E+04, 3.9651370303E+03, 9.8609011668E-01],
	[4.99650E+04, 4.3536980327E+04, 5.1025786554E+03, 3.0090461014E+04, 3.9653988320E+03, 9.8609518379E-01],
	[4.99700E+04, 4.3544782199E+04, 5.1026222796E+03, 3.0100291565E+04, 3.9656605745E+03, 9.8610024869E-01],
	[4.99750E+04, 4.3552584688E+04, 5.1026658998E+03, 3.0110124342E+04, 3.9659222577E+03, 9.8610531137E-01],
	[4.99800E+04, 4.3560387794E+04, 5.1027095161E+03, 3.0119959345E+04, 3.9661838818E+03, 9.8611037184E-01],
	[4.99850E+04, 4.3568191518E+04, 5.1027531283E+03, 3.0129796574E+04, 3.9664454466E+03, 9.8611543010E-01],
	[4.99900E+04, 4.3575995859E+04, 5.1027967365E+03, 3.0139636031E+04, 3.9667069522E+03, 9.8612048615E-01],
	[4.99950E+04, 4.3583800817E+04, 5.1028403408E+03, 3.0149477714E+04, 3.9669683987E+03, 9.8612553999E-01],
	[5.00000E+04, 4.3591606393E+04, 5.1028839411E+03, 3.0159321624E+04, 3.9672297860E+03, 9.8613059162E-01],
	[5.00050E+04, 4.3599412585E+04, 5.1029275374E+03, 3.0169184664E+04, 3.9674914065E+03, 9.8613564104E-01],
	[5.00100E+04, 4.3607219395E+04, 5.1029711297E+03, 3.0179049941E+04, 3.9677529677E+03, 9.8614068826E-01],
	[5.00150E+04, 4.3615026822E+04, 5.1030147180E+03, 3.0188917455E+04, 3.9680144696E+03, 9.8614573327E-01],
	[5.00200E+04, 4.3622834866E+04, 5.1030583023E+03, 3.0198787207E+04, 3.9682759124E+03, 9.8615077608E-01],
	[5.00250E+04, 4.3630643527E+04, 5.1031018826E+03, 3.0208659197E+04, 3.9685372959E+03, 9.8615581668E-01],
	[5.00300E+04, 4.3638452806E+04, 5.1031454590E+03, 3.0218533425E+04, 3.9687986201E+03, 9.8616085508E-01],
	[5.00350E+04, 4.3646262701E+04, 5.1031890314E+03, 3.0228409891E+04, 3.9690598852E+03, 9.8616589129E-01],
	[5.00400E+04, 4.3654073214E+04, 5.1032325998E+03, 3.0238288597E+04, 3.9693210912E+03, 9.8617092529E-01],
	[5.00450E+04, 4.3661884344E+04, 5.1032761642E+03, 3.0248169541E+04, 3.9695822379E+03, 9.8617595709E-01],
	[5.00500E+04, 4.3669696090E+04, 5.1033197246E+03, 3.0258052725E+04, 3.9698433255E+03, 9.8618098670E-01],
	[5.00550E+04, 4.3677508454E+04, 5.1033632811E+03, 3.0267938149E+04, 3.9701043540E+03, 9.8618601411E-01],
	[5.00600E+04, 4.3685321435E+04, 5.1034068336E+03, 3.0277825812E+04, 3.9703653234E+03, 9.8619103933E-01],
	[5.00650E+04, 4.3693135033E+04, 5.1034503821E+03, 3.0287715716E+04, 3.9706262337E+03, 9.8619606235E-01],
	[5.00700E+04, 4.3700949248E+04, 5.1034939266E+03, 3.0297607860E+04, 3.9708870848E+03, 9.8620108317E-01],
	[5.00750E+04, 4.3708764080E+04, 5.1035374671E+03, 3.0307502245E+04, 3.9711478770E+03, 9.8620610181E-01],
	[5.00800E+04, 4.3716579529E+04, 5.1035810037E+03, 3.0317398871E+04, 3.9714086100E+03, 9.8621111825E-01],
	[5.00850E+04, 4.3724395595E+04, 5.1036245363E+03, 3.0327297739E+04, 3.9716692841E+03, 9.8621613251E-01],
	[5.00900E+04, 4.3732212278E+04, 5.1036680649E+03, 3.0337198848E+04, 3.9719298991E+03, 9.8622114457E-01],
	[5.00950E+04, 4.3740029578E+04, 5.1037115895E+03, 3.0347102199E+04, 3.9721904551E+03, 9.8622615445E-01],
	[5.01000E+04, 4.3747847495E+04, 5.1037551102E+03, 3.0357007792E+04, 3.9724509521E+03, 9.8623116214E-01],
	[5.01050E+04, 4.3755666029E+04, 5.1037986269E+03, 3.0366915628E+04, 3.9727113902E+03, 9.8623616765E-01],
	[5.01100E+04, 4.3763485180E+04, 5.1038421396E+03, 3.0376825706E+04, 3.9729717693E+03, 9.8624117097E-01],
	[5.01150E+04, 4.3771304948E+04, 5.1038856484E+03, 3.0386738028E+04, 3.9732320894E+03, 9.8624617210E-01],
	[5.01200E+04, 4.3779125332E+04, 5.1039291532E+03, 3.0396652593E+04, 3.9734923506E+03, 9.8625117106E-01],
	[5.01250E+04, 4.3786946334E+04, 5.1039726540E+03, 3.0406569401E+04, 3.9737525529E+03, 9.8625616783E-01],
	[5.01300E+04, 4.3794767952E+04, 5.1040161509E+03, 3.0416488454E+04, 3.9740126964E+03, 9.8626116242E-01],
	[5.01350E+04, 4.3802590188E+04, 5.1040596437E+03, 3.0426409751E+04, 3.9742727809E+03, 9.8626615484E-01],
	[5.01400E+04, 4.3810413040E+04, 5.1041031327E+03, 3.0436333292E+04, 3.9745328066E+03, 9.8627114507E-01],
	[5.01450E+04, 4.3818236509E+04, 5.1041466176E+03, 3.0446259078E+04, 3.9747927734E+03, 9.8627613313E-01],
	[5.01500E+04, 4.3826060595E+04, 5.1041900986E+03, 3.0456187108E+04, 3.9750526814E+03, 9.8628111901E-01],
	[5.01550E+04, 4.3833885297E+04, 5.1042335756E+03, 3.0466117385E+04, 3.9753125305E+03, 9.8628610272E-01],
	[5.01600E+04, 4.3841710617E+04, 5.1042770487E+03, 3.0476049907E+04, 3.9755723209E+03, 9.8629108425E-01],
	[5.01650E+04, 4.3849536553E+04, 5.1043205178E+03, 3.0485984674E+04, 3.9758320525E+03, 9.8629606361E-01],
	[5.01700E+04, 4.3857363106E+04, 5.1043639829E+03, 3.0495921688E+04, 3.9760917253E+03, 9.8630104080E-01],
	[5.01750E+04, 4.3865190275E+04, 5.1044074441E+03, 3.0505860949E+04, 3.9763513393E+03, 9.8630601581E-01],
	[5.01800E+04, 4.3873018062E+04, 5.1044509013E+03, 3.0515802456E+04, 3.9766108946E+03, 9.8631098866E-01],
	[5.01850E+04, 4.3880846465E+04, 5.1044943545E+03, 3.0525746210E+04, 3.9768703912E+03, 9.8631595934E-01],
	[5.01900E+04, 4.3888675485E+04, 5.1045378038E+03, 3.0535692211E+04, 3.9771298291E+03, 9.8632092785E-01],
	[5.01950E+04, 4.3896505122E+04, 5.1045812491E+03, 3.0545640461E+04, 3.9773892082E+03, 9.8632589419E-01],
	[5.02000E+04, 4.3904335375E+04, 5.1046246905E+03, 3.0555590957E+04, 3.9776485287E+03, 9.8633085837E-01],
	[5.02050E+04, 4.3912166245E+04, 5.1046681279E+03, 3.0565543703E+04, 3.9779077906E+03, 9.8633582039E-01],
	[5.02100E+04, 4.3919997732E+04, 5.1047115614E+03, 3.0575498696E+04, 3.9781669937E+03, 9.8634078024E-01],
	[5.02150E+04, 4.3927829835E+04, 5.1047549909E+03, 3.0585455938E+04, 3.9784261383E+03, 9.8634573793E-01],
	[5.02200E+04, 4.3935662555E+04, 5.1047984164E+03, 3.0595415430E+04, 3.9786852242E+03, 9.8635069346E-01],
	[5.02250E+04, 4.3943495892E+04, 5.1048418380E+03, 3.0605377170E+04, 3.9789442516E+03, 9.8635564682E-01],
	[5.02300E+04, 4.3951329845E+04, 5.1048852557E+03, 3.0615341160E+04, 3.9792032203E+03, 9.8636059803E-01],
	[5.02350E+04, 4.3959164415E+04, 5.1049286694E+03, 3.0625307400E+04, 3.9794621305E+03, 9.8636554708E-01],
	[5.02400E+04, 4.3966999601E+04, 5.1049720791E+03, 3.0635275891E+04, 3.9797209821E+03, 9.8637049398E-01],
	[5.02450E+04, 4.3974835404E+04, 5.1050154849E+03, 3.0645246631E+04, 3.9799797752E+03, 9.8637543871E-01],
	[5.02500E+04, 4.3982671824E+04, 5.1050588867E+03, 3.0655219622E+04, 3.9802385097E+03, 9.8638038130E-01],
	[5.02550E+04, 4.3990508860E+04, 5.1051022846E+03, 3.0665194865E+04, 3.9804971858E+03, 9.8638532172E-01],
	[5.02600E+04, 4.3998346513E+04, 5.1051456786E+03, 3.0675172358E+04, 3.9807558033E+03, 9.8639026000E-01],
	[5.02650E+04, 4.4006184782E+04, 5.1051890686E+03, 3.0685152103E+04, 3.9810143624E+03, 9.8639519613E-01],
	[5.02700E+04, 4.4014023667E+04, 5.1052324546E+03, 3.0695134100E+04, 3.9812728630E+03, 9.8640013010E-01],
	[5.02750E+04, 4.4021863170E+04, 5.1052758367E+03, 3.0705118349E+04, 3.9815313051E+03, 9.8640506192E-01],
	[5.02800E+04, 4.4029703288E+04, 5.1053192148E+03, 3.0715104851E+04, 3.9817896889E+03, 9.8640999160E-01],
	[5.02850E+04, 4.4037544024E+04, 5.1053625891E+03, 3.0725093605E+04, 3.9820480142E+03, 9.8641491913E-01],
	[5.02900E+04, 4.4045385375E+04, 5.1054059593E+03, 3.0735084612E+04, 3.9823062811E+03, 9.8641984451E-01],
	[5.02950E+04, 4.4053227343E+04, 5.1054493256E+03, 3.0745077873E+04, 3.9825644896E+03, 9.8642476775E-01],
	[5.03000E+04, 4.4061069928E+04, 5.1054926880E+03, 3.0755073387E+04, 3.9828226398E+03, 9.8642968884E-01],
	[5.03050E+04, 4.4068913129E+04, 5.1055360464E+03, 3.0765071155E+04, 3.9830807316E+03, 9.8643460779E-01],
	[5.03100E+04, 4.4076756946E+04, 5.1055794009E+03, 3.0775071176E+04, 3.9833387650E+03, 9.8643952460E-01],
	[5.03150E+04, 4.4084601380E+04, 5.1056227515E+03, 3.0785073453E+04, 3.9835967402E+03, 9.8644443926E-01],
	[5.03200E+04, 4.4092446430E+04, 5.1056660981E+03, 3.0795077984E+04, 3.9838546570E+03, 9.8644935179E-01],
	[5.03250E+04, 4.4100292097E+04, 5.1057094408E+03, 3.0805084770E+04, 3.9841125155E+03, 9.8645426217E-01],
	[5.03300E+04, 4.4108138380E+04, 5.1057527795E+03, 3.0815093811E+04, 3.9843703158E+03, 9.8645917042E-01],
	[5.03350E+04, 4.4115985279E+04, 5.1057961143E+03, 3.0825105108E+04, 3.9846280578E+03, 9.8646407654E-01],
	[5.03400E+04, 4.4123832795E+04, 5.1058394452E+03, 3.0835118660E+04, 3.9848857415E+03, 9.8646898051E-01],
	[5.03450E+04, 4.4131680927E+04, 5.1058827721E+03, 3.0845134469E+04, 3.9851433670E+03, 9.8647388235E-01],
	[5.03500E+04, 4.4139529675E+04, 5.1059260951E+03, 3.0855152534E+04, 3.9854009343E+03, 9.8647878206E-01],
	[5.03550E+04, 4.4147379040E+04, 5.1059694142E+03, 3.0865172856E+04, 3.9856584434E+03, 9.8648367964E-01],
	[5.03600E+04, 4.4155229021E+04, 5.1060127293E+03, 3.0875195434E+04, 3.9859158943E+03, 9.8648857508E-01],
	[5.03650E+04, 4.4163079618E+04, 5.1060560405E+03, 3.0885220270E+04, 3.9861732870E+03, 9.8649346839E-01],
	[5.03700E+04, 4.4170930831E+04, 5.1060993477E+03, 3.0895247363E+04, 3.9864306216E+03, 9.8649835958E-01],
	[5.03750E+04, 4.4178782661E+04, 5.1061426511E+03, 3.0905276715E+04, 3.9866878981E+03, 9.8650324863E-01],
	[5.03800E+04, 4.4186635107E+04, 5.1061859504E+03, 3.0915308324E+04, 3.9869451164E+03, 9.8650813556E-01],
	[5.03850E+04, 4.4194488169E+04, 5.1062292459E+03, 3.0925342192E+04, 3.9872022766E+03, 9.8651302036E-01],
	[5.03900E+04, 4.4202341847E+04, 5.1062725375E+03, 3.0935378318E+04, 3.9874593787E+03, 9.8651790303E-01],
	[5.03950E+04, 4.4210196141E+04, 5.1063158251E+03, 3.0945416703E+04, 3.9877164228E+03, 9.8652278358E-01],
	[5.04000E+04, 4.4218051052E+04, 5.1063591087E+03, 3.0955457347E+04, 3.9879734087E+03, 9.8652766201E-01],
	[5.04050E+04, 4.4225906579E+04, 5.1064023885E+03, 3.0965500251E+04, 3.9882303367E+03, 9.8653253832E-01],
	[5.04100E+04, 4.4233762722E+04, 5.1064456643E+03, 3.0975545415E+04, 3.9884872066E+03, 9.8653741250E-01],
	[5.04150E+04, 4.4241619481E+04, 5.1064889362E+03, 3.0985592839E+04, 3.9887440184E+03, 9.8654228457E-01],
	[5.04200E+04, 4.4249476856E+04, 5.1065322042E+03, 3.0995642523E+04, 3.9890007723E+03, 9.8654715451E-01],
	[5.04250E+04, 4.4257334848E+04, 5.1065754683E+03, 3.1005694468E+04, 3.9892574682E+03, 9.8655202234E-01],
	[5.04300E+04, 4.4265193455E+04, 5.1066187284E+03, 3.1015748673E+04, 3.9895141061E+03, 9.8655688805E-01],
	[5.04350E+04, 4.4273052679E+04, 5.1066619846E+03, 3.1025805140E+04, 3.9897706861E+03, 9.8656175165E-01],
	[5.04400E+04, 4.4280912519E+04, 5.1067052369E+03, 3.1035863869E+04, 3.9900272081E+03, 9.8656661313E-01],
	[5.04450E+04, 4.4288772974E+04, 5.1067484852E+03, 3.1045924859E+04, 3.9902836722E+03, 9.8657147249E-01],
	[5.04500E+04, 4.4296634046E+04, 5.1067917297E+03, 3.1055988111E+04, 3.9905400784E+03, 9.8657632975E-01],
	[5.04550E+04, 4.4304495734E+04, 5.1068349702E+03, 3.1066053625E+04, 3.9907964267E+03, 9.8658118489E-01],
	[5.04600E+04, 4.4312358038E+04, 5.1068782068E+03, 3.1076121403E+04, 3.9910527171E+03, 9.8658603792E-01],
	[5.04650E+04, 4.4320220958E+04, 5.1069214395E+03, 3.1086191443E+04, 3.9913089497E+03, 9.8659088884E-01],
	[5.04700E+04, 4.4328084494E+04, 5.1069646683E+03, 3.1096263746E+04, 3.9915651244E+03, 9.8659573765E-01],
	[5.04750E+04, 4.4335948646E+04, 5.1070078931E+03, 3.1106338313E+04, 3.9918212412E+03, 9.8660058436E-01],
	[5.04800E+04, 4.4343813414E+04, 5.1070511141E+03, 3.1116415143E+04, 3.9920773003E+03, 9.8660542895E-01],
	[5.04850E+04, 4.4351678797E+04, 5.1070943311E+03, 3.1126494238E+04, 3.9923333015E+03, 9.8661027145E-01],
	[5.04900E+04, 4.4359544797E+04, 5.1071375442E+03, 3.1136575596E+04, 3.9925892450E+03, 9.8661511184E-01],
	[5.04950E+04, 4.4367411413E+04, 5.1071807534E+03, 3.1146659220E+04, 3.9928451307E+03, 9.8661995012E-01],
	[5.05000E+04, 4.4375278645E+04, 5.1072239587E+03, 3.1156745108E+04, 3.9931009586E+03, 9.8662478630E-01],
	[5.05050E+04, 4.4383146492E+04, 5.1072671601E+03, 3.1166833262E+04, 3.9933567288E+03, 9.8662962039E-01],
	[5.05100E+04, 4.4391014956E+04, 5.1073103575E+03, 3.1176923681E+04, 3.9936124413E+03, 9.8663445237E-01],
	[5.05150E+04, 4.4398884035E+04, 5.1073535511E+03, 3.1187016365E+04, 3.9938680961E+03, 9.8663928225E-01],
	[5.05200E+04, 4.4406753730E+04, 5.1073967407E+03, 3.1197111316E+04, 3.9941236931E+03, 9.8664411003E-01],
	[5.05250E+04, 4.4414624042E+04, 5.1074399264E+03, 3.1207208533E+04, 3.9943792325E+03, 9.8664893572E-01],
	[5.05300E+04, 4.4422494969E+04, 5.1074831082E+03, 3.1217308017E+04, 3.9946347142E+03, 9.8665375931E-01],
	[5.05350E+04, 4.4430366511E+04, 5.1075262862E+03, 3.1227409767E+04, 3.9948901383E+03, 9.8665858081E-01],
	[5.05400E+04, 4.4438238670E+04, 5.1075694602E+03, 3.1237513785E+04, 3.9951455047E+03, 9.8666340021E-01],
	[5.05450E+04, 4.4446111444E+04, 5.1076126303E+03, 3.1247620070E+04, 3.9954008135E+03, 9.8666821752E-01],
	[5.05500E+04, 4.4453984835E+04, 5.1076557965E+03, 3.1257728623E+04, 3.9956560647E+03, 9.8667303273E-01],
	[5.05550E+04, 4.4461858841E+04, 5.1076989588E+03, 3.1267839444E+04, 3.9959112584E+03, 9.8667784586E-01],
	[5.05600E+04, 4.4469733463E+04, 5.1077421171E+03, 3.1277952533E+04, 3.9961663944E+03, 9.8668265689E-01],
	[5.05650E+04, 4.4477608700E+04, 5.1077852716E+03, 3.1288067890E+04, 3.9964214729E+03, 9.8668746584E-01],
	[5.05700E+04, 4.4485484553E+04, 5.1078284222E+03, 3.1298185517E+04, 3.9966764939E+03, 9.8669227270E-01],
	[5.05750E+04, 4.4493361023E+04, 5.1078715689E+03, 3.1308305413E+04, 3.9969314573E+03, 9.8669707747E-01],
	[5.05800E+04, 4.4501238107E+04, 5.1079147117E+03, 3.1318427578E+04, 3.9971863632E+03, 9.8670188016E-01],
	[5.05850E+04, 4.4509115808E+04, 5.1079578505E+03, 3.1328552013E+04, 3.9974412116E+03, 9.8670668076E-01],
	[5.05900E+04, 4.4516994124E+04, 5.1080009855E+03, 3.1338678718E+04, 3.9976960025E+03, 9.8671147928E-01],
	[5.05950E+04, 4.4524873056E+04, 5.1080441166E+03, 3.1348807693E+04, 3.9979507360E+03, 9.8671627571E-01],
	[5.06000E+04, 4.4532752603E+04, 5.1080872438E+03, 3.1358938939E+04, 3.9982054120E+03, 9.8672107007E-01],
	[5.06050E+04, 4.4540632767E+04, 5.1081303671E+03, 3.1369072455E+04, 3.9984600306E+03, 9.8672586234E-01],
	[5.06100E+04, 4.4548513546E+04, 5.1081734865E+03, 3.1379208243E+04, 3.9987145917E+03, 9.8673065254E-01],
	[5.06150E+04, 4.4556394940E+04, 5.1082166019E+03, 3.1389346302E+04, 3.9989690955E+03, 9.8673544065E-01],
	[5.06200E+04, 4.4564276950E+04, 5.1082597135E+03, 3.1399486633E+04, 3.9992235418E+03, 9.8674022669E-01],
	[5.06250E+04, 4.4572159576E+04, 5.1083028212E+03, 3.1409629236E+04, 3.9994779308E+03, 9.8674501065E-01],
	[5.06300E+04, 4.4580042817E+04, 5.1083459251E+03, 3.1419774111E+04, 3.9997322624E+03, 9.8674979254E-01],
	[5.06350E+04, 4.4587926674E+04, 5.1083890250E+03, 3.1429921259E+04, 3.9999865367E+03, 9.8675457235E-01],
	[5.06400E+04, 4.4595811147E+04, 5.1084321210E+03, 3.1440070679E+04, 4.0002407537E+03, 9.8675935009E-01],
	[5.06450E+04, 4.4603696235E+04, 5.1084752131E+03, 3.1450222373E+04, 4.0004949133E+03, 9.8676412575E-01],
	[5.06500E+04, 4.4611581938E+04, 5.1085183014E+03, 3.1460376340E+04, 4.0007490156E+03, 9.8676889935E-01],
	[5.06550E+04, 4.4619468257E+04, 5.1085613857E+03, 3.1470532581E+04, 4.0010030607E+03, 9.8677367087E-01],
	[5.06600E+04, 4.4627355192E+04, 5.1086044662E+03, 3.1480691095E+04, 4.0012570485E+03, 9.8677844032E-01],
	[5.06650E+04, 4.4635242742E+04, 5.1086475428E+03, 3.1490851884E+04, 4.0015109790E+03, 9.8678320771E-01],
	[5.06700E+04, 4.4643130908E+04, 5.1086906154E+03, 3.1501014948E+04, 4.0017648523E+03, 9.8678797303E-01],
	[5.06750E+04, 4.4651019689E+04, 5.1087336842E+03, 3.1511180286E+04, 4.0020186683E+03, 9.8679273628E-01],
	[5.06800E+04, 4.4658909086E+04, 5.1087767492E+03, 3.1521347900E+04, 4.0022724272E+03, 9.8679749747E-01],
	[5.06850E+04, 4.4666799098E+04, 5.1088198102E+03, 3.1531517788E+04, 4.0025261289E+03, 9.8680225660E-01],
	[5.06900E+04, 4.4674689725E+04, 5.1088628673E+03, 3.1541689953E+04, 4.0027797733E+03, 9.8680701366E-01],
	[5.06950E+04, 4.4682580968E+04, 5.1089059206E+03, 3.1551864393E+04, 4.0030333607E+03, 9.8681176866E-01],
	[5.07000E+04, 4.4690472826E+04, 5.1089489700E+03, 3.1562041110E+04, 4.0032868908E+03, 9.8681652160E-01],
	[5.07050E+04, 4.4698365300E+04, 5.1089920155E+03, 3.1572220103E+04, 4.0035403639E+03, 9.8682127247E-01],
	[5.07100E+04, 4.4706258389E+04, 5.1090350571E+03, 3.1582401374E+04, 4.0037937798E+03, 9.8682602129E-01],
	[5.07150E+04, 4.4714152094E+04, 5.1090780948E+03, 3.1592584921E+04, 4.0040471386E+03, 9.8683076805E-01],
	[5.07200E+04, 4.4722046414E+04, 5.1091211286E+03, 3.1602770745E+04, 4.0043004404E+03, 9.8683551276E-01],
	[5.07250E+04, 4.4729941349E+04, 5.1091641586E+03, 3.1612958848E+04, 4.0045536850E+03, 9.8684025541E-01],
	[5.07300E+04, 4.4737836900E+04, 5.1092071847E+03, 3.1623149228E+04, 4.0048068727E+03, 9.8684499600E-01],
	[5.07350E+04, 4.4745733066E+04, 5.1092502069E+03, 3.1633341886E+04, 4.0050600032E+03, 9.8684973454E-01],
	[5.07400E+04, 4.4753629847E+04, 5.1092932253E+03, 3.1643536823E+04, 4.0053130768E+03, 9.8685447103E-01],
	[5.07450E+04, 4.4761527243E+04, 5.1093362397E+03, 3.1653734039E+04, 4.0055660933E+03, 9.8685920546E-01],
	[5.07500E+04, 4.4769425255E+04, 5.1093792503E+03, 3.1663933534E+04, 4.0058190528E+03, 9.8686393785E-01],
	[5.07550E+04, 4.4777323882E+04, 5.1094222570E+03, 3.1674135308E+04, 4.0060719554E+03, 9.8686866818E-01],
	[5.07600E+04, 4.4785223125E+04, 5.1094652598E+03, 3.1684339362E+04, 4.0063248010E+03, 9.8687339647E-01],
	[5.07650E+04, 4.4793155426E+04, 5.1095119516E+03, 3.1694545696E+04, 4.0065801198E+03, 9.8687812270E-01],
	[5.07700E+04, 4.4801091250E+04, 5.1095589693E+03, 3.1704754310E+04, 4.0068356081E+03, 9.8688284690E-01],
	[5.07750E+04, 4.4809027698E+04, 5.1096059827E+03, 3.1714965204E+04, 4.0070910398E+03, 9.8688756904E-01],
	[5.07800E+04, 4.4816964771E+04, 5.1096529919E+03, 3.1725178380E+04, 4.0073464148E+03, 9.8689228914E-01],
	[5.07850E+04, 4.4824902467E+04, 5.1096999969E+03, 3.1735393836E+04, 4.0076017332E+03, 9.8689700720E-01],
	[5.07900E+04, 4.4832840788E+04, 5.1097469977E+03, 3.1745611574E+04, 4.0078569951E+03, 9.8690172321E-01],
	[5.07950E+04, 4.4840779733E+04, 5.1097939943E+03, 3.1755831593E+04, 4.0081122003E+03, 9.8690643719E-01],
	[5.08000E+04, 4.4848719303E+04, 5.1098409868E+03, 3.1766053895E+04, 4.0083673490E+03, 9.8691114912E-01],
	[5.08050E+04, 4.4856659496E+04, 5.1098879750E+03, 3.1776278478E+04, 4.0086224412E+03, 9.8691585901E-01],
	[5.08100E+04, 4.4864600314E+04, 5.1099349591E+03, 3.1786505344E+04, 4.0088774768E+03, 9.8692056687E-01],
	[5.08150E+04, 4.4872541756E+04, 5.1099819389E+03, 3.1796734493E+04, 4.0091324559E+03, 9.8692527268E-01],
	[5.08200E+04, 4.4880483821E+04, 5.1100289146E+03, 3.1806965925E+04, 4.0093873785E+03, 9.8692997646E-01],
	[5.08250E+04, 4.4888426511E+04, 5.1100758861E+03, 3.1817199641E+04, 4.0096422446E+03, 9.8693467821E-01],
	[5.08300E+04, 4.4896369826E+04, 5.1101228534E+03, 3.1827435640E+04, 4.0098970542E+03, 9.8693937792E-01],
	[5.08350E+04, 4.4904313764E+04, 5.1101698165E+03, 3.1837673922E+04, 4.0101518074E+03, 9.8694407560E-01],
	[5.08400E+04, 4.4912258326E+04, 5.1102167754E+03, 3.1847914489E+04, 4.0104065041E+03, 9.8694877124E-01],
	[5.08450E+04, 4.4920203512E+04, 5.1102637301E+03, 3.1858157341E+04, 4.0106611444E+03, 9.8695346485E-01],
	[5.08500E+04, 4.4928149323E+04, 5.1103106806E+03, 3.1868402477E+04, 4.0109157283E+03, 9.8695815644E-01],
	[5.08550E+04, 4.4936095757E+04, 5.1103576270E+03, 3.1878649899E+04, 4.0111702558E+03, 9.8696284599E-01],
	[5.08600E+04, 4.4944042816E+04, 5.1104045692E+03, 3.1888899605E+04, 4.0114247270E+03, 9.8696753351E-01],
	[5.08650E+04, 4.4951990498E+04, 5.1104515072E+03, 3.1899151598E+04, 4.0116791417E+03, 9.8697221901E-01],
	[5.08700E+04, 4.4959938805E+04, 5.1104984410E+03, 3.1909405876E+04, 4.0119335001E+03, 9.8697690248E-01],
	[5.08750E+04, 4.4967887735E+04, 5.1105453706E+03, 3.1919662441E+04, 4.0121878022E+03, 9.8698158393E-01],
	[5.08800E+04, 4.4975837290E+04, 5.1105922960E+03, 3.1929921292E+04, 4.0124420479E+03, 9.8698626335E-01],
	[5.08850E+04, 4.4983787468E+04, 5.1106392173E+03, 3.1940182429E+04, 4.0126962373E+03, 9.8699094075E-01],
	[5.08900E+04, 4.4991738271E+04, 5.1106861344E+03, 3.1950445854E+04, 4.0129503704E+03, 9.8699561612E-01],
	[5.08950E+04, 4.4999689697E+04, 5.1107330473E+03, 3.1960711566E+04, 4.0132044473E+03, 9.8700028947E-01],
	[5.09000E+04, 4.5007641747E+04, 5.1107799560E+03, 3.1970979566E+04, 4.0134584679E+03, 9.8700496081E-01],
	[5.09050E+04, 4.5015594422E+04, 5.1108268606E+03, 3.1981249853E+04, 4.0137124322E+03, 9.8700963012E-01],
	[5.09100E+04, 4.5023547720E+04, 5.1108737609E+03, 3.1991522429E+04, 4.0139663403E+03, 9.8701429742E-01],
	[5.09150E+04, 4.5031501642E+04, 5.1109206571E+03, 3.2001797293E+04, 4.0142201922E+03, 9.8701896270E-01],
	[5.09200E+04, 4.5039456188E+04, 5.1109675491E+03, 3.2012074447E+04, 4.0144739879E+03, 9.8702362596E-01],
	[5.09250E+04, 4.5047411358E+04, 5.1110144370E+03, 3.2022353889E+04, 4.0147277273E+03, 9.8702828721E-01],
	[5.09300E+04, 4.5055367151E+04, 5.1110613207E+03, 3.2032635620E+04, 4.0149814107E+03, 9.8703294644E-01],
	[5.09350E+04, 4.5063323569E+04, 5.1111082002E+03, 3.2042919641E+04, 4.0152350378E+03, 9.8703760366E-01],
	[5.09400E+04, 4.5071280610E+04, 5.1111550755E+03, 3.2053205952E+04, 4.0154886088E+03, 9.8704225887E-01],
	[5.09450E+04, 4.5079238275E+04, 5.1112019467E+03, 3.2063494553E+04, 4.0157421237E+03, 9.8704691206E-01],
	[5.09500E+04, 4.5087196564E+04, 5.1112488136E+03, 3.2073785444E+04, 4.0159955824E+03, 9.8705156325E-01],
	[5.09550E+04, 4.5095155477E+04, 5.1112956765E+03, 3.2084078627E+04, 4.0162489851E+03, 9.8705621243E-01],
	[5.09600E+04, 4.5103115014E+04, 5.1113425351E+03, 3.2094374100E+04, 4.0165023317E+03, 9.8706085960E-01],
	[5.09650E+04, 4.5111075174E+04, 5.1113893896E+03, 3.2104671865E+04, 4.0167556222E+03, 9.8706550476E-01],
	[5.09700E+04, 4.5119035958E+04, 5.1114362399E+03, 3.2114971921E+04, 4.0170088566E+03, 9.8707014791E-01],
	[5.09750E+04, 4.5126997366E+04, 5.1114830861E+03, 3.2125274269E+04, 4.0172620350E+03, 9.8707478906E-01],
	[5.09800E+04, 4.5134959397E+04, 5.1115299280E+03, 3.2135578909E+04, 4.0175151574E+03, 9.8707942821E-01],
	[5.09850E+04, 4.5142922053E+04, 5.1115767659E+03, 3.2145885842E+04, 4.0177682237E+03, 9.8708406535E-01],
	[5.09900E+04, 4.5150885332E+04, 5.1116235995E+03, 3.2156195067E+04, 4.0180212341E+03, 9.8708870049E-01],
	[5.09950E+04, 4.5158849234E+04, 5.1116704290E+03, 3.2166506586E+04, 4.0182741885E+03, 9.8709333363E-01],
	[5.10000E+04, 4.5166813761E+04, 5.1117172543E+03, 3.2176820398E+04, 4.0185270869E+03, 9.8709796477E-01],
	[5.10050E+04, 4.5174778911E+04, 5.1117640755E+03, 3.2187136503E+04, 4.0187799293E+03, 9.8710259391E-01],
	[5.10100E+04, 4.5182744685E+04, 5.1118108925E+03, 3.2197454902E+04, 4.0190327158E+03, 9.8710722105E-01],
	[5.10150E+04, 4.5190711082E+04, 5.1118577054E+03, 3.2207775596E+04, 4.0192854464E+03, 9.8711184620E-01],
	[5.10200E+04, 4.5198678103E+04, 5.1119045141E+03, 3.2218098584E+04, 4.0195381211E+03, 9.8711646934E-01],
	[5.10250E+04, 4.5206645748E+04, 5.1119513186E+03, 3.2228423866E+04, 4.0197907399E+03, 9.8712109050E-01],
	[5.10300E+04, 4.5214614016E+04, 5.1119981190E+03, 3.2238751444E+04, 4.0200433028E+03, 9.8712570965E-01],
	[5.10350E+04, 4.5222582908E+04, 5.1120449152E+03, 3.2249081317E+04, 4.0202958099E+03, 9.8713032682E-01],
	[5.10400E+04, 4.5230552423E+04, 5.1120917072E+03, 3.2259413485E+04, 4.0205482611E+03, 9.8713494199E-01],
	[5.10450E+04, 4.5238522562E+04, 5.1121384951E+03, 3.2269747950E+04, 4.0208006564E+03, 9.8713955518E-01],
	[5.10500E+04, 4.5246493325E+04, 5.1121852789E+03, 3.2280084710E+04, 4.0210529960E+03, 9.8714416637E-01],
	[5.10550E+04, 4.5254464711E+04, 5.1122320585E+03, 3.2290423767E+04, 4.0213052797E+03, 9.8714877557E-01],
	[5.10600E+04, 4.5262436721E+04, 5.1122788339E+03, 3.2300765121E+04, 4.0215575077E+03, 9.8715338279E-01],
	[5.10650E+04, 4.5270409354E+04, 5.1123256052E+03, 3.2311108771E+04, 4.0218096798E+03, 9.8715798801E-01],
	[5.10700E+04, 4.5278382610E+04, 5.1123723723E+03, 3.2321454719E+04, 4.0220617962E+03, 9.8716259125E-01],
	[5.10750E+04, 4.5286356491E+04, 5.1124191353E+03, 3.2331802965E+04, 4.0223138569E+03, 9.8716719251E-01],
	[5.10800E+04, 4.5294330994E+04, 5.1124658942E+03, 3.2342153508E+04, 4.0225658618E+03, 9.8717179178E-01],
	[5.10850E+04, 4.5302306122E+04, 5.1125126489E+03, 3.2352506350E+04, 4.0228178110E+03, 9.8717638907E-01],
	[5.10900E+04, 4.5310281872E+04, 5.1125593994E+03, 3.2362861490E+04, 4.0230697045E+03, 9.8718098438E-01],
	[5.10950E+04, 4.5318258246E+04, 5.1126061458E+03, 3.2373218929E+04, 4.0233215423E+03, 9.8718557770E-01],
	[5.11000E+04, 4.5326235244E+04, 5.1126528880E+03, 3.2383578666E+04, 4.0235733245E+03, 9.8719016905E-01],
	[5.11050E+04, 4.5334212865E+04, 5.1126996261E+03, 3.2393940703E+04, 4.0238250510E+03, 9.8719475841E-01],
	[5.11100E+04, 4.5342191109E+04, 5.1127463601E+03, 3.2404305040E+04, 4.0240767218E+03, 9.8719934580E-01],
	[5.11150E+04, 4.5350169977E+04, 5.1127930899E+03, 3.2414671676E+04, 4.0243283370E+03, 9.8720393121E-01],
	[5.11200E+04, 4.5358149468E+04, 5.1128398156E+03, 3.2425040613E+04, 4.0245798966E+03, 9.8720851464E-01],
	[5.11250E+04, 4.5366129583E+04, 5.1128865371E+03, 3.2435411850E+04, 4.0248314006E+03, 9.8721309610E-01],
	[5.11300E+04, 4.5374110321E+04, 5.1129332545E+03, 3.2445785387E+04, 4.0250828491E+03, 9.8721767558E-01],
	[5.11350E+04, 4.5382091682E+04, 5.1129799677E+03, 3.2456161226E+04, 4.0253342419E+03, 9.8722225310E-01],
	[5.11400E+04, 4.5390073667E+04, 5.1130266768E+03, 3.2466539366E+04, 4.0255855792E+03, 9.8722682863E-01],
	[5.11450E+04, 4.5398056275E+04, 5.1130733818E+03, 3.2476919807E+04, 4.0258368609E+03, 9.8723140220E-01],
	[5.11500E+04, 4.5406039506E+04, 5.1131200826E+03, 3.2487302551E+04, 4.0260880872E+03, 9.8723597380E-01],
	[5.11550E+04, 4.5414023361E+04, 5.1131667793E+03, 3.2497687596E+04, 4.0263392579E+03, 9.8724054343E-01],
	[5.11600E+04, 4.5422007838E+04, 5.1132134718E+03, 3.2508074944E+04, 4.0265903731E+03, 9.8724511109E-01],
	[5.11650E+04, 4.5429992940E+04, 5.1132601602E+03, 3.2518464595E+04, 4.0268414328E+03, 9.8724967678E-01],
	[5.11700E+04, 4.5437978664E+04, 5.1133068445E+03, 3.2528856548E+04, 4.0270924371E+03, 9.8725424050E-01],
	[5.11750E+04, 4.5445965012E+04, 5.1133535246E+03, 3.2539250805E+04, 4.0273433859E+03, 9.8725880226E-01],
	[5.11800E+04, 4.5453951983E+04, 5.1134002006E+03, 3.2549647366E+04, 4.0275942793E+03, 9.8726336206E-01],
	[5.11850E+04, 4.5461939577E+04, 5.1134468725E+03, 3.2560046230E+04, 4.0278451172E+03, 9.8726791989E-01],
	[5.11900E+04, 4.5469927794E+04, 5.1134935402E+03, 3.2570447398E+04, 4.0280958998E+03, 9.8727247576E-01],
	[5.11950E+04, 4.5477916635E+04, 5.1135402038E+03, 3.2580850871E+04, 4.0283466269E+03, 9.8727702967E-01],
	[5.12000E+04, 4.5485906099E+04, 5.1135868633E+03, 3.2591256648E+04, 4.0285972987E+03, 9.8728158162E-01],
	[5.12050E+04, 4.5493896186E+04, 5.1136335186E+03, 3.2601664731E+04, 4.0288479151E+03, 9.8728613161E-01],
	[5.12100E+04, 4.5501886896E+04, 5.1136801698E+03, 3.2612075118E+04, 4.0290984762E+03, 9.8729067964E-01],
	[5.12150E+04, 4.5509878229E+04, 5.1137268169E+03, 3.2622487812E+04, 4.0293489819E+03, 9.8729522571E-01],
	[5.12200E+04, 4.5517870185E+04, 5.1137734599E+03, 3.2632902811E+04, 4.0295994323E+03, 9.8729976982E-01],
	[5.12250E+04, 4.5525862765E+04, 5.1138200987E+03, 3.2643320116E+04, 4.0298498274E+03, 9.8730431198E-01],
	[5.12300E+04, 4.5533855968E+04, 5.1138667334E+03, 3.2653739728E+04, 4.0301001672E+03, 9.8730885219E-01],
	[5.12350E+04, 4.5541849794E+04, 5.1139133639E+03, 3.2664161646E+04, 4.0303504517E+03, 9.8731339044E-01],
	[5.12400E+04, 4.5549844243E+04, 5.1139599904E+03, 3.2674585871E+04, 4.0306006809E+03, 9.8731792674E-01],
	[5.12450E+04, 4.5557839315E+04, 5.1140066127E+03, 3.2685012404E+04, 4.0308508550E+03, 9.8732246109E-01],
	[5.12500E+04, 4.5565835010E+04, 5.1140532309E+03, 3.2695441244E+04, 4.0311009737E+03, 9.8732699349E-01],
	[5.12550E+04, 4.5573831328E+04, 5.1140998450E+03, 3.2705872392E+04, 4.0313510373E+03, 9.8733152394E-01],
	[5.12600E+04, 4.5581828269E+04, 5.1141464549E+03, 3.2716305848E+04, 4.0316010457E+03, 9.8733605244E-01],
	[5.12650E+04, 4.5589825833E+04, 5.1141930608E+03, 3.2726741612E+04, 4.0318509988E+03, 9.8734057899E-01],
	[5.12700E+04, 4.5597824020E+04, 5.1142396625E+03, 3.2737179685E+04, 4.0321008968E+03, 9.8734510359E-01],
	[5.12750E+04, 4.5605822831E+04, 5.1142862601E+03, 3.2747620067E+04, 4.0323507397E+03, 9.8734962625E-01],
	[5.12800E+04, 4.5613822264E+04, 5.1143328535E+03, 3.2758062758E+04, 4.0326005274E+03, 9.8735414697E-01],
	[5.12850E+04, 4.5621822320E+04, 5.1143794429E+03, 3.2768507759E+04, 4.0328502599E+03, 9.8735866574E-01],
	[5.12900E+04, 4.5629822999E+04, 5.1144260281E+03, 3.2778955070E+04, 4.0330999374E+03, 9.8736318257E-01],
	[5.12950E+04, 4.5637824302E+04, 5.1144726092E+03, 3.2789404691E+04, 4.0333495597E+03, 9.8736769745E-01],
	[5.13000E+04, 4.5645826227E+04, 5.1145191862E+03, 3.2799856622E+04, 4.0335991270E+03, 9.8737221040E-01],
	[5.13050E+04, 4.5653828775E+04, 5.1145657591E+03, 3.2810310864E+04, 4.0338486391E+03, 9.8737672140E-01],
	[5.13100E+04, 4.5661831946E+04, 5.1146123279E+03, 3.2820767416E+04, 4.0340980963E+03, 9.8738123047E-01],
	[5.13150E+04, 4.5669835740E+04, 5.1146588926E+03, 3.2831226280E+04, 4.0343474983E+03, 9.8738573760E-01],
	[5.13200E+04, 4.5677840157E+04, 5.1147054531E+03, 3.2841687456E+04, 4.0345968454E+03, 9.8739024279E-01],
	[5.13250E+04, 4.5685845196E+04, 5.1147520095E+03, 3.2852150943E+04, 4.0348461374E+03, 9.8739474605E-01],
	[5.13300E+04, 4.5693850859E+04, 5.1147985619E+03, 3.2862616743E+04, 4.0350953745E+03, 9.8739924737E-01],
	[5.13350E+04, 4.5701857144E+04, 5.1148451101E+03, 3.2873084855E+04, 4.0353445565E+03, 9.8740374676E-01],
	[5.13400E+04, 4.5709864053E+04, 5.1148916542E+03, 3.2883555279E+04, 4.0355936836E+03, 9.8740824421E-01],
	[5.13450E+04, 4.5717871584E+04, 5.1149381942E+03, 3.2894028017E+04, 4.0358427557E+03, 9.8741273973E-01],
	[5.13500E+04, 4.5725879738E+04, 5.1149847300E+03, 3.2904503068E+04, 4.0360917729E+03, 9.8741723332E-01],
	[5.13550E+04, 4.5733888514E+04, 5.1150312618E+03, 3.2914980432E+04, 4.0363407352E+03, 9.8742172498E-01],
	[5.13600E+04, 4.5741897914E+04, 5.1150777895E+03, 3.2925460110E+04, 4.0365896425E+03, 9.8742621472E-01],
	[5.13650E+04, 4.5749907936E+04, 5.1151243131E+03, 3.2935942102E+04, 4.0368384950E+03, 9.8743070252E-01],
	[5.13700E+04, 4.5757918582E+04, 5.1151708325E+03, 3.2946426409E+04, 4.0370872926E+03, 9.8743518840E-01],
	[5.13750E+04, 4.5765929850E+04, 5.1152173479E+03, 3.2956913030E+04, 4.0373360353E+03, 9.8743967235E-01],
	[5.13800E+04, 4.5773941740E+04, 5.1152638591E+03, 3.2967401966E+04, 4.0375847231E+03, 9.8744415437E-01],
	[5.13850E+04, 4.5781954254E+04, 5.1153103663E+03, 3.2977893217E+04, 4.0378333561E+03, 9.8744863447E-01],
	[5.13900E+04, 4.5789967390E+04, 5.1153568693E+03, 3.2988386784E+04, 4.0380819343E+03, 9.8745311265E-01],
	[5.13950E+04, 4.5797981149E+04, 5.1154033682E+03, 3.2998882667E+04, 4.0383304577E+03, 9.8745758890E-01],
	[5.14000E+04, 4.5805995530E+04, 5.1154498631E+03, 3.3009380866E+04, 4.0385789263E+03, 9.8746206324E-01],
	[5.14050E+04, 4.5814010535E+04, 5.1154963538E+03, 3.3019881381E+04, 4.0388273401E+03, 9.8746653565E-01],
	[5.14100E+04, 4.5822026162E+04, 5.1155428405E+03, 3.3030384213E+04, 4.0390756991E+03, 9.8747100615E-01],
	[5.14150E+04, 4.5830042411E+04, 5.1155893230E+03, 3.3040889362E+04, 4.0393240034E+03, 9.8747547472E-01],
	[5.14200E+04, 4.5838059283E+04, 5.1156358014E+03, 3.3051396828E+04, 4.0395722529E+03, 9.8747994138E-01],
	[5.14250E+04, 4.5846076778E+04, 5.1156822758E+03, 3.3061906611E+04, 4.0398204477E+03, 9.8748440612E-01],
	[5.14300E+04, 4.5854094896E+04, 5.1157287460E+03, 3.3072418713E+04, 4.0400685878E+03, 9.8748886895E-01],
	[5.14350E+04, 4.5862113636E+04, 5.1157752122E+03, 3.3082933132E+04, 4.0403166732E+03, 9.8749332986E-01],
	[5.14400E+04, 4.5870132999E+04, 5.1158216743E+03, 3.3093449870E+04, 4.0405647040E+03, 9.8749778886E-01],
	[5.14450E+04, 4.5878152984E+04, 5.1158681322E+03, 3.3103968927E+04, 4.0408126801E+03, 9.8750224594E-01],
	[5.14500E+04, 4.5886173592E+04, 5.1159145861E+03, 3.3114490302E+04, 4.0410606015E+03, 9.8750670112E-01],
	[5.14550E+04, 4.5894194823E+04, 5.1159610359E+03, 3.3125013997E+04, 4.0413084683E+03, 9.8751115438E-01],
	[5.14600E+04, 4.5902216676E+04, 5.1160074816E+03, 3.3135540011E+04, 4.0415562804E+03, 9.8751560573E-01],
	[5.14650E+04, 4.5910239152E+04, 5.1160539232E+03, 3.3146068345E+04, 4.0418040380E+03, 9.8752005518E-01],
	[5.14700E+04, 4.5918262250E+04, 5.1161003607E+03, 3.3156598999E+04, 4.0420517409E+03, 9.8752450271E-01],
	[5.14750E+04, 4.5926285971E+04, 5.1161467941E+03, 3.3167131973E+04, 4.0422993893E+03, 9.8752894834E-01],
	[5.14800E+04, 4.5934310314E+04, 5.1161932234E+03, 3.3177667268E+04, 4.0425469832E+03, 9.8753339207E-01],
	[5.14850E+04, 4.5942335280E+04, 5.1162396487E+03, 3.3188204884E+04, 4.0427945224E+03, 9.8753783388E-01],
	[5.14900E+04, 4.5950360868E+04, 5.1162860698E+03, 3.3198744822E+04, 4.0430420072E+03, 9.8754227380E-01],
	[5.14950E+04, 4.5958387079E+04, 5.1163324869E+03, 3.3209287080E+04, 4.0432894374E+03, 9.8754671181E-01],
	[5.15000E+04, 4.5966413912E+04, 5.1163788999E+03, 3.3219831661E+04, 4.0435368131E+03, 9.8755114792E-01],
	[5.15050E+04, 4.5974441367E+04, 5.1164253088E+03, 3.3230378564E+04, 4.0437841343E+03, 9.8755558213E-01],
	[5.15100E+04, 4.5982469445E+04, 5.1164717136E+03, 3.3240927789E+04, 4.0440314011E+03, 9.8756001444E-01],
	[5.15150E+04, 4.5990498146E+04, 5.1165181143E+03, 3.3251479336E+04, 4.0442786134E+03, 9.8756444485E-01],
	[5.15200E+04, 4.5998527469E+04, 5.1165645110E+03, 3.3262033207E+04, 4.0445257712E+03, 9.8756887336E-01],
	[5.15250E+04, 4.6006557414E+04, 5.1166109035E+03, 3.3272589401E+04, 4.0447728746E+03, 9.8757329997E-01],
	[5.15300E+04, 4.6014587982E+04, 5.1166572920E+03, 3.3283147918E+04, 4.0450199236E+03, 9.8757772469E-01],
	[5.15350E+04, 4.6022619172E+04, 5.1167036764E+03, 3.3293708759E+04, 4.0452669182E+03, 9.8758214751E-01],
	[5.15400E+04, 4.6030650984E+04, 5.1167500567E+03, 3.3304271924E+04, 4.0455138583E+03, 9.8758656844E-01],
	[5.15450E+04, 4.6038683419E+04, 5.1167964330E+03, 3.3314837414E+04, 4.0457607442E+03, 9.8759098748E-01],
	[5.15500E+04, 4.6046716476E+04, 5.1168428052E+03, 3.3325405228E+04, 4.0460075756E+03, 9.8759540462E-01],
	[5.15550E+04, 4.6054750156E+04, 5.1168891732E+03, 3.3335975367E+04, 4.0462543527E+03, 9.8759981987E-01],
	[5.15600E+04, 4.6062784457E+04, 5.1169355373E+03, 3.3346547831E+04, 4.0465010755E+03, 9.8760423323E-01],
	[5.15650E+04, 4.6070819382E+04, 5.1169818972E+03, 3.3357122621E+04, 4.0467477440E+03, 9.8760864470E-01],
	[5.15700E+04, 4.6078854928E+04, 5.1170282531E+03, 3.3367699737E+04, 4.0469943581E+03, 9.8761305428E-01],
	[5.15750E+04, 4.6086891097E+04, 5.1170746048E+03, 3.3378279179E+04, 4.0472409180E+03, 9.8761746198E-01],
	[5.15800E+04, 4.6094927887E+04, 5.1171209526E+03, 3.3388860947E+04, 4.0474874236E+03, 9.8762186778E-01],
	[5.15850E+04, 4.6102965301E+04, 5.1171672962E+03, 3.3399445041E+04, 4.0477338749E+03, 9.8762627171E-01],
	[5.15900E+04, 4.6111003336E+04, 5.1172136358E+03, 3.3410031463E+04, 4.0479802720E+03, 9.8763067374E-01],
	[5.15950E+04, 4.6119041994E+04, 5.1172599713E+03, 3.3420620212E+04, 4.0482266148E+03, 9.8763507390E-01],
	[5.16000E+04, 4.6127081274E+04, 5.1173063027E+03, 3.3431211288E+04, 4.0484729035E+03, 9.8763947217E-01],
	[5.16050E+04, 4.6135121176E+04, 5.1173526301E+03, 3.3441804692E+04, 4.0487191379E+03, 9.8764386856E-01],
	[5.16100E+04, 4.6143161700E+04, 5.1173989533E+03, 3.3452400425E+04, 4.0489653182E+03, 9.8764826306E-01],
	[5.16150E+04, 4.6151202846E+04, 5.1174452726E+03, 3.3462998485E+04, 4.0492114442E+03, 9.8765265569E-01],
	[5.16200E+04, 4.6159244615E+04, 5.1174915877E+03, 3.3473598875E+04, 4.0494575161E+03, 9.8765704644E-01],
	[5.16250E+04, 4.6167287006E+04, 5.1175378988E+03, 3.3484201593E+04, 4.0497035339E+03, 9.8766143531E-01],
	[5.16300E+04, 4.6175330019E+04, 5.1175842058E+03, 3.3494806640E+04, 4.0499494976E+03, 9.8766582230E-01],
	[5.16350E+04, 4.6183373654E+04, 5.1176305088E+03, 3.3505414017E+04, 4.0501954071E+03, 9.8767020742E-01],
	[5.16400E+04, 4.6191417911E+04, 5.1176768077E+03, 3.3516023724E+04, 4.0504412625E+03, 9.8767459066E-01],
	[5.16450E+04, 4.6199462790E+04, 5.1177231025E+03, 3.3526635760E+04, 4.0506870638E+03, 9.8767897203E-01],
	[5.16500E+04, 4.6207508292E+04, 5.1177693933E+03, 3.3537250127E+04, 4.0509328111E+03, 9.8768335152E-01],
	[5.16550E+04, 4.6215554415E+04, 5.1178156800E+03, 3.3547866825E+04, 4.0511785043E+03, 9.8768772914E-01],
	[5.16600E+04, 4.6223601161E+04, 5.1178619626E+03, 3.3558485854E+04, 4.0514241435E+03, 9.8769210489E-01],
	[5.16650E+04, 4.6231648528E+04, 5.1179082412E+03, 3.3569107214E+04, 4.0516697286E+03, 9.8769647877E-01],
	[5.16700E+04, 4.6239696518E+04, 5.1179545157E+03, 3.3579730905E+04, 4.0519152597E+03, 9.8770085078E-01],
	[5.16750E+04, 4.6247745130E+04, 5.1180007862E+03, 3.3590356928E+04, 4.0521607368E+03, 9.8770522092E-01],
	[5.16800E+04, 4.6255794364E+04, 5.1180470526E+03, 3.3600985283E+04, 4.0524061600E+03, 9.8770958919E-01],
	[5.16850E+04, 4.6263844219E+04, 5.1180933149E+03, 3.3611615971E+04, 4.0526515291E+03, 9.8771395560E-01],
	[5.16900E+04, 4.6271894697E+04, 5.1181395732E+03, 3.3622248991E+04, 4.0528968443E+03, 9.8771832014E-01],
	[5.16950E+04, 4.6279945797E+04, 5.1181858274E+03, 3.3632884344E+04, 4.0531421056E+03, 9.8772268282E-01],
	[5.17000E+04, 4.6287997519E+04, 5.1182320776E+03, 3.3643522031E+04, 4.0533873129E+03, 9.8772704363E-01],
	[5.17050E+04, 4.6296049862E+04, 5.1182783237E+03, 3.3654162051E+04, 4.0536324663E+03, 9.8773140258E-01],
	[5.17100E+04, 4.6304102828E+04, 5.1183245658E+03, 3.3664804404E+04, 4.0538775658E+03, 9.8773575966E-01],
	[5.17150E+04, 4.6312156416E+04, 5.1183708038E+03, 3.3675449092E+04, 4.0541226114E+03, 9.8774011489E-01],
	[5.17200E+04, 4.6320210625E+04, 5.1184170377E+03, 3.3686096114E+04, 4.0543676032E+03, 9.8774446825E-01],
	[5.17250E+04, 4.6328265457E+04, 5.1184632676E+03, 3.3696745471E+04, 4.0546125411E+03, 9.8774881976E-01],
	[5.17300E+04, 4.6336320910E+04, 5.1185094935E+03, 3.3707397162E+04, 4.0548574251E+03, 9.8775316941E-01],
	[5.17350E+04, 4.6344376985E+04, 5.1185557153E+03, 3.3718051189E+04, 4.0551022554E+03, 9.8775751720E-01],
	[5.17400E+04, 4.6352433682E+04, 5.1186019331E+03, 3.3728707551E+04, 4.0553470318E+03, 9.8776186313E-01],
	[5.17450E+04, 4.6360491001E+04, 5.1186481468E+03, 3.3739366250E+04, 4.0555917544E+03, 9.8776620721E-01],
	[5.17500E+04, 4.6368548942E+04, 5.1186943564E+03, 3.3750027284E+04, 4.0558364232E+03, 9.8777054944E-01],
	[5.17550E+04, 4.6376607505E+04, 5.1187405620E+03, 3.3760690654E+04, 4.0560810382E+03, 9.8777488981E-01],
	[5.17600E+04, 4.6384666689E+04, 5.1187867636E+03, 3.3771356361E+04, 4.0563255995E+03, 9.8777922832E-01],
	[5.17650E+04, 4.6392726496E+04, 5.1188329611E+03, 3.3782024406E+04, 4.0565701071E+03, 9.8778356499E-01],
	[5.17700E+04, 4.6400786924E+04, 5.1188791546E+03, 3.3792694787E+04, 4.0568145609E+03, 9.8778789981E-01],
	[5.17750E+04, 4.6408847974E+04, 5.1189253440E+03, 3.3803367506E+04, 4.0570589610E+03, 9.8779223277E-01],
	[5.17800E+04, 4.6416909645E+04, 5.1189715294E+03, 3.3814042562E+04, 4.0573033074E+03, 9.8779656389E-01],
	[5.17850E+04, 4.6424971939E+04, 5.1190177108E+03, 3.3824719957E+04, 4.0575476001E+03, 9.8780089316E-01],
	[5.17900E+04, 4.6433034854E+04, 5.1190638881E+03, 3.3835399690E+04, 4.0577918392E+03, 9.8780522058E-01],
	[5.17950E+04, 4.6441098391E+04, 5.1191100613E+03, 3.3846081761E+04, 4.0580360246E+03, 9.8780954616E-01],
	[5.18000E+04, 4.6449162550E+04, 5.1191562305E+03, 3.3856766172E+04, 4.0582801563E+03, 9.8781386989E-01],
	[5.18050E+04, 4.6457227330E+04, 5.1192023957E+03, 3.3867452922E+04, 4.0585242345E+03, 9.8781819177E-01],
	[5.18100E+04, 4.6465292733E+04, 5.1192485568E+03, 3.3878142011E+04, 4.0587682590E+03, 9.8782251182E-01],
	[5.18150E+04, 4.6473358756E+04, 5.1192947139E+03, 3.3888833440E+04, 4.0590122299E+03, 9.8782683002E-01],
	[5.18200E+04, 4.6481425402E+04, 5.1193408670E+03, 3.3899527209E+04, 4.0592561472E+03, 9.8783114638E-01],
	[5.18250E+04, 4.6489492669E+04, 5.1193870160E+03, 3.3910223319E+04, 4.0595000110E+03, 9.8783546090E-01],
	[5.18300E+04, 4.6497560558E+04, 5.1194331610E+03, 3.3920921769E+04, 4.0597438211E+03, 9.8783977358E-01],
	[5.18350E+04, 4.6505629069E+04, 5.1194793020E+03, 3.3931622560E+04, 4.0599875778E+03, 9.8784408442E-01],
	[5.18400E+04, 4.6513698201E+04, 5.1195254389E+03, 3.3942325692E+04, 4.0602312809E+03, 9.8784839342E-01],
	[5.18450E+04, 4.6521767955E+04, 5.1195715718E+03, 3.3953031166E+04, 4.0604749305E+03, 9.8785270059E-01],
	[5.18500E+04, 4.6529838330E+04, 5.1196177006E+03, 3.3963738981E+04, 4.0607185266E+03, 9.8785700592E-01],
	[5.18550E+04, 4.6537909327E+04, 5.1196638255E+03, 3.3974449139E+04, 4.0609620693E+03, 9.8786130942E-01],
	[5.18600E+04, 4.6545980946E+04, 5.1197099462E+03, 3.3985161639E+04, 4.0612055584E+03, 9.8786561108E-01],
	[5.18650E+04, 4.6554053186E+04, 5.1197560630E+03, 3.3995876481E+04, 4.0614489941E+03, 9.8786991091E-01],
	[5.18700E+04, 4.6562126048E+04, 5.1198021757E+03, 3.4006593667E+04, 4.0616923764E+03, 9.8787420890E-01],
	[5.18750E+04, 4.6570199531E+04, 5.1198482844E+03, 3.4017313195E+04, 4.0619357052E+03, 9.8787850507E-01],
	[5.18800E+04, 4.6578273636E+04, 5.1198943891E+03, 3.4028035068E+04, 4.0621789806E+03, 9.8788279941E-01],
	[5.18850E+04, 4.6586348362E+04, 5.1199404897E+03, 3.4038759283E+04, 4.0624222026E+03, 9.8788709191E-01],
	[5.18900E+04, 4.6594423710E+04, 5.1199865864E+03, 3.4049485844E+04, 4.0626653712E+03, 9.8789138259E-01],
	[5.18950E+04, 4.6602499680E+04, 5.1200326789E+03, 3.4060214748E+04, 4.0629084864E+03, 9.8789567144E-01],
	[5.19000E+04, 4.6610576271E+04, 5.1200787675E+03, 3.4070945997E+04, 4.0631515483E+03, 9.8789995847E-01],
	[5.19050E+04, 4.6618653483E+04, 5.1201248520E+03, 3.4081679591E+04, 4.0633945569E+03, 9.8790424366E-01],
	[5.19100E+04, 4.6626731317E+04, 5.1201709325E+03, 3.4092415530E+04, 4.0636375121E+03, 9.8790852704E-01],
	[5.19150E+04, 4.6634809772E+04, 5.1202170090E+03, 3.4103153815E+04, 4.0638804140E+03, 9.8791280859E-01],
	[5.19200E+04, 4.6642888849E+04, 5.1202630815E+03, 3.4113894445E+04, 4.0641232626E+03, 9.8791708832E-01],
	[5.19250E+04, 4.6650968547E+04, 5.1203091499E+03, 3.4124637422E+04, 4.0643660579E+03, 9.8792136622E-01],
	[5.19300E+04, 4.6659048867E+04, 5.1203552144E+03, 3.4135382744E+04, 4.0646088000E+03, 9.8792564231E-01],
	[5.19350E+04, 4.6667129808E+04, 5.1204012748E+03, 3.4146130414E+04, 4.0648514887E+03, 9.8792991657E-01],
	[5.19400E+04, 4.6675211370E+04, 5.1204473311E+03, 3.4156880430E+04, 4.0650941243E+03, 9.8793418902E-01],
	[5.19450E+04, 4.6683293554E+04, 5.1204933835E+03, 3.4167632794E+04, 4.0653367066E+03, 9.8793845965E-01],
	[5.19500E+04, 4.6691376359E+04, 5.1205394318E+03, 3.4178387505E+04, 4.0655792357E+03, 9.8794272846E-01],
	[5.19550E+04, 4.6699459786E+04, 5.1205854762E+03, 3.4189144564E+04, 4.0658217116E+03, 9.8794699545E-01],
	[5.19600E+04, 4.6707543834E+04, 5.1206315165E+03, 3.4199903971E+04, 4.0660641343E+03, 9.8795126063E-01],
	[5.19650E+04, 4.6715628503E+04, 5.1206775528E+03, 3.4210665726E+04, 4.0663065038E+03, 9.8795552399E-01],
	[5.19700E+04, 4.6723713794E+04, 5.1207235850E+03, 3.4221429830E+04, 4.0665488202E+03, 9.8795978554E-01],
	[5.19750E+04, 4.6731799706E+04, 5.1207696133E+03, 3.4232196283E+04, 4.0667910834E+03, 9.8796404528E-01],
	[5.19800E+04, 4.6739886239E+04, 5.1208156376E+03, 3.4242965085E+04, 4.0670332935E+03, 9.8796830321E-01],
	[5.19850E+04, 4.6747973393E+04, 5.1208616578E+03, 3.4253736237E+04, 4.0672754505E+03, 9.8797255932E-01],
	[5.19900E+04, 4.6756061169E+04, 5.1209076740E+03, 3.4264509738E+04, 4.0675175544E+03, 9.8797681363E-01],
	[5.19950E+04, 4.6764149566E+04, 5.1209536862E+03, 3.4275285590E+04, 4.0677596052E+03, 9.8798106613E-01],
	[5.20000E+04, 4.6772238584E+04, 5.1209996944E+03, 3.4286063792E+04, 4.0680016029E+03, 9.8798531681E-01],
	[5.20050E+04, 4.6780328224E+04, 5.1210456986E+03, 3.4296844344E+04, 4.0682435475E+03, 9.8798956570E-01],
	[5.20100E+04, 4.6788418485E+04, 5.1210916988E+03, 3.4307627248E+04, 4.0684854391E+03, 9.8799381277E-01],
	[5.20150E+04, 4.6796509367E+04, 5.1211376950E+03, 3.4318412502E+04, 4.0687272777E+03, 9.8799805804E-01],
	[5.20200E+04, 4.6804600870E+04, 5.1211836871E+03, 3.4329200108E+04, 4.0689690633E+03, 9.8800230151E-01],
	[5.20250E+04, 4.6812692994E+04, 5.1212296753E+03, 3.4339990066E+04, 4.0692107958E+03, 9.8800654317E-01],
	[5.20300E+04, 4.6820785740E+04, 5.1212756594E+03, 3.4350782376E+04, 4.0694524754E+03, 9.8801078303E-01],
	[5.20350E+04, 4.6828879106E+04, 5.1213216396E+03, 3.4361577038E+04, 4.0696941020E+03, 9.8801502109E-01],
	[5.20400E+04, 4.6836973094E+04, 5.1213676157E+03, 3.4372374053E+04, 4.0699356756E+03, 9.8801925735E-01],
	[5.20450E+04, 4.6845067703E+04, 5.1214135878E+03, 3.4383173421E+04, 4.0701771963E+03, 9.8802349181E-01],
	[5.20500E+04, 4.6853162933E+04, 5.1214595560E+03, 3.4393975142E+04, 4.0704186641E+03, 9.8802772446E-01],
	[5.20550E+04, 4.6861258785E+04, 5.1215055201E+03, 3.4404779217E+04, 4.0706600789E+03, 9.8803195533E-01],
	[5.20600E+04, 4.6869355257E+04, 5.1215514802E+03, 3.4415585645E+04, 4.0709014408E+03, 9.8803618439E-01],
	[5.20650E+04, 4.6877452350E+04, 5.1215974363E+03, 3.4426394428E+04, 4.0711427499E+03, 9.8804041166E-01],
	[5.20700E+04, 4.6885550065E+04, 5.1216433885E+03, 3.4437205565E+04, 4.0713840061E+03, 9.8804463713E-01],
	[5.20750E+04, 4.6893648401E+04, 5.1216893366E+03, 3.4448019056E+04, 4.0716252094E+03, 9.8804886081E-01],
	[5.20800E+04, 4.6901747357E+04, 5.1217352807E+03, 3.4458834903E+04, 4.0718663598E+03, 9.8805308269E-01],
	[5.20850E+04, 4.6909846935E+04, 5.1217812208E+03, 3.4469653104E+04, 4.0721074574E+03, 9.8805730279E-01],
	[5.20900E+04, 4.6917947134E+04, 5.1218271569E+03, 3.4480473661E+04, 4.0723485022E+03, 9.8806152109E-01],
	[5.20950E+04, 4.6926047954E+04, 5.1218730891E+03, 3.4491296574E+04, 4.0725894942E+03, 9.8806573760E-01],
	[5.21000E+04, 4.6934149395E+04, 5.1219190172E+03, 3.4502121843E+04, 4.0728304334E+03, 9.8806995232E-01],
	[5.21050E+04, 4.6942251456E+04, 5.1219649413E+03, 3.4512949469E+04, 4.0730713199E+03, 9.8807416525E-01],
	[5.21100E+04, 4.6950354139E+04, 5.1220108615E+03, 3.4523779451E+04, 4.0733121535E+03, 9.8807837640E-01],
	[5.21150E+04, 4.6958457443E+04, 5.1220567776E+03, 3.4534611790E+04, 4.0735529345E+03, 9.8808258575E-01],
	[5.21200E+04, 4.6966561368E+04, 5.1221026898E+03, 3.4545446486E+04, 4.0737936626E+03, 9.8808679333E-01],
	[5.21250E+04, 4.6974665913E+04, 5.1221485979E+03, 3.4556283540E+04, 4.0740343381E+03, 9.8809099911E-01],
	[5.21300E+04, 4.6982771080E+04, 5.1221945021E+03, 3.4567122951E+04, 4.0742749608E+03, 9.8809520311E-01],
	[5.21350E+04, 4.6990876868E+04, 5.1222404023E+03, 3.4577964721E+04, 4.0745155309E+03, 9.8809940533E-01],
	[5.21400E+04, 4.6998983276E+04, 5.1222862985E+03, 3.4588808849E+04, 4.0747560483E+03, 9.8810360577E-01],
	[5.21450E+04, 4.7007090306E+04, 5.1223321907E+03, 3.4599655335E+04, 4.0749965130E+03, 9.8810780442E-01],
	[5.21500E+04, 4.70