import numpy as np

# data taken from McGPU files (Badal A, Badano A. Accelerating Monte Carlo simulations of photon transport in a voxelized geometry using a massively parallel graphics processing unit. Med Phys. 2009 Nov;36(11):4878–80. )

#[COMPTON INTERACTIONS (relativistic impulse model with approximated one-electron analytical profiles)]
#[SHELL INFORMATION FROM COMMON/CGCO/: FCO, UICO, FJ0, KZCO, KSCO]

# Note: the FJ0 values represent the PENELOPE-2006 quantities: (J_{i,0} m_{e} c), and are thus dimensionless.

soft_tissue_ICRP110_NUM_SHELLS = 30

soft_tissue_ICRP110_compton_data = np.array([
	[  0.79256906E-03,  0.62677701E+01,  0.28551676E+03,   0,  30],
	[  0.21166691E+01,  0.13338659E+02,  0.77957519E+02,   0,  30],
	[  0.48547891E+00,  0.23993511E+02,  0.79150578E+02,   0,  30],
	[  0.90761726E-03,  0.61984985E+02,  0.45797391E+02,   0,  30],
	[  0.65056192E-02,  0.17439576E+03,  0.20035384E+02,   0,  30],
	[  0.45979000E-03,  0.27000000E+03,  0.29188668E+02,  17,   2],
	[  0.23516400E+00,  0.28500000E+03,  0.20966508E+02,   6,  30],
	[  0.12383240E-02,  0.29500000E+03,  0.13223974E+02,  19,   4],
	[  0.61916200E-03,  0.29700000E+03,  0.13223974E+02,  19,   3],
	[  0.13961720E-03,  0.34700000E+03,  0.12360647E+02,  20,   4],
	[  0.69808600E-04,  0.35000000E+03,  0.12360647E+02,  20,   3],
	[  0.61916200E-03,  0.37900000E+03,  0.25351660E+02,  19,   2],
	[  0.21608400E-01,  0.41000000E+03,  0.17814680E+02,   7,   1],
	[  0.69808600E-04,  0.43800000E+03,  0.23844264E+02,  20,   2],
	[  0.47919200E+00,  0.54300000E+03,  0.15485068E+02,   8,   1],
	[  0.21782560E-04,  0.70800000E+03,  0.89073399E+01,  26,   4],
	[  0.10891280E-04,  0.72100000E+03,  0.89073399E+01,  26,   3],
	[  0.10891280E-04,  0.84800000E+03,  0.17403572E+02,  26,   2],
	[  0.11163880E-04,  0.10220000E+04,  0.75232764E+01,  30,   4],
	[  0.55819400E-05,  0.10450000E+04,  0.75232764E+01,  30,   3],
	[  0.59793200E-03,  0.10720000E+04,  0.11168434E+02,  11,   1],
	[  0.55819400E-05,  0.11960000E+04,  0.14799888E+02,  30,   2],
	[  0.65066400E-04,  0.13030000E+04,  0.10209182E+02,  12,   1],
	[  0.52235600E-03,  0.21490000E+04,  0.81125311E+01,  15,   1],
	[  0.75508800E-03,  0.24720000E+04,  0.75780908E+01,  16,   1],
	[  0.45979000E-03,  0.28230000E+04,  0.71258720E+01,  17,   1],
	[  0.61916200E-03,  0.36080000E+04,  0.63584704E+01,  19,   1],
	[  0.69808600E-04,  0.40380000E+04,  0.60295840E+01,  20,   1],
	[  0.10891280E-04,  0.71110000E+04,  0.46044096E+01,  26,   1],
	[  0.55819400E-05,  0.96610000E+04,  0.39740440E+01,  30,   1],
])
