
#ifndef V_COMMIT_HASH
	#define V_COMMIT_HASH "2bc9ee4"
#endif

#ifndef V_CURRENT_COMMIT_HASH
	#define V_CURRENT_COMMIT_HASH "6f4292d"
#endif

// V comptime_defines:
#define _VDEBUG (1)

// V typedefs:

typedef struct {
	void* _object;
	int _interface_idx;
} _Interface;

typedef struct strings__Builder strings__Builder;
typedef struct strconv__BF_param strconv__BF_param;
typedef struct strconv__PrepNumber strconv__PrepNumber;
typedef struct strconv__Dec32 strconv__Dec32;
typedef struct strconv__Dec64 strconv__Dec64;
typedef struct strconv__Uint128 strconv__Uint128;
typedef union strconv__Uf32 strconv__Uf32;
typedef union strconv__Uf64 strconv__Uf64;
typedef union strconv__Float64u strconv__Float64u;
typedef struct array array;
typedef struct VAssertMetaInfo VAssertMetaInfo;
typedef struct MethodArgs MethodArgs;
typedef struct FunctionData FunctionData;
typedef struct FieldData FieldData;
typedef struct DenseArray DenseArray;
typedef struct map map;
typedef struct OptionBase OptionBase;
typedef struct Option Option;
typedef struct SortedMap SortedMap;
typedef struct mapnode mapnode;
typedef struct string string;
typedef struct ustring ustring;
typedef struct RepIndex RepIndex;

// V typedefs2:
typedef struct Option_int Option_int;

// V cheaders:
// Generated by the V compiler

#if defined(__TINYC__) && defined(__has_include)
// tcc does not support has_include properly yet, turn it off completely
#undef __has_include
#endif

#if defined(__has_include)

#if __has_include(<inttypes.h>)
#include <inttypes.h>
#else
#error VERROR_MESSAGE The C compiler can not find <inttypes.h> . Please install build-essentials
#endif

#else
#include <inttypes.h>
#endif


//================================== builtin types ================================*/
typedef int64_t i64;
typedef int16_t i16;
typedef int8_t i8;
typedef uint64_t u64;
typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t byte;
typedef uint32_t rune;
typedef float f32;
typedef double f64;
typedef int64_t any_int;
typedef double any_float;
typedef unsigned char* byteptr;
typedef void* voidptr;
typedef char* charptr;
typedef byte array_fixed_byte_300 [300];

typedef struct sync__Channel* chan;

#ifndef __cplusplus
	#ifndef bool
		typedef int bool;
		#define true 1
		#define false 0
	#endif
#endif

typedef u64 (*MapHashFn)(voidptr);
typedef bool (*MapEqFn)(voidptr, voidptr);
typedef void (*MapCloneFn)(voidptr, voidptr);
typedef void (*MapFreeFn)(voidptr);


// c_headers
typedef int (*qsort_callback_func)(const void*, const void*);
#include <stdio.h>  // TODO remove all these includes, define all function signatures and types manually
#include <stdlib.h>

#if defined(_WIN32) || defined(__CYGWIN__)
	#define VV_EXPORTED_SYMBOL extern __declspec(dllexport)
	#define VV_LOCAL_SYMBOL static
#else
	// 4 < gcc < 5 is used by some older Ubuntu LTS and Centos versions,
	// and does not support __has_attribute(visibility) ...
	#ifndef __has_attribute
		#define __has_attribute(x) 0  // Compatibility with non-clang compilers.
	#endif
	#if (defined(__GNUC__) && (__GNUC__ >= 4)) || (defined(__clang__) && __has_attribute(visibility))
		#define VV_EXPORTED_SYMBOL extern __attribute__ ((visibility ("default")))
		#define VV_LOCAL_SYMBOL  __attribute__ ((visibility ("hidden")))
	#else
		#define VV_EXPORTED_SYMBOL extern
		#define VV_LOCAL_SYMBOL static
	#endif
#endif

#ifdef __cplusplus
	#include <utility>
	#define _MOV std::move
#else
	#define _MOV
#endif

#if defined(__TINYC__) && defined(__has_include)
// tcc does not support has_include properly yet, turn it off completely
#undef __has_include
#endif

#ifndef _WIN32
	#if defined __has_include
		#if __has_include (<execinfo.h>)
			#include <execinfo.h>
		#else
			// Most probably musl OR __ANDROID__ ...
			int backtrace (void **__array, int __size) { return 0; }
			char **backtrace_symbols (void *const *__array, int __size){ return 0; }
			void backtrace_symbols_fd (void *const *__array, int __size, int __fd){}
		#endif
	#endif
#endif

//#include "fns.h"
#include <signal.h>
#include <stdarg.h> // for va_list
#include <string.h> // memcpy

#if INTPTR_MAX == INT32_MAX
	#define TARGET_IS_32BIT 1
#elif INTPTR_MAX == INT64_MAX
	#define TARGET_IS_64BIT 1
#else
	#error "The environment is not 32 or 64-bit."
#endif

#if defined(__BYTE_ORDER__) && __BYTE_ORDER__ == __ORDER_BIG_ENDIAN__ || defined(__BYTE_ORDER) && __BYTE_ORDER == __BIG_ENDIAN || defined(__BIG_ENDIAN__) || defined(__ARMEB__) || defined(__THUMBEB__) || defined(__AARCH64EB__) || defined(_MIBSEB) || defined(__MIBSEB) || defined(__MIBSEB__)
	#define TARGET_ORDER_IS_BIG
#elif defined(__BYTE_ORDER__) && __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__ || defined(__BYTE_ORDER) && __BYTE_ORDER == __LITTLE_ENDIAN || defined(__LITTLE_ENDIAN__) || defined(__ARMEL__) || defined(__THUMBEL__) || defined(__AARCH64EL__) || defined(_MIPSEL) || defined(__MIPSEL) || defined(__MIPSEL__) || defined(_M_AMD64) || defined(_M_X64) || defined(_M_IX86)
	#define TARGET_ORDER_IS_LITTLE
#else
	#error "Unknown architecture endianness"
#endif

#ifndef _WIN32
	#include <ctype.h>
	#include <locale.h> // tolower
	#include <sys/time.h>
	#include <unistd.h> // sleep
	extern char **environ;
#endif

#if defined(__CYGWIN__) && !defined(_WIN32)
	#error Cygwin is not supported, please use MinGW or Visual Studio.
#endif

#ifdef __linux__
	#include <sys/types.h>
	#include <sys/wait.h> // os__wait uses wait on nix
#endif

#ifdef __FreeBSD__
	#include <sys/types.h>
	#include <sys/wait.h> // os__wait uses wait on nix
#endif

#ifdef __DragonFly__
	#include <sys/types.h>
	#include <sys/wait.h> // os__wait uses wait on nix
#endif

#ifdef __OpenBSD__
	#include <sys/types.h>
	#include <sys/resource.h>
	#include <sys/wait.h> // os__wait uses wait on nix
#endif

#ifdef __NetBSD__
	#include <sys/wait.h> // os__wait uses wait on nix
#endif

#ifdef __sun
	#include <sys/types.h>
	#include <sys/wait.h> // os__wait uses wait on nix
#endif


#define EMPTY_VARG_INITIALIZATION 0
#define EMPTY_STRUCT_DECLARATION
#define EMPTY_STRUCT_INITIALIZATION 0
// Due to a tcc bug, the length of an array needs to be specified, but GCC crashes if it is...
#define EMPTY_ARRAY_OF_ELEMS(x,n) (x[])
#define TCCSKIP(x) x

#define __NOINLINE __attribute__((noinline))
#define __IRQHANDLER __attribute__((interrupt))

#if defined(__x86_64__)
#define __V_amd64  1
#endif
#if defined(__aarch64__) || defined(__arm64__)
#define __V_aarch64  1
#endif

// Using just __GNUC__ for detecting gcc, is not reliable because other compilers define it too:
#ifdef __GNUC__
	#define __V_GCC__
#endif
#ifdef __TINYC__
	#undef __V_GCC__
#endif
#ifdef __cplusplus
	#undef __V_GCC__
#endif
#ifdef __clang__
	#undef __V_GCC__
#endif
#ifdef _MSC_VER
	#undef __V_GCC__
#endif

#ifdef __TINYC__
	#undef EMPTY_STRUCT_DECLARATION
	#undef EMPTY_STRUCT_INITIALIZATION
	#define EMPTY_STRUCT_DECLARATION char _dummy
	#define EMPTY_STRUCT_INITIALIZATION 0
	#undef EMPTY_ARRAY_OF_ELEMS
	#define EMPTY_ARRAY_OF_ELEMS(x,n) (x[n])
	#undef __NOINLINE
	#undef __IRQHANDLER
	// tcc does not support inlining at all
	#define __NOINLINE
	#define __IRQHANDLER
	#undef TCCSKIP
	#define TCCSKIP(x)
	// #include <byteswap.h>
	#ifndef _WIN32
		#include <execinfo.h>
		int tcc_backtrace(const char *fmt, ...);
	#endif
#endif

// for __offset_of
#ifndef __offsetof
	#define __offsetof(s,memb) ((size_t)((char *)&((s *)0)->memb - (char *)0))
#endif

#define OPTION_CAST(x) (x)

#ifndef V64_PRINTFORMAT
	#ifdef PRIx64
		#define V64_PRINTFORMAT "0x%"PRIx64
	#elif defined(__WIN32__)
		#define V64_PRINTFORMAT "0x%I64x"
	#elif defined(__linux__) && defined(__LP64__)
		#define V64_PRINTFORMAT "0x%lx"
	#else
		#define V64_PRINTFORMAT "0x%llx"
	#endif
#endif


#ifdef _WIN32
	#define WINVER 0x0600
	#ifdef _WIN32_WINNT
		#undef _WIN32_WINNT
	#endif
	#define _WIN32_WINNT 0x0600
	#define WIN32_LEAN_AND_MEAN
	#ifndef _UNICODE
	#define _UNICODE
	#endif
	#ifndef UNICODE
	#define UNICODE
	#endif
	#include <windows.h>

	#include <io.h> // _waccess
	#include <direct.h> // _wgetcwd
	//#include <WinSock2.h>

	#ifdef _MSC_VER
		// On MSVC these are the same (as long as /volatile:ms is passed)
		#define _Atomic volatile

		// MSVC cannot parse some things properly
		#undef EMPTY_STRUCT_DECLARATION
		#undef OPTION_CAST

		#define EMPTY_STRUCT_DECLARATION int ____dummy_variable
		#define OPTION_CAST(x)
		#undef __NOINLINE
		#undef __IRQHANDLER
		#define __NOINLINE __declspec(noinline)
		#define __IRQHANDLER __declspec(naked)

		#include <dbghelp.h>
		#pragma comment(lib, "Dbghelp.lib")

		extern wchar_t **_wenviron;
	#elif !defined(SRWLOCK_INIT)
		// these seem to be missing on Windows tcc
		typedef struct SRWLOCK { void* SRWLOCK; } SRWLOCK;
		void InitializeSRWLock(void*);
		void AcquireSRWLockShared(void*);
		void AcquireSRWLockExclusive(void*);
		void ReleaseSRWLockShared(void*);
		void ReleaseSRWLockExclusive(void*);
	#endif
#else
	#include <pthread.h>
	#ifndef PTHREAD_RWLOCK_PREFER_WRITER_NONRECURSIVE_NP
		// musl does not have that
		#define pthread_rwlockattr_setkind_np(a, b)
	#endif
#endif

// g_live_info is used by live.info()
static void* g_live_info = NULL;

//============================== HELPER C MACROS =============================*/
//#define tos4(s, slen) ((string){.str=(s), .len=(slen)})
// `"" s` is used to enforce a string literal argument
#define _SLIT(s) ((string){.str=(byteptr)("" s), .len=(sizeof(s)-1), .is_lit=1})
// take the address of an rvalue
#define ADDR(type, expr) (&((type[]){expr}[0]))
#define _PUSH_MANY(arr, val, tmp, tmp_typ) {tmp_typ tmp = (val); array_push_many(arr, tmp.data, tmp.len);}
#define _IN_MAP(val, m) map_exists_1(m, val)

// unsigned/signed comparisons
static inline bool _us32_gt(uint32_t a, int32_t b) { return a > INT32_MAX || (int32_t)a > b; }
static inline bool _us32_ge(uint32_t a, int32_t b) { return a >= INT32_MAX || (int32_t)a >= b; }
static inline bool _us32_eq(uint32_t a, int32_t b) { return a <= INT32_MAX && (int32_t)a == b; }
static inline bool _us32_ne(uint32_t a, int32_t b) { return a > INT32_MAX || (int32_t)a != b; }
static inline bool _us32_le(uint32_t a, int32_t b) { return a <= INT32_MAX && (int32_t)a <= b; }
static inline bool _us32_lt(uint32_t a, int32_t b) { return a < INT32_MAX && (int32_t)a < b; }
static inline bool _us64_gt(uint64_t a, int64_t b) { return a > INT64_MAX || (int64_t)a > b; }
static inline bool _us64_ge(uint64_t a, int64_t b) { return a >= INT64_MAX || (int64_t)a >= b; }
static inline bool _us64_eq(uint64_t a, int64_t b) { return a <= INT64_MAX && (int64_t)a == b; }
static inline bool _us64_ne(uint64_t a, int64_t b) { return a > INT64_MAX || (int64_t)a != b; }
static inline bool _us64_le(uint64_t a, int64_t b) { return a <= INT64_MAX && (int64_t)a <= b; }
static inline bool _us64_lt(uint64_t a, int64_t b) { return a < INT64_MAX && (int64_t)a < b; }

#if defined(__MINGW32__) || defined(__MINGW64__) || (defined(_WIN32) && defined(__TINYC__))
	#undef PRId64
	#undef PRIi64
	#undef PRIo64
	#undef PRIu64
	#undef PRIx64
	#undef PRIX64
	#define PRId64 "lld"
	#define PRIi64 "lli"
	#define PRIo64 "llo"
	#define PRIu64 "llu"
	#define PRIx64 "llx"
	#define PRIX64 "llX"
#endif

//================================== GLOBALS =================================*/
//byte g_str_buf[1024];
byte* g_str_buf;
int load_so(byteptr);
void reload_so();
void _vinit();
void _vcleanup();
#define sigaction_size sizeof(sigaction);
#define _ARR_LEN(a) ( (sizeof(a)) / (sizeof(a[0])) )

// ============== wyhash ==============
//Author: Wang Yi
#ifndef wyhash_version_gamma
	#define wyhash_version_gamma
	#define WYHASH_CONDOM 0
	#include <stdint.h>
	#include <string.h>
	#if defined(_MSC_VER) && defined(_M_X64)
		#include <intrin.h>
		#pragma intrinsic(_umul128)
	#endif

	//const uint64_t _wyp0=0xa0761d6478bd642full, _wyp1=0xe7037ed1a0b428dbull;
	#define _wyp0 ((uint64_t)0xa0761d6478bd642full)
	#define _wyp1 ((uint64_t)0xe7037ed1a0b428dbull)

	#if defined(__GNUC__) || defined(__INTEL_COMPILER) || defined(__clang__) || defined(__TINYC__)
		#define _likely_(x) __builtin_expect(x, 1)
		#define _unlikely_(x) __builtin_expect((x), 0)
	#else
		#define _likely_(x) (x)
		#define _unlikely_(x) (x)
	#endif

	#if defined(TARGET_ORDER_IS_LITTLE)
		#define WYHASH_LITTLE_ENDIAN 1
	#elif defined(TARGET_ORDER_IS_BIG)
		#define WYHASH_LITTLE_ENDIAN 0
	#endif

	#if (WYHASH_LITTLE_ENDIAN)
		static inline uint64_t _wyr8(const uint8_t *p) { uint64_t v; memcpy(&v, p, 8); return v;}
		static inline uint64_t _wyr4(const uint8_t *p) { unsigned v; memcpy(&v, p, 4); return v;}
	#else
		#if defined(__GNUC__) || defined(__INTEL_COMPILER) || defined(__clang__)
			static inline uint64_t _wyr8(const uint8_t *p) { uint64_t v; memcpy(&v, p, 8); return __builtin_bswap64(v);}
			static inline uint64_t _wyr4(const uint8_t *p) { unsigned v; memcpy(&v, p, 4); return __builtin_bswap32(v);}
		#elif defined(_MSC_VER)
			static inline uint64_t _wyr8(const uint8_t *p) { uint64_t v; memcpy(&v, p, 8); return _byteswap_uint64(v);}
			static inline uint64_t _wyr4(const uint8_t *p) { unsigned v; memcpy(&v, p, 4); return _byteswap_ulong(v);}
		#elif defined(__TINYC__)
			static inline uint64_t _wyr8(const uint8_t *p) { uint64_t v; memcpy(&v, p, 8); return bswap_64(v);}
			static inline uint64_t _wyr4(const uint8_t *p) { unsigned v; memcpy(&v, p, 4); return bswap_32(v);}
		#endif
	#endif

	static inline uint64_t _wyr3(const uint8_t *p, unsigned k) { return (((uint64_t)p[0]) << 16) | (((uint64_t)p[k >> 1]) << 8) | p[k - 1];}
	static inline uint64_t _wyrotr(uint64_t v, unsigned k) { return (v >> k) | (v << (64 - k));}
	static inline void _wymix128(uint64_t A, uint64_t B, uint64_t *C, uint64_t *D){
		A^=*C;	B^=*D;
	#ifdef UNOFFICIAL_WYHASH_32BIT
		uint64_t hh=(A>>32)*(B>>32), hl=(A>>32)*(unsigned)B, lh=(unsigned)A*(B>>32), ll=(uint64_t)(unsigned)A*(unsigned)B;
		*C=_wyrotr(hl,32)^hh; *D=_wyrotr(lh,32)^ll;
	#else
		#ifdef __SIZEOF_INT128__
			__uint128_t r=A; r*=B; *C=(uint64_t)r; *D=(uint64_t)(r>>64);
		#elif defined(_MSC_VER) && defined(_M_X64)
			A=_umul128(A,B,&B); *C=A; *D=B;
		#else
			uint64_t ha=A>>32, hb=B>>32, la=(uint32_t)A, lb=(uint32_t)B, hi, lo;
			uint64_t rh=ha*hb, rm0=ha*lb, rm1=hb*la, rl=la*lb, t=rl+(rm0<<32), c=t<rl;
			lo=t+(rm1<<32); c+=lo<t; hi=rh+(rm0>>32)+(rm1>>32)+c;
			*C=lo;	*D=hi;
		#endif
	#endif
	}
	static inline uint64_t wyhash(const void *key, uint64_t len, uint64_t seed){
		const uint8_t *p=(const uint8_t *)key;
		uint64_t i=len, see1=seed;
		start:
		if (_likely_(i<=16)) {
	#ifndef	WYHASH_CONDOM
			uint64_t shift = (i<8)*((8-i)<<3);
			//WARNING: intended reading outside buffer, trading for speed.
			_wymix128((_wyr8(p)<<shift)^_wyp0, (_wyr8(p+i-8)>>shift)^_wyp1, &seed, &see1);
	#else
			if (_likely_(i<=8)) {
				if (_likely_(i>=4)) _wymix128(_wyr4(p)^_wyp0,_wyr4(p+i-4)^_wyp1, &seed, &see1);
				else if (_likely_(i)) _wymix128(_wyr3(p,i)^_wyp0,_wyp1, &seed, &see1);
				else _wymix128(_wyp0,_wyp1, &seed, &see1);
			}
			else _wymix128(_wyr8(p)^_wyp0,_wyr8(p+i-8)^_wyp1, &seed, &see1);
	#endif
			_wymix128(len,_wyp0, &seed, &see1);
			return	seed^see1;
		}
		_wymix128(_wyr8(p)^_wyp0,_wyr8(p+8)^_wyp1, &seed, &see1);
		i-=16;	p+=16;	goto start;
	}
	static inline uint64_t wyhash64(uint64_t A, uint64_t B){
		_wymix128(_wyp0,_wyp1,&A,&B);
		_wymix128(0,0,&A,&B);
		return	A^B;
	}
	static inline uint64_t wyrand(uint64_t *seed){
		*seed+=_wyp0;
		uint64_t	a=0, b=0;
		_wymix128(*seed,*seed^_wyp1,&a,&b);
		return	a^b;
	}
	static inline double wy2u01(uint64_t r) {
		const double _wynorm=1.0/(1ull<<52);
		return (r>>12)*_wynorm;
	}
	static inline double wy2gau(uint64_t r) {
		const double _wynorm=1.0/(1ull<<20);
		return ((r&0x1fffff)+((r>>21)&0x1fffff)+((r>>42)&0x1fffff))*_wynorm-3.0;
	}
#endif

voidptr memdup(voidptr src, int sz);
static voidptr memfreedup(voidptr ptr, voidptr src, int sz) {
	free(ptr);
	return memdup(src, sz);
}


// V includes:

#if defined(__TINYC__) && defined(__has_include)
// tcc does not support has_include properly yet, turn it off completely
#undef __has_include
#endif
// added by module `builtin`:

#if defined(__has_include)

#if __has_include(<float.h>)
#include <float.h>
#else
#error VERROR_MESSAGE Header file <float.h>, needed for module `builtin` was not found. Please install the corresponding development headers.
#endif

#else
#include <float.h>
#endif

// added by module `gencmd`:

#if defined(__has_include)

#if __has_include("gencmd.h")
#include "gencmd.h"
#else
#error VERROR_MESSAGE Header file "gencmd.h", needed for module `gencmd` was not found. Please install the corresponding development headers.
#endif

#else
#include "gencmd.h"
#endif


// Enum definitions:
typedef enum {
	strconv__Char_parse_state_start, // 
	strconv__Char_parse_state_norm_char, // +1
	strconv__Char_parse_state_field_char, // +2
	strconv__Char_parse_state_pad_ch, // +3
	strconv__Char_parse_state_len_set_start, // +4
	strconv__Char_parse_state_len_set_in, // +5
	strconv__Char_parse_state_check_type, // +6
	strconv__Char_parse_state_check_float, // +7
	strconv__Char_parse_state_check_float_in, // +8
	strconv__Char_parse_state_reset_params, // +9
} strconv__Char_parse_state;

typedef enum {
	strconv__Align_text_right = 0, // 0
	strconv__Align_text_left, // 0+1
	strconv__Align_text_center, // 0+2
} strconv__Align_text;

typedef enum {
	ChanState_success, // 
	ChanState_not_ready, // +1
	ChanState_closed, // +2
} ChanState;


// V type definitions:
struct string {
	byteptr str;
	int len;
	int is_lit;
};

struct array {
	int element_size;
	voidptr data;
	int len;
	int cap;
};

struct DenseArray {
	int key_bytes;
	int value_bytes;
	int slot_bytes;
	int cap;
	int len;
	u32 deletes;
	byte* all_deleted;
	byteptr data;
};

struct map {
	int key_bytes;
	int value_bytes;
	u32 even_index;
	byte cached_hashbits;
	byte shift;
	DenseArray key_values;
	u32* metas;
	u32 extra_metas;
	bool has_string_keys;
	MapHashFn hash_fn;
	MapEqFn key_eq_fn;
	MapCloneFn clone_fn;
	MapFreeFn free_fn;
	int len;
};

struct Option {
	bool ok;
	bool is_none;
	string v_error;
	int ecode;
};


// BEGIN_multi_return_typedefs
typedef struct multi_return_u32_u32 multi_return_u32_u32;
typedef struct multi_return_u32_u32_u32 multi_return_u32_u32_u32;
typedef struct multi_return_int_strconv__PrepNumber multi_return_int_strconv__PrepNumber;
typedef struct multi_return_u64_int multi_return_u64_int;
typedef struct multi_return_strconv__Dec32_bool multi_return_strconv__Dec32_bool;
typedef struct multi_return_strconv__Dec64_bool multi_return_strconv__Dec64_bool;
typedef struct multi_return_u64_u64 multi_return_u64_u64;
// END_multi_return_typedefs

typedef array array_string;
typedef array array_byte;
typedef array array_int;
typedef int (*anon_fn_7_7_7)(int,int);
typedef array array_voidptr;
typedef void (*FnExitCb)();
typedef array array_MethodArgs;
typedef array array_charptr;
typedef array array_byteptr;
typedef array array_RepIndex;
typedef map map_string_int;
typedef _Interface hash__Hasher;
typedef _Interface hash__Hash32er;
typedef _Interface hash__Hash64er;
typedef array array_u64;
typedef array array_u32;
typedef array array_strconv__Uint128;
typedef array array_f64;
typedef array array_rune;
// builtin types:
//------------------ #endbuiltin
typedef string array_fixed_string_11 [11];
struct ustring {
	string s;
	array_int runes;
	int len;
};

struct VAssertMetaInfo {
	string fpath;
	int line_nr;
	string fn_name;
	string src;
	string op;
	string llabel;
	string rlabel;
	string lvalue;
	string rvalue;
};

struct MethodArgs {
	int typ;
};

struct FunctionData {
	string name;
	array_string attrs;
	array_MethodArgs args;
	int return_type;
	int typ;
};

struct FieldData {
	string name;
	array_string attrs;
	bool is_pub;
	bool is_mut;
	int typ;
};

struct OptionBase {
	bool ok;
	bool is_none;
	string v_error;
	int ecode;
};

struct SortedMap {
	int value_bytes;
	mapnode* root;
	int len;
};

typedef voidptr array_fixed_voidptr_11 [11];
struct RepIndex {
	int idx;
	int val_idx;
};

struct strings__Builder {
	array_byte buf;
	int str_calls;
	int len;
	int initial_size;
};

struct strconv__PrepNumber {
	bool negative;
	int exponent;
	u64 mantissa;
};

union strconv__Float64u {
	f64 f;
	u64 u;
};

struct strconv__Dec32 {
	u32 m;
	int e;
};

union strconv__Uf32 {
	f32 f;
	u32 u;
};

struct strconv__Dec64 {
	u64 m;
	int e;
};

union strconv__Uf64 {
	f64 f;
	u64 u;
};

struct strconv__BF_param {
	byte pad_ch;
	int len0;
	int len1;
	bool positive;
	bool sign_flag;
	strconv__Align_text allign;
	bool rm_tail_zero;
};

struct strconv__Uint128 {
	u64 lo;
	u64 hi;
};

typedef byte array_fixed_byte_26 [26];
typedef byteptr array_fixed_byteptr_100 [100];
typedef byte array_fixed_byte_1000 [1000];
typedef byte array_fixed_byte_256 [256];
struct mapnode {
	voidptr* children;
	int len;
	array_fixed_string_11 keys;
	array_fixed_voidptr_11 values;
};


// BEGIN_multi_return_structs
struct multi_return_u32_u32 {
	u32 arg0;
	u32 arg1;
};

struct multi_return_u32_u32_u32 {
	u32 arg0;
	u32 arg1;
	u32 arg2;
};

struct multi_return_int_strconv__PrepNumber {
	int arg0;
	strconv__PrepNumber arg1;
};

struct multi_return_u64_int {
	u64 arg0;
	int arg1;
};

struct multi_return_strconv__Dec32_bool {
	strconv__Dec32 arg0;
	bool arg1;
};

struct multi_return_strconv__Dec64_bool {
	strconv__Dec64 arg0;
	bool arg1;
};

struct multi_return_u64_u64 {
	u64 arg0;
	u64 arg1;
};

// END_multi_return_structs

static bool array_byte_contains(array_byte a, byte v); // auto

// V Option_xxx definitions:
struct Option_int {
	bool ok;
	bool is_none;
	string v_error;
	int ecode;
	byte data[sizeof(int)];
};


// V json forward decls:

// V definitions:
void _STR_PRINT_ARG(const char*, char**, int*, int*, int, ...);
string _STR(const char*, int, ...);
string _STR_TMP(const char*, ...);
// end of definitions #endif
strings__Builder strings__new_builder(int initial_size);
void strings__Builder_write_bytes(strings__Builder* b, byteptr bytes, int howmany);
void strings__Builder_write_b(strings__Builder* b, byte data);
void strings__Builder_write(strings__Builder* b, string s);
void strings__Builder_go_back(strings__Builder* b, int n);
string strings__bytes2string(array_byte b);
string strings__Builder_cut_last(strings__Builder* b, int n);
void strings__Builder_go_back_to(strings__Builder* b, int pos);
void strings__Builder_writeln(strings__Builder* b, string s);
string strings__Builder_last_n(strings__Builder* b, int n);
string strings__Builder_after(strings__Builder* b, int n);
string strings__Builder_str(strings__Builder* b);
void strings__Builder_free(strings__Builder* b);
int strings__levenshtein_distance(string a, string b);
f32 strings__levenshtein_distance_percentage(string a, string b);
f32 strings__dice_coefficient(string s1, string s2);
string strings__repeat(byte c, int n);
string strings__repeat_string(string s, int n);
u64 hash__wyhash_c(byteptr key, u64 len, u64 seed);
u64 hash__wyhash64_c(u64 a, u64 b);
u64 _const_hash__wyp0; // inited later
u64 _const_hash__wyp1; // inited later
u64 _const_hash__wyp2; // inited later
u64 _const_hash__wyp3; // inited later
u64 _const_hash__wyp4; // inited later
u64 hash__sum64_string(string key, u64 seed);
u64 hash__sum64(array_byte key, u64 seed);
u64 hash__wyhash64(byteptr key, u64 len, u64 seed_);
u64 hash__wyrotr(u64 v, u32 k);
u64 hash__wymum(u64 a, u64 b);
u64 hash__wyr3(byteptr p, u64 k);
u64 hash__wyr4(byteptr p);
u64 hash__wyr8(byteptr p);
u32 _const_math__bits__de_bruijn32; // inited later
array_byte _const_math__bits__de_bruijn32tab; // inited later
u64 _const_math__bits__de_bruijn64; // inited later
array_byte _const_math__bits__de_bruijn64tab; // inited later
u64 _const_math__bits__m0; // inited later
u64 _const_math__bits__m1; // inited later
u64 _const_math__bits__m2; // inited later
u64 _const_math__bits__m3; // inited later
u64 _const_math__bits__m4; // inited later
u32 _const_math__bits__max_u32; // inited later
u64 _const_math__bits__max_u64; // inited later
int math__bits__leading_zeros_8(byte x);
int math__bits__leading_zeros_16(u16 x);
int math__bits__leading_zeros_32(u32 x);
int math__bits__leading_zeros_64(u64 x);
int math__bits__trailing_zeros_8(byte x);
int math__bits__trailing_zeros_16(u16 x);
int math__bits__trailing_zeros_32(u32 x);
int math__bits__trailing_zeros_64(u64 x);
int math__bits__ones_count_8(byte x);
int math__bits__ones_count_16(u16 x);
int math__bits__ones_count_32(u32 x);
int math__bits__ones_count_64(u64 x);
byte math__bits__rotate_left_8(byte x, int k);
u16 math__bits__rotate_left_16(u16 x, int k);
u32 math__bits__rotate_left_32(u32 x, int k);
u64 math__bits__rotate_left_64(u64 x, int k);
byte math__bits__reverse_8(byte x);
u16 math__bits__reverse_16(u16 x);
u32 math__bits__reverse_32(u32 x);
u64 math__bits__reverse_64(u64 x);
u16 math__bits__reverse_bytes_16(u16 x);
u32 math__bits__reverse_bytes_32(u32 x);
u64 math__bits__reverse_bytes_64(u64 x);
int math__bits__len_8(byte x);
int math__bits__len_16(u16 x);
int math__bits__len_32(u32 x);
int math__bits__len_64(u64 x);
multi_return_u32_u32 math__bits__add_32(u32 x, u32 y, u32 carry);
multi_return_u64_u64 math__bits__add_64(u64 x, u64 y, u64 carry);
multi_return_u32_u32 math__bits__sub_32(u32 x, u32 y, u32 borrow);
multi_return_u64_u64 math__bits__sub_64(u64 x, u64 y, u64 borrow);
u64 _const_math__bits__two32; // inited later
u64 _const_math__bits__mask32; // inited later
string _const_math__bits__overflow_error; // a string literal, inited later
string _const_math__bits__divide_error; // a string literal, inited later
multi_return_u32_u32 math__bits__mul_32(u32 x, u32 y);
multi_return_u64_u64 math__bits__mul_64(u64 x, u64 y);
multi_return_u32_u32 math__bits__div_32(u32 hi, u32 lo, u32 y);
multi_return_u64_u64 math__bits__div_64(u64 hi, u64 lo, u64 y1);
u32 math__bits__rem_32(u32 hi, u32 lo, u32 y);
u64 math__bits__rem_64(u64 hi, u64 lo, u64 y);
array_byte _const_math__bits__ntz_8_tab; // inited later
array_byte _const_math__bits__pop_8_tab; // inited later
array_byte _const_math__bits__rev_8_tab; // inited later
array_byte _const_math__bits__len_8_tab; // inited later
multi_return_u32_u32_u32 strconv__lsr96(u32 s2, u32 s1, u32 s0);
multi_return_u32_u32_u32 strconv__lsl96(u32 s2, u32 s1, u32 s0);
multi_return_u32_u32_u32 strconv__add96(u32 s2, u32 s1, u32 s0, u32 d2, u32 d1, u32 d0);
multi_return_u32_u32_u32 strconv__sub96(u32 s2, u32 s1, u32 s0, u32 d2, u32 d1, u32 d0);
#define _const_strconv__digits 18
u64 _const_strconv__double_plus_zero; // inited later
u64 _const_strconv__double_minus_zero; // inited later
u64 _const_strconv__double_plus_infinity; // inited later
u64 _const_strconv__double_minus_infinity; // inited later
#define _const_strconv__fsm_a 0
#define _const_strconv__fsm_b 1
#define _const_strconv__fsm_c 2
#define _const_strconv__fsm_d 3
#define _const_strconv__fsm_e 4
#define _const_strconv__fsm_f 5
#define _const_strconv__fsm_g 6
#define _const_strconv__fsm_h 7
#define _const_strconv__fsm_i 8
#define _const_strconv__fsm_stop 9
#define _const_strconv__parser_ok 0
#define _const_strconv__parser_pzero 1
#define _const_strconv__parser_mzero 2
#define _const_strconv__parser_pinf 3
#define _const_strconv__parser_minf 4
#define _const_strconv__c_dpoint '.'
#define _const_strconv__c_plus '+'
#define _const_strconv__c_minus '-'
#define _const_strconv__c_zero '0'
#define _const_strconv__c_nine '9'
u32 _const_strconv__c_ten; // inited later
bool strconv__is_digit(byte x);
bool strconv__is_space(byte x);
bool strconv__is_exp(byte x);
multi_return_int_strconv__PrepNumber strconv__parser(string s);
u64 strconv__converter(strconv__PrepNumber* pn);
f64 strconv__atof64(string s);
f64 strconv__atof_quick(string s);
array_u64 _const_strconv__pos_exp; // inited later
array_u64 _const_strconv__neg_exp; // inited later
#define _const_strconv__int_size 32
u64 _const_strconv__max_u64; // inited later
byte strconv__byte_to_lower(byte c);
u64 strconv__common_parse_uint(string s, int _base, int _bit_size, bool error_on_non_digit, bool error_on_high_digit);
multi_return_u64_int strconv__common_parse_uint2(string s, int _base, int _bit_size);
u64 strconv__parse_uint(string s, int _base, int _bit_size);
i64 strconv__common_parse_int(string _s, int base, int _bit_size, bool error_on_non_digit, bool error_on_high_digit);
i64 strconv__parse_int(string _s, int base, int _bit_size);
Option_int strconv__atoi(string s);
bool strconv__underscore_ok(string s);
array_u32 _const_strconv__ten_pow_table_32; // inited later
u32 _const_strconv__mantbits32; // inited later
u32 _const_strconv__expbits32; // inited later
#define _const_strconv__bias32 127
#define _const_strconv__maxexp32 255
string strconv__Dec32_get_string_32(strconv__Dec32 d, bool neg, int i_n_digit, int i_pad_digit);
multi_return_strconv__Dec32_bool strconv__f32_to_decimal_exact_int(u32 i_mant, u32 exp);
strconv__Dec32 strconv__f32_to_decimal(u32 mant, u32 exp);
string strconv__f32_to_str(f32 f, int n_digit);
string strconv__f32_to_str_pad(f32 f, int n_digit);
array_u64 _const_strconv__ten_pow_table_64; // inited later
u32 _const_strconv__mantbits64; // inited later
u32 _const_strconv__expbits64; // inited later
#define _const_strconv__bias64 1023
#define _const_strconv__maxexp64 2047
string strconv__Dec64_get_string_64(strconv__Dec64 d, bool neg, int i_n_digit, int i_pad_digit);
multi_return_strconv__Dec64_bool strconv__f64_to_decimal_exact_int(u64 i_mant, u64 exp);
strconv__Dec64 strconv__f64_to_decimal(u64 mant, u64 exp);
string strconv__f64_to_str(f64 f, int n_digit);
string strconv__f64_to_str_pad(f64 f, int n_digit);
array_f64 _const_strconv__dec_round; // inited later
string strconv__f64_to_str_lnd(f64 f, int dec_digit);
string strconv__format_str(string s, strconv__BF_param p);
string strconv__format_dec(u64 d, strconv__BF_param p);
string strconv__format_fl(f64 f, strconv__BF_param p);
string strconv__format_es(f64 f, strconv__BF_param p);
string strconv__remove_tail_zeros(string s);
void strconv__v_printf(string str, array_voidptr pt);
string strconv__v_sprintf(string str, array_voidptr pt);
void strconv__v_sprintf_panic(int idx, int len);
f64 strconv__fabs(f64 x);
string strconv__ftoa_64(f64 f);
string strconv__ftoa_long_64(f64 f);
string strconv__ftoa_32(f32 f);
string strconv__ftoa_long_32(f32 f);
#define _const_strconv__pow5_num_bits_32 61
#define _const_strconv__pow5_inv_num_bits_32 59
#define _const_strconv__pow5_num_bits_64 121
#define _const_strconv__pow5_inv_num_bits_64 122
array_u64 _const_strconv__powers_of_10; // inited later
array_u64 _const_strconv__pow5_split_32; // inited later
array_u64 _const_strconv__pow5_inv_split_32; // inited later
array_strconv__Uint128 _const_strconv__pow5_split_64; // inited later
array_strconv__Uint128 _const_strconv__pow5_inv_split_64; // inited later
void strconv__assert1(bool t, string msg);
int strconv__bool_to_int(bool b);
u32 strconv__bool_to_u32(bool b);
u64 strconv__bool_to_u64(bool b);
string strconv__get_string_special(bool neg, bool expZero, bool mantZero);
int strconv__decimal_len_32(u32 u);
u32 strconv__mul_shift_32(u32 m, u64 mul, int ishift);
u32 strconv__mul_pow5_invdiv_pow2(u32 m, u32 q, int j);
u32 strconv__mul_pow5_div_pow2(u32 m, u32 i, int j);
u32 strconv__pow5_factor_32(u32 i_v);
bool strconv__multiple_of_power_of_five_32(u32 v, u32 p);
bool strconv__multiple_of_power_of_two_32(u32 v, u32 p);
u32 strconv__log10_pow2(int e);
u32 strconv__log10_pow5(int e);
int strconv__pow5_bits(int e);
int strconv__decimal_len_64(u64 u);
u64 strconv__shift_right_128(strconv__Uint128 v, int shift);
u64 strconv__mul_shift_64(u64 m, strconv__Uint128 mul, int shift);
u32 strconv__pow5_factor_64(u64 v_i);
bool strconv__multiple_of_power_of_five_64(u64 v, u32 p);
bool strconv__multiple_of_power_of_two_64(u64 v, u32 p);
string strconv__f32_to_str_l(f64 f);
string strconv__f64_to_str_l(f64 f);
array __new_array(int mylen, int cap, int elm_size);
array __new_array_with_default(int mylen, int cap, int elm_size, voidptr val);
array __new_array_with_array_default(int mylen, int cap, int elm_size, array val);
array new_array_from_c_array(int len, int cap, int elm_size, voidptr c_array);
array new_array_from_c_array_no_alloc(int len, int cap, int elm_size, voidptr c_array);
void array_ensure_cap(array* a, int required);
array array_repeat(array a, int count);
void array_sort_with_compare(array* a, voidptr compare);
void array_insert(array* a, int i, voidptr val);
void array_insert_many(array* a, int i, voidptr val, int size);
void array_prepend(array* a, voidptr val);
void array_prepend_many(array* a, voidptr val, int size);
void array_delete(array* a, int i);
void array_clear(array* a);
void array_trim(array* a, int index);
voidptr array_get_unsafe(array a, int i);
voidptr array_get(array a, int i);
voidptr array_first(array a);
voidptr array_last(array a);
voidptr array_pop(array* a);
void array_delete_last(array* a);
array array_slice(array a, int start, int _end);
array array_slice2(array a, int start, int _end, bool end_max);
array array_clone_static(array a);
array array_clone(array* a);
array array_slice_clone(array* a, int start, int _end);
void array_set_unsafe(array* a, int i, voidptr val);
void array_set(array* a, int i, voidptr val);
void array_push(array* a, voidptr val);
void array_push_many(array* a3, voidptr val, int size);
void array_reverse_in_place(array* a);
array array_reverse(array a);
void array_free(array* a);
string array_string_str(array_string a);
string array_byte_hex(array_byte b);
int copy(array_byte dst, array_byte src);
int compare_ints(int* a, int* b);
int compare_ints_reverse(int* a, int* b);
int compare_u64s(u64* a, u64* b);
int compare_u64s_reverse(u64* a, u64* b);
int compare_floats(f64* a, f64* b);
int compare_floats_reverse(f64* a, f64* b);
void array_int_sort(array_int* a);
int array_string_index(array_string a, string v);
int array_int_reduce(array_int a, int (*iter)(int , int ), int accum_start);
void array_grow_cap(array* a, int amount);
void array_grow_len(array* a, int amount);
bool array_string_eq(array_string a1, array_string a2);
int compare_i64(i64* a, i64* b);
int compare_f64(f64* a, f64* b);
int compare_f32(f32* a, f32* b);
array_voidptr array_pointers(array a);
array_byte voidptr_vbytes(voidptr data, int len);
array_byte byteptr_vbytes(byteptr data, int len);
void v_exit(int code);
void panic_debug(int line_no, string file, string mod, string fn_name, string s);
void v_panic(string s);
void eprintln(string s);
void eprint(string s);
void print(string s);
void println(string s);
byteptr v_malloc(int n);
byteptr v_realloc(byteptr b, int n);
byteptr v_calloc(int n);
byteptr vcalloc(int n);
void v_free(voidptr ptr);
voidptr memdup(voidptr src, int sz);
void v_ptr_free(voidptr ptr);
int is_atty(int fd);
byteptr g_m2_buf; // global
byteptr g_m2_ptr; // global
bool isnil(voidptr v);
void print_backtrace();
i64 total_m = 0; // global
int nr_mallocs = 0; // global
voidptr __as_cast(voidptr obj, int obj_type, int expected_type);
void __print_assert_failure(VAssertMetaInfo* i);
void builtin_init();
bool print_backtrace_skipping_top_frames(int xskipframes);
bool print_backtrace_skipping_top_frames_mac(int skipframes);
bool print_backtrace_skipping_top_frames_freebsd(int skipframes);
bool print_backtrace_skipping_top_frames_linux(int skipframes);
void break_if_debugger_attached();
int proc_pidpath(int , voidptr , int );
void chan_close(chan ch);
ChanState chan_try_pop(chan ch, voidptr obj);
ChanState chan_try_push(chan ch, voidptr obj);
string f64_str(f64 x);
string any_float_str(any_float d);
string f64_strsci(f64 x, int digit_num);
string f64_strlong(f64 x);
string f32_str(f32 x);
string f32_strsci(f32 x, int digit_num);
string f32_strlong(f32 x);
f32 f32_abs(f32 a);
f64 f64_abs(f64 a);
f32 f32_max(f32 a, f32 b);
f32 f32_min(f32 a, f32 b);
f64 f64_max(f64 a, f64 b);
f64 f64_min(f64 a, f64 b);
bool f32_eq_epsilon(f32 a, f32 b);
bool f64_eq_epsilon(f64 a, f64 b);
string ptr_str(voidptr ptr);
string _const_digit_pairs; // a string literal, inited later
string int_str_l(int nn, int max);
string i8_str(i8 n);
string i16_str(i16 n);
string u16_str(u16 n);
string int_str(int n);
string u32_str(u32 nn);
string any_int_str(any_int n);
string i64_str(i64 nn);
string u64_str(u64 nn);
string bool_str(bool b);
string u64_to_hex(u64 nn, byte len);
string u64_to_hex_no_leading_zeros(u64 nn, byte len);
string byte_hex(byte nn);
string i8_hex(i8 nn);
string u16_hex(u16 nn);
string i16_hex(i16 nn);
string u32_hex(u32 nn);
string int_hex(int nn);
string int_hex2(int n);
string u64_hex(u64 nn);
string i64_hex(i64 nn);
string any_int_hex(any_int nn);
string voidptr_str(voidptr nn);
string byteptr_str(byteptr nn);
string u64_hex_full(u64 nn);
string byte_str(byte b);
string byte_str_escaped(byte b);
#define _const_hashbits 24
#define _const_max_cached_hashbits 16
#define _const_init_log_capicity 5
int _const_init_capicity; // inited later
#define _const_max_load_factor 0.8
int _const_init_even_index; // inited later
#define _const_extra_metas_inc 4
u32 _const_hash_mask; // inited later
u32 _const_probe_inc; // inited later
bool fast_string_eq(string a, string b);
DenseArray new_dense_array(int key_bytes, int value_bytes);
voidptr DenseArray_key(DenseArray* d, int i);
voidptr DenseArray_value(DenseArray* d, int i);
bool DenseArray_has_index(DenseArray* d, int i);
int DenseArray_expand(DenseArray* d);
void DenseArray_zeros_to_end(DenseArray* d);
u64 map_hash_string(voidptr pkey);
u64 map_hash_int_1(voidptr pkey);
u64 map_hash_int_2(voidptr pkey);
u64 map_hash_int_4(voidptr pkey);
u64 map_hash_int_8(voidptr pkey);
bool map_eq_string(voidptr a, voidptr b);
bool map_eq_int_1(voidptr a, voidptr b);
bool map_eq_int_2(voidptr a, voidptr b);
bool map_eq_int_4(voidptr a, voidptr b);
bool map_eq_int_8(voidptr a, voidptr b);
void map_clone_string(voidptr dest, voidptr pkey);
void map_clone_int_1(voidptr dest, voidptr pkey);
void map_clone_int_2(voidptr dest, voidptr pkey);
void map_clone_int_4(voidptr dest, voidptr pkey);
void map_clone_int_8(voidptr dest, voidptr pkey);
void map_free_string(voidptr pkey);
void map_free_nop(voidptr _);
map new_map_2(int key_bytes, int value_bytes, MapHashFn hash_fn, MapEqFn key_eq_fn, MapCloneFn clone_fn, MapFreeFn free_fn);
map new_map_init_2(MapHashFn hash_fn, MapEqFn key_eq_fn, MapCloneFn clone_fn, MapFreeFn free_fn, int n, int key_bytes, int value_bytes, voidptr keys, voidptr values);
multi_return_u32_u32 map_key_to_index(map* m, voidptr pkey);
multi_return_u32_u32 map_meta_less(map* m, u32 _index, u32 _metas);
void map_meta_greater(map* m, u32 _index, u32 _metas, u32 kvi);
void map_ensure_extra_metas(map* m, u32 probe_count);
void map_set_1(map* m, voidptr key, voidptr value);
void map_expand(map* m);
void map_rehash(map* m);
void map_cached_rehash(map* m, u32 old_cap);
voidptr map_get_and_set_1(map* m, voidptr key, voidptr zero);
voidptr map_get_1(map* m, voidptr key, voidptr zero);
bool map_exists_1(map* m, voidptr key);
void DenseArray_delete(DenseArray* d, int i);
void map_delete(map* m, string key);
void map_delete_1(map* m, voidptr key);
array_string map_keys(map* m);
array map_keys_1(map* m);
DenseArray DenseArray_clone(DenseArray* d);
map map_clone(map* m);
void map_free(map* m);
void opt_ok2(voidptr data, OptionBase* option, int size);
string Option_str(Option o);
Option opt_none();
Option v_error(string message);
Option error_with_code(string message, int code);
string rune_str(rune c);
bool byte_is_capital(byte c);
array_byte array_byte_clone(array_byte b);
string array_byte_bytestr(array_byte b);
string bytes2string(array_byte b);
#define _const_degree 6
int _const_mid_index; // inited later
int _const_max_len; // inited later
u32 _const_children_bytes; // inited later
SortedMap new_sorted_map(int n, int value_bytes);
SortedMap new_sorted_map_init(int n, int value_bytes, string* keys, voidptr values);
mapnode* new_node();
void SortedMap_set(SortedMap* m, string key, voidptr value);
void mapnode_split_child(mapnode* n, int child_index, mapnode* y);
bool SortedMap_get(SortedMap m, string key, voidptr out);
bool SortedMap_exists(SortedMap m, string key);
int mapnode_find_key(mapnode* n, string k);
bool mapnode_remove_key(mapnode* n, string k);
void mapnode_remove_from_leaf(mapnode* n, int idx);
void mapnode_remove_from_non_leaf(mapnode* n, int idx);
void mapnode_fill(mapnode* n, int idx);
void mapnode_borrow_from_prev(mapnode* n, int idx);
void mapnode_borrow_from_next(mapnode* n, int idx);
void mapnode_merge(mapnode* n, int idx);
void SortedMap_delete(SortedMap* m, string key);
int mapnode_subkeys(mapnode* n, array_string* keys, int at);
array_string SortedMap_keys(SortedMap* m);
void mapnode_free(mapnode* n);
void SortedMap_free(SortedMap* m);
void SortedMap_print(SortedMap m);
int vstrlen(byteptr s);
string tos(byteptr s, int len);
string tos_clone(byteptr s);
string tos2(byteptr s);
string tos3(charptr s);
string tos4(byteptr s);
string tos5(charptr s);
string tos_lit(charptr s);
string byteptr_vstring(byteptr bp);
string byteptr_vstring_with_len(byteptr bp, int len);
string charptr_vstring(charptr cp);
string charptr_vstring_with_len(charptr cp, int len);
string string_clone_static(string a);
string string_clone(string a);
string cstring_to_vstring(byteptr cstr);
string string_replace_once(string s, string rep, string with);
string string_replace(string s, string rep, string with);
int compare_rep_index(RepIndex* a, RepIndex* b);
void array_RepIndex_sort2(array_RepIndex* a);
string string_replace_each(string s, array_string vals);
bool string_bool(string s);
int string_int(string s);
i64 string_i64(string s);
i8 string_i8(string s);
i16 string_i16(string s);
f32 string_f32(string s);
f64 string_f64(string s);
u16 string_u16(string s);
u32 string_u32(string s);
u64 string_u64(string s);
bool string_eq(string s, string a);
bool string_ne(string s, string a);
bool string_lt(string s, string a);
bool string_le(string s, string a);
bool string_gt(string s, string a);
bool string_ge(string s, string a);
string string_add(string s, string a);
array_string string_split(string s, string delim);
array_string string_split_nth(string s, string delim, int nth);
array_string string_split_into_lines(string s);
string string_left(string s, int n);
string string_right(string s, int n);
string string_substr2(string s, int start, int _end, bool end_max);
string string_substr(string s, int start, int end);
int string_index_old(string s, string p);
Option_int string_index(string s, string p);
int string_index_kmp(string s, string p);
int string_index_any(string s, string chars);
Option_int string_last_index(string s, string p);
int string_index_after(string s, string p, int start);
int string_index_byte(string s, byte c);
int string_last_index_byte(string s, byte c);
int string_count(string s, string substr);
bool string_contains(string s, string substr);
bool string_contains_any(string s, string chars);
bool string_contains_any_substr(string s, array_string substrs);
bool string_starts_with(string s, string p);
bool string_ends_with(string s, string p);
string string_to_lower(string s);
bool string_is_lower(string s);
string string_to_upper(string s);
bool string_is_upper(string s);
string string_capitalize(string s);
bool string_is_capital(string s);
string string_title(string s);
bool string_is_title(string s);
string string_find_between(string s, string start, string end);
bool byte_is_space(byte c);
string string_trim_space(string s);
string string_trim(string s, string cutset);
string string_trim_left(string s, string cutset);
string string_trim_right(string s, string cutset);
string string_trim_prefix(string s, string str);
string string_trim_suffix(string s, string str);
int compare_strings(string* a, string* b);
int compare_strings_reverse(string* a, string* b);
int compare_strings_by_len(string* a, string* b);
int compare_lower_strings(string* a, string* b);
void array_string_sort(array_string* s);
void array_string_sort_ignore_case(array_string* s);
void array_string_sort_by_len(array_string* s);
string string_str(string s);
string ustring_str(ustring s);
ustring string_ustring(string s);
array_int g_ustring_runes; // global
ustring string_ustring_tmp(string s);
bool ustring_eq(ustring u, ustring a);
bool ustring_ne(ustring u, ustring a);
bool ustring_lt(ustring u, ustring a);
bool ustring_le(ustring u, ustring a);
bool ustring_gt(ustring u, ustring a);
bool ustring_ge(ustring u, ustring a);
ustring ustring_add(ustring u, ustring a);
int ustring_index_after(ustring u, ustring p, int start);
int ustring_count(ustring u, ustring substr);
string ustring_substr(ustring u, int _start, int _end);
string ustring_left(ustring u, int pos);
string ustring_right(ustring u, int pos);
byte string_at(string s, int idx);
string ustring_at(ustring u, int idx);
void ustring_free(ustring* u);
bool byte_is_digit(byte c);
bool byte_is_hex_digit(byte c);
bool byte_is_oct_digit(byte c);
bool byte_is_bin_digit(byte c);
bool byte_is_letter(byte c);
void string_free(string* s);
string string_all_before(string s, string dot);
string string_all_before_last(string s, string dot);
string string_all_after(string s, string dot);
string string_all_after_last(string s, string dot);
string string_after(string s, string dot);
string string_after_char(string s, byte dot);
string array_string_join(array_string a, string del);
string array_string_join_lines(array_string s);
string string_reverse(string s);
string string_limit(string s, int max);
bool byte_is_white(byte c);
int string_hash(string s);
array_byte string_bytes(string s);
string string_repeat(string s, int count);
array_string string_fields(string s);
string string_strip_margin(string s);
string string_strip_margin_custom(string s, byte del);
array_string string_split_by_whitespace(string s);
#define _const_cp_utf8 65001
u16* string_to_wide(string _str);
string string_from_wide(u16* _wstr);
string string_from_wide2(u16* _wstr, int len);
int utf8_getchar();
int utf8_char_len(byte b);
string utf32_to_str(u32 code);
string utf32_to_str_no_malloc(u32 code, voidptr buf);
int string_utf32_code(string _rune);
int utf8_len(byte c);
int utf8_str_len(string s);
int utf8_str_visible_length(string s);
string gencmd__gencmd(string cmd);

// V interface table:
// ^^^ number of types for interface hash__Hasher: 0

// Methods wrapper for interface "hash__Hasher"

typedef array_byte (*_hash__Hasher_sum_fn)(void* _, array_byte b);
typedef int (*_hash__Hasher_size_fn)(void* _);
typedef int (*_hash__Hasher_block_size_fn)(void* _);

struct _hash__Hasher_interface_methods {
	_hash__Hasher_sum_fn sum;
	_hash__Hasher_size_fn size;
	_hash__Hasher_block_size_fn block_size;
};

static struct _hash__Hasher_interface_methods hash__Hasher_name_table[1];


// Casting functions for interface "hash__Hasher"
// ^^^ number of types for interface hash__Hash32er: 0

// Methods wrapper for interface "hash__Hash32er"

typedef u32 (*_hash__Hash32er_sum32_fn)(void* _);

struct _hash__Hash32er_interface_methods {
	_hash__Hash32er_sum32_fn sum32;
};

static struct _hash__Hash32er_interface_methods hash__Hash32er_name_table[1];


// Casting functions for interface "hash__Hash32er"
// ^^^ number of types for interface hash__Hash64er: 0

// Methods wrapper for interface "hash__Hash64er"

typedef u64 (*_hash__Hash64er_sum64_fn)(void* _);

struct _hash__Hash64er_interface_methods {
	_hash__Hash64er_sum64_fn sum64;
};

static struct _hash__Hash64er_interface_methods hash__Hash64er_name_table[1];


// Casting functions for interface "hash__Hash64er"

// V option typedefs:
typedef struct {
			int  data;
			string error;
			int    ecode;
			bool   ok;
			bool   is_none;
		} Option2_int;

// V stringliterals:

// >> string literal consts
void vinit_string_literals(){
	_const_math__bits__overflow_error = _SLIT("Overflow Error");
	_const_math__bits__divide_error = _SLIT("Divide Error");
	_const_digit_pairs = _SLIT("00102030405060708090011121314151617181910212223242526272829203132333435363738393041424344454647484940515253545556575859506162636465666768696071727374757677787970818283848586878889809192939495969798999");
}
// << string literal consts

static bool array_byte_contains(array_byte a, byte v) {
	for (int i = 0; i < a.len; ++i) {
		if ((*(byte*)array_get(a, i)) == v) {
			return true;
		}
	}
	return false;
}


// V out

// >> typeof() support for sum types
// << typeof() support for sum types


void _STR_PRINT_ARG(const char *fmt, char** refbufp, int *nbytes, int *memsize, int guess, ...) {
	va_list args;
	va_start(args, guess);
	// NB: (*memsize - *nbytes) === how much free space is left at the end of the current buffer refbufp
	// *memsize === total length of the buffer refbufp
	// *nbytes === already occupied bytes of buffer refbufp
	// guess === how many bytes were taken during the current vsnprintf run
	for(;;) {
		if (guess < *memsize - *nbytes) {
			guess = vsnprintf(*refbufp + *nbytes, *memsize - *nbytes, fmt, args);
			if (guess < *memsize - *nbytes) { // result did fit into buffer
				*nbytes += guess;
				break;
			}
		}
		// increase buffer (somewhat exponentially)
		*memsize += (*memsize + *memsize) / 3 + guess;
		*refbufp = (char*)realloc((void*)*refbufp, *memsize);
	}
	va_end(args);
}

string _STR(const char *fmt, int nfmts, ...) {
	va_list argptr;
	int memsize = 128;
	int nbytes = 0;
	char* buf = (char*)malloc(memsize);
	va_start(argptr, nfmts);
	for (int i=0; i<nfmts; ++i) {
		int k = strlen(fmt);
		bool is_fspec = false;
		for (int j=0; j<k; ++j) {
			if (fmt[j] == '%') {
				j++;
				if (fmt[j] != '%') {
					is_fspec = true;
					break;
				}
			}
		}
		if (is_fspec) {
			char f = fmt[k-1];
			char fup = f & 0xdf; // toupper
			bool l = fmt[k-2] == 'l';
			bool ll = l && fmt[k-3] == 'l';
			if (f == 'u' || fup == 'X' || f == 'o' || f == 'd' || f == 'c') { // int...
				if (ll) _STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+16, va_arg(argptr, long long));
				else if (l) _STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+10, va_arg(argptr, long));
				else _STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+8, va_arg(argptr, int));
			} else if (fup >= 'E' && fup <= 'G') { // floating point
				_STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+10, va_arg(argptr, double));
			} else if (f == 'p') {
				_STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+14, va_arg(argptr, void*));
			} else if (f == 's') { // v string
				string s = va_arg(argptr, string);
				if (fmt[k-4] == '*') { // %*.*s
					int fwidth = va_arg(argptr, int);
					if (fwidth < 0)
						fwidth -= (s.len - utf8_str_visible_length(s));
					else
						fwidth += (s.len - utf8_str_visible_length(s));
					_STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+s.len-4, fwidth, s.len, s.str);
				} else { // %.*s
					_STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k+s.len-4, s.len, s.str);
				}
			} else {
				//v_panic(tos3('Invaid format specifier'));
			}
		} else {
			_STR_PRINT_ARG(fmt, &buf, &nbytes, &memsize, k);
		}
		fmt += k+1;
	}
	va_end(argptr);
	buf[nbytes] = 0;
	buf = (char*)realloc((void*)buf, nbytes+1);
#ifdef DEBUG_ALLOC
	//puts('_STR:');
	puts(buf);
#endif
#if _VAUTOFREE
	//g_cur_str = (byteptr)buf;
#endif
	return tos2((byteptr)buf);
}

string _STR_TMP(const char *fmt, ...) {
	va_list argptr;
	va_start(argptr, fmt);
	size_t len = vsnprintf(0, 0, fmt, argptr) + 1;
	va_end(argptr);
	va_start(argptr, fmt);
	vsprintf((char *)g_str_buf, fmt, argptr);
	va_end(argptr);

#ifdef DEBUG_ALLOC
	//puts('_STR_TMP:');
	//puts(g_str_buf);
#endif
	string res = tos(g_str_buf,  len);
	res.is_lit = 1;
	return res;

} // endof _STR_TMP


strings__Builder strings__new_builder(int initial_size) {
	return (strings__Builder){.buf = __new_array_with_default(0, initial_size, sizeof(byte), 0),.str_calls = 0,.len = 0,.initial_size = initial_size,};
}

void strings__Builder_write_bytes(strings__Builder* b, byteptr bytes, int howmany) {
	array_push_many(&b->buf, bytes, howmany);
	b->len += howmany;
}

void strings__Builder_write_b(strings__Builder* b, byte data) {
	array_push(&b->buf, _MOV((byte[]){ data }));
	b->len++;
}

// Attr: [inline]
inline void strings__Builder_write(strings__Builder* b, string s) {
	if ((s).len == 0) {
		return;
	}
	array_push_many(&b->buf, s.str, s.len);
	b->len += s.len;
}

void strings__Builder_go_back(strings__Builder* b, int n) {
	array_trim(&b->buf, b->buf.len - n);
	b->len -= n;
}

string strings__bytes2string(array_byte b) {
	array_byte copy = array_clone(&b);
	array_push(&copy, _MOV((byte[]){ ((byte)('\0')) }));
	string res = tos(copy.data, copy.len - 1);
	return res;
}

string strings__Builder_cut_last(strings__Builder* b, int n) {
	string res = strings__bytes2string(array_slice(b->buf, b->len - n, b->buf.len));
	array_trim(&b->buf, b->buf.len - n);
	b->len -= n;
	return res;
}

void strings__Builder_go_back_to(strings__Builder* b, int pos) {
	array_trim(&b->buf, pos);
	b->len = pos;
}

// Attr: [inline]
inline void strings__Builder_writeln(strings__Builder* b, string s) {
	array_push_many(&b->buf, s.str, s.len);
	array_push(&b->buf, _MOV((byte[]){ '\n' }));
	b->len += s.len + 1;
}

string strings__Builder_last_n(strings__Builder* b, int n) {
	if (n > b->len) {
		return _SLIT("");
	}
	return strings__bytes2string(array_slice(b->buf, b->len - n, b->buf.len));
}

string strings__Builder_after(strings__Builder* b, int n) {
	if (n >= b->len) {
		return _SLIT("");
	}
	return strings__bytes2string(array_slice(b->buf, n, b->buf.len));
}

string strings__Builder_str(strings__Builder* b) {
	b->str_calls++;
	if (b->str_calls > 1) {
		panic_debug(127, tos3("/DATA/projects/web/v/v/vlib/strings/builder.v"), tos3("strings"), tos3("str"),  _SLIT("builder.str() should be called just once.\nIf you want to reuse a builder, call b.free() first."));
	}
	array_push(&b->buf, _MOV((byte[]){ '\0' }));
	string s = tos(b->buf.data, b->len);
	int bis = b->initial_size;
	b->buf = __new_array_with_default(0, bis, sizeof(byte), 0);
	b->len = 0;
	return s;
}

void strings__Builder_free(strings__Builder* b) {
	v_free(b->buf.data);
	b->len = 0;
	b->str_calls = 0;
}

int strings__levenshtein_distance(string a, string b) {
	array_int f = array_repeat(new_array_from_c_array(1, 1, sizeof(int), _MOV((int[1]){0})), b.len + 1);
	for (int j = 0; j < f.len; ++j) {
		array_set(&f, j, &(int[]) { j });
	}
	for (int _t5 = 0; _t5 < a.len; ++_t5) {
		byte ca = a.str[_t5];
		int j = 1;
		int fj1 = (*(int*)/*ee elem_typ */array_get(f, 0));
		(*(int*)/*ee elem_typ */array_get(f, 0))++;
		for (int _t6 = 0; _t6 < b.len; ++_t6) {
			byte cb = b.str[_t6];
			int mn = ((*(int*)/*ee elem_typ */array_get(f, j)) + 1 <= (*(int*)/*ee elem_typ */array_get(f, j - 1)) + 1 ? ((*(int*)/*ee elem_typ */array_get(f, j)) + 1) : ((*(int*)/*ee elem_typ */array_get(f, j - 1)) + 1));
			if (cb != ca) {
				mn = (mn <= fj1 + 1 ? (mn) : (fj1 + 1));
			} else {
				mn = (mn <= fj1 ? (mn) : (fj1));
			}
			fj1 = (*(int*)/*ee elem_typ */array_get(f, j));
			array_set(&f, j, &(int[]) { mn });
			j++;
		}
	}
	return (*(int*)/*ee elem_typ */array_get(f, f.len - 1));
}

f32 strings__levenshtein_distance_percentage(string a, string b) {
	int d = strings__levenshtein_distance(a, b);
	int l = (a.len >= b.len ? (a.len) : (b.len));
	return (1.00 - ((f32)(d)) / ((f32)(l))) * 100.00;
}

f32 strings__dice_coefficient(string s1, string s2) {
	if (s1.len == 0 || s2.len == 0) {
		return 0.0;
	}
	if (string_eq(s1, s2)) {
		return 1.0;
	}
	if (s1.len < 2 || s2.len < 2) {
		return 0.0;
	}
	string a = (s1.len > s2.len ? (s1) : (s2));
	string b = (string_eq(a, s1) ? (s2) : (s1));
	map_string_int first_bigrams = new_map_2(sizeof(string), sizeof(int), &map_hash_string, &map_eq_string, &map_clone_string, &map_free_string);
	for (int i = 0; i < a.len - 1; ++i) {
		string bigram = string_substr(a, i, i + 2);
		int q = (_IN_MAP(ADDR(string, bigram), ADDR(map, first_bigrams)) ? ((*(int*)map_get_1(ADDR(map, first_bigrams), &(string[]){bigram}, &(int[]){ 0 })) + 1) : (1));
		map_set_1(&first_bigrams, &(string[]){bigram}, &(int[]) { q });
	}
	int intersection_size = 0;
	for (int i = 0; i < b.len - 1; ++i) {
		string bigram = string_substr(b, i, i + 2);
		int count = (_IN_MAP(ADDR(string, bigram), ADDR(map, first_bigrams)) ? ((*(int*)map_get_1(ADDR(map, first_bigrams), &(string[]){bigram}, &(int[]){ 0 }))) : (0));
		if (count > 0) {
			map_set_1(&first_bigrams, &(string[]){bigram}, &(int[]) { count - 1 });
			intersection_size++;
		}
	}
	return (2.0 * ((f32)(intersection_size))) / (((f32)(a.len)) + ((f32)(b.len)) - 2);
}

string strings__repeat(byte c, int n) {
	if (n <= 0) {
		return _SLIT("");
	}
	byteptr bytes = v_malloc(n + 1);
	{ // Unsafe block
		memset(bytes, c, n);
		bytes[n] = '0';
	}
	return byteptr_vstring_with_len(bytes, n);
}

string strings__repeat_string(string s, int n) {
	if (n <= 0 || s.len == 0) {
		return _SLIT("");
	}
	int slen = s.len;
	int blen = slen * n;
	byteptr bytes = v_malloc(blen + 1);
	for (int bi = 0; bi < n; ++bi) {
		int bislen = bi * slen;
		for (int si = 0; si < slen; ++si) {
			{ // Unsafe block
				bytes[bislen + si] = string_at(s, si);
			}
		}
	}
	{ // Unsafe block
		bytes[blen] = '0';
	}
	return byteptr_vstring_with_len(bytes, blen);
}

// Attr: [inline]
inline u64 hash__wyhash_c(byteptr key, u64 len, u64 seed) {
	return wyhash(key, len, seed);
}

// Attr: [inline]
inline u64 hash__wyhash64_c(u64 a, u64 b) {
	return wyhash64(a, b);
}

// Attr: [inline]
inline u64 hash__sum64_string(string key, u64 seed) {
	return hash__wyhash64(key.str, ((u64)(key.len)), seed);
}

// Attr: [inline]
inline u64 hash__sum64(array_byte key, u64 seed) {
	return hash__wyhash64(((byteptr)(key.data)), ((u64)(key.len)), seed);
}

// Attr: [inline]
inline u64 hash__wyhash64(byteptr key, u64 len, u64 seed_) {
	if (len == 0) {
		return 0;
	}
	byteptr p = key;
	u64 seed = seed_;
	u64 i = (len & 63);
	u64 _t7 = i; 
		seed = (((_t7 <= 3)) ? (hash__wymum(((hash__wyr3(p, i) ^ seed) ^ _const_hash__wyp0), (seed ^ _const_hash__wyp1))) : ((_t7 >= 4 && _t7 <= 8)) ? (hash__wymum(((hash__wyr4(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr4(p + i - 4) ^ seed) ^ _const_hash__wyp1))) : ((_t7 >= 9 && _t7 <= 16)) ? (hash__wymum(((hash__wyr8(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr8(p + i - 8) ^ seed) ^ _const_hash__wyp1))) : ((_t7 >= 17 && _t7 <= 24)) ? ((hash__wymum(((hash__wyr8(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr8(p + 8) ^ seed) ^ _const_hash__wyp1)) ^ hash__wymum(((hash__wyr8(p + i - 8) ^ seed) ^ _const_hash__wyp2), (seed ^ _const_hash__wyp3)))) : ((_t7 >= 25 && _t7 <= 32)) ? ((hash__wymum(((hash__wyr8(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr8(p + 8) ^ seed) ^ _const_hash__wyp1)) ^ hash__wymum(((hash__wyr8(p + 16) ^ seed) ^ _const_hash__wyp2), ((hash__wyr8(p + i - 8) ^ seed) ^ _const_hash__wyp3)))) : ((((hash__wymum(((hash__wyr8(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr8(p + 8) ^ seed) ^ _const_hash__wyp1)) ^ hash__wymum(((hash__wyr8(p + 16) ^ seed) ^ _const_hash__wyp2), ((hash__wyr8(p + 24) ^ seed) ^ _const_hash__wyp3))) ^ hash__wymum(((hash__wyr8(p + i - 32) ^ seed) ^ _const_hash__wyp1), ((hash__wyr8(p + i - 24) ^ seed) ^ _const_hash__wyp2))) ^ hash__wymum(((hash__wyr8(p + i - 16) ^ seed) ^ _const_hash__wyp3), ((hash__wyr8(p + i - 8) ^ seed) ^ _const_hash__wyp0)))));
	if (i == len) {
		return hash__wymum(seed, (len ^ _const_hash__wyp4));
	}
	u64 see1 = seed;
	u64 see2 = seed;
	u64 see3 = seed;
	{ // Unsafe block
		p = p + i;
		for (i = len - i; i >= 64; i -= 64) {
			seed = hash__wymum(((hash__wyr8(p) ^ seed) ^ _const_hash__wyp0), ((hash__wyr8(p + 8) ^ seed) ^ _const_hash__wyp1));
			see1 = hash__wymum(((hash__wyr8(p + 16) ^ see1) ^ _const_hash__wyp2), ((hash__wyr8(p + 24) ^ see1) ^ _const_hash__wyp3));
			see2 = hash__wymum(((hash__wyr8(p + 32) ^ see2) ^ _const_hash__wyp1), ((hash__wyr8(p + 40) ^ see2) ^ _const_hash__wyp2));
			see3 = hash__wymum(((hash__wyr8(p + 48) ^ see3) ^ _const_hash__wyp3), ((hash__wyr8(p + 56) ^ see3) ^ _const_hash__wyp0));
			p = p + 64;
		}
	}
	return hash__wymum(((seed ^ see1) ^ see2), ((see3 ^ len) ^ _const_hash__wyp4));
}

// Attr: [inline]
inline u64 hash__wyrotr(u64 v, u32 k) {
	return ((v >> k) | (v << (64 - k)));
}

// Attr: [inline]
inline u64 hash__wymum(u64 a, u64 b) {
	u32 mask32 = ((u32)(4294967295U));
	u64 x0 = (a & mask32);
	u64 x1 = a >> 32;
	u64 y0 = (b & mask32);
	u64 y1 = b >> 32;
	u64 w0 = x0 * y0;
	u64 t = x1 * y0 + (w0 >> 32);
	u64 w1 = (t & mask32);
	u64 w2 = t >> 32;
	w1 += x0 * y1;
	u64 hi = x1 * y1 + w2 + (w1 >> 32);
	u64 lo = a * b;
	return (hi ^ lo);
}

// Attr: [inline]
inline u64 hash__wyr3(byteptr p, u64 k) {
	{ // Unsafe block
		return (((((u64)(p[0])) << 16) | (((u64)(p[k >> 1])) << 8)) | ((u64)(p[k - 1])));
	}
	return 0;
}

// Attr: [inline]
inline u64 hash__wyr4(byteptr p) {
	{ // Unsafe block
		return (((((u32)(p[0])) | (((u32)(p[1])) << ((u32)(8U)))) | (((u32)(p[2])) << ((u32)(16U)))) | (((u32)(p[3])) << ((u32)(24U))));
	}
	return 0;
}

// Attr: [inline]
inline u64 hash__wyr8(byteptr p) {
	{ // Unsafe block
		return (((((((((u64)(p[0])) | (((u64)(p[1])) << 8)) | (((u64)(p[2])) << 16)) | (((u64)(p[3])) << 24)) | (((u64)(p[4])) << 32)) | (((u64)(p[5])) << 40)) | (((u64)(p[6])) << 48)) | (((u64)(p[7])) << 56));
	}
	return 0;
}

int math__bits__leading_zeros_8(byte x) {
	return 8 - math__bits__len_8(x);
}

int math__bits__leading_zeros_16(u16 x) {
	return 16 - math__bits__len_16(x);
}

int math__bits__leading_zeros_32(u32 x) {
	return 32 - math__bits__len_32(x);
}

int math__bits__leading_zeros_64(u64 x) {
	return 64 - math__bits__len_64(x);
}

int math__bits__trailing_zeros_8(byte x) {
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__ntz_8_tab, x))));
}

int math__bits__trailing_zeros_16(u16 x) {
	if (x == 0) {
		return 16;
	}
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__de_bruijn32tab, ((u32)((x & -x))) * _const_math__bits__de_bruijn32 >> (32 - 5)))));
}

int math__bits__trailing_zeros_32(u32 x) {
	if (x == 0) {
		return 32;
	}
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__de_bruijn32tab, ((x & -x)) * _const_math__bits__de_bruijn32 >> (32 - 5)))));
}

int math__bits__trailing_zeros_64(u64 x) {
	if (x == 0) {
		return 64;
	}
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__de_bruijn64tab, ((x & -x)) * _const_math__bits__de_bruijn64 >> (64 - 6)))));
}

int math__bits__ones_count_8(byte x) {
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, x))));
}

int math__bits__ones_count_16(u16 x) {
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, x >> 8)) + (*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, (x & ((u16)(0xffU)))))));
}

int math__bits__ones_count_32(u32 x) {
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, x >> 24)) + (*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, (x >> 16 & 0xff))) + (*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, (x >> 8 & 0xff))) + (*(byte*)/*ee elem_typ */array_get(_const_math__bits__pop_8_tab, (x & ((u32)(0xffU)))))));
}

int math__bits__ones_count_64(u64 x) {
	u64 y = ((x >> ((u64)(1U)) & ((_const_math__bits__m0 & _const_math__bits__max_u64)))) + ((x & ((_const_math__bits__m0 & _const_math__bits__max_u64))));
	y = ((y >> ((u64)(2U)) & ((_const_math__bits__m1 & _const_math__bits__max_u64)))) + ((y & ((_const_math__bits__m1 & _const_math__bits__max_u64))));
	y = (((y >> 4) + y) & ((_const_math__bits__m2 & _const_math__bits__max_u64)));
	y += y >> 8;
	y += y >> 16;
	y += y >> 32;
	return (((int)(y)) & ((1 << 7) - 1));
}

// Attr: [inline]
inline byte math__bits__rotate_left_8(byte x, int k) {
	byte n = ((byte)(8));
	byte s = (((byte)(k)) & (n - ((byte)(1))));
	return (((x << s) | (x >> (n - s))));
}

// Attr: [inline]
inline u16 math__bits__rotate_left_16(u16 x, int k) {
	u16 n = ((u16)(16U));
	u16 s = (((u16)(k)) & (n - ((u16)(1U))));
	return (((x << s) | (x >> (n - s))));
}

// Attr: [inline]
inline u32 math__bits__rotate_left_32(u32 x, int k) {
	u32 n = ((u32)(32U));
	u32 s = (((u32)(k)) & (n - ((u32)(1U))));
	return (((x << s) | (x >> (n - s))));
}

// Attr: [inline]
inline u64 math__bits__rotate_left_64(u64 x, int k) {
	u64 n = ((u64)(64U));
	u64 s = (((u64)(k)) & (n - ((u64)(1U))));
	return (((x << s) | (x >> (n - s))));
}

// Attr: [inline]
inline byte math__bits__reverse_8(byte x) {
	return (*(byte*)/*ee elem_typ */array_get(_const_math__bits__rev_8_tab, x));
}

// Attr: [inline]
inline u16 math__bits__reverse_16(u16 x) {
	return (((u16)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__rev_8_tab, x >> 8)))) | (((u16)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__rev_8_tab, (x & ((u16)(0xffU))))))) << 8));
}

// Attr: [inline]
inline u32 math__bits__reverse_32(u32 x) {
	u64 y = ((((x >> ((u32)(1U)) & ((_const_math__bits__m0 & _const_math__bits__max_u32)))) | (((x & ((_const_math__bits__m0 & _const_math__bits__max_u32)))) << 1)));
	y = ((((y >> ((u32)(2U)) & ((_const_math__bits__m1 & _const_math__bits__max_u32)))) | (((y & ((_const_math__bits__m1 & _const_math__bits__max_u32)))) << ((u32)(2U)))));
	y = ((((y >> ((u32)(4U)) & ((_const_math__bits__m2 & _const_math__bits__max_u32)))) | (((y & ((_const_math__bits__m2 & _const_math__bits__max_u32)))) << ((u32)(4U)))));
	return math__bits__reverse_bytes_32(((u32)(y)));
}

// Attr: [inline]
inline u64 math__bits__reverse_64(u64 x) {
	u64 y = ((((x >> ((u64)(1U)) & ((_const_math__bits__m0 & _const_math__bits__max_u64)))) | (((x & ((_const_math__bits__m0 & _const_math__bits__max_u64)))) << 1)));
	y = ((((y >> ((u64)(2U)) & ((_const_math__bits__m1 & _const_math__bits__max_u64)))) | (((y & ((_const_math__bits__m1 & _const_math__bits__max_u64)))) << 2)));
	y = ((((y >> ((u64)(4U)) & ((_const_math__bits__m2 & _const_math__bits__max_u64)))) | (((y & ((_const_math__bits__m2 & _const_math__bits__max_u64)))) << 4)));
	return math__bits__reverse_bytes_64(y);
}

// Attr: [inline]
inline u16 math__bits__reverse_bytes_16(u16 x) {
	return ((x >> 8) | (x << 8));
}

// Attr: [inline]
inline u32 math__bits__reverse_bytes_32(u32 x) {
	u64 y = ((((x >> ((u32)(8U)) & ((_const_math__bits__m3 & _const_math__bits__max_u32)))) | (((x & ((_const_math__bits__m3 & _const_math__bits__max_u32)))) << ((u32)(8U)))));
	return ((u32)(((y >> 16) | (y << 16))));
}

// Attr: [inline]
inline u64 math__bits__reverse_bytes_64(u64 x) {
	u64 y = ((((x >> ((u64)(8U)) & ((_const_math__bits__m3 & _const_math__bits__max_u64)))) | (((x & ((_const_math__bits__m3 & _const_math__bits__max_u64)))) << ((u64)(8U)))));
	y = ((((y >> ((u64)(16U)) & ((_const_math__bits__m4 & _const_math__bits__max_u64)))) | (((y & ((_const_math__bits__m4 & _const_math__bits__max_u64)))) << ((u64)(16U)))));
	return ((y >> 32) | (y << 32));
}

int math__bits__len_8(byte x) {
	return ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__len_8_tab, x))));
}

int math__bits__len_16(u16 x) {
	u16 y = x;
	int n = 0;
	if (y >= 1 << 8) {
		y >>= 8;
		n = 8;
	}
	return n + ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__len_8_tab, y))));
}

int math__bits__len_32(u32 x) {
	u32 y = x;
	int n = 0;
	if (y >= (1 << 16)) {
		y >>= 16;
		n = 16;
	}
	if (y >= (1 << 8)) {
		y >>= 8;
		n += 8;
	}
	return n + ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__len_8_tab, y))));
}

int math__bits__len_64(u64 x) {
	u64 y = x;
	int n = 0;
	if (y >= ((u64)(1U)) << ((u64)(32U))) {
		y >>= 32;
		n = 32;
	}
	if (y >= ((u64)(1U)) << ((u64)(16U))) {
		y >>= 16;
		n += 16;
	}
	if (y >= ((u64)(1U)) << ((u64)(8U))) {
		y >>= 8;
		n += 8;
	}
	return n + ((int)((*(byte*)/*ee elem_typ */array_get(_const_math__bits__len_8_tab, y))));
}

multi_return_u32_u32 math__bits__add_32(u32 x, u32 y, u32 carry) {
	u64 sum64 = ((u64)(x)) + ((u64)(y)) + ((u64)(carry));
	u32 sum = ((u32)(sum64));
	u32 carry_out = ((u32)(sum64 >> 32));
	return (multi_return_u32_u32){.arg0=sum, .arg1=carry_out};
}

multi_return_u64_u64 math__bits__add_64(u64 x, u64 y, u64 carry) {
	u64 sum = x + y + carry;
	u64 carry_out = ((((x & y)) | ((((x | y)) & ~sum)))) >> 63;
	return (multi_return_u64_u64){.arg0=sum, .arg1=carry_out};
}

multi_return_u32_u32 math__bits__sub_32(u32 x, u32 y, u32 borrow) {
	u32 diff = x - y - borrow;
	u32 borrow_out = ((((~x & y)) | ((~((x ^ y)) & diff)))) >> 31;
	return (multi_return_u32_u32){.arg0=diff, .arg1=borrow_out};
}

multi_return_u64_u64 math__bits__sub_64(u64 x, u64 y, u64 borrow) {
	u64 diff = x - y - borrow;
	u64 borrow_out = ((((~x & y)) | ((~((x ^ y)) & diff)))) >> 63;
	return (multi_return_u64_u64){.arg0=diff, .arg1=borrow_out};
}

multi_return_u32_u32 math__bits__mul_32(u32 x, u32 y) {
	u64 tmp = ((u64)(x)) * ((u64)(y));
	u32 hi = ((u32)(tmp >> 32));
	u32 lo = ((u32)(tmp));
	return (multi_return_u32_u32){.arg0=hi, .arg1=lo};
}

multi_return_u64_u64 math__bits__mul_64(u64 x, u64 y) {
	u64 x0 = (x & _const_math__bits__mask32);
	u64 x1 = x >> 32;
	u64 y0 = (y & _const_math__bits__mask32);
	u64 y1 = y >> 32;
	u64 w0 = x0 * y0;
	u64 t = x1 * y0 + (w0 >> 32);
	u64 w1 = (t & _const_math__bits__mask32);
	u64 w2 = t >> 32;
	w1 += x0 * y1;
	u64 hi = x1 * y1 + w2 + (w1 >> 32);
	u64 lo = x * y;
	return (multi_return_u64_u64){.arg0=hi, .arg1=lo};
}

multi_return_u32_u32 math__bits__div_32(u32 hi, u32 lo, u32 y) {
	if (y != 0 && y <= hi) {
		panic_debug(407, tos3("/DATA/projects/web/v/v/vlib/math/bits/bits.v"), tos3("math.bits"), tos3("div_32"),  _const_math__bits__overflow_error);
	}
	u64 z = ((((u64)(hi)) << 32) | ((u64)(lo)));
	u32 quo = ((u32)(z / ((u64)(y))));
	u32 rem = ((u32)(z % ((u64)(y))));
	return (multi_return_u32_u32){.arg0=quo, .arg1=rem};
}

multi_return_u64_u64 math__bits__div_64(u64 hi, u64 lo, u64 y1) {
	u64 y = y1;
	if (y == 0) {
		panic_debug(422, tos3("/DATA/projects/web/v/v/vlib/math/bits/bits.v"), tos3("math.bits"), tos3("div_64"),  _const_math__bits__overflow_error);
	}
	if (y <= hi) {
		panic_debug(425, tos3("/DATA/projects/web/v/v/vlib/math/bits/bits.v"), tos3("math.bits"), tos3("div_64"),  _const_math__bits__overflow_error);
	}
	u32 s = ((u32)(math__bits__leading_zeros_64(y)));
	y <<= s;
	u64 yn1 = y >> 32;
	u64 yn0 = (y & _const_math__bits__mask32);
	u64 un32 = ((hi << s) | (lo >> (64 - s)));
	u64 un10 = lo << s;
	u64 un1 = un10 >> 32;
	u64 un0 = (un10 & _const_math__bits__mask32);
	u64 q1 = un32 / yn1;
	u64 rhat = un32 - q1 * yn1;
	for (;;) {
		if (!(q1 >= _const_math__bits__two32 || q1 * yn0 > _const_math__bits__two32 * rhat + un1)) break;
		q1--;
		rhat += yn1;
		if (rhat >= _const_math__bits__two32) {
			break;
		}
	}
	u64 un21 = un32 * _const_math__bits__two32 + un1 - q1 * y;
	u64 q0 = un21 / yn1;
	rhat = un21 - q0 * yn1;
	for (;;) {
		if (!(q0 >= _const_math__bits__two32 || q0 * yn0 > _const_math__bits__two32 * rhat + un0)) break;
		q0--;
		rhat += yn1;
		if (rhat >= _const_math__bits__two32) {
			break;
		}
	}
	return (multi_return_u64_u64){.arg0=q1 * _const_math__bits__two32 + q0, .arg1=(un21 * _const_math__bits__two32 + un0 - q0 * y) >> s};
}

u32 math__bits__rem_32(u32 hi, u32 lo, u32 y) {
	return ((u32)((((((u64)(hi)) << 32) | ((u64)(lo)))) % ((u64)(y))));
}

u64 math__bits__rem_64(u64 hi, u64 lo, u64 y) {
	multi_return_u64_u64 mr_15272 = math__bits__div_64(hi % y, lo, y);
	u64 rem = mr_15272.arg1;
	return rem;
}

multi_return_u32_u32_u32 strconv__lsr96(u32 s2, u32 s1, u32 s0) {
	u32 r0 = ((u32)(0U));
	u32 r1 = ((u32)(0U));
	u32 r2 = ((u32)(0U));
	r0 = ((s0 >> 1) | (((s1 & ((u32)(1U)))) << 31));
	r1 = ((s1 >> 1) | (((s2 & ((u32)(1U)))) << 31));
	r2 = s2 >> 1;
	return (multi_return_u32_u32_u32){.arg0=r2, .arg1=r1, .arg2=r0};
}

multi_return_u32_u32_u32 strconv__lsl96(u32 s2, u32 s1, u32 s0) {
	u32 r0 = ((u32)(0U));
	u32 r1 = ((u32)(0U));
	u32 r2 = ((u32)(0U));
	r2 = ((s2 << 1) | (((s1 & (((u32)(1U)) << 31))) >> 31));
	r1 = ((s1 << 1) | (((s0 & (((u32)(1U)) << 31))) >> 31));
	r0 = s0 << 1;
	return (multi_return_u32_u32_u32){.arg0=r2, .arg1=r1, .arg2=r0};
}

multi_return_u32_u32_u32 strconv__add96(u32 s2, u32 s1, u32 s0, u32 d2, u32 d1, u32 d0) {
	u64 w = ((u64)(0U));
	u32 r0 = ((u32)(0U));
	u32 r1 = ((u32)(0U));
	u32 r2 = ((u32)(0U));
	w = ((u64)(s0)) + ((u64)(d0));
	r0 = ((u32)(w));
	w >>= 32;
	w += ((u64)(s1)) + ((u64)(d1));
	r1 = ((u32)(w));
	w >>= 32;
	w += ((u64)(s2)) + ((u64)(d2));
	r2 = ((u32)(w));
	return (multi_return_u32_u32_u32){.arg0=r2, .arg1=r1, .arg2=r0};
}

multi_return_u32_u32_u32 strconv__sub96(u32 s2, u32 s1, u32 s0, u32 d2, u32 d1, u32 d0) {
	u64 w = ((u64)(0U));
	u32 r0 = ((u32)(0U));
	u32 r1 = ((u32)(0U));
	u32 r2 = ((u32)(0U));
	w = ((u64)(s0)) - ((u64)(d0));
	r0 = ((u32)(w));
	w >>= 32;
	w += ((u64)(s1)) - ((u64)(d1));
	r1 = ((u32)(w));
	w >>= 32;
	w += ((u64)(s2)) - ((u64)(d2));
	r2 = ((u32)(w));
	return (multi_return_u32_u32_u32){.arg0=r2, .arg1=r1, .arg2=r0};
}

bool strconv__is_digit(byte x) {
	return (x >= _const_strconv__c_zero && x <= _const_strconv__c_nine) == true;
}

bool strconv__is_space(byte x) {
	return (x == '\t' || x == '\n' || x == '\v' || x == '\f' || x == '\r' || x == ' ');
}

bool strconv__is_exp(byte x) {
	return (x == 'E' || x == 'e') == true;
}

multi_return_int_strconv__PrepNumber strconv__parser(string s) {
	int state = _const_strconv__fsm_a;
	int digx = 0;
	byte c = ((byte)(' '));
	int result = _const_strconv__parser_ok;
	bool expneg = false;
	int expexp = 0;
	int i = 0;
	strconv__PrepNumber pn = (strconv__PrepNumber){.negative = 0,.exponent = 0,.mantissa = 0,};
	for (;;) {
		if (!(state != _const_strconv__fsm_stop)) break;
		int _t8 = state; 
		if (_t8 == _const_strconv__fsm_a) {
			if (strconv__is_space(c) == true) {
				c = string_at(s, i);
				i++;
			} else {
				state = _const_strconv__fsm_b;
			}
		}
		else if (_t8 == _const_strconv__fsm_b) {
			state = _const_strconv__fsm_c;
			if (c == _const_strconv__c_plus) {
				c = string_at(s, i);
				i++;
			} else if (c == _const_strconv__c_minus) {
				pn.negative = true;
				c = string_at(s, i);
				i++;
			} else if (strconv__is_digit(c)) {
			} else if (c == _const_strconv__c_dpoint) {
			} else {
				state = _const_strconv__fsm_stop;
			}
		}
		else if (_t8 == _const_strconv__fsm_c) {
			if (c == _const_strconv__c_zero) {
				c = string_at(s, i++);
			} else if (c == _const_strconv__c_dpoint) {
				c = string_at(s, i++);
				state = _const_strconv__fsm_d;
			} else {
				state = _const_strconv__fsm_e;
			}
		}
		else if (_t8 == _const_strconv__fsm_d) {
			if (c == _const_strconv__c_zero) {
				c = string_at(s, i++);
				if (pn.exponent > -2147483647) {
					pn.exponent--;
				}
			} else {
				state = _const_strconv__fsm_f;
			}
		}
		else if (_t8 == _const_strconv__fsm_e) {
			if (strconv__is_digit(c)) {
				if (digx < _const_strconv__digits) {
					pn.mantissa *= 10;
					pn.mantissa += ((u64)(c - _const_strconv__c_zero));
					digx++;
				} else if (pn.exponent < 2147483647) {
					pn.exponent++;
				}
				c = string_at(s, i++);
			} else if (c == _const_strconv__c_dpoint) {
				c = string_at(s, i++);
				state = _const_strconv__fsm_f;
			} else {
				state = _const_strconv__fsm_f;
			}
		}
		else if (_t8 == _const_strconv__fsm_f) {
			if (strconv__is_digit(c)) {
				if (digx < _const_strconv__digits) {
					pn.mantissa *= 10;
					pn.mantissa += ((u64)(c - _const_strconv__c_zero));
					pn.exponent--;
					digx++;
				}
				c = string_at(s, i++);
			} else if (strconv__is_exp(c)) {
				c = string_at(s, i++);
				state = _const_strconv__fsm_g;
			} else {
				state = _const_strconv__fsm_g;
			}
		}
		else if (_t8 == _const_strconv__fsm_g) {
			if (c == _const_strconv__c_plus) {
				c = string_at(s, i++);
			} else if (c == _const_strconv__c_minus) {
				expneg = true;
				c = string_at(s, i++);
			}
			state = _const_strconv__fsm_h;
		}
		else if (_t8 == _const_strconv__fsm_h) {
			if (c == _const_strconv__c_zero) {
				c = string_at(s, i++);
			} else {
				state = _const_strconv__fsm_i;
			}
		}
		else if (_t8 == _const_strconv__fsm_i) {
			if (strconv__is_digit(c)) {
				if (expexp < 214748364) {
					expexp *= 10;
					expexp += ((int)(c - _const_strconv__c_zero));
				}
				c = string_at(s, i++);
			} else {
				state = _const_strconv__fsm_stop;
			}
		}
		else {
		};
		if (i >= s.len) {
			state = _const_strconv__fsm_stop;
		}
	}
	if (expneg) {
		expexp = -expexp;
	}
	pn.exponent += expexp;
	if (pn.mantissa == 0) {
		if (pn.negative) {
			result = _const_strconv__parser_mzero;
		} else {
			result = _const_strconv__parser_pzero;
		}
	} else if (pn.exponent > 309) {
		if (pn.negative) {
			result = _const_strconv__parser_minf;
		} else {
			result = _const_strconv__parser_pinf;
		}
	} else if (pn.exponent < -328) {
		if (pn.negative) {
			result = _const_strconv__parser_mzero;
		} else {
			result = _const_strconv__parser_pzero;
		}
	}
	return (multi_return_int_strconv__PrepNumber){.arg0=result, .arg1=pn};
}

u64 strconv__converter(strconv__PrepNumber* pn) {
	int binexp = 92;
	u32 s2 = ((u32)(0U));
	u32 s1 = ((u32)(0U));
	u32 s0 = ((u32)(0U));
	u32 q2 = ((u32)(0U));
	u32 q1 = ((u32)(0U));
	u32 q0 = ((u32)(0U));
	u32 r2 = ((u32)(0U));
	u32 r1 = ((u32)(0U));
	u32 r0 = ((u32)(0U));
	u32 mask28 = ((u32)(((u64)(0xFU)) << 28));
	u64 result = ((u64)(0U));
	s0 = ((u32)((pn->mantissa & ((u64)(0x00000000FFFFFFFFU)))));
	s1 = ((u32)(pn->mantissa >> 32));
	s2 = ((u32)(0U));
	for (;;) {
		if (!(pn->exponent > 0)) break;
		multi_return_u32_u32_u32 mr_6687 = strconv__lsl96(s2, s1, s0);
		q2 = mr_6687.arg0;
		q1 = mr_6687.arg1;
		q0 = mr_6687.arg2;
		multi_return_u32_u32_u32 mr_6731 = strconv__lsl96(q2, q1, q0);
		r2 = mr_6731.arg0;
		r1 = mr_6731.arg1;
		r0 = mr_6731.arg2;
		multi_return_u32_u32_u32 mr_6785 = strconv__lsl96(r2, r1, r0);
		s2 = mr_6785.arg0;
		s1 = mr_6785.arg1;
		s0 = mr_6785.arg2;
		multi_return_u32_u32_u32 mr_6839 = strconv__add96(s2, s1, s0, q2, q1, q0);
		s2 = mr_6839.arg0;
		s1 = mr_6839.arg1;
		s0 = mr_6839.arg2;
		pn->exponent--;
		for (;;) {
			if (!(((s2 & mask28)) != 0)) break;
			multi_return_u32_u32_u32 mr_6960 = strconv__lsr96(s2, s1, s0);
			q2 = mr_6960.arg0;
			q1 = mr_6960.arg1;
			q0 = mr_6960.arg2;
			binexp++;
			s2 = q2;
			s1 = q1;
			s0 = q0;
		}
	}
	for (;;) {
		if (!(pn->exponent < 0)) break;
		for (;;) {
			if (!(!(((s2 & (((u32)(1U)) << 31))) != 0))) break;
			multi_return_u32_u32_u32 mr_7103 = strconv__lsl96(s2, s1, s0);
			q2 = mr_7103.arg0;
			q1 = mr_7103.arg1;
			q0 = mr_7103.arg2;
			binexp--;
			s2 = q2;
			s1 = q1;
			s0 = q0;
		}
		q2 = s2 / _const_strconv__c_ten;
		r1 = s2 % _const_strconv__c_ten;
		r2 = ((s1 >> 8) | (r1 << 24));
		q1 = r2 / _const_strconv__c_ten;
		r1 = r2 % _const_strconv__c_ten;
		r2 = (((((s1 & ((u32)(0xFFU)))) << 16) | (s0 >> 16)) | (r1 << 24));
		r0 = r2 / _const_strconv__c_ten;
		r1 = r2 % _const_strconv__c_ten;
		q1 = ((q1 << 8) | (((r0 & ((u32)(0x00FF0000U)))) >> 16));
		q0 = r0 << 16;
		r2 = (((s0 & ((u32)(0xFFFFU)))) | (r1 << 16));
		q0 |= r2 / _const_strconv__c_ten;
		s2 = q2;
		s1 = q1;
		s0 = q0;
		pn->exponent++;
	}
	if (s2 != 0 || s1 != 0 || s0 != 0) {
		for (;;) {
			if (!(((s2 & mask28)) == 0)) break;
			multi_return_u32_u32_u32 mr_7762 = strconv__lsl96(s2, s1, s0);
			q2 = mr_7762.arg0;
			q1 = mr_7762.arg1;
			q0 = mr_7762.arg2;
			binexp--;
			s2 = q2;
			s1 = q1;
			s0 = q0;
		}
	}
	int nbit = 7;
	u32 check_round_bit = ((u32)(1U)) << ((u32)(nbit));
	u32 check_round_mask = ((u32)(0xFFFFFFFFU)) << ((u32)(nbit));
	if (((s1 & check_round_bit)) != 0) {
		if (((s1 & ~check_round_mask)) != 0) {
			multi_return_u32_u32_u32 mr_8835 = strconv__add96(s2, s1, s0, 0, check_round_bit, 0);
			s2 = mr_8835.arg0;
			s1 = mr_8835.arg1;
			s0 = mr_8835.arg2;
		} else {
			if (((s1 & (check_round_bit << ((u32)(1U))))) != 0) {
				multi_return_u32_u32_u32 mr_9025 = strconv__add96(s2, s1, s0, 0, check_round_bit, 0);
				s2 = mr_9025.arg0;
				s1 = mr_9025.arg1;
				s0 = mr_9025.arg2;
			}
		}
		s1 = (s1 & check_round_mask);
		s0 = ((u32)(0U));
		if ((s2 & (mask28 << ((u32)(1U)))) != 0) {
			multi_return_u32_u32_u32 mr_9225 = strconv__lsr96(s2, s1, s0);
			q2 = mr_9225.arg0;
			q1 = mr_9225.arg1;
			q0 = mr_9225.arg2;
			binexp--;
			s2 = q2;
			s1 = q1;
			s0 = q0;
		}
	}
	binexp += 1023;
	if (binexp > 2046) {
		if (pn->negative) {
			result = _const_strconv__double_minus_infinity;
		} else {
			result = _const_strconv__double_plus_infinity;
		}
	} else if (binexp < 1) {
		if (pn->negative) {
			result = _const_strconv__double_minus_zero;
		} else {
			result = _const_strconv__double_plus_zero;
		}
	} else if (s2 != 0) {
		u64 q = ((u64)(0U));
		u64 binexs2 = ((u64)(binexp)) << 52;
		q = (((((u64)((s2 & ~mask28))) << 24) | ((((u64)(s1)) + ((u64)(128U))) >> 8)) | binexs2);
		if (pn->negative) {
			q |= (((u64)(1U)) << 63);
		}
		result = q;
	}
	return result;
}

f64 strconv__atof64(string s) {
	strconv__PrepNumber pn = (strconv__PrepNumber){.negative = 0,.exponent = 0,.mantissa = 0,};
	int res_parsing = 0;
	strconv__Float64u res = (strconv__Float64u){
#ifndef __cplusplus
0
#endif
};
	multi_return_int_strconv__PrepNumber mr_10230 = strconv__parser(string_add(s, _SLIT(" ")));
	res_parsing = mr_10230.arg0;
	pn = mr_10230.arg1;
	int _t9 = res_parsing; 
	if (_t9 == _const_strconv__parser_ok) {
		res.u = strconv__converter((voidptr)&/*qq*/pn);
	}
	else if (_t9 == _const_strconv__parser_pzero) {
		res.u = _const_strconv__double_plus_zero;
	}
	else if (_t9 == _const_strconv__parser_mzero) {
		res.u = _const_strconv__double_minus_zero;
	}
	else if (_t9 == _const_strconv__parser_pinf) {
		res.u = _const_strconv__double_plus_infinity;
	}
	else if (_t9 == _const_strconv__parser_minf) {
		res.u = _const_strconv__double_minus_infinity;
	}
	else {
	};
	return res.f;
}

f64 strconv__atof_quick(string s) {
	strconv__Float64u f = (strconv__Float64u){
#ifndef __cplusplus
0
#endif
};
	f64 sign = ((f64)(1.0));
	int i = 0;
	for (;;) {
		if (!(i < s.len && string_at(s, i) == ' ')) break;
		i++;
	}
	if (i < s.len) {
		if (string_at(s, i) == '-') {
			sign = -1.0;
			i++;
		} else if (string_at(s, i) == '+') {
			i++;
		}
	}
	if (string_at(s, i) == 'i' && i + 2 < s.len && string_at(s, i + 1) == 'n' && string_at(s, i + 2) == 'f') {
		if (sign > 0.0) {
			f.u = _const_strconv__double_plus_infinity;
		} else {
			f.u = _const_strconv__double_minus_infinity;
		}
		return f.f;
	}
	for (;;) {
		if (!(i < s.len && string_at(s, i) == '0')) break;
		i++;
		if (i >= s.len) {
			if (sign > 0.0) {
				f.u = _const_strconv__double_plus_zero;
			} else {
				f.u = _const_strconv__double_minus_zero;
			}
			return f.f;
		}
	}
	for (;;) {
		if (!(i < s.len && (string_at(s, i) >= '0' && string_at(s, i) <= '9'))) break;
		f.f *= ((f64)(10.0));
		f.f += ((f64)(string_at(s, i) - '0'));
		i++;
	}
	if (i < s.len && string_at(s, i) == '.') {
		i++;
		f64 frac_mul = ((f64)(0.1));
		for (;;) {
			if (!(i < s.len && (string_at(s, i) >= '0' && string_at(s, i) <= '9'))) break;
			f.f += ((f64)(string_at(s, i) - '0')) * frac_mul;
			frac_mul *= ((f64)(0.1));
			i++;
		}
	}
	if (i < s.len && (string_at(s, i) == 'e' || string_at(s, i) == 'E')) {
		i++;
		int exp = 0;
		int exp_sign = 1;
		if (i < s.len) {
			if (string_at(s, i) == '-') {
				exp_sign = -1;
				i++;
			} else if (string_at(s, i) == '+') {
				i++;
			}
		}
		for (;;) {
			if (!(i < s.len && string_at(s, i) == '0')) break;
			i++;
		}
		for (;;) {
			if (!(i < s.len && (string_at(s, i) >= '0' && string_at(s, i) <= '9'))) break;
			exp *= 10;
			exp += ((int)(string_at(s, i) - '0'));
			i++;
		}
		if (exp_sign == 1) {
			if (exp > _const_strconv__pos_exp.len) {
				if (sign > 0) {
					f.u = _const_strconv__double_plus_infinity;
				} else {
					f.u = _const_strconv__double_minus_infinity;
				}
				return f.f;
			}
			strconv__Float64u tmp_mul = (strconv__Float64u){.u = (*(u64*)/*ee elem_typ */array_get(_const_strconv__pos_exp, exp)),};
			f.f = f.f * tmp_mul.f;
		} else {
			if (exp > _const_strconv__neg_exp.len) {
				if (sign > 0) {
					f.u = _const_strconv__double_plus_zero;
				} else {
					f.u = _const_strconv__double_minus_zero;
				}
				return f.f;
			}
			strconv__Float64u tmp_mul = (strconv__Float64u){.u = (*(u64*)/*ee elem_typ */array_get(_const_strconv__neg_exp, exp)),};
			f.f = f.f * tmp_mul.f;
		}
	}
	f.f = f.f * sign;
	return f.f;
}

byte strconv__byte_to_lower(byte c) {
	return (c | ('x' - 'X'));
}

u64 strconv__common_parse_uint(string s, int _base, int _bit_size, bool error_on_non_digit, bool error_on_high_digit) {
	multi_return_u64_int mr_829 = strconv__common_parse_uint2(s, _base, _bit_size);
	u64 result = mr_829.arg0;
	int v_error = mr_829.arg1;
	if (v_error != 0) {
		if (v_error > 0 && (error_on_non_digit || error_on_high_digit)) {
			return ((u64)(0U));
		}
	}
	return result;
}

multi_return_u64_int strconv__common_parse_uint2(string s, int _base, int _bit_size) {
	int bit_size = _bit_size;
	int base = _base;
	if (s.len < 1 || !strconv__underscore_ok(s)) {
		return (multi_return_u64_int){.arg0=((u64)(0U)), .arg1=1};
	}
	bool base0 = base == 0;
	int start_index = 0;
	if (2 <= base && base <= 36) {
	} else if (base == 0) {
		base = 10;
		if (string_at(s, 0) == '0') {
			if (s.len >= 3 && strconv__byte_to_lower(string_at(s, 1)) == 'b') {
				base = 2;
				start_index += 2;
			} else if (s.len >= 3 && strconv__byte_to_lower(string_at(s, 1)) == 'o') {
				base = 8;
				start_index += 2;
			} else if (s.len >= 3 && strconv__byte_to_lower(string_at(s, 1)) == 'x') {
				base = 16;
				start_index += 2;
			} else if (s.len >= 2 && (string_at(s, 1) >= '0' && string_at(s, 1) <= '9')) {
				base = 10;
				start_index++;
			} else {
				base = 8;
				start_index++;
			}
		}
	} else {
		return (multi_return_u64_int){.arg0=((u64)(0U)), .arg1=-1};
	}
	if (bit_size == 0) {
		bit_size = _const_strconv__int_size;
	} else if (bit_size < 0 || bit_size > 64) {
		return (multi_return_u64_int){.arg0=((u64)(0U)), .arg1=-2};
	}
	u64 cutoff = _const_strconv__max_u64 / ((u64)(base)) + ((u64)(1U));
	u64 max_val = (bit_size == 64 ? (_const_strconv__max_u64) : ((((u64)(1U)) << ((u64)(bit_size))) - ((u64)(1U))));
	u64 n = ((u64)(0U));
	for (int i = start_index; i < s.len; ++i) {
		byte c = string_at(s, i);
		byte cl = strconv__byte_to_lower(c);
		byte d = ((byte)(0));
		if (c == '_' && base0) {
			continue;
		} else if ('0' <= c && c <= '9') {
			d = c - '0';
		} else if ('a' <= cl && cl <= 'z') {
			d = cl - 'a' + 10;
		} else {
			return (multi_return_u64_int){.arg0=n, .arg1=i + 1};
		}
		if (d >= ((byte)(base))) {
			return (multi_return_u64_int){.arg0=n, .arg1=i + 1};
		}
		if (n >= cutoff) {
			return (multi_return_u64_int){.arg0=max_val, .arg1=-3};
		}
		n *= ((u64)(base));
		u64 n1 = n + ((u64)(d));
		if (n1 < n || n1 > max_val) {
			return (multi_return_u64_int){.arg0=max_val, .arg1=-3};
		}
		n = n1;
	}
	return (multi_return_u64_int){.arg0=n, .arg1=0};
}

u64 strconv__parse_uint(string s, int _base, int _bit_size) {
	return strconv__common_parse_uint(s, _base, _bit_size, true, true);
}

i64 strconv__common_parse_int(string _s, int base, int _bit_size, bool error_on_non_digit, bool error_on_high_digit) {
	string s = _s;
	int bit_size = _bit_size;
	if (s.len < 1) {
		return ((i64)(0));
	}
	bool neg = false;
	if (string_at(s, 0) == '+') {
		s = string_substr(s, 1, s.len);
	} else if (string_at(s, 0) == '-') {
		neg = true;
		s = string_substr(s, 1, s.len);
	}
	u64 un = strconv__common_parse_uint(s, base, bit_size, error_on_non_digit, error_on_high_digit);
	if (un == 0) {
		return ((i64)(0));
	}
	if (bit_size == 0) {
		bit_size = _const_strconv__int_size;
	}
	u64 cutoff = ((u64)(1U)) << ((u64)(bit_size - 1));
	if (!neg && un >= cutoff) {
		return ((i64)(cutoff - ((u64)(1U))));
	}
	if (neg && un > cutoff) {
		return -((i64)(cutoff));
	}
	return (neg ? (-((i64)(un))) : (((i64)(un))));
}

i64 strconv__parse_int(string _s, int base, int _bit_size) {
	return strconv__common_parse_int(_s, base, _bit_size, true, true);
}

Option_int strconv__atoi(string s) {
	if ((s).len == 0) {
		Option _t10 = v_error(_STR("strconv.atoi: parsing \"%.*s\000\": invalid syntax ", 2, s));
		return *(Option_int*)&_t10;
	}
	if ((_const_strconv__int_size == 32 && (0 < s.len && s.len < 10)) || (_const_strconv__int_size == 64 && (0 < s.len && s.len < 19))) {
		int start_idx = 0;
		if (string_at(s, 0) == '-' || string_at(s, 0) == '+') {
			start_idx++;
			if (s.len - start_idx < 1) {
				Option _t11 = v_error(_STR("strconv.atoi: parsing \"%.*s\000\": invalid syntax ", 2, s));
				return *(Option_int*)&_t11;
			}
		}
		int n = 0;
		for (int i = start_idx; i < s.len; ++i) {
			rune ch = string_at(s, i) - '0';
			if (ch > 9) {
				Option _t12 = v_error(_STR("strconv.atoi: parsing \"%.*s\000\": invalid syntax ", 2, s));
				return *(Option_int*)&_t12;
			}
			n = n * 10 + ((int)(ch));
		}
		Option_int _t13;
		opt_ok2(&(int[]) { (string_at(s, 0) == '-' ? (-n) : (n)) }, (OptionBase*)(&_t13), sizeof(int));
		return _t13;
	}
	i64 int64 = strconv__parse_int(s, 10, 0);
	Option_int _t14;
	opt_ok2(&(int[]) { ((int)(int64)) }, (OptionBase*)(&_t14), sizeof(int));
	return _t14;
}

bool strconv__underscore_ok(string s) {
	rune saw = '^';
	int i = 0;
	if (s.len >= 1 && (string_at(s, 0) == '-' || string_at(s, 0) == '+')) {
		i++;
	}
	bool hex = false;
	if (s.len - i >= 2 && string_at(s, i) == '0' && (strconv__byte_to_lower(string_at(s, i + 1)) == 'b' || strconv__byte_to_lower(string_at(s, i + 1)) == 'o' || strconv__byte_to_lower(string_at(s, i + 1)) == 'x')) {
		saw = '0';
		hex = strconv__byte_to_lower(string_at(s, i + 1)) == 'x';
		i += 2;
	}
	for (; i < s.len; i++) {
		if (('0' <= string_at(s, i) && string_at(s, i) <= '9') || (hex && 'a' <= strconv__byte_to_lower(string_at(s, i)) && strconv__byte_to_lower(string_at(s, i)) <= 'f')) {
			saw = '0';
			continue;
		}
		if (string_at(s, i) == '_') {
			if (saw != '0') {
				return false;
			}
			saw = '_';
			continue;
		}
		if (saw == '_') {
			return false;
		}
		saw = '!';
	}
	return saw != '_';
}

string strconv__Dec32_get_string_32(strconv__Dec32 d, bool neg, int i_n_digit, int i_pad_digit) {
	int n_digit = i_n_digit + 1;
	int pad_digit = i_pad_digit + 1;
	u32 out = d.m;
	int out_len = strconv__decimal_len_32(out);
	int out_len_original = out_len;
	int fw_zeros = 0;
	if (pad_digit > out_len) {
		fw_zeros = pad_digit - out_len;
	}
	array_byte buf = __new_array_with_default(((int)(out_len + 5 + 1 + 1)), 0, sizeof(byte), 0);
	int i = 0;
	if (neg) {
		array_set(&buf, i, &(byte[]) { '-' });
		i++;
	}
	int disp = 0;
	if (out_len <= 1) {
		disp = 1;
	}
	if (n_digit < out_len) {
		out += (*(u32*)/*ee elem_typ */array_get(_const_strconv__ten_pow_table_32, out_len - n_digit - 1)) * 5;
		out /= (*(u32*)/*ee elem_typ */array_get(_const_strconv__ten_pow_table_32, out_len - n_digit));
		out_len = n_digit;
	}
	int y = i + out_len;
	int x = 0;
	for (;;) {
		if (!(x < (out_len - disp - 1))) break;
		array_set(&buf, y - x, &(byte[]) { '0' + ((byte)(out % 10)) });
		out /= 10;
		i++;
		x++;
	}
	if (out_len >= 1) {
		array_set(&buf, y - x, &(byte[]) { '.' });
		x++;
		i++;
	}
	if (y - x >= 0) {
		array_set(&buf, y - x, &(byte[]) { '0' + ((byte)(out % 10)) });
		i++;
	}
	for (;;) {
		if (!(fw_zeros > 0)) break;
		array_set(&buf, i++, &(byte[]) { '0' });
		fw_zeros--;
	}
	array_set(&buf, i, &(byte[]) { 'e' });
	i++;
	int exp = d.e + out_len_original - 1;
	if (exp < 0) {
		array_set(&buf, i, &(byte[]) { '-' });
		i++;
		exp = -exp;
	} else {
		array_set(&buf, i, &(byte[]) { '+' });
		i++;
	}
	int d1 = exp % 10;
	int d0 = exp / 10;
	array_set(&buf, i, &(byte[]) { '0' + ((byte)(d0)) });
	i++;
	array_set(&buf, i, &(byte[]) { '0' + ((byte)(d1)) });
	i++;
	array_set(&buf, i, &(byte[]) { 0 });
	return tos(((byteptr)(&(*(byte*)/*ee elem_typ */array_get(buf, 0)))), i);
}

multi_return_strconv__Dec32_bool strconv__f32_to_decimal_exact_int(u32 i_mant, u32 exp) {
	strconv__Dec32 d = (strconv__Dec32){.m = 0,.e = 0,};
	u32 e = exp - _const_strconv__bias32;
	if (e > _const_strconv__mantbits32) {
		return (multi_return_strconv__Dec32_bool){.arg0=d, .arg1=false};
	}
	u32 shift = _const_strconv__mantbits32 - e;
	u32 mant = (i_mant | 0x00800000);
	d.m = mant >> shift;
	if ((d.m << shift) != mant) {
		return (multi_return_strconv__Dec32_bool){.arg0=d, .arg1=false};
	}
	for (;;) {
		if (!((d.m % 10) == 0)) break;
		d.m /= 10;
		d.e++;
	}
	return (multi_return_strconv__Dec32_bool){.arg0=d, .arg1=true};
}

strconv__Dec32 strconv__f32_to_decimal(u32 mant, u32 exp) {
	int e2 = 0;
	u32 m2 = ((u32)(0U));
	if (exp == 0) {
		e2 = 1 - _const_strconv__bias32 - ((int)(_const_strconv__mantbits32)) - 2;
		m2 = mant;
	} else {
		e2 = ((int)(exp)) - _const_strconv__bias32 - ((int)(_const_strconv__mantbits32)) - 2;
		m2 = ((((u32)(1U)) << _const_strconv__mantbits32) | mant);
	}
	bool even = ((m2 & 1)) == 0;
	bool accept_bounds = even;
	u32 mv = ((u32)(4 * m2));
	u32 mp = ((u32)(4 * m2 + 2));
	u32 mm_shift = strconv__bool_to_u32(mant != 0 || exp <= 1);
	u32 mm = ((u32)(4 * m2 - 1 - mm_shift));
	u32 vr = ((u32)(0U));
	u32 vp = ((u32)(0U));
	u32 vm = ((u32)(0U));
	int e10 = 0;
	bool vm_is_trailing_zeros = false;
	bool vr_is_trailing_zeros = false;
	byte last_removed_digit = ((byte)(0));
	if (e2 >= 0) {
		u32 q = strconv__log10_pow2(e2);
		e10 = ((int)(q));
		int k = _const_strconv__pow5_inv_num_bits_32 + strconv__pow5_bits(((int)(q))) - 1;
		int i = -e2 + ((int)(q)) + k;
		vr = strconv__mul_pow5_invdiv_pow2(mv, q, i);
		vp = strconv__mul_pow5_invdiv_pow2(mp, q, i);
		vm = strconv__mul_pow5_invdiv_pow2(mm, q, i);
		if (q != 0 && (vp - 1) / 10 <= vm / 10) {
			int l = _const_strconv__pow5_inv_num_bits_32 + strconv__pow5_bits(((int)(q - 1))) - 1;
			last_removed_digit = ((byte)(strconv__mul_pow5_invdiv_pow2(mv, q - 1, -e2 + ((int)(q - 1)) + l) % 10));
		}
		if (q <= 9) {
			if (mv % 5 == 0) {
				vr_is_trailing_zeros = strconv__multiple_of_power_of_five_32(mv, q);
			} else if (accept_bounds) {
				vm_is_trailing_zeros = strconv__multiple_of_power_of_five_32(mm, q);
			} else if (strconv__multiple_of_power_of_five_32(mp, q)) {
				vp--;
			}
		}
	} else {
		u32 q = strconv__log10_pow5(-e2);
		e10 = ((int)(q)) + e2;
		int i = -e2 - ((int)(q));
		int k = strconv__pow5_bits(i) - _const_strconv__pow5_num_bits_32;
		int j = ((int)(q)) - k;
		vr = strconv__mul_pow5_div_pow2(mv, ((u32)(i)), j);
		vp = strconv__mul_pow5_div_pow2(mp, ((u32)(i)), j);
		vm = strconv__mul_pow5_div_pow2(mm, ((u32)(i)), j);
		if (q != 0 && ((vp - 1) / 10) <= vm / 10) {
			j = ((int)(q)) - 1 - (strconv__pow5_bits(i + 1) - _const_strconv__pow5_num_bits_32);
			last_removed_digit = ((byte)(strconv__mul_pow5_div_pow2(mv, ((u32)(i + 1)), j) % 10));
		}
		if (q <= 1) {
			vr_is_trailing_zeros = true;
			if (accept_bounds) {
				vm_is_trailing_zeros = mm_shift == 1;
			} else {
				vp--;
			}
		} else if (q < 31) {
			vr_is_trailing_zeros = strconv__multiple_of_power_of_two_32(mv, q - 1);
		}
	}
	int removed = 0;
	u32 out = ((u32)(0U));
	if (vm_is_trailing_zeros || vr_is_trailing_zeros) {
		for (;;) {
			if (!(vp / 10 > vm / 10)) break;
			vm_is_trailing_zeros = vm_is_trailing_zeros && (vm % 10) == 0;
			vr_is_trailing_zeros = vr_is_trailing_zeros && (last_removed_digit == 0);
			last_removed_digit = ((byte)(vr % 10));
			vr /= 10;
			vp /= 10;
			vm /= 10;
			removed++;
		}
		if (vm_is_trailing_zeros) {
			for (;;) {
				if (!(vm % 10 == 0)) break;
				vr_is_trailing_zeros = vr_is_trailing_zeros && (last_removed_digit == 0);
				last_removed_digit = ((byte)(vr % 10));
				vr /= 10;
				vp /= 10;
				vm /= 10;
				removed++;
			}
		}
		if (vr_is_trailing_zeros && (last_removed_digit == 5) && (vr % 2) == 0) {
			last_removed_digit = 4;
		}
		out = vr;
		if ((vr == vm && (!accept_bounds || !vm_is_trailing_zeros)) || last_removed_digit >= 5) {
			out++;
		}
	} else {
		for (;;) {
			if (!(vp / 10 > vm / 10)) break;
			last_removed_digit = ((byte)(vr % 10));
			vr /= 10;
			vp /= 10;
			vm /= 10;
			removed++;
		}
		out = vr + strconv__bool_to_u32(vr == vm || last_removed_digit >= 5);
	}
	return (strconv__Dec32){.m = out,.e = e10 + removed,};
}

string strconv__f32_to_str(f32 f, int n_digit) {
	strconv__Uf32 u1 = (strconv__Uf32){
#ifndef __cplusplus
0
#endif
};
	u1.f = f;
	u32 u = u1.u;
	bool neg = (u >> (_const_strconv__mantbits32 + _const_strconv__expbits32)) != 0;
	u32 mant = (u & ((((u32)(1U)) << _const_strconv__mantbits32) - ((u32)(1U))));
	u32 exp = ((u >> _const_strconv__mantbits32) & ((((u32)(1U)) << _const_strconv__expbits32) - ((u32)(1U))));
	if ((exp == _const_strconv__maxexp32) || (exp == 0 && mant == 0)) {
		return strconv__get_string_special(neg, exp == 0, mant == 0);
	}
	multi_return_strconv__Dec32_bool mr_7979 = strconv__f32_to_decimal_exact_int(mant, exp);
	strconv__Dec32 d = mr_7979.arg0;
	bool ok = mr_7979.arg1;
	if (!ok) {
		d = strconv__f32_to_decimal(mant, exp);
	}
	return strconv__Dec32_get_string_32(d, neg, n_digit, 0);
}

string strconv__f32_to_str_pad(f32 f, int n_digit) {
	strconv__Uf32 u1 = (strconv__Uf32){
#ifndef __cplusplus
0
#endif
};
	u1.f = f;
	u32 u = u1.u;
	bool neg = (u >> (_const_strconv__mantbits32 + _const_strconv__expbits32)) != 0;
	u32 mant = (u & ((((u32)(1U)) << _const_strconv__mantbits32) - ((u32)(1U))));
	u32 exp = ((u >> _const_strconv__mantbits32) & ((((u32)(1U)) << _const_strconv__expbits32) - ((u32)(1U))));
	if ((exp == _const_strconv__maxexp32) || (exp == 0 && mant == 0)) {
		return strconv__get_string_special(neg, exp == 0, mant == 0);
	}
	multi_return_strconv__Dec32_bool mr_8687 = strconv__f32_to_decimal_exact_int(mant, exp);
	strconv__Dec32 d = mr_8687.arg0;
	bool ok = mr_8687.arg1;
	if (!ok) {
		d = strconv__f32_to_decimal(mant, exp);
	}
	return strconv__Dec32_get_string_32(d, neg, n_digit, n_digit);
}

string strconv__Dec64_get_string_64(strconv__Dec64 d, bool neg, int i_n_digit, int i_pad_digit) {
	int n_digit = i_n_digit + 1;
	int pad_digit = i_pad_digit + 1;
	u64 out = d.m;
	int d_exp = d.e;
	int out_len = strconv__decimal_len_64(out);
	int out_len_original = out_len;
	int fw_zeros = 0;
	if (pad_digit > out_len) {
		fw_zeros = pad_digit - out_len;
	}
	array_byte buf = __new_array_with_default((out_len + 6 + 1 + 1 + fw_zeros), 0, sizeof(byte), 0);
	int i = 0;
	if (neg) {
		array_set(&buf, i, &(byte[]) { '-' });
		i++;
	}
	int disp = 0;
	if (out_len <= 1) {
		disp = 1;
	}
	if (n_digit < out_len) {
		out += (*(u64*)/*ee elem_typ */array_get(_const_strconv__ten_pow_table_64, out_len - n_digit - 1)) * 5;
		out /= (*(u64*)/*ee elem_typ */array_get(_const_strconv__ten_pow_table_64, out_len - n_digit));
		if (d.m / (*(u64*)/*ee elem_typ */array_get(_const_strconv__ten_pow_table_64, out_len - n_digit)) < out) {
			d_exp++;
			n_digit++;
		}
		out_len = n_digit;
	}
	int y = i + out_len;
	int x = 0;
	for (;;) {
		if (!(x < (out_len - disp - 1))) break;
		array_set(&buf, y - x, &(byte[]) { '0' + ((byte)(out % 10)) });
		out /= 10;
		i++;
		x++;
	}
	if (out_len >= 1) {
		array_set(&buf, y - x, &(byte[]) { '.' });
		x++;
		i++;
	}
	if (y - x >= 0) {
		array_set(&buf, y - x, &(byte[]) { '0' + ((byte)(out % 10)) });
		i++;
	}
	for (;;) {
		if (!(fw_zeros > 0)) break;
		array_set(&buf, i++, &(byte[]) { '0' });
		fw_zeros--;
	}
	array_set(&buf, i, &(byte[]) { 'e' });
	i++;
	int exp = d_exp + out_len_original - 1;
	if (exp < 0) {
		array_set(&buf, i, &(byte[]) { '-' });
		i++;
		exp = -exp;
	} else {
		array_set(&buf, i, &(byte[]) { '+' });
		i++;
	}
	int d2 = exp % 10;
	exp /= 10;
	int d1 = exp % 10;
	int d0 = exp / 10;
	if (d0 > 0) {
		array_set(&buf, i, &(byte[]) { '0' + ((byte)(d0)) });
		i++;
	}
	array_set(&buf, i, &(byte[]) { '0' + ((byte)(d1)) });
	i++;
	array_set(&buf, i, &(byte[]) { '0' + ((byte)(d2)) });
	i++;
	array_set(&buf, i, &(byte[]) { 0 });
	return tos(((byteptr)(&(*(byte*)/*ee elem_typ */array_get(buf, 0)))), i);
}

multi_return_strconv__Dec64_bool strconv__f64_to_decimal_exact_int(u64 i_mant, u64 exp) {
	strconv__Dec64 d = (strconv__Dec64){.m = 0,.e = 0,};
	u64 e = exp - _const_strconv__bias64;
	if (e > _const_strconv__mantbits64) {
		return (multi_return_strconv__Dec64_bool){.arg0=d, .arg1=false};
	}
	u64 shift = _const_strconv__mantbits64 - e;
	u64 mant = (i_mant | ((u64)(0x0010000000000000U)));
	d.m = mant >> shift;
	if ((d.m << shift) != mant) {
		return (multi_return_strconv__Dec64_bool){.arg0=d, .arg1=false};
	}
	for (;;) {
		if (!((d.m % 10) == 0)) break;
		d.m /= 10;
		d.e++;
	}
	return (multi_return_strconv__Dec64_bool){.arg0=d, .arg1=true};
}

strconv__Dec64 strconv__f64_to_decimal(u64 mant, u64 exp) {
	int e2 = 0;
	u64 m2 = ((u64)(0U));
	if (exp == 0) {
		e2 = 1 - _const_strconv__bias64 - ((int)(_const_strconv__mantbits64)) - 2;
		m2 = mant;
	} else {
		e2 = ((int)(exp)) - _const_strconv__bias64 - ((int)(_const_strconv__mantbits64)) - 2;
		m2 = ((((u64)(1U)) << _const_strconv__mantbits64) | mant);
	}
	bool even = ((m2 & 1)) == 0;
	bool accept_bounds = even;
	u64 mv = ((u64)(4 * m2));
	u64 mm_shift = strconv__bool_to_u64(mant != 0 || exp <= 1);
	u64 vr = ((u64)(0U));
	u64 vp = ((u64)(0U));
	u64 vm = ((u64)(0U));
	int e10 = 0;
	bool vm_is_trailing_zeros = false;
	bool vr_is_trailing_zeros = false;
	if (e2 >= 0) {
		u32 q = strconv__log10_pow2(e2) - strconv__bool_to_u32(e2 > 3);
		e10 = ((int)(q));
		int k = _const_strconv__pow5_inv_num_bits_64 + strconv__pow5_bits(((int)(q))) - 1;
		int i = -e2 + ((int)(q)) + k;
		strconv__Uint128 mul = (*(strconv__Uint128*)/*ee elem_typ */array_get(_const_strconv__pow5_inv_split_64, q));
		vr = strconv__mul_shift_64(((u64)(4U)) * m2, mul, i);
		vp = strconv__mul_shift_64(((u64)(4U)) * m2 + ((u64)(2U)), mul, i);
		vm = strconv__mul_shift_64(((u64)(4U)) * m2 - ((u64)(1U)) - mm_shift, mul, i);
		if (q <= 21) {
			if (mv % 5 == 0) {
				vr_is_trailing_zeros = strconv__multiple_of_power_of_five_64(mv, q);
			} else if (accept_bounds) {
				vm_is_trailing_zeros = strconv__multiple_of_power_of_five_64(mv - 1 - mm_shift, q);
			} else if (strconv__multiple_of_power_of_five_64(mv + 2, q)) {
				vp--;
			}
		}
	} else {
		u32 q = strconv__log10_pow5(-e2) - strconv__bool_to_u32(-e2 > 1);
		e10 = ((int)(q)) + e2;
		int i = -e2 - ((int)(q));
		int k = strconv__pow5_bits(i) - _const_strconv__pow5_num_bits_64;
		int j = ((int)(q)) - k;
		strconv__Uint128 mul = (*(strconv__Uint128*)/*ee elem_typ */array_get(_const_strconv__pow5_split_64, i));
		vr = strconv__mul_shift_64(((u64)(4U)) * m2, mul, j);
		vp = strconv__mul_shift_64(((u64)(4U)) * m2 + ((u64)(2U)), mul, j);
		vm = strconv__mul_shift_64(((u64)(4U)) * m2 - ((u64)(1U)) - mm_shift, mul, j);
		if (q <= 1) {
			vr_is_trailing_zeros = true;
			if (accept_bounds) {
				vm_is_trailing_zeros = (mm_shift == 1);
			} else {
				vp--;
			}
		} else if (q < 63) {
			vr_is_trailing_zeros = strconv__multiple_of_power_of_two_64(mv, q - 1);
		}
	}
	int removed = 0;
	byte last_removed_digit = ((byte)(0));
	u64 out = ((u64)(0U));
	if (vm_is_trailing_zeros || vr_is_trailing_zeros) {
		for (;;) {
			u64 vp_div_10 = vp / 10;
			u64 vm_div_10 = vm / 10;
			if (vp_div_10 <= vm_div_10) {
				break;
			}
			u64 vm_mod_10 = vm % 10;
			u64 vr_div_10 = vr / 10;
			u64 vr_mod_10 = vr % 10;
			vm_is_trailing_zeros = vm_is_trailing_zeros && vm_mod_10 == 0;
			vr_is_trailing_zeros = vr_is_trailing_zeros && (last_removed_digit == 0);
			last_removed_digit = ((byte)(vr_mod_10));
			vr = vr_div_10;
			vp = vp_div_10;
			vm = vm_div_10;
			removed++;
		}
		if (vm_is_trailing_zeros) {
			for (;;) {
				u64 vm_div_10 = vm / 10;
				u64 vm_mod_10 = vm % 10;
				if (vm_mod_10 != 0) {
					break;
				}
				u64 vp_div_10 = vp / 10;
				u64 vr_div_10 = vr / 10;
				u64 vr_mod_10 = vr % 10;
				vr_is_trailing_zeros = vr_is_trailing_zeros && (last_removed_digit == 0);
				last_removed_digit = ((byte)(vr_mod_10));
				vr = vr_div_10;
				vp = vp_div_10;
				vm = vm_div_10;
				removed++;
			}
		}
		if (vr_is_trailing_zeros && (last_removed_digit == 5) && (vr % 2) == 0) {
			last_removed_digit = 4;
		}
		out = vr;
		if ((vr == vm && (!accept_bounds || !vm_is_trailing_zeros)) || last_removed_digit >= 5) {
			out++;
		}
	} else {
		bool round_up = false;
		for (;;) {
			if (!(vp / 100 > vm / 100)) break;
			round_up = (vr % 100) >= 50;
			vr /= 100;
			vp /= 100;
			vm /= 100;
			removed += 2;
		}
		for (;;) {
			if (!(vp / 10 > vm / 10)) break;
			round_up = (vr % 10) >= 5;
			vr /= 10;
			vp /= 10;
			vm /= 10;
			removed++;
		}
		out = vr + strconv__bool_to_u64(vr == vm || round_up);
	}
	return (strconv__Dec64){.m = out,.e = e10 + removed,};
}

string strconv__f64_to_str(f64 f, int n_digit) {
	strconv__Uf64 u1 = (strconv__Uf64){
#ifndef __cplusplus
0
#endif
};
	u1.f = f;
	u64 u = u1.u;
	bool neg = (u >> (_const_strconv__mantbits64 + _const_strconv__expbits64)) != 0;
	u64 mant = (u & ((((u64)(1U)) << _const_strconv__mantbits64) - ((u64)(1U))));
	u64 exp = ((u >> _const_strconv__mantbits64) & ((((u64)(1U)) << _const_strconv__expbits64) - ((u64)(1U))));
	if ((exp == _const_strconv__maxexp64) || (exp == 0 && mant == 0)) {
		return strconv__get_string_special(neg, exp == 0, mant == 0);
	}
	multi_return_strconv__Dec64_bool mr_9686 = strconv__f64_to_decimal_exact_int(mant, exp);
	strconv__Dec64 d = mr_9686.arg0;
	bool ok = mr_9686.arg1;
	if (!ok) {
		d = strconv__f64_to_decimal(mant, exp);
	}
	return strconv__Dec64_get_string_64(d, neg, n_digit, 0);
}

string strconv__f64_to_str_pad(f64 f, int n_digit) {
	strconv__Uf64 u1 = (strconv__Uf64){
#ifndef __cplusplus
0
#endif
};
	u1.f = f;
	u64 u = u1.u;
	bool neg = (u >> (_const_strconv__mantbits64 + _const_strconv__expbits64)) != 0;
	u64 mant = (u & ((((u64)(1U)) << _const_strconv__mantbits64) - ((u64)(1U))));
	u64 exp = ((u >> _const_strconv__mantbits64) & ((((u64)(1U)) << _const_strconv__expbits64) - ((u64)(1U))));
	if ((exp == _const_strconv__maxexp64) || (exp == 0 && mant == 0)) {
		return strconv__get_string_special(neg, exp == 0, mant == 0);
	}
	multi_return_strconv__Dec64_bool mr_10422 = strconv__f64_to_decimal_exact_int(mant, exp);
	strconv__Dec64 d = mr_10422.arg0;
	bool ok = mr_10422.arg1;
	if (!ok) {
		d = strconv__f64_to_decimal(mant, exp);
	}
	return strconv__Dec64_get_string_64(d, neg, n_digit, n_digit);
}

string strconv__f64_to_str_lnd(f64 f, int dec_digit) {
	string s = strconv__f64_to_str(f + (*(f64*)/*ee elem_typ */array_get(_const_strconv__dec_round, dec_digit)), 18);
	if (s.len > 2 && (string_at(s, 0) == 'n' || string_at(s, 1) == 'i')) {
		return s;
	}
	bool m_sgn_flag = false;
	int sgn = 1;
	array_fixed_byte_26 b = {0};
	int d_pos = 1;
	int i = 0;
	int i1 = 0;
	int exp = 0;
	int exp_sgn = 1;
	int dot_res_sp = -1;
	for (int _t15 = 0; _t15 < s.len; ++_t15) {
		byte c = s.str[_t15];
		if (c == '-') {
			sgn = -1;
			i++;
		} else if (c == '+') {
			sgn = 1;
			i++;
		} else if (c >= '0' && c <= '9') {
			b[i1++] = c;
			i++;
		} else if (c == '.') {
			if (sgn > 0) {
				d_pos = i;
			} else {
				d_pos = i - 1;
			}
			i++;
		} else if (c == 'e') {
			i++;
			break;
		} else {
			return _SLIT("[Float conversion error!!]");
		}
	}
	b[i1] = 0;
	if (string_at(s, i) == '-') {
		exp_sgn = -1;
		i++;
	} else if (string_at(s, i) == '+') {
		exp_sgn = 1;
		i++;
	}
	for (int _t16 = 0; _t16 < string_substr(s, i, s.len).len; ++_t16) {
		byte c = string_substr(s, i, s.len).str[_t16];
		exp = exp * 10 + ((int)(c - '0'));
	}
	array_byte res = __new_array_with_default(exp + 32, 0, sizeof(byte), &(byte[]){0});
	int r_i = 0;
	if (sgn == 1) {
		if (m_sgn_flag) {
			array_set(&res, r_i++, &(byte[]) { '+' });
		}
	} else {
		array_set(&res, r_i++, &(byte[]) { '-' });
	}
	i = 0;
	if (exp_sgn >= 0) {
		for (;;) {
			if (!(b[i] != 0)) break;
			array_set(&res, r_i++, &(byte[]) { b[i] });
			i++;
			if (i >= d_pos && exp >= 0) {
				if (exp == 0) {
					dot_res_sp = r_i;
					array_set(&res, r_i++, &(byte[]) { '.' });
				}
				exp--;
			}
		}
		for (;;) {
			if (!(exp >= 0)) break;
			array_set(&res, r_i++, &(byte[]) { '0' });
			exp--;
		}
	} else {
		bool dot_p = true;
		for (;;) {
			if (!(exp > 0)) break;
			array_set(&res, r_i++, &(byte[]) { '0' });
			exp--;
			if (dot_p) {
				dot_res_sp = r_i;
				array_set(&res, r_i++, &(byte[]) { '.' });
				dot_p = false;
			}
		}
		for (;;) {
			if (!(b[i] != 0)) break;
			array_set(&res, r_i++, &(byte[]) { b[i] });
			i++;
		}
	}
	if (dot_res_sp >= 0) {
		if ((r_i - dot_res_sp) > dec_digit) {
			r_i = dot_res_sp + dec_digit + 1;
		}
		array_set(&res, r_i, &(byte[]) { 0 });
		return tos(res.data, r_i);
	} else {
		if (dec_digit > 0) {
			int c = 0;
			array_set(&res, r_i++, &(byte[]) { '.' });
			for (;;) {
				if (!(c < dec_digit)) break;
				array_set(&res, r_i++, &(byte[]) { '0' });
				c++;
			}
			array_set(&res, r_i, &(byte[]) { 0 });
		}
		return tos(res.data, r_i);
	}
	return (string){.str=(byteptr)""};
}

string strconv__format_str(string s, strconv__BF_param p) {
	int dif = p.len0 - s.len;
	if (dif <= 0) {
		return s;
	}
	strings__Builder res = strings__new_builder(s.len + dif);
	if (p.allign == strconv__Align_text_right) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	strings__Builder_write(&res, s);
	if (p.allign == strconv__Align_text_left) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	return strings__Builder_str(&res);
}

string strconv__format_dec(u64 d, strconv__BF_param p) {
	string s = _SLIT("");
	strings__Builder res = strings__new_builder(20);
	int sign_len_diff = 0;
	if (p.pad_ch == '0') {
		if (p.positive) {
			if (p.sign_flag) {
				strings__Builder_write_b(&res, '+');
				sign_len_diff = -1;
			}
		} else {
			strings__Builder_write_b(&res, '-');
			sign_len_diff = -1;
		}
		s = u64_str(d);
	} else {
		if (p.positive) {
			if (p.sign_flag) {
				s = string_add(_SLIT("+"), u64_str(d));
			} else {
				s = u64_str(d);
			}
		} else {
			s = string_add(_SLIT("-"), u64_str(d));
		}
	}
	int dif = p.len0 - s.len + sign_len_diff;
	if (p.allign == strconv__Align_text_right) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	strings__Builder_write(&res, s);
	if (p.allign == strconv__Align_text_left) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	return strings__Builder_str(&res);
}

string strconv__format_fl(f64 f, strconv__BF_param p) {
	string s = _SLIT("");
	string fs = strconv__f64_to_str_lnd((f >= 0.0 ? (f) : (-f)), p.len1);
	if (string_at(fs, 0) == '[') {
		return fs;
	}
	if (p.rm_tail_zero) {
		fs = strconv__remove_tail_zeros(fs);
	}
	strings__Builder res = strings__new_builder((p.len0 > fs.len ? (p.len0) : (fs.len)));
	int sign_len_diff = 0;
	if (p.pad_ch == '0') {
		if (p.positive) {
			if (p.sign_flag) {
				strings__Builder_write_b(&res, '+');
				sign_len_diff = -1;
			}
		} else {
			strings__Builder_write_b(&res, '-');
			sign_len_diff = -1;
		}
		s = fs;
	} else {
		if (p.positive) {
			if (p.sign_flag) {
				s = string_add(_SLIT("+"), fs);
			} else {
				s = fs;
			}
		} else {
			s = string_add(_SLIT("-"), fs);
		}
	}
	int dif = p.len0 - s.len + sign_len_diff;
	if (p.allign == strconv__Align_text_right) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	strings__Builder_write(&res, s);
	if (p.allign == strconv__Align_text_left) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	return strings__Builder_str(&res);
}

string strconv__format_es(f64 f, strconv__BF_param p) {
	string s = _SLIT("");
	string fs = strconv__f64_to_str_pad((f > 0 ? (f) : (-f)), p.len1);
	if (p.rm_tail_zero) {
		fs = strconv__remove_tail_zeros(fs);
	}
	strings__Builder res = strings__new_builder((p.len0 > fs.len ? (p.len0) : (fs.len)));
	int sign_len_diff = 0;
	if (p.pad_ch == '0') {
		if (p.positive) {
			if (p.sign_flag) {
				strings__Builder_write_b(&res, '+');
				sign_len_diff = -1;
			}
		} else {
			strings__Builder_write_b(&res, '-');
			sign_len_diff = -1;
		}
		s = fs;
	} else {
		if (p.positive) {
			if (p.sign_flag) {
				s = string_add(_SLIT("+"), fs);
			} else {
				s = fs;
			}
		} else {
			s = string_add(_SLIT("-"), fs);
		}
	}
	int dif = p.len0 - s.len + sign_len_diff;
	if (p.allign == strconv__Align_text_right) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	strings__Builder_write(&res, s);
	if (p.allign == strconv__Align_text_left) {
		for (int i1 = 0; i1 < dif; i1++) {
			strings__Builder_write_b(&res, p.pad_ch);
		}
	}
	return strings__Builder_str(&res);
}

string strconv__remove_tail_zeros(string s) {
	int i = 0;
	int last_zero_start = -1;
	int dot_pos = -1;
	bool in_decimal = false;
	byte prev_ch = ((byte)(0));
	for (;;) {
		if (!(i < s.len)) break;
		byte ch = s.str[i];
		if (ch == '.') {
			in_decimal = true;
			dot_pos = i;
		} else if (in_decimal) {
			if (ch == '0' && prev_ch != '0') {
				last_zero_start = i;
			} else if (ch >= '1' && ch <= '9') {
				last_zero_start = -1;
			} else if (ch == 'e') {
				break;
			}
		}
		prev_ch = ch;
		i++;
	}
	string tmp = _SLIT("");
	if (last_zero_start > 0) {
		if (last_zero_start == dot_pos + 1) {
			tmp = string_add(string_substr(s, 0, dot_pos), string_substr(s, i, s.len));
		} else {
			tmp = string_add(string_substr(s, 0, last_zero_start), string_substr(s, i, s.len));
		}
	} else {
		tmp = s;
	}
	if (tmp.str[tmp.len - 1] == '.') {
		return string_substr(tmp, 0, tmp.len - 1);
	}
	return tmp;
}

void strconv__v_printf(string str, array_voidptr pt) {
	print(strconv__v_sprintf(str, new_array_from_c_array(1, 1, sizeof(voidptr), _MOV((voidptr[1]){(voidptr)&/*qq*/pt}))));
}

string strconv__v_sprintf(string str, array_voidptr pt) {
	strings__Builder res = strings__new_builder(pt.len * 16);
	int i = 0;
	int p_index = 0;
	bool sign = false;
	strconv__Align_text allign = strconv__Align_text_right;
	int len0 = -1;
	int len1 = -1;
	int def_len1 = 6;
	byte pad_ch = ((byte)(' '));
	rune ch1 = '0';
	rune ch2 = '0';
	strconv__Char_parse_state status = strconv__Char_parse_state_norm_char;
	for (;;) {
		if (!(i < str.len)) break;
		if (status == strconv__Char_parse_state_reset_params) {
			sign = false;
			allign = strconv__Align_text_right;
			len0 = -1;
			len1 = -1;
			pad_ch = ' ';
			status = strconv__Char_parse_state_norm_char;
			ch1 = '0';
			ch2 = '0';
			continue;
		}
		byte ch = string_at(str, i);
		if (ch != '%' && status == strconv__Char_parse_state_norm_char) {
			strings__Builder_write_b(&res, ch);
			i++;
			continue;
		}
		if (ch == '%' && status == strconv__Char_parse_state_norm_char) {
			status = strconv__Char_parse_state_field_char;
			i++;
			continue;
		}
		if (ch == 'c' && status == strconv__Char_parse_state_field_char) {
			strconv__v_sprintf_panic(p_index, pt.len);
			byte d1 = *(((byte*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
			strings__Builder_write_b(&res, d1);
			status = strconv__Char_parse_state_reset_params;
			p_index++;
			i++;
			continue;
		}
		if (ch == 'p' && status == strconv__Char_parse_state_field_char) {
			strconv__v_sprintf_panic(p_index, pt.len);
			strings__Builder_write(&res, _SLIT("0x"));
			strings__Builder_write(&res, ptr_str((*(voidptr*)/*ee elem_typ */array_get(pt, p_index))));
			status = strconv__Char_parse_state_reset_params;
			p_index++;
			i++;
			continue;
		}
		if (status == strconv__Char_parse_state_field_char) {
			rune fc_ch1 = '0';
			rune fc_ch2 = '0';
			if ((i + 1) < str.len) {
				fc_ch1 = string_at(str, i + 1);
				if ((i + 2) < str.len) {
					fc_ch2 = string_at(str, i + 2);
				}
			}
			if (ch == '+') {
				sign = true;
				i++;
				continue;
			} else if (ch == '-') {
				allign = strconv__Align_text_left;
				i++;
				continue;
			} else if ((ch == '0' || ch == ' ')) {
				if (allign == strconv__Align_text_right) {
					pad_ch = ch;
				}
				i++;
				continue;
			} else if (ch == '\'') {
				i++;
				continue;
			} else if (ch == '.' && fc_ch1 >= '1' && fc_ch1 <= '9') {
				status = strconv__Char_parse_state_check_float;
				i++;
				continue;
			} else if (ch == '.' && fc_ch1 == '*' && fc_ch2 == 's') {
				strconv__v_sprintf_panic(p_index, pt.len);
				int len = *(((int*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				p_index++;
				strconv__v_sprintf_panic(p_index, pt.len);
				string s = *(((string*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				s = string_substr(s, 0, len);
				p_index++;
				strings__Builder_write(&res, s);
				status = strconv__Char_parse_state_reset_params;
				i += 3;
				continue;
			}
			status = strconv__Char_parse_state_len_set_start;
			continue;
		}
		if (status == strconv__Char_parse_state_len_set_start) {
			if (ch >= '1' && ch <= '9') {
				len0 = ((int)(ch - '0'));
				status = strconv__Char_parse_state_len_set_in;
				i++;
				continue;
			}
			if (ch == '.') {
				status = strconv__Char_parse_state_check_float;
				i++;
				continue;
			}
			status = strconv__Char_parse_state_check_type;
			continue;
		}
		if (status == strconv__Char_parse_state_len_set_in) {
			if (ch >= '0' && ch <= '9') {
				len0 *= 10;
				len0 += ((int)(ch - '0'));
				i++;
				continue;
			}
			if (ch == '.') {
				status = strconv__Char_parse_state_check_float;
				i++;
				continue;
			}
			status = strconv__Char_parse_state_check_type;
			continue;
		}
		if (status == strconv__Char_parse_state_check_float) {
			if (ch >= '0' && ch <= '9') {
				len1 = ((int)(ch - '0'));
				status = strconv__Char_parse_state_check_float_in;
				i++;
				continue;
			}
			status = strconv__Char_parse_state_check_type;
			continue;
		}
		if (status == strconv__Char_parse_state_check_float_in) {
			if (ch >= '0' && ch <= '9') {
				len1 *= 10;
				len1 += ((int)(ch - '0'));
				i++;
				continue;
			}
			status = strconv__Char_parse_state_check_type;
			continue;
		}
		if (status == strconv__Char_parse_state_check_type) {
			if (ch == 'l') {
				if (ch1 == '0') {
					ch1 = 'l';
					i++;
					continue;
				} else {
					ch2 = 'l';
					i++;
					continue;
				}
			} else if (ch == 'h') {
				if (ch1 == '0') {
					ch1 = 'h';
					i++;
					continue;
				} else {
					ch2 = 'h';
					i++;
					continue;
				}
			} else if ((ch == 'd' || ch == 'i')) {
				u64 d1 = ((u64)(0U));
				bool positive = true;
				rune _t17 = ch1; 
				if (_t17 == 'h') {
					if (ch2 == 'h') {
						strconv__v_sprintf_panic(p_index, pt.len);
						i8 x = *(((i8*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
						positive = (x >= 0 ? (true) : (false));
						d1 = (positive ? (((u64)(x))) : (((u64)(-x))));
					} else {
						i16 x = *(((i16*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
						positive = (x >= 0 ? (true) : (false));
						d1 = (positive ? (((u64)(x))) : (((u64)(-x))));
					}
				}
				else if (_t17 == 'l') {
					strconv__v_sprintf_panic(p_index, pt.len);
					i64 x = *(((i64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
					positive = (x >= 0 ? (true) : (false));
					d1 = (positive ? (((u64)(x))) : (((u64)(-x))));
				}
				else {
					strconv__v_sprintf_panic(p_index, pt.len);
					int x = *(((int*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
					positive = (x >= 0 ? (true) : (false));
					d1 = (positive ? (((u64)(x))) : (((u64)(-x))));
				};
				strings__Builder_write(&res, strconv__format_dec(d1, (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = 0,
					.positive = positive,
					.sign_flag = sign,
					.allign = allign,
					.rm_tail_zero = 0,
				}));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				ch1 = '0';
				ch2 = '0';
				continue;
			} else if (ch == 'u') {
				u64 d1 = ((u64)(0U));
				bool positive = true;
				strconv__v_sprintf_panic(p_index, pt.len);
				rune _t18 = ch1; 
				if (_t18 == 'h') {
					if (ch2 == 'h') {
						d1 = ((u64)(*(((byte*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))))));
					} else {
						d1 = ((u64)(*(((u16*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))))));
					}
				}
				else if (_t18 == 'l') {
					d1 = ((u64)(*(((u64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))))));
				}
				else {
					d1 = ((u64)(*(((u32*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))))));
				};
				strings__Builder_write(&res, strconv__format_dec(d1, (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = 0,
					.positive = positive,
					.sign_flag = sign,
					.allign = allign,
					.rm_tail_zero = 0,
				}));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			} else if ((ch == 'x' || ch == 'X')) {
				strconv__v_sprintf_panic(p_index, pt.len);
				string s = _SLIT("");
				rune _t19 = ch1; 
				if (_t19 == 'h') {
					if (ch2 == 'h') {
						i8 x = *(((i8*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
						s = i8_hex(x);
					} else {
						i16 x = *(((i16*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
						s = i16_hex(x);
					}
				}
				else if (_t19 == 'l') {
					i64 x = *(((i64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
					s = i64_hex(x);
				}
				else {
					int x = *(((int*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
					s = int_hex(x);
				};
				if (ch == 'X') {
					s = string_to_upper(s);
				}
				strings__Builder_write(&res, strconv__format_str(s, (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = 0,
					.positive = true,
					.sign_flag = false,
					.allign = allign,
					.rm_tail_zero = 0,
				}));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			}
			if ((ch == 'f' || ch == 'F')) {
				strconv__v_sprintf_panic(p_index, pt.len);
				f64 x = *(((f64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				bool positive = x >= ((f64)(0.0));
				len1 = (len1 >= 0 ? (len1) : (def_len1));
				string s = strconv__format_fl(((f64)(x)), (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = len1,
					.positive = positive,
					.sign_flag = sign,
					.allign = allign,
					.rm_tail_zero = 0,
				});
				strings__Builder_write(&res, (ch == 'F' ? (string_to_upper(s)) : (s)));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			} else if ((ch == 'e' || ch == 'E')) {
				strconv__v_sprintf_panic(p_index, pt.len);
				f64 x = *(((f64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				bool positive = x >= ((f64)(0.0));
				len1 = (len1 >= 0 ? (len1) : (def_len1));
				string s = strconv__format_es(((f64)(x)), (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = len1,
					.positive = positive,
					.sign_flag = sign,
					.allign = allign,
					.rm_tail_zero = 0,
				});
				strings__Builder_write(&res, (ch == 'E' ? (string_to_upper(s)) : (s)));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			} else if ((ch == 'g' || ch == 'G')) {
				strconv__v_sprintf_panic(p_index, pt.len);
				f64 x = *(((f64*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				bool positive = x >= ((f64)(0.0));
				string s = _SLIT("");
				f64 tx = strconv__fabs(x);
				if (tx < 999999.0 && tx >= 0.00001) {
					len1 = (len1 >= 0 ? (len1 + 1) : (def_len1));
					s = strconv__format_fl(x, (strconv__BF_param){
						.pad_ch = pad_ch,
						.len0 = len0,
						.len1 = len1,
						.positive = positive,
						.sign_flag = sign,
						.allign = allign,
						.rm_tail_zero = true,
					});
				} else {
					len1 = (len1 >= 0 ? (len1 + 1) : (def_len1));
					s = strconv__format_es(x, (strconv__BF_param){
						.pad_ch = pad_ch,
						.len0 = len0,
						.len1 = len1,
						.positive = positive,
						.sign_flag = sign,
						.allign = allign,
						.rm_tail_zero = true,
					});
				}
				strings__Builder_write(&res, (ch == 'G' ? (string_to_upper(s)) : (s)));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			} else if (ch == 's') {
				strconv__v_sprintf_panic(p_index, pt.len);
				string s1 = *(((string*)((*(voidptr*)/*ee elem_typ */array_get(pt, p_index)))));
				pad_ch = ' ';
				strings__Builder_write(&res, strconv__format_str(s1, (strconv__BF_param){
					.pad_ch = pad_ch,
					.len0 = len0,
					.len1 = 0,
					.positive = true,
					.sign_flag = false,
					.allign = allign,
					.rm_tail_zero = 0,
				}));
				status = strconv__Char_parse_state_reset_params;
				p_index++;
				i++;
				continue;
			}
		}
		status = strconv__Char_parse_state_reset_params;
		p_index++;
		i++;
	}
	if (p_index != pt.len) {
		panic_debug(839, tos3("/DATA/projects/web/v/v/vlib/strconv/format.v"), tos3("strconv"), tos3("v_sprintf"),  _STR("%"PRId32"\000 %% conversion specifiers, but given %"PRId32"\000 args", 3, p_index, pt.len));
	}
	return strings__Builder_str(&res);
}

// Attr: [inline]
inline void strconv__v_sprintf_panic(int idx, int len) {
	if (idx >= len) {
		panic_debug(848, tos3("/DATA/projects/web/v/v/vlib/strconv/format.v"), tos3("strconv"), tos3("v_sprintf_panic"),  _STR("%"PRId32"\000 %% conversion specifiers, but given only %"PRId32"\000 args", 3, idx + 1, len));
	}
}

f64 strconv__fabs(f64 x) {
	if (x < 0.0) {
		return -x;
	}
	return x;
}

// Attr: [inline]
inline string strconv__ftoa_64(f64 f) {
	return strconv__f64_to_str(f, 17);
}

// Attr: [inline]
inline string strconv__ftoa_long_64(f64 f) {
	return strconv__f64_to_str_l(f);
}

// Attr: [inline]
inline string strconv__ftoa_32(f32 f) {
	return strconv__f32_to_str(f, 8);
}

// Attr: [inline]
inline string strconv__ftoa_long_32(f32 f) {
	return strconv__f32_to_str_l(f);
}

void strconv__assert1(bool t, string msg) {
	if (!t) {
		panic_debug(34, tos3("/DATA/projects/web/v/v/vlib/strconv/utilities.v"), tos3("strconv"), tos3("assert1"),  msg);
	}
}

// Attr: [inline]
inline int strconv__bool_to_int(bool b) {
	if (b) {
		return 1;
	}
	return 0;
}

// Attr: [inline]
inline u32 strconv__bool_to_u32(bool b) {
	if (b) {
		return ((u32)(1U));
	}
	return ((u32)(0U));
}

// Attr: [inline]
inline u64 strconv__bool_to_u64(bool b) {
	if (b) {
		return ((u64)(1U));
	}
	return ((u64)(0U));
}

string strconv__get_string_special(bool neg, bool expZero, bool mantZero) {
	if (!mantZero) {
		return _SLIT("nan");
	}
	if (!expZero) {
		if (neg) {
			return _SLIT("-inf");
		} else {
			return _SLIT("+inf");
		}
	}
	if (neg) {
		return _SLIT("-0e+00");
	}
	return _SLIT("0e+00");
}

int strconv__decimal_len_32(u32 u) {
	strconv__assert1(u < 1000000000, _SLIT("too big"));
	if (u >= 100000000) {
		return 9;
	} else if (u >= 10000000) {
		return 8;
	} else if (u >= 1000000) {
		return 7;
	} else if (u >= 100000) {
		return 6;
	} else if (u >= 10000) {
		return 5;
	} else if (u >= 1000) {
		return 4;
	} else if (u >= 100) {
		return 3;
	} else if (u >= 10) {
		return 2;
	}
	return 1;
}

u32 strconv__mul_shift_32(u32 m, u64 mul, int ishift) {
	multi_return_u64_u64 mr_1855 = math__bits__mul_64(((u64)(m)), mul);
	u64 hi = mr_1855.arg0;
	u64 lo = mr_1855.arg1;
	u64 shifted_sum = (lo >> ((u64)(ishift))) + (hi << ((u64)(64 - ishift)));
	strconv__assert1(shifted_sum <= 2147483647, _SLIT("shiftedSum <= math.max_u32"));
	return ((u32)(shifted_sum));
}

u32 strconv__mul_pow5_invdiv_pow2(u32 m, u32 q, int j) {
	return strconv__mul_shift_32(m, (*(u64*)/*ee elem_typ */array_get(_const_strconv__pow5_inv_split_32, q)), j);
}

u32 strconv__mul_pow5_div_pow2(u32 m, u32 i, int j) {
	return strconv__mul_shift_32(m, (*(u64*)/*ee elem_typ */array_get(_const_strconv__pow5_split_32, i)), j);
}

u32 strconv__pow5_factor_32(u32 i_v) {
	u32 v = i_v;
	for (u32 n = ((u32)(0U)); ; n++) {
		u32 q = v / 5;
		u32 r = v % 5;
		if (r != 0) {
			return n;
		}
		v = q;
	}
	return v;
}

bool strconv__multiple_of_power_of_five_32(u32 v, u32 p) {
	return strconv__pow5_factor_32(v) >= p;
}

bool strconv__multiple_of_power_of_two_32(u32 v, u32 p) {
	return ((u32)(math__bits__trailing_zeros_32(v))) >= p;
}

u32 strconv__log10_pow2(int e) {
	strconv__assert1(e >= 0, _SLIT("e >= 0"));
	strconv__assert1(e <= 1650, _SLIT("e <= 1650"));
	return (((u32)(e)) * 78913) >> 18;
}

u32 strconv__log10_pow5(int e) {
	strconv__assert1(e >= 0, _SLIT("e >= 0"));
	strconv__assert1(e <= 2620, _SLIT("e <= 2620"));
	return (((u32)(e)) * 732923) >> 20;
}

int strconv__pow5_bits(int e) {
	strconv__assert1(e >= 0, _SLIT("e >= 0"));
	strconv__assert1(e <= 3528, _SLIT("e <= 3528"));
	return ((int)(((((u32)(e)) * 1217359) >> 19) + 1));
}

int strconv__decimal_len_64(u64 u) {
	int log2 = 64 - math__bits__leading_zeros_64(u) - 1;
	int t = (log2 + 1) * 1233 >> 12;
	return t - strconv__bool_to_int(u < (*(u64*)/*ee elem_typ */array_get(_const_strconv__powers_of_10, t))) + 1;
}

u64 strconv__shift_right_128(strconv__Uint128 v, int shift) {
	strconv__assert1(shift < 64, _SLIT("shift < 64"));
	return ((v.hi << ((u64)(64 - shift))) | (v.lo >> ((u32)(shift))));
}

u64 strconv__mul_shift_64(u64 m, strconv__Uint128 mul, int shift) {
	multi_return_u64_u64 mr_4388 = math__bits__mul_64(m, mul.hi);
	u64 hihi = mr_4388.arg0;
	u64 hilo = mr_4388.arg1;
	multi_return_u64_u64 mr_4426 = math__bits__mul_64(m, mul.lo);
	u64 lohi = mr_4426.arg0;
	strconv__Uint128 sum = (strconv__Uint128){.lo = lohi + hilo,.hi = hihi,};
	if (sum.lo < lohi) {
		sum.hi++;
	}
	return strconv__shift_right_128(sum, shift - 64);
}

u32 strconv__pow5_factor_64(u64 v_i) {
	u64 v = v_i;
	for (u32 n = ((u32)(0U)); ; n++) {
		u64 q = v / 5;
		u64 r = v % 5;
		if (r != 0) {
			return n;
		}
		v = q;
	}
	return ((u32)(0U));
}

bool strconv__multiple_of_power_of_five_64(u64 v, u32 p) {
	return strconv__pow5_factor_64(v) >= p;
}

bool strconv__multiple_of_power_of_two_64(u64 v, u32 p) {
	return ((u32)(math__bits__trailing_zeros_64(v))) >= p;
}

string strconv__f32_to_str_l(f64 f) {
	return strconv__f64_to_str_l(((f32)(f)));
}

string strconv__f64_to_str_l(f64 f) {
	string s = strconv__f64_to_str(f, 18);
	if (s.len > 2 && (string_at(s, 0) == 'n' || string_at(s, 1) == 'i')) {
		return s;
	}
	bool m_sgn_flag = false;
	int sgn = 1;
	array_fixed_byte_26 b = {0};
	int d_pos = 1;
	int i = 0;
	int i1 = 0;
	int exp = 0;
	int exp_sgn = 1;
	for (int _t20 = 0; _t20 < s.len; ++_t20) {
		byte c = s.str[_t20];
		if (c == '-') {
			sgn = -1;
			i++;
		} else if (c == '+') {
			sgn = 1;
			i++;
		} else if (c >= '0' && c <= '9') {
			b[i1++] = c;
			i++;
		} else if (c == '.') {
			if (sgn > 0) {
				d_pos = i;
			} else {
				d_pos = i - 1;
			}
			i++;
		} else if (c == 'e') {
			i++;
			break;
		} else {
			return _SLIT("Float conversion error!!");
		}
	}
	b[i1] = 0;
	if (string_at(s, i) == '-') {
		exp_sgn = -1;
		i++;
	} else if (string_at(s, i) == '+') {
		exp_sgn = 1;
		i++;
	}
	for (int _t21 = 0; _t21 < string_substr(s, i, s.len).len; ++_t21) {
		byte c = string_substr(s, i, s.len).str[_t21];
		exp = exp * 10 + ((int)(c - '0'));
	}
	array_byte res = __new_array_with_default(exp + 32, 0, sizeof(byte), &(byte[]){0});
	int r_i = 0;
	if (sgn == 1) {
		if (m_sgn_flag) {
			array_set(&res, r_i++, &(byte[]) { '+' });
		}
	} else {
		array_set(&res, r_i++, &(byte[]) { '-' });
	}
	i = 0;
	if (exp_sgn >= 0) {
		for (;;) {
			if (!(b[i] != 0)) break;
			array_set(&res, r_i++, &(byte[]) { b[i] });
			i++;
			if (i >= d_pos && exp >= 0) {
				if (exp == 0) {
					array_set(&res, r_i++, &(byte[]) { '.' });
				}
				exp--;
			}
		}
		for (;;) {
			if (!(exp >= 0)) break;
			array_set(&res, r_i++, &(byte[]) { '0' });
			exp--;
		}
	} else {
		bool dot_p = true;
		for (;;) {
			if (!(exp > 0)) break;
			array_set(&res, r_i++, &(byte[]) { '0' });
			exp--;
			if (dot_p) {
				array_set(&res, r_i++, &(byte[]) { '.' });
				dot_p = false;
			}
		}
		for (;;) {
			if (!(b[i] != 0)) break;
			array_set(&res, r_i++, &(byte[]) { b[i] });
			i++;
		}
	}
	array_set(&res, r_i, &(byte[]) { 0 });
	return tos(res.data, r_i);
}

array __new_array(int mylen, int cap, int elm_size) {
	int cap_ = (cap < mylen ? (mylen) : (cap));
	array arr = (array){.element_size = elm_size,.data = vcalloc(cap_ * elm_size),.len = mylen,.cap = cap_,};
	return arr;
}

array __new_array_with_default(int mylen, int cap, int elm_size, voidptr val) {
	int cap_ = (cap < mylen ? (mylen) : (cap));
	array arr = (array){.element_size = elm_size,.data = vcalloc(cap_ * elm_size),.len = mylen,.cap = cap_,};
	if (val != 0) {
		for (int i = 0; i < arr.len; ++i) {
			array_set_unsafe(&arr, i, val);
		}
	}
	return arr;
}

array __new_array_with_array_default(int mylen, int cap, int elm_size, array val) {
	int cap_ = (cap < mylen ? (mylen) : (cap));
	array arr = (array){.element_size = elm_size,.data = vcalloc(cap_ * elm_size),.len = mylen,.cap = cap_,};
	for (int i = 0; i < arr.len; ++i) {
		array val_clone = array_clone(&val);
		array_set_unsafe(&arr, i, &val_clone);
	}
	return arr;
}

array new_array_from_c_array(int len, int cap, int elm_size, voidptr c_array) {
	int cap_ = (cap < len ? (len) : (cap));
	array arr = (array){.element_size = elm_size,.data = vcalloc(cap_ * elm_size),.len = len,.cap = cap_,};
	memcpy(arr.data, c_array, len * elm_size);
	return arr;
}

array new_array_from_c_array_no_alloc(int len, int cap, int elm_size, voidptr c_array) {
	array arr = (array){.element_size = elm_size,.data = c_array,.len = len,.cap = cap,};
	return arr;
}

// Attr: [inline]
inline void array_ensure_cap(array* a, int required) {
	if (required <= a->cap) {
		return;
	}
	int cap = (a->cap > 0 ? (a->cap) : (2));
	for (;;) {
		if (!(required > cap)) break;
		cap *= 2;
	}
	int new_size = cap * a->element_size;
	byteptr new_data = ((byteptr)(0));
	if (a->cap > 0) {
		new_data = v_realloc(a->data, new_size);
	} else {
		new_data = vcalloc(new_size);
	}
	a->data = new_data;
	a->cap = cap;
}

array array_repeat(array a, int count) {
	if (count < 0) {
		panic_debug(112, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("repeat"),  _STR("array.repeat: count is negative: %"PRId32"", 1, count));
	}
	int size = count * a.len * a.element_size;
	if (size == 0) {
		size = a.element_size;
	}
	array arr = (array){.element_size = a.element_size,.data = vcalloc(size),.len = count * a.len,.cap = count * a.len,};
	int size_of_array = ((int)(/*SizeOfType*/ sizeof(struct array)));
	for (int i = 0; i < count; ++i) {
		if (a.len > 0 && a.element_size == size_of_array) {
			array ary = (array){.element_size = 0,.data = 0,.len = 0,.cap = 0,};
			memcpy(&ary, a.data, size_of_array);
			array ary_clone = array_clone(&ary);
			memcpy(array_get_unsafe(arr, i * a.len), &ary_clone, a.len * a.element_size);
		} else {
			memcpy(array_get_unsafe(arr, i * a.len), ((byteptr)(a.data)), a.len * a.element_size);
		}
	}
	return arr;
}

void array_sort_with_compare(array* a, voidptr compare) {
	qsort(a->data, a->len, a->element_size, compare);
}

void array_insert(array* a, int i, voidptr val) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (i < 0 || i > a->len) {
			panic_debug(147, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("insert"),  _STR("array.insert: index out of range (i == %"PRId32"\000, a.len == %"PRId32"\000)", 3, i, a->len));
		}
	}
	#endif
	array_ensure_cap(a, a->len + 1);
	{ // Unsafe block
		memmove(array_get_unsafe(/*rec*/*a, i + 1), array_get_unsafe(/*rec*/*a, i), (a->len - i) * a->element_size);
		array_set_unsafe(a, i, val);
	}
	a->len++;
}

void array_insert_many(array* a, int i, voidptr val, int size) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (i < 0 || i > a->len) {
			panic_debug(162, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("insert_many"),  _STR("array.insert_many: index out of range (i == %"PRId32"\000, a.len == %"PRId32"\000)", 3, i, a->len));
		}
	}
	#endif
	array_ensure_cap(a, a->len + size);
	int elem_size = a->element_size;
	{ // Unsafe block
		voidptr iptr = array_get_unsafe(/*rec*/*a, i);
		memmove(array_get_unsafe(/*rec*/*a, i + size), iptr, (a->len - i) * elem_size);
		memcpy(iptr, val, size * elem_size);
	}
	a->len += size;
}

void array_prepend(array* a, voidptr val) {
	array_insert(a, 0, val);
}

void array_prepend_many(array* a, voidptr val, int size) {
	array_insert_many(a, 0, val, size);
}

void array_delete(array* a, int i) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (i < 0 || i >= a->len) {
			panic_debug(189, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("delete"),  _STR("array.delete: index out of range (i == %"PRId32"\000, a.len == %"PRId32"\000)", 3, i, a->len));
		}
	}
	#endif
	memmove(array_get_unsafe(/*rec*/*a, i), array_get_unsafe(/*rec*/*a, i + 1), (a->len - i - 1) * a->element_size);
	a->len--;
}

void array_clear(array* a) {
	a->len = 0;
}

void array_trim(array* a, int index) {
	if (index < a->len) {
		a->len = index;
	}
}

// Attr: [inline]
// Attr: [unsafe]
inline voidptr array_get_unsafe(array a, int i) {
	{ // Unsafe block
		return ((byteptr)(a.data)) + i * a.element_size;
	}
	return 0;
}

voidptr array_get(array a, int i) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (i < 0 || i >= a.len) {
			panic_debug(224, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("get"),  _STR("array.get: index out of range (i == %"PRId32"\000, a.len == %"PRId32"\000)", 3, i, a.len));
		}
	}
	#endif
	{ // Unsafe block
		return ((byteptr)(a.data)) + i * a.element_size;
	}
	return 0;
}

voidptr array_first(array a) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (a.len == 0) {
			panic_debug(236, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("first"),  _SLIT("array.first: array is empty"));
		}
	}
	#endif
	return a.data;
}

voidptr array_last(array a) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (a.len == 0) {
			panic_debug(246, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("last"),  _SLIT("array.last: array is empty"));
		}
	}
	#endif
	{ // Unsafe block
		return ((byteptr)(a.data)) + (a.len - 1) * a.element_size;
	}
	return 0;
}

voidptr array_pop(array* a) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (a->len == 0) {
			panic_debug(259, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("pop"),  _SLIT("array.pop: array is empty"));
		}
	}
	#endif
	int new_len = a->len - 1;
	byteptr last_elem = ((byteptr)(a->data)) + (new_len) * a->element_size;
	a->len = new_len;
	return memdup(last_elem, a->element_size);
}

void array_delete_last(array* a) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (a->len == 0) {
			panic_debug(275, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("delete_last"),  _SLIT("array.pop: array is empty"));
		}
	}
	#endif
	a->len--;
}

array array_slice(array a, int start, int _end) {
	int end = _end;
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (start > end) {
			panic_debug(289, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice"),  _STR("array.slice: invalid slice index (%"PRId32"\000 > %"PRId32"\000)", 3, start, end));
		}
		if (end > a.len) {
			panic_debug(292, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice"),  _STR("array.slice: slice bounds out of range (%"PRId32"\000 >= %"PRId32"\000)", 3, end, a.len));
		}
		if (start < 0) {
			panic_debug(295, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice"),  _STR("array.slice: slice bounds out of range (%"PRId32"\000 < 0)", 2, start));
		}
	}
	#endif
	byteptr data = ((byteptr)(0));
	{ // Unsafe block
		data = ((byteptr)(a.data)) + start * a.element_size;
	}
	int l = end - start;
	array res = (array){.element_size = a.element_size,.data = data,.len = l,.cap = l,};
	return res;
}

array array_slice2(array a, int start, int _end, bool end_max) {
	int end = (end_max ? (a.len) : (_end));
	return array_slice(a, start, end);
}

array array_clone_static(array a) {
	return array_clone(&a);
}

array array_clone(array* a) {
	int size = a->cap * a->element_size;
	if (size == 0) {
		size++;
	}
	array arr = (array){.element_size = a->element_size,.data = vcalloc(size),.len = a->len,.cap = a->cap,};
	int size_of_array = ((int)(/*SizeOfType*/ sizeof(struct array)));
	if (a->element_size == size_of_array) {
		for (int i = 0; i < a->len; ++i) {
			array ar = (array){.element_size = 0,.data = 0,.len = 0,.cap = 0,};
			memcpy(&ar, array_get_unsafe(/*rec*/*a, i), size_of_array);
			array ar_clone = array_clone(&ar);
			array_set_unsafe(&arr, i, &ar_clone);
		}
	} else {
		if (!isnil(a->data)) {
			memcpy(((byteptr)(arr.data)), a->data, a->cap * a->element_size);
		}
	}
	return arr;
}

array array_slice_clone(array* a, int start, int _end) {
	int end = _end;
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (start > end) {
			panic_debug(357, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice_clone"),  _STR("array.slice: invalid slice index (%"PRId32"\000 > %"PRId32"\000)", 3, start, end));
		}
		if (end > a->len) {
			panic_debug(360, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice_clone"),  _STR("array.slice: slice bounds out of range (%"PRId32"\000 >= %"PRId32"\000)", 3, end, a->len));
		}
		if (start < 0) {
			panic_debug(363, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("slice_clone"),  _STR("array.slice: slice bounds out of range (%"PRId32"\000 < 0)", 2, start));
		}
	}
	#endif
	byteptr data = ((byteptr)(0));
	{ // Unsafe block
		data = ((byteptr)(a->data)) + start * a->element_size;
	}
	int l = end - start;
	array res = (array){.element_size = a->element_size,.data = data,.len = l,.cap = l,};
	return array_clone(&res);
}

// Attr: [inline]
// Attr: [unsafe]
inline void array_set_unsafe(array* a, int i, voidptr val) {
	memcpy(((byteptr)(a->data)) + a->element_size * i, val, a->element_size);
}

void array_set(array* a, int i, voidptr val) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (i < 0 || i >= a->len) {
			panic_debug(391, tos3("/DATA/projects/web/v/v/vlib/builtin/array.v"), tos3("builtin"), tos3("set"),  _STR("array.set: index out of range (i == %"PRId32"\000, a.len == %"PRId32"\000)", 3, i, a->len));
		}
	}
	#endif
	memcpy(((byteptr)(a->data)) + a->element_size * i, val, a->element_size);
}

void array_push(array* a, voidptr val) {
	array_ensure_cap(a, a->len + 1);
	memmove(((byteptr)(a->data)) + a->element_size * a->len, val, a->element_size);
	a->len++;
}

void array_push_many(array* a3, voidptr val, int size) {
	if (a3->data == val && !isnil(a3->data)) {
		array copy = array_clone(a3);
		array_ensure_cap(a3, a3->len + size);
		memcpy(array_get_unsafe(/*rec*/*a3, a3->len), copy.data, a3->element_size * size);
	} else {
		array_ensure_cap(a3, a3->len + size);
		if (!isnil(a3->data) && !isnil(val)) {
			memcpy(array_get_unsafe(/*rec*/*a3, a3->len), val, a3->element_size * size);
		}
	}
	a3->len += size;
}

void array_reverse_in_place(array* a) {
	if (a->len < 2) {
		return;
	}
	{ // Unsafe block
		byteptr tmp_value = v_malloc(a->element_size);
		for (int i = 0; i < a->len / 2; ++i) {
			memcpy(tmp_value, ((byteptr)(a->data)) + i * a->element_size, a->element_size);
			memcpy(((byteptr)(a->data)) + i * a->element_size, ((byteptr)(a->data)) + (a->len - 1 - i) * a->element_size, a->element_size);
			memcpy(((byteptr)(a->data)) + (a->len - 1 - i) * a->element_size, tmp_value, a->element_size);
		}
		v_free(tmp_value);
	}
}

array array_reverse(array a) {
	if (a.len < 2) {
		return a;
	}
	array arr = (array){.element_size = a.element_size,.data = vcalloc(a.cap * a.element_size),.len = a.len,.cap = a.cap,};
	for (int i = 0; i < a.len; ++i) {
		array_set_unsafe(&arr, i, array_get_unsafe(a, a.len - 1 - i));
	}
	return arr;
}

// Attr: [unsafe]
void array_free(array* a) {
	#if defined(_VPREALLOC)
	{
	}
	#endif
	free(a->data);
}

string array_string_str(array_string a) {
	strings__Builder sb = strings__new_builder(a.len * 3);
	strings__Builder_write(&sb, _SLIT("["));
	for (int i = 0; i < a.len; ++i) {
		string val = (*(string*)/*ee elem_typ */array_get(a, i));
		strings__Builder_write(&sb, _SLIT("\'"));
		strings__Builder_write(&sb, val);
		strings__Builder_write(&sb, _SLIT("\'"));
		if (i < a.len - 1) {
			strings__Builder_write(&sb, _SLIT(", "));
		}
	}
	strings__Builder_write(&sb, _SLIT("]"));
	return strings__Builder_str(&sb);
}

string array_byte_hex(array_byte b) {
	byteptr hex = v_malloc(b.len * 2 + 1);
	int dst_i = 0;
	// FOR IN array
	array _t22 = b;
	for (int _t23 = 0; _t23 < _t22.len; ++_t23) {
		byte i = ((byte*)_t22.data)[_t23];
		byte n0 = i >> 4;
		{ // Unsafe block
			hex[dst_i++] = (n0 < 10 ? (n0 + '0') : (n0 + ((byte)(87))));
		}
		byte n1 = (i & 0xF);
		{ // Unsafe block
			hex[dst_i++] = (n1 < 10 ? (n1 + '0') : (n1 + ((byte)(87))));
		}
	}
	{ // Unsafe block
		hex[dst_i] = '\0';
		return tos(hex, dst_i);
	}
	return (string){.str=(byteptr)""};
}

int copy(array_byte dst, array_byte src) {
	if (dst.len > 0 && src.len > 0) {
		int min = 0;
		min = (dst.len < src.len ? (dst.len) : (src.len));
		memcpy(((byteptr)(dst.data)), array_slice(src, 0, min).data, dst.element_size * min);
		return min;
	}
	return 0;
}

int compare_ints(int* a, int* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

int compare_ints_reverse(int* a, int* b) {
	if (*a > *b) {
		return -1;
	}
	if (*a < *b) {
		return 1;
	}
	return 0;
}

int compare_u64s(u64* a, u64* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

int compare_u64s_reverse(u64* a, u64* b) {
	if (*a > *b) {
		return -1;
	}
	if (*a < *b) {
		return 1;
	}
	return 0;
}

int compare_floats(f64* a, f64* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

int compare_floats_reverse(f64* a, f64* b) {
	if (*a > *b) {
		return -1;
	}
	if (*a < *b) {
		return 1;
	}
	return 0;
}

void array_int_sort(array_int* a) {
	array_sort_with_compare(a, compare_ints);
}

int array_string_index(array_string a, string v) {
	for (int i = 0; i < a.len; ++i) {
		if (string_eq((*(string*)/*ee elem_typ */array_get(a, i)), v)) {
			return i;
		}
	}
	return -1;
}

int array_int_reduce(array_int a, int (*iter)(int , int ), int accum_start) {
	int accum_ = accum_start;
	// FOR IN array
	array _t24 = a;
	for (int _t25 = 0; _t25 < _t24.len; ++_t25) {
		int i = ((int*)_t24.data)[_t25];
		accum_ = iter(accum_, i);
	}
	return accum_;
}

void array_grow_cap(array* a, int amount) {
	array_ensure_cap(a, a->cap + amount);
}

void array_grow_len(array* a, int amount) {
	array_ensure_cap(a, a->len + amount);
	a->len += amount;
}

bool array_string_eq(array_string a1, array_string a2) {
	if (a1.len != a2.len) {
		return false;
	}
	for (int i = 0; i < a1.len; ++i) {
		if (string_ne((*(string*)/*ee elem_typ */array_get(a1, i)), (*(string*)/*ee elem_typ */array_get(a2, i)))) {
			return false;
		}
	}
	return true;
}

int compare_i64(i64* a, i64* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

int compare_f64(f64* a, f64* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

int compare_f32(f32* a, f32* b) {
	if (*a < *b) {
		return -1;
	}
	if (*a > *b) {
		return 1;
	}
	return 0;
}

array_voidptr array_pointers(array a) {
	array_voidptr res = __new_array_with_default(0, 0, sizeof(voidptr), 0);
	for (int i = 0; i < a.len; ++i) {
		array_push(&res, _MOV((voidptr[]){ array_get_unsafe(a, i) }));
	}
	return res;
}

// Attr: [unsafe]
array_byte voidptr_vbytes(voidptr data, int len) {
	array res = (array){.element_size = 1,.data = data,.len = len,.cap = len,};
	return res;
}

// Attr: [unsafe]
array_byte byteptr_vbytes(byteptr data, int len) {
	return voidptr_vbytes(((voidptr)(data)), len);
}

// TypeDecl
void v_exit(int code) {
	exit(code);
}

void panic_debug(int line_no, string file, string mod, string fn_name, string s) {
	eprintln(_SLIT("================ V panic ================"));
	eprintln(_STR("   module: %.*s", 1, mod));
	eprintln(_STR(" function: %.*s\000()", 2, fn_name));
	eprintln(_STR("  message: %.*s", 1, s));
	eprintln(_STR("     file: %.*s", 1, file));
	eprintln(string_add(_SLIT("     line: "), int_str(line_no)));
	eprintln(_SLIT("========================================="));
	#if defined(CUSTOM_DEFINE_exit_after_panic_message)
	{
	}
	#else
	{
		#if defined(CUSTOM_DEFINE_no_backtrace)
		{
		}
		#else
		{
			#if defined(__TINYC__)
			{
				#if defined(CUSTOM_DEFINE_panics_break_into_debugger)
				{
				}
				#else
				{
					tcc_backtrace("Backtrace");
				}
				#endif
				exit(1);
			}
			#endif
			print_backtrace_skipping_top_frames(1);
			#if defined(CUSTOM_DEFINE_panics_break_into_debugger)
			{
			}
			#endif
			exit(1);
		}
		#endif
	}
	#endif
}

void v_panic(string s) {
	eprintln(_STR("V panic: %.*s", 1, s));
	#if defined(CUSTOM_DEFINE_exit_after_panic_message)
	{
	}
	#else
	{
		#if defined(CUSTOM_DEFINE_no_backtrace)
		{
		}
		#else
		{
			#if defined(__TINYC__)
			{
				#if defined(CUSTOM_DEFINE_panics_break_into_debugger)
				{
				}
				#else
				{
					tcc_backtrace("Backtrace");
				}
				#endif
				exit(1);
			}
			#endif
			print_backtrace_skipping_top_frames(1);
			#if defined(CUSTOM_DEFINE_panics_break_into_debugger)
			{
			}
			#endif
			exit(1);
		}
		#endif
	}
	#endif
}

void eprintln(string s) {
	if (s.str == 0) {
		eprintln(_SLIT("eprintln(NIL)"));
	}
	fflush(stdout);
	fflush(stderr);
	write(2, s.str, s.len);
	write(2, "\n", 1);
	fflush(stderr);
}

void eprint(string s) {
	if (s.str == 0) {
		eprint(_SLIT("eprint(NIL)"));
	}
	fflush(stdout);
	fflush(stderr);
	write(2, s.str, s.len);
	fflush(stderr);
}

void print(string s) {
	write(1, s.str, s.len);
}

void println(string s) {
	#if defined(_WIN32)
	{
	}
	#else
	{
		printf("%.*s\n", s.len, s.str);
	}
	#endif
}

// Attr: [unsafe]
byteptr v_malloc(int n) {
	if (n <= 0) {
		panic_debug(146, tos3("/DATA/projects/web/v/v/vlib/builtin/builtin.c.v"), tos3("builtin"), tos3("malloc"),  _SLIT("malloc(<=0)"));
	}
	#if defined(_VPREALLOC)
	{
	}
	#else
	{
		byteptr ptr = malloc(n);
		if (ptr == 0) {
			panic_debug(159, tos3("/DATA/projects/web/v/v/vlib/builtin/builtin.c.v"), tos3("builtin"), tos3("malloc"),  _STR("malloc(%"PRId32"\000) failed", 2, n));
		}
		return ptr;
	}
	#endif
	return 0;
}

// Attr: [unsafe]
byteptr v_realloc(byteptr b, int n) {
	#if defined(_VPREALLOC)
	{
	}
	#else
	{
		byteptr ptr = realloc(b, n);
		if (ptr == 0) {
			panic_debug(196, tos3("/DATA/projects/web/v/v/vlib/builtin/builtin.c.v"), tos3("builtin"), tos3("v_realloc"),  _STR("realloc(%"PRId32"\000) failed", 2, n));
		}
		return ptr;
	}
	#endif
	return 0;
}

// Attr: [unsafe]
byteptr v_calloc(int n) {
	return calloc(1, n);
}

// Attr: [unsafe]
byteptr vcalloc(int n) {
	if (n < 0) {
		panic_debug(215, tos3("/DATA/projects/web/v/v/vlib/builtin/builtin.c.v"), tos3("builtin"), tos3("vcalloc"),  _SLIT("calloc(<=0)"));
	} else if (n == 0) {
		return ((byteptr)(0));
	}
	return calloc(1, n);
}

// Attr: [unsafe]
void v_free(voidptr ptr) {
	#if defined(_VPREALLOC)
	{
	}
	#endif
	free(ptr);
}

voidptr memdup(voidptr src, int sz) {
	if (sz == 0) {
		return vcalloc(1);
	}
	{ // Unsafe block
		byteptr mem = v_malloc(sz);
		return memcpy(mem, src, sz);
	}
	return 0;
}

void v_ptr_free(voidptr ptr) {
	#if defined(_VPREALLOC)
	{
	}
	#endif
	free(ptr);
}

int is_atty(int fd) {
	#if defined(_WIN32)
	{
	}
	#else
	{
		return isatty(fd);
	}
	#endif
	return 0;
}

bool isnil(voidptr v) {
	return v == 0;
}

void print_backtrace() {
	print_backtrace_skipping_top_frames(2);
}

voidptr __as_cast(voidptr obj, int obj_type, int expected_type) {
	if (obj_type != expected_type) {
		panic_debug(39, tos3("/DATA/projects/web/v/v/vlib/builtin/builtin.v"), tos3("builtin"), tos3("__as_cast"),  _STR("as cast: cannot cast %"PRId32"\000 to %"PRId32"", 2, obj_type, expected_type));
	}
	return obj;
}

void __print_assert_failure(VAssertMetaInfo* i) {
	eprintln(_STR("%.*s\000:%"PRId32"\000: FAIL: fn %.*s\000: assert %.*s", 4, i->fpath, i->line_nr + 1, i->fn_name, i->src));
	if (i->op.len > 0 && string_ne(i->op, _SLIT("call"))) {
		eprintln(_STR("   left value: %.*s\000 = %.*s", 2, i->llabel, i->lvalue));
		if (string_eq(i->rlabel, i->rvalue)) {
			eprintln(_STR("  right value: %.*s", 1, i->rlabel));
		} else {
			eprintln(_STR("  right value: %.*s\000 = %.*s", 2, i->rlabel, i->rvalue));
		}
	}
}

void builtin_init() {
}

bool print_backtrace_skipping_top_frames(int xskipframes) {
	int skipframes = xskipframes + 2;
	#if defined(__APPLE__)
	{
	}
	#endif
	#if defined(__linux__)
	{
		return print_backtrace_skipping_top_frames_linux(skipframes);
	}
	#endif
	#if defined(__FreeBSD__)
	{
	}
	#endif
	#if defined(__NetBSD__)
	{
	}
	#endif
	#if defined(__OpenBSD__)
	{
	}
	#endif
	println(_STR("print_backtrace_skipping_top_frames is not implemented. skipframes: %"PRId32"", 1, skipframes));
	return false;
}

bool print_backtrace_skipping_top_frames_mac(int skipframes) {
	#if defined(__APPLE__)
	{
	}
	#endif
	return true;
}

bool print_backtrace_skipping_top_frames_freebsd(int skipframes) {
	#if defined(__FreeBSD__)
	{
	}
	#endif
	return true;
}

bool print_backtrace_skipping_top_frames_linux(int skipframes) {
	#if defined(__ANDROID__)
	{
	}
	#endif
	#if !defined(__GLIBC__)
	{
	}
	#endif
	#if defined(CUSTOM_DEFINE_no_backtrace)
	{
	}
	#else
	{
		#if defined(__TINYC__)
		{
			tcc_backtrace("Backtrace");
			return false;
		}
		#endif
		array_fixed_byteptr_100 buffer = {0};
		int nr_ptrs = backtrace(((voidptr)(buffer)), 100);
		if (nr_ptrs < 2) {
			eprintln(_SLIT("C.backtrace returned less than 2 frames"));
			return false;
		}
		int nr_actual_frames = nr_ptrs - skipframes;
		array_string sframes = __new_array_with_default(0, 0, sizeof(string), 0);
		charptr* csymbols = backtrace_symbols(((voidptr)(&buffer[skipframes])), nr_actual_frames);
		for (int i = 0; i < nr_actual_frames; ++i) {
			array_push(&sframes, _MOV((string[]){ tos2(((byteptr)(csymbols[i]))) }));
		}
		// FOR IN array
		array _t28 = sframes;
		for (int _t29 = 0; _t29 < _t28.len; ++_t29) {
			string sframe = ((string*)_t28.data)[_t29];
			string executable = string_all_before(sframe, _SLIT("("));
			string addr = string_all_before(string_all_after(sframe, _SLIT("[")), _SLIT("]"));
			string beforeaddr = string_all_before(sframe, _SLIT("["));
			string cmd = _STR("addr2line -e %.*s\000 %.*s", 2, executable, addr);
			voidptr f = popen(((charptr)(cmd.str)), "r");
			if (isnil(f)) {
				eprintln(sframe);
				continue;
			}
			array_fixed_byte_1000 buf = {0};
			string output = _SLIT("");
			for (;;) {
				if (!(fgets(((charptr)(buf)), 1000, f) != 0)) break;
				output = /*f*/string_add(output, tos(((byteptr)(buf)), vstrlen(((byteptr)(buf)))));
			}
			output = string_add(string_trim_space(output), _SLIT(":"));
			if (pclose(f) != 0) {
				eprintln(sframe);
				continue;
			}
			if ((string_eq(output, _SLIT("??:0:")) || string_eq(output, _SLIT("??:?:")))) {
				output = _SLIT("");
			}
			output = string_replace(output, _SLIT(" (discriminator"), _SLIT(": (d."));
			eprintln(_STR("%*.*s\000 | %*.*s\000 | %.*s", 3, output, -55, addr, 14, beforeaddr));
		}
	}
	#endif
	return true;
}

void break_if_debugger_attached() {
	{ // Unsafe block
		voidptr* ptr = ((voidptr*)(0));
		*ptr = ((voidptr)(0));
	}
}

int proc_pidpath(int , voidptr , int );

// Attr: [trusted]
// Attr: [trusted]
// Attr: [trusted]
void chan_close(chan ch) {
}

ChanState chan_try_pop(chan ch, voidptr obj) {
	return ChanState_success;
}

ChanState chan_try_push(chan ch, voidptr obj) {
	return ChanState_success;
}

// Attr: [inline]
inline string f64_str(f64 x) {
	f64 abs_x = f64_abs(x);
	if (abs_x >= 0.0001 && abs_x < 1.0e6) {
		return strconv__f64_to_str_l(x);
	} else {
		return strconv__ftoa_64(x);
	}
	return (string){.str=(byteptr)""};
}

// Attr: [inline]
inline string any_float_str(any_float d) {
	return f64_str(((f64)(d)));
}

// Attr: [inline]
inline string f64_strsci(f64 x, int digit_num) {
	int n_digit = digit_num;
	if (n_digit < 1) {
		n_digit = 1;
	} else if (n_digit > 17) {
		n_digit = 17;
	}
	return strconv__f64_to_str(x, n_digit);
}

// Attr: [inline]
inline string f64_strlong(f64 x) {
	return strconv__f64_to_str_l(x);
}

// Attr: [inline]
inline string f32_str(f32 x) {
	f32 abs_x = f32_abs(x);
	if (abs_x >= 0.0001 && abs_x < 1.0e6) {
		return strconv__f32_to_str_l(x);
	} else {
		return strconv__ftoa_32(x);
	}
	return (string){.str=(byteptr)""};
}

// Attr: [inline]
inline string f32_strsci(f32 x, int digit_num) {
	int n_digit = digit_num;
	if (n_digit < 1) {
		n_digit = 1;
	} else if (n_digit > 8) {
		n_digit = 8;
	}
	return strconv__f32_to_str(x, n_digit);
}

// Attr: [inline]
inline string f32_strlong(f32 x) {
	return strconv__f32_to_str_l(x);
}

// Attr: [inline]
inline f32 f32_abs(f32 a) {
	return (a < 0 ? (-a) : (a));
}

// Attr: [inline]
inline f64 f64_abs(f64 a) {
	return (a < 0 ? (-a) : (a));
}

// Attr: [inline]
inline f32 f32_max(f32 a, f32 b) {
	return (a > b ? (a) : (b));
}

// Attr: [inline]
inline f32 f32_min(f32 a, f32 b) {
	return (a < b ? (a) : (b));
}

// Attr: [inline]
inline f64 f64_max(f64 a, f64 b) {
	return (a > b ? (a) : (b));
}

// Attr: [inline]
inline f64 f64_min(f64 a, f64 b) {
	return (a < b ? (a) : (b));
}

// Attr: [inline]
inline bool f32_eq_epsilon(f32 a, f32 b) {
	f32 hi = f32_max(f32_abs(a), f32_abs(b));
	f32 delta = f32_abs(a - b);
	if (hi > ((f32)(1.0))) {
		return delta <= hi * (4 * ((f32)(FLT_EPSILON)));
	} else {
		return (1 / (4 * ((f32)(FLT_EPSILON)))) * delta <= hi;
	}
	return 0;
}

// Attr: [inline]
inline bool f64_eq_epsilon(f64 a, f64 b) {
	f64 hi = f64_max(f64_abs(a), f64_abs(b));
	f64 delta = f64_abs(a - b);
	if (hi > 1.0) {
		return delta <= hi * (4 * ((f64)(DBL_EPSILON)));
	} else {
		return (1 / (4 * ((f64)(DBL_EPSILON)))) * delta <= hi;
	}
	return 0;
}

string ptr_str(voidptr ptr) {
	string buf1 = u64_hex(((u64)(ptr)));
	return buf1;
}

// Attr: [inline]
inline string int_str_l(int nn, int max) {
	i64 n = ((i64)(nn));
	int d = 0;
	if (n == 0) {
		return _SLIT("0");
	}
	byteptr buf = v_malloc(max + 1);
	bool is_neg = false;
	if (n < 0) {
		n = -n;
		is_neg = true;
	}
	int index = max;
	{ // Unsafe block
		buf[index--] = '\0';
	}
	for (;;) {
		if (!(n > 0)) break;
		int n1 = ((int)(n / 100));
		d = ((((int)(n)) - (n1 * 100)) << 1);
		n = n1;
		{ // Unsafe block
			buf[index--] = _const_digit_pairs.str[d++];
			buf[index--] = _const_digit_pairs.str[d];
		}
	}
	index++;
	if (d < 20) {
		index++;
	}
	if (is_neg) {
		index--;
		{ // Unsafe block
			buf[index] = '-';
		}
	}
	{ // Unsafe block
		memmove(buf, buf + index, (max - index) + 1);
		return tos(buf, (max - index));
	}
	return (string){.str=(byteptr)""};
}

string i8_str(i8 n) {
	return int_str_l(((int)(n)), 5);
}

string i16_str(i16 n) {
	return int_str_l(((int)(n)), 7);
}

string u16_str(u16 n) {
	return int_str_l(((int)(n)), 7);
}

string int_str(int n) {
	return int_str_l(n, 12);
}

string u32_str(u32 nn) {
	u32 n = nn;
	u32 d = ((u32)(0U));
	if (n == 0) {
		return _SLIT("0");
	}
	int max = 12;
	byteptr buf = v_malloc(max + 1);
	int index = max;
	{ // Unsafe block
		buf[index--] = '\0';
	}
	for (;;) {
		if (!(n > 0)) break;
		u32 n1 = n / ((u32)(100U));
		d = ((n - (n1 * ((u32)(100U)))) << ((u32)(1U)));
		n = n1;
		{ // Unsafe block
			buf[index--] = string_at(_const_digit_pairs, d++);
			buf[index--] = string_at(_const_digit_pairs, d);
		}
	}
	index++;
	if (d < ((u32)(20U))) {
		index++;
	}
	{ // Unsafe block
		memmove(buf, buf + index, (max - index) + 1);
		return tos(buf, (max - index));
	}
	return (string){.str=(byteptr)""};
}

// Attr: [inline]
inline string any_int_str(any_int n) {
	return i64_str(((i64)(n)));
}

string i64_str(i64 nn) {
	i64 n = nn;
	i64 d = ((i64)(0));
	if (n == 0) {
		return _SLIT("0");
	}
	int max = 20;
	byteptr buf = vcalloc(max + 1);
	bool is_neg = false;
	if (n < 0) {
		n = -n;
		is_neg = true;
	}
	int index = max;
	{ // Unsafe block
		buf[index--] = '\0';
	}
	for (;;) {
		if (!(n > 0)) break;
		i64 n1 = n / ((i64)(100));
		d = ((n - (n1 * ((i64)(100)))) << ((i64)(1)));
		n = n1;
		{ // Unsafe block
			buf[index--] = string_at(_const_digit_pairs, d++);
			buf[index--] = string_at(_const_digit_pairs, d);
		}
	}
	index++;
	if (d < ((i64)(20))) {
		index++;
	}
	if (is_neg) {
		index--;
		{ // Unsafe block
			buf[index] = '-';
		}
	}
	{ // Unsafe block
		memmove(buf, buf + index, (max - index) + 1);
		return tos(buf, (max - index));
	}
	return (string){.str=(byteptr)""};
}

string u64_str(u64 nn) {
	u64 n = nn;
	u64 d = ((u64)(0U));
	if (n == 0) {
		return _SLIT("0");
	}
	int max = 20;
	byteptr buf = vcalloc(max + 1);
	int index = max;
	{ // Unsafe block
		buf[index--] = '\0';
	}
	for (;;) {
		if (!(n > 0)) break;
		u64 n1 = n / 100;
		d = ((n - (n1 * 100)) << 1);
		n = n1;
		{ // Unsafe block
			buf[index--] = string_at(_const_digit_pairs, d++);
			buf[index--] = string_at(_const_digit_pairs, d);
		}
	}
	index++;
	if (d < 20) {
		index++;
	}
	{ // Unsafe block
		memmove(buf, buf + index, (max - index) + 1);
		return tos(buf, (max - index));
	}
	return (string){.str=(byteptr)""};
}

string bool_str(bool b) {
	if (b) {
		return _SLIT("true");
	}
	return _SLIT("false");
}

// Attr: [inline]
inline string u64_to_hex(u64 nn, byte len) {
	u64 n = nn;
	array_fixed_byte_256 buf = {0};
	buf[len] = '\0';
	int i = 0;
	for (i = len - 1; i >= 0; i--) {
		byte d = ((byte)((n & 0xF)));
		rune x = (d < 10 ? (d + '0') : (d + 87));
		buf[i] = x;
		n = n >> 4;
	}
	return (string){.str = memdup((voidptr)&/*qq*/buf, len + 1), .len = len};
}

// Attr: [inline]
inline string u64_to_hex_no_leading_zeros(u64 nn, byte len) {
	u64 n = nn;
	array_fixed_byte_256 buf = {0};
	buf[len] = '\0';
	int i = 0;
	for (i = len - 1; i >= 0; i--) {
		byte d = ((byte)((n & 0xF)));
		rune x = (d < 10 ? (d + '0') : (d + 87));
		buf[i] = x;
		n = n >> 4;
		if (n == 0) {
			break;
		}
	}
	int res_len = len - i;
	return (string){.str = memdup(&buf[i], res_len + 1), .len = res_len};
}

string byte_hex(byte nn) {
	if (nn == 0) {
		return _SLIT("00");
	}
	return u64_to_hex(nn, 2);
}

string i8_hex(i8 nn) {
	return byte_hex(((byte)(nn)));
}

string u16_hex(u16 nn) {
	if (nn == 0) {
		return _SLIT("0");
	}
	return u64_to_hex_no_leading_zeros(nn, 4);
}

string i16_hex(i16 nn) {
	return u16_hex(((u16)(nn)));
}

string u32_hex(u32 nn) {
	if (nn == 0) {
		return _SLIT("0");
	}
	return u64_to_hex_no_leading_zeros(nn, 8);
}

string int_hex(int nn) {
	return u32_hex(((u32)(nn)));
}

string int_hex2(int n) {
	return string_add(_SLIT("0x"), int_hex(n));
}

string u64_hex(u64 nn) {
	if (nn == 0) {
		return _SLIT("0");
	}
	return u64_to_hex_no_leading_zeros(nn, 16);
}

string i64_hex(i64 nn) {
	return u64_hex(((u64)(nn)));
}

string any_int_hex(any_int nn) {
	return u64_hex(((u64)(nn)));
}

string voidptr_str(voidptr nn) {
	return u64_hex(((u64)(nn)));
}

string byteptr_str(byteptr nn) {
	return u64_hex(((u64)(nn)));
}

string u64_hex_full(u64 nn) {
	return u64_to_hex(nn, 16);
}

string byte_str(byte b) {
	string str = (string){.str = v_malloc(2), .len = 1};
	{ // Unsafe block
		str.str[0] = b;
		str.str[1] = '\0';
	}
	return str;
}

string byte_str_escaped(byte b) {
	byte _t30 = b; 
		string str = ((_t30 == 0) ? (string_add(_SLIT("`\\"), _SLIT("0`"))) : (_t30 == 7) ? (_SLIT("`\\a`")) : (_t30 == 8) ? (_SLIT("`\\b`")) : (_t30 == 9) ? (_SLIT("`\\t`")) : (_t30 == 10) ? (_SLIT("`\\n`")) : (_t30 == 11) ? (_SLIT("`\\v`")) : (_t30 == 12) ? (_SLIT("`\\f`")) : (_t30 == 13) ? (_SLIT("`\\r`")) : ((_t30 >= 32 && _t30 <= 126)) ? (byte_str(b)) : (string_add(_SLIT("0x"), byte_hex(b))));
	return str;
}

// Attr: [inline]
inline bool fast_string_eq(string a, string b) {
	if (a.len != b.len) {
		return false;
	}
	{ // Unsafe block
		return memcmp(a.str, b.str, b.len) == 0;
	}
	return 0;
}

// Attr: [inline]
// Attr: [unsafe]
inline DenseArray new_dense_array(int key_bytes, int value_bytes) {
	int slot_bytes = key_bytes + value_bytes;
	int cap = 8;
	return (DenseArray){
		.key_bytes = key_bytes,
		.value_bytes = value_bytes,
		.slot_bytes = slot_bytes,
		.cap = cap,
		.len = 0,
		.deletes = 0,
		.all_deleted = 0,
		.data = v_malloc(cap * slot_bytes),
	};
}

// Attr: [inline]
inline voidptr DenseArray_key(DenseArray* d, int i) {
	return d->data + i * d->slot_bytes;
}

// Attr: [inline]
inline voidptr DenseArray_value(DenseArray* d, int i) {
	return d->data + i * d->slot_bytes + d->key_bytes;
}

// Attr: [inline]
inline bool DenseArray_has_index(DenseArray* d, int i) {
	return d->deletes == 0 || d->all_deleted[i] == 0;
}

// Attr: [inline]
inline int DenseArray_expand(DenseArray* d) {
	if (d->cap == d->len) {
		d->cap += d->cap >> 3;
		{ // Unsafe block
			d->data = v_realloc(d->data, d->slot_bytes * d->cap);
			if (d->deletes != 0) {
				d->all_deleted = v_realloc(d->all_deleted, d->cap);
				memset(d->all_deleted + d->len, 0, d->cap - d->len);
			}
		}
	}
	int push_index = d->len;
	{ // Unsafe block
		if (d->deletes != 0) {
			d->all_deleted[push_index] = 0;
		}
	}
	d->len++;
	return push_index;
}

void DenseArray_zeros_to_end(DenseArray* d) {
	byteptr tmp_buf = v_malloc(d->slot_bytes);
	int count = 0;
	for (int i = 0; i < d->len; ++i) {
		if (DenseArray_has_index(d, i)) {
			{ // Unsafe block
				memcpy(tmp_buf, DenseArray_key(d, count), d->slot_bytes);
				memcpy(DenseArray_key(d, count), DenseArray_key(d, i), d->slot_bytes);
				memcpy(DenseArray_key(d, i), tmp_buf, d->slot_bytes);
			}
			count++;
		}
	}
	v_free(tmp_buf);
	d->deletes = 0;
	v_free(d->all_deleted);
	d->len = count;
	d->cap = (count < 8 ? (8) : (count));
	{ // Unsafe block
		d->data = v_realloc(d->data, d->slot_bytes * d->cap);
	}
}

// TypeDecl
// TypeDecl
// TypeDecl
// TypeDecl
u64 map_hash_string(voidptr pkey) {
	string key = *((string*)(pkey));
	return hash__wyhash_c(key.str, ((u64)(key.len)), 0);
}

u64 map_hash_int_1(voidptr pkey) {
	return hash__wyhash64_c(*((byte*)(pkey)), 0);
}

u64 map_hash_int_2(voidptr pkey) {
	return hash__wyhash64_c(*((u16*)(pkey)), 0);
}

u64 map_hash_int_4(voidptr pkey) {
	return hash__wyhash64_c(*((u32*)(pkey)), 0);
}

u64 map_hash_int_8(voidptr pkey) {
	return hash__wyhash64_c(*((u64*)(pkey)), 0);
}

bool map_eq_string(voidptr a, voidptr b) {
	return fast_string_eq(*((string*)(a)), *((string*)(b)));
}

bool map_eq_int_1(voidptr a, voidptr b) {
	return *((byte*)(a)) == *((byte*)(b));
}

bool map_eq_int_2(voidptr a, voidptr b) {
	return *((u16*)(a)) == *((u16*)(b));
}

bool map_eq_int_4(voidptr a, voidptr b) {
	return *((u32*)(a)) == *((u32*)(b));
}

bool map_eq_int_8(voidptr a, voidptr b) {
	return *((u64*)(a)) == *((u64*)(b));
}

void map_clone_string(voidptr dest, voidptr pkey) {
	{ // Unsafe block
		string s = *((string*)(pkey));
		(*((string*)(dest))) = string_clone(s);
	}
}

void map_clone_int_1(voidptr dest, voidptr pkey) {
	{ // Unsafe block
		*((byte*)(dest)) = *((byte*)(pkey));
	}
}

void map_clone_int_2(voidptr dest, voidptr pkey) {
	{ // Unsafe block
		*((u16*)(dest)) = *((u16*)(pkey));
	}
}

void map_clone_int_4(voidptr dest, voidptr pkey) {
	{ // Unsafe block
		*((u32*)(dest)) = *((u32*)(pkey));
	}
}

void map_clone_int_8(voidptr dest, voidptr pkey) {
	{ // Unsafe block
		*((u64*)(dest)) = *((u64*)(pkey));
	}
}

void map_free_string(voidptr pkey) {
	string_free(&(*((string*)(pkey))));
}

void map_free_nop(voidptr _) {
}

map new_map_2(int key_bytes, int value_bytes, MapHashFn hash_fn, MapEqFn key_eq_fn, MapCloneFn clone_fn, MapFreeFn free_fn) {
	int metasize = ((int)(/*SizeOfType*/ sizeof(u32) * (_const_init_capicity + _const_extra_metas_inc)));
	bool has_string_keys = _us32_lt(/*SizeOfType*/ sizeof(voidptr),key_bytes);
	return (map){
		.key_bytes = key_bytes,
		.value_bytes = value_bytes,
		.even_index = _const_init_even_index,
		.cached_hashbits = _const_max_cached_hashbits,
		.shift = _const_init_log_capicity,
		.key_values = new_dense_array(key_bytes, value_bytes),
		.metas = ((u32*)(vcalloc(metasize))),
		.extra_metas = _const_extra_metas_inc,
		.has_string_keys = has_string_keys,
		.hash_fn = hash_fn,
		.key_eq_fn = key_eq_fn,
		.clone_fn = clone_fn,
		.free_fn = free_fn,
		.len = 0,
	};
}

map new_map_init_2(MapHashFn hash_fn, MapEqFn key_eq_fn, MapCloneFn clone_fn, MapFreeFn free_fn, int n, int key_bytes, int value_bytes, voidptr keys, voidptr values) {
	map out = new_map_2(key_bytes, value_bytes, hash_fn, key_eq_fn, clone_fn, free_fn);
	byteptr pkey = ((byteptr)(keys));
	byteptr pval = ((byteptr)(values));
	for (int _t31 = 0; _t31 < n; ++_t31) {
		{ // Unsafe block
			map_set_1(&out, pkey, pval);
			pkey += key_bytes;
			pval += value_bytes;
		}
	}
	return out;
}

// Attr: [inline]
inline multi_return_u32_u32 map_key_to_index(map* m, voidptr pkey) {
	u64 hash = m->hash_fn(pkey);
	u64 index = (hash & m->even_index);
	u64 meta = ((((hash >> m->shift) & _const_hash_mask)) | _const_probe_inc);
	return (multi_return_u32_u32){.arg0=((u32)(index)), .arg1=((u32)(meta))};
}

// Attr: [inline]
inline multi_return_u32_u32 map_meta_less(map* m, u32 _index, u32 _metas) {
	u32 index = _index;
	u32 meta = _metas;
	for (;;) {
		if (!(meta < m->metas[index])) break;
		index += 2;
		meta += _const_probe_inc;
	}
	return (multi_return_u32_u32){.arg0=index, .arg1=meta};
}

// Attr: [inline]
inline void map_meta_greater(map* m, u32 _index, u32 _metas, u32 kvi) {
	u32 meta = _metas;
	u32 index = _index;
	u32 kv_index = kvi;
	for (;;) {
		if (!(m->metas[index] != 0)) break;
		if (meta > m->metas[index]) {
			{ // Unsafe block
				u32 tmp_meta = m->metas[index];
				m->metas[index] = meta;
				meta = tmp_meta;
				u32 tmp_index = m->metas[index + 1];
				m->metas[index + 1] = kv_index;
				kv_index = tmp_index;
			}
		}
		index += 2;
		meta += _const_probe_inc;
	}
	{ // Unsafe block
		m->metas[index] = meta;
		m->metas[index + 1] = kv_index;
	}
	u32 probe_count = (meta >> _const_hashbits) - 1;
	map_ensure_extra_metas(m, probe_count);
}

// Attr: [inline]
inline void map_ensure_extra_metas(map* m, u32 probe_count) {
	if ((probe_count << 1) == m->extra_metas) {
		m->extra_metas += _const_extra_metas_inc;
		u32 mem_size = (m->even_index + 2 + m->extra_metas);
		{ // Unsafe block
			byteptr x = v_realloc(((byteptr)(m->metas)), ((int)(/*SizeOfType*/ sizeof(u32) * mem_size)));
			m->metas = ((u32*)(x));
			memset(m->metas + mem_size - _const_extra_metas_inc, 0, ((int)(/*SizeOfType*/ sizeof(u32) * _const_extra_metas_inc)));
		}
		if (probe_count == 252) {
			panic_debug(406, tos3("/DATA/projects/web/v/v/vlib/builtin/map.v"), tos3("builtin"), tos3("ensure_extra_metas"),  _SLIT("Probe overflow"));
		}
	}
}

void map_set_1(map* m, voidptr key, voidptr value) {
	f32 load_factor = ((f32)(m->len << 1)) / ((f32)(m->even_index));
	if (load_factor > _const_max_load_factor) {
		map_expand(m);
	}
	multi_return_u32_u32 mr_11819 = map_key_to_index(m, key);
	u32 index = mr_11819.arg0;
	u32 meta = mr_11819.arg1;
	multi_return_u32_u32 mr_11855 = map_meta_less(m, index, meta);
	index = mr_11855.arg0;
	meta = mr_11855.arg1;
	for (;;) {
		if (!(meta == m->metas[index])) break;
		int kv_index = ((int)(m->metas[index + 1]));
		voidptr pkey = DenseArray_key(&m->key_values, kv_index);
		if (m->key_eq_fn(key, pkey)) {
			{ // Unsafe block
				byteptr pval = ((byteptr)(pkey)) + m->key_bytes;
				memcpy(pval, value, m->value_bytes);
			}
			return;
		}
		index += 2;
		meta += _const_probe_inc;
	}
	int kv_index = DenseArray_expand(&m->key_values);
	{ // Unsafe block
		voidptr pkey = DenseArray_key(&m->key_values, kv_index);
		m->clone_fn(pkey, key);
		memcpy(((byteptr)(pkey)) + m->key_bytes, value, m->value_bytes);
	}
	map_meta_greater(m, index, meta, ((u32)(kv_index)));
	m->len++;
}

void map_expand(map* m) {
	u32 old_cap = m->even_index;
	m->even_index = ((m->even_index + 2) << 1) - 2;
	if (m->cached_hashbits == 0) {
		m->shift += _const_max_cached_hashbits;
		m->cached_hashbits = _const_max_cached_hashbits;
		map_rehash(m);
	} else {
		map_cached_rehash(m, old_cap);
		m->cached_hashbits--;
	}
}

void map_rehash(map* m) {
	u32 meta_bytes = /*SizeOfType*/ sizeof(u32) * (m->even_index + 2 + m->extra_metas);
	{ // Unsafe block
		byteptr x = v_realloc(((byteptr)(m->metas)), ((int)(meta_bytes)));
		m->metas = ((u32*)(x));
		memset(m->metas, 0, meta_bytes);
	}
	for (int i = 0; i < m->key_values.len; i++) {
		if (!DenseArray_has_index(&m->key_values, i)) {
			continue;
		}
		voidptr pkey = DenseArray_key(&m->key_values, i);
		multi_return_u32_u32 mr_13457 = map_key_to_index(m, pkey);
		u32 index = mr_13457.arg0;
		u32 meta = mr_13457.arg1;
		multi_return_u32_u32 mr_13495 = map_meta_less(m, index, meta);
		index = mr_13495.arg0;
		meta = mr_13495.arg1;
		map_meta_greater(m, index, meta, ((u32)(i)));
	}
}

void map_cached_rehash(map* m, u32 old_cap) {
	u32* old_metas = m->metas;
	int metasize = ((int)(/*SizeOfType*/ sizeof(u32) * (m->even_index + 2 + m->extra_metas)));
	m->metas = ((u32*)(vcalloc(metasize)));
	u32 old_extra_metas = m->extra_metas;
	for (u32 i = ((u32)(0U)); i <= old_cap + old_extra_metas; i += 2) {
		if (old_metas[i] == 0) {
			continue;
		}
		u32 old_meta = old_metas[i];
		u32 old_probe_count = ((old_meta >> _const_hashbits) - 1) << 1;
		u32 old_index = ((i - old_probe_count) & (m->even_index >> 1));
		u32 index = (((old_index | (old_meta << m->shift))) & m->even_index);
		u32 meta = (((old_meta & _const_hash_mask)) | _const_probe_inc);
		multi_return_u32_u32 mr_14283 = map_meta_less(m, index, meta);
		index = mr_14283.arg0;
		meta = mr_14283.arg1;
		u32 kv_index = old_metas[i + 1];
		map_meta_greater(m, index, meta, kv_index);
	}
	v_free(old_metas);
}

voidptr map_get_and_set_1(map* m, voidptr key, voidptr zero) {
	for (;;) {
		multi_return_u32_u32 mr_14733 = map_key_to_index(m, key);
		u32 index = mr_14733.arg0;
		u32 meta = mr_14733.arg1;
		for (;;) {
			if (meta == m->metas[index]) {
				int kv_index = ((int)(m->metas[index + 1]));
				voidptr pkey = DenseArray_key(&m->key_values, kv_index);
				if (m->key_eq_fn(key, pkey)) {
					return ((byteptr)(pkey)) + m->key_values.key_bytes;
				}
			}
			index += 2;
			meta += _const_probe_inc;
			if (meta > m->metas[index]) {
				break;
			}
		}
		map_set_1(m, key, zero);
	}
	// assert
	if (false) {} else {
		VAssertMetaInfo v_assert_meta_info__t32;
		memset(&v_assert_meta_info__t32, 0, sizeof(VAssertMetaInfo));
		v_assert_meta_info__t32.fpath = _SLIT("/DATA/projects/web/v/v/vlib/builtin/map.v");
		v_assert_meta_info__t32.line_nr = 528;
		v_assert_meta_info__t32.fn_name = _SLIT("get_and_set_1");
		v_assert_meta_info__t32.src = _SLIT("false");
		__print_assert_failure(&v_assert_meta_info__t32);
		v_panic(_SLIT("Assertion failed..."));
		exit(1);
	}
	return ((voidptr)(0));
}

voidptr map_get_1(map* m, voidptr key, voidptr zero) {
	multi_return_u32_u32 mr_15450 = map_key_to_index(m, key);
	u32 index = mr_15450.arg0;
	u32 meta = mr_15450.arg1;
	for (;;) {
		if (meta == m->metas[index]) {
			int kv_index = ((int)(m->metas[index + 1]));
			voidptr pkey = DenseArray_key(&m->key_values, kv_index);
			if (m->key_eq_fn(key, pkey)) {
				return ((byteptr)(pkey)) + m->key_values.key_bytes;
			}
		}
		index += 2;
		meta += _const_probe_inc;
		if (meta > m->metas[index]) {
			break;
		}
	}
	return zero;
}

bool map_exists_1(map* m, voidptr key) {
	multi_return_u32_u32 mr_15942 = map_key_to_index(m, key);
	u32 index = mr_15942.arg0;
	u32 meta = mr_15942.arg1;
	for (;;) {
		if (meta == m->metas[index]) {
			int kv_index = ((int)(m->metas[index + 1]));
			voidptr pkey = DenseArray_key(&m->key_values, kv_index);
			if (m->key_eq_fn(key, pkey)) {
				return true;
			}
		}
		index += 2;
		meta += _const_probe_inc;
		if (meta > m->metas[index]) {
			break;
		}
	}
	return false;
}

// Attr: [inline]
inline void DenseArray_delete(DenseArray* d, int i) {
	if (d->deletes == 0) {
		d->all_deleted = vcalloc(d->cap);
	}
	d->deletes++;
	{ // Unsafe block
		d->all_deleted[i] = 1;
	}
}

void map_delete(map* m, string key) {
	map_delete_1(m, &key);
}

void map_delete_1(map* m, voidptr key) {
	multi_return_u32_u32 mr_16640 = map_key_to_index(m, key);
	u32 index = mr_16640.arg0;
	u32 meta = mr_16640.arg1;
	multi_return_u32_u32 mr_16676 = map_meta_less(m, index, meta);
	index = mr_16676.arg0;
	meta = mr_16676.arg1;
	for (;;) {
		if (!(meta == m->metas[index])) break;
		int kv_index = ((int)(m->metas[index + 1]));
		voidptr pkey = DenseArray_key(&m->key_values, kv_index);
		if (m->key_eq_fn(key, pkey)) {
			for (;;) {
				if (!((m->metas[index + 2] >> _const_hashbits) > 1)) break;
				{ // Unsafe block
					m->metas[index] = m->metas[index + 2] - _const_probe_inc;
					m->metas[index + 1] = m->metas[index + 3];
				}
				index += 2;
			}
			m->len--;
			DenseArray_delete(&m->key_values, kv_index);
			{ // Unsafe block
				m->metas[index] = 0;
				m->free_fn(pkey);
				memset(pkey, 0, m->key_bytes);
			}
			if (m->key_values.len <= 32) {
				return;
			}
			if (_us32_ge(m->key_values.deletes,(m->key_values.len >> 1))) {
				DenseArray_zeros_to_end(&m->key_values);
				map_rehash(m);
			}
			return;
		}
		index += 2;
		meta += _const_probe_inc;
	}
}

array_string map_keys(map* m) {
	array_string keys = __new_array_with_default(m->len, 0, sizeof(string), &(string[]){_SLIT("")});
	byteptr item = ((byteptr)(keys.data));
	for (int i = 0; i < m->key_values.len; i++) {
		if (!DenseArray_has_index(&m->key_values, i)) {
			continue;
		}
		{ // Unsafe block
			voidptr pkey = DenseArray_key(&m->key_values, i);
			m->clone_fn(item, pkey);
			item += m->key_bytes;
		}
	}
	return keys;
}

array map_keys_1(map* m) {
	array keys = __new_array(m->len, 0, m->key_bytes);
	byteptr item = ((byteptr)(keys.data));
	if (m->key_values.deletes == 0) {
		for (int i = 0; i < m->key_values.len; i++) {
			{ // Unsafe block
				voidptr pkey = DenseArray_key(&m->key_values, i);
				m->clone_fn(item, pkey);
				item += m->key_bytes;
			}
		}
		return keys;
	}
	for (int i = 0; i < m->key_values.len; i++) {
		if (!DenseArray_has_index(&m->key_values, i)) {
			continue;
		}
		{ // Unsafe block
			voidptr pkey = DenseArray_key(&m->key_values, i);
			m->clone_fn(item, pkey);
			item += m->key_bytes;
		}
	}
	return keys;
}

// Attr: [unsafe]
DenseArray DenseArray_clone(DenseArray* d) {
	DenseArray res = (DenseArray){
		.key_bytes = d->key_bytes,
		.value_bytes = d->value_bytes,
		.slot_bytes = d->slot_bytes,
		.cap = d->cap,
		.len = d->len,
		.deletes = d->deletes,
		.all_deleted = 0,
		.data = 0,
	};
	{ // Unsafe block
		if (d->deletes != 0) {
			res.all_deleted = memdup(d->all_deleted, d->cap);
		}
		res.data = memdup(d->data, d->cap * d->slot_bytes);
	}
	return res;
}

// Attr: [unsafe]
map map_clone(map* m) {
	int metasize = ((int)(/*SizeOfType*/ sizeof(u32) * (m->even_index + 2 + m->extra_metas)));
	map res = (map){
		.key_bytes = m->key_bytes,
		.value_bytes = m->value_bytes,
		.even_index = m->even_index,
		.cached_hashbits = m->cached_hashbits,
		.shift = m->shift,
		.key_values = DenseArray_clone(&m->key_values),
		.metas = ((u32*)(v_malloc(metasize))),
		.extra_metas = m->extra_metas,
		.has_string_keys = m->has_string_keys,
		.hash_fn = m->hash_fn,
		.key_eq_fn = m->key_eq_fn,
		.clone_fn = m->clone_fn,
		.free_fn = m->free_fn,
		.len = m->len,
	};
	memcpy(res.metas, m->metas, metasize);
	if (!m->has_string_keys) {
		return res;
	}
	for (int i = 0; i < m->key_values.len; ++i) {
		if (!DenseArray_has_index(&m->key_values, i)) {
			continue;
		}
		m->clone_fn(DenseArray_key(&res.key_values, i), DenseArray_key(&m->key_values, i));
	}
	return res;
}

// Attr: [unsafe]
void map_free(map* m) {
	v_free(m->metas);
	if (m->key_values.deletes == 0) {
		for (int i = 0; i < m->key_values.len; i++) {
			{ // Unsafe block
				voidptr pkey = DenseArray_key(&m->key_values, i);
				m->free_fn(pkey);
			}
		}
	} else {
		for (int i = 0; i < m->key_values.len; i++) {
			if (!DenseArray_has_index(&m->key_values, i)) {
				continue;
			}
			{ // Unsafe block
				voidptr pkey = DenseArray_key(&m->key_values, i);
				m->free_fn(pkey);
			}
		}
		v_free(m->key_values.all_deleted);
	}
	v_free(m->key_values.data);
}

void opt_ok2(voidptr data, OptionBase* option, int size) {
	{ // Unsafe block
		*option = (OptionBase){.ok = true,.is_none = 0,.v_error = (string){.str=(byteptr)""},.ecode = 0,};
		memcpy(((byteptr)(&option->ecode)) + /*SizeOfType*/ sizeof(int), data, size);
	}
}

string Option_str(Option o) {
	if (o.ok && !o.is_none) {
		return _SLIT("Option{ ok }");
	}
	if (o.is_none) {
		return _SLIT("Option{ none }");
	}
	return _STR("Option{ error: \"%.*s\000\" }", 2, o.v_error);
}

Option opt_none() {
	return (Option){.ok = false,.is_none = true,.v_error = (string){.str=(byteptr)""},.ecode = 0,};
}

Option v_error(string message) {
	return (Option){.ok = false,.is_none = false,.v_error = message,.ecode = 0,};
}

Option error_with_code(string message, int code) {
	return (Option){.ok = false,.is_none = false,.v_error = message,.ecode = code,};
}

string rune_str(rune c) {
	return utf32_to_str(((u32)(c)));
}

bool byte_is_capital(byte c) {
	return c >= 'A' && c <= 'Z';
}

array_byte array_byte_clone(array_byte b) {
	array_byte res = __new_array_with_default(b.len, 0, sizeof(byte), 0);
	for (int i = 0; i < b.len; ++i) {
		array_set(&res, i, &(byte[]) { (*(byte*)/*ee elem_typ */array_get(b, i)) });
	}
	return res;
}

string array_byte_bytestr(array_byte b) {
	return bytes2string(b);
}

string bytes2string(array_byte b) {
	array_byte copy = array_clone(&b);
	array_push(&copy, _MOV((byte[]){ '\0' }));
	string res = tos(copy.data, copy.len - 1);
	return res;
}

SortedMap new_sorted_map(int n, int value_bytes) {
	return (SortedMap){.value_bytes = value_bytes,.root = new_node(),.len = 0,};
}

SortedMap new_sorted_map_init(int n, int value_bytes, string* keys, voidptr values) {
	SortedMap out = new_sorted_map(n, value_bytes);
	for (int i = 0; i < n; ++i) {
		SortedMap_set(&out, keys[i], ((byteptr)(values)) + i * value_bytes);
	}
	return out;
}

mapnode* new_node() {
	return (mapnode*)memdup(&(mapnode){.children = 0,.len = 0,.keys = {0},.values = {0},}, sizeof(mapnode));
}

void SortedMap_set(SortedMap* m, string key, voidptr value) {
	mapnode* node = m->root;
	int child_index = 0;
	mapnode* parent = ((mapnode*)(0));
	for (;;) {
		if (node->len == _const_max_len) {
			if (isnil(parent)) {
				parent = new_node();
				m->root = parent;
			}
			mapnode_split_child(parent, child_index, node);
			if (string_eq(key, parent->keys[child_index])) {
				memcpy(parent->values[child_index], value, m->value_bytes);
				return;
			}
			if (string_lt(key, parent->keys[child_index])) {
				node = ((mapnode*)(parent->children[child_index]));
			} else {
				node = ((mapnode*)(parent->children[child_index + 1]));
			}
		}
		int i = 0;
		for (;;) {
			if (!(i < node->len && string_gt(key, node->keys[i]))) break;
			i++;
		}
		if (i != node->len && string_eq(key, node->keys[i])) {
			memcpy(node->values[i], value, m->value_bytes);
			return;
		}
		if (isnil(node->children)) {
			int j = node->len - 1;
			for (;;) {
				if (!(j >= 0 && string_lt(key, node->keys[j]))) break;
				node->keys[j + 1] = node->keys[j];
				node->values[j + 1] = node->values[j];
				j--;
			}
			node->keys[j + 1] = key;
			node->values[j + 1] = v_malloc(m->value_bytes);
			memcpy(node->values[j + 1], value, m->value_bytes);
			node->len++;
			m->len++;
			return;
		}
		parent = node;
		child_index = i;
		node = ((mapnode*)(node->children[child_index]));
	}
}

void mapnode_split_child(mapnode* n, int child_index, mapnode* y) {
	mapnode* z = new_node();
	z->len = _const_mid_index;
	y->len = _const_mid_index;
	for (int j = _const_mid_index - 1; j >= 0; j--) {
		z->keys[j] = y->keys[j + _const_degree];
		z->values[j] = y->values[j + _const_degree];
	}
	if (!isnil(y->children)) {
		z->children = ((voidptr*)(v_malloc(((int)(_const_children_bytes)))));
		for (int jj = _const_degree - 1; jj >= 0; jj--) {
			{ // Unsafe block
				z->children[jj] = y->children[jj + _const_degree];
			}
		}
	}
	if (isnil(n->children)) {
		n->children = ((voidptr*)(v_malloc(((int)(_const_children_bytes)))));
	}
	{ // Unsafe block
		n->children[n->len + 1] = n->children[n->len];
	}
	for (int j = n->len; j > child_index; j--) {
		n->keys[j] = n->keys[j - 1];
		n->values[j] = n->values[j - 1];
		{ // Unsafe block
			n->children[j] = n->children[j - 1];
		}
	}
	n->keys[child_index] = y->keys[_const_mid_index];
	n->values[child_index] = y->values[_const_mid_index];
	{ // Unsafe block
		n->children[child_index] = ((voidptr)(y));
		n->children[child_index + 1] = ((voidptr)(z));
	}
	n->len++;
}

bool SortedMap_get(SortedMap m, string key, voidptr out) {
	mapnode* node = m.root;
	for (;;) {
		int i = node->len - 1;
		for (;;) {
			if (!(i >= 0 && string_lt(key, node->keys[i]))) break;
			i--;
		}
		if (i != -1 && string_eq(key, node->keys[i])) {
			memcpy(out, node->values[i], m.value_bytes);
			return true;
		}
		if (isnil(node->children)) {
			break;
		}
		node = ((mapnode*)(node->children[i + 1]));
	}
	return false;
}

bool SortedMap_exists(SortedMap m, string key) {
	if (isnil(m.root)) {
		return false;
	}
	mapnode* node = m.root;
	for (;;) {
		int i = node->len - 1;
		for (;;) {
			if (!(i >= 0 && string_lt(key, node->keys[i]))) break;
			i--;
		}
		if (i != -1 && string_eq(key, node->keys[i])) {
			return true;
		}
		if (isnil(node->children)) {
			break;
		}
		node = ((mapnode*)(node->children[i + 1]));
	}
	return false;
}

int mapnode_find_key(mapnode* n, string k) {
	int idx = 0;
	for (;;) {
		if (!(idx < n->len && string_lt(n->keys[idx], k))) break;
		idx++;
	}
	return idx;
}

bool mapnode_remove_key(mapnode* n, string k) {
	int idx = mapnode_find_key(n, k);
	if (idx < n->len && string_eq(n->keys[idx], k)) {
		if (isnil(n->children)) {
			mapnode_remove_from_leaf(n, idx);
		} else {
			mapnode_remove_from_non_leaf(n, idx);
		}
		return true;
	} else {
		if (isnil(n->children)) {
			return false;
		}
		bool flag = (idx == n->len ? (true) : (false));
		if (((mapnode*)(n->children[idx]))->len < _const_degree) {
			mapnode_fill(n, idx);
		}
		mapnode* node = ((mapnode*)(0));
		if (flag && idx > n->len) {
			node = ((mapnode*)(n->children[idx - 1]));
		} else {
			node = ((mapnode*)(n->children[idx]));
		}
		return mapnode_remove_key(node, k);
	}
	return 0;
}

void mapnode_remove_from_leaf(mapnode* n, int idx) {
	for (int i = idx + 1; i < n->len; i++) {
		n->keys[i - 1] = n->keys[i];
		n->values[i - 1] = n->values[i];
	}
	n->len--;
}

void mapnode_remove_from_non_leaf(mapnode* n, int idx) {
	string k = n->keys[idx];
	if (((mapnode*)(n->children[idx]))->len >= _const_degree) {
		mapnode* current = ((mapnode*)(n->children[idx]));
		for (;;) {
			if (!(!isnil(current->children))) break;
			current = ((mapnode*)(current->children[current->len]));
		}
		string predecessor = current->keys[current->len - 1];
		n->keys[idx] = predecessor;
		n->values[idx] = current->values[current->len - 1];
		mapnode* node = ((mapnode*)(n->children[idx]));
		mapnode_remove_key(node, predecessor);
	} else if (((mapnode*)(n->children[idx + 1]))->len >= _const_degree) {
		mapnode* current = ((mapnode*)(n->children[idx + 1]));
		for (;;) {
			if (!(!isnil(current->children))) break;
			current = ((mapnode*)(current->children[0]));
		}
		string successor = current->keys[0];
		n->keys[idx] = successor;
		n->values[idx] = current->values[0];
		mapnode* node = ((mapnode*)(n->children[idx + 1]));
		mapnode_remove_key(node, successor);
	} else {
		mapnode_merge(n, idx);
		mapnode* node = ((mapnode*)(n->children[idx]));
		mapnode_remove_key(node, k);
	}
}

void mapnode_fill(mapnode* n, int idx) {
	if (idx != 0 && ((mapnode*)(n->children[idx - 1]))->len >= _const_degree) {
		mapnode_borrow_from_prev(n, idx);
	} else if (idx != n->len && ((mapnode*)(n->children[idx + 1]))->len >= _const_degree) {
		mapnode_borrow_from_next(n, idx);
	} else if (idx != n->len) {
		mapnode_merge(n, idx);
	} else {
		mapnode_merge(n, idx - 1);
	}
}

void mapnode_borrow_from_prev(mapnode* n, int idx) {
	mapnode* child = ((mapnode*)(n->children[idx]));
	mapnode* sibling = ((mapnode*)(n->children[idx - 1]));
	for (int i = child->len - 1; i >= 0; i--) {
		child->keys[i + 1] = child->keys[i];
		child->values[i + 1] = child->values[i];
	}
	if (!isnil(child->children)) {
		for (int i = child->len; i >= 0; i--) {
			{ // Unsafe block
				child->children[i + 1] = child->children[i];
			}
		}
	}
	child->keys[0] = n->keys[idx - 1];
	child->values[0] = n->values[idx - 1];
	if (!isnil(child->children)) {
		{ // Unsafe block
			child->children[0] = sibling->children[sibling->len];
		}
	}
	n->keys[idx - 1] = sibling->keys[sibling->len - 1];
	n->values[idx - 1] = sibling->values[sibling->len - 1];
	child->len++;
	sibling->len--;
}

void mapnode_borrow_from_next(mapnode* n, int idx) {
	mapnode* child = ((mapnode*)(n->children[idx]));
	mapnode* sibling = ((mapnode*)(n->children[idx + 1]));
	child->keys[child->len] = n->keys[idx];
	child->values[child->len] = n->values[idx];
	if (!isnil(child->children)) {
		{ // Unsafe block
			child->children[child->len + 1] = sibling->children[0];
		}
	}
	n->keys[idx] = sibling->keys[0];
	n->values[idx] = sibling->values[0];
	for (int i = 1; i < sibling->len; i++) {
		sibling->keys[i - 1] = sibling->keys[i];
		sibling->values[i - 1] = sibling->values[i];
	}
	if (!isnil(sibling->children)) {
		for (int i = 1; i <= sibling->len; i++) {
			{ // Unsafe block
				sibling->children[i - 1] = sibling->children[i];
			}
		}
	}
	child->len++;
	sibling->len--;
}

void mapnode_merge(mapnode* n, int idx) {
	mapnode* child = ((mapnode*)(n->children[idx]));
	mapnode* sibling = ((mapnode*)(n->children[idx + 1]));
	child->keys[_const_mid_index] = n->keys[idx];
	child->values[_const_mid_index] = n->values[idx];
	for (int i = 0; i < sibling->len; ++i) {
		child->keys[i + _const_degree] = sibling->keys[i];
		child->values[i + _const_degree] = sibling->values[i];
	}
	if (!isnil(child->children)) {
		for (int i = 0; i <= sibling->len; i++) {
			{ // Unsafe block
				child->children[i + _const_degree] = sibling->children[i];
			}
		}
	}
	for (int i = idx + 1; i < n->len; i++) {
		n->keys[i - 1] = n->keys[i];
		n->values[i - 1] = n->values[i];
	}
	for (int i = idx + 2; i <= n->len; i++) {
		{ // Unsafe block
			n->children[i - 1] = n->children[i];
		}
	}
	child->len += sibling->len + 1;
	n->len--;
}

void SortedMap_delete(SortedMap* m, string key) {
	if (m->root->len == 0) {
		return;
	}
	bool removed = mapnode_remove_key(m->root, key);
	if (removed) {
		m->len--;
	}
	if (m->root->len == 0) {
		if (isnil(m->root->children)) {
			return;
		} else {
			m->root = ((mapnode*)(m->root->children[0]));
		}
	}
}

int mapnode_subkeys(mapnode* n, array_string* keys, int at) {
	int position = at;
	if (!isnil(n->children)) {
		for (int i = 0; i < n->len; ++i) {
			mapnode* child = ((mapnode*)(n->children[i]));
			position += mapnode_subkeys(child, keys, position);
			array_set(keys, position, &(string[]) { n->keys[i] });
			position++;
		}
		mapnode* child = ((mapnode*)(n->children[n->len]));
		position += mapnode_subkeys(child, keys, position);
	} else {
		for (int i = 0; i < n->len; ++i) {
			array_set(keys, position + i, &(string[]) { n->keys[i] });
		}
		position += n->len;
	}
	return position - at;
}

array_string SortedMap_keys(SortedMap* m) {
	array_string keys = __new_array_with_default(m->len, 0, sizeof(string), &(string[]){_SLIT("")});
	if (isnil(m->root) || m->root->len == 0) {
		return keys;
	}
	mapnode_subkeys(m->root, &/*arr*/keys, 0);
	return keys;
}

void mapnode_free(mapnode* n) {
	println(_SLIT("TODO"));
}

void SortedMap_free(SortedMap* m) {
	if (isnil(m->root)) {
		return;
	}
	mapnode_free(m->root);
}

void SortedMap_print(SortedMap m) {
	println(_SLIT("TODO"));
}

// Attr: [unsafe]
int vstrlen(byteptr s) {
	return strlen(((charptr)(s)));
}

// Attr: [unsafe]
string tos(byteptr s, int len) {
	if (s == 0) {
		panic_debug(80, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("tos"),  _SLIT("tos(): nil string"));
	}
	return (string){.str = s, .len = len};
}

string tos_clone(byteptr s) {
	return string_clone(tos2(s));
}

string tos2(byteptr s) {
	if (s == 0) {
		panic_debug(97, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("tos2"),  _SLIT("tos2: nil string"));
	}
	return (string){.str = s, .len = vstrlen(s)};
}

string tos3(charptr s) {
	if (s == 0) {
		panic_debug(108, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("tos3"),  _SLIT("tos3: nil string"));
	}
	return (string){.str = ((byteptr)(s)), .len = strlen(s)};
}

string tos4(byteptr s) {
	if (s == 0) {
		return _SLIT("");
	}
	return tos2(s);
}

string tos5(charptr s) {
	if (s == 0) {
		return _SLIT("");
	}
	return tos3(s);
}

// Attr: [deprecated]
string tos_lit(charptr s) {
	eprintln(_SLIT("warning: `tos_lit` has been deprecated, use `_SLIT` instead"));
	return (string){.str = ((byteptr)(s)), .len = strlen(s), .is_lit = 1};
}

// Attr: [unsafe]
string byteptr_vstring(byteptr bp) {
	return (string){.str = bp, .len = strlen(((charptr)(bp)))};
}

// Attr: [unsafe]
string byteptr_vstring_with_len(byteptr bp, int len) {
	return (string){.str = bp, .len = len};
}

// Attr: [unsafe]
string charptr_vstring(charptr cp) {
	return (string){.str = ((byteptr)(cp)), .len = strlen(cp)};
}

// Attr: [unsafe]
string charptr_vstring_with_len(charptr cp, int len) {
	return (string){.str = ((byteptr)(cp)), .len = len};
}

string string_clone_static(string a) {
	return string_clone(a);
}

string string_clone(string a) {
	if ((a).len == 0) {
		return _SLIT("");
	}
	string b = (string){.str = v_malloc(a.len + 1), .len = a.len};
	{ // Unsafe block
		memcpy(b.str, a.str, a.len);
		b.str[a.len] = '\0';
	}
	return b;
}

// Attr: [unsafe]
string cstring_to_vstring(byteptr cstr) {
	return tos_clone(cstr);
}

string string_replace_once(string s, string rep, string with) {
	Option_int _t34 = string_index(s, rep);
	if (!_t34.ok) {
		string err = _t34.v_error;
		int errcode = _t34.ecode;
		return string_clone(s);
	}
 	int index = *(int*) _t34.data;
	return string_add(string_add(string_substr(s, 0, index), with), string_substr(s, index + rep.len, s.len));
}

string string_replace(string s, string rep, string with) {
	if (s.len == 0 || rep.len == 0) {
		return string_clone(s);
	}
	array_int idxs = __new_array_with_default(0, 0, sizeof(int), 0);
	int idx = 0;
	for (;;) {
		idx = string_index_after(s, rep, idx);
		if (idx == -1) {
			break;
		}
		array_push(&idxs, _MOV((int[]){ idx }));
		idx += rep.len;
	}
	if (idxs.len == 0) {
		// Defer begin
		array_free(&idxs);
		// Defer end
		return string_clone(s);
	}
	int new_len = s.len + idxs.len * (with.len - rep.len);
	byteptr b = v_malloc(new_len + 1);
	int idx_pos = 0;
	int cur_idx = (*(int*)/*ee elem_typ */array_get(idxs, idx_pos));
	int b_i = 0;
	for (int i = 0; i < s.len; i++) {
		if (i == cur_idx) {
			for (int j = 0; j < with.len; ++j) {
				{ // Unsafe block
					b[b_i] = string_at(with, j);
				}
				b_i++;
			}
			i += rep.len - 1;
			idx_pos++;
			if (idx_pos < idxs.len) {
				cur_idx = (*(int*)/*ee elem_typ */array_get(idxs, idx_pos));
			}
		} else {
			{ // Unsafe block
				b[b_i] = string_at(s, i);
			}
			b_i++;
		}
	}
	{ // Unsafe block
		b[new_len] = '\0';
		// Defer begin
		array_free(&idxs);
		// Defer end
		return tos(b, new_len);
	}
	return (string){.str=(byteptr)""};
}

int compare_rep_index(RepIndex* a, RepIndex* b) {
	if (a->idx < b->idx) {
		return -1;
	}
	if (a->idx > b->idx) {
		return 1;
	}
	return 0;
}

void array_RepIndex_sort2(array_RepIndex* a) {
	array_sort_with_compare(a, compare_rep_index);
}

string string_replace_each(string s, array_string vals) {
	if (s.len == 0 || vals.len == 0) {
		return s;
	}
	if (vals.len % 2 != 0) {
		println(_SLIT("string.replace_each(): odd number of strings"));
		return s;
	}
	int new_len = s.len;
	array_RepIndex idxs = __new_array_with_default(0, 0, sizeof(RepIndex), 0);
	int idx = 0;
	for (int rep_i = 0; rep_i < vals.len; rep_i += 2) {
		string rep = (*(string*)/*ee elem_typ */array_get(vals, rep_i));
		string with = (*(string*)/*ee elem_typ */array_get(vals, rep_i + 1));
		for (;;) {
			idx = string_index_after(s, rep, idx);
			if (idx == -1) {
				break;
			}
			array_push(&idxs, _MOV((RepIndex[]){ (RepIndex){.idx = idx,.val_idx = rep_i,} }));
			idx += rep.len;
			new_len += with.len - rep.len;
		}
	}
	if (idxs.len == 0) {
		return s;
	}
	array_RepIndex_sort2(&idxs);
	byteptr b = v_malloc(new_len + 1);
	int idx_pos = 0;
	RepIndex cur_idx = (*(RepIndex*)/*ee elem_typ */array_get(idxs, idx_pos));
	int b_i = 0;
	for (int i = 0; i < s.len; i++) {
		if (i == cur_idx.idx) {
			string rep = (*(string*)/*ee elem_typ */array_get(vals, cur_idx.val_idx));
			string with = (*(string*)/*ee elem_typ */array_get(vals, cur_idx.val_idx + 1));
			for (int j = 0; j < with.len; ++j) {
				{ // Unsafe block
					b[b_i] = string_at(with, j);
				}
				b_i++;
			}
			i += rep.len - 1;
			idx_pos++;
			if (idx_pos < idxs.len) {
				cur_idx = (*(RepIndex*)/*ee elem_typ */array_get(idxs, idx_pos));
			}
		} else {
			{ // Unsafe block
				b[b_i] = s.str[i];
			}
			b_i++;
		}
	}
	{ // Unsafe block
		b[new_len] = '\0';
		return tos(b, new_len);
	}
	return (string){.str=(byteptr)""};
}

bool string_bool(string s) {
	return string_eq(s, _SLIT("true")) || string_eq(s, _SLIT("t"));
}

int string_int(string s) {
	return ((int)(strconv__common_parse_int(s, 0, 32, false, false)));
}

i64 string_i64(string s) {
	return strconv__common_parse_int(s, 0, 64, false, false);
}

i8 string_i8(string s) {
	return ((i8)(strconv__common_parse_int(s, 0, 8, false, false)));
}

i16 string_i16(string s) {
	return ((i16)(strconv__common_parse_int(s, 0, 16, false, false)));
}

f32 string_f32(string s) {
	return ((f32)(strconv__atof64(s)));
}

f64 string_f64(string s) {
	return strconv__atof64(s);
}

u16 string_u16(string s) {
	return ((u16)(strconv__common_parse_uint(s, 0, 16, false, false)));
}

u32 string_u32(string s) {
	return ((u32)(strconv__common_parse_uint(s, 0, 32, false, false)));
}

u64 string_u64(string s) {
	return strconv__common_parse_uint(s, 0, 64, false, false);
}

bool string_eq(string s, string a) {
	if (s.str == 0) {
		panic_debug(441, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("eq"),  _SLIT("string.eq(): nil string"));
	}
	if (s.len != a.len) {
		return false;
	}
	{ // Unsafe block
		return memcmp(s.str, a.str, a.len) == 0;
	}
	return 0;
}

bool string_ne(string s, string a) {
	return !string_eq(s, a);
}

bool string_lt(string s, string a) {
	for (int i = 0; i < s.len; ++i) {
		if (i >= a.len || string_at(s, i) > string_at(a, i)) {
			return false;
		} else if (string_at(s, i) < string_at(a, i)) {
			return true;
		}
	}
	if (s.len < a.len) {
		return true;
	}
	return false;
}

bool string_le(string s, string a) {
	return string_lt(s, a) || string_eq(s, a);
}

bool string_gt(string s, string a) {
	return !string_le(s, a);
}

bool string_ge(string s, string a) {
	return !string_lt(s, a);
}

string string_add(string s, string a) {
	int new_len = a.len + s.len;
	string res = (string){.str = v_malloc(new_len + 1), .len = new_len};
	for (int j = 0; j < s.len; ++j) {
		{ // Unsafe block
			res.str[j] = s.str[j];
		}
	}
	for (int j = 0; j < a.len; ++j) {
		{ // Unsafe block
			res.str[s.len + j] = a.str[j];
		}
	}
	{ // Unsafe block
		res.str[new_len] = '\0';
	}
	return res;
}

array_string string_split(string s, string delim) {
	return string_split_nth(s, delim, 0);
}

array_string string_split_nth(string s, string delim, int nth) {
	array_string res = __new_array_with_default(0, 0, sizeof(string), 0);
	int i = 0;
	if (delim.len == 0) {
		i = 1;
		for (int _t37 = 0; _t37 < s.len; ++_t37) {
			byte ch = s.str[_t37];
			if (nth > 0 && i >= nth) {
				array_push(&res, _MOV((string[]){ string_right(s, i) }));
				break;
			}
			array_push(&res, _MOV((string[]){ byte_str(ch) }));
			i++;
		}
		return res;
	}
	int start = 0;
	for (;;) {
		if (!(i <= s.len)) break;
		bool is_delim = i + delim.len <= s.len && string_eq(string_substr(s, i, i + delim.len), delim);
		if (is_delim) {
			string val = string_substr(s, start, i);
			bool was_last = nth > 0 && res.len == nth - 1;
			if (was_last) {
				break;
			}
			array_push(&res, _MOV((string[]){ val }));
			start = i + delim.len;
			i = start;
		} else {
			i++;
		}
	}
	if (nth < 1 || res.len < nth) {
		array_push(&res, _MOV((string[]){ string_right(s, start) }));
	}
	return res;
}

array_string string_split_into_lines(string s) {
	array_string res = __new_array_with_default(0, 0, sizeof(string), 0);
	if (s.len == 0) {
		return res;
	}
	int start = 0;
	for (int i = 0; i < s.len; i++) {
		bool is_lf = s.str[i] == '\n';
		bool is_crlf = i != s.len - 1 && s.str[i] == '\r' && s.str[i + 1] == '\n';
		bool is_eol = is_lf || is_crlf;
		bool is_last = (is_crlf ? (i == s.len - 2) : (i == s.len - 1));
		if (is_eol || is_last) {
			if (is_last && !is_eol) {
				i++;
			}
			string line = string_substr(s, start, i);
			array_push(&res, _MOV((string[]){ line }));
			if (is_crlf) {
				i++;
			}
			start = i + 1;
		}
	}
	return res;
}

string string_left(string s, int n) {
	if (n >= s.len) {
		return s;
	}
	return string_substr(s, 0, n);
}

string string_right(string s, int n) {
	if (n >= s.len) {
		return _SLIT("");
	}
	return string_substr(s, n, s.len);
}

string string_substr2(string s, int start, int _end, bool end_max) {
	int end = (end_max ? (s.len) : (_end));
	return string_substr(s, start, end);
}

string string_substr(string s, int start, int end) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (start > end || start > s.len || end > s.len || start < 0 || end < 0) {
			panic_debug(618, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("substr"),  _STR("substr(%"PRId32"\000, %"PRId32"\000) out of bounds (len=%"PRId32"\000)", 4, start, end, s.len));
		}
	}
	#endif
	int len = end - start;
	if (len == s.len) {
		return string_clone(s);
	}
	string res = (string){.str = v_malloc(len + 1), .len = len};
	for (int i = 0; i < len; ++i) {
		{ // Unsafe block
			res.str[i] = s.str[start + i];
		}
	}
	{ // Unsafe block
		res.str[len] = '\0';
	}
	return res;
}

int string_index_old(string s, string p) {
	if (p.len > s.len || p.len == 0) {
		return -1;
	}
	int i = 0;
	for (;;) {
		if (!(i < s.len)) break;
		int j = 0;
		for (;;) {
			if (!(j < p.len && s.str[i + j] == p.str[j])) break;
			j++;
		}
		if (j == p.len) {
			return i;
		}
		i++;
	}
	return -1;
}

Option_int string_index(string s, string p) {
	if (p.len > s.len || p.len == 0) {
		Option _t43 = opt_none();
		return *(Option_int*)&_t43;
	}
	int i = 0;
	for (;;) {
		if (!(i < s.len)) break;
		int j = 0;
		for (;;) {
			if (!(j < p.len && s.str[i + j] == p.str[j])) break;
			j++;
		}
		if (j == p.len) {
			Option_int _t44;
			opt_ok2(&(int[]) { i }, (OptionBase*)(&_t44), sizeof(int));
			return _t44;
		}
		i++;
	}
	Option _t45 = opt_none();
	return *(Option_int*)&_t45;
}

int string_index_kmp(string s, string p) {
	if (p.len > s.len) {
		return -1;
	}
	array_int prefix = __new_array_with_default(p.len, 0, sizeof(int), 0);
	int j = 0;
	for (int i = 1; i < p.len; i++) {
		for (;;) {
			if (!(p.str[j] != p.str[i] && j > 0)) break;
			j = (*(int*)/*ee elem_typ */array_get(prefix, j - 1));
		}
		if (p.str[j] == p.str[i]) {
			j++;
		}
		array_set(&prefix, i, &(int[]) { j });
	}
	j = 0;
	for (int i = 0; i < s.len; ++i) {
		for (;;) {
			if (!(p.str[j] != s.str[i] && j > 0)) break;
			j = (*(int*)/*ee elem_typ */array_get(prefix, j - 1));
		}
		if (p.str[j] == s.str[i]) {
			j++;
		}
		if (j == p.len) {
			return i - p.len + 1;
		}
	}
	return -1;
}

int string_index_any(string s, string chars) {
	for (int _t46 = 0; _t46 < chars.len; ++_t46) {
		byte c = chars.str[_t46];
		Option_int _t47 = string_index(s, byte_str(c));
		if (!_t47.ok) {
			string err = _t47.v_error;
			int errcode = _t47.ecode;
			continue;
		}
 		int index = *(int*) _t47.data;
		return index;
	}
	return -1;
}

Option_int string_last_index(string s, string p) {
	if (p.len > s.len || p.len == 0) {
		Option _t48 = opt_none();
		return *(Option_int*)&_t48;
	}
	int i = s.len - p.len;
	for (;;) {
		if (!(i >= 0)) break;
		int j = 0;
		for (;;) {
			if (!(j < p.len && s.str[i + j] == p.str[j])) break;
			j++;
		}
		if (j == p.len) {
			Option_int _t49;
			opt_ok2(&(int[]) { i }, (OptionBase*)(&_t49), sizeof(int));
			return _t49;
		}
		i--;
	}
	Option _t50 = opt_none();
	return *(Option_int*)&_t50;
}

int string_index_after(string s, string p, int start) {
	if (p.len > s.len) {
		return -1;
	}
	int strt = start;
	if (start < 0) {
		strt = 0;
	}
	if (start >= s.len) {
		return -1;
	}
	int i = strt;
	for (;;) {
		if (!(i < s.len)) break;
		int j = 0;
		int ii = i;
		for (;;) {
			if (!(j < p.len && s.str[ii] == p.str[j])) break;
			j++;
			ii++;
		}
		if (j == p.len) {
			return i;
		}
		i++;
	}
	return -1;
}

int string_index_byte(string s, byte c) {
	for (int i = 0; i < s.len; ++i) {
		if (s.str[i] == c) {
			return i;
		}
	}
	return -1;
}

int string_last_index_byte(string s, byte c) {
	for (int i = s.len - 1; i >= 0; i--) {
		if (s.str[i] == c) {
			return i;
		}
	}
	return -1;
}

int string_count(string s, string substr) {
	if (s.len == 0 || substr.len == 0) {
		return 0;
	}
	if (substr.len > s.len) {
		return 0;
	}
	int n = 0;
	int i = 0;
	for (;;) {
		i = string_index_after(s, substr, i);
		if (i == -1) {
			return n;
		}
		i += substr.len;
		n++;
	}
	return 0;
}

bool string_contains(string s, string substr) {
	if (substr.len == 0) {
		return true;
	}
	Option_int _t51 = string_index(s, substr);
	if (!_t51.ok) {
		string err = _t51.v_error;
		int errcode = _t51.ecode;
		return false;
	};
	return true;
}

bool string_contains_any(string s, string chars) {
	for (int _t52 = 0; _t52 < chars.len; ++_t52) {
		byte c = chars.str[_t52];
		if (string_contains(s, byte_str(c))) {
			return true;
		}
	}
	return false;
}

bool string_contains_any_substr(string s, array_string substrs) {
	if (substrs.len == 0) {
		return true;
	}
	// FOR IN array
	array _t53 = substrs;
	for (int _t54 = 0; _t54 < _t53.len; ++_t54) {
		string sub = ((string*)_t53.data)[_t54];
		if (string_contains(s, sub)) {
			return true;
		}
	}
	return false;
}

bool string_starts_with(string s, string p) {
	if (p.len > s.len) {
		return false;
	}
	for (int i = 0; i < p.len; ++i) {
		if (s.str[i] != p.str[i]) {
			return false;
		}
	}
	return true;
}

bool string_ends_with(string s, string p) {
	if (p.len > s.len) {
		return false;
	}
	for (int i = 0; i < p.len; ++i) {
		if (string_at(p, i) != string_at(s, s.len - p.len + i)) {
			return false;
		}
	}
	return true;
}

string string_to_lower(string s) {
	{ // Unsafe block
		byteptr b = v_malloc(s.len + 1);
		for (int i = 0; i < s.len; ++i) {
			b[i] = ((byte)(tolower(s.str[i])));
		}
		return tos(b, s.len);
	}
	return (string){.str=(byteptr)""};
}

bool string_is_lower(string s) {
	for (int i = 0; i < s.len; ++i) {
		if (string_at(s, i) >= 'A' && string_at(s, i) <= 'Z') {
			return false;
		}
	}
	return true;
}

string string_to_upper(string s) {
	{ // Unsafe block
		byteptr b = v_malloc(s.len + 1);
		for (int i = 0; i < s.len; ++i) {
			b[i] = ((byte)(toupper(s.str[i])));
		}
		return tos(b, s.len);
	}
	return (string){.str=(byteptr)""};
}

bool string_is_upper(string s) {
	for (int i = 0; i < s.len; ++i) {
		if (string_at(s, i) >= 'a' && string_at(s, i) <= 'z') {
			return false;
		}
	}
	return true;
}

string string_capitalize(string s) {
	if (s.len == 0) {
		return _SLIT("");
	}
	return string_add(string_to_upper(byte_str(string_at(s, 0))), string_substr(s, 1, s.len));
}

bool string_is_capital(string s) {
	if (s.len == 0 || !(string_at(s, 0) >= 'A' && string_at(s, 0) <= 'Z')) {
		return false;
	}
	for (int i = 1; i < s.len; ++i) {
		if (string_at(s, i) >= 'A' && string_at(s, i) <= 'Z') {
			return false;
		}
	}
	return true;
}

string string_title(string s) {
	array_string words = string_split(s, _SLIT(" "));
	array_string tit = __new_array_with_default(0, 0, sizeof(string), 0);
	// FOR IN array
	array _t55 = words;
	for (int _t56 = 0; _t56 < _t55.len; ++_t56) {
		string word = ((string*)_t55.data)[_t56];
		array_push(&tit, _MOV((string[]){ string_capitalize(word) }));
	}
	string title = array_string_join(tit, _SLIT(" "));
	return title;
}

bool string_is_title(string s) {
	array_string words = string_split(s, _SLIT(" "));
	// FOR IN array
	array _t58 = words;
	for (int _t59 = 0; _t59 < _t58.len; ++_t59) {
		string word = ((string*)_t58.data)[_t59];
		if (!string_is_capital(word)) {
			return false;
		}
	}
	return true;
}

string string_find_between(string s, string start, string end) {
	Option_int _t60 = string_index(s, start);
	if (!_t60.ok) {
		string err = _t60.v_error;
		int errcode = _t60.ecode;
		return _SLIT("");
	}
 	int start_pos = *(int*) _t60.data;
	string val = string_right(s, start_pos + start.len);
	Option_int _t61 = string_index(val, end);
	if (!_t61.ok) {
		string err = _t61.v_error;
		int errcode = _t61.ecode;
		return val;
	}
 	int end_pos = *(int*) _t61.data;
	return string_left(val, end_pos);
}

bool byte_is_space(byte c) {
	return (c == ' ' || c == '\n' || c == '\t' || c == '\v' || c == '\f' || c == '\r' || c == 0x85 || c == 0xa0);
}

string string_trim_space(string s) {
	return string_trim(s, _SLIT(" \n\t\v\f\r"));
}

string string_trim(string s, string cutset) {
	if (s.len < 1 || cutset.len < 1) {
		return s;
	}
	array_byte cs_arr = string_bytes(cutset);
	int pos_left = 0;
	int pos_right = s.len - 1;
	bool cs_match = true;
	for (;;) {
		if (!(pos_left <= s.len && pos_right >= -1 && cs_match)) break;
		cs_match = false;
		if ((array_byte_contains(cs_arr, string_at(s, pos_left)))) {
			pos_left++;
			cs_match = true;
		}
		if ((array_byte_contains(cs_arr, string_at(s, pos_right)))) {
			pos_right--;
			cs_match = true;
		}
		if (pos_left > pos_right) {
			return _SLIT("");
		}
	}
	return string_substr(s, pos_left, pos_right + 1);
}

string string_trim_left(string s, string cutset) {
	if (s.len < 1 || cutset.len < 1) {
		return s;
	}
	array_byte cs_arr = string_bytes(cutset);
	int pos = 0;
	for (;;) {
		if (!(pos < s.len && (array_byte_contains(cs_arr, string_at(s, pos))))) break;
		pos++;
	}
	return string_right(s, pos);
}

string string_trim_right(string s, string cutset) {
	if (s.len < 1 || cutset.len < 1) {
		return s;
	}
	array_byte cs_arr = string_bytes(cutset);
	int pos = s.len - 1;
	for (;;) {
		if (!(pos >= 0 && (array_byte_contains(cs_arr, string_at(s, pos))))) break;
		pos--;
	}
	return (pos < 0 ? (_SLIT("")) : (string_left(s, pos + 1)));
}

string string_trim_prefix(string s, string str) {
	if (string_starts_with(s, str)) {
		return string_substr(s, str.len, s.len);
	}
	return s;
}

string string_trim_suffix(string s, string str) {
	if (string_ends_with(s, str)) {
		return string_substr(s, 0, s.len - str.len);
	}
	return s;
}

int compare_strings(string* a, string* b) {
	if (string_lt(/*rec*/*a, *b)) {
		return -1;
	}
	if (string_gt(/*rec*/*a, *b)) {
		return 1;
	}
	return 0;
}

int compare_strings_reverse(string* a, string* b) {
	if (string_lt(/*rec*/*a, *b)) {
		return 1;
	}
	if (string_gt(/*rec*/*a, *b)) {
		return -1;
	}
	return 0;
}

int compare_strings_by_len(string* a, string* b) {
	if (a->len < b->len) {
		return -1;
	}
	if (a->len > b->len) {
		return 1;
	}
	return 0;
}

int compare_lower_strings(string* a, string* b) {
	string aa = string_to_lower(/*rec*/*a);
	string bb = string_to_lower(/*rec*/*b);
	return compare_strings((voidptr)&/*qq*/aa, (voidptr)&/*qq*/bb);
}

void array_string_sort(array_string* s) {
	array_sort_with_compare(s, compare_strings);
}

void array_string_sort_ignore_case(array_string* s) {
	array_sort_with_compare(s, compare_lower_strings);
}

void array_string_sort_by_len(array_string* s) {
	array_sort_with_compare(s, compare_strings_by_len);
}

string string_str(string s) {
	return s;
}

string ustring_str(ustring s) {
	return s.s;
}

ustring string_ustring(string s) {
	ustring res = (ustring){.s = s,.runes = __new_array(0, s.len, ((int)(/*SizeOfType*/ sizeof(int)))),.len = 0,};
	for (int i = 0; i < s.len; i++) {
		int char_len = utf8_char_len(s.str[i]);
		array_push(&res.runes, _MOV((int[]){ i }));
		i += char_len - 1;
		res.len++;
	}
	return res;
}

ustring string_ustring_tmp(string s) {
	if (g_ustring_runes.len == 0) {
		g_ustring_runes = __new_array(0, 128, ((int)(/*SizeOfType*/ sizeof(int))));
	}
	ustring res = (ustring){.s = s,.runes = __new_array(0, 1, sizeof(int)),.len = 0,};
	res.runes = g_ustring_runes;
	res.runes.len = s.len;
	int j = 0;
	for (int i = 0; i < s.len; i++) {
		int char_len = utf8_char_len(s.str[i]);
		(*(int*)/*ee elem_typ */array_get(res.runes, j)) = i;
		j++;
		i += char_len - 1;
		res.len++;
	}
	return res;
}

bool ustring_eq(ustring u, ustring a) {
	if (u.len != a.len || string_ne(u.s, a.s)) {
		return false;
	}
	return true;
}

bool ustring_ne(ustring u, ustring a) {
	return !ustring_eq(u, a);
}

bool ustring_lt(ustring u, ustring a) {
	return string_lt(u.s, a.s);
}

bool ustring_le(ustring u, ustring a) {
	return ustring_lt(u, a) || ustring_eq(u, a);
}

bool ustring_gt(ustring u, ustring a) {
	return !ustring_le(u, a);
}

bool ustring_ge(ustring u, ustring a) {
	return !ustring_lt(u, a);
}

ustring ustring_add(ustring u, ustring a) {
	ustring res = (ustring){.s = string_add(u.s, a.s),.runes = __new_array(0, u.s.len + a.s.len, ((int)(/*SizeOfType*/ sizeof(int)))),.len = 0,};
	int j = 0;
	for (int i = 0; i < u.s.len; i++) {
		int char_len = utf8_char_len(u.s.str[i]);
		array_push(&res.runes, _MOV((int[]){ j }));
		i += char_len - 1;
		j += char_len;
		res.len++;
	}
	for (int i = 0; i < a.s.len; i++) {
		int char_len = utf8_char_len(a.s.str[i]);
		array_push(&res.runes, _MOV((int[]){ j }));
		i += char_len - 1;
		j += char_len;
		res.len++;
	}
	return res;
}

int ustring_index_after(ustring u, ustring p, int start) {
	if (p.len > u.len) {
		return -1;
	}
	int strt = start;
	if (start < 0) {
		strt = 0;
	}
	if (start > u.len) {
		return -1;
	}
	int i = strt;
	for (;;) {
		if (!(i < u.len)) break;
		int j = 0;
		int ii = i;
		for (;;) {
			if (!(j < p.len && string_eq(ustring_at(u, ii), ustring_at(p, j)))) break;
			j++;
			ii++;
		}
		if (j == p.len) {
			return i;
		}
		i++;
	}
	return -1;
}

int ustring_count(ustring u, ustring substr) {
	if (u.len == 0 || substr.len == 0) {
		return 0;
	}
	if (substr.len > u.len) {
		return 0;
	}
	int n = 0;
	int i = 0;
	for (;;) {
		i = ustring_index_after(u, substr, i);
		if (i == -1) {
			return n;
		}
		i += substr.len;
		n++;
	}
	return 0;
}

string ustring_substr(ustring u, int _start, int _end) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (_start > _end || _start > u.len || _end > u.len || _start < 0 || _end < 0) {
			panic_debug(1300, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("substr"),  _STR("substr(%"PRId32"\000, %"PRId32"\000) out of bounds (len=%"PRId32"\000)", 4, _start, _end, u.len));
		}
	}
	#endif
	int end = (_end >= u.len ? (u.s.len) : ((*(int*)/*ee elem_typ */array_get(u.runes, _end))));
	return string_substr(u.s, (*(int*)/*ee elem_typ */array_get(u.runes, _start)), end);
}

string ustring_left(ustring u, int pos) {
	if (pos >= u.len) {
		return u.s;
	}
	return ustring_substr(u, 0, pos);
}

string ustring_right(ustring u, int pos) {
	if (pos >= u.len) {
		return _SLIT("");
	}
	return ustring_substr(u, pos, u.len);
}

byte string_at(string s, int idx) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (idx < 0 || idx >= s.len) {
			panic_debug(1330, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("at"),  _STR("string index out of range: %"PRId32"\000 / %"PRId32"", 2, idx, s.len));
		}
	}
	#endif
	{ // Unsafe block
		return s.str[idx];
	}
	return 0;
}

string ustring_at(ustring u, int idx) {
	#if !defined(CUSTOM_DEFINE_no_bounds_checking)
	{
		if (idx < 0 || idx >= u.len) {
			panic_debug(1343, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("at"),  _STR("string index out of range: %"PRId32"\000 / %"PRId32"", 2, idx, u.runes.len));
		}
	}
	#endif
	return ustring_substr(u, idx, idx + 1);
}

// Attr: [unsafe]
void ustring_free(ustring* u) {
	#if defined(_VPREALLOC)
	{
	}
	#endif
	{ // Unsafe block
		array_free(&u->runes);
		string_free(&u->s);
	}
}

bool byte_is_digit(byte c) {
	return c >= '0' && c <= '9';
}

bool byte_is_hex_digit(byte c) {
	return byte_is_digit(c) || (c >= 'a' && c <= 'f') || (c >= 'A' && c <= 'F');
}

bool byte_is_oct_digit(byte c) {
	return c >= '0' && c <= '7';
}

bool byte_is_bin_digit(byte c) {
	return c == '0' || c == '1';
}

bool byte_is_letter(byte c) {
	return (c >= 'a' && c <= 'z') || (c >= 'A' && c <= 'Z');
}

void string_free(string* s) {
	#if defined(_VPREALLOC)
	{
	}
	#endif
	if (s->is_lit == -98761234) {
		printf("double string.free() detected\n");
		return;
	}
	if (s->is_lit == 1 || s->len == 0) {
		return;
	}
	v_free(s->str);
	s->is_lit = -98761234;
}

string string_all_before(string s, string dot) {
	Option_int _t65 = string_index(s, dot);
	if (!_t65.ok) {
		string err = _t65.v_error;
		int errcode = _t65.ecode;
		return s;
	}
 	int pos = *(int*) _t65.data;
	return string_left(s, pos);
}

string string_all_before_last(string s, string dot) {
	Option_int _t66 = string_last_index(s, dot);
	if (!_t66.ok) {
		string err = _t66.v_error;
		int errcode = _t66.ecode;
		return s;
	}
 	int pos = *(int*) _t66.data;
	return string_left(s, pos);
}

string string_all_after(string s, string dot) {
	Option_int _t67 = string_index(s, dot);
	if (!_t67.ok) {
		string err = _t67.v_error;
		int errcode = _t67.ecode;
		return s;
	}
 	int pos = *(int*) _t67.data;
	return string_right(s, pos + dot.len);
}

string string_all_after_last(string s, string dot) {
	Option_int _t68 = string_last_index(s, dot);
	if (!_t68.ok) {
		string err = _t68.v_error;
		int errcode = _t68.ecode;
		return s;
	}
 	int pos = *(int*) _t68.data;
	return string_right(s, pos + dot.len);
}

string string_after(string s, string dot) {
	return string_all_after_last(s, dot);
}

string string_after_char(string s, byte dot) {
	int pos = 0;
	for (int i = 0; i < s.len; ++i) {
		byte c = s.str[i];
		if (c == dot) {
			pos = i;
			break;
		}
	}
	if (pos == 0) {
		return s;
	}
	return string_right(s, pos + 1);
}

string array_string_join(array_string a, string del) {
	if (a.len == 0) {
		return _SLIT("");
	}
	int len = 0;
	// FOR IN array
	array _t69 = a;
	for (int _t70 = 0; _t70 < _t69.len; ++_t70) {
		string val = ((string*)_t69.data)[_t70];
		len += val.len + del.len;
	}
	len -= del.len;
	string res = _SLIT("");
	res.len = len;
	res.str = v_malloc(res.len + 1);
	int idx = 0;
	// FOR IN array
	array _t71 = a;
	for (int i = 0; i < _t71.len; ++i) {
		string val = ((string*)_t71.data)[i];
		for (int j = 0; j < val.len; ++j) {
			{ // Unsafe block
				res.str[idx] = val.str[j];
			}
			idx++;
		}
		if (i != a.len - 1) {
			for (int k = 0; k < del.len; ++k) {
				{ // Unsafe block
					res.str[idx] = del.str[k];
				}
				idx++;
			}
		}
	}
	{ // Unsafe block
		res.str[res.len] = '\0';
	}
	return res;
}

string array_string_join_lines(array_string s) {
	return array_string_join(s, _SLIT("\n"));
}

string string_reverse(string s) {
	if (s.len == 0 || s.len == 1) {
		return s;
	}
	string res = (string){.str = v_malloc(s.len), .len = s.len};
	for (int i = s.len - 1; i >= 0; i--) {
		{ // Unsafe block
			res.str[s.len - i - 1] = string_at(s, i);
		}
	}
	return res;
}

string string_limit(string s, int max) {
	ustring u = string_ustring(s);
	if (u.len <= max) {
		return s;
	}
	return ustring_substr(u, 0, max);
}

// Attr: [deprecated]
bool byte_is_white(byte c) {
	eprintln(_SLIT("warning: `string.is_white` has been deprecated, use `string.is_space` instead"));
	return byte_is_space(c);
}

int string_hash(string s) {
	u32 h = ((u32)(0U));
	if (h == 0 && s.len > 0) {
		for (int _t72 = 0; _t72 < s.len; ++_t72) {
			byte c = s.str[_t72];
			h = h * 31 + ((u32)(c));
		}
	}
	return ((int)(h));
}

array_byte string_bytes(string s) {
	if (s.len == 0) {
		return __new_array_with_default(0, 0, sizeof(byte), 0);
	}
	array_byte buf = __new_array_with_default(s.len, 0, sizeof(byte), 0);
	memcpy(buf.data, s.str, s.len);
	return buf;
}

string string_repeat(string s, int count) {
	if (count < 0) {
		panic_debug(1565, tos3("/DATA/projects/web/v/v/vlib/builtin/string.v"), tos3("builtin"), tos3("repeat"),  _STR("string.repeat: count is negative: %"PRId32"", 1, count));
	} else if (count == 0) {
		return _SLIT("");
	} else if (count == 1) {
		return s;
	}
	int slen = s.len;
	int blen = slen * count;
	byteptr bytes = v_malloc(blen + 1);
	for (int bi = 0; bi < count; ++bi) {
		int bislen = bi * slen;
		for (int si = 0; si < slen; ++si) {
			{ // Unsafe block
				bytes[bislen + si] = string_at(s, si);
			}
		}
	}
	{ // Unsafe block
		bytes[blen] = '0';
		return byteptr_vstring_with_len(bytes, blen);
	}
	return (string){.str=(byteptr)""};
}

array_string string_fields(string s) {
	return string_split(string_replace(s, _SLIT("\t"), _SLIT(" ")), _SLIT(" "));
}

string string_strip_margin(string s) {
	return string_strip_margin_custom(s, '|');
}

string string_strip_margin_custom(string s, byte del) {
	byte sep = del;
	if (byte_is_space(sep)) {
		eprintln(_SLIT("Warning: `strip_margin` cannot use white-space as a delimiter"));
		eprintln(_SLIT("    Defaulting to `|`"));
		sep = '|';
	}
	byteptr ret = v_malloc(s.len + 1);
	int count = 0;
	for (int i = 0; i < s.len; i++) {
		if ((string_at(s, i) == '\n' || string_at(s, i) == '\r')) {
			{ // Unsafe block
				ret[count] = string_at(s, i);
			}
			count++;
			if (string_at(s, i) == '\r' && i < s.len - 1 && string_at(s, i + 1) == '\n') {
				{ // Unsafe block
					ret[count] = string_at(s, i + 1);
				}
				count++;
				i++;
			}
			for (;;) {
				if (!(string_at(s, i) != sep)) break;
				i++;
				if (i >= s.len) {
					break;
				}
			}
		} else {
			{ // Unsafe block
				ret[count] = string_at(s, i);
			}
			count++;
		}
	}
	{ // Unsafe block
		ret[count] = 0;
		return byteptr_vstring_with_len(ret, count);
	}
	return (string){.str=(byteptr)""};
}

array_string string_split_by_whitespace(string s) {
	array_string res = __new_array_with_default(0, 0, sizeof(string), 0);
	int word_start = 0;
	int word_end = 0;
	bool is_in_word = false;
	bool is_space = false;
	for (int i = 0; i < s.len; ++i) {
		byte c = s.str[i];
		is_space = (c == ' ' || c == '\t' || c == '\n');
		if (!is_in_word && !is_space) {
			word_start = i;
			is_in_word = true;
			continue;
		}
		if (is_space && is_in_word) {
			word_end = i;
			array_push(&res, _MOV((string[]){ string_substr(s, word_start, word_end) }));
			is_in_word = false;
			word_end = 0;
			word_start = 0;
			continue;
		}
	}
	if (is_in_word && word_start > 0) {
		array_push(&res, _MOV((string[]){ string_substr(s, word_start, s.len) }));
	}
	return res;
}

u16* string_to_wide(string _str) {
	#if defined(_WIN32)
	{
	}
	#else
	{
		return 0;
	}
	#endif
	return 0;
}

string string_from_wide(u16* _wstr) {
	#if defined(_WIN32)
	{
	}
	#else
	{
		return _SLIT("");
	}
	#endif
	return (string){.str=(byteptr)""};
}

string string_from_wide2(u16* _wstr, int len) {
	#if defined(_WIN32)
	{
	}
	#else
	{
		return _SLIT("");
	}
	#endif
	return (string){.str=(byteptr)""};
}

int utf8_getchar() {
	int c = getchar();
	int len = utf8_len(((byte)(~c)));
	if (c < 0) {
		return 0;
	} else if (len == 0) {
		return c;
	} else if (len == 1) {
		return -1;
	} else {
		int uc = (c & ((1 << (7 - len)) - 1));
		for (int i = 0; i + 1 < len; i++) {
			int c2 = getchar();
			if (c2 != -1 && (c2 >> 6) == 2) {
				uc <<= 6;
				uc |= ((c2 & 63));
			} else if (c2 == -1) {
				return 0;
			} else {
				return -1;
			}
		}
		return uc;
	}
	return 0;
}

int utf8_char_len(byte b) {
	return (((0xe5000000 >> (((b >> 3) & 0x1e))) & 3)) + 1;
}

string utf32_to_str(u32 code) {
	byteptr buffer = v_malloc(5);
	return utf32_to_str_no_malloc(code, buffer);
}

string utf32_to_str_no_malloc(u32 code, voidptr buf) {
	int icode = ((int)(code));
	string res = _SLIT("");
	{ // Unsafe block
		byteptr buffer = ((byteptr)(buf));
		if (icode <= 127) {
			buffer[0] = ((byte)(icode));
			res = tos(buffer, 1);
		} else if (icode <= 2047) {
			buffer[0] = (192 | ((byte)(icode >> 6)));
			buffer[1] = (128 | ((byte)((icode & 63))));
			res = tos(buffer, 2);
		} else if (icode <= 65535) {
			buffer[0] = (224 | ((byte)(icode >> 12)));
			buffer[1] = (128 | ((((byte)(icode >> 6)) & 63)));
			buffer[2] = (128 | ((byte)((icode & 63))));
			res = tos(buffer, 3);
		} else if (icode <= 1114111) {
			buffer[0] = (240 | ((byte)(icode >> 18)));
			buffer[1] = (128 | ((((byte)(icode >> 12)) & 63)));
			buffer[2] = (128 | ((((byte)(icode >> 6)) & 63)));
			buffer[3] = (128 | ((byte)((icode & 63))));
			res = tos(buffer, 4);
		}
	}
	res.is_lit = 1;
	return res;
}

int string_utf32_code(string _rune) {
	if (_rune.len == 0) {
		return 0;
	}
	if (_rune.len == 1) {
		return ((int)(string_at(_rune, 0)));
	}
	byte b = ((byte)(((int)(string_at(_rune, 0)))));
	b = b << _rune.len;
	int res = ((int)(b));
	int shift = 6 - _rune.len;
	for (int i = 1; i < _rune.len; i++) {
		int c = ((int)(string_at(_rune, i)));
		res = res << shift;
		res |= (c & 63);
		shift = 6;
	}
	return res;
}

int utf8_len(byte c) {
	int b = 0;
	byte x = c;
	if (((x & 240)) != 0) {
		x >>= 4;
	} else {
		b += 4;
	}
	if (((x & 12)) != 0) {
		x >>= 2;
	} else {
		b += 2;
	}
	if (((x & 2)) == 0) {
		b++;
	}
	return b;
}

int utf8_str_len(string s) {
	int l = 0;
	for (int i = 0; i < s.len; i++) {
		l++;
		byte c = s.str[i];
		if (((c & (1 << 7))) != 0) {
			for (byte t = ((byte)(1 << 6)); ((c & t)) != 0; t >>= 1) {
				i++;
			}
		}
	}
	return l;
}

int utf8_str_visible_length(string s) {
	int l = 0;
	int ul = 1;
	for (int i = 0; i < s.len; i += ul) {
		ul = 1;
		byte c = s.str[i];
		if (((c & (1 << 7))) != 0) {
			for (byte t = ((byte)(1 << 6)); ((c & t)) != 0; t >>= 1) {
				ul++;
			}
		}
		if (i + ul > s.len) {
			return l;
		}
		l++;
		if (c == 0xcc || c == 0xcd) {
			u16 r = ((((u16)(c)) << 8) | s.str[i + 1]);
			if (r >= 0xcc80 && r < 0xcdb0) {
				l--;
			}
		} else if (c == 0xe1 || c == 0xe2 || c == 0xef) {
			u32 r = ((((u32)(c)) << 16) | ((((u32)(s.str[i + 1])) << 8) | s.str[i + 2]));
			if ((r >= 0xe1aab0 && r < 0xe1ac80) || (r >= 0xe1b780 && r < 0xe1b880) || (r >= 0xe28390 && r < 0xe28480) || (r >= 0xefb8a0 && r < 0xefb8b0)) {
				l--;
			}
		}
	}
	return l;
}

string gencmd__gencmd(string cmd) {
	charptr result = send_command(cmd.str);
	if (!isnil(result)) {
		return cstring_to_vstring(result);
	}
	return _SLIT("Returned result is : empty");
}

__attribute__ ((constructor))
void _vinit() {
static bool once = false; if (once) {return;} once = true;
	builtin_init();
	vinit_string_literals();
	// Initializations for module strings :
	// Initializations for module hash :
	_const_hash__wyp0 = ((u64)(0xa0761d6478bd642fU));
	_const_hash__wyp1 = ((u64)(0xe7037ed1a0b428dbU));
	_const_hash__wyp2 = ((u64)(0x8ebc6af09c88c6e3U));
	_const_hash__wyp3 = ((u64)(0x589965cc75374cc3U));
	_const_hash__wyp4 = ((u64)(0x1d8e4e27c47d124fU));
	// Initializations for module math.bits :
	_const_math__bits__de_bruijn32 = ((u32)(0x077CB531U));
	_const_math__bits__de_bruijn32tab = new_array_from_c_array(32, 32, sizeof(byte), _MOV((byte[32]){
		((byte)(0)), 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8, 31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9}));
	_const_math__bits__de_bruijn64 = ((u64)(0x03f79d71b4ca8b09U));
	_const_math__bits__de_bruijn64tab = new_array_from_c_array(64, 64, sizeof(byte), _MOV((byte[64]){
		((byte)(0)), 1, 56, 2, 57, 49, 28, 3, 61, 58, 42, 50, 38, 29, 17, 4, 62, 47, 59, 36, 45, 43, 51, 22, 53, 39, 33, 30, 24, 18, 12, 5, 63, 55, 48, 27, 60, 41, 37, 16, 46, 35, 44, 21, 52, 32, 23, 11, 54, 26, 40, 15, 34, 20, 31, 10, 25, 14, 19, 9, 13, 8, 7, 6}));
	_const_math__bits__m0 = ((u64)(0x5555555555555555U));
	_const_math__bits__m1 = ((u64)(0x3333333333333333U));
	_const_math__bits__m2 = ((u64)(0x0f0f0f0f0f0f0f0fU));
	_const_math__bits__m3 = ((u64)(0x00ff00ff00ff00ffU));
	_const_math__bits__m4 = ((u64)(0x0000ffff0000ffffU));
	_const_math__bits__max_u32 = ((u32)(4294967295U));
	_const_math__bits__max_u64 = ((u64)(18446744073709551615U));
	_const_math__bits__two32 = ((u64)(0x100000000U));
	_const_math__bits__mask32 = _const_math__bits__two32 - 1;
	_const_math__bits__ntz_8_tab = new_array_from_c_array(256, 256, sizeof(byte), _MOV((byte[256]){
		((byte)(0x08)), 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x06, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x07, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x06, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x05, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x04, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00, 0x02, 0x00, 0x01, 0x00}));
	_const_math__bits__pop_8_tab = new_array_from_c_array(256, 256, sizeof(byte), _MOV((byte[256]){
		((byte)(0x00)), 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x04, 0x05, 0x05, 0x06, 0x05, 0x06, 0x06, 0x07, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x04, 0x05, 0x05, 0x06, 0x05, 0x06, 0x06, 0x07, 0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x04, 0x05, 0x05, 0x06, 0x05, 0x06, 0x06, 0x07, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x05, 0x06, 0x04, 0x05, 0x05, 0x06, 0x05, 0x06, 0x06, 0x07, 0x04, 0x05, 0x05, 0x06, 0x05, 0x06, 0x06, 0x07, 0x05, 0x06, 0x06, 0x07, 0x06, 0x07, 0x07, 0x08}));
	_const_math__bits__rev_8_tab = new_array_from_c_array(256, 256, sizeof(byte), _MOV((byte[256]){
		((byte)(0x00)), 0x80, 0x40, 0xc0, 0x20, 0xa0, 0x60, 0xe0, 0x10, 0x90, 0x50, 0xd0, 0x30, 0xb0, 0x70, 0xf0, 0x08, 0x88, 0x48, 0xc8, 0x28, 0xa8, 0x68, 0xe8, 0x18, 0x98, 0x58, 0xd8, 0x38, 0xb8, 0x78, 0xf8, 0x04, 0x84, 0x44, 0xc4, 0x24, 0xa4, 0x64, 0xe4, 0x14, 0x94, 0x54, 0xd4, 0x34, 0xb4, 0x74, 0xf4, 0x0c, 0x8c, 0x4c, 0xcc, 0x2c, 0xac, 0x6c, 0xec, 0x1c, 0x9c, 0x5c, 0xdc, 0x3c, 0xbc, 0x7c, 0xfc, 0x02, 0x82, 0x42, 0xc2, 0x22, 0xa2, 0x62, 0xe2, 0x12, 0x92, 0x52, 0xd2, 0x32, 0xb2, 0x72, 0xf2, 0x0a, 0x8a, 0x4a, 0xca, 0x2a, 0xaa, 0x6a, 0xea, 0x1a, 0x9a, 0x5a, 0xda, 0x3a, 0xba, 0x7a, 0xfa, 0x06, 0x86, 0x46, 0xc6, 0x26, 0xa6, 0x66, 0xe6, 0x16, 0x96, 0x56, 0xd6, 0x36, 0xb6, 0x76, 0xf6, 0x0e, 0x8e, 0x4e, 0xce, 0x2e, 0xae, 0x6e, 0xee, 0x1e, 0x9e, 0x5e, 0xde, 0x3e, 0xbe, 0x7e, 0xfe, 0x01, 0x81, 0x41, 0xc1, 0x21, 0xa1, 0x61, 0xe1, 0x11, 0x91, 0x51, 0xd1, 0x31, 0xb1, 0x71, 0xf1, 0x09, 0x89, 0x49, 0xc9, 0x29, 0xa9, 0x69, 0xe9, 0x19, 0x99, 0x59, 0xd9, 0x39, 0xb9, 0x79, 0xf9, 0x05, 0x85, 0x45, 0xc5, 0x25, 0xa5, 0x65, 0xe5, 0x15, 0x95, 0x55, 0xd5, 0x35, 0xb5, 0x75, 0xf5, 0x0d, 0x8d, 0x4d, 0xcd, 0x2d, 0xad, 0x6d, 0xed, 0x1d, 0x9d, 0x5d, 0xdd, 0x3d, 0xbd, 0x7d, 0xfd, 0x03, 0x83, 0x43, 0xc3, 0x23, 0xa3, 0x63, 0xe3, 0x13, 0x93, 0x53, 0xd3, 0x33, 0xb3, 0x73, 0xf3, 0x0b, 0x8b, 0x4b, 0xcb, 0x2b, 0xab, 0x6b, 0xeb, 0x1b, 0x9b, 0x5b, 0xdb, 0x3b, 0xbb, 0x7b, 0xfb, 0x07, 0x87, 0x47, 0xc7, 0x27, 0xa7, 0x67, 0xe7, 0x17, 0x97, 0x57, 0xd7, 0x37, 0xb7, 0x77, 0xf7, 0x0f, 0x8f, 0x4f, 0xcf, 0x2f, 0xaf, 0x6f, 0xef, 0x1f, 0x9f, 0x5f, 0xdf, 0x3f, 0xbf, 0x7f, 0xff}));
	_const_math__bits__len_8_tab = new_array_from_c_array(256, 256, sizeof(byte), _MOV((byte[256]){
		((byte)(0x00)), 0x01, 0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x07, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08}));
	// Initializations for module strconv :
	_const_strconv__double_plus_zero = ((u64)(0x0000000000000000U));
	_const_strconv__double_minus_zero = ((u64)(0x8000000000000000U));
	_const_strconv__double_plus_infinity = ((u64)(0x7FF0000000000000U));
	_const_strconv__double_minus_infinity = ((u64)(0xFFF0000000000000U));
	_const_strconv__c_ten = ((u32)(10U));
	_const_strconv__pos_exp = new_array_from_c_array(309, 309, sizeof(u64), _MOV((u64[309]){
		((u64)(0x3ff0000000000000U)), ((u64)(0x4024000000000000U)), ((u64)(0x4059000000000000U)), ((u64)(0x408f400000000000U)), ((u64)(0x40c3880000000000U)), ((u64)(0x40f86a0000000000U)), ((u64)(0x412e848000000000U)), ((u64)(0x416312d000000000U)), ((u64)(0x4197d78400000000U)), ((u64)(0x41cdcd6500000000U)), ((u64)(0x4202a05f20000000U)), ((u64)(0x42374876e8000000U)), ((u64)(0x426d1a94a2000000U)), ((u64)(0x42a2309ce5400000U)), ((u64)(0x42d6bcc41e900000U)), ((u64)(0x430c6bf526340000U)), ((u64)(0x4341c37937e08000U)), ((u64)(0x4376345785d8a000U)), ((u64)(0x43abc16d674ec800U)), ((u64)(0x43e158e460913d00U)), ((u64)(0x4415af1d78b58c40U)), ((u64)(0x444b1ae4d6e2ef50U)), ((u64)(0x4480f0cf064dd592U)), ((u64)(0x44b52d02c7e14af6U)), ((u64)(0x44ea784379d99db4U)), ((u64)(0x45208b2a2c280291U)), ((u64)(0x4554adf4b7320335U)), ((u64)(0x4589d971e4fe8402U)), ((u64)(0x45c027e72f1f1281U)), ((u64)(0x45f431e0fae6d721U)), ((u64)(0x46293e5939a08ceaU)), ((u64)(0x465f8def8808b024U)), ((u64)(0x4693b8b5b5056e17U)), ((u64)(0x46c8a6e32246c99cU)), ((u64)(0x46fed09bead87c03U)), ((u64)(0x4733426172c74d82U)), ((u64)(0x476812f9cf7920e3U)), ((u64)(0x479e17b84357691bU)), ((u64)(0x47d2ced32a16a1b1U)), ((u64)(0x48078287f49c4a1dU)), ((u64)(0x483d6329f1c35ca5U)), ((u64)(0x48725dfa371a19e7U)), ((u64)(0x48a6f578c4e0a061U)), ((u64)(0x48dcb2d6f618c879U)), ((u64)(0x4911efc659cf7d4cU)), ((u64)(0x49466bb7f0435c9eU)), ((u64)(0x497c06a5ec5433c6U)), ((u64)(0x49b18427b3b4a05cU)), ((u64)(0x49e5e531a0a1c873U)), ((u64)(0x4a1b5e7e08ca3a8fU)), ((u64)(0x4a511b0ec57e649aU)), ((u64)(0x4a8561d276ddfdc0U)), ((u64)(0x4ababa4714957d30U)), ((u64)(0x4af0b46c6cdd6e3eU)), ((u64)(0x4b24e1878814c9ceU)), ((u64)(0x4b5a19e96a19fc41U)), ((u64)(0x4b905031e2503da9U)), ((u64)(0x4bc4643e5ae44d13U)), ((u64)(0x4bf97d4df19d6057U)), ((u64)(0x4c2fdca16e04b86dU)), ((u64)(0x4c63e9e4e4c2f344U)), ((u64)(0x4c98e45e1df3b015U)), ((u64)(0x4ccf1d75a5709c1bU)), ((u64)(0x4d03726987666191U)), ((u64)(0x4d384f03e93ff9f5U)), ((u64)(0x4d6e62c4e38ff872U)), ((u64)(0x4da2fdbb0e39fb47U)), ((u64)(0x4dd7bd29d1c87a19U)), ((u64)(0x4e0dac74463a989fU)), ((u64)(0x4e428bc8abe49f64U)), ((u64)(0x4e772ebad6ddc73dU)), ((u64)(0x4eacfa698c95390cU)), ((u64)(0x4ee21c81f7dd43a7U)), ((u64)(0x4f16a3a275d49491U)), ((u64)(0x4f4c4c8b1349b9b5U)), ((u64)(0x4f81afd6ec0e1411U)), ((u64)(0x4fb61bcca7119916U)), ((u64)(0x4feba2bfd0d5ff5bU)), ((u64)(0x502145b7e285bf99U)), ((u64)(0x50559725db272f7fU)), ((u64)(0x508afcef51f0fb5fU)), ((u64)(0x50c0de1593369d1bU)), ((u64)(0x50f5159af8044462U)), ((u64)(0x512a5b01b605557bU)), ((u64)(0x516078e111c3556dU)), ((u64)(0x5194971956342ac8U)), ((u64)(0x51c9bcdfabc1357aU)), ((u64)(0x5200160bcb58c16cU)), ((u64)(0x52341b8ebe2ef1c7U)), ((u64)(0x526922726dbaae39U)), ((u64)(0x529f6b0f092959c7U)), ((u64)(0x52d3a2e965b9d81dU)), ((u64)(0x53088ba3bf284e24U)), ((u64)(0x533eae8caef261adU)), ((u64)(0x53732d17ed577d0cU)), ((u64)(0x53a7f85de8ad5c4fU)), ((u64)(0x53ddf67562d8b363U)), ((u64)(0x5412ba095dc7701eU)), ((u64)(0x5447688bb5394c25U)), ((u64)(0x547d42aea2879f2eU)), ((u64)(0x54b249ad2594c37dU)), ((u64)(0x54e6dc186ef9f45cU)), ((u64)(0x551c931e8ab87173U)), ((u64)(0x5551dbf316b346e8U)), ((u64)(0x558652efdc6018a2U)), ((u64)(0x55bbe7abd3781ecaU)), ((u64)(0x55f170cb642b133fU)), ((u64)(0x5625ccfe3d35d80eU)), ((u64)(0x565b403dcc834e12U)), ((u64)(0x569108269fd210cbU)), ((u64)(0x56c54a3047c694feU)), ((u64)(0x56fa9cbc59b83a3dU)), ((u64)(0x5730a1f5b8132466U)), ((u64)(0x5764ca732617ed80U)), ((u64)(0x5799fd0fef9de8e0U)), ((u64)(0x57d03e29f5c2b18cU)), ((u64)(0x58044db473335defU)), ((u64)(0x583961219000356bU)), ((u64)(0x586fb969f40042c5U)), ((u64)(0x58a3d3e2388029bbU)), ((u64)(0x58d8c8dac6a0342aU)), ((u64)(0x590efb1178484135U)), ((u64)(0x59435ceaeb2d28c1U)), ((u64)(0x59783425a5f872f1U)), ((u64)(0x59ae412f0f768fadU)), ((u64)(0x59e2e8bd69aa19ccU)), ((u64)(0x5a17a2ecc414a03fU)), ((u64)(0x5a4d8ba7f519c84fU)), ((u64)(0x5a827748f9301d32U)), ((u64)(0x5ab7151b377c247eU)), ((u64)(0x5aecda62055b2d9eU)), ((u64)(0x5b22087d4358fc82U)), ((u64)(0x5b568a9c942f3ba3U)), ((u64)(0x5b8c2d43b93b0a8cU)), ((u64)(0x5bc19c4a53c4e697U)), ((u64)(0x5bf6035ce8b6203dU)), ((u64)(0x5c2b843422e3a84dU)), ((u64)(0x5c6132a095ce4930U)), ((u64)(0x5c957f48bb41db7cU)), ((u64)(0x5ccadf1aea12525bU)), ((u64)(0x5d00cb70d24b7379U)), ((u64)(0x5d34fe4d06de5057U)), ((u64)(0x5d6a3de04895e46dU)), ((u64)(0x5da066ac2d5daec4U)), ((u64)(0x5dd4805738b51a75U)), ((u64)(0x5e09a06d06e26112U)), ((u64)(0x5e400444244d7cabU)), ((u64)(0x5e7405552d60dbd6U)), ((u64)(0x5ea906aa78b912ccU)), ((u64)(0x5edf485516e7577fU)), ((u64)(0x5f138d352e5096afU)), ((u64)(0x5f48708279e4bc5bU)), ((u64)(0x5f7e8ca3185deb72U)), ((u64)(0x5fb317e5ef3ab327U)), ((u64)(0x5fe7dddf6b095ff1U)), ((u64)(0x601dd55745cbb7edU)), ((u64)(0x6052a5568b9f52f4U)), ((u64)(0x60874eac2e8727b1U)), ((u64)(0x60bd22573a28f19dU)), ((u64)(0x60f2357684599702U)), ((u64)(0x6126c2d4256ffcc3U)), ((u64)(0x615c73892ecbfbf4U)), ((u64)(0x6191c835bd3f7d78U)), ((u64)(0x61c63a432c8f5cd6U)), ((u64)(0x61fbc8d3f7b3340cU)), ((u64)(0x62315d847ad00087U)), ((u64)(0x6265b4e5998400a9U)), ((u64)(0x629b221effe500d4U)), ((u64)(0x62d0f5535fef2084U)), ((u64)(0x630532a837eae8a5U)), ((u64)(0x633a7f5245e5a2cfU)), ((u64)(0x63708f936baf85c1U)), ((u64)(0x63a4b378469b6732U)), ((u64)(0x63d9e056584240feU)), ((u64)(0x64102c35f729689fU)), ((u64)(0x6444374374f3c2c6U)), ((u64)(0x647945145230b378U)), ((u64)(0x64af965966bce056U)), ((u64)(0x64e3bdf7e0360c36U)), ((u64)(0x6518ad75d8438f43U)), ((u64)(0x654ed8d34e547314U)), ((u64)(0x6583478410f4c7ecU)), ((u64)(0x65b819651531f9e8U)), ((u64)(0x65ee1fbe5a7e7861U)), ((u64)(0x6622d3d6f88f0b3dU)), ((u64)(0x665788ccb6b2ce0cU)), ((u64)(0x668d6affe45f818fU)), ((u64)(0x66c262dfeebbb0f9U)), ((u64)(0x66f6fb97ea6a9d38U)), ((u64)(0x672cba7de5054486U)), ((u64)(0x6761f48eaf234ad4U)), ((u64)(0x679671b25aec1d89U)), ((u64)(0x67cc0e1ef1a724ebU)), ((u64)(0x680188d357087713U)), ((u64)(0x6835eb082cca94d7U)), ((u64)(0x686b65ca37fd3a0dU)), ((u64)(0x68a11f9e62fe4448U)), ((u64)(0x68d56785fbbdd55aU)), ((u64)(0x690ac1677aad4ab1U)), ((u64)(0x6940b8e0acac4eafU)), ((u64)(0x6974e718d7d7625aU)), ((u64)(0x69aa20df0dcd3af1U)), ((u64)(0x69e0548b68a044d6U)), ((u64)(0x6a1469ae42c8560cU)), ((u64)(0x6a498419d37a6b8fU)), ((u64)(0x6a7fe52048590673U)), ((u64)(0x6ab3ef342d37a408U)), ((u64)(0x6ae8eb0138858d0aU)), ((u64)(0x6b1f25c186a6f04cU)), ((u64)(0x6b537798f4285630U)), ((u64)(0x6b88557f31326bbbU)), ((u64)(0x6bbe6adefd7f06aaU)), ((u64)(0x6bf302cb5e6f642aU)), ((u64)(0x6c27c37e360b3d35U)), ((u64)(0x6c5db45dc38e0c82U)), ((u64)(0x6c9290ba9a38c7d1U)), ((u64)(0x6cc734e940c6f9c6U)), ((u64)(0x6cfd022390f8b837U)), ((u64)(0x6d3221563a9b7323U)), ((u64)(0x6d66a9abc9424febU)), ((u64)(0x6d9c5416bb92e3e6U)), ((u64)(0x6dd1b48e353bce70U)), ((u64)(0x6e0621b1c28ac20cU)), ((u64)(0x6e3baa1e332d728fU)), ((u64)(0x6e714a52dffc6799U)), ((u64)(0x6ea59ce797fb817fU)), ((u64)(0x6edb04217dfa61dfU)), ((u64)(0x6f10e294eebc7d2cU)), ((u64)(0x6f451b3a2a6b9c76U)), ((u64)(0x6f7a6208b5068394U)), ((u64)(0x6fb07d457124123dU)), ((u64)(0x6fe49c96cd6d16ccU)), ((u64)(0x7019c3bc80c85c7fU)), ((u64)(0x70501a55d07d39cfU)), ((u64)(0x708420eb449c8843U)), ((u64)(0x70b9292615c3aa54U)), ((u64)(0x70ef736f9b3494e9U)), ((u64)(0x7123a825c100dd11U)), ((u64)(0x7158922f31411456U)), ((u64)(0x718eb6bafd91596bU)), ((u64)(0x71c33234de7ad7e3U)), ((u64)(0x71f7fec216198ddcU)), ((u64)(0x722dfe729b9ff153U)), ((u64)(0x7262bf07a143f6d4U)), ((u64)(0x72976ec98994f489U)), ((u64)(0x72cd4a7bebfa31abU)), ((u64)(0x73024e8d737c5f0bU)), ((u64)(0x7336e230d05b76cdU)), ((u64)(0x736c9abd04725481U)), ((u64)(0x73a1e0b622c774d0U)), ((u64)(0x73d658e3ab795204U)), ((u64)(0x740bef1c9657a686U)), ((u64)(0x74417571ddf6c814U)), ((u64)(0x7475d2ce55747a18U)), ((u64)(0x74ab4781ead1989eU)), ((u64)(0x74e10cb132c2ff63U)), ((u64)(0x75154fdd7f73bf3cU)), ((u64)(0x754aa3d4df50af0bU)), ((u64)(0x7580a6650b926d67U)), ((u64)(0x75b4cffe4e7708c0U)), ((u64)(0x75ea03fde214caf1U)), ((u64)(0x7620427ead4cfed6U)), ((u64)(0x7654531e58a03e8cU)), ((u64)(0x768967e5eec84e2fU)), ((u64)(0x76bfc1df6a7a61bbU)), ((u64)(0x76f3d92ba28c7d15U)), ((u64)(0x7728cf768b2f9c5aU)), ((u64)(0x775f03542dfb8370U)), ((u64)(0x779362149cbd3226U)), ((u64)(0x77c83a99c3ec7eb0U)), ((u64)(0x77fe494034e79e5cU)), ((u64)(0x7832edc82110c2f9U)), ((u64)(0x7867a93a2954f3b8U)), ((u64)(0x789d9388b3aa30a5U)), ((u64)(0x78d27c35704a5e67U)), ((u64)(0x79071b42cc5cf601U)), ((u64)(0x793ce2137f743382U)), ((u64)(0x79720d4c2fa8a031U)), ((u64)(0x79a6909f3b92c83dU)), ((u64)(0x79dc34c70a777a4dU)), ((u64)(0x7a11a0fc668aac70U)), ((u64)(0x7a46093b802d578cU)), ((u64)(0x7a7b8b8a6038ad6fU)), ((u64)(0x7ab137367c236c65U)), ((u64)(0x7ae585041b2c477fU)), ((u64)(0x7b1ae64521f7595eU)), ((u64)(0x7b50cfeb353a97dbU)), ((u64)(0x7b8503e602893dd2U)), ((u64)(0x7bba44df832b8d46U)), ((u64)(0x7bf06b0bb1fb384cU)), ((u64)(0x7c2485ce9e7a065fU)), ((u64)(0x7c59a742461887f6U)), ((u64)(0x7c9008896bcf54faU)), ((u64)(0x7cc40aabc6c32a38U)), ((u64)(0x7cf90d56b873f4c7U)), ((u64)(0x7d2f50ac6690f1f8U)), ((u64)(0x7d63926bc01a973bU)), ((u64)(0x7d987706b0213d0aU)), ((u64)(0x7dce94c85c298c4cU)), ((u64)(0x7e031cfd3999f7b0U)), ((u64)(0x7e37e43c8800759cU)), ((u64)(0x7e6ddd4baa009303U)), ((u64)(0x7ea2aa4f4a405be2U)), ((u64)(0x7ed754e31cd072daU)), ((u64)(0x7f0d2a1be4048f90U)), ((u64)(0x7f423a516e82d9baU)), ((u64)(0x7f76c8e5ca239029U)), ((u64)(0x7fac7b1f3cac7433U)), ((u64)(0x7fe1ccf385ebc8a0U))}));
	_const_strconv__neg_exp = new_array_from_c_array(324, 324, sizeof(u64), _MOV((u64[324]){
		((u64)(0x3ff0000000000000U)), ((u64)(0x3fb999999999999aU)), ((u64)(0x3f847ae147ae147bU)), ((u64)(0x3f50624dd2f1a9fcU)), ((u64)(0x3f1a36e2eb1c432dU)), ((u64)(0x3ee4f8b588e368f1U)), ((u64)(0x3eb0c6f7a0b5ed8dU)), ((u64)(0x3e7ad7f29abcaf48U)), ((u64)(0x3e45798ee2308c3aU)), ((u64)(0x3e112e0be826d695U)), ((u64)(0x3ddb7cdfd9d7bdbbU)), ((u64)(0x3da5fd7fe1796495U)), ((u64)(0x3d719799812dea11U)), ((u64)(0x3d3c25c268497682U)), ((u64)(0x3d06849b86a12b9bU)), ((u64)(0x3cd203af9ee75616U)), ((u64)(0x3c9cd2b297d889bcU)), ((u64)(0x3c670ef54646d497U)), ((u64)(0x3c32725dd1d243acU)), ((u64)(0x3bfd83c94fb6d2acU)), ((u64)(0x3bc79ca10c924223U)), ((u64)(0x3b92e3b40a0e9b4fU)), ((u64)(0x3b5e392010175ee6U)), ((u64)(0x3b282db34012b251U)), ((u64)(0x3af357c299a88ea7U)), ((u64)(0x3abef2d0f5da7dd9U)), ((u64)(0x3a88c240c4aecb14U)), ((u64)(0x3a53ce9a36f23c10U)), ((u64)(0x3a1fb0f6be506019U)), ((u64)(0x39e95a5efea6b347U)), ((u64)(0x39b4484bfeebc2a0U)), ((u64)(0x398039d665896880U)), ((u64)(0x3949f623d5a8a733U)), ((u64)(0x3914c4e977ba1f5cU)), ((u64)(0x38e09d8792fb4c49U)), ((u64)(0x38aa95a5b7f87a0fU)), ((u64)(0x38754484932d2e72U)), ((u64)(0x3841039d428a8b8fU)), ((u64)(0x380b38fb9daa78e4U)), ((u64)(0x37d5c72fb1552d83U)), ((u64)(0x37a16c262777579cU)), ((u64)(0x376be03d0bf225c7U)), ((u64)(0x37364cfda3281e39U)), ((u64)(0x3701d7314f534b61U)), ((u64)(0x36cc8b8218854567U)), ((u64)(0x3696d601ad376ab9U)), ((u64)(0x366244ce242c5561U)), ((u64)(0x362d3ae36d13bbceU)), ((u64)(0x35f7624f8a762fd8U)), ((u64)(0x35c2b50c6ec4f313U)), ((u64)(0x358dee7a4ad4b81fU)), ((u64)(0x3557f1fb6f10934cU)), ((u64)(0x352327fc58da0f70U)), ((u64)(0x34eea6608e29b24dU)), ((u64)(0x34b8851a0b548ea4U)), ((u64)(0x34839dae6f76d883U)), ((u64)(0x344f62b0b257c0d2U)), ((u64)(0x34191bc08eac9a41U)), ((u64)(0x33e41633a556e1ceU)), ((u64)(0x33b011c2eaabe7d8U)), ((u64)(0x3379b604aaaca626U)), ((u64)(0x3344919d5556eb52U)), ((u64)(0x3310747ddddf22a8U)), ((u64)(0x32da53fc9631d10dU)), ((u64)(0x32a50ffd44f4a73dU)), ((u64)(0x3270d9976a5d5297U)), ((u64)(0x323af5bf109550f2U)), ((u64)(0x32059165a6ddda5bU)), ((u64)(0x31d1411e1f17e1e3U)), ((u64)(0x319b9b6364f30304U)), ((u64)(0x316615e91d8f359dU)), ((u64)(0x3131ab20e472914aU)), ((u64)(0x30fc45016d841baaU)), ((u64)(0x30c69d9abe034955U)), ((u64)(0x309217aefe690777U)), ((u64)(0x305cf2b1970e7258U)), ((u64)(0x3027288e1271f513U)), ((u64)(0x2ff286d80ec190dcU)), ((u64)(0x2fbda48ce468e7c7U)), ((u64)(0x2f87b6d71d20b96cU)), ((u64)(0x2f52f8ac174d6123U)), ((u64)(0x2f1e5aacf2156838U)), ((u64)(0x2ee8488a5b445360U)), ((u64)(0x2eb36d3b7c36a91aU)), ((u64)(0x2e7f152bf9f10e90U)), ((u64)(0x2e48ddbcc7f40ba6U)), ((u64)(0x2e13e497065cd61fU)), ((u64)(0x2ddfd424d6faf031U)), ((u64)(0x2da97683df2f268dU)), ((u64)(0x2d745ecfe5bf520bU)), ((u64)(0x2d404bd984990e6fU)), ((u64)(0x2d0a12f5a0f4e3e5U)), ((u64)(0x2cd4dbf7b3f71cb7U)), ((u64)(0x2ca0aff95cc5b092U)), ((u64)(0x2c6ab328946f80eaU)), ((u64)(0x2c355c2076bf9a55U)), ((u64)(0x2c0116805effaeaaU)), ((u64)(0x2bcb5733cb32b111U)), ((u64)(0x2b95df5ca28ef40dU)), ((u64)(0x2b617f7d4ed8c33eU)), ((u64)(0x2b2bff2ee48e0530U)), ((u64)(0x2af665bf1d3e6a8dU)), ((u64)(0x2ac1eaff4a98553dU)), ((u64)(0x2a8cab3210f3bb95U)), ((u64)(0x2a56ef5b40c2fc77U)), ((u64)(0x2a225915cd68c9f9U)), ((u64)(0x29ed5b561574765bU)), ((u64)(0x29b77c44ddf6c516U)), ((u64)(0x2982c9d0b1923745U)), ((u64)(0x294e0fb44f50586eU)), ((u64)(0x29180c903f7379f2U)), ((u64)(0x28e33d4032c2c7f5U)), ((u64)(0x28aec866b79e0cbaU)), ((u64)(0x2878a0522c7e7095U)), ((u64)(0x2843b374f06526deU)), ((u64)(0x280f8587e7083e30U)), ((u64)(0x27d9379fec069826U)), ((u64)(0x27a42c7ff0054685U)), ((u64)(0x277023998cd10537U)), ((u64)(0x2739d28f47b4d525U)), ((u64)(0x2704a8729fc3ddb7U)), ((u64)(0x26d086c219697e2cU)), ((u64)(0x269a71368f0f3047U)), ((u64)(0x2665275ed8d8f36cU)), ((u64)(0x2630ec4be0ad8f89U)), ((u64)(0x25fb13ac9aaf4c0fU)), ((u64)(0x25c5a956e225d672U)), ((u64)(0x2591544581b7dec2U)), ((u64)(0x255bba08cf8c979dU)), ((u64)(0x25262e6d72d6dfb0U)), ((u64)(0x24f1bebdf578b2f4U)), ((u64)(0x24bc6463225ab7ecU)), ((u64)(0x2486b6b5b5155ff0U)), ((u64)(0x24522bc490dde65aU)), ((u64)(0x241d12d41afca3c3U)), ((u64)(0x23e7424348ca1c9cU)), ((u64)(0x23b29b69070816e3U)), ((u64)(0x237dc574d80cf16bU)), ((u64)(0x2347d12a4670c123U)), ((u64)(0x23130dbb6b8d674fU)), ((u64)(0x22de7c5f127bd87eU)), ((u64)(0x22a8637f41fcad32U)), ((u64)(0x227382cc34ca2428U)), ((u64)(0x223f37ad21436d0cU)), ((u64)(0x2208f9574dcf8a70U)), ((u64)(0x21d3faac3e3fa1f3U)), ((u64)(0x219ff779fd329cb9U)), ((u64)(0x216992c7fdc216faU)), ((u64)(0x2134756ccb01abfbU)), ((u64)(0x21005df0a267bcc9U)), ((u64)(0x20ca2fe76a3f9475U)), ((u64)(0x2094f31f8832dd2aU)), ((u64)(0x2060c27fa028b0efU)), ((u64)(0x202ad0cc33744e4bU)), ((u64)(0x1ff573d68f903ea2U)), ((u64)(0x1fc1297872d9cbb5U)), ((u64)(0x1f8b758d848fac55U)), ((u64)(0x1f55f7a46a0c89ddU)), ((u64)(0x1f2192e9ee706e4bU)), ((u64)(0x1eec1e43171a4a11U)), ((u64)(0x1eb67e9c127b6e74U)), ((u64)(0x1e81fee341fc585dU)), ((u64)(0x1e4ccb0536608d61U)), ((u64)(0x1e1708d0f84d3de7U)), ((u64)(0x1de26d73f9d764b9U)), ((u64)(0x1dad7becc2f23ac2U)), ((u64)(0x1d779657025b6235U)), ((u64)(0x1d42deac01e2b4f7U)), ((u64)(0x1d0e3113363787f2U)), ((u64)(0x1cd8274291c6065bU)), ((u64)(0x1ca3529ba7d19eafU)), ((u64)(0x1c6eea92a61c3118U)), ((u64)(0x1c38bba884e35a7aU)), ((u64)(0x1c03c9539d82aec8U)), ((u64)(0x1bcfa885c8d117a6U)), ((u64)(0x1b99539e3a40dfb8U)), ((u64)(0x1b6442e4fb671960U)), ((u64)(0x1b303583fc527ab3U)), ((u64)(0x1af9ef3993b72ab8U)), ((u64)(0x1ac4bf6142f8eefaU)), ((u64)(0x1a90991a9bfa58c8U)), ((u64)(0x1a5a8e90f9908e0dU)), ((u64)(0x1a253eda614071a4U)), ((u64)(0x19f0ff151a99f483U)), ((u64)(0x19bb31bb5dc320d2U)), ((u64)(0x1985c162b168e70eU)), ((u64)(0x1951678227871f3eU)), ((u64)(0x191bd8d03f3e9864U)), ((u64)(0x18e6470cff6546b6U)), ((u64)(0x18b1d270cc51055fU)), ((u64)(0x187c83e7ad4e6efeU)), ((u64)(0x1846cfec8aa52598U)), ((u64)(0x18123ff06eea847aU)), ((u64)(0x17dd331a4b10d3f6U)), ((u64)(0x17a75c1508da432bU)), ((u64)(0x1772b010d3e1cf56U)), ((u64)(0x173de6815302e556U)), ((u64)(0x1707eb9aa8cf1ddeU)), ((u64)(0x16d322e220a5b17eU)), ((u64)(0x169e9e369aa2b597U)), ((u64)(0x16687e92154ef7acU)), ((u64)(0x16339874ddd8c623U)), ((u64)(0x15ff5a549627a36cU)), ((u64)(0x15c91510781fb5f0U)), ((u64)(0x159410d9f9b2f7f3U)), ((u64)(0x15600d7b2e28c65cU)), ((u64)(0x1529af2b7d0e0a2dU)), ((u64)(0x14f48c22ca71a1bdU)), ((u64)(0x14c0701bd527b498U)), ((u64)(0x148a4cf9550c5426U)), ((u64)(0x14550a6110d6a9b8U)), ((u64)(0x1420d51a73deee2dU)), ((u64)(0x13eaee90b964b047U)), ((u64)(0x13b58ba6fab6f36cU)), ((u64)(0x13813c85955f2923U)), ((u64)(0x134b9408eefea839U)), ((u64)(0x1316100725988694U)), ((u64)(0x12e1a66c1e139eddU)), ((u64)(0x12ac3d79c9b8fe2eU)), ((u64)(0x12769794a160cb58U)), ((u64)(0x124212dd4de70913U)), ((u64)(0x120ceafbafd80e85U)), ((u64)(0x11d72262f3133ed1U)), ((u64)(0x11a281e8c275cbdaU)), ((u64)(0x116d9ca79d89462aU)), ((u64)(0x1137b08617a104eeU)), ((u64)(0x1102f39e794d9d8bU)), ((u64)(0x10ce5297287c2f45U)), ((u64)(0x1098421286c9bf6bU)), ((u64)(0x1063680ed23aff89U)), ((u64)(0x102f0ce4839198dbU)), ((u64)(0x0ff8d71d360e13e2U)), ((u64)(0x0fc3df4a91a4dcb5U)), ((u64)(0x0f8fcbaa82a16121U)), ((u64)(0x0f596fbb9bb44db4U)), ((u64)(0x0f245962e2f6a490U)), ((u64)(0x0ef047824f2bb6daU)), ((u64)(0x0eba0c03b1df8af6U)), ((u64)(0x0e84d6695b193bf8U)), ((u64)(0x0e50ab877c142ffaU)), ((u64)(0x0e1aac0bf9b9e65cU)), ((u64)(0x0de5566ffafb1eb0U)), ((u64)(0x0db111f32f2f4bc0U)), ((u64)(0x0d7b4feb7eb212cdU)), ((u64)(0x0d45d98932280f0aU)), ((u64)(0x0d117ad428200c08U)), ((u64)(0x0cdbf7b9d9cce00dU)), ((u64)(0x0ca65fc7e170b33eU)), ((u64)(0x0c71e6398126f5cbU)), ((u64)(0x0c3ca38f350b22dfU)), ((u64)(0x0c06e93f5da2824cU)), ((u64)(0x0bd25432b14ecea3U)), ((u64)(0x0b9d53844ee47dd1U)), ((u64)(0x0b677603725064a8U)), ((u64)(0x0b32c4cf8ea6b6ecU)), ((u64)(0x0afe07b27dd78b14U)), ((u64)(0x0ac8062864ac6f43U)), ((u64)(0x0a9338205089f29cU)), ((u64)(0x0a5ec033b40fea93U)), ((u64)(0x0a2899c2f6732210U)), ((u64)(0x09f3ae3591f5b4d9U)), ((u64)(0x09bf7d228322baf5U)), ((u64)(0x098930e868e89591U)), ((u64)(0x0954272053ed4474U)), ((u64)(0x09201f4d0ff10390U)), ((u64)(0x08e9cbae7fe805b3U)), ((u64)(0x08b4a2f1ffecd15cU)), ((u64)(0x0880825b3323dab0U)), ((u64)(0x084a6a2b85062ab3U)), ((u64)(0x081521bc6a6b555cU)), ((u64)(0x07e0e7c9eebc444aU)), ((u64)(0x07ab0c764ac6d3a9U)), ((u64)(0x0775a391d56bdc87U)), ((u64)(0x07414fa7ddefe3a0U)), ((u64)(0x070bb2a62fe638ffU)), ((u64)(0x06d62884f31e93ffU)), ((u64)(0x06a1ba03f5b21000U)), ((u64)(0x066c5cd322b67fffU)), ((u64)(0x0636b0a8e891ffffU)), ((u64)(0x060226ed86db3333U)), ((u64)(0x05cd0b15a491eb84U)), ((u64)(0x05973c115074bc6aU)), ((u64)(0x05629674405d6388U)), ((u64)(0x052dbd86cd6238d9U)), ((u64)(0x04f7cad23de82d7bU)), ((u64)(0x04c308a831868ac9U)), ((u64)(0x048e74404f3daadbU)), ((u64)(0x04585d003f6488afU)), ((u64)(0x04237d99cc506d59U)), ((u64)(0x03ef2f5c7a1a488eU)), ((u64)(0x03b8f2b061aea072U)), ((u64)(0x0383f559e7bee6c1U)), ((u64)(0x034feef63f97d79cU)), ((u64)(0x03198bf832dfdfb0U)), ((u64)(0x02e46ff9c24cb2f3U)), ((u64)(0x02b059949b708f29U)), ((u64)(0x027a28edc580e50eU)), ((u64)(0x0244ed8b04671da5U)), ((u64)(0x0210be08d0527e1dU)), ((u64)(0x01dac9a7b3b7302fU)), ((u64)(0x01a56e1fc2f8f359U)), ((u64)(0x017124e63593f5e1U)), ((u64)(0x013b6e3d22865634U)), ((u64)(0x0105f1ca820511c3U)), ((u64)(0x00d18e3b9b374169U)), ((u64)(0x009c16c5c5253575U)), ((u64)(0x0066789e3750f791U)), ((u64)(0x0031fa182c40c60dU)), ((u64)(0x000730d67819e8d2U)), ((u64)(0x0000b8157268fdafU)), ((u64)(0x000012688b70e62bU)), ((u64)(0x000001d74124e3d1U)), ((u64)(0x0000002f201d49fbU)), ((u64)(0x00000004b6695433U)), ((u64)(0x0000000078a42205U)), ((u64)(0x000000000c1069cdU)), ((u64)(0x000000000134d761U)), ((u64)(0x00000000001ee257U)), ((u64)(0x00000000000316a2U)), ((u64)(0x0000000000004f10U)), ((u64)(0x00000000000007e8U)), ((u64)(0x00000000000000caU)), ((u64)(0x0000000000000014U)), ((u64)(0x0000000000000002U))}));
	_const_strconv__max_u64 = ((u64)(18446744073709551615U));
	_const_strconv__ten_pow_table_32 = new_array_from_c_array(12, 12, sizeof(u32), _MOV((u32[12]){
		((u32)(1U)), ((u32)(10U)), ((u32)(100U)), ((u32)(1000U)), ((u32)(10000U)), ((u32)(100000U)), ((u32)(1000000U)), ((u32)(10000000U)), ((u32)(100000000U)), ((u32)(1000000000U)), ((u32)(10000000000U)), ((u32)(100000000000U))}));
	_const_strconv__mantbits32 = ((u32)(23U));
	_const_strconv__expbits32 = ((u32)(8U));
	_const_strconv__ten_pow_table_64 = new_array_from_c_array(20, 20, sizeof(u64), _MOV((u64[20]){
		((u64)(1U)), ((u64)(10U)), ((u64)(100U)), ((u64)(1000U)), ((u64)(10000U)), ((u64)(100000U)), ((u64)(1000000U)), ((u64)(10000000U)), ((u64)(100000000U)), ((u64)(1000000000U)), ((u64)(10000000000U)), ((u64)(100000000000U)), ((u64)(1000000000000U)), ((u64)(10000000000000U)), ((u64)(100000000000000U)), ((u64)(1000000000000000U)), ((u64)(10000000000000000U)), ((u64)(100000000000000000U)), ((u64)(1000000000000000000U)), ((u64)(10000000000000000000U))}));
	_const_strconv__mantbits64 = ((u32)(52U));
	_const_strconv__expbits64 = ((u32)(11U));
	_const_strconv__dec_round = new_array_from_c_array(20, 20, sizeof(f64), _MOV((f64[20]){
		((f64)(0.44)), 0.044, 0.0044, 0.00044, 0.000044, 0.0000044, 0.00000044, 0.000000044, 0.0000000044, 0.00000000044, 0.000000000044, 0.0000000000044, 0.00000000000044, 0.000000000000044, 0.0000000000000044, 0.00000000000000044, 0.000000000000000044, 0.0000000000000000044, 0.00000000000000000044, 0.000000000000000000044}));
	_const_strconv__powers_of_10 = new_array_from_c_array(18, 18, sizeof(u64), _MOV((u64[18]){
		((u64)(1e0)), ((u64)(1e1)), ((u64)(1e2)), ((u64)(1e3)), ((u64)(1e4)), ((u64)(1e5)), ((u64)(1e6)), ((u64)(1e7)), ((u64)(1e8)), ((u64)(1e9)), ((u64)(1e10)), ((u64)(1e11)), ((u64)(1e12)), ((u64)(1e13)), ((u64)(1e14)), ((u64)(1e15)), ((u64)(1e16)), ((u64)(1e17))}));
	_const_strconv__pow5_split_32 = new_array_from_c_array(47, 47, sizeof(u64), _MOV((u64[47]){
		((u64)(1152921504606846976U)), ((u64)(1441151880758558720U)), ((u64)(1801439850948198400U)), ((u64)(2251799813685248000U)), ((u64)(1407374883553280000U)), ((u64)(1759218604441600000U)), ((u64)(2199023255552000000U)), ((u64)(1374389534720000000U)), ((u64)(1717986918400000000U)), ((u64)(2147483648000000000U)), ((u64)(1342177280000000000U)), ((u64)(1677721600000000000U)), ((u64)(2097152000000000000U)), ((u64)(1310720000000000000U)), ((u64)(1638400000000000000U)), ((u64)(2048000000000000000U)), ((u64)(1280000000000000000U)), ((u64)(1600000000000000000U)), ((u64)(2000000000000000000U)), ((u64)(1250000000000000000U)), ((u64)(1562500000000000000U)), ((u64)(1953125000000000000U)), ((u64)(1220703125000000000U)), ((u64)(1525878906250000000U)), ((u64)(1907348632812500000U)), ((u64)(1192092895507812500U)), ((u64)(1490116119384765625U)), ((u64)(1862645149230957031U)), ((u64)(1164153218269348144U)), ((u64)(1455191522836685180U)), ((u64)(1818989403545856475U)), ((u64)(2273736754432320594U)), ((u64)(1421085471520200371U)), ((u64)(1776356839400250464U)), ((u64)(2220446049250313080U)), ((u64)(1387778780781445675U)), ((u64)(1734723475976807094U)), ((u64)(2168404344971008868U)), ((u64)(1355252715606880542U)), ((u64)(1694065894508600678U)), ((u64)(2117582368135750847U)), ((u64)(1323488980084844279U)), ((u64)(1654361225106055349U)), ((u64)(2067951531382569187U)), ((u64)(1292469707114105741U)), ((u64)(1615587133892632177U)), ((u64)(2019483917365790221U))}));
	_const_strconv__pow5_inv_split_32 = new_array_from_c_array(31, 31, sizeof(u64), _MOV((u64[31]){
		((u64)(576460752303423489U)), ((u64)(461168601842738791U)), ((u64)(368934881474191033U)), ((u64)(295147905179352826U)), ((u64)(472236648286964522U)), ((u64)(377789318629571618U)), ((u64)(302231454903657294U)), ((u64)(483570327845851670U)), ((u64)(386856262276681336U)), ((u64)(309485009821345069U)), ((u64)(495176015714152110U)), ((u64)(396140812571321688U)), ((u64)(316912650057057351U)), ((u64)(507060240091291761U)), ((u64)(405648192073033409U)), ((u64)(324518553658426727U)), ((u64)(519229685853482763U)), ((u64)(415383748682786211U)), ((u64)(332306998946228969U)), ((u64)(531691198313966350U)), ((u64)(425352958651173080U)), ((u64)(340282366920938464U)), ((u64)(544451787073501542U)), ((u64)(435561429658801234U)), ((u64)(348449143727040987U)), ((u64)(557518629963265579U)), ((u64)(446014903970612463U)), ((u64)(356811923176489971U)), ((u64)(570899077082383953U)), ((u64)(456719261665907162U)), ((u64)(365375409332725730U))}));
	_const_strconv__pow5_split_64 = new_array_from_c_array(326, 326, sizeof(strconv__Uint128), _MOV((strconv__Uint128[326]){
		(strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0100000000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0140000000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0190000000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01f4000000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0138800000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0186a00000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01e8480000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01312d0000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x017d784000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01dcd65000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x012a05f200000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0174876e80000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01d1a94a20000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x012309ce54000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x016bcc41e9000000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01c6bf5263400000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x011c37937e080000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x016345785d8a0000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01bc16d674ec8000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01158e460913d000U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x015af1d78b58c400U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01b1ae4d6e2ef500U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x010f0cf064dd5920U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x0152d02c7e14af68U)),}, (strconv__Uint128){.lo = ((u64)(0x0000000000000000U)),.hi = ((u64)(0x01a784379d99db42U)),}, (strconv__Uint128){.lo = ((u64)(0x4000000000000000U)),.hi = ((u64)(0x0108b2a2c2802909U)),}, (strconv__Uint128){.lo = ((u64)(0x9000000000000000U)),.hi = ((u64)(0x014adf4b7320334bU)),}, (strconv__Uint128){.lo = ((u64)(0x7400000000000000U)),.hi = ((u64)(0x019d971e4fe8401eU)),}, (strconv__Uint128){.lo = ((u64)(0x0880000000000000U)),.hi = ((u64)(0x01027e72f1f12813U)),}, (strconv__Uint128){.lo = ((u64)(0xcaa0000000000000U)),.hi = ((u64)(0x01431e0fae6d7217U)),}, (strconv__Uint128){.lo = ((u64)(0xbd48000000000000U)),.hi = ((u64)(0x0193e5939a08ce9dU)),}, (strconv__Uint128){.lo = ((u64)(0x2c9a000000000000U)),.hi = ((u64)(0x01f8def8808b0245U)),}, (strconv__Uint128){.lo = ((u64)(0x3be0400000000000U)),.hi = ((u64)(0x013b8b5b5056e16bU)),}, (strconv__Uint128){.lo = ((u64)(0x0ad8500000000000U)),.hi = ((u64)(0x018a6e32246c99c6U)),}, (strconv__Uint128){.lo = ((u64)(0x8d8e640000000000U)),.hi = ((u64)(0x01ed09bead87c037U)),}, (strconv__Uint128){.lo = ((u64)(0xb878fe8000000000U)),.hi = ((u64)(0x013426172c74d822U)),}, (strconv__Uint128){.lo = ((u64)(0x66973e2000000000U)),.hi = ((u64)(0x01812f9cf7920e2bU)),}, (strconv__Uint128){.lo = ((u64)(0x403d0da800000000U)),.hi = ((u64)(0x01e17b84357691b6U)),}, (strconv__Uint128){.lo = ((u64)(0xe826288900000000U)),.hi = ((u64)(0x012ced32a16a1b11U)),}, (strconv__Uint128){.lo = ((u64)(0x622fb2ab40000000U)),.hi = ((u64)(0x0178287f49c4a1d6U)),}, (strconv__Uint128){.lo = ((u64)(0xfabb9f5610000000U)),.hi = ((u64)(0x01d6329f1c35ca4bU)),}, (strconv__Uint128){.lo = ((u64)(0x7cb54395ca000000U)),.hi = ((u64)(0x0125dfa371a19e6fU)),}, (strconv__Uint128){.lo = ((u64)(0x5be2947b3c800000U)),.hi = ((u64)(0x016f578c4e0a060bU)),}, (strconv__Uint128){.lo = ((u64)(0x32db399a0ba00000U)),.hi = ((u64)(0x01cb2d6f618c878eU)),}, (strconv__Uint128){.lo = ((u64)(0xdfc9040047440000U)),.hi = ((u64)(0x011efc659cf7d4b8U)),}, (strconv__Uint128){.lo = ((u64)(0x17bb450059150000U)),.hi = ((u64)(0x0166bb7f0435c9e7U)),}, (strconv__Uint128){.lo = ((u64)(0xddaa16406f5a4000U)),.hi = ((u64)(0x01c06a5ec5433c60U)),}, (strconv__Uint128){.lo = ((u64)(0x8a8a4de845986800U)),.hi = ((u64)(0x0118427b3b4a05bcU)),}, (strconv__Uint128){.lo = ((u64)(0xad2ce16256fe8200U)),.hi = ((u64)(0x015e531a0a1c872bU)),}, (strconv__Uint128){.lo = ((u64)(0x987819baecbe2280U)),.hi = ((u64)(0x01b5e7e08ca3a8f6U)),}, (strconv__Uint128){.lo = ((u64)(0x1f4b1014d3f6d590U)),.hi = ((u64)(0x0111b0ec57e6499aU)),}, (strconv__Uint128){.lo = ((u64)(0xa71dd41a08f48af4U)),.hi = ((u64)(0x01561d276ddfdc00U)),}, (strconv__Uint128){.lo = ((u64)(0xd0e549208b31adb1U)),.hi = ((u64)(0x01aba4714957d300U)),}, (strconv__Uint128){.lo = ((u64)(0x828f4db456ff0c8eU)),.hi = ((u64)(0x010b46c6cdd6e3e0U)),}, (strconv__Uint128){.lo = ((u64)(0xa33321216cbecfb2U)),.hi = ((u64)(0x014e1878814c9cd8U)),}, (strconv__Uint128){.lo = ((u64)(0xcbffe969c7ee839eU)),.hi = ((u64)(0x01a19e96a19fc40eU)),}, (strconv__Uint128){.lo = ((u64)(0x3f7ff1e21cf51243U)),.hi = ((u64)(0x0105031e2503da89U)),}, (strconv__Uint128){.lo = ((u64)(0x8f5fee5aa43256d4U)),.hi = ((u64)(0x014643e5ae44d12bU)),}, (strconv__Uint128){.lo = ((u64)(0x7337e9f14d3eec89U)),.hi = ((u64)(0x0197d4df19d60576U)),}, (strconv__Uint128){.lo = ((u64)(0x1005e46da08ea7abU)),.hi = ((u64)(0x01fdca16e04b86d4U)),}, (strconv__Uint128){.lo = ((u64)(0x8a03aec4845928cbU)),.hi = ((u64)(0x013e9e4e4c2f3444U)),}, (strconv__Uint128){.lo = ((u64)(0xac849a75a56f72fdU)),.hi = ((u64)(0x018e45e1df3b0155U)),}, (strconv__Uint128){.lo = ((u64)(0x17a5c1130ecb4fbdU)),.hi = ((u64)(0x01f1d75a5709c1abU)),}, (strconv__Uint128){.lo = ((u64)(0xeec798abe93f11d6U)),.hi = ((u64)(0x013726987666190aU)),}, (strconv__Uint128){.lo = ((u64)(0xaa797ed6e38ed64bU)),.hi = ((u64)(0x0184f03e93ff9f4dU)),}, (strconv__Uint128){.lo = ((u64)(0x1517de8c9c728bdeU)),.hi = ((u64)(0x01e62c4e38ff8721U)),}, (strconv__Uint128){.lo = ((u64)(0xad2eeb17e1c7976bU)),.hi = ((u64)(0x012fdbb0e39fb474U)),}, (strconv__Uint128){.lo = ((u64)(0xd87aa5ddda397d46U)),.hi = ((u64)(0x017bd29d1c87a191U)),}, (strconv__Uint128){.lo = ((u64)(0x4e994f5550c7dc97U)),.hi = ((u64)(0x01dac74463a989f6U)),}, (strconv__Uint128){.lo = ((u64)(0xf11fd195527ce9deU)),.hi = ((u64)(0x0128bc8abe49f639U)),}, (strconv__Uint128){.lo = ((u64)(0x6d67c5faa71c2456U)),.hi = ((u64)(0x0172ebad6ddc73c8U)),}, (strconv__Uint128){.lo = ((u64)(0x88c1b77950e32d6cU)),.hi = ((u64)(0x01cfa698c95390baU)),}, (strconv__Uint128){.lo = ((u64)(0x957912abd28dfc63U)),.hi = ((u64)(0x0121c81f7dd43a74U)),}, (strconv__Uint128){.lo = ((u64)(0xbad75756c7317b7cU)),.hi = ((u64)(0x016a3a275d494911U)),}, (strconv__Uint128){.lo = ((u64)(0x298d2d2c78fdda5bU)),.hi = ((u64)(0x01c4c8b1349b9b56U)),}, (strconv__Uint128){.lo = ((u64)(0xd9f83c3bcb9ea879U)),.hi = ((u64)(0x011afd6ec0e14115U)),}, (strconv__Uint128){.lo = ((u64)(0x50764b4abe865297U)),.hi = ((u64)(0x0161bcca7119915bU)),}, (strconv__Uint128){.lo = ((u64)(0x2493de1d6e27e73dU)),.hi = ((u64)(0x01ba2bfd0d5ff5b2U)),}, (strconv__Uint128){.lo = ((u64)(0x56dc6ad264d8f086U)),.hi = ((u64)(0x01145b7e285bf98fU)),}, (strconv__Uint128){.lo = ((u64)(0x2c938586fe0f2ca8U)),.hi = ((u64)(0x0159725db272f7f3U)),}, (strconv__Uint128){.lo = ((u64)(0xf7b866e8bd92f7d2U)),.hi = ((u64)(0x01afcef51f0fb5efU)),}, (strconv__Uint128){.lo = ((u64)(0xfad34051767bdae3U)),.hi = ((u64)(0x010de1593369d1b5U)),}, (strconv__Uint128){.lo = ((u64)(0x79881065d41ad19cU)),.hi = ((u64)(0x015159af80444623U)),}, (strconv__Uint128){.lo = ((u64)(0x57ea147f49218603U)),.hi = ((u64)(0x01a5b01b605557acU)),}, (strconv__Uint128){.lo = ((u64)(0xb6f24ccf8db4f3c1U)),.hi = ((u64)(0x01078e111c3556cbU)),}, (strconv__Uint128){.lo = ((u64)(0xa4aee003712230b2U)),.hi = ((u64)(0x014971956342ac7eU)),}, (strconv__Uint128){.lo = ((u64)(0x4dda98044d6abcdfU)),.hi = ((u64)(0x019bcdfabc13579eU)),}, (strconv__Uint128){.lo = ((u64)(0xf0a89f02b062b60bU)),.hi = ((u64)(0x010160bcb58c16c2U)),}, (strconv__Uint128){.lo = ((u64)(0xacd2c6c35c7b638eU)),.hi = ((u64)(0x0141b8ebe2ef1c73U)),}, (strconv__Uint128){.lo = ((u64)(0x98077874339a3c71U)),.hi = ((u64)(0x01922726dbaae390U)),}, (strconv__Uint128){.lo = ((u64)(0xbe0956914080cb8eU)),.hi = ((u64)(0x01f6b0f092959c74U)),}, (strconv__Uint128){.lo = ((u64)(0xf6c5d61ac8507f38U)),.hi = ((u64)(0x013a2e965b9d81c8U)),}, (strconv__Uint128){.lo = ((u64)(0x34774ba17a649f07U)),.hi = ((u64)(0x0188ba3bf284e23bU)),}, (strconv__Uint128){.lo = ((u64)(0x01951e89d8fdc6c8U)),.hi = ((u64)(0x01eae8caef261acaU)),}, (strconv__Uint128){.lo = ((u64)(0x40fd3316279e9c3dU)),.hi = ((u64)(0x0132d17ed577d0beU)),}, (strconv__Uint128){.lo = ((u64)(0xd13c7fdbb186434cU)),.hi = ((u64)(0x017f85de8ad5c4edU)),}, (strconv__Uint128){.lo = ((u64)(0x458b9fd29de7d420U)),.hi = ((u64)(0x01df67562d8b3629U)),}, (strconv__Uint128){.lo = ((u64)(0xcb7743e3a2b0e494U)),.hi = ((u64)(0x012ba095dc7701d9U)),}, (strconv__Uint128){.lo = ((u64)(0x3e5514dc8b5d1db9U)),.hi = ((u64)(0x017688bb5394c250U)),}, (strconv__Uint128){.lo = ((u64)(0x4dea5a13ae346527U)),.hi = ((u64)(0x01d42aea2879f2e4U)),}, (strconv__Uint128){.lo = ((u64)(0xb0b2784c4ce0bf38U)),.hi = ((u64)(0x01249ad2594c37ceU)),}, (strconv__Uint128){.lo = ((u64)(0x5cdf165f6018ef06U)),.hi = ((u64)(0x016dc186ef9f45c2U)),}, (strconv__Uint128){.lo = ((u64)(0xf416dbf7381f2ac8U)),.hi = ((u64)(0x01c931e8ab871732U)),}, (strconv__Uint128){.lo = ((u64)(0xd88e497a83137abdU)),.hi = ((u64)(0x011dbf316b346e7fU)),}, (strconv__Uint128){.lo = ((u64)(0xceb1dbd923d8596cU)),.hi = ((u64)(0x01652efdc6018a1fU)),}, (strconv__Uint128){.lo = ((u64)(0xc25e52cf6cce6fc7U)),.hi = ((u64)(0x01be7abd3781eca7U)),}, (strconv__Uint128){.lo = ((u64)(0xd97af3c1a40105dcU)),.hi = ((u64)(0x01170cb642b133e8U)),}, (strconv__Uint128){.lo = ((u64)(0x0fd9b0b20d014754U)),.hi = ((u64)(0x015ccfe3d35d80e3U)),}, (strconv__Uint128){.lo = ((u64)(0xd3d01cde90419929U)),.hi = ((u64)(0x01b403dcc834e11bU)),}, (strconv__Uint128){.lo = ((u64)(0x6462120b1a28ffb9U)),.hi = ((u64)(0x01108269fd210cb1U)),}, (strconv__Uint128){.lo = ((u64)(0xbd7a968de0b33fa8U)),.hi = ((u64)(0x0154a3047c694fddU)),}, (strconv__Uint128){.lo = ((u64)(0x2cd93c3158e00f92U)),.hi = ((u64)(0x01a9cbc59b83a3d5U)),}, (strconv__Uint128){.lo = ((u64)(0x3c07c59ed78c09bbU)),.hi = ((u64)(0x010a1f5b81324665U)),}, (strconv__Uint128){.lo = ((u64)(0x8b09b7068d6f0c2aU)),.hi = ((u64)(0x014ca732617ed7feU)),}, (strconv__Uint128){.lo = ((u64)(0x2dcc24c830cacf34U)),.hi = ((u64)(0x019fd0fef9de8dfeU)),}, (strconv__Uint128){.lo = ((u64)(0xdc9f96fd1e7ec180U)),.hi = ((u64)(0x0103e29f5c2b18beU)),}, (strconv__Uint128){.lo = ((u64)(0x93c77cbc661e71e1U)),.hi = ((u64)(0x0144db473335deeeU)),}, (strconv__Uint128){.lo = ((u64)(0x38b95beb7fa60e59U)),.hi = ((u64)(0x01961219000356aaU)),}, (strconv__Uint128){.lo = ((u64)(0xc6e7b2e65f8f91efU)),.hi = ((u64)(0x01fb969f40042c54U)),}, (strconv__Uint128){.lo = ((u64)(0xfc50cfcffbb9bb35U)),.hi = ((u64)(0x013d3e2388029bb4U)),}, (strconv__Uint128){.lo = ((u64)(0x3b6503c3faa82a03U)),.hi = ((u64)(0x018c8dac6a0342a2U)),}, (strconv__Uint128){.lo = ((u64)(0xca3e44b4f9523484U)),.hi = ((u64)(0x01efb1178484134aU)),}, (strconv__Uint128){.lo = ((u64)(0xbe66eaf11bd360d2U)),.hi = ((u64)(0x0135ceaeb2d28c0eU)),}, (strconv__Uint128){.lo = ((u64)(0x6e00a5ad62c83907U)),.hi = ((u64)(0x0183425a5f872f12U)),}, (strconv__Uint128){.lo = ((u64)(0x0980cf18bb7a4749U)),.hi = ((u64)(0x01e412f0f768fad7U)),}, (strconv__Uint128){.lo = ((u64)(0x65f0816f752c6c8dU)),.hi = ((u64)(0x012e8bd69aa19cc6U)),}, (strconv__Uint128){.lo = ((u64)(0xff6ca1cb527787b1U)),.hi = ((u64)(0x017a2ecc414a03f7U)),}, (strconv__Uint128){.lo = ((u64)(0xff47ca3e2715699dU)),.hi = ((u64)(0x01d8ba7f519c84f5U)),}, (strconv__Uint128){.lo = ((u64)(0xbf8cde66d86d6202U)),.hi = ((u64)(0x0127748f9301d319U)),}, (strconv__Uint128){.lo = ((u64)(0x2f7016008e88ba83U)),.hi = ((u64)(0x017151b377c247e0U)),}, (strconv__Uint128){.lo = ((u64)(0x3b4c1b80b22ae923U)),.hi = ((u64)(0x01cda62055b2d9d8U)),}, (strconv__Uint128){.lo = ((u64)(0x250f91306f5ad1b6U)),.hi = ((u64)(0x012087d4358fc827U)),}, (strconv__Uint128){.lo = ((u64)(0xee53757c8b318623U)),.hi = ((u64)(0x0168a9c942f3ba30U)),}, (strconv__Uint128){.lo = ((u64)(0x29e852dbadfde7acU)),.hi = ((u64)(0x01c2d43b93b0a8bdU)),}, (strconv__Uint128){.lo = ((u64)(0x3a3133c94cbeb0ccU)),.hi = ((u64)(0x0119c4a53c4e6976U)),}, (strconv__Uint128){.lo = ((u64)(0xc8bd80bb9fee5cffU)),.hi = ((u64)(0x016035ce8b6203d3U)),}, (strconv__Uint128){.lo = ((u64)(0xbaece0ea87e9f43eU)),.hi = ((u64)(0x01b843422e3a84c8U)),}, (strconv__Uint128){.lo = ((u64)(0x74d40c9294f238a7U)),.hi = ((u64)(0x01132a095ce492fdU)),}, (strconv__Uint128){.lo = ((u64)(0xd2090fb73a2ec6d1U)),.hi = ((u64)(0x0157f48bb41db7bcU)),}, (strconv__Uint128){.lo = ((u64)(0x068b53a508ba7885U)),.hi = ((u64)(0x01adf1aea12525acU)),}, (strconv__Uint128){.lo = ((u64)(0x8417144725748b53U)),.hi = ((u64)(0x010cb70d24b7378bU)),}, (strconv__Uint128){.lo = ((u64)(0x651cd958eed1ae28U)),.hi = ((u64)(0x014fe4d06de5056eU)),}, (strconv__Uint128){.lo = ((u64)(0xfe640faf2a8619b2U)),.hi = ((u64)(0x01a3de04895e46c9U)),}, (strconv__Uint128){.lo = ((u64)(0x3efe89cd7a93d00fU)),.hi = ((u64)(0x01066ac2d5daec3eU)),}, (strconv__Uint128){.lo = ((u64)(0xcebe2c40d938c413U)),.hi = ((u64)(0x014805738b51a74dU)),}, (strconv__Uint128){.lo = ((u64)(0x426db7510f86f518U)),.hi = ((u64)(0x019a06d06e261121U)),}, (strconv__Uint128){.lo = ((u64)(0xc9849292a9b4592fU)),.hi = ((u64)(0x0100444244d7cab4U)),}, (strconv__Uint128){.lo = ((u64)(0xfbe5b73754216f7aU)),.hi = ((u64)(0x01405552d60dbd61U)),}, (strconv__Uint128){.lo = ((u64)(0x7adf25052929cb59U)),.hi = ((u64)(0x01906aa78b912cbaU)),}, (strconv__Uint128){.lo = ((u64)(0x1996ee4673743e2fU)),.hi = ((u64)(0x01f485516e7577e9U)),}, (strconv__Uint128){.lo = ((u64)(0xaffe54ec0828a6ddU)),.hi = ((u64)(0x0138d352e5096af1U)),}, (strconv__Uint128){.lo = ((u64)(0x1bfdea270a32d095U)),.hi = ((u64)(0x018708279e4bc5aeU)),}, (strconv__Uint128){.lo = ((u64)(0xa2fd64b0ccbf84baU)),.hi = ((u64)(0x01e8ca3185deb719U)),}, (strconv__Uint128){.lo = ((u64)(0x05de5eee7ff7b2f4U)),.hi = ((u64)(0x01317e5ef3ab3270U)),}, (strconv__Uint128){.lo = ((u64)(0x0755f6aa1ff59fb1U)),.hi = ((u64)(0x017dddf6b095ff0cU)),}, (strconv__Uint128){.lo = ((u64)(0x092b7454a7f3079eU)),.hi = ((u64)(0x01dd55745cbb7ecfU)),}, (strconv__Uint128){.lo = ((u64)(0x65bb28b4e8f7e4c3U)),.hi = ((u64)(0x012a5568b9f52f41U)),}, (strconv__Uint128){.lo = ((u64)(0xbf29f2e22335ddf3U)),.hi = ((u64)(0x0174eac2e8727b11U)),}, (strconv__Uint128){.lo = ((u64)(0x2ef46f9aac035570U)),.hi = ((u64)(0x01d22573a28f19d6U)),}, (strconv__Uint128){.lo = ((u64)(0xdd58c5c0ab821566U)),.hi = ((u64)(0x0123576845997025U)),}, (strconv__Uint128){.lo = ((u64)(0x54aef730d6629ac0U)),.hi = ((u64)(0x016c2d4256ffcc2fU)),}, (strconv__Uint128){.lo = ((u64)(0x29dab4fd0bfb4170U)),.hi = ((u64)(0x01c73892ecbfbf3bU)),}, (strconv__Uint128){.lo = ((u64)(0xfa28b11e277d08e6U)),.hi = ((u64)(0x011c835bd3f7d784U)),}, (strconv__Uint128){.lo = ((u64)(0x38b2dd65b15c4b1fU)),.hi = ((u64)(0x0163a432c8f5cd66U)),}, (strconv__Uint128){.lo = ((u64)(0xc6df94bf1db35de7U)),.hi = ((u64)(0x01bc8d3f7b3340bfU)),}, (strconv__Uint128){.lo = ((u64)(0xdc4bbcf772901ab0U)),.hi = ((u64)(0x0115d847ad000877U)),}, (strconv__Uint128){.lo = ((u64)(0xd35eac354f34215cU)),.hi = ((u64)(0x015b4e5998400a95U)),}, (strconv__Uint128){.lo = ((u64)(0x48365742a30129b4U)),.hi = ((u64)(0x01b221effe500d3bU)),}, (strconv__Uint128){.lo = ((u64)(0x0d21f689a5e0ba10U)),.hi = ((u64)(0x010f5535fef20845U)),}, (strconv__Uint128){.lo = ((u64)(0x506a742c0f58e894U)),.hi = ((u64)(0x01532a837eae8a56U)),}, (strconv__Uint128){.lo = ((u64)(0xe4851137132f22b9U)),.hi = ((u64)(0x01a7f5245e5a2cebU)),}, (strconv__Uint128){.lo = ((u64)(0x6ed32ac26bfd75b4U)),.hi = ((u64)(0x0108f936baf85c13U)),}, (strconv__Uint128){.lo = ((u64)(0x4a87f57306fcd321U)),.hi = ((u64)(0x014b378469b67318U)),}, (strconv__Uint128){.lo = ((u64)(0x5d29f2cfc8bc07e9U)),.hi = ((u64)(0x019e056584240fdeU)),}, (strconv__Uint128){.lo = ((u64)(0xfa3a37c1dd7584f1U)),.hi = ((u64)(0x0102c35f729689eaU)),}, (strconv__Uint128){.lo = ((u64)(0xb8c8c5b254d2e62eU)),.hi = ((u64)(0x014374374f3c2c65U)),}, (strconv__Uint128){.lo = ((u64)(0x26faf71eea079fb9U)),.hi = ((u64)(0x01945145230b377fU)),}, (strconv__Uint128){.lo = ((u64)(0xf0b9b4e6a48987a8U)),.hi = ((u64)(0x01f965966bce055eU)),}, (strconv__Uint128){.lo = ((u64)(0x5674111026d5f4c9U)),.hi = ((u64)(0x013bdf7e0360c35bU)),}, (strconv__Uint128){.lo = ((u64)(0x2c111554308b71fbU)),.hi = ((u64)(0x018ad75d8438f432U)),}, (strconv__Uint128){.lo = ((u64)(0xb7155aa93cae4e7aU)),.hi = ((u64)(0x01ed8d34e547313eU)),}, (strconv__Uint128){.lo = ((u64)(0x326d58a9c5ecf10cU)),.hi = ((u64)(0x013478410f4c7ec7U)),}, (strconv__Uint128){.lo = ((u64)(0xff08aed437682d4fU)),.hi = ((u64)(0x01819651531f9e78U)),}, (strconv__Uint128){.lo = ((u64)(0x3ecada89454238a3U)),.hi = ((u64)(0x01e1fbe5a7e78617U)),}, (strconv__Uint128){.lo = ((u64)(0x873ec895cb496366U)),.hi = ((u64)(0x012d3d6f88f0b3ceU)),}, (strconv__Uint128){.lo = ((u64)(0x290e7abb3e1bbc3fU)),.hi = ((u64)(0x01788ccb6b2ce0c2U)),}, (strconv__Uint128){.lo = ((u64)(0xb352196a0da2ab4fU)),.hi = ((u64)(0x01d6affe45f818f2U)),}, (strconv__Uint128){.lo = ((u64)(0xb0134fe24885ab11U)),.hi = ((u64)(0x01262dfeebbb0f97U)),}, (strconv__Uint128){.lo = ((u64)(0x9c1823dadaa715d6U)),.hi = ((u64)(0x016fb97ea6a9d37dU)),}, (strconv__Uint128){.lo = ((u64)(0x031e2cd19150db4bU)),.hi = ((u64)(0x01cba7de5054485dU)),}, (strconv__Uint128){.lo = ((u64)(0x21f2dc02fad2890fU)),.hi = ((u64)(0x011f48eaf234ad3aU)),}, (strconv__Uint128){.lo = ((u64)(0xaa6f9303b9872b53U)),.hi = ((u64)(0x01671b25aec1d888U)),}, (strconv__Uint128){.lo = ((u64)(0xd50b77c4a7e8f628U)),.hi = ((u64)(0x01c0e1ef1a724eaaU)),}, (strconv__Uint128){.lo = ((u64)(0xc5272adae8f199d9U)),.hi = ((u64)(0x01188d357087712aU)),}, (strconv__Uint128){.lo = ((u64)(0x7670f591a32e004fU)),.hi = ((u64)(0x015eb082cca94d75U)),}, (strconv__Uint128){.lo = ((u64)(0xd40d32f60bf98063U)),.hi = ((u64)(0x01b65ca37fd3a0d2U)),}, (strconv__Uint128){.lo = ((u64)(0xc4883fd9c77bf03eU)),.hi = ((u64)(0x0111f9e62fe44483U)),}, (strconv__Uint128){.lo = ((u64)(0xb5aa4fd0395aec4dU)),.hi = ((u64)(0x0156785fbbdd55a4U)),}, (strconv__Uint128){.lo = ((u64)(0xe314e3c447b1a760U)),.hi = ((u64)(0x01ac1677aad4ab0dU)),}, (strconv__Uint128){.lo = ((u64)(0xaded0e5aaccf089cU)),.hi = ((u64)(0x010b8e0acac4eae8U)),}, (strconv__Uint128){.lo = ((u64)(0xd96851f15802cac3U)),.hi = ((u64)(0x014e718d7d7625a2U)),}, (strconv__Uint128){.lo = ((u64)(0x8fc2666dae037d74U)),.hi = ((u64)(0x01a20df0dcd3af0bU)),}, (strconv__Uint128){.lo = ((u64)(0x39d980048cc22e68U)),.hi = ((u64)(0x010548b68a044d67U)),}, (strconv__Uint128){.lo = ((u64)(0x084fe005aff2ba03U)),.hi = ((u64)(0x01469ae42c8560c1U)),}, (strconv__Uint128){.lo = ((u64)(0x4a63d8071bef6883U)),.hi = ((u64)(0x0198419d37a6b8f1U)),}, (strconv__Uint128){.lo = ((u64)(0x9cfcce08e2eb42a4U)),.hi = ((u64)(0x01fe52048590672dU)),}, (strconv__Uint128){.lo = ((u64)(0x821e00c58dd309a7U)),.hi = ((u64)(0x013ef342d37a407cU)),}, (strconv__Uint128){.lo = ((u64)(0xa2a580f6f147cc10U)),.hi = ((u64)(0x018eb0138858d09bU)),}, (strconv__Uint128){.lo = ((u64)(0x8b4ee134ad99bf15U)),.hi = ((u64)(0x01f25c186a6f04c2U)),}, (strconv__Uint128){.lo = ((u64)(0x97114cc0ec80176dU)),.hi = ((u64)(0x0137798f428562f9U)),}, (strconv__Uint128){.lo = ((u64)(0xfcd59ff127a01d48U)),.hi = ((u64)(0x018557f31326bbb7U)),}, (strconv__Uint128){.lo = ((u64)(0xfc0b07ed7188249aU)),.hi = ((u64)(0x01e6adefd7f06aa5U)),}, (strconv__Uint128){.lo = ((u64)(0xbd86e4f466f516e0U)),.hi = ((u64)(0x01302cb5e6f642a7U)),}, (strconv__Uint128){.lo = ((u64)(0xace89e3180b25c98U)),.hi = ((u64)(0x017c37e360b3d351U)),}, (strconv__Uint128){.lo = ((u64)(0x1822c5bde0def3beU)),.hi = ((u64)(0x01db45dc38e0c826U)),}, (strconv__Uint128){.lo = ((u64)(0xcf15bb96ac8b5857U)),.hi = ((u64)(0x01290ba9a38c7d17U)),}, (strconv__Uint128){.lo = ((u64)(0xc2db2a7c57ae2e6dU)),.hi = ((u64)(0x01734e940c6f9c5dU)),}, (strconv__Uint128){.lo = ((u64)(0x3391f51b6d99ba08U)),.hi = ((u64)(0x01d022390f8b8375U)),}, (strconv__Uint128){.lo = ((u64)(0x403b393124801445U)),.hi = ((u64)(0x01221563a9b73229U)),}, (strconv__Uint128){.lo = ((u64)(0x904a077d6da01956U)),.hi = ((u64)(0x016a9abc9424feb3U)),}, (strconv__Uint128){.lo = ((u64)(0x745c895cc9081facU)),.hi = ((u64)(0x01c5416bb92e3e60U)),}, (strconv__Uint128){.lo = ((u64)(0x48b9d5d9fda513cbU)),.hi = ((u64)(0x011b48e353bce6fcU)),}, (strconv__Uint128){.lo = ((u64)(0x5ae84b507d0e58beU)),.hi = ((u64)(0x01621b1c28ac20bbU)),}, (strconv__Uint128){.lo = ((u64)(0x31a25e249c51eeeeU)),.hi = ((u64)(0x01baa1e332d728eaU)),}, (strconv__Uint128){.lo = ((u64)(0x5f057ad6e1b33554U)),.hi = ((u64)(0x0114a52dffc67992U)),}, (strconv__Uint128){.lo = ((u64)(0xf6c6d98c9a2002aaU)),.hi = ((u64)(0x0159ce797fb817f6U)),}, (strconv__Uint128){.lo = ((u64)(0xb4788fefc0a80354U)),.hi = ((u64)(0x01b04217dfa61df4U)),}, (strconv__Uint128){.lo = ((u64)(0xf0cb59f5d8690214U)),.hi = ((u64)(0x010e294eebc7d2b8U)),}, (strconv__Uint128){.lo = ((u64)(0x2cfe30734e83429aU)),.hi = ((u64)(0x0151b3a2a6b9c767U)),}, (strconv__Uint128){.lo = ((u64)(0xf83dbc9022241340U)),.hi = ((u64)(0x01a6208b50683940U)),}, (strconv__Uint128){.lo = ((u64)(0x9b2695da15568c08U)),.hi = ((u64)(0x0107d457124123c8U)),}, (strconv__Uint128){.lo = ((u64)(0xc1f03b509aac2f0aU)),.hi = ((u64)(0x0149c96cd6d16cbaU)),}, (strconv__Uint128){.lo = ((u64)(0x726c4a24c1573acdU)),.hi = ((u64)(0x019c3bc80c85c7e9U)),}, (strconv__Uint128){.lo = ((u64)(0xe783ae56f8d684c0U)),.hi = ((u64)(0x0101a55d07d39cf1U)),}, (strconv__Uint128){.lo = ((u64)(0x616499ecb70c25f0U)),.hi = ((u64)(0x01420eb449c8842eU)),}, (strconv__Uint128){.lo = ((u64)(0xf9bdc067e4cf2f6cU)),.hi = ((u64)(0x019292615c3aa539U)),}, (strconv__Uint128){.lo = ((u64)(0x782d3081de02fb47U)),.hi = ((u64)(0x01f736f9b3494e88U)),}, (strconv__Uint128){.lo = ((u64)(0x4b1c3e512ac1dd0cU)),.hi = ((u64)(0x013a825c100dd115U)),}, (strconv__Uint128){.lo = ((u64)(0x9de34de57572544fU)),.hi = ((u64)(0x018922f31411455aU)),}, (strconv__Uint128){.lo = ((u64)(0x455c215ed2cee963U)),.hi = ((u64)(0x01eb6bafd91596b1U)),}, (strconv__Uint128){.lo = ((u64)(0xcb5994db43c151deU)),.hi = ((u64)(0x0133234de7ad7e2eU)),}, (strconv__Uint128){.lo = ((u64)(0x7e2ffa1214b1a655U)),.hi = ((u64)(0x017fec216198ddbaU)),}, (strconv__Uint128){.lo = ((u64)(0x1dbbf89699de0febU)),.hi = ((u64)(0x01dfe729b9ff1529U)),}, (strconv__Uint128){.lo = ((u64)(0xb2957b5e202ac9f3U)),.hi = ((u64)(0x012bf07a143f6d39U)),}, (strconv__Uint128){.lo = ((u64)(0x1f3ada35a8357c6fU)),.hi = ((u64)(0x0176ec98994f4888U)),}, (strconv__Uint128){.lo = ((u64)(0x270990c31242db8bU)),.hi = ((u64)(0x01d4a7bebfa31aaaU)),}, (strconv__Uint128){.lo = ((u64)(0x5865fa79eb69c937U)),.hi = ((u64)(0x0124e8d737c5f0aaU)),}, (strconv__Uint128){.lo = ((u64)(0xee7f791866443b85U)),.hi = ((u64)(0x016e230d05b76cd4U)),}, (strconv__Uint128){.lo = ((u64)(0x2a1f575e7fd54a66U)),.hi = ((u64)(0x01c9abd04725480aU)),}, (strconv__Uint128){.lo = ((u64)(0x5a53969b0fe54e80U)),.hi = ((u64)(0x011e0b622c774d06U)),}, (strconv__Uint128){.lo = ((u64)(0xf0e87c41d3dea220U)),.hi = ((u64)(0x01658e3ab7952047U)),}, (strconv__Uint128){.lo = ((u64)(0xed229b5248d64aa8U)),.hi = ((u64)(0x01bef1c9657a6859U)),}, (strconv__Uint128){.lo = ((u64)(0x3435a1136d85eea9U)),.hi = ((u64)(0x0117571ddf6c8138U)),}, (strconv__Uint128){.lo = ((u64)(0x4143095848e76a53U)),.hi = ((u64)(0x015d2ce55747a186U)),}, (strconv__Uint128){.lo = ((u64)(0xd193cbae5b2144e8U)),.hi = ((u64)(0x01b4781ead1989e7U)),}, (strconv__Uint128){.lo = ((u64)(0xe2fc5f4cf8f4cb11U)),.hi = ((u64)(0x0110cb132c2ff630U)),}, (strconv__Uint128){.lo = ((u64)(0x1bbb77203731fdd5U)),.hi = ((u64)(0x0154fdd7f73bf3bdU)),}, (strconv__Uint128){.lo = ((u64)(0x62aa54e844fe7d4aU)),.hi = ((u64)(0x01aa3d4df50af0acU)),}, (strconv__Uint128){.lo = ((u64)(0xbdaa75112b1f0e4eU)),.hi = ((u64)(0x010a6650b926d66bU)),}, (strconv__Uint128){.lo = ((u64)(0xad15125575e6d1e2U)),.hi = ((u64)(0x014cffe4e7708c06U)),}, (strconv__Uint128){.lo = ((u64)(0x585a56ead360865bU)),.hi = ((u64)(0x01a03fde214caf08U)),}, (strconv__Uint128){.lo = ((u64)(0x37387652c41c53f8U)),.hi = ((u64)(0x010427ead4cfed65U)),}, (strconv__Uint128){.lo = ((u64)(0x850693e7752368f7U)),.hi = ((u64)(0x014531e58a03e8beU)),}, (strconv__Uint128){.lo = ((u64)(0x264838e1526c4334U)),.hi = ((u64)(0x01967e5eec84e2eeU)),}, (strconv__Uint128){.lo = ((u64)(0xafda4719a7075402U)),.hi = ((u64)(0x01fc1df6a7a61ba9U)),}, (strconv__Uint128){.lo = ((u64)(0x0de86c7008649481U)),.hi = ((u64)(0x013d92ba28c7d14aU)),}, (strconv__Uint128){.lo = ((u64)(0x9162878c0a7db9a1U)),.hi = ((u64)(0x018cf768b2f9c59cU)),}, (strconv__Uint128){.lo = ((u64)(0xb5bb296f0d1d280aU)),.hi = ((u64)(0x01f03542dfb83703U)),}, (strconv__Uint128){.lo = ((u64)(0x5194f9e568323906U)),.hi = ((u64)(0x01362149cbd32262U)),}, (strconv__Uint128){.lo = ((u64)(0xe5fa385ec23ec747U)),.hi = ((u64)(0x0183a99c3ec7eafaU)),}, (strconv__Uint128){.lo = ((u64)(0x9f78c67672ce7919U)),.hi = ((u64)(0x01e494034e79e5b9U)),}, (strconv__Uint128){.lo = ((u64)(0x03ab7c0a07c10bb0U)),.hi = ((u64)(0x012edc82110c2f94U)),}, (strconv__Uint128){.lo = ((u64)(0x04965b0c89b14e9cU)),.hi = ((u64)(0x017a93a2954f3b79U)),}, (strconv__Uint128){.lo = ((u64)(0x45bbf1cfac1da243U)),.hi = ((u64)(0x01d9388b3aa30a57U)),}, (strconv__Uint128){.lo = ((u64)(0x8b957721cb92856aU)),.hi = ((u64)(0x0127c35704a5e676U)),}, (strconv__Uint128){.lo = ((u64)(0x2e7ad4ea3e7726c4U)),.hi = ((u64)(0x0171b42cc5cf6014U)),}, (strconv__Uint128){.lo = ((u64)(0x3a198a24ce14f075U)),.hi = ((u64)(0x01ce2137f7433819U)),}, (strconv__Uint128){.lo = ((u64)(0xc44ff65700cd1649U)),.hi = ((u64)(0x0120d4c2fa8a030fU)),}, (strconv__Uint128){.lo = ((u64)(0xb563f3ecc1005bdbU)),.hi = ((u64)(0x016909f3b92c83d3U)),}, (strconv__Uint128){.lo = ((u64)(0xa2bcf0e7f14072d2U)),.hi = ((u64)(0x01c34c70a777a4c8U)),}, (strconv__Uint128){.lo = ((u64)(0x65b61690f6c847c3U)),.hi = ((u64)(0x011a0fc668aac6fdU)),}, (strconv__Uint128){.lo = ((u64)(0xbf239c35347a59b4U)),.hi = ((u64)(0x016093b802d578bcU)),}, (strconv__Uint128){.lo = ((u64)(0xeeec83428198f021U)),.hi = ((u64)(0x01b8b8a6038ad6ebU)),}, (strconv__Uint128){.lo = ((u64)(0x7553d20990ff9615U)),.hi = ((u64)(0x01137367c236c653U)),}, (strconv__Uint128){.lo = ((u64)(0x52a8c68bf53f7b9aU)),.hi = ((u64)(0x01585041b2c477e8U)),}, (strconv__Uint128){.lo = ((u64)(0x6752f82ef28f5a81U)),.hi = ((u64)(0x01ae64521f7595e2U)),}, (strconv__Uint128){.lo = ((u64)(0x8093db1d57999890U)),.hi = ((u64)(0x010cfeb353a97dadU)),}, (strconv__Uint128){.lo = ((u64)(0xe0b8d1e4ad7ffeb4U)),.hi = ((u64)(0x01503e602893dd18U)),}, (strconv__Uint128){.lo = ((u64)(0x18e7065dd8dffe62U)),.hi = ((u64)(0x01a44df832b8d45fU)),}, (strconv__Uint128){.lo = ((u64)(0x6f9063faa78bfefdU)),.hi = ((u64)(0x0106b0bb1fb384bbU)),}, (strconv__Uint128){.lo = ((u64)(0x4b747cf9516efebcU)),.hi = ((u64)(0x01485ce9e7a065eaU)),}, (strconv__Uint128){.lo = ((u64)(0xde519c37a5cabe6bU)),.hi = ((u64)(0x019a742461887f64U)),}, (strconv__Uint128){.lo = ((u64)(0x0af301a2c79eb703U)),.hi = ((u64)(0x01008896bcf54f9fU)),}, (strconv__Uint128){.lo = ((u64)(0xcdafc20b798664c4U)),.hi = ((u64)(0x0140aabc6c32a386U)),}, (strconv__Uint128){.lo = ((u64)(0x811bb28e57e7fdf5U)),.hi = ((u64)(0x0190d56b873f4c68U)),}, (strconv__Uint128){.lo = ((u64)(0xa1629f31ede1fd72U)),.hi = ((u64)(0x01f50ac6690f1f82U)),}, (strconv__Uint128){.lo = ((u64)(0xa4dda37f34ad3e67U)),.hi = ((u64)(0x013926bc01a973b1U)),}, (strconv__Uint128){.lo = ((u64)(0x0e150c5f01d88e01U)),.hi = ((u64)(0x0187706b0213d09eU)),}, (strconv__Uint128){.lo = ((u64)(0x919a4f76c24eb181U)),.hi = ((u64)(0x01e94c85c298c4c5U)),}, (strconv__Uint128){.lo = ((u64)(0x7b0071aa39712ef1U)),.hi = ((u64)(0x0131cfd3999f7afbU)),}, (strconv__Uint128){.lo = ((u64)(0x59c08e14c7cd7aadU)),.hi = ((u64)(0x017e43c8800759baU)),}, (strconv__Uint128){.lo = ((u64)(0xf030b199f9c0d958U)),.hi = ((u64)(0x01ddd4baa0093028U)),}, (strconv__Uint128){.lo = ((u64)(0x961e6f003c1887d7U)),.hi = ((u64)(0x012aa4f4a405be19U)),}, (strconv__Uint128){.lo = ((u64)(0xfba60ac04b1ea9cdU)),.hi = ((u64)(0x01754e31cd072d9fU)),}, (strconv__Uint128){.lo = ((u64)(0xfa8f8d705de65440U)),.hi = ((u64)(0x01d2a1be4048f907U)),}, (strconv__Uint128){.lo = ((u64)(0xfc99b8663aaff4a8U)),.hi = ((u64)(0x0123a516e82d9ba4U)),}, (strconv__Uint128){.lo = ((u64)(0x3bc0267fc95bf1d2U)),.hi = ((u64)(0x016c8e5ca239028eU)),}, (strconv__Uint128){.lo = ((u64)(0xcab0301fbbb2ee47U)),.hi = ((u64)(0x01c7b1f3cac74331U)),}, (strconv__Uint128){.lo = ((u64)(0x1eae1e13d54fd4ecU)),.hi = ((u64)(0x011ccf385ebc89ffU)),}, (strconv__Uint128){.lo = ((u64)(0xe659a598caa3ca27U)),.hi = ((u64)(0x01640306766bac7eU)),}, (strconv__Uint128){.lo = ((u64)(0x9ff00efefd4cbcb1U)),.hi = ((u64)(0x01bd03c81406979eU)),}, (strconv__Uint128){.lo = ((u64)(0x23f6095f5e4ff5efU)),.hi = ((u64)(0x0116225d0c841ec3U)),}, (strconv__Uint128){.lo = ((u64)(0xecf38bb735e3f36aU)),.hi = ((u64)(0x015baaf44fa52673U)),}, (strconv__Uint128){.lo = ((u64)(0xe8306ea5035cf045U)),.hi = ((u64)(0x01b295b1638e7010U)),}, (strconv__Uint128){.lo = ((u64)(0x911e4527221a162bU)),.hi = ((u64)(0x010f9d8ede39060aU)),}, (strconv__Uint128){.lo = ((u64)(0x3565d670eaa09bb6U)),.hi = ((u64)(0x015384f295c7478dU)),}, (strconv__Uint128){.lo = ((u64)(0x82bf4c0d2548c2a3U)),.hi = ((u64)(0x01a8662f3b391970U)),}, (strconv__Uint128){.lo = ((u64)(0x51b78f88374d79a6U)),.hi = ((u64)(0x01093fdd8503afe6U)),}, (strconv__Uint128){.lo = ((u64)(0xe625736a4520d810U)),.hi = ((u64)(0x014b8fd4e6449bdfU)),}, (strconv__Uint128){.lo = ((u64)(0xdfaed044d6690e14U)),.hi = ((u64)(0x019e73ca1fd5c2d7U)),}, (strconv__Uint128){.lo = ((u64)(0xebcd422b0601a8ccU)),.hi = ((u64)(0x0103085e53e599c6U)),}, (strconv__Uint128){.lo = ((u64)(0xa6c092b5c78212ffU)),.hi = ((u64)(0x0143ca75e8df0038U)),}, (strconv__Uint128){.lo = ((u64)(0xd070b763396297bfU)),.hi = ((u64)(0x0194bd136316c046U)),}, (strconv__Uint128){.lo = ((u64)(0x848ce53c07bb3dafU)),.hi = ((u64)(0x01f9ec583bdc7058U)),}, (strconv__Uint128){.lo = ((u64)(0x52d80f4584d5068dU)),.hi = ((u64)(0x013c33b72569c637U)),}, (strconv__Uint128){.lo = ((u64)(0x278e1316e60a4831U)),.hi = ((u64)(0x018b40a4eec437c5U)),}}));
	_const_strconv__pow5_inv_split_64 = new_array_from_c_array(292, 292, sizeof(strconv__Uint128), _MOV((strconv__Uint128[292]){
		(strconv__Uint128){.lo = ((u64)(0x0000000000000001U)),.hi = ((u64)(0x0400000000000000U)),}, (strconv__Uint128){.lo = ((u64)(0x3333333333333334U)),.hi = ((u64)(0x0333333333333333U)),}, (strconv__Uint128){.lo = ((u64)(0x28f5c28f5c28f5c3U)),.hi = ((u64)(0x028f5c28f5c28f5cU)),}, (strconv__Uint128){.lo = ((u64)(0xed916872b020c49cU)),.hi = ((u64)(0x020c49ba5e353f7cU)),}, (strconv__Uint128){.lo = ((u64)(0xaf4f0d844d013a93U)),.hi = ((u64)(0x0346dc5d63886594U)),}, (strconv__Uint128){.lo = ((u64)(0x8c3f3e0370cdc876U)),.hi = ((u64)(0x029f16b11c6d1e10U)),}, (strconv__Uint128){.lo = ((u64)(0xd698fe69270b06c5U)),.hi = ((u64)(0x0218def416bdb1a6U)),}, (strconv__Uint128){.lo = ((u64)(0xf0f4ca41d811a46eU)),.hi = ((u64)(0x035afe535795e90aU)),}, (strconv__Uint128){.lo = ((u64)(0xf3f70834acdae9f1U)),.hi = ((u64)(0x02af31dc4611873bU)),}, (strconv__Uint128){.lo = ((u64)(0x5cc5a02a23e254c1U)),.hi = ((u64)(0x0225c17d04dad296U)),}, (strconv__Uint128){.lo = ((u64)(0xfad5cd10396a2135U)),.hi = ((u64)(0x036f9bfb3af7b756U)),}, (strconv__Uint128){.lo = ((u64)(0xfbde3da69454e75eU)),.hi = ((u64)(0x02bfaffc2f2c92abU)),}, (strconv__Uint128){.lo = ((u64)(0x2fe4fe1edd10b918U)),.hi = ((u64)(0x0232f33025bd4223U)),}, (strconv__Uint128){.lo = ((u64)(0x4ca19697c81ac1bfU)),.hi = ((u64)(0x0384b84d092ed038U)),}, (strconv__Uint128){.lo = ((u64)(0x3d4e1213067bce33U)),.hi = ((u64)(0x02d09370d4257360U)),}, (strconv__Uint128){.lo = ((u64)(0x643e74dc052fd829U)),.hi = ((u64)(0x024075f3dceac2b3U)),}, (strconv__Uint128){.lo = ((u64)(0x6d30baf9a1e626a7U)),.hi = ((u64)(0x039a5652fb113785U)),}, (strconv__Uint128){.lo = ((u64)(0x2426fbfae7eb5220U)),.hi = ((u64)(0x02e1dea8c8da92d1U)),}, (strconv__Uint128){.lo = ((u64)(0x1cebfcc8b9890e80U)),.hi = ((u64)(0x024e4bba3a487574U)),}, (strconv__Uint128){.lo = ((u64)(0x94acc7a78f41b0ccU)),.hi = ((u64)(0x03b07929f6da5586U)),}, (strconv__Uint128){.lo = ((u64)(0xaa23d2ec729af3d7U)),.hi = ((u64)(0x02f394219248446bU)),}, (strconv__Uint128){.lo = ((u64)(0xbb4fdbf05baf2979U)),.hi = ((u64)(0x025c768141d369efU)),}, (strconv__Uint128){.lo = ((u64)(0xc54c931a2c4b758dU)),.hi = ((u64)(0x03c7240202ebdcb2U)),}, (strconv__Uint128){.lo = ((u64)(0x9dd6dc14f03c5e0bU)),.hi = ((u64)(0x0305b66802564a28U)),}, (strconv__Uint128){.lo = ((u64)(0x4b1249aa59c9e4d6U)),.hi = ((u64)(0x026af8533511d4edU)),}, (strconv__Uint128){.lo = ((u64)(0x44ea0f76f60fd489U)),.hi = ((u64)(0x03de5a1ebb4fbb15U)),}, (strconv__Uint128){.lo = ((u64)(0x6a54d92bf80caa07U)),.hi = ((u64)(0x0318481895d96277U)),}, (strconv__Uint128){.lo = ((u64)(0x21dd7a89933d54d2U)),.hi = ((u64)(0x0279d346de4781f9U)),}, (strconv__Uint128){.lo = ((u64)(0x362f2a75b8622150U)),.hi = ((u64)(0x03f61ed7ca0c0328U)),}, (strconv__Uint128){.lo = ((u64)(0xf825bb91604e810dU)),.hi = ((u64)(0x032b4bdfd4d668ecU)),}, (strconv__Uint128){.lo = ((u64)(0xc684960de6a5340bU)),.hi = ((u64)(0x0289097fdd7853f0U)),}, (strconv__Uint128){.lo = ((u64)(0xd203ab3e521dc33cU)),.hi = ((u64)(0x02073accb12d0ff3U)),}, (strconv__Uint128){.lo = ((u64)(0xe99f7863b696052cU)),.hi = ((u64)(0x033ec47ab514e652U)),}, (strconv__Uint128){.lo = ((u64)(0x87b2c6b62bab3757U)),.hi = ((u64)(0x02989d2ef743eb75U)),}, (strconv__Uint128){.lo = ((u64)(0xd2f56bc4efbc2c45U)),.hi = ((u64)(0x0213b0f25f69892aU)),}, (strconv__Uint128){.lo = ((u64)(0x1e55793b192d13a2U)),.hi = ((u64)(0x0352b4b6ff0f41deU)),}, (strconv__Uint128){.lo = ((u64)(0x4b77942f475742e8U)),.hi = ((u64)(0x02a8909265a5ce4bU)),}, (strconv__Uint128){.lo = ((u64)(0xd5f9435905df68baU)),.hi = ((u64)(0x022073a8515171d5U)),}, (strconv__Uint128){.lo = ((u64)(0x565b9ef4d6324129U)),.hi = ((u64)(0x03671f73b54f1c89U)),}, (strconv__Uint128){.lo = ((u64)(0xdeafb25d78283421U)),.hi = ((u64)(0x02b8e5f62aa5b06dU)),}, (strconv__Uint128){.lo = ((u64)(0x188c8eb12cecf681U)),.hi = ((u64)(0x022d84c4eeeaf38bU)),}, (strconv__Uint128){.lo = ((u64)(0x8dadb11b7b14bd9bU)),.hi = ((u64)(0x037c07a17e44b8deU)),}, (strconv__Uint128){.lo = ((u64)(0x7157c0e2c8dd647cU)),.hi = ((u64)(0x02c99fb46503c718U)),}, (strconv__Uint128){.lo = ((u64)(0x8ddfcd823a4ab6caU)),.hi = ((u64)(0x023ae629ea696c13U)),}, (strconv__Uint128){.lo = ((u64)(0x1632e269f6ddf142U)),.hi = ((u64)(0x0391704310a8acecU)),}, (strconv__Uint128){.lo = ((u64)(0x44f581ee5f17f435U)),.hi = ((u64)(0x02dac035a6ed5723U)),}, (strconv__Uint128){.lo = ((u64)(0x372ace584c1329c4U)),.hi = ((u64)(0x024899c4858aac1cU)),}, (strconv__Uint128){.lo = ((u64)(0xbeaae3c079b842d3U)),.hi = ((u64)(0x03a75c6da27779c6U)),}, (strconv__Uint128){.lo = ((u64)(0x6555830061603576U)),.hi = ((u64)(0x02ec49f14ec5fb05U)),}, (strconv__Uint128){.lo = ((u64)(0xb7779c004de6912bU)),.hi = ((u64)(0x0256a18dd89e626aU)),}, (strconv__Uint128){.lo = ((u64)(0xf258f99a163db512U)),.hi = ((u64)(0x03bdcf495a9703ddU)),}, (strconv__Uint128){.lo = ((u64)(0x5b7a614811caf741U)),.hi = ((u64)(0x02fe3f6de212697eU)),}, (strconv__Uint128){.lo = ((u64)(0xaf951aa00e3bf901U)),.hi = ((u64)(0x0264ff8b1b41edfeU)),}, (strconv__Uint128){.lo = ((u64)(0x7f54f7667d2cc19bU)),.hi = ((u64)(0x03d4cc11c5364997U)),}, (strconv__Uint128){.lo = ((u64)(0x32aa5f8530f09ae3U)),.hi = ((u64)(0x0310a3416a91d479U)),}, (strconv__Uint128){.lo = ((u64)(0xf55519375a5a1582U)),.hi = ((u64)(0x0273b5cdeedb1060U)),}, (strconv__Uint128){.lo = ((u64)(0xbbbb5b8bc3c3559dU)),.hi = ((u64)(0x03ec56164af81a34U)),}, (strconv__Uint128){.lo = ((u64)(0x2fc916096969114aU)),.hi = ((u64)(0x03237811d593482aU)),}, (strconv__Uint128){.lo = ((u64)(0x596dab3ababa743cU)),.hi = ((u64)(0x0282c674aadc39bbU)),}, (strconv__Uint128){.lo = ((u64)(0x478aef622efb9030U)),.hi = ((u64)(0x0202385d557cfafcU)),}, (strconv__Uint128){.lo = ((u64)(0xd8de4bd04b2c19e6U)),.hi = ((u64)(0x0336c0955594c4c6U)),}, (strconv__Uint128){.lo = ((u64)(0xad7ea30d08f014b8U)),.hi = ((u64)(0x029233aaaadd6a38U)),}, (strconv__Uint128){.lo = ((u64)(0x24654f3da0c01093U)),.hi = ((u64)(0x020e8fbbbbe454faU)),}, (strconv__Uint128){.lo = ((u64)(0x3a3bb1fc346680ebU)),.hi = ((u64)(0x034a7f92c63a2190U)),}, (strconv__Uint128){.lo = ((u64)(0x94fc8e635d1ecd89U)),.hi = ((u64)(0x02a1ffa89e94e7a6U)),}, (strconv__Uint128){.lo = ((u64)(0xaa63a51c4a7f0ad4U)),.hi = ((u64)(0x021b32ed4baa52ebU)),}, (strconv__Uint128){.lo = ((u64)(0xdd6c3b607731aaedU)),.hi = ((u64)(0x035eb7e212aa1e45U)),}, (strconv__Uint128){.lo = ((u64)(0x1789c919f8f488bdU)),.hi = ((u64)(0x02b22cb4dbbb4b6bU)),}, (strconv__Uint128){.lo = ((u64)(0xac6e3a7b2d906d64U)),.hi = ((u64)(0x022823c3e2fc3c55U)),}, (strconv__Uint128){.lo = ((u64)(0x13e390c515b3e23aU)),.hi = ((u64)(0x03736c6c9e606089U)),}, (strconv__Uint128){.lo = ((u64)(0xdcb60d6a77c31b62U)),.hi = ((u64)(0x02c2bd23b1e6b3a0U)),}, (strconv__Uint128){.lo = ((u64)(0x7d5e7121f968e2b5U)),.hi = ((u64)(0x0235641c8e52294dU)),}, (strconv__Uint128){.lo = ((u64)(0xc8971b698f0e3787U)),.hi = ((u64)(0x0388a02db0837548U)),}, (strconv__Uint128){.lo = ((u64)(0xa078e2bad8d82c6cU)),.hi = ((u64)(0x02d3b357c0692aa0U)),}, (strconv__Uint128){.lo = ((u64)(0xe6c71bc8ad79bd24U)),.hi = ((u64)(0x0242f5dfcd20eee6U)),}, (strconv__Uint128){.lo = ((u64)(0x0ad82c7448c2c839U)),.hi = ((u64)(0x039e5632e1ce4b0bU)),}, (strconv__Uint128){.lo = ((u64)(0x3be023903a356cfaU)),.hi = ((u64)(0x02e511c24e3ea26fU)),}, (strconv__Uint128){.lo = ((u64)(0x2fe682d9c82abd95U)),.hi = ((u64)(0x0250db01d8321b8cU)),}, (strconv__Uint128){.lo = ((u64)(0x4ca4048fa6aac8eeU)),.hi = ((u64)(0x03b4919c8d1cf8e0U)),}, (strconv__Uint128){.lo = ((u64)(0x3d5003a61eef0725U)),.hi = ((u64)(0x02f6dae3a4172d80U)),}, (strconv__Uint128){.lo = ((u64)(0x9773361e7f259f51U)),.hi = ((u64)(0x025f1582e9ac2466U)),}, (strconv__Uint128){.lo = ((u64)(0x8beb89ca6508fee8U)),.hi = ((u64)(0x03cb559e42ad070aU)),}, (strconv__Uint128){.lo = ((u64)(0x6fefa16eb73a6586U)),.hi = ((u64)(0x0309114b688a6c08U)),}, (strconv__Uint128){.lo = ((u64)(0xf3261abef8fb846bU)),.hi = ((u64)(0x026da76f86d52339U)),}, (strconv__Uint128){.lo = ((u64)(0x51d691318e5f3a45U)),.hi = ((u64)(0x03e2a57f3e21d1f6U)),}, (strconv__Uint128){.lo = ((u64)(0x0e4540f471e5c837U)),.hi = ((u64)(0x031bb798fe8174c5U)),}, (strconv__Uint128){.lo = ((u64)(0xd8376729f4b7d360U)),.hi = ((u64)(0x027c92e0cb9ac3d0U)),}, (strconv__Uint128){.lo = ((u64)(0xf38bd84321261effU)),.hi = ((u64)(0x03fa849adf5e061aU)),}, (strconv__Uint128){.lo = ((u64)(0x293cad0280eb4bffU)),.hi = ((u64)(0x032ed07be5e4d1afU)),}, (strconv__Uint128){.lo = ((u64)(0xedca240200bc3cccU)),.hi = ((u64)(0x028bd9fcb7ea4158U)),}, (strconv__Uint128){.lo = ((u64)(0xbe3b50019a3030a4U)),.hi = ((u64)(0x02097b309321cde0U)),}, (strconv__Uint128){.lo = ((u64)(0xc9f88002904d1a9fU)),.hi = ((u64)(0x03425eb41e9c7c9aU)),}, (strconv__Uint128){.lo = ((u64)(0x3b2d3335403daee6U)),.hi = ((u64)(0x029b7ef67ee396e2U)),}, (strconv__Uint128){.lo = ((u64)(0x95bdc291003158b8U)),.hi = ((u64)(0x0215ff2b98b6124eU)),}, (strconv__Uint128){.lo = ((u64)(0x892f9db4cd1bc126U)),.hi = ((u64)(0x035665128df01d4aU)),}, (strconv__Uint128){.lo = ((u64)(0x07594af70a7c9a85U)),.hi = ((u64)(0x02ab840ed7f34aa2U)),}, (strconv__Uint128){.lo = ((u64)(0x6c476f2c0863aed1U)),.hi = ((u64)(0x0222d00bdff5d54eU)),}, (strconv__Uint128){.lo = ((u64)(0x13a57eacda3917b4U)),.hi = ((u64)(0x036ae67966562217U)),}, (strconv__Uint128){.lo = ((u64)(0x0fb7988a482dac90U)),.hi = ((u64)(0x02bbeb9451de81acU)),}, (strconv__Uint128){.lo = ((u64)(0xd95fad3b6cf156daU)),.hi = ((u64)(0x022fefa9db1867bcU)),}, (strconv__Uint128){.lo = ((u64)(0xf565e1f8ae4ef15cU)),.hi = ((u64)(0x037fe5dc91c0a5faU)),}, (strconv__Uint128){.lo = ((u64)(0x911e4e608b725ab0U)),.hi = ((u64)(0x02ccb7e3a7cd5195U)),}, (strconv__Uint128){.lo = ((u64)(0xda7ea51a0928488dU)),.hi = ((u64)(0x023d5fe9530aa7aaU)),}, (strconv__Uint128){.lo = ((u64)(0xf7310829a8407415U)),.hi = ((u64)(0x039566421e7772aaU)),}, (strconv__Uint128){.lo = ((u64)(0x2c2739baed005cdeU)),.hi = ((u64)(0x02ddeb68185f8eefU)),}, (strconv__Uint128){.lo = ((u64)(0xbcec2e2f24004a4bU)),.hi = ((u64)(0x024b22b9ad193f25U)),}, (strconv__Uint128){.lo = ((u64)(0x94ad16b1d333aa11U)),.hi = ((u64)(0x03ab6ac2ae8ecb6fU)),}, (strconv__Uint128){.lo = ((u64)(0xaa241227dc2954dbU)),.hi = ((u64)(0x02ef889bbed8a2bfU)),}, (strconv__Uint128){.lo = ((u64)(0x54e9a81fe35443e2U)),.hi = ((u64)(0x02593a163246e899U)),}, (strconv__Uint128){.lo = ((u64)(0x2175d9cc9eed396aU)),.hi = ((u64)(0x03c1f689ea0b0dc2U)),}, (strconv__Uint128){.lo = ((u64)(0xe7917b0a18bdc788U)),.hi = ((u64)(0x03019207ee6f3e34U)),}, (strconv__Uint128){.lo = ((u64)(0xb9412f3b46fe393aU)),.hi = ((u64)(0x0267a8065858fe90U)),}, (strconv__Uint128){.lo = ((u64)(0xf535185ed7fd285cU)),.hi = ((u64)(0x03d90cd6f3c1974dU)),}, (strconv__Uint128){.lo = ((u64)(0xc42a79e57997537dU)),.hi = ((u64)(0x03140a458fce12a4U)),}, (strconv__Uint128){.lo = ((u64)(0x03552e512e12a931U)),.hi = ((u64)(0x02766e9e0ca4dbb7U)),}, (strconv__Uint128){.lo = ((u64)(0x9eeeb081e3510eb4U)),.hi = ((u64)(0x03f0b0fce107c5f1U)),}, (strconv__Uint128){.lo = ((u64)(0x4bf226ce4f740bc3U)),.hi = ((u64)(0x0326f3fd80d304c1U)),}, (strconv__Uint128){.lo = ((u64)(0xa3281f0b72c33c9cU)),.hi = ((u64)(0x02858ffe00a8d09aU)),}, (strconv__Uint128){.lo = ((u64)(0x1c2018d5f568fd4aU)),.hi = ((u64)(0x020473319a20a6e2U)),}, (strconv__Uint128){.lo = ((u64)(0xf9ccf48988a7fba9U)),.hi = ((u64)(0x033a51e8f69aa49cU)),}, (strconv__Uint128){.lo = ((u64)(0xfb0a5d3ad3b99621U)),.hi = ((u64)(0x02950e53f87bb6e3U)),}, (strconv__Uint128){.lo = ((u64)(0x2f3b7dc8a96144e7U)),.hi = ((u64)(0x0210d8432d2fc583U)),}, (strconv__Uint128){.lo = ((u64)(0xe52bfc7442353b0cU)),.hi = ((u64)(0x034e26d1e1e608d1U)),}, (strconv__Uint128){.lo = ((u64)(0xb756639034f76270U)),.hi = ((u64)(0x02a4ebdb1b1e6d74U)),}, (strconv__Uint128){.lo = ((u64)(0x2c451c735d92b526U)),.hi = ((u64)(0x021d897c15b1f12aU)),}, (strconv__Uint128){.lo = ((u64)(0x13a1c71efc1deea3U)),.hi = ((u64)(0x0362759355e981ddU)),}, (strconv__Uint128){.lo = ((u64)(0x761b05b2634b2550U)),.hi = ((u64)(0x02b52adc44bace4aU)),}, (strconv__Uint128){.lo = ((u64)(0x91af37c1e908eaa6U)),.hi = ((u64)(0x022a88b036fbd83bU)),}, (strconv__Uint128){.lo = ((u64)(0x82b1f2cfdb417770U)),.hi = ((u64)(0x03774119f192f392U)),}, (strconv__Uint128){.lo = ((u64)(0xcef4c23fe29ac5f3U)),.hi = ((u64)(0x02c5cdae5adbf60eU)),}, (strconv__Uint128){.lo = ((u64)(0x3f2a34ffe87bd190U)),.hi = ((u64)(0x0237d7beaf165e72U)),}, (strconv__Uint128){.lo = ((u64)(0x984387ffda5fb5b2U)),.hi = ((u64)(0x038c8c644b56fd83U)),}, (strconv__Uint128){.lo = ((u64)(0xe0360666484c915bU)),.hi = ((u64)(0x02d6d6b6a2abfe02U)),}, (strconv__Uint128){.lo = ((u64)(0x802b3851d3707449U)),.hi = ((u64)(0x024578921bbccb35U)),}, (strconv__Uint128){.lo = ((u64)(0x99dec082ebe72075U)),.hi = ((u64)(0x03a25a835f947855U)),}, (strconv__Uint128){.lo = ((u64)(0xae4bcd358985b391U)),.hi = ((u64)(0x02e8486919439377U)),}, (strconv__Uint128){.lo = ((u64)(0xbea30a913ad15c74U)),.hi = ((u64)(0x02536d20e102dc5fU)),}, (strconv__Uint128){.lo = ((u64)(0xfdd1aa81f7b560b9U)),.hi = ((u64)(0x03b8ae9b019e2d65U)),}, (strconv__Uint128){.lo = ((u64)(0x97daeece5fc44d61U)),.hi = ((u64)(0x02fa2548ce182451U)),}, (strconv__Uint128){.lo = ((u64)(0xdfe258a51969d781U)),.hi = ((u64)(0x0261b76d71ace9daU)),}, (strconv__Uint128){.lo = ((u64)(0x996a276e8f0fbf34U)),.hi = ((u64)(0x03cf8be24f7b0fc4U)),}, (strconv__Uint128){.lo = ((u64)(0xe121b9253f3fcc2aU)),.hi = ((u64)(0x030c6fe83f95a636U)),}, (strconv__Uint128){.lo = ((u64)(0xb41afa8432997022U)),.hi = ((u64)(0x02705986994484f8U)),}, (strconv__Uint128){.lo = ((u64)(0xecf7f739ea8f19cfU)),.hi = ((u64)(0x03e6f5a4286da18dU)),}, (strconv__Uint128){.lo = ((u64)(0x23f99294bba5ae40U)),.hi = ((u64)(0x031f2ae9b9f14e0bU)),}, (strconv__Uint128){.lo = ((u64)(0x4ffadbaa2fb7be99U)),.hi = ((u64)(0x027f5587c7f43e6fU)),}, (strconv__Uint128){.lo = ((u64)(0x7ff7c5dd1925fdc2U)),.hi = ((u64)(0x03feef3fa6539718U)),}, (strconv__Uint128){.lo = ((u64)(0xccc637e4141e649bU)),.hi = ((u64)(0x033258ffb842df46U)),}, (strconv__Uint128){.lo = ((u64)(0xd704f983434b83afU)),.hi = ((u64)(0x028ead9960357f6bU)),}, (strconv__Uint128){.lo = ((u64)(0x126a6135cf6f9c8cU)),.hi = ((u64)(0x020bbe144cf79923U)),}, (strconv__Uint128){.lo = ((u64)(0x83dd685618b29414U)),.hi = ((u64)(0x0345fced47f28e9eU)),}, (strconv__Uint128){.lo = ((u64)(0x9cb12044e08edcddU)),.hi = ((u64)(0x029e63f1065ba54bU)),}, (strconv__Uint128){.lo = ((u64)(0x16f419d0b3a57d7dU)),.hi = ((u64)(0x02184ff405161dd6U)),}, (strconv__Uint128){.lo = ((u64)(0x8b20294dec3bfbfbU)),.hi = ((u64)(0x035a19866e89c956U)),}, (strconv__Uint128){.lo = ((u64)(0x3c19baa4bcfcc996U)),.hi = ((u64)(0x02ae7ad1f207d445U)),}, (strconv__Uint128){.lo = ((u64)(0xc9ae2eea30ca3adfU)),.hi = ((u64)(0x02252f0e5b39769dU)),}, (strconv__Uint128){.lo = ((u64)(0x0f7d17dd1add2afdU)),.hi = ((u64)(0x036eb1b091f58a96U)),}, (strconv__Uint128){.lo = ((u64)(0x3f97464a7be42264U)),.hi = ((u64)(0x02bef48d41913babU)),}, (strconv__Uint128){.lo = ((u64)(0xcc790508631ce850U)),.hi = ((u64)(0x02325d3dce0dc955U)),}, (strconv__Uint128){.lo = ((u64)(0xe0c1a1a704fb0d4dU)),.hi = ((u64)(0x0383c862e3494222U)),}, (strconv__Uint128){.lo = ((u64)(0x4d67b4859d95a43eU)),.hi = ((u64)(0x02cfd3824f6dce82U)),}, (strconv__Uint128){.lo = ((u64)(0x711fc39e17aae9cbU)),.hi = ((u64)(0x023fdc683f8b0b9bU)),}, (strconv__Uint128){.lo = ((u64)(0xe832d2968c44a945U)),.hi = ((u64)(0x039960a6cc11ac2bU)),}, (strconv__Uint128){.lo = ((u64)(0xecf575453d03ba9eU)),.hi = ((u64)(0x02e11a1f09a7bcefU)),}, (strconv__Uint128){.lo = ((u64)(0x572ac4376402fbb1U)),.hi = ((u64)(0x024dae7f3aec9726U)),}, (strconv__Uint128){.lo = ((u64)(0x58446d256cd192b5U)),.hi = ((u64)(0x03af7d985e47583dU)),}, (strconv__Uint128){.lo = ((u64)(0x79d0575123dadbc4U)),.hi = ((u64)(0x02f2cae04b6c4697U)),}, (strconv__Uint128){.lo = ((u64)(0x94a6ac40e97be303U)),.hi = ((u64)(0x025bd5803c569edfU)),}, (strconv__Uint128){.lo = ((u64)(0x8771139b0f2c9e6cU)),.hi = ((u64)(0x03c62266c6f0fe32U)),}, (strconv__Uint128){.lo = ((u64)(0x9f8da948d8f07ebdU)),.hi = ((u64)(0x0304e85238c0cb5bU)),}, (strconv__Uint128){.lo = ((u64)(0xe60aedd3e0c06564U)),.hi = ((u64)(0x026a5374fa33d5e2U)),}, (strconv__Uint128){.lo = ((u64)(0xa344afb9679a3bd2U)),.hi = ((u64)(0x03dd5254c3862304U)),}, (strconv__Uint128){.lo = ((u64)(0xe903bfc78614fca8U)),.hi = ((u64)(0x031775109c6b4f36U)),}, (strconv__Uint128){.lo = ((u64)(0xba6966393810ca20U)),.hi = ((u64)(0x02792a73b055d8f8U)),}, (strconv__Uint128){.lo = ((u64)(0x2a423d2859b4769aU)),.hi = ((u64)(0x03f510b91a22f4c1U)),}, (strconv__Uint128){.lo = ((u64)(0xee9b642047c39215U)),.hi = ((u64)(0x032a73c7481bf700U)),}, (strconv__Uint128){.lo = ((u64)(0xbee2b680396941aaU)),.hi = ((u64)(0x02885c9f6ce32c00U)),}, (strconv__Uint128){.lo = ((u64)(0xff1bc53361210155U)),.hi = ((u64)(0x0206b07f8a4f5666U)),}, (strconv__Uint128){.lo = ((u64)(0x31c6085235019bbbU)),.hi = ((u64)(0x033de73276e5570bU)),}, (strconv__Uint128){.lo = ((u64)(0x27d1a041c4014963U)),.hi = ((u64)(0x0297ec285f1ddf3cU)),}, (strconv__Uint128){.lo = ((u64)(0xeca7b367d0010782U)),.hi = ((u64)(0x021323537f4b18fcU)),}, (strconv__Uint128){.lo = ((u64)(0xadd91f0c8001a59dU)),.hi = ((u64)(0x0351d21f3211c194U)),}, (strconv__Uint128){.lo = ((u64)(0xf17a7f3d3334847eU)),.hi = ((u64)(0x02a7db4c280e3476U)),}, (strconv__Uint128){.lo = ((u64)(0x279532975c2a0398U)),.hi = ((u64)(0x021fe2a3533e905fU)),}, (strconv__Uint128){.lo = ((u64)(0xd8eeb75893766c26U)),.hi = ((u64)(0x0366376bb8641a31U)),}, (strconv__Uint128){.lo = ((u64)(0x7a5892ad42c52352U)),.hi = ((u64)(0x02b82c562d1ce1c1U)),}, (strconv__Uint128){.lo = ((u64)(0xfb7a0ef102374f75U)),.hi = ((u64)(0x022cf044f0e3e7cdU)),}, (strconv__Uint128){.lo = ((u64)(0xc59017e8038bb254U)),.hi = ((u64)(0x037b1a07e7d30c7cU)),}, (strconv__Uint128){.lo = ((u64)(0x37a67986693c8eaaU)),.hi = ((u64)(0x02c8e19feca8d6caU)),}, (strconv__Uint128){.lo = ((u64)(0xf951fad1edca0bbbU)),.hi = ((u64)(0x023a4e198a20abd4U)),}, (strconv__Uint128){.lo = ((u64)(0x28832ae97c76792bU)),.hi = ((u64)(0x03907cf5a9cddfbbU)),}, (strconv__Uint128){.lo = ((u64)(0x2068ef21305ec756U)),.hi = ((u64)(0x02d9fd9154a4b2fcU)),}, (strconv__Uint128){.lo = ((u64)(0x19ed8c1a8d189f78U)),.hi = ((u64)(0x0247fe0ddd508f30U)),}, (strconv__Uint128){.lo = ((u64)(0x5caf4690e1c0ff26U)),.hi = ((u64)(0x03a66349621a7eb3U)),}, (strconv__Uint128){.lo = ((u64)(0x4a25d20d81673285U)),.hi = ((u64)(0x02eb82a11b48655cU)),}, (strconv__Uint128){.lo = ((u64)(0x3b5174d79ab8f537U)),.hi = ((u64)(0x0256021a7c39eab0U)),}, (strconv__Uint128){.lo = ((u64)(0x921bee25c45b21f1U)),.hi = ((u64)(0x03bcd02a605caab3U)),}, (strconv__Uint128){.lo = ((u64)(0xdb498b5169e2818eU)),.hi = ((u64)(0x02fd735519e3bbc2U)),}, (strconv__Uint128){.lo = ((u64)(0x15d46f7454b53472U)),.hi = ((u64)(0x02645c4414b62fcfU)),}, (strconv__Uint128){.lo = ((u64)(0xefba4bed545520b6U)),.hi = ((u64)(0x03d3c6d35456b2e4U)),}, (strconv__Uint128){.lo = ((u64)(0xf2fb6ff110441a2bU)),.hi = ((u64)(0x030fd242a9def583U)),}, (strconv__Uint128){.lo = ((u64)(0x8f2f8cc0d9d014efU)),.hi = ((u64)(0x02730e9bbb18c469U)),}, (strconv__Uint128){.lo = ((u64)(0xb1e5ae015c80217fU)),.hi = ((u64)(0x03eb4a92c4f46d75U)),}, (strconv__Uint128){.lo = ((u64)(0xc1848b344a001accU)),.hi = ((u64)(0x0322a20f03f6bdf7U)),}, (strconv__Uint128){.lo = ((u64)(0xce03a2903b3348a3U)),.hi = ((u64)(0x02821b3f365efe5fU)),}, (strconv__Uint128){.lo = ((u64)(0xd802e873628f6d4fU)),.hi = ((u64)(0x0201af65c518cb7fU)),}, (strconv__Uint128){.lo = ((u64)(0x599e40b89db2487fU)),.hi = ((u64)(0x0335e56fa1c14599U)),}, (strconv__Uint128){.lo = ((u64)(0xe14b66fa17c1d399U)),.hi = ((u64)(0x029184594e3437adU)),}, (strconv__Uint128){.lo = ((u64)(0x81091f2e7967dc7aU)),.hi = ((u64)(0x020e037aa4f692f1U)),}, (strconv__Uint128){.lo = ((u64)(0x9b41cb7d8f0c93f6U)),.hi = ((u64)(0x03499f2aa18a84b5U)),}, (strconv__Uint128){.lo = ((u64)(0xaf67d5fe0c0a0ff8U)),.hi = ((u64)(0x02a14c221ad536f7U)),}, (strconv__Uint128){.lo = ((u64)(0xf2b977fe70080cc7U)),.hi = ((u64)(0x021aa34e7bddc592U)),}, (strconv__Uint128){.lo = ((u64)(0x1df58cca4cd9ae0bU)),.hi = ((u64)(0x035dd2172c9608ebU)),}, (strconv__Uint128){.lo = ((u64)(0xe4c470a1d7148b3cU)),.hi = ((u64)(0x02b174df56de6d88U)),}, (strconv__Uint128){.lo = ((u64)(0x83d05a1b1276d5caU)),.hi = ((u64)(0x022790b2abe5246dU)),}, (strconv__Uint128){.lo = ((u64)(0x9fb3c35e83f1560fU)),.hi = ((u64)(0x0372811ddfd50715U)),}, (strconv__Uint128){.lo = ((u64)(0xb2f635e5365aab3fU)),.hi = ((u64)(0x02c200e4b310d277U)),}, (strconv__Uint128){.lo = ((u64)(0xf591c4b75eaeef66U)),.hi = ((u64)(0x0234cd83c273db92U)),}, (strconv__Uint128){.lo = ((u64)(0xef4fa125644b18a3U)),.hi = ((u64)(0x0387af39371fc5b7U)),}, (strconv__Uint128){.lo = ((u64)(0x8c3fb41de9d5ad4fU)),.hi = ((u64)(0x02d2f2942c196af9U)),}, (strconv__Uint128){.lo = ((u64)(0x3cffc34b2177bdd9U)),.hi = ((u64)(0x02425ba9bce12261U)),}, (strconv__Uint128){.lo = ((u64)(0x94cc6bab68bf9628U)),.hi = ((u64)(0x039d5f75fb01d09bU)),}, (strconv__Uint128){.lo = ((u64)(0x10a38955ed6611b9U)),.hi = ((u64)(0x02e44c5e6267da16U)),}, (strconv__Uint128){.lo = ((u64)(0xda1c6dde5784dafbU)),.hi = ((u64)(0x02503d184eb97b44U)),}, (strconv__Uint128){.lo = ((u64)(0xf693e2fd58d49191U)),.hi = ((u64)(0x03b394f3b128c53aU)),}, (strconv__Uint128){.lo = ((u64)(0xc5431bfde0aa0e0eU)),.hi = ((u64)(0x02f610c2f4209dc8U)),}, (strconv__Uint128){.lo = ((u64)(0x6a9c1664b3bb3e72U)),.hi = ((u64)(0x025e73cf29b3b16dU)),}, (strconv__Uint128){.lo = ((u64)(0x10f9bd6dec5eca4fU)),.hi = ((u64)(0x03ca52e50f85e8afU)),}, (strconv__Uint128){.lo = ((u64)(0xda616457f04bd50cU)),.hi = ((u64)(0x03084250d937ed58U)),}, (strconv__Uint128){.lo = ((u64)(0xe1e783798d09773dU)),.hi = ((u64)(0x026d01da475ff113U)),}, (strconv__Uint128){.lo = ((u64)(0x030c058f480f252eU)),.hi = ((u64)(0x03e19c9072331b53U)),}, (strconv__Uint128){.lo = ((u64)(0x68d66ad906728425U)),.hi = ((u64)(0x031ae3a6c1c27c42U)),}, (strconv__Uint128){.lo = ((u64)(0x8711ef14052869b7U)),.hi = ((u64)(0x027be952349b969bU)),}, (strconv__Uint128){.lo = ((u64)(0x0b4fe4ecd50d75f2U)),.hi = ((u64)(0x03f97550542c242cU)),}, (strconv__Uint128){.lo = ((u64)(0xa2a650bd773df7f5U)),.hi = ((u64)(0x032df7737689b689U)),}, (strconv__Uint128){.lo = ((u64)(0xb551da312c31932aU)),.hi = ((u64)(0x028b2c5c5ed49207U)),}, (strconv__Uint128){.lo = ((u64)(0x5ddb14f4235adc22U)),.hi = ((u64)(0x0208f049e576db39U)),}, (strconv__Uint128){.lo = ((u64)(0x2fc4ee536bc49369U)),.hi = ((u64)(0x034180763bf15ec2U)),}, (strconv__Uint128){.lo = ((u64)(0xbfd0bea92303a921U)),.hi = ((u64)(0x029acd2b63277f01U)),}, (strconv__Uint128){.lo = ((u64)(0x9973cbba8269541aU)),.hi = ((u64)(0x021570ef8285ff34U)),}, (strconv__Uint128){.lo = ((u64)(0x5bec792a6a42202aU)),.hi = ((u64)(0x0355817f373ccb87U)),}, (strconv__Uint128){.lo = ((u64)(0xe3239421ee9b4cefU)),.hi = ((u64)(0x02aacdff5f63d605U)),}, (strconv__Uint128){.lo = ((u64)(0xb5b6101b25490a59U)),.hi = ((u64)(0x02223e65e5e97804U)),}, (strconv__Uint128){.lo = ((u64)(0x22bce691d541aa27U)),.hi = ((u64)(0x0369fd6fd64259a1U)),}, (strconv__Uint128){.lo = ((u64)(0xb563eba7ddce21b9U)),.hi = ((u64)(0x02bb31264501e14dU)),}, (strconv__Uint128){.lo = ((u64)(0xf78322ecb171b494U)),.hi = ((u64)(0x022f5a850401810aU)),}, (strconv__Uint128){.lo = ((u64)(0x259e9e47824f8753U)),.hi = ((u64)(0x037ef73b399c01abU)),}, (strconv__Uint128){.lo = ((u64)(0x1e187e9f9b72d2a9U)),.hi = ((u64)(0x02cbf8fc2e1667bcU)),}, (strconv__Uint128){.lo = ((u64)(0x4b46cbb2e2c24221U)),.hi = ((u64)(0x023cc73024deb963U)),}, (strconv__Uint128){.lo = ((u64)(0x120adf849e039d01U)),.hi = ((u64)(0x039471e6a1645bd2U)),}, (strconv__Uint128){.lo = ((u64)(0xdb3be603b19c7d9aU)),.hi = ((u64)(0x02dd27ebb4504974U)),}, (strconv__Uint128){.lo = ((u64)(0x7c2feb3627b0647cU)),.hi = ((u64)(0x024a865629d9d45dU)),}, (strconv__Uint128){.lo = ((u64)(0x2d197856a5e7072cU)),.hi = ((u64)(0x03aa7089dc8fba2fU)),}, (strconv__Uint128){.lo = ((u64)(0x8a7ac6abb7ec05bdU)),.hi = ((u64)(0x02eec06e4a0c94f2U)),}, (strconv__Uint128){.lo = ((u64)(0xd52f05562cbcd164U)),.hi = ((u64)(0x025899f1d4d6dd8eU)),}, (strconv__Uint128){.lo = ((u64)(0x21e4d556adfae8a0U)),.hi = ((u64)(0x03c0f64fbaf1627eU)),}, (strconv__Uint128){.lo = ((u64)(0xe7ea444557fbed4dU)),.hi = ((u64)(0x0300c50c958de864U)),}, (strconv__Uint128){.lo = ((u64)(0xecbb69d1132ff10aU)),.hi = ((u64)(0x0267040a113e5383U)),}, (strconv__Uint128){.lo = ((u64)(0xadf8a94e851981aaU)),.hi = ((u64)(0x03d8067681fd526cU)),}, (strconv__Uint128){.lo = ((u64)(0x8b2d543ed0e13488U)),.hi = ((u64)(0x0313385ece6441f0U)),}, (strconv__Uint128){.lo = ((u64)(0xd5bddcff0d80f6d3U)),.hi = ((u64)(0x0275c6b23eb69b26U)),}, (strconv__Uint128){.lo = ((u64)(0x892fc7fe7c018aebU)),.hi = ((u64)(0x03efa45064575ea4U)),}, (strconv__Uint128){.lo = ((u64)(0x3a8c9ffec99ad589U)),.hi = ((u64)(0x03261d0d1d12b21dU)),}, (strconv__Uint128){.lo = ((u64)(0xc8707fff07af113bU)),.hi = ((u64)(0x0284e40a7da88e7dU)),}, (strconv__Uint128){.lo = ((u64)(0x39f39998d2f2742fU)),.hi = ((u64)(0x0203e9a1fe2071feU)),}, (strconv__Uint128){.lo = ((u64)(0x8fec28f484b7204bU)),.hi = ((u64)(0x033975cffd00b663U)),}, (strconv__Uint128){.lo = ((u64)(0xd989ba5d36f8e6a2U)),.hi = ((u64)(0x02945e3ffd9a2b82U)),}, (strconv__Uint128){.lo = ((u64)(0x47a161e42bfa521cU)),.hi = ((u64)(0x02104b66647b5602U)),}, (strconv__Uint128){.lo = ((u64)(0x0c35696d132a1cf9U)),.hi = ((u64)(0x034d4570a0c5566aU)),}, (strconv__Uint128){.lo = ((u64)(0x09c454574288172dU)),.hi = ((u64)(0x02a4378d4d6aab88U)),}, (strconv__Uint128){.lo = ((u64)(0xa169dd129ba0128bU)),.hi = ((u64)(0x021cf93dd7888939U)),}, (strconv__Uint128){.lo = ((u64)(0x0242fb50f9001dabU)),.hi = ((u64)(0x03618ec958da7529U)),}, (strconv__Uint128){.lo = ((u64)(0x9b68c90d940017bcU)),.hi = ((u64)(0x02b4723aad7b90edU)),}, (strconv__Uint128){.lo = ((u64)(0x4920a0d7a999ac96U)),.hi = ((u64)(0x0229f4fbbdfc73f1U)),}, (strconv__Uint128){.lo = ((u64)(0x750101590f5c4757U)),.hi = ((u64)(0x037654c5fcc71fe8U)),}, (strconv__Uint128){.lo = ((u64)(0x2a6734473f7d05dfU)),.hi = ((u64)(0x02c5109e63d27fedU)),}, (strconv__Uint128){.lo = ((u64)(0xeeb8f69f65fd9e4cU)),.hi = ((u64)(0x0237407eb641fff0U)),}, (strconv__Uint128){.lo = ((u64)(0xe45b24323cc8fd46U)),.hi = ((u64)(0x038b9a6456cfffe7U)),}, (strconv__Uint128){.lo = ((u64)(0xb6af502830a0ca9fU)),.hi = ((u64)(0x02d6151d123fffecU)),}, (strconv__Uint128){.lo = ((u64)(0xf88c402026e7087fU)),.hi = ((u64)(0x0244ddb0db666656U)),}, (strconv__Uint128){.lo = ((u64)(0x2746cd003e3e73feU)),.hi = ((u64)(0x03a162b4923d708bU)),}, (strconv__Uint128){.lo = ((u64)(0x1f6bd73364fec332U)),.hi = ((u64)(0x02e7822a0e978d3cU)),}, (strconv__Uint128){.lo = ((u64)(0xe5efdf5c50cbcf5bU)),.hi = ((u64)(0x0252ce880bac70fcU)),}, (strconv__Uint128){.lo = ((u64)(0x3cb2fefa1adfb22bU)),.hi = ((u64)(0x03b7b0d9ac471b2eU)),}, (strconv__Uint128){.lo = ((u64)(0x308f3261af195b56U)),.hi = ((u64)(0x02f95a47bd05af58U)),}, (strconv__Uint128){.lo = ((u64)(0x5a0c284e25ade2abU)),.hi = ((u64)(0x0261150630d15913U)),}, (strconv__Uint128){.lo = ((u64)(0x29ad0d49d5e30445U)),.hi = ((u64)(0x03ce8809e7b55b52U)),}, (strconv__Uint128){.lo = ((u64)(0x548a7107de4f369dU)),.hi = ((u64)(0x030ba007ec9115dbU)),}, (strconv__Uint128){.lo = ((u64)(0xdd3b8d9fe50c2bb1U)),.hi = ((u64)(0x026fb3398a0dab15U)),}, (strconv__Uint128){.lo = ((u64)(0x952c15cca1ad12b5U)),.hi = ((u64)(0x03e5eb8f434911bcU)),}, (strconv__Uint128){.lo = ((u64)(0x775677d6e7bda891U)),.hi = ((u64)(0x031e560c35d40e30U)),}, (strconv__Uint128){.lo = ((u64)(0xc5dec645863153a7U)),.hi = ((u64)(0x027eab3cf7dcd826U)),}}));
	// Initializations for module builtin :
	_const_init_capicity = 1 << _const_init_log_capicity;
	_const_init_even_index = _const_init_capicity - 2;
	_const_hash_mask = ((u32)(0x00FFFFFFU));
	_const_probe_inc = ((u32)(0x01000000U));
	_const_mid_index = _const_degree - 1;
	_const_max_len = 2 * _const_degree - 1;
	_const_children_bytes = /*SizeOfType*/ sizeof(voidptr) * (_const_max_len + 1);
	// Initializations for module gencmd :
}

// THE END.

