/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.newhope;

import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.newhope.ChaCha20;
import org.bouncycastle.pqc.crypto.newhope.NTT;
import org.bouncycastle.pqc.crypto.newhope.Precomp;
import org.bouncycastle.pqc.crypto.newhope.Reduce;
import org.bouncycastle.util.Pack;

class Poly {
    Poly() {
    }

    static void add(short[] x, short[] y, short[] z) {
        int i = 0;
        while (i < 1024) {
            z[i] = Reduce.barrett((short)(x[i] + y[i]));
            ++i;
        }
    }

    static void fromBytes(short[] r, byte[] a) {
        int i = 0;
        while (i < 256) {
            int j = 7 * i;
            int a0 = a[j + 0] & 0xFF;
            int a1 = a[j + 1] & 0xFF;
            int a2 = a[j + 2] & 0xFF;
            int a3 = a[j + 3] & 0xFF;
            int a4 = a[j + 4] & 0xFF;
            int a5 = a[j + 5] & 0xFF;
            int a6 = a[j + 6] & 0xFF;
            int k = 4 * i;
            r[k + 0] = (short)(a0 | (a1 & 0x3F) << 8);
            r[k + 1] = (short)(a1 >>> 6 | a2 << 2 | (a3 & 0xF) << 10);
            r[k + 2] = (short)(a3 >>> 4 | a4 << 4 | (a5 & 3) << 12);
            r[k + 3] = (short)(a5 >>> 2 | a6 << 6);
            ++i;
        }
    }

    static void fromNTT(short[] r) {
        NTT.bitReverse(r);
        NTT.core(r, Precomp.OMEGAS_INV_MONTGOMERY);
        NTT.mulCoefficients(r, Precomp.PSIS_INV_MONTGOMERY);
    }

    static void getNoise(short[] r, byte[] seed, byte nonce) {
        byte[] iv = new byte[8];
        iv[0] = nonce;
        byte[] buf = new byte[4096];
        ChaCha20.process(seed, iv, buf, 0, buf.length);
        int i = 0;
        while (i < 1024) {
            int t = Pack.bigEndianToInt(buf, i * 4);
            int d = 0;
            int j = 0;
            while (j < 8) {
                d += t >> j & 0x1010101;
                ++j;
            }
            int a = (d >>> 24) + (d >>> 0) & 0xFF;
            int b = (d >>> 16) + (d >>> 8) & 0xFF;
            r[i] = (short)(a + 12289 - b);
            ++i;
        }
    }

    static void pointWise(short[] x, short[] y, short[] z) {
        int i = 0;
        while (i < 1024) {
            int xi = x[i] & 0xFFFF;
            int yi = y[i] & 0xFFFF;
            short t = Reduce.montgomery(3186 * yi);
            z[i] = Reduce.montgomery(xi * (t & 0xFFFF));
            ++i;
        }
    }

    static void toBytes(byte[] r, short[] p) {
        int i = 0;
        while (i < 256) {
            int j = 4 * i;
            short t0 = Poly.normalize(p[j + 0]);
            short t1 = Poly.normalize(p[j + 1]);
            short t2 = Poly.normalize(p[j + 2]);
            short t3 = Poly.normalize(p[j + 3]);
            int k = 7 * i;
            r[k + 0] = (byte)t0;
            r[k + 1] = (byte)(t0 >> 8 | t1 << 6);
            r[k + 2] = (byte)(t1 >> 2);
            r[k + 3] = (byte)(t1 >> 10 | t2 << 4);
            r[k + 4] = (byte)(t2 >> 4);
            r[k + 5] = (byte)(t2 >> 12 | t3 << 2);
            r[k + 6] = (byte)(t3 >> 6);
            ++i;
        }
    }

    static void toNTT(short[] r) {
        NTT.mulCoefficients(r, Precomp.PSIS_BITREV_MONTGOMERY);
        NTT.core(r, Precomp.OMEGAS_MONTGOMERY);
    }

    static void uniform(short[] a, byte[] seed) {
        SHAKEDigest xof = new SHAKEDigest(128);
        xof.update(seed, 0, seed.length);
        int pos = 0;
        block0: while (true) {
            byte[] output = new byte[256];
            xof.doOutput(output, 0, output.length);
            int i = 0;
            while (true) {
                if (i >= output.length) continue block0;
                int val = output[i] & 0xFF | (output[i + 1] & 0xFF) << 8;
                if (val < 61445) {
                    a[pos++] = (short)val;
                    if (pos == 1024) {
                        return;
                    }
                }
                i += 2;
            }
            break;
        }
    }

    private static short normalize(short x) {
        int t = Reduce.barrett(x);
        int m = t - 12289;
        int c = m >> 31;
        t = m ^ (t ^ m) & c;
        return (short)t;
    }
}

