/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.test;

import org.bouncycastle.crypto.digests.GeneralDigest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class HKDFGeneratorTest
extends SimpleTest {
    private void compareOKM(int test, byte[] calculatedOKM, byte[] testOKM) {
        if (!this.areEqual(calculatedOKM, testOKM)) {
            this.fail("HKDF failed generator test " + test);
        }
    }

    @Override
    public void performTest() {
        GeneralDigest hash = new SHA256Digest();
        byte[] ikm = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        byte[] salt = Hex.decode("000102030405060708090a0b0c");
        byte[] info = Hex.decode("f0f1f2f3f4f5f6f7f8f9");
        int l = 42;
        byte[] okm = new byte[l];
        HKDFParameters params = new HKDFParameters(ikm, salt, info);
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(1, okm, Hex.decode("3cb25f25faacd57a90434f64d0362f2a2d2d0a90cf1a5a4c5db02d56ecc4c5bf34007208d5b887185865"));
        hash = new SHA256Digest();
        ikm = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f");
        salt = Hex.decode("606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf");
        info = Hex.decode("b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
        l = 82;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(2, okm, Hex.decode("b11e398dc80327a1c8e7f78c596a49344f012eda2d4efad8a050cc4c19afa97c59045a99cac7827271cb41c65e590e09da3275600c2f09b8367793a9aca3db71cc30c58179ec3e87c14c01d5c1f3434f1d87"));
        hash = new SHA256Digest();
        ikm = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        salt = new byte[]{};
        info = null;
        l = 42;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(3, okm, Hex.decode("8da4e775a563c18f715f802a063c5a31b8a11f5c5ee1879ec3454e5f3c738d2d9d201395faa4b61a96c8"));
        hash = new SHA1Digest();
        ikm = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b");
        salt = Hex.decode("000102030405060708090a0b0c");
        info = Hex.decode("f0f1f2f3f4f5f6f7f8f9");
        l = 42;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(4, okm, Hex.decode("085a01ea1b10f36933068b56efa5ad81a4f14b822f5b091568a9cdd4f155fda2c22e422478d305f3f896"));
        hash = new SHA1Digest();
        ikm = Hex.decode("000102030405060708090a0b0c0d0e0f101112131415161718191a1b1c1d1e1f202122232425262728292a2b2c2d2e2f303132333435363738393a3b3c3d3e3f404142434445464748494a4b4c4d4e4f");
        salt = Hex.decode("606162636465666768696a6b6c6d6e6f707172737475767778797a7b7c7d7e7f808182838485868788898a8b8c8d8e8f909192939495969798999a9b9c9d9e9fa0a1a2a3a4a5a6a7a8a9aaabacadaeaf");
        info = Hex.decode("b0b1b2b3b4b5b6b7b8b9babbbcbdbebfc0c1c2c3c4c5c6c7c8c9cacbcccdcecfd0d1d2d3d4d5d6d7d8d9dadbdcdddedfe0e1e2e3e4e5e6e7e8e9eaebecedeeeff0f1f2f3f4f5f6f7f8f9fafbfcfdfeff");
        l = 82;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(5, okm, Hex.decode("0bd770a74d1160f7c9f12cd5912a06ebff6adcae899d92191fe4305673ba2ffe8fa3f1a4e5ad79f3f334b3b202b2173c486ea37ce3d397ed034c7f9dfeb15c5e927336d0441f4c4300e2cff0d0900b52d3b4"));
        hash = new SHA1Digest();
        ikm = Hex.decode("0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b0b");
        salt = null;
        info = new byte[]{};
        l = 42;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(6, okm, Hex.decode("0ac1af7002b3d761d1e55298da9d0506b9ae52057220a306e07b6b87e8df21d0ea00033de03984d34918"));
        hash = new SHA1Digest();
        ikm = Hex.decode("0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c0c");
        salt = null;
        info = new byte[]{};
        l = 42;
        okm = new byte[l];
        params = new HKDFParameters(ikm, salt, info);
        hkdf = new HKDFBytesGenerator(hash);
        hkdf.init(params);
        hkdf.generateBytes(okm, 0, l);
        this.compareOKM(7, okm, Hex.decode("2c91117204d745f3500d636a62f64f0ab3bae548aa53d423b0d1f27ebba6f5e5673a081d70cce7acfc48"));
        hash = new SHA1Digest();
        ikm = Hex.decode("2adccada18779e7c2077ad2eb19d3f3e731385dd");
        byte[] info2 = new byte[]{};
        int l2 = 42;
        byte[] okm2 = new byte[l2];
        HKDFParameters params2 = HKDFParameters.skipExtractParameters(ikm, info2);
        HKDFBytesGenerator hkdf2 = new HKDFBytesGenerator(hash);
        hkdf2.init(params2);
        hkdf2.generateBytes(okm2, 0, l2);
        this.compareOKM(101, okm2, Hex.decode("2c91117204d745f3500d636a62f64f0ab3bae548aa53d423b0d1f27ebba6f5e5673a081d70cce7acfc48"));
        hash = new SHA1Digest();
        ikm = Hex.decode("2adccada18779e7c2077ad2eb19d3f3e731385dd");
        info2 = new byte[]{};
        l2 = 255 * hash.getDigestSize();
        okm2 = new byte[l2];
        params2 = HKDFParameters.skipExtractParameters(ikm, info2);
        hkdf2 = new HKDFBytesGenerator(hash);
        hkdf2.init(params2);
        hkdf2.generateBytes(okm2, 0, l2);
        int zeros = 0;
        int i = 0;
        while (i < hash.getDigestSize()) {
            if (okm2[i] == 0) {
                ++zeros;
            }
            ++i;
        }
        if (zeros == hash.getDigestSize()) {
            this.fail("HKDF failed generator test 102");
        }
    }

    @Override
    public String getName() {
        return "HKDF";
    }

    public static void main(String[] args) {
        HKDFGeneratorTest.runTest(new HKDFGeneratorTest());
    }
}

