/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.util;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTCTime;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BERSequence;
import org.bouncycastle.asn1.BERSet;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERGraphicString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class ASN1Dump {
    private static final String TAB = "    ";
    private static final int SAMPLE_SIZE = 32;

    static void _dumpAsString(String indent, boolean verbose, ASN1Primitive obj, StringBuffer buf) {
        String nl = Strings.lineSeparator();
        if (obj instanceof ASN1Sequence) {
            Enumeration e = ((ASN1Sequence)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            if (obj instanceof BERSequence) {
                buf.append("BER Sequence");
            } else if (obj instanceof DERSequence) {
                buf.append("DER Sequence");
            } else {
                buf.append("Sequence");
            }
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null || o.equals(DERNull.INSTANCE)) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o).toASN1Primitive(), buf);
            }
        } else if (obj instanceof ASN1TaggedObject) {
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            if (obj instanceof BERTaggedObject) {
                buf.append("BER Tagged [");
            } else {
                buf.append("Tagged [");
            }
            ASN1TaggedObject o = (ASN1TaggedObject)obj;
            buf.append(Integer.toString(o.getTagNo()));
            buf.append(']');
            if (!o.isExplicit()) {
                buf.append(" IMPLICIT ");
            }
            buf.append(nl);
            if (o.isEmpty()) {
                buf.append(tab);
                buf.append("EMPTY");
                buf.append(nl);
            } else {
                ASN1Dump._dumpAsString(tab, verbose, o.getObject(), buf);
            }
        } else if (obj instanceof ASN1Set) {
            Enumeration e = ((ASN1Set)obj).getObjects();
            String tab = String.valueOf(indent) + TAB;
            buf.append(indent);
            if (obj instanceof BERSet) {
                buf.append("BER Set");
            } else {
                buf.append("DER Set");
            }
            buf.append(nl);
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == null) {
                    buf.append(tab);
                    buf.append("NULL");
                    buf.append(nl);
                    continue;
                }
                if (o instanceof ASN1Primitive) {
                    ASN1Dump._dumpAsString(tab, verbose, (ASN1Primitive)o, buf);
                    continue;
                }
                ASN1Dump._dumpAsString(tab, verbose, ((ASN1Encodable)o).toASN1Primitive(), buf);
            }
        } else if (obj instanceof ASN1OctetString) {
            ASN1OctetString oct = (ASN1OctetString)obj;
            if (obj instanceof BEROctetString) {
                buf.append(String.valueOf(indent) + "BER Constructed Octet String" + "[" + oct.getOctets().length + "] ");
            } else {
                buf.append(String.valueOf(indent) + "DER Octet String" + "[" + oct.getOctets().length + "] ");
            }
            if (verbose) {
                buf.append(ASN1Dump.dumpBinaryDataAsString(indent, oct.getOctets()));
            } else {
                buf.append(nl);
            }
        } else if (obj instanceof ASN1ObjectIdentifier) {
            buf.append(String.valueOf(indent) + "ObjectIdentifier(" + ((ASN1ObjectIdentifier)obj).getId() + ")" + nl);
        } else if (obj instanceof ASN1Boolean) {
            buf.append(String.valueOf(indent) + "Boolean(" + ((ASN1Boolean)obj).isTrue() + ")" + nl);
        } else if (obj instanceof ASN1Integer) {
            buf.append(String.valueOf(indent) + "Integer(" + ((ASN1Integer)obj).getValue() + ")" + nl);
        } else if (obj instanceof DERBitString) {
            DERBitString bt = (DERBitString)obj;
            buf.append(String.valueOf(indent) + "DER Bit String" + "[" + bt.getBytes().length + ", " + bt.getPadBits() + "] ");
            if (verbose) {
                buf.append(ASN1Dump.dumpBinaryDataAsString(indent, bt.getBytes()));
            } else {
                buf.append(nl);
            }
        } else if (obj instanceof DERIA5String) {
            buf.append(String.valueOf(indent) + "IA5String(" + ((DERIA5String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERUTF8String) {
            buf.append(String.valueOf(indent) + "UTF8String(" + ((DERUTF8String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERPrintableString) {
            buf.append(String.valueOf(indent) + "PrintableString(" + ((DERPrintableString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERVisibleString) {
            buf.append(String.valueOf(indent) + "VisibleString(" + ((DERVisibleString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERBMPString) {
            buf.append(String.valueOf(indent) + "BMPString(" + ((DERBMPString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERT61String) {
            buf.append(String.valueOf(indent) + "T61String(" + ((DERT61String)obj).getString() + ") " + nl);
        } else if (obj instanceof DERGraphicString) {
            buf.append(String.valueOf(indent) + "GraphicString(" + ((DERGraphicString)obj).getString() + ") " + nl);
        } else if (obj instanceof DERVideotexString) {
            buf.append(String.valueOf(indent) + "VideotexString(" + ((DERVideotexString)obj).getString() + ") " + nl);
        } else if (obj instanceof ASN1UTCTime) {
            buf.append(String.valueOf(indent) + "UTCTime(" + ((ASN1UTCTime)obj).getTime() + ") " + nl);
        } else if (obj instanceof ASN1GeneralizedTime) {
            buf.append(String.valueOf(indent) + "GeneralizedTime(" + ((ASN1GeneralizedTime)obj).getTime() + ") " + nl);
        } else if (obj instanceof BERApplicationSpecific) {
            buf.append(ASN1Dump.outputApplicationSpecific("BER", indent, verbose, obj, nl));
        } else if (obj instanceof DERApplicationSpecific) {
            buf.append(ASN1Dump.outputApplicationSpecific("DER", indent, verbose, obj, nl));
        } else if (obj instanceof ASN1Enumerated) {
            ASN1Enumerated en = (ASN1Enumerated)obj;
            buf.append(String.valueOf(indent) + "DER Enumerated(" + en.getValue() + ")" + nl);
        } else if (obj instanceof DERExternal) {
            DERExternal ext = (DERExternal)obj;
            buf.append(String.valueOf(indent) + "External " + nl);
            String tab = String.valueOf(indent) + TAB;
            if (ext.getDirectReference() != null) {
                buf.append(String.valueOf(tab) + "Direct Reference: " + ext.getDirectReference().getId() + nl);
            }
            if (ext.getIndirectReference() != null) {
                buf.append(String.valueOf(tab) + "Indirect Reference: " + ext.getIndirectReference().toString() + nl);
            }
            if (ext.getDataValueDescriptor() != null) {
                ASN1Dump._dumpAsString(tab, verbose, ext.getDataValueDescriptor(), buf);
            }
            buf.append(String.valueOf(tab) + "Encoding: " + ext.getEncoding() + nl);
            ASN1Dump._dumpAsString(tab, verbose, ext.getExternalContent(), buf);
        } else {
            buf.append(String.valueOf(indent) + obj.toString() + nl);
        }
    }

    private static String outputApplicationSpecific(String type, String indent, boolean verbose, ASN1Primitive obj, String nl) {
        ASN1ApplicationSpecific app = ASN1ApplicationSpecific.getInstance(obj);
        StringBuffer buf = new StringBuffer();
        if (app.isConstructed()) {
            try {
                ASN1Sequence s = ASN1Sequence.getInstance(app.getObject(16));
                buf.append(String.valueOf(indent) + type + " ApplicationSpecific[" + app.getApplicationTag() + "]" + nl);
                Enumeration e = s.getObjects();
                while (e.hasMoreElements()) {
                    ASN1Dump._dumpAsString(String.valueOf(indent) + TAB, verbose, (ASN1Primitive)e.nextElement(), buf);
                }
            }
            catch (IOException e) {
                buf.append(e);
            }
            return buf.toString();
        }
        return String.valueOf(indent) + type + " ApplicationSpecific[" + app.getApplicationTag() + "] (" + Strings.fromByteArray(Hex.encode(app.getContents())) + ")" + nl;
    }

    public static String dumpAsString(Object obj) {
        return ASN1Dump.dumpAsString(obj, false);
    }

    public static String dumpAsString(Object obj, boolean verbose) {
        StringBuffer buf = new StringBuffer();
        if (obj instanceof ASN1Primitive) {
            ASN1Dump._dumpAsString("", verbose, (ASN1Primitive)obj, buf);
        } else if (obj instanceof ASN1Encodable) {
            ASN1Dump._dumpAsString("", verbose, ((ASN1Encodable)obj).toASN1Primitive(), buf);
        } else {
            return "unknown object type " + obj.toString();
        }
        return buf.toString();
    }

    private static String dumpBinaryDataAsString(String indent, byte[] bytes) {
        String nl = Strings.lineSeparator();
        StringBuffer buf = new StringBuffer();
        indent = String.valueOf(indent) + TAB;
        buf.append(nl);
        int i = 0;
        while (i < bytes.length) {
            if (bytes.length - i > 32) {
                buf.append(indent);
                buf.append(Strings.fromByteArray(Hex.encode(bytes, i, 32)));
                buf.append(TAB);
                buf.append(ASN1Dump.calculateAscString(bytes, i, 32));
                buf.append(nl);
            } else {
                buf.append(indent);
                buf.append(Strings.fromByteArray(Hex.encode(bytes, i, bytes.length - i)));
                int j = bytes.length - i;
                while (j != 32) {
                    buf.append("  ");
                    ++j;
                }
                buf.append(TAB);
                buf.append(ASN1Dump.calculateAscString(bytes, i, bytes.length - i));
                buf.append(nl);
            }
            i += 32;
        }
        return buf.toString();
    }

    private static String calculateAscString(byte[] bytes, int off, int len) {
        StringBuffer buf = new StringBuffer();
        int i = off;
        while (i != off + len) {
            if (bytes[i] >= 32 && bytes[i] <= 126) {
                buf.append((char)bytes[i]);
            }
            ++i;
        }
        return buf.toString();
    }
}

