/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public abstract class ASN1ApplicationSpecific
extends ASN1Primitive {
    protected final boolean isConstructed;
    protected final int tag;
    protected final byte[] octets;

    ASN1ApplicationSpecific(boolean isConstructed, int tag, byte[] octets) {
        this.isConstructed = isConstructed;
        this.tag = tag;
        this.octets = Arrays.clone(octets);
    }

    public static ASN1ApplicationSpecific getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected static int getLengthOfHeader(byte[] data) {
        int length = data[1] & 0xFF;
        if (length == 128) {
            return 2;
        }
        if (length > 127) {
            int size = length & 0x7F;
            if (size > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + size);
            }
            return size + 2;
        }
        return 2;
    }

    @Override
    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return Arrays.clone(this.octets);
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() throws IOException {
        return ASN1Primitive.fromByteArray(this.getContents());
    }

    public ASN1Primitive getObject(int derTagNo) throws IOException {
        if (derTagNo >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] orig = this.getEncoded();
        byte[] tmp = this.replaceTagNumber(derTagNo, orig);
        if ((orig[0] & 0x20) != 0) {
            tmp[0] = (byte)(tmp[0] | 0x20);
        }
        return ASN1Primitive.fromByteArray(tmp);
    }

    @Override
    int encodedLength() throws IOException {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        int classBits = 64;
        if (this.isConstructed) {
            classBits |= 0x20;
        }
        out.writeEncoded(classBits, this.tag, this.octets);
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1ApplicationSpecific)) {
            return false;
        }
        ASN1ApplicationSpecific other = (ASN1ApplicationSpecific)o;
        return this.isConstructed == other.isConstructed && this.tag == other.tag && Arrays.areEqual(this.octets, other.octets);
    }

    @Override
    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    /*
     * Unable to fully structure code
     */
    private byte[] replaceTagNumber(int newTag, byte[] input) throws IOException {
        block1: {
            tagNo = input[0] & 31;
            index = 1;
            if (tagNo != 31) break block1;
            tagNo = 0;
            if (((b = input[index++] & 255) & 127) != 0) ** GOTO lbl10
            throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
lbl-1000:
            // 1 sources

            {
                tagNo |= b & 127;
                tagNo <<= 7;
                b = input[index++] & 255;
lbl10:
                // 2 sources

                ** while (b >= 0 && (b & 128) != 0)
            }
        }
        tmp = new byte[input.length - index + 1];
        System.arraycopy(input, index, tmp, 1, tmp.length - 1);
        tmp[0] = (byte)newTag;
        return tmp;
    }
}

