"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketLambdaAuthorizer = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) Authorize WebSocket Api routes via a lambda function.
 *
 * @experimental
 */
class WebSocketLambdaAuthorizer {
    /**
     * @experimental
     */
    constructor(id, handler, props = {}) {
        this.id = id;
        this.handler = handler;
        this.props = props;
        jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_authorizers_alpha_WebSocketLambdaAuthorizerProps(props);
    }
    /**
     * (experimental) (experimental) Bind this authorizer to a specified WebSocket route.
     *
     * @experimental
     */
    bind(options) {
        var _b, _c;
        if (this.webSocketApi && (this.webSocketApi.apiId !== options.route.webSocketApi.apiId)) {
            throw new Error('Cannot attach the same authorizer to multiple Apis');
        }
        if (!this.authorizer) {
            this.webSocketApi = options.route.webSocketApi;
            this.authorizer = new aws_apigatewayv2_alpha_1.WebSocketAuthorizer(options.scope, this.id, {
                webSocketApi: options.route.webSocketApi,
                identitySource: (_b = this.props.identitySource) !== null && _b !== void 0 ? _b : [
                    '$request.header.Authorization',
                ],
                type: aws_apigatewayv2_alpha_1.WebSocketAuthorizerType.LAMBDA,
                authorizerName: (_c = this.props.authorizerName) !== null && _c !== void 0 ? _c : this.id,
                authorizerUri: lambdaAuthorizerArn(this.handler),
            });
            this.handler.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(this.authorizer.node)}-Permission`, {
                scope: options.scope,
                principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
                sourceArn: aws_cdk_lib_1.Stack.of(options.route).formatArn({
                    service: 'execute-api',
                    resource: options.route.webSocketApi.apiId,
                    resourceName: `authorizers/${this.authorizer.authorizerId}`,
                }),
            });
        }
        return {
            authorizerId: this.authorizer.authorizerId,
            authorizationType: 'CUSTOM',
        };
    }
}
exports.WebSocketLambdaAuthorizer = WebSocketLambdaAuthorizer;
_a = JSII_RTTI_SYMBOL_1;
WebSocketLambdaAuthorizer[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-authorizers-alpha.WebSocketLambdaAuthorizer", version: "2.5.0-alpha.0" };
/**
 * constructs the authorizerURIArn.
 */
function lambdaAuthorizerArn(handler) {
    return `arn:${aws_cdk_lib_1.Stack.of(handler).partition}:apigateway:${aws_cdk_lib_1.Stack.of(handler).region}:lambda:path/2015-03-31/functions/${handler.functionArn}/invocations`;
}
//# sourceMappingURL=data:application/json;base64,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