# Parses all imports and the imports of the imports of a py file into a Pandas DataFrame using pipdeptree/pipreqs/pip

## pip install pip2df

### Tested against Windows 10 / Python 3.10 / Anaconda 

```python
# The Python file you want to get the imports from 
# "C:\ProgramData\anaconda3\envs\adda\stra6.py" in this case 
from win10ctypestoast import show_toast

show_toast(
    title="Title",
    message="Message",
    icon=r"C:\Users\hansc\Pictures\numberresults.png",
    duration=1,
    repeat=2,
    pause=2,
    threaded=False,
)


# Create a new file (Console works as well) and use this code:
# The first time you use this module, you have to parse all modules in the env
from pip2df import ImportFetcher
cf = ( # Parsing 150 packages takes around 5 minutes.
    ImportFetcher()
    .get_all_modules_in_env(
        ignore_packages=(
            "ipython",
            "pip",
            "zipp",
            "docutils",
            "black",
            "pipreqs",
            "readme-renderer",
            "rich",
            "twine",
            "keyring",
            "importlib-metadata",
        )
    )
    .save_all_modules_dataframe("f:\\saveallimports.pkl") # Since you are probably not installing every day a new package, you can save the parsing results and load them later on
)
cf.load_all_modules_dataframe('f:\\saveallimports.pkl') # Save the parsing results 
print(cf.df) # Shows all modules in the env 
fileimports = cf.get_imports_from_py_file(
    r"C:\ProgramData\anaconda3\envs\adda\stra6.py" 
) 
print(fileimports.to_string())


# Output 
           package_name                               deps                                                                  folders  Version                                                                                                  Summary                                        Home-page                                                             Author                             Author-email       License                                              Location         Requires                                                                                                                                                                                                                           Required-by                                                                                                                                                                                                                                                                                                                                                                                             pipreqs  import_level
116    win10ctypestoast  ((Pillow, None), (pystray, None))    C:\ProgramData\anaconda3\envs\adda\lib\site-packages\win10ctypestoast     0.10                                                Windows-10-Toast-Notifications without pywin32 dependency  https://github.com/hansalemaos/win10ctypestoast                                                   Johannes Fischer  <aulasparticularesdealemaosp@gmail.com>           MIT  c:\programdata\anaconda3\envs\adda\lib\site-packages  Pillow, pystray                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ((Pillow, >=9.5.0), (pystray, >=0.19.4))             0
76               Pillow                                 ()                 C:\ProgramData\anaconda3\envs\adda\lib\site-packages\PIL    9.4.0                                                                            Python Imaging Library (Fork)                        https://python-pillow.org                                       Alex Clark (PIL Fork Author)                 aclark@python-pillow.org          HPND  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                 convpic2ico, pystray, win10ctypestoast                                                                                                                                                                                           ((cffi, >=1.15.1), (defusedxml, >=0.7.1), (ipython, >=8.12.0), (numpy, >=1.24.2), (olefile, >=0.46), (packaging, >=23.0), (PyQt5, >=5.15.9), (PyQt6, >=6.4.2), (PySide2, >=5.15.2.1), (PySide6, >=6.5.0))             1
88              pystray      ((Pillow, None), (six, None))             C:\ProgramData\anaconda3\envs\adda\lib\site-packages\pystray   0.19.4                                                                             Provides systray integration          https://github.com/moses-palmer/pystray                                                       Moses Palmér                   moses.palmer@gmail.com        LGPLv3  c:\programdata\anaconda3\envs\adda\lib\site-packages      Pillow, six                                                                                                                                                                                                                      win10ctypestoast                                                                                                                                                                                                                                                                                               ((AppKit, >=0.2.8), (Foundation, >=0.1.0a0.dev1), (Pillow, >=9.5.0), (six, >=1.16.0), (Xlib, >=0.21))             1
66                numpy                                 ()               C:\ProgramData\anaconda3\envs\adda\lib\site-packages\numpy   1.24.2                                                        Fundamental package for array computing in Python                            https://www.numpy.org                                          Travis E. Oliphant et al.                                           BSD-3-Clause  c:\programdata\anaconda3\envs\adda\lib\site-packages                   a-cv-imwrite-imread-plus, a-pandas-ex-fastloc, a-pandas-ex-numexpr, a-pandas-ex-plode-tool, check-if-nan, group-and-iter-everything, locate-pixelcolor, npfastsortcpp, numexpr, opencv-python, pandas, pdmemedit, PrettyColorPrinter  ((charset_normalizer, >=3.1.0), (Cython, >=0.29.33), (genapi, >=0.0.8), (hypothesis, >=6.70.2), (mtrand, >=0.1), (mypy, >=1.1.1), (nose, >=1.3.7), (numarray, >=1.5.1), (Numeric, >=24.2), (pickle5, >=0.0.12), (psutil, >=5.9.4), (PyInstaller, >=5.9.0), (pytest, >=7.2.2), (pytz, >=2023.2), (scipy, >=1.10.1), (setuptools, >=65.6.3), (threadpoolctl, >=3.1.0), (typing_extensions, >=4.5.0))             2
98                  six                                 ()                                                                     <NA>   1.16.0                                                                   Python 2 and 3 compatibility utilities                 https://github.com/benjaminp/six                                                  Benjamin Peterson                      benjamin@python.org           MIT  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                            asttokens, bleach, pystray, python-dateutil                                                                                                                                                                                                                                                                                                                                                                                                <NA>             2
14   charset-normalizer                                 ()  C:\ProgramData\anaconda3\envs\adda\lib\site-packages\charset_normalizer    3.1.0  The Real First Universal Charset Detector. Open, modern and actively maintained alternative to Chardet.     https://github.com/Ousret/charset_normalizer                                                        Ahmed TAHRI             ahmed.tahri@cloudnursery.dev           MIT  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                               requests                                                                                                                                                                                                                                                                                                                                                                                                  ()             3
21               Cython                                 ()              C:\ProgramData\anaconda3\envs\adda\lib\site-packages\Cython  0.29.33                                    The Cython compiler for writing C extensions for the Python language.                               http://cython.org/  Robert Bradshaw, Stefan Behnel, Dag Seljebotn, Greg Ewing, et al.                  cython-devel@python.org        Apache  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                          npfastsortcpp                                                                                                                                       ((cElementTree, >=1.0.2-20050302), (coverage, >=7.2.2), (Cython, >=0.29.33), (elementtree, >=1.2.6-20050316), (ipython, >=8.12.0), (lxml, >=4.9.2), (Parser, >=0.1), (Pygments, >=2.14.0), (pythran, >=0.12.1), (runtests, >=0.0.28), (setuptools, >=65.6.3))             3
83               psutil                                 ()              C:\ProgramData\anaconda3\envs\adda\lib\site-packages\psutil    5.9.4                                          Cross-platform lib for process and system monitoring in Python.              https://github.com/giampaolo/psutil                                                   Giampaolo Rodola                       g.rodola@gmail.com  BSD-3-Clause  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                pdmemedit, subprocess-print-and-capture                                                                                                                                                                                                                                                                                                   ((concurrencytest, >=0.1.2), (mock, >=5.0.1), (pip, >=23.0.1), (wheel, >=0.38.4), (wmi, >=1.5.1))             3
90                 pytz                                 ()                C:\ProgramData\anaconda3\envs\adda\lib\site-packages\pytz   2023.2                                                        World timezone definitions, modern and historical                     http://pythonhosted.org/pytz                                                      Stuart Bishop                  stuart@stuartbishop.net           MIT  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                                 pandas                                                                                                                                                                                                                                                                                                                                                           ((sets, >=0.3.2), (setuptools, >=65.6.3))             3
96           setuptools                                 ()          C:\ProgramData\anaconda3\envs\adda\lib\site-packages\setuptools   65.6.3                                  Easily download, build, install, upgrade, and uninstall Python packages               https://github.com/pypa/setuptools                                         Python Packaging Authority                 distutils-sig@python.org                c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                          npfastsortcpp                                                                                                                                                                                                                        ((Cython, >=0.29.33), (dl, >=0.1.0), (docutils, >=0.19), (Jinja2, >=3.1.2), (numpy, >=1.24.2), (railroad, >=0.5.0), (setuptools, >=65.6.3), (trove_classifiers, >=2023.3.9))             3
86             Pygments                                 ()            C:\ProgramData\anaconda3\envs\adda\lib\site-packages\pygments   2.14.0                                             Pygments is a syntax highlighting package written in Python.                            https://pygments.org/                                                       Georg Brandl                         georg@python.org  BSD-2-Clause  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                         ipython, readme-renderer, rich                                                                                                                                                                                                                                          ((chardet, >=5.1.0), (colorama, >=0.4.6), (docutils, >=0.19), (importlib_metadata, >=6.1.0), (Pillow, >=9.5.0), (setuptools, >=65.6.3), (Sphinx, >=6.1.3))             4
115               wheel                                 ()               C:\ProgramData\anaconda3\envs\adda\lib\site-packages\wheel   0.38.4                                                                        A built-package format for Python                    https://github.com/pypa/wheel                                                       Daniel Holth                       dholth@fastmail.fm           MIT  c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  ((setuptools, >=65.6.3),)             4
16             colorama                                 ()            C:\ProgramData\anaconda3\envs\adda\lib\site-packages\colorama    0.4.6                                                                    Cross-platform colored terminal text.                                                                                                                       Jonathan Hartley <tartley@tartley.com>                c:\programdata\anaconda3\envs\adda\lib\site-packages                                                                                                                                                                                                                                         click, ipython                                                                                                                                                                                                                                                                                                                                                          ((contextlib2, >=21.6.0), (mock, >=5.0.1))             5
```
