### Some utility functions to convert / manipulate US crude indicies which mid-month expiry
from commodutil import forwards
import pandas as pd
from pylim import lim


# a basic rudimentary example for the idea behind the calculation is shown here:
# https://github.com/aeorxc/pylim/raw/master/doc/us_curdes_lls_example.xlsx


def generate_symbol_list(symbol: str, start_year: int):
    """Given a symbol generate a list of timeseries which are stored in LIM
     as separate monthly contracts.
     eg PA0004066.2 in folder TopRelation:Energy:Crudes:Lls:Argus:Absolute:Monthly
    """
    postfix = []
    for m in forwards.futures_month_conv.values():
        for year in range(start_year, pd.to_datetime("today").year + 1):
            postfix.append('%s%s' % (year, m))
    symbols = ['%s_%s' % (symbol, x) for x in postfix]
    valid_symbols = lim.relations(*tuple(symbols))
    valid_symbols = valid_symbols.T
    valid_symbols = valid_symbols[valid_symbols['type'] == 'NORMAL']
    return valid_symbols.index


def cal_monthly_value(df, symbol, year, month):
    try:
        symbolx = '%s_%s%s' % (symbol, str(year), forwards.futures_month_conv[month])
        s = df[symbolx].dropna().tail(1).copy().iloc[0]
    except IndexError:
        return None
    return s


def cal_tmf_series(symbol: str, start_year: int):
    valid_symbols = generate_symbol_list(symbol, start_year)
    df = lim.series(valid_symbols)[str(start_year):]
    r = df.resample('MS').mean().copy()
    r['TMF'] = r.apply(lambda x: cal_monthly_value(df, symbol, x.name.year, x.name.month), 1)
    return r



