# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class RiskManagementSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'trading_areas': 'list[TradingArea]',
        'position_limits': 'list[PositionLimit]',
        'cash_limits': 'list[CashLimit]',
        'otr_limits': 'list[OtrLimit]',
        'order_action_quota_limit': 'list[OrderActionQuotaLimit]'
    }

    attribute_map = {
        'id': 'id',
        'trading_areas': 'trading_areas',
        'position_limits': 'position_limits',
        'cash_limits': 'cash_limits',
        'otr_limits': 'otr_limits',
        'order_action_quota_limit': 'order_action_quota_limit'
    }

    def __init__(self, id=None, trading_areas=None, position_limits=None, cash_limits=None, otr_limits=None, order_action_quota_limit=None, local_vars_configuration=None):  # noqa: E501
        """RiskManagementSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._trading_areas = None
        self._position_limits = None
        self._cash_limits = None
        self._otr_limits = None
        self._order_action_quota_limit = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if trading_areas is not None:
            self.trading_areas = trading_areas
        if position_limits is not None:
            self.position_limits = position_limits
        if cash_limits is not None:
            self.cash_limits = cash_limits
        if otr_limits is not None:
            self.otr_limits = otr_limits
        if order_action_quota_limit is not None:
            self.order_action_quota_limit = order_action_quota_limit

    @property
    def id(self):
        """Gets the id of this RiskManagementSettings.  # noqa: E501


        :return: The id of this RiskManagementSettings.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this RiskManagementSettings.


        :param id: The id of this RiskManagementSettings.  # noqa: E501
        :type id: str
        """

        self._id = id

    @property
    def trading_areas(self):
        """Gets the trading_areas of this RiskManagementSettings.  # noqa: E501


        :return: The trading_areas of this RiskManagementSettings.  # noqa: E501
        :rtype: list[TradingArea]
        """
        return self._trading_areas

    @trading_areas.setter
    def trading_areas(self, trading_areas):
        """Sets the trading_areas of this RiskManagementSettings.


        :param trading_areas: The trading_areas of this RiskManagementSettings.  # noqa: E501
        :type trading_areas: list[TradingArea]
        """

        self._trading_areas = trading_areas

    @property
    def position_limits(self):
        """Gets the position_limits of this RiskManagementSettings.  # noqa: E501


        :return: The position_limits of this RiskManagementSettings.  # noqa: E501
        :rtype: list[PositionLimit]
        """
        return self._position_limits

    @position_limits.setter
    def position_limits(self, position_limits):
        """Sets the position_limits of this RiskManagementSettings.


        :param position_limits: The position_limits of this RiskManagementSettings.  # noqa: E501
        :type position_limits: list[PositionLimit]
        """

        self._position_limits = position_limits

    @property
    def cash_limits(self):
        """Gets the cash_limits of this RiskManagementSettings.  # noqa: E501


        :return: The cash_limits of this RiskManagementSettings.  # noqa: E501
        :rtype: list[CashLimit]
        """
        return self._cash_limits

    @cash_limits.setter
    def cash_limits(self, cash_limits):
        """Sets the cash_limits of this RiskManagementSettings.


        :param cash_limits: The cash_limits of this RiskManagementSettings.  # noqa: E501
        :type cash_limits: list[CashLimit]
        """

        self._cash_limits = cash_limits

    @property
    def otr_limits(self):
        """Gets the otr_limits of this RiskManagementSettings.  # noqa: E501


        :return: The otr_limits of this RiskManagementSettings.  # noqa: E501
        :rtype: list[OtrLimit]
        """
        return self._otr_limits

    @otr_limits.setter
    def otr_limits(self, otr_limits):
        """Sets the otr_limits of this RiskManagementSettings.


        :param otr_limits: The otr_limits of this RiskManagementSettings.  # noqa: E501
        :type otr_limits: list[OtrLimit]
        """

        self._otr_limits = otr_limits

    @property
    def order_action_quota_limit(self):
        """Gets the order_action_quota_limit of this RiskManagementSettings.  # noqa: E501


        :return: The order_action_quota_limit of this RiskManagementSettings.  # noqa: E501
        :rtype: list[OrderActionQuotaLimit]
        """
        return self._order_action_quota_limit

    @order_action_quota_limit.setter
    def order_action_quota_limit(self, order_action_quota_limit):
        """Sets the order_action_quota_limit of this RiskManagementSettings.


        :param order_action_quota_limit: The order_action_quota_limit of this RiskManagementSettings.  # noqa: E501
        :type order_action_quota_limit: list[OrderActionQuotaLimit]
        """

        self._order_action_quota_limit = order_action_quota_limit

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RiskManagementSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RiskManagementSettings):
            return True

        return self.to_dict() != other.to_dict()
