# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


try:
    from inspect import getfullargspec
except ImportError:
    from inspect import getargspec as getfullargspec
import pprint
import re  # noqa: F401
import six

from powerbot_client.configuration import Configuration


class DeliveryArea(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'eic': 'str',
        'market_eic': 'str',
        'name': 'str',
        'long_name': 'str',
        'state': 'str',
        'time_zone': 'str',
        'currency': 'str',
        'products': 'list[str]',
        'product_details': 'list[ProductInformation]'
    }

    attribute_map = {
        'eic': 'eic',
        'market_eic': 'market_eic',
        'name': 'name',
        'long_name': 'long_name',
        'state': 'state',
        'time_zone': 'time_zone',
        'currency': 'currency',
        'products': 'products',
        'product_details': 'product_details'
    }

    def __init__(self, eic=None, market_eic=None, name=None, long_name=None, state=None, time_zone=None, currency=None, products=None, product_details=None, local_vars_configuration=None):  # noqa: E501
        """DeliveryArea - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration.get_default_copy()
        self.local_vars_configuration = local_vars_configuration

        self._eic = None
        self._market_eic = None
        self._name = None
        self._long_name = None
        self._state = None
        self._time_zone = None
        self._currency = None
        self._products = None
        self._product_details = None
        self.discriminator = None

        self.eic = eic
        if market_eic is not None:
            self.market_eic = market_eic
        self.name = name
        if long_name is not None:
            self.long_name = long_name
        self.state = state
        if time_zone is not None:
            self.time_zone = time_zone
        if currency is not None:
            self.currency = currency
        self.products = products
        if product_details is not None:
            self.product_details = product_details

    @property
    def eic(self):
        """Gets the eic of this DeliveryArea.  # noqa: E501

        The Energy Identification Code of the delivery area  # noqa: E501

        :return: The eic of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._eic

    @eic.setter
    def eic(self, eic):
        """Sets the eic of this DeliveryArea.

        The Energy Identification Code of the delivery area  # noqa: E501

        :param eic: The eic of this DeliveryArea.  # noqa: E501
        :type eic: str
        """
        if self.local_vars_configuration.client_side_validation and eic is None:  # noqa: E501
            raise ValueError("Invalid value for `eic`, must not be `None`")  # noqa: E501

        self._eic = eic

    @property
    def market_eic(self):
        """Gets the market_eic of this DeliveryArea.  # noqa: E501

        The Energy Identification Code of the market area (only available for M7 exchanges)  # noqa: E501

        :return: The market_eic of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._market_eic

    @market_eic.setter
    def market_eic(self, market_eic):
        """Sets the market_eic of this DeliveryArea.

        The Energy Identification Code of the market area (only available for M7 exchanges)  # noqa: E501

        :param market_eic: The market_eic of this DeliveryArea.  # noqa: E501
        :type market_eic: str
        """

        self._market_eic = market_eic

    @property
    def name(self):
        """Gets the name of this DeliveryArea.  # noqa: E501

        The name of the delivery area  # noqa: E501

        :return: The name of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this DeliveryArea.

        The name of the delivery area  # noqa: E501

        :param name: The name of this DeliveryArea.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def long_name(self):
        """Gets the long_name of this DeliveryArea.  # noqa: E501

        The long name of the delivery area (only available for M7 exchanges)  # noqa: E501

        :return: The long_name of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._long_name

    @long_name.setter
    def long_name(self, long_name):
        """Sets the long_name of this DeliveryArea.

        The long name of the delivery area (only available for M7 exchanges)  # noqa: E501

        :param long_name: The long_name of this DeliveryArea.  # noqa: E501
        :type long_name: str
        """

        self._long_name = long_name

    @property
    def state(self):
        """Gets the state of this DeliveryArea.  # noqa: E501

        The state of the delivery area, possible values are  * ACTI: The delivery area is active. It is possible to trade in that area.  * SUS: The delivery area is deactivated (hibernated). Trading in that delivery area is not possible.  * DELE: The delivery area was deleted. Trading is not possible.  # noqa: E501

        :return: The state of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this DeliveryArea.

        The state of the delivery area, possible values are  * ACTI: The delivery area is active. It is possible to trade in that area.  * SUS: The delivery area is deactivated (hibernated). Trading in that delivery area is not possible.  * DELE: The delivery area was deleted. Trading is not possible.  # noqa: E501

        :param state: The state of this DeliveryArea.  # noqa: E501
        :type state: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError("Invalid value for `state`, must not be `None`")  # noqa: E501
        allowed_values = ["ACTI", "SUSP", "DELE"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and state not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `state` ({0}), must be one of {1}"  # noqa: E501
                .format(state, allowed_values)
            )

        self._state = state

    @property
    def time_zone(self):
        """Gets the time_zone of this DeliveryArea.  # noqa: E501

        The tz database ID of the delivery area. (`null` if the user doesn't have access to any of the delivery area products)  # noqa: E501

        :return: The time_zone of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """Sets the time_zone of this DeliveryArea.

        The tz database ID of the delivery area. (`null` if the user doesn't have access to any of the delivery area products)  # noqa: E501

        :param time_zone: The time_zone of this DeliveryArea.  # noqa: E501
        :type time_zone: str
        """

        self._time_zone = time_zone

    @property
    def currency(self):
        """Gets the currency of this DeliveryArea.  # noqa: E501

        ISO 4217 currency code of the delivery area. (`null` if the user doesn't have access to any of the delivery area products)  # noqa: E501

        :return: The currency of this DeliveryArea.  # noqa: E501
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """Sets the currency of this DeliveryArea.

        ISO 4217 currency code of the delivery area. (`null` if the user doesn't have access to any of the delivery area products)  # noqa: E501

        :param currency: The currency of this DeliveryArea.  # noqa: E501
        :type currency: str
        """

        self._currency = currency

    @property
    def products(self):
        """Gets the products of this DeliveryArea.  # noqa: E501

        Products of the delivery area the exchange user has access to  # noqa: E501

        :return: The products of this DeliveryArea.  # noqa: E501
        :rtype: list[str]
        """
        return self._products

    @products.setter
    def products(self, products):
        """Sets the products of this DeliveryArea.

        Products of the delivery area the exchange user has access to  # noqa: E501

        :param products: The products of this DeliveryArea.  # noqa: E501
        :type products: list[str]
        """
        if self.local_vars_configuration.client_side_validation and products is None:  # noqa: E501
            raise ValueError("Invalid value for `products`, must not be `None`")  # noqa: E501

        self._products = products

    @property
    def product_details(self):
        """Gets the product_details of this DeliveryArea.  # noqa: E501

        Products of the delivery area the exchange user has access to.  # noqa: E501

        :return: The product_details of this DeliveryArea.  # noqa: E501
        :rtype: list[ProductInformation]
        """
        return self._product_details

    @product_details.setter
    def product_details(self, product_details):
        """Sets the product_details of this DeliveryArea.

        Products of the delivery area the exchange user has access to.  # noqa: E501

        :param product_details: The product_details of this DeliveryArea.  # noqa: E501
        :type product_details: list[ProductInformation]
        """

        self._product_details = product_details

    def to_dict(self, serialize=False):
        """Returns the model properties as a dict"""
        result = {}

        def convert(x):
            if hasattr(x, "to_dict"):
                args = getfullargspec(x.to_dict).args
                if len(args) == 1:
                    return x.to_dict()
                else:
                    return x.to_dict(serialize)
            else:
                return x

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            attr = self.attribute_map.get(attr, attr) if serialize else attr
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: convert(x),
                    value
                ))
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], convert(item[1])),
                    value.items()
                ))
            else:
                result[attr] = convert(value)

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, DeliveryArea):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, DeliveryArea):
            return True

        return self.to_dict() != other.to_dict()
