# coding: utf-8

"""
    PowerBot - Webservice for algotrading

    # TERMS AND CONDITIONS The PowerBot system provides B2B services for trading at intraday power markets. By using the PowerBot service, each user agrees to the terms and conditions of this licence: 1. The user confirms that they are familiar with the exchanges trading system and all relevant rules, is professionally qualified and in possession of a trading license for the relevant exchange. 2. The user will comply with the exchanges market rules (e.g. [EPEX Spot Market Rules](https://www.epexspot.com/en/downloads#rules-fees-processes) or [Nord Pool Market Rules](https://www.nordpoolgroup.com/trading/Rules-and-regulations/)) and will not endanger the exchange system at any time with heavy load from trading algorithms or by other use. 3. The user is aware of limits imposed by the exchange. 4. The user is solely liable for actions resulting from the use of PowerBot.   # INTRODUCTION PowerBot is a web-based software service enabling algorithmic trading on intraday power exchanges such as EPEX, Nord Pool, HUPX, BSP Southpool or TGE. The service is straightforward to integrate in an existing software environment and provides a variety of programming interfaces for development of individual trading algorithms and software tools. Besides enabling fully automated intraday trading, it can be used to create tools for human traders providing relevant information and trading opportunities or can be integrated in existing software tools. For further details see https://www.powerbot-trading.com  ## Knowledge Base In addition to this API guide, please find the documentation at https://docs.powerbot-trading.com - the password will be provided by the PowerBot team. If not, please reach out to us at support@powerbot-trading.com  ## Endpoints The PowerBot service is available at the following REST endpoints:  | Instance                | Base URL for REST Endpoints                                           | |-------------------------|-----------------------------------------------------------------------| | Test (EPEX)             | https://staging.powerbot-trading.com/playground/epex/v2/api           | | Test (Nord Pool)        | https://staging.powerbot-trading.com/playground/nordpool/v2/api       | | Test (HUPX)             | https://staging.powerbot-trading.com/playground/hupx/v2/api           | | Test (BSP Southpool)    | https://staging.powerbot-trading.com/playground/southpool/v2/api      | | Test (TGE)              | https://staging.powerbot-trading.com/playground/tge/v2/api            | | Test (IBEX)             | https://staging.powerbot-trading.com/playground/ibex/v2/api           | | Test (CROPEX)           | https://staging.powerbot-trading.com/playground/cropex/v2/api         | | Staging, Production     | Provided on request                                                   |  Access to endpoints is secured via an API Key, which needs to be passed as an \"api_key\" header in each request.   Notes on API Keys:  * API keys are specific to Test, Staging or Production.  * API keys are generated by the system administrator and need to be requested.  ## How to generate API clients (libraries) This OpenAPI specification can be used to generate API clients (programming libraries) for a wide range of programming languages using tools like [OpenAPI Generator](https://openapi-generator.tech/). A detailed guide can be found in the [knowledge base](https://docs.powerbot-trading.com/articles/getting-started/generating-clients/).  ## PowerBot Python client For Python, a ready-made client is also available on PyPI and can be downloaded locally via:  ```shell   pip install powerbot-client ```  ## Errors The API uses standard HTTP status codes to indicate the success or failure of the API call. The body of the response will be in JSON format as follows:  ``` {   \"message\": \"... an error message ...\" } ```  ## Paging The API uses offset and limit parameters for paged operations. An X-Total-Count header is added to responses to indicate the total number of items in a paged response.  ## Cross-Origin Resource Sharing This API features Cross-Origin Resource Sharing (CORS) implemented in compliance with  [W3C spec](https://www.w3.org/TR/cors/). This allows cross-domain communication from the browser. All responses have a wildcard same-origin which makes them completely public and accessible to everyone, including any code on any site.  ## API Rate Limiting The API limits the number of concurrent calls to 50 - when that limit is reached, the client will receive 503 http status codes (service unavailable) with the following text:  ``` {   \"message\": \"API rate limit exceeded\" } ``` Clients should ensure that they stay within the limit for concurrent API calls.    ## Additional code samples Additional information and code samples demonstrating the use of the API can be found at https://github.com/powerbot-trading.  # noqa: E501

    The version of the OpenAPI document: 2.10.0
    Contact: office@powerbot-trading.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from powerbot_client.api_client import ApiClient
from powerbot_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ContractApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calculate_bulk_statistics(self, contract_duration_minutes, delivery_area, delivery_from, delivery_to, **kwargs):  # noqa: E501
        """Get contract statistics in bulk  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period to restrict the calculation to a given amount of last traded quantity. Per default, only active or recently active contracts with be included in the calculation. Historic contracts matching the given delivery period can be included with setting the respective toggle. Please note that delivery_start and delivery_end have to be within 24 hours. Cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s). The quantity of only one of those trades will be taken into account, if a trades matches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_bulk_statistics(contract_duration_minutes, delivery_area, delivery_from, delivery_to, async_req=True)
        >>> result = thread.get()

        :param contract_duration_minutes: the duration of the contracts to calculate statistics for (required)
        :type contract_duration_minutes: int
        :param delivery_area: (required)
        :type delivery_area: list[str]
        :param delivery_from: (required)
        :type delivery_from: datetime
        :param delivery_to: (required)
        :type delivery_to: datetime
        :param execution_from_offset_minutes: only consider trades that happened after or at (delivery start - n minutes)
        :type execution_from_offset_minutes: int
        :param execution_to_offset_minutes: only consider trades that happened before (delivery start - n minutes)
        :type execution_to_offset_minutes: int
        :param limit_to_last_mw:
        :type limit_to_last_mw: float
        :param include_historic_data: If this option is enabled, statistics will also be calculated for expired contracts that match the given delivery period.
        :type include_historic_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: BulkContractStatistics
        """
        kwargs['_return_http_data_only'] = True
        return self.calculate_bulk_statistics_with_http_info(contract_duration_minutes, delivery_area, delivery_from, delivery_to, **kwargs)  # noqa: E501

    def calculate_bulk_statistics_with_http_info(self, contract_duration_minutes, delivery_area, delivery_from, delivery_to, **kwargs):  # noqa: E501
        """Get contract statistics in bulk  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period to restrict the calculation to a given amount of last traded quantity. Per default, only active or recently active contracts with be included in the calculation. Historic contracts matching the given delivery period can be included with setting the respective toggle. Please note that delivery_start and delivery_end have to be within 24 hours. Cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s). The quantity of only one of those trades will be taken into account, if a trades matches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_bulk_statistics_with_http_info(contract_duration_minutes, delivery_area, delivery_from, delivery_to, async_req=True)
        >>> result = thread.get()

        :param contract_duration_minutes: the duration of the contracts to calculate statistics for (required)
        :type contract_duration_minutes: int
        :param delivery_area: (required)
        :type delivery_area: list[str]
        :param delivery_from: (required)
        :type delivery_from: datetime
        :param delivery_to: (required)
        :type delivery_to: datetime
        :param execution_from_offset_minutes: only consider trades that happened after or at (delivery start - n minutes)
        :type execution_from_offset_minutes: int
        :param execution_to_offset_minutes: only consider trades that happened before (delivery start - n minutes)
        :type execution_to_offset_minutes: int
        :param limit_to_last_mw:
        :type limit_to_last_mw: float
        :param include_historic_data: If this option is enabled, statistics will also be calculated for expired contracts that match the given delivery period.
        :type include_historic_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(BulkContractStatistics, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_duration_minutes',
            'delivery_area',
            'delivery_from',
            'delivery_to',
            'execution_from_offset_minutes',
            'execution_to_offset_minutes',
            'limit_to_last_mw',
            'include_historic_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_bulk_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_duration_minutes' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_duration_minutes') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_duration_minutes` when calling `calculate_bulk_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `calculate_bulk_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_from' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_from') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_from` when calling `calculate_bulk_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_to' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_to') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_to` when calling `calculate_bulk_statistics`")  # noqa: E501

        if self.api_client.client_side_validation and 'execution_from_offset_minutes' in local_var_params and local_var_params['execution_from_offset_minutes'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `execution_from_offset_minutes` when calling `calculate_bulk_statistics`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'execution_to_offset_minutes' in local_var_params and local_var_params['execution_to_offset_minutes'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `execution_to_offset_minutes` when calling `calculate_bulk_statistics`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('contract_duration_minutes') is not None:  # noqa: E501
            query_params.append(('contract_duration_minutes', local_var_params['contract_duration_minutes']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
            collection_formats['delivery_area'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('execution_from_offset_minutes') is not None:  # noqa: E501
            query_params.append(('execution_from_offset_minutes', local_var_params['execution_from_offset_minutes']))  # noqa: E501
        if local_var_params.get('execution_to_offset_minutes') is not None:  # noqa: E501
            query_params.append(('execution_to_offset_minutes', local_var_params['execution_to_offset_minutes']))  # noqa: E501
        if local_var_params.get('limit_to_last_mw') is not None:  # noqa: E501
            query_params.append(('limit_to_last_mw', local_var_params['limit_to_last_mw']))  # noqa: E501
        if local_var_params.get('include_historic_data') is not None:  # noqa: E501
            query_params.append(('includeHistoricData', local_var_params['include_historic_data']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "BulkContractStatistics",
        }

        return self.api_client.call_api(
            '/contracts/bulkstatistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def calculate_statistics(self, delivery_area, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Get contract statistics  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period to restrict the calculation to a given amount of last traded quantity. Per default, only active or recently active contracts will be included in the calculation. Historic contracts matching the given delivery period can be included with setting the respective toggle. Please note that delivery_start and delivery_end have to be within 24 hours. Cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s). The quantity of only one of those trades will be taken into account, if a trades matches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_statistics(delivery_area, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param delivery_area: (required)
        :type delivery_area: list[str]
        :param delivery_start: (required)
        :type delivery_start: datetime
        :param delivery_end: (required)
        :type delivery_end: datetime
        :param execution_from:
        :type execution_from: datetime
        :param execution_to:
        :type execution_to: datetime
        :param limit_to_last_mw:
        :type limit_to_last_mw: float
        :param include_historic_data: If this option is enabled, statistics will also be calculated for expired contracts that match the given delivery period.
        :type include_historic_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: ContractStatistics
        """
        kwargs['_return_http_data_only'] = True
        return self.calculate_statistics_with_http_info(delivery_area, delivery_start, delivery_end, **kwargs)  # noqa: E501

    def calculate_statistics_with_http_info(self, delivery_area, delivery_start, delivery_end, **kwargs):  # noqa: E501
        """Get contract statistics  # noqa: E501

        Calculates the average price and volume of public trades executed for a given delivery interval for reference price and index calculation. Allows you to filter for public trades executed within a certain time period to restrict the calculation to a given amount of last traded quantity. Per default, only active or recently active contracts will be included in the calculation. Historic contracts matching the given delivery period can be included with setting the respective toggle. Please note that delivery_start and delivery_end have to be within 24 hours. Cross border trades are taken into account if either the buy or sell leg of the trade is in the specified delivery area(s). The quantity of only one of those trades will be taken into account, if a trades matches.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.calculate_statistics_with_http_info(delivery_area, delivery_start, delivery_end, async_req=True)
        >>> result = thread.get()

        :param delivery_area: (required)
        :type delivery_area: list[str]
        :param delivery_start: (required)
        :type delivery_start: datetime
        :param delivery_end: (required)
        :type delivery_end: datetime
        :param execution_from:
        :type execution_from: datetime
        :param execution_to:
        :type execution_to: datetime
        :param limit_to_last_mw:
        :type limit_to_last_mw: float
        :param include_historic_data: If this option is enabled, statistics will also be calculated for expired contracts that match the given delivery period.
        :type include_historic_data: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(ContractStatistics, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'delivery_area',
            'delivery_start',
            'delivery_end',
            'execution_from',
            'execution_to',
            'limit_to_last_mw',
            'include_historic_data'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method calculate_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `calculate_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_start' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_start') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_start` when calling `calculate_statistics`")  # noqa: E501
        # verify the required parameter 'delivery_end' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_end') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_end` when calling `calculate_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
            collection_formats['delivery_area'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('execution_from') is not None:  # noqa: E501
            query_params.append(('execution_from', local_var_params['execution_from']))  # noqa: E501
        if local_var_params.get('execution_to') is not None:  # noqa: E501
            query_params.append(('execution_to', local_var_params['execution_to']))  # noqa: E501
        if local_var_params.get('limit_to_last_mw') is not None:  # noqa: E501
            query_params.append(('limit_to_last_mw', local_var_params['limit_to_last_mw']))  # noqa: E501
        if local_var_params.get('include_historic_data') is not None:  # noqa: E501
            query_params.append(('includeHistoricData', local_var_params['include_historic_data']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "ContractStatistics",
        }

        return self.api_client.call_api(
            '/contracts/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def find_contracts(self, **kwargs):  # noqa: E501
        """Find contracts  # noqa: E501

        This method allows you to find active or historical contracts based on their exact delivery_start and delivery_end time (UTC) and lets you determine their contract_id. Using delivery_from and delivery_to, the contracts can be further limited to a given timespan.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_contracts(async_req=True)
        >>> result = thread.get()

        :param contract_id:
        :type contract_id: list[str]
        :param delivery_start: Limit the contracts to those with the given delivery start date.
        :type delivery_start: datetime
        :param delivery_end: Limit the contracts to those with the given delivery end date.
        :type delivery_end: datetime
        :param delivery_from: Limits the contracts to those with a delivery start date >= delivery_from.
        :type delivery_from: datetime
        :param delivery_to: Limits the contracts to those with a delivery end date <= delivery_to.
        :type delivery_to: datetime
        :param delivery_areas: Limit the search to contracts that belong to any of the specified delivery areas.
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ContractItem]
        """
        kwargs['_return_http_data_only'] = True
        return self.find_contracts_with_http_info(**kwargs)  # noqa: E501

    def find_contracts_with_http_info(self, **kwargs):  # noqa: E501
        """Find contracts  # noqa: E501

        This method allows you to find active or historical contracts based on their exact delivery_start and delivery_end time (UTC) and lets you determine their contract_id. Using delivery_from and delivery_to, the contracts can be further limited to a given timespan.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.find_contracts_with_http_info(async_req=True)
        >>> result = thread.get()

        :param contract_id:
        :type contract_id: list[str]
        :param delivery_start: Limit the contracts to those with the given delivery start date.
        :type delivery_start: datetime
        :param delivery_end: Limit the contracts to those with the given delivery end date.
        :type delivery_end: datetime
        :param delivery_from: Limits the contracts to those with a delivery start date >= delivery_from.
        :type delivery_from: datetime
        :param delivery_to: Limits the contracts to those with a delivery end date <= delivery_to.
        :type delivery_to: datetime
        :param delivery_areas: Limit the search to contracts that belong to any of the specified delivery areas.
        :type delivery_areas: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ContractItem], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_start',
            'delivery_end',
            'delivery_from',
            'delivery_to',
            'delivery_areas'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_contracts" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('contract_id') is not None:  # noqa: E501
            query_params.append(('contract_id', local_var_params['contract_id']))  # noqa: E501
            collection_formats['contract_id'] = 'csv'  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('delivery_areas') is not None:  # noqa: E501
            query_params.append(('delivery_areas', local_var_params['delivery_areas']))  # noqa: E501
            collection_formats['delivery_areas'] = 'multi'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[ContractItem]",
        }

        return self.api_client.call_api(
            '/contracts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_contract_history(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract history  # noqa: E501

        This method allows you to retrieve the history of a contract in a delivery area in the form of revisions (which include delta and sometimes full orderbook updates). When querying with a list of portfolios, you can retrieve all your own trades and signals that belong to the contract. When querying with a timestamp in \"as_of\", you can retrieve the contract history at a given point in time, or you can request a set of revisions.  If with_orders is set to true, the revisions will include new and deleted orders that belong to the revision (if requesting revisions) in delta-format or the full orderbook if requesting a historical version using \"as_of\".  Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract_history(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param from_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :type from_revision: int
        :param to_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :type to_revision: int
        :param as_of: Contract history as_of given point in time. Cannot be combined together with from_revision and to_revision.
        :type as_of: datetime
        :param with_owntrades: If set to true, the own trades which happened on that revision are returned.
        :type with_owntrades: bool
        :param with_signals: If set to true, the signals valid for that revision are returned.
        :type with_signals: bool
        :param with_orders: If set to true, details about bids/asks are returned
        :type with_orders: bool
        :param sort_by: Sorting options are \"ASC\" and \"DESC\" for the fields \"revisionNo\" and \"as_of\"
        :type sort_by: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[ContractHistoryItem]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_contract_history_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501

    def get_contract_history_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract history  # noqa: E501

        This method allows you to retrieve the history of a contract in a delivery area in the form of revisions (which include delta and sometimes full orderbook updates). When querying with a list of portfolios, you can retrieve all your own trades and signals that belong to the contract. When querying with a timestamp in \"as_of\", you can retrieve the contract history at a given point in time, or you can request a set of revisions.  If with_orders is set to true, the revisions will include new and deleted orders that belong to the revision (if requesting revisions) in delta-format or the full orderbook if requesting a historical version using \"as_of\".  Please note that this feature uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract_history_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param from_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :type from_revision: int
        :param to_revision: Revisions start with 0, each change increments it by 1. Please note that only up to 150 revisions at a time can be fetched.
        :type to_revision: int
        :param as_of: Contract history as_of given point in time. Cannot be combined together with from_revision and to_revision.
        :type as_of: datetime
        :param with_owntrades: If set to true, the own trades which happened on that revision are returned.
        :type with_owntrades: bool
        :param with_signals: If set to true, the signals valid for that revision are returned.
        :type with_signals: bool
        :param with_orders: If set to true, details about bids/asks are returned
        :type with_orders: bool
        :param sort_by: Sorting options are \"ASC\" and \"DESC\" for the fields \"revisionNo\" and \"as_of\"
        :type sort_by: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[ContractHistoryItem], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_area',
            'offset',
            'limit',
            'portfolio_id',
            'from_revision',
            'to_revision',
            'as_of',
            'with_owntrades',
            'with_signals',
            'with_orders',
            'sort_by'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contract_history" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_id` when calling `get_contract_history`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_contract_history`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_contract_history`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_contract_history`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_contract_history`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'contract_id' in local_var_params:
            path_params['contract_id'] = local_var_params['contract_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('from_revision') is not None:  # noqa: E501
            query_params.append(('from_revision', local_var_params['from_revision']))  # noqa: E501
        if local_var_params.get('to_revision') is not None:  # noqa: E501
            query_params.append(('to_revision', local_var_params['to_revision']))  # noqa: E501
        if local_var_params.get('as_of') is not None:  # noqa: E501
            query_params.append(('as_of', local_var_params['as_of']))  # noqa: E501
        if local_var_params.get('with_owntrades') is not None:  # noqa: E501
            query_params.append(('with_owntrades', local_var_params['with_owntrades']))  # noqa: E501
        if local_var_params.get('with_signals') is not None:  # noqa: E501
            query_params.append(('with_signals', local_var_params['with_signals']))  # noqa: E501
        if local_var_params.get('with_orders') is not None:  # noqa: E501
            query_params.append(('with_orders', local_var_params['with_orders']))  # noqa: E501
        if local_var_params.get('sort_by') is not None:  # noqa: E501
            query_params.append(('sort_by', local_var_params['sort_by']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[ContractHistoryItem]",
        }

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/history', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_contract_signals(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract signals  # noqa: E501

        This method allows you to retrieve your trading signals (your positions or custom data like weather, fundamental data etc.) valid for a contract in a delivery area for one or more portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract_signals(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[Signal]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_contract_signals_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501

    def get_contract_signals_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract signals  # noqa: E501

        This method allows you to retrieve your trading signals (your positions or custom data like weather, fundamental data etc.) valid for a contract in a delivery area for one or more portfolios.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_contract_signals_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[Signal], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_area',
            'portfolio_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_contract_signals" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_id` when calling `get_contract_signals`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_contract_signals`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in local_var_params:
            path_params['contract_id'] = local_var_params['contract_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[Signal]",
        }

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/signals', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_limits(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract portfolio information  # noqa: E501

        Calculates the current positions (portfolio-information) for a given contract. The response contains information about   - the currency of all parameters   - order-to-trade-ratios for the exchange, tenant and portfolio (DEPRECATED: replaced by order action quota)   - cash-positions   - net-positions   - order-action-quota-limits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_limits(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: RiskSettingsAndPortfolioInformation
        """
        kwargs['_return_http_data_only'] = True
        return self.get_limits_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501

    def get_limits_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract portfolio information  # noqa: E501

        Calculates the current positions (portfolio-information) for a given contract. The response contains information about   - the currency of all parameters   - order-to-trade-ratios for the exchange, tenant and portfolio (DEPRECATED: replaced by order action quota)   - cash-positions   - net-positions   - order-action-quota-limits  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_limits_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: The unique id of the contract (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param portfolio_id:
        :type portfolio_id: list[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(RiskSettingsAndPortfolioInformation, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_area',
            'portfolio_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_limits" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_id` when calling `get_limits`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_limits`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in local_var_params:
            path_params['contract_id'] = local_var_params['contract_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "RiskSettingsAndPortfolioInformation",
        }

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/portfolio-information', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_order_books(self, **kwargs):  # noqa: E501
        """Get all orderbooks  # noqa: E501

        Shows the public order book for the requested products (or all available products) for a given delivery_area. Default delivery area will be applied if left blank and default is set. This request will by default only deliver the order book statistics (best bid, best ask, last etc.) and does not include the full orderbook depth. If you wish to retrieve the full order book you can set with_order_details to \"true\". However, this should only be done if absolutely necessary, as it will negatively impact the performance. Alternatively you can request the full order book with GET /contract/contract_id/delivery_area/orders.  The order book containts portfolio relevant data (like net_position, signals etc.) and can thus be filtered by a list of portfolio IDs. Setting the limit parameter allows to limit the number of entries returned per request (sorted by ascending delivery time).  The filter with_bid_or_ask_only returns only non empty order books. If past_hours is set, the orderbook will include historical contracts that have been closed in the last X hours.  Using delivery_from and delivery_to, the order book can be further limited to a given timespan. If used in conjunction with past_hours, delivery_from has to be after the time defined by past_hours (now - past_hours < delivery_from < delivery_to).  This request uses caching, if the response on multiple requests does not change, a cached response is returned. In this case, the field \"etag\" in the response-header does not change.  For the best performance and to get the most out of caching, we urge you to set the parameter \"with_portfolio_information\" to false and request the portfolio_information only when you need it via GET/contract/{contract_id}/{delivery_area}/portfolio-information.  The parameters \"with_signals\", \"with_risk_settings\" and \"with_products\" also influence how often a cached response is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order_books(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param product: The list of products (e.g. Intraday_Power_D,XBID_Hour_Power) *separated by a comma*, for which the orderbook(s) should be retrieved; leave blank if you want all available orderbooks
        :type product: str
        :param with_bid_or_ask_only: If set to true, the returned orderbook will contain only contracts which contain at least one active bid or ask
        :type with_bid_or_ask_only: bool
        :param with_signals: If set to true, the returned orderbook will contain the signals applicable for the contracts
        :type with_signals: bool
        :param contract_id: limit the orderbook to an array of certain contracts only
        :type contract_id: list[str]
        :param contract_name: limit the orderbook to a certain contract name only
        :type contract_name: str
        :param delivery_start: limit the orderbook to those contracts with the given delivery start date
        :type delivery_start: datetime
        :param delivery_end: limit the orderbook to those contracts with the given delivery end date
        :type delivery_end: datetime
        :param delivery_within: limit the orderbook to those contracts having a delivery start/end date which starts before and ends after the given parameter
        :type delivery_within: datetime
        :param past_hours: The number of hours to look into the past in the orderbook. If this parameter is set, historic closed contracts are contained in the orderbook as well. Can't be used in conjunction with delivery_from.
        :type past_hours: int
        :param delivery_area: The EIC of the delivery area of the orderbook
        :type delivery_area: str
        :param delivery_from: Limits the orderbook to those contracts with a delivery start date >= delivery_from. When used in conjunction with past_hours, has to be after the time defined by past_hours (delivery_from > now - past_hours).
        :type delivery_from: datetime
        :param delivery_to: Limits the orderbook to those contracts with a delivery end date <= delivery_to.
        :type delivery_to: datetime
        :param with_order_details: If set to true, the returned orderbook will contain all current bids and asks of each contract (full orderbook depth). *Heads up* We generally recommend to request the full orderbook depth on a per contract basis when orderbook-changed notifications are received via websocket. If you need the full orderbook depth for all contracts at once more frequently, please consider using full orderbook snapshots via websocket.
        :type with_order_details: bool
        :param contract_type: **PDC**: (default) the order book only includes predefined contracts, i.e. the normal contracts generated by the backend  UDC: the order book only includes block products, which were created as the result of a block order submitted by a member  ALL: the order book contains both, PDC and UDC contracts
        :type contract_type: ContractType
        :param with_portfolio_information: If set to true, the portfolio_information is included in the response. Set to false to optimize caching.
        :type with_portfolio_information: bool
        :param with_risk_settings: If set to true, the risk_setting of the portfolio are included in the response. Set to false to optimize caching.
        :type with_risk_settings: bool
        :param with_products: If set to true, the available products are included in the response. Set to false to optimize caching.
        :type with_products: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: OrderBooks
        """
        kwargs['_return_http_data_only'] = True
        return self.get_order_books_with_http_info(**kwargs)  # noqa: E501

    def get_order_books_with_http_info(self, **kwargs):  # noqa: E501
        """Get all orderbooks  # noqa: E501

        Shows the public order book for the requested products (or all available products) for a given delivery_area. Default delivery area will be applied if left blank and default is set. This request will by default only deliver the order book statistics (best bid, best ask, last etc.) and does not include the full orderbook depth. If you wish to retrieve the full order book you can set with_order_details to \"true\". However, this should only be done if absolutely necessary, as it will negatively impact the performance. Alternatively you can request the full order book with GET /contract/contract_id/delivery_area/orders.  The order book containts portfolio relevant data (like net_position, signals etc.) and can thus be filtered by a list of portfolio IDs. Setting the limit parameter allows to limit the number of entries returned per request (sorted by ascending delivery time).  The filter with_bid_or_ask_only returns only non empty order books. If past_hours is set, the orderbook will include historical contracts that have been closed in the last X hours.  Using delivery_from and delivery_to, the order book can be further limited to a given timespan. If used in conjunction with past_hours, delivery_from has to be after the time defined by past_hours (now - past_hours < delivery_from < delivery_to).  This request uses caching, if the response on multiple requests does not change, a cached response is returned. In this case, the field \"etag\" in the response-header does not change.  For the best performance and to get the most out of caching, we urge you to set the parameter \"with_portfolio_information\" to false and request the portfolio_information only when you need it via GET/contract/{contract_id}/{delivery_area}/portfolio-information.  The parameters \"with_signals\", \"with_risk_settings\" and \"with_products\" also influence how often a cached response is returned.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_order_books_with_http_info(async_req=True)
        >>> result = thread.get()

        :param portfolio_id:
        :type portfolio_id: list[str]
        :param product: The list of products (e.g. Intraday_Power_D,XBID_Hour_Power) *separated by a comma*, for which the orderbook(s) should be retrieved; leave blank if you want all available orderbooks
        :type product: str
        :param with_bid_or_ask_only: If set to true, the returned orderbook will contain only contracts which contain at least one active bid or ask
        :type with_bid_or_ask_only: bool
        :param with_signals: If set to true, the returned orderbook will contain the signals applicable for the contracts
        :type with_signals: bool
        :param contract_id: limit the orderbook to an array of certain contracts only
        :type contract_id: list[str]
        :param contract_name: limit the orderbook to a certain contract name only
        :type contract_name: str
        :param delivery_start: limit the orderbook to those contracts with the given delivery start date
        :type delivery_start: datetime
        :param delivery_end: limit the orderbook to those contracts with the given delivery end date
        :type delivery_end: datetime
        :param delivery_within: limit the orderbook to those contracts having a delivery start/end date which starts before and ends after the given parameter
        :type delivery_within: datetime
        :param past_hours: The number of hours to look into the past in the orderbook. If this parameter is set, historic closed contracts are contained in the orderbook as well. Can't be used in conjunction with delivery_from.
        :type past_hours: int
        :param delivery_area: The EIC of the delivery area of the orderbook
        :type delivery_area: str
        :param delivery_from: Limits the orderbook to those contracts with a delivery start date >= delivery_from. When used in conjunction with past_hours, has to be after the time defined by past_hours (delivery_from > now - past_hours).
        :type delivery_from: datetime
        :param delivery_to: Limits the orderbook to those contracts with a delivery end date <= delivery_to.
        :type delivery_to: datetime
        :param with_order_details: If set to true, the returned orderbook will contain all current bids and asks of each contract (full orderbook depth). *Heads up* We generally recommend to request the full orderbook depth on a per contract basis when orderbook-changed notifications are received via websocket. If you need the full orderbook depth for all contracts at once more frequently, please consider using full orderbook snapshots via websocket.
        :type with_order_details: bool
        :param contract_type: **PDC**: (default) the order book only includes predefined contracts, i.e. the normal contracts generated by the backend  UDC: the order book only includes block products, which were created as the result of a block order submitted by a member  ALL: the order book contains both, PDC and UDC contracts
        :type contract_type: ContractType
        :param with_portfolio_information: If set to true, the portfolio_information is included in the response. Set to false to optimize caching.
        :type with_portfolio_information: bool
        :param with_risk_settings: If set to true, the risk_setting of the portfolio are included in the response. Set to false to optimize caching.
        :type with_risk_settings: bool
        :param with_products: If set to true, the available products are included in the response. Set to false to optimize caching.
        :type with_products: bool
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(OrderBooks, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'portfolio_id',
            'product',
            'with_bid_or_ask_only',
            'with_signals',
            'contract_id',
            'contract_name',
            'delivery_start',
            'delivery_end',
            'delivery_within',
            'past_hours',
            'delivery_area',
            'delivery_from',
            'delivery_to',
            'with_order_details',
            'contract_type',
            'with_portfolio_information',
            'with_risk_settings',
            'with_products'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_order_books" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if local_var_params.get('portfolio_id') is not None:  # noqa: E501
            query_params.append(('portfolio_id', local_var_params['portfolio_id']))  # noqa: E501
            collection_formats['portfolio_id'] = 'csv'  # noqa: E501
        if local_var_params.get('product') is not None:  # noqa: E501
            query_params.append(('product', local_var_params['product']))  # noqa: E501
        if local_var_params.get('with_bid_or_ask_only') is not None:  # noqa: E501
            query_params.append(('with_bid_or_ask_only', local_var_params['with_bid_or_ask_only']))  # noqa: E501
        if local_var_params.get('with_signals') is not None:  # noqa: E501
            query_params.append(('with_signals', local_var_params['with_signals']))  # noqa: E501
        if local_var_params.get('contract_id') is not None:  # noqa: E501
            query_params.append(('contractId', local_var_params['contract_id']))  # noqa: E501
            collection_formats['contractId'] = 'csv'  # noqa: E501
        if local_var_params.get('contract_name') is not None:  # noqa: E501
            query_params.append(('contractName', local_var_params['contract_name']))  # noqa: E501
        if local_var_params.get('delivery_start') is not None:  # noqa: E501
            query_params.append(('delivery_start', local_var_params['delivery_start']))  # noqa: E501
        if local_var_params.get('delivery_end') is not None:  # noqa: E501
            query_params.append(('delivery_end', local_var_params['delivery_end']))  # noqa: E501
        if local_var_params.get('delivery_within') is not None:  # noqa: E501
            query_params.append(('delivery_within', local_var_params['delivery_within']))  # noqa: E501
        if local_var_params.get('past_hours') is not None:  # noqa: E501
            query_params.append(('past_hours', local_var_params['past_hours']))  # noqa: E501
        if local_var_params.get('delivery_area') is not None:  # noqa: E501
            query_params.append(('delivery_area', local_var_params['delivery_area']))  # noqa: E501
        if local_var_params.get('delivery_from') is not None:  # noqa: E501
            query_params.append(('delivery_from', local_var_params['delivery_from']))  # noqa: E501
        if local_var_params.get('delivery_to') is not None:  # noqa: E501
            query_params.append(('delivery_to', local_var_params['delivery_to']))  # noqa: E501
        if local_var_params.get('with_order_details') is not None:  # noqa: E501
            query_params.append(('with_order_details', local_var_params['with_order_details']))  # noqa: E501
        if local_var_params.get('contract_type') is not None:  # noqa: E501
            query_params.append(('contract_type', local_var_params['contract_type']))  # noqa: E501
        if local_var_params.get('with_portfolio_information') is not None:  # noqa: E501
            query_params.append(('with_portfolio_information', local_var_params['with_portfolio_information']))  # noqa: E501
        if local_var_params.get('with_risk_settings') is not None:  # noqa: E501
            query_params.append(('with_risk_settings', local_var_params['with_risk_settings']))  # noqa: E501
        if local_var_params.get('with_products') is not None:  # noqa: E501
            query_params.append(('with_products', local_var_params['with_products']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "OrderBooks",
        }

        return self.api_client.call_api(
            '/orderbooks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_orders(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract full depth orderbook  # noqa: E501

        This method allows you to retrieve the full public orderbook of a contract (all bids and asks) in a specific delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_orders(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Orders
        """
        kwargs['_return_http_data_only'] = True
        return self.get_orders_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501

    def get_orders_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract full depth orderbook  # noqa: E501

        This method allows you to retrieve the full public orderbook of a contract (all bids and asks) in a specific delivery area.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_orders_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Orders, status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_area'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_orders" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_id` when calling `get_orders`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_orders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'contract_id' in local_var_params:
            path_params['contract_id'] = local_var_params['contract_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "Orders",
        }

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/orders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))

    def get_public_trades(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract public trades  # noqa: E501

        This method allows you to retrieve all public trades that were executed at the exchange for a given contract_id and delivery area. Please note that this function uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_trades(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :type to_api_timestamp: datetime
        :param from_execution_time: from timestamp is 'inclusive' (i.e. >=)
        :type from_execution_time: datetime
        :param to_execution_time: to timestamp is 'exclusive' (i.e. <)
        :type to_execution_time: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: list[PublicTrade]
        """
        kwargs['_return_http_data_only'] = True
        return self.get_public_trades_with_http_info(contract_id, delivery_area, **kwargs)  # noqa: E501

    def get_public_trades_with_http_info(self, contract_id, delivery_area, **kwargs):  # noqa: E501
        """Get contract public trades  # noqa: E501

        This method allows you to retrieve all public trades that were executed at the exchange for a given contract_id and delivery area. Please note that this function uses pagination.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_public_trades_with_http_info(contract_id, delivery_area, async_req=True)
        >>> result = thread.get()

        :param contract_id: (required)
        :type contract_id: str
        :param delivery_area: The EIC of the delivery area (required)
        :type delivery_area: str
        :param offset: Offset when loading a list of items
        :type offset: int
        :param limit: Limits the number of loaded items
        :type limit: int
        :param from_api_timestamp: from timestamp is 'inclusive' (i.e. >=)
        :type from_api_timestamp: datetime
        :param to_api_timestamp: to timestamp is 'exclusive' (i.e. <)
        :type to_api_timestamp: datetime
        :param from_execution_time: from timestamp is 'inclusive' (i.e. >=)
        :type from_execution_time: datetime
        :param to_execution_time: to timestamp is 'exclusive' (i.e. <)
        :type to_execution_time: datetime
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(list[PublicTrade], status_code(int), headers(HTTPHeaderDict))
        """

        local_var_params = locals()

        all_params = [
            'contract_id',
            'delivery_area',
            'offset',
            'limit',
            'from_api_timestamp',
            'to_api_timestamp',
            'from_execution_time',
            'to_execution_time'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_public_trades" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'contract_id' is set
        if self.api_client.client_side_validation and local_var_params.get('contract_id') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `contract_id` when calling `get_public_trades`")  # noqa: E501
        # verify the required parameter 'delivery_area' is set
        if self.api_client.client_side_validation and local_var_params.get('delivery_area') is None:  # noqa: E501
            raise ApiValueError("Missing the required parameter `delivery_area` when calling `get_public_trades`")  # noqa: E501

        if self.api_client.client_side_validation and 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `offset` when calling `get_public_trades`, must be a value greater than or equal to `0`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] > 500:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_public_trades`, must be a value less than or equal to `500`")  # noqa: E501
        if self.api_client.client_side_validation and 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `limit` when calling `get_public_trades`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'contract_id' in local_var_params:
            path_params['contract_id'] = local_var_params['contract_id']  # noqa: E501
        if 'delivery_area' in local_var_params:
            path_params['delivery_area'] = local_var_params['delivery_area']  # noqa: E501

        query_params = []
        if local_var_params.get('offset') is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if local_var_params.get('limit') is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if local_var_params.get('from_api_timestamp') is not None:  # noqa: E501
            query_params.append(('from_api_timestamp', local_var_params['from_api_timestamp']))  # noqa: E501
        if local_var_params.get('to_api_timestamp') is not None:  # noqa: E501
            query_params.append(('to_api_timestamp', local_var_params['to_api_timestamp']))  # noqa: E501
        if local_var_params.get('from_execution_time') is not None:  # noqa: E501
            query_params.append(('from_execution_time', local_var_params['from_execution_time']))  # noqa: E501
        if local_var_params.get('to_execution_time') is not None:  # noqa: E501
            query_params.append(('to_execution_time', local_var_params['to_execution_time']))  # noqa: E501

        header_params = dict(local_var_params.get('_headers', {}))

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['api_key_security']  # noqa: E501

        response_types_map = {
            200: "list[PublicTrade]",
        }

        return self.api_client.call_api(
            '/contract/{contract_id}/{delivery_area}/publictrades', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_types_map=response_types_map,
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats,
            _request_auth=local_var_params.get('_request_auth'))
