# Generated by Django 2.2.14 on 2020-08-02 18:04

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    dependencies = [
        ('base', '0019_satellite_details'),
    ]

    operations = [
        migrations.AlterField(
            model_name='operator',
            name='website',
            field=models.URLField(blank=True, validators=[django.core.validators.URLValidator(regex="(?:http(s)?:\\/\\/)?[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-\\._~:/?#[\\]@!\\$&'\\(\\)\\*\\+,;=.]+$", schemes=['http', 'https'])]),
        ),
        migrations.AlterField(
            model_name='satellite',
            name='dashboard_url',
            field=models.URLField(blank=True, null=True, validators=[django.core.validators.URLValidator(regex="(?:http(s)?:\\/\\/)?[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-\\._~:/?#[\\]@!\\$&'\\(\\)\\*\\+,;=.]+$", schemes=['http', 'https'])]),
        ),
        migrations.AlterField(
            model_name='satellite',
            name='website',
            field=models.URLField(blank=True, validators=[django.core.validators.URLValidator(regex="(?:http(s)?:\\/\\/)?[\\w.-]+(?:\\.[\\w\\.-]+)+[\\w\\-\\._~:/?#[\\]@!\\$&'\\(\\)\\*\\+,;=.]+$", schemes=['http', 'https'])]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='baud',
            field=models.FloatField(blank=True, help_text='The number of modulated symbols that the transmitter sends every second', null=True, validators=[django.core.validators.MinValueValidator(0)]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='citation',
            field=models.CharField(default='CITATION NEEDED - https://xkcd.com/285/', help_text='A reference (preferrably URL) for this entry or edit', max_length=512),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='created',
            field=models.DateTimeField(default=django.utils.timezone.now, help_text='Timestamp for this entry or edit'),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='description',
            field=models.TextField(help_text='Short description for this entry, like: UHF 9k6 AFSK Telemetry'),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='downlink_drift',
            field=models.IntegerField(blank=True, help_text='Transmitter drift from the published downlink frequency, stored in             parts per billion (PPB)', null=True, validators=[django.core.validators.MinValueValidator(-99999), django.core.validators.MaxValueValidator(99999)]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='downlink_high',
            field=models.BigIntegerField(blank=True, help_text='Frequency (in Hz) for the top of the downlink range for a transponder', null=True, validators=[django.core.validators.MinValueValidator(0, message='Ensure this value is greater than or equal to 0Hz'), django.core.validators.MaxValueValidator(40000000000, message='Ensure this value is less than or equal to 40Ghz')]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='downlink_low',
            field=models.BigIntegerField(blank=True, help_text='Frequency (in Hz) for the downlink, or bottom of the downlink range             for a transponder', null=True, validators=[django.core.validators.MinValueValidator(0, message='Ensure this value is greater than or equal to 0Hz'), django.core.validators.MaxValueValidator(40000000000, message='Ensure this value is less than or equal to 40Ghz')]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='downlink_mode',
            field=models.ForeignKey(blank=True, help_text='Modulation mode for the downlink', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='transmitter_downlink_entries', to='base.Mode'),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='invert',
            field=models.BooleanField(default=False, help_text='True if this is an inverted transponder'),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='service',
            field=models.CharField(choices=[('Aeronautical', 'Aeronautical'), ('Amateur', 'Amateur'), ('Broadcasting', 'Broadcasting'), ('Earth Exploration', 'Earth Exploration'), ('Fixed', 'Fixed'), ('Inter-satellite', 'Inter-satellite'), ('Maritime', 'Maritime'), ('Meteorological', 'Meteorological'), ('Mobile', 'Mobile'), ('Radiolocation', 'Radiolocation'), ('Radionavigational', 'Radionavigational'), ('Space Operation', 'Space Operation'), ('Space Research', 'Space Research'), ('Standard Frequency and Time Signal', 'Standard Frequency and Time Signal'), ('Unknown', 'Unknown')], default='Unknown', help_text='The published usage category for this transmitter', max_length=34),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='status',
            field=models.CharField(choices=[('active', 'active'), ('inactive', 'inactive'), ('invalid', 'invalid')], default='active', help_text='Functional state of this transmitter', max_length=8),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='uplink_drift',
            field=models.IntegerField(blank=True, help_text='Receiver drift from the published uplink frequency, stored in parts             per billion (PPB)', null=True, validators=[django.core.validators.MinValueValidator(-99999), django.core.validators.MaxValueValidator(99999)]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='uplink_high',
            field=models.BigIntegerField(blank=True, help_text='Frequency (in Hz) for the top of the uplink range for a transponder', null=True, validators=[django.core.validators.MinValueValidator(0, message='Ensure this value is greater than or equal to 0Hz'), django.core.validators.MaxValueValidator(40000000000, message='Ensure this value is less than or equal to 40Ghz')]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='uplink_low',
            field=models.BigIntegerField(blank=True, help_text='Frequency (in Hz) for the uplink, or bottom of the uplink range for a             transponder', null=True, validators=[django.core.validators.MinValueValidator(0, message='Ensure this value is greater than or equal to 0Hz'), django.core.validators.MaxValueValidator(40000000000, message='Ensure this value is less than or equal to 40Ghz')]),
        ),
        migrations.AlterField(
            model_name='transmitterentry',
            name='uplink_mode',
            field=models.ForeignKey(blank=True, help_text='Modulation mode for the uplink', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='transmitter_uplink_entries', to='base.Mode'),
        ),
    ]
