# air-sdk-python

<div align="left">
    <a href="https://speakeasyapi.dev/"><img src="https://custom-icon-badges.demolab.com/badge/-Built%20By%20Speakeasy-212015?style=for-the-badge&logoColor=FBE331&logo=speakeasy&labelColor=545454" /></a>
    <a href="https://github.com/airventures/sdk-python.git/actions"><img src="https://img.shields.io/github/actions/workflow/status/speakeasy-sdks/bolt-php/speakeasy_sdk_generation.yml?style=for-the-badge" /></a>
    
</div>

<!-- Start SDK Installation [installation] -->
## SDK Installation

```bash
pip install air-sdk-python
```
<!-- End SDK Installation [installation] -->

<!-- Start SDK Example Usage [usage] -->
## SDK Example Usage

### Example

```python
import air
from air.models import shared

s = air.Air(
    bearer_auth="<YOUR_BEARER_TOKEN_HERE>",
)

req = shared.Call(
    phone='874.397.6390 x76992',
    prompt_id=230621,
)

res = s.call.initiate_call(req)

if res.object is not None:
    # handle response
    pass

```
<!-- End SDK Example Usage [usage] -->

<!-- Start Available Resources and Operations [operations] -->
## Available Resources and Operations

### [call](docs/sdks/call/README.md)

* [initiate_call](docs/sdks/call/README.md#initiate_call) - Initiate a call
<!-- End Available Resources and Operations [operations] -->







<!-- Start Error Handling [errors] -->
## Error Handling

Handling errors in this SDK should largely match your expectations.  All operations return a response object or raise an error.  If Error objects are specified in your OpenAPI Spec, the SDK will raise the appropriate Error type.

| Error Object                                   | Status Code                                    | Content Type                                   |
| ---------------------------------------------- | ---------------------------------------------- | ---------------------------------------------- |
| errors.InitiateCallResponseBody                | 401                                            | application/json                               |
| errors.InitiateCallCallResponseBody            | 403                                            | application/json                               |
| errors.InitiateCallCallResponseResponseBody    | 404                                            | application/json                               |
| errors.InitiateCallCallResponse422ResponseBody | 422                                            | application/json                               |
| errors.InitiateCallCallResponse500ResponseBody | 500                                            | application/json                               |
| errors.SDKError                                | 4xx-5xx                                        | */*                                            |

### Example

```python
import air
from air.models import errors, shared

s = air.Air(
    bearer_auth="<YOUR_BEARER_TOKEN_HERE>",
)

req = shared.Call(
    phone='874.397.6390 x76992',
    prompt_id=230621,
)

res = None
try:
    res = s.call.initiate_call(req)
except errors.InitiateCallResponseBody as e:
    # handle exception
    raise(e)
except errors.InitiateCallCallResponseBody as e:
    # handle exception
    raise(e)
except errors.InitiateCallCallResponseResponseBody as e:
    # handle exception
    raise(e)
except errors.InitiateCallCallResponse422ResponseBody as e:
    # handle exception
    raise(e)
except errors.InitiateCallCallResponse500ResponseBody as e:
    # handle exception
    raise(e)
except errors.SDKError as e:
    # handle exception
    raise(e)

if res.object is not None:
    # handle response
    pass

```
<!-- End Error Handling [errors] -->



<!-- Start Server Selection [server] -->
## Server Selection

### Select Server by Index

You can override the default server globally by passing a server index to the `server_idx: int` optional parameter when initializing the SDK client instance. The selected server will then be used as the default on the operations that use it. This table lists the indexes associated with the available servers:

| # | Server | Variables |
| - | ------ | --------- |
| 0 | `https://chat.air.ai/api/v1` | None |

#### Example

```python
import air
from air.models import shared

s = air.Air(
    server_idx=0,
    bearer_auth="<YOUR_BEARER_TOKEN_HERE>",
)

req = shared.Call(
    phone='874.397.6390 x76992',
    prompt_id=230621,
)

res = s.call.initiate_call(req)

if res.object is not None:
    # handle response
    pass

```


### Override Server URL Per-Client

The default server can also be overridden globally by passing a URL to the `server_url: str` optional parameter when initializing the SDK client instance. For example:
```python
import air
from air.models import shared

s = air.Air(
    server_url="https://chat.air.ai/api/v1",
    bearer_auth="<YOUR_BEARER_TOKEN_HERE>",
)

req = shared.Call(
    phone='874.397.6390 x76992',
    prompt_id=230621,
)

res = s.call.initiate_call(req)

if res.object is not None:
    # handle response
    pass

```
<!-- End Server Selection [server] -->



<!-- Start Custom HTTP Client [http-client] -->
## Custom HTTP Client

The Python SDK makes API calls using the [requests](https://pypi.org/project/requests/) HTTP library.  In order to provide a convenient way to configure timeouts, cookies, proxies, custom headers, and other low-level configuration, you can initialize the SDK client with a custom `requests.Session` object.

For example, you could specify a header for every request that this sdk makes as follows:
```python
import air
import requests

http_client = requests.Session()
http_client.headers.update({'x-custom-header': 'someValue'})
s = air.Air(client=http_client)
```
<!-- End Custom HTTP Client [http-client] -->



<!-- Start Authentication [security] -->
## Authentication

### Per-Client Security Schemes

This SDK supports the following security scheme globally:

| Name          | Type          | Scheme        |
| ------------- | ------------- | ------------- |
| `bearer_auth` | http          | HTTP Bearer   |

To authenticate with the API the `bearer_auth` parameter must be set when initializing the SDK client instance. For example:
```python
import air
from air.models import shared

s = air.Air(
    bearer_auth="<YOUR_BEARER_TOKEN_HERE>",
)

req = shared.Call(
    phone='874.397.6390 x76992',
    prompt_id=230621,
)

res = s.call.initiate_call(req)

if res.object is not None:
    # handle response
    pass

```
<!-- End Authentication [security] -->

<!-- Placeholder for Future Speakeasy SDK Sections -->



### Maturity

This SDK is in beta, and there may be breaking changes between versions without a major version update. Therefore, we recommend pinning usage
to a specific package version. This way, you can install the same version each time without breaking changes unless you are intentionally
looking for the latest version.

### Contributions

While we value open-source contributions to this SDK, this library is generated programmatically.
Feel free to open a PR or a Github issue as a proof of concept and we'll do our best to include it in a future release!

### SDK Created by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
