// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
// SPDX-FileCopyrightInfo: Copyright © DUNE Project contributors, see file LICENSE.md in module root
// SPDX-License-Identifier: LicenseRef-GPL-2.0-only-with-DUNE-exception
//
// WARNING
// This file is automatically generated by jacobian.mac! Don't edit by hand!
#ifndef DUNE_GEOMETRY_QUADRATURE_Jacobi2_HH
#define DUNE_GEOMETRY_QUADRATURE_Jacobi2_HH

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif

namespace Dune {

  /************************************************
   * Quadraturerule for 1d line
   *************************************************/

  template<typename ct, int dim>
  class Jacobi2QuadratureRule;

  template<typename ct>
  using Jacobi2QuadratureRule1D = Jacobi2QuadratureRule<ct,1>;

  template<typename ct>
  class Jacobi2QuadratureRule<ct,1> : public QuadratureRule<ct,1>
  {
  public:
    /** brief The highest quadrature order available */
    constexpr static int highest_order = 61;

  private:
    friend class QuadratureRuleFactory<ct,1>;
    Jacobi2QuadratureRule (int p);
    ~Jacobi2QuadratureRule(){}
  };

  //! internal Helper template for the initialization of the quadrature rules
  template<typename ct,
      bool fundamental = std::is_floating_point<ct>::value>
  struct Jacobi2QuadratureInitHelper;

  template<typename ct>
  struct Jacobi2QuadratureInitHelper<ct, true> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  template<typename ct>
  struct Jacobi2QuadratureInitHelper<ct, false> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  // for fundamental types
  template<typename ct>
  void Jacobi2QuadratureInitHelper<ct,true>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = 0.25;
      _weight[0] = 1.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333;
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = 0.5441518440112252887999262362955145689146370092883477884571669901861729625759492147562832072252866864;
      _weight[0] = 0.4031435283193017223334255379639401221900370717228985977618745956006171301133968148879793243017249754;
      _points[1] = 0.1225148226554413778667404303711520977520296573783188782094996764804937040907174519103834594413799803;
      _weight[1] = 0.930189805014031610999907795369393211143296261610434735571458737732716203219936518445354009031608358;
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = 0.7050022098884983831223984775840482527404615621673957968187330274666375934719617430536332178860666683;
      _weight[0] = 0.1198028120343227920459059630233091355547326268137250385594040589278280490932505000994631471190946468;
      _points[1] = 0.3470037660383518847217635434039484551401490745262501021878985827903559852608331357830049271464466709;
      _weight[1] = 0.5849850770394640880140480814569575834996833285430405912588393379710804430684155659655248860334828359;
      _points[2] = 0.07299402407314973215583797901200329211938936330635410099336838974300642126720512116336185496748666083;
      _weight[2] = 0.6285454442595464532733792888530666142789173779765677035150899364344248411716672672683453001807558508;
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = 0.795851417896772863303377960793240153655111814369133947337218428490843889786355454581170273360860138;
      _weight[0] = 0.04140896299967226113759062618655673912665921802650887351261598768091744489940921375092075799421354484;
      _points[1] = 0.5170472951043675023405733693830732661441577674815143184126459202288394285156186604132268185358169055;
      _weight[1] = 0.2745355486916923012695053801672421777585462337521019227783801195324800153896617288464511839350699153;
      _points[2] = 0.04850054944699732929706725709898599476427280622804138308697676906809043140700237130756061833546337107;
      _weight[2] = 0.4435536624451119347329252698757826095062322419475350982016036681051358053754859408526879761621947264;
      _points[3] = 0.2386007375518623050589814127247005854364576119213103511631588822122262502910235136980422897678595854;
      _weight[3] = 0.5738351591968568361933120571037518069418956396071874388407335580148000676687764498832734152418551447;
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = 0.8510542129470164181162241874100130578037999355252331298775577412327508226081337242789670271254366003;
      _weight[0] = 0.0164553008123960318344649664771932761384129705299198594819023493276538663334439422044756555173918885;
      _points[1] = 0.6343334726308867723471638889206191121277336440958369160307851769971809925102122993798727580295999099;
      _weight[1] = 0.1282224028918476770189957222265331112459675505313588758170175986042217305503148083830364356533270504;
      _points[2] = 0.03457893991821509152445742863152659272391875376414497155987987848502413583832078858238836643039194193;
      _weight[2] = 0.3270591371430836716195229316894094001951854345378653863487891391459565840633676758520507731631799336;
      _points[3] = 0.3898863870655193282408954103849949929685699479384607713625473160659384788871254703280644555908817828;
      _weight[3] = 0.3568006448863600007450179722815356404122106902138793907440693610940259530233602522779046002721091408;
      _points[4] = 0.1734803207716957231045924179861795777093110520096575445025632205524389034895410507640407261570230985;
      _weight[4] = 0.504795847599645952115331740658661905341556687520309820941554885161475199362846654615865868727325323;
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = 0.8868056161775618663012660060104907510040863218112851455728573015303583622861762166128254348593013689;
      _weight[0] = 0.007324303227477190931113822360224935405864216618905867216202122367913348061134720321894342299951728867;
      _points[1] = 0.7156811273117139187676626245936073635482655112817582867648513925864912489801365831589316400094114546;
      _weight[1] = 0.06288118873978020531140504852007971390788413793492071598436679202370012665529257375196229311689702309;
      _points[2] = 0.5090364131647520840110399051677197756066865099413616255162800068449833494040551477253328196372325307;
      _weight[2] = 0.2051582845184648408805173003076769826286071695771531963106651422253387765576255251446619284393054827;
      _points[3] = 0.02590455509366719275464360699723454895681812392531925015861057429610266045438042891711695398904589615;
      _weight[3] = 0.2501548109063237515141062258733267440660779616350562328954095848025901035201055026000940757458649068;
      _points[4] = 0.3024369180228912327499055779185451938801342419623170862494499684632895155693734121375470591583017143;
      _weight[4] = 0.3783087469941648142731682068802065098680549714701846873490169027817905712014531819167360652747890985;
      _points[5] = 0.1315639416579851339869108507409737955754378625065300343093793277073462918773067828768175209181356068;
      _weight[5] = 0.429505998947122530423022729391818447456844876097112633577672789132000407337721829597984628456525117;
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = 0.9111831665630027636393173672090451969487181513569967751421124434536487739752746787009550475957343985;
      _weight[0] = 0.003570752134756827216036107377022441360104908358539661885927757477239078187959563376287977244479836972;
      _points[1] = 0.773517246591437501111998996426027488026169366066348465200565244218230399988368494001938326057139926;
      _weight[1] = 0.03265170252921877802892723627488505435251712336400851214223824298292417299877194662090599291711606812;
      _points[2] = 0.6000215132789929301939687728899372881025806599131930023285085834549592653990404218944489240088978781;
      _weight[2] = 0.1176888451581144593629814079400447094617082760975046287638279082701242348479743647408809166847127138;
      _points[3] = 0.02013277377340050723050168711747234907764398490423277046410233635340207429864852275760640623962261817;
      _weight[3] = 0.1971060071057524832937165163396190757998916431027808644906762554468035992816828007706400085856980319;
      _points[4] = 0.4140021445970597464182872488505667767590220835312978380704205456186698145026653746810963941381988064;
      _weight[4] = 0.2525855148355651908381357619247951567605016016259007795136116178216199124634212453015846804292228417;
      _points[5] = 0.1030890291480490147522267860059511003289175929398917699266215140490606015002180084249458354155438582;
      _weight[5] = 0.3627952984507445781478699198894979377596337461185747060555815360747820057455407114922673477814266561;
      _points[6] = 0.2405541260480575366536991415009998007569481612880393788676693328520290703357844995390090665448625147;
      _weight[6] = 0.3669352131191810164456663835874689578389760346660241804814700152598403298079827010307664096906772971;
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = 0.9285089649599068972010186178492256918523361943035918234239993038443100956977829527716887186137627323;
      _weight[0] = 0.001874071136138789023159770129253368619333666877009514163776075880783138331582326154790170679105180906;
      _points[1] = 0.8157717035832837607547517869758669198734561249520251057926437981546786829099776657599632715409829299;
      _weight[1] = 0.01789808685205763198302608401313458028471472087364949967388597034873997270243168913625909195923823938;
      _points[2] = 0.6695522718243614518301145105543719346057236571343379507230403873080542508578187492621559364188985917;
      _weight[2] = 0.06898745512093993121697462309944726926414242801556028350923661517840760011679153538454549507030134072;
      _points[3] = 0.01609775955192103353201355009661792907673719717398634906421435485594927605852943376972866088945344409;
      _weight[3] = 0.159115831226762239320425823705592796269808307236583292588717392773719674740770700496721345833462587;
      _points[4] = 0.5055970781844891719400618650060764872884489602668891730627538404857596368160581228502258304169030991;
      _weight[4] = 0.1632577055541760927458463846085917092703302398116046797151312588917290824986672513574976000713409909;
      _points[5] = 0.3416519914772022202729622621623959437357864175820185645023555961530872229142955610693253060030617732;
      _weight[5] = 0.2737887336866130889881088024434078279685567928059228224395487281994529345472410304920512689098080725;
      _points[6] = 0.08290061748565110270036635338038834250469178513978329482769857057078194045432465770034793117405856385;
      _weight[6] = 0.3072723730688904992180269402731618118770031436482066776403339468731082588061946079180966199553820393;
      _points[7] = 0.1954751684887399173242666095306123066183752190029232941588497041829344498467684123721199004984344214;
      _weight[7] = 0.3411390766877550608377649050607439697794440340647965636027033451873926715896541923933717408546950035;
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = 0.9412458642132742114143421271349757145307710728810603227584263072556399818130810425576470087365192321;
      _weight[0] = 0.001045049386077851771963674594932099904728987905881137936245423011782888065286438712365833246324346971;
      _points[1] = 0.8474368420132373201731804250196182721512229028198623679712683516725259240759225460110084747448902275;
      _weight[1] = 0.01029759458243489240932686362241481242050381516644947786284291452404221754858892924302398732118007726;
      _points[2] = 0.7232685717403354318179601582002055305769054380507989053229094988979833043442432382442417433411755164;
      _weight[2] = 0.04162446631740894820970534894375261359629703551183251098420143946239913509520566870940318195593343379;
      _points[3] = 0.5796940563511631262657724133119889515943464601677762686678217724998474141044996039946483039194661255;
      _weight[3] = 0.1053731236101993429518987840106901998442418069136281392168534644913155857561231942134211646777062514;
      _points[4] = 0.01316588559711449054519053781797215136082076089770230465987155514510039146923769474012679115743814305;
      _weight[4] = 0.1310405804441588858472781603370944604810978794735901694842259117976972694085138327178975817670983234;
      _points[5] = 0.4294536453878127925092480022865873331648138310301004847453416352653628845263290243369473840494158542;
      _weight[5] = 0.1941625114580260318381122496994582838080221982357833412996720724777967285153688457928679921481932565;
      _points[6] = 0.0680845295937675874765058569868224421713297601092686688022203256854416426151243571888926792972427821;
      _weight[6] = 0.261958148133586527127756428815648823072391939069180744506022629993832327961890621152764564116753725;
      _points[7] = 0.2858910883392203977279895669126411861610178692391895516747553642738332353741698871551056243758169287;
      _weight[7] = 0.2771375827592188368629111413955671111448010879552790959675288132265547247642744146956024875388283137;
      _points[8] = 0.1617595167640746420698109123291884182887719048042411253973851893042652216773926057713819903780351905;
      _weight[8] = 0.3106942766422220163143806819137749290612485831017087160757406643479124562180813880959865405613147766;
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = 0.950874292640523166446349484610325177054138698008876247521880845732145601052447073904101954699264569;
      _weight[0] = 0.0006129601467886433685130280913870182321267020111436205319486707118462805612131738008391387787268322555;
      _points[1] = 0.8717100745744084876118613420054236108762703517899922187764993623709234200889090646472972713573702869;
      _weight[1] = 0.006182092778946314514341307258874506510233203740474247976315870788020555404045823349159258546354102964;
      _points[2] = 0.7653476795481078962095331272446001935281254701059371299400639154174230207720369856446774138268604502;
      _weight[2] = 0.02587955627423411691892242624371044143548514233481194134088846643064833839260516482542276239452851382;
      _points[3] = 0.6396094886547097093285365061669561436997898167778574491235731369280604031123928829202652930591428398;
      _weight[3] = 0.06879030018621203231655000929591000454971704580551112869775545888215954689422647507462355006505397947;
      _points[4] = 0.0109684524561741342502810329904322267331336681681923877355192963785056979625337637538110478171937813;
      _weight[4] = 0.1097363548403899878418065943379411944061396284924080166565554103294093888964177063474961793610317609;
      _points[5] = 0.5038071264148739070055306420572277096670551499038191289399601781301074701278289240976204997968793742;
      _weight[5] = 0.1354182600672564641764042852374920057830707307904626801110973942414191156942172243587060817600027027;
      _points[6] = 0.368007850449337717604769566250171596247982565113976890620368550952044195900000495246411103376721109;
      _weight[6] = 0.2115351550678566328395393557696844837464895827386582581706740133267465009849730196407481293438002147;
      _points[7] = 0.05689815053365792071143485937912054793467820298666632147108136436086362854588603274828183051491504926;
      _weight[7] = 0.225091745611232505129663328610836642061495180030943960685427476047529432641869184478743685148813548;
      _points[8] = 0.2422811961325235611113945553650933509790917920092800543802211222195903604925019606707436266710657206;
      _weight[8] = 0.2698088775257512998821031772547641973726038694971785623654789998437662428652904614577889155923326546;
      _points[9] = 0.1359502340502289542657634293851948978251888305899476260362867729648816564909173618213354134260413652;
      _weight[9] = 0.2802780308346653363454898212327328392359722478917409167971915727317879309984750999998056323426925601;
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = 0.9583251437866482019244391246661515172975807330371457605995597415964384943234249185759655416699374958;
      _weight[0] = 0.000375201944039112274110771110315908356687730405206470034411653934686036893473293306588774880319268213;
      _points[1] = 0.8906910993543921891508128999060838449706283276255334717255508939690538822374778360353169582497335915;
      _weight[1] = 0.00385208230217295633280149495827083673193151247870147197552704364619028592854368826873460383639665097;
      _points[2] = 0.7987843585909146419746087280073481414657603642892225070265379669025781304819516320234507849776994695;
      _weight[2] = 0.01656001705287608941907074982129804342900595679782926547479362297629040174388475144000347871328583658;
      _points[3] = 0.688324239862956685695533975808089616887768561474068757166363819171422275318388614243984518557290749;
      _weight[3] = 0.0456583636723904729996850512271237669584876826738233279287055153455876677454530500071081468737087832;
      _points[4] = 0.009278973831348834202946610301344755180099785584988668019087892028035392237328733017396657895312042244;
      _weight[4] = 0.09320340020555350966024561740341972459706270009058980336483720700004390524125197996306174927564459171;
      _points[5] = 0.5662398391545683135675124719348766600394909006313209815451544722188689876257081925222297826462922053;
      _weight[5] = 0.09435865415522771459726664777523037712224413619385624135202085655621859469783133863488143428243946943;
      _points[6] = 0.4401983998588624670826813221763196944009306574309261115292338038944935336942601582950581383666207959;
      _weight[6] = 0.1571608711937424489861433436853150352752777007115971600215818769351715159348001703309820163758798218;
      _points[7] = 0.048249692094286258286483723731131691367687071501178650576197695398469355275111244782622963767846247;
      _weight[7] = 0.1949834441226579674578013161123198903391393493913141165710324158456011237446879391336948781555402736;
      _points[8] = 0.3181179519062339663774464665791396822719791120780551488743875923139814199674731765500037687261335592;
      _weight[8] = 0.2185288892841797042827148607708304088540070080506917135110024995552378489195340132318724808370494739;
      _points[9] = 0.1157886266293952259603059182556492085885288892943482283961924853822757749603844675338080199944631066;
      _weight[9] = 0.2519181720014695773533359952445167095153987763649309891459044750285736696026664998184742228754605857;
      _points[10] = 0.2076683415970598824438954253005318541962122637198783812084003037910494205451576930868295318153374046;
      _weight[10] = 0.2567342373990237799701574852246926321540907801747927739535161665097322828812066091979315472275857163;
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = 0.9642065352926715512129553062783893235051470791627773576749579921411683197960515088339540982065266612;
      _weight[0] = 0.0002382014392332466553295292468100035402588379323819602604826503406568381379009877933689507069923317518;
      _points[1] = 0.9057950735445437268017964703997392322761079119953073066163678713751459636010637378082399631441249729;
      _weight[1] = 0.002479813594178077693466924685437339297957267049610856766740237535355291735573310962968151138526176774;
      _points[2] = 0.8257185142147869017640833629537027093736435575778818152064773066577478052593968978372571869786865626;
      _weight[2] = 0.01088336857641535741816614466540524551935021467910130060680909665551588747958855091474710790206617211;
      _points[3] = 0.7282464529530726864288803300611436952397911534452751751134554512822045797431115007040988123166108503;
      _weight[3] = 0.03086546809554570647515094649861202512818448992619175640122761773789205214076726685224260000604713766;
      _points[4] = 0.618623863458456046293548861891138148294720180209701783497547364656844356405705986332563927357603768;
      _weight[4] = 0.06618937457843764840554885416015182450294519306581249015227764712822431773609940807764767959301801296;
      _points[5] = 0.00795204570263843687621909334004042303258789157901845111211954077607260954906099644364827702074452761;
      _weight[5] = 0.08012445033899501177523089686688632200915300524216047110927662984377082923088939924661277616536887942;
      _points[6] = 0.5027573604490322032793092784391183027172079885763226380243920422697606141569862957949651716180958326;
      _weight[6] = 0.1156322073549094419776139687208225491632847535363357613046929611804166587438361502417881862465344624;
      _points[7] = 0.04142781045429459079077016519479508238169039978959055353403669646892966829653108165370954342425005537;
      _weight[7] = 0.1702264614696225510918739636030398201621484344112814996354913309233794603455227611295265426262321147;
      _points[8] = 0.3868920099976897916656347038054368617573779726132266856600842411622840190011408572046787141187486327;
      _weight[8] = 0.171059054280755609269063747143514548405033082766416787099850451303096574198806692484217307152058153;
      _points[9] = 0.2772734577993151198175389183105218031690793465049448069023914667625432657455874204304984154028694716;
      _weight[9] = 0.2182957646569263313022348391211610218077554917110947715591671593278409360063080187628820023513092495;
      _points[10] = 0.09975762554261415706608170348029973993914665962085252482832659967377232598679917985998074692048546311;
      _weight[10] = 0.2263367389978962785859121446178675121101775526351403133866313748357859288961118901399429789565430877;
      _points[11] = 0.1798107890524232495416433443072131398519613973866393633683049652350649339970260755579436050297147405;
      _weight[11] = 0.2410024299504180726837413740036251216870850103778053650506861765213985586819288967273890504882725107;
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = 0.9689288942285889621118118173027414862466810321685627399195946722689891537382806172804214947762563879;
      _weight[0] = 0.0001560679730565849110018877622564030522971963926107455394995589020798212499287723463265570237517657826;
      _points[1] = 0.9179996455372066795336259702883514644585607264667402765509172640216951031101831301991193963406574736;
      _weight[1] = 0.001642883567163541667137135579634586264318797523514426083342476902975498845674881247797284810378208794;
      _points[2] = 0.8476910439472323909103140489514170370916151645340936646068779732870007405006591332706754097819751753;
      _weight[2] = 0.007329564556957514349394257676697856873834127393279604943260422811450298594922588905052267132904176197;
      _points[3] = 0.761249766308276972276659526393430789096233559591680956812385294673641776520411182465771879851800669;
      _weight[3] = 0.0212542773553305537922236577273894920266795630618925270008614094028470673633842799803854792283483557;
      _points[4] = 0.6627093135603885423214631521232583899762109853102761874503785215844447164251275965254928056783280667;
      _weight[4] = 0.04691303837240752265188152459747705248625923503706344789441878308197981725976028730594650682213315277;
      _points[5] = 0.006890831309958731396681534153406989161031292429588421666464684973903589904229316285895671436921466539;
      _weight[5] = 0.06960491444024738195232456693410433617039772704751655810891567455689639937541737691245714318024412803;
      _points[6] = 0.556674622629455010696946642362080582274005790127050520864708239847742359838170526149629812384999097;
      _weight[6] = 0.08501998685902645212445243555463312092509357047145464604938440147163681074074875244898739601239204062;
      _points[7] = 0.448102638905709853628734308793979708730769418234673142154600177113914833602501069027983838668057836;
      _weight[7] = 0.1317618067137311603345937815895239661737637824034451034501350134739730493893049812226124269295047473;
      _points[8] = 0.0359533627001700955011328119695205132217760105545034090502050160774587979100248003869028934390782858;
      _weight[8] = 0.149706832675376159814665192745896090274423343707367752518259997752083720102762657728173384760833919;
      _points[9] = 0.3420695126460753234745079965662670426694598946354515144515707529248230901101547245184760072145509804;
      _weight[9] = 0.1784984030224598177222653499089708881761495368969374648507406094628872556990281953015547320237188519;
      _points[10] = 0.08681178015758543328428030769060128035868046724108182524481800707505654573671895497355362141572101772;
      _weight[10] = 0.2036393228507800763716273887505590308873494434785424621492199411922564371066863588578324885550135641;
      _points[11] = 0.2435328995871284444190341035677509233546420884568021588363910256954815690060216467377269714945612026;
      _weight[11] = 0.2133600864234869829016066656915215457043166425583673690879063724648569706987753465045737718877610556;
      _points[12] = 0.1570999741965092747305220655514795076460478559637808966768026561701334378832315878926359118028066273;
      _weight[12] = 0.2244461485233095847401594888146689643184503673613412256573886718574101869069388545716338949684001378;
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = 0.972777120741183230452963363167272376141832232066661615502209934421620349446232535307554709008591307;
      _weight[0] = 0.0001051046466755994190066812166292344685646859351848575804945921359672835410758237589818594844183713655;
      _points[1] = 0.9279957387467523249837781220393962330973069328106674535182517668455918785733163177668632107772943337;
      _weight[1] = 0.001116397363787513880357822426330897791338165514714505129793583213369776447193493631912488567194436826;
      _points[2] = 0.8658249007315969536711408351810170671281166559680840985364216536761121893264203663610169524834368559;
      _weight[2] = 0.005047135580629952165313333678903904301766740735495618421679475165368531852851525344466712644979621146;
      _points[3] = 0.788774238434560715340304885598911781259911841674992787459123085551496025352674899149699384244556166;
      _weight[3] = 0.01489950270113143528621524991386061259196283121337933421213015237018974938111932684980666809215126327;
      _points[4] = 0.6999909171699064974107366639384890954484520793287566604677488395049079890581595895812516182137613225;
      _weight[4] = 0.03365190694854584883843086111142799005260169355843994956162857554818205354238736452087127825321312291;
      _points[5] = 0.006028808871066648170088747712159971400916567403381750549695222043202403723743444571483478785282597294;
      _weight[5] = 0.06102082447779318149404536788951199265358380400157561994830938903862191015641396072434298492746016295;
      _points[6] = 0.6031073967275967836818955665403615514497986107892801003779313726143183351054969157643569313893089786;
      _weight[6] = 0.06277732914029182873972173919394741932291208929247041454114182049684592982407685936803284668904118036;
      _points[7] = 0.5020891397499784100693253980496002910686100916885675007465829924443020109731422291660366333167504029;
      _weight[7] = 0.100864734147356220137224880808875104302052192464766848649639628532366084837666605920237506855583525;
      _points[8] = 0.03149425981865759070730671276631670807205021271980635578223819813728679761179934797609978862835346418;
      _weight[8] = 0.1325583818798422395037209033460692313542102941236965236002400055105646280610200698756731543890029501;
      _points[9] = 0.4010713786971543575811860320519884685924384191572501525138619910884257329369228617255111752487734427;
      _weight[9] = 0.1429560411700584519366501032413827809654950517490789640352810210845232863752618039772883247583044508;
      _points[10] = 0.3041895281416563096323663549044031022663432275568421834000345432977346183474641407178311135015966833;
      _weight[10] = 0.181013729017843525860489494264088046051451408765004892376855696951718958925979135336553761794343072;
      _points[11] = 0.07621362247485386758640678634002269316243941065388009043581495037460591816702556531771748717780648104;
      _weight[11] = 0.1836590884586847156456151997787713864338837649250093240214366377932523271705213409778289378534453448;
      _points[12] = 0.2154097570688955749006955320851489135121375905412025496653310142236265218036971673059371903435771384;
      _weight[12] = 0.2055596961578860130952322610656504885177771188630820243106415066192827887029009016919044018841550359;
      _points[13] = 0.13836652595947406914513833295824508073297946097396003437808776911010256290723795262197366021424416;
      _weight[13] = 0.2081034616428068073313094353978842445257334921914344569440612488730800245148651213554324071384231894;
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = 0.9759538743350237095620038412791153907886111958465214282812663898287649311216709075768610974652202589;
      _weight[0] = 0.00007251514227803490388636640769623041371922231503159275050960701128191249448264412063567318483535691285;
      _points[1] = 0.9362818217355187421025193722871475594082635803646883892837426450201379107391391453318432405302555511;
      _weight[1] = 0.0007759490522557821973605351452471324906775817329617622870809982729562547897699646378604645579100034014;
      _points[2] = 0.8809495287153136023880805549365229247192257620249850286280431657774932073581341528362053919854452732;
      _weight[2] = 0.003546294540936386695929109813840513953405630969412226155615325774569207011586893659157938322767788821;
      _points[3] = 0.811925477275009666689693121201954242771620008829733004296824074056702209005600015576730552774306681;
      _weight[3] = 0.01062265194309727672451284568453333373257143901288406177087267655658817988164428587123611239563582801;
      _points[4] = 0.7316979730525232062993394846752112991776703416144255053301405080726071072308400265108448666008619891;
      _weight[4] = 0.02444420044082419616486125716889612243023339647683950965594801711901059340309718047264869243476431921;
      _points[5] = 0.6431646017687849385394940088418749344687178001026537323433816746667626232189289933810809550840731543;
      _weight[5] = 0.04667432993910655425413732479156533084522800284809613605669453781660467725115778296456898579690543322;
      _points[6] = 0.005319052002843740590997840273977394950171778649845101239090388582865436842261195140802135539827222464;
      _weight[6] = 0.05392665090053721636106293416964196355047711087332304374347740716255549922473738865652698714578246672;
      _points[7] = 0.5495243555935513136546896219603138697609059893623113297331642759135899174924012857390026360474762955;
      _weight[7] = 0.07717366634109808194395315371897661481697794303982356504901090232725807785964281183615873931332253627;
      _points[8] = 0.454161235754477099160096249961882970440028290412084992137967720315620010546080107378450741085561459;
      _weight[8] = 0.1133062126969649905762758964950627527929647767293146529704816117151296007557005216726923669605708807;
      _points[9] = 0.02781456191826005157198070923807354759531829239720000300594134265113548577494995954028054810204631919;
      _weight[9] = 0.1181106030271928203575530674800549317555657907909469016820334832959564842606168165865226255761452183;
      _points[10] = 0.360521693587057648157784440778396533845073304851300600175139415981041719351211561421203525213788629;
      _weight[10] = 0.1498955031684052123812771871602716067084415379038225419304375844804254640021209627209252643892922648;
      _points[11] = 0.06743186583899861338456857757181849448994028471133539011140154174279356463786171047590124871058861619;
      _weight[11] = 0.1661252306064170614951978271811555413440569614651595199924632464948276552123825945778602473840727527;
      _points[12] = 0.2719899659294862030563380079302590480247942543957991004491026215444180175182375256505110567396822931;
      _weight[12] = 0.1799662232824637334629206112030205761825115733710491636849576725169740218336869361061489424124481296;
      _points[13] = 0.1227482862154978393395873240130317032151265317293409309723332247616160353114996846526951659728971574;
      _weight[13] = 0.1925282306741192635536195068795429148549620175078239732019144990499724648233740495658097375472587461;
      _points[14] = 0.1917657062776536255028268450504200863445325847077754640124610110844518238511837287875868381479691005;
      _weight[14] = 0.1961650715776367222607857100338277674615403482968446824018357637392232405293324998845805559263136167;
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = 0.9786064374986970125728009137812822496042690312088548040286436320973606732995221437659921341073019234;
      _weight[0] = 0.00005111364227877400497664824914822312187523131871077788171487966030019098788805718497028848685167938348;
      _points[1] = 0.9432242857122455935254506623929578257508869485688987484186741352804265152613888933335080761298126981;
      _weight[1] = 0.0005503124159022070098783811162627949675055432854454242381238069353356523893162308519719894537983138428;
      _points[2] = 0.8936859745488040188148696987681606327646834274095997914162494394444252336597543340153733132728571942;
      _weight[2] = 0.00253783999827534747204339587398565531121845521667075873722207114552047240564197912364057170241739288;
      _points[3] = 0.8315558830264619518892063548240608922762470054306231569778660096958033620199460946608882490135090267;
      _weight[3] = 0.007694127704267096909529759414250766143904775295057170663912123460022589036462078267439682969987203195;
      _points[4] = 0.7588252579491414133542794053511356108796435680365038583957695605622632533727925268078632201504708403;
      _weight[4] = 0.01797939540591943553282655904326541648736843405213664835704382086461644807389169392510655535237023706;
      _points[5] = 0.6778299174145608113025127726414777500320971717496155010727267379426891048458460258015622127620921854;
      _weight[5] = 0.03499018198244827989832060255651272931793234290752719755245012805681995519918979378047157992202798509;
      _points[6] = 0.004727687122934592206150610445064477185987713349095208078315620471990461862622014098091988804943732811;
      _weight[6] = 0.04799762249876787834602678161657048141079099237527991579241094505115520768176249489883380358692632167;
      _points[7] = 0.5911723853165030889707605187763419229680436878682765211186872551925076536578972852139357400884025256;
      _weight[7] = 0.05921510663100695336095700399081714160082916113233465165244891577971830694111417358117886339758554005;
      _points[8] = 0.5016375561531875937001304323508376116775809382887043798099322048009739763486344428459428277727638743;
      _weight[8] = 0.08942874259811972089333893705457462540747878902452832779327225337155148601273155358526763706035859378;
      _points[9] = 0.02474296761943498451260345626953567205761528650626344100702897707414062868822532862058633802247189094;
      _weight[9] = 0.1058433700693581081617490582582260489397739540049851972587515247508128778921240398581401705139086582;
      _points[10] = 0.4121029641168595969172842136225134716264638462851170381104799491302816048435587877644761732164741742;
      _weight[10] = 0.1224481516713504381677953376318549301968971738616216687469062423535307787680712176524375047323900127;
      _points[11] = 0.06007643771663799227524225532811249949040794230939448604178028132546709554288543218317352848544150918;
      _weight[11] = 0.150743298727674291333260325777243530241463714895605434027434973309301093690716384177669881743882149;
      _points[12] = 0.3254462100241296148268368519018063901298314159028243246203929830145913417696717843549623084103386732;
      _weight[12] = 0.1533921878047438226943307636411683225532230366129434468301308130372556609842068604135406661181292303;
      _points[13] = 0.244452431744511377302076561602752031033579055361062019964516938437829086971547471305886973271011502;
      _weight[13] = 0.1764506307035974844556454963572807953528221877075630527904162026163913063727413866339740371354372271;
      _points[14] = 0.1096006092587706028678975846195003827709889318416547509152886361080137785970255407503143033719803205;
      _weight[14] = 0.1779862938901728599046041983508410784211710356810272044473323158434144748195799575920162751395462319;
      _points[15] = 0.1717247594830021079030741779126958738693210887070413817883535217741774057292701297715602601789514587;
      _weight[15] = 0.1860249575894506351880500844013307938590785059618964565637623170975868320778954318066738261222629478;
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = 0.9808438938474125636766637209275972068403939450087260749208889199283197846333843968554117528460090215;
      _weight[0] = 0.00003672321680050201588893508809125700046531141997623090861092178661431081419170841266491721846696051565;
      _points[1] = 0.9490970165965445702465476283565708297246607755586873532653724677803087032874699499858701150851049691;
      _weight[1] = 0.0003974261013418958398496273404764511239692337872082450246160077318175409175170546288895012284106365673;
      _points[2] = 0.9045054233143287003790610093283550812376120574920944369394302938533880974366435920451390516090983422;
      _weight[2] = 0.001846696235108452323081740268246607255059909970851485069280721260167157397850582769904163871861571394;
      _points[3] = 0.8483270857099506075790635313717878056529164545129232857765525221759979278054482949739136814535756339;
      _weight[3] = 0.005655535035824528926649613561049219086512768112197461770524280675540737290522504605487405853423758352;
      _points[4] = 0.7821731030812211281011385401557176313519720275190703032263911897342087238744392146926368605116439999;
      _weight[4] = 0.01338606916727926148618970164658395028370018090423553621907901080091060043469655162093802538030485222;
      _points[5] = 0.707945001385085567943622426073089923213717087524592918375047496075645698517876359910689968651062034;
      _weight[5] = 0.02646567904144685891462284647978091273368422635641062894104746521612846499613282277673498551270934374;
      _points[6] = 0.004229765486490767874991987781300685340308435773431352185301973416816197017575857315649567725783395143;
      _weight[6] = 0.0429926041230744866513362488197449940557411715901469062889684425716121073405792471713585540944974964;
      _points[7] = 0.6277775385468142725656053809477606660481926914076750686903817659859352892916227568745400677875818882;
      _weight[7] = 0.04565456895454675099029361310226524142448988405389158412248073822256735245132154460401903761295545258;
      _points[8] = 0.5439766780904757097451521743554710584231978091980306940950977666498348773038378260887674018571215284;
      _weight[8] = 0.07055515732420044207392583546335768383670146789242918934183781450503912339593438180917722727222643093;
      _points[9] = 0.02215270531183023229420900210157300154854505840882207694347863994881565153556420004262394660019368648;
      _weight[9] = 0.09535104807481297848202429866106118257566228137557417660332400853161662680302761699773305885383429565;
      _points[10] = 0.4589530533530190808593345147437514652455985649810014296771181666727254937874683576150552189676820445;
      _weight[10] = 0.09931702444790433120952426058302138873908984792726837791724440362064021175262692440686069358710680237;
      _points[11] = 0.3751525416408178820083477139222646171835998951809981629079410853435870113997403594064257319049096888;
      _weight[11] = 0.1286542804495145568686598485110360146860251475979356089399894897424306248964305507294249894650268248;
      _points[12] = 0.05385601482718482956676032201364452390207889406802519433016964589948411947150472054630517663168267146;
      _weight[12] = 0.1372315591826875201137474777560073360546853485740573862533356511173364265079156697526661117060022962;
      _points[13] = 0.2949858662980234886510059849705601329210424075903350147902591485628362645969755211291710565803372332;
      _weight[13] = 0.1542209677884094145128943284286812925327302523010098402991289260221514316057089544615700030218449205;
      _points[14] = 0.09843493683054136249424692423709782639488974724295841277288648647004523568418618804137473135772561813;
      _weight[14] = 0.1645759033882728284844431118628830743614989413169168358659006260722663488738016626358120054114977563;
      _points[15] = 0.2207592251921513839136378776833585067846629363530123208654012539977418973898636052213362063366054326;
      _weight[15] = 0.171301615711738213205756533380504272892453453514380537158994786696403130130385394099728124635078177;
      _points[16] = 0.1546079282658856298783890388078768159643889899573936780160589552820868047441765770328672418716605903;
      _weight[16] = 0.1756904750903703112344453123805424546908639066388433026089700387600911377246901618503645283631366504;
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = 0.982748407594286960633073899546303045149028562784532859367422241743337841463798829462474307855455184;
      _weight[0] = 0.00002684034449817248636307890670990759607627648491468895416588504339235192716316452092184439475732072083;
      _points[1] = 0.9541078955173166588189030938461288380596566681165619454485636499417392056850149493349451358778683482;
      _weight[1] = 0.0002917480346564748213126518173258607508890442325216746931561102953965933068483693177921983263851560636;
      _points[2] = 0.913769864110792936166123189791591200842146787728630171609250287891749264970030467465031991732660097;
      _weight[2] = 0.001364364814750619931583941001892832710526596444814880095801559791422327117557391969710365759943918772;
      _points[3] = 0.8627567207000550133608166202160961738680665986694630756476656758603077150109726400447325844934459061;
      _weight[3] = 0.004214201135828769484963761390752045700215974350846961473780225330124447098246374619584268057948317043;
      _points[4] = 0.8023851498364174702066737905851700573574353078541166033802958270590653479162625703154687749291640617;
      _weight[4] = 0.01008288655374502320909828094580508673228285324540546402052877073095600352583258281978552537379255498;
      _points[5] = 0.7342173081350132503192173614025312330653864334982702635244595308063572372883774041853861365278221063;
      _weight[5] = 0.02020099515341872526673649424020333062100969085759988997176723342299630382322198514555179632843105095;
      _points[6] = 0.6600181272253155465521234027038088059575554457571711316782527733933985664095417196979606497396358233;
      _weight[6] = 0.03540911290037990977420098813904969531272785240516766309095652038688854805794084594012390191614815156;
      _points[7] = 0.003806582247501876383648534354890812883653084218143725055850915751286505483558068230455044287128636871;
      _weight[7] = 0.03872959521506409270998592307661178898880126487708449836871701251355028383578477016496915438790270965;
      _points[8] = 0.5817090526709179282288375852933077443864571121132991743769987023431980248853066657774790851887703593;
      _weight[8] = 0.05577559061459162570281412768389355996651397767708828589498056037792211480330590031535721170146035938;
      _points[9] = 0.5013181027502735883646759853790557548582408474545762758344248448850577878823309680705395605759116039;
      _weight[9] = 0.08031456678547888071777527613084748403550086714243964330239128562327769673230247753017547024436125657;
      _points[10] = 0.01994835104734301866630127355057796010747457504422512741431541670739879638700930791801503643734067254;
      _weight[10] = 0.08631509071677530810863100163952706294278370989850041392675520998322403679573746872013264641728964926;
      _points[11] = 0.4209272758703179558039109560839247557191088306211527841459293605637953895210495784407565029266997559;
      _weight[11] = 0.1068936974758404779443918912465824233672883504398824139817461678734416233217909028738142876058300019;
      _points[12] = 0.04854964530422463096552581822459659415208810269879122661467419186763858390450800500055006660727244013;
      _weight[12] = 0.1253356306869180533118015916525710771304275652121960162491546992025945693808868351192974349323507061;
      _points[13] = 0.3426185978020083004514048444648040212380882146133496205314099376215388144800483221755275703026317421;
      _weight[13] = 0.1323839048082899911826910765424937040163915594177335399366773159697079625785760931901186843037828332;
      _points[14] = 0.08887625911649738804818139219495746882989597915475128356802041517986238494141608853322148611303921851;
      _weight[14] = 0.1523005370137907506618312924014636112216561687461645368895555297544914491320199297299184081013271168;
      _points[15] = 0.2684201827866020844201471280361786628127359425869124458724958784949980847348751285744762131603672814;
      _weight[15] = 0.1530511786893971990313986250253572460871774396855398171527438104801138575696244796632962408451428573;
      _points[16] = 0.2002536959236303382067125585321085063433107257362303407043370644457116850092167808120166500781902619;
      _weight[16] = 0.1651346632398309976571473150915354252515252272981002584619642650179028278177299248154542524099377471;
      _points[17] = 0.1398845708351692649300383552676525748959865708235061557519490749172429745529982954346474136929122904;
      _weight[17] = 0.1655087291500782613306060164007111909015389149173326868684911715359303365087638368773296390165836235;
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = 0.9843828065517020106761276174556909144026325831604026447615399145866983347355888758046066379113914637;
      _weight[0] = 0.00001992280932787647270670068121504406904050878009796350082427834039239683808319955860954897199570269474;
      _points[1] = 0.9584169024234071451034779092669423904741880674092767651904315631184608661010553708352299289446592984;
      _weight[1] = 0.0002173705725280176670944890960502804423166204597532801450098392340276614206659788761434319343756988316;
      _points[2] = 0.9217606817291400488993742163227374545276684154855298882918293363660999418596388711657739790912190745;
      _weight[2] = 0.001022123435563885025902206640552076666567191786422602535420698723807095034807642183511143694636939209;
      _points[3] = 0.8752531629838266800659489088760858408079696488715943336759069360574915944199538127854460103635272211;
      _weight[3] = 0.003180177301794237493019314012687144031688576745974063615856410069920493919217044916534773054139522466;
      _points[4] = 0.8199803570632373353795400684102916116941435268852334780207569085081760303785333606287354427331798866;
      _weight[4] = 0.007679153890769252819349084362266762034680794496687220780226080890557707688737671772550611046414520838;
      _points[5] = 0.7572365191732979354973693279466696491303870879952976126011813160845715548094948766085611653832161417;
      _weight[5] = 0.01555913925021236084119398351318324635350878964483833382275711925200825311327878919159166803224050802;
      _points[6] = 0.6884917909140949891898655120380168800849788729479226796014048212433893444546592668647864865663296238;
      _weight[6] = 0.02764324431172879278940581658661853456999576463765561596565228984548554485346431017256946431651819152;
      _points[7] = 0.00344389040386249028069405093317222181182377640029914128584811126158447282426935788168626248683411491;
      _weight[7] = 0.03506918822751692946455730452233595458916116289923823285432079838303497328566987932630680788077123048;
      _points[8] = 0.6153572448045471654669401635833708805050867627458286076001673229030120048708698995373393775522832916;
      _weight[8] = 0.04424576251614803158884713918509202323760369304517733604518806841090123069603439631756455979147352893;
      _points[9] = 0.5395469627920880876694306633299818817017043399462428376541362226335526976593984274704483496113346924;
      _weight[9] = 0.06492726128798530252071044988969133477365566175334068106698994747182582468433303021020195666737121263;
      _points[10] = 0.01805697833790056286303009395434268665894880733591034692641015267785535091595126090806803068847434545;
      _weight[10] = 0.07848342536092973805160513510880688200259433707189886999155358202518740624336539197330534394096169371;
      _points[11] = 0.4628377985520202782022048705469377514873721078497890685487969094434993704576336247176078079949870379;
      _weight[11] = 0.08836225259929596186133469102150733448918159724655286754038526721794532427584912859912903335150515709;
      _points[12] = 0.3870277027693322034154529075168274250441355570183945919149496613274873431354056703498844308990953007;
      _weight[12] = 0.1123664317444116305965655143169402510025365271744523979648159561101015872421911323846125879396222849;
      _points[13] = 0.04398739509084273445519883277365948261943201401533755288465140272078804107508383052868780286880037334;
      _weight[13] = 0.1148325991148163444911640277657323543047270823476765245035320839854858063568929732605305651848156571;
      _points[14] = 0.3138935674182182241524085986530725421833888559124072140832271736633880973343121552225350975792017752;
      _weight[14] = 0.134100272282441135843622802269838878514535106695959606198030755727139751181154620361343864744773243;
      _points[15] = 0.08063327636666141546972177666301584599572774478496515259512648347202733971049631258972859243872553855;
      _weight[15] = 0.1411124687979040017383983383889387833636924536378786579842406801114338206400330468092921847805161686;
      _points[16] = 0.2451495690951685705524921770182137890794445582375331816751643930651784772617999016157149898754773397;
      _weight[16] = 0.1504300020813901758036486944453268769096163950084233519532702102196909305554659060185430103650449769;
      _points[17] = 0.1271364098615602695300253508396918022790446090548847239057383641397465202768706860278890106271755421;
      _weight[17] = 0.1556895448890469502039433952460571175059219100966614582090178761629870656252840687807066371333142135;
      _points[18] = 0.1824069836690918531306969538712789495119226639431501787827330067269926177189844384572705963840879384;
      _weight[18] = 0.1583929928595227080602642462804924544723091598046442686562413911514004596788051226202861652655253789;
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = 0.9857957888406418466800231313592152785604899067877207377306395965180365635041144860468676436334983574;
      _weight[0] = 0.00001499688397334853909009654734905514945521257651242233497492603278336052697351239051006226204854156653;
      _points[1] = 0.9621487121504981897091608064229207407940341288068742181995487210154653226478330645824175987235472225;
      _weight[1] = 0.0001641564083492808221962961635922449664007417807376345432948175005715964939937779190026714134500071776;
      _points[2] = 0.9286990149187505453450978371672693948888756101758623893390553359882107838318818368546819590506483564;
      _weight[2] = 0.0007755532384700472430793540610379271893135838353708382828748805776320956014381700141548785598395884206;
      _points[3] = 0.8861413029145471436872829303649495040166030756579052437556327864000033121939155088226394817590025748;
      _weight[3] = 0.002428182817069033016610894924350833114680897738357536155240424761102475327226118558922110562054613683;
      _points[4] = 0.835378914631561725171518394713412658084401759968059337516039711093759997511552876897585105888108726;
      _weight[4] = 0.005909777767885943225135430582621307955547100153876209416844747358074494910134249252257133135713181473;
      _points[5] = 0.7774925920354867535511259458365767833501645594282318185786818344152523063340596941838540072199020297;
      _weight[5] = 0.01208995668362951749967394391224448828054059207291389348694724435189801244587869887557864332435867969;
      _points[6] = 0.7137156110152876807420834353539261845083764977327116606392342641138367359145141329606212643884043524;
      _weight[6] = 0.02172836322449210980004804457059473249949021836957893650421253545420376191894281707541313281395790445;
      _points[7] = 0.003130683740743589562150141749546251006558087897339829841211539349738274314866496852982779908203455384;
      _weight[7] = 0.03190317094510660674090924062970198411577078121671833534897277070677203833980338615982239630856403199;
      _points[8] = 0.6454070457773675666173208347639696868480924890494238974440167033076937496843430736866993320402326217;
      _weight[8] = 0.03525422431297342131570109267190665101713924409722248740423389077510379965048840746566703817840967523;
      _points[9] = 0.5740226581828268717275121966537067538016418929949592700206557877680052279117492170391822933202016281;
      _weight[9] = 0.05256367702664660696843253488312400143294584902673080355015772217448264100685386833519746415036752641;
      _points[10] = 0.01642208813398783290254161425625752298093599837033552370593506952105049398340715992554357459620698864;
      _weight[10] = 0.07165500930295423640709583546529029927063232240443669945496644251219376217691519736672476809671709037;
      _points[11] = 0.5010838154828485513706246541369263270496076238639477776074661526726511056457717245333351712537248934;
      _weight[11] = 0.07288201367307476620737326123903540949531459313127703706325526164891890426846954818738827733176229809;
      _points[12] = 0.4281450409332566846154250347724519581718006946562795606850444879460088034322223621075385140190445604;
      _weight[12] = 0.09472916165698421592346580106597904566789390110319129543362928719528014089962861825723013260548530379;
      _points[13] = 0.04003690046190678099632014982879280251919218202100623418922253900409985734318539080916720634178996678;
      _weight[13] = 0.1055302577165023391780536338961832585932656024160937632538479770610925703787292264148375828435711154;
      _points[14] = 0.3567608701024531056470550666332594421879937365627218234316645015120881052816834839729303782691229973;
      _weight[14] = 0.1160096189823571406796654290456113281805357426540610444070368909950710161534150063798066831796666365;
      _points[15] = 0.07347719178528528305756654528587446712162956746829331567597923056648385302094819196497247815553334907;
      _weight[15] = 0.1309385772702925921899186259959536648124379399531342254695653323236852472377607884882919968014591912;
      _points[16] = 0.2884527121812723847719407066523953852068123046578582394812568730574474727765765420104187934722455199;
      _weight[16] = 0.134225725813901973916010859290956315174257925122368934739958261965474015514859603925292839755104494;
      _points[17] = 0.1160309076554868049466974315674778539277330768012538553063813735353261223084763159059242881112717542;
      _weight[17] = 0.1463516662129082599464371823076988796401775386811170193209364125128477705820631778004347152301799095;
      _points[18] = 0.2246764193843050384093819648321044864540754911683337333822542507266562834493851020811842664368541631;
      _weight[18] = 0.1467896818880725308530169982826116192006045612648753091087111859984896015533920748162929571735174518;
      _points[19] = 0.1667912534810094300129807014584903280447908397404053429938887652977094384333228625709776729362660067;
      _weight[19] = 0.1513895615076893628614187777974902875769289857347589080536723214276560283463670856505077453685905939;
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = 0.9870255665787578365469005516471821103487323205471391754376943598319864464211860106934058825645258605;
      _weight[0] = 0.00001143393418724068380170413895308611060849814044915809164226820001407628104622909351779375362862754133;
      _points[1] = 0.9654016073657424580929490790442942557127428617746879386553787549823009422401519559419539901187908714;
      _weight[1] = 0.0001255089335871709281118126890978511883410232408935299359481594966361344340514817928666164963461870615;
      _points[2] = 0.9347604364012299479827942935966019857975433066835579885667315868005288394577841513140255125926971028;
      _weight[2] = 0.0005953999959462022743715146028300385175077092750037786268248278976636240495566479815754772134557262851;
      _points[3] = 0.8956817429254667605282025742976504630403884116278020040145896760872923029903183803945118949524779672;
      _weight[3] = 0.001874294450135896801731784503573779401671276969326976735014995475320855077785022212257014129577865045;
      _points[4] = 0.8489227735376888398440174689512629925240544749893709330516913793468738663135396111526364874935057414;
      _weight[4] = 0.004592965682865899309081525926914390207513681471407921864480309470237783124356199535498939949623202478;
      _points[5] = 0.7953925737461314623249865033277437002775654540111543847783430994750663228409525643598837266227268953;
      _weight[5] = 0.009474486138446127589636908414029505700709517833191754141564237314203429084320420413231363560359878364;
      _points[6] = 0.736132620597287348464102976702205297915724058040746277165260616804853384913595025246627455052229207;
      _weight[6] = 0.01719724025685366088414548084037341187485771394568726343623778138278751292702859398535198066378906091;
      _points[7] = 0.6722961409869296162899704994812126870277260383783201960320999269060656781743057964570096111577941914;
      _weight[7] = 0.02822928389744864174544586786898217788137229652458972736832397295131736231647885061286268917613281016;
      _points[8] = 0.00285835060009189432225562771682668948582857512454396863027797721426567661617667311949044311935799591;
      _weight[8] = 0.02914652692549772359825191743397280020164868373562383178741132669912525302067096472110019756153082352;
      _points[9] = 0.6051255339761019284481098523077407624240428731564207776008663713434935031358888405650262217950025242;
      _weight[9] = 0.04266508146203472287514740814497105426127212704884677528002189938589343854792402933566360152308841045;
      _points[10] = 0.5359281386930321609326895183917609968520364389050114840655237758106639373854988648624902834575404957;
      _weight[10] = 0.06009811216766876110645301901080290470540542252779656010666162330015632690205531715683178923222126385;
      _points[11] = 0.01499936497207552234035713591602254705393618831318367785565166039034387086356684984726917088159977164;
      _weight[11] = 0.06566824457697127529902981695220767771270006886685278602736453053393289071075554704667985742556471193;
      _points[12] = 0.4660507666351746484729664900381236689850117104625250010739461671795351570200905473063913279087995362;
      _weight[12] = 0.07955912026541126007769813685510363475963878808713764989375842730287294266866641538077148042860200142;
      _points[13] = 0.03659386328114012262654505528218600854572346118015453102909226025011769718948800713156805117021348771;
      _weight[13] = 0.09726429982522235339421302162613403019875891383246840547625842897557731247557947987411501254680287177;
      _points[14] = 0.3968534769856190095039434290948319231559830819379799669417186235032912613191108923209116958842566661;
      _weight[14] = 0.0995403355010239132382717196606446428701230436642824894483894589415408071164372671565051418449066339;
      _points[15] = 0.3296830989901027237373491420545228582656516694202723447101849302637120749496599731334902543040306285;
      _weight[15] = 0.1181122908083299756311975390634647250493155093193591314865424228051155593226483354511888038664192693;
      _points[16] = 0.06722644166793863852656394767467500357144072170962214241165856897826976130638620748193107205233694509;
      _weight[16] = 0.1216954186195147767859181700852196598453398974387542750341310709128680231375238395840669422159454729;
      _points[17] = 0.2658470140108159098108921515437181536788750914282933339485578881666960769687043708156597820375066426;
      _weight[17] = 0.1331241870513333849458925379704009194981324486702047607071260864313889685659564325467513394603855075;
      _points[18] = 0.1063014797376931175504486884739310046446260359816027861282438230188065644711946783060826726008422005;
      _weight[18] = 0.1375542142025096877653615060378353535237823217814758119642712415097028824989683064469150618759633061;
      _points[19] = 0.2065877060825335686769803341751510840175689986107977624063634924301173628588357156175136088108010249;
      _weight[19] = 0.1424637790987724784544985952839802649730864625728979547070145816086846459169762856846041536108135636;
      _points[20] = 0.1530585749557192122497019530096285339475255004440860527688523339429919998362921566593935826956915166;
      _weight[20] = 0.1443411095395721799450733462238414248515479283870827912143456827382935051545476673209780806694503178;
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = 0.9881024599908778831834893508543820892773502151203394249702418542482522913410591542225873730537640238;
      _weight[0] = 0.000008819828241607839113836319188467664692011455724039965611658207161388061470286555951138804647517523762;
      _points[1] = 0.9682538838165636528816421008794414241196089368489573782572610534009132752925859249504071948887717238;
      _weight[1] = 0.00009705271167906710277821920044618755965438716605308287260605611296691915914345444845503274559759113985;
      _points[2] = 0.9400856692108184696160307746610789762831294650129674325772200327073362883580966732090847381891661162;
      _weight[2] = 0.0004620588367040999729282212179118719403671385452681342157971829216665667312380747639184954064858913054;
      _points[3] = 0.9040851784977527206617013643188418266790222208067682092434771080729602120076277567836036898919526278;
      _weight[3] = 0.001461453138691387066178714368792017613580659773821636378785062623685765189258882757952421529824382382;
      _points[4] = 0.860891752762866217306561289088760798024280407816610933118125205649126736100379365501381094748080698;
      _weight[4] = 0.003602665011170079496010454313375118125820248682611777483518813337130543978051137706444943926445444968;
      _points[5] = 0.8112752068392205078781186463119643007891999522242449004575256452024235067993066706011518445018605716;
      _weight[5] = 0.007485551813034275817216951148497417410643864099134073165862080079074318408799086608465326459832194165;
      _points[6] = 0.756120559178934871229287935277861726124138068090238740139279322617849153755355308054543314195952641;
      _weight[6] = 0.01370427408387923505535094139296990898530719232986605891147317475726272903114323254491117374114252769;
      _points[7] = 0.6964118629859517266112670768971276038290954874249845702950806736765993872213401445317623482971794438;
      _weight[7] = 0.02272307353970016175798801382037590056507281990311145345973578790932392062647349992155849279080103849;
      _points[8] = 0.002620074720371159424859367455264888905528254905967075341414209716403766002695753259982505462790702161;
      _weight[8] = 0.02673172609568654751853295736245388910769904510379438631959110356067466777925600320462833457894380703;
      _points[9] = 0.6332145255726628427916625618237318565701781915004554642631578635011061799446656933683602264420425428;
      _weight[9] = 0.03474679389549965662247861906215097123019694954611807141411557017597677027192888562429244380178121545;
      _points[10] = 0.5676562502726097870217726677178769223611025672537427859994804146174746381249794034881861040558801353;
      _weight[10] = 0.04960981404383829993700779271549480288885853637660176997186571280097470956587682931711438082157298981;
      _points[11] = 0.01375365798738580402575675070905872963577871007529049791330105411351782591035575021061471597349499472;
      _weight[11] = 0.06039224968649528527797201695304747719350890246767119584138949538030174755780883063573431771451573801;
      _points[12] = 0.5009068926479350501177501589277218806508226892948913257700098794311718939499484259368208163972501152;
      _weight[12] = 0.06670592951879767846792762476690622296014280028874613091699757533426509227995492281918325108396123329;
      _points[13] = 0.4341575748401551375082012124710567475311318981229697451221181030460066453494908033714119124482954651;
      _weight[13] = 0.08497667125409721785945148880879745505881359027847151653606924351274875356349984209037489762238788007;
      _points[14] = 0.03357522684802669271430819164015782255936555354251479618256136085248644097781000029083755653408339061;
      _weight[14] = 0.08989485493810659201312259319068572635263313059560239420597839977609904961839090425684384721793834645;
      _points[15] = 0.3685994249559412825032166420129271053410258894370369258634481384659319950868454860519985944915827024;
      _weight[15] = 0.1029672849391876735260280671946109142630666826269145737607246207862594409036669986746323585832975334;
      _points[16] = 0.06173556162306960169082657439530799232593239853434981616795449869395358825349510725475770984104108369;
      _weight[16] = 0.1132978321011550534569339446690910280401715810568023622298179018105850110347547332801463511728914714;
      _points[17] = 0.3054023184425990231526085351824413364932159709089239800101319162552567160333479391342542847608906839;
      _weight[17] = 0.118949346513709232985602192391896693374558508471962113359062925535623349061768764063169676690434175;
      _points[18] = 0.09773269667536864245847988499672332346923869097633493640302023050164801771896428112688852124513295678;
      _weight[18] = 0.1293178958114777478613063500315394516761550424810764340961225637292240059327409033219260993510310263;
      _points[19] = 0.245693999624503322224465199004346511040095219161282162101130888622591782757543602487249492370203605;
      _weight[19] = 0.1310983476019885069549959653684284929730374753089605272225430034875336215931548267651214213714624036;
      _points[20] = 0.14092439775695158519450619775816451884611959708690538685783129704464061843005866589153388941048851;
      _weight[20] = 0.1373943986576711189457038637687127484198195244023737460240143431480038626621631210916534276483539123;
      _points[21] = 0.1905399551842166284991396915288050974055091810716148172940553365188707797144828728812777249740083098;
      _weight[21] = 0.1377052393125228077987045052679605699295332423726478549816510583467911003227901128808596332546938645;
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = 0.9890507733735791253543712469758400035281773409051211956278514761266032259261348911429860283320820851;
      _weight[0] = 0.000006876667443448386873597174615624846641300742166712499390444623619723899261299135896561250296435335989;
      _points[1] = 0.9707685195733889938794720318771182548024669818727768010084319949615096226307776604478341088419960687;
      _weight[1] = 0.00007583423894827645199529497212749310045124079552553215845278302430393444077320694676832428355417760795;
      _points[2] = 0.9447885021959101873192640703319531140411645602202181230261730429904477029248254097807519999563813321;
      _weight[2] = 0.0003621778022397484227568716984452699810122401675080385621920809602503235452142352579992064490492180786;
      _points[3] = 0.9115232476013712848631727800493825734445243013466233941759256931038532414323388171548016643162639101;
      _weight[3] = 0.001150314682984822344334855610916138444468915824198344682212336984814856306470038289503572924918974143;
      _points[4] = 0.8715161336713438696663789268096078560203102425650686035780009545736051097600251592363012603490395307;
      _weight[4] = 0.002850497081093543249504950370776049252981886294476489764789366131665472664109268239563547266953185198;
      _points[5] = 0.8254231835351607786693628066740285412448723033292098215120413379094288517271797907093120388750575164;
      _weight[5] = 0.005960272673820516018892550728367359102119125009944955607272944225823529645958240764551805100276375076;
      _points[6] = 0.774000884826103954870602865039850232459354767308173945418496573567419087448226053026498675219714321;
      _weight[6] = 0.01099396318272331474169753508597427233921996009999619601995167163454190521119038525024744167647511149;
      _points[7] = 0.718093423039932334870528968550415558136496950365395538952664548514450259640017620337759804908076215;
      _weight[7] = 0.01838949716531371895801221750607384775779877835883666504812201193134363107981822179196427825682835979;
      _points[8] = 0.002410403998251780792451856588101972909066529739119798212188046208814258289064772101273823619146110848;
      _weight[8] = 0.02460458715379363680944285409901799406845331559876742556717226362516710861484213381914616524325269173;
      _points[9] = 0.6586187096898888135130219138910443233073970121048619807684601196253997338641760466888560080659310002;
      _weight[9] = 0.02840664653778501707948217016440661524304227052022033505140575431516377941086740846607743484483156773;
      _points[10] = 0.5965532681512670094276258199980622909368222170766033931827570264949111422639694369359726047707370604;
      _weight[10] = 0.04103337000606945503503522217670326104878723363104651468601157260930516194676854942670347964613293905;
      _points[11] = 0.0126567991854554032486919041147616055178068993488019404920062315307023102839017774129144625521651445;
      _weight[11] = 0.05572024457122334686306970307932336946322249656441291155755441029051172750463539491200291665562579443;
      _points[12] = 0.5329161809469259852961679422880949408372018266872169088225806359785246671619598639988003464099914504;
      _weight[12] = 0.05591706970939040592614623445525001285248857059702692030395415650257556886501471071456697084452361735;
      _points[13] = 0.4687523477214090214073558308296168896809398353261455806058774838069360883559041595095033610401987426;
      _weight[13] = 0.07233501875091631840919628023809183145752557746817854260441269393620510970432941834632187160557783416;
      _points[14] = 0.03091420521685777042524659261449895967467270312206086783863872080618109788426269086493255324515362316;
      _weight[14] = 0.08330302639229947932606202543244005159580104495976244028104260557408709909900455946501879510312450854;
      _points[15] = 0.4051153234824939152589899821459852518084292041960127091818387323191589246479819549763061565524843399;
      _weight[15] = 0.08921331592042749615179791387250922454007077948520920020945311505702881983826510488006429430176552302;
      _points[16] = 0.3430500166905744572249642236228373303079210262636306213248867962132213743211306739909111276661963969;
      _weight[16] = 0.1051971301902735212171552740490809864687285728732286101918097259253218725264728006157687448724567674;
      _points[17] = 0.05688697073444690821032588838336961743654015907339725082650819749305629473627316130856328689737426324;
      _weight[17] = 0.1056636634236599800025960030696444996116926205371369655056408389679930032480510185451962577501990656;
      _points[18] = 0.2835755302598378337994539658113249207907562733532297915625840729145925650514832273388671279031826889;
      _weight[18] = 0.1187676404312684393557883257269936135587246278818678797038987739015900277273626487102457050127845038;
      _points[19] = 0.09014913455773984691589948612922737211413253931649758225808067949438711851934860889153068726819551827;
      _weight[19] = 0.1216392044936975061036741688714549551287865944305569473422823525233694802740589876102729570564236371;
      _points[20] = 0.2276684266411056773027710770956689945976517001579188130220661151724974754332539072451049501434355138;
      _weight[20] = 0.1283940193233969697677293919549598541264664191744484566283510181595252794240699445354258114294514256;
      _points[21] = 0.1301546569620392647297136145470657135930380187181655783102116317627332537731657610993460755762494399;
      _weight[21] = 0.1306458637267026875983182867538939685731303811410348704694137140183344576684464387632647813109838146;
      _points[22] = 0.1762466912782491162874995389654770161435899409370830936250632217648999272579318891342051808242810613;
      _weight[22] = 0.132703099207861685113771606242267040771719381177782378888546698410791460688349318846771129681170662;
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = 0.9898901712174520906251165597593773918847523673221438024487047832202131975743714655305404620841092336;
      _weight[0] = 0.000005414795649621589410956891889788871742947297812794956478833735739984001890036849423513416122201443394;
      _points[1] = 0.9729966238607434240581902575081331739557554587997081204643390924536815578867557077759207213916891928;
      _weight[1] = 0.00005982741578200805140757442756876710357681187764184129492998044221027472286015156917522457282670014999;
      _points[2] = 0.9489617024727324761890720630019867067891512669388670367116995074683944983852471238704034144706207455;
      _weight[2] = 0.0002865262744228954315248621894840737436204226419751809547178299642115143727296322854938132384108068028;
      _points[3] = 0.9181367783042758317115298970528403234116421141197280467998314494812585311720032200286955057989618405;
      _weight[3] = 0.0009133865187289247367136496244884025935049017690707982258831296507599797381201681041293897274275549488;
      _points[4] = 0.8809865112004901553982606734371066424293828263572332748538020660425345593942795437337711303415925046;
      _weight[4] = 0.002273816875030566631082337760719505683063855834506483104577945072621905255965654055089511921562870697;
      _points[5] = 0.8380732394393357620477594707813738107956440957803211619128696670627887064733041577933862555402708822;
      _weight[5] = 0.00478099155488135631829927873735610850636015195412822564225728586449440911997072816425107894901952503;
      _points[6] = 0.7900471558143551952024299464595864800685694943997857653563880504121078982496465547542056175539248754;
      _weight[6] = 0.008877010801018946117185025924342474510540324525513331403312263343710478394357406571414381506861644254;
      _points[7] = 0.7376361331966650834319952799565664239997149439085959623604215726217384164028452637066239693458780367;
      _weight[7] = 0.0149629346691495350546165739431368442535998577893856441120639179339871284732782984334631217432407532;
      _points[8] = 0.002224935452613053665891943069255750028001477799647205535966283412159514791582999304672758496614559806;
      _weight[8] = 0.02272123685713789434030881931524938582897026979966692028426173000267001400447472415900288947310363378;
      _points[9] = 0.6816345890584223343347584224654693833359846182784640936142748749084889259843441535034498170983533268;
      _weight[9] = 0.02331919963843795558856289001178667829714874513151429202299104727270255015570026749611235251715190262;
      _points[10] = 0.6228914041763613552769405578811627797744735067301256611232410007539390365503687846951176550441159124;
      _weight[10] = 0.03402821314534665504742300668651742375478680187207505350701851655484252062079811817240060870672024125;
      _points[11] = 0.5622970377001162863211472577185407563882405046536041909948441852501756198349145685895124686912743446;
      _weight[11] = 0.0469115578091407435119135971531759206211456446784961440590979776235609374016068710085926652077969101;
      _points[12] = 0.01168600396976784119585970645372596213506262775598593366556381424441620764977273721853043934271845157;
      _weight[12] = 0.05156450302852561733106515247255298513224662256829380501788829770758411341850704243518347036063351569;
      _points[13] = 0.5007700206965443044420384481447814267438751908957880531164770293158552605883981361981888199260713036;
      _weight[13] = 0.06149308156503639872799358294626381094725788384605781475174499580448305892704309824786744398644990349;
      _points[14] = 0.4392430280138590771400222586966484479281187490364367805606402616906997553927361513577773490887077744;
      _weight[14] = 0.07699630754163361492101271509761239393849942140377941862209472613642061946357771589251994659060800813;
      _points[15] = 0.02855661419100575078433773106991474313748189689392150746530677045392972682926951708896373028078886491;
      _weight[15] = 0.07738771704125657665401015992403564121662898479846865035804772254684527134060060366464554448623310962;
      _points[16] = 0.3786487375725983130255223763826594151980352418923449568992150385696141263998799737945727620052669868;
      _weight[16] = 0.09238041135649377632848298626350660907150032768554403014238224628817114536167770593375677111179164115;
      _points[17] = 0.05258483976432183438541473688430542352634574929408691847030569765319726770565337571037990112697772436;
      _weight[17] = 0.09871617322318441702547220169324858290886567033955491182963415229959747527921243023604411058331651761;
      _points[18] = 0.3199056905142705147196284477592600478118677860085346296646837337943071384012733116212835394981488244;
      _weight[18] = 0.1064140204072954464118267057242311153891075934728738476926957640344192610080730226508773305006220935;
      _points[19] = 0.08340690827115669342265715031914870712393513349406943625573196053823905284341476460595076132799896886;
      _weight[19] = 0.1144998723800464282627119569938636431402696445948437363201340620984458709118113476601838585175390686;
      _points[20] = 0.2639043660726025930345938310051340067520452082079640857559305951097397292053028574030042265001554412;
      _weight[20] = 0.1177809496131256963154687299353704343516432112100715198188912862742036151417784070771267150847230789;
      _points[21] = 0.1205557027005187819785359775783852711983906679686549822611192158244964090168065655430091806355845052;
      _weight[21] = 0.1241560818892750740513319197449305270799796663008705162149327212005494018765146066229283656762922961;
      _points[22] = 0.2114936819377605655182888616348370137102012365281441126857995265139411092227855461865391104829793346;
      _weight[22] = 0.1252073956815181771346127294596215849298975190508766297740178851158073346196145842747014091777703977;
      _points[23] = 0.1634681244020306820900081449797999118733278369358442810228438232040837540450435199855004039271963652;
      _weight[23] = 0.127596703251215007750895920412380631459376052890311743223279016365294469723170711769195350434667225;
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = 0.9906367009503252040186638786057673854869752103072860840212608497776729091053687956427078165918374823;
      _weight[0] = 0.000004302755109283992853390612984473905388520107606420784662639203221026015612852498093180719624771642562;
      _points[1] = 0.9749800156322561440080537979319428058608688920634258011461633746480601222229645349760627442122976592;
      _weight[1] = 0.00004762148988535869484357810517214382489037315091947178037681066416731762841027085559169817014266353776;
      _points[2] = 0.9526814786656007765604428427646471107128280724641542445681143547072496089803389360499312827713045016;
      _weight[2] = 0.0002286333412778897125360878868810677218018864957423887924835086482637072540841046732817968346432845905;
      _points[3] = 0.924042107591375088183860270299603460716277839946970651202689016561215748927105401944373367096390483;
      _weight[3] = 0.0007312150296955576038999427301489336061245571898075392624561063075884138374981784504825108417887624151;
      _points[4] = 0.8894615186907393745656503873951861823090345844702245018938672248913223057207012920176380233027947257;
      _weight[4] = 0.001827746097251135206530204407903268733428075081612346622935423986110324998010804043842916652568803827;
      _points[5] = 0.8494243882656275732290900248503280680907322871463571360374955681062300158144452515011786494799600204;
      _weight[5] = 0.003862047153394014885660554694647840111512019761959973821093873699280118779178659279767371558180975605;
      _points[6] = 0.8044924465194527143198696101390306595020306714115014471218090194399979166482091146097001614651134795;
      _weight[6] = 0.0072126346647461759192556190144110051057368556634141677806079889518799372758034872159931011806213675;
      _points[7] = 0.7552962978229513043581799301877042674961500659949106188709770331116463725525761120695916327062411829;
      _weight[7] = 0.0122400733886804262239638702260922483882869874656751208959231837292087749645032165693967788849201739;
      _points[8] = 0.7025264744308617327764735628652519707991262430777878489777111185176795447563520263257678166613306619;
      _weight[8] = 0.01922488755916925990273545208551839304413598984038948928740273847627349626429186204670641466309370472;
      _points[9] = 0.002060081929097883499230548771256641683030644135588557914779023101696836289714772146200530803150593157;
      _weight[9] = 0.02104584654991310894984769694957997264389234706488954830869366146363669643607673681276112765962831785;
      _points[10] = 0.6469237071357920937508249478501848787366871342377897238574359882034872352624041632877614982121503125;
      _weight[10] = 0.02830437637751160048700083768002130944295668211190091848676117122152547090095035944438706910338866601;
      _points[11] = 0.5892685115570647814127303043715788194113182486287723623739652905892272971097895471854805549415698537;
      _weight[11] = 0.03941749238248017695654904390708201200479612204684234083409815391209463268142666322461799547268657044;
      _points[12] = 0.01082268301359031138105841238638610741754419495014618572099843382803432892580641158216400725801855869;
      _weight[12] = 0.04785247342860094090713410636696065372543581105275627351894179124877984338090126845647482492287693387;
      _points[13] = 0.5303702240359852173396065663591384210267634451500462472121109299789877460508376633515105839528377266;
      _weight[13] = 0.05226654254025416026230055459765768735408748982342137352210401586284879927470555960353573242755475313;
      _points[14] = 0.4710556365226797192363701668337433453652680273700752120149035736826756466148957367682835979522326213;
      _weight[14] = 0.06630287633400960740664405539791593674018482270105306573866739446952101295678770123011621440596649791;
      _points[15] = 0.02645812972355433281261111502741448762381582930484579072074942380857494497686847934716860456297192619;
      _weight[15] = 0.07206284363820171160165937570261028877417915555039796312170958415818099948789627440800921583584439041;
      _points[16] = 0.4121573881255929482897040156029304602803026810481251319022819080784439249416642297798100544798503957;
      _weight[16] = 0.08074110304100429667322390015353026479458249971802668553808949061734867458681218551998618063433486086;
      _points[17] = 0.04875046551971594256626048405495149863872650262007427692289050523464258580283035772642693653318980664;
      _weight[17] = 0.09238508110486277697046072106183462307349301111542269581192066431251586682339655452939053211823346898;
      _points[18] = 0.3545022754336092801330830225246756319748235396671835065241829375954950971669723822236925390213555707;
      _weight[18] = 0.09460303776621984255911428340425176633044568964941211415406548859126157076222722306525009261263870048;
      _points[19] = 0.2988996452854616817472628058730197227314433867599336194504840923830631129196201993067222862706236927;
      _weight[19] = 0.106788917328849938310343580342129676248041289822079930729453242089902642978743856332781087264853323;
      _points[20] = 0.07738719047941864058844549035651095463419321093462887741820043230753007046145151599424606907648132144;
      _weight[20] = 0.1078731206753558255699920516316999773845920194453412445398199388813993235893370279142238853057140305;
      _points[21] = 0.2461300326799557368501708657724630388374281519477683919406243379905396093914799829014978822920175362;
      _weight[21] = 0.1161699062528098563285204629158808188551384494639865932612070092262711343486676737524132437966100165;
      _points[22] = 0.1119664131211797080591453118900233568411335618341266482302911307568798211658937390561142794026721151;
      _weight[22] = 0.1179603120946719806730046151597300929107578524479463578273411646787924756993067021805470346187081039;
      _points[23] = 0.1969342031254723248318136513226723837261617920675631369200407885476768048090584724200227907109775708;
      _weight[23] = 0.1216929757207637586818931039746277834402913288184501947402046698604718770716389339788734360764541048;
      _points[24] = 0.1520027529734087162506287551943575708665665516914832278052044133827396241518816510167155210118609714;
      _weight[24] = 0.1224872666186146488533662443240610951691534977442791141723136190727891953370651772473494342557863352;
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = 0.9913035622385110788790336653178278306638685473029327049342568556768750779226166802910464862467032347;
      _weight[0] = 0.000003448114359757205756745360166489525198386376580749197638121869912495215206262890112928773755959767302;
      _points[1] = 0.9767531733280232298662661702683429698796977567485282341214009937436918106009940247102813503324814623;
      _weight[1] = 0.00003822053883255387900554746410523715204390828917060415678743895044994612478539092658170443346156339384;
      _points[2] = 0.9560108839274215742662198697342406595278034313234337217490396871934265900098665899697971229408821363;
      _weight[2] = 0.0001839034851575356489389594530597318328668080169779138264875530228689413045229252063322910022564475327;
      _points[3] = 0.9293359602715748334061432334478793404990512001092018428658048417839597361733846070929979731803178747;
      _weight[3] = 0.0005898711555596490013159173847175552002172211131197603246704873932959527131487834703954937504716351496;
      _points[4] = 0.8970739084211864094916125355818095043974285476361644489211453364655049867582275024468773277447054481;
      _weight[4] = 0.001479803510496533483770404222388761836968823110573963984604554556290327130157655956042477051021174593;
      _points[5] = 0.8596446098087925495341476044048610631434683111426290228292610152787315792738718461682721701424965136;
      _weight[5] = 0.003140570491033566324169178308200812903593777775611657950464043256177915220403707237044709370474184913;
      _points[6] = 0.8175357317097885446226654263638273500789689214285257860423082060382710028297478571779544782286374496;
      _weight[6] = 0.005895624378770345168835737990923267314213457921731405554223994080869703797491624920386576159748071496;
      _points[7] = 0.7712960967780431853930398083442015153386640842171062566103950893923844867230098706227918714691709195;
      _weight[7] = 0.0100652911435293349214185972039361728837965416629534978495957715958597173303805799754230918997120829;
      _points[8] = 0.7215284411637628205782811219801685752763893687252454146020804663752143651812554588012584507935377958;
      _weight[8] = 0.01591836500223050457908558597913063177486827168378060246011515511359787919282859563519099594101698746;
      _points[9] = 0.00191289717110327028836078524521752905378221643873610211392586422613620030638054085761591113838798103;
      _weight[9] = 0.01954892722439377291610145584289408938746223353894233403593192849234043653992666165122219128617863008;
      _points[10] = 0.6688815237617270248821108145549645861198322343286327852974929404210073467991331540955757170564355139;
      _weight[10] = 0.023620926866716590429781746080458886913912057392116175755472052610577816983937979347311540801052264;
      _points[11] = 0.6140416543163906865961035725129271962910179605530973598443859211090243690612314978954036450474195975;
      _weight[11] = 0.03318912383294029289365821071167045100713239775208250096989712764224744184932990528332463294336165887;
      _points[12] = 0.5577237395010012764647206840844501727253666372843105914449844804197466442981144131225215846683212315;
      _weight[12] = 0.0444526422478849071887171168971656648124189504190488385065799238682532085490823182384757209786707533;
      _points[13] = 0.01005154895905705829101837163776007839887286894178746427295654042900506836125523943248910412169749112;
      _weight[13] = 0.04452377548054358057693152306974293779850488015842524187316405913445811445216693334515560304563508699;
      _points[14] = 0.5006619595031362884856902687713503167221436363552477393781189311589046478109453733251474626310385349;
      _weight[14] = 0.05703475748022071828509619466256332516846561787218921379234532042280759325691321139002913907127018233;
      _points[15] = 0.02458221593567344139959951442945173604525227542008597683706536629066562897106555863890846130241857954;
      _weight[15] = 0.06725495107308428165273852693974342265312725376252435168146700914145779601982415440317967786025974281;
      _points[16] = 0.4436001949306515828559333823823612392858936114867615745808688805378474705116095676777622646630552513;
      _weight[16] = 0.07035322704434977742682228930847787787019711543667177558572243193480196890984850180718542235275479292;
      _points[17] = 0.3872823280574549937989445036865958828972832166536714882484665313850184327167229220473239233584617594;
      _weight[17] = 0.08364408140790913806503136264243828949700520235558282644016434999787678203843397466411902861456776414;
      _points[18] = 0.04531874608969985141125939892871352392582349070041744450306418403609338292543286780416369042306744593;
      _weight[18] = 0.08660682167204660370080193943728064352793416035738853172340408852080310732523056866657018900396374964;
      _points[19] = 0.332442544464647897764370591677219362088665986717434604231536379957097306038335636912411521157132378;
      _weight[19] = 0.09600780433395996459611005163022683822666687189995853795269920650589609941099345779579700299706512646;
      _points[20] = 0.07199121113320913897952303263315337990844978682594543098496219654933140959926243370975522920210941871;
      _weight[20] = 0.1017277570591432847348180174383227213260284916100920427592935367507284866022929405674356028872702434;
      _points[21] = 0.2797957613012491859655855463898480988672060062249520276103935539643102128193564469419623506479628483;
      _weight[21] = 0.106474774156680812568561370518019168161628546270578460416498320073426923055252814931939825477870784;
      _points[22] = 0.1042519922933739349627321569155201289060616104436747962912852388186208673319729357666535825336812708;
      _weight[22] = 0.1120761181427334190032010245158099690638256138925814165287686360873920886305053666402815536031124781;
      _points[23] = 0.23002830680682207126412919932716909390208658580572414780253225469621533437570891507880804871836099;
      _weight[23] = 0.1140844639890417668241464892471366407764480789831449930204960242372119155349985796101274929370035803;
      _points[24] = 0.1416805541841085939424499105077162112269282743432822292773459439118180445686557930664348991933582934;
      _weight[24] = 0.117447028575268886080283905928003969128044025940981427337594705298274644106623945515582721239819385;
      _points[25] = 0.1837889724621079951285773493909411733485119513609893231234408186596165165503607848643038915766770985;
      _weight[25] = 0.1179710549264457561782354350967497775907646397405245096492474927754560320390464932600093231430017935;
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = 0.9919016921030858633563363794429817847379787714779279595620322545994397707381328467786508349830459968;
      _weight[0] = 0.000002785016388572537705690681609177755671609902607460882831309119306006182467890894946863671115671403669;
      _points[1] = 0.9783447246593427423009234194577171124968296718365230530311186830121782128183606331424343744729291301;
      _weight[1] = 0.00003091244161938983408314671147246492772583236893784015618585479755757538573429388679225037321883934137;
      _points[2] = 0.9590024350798769967347900672867432755261033514982111722784661932934780135998830463243946849777047705;
      _weight[2] = 0.0001490333111707578435026953455921951778699719566794053596354648989169784384847030615809371744890831862;
      _points[3] = 0.9340992449559257825950427906558732935953068512720009591535099193403502312605076880588140292621747714;
      _weight[3] = 0.0004792697453785258073340451419757222154191164076444721019392392800535122603874466076414496344511966982;
      _points[4] = 0.9039353597784711070157033597360474229931818363030729923680719044761889533438408210305605660116515178;
      _weight[4] = 0.00120624834619181937137603199441914360465912857765792171269659313799452594208005653184665745154759608;
      _points[5] = 0.8688762741806575564667761401536189780901445930466251209065034762678430393181039572235882829647519408;
      _weight[5] = 0.002570049171197175931361063941668867313971915134023462330557089030766363955154108296199489949582894189;
      _points[6] = 0.8293472971383944771598355049274250058834269029021771996399619672863673163568105696112267907482074549;
      _weight[6] = 0.004846921295440348694709177690869156229797846446689132658058902702383248719112744082435662948118295653;
      _points[7] = 0.7858281353779031227352117058077111616012152440575051383618183698144842122819671305036791359257553671;
      _weight[7] = 0.008319259767931359303359612245105396666555498914945895238762583811716697454039472166862699670678373469;
      _points[8] = 0.7388469893624735910922449829548469590275526861901167534999751484805700903189045500413201466516638816;
      _weight[8] = 0.01323785353886628364655051789746491666869904914948154796436523205630295604837132271358219443071008338;
      _points[9] = 0.001780943143570460885558792886611446878630789847066000390270576459560516274569752479856156412462092889;
      _weight[9] = 0.01820603118871048582942728891063964187212465208682135554645716213359324348541984930031410535990257893;
      _points[10] = 0.6889741108323418280816571990178261232404686847403558539490499437753002791024731150404667801081009793;
      _weight[10] = 0.01978061738005189821681119732188615744078771959445292827828842468044747984641395372722160776435764143;
      _points[11] = 0.6368148674104017419630307715995676902754314764405299930956289867406713625910027046038473059912601229;
      _weight[11] = 0.02801276453548874808009747976668363223186535565759695290998544442635238085147611006105071688900964825;
      _points[12] = 0.5830023879264334250663902804376328580572440100955175317865653839064321210069269191484571926567993637;
      _weight[12] = 0.03785356234773460919311606411888319543129071813262592167579519593720136903085223560528795008414460997;
      _points[13] = 0.009359937258201115028705457829872668484510565995513908264444078497284370515863726402824600698033502681;
      _weight[13] = 0.04152785829844875717943172756938377186734953754235234311353404373544544228087795063232762728857180007;
      _points[14] = 0.528189873835532934021657722740027508548208196505456013409035767085006436526769095345534024824517463;
      _weight[14] = 0.04905440341529198363865576676516031676767482097727449018102715309052236173245485358847778720174353105;
      _points[15] = 0.4730426684520476703602592878224296830904178855899382298873897364315299239631836659193743186739257835;
      _weight[15] = 0.06119194926537683569355451543997997296618926203848359030101583951544914289940470883109383512474600588;
      _points[16] = 0.02289854263907702050395291455569141311738970919189788652592377127458263144110401632397331449331526483;
      _weight[16] = 0.06290119746144746482802734864589386618833347317601423057015638714495873048300389063863893761442406516;
      _points[17] = 0.4182301795447049734724846472391014243667560340702901180312848174318171551123809662146069605014604107;
      _weight[17] = 0.07367865526297174418825984472902459506331849312468798056148539468443217520004723844738101147944550983;
      _points[18] = 0.04223546938345160520274859443846427423042665304287693049731721062888330792747246995094108230190228905;
      _weight[18] = 0.08132436136446986193739170532758880791397877196523611071292546215873628519179693987936952305884224755;
      _points[19] = 0.3644177529904574950557756096570565098512806680305704179066355757972527488832137323378563137368606048;
      _weight[19] = 0.08579121209195122447243328295236127860714191311346550727152062805058661851930724613643640236403073954;
      _points[20] = 0.06713636929901124659578390479055933650185406663414917887488142333093823351973104095111454943659991062;
      _weight[20] = 0.09603082810201882415311963795104748870818268807470347887502846531247874858577708795396729820518612173;
      _points[21] = 0.3122585959444232262993504592262882061838804975738422821976444443102486079512087157897605571708467093;
      _weight[21] = 0.09671552705946981898751774104684219583762712809680328375846161035397016840278817983469759130134249606;
      _points[22] = 0.2623858474559273881160617913883325511276096577994481672721349608546023050783281843153256814191171124;
      _weight[22] = 0.1056050230492805119709298866476760648000510141882851923408616735140549390641398474028584341314146003;
      _points[23] = 0.0972990698736721763753164344064238004527912129365851467031032541694671325752127600065236562459329176;
      _weight[23] = 0.1065088544552712310709129163765736239560946416142489520312256996469840584797893553601506329292924869;
      _points[24] = 0.2154048926944543171651652614570632101946667733364492996249967765409568376782797064089297968838438259;
      _weight[24] = 0.1116474563280293741109965065113128931866832316104691669164509221561199637581464430175629066034208639;
      _points[25] = 0.1323574675652328254198509862867790334541690279550368666466192187710882991061076711351679865215991105;
      _weight[25] = 0.1125263755484285883365205837252928997215348671664386328271427347062622899654077798856335746521576459;
      _points[26] = 0.1718860139720701680722426766544501251353813244874586832784733002806207478525176577679137330683948481;
      _weight[26] = 0.1141343235447071384761478578769258902127350763147060770569388232507400711703976247938788173159387682;
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = 0.9924402145386934818494062074608256710512573670377708826247066201588500246796209226609635064997675722;
      _weight[0] = 0.000002265958598962605196822743329763905246915735782078382024974317229330583473761254873410776872767826297;
      _points[1] = 0.9797785960640749944438190057145039152741074495249043615408383040614782568644584229549468171687733794;
      _weight[1] = 0.00002518191216312457714080057893628203062066238548219866715788280885486052172769692157029551682300980055;
      _points[2] = 0.9617001463459457899861099885807198305217759101371616261805924955343739972380075801124042375869170113;
      _weight[2] = 0.0001216212208108765183086984702980407460962842267066259167107608532532670446458238411718198672773186945;
      _points[3] = 0.9384000294379855101586491825366150982471974093849676442221321111107915020236599462447922597108121458;
      _weight[3] = 0.0003920317051831638475926050565561955006834349747351228816020734233503026528227612365401820950255750158;
      _points[4] = 0.9101403003668531082536780547017155187065153962208111283714408048069939649812595801927679940070241872;
      _weight[4] = 0.0009895645441188801027588830624824366661410419145577967624579589789470698427514257565112370532368473272;
      _points[5] = 0.8772405436497879573891723774128885767103809571602310600748670880625265196548463651442992083091059555;
      _weight[5] = 0.002115799069802587276112448389274307711426310369019676527371289223126989553627023040825265918413245453;
      _points[6] = 0.8400732837976637417846403075634608381826446882830863254766087793874579013383417858472750832694708386;
      _weight[6] = 0.00400676996382688876369694147974047973154866283886113397519166712993033774666693888227342383322420845;
      _points[7] = 0.7990595276685624868995636153621286979861878231866964890727280422713114601123812756416012428130639633;
      _weight[7] = 0.006910213443566888748466176890723625292539468755284525612640801075874152045527474588594349300760027866;
      _points[8] = 0.7546639187593059817872803597557685898853275116792760713753923349366380454793941649397924902062412319;
      _weight[8] = 0.01105609190631242552105479324746823601234418177691168238419979938124926144067391591450784016492233245;
      _points[9] = 0.7073894438877855706285149361350268987939100593278504681962772015788814614262279003604123878408133833;
      _weight[9] = 0.01662340411686909034142413466450566565032418406426186662411255986983551839951256909951884474445425856;
      _points[10] = 0.001662188334010344257891461771211848609193102668366344886339851471823721411659306650434237708070485101;
      _weight[10] = 0.01699675331355490717411502137389388500094524603859825757063307660350119689582330207269535543572269786;
      _points[11] = 0.6577717217542247768084005053389194499315878203674783143278934979688418886464254544545346213089894437;
      _weight[11] = 0.02370693220667251758884754554263331205128739505850822623279313400923071925972365938987128520658945004;
      _points[12] = 0.6063729282730147073480576391241726828720982008190425665943509503596611618340212969981896009477717553;
      _weight[12] = 0.03228783996502644895650898643668602554416833029918697762571085207553801460068086760948486028196731261;
      _points[13] = 0.00873728447239214139065712242090646257020090445870447567282855490448705888193735202767834234353241308;
      _weight[13] = 0.0388221611401857501373760319181405664443831529949018732380163213415938798961715598697675365133475528;
      _points[14] = 0.5537754238684313594769240249501645635328248608561576380556038385473320553947237200652050810344918645;
      _weight[14] = 0.04221188066485391017179843621910132663247325582481799896194480286103572326145048899412823414104578068;
      _points[15] = 0.500575153441983623093869111019478966255819651560523227417590738918084787952706570511471287773556073;
      _weight[15] = 0.05317840198085355889436749877935944937229816786481312186261562562730237943218926093884454876384009258;
      _points[16] = 0.02138176483568373963034271336149516841266556866258386679039806082475071487814678080051058192488994791;
      _weight[16] = 0.05894766595670255670963440873302383759119498225513535332185369018894998992852923391583154766651460418;
      _points[17] = 0.4473748931198531751312384976638757267785856330538905813203215779969809276248509403699505273214443105;
      _weight[17] = 0.06474239890218384617641579074397429560281200820034847743486255276201782999215045306318422919140676195;
      _points[18] = 0.3947774199723313116769052107500062552907725427703361632104188629638226399349568702184562114618754642;
      _weight[18] = 0.0763306503770435867799217376007081375452687618911842652302001273146809417858403010269360961540654852;
      _points[19] = 0.03945520864053971121154986277226662685144080719364934557672928701141422590945414778597456317172456995;
      _weight[19] = 0.0764867860250257028448602879104010451834884717881588252543887775929982012360821861240101576752354614;
      _points[20] = 0.3433786819261913150681460413651973878949845823554863178403679470149846273838432659226376928927518381;
      _weight[20] = 0.08727159968574142456653607461431136580558843981507980115301946075240580150496406025982314095123393874;
      _points[21] = 0.06275318712545885999983743626481590179256400882623205243754304532648865470273322717790632337377314921;
      _weight[21] = 0.09074930386242807574850384737192231428927990682057845126440329212535996959549697864971331918463330868;
      _points[22] = 0.2937610451613514326972750749668948134956539051387656916985961515253610703405985442498156612536971559;
      _weight[22] = 0.09683723892284496243133400305982014503220595603741460800960591274877472218951050937958199531634003946;
      _points[23] = 0.09101180937213291493037786336117976907264810765721540819421996451301742291635988315532695530375611578;
      _weight[23] = 0.1012555974889907126108460496940755561934638347853673107289657786337559632509483599958359377654219545;
      _points[24] = 0.2464866954363530558083411840821592805659340568933689671152241449226482215610440148989074112781467142;
      _weight[24] = 0.1042939762323390317306252800023900820145384876648703530515689827183667386399613716670604816775598012;
      _points[25] = 0.1239109225098248943986786571525365727357700121269974363446057563225513757008341619263478384404697343;
      _weight[25] = 0.1077593224554183504441506568716594810393974684605908180762875165119213414701629886814347926818068901;
      _points[26] = 0.2020912680468832554423969706448920337400445843902748221160223851312616827201318751974338594370225009;
      _weight[26] = 0.1089584330514553833792479007201945848483678110902207242804925059301547571776537296722336644764227275;
      _points[27] = 0.161077778503025586034483484317896992168941561016791412920534016160288076683236712455481216991357141;
      _weight[27] = 0.1102534472607597186864914711577228898952005094019551823025011564740940733845646315084537049532027231;
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = 0.9929267893183628062269525350662871775653492285199651525986086819393629175725051227057650509336396086;
      _weight[0] = 0.000001856283772081021646463917006645502930051466535420769785785415393719988368277496916640181442415746151;
      _points[1] = 0.9810749076596256309006437136691611689533352449026726879855908015035858117277035374554302084570421548;
      _weight[1] = 0.00002065193379483673723520305410719094953030456381599065092914301994814430006275832864617928309149435563;
      _points[2] = 0.9641411217247745946828870542493190904639324758002400985928337168007851931895173178552116298526335159;
      _weight[2] = 0.00009990263394095784408772527008183937133715876054979511341138744323762818463231844388684177314495142668;
      _points[3] = 0.9422958895903871330495337162486475572840128154973285809341967704118304237104033071590241332038178755;
      _weight[3] = 0.0003227041908195134456269653088472861986621444725248385753566297569081862963005760178204697655072584826;
      _points[4] = 0.9157689585742375160527209731782209778138377544703193428562270193431316521163635958472103988871596499;
      _weight[4] = 0.0008167123025929537791590779222624889046680614565866252043480296283513012023263276872665424708570029282;
      _points[5] = 0.8848409513746070720478295357950882608136439751437339020150931391920340490511768348960488253412100603;
      _weight[5] = 0.001751756104040543812056707746636424489524091405182527252251987207967076087908850752406343551247101325;
      _points[6] = 0.8498394858283586592068606159884429949323530710404946731082134176863686453602964965002298383195124693;
      _weight[6] = 0.003329732099534716525904959471022450189067525736458400646569973558736059350650571180620965956491897284;
      _points[7] = 0.8111354807272444642075213249964705278931214853178016839227908886334439887655616436591190604415518726;
      _weight[7] = 0.005767322345572894815450450032797290470663786874293720580846143468974332971619800222681111399152007128;
      _points[8] = 0.7691391534023484768538220758922565584262388759203507506806944987604814945430447384460512918718215989;
      _weight[8] = 0.009272946255348385389541458548765573070689017484996409398510543999367015481576466379271350142341662023;
      _points[9] = 0.7242956444888707043560871701745064455538860059199548248154436973480104217103385414072838784155034141;
      _weight[9] = 0.01402009861333367145022482741179595153263656328537495601342898943949469294535231397346053110908384423;
      _points[10] = 0.001554929031256665420006752942495427838027482475136930592211048929383071266978688100380198645182484977;
      _weight[10] = 0.01590395547416049373084283970446254939586728862730454297894007025395012962095073015384060063814125139;
      _points[11] = 0.6770802877492443573266568704467015351806311769675395683120767898431579951848013577283510561777889766;
      _weight[11] = 0.02011976844683497331844387739702727260430369510653869789575590786230420302940347608481479643127976595;
      _points[12] = 0.627993565916526262182013707529617129394893152972341580368269585709554733044579996298702311470791131;
      _weight[12] = 0.02759491436298458106580574784196132821947800084432000401014943541800534280281110554230420725253142823;
      _points[13] = 0.5775558026309174452553151152733625043245901657653645490736680818890881281137921627962913404073228691;
      _weight[13] = 0.03635995684886709788958406007756343059353121747834284301899201980737194866787438745763436873700570147;
      _points[14] = 0.008174723674418611559103865544392948102157036888087052346790286307717131377449463638956498141460460573;
      _weight[14] = 0.03637065893665729571075344593916540199657241009646385824767892047382103100320528018288122982250320447;
      _points[15] = 0.5263016453375968201653794928636041556860229130020205964062744256271705159139407454117566470052847889;
      _weight[15] = 0.04620793050943086619045368766579074375745787430897608290923105422272112793759027659747296191028447982;
      _points[16] = 0.02001057277537863729118447337248115231454020584682554184760410583574379386658825873304229289136911038;
      _weight[16] = 0.05534795630399538850185456211297123893344168142281776267574745603114279671978481699568799512634590668;
      _points[17] = 0.4747743970009873561917723160531700205066921026924445193997049795210527057905182697247116916931894192;
      _weight[17] = 0.05680734250845563585288858316504839656434131896796498476261765390734591853152656637737926312889479053;
      _points[18] = 0.4235202564181097995474113146850489926682673472663289206460620937489498826422878291086158784870130803;
      _weight[18] = 0.06770995846565736534187178620911510510981331439007344136937490702077560334537629961218632220124974517;
      _points[19] = 0.0369396752916812645959209072886222502266940175506431296353140616816413196565410066864982546882814814;
      _weight[19] = 0.07204878416716868669494228779171087877055190291879777468441869777323207283284792884162808840671618476;
      _points[20] = 0.3730825280293374465690792859201248695856590531186829500141964698180241770761618137437466075148481282;
      _weight[20] = 0.07836975770978971115427402907838920161802800682518189208674079546857625920569703907869991396907702626;
      _points[21] = 0.05878290626605055885840865218087174046495481944251207998810378852091522787940776630512797824354282017;
      _weight[21] = 0.08585111618606221894547223897051276062455717563898810682264732561837504271642097505325204467579434545;
      _points[22] = 0.3239958625177051466248603397041584055661175398120534880219141687715302778163413540837796763370016129;
      _weight[22] = 0.08817225630680597612003660163949371818078447184949948235473102539086671161349867433599036467547766318;
      _points[23] = 0.08530880093329033563236471055857523621058808223719875374718841141972960523222133992450790818395778101;
      _weight[23] = 0.09630795187080586094841976728359810551551172932908124410591486740160430723013263344522700978629878583;
      _points[24] = 0.2767805891942973708577879729031042713879054366854930668603078587622459594790114634625651543742909842;
      _weight[24] = 0.09647238670452894868290795505134096581869886645007816822694179149988004663996108299166340298176479467;
      _points[25] = 0.2319372002063364238357113561581231468239578677677663627198771197540715838680988610437419882956982289;
      _weight[25] = 0.1026382437620365051961261302742550581710573153809810112602447887157691824281457449099765356526344903;
      _points[26] = 0.1162362048829853425076721375397609970107436875069462593303916880434153281948281248095660108756043849;
      _weight[26] = 0.1031676988619209181710558830873856413004363444827527678541306109133352094102382641980490562172708412;
      _points[27] = 0.1899410449901282865692379014213471630254082529921559753456718118947261873986526053764810399620158524;
      _weight[27] = 0.1060973443529894398202373165023237945259903765282338008207222574643863851930328256989138033717840287;
      _points[28] = 0.1512372911316014780919207790227039606491053931442636445013472589695144451175544237584698175481308518;
      _weight[28] = 0.1063816687914308151764286948578946009532016371806181830429151351514918575960369656164444521272090252;
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = 0.9933678849972890218242967429754756290348422812012610131690790938192644595723658942993255322380362377;
      _weight[0] = 0.000001530435692303559679202880600194069095291373243359882366029366110361351387216726316141966166113640561;
      _points[1] = 0.9822506759732043911736678171948047795906753507549646731542099473217074609302325111913020773007465754;
      _weight[1] = 0.00001704378210976846570170738949485625046237981076825018201228716265008270161857594461594414931549012417;
      _points[2] = 0.966356811610316331681829740124114472013698341152903565974034839219633588997916371133226198626933423;
      _weight[2] = 0.00008256807322596642712675172300945914195274209200047916147521082294370472442789555182791610679371970876;
      _points[3] = 0.9458357764492203337808419002032066885955503076575948450871012659368499041349175484945986129340774309;
      _weight[3] = 0.0002672199620663056472135919658807958654052121724338065121842860076057742788764139847141623009890424742;
      _points[4] = 0.9208898151139505953144638557329905235774970627249343559514095081325116537677830281076745417185029103;
      _weight[4] = 0.000677900876045822301748513097607136324210204873984589460746651754413842077422919562829610184363090602;
      _points[5] = 0.891766318682024711351680965262570788260699668723203291111539656543622803240979767532198330039144181;
      _weight[5] = 0.001458186687285437575395832778065189046874964252128656421832651017529503747672066055109671092349859249;
      _points[6] = 0.8587545173866958177170051992400022157663057683841349552780806326443491728626503313132174680442865727;
      _weight[6] = 0.002781045433058290735823690629828006775647419013227642282327332200732301717026140608010860330831076808;
      _points[7] = 0.8221823987382739350146679257725087410887946678055925816102530058347225710144385002987812579603934522;
      _weight[7] = 0.004835687651116839589207388506661792798688732351920846841568469474501450058791552883867826144653376215;
      _points[8] = 0.7824133817283033117351654063389710102986058216354587982007414417461506029482383411221290125361309735;
      _weight[8] = 0.00780951217924887175492555552277335297710152074877213295106913265321637430098410393345892760990754618;
      _points[9] = 0.7398426798885768781476865343971963892441993313179320887011131454876353948716056468750647185101546415;
      _weight[9] = 0.01186669231590524206744646319730034674869664293542161685991368345216694946396047626719698432221560565;
      _points[10] = 0.00145772783390650359258939349065175917847200065310815600213746054046489330060751964957340354200936242;
      _weight[10] = 0.01491315901155340446212604717451004862856152600028923881167748393402243077917276774270736813868227456;
      _points[11] = 0.6948933626480090846660737470948052491622820351678518066893206318036909102531481156845209039989461428;
      _weight[11] = 0.01712539544532892132744625893725802414621796017291600334410496954630813410240948250791722805919453726;
      _points[12] = 0.6480121455331503208705669145595995298479983344533984988806949082338790572395468688493909284724971216;
      _weight[12] = 0.02363589773545442376826921873044047832436878049349748821622300008932827072699686486257968668165021934;
      _points[13] = 0.5996649478704976551018373593654268159180810688501359806278139203431894217253568566355352104940005754;
      _weight[13] = 0.03136191451975259960451311523450739540697146877711414235255154582511143225744543683656798934447392143;
      _points[14] = 0.007664767864806790652510700943612758896490081250185334891650651104295876629089337085527195459046516929;
      _weight[14] = 0.03414270443637351996552524689520019651518918125519284231276373992492543701158246339820206496302363977;
      _points[15] = 0.5503322608308270557491787984340267743359031321325234333208060314419409333934168725488976010462177834;
      _weight[15] = 0.04016730562047342836983353438926568287679859907672033401806590163348537364732569259646213424815701809;
      _points[16] = 0.5005043712628964789717639236953963031984790603234627725767742098965776650636318606390262908257531406;
      _weight[16] = 0.04980994243944509670193186882596801360805780285331470412300413488400333743558037202503741391583451747;
      _points[17] = 0.0187669462746132244982993301440387916639043908855580554548242427097167553740409721090435065543842118;
      _weight[17] = 0.05206201194506336946652736896631086980047779181323752545621446604559586912360486216640464809850709849;
      _points[18] = 0.4506764885015598873510899584766044215966881241176557888841618510954362349594222860652999748365539745;
      _weight[18] = 0.05994396892391193201878777221886819034342923382714188936785401233706685684647954234713000168528380992;
      _points[19] = 0.0346564195659897349491044844339792828709394875646473158245898065449187036414264888486758751330533654;
      _weight[19] = 0.06797009893843161497359823823660113226698137894136207676183867733482609286998692739265881943481490805;
      _points[20] = 0.4013438224374185454639967766405275317142917022652449466333117794386845094513689829895546561946178324;
      _weight[20] = 0.07013099742401690013591360102740147731104180921542862503107396753093730582466635836943847279118991919;
      _points[21] = 0.3529966616853502786154550912575915364162723119239058502674939729539710162974658936315002971501451098;
      _weight[21] = 0.07986001209119680090675229090743842319473780511267993616803209051048773098007336509737306748332389762;
      _points[22] = 0.05517557808804576973579901521230398806718249322486323341936662310406570235218106947237236467595813226;
      _weight[22] = 0.08130576744926203003727351913523010351524516224444640024452683616344850950559158640251626220781181102;
      _points[23] = 0.3061155007205121813665886906735831563842230803361353335661166203013891520931517709134796871698281319;
      _weight[23] = 0.08857497394178217650471618391876129842077745883814547442007841660655316881345758283854245886546129746;
      _points[24] = 0.080120567112325535828402317065571442809308606707266764109231947703747384584007510546030547316032919;
      _weight[24] = 0.09165404412254467064066511550040554298695455034951684961821682398973282747671045386111241554317353069;
      _points[25] = 0.2611662643784974751033364418861637841052167095569197616325843294380357783689767519724808893027702637;
      _weight[25] = 0.0957084022537584356706622834178274651556869909900460229728119906274110824605147609337241300199247589;
      _points[26] = 0.1092434970626521088746731873448846222774206414347470411530922780957733620062425548835010678261700806;
      _weight[26] = 0.09876432908795536536032697004673551868704851460757200597881816491701736581480140253736911574432935214;
      _points[27] = 0.2185956771518845796303573075738189314253271962040366483829882206456924780212396799680806333911303056;
      _weight[27] = 0.1007186117616301279878554305959197341608245889317283916519828674052671542386577064173516389649996562;
      _points[28] = 0.1422549415999572144877609341053898829708731999301570680786197421573754663025852228845161221643511937;
      _weight[28] = 0.1025585393150491257467352768657020962566165514453482039316467571702515714029648271882670353598411089;
      _points[29] = 0.1788268232673087628783417984246983287220358061763450736249227518897393446664815732877331590542564701;
      _weight[29] = 0.1031278694745945415596052946177605117292110687637337979963517529456830375931435175722210364638955055;
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = 0.9937689943617638927613642550978404132193052847562085323183044817501866272149029814389654785747097187;
      _weight[0] = 0.000001269380626764678675373195326975758127251201208308023241385711948424755100169194183552495211808790648;
      _points[1] = 0.9833203701304175412485368480405225262637155639849370527489909821657295035574559858424684689497338574;
      _weight[1] = 0.00001414938875337667805842756312550972005132023758238594466807507236888151577830837913556555707754238027;
      _points[2] = 0.9683740118091604909480627251752021631877538352896943636065161160288890490739816800738966445710808703;
      _weight[2] = 0.00006863667359946888101889453121545292318816146796189038823923159828041558018051222520524730639664121677;
      _points[3] = 0.9490615100934992658665533661080479770940064242550734057590726835551016985542145903458461174891410266;
      _weight[3] = 0.0002225184113616753332835954161816580608307938220209914664726703106957494701509062705922833939390795155;
      _points[4] = 0.9255615822969551781356416726446810501492182917520502742877697614194101962468919439115832052932058982;
      _weight[4] = 0.0005657189666091238390709933068514304280659458878866494461459971250893209363885838891569990679795923031;
      _points[5] = 0.8980931407181669215572452752900580046388620566439707644527159091729569427638691092610084112862033889;
      _weight[5] = 0.001220041621260954623648068103750166494687433751337417055023692920392477150831347375208885934591540607;
      _points[6] = 0.8669124518396082568693596616154962977199040720951216992805820343587833819211852462891270723734944261;
      _weight[6] = 0.002333953705311331245464177602173047072288137060715168141773548841446522030992039657050969440578857492;
      _points[7] = 0.8323105489456515383744404260031629487070666431913964811955248376360356215462432754715923979789363373;
      _weight[7] = 0.004072567301324925286978191910109165210998809923518336725405684136878371982652710248244288816607680173;
      _points[8] = 0.7946104527758169326169679366928319864361859757363904011714581588637172599413472813223525772026136789;
      _weight[8] = 0.006603470707394316985994280362337310811861259335771870656920474608040126953653365813322975171532715797;
      _points[9] = 0.7541641319977899149388944264594135600637795973965264582163907849633878659064268645380961165020694247;
      _weight[9] = 0.01007952176991829850305258664289729474571005385425765929827171877545918882642476290287480815922844768;
      _points[10] = 0.001369365209100103662902538016497745627238368452352123490012738406772631849672261901196138706142526928;
      _weight[10] = 0.01401206490544436609023237121587349969746045006567761855081695008238920197145638880861484379937998666;
      _points[11] = 0.7113492068095685558133006667709819451575054362840455447176740142822369749162251926869838973346927698;
      _weight[11] = 0.01462008082783841976253308183893206231436847698410446515106255101009664107357060645472473645139699297;
      _points[12] = 0.6665654183773303861601326760614604743638563595328351949371522965073714357445225242299623003309299524;
      _weight[12] = 0.0202924034506888834074595019625389661145966542394859226818867916101663400848195357909655861316795088;
      _points[13] = 0.6202308940878964763528673529670363355339785112518597470011666286148975401503787651670787009253429759;
      _weight[13] = 0.02709500690386953751069178406838636815384967226318121133814435788253336859351359886090392628083630055;
      _points[14] = 0.007201060193187964367610144103097238265492936079471944871780273309543373182405493269711341122292980795;
      _weight[14] = 0.03211210056592242810234944055571401839762527500713589024854398810028566527822993288311027606844957208;
      _points[15] = 0.5727782422577024113870603024175540683472059621151315030913358644137301739485372481202450035572725181;
      _weight[15] = 0.03494475743428021057568935242276602073648520792237513277063007881830750670821227031289900085144260704;
      _points[16] = 0.5246505122103465455728183462099190147096086687630914369775031785647986088465765153290482473234440025;
      _weight[16] = 0.04366919988107116389230886514702208452192610172539603303155281880114132121310772290910736617814420272;
      _points[17] = 0.01763556469398653294408221167167162733992627300109424080406116588738610893975770523667372303912533056;
      _weight[17] = 0.04905514352007358740541302270051117036844203516552518776904458507336171955803915816081656601013491224;
      _points[18] = 0.4762970571775839012599109438642786787910227011918298028869481968383657046401344160723604121339610397;
      _weight[18] = 0.05300528235407393210593432792415778543059070542062211133149380520643792420434901154289638364872976669;
      _points[19] = 0.4281693385154156194417410742899825270370966980210852141448274402465912219366930868936595777620858797;
      _weight[19] = 0.06260514491381266112476446763960717503457148868267332156770556143624906440752520753898794314174248398;
      _points[20] = 0.03257779777966460886729942692136668100246248118137555022234282287177062321775785540900615891817245201;
      _weight[20] = 0.06421499003447563667095761947959886068101567810299905758943015986959607413434210190727781793751764501;
      _points[21] = 0.3807167103369646932919817405792130746606355782010403499486364214947528760107143133850084127060875174;
      _weight[21] = 0.07204908076371079309214829918846290043710821174646453642360675733877644714506224903242378673973541619;
      _points[22] = 0.05188853615392920947892793281212631775109602038992669350693691676633220365356651819015841212998281432;
      _weight[22] = 0.07708465591944440214978664678877579601642420763348919100177459902890693290204556050005832293398972658;
      _points[23] = 0.3343822238776351252419685447725649719691406591568741892752991492068380593197644708700909207098419998;
      _weight[23] = 0.08086518702868964921973768964419167020096598662788053379862951223461825278781407685710065195767206447;
      _points[24] = 0.07538754998514038394719127514008188990831275431228255760504153387312193075577455329791578743446834647;
      _weight[24] = 0.08727993087125598404851885924736203445983237573749491484102820440464420680359587863705024778690839844;
      _points[25] = 0.2895984907391475920138782464308026880200802349630140545217731202754357179091084031758311229993710084;
      _weight[25] = 0.08855464875380005756652072587576624284557300886023695065934716903300558691518263136396252574033032507;
      _points[26] = 0.10285545867509340672666309459934025824749333553664562240979626482386876152189922577567755172827218;
      _weight[26] = 0.09455543857311113942533268852024714918001646007576128813201633172025531623575828932114719978313621885;
      _points[27] = 0.2467836436155710933199228384538418511090271873523499710413024876413592298225490102948311490242624505;
      _weight[27] = 0.09462109265174807424873122469747347887669228616198273398437836689671301713817820752750902650005237804;
      _points[28] = 0.2063374321933079647369611133634897836240770185127581624195509150737302861230656791747631614142527725;
      _weight[28] = 0.09860204997970906763399803849822200678637561736800941509032055186211162575531237866562542497106307103;
      _points[29] = 0.1340358114983876564339860740140341196816667539203883664849981452786512463510185666317257255430747126;
      _weight[29] = 0.09881291012170006693456267092177765186618637716012470654782718891302456217838158452385974238915451355;
      _points[30] = 0.1686374906442098356617268634134017813732783166791782966045346757082471444333592363931357649357351428;
      _weight[30] = 0.1001003159524530363104180663619783799874178898404524336779305249101130790426842115444418169199692081;
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

  // for non-fundamental types: assign numbers as strings
  template<typename ct>
  void Jacobi2QuadratureInitHelper<ct,false>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = ct("0.25");
      _weight[0] = ct("1.333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333333");
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = ct("0.5441518440112252887999262362955145689146370092883477884571669901861729625759492147562832072252866864");
      _weight[0] = ct("0.4031435283193017223334255379639401221900370717228985977618745956006171301133968148879793243017249754");
      _points[1] = ct("0.1225148226554413778667404303711520977520296573783188782094996764804937040907174519103834594413799803");
      _weight[1] = ct("0.930189805014031610999907795369393211143296261610434735571458737732716203219936518445354009031608358");
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = ct("0.7050022098884983831223984775840482527404615621673957968187330274666375934719617430536332178860666683");
      _weight[0] = ct("0.1198028120343227920459059630233091355547326268137250385594040589278280490932505000994631471190946468");
      _points[1] = ct("0.3470037660383518847217635434039484551401490745262501021878985827903559852608331357830049271464466709");
      _weight[1] = ct("0.5849850770394640880140480814569575834996833285430405912588393379710804430684155659655248860334828359");
      _points[2] = ct("0.07299402407314973215583797901200329211938936330635410099336838974300642126720512116336185496748666083");
      _weight[2] = ct("0.6285454442595464532733792888530666142789173779765677035150899364344248411716672672683453001807558508");
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = ct("0.795851417896772863303377960793240153655111814369133947337218428490843889786355454581170273360860138");
      _weight[0] = ct("0.04140896299967226113759062618655673912665921802650887351261598768091744489940921375092075799421354484");
      _points[1] = ct("0.5170472951043675023405733693830732661441577674815143184126459202288394285156186604132268185358169055");
      _weight[1] = ct("0.2745355486916923012695053801672421777585462337521019227783801195324800153896617288464511839350699153");
      _points[2] = ct("0.04850054944699732929706725709898599476427280622804138308697676906809043140700237130756061833546337107");
      _weight[2] = ct("0.4435536624451119347329252698757826095062322419475350982016036681051358053754859408526879761621947264");
      _points[3] = ct("0.2386007375518623050589814127247005854364576119213103511631588822122262502910235136980422897678595854");
      _weight[3] = ct("0.5738351591968568361933120571037518069418956396071874388407335580148000676687764498832734152418551447");
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = ct("0.8510542129470164181162241874100130578037999355252331298775577412327508226081337242789670271254366003");
      _weight[0] = ct("0.0164553008123960318344649664771932761384129705299198594819023493276538663334439422044756555173918885");
      _points[1] = ct("0.6343334726308867723471638889206191121277336440958369160307851769971809925102122993798727580295999099");
      _weight[1] = ct("0.1282224028918476770189957222265331112459675505313588758170175986042217305503148083830364356533270504");
      _points[2] = ct("0.03457893991821509152445742863152659272391875376414497155987987848502413583832078858238836643039194193");
      _weight[2] = ct("0.3270591371430836716195229316894094001951854345378653863487891391459565840633676758520507731631799336");
      _points[3] = ct("0.3898863870655193282408954103849949929685699479384607713625473160659384788871254703280644555908817828");
      _weight[3] = ct("0.3568006448863600007450179722815356404122106902138793907440693610940259530233602522779046002721091408");
      _points[4] = ct("0.1734803207716957231045924179861795777093110520096575445025632205524389034895410507640407261570230985");
      _weight[4] = ct("0.504795847599645952115331740658661905341556687520309820941554885161475199362846654615865868727325323");
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = ct("0.8868056161775618663012660060104907510040863218112851455728573015303583622861762166128254348593013689");
      _weight[0] = ct("0.007324303227477190931113822360224935405864216618905867216202122367913348061134720321894342299951728867");
      _points[1] = ct("0.7156811273117139187676626245936073635482655112817582867648513925864912489801365831589316400094114546");
      _weight[1] = ct("0.06288118873978020531140504852007971390788413793492071598436679202370012665529257375196229311689702309");
      _points[2] = ct("0.5090364131647520840110399051677197756066865099413616255162800068449833494040551477253328196372325307");
      _weight[2] = ct("0.2051582845184648408805173003076769826286071695771531963106651422253387765576255251446619284393054827");
      _points[3] = ct("0.02590455509366719275464360699723454895681812392531925015861057429610266045438042891711695398904589615");
      _weight[3] = ct("0.2501548109063237515141062258733267440660779616350562328954095848025901035201055026000940757458649068");
      _points[4] = ct("0.3024369180228912327499055779185451938801342419623170862494499684632895155693734121375470591583017143");
      _weight[4] = ct("0.3783087469941648142731682068802065098680549714701846873490169027817905712014531819167360652747890985");
      _points[5] = ct("0.1315639416579851339869108507409737955754378625065300343093793277073462918773067828768175209181356068");
      _weight[5] = ct("0.429505998947122530423022729391818447456844876097112633577672789132000407337721829597984628456525117");
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = ct("0.9111831665630027636393173672090451969487181513569967751421124434536487739752746787009550475957343985");
      _weight[0] = ct("0.003570752134756827216036107377022441360104908358539661885927757477239078187959563376287977244479836972");
      _points[1] = ct("0.773517246591437501111998996426027488026169366066348465200565244218230399988368494001938326057139926");
      _weight[1] = ct("0.03265170252921877802892723627488505435251712336400851214223824298292417299877194662090599291711606812");
      _points[2] = ct("0.6000215132789929301939687728899372881025806599131930023285085834549592653990404218944489240088978781");
      _weight[2] = ct("0.1176888451581144593629814079400447094617082760975046287638279082701242348479743647408809166847127138");
      _points[3] = ct("0.02013277377340050723050168711747234907764398490423277046410233635340207429864852275760640623962261817");
      _weight[3] = ct("0.1971060071057524832937165163396190757998916431027808644906762554468035992816828007706400085856980319");
      _points[4] = ct("0.4140021445970597464182872488505667767590220835312978380704205456186698145026653746810963941381988064");
      _weight[4] = ct("0.2525855148355651908381357619247951567605016016259007795136116178216199124634212453015846804292228417");
      _points[5] = ct("0.1030890291480490147522267860059511003289175929398917699266215140490606015002180084249458354155438582");
      _weight[5] = ct("0.3627952984507445781478699198894979377596337461185747060555815360747820057455407114922673477814266561");
      _points[6] = ct("0.2405541260480575366536991415009998007569481612880393788676693328520290703357844995390090665448625147");
      _weight[6] = ct("0.3669352131191810164456663835874689578389760346660241804814700152598403298079827010307664096906772971");
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = ct("0.9285089649599068972010186178492256918523361943035918234239993038443100956977829527716887186137627323");
      _weight[0] = ct("0.001874071136138789023159770129253368619333666877009514163776075880783138331582326154790170679105180906");
      _points[1] = ct("0.8157717035832837607547517869758669198734561249520251057926437981546786829099776657599632715409829299");
      _weight[1] = ct("0.01789808685205763198302608401313458028471472087364949967388597034873997270243168913625909195923823938");
      _points[2] = ct("0.6695522718243614518301145105543719346057236571343379507230403873080542508578187492621559364188985917");
      _weight[2] = ct("0.06898745512093993121697462309944726926414242801556028350923661517840760011679153538454549507030134072");
      _points[3] = ct("0.01609775955192103353201355009661792907673719717398634906421435485594927605852943376972866088945344409");
      _weight[3] = ct("0.159115831226762239320425823705592796269808307236583292588717392773719674740770700496721345833462587");
      _points[4] = ct("0.5055970781844891719400618650060764872884489602668891730627538404857596368160581228502258304169030991");
      _weight[4] = ct("0.1632577055541760927458463846085917092703302398116046797151312588917290824986672513574976000713409909");
      _points[5] = ct("0.3416519914772022202729622621623959437357864175820185645023555961530872229142955610693253060030617732");
      _weight[5] = ct("0.2737887336866130889881088024434078279685567928059228224395487281994529345472410304920512689098080725");
      _points[6] = ct("0.08290061748565110270036635338038834250469178513978329482769857057078194045432465770034793117405856385");
      _weight[6] = ct("0.3072723730688904992180269402731618118770031436482066776403339468731082588061946079180966199553820393");
      _points[7] = ct("0.1954751684887399173242666095306123066183752190029232941588497041829344498467684123721199004984344214");
      _weight[7] = ct("0.3411390766877550608377649050607439697794440340647965636027033451873926715896541923933717408546950035");
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = ct("0.9412458642132742114143421271349757145307710728810603227584263072556399818130810425576470087365192321");
      _weight[0] = ct("0.001045049386077851771963674594932099904728987905881137936245423011782888065286438712365833246324346971");
      _points[1] = ct("0.8474368420132373201731804250196182721512229028198623679712683516725259240759225460110084747448902275");
      _weight[1] = ct("0.01029759458243489240932686362241481242050381516644947786284291452404221754858892924302398732118007726");
      _points[2] = ct("0.7232685717403354318179601582002055305769054380507989053229094988979833043442432382442417433411755164");
      _weight[2] = ct("0.04162446631740894820970534894375261359629703551183251098420143946239913509520566870940318195593343379");
      _points[3] = ct("0.5796940563511631262657724133119889515943464601677762686678217724998474141044996039946483039194661255");
      _weight[3] = ct("0.1053731236101993429518987840106901998442418069136281392168534644913155857561231942134211646777062514");
      _points[4] = ct("0.01316588559711449054519053781797215136082076089770230465987155514510039146923769474012679115743814305");
      _weight[4] = ct("0.1310405804441588858472781603370944604810978794735901694842259117976972694085138327178975817670983234");
      _points[5] = ct("0.4294536453878127925092480022865873331648138310301004847453416352653628845263290243369473840494158542");
      _weight[5] = ct("0.1941625114580260318381122496994582838080221982357833412996720724777967285153688457928679921481932565");
      _points[6] = ct("0.0680845295937675874765058569868224421713297601092686688022203256854416426151243571888926792972427821");
      _weight[6] = ct("0.261958148133586527127756428815648823072391939069180744506022629993832327961890621152764564116753725");
      _points[7] = ct("0.2858910883392203977279895669126411861610178692391895516747553642738332353741698871551056243758169287");
      _weight[7] = ct("0.2771375827592188368629111413955671111448010879552790959675288132265547247642744146956024875388283137");
      _points[8] = ct("0.1617595167640746420698109123291884182887719048042411253973851893042652216773926057713819903780351905");
      _weight[8] = ct("0.3106942766422220163143806819137749290612485831017087160757406643479124562180813880959865405613147766");
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = ct("0.950874292640523166446349484610325177054138698008876247521880845732145601052447073904101954699264569");
      _weight[0] = ct("0.0006129601467886433685130280913870182321267020111436205319486707118462805612131738008391387787268322555");
      _points[1] = ct("0.8717100745744084876118613420054236108762703517899922187764993623709234200889090646472972713573702869");
      _weight[1] = ct("0.006182092778946314514341307258874506510233203740474247976315870788020555404045823349159258546354102964");
      _points[2] = ct("0.7653476795481078962095331272446001935281254701059371299400639154174230207720369856446774138268604502");
      _weight[2] = ct("0.02587955627423411691892242624371044143548514233481194134088846643064833839260516482542276239452851382");
      _points[3] = ct("0.6396094886547097093285365061669561436997898167778574491235731369280604031123928829202652930591428398");
      _weight[3] = ct("0.06879030018621203231655000929591000454971704580551112869775545888215954689422647507462355006505397947");
      _points[4] = ct("0.0109684524561741342502810329904322267331336681681923877355192963785056979625337637538110478171937813");
      _weight[4] = ct("0.1097363548403899878418065943379411944061396284924080166565554103294093888964177063474961793610317609");
      _points[5] = ct("0.5038071264148739070055306420572277096670551499038191289399601781301074701278289240976204997968793742");
      _weight[5] = ct("0.1354182600672564641764042852374920057830707307904626801110973942414191156942172243587060817600027027");
      _points[6] = ct("0.368007850449337717604769566250171596247982565113976890620368550952044195900000495246411103376721109");
      _weight[6] = ct("0.2115351550678566328395393557696844837464895827386582581706740133267465009849730196407481293438002147");
      _points[7] = ct("0.05689815053365792071143485937912054793467820298666632147108136436086362854588603274828183051491504926");
      _weight[7] = ct("0.225091745611232505129663328610836642061495180030943960685427476047529432641869184478743685148813548");
      _points[8] = ct("0.2422811961325235611113945553650933509790917920092800543802211222195903604925019606707436266710657206");
      _weight[8] = ct("0.2698088775257512998821031772547641973726038694971785623654789998437662428652904614577889155923326546");
      _points[9] = ct("0.1359502340502289542657634293851948978251888305899476260362867729648816564909173618213354134260413652");
      _weight[9] = ct("0.2802780308346653363454898212327328392359722478917409167971915727317879309984750999998056323426925601");
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = ct("0.9583251437866482019244391246661515172975807330371457605995597415964384943234249185759655416699374958");
      _weight[0] = ct("0.000375201944039112274110771110315908356687730405206470034411653934686036893473293306588774880319268213");
      _points[1] = ct("0.8906910993543921891508128999060838449706283276255334717255508939690538822374778360353169582497335915");
      _weight[1] = ct("0.00385208230217295633280149495827083673193151247870147197552704364619028592854368826873460383639665097");
      _points[2] = ct("0.7987843585909146419746087280073481414657603642892225070265379669025781304819516320234507849776994695");
      _weight[2] = ct("0.01656001705287608941907074982129804342900595679782926547479362297629040174388475144000347871328583658");
      _points[3] = ct("0.688324239862956685695533975808089616887768561474068757166363819171422275318388614243984518557290749");
      _weight[3] = ct("0.0456583636723904729996850512271237669584876826738233279287055153455876677454530500071081468737087832");
      _points[4] = ct("0.009278973831348834202946610301344755180099785584988668019087892028035392237328733017396657895312042244");
      _weight[4] = ct("0.09320340020555350966024561740341972459706270009058980336483720700004390524125197996306174927564459171");
      _points[5] = ct("0.5662398391545683135675124719348766600394909006313209815451544722188689876257081925222297826462922053");
      _weight[5] = ct("0.09435865415522771459726664777523037712224413619385624135202085655621859469783133863488143428243946943");
      _points[6] = ct("0.4401983998588624670826813221763196944009306574309261115292338038944935336942601582950581383666207959");
      _weight[6] = ct("0.1571608711937424489861433436853150352752777007115971600215818769351715159348001703309820163758798218");
      _points[7] = ct("0.048249692094286258286483723731131691367687071501178650576197695398469355275111244782622963767846247");
      _weight[7] = ct("0.1949834441226579674578013161123198903391393493913141165710324158456011237446879391336948781555402736");
      _points[8] = ct("0.3181179519062339663774464665791396822719791120780551488743875923139814199674731765500037687261335592");
      _weight[8] = ct("0.2185288892841797042827148607708304088540070080506917135110024995552378489195340132318724808370494739");
      _points[9] = ct("0.1157886266293952259603059182556492085885288892943482283961924853822757749603844675338080199944631066");
      _weight[9] = ct("0.2519181720014695773533359952445167095153987763649309891459044750285736696026664998184742228754605857");
      _points[10] = ct("0.2076683415970598824438954253005318541962122637198783812084003037910494205451576930868295318153374046");
      _weight[10] = ct("0.2567342373990237799701574852246926321540907801747927739535161665097322828812066091979315472275857163");
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = ct("0.9642065352926715512129553062783893235051470791627773576749579921411683197960515088339540982065266612");
      _weight[0] = ct("0.0002382014392332466553295292468100035402588379323819602604826503406568381379009877933689507069923317518");
      _points[1] = ct("0.9057950735445437268017964703997392322761079119953073066163678713751459636010637378082399631441249729");
      _weight[1] = ct("0.002479813594178077693466924685437339297957267049610856766740237535355291735573310962968151138526176774");
      _points[2] = ct("0.8257185142147869017640833629537027093736435575778818152064773066577478052593968978372571869786865626");
      _weight[2] = ct("0.01088336857641535741816614466540524551935021467910130060680909665551588747958855091474710790206617211");
      _points[3] = ct("0.7282464529530726864288803300611436952397911534452751751134554512822045797431115007040988123166108503");
      _weight[3] = ct("0.03086546809554570647515094649861202512818448992619175640122761773789205214076726685224260000604713766");
      _points[4] = ct("0.618623863458456046293548861891138148294720180209701783497547364656844356405705986332563927357603768");
      _weight[4] = ct("0.06618937457843764840554885416015182450294519306581249015227764712822431773609940807764767959301801296");
      _points[5] = ct("0.00795204570263843687621909334004042303258789157901845111211954077607260954906099644364827702074452761");
      _weight[5] = ct("0.08012445033899501177523089686688632200915300524216047110927662984377082923088939924661277616536887942");
      _points[6] = ct("0.5027573604490322032793092784391183027172079885763226380243920422697606141569862957949651716180958326");
      _weight[6] = ct("0.1156322073549094419776139687208225491632847535363357613046929611804166587438361502417881862465344624");
      _points[7] = ct("0.04142781045429459079077016519479508238169039978959055353403669646892966829653108165370954342425005537");
      _weight[7] = ct("0.1702264614696225510918739636030398201621484344112814996354913309233794603455227611295265426262321147");
      _points[8] = ct("0.3868920099976897916656347038054368617573779726132266856600842411622840190011408572046787141187486327");
      _weight[8] = ct("0.171059054280755609269063747143514548405033082766416787099850451303096574198806692484217307152058153");
      _points[9] = ct("0.2772734577993151198175389183105218031690793465049448069023914667625432657455874204304984154028694716");
      _weight[9] = ct("0.2182957646569263313022348391211610218077554917110947715591671593278409360063080187628820023513092495");
      _points[10] = ct("0.09975762554261415706608170348029973993914665962085252482832659967377232598679917985998074692048546311");
      _weight[10] = ct("0.2263367389978962785859121446178675121101775526351403133866313748357859288961118901399429789565430877");
      _points[11] = ct("0.1798107890524232495416433443072131398519613973866393633683049652350649339970260755579436050297147405");
      _weight[11] = ct("0.2410024299504180726837413740036251216870850103778053650506861765213985586819288967273890504882725107");
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = ct("0.9689288942285889621118118173027414862466810321685627399195946722689891537382806172804214947762563879");
      _weight[0] = ct("0.0001560679730565849110018877622564030522971963926107455394995589020798212499287723463265570237517657826");
      _points[1] = ct("0.9179996455372066795336259702883514644585607264667402765509172640216951031101831301991193963406574736");
      _weight[1] = ct("0.001642883567163541667137135579634586264318797523514426083342476902975498845674881247797284810378208794");
      _points[2] = ct("0.8476910439472323909103140489514170370916151645340936646068779732870007405006591332706754097819751753");
      _weight[2] = ct("0.007329564556957514349394257676697856873834127393279604943260422811450298594922588905052267132904176197");
      _points[3] = ct("0.761249766308276972276659526393430789096233559591680956812385294673641776520411182465771879851800669");
      _weight[3] = ct("0.0212542773553305537922236577273894920266795630618925270008614094028470673633842799803854792283483557");
      _points[4] = ct("0.6627093135603885423214631521232583899762109853102761874503785215844447164251275965254928056783280667");
      _weight[4] = ct("0.04691303837240752265188152459747705248625923503706344789441878308197981725976028730594650682213315277");
      _points[5] = ct("0.006890831309958731396681534153406989161031292429588421666464684973903589904229316285895671436921466539");
      _weight[5] = ct("0.06960491444024738195232456693410433617039772704751655810891567455689639937541737691245714318024412803");
      _points[6] = ct("0.556674622629455010696946642362080582274005790127050520864708239847742359838170526149629812384999097");
      _weight[6] = ct("0.08501998685902645212445243555463312092509357047145464604938440147163681074074875244898739601239204062");
      _points[7] = ct("0.448102638905709853628734308793979708730769418234673142154600177113914833602501069027983838668057836");
      _weight[7] = ct("0.1317618067137311603345937815895239661737637824034451034501350134739730493893049812226124269295047473");
      _points[8] = ct("0.0359533627001700955011328119695205132217760105545034090502050160774587979100248003869028934390782858");
      _weight[8] = ct("0.149706832675376159814665192745896090274423343707367752518259997752083720102762657728173384760833919");
      _points[9] = ct("0.3420695126460753234745079965662670426694598946354515144515707529248230901101547245184760072145509804");
      _weight[9] = ct("0.1784984030224598177222653499089708881761495368969374648507406094628872556990281953015547320237188519");
      _points[10] = ct("0.08681178015758543328428030769060128035868046724108182524481800707505654573671895497355362141572101772");
      _weight[10] = ct("0.2036393228507800763716273887505590308873494434785424621492199411922564371066863588578324885550135641");
      _points[11] = ct("0.2435328995871284444190341035677509233546420884568021588363910256954815690060216467377269714945612026");
      _weight[11] = ct("0.2133600864234869829016066656915215457043166425583673690879063724648569706987753465045737718877610556");
      _points[12] = ct("0.1570999741965092747305220655514795076460478559637808966768026561701334378832315878926359118028066273");
      _weight[12] = ct("0.2244461485233095847401594888146689643184503673613412256573886718574101869069388545716338949684001378");
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = ct("0.972777120741183230452963363167272376141832232066661615502209934421620349446232535307554709008591307");
      _weight[0] = ct("0.0001051046466755994190066812166292344685646859351848575804945921359672835410758237589818594844183713655");
      _points[1] = ct("0.9279957387467523249837781220393962330973069328106674535182517668455918785733163177668632107772943337");
      _weight[1] = ct("0.001116397363787513880357822426330897791338165514714505129793583213369776447193493631912488567194436826");
      _points[2] = ct("0.8658249007315969536711408351810170671281166559680840985364216536761121893264203663610169524834368559");
      _weight[2] = ct("0.005047135580629952165313333678903904301766740735495618421679475165368531852851525344466712644979621146");
      _points[3] = ct("0.788774238434560715340304885598911781259911841674992787459123085551496025352674899149699384244556166");
      _weight[3] = ct("0.01489950270113143528621524991386061259196283121337933421213015237018974938111932684980666809215126327");
      _points[4] = ct("0.6999909171699064974107366639384890954484520793287566604677488395049079890581595895812516182137613225");
      _weight[4] = ct("0.03365190694854584883843086111142799005260169355843994956162857554818205354238736452087127825321312291");
      _points[5] = ct("0.006028808871066648170088747712159971400916567403381750549695222043202403723743444571483478785282597294");
      _weight[5] = ct("0.06102082447779318149404536788951199265358380400157561994830938903862191015641396072434298492746016295");
      _points[6] = ct("0.6031073967275967836818955665403615514497986107892801003779313726143183351054969157643569313893089786");
      _weight[6] = ct("0.06277732914029182873972173919394741932291208929247041454114182049684592982407685936803284668904118036");
      _points[7] = ct("0.5020891397499784100693253980496002910686100916885675007465829924443020109731422291660366333167504029");
      _weight[7] = ct("0.100864734147356220137224880808875104302052192464766848649639628532366084837666605920237506855583525");
      _points[8] = ct("0.03149425981865759070730671276631670807205021271980635578223819813728679761179934797609978862835346418");
      _weight[8] = ct("0.1325583818798422395037209033460692313542102941236965236002400055105646280610200698756731543890029501");
      _points[9] = ct("0.4010713786971543575811860320519884685924384191572501525138619910884257329369228617255111752487734427");
      _weight[9] = ct("0.1429560411700584519366501032413827809654950517490789640352810210845232863752618039772883247583044508");
      _points[10] = ct("0.3041895281416563096323663549044031022663432275568421834000345432977346183474641407178311135015966833");
      _weight[10] = ct("0.181013729017843525860489494264088046051451408765004892376855696951718958925979135336553761794343072");
      _points[11] = ct("0.07621362247485386758640678634002269316243941065388009043581495037460591816702556531771748717780648104");
      _weight[11] = ct("0.1836590884586847156456151997787713864338837649250093240214366377932523271705213409778289378534453448");
      _points[12] = ct("0.2154097570688955749006955320851489135121375905412025496653310142236265218036971673059371903435771384");
      _weight[12] = ct("0.2055596961578860130952322610656504885177771188630820243106415066192827887029009016919044018841550359");
      _points[13] = ct("0.13836652595947406914513833295824508073297946097396003437808776911010256290723795262197366021424416");
      _weight[13] = ct("0.2081034616428068073313094353978842445257334921914344569440612488730800245148651213554324071384231894");
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = ct("0.9759538743350237095620038412791153907886111958465214282812663898287649311216709075768610974652202589");
      _weight[0] = ct("0.00007251514227803490388636640769623041371922231503159275050960701128191249448264412063567318483535691285");
      _points[1] = ct("0.9362818217355187421025193722871475594082635803646883892837426450201379107391391453318432405302555511");
      _weight[1] = ct("0.0007759490522557821973605351452471324906775817329617622870809982729562547897699646378604645579100034014");
      _points[2] = ct("0.8809495287153136023880805549365229247192257620249850286280431657774932073581341528362053919854452732");
      _weight[2] = ct("0.003546294540936386695929109813840513953405630969412226155615325774569207011586893659157938322767788821");
      _points[3] = ct("0.811925477275009666689693121201954242771620008829733004296824074056702209005600015576730552774306681");
      _weight[3] = ct("0.01062265194309727672451284568453333373257143901288406177087267655658817988164428587123611239563582801");
      _points[4] = ct("0.7316979730525232062993394846752112991776703416144255053301405080726071072308400265108448666008619891");
      _weight[4] = ct("0.02444420044082419616486125716889612243023339647683950965594801711901059340309718047264869243476431921");
      _points[5] = ct("0.6431646017687849385394940088418749344687178001026537323433816746667626232189289933810809550840731543");
      _weight[5] = ct("0.04667432993910655425413732479156533084522800284809613605669453781660467725115778296456898579690543322");
      _points[6] = ct("0.005319052002843740590997840273977394950171778649845101239090388582865436842261195140802135539827222464");
      _weight[6] = ct("0.05392665090053721636106293416964196355047711087332304374347740716255549922473738865652698714578246672");
      _points[7] = ct("0.5495243555935513136546896219603138697609059893623113297331642759135899174924012857390026360474762955");
      _weight[7] = ct("0.07717366634109808194395315371897661481697794303982356504901090232725807785964281183615873931332253627");
      _points[8] = ct("0.454161235754477099160096249961882970440028290412084992137967720315620010546080107378450741085561459");
      _weight[8] = ct("0.1133062126969649905762758964950627527929647767293146529704816117151296007557005216726923669605708807");
      _points[9] = ct("0.02781456191826005157198070923807354759531829239720000300594134265113548577494995954028054810204631919");
      _weight[9] = ct("0.1181106030271928203575530674800549317555657907909469016820334832959564842606168165865226255761452183");
      _points[10] = ct("0.360521693587057648157784440778396533845073304851300600175139415981041719351211561421203525213788629");
      _weight[10] = ct("0.1498955031684052123812771871602716067084415379038225419304375844804254640021209627209252643892922648");
      _points[11] = ct("0.06743186583899861338456857757181849448994028471133539011140154174279356463786171047590124871058861619");
      _weight[11] = ct("0.1661252306064170614951978271811555413440569614651595199924632464948276552123825945778602473840727527");
      _points[12] = ct("0.2719899659294862030563380079302590480247942543957991004491026215444180175182375256505110567396822931");
      _weight[12] = ct("0.1799662232824637334629206112030205761825115733710491636849576725169740218336869361061489424124481296");
      _points[13] = ct("0.1227482862154978393395873240130317032151265317293409309723332247616160353114996846526951659728971574");
      _weight[13] = ct("0.1925282306741192635536195068795429148549620175078239732019144990499724648233740495658097375472587461");
      _points[14] = ct("0.1917657062776536255028268450504200863445325847077754640124610110844518238511837287875868381479691005");
      _weight[14] = ct("0.1961650715776367222607857100338277674615403482968446824018357637392232405293324998845805559263136167");
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = ct("0.9786064374986970125728009137812822496042690312088548040286436320973606732995221437659921341073019234");
      _weight[0] = ct("0.00005111364227877400497664824914822312187523131871077788171487966030019098788805718497028848685167938348");
      _points[1] = ct("0.9432242857122455935254506623929578257508869485688987484186741352804265152613888933335080761298126981");
      _weight[1] = ct("0.0005503124159022070098783811162627949675055432854454242381238069353356523893162308519719894537983138428");
      _points[2] = ct("0.8936859745488040188148696987681606327646834274095997914162494394444252336597543340153733132728571942");
      _weight[2] = ct("0.00253783999827534747204339587398565531121845521667075873722207114552047240564197912364057170241739288");
      _points[3] = ct("0.8315558830264619518892063548240608922762470054306231569778660096958033620199460946608882490135090267");
      _weight[3] = ct("0.007694127704267096909529759414250766143904775295057170663912123460022589036462078267439682969987203195");
      _points[4] = ct("0.7588252579491414133542794053511356108796435680365038583957695605622632533727925268078632201504708403");
      _weight[4] = ct("0.01797939540591943553282655904326541648736843405213664835704382086461644807389169392510655535237023706");
      _points[5] = ct("0.6778299174145608113025127726414777500320971717496155010727267379426891048458460258015622127620921854");
      _weight[5] = ct("0.03499018198244827989832060255651272931793234290752719755245012805681995519918979378047157992202798509");
      _points[6] = ct("0.004727687122934592206150610445064477185987713349095208078315620471990461862622014098091988804943732811");
      _weight[6] = ct("0.04799762249876787834602678161657048141079099237527991579241094505115520768176249489883380358692632167");
      _points[7] = ct("0.5911723853165030889707605187763419229680436878682765211186872551925076536578972852139357400884025256");
      _weight[7] = ct("0.05921510663100695336095700399081714160082916113233465165244891577971830694111417358117886339758554005");
      _points[8] = ct("0.5016375561531875937001304323508376116775809382887043798099322048009739763486344428459428277727638743");
      _weight[8] = ct("0.08942874259811972089333893705457462540747878902452832779327225337155148601273155358526763706035859378");
      _points[9] = ct("0.02474296761943498451260345626953567205761528650626344100702897707414062868822532862058633802247189094");
      _weight[9] = ct("0.1058433700693581081617490582582260489397739540049851972587515247508128778921240398581401705139086582");
      _points[10] = ct("0.4121029641168595969172842136225134716264638462851170381104799491302816048435587877644761732164741742");
      _weight[10] = ct("0.1224481516713504381677953376318549301968971738616216687469062423535307787680712176524375047323900127");
      _points[11] = ct("0.06007643771663799227524225532811249949040794230939448604178028132546709554288543218317352848544150918");
      _weight[11] = ct("0.150743298727674291333260325777243530241463714895605434027434973309301093690716384177669881743882149");
      _points[12] = ct("0.3254462100241296148268368519018063901298314159028243246203929830145913417696717843549623084103386732");
      _weight[12] = ct("0.1533921878047438226943307636411683225532230366129434468301308130372556609842068604135406661181292303");
      _points[13] = ct("0.244452431744511377302076561602752031033579055361062019964516938437829086971547471305886973271011502");
      _weight[13] = ct("0.1764506307035974844556454963572807953528221877075630527904162026163913063727413866339740371354372271");
      _points[14] = ct("0.1096006092587706028678975846195003827709889318416547509152886361080137785970255407503143033719803205");
      _weight[14] = ct("0.1779862938901728599046041983508410784211710356810272044473323158434144748195799575920162751395462319");
      _points[15] = ct("0.1717247594830021079030741779126958738693210887070413817883535217741774057292701297715602601789514587");
      _weight[15] = ct("0.1860249575894506351880500844013307938590785059618964565637623170975868320778954318066738261222629478");
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = ct("0.9808438938474125636766637209275972068403939450087260749208889199283197846333843968554117528460090215");
      _weight[0] = ct("0.00003672321680050201588893508809125700046531141997623090861092178661431081419170841266491721846696051565");
      _points[1] = ct("0.9490970165965445702465476283565708297246607755586873532653724677803087032874699499858701150851049691");
      _weight[1] = ct("0.0003974261013418958398496273404764511239692337872082450246160077318175409175170546288895012284106365673");
      _points[2] = ct("0.9045054233143287003790610093283550812376120574920944369394302938533880974366435920451390516090983422");
      _weight[2] = ct("0.001846696235108452323081740268246607255059909970851485069280721260167157397850582769904163871861571394");
      _points[3] = ct("0.8483270857099506075790635313717878056529164545129232857765525221759979278054482949739136814535756339");
      _weight[3] = ct("0.005655535035824528926649613561049219086512768112197461770524280675540737290522504605487405853423758352");
      _points[4] = ct("0.7821731030812211281011385401557176313519720275190703032263911897342087238744392146926368605116439999");
      _weight[4] = ct("0.01338606916727926148618970164658395028370018090423553621907901080091060043469655162093802538030485222");
      _points[5] = ct("0.707945001385085567943622426073089923213717087524592918375047496075645698517876359910689968651062034");
      _weight[5] = ct("0.02646567904144685891462284647978091273368422635641062894104746521612846499613282277673498551270934374");
      _points[6] = ct("0.004229765486490767874991987781300685340308435773431352185301973416816197017575857315649567725783395143");
      _weight[6] = ct("0.0429926041230744866513362488197449940557411715901469062889684425716121073405792471713585540944974964");
      _points[7] = ct("0.6277775385468142725656053809477606660481926914076750686903817659859352892916227568745400677875818882");
      _weight[7] = ct("0.04565456895454675099029361310226524142448988405389158412248073822256735245132154460401903761295545258");
      _points[8] = ct("0.5439766780904757097451521743554710584231978091980306940950977666498348773038378260887674018571215284");
      _weight[8] = ct("0.07055515732420044207392583546335768383670146789242918934183781450503912339593438180917722727222643093");
      _points[9] = ct("0.02215270531183023229420900210157300154854505840882207694347863994881565153556420004262394660019368648");
      _weight[9] = ct("0.09535104807481297848202429866106118257566228137557417660332400853161662680302761699773305885383429565");
      _points[10] = ct("0.4589530533530190808593345147437514652455985649810014296771181666727254937874683576150552189676820445");
      _weight[10] = ct("0.09931702444790433120952426058302138873908984792726837791724440362064021175262692440686069358710680237");
      _points[11] = ct("0.3751525416408178820083477139222646171835998951809981629079410853435870113997403594064257319049096888");
      _weight[11] = ct("0.1286542804495145568686598485110360146860251475979356089399894897424306248964305507294249894650268248");
      _points[12] = ct("0.05385601482718482956676032201364452390207889406802519433016964589948411947150472054630517663168267146");
      _weight[12] = ct("0.1372315591826875201137474777560073360546853485740573862533356511173364265079156697526661117060022962");
      _points[13] = ct("0.2949858662980234886510059849705601329210424075903350147902591485628362645969755211291710565803372332");
      _weight[13] = ct("0.1542209677884094145128943284286812925327302523010098402991289260221514316057089544615700030218449205");
      _points[14] = ct("0.09843493683054136249424692423709782639488974724295841277288648647004523568418618804137473135772561813");
      _weight[14] = ct("0.1645759033882728284844431118628830743614989413169168358659006260722663488738016626358120054114977563");
      _points[15] = ct("0.2207592251921513839136378776833585067846629363530123208654012539977418973898636052213362063366054326");
      _weight[15] = ct("0.171301615711738213205756533380504272892453453514380537158994786696403130130385394099728124635078177");
      _points[16] = ct("0.1546079282658856298783890388078768159643889899573936780160589552820868047441765770328672418716605903");
      _weight[16] = ct("0.1756904750903703112344453123805424546908639066388433026089700387600911377246901618503645283631366504");
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = ct("0.982748407594286960633073899546303045149028562784532859367422241743337841463798829462474307855455184");
      _weight[0] = ct("0.00002684034449817248636307890670990759607627648491468895416588504339235192716316452092184439475732072083");
      _points[1] = ct("0.9541078955173166588189030938461288380596566681165619454485636499417392056850149493349451358778683482");
      _weight[1] = ct("0.0002917480346564748213126518173258607508890442325216746931561102953965933068483693177921983263851560636");
      _points[2] = ct("0.913769864110792936166123189791591200842146787728630171609250287891749264970030467465031991732660097");
      _weight[2] = ct("0.001364364814750619931583941001892832710526596444814880095801559791422327117557391969710365759943918772");
      _points[3] = ct("0.8627567207000550133608166202160961738680665986694630756476656758603077150109726400447325844934459061");
      _weight[3] = ct("0.004214201135828769484963761390752045700215974350846961473780225330124447098246374619584268057948317043");
      _points[4] = ct("0.8023851498364174702066737905851700573574353078541166033802958270590653479162625703154687749291640617");
      _weight[4] = ct("0.01008288655374502320909828094580508673228285324540546402052877073095600352583258281978552537379255498");
      _points[5] = ct("0.7342173081350132503192173614025312330653864334982702635244595308063572372883774041853861365278221063");
      _weight[5] = ct("0.02020099515341872526673649424020333062100969085759988997176723342299630382322198514555179632843105095");
      _points[6] = ct("0.6600181272253155465521234027038088059575554457571711316782527733933985664095417196979606497396358233");
      _weight[6] = ct("0.03540911290037990977420098813904969531272785240516766309095652038688854805794084594012390191614815156");
      _points[7] = ct("0.003806582247501876383648534354890812883653084218143725055850915751286505483558068230455044287128636871");
      _weight[7] = ct("0.03872959521506409270998592307661178898880126487708449836871701251355028383578477016496915438790270965");
      _points[8] = ct("0.5817090526709179282288375852933077443864571121132991743769987023431980248853066657774790851887703593");
      _weight[8] = ct("0.05577559061459162570281412768389355996651397767708828589498056037792211480330590031535721170146035938");
      _points[9] = ct("0.5013181027502735883646759853790557548582408474545762758344248448850577878823309680705395605759116039");
      _weight[9] = ct("0.08031456678547888071777527613084748403550086714243964330239128562327769673230247753017547024436125657");
      _points[10] = ct("0.01994835104734301866630127355057796010747457504422512741431541670739879638700930791801503643734067254");
      _weight[10] = ct("0.08631509071677530810863100163952706294278370989850041392675520998322403679573746872013264641728964926");
      _points[11] = ct("0.4209272758703179558039109560839247557191088306211527841459293605637953895210495784407565029266997559");
      _weight[11] = ct("0.1068936974758404779443918912465824233672883504398824139817461678734416233217909028738142876058300019");
      _points[12] = ct("0.04854964530422463096552581822459659415208810269879122661467419186763858390450800500055006660727244013");
      _weight[12] = ct("0.1253356306869180533118015916525710771304275652121960162491546992025945693808868351192974349323507061");
      _points[13] = ct("0.3426185978020083004514048444648040212380882146133496205314099376215388144800483221755275703026317421");
      _weight[13] = ct("0.1323839048082899911826910765424937040163915594177335399366773159697079625785760931901186843037828332");
      _points[14] = ct("0.08887625911649738804818139219495746882989597915475128356802041517986238494141608853322148611303921851");
      _weight[14] = ct("0.1523005370137907506618312924014636112216561687461645368895555297544914491320199297299184081013271168");
      _points[15] = ct("0.2684201827866020844201471280361786628127359425869124458724958784949980847348751285744762131603672814");
      _weight[15] = ct("0.1530511786893971990313986250253572460871774396855398171527438104801138575696244796632962408451428573");
      _points[16] = ct("0.2002536959236303382067125585321085063433107257362303407043370644457116850092167808120166500781902619");
      _weight[16] = ct("0.1651346632398309976571473150915354252515252272981002584619642650179028278177299248154542524099377471");
      _points[17] = ct("0.1398845708351692649300383552676525748959865708235061557519490749172429745529982954346474136929122904");
      _weight[17] = ct("0.1655087291500782613306060164007111909015389149173326868684911715359303365087638368773296390165836235");
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = ct("0.9843828065517020106761276174556909144026325831604026447615399145866983347355888758046066379113914637");
      _weight[0] = ct("0.00001992280932787647270670068121504406904050878009796350082427834039239683808319955860954897199570269474");
      _points[1] = ct("0.9584169024234071451034779092669423904741880674092767651904315631184608661010553708352299289446592984");
      _weight[1] = ct("0.0002173705725280176670944890960502804423166204597532801450098392340276614206659788761434319343756988316");
      _points[2] = ct("0.9217606817291400488993742163227374545276684154855298882918293363660999418596388711657739790912190745");
      _weight[2] = ct("0.001022123435563885025902206640552076666567191786422602535420698723807095034807642183511143694636939209");
      _points[3] = ct("0.8752531629838266800659489088760858408079696488715943336759069360574915944199538127854460103635272211");
      _weight[3] = ct("0.003180177301794237493019314012687144031688576745974063615856410069920493919217044916534773054139522466");
      _points[4] = ct("0.8199803570632373353795400684102916116941435268852334780207569085081760303785333606287354427331798866");
      _weight[4] = ct("0.007679153890769252819349084362266762034680794496687220780226080890557707688737671772550611046414520838");
      _points[5] = ct("0.7572365191732979354973693279466696491303870879952976126011813160845715548094948766085611653832161417");
      _weight[5] = ct("0.01555913925021236084119398351318324635350878964483833382275711925200825311327878919159166803224050802");
      _points[6] = ct("0.6884917909140949891898655120380168800849788729479226796014048212433893444546592668647864865663296238");
      _weight[6] = ct("0.02764324431172879278940581658661853456999576463765561596565228984548554485346431017256946431651819152");
      _points[7] = ct("0.00344389040386249028069405093317222181182377640029914128584811126158447282426935788168626248683411491");
      _weight[7] = ct("0.03506918822751692946455730452233595458916116289923823285432079838303497328566987932630680788077123048");
      _points[8] = ct("0.6153572448045471654669401635833708805050867627458286076001673229030120048708698995373393775522832916");
      _weight[8] = ct("0.04424576251614803158884713918509202323760369304517733604518806841090123069603439631756455979147352893");
      _points[9] = ct("0.5395469627920880876694306633299818817017043399462428376541362226335526976593984274704483496113346924");
      _weight[9] = ct("0.06492726128798530252071044988969133477365566175334068106698994747182582468433303021020195666737121263");
      _points[10] = ct("0.01805697833790056286303009395434268665894880733591034692641015267785535091595126090806803068847434545");
      _weight[10] = ct("0.07848342536092973805160513510880688200259433707189886999155358202518740624336539197330534394096169371");
      _points[11] = ct("0.4628377985520202782022048705469377514873721078497890685487969094434993704576336247176078079949870379");
      _weight[11] = ct("0.08836225259929596186133469102150733448918159724655286754038526721794532427584912859912903335150515709");
      _points[12] = ct("0.3870277027693322034154529075168274250441355570183945919149496613274873431354056703498844308990953007");
      _weight[12] = ct("0.1123664317444116305965655143169402510025365271744523979648159561101015872421911323846125879396222849");
      _points[13] = ct("0.04398739509084273445519883277365948261943201401533755288465140272078804107508383052868780286880037334");
      _weight[13] = ct("0.1148325991148163444911640277657323543047270823476765245035320839854858063568929732605305651848156571");
      _points[14] = ct("0.3138935674182182241524085986530725421833888559124072140832271736633880973343121552225350975792017752");
      _weight[14] = ct("0.134100272282441135843622802269838878514535106695959606198030755727139751181154620361343864744773243");
      _points[15] = ct("0.08063327636666141546972177666301584599572774478496515259512648347202733971049631258972859243872553855");
      _weight[15] = ct("0.1411124687979040017383983383889387833636924536378786579842406801114338206400330468092921847805161686");
      _points[16] = ct("0.2451495690951685705524921770182137890794445582375331816751643930651784772617999016157149898754773397");
      _weight[16] = ct("0.1504300020813901758036486944453268769096163950084233519532702102196909305554659060185430103650449769");
      _points[17] = ct("0.1271364098615602695300253508396918022790446090548847239057383641397465202768706860278890106271755421");
      _weight[17] = ct("0.1556895448890469502039433952460571175059219100966614582090178761629870656252840687807066371333142135");
      _points[18] = ct("0.1824069836690918531306969538712789495119226639431501787827330067269926177189844384572705963840879384");
      _weight[18] = ct("0.1583929928595227080602642462804924544723091598046442686562413911514004596788051226202861652655253789");
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = ct("0.9857957888406418466800231313592152785604899067877207377306395965180365635041144860468676436334983574");
      _weight[0] = ct("0.00001499688397334853909009654734905514945521257651242233497492603278336052697351239051006226204854156653");
      _points[1] = ct("0.9621487121504981897091608064229207407940341288068742181995487210154653226478330645824175987235472225");
      _weight[1] = ct("0.0001641564083492808221962961635922449664007417807376345432948175005715964939937779190026714134500071776");
      _points[2] = ct("0.9286990149187505453450978371672693948888756101758623893390553359882107838318818368546819590506483564");
      _weight[2] = ct("0.0007755532384700472430793540610379271893135838353708382828748805776320956014381700141548785598395884206");
      _points[3] = ct("0.8861413029145471436872829303649495040166030756579052437556327864000033121939155088226394817590025748");
      _weight[3] = ct("0.002428182817069033016610894924350833114680897738357536155240424761102475327226118558922110562054613683");
      _points[4] = ct("0.835378914631561725171518394713412658084401759968059337516039711093759997511552876897585105888108726");
      _weight[4] = ct("0.005909777767885943225135430582621307955547100153876209416844747358074494910134249252257133135713181473");
      _points[5] = ct("0.7774925920354867535511259458365767833501645594282318185786818344152523063340596941838540072199020297");
      _weight[5] = ct("0.01208995668362951749967394391224448828054059207291389348694724435189801244587869887557864332435867969");
      _points[6] = ct("0.7137156110152876807420834353539261845083764977327116606392342641138367359145141329606212643884043524");
      _weight[6] = ct("0.02172836322449210980004804457059473249949021836957893650421253545420376191894281707541313281395790445");
      _points[7] = ct("0.003130683740743589562150141749546251006558087897339829841211539349738274314866496852982779908203455384");
      _weight[7] = ct("0.03190317094510660674090924062970198411577078121671833534897277070677203833980338615982239630856403199");
      _points[8] = ct("0.6454070457773675666173208347639696868480924890494238974440167033076937496843430736866993320402326217");
      _weight[8] = ct("0.03525422431297342131570109267190665101713924409722248740423389077510379965048840746566703817840967523");
      _points[9] = ct("0.5740226581828268717275121966537067538016418929949592700206557877680052279117492170391822933202016281");
      _weight[9] = ct("0.05256367702664660696843253488312400143294584902673080355015772217448264100685386833519746415036752641");
      _points[10] = ct("0.01642208813398783290254161425625752298093599837033552370593506952105049398340715992554357459620698864");
      _weight[10] = ct("0.07165500930295423640709583546529029927063232240443669945496644251219376217691519736672476809671709037");
      _points[11] = ct("0.5010838154828485513706246541369263270496076238639477776074661526726511056457717245333351712537248934");
      _weight[11] = ct("0.07288201367307476620737326123903540949531459313127703706325526164891890426846954818738827733176229809");
      _points[12] = ct("0.4281450409332566846154250347724519581718006946562795606850444879460088034322223621075385140190445604");
      _weight[12] = ct("0.09472916165698421592346580106597904566789390110319129543362928719528014089962861825723013260548530379");
      _points[13] = ct("0.04003690046190678099632014982879280251919218202100623418922253900409985734318539080916720634178996678");
      _weight[13] = ct("0.1055302577165023391780536338961832585932656024160937632538479770610925703787292264148375828435711154");
      _points[14] = ct("0.3567608701024531056470550666332594421879937365627218234316645015120881052816834839729303782691229973");
      _weight[14] = ct("0.1160096189823571406796654290456113281805357426540610444070368909950710161534150063798066831796666365");
      _points[15] = ct("0.07347719178528528305756654528587446712162956746829331567597923056648385302094819196497247815553334907");
      _weight[15] = ct("0.1309385772702925921899186259959536648124379399531342254695653323236852472377607884882919968014591912");
      _points[16] = ct("0.2884527121812723847719407066523953852068123046578582394812568730574474727765765420104187934722455199");
      _weight[16] = ct("0.134225725813901973916010859290956315174257925122368934739958261965474015514859603925292839755104494");
      _points[17] = ct("0.1160309076554868049466974315674778539277330768012538553063813735353261223084763159059242881112717542");
      _weight[17] = ct("0.1463516662129082599464371823076988796401775386811170193209364125128477705820631778004347152301799095");
      _points[18] = ct("0.2246764193843050384093819648321044864540754911683337333822542507266562834493851020811842664368541631");
      _weight[18] = ct("0.1467896818880725308530169982826116192006045612648753091087111859984896015533920748162929571735174518");
      _points[19] = ct("0.1667912534810094300129807014584903280447908397404053429938887652977094384333228625709776729362660067");
      _weight[19] = ct("0.1513895615076893628614187777974902875769289857347589080536723214276560283463670856505077453685905939");
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = ct("0.9870255665787578365469005516471821103487323205471391754376943598319864464211860106934058825645258605");
      _weight[0] = ct("0.00001143393418724068380170413895308611060849814044915809164226820001407628104622909351779375362862754133");
      _points[1] = ct("0.9654016073657424580929490790442942557127428617746879386553787549823009422401519559419539901187908714");
      _weight[1] = ct("0.0001255089335871709281118126890978511883410232408935299359481594966361344340514817928666164963461870615");
      _points[2] = ct("0.9347604364012299479827942935966019857975433066835579885667315868005288394577841513140255125926971028");
      _weight[2] = ct("0.0005953999959462022743715146028300385175077092750037786268248278976636240495566479815754772134557262851");
      _points[3] = ct("0.8956817429254667605282025742976504630403884116278020040145896760872923029903183803945118949524779672");
      _weight[3] = ct("0.001874294450135896801731784503573779401671276969326976735014995475320855077785022212257014129577865045");
      _points[4] = ct("0.8489227735376888398440174689512629925240544749893709330516913793468738663135396111526364874935057414");
      _weight[4] = ct("0.004592965682865899309081525926914390207513681471407921864480309470237783124356199535498939949623202478");
      _points[5] = ct("0.7953925737461314623249865033277437002775654540111543847783430994750663228409525643598837266227268953");
      _weight[5] = ct("0.009474486138446127589636908414029505700709517833191754141564237314203429084320420413231363560359878364");
      _points[6] = ct("0.736132620597287348464102976702205297915724058040746277165260616804853384913595025246627455052229207");
      _weight[6] = ct("0.01719724025685366088414548084037341187485771394568726343623778138278751292702859398535198066378906091");
      _points[7] = ct("0.6722961409869296162899704994812126870277260383783201960320999269060656781743057964570096111577941914");
      _weight[7] = ct("0.02822928389744864174544586786898217788137229652458972736832397295131736231647885061286268917613281016");
      _points[8] = ct("0.00285835060009189432225562771682668948582857512454396863027797721426567661617667311949044311935799591");
      _weight[8] = ct("0.02914652692549772359825191743397280020164868373562383178741132669912525302067096472110019756153082352");
      _points[9] = ct("0.6051255339761019284481098523077407624240428731564207776008663713434935031358888405650262217950025242");
      _weight[9] = ct("0.04266508146203472287514740814497105426127212704884677528002189938589343854792402933566360152308841045");
      _points[10] = ct("0.5359281386930321609326895183917609968520364389050114840655237758106639373854988648624902834575404957");
      _weight[10] = ct("0.06009811216766876110645301901080290470540542252779656010666162330015632690205531715683178923222126385");
      _points[11] = ct("0.01499936497207552234035713591602254705393618831318367785565166039034387086356684984726917088159977164");
      _weight[11] = ct("0.06566824457697127529902981695220767771270006886685278602736453053393289071075554704667985742556471193");
      _points[12] = ct("0.4660507666351746484729664900381236689850117104625250010739461671795351570200905473063913279087995362");
      _weight[12] = ct("0.07955912026541126007769813685510363475963878808713764989375842730287294266866641538077148042860200142");
      _points[13] = ct("0.03659386328114012262654505528218600854572346118015453102909226025011769718948800713156805117021348771");
      _weight[13] = ct("0.09726429982522235339421302162613403019875891383246840547625842897557731247557947987411501254680287177");
      _points[14] = ct("0.3968534769856190095039434290948319231559830819379799669417186235032912613191108923209116958842566661");
      _weight[14] = ct("0.0995403355010239132382717196606446428701230436642824894483894589415408071164372671565051418449066339");
      _points[15] = ct("0.3296830989901027237373491420545228582656516694202723447101849302637120749496599731334902543040306285");
      _weight[15] = ct("0.1181122908083299756311975390634647250493155093193591314865424228051155593226483354511888038664192693");
      _points[16] = ct("0.06722644166793863852656394767467500357144072170962214241165856897826976130638620748193107205233694509");
      _weight[16] = ct("0.1216954186195147767859181700852196598453398974387542750341310709128680231375238395840669422159454729");
      _points[17] = ct("0.2658470140108159098108921515437181536788750914282933339485578881666960769687043708156597820375066426");
      _weight[17] = ct("0.1331241870513333849458925379704009194981324486702047607071260864313889685659564325467513394603855075");
      _points[18] = ct("0.1063014797376931175504486884739310046446260359816027861282438230188065644711946783060826726008422005");
      _weight[18] = ct("0.1375542142025096877653615060378353535237823217814758119642712415097028824989683064469150618759633061");
      _points[19] = ct("0.2065877060825335686769803341751510840175689986107977624063634924301173628588357156175136088108010249");
      _weight[19] = ct("0.1424637790987724784544985952839802649730864625728979547070145816086846459169762856846041536108135636");
      _points[20] = ct("0.1530585749557192122497019530096285339475255004440860527688523339429919998362921566593935826956915166");
      _weight[20] = ct("0.1443411095395721799450733462238414248515479283870827912143456827382935051545476673209780806694503178");
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = ct("0.9881024599908778831834893508543820892773502151203394249702418542482522913410591542225873730537640238");
      _weight[0] = ct("0.000008819828241607839113836319188467664692011455724039965611658207161388061470286555951138804647517523762");
      _points[1] = ct("0.9682538838165636528816421008794414241196089368489573782572610534009132752925859249504071948887717238");
      _weight[1] = ct("0.00009705271167906710277821920044618755965438716605308287260605611296691915914345444845503274559759113985");
      _points[2] = ct("0.9400856692108184696160307746610789762831294650129674325772200327073362883580966732090847381891661162");
      _weight[2] = ct("0.0004620588367040999729282212179118719403671385452681342157971829216665667312380747639184954064858913054");
      _points[3] = ct("0.9040851784977527206617013643188418266790222208067682092434771080729602120076277567836036898919526278");
      _weight[3] = ct("0.001461453138691387066178714368792017613580659773821636378785062623685765189258882757952421529824382382");
      _points[4] = ct("0.860891752762866217306561289088760798024280407816610933118125205649126736100379365501381094748080698");
      _weight[4] = ct("0.003602665011170079496010454313375118125820248682611777483518813337130543978051137706444943926445444968");
      _points[5] = ct("0.8112752068392205078781186463119643007891999522242449004575256452024235067993066706011518445018605716");
      _weight[5] = ct("0.007485551813034275817216951148497417410643864099134073165862080079074318408799086608465326459832194165");
      _points[6] = ct("0.756120559178934871229287935277861726124138068090238740139279322617849153755355308054543314195952641");
      _weight[6] = ct("0.01370427408387923505535094139296990898530719232986605891147317475726272903114323254491117374114252769");
      _points[7] = ct("0.6964118629859517266112670768971276038290954874249845702950806736765993872213401445317623482971794438");
      _weight[7] = ct("0.02272307353970016175798801382037590056507281990311145345973578790932392062647349992155849279080103849");
      _points[8] = ct("0.002620074720371159424859367455264888905528254905967075341414209716403766002695753259982505462790702161");
      _weight[8] = ct("0.02673172609568654751853295736245388910769904510379438631959110356067466777925600320462833457894380703");
      _points[9] = ct("0.6332145255726628427916625618237318565701781915004554642631578635011061799446656933683602264420425428");
      _weight[9] = ct("0.03474679389549965662247861906215097123019694954611807141411557017597677027192888562429244380178121545");
      _points[10] = ct("0.5676562502726097870217726677178769223611025672537427859994804146174746381249794034881861040558801353");
      _weight[10] = ct("0.04960981404383829993700779271549480288885853637660176997186571280097470956587682931711438082157298981");
      _points[11] = ct("0.01375365798738580402575675070905872963577871007529049791330105411351782591035575021061471597349499472");
      _weight[11] = ct("0.06039224968649528527797201695304747719350890246767119584138949538030174755780883063573431771451573801");
      _points[12] = ct("0.5009068926479350501177501589277218806508226892948913257700098794311718939499484259368208163972501152");
      _weight[12] = ct("0.06670592951879767846792762476690622296014280028874613091699757533426509227995492281918325108396123329");
      _points[13] = ct("0.4341575748401551375082012124710567475311318981229697451221181030460066453494908033714119124482954651");
      _weight[13] = ct("0.08497667125409721785945148880879745505881359027847151653606924351274875356349984209037489762238788007");
      _points[14] = ct("0.03357522684802669271430819164015782255936555354251479618256136085248644097781000029083755653408339061");
      _weight[14] = ct("0.08989485493810659201312259319068572635263313059560239420597839977609904961839090425684384721793834645");
      _points[15] = ct("0.3685994249559412825032166420129271053410258894370369258634481384659319950868454860519985944915827024");
      _weight[15] = ct("0.1029672849391876735260280671946109142630666826269145737607246207862594409036669986746323585832975334");
      _points[16] = ct("0.06173556162306960169082657439530799232593239853434981616795449869395358825349510725475770984104108369");
      _weight[16] = ct("0.1132978321011550534569339446690910280401715810568023622298179018105850110347547332801463511728914714");
      _points[17] = ct("0.3054023184425990231526085351824413364932159709089239800101319162552567160333479391342542847608906839");
      _weight[17] = ct("0.118949346513709232985602192391896693374558508471962113359062925535623349061768764063169676690434175");
      _points[18] = ct("0.09773269667536864245847988499672332346923869097633493640302023050164801771896428112688852124513295678");
      _weight[18] = ct("0.1293178958114777478613063500315394516761550424810764340961225637292240059327409033219260993510310263");
      _points[19] = ct("0.245693999624503322224465199004346511040095219161282162101130888622591782757543602487249492370203605");
      _weight[19] = ct("0.1310983476019885069549959653684284929730374753089605272225430034875336215931548267651214213714624036");
      _points[20] = ct("0.14092439775695158519450619775816451884611959708690538685783129704464061843005866589153388941048851");
      _weight[20] = ct("0.1373943986576711189457038637687127484198195244023737460240143431480038626621631210916534276483539123");
      _points[21] = ct("0.1905399551842166284991396915288050974055091810716148172940553365188707797144828728812777249740083098");
      _weight[21] = ct("0.1377052393125228077987045052679605699295332423726478549816510583467911003227901128808596332546938645");
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = ct("0.9890507733735791253543712469758400035281773409051211956278514761266032259261348911429860283320820851");
      _weight[0] = ct("0.000006876667443448386873597174615624846641300742166712499390444623619723899261299135896561250296435335989");
      _points[1] = ct("0.9707685195733889938794720318771182548024669818727768010084319949615096226307776604478341088419960687");
      _weight[1] = ct("0.00007583423894827645199529497212749310045124079552553215845278302430393444077320694676832428355417760795");
      _points[2] = ct("0.9447885021959101873192640703319531140411645602202181230261730429904477029248254097807519999563813321");
      _weight[2] = ct("0.0003621778022397484227568716984452699810122401675080385621920809602503235452142352579992064490492180786");
      _points[3] = ct("0.9115232476013712848631727800493825734445243013466233941759256931038532414323388171548016643162639101");
      _weight[3] = ct("0.001150314682984822344334855610916138444468915824198344682212336984814856306470038289503572924918974143");
      _points[4] = ct("0.8715161336713438696663789268096078560203102425650686035780009545736051097600251592363012603490395307");
      _weight[4] = ct("0.002850497081093543249504950370776049252981886294476489764789366131665472664109268239563547266953185198");
      _points[5] = ct("0.8254231835351607786693628066740285412448723033292098215120413379094288517271797907093120388750575164");
      _weight[5] = ct("0.005960272673820516018892550728367359102119125009944955607272944225823529645958240764551805100276375076");
      _points[6] = ct("0.774000884826103954870602865039850232459354767308173945418496573567419087448226053026498675219714321");
      _weight[6] = ct("0.01099396318272331474169753508597427233921996009999619601995167163454190521119038525024744167647511149");
      _points[7] = ct("0.718093423039932334870528968550415558136496950365395538952664548514450259640017620337759804908076215");
      _weight[7] = ct("0.01838949716531371895801221750607384775779877835883666504812201193134363107981822179196427825682835979");
      _points[8] = ct("0.002410403998251780792451856588101972909066529739119798212188046208814258289064772101273823619146110848");
      _weight[8] = ct("0.02460458715379363680944285409901799406845331559876742556717226362516710861484213381914616524325269173");
      _points[9] = ct("0.6586187096898888135130219138910443233073970121048619807684601196253997338641760466888560080659310002");
      _weight[9] = ct("0.02840664653778501707948217016440661524304227052022033505140575431516377941086740846607743484483156773");
      _points[10] = ct("0.5965532681512670094276258199980622909368222170766033931827570264949111422639694369359726047707370604");
      _weight[10] = ct("0.04103337000606945503503522217670326104878723363104651468601157260930516194676854942670347964613293905");
      _points[11] = ct("0.0126567991854554032486919041147616055178068993488019404920062315307023102839017774129144625521651445");
      _weight[11] = ct("0.05572024457122334686306970307932336946322249656441291155755441029051172750463539491200291665562579443");
      _points[12] = ct("0.5329161809469259852961679422880949408372018266872169088225806359785246671619598639988003464099914504");
      _weight[12] = ct("0.05591706970939040592614623445525001285248857059702692030395415650257556886501471071456697084452361735");
      _points[13] = ct("0.4687523477214090214073558308296168896809398353261455806058774838069360883559041595095033610401987426");
      _weight[13] = ct("0.07233501875091631840919628023809183145752557746817854260441269393620510970432941834632187160557783416");
      _points[14] = ct("0.03091420521685777042524659261449895967467270312206086783863872080618109788426269086493255324515362316");
      _weight[14] = ct("0.08330302639229947932606202543244005159580104495976244028104260557408709909900455946501879510312450854");
      _points[15] = ct("0.4051153234824939152589899821459852518084292041960127091818387323191589246479819549763061565524843399");
      _weight[15] = ct("0.08921331592042749615179791387250922454007077948520920020945311505702881983826510488006429430176552302");
      _points[16] = ct("0.3430500166905744572249642236228373303079210262636306213248867962132213743211306739909111276661963969");
      _weight[16] = ct("0.1051971301902735212171552740490809864687285728732286101918097259253218725264728006157687448724567674");
      _points[17] = ct("0.05688697073444690821032588838336961743654015907339725082650819749305629473627316130856328689737426324");
      _weight[17] = ct("0.1056636634236599800025960030696444996116926205371369655056408389679930032480510185451962577501990656");
      _points[18] = ct("0.2835755302598378337994539658113249207907562733532297915625840729145925650514832273388671279031826889");
      _weight[18] = ct("0.1187676404312684393557883257269936135587246278818678797038987739015900277273626487102457050127845038");
      _points[19] = ct("0.09014913455773984691589948612922737211413253931649758225808067949438711851934860889153068726819551827");
      _weight[19] = ct("0.1216392044936975061036741688714549551287865944305569473422823525233694802740589876102729570564236371");
      _points[20] = ct("0.2276684266411056773027710770956689945976517001579188130220661151724974754332539072451049501434355138");
      _weight[20] = ct("0.1283940193233969697677293919549598541264664191744484566283510181595252794240699445354258114294514256");
      _points[21] = ct("0.1301546569620392647297136145470657135930380187181655783102116317627332537731657610993460755762494399");
      _weight[21] = ct("0.1306458637267026875983182867538939685731303811410348704694137140183344576684464387632647813109838146");
      _points[22] = ct("0.1762466912782491162874995389654770161435899409370830936250632217648999272579318891342051808242810613");
      _weight[22] = ct("0.132703099207861685113771606242267040771719381177782378888546698410791460688349318846771129681170662");
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = ct("0.9898901712174520906251165597593773918847523673221438024487047832202131975743714655305404620841092336");
      _weight[0] = ct("0.000005414795649621589410956891889788871742947297812794956478833735739984001890036849423513416122201443394");
      _points[1] = ct("0.9729966238607434240581902575081331739557554587997081204643390924536815578867557077759207213916891928");
      _weight[1] = ct("0.00005982741578200805140757442756876710357681187764184129492998044221027472286015156917522457282670014999");
      _points[2] = ct("0.9489617024727324761890720630019867067891512669388670367116995074683944983852471238704034144706207455");
      _weight[2] = ct("0.0002865262744228954315248621894840737436204226419751809547178299642115143727296322854938132384108068028");
      _points[3] = ct("0.9181367783042758317115298970528403234116421141197280467998314494812585311720032200286955057989618405");
      _weight[3] = ct("0.0009133865187289247367136496244884025935049017690707982258831296507599797381201681041293897274275549488");
      _points[4] = ct("0.8809865112004901553982606734371066424293828263572332748538020660425345593942795437337711303415925046");
      _weight[4] = ct("0.002273816875030566631082337760719505683063855834506483104577945072621905255965654055089511921562870697");
      _points[5] = ct("0.8380732394393357620477594707813738107956440957803211619128696670627887064733041577933862555402708822");
      _weight[5] = ct("0.00478099155488135631829927873735610850636015195412822564225728586449440911997072816425107894901952503");
      _points[6] = ct("0.7900471558143551952024299464595864800685694943997857653563880504121078982496465547542056175539248754");
      _weight[6] = ct("0.008877010801018946117185025924342474510540324525513331403312263343710478394357406571414381506861644254");
      _points[7] = ct("0.7376361331966650834319952799565664239997149439085959623604215726217384164028452637066239693458780367");
      _weight[7] = ct("0.0149629346691495350546165739431368442535998577893856441120639179339871284732782984334631217432407532");
      _points[8] = ct("0.002224935452613053665891943069255750028001477799647205535966283412159514791582999304672758496614559806");
      _weight[8] = ct("0.02272123685713789434030881931524938582897026979966692028426173000267001400447472415900288947310363378");
      _points[9] = ct("0.6816345890584223343347584224654693833359846182784640936142748749084889259843441535034498170983533268");
      _weight[9] = ct("0.02331919963843795558856289001178667829714874513151429202299104727270255015570026749611235251715190262");
      _points[10] = ct("0.6228914041763613552769405578811627797744735067301256611232410007539390365503687846951176550441159124");
      _weight[10] = ct("0.03402821314534665504742300668651742375478680187207505350701851655484252062079811817240060870672024125");
      _points[11] = ct("0.5622970377001162863211472577185407563882405046536041909948441852501756198349145685895124686912743446");
      _weight[11] = ct("0.0469115578091407435119135971531759206211456446784961440590979776235609374016068710085926652077969101");
      _points[12] = ct("0.01168600396976784119585970645372596213506262775598593366556381424441620764977273721853043934271845157");
      _weight[12] = ct("0.05156450302852561733106515247255298513224662256829380501788829770758411341850704243518347036063351569");
      _points[13] = ct("0.5007700206965443044420384481447814267438751908957880531164770293158552605883981361981888199260713036");
      _weight[13] = ct("0.06149308156503639872799358294626381094725788384605781475174499580448305892704309824786744398644990349");
      _points[14] = ct("0.4392430280138590771400222586966484479281187490364367805606402616906997553927361513577773490887077744");
      _weight[14] = ct("0.07699630754163361492101271509761239393849942140377941862209472613642061946357771589251994659060800813");
      _points[15] = ct("0.02855661419100575078433773106991474313748189689392150746530677045392972682926951708896373028078886491");
      _weight[15] = ct("0.07738771704125657665401015992403564121662898479846865035804772254684527134060060366464554448623310962");
      _points[16] = ct("0.3786487375725983130255223763826594151980352418923449568992150385696141263998799737945727620052669868");
      _weight[16] = ct("0.09238041135649377632848298626350660907150032768554403014238224628817114536167770593375677111179164115");
      _points[17] = ct("0.05258483976432183438541473688430542352634574929408691847030569765319726770565337571037990112697772436");
      _weight[17] = ct("0.09871617322318441702547220169324858290886567033955491182963415229959747527921243023604411058331651761");
      _points[18] = ct("0.3199056905142705147196284477592600478118677860085346296646837337943071384012733116212835394981488244");
      _weight[18] = ct("0.1064140204072954464118267057242311153891075934728738476926957640344192610080730226508773305006220935");
      _points[19] = ct("0.08340690827115669342265715031914870712393513349406943625573196053823905284341476460595076132799896886");
      _weight[19] = ct("0.1144998723800464282627119569938636431402696445948437363201340620984458709118113476601838585175390686");
      _points[20] = ct("0.2639043660726025930345938310051340067520452082079640857559305951097397292053028574030042265001554412");
      _weight[20] = ct("0.1177809496131256963154687299353704343516432112100715198188912862742036151417784070771267150847230789");
      _points[21] = ct("0.1205557027005187819785359775783852711983906679686549822611192158244964090168065655430091806355845052");
      _weight[21] = ct("0.1241560818892750740513319197449305270799796663008705162149327212005494018765146066229283656762922961");
      _points[22] = ct("0.2114936819377605655182888616348370137102012365281441126857995265139411092227855461865391104829793346");
      _weight[22] = ct("0.1252073956815181771346127294596215849298975190508766297740178851158073346196145842747014091777703977");
      _points[23] = ct("0.1634681244020306820900081449797999118733278369358442810228438232040837540450435199855004039271963652");
      _weight[23] = ct("0.127596703251215007750895920412380631459376052890311743223279016365294469723170711769195350434667225");
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = ct("0.9906367009503252040186638786057673854869752103072860840212608497776729091053687956427078165918374823");
      _weight[0] = ct("0.000004302755109283992853390612984473905388520107606420784662639203221026015612852498093180719624771642562");
      _points[1] = ct("0.9749800156322561440080537979319428058608688920634258011461633746480601222229645349760627442122976592");
      _weight[1] = ct("0.00004762148988535869484357810517214382489037315091947178037681066416731762841027085559169817014266353776");
      _points[2] = ct("0.9526814786656007765604428427646471107128280724641542445681143547072496089803389360499312827713045016");
      _weight[2] = ct("0.0002286333412778897125360878868810677218018864957423887924835086482637072540841046732817968346432845905");
      _points[3] = ct("0.924042107591375088183860270299603460716277839946970651202689016561215748927105401944373367096390483");
      _weight[3] = ct("0.0007312150296955576038999427301489336061245571898075392624561063075884138374981784504825108417887624151");
      _points[4] = ct("0.8894615186907393745656503873951861823090345844702245018938672248913223057207012920176380233027947257");
      _weight[4] = ct("0.001827746097251135206530204407903268733428075081612346622935423986110324998010804043842916652568803827");
      _points[5] = ct("0.8494243882656275732290900248503280680907322871463571360374955681062300158144452515011786494799600204");
      _weight[5] = ct("0.003862047153394014885660554694647840111512019761959973821093873699280118779178659279767371558180975605");
      _points[6] = ct("0.8044924465194527143198696101390306595020306714115014471218090194399979166482091146097001614651134795");
      _weight[6] = ct("0.0072126346647461759192556190144110051057368556634141677806079889518799372758034872159931011806213675");
      _points[7] = ct("0.7552962978229513043581799301877042674961500659949106188709770331116463725525761120695916327062411829");
      _weight[7] = ct("0.0122400733886804262239638702260922483882869874656751208959231837292087749645032165693967788849201739");
      _points[8] = ct("0.7025264744308617327764735628652519707991262430777878489777111185176795447563520263257678166613306619");
      _weight[8] = ct("0.01922488755916925990273545208551839304413598984038948928740273847627349626429186204670641466309370472");
      _points[9] = ct("0.002060081929097883499230548771256641683030644135588557914779023101696836289714772146200530803150593157");
      _weight[9] = ct("0.02104584654991310894984769694957997264389234706488954830869366146363669643607673681276112765962831785");
      _points[10] = ct("0.6469237071357920937508249478501848787366871342377897238574359882034872352624041632877614982121503125");
      _weight[10] = ct("0.02830437637751160048700083768002130944295668211190091848676117122152547090095035944438706910338866601");
      _points[11] = ct("0.5892685115570647814127303043715788194113182486287723623739652905892272971097895471854805549415698537");
      _weight[11] = ct("0.03941749238248017695654904390708201200479612204684234083409815391209463268142666322461799547268657044");
      _points[12] = ct("0.01082268301359031138105841238638610741754419495014618572099843382803432892580641158216400725801855869");
      _weight[12] = ct("0.04785247342860094090713410636696065372543581105275627351894179124877984338090126845647482492287693387");
      _points[13] = ct("0.5303702240359852173396065663591384210267634451500462472121109299789877460508376633515105839528377266");
      _weight[13] = ct("0.05226654254025416026230055459765768735408748982342137352210401586284879927470555960353573242755475313");
      _points[14] = ct("0.4710556365226797192363701668337433453652680273700752120149035736826756466148957367682835979522326213");
      _weight[14] = ct("0.06630287633400960740664405539791593674018482270105306573866739446952101295678770123011621440596649791");
      _points[15] = ct("0.02645812972355433281261111502741448762381582930484579072074942380857494497686847934716860456297192619");
      _weight[15] = ct("0.07206284363820171160165937570261028877417915555039796312170958415818099948789627440800921583584439041");
      _points[16] = ct("0.4121573881255929482897040156029304602803026810481251319022819080784439249416642297798100544798503957");
      _weight[16] = ct("0.08074110304100429667322390015353026479458249971802668553808949061734867458681218551998618063433486086");
      _points[17] = ct("0.04875046551971594256626048405495149863872650262007427692289050523464258580283035772642693653318980664");
      _weight[17] = ct("0.09238508110486277697046072106183462307349301111542269581192066431251586682339655452939053211823346898");
      _points[18] = ct("0.3545022754336092801330830225246756319748235396671835065241829375954950971669723822236925390213555707");
      _weight[18] = ct("0.09460303776621984255911428340425176633044568964941211415406548859126157076222722306525009261263870048");
      _points[19] = ct("0.2988996452854616817472628058730197227314433867599336194504840923830631129196201993067222862706236927");
      _weight[19] = ct("0.106788917328849938310343580342129676248041289822079930729453242089902642978743856332781087264853323");
      _points[20] = ct("0.07738719047941864058844549035651095463419321093462887741820043230753007046145151599424606907648132144");
      _weight[20] = ct("0.1078731206753558255699920516316999773845920194453412445398199388813993235893370279142238853057140305");
      _points[21] = ct("0.2461300326799557368501708657724630388374281519477683919406243379905396093914799829014978822920175362");
      _weight[21] = ct("0.1161699062528098563285204629158808188551384494639865932612070092262711343486676737524132437966100165");
      _points[22] = ct("0.1119664131211797080591453118900233568411335618341266482302911307568798211658937390561142794026721151");
      _weight[22] = ct("0.1179603120946719806730046151597300929107578524479463578273411646787924756993067021805470346187081039");
      _points[23] = ct("0.1969342031254723248318136513226723837261617920675631369200407885476768048090584724200227907109775708");
      _weight[23] = ct("0.1216929757207637586818931039746277834402913288184501947402046698604718770716389339788734360764541048");
      _points[24] = ct("0.1520027529734087162506287551943575708665665516914832278052044133827396241518816510167155210118609714");
      _weight[24] = ct("0.1224872666186146488533662443240610951691534977442791141723136190727891953370651772473494342557863352");
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = ct("0.9913035622385110788790336653178278306638685473029327049342568556768750779226166802910464862467032347");
      _weight[0] = ct("0.000003448114359757205756745360166489525198386376580749197638121869912495215206262890112928773755959767302");
      _points[1] = ct("0.9767531733280232298662661702683429698796977567485282341214009937436918106009940247102813503324814623");
      _weight[1] = ct("0.00003822053883255387900554746410523715204390828917060415678743895044994612478539092658170443346156339384");
      _points[2] = ct("0.9560108839274215742662198697342406595278034313234337217490396871934265900098665899697971229408821363");
      _weight[2] = ct("0.0001839034851575356489389594530597318328668080169779138264875530228689413045229252063322910022564475327");
      _points[3] = ct("0.9293359602715748334061432334478793404990512001092018428658048417839597361733846070929979731803178747");
      _weight[3] = ct("0.0005898711555596490013159173847175552002172211131197603246704873932959527131487834703954937504716351496");
      _points[4] = ct("0.8970739084211864094916125355818095043974285476361644489211453364655049867582275024468773277447054481");
      _weight[4] = ct("0.001479803510496533483770404222388761836968823110573963984604554556290327130157655956042477051021174593");
      _points[5] = ct("0.8596446098087925495341476044048610631434683111426290228292610152787315792738718461682721701424965136");
      _weight[5] = ct("0.003140570491033566324169178308200812903593777775611657950464043256177915220403707237044709370474184913");
      _points[6] = ct("0.8175357317097885446226654263638273500789689214285257860423082060382710028297478571779544782286374496");
      _weight[6] = ct("0.005895624378770345168835737990923267314213457921731405554223994080869703797491624920386576159748071496");
      _points[7] = ct("0.7712960967780431853930398083442015153386640842171062566103950893923844867230098706227918714691709195");
      _weight[7] = ct("0.0100652911435293349214185972039361728837965416629534978495957715958597173303805799754230918997120829");
      _points[8] = ct("0.7215284411637628205782811219801685752763893687252454146020804663752143651812554588012584507935377958");
      _weight[8] = ct("0.01591836500223050457908558597913063177486827168378060246011515511359787919282859563519099594101698746");
      _points[9] = ct("0.00191289717110327028836078524521752905378221643873610211392586422613620030638054085761591113838798103");
      _weight[9] = ct("0.01954892722439377291610145584289408938746223353894233403593192849234043653992666165122219128617863008");
      _points[10] = ct("0.6688815237617270248821108145549645861198322343286327852974929404210073467991331540955757170564355139");
      _weight[10] = ct("0.023620926866716590429781746080458886913912057392116175755472052610577816983937979347311540801052264");
      _points[11] = ct("0.6140416543163906865961035725129271962910179605530973598443859211090243690612314978954036450474195975");
      _weight[11] = ct("0.03318912383294029289365821071167045100713239775208250096989712764224744184932990528332463294336165887");
      _points[12] = ct("0.5577237395010012764647206840844501727253666372843105914449844804197466442981144131225215846683212315");
      _weight[12] = ct("0.0444526422478849071887171168971656648124189504190488385065799238682532085490823182384757209786707533");
      _points[13] = ct("0.01005154895905705829101837163776007839887286894178746427295654042900506836125523943248910412169749112");
      _weight[13] = ct("0.04452377548054358057693152306974293779850488015842524187316405913445811445216693334515560304563508699");
      _points[14] = ct("0.5006619595031362884856902687713503167221436363552477393781189311589046478109453733251474626310385349");
      _weight[14] = ct("0.05703475748022071828509619466256332516846561787218921379234532042280759325691321139002913907127018233");
      _points[15] = ct("0.02458221593567344139959951442945173604525227542008597683706536629066562897106555863890846130241857954");
      _weight[15] = ct("0.06725495107308428165273852693974342265312725376252435168146700914145779601982415440317967786025974281");
      _points[16] = ct("0.4436001949306515828559333823823612392858936114867615745808688805378474705116095676777622646630552513");
      _weight[16] = ct("0.07035322704434977742682228930847787787019711543667177558572243193480196890984850180718542235275479292");
      _points[17] = ct("0.3872823280574549937989445036865958828972832166536714882484665313850184327167229220473239233584617594");
      _weight[17] = ct("0.08364408140790913806503136264243828949700520235558282644016434999787678203843397466411902861456776414");
      _points[18] = ct("0.04531874608969985141125939892871352392582349070041744450306418403609338292543286780416369042306744593");
      _weight[18] = ct("0.08660682167204660370080193943728064352793416035738853172340408852080310732523056866657018900396374964");
      _points[19] = ct("0.332442544464647897764370591677219362088665986717434604231536379957097306038335636912411521157132378");
      _weight[19] = ct("0.09600780433395996459611005163022683822666687189995853795269920650589609941099345779579700299706512646");
      _points[20] = ct("0.07199121113320913897952303263315337990844978682594543098496219654933140959926243370975522920210941871");
      _weight[20] = ct("0.1017277570591432847348180174383227213260284916100920427592935367507284866022929405674356028872702434");
      _points[21] = ct("0.2797957613012491859655855463898480988672060062249520276103935539643102128193564469419623506479628483");
      _weight[21] = ct("0.106474774156680812568561370518019168161628546270578460416498320073426923055252814931939825477870784");
      _points[22] = ct("0.1042519922933739349627321569155201289060616104436747962912852388186208673319729357666535825336812708");
      _weight[22] = ct("0.1120761181427334190032010245158099690638256138925814165287686360873920886305053666402815536031124781");
      _points[23] = ct("0.23002830680682207126412919932716909390208658580572414780253225469621533437570891507880804871836099");
      _weight[23] = ct("0.1140844639890417668241464892471366407764480789831449930204960242372119155349985796101274929370035803");
      _points[24] = ct("0.1416805541841085939424499105077162112269282743432822292773459439118180445686557930664348991933582934");
      _weight[24] = ct("0.117447028575268886080283905928003969128044025940981427337594705298274644106623945515582721239819385");
      _points[25] = ct("0.1837889724621079951285773493909411733485119513609893231234408186596165165503607848643038915766770985");
      _weight[25] = ct("0.1179710549264457561782354350967497775907646397405245096492474927754560320390464932600093231430017935");
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = ct("0.9919016921030858633563363794429817847379787714779279595620322545994397707381328467786508349830459968");
      _weight[0] = ct("0.000002785016388572537705690681609177755671609902607460882831309119306006182467890894946863671115671403669");
      _points[1] = ct("0.9783447246593427423009234194577171124968296718365230530311186830121782128183606331424343744729291301");
      _weight[1] = ct("0.00003091244161938983408314671147246492772583236893784015618585479755757538573429388679225037321883934137");
      _points[2] = ct("0.9590024350798769967347900672867432755261033514982111722784661932934780135998830463243946849777047705");
      _weight[2] = ct("0.0001490333111707578435026953455921951778699719566794053596354648989169784384847030615809371744890831862");
      _points[3] = ct("0.9340992449559257825950427906558732935953068512720009591535099193403502312605076880588140292621747714");
      _weight[3] = ct("0.0004792697453785258073340451419757222154191164076444721019392392800535122603874466076414496344511966982");
      _points[4] = ct("0.9039353597784711070157033597360474229931818363030729923680719044761889533438408210305605660116515178");
      _weight[4] = ct("0.00120624834619181937137603199441914360465912857765792171269659313799452594208005653184665745154759608");
      _points[5] = ct("0.8688762741806575564667761401536189780901445930466251209065034762678430393181039572235882829647519408");
      _weight[5] = ct("0.002570049171197175931361063941668867313971915134023462330557089030766363955154108296199489949582894189");
      _points[6] = ct("0.8293472971383944771598355049274250058834269029021771996399619672863673163568105696112267907482074549");
      _weight[6] = ct("0.004846921295440348694709177690869156229797846446689132658058902702383248719112744082435662948118295653");
      _points[7] = ct("0.7858281353779031227352117058077111616012152440575051383618183698144842122819671305036791359257553671");
      _weight[7] = ct("0.008319259767931359303359612245105396666555498914945895238762583811716697454039472166862699670678373469");
      _points[8] = ct("0.7388469893624735910922449829548469590275526861901167534999751484805700903189045500413201466516638816");
      _weight[8] = ct("0.01323785353886628364655051789746491666869904914948154796436523205630295604837132271358219443071008338");
      _points[9] = ct("0.001780943143570460885558792886611446878630789847066000390270576459560516274569752479856156412462092889");
      _weight[9] = ct("0.01820603118871048582942728891063964187212465208682135554645716213359324348541984930031410535990257893");
      _points[10] = ct("0.6889741108323418280816571990178261232404686847403558539490499437753002791024731150404667801081009793");
      _weight[10] = ct("0.01978061738005189821681119732188615744078771959445292827828842468044747984641395372722160776435764143");
      _points[11] = ct("0.6368148674104017419630307715995676902754314764405299930956289867406713625910027046038473059912601229");
      _weight[11] = ct("0.02801276453548874808009747976668363223186535565759695290998544442635238085147611006105071688900964825");
      _points[12] = ct("0.5830023879264334250663902804376328580572440100955175317865653839064321210069269191484571926567993637");
      _weight[12] = ct("0.03785356234773460919311606411888319543129071813262592167579519593720136903085223560528795008414460997");
      _points[13] = ct("0.009359937258201115028705457829872668484510565995513908264444078497284370515863726402824600698033502681");
      _weight[13] = ct("0.04152785829844875717943172756938377186734953754235234311353404373544544228087795063232762728857180007");
      _points[14] = ct("0.528189873835532934021657722740027508548208196505456013409035767085006436526769095345534024824517463");
      _weight[14] = ct("0.04905440341529198363865576676516031676767482097727449018102715309052236173245485358847778720174353105");
      _points[15] = ct("0.4730426684520476703602592878224296830904178855899382298873897364315299239631836659193743186739257835");
      _weight[15] = ct("0.06119194926537683569355451543997997296618926203848359030101583951544914289940470883109383512474600588");
      _points[16] = ct("0.02289854263907702050395291455569141311738970919189788652592377127458263144110401632397331449331526483");
      _weight[16] = ct("0.06290119746144746482802734864589386618833347317601423057015638714495873048300389063863893761442406516");
      _points[17] = ct("0.4182301795447049734724846472391014243667560340702901180312848174318171551123809662146069605014604107");
      _weight[17] = ct("0.07367865526297174418825984472902459506331849312468798056148539468443217520004723844738101147944550983");
      _points[18] = ct("0.04223546938345160520274859443846427423042665304287693049731721062888330792747246995094108230190228905");
      _weight[18] = ct("0.08132436136446986193739170532758880791397877196523611071292546215873628519179693987936952305884224755");
      _points[19] = ct("0.3644177529904574950557756096570565098512806680305704179066355757972527488832137323378563137368606048");
      _weight[19] = ct("0.08579121209195122447243328295236127860714191311346550727152062805058661851930724613643640236403073954");
      _points[20] = ct("0.06713636929901124659578390479055933650185406663414917887488142333093823351973104095111454943659991062");
      _weight[20] = ct("0.09603082810201882415311963795104748870818268807470347887502846531247874858577708795396729820518612173");
      _points[21] = ct("0.3122585959444232262993504592262882061838804975738422821976444443102486079512087157897605571708467093");
      _weight[21] = ct("0.09671552705946981898751774104684219583762712809680328375846161035397016840278817983469759130134249606");
      _points[22] = ct("0.2623858474559273881160617913883325511276096577994481672721349608546023050783281843153256814191171124");
      _weight[22] = ct("0.1056050230492805119709298866476760648000510141882851923408616735140549390641398474028584341314146003");
      _points[23] = ct("0.0972990698736721763753164344064238004527912129365851467031032541694671325752127600065236562459329176");
      _weight[23] = ct("0.1065088544552712310709129163765736239560946416142489520312256996469840584797893553601506329292924869");
      _points[24] = ct("0.2154048926944543171651652614570632101946667733364492996249967765409568376782797064089297968838438259");
      _weight[24] = ct("0.1116474563280293741109965065113128931866832316104691669164509221561199637581464430175629066034208639");
      _points[25] = ct("0.1323574675652328254198509862867790334541690279550368666466192187710882991061076711351679865215991105");
      _weight[25] = ct("0.1125263755484285883365205837252928997215348671664386328271427347062622899654077798856335746521576459");
      _points[26] = ct("0.1718860139720701680722426766544501251353813244874586832784733002806207478525176577679137330683948481");
      _weight[26] = ct("0.1141343235447071384761478578769258902127350763147060770569388232507400711703976247938788173159387682");
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = ct("0.9924402145386934818494062074608256710512573670377708826247066201588500246796209226609635064997675722");
      _weight[0] = ct("0.000002265958598962605196822743329763905246915735782078382024974317229330583473761254873410776872767826297");
      _points[1] = ct("0.9797785960640749944438190057145039152741074495249043615408383040614782568644584229549468171687733794");
      _weight[1] = ct("0.00002518191216312457714080057893628203062066238548219866715788280885486052172769692157029551682300980055");
      _points[2] = ct("0.9617001463459457899861099885807198305217759101371616261805924955343739972380075801124042375869170113");
      _weight[2] = ct("0.0001216212208108765183086984702980407460962842267066259167107608532532670446458238411718198672773186945");
      _points[3] = ct("0.9384000294379855101586491825366150982471974093849676442221321111107915020236599462447922597108121458");
      _weight[3] = ct("0.0003920317051831638475926050565561955006834349747351228816020734233503026528227612365401820950255750158");
      _points[4] = ct("0.9101403003668531082536780547017155187065153962208111283714408048069939649812595801927679940070241872");
      _weight[4] = ct("0.0009895645441188801027588830624824366661410419145577967624579589789470698427514257565112370532368473272");
      _points[5] = ct("0.8772405436497879573891723774128885767103809571602310600748670880625265196548463651442992083091059555");
      _weight[5] = ct("0.002115799069802587276112448389274307711426310369019676527371289223126989553627023040825265918413245453");
      _points[6] = ct("0.8400732837976637417846403075634608381826446882830863254766087793874579013383417858472750832694708386");
      _weight[6] = ct("0.00400676996382688876369694147974047973154866283886113397519166712993033774666693888227342383322420845");
      _points[7] = ct("0.7990595276685624868995636153621286979861878231866964890727280422713114601123812756416012428130639633");
      _weight[7] = ct("0.006910213443566888748466176890723625292539468755284525612640801075874152045527474588594349300760027866");
      _points[8] = ct("0.7546639187593059817872803597557685898853275116792760713753923349366380454793941649397924902062412319");
      _weight[8] = ct("0.01105609190631242552105479324746823601234418177691168238419979938124926144067391591450784016492233245");
      _points[9] = ct("0.7073894438877855706285149361350268987939100593278504681962772015788814614262279003604123878408133833");
      _weight[9] = ct("0.01662340411686909034142413466450566565032418406426186662411255986983551839951256909951884474445425856");
      _points[10] = ct("0.001662188334010344257891461771211848609193102668366344886339851471823721411659306650434237708070485101");
      _weight[10] = ct("0.01699675331355490717411502137389388500094524603859825757063307660350119689582330207269535543572269786");
      _points[11] = ct("0.6577717217542247768084005053389194499315878203674783143278934979688418886464254544545346213089894437");
      _weight[11] = ct("0.02370693220667251758884754554263331205128739505850822623279313400923071925972365938987128520658945004");
      _points[12] = ct("0.6063729282730147073480576391241726828720982008190425665943509503596611618340212969981896009477717553");
      _weight[12] = ct("0.03228783996502644895650898643668602554416833029918697762571085207553801460068086760948486028196731261");
      _points[13] = ct("0.00873728447239214139065712242090646257020090445870447567282855490448705888193735202767834234353241308");
      _weight[13] = ct("0.0388221611401857501373760319181405664443831529949018732380163213415938798961715598697675365133475528");
      _points[14] = ct("0.5537754238684313594769240249501645635328248608561576380556038385473320553947237200652050810344918645");
      _weight[14] = ct("0.04221188066485391017179843621910132663247325582481799896194480286103572326145048899412823414104578068");
      _points[15] = ct("0.500575153441983623093869111019478966255819651560523227417590738918084787952706570511471287773556073");
      _weight[15] = ct("0.05317840198085355889436749877935944937229816786481312186261562562730237943218926093884454876384009258");
      _points[16] = ct("0.02138176483568373963034271336149516841266556866258386679039806082475071487814678080051058192488994791");
      _weight[16] = ct("0.05894766595670255670963440873302383759119498225513535332185369018894998992852923391583154766651460418");
      _points[17] = ct("0.4473748931198531751312384976638757267785856330538905813203215779969809276248509403699505273214443105");
      _weight[17] = ct("0.06474239890218384617641579074397429560281200820034847743486255276201782999215045306318422919140676195");
      _points[18] = ct("0.3947774199723313116769052107500062552907725427703361632104188629638226399349568702184562114618754642");
      _weight[18] = ct("0.0763306503770435867799217376007081375452687618911842652302001273146809417858403010269360961540654852");
      _points[19] = ct("0.03945520864053971121154986277226662685144080719364934557672928701141422590945414778597456317172456995");
      _weight[19] = ct("0.0764867860250257028448602879104010451834884717881588252543887775929982012360821861240101576752354614");
      _points[20] = ct("0.3433786819261913150681460413651973878949845823554863178403679470149846273838432659226376928927518381");
      _weight[20] = ct("0.08727159968574142456653607461431136580558843981507980115301946075240580150496406025982314095123393874");
      _points[21] = ct("0.06275318712545885999983743626481590179256400882623205243754304532648865470273322717790632337377314921");
      _weight[21] = ct("0.09074930386242807574850384737192231428927990682057845126440329212535996959549697864971331918463330868");
      _points[22] = ct("0.2937610451613514326972750749668948134956539051387656916985961515253610703405985442498156612536971559");
      _weight[22] = ct("0.09683723892284496243133400305982014503220595603741460800960591274877472218951050937958199531634003946");
      _points[23] = ct("0.09101180937213291493037786336117976907264810765721540819421996451301742291635988315532695530375611578");
      _weight[23] = ct("0.1012555974889907126108460496940755561934638347853673107289657786337559632509483599958359377654219545");
      _points[24] = ct("0.2464866954363530558083411840821592805659340568933689671152241449226482215610440148989074112781467142");
      _weight[24] = ct("0.1042939762323390317306252800023900820145384876648703530515689827183667386399613716670604816775598012");
      _points[25] = ct("0.1239109225098248943986786571525365727357700121269974363446057563225513757008341619263478384404697343");
      _weight[25] = ct("0.1077593224554183504441506568716594810393974684605908180762875165119213414701629886814347926818068901");
      _points[26] = ct("0.2020912680468832554423969706448920337400445843902748221160223851312616827201318751974338594370225009");
      _weight[26] = ct("0.1089584330514553833792479007201945848483678110902207242804925059301547571776537296722336644764227275");
      _points[27] = ct("0.161077778503025586034483484317896992168941561016791412920534016160288076683236712455481216991357141");
      _weight[27] = ct("0.1102534472607597186864914711577228898952005094019551823025011564740940733845646315084537049532027231");
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = ct("0.9929267893183628062269525350662871775653492285199651525986086819393629175725051227057650509336396086");
      _weight[0] = ct("0.000001856283772081021646463917006645502930051466535420769785785415393719988368277496916640181442415746151");
      _points[1] = ct("0.9810749076596256309006437136691611689533352449026726879855908015035858117277035374554302084570421548");
      _weight[1] = ct("0.00002065193379483673723520305410719094953030456381599065092914301994814430006275832864617928309149435563");
      _points[2] = ct("0.9641411217247745946828870542493190904639324758002400985928337168007851931895173178552116298526335159");
      _weight[2] = ct("0.00009990263394095784408772527008183937133715876054979511341138744323762818463231844388684177314495142668");
      _points[3] = ct("0.9422958895903871330495337162486475572840128154973285809341967704118304237104033071590241332038178755");
      _weight[3] = ct("0.0003227041908195134456269653088472861986621444725248385753566297569081862963005760178204697655072584826");
      _points[4] = ct("0.9157689585742375160527209731782209778138377544703193428562270193431316521163635958472103988871596499");
      _weight[4] = ct("0.0008167123025929537791590779222624889046680614565866252043480296283513012023263276872665424708570029282");
      _points[5] = ct("0.8848409513746070720478295357950882608136439751437339020150931391920340490511768348960488253412100603");
      _weight[5] = ct("0.001751756104040543812056707746636424489524091405182527252251987207967076087908850752406343551247101325");
      _points[6] = ct("0.8498394858283586592068606159884429949323530710404946731082134176863686453602964965002298383195124693");
      _weight[6] = ct("0.003329732099534716525904959471022450189067525736458400646569973558736059350650571180620965956491897284");
      _points[7] = ct("0.8111354807272444642075213249964705278931214853178016839227908886334439887655616436591190604415518726");
      _weight[7] = ct("0.005767322345572894815450450032797290470663786874293720580846143468974332971619800222681111399152007128");
      _points[8] = ct("0.7691391534023484768538220758922565584262388759203507506806944987604814945430447384460512918718215989");
      _weight[8] = ct("0.009272946255348385389541458548765573070689017484996409398510543999367015481576466379271350142341662023");
      _points[9] = ct("0.7242956444888707043560871701745064455538860059199548248154436973480104217103385414072838784155034141");
      _weight[9] = ct("0.01402009861333367145022482741179595153263656328537495601342898943949469294535231397346053110908384423");
      _points[10] = ct("0.001554929031256665420006752942495427838027482475136930592211048929383071266978688100380198645182484977");
      _weight[10] = ct("0.01590395547416049373084283970446254939586728862730454297894007025395012962095073015384060063814125139");
      _points[11] = ct("0.6770802877492443573266568704467015351806311769675395683120767898431579951848013577283510561777889766");
      _weight[11] = ct("0.02011976844683497331844387739702727260430369510653869789575590786230420302940347608481479643127976595");
      _points[12] = ct("0.627993565916526262182013707529617129394893152972341580368269585709554733044579996298702311470791131");
      _weight[12] = ct("0.02759491436298458106580574784196132821947800084432000401014943541800534280281110554230420725253142823");
      _points[13] = ct("0.5775558026309174452553151152733625043245901657653645490736680818890881281137921627962913404073228691");
      _weight[13] = ct("0.03635995684886709788958406007756343059353121747834284301899201980737194866787438745763436873700570147");
      _points[14] = ct("0.008174723674418611559103865544392948102157036888087052346790286307717131377449463638956498141460460573");
      _weight[14] = ct("0.03637065893665729571075344593916540199657241009646385824767892047382103100320528018288122982250320447");
      _points[15] = ct("0.5263016453375968201653794928636041556860229130020205964062744256271705159139407454117566470052847889");
      _weight[15] = ct("0.04620793050943086619045368766579074375745787430897608290923105422272112793759027659747296191028447982");
      _points[16] = ct("0.02001057277537863729118447337248115231454020584682554184760410583574379386658825873304229289136911038");
      _weight[16] = ct("0.05534795630399538850185456211297123893344168142281776267574745603114279671978481699568799512634590668");
      _points[17] = ct("0.4747743970009873561917723160531700205066921026924445193997049795210527057905182697247116916931894192");
      _weight[17] = ct("0.05680734250845563585288858316504839656434131896796498476261765390734591853152656637737926312889479053");
      _points[18] = ct("0.4235202564181097995474113146850489926682673472663289206460620937489498826422878291086158784870130803");
      _weight[18] = ct("0.06770995846565736534187178620911510510981331439007344136937490702077560334537629961218632220124974517");
      _points[19] = ct("0.0369396752916812645959209072886222502266940175506431296353140616816413196565410066864982546882814814");
      _weight[19] = ct("0.07204878416716868669494228779171087877055190291879777468441869777323207283284792884162808840671618476");
      _points[20] = ct("0.3730825280293374465690792859201248695856590531186829500141964698180241770761618137437466075148481282");
      _weight[20] = ct("0.07836975770978971115427402907838920161802800682518189208674079546857625920569703907869991396907702626");
      _points[21] = ct("0.05878290626605055885840865218087174046495481944251207998810378852091522787940776630512797824354282017");
      _weight[21] = ct("0.08585111618606221894547223897051276062455717563898810682264732561837504271642097505325204467579434545");
      _points[22] = ct("0.3239958625177051466248603397041584055661175398120534880219141687715302778163413540837796763370016129");
      _weight[22] = ct("0.08817225630680597612003660163949371818078447184949948235473102539086671161349867433599036467547766318");
      _points[23] = ct("0.08530880093329033563236471055857523621058808223719875374718841141972960523222133992450790818395778101");
      _weight[23] = ct("0.09630795187080586094841976728359810551551172932908124410591486740160430723013263344522700978629878583");
      _points[24] = ct("0.2767805891942973708577879729031042713879054366854930668603078587622459594790114634625651543742909842");
      _weight[24] = ct("0.09647238670452894868290795505134096581869886645007816822694179149988004663996108299166340298176479467");
      _points[25] = ct("0.2319372002063364238357113561581231468239578677677663627198771197540715838680988610437419882956982289");
      _weight[25] = ct("0.1026382437620365051961261302742550581710573153809810112602447887157691824281457449099765356526344903");
      _points[26] = ct("0.1162362048829853425076721375397609970107436875069462593303916880434153281948281248095660108756043849");
      _weight[26] = ct("0.1031676988619209181710558830873856413004363444827527678541306109133352094102382641980490562172708412");
      _points[27] = ct("0.1899410449901282865692379014213471630254082529921559753456718118947261873986526053764810399620158524");
      _weight[27] = ct("0.1060973443529894398202373165023237945259903765282338008207222574643863851930328256989138033717840287");
      _points[28] = ct("0.1512372911316014780919207790227039606491053931442636445013472589695144451175544237584698175481308518");
      _weight[28] = ct("0.1063816687914308151764286948578946009532016371806181830429151351514918575960369656164444521272090252");
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = ct("0.9933678849972890218242967429754756290348422812012610131690790938192644595723658942993255322380362377");
      _weight[0] = ct("0.000001530435692303559679202880600194069095291373243359882366029366110361351387216726316141966166113640561");
      _points[1] = ct("0.9822506759732043911736678171948047795906753507549646731542099473217074609302325111913020773007465754");
      _weight[1] = ct("0.00001704378210976846570170738949485625046237981076825018201228716265008270161857594461594414931549012417");
      _points[2] = ct("0.966356811610316331681829740124114472013698341152903565974034839219633588997916371133226198626933423");
      _weight[2] = ct("0.00008256807322596642712675172300945914195274209200047916147521082294370472442789555182791610679371970876");
      _points[3] = ct("0.9458357764492203337808419002032066885955503076575948450871012659368499041349175484945986129340774309");
      _weight[3] = ct("0.0002672199620663056472135919658807958654052121724338065121842860076057742788764139847141623009890424742");
      _points[4] = ct("0.9208898151139505953144638557329905235774970627249343559514095081325116537677830281076745417185029103");
      _weight[4] = ct("0.000677900876045822301748513097607136324210204873984589460746651754413842077422919562829610184363090602");
      _points[5] = ct("0.891766318682024711351680965262570788260699668723203291111539656543622803240979767532198330039144181");
      _weight[5] = ct("0.001458186687285437575395832778065189046874964252128656421832651017529503747672066055109671092349859249");
      _points[6] = ct("0.8587545173866958177170051992400022157663057683841349552780806326443491728626503313132174680442865727");
      _weight[6] = ct("0.002781045433058290735823690629828006775647419013227642282327332200732301717026140608010860330831076808");
      _points[7] = ct("0.8221823987382739350146679257725087410887946678055925816102530058347225710144385002987812579603934522");
      _weight[7] = ct("0.004835687651116839589207388506661792798688732351920846841568469474501450058791552883867826144653376215");
      _points[8] = ct("0.7824133817283033117351654063389710102986058216354587982007414417461506029482383411221290125361309735");
      _weight[8] = ct("0.00780951217924887175492555552277335297710152074877213295106913265321637430098410393345892760990754618");
      _points[9] = ct("0.7398426798885768781476865343971963892441993313179320887011131454876353948716056468750647185101546415");
      _weight[9] = ct("0.01186669231590524206744646319730034674869664293542161685991368345216694946396047626719698432221560565");
      _points[10] = ct("0.00145772783390650359258939349065175917847200065310815600213746054046489330060751964957340354200936242");
      _weight[10] = ct("0.01491315901155340446212604717451004862856152600028923881167748393402243077917276774270736813868227456");
      _points[11] = ct("0.6948933626480090846660737470948052491622820351678518066893206318036909102531481156845209039989461428");
      _weight[11] = ct("0.01712539544532892132744625893725802414621796017291600334410496954630813410240948250791722805919453726");
      _points[12] = ct("0.6480121455331503208705669145595995298479983344533984988806949082338790572395468688493909284724971216");
      _weight[12] = ct("0.02363589773545442376826921873044047832436878049349748821622300008932827072699686486257968668165021934");
      _points[13] = ct("0.5996649478704976551018373593654268159180810688501359806278139203431894217253568566355352104940005754");
      _weight[13] = ct("0.03136191451975259960451311523450739540697146877711414235255154582511143225744543683656798934447392143");
      _points[14] = ct("0.007664767864806790652510700943612758896490081250185334891650651104295876629089337085527195459046516929");
      _weight[14] = ct("0.03414270443637351996552524689520019651518918125519284231276373992492543701158246339820206496302363977");
      _points[15] = ct("0.5503322608308270557491787984340267743359031321325234333208060314419409333934168725488976010462177834");
      _weight[15] = ct("0.04016730562047342836983353438926568287679859907672033401806590163348537364732569259646213424815701809");
      _points[16] = ct("0.5005043712628964789717639236953963031984790603234627725767742098965776650636318606390262908257531406");
      _weight[16] = ct("0.04980994243944509670193186882596801360805780285331470412300413488400333743558037202503741391583451747");
      _points[17] = ct("0.0187669462746132244982993301440387916639043908855580554548242427097167553740409721090435065543842118");
      _weight[17] = ct("0.05206201194506336946652736896631086980047779181323752545621446604559586912360486216640464809850709849");
      _points[18] = ct("0.4506764885015598873510899584766044215966881241176557888841618510954362349594222860652999748365539745");
      _weight[18] = ct("0.05994396892391193201878777221886819034342923382714188936785401233706685684647954234713000168528380992");
      _points[19] = ct("0.0346564195659897349491044844339792828709394875646473158245898065449187036414264888486758751330533654");
      _weight[19] = ct("0.06797009893843161497359823823660113226698137894136207676183867733482609286998692739265881943481490805");
      _points[20] = ct("0.4013438224374185454639967766405275317142917022652449466333117794386845094513689829895546561946178324");
      _weight[20] = ct("0.07013099742401690013591360102740147731104180921542862503107396753093730582466635836943847279118991919");
      _points[21] = ct("0.3529966616853502786154550912575915364162723119239058502674939729539710162974658936315002971501451098");
      _weight[21] = ct("0.07986001209119680090675229090743842319473780511267993616803209051048773098007336509737306748332389762");
      _points[22] = ct("0.05517557808804576973579901521230398806718249322486323341936662310406570235218106947237236467595813226");
      _weight[22] = ct("0.08130576744926203003727351913523010351524516224444640024452683616344850950559158640251626220781181102");
      _points[23] = ct("0.3061155007205121813665886906735831563842230803361353335661166203013891520931517709134796871698281319");
      _weight[23] = ct("0.08857497394178217650471618391876129842077745883814547442007841660655316881345758283854245886546129746");
      _points[24] = ct("0.080120567112325535828402317065571442809308606707266764109231947703747384584007510546030547316032919");
      _weight[24] = ct("0.09165404412254467064066511550040554298695455034951684961821682398973282747671045386111241554317353069");
      _points[25] = ct("0.2611662643784974751033364418861637841052167095569197616325843294380357783689767519724808893027702637");
      _weight[25] = ct("0.0957084022537584356706622834178274651556869909900460229728119906274110824605147609337241300199247589");
      _points[26] = ct("0.1092434970626521088746731873448846222774206414347470411530922780957733620062425548835010678261700806");
      _weight[26] = ct("0.09876432908795536536032697004673551868704851460757200597881816491701736581480140253736911574432935214");
      _points[27] = ct("0.2185956771518845796303573075738189314253271962040366483829882206456924780212396799680806333911303056");
      _weight[27] = ct("0.1007186117616301279878554305959197341608245889317283916519828674052671542386577064173516389649996562");
      _points[28] = ct("0.1422549415999572144877609341053898829708731999301570680786197421573754663025852228845161221643511937");
      _weight[28] = ct("0.1025585393150491257467352768657020962566165514453482039316467571702515714029648271882670353598411089");
      _points[29] = ct("0.1788268232673087628783417984246983287220358061763450736249227518897393446664815732877331590542564701");
      _weight[29] = ct("0.1031278694745945415596052946177605117292110687637337979963517529456830375931435175722210364638955055");
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = ct("0.9937689943617638927613642550978404132193052847562085323183044817501866272149029814389654785747097187");
      _weight[0] = ct("0.000001269380626764678675373195326975758127251201208308023241385711948424755100169194183552495211808790648");
      _points[1] = ct("0.9833203701304175412485368480405225262637155639849370527489909821657295035574559858424684689497338574");
      _weight[1] = ct("0.00001414938875337667805842756312550972005132023758238594466807507236888151577830837913556555707754238027");
      _points[2] = ct("0.9683740118091604909480627251752021631877538352896943636065161160288890490739816800738966445710808703");
      _weight[2] = ct("0.00006863667359946888101889453121545292318816146796189038823923159828041558018051222520524730639664121677");
      _points[3] = ct("0.9490615100934992658665533661080479770940064242550734057590726835551016985542145903458461174891410266");
      _weight[3] = ct("0.0002225184113616753332835954161816580608307938220209914664726703106957494701509062705922833939390795155");
      _points[4] = ct("0.9255615822969551781356416726446810501492182917520502742877697614194101962468919439115832052932058982");
      _weight[4] = ct("0.0005657189666091238390709933068514304280659458878866494461459971250893209363885838891569990679795923031");
      _points[5] = ct("0.8980931407181669215572452752900580046388620566439707644527159091729569427638691092610084112862033889");
      _weight[5] = ct("0.001220041621260954623648068103750166494687433751337417055023692920392477150831347375208885934591540607");
      _points[6] = ct("0.8669124518396082568693596616154962977199040720951216992805820343587833819211852462891270723734944261");
      _weight[6] = ct("0.002333953705311331245464177602173047072288137060715168141773548841446522030992039657050969440578857492");
      _points[7] = ct("0.8323105489456515383744404260031629487070666431913964811955248376360356215462432754715923979789363373");
      _weight[7] = ct("0.004072567301324925286978191910109165210998809923518336725405684136878371982652710248244288816607680173");
      _points[8] = ct("0.7946104527758169326169679366928319864361859757363904011714581588637172599413472813223525772026136789");
      _weight[8] = ct("0.006603470707394316985994280362337310811861259335771870656920474608040126953653365813322975171532715797");
      _points[9] = ct("0.7541641319977899149388944264594135600637795973965264582163907849633878659064268645380961165020694247");
      _weight[9] = ct("0.01007952176991829850305258664289729474571005385425765929827171877545918882642476290287480815922844768");
      _points[10] = ct("0.001369365209100103662902538016497745627238368452352123490012738406772631849672261901196138706142526928");
      _weight[10] = ct("0.01401206490544436609023237121587349969746045006567761855081695008238920197145638880861484379937998666");
      _points[11] = ct("0.7113492068095685558133006667709819451575054362840455447176740142822369749162251926869838973346927698");
      _weight[11] = ct("0.01462008082783841976253308183893206231436847698410446515106255101009664107357060645472473645139699297");
      _points[12] = ct("0.6665654183773303861601326760614604743638563595328351949371522965073714357445225242299623003309299524");
      _weight[12] = ct("0.0202924034506888834074595019625389661145966542394859226818867916101663400848195357909655861316795088");
      _points[13] = ct("0.6202308940878964763528673529670363355339785112518597470011666286148975401503787651670787009253429759");
      _weight[13] = ct("0.02709500690386953751069178406838636815384967226318121133814435788253336859351359886090392628083630055");
      _points[14] = ct("0.007201060193187964367610144103097238265492936079471944871780273309543373182405493269711341122292980795");
      _weight[14] = ct("0.03211210056592242810234944055571401839762527500713589024854398810028566527822993288311027606844957208");
      _points[15] = ct("0.5727782422577024113870603024175540683472059621151315030913358644137301739485372481202450035572725181");
      _weight[15] = ct("0.03494475743428021057568935242276602073648520792237513277063007881830750670821227031289900085144260704");
      _points[16] = ct("0.5246505122103465455728183462099190147096086687630914369775031785647986088465765153290482473234440025");
      _weight[16] = ct("0.04366919988107116389230886514702208452192610172539603303155281880114132121310772290910736617814420272");
      _points[17] = ct("0.01763556469398653294408221167167162733992627300109424080406116588738610893975770523667372303912533056");
      _weight[17] = ct("0.04905514352007358740541302270051117036844203516552518776904458507336171955803915816081656601013491224");
      _points[18] = ct("0.4762970571775839012599109438642786787910227011918298028869481968383657046401344160723604121339610397");
      _weight[18] = ct("0.05300528235407393210593432792415778543059070542062211133149380520643792420434901154289638364872976669");
      _points[19] = ct("0.4281693385154156194417410742899825270370966980210852141448274402465912219366930868936595777620858797");
      _weight[19] = ct("0.06260514491381266112476446763960717503457148868267332156770556143624906440752520753898794314174248398");
      _points[20] = ct("0.03257779777966460886729942692136668100246248118137555022234282287177062321775785540900615891817245201");
      _weight[20] = ct("0.06421499003447563667095761947959886068101567810299905758943015986959607413434210190727781793751764501");
      _points[21] = ct("0.3807167103369646932919817405792130746606355782010403499486364214947528760107143133850084127060875174");
      _weight[21] = ct("0.07204908076371079309214829918846290043710821174646453642360675733877644714506224903242378673973541619");
      _points[22] = ct("0.05188853615392920947892793281212631775109602038992669350693691676633220365356651819015841212998281432");
      _weight[22] = ct("0.07708465591944440214978664678877579601642420763348919100177459902890693290204556050005832293398972658");
      _points[23] = ct("0.3343822238776351252419685447725649719691406591568741892752991492068380593197644708700909207098419998");
      _weight[23] = ct("0.08086518702868964921973768964419167020096598662788053379862951223461825278781407685710065195767206447");
      _points[24] = ct("0.07538754998514038394719127514008188990831275431228255760504153387312193075577455329791578743446834647");
      _weight[24] = ct("0.08727993087125598404851885924736203445983237573749491484102820440464420680359587863705024778690839844");
      _points[25] = ct("0.2895984907391475920138782464308026880200802349630140545217731202754357179091084031758311229993710084");
      _weight[25] = ct("0.08855464875380005756652072587576624284557300886023695065934716903300558691518263136396252574033032507");
      _points[26] = ct("0.10285545867509340672666309459934025824749333553664562240979626482386876152189922577567755172827218");
      _weight[26] = ct("0.09455543857311113942533268852024714918001646007576128813201633172025531623575828932114719978313621885");
      _points[27] = ct("0.2467836436155710933199228384538418511090271873523499710413024876413592298225490102948311490242624505");
      _weight[27] = ct("0.09462109265174807424873122469747347887669228616198273398437836689671301713817820752750902650005237804");
      _points[28] = ct("0.2063374321933079647369611133634897836240770185127581624195509150737302861230656791747631614142527725");
      _weight[28] = ct("0.09860204997970906763399803849822200678637561736800941509032055186211162575531237866562542497106307103");
      _points[29] = ct("0.1340358114983876564339860740140341196816667539203883664849981452786512463510185666317257255430747126");
      _weight[29] = ct("0.09881291012170006693456267092177765186618637716012470654782718891302456217838158452385974238915451355");
      _points[30] = ct("0.1686374906442098356617268634134017813732783166791782966045346757082471444333592363931357649357351428");
      _weight[30] = ct("0.1001003159524530363104180663619783799874178898404524336779305249101130790426842115444418169199692081");
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }


  template<typename ct>
  Jacobi2QuadratureRule<ct,1>::Jacobi2QuadratureRule (int p)
      : QuadratureRule<ct,1>(GeometryTypes::line)
  {
    //! set up quadrature of given order in d dimensions
    std::vector< FieldVector<ct,1> > _points;
    std::vector< ct > _weight;

    int deliveredOrder_;

    Jacobi2QuadratureInitHelper<ct>::init(p, _points, _weight, deliveredOrder_);

    this->delivered_order = deliveredOrder_;
    assert(_points.size() == _weight.size());
    for (size_t i = 0; i < _points.size(); i++)
      this->push_back(QuadraturePoint<ct,1>(_points[i], _weight[i]));
  }

} // namespace Dune

#endif // DUNE_GEOMETRY_QUADRATURE_Jacobi2_HH
