// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
// SPDX-FileCopyrightInfo: Copyright © DUNE Project contributors, see file LICENSE.md in module root
// SPDX-License-Identifier: LicenseRef-GPL-2.0-only-with-DUNE-exception
//
// WARNING
// This file is automatically generated by jacobian.mac! Don't edit by hand!
#ifndef DUNE_GEOMETRY_QUADRATURE_Gauss_HH
#define DUNE_GEOMETRY_QUADRATURE_Gauss_HH

#ifndef DUNE_INCLUDING_IMPLEMENTATION
#error This is a private header that should not be included directly.
#error Use #include <dune/geometry/quadraturerules.hh> instead.
#endif

namespace Dune {

  /************************************************
   * Quadraturerule for 1d line
   *************************************************/

  template<typename ct, int dim>
  class GaussQuadratureRule;

  template<typename ct>
  using GaussQuadratureRule1D = GaussQuadratureRule<ct,1>;

  template<typename ct>
  class GaussQuadratureRule<ct,1> : public QuadratureRule<ct,1>
  {
  public:
    /** brief The highest quadrature order available */
    constexpr static int highest_order = 61;

  private:
    friend class QuadratureRuleFactory<ct,1>;
    GaussQuadratureRule (int p);
    ~GaussQuadratureRule(){}
  };

  //! internal Helper template for the initialization of the quadrature rules
  template<typename ct,
      bool fundamental = std::is_floating_point<ct>::value>
  struct GaussQuadratureInitHelper;

  template<typename ct>
  struct GaussQuadratureInitHelper<ct, true> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  template<typename ct>
  struct GaussQuadratureInitHelper<ct, false> {
    static void init(int p,
                     std::vector< FieldVector<ct, 1> > & _points,
                     std::vector< ct > & _weight,
                     int & delivered_order);
  };

  // for fundamental types
  template<typename ct>
  void GaussQuadratureInitHelper<ct,true>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = 0.5;
      _weight[0] = 1.0;
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = 0.2113248654051871177454256097490212721761991243649365619906988367580111638485333271531423022071252374;
      _weight[0] = 0.5;
      _points[1] = 0.7886751345948128822545743902509787278238008756350634380093011632419888361514666728468576977928747626;
      _weight[1] = 0.5;
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = 0.8872983346207416885179265399782399610832921705291590826587573766113483091936979033519287376858673518;
      _weight[0] = 0.2777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777;
      _points[1] = 0.1127016653792583114820734600217600389167078294708409173412426233886516908063020966480712623141326482;
      _weight[1] = 0.2777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777778;
      _points[2] = 0.5;
      _weight[2] = 0.4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444;
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = 0.9305681557970262876119732444464047525478626898148588188078609604532647357475244328520811699422396526;
      _weight[0] = 0.1739274225687269286865319746109997036176743479169467702462646597593759337329551758609918838661290797;
      _points[1] = 0.0694318442029737123880267555535952474521373101851411811921390395467352642524755671479188300577603474;
      _weight[1] = 0.1739274225687269286865319746109997036176743479169467702462646597593759337329551758609918838661290798;
      _points[2] = 0.3300094782075718675986671204483776563997120651145428237035230115894899847683814827610623597822225942;
      _weight[2] = 0.3260725774312730713134680253890002963823256520830532297537353402406240662670448241390081161338709202;
      _points[3] = 0.6699905217924281324013328795516223436002879348854571762964769884105100152316185172389376402177774058;
      _weight[3] = 0.3260725774312730713134680253890002963823256520830532297537353402406240662670448241390081161338709202;
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = 0.953089922969331996398813439149696482562825955381265431436881143271885397458343423470571494776771131;
      _weight[0] = 0.1184634425280945437571320203599586813216300011062070077914139441108586442015215492899967152469757223;
      _points[1] = 0.04691007703066800360118656085030351743717404461873456856311885672811460254165657652942850522322886904;
      _weight[1] = 0.1184634425280945437571320203599586813216300011062070077914139441108586442015215492899967152469757223;
      _points[2] = 0.7692346550528415455181572103501044024836433034527799781011158135297355926838776455179018336252854658;
      _weight[2] = 0.2393143352496832340206457574178190964561477766715707699863638336669191335762562284877810625308020554;
      _points[3] = 0.2307653449471584544818427896498955975163566965472200218988841864702644073161223544820981663747145342;
      _weight[3] = 0.2393143352496832340206457574178190964561477766715707699863638336669191335762562284877810625308020554;
      _points[4] = 0.5;
      _weight[4] = 0.2844444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444;
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = 0.03376524289842398609384922275300269543261713114385508756372519173669324957789990186185563003903700748;
      _weight[0] = 0.08566224618958517252014807108636644676341125074202199119931771989947288027117007732396385271319433444;
      _points[1] = 0.9662347571015760139061507772469973045673828688561449124362748082633067504221000981381443699609629925;
      _weight[1] = 0.08566224618958517252014807108636644676341125074202199119931771989947288027117007732396385271319433508;
      _points[2] = 0.8306046932331322568306997975099526735032242821975850354072633529260917483035715504721432018732307282;
      _weight[2] = 0.1803807865240693037849167569188580558307609463733727411448696201185700189186308591604811009944096738;
      _points[3] = 0.1693953067668677431693002024900473264967757178024149645927366470739082516964284495278567981267692718;
      _weight[3] = 0.180380786524069303784916756918858055830760946373372741144869620118570018918630859160481100994409674;
      _points[4] = 0.6193095930415984543152508608403559677093053150700106750906975822871374671378199211246122136286745658;
      _weight[4] = 0.2339569672863455236949351719947754974058278028846052676558126599819571008101990635155550462923959912;
      _points[5] = 0.3806904069584015456847491391596440322906946849299893249093024177128625328621800788753877863713254342;
      _weight[5] = 0.2339569672863455236949351719947754974058278028846052676558126599819571008101990635155550462923959912;
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = 0.9745539561713792622630948420239256312003854688353088917743845519565316651774200704028653850139628621;
      _weight[0] = 0.06474248308443484663530571633954100916429370112997333198860431936232761748602115435781270908146042202;
      _points[1] = 0.02544604382862073773690515797607436879961453116469110822561544804346833482257992959713461498603713794;
      _weight[1] = 0.06474248308443484663530571633954100916429370112997333198860431936232761748602115435781270908146042288;
      _points[2] = 0.1292344072003027800680676133596057964629261764293048699400223240162850626639097431035865838165683765;
      _weight[2] = 0.139852695744638333950733885711889791243462532613299382268507016346809405215281338406620471450598809;
      _points[3] = 0.8707655927996972199319323866403942035370738235706951300599776759837149373360902568964134161834316235;
      _weight[3] = 0.1398526957446383339507338857118897912434625326132993822685070163468094052152813384066204714505988098;
      _points[4] = 0.2970774243113014165466967939615192683263089929503149368064783741026680933869371723358436551361267061;
      _weight[4] = 0.1909150252525594724751848877444875669391825417669313673755417255153527732170648541743423296720224007;
      _points[5] = 0.7029225756886985834533032060384807316736910070496850631935216258973319066130628276641563448638732939;
      _weight[5] = 0.1909150252525594724751848877444875669391825417669313673755417255153527732170648541743423296720224007;
      _points[6] = 0.5;
      _weight[6] = 0.2089795918367346938775510204081632653061224489795918367346938775510204081632653061224489795918367347;
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = 0.9801449282487681158417804342847364952141176171507260191358198886862124488717096422197194796316561341;
      _weight[0] = 0.05061426814518812957626567715498109505769704552584247852950184903237008938173539243014136965202249679;
      _points[1] = 0.01985507175123188415821956571526350478588238284927398086418011131378755112829035778028052036834386592;
      _weight[1] = 0.05061426814518812957626567715498109505769704552584247852950184903237008938173539243014136965202250399;
      _points[2] = 0.1016667612931866302042230317620847815814141341920175839649148524803913471617634539264240363521370304;
      _weight[2] = 0.1111905172266872352721779972131204422150654350256247823629546446468084072852245204268265711885989599;
      _points[3] = 0.8983332387068133697957769682379152184185858658079824160350851475196086528382365460735759636478629696;
      _weight[3] = 0.1111905172266872352721779972131204422150654350256247823629546446468084072852245204268265711885989642;
      _points[4] = 0.237233795041835507091130475405376825479017878439803571124571450363772589615719363738019299903184009;
      _weight[4] = 0.156853322938943643668981100993300656630164499501367468845131972537478135971086748480849038116964278;
      _points[5] = 0.762766204958164492908869524594623174520982121560196428875428549636227410384280636261980700096815991;
      _weight[5] = 0.156853322938943643668981100993300656630164499501367468845131972537478135971086748480849038116964278;
      _points[6] = 0.4082826787521750975302619288199080096666210935435131088414057631503977628892289429419658881444383231;
      _weight[6] = 0.1813418916891809914825752246385978060970730199471652702624115337833433673619533386621830210424142548;
      _points[7] = 0.5917173212478249024697380711800919903333789064564868911585942368496022371107710570580341118555616769;
      _weight[7] = 0.1813418916891809914825752246385978060970730199471652702624115337833433673619533386621830210424142548;
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = 0.01591988024618695508221189854816356497529759975403733522498834407545981280169962346906312538655294424;
      _weight[0] = 0.04063719418078720598594607905526182533783086039120537535555383844034334315422603147278927735147130028;
      _points[1] = 0.9840801197538130449177881014518364350247024002459626647750116559245401871983003765309368746134470557;
      _weight[1] = 0.0406371941807872059859460790552618253378308603912053753555538384403433431542260314727892773514713142;
      _points[2] = 0.08198444633668210285028510596513256172794664093766200194781401018027249655920494055302690148707122983;
      _weight[2] = 0.0903240803474287020292360156214564047571689108660202422491679532356786452724731348822974886515998753;
      _points[3] = 0.9180155536633178971497148940348674382720533590623379980521859898197275034407950594469730985129287703;
      _weight[3] = 0.0903240803474287020292360156214564047571689108660202422491679532356786452724731348822974886515998796;
      _points[4] = 0.8066857163502951986543510196707370923928603024702823464364064711406336732455005992916200069517842923;
      _weight[4] = 0.1303053482014677311593714347093164248859201022186499759699985010598054078344456223238230465475086993;
      _points[5] = 0.1933142836497048013456489803292629076071396975297176535635935288593663267544994007083799930482157077;
      _weight[5] = 0.1303053482014677311593714347093164248859201022186499759699985010598054078344456223238230465475087005;
      _points[6] = 0.3378732882980955354807309926783316957140218696315134555864762615789067102324378754034506991507512164;
      _weight[6] = 0.1561735385200014200343152032922218327993774306309523227770055827995719486620096582850609609440031769;
      _points[7] = 0.6621267117019044645192690073216683042859781303684865444135237384210932897675621245965493008492487836;
      _weight[7] = 0.156173538520001420034315203292221832799377430630952322777005582799571948662009658285060960944003177;
      _points[8] = 0.5;
      _weight[8] = 0.1651196775006298815822625346434870244394053917863441672965482489292013101536911060720584530108339632;
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = 0.9869532642585858600389820060422260267141349733461910596156060333482976016173180798128617824781342781;
      _weight[0] = 0.03333567215434406879678440494666589642893241716007907256434744080670603204204355088839275484252937791;
      _points[1] = 0.01304673574141413996101799395777397328586502665380894038439396665170239838268192018713821752186572192;
      _weight[1] = 0.03333567215434406879678440494666589642893241716007907256434744080670603204204355088839275484252937791;
      _points[2] = 0.9325316833444922553660483442117465242637715074826652262609798659226873775690277806783953644730228854;
      _weight[2] = 0.07472567457529029657288816982884866620127831983471368391773863437661932736331500547297363231736586137;
      _points[3] = 0.06746831665550774463395165578825347573622849251733477373902013407731262243097221932160463552697711466;
      _weight[3] = 0.07472567457529029657288816982884866620127831983471368391773863437661932736331500547297363231736596593;
      _points[4] = 0.1602952158504877968828363174425632121153526440825952661675914055237207123024625376924607132147598102;
      _weight[4] = 0.1095431812579910219977674671140815962293859352613385449404782718175999553264756406213419965886010702;
      _points[5] = 0.8397047841495122031171636825574367878846473559174047338324085944762792876975374623075392867852401898;
      _weight[5] = 0.1095431812579910219977674671140815962293859352613385449404782718175999553264756406213419965886011106;
      _points[6] = 0.2833023029353764046003670284171079188999640811718767517486492434281165054611482493874486210249411394;
      _weight[6] = 0.1346333596549981775456134607847346764298799692304418979002816381210767161595896383821133183546263798;
      _points[7] = 0.7166976970646235953996329715828920811000359188281232482513507565718834945388517506125513789750588606;
      _weight[7] = 0.1346333596549981775456134607847346764298799692304418979002816381210767161595896383821133183546263804;
      _points[8] = 0.4255628305091843945575869994351400076912175702896541521460053732420481913221657393144111851002681544;
      _weight[8] = 0.1477621123573764350869464973256691647105233585134268006771540148779979691085761646351782978968771084;
      _points[9] = 0.5744371694908156054424130005648599923087824297103458478539946267579518086778342606855888148997318456;
      _weight[9] = 0.1477621123573764350869464973256691647105233585134268006771540148779979691085761646351782978968771084;
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = 0.01088567092697150359803099943857130461428879554010779228709946700816810030955500589984030091632761502;
      _weight[0] = 0.02783428355808683324137686022127428936425781284844907417419214283707770364036877194184561103615985882;
      _points[1] = 0.9891143290730284964019690005614286953857112044598922077129005329918318996904449941001596990836723848;
      _weight[1] = 0.02783428355808683324137686022127428936425781284844907417419214283707770364036877194184561103615998649;
      _points[2] = 0.9435312998840476495375788846519636333158378756126571924837055277688056569286863337211452975632986873;
      _weight[2] = 0.06279018473245231231734714961197005009880789569770175033196700540895728756623563881734382085702807703;
      _points[3] = 0.05646870011595235046242111534803636668416212438734280751629447223119434307131366627885470243670131297;
      _weight[3] = 0.0627901847324523123173471496119700500988078956977017503319670054089572875662356388173438208570284425;
      _points[4] = 0.86507600278702466204670812601557672902482153101306515598918916984350662252925961479771170548564185;
      _weight[4] = 0.0931451054638671257130488207158279458456423740201017058907532020869361740043927512346653792589896456;
      _points[5] = 0.13492399721297533795329187398442327097517846898693484401081083015649337747074038520228829451435815;
      _weight[5] = 0.09314510546386712571304882071582794584564237402010170589075320208693617400439275123466537925898987179;
      _points[6] = 0.2404519353965940920371371652706952227598864424400357554895386942566520367744635535872006099477254724;
      _weight[6] = 0.1165968822959952399592618524215875697158990861584792545136598610609661066094404979770199742191308423;
      _points[7] = 0.7595480646034059079628628347293047772401135575599642445104613057433479632255364464127993900522745276;
      _weight[7] = 0.1165968822959952399592618524215875697158990861584792545136598610609661066094404979770199742191308499;
      _points[8] = 0.6347715779761724861657659927004307623398109312195261408119628159400285331118473678519107961221336507;
      _weight[8] = 0.131402272255123331090344434945254597686382338801572278190027685742756401669772626776208498508513353;
      _points[9] = 0.3652284220238275138342340072995692376601890687804738591880371840599714668881526321480892038778663493;
      _weight[9] = 0.131402272255123331090344434945254597686382338801572278190027685742756401669772626776208498508513353;
      _points[10] = 0.5;
      _weight[10] = 0.1364625433889503153572417641681710945780209849473918737988002057266126530195794265058334322403586473;
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = 0.009219682876640374654725454925359588519922400093134244768658939096103377840873008887371366054773882871;
      _weight[0] = 0.02358766819325591359730798074250853015851453699742354478025267350190486057601935533541295353770570183;
      _points[1] = 0.9907803171233596253452745450746404114800775999068657552313410609038966221591269911126286339452261171;
      _weight[1] = 0.02358766819325591359730798074250853015851453699742354478025267350190486057601935533541295353771090306;
      _points[2] = 0.9520586281852374283392329330595480962687983546066487732770378803406173978646178952434847139118666353;
      _weight[2] = 0.05346966299765921548012735909699811210728508673516244000256302105140949681374878827026865904815670116;
      _points[3] = 0.0479413718147625716607670669404519037312016453933512267229621196593826021353821047565152860881333648;
      _weight[3] = 0.05346966299765921548012735909699811210728508673516244000256302105140949681374878827026865904815772913;
      _points[4] = 0.8849513370971523435184469166064090379924628750094658188322095321245582715542356120082124996117109545;
      _weight[4] = 0.08003916427167311316732626477167953593600586524543208895494977207897711258664557534082827631852788289;
      _points[5] = 0.1150486629028476564815530833935909620075371249905341811677904678754417284457643879917875003882890453;
      _weight[5] = 0.08003916427167311316732626477167953593600586524543208895494977207897711258664557534082827631852953845;
      _points[6] = 0.7936589771433087236483512094702671401845492570240262407551354398336703496879476312178553824943741012;
      _weight[6] = 0.1015837133615329608745322279048991882532590736372950731992972828988228162552364218975721975323025648;
      _points[7] = 0.2063410228566912763516487905297328598154507429759737592448645601663296503120523687821446175056258989;
      _weight[7] = 0.1015837133615329608745322279048991882532590736372950731992972828988228162552364218975721975323026497;
      _points[8] = 0.3160842505009099031236542316781412193718199293322951893441000602479550352416060630606327857497267114;
      _weight[8] = 0.1167462682691774043804249494624390281297049860998774373652617489107460000397058376403395132542818442;
      _points[9] = 0.6839157494990900968763457683218587806281800706677048106558999397520449647583939369393672142502732886;
      _weight[9] = 0.1167462682691774043804249494624390281297049860998774373652617489107460000397058376403395132542818454;
      _points[10] = 0.5626167042557344577362206847319265649916984581527221366064608773742310281206948443714341492347456798;
      _weight[10] = 0.1245735229067013925002812180214756054152304512848094156976755015581397137286440215155784003090211765;
      _points[11] = 0.4373832957442655422637793152680734350083015418472778633935391226257689718793051556285658507652543202;
      _weight[11] = 0.1245735229067013925002812180214756054152304512848094156976755015581397137286440215155784003090211765;
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = 0.9920915273592940747364147244035548055324952809629374543470036602142976189378134209302846436307092946;
      _weight[0] = 0.02024200238265793976001079610049303002099327287249443406752330375249723025639635524721040621651256352;
      _points[1] = 0.007908472640705925263585275596445194467504719037062545652996339785702381062186579069715356369290706896;
      _weight[1] = 0.02024200238265793976001079610049303002099327287249443406752330375249723025639635524721040621651575551;
      _points[2] = 0.9587991996114889826032739182503597561952373950558416479476426728298296042948049571417426951702914619;
      _weight[2] = 0.04606074991886422395721088797689856046184199993111841954419577366979686486381646314594890787783233253;
      _points[3] = 0.04120080038851101739672608174964024380476260494415835205235732717017039570519504285825730482970853578;
      _weight[3] = 0.04606074991886422395721088797689856046184199993111841954419577366979686486381646314594890787787365219;
      _points[4] = 0.9007890453666549563971032447914299451528078623952500149486923569296110581133200610150149370926585299;
      _weight[4] = 0.069436755109893619231800888434435733810931359131649113823177508252886260767444767862590771427295539;
      _points[5] = 0.09921095463334504360289675520857005484719213760474998505130764307038894188667993898498506290734147097;
      _weight[5] = 0.06943675510989361923180088843443573381093135913164911382317750825288626076744476786259077142729935376;
      _points[6] = 0.1788253302798298896780076965022421749641513008692115713054287960406782234275032125428058499429042223;
      _weight[6] = 0.08907299038097286914002334599804899775640632533050825149339722014457253474937436174735847561115655018;
      _points[7] = 0.8211746697201701103219923034977578250358486991307884286945712039593217765724967874571941500570957777;
      _weight[7] = 0.08907299038097286914002334599804899775640632533050825149339722014457253474937436174735847561115720583;
      _points[8] = 0.724246375518223426438956426063819933900960833720878939479141473729122046033108571822519104277366505;
      _weight[8] = 0.1039080237684442511562616096530263816932913045997517746095555599582692717825422161302977640233059593;
      _points[9] = 0.2757536244817765735610435739361800660990391662791210605208585262708779539668914281774808957226334949;
      _weight[9] = 0.1039080237684442511562616096530263816932913045997517746095555599582692717825422161302977640233059661;
      _points[10] = 0.6152291579775673970327640605489944176057711879417655817346307489185810418442909754064014723823400647;
      _weight[10] = 0.1131415901314486192060450930198883092173788688077785099324842743857878315602499855209131593331569649;
      _points[11] = 0.3847708420224326029672359394510055823942288120582344182653692510814189581557090245935985276176599353;
      _weight[11] = 0.1131415901314486192060450930198883092173788688077785099324842743857878315602499855209131593331569649;
      _points[12] = 0.5;
      _weight[12] = 0.1162757766154369550972947576344179740783137386533989930593327196723800120403517006913610310213706817;
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = 0.006858095651593830579201366647973599161954296380387059177964594111125222933754181044676880167424125515;
      _weight[0] = 0.01755973016587593151591643806909589030985280463856363829074994509820816141890413526883839849926422796;
      _points[1] = 0.9931419043484061694207986333520264008380457036196129408220354058888747770662458189553231198325758757;
      _weight[1] = 0.01755973016587593151591643806909589030985280463856363829074994509820816141890413526883839849929733993;
      _points[2] = 0.9642174418317867586681955696889371322385196052049188093589812237410655467721799265557069528418287599;
      _weight[2] = 0.04007904357988010490281663853142715479184889269729738260069953274478573722864358493176809540971271623;
      _points[3] = 0.03578255816821324133180443031106286776148039479508119064101877625893445322782007344429304715817123803;
      _weight[3] = 0.0400790435798801049028166385314271547918488926972973826006995327447857372286435849317680954097315832;
      _points[4] = 0.9136006575348824965948973713251974805198505507375405907803545271207399154050144367852131950689447722;
      _weight[4] = 0.06075928534395159234470740453623831297833467284503733614553769627157987194626324615940995313520037766;
      _points[5] = 0.08639934246511750340510262867480251948014944926245940921964547287926008459498556321478680493105522878;
      _weight[5] = 0.06075928534395159234470740453623831297833467284503733614553769627157987194626324615940995313521470206;
      _points[6] = 0.8436464524058427350740099015096670687692006063735853378096332443140924480915666284736865352526059193;
      _weight[6] = 0.07860158357909676728480096931192107830283401866866168748465852193738408818480414925697904668120528128;
      _points[7] = 0.1563535475941572649259900984903329312307993936264146621903667556859075519084333715263134647473940806;
      _weight[7] = 0.07860158357909676728480096931192107830283401866866168748465852193738408818480414925697904668120705796;
      _points[8] = 0.2423756818209229540173546407244056688455573587153469815242476154536075240839721697739639898246135538;
      _weight[8] = 0.09276919873896890687085829506257851812446130146866582951001746253454917513176272221277636557335623116;
      _points[9] = 0.7576243181790770459826453592755943311544426412846530184757523845463924759160278302260360101753864463;
      _weight[9] = 0.09276919873896890687085829506257851812446130146866582951001746253454917513176272221277636557335624966;
      _points[10] = 0.3404438155360551197821640879157622665828693982330780217016749063713332797436036084175331472893267934;
      _weight[10] = 0.1025992318606478019829620328306090278551695306547097258584486451416835724126248601697159199959454469;
      _points[11] = 0.6595561844639448802178359120842377334171306017669219782983250936286667202563963915824668527106732066;
      _weight[11] = 0.1025992318606478019829620328306090278551695306547097258584486451416835724126248601697159199959454481;
      _points[12] = 0.4459725256463281689668776748900826261940241972628812214795894693459932354941349964349496559116553164;
      _weight[12] = 0.1076319267315788950979382216581300176374987790270644001098881962718093936769973020005122207054097891;
      _points[13] = 0.5540274743536718310331223251099173738059758027371187785204105306540067645058650035650503440883446836;
      _weight[13] = 0.1076319267315788950979382216581300176374987790270644001098881962718093936769973020005122207054097891;
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = 0.006003740989757285755217140706693709426513591438119255000001242206305781315490287643638974815840423912;
      _weight[0] = 0.01537662099805863417731419678860220886087407241671703713211414275211859473355858401951938536567818793;
      _points[1] = 0.9939962590102427142447828592933062905734864085618807449999987577936942186845097123563610251841595731;
      _weight[1] = 0.01537662099805863417731419678860220886087407241671703713211414275211859473355858401951938536633108639;
      _points[2] = 0.9686366962003529521538794738551047356219981367576522289506815381751014868985227639752737930871340456;
      _weight[2] = 0.03518302374405406235463370822533366923335401637716535991295364645719352775643711852242022603232734774;
      _points[3] = 0.03136330379964704784612052614489526437800186324234777104931846182489851310147723602472620691286596038;
      _weight[3] = 0.03518302374405406235463370822533366923335401637716535991295364645719352775643711852242022603294154521;
      _points[4] = 0.07589670829478639189967583961289157431687191263150368295213622061966246241292725740119614012458925999;
      _weight[4] = 0.05357961023358596750593477334293465170777185787905099034351119456093899742615789986284292856885599421;
      _points[5] = 0.9241032917052136081003241603871084256831280873684963170478637793803375375870727425988038598754107365;
      _weight[5] = 0.05357961023358596750593477334293465170777185787905099034351119456093899742615789986284292856902630637;
      _points[6] = 0.8622088656800850237080930273069690048154496472920512817757117103520618908389626094980505488015671642;
      _weight[6] = 0.06978533896307715722390239725551416126042513765775562160119556431554422227095390584038412868178503037;
      _points[7] = 0.1377911343199149762919069726930309951845503527079487182242882896479381091610373905019494511984328364;
      _weight[7] = 0.06978533896307715722390239725551416126042513765775562160119556431554422227095390584038412868179665823;
      _points[8] = 0.2145139136957305762313866313730446793808068018586251975733672914729023100651207102582926857150869278;
      _weight[8] = 0.08313460290849696677660043024060440556545009004920645366093259528177678160613925885535258714620779062;
      _points[9] = 0.7854860863042694237686133686269553206191931981413748024266327085270976899348792897417073142849130721;
      _weight[9] = 0.08313460290849696677660043024060440556545009004920645366093259528177678160613925885535258714620808482;
      _points[10] = 0.302924326461218315051396314509477265818623611920650872484417328024195521106519291012251442919170119;
      _weight[10] = 0.09308050000778110551340028093321141225311300613896420140774786365500662775134958030947488444304965858;
      _points[11] = 0.6970756735387816849486036854905227341813763880793491275155826719758044788934807089877485570808298811;
      _weight[11] = 0.09308050000778110551340028093321141225311300613896420140774786365500662775134958030947488444304966241;
      _points[12] = 0.3994029530012827388496858483027018960935817727686811601920251376950258804984899061990818709662394704;
      _weight[12] = 0.09921574266355578822805916322191966240934627997877099674236896396456239876671713406665749958240891154;
      _points[13] = 0.6005970469987172611503141516972981039064182272313188398079748623049741195015100938009181290337605296;
      _weight[13] = 0.09921574266355578822805916322191966240934627997877099674236896396456239876671713406665749958240891161;
      _points[14] = 0.5;
      _weight[14] = 0.1012891209627806364403100999837596574193310790047386783983520580257176993773730370466967203563940161;
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = 0.005299532504175033701922913274833686286862964171177434974388047634337931392087301530731784046600902477;
      _weight[0] = 0.01357622970587704742589028622800905175613368778338039899530515953690205683210808662466288961558883448;
      _points[1] = 0.9947004674958249662980770867251663137131370358288225650256119523656620686079126984692682159533990871;
      _weight[1] = 0.01357622970587704742589028622800905175613368778338039899530515953690205683210808662466288961642578809;
      _points[2] = 0.9722875115366162880389942077673041725455696362955363004627768260333048944513411521097828643690791645;
      _weight[2] = 0.03112676196932394643142191849718884713749325417645342895065175790976786944352190953060585476930010037;
      _points[3] = 0.02771248846338371196100579223269582745443036370446369953722317396669510554865884789021713563092085786;
      _weight[3] = 0.03112676196932394643142191849718884713749325417645342895065175790976786944352190953060585476935955411;
      _points[4] = 0.06718439880608412805976605114380343380633230757623664594824428721611980114375472087143375281761380758;
      _weight[4] = 0.04757925584124639240496255380112311317763175159185632907841114361481587978884097972351247865969801944;
      _points[5] = 0.9328156011939158719402339488561965661936676924237633540517557127838801988562452791285662471823861744;
      _weight[5] = 0.04757925584124639240496255380112311317763175159185632907841114361481587978884097972351247866179909653;
      _points[6] = 0.8777022041775015169475505974237211341769068282287515048908785884611484305156358388603110284596247239;
      _weight[6] = 0.06231448562776693602623814109600821007244342961110133997237529521470548196073267679898459500869048106;
      _points[7] = 0.1222977958224984830524494025762788658230931717712484951091214115388515694843641611396889715403752838;
      _weight[7] = 0.06231448562776693602623814109600821007244342961110133997237529521470548196073267679898459500869141184;
      _points[8] = 0.8089381222013218742233358820243955094959411088828288970518986777708666588774057122284555152139792502;
      _weight[8] = 0.07479799440828836604075086527373927448524553410391823340271098109368020201020899122588931920152688622;
      _points[9] = 0.191061877798678125776664117975604490504058891117171102948101322229133341122594287771544484786020748;
      _weight[9] = 0.07479799440828836604075086527373927448524553410391823340271098109368020201020899122588931920153081579;
      _points[10] = 0.7290083888286136931712097214917887867700158065177617454505773754738795871451468038677177639679940468;
      _weight[10] = 0.08457825969750126909465603951517998110581973670801414087254146784040183210496526546607766127103887189;
      _points[11] = 0.2709916111713863068287902785082112132299841934822382545494226245261204128548531961322822360320059534;
      _weight[11] = 0.08457825969750126909465603951517998110581973670801414087254146784040183210496526546607766127103912237;
      _points[12] = 0.6408017753896294566152302507302480532430347453852999002744173669779625897495653852207201145760200796;
      _weight[12] = 0.09130170752246179443338183398460996969177811182732464120924757218971523247505558748020021255849263684;
      _points[13] = 0.3591982246103705433847697492697519467569652546147000997255826330220374102504346147792798854239799204;
      _weight[13] = 0.09130170752246179443338183398460996969177811182732464120924757218971523247505558748020021255849263706;
      _points[14] = 0.4524937450811812799073403322875209684348234721554672716513900913874373508777039335076206535121083239;
      _weight[14] = 0.09472530522753424814269836160414155257345449419795148751875662260001144538456650315006698891676697614;
      _points[15] = 0.5475062549188187200926596677124790315651765278445327283486099086125626491222960664923793464878916761;
      _weight[15] = 0.09472530522753424814269836160414155257345449419795148751875662260001144538456650315006698891676697614;
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = 0.004712262342791332162282990029667361746105074770217848608045606628828071264688983144320779675129030429;
      _weight[0] = 0.01207415143427396598005501314378266234584865797251263915559257441510919835275524317979262072372571691;
      _points[1] = 0.9952877376572086678377170099703326382538949252297821513919543933711719287353110168556792203248709665;
      _weight[1] = 0.01207415143427396598005501314378266234584865797251263915559257441510919835275524317979262072798397032;
      _points[2] = 0.02466223911561611938864152105209848927830747672044564616501539379394231686390070262498154862426577667;
      _weight[2] = 0.02772976468699360056472008267912233025642312597661442349686203935512871300166731918663789437619580271;
      _points[3] = 0.9753377608843838806113584789479015107216925232795543538349846062060576831360992973750184513757342315;
      _weight[3] = 0.02772976468699360056472008267912233025642312597661442349686203935512871300166731918663789438923065064;
      _points[4] = 0.9401195768634929510614778472440778463117084089672139501759550796620135652522056057591535969342795476;
      _weight[4] = 0.04251807415858959044176768509553103692524569460925273788320518036939199639374132387349380214026392876;
      _points[5] = 0.05988042313650704893852215275592215368829159103278604982404492033798643474779439424084640306572044363;
      _weight[5] = 0.04251807415858959044176768509553103692524569460925273788320518036939199639374132387349380215620526406;
      _points[6] = 0.8907570019484007034626150277602380251119862363702842562566572677562888080797565380866902504334808315;
      _weight[6] = 0.05594192359670198554739419281317796336792171213153852500924324122454783982180491780761085226210241093;
      _points[7] = 0.1092429980515992965373849722397619748880137636297157437433427322437111919202434619133097495665191737;
      _weight[7] = 0.05594192359670198554739419281317796336792171213153852500924324122454783982180491780761085226455009237;
      _points[8] = 0.1711644203916546170748488916784988324260970542620133780973841522463378512126512091235044063472449388;
      _weight[8] = 0.06756818423426273664315999085117509868606292661724451018899730534443362149496927204875472415680701704;
      _points[9] = 0.8288355796083453829251511083215011675739029457379866219026158477536621487873487908764955936527550596;
      _weight[9] = 0.06756818423426273664315999085117509868606292661724451018899730534443362149496927204875472415684703185;
      _points[10] = 0.7563452685432384839431232843147759372914618612055864529563657494821424624713927401409902061902588012;
      _weight[10] = 0.07702288053840514404071579740097930597024152923550896719263235567572337092983822554580872467672521159;
      _points[11] = 0.243654731456761516056876715685224062708538138794413547043634250517857537528607259859009793809741199;
      _weight[11] = 0.07702288053840514404071579740097930597024152923550896719263235567572337092983822554580872467672663593;
      _points[12] = 0.6756158817269381576485927585476730025202698757878375116595805097738971308233747864487915723017545524;
      _weight[12] = 0.08400205107822502225498533189416157751059906448253700713497792567016155325001229328060192486945988784;
      _points[13] = 0.3243841182730618423514072414523269974797301242121624883404194902261028691766252135512084276982454476;
      _weight[13] = 0.08400205107822502225498533189416157751059906448253700713497792567016155325001229328060192486945989544;
      _points[14] = 0.5892420907479239279253387468270327787377096663457628217814759071353487752396502880851444611048175023;
      _weight[14] = 0.08828135268349632316263549505659861957546220900037405902157220345660451810364134022616734534204332795;
      _points[15] = 0.4107579092520760720746612531729672212622903336542371782185240928646512247603497119148555388951824977;
      _weight[15] = 0.08828135268349632316263549505659861957546220900037405902157220345660451810364134022616734534204332799;
      _points[16] = 0.5;
      _weight[16] = 0.0897232351781032627291328221309428107243901599488342618338343489777983773031401297022642228762521388;
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = 0.004217415789534526634991997646924614873710531577280153540162184880071453204110195124118265193699399567;
      _weight[0] = 0.01080800676324165515667135513322623469384261573779497273103799507067654511867256095162565153472427187;
      _points[1] = 0.9957825842104654733650080023530753851262894684227198464598378151199285467958898048758817348063006366;
      _weight[1] = 0.01080800676324165515667135513322623469384261573779497273103799507067654511867256095162565154865900931;
      _points[2] = 0.9779119747856988775905979464648881549864220674056532394226938148454490356023866119789411964798169198;
      _weight[2] = 0.02485727444748489822666747310131932084043312306445510112315215393278617164790170814752068547592735646;
      _points[3] = 0.02208802521430112240940205353511184501357793259434676057730618515455096439761338802105880352018300695;
      _weight[3] = 0.02485727444748489822666747310131932084043312306445510112315215393278617164790170814752068552847842593;
      _points[4] = 0.9463012332487778696030302955635727577039476356761491070937331574536202912183924679153337935403015991;
      _weight[4] = 0.03821286512744452826456483880831826280265895310417914372476068961720500364589648967088255123780103244;
      _points[5] = 0.05369876675122213039696970443642724229605236432385089290626684254637970878160753208466620645969845262;
      _weight[5] = 0.03821286512744452826456483880831826280265895310417914372476068961720500364589648967088255130463489598;
      _points[6] = 0.9018524794862615578412087275072953985516494608059612408752140320976940527144721436141434827212058818;
      _weight[6] = 0.05047102205314358278140699246241730353140056944383945080518726832782539869024926167622531935947931249;
      _points[7] = 0.09814752051373844215879127249270460144835053919403875912478596790230594728552785638585651727879410136;
      _weight[7] = 0.05047102205314358278140699246241730353140056944383945080518726832782539869024926167622531936152909078;
      _points[8] = 0.8458435215301766039374455406444241947261352864087538794510813284185986844518146255669054040725663105;
      _weight[8] = 0.06127760335573923009225956340010077761408194866671954858362675682702871979970184091909860996236098967;
      _points[9] = 0.1541564784698233960625544593555758052738647135912461205489186715814013155481853744330945959274336919;
      _weight[9] = 0.06127760335573923009225956340010077761408194866671954858362675682702871979970184091909860996247060097;
      _points[10] = 0.2201145844630262326960642257373354315361867571146452916800065279689077358967397401704589758199778143;
      _weight[10] = 0.07032145733532532560236565187597361404775120516548627994172809763023279346387494851533138451345573173;
      _points[11] = 0.7798854155369737673039357742626645684638132428853547083199934720310922641032602598295410241800221855;
      _weight[11] = 0.07032145733532532560236565187597361404775120516548627994172809763023279346387494851533138451345944567;
      _points[12] = 0.2941244192685786769820341030834741814605051589399872443594255661048051634497872951128265748031744856;
      _weight[12] = 0.07734233756313262246270900191818738609660919813367708633332095736389143461532186515617346192611193334;
      _points[13] = 0.7058755807314213230179658969165258185394948410600127556405744338951948365502127048871734251968255144;
      _weight[13] = 0.07734233756313262246270900191818738609660919813367708633332095736389143461532186515617346192611199996;
      _points[14] = 0.3740568871542472452055135725610443849185691171701797709898644841316077532221378890964612289453068764;
      _weight[14] = 0.0821382418729163614930268882329637952061694769986764766222484854558242109226040038776818788735302449;
      _points[15] = 0.6259431128457527547944864274389556150814308828298202290101355158683922467778621109035387710546931236;
      _weight[15] = 0.0821382418729163614930268882329637952061694769986764766222484854558242109226040038776818788735302449;
      _points[16] = 0.5423875065208676506211309264678919058666586934530449600216822588127498953266400008189022753637198062;
      _weight[16] = 0.08457119148157179592032823506749330516705290968517194013493759577452972209577732108546045701988907679;
      _points[17] = 0.4576124934791323493788690735321080941333413065469550399783177411872501046733599991810977246362801938;
      _weight[17] = 0.08457119148157179592032823506749330516705290968517194013493759577452972209577732108546045701988907679;
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = 0.9962034219217922015945088351266302467946582007016053933398397195456159514792614419018374604367093356;
      _weight[0] = 0.009730894114863238518156020732219217876453304534643320396340236230800718784052774105426043995362173783;
      _points[1] = 0.003796578078207798405491164873369753205341799298394606660160280454384048520738558098162539563290576184;
      _weight[1] = 0.009730894114863238518156020732219217876453304534643320396340236230800718784052774105426044173769122249;
      _points[2] = 0.980104076067415015426389420343825763307545751637069052958908167216100374968744256610371780745770797;
      _weight[2] = 0.02240711338284980016641907870099710597587711373392880104292726338382149569213972882233451675157216316;
      _points[3] = 0.01989592393258498457361057965617423669245424836293094704109183278389962503125574338962821925422939313;
      _weight[3] = 0.02240711338284980016641907870099710597587711373392880104292726338382149569213972882233451752427173122;
      _points[4] = 0.04842204819259104917866953573384375609530303297132209115248378761918209770494789052123988581535143365;
      _weight[4] = 0.03452227136882061329035412900300652248092401584380656556145021384801748745321951075883154737770809981;
      _points[5] = 0.9515779518074089508213304642661562439046969670286779088475162123808179022950521094787601141846484121;
      _weight[5] = 0.03452227136882061329035412900300652248092401584380656556145021384801748745321951075883154804745494595;
      _points[6] = 0.9113573282685714124894612433563569508872692431034150206849319443027501714518429160134331115546303493;
      _weight[6] = 0.04574501081122499973223104706191982633045582564829939233249467245103111052189863080287385751297978919;
      _points[7] = 0.08864267173142858751053875664364304911273075689658497931506805569724982854815708398656688844536971947;
      _weight[7] = 0.04574501081122499973223104706191982633045582564829939233249467245103111052189863080287385752662736252;
      _points[8] = 0.1395169113323853106914520695881091851714290835456666125307047643066927204260069735782833086643367062;
      _weight[8] = 0.05578332277366699735801195084088299874066592691994688776073057143822948805282323530050214248021619462;
      _points[9] = 0.860483088667614689308547930411890814828570916454333387469295235693307279573993026421716691335663273;
      _weight[9] = 0.05578332277366699735801195084088299874066592691994688776073057143822948805282323530050214248274414005;
      _points[10] = 0.1997273476691594882651809175268803600658389586338537162067066371658075456515645797876221023342730016;
      _weight[10] = 0.06437698126966811383775789242843855852791978854673151727355219231115180202831583996571650116696087894;
      _points[11] = 0.8002726523308405117348190824731196399341610413661462837932933628341924543484354202123778976657270034;
      _weight[11] = 0.06437698126966811383775789242843855852791978854673151727355219231115180202831583996571650116705281951;
      _points[12] = 0.2677146293120195271413664259479488160118571426879317015078455612121579394432872966567752271396340272;
      _weight[12] = 0.07130335108680330588787305472095148623783417241223693046328582795322912423645162550747003591862412103;
      _points[13] = 0.7322853706879804728586335740520511839881428573120682984921544387878420605567127033432247728603659722;
      _weight[13] = 0.07130335108680330588787305472095148623783417241223693046328582795322912423645162550747003591862432269;
      _points[14] = 0.6582820499818149159950586644249224589461426095664436225778644933989464429102881989984194460432401755;
      _weight[14] = 0.07638302103292983338942770044883149923050413361821431176155077653740552182553160682740492351539352549;
      _points[15] = 0.3417179500181850840049413355750775410538573904335563774221355066010535570897118010015805539567598244;
      _weight[15] = 0.07638302103292983338942770044883149923050413361821431176155077653740552182553160682740492351539354559;
      _points[16] = 0.5801793228201126879340480578703717747524367502354376894373217258031603043401955368283697867497404565;
      _weight[16] = 0.07948442169697717382497821973252360083939007909756304787558745766237048929169252987130523836300323926;
      _points[17] = 0.4198206771798873120659519421296282252475632497645623105626782741968396956598044631716302132502595435;
      _weight[17] = 0.07948442169697717382497821973252360083939007909756304787558745766237048929169252987130523836300323929;
      _points[18] = 0.5;
      _weight[18] = 0.08052722492439184798958181266045836751995127928925845106416157636788552422774903607627038285846452347;
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = 0.003435700407452537606938805764339860888676434549172051925907934391007641186123109580275298751713954469;
      _weight[0] = 0.008807003569576059155930981175926408181071552771668366262174663338674209629810923908701553356090040729;
      _points[1] = 0.996564299592547462393061194235660139111323565450827948074092065608992358813876890419724701248285876;
      _weight[1] = 0.008807003569576059155930981175926408181071552771668366262174663338674209629810923908701553563226498553;
      _points[2] = 0.9819859636389568956338330655986386109560301639030944280317687969460207903921915284900090626279828738;
      _weight[2] = 0.02030071490019347066551997613746605493954531999497576840880342728091614837549366414776945721436983009;
      _points[3] = 0.01801403636104310436616693440136138904396983609690557196823120305397920960780847150999093737201747363;
      _weight[3] = 0.02030071490019347066551997613746605493954531999497576840880342728091614837549366414776945930224083097;
      _points[4] = 0.9561172141256629529338762206016490565245923987118458873979411095790354456043595394682223630964602397;
      _weight[4] = 0.03133602416705453178475326759352080317580053828921818204979217271898740551683283932228188052636258305;
      _points[5] = 0.04388278587433704706612377939835094347540760128815411260205889042096455439564046053177763690353951217;
      _weight[5] = 0.03133602416705453178475326759352080317580053828921818204979217271898740551683283932228188185922162769;
      _points[6] = 0.08044151408889058830273546914923965733518531746718131337375363723356945300033759504038532971702103414;
      _weight[6] = 0.04163837078835237436237907161102310305008891429158164537244103039284654144703970973568759498491074799;
      _points[7] = 0.9195584859111094116972645308507603426648146825328186866262463627664305469996624049596146702829790438;
      _weight[7] = 0.04163837078835237436237907161102310305008891429158164537244103039284654144703970973568759537895086086;
      _points[8] = 0.1268340467699246036928474648221792048446346602154117779302270469657323224809224676594479431896762949;
      _weight[8] = 0.05096505990862021751837506774017493808334582801169627813098580809842616101269717323767465784984593666;
      _points[9] = 0.8731659532300753963071525351778207951553653397845882220697729530342676775190775323405520568103236989;
      _weight[9] = 0.05096505990862021751837506774017493808334582801169627813098580809842616101269717323767465787679251824;
      _points[10] = 0.8180268403632575127264183481131429683716945583996842319697233112732706312927150662793515977478806628;
      _weight[10] = 0.05909726598075920865618868885569114350252060977448438772344497601008737417525575815286434391364216924;
      _points[11] = 0.1819731596367424872735816518868570316283054416003157680302766887267293687072849337206484022521193356;
      _weight[11] = 0.05909726598075920865618868885569114350252060977448438772344497601008737417525575815286434391379151647;
      _points[12] = 0.755433500975413549002182025477625499212745664601213416736174309947367485195382864072015841525433889;
      _weight[12] = 0.06584431922458831344924724987408156745805525557349176349821824685442717821474046657177898759196353775;
      _points[13] = 0.2445664990245864509978179745223745007872543353987865832638256900526325148046171359279841584745661111;
      _weight[13] = 0.06584431922458831344924724987408156745805525557349176349821824685442717821474046657177898759199220677;
      _points[14] = 0.3131469556422902196637259114875363813021268391471586440860256932421771178134702360520521581827333106;
      _weight[14] = 0.07104805465919102566464916253358246651725770669601015166868354149191404374896718380847461214160016571;
      _points[15] = 0.6868530443577097803362740885124636186978731608528413559139743067578228821865297639479478418172666894;
      _weight[15] = 0.07104805465919102566464916253358246651725770669601015166868354149191404374896718380847461214160037349;
      _points[16] = 0.613892925570822539040248097684287312371544468841463736157317869603585670931777913897476062595484354;
      _weight[16] = 0.07458649323630187339391436850098471834633995204068415824810560890492221129779339034698066301760523947;
      _points[17] = 0.386107074429177460959751902315712687628455531158536263842682130396414329068222086102523937404515646;
      _weight[17] = 0.07458649323630187339391436850098471834633995204068415824810560890492221129779339034698066301760523991;
      _points[18] = 0.5382632605667486668773202046994191055023981334067487504023976221921281710241684891207725570907781078;
      _weight[18] = 0.07637669356536292534904216597754879674597432255618929863735052490879872658136889076778624391825195297;
      _points[19] = 0.4617367394332513331226797953005808944976018665932512495976023778078718289758315108792274429092218922;
      _weight[19] = 0.07637669356536292534904216597754879674597432255618929863735052490879872658136889076778624391825195297;
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = 0.9968760853101947501301210179689704645966692273911645927904369273565480545114964034990643735676197425;
      _weight[0] = 0.008008614128887166662112308429235507632945211058951241274088955056779383680659431157453347771312310018;
      _points[1] = 0.003123914689805249869878982031029535403330772608835407209563072643451945488503596500935626432380384723;
      _weight[1] = 0.008008614128887166662112308429235507632945211058951241274088955056779383680659431157453351749114303732;
      _points[2] = 0.01638658071684685284168889254615241928765315633507657502351443595743951999745985601408129906803823328;
      _weight[2] = 0.01847689488542624689997533414966483309447215407436491871358459093939287557878370422926170697737740157;
      _points[3] = 0.9836134192831531471583111074538475807123468436649234249764855640425604800025401439859187009319615024;
      _weight[3] = 0.01847689488542624689997533414966483309447215407436491871358459093939287557878370422926172175919579072;
      _points[4] = 0.03995033292479958560490643314251555292042619517588915141193225645450921846529608550413402431396548965;
      _weight[4] = 0.02856721271342860414181791323622397874564379841312802072125366171352452769982600404414322716617000998;
      _points[5] = 0.9600496670752004143950935668574844470795738048241108485880677435454907815347039144958659756860347123;
      _weight[5] = 0.02856721271342860414181791323622397874564379841312802072125366171352452769982600404414322962279680312;
      _points[6] = 0.9266816822916586418236253192937838351380529015896719853714958146971214531419175734861448185958476768;
      _weight[6] = 0.03805005681418965100852582665009158961307717621198301426073424290822675829330037499656830937779117347;
      _points[7] = 0.07331831770834135817637468070621616486194709841032801462850418530287854685808242651385518140415223744;
      _weight[7] = 0.03805005681418965100852582665009158961307717621198301426073424290822675829330037499656830966790713345;
      _points[8] = 0.1157800182621610456920610743468859825895116471143152245656366674849906287301494102064641704530676751;
      _weight[8] = 0.04672221172801693077664487055696604424176332368079642243334763581628894888685619367593429425889811223;
      _points[9] = 0.8842199817378389543079389256531140174104883528856847754343633325150093712698505897935358295469323533;
      _weight[9] = 0.04672221172801693077664487055696604424176332368079642243334763581628894888685619367593429445743788085;
      _points[10] = 0.833569402098706159652983334995169581298514671655701421237733541173597096557848147649755244281395587;
      _weight[10] = 0.05439864958357418883173728903505282101684979789692816527639104358448682188313469419058838120027728265;
      _points[11] = 0.1664305979012938403470166650048304187014853283442985787622664588264029034421518523502447557186044041;
      _weight[11] = 0.05439864958357418883173728903505282101684979789692816527639104358448682188313469419058838122180361033;
      _points[12] = 0.2241905820563900964704906016378433566889698878846601674978470802501976091441579814715095060504845149;
      _weight[12] = 0.06091570802686426709768358856286679917816881278076872512149190392137945061467548197097422700245561668;
      _points[13] = 0.7758094179436099035295093983621566433110301121153398325021529197498023908558420185284904939495154868;
      _weight[13] = 0.06091570802686426709768358856286679917816881278076872512149190392137945061467548197097422700249951898;
      _points[14] = 0.7121710601037193917868344442718940260482226159198172921121291179482434418394007784999360464569138182;
      _weight[14] = 0.06613446931666873089052628724838780216450577007157841160917516157589129928261519951184529780764479093;
      _points[15] = 0.2878289398962806082131655557281059739517773840801827078878708820517565581605992215000639535430861817;
      _weight[15] = 0.06613446931666873089052628724838780216450577007157841160917516157589129928261519951184529780764839634;
      _points[16] = 0.3559893415987994516996037419676998400454908681769833856228592376253775285290786160733304858198915867;
      _weight[16] = 0.06994369739553657736106671193379155544639658047745980218686566316212163123260307830816081080108004754;
      _points[17] = 0.6440106584012005483003962580323001599545091318230166143771407623746224714709213839266695141801084133;
      _weight[17] = 0.06994369739553657736106671193379155544639658047745980218686566316212163123260307830816081080108004754;
      _points[18] = 0.5727809270804475454685154911693431650581630122189688787107441949927736404416598988452579892191042265;
      _weight[18] = 0.07226220199498502953191358327687627180497498109854991737623649444304865467169593493263483293242601162;
      _points[19] = 0.4272190729195524545314845088306568349418369877810311212892558050072263595583401011547420107808957735;
      _weight[19] = 0.07226220199498502953191358327687627180497498109854991737623649444304865467169593493263483293242601162;
      _points[20] = 0.5;
      _weight[20] = 0.07304056682484521359599257384168559412240478847098272205366129375771929635169980596487109556323312786;
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = 0.002852707258800353963484289419350509803472900801984232511488537516671751147960044089614037111865173732;
      _weight[0] = 0.007313997649136100342495549023592722595105974562161865462248795710094053266374085571141880346311089378;
      _points[1] = 0.9971472927411996460365157105806494901965270991980157674885114624833282488520399559103859628881355814;
      _weight[1] = 0.007313997649136100342495549023592722595105974562161865462248795710094053266374085571141883008544226611;
      _points[2] = 0.9850302489177143635619754933826343554029844615689014847798691061681871303874212543187706773135177033;
      _weight[2] = 0.01688745079240707739665112343295645067458465723723733021644159727997575587653074419945745695676145639;
      _points[3] = 0.01496975108228563643802450661736564459701553843109851522013089383181286961257874568122932268648048749;
      _weight[3] = 0.01688745079240707739665112343295645067458465723723733021644159727997575587653074419945762155251412539;
      _points[4] = 0.03652161390641299973965353037047340168233517331397400897771340423643194044422943724815312357627569228;
      _weight[4] = 0.02614666757634164297015602563660562805607504678461815806135504164883817117996641239098413278077729423;
      _points[5] = 0.9634783860935870002603464696295265983176648266860259910222865957635680595557705627518468764237260872;
      _weight[5] = 0.02614666757634164297015602563660562805607504678461815806135504164883817117996641239098413540926935972;
      _points[6] = 0.9329062888601500682682128185096893645423983777942230780635466846313584474707602174042400781419289789;
      _weight[6] = 0.03489823421226024404748070946510882869938752647754026369315568588197320174364294701969641072525858542;
      _points[7] = 0.06709371113984993173178718149031063545760162220577692193645331536864155252923978259575992185807001107;
      _weight[7] = 0.03489823421226024404748070946510882869938752647754026369315568588197320174364294701969641451337550866;
      _points[8] = 0.8939084029896040810021389777041757606940893356657815790608466988555661381263540374500257594796665631;
      _weight[8] = 0.04297080310853386370722184068635143309457220267453989164328500552412301238656307871601112391536217695;
      _points[9] = 0.1060915970103959189978610222958242393059106643342184209391533011444338618736459625499742405203337798;
      _weight[9] = 0.04297080310853386370722184068635143309457220267453989164328500552412301238656307871601112573694851247;
      _points[10] = 0.1527563684066586099746550821188716143663288550112824194391331123038570301128534725802029426006947326;
      _weight[10] = 0.05020707222144048246603941891526814117540554438384981289248045717022654803711188637143031951500947387;
      _points[11] = 0.8472436315933413900253449178811283856336711449887175805608668876961429698871465274197970573993052051;
      _weight[11] = 0.05020707222144048246603941891526814117540554438384981289248045717022654803711188637143031963916383524;
      _points[12] = 0.7938202017534557964794384638193236744388078017868589198850169106862341889140221801795800526056382982;
      _weight[12] = 0.05646614804026960919670030371089215955713166606049735213629877312430656546180541682980244071096423847;
      _points[13] = 0.2061797982465442035205615361806763255611921982131410801149830893137658110859778198204199473943617058;
      _weight[13] = 0.05646614804026960919670030371089215955713166606049735213629877312430656546180541682980244071408393247;
      _points[14] = 0.2653220810066214867968346445167968269523281044346317261019499851532114926571816930628014255887449256;
      _weight[14] = 0.06162618840525621214278049307740723597972249950248398621421098594256775139958772701589012301716629665;
      _points[15] = 0.7346779189933785132031653554832031730476718955653682738980500148467885073428183069371985744112550745;
      _weight[15] = 0.06162618840525621214278049307740723597972249950248398621421098594256775139958772701589012301721118318;
      _points[16] = 0.3290320895539578874209262897863101902204133504146563280015688081554932805464265186717208013164783515;
      _weight[16] = 0.06558675239353118536648249626515372293787094709401532656268985171227230515676448704571705001653997614;
      _points[17] = 0.6709679104460421125790737102136898097795866495853436719984311918445067194535734813282791986835216485;
      _weight[17] = 0.06558675239353118536648249626515372293787094709401532656268985171227230515676448704571705001654039024;
      _points[18] = 0.603930213344110642739423266959772867107837554548966824834326652184100420657358832108299412062849607;
      _weight[18] = 0.06827074917300758567628691561575869829318382649434308405473486746910377908226891669049531646614901666;
      _points[19] = 0.396069786655889357260576733040227132892162445451033175165673347815899579342641167891700587937150393;
      _weight[19] = 0.06827074917300758567628691561575869829318382649434308405473486746910377908226891669049531646614901691;
      _points[20] = 0.5348696366598611106069208980593140409111481497401157373533409732558046868163197230382591971852169272;
      _weight[20] = 0.06962593642781599668770512417090497893696010872871292906309893853651885640938429814937374841202945705;
      _points[21] = 0.4651303633401388893930791019406859590888518502598842626466590267441953131836802769617408028147830728;
      _weight[21] = 0.06962593642781599668770512417090497893696010872871292906309893853651885640938429814937374841202945706;
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = 0.997384667498776061761962857722787180286813686229435210463396942083537039882892635091994572108193741;
      _weight[0] = 0.006705929743570886040654746729307532488309167052868616696197941069580443368026029924649341359469772762;
      _points[1] = 0.002615332501223938238037142277212819713186313770564789536603057916462960117107364908005427891809143873;
      _weight[1] = 0.006705929743570886040654746729307532488309167052868616696197941069580443368026029924649573769364960656;
      _points[2] = 0.01372876439094238402198796158961131240919310232301302875437192063210148141271179106629126712803738242;
      _weight[2] = 0.01549400292848972215534710982094225269188626449996403321744390329930889213143379600112464044475669166;
      _points[3] = 0.9862712356090576159780120384103886875908068976769869712456280793678985185872882089337087328719558227;
      _weight[3] = 0.01549400292848972215534710982094225269188626449996403321744390329930889213143379600112501966065445252;
      _points[4] = 0.9664855434130080511745984945192114891178509100756953853464506273009889144000435399565050359131567801;
      _weight[4] = 0.02401883586554233428582053581601699828060815415175580566684183343492904343740931457766543707359225583;
      _points[5] = 0.03351445658699194882540150548078851088214908992430461465354937269901108559995646004349496408684971031;
      _weight[5] = 0.02401883586554233428582053581601699828060815415175580566684183343492904343740931457766597672718701168;
      _points[6] = 0.06162382086477916631092155703292716418053548501967468254529944211972418064524202840071725243915325682;
      _weight[6] = 0.03211621070426292606358480757945549901957913787740341524767334102645877679039064170319606692512096974;
      _points[7] = 0.9383761791352208336890784429670728358194645149803253174547005578802758193547579715992827475608431633;
      _weight[7] = 0.03211621070426292606358480757945549901957913787740341524767334102645877679039064170319608117985608873;
      _points[8] = 0.09755579919058005392444079650161072102928493013484598870728378216414661991547532039245499830903712074;
      _weight[8] = 0.03964070588835947746144626237102161345685599596920325127781727016602150200687944126797677649047476588;
      _points[9] = 0.9024442008094199460755592034983892789707150698651540112927162178358533800845246796075450016909641157;
      _weight[9] = 0.03964070588835947746144626237102161345685599596920325127781727016602150200687944126797678878871689404;
      _points[10] = 0.8593306815659750972308122418743094241649648725656463978773906441070255643379628737551436279609732762;
      _weight[10] = 0.04645788303001757373850930868488232430173003587156494686632975230596864246779408039973782068126544426;
      _points[11] = 0.1406693184340249027691877581256905758350351274343536021226093558929744356620371262448563720390264527;
      _weight[11] = 0.04645788303001757373850930868488232430173003587156494686632975230596864246779408039973782150814728313;
      _points[12] = 0.1901950621181769218074513441752021733064096705964538521495672071954400967517765817297777471175290854;
      _weight[12] = 0.05244604573227070503704309250737192742923579159698750275141259616938968817102544494992821894515182282;
      _points[13] = 0.8098049378818230781925486558247978266935903294035461478504327928045599032482234182702222528824709511;
      _weight[13] = 0.05244604573227070503704309250737192742923579159698750275141259616938968817102544494992821895313919395;
      _points[14] = 0.7547507389230037748448965239334232152724213845924288116135946904106375025523832657533759938640108684;
      _weight[14] = 0.05749832011120568247082175646698065074570526146479280330453785170139979724187270361906533563745699839;
      _points[15] = 0.2452492610769962251551034760665767847275786154075711883864053095893624974476167342466240061359891292;
      _weight[15] = 0.05749832011120568247082175646698065074570526146479280330453785170139979724187270361906533563767227994;
      _points[16] = 0.3048494809848545842892555635596972707109745746537482593903973683416436919064837854106762368147562967;
      _weight[16] = 0.06152454215336476523378920033600482740792640627323528721783516645084523385389260275505301355895038264;
      _points[17] = 0.6951505190151454157107444364403027292890254253462517406096026316583563080935162145893237631852437032;
      _weight[17] = 0.06152454215336476523378920033600482740792640627323528721783516645084523385389260275505301355895211182;
      _points[18] = 0.6320678404851724652669347691416548014895066250970698024345394385261644267913360122890792643554668868;
      _weight[18] = 0.06445286109404107498929766969989682662985774859589174622217021585899473237800551787502302994595886119;
      _points[19] = 0.3679321595148275347330652308583451985104933749029301975654605614738355732086639877109207356445331132;
      _weight[19] = 0.06445286109404107498929766969989682662985774859589174622217021585899473237800551787502302994595887207;
      _points[20] = 0.4333715878507669445341286588791169314947973618733089217445273114064760550621727612127183682018242994;
      _weight[20] = 0.06623101970234830868582123235165846290251783473711176216125613401924300294133970283679005885397038903;
      _points[21] = 0.5666284121492330554658713411208830685052026381266910782554726885935239449378272387872816317981757006;
      _weight[21] = 0.06623101970234830868582123235165846290251783473711176216125613401924300294133970283679005885397038906;
      _points[22] = 0.5;
      _weight[22] = 0.06682728609305308767572855527292216929157640381844165874096798899572049042386144817957960350208853286;
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = 0.9975936099985106800899987048503684059372988462980014387208002725571419160347288689416986446685566286;
      _weight[0] = 0.006170614899993599773402833535018645787955020445683258408643660470545862758940556895899243366671187447;
      _points[1] = 0.002406390001489319910001295149631594062701153701998561279199727442858083965271131058301355331443605634;
      _weight[1] = 0.006170614899993599773402833535018645787955020445683258408643660470545862758940556895899519911713663779;
      _points[2] = 0.987364277985654749099195996504084530870591526520089359905796782553590560640490112269318737140860893;
      _weight[2] = 0.01426569431446683159065390797593914322459889896595405830083240237882200281871457171284068800097932645;
      _points[3] = 0.01263572201434525090080400349591546912940847347991064009420321744640943935950988773068126285913870873;
      _weight[3] = 0.01426569431446683159065390797593914322459889896595405830083240237882200281871457171284165660291838644;
      _points[4] = 0.03086272399863362073817549914563927517259017096127432668248641204520525197373216452001767923206867783;
      _weight[4] = 0.02213871940870990308430137410566911442965642091692894837069861486051218814113321981719642280218335366;
      _points[5] = 0.969137276001366379261824500854360724827409829038725673317513587954794748026267835479982320767931424;
      _weight[5] = 0.02213871940870990308430137410566911442965642091692894837069861486051218814113321981719673619811954492;
      _points[6] = 0.05679223649779948289342282900890162245633347834553997981448104161216258280052041394793824900190687327;
      _weight[6] = 0.02964929245771839037318387925005429227060006328260674551868827564704915158875412078303371109763423013;
      _points[7] = 0.943207763502200517106577170991098377543666521654460020185518958387837417199479586052061750998093307;
      _weight[7] = 0.02964929245771839037318387925005429227060006328260674551868827564704915158875412078303438091669549109;
      _points[8] = 0.08999900701304853902302506366512739596193676116607220637800948699930851052322272995886973941370905738;
      _weight[8] = 0.03667324070554015286701680762655825905966825492424973570135124533002069423793546741616252879754303569;
      _points[9] = 0.9100009929869514609769749363348726040380632388339277936219905130006914894767772700411302605862907671;
      _weight[9] = 0.03667324070554015286701680762655825905966825492424973570135124533002069423793546741616257681394130904;
      _points[10] = 0.8700620957892771821219140515499892127616462435070927284331911841359501693204614662206656780655647523;
      _weight[10] = 0.04309508076597663795859260149187133359254029411896650279420357193064344223039026563444432705548550264;
      _points[11] = 0.1299379042107228178780859484500107872383537564929072715668088158640498306795385337793343219344353201;
      _weight[11] = 0.04309508076597663795859260149187133359254029411896650279420357193064344223039026563444432809380918206;
      _points[12] = 0.8240468259684877846262478934553738133348291493094783901494668325122241587842698859640588851828635455;
      _weight[12] = 0.04880932605205694413494033223212357721395948442684297204165530501147716928879598917401001997704509176;
      _points[13] = 0.175953174031512215373752106544626186665170850690521609850533167487775841215730114035941114817136438;
      _weight[13] = 0.04880932605205694413494033223212357721395948442684297204165530501147716928879598917401002003817914148;
      _points[14] = 0.7727107356944197678291878086091861850053919962938090877168071949152824195897854485479174337204031353;
      _weight[14] = 0.05372213505798281739128867122330311139731434506711001088327082044341093319721855299029336355911190586;
      _points[15] = 0.2272892643055802321708121913908138149946080037061909122831928050847175804102145514520825662795968657;
      _weight[15] = 0.05372213505798281739128867122330311139731434506711001088327082044341093319721855299029336356007551697;
      _points[16] = 0.7168967538130225692435421159566748562262107554639844040404006423283822035168154570288677152330378081;
      _weight[16] = 0.05775283402686280067667224195339177993113515568824823529222468004433512677565927497017212882338315957;
      _points[17] = 0.2831032461869774307564578840433251437737892445360155959595993576716177964831845429711322847669621927;
      _weight[17] = 0.05775283402686280067667224195339177993113515568824823529222468004433512677565927497017212882339235575;
      _points[18] = 0.3424786601519183128066033543400948796067608695875913656228849352350589218293782958280632452223958946;
      _weight[18] = 0.06083523646390169560223157673813121280351477960190288938873587725631269685885848095887890171538627273;
      _points[19] = 0.6575213398480816871933966456599051203932391304124086343771150647649410781706217041719367547776041053;
      _weight[19] = 0.06083523646390169560223157673813121280351477960190288938873587725631269685885848095887890171538658359;
      _points[20] = 0.5955594337368081545793199103785348159202025516573766780744592882940429763459358709912455556226048654;
      _weight[20] = 0.06291872817341414806068769125559184436320166279067270208904575844069693633333129844101908962821056986;
      _points[21] = 0.4044405662631918454206800896214651840797974483426233219255407117059570236540641290087544443773951346;
      _weight[21] = 0.06291872817341414806068769125559184436320166279067270208904575844069693633333129844101908962821056988;
      _points[22] = 0.5320284464313028130425215413123725192954995977103736967121755408948696417969550539014464380671262546;
      _weight[22] = 0.06396909767337607848702808261234768592585561977083394121064978818617379577026820120604598878336737117;
      _points[23] = 0.4679715535686971869574784586876274807045004022896263032878244591051303582030449460985535619328737454;
      _weight[23] = 0.06396909767337607848702808261234768592585561977083394121064978818617379577026820120604598878336737117;
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = 0.9977784848952490489543924734469508086287813247024040856054024655664667406718639672436440131764693153;
      _weight[0] = 0.005696899250513143973951482056617386801660263146454848224474030558094945864883371677963556787448376476;
      _points[1] = 0.00222151510475095104560752655304919137121867529759591439459753443353325932813603275635598682353248497;
      _weight[1] = 0.005696899250513143973951482056617386801660263146454848224474030558094945864883371677965811475059758741;
      _points[2] = 0.01166803927024124425084230676020296612731472234279662766450628634191806623205972305177664525848306765;
      _weight[2] = 0.01317749330751606863095090764764957246798164085166123437768308289193546700443974968576767635766725226;
      _points[3] = 0.9883319607297587557491576932397970338726852776572033723354937136580819337679402769482233547415133449;
      _weight[3] = 0.01317749330751606863095090764764957246798164085166123437768308289193546700443974968577242932413311562;
      _points[4] = 0.9714872856144871697070055848292352659526007853044950709637262485686476612720246306544526090756260955;
      _weight[4] = 0.02046957835065315632781174385582297683042289168205217325234920744964871644010775638523527067391420037;
      _points[5] = 0.02851271438551283029299441517076473404739921469550492903627375143135233872797536934554739092437612273;
      _weight[5] = 0.02046957835065315632781174385582297683042289168205217325234920744964871644010775638524604173635510725;
      _points[6] = 0.05250400106086231557447899660859752291272257512320804846914915852041424454940027431440699653479712593;
      _weight[6] = 0.02745234798791759596296844577023666208005499277655567452425424912229688733921825594785529844095563499;
      _points[7] = 0.9474959989391376844255210033914024770872774248767919515308508414795857554505997256855930034652027271;
      _weight[7] = 0.02745234798791759596296844577023666208005499277655567452425424912229688733921825594785796307473275137;
      _points[8] = 0.9167213143804170007105105543467847847304820569117603930104323577308590662385450626266148697387927944;
      _weight[8] = 0.03401916690617845860359359282835398427735474717731828130753561320500182702585573655332580227175966452;
      _points[9] = 0.08327868561958299928948944565321521526951794308823960698956764226914093376145493737338513026120669813;
      _weight[9] = 0.03401916690617845860359359282835398427735474717731828130753561320500182702585573655332604122774719797;
      _points[10] = 0.1203703684813211847113585673978195118062389905508329395408051322774906855898687961961816013790731491;
      _weight[10] = 0.04007035016750050900661747983455565114511286642683794685810073148680641446740064477972868629207952781;
      _points[11] = 0.8796296315186788152886414326021804881937610094491670604591948677225093144101312038038183986209271367;
      _weight[11] = 0.04007035016750050900661747983455565114511286642683794685810073148680641446740064477972869753838111488;
      _points[12] = 0.1632168157632658177574396833761889120582916359636253414701715191108561315753578942090181571598454979;
      _weight[12] = 0.04551413099148182490574861035144582669049627947966715548524188448350869233920526345124219761526968488;
      _points[13] = 0.836783184236734182242560316623811087941708364036374658529828480889143868424642105790981842840154432;
      _weight[13] = 0.04551413099148182490574861035144582669049627947966715548524188448350869233920526345124219865109678983;
      _points[14] = 0.2111685348793885161381550791936729663021324803542408716772582461194884936236839888616417017671017262;
      _weight[14] = 0.05026797453352532210110344519634291349423304726407095353493452099970647407952301484097782805516032632;
      _points[15] = 0.7888314651206114838618449208063270336978675196457591283227417538805115063763160111383582982328982821;
      _weight[15] = 0.0502679745335253221011034451963429134942330472640709535349345209997064740795230148409778280886849818;
      _points[16] = 0.2634986342771425197389089424954039793340911307691863545463845861521983620793569849484215761086031856;
      _weight[16] = 0.05425981223713182655804697852505830967003879399336100807824715367441964639680422134669884175019772201;
      _points[17] = 0.7365013657228574802610910575045960206659088692308136454536154138478016379206430150515784238913968136;
      _weight[17] = 0.05425981223713182655804697852505830967003879399336100807824715367441964639680422134669884175027469118;
      _points[18] = 0.6805861529046939188679108650638203337110391735216875348972893889233726911978482743016476575304688072;
      _weight[18] = 0.05742912957285582416966277293477790432046809583409007479575749501574139833556271128267214949278988798;
      _points[19] = 0.319413847095306081132089134936179666288960826478312465102710611076627308802151725698352342469531193;
      _weight[19] = 0.05742912957285582416966277293477790432046809583409007479575749501574139833556271128267214949279150727;
      _points[20] = 0.6219334418604942160225951813987257932028165781629922382105678266251937363929279753398881838816251703;
      _weight[20] = 0.05972788176789238611408906325645052369508835070686321275979394066759204511009386751221434860487635927;
      _points[21] = 0.3780665581395057839774048186012742067971834218370077617894321733748062636070720246601118161183748297;
      _weight[21] = 0.05972788176789238611408906325645052369508835070686321275979394066759204511009386751221434860487637172;
      _points[22] = 0.5614323463053551981936799094040184027661026730248918692119467689463544174844292079132194249731655277;
      _weight[22] = 0.06112122149515502084447975947292575291752962378152952045379004111601948360959005121516770445539453314;
      _points[23] = 0.4385676536946448018063200905959815972338973269751081307880532310536455825155707920867805750268344723;
      _weight[23] = 0.06112122149515502084447975947292575291752962378152952045379004111601948360959005121516770445539453319;
      _points[24] = 0.5;
      _weight[24] = 0.06158802686335772560195143653952507121911681375907583269567609865845600397463071064230056258752479189;
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = 0.002057149427191535498391520338546987021571072440220166301736095297216851683361096774046705971591914138;
      _weight[0] = 0.005275686308671503577825593842625988952172868589847307275027713818381611146754875672203017278562745882;
      _points[1] = 0.9979428505728084645016084796614530129784289275597798336982639047027831483166389032259532940283980829;
      _weight[1] = 0.005275686308671503577825593842625988952172868589847307275027713818381611146754875672222096535931991352;
      _points[2] = 0.9891927229782354955502901771559631527234582818736592512427074306582525753725062356694672106206098011;
      _weight[2] = 0.01220892554631595439480791375989420012024796309863517102602344753784585784943394482692276794975351226;
      _points[3] = 0.01080727702176450444970982284403684727654171812634074875729256934174742462749376433053278937941302212;
      _weight[3] = 0.01220892554631595439480791375989420012024796309863517102602344753784585784943394482692590062619002023;
      _points[4] = 0.9735795333308571250679576417590183772603551688421576350091338898049288222262304038853530988756546694;
      _weight[4] = 0.01898119164718138197515157062442524734538521087202447883765591232640395020816792394092103666682741212;
      _points[5] = 0.02642046666914287493204235824098162273964483115784236499086611019507117777376959611464690112432590056;
      _weight[5] = 0.01898119164718138197515157062442524734538521087202447883765591232640395020816792394092953156322980776;
      _points[6] = 0.9513189309921535371088327996156051256705620026864526862775828273897328995512729934288304151250970431;
      _weight[6] = 0.02548791264857390599915995036203668976293965927148596741191884299970865622501582259468003159778249186;
      _points[7] = 0.04868106900784646289116720038439487432943799731354731372241717261026710044872700657116958487490989121;
      _weight[7] = 0.02548791264857390599915995036203668976293965927148596741191884299970865622501582259469676675396512358;
      _points[8] = 0.07727702860575099060124646926608091921396244895433521528491176354419154266438185252492621891031580747;
      _weight[8] = 0.03163702316478741776972684495352254786111142100634725533304794330399419585613801383092451868449629648;
      _points[9] = 0.9227229713942490093987535307339190807860375510456647847150882364558084573356181474750737810896852668;
      _weight[9] = 0.0316370231647874177697268449535225478611114210063472553330479433039941958561380138309268591934534817;
      _points[10] = 0.1118070255896605719035163763788580665118908718724025639184157891864835356795866770152894361720024268;
      _weight[10] = 0.03734207488282987294353789805142416931937358094052034038951542087140981540468873148337639510000187901;
      _points[11] = 0.8881929744103394280964836236211419334881091281275974360815842108135164643204133229847105638279954159;
      _weight[11] = 0.03734207488282987294353789805142416931937358094052034038951542087140981540468873148337657126474272665;
      _points[12] = 0.8482136302099786324319069568647123489303766588954095758522787269191802734979190143979569224436633356;
      _weight[12] = 0.04252294715674261960522388253999084829196015838833913809302809070999389600765276409114327132632335978;
      _points[13] = 0.151786369790021367568093043135287651069623341104590424147721273080819726502080985602043077556337607;
      _weight[13] = 0.04252294715674261960522388253999084829196015838833913809302809070999389600765276409114329640288988689;
      _points[14] = 0.1966538534911909683840106265415564727823677138670450548106783437400359365548733997670835956949944863;
      _weight[14] = 0.04710690017795707423183244153365159927458287295710363993165745118401724964172710566666105228365478843;
      _points[15] = 0.8033461465088090316159893734584435272176322861329549451893216562599640634451266002329164043050053082;
      _weight[15] = 0.04710690017795707423183244153365159927458287295710363993165745118401724964172710566666105283897288388;
      _points[16] = 0.7542203574122528588478515323627845876881533770928754068605502348019636974646783451170112711373754115;
      _weight[16] = 0.05102958054721271161920703512671539616360440567712100516593690970432633440273700128534590714780195155;
      _points[17] = 0.2457796425877471411521484676372154123118466229071245931394497651980363025353216548829887288626246107;
      _weight[17] = 0.05102958054721271161920703512671539616360440567712100516593690970432633440273700128534590715187806242;
      _points[18] = 0.2984741224382568467594613114505584481700312951503419087054294332259078914763146734751210244027963381;
      _weight[18] = 0.0542359202642882953282897133639987911447191017106533222648028543047306996364527919847157957602897432;
      _points[19] = 0.7015258775617431532405386885494415518299687048496580912945705667740921085236853265248789755972036612;
      _weight[19] = 0.05423592026428829532828971336399879114471910171065332226480285430473069963645279198471579576032138823;
      _points[20] = 0.3539975802570215524285823089610848515576403065185048108938279040481491877109960462088021476536134262;
      _weight[20] = 0.05668090827315983327472035922129907262297518146250760699414396494374455328228972724632422646792560352;
      _points[21] = 0.6460024197429784475714176910389151484423596934814951891061720959518508122890039537911978523463865738;
      _weight[21] = 0.05668090827315983327472035922129907262297518146250760699414396494374455328228972724632422646792609764;
      _points[22] = 0.4115705898215549080154711257908276250113081180993678692598261501079773599722919564411924558682029493;
      _weight[22] = 0.05833022174264829102233125377018110681598244061096210823008134860563283296415986325634816982250102892;
      _points[23] = 0.5884294101784450919845288742091723749886918819006321307401738498920226400277080435588075441317970507;
      _weight[23] = 0.05833022174264829102233125377018110681598244061096210823008134860563283296415986325634816982250102892;
      _points[24] = 0.5296150467146566035468592875992016803951173676945177910771361458421935180599867101692053134428938839;
      _weight[24] = 0.05916070763963113825818554285023434232494513541445265904716009968981034737478143412042810703364070916;
      _points[25] = 0.4703849532853433964531407124007983196048826323054822089228638541578064819400132898307946865571061161;
      _weight[25] = 0.05916070763963113825818554285023434232494513541445265904716009968981034737478143412042810703364070916;
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = 0.001910368555505716530556395809385004869655972217064406149181751605891127211337093955618976639176052996;
      _weight[0] = 0.004899498025647180130575027545629549049112909467545796084070202282931315208834056077691434852954585551;
      _points[1] = 0.9980896314444942834694436041906149951303440277829355938508182483941088727886629060443810233608259815;
      _weight[1] = 0.004899498025647180130575027545629549049112909467545796084070202282931315208834056077753240245468294788;
      _points[2] = 0.01003826201924938857206332216947640771617888930502461838057005347380871200989052684729151220284212677;
      _weight[2] = 0.01134311579809031159801710322338074440638386014408317781572106511953791501790501107707508572996524597;
      _points[3] = 0.9899617379807506114279366778305235922838211106949753816194299465261912879901094731527084877971586194;
      _weight[3] = 0.01134311579809031159801710322338074440638386014408317781572106511953791501790501107742569568707400832;
      _points[4] = 0.9754502789073525034259540153219414465462949667422088254669086953936933344049557428958097932983624977;
      _weight[4] = 0.01764852687870985551128914465235582056806944476147090579111389254745441331417783144208520625011731365;
      _points[5] = 0.02454972109264749657404598467805855345370503325779117453309130460630666559504425710419020670162446147;
      _weight[5] = 0.01764852687870985551128914465235582056806944476147090579111389254745441331417783144210401009766964174;
      _points[6] = 0.9547411603387455521503225091048446274740221677974804795566137762360281331762640112274766026251394194;
      _weight[6] = 0.02372470626030753135204835505709235911236281008309236425865500633458910592851796202108612874571502525;
      _points[7] = 0.04525883966125444784967749089515537252597783220251952044338622376397186682373598877252339737488204539;
      _weight[7] = 0.02372470626030753135204835505709235911236281008309236425865500633458910592851796202114102641702143869;
      _points[8] = 0.9281039540091472451513686113534213988821434993017529134885948270644016596929044902648783426521190244;
      _weight[8] = 0.02949176842991679955515041685976581658262029535320608127010760745691056483180227669210348485634524415;
      _points[9] = 0.07189604599085275484863138864657860111785650069824708651140517293559834030709550973512165734786335432;
      _weight[9] = 0.02949176842991679955515041685976581658262029535320608127010760745691056483180227669212110937924323569;
      _points[10] = 0.1041141804647458864278013279463646335402994671260682437963596939765897575631027349407405614340916029;
      _weight[10] = 0.03487441188312279649216144417833363806641234662847600018870939081052967940428179133628125012015134327;
      _points[11] = 0.8958858195352541135721986720536353664597005328739317562036403060234102424368972650592594385659169024;
      _weight[11] = 0.03487441188312279649216144417833363806641234662847600018870939081052967940428179133628233232240947058;
      _points[12] = 0.1414932631302881503525918941788302251246639739507184286743918968321525838419328333124890452720638476;
      _weight[12] = 0.03980243388652888563153747950492120148807333649350147570670438190137636322061009657571262463250792362;
      _points[13] = 0.8585067368697118496474081058211697748753360260492815713256081031678474161580671666875109547279336968;
      _weight[13] = 0.03980243388652888563153747950492120148807333649350147570670438190137636322061009657571264732060672834;
      _points[14] = 0.8164539859732475704638673188172443060515380087846683486475559495117003454985408900102633473248019569;
      _weight[14] = 0.04421157927187847509716140142687455552826837502554955490293556854829634959572854374441794903265292647;
      _points[15] = 0.1835460140267524295361326811827556939484619912153316513524440504882996545014591099897366526751984366;
      _weight[15] = 0.0442115792718784750971614014268745555282683750255495549029355685482963495957285437444179516937253006;
      _points[16] = 0.7702757822897284474501504707799914104795902244935908451871688750179704483581906127122403416472846593;
      _weight[16] = 0.04804436368501425378282632327905292958010581476851466721406555676700756739190327262980465263698979581;
      _points[17] = 0.2297242177102715525498495292200085895204097755064091548128311249820295516418093872877596583527153147;
      _weight[17] = 0.04804436368501425378282632327905292958010581476851466721406555676700756739190327262980465271829088215;
      _points[18] = 0.7205741258750134402929870778446407262238422975815496940726936067016003481397479590425318969605111507;
      _weight[18] = 0.05125081890887289933562385576633190466220494745735866493489091619149373974629794637200532992800577459;
      _points[19] = 0.2794258741249865597070129221553592737761577024184503059273063932983996518602520409574681030394888488;
      _weight[19] = 0.05125081890887289933562385576633190466220494745735866493489091619149373974629794637200532992840251648;
      _points[20] = 0.6679969518192544498651595171036422708950100094537970953624933535475046614272798926175690236905281402;
      _weight[20] = 0.05378914289426659360608149221332870240948304953188233275617945325759724607200991384577327794535374829;
      _points[21] = 0.3320030481807455501348404828963577291049899905462029046375066464524953385727201073824309763094718599;
      _weight[21] = 0.05378914289426659360608149221332870240948304953188233275617945325759724607200991384577327794535376847;
      _points[22] = 0.3867703172802315705713804463198849144102766335358981616766855014081114331134964348872204676390168474;
      _weight[22] = 0.05562624417842259633608154802142433741646019004254163354820175484896603913565917187623706977023691306;
      _points[23] = 0.6132296827197684294286195536801150855897233664641018383233144985918885668865035651127795323609831526;
      _weight[23] = 0.05562624417842259633608154802142433741646019004254163354820175484896603913565917187623706977023693234;
      _points[24] = 0.5569862928047649834664474919349883135866402669890704973828769548831827443942053726981897403198983148;
      _weight[24] = 0.05673817305448257431018497404604962896026225940523601294820827478851116979698381328179598174896188868;
      _points[25] = 0.4430137071952350165335525080650116864133597330109295026171230451168172556057946273018102596801016852;
      _weight[25] = 0.05673817305448257431018497404604962896026225940523601294820827478851116979698381328179598174896188868;
      _points[26] = 0.5;
      _weight[26] = 0.05711043368947849452252286845091762434036072167508266516087385828959706267057662605513742154892559577;
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = 0.9982212487869772249752181952416554958750652160482129522928361647452421094805343626603577033042341754;
      _weight[0] = 0.004562141296547258869408076961475853120172245549145499708369845661949729932899064572236480217464936533;
      _points[1] = 0.001778751213022775024781804758344504124934783951787047707163835254757890519465637339642296695770837121;
      _weight[1] = 0.004562141296547258869408076961475853120172245549145499708369845661949729932899064572526563822056534335;
      _points[2] = 0.009348417314563623152720027096084861777922523373430845161987159270635774039111600249036536472313720156;
      _weight[2] = 0.01056605629638562987575019049663271722568467536164281889883424512553257787678854598195646787921082855;
      _points[3] = 0.9906515826854363768472799729039151382220774766265691548380128407293642259608883997509634635276713864;
      _weight[3] = 0.01056605629638562987575019049663271722568467536164281889883424512553257787678854598300882424950004705;
      _points[4] = 0.02287035968553090137294908014739220549829806295602416229264277568808467970208460056959184723562776574;
      _weight[4] = 0.01645071389115218998881540958526602299076540871004859392963081030188231834630637036053429300942080203;
      _points[5] = 0.9771296403144690986270509198526077945017019370439758377073572243119153202979153994304081527643931369;
      _weight[5] = 0.01645071389115218998881540958526602299076540871004859392963081030188231834630637036091886542410802276;
      _points[6] = 0.9578165131960660369348447116649635731762483976045607543307501223015040892535203600513990741767643359;
      _weight[6] = 0.0221364673795021139197939388266036953074970563542834218575735309421120888068499657459498897458583356;
      _points[7] = 0.0421834868039339630651552883350364268237516023954392456692498776984959107464796399486009258232168588;
      _weight[7] = 0.02213646737950211391979393882660369530749705635428342185757353094211208880684996574697771782818581975;
      _points[8] = 0.06705373871280247552887271631015659782906858460788683151122663349165279571743880703871341595766224915;
      _weight[8] = 0.02755367283785837271574145911347279560952898211283269420344637698647131160967129884318854047272566957;
      _points[9] = 0.9329462612871975244711272836898434021709314153921131684887733665083472042825611929612865840423488529;
      _weight[9] = 0.02755367283785837271574145911347279560952898211283269420344637698647131160967129884338434412610919579;
      _points[10] = 0.902820685458589585723942977712638829335850707404155834105343580890194771630436017399200517149107126;
      _weight[10] = 0.03263646198349979789669878338775231817681771558130351316774240907603844736949397023700131832114238009;
      _points[11] = 0.09717931454141041427605702228736117066414929259584416589465641910980522836956398260079948285088883028;
      _weight[11] = 0.03263646198349979789669878338775231817681771558130351316774240907603844736949397023700859662540316838;
      _points[12] = 0.8678054390068158860140722551462671840080305099965209466142638881679056292346650954667042208312744222;
      _weight[12] = 0.03732310711728438951196594358651101901081793060316672371966002810748192103268864967435680304363377329;
      _points[13] = 0.1321945609931841139859277448537328159919694900034790533857361118320943707653349045332957791687263386;
      _weight[13] = 0.0373231071172843895119659435865110190108179306031667237196600281074819210326886496743589656272682794;
      _points[14] = 0.8283255470194324806099490882533714107848008451249649809158517487479251504918128910941778006375064516;
      _weight[14] = 0.04155670861445060919519824912216623993056720672192566649817783586627122641301714237517143947408073117;
      _points[15] = 0.171674452980567519390050911746628589215199154875035019084148251252074849508187108905822199362493522;
      _weight[15] = 0.04155670861445060919519824912216623993056720672192566649817783586627122641301714237517145385645260117;
      _points[16] = 0.2151397640942991403459983583217845334376436571716763860899851611688926236813584997474581943081317975;
      _weight[16] = 0.04528587219651642047109301566839206491142874272724243618793426692722835773337135218283108917063664998;
      _points[17] = 0.7848602359057008596540016416782154665623563428283236139100148388311073763186415002525418056918681942;
      _weight[17] = 0.04528587219651642047109301566839206491142874272724243618793426692722835773337135218283109040639983369;
      _points[18] = 0.262062887522440869482794076166282978686391927310672024295443653528363812900513554436429402188325273;
      _weight[18] = 0.04846532899896495792524450304772030088251656167823080247843814090718469703877365354821424384893553832;
      _points[19] = 0.7379371124775591305172059238337170213136080726893279757045563464716361870994864455635705978116747257;
      _weight[19] = 0.04846532899896495792524450304772030088251656167823080247843814090718469703877365354821424385463743862;
      _points[20] = 0.688125758044539355110678604778043491435846988521611455172176360196915859421478201914138666867737561;
      _weight[20] = 0.05105648378903038490710831925285606752329000117896027046698772610142319921851682034903030485135373313;
      _points[21] = 0.3118742419554606448893213952219565085641530114783885448278236398030841405785217980858613331322624396;
      _weight[21] = 0.05105648378903038490710831925285606752329000117896027046698772610142319921851682034903030485137455679;
      _points[22] = 0.363969186182410961161586821937115132587619351653238523750162036748778829879543151606605536872026769;
      _weight[22] = 0.05302788296142320895520821849840541439496148134257975841531014814296125636970519336941207124174814022;
      _points[23] = 0.636030813817589038838413178062884867412380648346761476249837963251221170120456848393394463127973231;
      _weight[23] = 0.05302788296142320895520821849840541439496148134257975841531014814296125636970519336941207124174827441;
      _points[24] = 0.5822846410666903856407358889455827285728627078005840882471428133476659252378482239091221824898926037;
      _weight[24] = 0.05435559612914706762678575965183668393763922733302198382856058523865666319156439405412133157517785174;
      _points[25] = 0.4177153589333096143592641110544172714271372921994159117528571866523340747621517760908778175101073963;
      _weight[25] = 0.05435559612914706762678575965183668393763922733302198382856058523865666319156439405412133157517785209;
      _points[26] = 0.5275396449420171352132582636709399889253979955304168418726692936294472722671537883242063627327149899;
      _weight[26] = 0.05502350650823759814118813280090880697831276474561581663933405061480620506035357870344563338891741859;
      _points[27] = 0.4724603550579828647867417363290600110746020044695831581273307063705527277328462116757936372672850101;
      _weight[27] = 0.05502350650823759814118813280090880697831276474561581663933405061480620506035357870344563338891741859;
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = 0.001660278869701706918404233725323057174113273374559998900921338121607207002790127831238018210105691685;
      _weight[0] = 0.004258451939373204827131906651124901501199444899259243026215047279732645793902882416561761178003708122;
      _points[1] = 0.9983397211302982930815957662746769428258867266254400010990786618783927929972098721687619817900013044;
      _weight[1] = 0.00425845193937320482713190665112490150119944489925924302621504727973264579390288241744535539018274769;
      _points[2] = 0.991272752630706587435463007893188478053390974453215779512560045723336292857815191776086317357309087;
      _weight[2] = 0.0098660425280613529919299008201978155748032840951807938280269223376721781694305564537882256883305202;
      _points[3] = 0.008727247369293412564536992106811521946609025546784220487439954276663707142184808223913682642415212693;
      _weight[3] = 0.00986604252806135299192990082019781557480328409518079382802692233767217816943055646072225404451223492;
      _points[4] = 0.02135720211095613710089598150958821813122022302295146471823518192332919792283790106899735207110017006;
      _weight[4] = 0.0153702461010468113222042626873083748735581304843547551610421796831758162179478083469863767119774409;
      _points[5] = 0.9786427978890438628991040184904117818687797769770485352817648180766708020771620989310026479292115706;
      _weight[5] = 0.01537024610104681132220426268730837487355813048435475516104217968317581621794780836139798196132962266;
      _points[6] = 0.03940988352347060745312328195844678729558032834385320076550426809702499335777486268074240653069993902;
      _weight[6] = 0.02070103125934141805241500505703846076674539019428719862896243971739621852818551853953495319631759502;
      _points[7] = 0.9605901164765293925468767180415532127044196716561467992344957319029750066422251373192575934690763516;
      _weight[7] = 0.02070103125934141805241500505703846076674539019428719862896243971739621852818551853984171415670102727;
      _points[8] = 0.06268109753994860479110328937171072654469156844047931463638958564262908145684442658053764847935897777;
      _weight[8] = 0.02579741345124896195629719058977129895981105532307103384093141566365206014644921025462052127950351516;
      _points[9] = 0.9373189024600513952088967106282892734553084315595206853636104143573709185431555734194623515207548012;
      _weight[9] = 0.02579741345124896195629719058977129895981105532307103384093141566365206014644921025527067660590528598;
      _points[10] = 0.09090725619237377750521389271060751218498921905885311443148286385234173733221244639847037110258048705;
      _weight[10] = 0.0306015453285395692710549240119535224620322698895651041589387060559972220376777554907964141556590276;
      _points[11] = 0.9090927438076262224947861072893924878150107809411468855685171361476582626677875536015296288973760434;
      _weight[11] = 0.03060154532853956927105492401195352246203226988956510415893870605599722203767775549082120815892355311;
      _points[12] = 0.8762314258672385669563050386060690951062959841144933042059989957623460653588429567443031613856582753;
      _weight[12] = 0.03505896662752563928479074347443958655119744433738679095740371243000397857149125882037553337678302389;
      _points[13] = 0.1237685741327614330436949613939309048937040158855066957940010042376539346411570432556968386143545099;
      _weight[13] = 0.03505896662752563928479074347443958655119744433738679095740371243000397857149125882037823722445054435;
      _points[14] = 0.1608927311986567424219074973040070368058685349926774186380950705253167483999159884580950739648692351;
      _weight[14] = 0.03911916356788189191407244432984016568343953847983485473378759766238027210361614738466142952885046597;
      _points[15] = 0.8391072688013432575780925026959929631941314650073225813619049294746832516000840115419049260351279701;
      _weight[15] = 0.03911916356788189191407244432984016568343953847983485473378759766238027210361614738466173188057738515;
      _points[16] = 0.7981408985691139101897931055944948900390934051927888192367311966151714169808699492956273492244185209;
      _weight[16] = 0.04273612868308626377267242464860403569084912830679669766094537169121599627783617681021242154028807844;
      _points[17] = 0.2018591014308860898102068944055051099609065948072111807632688033848285830191300507043726507755818786;
      _weight[17] = 0.042736128683086263772672424648604035690849128306796697660945371691215996277836176810212423235581571;
      _points[18] = 0.753796477562113821051313959813760076675611920192292082092532153549107183181318411159590233645317137;
      _weight[18] = 0.04586887856962938167398320553855540344911451049097728563791493734934686215774724755050591362461630883;
      _points[19] = 0.2462035224378861789486860401862399233243880798077079179074678464508928168186815888404097663546828384;
      _weight[19] = 0.04586887856962938167398320553855540344911451049097728563791493734934686215774724755050591365107221208;
      _points[20] = 0.2934235559129956680546467069841915883382807406318430401108076673728583268940136014749802695368964944;
      _weight[20] = 0.04848191704720430315095003744134437958817813896090178213024773337311643895088929114457563589694005033;
      _points[21] = 0.7065764440870043319453532930158084116617192593681569598891923326271416731059863985250197304631035028;
      _weight[21] = 0.04848191704720430315095003744134437958817813896090178213024773337311643895088929114457563589714280829;
      _points[22] = 0.6570158189338199674740979615955237241292244095454137406483794654472233487147167212702577337526900784;
      _weight[22] = 0.0505456368799574830609102734537486818237836394262625995614160116528885101846129027944658327169071752;
      _points[23] = 0.3429841810661800325259020384044762758707755904545862593516205345527766512852832787297422662473099228;
      _weight[23] = 0.05054563687995748306091027345374868182378363942626259956141601165288851018461290279446583271690743738;
      _points[24] = 0.6056761430830005372531878644514687495283254088560475740192004226610294555540058890492892141022582066;
      _weight[24] = 0.05203665503886468695666423564256003445532611033773384582184702707394015054274691957461250068566735182;
      _points[25] = 0.3943238569169994627468121355485312504716745911439524259807995773389705444459941109507107858977417932;
      _weight[25] = 0.05203665503886468695666423564256003445532611033773384582184702707394015054274691957461250068566737544;
      _points[26] = 0.5531391150663396150854911962151884904585977196478035681428876370110826718757923204715022303102827086;
      _weight[26] = 0.05293807754866047070329566392609394653741565687113901991407767276251131908456972819198550959864424907;
      _points[27] = 0.4468608849336603849145088037848115095414022803521964318571123629889173281242076795284977696897172914;
      _weight[27] = 0.05293807754866047070329566392609394653741565687113901991407767276251131908456972819198550959864424907;
      _points[28] = 0.5;
      _weight[28] = 0.05323969085915712212325556345483878416509251580649798987648645053394066246579319242238732282325525218;
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = 0.9984467420373247701358150254593476416704410190588753950540471489011938476050818704079410097787617413;
      _weight[0] = 0.003984096248083302807732941737336811225240348293575860614742581678460019216450666634479433344457437239;
      _points[1] = 0.001553257962675229864184974540652358329558980941124604945952851098806152394918129592058990221182733242;
      _weight[1] = 0.003984096248083302807732941737336811225240348293575860614742581678460019216450666642188026814968437855;
      _points[2] = 0.008165938360126395014983709197168599029841072645144318241409994924427852317604478148962014169242317633;
      _weight[2] = 0.009233234155545479571151065956023634548103266984090701685649182757292799760653986755450699432333341509;
      _points[3] = 0.9918340616398736049850162908028314009701589273548556817585900050755721476823955218510379858309033031;
      _weight[3] = 0.009233234155545479571151065956023634548103266984090701685649182757292799760653986815792453169513453224;
      _points[4] = 0.0199890675158462438915644872091011685348203912980383002571691637875300211464657853864052781488233464;
      _weight[4] = 0.01439235394166168467485958980564602181979444727314374823709006130407299447000696654140593213314494214;
      _points[5] = 0.9800109324841537561084355127908988314651796087019616997428308362124699788535342146135947218510085378;
      _weight[5] = 0.01439235394166168467485958980564602181979444727314374823709006130407299447000696660670929023709229111;
      _points[6] = 0.03689997628536283706033786145976299795676273158733546954448143316028850217444883659161355992412324619;
      _weight[6] = 0.01939959628481352479840096822317384601660048838319767605386639485297348547638489696037231540825839766;
      _points[7] = 0.9631000237146371629396621385402370020432372684126645304555185668397114978255511634083864400759978334;
      _weight[7] = 0.01939959628481352479840096822317384601660048838319767605386639485297348547638489696454661377310503722;
      _points[8] = 0.9412802678960263407715582312651127950283445735732421160341630265608081313475958278646079191424468346;
      _weight[8] = 0.02420133641529702645146907021140375890763590459868636817259596839590271283855107639963466400268558322;
      _points[9] = 0.05871973210397365922844176873488720497165542642675788396583697343919186865240417213539208085749427117;
      _weight[9] = 0.02420133641529702645146907021140375890763590459868636817259596839590271283855107640314816261043103779;
      _points[10] = 0.0852171188086158012785509401337490417804656519148291605965235082731717467052091824585237782457661204;
      _weight[10] = 0.02874657810880953324086084470102806439856033536088156727435789950161607370497718846308085054974539156;
      _points[11] = 0.9147828811913841987214490598662509582195343480851708394034764917268282532947908175414762217542537747;
      _weight[11] = 0.02874657810880953324086084470102806439856033536088156727435789950161607370497718846308397388938158375;
      _points[12] = 0.8838887160524130974589886704872515658474418086164542266032471936825792850864975225263048012930588557;
      _weight[12] = 0.03298711494109024756406425755798118061872147682833018948351575802107183623304708968291271722923362495;
      _points[13] = 0.1161112839475869025410113295127484341525581913835457733967528063174207149135024774736951987069361996;
      _weight[13] = 0.03298711494109024756406425755798118061872147682833018948351575802107183623304708968296127720974999476;
      _points[14] = 0.8489252473966578984661461940133200341911769003269773281898614233699883606215799803476908182200597426;
      _weight[14] = 0.03687798736885260313412192501109536707688526301852471947063459118729969965731760585520115159405834797;
      _points[15] = 0.1510747526033421015338538059866799658088230996730226718101385766300116393784200196523091817799413847;
      _weight[15] = 0.03687798736885260313412192501109536707688526301852471947063459118729969965731760585520211743210103565;
      _points[16] = 0.1897369085053785694297612217844053503963176535852359337024744149378323425125554411294237077723385906;
      _weight[16] = 0.04037794761471010767734746923026486543794640185421964994512929685302559028351317280210616346488849335;
      _points[17] = 0.8102630914946214305702387782155946496036823464147640662975255850621676574874445588705762922276610945;
      _weight[17] = 0.0403779476147101076773474692302648654379464018542196499451292968530255902835131728021061872309781039;
      _points[18] = 0.7683120740710099496320848966555363970820890034651485527263717414560074543094891893155705800485953387;
      _weight[18] = 0.04344989360054148990119376535756285128837666437177267200611106494107679112713074712397751617336896013;
      _points[19] = 0.2316879259289900503679151033444636029179109965348514472736282585439925456905108106844294199514047477;
      _weight[19] = 0.04344989360054148990119376535756285128837666437177267200611106494107679112713074712397751721923776294;
      _points[20] = 0.723516884769044588390304950161427000081203796930712204877238690863807675864292103502003444360620908;
      _weight[20] = 0.0460612611188930643588163535438093835984566172091170537638375235009865235350470841492320264444094193;
      _points[21] = 0.2764831152309554116096950498385729999187962030692877951227613091361923241357078964979965556393790769;
      _weight[21] = 0.04606126111889306435881635354380938359845661720911705376383752350098652353504708414923202646065604094;
      _points[22] = 0.6763523627654390567355186035446869303268155040107128132970922344501347081165955393321801983760567682;
      _weight[22] = 0.04818436858732212981973431317590493254820323071508012295649713786641876737100156186247562390896992009;
      _points[23] = 0.3236476372345609432644813964553130696731844959892871867029077655498652918834044606678198016239432329;
      _weight[23] = 0.04818436858732212981973431317590493254820323071508012295649713786641876737100156186247562390902385435;
      _points[24] = 0.6273184630839449232199025649089025539413946516512592130821429875444817657845394014531831406921181011;
      _weight[24] = 0.04979671029339763353139014105178473826493463183335213861068257309197333019495440450904614964466218078;
      _points[25] = 0.3726815369160550767800974350910974460586053483487407869178570124555182342154605985468168593078818989;
      _weight[25] = 0.04979671029339763353139014105178473826493463183335213861068257309197333019495440450904614964466224146;
      _points[26] = 0.4230650431957082265181026636283720397907240143778307691405185085421064257445919493015384467446296072;
      _weight[26] = 0.05088119487420275229821447608427702231635314474356342043213047270982125680265883747273799890989195542;
      _points[27] = 0.5769349568042917734818973363716279602092759856221692308594814914578935742554080506984615532553703928;
      _weight[27] = 0.0508811948742027522982144760842770223163531447435634204321304727098212568026588374727379989098919558;
      _points[28] = 0.5257359212776588479165126065833612868745707268332847821275804219939823776052135545279350453536427429;
      _weight[28] = 0.05142632644677942017064281835270752193418777853246411129315949333800811932830471469631442316094435458;
      _points[29] = 0.4742640787223411520834873934166387131254292731667152178724195780060176223947864454720649546463572571;
      _weight[29] = 0.05142632644677942017064281835270752193418777853246411129315949333800811932830471469631442316094435458;
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = 0.001456259090261462972186722888448745874277332941465184603938140536671727639569783488828314396257689635;
      _weight[0] = 0.003735415789624387929348437516106203511075426242024019849635485164339136550087160836353011312030814283;
      _points[1] = 0.9985437409097385370278132771115512541257226670585348153960618594633282723604302165111716856051244182;
      _weight[1] = 0.003735415789624387929348437516106203511075426242024019849635485164339136550087160845587137141720281039;
      _points[2] = 0.9923429548325762420012325833673423554692591347573218354728643296977299769442723637440437229734679307;
      _weight[2] = 0.008659310395155291231578998043410570683136431383997888316377591894405077207572920934503029106477412167;
      _points[3] = 0.00765704516742375799876741663265764453074086524267816452713567030227002305572763625595627702295878941;
      _weight[3] = 0.008659310395155291231578998043410570683136431383997888316377591894405077207572921233026982288499865862;
      _points[4] = 0.981251962546474830894526202052929150948609742576279188386675678514985989965298058276482183478766264;
      _weight[4] = 0.01350450959248971090030435404596607807117832300105832292843737492363504441243640114529650286166003484;
      _points[5] = 0.01874803745352516910547379794707084905139025742372081161332432148501401003470194172351781652525371484;
      _weight[5] = 0.01350450959248971090030435404596607807117832300105832292843737492363504441243640179017013630612728352;
      _points[6] = 0.9653784989483240824784728798646317564066988436290410182276681875953414709211815171232175381609787332;
      _weight[6] = 0.01821613695619273201219600523390172116357266602383384295070951969816670398426204512121133695127756726;
      _points[7] = 0.03462150105167591752152712013536824359330115637095898177233181240465852907881848287678246183624739291;
      _weight[7] = 0.01821613695619273201219600523390172116357266602383384295070951969816670398426204520325386329727057047;
      _points[8] = 0.9448800149741355216870960044910796307717987059325954748815660279630855009680425324985645588464641407;
      _weight[8] = 0.02274685376360055145115792894731483863177635965501448244675831806076219499563510508340775276693803594;
      _points[9] = 0.05511998502586447831290399550892036922820129406740452511843397203691449903195746750143544115477625997;
      _weight[9] = 0.02274685376360055145115792894731483863177635965501448244675831806076219499563510512478069813822093218;
      _points[10] = 0.9199601600731336700434522679700891780273686505373747614156803069474734141326785555328494277978334248;
      _weight[10] = 0.0270515412124584268558331295433100213601947312981059038470039105256499515290323858014887309311220587;
      _points[11] = 0.08003983992686632995654773202991082197263134946262523858431969305252658586732144446715057220183028104;
      _weight[11] = 0.02705154121245842685583312954331002136019473129810590384700391052564995152903238580263298133541309537;
      _points[12] = 0.1091334257916875297968199899026577544522948139933005599675624686482212483980791531009348949654394841;
      _weight[12] = 0.03108739328051421345517177184334833357936439968232565764075375266574554731138425888082085196543468197;
      _points[13] = 0.8908665742083124702031800100973422455477051860066994400324375313517787516019208468990651050345943823;
      _weight[13] = 0.03108739328051421345517177184334833357936439968232565764075375266574554731138425888130083816054638221;
      _points[14] = 0.1421116077065733580470145673167570220549032619152057836859458771974568631244629034775778924291043132;
      _weight[14] = 0.03481429161770518308387806312756285525754285369867169685553635851837134563893470805502034184209715985;
      _points[15] = 0.8578883922934266419529854326832429779450967380847942163140541228025431368755370965224221075709079774;
      _weight[15] = 0.03481429161770518308387806312756285525754285369867169685553635851837134563893470805507043833071976983;
      _points[16] = 0.1786466385378698269077908983837492730041546583318966217453477017619332973797433691655777512192607888;
      _weight[16] = 0.03819519329938830821317883745066532246287845684710432704609504082320412596697428296745119702124533426;
      _points[17] = 0.8213533614621301730922091016162507269958453416681033782546522982380667026202566308344222487807324943;
      _weight[17] = 0.03819519329938830821317883745066532246287845684710432704609504082320412596697428296745132284385085426;
      _points[18] = 0.2183754192964253686395275382024192860256988634165564845071156081562723096081775797374572902948126088;
      _weight[18] = 0.0411964958807946319519116837159808853078841332783231389051919621253154333232668202076256025443723746;
      _points[19] = 0.7816245807035746313604724617975807139743011365834435154928843918437276903918224202625427097051892246;
      _weight[19] = 0.04119649588079463195191168371598088530788413327832313890519196212531543332326682020762560352392116962;
      _points[20] = 0.2609031089775487597797029803217571257802383142512884375809194745004315606814533610283708215805617322;
      _weight[20] = 0.04378837030423893806309903484766654611462907988560212575177060598456271225204984948183410913304042932;
      _points[21] = 0.7390968910224512402202970196782428742197616857487115624190805254995684393185466389716291784194379161;
      _weight[21] = 0.04378837030423893806309903484766654611462907988560212575177060598456271225204984948183410923826059577;
      _points[22] = 0.3058070491958835284693242693562399490074468660532279821210935607641609639146006582516778301944404148;
      _weight[22] = 0.04594505694682073910768143580357506274865541268957890208924280825212435217371207403383186527240141105;
      _points[23] = 0.6941929508041164715306757306437600509925531339467720178789064392358390360853993417483221698055596242;
      _weight[23] = 0.04594505694682073910768143580357506274865541268957890208924280825212435217371207403383186527340160378;
      _points[24] = 0.3526409650091491916910480511641478306235724073608207215318520588819652150614509044215928373785823166;
      _weight[24] = 0.04764512145615975640360209874379834227066236912347951135572473296423440281824639506062046299784091323;
      _points[25] = 0.6473590349908508083089519488358521693764275926391792784681479411180347849385490955784071626214176832;
      _weight[25] = 0.04764512145615975640360209874379834227066236912347951135572473296423440281824639506062046299784199497;
      _points[26] = 0.5990605996677853143862064980164169688873974060807774399934011271280026030023023224343955099764932203;
      _weight[26] = 0.04887166769316436254673700548949835191786439433804755725475732225072623157354002120950387583890250572;
      _points[27] = 0.4009394003322146856137935019835830311126025939192225600065988728719973969976976775656044900235067797;
      _weight[27] = 0.0488716676931643625467370054894983519178643943380475572547573222507262315735400212095038758389025195;
      _points[28] = 0.5497776560761707601625873950594703669194976793887636530301135454886349377647980330327888590157321036;
      _weight[28] = 0.04961250561333615393743775721430750700877160997778153489060157125773453723517885216715386205370758322;
      _points[29] = 0.4502223439238292398374126049405296330805023206112363469698864545113650622352019669672111409842678964;
      _weight[29] = 0.04961250561333615393743775721430750700877160997778153489060157125773453723517885216715386205370758326;
      _points[30] = 0.5;
      _weight[30] = 0.04986027239671322571376691686717471982162670575010217574280728978204640605537343723220456872105070443;
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }

  // for non-fundamental types: assign numbers as strings
  template<typename ct>
  void GaussQuadratureInitHelper<ct,false>::init(int p,
         std::vector< FieldVector<ct, 1> > & _points,
         std::vector< ct > & _weight,
         int & delivered_order)
  {
    switch(p)
    {
    // order 0,1
    case 0 :
    case 1 :
      delivered_order = 1;
      _points.resize(1);
      _weight.resize(1);
      _points[0] = ct("0.5");
      _weight[0] = ct("1.0");
      break;

    // order 2,3
    case 2 :
    case 3 :
      delivered_order = 3;
      _points.resize(2);
      _weight.resize(2);
      _points[0] = ct("0.2113248654051871177454256097490212721761991243649365619906988367580111638485333271531423022071252374");
      _weight[0] = ct("0.5");
      _points[1] = ct("0.7886751345948128822545743902509787278238008756350634380093011632419888361514666728468576977928747626");
      _weight[1] = ct("0.5");
      break;

    // order 4,5
    case 4 :
    case 5 :
      delivered_order = 5;
      _points.resize(3);
      _weight.resize(3);
      _points[0] = ct("0.8872983346207416885179265399782399610832921705291590826587573766113483091936979033519287376858673518");
      _weight[0] = ct("0.2777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777");
      _points[1] = ct("0.1127016653792583114820734600217600389167078294708409173412426233886516908063020966480712623141326482");
      _weight[1] = ct("0.2777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777778");
      _points[2] = ct("0.5");
      _weight[2] = ct("0.4444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444");
      break;

    // order 6,7
    case 6 :
    case 7 :
      delivered_order = 7;
      _points.resize(4);
      _weight.resize(4);
      _points[0] = ct("0.9305681557970262876119732444464047525478626898148588188078609604532647357475244328520811699422396526");
      _weight[0] = ct("0.1739274225687269286865319746109997036176743479169467702462646597593759337329551758609918838661290797");
      _points[1] = ct("0.0694318442029737123880267555535952474521373101851411811921390395467352642524755671479188300577603474");
      _weight[1] = ct("0.1739274225687269286865319746109997036176743479169467702462646597593759337329551758609918838661290798");
      _points[2] = ct("0.3300094782075718675986671204483776563997120651145428237035230115894899847683814827610623597822225942");
      _weight[2] = ct("0.3260725774312730713134680253890002963823256520830532297537353402406240662670448241390081161338709202");
      _points[3] = ct("0.6699905217924281324013328795516223436002879348854571762964769884105100152316185172389376402177774058");
      _weight[3] = ct("0.3260725774312730713134680253890002963823256520830532297537353402406240662670448241390081161338709202");
      break;

    // order 8,9
    case 8 :
    case 9 :
      delivered_order = 9;
      _points.resize(5);
      _weight.resize(5);
      _points[0] = ct("0.953089922969331996398813439149696482562825955381265431436881143271885397458343423470571494776771131");
      _weight[0] = ct("0.1184634425280945437571320203599586813216300011062070077914139441108586442015215492899967152469757223");
      _points[1] = ct("0.04691007703066800360118656085030351743717404461873456856311885672811460254165657652942850522322886904");
      _weight[1] = ct("0.1184634425280945437571320203599586813216300011062070077914139441108586442015215492899967152469757223");
      _points[2] = ct("0.7692346550528415455181572103501044024836433034527799781011158135297355926838776455179018336252854658");
      _weight[2] = ct("0.2393143352496832340206457574178190964561477766715707699863638336669191335762562284877810625308020554");
      _points[3] = ct("0.2307653449471584544818427896498955975163566965472200218988841864702644073161223544820981663747145342");
      _weight[3] = ct("0.2393143352496832340206457574178190964561477766715707699863638336669191335762562284877810625308020554");
      _points[4] = ct("0.5");
      _weight[4] = ct("0.2844444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444444");
      break;

    // order 10,11
    case 10 :
    case 11 :
      delivered_order = 11;
      _points.resize(6);
      _weight.resize(6);
      _points[0] = ct("0.03376524289842398609384922275300269543261713114385508756372519173669324957789990186185563003903700748");
      _weight[0] = ct("0.08566224618958517252014807108636644676341125074202199119931771989947288027117007732396385271319433444");
      _points[1] = ct("0.9662347571015760139061507772469973045673828688561449124362748082633067504221000981381443699609629925");
      _weight[1] = ct("0.08566224618958517252014807108636644676341125074202199119931771989947288027117007732396385271319433508");
      _points[2] = ct("0.8306046932331322568306997975099526735032242821975850354072633529260917483035715504721432018732307282");
      _weight[2] = ct("0.1803807865240693037849167569188580558307609463733727411448696201185700189186308591604811009944096738");
      _points[3] = ct("0.1693953067668677431693002024900473264967757178024149645927366470739082516964284495278567981267692718");
      _weight[3] = ct("0.180380786524069303784916756918858055830760946373372741144869620118570018918630859160481100994409674");
      _points[4] = ct("0.6193095930415984543152508608403559677093053150700106750906975822871374671378199211246122136286745658");
      _weight[4] = ct("0.2339569672863455236949351719947754974058278028846052676558126599819571008101990635155550462923959912");
      _points[5] = ct("0.3806904069584015456847491391596440322906946849299893249093024177128625328621800788753877863713254342");
      _weight[5] = ct("0.2339569672863455236949351719947754974058278028846052676558126599819571008101990635155550462923959912");
      break;

    // order 12,13
    case 12 :
    case 13 :
      delivered_order = 13;
      _points.resize(7);
      _weight.resize(7);
      _points[0] = ct("0.9745539561713792622630948420239256312003854688353088917743845519565316651774200704028653850139628621");
      _weight[0] = ct("0.06474248308443484663530571633954100916429370112997333198860431936232761748602115435781270908146042202");
      _points[1] = ct("0.02544604382862073773690515797607436879961453116469110822561544804346833482257992959713461498603713794");
      _weight[1] = ct("0.06474248308443484663530571633954100916429370112997333198860431936232761748602115435781270908146042288");
      _points[2] = ct("0.1292344072003027800680676133596057964629261764293048699400223240162850626639097431035865838165683765");
      _weight[2] = ct("0.139852695744638333950733885711889791243462532613299382268507016346809405215281338406620471450598809");
      _points[3] = ct("0.8707655927996972199319323866403942035370738235706951300599776759837149373360902568964134161834316235");
      _weight[3] = ct("0.1398526957446383339507338857118897912434625326132993822685070163468094052152813384066204714505988098");
      _points[4] = ct("0.2970774243113014165466967939615192683263089929503149368064783741026680933869371723358436551361267061");
      _weight[4] = ct("0.1909150252525594724751848877444875669391825417669313673755417255153527732170648541743423296720224007");
      _points[5] = ct("0.7029225756886985834533032060384807316736910070496850631935216258973319066130628276641563448638732939");
      _weight[5] = ct("0.1909150252525594724751848877444875669391825417669313673755417255153527732170648541743423296720224007");
      _points[6] = ct("0.5");
      _weight[6] = ct("0.2089795918367346938775510204081632653061224489795918367346938775510204081632653061224489795918367347");
      break;

    // order 14,15
    case 14 :
    case 15 :
      delivered_order = 15;
      _points.resize(8);
      _weight.resize(8);
      _points[0] = ct("0.9801449282487681158417804342847364952141176171507260191358198886862124488717096422197194796316561341");
      _weight[0] = ct("0.05061426814518812957626567715498109505769704552584247852950184903237008938173539243014136965202249679");
      _points[1] = ct("0.01985507175123188415821956571526350478588238284927398086418011131378755112829035778028052036834386592");
      _weight[1] = ct("0.05061426814518812957626567715498109505769704552584247852950184903237008938173539243014136965202250399");
      _points[2] = ct("0.1016667612931866302042230317620847815814141341920175839649148524803913471617634539264240363521370304");
      _weight[2] = ct("0.1111905172266872352721779972131204422150654350256247823629546446468084072852245204268265711885989599");
      _points[3] = ct("0.8983332387068133697957769682379152184185858658079824160350851475196086528382365460735759636478629696");
      _weight[3] = ct("0.1111905172266872352721779972131204422150654350256247823629546446468084072852245204268265711885989642");
      _points[4] = ct("0.237233795041835507091130475405376825479017878439803571124571450363772589615719363738019299903184009");
      _weight[4] = ct("0.156853322938943643668981100993300656630164499501367468845131972537478135971086748480849038116964278");
      _points[5] = ct("0.762766204958164492908869524594623174520982121560196428875428549636227410384280636261980700096815991");
      _weight[5] = ct("0.156853322938943643668981100993300656630164499501367468845131972537478135971086748480849038116964278");
      _points[6] = ct("0.4082826787521750975302619288199080096666210935435131088414057631503977628892289429419658881444383231");
      _weight[6] = ct("0.1813418916891809914825752246385978060970730199471652702624115337833433673619533386621830210424142548");
      _points[7] = ct("0.5917173212478249024697380711800919903333789064564868911585942368496022371107710570580341118555616769");
      _weight[7] = ct("0.1813418916891809914825752246385978060970730199471652702624115337833433673619533386621830210424142548");
      break;

    // order 16,17
    case 16 :
    case 17 :
      delivered_order = 17;
      _points.resize(9);
      _weight.resize(9);
      _points[0] = ct("0.01591988024618695508221189854816356497529759975403733522498834407545981280169962346906312538655294424");
      _weight[0] = ct("0.04063719418078720598594607905526182533783086039120537535555383844034334315422603147278927735147130028");
      _points[1] = ct("0.9840801197538130449177881014518364350247024002459626647750116559245401871983003765309368746134470557");
      _weight[1] = ct("0.0406371941807872059859460790552618253378308603912053753555538384403433431542260314727892773514713142");
      _points[2] = ct("0.08198444633668210285028510596513256172794664093766200194781401018027249655920494055302690148707122983");
      _weight[2] = ct("0.0903240803474287020292360156214564047571689108660202422491679532356786452724731348822974886515998753");
      _points[3] = ct("0.9180155536633178971497148940348674382720533590623379980521859898197275034407950594469730985129287703");
      _weight[3] = ct("0.0903240803474287020292360156214564047571689108660202422491679532356786452724731348822974886515998796");
      _points[4] = ct("0.8066857163502951986543510196707370923928603024702823464364064711406336732455005992916200069517842923");
      _weight[4] = ct("0.1303053482014677311593714347093164248859201022186499759699985010598054078344456223238230465475086993");
      _points[5] = ct("0.1933142836497048013456489803292629076071396975297176535635935288593663267544994007083799930482157077");
      _weight[5] = ct("0.1303053482014677311593714347093164248859201022186499759699985010598054078344456223238230465475087005");
      _points[6] = ct("0.3378732882980955354807309926783316957140218696315134555864762615789067102324378754034506991507512164");
      _weight[6] = ct("0.1561735385200014200343152032922218327993774306309523227770055827995719486620096582850609609440031769");
      _points[7] = ct("0.6621267117019044645192690073216683042859781303684865444135237384210932897675621245965493008492487836");
      _weight[7] = ct("0.156173538520001420034315203292221832799377430630952322777005582799571948662009658285060960944003177");
      _points[8] = ct("0.5");
      _weight[8] = ct("0.1651196775006298815822625346434870244394053917863441672965482489292013101536911060720584530108339632");
      break;

    // order 18,19
    case 18 :
    case 19 :
      delivered_order = 19;
      _points.resize(10);
      _weight.resize(10);
      _points[0] = ct("0.9869532642585858600389820060422260267141349733461910596156060333482976016173180798128617824781342781");
      _weight[0] = ct("0.03333567215434406879678440494666589642893241716007907256434744080670603204204355088839275484252937791");
      _points[1] = ct("0.01304673574141413996101799395777397328586502665380894038439396665170239838268192018713821752186572192");
      _weight[1] = ct("0.03333567215434406879678440494666589642893241716007907256434744080670603204204355088839275484252937791");
      _points[2] = ct("0.9325316833444922553660483442117465242637715074826652262609798659226873775690277806783953644730228854");
      _weight[2] = ct("0.07472567457529029657288816982884866620127831983471368391773863437661932736331500547297363231736586137");
      _points[3] = ct("0.06746831665550774463395165578825347573622849251733477373902013407731262243097221932160463552697711466");
      _weight[3] = ct("0.07472567457529029657288816982884866620127831983471368391773863437661932736331500547297363231736596593");
      _points[4] = ct("0.1602952158504877968828363174425632121153526440825952661675914055237207123024625376924607132147598102");
      _weight[4] = ct("0.1095431812579910219977674671140815962293859352613385449404782718175999553264756406213419965886010702");
      _points[5] = ct("0.8397047841495122031171636825574367878846473559174047338324085944762792876975374623075392867852401898");
      _weight[5] = ct("0.1095431812579910219977674671140815962293859352613385449404782718175999553264756406213419965886011106");
      _points[6] = ct("0.2833023029353764046003670284171079188999640811718767517486492434281165054611482493874486210249411394");
      _weight[6] = ct("0.1346333596549981775456134607847346764298799692304418979002816381210767161595896383821133183546263798");
      _points[7] = ct("0.7166976970646235953996329715828920811000359188281232482513507565718834945388517506125513789750588606");
      _weight[7] = ct("0.1346333596549981775456134607847346764298799692304418979002816381210767161595896383821133183546263804");
      _points[8] = ct("0.4255628305091843945575869994351400076912175702896541521460053732420481913221657393144111851002681544");
      _weight[8] = ct("0.1477621123573764350869464973256691647105233585134268006771540148779979691085761646351782978968771084");
      _points[9] = ct("0.5744371694908156054424130005648599923087824297103458478539946267579518086778342606855888148997318456");
      _weight[9] = ct("0.1477621123573764350869464973256691647105233585134268006771540148779979691085761646351782978968771084");
      break;

    // order 20,21
    case 20 :
    case 21 :
      delivered_order = 21;
      _points.resize(11);
      _weight.resize(11);
      _points[0] = ct("0.01088567092697150359803099943857130461428879554010779228709946700816810030955500589984030091632761502");
      _weight[0] = ct("0.02783428355808683324137686022127428936425781284844907417419214283707770364036877194184561103615985882");
      _points[1] = ct("0.9891143290730284964019690005614286953857112044598922077129005329918318996904449941001596990836723848");
      _weight[1] = ct("0.02783428355808683324137686022127428936425781284844907417419214283707770364036877194184561103615998649");
      _points[2] = ct("0.9435312998840476495375788846519636333158378756126571924837055277688056569286863337211452975632986873");
      _weight[2] = ct("0.06279018473245231231734714961197005009880789569770175033196700540895728756623563881734382085702807703");
      _points[3] = ct("0.05646870011595235046242111534803636668416212438734280751629447223119434307131366627885470243670131297");
      _weight[3] = ct("0.0627901847324523123173471496119700500988078956977017503319670054089572875662356388173438208570284425");
      _points[4] = ct("0.86507600278702466204670812601557672902482153101306515598918916984350662252925961479771170548564185");
      _weight[4] = ct("0.0931451054638671257130488207158279458456423740201017058907532020869361740043927512346653792589896456");
      _points[5] = ct("0.13492399721297533795329187398442327097517846898693484401081083015649337747074038520228829451435815");
      _weight[5] = ct("0.09314510546386712571304882071582794584564237402010170589075320208693617400439275123466537925898987179");
      _points[6] = ct("0.2404519353965940920371371652706952227598864424400357554895386942566520367744635535872006099477254724");
      _weight[6] = ct("0.1165968822959952399592618524215875697158990861584792545136598610609661066094404979770199742191308423");
      _points[7] = ct("0.7595480646034059079628628347293047772401135575599642445104613057433479632255364464127993900522745276");
      _weight[7] = ct("0.1165968822959952399592618524215875697158990861584792545136598610609661066094404979770199742191308499");
      _points[8] = ct("0.6347715779761724861657659927004307623398109312195261408119628159400285331118473678519107961221336507");
      _weight[8] = ct("0.131402272255123331090344434945254597686382338801572278190027685742756401669772626776208498508513353");
      _points[9] = ct("0.3652284220238275138342340072995692376601890687804738591880371840599714668881526321480892038778663493");
      _weight[9] = ct("0.131402272255123331090344434945254597686382338801572278190027685742756401669772626776208498508513353");
      _points[10] = ct("0.5");
      _weight[10] = ct("0.1364625433889503153572417641681710945780209849473918737988002057266126530195794265058334322403586473");
      break;

    // order 22,23
    case 22 :
    case 23 :
      delivered_order = 23;
      _points.resize(12);
      _weight.resize(12);
      _points[0] = ct("0.009219682876640374654725454925359588519922400093134244768658939096103377840873008887371366054773882871");
      _weight[0] = ct("0.02358766819325591359730798074250853015851453699742354478025267350190486057601935533541295353770570183");
      _points[1] = ct("0.9907803171233596253452745450746404114800775999068657552313410609038966221591269911126286339452261171");
      _weight[1] = ct("0.02358766819325591359730798074250853015851453699742354478025267350190486057601935533541295353771090306");
      _points[2] = ct("0.9520586281852374283392329330595480962687983546066487732770378803406173978646178952434847139118666353");
      _weight[2] = ct("0.05346966299765921548012735909699811210728508673516244000256302105140949681374878827026865904815670116");
      _points[3] = ct("0.0479413718147625716607670669404519037312016453933512267229621196593826021353821047565152860881333648");
      _weight[3] = ct("0.05346966299765921548012735909699811210728508673516244000256302105140949681374878827026865904815772913");
      _points[4] = ct("0.8849513370971523435184469166064090379924628750094658188322095321245582715542356120082124996117109545");
      _weight[4] = ct("0.08003916427167311316732626477167953593600586524543208895494977207897711258664557534082827631852788289");
      _points[5] = ct("0.1150486629028476564815530833935909620075371249905341811677904678754417284457643879917875003882890453");
      _weight[5] = ct("0.08003916427167311316732626477167953593600586524543208895494977207897711258664557534082827631852953845");
      _points[6] = ct("0.7936589771433087236483512094702671401845492570240262407551354398336703496879476312178553824943741012");
      _weight[6] = ct("0.1015837133615329608745322279048991882532590736372950731992972828988228162552364218975721975323025648");
      _points[7] = ct("0.2063410228566912763516487905297328598154507429759737592448645601663296503120523687821446175056258989");
      _weight[7] = ct("0.1015837133615329608745322279048991882532590736372950731992972828988228162552364218975721975323026497");
      _points[8] = ct("0.3160842505009099031236542316781412193718199293322951893441000602479550352416060630606327857497267114");
      _weight[8] = ct("0.1167462682691774043804249494624390281297049860998774373652617489107460000397058376403395132542818442");
      _points[9] = ct("0.6839157494990900968763457683218587806281800706677048106558999397520449647583939369393672142502732886");
      _weight[9] = ct("0.1167462682691774043804249494624390281297049860998774373652617489107460000397058376403395132542818454");
      _points[10] = ct("0.5626167042557344577362206847319265649916984581527221366064608773742310281206948443714341492347456798");
      _weight[10] = ct("0.1245735229067013925002812180214756054152304512848094156976755015581397137286440215155784003090211765");
      _points[11] = ct("0.4373832957442655422637793152680734350083015418472778633935391226257689718793051556285658507652543202");
      _weight[11] = ct("0.1245735229067013925002812180214756054152304512848094156976755015581397137286440215155784003090211765");
      break;

    // order 24,25
    case 24 :
    case 25 :
      delivered_order = 25;
      _points.resize(13);
      _weight.resize(13);
      _points[0] = ct("0.9920915273592940747364147244035548055324952809629374543470036602142976189378134209302846436307092946");
      _weight[0] = ct("0.02024200238265793976001079610049303002099327287249443406752330375249723025639635524721040621651256352");
      _points[1] = ct("0.007908472640705925263585275596445194467504719037062545652996339785702381062186579069715356369290706896");
      _weight[1] = ct("0.02024200238265793976001079610049303002099327287249443406752330375249723025639635524721040621651575551");
      _points[2] = ct("0.9587991996114889826032739182503597561952373950558416479476426728298296042948049571417426951702914619");
      _weight[2] = ct("0.04606074991886422395721088797689856046184199993111841954419577366979686486381646314594890787783233253");
      _points[3] = ct("0.04120080038851101739672608174964024380476260494415835205235732717017039570519504285825730482970853578");
      _weight[3] = ct("0.04606074991886422395721088797689856046184199993111841954419577366979686486381646314594890787787365219");
      _points[4] = ct("0.9007890453666549563971032447914299451528078623952500149486923569296110581133200610150149370926585299");
      _weight[4] = ct("0.069436755109893619231800888434435733810931359131649113823177508252886260767444767862590771427295539");
      _points[5] = ct("0.09921095463334504360289675520857005484719213760474998505130764307038894188667993898498506290734147097");
      _weight[5] = ct("0.06943675510989361923180088843443573381093135913164911382317750825288626076744476786259077142729935376");
      _points[6] = ct("0.1788253302798298896780076965022421749641513008692115713054287960406782234275032125428058499429042223");
      _weight[6] = ct("0.08907299038097286914002334599804899775640632533050825149339722014457253474937436174735847561115655018");
      _points[7] = ct("0.8211746697201701103219923034977578250358486991307884286945712039593217765724967874571941500570957777");
      _weight[7] = ct("0.08907299038097286914002334599804899775640632533050825149339722014457253474937436174735847561115720583");
      _points[8] = ct("0.724246375518223426438956426063819933900960833720878939479141473729122046033108571822519104277366505");
      _weight[8] = ct("0.1039080237684442511562616096530263816932913045997517746095555599582692717825422161302977640233059593");
      _points[9] = ct("0.2757536244817765735610435739361800660990391662791210605208585262708779539668914281774808957226334949");
      _weight[9] = ct("0.1039080237684442511562616096530263816932913045997517746095555599582692717825422161302977640233059661");
      _points[10] = ct("0.6152291579775673970327640605489944176057711879417655817346307489185810418442909754064014723823400647");
      _weight[10] = ct("0.1131415901314486192060450930198883092173788688077785099324842743857878315602499855209131593331569649");
      _points[11] = ct("0.3847708420224326029672359394510055823942288120582344182653692510814189581557090245935985276176599353");
      _weight[11] = ct("0.1131415901314486192060450930198883092173788688077785099324842743857878315602499855209131593331569649");
      _points[12] = ct("0.5");
      _weight[12] = ct("0.1162757766154369550972947576344179740783137386533989930593327196723800120403517006913610310213706817");
      break;

    // order 26,27
    case 26 :
    case 27 :
      delivered_order = 27;
      _points.resize(14);
      _weight.resize(14);
      _points[0] = ct("0.006858095651593830579201366647973599161954296380387059177964594111125222933754181044676880167424125515");
      _weight[0] = ct("0.01755973016587593151591643806909589030985280463856363829074994509820816141890413526883839849926422796");
      _points[1] = ct("0.9931419043484061694207986333520264008380457036196129408220354058888747770662458189553231198325758757");
      _weight[1] = ct("0.01755973016587593151591643806909589030985280463856363829074994509820816141890413526883839849929733993");
      _points[2] = ct("0.9642174418317867586681955696889371322385196052049188093589812237410655467721799265557069528418287599");
      _weight[2] = ct("0.04007904357988010490281663853142715479184889269729738260069953274478573722864358493176809540971271623");
      _points[3] = ct("0.03578255816821324133180443031106286776148039479508119064101877625893445322782007344429304715817123803");
      _weight[3] = ct("0.0400790435798801049028166385314271547918488926972973826006995327447857372286435849317680954097315832");
      _points[4] = ct("0.9136006575348824965948973713251974805198505507375405907803545271207399154050144367852131950689447722");
      _weight[4] = ct("0.06075928534395159234470740453623831297833467284503733614553769627157987194626324615940995313520037766");
      _points[5] = ct("0.08639934246511750340510262867480251948014944926245940921964547287926008459498556321478680493105522878");
      _weight[5] = ct("0.06075928534395159234470740453623831297833467284503733614553769627157987194626324615940995313521470206");
      _points[6] = ct("0.8436464524058427350740099015096670687692006063735853378096332443140924480915666284736865352526059193");
      _weight[6] = ct("0.07860158357909676728480096931192107830283401866866168748465852193738408818480414925697904668120528128");
      _points[7] = ct("0.1563535475941572649259900984903329312307993936264146621903667556859075519084333715263134647473940806");
      _weight[7] = ct("0.07860158357909676728480096931192107830283401866866168748465852193738408818480414925697904668120705796");
      _points[8] = ct("0.2423756818209229540173546407244056688455573587153469815242476154536075240839721697739639898246135538");
      _weight[8] = ct("0.09276919873896890687085829506257851812446130146866582951001746253454917513176272221277636557335623116");
      _points[9] = ct("0.7576243181790770459826453592755943311544426412846530184757523845463924759160278302260360101753864463");
      _weight[9] = ct("0.09276919873896890687085829506257851812446130146866582951001746253454917513176272221277636557335624966");
      _points[10] = ct("0.3404438155360551197821640879157622665828693982330780217016749063713332797436036084175331472893267934");
      _weight[10] = ct("0.1025992318606478019829620328306090278551695306547097258584486451416835724126248601697159199959454469");
      _points[11] = ct("0.6595561844639448802178359120842377334171306017669219782983250936286667202563963915824668527106732066");
      _weight[11] = ct("0.1025992318606478019829620328306090278551695306547097258584486451416835724126248601697159199959454481");
      _points[12] = ct("0.4459725256463281689668776748900826261940241972628812214795894693459932354941349964349496559116553164");
      _weight[12] = ct("0.1076319267315788950979382216581300176374987790270644001098881962718093936769973020005122207054097891");
      _points[13] = ct("0.5540274743536718310331223251099173738059758027371187785204105306540067645058650035650503440883446836");
      _weight[13] = ct("0.1076319267315788950979382216581300176374987790270644001098881962718093936769973020005122207054097891");
      break;

    // order 28,29
    case 28 :
    case 29 :
      delivered_order = 29;
      _points.resize(15);
      _weight.resize(15);
      _points[0] = ct("0.006003740989757285755217140706693709426513591438119255000001242206305781315490287643638974815840423912");
      _weight[0] = ct("0.01537662099805863417731419678860220886087407241671703713211414275211859473355858401951938536567818793");
      _points[1] = ct("0.9939962590102427142447828592933062905734864085618807449999987577936942186845097123563610251841595731");
      _weight[1] = ct("0.01537662099805863417731419678860220886087407241671703713211414275211859473355858401951938536633108639");
      _points[2] = ct("0.9686366962003529521538794738551047356219981367576522289506815381751014868985227639752737930871340456");
      _weight[2] = ct("0.03518302374405406235463370822533366923335401637716535991295364645719352775643711852242022603232734774");
      _points[3] = ct("0.03136330379964704784612052614489526437800186324234777104931846182489851310147723602472620691286596038");
      _weight[3] = ct("0.03518302374405406235463370822533366923335401637716535991295364645719352775643711852242022603294154521");
      _points[4] = ct("0.07589670829478639189967583961289157431687191263150368295213622061966246241292725740119614012458925999");
      _weight[4] = ct("0.05357961023358596750593477334293465170777185787905099034351119456093899742615789986284292856885599421");
      _points[5] = ct("0.9241032917052136081003241603871084256831280873684963170478637793803375375870727425988038598754107365");
      _weight[5] = ct("0.05357961023358596750593477334293465170777185787905099034351119456093899742615789986284292856902630637");
      _points[6] = ct("0.8622088656800850237080930273069690048154496472920512817757117103520618908389626094980505488015671642");
      _weight[6] = ct("0.06978533896307715722390239725551416126042513765775562160119556431554422227095390584038412868178503037");
      _points[7] = ct("0.1377911343199149762919069726930309951845503527079487182242882896479381091610373905019494511984328364");
      _weight[7] = ct("0.06978533896307715722390239725551416126042513765775562160119556431554422227095390584038412868179665823");
      _points[8] = ct("0.2145139136957305762313866313730446793808068018586251975733672914729023100651207102582926857150869278");
      _weight[8] = ct("0.08313460290849696677660043024060440556545009004920645366093259528177678160613925885535258714620779062");
      _points[9] = ct("0.7854860863042694237686133686269553206191931981413748024266327085270976899348792897417073142849130721");
      _weight[9] = ct("0.08313460290849696677660043024060440556545009004920645366093259528177678160613925885535258714620808482");
      _points[10] = ct("0.302924326461218315051396314509477265818623611920650872484417328024195521106519291012251442919170119");
      _weight[10] = ct("0.09308050000778110551340028093321141225311300613896420140774786365500662775134958030947488444304965858");
      _points[11] = ct("0.6970756735387816849486036854905227341813763880793491275155826719758044788934807089877485570808298811");
      _weight[11] = ct("0.09308050000778110551340028093321141225311300613896420140774786365500662775134958030947488444304966241");
      _points[12] = ct("0.3994029530012827388496858483027018960935817727686811601920251376950258804984899061990818709662394704");
      _weight[12] = ct("0.09921574266355578822805916322191966240934627997877099674236896396456239876671713406665749958240891154");
      _points[13] = ct("0.6005970469987172611503141516972981039064182272313188398079748623049741195015100938009181290337605296");
      _weight[13] = ct("0.09921574266355578822805916322191966240934627997877099674236896396456239876671713406665749958240891161");
      _points[14] = ct("0.5");
      _weight[14] = ct("0.1012891209627806364403100999837596574193310790047386783983520580257176993773730370466967203563940161");
      break;

    // order 30,31
    case 30 :
    case 31 :
      delivered_order = 31;
      _points.resize(16);
      _weight.resize(16);
      _points[0] = ct("0.005299532504175033701922913274833686286862964171177434974388047634337931392087301530731784046600902477");
      _weight[0] = ct("0.01357622970587704742589028622800905175613368778338039899530515953690205683210808662466288961558883448");
      _points[1] = ct("0.9947004674958249662980770867251663137131370358288225650256119523656620686079126984692682159533990871");
      _weight[1] = ct("0.01357622970587704742589028622800905175613368778338039899530515953690205683210808662466288961642578809");
      _points[2] = ct("0.9722875115366162880389942077673041725455696362955363004627768260333048944513411521097828643690791645");
      _weight[2] = ct("0.03112676196932394643142191849718884713749325417645342895065175790976786944352190953060585476930010037");
      _points[3] = ct("0.02771248846338371196100579223269582745443036370446369953722317396669510554865884789021713563092085786");
      _weight[3] = ct("0.03112676196932394643142191849718884713749325417645342895065175790976786944352190953060585476935955411");
      _points[4] = ct("0.06718439880608412805976605114380343380633230757623664594824428721611980114375472087143375281761380758");
      _weight[4] = ct("0.04757925584124639240496255380112311317763175159185632907841114361481587978884097972351247865969801944");
      _points[5] = ct("0.9328156011939158719402339488561965661936676924237633540517557127838801988562452791285662471823861744");
      _weight[5] = ct("0.04757925584124639240496255380112311317763175159185632907841114361481587978884097972351247866179909653");
      _points[6] = ct("0.8777022041775015169475505974237211341769068282287515048908785884611484305156358388603110284596247239");
      _weight[6] = ct("0.06231448562776693602623814109600821007244342961110133997237529521470548196073267679898459500869048106");
      _points[7] = ct("0.1222977958224984830524494025762788658230931717712484951091214115388515694843641611396889715403752838");
      _weight[7] = ct("0.06231448562776693602623814109600821007244342961110133997237529521470548196073267679898459500869141184");
      _points[8] = ct("0.8089381222013218742233358820243955094959411088828288970518986777708666588774057122284555152139792502");
      _weight[8] = ct("0.07479799440828836604075086527373927448524553410391823340271098109368020201020899122588931920152688622");
      _points[9] = ct("0.191061877798678125776664117975604490504058891117171102948101322229133341122594287771544484786020748");
      _weight[9] = ct("0.07479799440828836604075086527373927448524553410391823340271098109368020201020899122588931920153081579");
      _points[10] = ct("0.7290083888286136931712097214917887867700158065177617454505773754738795871451468038677177639679940468");
      _weight[10] = ct("0.08457825969750126909465603951517998110581973670801414087254146784040183210496526546607766127103887189");
      _points[11] = ct("0.2709916111713863068287902785082112132299841934822382545494226245261204128548531961322822360320059534");
      _weight[11] = ct("0.08457825969750126909465603951517998110581973670801414087254146784040183210496526546607766127103912237");
      _points[12] = ct("0.6408017753896294566152302507302480532430347453852999002744173669779625897495653852207201145760200796");
      _weight[12] = ct("0.09130170752246179443338183398460996969177811182732464120924757218971523247505558748020021255849263684");
      _points[13] = ct("0.3591982246103705433847697492697519467569652546147000997255826330220374102504346147792798854239799204");
      _weight[13] = ct("0.09130170752246179443338183398460996969177811182732464120924757218971523247505558748020021255849263706");
      _points[14] = ct("0.4524937450811812799073403322875209684348234721554672716513900913874373508777039335076206535121083239");
      _weight[14] = ct("0.09472530522753424814269836160414155257345449419795148751875662260001144538456650315006698891676697614");
      _points[15] = ct("0.5475062549188187200926596677124790315651765278445327283486099086125626491222960664923793464878916761");
      _weight[15] = ct("0.09472530522753424814269836160414155257345449419795148751875662260001144538456650315006698891676697614");
      break;

    // order 32,33
    case 32 :
    case 33 :
      delivered_order = 33;
      _points.resize(17);
      _weight.resize(17);
      _points[0] = ct("0.004712262342791332162282990029667361746105074770217848608045606628828071264688983144320779675129030429");
      _weight[0] = ct("0.01207415143427396598005501314378266234584865797251263915559257441510919835275524317979262072372571691");
      _points[1] = ct("0.9952877376572086678377170099703326382538949252297821513919543933711719287353110168556792203248709665");
      _weight[1] = ct("0.01207415143427396598005501314378266234584865797251263915559257441510919835275524317979262072798397032");
      _points[2] = ct("0.02466223911561611938864152105209848927830747672044564616501539379394231686390070262498154862426577667");
      _weight[2] = ct("0.02772976468699360056472008267912233025642312597661442349686203935512871300166731918663789437619580271");
      _points[3] = ct("0.9753377608843838806113584789479015107216925232795543538349846062060576831360992973750184513757342315");
      _weight[3] = ct("0.02772976468699360056472008267912233025642312597661442349686203935512871300166731918663789438923065064");
      _points[4] = ct("0.9401195768634929510614778472440778463117084089672139501759550796620135652522056057591535969342795476");
      _weight[4] = ct("0.04251807415858959044176768509553103692524569460925273788320518036939199639374132387349380214026392876");
      _points[5] = ct("0.05988042313650704893852215275592215368829159103278604982404492033798643474779439424084640306572044363");
      _weight[5] = ct("0.04251807415858959044176768509553103692524569460925273788320518036939199639374132387349380215620526406");
      _points[6] = ct("0.8907570019484007034626150277602380251119862363702842562566572677562888080797565380866902504334808315");
      _weight[6] = ct("0.05594192359670198554739419281317796336792171213153852500924324122454783982180491780761085226210241093");
      _points[7] = ct("0.1092429980515992965373849722397619748880137636297157437433427322437111919202434619133097495665191737");
      _weight[7] = ct("0.05594192359670198554739419281317796336792171213153852500924324122454783982180491780761085226455009237");
      _points[8] = ct("0.1711644203916546170748488916784988324260970542620133780973841522463378512126512091235044063472449388");
      _weight[8] = ct("0.06756818423426273664315999085117509868606292661724451018899730534443362149496927204875472415680701704");
      _points[9] = ct("0.8288355796083453829251511083215011675739029457379866219026158477536621487873487908764955936527550596");
      _weight[9] = ct("0.06756818423426273664315999085117509868606292661724451018899730534443362149496927204875472415684703185");
      _points[10] = ct("0.7563452685432384839431232843147759372914618612055864529563657494821424624713927401409902061902588012");
      _weight[10] = ct("0.07702288053840514404071579740097930597024152923550896719263235567572337092983822554580872467672521159");
      _points[11] = ct("0.243654731456761516056876715685224062708538138794413547043634250517857537528607259859009793809741199");
      _weight[11] = ct("0.07702288053840514404071579740097930597024152923550896719263235567572337092983822554580872467672663593");
      _points[12] = ct("0.6756158817269381576485927585476730025202698757878375116595805097738971308233747864487915723017545524");
      _weight[12] = ct("0.08400205107822502225498533189416157751059906448253700713497792567016155325001229328060192486945988784");
      _points[13] = ct("0.3243841182730618423514072414523269974797301242121624883404194902261028691766252135512084276982454476");
      _weight[13] = ct("0.08400205107822502225498533189416157751059906448253700713497792567016155325001229328060192486945989544");
      _points[14] = ct("0.5892420907479239279253387468270327787377096663457628217814759071353487752396502880851444611048175023");
      _weight[14] = ct("0.08828135268349632316263549505659861957546220900037405902157220345660451810364134022616734534204332795");
      _points[15] = ct("0.4107579092520760720746612531729672212622903336542371782185240928646512247603497119148555388951824977");
      _weight[15] = ct("0.08828135268349632316263549505659861957546220900037405902157220345660451810364134022616734534204332799");
      _points[16] = ct("0.5");
      _weight[16] = ct("0.0897232351781032627291328221309428107243901599488342618338343489777983773031401297022642228762521388");
      break;

    // order 34,35
    case 34 :
    case 35 :
      delivered_order = 35;
      _points.resize(18);
      _weight.resize(18);
      _points[0] = ct("0.004217415789534526634991997646924614873710531577280153540162184880071453204110195124118265193699399567");
      _weight[0] = ct("0.01080800676324165515667135513322623469384261573779497273103799507067654511867256095162565153472427187");
      _points[1] = ct("0.9957825842104654733650080023530753851262894684227198464598378151199285467958898048758817348063006366");
      _weight[1] = ct("0.01080800676324165515667135513322623469384261573779497273103799507067654511867256095162565154865900931");
      _points[2] = ct("0.9779119747856988775905979464648881549864220674056532394226938148454490356023866119789411964798169198");
      _weight[2] = ct("0.02485727444748489822666747310131932084043312306445510112315215393278617164790170814752068547592735646");
      _points[3] = ct("0.02208802521430112240940205353511184501357793259434676057730618515455096439761338802105880352018300695");
      _weight[3] = ct("0.02485727444748489822666747310131932084043312306445510112315215393278617164790170814752068552847842593");
      _points[4] = ct("0.9463012332487778696030302955635727577039476356761491070937331574536202912183924679153337935403015991");
      _weight[4] = ct("0.03821286512744452826456483880831826280265895310417914372476068961720500364589648967088255123780103244");
      _points[5] = ct("0.05369876675122213039696970443642724229605236432385089290626684254637970878160753208466620645969845262");
      _weight[5] = ct("0.03821286512744452826456483880831826280265895310417914372476068961720500364589648967088255130463489598");
      _points[6] = ct("0.9018524794862615578412087275072953985516494608059612408752140320976940527144721436141434827212058818");
      _weight[6] = ct("0.05047102205314358278140699246241730353140056944383945080518726832782539869024926167622531935947931249");
      _points[7] = ct("0.09814752051373844215879127249270460144835053919403875912478596790230594728552785638585651727879410136");
      _weight[7] = ct("0.05047102205314358278140699246241730353140056944383945080518726832782539869024926167622531936152909078");
      _points[8] = ct("0.8458435215301766039374455406444241947261352864087538794510813284185986844518146255669054040725663105");
      _weight[8] = ct("0.06127760335573923009225956340010077761408194866671954858362675682702871979970184091909860996236098967");
      _points[9] = ct("0.1541564784698233960625544593555758052738647135912461205489186715814013155481853744330945959274336919");
      _weight[9] = ct("0.06127760335573923009225956340010077761408194866671954858362675682702871979970184091909860996247060097");
      _points[10] = ct("0.2201145844630262326960642257373354315361867571146452916800065279689077358967397401704589758199778143");
      _weight[10] = ct("0.07032145733532532560236565187597361404775120516548627994172809763023279346387494851533138451345573173");
      _points[11] = ct("0.7798854155369737673039357742626645684638132428853547083199934720310922641032602598295410241800221855");
      _weight[11] = ct("0.07032145733532532560236565187597361404775120516548627994172809763023279346387494851533138451345944567");
      _points[12] = ct("0.2941244192685786769820341030834741814605051589399872443594255661048051634497872951128265748031744856");
      _weight[12] = ct("0.07734233756313262246270900191818738609660919813367708633332095736389143461532186515617346192611193334");
      _points[13] = ct("0.7058755807314213230179658969165258185394948410600127556405744338951948365502127048871734251968255144");
      _weight[13] = ct("0.07734233756313262246270900191818738609660919813367708633332095736389143461532186515617346192611199996");
      _points[14] = ct("0.3740568871542472452055135725610443849185691171701797709898644841316077532221378890964612289453068764");
      _weight[14] = ct("0.0821382418729163614930268882329637952061694769986764766222484854558242109226040038776818788735302449");
      _points[15] = ct("0.6259431128457527547944864274389556150814308828298202290101355158683922467778621109035387710546931236");
      _weight[15] = ct("0.0821382418729163614930268882329637952061694769986764766222484854558242109226040038776818788735302449");
      _points[16] = ct("0.5423875065208676506211309264678919058666586934530449600216822588127498953266400008189022753637198062");
      _weight[16] = ct("0.08457119148157179592032823506749330516705290968517194013493759577452972209577732108546045701988907679");
      _points[17] = ct("0.4576124934791323493788690735321080941333413065469550399783177411872501046733599991810977246362801938");
      _weight[17] = ct("0.08457119148157179592032823506749330516705290968517194013493759577452972209577732108546045701988907679");
      break;

    // order 36,37
    case 36 :
    case 37 :
      delivered_order = 37;
      _points.resize(19);
      _weight.resize(19);
      _points[0] = ct("0.9962034219217922015945088351266302467946582007016053933398397195456159514792614419018374604367093356");
      _weight[0] = ct("0.009730894114863238518156020732219217876453304534643320396340236230800718784052774105426043995362173783");
      _points[1] = ct("0.003796578078207798405491164873369753205341799298394606660160280454384048520738558098162539563290576184");
      _weight[1] = ct("0.009730894114863238518156020732219217876453304534643320396340236230800718784052774105426044173769122249");
      _points[2] = ct("0.980104076067415015426389420343825763307545751637069052958908167216100374968744256610371780745770797");
      _weight[2] = ct("0.02240711338284980016641907870099710597587711373392880104292726338382149569213972882233451675157216316");
      _points[3] = ct("0.01989592393258498457361057965617423669245424836293094704109183278389962503125574338962821925422939313");
      _weight[3] = ct("0.02240711338284980016641907870099710597587711373392880104292726338382149569213972882233451752427173122");
      _points[4] = ct("0.04842204819259104917866953573384375609530303297132209115248378761918209770494789052123988581535143365");
      _weight[4] = ct("0.03452227136882061329035412900300652248092401584380656556145021384801748745321951075883154737770809981");
      _points[5] = ct("0.9515779518074089508213304642661562439046969670286779088475162123808179022950521094787601141846484121");
      _weight[5] = ct("0.03452227136882061329035412900300652248092401584380656556145021384801748745321951075883154804745494595");
      _points[6] = ct("0.9113573282685714124894612433563569508872692431034150206849319443027501714518429160134331115546303493");
      _weight[6] = ct("0.04574501081122499973223104706191982633045582564829939233249467245103111052189863080287385751297978919");
      _points[7] = ct("0.08864267173142858751053875664364304911273075689658497931506805569724982854815708398656688844536971947");
      _weight[7] = ct("0.04574501081122499973223104706191982633045582564829939233249467245103111052189863080287385752662736252");
      _points[8] = ct("0.1395169113323853106914520695881091851714290835456666125307047643066927204260069735782833086643367062");
      _weight[8] = ct("0.05578332277366699735801195084088299874066592691994688776073057143822948805282323530050214248021619462");
      _points[9] = ct("0.860483088667614689308547930411890814828570916454333387469295235693307279573993026421716691335663273");
      _weight[9] = ct("0.05578332277366699735801195084088299874066592691994688776073057143822948805282323530050214248274414005");
      _points[10] = ct("0.1997273476691594882651809175268803600658389586338537162067066371658075456515645797876221023342730016");
      _weight[10] = ct("0.06437698126966811383775789242843855852791978854673151727355219231115180202831583996571650116696087894");
      _points[11] = ct("0.8002726523308405117348190824731196399341610413661462837932933628341924543484354202123778976657270034");
      _weight[11] = ct("0.06437698126966811383775789242843855852791978854673151727355219231115180202831583996571650116705281951");
      _points[12] = ct("0.2677146293120195271413664259479488160118571426879317015078455612121579394432872966567752271396340272");
      _weight[12] = ct("0.07130335108680330588787305472095148623783417241223693046328582795322912423645162550747003591862412103");
      _points[13] = ct("0.7322853706879804728586335740520511839881428573120682984921544387878420605567127033432247728603659722");
      _weight[13] = ct("0.07130335108680330588787305472095148623783417241223693046328582795322912423645162550747003591862432269");
      _points[14] = ct("0.6582820499818149159950586644249224589461426095664436225778644933989464429102881989984194460432401755");
      _weight[14] = ct("0.07638302103292983338942770044883149923050413361821431176155077653740552182553160682740492351539352549");
      _points[15] = ct("0.3417179500181850840049413355750775410538573904335563774221355066010535570897118010015805539567598244");
      _weight[15] = ct("0.07638302103292983338942770044883149923050413361821431176155077653740552182553160682740492351539354559");
      _points[16] = ct("0.5801793228201126879340480578703717747524367502354376894373217258031603043401955368283697867497404565");
      _weight[16] = ct("0.07948442169697717382497821973252360083939007909756304787558745766237048929169252987130523836300323926");
      _points[17] = ct("0.4198206771798873120659519421296282252475632497645623105626782741968396956598044631716302132502595435");
      _weight[17] = ct("0.07948442169697717382497821973252360083939007909756304787558745766237048929169252987130523836300323929");
      _points[18] = ct("0.5");
      _weight[18] = ct("0.08052722492439184798958181266045836751995127928925845106416157636788552422774903607627038285846452347");
      break;

    // order 38,39
    case 38 :
    case 39 :
      delivered_order = 39;
      _points.resize(20);
      _weight.resize(20);
      _points[0] = ct("0.003435700407452537606938805764339860888676434549172051925907934391007641186123109580275298751713954469");
      _weight[0] = ct("0.008807003569576059155930981175926408181071552771668366262174663338674209629810923908701553356090040729");
      _points[1] = ct("0.996564299592547462393061194235660139111323565450827948074092065608992358813876890419724701248285876");
      _weight[1] = ct("0.008807003569576059155930981175926408181071552771668366262174663338674209629810923908701553563226498553");
      _points[2] = ct("0.9819859636389568956338330655986386109560301639030944280317687969460207903921915284900090626279828738");
      _weight[2] = ct("0.02030071490019347066551997613746605493954531999497576840880342728091614837549366414776945721436983009");
      _points[3] = ct("0.01801403636104310436616693440136138904396983609690557196823120305397920960780847150999093737201747363");
      _weight[3] = ct("0.02030071490019347066551997613746605493954531999497576840880342728091614837549366414776945930224083097");
      _points[4] = ct("0.9561172141256629529338762206016490565245923987118458873979411095790354456043595394682223630964602397");
      _weight[4] = ct("0.03133602416705453178475326759352080317580053828921818204979217271898740551683283932228188052636258305");
      _points[5] = ct("0.04388278587433704706612377939835094347540760128815411260205889042096455439564046053177763690353951217");
      _weight[5] = ct("0.03133602416705453178475326759352080317580053828921818204979217271898740551683283932228188185922162769");
      _points[6] = ct("0.08044151408889058830273546914923965733518531746718131337375363723356945300033759504038532971702103414");
      _weight[6] = ct("0.04163837078835237436237907161102310305008891429158164537244103039284654144703970973568759498491074799");
      _points[7] = ct("0.9195584859111094116972645308507603426648146825328186866262463627664305469996624049596146702829790438");
      _weight[7] = ct("0.04163837078835237436237907161102310305008891429158164537244103039284654144703970973568759537895086086");
      _points[8] = ct("0.1268340467699246036928474648221792048446346602154117779302270469657323224809224676594479431896762949");
      _weight[8] = ct("0.05096505990862021751837506774017493808334582801169627813098580809842616101269717323767465784984593666");
      _points[9] = ct("0.8731659532300753963071525351778207951553653397845882220697729530342676775190775323405520568103236989");
      _weight[9] = ct("0.05096505990862021751837506774017493808334582801169627813098580809842616101269717323767465787679251824");
      _points[10] = ct("0.8180268403632575127264183481131429683716945583996842319697233112732706312927150662793515977478806628");
      _weight[10] = ct("0.05909726598075920865618868885569114350252060977448438772344497601008737417525575815286434391364216924");
      _points[11] = ct("0.1819731596367424872735816518868570316283054416003157680302766887267293687072849337206484022521193356");
      _weight[11] = ct("0.05909726598075920865618868885569114350252060977448438772344497601008737417525575815286434391379151647");
      _points[12] = ct("0.755433500975413549002182025477625499212745664601213416736174309947367485195382864072015841525433889");
      _weight[12] = ct("0.06584431922458831344924724987408156745805525557349176349821824685442717821474046657177898759196353775");
      _points[13] = ct("0.2445664990245864509978179745223745007872543353987865832638256900526325148046171359279841584745661111");
      _weight[13] = ct("0.06584431922458831344924724987408156745805525557349176349821824685442717821474046657177898759199220677");
      _points[14] = ct("0.3131469556422902196637259114875363813021268391471586440860256932421771178134702360520521581827333106");
      _weight[14] = ct("0.07104805465919102566464916253358246651725770669601015166868354149191404374896718380847461214160016571");
      _points[15] = ct("0.6868530443577097803362740885124636186978731608528413559139743067578228821865297639479478418172666894");
      _weight[15] = ct("0.07104805465919102566464916253358246651725770669601015166868354149191404374896718380847461214160037349");
      _points[16] = ct("0.613892925570822539040248097684287312371544468841463736157317869603585670931777913897476062595484354");
      _weight[16] = ct("0.07458649323630187339391436850098471834633995204068415824810560890492221129779339034698066301760523947");
      _points[17] = ct("0.386107074429177460959751902315712687628455531158536263842682130396414329068222086102523937404515646");
      _weight[17] = ct("0.07458649323630187339391436850098471834633995204068415824810560890492221129779339034698066301760523991");
      _points[18] = ct("0.5382632605667486668773202046994191055023981334067487504023976221921281710241684891207725570907781078");
      _weight[18] = ct("0.07637669356536292534904216597754879674597432255618929863735052490879872658136889076778624391825195297");
      _points[19] = ct("0.4617367394332513331226797953005808944976018665932512495976023778078718289758315108792274429092218922");
      _weight[19] = ct("0.07637669356536292534904216597754879674597432255618929863735052490879872658136889076778624391825195297");
      break;

    // order 40,41
    case 40 :
    case 41 :
      delivered_order = 41;
      _points.resize(21);
      _weight.resize(21);
      _points[0] = ct("0.9968760853101947501301210179689704645966692273911645927904369273565480545114964034990643735676197425");
      _weight[0] = ct("0.008008614128887166662112308429235507632945211058951241274088955056779383680659431157453347771312310018");
      _points[1] = ct("0.003123914689805249869878982031029535403330772608835407209563072643451945488503596500935626432380384723");
      _weight[1] = ct("0.008008614128887166662112308429235507632945211058951241274088955056779383680659431157453351749114303732");
      _points[2] = ct("0.01638658071684685284168889254615241928765315633507657502351443595743951999745985601408129906803823328");
      _weight[2] = ct("0.01847689488542624689997533414966483309447215407436491871358459093939287557878370422926170697737740157");
      _points[3] = ct("0.9836134192831531471583111074538475807123468436649234249764855640425604800025401439859187009319615024");
      _weight[3] = ct("0.01847689488542624689997533414966483309447215407436491871358459093939287557878370422926172175919579072");
      _points[4] = ct("0.03995033292479958560490643314251555292042619517588915141193225645450921846529608550413402431396548965");
      _weight[4] = ct("0.02856721271342860414181791323622397874564379841312802072125366171352452769982600404414322716617000998");
      _points[5] = ct("0.9600496670752004143950935668574844470795738048241108485880677435454907815347039144958659756860347123");
      _weight[5] = ct("0.02856721271342860414181791323622397874564379841312802072125366171352452769982600404414322962279680312");
      _points[6] = ct("0.9266816822916586418236253192937838351380529015896719853714958146971214531419175734861448185958476768");
      _weight[6] = ct("0.03805005681418965100852582665009158961307717621198301426073424290822675829330037499656830937779117347");
      _points[7] = ct("0.07331831770834135817637468070621616486194709841032801462850418530287854685808242651385518140415223744");
      _weight[7] = ct("0.03805005681418965100852582665009158961307717621198301426073424290822675829330037499656830966790713345");
      _points[8] = ct("0.1157800182621610456920610743468859825895116471143152245656366674849906287301494102064641704530676751");
      _weight[8] = ct("0.04672221172801693077664487055696604424176332368079642243334763581628894888685619367593429425889811223");
      _points[9] = ct("0.8842199817378389543079389256531140174104883528856847754343633325150093712698505897935358295469323533");
      _weight[9] = ct("0.04672221172801693077664487055696604424176332368079642243334763581628894888685619367593429445743788085");
      _points[10] = ct("0.833569402098706159652983334995169581298514671655701421237733541173597096557848147649755244281395587");
      _weight[10] = ct("0.05439864958357418883173728903505282101684979789692816527639104358448682188313469419058838120027728265");
      _points[11] = ct("0.1664305979012938403470166650048304187014853283442985787622664588264029034421518523502447557186044041");
      _weight[11] = ct("0.05439864958357418883173728903505282101684979789692816527639104358448682188313469419058838122180361033");
      _points[12] = ct("0.2241905820563900964704906016378433566889698878846601674978470802501976091441579814715095060504845149");
      _weight[12] = ct("0.06091570802686426709768358856286679917816881278076872512149190392137945061467548197097422700245561668");
      _points[13] = ct("0.7758094179436099035295093983621566433110301121153398325021529197498023908558420185284904939495154868");
      _weight[13] = ct("0.06091570802686426709768358856286679917816881278076872512149190392137945061467548197097422700249951898");
      _points[14] = ct("0.7121710601037193917868344442718940260482226159198172921121291179482434418394007784999360464569138182");
      _weight[14] = ct("0.06613446931666873089052628724838780216450577007157841160917516157589129928261519951184529780764479093");
      _points[15] = ct("0.2878289398962806082131655557281059739517773840801827078878708820517565581605992215000639535430861817");
      _weight[15] = ct("0.06613446931666873089052628724838780216450577007157841160917516157589129928261519951184529780764839634");
      _points[16] = ct("0.3559893415987994516996037419676998400454908681769833856228592376253775285290786160733304858198915867");
      _weight[16] = ct("0.06994369739553657736106671193379155544639658047745980218686566316212163123260307830816081080108004754");
      _points[17] = ct("0.6440106584012005483003962580323001599545091318230166143771407623746224714709213839266695141801084133");
      _weight[17] = ct("0.06994369739553657736106671193379155544639658047745980218686566316212163123260307830816081080108004754");
      _points[18] = ct("0.5727809270804475454685154911693431650581630122189688787107441949927736404416598988452579892191042265");
      _weight[18] = ct("0.07226220199498502953191358327687627180497498109854991737623649444304865467169593493263483293242601162");
      _points[19] = ct("0.4272190729195524545314845088306568349418369877810311212892558050072263595583401011547420107808957735");
      _weight[19] = ct("0.07226220199498502953191358327687627180497498109854991737623649444304865467169593493263483293242601162");
      _points[20] = ct("0.5");
      _weight[20] = ct("0.07304056682484521359599257384168559412240478847098272205366129375771929635169980596487109556323312786");
      break;

    // order 42,43
    case 42 :
    case 43 :
      delivered_order = 43;
      _points.resize(22);
      _weight.resize(22);
      _points[0] = ct("0.002852707258800353963484289419350509803472900801984232511488537516671751147960044089614037111865173732");
      _weight[0] = ct("0.007313997649136100342495549023592722595105974562161865462248795710094053266374085571141880346311089378");
      _points[1] = ct("0.9971472927411996460365157105806494901965270991980157674885114624833282488520399559103859628881355814");
      _weight[1] = ct("0.007313997649136100342495549023592722595105974562161865462248795710094053266374085571141883008544226611");
      _points[2] = ct("0.9850302489177143635619754933826343554029844615689014847798691061681871303874212543187706773135177033");
      _weight[2] = ct("0.01688745079240707739665112343295645067458465723723733021644159727997575587653074419945745695676145639");
      _points[3] = ct("0.01496975108228563643802450661736564459701553843109851522013089383181286961257874568122932268648048749");
      _weight[3] = ct("0.01688745079240707739665112343295645067458465723723733021644159727997575587653074419945762155251412539");
      _points[4] = ct("0.03652161390641299973965353037047340168233517331397400897771340423643194044422943724815312357627569228");
      _weight[4] = ct("0.02614666757634164297015602563660562805607504678461815806135504164883817117996641239098413278077729423");
      _points[5] = ct("0.9634783860935870002603464696295265983176648266860259910222865957635680595557705627518468764237260872");
      _weight[5] = ct("0.02614666757634164297015602563660562805607504678461815806135504164883817117996641239098413540926935972");
      _points[6] = ct("0.9329062888601500682682128185096893645423983777942230780635466846313584474707602174042400781419289789");
      _weight[6] = ct("0.03489823421226024404748070946510882869938752647754026369315568588197320174364294701969641072525858542");
      _points[7] = ct("0.06709371113984993173178718149031063545760162220577692193645331536864155252923978259575992185807001107");
      _weight[7] = ct("0.03489823421226024404748070946510882869938752647754026369315568588197320174364294701969641451337550866");
      _points[8] = ct("0.8939084029896040810021389777041757606940893356657815790608466988555661381263540374500257594796665631");
      _weight[8] = ct("0.04297080310853386370722184068635143309457220267453989164328500552412301238656307871601112391536217695");
      _points[9] = ct("0.1060915970103959189978610222958242393059106643342184209391533011444338618736459625499742405203337798");
      _weight[9] = ct("0.04297080310853386370722184068635143309457220267453989164328500552412301238656307871601112573694851247");
      _points[10] = ct("0.1527563684066586099746550821188716143663288550112824194391331123038570301128534725802029426006947326");
      _weight[10] = ct("0.05020707222144048246603941891526814117540554438384981289248045717022654803711188637143031951500947387");
      _points[11] = ct("0.8472436315933413900253449178811283856336711449887175805608668876961429698871465274197970573993052051");
      _weight[11] = ct("0.05020707222144048246603941891526814117540554438384981289248045717022654803711188637143031963916383524");
      _points[12] = ct("0.7938202017534557964794384638193236744388078017868589198850169106862341889140221801795800526056382982");
      _weight[12] = ct("0.05646614804026960919670030371089215955713166606049735213629877312430656546180541682980244071096423847");
      _points[13] = ct("0.2061797982465442035205615361806763255611921982131410801149830893137658110859778198204199473943617058");
      _weight[13] = ct("0.05646614804026960919670030371089215955713166606049735213629877312430656546180541682980244071408393247");
      _points[14] = ct("0.2653220810066214867968346445167968269523281044346317261019499851532114926571816930628014255887449256");
      _weight[14] = ct("0.06162618840525621214278049307740723597972249950248398621421098594256775139958772701589012301716629665");
      _points[15] = ct("0.7346779189933785132031653554832031730476718955653682738980500148467885073428183069371985744112550745");
      _weight[15] = ct("0.06162618840525621214278049307740723597972249950248398621421098594256775139958772701589012301721118318");
      _points[16] = ct("0.3290320895539578874209262897863101902204133504146563280015688081554932805464265186717208013164783515");
      _weight[16] = ct("0.06558675239353118536648249626515372293787094709401532656268985171227230515676448704571705001653997614");
      _points[17] = ct("0.6709679104460421125790737102136898097795866495853436719984311918445067194535734813282791986835216485");
      _weight[17] = ct("0.06558675239353118536648249626515372293787094709401532656268985171227230515676448704571705001654039024");
      _points[18] = ct("0.603930213344110642739423266959772867107837554548966824834326652184100420657358832108299412062849607");
      _weight[18] = ct("0.06827074917300758567628691561575869829318382649434308405473486746910377908226891669049531646614901666");
      _points[19] = ct("0.396069786655889357260576733040227132892162445451033175165673347815899579342641167891700587937150393");
      _weight[19] = ct("0.06827074917300758567628691561575869829318382649434308405473486746910377908226891669049531646614901691");
      _points[20] = ct("0.5348696366598611106069208980593140409111481497401157373533409732558046868163197230382591971852169272");
      _weight[20] = ct("0.06962593642781599668770512417090497893696010872871292906309893853651885640938429814937374841202945705");
      _points[21] = ct("0.4651303633401388893930791019406859590888518502598842626466590267441953131836802769617408028147830728");
      _weight[21] = ct("0.06962593642781599668770512417090497893696010872871292906309893853651885640938429814937374841202945706");
      break;

    // order 44,45
    case 44 :
    case 45 :
      delivered_order = 45;
      _points.resize(23);
      _weight.resize(23);
      _points[0] = ct("0.997384667498776061761962857722787180286813686229435210463396942083537039882892635091994572108193741");
      _weight[0] = ct("0.006705929743570886040654746729307532488309167052868616696197941069580443368026029924649341359469772762");
      _points[1] = ct("0.002615332501223938238037142277212819713186313770564789536603057916462960117107364908005427891809143873");
      _weight[1] = ct("0.006705929743570886040654746729307532488309167052868616696197941069580443368026029924649573769364960656");
      _points[2] = ct("0.01372876439094238402198796158961131240919310232301302875437192063210148141271179106629126712803738242");
      _weight[2] = ct("0.01549400292848972215534710982094225269188626449996403321744390329930889213143379600112464044475669166");
      _points[3] = ct("0.9862712356090576159780120384103886875908068976769869712456280793678985185872882089337087328719558227");
      _weight[3] = ct("0.01549400292848972215534710982094225269188626449996403321744390329930889213143379600112501966065445252");
      _points[4] = ct("0.9664855434130080511745984945192114891178509100756953853464506273009889144000435399565050359131567801");
      _weight[4] = ct("0.02401883586554233428582053581601699828060815415175580566684183343492904343740931457766543707359225583");
      _points[5] = ct("0.03351445658699194882540150548078851088214908992430461465354937269901108559995646004349496408684971031");
      _weight[5] = ct("0.02401883586554233428582053581601699828060815415175580566684183343492904343740931457766597672718701168");
      _points[6] = ct("0.06162382086477916631092155703292716418053548501967468254529944211972418064524202840071725243915325682");
      _weight[6] = ct("0.03211621070426292606358480757945549901957913787740341524767334102645877679039064170319606692512096974");
      _points[7] = ct("0.9383761791352208336890784429670728358194645149803253174547005578802758193547579715992827475608431633");
      _weight[7] = ct("0.03211621070426292606358480757945549901957913787740341524767334102645877679039064170319608117985608873");
      _points[8] = ct("0.09755579919058005392444079650161072102928493013484598870728378216414661991547532039245499830903712074");
      _weight[8] = ct("0.03964070588835947746144626237102161345685599596920325127781727016602150200687944126797677649047476588");
      _points[9] = ct("0.9024442008094199460755592034983892789707150698651540112927162178358533800845246796075450016909641157");
      _weight[9] = ct("0.03964070588835947746144626237102161345685599596920325127781727016602150200687944126797678878871689404");
      _points[10] = ct("0.8593306815659750972308122418743094241649648725656463978773906441070255643379628737551436279609732762");
      _weight[10] = ct("0.04645788303001757373850930868488232430173003587156494686632975230596864246779408039973782068126544426");
      _points[11] = ct("0.1406693184340249027691877581256905758350351274343536021226093558929744356620371262448563720390264527");
      _weight[11] = ct("0.04645788303001757373850930868488232430173003587156494686632975230596864246779408039973782150814728313");
      _points[12] = ct("0.1901950621181769218074513441752021733064096705964538521495672071954400967517765817297777471175290854");
      _weight[12] = ct("0.05244604573227070503704309250737192742923579159698750275141259616938968817102544494992821894515182282");
      _points[13] = ct("0.8098049378818230781925486558247978266935903294035461478504327928045599032482234182702222528824709511");
      _weight[13] = ct("0.05244604573227070503704309250737192742923579159698750275141259616938968817102544494992821895313919395");
      _points[14] = ct("0.7547507389230037748448965239334232152724213845924288116135946904106375025523832657533759938640108684");
      _weight[14] = ct("0.05749832011120568247082175646698065074570526146479280330453785170139979724187270361906533563745699839");
      _points[15] = ct("0.2452492610769962251551034760665767847275786154075711883864053095893624974476167342466240061359891292");
      _weight[15] = ct("0.05749832011120568247082175646698065074570526146479280330453785170139979724187270361906533563767227994");
      _points[16] = ct("0.3048494809848545842892555635596972707109745746537482593903973683416436919064837854106762368147562967");
      _weight[16] = ct("0.06152454215336476523378920033600482740792640627323528721783516645084523385389260275505301355895038264");
      _points[17] = ct("0.6951505190151454157107444364403027292890254253462517406096026316583563080935162145893237631852437032");
      _weight[17] = ct("0.06152454215336476523378920033600482740792640627323528721783516645084523385389260275505301355895211182");
      _points[18] = ct("0.6320678404851724652669347691416548014895066250970698024345394385261644267913360122890792643554668868");
      _weight[18] = ct("0.06445286109404107498929766969989682662985774859589174622217021585899473237800551787502302994595886119");
      _points[19] = ct("0.3679321595148275347330652308583451985104933749029301975654605614738355732086639877109207356445331132");
      _weight[19] = ct("0.06445286109404107498929766969989682662985774859589174622217021585899473237800551787502302994595887207");
      _points[20] = ct("0.4333715878507669445341286588791169314947973618733089217445273114064760550621727612127183682018242994");
      _weight[20] = ct("0.06623101970234830868582123235165846290251783473711176216125613401924300294133970283679005885397038903");
      _points[21] = ct("0.5666284121492330554658713411208830685052026381266910782554726885935239449378272387872816317981757006");
      _weight[21] = ct("0.06623101970234830868582123235165846290251783473711176216125613401924300294133970283679005885397038906");
      _points[22] = ct("0.5");
      _weight[22] = ct("0.06682728609305308767572855527292216929157640381844165874096798899572049042386144817957960350208853286");
      break;

    // order 46,47
    case 46 :
    case 47 :
      delivered_order = 47;
      _points.resize(24);
      _weight.resize(24);
      _points[0] = ct("0.9975936099985106800899987048503684059372988462980014387208002725571419160347288689416986446685566286");
      _weight[0] = ct("0.006170614899993599773402833535018645787955020445683258408643660470545862758940556895899243366671187447");
      _points[1] = ct("0.002406390001489319910001295149631594062701153701998561279199727442858083965271131058301355331443605634");
      _weight[1] = ct("0.006170614899993599773402833535018645787955020445683258408643660470545862758940556895899519911713663779");
      _points[2] = ct("0.987364277985654749099195996504084530870591526520089359905796782553590560640490112269318737140860893");
      _weight[2] = ct("0.01426569431446683159065390797593914322459889896595405830083240237882200281871457171284068800097932645");
      _points[3] = ct("0.01263572201434525090080400349591546912940847347991064009420321744640943935950988773068126285913870873");
      _weight[3] = ct("0.01426569431446683159065390797593914322459889896595405830083240237882200281871457171284165660291838644");
      _points[4] = ct("0.03086272399863362073817549914563927517259017096127432668248641204520525197373216452001767923206867783");
      _weight[4] = ct("0.02213871940870990308430137410566911442965642091692894837069861486051218814113321981719642280218335366");
      _points[5] = ct("0.969137276001366379261824500854360724827409829038725673317513587954794748026267835479982320767931424");
      _weight[5] = ct("0.02213871940870990308430137410566911442965642091692894837069861486051218814113321981719673619811954492");
      _points[6] = ct("0.05679223649779948289342282900890162245633347834553997981448104161216258280052041394793824900190687327");
      _weight[6] = ct("0.02964929245771839037318387925005429227060006328260674551868827564704915158875412078303371109763423013");
      _points[7] = ct("0.943207763502200517106577170991098377543666521654460020185518958387837417199479586052061750998093307");
      _weight[7] = ct("0.02964929245771839037318387925005429227060006328260674551868827564704915158875412078303438091669549109");
      _points[8] = ct("0.08999900701304853902302506366512739596193676116607220637800948699930851052322272995886973941370905738");
      _weight[8] = ct("0.03667324070554015286701680762655825905966825492424973570135124533002069423793546741616252879754303569");
      _points[9] = ct("0.9100009929869514609769749363348726040380632388339277936219905130006914894767772700411302605862907671");
      _weight[9] = ct("0.03667324070554015286701680762655825905966825492424973570135124533002069423793546741616257681394130904");
      _points[10] = ct("0.8700620957892771821219140515499892127616462435070927284331911841359501693204614662206656780655647523");
      _weight[10] = ct("0.04309508076597663795859260149187133359254029411896650279420357193064344223039026563444432705548550264");
      _points[11] = ct("0.1299379042107228178780859484500107872383537564929072715668088158640498306795385337793343219344353201");
      _weight[11] = ct("0.04309508076597663795859260149187133359254029411896650279420357193064344223039026563444432809380918206");
      _points[12] = ct("0.8240468259684877846262478934553738133348291493094783901494668325122241587842698859640588851828635455");
      _weight[12] = ct("0.04880932605205694413494033223212357721395948442684297204165530501147716928879598917401001997704509176");
      _points[13] = ct("0.175953174031512215373752106544626186665170850690521609850533167487775841215730114035941114817136438");
      _weight[13] = ct("0.04880932605205694413494033223212357721395948442684297204165530501147716928879598917401002003817914148");
      _points[14] = ct("0.7727107356944197678291878086091861850053919962938090877168071949152824195897854485479174337204031353");
      _weight[14] = ct("0.05372213505798281739128867122330311139731434506711001088327082044341093319721855299029336355911190586");
      _points[15] = ct("0.2272892643055802321708121913908138149946080037061909122831928050847175804102145514520825662795968657");
      _weight[15] = ct("0.05372213505798281739128867122330311139731434506711001088327082044341093319721855299029336356007551697");
      _points[16] = ct("0.7168967538130225692435421159566748562262107554639844040404006423283822035168154570288677152330378081");
      _weight[16] = ct("0.05775283402686280067667224195339177993113515568824823529222468004433512677565927497017212882338315957");
      _points[17] = ct("0.2831032461869774307564578840433251437737892445360155959595993576716177964831845429711322847669621927");
      _weight[17] = ct("0.05775283402686280067667224195339177993113515568824823529222468004433512677565927497017212882339235575");
      _points[18] = ct("0.3424786601519183128066033543400948796067608695875913656228849352350589218293782958280632452223958946");
      _weight[18] = ct("0.06083523646390169560223157673813121280351477960190288938873587725631269685885848095887890171538627273");
      _points[19] = ct("0.6575213398480816871933966456599051203932391304124086343771150647649410781706217041719367547776041053");
      _weight[19] = ct("0.06083523646390169560223157673813121280351477960190288938873587725631269685885848095887890171538658359");
      _points[20] = ct("0.5955594337368081545793199103785348159202025516573766780744592882940429763459358709912455556226048654");
      _weight[20] = ct("0.06291872817341414806068769125559184436320166279067270208904575844069693633333129844101908962821056986");
      _points[21] = ct("0.4044405662631918454206800896214651840797974483426233219255407117059570236540641290087544443773951346");
      _weight[21] = ct("0.06291872817341414806068769125559184436320166279067270208904575844069693633333129844101908962821056988");
      _points[22] = ct("0.5320284464313028130425215413123725192954995977103736967121755408948696417969550539014464380671262546");
      _weight[22] = ct("0.06396909767337607848702808261234768592585561977083394121064978818617379577026820120604598878336737117");
      _points[23] = ct("0.4679715535686971869574784586876274807045004022896263032878244591051303582030449460985535619328737454");
      _weight[23] = ct("0.06396909767337607848702808261234768592585561977083394121064978818617379577026820120604598878336737117");
      break;

    // order 48,49
    case 48 :
    case 49 :
      delivered_order = 49;
      _points.resize(25);
      _weight.resize(25);
      _points[0] = ct("0.9977784848952490489543924734469508086287813247024040856054024655664667406718639672436440131764693153");
      _weight[0] = ct("0.005696899250513143973951482056617386801660263146454848224474030558094945864883371677963556787448376476");
      _points[1] = ct("0.00222151510475095104560752655304919137121867529759591439459753443353325932813603275635598682353248497");
      _weight[1] = ct("0.005696899250513143973951482056617386801660263146454848224474030558094945864883371677965811475059758741");
      _points[2] = ct("0.01166803927024124425084230676020296612731472234279662766450628634191806623205972305177664525848306765");
      _weight[2] = ct("0.01317749330751606863095090764764957246798164085166123437768308289193546700443974968576767635766725226");
      _points[3] = ct("0.9883319607297587557491576932397970338726852776572033723354937136580819337679402769482233547415133449");
      _weight[3] = ct("0.01317749330751606863095090764764957246798164085166123437768308289193546700443974968577242932413311562");
      _points[4] = ct("0.9714872856144871697070055848292352659526007853044950709637262485686476612720246306544526090756260955");
      _weight[4] = ct("0.02046957835065315632781174385582297683042289168205217325234920744964871644010775638523527067391420037");
      _points[5] = ct("0.02851271438551283029299441517076473404739921469550492903627375143135233872797536934554739092437612273");
      _weight[5] = ct("0.02046957835065315632781174385582297683042289168205217325234920744964871644010775638524604173635510725");
      _points[6] = ct("0.05250400106086231557447899660859752291272257512320804846914915852041424454940027431440699653479712593");
      _weight[6] = ct("0.02745234798791759596296844577023666208005499277655567452425424912229688733921825594785529844095563499");
      _points[7] = ct("0.9474959989391376844255210033914024770872774248767919515308508414795857554505997256855930034652027271");
      _weight[7] = ct("0.02745234798791759596296844577023666208005499277655567452425424912229688733921825594785796307473275137");
      _points[8] = ct("0.9167213143804170007105105543467847847304820569117603930104323577308590662385450626266148697387927944");
      _weight[8] = ct("0.03401916690617845860359359282835398427735474717731828130753561320500182702585573655332580227175966452");
      _points[9] = ct("0.08327868561958299928948944565321521526951794308823960698956764226914093376145493737338513026120669813");
      _weight[9] = ct("0.03401916690617845860359359282835398427735474717731828130753561320500182702585573655332604122774719797");
      _points[10] = ct("0.1203703684813211847113585673978195118062389905508329395408051322774906855898687961961816013790731491");
      _weight[10] = ct("0.04007035016750050900661747983455565114511286642683794685810073148680641446740064477972868629207952781");
      _points[11] = ct("0.8796296315186788152886414326021804881937610094491670604591948677225093144101312038038183986209271367");
      _weight[11] = ct("0.04007035016750050900661747983455565114511286642683794685810073148680641446740064477972869753838111488");
      _points[12] = ct("0.1632168157632658177574396833761889120582916359636253414701715191108561315753578942090181571598454979");
      _weight[12] = ct("0.04551413099148182490574861035144582669049627947966715548524188448350869233920526345124219761526968488");
      _points[13] = ct("0.836783184236734182242560316623811087941708364036374658529828480889143868424642105790981842840154432");
      _weight[13] = ct("0.04551413099148182490574861035144582669049627947966715548524188448350869233920526345124219865109678983");
      _points[14] = ct("0.2111685348793885161381550791936729663021324803542408716772582461194884936236839888616417017671017262");
      _weight[14] = ct("0.05026797453352532210110344519634291349423304726407095353493452099970647407952301484097782805516032632");
      _points[15] = ct("0.7888314651206114838618449208063270336978675196457591283227417538805115063763160111383582982328982821");
      _weight[15] = ct("0.0502679745335253221011034451963429134942330472640709535349345209997064740795230148409778280886849818");
      _points[16] = ct("0.2634986342771425197389089424954039793340911307691863545463845861521983620793569849484215761086031856");
      _weight[16] = ct("0.05425981223713182655804697852505830967003879399336100807824715367441964639680422134669884175019772201");
      _points[17] = ct("0.7365013657228574802610910575045960206659088692308136454536154138478016379206430150515784238913968136");
      _weight[17] = ct("0.05425981223713182655804697852505830967003879399336100807824715367441964639680422134669884175027469118");
      _points[18] = ct("0.6805861529046939188679108650638203337110391735216875348972893889233726911978482743016476575304688072");
      _weight[18] = ct("0.05742912957285582416966277293477790432046809583409007479575749501574139833556271128267214949278988798");
      _points[19] = ct("0.319413847095306081132089134936179666288960826478312465102710611076627308802151725698352342469531193");
      _weight[19] = ct("0.05742912957285582416966277293477790432046809583409007479575749501574139833556271128267214949279150727");
      _points[20] = ct("0.6219334418604942160225951813987257932028165781629922382105678266251937363929279753398881838816251703");
      _weight[20] = ct("0.05972788176789238611408906325645052369508835070686321275979394066759204511009386751221434860487635927");
      _points[21] = ct("0.3780665581395057839774048186012742067971834218370077617894321733748062636070720246601118161183748297");
      _weight[21] = ct("0.05972788176789238611408906325645052369508835070686321275979394066759204511009386751221434860487637172");
      _points[22] = ct("0.5614323463053551981936799094040184027661026730248918692119467689463544174844292079132194249731655277");
      _weight[22] = ct("0.06112122149515502084447975947292575291752962378152952045379004111601948360959005121516770445539453314");
      _points[23] = ct("0.4385676536946448018063200905959815972338973269751081307880532310536455825155707920867805750268344723");
      _weight[23] = ct("0.06112122149515502084447975947292575291752962378152952045379004111601948360959005121516770445539453319");
      _points[24] = ct("0.5");
      _weight[24] = ct("0.06158802686335772560195143653952507121911681375907583269567609865845600397463071064230056258752479189");
      break;

    // order 50,51
    case 50 :
    case 51 :
      delivered_order = 51;
      _points.resize(26);
      _weight.resize(26);
      _points[0] = ct("0.002057149427191535498391520338546987021571072440220166301736095297216851683361096774046705971591914138");
      _weight[0] = ct("0.005275686308671503577825593842625988952172868589847307275027713818381611146754875672203017278562745882");
      _points[1] = ct("0.9979428505728084645016084796614530129784289275597798336982639047027831483166389032259532940283980829");
      _weight[1] = ct("0.005275686308671503577825593842625988952172868589847307275027713818381611146754875672222096535931991352");
      _points[2] = ct("0.9891927229782354955502901771559631527234582818736592512427074306582525753725062356694672106206098011");
      _weight[2] = ct("0.01220892554631595439480791375989420012024796309863517102602344753784585784943394482692276794975351226");
      _points[3] = ct("0.01080727702176450444970982284403684727654171812634074875729256934174742462749376433053278937941302212");
      _weight[3] = ct("0.01220892554631595439480791375989420012024796309863517102602344753784585784943394482692590062619002023");
      _points[4] = ct("0.9735795333308571250679576417590183772603551688421576350091338898049288222262304038853530988756546694");
      _weight[4] = ct("0.01898119164718138197515157062442524734538521087202447883765591232640395020816792394092103666682741212");
      _points[5] = ct("0.02642046666914287493204235824098162273964483115784236499086611019507117777376959611464690112432590056");
      _weight[5] = ct("0.01898119164718138197515157062442524734538521087202447883765591232640395020816792394092953156322980776");
      _points[6] = ct("0.9513189309921535371088327996156051256705620026864526862775828273897328995512729934288304151250970431");
      _weight[6] = ct("0.02548791264857390599915995036203668976293965927148596741191884299970865622501582259468003159778249186");
      _points[7] = ct("0.04868106900784646289116720038439487432943799731354731372241717261026710044872700657116958487490989121");
      _weight[7] = ct("0.02548791264857390599915995036203668976293965927148596741191884299970865622501582259469676675396512358");
      _points[8] = ct("0.07727702860575099060124646926608091921396244895433521528491176354419154266438185252492621891031580747");
      _weight[8] = ct("0.03163702316478741776972684495352254786111142100634725533304794330399419585613801383092451868449629648");
      _points[9] = ct("0.9227229713942490093987535307339190807860375510456647847150882364558084573356181474750737810896852668");
      _weight[9] = ct("0.0316370231647874177697268449535225478611114210063472553330479433039941958561380138309268591934534817");
      _points[10] = ct("0.1118070255896605719035163763788580665118908718724025639184157891864835356795866770152894361720024268");
      _weight[10] = ct("0.03734207488282987294353789805142416931937358094052034038951542087140981540468873148337639510000187901");
      _points[11] = ct("0.8881929744103394280964836236211419334881091281275974360815842108135164643204133229847105638279954159");
      _weight[11] = ct("0.03734207488282987294353789805142416931937358094052034038951542087140981540468873148337657126474272665");
      _points[12] = ct("0.8482136302099786324319069568647123489303766588954095758522787269191802734979190143979569224436633356");
      _weight[12] = ct("0.04252294715674261960522388253999084829196015838833913809302809070999389600765276409114327132632335978");
      _points[13] = ct("0.151786369790021367568093043135287651069623341104590424147721273080819726502080985602043077556337607");
      _weight[13] = ct("0.04252294715674261960522388253999084829196015838833913809302809070999389600765276409114329640288988689");
      _points[14] = ct("0.1966538534911909683840106265415564727823677138670450548106783437400359365548733997670835956949944863");
      _weight[14] = ct("0.04710690017795707423183244153365159927458287295710363993165745118401724964172710566666105228365478843");
      _points[15] = ct("0.8033461465088090316159893734584435272176322861329549451893216562599640634451266002329164043050053082");
      _weight[15] = ct("0.04710690017795707423183244153365159927458287295710363993165745118401724964172710566666105283897288388");
      _points[16] = ct("0.7542203574122528588478515323627845876881533770928754068605502348019636974646783451170112711373754115");
      _weight[16] = ct("0.05102958054721271161920703512671539616360440567712100516593690970432633440273700128534590714780195155");
      _points[17] = ct("0.2457796425877471411521484676372154123118466229071245931394497651980363025353216548829887288626246107");
      _weight[17] = ct("0.05102958054721271161920703512671539616360440567712100516593690970432633440273700128534590715187806242");
      _points[18] = ct("0.2984741224382568467594613114505584481700312951503419087054294332259078914763146734751210244027963381");
      _weight[18] = ct("0.0542359202642882953282897133639987911447191017106533222648028543047306996364527919847157957602897432");
      _points[19] = ct("0.7015258775617431532405386885494415518299687048496580912945705667740921085236853265248789755972036612");
      _weight[19] = ct("0.05423592026428829532828971336399879114471910171065332226480285430473069963645279198471579576032138823");
      _points[20] = ct("0.3539975802570215524285823089610848515576403065185048108938279040481491877109960462088021476536134262");
      _weight[20] = ct("0.05668090827315983327472035922129907262297518146250760699414396494374455328228972724632422646792560352");
      _points[21] = ct("0.6460024197429784475714176910389151484423596934814951891061720959518508122890039537911978523463865738");
      _weight[21] = ct("0.05668090827315983327472035922129907262297518146250760699414396494374455328228972724632422646792609764");
      _points[22] = ct("0.4115705898215549080154711257908276250113081180993678692598261501079773599722919564411924558682029493");
      _weight[22] = ct("0.05833022174264829102233125377018110681598244061096210823008134860563283296415986325634816982250102892");
      _points[23] = ct("0.5884294101784450919845288742091723749886918819006321307401738498920226400277080435588075441317970507");
      _weight[23] = ct("0.05833022174264829102233125377018110681598244061096210823008134860563283296415986325634816982250102892");
      _points[24] = ct("0.5296150467146566035468592875992016803951173676945177910771361458421935180599867101692053134428938839");
      _weight[24] = ct("0.05916070763963113825818554285023434232494513541445265904716009968981034737478143412042810703364070916");
      _points[25] = ct("0.4703849532853433964531407124007983196048826323054822089228638541578064819400132898307946865571061161");
      _weight[25] = ct("0.05916070763963113825818554285023434232494513541445265904716009968981034737478143412042810703364070916");
      break;

    // order 52,53
    case 52 :
    case 53 :
      delivered_order = 53;
      _points.resize(27);
      _weight.resize(27);
      _points[0] = ct("0.001910368555505716530556395809385004869655972217064406149181751605891127211337093955618976639176052996");
      _weight[0] = ct("0.004899498025647180130575027545629549049112909467545796084070202282931315208834056077691434852954585551");
      _points[1] = ct("0.9980896314444942834694436041906149951303440277829355938508182483941088727886629060443810233608259815");
      _weight[1] = ct("0.004899498025647180130575027545629549049112909467545796084070202282931315208834056077753240245468294788");
      _points[2] = ct("0.01003826201924938857206332216947640771617888930502461838057005347380871200989052684729151220284212677");
      _weight[2] = ct("0.01134311579809031159801710322338074440638386014408317781572106511953791501790501107707508572996524597");
      _points[3] = ct("0.9899617379807506114279366778305235922838211106949753816194299465261912879901094731527084877971586194");
      _weight[3] = ct("0.01134311579809031159801710322338074440638386014408317781572106511953791501790501107742569568707400832");
      _points[4] = ct("0.9754502789073525034259540153219414465462949667422088254669086953936933344049557428958097932983624977");
      _weight[4] = ct("0.01764852687870985551128914465235582056806944476147090579111389254745441331417783144208520625011731365");
      _points[5] = ct("0.02454972109264749657404598467805855345370503325779117453309130460630666559504425710419020670162446147");
      _weight[5] = ct("0.01764852687870985551128914465235582056806944476147090579111389254745441331417783144210401009766964174");
      _points[6] = ct("0.9547411603387455521503225091048446274740221677974804795566137762360281331762640112274766026251394194");
      _weight[6] = ct("0.02372470626030753135204835505709235911236281008309236425865500633458910592851796202108612874571502525");
      _points[7] = ct("0.04525883966125444784967749089515537252597783220251952044338622376397186682373598877252339737488204539");
      _weight[7] = ct("0.02372470626030753135204835505709235911236281008309236425865500633458910592851796202114102641702143869");
      _points[8] = ct("0.9281039540091472451513686113534213988821434993017529134885948270644016596929044902648783426521190244");
      _weight[8] = ct("0.02949176842991679955515041685976581658262029535320608127010760745691056483180227669210348485634524415");
      _points[9] = ct("0.07189604599085275484863138864657860111785650069824708651140517293559834030709550973512165734786335432");
      _weight[9] = ct("0.02949176842991679955515041685976581658262029535320608127010760745691056483180227669212110937924323569");
      _points[10] = ct("0.1041141804647458864278013279463646335402994671260682437963596939765897575631027349407405614340916029");
      _weight[10] = ct("0.03487441188312279649216144417833363806641234662847600018870939081052967940428179133628125012015134327");
      _points[11] = ct("0.8958858195352541135721986720536353664597005328739317562036403060234102424368972650592594385659169024");
      _weight[11] = ct("0.03487441188312279649216144417833363806641234662847600018870939081052967940428179133628233232240947058");
      _points[12] = ct("0.1414932631302881503525918941788302251246639739507184286743918968321525838419328333124890452720638476");
      _weight[12] = ct("0.03980243388652888563153747950492120148807333649350147570670438190137636322061009657571262463250792362");
      _points[13] = ct("0.8585067368697118496474081058211697748753360260492815713256081031678474161580671666875109547279336968");
      _weight[13] = ct("0.03980243388652888563153747950492120148807333649350147570670438190137636322061009657571264732060672834");
      _points[14] = ct("0.8164539859732475704638673188172443060515380087846683486475559495117003454985408900102633473248019569");
      _weight[14] = ct("0.04421157927187847509716140142687455552826837502554955490293556854829634959572854374441794903265292647");
      _points[15] = ct("0.1835460140267524295361326811827556939484619912153316513524440504882996545014591099897366526751984366");
      _weight[15] = ct("0.0442115792718784750971614014268745555282683750255495549029355685482963495957285437444179516937253006");
      _points[16] = ct("0.7702757822897284474501504707799914104795902244935908451871688750179704483581906127122403416472846593");
      _weight[16] = ct("0.04804436368501425378282632327905292958010581476851466721406555676700756739190327262980465263698979581");
      _points[17] = ct("0.2297242177102715525498495292200085895204097755064091548128311249820295516418093872877596583527153147");
      _weight[17] = ct("0.04804436368501425378282632327905292958010581476851466721406555676700756739190327262980465271829088215");
      _points[18] = ct("0.7205741258750134402929870778446407262238422975815496940726936067016003481397479590425318969605111507");
      _weight[18] = ct("0.05125081890887289933562385576633190466220494745735866493489091619149373974629794637200532992800577459");
      _points[19] = ct("0.2794258741249865597070129221553592737761577024184503059273063932983996518602520409574681030394888488");
      _weight[19] = ct("0.05125081890887289933562385576633190466220494745735866493489091619149373974629794637200532992840251648");
      _points[20] = ct("0.6679969518192544498651595171036422708950100094537970953624933535475046614272798926175690236905281402");
      _weight[20] = ct("0.05378914289426659360608149221332870240948304953188233275617945325759724607200991384577327794535374829");
      _points[21] = ct("0.3320030481807455501348404828963577291049899905462029046375066464524953385727201073824309763094718599");
      _weight[21] = ct("0.05378914289426659360608149221332870240948304953188233275617945325759724607200991384577327794535376847");
      _points[22] = ct("0.3867703172802315705713804463198849144102766335358981616766855014081114331134964348872204676390168474");
      _weight[22] = ct("0.05562624417842259633608154802142433741646019004254163354820175484896603913565917187623706977023691306");
      _points[23] = ct("0.6132296827197684294286195536801150855897233664641018383233144985918885668865035651127795323609831526");
      _weight[23] = ct("0.05562624417842259633608154802142433741646019004254163354820175484896603913565917187623706977023693234");
      _points[24] = ct("0.5569862928047649834664474919349883135866402669890704973828769548831827443942053726981897403198983148");
      _weight[24] = ct("0.05673817305448257431018497404604962896026225940523601294820827478851116979698381328179598174896188868");
      _points[25] = ct("0.4430137071952350165335525080650116864133597330109295026171230451168172556057946273018102596801016852");
      _weight[25] = ct("0.05673817305448257431018497404604962896026225940523601294820827478851116979698381328179598174896188868");
      _points[26] = ct("0.5");
      _weight[26] = ct("0.05711043368947849452252286845091762434036072167508266516087385828959706267057662605513742154892559577");
      break;

    // order 54,55
    case 54 :
    case 55 :
      delivered_order = 55;
      _points.resize(28);
      _weight.resize(28);
      _points[0] = ct("0.9982212487869772249752181952416554958750652160482129522928361647452421094805343626603577033042341754");
      _weight[0] = ct("0.004562141296547258869408076961475853120172245549145499708369845661949729932899064572236480217464936533");
      _points[1] = ct("0.001778751213022775024781804758344504124934783951787047707163835254757890519465637339642296695770837121");
      _weight[1] = ct("0.004562141296547258869408076961475853120172245549145499708369845661949729932899064572526563822056534335");
      _points[2] = ct("0.009348417314563623152720027096084861777922523373430845161987159270635774039111600249036536472313720156");
      _weight[2] = ct("0.01056605629638562987575019049663271722568467536164281889883424512553257787678854598195646787921082855");
      _points[3] = ct("0.9906515826854363768472799729039151382220774766265691548380128407293642259608883997509634635276713864");
      _weight[3] = ct("0.01056605629638562987575019049663271722568467536164281889883424512553257787678854598300882424950004705");
      _points[4] = ct("0.02287035968553090137294908014739220549829806295602416229264277568808467970208460056959184723562776574");
      _weight[4] = ct("0.01645071389115218998881540958526602299076540871004859392963081030188231834630637036053429300942080203");
      _points[5] = ct("0.9771296403144690986270509198526077945017019370439758377073572243119153202979153994304081527643931369");
      _weight[5] = ct("0.01645071389115218998881540958526602299076540871004859392963081030188231834630637036091886542410802276");
      _points[6] = ct("0.9578165131960660369348447116649635731762483976045607543307501223015040892535203600513990741767643359");
      _weight[6] = ct("0.0221364673795021139197939388266036953074970563542834218575735309421120888068499657459498897458583356");
      _points[7] = ct("0.0421834868039339630651552883350364268237516023954392456692498776984959107464796399486009258232168588");
      _weight[7] = ct("0.02213646737950211391979393882660369530749705635428342185757353094211208880684996574697771782818581975");
      _points[8] = ct("0.06705373871280247552887271631015659782906858460788683151122663349165279571743880703871341595766224915");
      _weight[8] = ct("0.02755367283785837271574145911347279560952898211283269420344637698647131160967129884318854047272566957");
      _points[9] = ct("0.9329462612871975244711272836898434021709314153921131684887733665083472042825611929612865840423488529");
      _weight[9] = ct("0.02755367283785837271574145911347279560952898211283269420344637698647131160967129884338434412610919579");
      _points[10] = ct("0.902820685458589585723942977712638829335850707404155834105343580890194771630436017399200517149107126");
      _weight[10] = ct("0.03263646198349979789669878338775231817681771558130351316774240907603844736949397023700131832114238009");
      _points[11] = ct("0.09717931454141041427605702228736117066414929259584416589465641910980522836956398260079948285088883028");
      _weight[11] = ct("0.03263646198349979789669878338775231817681771558130351316774240907603844736949397023700859662540316838");
      _points[12] = ct("0.8678054390068158860140722551462671840080305099965209466142638881679056292346650954667042208312744222");
      _weight[12] = ct("0.03732310711728438951196594358651101901081793060316672371966002810748192103268864967435680304363377329");
      _points[13] = ct("0.1321945609931841139859277448537328159919694900034790533857361118320943707653349045332957791687263386");
      _weight[13] = ct("0.0373231071172843895119659435865110190108179306031667237196600281074819210326886496743589656272682794");
      _points[14] = ct("0.8283255470194324806099490882533714107848008451249649809158517487479251504918128910941778006375064516");
      _weight[14] = ct("0.04155670861445060919519824912216623993056720672192566649817783586627122641301714237517143947408073117");
      _points[15] = ct("0.171674452980567519390050911746628589215199154875035019084148251252074849508187108905822199362493522");
      _weight[15] = ct("0.04155670861445060919519824912216623993056720672192566649817783586627122641301714237517145385645260117");
      _points[16] = ct("0.2151397640942991403459983583217845334376436571716763860899851611688926236813584997474581943081317975");
      _weight[16] = ct("0.04528587219651642047109301566839206491142874272724243618793426692722835773337135218283108917063664998");
      _points[17] = ct("0.7848602359057008596540016416782154665623563428283236139100148388311073763186415002525418056918681942");
      _weight[17] = ct("0.04528587219651642047109301566839206491142874272724243618793426692722835773337135218283109040639983369");
      _points[18] = ct("0.262062887522440869482794076166282978686391927310672024295443653528363812900513554436429402188325273");
      _weight[18] = ct("0.04846532899896495792524450304772030088251656167823080247843814090718469703877365354821424384893553832");
      _points[19] = ct("0.7379371124775591305172059238337170213136080726893279757045563464716361870994864455635705978116747257");
      _weight[19] = ct("0.04846532899896495792524450304772030088251656167823080247843814090718469703877365354821424385463743862");
      _points[20] = ct("0.688125758044539355110678604778043491435846988521611455172176360196915859421478201914138666867737561");
      _weight[20] = ct("0.05105648378903038490710831925285606752329000117896027046698772610142319921851682034903030485135373313");
      _points[21] = ct("0.3118742419554606448893213952219565085641530114783885448278236398030841405785217980858613331322624396");
      _weight[21] = ct("0.05105648378903038490710831925285606752329000117896027046698772610142319921851682034903030485137455679");
      _points[22] = ct("0.363969186182410961161586821937115132587619351653238523750162036748778829879543151606605536872026769");
      _weight[22] = ct("0.05302788296142320895520821849840541439496148134257975841531014814296125636970519336941207124174814022");
      _points[23] = ct("0.636030813817589038838413178062884867412380648346761476249837963251221170120456848393394463127973231");
      _weight[23] = ct("0.05302788296142320895520821849840541439496148134257975841531014814296125636970519336941207124174827441");
      _points[24] = ct("0.5822846410666903856407358889455827285728627078005840882471428133476659252378482239091221824898926037");
      _weight[24] = ct("0.05435559612914706762678575965183668393763922733302198382856058523865666319156439405412133157517785174");
      _points[25] = ct("0.4177153589333096143592641110544172714271372921994159117528571866523340747621517760908778175101073963");
      _weight[25] = ct("0.05435559612914706762678575965183668393763922733302198382856058523865666319156439405412133157517785209");
      _points[26] = ct("0.5275396449420171352132582636709399889253979955304168418726692936294472722671537883242063627327149899");
      _weight[26] = ct("0.05502350650823759814118813280090880697831276474561581663933405061480620506035357870344563338891741859");
      _points[27] = ct("0.4724603550579828647867417363290600110746020044695831581273307063705527277328462116757936372672850101");
      _weight[27] = ct("0.05502350650823759814118813280090880697831276474561581663933405061480620506035357870344563338891741859");
      break;

    // order 56,57
    case 56 :
    case 57 :
      delivered_order = 57;
      _points.resize(29);
      _weight.resize(29);
      _points[0] = ct("0.001660278869701706918404233725323057174113273374559998900921338121607207002790127831238018210105691685");
      _weight[0] = ct("0.004258451939373204827131906651124901501199444899259243026215047279732645793902882416561761178003708122");
      _points[1] = ct("0.9983397211302982930815957662746769428258867266254400010990786618783927929972098721687619817900013044");
      _weight[1] = ct("0.00425845193937320482713190665112490150119944489925924302621504727973264579390288241744535539018274769");
      _points[2] = ct("0.991272752630706587435463007893188478053390974453215779512560045723336292857815191776086317357309087");
      _weight[2] = ct("0.0098660425280613529919299008201978155748032840951807938280269223376721781694305564537882256883305202");
      _points[3] = ct("0.008727247369293412564536992106811521946609025546784220487439954276663707142184808223913682642415212693");
      _weight[3] = ct("0.00986604252806135299192990082019781557480328409518079382802692233767217816943055646072225404451223492");
      _points[4] = ct("0.02135720211095613710089598150958821813122022302295146471823518192332919792283790106899735207110017006");
      _weight[4] = ct("0.0153702461010468113222042626873083748735581304843547551610421796831758162179478083469863767119774409");
      _points[5] = ct("0.9786427978890438628991040184904117818687797769770485352817648180766708020771620989310026479292115706");
      _weight[5] = ct("0.01537024610104681132220426268730837487355813048435475516104217968317581621794780836139798196132962266");
      _points[6] = ct("0.03940988352347060745312328195844678729558032834385320076550426809702499335777486268074240653069993902");
      _weight[6] = ct("0.02070103125934141805241500505703846076674539019428719862896243971739621852818551853953495319631759502");
      _points[7] = ct("0.9605901164765293925468767180415532127044196716561467992344957319029750066422251373192575934690763516");
      _weight[7] = ct("0.02070103125934141805241500505703846076674539019428719862896243971739621852818551853984171415670102727");
      _points[8] = ct("0.06268109753994860479110328937171072654469156844047931463638958564262908145684442658053764847935897777");
      _weight[8] = ct("0.02579741345124896195629719058977129895981105532307103384093141566365206014644921025462052127950351516");
      _points[9] = ct("0.9373189024600513952088967106282892734553084315595206853636104143573709185431555734194623515207548012");
      _weight[9] = ct("0.02579741345124896195629719058977129895981105532307103384093141566365206014644921025527067660590528598");
      _points[10] = ct("0.09090725619237377750521389271060751218498921905885311443148286385234173733221244639847037110258048705");
      _weight[10] = ct("0.0306015453285395692710549240119535224620322698895651041589387060559972220376777554907964141556590276");
      _points[11] = ct("0.9090927438076262224947861072893924878150107809411468855685171361476582626677875536015296288973760434");
      _weight[11] = ct("0.03060154532853956927105492401195352246203226988956510415893870605599722203767775549082120815892355311");
      _points[12] = ct("0.8762314258672385669563050386060690951062959841144933042059989957623460653588429567443031613856582753");
      _weight[12] = ct("0.03505896662752563928479074347443958655119744433738679095740371243000397857149125882037553337678302389");
      _points[13] = ct("0.1237685741327614330436949613939309048937040158855066957940010042376539346411570432556968386143545099");
      _weight[13] = ct("0.03505896662752563928479074347443958655119744433738679095740371243000397857149125882037823722445054435");
      _points[14] = ct("0.1608927311986567424219074973040070368058685349926774186380950705253167483999159884580950739648692351");
      _weight[14] = ct("0.03911916356788189191407244432984016568343953847983485473378759766238027210361614738466142952885046597");
      _points[15] = ct("0.8391072688013432575780925026959929631941314650073225813619049294746832516000840115419049260351279701");
      _weight[15] = ct("0.03911916356788189191407244432984016568343953847983485473378759766238027210361614738466173188057738515");
      _points[16] = ct("0.7981408985691139101897931055944948900390934051927888192367311966151714169808699492956273492244185209");
      _weight[16] = ct("0.04273612868308626377267242464860403569084912830679669766094537169121599627783617681021242154028807844");
      _points[17] = ct("0.2018591014308860898102068944055051099609065948072111807632688033848285830191300507043726507755818786");
      _weight[17] = ct("0.042736128683086263772672424648604035690849128306796697660945371691215996277836176810212423235581571");
      _points[18] = ct("0.753796477562113821051313959813760076675611920192292082092532153549107183181318411159590233645317137");
      _weight[18] = ct("0.04586887856962938167398320553855540344911451049097728563791493734934686215774724755050591362461630883");
      _points[19] = ct("0.2462035224378861789486860401862399233243880798077079179074678464508928168186815888404097663546828384");
      _weight[19] = ct("0.04586887856962938167398320553855540344911451049097728563791493734934686215774724755050591365107221208");
      _points[20] = ct("0.2934235559129956680546467069841915883382807406318430401108076673728583268940136014749802695368964944");
      _weight[20] = ct("0.04848191704720430315095003744134437958817813896090178213024773337311643895088929114457563589694005033");
      _points[21] = ct("0.7065764440870043319453532930158084116617192593681569598891923326271416731059863985250197304631035028");
      _weight[21] = ct("0.04848191704720430315095003744134437958817813896090178213024773337311643895088929114457563589714280829");
      _points[22] = ct("0.6570158189338199674740979615955237241292244095454137406483794654472233487147167212702577337526900784");
      _weight[22] = ct("0.0505456368799574830609102734537486818237836394262625995614160116528885101846129027944658327169071752");
      _points[23] = ct("0.3429841810661800325259020384044762758707755904545862593516205345527766512852832787297422662473099228");
      _weight[23] = ct("0.05054563687995748306091027345374868182378363942626259956141601165288851018461290279446583271690743738");
      _points[24] = ct("0.6056761430830005372531878644514687495283254088560475740192004226610294555540058890492892141022582066");
      _weight[24] = ct("0.05203665503886468695666423564256003445532611033773384582184702707394015054274691957461250068566735182");
      _points[25] = ct("0.3943238569169994627468121355485312504716745911439524259807995773389705444459941109507107858977417932");
      _weight[25] = ct("0.05203665503886468695666423564256003445532611033773384582184702707394015054274691957461250068566737544");
      _points[26] = ct("0.5531391150663396150854911962151884904585977196478035681428876370110826718757923204715022303102827086");
      _weight[26] = ct("0.05293807754866047070329566392609394653741565687113901991407767276251131908456972819198550959864424907");
      _points[27] = ct("0.4468608849336603849145088037848115095414022803521964318571123629889173281242076795284977696897172914");
      _weight[27] = ct("0.05293807754866047070329566392609394653741565687113901991407767276251131908456972819198550959864424907");
      _points[28] = ct("0.5");
      _weight[28] = ct("0.05323969085915712212325556345483878416509251580649798987648645053394066246579319242238732282325525218");
      break;

    // order 58,59
    case 58 :
    case 59 :
      delivered_order = 59;
      _points.resize(30);
      _weight.resize(30);
      _points[0] = ct("0.9984467420373247701358150254593476416704410190588753950540471489011938476050818704079410097787617413");
      _weight[0] = ct("0.003984096248083302807732941737336811225240348293575860614742581678460019216450666634479433344457437239");
      _points[1] = ct("0.001553257962675229864184974540652358329558980941124604945952851098806152394918129592058990221182733242");
      _weight[1] = ct("0.003984096248083302807732941737336811225240348293575860614742581678460019216450666642188026814968437855");
      _points[2] = ct("0.008165938360126395014983709197168599029841072645144318241409994924427852317604478148962014169242317633");
      _weight[2] = ct("0.009233234155545479571151065956023634548103266984090701685649182757292799760653986755450699432333341509");
      _points[3] = ct("0.9918340616398736049850162908028314009701589273548556817585900050755721476823955218510379858309033031");
      _weight[3] = ct("0.009233234155545479571151065956023634548103266984090701685649182757292799760653986815792453169513453224");
      _points[4] = ct("0.0199890675158462438915644872091011685348203912980383002571691637875300211464657853864052781488233464");
      _weight[4] = ct("0.01439235394166168467485958980564602181979444727314374823709006130407299447000696654140593213314494214");
      _points[5] = ct("0.9800109324841537561084355127908988314651796087019616997428308362124699788535342146135947218510085378");
      _weight[5] = ct("0.01439235394166168467485958980564602181979444727314374823709006130407299447000696660670929023709229111");
      _points[6] = ct("0.03689997628536283706033786145976299795676273158733546954448143316028850217444883659161355992412324619");
      _weight[6] = ct("0.01939959628481352479840096822317384601660048838319767605386639485297348547638489696037231540825839766");
      _points[7] = ct("0.9631000237146371629396621385402370020432372684126645304555185668397114978255511634083864400759978334");
      _weight[7] = ct("0.01939959628481352479840096822317384601660048838319767605386639485297348547638489696454661377310503722");
      _points[8] = ct("0.9412802678960263407715582312651127950283445735732421160341630265608081313475958278646079191424468346");
      _weight[8] = ct("0.02420133641529702645146907021140375890763590459868636817259596839590271283855107639963466400268558322");
      _points[9] = ct("0.05871973210397365922844176873488720497165542642675788396583697343919186865240417213539208085749427117");
      _weight[9] = ct("0.02420133641529702645146907021140375890763590459868636817259596839590271283855107640314816261043103779");
      _points[10] = ct("0.0852171188086158012785509401337490417804656519148291605965235082731717467052091824585237782457661204");
      _weight[10] = ct("0.02874657810880953324086084470102806439856033536088156727435789950161607370497718846308085054974539156");
      _points[11] = ct("0.9147828811913841987214490598662509582195343480851708394034764917268282532947908175414762217542537747");
      _weight[11] = ct("0.02874657810880953324086084470102806439856033536088156727435789950161607370497718846308397388938158375");
      _points[12] = ct("0.8838887160524130974589886704872515658474418086164542266032471936825792850864975225263048012930588557");
      _weight[12] = ct("0.03298711494109024756406425755798118061872147682833018948351575802107183623304708968291271722923362495");
      _points[13] = ct("0.1161112839475869025410113295127484341525581913835457733967528063174207149135024774736951987069361996");
      _weight[13] = ct("0.03298711494109024756406425755798118061872147682833018948351575802107183623304708968296127720974999476");
      _points[14] = ct("0.8489252473966578984661461940133200341911769003269773281898614233699883606215799803476908182200597426");
      _weight[14] = ct("0.03687798736885260313412192501109536707688526301852471947063459118729969965731760585520115159405834797");
      _points[15] = ct("0.1510747526033421015338538059866799658088230996730226718101385766300116393784200196523091817799413847");
      _weight[15] = ct("0.03687798736885260313412192501109536707688526301852471947063459118729969965731760585520211743210103565");
      _points[16] = ct("0.1897369085053785694297612217844053503963176535852359337024744149378323425125554411294237077723385906");
      _weight[16] = ct("0.04037794761471010767734746923026486543794640185421964994512929685302559028351317280210616346488849335");
      _points[17] = ct("0.8102630914946214305702387782155946496036823464147640662975255850621676574874445588705762922276610945");
      _weight[17] = ct("0.0403779476147101076773474692302648654379464018542196499451292968530255902835131728021061872309781039");
      _points[18] = ct("0.7683120740710099496320848966555363970820890034651485527263717414560074543094891893155705800485953387");
      _weight[18] = ct("0.04344989360054148990119376535756285128837666437177267200611106494107679112713074712397751617336896013");
      _points[19] = ct("0.2316879259289900503679151033444636029179109965348514472736282585439925456905108106844294199514047477");
      _weight[19] = ct("0.04344989360054148990119376535756285128837666437177267200611106494107679112713074712397751721923776294");
      _points[20] = ct("0.723516884769044588390304950161427000081203796930712204877238690863807675864292103502003444360620908");
      _weight[20] = ct("0.0460612611188930643588163535438093835984566172091170537638375235009865235350470841492320264444094193");
      _points[21] = ct("0.2764831152309554116096950498385729999187962030692877951227613091361923241357078964979965556393790769");
      _weight[21] = ct("0.04606126111889306435881635354380938359845661720911705376383752350098652353504708414923202646065604094");
      _points[22] = ct("0.6763523627654390567355186035446869303268155040107128132970922344501347081165955393321801983760567682");
      _weight[22] = ct("0.04818436858732212981973431317590493254820323071508012295649713786641876737100156186247562390896992009");
      _points[23] = ct("0.3236476372345609432644813964553130696731844959892871867029077655498652918834044606678198016239432329");
      _weight[23] = ct("0.04818436858732212981973431317590493254820323071508012295649713786641876737100156186247562390902385435");
      _points[24] = ct("0.6273184630839449232199025649089025539413946516512592130821429875444817657845394014531831406921181011");
      _weight[24] = ct("0.04979671029339763353139014105178473826493463183335213861068257309197333019495440450904614964466218078");
      _points[25] = ct("0.3726815369160550767800974350910974460586053483487407869178570124555182342154605985468168593078818989");
      _weight[25] = ct("0.04979671029339763353139014105178473826493463183335213861068257309197333019495440450904614964466224146");
      _points[26] = ct("0.4230650431957082265181026636283720397907240143778307691405185085421064257445919493015384467446296072");
      _weight[26] = ct("0.05088119487420275229821447608427702231635314474356342043213047270982125680265883747273799890989195542");
      _points[27] = ct("0.5769349568042917734818973363716279602092759856221692308594814914578935742554080506984615532553703928");
      _weight[27] = ct("0.0508811948742027522982144760842770223163531447435634204321304727098212568026588374727379989098919558");
      _points[28] = ct("0.5257359212776588479165126065833612868745707268332847821275804219939823776052135545279350453536427429");
      _weight[28] = ct("0.05142632644677942017064281835270752193418777853246411129315949333800811932830471469631442316094435458");
      _points[29] = ct("0.4742640787223411520834873934166387131254292731667152178724195780060176223947864454720649546463572571");
      _weight[29] = ct("0.05142632644677942017064281835270752193418777853246411129315949333800811932830471469631442316094435458");
      break;

    // order 60,61
    case 60 :
    case 61 :
      delivered_order = 61;
      _points.resize(31);
      _weight.resize(31);
      _points[0] = ct("0.001456259090261462972186722888448745874277332941465184603938140536671727639569783488828314396257689635");
      _weight[0] = ct("0.003735415789624387929348437516106203511075426242024019849635485164339136550087160836353011312030814283");
      _points[1] = ct("0.9985437409097385370278132771115512541257226670585348153960618594633282723604302165111716856051244182");
      _weight[1] = ct("0.003735415789624387929348437516106203511075426242024019849635485164339136550087160845587137141720281039");
      _points[2] = ct("0.9923429548325762420012325833673423554692591347573218354728643296977299769442723637440437229734679307");
      _weight[2] = ct("0.008659310395155291231578998043410570683136431383997888316377591894405077207572920934503029106477412167");
      _points[3] = ct("0.00765704516742375799876741663265764453074086524267816452713567030227002305572763625595627702295878941");
      _weight[3] = ct("0.008659310395155291231578998043410570683136431383997888316377591894405077207572921233026982288499865862");
      _points[4] = ct("0.981251962546474830894526202052929150948609742576279188386675678514985989965298058276482183478766264");
      _weight[4] = ct("0.01350450959248971090030435404596607807117832300105832292843737492363504441243640114529650286166003484");
      _points[5] = ct("0.01874803745352516910547379794707084905139025742372081161332432148501401003470194172351781652525371484");
      _weight[5] = ct("0.01350450959248971090030435404596607807117832300105832292843737492363504441243640179017013630612728352");
      _points[6] = ct("0.9653784989483240824784728798646317564066988436290410182276681875953414709211815171232175381609787332");
      _weight[6] = ct("0.01821613695619273201219600523390172116357266602383384295070951969816670398426204512121133695127756726");
      _points[7] = ct("0.03462150105167591752152712013536824359330115637095898177233181240465852907881848287678246183624739291");
      _weight[7] = ct("0.01821613695619273201219600523390172116357266602383384295070951969816670398426204520325386329727057047");
      _points[8] = ct("0.9448800149741355216870960044910796307717987059325954748815660279630855009680425324985645588464641407");
      _weight[8] = ct("0.02274685376360055145115792894731483863177635965501448244675831806076219499563510508340775276693803594");
      _points[9] = ct("0.05511998502586447831290399550892036922820129406740452511843397203691449903195746750143544115477625997");
      _weight[9] = ct("0.02274685376360055145115792894731483863177635965501448244675831806076219499563510512478069813822093218");
      _points[10] = ct("0.9199601600731336700434522679700891780273686505373747614156803069474734141326785555328494277978334248");
      _weight[10] = ct("0.0270515412124584268558331295433100213601947312981059038470039105256499515290323858014887309311220587");
      _points[11] = ct("0.08003983992686632995654773202991082197263134946262523858431969305252658586732144446715057220183028104");
      _weight[11] = ct("0.02705154121245842685583312954331002136019473129810590384700391052564995152903238580263298133541309537");
      _points[12] = ct("0.1091334257916875297968199899026577544522948139933005599675624686482212483980791531009348949654394841");
      _weight[12] = ct("0.03108739328051421345517177184334833357936439968232565764075375266574554731138425888082085196543468197");
      _points[13] = ct("0.8908665742083124702031800100973422455477051860066994400324375313517787516019208468990651050345943823");
      _weight[13] = ct("0.03108739328051421345517177184334833357936439968232565764075375266574554731138425888130083816054638221");
      _points[14] = ct("0.1421116077065733580470145673167570220549032619152057836859458771974568631244629034775778924291043132");
      _weight[14] = ct("0.03481429161770518308387806312756285525754285369867169685553635851837134563893470805502034184209715985");
      _points[15] = ct("0.8578883922934266419529854326832429779450967380847942163140541228025431368755370965224221075709079774");
      _weight[15] = ct("0.03481429161770518308387806312756285525754285369867169685553635851837134563893470805507043833071976983");
      _points[16] = ct("0.1786466385378698269077908983837492730041546583318966217453477017619332973797433691655777512192607888");
      _weight[16] = ct("0.03819519329938830821317883745066532246287845684710432704609504082320412596697428296745119702124533426");
      _points[17] = ct("0.8213533614621301730922091016162507269958453416681033782546522982380667026202566308344222487807324943");
      _weight[17] = ct("0.03819519329938830821317883745066532246287845684710432704609504082320412596697428296745132284385085426");
      _points[18] = ct("0.2183754192964253686395275382024192860256988634165564845071156081562723096081775797374572902948126088");
      _weight[18] = ct("0.0411964958807946319519116837159808853078841332783231389051919621253154333232668202076256025443723746");
      _points[19] = ct("0.7816245807035746313604724617975807139743011365834435154928843918437276903918224202625427097051892246");
      _weight[19] = ct("0.04119649588079463195191168371598088530788413327832313890519196212531543332326682020762560352392116962");
      _points[20] = ct("0.2609031089775487597797029803217571257802383142512884375809194745004315606814533610283708215805617322");
      _weight[20] = ct("0.04378837030423893806309903484766654611462907988560212575177060598456271225204984948183410913304042932");
      _points[21] = ct("0.7390968910224512402202970196782428742197616857487115624190805254995684393185466389716291784194379161");
      _weight[21] = ct("0.04378837030423893806309903484766654611462907988560212575177060598456271225204984948183410923826059577");
      _points[22] = ct("0.3058070491958835284693242693562399490074468660532279821210935607641609639146006582516778301944404148");
      _weight[22] = ct("0.04594505694682073910768143580357506274865541268957890208924280825212435217371207403383186527240141105");
      _points[23] = ct("0.6941929508041164715306757306437600509925531339467720178789064392358390360853993417483221698055596242");
      _weight[23] = ct("0.04594505694682073910768143580357506274865541268957890208924280825212435217371207403383186527340160378");
      _points[24] = ct("0.3526409650091491916910480511641478306235724073608207215318520588819652150614509044215928373785823166");
      _weight[24] = ct("0.04764512145615975640360209874379834227066236912347951135572473296423440281824639506062046299784091323");
      _points[25] = ct("0.6473590349908508083089519488358521693764275926391792784681479411180347849385490955784071626214176832");
      _weight[25] = ct("0.04764512145615975640360209874379834227066236912347951135572473296423440281824639506062046299784199497");
      _points[26] = ct("0.5990605996677853143862064980164169688873974060807774399934011271280026030023023224343955099764932203");
      _weight[26] = ct("0.04887166769316436254673700548949835191786439433804755725475732225072623157354002120950387583890250572");
      _points[27] = ct("0.4009394003322146856137935019835830311126025939192225600065988728719973969976976775656044900235067797");
      _weight[27] = ct("0.0488716676931643625467370054894983519178643943380475572547573222507262315735400212095038758389025195");
      _points[28] = ct("0.5497776560761707601625873950594703669194976793887636530301135454886349377647980330327888590157321036");
      _weight[28] = ct("0.04961250561333615393743775721430750700877160997778153489060157125773453723517885216715386205370758322");
      _points[29] = ct("0.4502223439238292398374126049405296330805023206112363469698864545113650622352019669672111409842678964");
      _weight[29] = ct("0.04961250561333615393743775721430750700877160997778153489060157125773453723517885216715386205370758326");
      _points[30] = ct("0.5");
      _weight[30] = ct("0.04986027239671322571376691686717471982162670575010217574280728978204640605537343723220456872105070443");
      break;

    default :
      DUNE_THROW(QuadratureOrderOutOfRange, "Quadrature rule " << p << " not supported!");
    }
  }


  template<typename ct>
  GaussQuadratureRule<ct,1>::GaussQuadratureRule (int p)
      : QuadratureRule<ct,1>(GeometryTypes::line)
  {
    //! set up quadrature of given order in d dimensions
    std::vector< FieldVector<ct,1> > _points;
    std::vector< ct > _weight;

    int deliveredOrder_;

    GaussQuadratureInitHelper<ct>::init(p, _points, _weight, deliveredOrder_);

    this->delivered_order = deliveredOrder_;
    assert(_points.size() == _weight.size());
    for (size_t i = 0; i < _points.size(); i++)
      this->push_back(QuadraturePoint<ct,1>(_points[i], _weight[i]));
  }

} // namespace Dune

#endif // DUNE_GEOMETRY_QUADRATURE_Gauss_HH
